#############################################################################
##
#A  util.g              CHEVIE library          Meinolf Geck, Frank L\"ubeck, 
#A                                               Jean Michel, G\"otz Pfeiffer
##
#A  $Id: util.g,v 1.1 1997/01/21 13:46:35 gap Exp $
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, IWR
#Y  der Universit\"at Heidelberg, University of St. Andrews, and   University 
#Y  Paris VII.
##
##  This file contains routines of general utility which have been
##  developed during the writing of the chevie package. These routines
##  should really put into some other part of the GAP library, they
##  have nothing specific to Coxeter groups.
##

InductionTableOps:=OperationsRecord("InductionTableOps");

InductionTableOps.Print:=
   function(t)Print("InductionTable( ",t.u,", ",t.g,")");end;

InductionTableOps.Display:=function(arg)
  local  t, r, arr, max, li, l, k, br, mbr, PrintArr;

  t:=ShallowCopy(arg[1]);
  if Length(arg)=2 then
    r:=arg[2];
  else
    r:=rec();
  fi;
  
  if IsBound(r.charsGroup) then
    t.scalar:=t.scalar{r.charsGroup};
    t.charGroup:=t.charGroup{r.charsGroup};
  fi;
  if IsBound(r.charsSubgroup) then
    t.scalar:=t.scalar{[1..Length(t.scalar)]}{r.charsSubgroup};
    t.charSubgroup:=t.charSubgroup{r.charsSubgroup};
  fi;
  
  PrintArr:=function(arr)
    local l, k;
    for l  in [ 1 .. Length( arr ) ]  do
	if l = 2  then
	    Print( String(List([1..br+1],i->'_')),"\n");
	fi;
        Print( String( arr[l][1], -max[li[1]]+1)," |");
	for k  in [ 2 .. Length( arr[l] ) ]  do
	    Print( String( arr[l][k], max[li[k]] ) );
	od;
        Print("\n");
    od;
  end;
  
  if IsBound(t.headString) then 
    Print(t.headString);
  fi;
  arr := [Concatenation([" "],t.charSubgroup)];
  Append(arr,List( [1..Length(t.scalar)], function ( x )
          return Concatenation([t.charGroup[x]],List( t.scalar[x], 
                             function(a) 
                               if a=0 then return "."; 
                               else return String(a);fi;end ));
      end ));
  max :=List( TransposedMat(arr), function ( x )
            return Maximum( List( x, LengthString ) );
        end )+1;
  mbr:=SizeScreen()[1]-2;

  k:=3;
  br:=max[1]+max[2];
  li:=[1,2];  
  while k<=Length(max) do
    if br+max[k]<mbr then
      br:=br+max[k];
      Add(li,k);
    else
      PrintArr(arr{[1..Length(arr)]}{li});
      Print("\n");
      br:=max[1]+max[k];
      li:=[1,k];
    fi;
    k:=k+1;
  od;
  if li<>[1] then
    PrintArr(arr{[1..Length(arr)]}{li});
    Print("\n");
  fi;
end;

############################################################################
##
#F  InductionTable( <u>, <g> ) . . . . . . . . . . . decomposition of induced 
#F  characters 
##  
##  Let <u>  be  a subgroup of  <g>.   'InductionTable'  returns a  record
##  describing  the  decomposition of  the  irreducible  characters of <u>
##  induced to <g>.
##  
##  The result can be displayed using 'Display'.
##  
##  In fact this function also works for Coxeter cosets.
##  
InductionTable:=function(u,g)
  local tr,ti,h,g,erg;
  tr:=CharTable(u);
  ti:=CharTable(g);
  StoreFusion(tr,ti,FusionConjugacyClasses(u,g));
  erg:= rec(scalar:=MatScalarProducts(tr,tr.irreducibles,
                                  Restricted(ti,tr,ti.irreducibles)));
  erg.u:=u;
  erg.g:=g;
  if IsBound(tr.irredinfo) then
    erg.charSubgroup:=List(tr.irredinfo,a->a.charname);
  else
    erg.charSubgroup:=List([1..Length(tr.irreducibles)],
                        i->String(Concatenation("X.",String(i))));
  fi;
  if IsBound(ti.irredinfo) then
    erg.charGroup:=List(ti.irredinfo,a->a.charname);
  else
    erg.charGroup:=List([1..Length(ti.irreducibles)],
                        i->String(Concatenation("X.",String(i))));
  fi;
  
  # special code for Coxeter groups or cosets:
  if (IsBound(erg.u.isCoxeterGroup) and IsBound(erg.g.isCoxeterGroup)) or
     (IsBound(erg.u.isCoxeterCoset) and IsBound(erg.g.isCoxeterCoset)) then
    erg.headString:=String(Concatenation("Induction from ",CartanName(erg.u),
                            " into ",CartanName(erg.g),"\n"));
  fi;
  
  erg.operations:=InductionTableOps;
  return erg;
end;

#############################################################################
##
#F  CharRepresentationWords(<rep>,<elts>) . . . . character of representation 
#F  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  on words
##  
##  <rep> is a list of matrices representing images of generators,
##  <elts> a list of words in the generators.  Returns the character on <elts>.
## 
CharRepresentationWords:=function(rep,elts)
  return List(elts,function(e)
    if e=[] then return Length(rep[1]);
    else return TraceMat(Product(rep{e}));
    fi;
    end);
end;

#############################################################################
##
#F  DecomposedMat( <mat> ) . . . . . . . . . Find if the square matrix mat
#F  admits a block decomposition.
##  
##  Define a graph G with vertices [1..Length(mat)] and with an edge
##  between i and j if either mat[i][j] or mat[j][i] is non-zero.
##  DecomposedMat return a list of lists l such that l[1],l[2], etc..
##  are the vertices in each connected component of G. In other words,
##  mat{l[1]}{l[1]},mat{l[2]}{l[2]},etc... are blocks of the matrix mat
## 
DecomposedMat:=function(M)
  local l, i, j, k, cl, ci, cj, erg;
  l:=Length(M);
  
  # cl contains numbers for the equivalence classes, first
  # each element forms a class:
  cl:=[1..l];
  for i in [1..l] do
    for j in [i+1..l] do
      # if new relation i~j and classes are different then join classes:
      if (M[i][j]<>0 or M[j][i]<>0) and cl[i]<>cl[j] then
        ci:=cl[i]; cj:=cl[j];
        for k in [1..l] do
          if cl[k]=cj then
            cl[k]:=ci;
          fi;
        od;
      fi;
    od;
  od;
  
  # extract the classes from information in cl:
  erg:=[];
  for i in [1..l] do
    if IsBound(erg[cl[i]]) then
      AddSet(erg[cl[i]],i);
    else
      erg[cl[i]]:=[i];
    fi;
  od;
  return Set(erg);
end;


#############################################################################
##
#F  SublistUnbnd( <l>, <ind> ) . . . . . . . . . Sublist of a list with
#F  possibly unbound entries.
##  
## The writing of this function was prompted by the fact that if l has some
## unbound entries, l{ind} returns an error message instead of doing what is
## expected (which is what this routine does). Maybe this should be changed?
##
SublistUnbnd:=function(l,ind)local res,i;
  res:=[];
  for i in [1..Length(ind)] do
    if IsBound(l[ind[i]]) then res[i]:=l[ind[i]];fi;
  od;
  return res;
  end;

#############################################################################
##
#F  DirectSumMat( <mat1>,...,<matn> )  or
#F  DirectSumMat( [<mat1>,...,<matn>])  direct sum of   Matrices
##
##  'DirectSumMat' returns the block diagonal direct sum of the  
##  matrices <mat1>  ... <matn> (which can be rectangular or empty).
##
DirectSumMat := function (arg) local  c,r,res,m,f;
  if Length(arg)=1 and not IsMat(arg[1]) then arg:=arg[1];fi;
  f:=function(m)if Length(m)=0 then return 0; else return Length(m[1]);fi;end;
  res:=NullMat(Sum(arg,Length),Sum(arg,f));
  r:=0;c:=0;
  for m in arg do
    res{r+[1..Length(m)]}{c+[1..f(m)]}:=m;
    r:=r+Length(m);
    c:=c+f(m);
  od;
  return res;
end;

#############################################################################
##
#F  IsLowerTriangularMat( <mat> ) . . . . . true if  <mat> is lower triangular
#F  IsDiagonalMat( <mat> ) . . . . . . . . . . . .  true if <mat> is diagonal
##  
IsLowerTriangularMat:=function(A)
  local n, i, j, erg;
  n:=Length(A);
  for i in [1..n-1] do
    for j in [i+1..n] do
      if A[i][j]<>0*A[i][j] then
        return false;
      fi;
    od;
  od;
  return true;
end;  

IsDiagonalMat:=function(M)
  local i, j;
  if Length(M)=0 then return true; fi;
  for i in [1..Length(M)] do
    for j in [1..Length(M[1])] do
      if i<>j and M[i][j]<>0*M[i][j] then
        return false;
      fi;
    od;
  od;
  return true;
end;

##############################################################################
# 'Value' function for polynomials represented as
#   [ vector of coefficients, valuation]
#
# This function is used in particular for char. tables of Hecke algebras of
# type En, Hn. This seems to be the best "Value" function because many entries
# are sparse polynomials:
#
FastValue:=function(f,x)
  local  val, i, p;
  if IsPolynomial(x) and x=Indeterminate(x.baseRing) then
      return Polynomial(x.baseRing,f[1],f[2]);
  fi;
  if f[1]=[] then
    return 0*x;
  fi;
  val:=0*x;
  p:=f[2];
  for i in f[1] do
    if i<>0 then
      val:=val+i*x^p;
    fi;
    p:=p+1;  
  od;
  return val;
end;

#############################################################################
##
#F  IntListToString( <part>, [<brackets>] ) . . . . . . . . as the name says
##  
##  <part> must be a list of positive integers. If all of them are smaller
##  than 10 then a string of digits corresponding to the entries of <part>
##  is returned.  If   an entry is >=10  then  the elements of <part>  are
##  converted to   strings, concatenated  with  separating commas  and the
##  result surrounded by brackets:
##  
##     [4,2,2,1,1]   --->    "42211"
##     [14,2,2,1,1]  --->    "(14,2,2,1,1)"
##  
IntListToString:=function(arg)
  local s, digits,brackets,p;
  p:=arg[1];
  if Length(arg)=2 then brackets:=arg[2];else brackets:="()";fi;
  digits:="0123456789";
  if ForAll(p,x->x<10) then
    return String(digits{1+p});
  else
    s:= Concatenation(List(p,x->Concatenation(String(x),",")));
    s:=Concatenation([brackets[1]],s);
    s[Length(s)]:=brackets[2];
    return String(s);
  fi;
end;

#############################################################################
##
#F  IsNormalizing( <lst>, <mat> ) . . . . . . . true if matrix <mat> lets
#F  set <lst> of vectors invariant
##  
IsNormalizing:=function(l,M)
  return Set(l*M)=Set(l);
end;

#############################################################################
##
#F  PointsAndRepresentativesOrbits( <g>[, <m>] ) . . . . . . orbits of points 
#F  under permutation group <g>
##  
##  <g>  must  be  a permutation  group.   'PointAndRepresentativesOrbits'
##  returns a  list [orb,rep].  Here  orb is  a list  of the <g>-orbits on
##  [1..LargestMovedPoint(<g>)] or,  if  given, [1..<m>].  rep[i][j] is an
##  element of <g>, such that orb[i][1]^rep[i][j] = orb[i][j].
##  
##  ??? better to give list of points instead of <m> ???
PointsAndRepresentativesOrbits:=function ( arg )
  local  G, orbs, orb, max, g, gs, new, gen, Ggen, p, pnt, fst, img;
  G:=arg[1];

  if Length(arg)>1 then
    max:=arg[2];
  else
    max := PermGroupOps.LargestMovedPoint(G);
  fi;

  Ggen:=G.generators;
  new := BlistList( [ 1 .. max ], [ 1 .. max ] );
  orbs := [  ];
  gs:=[];
  fst := 1;
  while fst <> false  do
      orb := [ fst ];
      g:=[()];
      new[fst] := false;
      p:=1;
      while p<=Length(orb)  do
	  for gen  in Ggen  do
	      img := orb[p] ^ gen;
	      if new[img]  then
		  Add( orb, img );
		  Add(g,g[p]*gen);
		  new[img] := false;
	      fi;
	  od;
	  p:=p+1;
      od;
      Add( orbs, orb );
      Add( gs, g );
      fst := Position( new, true, fst );
  od;
  return [orbs,gs];
end;

############################################################################
# EigenvaluesMat: eigenvalues of a matrix over the cyclotomics of finite order
#            (actually it is also allowed for mat to have some 0 eigenvalues)
#
EigenvaluesMat:=function(mat)local p,eigenvalues,i,x;
  p:=FieldMatricesOps.CharacteristicPolynomial(FieldMatrices,mat);
  eigenvalues:=[1..p.valuation]*0;
  p:=Polynomial(Cyclotomics,p.coefficients,0);
  i:=1;
  while Degree(p)>0 do
    for x in PrimeResidues(i) do
      while Value(p,E(i)^x)=0 do
        Add(eigenvalues,E(i)^x);
        p:=p/(X(Cyclotomics)-E(i)^x);
      od;
    od;
    i:=i+1;
  od;
  return eigenvalues;
end;
