#############################################################################
##
#A  weyl2a.g             CHEVIE library                         Frank Luebeck
##
#A  $Id: weyl2a.g,v 1.1 1997/01/21 13:46:43 gap Exp $
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, IWR
#Y  der Universit\"at Heidelberg, University of St. Andrews, and   University 
#Y  Paris VII.
##

CHEVIE.2A:=rec();

CHEVIE.2A.PositionId:=function(n) return Length(Partitions(n+1)); end;
 
CHEVIE.2A.PositionSgn:=function(n) return 1; end;
 
CHEVIE.2A.PositionRefl:=function(n) return Length(Partitions(n+1))-1; end;


#############################################################################
##
#F  CHEVIE.2A.ClassInfo( <n> ) . . . . . . . . . . conjugacy classes for type A
##  
##  'CHEVIE.2A.ClassInfo' returns a record with three components:
##    classtext:   representatives of minimal length in  the  conjugacy  
##                 classes, as words in generators in standard order
##    classparams:  partitions, parameterizing the classes
##    classnames:  strings for partitions
##  
##  The  ordering  corresponds  to the  order of  the columns of the ordinary
##  character table of the symmetric  group $S_{n+1}$, as returned by the GAP
##  function 'CharTable("Symmetric", <n+1>)'.
##  
CHEVIE.2A.ClassInfoOld:=function(n)
    local  i, lwort, res;
    
    # longest element of the Coxeter group:
    lwort:=[];
    for i in [n,n-1..1] do 
      Append(lwort,[1..i]);
    od;
    
    res:=CHEVIE.A.ClassInfo(n);
    res.classtext:=List(res.classtext,a->Concatenation(a,lwort));
    
    return res;
end;

CHEVIE.2A.ClassInfo:=function(n)
  local guesslongest, w, x, i, l, pi, res;
  
  guesslongest:=function(n,ps)
    local redw, w0, l, p, pp, off, res;

    # make word from permutation:
    redw:=function(n,w)
      local i,l;
      l:=[];
      while true  do
        i := 0;
        repeat
          if i>=n then return l;fi;
          i := i + 1;
        until i^w>(i+1)^w;
        Add( l, i );
        w := (i,i+1) * w;
      od;
      return l;
    end;

    l:=[];
    w0:=();
    for p in [1..Int((n+1)/2)] do
      Append(l,[p,n-p+2]);
      w0:=w0*(p,n-p+2);
    od;
    if n mod 2 =0 then Add(l,p+1); fi;

    res:=[];
    for p in ps do
      pp:=Concatenation(Filtered(p,i->i mod 2=0),
                      Filtered(p,i->i<>1 and i mod 2=1));
      x:=();
      off:=0;
      for i in pp do
        x:=x*Product(List([2..i],j->(l[off+1],l[off+j])));
        off:=off+i;
      od;
      Add(res,redw(n,x*w0));
    od;
    return res;
  end;
  
  res:= rec(classparams:=Partitions(n+1));
  res.classnames:=List(res.classparams,IntListToString);
  res.classtext:=guesslongest(n,res.classparams);
  
  return res;
end;

##  _checkshortest:=function(w,x)
##    local l, p, els;
##    l:=Length(x);
##    p:=PermCoxeterWord (w,x)/LongestCoxeterElement(w);
##    els:=Elements(ConjugacyClass(w,p))*LongestCoxeterElement(w);
##    return ForAll(els,p->CoxeterLength(w,p)>=l);
##  end;



#############################################################################
##
#F  ClassParam2A( <n>, <w> )  . . . . . . . . . . . . . class parameter of w
##
##  given an element w  of a Coxeter group W of type A_n  as word in  standard
##  generators,  'ClassParam2A' returns the  classparams of its F-conjugacy
##  class under the nontrivial F action permuting the generators.
##
CHEVIE.2A.ClassParam:=function(n, w)
  local i, j, x, res, mark, cyc;
  
  x:=();
  for i in w do
    x:=x*(i,i+1);
  od;
  
  # shifting from w_0 class to conjugacy class:
  for i in [1..QuoInt(n+1,2)] do
    x:=x*(i,n+2-i);
  od;
  
  res:=[];
  mark:=[1..n+1];
  for i in [1..n+1] do
    if mark[i]<>0 then
      cyc:=CyclePermInt(x,i);
      Add(res,Length(cyc));
      for j in cyc do
        mark[j]:=0;
      od;
    fi;
  od;
  
  Sort(res);
  
  return Reversed(res);
end;

CHEVIE.2A.CharParams:=n->Partitions(n+1);
CHEVIE.2A.CharName:=IntListToString;

#############################################################################
##
#F  CHEVIE.2A.CharTable( <l> ) outer character table of CoxeterGroup("A",l).2
##  
##  This function returns the part of the character table of 
##  CoxeterGroup("A",l).2  on the outer classes of CoxeterGroup("A",l). For 
##  each character of CoxeterGroup("A",l) there are two extensions  to the 
##  whole group. 'CharTable2A'  gives the  values  of the  *preferred* 
##  extensions defined  in [CS,17.2, case A_l].
##    
CHEVIE.2A.CharTable:=function(r)
  local aphi, i, tmp, tbl;
  
  # [LuB, 4.19] Preferred extension: -1 acts on \tilde E where E corresponds
  # to partition p by (-1)^aphi(p)
  aphi:=function(p)
    return Sum(List(AssociatedPartition(p),i->i*(i-1)/2));
  end;
  
  tbl:=CoxeterCharTableIrred("A",[1..r]);
  tbl.identifier:=String(Concatenation("W(^2A",String(r),")"));
  for i in [1..Length(tbl.irreducibles)] do
    tbl.irreducibles[i]:=(-1)^aphi(tbl.irredinfo[i].charparam)
                         *tbl.irreducibles[i];
  od;
  
  tmp:=CHEVIE.2A.ClassInfo(r);
  tbl.classtext:=tmp.classtext;
  tbl.classnames:=tmp.classnames;
  tbl.classparam:=tmp.classparams;
  
  return tbl;
end;

CHEVIE.2A.HeckeCharTable:=function(r,sqq)local W,phi,WF,qE,H,tbl,tmp,i,cl;
  W:=CoxeterGroup("A",r);
  if r=1 then phi:=();
  else phi:=Product([1..QuoInt(r,2)],i->(i,r+1-i));
  fi;
  WF:=CoxeterCoset(W,phi);
# If q_E is the square root which deforms to 1 of the eigenvalue of T_{w_0}
# on E which deforms to 1, then we have:
#  E~(T_w\phi)=\overline(E(T_{w^-1w_0}))q_E (trivial extension)
#  E~(T_w\phi)=(-1)^a_E\overline(E(T_{w^-1w_0}))q_E (preferred extension)
# where \overline means q->q^-1
  qE:=HeckeCentralMonomials(Hecke(W,sqq));
  H:=Hecke(W,sqq^-2);
  tbl:=ShallowCopy(CharTable(H));
  tmp:=CHEVIE.2A.ClassInfo(r);
  tbl.classtext:=tmp.classtext;
  tbl.classnames:=tmp.classnames;
  tbl.classparam:=tmp.classparams;
  tbl.identifier:=String(Concatenation("H(^2A",String(r),")"));
  cl:=List(tbl.classtext,x->PermCoxeterWord (W,x)*LongestCoxeterElement(W));
  tbl.irreducibles:=TransposedMat(List(cl,x->HeckeCharValues(Basis(H,"T")(x))));
  for i in [1..Length(tbl.irreducibles)] do
    tbl.irreducibles[i]:=(-1)^Sum(List(AssociatedPartition(
       tbl.irredinfo[i].charparam[1]),i->i*(i-1)/2))*qE[i]*tbl.irreducibles[i];
  od;
  return tbl;
end;

CHEVIE.2A.PhiFactors:=n->List([2..n+1],x->(-1)^x);
