#############################################################################
##
#A  weyl2d.g         CHEVIE library                             Frank Luebeck
##
#A  $Id: weyl2d.g,v 1.1 1997/01/21 13:46:44 gap Exp $
##
##                      preliminary version 
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, IWR
#Y  der Universit\"at Heidelberg, University of St. Andrews, and   University 
#Y  Paris VII.
##

CHEVIE.2D:=rec();
if not IsBound(CHEVIE.B) then ReadChv("tbl/weylb");fi;

#############################################################################
##
#F  CHEVIE.2D.ClassInfo( <n> ) . . . . . . . . . conjugacy classes for type 2D
##  
##  'CHEVIE.2D.ClassInfo' returns a record with three components:
##    classtext:   representatives of minimal length in  the  conjugacy  
##                 classes, as words in generators in standard order
##    classparams:  partitions, parameterizing the classes
##    classnames:  strings for partitions
##  
##  
##  Here we parametrize the F-conjugacy  classes by the *outer* classes in
##  the  corresponding Coxeter group of type  B_n. If n is  odd then it would
##  also be possible to parametrize  them by the  conjugacy classes in the
##  Coxeter group of type D_n (you get the F-conjugacy classes by translation
##  with the  longest element), because W(B_n) is  isomorphic to  W(D_n) x
##  C_2 in this case. This gives two possible labelings of the F-conjugacy
##  classes: one with the labels of the  inner and one  with the labels of
##  the outer classes. They correspond in the following way: Let [a,b] the
##  double  partition    for an  inner  class   of   W(D_n) and   let  the
##  multiplication  with the longest element  of W(B_n) lead  to the outer
##  class with double partition [c,d]. Then c contains the even entries of
##  a and the  odd entries of b and  d contains the  even entries of b and
##  the odd entries of a.
##  
CHEVIE.2D.ClassInfo:=function ( n )
  local  z, l, part, i, j, p, reps, w, a, hifu, res;
  
  # substitute appearance of generator '1' in type "B" by [1,2,1,1,2],
  # then subword [1,2,1] is generator '1' in type "D":
  hifu:=function(l1)
    local i,l,ll,a;
    l:=Copy(l1);
    ll:=[];
    i:=1;
    while i <= Length(l) do
      if l[i]=1 then
        if l[i+1]=1 then
          i:=i+2;
        elif l[i+1]=2 and l[i+2]=1 then
          Add(ll,1);
          i:=i+3;
        elif l[i+1]>2 then
          Add(ll,l[i+1]);
          l[i+1]:=1;
          i:=i+1;
        else
          Add(ll,1);
          l[i+1]:=1;
          i:=i+1;
        fi;
      else
        Add(ll,l[i]);
        i:=i+1;
      fi;
    od;
    return ll;
  end;
  
  # representatives for type "B":
  part := PartitionTuples( n, 2 );
  reps := [  ];
  for p  in part  do
      p[2] := Reversed( p[2] );
      w := [  ];
      i := 1;
      for l  in p[2]  do
          for j  in [ 1 .. i ]  do
              Add( w, i + 1 - j );
          od;
          for j  in [ 2 .. i ]  do
              Add( w, j );
          od;
          i := i + 1;
          z := 1;
          while z < l  do
              Add( w, i );
              z := z + 1;
              i := i + 1;
          od;
      od;
      i := i + 1;
      for l  in p[1]  do
          z := 1;
          while z < l  do
              Add( w, i );
              z := z + 1;
              i := i + 1;
          od;
          i := i + 1;
      od;
      p[2] := Reversed( p[2] );
      Add( reps, [ w, p ] );
  od;
  
  # outer classes for subgroup of type "D":
  reps:=Filtered(reps,a->Length(a[2][2]) mod 2 = 1);
  for a in reps do
    Add(a[1],1);
  od;
  reps:=List(reps,a->[hifu(a[1]),a[2]]);
  
  res:=rec(classtext:=[],
           classnames:=[],
           classparams:=[]);
  
  for a in reps do
    Add(res.classtext,a[1]);
    Add(res.classparams,a[2]);
    Add(res.classnames,DoublePartitionToString(a[2]));
  od;
  
  return res;
end;

#############################################################################
##
#F  CHEVIE.2D.ClassParam( <n>, <w> ) . . . . . . . . . class parameter of w
##  
##  given an element w  of a Coxeter group W of type D  as word in  standard
##  generators,  'CHEVIE.2D.ClassParam' returns the classparam of its 
##  F-conjugacy  class under the nontrivial F action permuting the first two 
##  generators.
##  
CHEVIE.2D.ClassParam:=function(n,w)
  local x, i, res, mark, cyc, j;
  
  x:=();
  for i in w do
    if i=1 then x:=x*(1,n+2)(2,n+1); else x:=x*(i-1,i)(i-1+n,i+n);fi;
  od;
  
  # now shifting in the coset:
  x:=x*(1,n+1);
  
  res:=[[],[]];
  mark:=[1..n];
  for i in [1..n] do
    if mark[i]<>0 then
      cyc:=CyclePermInt(x,i);
      if i+n in cyc then
        Add(res[2],Length(cyc)/2);
      else
        Add(res[1],Length(cyc));
      fi;
      for j in cyc do
        if j>n then
          mark[j-n]:=0;
        else
          mark[j]:=0;
        fi;
      od;
    fi;
  od;
  
  Sort(res[1]);
  Sort(res[2]);
  return [Reversed(res[1]),Reversed(res[2])];
end;

# test if a character of W(B) corresponds to the preferred extension
# for ^2D, see [CS,17.2] and [Lusztig-book,4.4,4.18]:
CHEVIE.2D.IsPreferred:=function(pp)
  local A,B;
  A:=Concatenation([0],Reversed(pp[1]));
  A:=A+[0..Length(A)-1];
  B:=Concatenation([0],Reversed(pp[2]));
  B:=B+[0..Length(B)-1];
  while Length(A)>Length(B) do
    B:=Concatenation([0],B+[1..Length(B)]);
  od;
  while Length(B)>Length(A) do
    A:=Concatenation([0],A+[1..Length(A)]);
  od;
  return B<A;
end;

# test if a character of W(B) corresponds to the "good" extension
CHEVIE.2D.IsGood:=function(pp)
      return pp[1]>pp[2];
end;  

CHEVIE.2D.testchar:=CHEVIE.2D.IsPreferred;

CHEVIE.2D.CharParams:=function(n)
  return Filtered(CHEVIE.Load("B",n).CharParams(n),CHEVIE.2D.testchar);
end;

CHEVIE.2D.PositionId:=function(n)
  return Length(CHEVIE.2D.CharParams(n));
end;
 
CHEVIE.2D.PositionSgn:=function(n) return 1; end;
 
CHEVIE.2D.PositionRefl:=function(n)
  return Length(CHEVIE.2D.CharParams(n))-1;
end;
 

CHEVIE.2D.CharName:=DoublePartitionToString;

#############################################################################
##
#F  CHEVIE.2D.CharTable( <l> ) outer character table of CoxeterGroup("D",l).2
##  
##  This function returns  the part of the character table the Coxeter group
##  of  type B_l on classes  outside a reflection subgroup  of  type D_l for 
##  the characters which  remain irreducible  on restriction to  this subgroup
##  and which   correspond   to the   *preferred* extensions    defined in
##  [CS,17.2, case D_l].
##  
##  Alternatively you can get the  *good* extension instead of *preferred*
##  extension by giving setting CHEVIE.2D.testchar:=CHEVIE.2D.IsGood.
##  
CHEVIE.2D.CharTable:=function(l)
  local l, hi, tbl, i, lst, lst2, p, sy, cli,test;
  
  hi:=CharTable("WeylB",l);
  cli:=CHEVIE.2D.ClassInfo(l);
  lst:=Filtered([1..Length(hi.classparam)], 
                                  i->Length(hi.classparam[i][2][2]) mod 2=1);
  tbl:=rec(identifier:=String(Concatenation("W(^2D",String(l),")")));
  tbl.size:=hi.size/2;
  tbl.centralizers:=hi.centralizers{lst}/2;
  tbl.orders:=hi.orders{lst};
  tbl.classparam:=cli.classparams;
  tbl.classtext:=cli.classtext;
  tbl.classnames:=cli.classnames;
  tbl.classes:=hi.classes{lst};
  tbl.text:="extracted from generic character table of type B";
  tbl.operations:=CharTableOps;
  sy:=List(hi.irredinfo,a->a.charparam[2]);
  lst2:=Filtered([1..Length(sy)],i->CHEVIE.2D.testchar(sy[i]));
  tbl.irredinfo:=List(hi.irredinfo{lst2},a->rec(charparam:=a.charparam[2],
                                charname:=CHEVIE.2D.CharName(a.charparam[2])));
  tbl.irreducibles:=hi.irreducibles{lst2}{lst};
  return tbl;
end;

CHEVIE.2D.HeckeCharTable:=function(l,q)local W,H,hi,cli,lst,tbl,sy,lst2,test;
  hi:=CHEVIE.B.HeckeCharTable(l,[q^0,q]);
  cli:=CHEVIE.2D.ClassInfo(l);
  lst:=Filtered([1..Length(hi.classparam)], 
                                  i->Length(hi.classparam[i][2]) mod 2=1);
  tbl:=rec(identifier:=String(Concatenation("H(^2D",String(l),")")),
           size:=hi.size/2,
           orders:=hi.orders{lst},
           centralizers:=hi.centralizers{lst}/2,
	   classparam:=cli.classparams,
	   classtext:=cli.classtext,
	   classnames:=cli.classnames,
	   classes:=hi.classes{lst},
           text:="extracted from generic character table of HeckeB",
           operations:=CharTableOps);
  lst2:=Filtered([1..Length(hi.irredinfo)],
                 i->CHEVIE.2D.testchar(hi.irredinfo[i].charparam));
  tbl.irredinfo:=List(hi.irredinfo{lst2},a->rec(charparam:=a.charparam,
                         charname:=CHEVIE.2D.CharName(a.charparam)));
  cli:=List(cli.classtext,x->Concatenation([1],Concatenation(List(x,
	function(y)if y=1 then return [1,2,1];else return [y];fi;end))));
  H:=Basis(Hecke(CoxeterGroup("B",l),Concatenation([q^0],List([1..l-1],x->q))),"T");
  tbl.irreducibles:=TransposedMat(List(cli,
      x->HeckeCharValues(H(x),hi.irreducibles{lst2})));
  return tbl;
end;

CHEVIE.2D.PhiFactors:=function(n)local res;
  res:=List([1..n],x->1);
  res[QuoInt(n+1,2)]:=-1;
  return res;
end;
