#############################################################################
##
#A  weyle6.g                  CHEVIE library                     Meinolf Geck
##
#A  $Id: weyle6.g,v 1.1 1997/01/21 13:46:50 gap Exp $
##
#Y  Copyright (C) 1992 - 1996  Lehrstuhl D f\"ur Mathematik, RWTH Aachen, IWR
#Y  der Universit\"at Heidelberg, University of St. Andrews, and   University 
#Y  Paris VII.
##
##  This file contains the character table of the Hecke algebras of type E6.
##

CHEVIE.E6:=rec();

CHEVIE.E6.classtext:=
[ [ ], [ 3, 4, 3, 2, 4, 3, 5, 4, 3, 2, 4, 5 ], [ 1, 4 ], 
  [ 1, 3, 1, 4, 3, 1, 2, 4, 5, 4, 3, 1, 2, 4, 3, 5, 6, 5, 4, 3, 2, 4, 5, 6 ], 
  [ 1, 3 ], [ 1, 3, 5, 6 ], [ 3, 4, 3, 2, 4, 5 ], [ 1, 4, 3, 6 ], 
  [ 1, 4, 3, 2 ], [ 1, 2, 3, 1, 5, 4, 6, 5, 4, 2, 3, 4 ], [ 3, 4, 2, 5 ], 
  [ 1, 2, 3, 4, 2, 3, 4, 6, 5, 4, 2, 3, 4, 5 ], [ 1, 3, 2, 5 ], 
  [ 1, 3, 4, 3, 2, 4, 5, 6 ], [ 1, 4, 6, 2, 3, 5 ], [ 1 ], [ 1, 4, 6 ], 
  [ 1, 3, 4, 3, 2, 4, 3, 5, 4, 3, 2, 4, 5 ], [ 1, 4, 3 ], [ 1, 3, 2 ], 
  [ 1, 3, 2, 5, 6 ], [ 1, 4, 6, 3, 5 ], [ 1, 3, 4, 2, 5 ], 
  [ 1, 4, 3, 2, 6 ], [ 1, 4, 2, 5, 4, 2, 3 ] ];

CHEVIE.E6.classnames:=[ " ", "4A_1", "2A_1", "3A_2", "A_2", "2A_2", "D_4(a_1)", 
  "A_3+A_1", "A_4", "E_6(a_2)", "D_4", "A_5+A_1", "A_2+2A_1", 
  "E_6(a_1)", "E_6", "A_1", "3A_1", "A_3+2A_1", "A_3", "A_2+A_1", 
  "2A_2+A_1", "A_5", "D_5", "A_4+A_1", "D_5(a_1)" ];

#how to make a .charname from a .charparam
CHEVIE.E6.CharName:=x->String(Concatenation("phi_{",String(x[1]),
                                        ",",String(x[2]),"}"));

CHEVIE.E6.CharParams:=function()
  return [[1, 0 ],[ 1, 36 ],[ 10, 9 ] , [ 6, 1 ],  [ 6, 25 ],
  [ 20, 10 ],  [ 15, 5 ], [ 15, 17 ],  [ 15, 4 ], [ 15, 16 ],  [ 20, 2 ],
  [ 20, 20 ],  [ 24, 6 ], [ 24, 12 ],  [ 30, 3 ], [ 30, 15 ],  [ 60, 8 ],
  [ 80, 7 ],  [ 90, 8 ], [ 60, 5 ],  [ 60, 11 ], [ 64, 4 ],  [ 64, 13 ],
  [ 81, 6 ] ,  [ 81, 10 ]];
end;

CHEVIE.E6.frame:=
[ "1_p", "1_p'", "10_s", "6_p", "6_p'", "20_s", "15_p", "15_p'", "15_q", 
  "15_q'", "20_p", "20_p'", "24_p", "24_p'", "30_p", "30_p'", "60_s", "80_s", 
  "90_s", "60_p", "60_p'", "64_p", "64_p'", "81_p", "81_p'" ];

CHEVIE.E6.cyclestructure:=[ [  ], [ 36 ], [ 30 ], [ , 24 ], [ , 20 ], 
  [ , 22 ], [ ,, 18 ], [ 5,, 15 ], 
  [ ,,, 14 ], [ ,,,, 12 ], [ 6,,,, 10 ], [ 3,,,, 11 ], [ 6, 4,,, 8 ], 
  [ ,,,,,,, 8 ], [ ,,,,,,,,,, 6 ], 
  [ 21 ], [ 35 ], [ 6,, 15 ], [ 4,, 15 ], 
  [ 3, 8,,, 6 ], [ 3, 10,,, 6 ], [ 2,,,, 11 ], [ ,,,,,, 9 ], 
  [ 1,,, 6,,,,, 4 ], [ ,, 3,, 2,,,,,, 4 ] ];

CHEVIE.E6.generators:=
[ ( 1,37)( 3, 7)( 9,12)(13,17)(15,18)(19,22)(21,23)(24,26)(25,27)(28,30)
  (31,33)(39,43)(45,48)(49,53)(51,54)(55,58)(57,59)(60,62)(61,63)(64,66)
  (67,69), ( 2,38)( 4, 8)
  ( 9,13)(10,14)(12,17)(15,19)(16,20)(18,22)(21,25)
  (23,27)(35,36)(40,44)(45,49)(46,50)(48,53)(51,55)(52,56)(54,58)(57,61)
  (59,63)(71,72), ( 1, 7)
  ( 3,39)( 4, 9)( 8,13)(10,15)(14,19)(16,21)(20,25)
  (26,29)(30,32)(33,34)(37,43)(40,45)(44,49)(46,51)(50,55)(52,57)(56,61)
  (62,65)(66,68)(69,70), ( 2, 8)
  ( 3, 9)( 4,40)( 5,10)( 7,12)(11,16)(19,24)
  (22,26)(25,28)(27,30)(34,35)(38,44)(39,45)(41,46)(43,48)(47,52)(55,60)
  (58,62)(61,64)(63,66)(70,71), 
  ( 4,10)( 5,41)( 6,11)( 8,14)( 9,15)(12,18)
  (13,19)(17,22)(28,31)(30,33)(32,34)(40,46)(42,47)(44,50)(45,51)(48,54)
  (49,55)(53,58)(64,67)(66,69)
  (68,70), ( 5,11)( 6,42)(10,16)(14,20)(15,21)
  (18,23)(19,25)(22,27)
  (24,28)(26,30)(29,32)(41,47)(46,52)(50,56)(51,57)
  (54,59)(55,61)(58,63)(60,64)(62,66)(65,68) ];

CHEVIE.E6.cartan:=[ [ 2, 0, -1, 0, 0, 0 ], [ 0, 2, 0, -1, 0, 0 ], 
  [ -1, 0, 2, -1, 0, 0 ], [ 0, -1, -1, 2, -1, 0 ], 
  [ 0, 0, 0, -1, 2, -1 ], [ 0, 0, 0, 0, -1, 2 ] ];

CHEVIE.E6.powermap:= [ , [ 1, 1, 1, 4, 5, 6, 2, 3, 9, 4, 5, 6, 5, 14, 10, 1,
  1, 3, 3, 5, 6, 6, 7, 9, 13 ], 
  [ 1, 2, 3, 1, 1, 1, 7, 8, 9, 2, 2, 2, 3, 4, 7, 16, 17, 18, 19, 16, 16, 
      17, 23, 24, 18 ],, 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 
      20, 21, 22, 23, 16, 25 ] ];

CHEVIE.E6.orders:=[ 1, 2, 2, 3, 3, 3, 4, 4, 5, 6, 6, 6, 6, 9, 12, 2, 2, 4, 4, 6, 
  6, 6, 8, 10, 12 ];

CHEVIE.E6.centralizers:=[ 51840, 1152, 192, 648, 216, 108, 96, 16, 10, 72,
  36, 36, 24, 9, 12, 1440, 96, 96, 32, 36, 36, 12, 8, 10, 12 ];

CHEVIE.E6.classes:=[ 1, 45, 270, 80, 240, 480, 540, 3240, 5184, 
    720, 1440, 1440, 2160, 5760, 4320, 36, 540, 540, 1620, 1440, 1440, 4320, 
    6480, 5184, 4320 ];

CHEVIE.E6.PositionId:=function() return 1; end;

CHEVIE.E6.PositionSgn:=function() return 2; end;

CHEVIE.E6.PositionRefl:=function() return 4; end;

CHEVIE.E6.vpolheckeirreducibles:=
[ [ [ [ 1 ], 0 ], [ [ 1 ], 12 ], [ [ 1 ], 2 ], [ [ 1 ], 24 ], [ [ 1 ], 2 ], 
      [ [ 1 ], 4 ], [ [ 1 ], 6 ], [ [ 1 ], 4 ], [ [ 1 ], 4 ], [ [ 1 ], 12 ], 
      [ [ 1 ], 4 ], [ [ 1 ], 14 ], [ [ 1 ], 4 ], [ [ 1 ], 8 ], [ [ 1 ], 6 ], 
      [ [ 1 ], 1 ], [ [ 1 ], 3 ], [ [ 1 ], 13 ], [ [ 1 ], 3 ], [ [ 1 ], 3 ], 
      [ [ 1 ], 5 ], [ [ 1 ], 5 ], [ [ 1 ], 5 ], [ [ 1 ], 5 ], [ [ 1 ], 7 ] ], 
  [ [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], 
      [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], 
      [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], [ [ 1 ], 0 ], 
      [ [ -1 ], 0 ], [ [ -1 ], 0 ], [ [ -1 ], 0 ], [ [ -1 ], 0 ], 
      [ [ -1 ], 0 ], [ [ -1 ], 0 ], [ [ -1 ], 0 ], [ [ -1 ], 0 ], 
      [ [ -1 ], 0 ], [ [ -1 ], 0 ] ], 
  [ [ [ 10 ], 0 ], [ [ -6 ], 6 ], [ [ 3, -4, 3 ], 0 ], [ [ 1 ], 12 ], 
      [ [ 1, -4, 1 ], 0 ], [ [ 1, 0, 2, 0, 1 ], 0 ], [ [ 2 ], 3 ], 
      [ [ -1, 0, -1 ], 1 ], [ [  ], 0 ], [ [ -3 ], 6 ], [ [  ], 0 ], 
      [ [ -1, 2, -1 ], 6 ], [ [ 1, -1, 2, -1, 1 ], 0 ], [ [ 1 ], 4 ], 
      [ [ -1 ], 3 ], [ [ -5, 5 ], 0 ], [ [ -2, 3, -3, 2 ], 0 ], 
      [ [ 3, -3 ], 6 ], [ [ 1, -1 ], 1 ], [ [ -1, 2, -2, 1 ], 0 ], 
      [ [ -1, 0, -1, 1, 0, 1 ], 0 ], [ [  ], 0 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [  ], 0 ] ], 
  [ [ [ 6 ], 0 ], [ [ -4, 0, 0, 2 ], 9 ], [ [ -2, 4 ], 1 ], [ [ -3 ], 20 ], 
      [ [ -1, 4 ], 1 ], [ [ -2, 2 ], 3 ], [ [ 2 ], 6 ], [ [ -2, 2 ], 3 ], 
      [ [ -1, 2 ], 3 ], [ [ 1 ], 10 ], [ [ -1, 2 ], 3 ], [ [ -2 ], 11 ], 
      [ [ -3, 2 ], 3 ], [ [  ], 0 ], [ [ -1 ], 5 ], [ [ -1, 5 ], 0 ], 
      [ [ -3, 3 ], 2 ], [ [ -3, 0, 0, 1 ], 10 ], [ [ -1, 3 ], 2 ], 
      [ [ -2, 3 ], 2 ], [ [ -3, 1 ], 4 ], [ [ -1, 1 ], 4 ], [ [ -1, 1 ], 4 ], 
      [ [ -2, 1 ], 4 ], [ [ 1 ], 7 ] ], 
  [ [ [ 6 ], 0 ], [ [ 2, 0, 0, -4 ], 0 ], [ [ 4, -2 ], 0 ], [ [ -3 ], 4 ], 
      [ [ 4, -1 ], 0 ], [ [ 2, -2 ], 0 ], [ [ 2 ], 0 ], [ [ 2, -2 ], 0 ], 
      [ [ 2, -1 ], 0 ], [ [ 1 ], 2 ], [ [ 2, -1 ], 0 ], [ [ -2 ], 3 ], 
      [ [ 2, -3 ], 0 ], [ [  ], 0 ], [ [ -1 ], 1 ], [ [ -5, 1 ], 0 ], 
      [ [ -3, 3 ], 0 ], [ [ -1, 0, 0, 3 ], 0 ], [ [ -3, 1 ], 0 ], 
      [ [ -3, 2 ], 0 ], [ [ -1, 3 ], 0 ], [ [ -1, 1 ], 0 ], [ [ -1, 1 ], 0 ], 
      [ [ -1, 2 ], 0 ], [ [ -1 ], 0 ] ], 
  [ [ [ 20 ], 0 ], [ [ -4, 0, 0, 12, 0, 0, -4 ], 3 ], [ [ 4, -12, 4 ], 0 ], 
      [ [ -7 ], 12 ], [ [ 4, -6, 4 ], 0 ], [ [ -2, 6, -2 ], 1 ], 
      [ [ 4 ], 3 ], [ [ -2, 4, -2 ], 1 ], [ [ -1, 2, -1 ], 1 ], [ [ 1 ], 6 ], 
      [ [ -1, 0, -1 ], 1 ], [ [ -2 ], 7 ], [ [ -3, 8, -3 ], 1 ], 
      [ [ -1 ], 4 ], [ [ 1 ], 3 ], [ [ -10, 10 ], 0 ], 
      [ [ -1, 9, -9, 1 ], 0 ], [ [ -1, 0, -3, 3, 0, 1 ], 4 ], 
      [ [ -1, 3, -3, 1 ], 0 ], [ [ -1, 6, -6, 1 ], 0 ], [ [ -5, 5 ], 2 ], 
      [ [ -1, 1 ], 2 ], [ [  ], 0 ], [ [ -2, 2 ], 2 ], [ [ -1, 1 ], 3 ] ], 
  [ [ [ 15 ], 0 ], [ [ 6, 0, 0, -8, 0, 0, 1 ], 6 ], [ [ 1, -8, 6 ], 0 ], 
      [ [ 6 ], 16 ], [ [ 1, -4, 6 ], 0 ], [ [ 3, -4, 1 ], 2 ], 
      [ [ 2, 0, 0, 1 ], 3 ], [ [ 2, -4, 1 ], 2 ], [ [ 1, -2, 1 ], 2 ], 
      [ [ 2 ], 8 ], [ [ -2, 1 ], 3 ], [ [ 1, 0, 1 ], 8 ], [ [ 4, -6, 1 ], 2 ],
      [ [  ], 0 ], [ [  ], 0 ], [ [ -5, 10 ], 0 ], [ [ 3, -9, 3 ], 1 ], 
      [ [ 3, 0, 1, -3 ], 7 ], [ [ 1, -3, 3 ], 1 ], [ [ 2, -6, 3 ], 1 ], 
      [ [ 5, -3 ], 3 ], [ [ 1, -1 ], 3 ], [ [ -1 ], 4 ], [ [ 2, -2 ], 3 ], 
      [ [ 1 ], 4 ] ], 
  [ [ [ 15 ], 0 ], [ [ 1, 0, 0, -8, 0, 0, 6 ], 0 ], [ [ 6, -8, 1 ], 0 ], 
      [ [ 6 ], 8 ], [ [ 6, -4, 1 ], 0 ], [ [ 1, -4, 3 ], 0 ], 
      [ [ 1, 0, 0, 2 ], 0 ], [ [ 1, -4, 2 ], 0 ], [ [ 1, -2, 1 ], 0 ], 
      [ [ 2 ], 4 ], [ [ 1, -2 ], 0 ], [ [ 1, 0, 1 ], 4 ], [ [ 1, -6, 4 ], 0 ],
      [ [  ], 0 ], [ [  ], 0 ], [ [ -10, 5 ], 0 ], [ [ -3, 9, -3 ], 0 ], 
      [ [ 3, -1, 0, -3 ], 3 ], [ [ -3, 3, -1 ], 0 ], [ [ -3, 6, -2 ], 0 ], 
      [ [ 3, -5 ], 1 ], [ [ 1, -1 ], 1 ], [ [ 1 ], 1 ], [ [ 2, -2 ], 1 ], 
      [ [ -1 ], 3 ] ], 
  [ [ [ 15 ], 0 ], [ [ 2, 0, 9, -4 ], 6 ], [ [ 2, -6, 7 ], 0 ], 
      [ [ -3 ], 16 ], [ [ -5, 5 ], 1 ], [ [ 2, -2, 3 ], 2 ], [ [ 2, -3 ], 3 ],
      [ [ 1, -2, 2 ], 2 ], [ [ -1, 1 ], 3 ], [ [ 1 ], 8 ], [ [ -1, -1 ], 2 ], 
      [ [ 1 ], 10 ], [ [ -1, 2, -4, 3 ], 1 ], [ [  ], 0 ], [ [ -1 ], 4 ], 
      [ [ -5, 10 ], 0 ], [ [ -1, 3, -6, 5 ], 0 ], [ [ 4, -1 ], 9 ], 
      [ [ -3, 2 ], 2 ], [ [ 2, -4, 4 ], 1 ], [ [ -1, 1, -3, 2 ], 2 ], 
      [ [ 1 ], 5 ], [ [ -1 ], 3 ], [ [ -1, 1 ], 4 ], [ [ 1, -1 ], 4 ] ], 
  [ [ [ 15 ], 0 ], [ [ -4, 9, 0, 2 ], 3 ], [ [ 7, -6, 2 ], 0 ], 
      [ [ -3 ], 8 ], [ [ 5, -5 ], 0 ], [ [ 3, -2, 2 ], 0 ], [ [ -3, 2 ], 2 ], 
      [ [ 2, -2, 1 ], 0 ], [ [ 1, -1 ], 0 ], [ [ 1 ], 4 ], [ [ -1, -1 ], 1 ], 
      [ [ 1 ], 4 ], [ [ 3, -4, 2, -1 ], 0 ], [ [  ], 0 ], [ [ -1 ], 2 ], 
      [ [ -10, 5 ], 0 ], [ [ -5, 6, -3, 1 ], 0 ], [ [ 1, -4 ], 3 ], 
      [ [ -2, 3 ], 0 ], [ [ -4, 4, -2 ], 0 ], [ [ -2, 3, -1, 1 ], 0 ], 
      [ [ -1 ], 0 ], [ [ 1 ], 2 ], [ [ -1, 1 ], 0 ], [ [ 1, -1 ], 2 ] ], 
  [ [ [ 20 ], 0 ], [ [ 9, -8, 0, 0, 3 ], 8 ], [ [ 1, -8, 11 ], 0 ], 
      [ [ 2 ], 18 ], [ [ -5, 10 ], 1 ], [ [ 1, -6, 4 ], 2 ], 
      [ [ -3, 0, 3 ], 4 ], [ [ 1, -5, 4 ], 2 ], [ [ -3, 3 ], 3 ], 
      [ [ -2 ], 9 ], [ [ -2, 3 ], 3 ], [ [ 2, -1 ], 10 ], [ [ 3, -7, 5 ], 2 ],
      [ [ -1 ], 6 ], [ [  ], 0 ], [ [ -5, 15 ], 0 ], [ [ 3, -9, 8 ], 1 ], 
      [ [ 5, -4, 0, 0, 1 ], 9 ], [ [ -4, 6 ], 2 ], [ [ 1, -7, 7 ], 1 ], 
      [ [ 3, -5, 3 ], 3 ], [ [ -2, 1 ], 4 ], [ [ -1, 1 ], 4 ], 
      [ [ 1, -3, 2 ], 3 ], [ [ -2, 0, 1 ], 5 ] ], 
  [ [ [ 20 ], 0 ], [ [ 3, 0, 0, -8, 9 ], 0 ], [ [ 11, -8, 1 ], 0 ], 
      [ [ 2 ], 6 ], [ [ 10, -5 ], 0 ], [ [ 4, -6, 1 ], 0 ], 
      [ [ 3, 0, -3 ], 0 ], [ [ 4, -5, 1 ], 0 ], [ [ 3, -3 ], 0 ], 
      [ [ -2 ], 3 ], [ [ 3, -2 ], 0 ], [ [ -1, 2 ], 3 ], [ [ 5, -7, 3 ], 0 ], 
      [ [ -1 ], 2 ], [ [  ], 0 ], [ [ -15, 5 ], 0 ], [ [ -8, 9, -3 ], 0 ], 
      [ [ -1, 0, 0, 4, -5 ], 0 ], [ [ -6, 4 ], 0 ], [ [ -7, 7, -1 ], 0 ], 
      [ [ -3, 5, -3 ], 0 ], [ [ -1, 2 ], 0 ], [ [ -1, 1 ], 0 ], 
      [ [ -2, 3, -1 ], 0 ], [ [ -1, 0, 2 ], 0 ] ], 
  [ [ [ 24 ], 0 ], [ [ -2, 0, 9, 0, 0, 0, 1 ], 6 ], [ [ 4, -12, 8 ], 0 ], 
      [ [ 6 ], 14 ], [ [ 2, -8, 6 ], 0 ], [ [ 1, 0, 5, -4, 1 ], 0 ], 
      [ [ 2, -3, 0, 1 ], 3 ], [ [ -1, 3, -3, 1 ], 1 ], [ [ 1, -2 ], 2 ], 
      [ [ 2 ], 7 ], [ [ 1, 0, 1 ], 2 ], [ [ -2, 1 ], 8 ], 
      [ [ -3, 6, -5, 2 ], 1 ], [ [  ], 0 ], [ [  ], 0 ], [ [ -10, 14 ], 0 ], 
      [ [ -1, 9, -9, 5 ], 0 ], [ [ -2, 0, 2 ], 7 ], [ [ 2, -4, 2 ], 1 ], 
      [ [ -1, 4, -8, 3 ], 0 ], [ [ 1, -3, 4, -2, 1 ], 1 ], [ [ 1 ], 3 ], 
      [ [  ], 0 ], [ [ -1, 1, -1 ], 2 ], [ [ 1, -1 ], 4 ] ], 
  [ [ [ 24 ], 0 ], [ [ 1, 0, 0, 0, 9, 0, -2 ], 0 ], [ [ 8, -12, 4 ], 0 ], 
      [ [ 6 ], 10 ], [ [ 6, -8, 2 ], 0 ], [ [ 1, -4, 5, 0, 1 ], 0 ], 
      [ [ 1, 0, -3, 2 ], 0 ], [ [ 1, -3, 3, -1 ], 0 ], [ [ -2, 1 ], 1 ], 
      [ [ 2 ], 5 ], [ [ 1, 0, 1 ], 0 ], [ [ 1, -2 ], 5 ], 
      [ [ 2, -5, 6, -3 ], 0 ], [ [  ], 0 ], [ [  ], 0 ], [ [ -14, 10 ], 0 ], 
      [ [ -5, 9, -9, 1 ], 0 ], [ [ -2, 0, 2 ], 4 ], [ [ -2, 4, -2 ], 0 ], 
      [ [ -3, 8, -4, 1 ], 0 ], [ [ -1, 2, -4, 3, -1 ], 0 ], [ [ -1 ], 2 ], 
      [ [  ], 0 ], [ [ 1, -1, 1 ], 1 ], [ [ 1, -1 ], 2 ] ], 
  [ [ [ 30 ], 0 ], [ [ -8, 0, 9, -12, 0, 0, 1 ], 6 ], [ [ 3, -14, 13 ], 0 ], 
      [ [ 3 ], 16 ], [ [ 1, -9, 11 ], 0 ], [ [ 5, -6, 4 ], 2 ], 
      [ [ -3, 0, 1 ], 4 ], [ [ 3, -6, 3 ], 2 ], [ [ 1, -3, 2 ], 2 ], 
      [ [ -1 ], 8 ], [ [ 1, -3, 1 ], 2 ], [ [ -1 ], 8 ], 
      [ [ -1, 6, -10, 4 ], 1 ], [ [  ], 0 ], [ [ 1 ], 4 ], [ [ -10, 20 ], 0 ],
      [ [ -1, 6, -15, 8 ], 0 ], [ [ -3, 0, 3, -4 ], 7 ], [ [ 1, -6, 5 ], 1 ], 
      [ [ 4, -10, 7 ], 1 ], [ [ -1, 6, -6, 2 ], 2 ], [ [ 1, -1, 1 ], 3 ], 
      [ [ 1, -1 ], 3 ], [ [ 2, -3, 1 ], 3 ], [ [ -1 ], 5 ] ], 
  [ [ [ 30 ], 0 ], [ [ 1, 0, 0, -12, 9, 0, -8 ], 0 ], [ [ 13, -14, 3 ], 0 ], 
      [ [ 3 ], 8 ], [ [ 11, -9, 1 ], 0 ], [ [ 4, -6, 5 ], 0 ], 
      [ [ 1, 0, -3 ], 0 ], [ [ 3, -6, 3 ], 0 ], [ [ 2, -3, 1 ], 0 ], 
      [ [ -1 ], 4 ], [ [ 1, -3, 1 ], 0 ], [ [ -1 ], 6 ], 
      [ [ 4, -10, 6, -1 ], 0 ], [ [  ], 0 ], [ [ 1 ], 2 ], [ [ -20, 10 ], 0 ],
      [ [ -8, 15, -6, 1 ], 0 ], [ [ 4, -3, 0, 3 ], 3 ], [ [ -5, 6, -1 ], 0 ], 
      [ [ -7, 10, -4 ], 0 ], [ [ -2, 6, -6, 1 ], 0 ], [ [ -1, 1, -1 ], 0 ], 
      [ [ 1, -1 ], 1 ], [ [ -1, 3, -2 ], 0 ], [ [ 1 ], 2 ] ], 
  [ [ [ 60 ], 0 ], [ [ 9, 0, -6, 0, 9 ], 4 ], [ [ 16, -28, 16 ], 0 ], 
      [ [ -3 ], 12 ], [ [ 8, -22, 8 ], 0 ], [ [ 2, -6, 8, -6, 2 ], 0 ], 
      [ [ -3, 10, -3 ], 2 ], [ [ 1, -4, 6, -4, 1 ], 0 ], [ [ -1, 2, -1 ], 1 ],
      [ [ -3 ], 6 ], [ [  ], 0 ], [ [ -1, 2, -1 ], 6 ], 
      [ [ 3, -10, 12, -10, 3 ], 0 ], [ [  ], 0 ], [ [ 1 ], 3 ], 
      [ [ -30, 30 ], 0 ], [ [ -9, 21, -21, 9 ], 0 ], 
      [ [ -1, 0, 5, -5, 0, 1 ], 4 ], [ [ -1, 7, -7, 1 ], 0 ], 
      [ [ -5, 14, -14, 5 ], 0 ], [ [ -1, 5, -6, 6, -5, 1 ], 0 ], [ [  ], 0 ], 
      [ [ 1, -1 ], 2 ], [ [ 1, -1, 1, -1 ], 1 ], [ [ -2, 2 ], 3 ] ], 
  [ [ [ 80 ], 0 ], [ [ -4, 9, 0, -26, 0, 9, -4 ], 3 ], [ [ 20, -40, 20 ], 0 ],
      [ [ -10 ], 12 ], [ [ 12, -28, 12 ], 0 ], [ [ 2, -8, 14, -8, 2 ], 0 ], 
      [ [ -3, 6, -3 ], 2 ], [ [ 1, -6, 10, -6, 1 ], 0 ], [ [ -2, 4, -2 ], 1 ],
      [ [ 2 ], 6 ], [ [ -1, 4, -1 ], 1 ], [ [ 1, 0, 1 ], 6 ], 
      [ [ 3, -13, 20, -13, 3 ], 0 ], [ [ -1 ], 4 ], [ [  ], 0 ], 
      [ [ -40, 40 ], 0 ], [ [ -10, 30, -30, 10 ], 0 ], [ [ 8, -8 ], 6 ], 
      [ [ -2, 10, -10, 2 ], 0 ], [ [ -6, 20, -20, 6 ], 0 ], 
      [ [ -1, 5, -11, 11, -5, 1 ], 0 ], [ [ -1, 1 ], 2 ], [ [ -1, 1 ], 2 ], 
      [ [ 1, -3, 3, -1 ], 1 ], [ [ -1, 1 ], 3 ] ], 
  [ [ [ 90 ], 0 ], [ [ -8, 9, 0, -8, 0, 9, -8 ], 3 ], [ [ 21, -48, 21 ], 0 ], 
      [ [ 9 ], 12 ], [ [ 15, -30, 15 ], 0 ], [ [ 1, -10, 18, -10, 1 ], 0 ], 
      [ [ -3, 8, -3 ], 2 ], [ [ 1, -7, 14, -7, 1 ], 0 ], [ [ -3, 6, -3 ], 1 ],
      [ [ -3 ], 6 ], [ [ -2, 4, -2 ], 1 ], [ [ -1, 2, -1 ], 6 ], 
      [ [ 2, -15, 26, -15, 2 ], 0 ], [ [  ], 0 ], [ [ -1 ], 3 ], 
      [ [ -45, 45 ], 0 ], [ [ -9, 36, -36, 9 ], 0 ], 
      [ [ -1, 0, 2, -2, 0, 1 ], 4 ], [ [ -3, 12, -12, 3 ], 0 ], 
      [ [ -6, 24, -24, 6 ], 0 ], [ [ 5, -15, 15, -5 ], 1 ], [ [ -2, 2 ], 2 ], 
      [ [ -1, 1 ], 2 ], [ [ 1, -5, 5, -1 ], 1 ], [ [ -2, 2 ], 3 ] ], 
  [ [ [ 60 ], 0 ], [ [ -14, 0, 18, -8 ], 6 ], [ [ 11, -28, 21 ], 0 ], 
      [ [ 6 ], 14 ], [ [ 4, -21, 14 ], 0 ], [ [ -4, 7, -10, 4 ], 1 ], 
      [ [ 6, -6 ], 3 ], [ [ -2, 6, -7, 3 ], 1 ], [ [ 2, -3, 1 ], 2 ], 
      [ [ 2 ], 7 ], [ [ 1, -2 ], 2 ], [ [ 1, -2 ], 7 ], 
      [ [ 1, -6, 13, -13, 6 ], 0 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ -25, 35 ], 0 ], [ [ -5, 18, -24, 13 ], 0 ], 
      [ [ 3, -8, 0, 4, -1 ], 6 ], [ [ 4, -10, 4 ], 1 ], 
      [ [ -2, 11, -17, 9 ], 0 ], [ [ 2, -5, 8, -7, 3 ], 1 ], [ [ -1 ], 4 ], 
      [ [  ], 0 ], [ [ -1, 2, -2, 1 ], 2 ], [ [ 2, -1 ], 4 ] ], 
  [ [ [ 60 ], 0 ], [ [ -8, 18, 0, -14 ], 3 ], [ [ 21, -28, 11 ], 0 ], 
      [ [ 6 ], 10 ], [ [ 14, -21, 4 ], 0 ], [ [ 4, -10, 7, -4 ], 0 ], 
      [ [ -6, 6 ], 2 ], [ [ 3, -7, 6, -2 ], 0 ], [ [ 1, -3, 2 ], 0 ], 
      [ [ 2 ], 5 ], [ [ -2, 1 ], 1 ], [ [ -2, 1 ], 6 ], 
      [ [ 6, -13, 13, -6, 1 ], 0 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ -35, 25 ], 0 ], [ [ -13, 24, -18, 5 ], 0 ], 
      [ [ 1, -4, 0, 8, -3 ], 3 ], [ [ -4, 10, -4 ], 0 ], 
      [ [ -9, 17, -11, 2 ], 0 ], [ [ -3, 7, -8, 5, -2 ], 0 ], [ [ 1 ], 1 ], 
      [ [  ], 0 ], [ [ -1, 2, -2, 1 ], 0 ], [ [ 1, -2 ], 2 ] ], 
  [ [ [ 64 ], 0 ], [ [ -4, 0, 18, -16, 0, 0, 2 ], 6 ], [ [ 8, -32, 24 ], 0 ], 
      [ [ -8 ], 15 ], [ [ 4, -20, 20 ], 0 ], [ [ -2, 10, -14, 4 ], 1 ], 
      [ [ 4, -6, 0, 2 ], 3 ], [ [ -1, 8, -11, 4 ], 1 ], [ [ 3, -6, 2 ], 2 ], 
      [ [  ], 0 ], [ [ 2, -4, 2 ], 2 ], [ [  ], 0 ], 
      [ [ -4, 16, -18, 6 ], 1 ], [ [ 1 ], 5 ], [ [  ], 0 ], 
      [ [ -24, 40 ], 0 ], [ [ -2, 18, -30, 14 ], 0 ], [ [ -2, 0, 6, -4 ], 7 ],
      [ [ 4, -12, 8 ], 1 ], [ [ -1, 10, -22, 11 ], 0 ], 
      [ [ -6, 12, -10, 2 ], 2 ], [ [ 2, -2 ], 3 ], [ [ 1, -1 ], 3 ], 
      [ [ -1, 5, -4, 1 ], 2 ], [ [ 2, -2 ], 4 ] ], 
  [ [ [ 64 ], 0 ], [ [ 2, 0, 0, -16, 18, 0, -4 ], 0 ], [ [ 24, -32, 8 ], 0 ], 
      [ [ -8 ], 9 ], [ [ 20, -20, 4 ], 0 ], [ [ 4, -14, 10, -2 ], 0 ], 
      [ [ 2, 0, -6, 4 ], 0 ], [ [ 4, -11, 8, -1 ], 0 ], [ [ 2, -6, 3 ], 0 ], 
      [ [  ], 0 ], [ [ 2, -4, 2 ], 0 ], [ [  ], 0 ], 
      [ [ 6, -18, 16, -4 ], 0 ], [ [ 1 ], 3 ], [ [  ], 0 ], 
      [ [ -40, 24 ], 0 ], [ [ -14, 30, -18, 2 ], 0 ], [ [ 4, -6, 0, 2 ], 3 ], 
      [ [ -8, 12, -4 ], 0 ], [ [ -11, 22, -10, 1 ], 0 ], 
      [ [ -2, 10, -12, 6 ], 0 ], [ [ 2, -2 ], 1 ], [ [ 1, -1 ], 1 ], 
      [ [ -1, 4, -5, 1 ], 0 ], [ [ 2, -2 ], 2 ] ], 
  [ [ [ 81 ], 0 ], [ [ 9, 0, -6, 0, 18, -12 ], 4 ], [ [ 15, -42, 24 ], 0 ], 
      [ [  ], 0 ], [ [ 9, -27, 18 ], 0 ], [ [ -6, 15, -12, 3 ], 1 ], 
      [ [ -3, 6, -6 ], 2 ], [ [ -4, 11, -10, 2 ], 1 ], 
      [ [ -1, 5, -4, 1 ], 1 ], [ [  ], 0 ], [ [ 3, -3 ], 2 ], [ [  ], 0 ], 
      [ [ 1, -9, 22, -18, 4 ], 0 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ -36, 45 ], 0 ], [ [ -6, 27, -36, 12 ], 0 ], 
      [ [ 1, 2, -2, -1, 4, -1 ], 5 ], [ [ -1, 8, -13, 5 ], 0 ], 
      [ [ -3, 18, -24, 9 ], 0 ], [ [ 2, -10, 15, -8, 1 ], 1 ], 
      [ [ -1, 2, -1 ], 2 ], [ [ 1 ], 3 ], [ [ -3, 5, -3 ], 2 ], 
      [ [ -1, 2, -1 ], 3 ] ], 
  [ [ [ 81 ], 0 ], [ [ -12, 18, 0, -6, 0, 9 ], 3 ], [ [ 24, -42, 15 ], 0 ], 
      [ [  ], 0 ], [ [ 18, -27, 9 ], 0 ], [ [ 3, -12, 15, -6 ], 0 ], 
      [ [ -6, 6, -3 ], 2 ], [ [ 2, -10, 11, -4 ], 0 ], 
      [ [ 1, -4, 5, -1 ], 0 ], [ [  ], 0 ], [ [ -3, 3 ], 1 ], [ [  ], 0 ], 
      [ [ 4, -18, 22, -9, 1 ], 0 ], [ [  ], 0 ], [ [  ], 0 ], 
      [ [ -45, 36 ], 0 ], [ [ -12, 36, -27, 6 ], 0 ], 
      [ [ 1, -4, 1, 2, -2, -1 ], 3 ], [ [ -5, 13, -8, 1 ], 0 ], 
      [ [ -9, 24, -18, 3 ], 0 ], [ [ -1, 8, -15, 10, -2 ], 0 ], 
      [ [ 1, -2, 1 ], 1 ], [ [ -1 ], 2 ], [ [ 3, -5, 3 ], 1 ], 
      [ [ 1, -2, 1 ], 2 ] ] ];

CHEVIE.E6.vcycpolschurelms:=
[ [ [ 0, 0, 4, 3, 2, 1, 2, 0, 1, 1, 0, 0, 1 ], 1 ], 
  [ [ -36, 0, 4, 3, 2, 1, 2, 0, 1, 1, 0, 0, 1 ], 1 ], 
  [ [ -7, 0, 4, 3, 2 ], 3 ], [ [ -1, 0, 4, 3, 2, 1, 2, 0, 0, 0, 0, 0, 1 ], 1 ]
    , [ [ -25, 0, 4, 3, 2, 1, 2, 0, 0, 0, 0, 0, 1 ], 1 ], 
  [ [ -7, 0, 4, 3, 0, 0, 0, 0, 0, 0, 0, 0, 1 ], 6 ], 
  [ [ -3, 0, 4, 3, 2, 0, 0, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -15, 0, 4, 3, 2, 0, 0, 0, 0, 0, 0, 0, 1 ], 2 ], 
  [ [ -3, 0, 4, 3, 2, 0, 2 ], 2 ], [ [ -15, 0, 4, 3, 2, 0, 2 ], 2 ], 
  [ [ -2, 0, 4, 3, 1, 0, 2, 0, 0, 1 ], 1 ], 
  [ [ -20, 0, 4, 3, 1, 0, 2, 0, 0, 1 ], 1 ], [ [ -6, 0, 4, 3, 0, 1, 2 ], 1 ], 
  [ [ -12, 0, 4, 3, 0, 1, 2 ], 1 ], [ [ -3, 0, 4, 3, 0, 0, 2, 0, 1 ], 2 ], 
  [ [ -15, 0, 4, 3, 0, 0, 2, 0, 1 ], 2 ], [ [ -7, 0, 4, 3, 0, 0, 2 ], 2 ], 
  [ [ -7, 0, 0, 3, 2, 0, 2 ], 6 ], [ [ -7, 0, 4, 0, 2, 0, 0, 0, 0, 1 ], 3 ], 
  [ [ -5, 0, 4, 3, 1, 0, 2 ], 1 ], [ [ -11, 0, 4, 3, 1, 0, 2 ], 1 ], 
  [ [ -4, 0, 1, 3, 0, 1, 0, 0, 0, 1 ], 1 ], 
  [ [ -13, 0, 1, 3, 0, 1, 0, 0, 0, 1 ], 1 ], 
  [ [ -6, 0, 4, 0, 2, 1, 0, 0, 1 ], 1 ], 
  [ [ -10, 0, 4, 0, 2, 1, 0, 0, 1 ], 1 ] ];

CHEVIE.E6.vpolfakedegrees:=
[ [ [ 1 ], 0 ], [ [ 1 ], 36 ], 
  [ [ 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1 ], 9 ], 
  [ [ 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1 ], 1 ], 
  [ [ 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1 ], 25 ], 
  [ [ 1, 0, 1, 2, 1, 0, 3, 2, 0, 2, 3, 0, 1, 2, 1, 0, 1 ], 10 ], 
  [ [ 1, 1, 0, 1, 2, 0, 1, 3, 1, 0, 2, 1, 0, 1, 1 ], 5 ], 
  [ [ 1, 1, 0, 1, 2, 0, 1, 3, 1, 0, 2, 1, 0, 1, 1 ], 17 ], 
  [ [ 1, 0, 1, 1, 1, 0, 2, 1, 1, 1, 2, 0, 1, 1, 1, 0, 1 ], 4 ], 
  [ [ 1, 0, 1, 1, 1, 0, 2, 1, 1, 1, 2, 0, 1, 1, 1, 0, 1 ], 16 ], 
  [ [ 1, 1, 1, 1, 2, 1, 2, 2, 2, 1, 2, 1, 1, 1, 1 ], 2 ], 
  [ [ 1, 1, 1, 1, 2, 1, 2, 2, 2, 1, 2, 1, 1, 1, 1 ], 20 ], 
  [ [ 1, 0, 1, 1, 1, 1, 3, 1, 2, 2, 2, 1, 3, 1, 1, 1, 1, 0, 1 ], 6 ], 
  [ [ 1, 0, 1, 1, 1, 1, 3, 1, 2, 2, 2, 1, 3, 1, 1, 1, 1, 0, 1 ], 12 ], 
  [ [ 1, 0, 1, 1, 2, 1, 3, 2, 3, 2, 3, 2, 3, 1, 2, 1, 1, 0, 1 ], 3 ], 
  [ [ 1, 0, 1, 1, 2, 1, 3, 2, 3, 2, 3, 2, 3, 1, 2, 1, 1, 0, 1 ], 15 ], 
  [ [ 1, 1, 2, 1, 3, 3, 4, 3, 6, 4, 4, 4, 6, 3, 4, 3, 3, 1, 2, 1, 1 ], 8 ], 
  [ [ 1, 0, 1, 2, 3, 2, 6, 4, 5, 6, 8, 4, 8, 6, 5, 4, 6, 2, 3, 2, 1, 0, 1 ], 
      7 ], 
  [ [ 1, 2, 1, 3, 4, 4, 5, 8, 6, 7, 8, 7, 6, 8, 5, 4, 4, 3, 1, 2, 1 ], 8 ], 
  [ [ 1, 1, 1, 2, 3, 2, 4, 5, 4, 4, 6, 4, 4, 5, 4, 2, 3, 2, 1, 1, 1 ], 5 ], 
  [ [ 1, 1, 1, 2, 3, 2, 4, 5, 4, 4, 6, 4, 4, 5, 4, 2, 3, 2, 1, 1, 1 ], 11 ], 
  [ [ 1, 1, 1, 3, 3, 3, 5, 5, 4, 6, 6, 4, 5, 5, 3, 3, 3, 1, 1, 1 ], 4 ], 
  [ [ 1, 1, 1, 3, 3, 3, 5, 5, 4, 6, 6, 4, 5, 5, 3, 3, 3, 1, 1, 1 ], 13 ], 
  [ [ 1, 1, 2, 2, 4, 4, 5, 5, 7, 6, 7, 6, 7, 5, 5, 4, 4, 2, 2, 1, 1 ], 6 ], 
  [ [ 1, 1, 2, 2, 4, 4, 5, 5, 7, 6, 7, 6, 7, 5, 5, 4, 4, 2, 2, 1, 1 ], 10 ] ];

#############################################################################
##
#F  CHEVIE.E6.ClassParam( <w> )   . . . . . . . . . . . class parameter of w
##
##  given an element w  of a Coxeter group W of type E_6  as word in  standard
##  generators, 'CHEVIE.E6.ClassParam' returns the classparam of its conjugacy
##  class.
##
CHEVIE.E6.ClassParam:=function(w)
  if w=[] then return " ";fi;
  return CHEVIE.E6.classparams[Position(CHEVIE.E6.cyclestructure,
    CycleStructurePerm(Product(CHEVIE.E6.generators{w})))];
end;

###########################################################################
##
#F CHEVIE.E6.HeckeCharTable( <v> ) character table of the Hecke algebra of type E6
##
## Note: the parameter for the Hecke algebra is <v>.
##
CHEVIE.E6.HeckeCharTable:=v->rec( 
  identifier := "H(E6)", 
  text := "origin: Meinolf Geck, April 1992",
  parameter := [ v, v, v, v, v, v ],
  cartan:=CHEVIE.E6.cartan, 
  size := 51840, 
  powermap:=CHEVIE.E6.powermap, 
  classtext := CHEVIE.E6.classtext,
  classnames := CHEVIE.E6.classnames,
  classparam := CHEVIE.E6.classnames,
  orders := CHEVIE.E6.orders, 
  centralizers := CHEVIE.E6.centralizers, 
  classes := CHEVIE.E6.classes,
  irreducibles:=List(CHEVIE.E6.vpolheckeirreducibles,
                     i->List(i,j->FastValue(j,v))),
  irredinfo:=List(CHEVIE.E6.CharParams(),x->
                       rec(charparam:=x,charname:=CHEVIE.E6.CharName(x))),
  operations:=CharTableOps);
