#############################################################################
##
#A  codeops.g                GUAVA                              Reinald Baart
#A                                                        &Jasper Cramwinckel
#A                                                           &Erik Roijackers
##
##  All the dispatchers and their .operation entries
##
#H  $Log: codeops.g,v $
#H  Revision 1.2  1997/01/20 15:05:56  werner
#H  Upgrade from Guava 1.2 to Guava 1.3 for GAP release 3.4.4.
#H
#H  Revision 1.65  1996/05/23  12:37:22  eminkes
#H  Aarghh. The bug was not in WeightDistribution...
#H  So I undid some changes.
#H
#H  Revision 1.64  1996/05/15  13:02:19  eminkes
#H  Also for CodeOps.
#H
#H  Revision 1.63  1996/05/15  12:22:23  eminkes
#H  Tried again to solve WeightDistribution.
#H
#H  Revision 1.62  1996/05/15  12:11:26  eminkes
#H  Hopefully WeightDistribution works now.
#H
#H  Revision 1.61  1996/05/15  12:05:56  eminkes
#H  Another small mistake.
#H
#H  Revision 1.60  1996/05/15  12:03:22  eminkes
#H  Made a small mistake.  Should work now.
#H
#H  Revision 1.59  1996/05/15  11:58:32  eminkes
#H  A ugly hack in WeightDistribution. WD sometimes returned a vector
#H  that was too long.
#H
#H  Revision 1.58  1996/04/26  09:48:48  eminkes
#H  Made changes that were necessary for the new release of GUAVA.
#H
#H  Revision 1.57  1996/03/21  15:05:28  eminkes
#H  Forgot to change all three "Save" functions.
#H
#H  Revision 1.56  1996/03/21  14:59:37  eminkes
#H  Changed the behavior of Save.  It no longer appends to the file,
#H  instead it erases the file first, like the other Save-functions.
#H
#H  Revision 1.55  1995/11/09  14:40:01  jcramwin
#H  Fixed a bug in WordLength. WordLength(~list~) gave an infinite
#H  loop, now it gives an error.
#H
#H  Revision 1.54  1995/11/09  12:43:14  jcramwin
#H  From now on, in a linear code, the wordlength must always be
#H  included, just like with cyclic codes
#H
#H  Revision 1.53  1995/05/18  02:12:37  mschoene
#H  changed location of executables, fixed 'TmpName' call
#H
#H  Revision 1.52  1995/05/17  23:40:54  mschoene
#H  changed 'MinimumDistanceCombinations' to 'ClosestVectorCombinations'
#H
#H  Revision 1.51  1995/01/12  10:17:12  jcramwin
#H  fixed some bugs (found by Simonis) in MinimumDistance(C, w) for C linear
#H
#H  Revision 1.50  1995/01/06  10:55:10  jcramwin
#H  removed a comment in LinCodeOps.MinDist
#H
#H  Revision 1.49  1995/01/04  14:15:12  jcramwin
#H  fixed a bug in LinCodeOps.MinDist when SyndromeTable is bound
#H
#H  Revision 1.48  1994/11/15  08:20:16  rbaart
#H  Changed 2nd LinCodeOps.LowerBoundMinimumDistance
#H
#H  Revision 1.46  1994/11/11  17:10:25  jcramwin
#H  Sharpened the LowerBoundMinimumDistance
#H
#H  Revision 1.45  1994/11/11  16:06:46  jcramwin
#H  changed the way MinDist gets a few columns from a matrix
#H
#H  Revision 1.44  1994/11/10  12:16:42  rbaart
#H  Elements: return [NullWord(C)] (list)
#H
#H  Revision 1.43  1994/11/10  10:33:27  jcramwin
#H  History returned a list of list of chars, now a list of strings
#H
#H  Revision 1.42  1994/11/09  14:08:24  jcramwin
#H  changed the Display & History & String
#H
#H  Revision 1.41  1994/11/08  13:57:13  rbaart
#H  String: removed printing of selfdual and perfect
#H
#H  Revision 1.40  1994/11/07  14:38:36  rbaart
#H  Added OpsOps to the *CodeOps records
#H
#H  Revision 1.39  1994/11/04  16:47:59  jcramwin
#H  Minimumdistance now makes use of the sindrometable if it is bound
#H
#H  Revision 1.38  1994/11/04  12:50:05  jcramwin
#H  I finaly found out how MinDist(C, v) works. Made some changes with it
#H
#H  Revision 1.37  1994/11/03  10:50:11  jcramwin
#H  Changed NullVector
#H
#H  Revision 1.36  1994/11/03  09:56:05  jcramwin
#H  for permutig two rows, they need not be copied
#H
#H  Revision 1.35  1994/11/03  08:49:10  rbaart
#H  Same as previous
#H
#H  Revision 1.34  1994/11/03  08:46:51  rbaart
#H  IsSelfOrthogonalCode: fixed operations.isSelfOrthogonalCode
#H
#H  Revision 1.33  1994/11/02  15:40:23  rbaart
#H  Changed Permuted into own version
#H
#H  Revision 1.32  1994/11/02  14:06:31  jcramwin
#H  fixed a bug in CycCodeOps.MinimumDistance
#H
#H  Revision 1.31  1994/11/02  12:15:56  jcramwin
#H  added a Hisplay function and dispatchers
#H
#H  Revision 1.30  1994/10/31  12:46:51  jcramwin
#H  the history can be generated by DescriptionOfCode(C)
#H
#H  Revision 1.29  1994/10/28  11:05:00  rbaart
#H  Added p.b.a. AutomorphismGroup & CodeIsomorphism (in commment)
#H
#H  Revision 1.28  1994/10/28  10:42:52  rbaart
#H  MinimumWeightWords: initialized zerovec
#H
#H  Revision 1.27  1994/10/27  17:18:49  rbaart
#H  MinimumWeightWords improved
#H
#H  Revision 1.26  1994/10/27  15:29:26  jcramwin
#H  rewrote StandardArray
#H
#H  Revision 1.25  1994/10/26  12:25:35  rbaart
#H  UpperBoundMinimumDistance checks for null codes
#H
#H  Revision 1.24  1994/10/26  12:14:32  jcramwin
#H  finished the dispachers
#H
#H  Revision 1.23  1994/10/26  10:47:58  jcramwin
#H  changed some dispachers angain
#H
#H  Revision 1.22  1994/10/25  16:34:36  jcramwin
#H  speeded up mindist and changed some dispatchers
#H
#H  Revision 1.21  1994/10/24  16:39:38  jcramwin
#H  speeded up LinCodeOps.MinimumDistance
#H
#H  Revision 1.20  1994/10/24  11:25:17  jcramwin
#H  changed \= so C = false will work.
#H
#H  Revision 1.19  1994/10/24  09:30:06  jcramwin
#H  Redundancy rewriten (the dispatcher checked for linearaty
#H  of the code -> wrong)!
#H
#H  Revision 1.18  1994/10/24  08:43:32  jcramwin
#H  'distace' changed in 'distance'
#H
#H  Revision 1.17  1994/10/24  08:28:02  rbaart
#H  CodeIsomorphism: removed copying of innerDistribution field
#H
#H  Revision 1.16  1994/10/24  08:17:52  jcramwin
#H  Lower and UpperBoundMinimumDistance implemented
#H
#H  Revision 1.15  1994/10/20  14:20:57  rbaart
#H  Added MinimumWeightWords and changed function String
#H
#H  Revision 1.14  1994/10/19  09:35:09  rbaart
#H  Changed Display
#H
#H  Revision 1.13  1994/10/14  16:22:19  jcramwin
#H  probably changed something with OptimalLinearCode
#H
#H  Revision 1.12  1994/10/13  15:16:38  rbaart
#H  Changed codeword functions
#H
#H  Revision 1.11  1994/10/11  14:39:00  rbaart
#H  Elements: now checks for empty generator matrix
#H
#H  Revision 1.10  1994/10/11  09:23:23  jcramwin
#H  fixed a bug in LinCodeOps.MinimumDistance I just created...
#H
#H  Revision 1.9  1994/10/07  16:00:32  jcramwin
#H  fixed a bug in MinDist I just introduced...
#H
#H  Revision 1.8  1994/10/07  14:58:30  jcramwin
#H  changed some things in LinCodeOps.Minimumdistance, hoped to
#H  make it faster but it did not work
#H
#H  Revision 1.7  1994/10/06  13:58:11  rbaart
#H  MinimumDistance checks for presence of weightDistribution,
#H  WeightDistribution no longer uses KrawtchoukMat
#H
#H  Revision 1.6  1994/09/30  10:45:19  rbaart
#H  Fixed bug in IsCyclicCode
#H
#H  Revision 1.5  1994/09/30  10:22:51  rbaart
#H  Fixed bug in IsLinearCode
#H
#H  Revision 1.4  1994/09/28  13:54:05  jcramwin
#H  changed ' for "
#H
#H  Revision 1.3  1994/09/28  13:01:27  jcramwin
#H  changed intFFE in IntVecFFE
#H
#H  Revision 1.2  1994/09/28  12:13:25  jcramwin
#H  changed some 'return false'-es in 'Error()'-s
#H
#H  Revision 1.1  1994/09/28  11:08:29  jcramwin
#H  Initial revision
#H
##

   CodeOps := rec( name :=    "CodeOps", operations := OpsOps );
LinCodeOps := rec( name := "LinCodeOps", operations := OpsOps );
CycCodeOps := rec( name := "CycCodeOps", operations := OpsOps );

#############################################################################
##
#F  IsCode( <C> ) . . . . . . . . . . . . . . . . . . . . . . . . . . trivial
##
IsCode := function ( obj )
    return IsRec( obj ) and IsBound( obj.isCode ) and obj.isCode;
end;

#############################################################################
##
#F  WordLength( <C> ) . . . . . . . . . . . .  length of the codewords of <C>
##
WordLength := function (C)
    local l;
    if IsCode(C) then
        if not IsBound(C.wordLength) then
            C.wordLength :=  C.operations.WordLength(C);
        fi;
        return C.wordLength;
    elif IsCodeword(C) then     # the last part would also have worked
        return C.wordLength;    #in this case, but this works much faster
    else
        l := Codeword(C);
        return l.WordLength;
    fi;
end;

CodeOps.WordLength := function(C)
    return WordLength(Elements(C)[1]);
end;

#In a linear code, the wordlength must always be included
#because the wordlength can not always be calculated (NullCode)
#
#LinCodeOps.WordLength := function(C)
#    if IsBound(C.generatorMat) then
#        return Length( C.generatorMat[1] );
#    else
#        return Length( C.checkMat[1] );
#    fi;
#end;

#############################################################################
##
#F  IsLinearCode( <C> ) . . . . . . . . . . . . . . . checks if <C> is linear
##
## If so, the record fields will be adjusted to the linear type
##
IsLinearCode := function(C)
    if not IsCode(C) then
        return false; #is cool
    fi;
    if not IsBound(C.isLinearCode) then
        C.isLinearCode := C.operations.IsLinearCode(C);
    fi;
    return C.isLinearCode;
end;

CodeOps.IsLinearCode := function(C)
    local gen, k, F, q;
    F := Field(C);
    q := Size(F);
    k := LogInt(Size(C),q);
    # first the trivial cases:
    if ( IsBound(C.weightDistribution) and 
         IsBound(C.innerDistribution)
         and (C.weightDistribution <> C.innerDistribution) )
       or ( q^k <> Size(C) )
       or (not (NullMat(1,WordLength(C), F)[1] in C)) then
        return false; #is cool
    else
        gen:=BaseMat(VectorCodeword(Elements(C)));
        if Length(gen) <> k then
            return false; # is cool as ice
        else
            C.generatorMat := gen;
            C.operations    :=LinCodeOps;
            if IsBound(C.innerDistribution) then
                C.weightDistribution:=C.innerDistribution;
                Unbind(C.innerDistribution);
            fi;
            return true;
        fi;        
    fi;
end;

CycCodeOps.IsLinearCode := function(C)
    return true;
end;


#############################################################################
##
#F  IsFinite( <C> ) . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
##
##  has a global dispatcher
##
CodeOps.IsFinite := function(C)
    return true;
end;

LinCodeOps.IsFinite := CodeOps.IsFinite;
  
CycCodeOps.IsFinite := CodeOps.IsFinite;


#############################################################################
##
#F  Dimension( <C> )  . . . . . . . . . . . . . . . . . . . . . . . . . . .  
##
##  has a global dispatcher
##
CodeOps.Dimension := function(C)
    if IsLinearCode(C) then
        return Dimension(C);
    else
        Error("dimension is only defined for linear codes");
    fi;
end;

LinCodeOps.Dimension := function(C)
    if IsBound(C.generatorMat) then
        return Length( C.generatorMat );
    else
        return WordLength(C) - Length( C.checkMat );
    fi;
end;

CycCodeOps.Dimension := function(C)
    if IsBound( C.generatorPol ) then
        return WordLength(C) - Degree(C.generatorPol);
    else
        return Degree(C.checkPol);
    fi;
end;


#############################################################################
##
#F  Elements( <C> ) . . . . . . . . . . . .  returns all the codewords of <C>
##
##  has a global dispatcher
##
CodeOps.Elements := function(C)
    return C.elements;
end;

LinCodeOps.Elements := function(C)
    local G, F, FieldEls, FieldEl, CodeEls, CodeEl, i, temp;
    
    F := Field(C);
    G := GeneratorMat(C);
    if G = [] then
        return [NullWord(C)];
    fi;
    FieldEls := Elements(F){[2 .. Size(F)]};
    CodeEls := [0 * G[1]];
    for i in Dimension(C) + 1 - [1 .. Dimension(C)] do
        temp := [];
        for FieldEl in FieldEls do
            for CodeEl in CodeEls do
                Add(temp, CodeEl + FieldEl * G[i]);
            od;
        od;
        Append(CodeEls, temp);
    od;
    return Codeword(CodeEls, F);
end;
	
CycCodeOps.Elements := function(C)
    local El;
    El := LinCodeOps.Elements(C);
    TreatAsPoly(El);
    return El;
end;

#############################################################################
##
#F  Field( <C> )  . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
##
##  has a global dispatcher
##
CodeOps.Field := function(C)
    if not IsBound(C.baseField) then
        C.baseField := DefaultField(Flat(VectorCodeword(Elements(C))));
    fi;
    return C.baseField;
end;
  
LinCodeOps.Field := function(C)
    if not IsBound(C.baseField) then
        if IsBound(C.generatorMat) then
            C.baseField := DefaultField(Flat(C.generatorMat));
        else
            C.baseField := DefaultField(Flat(C.checkMat));
        fi;
    fi;
    return C.baseField;
end;

CycCodeOps.Field := function(C)
    if not IsBound(C.baseField) then
        if IsBound(C.generatorPol) then
            C.baseField := C.generatorPol.baseRing;
        else
            C.baseField := C.checkPol.baseRing;
        fi;
    fi;
    return C.baseField;
end;

#############################################################################
##
#F  Size( <C> ) . . . . . . . . . . .  returns the number of codewords of <C>
##
##  has a global dispatcher
##
CodeOps.Size := function(C)
    return Length(Elements(C));
end;

LinCodeOps.Size := function(C)
    return Size(Field(C)) ^ Dimension(C);
end;

CycCodeOps.Size := LinCodeOps.Size;

#############################################################################
##
#F  Redundancy( <C> ) . . . . . . . . . . . . . . . . . . . . . . . . . . .  
##
##  has a global dispatcher
##
Redundancy := function (C)
    if not IsBound(C.redundancy) then
        C.redundancy := C.operations.Redundancy(C);
    fi;
    return C.redundancy;
end;

CodeOps.Redundancy := function(C)
    if IsLinearCode(C) then
        return Redundancy(C);
    else
        Error("redundancy is only defined for linear codes");
    fi;
end;

LinCodeOps.Redundancy := function(C)
    return WordLength(C) - Dimension(C);
end;

CycCodeOps.Redundancy := LinCodeOps.Redundancy;

#############################################################################
##
#F  GeneratorMat(C) . . . . .  finds the generator matrix belonging to code C
##
##  Pre: C should contain a generator or check matrix
##
GeneratorMat := function (C)
    if not IsBound(C.generatorMat) then
        C.generatorMat := C.operations.GeneratorMat(C);
    fi;
    return C.generatorMat;
end;

CodeOps.GeneratorMat := function (C)
    if IsLinearCode(C) then
        return GeneratorMat(C);
    else
        Error("non-linear codes don't have a generator matrix");
    fi;
end;

LinCodeOps.GeneratorMat := function (C)
    local G;
    if C.checkMat = [] then
        G := NullspaceMat(TransposedMat(C.checkMat));
    elif IsInStandardForm(C.checkMat, false) then      
        G := TransposedMat(Concatenation(IdentityMat(
                     Dimension(C), Field(C) ),
                     List(-C.checkMat, x->x{[1..Dimension(C) ]})));
    else 
        G := NullspaceMat(TransposedMat(C.checkMat));
    fi;
    return G;
end;

CycCodeOps.GeneratorMat := function (C)
    local F, G, p, n, i, R, zero;
    #To be inspected:
    #if IsBound(C.checkMat) and IsInStandardForm(C.checkMat, false) then
    #    G := TransposedMat(Concatenation(IdentityMat(C.dimension,C.baseField),
    #                 List(-C.checkMat, x->x{[1..C.dimension]})));
    #else
        F := Field(C);
        p := GeneratorPol(C);
        n := WordLength(C);
	G := [];
        zero := F.zero;
        for i in [1..Dimension(C)] do
            R := NullVector(i-1, F);
            Append(R, p.coefficients);
            Append(R, NullVector(n-Length(R), F));
            G[i] := R;
        od;
    #fi;
    return G;
end;

#############################################################################
##
#F  CheckMat( <C> ) . . . . . . .  finds the check matrix belonging to code C
##
##  Pre: <C> should be a linear code
##
CheckMat := function (C)
    if not IsBound(C.checkMat) then
        C.checkMat := C.operations.CheckMat(C);
    fi;
    return C.checkMat;
end;

CodeOps.CheckMat := function (C)
    if IsLinearCode(C) then
        return CheckMat(C);
    else
        Error("non-linear codes don't have a check matrix");
    fi;
end;

LinCodeOps.CheckMat := function (C)
    local H;
    if C.generatorMat = [] then
        H := IdentityMat(WordLength(C), Field(C));
    elif IsInStandardForm(C.generatorMat, true) then
        H := TransposedMat(Concatenation(List(-C.generatorMat,
                     x-> x{[Dimension(C)+1 .. WordLength(C) ]}),
                     IdentityMat(Redundancy(C), Field(C) )));
    else
        H := NullspaceMat(TransposedMat(C.generatorMat));
    fi;
    return H;
end;

CycCodeOps.CheckMat := function (C)
    local F, H, p, n, i, R, zero;
    #if IsBound(C.generatorMat) and IsInStandardForm(C.generatorMat, true) then
    #    H := TransposedMat(Concatenation(List(-C.generatorMat, x-> 
    #                 x{[C.dimension+1..C.wordLength]}),
    #                 IdentityMat(C.redundancy, C.baseField)));
    #else
        F := Field(C);
        H := [];
        p := CheckPol(C);
        p := X(F)^Dimension(C)*Value(p,X(F)^-1);
        n := WordLength(C);
        zero := F.zero;
        for i in [1..Redundancy(C)] do
            R := NullVector(i-1, F);
            Append(R, p.coefficients);
            Append(R, NullVector(n-Length(R), F));
            H[i] := R;
        od;
    #fi;
    return H;
end;

#############################################################################
##
#F  IsCyclicCode( <C> ) . . . . . . . . . . . . . . . . . . . . . . . . . .  
##
IsCyclicCode := function(C)
    if not IsCode(C) then
        return false;
    fi;
    if IsBound(C.isCyclicCode) then
        return C.isCyclicCode;
    fi;
    C.isCyclicCode := C.operations.IsCyclicCode(C);
    return C.isCyclicCode;
end;

CodeOps.IsCyclicCode := function(C)
    if IsLinearCode(C) then
        return IsCyclicCode(C);
    else
        return false;
    fi;
end;

LinCodeOps.IsCyclicCode := function(C)
    local C1, F, L, Gp;
    F := Field(C);
    L := List(GeneratorMat(C), g->Polynomial(F, F.one*g));
    Add(L, F.one*(X(F)^WordLength(C) - 1));
    Gp := Gcd(L);
    if Redundancy(C) = Degree(Gp) then
        #Add(C.name, "Converted to cyclic code");
        C.generatorPol := Gp;
        C.operations := CycCodeOps;
        Unbind(C.elements);
        Unbind(C.generatorMat);
        Unbind(C.checkMat);
        Unbind(C.syndromeTable);
        return true;
    else
        return false; #so the code is not cyclic
    fi;
end;

#############################################################################
##
#F  GeneratorPol( <C> ) . . . . . . . . returns the generator polynomial of C
##
##  Pre: C must have a generator or check polynomial
##
GeneratorPol := function (C)
    if not IsBound(C.generatorPol) then
        C.generatorPol := C.operations.GeneratorPol(C);
    fi;
    return C.generatorPol;
end;

CodeOps.GeneratorPol := function(C)
    if IsCyclicCode(C) then
        return GeneratorPol(C);
    else
        Error("generator polynomial is only defined for cyclic codes");
    fi;
end;

LinCodeOps.GeneratorPol := CodeOps.GeneratorPol;

CycCodeOps.GeneratorPol := function(C)
    local F;
    F := Field(C);
    return EuclideanQuotient(F.one*(X(F)^WordLength(C)-1),C.checkPol);
end;

#############################################################################
##
#F  CheckPol( <C> ) . . . . . . . .  returns the parity check polynomial of C
##
##  Pre: C must have a generator or check polynomial 
##
CheckPol := function (C)
    if not IsBound(C.checkPol) then
        C.checkPol := C.operations.CheckPol(C);
    fi;
    return C.checkPol;
end;

CodeOps.CheckPol := function(C)
    if IsCyclicCode(C) then
        return CheckPol(C);
    else
        Error("generator polynomial is only defined for cyclic codes");
    fi;
end;

LinCodeOps.CheckPol := CodeOps.CheckPol;

CycCodeOps.CheckPol := function(C)
    local F, n;
    F := Field(C);
    n := WordLength(C);
    return EuclideanQuotient(F.one*(X(F)^n-1),C.generatorPol);
end;

#############################################################################
##
#F  MinimumDistance( <C> [, <w>] )  . . . .  determines the minimum distance 
##
##  MinimumDistance( <C> ) determines the minimum distance of <C>
##  MinimumDistance( <C>, <w> ) determines the minimum distance to a word <w>
##
MinimumDistance := function (arg)
    local C;
    if Length(arg) = 1 then
        C := arg[1];
        if UpperBoundMinimumDistance(C) <> LowerBoundMinimumDistance(C) then
            C.lowerBoundMinimumDistance := C.operations.MinimumDistance(C);
            C.upperBoundMinimumDistance := C.lowerBoundMinimumDistance;
        fi;
        return C.lowerBoundMinimumDistance;
    elif Length(arg) = 2 then
    	return arg[1].operations.MinimumDistance(arg[1],arg[2]);
    else
        Error("usage: MinimumDistance( <C> [, <w> ])");
    fi;
end;
          
CodeOps.MinimumDistance := function(arg)
    local C, W, El, F, n, zero, d, w, DD;
    if IsLinearCode(arg[1]) then
        return ApplyFunc(MinimumDistance, arg);
    elif Length(arg) = 1 then
        C := arg[1];
        W := VectorCodeword(Elements(C), C);
        El := W;  # so not a copy!
    elif Length(arg) = 2 then
        C := arg[1];
        if arg[2] in C then
            return 0;
        fi;
        W := [VectorCodeword(arg[2],C)];
        El := VectorCodeword(Elements(C));
    else
        Error("usage: MinimumDistance( <C> [, <w>] )");
    fi;
    F := Field(C);
    n := WordLength(C);
    zero := F.zero;
    d := n;
    DD := NullVector(n+1);
    for w in W do
        DD := DD + DistancesDistributionVecFFEsVecFFE(El, w);
    od;
    d := PositionProperty([2..n+1], i->DD[i] <> 0);
    return d;
end;

LinCodeOps.MinimumDistance := function(arg)
    local Mat, n, k, zero, UP, G, W, multiple, weight,
          ThisGIsDone,  #is true as the latest matrix is converted
          Icount,       #number of corrected generatormatrices
          i,            #first rownumber which could be added to I
          l,            #columnnumber which could be used
          IdentityColumns,
          j, CurW, UMD, C, w, q, tmp;
    
    C := arg[1];
    k := Dimension(C);
    n := WordLength(C);
    zero := Field(C).zero;
    q := Size(Field(C));
    if Length(arg) = 1 then
        if k = 0 then
            return n;
        elif k = n then
            return 1;
        elif IsBound(C.weightDistribution) then
            i := PositionProperty(C.weightDistribution{[2..n+1]},i-> i <> 0);
            return i;
#        elif IsBound(C.syndromeTable) then
#            do something with that info
        fi;
        w := NullVector(n, Field(C));
        UMD := UpperBoundMinimumDistance(C);
        CurW := 1;
    else
        w := VectorCodeword(arg[2]);
        if w in C then
            return 0;
        elif k = 0 then
            return WeightCodeword(Codeword(w));
        elif IsBound(C.syndromeTable) then
            j := 1;
            w := VectorCodeword( Syndrome(C, w) );
            for i in [ 0 .. k - 1 ] do
                if w[ k - i ] <> zero then
                    j := j + q^i * ( LogFFE( w[ k - i ] ) + 1 );
                fi;
            od;
            return WeightCodeword(SyndromeTable(C)[j][1]);
        fi;
        UMD := WeightCodeword(Codeword(w));
                   #this must be so, because the kernel function
                   #can not find this distance
        CurW := 0; 
    fi;
    Mat := Copy(GeneratorMat(C));
    i := 1;
##  The next lines could go etwas faster for cyclic codes by weighting the
##  generator polynomial, but a copy of this function must be made in the
##  CycCodeOps, which makes it harder to make changes. 
    if q = 2 then
        if IsSelfOrthogonalCode(C) and Length(arg) = 1 then
            multiple := 4;
        else
            multiple := 2;
        fi;
        repeat
            weight := 0;
            for j in Mat[i] do
                if not j = zero then
                    weight := weight + 1;
                fi;
            od;
            multiple := Gcd( multiple, weight );
            i := i + 1;
        until multiple = 1 or i > k;
    elif q = 4 and IsSelfOrthogonalCode(C) and Length(arg) = 1 then
        repeat
            weight := 0;
            for j in Mat[i] do
                if not j = zero then
                    weight := weight + 1;
                fi;
            od;
            i := i + 1;
        until weight mod 4 <> 0 or i > k;
	if weight mod 4 = 0 then
	    multiple := 4;
        else
            multiple := 1;
        fi;
    elif q = 3 and IsSelfOrthogonalCode(C) and Length(arg) = 1 then
        multiple := 3;
    else
        multiple := 1;
    fi;
# we now know that the weight of all the elements are a multiple of multiple
    UP := List([1..n], i->false);   #which columns are already used
    G := [];
    W := [];
    Icount := 0;
    
    repeat
        ThisGIsDone := false;
        i := 1;                   # i is the row of the identitymatrix it
        l := 1;                   # is trying to make
        IdentityColumns := [];
        while not ThisGIsDone and (l <= n) do
            if not UP[l] then     # try this column if it is not already used
                j := i;      
                while (j <= k) and (Mat[j][l] = zero) do 
                    j := j + 1;   # go down in the matrix until a nonzero
                od;               # entry is found
                if j <= k then
                    if j > i then
                        tmp := Mat[i];
                        Mat[i] := Mat[j];
                        Mat[j] := tmp;
                    fi;
                    Mat[i] := Mat[i]/Mat[i][l];
                    for j in Concatenation([1..i-1], [i+1..k]) do
                        if Mat[j][l] <> zero then
                            Mat[j] := Mat[j] - Mat[j][l]*Mat[i];
                        fi;
                    od;
                    UP[l] := true;
                    Add(IdentityColumns, l);
                    i := i + 1;
                    ThisGIsDone := ( i > k );
                fi;
            fi; 
            l := l + 1;
        od;
        if ThisGIsDone then
            Icount := Icount + 1;
            Add( G, Mat{[1..k]}{Difference([1..n],IdentityColumns)} );
            w := w-w{IdentityColumns}*Mat;
            Add(W,w{Difference([1..n], IdentityColumns)} );
            if Length(arg) = 2 then
                UMD := Minimum( UMD, WeightCodeword( Codeword( w ) ) );
            fi;
## G_i is generator matrix i
## W_i has zeros in IdentityColumns,
## but has same distance to code because
## only a codeword is added
        fi;
    until not ThisGIsDone or ( Icount = Int( n / k ) );

    while CurW <= ( UMD - multiple ) / Icount do
        i := 0;
        repeat
            i := i + 1;
            UMD := Minimum( UMD, DistanceVecFFE( W[i],
                                   AClosestVectorCombinationsMatFFEVecFFE(
                                     G[i], q, W[i], CurW, CurW*(Icount-1) )
                                   ) + CurW );
        until (i = Length(G)) or (UMD = CurW*Icount);
        CurW := CurW + 1;
    od;
    return UMD;
end;
           
CycCodeOps.MinimumDistance := function( arg )
    if Length(arg) = 1 then
        return MinimumDistance( PuncturedCode( arg[1] ) ) + 1;
    else
        return LinCodeOps.MinimumDistance(arg[1], arg[2]);
    fi;
end;

#############################################################################
##
#F  LowerBoundMinimumDistance( arg )  . . . . . . . . . . . . . . . . . . .  
##
LowerBoundMinimumDistance := function(arg)
    # not yet dispatched because it has no use yet
    if Length(arg) = 1 and IsCode(arg[1]) then
        return arg[1].operations.LowerBoundMinimumDistance(arg[1]);
    elif Length(arg) = 2 then
            return BoundsMinimumDistance(arg[1],arg[2],2,true).lowerBound;
    elif Length(arg) = 3 then
            return BoundsMinimumDistance(arg[1],arg[2],arg[3],true).lowerBound;
    else
        Error("usage: LowerBoundMinimumDistance( <C> | <n, k [, q ]> )");
    fi;
end;

CodeOps.LowerBoundMinimumDistance := function(C)
    if not IsBound(C.lowerBoundMinimumDistance) then
        C.lowerBoundMinimumDistance := 1;
    fi;
    if Size(C) = 1 then
        C.lowerBoundMinimumDistance := WordLength( C );
    fi;
    return C.lowerBoundMinimumDistance;
end;

LinCodeOps.LowerBoundMinimumDistance := function(C)
    if not IsBound(C.lowerBoundMinimumDistance) then
        C.lowerBoundMinimumDistance := 1;
    fi;
    if Dimension(C) = 0 then
        C.lowerBoundMinimumDistance := WordLength( C );
    elif Dimension(C) = 1 then
        C.lowerBoundMinimumDistance := WeightCodeword( Codeword(
                                               GeneratorMat(C)[1] ) );
    fi;
    return C.lowerBoundMinimumDistance;
end;

CycCodeOps.LowerBoundMinimumDistance := function(C)
    if not IsBound(C.lowerBoundMinimumDistance) then
        C.lowerBoundMinimumDistance := 1;
    fi;
    if Dimension(C) = 0 then
        C.lowerBoundMinimumDistance := WordLength( C );
    elif Dimension(C) = 1 then
        C.lowerBoundMinimumDistance := WeightCodeword( Codeword(
                                               GeneratorPol(C) ) );
    fi;
    return C.lowerBoundMinimumDistance;
end;

#############################################################################
##
#F  UpperBoundMinimumDistance( arg )  . . . . . . . . . . . . . . . . . . .  
##
UpperBoundMinimumDistance := function(arg)
    if Length(arg) = 1 and IsCode(arg[1]) then
        # the .operations is always called because it may want to calculate
        # the minimumweight of the generators
        return arg[1].operations.UpperBoundMinimumDistance(arg[1]);
    elif Length(arg) = 2 then
            return BoundsMinimumDistance(arg[1],arg[2],2,false).upperBound;
    elif Length(arg) = 3 then
          return BoundsMinimumDistance(arg[1],arg[2],arg[3],false).upperBound;
    else
        Error("usage: UpperBoundMinimumDistance( <C> | <n, k [, q ]> )");
    fi;
end;

CodeOps.UpperBoundMinimumDistance := function(C)
    if not IsBound(C.upperBoundMinimumDistance) then
        C.upperBoundMinimumDistance := WordLength(C);
    fi;
    return C.upperBoundMinimumDistance;
end;

LinCodeOps.UpperBoundMinimumDistance := function(C)
    local zero, row, element, sum;
    if not IsBound(C.upperBoundMinimumDistance) then
        C.upperBoundMinimumDistance := WordLength(C);
    fi;
    if not IsBound(C.minimumWeightOfGenerators) then
        zero := Field(C).zero;
        C.minimumWeightOfGenerators := WordLength(C);
        if Dimension(C) > 0 then
            # minimumWeightOfGenerators for null codes is n
            for row in GeneratorMat(C) do
                sum := 0;
                for element in row do
                    if element <> zero then
                        sum := sum + 1;
                    fi;
                od;
                if sum < C.minimumWeightOfGenerators then
                    C.minimumWeightOfGenerators := sum;
                fi;
            od;
        fi;
    fi;
    if C.minimumWeightOfGenerators < C.upperBoundMinimumDistance then
        C.upperBoundMinimumDistance := C.minimumWeightOfGenerators;
    fi;
    if not IsBound(C.upperBoundOptimalMinimumDistance) then
        C.upperBoundOptimalMinimumDistance := BoundsMinimumDistance(
                     WordLength(C), Dimension(C), Field(C), false ).upperBound;
    fi;
    if C.upperBoundOptimalMinimumDistance < C.upperBoundMinimumDistance then
        C.upperBoundMinimumDistance := C.upperBoundOptimalMinimumDistance;
    fi;
    return C.upperBoundMinimumDistance;
end;

CycCodeOps.UpperBoundMinimumDistance := function(C)
    if not IsBound(C.upperBoundMinimumDistance) then
        C.upperBoundMinimumDistance := WordLength(C);
    fi;
    if not IsBound(C.minimumWeightOfGenerators) then
        if Dimension(C) > 0 then
            # minimumWeightOfGenerators of null codes is n
            C.minimumWeightOfGenerators := WeightCodeword(
                                                 Codeword(GeneratorPol(C)));
        else
            C.minimumWeightOfGenerators := WordLength(C);
        fi;
    fi;
    if C.minimumWeightOfGenerators < C.upperBoundMinimumDistance then
        C.upperBoundMinimumDistance := C.minimumWeightOfGenerators;
    fi;
    if not IsBound(C.upperBoundOptimalMinimumDistance) then
        C.upperBoundOptimalMinimumDistance := BoundsMinimumDistance(
                  WordLength(C), Dimension(C), Field(C), false ).upperBound;
    fi;
    if C.upperBoundOptimalMinimumDistance < C.upperBoundMinimumDistance then
        C.upperBoundMinimumDistance := C.upperBoundOptimalMinimumDistance;
    fi;
    return C.upperBoundMinimumDistance;
end;

#############################################################################
##
#F  MinimumWeightWords( <C> ) . . .  returns the code words of minimum weight
##
MinimumWeightWords := function(C)
    return C.operations.MinimumWeightWords(C);
end;

CodeOps.MinimumWeightWords := function(C)
    local curmin, res, e, w, zerovec;
    if IsLinearCode(C) then
        return MinimumWeightWords(C);
    fi;
    curmin := WordLength(C);
    if not IsBound(C.weightDistribution) then
        res := [];
        for e in Elements(C) do
            w := WeightCodeword(e);
            if w < curmin and w <> 0 then
                # New minimum weight found
                curmin := w;
                res := [ e ];
            elif w = curmin then
                Add(res, e);
            fi;
        od;
        return res;
    else
        # Find the minimum weight
        w := PositionProperty(WeightDistribution(C){[2..WordLength(C)]},
                     e -> e <> 0);
        if w = false then
            return NullVector(WordLength(C), Field(C));
        else
            return Filtered(Elements(C), e -> WeightCodeword(e) = w);
        fi;
    fi;
end;

LinCodeOps.MinimumWeightWords := function(C)
    local d, G, res, vector, count, i, t, k, q, M, zerovec;
    d := MinimumDistance(C);  # Equal to minimum weight
    G := GeneratorMat(C);
    k := Dimension(C);
    q := Size(Field(C));
    M := Size(C);
    res := [];
    vector := NullVector(WordLength(C), Field(C));
    zerovec := Copy(vector);
    count := 1;
    while count < M do
        # Calculate next word in the code
        i := k;
        t := count;
        while t mod q = 0 do
            t := t / q;
            i := i - 1;
        od;
        vector := vector + G[i];
        if DistanceVecFFE(vector, zerovec) = d then
            # This word has minimum weight
            Add(res, Codeword(vector));
        fi;
        count := count + 1;
    od;
    return res;
end;

CycCodeOps.MinimumWeightWords := LinCodeOps.MinimumWeightWords;

#############################################################################
##
#F  WeightDistribution( <C> ) . . . returns the weight distribution of a code
##
WeightDistribution := function (C)
    if not IsBound(C.weightDistribution) then
        C.weightDistribution := C.operations.WeightDistribution(C);
    fi;
    return C.weightDistribution;
end;

CodeOps.WeightDistribution := function (C)
    local El, nl, newwd;
    if IsLinearCode(C) then
        return WeightDistribution(C);
    fi;
    El := VectorCodeword(Elements(C));
    nl := VectorCodeword(NullWord(C));
    newwd := DistancesDistributionVecFFEsVecFFE(El, nl);
    return newwd;
end;

LinCodeOps.WeightDistribution := function(C)
    local G, nl, k, n, q, wd, newwd, oldrow, newrow, i, j;
    n := WordLength(C);
    k := Dimension(C);
    q := Size(Field(C));
    nl := VectorCodeword(NullWord(C));
    if k = 0 then
        G := NullVector(n+1);
        G[1] := 1;
        newwd := G;
    elif k = n then
        newwd := List([0..n], i->Binomial(n, i));
    elif k <= Int(n/2) then
	G := Copy(GeneratorMat(C));
        newwd := DistancesDistributionMatFFEVecFFE(G, q, nl);
    else
        G := Copy(CheckMat(C));
        wd := DistancesDistributionMatFFEVecFFE(G, q, nl);
        newwd := [Sum(wd)];
        oldrow := List([1..n+1], i->1);
        newrow := [];
        for i in [2..n+1] do
            newrow[1] := Binomial(n, i-1) * (q-1)^(i-1);
            for j in [2..n+1] do
                newrow[j] := newrow[j-1] - (q-1) * oldrow[j] - oldrow[j-1];
            od;
            newwd[i] := newrow * wd;
            oldrow := Copy(newrow);
        od;
        newwd:= newwd / (q ^ Redundancy(C));
    fi;
    return newwd;
end;

CycCodeOps.WeightDistribution := LinCodeOps.WeightDistribution;

#############################################################################
##
#F  InnerDistribution( <C> )  . . . . . .  the inner distribution of the code
##
##  The average distance distribution of distances between all codewords
##
InnerDistribution := function (C) 
    if not IsBound(C.innerDistribution) then
        C.innerDistribution := C.operations.InnerDistribution(C);
    fi;
    return C.innerDistribution;
end;

CodeOps.InnerDistribution := function (C)
    local ID, c, El;
    El := VectorCodeword(Elements(C));
    ID := List([1..WordLength(C)+1], i->0);
    for c in El do
        ID := ID + DistancesDistributionVecFFEsVecFFE(El, c);
    od;
    return ID/Size(C);
end;

LinCodeOps.InnerDistribution := function (C)
    return WeightDistribution(C);
end;

CycCodeOps.InnerDistribution := LinCodeOps.InnerDistribution;

#############################################################################
##
#F  OuterDistribution( <C> )  . . . . . . . . . . . . . . . . . . . . . . .  
##
##  the number of codewords on a distance i from all elements of GF(q)^n
##
OuterDistribution := function(C)
    if not IsBound(C.outerDistribution) then
       C.outerDistribution := C.operations.OuterDistribution(C);
    fi;
    return C.outerDistribution;
end;

CodeOps.OuterDistribution := function (C)
    local Code, vector, d, n, q, one, count, size, t, i, j, res, zero, large,
          LocalDistance, AddOneToVector, dd, nulld, c, Makeword;

    if IsLinearCode(C) then
        return OuterDistribution(C);
    fi;
    q := Size(Field(C));
    n := WordLength(C);
    size := Size(C);
    one := Field(C).one;
    if q = 2 then
        Code := List(VectorCodeword(Elements(C)), i -> BlistList(i, [one]));
        vector := List([1..n], i-> false);
        zero := false;
        large := true;
        AddOneToVector := function(t) vector[t] := true; end;
        LocalDistance := DistanceBlist;
        Makeword := function(c)
            local i, res;
            res := [];
            for i in [1..n] do
                if c[i] then
                    res[i] := 1;
                else
                    res[i] := 0;
                fi;
            od;
            return Codeword(res);
        end;
    else
        zero := Field(C).zero;
        if IsPrimeInt(q) then
            Code := IntVecFFE(VectorCodeword(Elements(C)));
        else
            Code := List(VectorCodeword(Elements(C)), i -> List(i, function(j) 
                if j = zero then
                    return 0;
                else
                    return LogFFE(j,Z(q))+1; fi;
                end));
            fi;
            vector := NullVector(n);
            zero := 0;
            large := q-1;
            AddOneToVector := function(t) vector[t] := vector[t] + 1; end;
            LocalDistance := function(a,b)
                j := 0;
                for i in [1..n] do
                    if a[i] <> b[i] then
                        j := j + 1;
                    fi;
                od;
                return j;
            end;
            Makeword := function(c)
                return Codeword(c);
        end;
    fi;
    res := [[Makeword(vector), WeightDistribution(C)]];
    nulld := NullVector(n+1);
    for count in [2..q^n] do
        # Make next vector
        t := n;
        while vector[t] = large do
            vector[t] := zero;
            t := t - 1;
        od;
        AddOneToVector(t);
        # Calculate distances to vector
        dd := Copy(nulld);
        for c in Code do
            d := LocalDistance(c, vector) + 1;
            dd[d] := dd[d] + 1;
        od;
        Add(res, [Makeword(vector), dd]);
    od;
    return res;
end;

LinCodeOps.OuterDistribution := function(C)
    local STentry, dtw, E, res, i;
    E := C.operations.Elements(C);
    res := [];
    for STentry in List(SyndromeTable(C), i -> i[1]) do
        dtw := DistancesDistribution(C, STentry);
        for i in E do
            Add(res, [STentry.vector + i, dtw]);
        od;
    od;
    return res;
end;

CycCodeOps.OuterDistribution := LinCodeOps.OuterDistribution;

#############################################################################
##
#F  CoveringRadius( <C> ) . . . . . . . . . . . .  the covering radius of <C>
##
##  Not useful for large codes.
##
##  This stuff is now in 'codecr.g'
##
# CoveringRadius := function (C)
#     if not IsBound(C.coveringRadius) then
#         C.coveringRadius := C.operations.CoveringRadius(C);
#     fi;
#     return C.coveringRadius;
# end;
# 
# CodeOps.CoveringRadius := function (C)
#     local Code, vector, d, curmax, n, q, one, count, size, t, i, j,
#     LocalDistance, zero, large, AddOneToVector;
# 
#     if IsLinearCode(C) then
#         return CoveringRadius(C);    
#     fi;
#     q := Size(Field(C));
#     n := WordLength(C);
#     size := Size(C);
#     one := Field(C).one;
#     if q = 2 then
#         Code := List(VectorCodeword(Elements(C)), i -> BlistList(i, [one]));
#         vector := List([1..n], i-> false);
#         zero := false;
#         large := true;
#         AddOneToVector := function(t) vector[t] := true; end;
#         LocalDistance := DistanceBlist;
#     else
#         zero := Field(C).zero;
#         if IsPrimeInt(q) then
#             Code := IntVecFFE(VectorCodeword(Elements(C)));
#         else
#             Code := List(VectorCodeword(Elements(C)), i -> List(i, function(j) 
#                 if j = zero then
#                     return 0;
#                 else return LogFFE(j,Z(q))+1; fi;
#             end));
#         fi;
#         vector := List([1..n], i-> 0);
#         zero := 0;
#         large := q-1;
#         AddOneToVector := function(t) vector[t] := vector[t] + 1; end;
#         LocalDistance := function(a,b)
#             j := 0;
#             for i in [1..n] do
#                 if a[i] <> b[i] then j := j + 1; fi;
#             od;
#             return j;
#         end;
#     fi;
#     curmax := n;
#     for t in Code do
#         d := LocalDistance(t, vector);
#         if d < curmax then
#             curmax := d;
#         fi;
#     od;
#     for count in [2..q^n] do
#         t := n;
#         while vector[t] = large do
#             vector[t] := zero;
#             t := t - 1;
#         od;
#         AddOneToVector(t);
#         t := 1;
#         repeat
#             d := LocalDistance(Code[t], vector);
#             t := t + 1;
#         until d <= curmax or t > size;
#         if d > curmax then
#             curmax := n;
#             for t in Code do
#                 d := LocalDistance(t, vector);
#                 if d < curmax then
#                     curmax := d;
#                 fi;
#             od;
#         fi;
#     od;
#     return curmax;
# end;
# 
# LinCodeOps.CoveringRadius := function(C)
#     if Redundancy(C) = 0 then
#         return 0;
#     else
#         return Maximum(List(SyndromeTable(C), i->WeightCodeword(i[1])));
#     fi;
# end;
# 
# CycCodeOps.CoveringRadius := LinCodeOps.CoveringRadius;

#############################################################################
##
#F  Decode( <C>, <c> )  . . . . . . . . .  decodes the codeword(s) c from <C>
##
##  c can be a codeword or a list of codewords
##
Decode := function (C, c)
    local n, i, s, go;

    c := Codeword(c,Field(C));
    if IsList(c) then
        return List(c, i -> Decode(C, i));
    else
        if IsBound(C.specialDecoder) then
            return C.specialDecoder(C, c);
        elif IsBound(C.operations.Decode) then
            return C.operations.Decode(C, c);
        else
            Error("no decoder present");
        fi;
    fi;
end;
    
LinCodeOps.Decode := function(C, c)
    local S, syn, index, corr, Gt, i, x, F;
    F := Field(C);
    S := SyndromeTable(C);
    syn := Syndrome(C, c);
    index := 0;
    repeat
        index := index + 1;
    until S[index][2] = syn;
    corr := VectorCodeword(c - S[index][1]);	     # correct codeword
    x := SolutionMat(GeneratorMat(C), corr);
    return Codeword(x,Field(C));
end;
  
CycCodeOps.Decode := function(C, r)
    return LinCodeOps.Decode(C, VectorCodeword(r, C));
end;

#############################################################################
##
#F  IsSelfDualCode( <C> ) . . . . . . . . . determines whether C is self dual
##
##  i.o.w. each codeword is orthogonal to all codewords (including itself)
##
IsSelfDualCode := function(C)
    if not IsBound(C.isSelfDualCode) then
        C.isSelfDualCode := C.operations.IsSelfDualCode(C);
    fi;
    return C.isSelfDualCode;
end;

CodeOps.IsSelfDualCode := function(C)
    return false;
end;

LinCodeOps.IsSelfDualCode := function(C)
    local ISD;
    if Redundancy(C) <> Dimension(C) then
        return false; #so the code is not self dual
    else
        return (GeneratorMat(C)*TransposedMat(GeneratorMat(C)) = 
                NullMat(Dimension(C),Dimension(C),Field(C))) and
               (Dimension(C) = Redundancy(C));
    fi;
    return ISD;
end;

CycCodeOps.IsSelfDualCode := function(C)
    local r;
    if Redundancy(C) <> Dimension(C) then
        return false; #so the code is not self dual
    else
        r := ReciprocalPolynomial(GeneratorPol(C),Redundancy(C));
        r := r/LeadingCoefficient(r);
        return CheckPol(C) = r;
    fi;
end;

#############################################################################
##
#F  \*( <l>, <C> )  . . . . .  the codeword belonging to information vector x
##
##  only valid if C is linear! Has a global dispatcher
##
CodeOps.\* := function(l, C)
    if IsLinearCode(C) then
        return l*C;
    elif IsCode(l) then
    	return DirectProductCode(l, C); # always signals an error
    else
    	Error("<r> is a non-linear code");# encoding not possible
    fi;
end;

LinCodeOps.\* := function (l, C)
    local s, i, k;
    if IsCyclicCode(C) then
        return l*C;
    elif IsCode(l) then
    	return DirectProductCode(l, C);
    else
        l := VectorCodeword(l, Dimension(C), Field(C));
	if GeneratorMat(C) = [] then
            return NullMat(Length(l), WordLength(C), Field(C));
        else
            return Codeword(l*GeneratorMat(C), C);
        fi;
    fi;
end;

CycCodeOps.\* := function(l, C)
    local F, p;
    F := Field(C);
    if IsCode(l) then
            return DirectProductCode(l, C);
    else
        l := Codeword(l, Dimension(C), F);
        if IsList(l) then
            return List(l, i-> i*C);
        else
            return Codeword(PolyCodeword(l) * GeneratorPol(C), C);
        fi;
    fi;
end;  

#############################################################################
##
#F  \+( <l>, <C> )  . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
##
##  Has a global dispatcher
##
CodeOps.\+ := function(l, C)
    if not IsCode(C) then 
    	return C+l;
    elif IsCode(l) then
        return DirectSumCode(l, C);
    else
        l := Codeword(l);
        return CosetCode(C, Codeword(l,C));
    fi;
end;
  
LinCodeOps.\+ := CodeOps.\+;

CycCodeOps.\+ := CodeOps.\+;

#############################################################################
##
#F  \in( <l>, <C> ) . . . . . .  true if the vector is an element of the code
##
##  Has a global dispatcher.
##
CodeOps.\in := function(l,C)
    if IsCode(l) then
        l := Copy(Elements(l));
    fi;
    l := Codeword(l);
    if IsList(l) then
        return ForAll(l, i-> i in C);
    elif IsCodeword(l) then
        if WordLength(l) <> WordLength(C) then
        	return false; #so l is not in C
        else 
            return l in C.elements;
        fi;
    else 
        Error("usage: <codeword | mat | code> in <code>");
    fi;
end;

LinCodeOps.\in := function(l, C)
    if IsCode(l) then
        if IsLinearCode(l) then
            l := GeneratorMat(l);
        else
            l := Elements(l);
        fi;
    fi;
    l := Codeword(l, Field(C));
    if IsList(l) then 
        return ForAll(l, i->i in C);
    else
        if WordLength(l) <> WordLength(C) then 
            return false; #so l is not in C
        elif GeneratorMat(C) = [] then
            return WeightCodeword(l) = 0;
        elif CheckMat(C) = [] then
            return Field(l) = Field(C);
        else
            return WeightCodeword(CheckMat(C)*l) = 0;
        fi;
    fi;
end;

CycCodeOps.\in := function(l, C)
    local p, F;
    if IsCode(l) then
        if IsCyclicCode(l) then
            return GeneratorPol(l) mod GeneratorPol(C) = 0*X(Field(C));
        elif IsLinearCode(l) then
            l := GeneratorMat(l);
        else
            l := Elements(l);
        fi;
    fi;
    l := Codeword(l, C);
    if IsList(l) then
        return ForAll(l, i -> i in C);
    elif IsCodeword(l) then
        return PolyCodeword(l) mod GeneratorPol(C) = Field(C).zero*X(Field(C));
    else
        Error("usage: <list | mat | code> in <code>");
    fi;
end;
  
#############################################################################
##
#F  \=( <C1>, <C2> )  . . . . .  tests if Set(Elements(C1))=Set(Elements(C2))
##
##  Has a global dispatcher.
##  Post: returns a boolean
##
CodeOps.\= := function(l, r)
    local field, fields;
    if not (IsCode(r) and IsCode(l)) then
        return false; #so l is not equal to r
    elif IsLinearCode(l) then
        return r = l;
    else
        if Set(Elements(l)) = Set(Elements(r)) then
            fields := ["weightDistribution", "innerDistribution",
                       "boundsCoveringRadius",
                       "isLinearCode", "isPerfectCode",
                       "isSelfDualCode", "outerDistribution", "isCyclicCode",
                       "automorphismGroup"];
            for field in fields do 
                if not IsBound(l.(field)) then
                    if IsBound(r.(field)) then
                        l.(field) := r.(field);
                    fi;
                else
                    if not IsBound(r.(field)) then
                        r.(field) := l.(field);
                    fi;
                fi;
            od;
            l.lowerBoundMinimumDistance := Maximum(LowerBoundMinimumDistance(l), LowerBoundMinimumDistance(r));
            r.lowerBoundMinimumDistance := l.lowerBoundMinimumDistance;
            l.upperBoundMinimumDistance := Minimum(UpperBoundMinimumDistance(l), UpperBoundMinimumDistance(r));
            r.upperBoundMinimumDistance := UpperBoundMinimumDistance(l);
            return true;
        else
            return false; #so l is not equal to r
        fi;
    fi;
end;

LinCodeOps.\= := function(l, r)
    local field, fields;
    if not (IsCode(l) and IsCode(r)) then
        return false;  #so l is not equal to r
    elif IsCyclicCode(l) then
        return r = l;
    elif IsLinearCode(l) then
        if BaseMat(GeneratorMat(l))=BaseMat(GeneratorMat(r)) then
            fields := ["weightDistribution", "innerDistribution",
                       "boundsCoveringRadius",
                       "isLinearCode", "isPerfectCode",
                       "isSelfDualCode", "outerDistribution", "isCyclicCode",
                       "automorphismGroup"];
            for field in fields do 
                if not IsBound(l.(field)) then
                    if IsBound(r.(field)) then
                        l.(field) := r.(field);
                    fi;
                else
                    if not IsBound(r.(field)) then
                        r.(field) := l.(field);
                    fi;
                fi;
            od;
            l.lowerBoundMinimumDistance := Maximum(LowerBoundMinimumDistance(l), LowerBoundMinimumDistance(r));
            r.lowerBoundMinimumDistance := l.lowerBoundMinimumDistance;
            l.upperBoundMinimumDistance := Minimum(UpperBoundMinimumDistance(l), UpperBoundMinimumDistance(r));
            r.upperBoundMinimumDistance := UpperBoundMinimumDistance(l);
            return true;
        else
            return false; #so l is not equal to r
        fi;
    else
        return false; #so l is not equal to r
    fi;
end;

CycCodeOps.\= := function(l, r)
    local field, fields, bmdl, bmdr;
    if not (IsCode(l) and IsCode(r)) then
        return false; #so l is not equal to r
    elif IsCyclicCode(l) and GeneratorPol(l) = GeneratorPol(r) then
        fields := ["weightDistribution", "innerDistribution",
                   "boundsCoveringRadius",
                   "isLinearCode", "isPerfectCode",
                   "isSelfDualCode", "outerDistribution", "isCyclicCode",
                   "automorphismGroup", "roots"];
        for field in fields do 
            if not IsBound(l.(field)) then
                if IsBound(r.(field)) then
                    l.(field) := r.(field);
                fi;
            else
                if not IsBound(r.(field)) then
                    r.(field) := l.(field);
                fi;
            fi;
        od;
        l.lowerBoundMinimumDistance := Maximum(LowerBoundMinimumDistance(l),
                                               LowerBoundMinimumDistance(r));
        r.lowerBoundMinimumDistance := l.lowerBoundMinimumDistance;
        l.upperBoundMinimumDistance := Minimum(UpperBoundMinimumDistance(l),
                                               UpperBoundMinimumDistance(r));
        r.upperBoundMinimumDistance := l.upperBoundMinimumDistance;
        return true;
    else
        return false; #so l is not equal to r
    fi;
end;

#############################################################################
##
#F  SyndromeTable ( <C> ) . . . . . . . . . . . . . . . a Syndrome table of C
##
SyndromeTable := function(C)
    local H, L, F;
    if not IsBound(C.syndromeTable) then
        C.syndromeTable := C.operations.SyndromeTable(C);
    fi;
    return C.syndromeTable;
end;

CodeOps.SyndromeTable := function(C)
    if IsLinearCode(C) then
        return SyndromeTable(C);
    else
        Error("the syndrome table is not defined for non-linear codes");
    fi;
end;

LinCodeOps.SyndromeTable := function(C)
    local H, L, F;
    H := CheckMat(C);
    if H = [] then
        return [];
    fi;
    F := Field(C);
    L := CosetLeadersMatFFE(H, Size(F));
    H := TransposedMat(H);
    return Codeword(List(L, l-> [l, l*H]), F);
end;

CycCodeOps.SyndromeTable := LinCodeOps.SyndromeTable;

#############################################################################
##
#F  StandardArray( <C> )  . . . . . . . . . . . . a standard array for code C
##
##  Post: returns a 3D-matrix. The first row contains all the codewords of C.
##  The other rows contain the cosets, preceded by their coset leaders.
##
StandardArray := function(C)
    if not IsBound(C.standardArray) then
        return C.operations.StandardArray(C);
    else
        return C.standardArray;
    fi;
end;

CodeOps.StandardArray := function(C)
    if IsLinearCode(C) then
        return StandardArray(C);
    else
        Error("a standard array is not defined for non-linear codes");
    fi;
end;

LinCodeOps.StandardArray := function(C)
    local Els;
    Els := Elements(C);
    if CheckMat(C) = [] then
        return [Els];
    fi;
    return List(Set( CosetLeadersMatFFE(CheckMat(C), Size(Field(C))) ),
                row -> List(Els, column -> row + column));
end;
    
CycCodeOps.StandardArray := LinCodeOps.StandardArray;

#############################################################################
##
#F  AutomorphismGroup( <C> )  . . . . . . . .  the automorphism group of code
##
##  The automorphism group is the largest permutation group of degree n such
##  that for each permutation in the group C' = C
##
AutomorphismGroup := function (C)
    if not IsBound(C.automorphismGroup) then
        if Size(Field(C)) > 2 then
            Error("Gap calculates automorphism groups for binary codes only");
        else
            C.automorphismGroup := C.operations.AutomorphismGroup(C);
        fi;
    fi;
    return C.automorphismGroup;
end;

CodeOps.AutomorphismGroup := function (C)
    if IsLinearCode(C) then
        return AutomorphismGroup(C);
    else
        return MatAutomorphisms(VectorCodeword(Elements(C)), [], Group( () ));
    fi;
end;

LinCodeOps.AutomorphismGroup := function (C)
    local incode, inV, outgroup, infile,Ccalc;
    incode :=  TmpName(); PrintTo( incode, "\n" );
    inV := TmpName(); PrintTo( inV, "\n" );
    outgroup := TmpName(); PrintTo( outgroup, "\n" );
    infile := TmpName(); PrintTo( infile, "\n" );
    # Calculate with dual code if it is smaller:
    if Dimension(C) > QuoInt(WordLength(C), 2) then
        Ccalc := DualCode(C);
    else
        Ccalc := ShallowCopy(C);
    fi;
    GuavaToLeon(Ccalc, incode);
    ExecPkg("guava","bin/`hostname`/wtdist",
            Concatenation("-q ",incode,"::code ",
            String(MinimumDistance(Ccalc))," ",inV,"::code"),".");
    ExecPkg("guava","bin/`hostname`/desauto",
            Concatenation("-code -q ",
            incode,"::code ",inV,"::code ",outgroup),".");
    ExecPkg("guava","bin/`hostname`/leonconv", 
            Concatenation("-a ",outgroup," ", infile),".");
    Read(infile);
    RemoveFiles(incode,inV,outgroup,infile);
    return GUAVA_TEMP_VAR;
end;

##  If the new partition backtrack algorithms are implemented, the previous
##  function can be replaced by the next:
#LinCodeOps.AutomorphismGroup := function(C)
#    local Ccalc, InvSet;
#    if Dimension(C) > QuoInt(WordLength(C), 2) then
#        Ccalc := DualCode(C);
#    else
#        Ccalc := ShallowCopy(C);
#    fi;
#    InvSet := VectorCodeword(MinimumWeightWords(Ccalc));
#    return AutomorphismGroupBinaryLinearCode(Ccalc, InvSet);
#end;

CycCodeOps.AutomorphismGroup := LinCodeOps.AutomorphismGroup;

#############################################################################
##
#F  IsSelfOrthogonalCode( <C> ) . . . . . . . . . . . . . . . . . . . . . .  
##
IsSelfOrthogonalCode := function(C)
    if not IsBound(C.isSelfOrthogonalCode) then
        C.isSelfOrthogonalCode := C.operations.IsSelfOrthogonalCode(C);
    fi;
    return C.isSelfOrthogonalCode;
end;

CodeOps.IsSelfOrthogonalCode := function(C)
    local El, M, zero, i, j, IsSO;
    if IsLinearCode(C) then
        return IsSelfOrthogonalCode(C);
    fi;
    El := Elements(C);
    M := Size(C);
    zero := Field(C).zero;
    i := 1; IsSO := true;
    while (i <= M-1) and IsSO do
        j := i+1;
        while (j <= M) and (El[i]*El[j] = zero) do 
            j := j + 1; 
        od;
        if j <= M then 
            IsSO := false;
        fi;
        i := i + 1;
    od;
    return IsSO;
end;

LinCodeOps.IsSelfOrthogonalCode := function(C)
    local G, k;
    G := GeneratorMat(C);
    k := Dimension(C);
    return G*TransposedMat(G) = NullMat(k,k,Field(C));
end;

CycCodeOps.IsSelfOrthogonalCode := LinCodeOps.IsSelfOrthogonalCode;
 
#############################################################################
##
#F  CodeIsomorphism( <C1>, <C2> ) . . the permutation that translates C1 into
#F                         C2 if C1 and C2 are equivalent, or false otherwise
##
CodeIsomorphism := function (C1, C2)
    if WordLength(C1) <> WordLength(C2) or Size(C1) <> Size(C2)
       or MinimumDistance(C1) <> MinimumDistance(C2)
       or Field(C1) <> Field(C2) then
        return false; #I think this is what we want (see IsEquivalentCode)
    elif C1=C2 then
        return ();
    else
        return C2.operations.CodeIsomorphism(C1, C2 );
    fi;
end;

CodeOps.CodeIsomorphism := function (C1, C2)
    local tp, field;
    tp :=  TransformingPermutations(VectorCodeword(Elements(C1)), 
                   VectorCodeword(Elements(C2)));
    if tp <> false then
        for field in ["weightDistribution", "innerDistribution",
                "boundsCoveringRadius",
                "isPerfectCode", "isSelfDualCode"] do 
            if not IsBound(C1.(field)) then
                if IsBound(C2.(field)) then
                    C1.(field) := C2.(field);
                fi;
            else
                if not IsBound(C2.(field)) then
                    C2.(field) := C1.(field);
                fi;
            fi;
        od;
        C1.lowerBoundMinimumDistance := Maximum(LowerBoundMinimumDistance(C1),
                                                LowerBoundMinimumDistance(C2));
        C2.lowerBoundMinimumDistance := LowerBoundMinimumDistance(C1);
        C1.upperBoundMinimumDistance := Minimum(UpperBoundMinimumDistance(C1),
                                                UpperBoundMinimumDistance(C2));
        C2.upperBoundMinimumDistance := UpperBoundMinimumDistance(C1);
        return tp.columns;
    else
        return false; #yes, this is right
    fi;
end;

LinCodeOps.CodeIsomorphism := function (C1, C2)
    local code1,code2,cwcode1,cwcode2,output,infile, field;
    if not IsLinearCode(C1) then
        return CodeIsomorphism(C2, C1);
    fi;
    if Field(C1) <> GF(2) then
        Error("GUAVA can only calculate equivalence over GF(2)");
    fi;
    code1 := TmpName(); PrintTo( code1, "\n" );
    code2 := TmpName(); PrintTo( code2, "\n" );
    cwcode1 := TmpName(); PrintTo( cwcode1, "\n" );
    cwcode2 := TmpName(); PrintTo( cwcode2, "\n" );
    output := TmpName(); PrintTo( output, "\n" );
    infile := TmpName(); PrintTo( infile, "\n" );
    GuavaToLeon(C1, code1);
    GuavaToLeon(C2, code2);
    ExecPkg("guava","bin/`hostname`/wtdist",
            Concatenation("-q ",code1,"::code ",
            String(MinimumDistance(C1))," ",cwcode1,"::code"),".");
    ExecPkg("guava","bin/`hostname`/wtdist",
            Concatenation("-q ",code2,"::code ",
            String(MinimumDistance(C2))," ",cwcode2,"::code"),".");
    ExecPkg("guava","bin/`hostname`/desauto",
            Concatenation("-iso -code -q ",
            code1,"::code ",code2,"::code ",cwcode1,"::code ",
            cwcode2,"::code ",output),".");
    ExecPkg("guava","bin/`hostname`/leonconv",
            Concatenation("-e ",output," ", 
            infile),".");
    Read(infile);
    RemoveFiles(code1,code2,cwcode1,cwcode2,output,infile);
    if not IsPerm(GUAVA_TEMP_VAR) then
        return false; #it is good that false is returned
    else
        for field in ["weightDistribution",
                "boundsCoveringRadius", "isPerfectCode",
                "isSelfDualCode"]  do 
            if not IsBound(C1.(field)) then
                if IsBound(C2.(field)) then
                    C1.(field) := C2.(field);
                fi;
            else
                if not IsBound(C2.(field)) then
                    C2.(field) := C1.(field);
                fi;
            fi;
        od;
        C1.lowerBoundMinimumDistance := Maximum(LowerBoundMinimumDistance(C1),
                                                LowerBoundMinimumDistance(C2));
        C2.lowerBoundMinimumDistance := LowerBoundMinimumDistance(C1);
        C1.upperBoundMinimumDistance := Minimum(UpperBoundMinimumDistance(C1),
                                                UpperBoundMinimumDistance(C2));
        C2.upperBoundMinimumDistance := UpperBoundMinimumDistance(C1);
        return GUAVA_TEMP_VAR;
    fi;
end;

##  If the new partition backtrack algorithms are implemented, the previous
##  function can be replaced by the next:
#LinCodeOps.CodeIsomorphism := function (C1, C2)
#    local field, InvSet1, InvSet2, P;
#    if not IsLinearCode(C1) then
#        return CodeIsomorphism(C2, C1);
#    fi;
#    if Field(C1) <> GF(2) then
#        Error("GUAVA can only calculate equivalence over GF(2)");
#    fi;
#    InvSet1 := VectorCodeword(MinimumWeightWords(C1));
#    InvSet2 := VectorCodeword(MinimumWeightWords(C2));
#    P := AutomorphismGroupBinaryLinearCode(C1, InvSet1, C2, InvSet2);
#    if not IsPerm(P) then
#        return false; #it is good that false is returned
#    else
#        for field in ["weightDistribution",
#                      "boundsCoveringRadius", "isPerfectCode",
#                      "isSelfDualCode"]  do 
#            if not IsBound(C1.(field)) then
#                if IsBound(C2.(field)) then
#                    C1.(field) := C2.(field);
#                fi;
#            else
#                if not IsBound(C2.(field)) then
#                    C2.(field) := C1.(field);
#                fi;
#            fi;
#        od;
#        C1.lowerBoundMinimumDistance := Maximum(LowerBoundMinimumDistance(C1),
#                                               LowerBoundMinimumDistance(C2));
#        C2.lowerBoundMinimumDistance := LowerBoundMinimumDistance(C1);
#        C1.upperBoundMinimumDistance := Minimum(UpperBoundMinimumDistance(C1),
#                                               UpperBoundMinimumDistance(C2));
#        C2.upperBoundMinimumDistance := UpperBoundMinimumDistance(C1);
#        return P;
#    fi;
#end;

CycCodeOps.CodeIsomorphism := LinCodeOps.CodeIsomorphism;

#############################################################################
##
#F  IsEquivalent( <C1>, <C2> )  . . . . . .  true if C1 and C2 are equivalent
##
##  that is if there exists a permutation that transforms C1 into C2.
##  If returnperm is true, this permutation (if it exists) is returned;
##  else the function only returns true or false. Has a global dispatcher.
##
CodeOps.IsEquivalent := function (C1, C2 )
    return not IsBool( CodeIsomorphism( C1, C2 ) );
end;

LinCodeOps.IsEquivalent := CodeOps.IsEquivalent;

CycCodeOps.IsEquivalent := LinCodeOps.IsEquivalent;

#############################################################################
##
#F  RootsOfCode( <C> )  . . . .  the roots of the generator polynomial of <C>
##
##  It finds the roots by trying all elements of the extension field
##
RootsOfCode := function(C)
    if not IsBound(C.rootsOfCode) then
        C.rootsOfCode := C.operations.RootsOfCode(C);
    fi;
    return C.rootsOfCode;
end;

CodeOps.RootsOfCode := function(C)
    if IsCyclicCode(C) then
        return RootsOfCode(C);
    else
        Error("the roots of a code are only defined for cyclic codes");
    fi;
    return C.rootsOfCode;
end;

LinCodeOps.RootsOfCode := CodeOps.RootsOfCode;

CycCodeOps.RootsOfCode := function(C)
    local a, roots, zero, i, t, G;
    G := GeneratorPol(C);
    a := PrimitiveUnityRoot(Size(Field(C)), WordLength(C));
    roots := [];
    zero := 0*a;
    t := a^0;
    for i in [0..WordLength(C)-1] do
        if Value(G, t) = zero then
            Add(roots, t);
        fi;
        t := t * a;
    od;
    return(Set(roots));
end;

#############################################################################
##
#F  DistancesDistribution( <C>, <w> ) . . .  distribution of distances from a
#F                                               word w to all codewords of C
##
DistancesDistribution := function(C,w)
    return C.operations.DistancesDistribution(C,w);
end;

CodeOps.DistancesDistribution := function(C, w)
    local El;
    if IsLinearCode(C) then
        return DistancesDistribution(C,w);
    fi;
    El := VectorCodeword(Elements(C));
    w := VectorCodeword(w, C);
    return DistancesDistributionVecFFEsVecFFE(El,w);
end;

LinCodeOps.DistancesDistribution := function(C, w)
local G;
	G := Copy(GeneratorMat(C));
	w := VectorCodeword(w, C);
	return DistancesDistributionMatFFEVecFFE(G, Size(Field(C)), w);
end;

CycCodeOps.DistancesDistribution := LinCodeOps.DistancesDistribution;
          
#############################################################################
##
#F  Syndrome( <C>, <c> )  . . . . . . .  the syndrome of word <c> in code <C>
##
Syndrome := function(C,c)
        return C.operations.Syndrome(C,c);
end;

CodeOps.Syndrome := function(C, c)
    if not IsLinearCode(C) then
        Error("argument must be a linear code");
    else
        return Syndrome(C,c);
    fi;
end;

LinCodeOps.Syndrome := function(C, c)
    if CheckMat(C) = [] then
        return [Field(C).zero];
    else
        return CheckMat(C) * Codeword(c,C);
    fi;
end;

CycCodeOps.Syndrome := LinCodeOps.Syndrome;

#############################################################################
##
#F  CodewordNr( <C>, <i> )  . . . . . . . . . . . . . . . . .  elements(C)[i]
##
CodewordNr := function (arg)
    if Length(arg) <> 2 then
        Error("usage: CodewordNr( C , <i | list> )");
    fi;
    return arg[1].operations.CodewordNr(arg[1], arg[2]);
end;

CodeOps.CodewordNr := function (C, l)
    local returnlist;
    if IsLinearCode(C) then
        return CodewordNr(C, l);
    fi;
    if IsList(l) then
        l := Set(l);
        returnlist := (Length(l) > 1);
    else
        l := [l];
        returnlist := false;
    fi;
    if (l[1] < 1) or (l[Length(l)] > Size(C)) then
        Error("range: 1..", String(Size(C)));
    fi;
    if returnlist then
        return Elements(C){l};
    else
        return Flat(Elements(C){l})[1];
    fi;
end;

LinCodeOps.CodewordNr := function (C, l)
    local index, source, i, result, q, returnlist, F, kmin;
    if IsList(l) then
        l := Set(l);
        returnlist := (Length(l) > 1);
    else
        l := [l];
        returnlist := false;
    fi;
    if (l[1] < 1) or (l[Length(l)] > Size(C)) then
        Error("range: 1..", String(Size(C)));
    fi;
    if IsBound(C.elements) then
        if returnlist then
            return Elements(C){l};
        else
            return Flat(Elements(C){l})[1];
        fi;
    else
        result := [];
        q := Size(Field(C));
        F := Field(C);
        kmin := Dimension(C) - 1;
        for index in l do
            source := [];
            i := index-1;
            while i >= 1 do
                Add(source, i mod q);
                i := Int(i / q);
            od;
            for i in [Length(source)..kmin] do
                Add(source, 0);
            od;
            Add(result, Reversed(source) * C);
        od;
        if returnlist then
            return result;
        else
            return result[1];
        fi;
    fi;
end;

CycCodeOps.CodewordNr := LinCodeOps.CodewordNr;

#############################################################################
##
#F  String( <C> ) . . . . . . . . . . . . . . . . . . . . . . . . . . . . .  
##
##  has a global dispatcher
##
CodeOps.String := function(C)
    local n, x, lbmd, ubmd, line;
    line := "a";
    if Int(WordLength(C)/(10^LogInt(WordLength(C),10))) = 8 
       or WordLength( C ) = 11 or WordLength( C ) = 18 then
    	Append(line, "n");
    fi;
    Append(line,Concatenation(" (",String(WordLength(C)),",",
            String(Size(C)),","));
    lbmd := String( LowerBoundMinimumDistance(C));
    ubmd := String( UpperBoundMinimumDistance(C));
    if lbmd = ubmd then
        Append(line, lbmd );
    else
        Append( line, Concatenation( lbmd, "..", ubmd ) );
    fi;
    Append( line, ")" );
    if Length( BoundsCoveringRadius( C ) ) = 1 then
        Append( line, String( C.boundsCoveringRadius[ 1 ] ) );
    else
        Append( line, Concatenation( 
                String( C.boundsCoveringRadius[ 1 ] ),
                "..",
                String( C.boundsCoveringRadius[ 
                        Length( C.boundsCoveringRadius ) ] ) ) );
    fi;
    Append( line, " " );
    if not IsBound( C.name ) then
        C.name := "unknown unrestricted code";
    fi;
    Append( line, C.name );
    if not IsBound( C.history ) then
        Append(line,Concatenation(" over GF(", String(Size(Field(C))),")"));
    fi;
    IsString( line );
    return line;
end;
           
LinCodeOps.String := function(C)
    local lbmd, ubmd, line;
    line := "a linear [";
    line := Concatenation( line, String(WordLength(C)), ",",
                    String(Dimension(C)), "," );
    lbmd := String( LowerBoundMinimumDistance(C) );
    ubmd := String( UpperBoundMinimumDistance(C) );
    if lbmd = ubmd then
        Append(line, lbmd );
    else
        Append(line,Concatenation( lbmd, "..", ubmd ) );
    fi;
    Append( line, "]" );
    if Length( BoundsCoveringRadius( C ) ) = 1 then
        Append( line, String( C.boundsCoveringRadius[ 1 ] ) );
    else
        Append( line, Concatenation( 
                String( C.boundsCoveringRadius[ 1 ] ),
                "..",
                String( Maximum( C.boundsCoveringRadius ) ) ) );
    fi;
    Append( line, " " );
    if not IsBound( C.name ) then
        C.name := "unknown linear code";
    fi;
    Append( line, C.name );
    if not IsBound( C.history ) then
        Append(line,Concatenation(" over GF(", String(Size(Field(C))),")"));
    fi;
    IsString( line );
    return line;
end;

CycCodeOps.String :=  function(C)
    local n, x, lbmd, ubmd, line;
    line:="a cyclic [";
    Append( line, Concatenation( String(WordLength(C)), ",",
            String(Dimension(C)), "," ));
    lbmd := String( LowerBoundMinimumDistance(C) );
    ubmd := String( UpperBoundMinimumDistance(C) );
    if lbmd = ubmd then
        Append(line, lbmd );
    else
        Append(line,Concatenation( lbmd, "..", ubmd ) );
    fi;
    Append( line, "]" );
    if Length( BoundsCoveringRadius( C ) ) = 1 then
        Append( line, String( C.boundsCoveringRadius[ 1 ] ) );
    else
        Append( line, Concatenation( 
                String( C.boundsCoveringRadius[ 1 ] ),
                "..",
                String( C.boundsCoveringRadius[ 
                        Length( C.boundsCoveringRadius ) ] ) ) );
    fi;
    Append( line, " " );
    if not IsBound( C.name ) then
        C.name := "unknown cyclic code";
    fi;
    Append( line, C.name );
    if not IsBound( C.history ) then
        Append(line,Concatenation(" over GF(", String(Size(Field(C))),")"));
    fi;
    IsString( line );
    return line;
end;

#############################################################################
##
#F  Print( <C> )  . . . . . . . . . . . . .  prints short information about C
##
##  Has a global dispatcher
##
CodeOps.Print := function(C)
    Print(String(C));
end;

LinCodeOps.Print := CodeOps.Print;
  
CycCodeOps.Print := CodeOps.Print;

#############################################################################
##
#F  Display( <C>, <fake> )  . . . . . . . .  prints the history of the code C
##
##  Has a global dispatcher
##
CodeOps.Display := function(C, fake)
    local d;
    for d in History(C) do
        Print(d,"\n");
    od;
end;

LinCodeOps.Display := CodeOps.Display;

CycCodeOps.Display := CodeOps.Display;
  
#############################################################################
##
#F  Save( <filename>, <C>, <var-name> ) . . . . . writes the code C to a file
##
##  with variable name var-name. It can be read back by calling
##  Read (filename); the code then has the name var-name.
##  All fiels of the code record are stored except for the operations field
##  and, in case of a linear or cyclic code, the elements.
##  Has a global dispatcher.
##  Pre: filename is accessible for writing
##
CodeOps.Save := function (filename, C, codename)
    local fld;
    PrintTo(filename, "\n# GUAVA code #\n");
    AppendTo(filename, codename, " := rec(\n");
    for fld in Set(RecFields(C)) do
        if fld <> "operations" and 
           fld <> "name" and
           fld <> "elements" then
            AppendTo(filename, fld, ":=",C.(fld),",\n");
        fi;
    od;
    AppendTo(filename,"elements:=Codeword(",VectorCodeword(C.elements),"),\n");
    AppendTo(filename, "name := \"", C.name,"\",\n");
    AppendTo(filename, "operations := ", C.operations.name,"\n);\n");
end;

LinCodeOps.Save := function (filename, C, codename)
    local fld;
    PrintTo(filename, "\n# GUAVA code #\n");
    AppendTo(filename, codename, " := rec(\n");
    for fld in Set(RecFields(C)) do
        if fld <> "operations" and
           fld <> "name" and
           fld <> "elements" then
            AppendTo(filename, fld, ":=",C.(fld),",\n");
        fi;
    od;
    AppendTo(filename, "name := \"", C.name,"\",\n");
    AppendTo(filename, "operations := ", C.operations.name,"\n);\n");
end;

CycCodeOps.Save := function (filename, C, codename)
    local fld;
    PrintTo(filename, "\n# GUAVA code #\n");
    AppendTo(filename, codename, " := rec(\n");
    for fld in Set(RecFields(C)) do
        if fld <> "operations" and
           fld <> "name" and
           fld <> "elements" then
            AppendTo(filename, fld, ":=",C.(fld),",\n");
        fi;
    od;
    AppendTo(filename, "name := \"", C.name,"\",\n");
    AppendTo(filename, "operations := ", C.operations.name,"\n);\n");
end;

#############################################################################
##
#F  History( <C> )  . . . . . . . . . . . . . . . shows the history of a code
##
History := function( C )
    return C.operations.History( C );
end;

CodeOps.History := function( C )
    local s;
    if not IsBound(C.history) then
        return [ String( C ) ];
    else
        s := String( Concatenation( String( C ), " of" ) );
        return Concatenation( [ s ], C.history );
    fi;
end;

LinCodeOps.History := CodeOps.History;

CycCodeOps.History := CodeOps.History;
