#############################################################################
##
#W  fixes_polyfin.g	   	Matrix Packages                  Frank Celler
##
#H  @(#)$Id: polyfin.g,v 1.1 1997/03/10 13:52:00 gap Exp $
##
#Y  Copyright (C)  1996,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This file fixes  functions from the  polynomial packages of GAP 3.4 which
##  should been done slightly differently.
##
RevisionMatrix.fixes_polyfin_g :=
    "@(#)$Id: polyfin.g,v 1.1 1997/03/10 13:52:00 gap Exp $";


# read in the files to patch
ReadLib("polyfin");


#############################################################################
##

#F  FiniteFieldPolynomialRingOps.OrderKnownDividend( <R>, <g>, <f>, <pp> )
##
##  Computes an integer n such that <g>^n = const  mod <f> where <g>  and <f>
##  are polynomials in <R> and <pp> is list  of prime powers of  an integer d
##  such that n divides  d.   The  functions  returns  the integer n  and the
##  element const.
##
OKDInd := "#I";

FiniteFieldPolynomialRingOps.PowerModCheck := function( R, g, pp, f )
    local   qq,  i;

    qq := [];
    for i  in [ 1 .. Length(pp)/2 ]  do
        Add( qq, pp[2*i-1] );
        Add( qq, pp[2*i] );
        g := PowerMod( R, g, pp[2*i-1] ^ pp[2*i], f );
        if Degree(g) = 0  then
            return [ g, qq ];
        fi;
    od;
    return [ g, qq ];

end;


FiniteFieldPolynomialRingOps.OrderKnownDividend := function ( R, g, f, pp )
    local   old,  l,  a,  h,  n1,  pp1,  pp2,  k,  o,  q;

    # adjust indent
    old    := OKDInd;
    OKDInd := ConcatenationString( OKDInd, "  " );

    # if <g> is constant return order 1
    InfoPoly2( OKDInd, "OrderKnownDividend:\n" );
    InfoPoly2( OKDInd, "  <g>  = ", g, "\n" );
    InfoPoly2( OKDInd, "  <f>  = ", f, "\n" );
    InfoPoly2( OKDInd, "  <pp> = ", pp, "\n" );
    if 0 = Degree(g)  then
	InfoPoly2( OKDInd, "  <g> is constant\n" );
        l := [ 1, g.coefficients[1] ];
        InfoPoly2( OKDInd, "OrderKnownDividend returns ", l, "\n" );
	OKDInd := old;
    	return l;

    # if the dividend is a prime, we must compute g^pp[1] to get the constant
    elif Length(pp) = 2 and pp[2] = 1  then
    	k := PowerMod( g, pp[1], f );
    	l := [ pp[1], k.coefficients[1] ];
        InfoPoly2( OKDInd, "OrderKnownDividend returns ", l, "\n" );
	OKDInd := old;
        return l;

    # if the dividend is a prime power find the necessary power
    elif Length(pp) = 2  then
	InfoPoly2( "#I    prime power, divide and conquer\n" );
        pp := Copy( pp );
        a  := QuoInt( pp[2], 2 );
	q  := pp[1] ^ a;
        h  := PowerMod( R, g, q, f );

	# if <h> is constant try again with smaller dividend
        if 0 = Degree(h)  then
	    pp[2] := a;
	    o := R.operations.OrderKnownDividend( R, g, f, pp );
        else
	    pp[2] := pp[2] - a;
	    l := R.operations.OrderKnownDividend( R, h, f, pp );
	    o := [ q*l[1], l[2] ];
        fi;
        InfoPoly2( "#I  OrderKnownDividend returns ", o, "\n" );
	OKDInd := old;
	return o;

    # split different primes.
    else

    	# divide primes
	InfoPoly2( OKDInd, "  ", Length(pp)/2, " different primes\n" );
        n1  := QuoInt( Length(pp), 4 );
        pp1 := pp{[ n1*2+1 .. Length(pp) ]};
        pp2 := pp{[ 1 .. n1*2 ]};
	InfoPoly2( OKDInd, "    <pp1> = ", pp1, "\n" );
	InfoPoly2( OKDInd, "    <pp2> = ", pp2, "\n" );

        # raise <g> to the power <pp2>
        k   := R.operations.PowerModCheck( R, g, pp2, f );
        pp2 := k[2];
        k   := k[1];

        # compute order for <pp1>
	o := R.operations.OrderKnownDividend( R, k, f, pp1 );

        # compute order for <pp2>
    	k := PowerMod( R, g, o[1], f );
	l := R.operations.OrderKnownDividend( R, k, f, pp2 );
    	o := [ o[1]*l[1], l[2] ];
        InfoPoly2( OKDInd, "OrderKnownDividend returns ", o, "\n" );
	OKDInd := old;
        return o;
    fi;

end;


#############################################################################
##

#E  fixes_polyfin.g . . . . . . . . . . . . . . . . . . . . . . . . ends here
##
