public class Builtin {
  
  public static void main ( String[] args ) {
	byteSetTest();
	intArrProd();
	floatArrProd();
	doubleArrProd();
  }
  
  
  public static void byteSetTest () {
	int rounds = 30000;
	long t1, t2;
	int  i, n = 100;
	byte[] a;
  
	a = new byte[n];

	t1 = System.currentTimeMillis();
	while ( rounds-- != 0 ) {
	  for ( i=0; i<n; i++ ) {
		a[i] = 1;
		if ( a[i] == 2 ) break;
	  }
	}
	t2 = System.currentTimeMillis();
	System.out.println( "byte set test: " + (t2 - t1));
  }

  
  public static void intArrProd () {
	int       rounds = 10000;
	long      t1, t2;
	int[]     a, b;
	int       res;
	int       i, n = 100;

	a = new int[n];
	b = new int[n];
	
	t1 = System.currentTimeMillis();
	while ( rounds-- != 0 ) {
	
	  for ( i=0; i<n; i++ ){
		a[i] = i;
		b[i] = i*2;
	  }
	
	  for ( i=0, res=0; i<n; i++ ) {
		res += a[i] * b[i];
	  }
	}
	t2 = System.currentTimeMillis();
	System.out.println( "int array inner prod: " + (t2 - t1));
  }
  
  public static void floatArrProd () {
	int       rounds = 10000;
	long      t1, t2;
	float[]     a, b;
	float       res;
	int       i;
	int       n = 100;

	a = new float[n];
	b = new float[n];
	
	t1 = System.currentTimeMillis();
	while ( rounds-- != 0 ) {
	
	  for ( i=0; i<n; i++ ){
		a[i] = i;
		b[i] = i*2;
	  }
	
	  for ( i=0, res=0; i<n; i++ ) {
		res += a[i] * b[i];
	  }
	}
	t2 = System.currentTimeMillis();
	System.out.println( "float array inner prod: " + (t2 - t1));
  }

  public static void doubleArrProd () {
	int       rounds = 10000;
	long      t1, t2;
	double[]     a, b;
	double       res;
	int       i;
	int       n = 100;
	
	a = new double[n];
	b = new double[n];
	
	t1 = System.currentTimeMillis();
	while ( rounds-- != 0 ) {
	
	  for ( i=0; i<n; i++ ){
		a[i] = i;
		b[i] = i*2;
	  }
	
	  for ( i=0, res=0; i<n; i++ ) {
		res += a[i] * b[i];
	  }
	}
	t2 = System.currentTimeMillis();
	System.out.println( "double array inner prod: " + (t2 - t1));
  }
}
