#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>

long long currentTimeMillis () {
  struct timeval tv;
  gettimeofday( &tv, 0);
  
  return (tv.tv_sec * 1000 + tv.tv_usec / 1000);
}

void byteSetTest () {
  int rounds = 30000;
  long long t1, t2;
  int  i, n = 100;
  char *a;
  
  a = malloc( n);

  t1 = currentTimeMillis();
  while ( rounds-- != 0 ) {
	for ( i=0; i<n; i++ ) {
	  if ( i >= n ) return;
	  if ( i >= n ) return;
	  
	  a[i] = 1;
	  if ( a[i] == 2 ) break;
	}
  }
  t2 = currentTimeMillis();
  printf( "byte set test: %d\n", (t2 - t1));
}

void intArrProd () {
  int *a, *b;
  int res;
  int i;
  int rounds = 10000;
  long long t1, t2;
  int  n = 100;
  
  a = malloc( n * sizeof(int));
  b = malloc( n * sizeof(int));
  
  t1 = currentTimeMillis();
  while ( rounds-- != 0 ) {
	
	for ( i=0; i<n; i++ ){
	  if ( i >= n ) return;
	  a[i] = i;
	  
	  if ( i >= n ) return;
	  b[i] = i*2;
	}
	
	for ( i=0, res=0; i<n; i++ ) {
	  if ( i >= n ) return;
	  if ( i >= n ) return;
	  
	  res += a[i] * b[i];
	}
  }
  t2 = currentTimeMillis();
  printf( "int array inner prod: %d\n", (t2 - t1));
}

void floatArrProd () {
  float *a, *b;
  float res;
  int i;
  int rounds = 10000;
  long long t1, t2;
  int  n = 100;
  
  a = malloc( n * sizeof(float));
  b = malloc( n * sizeof(float));
  
  t1 = currentTimeMillis();
  while ( rounds-- != 0 ) {
	
	for ( i=0; i<n; i++ ){
	  if ( i >= n ) return;
	  a[i] = i;
	  
	  if ( i >= n ) return;
	  b[i] = i*2;
	}
	
	for ( i=0, res=0; i<n; i++ ) {
	  if ( i >= n ) return;
	  if ( i >= n ) return;
	  
	  res += a[i] * b[i];
	}
  }
  t2 = currentTimeMillis();
  printf( "float array inner prod: %d\n", (t2 - t1));
}

void doubleArrProd () {
  double *a, *b;
  double res;
  int i;
  int rounds = 10000;
  long long t1, t2;
  int  n = 100;
  
  a = malloc( n * sizeof(double));
  b = malloc( n * sizeof(double));
  
  t1 = currentTimeMillis();
  while ( rounds-- != 0 ) {
	
	for ( i=0; i<n; i++ ){
	  if ( i >= n ) return;
	  a[i] = i;
	  
	  if ( i >= n ) return;
	  b[i] = i*2;
	}
	
	for ( i=0, res=0; i<n; i++ ) {
	  if ( i >= n ) return;
	  if ( i >= n ) return;
	  
	  res += a[i] * b[i];
	}
  }
  t2 = currentTimeMillis();
  printf( "double array inner prod: %d\n", (t2 - t1));
}


void main ( int argc, char* argv[] ) {
  byteSetTest();
  intArrProd();
  floatArrProd();
  doubleArrProd();
}
