<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl"
 xmlns:html="http://www.w3.org/Profiles/XHTML-transitional">

  <xsl:template><xsl:apply-templates/></xsl:template>
  <xsl:template match="text()"><xsl:value-of/></xsl:template>

  <xsl:template match="/">
    <html>
      <xsl:comment>
        This HTML file is automatically converted from XML. Do not edit!
      </xsl:comment>
      <head>
        <title><xsl:value-of select="program/maintitle"/></title>
        <style>

<xsl:comment>
==================== this is mainly jit.css =========================
</xsl:comment>

body {
 background-color: #e6e6ff;
}

p {
 margin-bottom: 0pt;
 margin-top: 0pt;
}

.program {
 width: 94.7%;
 margin-left: 5%;
}

.day {
}

.track {
}

.session {
 background-color: #f0f0ff;
 border-top: 2px solid #ffffff;
 border-left: 2px solid #ffffff;
 border-bottom: 2px solid #c0c0d0;
 border-right: 2px solid #c0c0d0;
 padding: 0.5em;
}

.talk {
 margin-top: 20pt;
}

.maintitle {
 font-family: arial, helvetica, sans-serif;
 font-weight: bold;
 font-size: 24pt;
 display: block;
 color: darkred;
 text-align: center;
 margin-bottom: 20pt;
 margin-top: 20pt;
}

.title {
 font-family: arial, helvetica, sans-serif;
 font-weight: bold;
 font-size: 14pt;
 display: block;
 text-align: left;
}

.day-title {
 font-size: 20pt;
 text-align: center;
 margin-top: 4cm;
 color: white;
 background-color: darkblue;
 padding: .5em;
}

.track-title {
 font-size: 18pt;
 text-align: center;
 margin-top: 2cm;
 color: white;
 background-color: black;
 padding: .5em;
}

.session-title {
 font-size: 16pt;
 text-align: left;
 padding-top: 12pt;
 color: darkred;
 background-color: transparent;
}

.talk-title {
 font-size: 12pt;
 text-align: left;
 padding-top: 7pt;
 color: darkred;
 background-color: transparent;
}

.note {
 display: block;
 clear: left;
 margin-left: 3.2cm;
 margin-bottom: 0.5em;
}

.info {
 display: block;
 margin-bottom: 0.5em;
}

.author {
 font-weight: bold;
 display: block;
 clear: left;
 margin-left: 3.2cm;
 margin-bottom: 0.5em;
}

.name {
 display: inline;
}

.name-email {
 display: inline;
 text-decoration: none;
 color: darkblue;
}

.organisation {
 display: inline;
 font-style: italic;
}

.time {
 font-weight: bold;
 font-size: 14pt;
 color: darkblue;
 display: block;
 float: left;
 margin-top: 5pt;
 margin-bottom: 5pt;
 margin-right: 10pt;
}

.from {
 display: inline;
}

.to {
 display: inline;
}

.abstract {
 display: block;
 background-color: #e6e6ff;
 border-top: 2px solid #c0c0d0;
 border-left: 2px solid #c0c0d0;
 border-bottom: 2px solid #ffffff;
 border-right: 2px solid #ffffff;
 padding: .5em;
 padding-left: 3.1cm;
}

.p {
 display: block;
 margin-bottom: .5em;
}

.copyright {
 display: block;
 margin-top: 1cm;
 border-top: 1px solid grey;
}

.slide {
 font-size: 8pt;
 font-weight: bold;
 color: #909090;
 text-align: left;
 margin-left: 3.2cm;
}

.tagline {
 font-size: 8pt;
 font-weight: bold;
 color:  #a6a6cf;
 margin-left: 3.2cm;
}

.jumpline {
 font-size: x-small;
 font-weight: bold;
 color:  #a6a6cf;
 text-align: right;
}

.logoline {
 font-family: arial, helvetica, sans-serif;
 font-weight: bold;
 font-size: 14pt;
 display: block;
 text-align: center;
 background-color: white;
}

<xsl:comment>
==================== this was mainly jit.css ========================
</xsl:comment>

        </style>

        <script language="JavaScript"><xsl:comment><![CDATA[
          function toggle (show, hide) {
            hide.style.display="none";
            show.style.display="block";
          }
        ]]>//</xsl:comment>
        </script>

      </head>
      <body>

      <xsl:apply-templates/>

      </body>
    </html>
  </xsl:template>


  <xsl:template match="program">
    <div class="program"><xsl:apply-templates/></div>
  </xsl:template>

  <xsl:template match="maintitle">
    <h1 class="maintitle"><xsl:apply-templates/></h1>
    <p class="jumpline">Navigational sugar:</p>
    <hr/>
    <xsl:for-each select="/program/day">
      <p class="jumpline">Skip to
        <a><xsl:attribute name="href">#<xsl:value-of select="title/@name"/></xsl:attribute><xsl:value-of select="title"/></a></p>
    </xsl:for-each>
    <p class="jumpline">Further links:</p>
  </xsl:template>

  <xsl:template match="day">
    <div class="day"><xsl:apply-templates/></div>
  </xsl:template>

  <xsl:template match="track">
    <div class="track"><xsl:apply-templates/></div>
  </xsl:template>

  <xsl:template match="session">
    <div class="session"><xsl:apply-templates/></div>
  </xsl:template>

  <xsl:template match="talk">
    <div class="talk"><xsl:apply-templates/></div>
  </xsl:template>

  <xsl:template match="title">
    <p class="title"><xsl:apply-templates/></p>
  </xsl:template>

  <xsl:template match="day/title">
    <a><xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute></a>
    <div class="title"><p class="day-title"><xsl:apply-templates/></p></div>
    <p class="logoline">
      <img align="bottom">
        <xsl:attribute name="src">images/<xsl:value-of select="@logo"/></xsl:attribute>
      </img>
      <xsl:value-of select="@logotext"/>
    </p>
  </xsl:template>

  <xsl:template match="track/title">
    <div class="title"><p class="track-title"><xsl:apply-templates/></p></div>
  </xsl:template>

  <xsl:template match="session/title">
    <div class="title"><p class="session-title"><xsl:apply-templates/></p></div>
    <xsl:if test="@logo">
      <img align="right" border="0"
          style="margin-left: 0.2cm; margin-bottom: 0.2cm">
        <xsl:attribute name="src">images/<xsl:value-of select="@logo"/></xsl:attribute>
      </img>
    </xsl:if>
  </xsl:template>

  <xsl:template match="talk/title">
    <div class="title"><p class="talk-title"><xsl:apply-templates/></p></div>
    <xsl:if test="@logo">
      <img align="right" border="0"
          style="margin-left: 0.5cm; margin-top: 0.2cm; margin-bottom: 0.2cm">
        <xsl:attribute name="src">images/<xsl:value-of select="@logo"/></xsl:attribute>
      </img>
    </xsl:if>
  </xsl:template>

  <xsl:template match="note">
    <p class="note">[<xsl:apply-templates/>]</p>
  </xsl:template>

  <xsl:template match="info">
    <div class="info"><xsl:apply-templates/></div>
  </xsl:template>

  <xsl:template match="author">
    <p class="author"><xsl:apply-templates/></p>
  </xsl:template>

  <xsl:template match="name">
    <span class="name"><xsl:apply-templates/></span>
  </xsl:template>

  <xsl:template match="name[@email]">
      <a>
        <xsl:attribute name="href">mailto:<xsl:value-of select="@email"/></xsl:attribute>
        <span class="name-email"><xsl:apply-templates/></span></a>
  </xsl:template>

  <xsl:template match="organisation">
    <span class="organisation"> (<xsl:apply-templates/>)</span>
  </xsl:template>

  <xsl:template match="time">
    <p class="time"><xsl:apply-templates/></p>
  </xsl:template>

  <xsl:template match="from">
    <span class="from"><xsl:apply-templates/></span>
  </xsl:template>

  <xsl:template match="to">
    <span class="to"> - <xsl:apply-templates/></span>
  </xsl:template>

  <xsl:template match="slide">
    <div class="slide">
      Vortragsfolien:
      <a target="slideview"><xsl:attribute name="href"><xsl:value-of select="."/></xsl:attribute>[ <xsl:value-of select="@type"/> ]</a>
      (<xsl:value-of select="@size"/>)
    </div>
  </xsl:template>

  <xsl:template match="abstract">
    <div style="display: none">
      <xsl:attribute name="id">yepp<xsl:value-of select="@name"/></xsl:attribute>
      <p class="tagline"><a>
        <xsl:attribute name="href">javascript:toggle(
          nope<xsl:value-of select="@name"/>,
          yepp<xsl:value-of select="@name"/>
          )</xsl:attribute>[-]</a></p>
      <div class="abstract">
      <b>Abstrakt: </b><xsl:apply-templates/></div>
    </div>
    <div>
      <xsl:attribute name="id">nope<xsl:value-of select="@name"/></xsl:attribute>
      <p class="tagline"><a>
        <xsl:attribute name="href">javascript:toggle(
          yepp<xsl:value-of select="@name"/>,
          nope<xsl:value-of select="@name"/>
          )</xsl:attribute>[+]</a> (click symbol for summary)</p>
    </div>
  </xsl:template>

  <xsl:template match="p">
    <p class="p"><xsl:apply-templates/></p>
  </xsl:template>

  <xsl:template match="copyright">
    <p class="copyright"><xsl:apply-templates/></p>
  </xsl:template>

  <xsl:template match="lnk">
    <p class="jumpline"><a><xsl:apply-templates select="@*"/><xsl:apply-templates/></a></p>
  </xsl:template>
  
  <xsl:template match="html:a">
    <a><xsl:apply-templates select="@*"/><xsl:apply-templates/></a>
  </xsl:template>
  
  <xsl:template match="html:img">
    <img><xsl:apply-templates select="@*"/><xsl:apply-templates select="*"/></img>
  </xsl:template>

  <xsl:template match="html:ul">
    <ul><xsl:apply-templates/></ul>
  </xsl:template>
  
  <xsl:template match="html:li">
    <li><xsl:apply-templates/></li>
  </xsl:template>
  
  <xsl:template match="@*">
    <xsl:copy><xsl:value-of/></xsl:copy>
  </xsl:template>

</xsl:stylesheet>
