import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import java.io.*;
import java.net.*;


public class JGUISVUser extends JApplet {
  JSpielCanvasPos1 sc1;
  JSpielCanvas sc2;
  JSpielfeld spieler, computer;
  JSVClient netz;
  JPanel computerPanel;
  JPanel spielerPanel;
  JPanel buttonsPanel;
  JButton setship, shoot;
  Container thisApplet;

  public void init () {

     thisApplet = this;
     getContentPane().setLayout(new GridLayout(1,3));
     setSize(700,266);

    computer = new JSpielfeld();
    spieler = new JSpielfeld();
    buttonsPanel = new JPanel(false);
    buttonsPanel.setLayout(new FlowLayout(FlowLayout.CENTER));

    computerPanel = new JPanel(false);
    computerPanel.setLayout(new BoxLayout(computerPanel, BoxLayout.Y_AXIS));
    computerPanel.setBorder( new TitledBorder(new TitledBorder(LineBorder.createGrayLineBorder(),"Spielfeld des"),
                                "Computers", TitledBorder.RIGHT, TitledBorder.BOTTOM));


    spielerPanel = new JPanel(false);
    spielerPanel.setLayout(new BoxLayout(spielerPanel, BoxLayout.Y_AXIS));
    spielerPanel.setBorder( new TitledBorder(new TitledBorder(LineBorder.createGrayLineBorder(),"Spielfeld des"),
                                "Spielers", TitledBorder.RIGHT, TitledBorder.BOTTOM));
    // Anlegen der Buttons

    setship = new JButton("Neues Spiel");
    setship.setToolTipText("Neues Spiel");
    setship.addActionListener(new ButtonListener(0));
    buttonsPanel.add(setship);

    shoot = new JButton("Schuss abgeben");
    shoot.setToolTipText("Klick mich, um zu schiessen");
    shoot.setEnabled(false);
    shoot.addActionListener(new ButtonListener(1));
    buttonsPanel.add(shoot);

    getContentPane().add(buttonsPanel);

    //Spielfeld des Computers

    sc1 = new JSpielCanvasPos1(computer);
    computerPanel.add(sc1);
    getContentPane().add(computerPanel);

    //Spielfeld des Benutzers
    sc2 = new JSpielCanvas(spieler);
    spielerPanel.add(sc2);
    getContentPane().add(spielerPanel);

    validate();
  }


  class ButtonListener implements ActionListener {
    private int val;
    ButtonListener (int val) {
      this.val = val;
    }
    public void actionPerformed(ActionEvent e) {
      JDaten daten;
      Point p = null;
      daten = new JDaten();

      if (val == 0){ //Schiffe setzen
        spieler.initialisieren();
        computer.initialisieren();
        try {
          netz = new JSVClient((JGUISVUser) thisApplet);
        } catch (IOException ioe){
           JOptionPane.showMessageDialog(null, "Probleme beim Netzaufbau!!");
           return;
        }
        if (netz.SVSocket == null)
          return;

        JSchiffFenster fenster = new JSchiffFenster(spieler, thisApplet);
        fenster.setTitle("Schiffe setzen");
        fenster.pack();
        fenster.setVisible(true);
        fenster.setSize(550,380);
        shoot.setEnabled(true);
        repaint();

      } else{ //Schiessen
        getSchussKoordinaten();

        //Koordinaten bereits markiert?
        if (sc1.sa1.tmp.x == -1)
          return;
        daten.status=daten.SCHUSS;
        daten.p.x=sc1.sa1.tmp.x;
        daten.p.y=sc1.sa1.tmp.y;
        netz.sendData(daten);
        shoot.setEnabled(false);
        try {
          daten = netz.getData();
        }catch (IOException ioe) {}

        if (daten.status == daten.TREFFER) {
          //TREFFER
          System.out.println("Wir haben getroffen");
          //Einfaerben
          computer.spiel[sc1.sa1.tmp.x][sc1.sa1.tmp.y]=computer.VERSENKT;
          computer.schiffZahl--;
          if (computer.schiffZahl==0){
            //Gewinnmeldung
            JOptionPane.showMessageDialog(null, "Herzlichen Glckwunsch, Sie haben gewonnen!!!");
            try {
              netz.beenden();
            } catch (IOException ioe) {}
            //Neues Spiel anbieten
            shoot.setEnabled(false);
            return;
          }
          sc1.sa1.tmp.x = sc1.sa1.tmp.y = -1;
          sc1.sa1.repaint();
          repaint();
          shoot.setEnabled(true);
        } else {
          System.out.println("Wasser");
          computer.spiel[sc1.sa1.tmp.x][sc1.sa1.tmp.y]=computer.WASSER;
          sc1.sa1.tmp.x = sc1.sa1.tmp.y = -1;
          sc1.sa1.repaint();
          rechnerTrifft(daten);
          if (spieler.schiffZahl!=0)
            shoot.setEnabled(true);
          sc2.repaint();

        repaint();
        }
      }
      validate();
    }

     public void rechnerTrifft(JDaten d) {

          while (true) {
                if (spieler.spiel[d.p.x][d.p.y]!=spieler.SCHIFF)
                  if (spieler.spiel[d.p.x][d.p.y]!=spieler.VERSENKT)
                  {
                  spieler.spiel[d.p.x][d.p.y]=spieler.WASSER;
                  //Rechner schiesst ins Wasser
                  return;
                }
                //Rechner hat uns wirklich getroffen
                d.status = d.TREFFER;
                netz.sendData(d);
                spieler.spiel[d.p.x][d.p.y]=spieler.VERSENKT;

                spieler.schiffZahl--;
                if (spieler.schiffZahl==0){
                  //Meldung dass Spieler verloren hat
                    JOptionPane.showMessageDialog(null, "Leider verloren!!");
                    try {
                      netz.beenden();
                    } catch (IOException ioe) {}
                    //Neues Spiel anbieten
                    shoot.setEnabled(false);
                    return;
                  }

                try {
                    d = netz.getData();
                }catch (IOException ioe) {}
                shoot.setEnabled(false);

                sc2.repaint();
                repaint();
          }
    }



    public void getSchussKoordinaten() {
      System.out.println("Schuss auf "+sc1.sa1.tmp.x+" "+sc1.sa1.tmp.y);
    }
  }
}