/**
* Das vorliegende JAVA-Programm erzeugt eine einfache Tabelle
* benutzt wird die relationale Datenbank (MS-Access 7.0).
*
* Das Programm muss in der folgenden Form aufgerufen werden:
*
* java OpenJavaDB
*
* Erstellt: 06.04.1999
*/

// Notwendige Klassen importieren
import java.sql.*;

// Klassendefinition
class OpenJavaDB {

    static  String          query_str;              // String fuer die erste Abfrage
 //   static  String          query2_str;              // String fuer die zweite Abfrage
    static  ResultSet       mein_ergebnis;          //erster  Ergebnissatz
  //  static  ResultSet       mein2_ergebnis;          //zweiter  Ergebnissatz
    static  Integer         spieler_nummer;         // Variable fuer die Spielernummer
    static  String          spieler_vorname;        // Variable fuer den Spielervornamen
    static  String          spieler_name;           // Variable fuer den Spielernachnamen
    static  Integer         spieler_gespielt;       // Variable fuer die Anzahl der gespielten Male

    public static void  main(String args[]) {

        // Programminformationen ausgeben:
        System.out.println();
        System.out.println("--openjava----openjava----openjava----openjava----openjava----openjava--");
        System.out.println("  ");
        System.out.println();
        System.out.println("Programm:       OpenJavaDB                            ");
        System.out.println("Zweck:          Erzeugt eine Tabelle fr eine MS-Access-Datenbank    ");
        System.out.println("Version:        1.0                                       ");
        System.out.println("Erstellt am:    06.04.99                                  ");
        System.out.println("  ");
        System.out.println();
        System.out.println("--openjava----openjava----openjava----openjava----openjava----openjava--");
        System.out.println();
        System.out.println();

            try {

            // 1. Laden des JDBC-ODBC-Treiber
            Class.forName ("sun.jdbc.odbc.JdbcOdbcDriver");

            // 2. Datenbank-URL spezifizieren. Die Datenbank heisst openjava
            String db_url = "jdbc:odbc:openjava";

            // 3. Verbindung zur Datenbank herstellen (Benutzer und Kennwort werden nicht gebraucht)
            Connection mein_con = DriverManager.getConnection(db_url, "", "");
              System.out.println("  ");
              System.out.println("INFO: Verbindung zur Datenbank erfolgreich durchgefuehrt.");
              System.out.println("  ");

            // 4. Statements erzeugen
            Statement mein_stmnt = mein_con.createStatement();


            // 5. Loeschen der Tabelle Spieler falls es existiert
          try{
                    mein_stmnt.execute("DROP TABLE Spieler" );
          } catch (Exception e){System.out.println(" Tabelle Spieler existiert nicht ");}


            // 6. Eine Tabelle Erzeugen
            mein_stmnt.execute("CREATE TABLE Spieler(" + "Spieler_Nr integer,"+ "Nachname varchar (32)," +
                                "Vorname varchar (32),"+ "Gespielt integer );"
            );

            System.out.println("  ");
            System.out.println("INFO: Tabelle erfolgreich erzeugt.");
            System.out.println("  ");

            // 7. Daten in der Tabelle Einfgen
            mein_stmnt.executeUpdate ("INSERT INTO Spieler " + " VALUES (1, 'ElSaddik', 'Abed', 4)" );
            mein_stmnt.executeUpdate ("INSERT INTO Spieler " + " VALUES (2, 'Fischer', 'Stephan', 6)" );
            mein_stmnt.executeUpdate ("INSERT INTO Spieler " + " VALUES (3, 'ElSaddik', 'Abutti', 8)" );
            mein_stmnt.executeUpdate ("INSERT INTO Spieler " + " VALUES (4, 'Frankfurter', 'Richard', 2)" );

            System.out.println("  ");
            System.out.println("INFO: Werte in der Tabelle erfolgreich eingegeben.");
            System.out.println("  ");

            // 8. Nun wird eine Anfrage an die Datenbank gemacht um zu sehen ob die Daten drin sind
            query_str = "SELECT Spieler_Nr, Nachname, Vorname, Gespielt FROM Spieler";

            // 9. Abfrage ausfuehren und Ergebnisse anschauen
            mein_ergebnis = mein_stmnt.executeQuery(query_str);
            System.out.println();
            System.out.println("--openjava----openjava----Zeige Tabellen Inhalt----openjava----openjava--");
            System.out.println();
            SchreibeErgebnis(mein_ergebnis);

            // 11. Benutzen von PreparedStatement
            PreparedStatement mein_prstmnt = mein_con.prepareStatement("UPDATE Spieler SET Gespielt=? WHERE Nachname=?");

            // Setzen der jeweiligen Variablen mit den entsprechenden
            // setxxx-Methode
            mein_prstmnt.setInt(1, 44);
            mein_prstmnt.setString(2, "ElSaddik");
            // Tabelle Aktualisieren
            mein_prstmnt.executeUpdate();

            //12. Nun wird eine neue Anfrage an die Datenbank gemacht um zu sehen ob die Daten aktualisiert wurden
            query_str = "SELECT Spieler_Nr, Nachname, Vorname, Gespielt FROM Spieler WHERE Gespielt < 50";

            // 13. Abfrage ausfuehren und Ergebnisse anschauen
            mein_ergebnis = mein_stmnt.executeQuery(query_str);
            System.out.println();
            System.out.println("--openjava----openjava----PreparedStatement Verwenden----openjava----openjava--");
            System.out.println();
            SchreibeErgebnis(mein_ergebnis);


            // 15. Benutzen von PreparedStatement um Datenstze aus der Datenbank zu lschen
            PreparedStatement mein2_prstmnt = mein_con.prepareStatement("DELETE FROM Spieler Where Nachname=?");

            // Setzen der jeweiligen Variablen mit den entsprechenden
            // setxxx-Methode
            mein2_prstmnt.setString(1, "ElSaddik");
            // Tabelle Aktualisieren
            mein2_prstmnt.executeUpdate();

            //16. Nun wird eine neue Anfrage an die Datenbank gemacht um zu sehen ob die Daten aktualisiert wurden
            query_str = "SELECT Spieler_Nr, Nachname, Vorname, Gespielt FROM Spieler";

            // 17. Abfrage ausfuehren und Ergebnisse anschauen
            mein_ergebnis = mein_stmnt.executeQuery(query_str);
            System.out.println();
            System.out.println("--openjava----openjava----PreparedStatement zum Lschen verwenden----openjava----openjava--");
            System.out.println();
            SchreibeErgebnis(mein_ergebnis);

////////////  BEGIN METADATA   /////
 // 18. Erzeugen des Metadatenobjektes
        DatabaseMetaData meine_metadata = mein_con.getMetaData();


    	if (meine_metadata == null) {
            System.out.println ("Keine Datenbank-Metadaten vorhanden");
        } else {
                 //19. Ausgeben der Informationen ueber das RDBMS
                System.out.println();
                System.out.println("--openjava----openjava----Datenbank Information----openjava----openjava--");
                System.out.println();
                System.out.println();
                System.out.println("Datenbank Produktsname:   " + meine_metadata.getDatabaseProductName());
                System.out.println("Datenbank Version:        " + meine_metadata.getDatabaseProductVersion());
                System.out.println("JDBC-Treiber Name:        " + meine_metadata.getDriverName());
                System.out.println("Treiber Version:          " + meine_metadata.getDriverVersion());
                System.out.println("URL:                      " + meine_metadata.getURL());
                System.out.println("Benutzer:                 " + meine_metadata.getUserName());
                System.out.println();
                System.out.println();
                // 20. Ausgeben der Informationen ueber unterstuetzte Features
                System.out.println();
                System.out.println("--openjava----openjava----Unterstuetzte Features----openjava----openjava--");
                System.out.println();
                System.out.println();
                if(meine_metadata.supportsANSI92FullSQL()) {
                  System.out.println("Ansi92 SQL:                                            Voll unterstuetzt");
                }
                else {
                    if(meine_metadata.supportsANSI92IntermediateSQL()) {
                        System.out.println("Ansi92 SQL (1):                                      Teilweise Unterstuetzt");
                    }
                    else {
                        if(meine_metadata.supportsANSI92EntryLevelSQL()) {
                            System.out.println("Ansi92 SQL:                                          Ansatzweise Unterstuetzt");
                        }
                        else {
                            System.out.println("Ansi92 SQL:                                          wird nicht unterstuetzt");
                        }
                    }
                }

                if(meine_metadata.supportsStoredProcedures()) {
                    System.out.println("Stored Procedures:                                   werden unterstuetzt");
                }
                else {
                    System.out.println("Stored Procedures:                                   werden nicht unterstuetzt");
                }
                if(meine_metadata.supportsTransactions()) {
                    System.out.println("Transaktionen:                                       werden unterstuetzt");
                }
                else {
                    System.out.println("Transaktionen:                                       werden nicht unterstuetzt");
                }
                if(meine_metadata.supportsMultipleTransactions()) {
                    System.out.println("Multiple Transaktionen:                              werden unterstuetzt");
                }
                else {
                    System.out.println("Multiple Transaktionen:                              werden nicht unterstuetzt");
                }
                if(meine_metadata.supportsDataDefinitionAndDataManipulationTransactions()) {
                    System.out.println("Data Definition und Data Manipulation Transactions:  werden unterstuetzt");
                }
                else {
                    System.out.println("Data Definition und Data Manipulation Transactions:  werden nicht unterstuetzt");
                }
                if(meine_metadata.supportsGroupBy()) {
                    System.out.println("Group By:                                            wird unterstuetzt");
                }
                else {
                    System.out.println("Group By:                                            wird nicht unterstuetzt");
                }
                if(meine_metadata.supportsOuterJoins()) {
                    System.out.println("Outer Join:                                          wird unterstuetzt");
                }
                else {
                    System.out.println("Outer Join:                                          wird nicht unterstuetzt");
                }
                if(meine_metadata.supportsSelectForUpdate()) {
                    System.out.println("Select for Update:                                   wird unterstuetzt");
                }
                else {
                    System.out.println("Select for Update:                                   wird nicht unterstuetzt");
                }

                System.out.println();

                // 21 Ermittle die verfuegbare Tabellen sowie deren Aufbau
                System.out.println();System.out.println();
                System.out.println("--openjava----openjava----Tabellenaufbau----openjava----openjava--");
                System.out.println();
                System.out.println();

                // 22 Liste der die Tabellentypen erstellen
                String meine_Tabellen[] = { "TABLE" };

                // 23 Liste aller Tabellen ermitteln

                ResultSet meine_Tabellen_Ergebnisse = meine_metadata.getTables(null, null, "%", meine_Tabellen);

                // 24 Tabellen-Information ausgeben
                while(meine_Tabellen_Ergebnisse.next()) {
                    String tabellen_name = meine_Tabellen_Ergebnisse.getString(3);
                    System.out.println("Tabellenname:                        " + tabellen_name);
                    System.out.println();
                    ResultSet meine_Spalten_Ergebnisse = mein_stmnt.executeQuery("SELECT * FROM "+ tabellen_name);

                    //  Tabellenspalten ermitteln
                    ResultSetMetaData rsmd = meine_Spalten_Ergebnisse.getMetaData();
                    int anzahlDerSpalten = rsmd.getColumnCount();
                    for (int i=1; i<=anzahlDerSpalten; i++){
                        String spaltenName = rsmd.getColumnName(i);
                        String datenTyp = rsmd.getColumnTypeName(i);
                        boolean schreibbar = rsmd.isWritable(i);
                        boolean caseSens = rsmd.isCaseSensitive(i);
                        System.out.println("Name der Spalte:                     " + spaltenName);
                        System.out.println("verwendeter SQL-Datentyp:            " + datenTyp);
                        System.out.println("ist die Spalte schreibbar:           " + schreibbar);
                        System.out.println("ist der Spaltename Casesen sitive:   " + caseSens);
                    }

                    while(meine_Spalten_Ergebnisse.next()) {
                        System.out.println("        ");
                        for (int i=1; i<=anzahlDerSpalten; i++){
                            String derString = meine_Spalten_Ergebnisse.getString(i);
                            System.out.print(derString + "      ");
                        }
                        System.out.println();
                    }
                    System.out.println();
                }


        }
////////////  END METADATA      ////


            // 25. Verbindung zur Datenbank beenden
            mein_con.close();
            System.out.println("  ");
            System.out.println("INFO: Verbindung zur Datenbank geschlossen.");
            System.out.println();
        }
        // Ggf. aufgetretene Exceptions abfangen
        catch(SQLException sqlex) {
            System.out.println();
            System.out.println("  ");
            System.out.println("ERROR: Datenbankfehler: " + sqlex.getMessage());
            System.out.println("--------------------------------------------------------------------------");
            sqlex.printStackTrace();
            System.out.println();
            System.out.println("  ");
        }

        catch(Exception exp) {
            System.out.println();
            System.out.println("  ");
            System.out.println("ERROR: Sonstiger Fehler: " + exp.getMessage());
            System.out.println("--------------------------------------------------------------------------");
            exp.printStackTrace();
            System.out.println();
            System.out.println("  ");
        }


  }

    /**
    /* Funktion zum Auffuellen eines uebergebenen Strings st mit Leerzeichen     
    /* bis zur uebergebenen Laenge i */
   */

    private static String FormatierteAusgabe(String st, int i) {
        String  leereZeile = "                                                                ";
        if(st.length() < i)
            return st.concat(leereZeile.substring(0, (i - st.length())));
        else
            return st;
    }



    public static void  SchreibeErgebnis(ResultSet rs) {

           //Abfrageergebnis bearbeiten und ausgeben
            System.out.println();
            System.out.print(FormatierteAusgabe("Spieler_Nr:",17));
            System.out.print(FormatierteAusgabe("Name",17));
            System.out.print(FormatierteAusgabe("Vorname",17));
            System.out.print(FormatierteAusgabe("Gespielt",7));
            System.out.println();
            System.out.println("  ");

            try{
                // Solange Tabelle enthlt Daten, sollen diese Ausgegeben werden
                while(rs.next()) {
                    spieler_nummer = new Integer(rs.getInt("Spieler_Nr"));
                    spieler_name = rs.getString("Nachname");
                    spieler_vorname = rs.getString("Vorname");
                    spieler_gespielt = new Integer(rs.getInt("Gespielt"));

                    System.out.print(FormatierteAusgabe(spieler_nummer.toString(),17));
                    System.out.print(FormatierteAusgabe(spieler_name,17));
                    System.out.print(FormatierteAusgabe(spieler_vorname,17));
                    System.out.print(FormatierteAusgabe(spieler_gespielt.toString(),7));
                    System.out.println();

                }
            } catch(SQLException sqlex) {
                System.out.println();
                System.out.println("  ");
                System.out.println("ERROR: Datenbankfehler: " + sqlex.getMessage());
                System.out.println("--------------------------------------------------------------------------");
                sqlex.printStackTrace();
                System.out.println();
                System.out.println("  ");
            }

            System.out.println();
            System.out.println("  ");
    }

}