package server3;

import java.net.*;
import java.rmi.*;
import java.rmi.activation.*;
import java.security.*;
import java.util.*;

public class PasswortStart3 {
public static void main (String args[]) {
if (args.length != 3) {
System.err.println("Eingabe: java server.Datenbank <Server> <Port><Pfad zu Klassendateien>");
System.exit(1);
}
String server = args[0];
int port = Integer.parseInt(args[1]);
String dateiOrt=args[2];

//Security Manager
System.setSecurityManager(new RMISecurityManager());

try {

//Instanz des Objekts anlegen
Properties env = new Properties(); 
env.put("java.security.policy", "C:/home/fisch/private/Javabuch/buchcode/kapitel11/java.policy"); 
ActivationGroupID groupID= ActivationGroup.getSystem().registerGroup(new ActivationGroupDesc(env, null));
//Verwende verpacktes Objekt, um dem aktivierten Objekt
//mitzuzeilen, wo seine persistenten Daten sind
MarshalledObject kommandozeile=null;
ActivationDesc ad = new ActivationDesc(groupID, "server.DatabaseUpdateImpl3", dateiOrt, kommandozeile);
//Registrierung
DatabaseUpdate3 du = (DatabaseUpdate3)Activatable.register(ad);
System.out.println("rmid registriert");

//Binden
String url = "//"+server+":"+port+"/DatabaseUpdate3";
Naming.rebind(url,du);
}catch (Exception e) {
e.printStackTrace();
System.out.println(e.getMessage());
}
System.exit(0);
}
}
