                    /**
                   *  The Player class has data members to describe
                   *  a Player. String methods are available to
                   *  display the data members to the console or Web page.
                   *
                   *  @author OpenJava (c)
                   *  @version 1, 18 Mai 1999
                   *
                   */


                  import java.sql.*;
                  import javax.servlet.http.*;


                  public class Spieler
                  {
                      // data members

                      protected String lastName;
                      protected String firstName;
                      protected String email;
                      protected int  gespielt;
                      protected int gewonnen;
                      protected int verloren;
                      protected final String CR = "\n";     // carriage return

                      // constructors
                      public Spieler()
                      {
                      }

                      public Spieler(HttpServletRequest request)
                      {
                          lastName = request.getParameter("Nachname");
                          firstName = request.getParameter("Vorname");
                          email = request.getParameter("Email");
                      }

                      public Spieler(ResultSet dataResultSet)
                      {

                          try {
                              // assign data members
                              lastName =  dataResultSet.getString("Nachname");
                              firstName =  dataResultSet.getString("Vorname");
                              email = dataResultSet.getString("Email");
                              gespielt = dataResultSet.getInt("Gespielt");
                              gewonnen = dataResultSet.getInt("Gewonnen");
                              verloren = dataResultSet.getInt("Verloren");
                          }
                          catch (SQLException e)
                          {
                              e.printStackTrace();
                          }
                      }

                      //  accessors
                      public String getLastName()
                      {
                          return lastName;
                      }

                      public String getFirstName()
                      {
                          return firstName;
                      }

                      public String getEmail()
                      {
                          return email;
                      }

                      public int getGespielt()
                      {
                          return gespielt;
                      }

                       public int getGewonnen()
                      {
                          return gewonnen;
                      }

                       public int getVerloren()
                      {
                          return verloren;
                      }

                      //  methods
                      //  normal text string representation
                      public String toString()
                      {
                         String replyString = "";
                         replyString += "Name: " + lastName + ", " + firstName + CR;
                         replyString += "E-mail: " + email + CR;
                         replyString += "Gespielt: " + gespielt  + CR;
                         replyString += "Gewonnen: " + gewonnen  + CR;
                         replyString += "Verloren: " + verloren  + CR;
                         replyString +=  CR+ CR;
                         return replyString;
                      }

                      //  returns data as HTML formatted un-ordered list
                      public String toWebString()
                      {
                          String replyString = "<ul>";
                          replyString += "<li><B>Name:</B> " + lastName + ", " + firstName + CR;
                          replyString += "<li><B>E-mail:</B> " + email + CR;
                          replyString += "<li><B>Gespielt:</B> " + gespielt  +CR;
                          replyString += "<li><B>Gewonnen:</B> " + gewonnen  +CR;
                          replyString += "<li><B>Verloren:</B> " + verloren  +CR;

                          replyString += "</ul>" + CR;

                          return replyString;
                      }

                      // returns data formatted for an HTML table row
                      public String toTableString(int rowNumber)
                      {
                          String replyString = "";
                          String tdBegin = "<td>";
                          String tdEnd = "</td>" + CR;

                          replyString += "<tr>" + CR;
                          replyString += tdBegin + rowNumber + tdEnd;
                          replyString += tdBegin + lastName + ", " + firstName + tdEnd;
                          replyString += tdBegin + "<a href=mailto:" + email + "> "  + email + "</a>" + tdEnd;

                          replyString += tdBegin + gespielt + tdEnd;
                          replyString += tdBegin + gewonnen + tdEnd;
                          replyString += "</tr>" + CR;

                          return replyString;
                      }
                  }

