                  /**
                   *  This servlet provides data entry and retrieval of
                   *  Players data in a database.
                   *
                   *  @author OpenJava (c)
                   *  @version 1, 18 Mai 1999
                   *
                   */
                  import javax.servlet.*;
                  import javax.servlet.http.*;

                  import java.sql.*;
                  import java.io.*;
                  import java.util.*;


                  public class SpielerDBServlet extends HttpServlet

                  {
                      // data members
                      protected Connection dbConnection;
                      protected PreparedStatement displayStatement;
                      protected PreparedStatement registerStatement;

                      protected String dbURL = "jdbc:odbc:SpielerDatabase";
                      protected String userID = "";
                      protected String passwd = "";

                      protected String CR = "\n";

                      protected final int FIRST_NAME_POSITION = 1;
                      protected final int LAST_NAME_POSITION  = 2;
                      protected final int EMAIL_POSITION      = 3;

                      Server derSchiffeServer;
                      protected Thread myThread;
                      public String[] leer = {""};

                      public void init(ServletConfig config) throws ServletException
                      {
                          super.init(config);

                      }

                      public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
                      {
                        // Verbinden mit der Datenbank
                          try {
                             Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                             dbConnection = DriverManager.getConnection(dbURL, userID, passwd);
                             displayStatement =  dbConnection.prepareStatement("select * from SpielerDatabase");
                             registerStatement = dbConnection.prepareStatement("insert into SpielerDatabase"  + "(Vorname, Nachname, Email)" + " values (?, ?, ?)");
                          }
                          catch (Exception e)
                          {
                              cleanUp();
                              e.printStackTrace();
                          }

                          String userOption = null;
                          userOption = request.getParameter("Register");

                          if (userOption != null)
                          {
                              // hidden form field "Register" was present
                            registerSpieler(request, response);
                              // Beim Registrieren wird der Server (Schiffe Versenken) gestartet
                             if (myThread == null) {
                                 myThread = new StartTheSchiffeServer();
                                 myThread.start();
                             }

                          }
                          else
                          {
                              // simply display the Players
                              displaySpieler(request, response);
                          }
                           // close database connectivity
                           cleanUp();
                     }

                     public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
                      {
                            doGet(request, response);
                      }


                      public void displaySpieler(HttpServletRequest request,  HttpServletResponse response)
                      {
                          Spieler aSpieler = null;

                          try {

                              response.setContentType("text/html");
                              PrintWriter out = response.getWriter();

                              // build the html page heading
                              String htmlHead = "<html><head><title>Liste aller Spieler</title></head>" + CR;

                              // build the html body
                              String htmlBody = "<body><center>" + CR;
                              htmlBody += "<h1>Liste aller Spieler</h1>" + CR;
                              htmlBody += "<hr></center><p>" + CR;

                              // build the table heading
                              String tableHead = "<center><table border width=100% cellpadding=5>" + CR;
                              tableHead += "<tr>" + CR;
                              tableHead += "<th> </th>" + CR;
                              tableHead += "<th>Name des Spielers</th>" + CR;
                              tableHead += "<th>E-mail</th>" + CR;
                              tableHead += "<th>Gespielt</th>" + CR;
                              tableHead += "<th>Gewonnen</th>" + CR;
                              tableHead += "</tr>" + CR;

                              // execute the query to get a list of the Players
                               ResultSet dataResultSet = displayStatement.executeQuery();

                              // build the table body
                              String tableBody = "";

                              int rowNumber = 1;
                              while (dataResultSet.next())
                              {
                                  aSpieler = new Spieler(dataResultSet);
                                  tableBody +=  aSpieler.toTableString(rowNumber);
                                  rowNumber++;
                              }

                              dataResultSet.close();

                              // build the table bottom
                              String tableBottom = "</table></center>";

                              // build html page bottom
                              String htmlBottom = "</body></html>";

                              // build complete html page
                              htmlBody += tableHead + tableBody + tableBottom;

                              htmlBody += "<p><hr>";

                              // add the copyright statement
                              htmlBody += "<p><i>" + this.getServletInfo() + "</i>";
                              htmlBody += "</center>";
                              String htmlPage = htmlHead + htmlBody + htmlBottom;

                            // now let's send this dynamic data
                            // back to the browser
                    		out.println(htmlPage);
                         }
                          catch (Exception e)
                          {
                              cleanUp();
                              e.printStackTrace();
                          }
                      }

                      public void registerSpieler(HttpServletRequest  request, HttpServletResponse  response)
                      {
                          try {
                              response.setContentType("text/html");
                              PrintWriter out = response.getWriter();

                              // create a new Spieler based on the form data
                              Spieler aSpieler = new Spieler(request);

                              // set sql parameters
                              registerStatement.setString(LAST_NAME_POSITION, aSpieler.getLastName());
                              registerStatement.setString(FIRST_NAME_POSITION,  aSpieler.getFirstName());
                              registerStatement.setString(EMAIL_POSITION,   aSpieler.getEmail());
                              // execute sql
                              registerStatement.executeUpdate();

                              // build confirmation page
                              String htmlPage =  "<html><head><title>Confirmation Page</title></head>";

                              htmlPage += "<body>";
                              htmlPage += "<center><h1>Confirmation  Page</h1></center><hr>";
                              htmlPage += "Folgende Informationen wurden bearbeitet";
                              htmlPage += aSpieler.toWebString();

                              htmlPage += "<hr>";
                              // add the copyright statement
                              htmlPage += "<a href=/servlets/SpielerDBServlet>Siehe Liste aller Spieler</a>";
                              htmlPage += "<p><i>" + this.getServletInfo() + "</i>";
                              htmlPage += "</center></body></html>";

                             // now let's send this dynamic data
                            // back to the browser
                    		out.println(htmlPage);
                         }
                          catch (Exception e)
                          {
                              cleanUp();
                              e.printStackTrace();
                          }

                     }

                      public void cleanUp()
                      {
                          try {
                              System.out.println("Closing database connection");
                              dbConnection.close();
                          }
                          catch (SQLException e)
                          {
                              e.printStackTrace();
                          }

                      }

                      public void destroy()
                      {
                          System.out.println("SpielerDBServlet: destroy");
                          cleanUp();
                          myThread.stop();
                      }

                      public String getServletInfo()
                      {
                          return "<i>Spielerregistrierung-Servlet, v.1 <br> (c) OpenJava 1999</i>";
                      }



                       // inner class to start the server
                      public class StartTheSchiffeServer extends Thread {

                        public StartTheSchiffeServer(){
                            super();
                        }

                        public void run() {

                            try{
                                derSchiffeServer = new Server();
                                derSchiffeServer.main(leer);
                                myThread.sleep(1000);
                            } catch (Exception ie){}

                        }
                      }




                  }
