package server2;

import java.rmi.*;
import java.rmi.registry.*;

public class Datenbank2 {
    public static void main (String args[]) {
        if (args.length != 2) {
            System.err.println("Eingabe: java server.Datenbank2 <Server> <Port>");
            System.exit(1);
        }
        String server = args[0];
        int port = Integer.parseInt(args[1]);
        //Neuer Security Manager
        System.setSecurityManager(new RMISecurityManager());
        try {
            //Ort der Registry
            LocateRegistry.createRegistry(port);
            System.out.println("Registry definiert");
            //Instanz der Datenbankanwendung
            DatabaseUpdateImpl2 dui = new DatabaseUpdateImpl2();
            //Binden der Objektinstanz an entfernte Registry
            String urlString="//"+server+":"+port+"/DatabaseUpdate2";

            System.out.println("Namensbindung erfolgt");
            Naming.rebind(urlString, dui);
        }catch (Exception e) {
            System.out.println("Fehler aufgetreten");
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }
}
