import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.rmi.*;

public class GUISVUser extends Applet {
  SpielCanvasPos1 sc1;
  SpielCanvas sc2;
  Spielfeld spieler, computer;
  SVClient netz;
  Button shoot,  setship;
  Panel buttonPanel; // Panel fuer Buttons (shoot und setship)
  Panel sc1Panel; // im Zentrum dieses Panel wird Spielfeld des Computers plaziert
  Panel sc2Panel; // im Zentrum dieses Panel wird Spielfeld des Spielers plaziert
  Label label1; // Spielfeld des Computers
  Label label2; // Spielfeld des Spielers
  Container c;

  // Daten fr RMI-Client
    public boolean gewonnen = false;
    StartDerRMIClient srmi;
    public String[]  mainString0 = {"localhost","1234","0"}; // Spiel ist verloren
    public String[]  mainString1 = {"localhost","1234","1"}; // Spiel ist gewonnen
    Thread myThread;


  public void init() {

    computer = new Spielfeld();
    spieler = new Spielfeld();

    c = this;
    setLayout(new GridLayout(1,3,5,0));
    setSize(650,266);
    setBackground(new Color(16777215));

    // Setzen der Buttons
    buttonPanel = new Panel();
    buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
    buttonPanel.setBounds(0,0,142,266);
    buttonPanel.setBackground(new Color(16777215));
    add(buttonPanel);
    setship = new Button();
    setship.setLabel("Neues Spiel");
    setship.addActionListener(new ButtonListener(0));
    setship.setBounds(31,5,80,23);
    setship.setBackground(new Color(12632256));
    buttonPanel.add(setship);
    shoot = new Button("Schuss abgeben");
    shoot.setEnabled(false);
    shoot.addActionListener(new ButtonListener(1));
    shoot.setBounds(17,33,108,23);
    shoot.setBackground(new Color(12632256));
    buttonPanel.add(shoot);

    //Spielfeld des Computers
    sc1Panel = new Panel();
    sc1Panel.setLayout(new BorderLayout(0,0));
    sc1Panel.setBounds(142,0,142,266);
    sc1Panel.setBackground(new Color(16777215));
    sc1 = new SpielCanvasPos1(computer);
    sc1Panel.add("Center",sc1);
    label1 = new Label("Spielfeld des Computers", Label.LEFT);
    label1.setBounds(0,133,142,133);
    sc1Panel.add("South",label1);
    add(sc1Panel);

    //Spielfeld des Benutzers
    sc2Panel = new Panel();
    sc2Panel.setLayout(new BorderLayout(0,0));
    sc2Panel.setBounds(284,0,142,266);
    sc2Panel.setBackground(new Color(16777215));
    add(sc2Panel);
    sc2 = new SpielCanvas(spieler);
    sc2Panel.add("Center",sc2);
    label2 = new Label("Spielfeld des Benutzers", Label.LEFT);
    label2.setBounds(0,133,142,133);
    sc2Panel.add("South",label2);


  }

  public void ausgabeFenster (String s) {
      Object anker = getParent();
      while (! (anker instanceof Frame))
        anker = ((Component) anker).getParent();
      FehlerFenster dialog = new FehlerFenster((Frame)anker, s);
      //FehlerFenster dialog = new FehlerFenster(this, s);
      dialog.setVisible(true);
      dialog.setSize(400,100);
      return;
   }


  class ButtonListener implements ActionListener {
    private int val;
    String [] s;
    ButtonListener (int val) {
      //Schuss-Status, x- und y-Koordinate

      this.val = val;
    }

    public void actionPerformed(ActionEvent e) {
      Daten daten;
      Point p = null;
      daten = new Daten();
      if (val == 0){ //Schiffe setzen

        spieler.initialisieren();
        computer.initialisieren();
        try {
          netz = new SVClient((GUISVUser) c);
        } catch (IOException ioe){
          ausgabeFenster("Probleme beim Netzaufbau");
          return;
        }

        if (netz.SVSocket == null)
          return;
        SchiffFenster fenster = new SchiffFenster(spieler, c);
        fenster.setTitle("Schiffe setzen");
        fenster.pack();
        fenster.setVisible(true);
        fenster.setSize(600,350);
        shoot.setEnabled(true);
        repaint();

        // Thread der Datenbank mittels RMI-Client stoppen
        if (myThread != null){
            myThread.stop();
            myThread = null;
        }


      } else{
        //Schiessen
        getSchussKoordinaten();
        //Koordinaten bereits markiert?
        if (sc1.sa1.tmp.x == -1)
          return;
        daten.status=daten.SCHUSS;
        daten.p.x=sc1.sa1.tmp.x;
        daten.p.y=sc1.sa1.tmp.y;
        netz.sendData(daten);
        shoot.setEnabled(false);
        try {
          daten = netz.getData();
        }catch (IOException ioe) {}

        if (daten.status == daten.TREFFER) {
          //TREFFER
          System.out.println("Wir haben getroffen");
          //Einfaerben
          computer.spiel[sc1.sa1.tmp.x][sc1.sa1.tmp.y]=computer.VERSENKT;
          computer.schiffZahl--;
          if (computer.schiffZahl==0){
          // Anbinden an die Datenbank mittels RMI-Client, um Ergebnis zu schreiben
          gewonnen = true;
          if (myThread == null){
              myThread = new StartRMIClient();
              myThread.start();
          }
            //Gewinnmeldung
            ausgabeFenster("Herzlichen Glckwunsch, Sie haben gewonnen!");
            try {
              netz.beenden();
            } catch (IOException ioe) {}

            //Neues Spiel anbieten
            shoot.setEnabled(false);
            return;
          }
          sc1.sa1.tmp.x = sc1.sa1.tmp.y = -1;
          sc1.sa1.repaint();
          repaint();
          shoot.setEnabled(true);
        } else {
          System.out.println("Wasser");
          computer.spiel[sc1.sa1.tmp.x][sc1.sa1.tmp.y]=computer.WASSER;
          sc1.sa1.tmp.x = sc1.sa1.tmp.y = -1;
          sc1.sa1.repaint();
          rechnerTrifft(daten);
          if (spieler.schiffZahl!=0)
            shoot.setEnabled(true);
          sc2.repaint();
          repaint();
        }
      }
        validate();
    }


    public void rechnerTrifft(Daten d) {

      while (true) {
        if (spieler.spiel[d.p.x][d.p.y]!=spieler.SCHIFF)
          if (spieler.spiel[d.p.x][d.p.y]!=spieler.VERSENKT)
          {
          spieler.spiel[d.p.x][d.p.y]=spieler.WASSER;
          //Rechner schiesst ins Wasser
          return;
        }
        //Rechner hat uns wirklich getroffen
        d.status = d.TREFFER;
        netz.sendData(d);
        spieler.spiel[d.p.x][d.p.y]=spieler.VERSENKT;

        spieler.schiffZahl--;
        if (spieler.schiffZahl==0){

            // Anbinden an die Datenbank mittels RMI-Client, um Ergebnis zu Schreiben
            gewonnen = false;
            if (myThread == null){
               myThread = new StartRMIClient();
               myThread.start();
            }

          //Meldung dass Spieler verloren hat
            ausgabeFenster("Leider verloren!");
            try {
              netz.beenden();
            } catch (IOException ioe) {}

            //Neues Spiel anbieten
            shoot.setEnabled(false);
            return;
          }

        try {
            d = netz.getData();
        }catch (IOException ioe) {}
        shoot.setEnabled(false);

        sc2.repaint();
        repaint();
      }
    }
    public void getSchussKoordinaten() {

      System.out.println("Schuss auf "+sc1.sa1.tmp.x+" "+sc1.sa1.tmp.y);
      return;
    }
  }

    // Thread zum Starten des RMI-Clients, um den Datenbankeintrag zu aktualisieren
        public class StartRMIClient extends Thread{

           public StartRMIClient(){
              super();
           }
           public void run() {
              try {
                 server2.Klient2 kl2 = new server2.Klient2();
                 if (gewonnen) {
                     System.out.println("YAHOO Gewonnen!");
                     kl2.main(mainString1);
                 } else{
                     System.out.println("Schade Verloren!");
                     kl2.main(mainString0);
                 }
                 myThread.sleep(1000);
              }catch (Exception ex) {}
           }
        }

}