import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;

public class FokusBeispiel extends Applet
		            implements FocusListener,
				       ActionListener {

    TextArea anzeige;
    FocusFenster fenster;
    Button b1, b2;
    static final String ZEIGE= "zeige";
    static final String LOESCHE = "loesche";
    String neueZeile;

    public void init() {
	b1 = new Button("ffnen des Fensters.");
	b1.setActionCommand(ZEIGE);
	b1.addActionListener(this);

	b2 = new Button("Lschen der Anzeige.");
	b2.setActionCommand(LOESCHE);
	b2.addActionListener(this);

	anzeige = new TextArea(5, 20);

	setLayout(new BorderLayout());
	add("North", anzeige);
	add("Center", b1);
	add("South", b2);

	//Neues Fenster erzeugen, aber nicht anzeigen.
	fenster = new FocusFenster(this);

	neueZeile = System.getProperty("line.separator");
    }

    public void stop() {
	fenster.setVisible(false);
    }

    public void focusGained(FocusEvent e) {
	nachricht("Fokus erhalten", e);
    }

    public void focusLost(FocusEvent e) {
	nachricht("Fokus verloren", e);
    }

    void nachricht(String n, FocusEvent e) {
	anzeige.append(n
		       + ": "
		       + e.getComponent()
		       + neueZeile); 
    }

    public void actionPerformed(ActionEvent e) {
	if (e.getActionCommand() == ZEIGE) {
	    fenster.pack();
	    fenster.setVisible(true);
	} else { //LOESCHE
	    anzeige.setText("");
	}
    }
}

class FocusFenster extends Frame {

    public FocusFenster(FocusListener l) {
	//Verwende Konstruktor der Superklasse Frame
	super("Fokus-Event-Fenster");
	GridLayout g = new GridLayout(1,2);
	setLayout(g);


	this.addFocusListener(l);

	TextField tf = new TextField("TextField");
	tf.addFocusListener(l);
	add(tf);

	Button b= new Button("Button");
	b.addFocusListener(l);
	add(b);
    }
}
