import java.awt.*;
import java.awt.event.*;

public class SelectionArea extends Canvas {
  Point tmp;
  Spielfeld s;

  public SelectionArea(Spielfeld s) {
    super();
    this.s = s;
    tmp = new Point(-1,-1);
    validate();
  }

    public void paint(Graphics screen) {
        int i,j;
        // Erzeuge Quadrat als Spielfeldbegrenzung

        screen.setColor(Color.white);
        screen.fillRect(0,0,200,200);
        screen.setColor(Color.black);
        screen.drawRect(0,0,200,200);
        // Erzeuge horizontale und vertikale Linien
        for (i = 1; i < 10; i++){

          screen.drawLine(0, 0+i*20,200, 0+i*20);
          screen.drawLine(0+i*20, 0,0+i*20, 200);
        }
        // Markiere Schiffe und Wasser
        for (i = 0; i < 10; i++)
          for (j = 0; j < 10; j++)
            if (s.spiel[i][j]!= s.FREI){
              switch (s.spiel[i][j]) {
                case s.WASSER:
                  // Erzeuge blaues Quadrat
                  screen.setColor(Color.blue);
                  screen.fillRect(i*20+1,j*20+1,20-1,20-1);
                break;
                case s.SCHIFF:
                  // Erzeuge gruenes Quadrat
                  screen.setColor(Color.green);
                  screen.fillRect(i*20+1,j*20+1,19,19);
                break;
                case s.VERSENKT:
                  // Erzeuge rotes Quadrat
                  screen.setColor(Color.red);
                  screen.fillRect(i*20+1,j*20+1,19,19);
                break;
                default:
                break;
              }
          }

        //Zeichne Koordinate ein
        if (tmp.x != -1){
          screen.setColor(Color.green);
          screen.fillRect(tmp.x*20+1,tmp.y*20+1,19,19);
        }
    }

}

