import java.io.*;
import java.net.*;
import java.awt.*;


public class SVClient {
String sendeZeile, empfangsZeile;
Socket SVSocket;
PrintWriter senden = null;
BufferedReader empfangen= null;
Daten daten;

GUISVUser s;

public SVClient (GUISVUser s) throws IOException{
   this.s = s;
   SVSocket = null;
   try {
     SVSocket = new Socket("localhost", 4444);

     senden = new PrintWriter(SVSocket.getOutputStream(), true);
     empfangen = new BufferedReader(new InputStreamReader(SVSocket.getInputStream()));
   } catch (UnknownHostException e) {
      System.err.println("Host unbekannt: plato.");
      System.exit(1);
   } catch (IOException e) {
     System.err.println("I/O zu Plato abgelehnt.");
     s.ausgabeFenster("Probleme bei der Netzwerkverarbeitung");
     return;
    }
}
  public Daten  getData () throws IOException{
    Daten d = new Daten();

    if ((empfangsZeile = empfangen.readLine()) != null){ 
      if (empfangsZeile.equalsIgnoreCase("0"))
        d.status = d.SCHUSS;
      if (empfangsZeile.equalsIgnoreCase("2"))
        d.status = d.TREFFER;
    }

    if ((empfangsZeile = empfangen.readLine()) != null) 
      d.p.x = Integer.parseInt(empfangsZeile);
    if ((empfangsZeile = empfangen.readLine()) != null) 
      d.p.y = Integer.parseInt(empfangsZeile);
    
    System.out.println("Server schickt: ("+d.p.x+","+d.p.y+")");
  
    return d;
  }
  public void sendData (Daten d) {
    //Senden der Statusinfo, der x- und y-Koordinaten
    senden.println(""+d.status);
    senden.println(""+d.p.x);
    senden.println(""+d.p.y);
  }

  public void beenden () throws IOException{
    try {
      senden.close();
      empfangen.close();
      SVSocket.close();
    } catch (IOException e) {}

  }
}
