import java.net.*;
import java.io.*;
import java.awt.*;


public class SVServer {
   String sendeZeile, empfangsZeile;
   PrintWriter senden;
   BufferedReader empfangen;
   ServerSocket serverSocket; 
   Socket clientSocket;

  public SVServer() throws IOException {
    serverSocket = null;
    try {
      serverSocket = new ServerSocket(4444);
    } catch (IOException e) {
      System.err.println("Port nicht verfgbar: 4444.");
      System.exit(1);
    }
    clientSocket = null;
    try {
      clientSocket = serverSocket.accept();
    } catch (IOException e) {
      System.err.println("Accept fehlgeschlagen.");
      System.exit(1);
    }
    senden = new PrintWriter(clientSocket.getOutputStream(), true);
    empfangen= new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
  }


public Daten  getData () throws IOException{
    Daten d = new Daten();
    if ((empfangsZeile = empfangen.readLine()) != null){ 
      if (empfangsZeile.equalsIgnoreCase("0"))
        d.status = d.SCHUSS;
      if (empfangsZeile.equalsIgnoreCase("2"))
        d.status = d.TREFFER;
    }

    if ((empfangsZeile = empfangen.readLine()) != null) 
      d.p.x = Integer.parseInt(empfangsZeile);
    if ((empfangsZeile = empfangen.readLine()) != null) 
      d.p.y = Integer.parseInt(empfangsZeile);
        
    System.out.println("Client schickt: ("+d.p.x+","+d.p.y+")");

    return d;
  }
  public void sendData (Daten d) {
    //Senden der Statusinfo, der x- und y-Koordinaten
    senden.println(""+d.status);
    senden.println(""+d.p.x);
    senden.println(""+d.p.y);
  }

  
public void beenden () {    
  try {
    senden.close();
    empfangen.close();
    clientSocket.close();
    serverSocket.close();
  } catch (IOException e) {
      System.out.println("Fehler beim Schliessen der Verbindung");
  }
}
}
