/** Beispiel Swing1.java fr das Buch OpenJava
 * Das ist eine Java Application, in der zwei Views fr ein Datenmodell erstellt werden.
 * <BR> Starten mit: Java Swing1
 * @version 1.0  Date: 20.12.1998
 * @author      OpenJava Buch
 * @version     1.0  Date: 20.12.1998
 * @since       JDK1.2
*/
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
    public class Swing1 extends JFrame {
        // Einfaches Datenmodell: Naturliche Zahlen zwischen 0 und 100, Anfangswert 30.
        DefaultBoundedRangeModel myModel = new DefaultBoundedRangeModel(30,1,0,100);
            public Swing1() {
                super("Swing 1");
                // Ein JSlider und ein JProgressBar werden instantiiert
                // JSlider ndert den Wert der Zahl, JProgressBar zeigt ihn an.
                // Beide Swing Komponenten haben ein gemeinsames Datenmodell
                JSlider mySlider = new JSlider(myModel);
                JProgressBar myProgressBar = new JProgressBar(myModel);
                JPanel myJPanel = new JPanel(false);
                // Etwas fr das Layout, genaure Beschreibung, siehe Swing API
                mySlider.setPaintTicks(true);
                mySlider.setPaintLabels(true);
                mySlider.setMajorTickSpacing(20);
                mySlider.setMinorTickSpacing(5);
                myJPanel.setLayout(new BoxLayout(myJPanel, BoxLayout.Y_AXIS));
               	myJPanel.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
               	myJPanel.add(mySlider);
               	myJPanel.add(myProgressBar);
               	setContentPane(myJPanel);

            }
               	// Main Funktion mit Null Argumente
               	public static void main(String[] args) {
               	    JFrame frame = new Swing1();
               	    // Innere Adapterklasse
               	    WindowListener l = new WindowAdapter() {
               	        public void windowClosing(WindowEvent e) { System.exit(0); }
               	        };
               	        frame.addWindowListener(l);
               	        frame.pack();
               	        frame.setVisible(true);
               	}
    }