/** Beispiel Swing4.java fr das Buch OpenJava
 * Das ist eine Java Application, in der drei Views
 * fr ein Datenmodell erstellt werden.
 * <BR> Starten mit: Java Swing3
 * @version 1.0  Date: 20.12.1998
 * @author      OpenJava Buch
 * @version     1.0  Date: 20.12.1998
 * @since       JDK1.2
*/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


// Adapter-Klasse: Ermglicht die Nutzung eines
// JTextField als View fr ein BoundedRangeModel.
class IntegerToTextAdapter implements ChangeListener {
    BoundedRangeModel myModel;
    JTextField	myTextField;
    public IntegerToTextAdapter(BoundedRangeModel theModel, JTextField theText) {
        myModel=theModel;
        myTextField=theText;
        // Adapter als Listener beim Model anmelden
        myModel.addChangeListener(this);
        myTextField.setText((new Integer(myModel.getValue())).toString());
    }
        public void stateChanged(ChangeEvent e) {
            // Model hat sich gendert: Text soll angepasst werden
            myTextField.setText((new Integer(myModel.getValue())).toString());
        }
}



public class Swing4 extends JFrame {
        // Einfaches Datenmodell: Naturliche Zahlen zwischen 0 und 100, Anfangswert 30.
        BoundedRangeModel myModel = new DefaultBoundedRangeModel(30,1,0,100);
        String buttonLabel = "Ruecksetzen";
        JButton resetButton = new JButton(buttonLabel);
    //    Button resetButton = new Button("Ruecksetzen");
             public Swing4() {
                super("Swing 4");
                // Ein JSlider und ein JProgressBar werden instantiiert
                // JSlider ndert den Wert der Zahl, JProgressBar zeigt ihn an.
                // Beide Swing Komponenten haben ein gemeinsames Datenmodell
                JSlider mySlider = new JSlider(myModel);
                JProgressBar myProgressBar = new JProgressBar(myModel);
                JTextField myTextField = new JTextField();
                JPanel myJPanel = new JPanel(false);
                // Etwas fr das Layout, genaure Beschreibung, siehe Swing API
                mySlider.setPaintTicks(true);
                mySlider.setPaintLabels(true);
                mySlider.setMajorTickSpacing(20);
                mySlider.setMinorTickSpacing(5);
                myJPanel.setLayout(new BoxLayout(myJPanel, BoxLayout.Y_AXIS));
               	myJPanel.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
               	// Ein JTextField kann normalerweise mit einem BoundedRangeModel nichts anfangen.
                // Deshalb: ein Adapter zwischen dem Model und dem JTextField.
                IntegerToTextAdapter myAdapter = new IntegerToTextAdapter(myModel,myTextField);
               	myTextField.setEditable(false);
               	myJPanel.add(myTextField);
               	myJPanel.add(mySlider);
               	myJPanel.add(myProgressBar);

                resetButton.setMnemonic(buttonLabel.charAt(0));
      //        resetButton.setMnemonic('R');
                resetButton.setToolTipText("Wert zurcksetzen");

               	myJPanel.add(resetButton);
               	setContentPane(myJPanel);

		        ButtonAction theAction = new ButtonAction();
		        resetButton.addActionListener(theAction);


            }
               	// Main Funktion mit Null Argumente
               	public static void main(String[] args) {
               	    JFrame frame = new Swing4();
               	    // Innere Klasse
               	    WindowListener l = new WindowAdapter() {
               	        public void windowClosing(WindowEvent e) { System.exit(0); }
               	        };
               	        frame.addWindowListener(l);
               	        frame.pack();
               	        frame.setVisible(true);
               	}
    // Innere Klasse als ActionEvent Adapter
    class ButtonAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
		   Object theObject = event.getSource();
		   if (theObject == resetButton)

		       reset_Action(event);
        }
	}

    // Setzt den Wert auf 30 Zurck
    public void reset_Action(java.awt.event.ActionEvent event) {
         myModel.setValue(30);
    }
}