/** Beispiel Swing5.java fr das Buch OpenJava
 * Das ist eine Java Application, in der drei Views
 * fr ein Datenmodell erstellt werden.
 * <BR> Starten mit: Java Swing5
 * @version 1.0  Date: 20.12.1998
 * @author      OpenJava Buch
 * @version     1.0  Date: 20.12.1998
 * @since       JDK1.2
*/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


// Adapter-Klasse: Ermglicht die Nutzung eines
// JTextField als View fr ein BoundedRangeModel.
class IntegerToTextAdapter implements ChangeListener {
    BoundedRangeModel myModel;
    JTextField	myTextField;
    public IntegerToTextAdapter(BoundedRangeModel theModel, JTextField theText) {
        myModel=theModel;
        myTextField=theText;
        // Adapter als Listener beim Model anmelden
        myModel.addChangeListener(this);
        myTextField.setText((new Integer(myModel.getValue())).toString());
    }
        public void stateChanged(ChangeEvent e) {
            // Model hat sich gendert: Text soll angepasst werden
            myTextField.setText((new Integer(myModel.getValue())).toString());
        }
}



public class Swing5 extends JFrame {
        // Einfaches Datenmodell: Naturliche Zahlen zwischen 0 und 100, Anfangswert 30.
        BoundedRangeModel myModel = new DefaultBoundedRangeModel(30,1,0,100);
        String buttonLabel = "Ruecksetzen";
        JButton resetButton = new JButton(buttonLabel);
    //  Button resetButton = new Button("Ruecksetzen");

        JMenuBar menuBar;
        public String currentUI = "Metal";

       // L&F radio buttons wobei mac L&F nicht untersttzt ist
      //  JRadioButtonMenuItem macMenuItem; //
        JRadioButtonMenuItem metalMenuItem;
        JRadioButtonMenuItem motifMenuItem;
        JRadioButtonMenuItem windowsMenuItem;

             public Swing5() {
                super("Swing 5");
                // Ein JSlider und ein JProgressBar werden instantiiert
                // JSlider ndert den Wert der Zahl, JProgressBar zeigt ihn an.
                // Beide Swing Komponenten haben ein gemeinsames Datenmodell
                JSlider mySlider = new JSlider(myModel);
                JProgressBar myProgressBar = new JProgressBar(myModel);
                JTextField myTextField = new JTextField();
                JPanel myJPanel = new JPanel(false);
                // Etwas fr das Layout, genaure Beschreibung, siehe Swing API
                mySlider.setPaintTicks(true);
                mySlider.setPaintLabels(true);
                mySlider.setMajorTickSpacing(20);
                mySlider.setMinorTickSpacing(5);
                myJPanel.setLayout(new BoxLayout(myJPanel, BoxLayout.Y_AXIS));
               	myJPanel.setBorder(BorderFactory.createMatteBorder(5,5,5,5,Color.red));
               	// Ein JTextField kann normalerweise mit einem BoundedRangeModel nichts anfangen.
                // Deshalb: ein Adapter zwischen dem Model und dem JTextField.
                IntegerToTextAdapter myAdapter = new IntegerToTextAdapter(myModel,myTextField);
               	myTextField.setEditable(false);
               	myJPanel.add(myTextField);
               	myJPanel.add(mySlider);
               	myJPanel.add(myProgressBar);

                resetButton.setMnemonic(buttonLabel.charAt(0));
      //        resetButton.setMnemonic('R');
                resetButton.setToolTipText("Wert zurcksetzen");

               	myJPanel.add(resetButton);
               	setContentPane(myJPanel);

		        ButtonAction theAction = new ButtonAction();
		        resetButton.addActionListener(theAction);

                // Einfgen der Menu und MenuItems

            menuBar = new JMenuBar();
        	menuBar.setOpaque(true);
        	JMenu dialogs = buildDialogMenu();
        	JMenu help    = buildHelpMenu();

        	// Options Menu
        	JMenu options = new JMenu("Look&Feel");
            options.setMnemonic('L');
    	    options.getAccessibleContext().setAccessibleDescription("Look and Feel optionen: selectiere eins von den angebotenen Look and Feels");

            // Look and Feel Radio control
        	ButtonGroup group = new ButtonGroup();
        	ToggleUIListener toggleUIListener = new ToggleUIListener();

            metalMenuItem = (JRadioButtonMenuItem) options.add(new JRadioButtonMenuItem("Java Look and Feel"));
        	metalMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("Metal"));
        	metalMenuItem.setSelected(true);
        	group.add(metalMenuItem);
        	metalMenuItem.addItemListener(toggleUIListener);
        	metalMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_1, ActionEvent.ALT_MASK));

            motifMenuItem = (JRadioButtonMenuItem) options.add(new JRadioButtonMenuItem("Motif Look and Feel"));
        	motifMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("CDE/Motif"));
        	group.add(motifMenuItem);
        	motifMenuItem.addItemListener(toggleUIListener);
        	motifMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_2, ActionEvent.ALT_MASK));

            windowsMenuItem = (JRadioButtonMenuItem) options.add(new JRadioButtonMenuItem("Windows Style Look and Feel"));
        	windowsMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("Windows"));
        	group.add(windowsMenuItem);
        	windowsMenuItem.addItemListener(toggleUIListener);
        	windowsMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_3, ActionEvent.ALT_MASK));



        	menuBar.add(dialogs);
        	menuBar.add(options);
        	menuBar.add(help);
        	setJMenuBar(menuBar);

    }

    // Erzeugen der Dialoge Menu
    protected JMenu buildDialogMenu() {
	JMenu     dialogsMenu       = new JMenu("Dialogs");
    dialogsMenu.setMnemonic('D');
	JMenuItem message    = new JMenuItem("Message Dialog");
	JMenuItem warning    = new JMenuItem("Warning Dialog");
	JMenuItem confirm    = new JMenuItem("Confirmation Dialog");
	JMenuItem input      = new JMenuItem("Input Dialog");
	JMenuItem select     = new JMenuItem("Select Dialog");

	JMenuItem quit       = new JMenuItem("Beenden");

	message.addActionListener(new ActionListener() {
	     public void actionPerformed(ActionEvent e) {
			JOptionPane.showMessageDialog(null, "Fehler Haft", "Message", JOptionPane.INFORMATION_MESSAGE);

	}});

	warning.addActionListener(new ActionListener() {
	     public void actionPerformed(ActionEvent e) {
		    Object[] options = { "OK", "CANCEL" };
            JOptionPane.showOptionDialog(null, "Click OK to continue", "Warning",
               JOptionPane.DEFAULT_OPTION, JOptionPane.WARNING_MESSAGE, null, options, options[0]);
	}});

	confirm.addActionListener(new ActionListener() {
	     public void actionPerformed(ActionEvent e) {
		    JOptionPane.showConfirmDialog(null,
               "Einverstanden", "Confirm Dialog", JOptionPane.YES_NO_OPTION);
	}});

	input.addActionListener(new ActionListener() {
	     public void actionPerformed(ActionEvent e) {
            String inputValue = JOptionPane.showInputDialog("Trage einen Wert ein");

         }});

	select.addActionListener(new ActionListener() {
	     public void actionPerformed(ActionEvent e) {
    	     Object[] possibleValues = { "Erste", "Zweite", "Dritte" };
             Object selectedValue = JOptionPane.showInputDialog(null,
                       "Waehle", "Input",
                       JOptionPane.INFORMATION_MESSAGE, null,
                       possibleValues, possibleValues[0]);
        }});

	quit.addActionListener(new ActionListener() {
	     public void actionPerformed(ActionEvent e) {
			  quit();
	}});

	dialogsMenu.add(message);
	dialogsMenu.add(warning);
	dialogsMenu.add(confirm);
	dialogsMenu.add(input);
	dialogsMenu.add(select);
	dialogsMenu.addSeparator();
	dialogsMenu.add(quit);
	return dialogsMenu;
    }


    protected JMenu buildHelpMenu() {
	JMenu help = new JMenu("Help");
    help.setMnemonic('H');
    JMenuItem about = new JMenuItem("Open Java...");
	JMenuItem openHelp = new JMenuItem("Contact");

	about.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
	        showHelpWindow( "OpenJava Buch 1998");
	  }});

	openHelp.addActionListener(new ActionListener() {
	  public void actionPerformed(ActionEvent e) {
		showHelpWindow("Fragen an: openjava@kom.tu-darmstadt.de");
	}});

	help.add(about);
	help.add(openHelp);

	return help;
    }


   public void showHelpWindow(String satz) {
        JOptionPane.showMessageDialog(this, satz);
    }




    /**
     * Wechsle zwichen den verschiedenen untersttzten
     * Look and Feel: Windows, Motif, and the Java Look and Feel
     */
    class ToggleUIListener implements ItemListener {
   public void itemStateChanged(ItemEvent e) {
    	   Component root = getRootComponent();
	       root.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    	   JRadioButtonMenuItem rb = (JRadioButtonMenuItem) e.getSource();
           try {
    	     if(rb.isSelected() && rb.getText().equals("Windows Style Look and Feel")) {
            		currentUI = "Windows";
            	    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            	    SwingUtilities.updateComponentTreeUI(getRootComponent());
             } else if(rb.isSelected() && rb.getText().equals("Motif Look and Feel")) {
    		        currentUI = "Motif";
    	    	    UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
    	    	    SwingUtilities.updateComponentTreeUI(getRootComponent());
    	     } else if(rb.isSelected() && rb.getText().equals("Java Look and Feel")) {
    		        currentUI = "Metal";
                    UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
    	    	    SwingUtilities.updateComponentTreeUI(getRootComponent());
    	    }
          } catch (UnsupportedLookAndFeelException exc) {
    		// Error - unsupported L&F
    	          rb.setEnabled(false);
                   System.err.println("Unsupported LookAndFeel: " + rb.getText());

    		// Trotzdem Setze das L&F zu  dem Java Standard Look and Feel
                		try {
                		    currentUI = "Metal";
                		    metalMenuItem.setSelected(true);
                		    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                		    SwingUtilities.updateComponentTreeUI(getRootComponent());
                		} catch (Exception exc2) {
                		    System.err.println("Could not load LookAndFeel: " + exc2);
            		    }
          }
           catch (Exception exc) {
                        rb.setEnabled(false);
                        System.err.println("Could not load LookAndFeel: " + rb.getText());
           }
    	    root.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
   }
    }



  public Container getRootComponent() {
    return this;
  }


  public void quit() {
        System.exit(0);
    }



      	// Main Funktion mit Null Argumente
       	public static void main(String[] args) {
       	    JFrame frame = new Swing5();
       	    // Innere Klasse
       	    WindowListener l = new WindowAdapter() {
      	        public void windowClosing(WindowEvent e) { System.exit(0); }
      	    };
            frame.addWindowListener(l);
            frame.pack();
            frame.setVisible(true);
        }

                // Innere Klasse als ActionEvent Adapter
    class ButtonAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
		   Object theObject = event.getSource();
		   if (theObject == resetButton)

		       reset_Action(event);
        }
	}

    // Setzt den Wert auf 30 Zurck
    public void reset_Action(java.awt.event.ActionEvent event) {
         myModel.setValue(30);
    }
}