/** Beispiel BorderPanel.java fr das Buch OpenJava
 * Das ist eine Java Application, die verschiedene Rnder zeigt
 * <BR> Starten mit: Java BorderPanel
 * @author      OpenJava Buch
 * @version     1.0  Date: 06.03.1999
 * @since       JDK1.2
*/


import javax.swing.*;
import javax.swing.border.*;

import java.awt.*;
import java.awt.event.*;

public class BorderPanel extends JPanel {
 public BorderPanel() {
                     setLayout (new GridLayout (4, 3, 5, 5));
                     JButton b = new JButton("Empty");
                     b.setBackground (SystemColor.control);
                     b.setBorder (new EmptyBorder (1,1,1,1));
                     add(b);
                     b = new JButton ("Etched");
                     b.setBackground (SystemColor.control);
                     b.setBorder (new EtchedBorder ());
                     add(b);
                     b = new JButton ("ColorizedEtched");
                     b.setBackground (SystemColor.control);
                     b.setBorder (new EtchedBorder (Color.red, 
                                                     Color.green));
                     add(b);
                     b = new JButton ("Titled/Line");
                     b.setBackground (SystemColor.control);
                     b.setBorder(new TitledBorder (
                       new TitledBorder(
                         LineBorder.createGrayLineBorder(),
                         "Schiffe"),
                       "Versenken",
                       TitledBorder.RIGHT,
                       TitledBorder.BOTTOM));
                     add(b);
                     b = new JButton ("Bevel Up");
                     b.setBackground (SystemColor.control);
                     b.setBorder(new BevelBorder(BevelBorder.RAISED));
                     add(b);
                     b = new JButton ("Bevel Down");
                     b.setBackground (SystemColor.control);
                     b.setBorder(new BevelBorder(BevelBorder.LOWERED));
                     add(b);
                     b = new JButton ("Soft Bevel");
                     b.setBackground (SystemColor.control);
                     b.setBorder(new SoftBevelBorder(SoftBevelBorder.LOWERED));
                     add(b);
                     b = new JButton ("Matte");
                     b.setBackground (SystemColor.control);
                     b.setBorder(new MatteBorder(5, 10, 5, 10, Color.red));
                     add(b);
                     b = new JButton ("Matte Icon");
                     b.setBackground (SystemColor.control);
                     Icon icon = new ImageIcon ("face1.gif");
                     b.setBorder(new MatteBorder(10, 10, 10, 10, icon));
                     add(b);
                     b = new JButton ("ColorizedBezel");
                     b.setBackground (SystemColor.control);
                     b.setBorder(new BevelBorder(BevelBorder.RAISED, 
                                                 Color.red, Color.pink));
                     add(b);
                    
                    
                   }
                 
   public static void main(String[] args){
        JFrame frame = new JFrame("JListPanel");

        BorderPanel bp = new BorderPanel();
        frame.getContentPane().add(bp);
        frame.pack();
        frame.setVisible(true);
    }

}