/** Beispiel BoxLayoutBsp.java fr das Buch OpenJava
 * Das ist eine Java Application, in der drei Views
 * fr ein Datenmodell erstellt werden.
 * <BR> Starten mit: Java BoxLayoutBsp
 * @version 1.0  Date: 28.02.1999
 * @author      OpenJava Buch
 * @version     1.0  Date: 20.12.1999
 * @since       JDK1.2
*/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


public class BoxLayoutBsp extends JFrame {


  public BoxLayoutBsp() {
       super("BoxLayout. Bsp");

        Button Button1 = new Button("Button1");
        Button Button2 = new Button("Button2");
        Button Button3 = new Button("Button3");
        Button Button4 = new Button("Button4");
        Button Button5 = new Button("Button5");
        Button Button6 = new Button("Button6");

        JPanel JPanel1 = new JPanel(false);
        JPanel1.setLayout(new BoxLayout(JPanel1, BoxLayout.Y_AXIS));
        JPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10,10,10,10), "JPanel1"));
        JPanel1.add(Button1);
        JPanel1.add(Button2);
        JPanel1.add(Button3);

        JPanel JPanel2 = new JPanel(false);
        JPanel2.setLayout(new BoxLayout(JPanel2, BoxLayout.Y_AXIS));
        JPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10,10,10,10), "JPanel2"));

       // JPanel2.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        JPanel2.add(Button4);
        JPanel2.add(Button5);
        JPanel2.add(Button6);

        JPanel JPanel3 = new JPanel(false);
        JPanel3.setLayout(new BoxLayout(JPanel3, BoxLayout.X_AXIS));
        JPanel3.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        JPanel3.add(JPanel1);
        JPanel3.add(JPanel2);

        setContentPane(JPanel3);
      }
               	// Main Funktion mit Null Argumente
               	public static void main(String[] args) {
               	    JFrame frame = new BoxLayoutBsp();
               	    // Innere Klasse
               	    WindowListener l = new WindowAdapter() {
               	        public void windowClosing(WindowEvent e) { System.exit(0); }
               	        };
               	        frame.addWindowListener(l);
               	        frame.pack();
               	        frame.setVisible(true);
               	}

}