/** Beispiel JInternalFrameDemo.java fr das Buch OpenJava
 * Das ist eine Java Application, in der die Benutzung
 * von JInternalFrame gezeigt wird
 * <BR> Starten mit: Java JInternalFrameDemo
 * @author      OpenJava Buch
 * @version 1.0  Date: 08.03.1999
 * @since       JDK1.2
*/


import javax.swing.JInternalFrame;
import javax.swing.JDesktopPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JMenuBar;
import javax.swing.JFrame;

import java.awt.event.*;
import java.awt.*;

public class JInternalFrameDemo extends JFrame {

    JDesktopPane desktop;
     int offeneFrames = 0;
    public JInternalFrameDemo() {
        super("JInternalFrameDemo");

  // Erstellen eines groen Fenster
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        setBounds(inset, inset, screenSize.width - inset*2, screenSize.height-inset*2);

        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });

        // Definition der GUI
        desktop = new JDesktopPane(); //ein spezielles JLayeredPane
        createFrame(); //Damit ein JInternalFrame direkt erscheint

        setContentPane(desktop);
        setJMenuBar(createMenuBar());
    }

// Um neue JInternalFrame zu Erzeugen
    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();

        JMenu menu = new JMenu("JInternalFrame");
        JMenuItem menuItem = new JMenuItem("Neu");
        menuItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                createFrame();
            }
        });
        menu.add(menuItem);
        menuBar.add(menu);

        return menuBar;
    }

    // Die Erzeugung von JInternalFrame
    protected void createFrame() {

        JInternalFrame frame = new JInternalFrame("InternalFrame#" + (++offeneFrames),true,true,true,true);
        frame.setLocation(20*offeneFrames,20*offeneFrames);
        frame.setSize(200,200);
        desktop.add(frame);
        try {
            frame.setSelected(true);
        } catch (java.beans.PropertyVetoException e2) {}
    }

    public static void main(String[] args) {
        JInternalFrameDemo frame = new JInternalFrameDemo();
        frame.setVisible(true);
    }
}