/** Beispiel JSpliterPanel.java fr das Buch OpenJava
 * Das ist eine Java Application, die JSpliterPanel zeigt
 * <BR> Starten mit: Java JSpliterPanel
 * @author      OpenJava Buch
 * @version     1.0  Date: 08.03.1999
 * @since       JDK1.2
*/



import java.awt.event.*;
import java.awt.*;
import javax.swing.event.*;
import java.util.*;
import javax.swing.*;

public class JSpliterPanel extends javax.swing.JPanel
{
    private JSplitPane splitPane, splitPaneBottom;
	private JButton topButton = new JButton("Top");
	private JButton rightButton = new JButton("BottomRight");
	private JButton leftButton = new JButton("BottomLeft");

	public JSpliterPanel()
	{
		setLayout(new BorderLayout(0,0));
		setSize(405,279);
		setFont(new Font("Dialog", Font.PLAIN, 12));
		setForeground(new Color(0));
		setBackground(new Color(-3355444));

        splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        splitPaneBottom = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
        splitPane.setTopComponent(topButton);
        splitPaneBottom.setRightComponent(rightButton);
        splitPaneBottom.setLeftComponent(leftButton);
        splitPane.setBottomComponent(splitPaneBottom);
        splitPane.setOneTouchExpandable(true);
        splitPaneBottom.setOneTouchExpandable(true);

        //Provide minimum sizes for the two components in the split pane
        Dimension minimumSize = new Dimension(100, 50);

        //Set the initial location and size of the divider
        splitPane.setDividerLocation(150);
        splitPane.setDividerSize(10);
        splitPaneBottom.setDividerLocation(150);
        splitPaneBottom.setDividerSize(10);

        //Provide a preferred size for the split pane
        splitPane.setPreferredSize(new Dimension(400, 200));
        splitPaneBottom.setPreferredSize(new Dimension(400, 200));

        this.add(splitPane);

    }


        public JSplitPane getSplitPane() {
            return splitPane;
        }

              public void removeComponent(java.awt.Component component)
        {
            splitPane.remove(component);
            splitPaneBottom.remove(component);
        }


        public static void main(String s[]) {
            JFrame frame = new JFrame("JSplitPane in Aktion");

            frame.addWindowListener(new WindowAdapter() {
                public void windowClosing(WindowEvent e) {System.exit(0);}
            });

            JSpliterPanel jsp = new JSpliterPanel();
            frame.getContentPane().add(jsp.getSplitPane());
            frame.pack();
            frame.setVisible(true);
    }




}