/** Beispiel JTrees.java fr das Buch OpenJava
 * Das ist eine Java Application, die JTree zeigt
 * <BR> Starten mit: Java JTrees
 * @author      OpenJava Buch
 * @version     1.0  Date: 06.03.1999
 * @since       JDK1.2
*/


import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;

// Diese Klasse nimmt ein Array und macht
// den ersten Element zu einem Node
// die andere Elemente werden dann Bltter
class Branch {
  DefaultMutableTreeNode r;
  public Branch(String[] data) {
    r = new DefaultMutableTreeNode(data[0]);
    for(int i = 1; i < data.length; i++)
      r.add(new DefaultMutableTreeNode(data[i]));
  }
  public DefaultMutableTreeNode node() {
    return r;
  }
}

public class JTrees extends JPanel {
  String[][] data = {
    { "Farbe", "Rot", "Gelb", "Grn" },
    { "Lnge", "Klein", "Mittel", "Gro" },
    { "Volume", "Viel", "Mittel", "wenig" },
    { "Temperatur", "Viel", "Mittel", "wenig"  },
    {  "Farbe2", "Lila", "Blau", "Schwarz" },
  };
  static int i = 0;
  DefaultMutableTreeNode root, child, chosen;
  JTree tree;
  DefaultTreeModel model;
  public JTrees() {
    setLayout(new BorderLayout());
    root = new DefaultMutableTreeNode("root");
    tree = new JTree(root);
    // Addiere ein ScrollBar:
    add(new JScrollPane(tree),
      BorderLayout.CENTER);
    // tree Modell
    model =(DefaultTreeModel)tree.getModel();
    JButton test = new JButton("Press me");
    test.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e){
        if(i < data.length) {
          child = new Branch(data[i++]).node();
          // Habe ich das letzte gecklickt?
          chosen = (DefaultMutableTreeNode)
            tree.getLastSelectedPathComponent();
          if(chosen == null) chosen = root;
          // tree update
          model.insertNodeInto(child, chosen, 0);

        }
      }
    });
    // Change the button's colors:
    test.setBackground(Color.blue);
    test.setForeground(Color.white);
    JPanel p = new JPanel();
    p.add(test);
    add(p, BorderLayout.SOUTH);
  }
  public static void main(String args[]) {
     JFrame frame = new JFrame("JTree in Aktion");
     JTrees jtr = new JTrees();
     frame.getContentPane().add(jtr);
     frame.pack();
     frame.setVisible(true);
  }
}