/** Beispiel Jtable.java fr das Buch OpenJava
 * Das ist eine Java Application, die Jtable zeigt
 * <BR> Starten mit: Java Jtable
 * @author      OpenJava Buch
 * @version     1.0  Date: 06.03.1999
 * @since       JDK1.2
*/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;

// The TableModel controls all the data:
class DataModel extends AbstractTableModel {
  Object[][] data = {
{"Julia","Java",new Integer(25),"Squatch",new Boolean(false)},
{"Abed", "Mustermann", new Integer(29),"Socer", new Boolean(true)},
{"stefi", "Walrath", new Integer(29), "Socer",new Boolean(true)},
{"Mark", "Andrews", new Integer(20), "Socer",new Boolean(true)},
};
String[] columnNames = {"Name","Vorname","Alter","Sport", "Mnnlich"};

 // Prints data when table changes:
  class TML implements TableModelListener {
    public void tableChanged(TableModelEvent e) {
      for(int i = 0; i < data.length; i++) {
        for(int j = 0; j < data[0].length; j++)
          System.out.print(data[i][j] + " ");
        System.out.println();
      }
    }
  }



  DataModel() {
    addTableModelListener(new TML());

      }
 public String getColumnName(int col) {
return columnNames[col].toString();
}
public int getRowCount() { return data.length; }
public int getColumnCount() { return columnNames.length; }
public Object getValueAt(int row, int col) {
return data[row][col];
}
public boolean isCellEditable(int row, int col) {
return true;
}
public void setValueAt(Object value, int row, int col) {
data[row][col] = value;
fireTableCellUpdated(row, col);
}

};

public class Jtable extends JPanel {
  public Jtable() {
    setLayout(new BorderLayout());
    JTable table = new JTable(new DataModel());
    add(new JScrollPane(table),
      BorderLayout.CENTER);

    TableColumn column = null;
    for (int i = 0; i < 5; i++) {
        column = table.getColumnModel().getColumn(i);
        if (i == 2) {
            column.setPreferredWidth(50); //Alter Spalte ist kleiner
        } else {
        column.setPreferredWidth(100);
        }
    }


        TableColumn sportColumn = table.getColumnModel().getColumn(3);

        JComboBox comboBox = new JComboBox();
        comboBox.addItem("Snowboarding");
        comboBox.addItem("Rowing");
        comboBox.addItem("Chasing toddlers");
        comboBox.addItem("Speed reading");
        comboBox.addItem("Teaching high school");
        comboBox.addItem("None");
        sportColumn.setCellEditor(new DefaultCellEditor(comboBox));





  }
  public static void main(String args[]) {
      JFrame frame = new JFrame("JTable in Aktion");
     Jtable jta = new Jtable();
     frame.getContentPane().add(jta);
     frame.pack();
     frame.setVisible(true);
  }
}