import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;


public class JSchiffFenster extends JFrame implements ActionListener{
  JSpielCanvas sc1;
  JSpielfeld s;
  JQuadrate q[];

  JPanel schiffePanel; // Der generelle Panel worauf ein Schiff
                       // mit seinem Bezeichnung stehen soll.
  JPanel topPanel;      // beinhaltet plazierPanel und schiffePanel
  JPanel bottomPanel;   // fr die unteren Labels
  JPanel plazierPanel;
  JLabel l1;
  JLabel l2;
  JLabel label3;
  JFrame thisFrame;
  Container parentApplet;

  public JSchiffFenster(JSpielfeld s, Container c) {

    this.parentApplet = c;
    this.s = s;
    thisFrame = this;

    s.initialisieren();
    q = new JQuadrate[5];

    // Teile das Frame in horizontale Richtung
    getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));
    setSize(300,250);

    topPanel = new JPanel(false);
    topPanel.setLayout(new BoxLayout(topPanel, BoxLayout.X_AXIS));
    topPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10,10,10,10), ""));

     //Spielfeld des Benutzers
    plazierPanel = new JPanel(false);
    plazierPanel.setLayout(new BoxLayout(plazierPanel, BoxLayout.Y_AXIS));
    plazierPanel.setBorder( new TitledBorder(new TitledBorder(LineBorder.createGrayLineBorder(),"Bitte Plaziere die"),
                                "Schiffe", TitledBorder.RIGHT, TitledBorder.BOTTOM));
    topPanel.add(plazierPanel);

    sc1 = new JSpielCanvasPos2(s, q);
    plazierPanel.add(sc1);


      //Infofelder
    schiffePanel = new JPanel(false);
    schiffePanel.setLayout(new BoxLayout(schiffePanel, BoxLayout.Y_AXIS));
    schiffePanel.setBorder( new TitledBorder(new TitledBorder(LineBorder.createGrayLineBorder(),"Vorhandene"),
                                "Schiffe", TitledBorder.RIGHT, TitledBorder.BOTTOM));
    topPanel.add(schiffePanel);

    zeigeQuadrat("2-er Schiff", 0);
    zeigeQuadrat("3-er Schiff 1",1);
    zeigeQuadrat("3-er Schiff 2", 2);
    zeigeQuadrat("4-er Schiff", 3);
    zeigeQuadrat("5-er Schiff", 4);

 // Anlegen der Buttons
    JButton fertig = new JButton("Fertig");
    fertig.setToolTipText("Clicke erst wenn Schiffe positioniert sind.");
    fertig.addActionListener(this);

    topPanel.add(fertig);

    /// Definition des LabelPanels
    bottomPanel = new JPanel(false);
    bottomPanel.setLayout(new GridLayout(2,0));

    JLabel l1 = new JLabel("Zum Setzen der Schiffe bitte Anfangs- und Endposition mit der Maus markieren", JLabel.LEFT);
    bottomPanel.add(l1);
    JLabel l2 = new JLabel("Zum Entfernen der Schiffe bitte Anfangs- und Endposition nochmals mit der Maus markieren", JLabel.LEFT);
    bottomPanel.add(l2);

    getContentPane().add(topPanel);
    getContentPane().add(bottomPanel);
    validate();

  }

  protected void zeigeQuadrat(String name, int schiffNummer) {

       // hilfPanle stellt einen Shiff mit dessen Label dar
       JPanel hilfPanel = new JPanel(false);
       hilfPanel.setLayout(null);

       q[schiffNummer] = new JQuadrate(s, schiffNummer);
       q[schiffNummer].setBounds(5,5,16,16);
       hilfPanel.add(q[schiffNummer]);
       label3 = new JLabel(name);
       label3.setBounds(30,5,100,20);
       hilfPanel.add(label3);

       schiffePanel.add(hilfPanel);
       validate();
  }

  public void actionPerformed(ActionEvent e) {

    //System.out.println("schiffZahl = "+ s.schiffZahl);
    if (s.schiffZahl == 0){
      setVisible(false);
      repaint();
      s.schiffZahl = 17;
      s.spielfeldFertigstellen();
      parentApplet.setSize(parentApplet.getSize().width+1, parentApplet.getSize().height+1);


    } else {
      //Fehlermeldung
     JOptionPane.showMessageDialog(thisFrame, "Erst alle Schiffe setzen!!");

    }
  }



}