import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;


public class GUISVUserBean extends Applet {

  SpielCanvasBean sc1;
  SpielCanvasBean sc2;
  SVClient netz;

  Spielfeld spieler, computer;
  Button shoot, setship;
  Panel buttonPanel; // Panel wo die Zwei Button (shoot und setship) stehen
  Panel sc1Panel; // im Centrum dieses Panel wird der Spielfeld des Computerts plaziert
  Panel sc2Panel; // im Centrum dieses Panel wird der Spielfeld des Spielers plaziert
  Label label1; // Bezeichnung des Spielfeldes des Computerts
  Label label2; // Bezeichnung des Spielfeldes des Spielers
  Container c;


  public void init () {

        c = this;
        computer = new Spielfeld();
        spieler = new Spielfeld();

        setLayout(new GridLayout(1,3,5,0));
		setSize(650,266);
		setBackground(new Color(16777215));

		// Setzen der Buttons
		buttonPanel = new java.awt.Panel();
		buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER,5,5));
		buttonPanel.setBounds(0,0,142,266);
		buttonPanel.setBackground(new Color(16777215));
		add(buttonPanel);
		setship = new java.awt.Button();
		setship.setLabel("neues Spiel");
	    setship.addActionListener(new ButtonListener(0));
		setship.setBounds(31,5,80,23);
		setship.setBackground(new Color(12632256));
		buttonPanel.add(setship);
		shoot = new Button("Schuss abgeben");
        shoot.setEnabled(false);
        shoot.addActionListener(new ButtonListener(1));
        shoot.setBounds(17,33,108,23);
		shoot.setBackground(new Color(12632256));
		buttonPanel.add(shoot);

        //Spielfeld des Computers
        sc1Panel = new java.awt.Panel();
		sc1Panel.setLayout(new BorderLayout(0,0));
		sc1Panel.setBounds(142,0,142,266);
		sc1Panel.setBackground(new Color(16777215));
		sc1 = new SpielCanvasBean();
		sc1.setPosition1(true);
		sc1.setS(computer);
		sc1Panel.add("Center",sc1);
		sc1.initialisiere();
		label1 = new java.awt.Label("Spielfeld des Computers", Label.LEFT);
		label1.setBounds(0,133,142,133);
		sc1Panel.add("South",label1);
        add(sc1Panel);

        //Spielfeld des Benutzers
        sc2Panel = new java.awt.Panel();
		sc2Panel.setLayout(new BorderLayout(0,0));
		sc2Panel.setBounds(284,0,142,266);
		sc2Panel.setBackground(new Color(16777215));
		add(sc2Panel);
		sc2 = new SpielCanvasBean();
		sc2.setS(spieler);
    	sc2Panel.add("Center",sc2);
    	sc2.initialisiere();
		label2 = new java.awt.Label("Spielfeld des Benutzers", Label.LEFT);
		label2.setBounds(0,133,142,133);
		sc2Panel.add("South",label2);
}

    public void ausgabeFenster (String s) {
   /*   Object anker = getParent();
      while (! (anker instanceof Frame))
        anker = ((Component) anker).getParent();
  */
      FehlerFensterBean dialog = new FehlerFensterBean();
      dialog.setTitle(s);
     // FehlerFenster dialog = new FehlerFenster((Frame)anker, s);
      dialog.setVisible(true);
      dialog.setSize(400,100);
      return;
   }

  class ButtonListener implements ActionListener {
    private int val;
    ButtonListener (int val) {
      this.val = val;
    }

   public void actionPerformed(ActionEvent e) {
      Daten daten;
      Point p = null;
      daten = new Daten();
      if (val == 0){ //Schiffe setzen
        spieler.initialisieren();
        computer.initialisieren();
        try {
          netz = new SVClient((GUISVUserBean) c);
        } catch (IOException ioe){
          ausgabeFenster("Probleme beim Netzaufbau");
          return;
        }

        if (netz.SVSocket == null)
          return;
        SchiffFensterBean fenster = new SchiffFensterBean(spieler, c);
        fenster.setTitle("Schiffe setzen");
        fenster.pack();
        fenster.setVisible(true);
        fenster.setSize(600,350);
        shoot.setEnabled(true);
        repaint();
      } else{
        //Schiessen
        getSchussKoordinaten();
        //Koordinaten bereits markiert?
        if (sc1.getSchussPositionX() == -1)
          return;
        daten.status=daten.SCHUSS;
        daten.p.x=sc1.getSchussPositionX();
        daten.p.y=sc1.getSchussPositionY();
        netz.sendData(daten);
        shoot.setEnabled(false);
        try {
          daten = netz.getData();
        }catch (IOException ioe) {}

        if (daten.status == daten.TREFFER) {
          //TREFFER
          System.out.println("Wir haben getroffen");
          //Einfaerben
          computer.spiel[sc1.getSchussPositionX()][sc1.getSchussPositionY()]=computer.VERSENKT;
          computer.schiffZahl--;
          if (computer.schiffZahl==0){
            //Gewinnmeldung
            ausgabeFenster("Herzlichen Glckwunsch, Sie haben gewonnen!");
            try {
              netz.beenden();
            } catch (IOException ioe) {}
            //Neues Spiel anbieten
            shoot.setEnabled(false);
            return;
          }
          sc1.setSchussPositionX(-1);
          sc1.setSchussPositionY(-1);
        //          sc1.sa1.tmp.x = sc1.sa1.tmp.y = -1;
          sc1.getSa1().repaint();

          repaint();
          shoot.setEnabled(true);
        } else {
          System.out.println("Wasser");
          computer.spiel[sc1.getSchussPositionX()][sc1.getSchussPositionY()]=computer.WASSER;
          sc1.setSchussPositionX(-1);
          sc1.setSchussPositionY(-1);
//          sc1.sa1.tmp.x = sc1.sa1.tmp.y = -1;
          sc1.getSa1().repaint();

          rechnerTrifft(daten);
          if (spieler.schiffZahl!=0)
            shoot.setEnabled(true);
          sc2.repaint();
          repaint();
        }
      }
        validate();
    }


    public void rechnerTrifft(Daten d) {

      while (true) {
        if (spieler.spiel[d.p.x][d.p.y]!=spieler.SCHIFF)
          if (spieler.spiel[d.p.x][d.p.y]!=spieler.VERSENKT)
          {
          spieler.spiel[d.p.x][d.p.y]=spieler.WASSER;
          //Rechner schiesst ins Wasser
          return;
        }
        //Rechner hat uns wirklich getroffen
        d.status = d.TREFFER;
        netz.sendData(d);
        spieler.spiel[d.p.x][d.p.y]=spieler.VERSENKT;

        spieler.schiffZahl--;
        if (spieler.schiffZahl==0){
          //Meldung dass Spieler verloren hat
            ausgabeFenster("Leider verloren!");
            try {
              netz.beenden();
            } catch (IOException ioe) {}
            //Neues Spiel anbieten
            shoot.setEnabled(false);
            return;
          }

        try {
            d = netz.getData();
        }catch (IOException ioe) {}
        shoot.setEnabled(false);

        sc2.repaint();
        repaint();
      }
    }


    public void getSchussKoordinaten() {
      System.out.println("Schuss auf "+sc1.getSchussPositionX()+" "+sc1.getSchussPositionY());
      return;
    }
  }
}