import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.beans.*;

public class SchiffFensterBean extends Frame implements ActionListener{
  SpielCanvasBean sc1;
  Spielfeld s;
  QuadrateBean q[];

  java.awt.Panel southPanel; // fr die zwei Info Zeilen
  java.awt.Panel centerPanel; // Spielfeld und panel 2
  java.awt.Label label1; //1. Informationszeile
  java.awt.Label label2; //2. Informationszeile
  java.awt.Label label3; // Label der einzusetzenden Schiffe
  java.awt.Panel panel1; // Der generelle Panel worauf ein Schiff
                         // mit seinem Bezeichnung stehen soll.
  java.awt.Panel panel2; // Panel worauf die Schiffe mit Bezeichnungen und
                         // der fertig-Button stehen

  Container c;

  public SchiffFensterBean(Spielfeld s, Container c) {
    this.s = s;
    this.c = c;
    s.initialisieren();
    q = new QuadrateBean[5];

    setLayout(new BorderLayout(0,0));
	setSize(300,250);
	centerPanel = new java.awt.Panel();
	centerPanel.setLayout(new GridLayout(1,2,0,0));
	centerPanel.setBounds(0,0,300,220);
	add("Center", centerPanel);

    //Spielfeld des Benutzers
    sc1 = new SpielCanvasBean();
    sc1.setPosition2(true);
    sc1.setS(s);
    sc1.setQ(q);
    sc1.initialisiere();

    centerPanel.add(sc1);

    //Infofelder
    panel2 = new java.awt.Panel();
	panel2.setLayout(new GridLayout(5,1,3,3));
    centerPanel.add(panel2);

    zeigeQuadrat("2-er Schiff", false, 0);
    zeigeQuadrat("3-er Schiff 1", true,1);
    zeigeQuadrat("3-er Schiff 2", true, 2);
    zeigeQuadrat("4-er Schiff",  true, 3);
    zeigeQuadrat("5-er Schiff",  true, 4);

    southPanel = new java.awt.Panel();
	southPanel.setLayout(new GridLayout(2,1,0,0));
	southPanel.setBounds(0,220,426,0);
	add("South", southPanel);
	label1 = new Label("Zum Setzen der Schiffe bitte Anfangs- und Endposition mit der Maus markieren", Label.LEFT);
    label1.setBounds(0,0,426,23);
	southPanel.add(label1);
	label2 = new Label("Zum Entfernen der Schiffe bitte Anfangs- und Endposition nochmals mit der Maus markieren", Label.LEFT);
	label2.setBounds(0,23,426,23);
	southPanel.add(label2);

  }

  protected void zeigeQuadrat(String name, boolean val, int schiffNummer) {

    panel1 = new java.awt.Panel();
	panel1.setLayout(null);
	//panel1.setBounds(0,0,213,41);
	q[schiffNummer] = new QuadrateBean();
/*	try{
	q[schiffNummer] = (QuadrateBean)Beans.instantiate(null, "QuadrateBean");
	} catch (Exception e) {
	  System.out.println("Fehler beim Instatierung der Quadrate.");
	}
*/
	q[schiffNummer].setS(s);
	q[schiffNummer].setNummer(schiffNummer);
    q[schiffNummer].setBounds(5,5,20,20);
    panel1.add(q[schiffNummer]);
	label3 = new java.awt.Label(name);
	label3.setBounds(30,5,100,20);
	panel1.add(label3);

	// Anlegen der Buttons
    if (val==false){
        Button fertig = new Button("Fertig");
	    fertig.setBounds(130,5,60,30);
	    panel1.add(fertig);
	    fertig.addActionListener(this);
	}
	panel2.add(panel1);

  }

  public void actionPerformed(ActionEvent e) {
     System.out.println("Anzahl der Schiffe " + s);
     if (s.schiffZahl == 0){

      repaint();
      setVisible(false);
      s.schiffZahl = 17;
      s.spielfeldFertigstellen();
      c.setSize(c.getSize().width+1, c.getSize().height+1);

    }
    else {
     /*   Object anker = sc1.getParent();
          while (! (anker instanceof Frame))
            anker = ((Component) anker).getParent();
       */ FehlerFensterBean dialog = new FehlerFensterBean();
          dialog.setTitle("Erst alle Schiffe setzen!!");
          dialog.setVisible(true);
          dialog.setSize(150,100);
    }

  }
}