import java.awt.*;
import java.awt.event.*;

public class SpielCanvasBean extends Panel {
  private Spielfeld s;
  private QuadrateBean[] q;
  private boolean position1;
  private boolean position2;

  private SelectionAreaPos1 sa1; //= new SelectionAreaBean();
  private SelectionAreaPos2 sa2;

      public  SpielCanvasBean () {
          // super();
         sa1 = new SelectionAreaPos1();
         sa2 = new SelectionAreaPos2();
      }

      public Insets getInsets() {
          return new Insets(0,0,0,0);
      }

      public void  setS(Spielfeld s){
           this.s = s;
      }
      public Spielfeld getS(){
           return s;
      }

      public void setQ(QuadrateBean[] q){
          this.q = q;
      }
      public QuadrateBean[] getQ(){
          return q;
      }

      public void setPosition1(boolean b){
        position1 = b;
      }
      public boolean isPosition1(){
        return position1;
      }

      public void setPosition2(boolean b){
        position2 = b;
      }
      public boolean isPosition2(){
        return position2;
      }

      public SelectionAreaPos1 getSa1(){
        return sa1;
      }
      public void  setSa1(SelectionAreaPos1 sa1){
        this.sa1 = sa1;
      }

      public SelectionAreaPos2 getSa2(){
        return sa2;
      }
       public void setSa2(SelectionAreaPos2 sa2){
        this.sa2 = sa2;
      }

      // Die Schuss-Koordinaten
      public int getSchussPositionX(){
        return getSa1().tmp.x;
      }
      public void setSchussPositionX(int i){
         getSa1().tmp.x = i;
      }

      public int getSchussPositionY(){
        return getSa1().tmp.y;
      }
      public void setSchussPositionY(int i){
         getSa1().tmp.y = i;
      }



     // Methode um alles zu initialisieren
      public void initialisiere(){

            if (isPosition1()) {
                setLayout(new GridLayout(1,0));
                sa1 = new SelectionAreaPos1(getS());
                add(sa1);
                validate();

           }else if (isPosition2()) {
                //Set layout to one that makes its contents as big as possible.
                setLayout(new GridLayout(1,0));
                sa2 = new SelectionAreaPos2(getS(), getQ());
                add(sa2);
                validate();
           }

      }



      public void paint(Graphics screen) {
        int i,j;

        // Erzeuge Quadrat als Spielfeldbegrenzung

        screen.setColor(Color.white);
        screen.fillRect(0,0,200,200);
        screen.setColor(Color.black);
        screen.drawRect(0,0,200,200);
        // Erzeuge horizontale und vertikale Linien
        for (i = 1; i < 10; i++){
          screen.drawLine(0, 0+i*20,200, 0+i*20);
          screen.drawLine(0+i*20, 0,0+i*20, 200);
        }
        // Markiere Schiffe und Wasser
           for (i = 0; i < 10; i++){
              for (j = 0; j < 10; j++){
               if (s.spiel[i][j]!= s.FREI){
                switch (s.spiel[i][j]) {
                 case s.WASSER:
                      // Erzeuge blaues Quadrat
                      screen.setColor(Color.blue);
                      //i*20+1 bzw. 20-1=19 damit die Randung bleibt
                      screen.fillRect(i*20+1,j*20+1,19,19);
                    break;
                    case s.SCHIFF:
                      // Erzeuge gruenes Quadrat
                      screen.setColor(Color.green);
                       //i*20+1 bzw. 20-1=19 damit die Randung bleibt
                      screen.fillRect(i*20+1,j*20+1,19,19);
                    break;
                    case s.VERSENKT:
                      // Erzeuge rotes Quadrat
                      screen.setColor(Color.red);
                       //i*20+1 bzw. 20-1=19 damit die Randung bleibt
                      screen.fillRect(i*20+1,j*20+1,19,19);
                    break;
                    default:
                    break;
                  }
                }
              }
           }
      }
}