(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1255770,      44073]*)
(*NotebookOutlinePosition[   1373436,      46660]*)
(*  CellTagsIndexPosition[   1371581,      46605]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["TSi ProPac: Controls", "Title",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  TextAlignment->Left,
  AspectRatioFixed->True],

Cell["Harry G. Kwatny", "Subtitle"],

Cell["\<\
Department of Mechanical Engineering & Mechanics
Drexel University\
\>", "Subsubtitle"],

Cell[TextData[StyleBox["Gilmer L. Blankenship", "Subtitle",
  FontSlant->"Plain"]], "Subsubtitle"],

Cell["\<\
Department of Electrical & Computer Engineering
University of Maryland\
\>", "Subsubtitle"],

Cell[CellGroupData[{

Cell["Getting Started", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Getting Started"],

Cell[BoxData[
    \(Off[General::spell]; \nOff[General::spell1]; \)], "Input",
  CellLabel->"In[1]:="],

Cell[TextData[{
  "This notebook illustrates the tools provided in Controls including a few \
new functions contained in Version 3.0. Controls is contained in the \
directory ProPac. ProPac can be placed anywhwere you like, but a search path \
must be defined for it. It is most convenient to place ProPac in the \
AddOns\\Applications directiory, i.e, C:\\Program Files\\Wolfram Research\\",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\\3.0\\AddOns\\Applications. Once ProPac is loaded all of the functions in \
Dynamics as well as other packages included in TSi ProPac will be available \
for use and loaded as when needed."
}], "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Getting Started"],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3 ProPac can be loaded with the command"
}], "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Getting Started"],

Cell[CellGroupData[{

Cell["<<ProPac`", "Input",
  CellLabel->"In[2]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Getting Started"],

Cell[BoxData[
    \("\n    This is ProPac - Version 2.0\n \n ProPac has been successfully \
loaded. It contains packages\n for multibody dynamics, linear control and \
nonlinear control.\n Appropriate packages will be loaded automatically as \
required.\n Packages can be manually loaded by simply entering \
GeometricTools,\n Dynamics, LinearControl, NonlinearControl or MEXTools as \
desired.\n Once a package is loaded, enter ?GeomtricTools, ?Dynamics,\n \
?LinearControl, ?NonlinearControl, or ?MEXTools, respectively,\n to obtain a \
list of available functions. Help is also available\n in the Help Browser \
under Add-ons."\)], "Print",
  GeneratedCell->False,
  CellAutoOverwrite->False]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 2.2 use the command ProPac`Master`."
}], "Text",
  CellTags->"Getting Started"]
}, Closed]],

Cell[CellGroupData[{

Cell["Basics of The Linear Package", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["What's in the Package", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"What's in the Package"],

Cell["\<\

We will demonstrate some of the functions in the linear control systems \
package ControL. First, load ProPac\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"What's in the Package"],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< ProPac`\)], "Input",
  CellLabel->"In[3]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"What's in the Package"],

Cell[BoxData[
    \("\n    This is a development version of ProPac - Version 1.xx\n \n \
ProPac has been successfully loaded. It contains packages\n for multibody \
dynamics, linear control and nonlinear control.\n Appropriate packages will \
be loaded automatically as required.\n Packages can be manually loaded by \
simply entering GeometricTools,\n Dynamics, LinearControl, NonlinearControl \
or MEXTools as desired.\n Once a package is loaded, enter ?GeomtricTools, \
?Dynamics,\n ?LinearControl, ?NonlinearControl, or ?MEXTools, respectively,\n \
to obtain a list of available functions. Help is also available\n in the Help \
Browser under Add-ons."\)], "Print",
  CellTags->"What's in the Package"]
}, Open  ]],

Cell["\<\
To obtain a list of functions available in the linear package ControlL:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"What's in the Package"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearControl\)], "Input",
  CellLabel->"In[4]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"What's in the Package"],

Cell[BoxData[
    \("  *** LinearControl successfully loaded ***"\)], "Print",
  CellTags->"What's in the Package"],

Cell[BoxData[
    \(LinearControl\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"What's in the Package"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?LinearControl\)\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"What's in the Package"],

Cell[BoxData[
    \("Functions in the package for linear control are:\n \n MatrixRank, \
Jacobian, TaylorLinearize,\n  RandomMatrix, RangeSpace, MatrixTrace,n \
BlockCompanionMatrix,\n \n StateSpaceToTransferFunction,\n \
LeastCommonDenominator, Poles, Zeros,\n AssociatedHankelMatrix,LaurentSeries,\
\n McMillanDegree,ControllableRealization,\n ObservableRealization, \
MinimalRealization,\n \n ControllabilityMatrix, ObservabilityMatrix,\n \
ControllablePair, ObservablePair,\n KalmanDecomposition,RelativeDegree,\n \n \
AlgebraicRiccatiEquation,LQR,LQE,\n DecouplingControl,PolePlace,\n \
LyapunovEquation,\n \n RootLocus,Nyquist,ColorNyquist,Bode,\n \
PoleZeroPlot"\)], "Print",
  CellTags->"What's in the Package"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Linearization", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"Linearization", "i:1"}],

Cell["Define a nonlinear system:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"Linearization", "i:1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(f = {x1\^2\ Sin[x1] - x2 + u1\ u2, \(-x2\) + x2\^3 + u1 + 
          3\ u2}\)], "Input",
  CellLabel->"In[6]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Linearization", "i:1"}],

Cell[BoxData[
    \({u1\ u2 - x2 + x1\^2\ Sin[x1], u1 + 3\ u2 - x2 + x2\^3}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->{"Linearization", "i:1"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(g = {x1 + x2, x2 + u2\^2}\)], "Input",
  CellLabel->"In[7]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Linearization", "i:1"}],

Cell[BoxData[
    \({x1 + x2, u2\^2 + x2}\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->{"Linearization", "i:1"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(x = {x1, x2}\)], "Input",
  CellLabel->"In[8]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Linearization", "i:1"}],

Cell[BoxData[
    \({x1, x2}\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->{"Linearization", "i:1"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(u = {u1, u2}\)], "Input",
  CellLabel->"In[9]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Linearization", "i:1"}],

Cell[BoxData[
    \({u1, u2}\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->{"Linearization", "i:1"}]
}, Open  ]],

Cell["\<\
Now, linearize it about the equilibrium point x=(0,0), u=(0,0)\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"Linearization", "i:1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \({A1, B1, C1, D1} = 
      TaylorLinearize[f, g, x, {0, 0}, u, {0, 0}]\)], "Input",
  CellLabel->"In[10]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Linearization", "i:1"}],

Cell[BoxData[
    \({{{0, \(-1\)}, {0, \(-1\)}}, {{0, 0}, {1, 3}}, {{1, 1}, {0, 1}}, {{0, 
          0}, {0, 0}}}\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->{"Linearization", "i:1"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Poles & Zeros", "Subsection",
  CellTags->{"Poles and Zeros", "i:2"}],

Cell[TextData[{
  "The functions ",
  StyleBox["Poles",
    FontFamily->"Courier New"],
  " and ",
  StyleBox["Zeros",
    FontFamily->"Courier New"],
  " compute, respectively, the system poles and (transmission) zeros from its \
transfer matrix.  ",
  StyleBox["Poles",
    FontFamily->"Courier New"],
  " computes the roos of the least common denominator of minors of all orders \
and ",
  StyleBox["Zeros",
    FontFamily->"Courier New"],
  " computes the roots of the greatest common multiple of minors of order \
k=Rank[G[s]]. Hence these are the poles and zeros of a minimal realization of \
G[s]."
}], "Text",
  CellTags->{"Poles and Zeros", "i:2"}],

Cell[BoxData[{
    \(G[s_] := {{\((s - 1)\)*\((s + 2)\), 
            0, \((s - 1)\)^2}, {\(-\((s + 1)\)\)*\((s + 2)\), \((s - 
                  1)\)*\((s + 1)\), \((s - 1)\)*\((s + 1)\)}}/\((\((s + 
                1)\)*\((s + 2)\)*\((s - 1)\))\)\), "\n", 
    \(H[s_] := {{s - 1, s}, {\(-6\), 
            s - 2}}/\((1.25*\((s + 1)\)*\((s + 2)\))\)\)}], "Input",
  CellLabel->"In[11]:=",
  CellTags->{"Poles and Zeros", "i:2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(G[s] // MatrixForm\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->{"Poles and Zeros", "i:2"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(1\/\(1 + s\)\), 
              "0", \(\(\(-1\) + s\)\/\(\((1 + s)\)\ \((2 + s)\)\)\)},
            {\(\(\(-1\) - 
                    s\)\/\(\((\(-1\) + s)\)\ \((1 + s)\)\)\), \(1\/\(2 + 
                    s\)\), \(1\/\(2 + s\)\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[13]//MatrixForm=",
  CellTags->{"Poles and Zeros", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(H[s] // MatrixForm\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->{"Poles and Zeros", "i:2"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(\(0.8`\ \((\(-1\) + s)\)\)\/\(\((1 + s)\)\ \((2 + 
                        s)\)\)\), \(\(0.8`\ s\)\/\(\((1 + s)\)\ \((2 + 
                        s)\)\)\)},
            {\(-\(4.80000000000000071`\/\(\((1 + s)\)\ \((2 + 
                          s)\)\)\)\), \(\(0.8`\ \((\(-2\) + s)\)\)\/\(\((1 + 
                        s)\)\ \((2 + s)\)\)\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[14]//MatrixForm=",
  CellTags->{"Poles and Zeros", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Poles[G, s]\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->{"Poles and Zeros", "i:2"}],

Cell[BoxData[
    \({{\(-2\), 2}, {\(-1\), 1}, {1, 1}}\)], "Output",
  CellLabel->"Out[15]=",
  CellTags->{"Poles and Zeros", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Poles[H, s]\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->{"Poles and Zeros", "i:2"}],

Cell[BoxData[
    \({{\(-2\), 1}, {\(-1\), 1}}\)], "Output",
  CellLabel->"Out[16]=",
  CellTags->{"Poles and Zeros", "i:2"}]
}, Open  ]],

Cell[BoxData[{
    \(G[s_] := {{\((s - 1)\)*\((s + 2)\), 
            0, \((s - 1)\)^2}, {\(-\((s + 1)\)\)*\((s + 2)\), \((s - 
                  1)\)*\((s + 1)\), \((s - 1)\)*\((s + 1)\)}}/\((\((s + 
                1)\)*\((s + 2)\)*\((s - 1)\))\)\), "\n", 
    \(H[s_] := {{s - 1, s}, {\(-6\), 
            s - 2}}/\((1.25*\((s + 1)\)*\((s + 2)\))\)\), "\n", 
    \(K[s_] := {{s - 1, 4}, {4.5, 2*\((s - 1)\)}}/\((s + 2)\)\)}], "Input",
  CellLabel->"In[17]:=",
  CellTags->{"Poles and Zeros", "i:2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(G[s] // MatrixForm\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->{"Poles and Zeros", "i:2"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(1\/\(1 + s\)\), 
              "0", \(\(\(-1\) + s\)\/\(\((1 + s)\)\ \((2 + s)\)\)\)},
            {\(\(\(-1\) - 
                    s\)\/\(\((\(-1\) + s)\)\ \((1 + s)\)\)\), \(1\/\(2 + 
                    s\)\), \(1\/\(2 + s\)\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[20]//MatrixForm=",
  CellTags->{"Poles and Zeros", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(H[s] // MatrixForm\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->{"Poles and Zeros", "i:2"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(\(0.8`\ \((\(-1\) + s)\)\)\/\(\((1 + s)\)\ \((2 + 
                        s)\)\)\), \(\(0.8`\ s\)\/\(\((1 + s)\)\ \((2 + 
                        s)\)\)\)},
            {\(-\(4.80000000000000071`\/\(\((1 + s)\)\ \((2 + 
                          s)\)\)\)\), \(\(0.8`\ \((\(-2\) + s)\)\)\/\(\((1 + 
                        s)\)\ \((2 + s)\)\)\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[21]//MatrixForm=",
  CellTags->{"Poles and Zeros", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(K[s] // MatrixForm\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->{"Poles and Zeros", "i:2"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(\(\(-1\) + s\)\/\(2 + s\)\), \(4\/\(2 + s\)\)},
            {
              FractionBox[
                StyleBox["4.5`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->2], \(2 + 
                  s\)], \(\(2\ \((\(-1\) + s)\)\)\/\(2 + s\)\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[22]//MatrixForm=",
  CellTags->{"Poles and Zeros", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Zeros[G, s]\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->{"Poles and Zeros", "i:2"}],

Cell[BoxData[
    \({{1, 1}}\)], "Output",
  CellLabel->"Out[23]=",
  CellTags->{"Poles and Zeros", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Zeros[H, s]\)], "Input",
  CellLabel->"In[24]:=",
  CellTags->{"Poles and Zeros", "i:2"}],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[24]=",
  CellTags->{"Poles and Zeros", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Zeros[K, s]\)], "Input",
  CellLabel->"In[25]:=",
  CellTags->{"Poles and Zeros", "i:2"}],

Cell[BoxData[
    \({{4, 1}}\)], "Output",
  CellLabel->"Out[25]=",
  CellTags->{"Poles and Zeros", "i:2"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["State Space to Transfer Function and Back", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"State Space to Transfer Function and Back", "i:3"}],

Cell["Convert the state space description to a transfer function:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"State Space to Transfer Function and Back", "i:3"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(G1[s_] := StateSpaceToTransferFunction[A1, B1, C1, D1, s]\), "\n", 
    \(G1[s]\)}], "Input",
  CellLabel->"In[26]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"State Space to Transfer Function and Back", "i:3"}],

Cell[BoxData[
    \({{\(\(-1\) + s\)\/\(s + s\^2\), \(3\ \((\(-1\) + s)\)\)\/\(s + s\^2\)}, \
{1\/\(1 + s\), 3\/\(1 + s\)}}\)], "Output",
  CellLabel->"Out[27]=",
  CellTags->{"State Space to Transfer Function and Back", "i:3"}]
}, Open  ]],

Cell["\<\
Now, convert back to state space by finding a controllable realization:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"State Space to Transfer Function and Back", "i:3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \({A2, B2, C2} = ControllableRealization[G1, s]\)], "Input",
  CellLabel->"In[28]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"State Space to Transfer Function and Back", "i:3"}],

Cell[BoxData[
    \({{{0, 0, 1, 0}, {0, 0, 0, 1}, {0, 0, \(-1\), 0}, {0, 0, 
          0, \(-1\)}}, {{0, 0}, {0, 0}, {1, 0}, {0, 1}}, {{\(-1\), \(-3\), 1, 
          3}, {0, 0, 1, 3}}}\)], "Output",
  CellLabel->"Out[28]=",
  CellTags->{"State Space to Transfer Function and Back", "i:3"}]
}, Open  ]],

Cell["Is the controllable realization observable?", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"State Space to Transfer Function and Back", "i:3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ObservablePair[A2, C2]\)], "Input",
  CellLabel->"In[29]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"State Space to Transfer Function and Back", "i:3"}],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[29]=",
  CellTags->{"State Space to Transfer Function and Back", "i:3"}]
}, Open  ]],

Cell["Let's construct a transfer function for this realization", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"State Space to Transfer Function and Back", "i:3"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(G2[s_] := StateSpaceToTransferFunction[A2, B2, C2, s]\), "\n", 
    \(G2[s]\)}], "Input",
  CellLabel->"In[30]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"State Space to Transfer Function and Back", "i:3"}],

Cell[BoxData[
    \({{\(\(-1\) + s\)\/\(s + s\^2\), \(3\ \((\(-1\) + s)\)\)\/\(s + s\^2\)}, \
{1\/\(1 + s\), 3\/\(1 + s\)}}\)], "Output",
  CellLabel->"Out[31]=",
  CellTags->{"State Space to Transfer Function and Back", "i:3"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Minimal Realization", "Subsection",
  CellTags->{"Minimal Realization", "i:4"}],

Cell["\<\
The function MinimalRealization can be used to construct a minimal (or \
irreducible) realization. It always retuns the system parameters in Jordan \
form. \
\>", "Text",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    \(\(H[s_] := 
        Together[
          Outer[Times, {1, 1, 1}, {1, 0, 0}]/\((s + p)\)^3 + 
            Outer[Times, {0, 1, 0}, {0, 1, 0}]/\((s + p)\)^3 + 
            Outer[Times, {1, 0, 1}, {1, 0, 0}]/\((s + p)\)^2 + 
            Outer[Times, {2, 5, 2}, {0, 0, 1}]/\((s + p)\)^2 + 
            Outer[Times, {2, 2, 3}, {\(-1\), \(-1\), 0}]/\((s + 
                  p)\)];\)\)], "Input",
  CellLabel->"In[32]:=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(H[s] // MatrixForm\), "\n", 
    \(\({AA, BB, CC, DD} = MinimalRealization[H, s];\)\), "\n", 
    \(AA // MatrixForm\), "\n", 
    \(BB // MatrixForm\), "\n", 
    \(CC // MatrixForm\), "\n", 
    \(DD // MatrixForm\)}], "Input",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(\(1 + p - 2\ p\^2 + s - 4\ p\ s - 
                    2\ s\^2\)\/\((p + s)\)\^3\), \(-\(2\/\(p + 
                      s\)\)\), \(2\/\((p + s)\)\^2\)},
            {\(\(1 - 2\ p\^2 - 4\ p\ s - 2\ s\^2\)\/\((p + s)\)\^3\), \(\(1 - 
                    2\ p\^2 - 4\ p\ s - 
                    2\ s\^2\)\/\((p + s)\)\^3\), \(5\/\((p + s)\)\^2\)},
            {\(\(1 + p - 3\ p\^2 + s - 6\ p\ s - 
                    3\ s\^2\)\/\((p + s)\)\^3\), \(-\(3\/\(p + 
                      s\)\)\), \(2\/\((p + s)\)\^2\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[32]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    \("Eliminating nonobservable states."\)], "Print",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(-p\), "1", "0", "0", "0", "0"},
            {"0", \(-p\), "1", "0", "0", "0"},
            {"0", "0", \(-p\), "0", "0", "0"},
            {"0", "0", "0", \(-p\), "1", "0"},
            {"0", "0", "0", "0", \(-p\), "1"},
            {"0", "0", "0", "0", "0", \(-p\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[33]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0", \(-2\)},
            {"0", "0", "2"},
            {"1", "0", "0"},
            {"0", "0", "2"},
            {"0", "0", "3"},
            {"0", "1", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[34]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", "1", \(-2\), "0", "0", \(-2\)},
            {"1", "0", \(-2\), "1", "0", \(-2\)},
            {"1", "1", \(-3\), "0", "0", \(-3\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[35]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0", "0"},
            {"0", "0", "0"},
            {"0", "0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[36]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}]
}, Open  ]],

Cell[BoxData[
    \(\(H[s_] := 
        N[Together[
            Outer[Times, {1, 1, 1}, {1, 0, 0}]/\((s + p)\)^3 + 
              Outer[Times, {0, 1, 0}, {0, 1, 0}]/\((s + p)\)^3 + 
              Outer[Times, {1, 0, 1}, {1, 0, 0}]/\((s + p)\)^2 + 
              Outer[Times, {2, 5, 2}, {0, 0, 1}]/\((s + p)\)^2 + 
              Outer[Times, {2, 2, 3}, {\(-1\), \(-1\), 0}]/\((s + 
                    p)\)]];\)\)], "Input",
  CellLabel->"In[37]:=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(H[s] // MatrixForm\), "\n", 
    \(\({AA, BB, CC, DD} = MinimalRealization[H, s];\)\), "\n", 
    \(AA // MatrixForm\), "\n", 
    \(BB // MatrixForm\), "\n", 
    \(CC // MatrixForm\), "\n", 
    \(DD // MatrixForm\)}], "Input",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(\(\(\(1.`\)\(\[InvisibleSpace]\)\) + p - 2.`\ p\^2 + s - 
                    4.`\ p\ s - 
                    2.`\ s\^2\)\/\((p + s)\)\^3\), \(-\(2.`\/\(p + 
                      s\)\)\), \(2.`\/\((p + s)\)\^2\)},
            {\(\(\(\(1.`\)\(\[InvisibleSpace]\)\) - 2.`\ p\^2 - 4.`\ p\ s - 
                    2.`\ s\^2\)\/\((p + s)\)\^3\), \(\(\(\(1.`\)\(\
\[InvisibleSpace]\)\) - 2.`\ p\^2 - 4.`\ p\ s - 
                    2.`\ s\^2\)\/\((p + s)\)\^3\), \(5.`\/\((p + s)\)\^2\)},
            {\(\(\(\(1.`\)\(\[InvisibleSpace]\)\) + p - 3.`\ p\^2 + s - 
                    6.`\ p\ s - 
                    3.`\ s\^2\)\/\((p + s)\)\^3\), \(-\(3.`\/\(p + 
                      s\)\)\), \(2.`\/\((p + s)\)\^2\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[37]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    \("Eliminating nonobservable states."\)], "Print",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(-p\), "1", "0", "0", "0", "0"},
            {"0", \(-p\), "1", "0", "0", "0"},
            {"0", "0", \(-p\), "0", "0", "0"},
            {"0", "0", "0", \(-p\), "1", "0"},
            {"0", "0", "0", "0", \(-p\), "1"},
            {"0", "0", "0", "0", "0", \(-p\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[38]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0", \(-2\)},
            {"0", "0", "2"},
            {"1", "0", "0"},
            {"0", "0", "2"},
            {"0", "0", "3"},
            {"0", "1", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[39]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", "1", \(-2\), "0", "0", \(-2\)},
            {"1", "0", \(-2\), "1", "0", \(-2\)},
            {"1", "1", \(-3\), "0", "0", \(-3\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[40]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0", "0"},
            {"0", "0", "0"},
            {"0", "0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[41]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}]
}, Open  ]],

Cell[BoxData[
    \(G[s_] := {{1/\((\((s + 2)\)^3\ \((s + 5)\))\), 
          1/\((s + 5)\)}, {1/\((s + 2)\), 0}}\)], "Input",
  CellLabel->"In[42]:=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(G[s] // MatrixForm\)], "Input",
  CellLabel->"In[43]:=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(1\/\(\((2 + s)\)\^3\ \((5 + s)\)\)\), \(1\/\(5 + s\)\)},
            {\(1\/\(2 + s\)\), "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[43]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({AA, BB, CC, DD} = MinimalRealization[G, s];\)\), "\n", 
    \(AA // MatrixForm\), "\n", 
    \(BB // MatrixForm\), "\n", 
    \(CC // MatrixForm\), "\n", 
    \(DD // MatrixForm\)}], "Input",
  CellLabel->"In[44]:=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(-2\), "1", "0", "0"},
            {"0", \(-2\), "1", "0"},
            {"0", "0", \(-2\), "0"},
            {"0", "0", "0", \(-5\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[44]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0"},
            {"0", "0"},
            {"1", "0"},
            {"1", \(-27\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[45]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(1\/3\), \(-\(1\/9\)\), \(1\/27\), \(-\(730\/27\)\)},
            {"0", "0", "1", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[46]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0"},
            {"0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[47]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}]
}, Open  ]],

Cell[BoxData[
    \(G[s_] := 
      Together[{{1 + 1/\((\((s + 2)\)^3*\((s + 5)\))\), 
            1/\((s + 5)\)}, {1/\((s + 2)\), 1}}]\)], "Input",
  CellLabel->"In[48]:=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(G[s] // MatrixForm\)], "Input",
  CellLabel->"In[49]:=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(\(41 + 68\ s + 42\ s\^2 + 11\ s\^3 + 
                    s\^4\)\/\(\((2 + s)\)\^3\ \((5 + s)\)\)\), \(1\/\(5 + 
                    s\)\)},
            {\(1\/\(2 + s\)\), "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[49]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({AA, BB, CC, DD} = MinimalRealization[G, s];\)\), "\n", 
    \(AA // MatrixForm\), "\n", 
    \(BB // MatrixForm\), "\n", 
    \(CC // MatrixForm\), "\n", 
    \(DD // MatrixForm\)}], "Input",
  CellLabel->"In[50]:=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(-2\), "1", "0", "0"},
            {"0", \(-2\), "1", "0"},
            {"0", "0", \(-2\), "0"},
            {"0", "0", "0", \(-5\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[50]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0"},
            {"0", "0"},
            {"1", "0"},
            {"1", \(-27\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[51]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(1\/3\), \(-\(1\/9\)\), \(1\/27\), \(-\(730\/27\)\)},
            {"0", "0", "1", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[52]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", "0"},
            {"0", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[53]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}]
}, Open  ]],

Cell["\<\
MinimalRealization can also be used with systems defined in state space form.\
\
\>", "Text",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    \(\({Anew, Bnew, Cnew, Dnew} = 
        MinimalRealization[AA, BB, CC, DD];\)\)], "Input",
  CellLabel->"In[54]:=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Anew // MatrixForm\), "\n", 
    \(Bnew // MatrixForm\), "\n", 
    \(Cnew // MatrixForm\), "\n", 
    \(Dnew // MatrixForm\)}], "Input",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    \("System is controllable."\)], "Print",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    \("Decompose into controllable/uncontrollable parts."\)], "Print",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    \("Divide controllable part into observable/unobservable parts."\)], \
"Print",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    \("System is observable."\)], "Print",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(-5\), "0", "0", "0"},
            {"0", \(-2\), "1", "0"},
            {"0", "0", \(-2\), "1"},
            {"0", "0", "0", \(-2\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[54]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", \(-27\)},
            {"0", "0"},
            {"0", "0"},
            {"1", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[55]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(-\(730\/27\)\), \(1\/3\), \(-\(1\/9\)\), \(1\/27\)},
            {"0", "0", "0", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[56]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", "0"},
            {"0", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[57]//MatrixForm=",
  CellTags->{"Minimal Realization", "i:4"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Controllability, Observability and Pole Placement", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"Controllability", "i:5"}],

Cell["\<\
Check the controllability and observability of the original linearized model.\
\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"Controllability", "i:5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ControllablePair[A1, B1]\)], "Input",
  CellLabel->"In[58]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Controllability", "i:5"}],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[58]=",
  CellTags->{"Controllability", "i:5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ObservablePair[A1, C1]\)], "Input",
  CellLabel->"In[59]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Controllability", "i:5"}],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[59]=",
  CellTags->{"Controllability", "i:5"}]
}, Open  ]],

Cell["\<\
Since the system is controllable, we can place the poles, at say (-2,-2), \
using state feedback. First, lets do it using both controls\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"Controllability", "i:5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolePlace[A1, B1, {\(-2\), \(-2\)}]\)], "Input",
  CellLabel->"In[60]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Controllability", "i:5"}],

Cell[BoxData[
    \({{\(-4\), 3}, {0, 0}}\)], "Output",
  CellLabel->"Out[60]=",
  CellTags->{"Controllability", "i:5"}]
}, Open  ]],

Cell["Now, do it using only the second control (port 2):", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"Controllability", "i:5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolePlace[A1, B1, 2, {\(-2\), \(-2\)}]\)], "Input",
  CellLabel->"In[61]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Controllability", "i:5"}],

Cell[BoxData[
    \({{0, 0}, {\(-\(4\/3\)\), 1}}\)], "Output",
  CellLabel->"Out[61]=",
  CellTags->{"Controllability", "i:5"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Kalman Reduction & Minimal (Irreducible) Realizations", "Subsection",
  CellTags->{"Kalman Form", "i:6"}],

Cell["\<\
KalmanDecomposition - transforms a state space description to a canonical \
form identifying the four parts: controllable & observable, controllable & \
not observable, not controllable & observable, not controllable & not \
observable. An option (IrreducibleRealization->True) returns only the minimal \
(or irreducible) system, i.e., the controllable & observable part. \
\>", "Text",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[{
    \(\(AA = {{1, 1, 0}, {0, 1, 0}, {0, 1, 1}};\)\), "\n", 
    \(\(BB = {{0, 1}, {1, 0}, {0, 1}};\)\), "\n", 
    \(CC = {{1, 1, 1}}; DD = {{0, 0}};\)}], "Input",
  CellLabel->"In[62]:=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({Anew, Bnew, Cnew, Dnew} = 
        KalmanDecomposition[AA, BB, CC, DD];\)\), "\n", 
    \(Anew // MatrixForm\), "\n", 
    \(Bnew // MatrixForm\), "\n", 
    \(Cnew // MatrixForm\), "\n", 
    \(Dnew // MatrixForm\)}], "Input",
  CellLabel->"In[63]:=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \("Decompose into controllable/uncontrollable parts."\)], "Print",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \("Divide controllable part into observable/unobservable parts."\)], \
"Print",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \("System is observable."\)], "Print",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \("Divide uncontrollable part into observable/unobservable parts."\)], \
"Print",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", "1", "0"},
            {"0", "1", "0"},
            {"0", "0", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[63]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "1"},
            {"1", "0"},
            {"0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[64]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"2", "1", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[65]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[66]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Anew\), "\n", 
    \(Bnew\), "\n", 
    \(Cnew\), "\n", 
    \(Dnew\)}], "Input",
  CellLabel->"In[67]:=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \({{1, 1, 0}, {0, 1, 0}, {0, 0, 1}}\)], "Output",
  CellLabel->"Out[67]=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \({{0, 1}, {1, 0}, {0, 0}}\)], "Output",
  CellLabel->"Out[68]=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \({{2, 1, 0}}\)], "Output",
  CellLabel->"Out[69]=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \({{0, 0}}\)], "Output",
  CellLabel->"Out[70]=",
  CellTags->{"Kalman Form", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({Anew, Bnew, Cnew, Dnew} = 
        KalmanDecomposition[AA, BB, CC, DD, 
          IrreducibleRealization -> True];\)\), "\n", 
    \(Anew // MatrixForm\), "\n", 
    \(Bnew // MatrixForm\), "\n", 
    \(Cnew // MatrixForm\), "\n", 
    \(Dnew // MatrixForm\)}], "Input",
  CellLabel->"In[71]:=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \("Decompose into controllable/uncontrollable parts."\)], "Print",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \("Divide controllable part into observable/unobservable parts."\)], \
"Print",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \("System is observable."\)], "Print",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \("Divide uncontrollable part into observable/unobservable parts."\)], \
"Print",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", "1", "0"},
            {"0", "1", "0"},
            {"0", "0", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[71]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "1"},
            {"1", "0"},
            {"0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[72]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"2", "1", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[73]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[74]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}]
}, Open  ]],

Cell[BoxData[{
    \(\(AA = {{0, \(-1\), 1}, {1, \(-2\), 1}, {0, 1, \(-1\)}};\)\), "\n", 
    \(\(BB = {{1, 0}, {1, 1}, {1, 2}};\)\), "\n", 
    \(CC = {{0, 1, 0}}; DD = {{0, 0}};\)}], "Input",
  CellLabel->"In[75]:=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({Anew, Bnew, Cnew, Dnew} = 
        KalmanDecomposition[AA, BB, CC, DD];\)\), "\n", 
    \(Anew // MatrixForm\), "\n", 
    \(Bnew // MatrixForm\), "\n", 
    \(Cnew // MatrixForm\), "\n", 
    \(Dnew // MatrixForm\)}], "Input",
  CellLabel->"In[76]:=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \("Decompose into controllable/uncontrollable parts."\)], "Print",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \("Divide controllable part into observable/unobservable parts."\)], \
"Print",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \("Divide uncontrollable part into observable/unobservable parts."\)], \
"Print",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \("System is observable."\)], "Print",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(-1\), "1", "5"},
            {"0", "0", "2"},
            {"0", "0", \(-2\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[76]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", "0"},
            {"1", "1"},
            {"0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[77]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "1", \(-2\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[78]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[79]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({Anew, Bnew, Cnew, Dnew} = 
        KalmanDecomposition[AA, BB, CC, DD, 
          IrreducibleRealization -> True];\)\), "\n", 
    \(Anew // MatrixForm\), "\n", 
    \(Bnew // MatrixForm\), "\n", 
    \(Cnew // MatrixForm\), "\n", 
    \(Dnew // MatrixForm\)}], "Input",
  CellLabel->"In[80]:=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \("Decompose into controllable/uncontrollable parts."\)], "Print",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \("Divide controllable part into observable/unobservable parts."\)], \
"Print",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \("Divide uncontrollable part into observable/unobservable parts."\)], \
"Print",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \("System is observable."\)], "Print",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(-1\), "1", "5"},
            {"0", "0", "2"},
            {"0", "0", \(-2\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[80]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", "0"},
            {"1", "1"},
            {"0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[81]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "1", \(-2\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[82]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[83]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}]
}, Open  ]],

Cell[BoxData[{
    \(\(AA = {{0, \(-1\), 1}, {1, \(-2\), 1}, {0, 1, \(-1\)}};\)\), "\n", 
    \(\(BB = {{1, 0}, {1, 1}, {1, 2}};\)\), "\n", 
    \(CC = {{0, 1, 0}}; DD = {{0, 0}};\)}], "Input",
  CellLabel->"In[84]:=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\({Anew, Bnew, Cnew, Dnew} = 
        MinimalRealization[AA, BB, CC, DD];\)\), "\n", 
    \(Anew // MatrixForm\), "\n", 
    \(Bnew // MatrixForm\), "\n", 
    \(Cnew // MatrixForm\), "\n", 
    \(Dnew // MatrixForm\)}], "Input",
  CellLabel->"In[85]:=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \("Decompose into controllable/uncontrollable parts."\)], "Print",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    \("Divide controllable part into observable/unobservable parts."\)], \
"Print",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(-1\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[85]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[86]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[87]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[88]//MatrixForm=",
  CellTags->{"Kalman Form", "i:6"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Another Example: lateral aircraft dynamics", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell["\<\
The following model is representaive of the linearized lateral dynamics of an \
aircraft:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AA = {{\(-10\), 0, \(-10\), 0}, {0, \(- .7\), 9, 0}, {0, \(-1\), 
          \(- .7\), 0}, {1, 0, 0, 0}}\)], "Input",
  CellLabel->"In[89]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\({\(-10\), 0, \(-10\), 0}\), ",", 
        RowBox[{"{", 
          RowBox[{"0", ",", 
            RowBox[{"-", 
              StyleBox["0.7`",
                StyleBoxAutoDelete->True,
                PrintPrecision->1]}], ",", "9", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"0", ",", \(-1\), ",", 
            RowBox[{"-", 
              StyleBox["0.7`",
                StyleBoxAutoDelete->True,
                PrintPrecision->1]}], ",", "0"}], "}"}], ",", 
        \({1, 0, 0, 0}\)}], "}"}]], "Output",
  CellLabel->"Out[89]=",
  CellTags->"Another Example"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(BB = {{20, 2.8}, {0, \(-3.13\)}, {0, 0}, {0, 0}}\)], "Input",
  CellLabel->"In[90]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{"20", ",", 
            StyleBox["2.79999999999999982`",
              StyleBoxAutoDelete->True,
              PrintPrecision->2]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"0", ",", 
            RowBox[{"-", 
              StyleBox["3.12999999999999989`",
                StyleBoxAutoDelete->True,
                PrintPrecision->3]}]}], "}"}], ",", \({0, 0}\), ",", 
        \({0, 0}\)}], "}"}]], "Output",
  CellLabel->"Out[90]=",
  CellTags->"Another Example"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CC = {{0, 0, 1, 0}, {0, 0, 0, 1}}\)], "Input",
  CellLabel->"In[91]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[BoxData[
    \({{0, 0, 1, 0}, {0, 0, 0, 1}}\)], "Output",
  CellLabel->"Out[91]=",
  CellTags->"Another Example"]
}, Open  ]],

Cell["Lets test controllability and observability:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ControllablePair[AA, BB]\)], "Input",
  CellLabel->"In[92]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[92]=",
  CellTags->"Another Example"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ObservablePair[AA, CC]\)], "Input",
  CellLabel->"In[93]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[93]=",
  CellTags->"Another Example"]
}, Open  ]],

Cell["Now, we can obtain the transfer function.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[BoxData[
    \(K[s_] := StateSpaceToTransferFunction[AA, BB, CC, s]\)], "Input",
  CellLabel->"In[94]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[CellGroupData[{

Cell[BoxData[
    \(K[s]\)], "Input",
  CellLabel->"In[95]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[BoxData[
    \({{0, 
        \(31.2999999999999989`\ s + 
            3.12999999999999989`\ s\^2\)\/\(94.9000000000000021`\ s + 
            23.4900000000000019`\ s\^2 + 11.4000000000000012`\ s\^3 + 
            s\^4\)}, {
        \(\(189.800000000000004`\[InvisibleSpace]\) + 
            28.0000000000000035`\ s + 
            20.`\ s\^2\)\/\(94.9000000000000021`\ s + 
            23.4900000000000019`\ s\^2 + 11.4000000000000012`\ s\^3 + s\^4\), 
        \(\(-4.72799999999999798`\) + 3.91999999999999957`\ s + 
            2.79999999999999982`\ s\^2\)\/\(94.9000000000000021`\ s + 
            23.4900000000000019`\ s\^2 + 11.4000000000000012`\ s\^3 + s\^4\)}}
      \)], "Output",
  CellLabel->"Out[95]=",
  CellTags->"Another Example"]
}, Open  ]],

Cell["\<\
We can obtain the McMillan degree and generate a Laurent series.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[CellGroupData[{

Cell[BoxData[
    \(McMillanDegree[K, s]\)], "Input",
  CellLabel->"In[96]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[96]=",
  CellTags->"Another Example"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LaurentSeries[K, s, 3]\)], "Input",
  CellLabel->"In[97]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{"0", ",", 
            InterpretationBox[
              RowBox[{
              \(3.12999999999999989`\ \((1\/s)\)\^2\), "-", 
                \(4.38200000000000056`\ \((1\/s)\)\^3\), "+", 
                InterpretationBox[\(O[1\/s]\^4\),
                  SeriesData[ 
                    Power[ s, -1], 0, {}, 2, 4, 1]]}],
              SeriesData[ 
                Power[ s, -1], 0, {3.1299999999999999, -4.3820000000000006}, 
                2, 4, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[
              RowBox[{
              \(20.`\ \((1\/s)\)\^2\), "-", \(200.`\ \((1\/s)\)\^3\), "+", 
                InterpretationBox[\(O[1\/s]\^4\),
                  SeriesData[ 
                    Power[ s, -1], 0, {}, 2, 4, 1]]}],
              SeriesData[ 
                Power[ s, -1], 0, {.2*^2, -.2*^3}, 2, 4, 1]], ",", 
            InterpretationBox[
              RowBox[{
              \(2.79999999999999982`\ \((1\/s)\)\^2\), "-", 
                \(28.0000000000000035`\ \((1\/s)\)\^3\), "+", 
                InterpretationBox[\(O[1\/s]\^4\),
                  SeriesData[ 
                    Power[ s, -1], 0, {}, 2, 4, 1]]}],
              SeriesData[ 
                Power[ s, -1], 0, {2.7999999999999998, -28.0}, 2, 4, 1]]}], 
          "}"}]}], "}"}]], "Output",
  CellLabel->"Out[97]=",
  CellTags->"Another Example"]
}, Open  ]],

Cell["\<\
We can construct controllable or observable realizations from this transfer \
function.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ControllableRealization[K, s]\)], "Input",
  CellLabel->"In[98]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[BoxData[
    \({{{0, 0, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 
          0, 0, 0}, {0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 0}, {0, 
          0, 0, 0, 0, 0, 0, 1}, {0, 0, \(-94.9000000000000021`\), 0, 
          \(-23.4900000000000019`\), 0, \(-11.4000000000000012`\), 0}, {0, 0, 
          0, \(-94.9000000000000021`\), 0, \(-23.4900000000000019`\), 0, 
          \(-11.4000000000000012`\)}}, {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 
          0}, {0, 0}, {1, 0}, {0, 1}}, {{0, 0, 0, 31.2999999999999989`, 0, 
          3.12999999999999989`, 0, 0}, {189.800000000000004`, 
          \(-4.72799999999999709`\), 28.0000000000000035`, 
          3.91999999999999904`, 20.`, 2.79999999999999982`, 0, 0}}}\)], 
  "Output",
  CellLabel->"Out[98]=",
  CellTags->"Another Example"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ObservableRealization[K, s]\)], "Input",
  CellLabel->"In[99]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[BoxData[
    \({{{0, 0, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 
          0, 0, 0}, {0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 0}, {0, 
          0, 0, 0, 0, 0, 0, 1}, {0, 0, \(-94.9000000000000021`\), 0, 
          \(-23.4900000000000019`\), 0, \(-11.4000000000000012`\), 0}, {0, 0, 
          0, \(-94.9000000000000021`\), 0, \(-23.4900000000000019`\), 0, 
          \(-11.4000000000000012`\)}}, {{0, 0}, {0, 0}, {0, 
          3.12999999999999989`}, {20.`, 2.79999999999999982`}, {0, 
          \(-4.38200000000000056`\)}, {\(-200.`\), 
          \(-28.0000000000000035`\)}, {0, \(-23.5689000000000037`\)}, {
          2000.`, 248.700000000000009`}}, {{1, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 
          0, 0, 0, 0, 0, 0}}}\)], "Output",
  CellLabel->"Out[99]=",
  CellTags->"Another Example"]
}, Open  ]],

Cell["\<\
Now, let's look at a SISO system whose input is the first control and output \
is the second output:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[BoxData[
    \(K1[s_] := 
      StateSpaceToTransferFunction[AA, 
        BB\[LeftDoubleBracket]{1, 2, 3, 4}, {1}\[RightDoubleBracket], 
        CC\[LeftDoubleBracket]{2}, {1, 2, 3, 4}\[RightDoubleBracket], s]\)], 
  "Input",
  CellLabel->"In[100]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[CellGroupData[{

Cell[BoxData[
    \(K1[s]\)], "Input",
  CellLabel->"In[101]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[BoxData[
    \({{\(20\ 
            \((\(9.49000000000000021`\[InvisibleSpace]\) + 
                1.39999999999999991`\ s + s\^2)\)\)\/\(94.9000000000000021`\ 
              s + 23.4900000000000019`\ s\^2 + 11.4000000000000012`\ s\^3 + 
            s\^4\)}}\)], "Output",
  CellLabel->"Out[101]=",
  CellTags->"Another Example"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(McMillanDegree[K1, s]\)], "Input",
  CellLabel->"In[102]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[102]=",
  CellTags->"Another Example"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ObservableRealization[K1, s]\)], "Input",
  CellLabel->"In[103]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[BoxData[
    \({{{0, 1, 0, 0}, {0, 0, 1, 0}, {0, 0, 0, 1}, {0, 
          \(-94.9000000000000021`\), \(-23.4900000000000019`\), 
          \(-11.4000000000000012`\)}}, {{0}, {20}, {\(-200.`\)}, {2000.`}}, {{
          1, 0, 0, 0}}}\)], "Output",
  CellLabel->"Out[103]=",
  CellTags->"Another Example"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ControllablePair[AA, 
      BB\[LeftDoubleBracket]{1, 2, 3, 4}, {1}\[RightDoubleBracket]]\)], 
  "Input",
  CellLabel->"In[104]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[104]=",
  CellTags->"Another Example"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ControllabilityMatrix[AA, 
      BB\[LeftDoubleBracket]{1, 2, 3, 4}, {1}\[RightDoubleBracket]]\)], 
  "Input",
  CellLabel->"In[105]:=",
  CellTags->"Another Example"],

Cell[BoxData[
    \({{20, \(-200.`\), 2000.`, \(-20000.`\)}, {0, 0.`, 0.`, 0.`}, {0, 0.`, 
        0.`, 0.`}, {0, 20.`, \(-200.`\), 2000.`}}\)], "Output",
  CellLabel->"Out[105]=",
  CellTags->"Another Example"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ObservablePair[AA, 
      CC\[LeftDoubleBracket]{2}, {1, 2, 3, 4}\[RightDoubleBracket]]\)], 
  "Input",
  CellLabel->"In[106]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Another Example"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[106]=",
  CellTags->"Another Example"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ObservabilityMatrix[AA, 
      CC\[LeftDoubleBracket]{2}, {1, 2, 3, 4}\[RightDoubleBracket]]\)], 
  "Input",
  CellLabel->"In[107]:=",
  CellTags->"Another Example"],

Cell[BoxData[
    \({{0, 0, 0, 1}, {1.`, 0.`, 0.`, 0.`}, {\(-10.`\), 0.`, \(-10.`\), 0.`}, {
        100.`, 10.`, 107.000000000000006`, 0.`}}\)], "Output",
  CellLabel->"Out[107]=",
  CellTags->"Another Example"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics Functions", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Introduction"],

Cell["\<\
In the following paragraphs we will illustrate the use of graphics functions \
that produce Bode, Nyquist, and root locus plots, and a surface plot \
illustrating the singularities of a rational transefer function.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Introduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Bode Plot", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"Bode plot", "i:9"}],

Cell["Now, define a transfer function", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"Bode plot", "i:9"}],

Cell[BoxData[
    \(G[s_] := \(\((s + 10)\)\ \((s + 4)\)\)\/\(\((s + 5)\)\ \((s\^2 + 2\ s + \
2)\)\ \((s\^2 + 1\ s + 1)\)\)\)], "Input",
  CellLabel->"In[108]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Bode plot", "i:9"}],

Cell["\<\
The Bode plot of G over the frquency range .01 to 10 radians per second is \
obtained by invoking the function:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"Bode plot", "i:9"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Bode[G, s,  .01, 10]\)], "Input",
  CellLabel->"In[109]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Bode plot", "i:9"}],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .33333 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.658728 0.317462 0.266206 0.00450947 [
[.0238 -0.0125 -14 -12.875 ]
[.0238 -0.0125 14 0 ]
[.2457 -0.0125 -14 -12.875 ]
[.2457 -0.0125 14 0 ]
[.34127 -0.0125 -11 -12.875 ]
[.34127 -0.0125 11 0 ]
[.56316 -0.0125 -11 -12.875 ]
[.56316 -0.0125 11 0 ]
[.65873 -0.0125 -5 -12.875 ]
[.65873 -0.0125 5 0 ]
[.88062 -0.0125 -5 -12.875 ]
[.88062 -0.0125 5 0 ]
[.97619 -0.0125 -8 -12.875 ]
[.97619 -0.0125 8 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -23 -25.75 ]
[.5 -0.0125 23 -12.875 ]
[-0.0125 .04073 -18 -4.5 ]
[-0.0125 .04073 0 4.5 ]
[-0.0125 .08583 -18 -4.5 ]
[-0.0125 .08583 0 4.5 ]
[-0.0125 .13092 -18 -4.5 ]
[-0.0125 .13092 0 4.5 ]
[-0.0125 .17602 -18 -4.5 ]
[-0.0125 .17602 0 4.5 ]
[-0.0125 .22111 -18 -4.5 ]
[-0.0125 .22111 0 4.5 ]
[-0.0125 .26621 -6 -4.5 ]
[-0.0125 .26621 0 4.5 ]
[-0.0125 .3113 -12 -4.5 ]
[-0.0125 .3113 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .16667 -40 -6.4375 ]
[-0.01875 .16667 -18 6.4375 ]
[.0238 .34583 -14 0 ]
[.0238 .34583 14 12.875 ]
[.2457 .34583 -14 0 ]
[.2457 .34583 14 12.875 ]
[.34127 .34583 -11 0 ]
[.34127 .34583 11 12.875 ]
[.56316 .34583 -11 0 ]
[.56316 .34583 11 12.875 ]
[.65873 .34583 -5 0 ]
[.65873 .34583 5 12.875 ]
[.88062 .34583 -5 0 ]
[.88062 .34583 5 12.875 ]
[.97619 .34583 -8 0 ]
[.97619 .34583 8 12.875 ]
[ 0 .33333 .125 0 ]
[.5 .34583 -26 12.875 ]
[.5 .34583 26 24.0625 ]
[ 1 0 .125 0 ]
[1.0125 .16667 0 -6.4375 ]
[1.0125 .16667 10 6.4375 ]
[ 0 -0.0005 0 0 ]
[ 1 .33383 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
.75 g
.25 Mabswid
.0238 0 m
.0238 .33333 L
s
.18253 0 m
.18253 .33333 L
s
.34127 0 m
.34127 .33333 L
s
.5 0 m
.5 .33333 L
s
.65873 0 m
.65873 .33333 L
s
.81746 0 m
.81746 .33333 L
s
.97619 0 m
.97619 .33333 L
s
0 .04073 m
1 .04073 L
s
0 .08583 m
1 .08583 L
s
0 .13092 m
1 .13092 L
s
0 .17602 m
1 .17602 L
s
0 .22111 m
1 .22111 L
s
0 .26621 m
1 .26621 L
s
0 .3113 m
1 .3113 L
s
0 g
.0238 0 m
.0238 .00625 L
s
gsave
.0238 -0.0125 -75 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.01) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.2457 0 m
.2457 .00625 L
s
gsave
.2457 -0.0125 -75 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.05) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.34127 0 m
.34127 .00625 L
s
gsave
.34127 -0.0125 -72 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.1) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.56316 0 m
.56316 .00625 L
s
gsave
.56316 -0.0125 -72 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.65873 0 m
.65873 .00625 L
s
gsave
.65873 -0.0125 -66 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.88062 0 m
.88062 .00625 L
s
gsave
.88062 -0.0125 -66 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.97619 0 m
.97619 .00625 L
s
gsave
.97619 -0.0125 -69 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
75.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.001 w
.11937 0 m
.11937 .00375 L
s
.17527 0 m
.17527 .00375 L
s
.21494 0 m
.21494 .00375 L
s
.27084 0 m
.27084 .00375 L
s
.29209 0 m
.29209 .00375 L
s
.3105 0 m
.3105 .00375 L
s
.32674 0 m
.32674 .00375 L
s
.43683 0 m
.43683 .00375 L
s
.49273 0 m
.49273 .00375 L
s
.5324 0 m
.5324 .00375 L
s
.5883 0 m
.5883 .00375 L
s
.60955 0 m
.60955 .00375 L
s
.62796 0 m
.62796 .00375 L
s
.6442 0 m
.6442 .00375 L
s
.75429 0 m
.75429 .00375 L
s
.8102 0 m
.8102 .00375 L
s
.84986 0 m
.84986 .00375 L
s
.90576 0 m
.90576 .00375 L
s
.92701 0 m
.92701 .00375 L
s
.94543 0 m
.94543 .00375 L
s
.96166 0 m
.96166 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -84 -29.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(rad) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
81.000000 13.000000 moveto
(\\220) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(sec) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
0 .04073 m
.00625 .04073 L
s
[(-50)] -0.0125 .04073 1 0 Mshowa
0 .08583 m
.00625 .08583 L
s
[(-40)] -0.0125 .08583 1 0 Mshowa
0 .13092 m
.00625 .13092 L
s
[(-30)] -0.0125 .13092 1 0 Mshowa
0 .17602 m
.00625 .17602 L
s
[(-20)] -0.0125 .17602 1 0 Mshowa
0 .22111 m
.00625 .22111 L
s
[(-10)] -0.0125 .22111 1 0 Mshowa
0 .26621 m
.00625 .26621 L
s
[(0)] -0.0125 .26621 1 0 Mshowa
0 .3113 m
.00625 .3113 L
s
[(10)] -0.0125 .3113 1 0 Mshowa
.125 Mabswid
0 .04975 m
.00375 .04975 L
s
0 .05877 m
.00375 .05877 L
s
0 .06779 m
.00375 .06779 L
s
0 .07681 m
.00375 .07681 L
s
0 .09485 m
.00375 .09485 L
s
0 .10387 m
.00375 .10387 L
s
0 .11288 m
.00375 .11288 L
s
0 .1219 m
.00375 .1219 L
s
0 .13994 m
.00375 .13994 L
s
0 .14896 m
.00375 .14896 L
s
0 .15798 m
.00375 .15798 L
s
0 .167 m
.00375 .167 L
s
0 .18504 m
.00375 .18504 L
s
0 .19405 m
.00375 .19405 L
s
0 .20307 m
.00375 .20307 L
s
0 .21209 m
.00375 .21209 L
s
0 .23013 m
.00375 .23013 L
s
0 .23915 m
.00375 .23915 L
s
0 .24817 m
.00375 .24817 L
s
0 .25719 m
.00375 .25719 L
s
0 .27523 m
.00375 .27523 L
s
0 .28424 m
.00375 .28424 L
s
0 .29326 m
.00375 .29326 L
s
0 .30228 m
.00375 .30228 L
s
0 .03171 m
.00375 .03171 L
s
0 .02269 m
.00375 .02269 L
s
0 .01368 m
.00375 .01368 L
s
0 .00466 m
.00375 .00466 L
s
0 .32032 m
.00375 .32032 L
s
0 .32934 m
.00375 .32934 L
s
.25 Mabswid
0 0 m
0 .33333 L
s
gsave
-0.01875 .16667 -101 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(dB) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.0238 .32708 m
.0238 .33333 L
s
gsave
.0238 .34583 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.01) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.2457 .32708 m
.2457 .33333 L
s
gsave
.2457 .34583 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.05) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.34127 .32708 m
.34127 .33333 L
s
gsave
.34127 .34583 -72 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.1) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.56316 .32708 m
.56316 .33333 L
s
gsave
.56316 .34583 -72 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.65873 .32708 m
.65873 .33333 L
s
gsave
.65873 .34583 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.88062 .32708 m
.88062 .33333 L
s
gsave
.88062 .34583 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.97619 .32708 m
.97619 .33333 L
s
gsave
.97619 .34583 -69 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
75.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.001 w
.11937 .32958 m
.11937 .33333 L
s
.17527 .32958 m
.17527 .33333 L
s
.21494 .32958 m
.21494 .33333 L
s
.27084 .32958 m
.27084 .33333 L
s
.29209 .32958 m
.29209 .33333 L
s
.3105 .32958 m
.3105 .33333 L
s
.32674 .32958 m
.32674 .33333 L
s
.43683 .32958 m
.43683 .33333 L
s
.49273 .32958 m
.49273 .33333 L
s
.5324 .32958 m
.5324 .33333 L
s
.5883 .32958 m
.5883 .33333 L
s
.60955 .32958 m
.60955 .33333 L
s
.62796 .32958 m
.62796 .33333 L
s
.6442 .32958 m
.6442 .33333 L
s
.75429 .32958 m
.75429 .33333 L
s
.8102 .32958 m
.8102 .33333 L
s
.84986 .32958 m
.84986 .33333 L
s
.90576 .32958 m
.90576 .33333 L
s
.92701 .32958 m
.92701 .33333 L
s
.94543 .32958 m
.94543 .33333 L
s
.96166 .32958 m
.96166 .33333 L
s
.25 Mabswid
0 .33333 m
1 .33333 L
s
gsave
.5 .34583 -87 8.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 15.187500 moveto
 460.000000 15.187500 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 15.187500 lineto
closepath
clip newpath
63.000000 12.500000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 12.500000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(MAGNITUDE) show
111.000000 12.500000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica-Bold
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica-Bold
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica-Bold
grestore
.99375 .04073 m
1 .04073 L
s
.99375 .08583 m
1 .08583 L
s
.99375 .13092 m
1 .13092 L
s
.99375 .17602 m
1 .17602 L
s
.99375 .22111 m
1 .22111 L
s
.99375 .26621 m
1 .26621 L
s
.99375 .3113 m
1 .3113 L
s
.125 Mabswid
.99625 .04975 m
1 .04975 L
s
.99625 .05877 m
1 .05877 L
s
.99625 .06779 m
1 .06779 L
s
.99625 .07681 m
1 .07681 L
s
.99625 .09485 m
1 .09485 L
s
.99625 .10387 m
1 .10387 L
s
.99625 .11288 m
1 .11288 L
s
.99625 .1219 m
1 .1219 L
s
.99625 .13994 m
1 .13994 L
s
.99625 .14896 m
1 .14896 L
s
.99625 .15798 m
1 .15798 L
s
.99625 .167 m
1 .167 L
s
.99625 .18504 m
1 .18504 L
s
.99625 .19405 m
1 .19405 L
s
.99625 .20307 m
1 .20307 L
s
.99625 .21209 m
1 .21209 L
s
.99625 .23013 m
1 .23013 L
s
.99625 .23915 m
1 .23915 L
s
.99625 .24817 m
1 .24817 L
s
.99625 .25719 m
1 .25719 L
s
.99625 .27523 m
1 .27523 L
s
.99625 .28424 m
1 .28424 L
s
.99625 .29326 m
1 .29326 L
s
.99625 .30228 m
1 .30228 L
s
.99625 .03171 m
1 .03171 L
s
.99625 .02269 m
1 .02269 L
s
.99625 .01368 m
1 .01368 L
s
.99625 .00466 m
1 .00466 L
s
.99625 .32032 m
1 .32032 L
s
.99625 .32934 m
1 .32934 L
s
.25 Mabswid
1 0 m
1 .33333 L
s
gsave
1.0125 .16667 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
69.000000 13.000000 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .33333 L
0 .33333 L
closepath
clip
newpath
.5 Mabswid
.02381 .32051 m
.13457 .32052 L
.1907 .32053 L
.2357 .32055 L
.26792 .32058 L
.29222 .3206 L
.31139 .32064 L
.32976 .32068 L
.34688 .32072 L
.36216 .32078 L
.3769 .32084 L
.40011 .32097 L
.42342 .32115 L
.44176 .32135 L
.47208 .32178 L
.48668 .32207 L
.49898 .32234 L
.53756 .32349 L
.57 .32468 L
.57673 .32491 L
.5835 .32511 L
.58903 .32525 L
.59207 .32531 L
.59485 .32535 L
.59647 .32537 L
.59799 .32539 L
.60079 .3254 L
.60234 .3254 L
.60375 .32539 L
.60529 .32538 L
.6069 .32535 L
.60836 .32533 L
.60992 .32529 L
.6127 .32521 L
.61594 .32507 L
.61884 .32491 L
.62341 .32457 L
.62824 .32409 L
.63311 .32345 L
.63749 .32273 L
.64576 .32092 L
.65419 .31841 L
.66829 .31253 L
.68076 .30557 L
.69133 .29845 L
.73027 .26511 L
.75954 .23551 L
.7851 .20825 L
.8059 .1857 L
.82504 .16492 L
Mistroke
.84125 .14739 L
.85524 .13236 L
.86871 .11799 L
.88054 .10545 L
.8921 .0933 L
.90238 .08256 L
.9116 .073 L
.92077 .06355 L
.92907 .05506 L
.9366 .0474 L
.94418 .03973 L
.95111 .03277 L
.95812 .02578 L
.96454 .0194 L
.97046 .01357 L
.97619 .00794 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[109]:=",
  ImageSize->{524, 174.438},
  ImageMargins->{{0, 0}, {0, 1}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008<0000[Q000`40O003h00Oogooogoo3Woo003o
OoooOol>Ool00?mooomoo`ioo`00ogooogoo3Woo003oOolDOol00`00Oomoo`3fOol00?moo`9oo`<0
009oo`@0009oo`<000Eoo`03001oogoo009oo`8000Aoo`80009oo`<00>Ioo`00ogoo0goo00@007oo
Oomoo`<0009oo`04001oogoo0005Ool00`00Oomoo`04Ool01000Oomoo`0017oo00<007ooOol0iWoo
003oOol3Ool00`00Oomoo`03Ool01000Oomoo`000Woo00<007ooOol00goo00<007ooOol00goo00@0
07ooOomoo`<0009oo`03001oogoo0>Ioo`00ogoo0Woo10000Woo0P000goo0`001Woo00<007ooOol0
0Woo0P000Woo0`000Woo0`00iWoo003oOol?Ool00`00Oomoo`04Ool00`00Oomoo`3dOol00?moo`io
o`8000Moo`03001oogoo0?=oo`00ogooogoo3Woo003oOoooOol>Ool00?mooomoo`ioo`00ogooogoo
3Woo003oOoooOol>Ool00?mooomoo`ioo`00ogooogoo3Woo001WOol00`00Oomoo`02Ool00`00Oomo
o`02Ool00`00Oomoo`05000jOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`0BOol00`00Oomoo`02Ool00`00Oomoo`050010Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`0HOol50019Ool00`00Oomoo`0IOol50002Ool00`00Oomoo`1?Ool006Ioo`03001oo`00
00Moo`03001oo`0000=oo`03001oogoo03Uoo`03001oo`0000Moo`03001oo`00009oo`03001oo`00
019oo`03001oo`0000Qoo`03001oogoo03moo`03001oo`0000Moo`03001oo`0001]oo`03001oogoo
04Qoo`03001oo`0001aoo`07001oogooOol007oo0000D7oo001VOol00`00Ool00007Ool00`00Ool0
0003Ool00`00Oomoo`0iOol00`00Ool00007Ool00`00Ool00004Ool00`00Oomoo`0@Ool00`00Ool0
0008Ool00`00Oomoo`0oOol00`00Ool00009Ool00`00Oomoo`0IOol00`00Oomoo`1:Ool00`00Oomo
o`0JOol01`00Oomoogoo001oo`00051oo`00IWoo00<007oo00001goo00<007oo00000goo00<007oo
Ool0>Goo00<007oo00001goo00<007oo00000Woo0P004goo00<007oo000027oo00<007ooOol0?goo
00<007oo00001goo0P0077oo00<007ooOol0B7oo0P007Goo00L007ooOomoo`00Ool0001@Ool006Io
o`03001oo`0000Moo`03001oo`0000=oo`03001oogoo03Uoo`03001oo`0000Moo`03001oo`00009o
o`03001oogoo019oo`03001oo`0000Qoo`03001oogoo03moo`03001oo`0000Moo`03001oogoo01]o
o`03001oogoo04Qoo`03001oogoo01aoo`07001oogooOol007oo0000D7oo001WOol00`00Oomoo`07
Ool01000Oomoogoo0P00?7oo00<007ooOol01goo00@007ooOomoo`<001=oo`03001oogoo00Ioo`80
049oo`03001oogoo00Ioo`<001Yoo`8004Yoo`<001]oo`8000Aoo`03001oogoo04moo`00ogooogoo
3Woo003oOoooOol>Ool00?mooomoo`ioo`00ogooogoo3Woo003oOoooOol>Ool00?mooomoo`ioo`00
JGooo`00F`00BGoo001YOol00`00Oomoo`05Ool00`00Oomoo`0NOol00`00Oomoo`0@Ool01000Oomo
oekg2Woo00<007ooOol01goo00<007ooOol01Woo00<007ooOol017oo00<007ooOol017oo00<007oo
Ool00Woo00<007ooOol00Woo00<007ooOol07Woo00<007ooOol04Goo00<007ooG_L02Woo00<007oo
Ool027oo00<007ooOol01Woo00<007ooOol017oo00<007ooOol00goo00<007ooOol00goo00<007oo
Ool00Woo00<007ooOol07Woo00<007ooOol047oo00@007ooOomNm`Yoo`03001oogoo00Moo`03001o
ogoo00Ioo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo009oo`03001o
ogoo00Ioo`03001oogoo04Moo`00JGoo0P001Woo00<007ooOol0=7oo00=NmgooOol04Woo00<007oo
Ool07Woo00<007ooOol0=7oo00=NmgooOol04goo00<007ooOol07Woo00<007ooOol0=7oo00=Nmgoo
Ool04Woo00<007ooOol07Woo00<007ooOol017oo0`00BGoo001YOol00`00Oomoo`05Ool00ekgOomo
o`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomo
o`0cOol00`00Oomoo`06Ool00`00Oomoo`17Ool006Uoo`03001oogoo00Eoo`03G_Moogoo03Aoo`03
G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo039oo`03
001Nmgoo00Moo`03001oogoo04Moo`00JGoo0P001Woo00=NmgooOol0=7oo00=NmgooOol0<goo00=N
mgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0<Goo00<007ooG_L01Woo0`00
BGoo001YOol00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekg
Oomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0`Ool01000Oomooekg27oo00<007ooOol0Agoo001Y
Ool00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0d
Ool00ekgOomoo`0dOol00ekgOomoo`0_Ool01@00OomoogooG_L027oo00<007ooOol0Agoo001YOol2
0006Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomo
o`0dOol00ekgOomoo`0^Ool00`00Oomoo`02Ool00ekgOomoo`04Ool30019Ool006Uoo`03001oogoo
00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo
03Aoo`03G_Moogoo02eoo`03001oogoo00=oo`03G_Moogoo00Ioo`03001oogoo04Moo`00JGoo00<0
07ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=N
mgooOol0=7oo00=NmgooOol0;7oo00<007ooOol017oo00=NmgooOol01Woo00<007ooOol0Agoo001Y
Ool20006Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekg
Oomoo`0dOol00ekgOomoo`0[Ool00`00Oomoo`05Ool00ekgOomoo`04Ool30019Ool005aoo`03001o
ogoo009oo`03001oogoo00Eoo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Mo
ogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo02Yoo`03001oogoo00Ioo`03G_Mo
ogoo00Ioo`03001oogoo04Moo`00Fgoo00<007oo00000Woo00<007oo00001Woo00<007ooOol01Goo
00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0=7oo
00=NmgooOol0:Goo00<007ooOol01goo00=NmgooOol01Woo00<007ooOol0Agoo001FOol30004Ool0
1P00Oomoo`00Ool000Ioo`<00?mNmd=Nm`03001Nmekg00iNm`@004Uoo`00Fgoo0P000goo00<007oo
00001Woo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=Nmgoo
Ool0=7oo00=NmgooOol0=7oo00=NmgooOol09goo00<007ooOol02Goo00=NmgooOol01Woo00<007oo
Ool0Agoo001KOol00`00Oomoo`02Ool00`00Ool00006Ool00`00Oomoo`05Ool00ekgOomoo`0dOol0
0ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0VOol0
0`00Oomoo`0:Ool00ekgOomoo`06Ool00`00Oomoo`17Ool005]oo`<000=oo`03001oogoo00Eoo`80
00Ioo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo
03Aoo`03G_Moogoo02Eoo`03001oogoo00]oo`03G_Moogoo00Aoo`<004Uoo`00JGoo00<007ooOol0
1Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0
=7oo00=NmgooOol097oo00<007ooOol037oo00=NmgooOol01Woo00<007ooOol0Agoo001YOol00`00
Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekg
Oomoo`0dOol00ekgOomoo`0SOol00`00Oomoo`0=Ool00ekgOomoo`06Ool00`00Oomoo`17Ool006Uo
o`8000Ioo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Mo
ogoo03Aoo`03G_Moogoo029oo`03001oogoo00ioo`03G_Moogoo00Aoo`<004Uoo`00JGoo00<007oo
Ool01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=Nmgoo
Ool0=7oo00=NmgooOol08Goo00<007ooOol03goo00=NmgooOol01Woo00<007ooOol0Agoo001YOol0
0`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol0
0ekgOomoo`0dOol00ekgOomoo`0POol00`00Oomoo`0@Ool00ekgOomoo`06Ool00`00Oomoo`17Ool0
06Uoo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo
03Aoo`03G_Moogoo03Aoo`03G_Moogoo01moo`03001oogoo015oo`03G_Moogoo00Ioo`03001oogoo
04Moo`00JGoo0P001Woo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0
=7oo00=NmgooOol0=7oo00=NmgooOol07Woo00<007ooOol04Woo00=NmgooOol017oo0`00BGoo001Y
Ool00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0d
Ool00ekgOomoo`0dOol00ekgOomoo`0MOol00`00Oomoo`0COol00ekgOomoo`06Ool00`00Oomoo`17
Ool006Uoo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Mo
ogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo01aoo`03001oogoo01Aoo`03G_Moogoo00Ioo`03001o
ogoo04Moo`00JGoo0P001Woo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=Nmgoo
Ool0=7oo00=NmgooOol0=7oo00=NmgooOol06goo00<007ooOol05Goo00=NmgooOol017oo0`00BGoo
001LOol30002Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol0
0ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0KOol00`00Oomoo`0EOol0
0ekgOomoo`06Ool00`00Oomoo`17Ool005eoo`06001oogoo001oo`001Woo00<007ooOol01Goo00=N
mgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0=7oo00=N
mgooOol06Woo00<007ooOol05Woo00=NmgooOol01Woo00<007ooOol0Agoo001FOol30002Ool40000
17oo001oo`001Woo0`00oekg=5kg00<005kgG_L07Ekg1000BGoo001KOol00`00Ool00002Ool00`00
Ool00006Ool00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekg
Oomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0GOol2000JOol00ekgOomoo`06Ool00`00Oomoo`17
Ool005aoo`80009oo`03001oo`0000Ioo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=o
o`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo01Ioo`03001oogoo01Yo
o`03G_Moogoo00Ioo`03001oogoo04Moo`00GGoo00D007ooOomoo`0000Moo`8000Ioo`03G_Moogoo
03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo
01Eoo`03001oogoo01]oo`03G_Moogoo00Aoo`<004Uoo`00JGoo00<007ooOol01Goo00=NmgooOol0
=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0
57oo00<007ooOol077oo00=NmgooOol01Woo00<007ooOol0Agoo001YOol00`00Oomoo`05Ool00ekg
Oomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekg
Oomoo`0DOol00`00Oomoo`0LOol00ekgOomoo`06Ool00`00Oomoo`17Ool006Uoo`8000Ioo`03G_Mo
ogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Mo
ogoo01=oo`03001oogoo01eoo`03G_Moogoo00Aoo`<004Uoo`00JGoo00<007ooOol01Goo00=Nmgoo
Ool0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0=7oo00=Nmgoo
Ool04Woo00<007ooOol07Woo00=NmgooOol01Woo00<007ooOol0Agoo001YOol00`00Oomoo`05Ool0
0ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0dOol0
0ekgOomoo`0AOol00`00Oomoo`0OOol00ekgOomoo`06Ool00`00Oomoo`17Ool006Uoo`8000Ioo`03
G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03
G_Moogoo011oo`03001oogoo021oo`03G_Moogoo00Aoo`<004Uoo`00JGoo00<007ooOol01Goo00=N
mgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0=7oo00=N
mgooOol03goo00<007ooOol08Goo00=NmgooOol01Woo00<007ooOol0Agoo001YOol00`00Oomoo`05
Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0d
Ool00ekgOomoo`0>Ool00`00Oomoo`0ROol00ekgOomoo`06Ool00`00Oomoo`17Ool006Uoo`8000Io
o`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo03Ao
o`03G_Moogoo00eoo`03001oogoo02=oo`03G_Moogoo00Aoo`<004Uoo`00Fgoo0P0017oo00<007oo
Ool01Goo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=Nmgoo
Ool0=7oo00=NmgooOol0=7oo00=NmgooOol037oo00<007ooOol097oo00=NmgooOol01Woo00<007oo
Ool0Agoo001MOol01P00Oomoo`00Ool000Ioo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo
03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo00aoo`03001oogoo
02Aoo`03G_Moogoo00Ioo`03001oogoo04Moo`00EWoo0`000goo00L007ooOomoo`00Ool00006Ool3
003oG_LVG_L00`00G_MNm`0[G_L40019Ool005eoo`06001oogoo001oo`001Woo00<007ooOol01Goo
00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0=7oo
00=NmgooOol02Woo00<007ooOol09Woo00=NmgooOol01Woo00<007ooOol0Agoo001KOol00`00Ool0
0002Ool00`00Ool00006Ool00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomo
o`0dOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`09Ool00`00Oomoo`0WOol00ekgOomo
o`06Ool00`00Oomoo`17Ool005aoo`03001oogoo009oo`03001oogoo00Eoo`8000Ioo`03G_Moogoo
03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo
00Qoo`03001oogoo02Qoo`03G_Moogoo00Aoo`<004Uoo`00JGoo00<007ooOol01Goo00=NmgooOol0
=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0
1goo00<007ooOol0:Goo00=NmgooOol01Woo00<007ooOol0Agoo001YOol00`00Oomoo`05Ool00ekg
Oomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekg
Oomoo`06Ool00`00Oomoo`0ZOol00ekgOomoo`06Ool00`00Oomoo`17Ool006Uoo`03001oogoo00Eo
o`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo03Ao
o`03G_Moogoo00Eoo`03001oogoo02]oo`03G_Moogoo00Ioo`03001oogoo04Moo`00JGoo0P001Woo
00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0=7oo
00=NmgooOol017oo00<007ooOol0;7oo00=NmgooOol017oo0`00BGoo001YOol00`00Oomoo`05Ool0
0ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0dOol0
0ekgOomoo`03Ool00`00Oomoo`0]Ool00ekgOomoo`06Ool00`00Oomoo`17Ool006Uoo`03001oogoo
00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo
03Aoo`03G_Moogoo009oo`03001oogoo02ioo`03G_Moogoo00Ioo`03001oogoo04Moo`00JGoo0P00
1Woo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0
=7oo00ENmgooOomoo`00035oo`03G_Moogoo00Aoo`<004Uoo`00?Woo1`0097oo00<007ooOol01Goo
00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0=7oo
00ANmgooOol0039oo`03G_Moogoo00Ioo`03001oogoo04Moo`00?Goo00H007ooOol007oo0002Ool0
0`00Oomoo`0QOol00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol0
0ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOol0000cOol00ekgOomoo`06Ool00`00Oomoo`17Ool0
03eoo`06001oogoo001oo`000Woo00<007ooOol08Goo0P001Woo00=NmgooOol0=7oo00=NmgooOol0
<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0=7oo00=Nm`00Ool0<goo00=NmgooOol0
17oo0`00BGoo000nOol3000017oo000000005Woo0`000goo00<007ooOol01Goo00<007ooOol01Goo
00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0=7oo
00<007ooOol0<goo00=NmgooOol01Woo00<007ooOol0Agoo0010Ool00`00Ool00002Ool00`00Oomo
o`0COol00`00Oomoo`02Ool00`00Ool00006Ool00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomo
o`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0cOol00`00G_Moo`0dOol00ekgOomo
o`06Ool00`00Oomoo`17Ool003moo`H0015oo`<000=oo`07001oogooOol007oo00001Woo0`00oekg
5ekg00<005kgG_L0>Ukg1000BGoo001LOol01`00Oomoogoo001oo`0000Ioo`03001oogoo00Eoo`03
G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo039oo`03
001ooekg03Eoo`03G_Moogoo00Ioo`03001oogoo04Moo`00Fgoo00<007oo00000Woo00<007oo0000
1Woo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0
=7oo00=NmgooOol0<Goo00@007ooOomNmcEoo`03G_Moogoo00Ioo`03001oogoo04Moo`00G7oo00<0
07ooOol00Woo00<007ooOol01Goo0P001Woo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0
=7oo00=NmgooOol0=7oo00=NmgooOol0<7oo00D007ooOomooekg03Eoo`03G_Moogoo00Aoo`<004Uo
o`00JGoo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=Nmgoo
Ool0=7oo00=NmgooOol0;goo00<007ooOol00Woo00=NmgooOol0<goo00=NmgooOol01Woo00<007oo
Ool0Agoo001YOol00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol0
0ekgOomoo`0dOol00ekgOomoo`0^Ool00`00Oomoo`03Ool00ekgOomoo`0cOol00ekgOomoo`06Ool0
0`00Oomoo`17Ool006Uoo`8000Ioo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03
G_Moogoo03Aoo`03G_Moogoo02eoo`03001oogoo00Aoo`03G_Moogoo03=oo`03G_Moogoo00Aoo`<0
04Uoo`00JGoo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=N
mgooOol0=7oo00=NmgooOol0;7oo00<007ooOol01Goo00=NmgooOol0<goo00=NmgooOol01Woo00<0
07ooOol0Agoo001YOol00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0d
Ool00ekgOomoo`0dOol00ekgOomoo`0[Ool00`00Oomoo`06Ool00ekgOomoo`0cOol00ekgOomoo`06
Ool00`00Oomoo`17Ool006Uoo`8000Ioo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Ao
o`03G_Moogoo03Aoo`03G_Moogoo02Yoo`03001oogoo00Moo`03G_Moogoo03=oo`03G_Moogoo00Ao
o`<004Uoo`00JGoo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo
00=NmgooOol0=7oo00=NmgooOol0:Goo00<007ooOol027oo00=NmgooOol0<goo00=NmgooOol01Woo
00<007ooOol0Agoo001YOol00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomo
o`0dOol00ekgOomoo`0dOol00ekgOomoo`0XOol00`00Oomoo`09Ool00ekgOomoo`0cOol00ekgOomo
o`06Ool00`00Oomoo`17Ool006Uoo`8000Ioo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo
03Aoo`03G_Moogoo03Aoo`03G_Moogoo02Moo`03001oogoo00Yoo`03G_Moogoo03=oo`03G_Moogoo
00Aoo`<004Uoo`00FWoo1@000Woo00<007ooOol01Goo00<007ooOol01Goo00=NmgooOol0=7oo00=N
mgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol09Woo00<007ooOol02goo00=N
mgooOol0<goo00=NmgooOol01Woo00<007ooOol0Agoo001LOol01`00Oomoogoo001oo`0000Ioo`03
001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03
G_Moogoo02Eoo`03001oogoo00aoo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo04Moo`00
EWoo0`000goo00L007ooOomoo`00Ool00006Ool3003oG_L8G_L00`00G_MNm`19G_L40019Ool005ao
o`07001oogooOol007oo00001Woo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=N
mgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol097oo00<007ooOol03Goo00=NmgooOol0<goo00=N
mgooOol01Woo00<007ooOol0Agoo001LOol01`00Oomoogoo001oo`0000Ioo`03001oogoo00Eoo`03
G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo02=oo`03
001oogoo00ioo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo04Moo`00Fgoo0P0017oo00<0
07ooOol01Goo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=N
mgooOol0=7oo00=NmgooOol08Woo00<007ooOol03goo00=NmgooOol0<goo00=NmgooOol01Woo00<0
07ooOol0Agoo001YOol20006Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekg
Oomoo`0dOol00ekgOomoo`0QOol00`00Oomoo`0@Ool00ekgOomoo`0cOol00ekgOomoo`04Ool30019
Ool006Uoo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Mo
ogoo03Aoo`03G_Moogoo021oo`03001oogoo015oo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001o
ogoo04Moo`00JGoo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo
00=NmgooOol0=7oo00=NmgooOol07goo00<007ooOol04Woo00=NmgooOol0<goo00=NmgooOol01Woo
00<007ooOol0Agoo001YOol20006Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol0
0ekgOomoo`0dOol00ekgOomoo`0NOol00`00Oomoo`0COol00ekgOomoo`0cOol00ekgOomoo`04Ool3
0019Ool006Uoo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03
G_Moogoo03Aoo`03G_Moogoo01eoo`03001oogoo01Aoo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03
001oogoo04Moo`00JGoo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0
=7oo00=NmgooOol0=7oo00=NmgooOol077oo00<007ooOol05Goo00=NmgooOol0<goo00=NmgooOol0
1Woo00<007ooOol0Agoo001YOol20006Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0d
Ool00ekgOomoo`0dOol00ekgOomoo`0KOol00`00Oomoo`0FOol00ekgOomoo`0cOol00ekgOomoo`04
Ool30019Ool006Uoo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Ao
o`03G_Moogoo03Aoo`03G_Moogoo01]oo`03001oogoo01Ioo`03G_Moogoo03=oo`03G_Moogoo00Io
o`03001oogoo04Moo`00JGoo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=Nmgoo
Ool0=7oo00=NmgooOol0=7oo00=NmgooOol06Woo00<007ooOol05goo00=NmgooOol0<goo00=Nmgoo
Ool01Woo00<007ooOol0Agoo001YOol20006Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomo
o`0dOol00ekgOomoo`0dOol00ekgOomoo`0IOol00`00Oomoo`0HOol00ekgOomoo`0cOol00ekgOomo
o`04Ool30019Ool0065oo`03001oogoo00Eoo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo
03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo01Qoo`03001oogoo01Uoo`03G_Moogoo
03=oo`03G_Moogoo00Ioo`03001oogoo04Moo`00H7oo00<007oo00001Woo00<007ooOol01Goo00=N
mgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol05goo00<0
07ooOol06Woo00=NmgooOol0<goo00=NmgooOol01Woo00<007ooOol0Agoo001POol00`00Ool00006
Ool3003iG_L00`00G_MNm`1GG_L40019Ool0061oo`03001oo`0000Ioo`03001oogoo00Eoo`03G_Mo
ogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo01Eoo`03001o
ogoo01aoo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo04Moo`00H7oo00<007oo00001Woo
00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo
00=NmgooOol04goo0P007goo00=NmgooOol0<goo00=NmgooOol01Woo00<007ooOol0Agoo001QOol0
0`00Oomoo`05Ool20006Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomo
o`0dOol00ekgOomoo`0BOol00`00Oomoo`0OOol00ekgOomoo`0cOol00ekgOomoo`04Ool30019Ool0
06Uoo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo
03Aoo`03G_Moogoo015oo`03001oogoo021oo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo
04Moo`00JGoo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=N
mgooOol0=7oo00=NmgooOol047oo00<007ooOol08Goo00=NmgooOol0<goo00=NmgooOol01Woo00<0
07ooOol0Agoo001YOol20006Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekg
Oomoo`0dOol00ekgOomoo`0>Ool2000TOol00ekgOomoo`0cOol00ekgOomoo`04Ool30019Ool006Uo
o`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Ao
o`03G_Moogoo00eoo`03001oogoo02Aoo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo04Mo
o`00JGoo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=Nmgoo
Ool0=7oo00=NmgooOol037oo00<007ooOol09Goo00=NmgooOol0<goo00=NmgooOol01Woo00<007oo
Ool0Agoo001YOol20006Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomo
o`0dOol00ekgOomoo`0:Ool2000XOol00ekgOomoo`0cOol00ekgOomoo`04Ool30019Ool006Uoo`03
001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03
G_Moogoo00Uoo`03001oogoo02Qoo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo04Moo`00
JGoo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0
=7oo00=NmgooOol027oo00<007ooOol0:Goo00=NmgooOol0<goo00=NmgooOol01Woo00<007ooOol0
Agoo001YOol20006Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0d
Ool00ekgOomoo`07Ool00`00Oomoo`0ZOol00ekgOomoo`0cOol00ekgOomoo`04Ool30019Ool006Uo
o`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Ao
o`03G_Moogoo00Eoo`8002eoo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo04Moo`00FWoo
1@000Woo00<007ooOol01Goo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=Nmgoo
Ool0=7oo00=NmgooOol0=7oo00=NmgooOol017oo00<007ooOol0;Goo00=NmgooOol0<goo00=Nmgoo
Ool01Woo00<007ooOol0Agoo001LOol01`00Oomoogoo001oo`0000Ioo`03001oogoo00Eoo`03G_Mo
ogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo009oo`80031o
o`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo04Moo`00G7oo00L007ooOomoo`00Ool00006
Ool3003RG_L3001^G_L40019Ool005aoo`07001oogooOol007oo00001Woo00<007ooOol01Goo00=N
mgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo0P00=Goo00=NmgooOol0
<goo00=NmgooOol01Woo00<007ooOol0Agoo001LOol01`00Oomoogoo001oo`0000Ioo`03001oogoo
00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo035oo`<00003G_Mo
ogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo04Moo`00Fgoo0P0017oo00<007oo
Ool01Goo0P001WooZ`00:Goo10000goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol017oo
0`00BGoo001YOol00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol0
0ekgOomoo`04OolY0007Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`06Ool00`00Oomo
o`17Ool006Uoo`03001oogoo00Eoo`03001oogoo03Aoo`03G_Moogoo019oo`03001oogoo01ioo`03
001oogoo03Aoo`03G_Moogoo01=oo`03001oogoo01ioo`03001oogoo03Aoo`03G_Moogoo019oo`03
001oogoo01ioo`03001oogoo00Ioo`03001oogoo04Moo`00JGoo0P001Woo00<007ooOol07Woo00<0
07ooOol047oo00@007ooOomNm`Yoo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Aoo`03
001oogoo00Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo01ioo`03001oogoo015oo`03
001ooekg00Yoo`03001oogoo00Qoo`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00=oo`03
001oogoo00=oo`03001oogoo009oo`03001oogoo01ioo`03001oogoo011oo`04001oogooG_L:Ool0
0`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool00`00Oomoo`04Ool30019Ool006Uoool005/004Uoo`00ogooogoo3Woo003oOooo
Ool>Ool00?mooomoo`ioo`00ogooogoo3Woo003oOoooOol>Ool00?mooomoo`ioo`00ogooogoo3Woo
003oOoooOol>Ool006Moo`03001oogoo009oo`03001oogoo009oo`03001oogoo00D003Yoo`03001o
ogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo019oo`03001oogoo009oo`03001o
ogoo00D0041oo`03001oogoo009oo`03001oogoo009oo`03001oogoo01Qoo`D004Uoo`03001oogoo
01Uoo`D0009oo`03001oogoo04moo`00IWoo00<007oo00001goo00<007oo00000goo00<007ooOol0
>Goo00<007oo00001goo00<007oo00000Woo00<007oo00004Woo00<007oo000027oo00<007ooOol0
?goo00<007oo00001goo00<007oo00006goo00<007ooOol0B7oo00<007oo000077oo00L007ooOomo
o`00Ool0001@Ool006Ioo`03001oo`0000Moo`03001oo`0000=oo`03001oogoo03Uoo`03001oo`00
00Moo`03001oo`0000Aoo`03001oogoo011oo`03001oo`0000Qoo`03001oogoo03moo`03001oo`00
00Uoo`03001oogoo01Uoo`03001oogoo04Yoo`03001oogoo01Yoo`07001oogooOol007oo0000D7oo
001VOol00`00Ool00007Ool00`00Ool00003Ool00`00Oomoo`0iOol00`00Ool00007Ool00`00Ool0
0002Ool2000COol00`00Ool00008Ool00`00Oomoo`0oOol00`00Ool00007Ool2000LOol00`00Oomo
o`18Ool2000MOol01`00Oomoogoo001oo`00051oo`00IWoo00<007oo00001goo00<007oo00000goo
00<007ooOol0>Goo00<007oo00001goo00<007oo00000Woo00<007ooOol04Woo00<007oo000027oo
00<007ooOol0?goo00<007oo00001goo00<007ooOol06goo00<007ooOol0B7oo00<007ooOol077oo
00L007ooOomoo`00Ool0001@Ool006Moo`03001oogoo00Moo`04001oogooOol2000lOol00`00Oomo
o`07Ool01000Oomoogoo0`004goo00<007ooOol01Woo0P00@Woo00<007ooOol01Woo0`006Woo0P00
BWoo0`006goo0P0017oo00<007ooOol0Cgoo003oOoooOol>Ool00?mooomoo`ioo`00ogooogoo3Woo
003oOoooOol>Ool00?mooomoo`ioo`00ogooogoo3Woo003nOol01`00Ool007oo001oo`0000=oo`80
0003Ool000000080009oo`04001oogoo0002Ool01000Oomoo`000goo10000Woo10000Woo1000gWoo
003nOol3000017oo001oogoo10000Woo00P007ooOomoo`00Ool007oo0P000Woo00@007ooOol000=o
o`04001oogoo0002Ool01000Oomoo`000Woo00<007ooOol0ggoo003nOol200000goo00000002Ool0
1@00Oomoo`00Ool00P0000Eoo`00000007oo00@0009oo`04001oogoo0003Ool01000Oomoo`000Woo
00@007ooOol0009oo`03001oogoo0=moo`00oWoo0P0000=oo`0000000Woo0`000Woo0P001Goo0P00
00Eoo`00Oomoo`00009oo`05001oogooOol00002Ool01000Oomoo`000Woo00@007ooOol00>5oo`00
oWoo0P0000=oo`0000000goo0P000goo00<007ooOol00P0000Eoo`00Oomoo`00009oo`04001oogoo
0003Ool01000Oomoo`000Woo00@007ooOol0009oo`03001oogoo0=moo`00oWoo00<007ooOol00P00
0goo0P0017oo0`000Woo00@007ooOol0009oo`H00005Ool007ooOol00002Ool30003Ool4003NOol0
0?mooomoo`ioo`00ogooogoo3Woo0000\
\>"],
  ImageRangeCache->{{{0, 523}, {173.438, 0}} -> {-3.03439, -78.3563, \
0.00913039, 0.64277}},
  CellTags->{"Bode plot", "i:9"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .33333 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.65873 0.31746 0.326544 0.00108242 [
[.02381 -0.0125 -14 -12.875 ]
[.02381 -0.0125 14 0 ]
[.2457 -0.0125 -14 -12.875 ]
[.2457 -0.0125 14 0 ]
[.34127 -0.0125 -11 -12.875 ]
[.34127 -0.0125 11 0 ]
[.56317 -0.0125 -11 -12.875 ]
[.56317 -0.0125 11 0 ]
[.65873 -0.0125 -5 -12.875 ]
[.65873 -0.0125 5 0 ]
[.88063 -0.0125 -5 -12.875 ]
[.88063 -0.0125 5 0 ]
[.97619 -0.0125 -8 -12.875 ]
[.97619 -0.0125 8 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -23 -25.75 ]
[.5 -0.0125 23 -12.875 ]
[-0.0125 .00182 -24 -4.5 ]
[-0.0125 .00182 0 4.5 ]
[-0.0125 .05594 -24 -4.5 ]
[-0.0125 .05594 0 4.5 ]
[-0.0125 .11006 -24 -4.5 ]
[-0.0125 .11006 0 4.5 ]
[-0.0125 .16418 -24 -4.5 ]
[-0.0125 .16418 0 4.5 ]
[-0.0125 .2183 -24 -4.5 ]
[-0.0125 .2183 0 4.5 ]
[-0.0125 .27242 -18 -4.5 ]
[-0.0125 .27242 0 4.5 ]
[-0.0125 .32654 -6 -4.5 ]
[-0.0125 .32654 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .16667 -52 -6.4375 ]
[-0.01875 .16667 -24 6.4375 ]
[.02381 .34583 -14 0 ]
[.02381 .34583 14 12.875 ]
[.2457 .34583 -14 0 ]
[.2457 .34583 14 12.875 ]
[.34127 .34583 -11 0 ]
[.34127 .34583 11 12.875 ]
[.56317 .34583 -11 0 ]
[.56317 .34583 11 12.875 ]
[.65873 .34583 -5 0 ]
[.65873 .34583 5 12.875 ]
[.88063 .34583 -5 0 ]
[.88063 .34583 5 12.875 ]
[.97619 .34583 -8 0 ]
[.97619 .34583 8 12.875 ]
[ 0 .33333 .125 0 ]
[.5 .34583 -15.4063 12.875 ]
[.5 .34583 15.4063 24.0625 ]
[ 1 0 .125 0 ]
[1.0125 .16667 0 -6.4375 ]
[1.0125 .16667 10 6.4375 ]
[ 0 -0.0005 0 0 ]
[ 1 .33383 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
.75 g
.25 Mabswid
.02381 0 m
.02381 .33333 L
s
.18254 0 m
.18254 .33333 L
s
.34127 0 m
.34127 .33333 L
s
.5 0 m
.5 .33333 L
s
.65873 0 m
.65873 .33333 L
s
.81746 0 m
.81746 .33333 L
s
.97619 0 m
.97619 .33333 L
s
0 .00182 m
1 .00182 L
s
0 .05594 m
1 .05594 L
s
0 .11006 m
1 .11006 L
s
0 .16418 m
1 .16418 L
s
0 .2183 m
1 .2183 L
s
0 .27242 m
1 .27242 L
s
0 .32654 m
1 .32654 L
s
0 g
.02381 0 m
.02381 .00625 L
s
gsave
.02381 -0.0125 -75 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.01) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.2457 0 m
.2457 .00625 L
s
gsave
.2457 -0.0125 -75 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.05) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.34127 0 m
.34127 .00625 L
s
gsave
.34127 -0.0125 -72 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.1) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.56317 0 m
.56317 .00625 L
s
gsave
.56317 -0.0125 -72 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.65873 0 m
.65873 .00625 L
s
gsave
.65873 -0.0125 -66 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.88063 0 m
.88063 .00625 L
s
gsave
.88063 -0.0125 -66 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.97619 0 m
.97619 .00625 L
s
gsave
.97619 -0.0125 -69 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
75.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.001 w
.11937 0 m
.11937 .00375 L
s
.17528 0 m
.17528 .00375 L
s
.21494 0 m
.21494 .00375 L
s
.27084 0 m
.27084 .00375 L
s
.29209 0 m
.29209 .00375 L
s
.3105 0 m
.3105 .00375 L
s
.32674 0 m
.32674 .00375 L
s
.43683 0 m
.43683 .00375 L
s
.49274 0 m
.49274 .00375 L
s
.5324 0 m
.5324 .00375 L
s
.5883 0 m
.5883 .00375 L
s
.60955 0 m
.60955 .00375 L
s
.62797 0 m
.62797 .00375 L
s
.6442 0 m
.6442 .00375 L
s
.7543 0 m
.7543 .00375 L
s
.8102 0 m
.8102 .00375 L
s
.84986 0 m
.84986 .00375 L
s
.90576 0 m
.90576 .00375 L
s
.92702 0 m
.92702 .00375 L
s
.94543 0 m
.94543 .00375 L
s
.96166 0 m
.96166 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -84 -29.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(rad) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
81.000000 13.000000 moveto
(\\220) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(sec) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
0 .00182 m
.00625 .00182 L
s
[(-300)] -0.0125 .00182 1 0 Mshowa
0 .05594 m
.00625 .05594 L
s
[(-250)] -0.0125 .05594 1 0 Mshowa
0 .11006 m
.00625 .11006 L
s
[(-200)] -0.0125 .11006 1 0 Mshowa
0 .16418 m
.00625 .16418 L
s
[(-150)] -0.0125 .16418 1 0 Mshowa
0 .2183 m
.00625 .2183 L
s
[(-100)] -0.0125 .2183 1 0 Mshowa
0 .27242 m
.00625 .27242 L
s
[(-50)] -0.0125 .27242 1 0 Mshowa
0 .32654 m
.00625 .32654 L
s
[(0)] -0.0125 .32654 1 0 Mshowa
.125 Mabswid
0 .01264 m
.00375 .01264 L
s
0 .02347 m
.00375 .02347 L
s
0 .03429 m
.00375 .03429 L
s
0 .04511 m
.00375 .04511 L
s
0 .06676 m
.00375 .06676 L
s
0 .07759 m
.00375 .07759 L
s
0 .08841 m
.00375 .08841 L
s
0 .09924 m
.00375 .09924 L
s
0 .12088 m
.00375 .12088 L
s
0 .13171 m
.00375 .13171 L
s
0 .14253 m
.00375 .14253 L
s
0 .15336 m
.00375 .15336 L
s
0 .17501 m
.00375 .17501 L
s
0 .18583 m
.00375 .18583 L
s
0 .19665 m
.00375 .19665 L
s
0 .20748 m
.00375 .20748 L
s
0 .22913 m
.00375 .22913 L
s
0 .23995 m
.00375 .23995 L
s
0 .25077 m
.00375 .25077 L
s
0 .2616 m
.00375 .2616 L
s
0 .28325 m
.00375 .28325 L
s
0 .29407 m
.00375 .29407 L
s
0 .3049 m
.00375 .3049 L
s
0 .31572 m
.00375 .31572 L
s
.25 Mabswid
0 0 m
0 .33333 L
s
gsave
-0.01875 .16667 -113 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(deg) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.02381 .32708 m
.02381 .33333 L
s
gsave
.02381 .34583 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.01) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.2457 .32708 m
.2457 .33333 L
s
gsave
.2457 .34583 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.05) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.34127 .32708 m
.34127 .33333 L
s
gsave
.34127 .34583 -72 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.1) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.56317 .32708 m
.56317 .33333 L
s
gsave
.56317 .34583 -72 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.65873 .32708 m
.65873 .33333 L
s
gsave
.65873 .34583 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.88063 .32708 m
.88063 .33333 L
s
gsave
.88063 .34583 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.97619 .32708 m
.97619 .33333 L
s
gsave
.97619 .34583 -69 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
75.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.001 w
.11937 .32958 m
.11937 .33333 L
s
.17528 .32958 m
.17528 .33333 L
s
.21494 .32958 m
.21494 .33333 L
s
.27084 .32958 m
.27084 .33333 L
s
.29209 .32958 m
.29209 .33333 L
s
.3105 .32958 m
.3105 .33333 L
s
.32674 .32958 m
.32674 .33333 L
s
.43683 .32958 m
.43683 .33333 L
s
.49274 .32958 m
.49274 .33333 L
s
.5324 .32958 m
.5324 .33333 L
s
.5883 .32958 m
.5883 .33333 L
s
.60955 .32958 m
.60955 .33333 L
s
.62797 .32958 m
.62797 .33333 L
s
.6442 .32958 m
.6442 .33333 L
s
.7543 .32958 m
.7543 .33333 L
s
.8102 .32958 m
.8102 .33333 L
s
.84986 .32958 m
.84986 .33333 L
s
.90576 .32958 m
.90576 .33333 L
s
.92702 .32958 m
.92702 .33333 L
s
.94543 .32958 m
.94543 .33333 L
s
.96166 .32958 m
.96166 .33333 L
s
.25 Mabswid
0 .33333 m
1 .33333 L
s
gsave
.5 .34583 -76.4063 8.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 15.187500 moveto
 460.000000 15.187500 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 15.187500 lineto
closepath
clip newpath
63.000000 12.500000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 12.500000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(PHASE) show
89.812500 12.500000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica-Bold
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica-Bold
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica-Bold
grestore
.99375 .00182 m
1 .00182 L
s
.99375 .05594 m
1 .05594 L
s
.99375 .11006 m
1 .11006 L
s
.99375 .16418 m
1 .16418 L
s
.99375 .2183 m
1 .2183 L
s
.99375 .27242 m
1 .27242 L
s
.99375 .32654 m
1 .32654 L
s
.125 Mabswid
.99625 .01264 m
1 .01264 L
s
.99625 .02347 m
1 .02347 L
s
.99625 .03429 m
1 .03429 L
s
.99625 .04511 m
1 .04511 L
s
.99625 .06676 m
1 .06676 L
s
.99625 .07759 m
1 .07759 L
s
.99625 .08841 m
1 .08841 L
s
.99625 .09924 m
1 .09924 L
s
.99625 .12088 m
1 .12088 L
s
.99625 .13171 m
1 .13171 L
s
.99625 .14253 m
1 .14253 L
s
.99625 .15336 m
1 .15336 L
s
.99625 .17501 m
1 .17501 L
s
.99625 .18583 m
1 .18583 L
s
.99625 .19665 m
1 .19665 L
s
.99625 .20748 m
1 .20748 L
s
.99625 .22913 m
1 .22913 L
s
.99625 .23995 m
1 .23995 L
s
.99625 .25077 m
1 .25077 L
s
.99625 .2616 m
1 .2616 L
s
.99625 .28325 m
1 .28325 L
s
.99625 .29407 m
1 .29407 L
s
.99625 .3049 m
1 .3049 L
s
.99625 .31572 m
1 .31572 L
s
.25 Mabswid
1 0 m
1 .33333 L
s
gsave
1.0125 .16667 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
69.000000 13.000000 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.5 Mabswid
.02381 .3254 m
.35428 .31387 L
.44343 .30199 L
.49712 .28945 L
.53567 .2759 L
.56576 .26103 L
.59045 .24458 L
.61137 .22652 L
.62954 .20716 L
.64559 .18728 L
.65997 .16789 L
.67298 .14986 L
.68487 .13365 L
.69582 .11937 L
.70596 .10688 L
.71541 .09601 L
.72425 .08652 L
.73256 .07824 L
.7404 .07098 L
.74781 .0646 L
.75485 .05898 L
.76154 .054 L
.76792 .04959 L
.77403 .04566 L
.77987 .04216 L
.78547 .03902 L
.79086 .0362 L
.79604 .03366 L
.80104 .03137 L
.80586 .02929 L
.81052 .02741 L
.81502 .0257 L
.81939 .02415 L
.82362 .02273 L
.82772 .02143 L
.83171 .02025 L
.83558 .01916 L
.83935 .01817 L
.84301 .01726 L
.84659 .01642 L
.85007 .01565 L
.85346 .01494 L
.85678 .01429 L
.86001 .01369 L
.86318 .01314 L
.86627 .01263 L
.86929 .01216 L
.87225 .01174 L
.87515 .01134 L
.87798 .01098 L
Mistroke
.88076 .01065 L
.88349 .01034 L
.88616 .01006 L
.88878 .00981 L
.89135 .00958 L
.89388 .00937 L
.89636 .00917 L
.89879 .009 L
.90119 .00884 L
.90354 .0087 L
.90585 .00857 L
.90813 .00846 L
.91037 .00836 L
.91257 .00828 L
.91474 .0082 L
.91687 .00814 L
.91897 .00808 L
.92104 .00804 L
.92308 .008 L
.92509 .00797 L
.92707 .00795 L
.92903 .00794 L
.93095 .00794 L
.93285 .00794 L
.93473 .00795 L
.93657 .00796 L
.9384 .00798 L
.9402 .008 L
.94197 .00803 L
.94373 .00807 L
.94546 .0081 L
.94717 .00815 L
.94886 .00819 L
.95053 .00824 L
.95218 .0083 L
.95381 .00835 L
.95542 .00841 L
.95701 .00847 L
.95858 .00854 L
.96014 .0086 L
.96168 .00867 L
.9632 .00875 L
.96471 .00882 L
.9662 .00889 L
.96767 .00897 L
.96913 .00905 L
.97057 .00913 L
.972 .00921 L
.97341 .0093 L
.97481 .00938 L
Mistroke
.97619 .00947 L
Mfstroke
0 0 m
1 0 L
1 .33333 L
0 .33333 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[109]:=",
  ImageSize->{524, 174.438},
  ImageMargins->{{0, 0}, {0, 1}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008<0000[Q000`40O003h00Oogooogoo3Woo003o
OoooOol>Ool00?mooomoo`ioo`00ogooogoo3Woo003oOolJOol00`00Oomoo`3`Ool00?moo`Qoo`<0
009oo`@0009oo`<000Eoo`03001oogoo009oo`8000Aoo`80009oo`<00>1oo`00ogoo2Goo00@007oo
Oomoo`<0009oo`04001oogoo0005Ool00`00Oomoo`04Ool01000Oomoo`0017oo00<007ooOol0h7oo
003oOol9Ool00`00Oomoo`03Ool01000Oomoo`000Woo00<007ooOol00goo00<007ooOol00goo00@0
07ooOomoo`<0009oo`03001oogoo0>1oo`00ogoo27oo10000Woo0P000goo0`001Woo00<007ooOol0
0Woo0P000Woo0`000Woo0`00h7oo003oOolEOol00`00Oomoo`04Ool00`00Oomoo`3^Ool00?mooaAo
o`8000Moo`03001oogoo0>eoo`00ogooogoo3Woo003oOoooOol>Ool00?mooomoo`ioo`00ogooogoo
3Woo003oOoooOol>Ool00?mooomoo`ioo`00ogooogoo3Woo001]Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool00`00Oomoo`05000jOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`0BOol00`00Oomoo`02Ool00`00Oomoo`050010Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`0HOol50019Ool00`00Oomoo`0IOol50002Ool00`00Oomoo`19Ool006aoo`03001oo`00
00Moo`03001oo`0000=oo`03001oogoo03Uoo`03001oo`0000Moo`03001oo`00009oo`03001oo`00
019oo`03001oo`0000Qoo`03001oogoo03moo`03001oo`0000Moo`03001oo`0001]oo`03001oogoo
04Qoo`03001oo`0001aoo`07001oogooOol007oo0000BWoo001/Ool00`00Ool00007Ool00`00Ool0
0003Ool00`00Oomoo`0iOol00`00Ool00007Ool00`00Ool00004Ool00`00Oomoo`0@Ool00`00Ool0
0008Ool00`00Oomoo`0oOol00`00Ool00009Ool00`00Oomoo`0IOol00`00Oomoo`1:Ool00`00Oomo
o`0JOol01`00Oomoogoo001oo`0004Yoo`00K7oo00<007oo00001goo00<007oo00000goo00<007oo
Ool0>Goo00<007oo00001goo00<007oo00000Woo0P004goo00<007oo000027oo00<007ooOol0?goo
00<007oo00001goo0P0077oo00<007ooOol0B7oo0P007Goo00L007ooOomoo`00Ool0001:Ool006ao
o`03001oo`0000Moo`03001oo`0000=oo`03001oogoo03Uoo`03001oo`0000Moo`03001oo`00009o
o`03001oogoo019oo`03001oo`0000Qoo`03001oogoo03moo`03001oo`0000Moo`03001oogoo01]o
o`03001oogoo04Qoo`03001oogoo01aoo`07001oogooOol007oo0000BWoo001]Ool00`00Oomoo`07
Ool01000Oomoogoo0P00?7oo00<007ooOol01goo00@007ooOomoo`<001=oo`03001oogoo00Ioo`80
049oo`03001oogoo00Ioo`<001Yoo`8004Yoo`<001]oo`8000Aoo`03001oogoo04Uoo`00ogooogoo
3Woo003oOoooOol>Ool00?mooomoo`ioo`00ogooogoo3Woo003oOoooOol>Ool005aoo`8000Aoo`03
001oogoo009oo`03001oogoo0?mooj=oo`00GWoo00H007ooOol007oo0002Ool00`00Ool00006Oooo
001K0013Ool005Moo`<000=oo`07001oogooOol007oo00000Woo00<007oo00001Woo0`001Ekg00<0
05kgG_L07Ukg00<005kgG_L045kg00<005kgG_L02ekg00<005kgG_L01ekg00<005kgG_L01Ukg00<0
05kgG_L015kg00<005kgG_L015kg00<005kgG_L00Ukg00<005kgG_L00Ukg00<005kgG_L07Ukg00<0
05kgG_L04Ekg00<005kgG_L02Ukg00<005kgG_L025kg00<005kgG_L01Ukg00<005kgG_L015kg00<0
05kgG_L00ekg00<005kgG_L00ekg00<005kgG_L00Ukg00<005kgG_L07Ukg00<005kgG_L045kg00<0
05kgG_L02ekg00<005kgG_L01ekg00<005kgG_L01Ukg00<005kgG_L015kg00<005kgG_L015kg00<0
05kgG_L00Ukg00<005kgG_L00Ukg00<005kgG_L00ekg1000@goo001NOol01P00Oomoo`00Ool0009o
o`03001oo`0000Ioo`03001oogoo00Eoo`03001oogoo03Aoo`03G_Moogoo019oo`03001oogoo01io
o`03001oogoo03Aoo`03G_Moogoo01=oo`03001oogoo01ioo`03001oogoo03Aoo`03G_Moogoo019o
o`03001oogoo01ioo`03001oogoo00Ioo`03001oogoo045oo`00G7oo00<007oo00000Woo00<007oo
00000Woo00<007oo00001Woo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=Nmgoo
Ool0=7oo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol05Woo7P0027oo00<007ooOol0@Goo
001MOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`05Ool20006Ool00ekgOomoo`0dOol0
0ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0=Ool9
000MOol00ekgOomoo`04Ool30013Ool006moo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo
03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo00Uoo`@002Ioo`03
G_Moogoo00Ioo`03001oogoo045oo`00Kgoo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0
<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol017oo1@00:Woo00=N
mgooOol01Woo00<007ooOol0@Goo001_Ool00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0c
Ool00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`02Ool2000_Ool00ekg
Oomoo`06Ool00`00Oomoo`11Ool006moo`8000Ioo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Mo
ogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`D0035oo`03G_Moogoo00Aoo`<004=oo`00Kgoo
00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo
00=NmgooOol0<goo00<005kgOol0=7oo00=NmgooOol01Woo00<007ooOol0@Goo001_Ool00`00Oomo
o`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomo
o`0`Ool300000gooG_Moo`0dOol00ekgOomoo`06Ool00`00Oomoo`11Ool006moo`03001oogoo00Eo
o`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo02io
o`8000Aoo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo045oo`00Kgoo0P001Woo00=Nmgoo
Ool0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0;7oo0P001Woo
00=NmgooOol0<goo00=NmgooOol017oo0`00@goo001_Ool00`00Oomoo`05Ool00ekgOomoo`0dOol0
0ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0ZOol20008Ool00ekgOomo
o`0cOol00ekgOomoo`06Ool00`00Oomoo`11Ool006moo`03001oogoo00Eoo`03G_Moogoo03Aoo`03
G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo02Uoo`03001oogoo00Qoo`03
G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo045oo`00Kgoo00<007ooOol01Goo00=NmgooOol0
=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol09goo0P002goo00=N
mgooOol0<goo00=NmgooOol01Woo00<007ooOol0@Goo001_Ool20006Ool00ekgOomoo`0dOol00ekg
Oomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0UOol2000=Ool00ekgOomoo`0c
Ool00ekgOomoo`04Ool30013Ool005aoo`<000=oo`03001oogoo009oo`03001oogoo00Eoo`03001o
ogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Mo
ogoo02=oo`8000moo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo045oo`00G7oo00<007oo
Ool00Woo00<007oo00000Woo00<007oo00001Woo00<007ooOol01Goo00=NmgooOol0=7oo00=Nmgoo
Ool0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol08Goo0P004Goo00=NmgooOol0<goo
00=NmgooOol01Woo00<007ooOol0@Goo001GOol30003Ool00`00Oomoo`03Ool01P00Oomoo`00Ool0
00Ioo`<00?mNm`ANm`03001Nmekg04eNm`@004=oo`00GGoo00@007ooOomoo`8000=oo`03001oo`00
00Ioo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo
03Aoo`03G_Moogoo01ioo`8001Aoo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo045oo`00
G7oo00<007oo00000Woo00<007ooOol00Woo00<007oo00001Woo00<007ooOol01Goo00=NmgooOol0
=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol07Goo00<007ooOol0
57oo00=NmgooOol0<goo00=NmgooOol01Woo00<007ooOol0@Goo001MOol01000Oomoogoo0`000goo
00<007ooOol01Goo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo
00=NmgooOol0=7oo00=NmgooOol077oo00<007ooOol05Goo00=NmgooOol0<goo00=NmgooOol01Woo
00<007ooOol0@Goo001_Ool20006Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol0
0ekgOomoo`0dOol00ekgOomoo`0KOol00`00Oomoo`0FOol00ekgOomoo`0cOol00ekgOomoo`04Ool3
0013Ool006moo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03
G_Moogoo03Aoo`03G_Moogoo01Yoo`03001oogoo01Moo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03
001oogoo045oo`00Kgoo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0
=7oo00=NmgooOol0=7oo00=NmgooOol06Goo00<007ooOol067oo00=NmgooOol0<goo00=NmgooOol0
1Woo00<007ooOol0@Goo001_Ool00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekg
Oomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0GOol2000KOol00ekgOomoo`0cOol00ekgOomoo`06
Ool00`00Oomoo`11Ool006moo`8000Ioo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Ao
o`03G_Moogoo03Aoo`03G_Moogoo01Ioo`03001oogoo01]oo`03G_Moogoo03=oo`03G_Moogoo00Ao
o`<004=oo`00Kgoo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo
00=NmgooOol0=7oo00=NmgooOol05Goo00<007ooOol077oo00=NmgooOol0<goo00=NmgooOol01Woo
00<007ooOol0@Goo001_Ool00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomo
o`0dOol00ekgOomoo`0dOol00ekgOomoo`0DOol00`00Oomoo`0MOol00ekgOomoo`0cOol00ekgOomo
o`06Ool00`00Oomoo`11Ool006moo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03
G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo01=oo`03001oogoo01ioo`03G_Moogoo03=oo`03
G_Moogoo00Ioo`03001oogoo045oo`00Kgoo0P001Woo00=NmgooOol0=7oo00=NmgooOol0<goo00=N
mgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol04Woo00<007ooOol07goo00=NmgooOol0<goo00=N
mgooOol017oo0`00@goo001_Ool00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekg
Oomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0AOol00`00Oomoo`0POol00ekgOomoo`0cOol00ekg
Oomoo`06Ool00`00Oomoo`11Ool006moo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=o
o`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo011oo`03001oogoo025oo`03G_Moogoo03=o
o`03G_Moogoo00Ioo`03001oogoo045oo`00Kgoo0P001Woo00=NmgooOol0=7oo00=NmgooOol0<goo
00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol03goo00<007ooOol08Woo00=NmgooOol0<goo
00=NmgooOol017oo0`00@goo001_Ool00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol0
0ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0>Ool00`00Oomoo`0SOol00ekgOomoo`0cOol0
0ekgOomoo`06Ool00`00Oomoo`11Ool005aoo`<000=oo`03001oogoo009oo`03001oogoo00Eoo`03
001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03
G_Moogoo00ioo`03001oogoo02=oo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo045oo`00
G7oo00<007ooOol00Woo00<007oo00000Woo00<007oo00001Woo00<007ooOol01Goo00=NmgooOol0
=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol03Goo00<007ooOol0
97oo00=NmgooOol0<goo00=NmgooOol01Woo00<007ooOol0@Goo001GOol30003Ool01`00Oomoogoo
001oo`00009oo`03001oo`0000Ioo`<00>mNm`03001Nmekg065Nm`@004=oo`00GGoo00L007ooOomo
o`00Ool00002Ool00`00Ool00006Ool00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol0
0ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0;Ool00`00Oomoo`0VOol00ekgOomoo`0cOol0
0ekgOomoo`06Ool00`00Oomoo`11Ool005aoo`03001oo`00009oo`03001oo`00009oo`03001oo`00
00Ioo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo
03Aoo`03G_Moogoo00]oo`03001oogoo02Ioo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo
045oo`00GGoo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol01Goo00<007ooOol01Goo00=N
mgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol02Woo00<0
07ooOol09goo00=NmgooOol0<goo00=NmgooOol01Woo00<007ooOol0@Goo001_Ool20006Ool00ekg
Oomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`09Ool00`00
Oomoo`0XOol00ekgOomoo`0cOol00ekgOomoo`04Ool30013Ool006moo`03001oogoo00Eoo`03G_Mo
ogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo00Qoo`03001o
ogoo02Uoo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo045oo`00Kgoo00<007ooOol01Goo
00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol027oo
00<007ooOol0:Goo00=NmgooOol0<goo00=NmgooOol01Woo00<007ooOol0@Goo001_Ool00`00Oomo
o`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomo
o`07Ool00`00Oomoo`0ZOol00ekgOomoo`0cOol00ekgOomoo`06Ool00`00Oomoo`11Ool006moo`80
00Ioo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo
00Ioo`03001oogoo02]oo`03G_Moogoo03=oo`03G_Moogoo00Aoo`<004=oo`00Kgoo00<007ooOol0
1Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0
1Goo00<007ooOol0;7oo00=NmgooOol0<goo00=NmgooOol01Woo00<007ooOol0@Goo001_Ool00`00
Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekg
Oomoo`05Ool00`00Oomoo`0/Ool00ekgOomoo`0cOol00ekgOomoo`06Ool00`00Oomoo`11Ool006mo
o`8000Ioo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Mo
ogoo00Aoo`03001oogoo02eoo`03G_Moogoo03=oo`03G_Moogoo00Aoo`<004=oo`00Kgoo00<007oo
Ool01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=Nmgoo
Ool00goo00<007ooOol0;Woo00=NmgooOol0<goo00=NmgooOol01Woo00<007ooOol0@Goo001_Ool0
0`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0dOol0
0ekgOomoo`03Ool00`00Oomoo`0^Ool00ekgOomoo`0cOol00ekgOomoo`06Ool00`00Oomoo`11Ool0
06moo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo
03Aoo`03G_Moogoo009oo`03001oogoo02moo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo
045oo`00Kgoo0P001Woo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0
=7oo00ENmgooOomoo`00039oo`03G_Moogoo03=oo`03G_Moogoo00Aoo`<004=oo`00@Woo0P00:goo
00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo
00ANmgooOol003=oo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo045oo`00A7oo00<007oo
Ool057oo1@000Woo00<007ooOol00Woo00<007ooOol01Goo00<007ooOol01Goo00=NmgooOol0=7oo
00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=Nmgoo0000=7oo00=NmgooOol0<goo
00=NmgooOol01Woo00<007ooOol0@Goo000hOol30002Ool20003Ool3000HOol01`00Oomoogoo001o
o`00009oo`03001oo`0000Ioo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Mo
ogoo03Aoo`03G_Moogoo03Aoo`03G_Moo`0003Aoo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001o
ogoo045oo`00=goo00H007ooOol007oo0004Ool01000Oomoo`004Woo0`000goo00<007ooOol00goo
00H007ooOol007oo0006Ool3003QG_L00`00G_MNm`1_G_L40013Ool003Moo`05001oogoo001oo`03
0002Ool01000Oomoo`0067oo00@007ooOomoo`8000=oo`03001oo`0000Ioo`03001oogoo00Eoo`03
G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03001oogoo03Aoo`03
G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo045oo`00>7oo0`0000Aoo`00000000=oo`<001Qo
o`05001oogooOol00004Ool00`00Ool00006Ool00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomo
o`0cOol00ekgOomoo`0dOol00ekgOomoo`0cOol00`00G_Moo`0eOol00ekgOomoo`0cOol00ekgOomo
o`06Ool00`00Oomoo`11Ool003Yoo`03001oogoo01moo`8000=oo`<000=oo`03001oogoo00Eoo`03
001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03
001Nmgoo03Eoo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo045oo`00>Goo0P00=7oo0P00
1Woo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0<Woo00<007ooG_L0
=Woo00=NmgooOol0<goo00=NmgooOol017oo0`00@goo001_Ool00`00Oomoo`05Ool00ekgOomoo`0d
Ool00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0aOol01000Oomooekg=Woo00=NmgooOol0
<goo00=NmgooOol01Woo00<007ooOol0@Goo001_Ool00`00Oomoo`05Ool00ekgOomoo`0dOol00ekg
Oomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0`Ool01@00OomoogooG_L0=Woo00=NmgooOol0<goo
00=NmgooOol01Woo00<007ooOol0@Goo001_Ool20006Ool00ekgOomoo`0dOol00ekgOomoo`0cOol0
0ekgOomoo`0dOol00ekgOomoo`0`Ool01@00OomoogooG_L0=Woo00=NmgooOol0<goo00=NmgooOol0
17oo0`00@goo001_Ool00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0d
Ool00ekgOomoo`0_Ool00`00Oomoo`02Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`06
Ool00`00Oomoo`11Ool006moo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Mo
ogoo03Aoo`03G_Moogoo02ioo`03001oogoo00=oo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Mo
ogoo00Ioo`03001oogoo045oo`00Kgoo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo
00=NmgooOol0=7oo00=NmgooOol0;Woo00<007ooOol00goo00=NmgooOol0=7oo00=NmgooOol0<goo
00=NmgooOol01Woo00<007ooOol0@Goo001_Ool20006Ool00ekgOomoo`0dOol00ekgOomoo`0cOol0
0ekgOomoo`0dOol00ekgOomoo`0]Ool00`00Oomoo`04Ool00ekgOomoo`0dOol00ekgOomoo`0cOol0
0ekgOomoo`04Ool30013Ool006moo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03
G_Moogoo03Aoo`03G_Moogoo02aoo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03
G_Moogoo00Ioo`03001oogoo045oo`00Kgoo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0
<goo00=NmgooOol0=7oo00=NmgooOol0:goo00<007ooOol01Woo00=NmgooOol0=7oo00=NmgooOol0
<goo00=NmgooOol01Woo00<007ooOol0@Goo001_Ool00`00Oomoo`05Ool00ekgOomoo`0dOol00ekg
Oomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0[Ool00`00Oomoo`06Ool00ekgOomoo`0dOol00ekg
Oomoo`0cOol00ekgOomoo`06Ool00`00Oomoo`11Ool006moo`8000Ioo`03G_Moogoo03Aoo`03G_Mo
ogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo02Yoo`03001oogoo00Moo`03G_Moogoo03Aoo`03G_Mo
ogoo03=oo`03G_Moogoo00Aoo`<004=oo`00Fgoo1@000Woo00<007ooOol00Woo00<007ooOol01Goo
00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol0:Goo
00<007ooOol027oo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol01Woo00<007ooOol0@Goo
001MOol01`00Oomoogoo001oo`00009oo`03001oo`0000Ioo`03001oogoo00Eoo`03G_Moogoo03Ao
o`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo02Qoo`03001oogoo00Uoo`03G_Moogoo03Ao
o`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo045oo`00Egoo0`000goo00L007ooOomoo`00
Ool00002Ool00`00Ool00006Ool3003CG_L00`00G_MNm`1mG_L40013Ool005eoo`07001oogooOol0
07oo00000Woo00<007oo00001Woo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=N
mgooOol0=7oo00=NmgooOol09Woo00<007ooOol02goo00=NmgooOol0=7oo00=NmgooOol0<goo00=N
mgooOol01Woo00<007ooOol0@Goo001MOol01`00Oomoogoo001oo`00009oo`03001oo`0000Ioo`03
001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo02Eoo`03
001oogoo00aoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo045oo`00
G7oo0P0017oo00<007ooOol00Woo00<007ooOol01Goo00<007ooOol01Goo00=NmgooOol0=7oo00=N
mgooOol0<goo00=NmgooOol0=7oo00=NmgooOol097oo00<007ooOol03Goo00=NmgooOol0=7oo00=N
mgooOol0<goo00=NmgooOol01Woo00<007ooOol0@Goo001_Ool20006Ool00ekgOomoo`0dOol00ekg
Oomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0SOol00`00Oomoo`0>Ool00ekgOomoo`0dOol00ekg
Oomoo`0cOol00ekgOomoo`04Ool30013Ool006moo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Mo
ogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo029oo`03001oogoo00moo`03G_Moogoo03Aoo`03G_Mo
ogoo03=oo`03G_Moogoo00Ioo`03001oogoo045oo`00Kgoo00<007ooOol01Goo00=NmgooOol0=7oo
00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol08Goo00<007ooOol047oo00=NmgooOol0=7oo
00=NmgooOol0<goo00=NmgooOol01Woo00<007ooOol0@Goo001_Ool00`00Oomoo`05Ool00ekgOomo
o`0dOol00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0OOol2000COol00ekgOomoo`0dOol0
0ekgOomoo`0cOol00ekgOomoo`06Ool00`00Oomoo`11Ool006moo`8000Ioo`03G_Moogoo03Aoo`03
G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo01ioo`03001oogoo01=oo`03G_Moogoo03Aoo`03
G_Moogoo03=oo`03G_Moogoo00Aoo`<004=oo`00Kgoo00<007ooOol01Goo00=NmgooOol0=7oo00=N
mgooOol0<goo00=NmgooOol0=7oo00=NmgooOol07Goo00<007ooOol057oo00=NmgooOol0=7oo00=N
mgooOol0<goo00=NmgooOol01Woo00<007ooOol0@Goo001_Ool00`00Oomoo`05Ool00ekgOomoo`0d
Ool00ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0LOol00`00Oomoo`0EOol00ekgOomoo`0d
Ool00ekgOomoo`0cOol00ekgOomoo`06Ool00`00Oomoo`11Ool006moo`03001oogoo00Eoo`03G_Mo
ogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo01Yoo`8001Qoo`03G_Moogoo03Ao
o`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo045oo`00Kgoo0P001Woo00=NmgooOol0=7oo
00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol06Goo00<007ooOol067oo00=NmgooOol0=7oo
00=NmgooOol0<goo00=NmgooOol017oo0`00@goo001_Ool00`00Oomoo`05Ool00ekgOomoo`0dOol0
0ekgOomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`0GOol2000KOol00ekgOomoo`0dOol00ekgOomo
o`0cOol00ekgOomoo`06Ool00`00Oomoo`11Ool006moo`03001oogoo00Eoo`03G_Moogoo03Aoo`03
G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo01Eoo`8001eoo`03G_Moogoo03Aoo`03G_Moogoo
03=oo`03G_Moogoo00Ioo`03001oogoo045oo`00Kgoo0P001Woo00=NmgooOol0=7oo00=NmgooOol0
<goo00=NmgooOol0=7oo00=NmgooOol04goo0P007goo00=NmgooOol0=7oo00=NmgooOol0<goo00=N
mgooOol017oo0`00@goo001_Ool00`00Oomoo`05Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekg
Oomoo`0dOol00ekgOomoo`0AOol2000QOol00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`06
Ool00`00Oomoo`11Ool0069oo`03001oogoo009oo`03001oogoo00Eoo`03001oogoo00Eoo`03G_Mo
ogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo00moo`8002=oo`03G_Moogoo03Ao
o`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo045oo`00HGoo00<007oo00000Woo00<007oo
00001Woo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=Nmgoo
Ool03Goo0P009Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol01Woo00<007ooOol0@Goo
001LOol30004Ool01P00Oomoo`00Ool000Ioo`<00;MNm`8009YNm`@004=oo`00HGoo0P000goo00<0
07oo00001Woo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=N
mgooOol027oo0`00:Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol01Woo00<007ooOol0
@Goo001QOol00`00Oomoo`02Ool00`00Ool00006Ool00`00Oomoo`05Ool00ekgOomoo`0dOol00ekg
Oomoo`0cOol00ekgOomoo`0dOol00ekgOomoo`06Ool2000/Ool00ekgOomoo`0dOol00ekgOomoo`0c
Ool00ekgOomoo`06Ool00`00Oomoo`11Ool0065oo`<000=oo`03001oogoo00Eoo`03001oogoo00Eo
o`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo03Aoo`03G_Moogoo00=oo`<002ioo`03G_Mo
ogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo045oo`00Kgoo0P001Woo00=Nmgoo
Ool0=7oo00=NmgooOol0<goo00=NmgooOol0=7oo00=NmgooOol00`00<Goo00=NmgooOol0=7oo00=N
mgooOol0<goo00=NmgooOol017oo0`00@goo001_Ool00`00Oomoo`05Ool00ekgOomoo`0dOol00ekg
Oomoo`0cOol00ekgOomoo`0dOol00ekg0000000dOol00ekgOomoo`0dOol00ekgOomoo`0cOol00ekg
Oomoo`06Ool00`00Oomoo`11Ool006moo`03001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=o
o`03G_Moogoo035oo`@003Ioo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001o
ogoo045oo`00Kgoo00<007ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol0;Goo
10000goo00=NmgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol01Woo00<007oo
Ool0@Goo001_Ool20006Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0XOol50007Ool0
0ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`04Ool30013Ool006moo`03
001oogoo00Eoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo02Aoo`@000aoo`03G_Moogoo
03Aoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo045oo`00Kgoo00<0
07ooOol01Goo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol07Woo1P0047oo00=NmgooOol0
=7oo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol01Woo00<007ooOol0@Goo001_Ool20006
Ool00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`0FOol8000FOol00ekgOomoo`0dOol00ekg
Oomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`04Ool30013Ool006moo`03001oogoo00Eoo`03G_Mo
ogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo00ioo`P001ioo`03G_Moogoo03Aoo`03G_Moogoo03Ao
o`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001oogoo045oo`00Kgoo00<007ooOol01Goo00=Nmgoo
Ool0=7oo00=NmgooOol0<goo00=NmgooOol01Woo20009Woo00=NmgooOol0=7oo00=NmgooOol0=7oo
00=NmgooOol0<goo00=NmgooOol01Woo00<007ooOol0@Goo001_Ool00`00Oomoo`05Ool00ekgOomo
o`0dOol00ekgOomoo`0ZOolB000^Ool00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0cOol0
0ekgOomoo`06Ool00`00Oomoo`11Ool006moo`8000Ioo`03G_Moogoo03Aoo`03G_Moogoo00iooa`0
00Uoo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo
00Aoo`<004=oo`00Kgoo00<007ooOol01Goo00=NmgooOol0:7oo7@009Goo00=NmgooOol0=7oo00=N
mgooOol0=7oo00=NmgooOol0=7oo00=NmgooOol0<goo00=NmgooOol01Woo00<007ooOol0@Goo001W
Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00ekgOomoo`0<OolL000<Ool00ekgOomoo`0cOol00ekg
Oomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0dOol00ekgOomoo`0cOol00ekgOomoo`06Ool00`00
Oomoo`11Ool006Ioo`03001oo`0000Ioo`03001oogoo00Eoo`l002Qoo`03G_Moogoo03=oo`03G_Mo
ogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo03Aoo`03G_Moogoo03=oo`03G_Moogoo00Ioo`03001o
ogoo045oo`00IWoo00<007oo00001Woo0`001Ekg00<005kgG_L0BEkg00<005kgG_L07Ukg00<005kg
G_L0BUkg00<005kgG_L07Ukg00<005kgG_L0BEkg00<005kgG_L07Ukg00<005kgG_L00ekg1000@goo
001VOol00`00Ool00006Ool00`00Oomoo`05Ool00`00Oomoo`0NOol00`00Oomoo`0@Ool01000Oomo
oekg2Woo00<007ooOol01goo00<007ooOol01Woo00<007ooOol017oo00<007ooOol017oo00<007oo
Ool00Woo00<007ooOol00Woo00<007ooOol07Woo00<007ooOol04Goo00<007ooG_L02Woo00<007oo
Ool027oo00<007ooOol01Woo00<007ooOol017oo00<007ooOol00goo00<007ooOol00goo00<007oo
Ool00Woo00<007ooOol07Woo00<007ooOol047oo00@007ooOomNm`Yoo`03001oogoo00Moo`03001o
ogoo00Ioo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo009oo`03001oogoo009oo`03001o
ogoo00Ioo`03001oogoo045oo`00IWoo00<007oo00001Wooo`00F`00@goo001WOol00`00Oomoo`3o
OonSOol00?mooomoo`ioo`00ogooogoo3Woo003oOoooOol>Ool00?mooomoo`ioo`00ogooogoo3Woo
003oOoooOol>Ool00?mooomoo`ioo`00KGoo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0
1@00>Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol04Woo00<007oo
Ool00Woo00<007ooOol01@00@7oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol067oo1@00
BGoo00<007ooOol06Goo1@000Woo00<007ooOol0BGoo001/Ool00`00Ool00007Ool00`00Ool00003
Ool00`00Oomoo`0iOol00`00Ool00007Ool00`00Ool00002Ool00`00Ool0000BOol00`00Ool00008
Ool00`00Oomoo`0oOol00`00Ool00007Ool00`00Ool0000KOol00`00Oomoo`18Ool00`00Ool0000L
Ool01`00Oomoogoo001oo`0004Yoo`00K7oo00<007oo00001goo00<007oo00000goo00<007ooOol0
>Goo00<007oo00001goo00<007oo000017oo00<007ooOol047oo00<007oo000027oo00<007ooOol0
?goo00<007oo00002Goo00<007ooOol06Goo00<007ooOol0BWoo00<007ooOol06Woo00L007ooOomo
o`00Ool0001:Ool006aoo`03001oo`0000Moo`03001oo`0000=oo`03001oogoo03Uoo`03001oo`00
00Moo`03001oo`00009oo`8001=oo`03001oo`0000Qoo`03001oogoo03moo`03001oo`0000Moo`80
01aoo`03001oogoo04Qoo`8001eoo`07001oogooOol007oo0000BWoo001/Ool00`00Ool00007Ool0
0`00Ool00003Ool00`00Oomoo`0iOol00`00Ool00007Ool00`00Ool00002Ool00`00Oomoo`0BOol0
0`00Ool00008Ool00`00Oomoo`0oOol00`00Ool00007Ool00`00Oomoo`0KOol00`00Oomoo`18Ool0
0`00Oomoo`0LOol01`00Oomoogoo001oo`0004Yoo`00KGoo00<007ooOol01goo00@007ooOomoo`80
03aoo`03001oogoo00Moo`04001oogooOol3000COol00`00Oomoo`06Ool20012Ool00`00Oomoo`06
Ool3000JOol2001:Ool3000KOol20004Ool00`00Oomoo`19Ool00?mooomoo`ioo`00ogooogoo3Woo
003oOoooOol>Ool00?mooomoo`ioo`00ogooogoo3Woo003oOoooOol>Ool00?mooa1oo`03001oogoo
009oo`06001oogoo001oo`000goo0P0000Aoo`000000009oo`@00>=oo`00ogoo47oo00<007ooOol0
0Woo00@007ooOol0009oo`@00003Ool00000009oo`03001oo`000>Ioo`00ogoo47oo0`000Woo1000
0Woo00@007ooOol000=oo`<00003Ool007oo0>Eoo`00ogoo47oo00H007ooOol007oo0002Ool00`00
Oomoo`030003Ool20003Ool00`00Oomoo`3TOol00?mooa1oo`06001oogoo001oo`000Woo00@007oo
Oomoo`8000=oo`06001oo`00001oo`00iWoo003oOol@Ool30002Ool01000Oomoo`000goo0P000goo
0`000Woo1000hgoo003oOoooOol>Ool00?mooomoo`ioo`00\
\>"],
  ImageRangeCache->{{{0, 523}, {173.438, 0}} -> {-3.0892, -382.184, \
0.00913045, 2.67784}},
  CellTags->{"Bode plot", "i:9"}]
}, Open  ]]
}, Open  ]],

Cell["\<\
Bode can also be used with the PlotPoints option when finer resolution is \
required.\
\>", "Text",
  CellTags->{"Bode plot", "i:9"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\tG[
        s_] := \(\((s + 10)\)\ \((s + 4)\)\)\/\(s\ \((s\^2 +  .1\ s + 2)\)\ \
\((s\^2 +  .1\ s + 1)\)\)\), "\n", 
    \(Bode[G, s,  .2, 10, PlotPoints \[Rule] 1000]\)}], "Input",
  CellLabel->"In[110]:=",
  CellTags->{"Bode plot", "i:9"}],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .33333 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.415627 0.560564 0.172201 0.00292893 [
[.02381 -0.0125 -11 -12.875 ]
[.02381 -0.0125 11 0 ]
[.24688 -0.0125 -11 -12.875 ]
[.24688 -0.0125 11 0 ]
[.41563 -0.0125 -5 -12.875 ]
[.41563 -0.0125 5 0 ]
[.58437 -0.0125 -5 -12.875 ]
[.58437 -0.0125 5 0 ]
[.80744 -0.0125 -5 -12.875 ]
[.80744 -0.0125 5 0 ]
[.97619 -0.0125 -8 -12.875 ]
[.97619 -0.0125 8 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -23 -25.75 ]
[.5 -0.0125 23 -12.875 ]
[-0.0125 .05504 -18 -4.5 ]
[-0.0125 .05504 0 4.5 ]
[-0.0125 .11362 -18 -4.5 ]
[-0.0125 .11362 0 4.5 ]
[-0.0125 .1722 -6 -4.5 ]
[-0.0125 .1722 0 4.5 ]
[-0.0125 .23078 -12 -4.5 ]
[-0.0125 .23078 0 4.5 ]
[-0.0125 .28936 -12 -4.5 ]
[-0.0125 .28936 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .16667 -40 -6.4375 ]
[-0.01875 .16667 -18 6.4375 ]
[.02381 .34583 -11 0 ]
[.02381 .34583 11 12.875 ]
[.24688 .34583 -11 0 ]
[.24688 .34583 11 12.875 ]
[.41563 .34583 -5 0 ]
[.41563 .34583 5 12.875 ]
[.58437 .34583 -5 0 ]
[.58437 .34583 5 12.875 ]
[.80744 .34583 -5 0 ]
[.80744 .34583 5 12.875 ]
[.97619 .34583 -8 0 ]
[.97619 .34583 8 12.875 ]
[ 0 .33333 .125 0 ]
[.5 .34583 -26 12.875 ]
[.5 .34583 26 24.0625 ]
[ 1 0 .125 0 ]
[1.0125 .16667 0 -6.4375 ]
[1.0125 .16667 10 6.4375 ]
[ 0 -0.0005 0 0 ]
[ 1 .33383 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
.75 g
.25 Mabswid
.13534 0 m
.13534 .33333 L
s
.27549 0 m
.27549 .33333 L
s
.41563 0 m
.41563 .33333 L
s
.55577 0 m
.55577 .33333 L
s
.69591 0 m
.69591 .33333 L
s
.83605 0 m
.83605 .33333 L
s
.97619 0 m
.97619 .33333 L
s
0 .05504 m
1 .05504 L
s
0 .11362 m
1 .11362 L
s
0 .1722 m
1 .1722 L
s
0 .23078 m
1 .23078 L
s
0 .28936 m
1 .28936 L
s
0 g
.02381 0 m
.02381 .00625 L
s
gsave
.02381 -0.0125 -72 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.24688 0 m
.24688 .00625 L
s
gsave
.24688 -0.0125 -72 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.41563 0 m
.41563 .00625 L
s
gsave
.41563 -0.0125 -66 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.58437 0 m
.58437 .00625 L
s
gsave
.58437 -0.0125 -66 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.80744 0 m
.80744 .00625 L
s
gsave
.80744 -0.0125 -66 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.97619 0 m
.97619 .00625 L
s
gsave
.97619 -0.0125 -69 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
75.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.001 w
.12252 0 m
.12252 .00375 L
s
.19256 0 m
.19256 .00375 L
s
.29127 0 m
.29127 .00375 L
s
.32879 0 m
.32879 .00375 L
s
.3613 0 m
.3613 .00375 L
s
.38998 0 m
.38998 .00375 L
s
.68308 0 m
.68308 .00375 L
s
.75312 0 m
.75312 .00375 L
s
.85183 0 m
.85183 .00375 L
s
.88936 0 m
.88936 .00375 L
s
.92187 0 m
.92187 .00375 L
s
.95054 0 m
.95054 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -84 -29.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(rad) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
81.000000 13.000000 moveto
(\\220) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(sec) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
0 .05504 m
.00625 .05504 L
s
[(-40)] -0.0125 .05504 1 0 Mshowa
0 .11362 m
.00625 .11362 L
s
[(-20)] -0.0125 .11362 1 0 Mshowa
0 .1722 m
.00625 .1722 L
s
[(0)] -0.0125 .1722 1 0 Mshowa
0 .23078 m
.00625 .23078 L
s
[(20)] -0.0125 .23078 1 0 Mshowa
0 .28936 m
.00625 .28936 L
s
[(40)] -0.0125 .28936 1 0 Mshowa
.125 Mabswid
0 .06969 m
.00375 .06969 L
s
0 .08433 m
.00375 .08433 L
s
0 .09898 m
.00375 .09898 L
s
0 .12827 m
.00375 .12827 L
s
0 .14291 m
.00375 .14291 L
s
0 .15756 m
.00375 .15756 L
s
0 .18685 m
.00375 .18685 L
s
0 .20149 m
.00375 .20149 L
s
0 .21613 m
.00375 .21613 L
s
0 .24542 m
.00375 .24542 L
s
0 .26007 m
.00375 .26007 L
s
0 .27471 m
.00375 .27471 L
s
0 .0404 m
.00375 .0404 L
s
0 .02575 m
.00375 .02575 L
s
0 .01111 m
.00375 .01111 L
s
0 .304 m
.00375 .304 L
s
0 .31865 m
.00375 .31865 L
s
0 .33329 m
.00375 .33329 L
s
.25 Mabswid
0 0 m
0 .33333 L
s
gsave
-0.01875 .16667 -101 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(dB) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.02381 .32708 m
.02381 .33333 L
s
gsave
.02381 .34583 -72 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.24688 .32708 m
.24688 .33333 L
s
gsave
.24688 .34583 -72 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.41563 .32708 m
.41563 .33333 L
s
gsave
.41563 .34583 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.58437 .32708 m
.58437 .33333 L
s
gsave
.58437 .34583 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.80744 .32708 m
.80744 .33333 L
s
gsave
.80744 .34583 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.97619 .32708 m
.97619 .33333 L
s
gsave
.97619 .34583 -69 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
75.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.001 w
.12252 .32958 m
.12252 .33333 L
s
.19256 .32958 m
.19256 .33333 L
s
.29127 .32958 m
.29127 .33333 L
s
.32879 .32958 m
.32879 .33333 L
s
.3613 .32958 m
.3613 .33333 L
s
.38998 .32958 m
.38998 .33333 L
s
.68308 .32958 m
.68308 .33333 L
s
.75312 .32958 m
.75312 .33333 L
s
.85183 .32958 m
.85183 .33333 L
s
.88936 .32958 m
.88936 .33333 L
s
.92187 .32958 m
.92187 .33333 L
s
.95054 .32958 m
.95054 .33333 L
s
.25 Mabswid
0 .33333 m
1 .33333 L
s
gsave
.5 .34583 -87 8.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 15.187500 moveto
 460.000000 15.187500 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 15.187500 lineto
closepath
clip newpath
63.000000 12.500000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 12.500000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(MAGNITUDE) show
111.000000 12.500000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica-Bold
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica-Bold
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica-Bold
grestore
.99375 .05504 m
1 .05504 L
s
.99375 .11362 m
1 .11362 L
s
.99375 .1722 m
1 .1722 L
s
.99375 .23078 m
1 .23078 L
s
.99375 .28936 m
1 .28936 L
s
.125 Mabswid
.99625 .06969 m
1 .06969 L
s
.99625 .08433 m
1 .08433 L
s
.99625 .09898 m
1 .09898 L
s
.99625 .12827 m
1 .12827 L
s
.99625 .14291 m
1 .14291 L
s
.99625 .15756 m
1 .15756 L
s
.99625 .18685 m
1 .18685 L
s
.99625 .20149 m
1 .20149 L
s
.99625 .21613 m
1 .21613 L
s
.99625 .24542 m
1 .24542 L
s
.99625 .26007 m
1 .26007 L
s
.99625 .27471 m
1 .27471 L
s
.99625 .0404 m
1 .0404 L
s
.99625 .02575 m
1 .02575 L
s
.99625 .01111 m
1 .01111 L
s
.99625 .304 m
1 .304 L
s
.99625 .31865 m
1 .31865 L
s
.99625 .33329 m
1 .33329 L
s
.25 Mabswid
1 0 m
1 .33333 L
s
gsave
1.0125 .16667 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
69.000000 13.000000 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .33333 L
0 .33333 L
closepath
clip
newpath
.5 Mabswid
.02381 .29094 m
.06648 .28716 L
.10582 .28394 L
.13774 .28159 L
.16494 .27985 L
.19089 .27847 L
.21351 .27757 L
.2191 .2774 L
.22503 .27724 L
.23004 .27713 L
.23544 .27704 L
.23793 .277 L
.24057 .27697 L
.24304 .27695 L
.24528 .27693 L
.24658 .27693 L
.24778 .27692 L
.24846 .27692 L
.24908 .27692 L
.24943 .27692 L
.2498 .27692 L
.25015 .27692 L
.25047 .27692 L
.25105 .27692 L
.2516 .27692 L
.25219 .27692 L
.25253 .27692 L
.25283 .27692 L
.25344 .27692 L
.2541 .27692 L
.2553 .27693 L
.25638 .27694 L
.25755 .27694 L
.25964 .27696 L
.26211 .27699 L
.26435 .27703 L
.26891 .27712 L
.27362 .27724 L
.28201 .27754 L
.28957 .27791 L
.29772 .27844 L
.3049 .27902 L
.31966 .28062 L
.33306 .28267 L
.34655 .2855 L
.35886 .28899 L
.37015 .29325 L
.38162 .29906 L
.39216 .30633 L
.4029 .31619 L
Mistroke
.40809 .32133 L
.41058 .3234 L
.41174 .32417 L
.41281 .32473 L
.41335 .32496 L
.41393 .32515 L
.4142 .32522 L
.4145 .32529 L
.41467 .32532 L
.41483 .32534 L
.41513 .32537 L
.41541 .32539 L
.41566 .3254 L
.41595 .32539 L
.41624 .32537 L
.4165 .32534 L
.41674 .3253 L
.41729 .32517 L
.41787 .32499 L
.41848 .32474 L
.41956 .32418 L
.42198 .32243 L
.43079 .31397 L
.43984 .30633 L
.44824 .30117 L
.45271 .29914 L
.45686 .29768 L
.45883 .29713 L
.46091 .29664 L
.46267 .29632 L
.46458 .29605 L
.46561 .29594 L
.46612 .2959 L
.46659 .29587 L
.467 .29584 L
.46746 .29582 L
.46792 .29581 L
.46817 .2958 L
.4684 .2958 L
.46864 .29579 L
.46877 .29579 L
.4689 .29579 L
.46915 .29579 L
.46929 .2958 L
.46942 .2958 L
.46965 .2958 L
.4699 .29581 L
.47035 .29582 L
.47088 .29585 L
.47143 .29589 L
Mistroke
.47243 .29598 L
.47337 .29609 L
.47423 .29622 L
.47614 .2966 L
.4779 .29707 L
.47956 .29762 L
.48322 .29924 L
.48656 .30127 L
.49352 .30679 L
.49532 .30807 L
.49581 .30836 L
.49633 .30862 L
.49677 .30879 L
.49702 .30887 L
.49725 .30894 L
.49747 .30898 L
.49758 .309 L
.4977 .30902 L
.49792 .30904 L
.49812 .30904 L
.49823 .30904 L
.49835 .30904 L
.49856 .30902 L
.49868 .309 L
.49881 .30897 L
.49905 .30892 L
.49925 .30885 L
.49946 .30877 L
.49984 .30858 L
.5003 .30829 L
.50071 .30797 L
.50153 .30716 L
.5024 .30608 L
.50396 .30368 L
.50743 .29699 L
.51362 .28453 L
.52005 .2732 L
.52609 .26403 L
.53234 .25564 L
.53821 .24854 L
.54374 .24238 L
.54948 .23641 L
.55488 .23111 L
.56049 .22589 L
.56578 .22119 L
.57076 .21693 L
.57595 .21265 L
.58084 .20874 L
.58546 .20515 L
.59028 .2015 L
Mistroke
.59483 .19813 L
.59957 .19469 L
.60406 .1915 L
.6083 .18855 L
.61273 .18552 L
.61692 .18269 L
.62088 .18006 L
.62503 .17734 L
.62896 .1748 L
.63307 .17218 L
.63696 .16972 L
.64064 .16742 L
.64451 .16504 L
.64817 .1628 L
.652 .16048 L
.65564 .1583 L
.65908 .15625 L
.6627 .15412 L
.66613 .15212 L
.66938 .15023 L
.6728 .14826 L
.67604 .14641 L
.67944 .14448 L
.68268 .14265 L
.68575 .14093 L
.68897 .13914 L
.69203 .13744 L
.69494 .13584 L
.69801 .13416 L
.70092 .13258 L
.70397 .13092 L
.70688 .12936 L
.70965 .12788 L
.71256 .12632 L
.71532 .12486 L
.71823 .12332 L
.721 .12187 L
.72363 .12049 L
.72641 .11904 L
.72904 .11767 L
.73156 .11638 L
.7342 .11501 L
.73672 .11372 L
.73937 .11237 L
.7419 .11108 L
.7443 .10987 L
.74683 .10859 L
.74925 .10737 L
.75179 .1061 L
.75421 .10489 L
Mistroke
.75652 .10374 L
.75895 .10253 L
.76127 .10139 L
.76348 .1003 L
.76581 .09915 L
.76803 .09806 L
.77037 .09692 L
.7726 .09584 L
.77473 .0948 L
.77697 .09372 L
.77911 .09268 L
.78116 .0917 L
.78331 .09067 L
.78537 .08968 L
.78754 .08865 L
.78961 .08766 L
.79158 .08673 L
.79366 .08574 L
.79565 .0848 L
.79775 .08381 L
.79975 .08287 L
.80166 .08198 L
.80368 .08103 L
.80561 .08013 L
.80745 .07928 L
.80939 .07838 L
.81124 .07752 L
.8132 .07662 L
.81507 .07575 L
.81685 .07493 L
.81874 .07407 L
.82054 .07324 L
.82226 .07246 L
.82408 .07163 L
.82582 .07084 L
.82765 .07001 L
.8294 .06921 L
.83108 .06846 L
.83284 .06766 L
.83454 .0669 L
.83632 .0661 L
.83803 .06533 L
.83966 .0646 L
.84138 .06383 L
.84303 .0631 L
.8446 .0624 L
.84627 .06166 L
.84786 .06095 L
.84954 .06021 L
.85115 .0595 L
Mistroke
.85268 .05882 L
.85431 .05811 L
.85586 .05743 L
.8575 .05671 L
.85907 .05602 L
.86058 .05536 L
.86216 .05467 L
.86368 .05401 L
.86513 .05338 L
.86667 .05272 L
.86814 .05208 L
.86969 .05141 L
.87117 .05077 L
.8726 .05016 L
.8741 .04951 L
.87554 .04889 L
.87691 .0483 L
.87837 .04768 L
.87976 .04708 L
.88123 .04646 L
.88264 .04586 L
.88399 .04528 L
.88541 .04468 L
.88678 .0441 L
.88822 .04349 L
.8896 .0429 L
.89093 .04234 L
.89232 .04175 L
.89366 .04119 L
.89494 .04065 L
.8963 .04008 L
.8976 .03954 L
.89897 .03896 L
.90029 .03842 L
.90155 .03789 L
.90288 .03734 L
.90415 .0368 L
.9055 .03624 L
.90679 .03571 L
.90803 .0352 L
.90934 .03465 L
.91059 .03414 L
.91179 .03364 L
.91306 .03312 L
.91428 .03262 L
.91556 .03209 L
.9168 .03158 L
.91798 .0311 L
.91923 .03059 L
.92042 .0301 L
Mistroke
.92157 .02963 L
.92278 .02913 L
.92394 .02866 L
.92517 .02816 L
.92635 .02768 L
.92748 .02722 L
.92868 .02674 L
.92982 .02627 L
.93103 .02578 L
.93219 .02531 L
.93331 .02487 L
.93448 .02439 L
.93561 .02394 L
.93669 .0235 L
.93784 .02304 L
.93893 .0226 L
.94009 .02214 L
.9412 .02169 L
.94227 .02127 L
.9434 .02082 L
.94448 .02038 L
.94552 .01997 L
.94661 .01953 L
.94767 .01912 L
.94878 .01867 L
.94985 .01825 L
.95087 .01784 L
.95195 .01742 L
.95299 .017 L
.95409 .01657 L
.95515 .01615 L
.95616 .01576 L
.95722 .01533 L
.95825 .01493 L
.95923 .01455 L
.96027 .01414 L
.96127 .01374 L
.96233 .01333 L
.96334 .01293 L
.96431 .01255 L
.96534 .01215 L
.96633 .01177 L
.96737 .01136 L
.96837 .01097 L
.96933 .0106 L
.97035 .0102 L
.97133 .00982 L
.97226 .00946 L
.97325 .00907 L
.9742 .00871 L
Mistroke
.97521 .00832 L
.97617 .00794 L
.97619 .00794 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[110]:=",
  ImageSize->{519, 172.688},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000870000[1000`40O003h00Oogooogoo2Goo003o
OoooOol9Ool00?mooomoo`Uoo`00ogooogoo2Goo003oOolBOol00`00Oomoo`3cOol00?moo`<0009o
o`@0009oo`<000Eoo`03001oogoo009oo`8000Aoo`80009oo`<00>=oo`00ogoo0Goo00@007ooOomo
o`<0009oo`04001oogoo0005Ool00`00Oomoo`04Ool01000Oomoo`0017oo00<007ooOol0hgoo003o
Ool1Ool00`00Oomoo`03Ool01000Oomoo`000Woo00<007ooOol00goo00<007ooOol00goo00@007oo
Oomoo`<0009oo`03001oogoo0>=oo`00ogoo10000Woo0P000goo0`001Woo00<007ooOol00Woo0P00
0Woo0`000Woo0`00hgoo003oOol=Ool00`00Oomoo`04Ool00`00Oomoo`3aOol00?moo`aoo`8000Mo
o`03001oogoo0?1oo`00ogooogoo2Goo003oOoooOol9Ool00?mooomoo`Uoo`00ogooogoo2Goo003o
OoooOol9Ool00?mooomoo`Uoo`00ogooogoo2Goo001ZOol00`00Oomoo`02Ool01000Oomoogoo0`00
?goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0<Goo1@00=Goo0`00BWoo00<007ooOol0
<Woo1@000Woo00<007ooOol0CWoo001YOol00`00Ool00007Ool00`00Oomoo`0nOol00`00Ool00007
Ool00`00Ool0000dOol00`00Oomoo`0eOol00`00Oomoo`19Ool00`00Ool0000eOol01`00Oomoogoo
001oo`0004moo`00JGoo00<007oo000027oo00<007ooOol0?Goo00<007oo00002Goo00<007ooOol0
<Woo00<007ooOol0=Woo00<007ooOol0BWoo00<007ooOol0<goo00L007ooOomoo`00Ool0001?Ool0
06Uoo`03001oo`0000Qoo`03001oogoo03eoo`03001oo`0000Moo`8003Eoo`03001oogoo03Ioo`03
001oogoo04Qoo`8003Ioo`07001oogooOol007oo0000Cgoo001YOol00`00Ool00007Ool00`00Ool0
000nOol00`00Ool00007Ool00`00Oomoo`0dOol00`00Oomoo`0eOol00`00Ool00019Ool00`00Oomo
o`0eOol01`00Oomoogoo001oo`0004moo`00JWoo00<007ooOol01goo00<007ooOol0?Woo00<007oo
Ool01Woo0`00<goo0P00>7oo00<007ooOol0B7oo0`00=7oo0P0017oo00<007ooOol0CWoo003oOooo
Ool9Ool00?mooomoo`Uoo`00ogooogoo2Goo003oOoooOol9Ool00?mooomoo`Uoo`00ogooogoo2Goo
001YOooo001F0019Ool006Uoo`03001oogoo00Eoo`03001oogoo01ioo`03001oogoo009oo`03G_Mo
ogoo011oo`03001oogoo00moo`03001oogoo00Moo`03G_Moogoo00=oo`03001oogoo00Uoo`03001o
ogoo00Qoo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo02eoo`03G_Moogoo00Ioo`03001o
ogoo01moo`05001oogooOomNm`0COol00`00Oomoo`0?Ool00`00Oomoo`07Ool00ekgOomoo`02Ool0
0`00Oomoo`0:Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`05Ool0
0`00Oomoo`17Ool006Uoo`03001oogoo00Eoo`03001oogoo02=oo`03G_Moogoo029oo`03001oogoo
00Moo`03G_Moogoo02eoo`03001oogoo02eoo`03G_Moogoo00Ioo`03001oogoo02=oo`03G_Moogoo
02=oo`03001oogoo00Moo`03G_Moogoo02eoo`03001oogoo00Eoo`03001oogoo04Moo`00JGoo00<0
07ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol0;7oo00=N
mgooOol0;Goo00=NmgooOol0:Woo10001goo00<007ooOol0Agoo001YOol2000/Ool00ekgOomoo`0/
Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0W
Ool40002Ool00ekgOomoo`03Ool30019Ool006Uoo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Mo
ogoo02eoo`03G_Moogoo02eoo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02Eoo`<000Eo
o`03G_Moogoo00Eoo`03001oogoo04Moo`00JGoo00<007ooOol0:goo00=NmgooOol0;7oo00=Nmgoo
Ool0;Goo00=NmgooOol0;Goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol08Woo10001goo
00=NmgooOol01Goo00<007ooOol0Agoo001YOol00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomo
o`0]Ool00ekgOomoo`0]Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0POol3000:Ool0
0ekgOomoo`05Ool00`00Oomoo`17Ool006Uoo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo
02eoo`03G_Moogoo02eoo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo01ioo`8000eoo`03
G_Moogoo00Eoo`03001oogoo04Moo`00JGoo0P00;7oo00=NmgooOol0;7oo00=NmgooOol0;Goo00=N
mgooOol0;Goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol06goo0`003goo00=NmgooOol0
0goo0`00BGoo001YOol00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]
Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0IOol3000AOol00ekgOomoo`05Ool00`00
Oomoo`17Ool006Uoo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eo
o`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo01Ioo`<001Aoo`03G_Moogoo00Eoo`03001o
ogoo04Moo`00JGoo00<007ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo
00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol057oo0`005Woo00=NmgooOol01Goo00<007oo
Ool0Agoo001YOol00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool0
0ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0AOol4000HOol00ekgOomoo`05Ool00`00Oomo
o`17Ool006Uoo`8002aoo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo
02aoo`03G_Moogoo02eoo`03G_Moogoo00moo`<001]oo`03G_Moogoo00=oo`<004Uoo`00JGoo00<0
07ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol0;7oo00=N
mgooOol0;Goo00=NmgooOol03Goo0`007Goo00=NmgooOol01Goo00<007ooOol0Agoo001YOol00`00
Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`0/Ool00ekg
Oomoo`0]Ool00ekgOomoo`0:Ool3000POol00ekgOomoo`05Ool00`00Oomoo`17Ool005aoo`<0009o
o`03001oogoo00Eoo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eo
o`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo00Qoo`<0029oo`03G_Moogoo00Eoo`03001o
ogoo04Moo`00GGoo00H007ooOol007oo0006Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomo
o`0]Ool00ekgOomoo`0]Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`06Ool3000TOol0
0ekgOomoo`05Ool00`00Oomoo`17Ool005Ioo`<0009oo`@00004Ool007oo0006Ool3003oG_LQG_L2
000/G_L40019Ool005]oo`03001oo`00009oo`03001oo`0000Ioo`03001oogoo02]oo`03G_Moogoo
02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo02aoo`03G_Moogoo02eoo`04G_Moogoo
Ool3000YOol00ekgOomoo`05Ool00`00Oomoo`17Ool005aoo`80009oo`03001oo`0000Ioo`03001o
ogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo02aoo`03G_Mo
ogoo02eoo`03G_Moo`00008002]oo`03G_Moogoo00Eoo`03001oogoo04Moo`00GGoo00D007ooOomo
o`0000Moo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Mo
ogoo02aoo`03G_Moogoo02eoo`<002eoo`03G_Moogoo00Eoo`03001oogoo04Moo`00JGoo00<007oo
Ool0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol0;7oo00=Nmgoo
Ool0:goo0P0000=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0Agoo001YOol2000/Ool00ekg
Oomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`0/Ool00ekgOomoo`0XOol30002
Ool00ekgOomoo`0]Ool00ekgOomoo`03Ool30019Ool006Uoo`03001oogoo02]oo`03G_Moogoo02ao
o`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo02aoo`03G_Moogoo02Ioo`<000Aoo`03G_Mo
ogoo02eoo`03G_Moogoo00Eoo`03001oogoo04Moo`00JGoo00<007ooOol0:goo00=NmgooOol0;7oo
00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol0;7oo00=NmgooOol097oo0`001Woo00=Nmgoo
Ool0;Goo00=NmgooOol01Goo00<007ooOol0Agoo001YOol00`00Oomoo`0[Ool00ekgOomoo`0/Ool0
0ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`0/Ool00ekgOomoo`0ROol20009Ool00ekgOomo
o`0]Ool00ekgOomoo`05Ool00`00Oomoo`17Ool006Uoo`8002aoo`03G_Moogoo02aoo`03G_Moogoo
02eoo`03G_Moogoo02eoo`03G_Moogoo02aoo`03G_Moogoo021oo`8000]oo`03G_Moogoo02eoo`03
G_Moogoo00=oo`<004Uoo`00JGoo00<007ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=N
mgooOol0;Goo00=NmgooOol0;7oo00=NmgooOol07Woo0P003Goo00=NmgooOol0;Goo00=NmgooOol0
1Goo00<007ooOol0Agoo001YOol00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekg
Oomoo`0]Ool00ekgOomoo`0/Ool00ekgOomoo`0LOol2000?Ool00ekgOomoo`0]Ool00ekgOomoo`05
Ool00`00Oomoo`17Ool006Uoo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Mo
ogoo02eoo`03G_Moogoo02aoo`03G_Moogoo01Uoo`<0015oo`03G_Moogoo02eoo`03G_Moogoo00Eo
o`03001oogoo04Moo`00JGoo00<007ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=Nmgoo
Ool0;Goo00=NmgooOol0;7oo00=NmgooOol05goo0`004goo00=NmgooOol0;Goo00=NmgooOol01Goo
00<007ooOol0Agoo001YOol2000/Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool0
0ekgOomoo`0/Ool00ekgOomoo`0FOol2000EOol00ekgOomoo`0]Ool00ekgOomoo`03Ool30019Ool0
06Uoo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo
02aoo`03G_Moogoo01=oo`<001Moo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo04Moo`00
JGoo00<007ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol0
;7oo00=NmgooOol04Goo0`006Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0Agoo001K
Ool30003Ool00`00Oomoo`05Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekg
Oomoo`0]Ool00ekgOomoo`0/Ool00ekgOomoo`0?Ool2000LOol00ekgOomoo`0]Ool00ekgOomoo`05
Ool00`00Oomoo`17Ool005]oo`03001oogoo009oo`03001oo`0000Ioo`03001oogoo02]oo`03G_Mo
ogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo02aoo`03G_Moogoo00ioo`8001eo
o`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo04Moo`00EWoo0`000goo00L007ooOomoo`00
Ool00006Ool3003gG_L3001DG_L40019Ool005aoo`07001oogooOol007oo00001Woo00<007ooOol0
:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol0;7oo00=NmgooOol0
2Goo0P008Woo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0Agoo001KOol00`00Ool00002
Ool00`00Ool00006Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]
Ool00ekgOomoo`0/Ool00ekgOomoo`08Ool00`00Oomoo`0ROol00ekgOomoo`0]Ool00ekgOomoo`05
Ool00`00Oomoo`17Ool005aoo`03001oogoo009oo`03001oogoo00Eoo`03001oogoo02]oo`03G_Mo
ogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo02aoo`03G_Moogoo00Ioo`8002Eo
o`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo04Moo`00JGoo00<007ooOol0:goo00=Nmgoo
Ool0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol0;7oo00=NmgooOol017oo0P009goo
00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0Agoo001YOol2000/Ool00ekgOomoo`0/Ool0
0ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`0/Ool00ekgOomoo`02Ool2000YOol00ekgOomo
o`0]Ool00ekgOomoo`03Ool30019Ool006Uoo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo
02eoo`03G_Moogoo02eoo`03G_Moogoo02aoo`03G_Moogoo008002]oo`03G_Moogoo02eoo`03G_Mo
ogoo00Eoo`03001oogoo04Moo`00JGoo00<007ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo
00=NmgooOol0;Goo00=NmgooOol0;7oo00=Nm`000000;Goo00=NmgooOol0;Goo00=NmgooOol01Goo
00<007ooOol0Agoo001YOol00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomo
o`0]Ool00ekgOomoo`0/Ool00`00Oomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomo
o`17Ool006Uoo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03
G_Moogoo02Yoo`800003G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo04Mo
o`00JGoo0P00;7oo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol0:7oo
0P000Woo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol00goo0`00BGoo001YOol00`00Oomo
o`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`0WOol00`00Oomo
o`02Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`17Ool006Uoo`03
001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo02Aoo`<0
00Eoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo04Moo`00JGoo00<0
07ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol08goo00<0
07ooOol01Woo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0Agoo001Y
Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`0Q
Ool20009Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`17Ool006Uo
o`8002aoo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo021oo`03001o
ogoo00Uoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00=oo`<004Uoo`00JGoo00<007oo
Ool0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol07Goo0`0037oo
00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0Agoo000nOol7000TOol0
0`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`0LOol0
0`00Oomoo`0=Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`17Ool0
03eoo`06001oogoo001oo`000Woo00<007ooOol06Goo00<007ooOol01Goo00<007ooOol0:goo00=N
mgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol06goo00<007ooOol03Woo00=N
mgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0Agoo000mOol01P00Oomoo`00
Ool0009oo`03001oogoo01Qoo`03001oo`0000Ioo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Mo
ogoo02eoo`03G_Moogoo02eoo`03G_Moogoo01Uoo`80015oo`03G_Moogoo02eoo`03G_Moogoo02eo
o`03G_Moogoo00Eoo`03001oogoo04Moo`00?Woo0`0000Aoo`00000001]oo`03001oo`0000Ioo`<0
0=ANm`8007QNm`@004Uoo`00@7oo00<007oo00000Woo00<007ooOol067oo00<007oo00001Woo00<0
07ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol05Goo0P00
5Goo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0Agoo000oOol6000K
Ool00`00Ool00006Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]
Ool00ekgOomoo`0DOol00`00Oomoo`0EOol00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05
Ool00`00Oomoo`17Ool0065oo`03001oogoo00Eoo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Mo
ogoo02eoo`03G_Moogoo02eoo`03G_Moogoo01=oo`03001oogoo01Ioo`03G_Moogoo02eoo`03G_Mo
ogoo02eoo`03G_Moogoo00Eoo`03001oogoo04Moo`00JGoo00<007ooOol0:goo00=NmgooOol0;7oo
00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol04Goo0P006Goo00=NmgooOol0;Goo00=Nmgoo
Ool0;Goo00=NmgooOol01Goo00<007ooOol0Agoo001YOol2000/Ool00ekgOomoo`0/Ool00ekgOomo
o`0]Ool00ekgOomoo`0]Ool00ekgOomoo`0@Ool00`00Oomoo`0IOol00ekgOomoo`0]Ool00ekgOomo
o`0]Ool00ekgOomoo`03Ool30019Ool006Uoo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo
02eoo`03G_Moogoo02eoo`03G_Moogoo00ioo`8001aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03
G_Moogoo00Eoo`03001oogoo04Moo`00JGoo00<007ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0
;Goo00=NmgooOol0;Goo00=NmgooOol03Goo00<007ooOol077oo00=NmgooOol0;Goo00=NmgooOol0
;Goo00=NmgooOol01Goo00<007ooOol0Agoo001YOol00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekg
Oomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`0;Ool2000OOol00ekgOomoo`0]Ool00ekgOomoo`0]
Ool00ekgOomoo`05Ool00`00Oomoo`17Ool006Uoo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Mo
ogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Yoo`03001oogoo01moo`03G_Moogoo02eoo`03G_Mo
ogoo02eoo`03G_Moogoo00Eoo`03001oogoo04Moo`00JGoo0P00;7oo00=NmgooOol0;7oo00=Nmgoo
Ool0;Goo00=NmgooOol0;Goo00=NmgooOol027oo0P008Woo00=NmgooOol0;Goo00=NmgooOol0;Goo
00=NmgooOol00goo0`00BGoo001YOol00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool0
0ekgOomoo`0]Ool00ekgOomoo`07Ool00`00Oomoo`0ROol00ekgOomoo`0]Ool00ekgOomoo`0]Ool0
0ekgOomoo`05Ool00`00Oomoo`17Ool006Uoo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo
02eoo`03G_Moogoo02eoo`03G_Moogoo00Moo`03001oogoo029oo`03G_Moogoo02eoo`03G_Moogoo
02eoo`03G_Moogoo00Eoo`03001oogoo04Moo`00JGoo00<007ooOol0:goo00=NmgooOol0;7oo00=N
mgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo0P009Goo00=NmgooOol0;Goo00=NmgooOol0
;Goo00=NmgooOol01Goo00<007ooOol0Agoo001YOol00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekg
Oomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`03Ool2000WOol00ekgOomoo`0]Ool00ekgOomoo`0]
Ool00ekgOomoo`05Ool00`00Oomoo`17Ool006Uoo`8002aoo`03G_Moogoo02aoo`03G_Moogoo02eo
o`03G_Moogoo02eoo`03G_Moogoo009oo`03001oogoo02Moo`03G_Moogoo02eoo`03G_Moogoo02eo
o`03G_Moogoo00=oo`<004Uoo`00JGoo00<007ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo
00=NmgooOol0;Goo00=NmgooOol00Woo00<007ooOol09goo00=NmgooOol0;Goo00=NmgooOol0;Goo
00=NmgooOol01Goo00<007ooOol0Agoo001YOol00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomo
o`0]Ool00ekgOomoo`0]Ool00ekgOomoo`02000ZOol00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekg
Oomoo`05Ool00`00Oomoo`17Ool005]oo`<000=oo`03001oogoo00Eoo`03001oogoo02]oo`03G_Mo
ogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moo`0002aoo`03G_Moogoo02eoo`03G_Mo
ogoo02eoo`03G_Moogoo00Eoo`03001oogoo04Moo`00Fgoo00<007ooOol00Woo00<007oo00001Woo
00<007ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=Nm`00Ool0;7oo
00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0Agoo001LOol01`00Oomo
ogoo001oo`0000Ioo`<00;UNm`8009=Nm`@004Uoo`00G7oo00L007ooOomoo`00Ool00006Ool00`00
Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0[Ool00`00OomNm`0^Ool00ekg
Oomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`17Ool005]oo`03001oo`00009o
o`03001oo`0000Ioo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02Yo
o`04001oogooG_L^Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`17
Ool005aoo`03001oogoo009oo`03001oogoo00Eoo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Mo
ogoo02eoo`03G_Moogoo02Uoo`05001oogooOomNm`0^Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool0
0ekgOomoo`05Ool00`00Oomoo`17Ool006Uoo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo
02eoo`03G_Moogoo02Qoo`03001oogoo009oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo
02eoo`03G_Moogoo00Eoo`03001oogoo04Moo`00JGoo0P00;7oo00=NmgooOol0;7oo00=NmgooOol0
;Goo00=NmgooOol09goo00<007ooOol00goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0
;Goo00=NmgooOol00goo0`00BGoo001YOol00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]
Ool00ekgOomoo`0WOol00`00Oomoo`03Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]
Ool00ekgOomoo`05Ool00`00Oomoo`17Ool006Uoo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Mo
ogoo02eoo`03G_Moogoo02Ioo`03001oogoo00Aoo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Mo
ogoo02eoo`03G_Moogoo00Eoo`03001oogoo04Moo`00JGoo00<007ooOol0:goo00=NmgooOol0;7oo
00=NmgooOol0;Goo00=NmgooOol09Woo00<007ooOol017oo00=NmgooOol0;7oo00=NmgooOol0;Goo
00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0Agoo001YOol00`00Oomoo`0[Ool00ekgOomo
o`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0UOol00`00Oomoo`05Ool00ekgOomoo`0/Ool00ekgOomo
o`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`17Ool006Uoo`8002aoo`03G_Moogoo
02aoo`03G_Moogoo02eoo`03G_Moogoo02Aoo`03001oogoo00Ioo`03G_Moogoo02aoo`03G_Moogoo
02eoo`03G_Moogoo02eoo`03G_Moogoo00=oo`<004Uoo`00JGoo00<007ooOol0:goo00=NmgooOol0
;7oo00=NmgooOol0;Goo00=NmgooOol08goo00<007ooOol01goo00=NmgooOol0;7oo00=NmgooOol0
;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0Agoo001YOol00`00Oomoo`0[Ool00ekg
Oomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0ROol00`00Oomoo`08Ool00ekgOomoo`0/Ool00ekg
Oomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`17Ool006Uoo`03001oogoo02]o
o`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo025oo`03001oogoo00Uoo`03G_Moogoo02ao
o`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo04Moo`00JGoo00<007oo
Ool0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol08Goo00<007ooOol02Goo00=Nmgoo
Ool0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0Agoo001YOol2
000/Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0POol00`00Oomoo`0:Ool00ekgOomo
o`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`03Ool30019Ool006Uoo`03001oogoo
02]oo`03G_Moogoo01Aooal002Uoo`03G_Moogoo01moo`03001oogoo00]oo`03G_Moogoo02aoo`03
G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo04Moo`00JGoo00<007ooOol0
:goo00=NmgooOol00goo4@0067oo00=NmgooOol017oo2`007Woo00=NmgooOol07goo00<007ooOol0
2goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0
Agoo001LOol30002Ool00`00Oomoo`05Ool00`00Oomoo`0JOolG000YOol00ekgOomoo`0?Ool4000J
Ool00ekgOomoo`0NOol00`00Oomoo`0<Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]
Ool00ekgOomoo`05Ool00`00Oomoo`17Ool005eoo`06001oogoo001oo`001Woo00<007ooOol047oo
2P004Goo00=NmgooOol0;7oo00=NmgooOol04goo1@005Goo00=NmgooOol07Woo00<007ooOol037oo
00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0Agoo
001KOol4000017oo001oo`001Woo0`002Ekg1`00IEkg0`00<Ukg00<005kgG_L0XEkg1000BGoo001K
Ool00`00Ool00002Ool00`00Ool00006Ool00`00Oomoo`05Ool4000ROol00ekgOomoo`0/Ool00ekg
Oomoo`0KOol2000@Ool00ekgOomoo`0MOol00`00Oomoo`0=Ool00ekgOomoo`0/Ool00ekgOomoo`0]
Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`17Ool005aoo`80009oo`03001oo`0000Io
o`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo01eoo`03001oogoo00eoo`03G_Moogoo00io
o`<000]oo`03001oogoo00ioo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Mo
ogoo00Eoo`03001oogoo04Moo`00GGoo00D007ooOomoo`0000Moo`03001oogoo02]oo`03G_Moogoo
02aoo`03G_Moogoo01ioo`8000eoo`03G_Moogoo00]oo`@0009oo`<000Qoo`03001oogoo00ioo`03
G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo04Moo`00
JGoo00<007ooOol0:goo00=NmgooOol0;7oo00=NmgooOol087oo0P002goo00=NmgooOol027oo0`00
2Goo0P001Goo00<007ooOol03goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=N
mgooOol01Goo00<007ooOol0Agoo001YOol2000/Ool00ekgOomoo`0/Ool00ekgOomoo`0ROol20009
Ool00ekgOomoo`06Ool2000>Ool00`00Oomoo`02Ool00`00Oomoo`0?Ool00ekgOomoo`0/Ool00ekg
Oomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`03Ool30019Ool006Uoo`03001oogoo02]oo`03G_Mo
ogoo02aoo`03G_Moogoo02Aoo`8000Moo`03G_Moogoo00Eoo`03001oogoo00moo`04001oogoo000B
Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`17
Ool006Uoo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02Ioo`03001oogoo00Aoo`03G_Mo
ogoo00Aoo`03001oogoo015oo`<0019oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eo
o`03G_Moogoo00Eoo`03001oogoo04Moo`00JGoo00<007ooOol0:goo00=NmgooOol0;7oo00=Nmgoo
Ool09goo0P0017oo00=NmgooOol00goo00<007ooOol09goo00=NmgooOol0;7oo00=NmgooOol0;Goo
00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0Agoo001YOol00`00Oomoo`0[Ool00ekgOomo
o`0/Ool00ekgOomoo`0YOol01@00OomoogooG_L017oo00<007ooOol0:7oo00=NmgooOol0;7oo00=N
mgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0Agoo001YOol2000/Ool00ekg
Oomoo`0/Ool00ekgOomoo`0ZOol01000Oomooekg0Woo0P00:goo00=NmgooOol0;7oo00=NmgooOol0
;Goo00=NmgooOol0;Goo00=NmgooOol00goo0`00BGoo001YOol00`00Oomoo`0[Ool00ekgOomoo`0/
Ool00ekgOomoo`0ZOol01P00OomooekgOol002eoo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Mo
ogoo02eoo`03G_Moogoo00Eoo`03001oogoo04Moo`00JGoo00<007ooOol0:goo00=NmgooOol0;7oo
00=NmgooOol0:goo1000;Woo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=Nmgoo
Ool01Goo00<007ooOol0Agoo001YOol00`00Oomoo`05Ool00`00Oomoo`0SOol00ekgOomoo`0ROol0
0`00Oomoo`07Ool00ekgOomoo`0]Ool00`00Oomoo`0]Ool00ekgOomoo`06Ool00`00Oomoo`0SOol0
0ekgOomoo`0SOol00`00Oomoo`07Ool00ekgOomoo`0]Ool00`00Oomoo`05Ool00`00Oomoo`17Ool0
06Uoo`03001oogoo00Eoo`03001oogoo01ioo`03001oogoo009oo`03G_Moogoo011oo`03001oogoo
00moo`03001oogoo00Moo`03G_Moogoo00=oo`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo
00Moo`03001oogoo00Ioo`03001oogoo02eoo`03G_Moogoo00Ioo`03001oogoo01moo`05001oogoo
OomNm`0COol00`00Oomoo`0?Ool00`00Oomoo`07Ool00ekgOomoo`02Ool00`00Oomoo`0:Ool00`00
Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`17Ool006Uo
ool005H004Uoo`00ogooogoo2Goo003oOoooOol9Ool00?mooomoo`Uoo`00ogooogoo2Goo003oOooo
Ool9Ool00?mooomoo`Uoo`00ogooogoo2Goo003oOoooOol9Ool006Yoo`03001oogoo009oo`04001o
ogooOol3000oOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0aOol5000eOol3001:Ool0
0`00Oomoo`0bOol50002Ool00`00Oomoo`1>Ool006Uoo`03001oo`0000Moo`03001oogoo03ioo`03
001oo`0000Moo`03001oo`0003Aoo`03001oogoo03Eoo`03001oogoo04Uoo`03001oo`0003Eoo`07
001oogooOol007oo0000Cgoo001YOol00`00Ool00008Ool00`00Oomoo`0mOol00`00Ool00009Ool0
0`00Oomoo`0bOol00`00Oomoo`0fOol00`00Oomoo`1:Ool00`00Oomoo`0cOol01`00Oomoogoo001o
o`0004moo`00JGoo00<007oo000027oo00<007ooOol0?Goo00<007oo00001goo0P00=Goo00<007oo
Ool0=Woo00<007ooOol0B7oo0P00=Woo00L007ooOomoo`00Ool0001?Ool006Uoo`03001oo`0000Mo
o`03001oo`0003ioo`03001oo`0000Moo`03001oogoo03Aoo`03001oogoo03Eoo`03001oo`0004Uo
o`03001oogoo03Eoo`07001oogooOol007oo0000Cgoo001ZOol00`00Oomoo`07Ool00`00Oomoo`0n
Ool00`00Oomoo`06Ool3000cOol2000hOol00`00Oomoo`18Ool3000dOol20004Ool00`00Oomoo`1>
Ool00?mooomoo`Uoo`00ogooogoo2Goo003oOoooOol9Ool00?mooomoo`Uoo`00ogooogoo2Goo003o
OoooOol9Ool00?aoo`07001oo`00Ool007oo00000goo0P0000=oo`0000000P000Woo00@007ooOol0
009oo`04001oogoo0003Ool40002Ool40002Ool4003KOol00?aoo`<00004Ool007ooOol40002Ool0
2000Oomoogoo001oo`00Ool20002Ool01000Oomoo`000goo00@007ooOol0009oo`04001oogoo0002
Ool00`00Oomoo`3LOol00?aoo`800003Ool00000009oo`05001oogoo001oo`0200001Goo00000000
Ool010000Woo00@007ooOol000=oo`04001oogoo0002Ool01000Oomoo`000Woo00<007ooOol0g7oo
003lOol200000goo00000002Ool30002Ool20005Ool200001Goo001oogoo00000Woo00D007ooOomo
o`00009oo`04001oogoo0002Ool01000Oomoo`00gWoo003lOol200000goo00000003Ool20003Ool0
0`00Oomoo`0200001Goo001oogoo00000Woo00@007ooOol000=oo`04001oogoo0002Ool01000Oomo
o`000Woo00<007ooOol0g7oo003lOol00`00Oomoo`020003Ool20004Ool30002Ool01000Oomoo`00
0Woo1P0000Eoo`00Oomoo`00009oo`<000=oo`@00=]oo`00ogooogoo2Goo003oOoooOol9Ool00001
\
\>"],
  ImageRangeCache->{{{0, 518}, {171.688, 0}} -> {-1.2922, -88.9104, \
0.00524503, 1.00384}},
  CellTags->{"Bode plot", "i:9"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .33333 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.415627 0.560564 0.410757 0.000999676 [
[.02381 -0.0125 -11 -12.875 ]
[.02381 -0.0125 11 0 ]
[.24688 -0.0125 -11 -12.875 ]
[.24688 -0.0125 11 0 ]
[.41563 -0.0125 -5 -12.875 ]
[.41563 -0.0125 5 0 ]
[.58437 -0.0125 -5 -12.875 ]
[.58437 -0.0125 5 0 ]
[.80744 -0.0125 -5 -12.875 ]
[.80744 -0.0125 5 0 ]
[.97619 -0.0125 -8 -12.875 ]
[.97619 -0.0125 8 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -23 -25.75 ]
[.5 -0.0125 23 -12.875 ]
[-0.0125 .01089 -24 -4.5 ]
[-0.0125 .01089 0 4.5 ]
[-0.0125 .06087 -24 -4.5 ]
[-0.0125 .06087 0 4.5 ]
[-0.0125 .11085 -24 -4.5 ]
[-0.0125 .11085 0 4.5 ]
[-0.0125 .16084 -24 -4.5 ]
[-0.0125 .16084 0 4.5 ]
[-0.0125 .21082 -24 -4.5 ]
[-0.0125 .21082 0 4.5 ]
[-0.0125 .26081 -24 -4.5 ]
[-0.0125 .26081 0 4.5 ]
[-0.0125 .31079 -24 -4.5 ]
[-0.0125 .31079 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .16667 -52 -6.4375 ]
[-0.01875 .16667 -24 6.4375 ]
[.02381 .34583 -11 0 ]
[.02381 .34583 11 12.875 ]
[.24688 .34583 -11 0 ]
[.24688 .34583 11 12.875 ]
[.41563 .34583 -5 0 ]
[.41563 .34583 5 12.875 ]
[.58437 .34583 -5 0 ]
[.58437 .34583 5 12.875 ]
[.80744 .34583 -5 0 ]
[.80744 .34583 5 12.875 ]
[.97619 .34583 -8 0 ]
[.97619 .34583 8 12.875 ]
[ 0 .33333 .125 0 ]
[.5 .34583 -15.4063 12.875 ]
[.5 .34583 15.4063 24.0625 ]
[ 1 0 .125 0 ]
[1.0125 .16667 0 -6.4375 ]
[1.0125 .16667 10 6.4375 ]
[ 0 -0.0005 0 0 ]
[ 1 .33383 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
.75 g
.25 Mabswid
.13534 0 m
.13534 .33333 L
s
.27549 0 m
.27549 .33333 L
s
.41563 0 m
.41563 .33333 L
s
.55577 0 m
.55577 .33333 L
s
.69591 0 m
.69591 .33333 L
s
.83605 0 m
.83605 .33333 L
s
.97619 0 m
.97619 .33333 L
s
0 .01089 m
1 .01089 L
s
0 .06087 m
1 .06087 L
s
0 .11085 m
1 .11085 L
s
0 .16084 m
1 .16084 L
s
0 .21082 m
1 .21082 L
s
0 .26081 m
1 .26081 L
s
0 .31079 m
1 .31079 L
s
0 g
.02381 0 m
.02381 .00625 L
s
gsave
.02381 -0.0125 -72 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.24688 0 m
.24688 .00625 L
s
gsave
.24688 -0.0125 -72 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.41563 0 m
.41563 .00625 L
s
gsave
.41563 -0.0125 -66 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.58437 0 m
.58437 .00625 L
s
gsave
.58437 -0.0125 -66 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.80744 0 m
.80744 .00625 L
s
gsave
.80744 -0.0125 -66 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.97619 0 m
.97619 .00625 L
s
gsave
.97619 -0.0125 -69 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
75.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.001 w
.12252 0 m
.12252 .00375 L
s
.19256 0 m
.19256 .00375 L
s
.29127 0 m
.29127 .00375 L
s
.32879 0 m
.32879 .00375 L
s
.3613 0 m
.3613 .00375 L
s
.38998 0 m
.38998 .00375 L
s
.68308 0 m
.68308 .00375 L
s
.75312 0 m
.75312 .00375 L
s
.85183 0 m
.85183 .00375 L
s
.88936 0 m
.88936 .00375 L
s
.92187 0 m
.92187 .00375 L
s
.95054 0 m
.95054 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -84 -29.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(rad) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
81.000000 13.000000 moveto
(\\220) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(sec) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
0 .01089 m
.00625 .01089 L
s
[(-400)] -0.0125 .01089 1 0 Mshowa
0 .06087 m
.00625 .06087 L
s
[(-350)] -0.0125 .06087 1 0 Mshowa
0 .11085 m
.00625 .11085 L
s
[(-300)] -0.0125 .11085 1 0 Mshowa
0 .16084 m
.00625 .16084 L
s
[(-250)] -0.0125 .16084 1 0 Mshowa
0 .21082 m
.00625 .21082 L
s
[(-200)] -0.0125 .21082 1 0 Mshowa
0 .26081 m
.00625 .26081 L
s
[(-150)] -0.0125 .26081 1 0 Mshowa
0 .31079 m
.00625 .31079 L
s
[(-100)] -0.0125 .31079 1 0 Mshowa
.125 Mabswid
0 .02088 m
.00375 .02088 L
s
0 .03088 m
.00375 .03088 L
s
0 .04088 m
.00375 .04088 L
s
0 .05087 m
.00375 .05087 L
s
0 .07087 m
.00375 .07087 L
s
0 .08086 m
.00375 .08086 L
s
0 .09086 m
.00375 .09086 L
s
0 .10086 m
.00375 .10086 L
s
0 .12085 m
.00375 .12085 L
s
0 .13085 m
.00375 .13085 L
s
0 .14084 m
.00375 .14084 L
s
0 .15084 m
.00375 .15084 L
s
0 .17083 m
.00375 .17083 L
s
0 .18083 m
.00375 .18083 L
s
0 .19083 m
.00375 .19083 L
s
0 .20082 m
.00375 .20082 L
s
0 .22082 m
.00375 .22082 L
s
0 .23082 m
.00375 .23082 L
s
0 .24081 m
.00375 .24081 L
s
0 .25081 m
.00375 .25081 L
s
0 .2708 m
.00375 .2708 L
s
0 .2808 m
.00375 .2808 L
s
0 .2908 m
.00375 .2908 L
s
0 .30079 m
.00375 .30079 L
s
0 .00089 m
.00375 .00089 L
s
0 .32079 m
.00375 .32079 L
s
0 .33078 m
.00375 .33078 L
s
.25 Mabswid
0 0 m
0 .33333 L
s
gsave
-0.01875 .16667 -113 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(deg) show
87.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.02381 .32708 m
.02381 .33333 L
s
gsave
.02381 .34583 -72 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.24688 .32708 m
.24688 .33333 L
s
gsave
.24688 .34583 -72 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.5) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.41563 .32708 m
.41563 .33333 L
s
gsave
.41563 .34583 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.58437 .32708 m
.58437 .33333 L
s
gsave
.58437 .34583 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.80744 .32708 m
.80744 .33333 L
s
gsave
.80744 .34583 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.97619 .32708 m
.97619 .33333 L
s
gsave
.97619 .34583 -69 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
75.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.001 w
.12252 .32958 m
.12252 .33333 L
s
.19256 .32958 m
.19256 .33333 L
s
.29127 .32958 m
.29127 .33333 L
s
.32879 .32958 m
.32879 .33333 L
s
.3613 .32958 m
.3613 .33333 L
s
.38998 .32958 m
.38998 .33333 L
s
.68308 .32958 m
.68308 .33333 L
s
.75312 .32958 m
.75312 .33333 L
s
.85183 .32958 m
.85183 .33333 L
s
.88936 .32958 m
.88936 .33333 L
s
.92187 .32958 m
.92187 .33333 L
s
.95054 .32958 m
.95054 .33333 L
s
.25 Mabswid
0 .33333 m
1 .33333 L
s
gsave
.5 .34583 -76.4063 8.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 19.1875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 15.187500 moveto
 460.000000 15.187500 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 15.187500 lineto
closepath
clip newpath
63.000000 12.500000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 12.500000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(PHASE) show
89.812500 12.500000 moveto
%%IncludeResource: font Helvetica-Bold
%%IncludeFont: Helvetica-Bold
/Helvetica-Bold findfont 8.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Helvetica-Bold
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Helvetica-Bold
%%DocumentSuppliedFonts:
%%DocumentFonts: font Helvetica-Bold
grestore
.99375 .01089 m
1 .01089 L
s
.99375 .06087 m
1 .06087 L
s
.99375 .11085 m
1 .11085 L
s
.99375 .16084 m
1 .16084 L
s
.99375 .21082 m
1 .21082 L
s
.99375 .26081 m
1 .26081 L
s
.99375 .31079 m
1 .31079 L
s
.125 Mabswid
.99625 .02088 m
1 .02088 L
s
.99625 .03088 m
1 .03088 L
s
.99625 .04088 m
1 .04088 L
s
.99625 .05087 m
1 .05087 L
s
.99625 .07087 m
1 .07087 L
s
.99625 .08086 m
1 .08086 L
s
.99625 .09086 m
1 .09086 L
s
.99625 .10086 m
1 .10086 L
s
.99625 .12085 m
1 .12085 L
s
.99625 .13085 m
1 .13085 L
s
.99625 .14084 m
1 .14084 L
s
.99625 .15084 m
1 .15084 L
s
.99625 .17083 m
1 .17083 L
s
.99625 .18083 m
1 .18083 L
s
.99625 .19083 m
1 .19083 L
s
.99625 .20082 m
1 .20082 L
s
.99625 .22082 m
1 .22082 L
s
.99625 .23082 m
1 .23082 L
s
.99625 .24081 m
1 .24081 L
s
.99625 .25081 m
1 .25081 L
s
.99625 .2708 m
1 .2708 L
s
.99625 .2808 m
1 .2808 L
s
.99625 .2908 m
1 .2908 L
s
.99625 .30079 m
1 .30079 L
s
.99625 .00089 m
1 .00089 L
s
.99625 .32079 m
1 .32079 L
s
.99625 .33078 m
1 .33078 L
s
.25 Mabswid
1 0 m
1 .33333 L
s
gsave
1.0125 .16667 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
69.000000 13.000000 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.5 Mabswid
.02381 .32302 m
.03546 .32312 L
.04657 .32322 L
.0572 .32332 L
.06738 .32342 L
.07716 .32352 L
.08656 .32361 L
.0956 .32371 L
.10433 .3238 L
.11275 .3239 L
.12089 .32399 L
.12877 .32408 L
.1364 .32416 L
.1438 .32425 L
.15098 .32433 L
.15795 .32441 L
.16473 .32449 L
.17133 .32457 L
.17775 .32464 L
.18401 .32472 L
.19011 .32479 L
.19606 .32485 L
.20187 .32492 L
.20754 .32498 L
.21309 .32504 L
.21851 .32509 L
.22381 .32514 L
.229 .32519 L
.23409 .32523 L
.23906 .32527 L
.24394 .3253 L
.24872 .32533 L
.25341 .32536 L
.25802 .32538 L
.26253 .32539 L
.26697 .3254 L
.27132 .3254 L
.2756 .32539 L
.2798 .32538 L
.28393 .32536 L
.288 .32533 L
.292 .32529 L
.29593 .32524 L
.2998 .32519 L
.30361 .32512 L
.30736 .32504 L
.31105 .32494 L
.31469 .32484 L
.31828 .32472 L
.32181 .32458 L
Mistroke
.32529 .32442 L
.32872 .32425 L
.33211 .32405 L
.33545 .32384 L
.33874 .32359 L
.34199 .32332 L
.3452 .32302 L
.34837 .32268 L
.35149 .32231 L
.35458 .32189 L
.35762 .32142 L
.36063 .3209 L
.3636 .32032 L
.36654 .31966 L
.36944 .31892 L
.37231 .31809 L
.37514 .31714 L
.37794 .31607 L
.38071 .31483 L
.38345 .31342 L
.38616 .31177 L
.38884 .30986 L
.39149 .30761 L
.39411 .30494 L
.3967 .30176 L
.39926 .29792 L
.4018 .29325 L
.40432 .28757 L
.4068 .28066 L
.40926 .27236 L
.4117 .26268 L
.41411 .25192 L
.4165 .24074 L
.41887 .22996 L
.42121 .22024 L
.42353 .21188 L
.42583 .20489 L
.42811 .19912 L
.43036 .19435 L
.4326 .19039 L
.43481 .18707 L
.43701 .18425 L
.43918 .18183 L
.44134 .17972 L
.44348 .17787 L
.4456 .17621 L
.4477 .17471 L
.44978 .17335 L
.45184 .17208 L
.45389 .17088 L
Mistroke
.45592 .16975 L
.45793 .16865 L
.45993 .16758 L
.46191 .16652 L
.46388 .16545 L
.46583 .16437 L
.46776 .16325 L
.46968 .16207 L
.47158 .16083 L
.47347 .15949 L
.47534 .15804 L
.4772 .15643 L
.47905 .15464 L
.48088 .15262 L
.4827 .1503 L
.4845 .14761 L
.4863 .14446 L
.48807 .14071 L
.48984 .13622 L
.49159 .13078 L
.49333 .1242 L
.49506 .11627 L
.49677 .10695 L
.49848 .09645 L
.50017 .0853 L
.50185 .07433 L
.50352 .06425 L
.50518 .0555 L
.50682 .04816 L
.50846 .04211 L
.51008 .03714 L
.51169 .03306 L
.5133 .02967 L
.51489 .02685 L
.51647 .02447 L
.51804 .02245 L
.5196 .02073 L
.52115 .01924 L
.5227 .01794 L
.52423 .01681 L
.52575 .01582 L
.52726 .01495 L
.52877 .01417 L
.53026 .01349 L
.53175 .01287 L
.53322 .01232 L
.53469 .01183 L
.53615 .01139 L
.5376 .01099 L
.53904 .01064 L
Mistroke
.54047 .01031 L
.5419 .01002 L
.54331 .00976 L
.54472 .00953 L
.54612 .00932 L
.54751 .00913 L
.5489 .00896 L
.55027 .0088 L
.55164 .00867 L
.553 .00855 L
.55436 .00844 L
.5557 .00834 L
.55704 .00826 L
.55837 .00819 L
.5597 .00813 L
.56101 .00808 L
.56232 .00803 L
.56362 .008 L
.56492 .00797 L
.56621 .00795 L
.56749 .00794 L
.56877 .00794 L
.57003 .00794 L
.5713 .00794 L
.57255 .00795 L
.5738 .00797 L
.57504 .00799 L
.57628 .00802 L
.57751 .00805 L
.57873 .00808 L
.57995 .00812 L
.58116 .00816 L
.58237 .0082 L
.58357 .00825 L
.58476 .0083 L
.58595 .00836 L
.58713 .00842 L
.58831 .00848 L
.58948 .00854 L
.59065 .0086 L
.59181 .00867 L
.59296 .00874 L
.59411 .00881 L
.59525 .00888 L
.59639 .00896 L
.59752 .00904 L
.59865 .00912 L
.59977 .0092 L
.60089 .00928 L
.602 .00936 L
Mistroke
.60311 .00945 L
.60421 .00954 L
.60531 .00963 L
.6064 .00971 L
.60749 .00981 L
.60857 .0099 L
.60965 .00999 L
.61072 .01009 L
.61179 .01018 L
.61285 .01028 L
.61391 .01038 L
.61497 .01048 L
.61602 .01057 L
.61706 .01068 L
.6181 .01078 L
.61914 .01088 L
.62017 .01098 L
.6212 .01109 L
.62222 .01119 L
.62324 .0113 L
.62425 .0114 L
.62527 .01151 L
.62627 .01161 L
.62727 .01172 L
.62827 .01183 L
.62927 .01194 L
.63026 .01205 L
.63124 .01216 L
.63222 .01227 L
.6332 .01238 L
.63418 .01249 L
.63515 .0126 L
.63611 .01272 L
.63708 .01283 L
.63803 .01294 L
.63899 .01305 L
.63994 .01317 L
.64089 .01328 L
.64183 .0134 L
.64277 .01351 L
.64371 .01363 L
.64464 .01374 L
.64557 .01386 L
.6465 .01397 L
.64742 .01409 L
.64834 .01421 L
.64925 .01432 L
.65017 .01444 L
.65108 .01456 L
.65198 .01467 L
Mistroke
.65288 .01479 L
.65378 .01491 L
.65468 .01503 L
.65557 .01515 L
.65646 .01526 L
.65734 .01538 L
.65823 .0155 L
.6591 .01562 L
.65998 .01574 L
.66085 .01586 L
.66172 .01598 L
.66259 .01609 L
.66345 .01621 L
.66431 .01633 L
.66517 .01645 L
.66603 .01657 L
.66688 .01669 L
.66773 .01681 L
.66857 .01693 L
.66941 .01705 L
.67025 .01717 L
.67109 .01729 L
.67193 .01741 L
.67276 .01753 L
.67358 .01765 L
.67441 .01777 L
.67523 .01789 L
.67605 .01801 L
.67687 .01813 L
.67768 .01825 L
.6785 .01837 L
.67931 .01849 L
.68011 .01861 L
.68092 .01873 L
.68172 .01885 L
.68251 .01897 L
.68331 .01909 L
.6841 .01921 L
.68489 .01933 L
.68568 .01945 L
.68647 .01957 L
.68725 .01969 L
.68803 .01981 L
.68881 .01993 L
.68959 .02005 L
.69036 .02017 L
.69113 .02029 L
.6919 .02041 L
.69266 .02053 L
.69343 .02065 L
Mistroke
.69419 .02077 L
.69495 .02088 L
.6957 .021 L
.69646 .02112 L
.69721 .02124 L
.69796 .02136 L
.6987 .02148 L
.69945 .0216 L
.70019 .02172 L
.70093 .02184 L
.70167 .02196 L
.70241 .02207 L
.70314 .02219 L
.70387 .02231 L
.7046 .02243 L
.70533 .02255 L
.70605 .02267 L
.70677 .02278 L
.70749 .0229 L
.70821 .02302 L
.70893 .02314 L
.70964 .02326 L
.71035 .02337 L
.71106 .02349 L
.71177 .02361 L
.71248 .02373 L
.71318 .02384 L
.71388 .02396 L
.71458 .02408 L
.71528 .02419 L
.71598 .02431 L
.71667 .02443 L
.71736 .02454 L
.71805 .02466 L
.71874 .02478 L
.71943 .02489 L
.72011 .02501 L
.72079 .02513 L
.72147 .02524 L
.72215 .02536 L
.72283 .02547 L
.7235 .02559 L
.72417 .0257 L
.72485 .02582 L
.72551 .02594 L
.72618 .02605 L
.72685 .02617 L
.72751 .02628 L
.72817 .02639 L
.72883 .02651 L
Mistroke
.72949 .02662 L
.73015 .02674 L
.7308 .02685 L
.73145 .02697 L
.7321 .02708 L
.73275 .02719 L
.7334 .02731 L
.73405 .02742 L
.73469 .02753 L
.73533 .02765 L
.73598 .02776 L
.73661 .02787 L
.73725 .02799 L
.73789 .0281 L
.73852 .02821 L
.73915 .02832 L
.73979 .02844 L
.74041 .02855 L
.74104 .02866 L
.74167 .02877 L
.74229 .02888 L
.74292 .029 L
.74354 .02911 L
.74416 .02922 L
.74477 .02933 L
.74539 .02944 L
.74601 .02955 L
.74662 .02966 L
.74723 .02977 L
.74784 .02988 L
.74845 .02999 L
.74906 .0301 L
.74966 .03021 L
.75027 .03032 L
.75087 .03043 L
.75147 .03054 L
.75207 .03065 L
.75267 .03076 L
.75327 .03087 L
.75386 .03098 L
.75446 .03109 L
.75505 .0312 L
.75564 .03131 L
.75623 .03142 L
.75682 .03152 L
.7574 .03163 L
.75799 .03174 L
.75857 .03185 L
.75915 .03196 L
.75974 .03206 L
Mistroke
.76032 .03217 L
.76089 .03228 L
.76147 .03239 L
.76205 .03249 L
.76262 .0326 L
.76319 .03271 L
.76377 .03281 L
.76434 .03292 L
.7649 .03303 L
.76547 .03313 L
.76604 .03324 L
.7666 .03334 L
.76717 .03345 L
.76773 .03355 L
.76829 .03366 L
.76885 .03377 L
.76941 .03387 L
.76997 .03398 L
.77052 .03408 L
.77108 .03418 L
.77163 .03429 L
.77218 .03439 L
.77273 .0345 L
.77328 .0346 L
.77383 .03471 L
.77438 .03481 L
.77492 .03491 L
.77547 .03502 L
.77601 .03512 L
.77656 .03522 L
.7771 .03533 L
.77764 .03543 L
.77817 .03553 L
.77871 .03563 L
.77925 .03574 L
.77978 .03584 L
.78032 .03594 L
.78085 .03604 L
.78138 .03615 L
.78191 .03625 L
.78244 .03635 L
.78297 .03645 L
.7835 .03655 L
.78402 .03665 L
.78455 .03675 L
.78507 .03685 L
.78559 .03695 L
.78612 .03706 L
.78664 .03716 L
.78716 .03726 L
Mistroke
.78767 .03736 L
.78819 .03746 L
.78871 .03756 L
.78922 .03766 L
.78973 .03775 L
.79025 .03785 L
.79076 .03795 L
.79127 .03805 L
.79178 .03815 L
.79229 .03825 L
.79279 .03835 L
.7933 .03845 L
.79381 .03855 L
.79431 .03864 L
.79481 .03874 L
.79532 .03884 L
.79582 .03894 L
.79632 .03903 L
.79682 .03913 L
.79731 .03923 L
.79781 .03933 L
.79831 .03942 L
.7988 .03952 L
.79929 .03962 L
.79979 .03971 L
.80028 .03981 L
.80077 .03991 L
.80126 .04 L
.80175 .0401 L
.80224 .04019 L
.80272 .04029 L
.80321 .04039 L
.8037 .04048 L
.80418 .04058 L
.80466 .04067 L
.80514 .04077 L
.80563 .04086 L
.80611 .04096 L
.80659 .04105 L
.80706 .04115 L
.80754 .04124 L
.80802 .04133 L
.80849 .04143 L
.80897 .04152 L
.80944 .04162 L
.80991 .04171 L
.81039 .0418 L
.81086 .0419 L
.81133 .04199 L
.8118 .04208 L
Mistroke
.81226 .04218 L
.81273 .04227 L
.8132 .04236 L
.81366 .04245 L
.81413 .04255 L
.81459 .04264 L
.81506 .04273 L
.81552 .04282 L
.81598 .04291 L
.81644 .04301 L
.8169 .0431 L
.81736 .04319 L
.81781 .04328 L
.81827 .04337 L
.81873 .04346 L
.81918 .04355 L
.81964 .04364 L
.82009 .04373 L
.82054 .04382 L
.82099 .04391 L
.82145 .044 L
.8219 .04409 L
.82235 .04418 L
.82279 .04427 L
.82324 .04436 L
.82369 .04445 L
.82413 .04454 L
.82458 .04463 L
.82502 .04472 L
.82547 .04481 L
.82591 .0449 L
.82635 .04499 L
.82679 .04508 L
.82723 .04516 L
.82767 .04525 L
.82811 .04534 L
.82855 .04543 L
.82899 .04552 L
.82942 .0456 L
.82986 .04569 L
.83029 .04578 L
.83073 .04587 L
.83116 .04595 L
.83159 .04604 L
.83202 .04613 L
.83246 .04622 L
.83289 .0463 L
.83331 .04639 L
.83374 .04648 L
.83417 .04656 L
Mistroke
.8346 .04665 L
.83503 .04673 L
.83545 .04682 L
.83588 .04691 L
.8363 .04699 L
.83672 .04708 L
.83715 .04716 L
.83757 .04725 L
.83799 .04733 L
.83841 .04742 L
.83883 .0475 L
.83925 .04759 L
.83967 .04767 L
.84008 .04776 L
.8405 .04784 L
.84092 .04793 L
.84133 .04801 L
.84175 .04809 L
.84216 .04818 L
.84258 .04826 L
.84299 .04834 L
.8434 .04843 L
.84381 .04851 L
.84422 .04859 L
.84463 .04868 L
.84504 .04876 L
.84545 .04884 L
.84586 .04893 L
.84627 .04901 L
.84667 .04909 L
.84708 .04917 L
.84748 .04926 L
.84789 .04934 L
.84829 .04942 L
.84869 .0495 L
.8491 .04958 L
.8495 .04967 L
.8499 .04975 L
.8503 .04983 L
.8507 .04991 L
.8511 .04999 L
.8515 .05007 L
.8519 .05015 L
.85229 .05023 L
.85269 .05032 L
.85308 .0504 L
.85348 .05048 L
.85387 .05056 L
.85427 .05064 L
.85466 .05072 L
Mistroke
.85505 .0508 L
.85545 .05088 L
.85584 .05096 L
.85623 .05104 L
.85662 .05112 L
.85701 .0512 L
.8574 .05127 L
.85779 .05135 L
.85817 .05143 L
.85856 .05151 L
.85895 .05159 L
.85933 .05167 L
.85972 .05175 L
.8601 .05183 L
.86049 .0519 L
.86087 .05198 L
.86125 .05206 L
.86164 .05214 L
.86202 .05222 L
.8624 .05229 L
.86278 .05237 L
.86316 .05245 L
.86354 .05253 L
.86392 .0526 L
.86429 .05268 L
.86467 .05276 L
.86505 .05284 L
.86543 .05291 L
.8658 .05299 L
.86618 .05307 L
.86655 .05314 L
.86692 .05322 L
.8673 .0533 L
.86767 .05337 L
.86804 .05345 L
.86842 .05352 L
.86879 .0536 L
.86916 .05368 L
.86953 .05375 L
.8699 .05383 L
.87027 .0539 L
.87063 .05398 L
.871 .05405 L
.87137 .05413 L
.87174 .0542 L
.8721 .05428 L
.87247 .05435 L
.87283 .05443 L
.8732 .0545 L
.87356 .05458 L
Mistroke
.87392 .05465 L
.87429 .05472 L
.87465 .0548 L
.87501 .05487 L
.87537 .05495 L
.87573 .05502 L
.87609 .05509 L
.87645 .05517 L
.87681 .05524 L
.87717 .05531 L
.87753 .05539 L
.87789 .05546 L
.87824 .05553 L
.8786 .05561 L
.87896 .05568 L
.87931 .05575 L
.87967 .05582 L
.88002 .0559 L
.88037 .05597 L
.88073 .05604 L
.88108 .05611 L
.88143 .05619 L
.88178 .05626 L
.88214 .05633 L
.88249 .0564 L
.88284 .05647 L
.88319 .05654 L
.88354 .05662 L
.88389 .05669 L
.88423 .05676 L
.88458 .05683 L
.88493 .0569 L
.88528 .05697 L
.88562 .05704 L
.88597 .05711 L
.88631 .05718 L
.88666 .05725 L
.887 .05733 L
.88735 .0574 L
.88769 .05747 L
.88803 .05754 L
.88838 .05761 L
.88872 .05768 L
.88906 .05775 L
.8894 .05782 L
.88974 .05789 L
.89008 .05795 L
.89042 .05802 L
.89076 .05809 L
.8911 .05816 L
Mistroke
.89144 .05823 L
.89177 .0583 L
.89211 .05837 L
.89245 .05844 L
.89278 .05851 L
.89312 .05858 L
.89346 .05864 L
.89379 .05871 L
.89412 .05878 L
.89446 .05885 L
.89479 .05892 L
.89513 .05899 L
.89546 .05905 L
.89579 .05912 L
.89612 .05919 L
.89645 .05926 L
.89678 .05932 L
.89711 .05939 L
.89744 .05946 L
.89777 .05953 L
.8981 .05959 L
.89843 .05966 L
.89876 .05973 L
.89909 .0598 L
.89941 .05986 L
.89974 .05993 L
.90007 .06 L
.90039 .06006 L
.90072 .06013 L
.90104 .06019 L
.90137 .06026 L
.90169 .06033 L
.90202 .06039 L
.90234 .06046 L
.90266 .06053 L
.90299 .06059 L
.90331 .06066 L
.90363 .06072 L
.90395 .06079 L
.90427 .06085 L
.90459 .06092 L
.90491 .06098 L
.90523 .06105 L
.90555 .06111 L
.90587 .06118 L
.90619 .06124 L
.9065 .06131 L
.90682 .06137 L
.90714 .06144 L
.90746 .0615 L
Mistroke
.90777 .06157 L
.90809 .06163 L
.9084 .0617 L
.90872 .06176 L
.90903 .06182 L
.90935 .06189 L
.90966 .06195 L
.90997 .06202 L
.91029 .06208 L
.9106 .06214 L
.91091 .06221 L
.91122 .06227 L
.91153 .06233 L
.91185 .0624 L
.91216 .06246 L
.91247 .06252 L
.91278 .06259 L
.91309 .06265 L
.91339 .06271 L
.9137 .06277 L
.91401 .06284 L
.91432 .0629 L
.91463 .06296 L
.91493 .06302 L
.91524 .06309 L
.91555 .06315 L
.91585 .06321 L
.91616 .06327 L
.91646 .06333 L
.91677 .0634 L
.91707 .06346 L
.91738 .06352 L
.91768 .06358 L
.91798 .06364 L
.91829 .0637 L
.91859 .06377 L
.91889 .06383 L
.91919 .06389 L
.91949 .06395 L
.91979 .06401 L
.92009 .06407 L
.9204 .06413 L
.92069 .06419 L
.92099 .06425 L
.92129 .06431 L
.92159 .06438 L
.92189 .06444 L
.92219 .0645 L
.92249 .06456 L
.92278 .06462 L
Mistroke
.92308 .06468 L
.92338 .06474 L
.92367 .0648 L
.92397 .06486 L
.92426 .06492 L
.92456 .06498 L
.92485 .06504 L
.92515 .06509 L
.92544 .06515 L
.92574 .06521 L
.92603 .06527 L
.92632 .06533 L
.92662 .06539 L
.92691 .06545 L
.9272 .06551 L
.92749 .06557 L
.92778 .06563 L
.92807 .06569 L
.92836 .06574 L
.92865 .0658 L
.92894 .06586 L
.92923 .06592 L
.92952 .06598 L
.92981 .06604 L
.9301 .06609 L
.93039 .06615 L
.93068 .06621 L
.93096 .06627 L
.93125 .06633 L
.93154 .06638 L
.93182 .06644 L
.93211 .0665 L
.9324 .06656 L
.93268 .06662 L
.93297 .06667 L
.93325 .06673 L
.93354 .06679 L
.93382 .06684 L
.9341 .0669 L
.93439 .06696 L
.93467 .06702 L
.93495 .06707 L
.93524 .06713 L
.93552 .06719 L
.9358 .06724 L
.93608 .0673 L
.93636 .06736 L
.93664 .06741 L
.93692 .06747 L
.9372 .06752 L
Mistroke
.93748 .06758 L
.93776 .06764 L
.93804 .06769 L
.93832 .06775 L
.9386 .0678 L
.93888 .06786 L
.93916 .06792 L
.93943 .06797 L
.93971 .06803 L
.93999 .06808 L
.94026 .06814 L
.94054 .06819 L
.94082 .06825 L
.94109 .0683 L
.94137 .06836 L
.94164 .06841 L
.94192 .06847 L
.94219 .06852 L
.94247 .06858 L
.94274 .06863 L
.94301 .06869 L
.94329 .06874 L
.94356 .0688 L
.94383 .06885 L
.9441 .06891 L
.94438 .06896 L
.94465 .06902 L
.94492 .06907 L
.94519 .06912 L
.94546 .06918 L
.94573 .06923 L
.946 .06929 L
.94627 .06934 L
.94654 .06939 L
.94681 .06945 L
.94708 .0695 L
.94735 .06955 L
.94762 .06961 L
.94789 .06966 L
.94815 .06971 L
.94842 .06977 L
.94869 .06982 L
.94896 .06987 L
.94922 .06993 L
.94949 .06998 L
.94975 .07003 L
.95002 .07009 L
.95029 .07014 L
.95055 .07019 L
.95082 .07024 L
Mistroke
.95108 .0703 L
.95135 .07035 L
.95161 .0704 L
.95187 .07045 L
.95214 .07051 L
.9524 .07056 L
.95266 .07061 L
.95293 .07066 L
.95319 .07071 L
.95345 .07077 L
.95371 .07082 L
.95397 .07087 L
.95423 .07092 L
.9545 .07097 L
.95476 .07103 L
.95502 .07108 L
.95528 .07113 L
.95554 .07118 L
.9558 .07123 L
.95606 .07128 L
.95631 .07133 L
.95657 .07139 L
.95683 .07144 L
.95709 .07149 L
.95735 .07154 L
.95761 .07159 L
.95786 .07164 L
.95812 .07169 L
.95838 .07174 L
.95863 .07179 L
.95889 .07184 L
.95915 .07189 L
.9594 .07194 L
.95966 .07199 L
.95991 .07204 L
.96017 .07209 L
.96042 .07214 L
.96068 .07219 L
.96093 .07225 L
.96118 .0723 L
.96144 .07234 L
.96169 .07239 L
.96194 .07244 L
.9622 .07249 L
.96245 .07254 L
.9627 .07259 L
.96295 .07264 L
.96321 .07269 L
.96346 .07274 L
.96371 .07279 L
Mistroke
.96396 .07284 L
.96421 .07289 L
.96446 .07294 L
.96471 .07299 L
.96496 .07304 L
.96521 .07309 L
.96546 .07314 L
.96571 .07318 L
.96596 .07323 L
.96621 .07328 L
.96646 .07333 L
.9667 .07338 L
.96695 .07343 L
.9672 .07348 L
.96745 .07352 L
.96769 .07357 L
.96794 .07362 L
.96819 .07367 L
.96843 .07372 L
.96868 .07377 L
.96893 .07381 L
.96917 .07386 L
.96942 .07391 L
.96966 .07396 L
.96991 .07401 L
.97015 .07405 L
.9704 .0741 L
.97064 .07415 L
.97088 .0742 L
.97113 .07424 L
.97137 .07429 L
.97161 .07434 L
.97186 .07439 L
.9721 .07443 L
.97234 .07448 L
.97259 .07453 L
.97283 .07457 L
.97307 .07462 L
.97331 .07467 L
.97355 .07472 L
.97379 .07476 L
.97403 .07481 L
.97427 .07486 L
.97451 .0749 L
.97475 .07495 L
.97499 .075 L
.97523 .07504 L
.97547 .07509 L
.97571 .07513 L
.97595 .07518 L
Mistroke
.97619 .07523 L
Mfstroke
0 0 m
1 0 L
1 .33333 L
0 .33333 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[110]:=",
  ImageSize->{519, 172.688},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000870000[1000`40O003h00Oogooogoo2Goo003o
OoooOol9Ool00?mooomoo`Uoo`00ogooogoo2Goo003oOolHOol00`00Oomoo`3]Ool00?moo`Ioo`<0
009oo`@0009oo`<000Eoo`03001oogoo009oo`8000Aoo`80009oo`<00=eoo`00ogoo1goo00@007oo
Oomoo`<0009oo`04001oogoo0005Ool00`00Oomoo`04Ool01000Oomoo`0017oo00<007ooOol0gGoo
003oOol7Ool00`00Oomoo`03Ool01000Oomoo`000Woo00<007ooOol00goo00<007ooOol00goo00@0
07ooOomoo`<0009oo`03001oogoo0=eoo`00ogoo1Woo10000Woo0P000goo0`001Woo00<007ooOol0
0Woo0P000Woo0`000Woo0`00gGoo003oOolCOol00`00Oomoo`04Ool00`00Oomoo`3[Ool00?mooa9o
o`8000Moo`03001oogoo0>Yoo`00ogooogoo2Goo003oOoooOol9Ool00?mooomoo`Uoo`00ogooogoo
2Goo003oOoooOol9Ool00?mooomoo`Uoo`00ogooogoo2Goo001`Ool00`00Oomoo`02Ool01000Oomo
ogoo0`00?goo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0<Goo1@00=Goo0`00BWoo00<0
07ooOol0<Woo1@000Woo00<007ooOol0B7oo001_Ool00`00Ool00007Ool00`00Oomoo`0nOol00`00
Ool00007Ool00`00Ool0000dOol00`00Oomoo`0eOol00`00Oomoo`19Ool00`00Ool0000eOol01`00
Oomoogoo001oo`0004Uoo`00Kgoo00<007oo000027oo00<007ooOol0?Goo00<007oo00002Goo00<0
07ooOol0<Woo00<007ooOol0=Woo00<007ooOol0BWoo00<007ooOol0<goo00L007ooOomoo`00Ool0
0019Ool006moo`03001oo`0000Qoo`03001oogoo03eoo`03001oo`0000Moo`8003Eoo`03001oogoo
03Ioo`03001oogoo04Qoo`8003Ioo`07001oogooOol007oo0000BGoo001_Ool00`00Ool00007Ool0
0`00Ool0000nOol00`00Ool00007Ool00`00Oomoo`0dOol00`00Oomoo`0eOol00`00Ool00019Ool0
0`00Oomoo`0eOol01`00Oomoogoo001oo`0004Uoo`00L7oo00<007ooOol01goo00<007ooOol0?Woo
00<007ooOol01Woo0`00<goo0P00>7oo00<007ooOol0B7oo0`00=7oo0P0017oo00<007ooOol0B7oo
003oOoooOol9Ool00?mooomoo`Uoo`00ogooogoo2Goo003oOoooOol9Ool00?mooomoo`Uoo`00ogoo
ogoo2Goo001_Oooo001F0013Ool006moo`03001oogoo00Eoo`03001oogoo01ioo`03001oogoo009o
o`03G_Moogoo011oo`03001oogoo00moo`03001oogoo00Moo`03G_Moogoo00=oo`03001oogoo00Uo
o`03001oogoo00Qoo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo02eoo`03G_Moogoo00Io
o`03001oogoo01moo`05001oogooOomNm`0COol00`00Oomoo`0?Ool00`00Oomoo`07Ool00ekgOomo
o`02Ool00`00Oomoo`0:Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomo
o`05Ool00`00Oomoo`11Ool005eoo`<0009oo`03001oogoo009oo`03001oogoo00Eoo`03001oogoo
00Eoo`03001oogoo02=oo`03G_Moogoo029oo`03001oogoo00Moo`03G_Moogoo02eoo`03001oogoo
02eoo`03G_Moogoo00Ioo`03001oogoo02=oo`03G_Moogoo02=oo`03001oogoo00Moo`03G_Moogoo
02eoo`03001oogoo00Eoo`03001oogoo045oo`00GWoo00H007ooOol007oo0002Ool00`00Ool00006
Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0WOolL000IOol00ekg
Oomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`11Ool005Moo`<0009oo`@00004
Ool007oo0002Ool00`00Ool00006Ool3002aG_L3000KG_L:001eG_L40013Ool005aoo`03001oo`00
009oo`03001oo`00009oo`03001oo`0000Ioo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo
02eoo`03G_Moogoo029oo`8000Uoo`03G_Moogoo01]oo`P000Uoo`03G_Moogoo02eoo`03G_Moogoo
02eoo`03G_Moogoo00Eoo`03001oogoo045oo`00GGoo0P000Woo00<007oo00000Woo00<007oo0000
1Woo00<007ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol08Goo0P002Woo00=N
mgooOol08goo1`000Woo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0
@Goo001NOol01@00Oomoogoo000017oo00<007ooOol01Goo0P00;7oo00=NmgooOol0;7oo00=Nmgoo
Ool0;Goo00=NmgooOol087oo00<007ooOol02Woo00=NmgooOol0:Goo1`00;7oo00=NmgooOol0;Goo
00=NmgooOol00goo0`00@goo001_Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool0
0ekgOomoo`0OOol00`00Oomoo`0;Ool00ekgOomoo`0/Ool015kgOomoogoo1P009Woo00=NmgooOol0
;Goo00=NmgooOol01Goo00<007ooOol0@Goo001_Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekg
Oomoo`0]Ool00ekgOomoo`0OOol00`00Oomoo`0;Ool00ekgOomoo`0/Ool00ekgOomoo`07Ool6000P
Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`11Ool006moo`8002aoo`03G_Moogoo02ao
o`03G_Moogoo02eoo`03G_Moogoo01ioo`03001oogoo00aoo`03G_Moogoo02aoo`03G_Moogoo00ao
o`L001Yoo`03G_Moogoo02eoo`03G_Moogoo00=oo`<004=oo`00Kgoo00<007ooOol0:goo00=Nmgoo
Ool0;7oo00=NmgooOol0;Goo00=NmgooOol07Woo00<007ooOol037oo00=NmgooOol0;7oo00=Nmgoo
Ool04Woo1P005Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0@Goo001_Ool00`00Oomo
o`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0MOol00`00Oomoo`0=Ool00ekgOomo
o`0/Ool00ekgOomoo`0GOol6000@Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`11Ool0
06moo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo01aoo`03001oogoo
00ioo`03G_Moogoo02aoo`03G_Moogoo01aoo`H000]oo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03
001oogoo045oo`00Kgoo0P00;7oo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol077oo00<0
07ooOol03Woo00=NmgooOol0;7oo00=NmgooOol08Woo1@001Woo00=NmgooOol0;Goo00=NmgooOol0
0goo0`00@goo001_Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0L
Ool00`00Oomoo`0>Ool00ekgOomoo`0/Ool00ekgOomoo`0WOol500000gooG_Moo`0^Ool00ekgOomo
o`05Ool00`00Oomoo`11Ool006moo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03
G_Moogoo01aoo`03001oogoo00ioo`03G_Moogoo02aoo`03G_Moogoo02]oo`H002aoo`03G_Moogoo
00Eoo`03001oogoo045oo`00Kgoo0P00;7oo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0
77oo00<007ooOol03Woo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol01P009goo00=Nmgoo
Ool00goo0`00@goo001_Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomo
o`0KOol00`00Oomoo`0?Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool6000ROol0
0ekgOomoo`05Ool00`00Oomoo`11Ool005aoo`8000Aoo`03001oogoo009oo`03001oogoo00Eoo`03
001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo01]oo`03001oogoo00moo`03
G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo00Yoo`H001eoo`03G_Moogoo00Eoo`03001oogoo
045oo`00GWoo00H007ooOol007oo0002Ool00`00Ool00006Ool00`00Oomoo`0[Ool00ekgOomoo`0/
Ool00ekgOomoo`0]Ool00ekgOomoo`0KOol00`00Oomoo`0?Ool00ekgOomoo`0/Ool00ekgOomoo`0]
Ool00ekgOomoo`0?Ool6000HOol00ekgOomoo`05Ool00`00Oomoo`11Ool005Moo`<000=oo`03001o
ogoo00=oo`06001oogoo001oo`001Woo0`00Z5kg00<005kgG_L0QEkg1P0065kg1000@goo001NOol0
0`00Oomoo`020003Ool00`00Ool00006Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]
Ool00ekgOomoo`0KOol00`00Oomoo`0?Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0I
Ool6000>Ool00ekgOomoo`05Ool00`00Oomoo`11Ool005aoo`03001oo`00009oo`03001oogoo009o
o`03001oo`0000Ioo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo01]o
o`03001oogoo00moo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo01ioo`H000Uoo`03G_Mo
ogoo00Eoo`03001oogoo045oo`00GGoo00@007ooOomoo`<000=oo`03001oogoo00Eoo`8002aoo`03
G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo01Yoo`03001oogoo011oo`03G_Moogoo02aoo`03
G_Moogoo02eoo`03G_Moogoo02=oo`H000Aoo`03G_Moogoo00=oo`<004=oo`00Kgoo00<007ooOol0
:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol06Woo00<007ooOol047oo00=NmgooOol0
;7oo00=NmgooOol0;Goo00=NmgooOol0:7oo1P001goo00<007ooOol0@Goo001_Ool00`00Oomoo`0[
Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0JOol00`00Oomoo`0@Ool00ekgOomoo`0/
Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`11Ool006moo`8002ao
o`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo01Yoo`03001oogoo011oo`03G_Moogoo02ao
o`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00=oo`<004=oo`00Kgoo00<007ooOol0:goo
00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol06Woo00<007ooOol047oo00=NmgooOol0;7oo
00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0@Goo001_Ool00`00Oomo
o`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0JOol00`00Oomoo`0@Ool00ekgOomo
o`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`11Ool006moo`03
001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo01Yoo`03001oogoo011oo`03
G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo045oo`00
Kgoo0P00;7oo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol06Goo00<007ooOol04Goo00=N
mgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol00goo0`00@goo001_Ool00`00
Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0IOol00`00Oomoo`0AOol00ekg
Oomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`11Ool006mo
o`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo01Uoo`03001oogoo015o
o`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo045o
o`00Kgoo0P00;7oo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol06Goo00<007ooOol04Goo
00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol00goo0`00@goo001_Ool0
0`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0HOol00`00Oomoo`0BOol0
0ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`11Ool0
05aoo`8000Aoo`03001oogoo009oo`03001oogoo00Eoo`03001oogoo02]oo`03G_Moogoo02aoo`03
G_Moogoo02eoo`03G_Moogoo01Qoo`03001oogoo019oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03
G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo045oo`00GWoo00H007ooOol007oo0002Ool00`00
Ool00006Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0HOol00`00
Oomoo`0BOol00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00
Oomoo`11Ool005Moo`<000=oo`07001oogooOol007oo00000Woo00<007oo00001Woo0`00YEkg00<0
05kgG_L0YUkg1000@goo001NOol01P00Oomoo`00Ool0009oo`03001oo`0000Ioo`03001oogoo02]o
o`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo01Qoo`03001oogoo019oo`03G_Moogoo02ao
o`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo045oo`00G7oo00<007oo
00000Woo00<007oo00000Woo00<007oo00001Woo00<007ooOol0:goo00=NmgooOol0;7oo00=Nmgoo
Ool0;Goo00=NmgooOol067oo00<007ooOol04Woo00=NmgooOol0;7oo00=NmgooOol0;Goo00=Nmgoo
Ool0;Goo00=NmgooOol01Goo00<007ooOol0@Goo001MOol00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`05Ool2000/Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0GOol00`00Oomo
o`0COol00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`03Ool30013Ool0
06moo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo01Moo`03001oogoo
01=oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo
045oo`00Kgoo00<007ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol05goo00<0
07ooOol04goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<0
07ooOol0@Goo001_Ool2000/Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0GOol00`00
Oomoo`0COol00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`03Ool30013
Ool006moo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo01Ioo`03001o
ogoo01Aoo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001o
ogoo045oo`00Kgoo00<007ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol05Woo
00<007ooOol057oo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo
00<007ooOol0@Goo001_Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomo
o`0FOol00`00Oomoo`0DOol00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomo
o`05Ool00`00Oomoo`11Ool006moo`8002aoo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo
01Ioo`03001oogoo01Aoo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo
00=oo`<004=oo`00Kgoo00<007ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0
5Goo00<007ooOol05Goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol0
1Goo00<007ooOol0@Goo001_Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekg
Oomoo`0DOol00`00Oomoo`0FOol00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekg
Oomoo`05Ool00`00Oomoo`11Ool006moo`8002aoo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Mo
ogoo01Aoo`03001oogoo01Ioo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Mo
ogoo00=oo`<004=oo`00Kgoo00<007ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=Nmgoo
Ool04Woo0P006Goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo
00<007ooOol0@Goo0012Ool2000HOol30003Ool00`00Oomoo`02Ool00`00Oomoo`05Ool00`00Oomo
o`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0BOol00`00Oomoo`0HOol00ekgOomo
o`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`11Ool004Aoo`03
001oogoo01Eoo`03001oogoo009oo`03001oo`00009oo`03001oo`0000Ioo`03001oogoo02]oo`03
G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo015oo`03001oogoo01Uoo`03G_Moogoo02aoo`03
G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo045oo`00>7oo0`000Woo0P00
0goo0`004Woo0`000goo00<007ooOol00goo00H007ooOol007oo0006Ool3002LG_L2002`G_L40013
Ool003Moo`06001oogoo001oo`0017oo00@007ooOol001Qoo`04001oogooOol20003Ool00`00Ool0
0006Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0=Ool2000NOol0
0ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`11Ool0
03Moo`05001oogoo001oo`030002Ool01000Oomoo`005goo00<007oo00000Woo00<007ooOol00Woo
00<007oo00001Woo00<007ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol02goo
0P0087oo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007oo
Ool0@Goo000hOol3000017oo000000000goo0`0067oo00@007ooOomoo`<000=oo`03001oogoo00Eo
o`8002aoo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo00Uoo`<0025oo`03G_Moogoo02ao
o`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00=oo`<004=oo`00>Woo00<007ooOol0<Woo
00<007ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol027oo00<007ooOol08Woo
00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0@Goo
000iOol2000dOol00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`06Ool2
000UOol00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomo
o`11Ool006moo`8002aoo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo00Ioo`03001oogoo
02Aoo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00=oo`<004=oo`00
Kgoo00<007ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol017oo0P009goo00=N
mgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0@Goo001_
Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`03Ool00`00Oomoo`0W
Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`11
Ool006moo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo00=oo`03001o
ogoo02Moo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001o
ogoo045oo`00Kgoo0P00;7oo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol00goo00<007oo
Ool09goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol00goo0`00@goo
001_Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`02Ool00`00Oomo
o`0XOol00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomo
o`11Ool006moo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`05G_MoogooOol0000[
Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`11
Ool006moo`8002aoo`03G_Moogoo02aoo`03G_Moogoo02eoo`05G_MoogooOol0000[Ool00ekgOomo
o`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`03Ool30013Ool006moo`03001oogoo
02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`04G_Moogoo000/Ool00ekgOomoo`0/Ool00ekgOomo
o`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`11Ool005aoo`<000=oo`03001oogoo
009oo`03001oogoo00Eoo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`04G_Moogoo
000/Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomo
o`11Ool005aoo`03001oogoo009oo`03001oo`00009oo`03001oo`0000Ioo`03001oogoo02]oo`03
G_Moogoo02aoo`03G_Moogoo02eoo`04G_Moogoo000/Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool0
0ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`11Ool005Moo`<000=oo`07001oogooOol007oo
00000Woo00<007oo00001Woo0`00SEkg00<005kgG_L0_Ukg1000@goo001MOol01`00Oomoogoo001o
o`00009oo`03001oo`0000Ioo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`04G_Mo
ogoo000/Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00
Oomoo`11Ool005aoo`03001oo`00009oo`03001oo`00009oo`03001oo`0000Ioo`03001oogoo02]o
o`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moo`0002eoo`03G_Moogoo02aoo`03G_Moogoo02eo
o`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo045oo`00GGoo00<007ooOol00Woo00<007oo
Ool00Woo00<007ooOol01Goo0P00;7oo00=NmgooOol0;7oo00=NmgooOol0;Goo00=Nmgoo0000;Goo
00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol00goo0`00@goo001_Ool0
0`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOol0000]Ool00ekgOomoo`0/Ool0
0ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`11Ool006moo`03001oogoo
02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_L007oo02eoo`03G_Moogoo02aoo`03G_Moogoo
02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo045oo`00Kgoo0P00;7oo00=NmgooOol0
;7oo00=NmgooOol0;Goo00=Nm`00Ool0;Goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0
;Goo00=NmgooOol00goo0`00@goo001_Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0]
Ool00ekg001oo`0]Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05
Ool00`00Oomoo`11Ool006moo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02eoo`03001o
ogoo02eoo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001o
ogoo045oo`00Kgoo00<007ooOol0:goo00=NmgooOol0;7oo00=NmgooOol0;Goo00<007ooOol0;Goo
00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0@Goo
001_Ool2000/Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00`00Oomoo`0]Ool00ekgOomoo`0/Ool0
0ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`03Ool30013Ool006moo`03001oogoo02]oo`03
G_Moogoo02aoo`03G_Moogoo02eoo`03001oogoo02eoo`03G_Moogoo02aoo`03G_Moogoo02eoo`03
G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo045oo`00Kgoo00<007ooOol0:goo00=NmgooOol0
;7oo00=NmgooOol0;7oo00<005kgOol0;Woo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0
;Goo00=NmgooOol01Goo00<007ooOol0@Goo001_Ool2000/Ool00ekgOomoo`0/Ool00ekgOomoo`0/
Ool00`00G_Moo`0^Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`03
Ool30013Ool006moo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02aoo`03001Nmgoo02io
o`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo045o
o`00Fgoo1@000Woo00<007ooOol00Woo00<007ooOol01Goo00<007ooOol0:goo00=NmgooOol0;7oo
00=NmgooOol0;7oo00<005kgOol0;Woo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo
00=NmgooOol01Goo00<007ooOol0@Goo001MOol01`00Oomoogoo001oo`00009oo`03001oo`0000Io
o`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02aoo`03001Nmgoo02ioo`03G_Moogoo02ao
o`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo045oo`00Egoo0`000goo
00<007ooOol00goo00H007ooOol007oo0006Ool30029G_L00`00G_MNm`32G_L40013Ool005eoo`04
001oogooOol20003Ool00`00Ool00006Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0/
Ool00`00G_Moo`0^Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05
Ool00`00Oomoo`11Ool005eoo`05001oogooOol00004Ool00`00Ool00006Ool00`00Oomoo`0[Ool0
0ekgOomoo`0/Ool00ekgOomoo`0[Ool00`00OomNm`0_Ool00ekgOomoo`0/Ool00ekgOomoo`0]Ool0
0ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`11Ool005aoo`8000=oo`<000=oo`03001oogoo
00Eoo`8002aoo`03G_Moogoo02aoo`03G_Moogoo02]oo`03001ooekg02moo`03G_Moogoo02aoo`03
G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00=oo`<004=oo`00Kgoo00<007ooOol0:goo00=N
mgooOol0;7oo00=NmgooOol0:goo00<007ooG_L0;goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=N
mgooOol0;Goo00=NmgooOol01Goo00<007ooOol0@Goo001_Ool00`00Oomoo`0[Ool00ekgOomoo`0/
Ool00ekgOomoo`0ZOol01000Oomooekg;goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0
;Goo00=NmgooOol01Goo00<007ooOol0@Goo001_Ool2000/Ool00ekgOomoo`0/Ool00ekgOomoo`0Z
Ool01000Oomooekg;goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol0
0goo0`00@goo001_Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0ZOol01000Oomooekg
;goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0
@Goo001_Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0YOol01@00OomoogooG_L0;goo
00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0@Goo
001_Ool00`00Oomoo`0[Ool00ekgOomoo`0/Ool00ekgOomoo`0YOol01@00OomoogooG_L0;goo00=N
mgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0@Goo001_
Ool2000/Ool00ekgOomoo`0/Ool00ekgOomoo`0XOol00`00Oomoo`02Ool00ekgOomoo`0]Ool00ekg
Oomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`03Ool30013Ool006moo`03001o
ogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02Qoo`03001oogoo009oo`03G_Moogoo02eoo`03G_Mo
ogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo045oo`00Kgoo
00<007ooOol0:goo00=NmgooOol0;7oo00=NmgooOol09goo00<007ooOol00goo00=NmgooOol0;Goo
00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0@Goo
001_Ool2000/Ool00ekgOomoo`0/Ool00ekgOomoo`0VOol00`00Oomoo`04Ool00ekgOomoo`0]Ool0
0ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`03Ool30013Ool006moo`03
001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02Ioo`03001oogoo00Aoo`03G_Moogoo02eoo`03
G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo045oo`00
Fgoo1@000Woo00<007ooOol00Woo00<007ooOol01Goo00<007ooOol0:goo00=NmgooOol0;7oo00=N
mgooOol09Goo0P001Woo00=NmgooOol0;Goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=NmgooOol0
;Goo00=NmgooOol01Goo00<007ooOol0@Goo001MOol01`00Oomoogoo001oo`00009oo`03001oo`00
00Ioo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo02Aoo`03001oogoo00Ioo`03G_Moogoo
02eoo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001oogoo
045oo`00Egoo0`000goo00L007ooOomoo`00Ool00002Ool00`00Ool00006Ool3001oG_L2003=G_L4
0013Ool005eoo`07001oogooOol007oo00000Woo00<007oo00001Woo00<007ooOol0:goo00=Nmgoo
Ool0;7oo00=NmgooOol087oo0P002goo00=NmgooOol0;Goo00=NmgooOol0;7oo00=NmgooOol0;Goo
00=NmgooOol0;Goo00=NmgooOol01Goo00<007ooOol0@Goo001MOol01`00Oomoogoo001oo`00009o
o`03001oo`0000Ioo`03001oogoo02]oo`03G_Moogoo02aoo`03G_Moogoo01eoo`<000eoo`03G_Mo
ogoo02eoo`03G_Moogoo02aoo`03G_Moogoo02eoo`03G_Moogoo02eoo`03G_Moogoo00Eoo`03001o
ogoo045oo`00G7oo0P0017oo00<007ooOol00Woo00<007ooOol01Goo0P00;7oo00=NmgooOol0;7oo
00=NmgooOol05goo1P0047oo00=NmgooOol0;Goo00=NmgooOol0;7oo00=NmgooOol0;Goo00=Nmgoo
Ool0;Goo00=NmgooOol00goo0`00@goo001_Ool00`00Oomoo`05Oom_000FOol00ekgOomoo`0]Ool0
0ekgOomoo`0/Ool00ekgOomoo`0]Ool00ekgOomoo`0]Ool00ekgOomoo`05Ool00`00Oomoo`11Ool0
06moo`03001oogoo00Eoo`03001oogoo02=oo`03G_Moogoo029oo`03001oogoo00Moo`03G_Moogoo
02eoo`03001oogoo02eoo`03G_Moogoo00Ioo`03001oogoo02=oo`03G_Moogoo02=oo`03001oogoo
00Moo`03G_Moogoo02eoo`03001oogoo00Eoo`03001oogoo045oo`00Kgoo0P001Woo00<007ooOol0
7Woo00<007ooOol00Woo00=NmgooOol047oo00<007ooOol03goo00<007ooOol01goo00=NmgooOol0
0goo00<007ooOol02Goo00<007ooOol027oo00<007ooOol01goo00<007ooOol01Woo00<007ooOol0
;Goo00=NmgooOol01Woo00<007ooOol07goo00D007ooOomooekg01=oo`03001oogoo00moo`03001o
ogoo00Moo`03G_Moogoo009oo`03001oogoo00Yoo`03001oogoo00Qoo`03001oogoo00Moo`03001o
ogoo00Ioo`03001oogoo00=oo`<004=oo`00Kgooo`00EP00@goo003oOoooOol9Ool00?mooomoo`Uo
o`00ogooogoo2Goo003oOoooOol9Ool00?mooomoo`Uoo`00ogooogoo2Goo003oOoooOol9Ool00?mo
oomoo`Uoo`00L7oo00<007ooOol00Woo00@007ooOomoo`<003moo`03001oogoo009oo`03001oogoo
009oo`03001oogoo035oo`D003Eoo`<004Yoo`03001oogoo039oo`D0009oo`03001oogoo04Qoo`00
Kgoo00<007oo00001goo00<007ooOol0?Woo00<007oo00001goo00<007oo0000=7oo00<007ooOol0
=Goo00<007ooOol0BGoo00<007oo0000=Goo00L007ooOomoo`00Ool00019Ool006moo`03001oo`00
00Qoo`03001oogoo03eoo`03001oo`0000Uoo`03001oogoo039oo`03001oogoo03Ioo`03001oogoo
04Yoo`03001oogoo03=oo`07001oogooOol007oo0000BGoo001_Ool00`00Ool00008Ool00`00Oomo
o`0mOol00`00Ool00007Ool2000eOol00`00Oomoo`0fOol00`00Oomoo`18Ool2000fOol01`00Oomo
ogoo001oo`0004Uoo`00Kgoo00<007oo00001goo00<007oo0000?Woo00<007oo00001goo00<007oo
Ool0=7oo00<007ooOol0=Goo00<007oo0000BGoo00<007ooOol0=Goo00L007ooOomoo`00Ool00019
Ool0071oo`03001oogoo00Moo`03001oogoo03ioo`03001oogoo00Ioo`<003=oo`8003Qoo`03001o
ogoo04Qoo`<003Aoo`8000Aoo`03001oogoo04Qoo`00ogooogoo2Goo003oOoooOol9Ool00?mooomo
o`Uoo`00ogooogoo2Goo003oOoooOol9Ool00?mooomoo`Uoo`00ogoo3Goo00<007ooOol00Woo00H0
07ooOol007oo0003Ool2000017oo000000000Woo1000hGoo003oOol=Ool00`00Oomoo`02Ool01000
Oomoo`000Woo100000=oo`0000000Woo00<007oo0000i7oo003oOol=Ool30002Ool40002Ool01000
Oomoo`000goo0`0000=oo`00Ool0hgoo003oOol=Ool01P00Oomoo`00Ool0009oo`03001oogoo00<0
00=oo`8000=oo`03001oogoo0>9oo`00ogoo3Goo00H007ooOol007oo0002Ool01000Oomoogoo0P00
0goo00H007oo000007oo003TOol00?moo`eoo`<0009oo`04001oogoo0003Ool20003Ool30002Ool4
003QOol00?mooomoo`Uoo`00ogooogoo2Goo0000\
\>"],
  ImageRangeCache->{{{0, 518}, {171.688, 0}} -> {-1.32367, -499.13, \
0.00524503, 2.94113}},
  CellTags->{"Bode plot", "i:9"}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Nyquist Plot", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"Nyquist Plot", "i:10"}],

Cell["\<\
The Nyquist plot of G over the frequency range -20 to +20 radians per second \
is obtained from:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"Nyquist Plot", "i:10"}],

Cell[BoxData[
    \(G[s_] := \(\((s + 10)\)\ \((s + 4)\)\)\/\(\((s + 5)\)\ \((s\^2 + 2\ s + \
2)\)\ \((s\^2 + 1\ s + 1)\)\)\)], "Input",
  CellLabel->"In[112]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Nyquist Plot", "i:10"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Nyquist[G, s, \(-20\), \(+20\)]\)], "Input",
  CellLabel->"In[113]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Nyquist Plot", "i:10"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.433906 0.135597 0.308889 0.0651981 [
[.02711 -0.0125 -6 -9 ]
[.02711 -0.0125 6 0 ]
[.16271 -0.0125 -6 -9 ]
[.16271 -0.0125 6 0 ]
[.29831 -0.0125 -6 -9 ]
[.29831 -0.0125 6 0 ]
[.43391 -0.0125 -3 -9 ]
[.43391 -0.0125 3 0 ]
[.5695 -0.0125 -3 -9 ]
[.5695 -0.0125 3 0 ]
[.7051 -0.0125 -3 -9 ]
[.7051 -0.0125 3 0 ]
[.8407 -0.0125 -3 -9 ]
[.8407 -0.0125 3 0 ]
[.9763 -0.0125 -3 -9 ]
[.9763 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -17 -21.875 ]
[.5 -0.0125 17 -9 ]
[-0.0125 .0481 -12 -4.5 ]
[-0.0125 .0481 0 4.5 ]
[-0.0125 .17849 -12 -4.5 ]
[-0.0125 .17849 0 4.5 ]
[-0.0125 .30889 -6 -4.5 ]
[-0.0125 .30889 0 4.5 ]
[-0.0125 .43928 -6 -4.5 ]
[-0.0125 .43928 0 4.5 ]
[-0.0125 .56968 -6 -4.5 ]
[-0.0125 .56968 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -46.25 -6.4375 ]
[-0.01875 .30902 -12 6.4375 ]
[ 0 .61803 .125 0 ]
[.5 .63053 -5 0 ]
[.5 .63053 5 12.875 ]
[ 1 0 .125 0 ]
[1.0125 .30902 0 -6.4375 ]
[1.0125 .30902 10 6.4375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 .5 r
.25 Mabswid
.16271 0 m
.16271 .61803 L
s
.29831 0 m
.29831 .61803 L
s
.43391 0 m
.43391 .61803 L
s
.5695 0 m
.5695 .61803 L
s
.7051 0 m
.7051 .61803 L
s
.8407 0 m
.8407 .61803 L
s
0 .0481 m
1 .0481 L
s
0 .17849 m
1 .17849 L
s
0 .30889 m
1 .30889 L
s
0 .43928 m
1 .43928 L
s
0 .56968 m
1 .56968 L
s
0 g
.02711 0 m
.02711 .00625 L
s
[(-3)] .02711 -0.0125 0 1 Mshowa
.16271 0 m
.16271 .00625 L
s
[(-2)] .16271 -0.0125 0 1 Mshowa
.29831 0 m
.29831 .00625 L
s
[(-1)] .29831 -0.0125 0 1 Mshowa
.43391 0 m
.43391 .00625 L
s
[(0)] .43391 -0.0125 0 1 Mshowa
.5695 0 m
.5695 .00625 L
s
[(1)] .5695 -0.0125 0 1 Mshowa
.7051 0 m
.7051 .00625 L
s
[(2)] .7051 -0.0125 0 1 Mshowa
.8407 0 m
.8407 .00625 L
s
[(3)] .8407 -0.0125 0 1 Mshowa
.9763 0 m
.9763 .00625 L
s
[(4)] .9763 -0.0125 0 1 Mshowa
.125 Mabswid
.05423 0 m
.05423 .00375 L
s
.08135 0 m
.08135 .00375 L
s
.10847 0 m
.10847 .00375 L
s
.13559 0 m
.13559 .00375 L
s
.18983 0 m
.18983 .00375 L
s
.21695 0 m
.21695 .00375 L
s
.24407 0 m
.24407 .00375 L
s
.27119 0 m
.27119 .00375 L
s
.32543 0 m
.32543 .00375 L
s
.35255 0 m
.35255 .00375 L
s
.37967 0 m
.37967 .00375 L
s
.40679 0 m
.40679 .00375 L
s
.46103 0 m
.46103 .00375 L
s
.48815 0 m
.48815 .00375 L
s
.51526 0 m
.51526 .00375 L
s
.54238 0 m
.54238 .00375 L
s
.59662 0 m
.59662 .00375 L
s
.62374 0 m
.62374 .00375 L
s
.65086 0 m
.65086 .00375 L
s
.67798 0 m
.67798 .00375 L
s
.73222 0 m
.73222 .00375 L
s
.75934 0 m
.75934 .00375 L
s
.78646 0 m
.78646 .00375 L
s
.81358 0 m
.81358 .00375 L
s
.86782 0 m
.86782 .00375 L
s
.89494 0 m
.89494 .00375 L
s
.92206 0 m
.92206 .00375 L
s
.94918 0 m
.94918 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -78 -25.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Re) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
75.000000 13.000000 moveto
(@) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
87.000000 13.000000 moveto
(D) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
0 .0481 m
.00625 .0481 L
s
[(-4)] -0.0125 .0481 1 0 Mshowa
0 .17849 m
.00625 .17849 L
s
[(-2)] -0.0125 .17849 1 0 Mshowa
0 .30889 m
.00625 .30889 L
s
[(0)] -0.0125 .30889 1 0 Mshowa
0 .43928 m
.00625 .43928 L
s
[(2)] -0.0125 .43928 1 0 Mshowa
0 .56968 m
.00625 .56968 L
s
[(4)] -0.0125 .56968 1 0 Mshowa
.125 Mabswid
0 .0807 m
.00375 .0807 L
s
0 .11329 m
.00375 .11329 L
s
0 .14589 m
.00375 .14589 L
s
0 .21109 m
.00375 .21109 L
s
0 .24369 m
.00375 .24369 L
s
0 .27629 m
.00375 .27629 L
s
0 .34149 m
.00375 .34149 L
s
0 .37409 m
.00375 .37409 L
s
0 .40669 m
.00375 .40669 L
s
0 .47188 m
.00375 .47188 L
s
0 .50448 m
.00375 .50448 L
s
0 .53708 m
.00375 .53708 L
s
0 .0155 m
.00375 .0155 L
s
0 .60228 m
.00375 .60228 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -107.25 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Im) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
75.250000 13.000000 moveto
(@) show
81.250000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
87.250000 13.000000 moveto
(D) show
93.250000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
.02711 .61178 m
.02711 .61803 L
s
.16271 .61178 m
.16271 .61803 L
s
.29831 .61178 m
.29831 .61803 L
s
.43391 .61178 m
.43391 .61803 L
s
.5695 .61178 m
.5695 .61803 L
s
.7051 .61178 m
.7051 .61803 L
s
.8407 .61178 m
.8407 .61803 L
s
.9763 .61178 m
.9763 .61803 L
s
.125 Mabswid
.05423 .61428 m
.05423 .61803 L
s
.08135 .61428 m
.08135 .61803 L
s
.10847 .61428 m
.10847 .61803 L
s
.13559 .61428 m
.13559 .61803 L
s
.18983 .61428 m
.18983 .61803 L
s
.21695 .61428 m
.21695 .61803 L
s
.24407 .61428 m
.24407 .61803 L
s
.27119 .61428 m
.27119 .61803 L
s
.32543 .61428 m
.32543 .61803 L
s
.35255 .61428 m
.35255 .61803 L
s
.37967 .61428 m
.37967 .61803 L
s
.40679 .61428 m
.40679 .61803 L
s
.46103 .61428 m
.46103 .61803 L
s
.48815 .61428 m
.48815 .61803 L
s
.51526 .61428 m
.51526 .61803 L
s
.54238 .61428 m
.54238 .61803 L
s
.59662 .61428 m
.59662 .61803 L
s
.62374 .61428 m
.62374 .61803 L
s
.65086 .61428 m
.65086 .61803 L
s
.67798 .61428 m
.67798 .61803 L
s
.73222 .61428 m
.73222 .61803 L
s
.75934 .61428 m
.75934 .61803 L
s
.78646 .61428 m
.78646 .61803 L
s
.81358 .61428 m
.81358 .61803 L
s
.86782 .61428 m
.86782 .61803 L
s
.89494 .61428 m
.89494 .61803 L
s
.92206 .61428 m
.92206 .61803 L
s
.94918 .61428 m
.94918 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
gsave
.5 .63053 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
69.000000 13.000000 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.99375 .0481 m
1 .0481 L
s
.99375 .17849 m
1 .17849 L
s
.99375 .30889 m
1 .30889 L
s
.99375 .43928 m
1 .43928 L
s
.99375 .56968 m
1 .56968 L
s
.125 Mabswid
.99625 .0807 m
1 .0807 L
s
.99625 .11329 m
1 .11329 L
s
.99625 .14589 m
1 .14589 L
s
.99625 .21109 m
1 .21109 L
s
.99625 .24369 m
1 .24369 L
s
.99625 .27629 m
1 .27629 L
s
.99625 .34149 m
1 .34149 L
s
.99625 .37409 m
1 .37409 L
s
.99625 .40669 m
1 .40669 L
s
.99625 .47188 m
1 .47188 L
s
.99625 .50448 m
1 .50448 L
s
.99625 .53708 m
1 .53708 L
s
.99625 .0155 m
1 .0155 L
s
.99625 .60228 m
1 .60228 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
gsave
1.0125 .30902 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
69.000000 13.000000 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 .30889 m
1 .30889 L
s
.43391 0 m
.43391 .61803 L
s
0 0 0 r
.5 Mabswid
.43391 .30888 m
.43391 .30888 L
.43392 .30887 L
.43392 .30887 L
.43393 .30886 L
.43395 .30884 L
.43398 .30881 L
.43405 .30873 L
.43424 .30853 L
.43441 .30833 L
.43475 .30787 L
.43499 .30749 L
.43531 .30683 L
.43551 .30629 L
.43569 .30563 L
.43577 .30523 L
.4358 .30499 L
.43583 .30473 L
.43586 .30447 L
.43587 .30422 L
.43588 .3039 L
.43587 .30358 L
.43585 .30326 L
.43582 .30288 L
.43577 .3025 L
.43571 .30212 L
.43561 .30164 L
.43546 .30107 L
.43507 .2999 L
.43441 .29843 L
.43332 .29656 L
.43189 .29462 L
.42964 .29213 L
.42665 .28942 L
.42282 .28652 L
.41067 .27959 L
.40048 .27525 L
.38489 .27016 L
.37475 .26756 L
.36183 .26489 L
.34736 .26262 L
.33202 .26092 L
.31348 .25971 L
.29361 .25937 L
.26884 .2602 L
.23867 .26305 L
.22223 .26546 L
.20338 .26898 L
.16702 .27827 L
.13022 .29166 L
Mistroke
.09661 .30864 L
.06529 .33114 L
.04155 .35729 L
.02773 .38473 L
.02381 .41791 L
.03598 .45692 L
.07026 .49843 L
.1174 .53152 L
.1861 .56249 L
.23121 .57661 L
.284 .58876 L
.38556 .60174 L
.48491 .60332 L
.57177 .5962 L
.6564 .58113 L
.69948 .56993 L
.73635 .55812 L
.80035 .53157 L
.85494 .50058 L
.89001 .47434 L
.91976 .44557 L
.94279 .41584 L
.95807 .38867 L
.96788 .36349 L
.97343 .34091 L
.97619 .31503 L
.97537 .29067 L
.97139 .26709 L
.96341 .24154 L
.95194 .21709 L
.93765 .19446 L
.91552 .1676 L
.88357 .13812 L
.84449 .11049 L
.79933 .08571 L
.74304 .06205 L
.68032 .04254 L
.60068 .02576 L
.55134 .01917 L
.50369 .01532 L
.40915 .01472 L
.35468 .01869 L
.30462 .02536 L
.20952 .04747 L
.16226 .06449 L
.12438 .0824 L
.07279 .11713 L
.03827 .15687 L
.02502 .19084 L
.02581 .22613 L
Mistroke
.04107 .25979 L
.06917 .28995 L
.10227 .3124 L
.13501 .32813 L
.168 .33981 L
.19761 .34755 L
.2281 .35325 L
.2577 .35676 L
.28292 .35822 L
.30397 .35835 L
.32073 .3577 L
.33673 .35641 L
.35265 .3544 L
.36509 .35227 L
.38698 .34702 L
.4014 .34217 L
.41126 .33791 L
.42458 .32999 L
.42875 .32651 L
.43132 .32384 L
.43289 .32184 L
.43405 .32001 L
.43488 .31834 L
.43536 .31705 L
.43554 .31642 L
.43566 .31589 L
.43575 .31539 L
.43579 .31513 L
.43582 .31489 L
.43586 .31449 L
.43587 .31416 L
.43588 .31383 L
.43587 .31365 L
.43587 .3135 L
.43585 .31323 L
.43583 .31298 L
.4358 .31278 L
.43577 .31258 L
.43569 .31216 L
.43561 .31183 L
.43529 .31091 L
.43512 .31054 L
.43498 .31028 L
.43472 .30986 L
.43422 .30922 L
.43405 .30904 L
.43398 .30897 L
.43395 .30894 L
.43393 .30892 L
.43392 .30891 L
Mistroke
.43392 .3089 L
.43391 .3089 L
.43391 .3089 L
Mfstroke
0 1 0 r
.29831 .30889 m
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
s
1 0 0 r
.29831 .30889 m
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
.29831 .30889 L
s
0 0 1 r
.43391 .30889 m
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
.43391 .30889 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[113]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool00:9oo`8000=oo`8000=oo`80079oo`00XWoo00<007ooOol017oo00D007ooOomoo`00079oo`00
Tgoo0`0000Aoo`00Oomoo`8000Ioo`03001oogoo009oo`<000=oo`03001oogoo071oo`00U7oo00H0
07ooOol007oo0008Ool01@00Oomoogoo00000Woo00D007ooOomoo`00079oo`00U7oo0`000Woo0`00
1Woo00D007ooOomoo`00009oo`05001oogooOol0001bOol009Aoo`05001oogoo001oo`030006Ool0
0`00Oomoo`02Ool30003Ool00`00Oomoo`1`Ool009Aoo`04001oogoo000:Ool00`00Oomoo`08Ool0
0`00Oomoo`1`Ool009=oo`@000]oo`8000Qoo`80079oo`00ogoo8Goo003oOolQOol00?moob5oo`00
>Woo0P0077oo0`006Woo1@006Goo00<007ooOol06Goo1@006Woo0`006goo0P007Goo0`004Woo000l
Ool00`00Oomoo`0IOol00`00Oomoo`0LOol00`00Oomoo`0HOol00`00Ool0000LOol00`00Oomoo`0J
Ool00`00Oomoo`0MOol00`00Oomoo`0KOol00`00Oomoo`0AOol003Eoo`<000=oo`03001oogoo01Eo
o`<000=oo`03001oogoo01Eoo`<000=oo`03001oogoo01Qoo`03001oo`0001aoo`03001oogoo01]o
o`03001oogoo01]oo`03001oogoo01Yoo`@0019oo`00?7oo00<007ooOol06Woo00<007ooOol06goo
00<007ooOol067oo00<007oo000077oo00<007ooOol06goo00<007ooOol077oo00<007ooOol06Goo
00<007oo00004goo000jOol00`00Ool0000KOol00`00Ool0000LOol00`00Oomoo`0HOol00`00Ool0
000LOol00`00Oomoo`0JOol00`00Ool0000KOol00`00Ool0000LOol2000COol003]oo`03001oogoo
01]oo`03001oogoo01Yoo`8001]oo`03001oogoo01Yoo`8001eoo`03001oogoo01]oo`03001oogoo
01aoo`03001oogoo015oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol003=o
omh000moo`00<goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo
00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo
00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo
00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo
00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo
00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo
00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo
00<007ooOol00goo00<007ooOol00goo00<007ooOol00Woo00<007ooOol03Goo000cOol00`00Oomo
o`03Ool00`00Oomoo`0KOol00`00Oomoo`0KOol00`00Oomoo`0KOol00`00Oomoo`0KOol00`00Oomo
o`0KOol00`00Oomoo`0KOol00`00Oomoo`0KOol00`00Oomoo`02Ool00`00Oomoo`0=Ool003=oo`03
001oogoo025oo`0300moogoo01]oo`0300moogoo015ooa0001Qoo`0300moogoo01]oo`0300moogoo
01]oo`0300moogoo021oo`03001oogoo00eoo`00<goo0P008Woo00<03gooOol06goo00<03gooOol0
27oo2@002Woo00<007ooOol00goo5`0000=oo`0?Ool077oo00<03gooOol06goo00<03gooOol087oo
00<007ooOol03Goo000cOol00`00Oomoo`0QOol00`0?Oomoo`0KOol00`0?Oomoo`02Ool6000COol0
0`00Oomoo`0JOol6000IOol00`0?Oomoo`0KOol00`0?Oomoo`0POol00`00Oomoo`0=Ool003=oo`03
001oogoo025oo`0300moogoo01]oo`D001Uoo`03001oogoo01]oo`0300moogoo009oo`D001Aoo`03
00moogoo01]oo`0300moogoo021oo`03001oogoo00eoo`00<goo00<007ooOol08Goo00<03gooOol0
5goo100000<03gooOol06goo00<007ooOol06goo00<03gooOol01goo100047oo00<03gooOol06goo
00<03gooOol087oo00<007ooOol03Goo000cOol00`00Oomoo`0QOol00`0?Oomoo`0COol40004Ool0
0`0?Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0;Ool5000;Ool00`0?Oomoo`0KOol00`0?Oomo
o`0POol00`00Oomoo`0=Ool002eoo`<000=oo`03001oogoo025oo`0300moogoo00moo`@000Qoo`03
00moogoo01]oo`03001oogoo01]oo`0300moogoo011oo`@000Moo`0300moogoo01]oo`0300moogoo
021oo`03001oogoo00eoo`00;Woo00<007ooOol00Woo00<007ooOol08Goo00<03gooOol02goo1000
37oo00<03gooOol06goo00<007ooOol06goo00<03gooOol057oo10000goo00<03gooOol06goo00<0
3gooOol087oo00<007ooOol03Goo000WOol30002Ool40003Ool3000[00l4000^00l00`0000l03`0f
00l4000o00l2000?Ool002aoo`03001oo`0000Aoo`03001oogoo025oo`0300moogoo00=oo`@001Ao
o`0300moogoo01]oo`03001oogoo01]oo`0300moogoo01]oo`0400l00000000JOol00`0?Oomoo`0P
Ool00`00Oomoo`0=Ool002eoo`8000Aoo`03001oogoo025oo`0300moo`0000<001Qoo`0300moogoo
01]oo`03001oogoo01]oo`0300moogoo01]oo`0400moogooOol4000FOol00`0?Oomoo`0POol00`00
Oomoo`0=Ool002ioo`03001oogoo009oo`03001oogoo025oo`8001aoo`0300moogoo01]oo`03001o
ogoo01]oo`0300moogoo01]oo`0300moogoo00Eoo`<001=oo`0300moogoo021oo`03001oogoo00eo
o`00<goo00<007ooOol07goo0P0000<03gooOol06goo00<03gooOol06goo00<007ooOol06goo00<0
3gooOol06goo00<03gooOol027oo0P004Goo00<03gooOol087oo00<007ooOol03Goo000cOol00`00
Oomoo`0MOol20002Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0K
Ool00`0?Oomoo`0:Ool2000?Ool00`0?Oomoo`0POol00`00Oomoo`0=Ool003=oo`03001oogoo01]o
o`8000Aoo`0300moogoo01]oo`0300moogoo01]oo`03001oogoo01]oo`0300moogoo01]oo`0300mo
ogoo00aoo`<000aoo`0300moogoo021oo`03001oogoo00eoo`00<goo0P006Woo0P001Woo00<03goo
Ool06goo00<03gooOol06goo00<007ooOol06goo00<03gooOol06goo00<03gooOol03goo0P002Woo
00<03gooOol087oo00<007ooOol03Goo000cOol00`00Oomoo`0GOol20008Ool00`0?Oomoo`0KOol0
0`0?Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0AOol20008Ool00`0?Oomo
o`0POol00`00Oomoo`0=Ool003=oo`03001oogoo01Ioo`03001oogoo00Qoo`0300moogoo01]oo`03
00moogoo01]oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo01=oo`8000Ioo`0300moogoo
021oo`03001oogoo00eoo`00<goo00<007ooOol057oo0P002goo00<03gooOol06goo00<03gooOol0
6goo00<007ooOol06goo00<03gooOol06goo00<03gooOol05Goo0P0017oo00<03gooOol087oo00<0
07ooOol03Goo000cOol00`00Oomoo`0COol00`00Oomoo`0;Ool00`0?Oomoo`0KOol00`0?Oomoo`0K
Ool00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0GOol01@00Oomoogoo00l08Woo00<007oo
Ool03Goo000cOol00`00Oomoo`0AOol2000>Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`00Oomo
o`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0HOol200000goo00moo`0QOol00`00Oomoo`0=Ool003=o
o`03001oogoo011oo`03001oogoo00ioo`0300moogoo01]oo`0300moogoo01]oo`03001oogoo01]o
o`0300moogoo01]oo`0300moogoo01Yoo`80029oo`03001oogoo00eoo`00<goo0P003goo0P004Goo
00<03gooOol06goo00<03gooOol06goo00<007ooOol06goo00<03gooOol06goo00<03gooOol06goo
00<03`00Ool087oo00<007ooOol03Goo000cOol00`00Oomoo`0=Ool00`00Oomoo`0AOol00`0?Oomo
o`0KOol00`0?Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol0100?Ool0
00007goo00<007ooOol03Goo000cOol00`00Oomoo`0<Ool00`00Oomoo`0BOol00`0?Oomoo`0KOol0
0`0?Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol01@0?Oomoogoo0000
7Woo00<007ooOol03Goo000cOol00`00Oomoo`0;Ool00`00Oomoo`0COol00`0?Oomoo`0KOol00`0?
Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`02Ool2000L
Ool00`00Oomoo`0=Ool003=oo`03001oogoo00]oo`03001oogoo01=oo`0300moogoo01]oo`0300mo
ogoo01]oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo00Aoo`03001o
ogoo01Uoo`03001oogoo00eoo`00<goo00<007ooOol02Woo00<007ooOol057oo00<03gooOol06goo
00<03gooOol06goo00<007ooOol06goo00<03gooOol06goo00<03gooOol06goo00<03gooOol01Goo
0P006Goo00<007ooOol03Goo000cOol00`00Oomoo`09Ool00`00Oomoo`0EOol00`0?Oomoo`0KOol0
0`0?Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`07Ool0
0`00Oomoo`0FOol00`00Oomoo`0=Ool003=oo`8000Uoo`03001oogoo01Ioo`0300moogoo01]oo`03
00moogoo01]oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo00Qoo`03
001oogoo01Eoo`03001oogoo00eoo`00<goo00<007ooOol027oo00<007ooOol05Woo00<03gooOol0
6goo00<03gooOol06goo00<007ooOol06goo00<03gooOol06goo00<03gooOol06goo00<03gooOol0
2Goo00<007ooOol057oo00<007ooOol03Goo000cOol00`00Oomoo`07Ool00`00Oomoo`0GOol00`0?
Oomoo`0KOol00`0?Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?
Oomoo`0:Ool2000DOol00`00Oomoo`0=Ool003=oo`03001oogoo00Ioo`03001oogoo01Qoo`0300mo
ogoo01]oo`0300moogoo01]oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`0300mo
ogoo00aoo`03001oogoo015oo`03001oogoo00eoo`00<goo00<007ooOol01Woo00<007ooOol067oo
00<03gooOol06goo00<03gooOol06goo00<007ooOol06goo00<03gooOol06goo00<03gooOol06goo
00<03gooOol03Goo00<007ooOol047oo00<007ooOol03Goo000cOol00`00Oomoo`05Ool00`00Oomo
o`0IOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomo
o`0KOol00`0?Oomoo`0>Ool00`00Oomoo`0?Ool00`00Oomoo`0=Ool002aoo`<000Aoo`03001oogoo
00Eoo`03001oogoo01Uoo`0300moogoo01]oo`0300moogoo01]oo`03001oogoo01]oo`0300moogoo
01]oo`0300moogoo01]oo`0300moogoo00moo`03001oogoo00ioo`03001oogoo00eoo`00;7oo00<0
07ooOol017oo00<007ooOol017oo00<007ooOol06Woo00<03gooOol06goo00<03gooOol06goo00<0
07ooOol06goo00<03gooOol06goo00<03gooOol06goo00<03gooOol047oo00<007ooOol03Goo00<0
07ooOol03Goo000WOol30003Ool00`00Oomoo`03Ool3000400l00`0000l03`1F00l00`0000l03`1[
00l00`0000l03`0;00l2000?Ool002eoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo01]o
o`0300moogoo01]oo`0300moogoo01]oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo01]o
o`0300moogoo015oo`03001oogoo00aoo`03001oogoo00eoo`00;7oo00<007oo000017oo00<007oo
Ool00goo00<007ooOol06goo00<03gooOol06goo00<03gooOol06goo00<007ooOol06goo00<03goo
Ool06goo00<03gooOol06goo00<03gooOol04Woo00<007ooOol02goo00<007ooOol03Goo000]Ool0
0`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol0
0`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0COol00`00Oomoo`0:Ool0
0`00Oomoo`0=Ool003=oo`03001oogoo00=oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo
01]oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo01Aoo`03001oogoo
00Uoo`03001oogoo00eoo`00<goo00<007ooOol00goo00<007ooOol06goo00<03gooOol06goo00<0
3gooOol06goo00<007ooOol06goo00<03gooOol06goo00<03gooOol06goo00<03gooOol057oo00<0
07ooOol02Goo00<007ooOol03Goo000cOol00`00Oomoo`03Ool00`00Oomoo`0KOol00`0?Oomoo`0K
Ool00`0?Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0E
Ool00`00Oomoo`08Ool00`00Oomoo`0=Ool003=oo`8000Aoo`03001oogoo01]oo`0300moogoo01]o
o`0300moogoo01]oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo01Eo
o`03001oogoo00Qoo`03001oogoo00eoo`00<goo00<007ooOol00goo00<007ooOol06goo00<03goo
Ool06goo00<03gooOol06goo00<007ooOol06goo00<03gooOol06goo00<03gooOol06goo00<03goo
Ool05Woo00<007ooOol01goo00<007ooOol03Goo000cOol00`00Oomoo`03Ool00`00Oomoo`0KOol0
0`0?Oomoo`0KOol00`0?Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol0
0`0?Oomoo`0FOol00`00Oomoo`07Ool00`00Oomoo`0=Ool003=oo`03001oogoo00=oo`03001oogoo
01]oo`0300moogoo01]oo`0300moogoo01]oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo
01]oo`0300moogoo01Moo`03001oogoo00Ioo`03001oogoo00eoo`00<goo00<007ooOol00goo00<0
07ooOol06goo00<03gooOol06goo00<03gooOol06goo00<007ooOol06goo00<03gooOol06goo00<0
3gooOol06goo00<03gooOol05goo00<007ooOol01Woo00<007ooOol03Goo000cOol00`00Oomoo`04
Ool00`00Oomoo`0JOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0K
Ool00`0?Oomoo`0KOol00`0?Oomoo`0GOol00`00Oomoo`06Ool00`00Oomoo`0=Ool003=oo`03001o
ogoo00Aoo`03001oogoo01Yoo`0300moogoo01]oo`0300moogoo01]oo`03001oogoo01]oo`0300mo
ogoo01]oo`0300moogoo01]oo`0300moogoo01Qoo`03001oogoo00Eoo`03001oogoo00eoo`00<goo
0P001Woo00<007ooOol06Goo00<03gooOol06goo00<03gooOol06goo00<007ooOol06goo00<03goo
Ool06goo00<03gooOol06goo00<03gooOol067oo00<007ooOol01Goo00<007ooOol03Goo000cOol0
0`00Oomoo`05Ool00`00Oomoo`0IOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`00Oomoo`0KOol0
0`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0HOol00`00Oomoo`05Ool00`00Oomoo`0=Ool0
03=oo`03001oogoo00Eoo`03001oogoo01Uoo`0300moogoo01]oo`0300moogoo01]oo`03001oogoo
01]oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo01Uoo`03001oogoo00Aoo`03001oogoo
00eoo`00<goo00<007ooOol01Woo00<007ooOol067oo00<03gooOol06goo00<03gooOol06goo00<0
07ooOol06goo00<03gooOol06goo00<03gooOol06goo00<03gooOol06Goo00<007ooOol017oo00<0
07ooOol03Goo000cOol00`00Oomoo`06Ool00`00Oomoo`0HOol00`0?Oomoo`0=OolK000AOol00`00
Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0JOol00`00Oomoo`03Ool00`00
Oomoo`0=Ool003=oo`03001oogoo00Moo`03001oogoo01Moo`0300moogoo00Uoo`@000ioo`0300mo
ogoo00Yoo`D000aoo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo01Yo
o`03001oogoo00=oo`03001oogoo00eoo`00<goo00<007ooOol027oo00<007ooOol05Woo00<03goo
Ool01Goo10004Woo00<03gooOol03goo0`002Goo00<007ooOol06goo00<03gooOol06goo00<03goo
Ool06goo00<03gooOol06Woo00<007ooOol00goo00<007ooOol03Goo000cOol2000:Ool2000FOol0
100?Oomoogoo10005Woo00<03gooOol04Woo0`001Woo00<007ooOol06goo00<03gooOol06goo00<0
3gooOol06goo00<03gooOol06Woo00<007ooOol00goo00<007ooOol03Goo000cOol00`00Oomoo`0;
Ool00`00Oomoo`0COol4000JOol00`0?Oomoo`0EOol20004Ool00`00Oomoo`0KOol00`0?Oomoo`0K
Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`00Oomoo`02Ool00`00Oomoo`0=Ool003=oo`03001o
ogoo00aoo`03001oogoo011oo`80000300moogoo01]oo`0300moogoo01Moo`80009oo`03001oogoo
01]oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`03001oogoo009oo`03001oogoo
00eoo`00<goo00<007ooOol03Goo00<007ooOol037oo0`000Woo00<03gooOol06goo00<03gooOol0
6Goo0`007Goo00<03gooOol06goo00<03gooOol06goo00<03gooOol06goo00<007ooOol00Woo00<0
07ooOol03Goo000BOol20003Ool20003Ool2000EOol00`00Oomoo`0>Ool20009Ool30005Ool00`0?
Oomoo`0KOol00`0?Oomoo`0JOol2000MOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0K
Ool00`00Oomoo`02Ool00`00Oomoo`0=Ool0019oo`03001oogoo00Aoo`05001oogooOol0000EOol0
0`00Oomoo`0@Ool00`00Oomoo`04Ool20008Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`00Oomo
o`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`00Oomoo`02Ool00`00Oomo
o`0=Ool000Aoo`<00006Ool007oo001oo`001Goo00<007ooOol00Woo0`000goo00<007ooOol03Goo
00<007ooOol00goo00<007ooOol04Goo00@007ooOomoo`8000Yoo`0300moogoo01]oo`0300moogoo
01]oo`8001aoo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`03001oogoo009oo`03
001oogoo00eoo`001Goo00P007ooOol007oo001oo`001Goo00D007ooOomoo`00009oo`05001oogoo
Ool0000>Ool00`00Ool00004Ool00`00Oomoo`0BOol3000<Ool00`0?Oomoo`0KOol00g`0Oomoo`0K
Ool00`0O001oo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`00Oomoo`02
Ool00`00Oomoo`0=Ool000Eoo`08001oogoo001oo`00Ool000Eoo`05001oogooOol00002Ool01@00
Oomoogoo00003Woo00<007oo000017oogP003goo0005Ool00`00Oomoo`0200000goo001oo`05Ool0
0`00Oomoo`02Ool30003Ool00`00Oomoo`0<Ool00`00Ool00004Ool00`00Oomoo`0@Ool00`00Oomo
o`02Ool2000:Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol2000LOol00`0?Oomoo`0KOol00`0?Oomo
o`0KOol00`0?Oomoo`0KOol00`00Oomoo`02Ool00`00Oomoo`0=Ool000Eoo`03001oogoo00Yoo`03
001oogoo00Qoo`03001oogoo00aoo`03001oo`0000Aoo`03001oogoo00moo`03001oogoo00Eoo`80
00Qoo`0300moogoo01]oo`0300moogoo01]oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo
01]oo`0300moogoo01]oo`03001oogoo009oo`03001oogoo00eoo`0017oo0`002goo0P0027oo0P00
3goo00<007ooOol00goo00<007ooOol03Goo0P002Woo0P001Woo00<03gooOol06goo00<03gooOol0
6Woo0P007Goo00<03gooOol06goo00<03gooOol06goo00<03gooOol06goo00<007ooOol00Woo00<0
07ooOol03Goo000cOol00`00Oomoo`0<Ool00`00Oomoo`0<Ool20004Ool00`0?Oomoo`0KOol00`0?
Oomoo`0IOol00`00Ool0000MOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`00
Oomoo`02Ool00`00Oomoo`0=Ool003=oo`03001oogoo00]oo`03001oogoo00moo`@0000300moogoo
01]oo`0300moogoo01Moo`80009oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`03
00moogoo01]oo`03001oogoo009oo`03001oogoo00eoo`00<goo00<007ooOol02Woo00<007ooOol0
57oo0`006goo00<03gooOol05Woo00<007ooOol00Woo00<007ooOol06goo00<03gooOol06goo00<0
3gooOol06goo00<03gooOol06goo00<007ooOol00Woo00<007ooOol03Goo000cOol2000:Ool00`00
Oomoo`0EOol00`0?Oomoo`04000GOol00`0?Oomoo`0COol30005Ool00`00Oomoo`0KOol00`0?Oomo
o`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`00Oomoo`02Ool00`00Oomoo`0=Ool003=oo`03
001oogoo00Qoo`03001oogoo01Ioo`0300moogoo00Aoo`D0019oo`0300moogoo00moo`@000Qoo`03
001oogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`03001oogoo009oo`03
001oogoo00eoo`00<goo00<007ooOol01goo00<007ooOol05goo00<03gooOol02Goo1P0037oo00<0
3gooOol02goo100037oo00<007ooOol06goo00<03gooOol06goo00<03gooOol06goo00<03gooOol0
6Woo00<007ooOol00goo00<007ooOol03Goo000cOol00`00Oomoo`06Ool00`00Oomoo`0HOol00`0?
Oomoo`0?OolJ000@Ool00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0J
Ool00`00Oomoo`03Ool00`00Oomoo`0=Ool003=oo`03001oogoo00Eoo`03001oogoo01Uoo`0300mo
ogoo01]oo`0300moogoo01]oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`0300mo
ogoo01Uoo`03001oogoo00Aoo`03001oogoo00eoo`00<goo00<007ooOol01Goo00<007ooOol06Goo
00<03gooOol06goo00<03gooOol06goo00<007ooOol06goo00<03gooOol06goo00<03gooOol06goo
00<03gooOol06Goo00<007ooOol017oo00<007ooOol03Goo000cOol00`00Oomoo`04Ool00`00Oomo
o`0JOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomo
o`0KOol00`0?Oomoo`0IOol00`00Oomoo`04Ool00`00Oomoo`0=Ool003=oo`8000Eoo`03001oogoo
01Yoo`0300moogoo01]oo`0300moogoo01]oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo
01]oo`0300moogoo01Qoo`03001oogoo00Eoo`03001oogoo00eoo`00<goo00<007ooOol00goo00<0
07ooOol06goo00<03gooOol06goo00<03gooOol06goo00<007ooOol06goo00<03gooOol06goo00<0
3gooOol06goo00<03gooOol067oo00<007ooOol01Goo00<007ooOol03Goo000cOol00`00Oomoo`03
Ool00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0K
Ool00`0?Oomoo`0KOol00`0?Oomoo`0GOol00`00Oomoo`06Ool00`00Oomoo`0=Ool003=oo`03001o
ogoo00=oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`03001oogoo01]oo`0300mo
ogoo01]oo`0300moogoo01]oo`0300moogoo01Moo`03001oogoo00Ioo`03001oogoo00eoo`00<goo
00<007ooOol00goo00<007ooOol06goo00<03gooOol06goo00<03gooOol06goo00<007ooOol06goo
00<03gooOol06goo00<03gooOol06goo00<03gooOol05Woo00<007ooOol01goo00<007ooOol03Goo
000cOol00`00Oomoo`03Ool00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`00Oomo
o`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0FOol00`00Oomoo`07Ool00`00Oomo
o`0=Ool003=oo`03001oogoo00=oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`03
001oogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo01Eoo`03001oogoo00Qoo`03
001oogoo00eoo`00<goo0P0017oo00<007ooOol06goo00<03gooOol06goo00<03gooOol06goo00<0
07ooOol06goo00<03gooOol06goo00<03gooOol06goo00<03gooOol05Goo00<007ooOol027oo00<0
07ooOol03Goo000cOol00`00Oomoo`03Ool00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0K
Ool00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0DOol00`00Oomoo`09
Ool00`00Oomoo`0=Ool003=oo`03001oogoo00=oo`03001oogoo01]oo`0300moogoo01]oo`0300mo
ogoo01]oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo01Aoo`03001o
ogoo00Uoo`03001oogoo00eoo`00<goo00<007ooOol00goo00<007ooOol06goo00<03gooOol06goo
00<03gooOol06goo00<007ooOol06goo00<03gooOol06goo00<03gooOol06goo00<03gooOol04goo
00<007ooOol02Woo00<007ooOol03Goo000cOol00`00Oomoo`03Ool00`00Oomoo`0KOol00`0?Oomo
o`0KOol00`0?Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomo
o`0COol00`00Oomoo`0:Ool00`00Oomoo`0=Ool002aoo`<000Aoo`03001oogoo00Aoo`03001oogoo
01Yoo`0300moogoo01]oo`0300moogoo01]oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo
01]oo`0300moogoo019oo`03001oogoo00]oo`03001oogoo00eoo`00;7oo00<007ooOol017oo00<0
07ooOol017oo00<007ooOol06Woo00<03gooOol06goo00<03gooOol06goo00<007ooOol06goo00<0
3gooOol06goo00<03gooOol06goo00<03gooOol04Goo00<007ooOol037oo00<007ooOol03Goo000]
Ool00`00Oomoo`03Ool3000400l00`0000l03`1F00l00`0000l03`1Z00l00`0000l03`0<00l2000?
Ool002eoo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo01Yoo`0300moogoo01]oo`0300mo
ogoo01]oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo011oo`03001o
ogoo00eoo`03001oogoo00eoo`00;7oo00<007oo000017oo00<007ooOol01Goo00<007ooOol06Goo
00<03gooOol06goo00<03gooOol06goo00<007ooOol06goo00<03gooOol06goo00<03gooOol06goo
00<03gooOol03goo00<007ooOol03Woo00<007ooOol03Goo000]Ool00`00Oomoo`03Ool00`00Oomo
o`05Ool00`00Oomoo`0IOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomo
o`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0>Ool00`00Oomoo`0?Ool00`00Oomoo`0=Ool003=oo`03
001oogoo00Eoo`03001oogoo01Uoo`0300moogoo01]oo`0300moogoo01]oo`03001oogoo01]oo`03
00moogoo01]oo`0300moogoo01]oo`0300moogoo00eoo`03001oogoo011oo`03001oogoo00eoo`00
<goo00<007ooOol01Woo00<007ooOol067oo00<03gooOol06goo00<03gooOol06goo00<007ooOol0
6goo00<03gooOol06goo00<03gooOol06goo00<03gooOol02goo0P004goo00<007ooOol03Goo000c
Ool00`00Oomoo`07Ool00`00Oomoo`0GOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`00Oomoo`0K
Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0:Ool00`00Oomoo`0COol00`00Oomoo`0=
Ool003=oo`03001oogoo00Qoo`03001oogoo01Ioo`0300moogoo01]oo`0300moogoo01]oo`03001o
ogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo00Uoo`03001oogoo01Aoo`03001o
ogoo00eoo`00<goo0P002Woo00<007ooOol05Goo00<03gooOol06goo00<03gooOol06goo00<007oo
Ool06goo00<03gooOol06goo00<03gooOol06goo00<03gooOol027oo00<007ooOol05Goo00<007oo
Ool03Goo000cOol00`00Oomoo`09Ool00`00Oomoo`0EOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol0
0`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`07Ool00`00Oomoo`0FOol0
0`00Oomoo`0=Ool003=oo`03001oogoo00Yoo`03001oogoo01Aoo`0300moogoo01]oo`0300moogoo
01]oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`0300moogoo00Eoo`8001Uoo`03
001oogoo00eoo`00<goo00<007ooOol02goo00<007ooOol04goo00<03gooOol06goo00<03gooOol0
6goo00<007ooOol06goo00<03gooOol06goo00<03gooOol06goo00<03gooOol017oo00<007ooOol0
6Goo00<007ooOol03Goo000cOol00`00Oomoo`0<Ool00`00Oomoo`0BOol00`0?Oomoo`0KOol00`0?
Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`03Ool00`00
Oomoo`0JOol00`00Oomoo`0=Ool003=oo`03001oogoo00eoo`03001oogoo015oo`0300moogoo01]o
o`0300moogoo01]oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`0400moogooOol2
000MOol00`00Oomoo`0=Ool003=oo`03001oogoo00ioo`03001oogoo011oo`0300moogoo01]oo`03
00moogoo01]oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo01]oo`0400moogoo000OOol0
0`00Oomoo`0=Ool003=oo`80011oo`80011oo`0300moogoo01]oo`0300moogoo01]oo`03001oogoo
01]oo`0300moogoo01]oo`0300moogoo01]oo`0300l00000021oo`03001oogoo00eoo`00<goo00<0
07ooOol04Goo00<007ooOol03Goo00<03gooOol06goo00<03gooOol06goo00<007ooOol06goo00<0
3gooOol06goo00<03gooOol06Woo0P008Woo00<007ooOol03Goo000cOol00`00Oomoo`0BOol00`00
Oomoo`0<Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?
Oomoo`0IOol00`00Ool03`0ROol00`00Oomoo`0=Ool003=oo`03001oogoo01=oo`03001oogoo00]o
o`0300moogoo01]oo`0300moogoo01]oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo01Mo
o`80009oo`0300moogoo021oo`03001oogoo00eoo`00<goo00<007ooOol057oo0P002goo00<03goo
Ool06goo00<03gooOol06goo00<007ooOol06goo00<03gooOol06goo00<03gooOol05Goo0P0017oo
00<03gooOol087oo00<007ooOol03Goo000cOol00`00Oomoo`0FOol00`00Oomoo`08Ool00`0?Oomo
o`0KOol00`0?Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`0COol20006Ool0
0`0?Oomoo`0POol00`00Oomoo`0=Ool003=oo`03001oogoo01Moo`8000Qoo`0300moogoo01]oo`03
00moogoo01]oo`03001oogoo01]oo`0300moogoo01]oo`0300moogoo015oo`8000Qoo`0300moogoo
021oo`03001oogoo00eoo`00<goo0P006Woo0P001Woo00<03gooOol06goo00<03gooOol06goo00<0
07ooOol06goo00<03gooOol06goo00<03gooOol03goo0P002Woo00<03gooOol087oo00<007ooOol0
3Goo000cOol00`00Oomoo`0KOol20004Ool00`0?Oomoo`0KOol00`0?Oomoo`0KOol00`00Oomoo`0K
Ool00`0?Oomoo`0KOol00`0?Oomoo`0=Ool2000<Ool00`0?Oomoo`0POol00`00Oomoo`0=Ool003=o
o`03001oogoo01eoo`80009oo`0300moogoo01]oo`0300moogoo01]oo`03001oogoo01]oo`0300mo
ogoo01]oo`0300moogoo00Yoo`<000ioo`0300moogoo021oo`03001oogoo00eoo`00<goo00<007oo
Ool07goo0P0000<03gooOol06goo00<03gooOol06goo00<007ooOol06goo00<03gooOol06goo00<0
3gooOol027oo0P004Goo00<03gooOol087oo00<007ooOol03Goo000cOol00`00Oomoo`0QOol2000L
Ool00`0?Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`06Ool2000COol00`0?
Oomoo`0POol00`00Oomoo`0=Ool002eoo`<000=oo`03001oogoo025oo`0400moo`00000JOol00`0?
Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Oomoo`03Ool3000EOol00`0?Oomoo`0P
Ool00`00Oomoo`0=Ool002ioo`03001oogoo009oo`03001oogoo025oo`0400moogooOol3000GOol0
0`0?Oomoo`0KOol00`00Oomoo`0KOol00`0?Oomoo`0KOol00`0?Ool00003000HOol00`0?Oomoo`0P
Ool00`00Oomoo`0=Ool002aoo`@000=oo`<002P03`<003803`0300003`0?03L03`@003h03`8000mo
o`00;7oo00<007oo000017oo00<007ooOol08Goo00<03gooOol01goo100047oo00<03gooOol06goo
00<007ooOol06goo00<03gooOol05Woo0`000Woo00<03gooOol06goo00<03gooOol087oo00<007oo
Ool03Goo000]Ool20004Ool00`00Oomoo`0QOol00`0?Oomoo`0;Ool4000<Ool00`0?Oomoo`0KOol0
0`00Oomoo`0KOol00`0?Oomoo`0BOol40005Ool00`0?Oomoo`0KOol00`0?Oomoo`0POol00`00Oomo
o`0=Ool002ioo`03001oogoo009oo`03001oogoo025oo`0300moogoo00moo`H000Ioo`0300moogoo
01]oo`03001oogoo01]oo`0300moogoo00ioo`@000Uoo`0300moogoo01]oo`0300moogoo021oo`03
001oogoo00eoo`00<goo00<007ooOol08Goo00<03gooOol05Goo1`007Goo00<007ooOol06goo00<0
3gooOol027oo1P003Goo00<03gooOol06goo00<03gooOol087oo00<007ooOol03Goo000cOol00`00
Oomoo`0QOol00`0?Oomoo`0KOol00`0?00000006000EOol00`00Oomoo`0KOol00`0?Oomoo`02Ool6
000COol00`0?Oomoo`0KOol00`0?Oomoo`0POol00`00Oomoo`0=Ool003=oo`03001oogoo025oo`03
00moogoo01]oo`0300moogoo00Ioo`P000eoo`03001oogoo01Qoo`P001Uoo`0300moogoo01]oo`03
00moogoo021oo`03001oogoo00eoo`00<goo0P008Woo00<03gooOol06goo00<03gooOol03Woo3P00
47oo2P000goo00<03gooOol06goo00<03gooOol06goo00<03gooOol087oo00<007ooOol03Goo000c
Ool00`00Oomoo`0QOol00`0?Oomoo`0KOol00`0?Oomoo`0KOolA000=Ool00`0?Oomoo`0KOol00`0?
Oomoo`0KOol00`0?Oomoo`0POol00`00Oomoo`0=Ool003=oo`03001oogoo00=oo`03001oogoo01]o
o`03001oogoo01]oo`03001oogoo01]oo`03001oogoo01]oo`03001oogoo01]oo`03001oogoo01]o
o`03001oogoo01]oo`03001oogoo009oo`03001oogoo00eoo`00<goo00<007ooOol00goo00<007oo
Ool00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007oo
Ool00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007oo
Ool00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007oo
Ool00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007oo
Ool00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007oo
Ool00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007oo
Ool00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007ooOol00goo00<007oo
Ool00Woo00<007ooOol03Goo000cOooN000?Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003o
OolQOol00?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-4.92616, -6.44683, \
0.0333522, 0.0693648}},
  CellTags->{"Nyquist Plot", "i:10"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[113]=",
  CellTags->{"Nyquist Plot", "i:10"}]
}, Open  ]],

Cell["Similarly, the inverse Nyquist plot can be obtained:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"Nyquist Plot", "i:10"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(InverseNyquist[G, s, \(-20\), \(+20\)]\)], "Input",
  CellLabel->"In[114]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Nyquist Plot", "i:10"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.024188 0.000501694 0.309017 4.22255e-005 [
[.02419 -0.0125 -3 -9 ]
[.02419 -0.0125 3 0 ]
[.14961 -0.0125 -9 -9 ]
[.14961 -0.0125 9 0 ]
[.27504 -0.0125 -9 -9 ]
[.27504 -0.0125 9 0 ]
[.40046 -0.0125 -9 -9 ]
[.40046 -0.0125 9 0 ]
[.52588 -0.0125 -12 -9 ]
[.52588 -0.0125 12 0 ]
[.65131 -0.0125 -12 -9 ]
[.65131 -0.0125 12 0 ]
[.77673 -0.0125 -12 -9 ]
[.77673 -0.0125 12 0 ]
[.90215 -0.0125 -12 -9 ]
[.90215 -0.0125 12 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -23 -21.875 ]
[.5 -0.0125 23 -9 ]
[-0.0125 .05566 -30 -4.5 ]
[-0.0125 .05566 0 4.5 ]
[-0.0125 .14012 -30 -4.5 ]
[-0.0125 .14012 0 4.5 ]
[-0.0125 .22457 -30 -4.5 ]
[-0.0125 .22457 0 4.5 ]
[-0.0125 .30902 -6 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .39347 -24 -4.5 ]
[-0.0125 .39347 0 4.5 ]
[-0.0125 .47792 -24 -4.5 ]
[-0.0125 .47792 0 4.5 ]
[-0.0125 .56237 -24 -4.5 ]
[-0.0125 .56237 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -76.25 -6.4375 ]
[-0.01875 .30902 -30 6.4375 ]
[ 0 .61803 .125 0 ]
[.5 .63053 -5 0 ]
[.5 .63053 5 12.875 ]
[ 1 0 .125 0 ]
[1.0125 .30902 0 -6.4375 ]
[1.0125 .30902 10 6.4375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02419 0 m
.02419 .00625 L
s
[(0)] .02419 -0.0125 0 1 Mshowa
.14961 0 m
.14961 .00625 L
s
[(250)] .14961 -0.0125 0 1 Mshowa
.27504 0 m
.27504 .00625 L
s
[(500)] .27504 -0.0125 0 1 Mshowa
.40046 0 m
.40046 .00625 L
s
[(750)] .40046 -0.0125 0 1 Mshowa
.52588 0 m
.52588 .00625 L
s
[(1000)] .52588 -0.0125 0 1 Mshowa
.65131 0 m
.65131 .00625 L
s
[(1250)] .65131 -0.0125 0 1 Mshowa
.77673 0 m
.77673 .00625 L
s
[(1500)] .77673 -0.0125 0 1 Mshowa
.90215 0 m
.90215 .00625 L
s
[(1750)] .90215 -0.0125 0 1 Mshowa
.125 Mabswid
.04927 0 m
.04927 .00375 L
s
.07436 0 m
.07436 .00375 L
s
.09944 0 m
.09944 .00375 L
s
.12453 0 m
.12453 .00375 L
s
.1747 0 m
.1747 .00375 L
s
.19978 0 m
.19978 .00375 L
s
.22487 0 m
.22487 .00375 L
s
.24995 0 m
.24995 .00375 L
s
.30012 0 m
.30012 .00375 L
s
.3252 0 m
.3252 .00375 L
s
.35029 0 m
.35029 .00375 L
s
.37537 0 m
.37537 .00375 L
s
.42554 0 m
.42554 .00375 L
s
.45063 0 m
.45063 .00375 L
s
.47571 0 m
.47571 .00375 L
s
.5008 0 m
.5008 .00375 L
s
.55097 0 m
.55097 .00375 L
s
.57605 0 m
.57605 .00375 L
s
.60114 0 m
.60114 .00375 L
s
.62622 0 m
.62622 .00375 L
s
.67639 0 m
.67639 .00375 L
s
.70148 0 m
.70148 .00375 L
s
.72656 0 m
.72656 .00375 L
s
.75164 0 m
.75164 .00375 L
s
.80181 0 m
.80181 .00375 L
s
.8269 0 m
.8269 .00375 L
s
.85198 0 m
.85198 .00375 L
s
.87707 0 m
.87707 .00375 L
s
.92724 0 m
.92724 .00375 L
s
.95232 0 m
.95232 .00375 L
s
.97741 0 m
.97741 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -84 -25.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Re) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
75.000000 13.000000 moveto
(@) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
87.000000 13.000000 moveto
(\\220) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
99.000000 13.000000 moveto
(D) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
0 .05566 m
.00625 .05566 L
s
[(-6000)] -0.0125 .05566 1 0 Mshowa
0 .14012 m
.00625 .14012 L
s
[(-4000)] -0.0125 .14012 1 0 Mshowa
0 .22457 m
.00625 .22457 L
s
[(-2000)] -0.0125 .22457 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(0)] -0.0125 .30902 1 0 Mshowa
0 .39347 m
.00625 .39347 L
s
[(2000)] -0.0125 .39347 1 0 Mshowa
0 .47792 m
.00625 .47792 L
s
[(4000)] -0.0125 .47792 1 0 Mshowa
0 .56237 m
.00625 .56237 L
s
[(6000)] -0.0125 .56237 1 0 Mshowa
.125 Mabswid
0 .07678 m
.00375 .07678 L
s
0 .09789 m
.00375 .09789 L
s
0 .119 m
.00375 .119 L
s
0 .16123 m
.00375 .16123 L
s
0 .18234 m
.00375 .18234 L
s
0 .20345 m
.00375 .20345 L
s
0 .24568 m
.00375 .24568 L
s
0 .26679 m
.00375 .26679 L
s
0 .2879 m
.00375 .2879 L
s
0 .33013 m
.00375 .33013 L
s
0 .35124 m
.00375 .35124 L
s
0 .37236 m
.00375 .37236 L
s
0 .41458 m
.00375 .41458 L
s
0 .43569 m
.00375 .43569 L
s
0 .45681 m
.00375 .45681 L
s
0 .49903 m
.00375 .49903 L
s
0 .52014 m
.00375 .52014 L
s
0 .54126 m
.00375 .54126 L
s
0 .03455 m
.00375 .03455 L
s
0 .01344 m
.00375 .01344 L
s
0 .58348 m
.00375 .58348 L
s
0 .6046 m
.00375 .6046 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -137.25 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Im) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
75.250000 13.000000 moveto
(@) show
81.250000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
87.250000 13.000000 moveto
(\\220) show
93.250000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
99.250000 13.000000 moveto
(D) show
105.250000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
.02419 .61178 m
.02419 .61803 L
s
.14961 .61178 m
.14961 .61803 L
s
.27504 .61178 m
.27504 .61803 L
s
.40046 .61178 m
.40046 .61803 L
s
.52588 .61178 m
.52588 .61803 L
s
.65131 .61178 m
.65131 .61803 L
s
.77673 .61178 m
.77673 .61803 L
s
.90215 .61178 m
.90215 .61803 L
s
.125 Mabswid
.04927 .61428 m
.04927 .61803 L
s
.07436 .61428 m
.07436 .61803 L
s
.09944 .61428 m
.09944 .61803 L
s
.12453 .61428 m
.12453 .61803 L
s
.1747 .61428 m
.1747 .61803 L
s
.19978 .61428 m
.19978 .61803 L
s
.22487 .61428 m
.22487 .61803 L
s
.24995 .61428 m
.24995 .61803 L
s
.30012 .61428 m
.30012 .61803 L
s
.3252 .61428 m
.3252 .61803 L
s
.35029 .61428 m
.35029 .61803 L
s
.37537 .61428 m
.37537 .61803 L
s
.42554 .61428 m
.42554 .61803 L
s
.45063 .61428 m
.45063 .61803 L
s
.47571 .61428 m
.47571 .61803 L
s
.5008 .61428 m
.5008 .61803 L
s
.55097 .61428 m
.55097 .61803 L
s
.57605 .61428 m
.57605 .61803 L
s
.60114 .61428 m
.60114 .61803 L
s
.62622 .61428 m
.62622 .61803 L
s
.67639 .61428 m
.67639 .61803 L
s
.70148 .61428 m
.70148 .61803 L
s
.72656 .61428 m
.72656 .61803 L
s
.75164 .61428 m
.75164 .61803 L
s
.80181 .61428 m
.80181 .61803 L
s
.8269 .61428 m
.8269 .61803 L
s
.85198 .61428 m
.85198 .61803 L
s
.87707 .61428 m
.87707 .61803 L
s
.92724 .61428 m
.92724 .61803 L
s
.95232 .61428 m
.95232 .61803 L
s
.97741 .61428 m
.97741 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
gsave
.5 .63053 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
69.000000 13.000000 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.99375 .05566 m
1 .05566 L
s
.99375 .14012 m
1 .14012 L
s
.99375 .22457 m
1 .22457 L
s
.99375 .30902 m
1 .30902 L
s
.99375 .39347 m
1 .39347 L
s
.99375 .47792 m
1 .47792 L
s
.99375 .56237 m
1 .56237 L
s
.125 Mabswid
.99625 .07678 m
1 .07678 L
s
.99625 .09789 m
1 .09789 L
s
.99625 .119 m
1 .119 L
s
.99625 .16123 m
1 .16123 L
s
.99625 .18234 m
1 .18234 L
s
.99625 .20345 m
1 .20345 L
s
.99625 .24568 m
1 .24568 L
s
.99625 .26679 m
1 .26679 L
s
.99625 .2879 m
1 .2879 L
s
.99625 .33013 m
1 .33013 L
s
.99625 .35124 m
1 .35124 L
s
.99625 .37236 m
1 .37236 L
s
.99625 .41458 m
1 .41458 L
s
.99625 .43569 m
1 .43569 L
s
.99625 .45681 m
1 .45681 L
s
.99625 .49903 m
1 .49903 L
s
.99625 .52014 m
1 .52014 L
s
.99625 .54126 m
1 .54126 L
s
.99625 .03455 m
1 .03455 L
s
.99625 .01344 m
1 .01344 L
s
.99625 .58348 m
1 .58348 L
s
.99625 .6046 m
1 .6046 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
gsave
1.0125 .30902 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
69.000000 13.000000 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 .30902 m
1 .30902 L
s
.5 Mabswid
.97619 .60332 m
.79763 .5325 L
.62303 .46921 L
.47867 .42179 L
.35827 .38601 L
.25057 .35729 L
.16737 .33751 L
.1012 .32352 L
.0586 .31546 L
.03529 .31136 L
.02897 .31024 L
.02525 .30952 L
.02441 .30932 L
.02412 .30924 L
.02395 .30918 L
.02389 .30915 L
.02385 .30913 L
.02383 .30912 L
.02382 .30911 L
.02382 .3091 L
.02381 .30909 L
.02381 .30908 L
.02381 .30907 L
.02381 .30907 L
.02382 .30906 L
.02382 .30906 L
.02383 .30905 L
.02384 .30905 L
.02386 .30904 L
.02388 .30903 L
.02392 .30903 L
.02396 .30902 L
.024 .30902 L
.02404 .30901 L
.02407 .30901 L
.02409 .30901 L
.02411 .30901 L
.02413 .30901 L
.02415 .30901 L
.02417 .30901 L
.02418 .30901 L
.02419 .30901 L
.02421 .30901 L
.02422 .30901 L
.02424 .30901 L
.02425 .30901 L
.02426 .30901 L
.02427 .30901 L
.02428 .30901 L
.02429 .30901 L
Mistroke
.0243 .30901 L
.02431 .30901 L
.02431 .30902 L
.02431 .30902 L
.02431 .30902 L
.02431 .30902 L
.02431 .30902 L
.02431 .30902 L
.02431 .30902 L
.0243 .30902 L
.02429 .30902 L
.02428 .30902 L
.02427 .30902 L
.02425 .30902 L
.02424 .30903 L
.02423 .30903 L
.02421 .30903 L
.0242 .30903 L
.02419 .30903 L
.02418 .30903 L
.02417 .30903 L
.02416 .30903 L
.02414 .30903 L
.02413 .30903 L
.02411 .30903 L
.02409 .30902 L
.02407 .30902 L
.02403 .30902 L
.02398 .30902 L
.02393 .30901 L
.0239 .309 L
.02388 .309 L
.02386 .30899 L
.02385 .30899 L
.02384 .30898 L
.02383 .30898 L
.02382 .30897 L
.02381 .30897 L
.02381 .30896 L
.02381 .30895 L
.02381 .30895 L
.02381 .30894 L
.02382 .30893 L
.02382 .30893 L
.02385 .30891 L
.02388 .30889 L
.02393 .30886 L
.02408 .30881 L
.02471 .30864 L
.02576 .30841 L
Mistroke
.03644 .30648 L
.0604 .30225 L
.1046 .29384 L
.16715 .28057 L
.25572 .25945 L
.36225 .2309 L
.48383 .19463 L
.63322 .1453 L
.79597 .08617 L
.97619 .01472 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[114]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00:]oo`8000moo`8000=oo`8005eoo`00Zgoo00<007ooOol01goo00<007oo
Ool01Woo00D007ooOomoo`0005eoo`00W7oo0`0000Aoo`00Oomoo`8000Ioo`03001oogoo00D000=o
o`03001oogoo00=oo`<000=oo`03001oogoo05]oo`00WGoo00H007ooOol007oo0008Ool00`00Oomo
o`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool01000Oomoo`000goo00<007ooOol0Fgoo002MOol3
0002Ool30006Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool01000Oomoo`000goo
00<007ooOol0Fgoo002MOol01@00Oomoo`00Ool00`001Woo00<007ooOol00Woo00<007ooOol017oo
00<007ooOol00Woo0`000goo00<007ooOol0Fgoo002MOol01000Oomoo`002Woo00<007ooOol00Woo
00<007ooOol017oo00<007ooOol027oo00<007ooOol0Fgoo002LOol4000;Ool20002Ool20007Ool0
0`00Oomoo`06Ool2001MOol00?moob5oo`00ogoo8Goo003oOolQOol005Aoo`03001oogoo00moo`<0
00=oo`03001oogoo009oo`03001oogoo00]oo`03001oogoo009oo`03001oogoo009oo`03001oogoo
00aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo00Moo`D0009oo`03001oogoo009oo`03
001oogoo009oo`03001oogoo00Aoo`D00004Ool000000003Ool00`00Oomoo`02Ool00`00Oomoo`05
Ool50002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`04Ool50002Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool00`00Oomoo`0GOol005=oo`03001oo`00011oo`03001oogoo009oo`03001o
o`00009oo`03001oo`0000]oo`03001oo`00009oo`03001oo`00009oo`03001oo`0000eoo`07001o
ogooOol007oo00000Woo00<007oo00002Woo00L007ooOomoo`00Ool00002Ool00`00Ool00002Ool0
0`00Ool00007Ool01@00Oomoogoo000017oo00<007oo00000Woo00<007oo000027oo00L007ooOomo
o`00Ool00002Ool00`00Ool00002Ool00`00Ool00007Ool00`00Oomoo`02Ool01`00Oomoogoo001o
o`00009oo`03001oo`0001Qoo`00Dgoo00<007oo00004Goo00<007ooOol00goo00H007ooOol007oo
000=Ool01P00Oomoo`00Ool0009oo`03001oo`0000eoo`03001oogoo00=oo`06001oogoo001oo`00
2Woo00L007ooOomoo`00Ool00002Ool00`00Ool00002Ool00`00Ool00007Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool01P00Oomoo`00Ool000Qoo`03001oogoo00=oo`06001oogoo001oo`000Woo00<0
07oo00001goo00<007ooOol00Woo00<007ooOol00goo00H007ooOol007oo000HOol005=oo`03001o
o`00015oo`04001oogooOol20003Ool00`00Ool0000;Ool20003Ool00`00Ool00002Ool00`00Ool0
000>Ool00`00Oomoo`020003Ool00`00Ool0000:Ool01`00Oomoogoo001oo`00009oo`03001oo`00
009oo`03001oo`0000Moo`03001oogoo009oo`04001oogooOol20003Ool00`00Ool00008Ool01000
Oomoogoo0P000goo00<007oo00000Woo00<007oo00001goo00<007ooOol00goo00<007ooOol00P00
0goo00<007oo000067oo001COol00`00Ool0000@Ool00`00Ool00002Ool00`00Oomoo`02Ool00`00
Ool0000;Ool00`00Oomoo`02Ool00`00Ool00002Ool00`00Ool0000<Ool00`00Ool00002Ool00`00
Oomoo`02Ool00`00Ool0000:Ool01`00Oomoogoo001oo`00009oo`03001oo`00009oo`03001oo`00
00Moo`07001oogooOol007oo00000Woo00<007ooOol00Woo00<007oo000027oo00D007ooOomoo`00
00Aoo`03001oo`00009oo`03001oo`0000Moo`07001oogooOol007oo00000Woo00<007ooOol00Woo
00<007oo000067oo001DOol00`00Oomoo`0@Ool01000Oomoogoo0`000goo00<007ooOol02Woo0`00
0goo00<007ooOol00Woo00<007ooOol02goo0`000Woo0`000goo00<007ooOol027oo0P0017oo00<0
07ooOol00Woo00<007ooOol00Woo00<007ooOol01Goo0P0017oo00@007ooOomoo`<000=oo`03001o
ogoo00Ioo`8000=oo`<000=oo`03001oogoo009oo`03001oogoo00Eoo`8000=oo`<0009oo`<000=o
o`03001oogoo01Moo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo001?Ooo4000=Ool004mo
o`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo009o
o`03001oogoo009oo`05001oogooOol00004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01@00Oomoogoo000017oo00<0
07ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol00Woo00D007ooOomoo`0000Aoo`03001oogoo009oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`05001oogooOol0
0004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool01@00Oomoogoo00003Goo001?Ool00`00Oomoo`02Ool00`00Oomoo`0F
Ool00`00Oomoo`0EOol00`00Oomoo`0EOol00`00Oomoo`0FOol00`00Oomoo`0EOol00`00Oomoo`0F
Ool00`00Oomoo`0EOol00`00Oomoo`0@Ool00`00Oomoo`0;Ool004moo`800;]oo`8000=oo`8000eo
o`00Cgoo00<007ooOol0^7oo0P001Woo00<007ooOol02goo001?Ool00`00Oomoo`2eOol30008Ool0
0`00Oomoo`0;Ool004moo`03001oogoo0;=oo`8000]oo`03001oogoo00]oo`00Cgoo0P00/Goo0`00
37oo0P003Goo001?Ool00`00Oomoo`2^Ool2000@Ool00`00Oomoo`0;Ool003Yoo`8000Aoo`03001o
ogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo0:]oo`<0019oo`03001oogoo00]o
o`00>Woo00<007oo00000Woo00<007oo00000Woo00<007oo00000Woo00<007oo00000goo00<007oo
Ool0ZGoo0P005Goo00<007ooOol02goo000eOol30002Ool00`00Ool00002Ool00`00Ool00002Ool0
0`00Ool00002Ool00`00Ool00003Ool3002VOol3000FOol2000=Ool003Yoo`8000=oo`03001oo`00
009oo`03001oo`00009oo`03001oo`0000=oo`03001oogoo0:Aoo`8001Yoo`03001oogoo00]oo`00
>Woo00<007ooOol00Woo00<007oo00000Woo00<007oo00000Woo00<007oo00000goo00<007ooOol0
XGoo0`0077oo00<007ooOol02goo000kOol20003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`02Ool00`00Oomoo`2OOol2000OOol00`00Oomoo`0;Ool004moo`8009eoo`<0021oo`8000eo
o`00Cgoo00<007ooOol0VWoo0P0097oo00<007ooOol02goo001?Ool00`00Oomoo`2GOol3000VOol0
0`00Oomoo`0;Ool004moo`03001oogoo09Eoo`8002Uoo`03001oogoo00]oo`00Cgoo0P00Tgoo0`00
:Woo0P003Goo001?Ool00`00Oomoo`2?Ool3000^Ool00`00Oomoo`0;Ool004moo`03001oogoo08eo
o`80035oo`03001oogoo00]oo`00Cgoo00<007ooOol0RWoo0`00<goo00<007ooOol02goo001?Ool0
0`00Oomoo`28Ool2000fOol00`00Oomoo`0;Ool004moo`8008Ioo`<003Moo`8000eoo`00Cgoo00<0
07ooOol0Pgoo0P00>goo00<007ooOol02goo000kOol30002Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool00`00Oomoo`20Ool3000mOol00`00Oomoo`0;Ool003aoo`06001oogoo001o
o`000Woo00<007oo00000Woo00<007oo00000goo00<007ooOol0OGoo0`00@7oo00<007ooOol02goo
000eOol30002Ool4000017oo001oo`000Woo00<007oo00000Woo00<007oo00000goo0`00Ngoo0P00
@Woo0P003Goo000jOol00`00Ool00002Ool00`00Ool00002Ool00`00Ool00002Ool00`00Ool00003
Ool00`00Oomoo`1hOol30015Ool00`00Oomoo`0;Ool003]oo`80009oo`03001oo`00009oo`03001o
o`00009oo`03001oo`0000=oo`03001oogoo07Eoo`<004Qoo`03001oogoo00]oo`00?7oo00D007oo
Oomoo`0000Aoo`03001oogoo009oo`03001oogoo009oo`03001oogoo075oo`@004]oo`03001oogoo
00]oo`00Cgoo0P00Kgoo0`00CWoo0P003Goo001?Ool00`00Oomoo`1[Ool3001BOol00`00Oomoo`0;
Ool004moo`03001oogoo06Qoo`<005Eoo`03001oogoo00]oo`00Cgoo00<007ooOol0IGoo0`00F7oo
00<007ooOol02goo001?Ool2001ROol4001JOol2000=Ool004moo`03001oogoo05ioo`<005moo`03
001oogoo00]oo`00Cgoo00<007ooOol0Fgoo0`00HWoo00<007ooOol02goo001?Ool00`00Oomoo`1G
Ool4001UOol00`00Oomoo`0;Ool004moo`8005Eoo`<006Qoo`8000eoo`00Cgoo00<007ooOol0DGoo
0`00K7oo00<007ooOol02goo000jOol30003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool00`00Oomoo`1=Ool4001_Ool00`00Oomoo`0;Ool003Yoo`03001oogoo009oo`03001oo`00
009oo`03001oo`00009oo`03001oo`0000=oo`03001oogoo04Yoo`<007=oo`03001oogoo00]oo`00
=Goo0`000goo00L007ooOomoo`00Ool00002Ool00`00Ool00002Ool00`00Ool00003Ool30016Ool4
001eOol2000=Ool003]oo`07001oogooOol007oo00000Woo00<007oo00000Woo00<007oo00000goo
00<007ooOol0@goo0`00NWoo00<007ooOol02goo000jOol00`00Ool00002Ool00`00Ool00002Ool0
0`00Ool00002Ool00`00Ool00003Ool00`00Oomoo`0oOol4001mOol00`00Oomoo`0;Ool003]oo`03
001oogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo03aoo`<0
085oo`03001oogoo00]oo`00Cgoo0P00>Goo1000Pgoo0P003Goo001?Ool00`00Oomoo`0eOol30028
Ool00`00Oomoo`0;Ool004moo`03001oogoo035oo`@008]oo`03001oogoo00]oo`00Cgoo00<007oo
Ool0;Goo1000Sgoo00<007ooOol02goo001?Ool2000ZOol4002BOol2000=Ool004moo`03001oogoo
02Eoo`@009Moo`03001oogoo00]oo`00Cgoo00<007ooOol08Goo1000Vgoo00<007ooOol02goo001?
Ool00`00Oomoo`0MOol4002OOol00`00Oomoo`0;Ool004moo`8001Yoo`@00:9oo`8000eoo`004Goo
0P003goo0P000goo0P009Woo00<007ooOol05Goo1000Ygoo00<007ooOol02goo000AOol00`00Oomo
o`07Ool00`00Oomoo`06Ool01@00Oomoogoo00009Woo00<007ooOol03Woo1`00Zgoo00<007ooOol0
2goo0003Ool300001Woo001oo`00Ool000Eoo`03001oogoo00D000=oo`03001oogoo00=oo`<000=o
o`03001oogoo01moo`03001oogoo009oo`03001oogoo00Moo`L00;9oo`03001oogoo00]oo`0017oo
00P007ooOol007oo001oo`001Goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo00@0
07ooOol000=oo`03001oogoo01ioo`03001oo`0000=oo`03001oogoo009oo`D00;Uoo`03001oogoo
00]oo`0017oo00P007ooOol007oo001oo`001Goo00<007ooOol00Woo00<007ooOol00goo00<007oo
Ool00Woo00@007ooOol000=oo`03001oogoo01ioo`03001oo`0000=ool@000eoo`0017oo00<007oo
Ool00P0000=oo`00Ool01Goo00<007ooOol00Woo00<007ooOol017oo00<007ooOol00Woo0`000goo
00<007ooOol07Woo00<007oo00000goo00<007ooOol01goo1P00/goo00<007ooOol02goo0004Ool0
0`00Oomoo`0:Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`08Ool00`00Oomoo`0NOol0
0`00Ool00003Ool00`00Oomoo`0=Ool7002/Ool00`00Oomoo`0;Ool000=oo`<000]oo`80009oo`80
00Moo`03001oogoo00Ioo`80025oo`03001oogoo009oo`03001oogoo01Aoo`@00:Qoo`03001oogoo
00]oo`00Cgoo0P006Goo1000Xgoo0P003Goo001?Ool00`00Oomoo`0LOol4002POol00`00Oomoo`0;
Ool004moo`03001oogoo021oo`@009aoo`03001oogoo00]oo`00Cgoo00<007ooOol097oo1000V7oo
00<007ooOol02goo001?Ool2000YOol4002COol2000=Ool004moo`03001oogoo02aoo`@0091oo`03
001oogoo00]oo`00Cgoo00<007ooOol0<7oo1000S7oo00<007ooOol02goo001?Ool00`00Oomoo`0d
Ool30029Ool00`00Oomoo`0;Ool004moo`8003Qoo`@008Aoo`8000eoo`00Cgoo00<007ooOol0>goo
0`00PWoo00<007ooOol02goo000jOol30003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool00`00Oomoo`0nOol4001nOol00`00Oomoo`0;Ool003Yoo`03001oogoo009oo`03001oo`00
009oo`03001oo`00009oo`03001oo`0000=oo`03001oogoo049oo`<007]oo`03001oogoo00]oo`00
>goo00L007ooOomoo`00Ool00002Ool00`00Ool00002Ool00`00Ool00003Ool30015Ool4001fOol2
000=Ool003]oo`07001oogooOol007oo00000Woo00<007oo00000Woo00<007oo00000goo00<007oo
Ool0BGoo1000Lgoo00<007ooOol02goo000jOol00`00Ool00002Ool00`00Ool00002Ool00`00Ool0
0002Ool00`00Ool00003Ool00`00Oomoo`1=Ool4001_Ool00`00Oomoo`0;Ool003]oo`03001oogoo
009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo055oo`@006]oo`03
001oogoo00]oo`00Cgoo0P00EWoo1000IWoo0P003Goo001?Ool00`00Oomoo`1IOol4001SOol00`00
Oomoo`0;Ool004moo`03001oogoo05eoo`<0061oo`03001oogoo00]oo`00Cgoo00<007ooOol0H7oo
0P00GWoo00<007ooOol02goo001?Ool2001SOol3001JOol2000=Ool004moo`03001oogoo06Eoo`<0
05Qoo`03001oogoo00]oo`00Cgoo00<007ooOol0J7oo0`00EGoo00<007ooOol02goo001?Ool00`00
Oomoo`1[Ool3001BOol00`00Oomoo`0;Ool004moo`8006moo`8004moo`8000eoo`00Cgoo00<007oo
Ool0L7oo0`00CGoo00<007ooOol02goo000kOol30002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool00`00Oomoo`1cOol3001:Ool00`00Oomoo`0;Ool003aoo`06001oogoo001oo`00
0Woo00<007oo00000Woo00<007oo00000goo00<007ooOol0MWoo0`00Agoo00<007ooOol02goo000j
Ool4000017oo001oo`000Woo00<007oo00000Woo00<007oo00000goo0`00NGoo0`00@goo0P003Goo
000jOol00`00Ool00002Ool00`00Ool00002Ool00`00Ool00002Ool00`00Ool00003Ool00`00Oomo
o`1lOol30011Ool00`00Oomoo`0;Ool003]oo`80009oo`03001oo`00009oo`03001oo`00009oo`03
001oo`0000=oo`03001oogoo07moo`8003moo`03001oogoo00]oo`00?7oo00D007ooOomoo`0000Ao
o`03001oogoo009oo`03001oogoo009oo`03001oogoo085oo`<003aoo`03001oogoo00]oo`00Cgoo
00<007ooOol0Q7oo0`00>Goo00<007ooOol02goo001?Ool20028Ool3000eOol2000=Ool004moo`03
001oogoo08Yoo`<003=oo`03001oogoo00]oo`00Cgoo00<007ooOol0SGoo0`00<7oo00<007ooOol0
2goo001?Ool00`00Oomoo`2@Ool2000^Ool00`00Oomoo`0;Ool004moo`8009=oo`<002Yoo`8000eo
o`00Cgoo00<007ooOol0UGoo0`00:7oo00<007ooOol02goo001?Ool00`00Oomoo`2HOol3000UOol0
0`00Oomoo`0;Ool004moo`03001oogoo09]oo`8002=oo`03001oogoo00]oo`00Cgoo0P00WWoo0`00
7goo0P003Goo001?Ool00`00Oomoo`2POol2000NOol00`00Oomoo`0;Ool003Yoo`8000Aoo`03001o
ogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo0:9oo`8001aoo`03001oogoo00]o
o`00>Woo00<007oo00000Woo00<007oo00000Woo00<007oo00000Woo00<007oo00000goo00<007oo
Ool0Y7oo0`006Goo00<007ooOol02goo000jOol00`00Ool00002Ool00`00Ool00002Ool00`00Ool0
0002Ool00`00Ool00003Ool3002WOol2000FOol2000=Ool003Yoo`8000=oo`03001oo`00009oo`03
001oo`00009oo`03001oo`0000=oo`03001oogoo0:Uoo`<001Aoo`03001oogoo00]oo`00>Woo00<0
07ooOol00Woo00<007oo00000Woo00<007oo00000Woo00<007oo00000goo00<007ooOol0[7oo0P00
4Woo00<007ooOol02goo000kOol20003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool00`00Oomoo`2^Ool3000?Ool00`00Oomoo`0;Ool004moo`800;9oo`8000aoo`8000eoo`00Cgoo
00<007ooOol0/goo0P002goo00<007ooOol02goo001?Ool00`00Oomoo`2eOol30008Ool00`00Oomo
o`0;Ool004moo`03001oogoo0;Qoo`8000Ioo`03001oogoo00]oo`00Cgoo0P00^goo0P000goo0P00
3Goo001?Ool00`00Oomoo`02Ool00`00Oomoo`0FOol00`00Oomoo`0EOol00`00Oomoo`0EOol00`00
Oomoo`0FOol00`00Oomoo`0EOol00`00Oomoo`0FOol00`00Oomoo`0EOol00`00Oomoo`0@Ool00`00
Oomoo`0;Ool004moo`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo009o
o`03001oogoo009oo`03001oogoo009oo`05001oogooOol00004Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01@00Oomo
ogoo000017oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`0000Aoo`03001oogoo009o
o`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo009oo`03001oogoo009o
o`05001oogooOol00004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01@00Oomoogoo00003Goo001?Ooo4000=Ool00?mo
ob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo
003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?mo
ob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo
0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-866.349, -11310.4, 10.2394, \
121.657}},
  CellTags->{"Nyquist Plot", "i:10"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[114]=",
  CellTags->{"Nyquist Plot", "i:10"}]
}, Open  ]],

Cell["\<\
We can also get a color version of the same plot. For variety, we choose a \
frequency range of -4 to +4 radians per second and specify a frequency \
increment of 0.01.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"Nyquist Plot", "i:10"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ND = ColorNyquist[G, s, \(-4. \), \(+4. \),  .01]\)], "Input",
  CellLabel->"In[115]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Nyquist Plot", "i:10"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.4104 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.438894 0.671621 0.705202 0.671621 [
[ 0 0 0 0 ]
[ 1 1.4104 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.0238095 0.033581 0.853978 1.37682 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.433984 0.135552 0.809017 0.170266 [
[.02733 -0.0125 -6 -9 ]
[.02733 -0.0125 6 0 ]
[.16288 -0.0125 -6 -9 ]
[.16288 -0.0125 6 0 ]
[.29843 -0.0125 -6 -9 ]
[.29843 -0.0125 6 0 ]
[.43398 -0.0125 -3 -9 ]
[.43398 -0.0125 3 0 ]
[.56954 -0.0125 -3 -9 ]
[.56954 -0.0125 3 0 ]
[.70509 -0.0125 -3 -9 ]
[.70509 -0.0125 3 0 ]
[.84064 -0.0125 -3 -9 ]
[.84064 -0.0125 3 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -17 -21.875 ]
[.5 -0.0125 17 -9 ]
[-0.0125 .12795 -12 -4.5 ]
[-0.0125 .12795 0 4.5 ]
[-0.0125 .46849 -12 -4.5 ]
[-0.0125 .46849 0 4.5 ]
[-0.0125 .80902 -6 -4.5 ]
[-0.0125 .80902 0 4.5 ]
[-0.0125 1.14955 -6 -4.5 ]
[-0.0125 1.14955 0 4.5 ]
[-0.0125 1.49008 -6 -4.5 ]
[-0.0125 1.49008 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .80902 -46.25 -6.4375 ]
[-0.01875 .80902 -12 6.4375 ]
[ 0 1.61803 .125 0 ]
[.5 1.63053 -5 0 ]
[.5 1.63053 5 12.875 ]
[ 1 0 .125 0 ]
[1.0125 .80902 0 -6.4375 ]
[1.0125 .80902 10 6.4375 ]
[.5 1.63053 -101.781 12.875 ]
[.5 1.63053 101.781 35.4375 ]
[ 0 0 0 0 ]
[ 1 1.61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.02733 0 m
.02733 .00625 L
s
[(-3)] .02733 -0.0125 0 1 Mshowa
.16288 0 m
.16288 .00625 L
s
[(-2)] .16288 -0.0125 0 1 Mshowa
.29843 0 m
.29843 .00625 L
s
[(-1)] .29843 -0.0125 0 1 Mshowa
.43398 0 m
.43398 .00625 L
s
[(0)] .43398 -0.0125 0 1 Mshowa
.56954 0 m
.56954 .00625 L
s
[(1)] .56954 -0.0125 0 1 Mshowa
.70509 0 m
.70509 .00625 L
s
[(2)] .70509 -0.0125 0 1 Mshowa
.84064 0 m
.84064 .00625 L
s
[(3)] .84064 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(4)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05444 0 m
.05444 .00375 L
s
.08155 0 m
.08155 .00375 L
s
.10866 0 m
.10866 .00375 L
s
.13577 0 m
.13577 .00375 L
s
.18999 0 m
.18999 .00375 L
s
.2171 0 m
.2171 .00375 L
s
.24421 0 m
.24421 .00375 L
s
.27132 0 m
.27132 .00375 L
s
.32554 0 m
.32554 .00375 L
s
.35265 0 m
.35265 .00375 L
s
.37976 0 m
.37976 .00375 L
s
.40687 0 m
.40687 .00375 L
s
.46109 0 m
.46109 .00375 L
s
.4882 0 m
.4882 .00375 L
s
.51532 0 m
.51532 .00375 L
s
.54243 0 m
.54243 .00375 L
s
.59665 0 m
.59665 .00375 L
s
.62376 0 m
.62376 .00375 L
s
.65087 0 m
.65087 .00375 L
s
.67798 0 m
.67798 .00375 L
s
.7322 0 m
.7322 .00375 L
s
.75931 0 m
.75931 .00375 L
s
.78642 0 m
.78642 .00375 L
s
.81353 0 m
.81353 .00375 L
s
.86775 0 m
.86775 .00375 L
s
.89486 0 m
.89486 .00375 L
s
.92197 0 m
.92197 .00375 L
s
.94908 0 m
.94908 .00375 L
s
.00022 0 m
.00022 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -78 -25.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Re) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
75.000000 13.000000 moveto
(@) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
87.000000 13.000000 moveto
(D) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
0 .12795 m
.00625 .12795 L
s
[(-4)] -0.0125 .12795 1 0 Mshowa
0 .46849 m
.00625 .46849 L
s
[(-2)] -0.0125 .46849 1 0 Mshowa
0 .80902 m
.00625 .80902 L
s
[(0)] -0.0125 .80902 1 0 Mshowa
0 1.14955 m
.00625 1.14955 L
s
[(2)] -0.0125 1.14955 1 0 Mshowa
0 1.49008 m
.00625 1.49008 L
s
[(4)] -0.0125 1.49008 1 0 Mshowa
.125 Mabswid
0 .21309 m
.00375 .21309 L
s
0 .29822 m
.00375 .29822 L
s
0 .38335 m
.00375 .38335 L
s
0 .55362 m
.00375 .55362 L
s
0 .63875 m
.00375 .63875 L
s
0 .72388 m
.00375 .72388 L
s
0 .89415 m
.00375 .89415 L
s
0 .97928 m
.00375 .97928 L
s
0 1.06442 m
.00375 1.06442 L
s
0 1.23468 m
.00375 1.23468 L
s
0 1.31981 m
.00375 1.31981 L
s
0 1.40495 m
.00375 1.40495 L
s
0 .04282 m
.00375 .04282 L
s
0 1.57521 m
.00375 1.57521 L
s
.25 Mabswid
0 0 m
0 1.61803 L
s
gsave
-0.01875 .80902 -107.25 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Im) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
75.250000 13.000000 moveto
(@) show
81.250000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
87.250000 13.000000 moveto
(D) show
93.250000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
.02733 1.61178 m
.02733 1.61803 L
s
.16288 1.61178 m
.16288 1.61803 L
s
.29843 1.61178 m
.29843 1.61803 L
s
.43398 1.61178 m
.43398 1.61803 L
s
.56954 1.61178 m
.56954 1.61803 L
s
.70509 1.61178 m
.70509 1.61803 L
s
.84064 1.61178 m
.84064 1.61803 L
s
.97619 1.61178 m
.97619 1.61803 L
s
.125 Mabswid
.05444 1.61428 m
.05444 1.61803 L
s
.08155 1.61428 m
.08155 1.61803 L
s
.10866 1.61428 m
.10866 1.61803 L
s
.13577 1.61428 m
.13577 1.61803 L
s
.18999 1.61428 m
.18999 1.61803 L
s
.2171 1.61428 m
.2171 1.61803 L
s
.24421 1.61428 m
.24421 1.61803 L
s
.27132 1.61428 m
.27132 1.61803 L
s
.32554 1.61428 m
.32554 1.61803 L
s
.35265 1.61428 m
.35265 1.61803 L
s
.37976 1.61428 m
.37976 1.61803 L
s
.40687 1.61428 m
.40687 1.61803 L
s
.46109 1.61428 m
.46109 1.61803 L
s
.4882 1.61428 m
.4882 1.61803 L
s
.51532 1.61428 m
.51532 1.61803 L
s
.54243 1.61428 m
.54243 1.61803 L
s
.59665 1.61428 m
.59665 1.61803 L
s
.62376 1.61428 m
.62376 1.61803 L
s
.65087 1.61428 m
.65087 1.61803 L
s
.67798 1.61428 m
.67798 1.61803 L
s
.7322 1.61428 m
.7322 1.61803 L
s
.75931 1.61428 m
.75931 1.61803 L
s
.78642 1.61428 m
.78642 1.61803 L
s
.81353 1.61428 m
.81353 1.61803 L
s
.86775 1.61428 m
.86775 1.61803 L
s
.89486 1.61428 m
.89486 1.61803 L
s
.92197 1.61428 m
.92197 1.61803 L
s
.94908 1.61428 m
.94908 1.61803 L
s
.00022 1.61428 m
.00022 1.61803 L
s
.25 Mabswid
0 1.61803 m
1 1.61803 L
s
gsave
.5 1.63053 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
69.000000 13.000000 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.99375 .12795 m
1 .12795 L
s
.99375 .46849 m
1 .46849 L
s
.99375 .80902 m
1 .80902 L
s
.99375 1.14955 m
1 1.14955 L
s
.99375 1.49008 m
1 1.49008 L
s
.125 Mabswid
.99625 .21309 m
1 .21309 L
s
.99625 .29822 m
1 .29822 L
s
.99625 .38335 m
1 .38335 L
s
.99625 .55362 m
1 .55362 L
s
.99625 .63875 m
1 .63875 L
s
.99625 .72388 m
1 .72388 L
s
.99625 .89415 m
1 .89415 L
s
.99625 .97928 m
1 .97928 L
s
.99625 1.06442 m
1 1.06442 L
s
.99625 1.23468 m
1 1.23468 L
s
.99625 1.31981 m
1 1.31981 L
s
.99625 1.40495 m
1 1.40495 L
s
.99625 .04282 m
1 .04282 L
s
.99625 1.57521 m
1 1.57521 L
s
.25 Mabswid
1 0 m
1 1.61803 L
s
gsave
1.0125 .80902 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
69.000000 13.000000 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.5 1.63053 -162.781 8.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30.5625 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 26.562500 moveto
 460.000000 26.562500 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 26.562500 lineto
closepath
clip newpath
63.000000 17.312500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.312500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(G) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
69.000000 17.312500 moveto
(@) show
75.000000 17.312500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
81.000000 17.312500 moveto
(D) show
87.000000 17.312500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(=) show
93.000000 17.312500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
140.000000 11.250000 moveto
(H) show
146.000000 11.250000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
154.375000 11.250000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
162.750000 11.250000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
168.750000 11.250000 moveto
(L) show
177.375000 11.250000 moveto
(H) show
183.375000 11.250000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
191.750000 11.250000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
200.125000 11.250000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
212.125000 11.250000 moveto
(L) show
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
97.375000 17.312500 moveto
(\\200) show
99.250000 17.312500 moveto
(\\200) show
101.125000 17.312500 moveto
(\\200) show
103.000000 17.312500 moveto
(\\200) show
104.875000 17.312500 moveto
(\\200) show
106.750000 17.312500 moveto
(\\200) show
108.625000 17.312500 moveto
(\\200) show
110.500000 17.312500 moveto
(\\200) show
112.375000 17.312500 moveto
(\\200) show
114.250000 17.312500 moveto
(\\200) show
116.125000 17.312500 moveto
(\\200) show
118.000000 17.312500 moveto
(\\200) show
119.875000 17.312500 moveto
(\\200) show
121.750000 17.312500 moveto
(\\200) show
123.625000 17.312500 moveto
(\\200) show
125.500000 17.312500 moveto
(\\200) show
127.375000 17.312500 moveto
(\\200) show
129.250000 17.312500 moveto
(\\200) show
131.125000 17.312500 moveto
(\\200) show
133.000000 17.312500 moveto
(\\200) show
134.875000 17.312500 moveto
(\\200) show
136.750000 17.312500 moveto
(\\200) show
138.625000 17.312500 moveto
(\\200) show
140.500000 17.312500 moveto
(\\200) show
142.375000 17.312500 moveto
(\\200) show
144.250000 17.312500 moveto
(\\200) show
146.125000 17.312500 moveto
(\\200) show
148.000000 17.312500 moveto
(\\200) show
149.875000 17.312500 moveto
(\\200) show
151.750000 17.312500 moveto
(\\200) show
153.625000 17.312500 moveto
(\\200) show
155.500000 17.312500 moveto
(\\200) show
157.375000 17.312500 moveto
(\\200) show
159.250000 17.312500 moveto
(\\200) show
161.125000 17.312500 moveto
(\\200) show
163.000000 17.312500 moveto
(\\200) show
164.875000 17.312500 moveto
(\\200) show
166.750000 17.312500 moveto
(\\200) show
168.625000 17.312500 moveto
(\\200) show
170.500000 17.312500 moveto
(\\200) show
172.375000 17.312500 moveto
(\\200) show
174.250000 17.312500 moveto
(\\200) show
176.125000 17.312500 moveto
(\\200) show
178.000000 17.312500 moveto
(\\200) show
179.875000 17.312500 moveto
(\\200) show
181.750000 17.312500 moveto
(\\200) show
183.625000 17.312500 moveto
(\\200) show
185.500000 17.312500 moveto
(\\200) show
187.375000 17.312500 moveto
(\\200) show
189.250000 17.312500 moveto
(\\200) show
191.125000 17.312500 moveto
(\\200) show
193.000000 17.312500 moveto
(\\200) show
194.875000 17.312500 moveto
(\\200) show
196.750000 17.312500 moveto
(\\200) show
198.625000 17.312500 moveto
(\\200) show
200.500000 17.312500 moveto
(\\200) show
202.375000 17.312500 moveto
(\\200) show
204.250000 17.312500 moveto
(\\200) show
206.125000 17.312500 moveto
(\\200) show
208.000000 17.312500 moveto
(\\200) show
209.875000 17.312500 moveto
(\\200) show
211.750000 17.312500 moveto
(\\200) show
213.625000 17.312500 moveto
(\\200) show
215.500000 17.312500 moveto
(\\200) show
217.375000 17.312500 moveto
(\\200) show
219.250000 17.312500 moveto
(\\200) show
221.125000 17.312500 moveto
(\\200) show
223.000000 17.312500 moveto
(\\200) show
224.875000 17.312500 moveto
(\\200) show
226.750000 17.312500 moveto
(\\200) show
228.625000 17.312500 moveto
(\\200) show
230.500000 17.312500 moveto
(\\200) show
232.375000 17.312500 moveto
(\\200) show
234.250000 17.312500 moveto
(\\200) show
236.125000 17.312500 moveto
(\\200) show
238.000000 17.312500 moveto
(\\200) show
239.875000 17.312500 moveto
(\\200) show
241.750000 17.312500 moveto
(\\200) show
243.625000 17.312500 moveto
(\\200) show
245.500000 17.312500 moveto
(\\200) show
247.375000 17.312500 moveto
(\\200) show
249.250000 17.312500 moveto
(\\200) show
251.125000 17.312500 moveto
(\\200) show
253.000000 17.312500 moveto
(\\200) show
254.875000 17.312500 moveto
(\\200) show
256.750000 17.312500 moveto
(\\200) show
258.625000 17.312500 moveto
(\\200) show
258.937500 17.312500 moveto
(\\200) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
98.687500 23.625000 moveto
(H) show
104.687500 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
113.062500 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
121.437500 23.625000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
127.437500 23.625000 moveto
(L) show
136.062500 23.625000 moveto
(H) show
142.062500 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
148.062500 21.062500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
155.000000 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
163.375000 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
171.750000 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
180.125000 23.625000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
186.125000 23.625000 moveto
(L) show
194.750000 23.625000 moveto
(H) show
200.750000 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
206.750000 21.062500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
213.687500 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
222.062500 23.625000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
230.687500 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
239.062500 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
247.437500 23.625000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
253.437500 23.625000 moveto
(L) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier-Italic
%%+ font Math1Mono
%%+ font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier-Italic
%%+ Math1Mono
%%+ Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier-Italic
%%+ font Math1Mono
%%+ font Math2Mono
%%+ font Courier
grestore
0 0 m
1 0 L
1 1.61803 L
0 1.61803 L
closepath
clip
newpath
.75 g
.5 Mabswid
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
1 .99952 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
1 1.2195 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
1 1.51999 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
.80584 1.61803 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
.60656 1.61803 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
.43398 1.61803 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
.26141 1.61803 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
.06213 1.61803 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
0 1.35414 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
0 1.12375 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
0 .95508 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
0 .80902 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
0 .66295 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
0 .49429 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
0 .26389 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
.06213 0 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
.26141 0 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
.43398 0 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
.60656 0 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
.80584 0 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
1 .09805 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
1 .39854 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
1 .61851 L
s
.43398 .80902 m
0 0 rlineto s
.43398 .80902 m
1 .80902 L
s
.52887 .80902 m
.52812 .82395 L
.52589 .83866 L
.52221 .85289 L
.51713 .86644 L
.51075 .87907 L
.50315 .89061 L
.49447 .90085 L
.48483 .90965 L
.47438 .91686 L
.46331 .92237 L
.45176 .92609 L
.43994 .92797 L
.42803 .92797 L
.4162 .92609 L
.40466 .92237 L
.39358 .91686 L
.38314 .90965 L
.3735 .90085 L
.36482 .89061 L
.35722 .87907 L
.35083 .86644 L
.34576 .85289 L
.34208 .83866 L
.33985 .82395 L
.3391 .80902 L
.33985 .79408 L
.34208 .77938 L
.34576 .76514 L
.35083 .7516 L
.35722 .73896 L
.36482 .72743 L
.3735 .71718 L
.38314 .70838 L
.39358 .70117 L
.40466 .69566 L
.4162 .69194 L
.42803 .69007 L
.43994 .69007 L
.45176 .69194 L
.46331 .69566 L
.47438 .70117 L
.48483 .70838 L
.49447 .71718 L
.50315 .72743 L
.51075 .73896 L
.51713 .7516 L
.52221 .76514 L
.52589 .77938 L
.52812 .79408 L
Mistroke
.52887 .80902 L
Mfstroke
.62376 .80902 m
.62226 .83889 L
.61779 .8683 L
.61043 .89677 L
.60028 .92385 L
.58751 .94913 L
.57232 .97219 L
.55495 .99269 L
.53567 1.01028 L
.51479 1.0247 L
.49263 1.03572 L
.46954 1.04317 L
.4459 1.04692 L
.42207 1.04692 L
.39842 1.04317 L
.37534 1.03572 L
.35318 1.0247 L
.3323 1.01028 L
.31302 .99269 L
.29565 .97219 L
.28046 .94913 L
.26769 .92385 L
.25754 .89677 L
.25017 .8683 L
.24571 .83889 L
.24421 .80902 L
.24571 .77914 L
.25017 .74974 L
.25754 .72127 L
.26769 .69418 L
.28046 .66891 L
.29565 .64584 L
.31302 .62535 L
.3323 .60775 L
.35318 .59333 L
.37534 .58231 L
.39842 .57487 L
.42207 .57112 L
.4459 .57112 L
.46954 .57487 L
.49263 .58231 L
.51479 .59333 L
.53567 .60775 L
.55495 .62535 L
.57232 .64584 L
.58751 .66891 L
.60028 .69418 L
.61043 .72127 L
.61779 .74974 L
.62226 .77914 L
Mistroke
.62376 .80902 L
Mfstroke
.71864 .80902 m
.7164 .85383 L
.7097 .89794 L
.69865 .94064 L
.68343 .98127 L
.66428 1.01918 L
.64149 1.05378 L
.61543 1.08452 L
.58651 1.11091 L
.55519 1.13255 L
.52195 1.14908 L
.48732 1.16024 L
.45186 1.16587 L
.41611 1.16587 L
.38064 1.16024 L
.34602 1.14908 L
.31278 1.13255 L
.28146 1.11091 L
.25254 1.08452 L
.22648 1.05378 L
.20369 1.01918 L
.18454 .98127 L
.16932 .94064 L
.15827 .89794 L
.15157 .85383 L
.14933 .80902 L
.15157 .7642 L
.15827 .7201 L
.16932 .67739 L
.18454 .63676 L
.20369 .59885 L
.22648 .56425 L
.25254 .53351 L
.28146 .50712 L
.31278 .48549 L
.34602 .46896 L
.38064 .45779 L
.41611 .45216 L
.45186 .45216 L
.48732 .45779 L
.52195 .46896 L
.55519 .48549 L
.58651 .50712 L
.61543 .53351 L
.64149 .56425 L
.66428 .59885 L
.68343 .63676 L
.69865 .67739 L
.7097 .7201 L
.7164 .7642 L
Mistroke
.71864 .80902 L
Mfstroke
.81353 .80902 m
.81054 .86877 L
.8016 .92758 L
.78688 .98452 L
.76658 1.03869 L
.74104 1.08924 L
.71066 1.13537 L
.67591 1.17635 L
.63735 1.21155 L
.59559 1.24039 L
.55127 1.26243 L
.5051 1.27732 L
.45782 1.28482 L
.41015 1.28482 L
.36286 1.27732 L
.3167 1.26243 L
.27238 1.24039 L
.23061 1.21155 L
.19205 1.17635 L
.15731 1.13537 L
.12693 1.08924 L
.10139 1.03869 L
.08109 .98452 L
.06636 .92758 L
.05743 .86877 L
.05444 .80902 L
.05743 .74927 L
.06636 .69046 L
.08109 .63352 L
.10139 .57934 L
.12693 .52879 L
.15731 .48266 L
.19205 .44168 L
.23061 .40649 L
.27238 .37765 L
.3167 .35561 L
.36286 .34072 L
.41015 .33321 L
.45782 .33321 L
.5051 .34072 L
.55127 .35561 L
.59559 .37765 L
.63735 .40649 L
.67591 .44168 L
.71066 .48266 L
.74104 .52879 L
.76658 .57934 L
.78688 .63352 L
.8016 .69046 L
.81054 .74927 L
Mistroke
.81353 .80902 L
Mfstroke
.90841 .80902 m
.90467 .88371 L
.89351 .95722 L
.8751 1.02839 L
.84973 1.09611 L
.81781 1.1593 L
.77983 1.21696 L
.7364 1.26819 L
.6882 1.31218 L
.63599 1.34823 L
.58059 1.37578 L
.52288 1.39439 L
.46377 1.40377 L
.40419 1.40377 L
.34508 1.39439 L
.28738 1.37578 L
.23198 1.34823 L
.17977 1.31218 L
.13157 1.26819 L
.08814 1.21696 L
.05016 1.1593 L
.01824 1.09611 L
s
.01824 1.09611 m
0 1.04743 L
s
0 .57061 m
.01824 .52193 L
.05016 .45874 L
.08814 .40107 L
.13157 .34984 L
.17977 .30586 L
.23198 .2698 L
.28738 .24225 L
.34508 .22364 L
.40419 .21426 L
.46377 .21426 L
.52288 .22364 L
.58059 .24225 L
.63599 .2698 L
.6882 .30586 L
.7364 .34984 L
.77983 .40107 L
.81781 .45874 L
.84973 .52193 L
.8751 .58964 L
.89351 .66082 L
.90467 .73433 L
.90841 .80902 L
s
1 .87492 m
.99881 .89864 L
.98541 .98686 L
.96332 1.07227 L
.93288 1.15353 L
.89457 1.22935 L
.849 1.29855 L
.79688 1.36002 L
.73904 1.41281 L
.67639 1.45607 L
.60991 1.48913 L
.54066 1.51147 L
.46973 1.52272 L
.39824 1.52272 L
.32731 1.51147 L
.25806 1.48913 L
.19158 1.45607 L
.12893 1.41281 L
.07109 1.36002 L
.01897 1.29855 L
s
.01897 1.29855 m
0 1.26974 L
s
0 .34829 m
.01897 .31949 L
.07109 .25801 L
.12893 .20522 L
.19158 .16196 L
.25806 .1289 L
.32731 .10657 L
.39824 .09531 L
.46973 .09531 L
.54066 .10657 L
.60991 .1289 L
.67639 .16196 L
.73904 .20522 L
.79688 .25801 L
.849 .31949 L
.89457 .38868 L
.93288 .46451 L
.96332 .54576 L
.98541 .63117 L
.99881 .71939 L
s
.99881 .71939 m
1 .74312 L
s
1 1.24267 m
.97134 1.29941 L
.91817 1.38014 L
.85736 1.45186 L
.78988 1.51344 L
.71679 1.56392 L
.63923 1.60249 L
s
.63923 1.60249 m
.59103 1.61803 L
s
.27694 1.61803 m
.22873 1.60249 L
.15118 1.56392 L
.07809 1.51344 L
.01061 1.45186 L
s
.01061 1.45186 m
0 1.43935 L
s
0 .17869 m
.01061 .16618 L
.07809 .10459 L
.15118 .05412 L
.22873 .01555 L
s
.22873 .01555 m
.27694 0 L
s
.59103 0 m
.63923 .01555 L
.71679 .05412 L
.78988 .10459 L
.85736 .16618 L
.91817 .2379 L
.97134 .31863 L
s
.97134 .31863 m
1 .37536 L
s
1 1.4425 m
.98734 1.46173 L
.91785 1.54369 L
.84072 1.61407 L
s
.84072 1.61407 m
.83499 1.61803 L
s
.03298 1.61803 m
.02724 1.61407 L
s
.02724 1.61407 m
0 1.58921 L
s
0 .02882 m
.02724 .00396 L
s
.02724 .00396 m
.03298 0 L
s
.83499 0 m
.84072 .00396 L
.91785 .07434 L
.98734 .15631 L
s
.98734 .15631 m
1 .17554 L
s
1 1.60996 m
.99316 1.61803 L
s
.99316 0 m
1 .00807 L
s
.75 0 0 r
.008 w
.43551 .80283 m
.43551 .80277 L
s
.75 0 .004 r
.43551 .80277 m
.43552 .80271 L
s
.75 0 .007 r
.43552 .80271 m
.43553 .80265 L
s
.75 0 .011 r
.43553 .80265 m
.43554 .80258 L
s
.75 0 .015 r
.43554 .80258 m
.43555 .80252 L
s
.75 0 .018 r
.43555 .80252 m
.43556 .80246 L
s
.75 0 .022 r
.43556 .80246 m
.43557 .80239 L
s
.75 0 .026 r
.43557 .80239 m
.43557 .80232 L
s
.75 0 .029 r
.43557 .80232 m
.43558 .80226 L
s
.75 0 .033 r
.43558 .80226 m
.43559 .80219 L
s
.75 0 .037 r
.43559 .80219 m
.4356 .80212 L
s
.75 0 .04 r
.4356 .80212 m
.43561 .80205 L
s
.75 0 .044 r
.43561 .80205 m
.43562 .80198 L
s
.75 0 .048 r
.43562 .80198 m
.43563 .8019 L
s
.75 0 .051 r
.43563 .8019 m
.43563 .80183 L
s
.75 0 .055 r
.43563 .80183 m
.43564 .80176 L
s
.75 0 .059 r
.43564 .80176 m
.43565 .80168 L
s
.75 0 .062 r
.43565 .80168 m
.43566 .80161 L
s
.75 0 .066 r
.43566 .80161 m
.43567 .80153 L
s
.75 0 .069 r
.43567 .80153 m
.43568 .80145 L
s
.75 0 .073 r
.43568 .80145 m
.43568 .80137 L
s
.75 0 .077 r
.43568 .80137 m
.43569 .80129 L
s
.75 0 .08 r
.43569 .80129 m
.4357 .80121 L
s
.75 0 .084 r
.4357 .80121 m
.43571 .80113 L
s
.75 0 .088 r
.43571 .80113 m
.43572 .80104 L
s
.75 0 .091 r
.43572 .80104 m
.43573 .80096 L
s
.75 0 .095 r
.43573 .80096 m
.43573 .80087 L
s
.75 0 .099 r
.43573 .80087 m
.43574 .80079 L
s
.75 0 .102 r
.43574 .80079 m
.43575 .8007 L
s
.75 0 .106 r
.43575 .8007 m
.43576 .80061 L
s
.75 0 .11 r
.43576 .80061 m
.43577 .80052 L
s
.75 0 .113 r
.43577 .80052 m
.43577 .80043 L
s
.75 0 .117 r
.43577 .80043 m
.43578 .80034 L
s
.75 0 .121 r
.43578 .80034 m
.43579 .80024 L
s
.75 0 .124 r
.43579 .80024 m
.4358 .80015 L
s
.75 0 .128 r
.4358 .80015 m
.4358 .80005 L
s
.75 0 .132 r
.4358 .80005 m
.43581 .79995 L
s
.75 0 .135 r
.43581 .79995 m
.43582 .79985 L
s
.75 0 .139 r
.43582 .79985 m
.43582 .79975 L
s
.75 0 .143 r
.43582 .79975 m
.43583 .79965 L
s
.75 0 .146 r
.43583 .79965 m
.43584 .79955 L
s
.75 0 .15 r
.43584 .79955 m
.43585 .79944 L
s
.75 0 .154 r
.43585 .79944 m
.43585 .79933 L
s
.75 0 .157 r
.43585 .79933 m
.43586 .79923 L
s
.75 0 .161 r
.43586 .79923 m
.43586 .79912 L
s
.75 0 .165 r
.43586 .79912 m
.43587 .79901 L
s
.75 0 .168 r
.43587 .79901 m
.43588 .79889 L
s
.75 0 .172 r
.43588 .79889 m
.43588 .79878 L
s
.75 0 .176 r
.43588 .79878 m
.43589 .79866 L
s
.75 0 .179 r
.43589 .79866 m
.43589 .79855 L
s
.75 0 .183 r
.43589 .79855 m
.4359 .79843 L
s
.75 0 .186 r
.4359 .79843 m
.4359 .79831 L
s
.75 0 .19 r
.4359 .79831 m
.43591 .79818 L
s
.75 0 .194 r
.43591 .79818 m
.43591 .79806 L
s
.75 0 .197 r
.43591 .79806 m
.43592 .79793 L
s
.75 0 .201 r
.43592 .79793 m
.43592 .7978 L
s
.75 0 .205 r
.43592 .7978 m
.43593 .79767 L
s
.75 0 .208 r
.43593 .79767 m
.43593 .79754 L
s
.75 0 .212 r
.43593 .79754 m
.43593 .79741 L
s
.75 0 .216 r
.43593 .79741 m
.43594 .79727 L
s
.75 0 .219 r
.43594 .79727 m
.43594 .79714 L
s
.75 0 .223 r
.43594 .79714 m
.43594 .797 L
s
.75 0 .227 r
.43594 .797 m
.43595 .79685 L
s
.75 0 .23 r
.43595 .79685 m
.43595 .79671 L
s
.75 0 .234 r
.43595 .79671 m
.43595 .79656 L
s
.75 0 .238 r
.43595 .79656 m
.43595 .79642 L
s
.75 0 .241 r
.43595 .79642 m
.43595 .79627 L
s
.75 0 .245 r
.43595 .79627 m
.43595 .79611 L
s
.75 0 .249 r
.43595 .79611 m
.43595 .79596 L
s
.75 0 .252 r
.43595 .79596 m
.43595 .7958 L
s
.75 0 .256 r
.43595 .7958 m
.43595 .79564 L
s
.75 0 .26 r
.43595 .79564 m
.43595 .79548 L
s
.75 0 .263 r
.43595 .79548 m
.43595 .79532 L
s
.75 0 .267 r
.43595 .79532 m
.43595 .79515 L
s
.75 0 .271 r
.43595 .79515 m
.43594 .79498 L
s
.75 0 .274 r
.43594 .79498 m
.43594 .79481 L
s
.75 0 .278 r
.43594 .79481 m
.43594 .79463 L
s
.75 0 .282 r
.43594 .79463 m
.43593 .79446 L
s
.75 0 .285 r
.43593 .79446 m
.43593 .79428 L
s
.75 0 .289 r
.43593 .79428 m
.43592 .79409 L
s
.75 0 .292 r
.43592 .79409 m
.43592 .79391 L
s
.75 0 .296 r
.43592 .79391 m
.43591 .79372 L
s
.75 0 .3 r
.43591 .79372 m
.43591 .79353 L
s
.75 0 .303 r
.43591 .79353 m
.4359 .79334 L
s
.75 0 .307 r
.4359 .79334 m
.43589 .79314 L
s
.75 0 .311 r
.43589 .79314 m
.43588 .79294 L
s
.75 0 .314 r
.43588 .79294 m
.43587 .79273 L
s
.75 0 .318 r
.43587 .79273 m
.43586 .79253 L
s
.75 0 .322 r
.43586 .79253 m
.43585 .79232 L
s
.75 0 .325 r
.43585 .79232 m
.43584 .79211 L
s
.75 0 .329 r
.43584 .79211 m
.43582 .79189 L
s
.75 0 .333 r
.43582 .79189 m
.43581 .79167 L
s
.75 0 .336 r
.43581 .79167 m
.43579 .79145 L
s
.75 0 .34 r
.43579 .79145 m
.43578 .79122 L
s
.75 0 .344 r
.43578 .79122 m
.43576 .79099 L
s
.75 0 .347 r
.43576 .79099 m
.43574 .79075 L
s
.75 0 .351 r
.43574 .79075 m
.43572 .79052 L
s
.75 0 .355 r
.43572 .79052 m
.4357 .79028 L
s
.75 0 .358 r
.4357 .79028 m
.43568 .79003 L
s
.75 0 .362 r
.43568 .79003 m
.43566 .78978 L
s
.75 0 .366 r
.43566 .78978 m
.43563 .78953 L
s
.75 0 .369 r
.43563 .78953 m
.43561 .78927 L
s
.75 0 .373 r
.43561 .78927 m
.43558 .78901 L
s
.75 0 .377 r
.43558 .78901 m
.43555 .78874 L
s
.75 0 .38 r
.43555 .78874 m
.43553 .78847 L
s
.75 0 .384 r
.43553 .78847 m
.43549 .7882 L
s
.75 0 .388 r
.43549 .7882 m
.43546 .78792 L
s
.75 0 .391 r
.43546 .78792 m
.43543 .78764 L
s
.75 0 .395 r
.43543 .78764 m
.43539 .78735 L
s
.75 0 .399 r
.43539 .78735 m
.43536 .78706 L
s
.75 0 .402 r
.43536 .78706 m
.43532 .78676 L
s
.75 0 .406 r
.43532 .78676 m
.43528 .78646 L
s
.75 0 .409 r
.43528 .78646 m
.43523 .78615 L
s
.75 0 .413 r
.43523 .78615 m
.43519 .78584 L
s
.75 0 .417 r
.43519 .78584 m
.43514 .78552 L
s
.75 0 .42 r
.43514 .78552 m
.43509 .7852 L
s
.75 0 .424 r
.43509 .7852 m
.43504 .78487 L
s
.75 0 .428 r
.43504 .78487 m
.43499 .78453 L
s
.75 0 .431 r
.43499 .78453 m
.43494 .78419 L
s
.75 0 .435 r
.43494 .78419 m
.43488 .78385 L
s
.75 0 .439 r
.43488 .78385 m
.43482 .7835 L
s
.75 0 .442 r
.43482 .7835 m
.43476 .78314 L
s
.75 0 .446 r
.43476 .78314 m
.43469 .78278 L
s
.75 0 .45 r
.43469 .78278 m
.43462 .78241 L
s
.75 0 .453 r
.43462 .78241 m
.43455 .78204 L
s
.75 0 .457 r
.43455 .78204 m
.43448 .78166 L
s
.75 0 .461 r
.43448 .78166 m
.4344 .78127 L
s
.75 0 .464 r
.4344 .78127 m
.43432 .78088 L
s
.75 0 .468 r
.43432 .78088 m
.43424 .78048 L
s
.75 0 .472 r
.43424 .78048 m
.43415 .78007 L
s
.75 0 .475 r
.43415 .78007 m
.43406 .77966 L
s
.75 0 .479 r
.43406 .77966 m
.43397 .77924 L
s
.75 0 .483 r
.43397 .77924 m
.43387 .77881 L
s
.75 0 .486 r
.43387 .77881 m
.43377 .77837 L
s
.75 0 .49 r
.43377 .77837 m
.43367 .77793 L
s
.75 0 .494 r
.43367 .77793 m
.43356 .77748 L
s
.75 0 .497 r
.43356 .77748 m
.43345 .77703 L
s
.75 0 .501 r
.43345 .77703 m
.43333 .77656 L
s
.75 0 .505 r
.43333 .77656 m
.43321 .77609 L
s
.75 0 .508 r
.43321 .77609 m
.43308 .77561 L
s
.75 0 .512 r
.43308 .77561 m
.43295 .77512 L
s
.75 0 .516 r
.43295 .77512 m
.43281 .77462 L
s
.75 0 .519 r
.43281 .77462 m
.43267 .77412 L
s
.75 0 .523 r
.43267 .77412 m
.43252 .7736 L
s
.75 0 .527 r
.43252 .7736 m
.43237 .77308 L
s
.75 0 .53 r
.43237 .77308 m
.43221 .77255 L
s
.75 0 .534 r
.43221 .77255 m
.43205 .77201 L
s
.75 0 .537 r
.43205 .77201 m
.43188 .77146 L
s
.75 0 .541 r
.43188 .77146 m
.4317 .7709 L
s
.75 0 .545 r
.4317 .7709 m
.43152 .77033 L
s
.75 0 .548 r
.43152 .77033 m
.43133 .76975 L
s
.75 0 .552 r
.43133 .76975 m
.43113 .76917 L
s
.75 0 .556 r
.43113 .76917 m
.43093 .76857 L
s
.75 0 .559 r
.43093 .76857 m
.43072 .76796 L
s
.75 0 .563 r
.43072 .76796 m
.4305 .76734 L
s
.75 0 .567 r
.4305 .76734 m
.43027 .76671 L
s
.75 0 .57 r
.43027 .76671 m
.43003 .76608 L
s
.75 0 .574 r
.43003 .76608 m
.42979 .76543 L
s
.75 0 .578 r
.42979 .76543 m
.42954 .76477 L
s
.75 0 .581 r
.42954 .76477 m
.42927 .7641 L
s
.75 0 .585 r
.42927 .7641 m
.429 .76341 L
s
.75 0 .589 r
.429 .76341 m
.42872 .76272 L
s
.75 0 .592 r
.42872 .76272 m
.42843 .76201 L
s
.75 0 .596 r
.42843 .76201 m
.42813 .7613 L
s
.75 0 .6 r
.42813 .7613 m
.42781 .76057 L
s
.75 0 .603 r
.42781 .76057 m
.42749 .75983 L
s
.75 0 .607 r
.42749 .75983 m
.42715 .75908 L
s
.75 0 .611 r
.42715 .75908 m
.4268 .75831 L
s
.75 0 .614 r
.4268 .75831 m
.42644 .75754 L
s
.75 0 .618 r
.42644 .75754 m
.42607 .75675 L
s
.75 0 .622 r
.42607 .75675 m
.42568 .75595 L
s
.75 0 .625 r
.42568 .75595 m
.42528 .75513 L
s
.75 0 .629 r
.42528 .75513 m
.42486 .7543 L
s
.75 0 .633 r
.42486 .7543 m
.42443 .75346 L
s
.75 0 .636 r
.42443 .75346 m
.42399 .75261 L
s
.75 0 .64 r
.42399 .75261 m
.42352 .75174 L
s
.75 0 .644 r
.42352 .75174 m
.42305 .75086 L
s
.75 0 .647 r
.42305 .75086 m
.42255 .74997 L
s
.75 0 .651 r
.42255 .74997 m
.42204 .74906 L
s
.75 0 .654 r
.42204 .74906 m
.42151 .74814 L
s
.75 0 .658 r
.42151 .74814 m
.42096 .7472 L
s
.75 0 .662 r
.42096 .7472 m
.42039 .74626 L
s
.75 0 .665 r
.42039 .74626 m
.4198 .74529 L
s
.75 0 .669 r
.4198 .74529 m
.41919 .74432 L
s
.75 0 .673 r
.41919 .74432 m
.41856 .74333 L
s
.75 0 .676 r
.41856 .74333 m
.4179 .74232 L
s
.75 0 .68 r
.4179 .74232 m
.41723 .7413 L
s
.75 0 .684 r
.41723 .7413 m
.41653 .74027 L
s
.75 0 .687 r
.41653 .74027 m
.4158 .73922 L
s
.75 0 .691 r
.4158 .73922 m
.41505 .73816 L
s
.75 0 .695 r
.41505 .73816 m
.41427 .73709 L
s
.75 0 .698 r
.41427 .73709 m
.41347 .736 L
s
.75 0 .702 r
.41347 .736 m
.41264 .7349 L
s
.75 0 .706 r
.41264 .7349 m
.41178 .73378 L
s
.75 0 .709 r
.41178 .73378 m
.41088 .73266 L
s
.75 0 .713 r
.41088 .73266 m
.40996 .73151 L
s
.75 0 .717 r
.40996 .73151 m
.40901 .73036 L
s
.75 0 .72 r
.40901 .73036 m
.40802 .72919 L
s
.75 0 .724 r
.40802 .72919 m
.407 .72801 L
s
.75 0 .728 r
.407 .72801 m
.40594 .72682 L
s
.75 0 .731 r
.40594 .72682 m
.40484 .72562 L
s
.75 0 .735 r
.40484 .72562 m
.40371 .7244 L
s
.75 0 .739 r
.40371 .7244 m
.40254 .72317 L
s
.75 0 .742 r
.40254 .72317 m
.40133 .72194 L
s
.75 0 .746 r
.40133 .72194 m
.40008 .72069 L
s
.75 0 .75 r
.40008 .72069 m
.39878 .71943 L
s
.747 0 .75 r
.39878 .71943 m
.39744 .71817 L
s
.743 0 .75 r
.39744 .71817 m
.39605 .7169 L
s
.739 0 .75 r
.39605 .7169 m
.39462 .71562 L
s
.736 0 .75 r
.39462 .71562 m
.39314 .71433 L
s
.732 0 .75 r
.39314 .71433 m
.39161 .71304 L
s
.729 0 .75 r
.39161 .71304 m
.39002 .71174 L
s
.725 0 .75 r
.39002 .71174 m
.38838 .71044 L
s
.721 0 .75 r
.38838 .71044 m
.38669 .70914 L
s
.718 0 .75 r
.38669 .70914 m
.38494 .70783 L
s
.714 0 .75 r
.38494 .70783 m
.38313 .70653 L
s
.71 0 .75 r
.38313 .70653 m
.38126 .70523 L
s
.707 0 .75 r
.38126 .70523 m
.37933 .70393 L
s
.703 0 .75 r
.37933 .70393 m
.37733 .70263 L
s
.699 0 .75 r
.37733 .70263 m
.37527 .70135 L
s
.696 0 .75 r
.37527 .70135 m
.37314 .70007 L
s
.692 0 .75 r
.37314 .70007 m
.37093 .6988 L
s
.688 0 .75 r
.37093 .6988 m
.36866 .69754 L
s
.685 0 .75 r
.36866 .69754 m
.36632 .6963 L
s
.681 0 .75 r
.36632 .6963 m
.36389 .69507 L
s
.677 0 .75 r
.36389 .69507 m
.36139 .69387 L
s
.674 0 .75 r
.36139 .69387 m
.35881 .69269 L
s
.67 0 .75 r
.35881 .69269 m
.35615 .69153 L
s
.666 0 .75 r
.35615 .69153 m
.3534 .6904 L
s
.663 0 .75 r
.3534 .6904 m
.35056 .68931 L
s
.659 0 .75 r
.35056 .68931 m
.34764 .68825 L
s
.655 0 .75 r
.34764 .68825 m
.34462 .68723 L
s
.652 0 .75 r
.34462 .68723 m
.34151 .68625 L
s
.648 0 .75 r
.34151 .68625 m
.33831 .68532 L
s
.644 0 .75 r
.33831 .68532 m
.33501 .68444 L
s
.641 0 .75 r
.33501 .68444 m
.33161 .68362 L
s
.637 0 .75 r
.33161 .68362 m
.3281 .68286 L
s
.633 0 .75 r
.3281 .68286 m
.3245 .68216 L
s
.63 0 .75 r
.3245 .68216 m
.32079 .68154 L
s
.626 0 .75 r
.32079 .68154 m
.31696 .681 L
s
.623 0 .75 r
.31696 .681 m
.31303 .68054 L
s
.619 0 .75 r
.31303 .68054 m
.30899 .68017 L
s
.615 0 .75 r
.30899 .68017 m
.30484 .6799 L
s
.612 0 .75 r
.30484 .6799 m
.30057 .67973 L
s
.608 0 .75 r
.30057 .67973 m
.29618 .67967 L
s
.604 0 .75 r
.29618 .67967 m
.29168 .67973 L
s
.601 0 .75 r
.29168 .67973 m
.28706 .67993 L
s
.597 0 .75 r
.28706 .67993 m
.28231 .68025 L
s
.593 0 .75 r
.28231 .68025 m
.27745 .68072 L
s
.59 0 .75 r
.27745 .68072 m
.27247 .68135 L
s
.586 0 .75 r
.27247 .68135 m
.26737 .68214 L
s
.582 0 .75 r
.26737 .68214 m
.26214 .6831 L
s
.579 0 .75 r
.26214 .6831 m
.25679 .68425 L
s
.575 0 .75 r
.25679 .68425 m
.25133 .68559 L
s
.571 0 .75 r
.25133 .68559 m
.24574 .68714 L
s
.568 0 .75 r
.24574 .68714 m
.24004 .68891 L
s
.564 0 .75 r
.24004 .68891 m
.23422 .69091 L
s
.56 0 .75 r
.23422 .69091 m
.22828 .69315 L
s
.557 0 .75 r
.22828 .69315 m
.22224 .69565 L
s
.553 0 .75 r
.22224 .69565 m
.21609 .69842 L
s
.549 0 .75 r
.21609 .69842 m
.20983 .70147 L
s
.546 0 .75 r
.20983 .70147 m
.20348 .70481 L
s
.542 0 .75 r
.20348 .70481 m
.19703 .70847 L
s
.538 0 .75 r
.19703 .70847 m
.1905 .71246 L
s
.535 0 .75 r
.1905 .71246 m
.18388 .71678 L
s
.531 0 .75 r
.18388 .71678 m
.17719 .72146 L
s
.527 0 .75 r
.17719 .72146 m
.17044 .72651 L
s
.524 0 .75 r
.17044 .72651 m
.16363 .73194 L
s
.52 0 .75 r
.16363 .73194 m
.15677 .73777 L
s
.516 0 .75 r
.15677 .73777 m
.14989 .74402 L
s
.513 0 .75 r
.14989 .74402 m
.14298 .75071 L
s
.509 0 .75 r
.14298 .75071 m
.13606 .75783 L
s
.505 0 .75 r
.13606 .75783 m
.12915 .76542 L
s
.502 0 .75 r
.12915 .76542 m
.12226 .77348 L
s
.498 0 .75 r
.12226 .77348 m
.11542 .78203 L
s
.495 0 .75 r
.11542 .78203 m
.10863 .79108 L
s
.491 0 .75 r
.10863 .79108 m
.10192 .80064 L
s
.487 0 .75 r
.10192 .80064 m
.09531 .81072 L
s
.484 0 .75 r
.09531 .81072 m
.08882 .82134 L
s
.48 0 .75 r
.08882 .82134 m
.08247 .8325 L
s
.476 0 .75 r
.08247 .8325 m
.07629 .84421 L
s
.473 0 .75 r
.07629 .84421 m
.07031 .85647 L
s
.469 0 .75 r
.07031 .85647 m
.06455 .86929 L
s
.465 0 .75 r
.06455 .86929 m
.05904 .88268 L
s
.462 0 .75 r
.05904 .88268 m
.05381 .89662 L
s
.458 0 .75 r
.05381 .89662 m
.04889 .91112 L
s
.454 0 .75 r
.04889 .91112 m
.04432 .92617 L
s
.451 0 .75 r
.04432 .92617 m
.04011 .94177 L
s
.447 0 .75 r
.04011 .94177 m
.03631 .9579 L
s
.443 0 .75 r
.03631 .9579 m
.03295 .97455 L
s
.44 0 .75 r
.03295 .97455 m
.03006 .9917 L
s
.436 0 .75 r
.03006 .9917 m
.02767 1.00933 L
s
.432 0 .75 r
.02767 1.00933 m
.02582 1.02741 L
s
.429 0 .75 r
.02582 1.02741 m
.02454 1.04592 L
s
.425 0 .75 r
.02454 1.04592 m
.02386 1.06483 L
s
.421 0 .75 r
.02386 1.06483 m
.02381 1.0841 L
s
.418 0 .75 r
.02381 1.0841 m
.02442 1.10369 L
s
.414 0 .75 r
.02442 1.10369 m
.02571 1.12356 L
s
.41 0 .75 r
.02571 1.12356 m
.02772 1.14367 L
s
.407 0 .75 r
.02772 1.14367 m
.03046 1.16396 L
s
.403 0 .75 r
.03046 1.16396 m
.03395 1.18437 L
s
.399 0 .75 r
.03395 1.18437 m
.03822 1.20487 L
s
.396 0 .75 r
.03822 1.20487 m
.04327 1.22538 L
s
.392 0 .75 r
.04327 1.22538 m
.04912 1.24585 L
s
.388 0 .75 r
.04912 1.24585 m
.05577 1.26621 L
s
.385 0 .75 r
.05577 1.26621 m
.06322 1.28641 L
s
.381 0 .75 r
.06322 1.28641 m
.07148 1.30637 L
s
.378 0 .75 r
.07148 1.30637 m
.08054 1.32604 L
s
.374 0 .75 r
.08054 1.32604 m
.09039 1.34534 L
s
.37 0 .75 r
.09039 1.34534 m
.10102 1.36421 L
s
.367 0 .75 r
.10102 1.36421 m
.11241 1.3826 L
s
.363 0 .75 r
.11241 1.3826 m
.12453 1.40044 L
s
.359 0 .75 r
.12453 1.40044 m
.13736 1.41766 L
s
.356 0 .75 r
.13736 1.41766 m
.15088 1.43423 L
s
.352 0 .75 r
.15088 1.43423 m
.16504 1.45007 L
s
.348 0 .75 r
.16504 1.45007 m
.17981 1.46514 L
s
.345 0 .75 r
.17981 1.46514 m
.19515 1.4794 L
s
.341 0 .75 r
.19515 1.4794 m
.21102 1.4928 L
s
.337 0 .75 r
.21102 1.4928 m
.22738 1.50532 L
s
.334 0 .75 r
.22738 1.50532 m
.24417 1.51691 L
s
.33 0 .75 r
.24417 1.51691 m
.26135 1.52755 L
s
.326 0 .75 r
.26135 1.52755 m
.27888 1.53722 L
s
.323 0 .75 r
.27888 1.53722 m
.29669 1.5459 L
s
.319 0 .75 r
.29669 1.5459 m
.31475 1.55358 L
s
.315 0 .75 r
.31475 1.55358 m
.33299 1.56026 L
s
.312 0 .75 r
.33299 1.56026 m
.35139 1.56594 L
s
.308 0 .75 r
.35139 1.56594 m
.36987 1.57061 L
s
.304 0 .75 r
.36987 1.57061 m
.38841 1.57429 L
s
.301 0 .75 r
.38841 1.57429 m
.40695 1.57699 L
s
.297 0 .75 r
.40695 1.57699 m
.42544 1.57872 L
s
.293 0 .75 r
.42544 1.57872 m
.44386 1.57951 L
s
.29 0 .75 r
.44386 1.57951 m
.46216 1.57937 L
s
.286 0 .75 r
.46216 1.57937 m
.4803 1.57834 L
s
.282 0 .75 r
.4803 1.57834 m
.49825 1.57644 L
s
.279 0 .75 r
.49825 1.57644 m
.51597 1.57369 L
s
.275 0 .75 r
.51597 1.57369 m
.53344 1.57014 L
s
.272 0 .75 r
.53344 1.57014 m
.55064 1.56582 L
s
.268 0 .75 r
.55064 1.56582 m
.56753 1.56076 L
s
.264 0 .75 r
.56753 1.56076 m
.5841 1.55499 L
s
.261 0 .75 r
.5841 1.55499 m
.60032 1.54856 L
s
.257 0 .75 r
.60032 1.54856 m
.61619 1.5415 L
s
.253 0 .75 r
.61619 1.5415 m
.63168 1.53384 L
s
.25 0 .75 r
.63168 1.53384 m
.64679 1.52562 L
s
.246 0 .75 r
.64679 1.52562 m
.6615 1.51688 L
s
.242 0 .75 r
.6615 1.51688 m
.67582 1.50765 L
s
.239 0 .75 r
.67582 1.50765 m
.68972 1.49796 L
s
.235 0 .75 r
.68972 1.49796 m
.70322 1.48786 L
s
.231 0 .75 r
.70322 1.48786 m
.7163 1.47736 L
s
.228 0 .75 r
.7163 1.47736 m
.72897 1.46651 L
s
.224 0 .75 r
.72897 1.46651 m
.74122 1.45533 L
s
.22 0 .75 r
.74122 1.45533 m
.75306 1.44385 L
s
.217 0 .75 r
.75306 1.44385 m
.7645 1.43209 L
s
.213 0 .75 r
.7645 1.43209 m
.77553 1.4201 L
s
.209 0 .75 r
.77553 1.4201 m
.78617 1.40788 L
s
.206 0 .75 r
.78617 1.40788 m
.79641 1.39546 L
s
.202 0 .75 r
.79641 1.39546 m
.80626 1.38287 L
s
.198 0 .75 r
.80626 1.38287 m
.81574 1.37012 L
s
.195 0 .75 r
.81574 1.37012 m
.82484 1.35724 L
s
.191 0 .75 r
.82484 1.35724 m
.83358 1.34423 L
s
.187 0 .75 r
.83358 1.34423 m
.84196 1.33113 L
s
.184 0 .75 r
.84196 1.33113 m
.85 1.31795 L
s
.18 0 .75 r
.85 1.31795 m
.8577 1.30469 L
s
.176 0 .75 r
.8577 1.30469 m
.86507 1.29137 L
s
.173 0 .75 r
.86507 1.29137 m
.87211 1.27801 L
s
.169 0 .75 r
.87211 1.27801 m
.87885 1.26462 L
s
.165 0 .75 r
.87885 1.26462 m
.88529 1.2512 L
s
.162 0 .75 r
.88529 1.2512 m
.89143 1.23777 L
s
.158 0 .75 r
.89143 1.23777 m
.89728 1.22434 L
s
.154 0 .75 r
.89728 1.22434 m
.90286 1.2109 L
s
.151 0 .75 r
.90286 1.2109 m
.90818 1.19747 L
s
.147 0 .75 r
.90818 1.19747 m
.91323 1.18406 L
s
.144 0 .75 r
.91323 1.18406 m
.91804 1.17067 L
s
.14 0 .75 r
.91804 1.17067 m
.9226 1.1573 L
s
.136 0 .75 r
.9226 1.1573 m
.92693 1.14396 L
s
.133 0 .75 r
.92693 1.14396 m
.93103 1.13065 L
s
.129 0 .75 r
.93103 1.13065 m
.93491 1.11737 L
s
.125 0 .75 r
.93491 1.11737 m
.93857 1.10413 L
s
.122 0 .75 r
.93857 1.10413 m
.94203 1.09093 L
s
.118 0 .75 r
.94203 1.09093 m
.9453 1.07776 L
s
.114 0 .75 r
.9453 1.07776 m
.94837 1.06464 L
s
.111 0 .75 r
.94837 1.06464 m
.95125 1.05156 L
s
.107 0 .75 r
.95125 1.05156 m
.95395 1.03851 L
s
.103 0 .75 r
.95395 1.03851 m
.95647 1.02551 L
s
.1 0 .75 r
.95647 1.02551 m
.95882 1.01254 L
s
.096 0 .75 r
.95882 1.01254 m
.96101 .99962 L
s
.092 0 .75 r
.96101 .99962 m
.96303 .98673 L
s
.089 0 .75 r
.96303 .98673 m
.9649 .97387 L
s
.085 0 .75 r
.9649 .97387 m
.96661 .96105 L
s
.081 0 .75 r
.96661 .96105 m
.96818 .94826 L
s
.078 0 .75 r
.96818 .94826 m
.96959 .9355 L
s
.074 0 .75 r
.96959 .9355 m
.97086 .92277 L
s
.07 0 .75 r
.97086 .92277 m
.972 .91007 L
s
.067 0 .75 r
.972 .91007 m
.97299 .89738 L
s
.063 0 .75 r
.97299 .89738 m
.97384 .88472 L
s
.059 0 .75 r
.97384 .88472 m
.97456 .87208 L
s
.056 0 .75 r
.97456 .87208 m
.97515 .85945 L
s
.052 0 .75 r
.97515 .85945 m
.97561 .84683 L
s
.048 0 .75 r
.97561 .84683 m
.97593 .83422 L
s
.045 0 .75 r
.97593 .83422 m
.97613 .82162 L
s
.041 0 .75 r
.97613 .82162 m
.97619 .80902 L
s
.038 0 .75 r
.97619 .80902 m
.97613 .79642 L
s
.034 0 .75 r
.97613 .79642 m
.97593 .78381 L
s
.03 0 .75 r
.97593 .78381 m
.97561 .7712 L
s
.027 0 .75 r
.97561 .7712 m
.97515 .75859 L
s
.023 0 .75 r
.97515 .75859 m
.97456 .74596 L
s
.019 0 .75 r
.97456 .74596 m
.97384 .73331 L
s
.016 0 .75 r
.97384 .73331 m
.97299 .72065 L
s
.012 0 .75 r
.97299 .72065 m
.972 .70797 L
s
.008 0 .75 r
.972 .70797 m
.97086 .69526 L
s
.005 0 .75 r
.97086 .69526 m
.96959 .68253 L
s
.001 0 .75 r
.96959 .68253 m
.96818 .66977 L
s
0 .003 .75 r
.96818 .66977 m
.96661 .65698 L
s
0 .006 .75 r
.96661 .65698 m
.9649 .64416 L
s
0 .01 .75 r
.9649 .64416 m
.96303 .63131 L
s
0 .014 .75 r
.96303 .63131 m
.96101 .61842 L
s
0 .017 .75 r
.96101 .61842 m
.95882 .60549 L
s
0 .021 .75 r
.95882 .60549 m
.95647 .59253 L
s
0 .025 .75 r
.95647 .59253 m
.95395 .57952 L
s
0 .028 .75 r
.95395 .57952 m
.95125 .56648 L
s
0 .032 .75 r
.95125 .56648 m
.94837 .55339 L
s
0 .036 .75 r
.94837 .55339 m
.9453 .54027 L
s
0 .039 .75 r
.9453 .54027 m
.94203 .52711 L
s
0 .043 .75 r
.94203 .52711 m
.93857 .5139 L
s
0 .047 .75 r
.93857 .5139 m
.93491 .50066 L
s
0 .05 .75 r
.93491 .50066 m
.93103 .48739 L
s
0 .054 .75 r
.93103 .48739 m
.92693 .47408 L
s
0 .058 .75 r
.92693 .47408 m
.9226 .46074 L
s
0 .061 .75 r
.9226 .46074 m
.91804 .44737 L
s
0 .065 .75 r
.91804 .44737 m
.91323 .43397 L
s
0 .069 .75 r
.91323 .43397 m
.90818 .42056 L
s
0 .072 .75 r
.90818 .42056 m
.90286 .40713 L
s
0 .076 .75 r
.90286 .40713 m
.89728 .3937 L
s
0 .079 .75 r
.89728 .3937 m
.89143 .38026 L
s
0 .083 .75 r
.89143 .38026 m
.88529 .36683 L
s
0 .087 .75 r
.88529 .36683 m
.87885 .35341 L
s
0 .09 .75 r
.87885 .35341 m
.87211 .34002 L
s
0 .094 .75 r
.87211 .34002 m
.86507 .32666 L
s
0 .098 .75 r
.86507 .32666 m
.8577 .31335 L
s
0 .101 .75 r
.8577 .31335 m
.85 .30009 L
s
0 .105 .75 r
.85 .30009 m
.84196 .2869 L
s
0 .109 .75 r
.84196 .2869 m
.83358 .2738 L
s
0 .112 .75 r
.83358 .2738 m
.82484 .2608 L
s
0 .116 .75 r
.82484 .2608 m
.81574 .24792 L
s
0 .12 .75 r
.81574 .24792 m
.80626 .23517 L
s
0 .123 .75 r
.80626 .23517 m
.79641 .22257 L
s
0 .127 .75 r
.79641 .22257 m
.78617 .21016 L
s
0 .131 .75 r
.78617 .21016 m
.77553 .19794 L
s
0 .134 .75 r
.77553 .19794 m
.7645 .18594 L
s
0 .138 .75 r
.7645 .18594 m
.75306 .17419 L
s
0 .142 .75 r
.75306 .17419 m
.74122 .16271 L
s
0 .145 .75 r
.74122 .16271 m
.72897 .15153 L
s
0 .149 .75 r
.72897 .15153 m
.7163 .14067 L
s
0 .153 .75 r
.7163 .14067 m
.70322 .13018 L
s
0 .156 .75 r
.70322 .13018 m
.68972 .12007 L
s
0 .16 .75 r
.68972 .12007 m
.67582 .11039 L
s
0 .164 .75 r
.67582 .11039 m
.6615 .10116 L
s
0 .167 .75 r
.6615 .10116 m
.64679 .09242 L
s
0 .171 .75 r
.64679 .09242 m
.63168 .0842 L
s
0 .175 .75 r
.63168 .0842 m
.61619 .07654 L
s
0 .178 .75 r
.61619 .07654 m
.60032 .06947 L
s
0 .182 .75 r
.60032 .06947 m
.5841 .06304 L
s
0 .186 .75 r
.5841 .06304 m
.56753 .05728 L
s
0 .189 .75 r
.56753 .05728 m
.55064 .05221 L
s
0 .193 .75 r
.55064 .05221 m
.53344 .04789 L
s
0 .197 .75 r
.53344 .04789 m
.51597 .04434 L
s
0 .2 .75 r
.51597 .04434 m
.49825 .0416 L
s
0 .204 .75 r
.49825 .0416 m
.4803 .0397 L
s
0 .207 .75 r
.4803 .0397 m
.46216 .03866 L
s
0 .211 .75 r
.46216 .03866 m
.44386 .03852 L
s
0 .215 .75 r
.44386 .03852 m
.42544 .03931 L
s
0 .218 .75 r
.42544 .03931 m
.40695 .04104 L
s
0 .222 .75 r
.40695 .04104 m
.38841 .04374 L
s
0 .226 .75 r
.38841 .04374 m
.36987 .04742 L
s
0 .229 .75 r
.36987 .04742 m
.35139 .0521 L
s
0 .233 .75 r
.35139 .0521 m
.33299 .05777 L
s
0 .237 .75 r
.33299 .05777 m
.31475 .06445 L
s
0 .24 .75 r
.31475 .06445 m
.29669 .07214 L
s
0 .244 .75 r
.29669 .07214 m
.27888 .08082 L
s
0 .248 .75 r
.27888 .08082 m
.26135 .09049 L
s
0 .251 .75 r
.26135 .09049 m
.24417 .10113 L
s
0 .255 .75 r
.24417 .10113 m
.22738 .11272 L
s
0 .259 .75 r
.22738 .11272 m
.21102 .12523 L
s
0 .262 .75 r
.21102 .12523 m
.19515 .13864 L
s
0 .266 .75 r
.19515 .13864 m
.17981 .15289 L
s
0 .27 .75 r
.17981 .15289 m
.16504 .16797 L
s
0 .273 .75 r
.16504 .16797 m
.15088 .18381 L
s
0 .277 .75 r
.15088 .18381 m
.13736 .20037 L
s
0 .281 .75 r
.13736 .20037 m
.12453 .2176 L
s
0 .284 .75 r
.12453 .2176 m
.11241 .23543 L
s
0 .288 .75 r
.11241 .23543 m
.10102 .25382 L
s
0 .292 .75 r
.10102 .25382 m
.09039 .2727 L
s
0 .295 .75 r
.09039 .2727 m
.08054 .292 L
s
0 .299 .75 r
.08054 .292 m
.07148 .31166 L
s
0 .303 .75 r
.07148 .31166 m
.06322 .33163 L
s
0 .306 .75 r
.06322 .33163 m
.05577 .35182 L
s
0 .31 .75 r
.05577 .35182 m
.04912 .37219 L
s
0 .314 .75 r
.04912 .37219 m
.04327 .39265 L
s
0 .317 .75 r
.04327 .39265 m
.03822 .41317 L
s
0 .321 .75 r
.03822 .41317 m
.03395 .43366 L
s
0 .324 .75 r
.03395 .43366 m
.03046 .45408 L
s
0 .328 .75 r
.03046 .45408 m
.02772 .47437 L
s
0 .332 .75 r
.02772 .47437 m
.02571 .49447 L
s
0 .335 .75 r
.02571 .49447 m
.02442 .51434 L
s
0 .339 .75 r
.02442 .51434 m
.02381 .53393 L
s
0 .343 .75 r
.02381 .53393 m
.02386 .5532 L
s
0 .346 .75 r
.02386 .5532 m
.02454 .57211 L
s
0 .35 .75 r
.02454 .57211 m
.02582 .59062 L
s
0 .354 .75 r
.02582 .59062 m
.02767 .60871 L
s
0 .357 .75 r
.02767 .60871 m
.03006 .62634 L
s
0 .361 .75 r
.03006 .62634 m
.03295 .64349 L
s
0 .365 .75 r
.03295 .64349 m
.03631 .66014 L
s
0 .368 .75 r
.03631 .66014 m
.04011 .67626 L
s
0 .372 .75 r
.04011 .67626 m
.04432 .69186 L
s
0 .376 .75 r
.04432 .69186 m
.04889 .70691 L
s
0 .379 .75 r
.04889 .70691 m
.05381 .72142 L
s
0 .383 .75 r
.05381 .72142 m
.05904 .73536 L
s
0 .387 .75 r
.05904 .73536 m
.06455 .74874 L
s
0 .39 .75 r
.06455 .74874 m
.07031 .76156 L
s
0 .394 .75 r
.07031 .76156 m
.07629 .77383 L
s
0 .398 .75 r
.07629 .77383 m
.08247 .78554 L
s
0 .401 .75 r
.08247 .78554 m
.08882 .7967 L
s
0 .405 .75 r
.08882 .7967 m
.09531 .80731 L
s
0 .409 .75 r
.09531 .80731 m
.10192 .8174 L
s
0 .412 .75 r
.10192 .8174 m
.10863 .82696 L
s
0 .416 .75 r
.10863 .82696 m
.11542 .83601 L
s
0 .42 .75 r
.11542 .83601 m
.12226 .84455 L
s
0 .423 .75 r
.12226 .84455 m
.12915 .85262 L
s
0 .427 .75 r
.12915 .85262 m
.13606 .8602 L
s
0 .431 .75 r
.13606 .8602 m
.14298 .86733 L
s
0 .434 .75 r
.14298 .86733 m
.14989 .87401 L
s
0 .438 .75 r
.14989 .87401 m
.15677 .88026 L
s
0 .441 .75 r
.15677 .88026 m
.16363 .88609 L
s
0 .445 .75 r
.16363 .88609 m
.17044 .89153 L
s
0 .449 .75 r
.17044 .89153 m
.17719 .89658 L
s
0 .452 .75 r
.17719 .89658 m
.18388 .90126 L
s
0 .456 .75 r
.18388 .90126 m
.1905 .90558 L
s
0 .46 .75 r
.1905 .90558 m
.19703 .90956 L
s
0 .463 .75 r
.19703 .90956 m
.20348 .91322 L
s
0 .467 .75 r
.20348 .91322 m
.20983 .91657 L
s
0 .471 .75 r
.20983 .91657 m
.21609 .91962 L
s
0 .474 .75 r
.21609 .91962 m
.22224 .92238 L
s
0 .478 .75 r
.22224 .92238 m
.22828 .92488 L
s
0 .482 .75 r
.22828 .92488 m
.23422 .92712 L
s
0 .485 .75 r
.23422 .92712 m
.24004 .92912 L
s
0 .489 .75 r
.24004 .92912 m
.24574 .93089 L
s
0 .493 .75 r
.24574 .93089 m
.25133 .93244 L
s
0 .496 .75 r
.25133 .93244 m
.25679 .93378 L
s
0 .5 .75 r
.25679 .93378 m
.26214 .93493 L
s
0 .504 .75 r
.26214 .93493 m
.26737 .9359 L
s
0 .507 .75 r
.26737 .9359 m
.27247 .93669 L
s
0 .511 .75 r
.27247 .93669 m
.27745 .93731 L
s
0 .515 .75 r
.27745 .93731 m
.28231 .93778 L
s
0 .518 .75 r
.28231 .93778 m
.28706 .93811 L
s
0 .522 .75 r
.28706 .93811 m
.29168 .9383 L
s
0 .526 .75 r
.29168 .9383 m
.29618 .93836 L
s
0 .529 .75 r
.29618 .93836 m
.30057 .93831 L
s
0 .533 .75 r
.30057 .93831 m
.30484 .93814 L
s
0 .537 .75 r
.30484 .93814 m
.30899 .93786 L
s
0 .54 .75 r
.30899 .93786 m
.31303 .9375 L
s
0 .544 .75 r
.31303 .9375 m
.31696 .93704 L
s
0 .548 .75 r
.31696 .93704 m
.32079 .93649 L
s
0 .551 .75 r
.32079 .93649 m
.3245 .93587 L
s
0 .555 .75 r
.3245 .93587 m
.3281 .93518 L
s
0 .558 .75 r
.3281 .93518 m
.33161 .93442 L
s
0 .562 .75 r
.33161 .93442 m
.33501 .93359 L
s
0 .566 .75 r
.33501 .93359 m
.33831 .93271 L
s
0 .569 .75 r
.33831 .93271 m
.34151 .93178 L
s
0 .573 .75 r
.34151 .93178 m
.34462 .93081 L
s
0 .577 .75 r
.34462 .93081 m
.34764 .92979 L
s
0 .58 .75 r
.34764 .92979 m
.35056 .92873 L
s
0 .584 .75 r
.35056 .92873 m
.3534 .92763 L
s
0 .588 .75 r
.3534 .92763 m
.35615 .9265 L
s
0 .591 .75 r
.35615 .9265 m
.35881 .92535 L
s
0 .595 .75 r
.35881 .92535 m
.36139 .92416 L
s
0 .599 .75 r
.36139 .92416 m
.36389 .92296 L
s
0 .602 .75 r
.36389 .92296 m
.36632 .92174 L
s
0 .606 .75 r
.36632 .92174 m
.36866 .92049 L
s
0 .61 .75 r
.36866 .92049 m
.37093 .91924 L
s
0 .613 .75 r
.37093 .91924 m
.37314 .91797 L
s
0 .617 .75 r
.37314 .91797 m
.37527 .91669 L
s
0 .621 .75 r
.37527 .91669 m
.37733 .9154 L
s
0 .624 .75 r
.37733 .9154 m
.37933 .91411 L
s
0 .628 .75 r
.37933 .91411 m
.38126 .91281 L
s
0 .632 .75 r
.38126 .91281 m
.38313 .91151 L
s
0 .635 .75 r
.38313 .91151 m
.38494 .9102 L
s
0 .639 .75 r
.38494 .9102 m
.38669 .9089 L
s
0 .643 .75 r
.38669 .9089 m
.38838 .9076 L
s
0 .646 .75 r
.38838 .9076 m
.39002 .90629 L
s
0 .65 .75 r
.39002 .90629 m
.39161 .905 L
s
0 .654 .75 r
.39161 .905 m
.39314 .90371 L
s
0 .657 .75 r
.39314 .90371 m
.39462 .90242 L
s
0 .661 .75 r
.39462 .90242 m
.39605 .90114 L
s
0 .665 .75 r
.39605 .90114 m
.39744 .89987 L
s
0 .668 .75 r
.39744 .89987 m
.39878 .8986 L
s
0 .672 .75 r
.39878 .8986 m
.40008 .89734 L
s
0 .675 .75 r
.40008 .89734 m
.40133 .8961 L
s
0 .679 .75 r
.40133 .8961 m
.40254 .89486 L
s
0 .683 .75 r
.40254 .89486 m
.40371 .89363 L
s
0 .686 .75 r
.40371 .89363 m
.40484 .89242 L
s
0 .69 .75 r
.40484 .89242 m
.40594 .89121 L
s
0 .694 .75 r
.40594 .89121 m
.407 .89002 L
s
0 .697 .75 r
.407 .89002 m
.40802 .88884 L
s
0 .701 .75 r
.40802 .88884 m
.40901 .88767 L
s
0 .705 .75 r
.40901 .88767 m
.40996 .88652 L
s
0 .708 .75 r
.40996 .88652 m
.41088 .88538 L
s
0 .712 .75 r
.41088 .88538 m
.41178 .88425 L
s
0 .716 .75 r
.41178 .88425 m
.41264 .88313 L
s
0 .719 .75 r
.41264 .88313 m
.41347 .88203 L
s
0 .723 .75 r
.41347 .88203 m
.41427 .88094 L
s
0 .727 .75 r
.41427 .88094 m
.41505 .87987 L
s
0 .73 .75 r
.41505 .87987 m
.4158 .87881 L
s
0 .734 .75 r
.4158 .87881 m
.41653 .87776 L
s
0 .738 .75 r
.41653 .87776 m
.41723 .87673 L
s
0 .741 .75 r
.41723 .87673 m
.4179 .87571 L
s
0 .745 .75 r
.4179 .87571 m
.41856 .87471 L
s
0 .749 .75 r
.41856 .87471 m
.41919 .87372 L
s
0 .75 .748 r
.41919 .87372 m
.4198 .87274 L
s
0 .75 .744 r
.4198 .87274 m
.42039 .87178 L
s
0 .75 .74 r
.42039 .87178 m
.42096 .87083 L
s
0 .75 .737 r
.42096 .87083 m
.42151 .86989 L
s
0 .75 .733 r
.42151 .86989 m
.42204 .86897 L
s
0 .75 .729 r
.42204 .86897 m
.42255 .86807 L
s
0 .75 .726 r
.42255 .86807 m
.42305 .86717 L
s
0 .75 .722 r
.42305 .86717 m
.42352 .86629 L
s
0 .75 .719 r
.42352 .86629 m
.42399 .86542 L
s
0 .75 .715 r
.42399 .86542 m
.42443 .86457 L
s
0 .75 .711 r
.42443 .86457 m
.42486 .86373 L
s
0 .75 .708 r
.42486 .86373 m
.42528 .8629 L
s
0 .75 .704 r
.42528 .8629 m
.42568 .86209 L
s
0 .75 .7 r
.42568 .86209 m
.42607 .86129 L
s
0 .75 .697 r
.42607 .86129 m
.42644 .8605 L
s
0 .75 .693 r
.42644 .8605 m
.4268 .85972 L
s
0 .75 .689 r
.4268 .85972 m
.42715 .85896 L
s
0 .75 .686 r
.42715 .85896 m
.42749 .8582 L
s
0 .75 .682 r
.42749 .8582 m
.42781 .85746 L
s
0 .75 .678 r
.42781 .85746 m
.42813 .85674 L
s
0 .75 .675 r
.42813 .85674 m
.42843 .85602 L
s
0 .75 .671 r
.42843 .85602 m
.42872 .85531 L
s
0 .75 .667 r
.42872 .85531 m
.429 .85462 L
s
0 .75 .664 r
.429 .85462 m
.42927 .85394 L
s
0 .75 .66 r
.42927 .85394 m
.42954 .85327 L
s
0 .75 .656 r
.42954 .85327 m
.42979 .85261 L
s
0 .75 .653 r
.42979 .85261 m
.43003 .85196 L
s
0 .75 .649 r
.43003 .85196 m
.43027 .85132 L
s
0 .75 .645 r
.43027 .85132 m
.4305 .85069 L
s
0 .75 .642 r
.4305 .85069 m
.43072 .85007 L
s
0 .75 .638 r
.43072 .85007 m
.43093 .84947 L
s
0 .75 .634 r
.43093 .84947 m
.43113 .84887 L
s
0 .75 .631 r
.43113 .84887 m
.43133 .84828 L
s
0 .75 .627 r
.43133 .84828 m
.43152 .8477 L
s
0 .75 .623 r
.43152 .8477 m
.4317 .84714 L
s
0 .75 .62 r
.4317 .84714 m
.43188 .84658 L
s
0 .75 .616 r
.43188 .84658 m
.43205 .84603 L
s
0 .75 .612 r
.43205 .84603 m
.43221 .84549 L
s
0 .75 .609 r
.43221 .84549 m
.43237 .84495 L
s
0 .75 .605 r
.43237 .84495 m
.43252 .84443 L
s
0 .75 .601 r
.43252 .84443 m
.43267 .84392 L
s
0 .75 .598 r
.43267 .84392 m
.43281 .84341 L
s
0 .75 .594 r
.43281 .84341 m
.43295 .84292 L
s
0 .75 .591 r
.43295 .84292 m
.43308 .84243 L
s
0 .75 .587 r
.43308 .84243 m
.43321 .84195 L
s
0 .75 .583 r
.43321 .84195 m
.43333 .84147 L
s
0 .75 .58 r
.43333 .84147 m
.43345 .84101 L
s
0 .75 .576 r
.43345 .84101 m
.43356 .84055 L
s
0 .75 .572 r
.43356 .84055 m
.43367 .8401 L
s
0 .75 .569 r
.43367 .8401 m
.43377 .83966 L
s
0 .75 .565 r
.43377 .83966 m
.43387 .83922 L
s
0 .75 .561 r
.43387 .83922 m
.43397 .8388 L
s
0 .75 .558 r
.43397 .8388 m
.43406 .83838 L
s
0 .75 .554 r
.43406 .83838 m
.43415 .83796 L
s
0 .75 .55 r
.43415 .83796 m
.43424 .83756 L
s
0 .75 .547 r
.43424 .83756 m
.43432 .83716 L
s
0 .75 .543 r
.43432 .83716 m
.4344 .83676 L
s
0 .75 .539 r
.4344 .83676 m
.43448 .83638 L
s
0 .75 .536 r
.43448 .83638 m
.43455 .836 L
s
0 .75 .532 r
.43455 .836 m
.43462 .83562 L
s
0 .75 .528 r
.43462 .83562 m
.43469 .83525 L
s
0 .75 .525 r
.43469 .83525 m
.43476 .83489 L
s
0 .75 .521 r
.43476 .83489 m
.43482 .83453 L
s
0 .75 .517 r
.43482 .83453 m
.43488 .83418 L
s
0 .75 .514 r
.43488 .83418 m
.43494 .83384 L
s
0 .75 .51 r
.43494 .83384 m
.43499 .8335 L
s
0 .75 .506 r
.43499 .8335 m
.43504 .83317 L
s
0 .75 .503 r
.43504 .83317 m
.43509 .83284 L
s
0 .75 .499 r
.43509 .83284 m
.43514 .83252 L
s
0 .75 .495 r
.43514 .83252 m
.43519 .8322 L
s
0 .75 .492 r
.43519 .8322 m
.43523 .83189 L
s
0 .75 .488 r
.43523 .83189 m
.43528 .83158 L
s
0 .75 .484 r
.43528 .83158 m
.43532 .83128 L
s
0 .75 .481 r
.43532 .83128 m
.43536 .83098 L
s
0 .75 .477 r
.43536 .83098 m
.43539 .83069 L
s
0 .75 .474 r
.43539 .83069 m
.43543 .8304 L
s
0 .75 .47 r
.43543 .8304 m
.43546 .83011 L
s
0 .75 .466 r
.43546 .83011 m
.43549 .82984 L
s
0 .75 .463 r
.43549 .82984 m
.43553 .82956 L
s
0 .75 .459 r
.43553 .82956 m
.43555 .82929 L
s
0 .75 .455 r
.43555 .82929 m
.43558 .82903 L
s
0 .75 .452 r
.43558 .82903 m
.43561 .82876 L
s
0 .75 .448 r
.43561 .82876 m
.43563 .82851 L
s
0 .75 .444 r
.43563 .82851 m
.43566 .82825 L
s
0 .75 .441 r
.43566 .82825 m
.43568 .828 L
s
0 .75 .437 r
.43568 .828 m
.4357 .82776 L
s
0 .75 .433 r
.4357 .82776 m
.43572 .82752 L
s
0 .75 .43 r
.43572 .82752 m
.43574 .82728 L
s
0 .75 .426 r
.43574 .82728 m
.43576 .82705 L
s
0 .75 .422 r
.43576 .82705 m
.43578 .82681 L
s
0 .75 .419 r
.43578 .82681 m
.43579 .82659 L
s
0 .75 .415 r
.43579 .82659 m
.43581 .82636 L
s
0 .75 .411 r
.43581 .82636 m
.43582 .82615 L
s
0 .75 .408 r
.43582 .82615 m
.43584 .82593 L
s
0 .75 .404 r
.43584 .82593 m
.43585 .82572 L
s
0 .75 .4 r
.43585 .82572 m
.43586 .82551 L
s
0 .75 .397 r
.43586 .82551 m
.43587 .8253 L
s
0 .75 .393 r
.43587 .8253 m
.43588 .8251 L
s
0 .75 .389 r
.43588 .8251 m
.43589 .8249 L
s
0 .75 .386 r
.43589 .8249 m
.4359 .8247 L
s
0 .75 .382 r
.4359 .8247 m
.43591 .8245 L
s
0 .75 .378 r
.43591 .8245 m
.43591 .82431 L
s
0 .75 .375 r
.43591 .82431 m
.43592 .82413 L
s
0 .75 .371 r
.43592 .82413 m
.43592 .82394 L
s
0 .75 .367 r
.43592 .82394 m
.43593 .82376 L
s
0 .75 .364 r
.43593 .82376 m
.43593 .82358 L
s
0 .75 .36 r
.43593 .82358 m
.43594 .8234 L
s
0 .75 .357 r
.43594 .8234 m
.43594 .82323 L
s
0 .75 .353 r
.43594 .82323 m
.43594 .82305 L
s
0 .75 .349 r
.43594 .82305 m
.43595 .82288 L
s
0 .75 .346 r
.43595 .82288 m
.43595 .82272 L
s
0 .75 .342 r
.43595 .82272 m
.43595 .82255 L
s
0 .75 .338 r
.43595 .82255 m
.43595 .82239 L
s
0 .75 .335 r
.43595 .82239 m
.43595 .82223 L
s
0 .75 .331 r
.43595 .82223 m
.43595 .82207 L
s
0 .75 .327 r
.43595 .82207 m
.43595 .82192 L
s
0 .75 .324 r
.43595 .82192 m
.43595 .82177 L
s
0 .75 .32 r
.43595 .82177 m
.43595 .82162 L
s
0 .75 .316 r
.43595 .82162 m
.43595 .82147 L
s
0 .75 .313 r
.43595 .82147 m
.43595 .82132 L
s
0 .75 .309 r
.43595 .82132 m
.43595 .82118 L
s
0 .75 .305 r
.43595 .82118 m
.43594 .82104 L
s
0 .75 .302 r
.43594 .82104 m
.43594 .8209 L
s
0 .75 .298 r
.43594 .8209 m
.43594 .82076 L
s
0 .75 .294 r
.43594 .82076 m
.43593 .82062 L
s
0 .75 .291 r
.43593 .82062 m
.43593 .82049 L
s
0 .75 .287 r
.43593 .82049 m
.43593 .82036 L
s
0 .75 .283 r
.43593 .82036 m
.43592 .82023 L
s
0 .75 .28 r
.43592 .82023 m
.43592 .8201 L
s
0 .75 .276 r
.43592 .8201 m
.43591 .81998 L
s
0 .75 .272 r
.43591 .81998 m
.43591 .81985 L
s
0 .75 .269 r
.43591 .81985 m
.4359 .81973 L
s
0 .75 .265 r
.4359 .81973 m
.4359 .81961 L
s
0 .75 .261 r
.4359 .81961 m
.43589 .81949 L
s
0 .75 .258 r
.43589 .81949 m
.43589 .81937 L
s
0 .75 .254 r
.43589 .81937 m
.43588 .81925 L
s
0 .75 .25 r
.43588 .81925 m
.43588 .81914 L
s
0 .75 .247 r
.43588 .81914 m
.43587 .81903 L
s
0 .75 .243 r
.43587 .81903 m
.43586 .81892 L
s
0 .75 .24 r
.43586 .81892 m
.43586 .81881 L
s
0 .75 .236 r
.43586 .81881 m
.43585 .8187 L
s
0 .75 .232 r
.43585 .8187 m
.43585 .81859 L
s
0 .75 .229 r
.43585 .81859 m
.43584 .81849 L
s
0 .75 .225 r
.43584 .81849 m
.43583 .81838 L
s
0 .75 .221 r
.43583 .81838 m
.43582 .81828 L
s
0 .75 .218 r
.43582 .81828 m
.43582 .81818 L
s
0 .75 .214 r
.43582 .81818 m
.43581 .81808 L
s
0 .75 .21 r
.43581 .81808 m
.4358 .81798 L
s
0 .75 .207 r
.4358 .81798 m
.4358 .81789 L
s
0 .75 .203 r
.4358 .81789 m
.43579 .81779 L
s
0 .75 .199 r
.43579 .81779 m
.43578 .8177 L
s
0 .75 .196 r
.43578 .8177 m
.43577 .81761 L
s
0 .75 .192 r
.43577 .81761 m
.43577 .81751 L
s
0 .75 .188 r
.43577 .81751 m
.43576 .81742 L
s
0 .75 .185 r
.43576 .81742 m
.43575 .81733 L
s
0 .75 .181 r
.43575 .81733 m
.43574 .81725 L
s
0 .75 .177 r
.43574 .81725 m
.43573 .81716 L
s
0 .75 .174 r
.43573 .81716 m
.43573 .81707 L
s
0 .75 .17 r
.43573 .81707 m
.43572 .81699 L
s
0 .75 .166 r
.43572 .81699 m
.43571 .81691 L
s
0 .75 .163 r
.43571 .81691 m
.4357 .81682 L
s
0 .75 .159 r
.4357 .81682 m
.43569 .81674 L
s
0 .75 .155 r
.43569 .81674 m
.43568 .81666 L
s
0 .75 .152 r
.43568 .81666 m
.43568 .81658 L
s
0 .75 .148 r
.43568 .81658 m
.43567 .81651 L
s
0 .75 .144 r
.43567 .81651 m
.43566 .81643 L
s
0 .75 .141 r
.43566 .81643 m
.43565 .81635 L
s
0 .75 .137 r
.43565 .81635 m
.43564 .81628 L
s
0 .75 .133 r
.43564 .81628 m
.43563 .8162 L
s
0 .75 .13 r
.43563 .8162 m
.43563 .81613 L
s
0 .75 .126 r
.43563 .81613 m
.43562 .81606 L
s
0 .75 .123 r
.43562 .81606 m
.43561 .81599 L
s
0 .75 .119 r
.43561 .81599 m
.4356 .81592 L
s
0 .75 .115 r
.4356 .81592 m
.43559 .81585 L
s
0 .75 .112 r
.43559 .81585 m
.43558 .81578 L
s
0 .75 .108 r
.43558 .81578 m
.43557 .81571 L
s
0 .75 .104 r
.43557 .81571 m
.43557 .81564 L
s
0 .75 .101 r
.43557 .81564 m
.43556 .81558 L
s
0 .75 .097 r
.43556 .81558 m
.43555 .81551 L
s
0 .75 .093 r
.43555 .81551 m
.43554 .81545 L
s
0 .75 .09 r
.43554 .81545 m
.43553 .81539 L
s
0 .75 .086 r
.43553 .81539 m
.43552 .81532 L
s
0 .75 .082 r
.43552 .81532 m
.43551 .81526 L
s
0 .75 .079 r
.43551 .81526 m
.43551 .8152 L
s
0 1 0 r
.001 w
.29843 .80902 m
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
Mistroke
.29843 .80902 L
Mfstroke
1 0 0 r
.0005 w
.29843 .80902 m
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
.29843 .80902 L
Mistroke
.29843 .80902 L
Mfstroke
0 0 1 r
.004 w
.43398 .80902 m
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
.43398 .80902 L
Mistroke
.43398 .80902 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.909028 0.369391 0.97619 0.705202 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.000312461 0.00624922 [
[ 0 0 0 0 ]
[ 1 5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 5 L
0 5 L
closepath
clip
newpath
.75 0 0 r
.02381 .00031 m
.02381 .00656 L
.5 .00656 L
.5 .00031 L
F
0 g
gsave
.52381 .00344 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(4.) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
.75 0 .004 r
.02381 .00656 m
.02381 .01281 L
.5 .01281 L
.5 .00656 L
F
.75 0 .007 r
.02381 .01281 m
.02381 .01906 L
.5 .01906 L
.5 .01281 L
F
.75 0 .011 r
.02381 .01906 m
.02381 .02531 L
.5 .02531 L
.5 .01906 L
F
.75 0 .015 r
.02381 .02531 m
.02381 .03156 L
.5 .03156 L
.5 .02531 L
F
.75 0 .018 r
.02381 .03156 m
.02381 .03781 L
.5 .03781 L
.5 .03156 L
F
.75 0 .022 r
.02381 .03781 m
.02381 .04406 L
.5 .04406 L
.5 .03781 L
F
.75 0 .026 r
.02381 .04406 m
.02381 .05031 L
.5 .05031 L
.5 .04406 L
F
.75 0 .029 r
.02381 .05031 m
.02381 .05656 L
.5 .05656 L
.5 .05031 L
F
.75 0 .033 r
.02381 .05656 m
.02381 .0628 L
.5 .0628 L
.5 .05656 L
F
.75 0 .037 r
.02381 .0628 m
.02381 .06905 L
.5 .06905 L
.5 .0628 L
F
.75 0 .04 r
.02381 .06905 m
.02381 .0753 L
.5 .0753 L
.5 .06905 L
F
.75 0 .044 r
.02381 .0753 m
.02381 .08155 L
.5 .08155 L
.5 .0753 L
F
.75 0 .048 r
.02381 .08155 m
.02381 .0878 L
.5 .0878 L
.5 .08155 L
F
.75 0 .051 r
.02381 .0878 m
.02381 .09405 L
.5 .09405 L
.5 .0878 L
F
.75 0 .055 r
.02381 .09405 m
.02381 .1003 L
.5 .1003 L
.5 .09405 L
F
.75 0 .059 r
.02381 .1003 m
.02381 .10655 L
.5 .10655 L
.5 .1003 L
F
.75 0 .062 r
.02381 .10655 m
.02381 .1128 L
.5 .1128 L
.5 .10655 L
F
.75 0 .066 r
.02381 .1128 m
.02381 .11905 L
.5 .11905 L
.5 .1128 L
F
.75 0 .07 r
.02381 .11905 m
.02381 .1253 L
.5 .1253 L
.5 .11905 L
F
.75 0 .073 r
.02381 .1253 m
.02381 .13155 L
.5 .13155 L
.5 .1253 L
F
.75 0 .077 r
.02381 .13155 m
.02381 .1378 L
.5 .1378 L
.5 .13155 L
F
.75 0 .081 r
.02381 .1378 m
.02381 .14404 L
.5 .14404 L
.5 .1378 L
F
.75 0 .084 r
.02381 .14404 m
.02381 .15029 L
.5 .15029 L
.5 .14404 L
F
.75 0 .088 r
.02381 .15029 m
.02381 .15654 L
.5 .15654 L
.5 .15029 L
F
.75 0 .092 r
.02381 .15654 m
.02381 .16279 L
.5 .16279 L
.5 .15654 L
F
.75 0 .095 r
.02381 .16279 m
.02381 .16904 L
.5 .16904 L
.5 .16279 L
F
.75 0 .099 r
.02381 .16904 m
.02381 .17529 L
.5 .17529 L
.5 .16904 L
F
.75 0 .103 r
.02381 .17529 m
.02381 .18154 L
.5 .18154 L
.5 .17529 L
F
.75 0 .106 r
.02381 .18154 m
.02381 .18779 L
.5 .18779 L
.5 .18154 L
F
.75 0 .11 r
.02381 .18779 m
.02381 .19404 L
.5 .19404 L
.5 .18779 L
F
.75 0 .113 r
.02381 .19404 m
.02381 .20029 L
.5 .20029 L
.5 .19404 L
F
.75 0 .117 r
.02381 .20029 m
.02381 .20654 L
.5 .20654 L
.5 .20029 L
F
.75 0 .121 r
.02381 .20654 m
.02381 .21279 L
.5 .21279 L
.5 .20654 L
F
.75 0 .124 r
.02381 .21279 m
.02381 .21904 L
.5 .21904 L
.5 .21279 L
F
.75 0 .128 r
.02381 .21904 m
.02381 .22528 L
.5 .22528 L
.5 .21904 L
F
.75 0 .132 r
.02381 .22528 m
.02381 .23153 L
.5 .23153 L
.5 .22528 L
F
.75 0 .135 r
.02381 .23153 m
.02381 .23778 L
.5 .23778 L
.5 .23153 L
F
.75 0 .139 r
.02381 .23778 m
.02381 .24403 L
.5 .24403 L
.5 .23778 L
F
.75 0 .143 r
.02381 .24403 m
.02381 .25028 L
.5 .25028 L
.5 .24403 L
F
.75 0 .146 r
.02381 .25028 m
.02381 .25653 L
.5 .25653 L
.5 .25028 L
F
.75 0 .15 r
.02381 .25653 m
.02381 .26278 L
.5 .26278 L
.5 .25653 L
F
.75 0 .154 r
.02381 .26278 m
.02381 .26903 L
.5 .26903 L
.5 .26278 L
F
.75 0 .157 r
.02381 .26903 m
.02381 .27528 L
.5 .27528 L
.5 .26903 L
F
.75 0 .161 r
.02381 .27528 m
.02381 .28153 L
.5 .28153 L
.5 .27528 L
F
.75 0 .165 r
.02381 .28153 m
.02381 .28778 L
.5 .28778 L
.5 .28153 L
F
.75 0 .168 r
.02381 .28778 m
.02381 .29403 L
.5 .29403 L
.5 .28778 L
F
.75 0 .172 r
.02381 .29403 m
.02381 .30027 L
.5 .30027 L
.5 .29403 L
F
.75 0 .176 r
.02381 .30027 m
.02381 .30652 L
.5 .30652 L
.5 .30027 L
F
.75 0 .179 r
.02381 .30652 m
.02381 .31277 L
.5 .31277 L
.5 .30652 L
F
.75 0 .183 r
.02381 .31277 m
.02381 .31902 L
.5 .31902 L
.5 .31277 L
F
.75 0 .187 r
.02381 .31902 m
.02381 .32527 L
.5 .32527 L
.5 .31902 L
F
.75 0 .19 r
.02381 .32527 m
.02381 .33152 L
.5 .33152 L
.5 .32527 L
F
.75 0 .194 r
.02381 .33152 m
.02381 .33777 L
.5 .33777 L
.5 .33152 L
F
.75 0 .198 r
.02381 .33777 m
.02381 .34402 L
.5 .34402 L
.5 .33777 L
F
.75 0 .201 r
.02381 .34402 m
.02381 .35027 L
.5 .35027 L
.5 .34402 L
F
.75 0 .205 r
.02381 .35027 m
.02381 .35652 L
.5 .35652 L
.5 .35027 L
F
.75 0 .209 r
.02381 .35652 m
.02381 .36277 L
.5 .36277 L
.5 .35652 L
F
.75 0 .212 r
.02381 .36277 m
.02381 .36902 L
.5 .36902 L
.5 .36277 L
F
.75 0 .216 r
.02381 .36902 m
.02381 .37527 L
.5 .37527 L
.5 .36902 L
F
.75 0 .22 r
.02381 .37527 m
.02381 .38151 L
.5 .38151 L
.5 .37527 L
F
.75 0 .223 r
.02381 .38151 m
.02381 .38776 L
.5 .38776 L
.5 .38151 L
F
.75 0 .227 r
.02381 .38776 m
.02381 .39401 L
.5 .39401 L
.5 .38776 L
F
.75 0 .231 r
.02381 .39401 m
.02381 .40026 L
.5 .40026 L
.5 .39401 L
F
.75 0 .234 r
.02381 .40026 m
.02381 .40651 L
.5 .40651 L
.5 .40026 L
F
.75 0 .238 r
.02381 .40651 m
.02381 .41276 L
.5 .41276 L
.5 .40651 L
F
.75 0 .242 r
.02381 .41276 m
.02381 .41901 L
.5 .41901 L
.5 .41276 L
F
.75 0 .245 r
.02381 .41901 m
.02381 .42526 L
.5 .42526 L
.5 .41901 L
F
.75 0 .249 r
.02381 .42526 m
.02381 .43151 L
.5 .43151 L
.5 .42526 L
F
.75 0 .253 r
.02381 .43151 m
.02381 .43776 L
.5 .43776 L
.5 .43151 L
F
.75 0 .256 r
.02381 .43776 m
.02381 .44401 L
.5 .44401 L
.5 .43776 L
F
.75 0 .26 r
.02381 .44401 m
.02381 .45026 L
.5 .45026 L
.5 .44401 L
F
.75 0 .264 r
.02381 .45026 m
.02381 .45651 L
.5 .45651 L
.5 .45026 L
F
.75 0 .267 r
.02381 .45651 m
.02381 .46275 L
.5 .46275 L
.5 .45651 L
F
.75 0 .271 r
.02381 .46275 m
.02381 .469 L
.5 .469 L
.5 .46275 L
F
.75 0 .275 r
.02381 .469 m
.02381 .47525 L
.5 .47525 L
.5 .469 L
F
.75 0 .278 r
.02381 .47525 m
.02381 .4815 L
.5 .4815 L
.5 .47525 L
F
.75 0 .282 r
.02381 .4815 m
.02381 .48775 L
.5 .48775 L
.5 .4815 L
F
.75 0 .286 r
.02381 .48775 m
.02381 .494 L
.5 .494 L
.5 .48775 L
F
.75 0 .289 r
.02381 .494 m
.02381 .50025 L
.5 .50025 L
.5 .494 L
F
.75 0 .293 r
.02381 .50025 m
.02381 .5065 L
.5 .5065 L
.5 .50025 L
F
.75 0 .297 r
.02381 .5065 m
.02381 .51275 L
.5 .51275 L
.5 .5065 L
F
.75 0 .3 r
.02381 .51275 m
.02381 .519 L
.5 .519 L
.5 .51275 L
F
.75 0 .304 r
.02381 .519 m
.02381 .52525 L
.5 .52525 L
.5 .519 L
F
.75 0 .308 r
.02381 .52525 m
.02381 .5315 L
.5 .5315 L
.5 .52525 L
F
.75 0 .311 r
.02381 .5315 m
.02381 .53775 L
.5 .53775 L
.5 .5315 L
F
.75 0 .315 r
.02381 .53775 m
.02381 .54399 L
.5 .54399 L
.5 .53775 L
F
.75 0 .318 r
.02381 .54399 m
.02381 .55024 L
.5 .55024 L
.5 .54399 L
F
.75 0 .322 r
.02381 .55024 m
.02381 .55649 L
.5 .55649 L
.5 .55024 L
F
.75 0 .326 r
.02381 .55649 m
.02381 .56274 L
.5 .56274 L
.5 .55649 L
F
.75 0 .329 r
.02381 .56274 m
.02381 .56899 L
.5 .56899 L
.5 .56274 L
F
.75 0 .333 r
.02381 .56899 m
.02381 .57524 L
.5 .57524 L
.5 .56899 L
F
.75 0 .337 r
.02381 .57524 m
.02381 .58149 L
.5 .58149 L
.5 .57524 L
F
.75 0 .34 r
.02381 .58149 m
.02381 .58774 L
.5 .58774 L
.5 .58149 L
F
.75 0 .344 r
.02381 .58774 m
.02381 .59399 L
.5 .59399 L
.5 .58774 L
F
.75 0 .348 r
.02381 .59399 m
.02381 .60024 L
.5 .60024 L
.5 .59399 L
F
.75 0 .351 r
.02381 .60024 m
.02381 .60649 L
.5 .60649 L
.5 .60024 L
F
.75 0 .355 r
.02381 .60649 m
.02381 .61274 L
.5 .61274 L
.5 .60649 L
F
.75 0 .359 r
.02381 .61274 m
.02381 .61899 L
.5 .61899 L
.5 .61274 L
F
.75 0 .362 r
.02381 .61899 m
.02381 .62523 L
.5 .62523 L
.5 .61899 L
F
.75 0 .366 r
.02381 .62523 m
.02381 .63148 L
.5 .63148 L
.5 .62523 L
F
.75 0 .37 r
.02381 .63148 m
.02381 .63773 L
.5 .63773 L
.5 .63148 L
F
.75 0 .373 r
.02381 .63773 m
.02381 .64398 L
.5 .64398 L
.5 .63773 L
F
.75 0 .377 r
.02381 .64398 m
.02381 .65023 L
.5 .65023 L
.5 .64398 L
F
.75 0 .381 r
.02381 .65023 m
.02381 .65648 L
.5 .65648 L
.5 .65023 L
F
.75 0 .384 r
.02381 .65648 m
.02381 .66273 L
.5 .66273 L
.5 .65648 L
F
.75 0 .388 r
.02381 .66273 m
.02381 .66898 L
.5 .66898 L
.5 .66273 L
F
.75 0 .392 r
.02381 .66898 m
.02381 .67523 L
.5 .67523 L
.5 .66898 L
F
.75 0 .395 r
.02381 .67523 m
.02381 .68148 L
.5 .68148 L
.5 .67523 L
F
.75 0 .399 r
.02381 .68148 m
.02381 .68773 L
.5 .68773 L
.5 .68148 L
F
.75 0 .403 r
.02381 .68773 m
.02381 .69398 L
.5 .69398 L
.5 .68773 L
F
.75 0 .406 r
.02381 .69398 m
.02381 .70022 L
.5 .70022 L
.5 .69398 L
F
.75 0 .41 r
.02381 .70022 m
.02381 .70647 L
.5 .70647 L
.5 .70022 L
F
.75 0 .414 r
.02381 .70647 m
.02381 .71272 L
.5 .71272 L
.5 .70647 L
F
.75 0 .417 r
.02381 .71272 m
.02381 .71897 L
.5 .71897 L
.5 .71272 L
F
.75 0 .421 r
.02381 .71897 m
.02381 .72522 L
.5 .72522 L
.5 .71897 L
F
.75 0 .425 r
.02381 .72522 m
.02381 .73147 L
.5 .73147 L
.5 .72522 L
F
.75 0 .428 r
.02381 .73147 m
.02381 .73772 L
.5 .73772 L
.5 .73147 L
F
.75 0 .432 r
.02381 .73772 m
.02381 .74397 L
.5 .74397 L
.5 .73772 L
F
.75 0 .436 r
.02381 .74397 m
.02381 .75022 L
.5 .75022 L
.5 .74397 L
F
.75 0 .439 r
.02381 .75022 m
.02381 .75647 L
.5 .75647 L
.5 .75022 L
F
.75 0 .443 r
.02381 .75647 m
.02381 .76272 L
.5 .76272 L
.5 .75647 L
F
.75 0 .447 r
.02381 .76272 m
.02381 .76897 L
.5 .76897 L
.5 .76272 L
F
.75 0 .45 r
.02381 .76897 m
.02381 .77522 L
.5 .77522 L
.5 .76897 L
F
.75 0 .454 r
.02381 .77522 m
.02381 .78146 L
.5 .78146 L
.5 .77522 L
F
.75 0 .458 r
.02381 .78146 m
.02381 .78771 L
.5 .78771 L
.5 .78146 L
F
.75 0 .461 r
.02381 .78771 m
.02381 .79396 L
.5 .79396 L
.5 .78771 L
F
.75 0 .465 r
.02381 .79396 m
.02381 .80021 L
.5 .80021 L
.5 .79396 L
F
.75 0 .469 r
.02381 .80021 m
.02381 .80646 L
.5 .80646 L
.5 .80021 L
F
.75 0 .472 r
.02381 .80646 m
.02381 .81271 L
.5 .81271 L
.5 .80646 L
F
.75 0 .476 r
.02381 .81271 m
.02381 .81896 L
.5 .81896 L
.5 .81271 L
F
.75 0 .48 r
.02381 .81896 m
.02381 .82521 L
.5 .82521 L
.5 .81896 L
F
.75 0 .483 r
.02381 .82521 m
.02381 .83146 L
.5 .83146 L
.5 .82521 L
F
.75 0 .487 r
.02381 .83146 m
.02381 .83771 L
.5 .83771 L
.5 .83146 L
F
.75 0 .491 r
.02381 .83771 m
.02381 .84396 L
.5 .84396 L
.5 .83771 L
F
.75 0 .494 r
.02381 .84396 m
.02381 .85021 L
.5 .85021 L
.5 .84396 L
F
.75 0 .498 r
.02381 .85021 m
.02381 .85646 L
.5 .85646 L
.5 .85021 L
F
.75 0 .502 r
.02381 .85646 m
.02381 .8627 L
.5 .8627 L
.5 .85646 L
F
.75 0 .505 r
.02381 .8627 m
.02381 .86895 L
.5 .86895 L
.5 .8627 L
F
.75 0 .509 r
.02381 .86895 m
.02381 .8752 L
.5 .8752 L
.5 .86895 L
F
.75 0 .513 r
.02381 .8752 m
.02381 .88145 L
.5 .88145 L
.5 .8752 L
F
.75 0 .516 r
.02381 .88145 m
.02381 .8877 L
.5 .8877 L
.5 .88145 L
F
.75 0 .52 r
.02381 .8877 m
.02381 .89395 L
.5 .89395 L
.5 .8877 L
F
.75 0 .523 r
.02381 .89395 m
.02381 .9002 L
.5 .9002 L
.5 .89395 L
F
.75 0 .527 r
.02381 .9002 m
.02381 .90645 L
.5 .90645 L
.5 .9002 L
F
.75 0 .531 r
.02381 .90645 m
.02381 .9127 L
.5 .9127 L
.5 .90645 L
F
.75 0 .534 r
.02381 .9127 m
.02381 .91895 L
.5 .91895 L
.5 .9127 L
F
.75 0 .538 r
.02381 .91895 m
.02381 .9252 L
.5 .9252 L
.5 .91895 L
F
.75 0 .542 r
.02381 .9252 m
.02381 .93145 L
.5 .93145 L
.5 .9252 L
F
.75 0 .545 r
.02381 .93145 m
.02381 .9377 L
.5 .9377 L
.5 .93145 L
F
.75 0 .549 r
.02381 .9377 m
.02381 .94394 L
.5 .94394 L
.5 .9377 L
F
.75 0 .553 r
.02381 .94394 m
.02381 .95019 L
.5 .95019 L
.5 .94394 L
F
.75 0 .556 r
.02381 .95019 m
.02381 .95644 L
.5 .95644 L
.5 .95019 L
F
.75 0 .56 r
.02381 .95644 m
.02381 .96269 L
.5 .96269 L
.5 .95644 L
F
.75 0 .564 r
.02381 .96269 m
.02381 .96894 L
.5 .96894 L
.5 .96269 L
F
.75 0 .567 r
.02381 .96894 m
.02381 .97519 L
.5 .97519 L
.5 .96894 L
F
.75 0 .571 r
.02381 .97519 m
.02381 .98144 L
.5 .98144 L
.5 .97519 L
F
.75 0 .575 r
.02381 .98144 m
.02381 .98769 L
.5 .98769 L
.5 .98144 L
F
.75 0 .578 r
.02381 .98769 m
.02381 .99394 L
.5 .99394 L
.5 .98769 L
F
.75 0 .582 r
.02381 .99394 m
.02381 1.00019 L
.5 1.00019 L
.5 .99394 L
F
.75 0 .586 r
.02381 1.00019 m
.02381 1.00644 L
.5 1.00644 L
.5 1.00019 L
F
.75 0 .589 r
.02381 1.00644 m
.02381 1.01269 L
.5 1.01269 L
.5 1.00644 L
F
.75 0 .593 r
.02381 1.01269 m
.02381 1.01894 L
.5 1.01894 L
.5 1.01269 L
F
.75 0 .597 r
.02381 1.01894 m
.02381 1.02518 L
.5 1.02518 L
.5 1.01894 L
F
.75 0 .6 r
.02381 1.02518 m
.02381 1.03143 L
.5 1.03143 L
.5 1.02518 L
F
.75 0 .604 r
.02381 1.03143 m
.02381 1.03768 L
.5 1.03768 L
.5 1.03143 L
F
.75 0 .608 r
.02381 1.03768 m
.02381 1.04393 L
.5 1.04393 L
.5 1.03768 L
F
.75 0 .611 r
.02381 1.04393 m
.02381 1.05018 L
.5 1.05018 L
.5 1.04393 L
F
.75 0 .615 r
.02381 1.05018 m
.02381 1.05643 L
.5 1.05643 L
.5 1.05018 L
F
.75 0 .619 r
.02381 1.05643 m
.02381 1.06268 L
.5 1.06268 L
.5 1.05643 L
F
.75 0 .622 r
.02381 1.06268 m
.02381 1.06893 L
.5 1.06893 L
.5 1.06268 L
F
.75 0 .626 r
.02381 1.06893 m
.02381 1.07518 L
.5 1.07518 L
.5 1.06893 L
F
.75 0 .63 r
.02381 1.07518 m
.02381 1.08143 L
.5 1.08143 L
.5 1.07518 L
F
.75 0 .633 r
.02381 1.08143 m
.02381 1.08768 L
.5 1.08768 L
.5 1.08143 L
F
.75 0 .637 r
.02381 1.08768 m
.02381 1.09393 L
.5 1.09393 L
.5 1.08768 L
F
.75 0 .641 r
.02381 1.09393 m
.02381 1.10017 L
.5 1.10017 L
.5 1.09393 L
F
.75 0 .644 r
.02381 1.10017 m
.02381 1.10642 L
.5 1.10642 L
.5 1.10017 L
F
.75 0 .648 r
.02381 1.10642 m
.02381 1.11267 L
.5 1.11267 L
.5 1.10642 L
F
.75 0 .652 r
.02381 1.11267 m
.02381 1.11892 L
.5 1.11892 L
.5 1.11267 L
F
.75 0 .655 r
.02381 1.11892 m
.02381 1.12517 L
.5 1.12517 L
.5 1.11892 L
F
.75 0 .659 r
.02381 1.12517 m
.02381 1.13142 L
.5 1.13142 L
.5 1.12517 L
F
.75 0 .663 r
.02381 1.13142 m
.02381 1.13767 L
.5 1.13767 L
.5 1.13142 L
F
.75 0 .666 r
.02381 1.13767 m
.02381 1.14392 L
.5 1.14392 L
.5 1.13767 L
F
.75 0 .67 r
.02381 1.14392 m
.02381 1.15017 L
.5 1.15017 L
.5 1.14392 L
F
.75 0 .674 r
.02381 1.15017 m
.02381 1.15642 L
.5 1.15642 L
.5 1.15017 L
F
.75 0 .677 r
.02381 1.15642 m
.02381 1.16267 L
.5 1.16267 L
.5 1.15642 L
F
.75 0 .681 r
.02381 1.16267 m
.02381 1.16892 L
.5 1.16892 L
.5 1.16267 L
F
.75 0 .685 r
.02381 1.16892 m
.02381 1.17517 L
.5 1.17517 L
.5 1.16892 L
F
.75 0 .688 r
.02381 1.17517 m
.02381 1.18141 L
.5 1.18141 L
.5 1.17517 L
F
.75 0 .692 r
.02381 1.18141 m
.02381 1.18766 L
.5 1.18766 L
.5 1.18141 L
F
.75 0 .696 r
.02381 1.18766 m
.02381 1.19391 L
.5 1.19391 L
.5 1.18766 L
F
.75 0 .699 r
.02381 1.19391 m
.02381 1.20016 L
.5 1.20016 L
.5 1.19391 L
F
.75 0 .703 r
.02381 1.20016 m
.02381 1.20641 L
.5 1.20641 L
.5 1.20016 L
F
.75 0 .707 r
.02381 1.20641 m
.02381 1.21266 L
.5 1.21266 L
.5 1.20641 L
F
.75 0 .71 r
.02381 1.21266 m
.02381 1.21891 L
.5 1.21891 L
.5 1.21266 L
F
.75 0 .714 r
.02381 1.21891 m
.02381 1.22516 L
.5 1.22516 L
.5 1.21891 L
F
.75 0 .718 r
.02381 1.22516 m
.02381 1.23141 L
.5 1.23141 L
.5 1.22516 L
F
.75 0 .721 r
.02381 1.23141 m
.02381 1.23766 L
.5 1.23766 L
.5 1.23141 L
F
.75 0 .725 r
.02381 1.23766 m
.02381 1.24391 L
.5 1.24391 L
.5 1.23766 L
F
.75 0 .729 r
.02381 1.24391 m
.02381 1.25016 L
.5 1.25016 L
.5 1.24391 L
F
.75 0 .732 r
.02381 1.25016 m
.02381 1.25641 L
.5 1.25641 L
.5 1.25016 L
F
.75 0 .736 r
.02381 1.25641 m
.02381 1.26265 L
.5 1.26265 L
.5 1.25641 L
F
.75 0 .739 r
.02381 1.26265 m
.02381 1.2689 L
.5 1.2689 L
.5 1.26265 L
F
.75 0 .743 r
.02381 1.2689 m
.02381 1.27515 L
.5 1.27515 L
.5 1.2689 L
F
.75 0 .747 r
.02381 1.27515 m
.02381 1.2814 L
.5 1.2814 L
.5 1.27515 L
F
.75 0 .75 r
.02381 1.2814 m
.02381 1.28765 L
.5 1.28765 L
.5 1.2814 L
F
.746 0 .75 r
.02381 1.28765 m
.02381 1.2939 L
.5 1.2939 L
.5 1.28765 L
F
.742 0 .75 r
.02381 1.2939 m
.02381 1.30015 L
.5 1.30015 L
.5 1.2939 L
F
.739 0 .75 r
.02381 1.30015 m
.02381 1.3064 L
.5 1.3064 L
.5 1.30015 L
F
.735 0 .75 r
.02381 1.3064 m
.02381 1.31265 L
.5 1.31265 L
.5 1.3064 L
F
.731 0 .75 r
.02381 1.31265 m
.02381 1.3189 L
.5 1.3189 L
.5 1.31265 L
F
.728 0 .75 r
.02381 1.3189 m
.02381 1.32515 L
.5 1.32515 L
.5 1.3189 L
F
.724 0 .75 r
.02381 1.32515 m
.02381 1.3314 L
.5 1.3314 L
.5 1.32515 L
F
.72 0 .75 r
.02381 1.3314 m
.02381 1.33765 L
.5 1.33765 L
.5 1.3314 L
F
.717 0 .75 r
.02381 1.33765 m
.02381 1.34389 L
.5 1.34389 L
.5 1.33765 L
F
.713 0 .75 r
.02381 1.34389 m
.02381 1.35014 L
.5 1.35014 L
.5 1.34389 L
F
.709 0 .75 r
.02381 1.35014 m
.02381 1.35639 L
.5 1.35639 L
.5 1.35014 L
F
.706 0 .75 r
.02381 1.35639 m
.02381 1.36264 L
.5 1.36264 L
.5 1.35639 L
F
.702 0 .75 r
.02381 1.36264 m
.02381 1.36889 L
.5 1.36889 L
.5 1.36264 L
F
.698 0 .75 r
.02381 1.36889 m
.02381 1.37514 L
.5 1.37514 L
.5 1.36889 L
F
.695 0 .75 r
.02381 1.37514 m
.02381 1.38139 L
.5 1.38139 L
.5 1.37514 L
F
.691 0 .75 r
.02381 1.38139 m
.02381 1.38764 L
.5 1.38764 L
.5 1.38139 L
F
.687 0 .75 r
.02381 1.38764 m
.02381 1.39389 L
.5 1.39389 L
.5 1.38764 L
F
.684 0 .75 r
.02381 1.39389 m
.02381 1.40014 L
.5 1.40014 L
.5 1.39389 L
F
.68 0 .75 r
.02381 1.40014 m
.02381 1.40639 L
.5 1.40639 L
.5 1.40014 L
F
.676 0 .75 r
.02381 1.40639 m
.02381 1.41264 L
.5 1.41264 L
.5 1.40639 L
F
.673 0 .75 r
.02381 1.41264 m
.02381 1.41889 L
.5 1.41889 L
.5 1.41264 L
F
.669 0 .75 r
.02381 1.41889 m
.02381 1.42513 L
.5 1.42513 L
.5 1.41889 L
F
.665 0 .75 r
.02381 1.42513 m
.02381 1.43138 L
.5 1.43138 L
.5 1.42513 L
F
.662 0 .75 r
.02381 1.43138 m
.02381 1.43763 L
.5 1.43763 L
.5 1.43138 L
F
.658 0 .75 r
.02381 1.43763 m
.02381 1.44388 L
.5 1.44388 L
.5 1.43763 L
F
.654 0 .75 r
.02381 1.44388 m
.02381 1.45013 L
.5 1.45013 L
.5 1.44388 L
F
.651 0 .75 r
.02381 1.45013 m
.02381 1.45638 L
.5 1.45638 L
.5 1.45013 L
F
.647 0 .75 r
.02381 1.45638 m
.02381 1.46263 L
.5 1.46263 L
.5 1.45638 L
F
.643 0 .75 r
.02381 1.46263 m
.02381 1.46888 L
.5 1.46888 L
.5 1.46263 L
F
.64 0 .75 r
.02381 1.46888 m
.02381 1.47513 L
.5 1.47513 L
.5 1.46888 L
F
.636 0 .75 r
.02381 1.47513 m
.02381 1.48138 L
.5 1.48138 L
.5 1.47513 L
F
.632 0 .75 r
.02381 1.48138 m
.02381 1.48763 L
.5 1.48763 L
.5 1.48138 L
F
.629 0 .75 r
.02381 1.48763 m
.02381 1.49388 L
.5 1.49388 L
.5 1.48763 L
F
.625 0 .75 r
.02381 1.49388 m
.02381 1.50012 L
.5 1.50012 L
.5 1.49388 L
F
.621 0 .75 r
.02381 1.50012 m
.02381 1.50637 L
.5 1.50637 L
.5 1.50012 L
F
.618 0 .75 r
.02381 1.50637 m
.02381 1.51262 L
.5 1.51262 L
.5 1.50637 L
F
.614 0 .75 r
.02381 1.51262 m
.02381 1.51887 L
.5 1.51887 L
.5 1.51262 L
F
.61 0 .75 r
.02381 1.51887 m
.02381 1.52512 L
.5 1.52512 L
.5 1.51887 L
F
.607 0 .75 r
.02381 1.52512 m
.02381 1.53137 L
.5 1.53137 L
.5 1.52512 L
F
.603 0 .75 r
.02381 1.53137 m
.02381 1.53762 L
.5 1.53762 L
.5 1.53137 L
F
.599 0 .75 r
.02381 1.53762 m
.02381 1.54387 L
.5 1.54387 L
.5 1.53762 L
F
.596 0 .75 r
.02381 1.54387 m
.02381 1.55012 L
.5 1.55012 L
.5 1.54387 L
F
.592 0 .75 r
.02381 1.55012 m
.02381 1.55637 L
.5 1.55637 L
.5 1.55012 L
F
.588 0 .75 r
.02381 1.55637 m
.02381 1.56262 L
.5 1.56262 L
.5 1.55637 L
F
.585 0 .75 r
.02381 1.56262 m
.02381 1.56887 L
.5 1.56887 L
.5 1.56262 L
F
.581 0 .75 r
.02381 1.56887 m
.02381 1.57512 L
.5 1.57512 L
.5 1.56887 L
F
.577 0 .75 r
.02381 1.57512 m
.02381 1.58136 L
.5 1.58136 L
.5 1.57512 L
F
.574 0 .75 r
.02381 1.58136 m
.02381 1.58761 L
.5 1.58761 L
.5 1.58136 L
F
.57 0 .75 r
.02381 1.58761 m
.02381 1.59386 L
.5 1.59386 L
.5 1.58761 L
F
.566 0 .75 r
.02381 1.59386 m
.02381 1.60011 L
.5 1.60011 L
.5 1.59386 L
F
.563 0 .75 r
.02381 1.60011 m
.02381 1.60636 L
.5 1.60636 L
.5 1.60011 L
F
.559 0 .75 r
.02381 1.60636 m
.02381 1.61261 L
.5 1.61261 L
.5 1.60636 L
F
.556 0 .75 r
.02381 1.61261 m
.02381 1.61886 L
.5 1.61886 L
.5 1.61261 L
F
.552 0 .75 r
.02381 1.61886 m
.02381 1.62511 L
.5 1.62511 L
.5 1.61886 L
F
.548 0 .75 r
.02381 1.62511 m
.02381 1.63136 L
.5 1.63136 L
.5 1.62511 L
F
.545 0 .75 r
.02381 1.63136 m
.02381 1.63761 L
.5 1.63761 L
.5 1.63136 L
F
.541 0 .75 r
.02381 1.63761 m
.02381 1.64386 L
.5 1.64386 L
.5 1.63761 L
F
.537 0 .75 r
.02381 1.64386 m
.02381 1.65011 L
.5 1.65011 L
.5 1.64386 L
F
.534 0 .75 r
.02381 1.65011 m
.02381 1.65636 L
.5 1.65636 L
.5 1.65011 L
F
.53 0 .75 r
.02381 1.65636 m
.02381 1.6626 L
.5 1.6626 L
.5 1.65636 L
F
.526 0 .75 r
.02381 1.6626 m
.02381 1.66885 L
.5 1.66885 L
.5 1.6626 L
F
.523 0 .75 r
.02381 1.66885 m
.02381 1.6751 L
.5 1.6751 L
.5 1.66885 L
F
.519 0 .75 r
.02381 1.6751 m
.02381 1.68135 L
.5 1.68135 L
.5 1.6751 L
F
.515 0 .75 r
.02381 1.68135 m
.02381 1.6876 L
.5 1.6876 L
.5 1.68135 L
F
.512 0 .75 r
.02381 1.6876 m
.02381 1.69385 L
.5 1.69385 L
.5 1.6876 L
F
.508 0 .75 r
.02381 1.69385 m
.02381 1.7001 L
.5 1.7001 L
.5 1.69385 L
F
.504 0 .75 r
.02381 1.7001 m
.02381 1.70635 L
.5 1.70635 L
.5 1.7001 L
F
.501 0 .75 r
.02381 1.70635 m
.02381 1.7126 L
.5 1.7126 L
.5 1.70635 L
F
.497 0 .75 r
.02381 1.7126 m
.02381 1.71885 L
.5 1.71885 L
.5 1.7126 L
F
.493 0 .75 r
.02381 1.71885 m
.02381 1.7251 L
.5 1.7251 L
.5 1.71885 L
F
.49 0 .75 r
.02381 1.7251 m
.02381 1.73135 L
.5 1.73135 L
.5 1.7251 L
F
.486 0 .75 r
.02381 1.73135 m
.02381 1.7376 L
.5 1.7376 L
.5 1.73135 L
F
.482 0 .75 r
.02381 1.7376 m
.02381 1.74384 L
.5 1.74384 L
.5 1.7376 L
F
.479 0 .75 r
.02381 1.74384 m
.02381 1.75009 L
.5 1.75009 L
.5 1.74384 L
F
.475 0 .75 r
.02381 1.75009 m
.02381 1.75634 L
.5 1.75634 L
.5 1.75009 L
F
.471 0 .75 r
.02381 1.75634 m
.02381 1.76259 L
.5 1.76259 L
.5 1.75634 L
F
.468 0 .75 r
.02381 1.76259 m
.02381 1.76884 L
.5 1.76884 L
.5 1.76259 L
F
.464 0 .75 r
.02381 1.76884 m
.02381 1.77509 L
.5 1.77509 L
.5 1.76884 L
F
.46 0 .75 r
.02381 1.77509 m
.02381 1.78134 L
.5 1.78134 L
.5 1.77509 L
F
.457 0 .75 r
.02381 1.78134 m
.02381 1.78759 L
.5 1.78759 L
.5 1.78134 L
F
.453 0 .75 r
.02381 1.78759 m
.02381 1.79384 L
.5 1.79384 L
.5 1.78759 L
F
.449 0 .75 r
.02381 1.79384 m
.02381 1.80009 L
.5 1.80009 L
.5 1.79384 L
F
.446 0 .75 r
.02381 1.80009 m
.02381 1.80634 L
.5 1.80634 L
.5 1.80009 L
F
.442 0 .75 r
.02381 1.80634 m
.02381 1.81259 L
.5 1.81259 L
.5 1.80634 L
F
.438 0 .75 r
.02381 1.81259 m
.02381 1.81884 L
.5 1.81884 L
.5 1.81259 L
F
.435 0 .75 r
.02381 1.81884 m
.02381 1.82508 L
.5 1.82508 L
.5 1.81884 L
F
.431 0 .75 r
.02381 1.82508 m
.02381 1.83133 L
.5 1.83133 L
.5 1.82508 L
F
.427 0 .75 r
.02381 1.83133 m
.02381 1.83758 L
.5 1.83758 L
.5 1.83133 L
F
.424 0 .75 r
.02381 1.83758 m
.02381 1.84383 L
.5 1.84383 L
.5 1.83758 L
F
.42 0 .75 r
.02381 1.84383 m
.02381 1.85008 L
.5 1.85008 L
.5 1.84383 L
F
.416 0 .75 r
.02381 1.85008 m
.02381 1.85633 L
.5 1.85633 L
.5 1.85008 L
F
.413 0 .75 r
.02381 1.85633 m
.02381 1.86258 L
.5 1.86258 L
.5 1.85633 L
F
.409 0 .75 r
.02381 1.86258 m
.02381 1.86883 L
.5 1.86883 L
.5 1.86258 L
F
.405 0 .75 r
.02381 1.86883 m
.02381 1.87508 L
.5 1.87508 L
.5 1.86883 L
F
.402 0 .75 r
.02381 1.87508 m
.02381 1.88133 L
.5 1.88133 L
.5 1.87508 L
F
.398 0 .75 r
.02381 1.88133 m
.02381 1.88758 L
.5 1.88758 L
.5 1.88133 L
F
.394 0 .75 r
.02381 1.88758 m
.02381 1.89383 L
.5 1.89383 L
.5 1.88758 L
F
.391 0 .75 r
.02381 1.89383 m
.02381 1.90007 L
.5 1.90007 L
.5 1.89383 L
F
.387 0 .75 r
.02381 1.90007 m
.02381 1.90632 L
.5 1.90632 L
.5 1.90007 L
F
.383 0 .75 r
.02381 1.90632 m
.02381 1.91257 L
.5 1.91257 L
.5 1.90632 L
F
.38 0 .75 r
.02381 1.91257 m
.02381 1.91882 L
.5 1.91882 L
.5 1.91257 L
F
.376 0 .75 r
.02381 1.91882 m
.02381 1.92507 L
.5 1.92507 L
.5 1.91882 L
F
.372 0 .75 r
.02381 1.92507 m
.02381 1.93132 L
.5 1.93132 L
.5 1.92507 L
F
.369 0 .75 r
.02381 1.93132 m
.02381 1.93757 L
.5 1.93757 L
.5 1.93132 L
F
.365 0 .75 r
.02381 1.93757 m
.02381 1.94382 L
.5 1.94382 L
.5 1.93757 L
F
.361 0 .75 r
.02381 1.94382 m
.02381 1.95007 L
.5 1.95007 L
.5 1.94382 L
F
.358 0 .75 r
.02381 1.95007 m
.02381 1.95632 L
.5 1.95632 L
.5 1.95007 L
F
.354 0 .75 r
.02381 1.95632 m
.02381 1.96257 L
.5 1.96257 L
.5 1.95632 L
F
.351 0 .75 r
.02381 1.96257 m
.02381 1.96882 L
.5 1.96882 L
.5 1.96257 L
F
.347 0 .75 r
.02381 1.96882 m
.02381 1.97507 L
.5 1.97507 L
.5 1.96882 L
F
.343 0 .75 r
.02381 1.97507 m
.02381 1.98131 L
.5 1.98131 L
.5 1.97507 L
F
.34 0 .75 r
.02381 1.98131 m
.02381 1.98756 L
.5 1.98756 L
.5 1.98131 L
F
.336 0 .75 r
.02381 1.98756 m
.02381 1.99381 L
.5 1.99381 L
.5 1.98756 L
F
.332 0 .75 r
.02381 1.99381 m
.02381 2.00006 L
.5 2.00006 L
.5 1.99381 L
F
.329 0 .75 r
.02381 2.00006 m
.02381 2.00631 L
.5 2.00631 L
.5 2.00006 L
F
.325 0 .75 r
.02381 2.00631 m
.02381 2.01256 L
.5 2.01256 L
.5 2.00631 L
F
.321 0 .75 r
.02381 2.01256 m
.02381 2.01881 L
.5 2.01881 L
.5 2.01256 L
F
.318 0 .75 r
.02381 2.01881 m
.02381 2.02506 L
.5 2.02506 L
.5 2.01881 L
F
.314 0 .75 r
.02381 2.02506 m
.02381 2.03131 L
.5 2.03131 L
.5 2.02506 L
F
.31 0 .75 r
.02381 2.03131 m
.02381 2.03756 L
.5 2.03756 L
.5 2.03131 L
F
.307 0 .75 r
.02381 2.03756 m
.02381 2.04381 L
.5 2.04381 L
.5 2.03756 L
F
.303 0 .75 r
.02381 2.04381 m
.02381 2.05006 L
.5 2.05006 L
.5 2.04381 L
F
.299 0 .75 r
.02381 2.05006 m
.02381 2.05631 L
.5 2.05631 L
.5 2.05006 L
F
.296 0 .75 r
.02381 2.05631 m
.02381 2.06255 L
.5 2.06255 L
.5 2.05631 L
F
.292 0 .75 r
.02381 2.06255 m
.02381 2.0688 L
.5 2.0688 L
.5 2.06255 L
F
.288 0 .75 r
.02381 2.0688 m
.02381 2.07505 L
.5 2.07505 L
.5 2.0688 L
F
.285 0 .75 r
.02381 2.07505 m
.02381 2.0813 L
.5 2.0813 L
.5 2.07505 L
F
.281 0 .75 r
.02381 2.0813 m
.02381 2.08755 L
.5 2.08755 L
.5 2.0813 L
F
.277 0 .75 r
.02381 2.08755 m
.02381 2.0938 L
.5 2.0938 L
.5 2.08755 L
F
.274 0 .75 r
.02381 2.0938 m
.02381 2.10005 L
.5 2.10005 L
.5 2.0938 L
F
.27 0 .75 r
.02381 2.10005 m
.02381 2.1063 L
.5 2.1063 L
.5 2.10005 L
F
.266 0 .75 r
.02381 2.1063 m
.02381 2.11255 L
.5 2.11255 L
.5 2.1063 L
F
.263 0 .75 r
.02381 2.11255 m
.02381 2.1188 L
.5 2.1188 L
.5 2.11255 L
F
.259 0 .75 r
.02381 2.1188 m
.02381 2.12505 L
.5 2.12505 L
.5 2.1188 L
F
.255 0 .75 r
.02381 2.12505 m
.02381 2.1313 L
.5 2.1313 L
.5 2.12505 L
F
.252 0 .75 r
.02381 2.1313 m
.02381 2.13755 L
.5 2.13755 L
.5 2.1313 L
F
.248 0 .75 r
.02381 2.13755 m
.02381 2.14379 L
.5 2.14379 L
.5 2.13755 L
F
.244 0 .75 r
.02381 2.14379 m
.02381 2.15004 L
.5 2.15004 L
.5 2.14379 L
F
.241 0 .75 r
.02381 2.15004 m
.02381 2.15629 L
.5 2.15629 L
.5 2.15004 L
F
.237 0 .75 r
.02381 2.15629 m
.02381 2.16254 L
.5 2.16254 L
.5 2.15629 L
F
.233 0 .75 r
.02381 2.16254 m
.02381 2.16879 L
.5 2.16879 L
.5 2.16254 L
F
.23 0 .75 r
.02381 2.16879 m
.02381 2.17504 L
.5 2.17504 L
.5 2.16879 L
F
.226 0 .75 r
.02381 2.17504 m
.02381 2.18129 L
.5 2.18129 L
.5 2.17504 L
F
.222 0 .75 r
.02381 2.18129 m
.02381 2.18754 L
.5 2.18754 L
.5 2.18129 L
F
.219 0 .75 r
.02381 2.18754 m
.02381 2.19379 L
.5 2.19379 L
.5 2.18754 L
F
.215 0 .75 r
.02381 2.19379 m
.02381 2.20004 L
.5 2.20004 L
.5 2.19379 L
F
.211 0 .75 r
.02381 2.20004 m
.02381 2.20629 L
.5 2.20629 L
.5 2.20004 L
F
.208 0 .75 r
.02381 2.20629 m
.02381 2.21254 L
.5 2.21254 L
.5 2.20629 L
F
.204 0 .75 r
.02381 2.21254 m
.02381 2.21879 L
.5 2.21879 L
.5 2.21254 L
F
.2 0 .75 r
.02381 2.21879 m
.02381 2.22503 L
.5 2.22503 L
.5 2.21879 L
F
.197 0 .75 r
.02381 2.22503 m
.02381 2.23128 L
.5 2.23128 L
.5 2.22503 L
F
.193 0 .75 r
.02381 2.23128 m
.02381 2.23753 L
.5 2.23753 L
.5 2.23128 L
F
.189 0 .75 r
.02381 2.23753 m
.02381 2.24378 L
.5 2.24378 L
.5 2.23753 L
F
.186 0 .75 r
.02381 2.24378 m
.02381 2.25003 L
.5 2.25003 L
.5 2.24378 L
F
.182 0 .75 r
.02381 2.25003 m
.02381 2.25628 L
.5 2.25628 L
.5 2.25003 L
F
.178 0 .75 r
.02381 2.25628 m
.02381 2.26253 L
.5 2.26253 L
.5 2.25628 L
F
.175 0 .75 r
.02381 2.26253 m
.02381 2.26878 L
.5 2.26878 L
.5 2.26253 L
F
.171 0 .75 r
.02381 2.26878 m
.02381 2.27503 L
.5 2.27503 L
.5 2.26878 L
F
.167 0 .75 r
.02381 2.27503 m
.02381 2.28128 L
.5 2.28128 L
.5 2.27503 L
F
.164 0 .75 r
.02381 2.28128 m
.02381 2.28753 L
.5 2.28753 L
.5 2.28128 L
F
.16 0 .75 r
.02381 2.28753 m
.02381 2.29378 L
.5 2.29378 L
.5 2.28753 L
F
.156 0 .75 r
.02381 2.29378 m
.02381 2.30002 L
.5 2.30002 L
.5 2.29378 L
F
.153 0 .75 r
.02381 2.30002 m
.02381 2.30627 L
.5 2.30627 L
.5 2.30002 L
F
.149 0 .75 r
.02381 2.30627 m
.02381 2.31252 L
.5 2.31252 L
.5 2.30627 L
F
.145 0 .75 r
.02381 2.31252 m
.02381 2.31877 L
.5 2.31877 L
.5 2.31252 L
F
.142 0 .75 r
.02381 2.31877 m
.02381 2.32502 L
.5 2.32502 L
.5 2.31877 L
F
.138 0 .75 r
.02381 2.32502 m
.02381 2.33127 L
.5 2.33127 L
.5 2.32502 L
F
.135 0 .75 r
.02381 2.33127 m
.02381 2.33752 L
.5 2.33752 L
.5 2.33127 L
F
.131 0 .75 r
.02381 2.33752 m
.02381 2.34377 L
.5 2.34377 L
.5 2.33752 L
F
.127 0 .75 r
.02381 2.34377 m
.02381 2.35002 L
.5 2.35002 L
.5 2.34377 L
F
.124 0 .75 r
.02381 2.35002 m
.02381 2.35627 L
.5 2.35627 L
.5 2.35002 L
F
.12 0 .75 r
.02381 2.35627 m
.02381 2.36252 L
.5 2.36252 L
.5 2.35627 L
F
.116 0 .75 r
.02381 2.36252 m
.02381 2.36877 L
.5 2.36877 L
.5 2.36252 L
F
.113 0 .75 r
.02381 2.36877 m
.02381 2.37502 L
.5 2.37502 L
.5 2.36877 L
F
.109 0 .75 r
.02381 2.37502 m
.02381 2.38126 L
.5 2.38126 L
.5 2.37502 L
F
.105 0 .75 r
.02381 2.38126 m
.02381 2.38751 L
.5 2.38751 L
.5 2.38126 L
F
.102 0 .75 r
.02381 2.38751 m
.02381 2.39376 L
.5 2.39376 L
.5 2.38751 L
F
.098 0 .75 r
.02381 2.39376 m
.02381 2.40001 L
.5 2.40001 L
.5 2.39376 L
F
.094 0 .75 r
.02381 2.40001 m
.02381 2.40626 L
.5 2.40626 L
.5 2.40001 L
F
.091 0 .75 r
.02381 2.40626 m
.02381 2.41251 L
.5 2.41251 L
.5 2.40626 L
F
.087 0 .75 r
.02381 2.41251 m
.02381 2.41876 L
.5 2.41876 L
.5 2.41251 L
F
.083 0 .75 r
.02381 2.41876 m
.02381 2.42501 L
.5 2.42501 L
.5 2.41876 L
F
.08 0 .75 r
.02381 2.42501 m
.02381 2.43126 L
.5 2.43126 L
.5 2.42501 L
F
.076 0 .75 r
.02381 2.43126 m
.02381 2.43751 L
.5 2.43751 L
.5 2.43126 L
F
.072 0 .75 r
.02381 2.43751 m
.02381 2.44376 L
.5 2.44376 L
.5 2.43751 L
F
.069 0 .75 r
.02381 2.44376 m
.02381 2.45001 L
.5 2.45001 L
.5 2.44376 L
F
.065 0 .75 r
.02381 2.45001 m
.02381 2.45626 L
.5 2.45626 L
.5 2.45001 L
F
.061 0 .75 r
.02381 2.45626 m
.02381 2.4625 L
.5 2.4625 L
.5 2.45626 L
F
.058 0 .75 r
.02381 2.4625 m
.02381 2.46875 L
.5 2.46875 L
.5 2.4625 L
F
.054 0 .75 r
.02381 2.46875 m
.02381 2.475 L
.5 2.475 L
.5 2.46875 L
F
.05 0 .75 r
.02381 2.475 m
.02381 2.48125 L
.5 2.48125 L
.5 2.475 L
F
.047 0 .75 r
.02381 2.48125 m
.02381 2.4875 L
.5 2.4875 L
.5 2.48125 L
F
.043 0 .75 r
.02381 2.4875 m
.02381 2.49375 L
.5 2.49375 L
.5 2.4875 L
F
.039 0 .75 r
.02381 2.49375 m
.02381 2.5 L
.5 2.5 L
.5 2.49375 L
F
.036 0 .75 r
.02381 2.5 m
.02381 2.50625 L
.5 2.50625 L
.5 2.5 L
F
.032 0 .75 r
.02381 2.50625 m
.02381 2.5125 L
.5 2.5125 L
.5 2.50625 L
F
.028 0 .75 r
.02381 2.5125 m
.02381 2.51875 L
.5 2.51875 L
.5 2.5125 L
F
.025 0 .75 r
.02381 2.51875 m
.02381 2.525 L
.5 2.525 L
.5 2.51875 L
F
.021 0 .75 r
.02381 2.525 m
.02381 2.53125 L
.5 2.53125 L
.5 2.525 L
F
.017 0 .75 r
.02381 2.53125 m
.02381 2.5375 L
.5 2.5375 L
.5 2.53125 L
F
.014 0 .75 r
.02381 2.5375 m
.02381 2.54374 L
.5 2.54374 L
.5 2.5375 L
F
.01 0 .75 r
.02381 2.54374 m
.02381 2.54999 L
.5 2.54999 L
.5 2.54374 L
F
.006 0 .75 r
.02381 2.54999 m
.02381 2.55624 L
.5 2.55624 L
.5 2.54999 L
F
.003 0 .75 r
.02381 2.55624 m
.02381 2.56249 L
.5 2.56249 L
.5 2.55624 L
F
0 .001 .75 r
.02381 2.56249 m
.02381 2.56874 L
.5 2.56874 L
.5 2.56249 L
F
0 .005 .75 r
.02381 2.56874 m
.02381 2.57499 L
.5 2.57499 L
.5 2.56874 L
F
0 .008 .75 r
.02381 2.57499 m
.02381 2.58124 L
.5 2.58124 L
.5 2.57499 L
F
0 .012 .75 r
.02381 2.58124 m
.02381 2.58749 L
.5 2.58749 L
.5 2.58124 L
F
0 .016 .75 r
.02381 2.58749 m
.02381 2.59374 L
.5 2.59374 L
.5 2.58749 L
F
0 .019 .75 r
.02381 2.59374 m
.02381 2.59999 L
.5 2.59999 L
.5 2.59374 L
F
0 .023 .75 r
.02381 2.59999 m
.02381 2.60624 L
.5 2.60624 L
.5 2.59999 L
F
0 .027 .75 r
.02381 2.60624 m
.02381 2.61249 L
.5 2.61249 L
.5 2.60624 L
F
0 .03 .75 r
.02381 2.61249 m
.02381 2.61874 L
.5 2.61874 L
.5 2.61249 L
F
0 .034 .75 r
.02381 2.61874 m
.02381 2.62498 L
.5 2.62498 L
.5 2.61874 L
F
0 .038 .75 r
.02381 2.62498 m
.02381 2.63123 L
.5 2.63123 L
.5 2.62498 L
F
0 .041 .75 r
.02381 2.63123 m
.02381 2.63748 L
.5 2.63748 L
.5 2.63123 L
F
0 .045 .75 r
.02381 2.63748 m
.02381 2.64373 L
.5 2.64373 L
.5 2.63748 L
F
0 .049 .75 r
.02381 2.64373 m
.02381 2.64998 L
.5 2.64998 L
.5 2.64373 L
F
0 .052 .75 r
.02381 2.64998 m
.02381 2.65623 L
.5 2.65623 L
.5 2.64998 L
F
0 .056 .75 r
.02381 2.65623 m
.02381 2.66248 L
.5 2.66248 L
.5 2.65623 L
F
0 .06 .75 r
.02381 2.66248 m
.02381 2.66873 L
.5 2.66873 L
.5 2.66248 L
F
0 .063 .75 r
.02381 2.66873 m
.02381 2.67498 L
.5 2.67498 L
.5 2.66873 L
F
0 .067 .75 r
.02381 2.67498 m
.02381 2.68123 L
.5 2.68123 L
.5 2.67498 L
F
0 .07 .75 r
.02381 2.68123 m
.02381 2.68748 L
.5 2.68748 L
.5 2.68123 L
F
0 .074 .75 r
.02381 2.68748 m
.02381 2.69373 L
.5 2.69373 L
.5 2.68748 L
F
0 .078 .75 r
.02381 2.69373 m
.02381 2.69998 L
.5 2.69998 L
.5 2.69373 L
F
0 .081 .75 r
.02381 2.69998 m
.02381 2.70622 L
.5 2.70622 L
.5 2.69998 L
F
0 .085 .75 r
.02381 2.70622 m
.02381 2.71247 L
.5 2.71247 L
.5 2.70622 L
F
0 .089 .75 r
.02381 2.71247 m
.02381 2.71872 L
.5 2.71872 L
.5 2.71247 L
F
0 .092 .75 r
.02381 2.71872 m
.02381 2.72497 L
.5 2.72497 L
.5 2.71872 L
F
0 .096 .75 r
.02381 2.72497 m
.02381 2.73122 L
.5 2.73122 L
.5 2.72497 L
F
0 .1 .75 r
.02381 2.73122 m
.02381 2.73747 L
.5 2.73747 L
.5 2.73122 L
F
0 .103 .75 r
.02381 2.73747 m
.02381 2.74372 L
.5 2.74372 L
.5 2.73747 L
F
0 .107 .75 r
.02381 2.74372 m
.02381 2.74997 L
.5 2.74997 L
.5 2.74372 L
F
0 .111 .75 r
.02381 2.74997 m
.02381 2.75622 L
.5 2.75622 L
.5 2.74997 L
F
0 .114 .75 r
.02381 2.75622 m
.02381 2.76247 L
.5 2.76247 L
.5 2.75622 L
F
0 .118 .75 r
.02381 2.76247 m
.02381 2.76872 L
.5 2.76872 L
.5 2.76247 L
F
0 .122 .75 r
.02381 2.76872 m
.02381 2.77497 L
.5 2.77497 L
.5 2.76872 L
F
0 .125 .75 r
.02381 2.77497 m
.02381 2.78121 L
.5 2.78121 L
.5 2.77497 L
F
0 .129 .75 r
.02381 2.78121 m
.02381 2.78746 L
.5 2.78746 L
.5 2.78121 L
F
0 .133 .75 r
.02381 2.78746 m
.02381 2.79371 L
.5 2.79371 L
.5 2.78746 L
F
0 .136 .75 r
.02381 2.79371 m
.02381 2.79996 L
.5 2.79996 L
.5 2.79371 L
F
0 .14 .75 r
.02381 2.79996 m
.02381 2.80621 L
.5 2.80621 L
.5 2.79996 L
F
0 .144 .75 r
.02381 2.80621 m
.02381 2.81246 L
.5 2.81246 L
.5 2.80621 L
F
0 .147 .75 r
.02381 2.81246 m
.02381 2.81871 L
.5 2.81871 L
.5 2.81246 L
F
0 .151 .75 r
.02381 2.81871 m
.02381 2.82496 L
.5 2.82496 L
.5 2.81871 L
F
0 .155 .75 r
.02381 2.82496 m
.02381 2.83121 L
.5 2.83121 L
.5 2.82496 L
F
0 .158 .75 r
.02381 2.83121 m
.02381 2.83746 L
.5 2.83746 L
.5 2.83121 L
F
0 .162 .75 r
.02381 2.83746 m
.02381 2.84371 L
.5 2.84371 L
.5 2.83746 L
F
0 .166 .75 r
.02381 2.84371 m
.02381 2.84996 L
.5 2.84996 L
.5 2.84371 L
F
0 .169 .75 r
.02381 2.84996 m
.02381 2.85621 L
.5 2.85621 L
.5 2.84996 L
F
0 .173 .75 r
.02381 2.85621 m
.02381 2.86245 L
.5 2.86245 L
.5 2.85621 L
F
0 .177 .75 r
.02381 2.86245 m
.02381 2.8687 L
.5 2.8687 L
.5 2.86245 L
F
0 .18 .75 r
.02381 2.8687 m
.02381 2.87495 L
.5 2.87495 L
.5 2.8687 L
F
0 .184 .75 r
.02381 2.87495 m
.02381 2.8812 L
.5 2.8812 L
.5 2.87495 L
F
0 .188 .75 r
.02381 2.8812 m
.02381 2.88745 L
.5 2.88745 L
.5 2.8812 L
F
0 .191 .75 r
.02381 2.88745 m
.02381 2.8937 L
.5 2.8937 L
.5 2.88745 L
F
0 .195 .75 r
.02381 2.8937 m
.02381 2.89995 L
.5 2.89995 L
.5 2.8937 L
F
0 .199 .75 r
.02381 2.89995 m
.02381 2.9062 L
.5 2.9062 L
.5 2.89995 L
F
0 .202 .75 r
.02381 2.9062 m
.02381 2.91245 L
.5 2.91245 L
.5 2.9062 L
F
0 .206 .75 r
.02381 2.91245 m
.02381 2.9187 L
.5 2.9187 L
.5 2.91245 L
F
0 .21 .75 r
.02381 2.9187 m
.02381 2.92495 L
.5 2.92495 L
.5 2.9187 L
F
0 .213 .75 r
.02381 2.92495 m
.02381 2.9312 L
.5 2.9312 L
.5 2.92495 L
F
0 .217 .75 r
.02381 2.9312 m
.02381 2.93745 L
.5 2.93745 L
.5 2.9312 L
F
0 .221 .75 r
.02381 2.93745 m
.02381 2.94369 L
.5 2.94369 L
.5 2.93745 L
F
0 .224 .75 r
.02381 2.94369 m
.02381 2.94994 L
.5 2.94994 L
.5 2.94369 L
F
0 .228 .75 r
.02381 2.94994 m
.02381 2.95619 L
.5 2.95619 L
.5 2.94994 L
F
0 .232 .75 r
.02381 2.95619 m
.02381 2.96244 L
.5 2.96244 L
.5 2.95619 L
F
0 .235 .75 r
.02381 2.96244 m
.02381 2.96869 L
.5 2.96869 L
.5 2.96244 L
F
0 .239 .75 r
.02381 2.96869 m
.02381 2.97494 L
.5 2.97494 L
.5 2.96869 L
F
0 .243 .75 r
.02381 2.97494 m
.02381 2.98119 L
.5 2.98119 L
.5 2.97494 L
F
0 .246 .75 r
.02381 2.98119 m
.02381 2.98744 L
.5 2.98744 L
.5 2.98119 L
F
0 .25 .75 r
.02381 2.98744 m
.02381 2.99369 L
.5 2.99369 L
.5 2.98744 L
F
0 .254 .75 r
.02381 2.99369 m
.02381 2.99994 L
.5 2.99994 L
.5 2.99369 L
F
0 .257 .75 r
.02381 2.99994 m
.02381 3.00619 L
.5 3.00619 L
.5 2.99994 L
F
0 .261 .75 r
.02381 3.00619 m
.02381 3.01244 L
.5 3.01244 L
.5 3.00619 L
F
0 .265 .75 r
.02381 3.01244 m
.02381 3.01869 L
.5 3.01869 L
.5 3.01244 L
F
0 .268 .75 r
.02381 3.01869 m
.02381 3.02493 L
.5 3.02493 L
.5 3.01869 L
F
0 .272 .75 r
.02381 3.02493 m
.02381 3.03118 L
.5 3.03118 L
.5 3.02493 L
F
0 .276 .75 r
.02381 3.03118 m
.02381 3.03743 L
.5 3.03743 L
.5 3.03118 L
F
0 .279 .75 r
.02381 3.03743 m
.02381 3.04368 L
.5 3.04368 L
.5 3.03743 L
F
0 .283 .75 r
.02381 3.04368 m
.02381 3.04993 L
.5 3.04993 L
.5 3.04368 L
F
0 .286 .75 r
.02381 3.04993 m
.02381 3.05618 L
.5 3.05618 L
.5 3.04993 L
F
0 .29 .75 r
.02381 3.05618 m
.02381 3.06243 L
.5 3.06243 L
.5 3.05618 L
F
0 .294 .75 r
.02381 3.06243 m
.02381 3.06868 L
.5 3.06868 L
.5 3.06243 L
F
0 .297 .75 r
.02381 3.06868 m
.02381 3.07493 L
.5 3.07493 L
.5 3.06868 L
F
0 .301 .75 r
.02381 3.07493 m
.02381 3.08118 L
.5 3.08118 L
.5 3.07493 L
F
0 .305 .75 r
.02381 3.08118 m
.02381 3.08743 L
.5 3.08743 L
.5 3.08118 L
F
0 .308 .75 r
.02381 3.08743 m
.02381 3.09368 L
.5 3.09368 L
.5 3.08743 L
F
0 .312 .75 r
.02381 3.09368 m
.02381 3.09993 L
.5 3.09993 L
.5 3.09368 L
F
0 .316 .75 r
.02381 3.09993 m
.02381 3.10617 L
.5 3.10617 L
.5 3.09993 L
F
0 .319 .75 r
.02381 3.10617 m
.02381 3.11242 L
.5 3.11242 L
.5 3.10617 L
F
0 .323 .75 r
.02381 3.11242 m
.02381 3.11867 L
.5 3.11867 L
.5 3.11242 L
F
0 .327 .75 r
.02381 3.11867 m
.02381 3.12492 L
.5 3.12492 L
.5 3.11867 L
F
0 .33 .75 r
.02381 3.12492 m
.02381 3.13117 L
.5 3.13117 L
.5 3.12492 L
F
0 .334 .75 r
.02381 3.13117 m
.02381 3.13742 L
.5 3.13742 L
.5 3.13117 L
F
0 .338 .75 r
.02381 3.13742 m
.02381 3.14367 L
.5 3.14367 L
.5 3.13742 L
F
0 .341 .75 r
.02381 3.14367 m
.02381 3.14992 L
.5 3.14992 L
.5 3.14367 L
F
0 .345 .75 r
.02381 3.14992 m
.02381 3.15617 L
.5 3.15617 L
.5 3.14992 L
F
0 .349 .75 r
.02381 3.15617 m
.02381 3.16242 L
.5 3.16242 L
.5 3.15617 L
F
0 .352 .75 r
.02381 3.16242 m
.02381 3.16867 L
.5 3.16867 L
.5 3.16242 L
F
0 .356 .75 r
.02381 3.16867 m
.02381 3.17492 L
.5 3.17492 L
.5 3.16867 L
F
0 .36 .75 r
.02381 3.17492 m
.02381 3.18116 L
.5 3.18116 L
.5 3.17492 L
F
0 .363 .75 r
.02381 3.18116 m
.02381 3.18741 L
.5 3.18741 L
.5 3.18116 L
F
0 .367 .75 r
.02381 3.18741 m
.02381 3.19366 L
.5 3.19366 L
.5 3.18741 L
F
0 .371 .75 r
.02381 3.19366 m
.02381 3.19991 L
.5 3.19991 L
.5 3.19366 L
F
0 .374 .75 r
.02381 3.19991 m
.02381 3.20616 L
.5 3.20616 L
.5 3.19991 L
F
0 .378 .75 r
.02381 3.20616 m
.02381 3.21241 L
.5 3.21241 L
.5 3.20616 L
F
0 .382 .75 r
.02381 3.21241 m
.02381 3.21866 L
.5 3.21866 L
.5 3.21241 L
F
0 .385 .75 r
.02381 3.21866 m
.02381 3.22491 L
.5 3.22491 L
.5 3.21866 L
F
0 .389 .75 r
.02381 3.22491 m
.02381 3.23116 L
.5 3.23116 L
.5 3.22491 L
F
0 .393 .75 r
.02381 3.23116 m
.02381 3.23741 L
.5 3.23741 L
.5 3.23116 L
F
0 .396 .75 r
.02381 3.23741 m
.02381 3.24366 L
.5 3.24366 L
.5 3.23741 L
F
0 .4 .75 r
.02381 3.24366 m
.02381 3.24991 L
.5 3.24991 L
.5 3.24366 L
F
0 .404 .75 r
.02381 3.24991 m
.02381 3.25616 L
.5 3.25616 L
.5 3.24991 L
F
0 .407 .75 r
.02381 3.25616 m
.02381 3.2624 L
.5 3.2624 L
.5 3.25616 L
F
0 .411 .75 r
.02381 3.2624 m
.02381 3.26865 L
.5 3.26865 L
.5 3.2624 L
F
0 .415 .75 r
.02381 3.26865 m
.02381 3.2749 L
.5 3.2749 L
.5 3.26865 L
F
0 .418 .75 r
.02381 3.2749 m
.02381 3.28115 L
.5 3.28115 L
.5 3.2749 L
F
0 .422 .75 r
.02381 3.28115 m
.02381 3.2874 L
.5 3.2874 L
.5 3.28115 L
F
0 .426 .75 r
.02381 3.2874 m
.02381 3.29365 L
.5 3.29365 L
.5 3.2874 L
F
0 .429 .75 r
.02381 3.29365 m
.02381 3.2999 L
.5 3.2999 L
.5 3.29365 L
F
0 .433 .75 r
.02381 3.2999 m
.02381 3.30615 L
.5 3.30615 L
.5 3.2999 L
F
0 .437 .75 r
.02381 3.30615 m
.02381 3.3124 L
.5 3.3124 L
.5 3.30615 L
F
0 .44 .75 r
.02381 3.3124 m
.02381 3.31865 L
.5 3.31865 L
.5 3.3124 L
F
0 .444 .75 r
.02381 3.31865 m
.02381 3.3249 L
.5 3.3249 L
.5 3.31865 L
F
0 .448 .75 r
.02381 3.3249 m
.02381 3.33115 L
.5 3.33115 L
.5 3.3249 L
F
0 .451 .75 r
.02381 3.33115 m
.02381 3.3374 L
.5 3.3374 L
.5 3.33115 L
F
0 .455 .75 r
.02381 3.3374 m
.02381 3.34364 L
.5 3.34364 L
.5 3.3374 L
F
0 .459 .75 r
.02381 3.34364 m
.02381 3.34989 L
.5 3.34989 L
.5 3.34364 L
F
0 .462 .75 r
.02381 3.34989 m
.02381 3.35614 L
.5 3.35614 L
.5 3.34989 L
F
0 .466 .75 r
.02381 3.35614 m
.02381 3.36239 L
.5 3.36239 L
.5 3.35614 L
F
0 .47 .75 r
.02381 3.36239 m
.02381 3.36864 L
.5 3.36864 L
.5 3.36239 L
F
0 .473 .75 r
.02381 3.36864 m
.02381 3.37489 L
.5 3.37489 L
.5 3.36864 L
F
0 .477 .75 r
.02381 3.37489 m
.02381 3.38114 L
.5 3.38114 L
.5 3.37489 L
F
0 .481 .75 r
.02381 3.38114 m
.02381 3.38739 L
.5 3.38739 L
.5 3.38114 L
F
0 .484 .75 r
.02381 3.38739 m
.02381 3.39364 L
.5 3.39364 L
.5 3.38739 L
F
0 .488 .75 r
.02381 3.39364 m
.02381 3.39989 L
.5 3.39989 L
.5 3.39364 L
F
0 .491 .75 r
.02381 3.39989 m
.02381 3.40614 L
.5 3.40614 L
.5 3.39989 L
F
0 .495 .75 r
.02381 3.40614 m
.02381 3.41239 L
.5 3.41239 L
.5 3.40614 L
F
0 .499 .75 r
.02381 3.41239 m
.02381 3.41864 L
.5 3.41864 L
.5 3.41239 L
F
0 .502 .75 r
.02381 3.41864 m
.02381 3.42488 L
.5 3.42488 L
.5 3.41864 L
F
0 .506 .75 r
.02381 3.42488 m
.02381 3.43113 L
.5 3.43113 L
.5 3.42488 L
F
0 .51 .75 r
.02381 3.43113 m
.02381 3.43738 L
.5 3.43738 L
.5 3.43113 L
F
0 .513 .75 r
.02381 3.43738 m
.02381 3.44363 L
.5 3.44363 L
.5 3.43738 L
F
0 .517 .75 r
.02381 3.44363 m
.02381 3.44988 L
.5 3.44988 L
.5 3.44363 L
F
0 .521 .75 r
.02381 3.44988 m
.02381 3.45613 L
.5 3.45613 L
.5 3.44988 L
F
0 .524 .75 r
.02381 3.45613 m
.02381 3.46238 L
.5 3.46238 L
.5 3.45613 L
F
0 .528 .75 r
.02381 3.46238 m
.02381 3.46863 L
.5 3.46863 L
.5 3.46238 L
F
0 .532 .75 r
.02381 3.46863 m
.02381 3.47488 L
.5 3.47488 L
.5 3.46863 L
F
0 .535 .75 r
.02381 3.47488 m
.02381 3.48113 L
.5 3.48113 L
.5 3.47488 L
F
0 .539 .75 r
.02381 3.48113 m
.02381 3.48738 L
.5 3.48738 L
.5 3.48113 L
F
0 .543 .75 r
.02381 3.48738 m
.02381 3.49363 L
.5 3.49363 L
.5 3.48738 L
F
0 .546 .75 r
.02381 3.49363 m
.02381 3.49988 L
.5 3.49988 L
.5 3.49363 L
F
0 .55 .75 r
.02381 3.49988 m
.02381 3.50612 L
.5 3.50612 L
.5 3.49988 L
F
0 .554 .75 r
.02381 3.50612 m
.02381 3.51237 L
.5 3.51237 L
.5 3.50612 L
F
0 .557 .75 r
.02381 3.51237 m
.02381 3.51862 L
.5 3.51862 L
.5 3.51237 L
F
0 .561 .75 r
.02381 3.51862 m
.02381 3.52487 L
.5 3.52487 L
.5 3.51862 L
F
0 .565 .75 r
.02381 3.52487 m
.02381 3.53112 L
.5 3.53112 L
.5 3.52487 L
F
0 .568 .75 r
.02381 3.53112 m
.02381 3.53737 L
.5 3.53737 L
.5 3.53112 L
F
0 .572 .75 r
.02381 3.53737 m
.02381 3.54362 L
.5 3.54362 L
.5 3.53737 L
F
0 .576 .75 r
.02381 3.54362 m
.02381 3.54987 L
.5 3.54987 L
.5 3.54362 L
F
0 .579 .75 r
.02381 3.54987 m
.02381 3.55612 L
.5 3.55612 L
.5 3.54987 L
F
0 .583 .75 r
.02381 3.55612 m
.02381 3.56237 L
.5 3.56237 L
.5 3.55612 L
F
0 .587 .75 r
.02381 3.56237 m
.02381 3.56862 L
.5 3.56862 L
.5 3.56237 L
F
0 .59 .75 r
.02381 3.56862 m
.02381 3.57487 L
.5 3.57487 L
.5 3.56862 L
F
0 .594 .75 r
.02381 3.57487 m
.02381 3.58111 L
.5 3.58111 L
.5 3.57487 L
F
0 .598 .75 r
.02381 3.58111 m
.02381 3.58736 L
.5 3.58736 L
.5 3.58111 L
F
0 .601 .75 r
.02381 3.58736 m
.02381 3.59361 L
.5 3.59361 L
.5 3.58736 L
F
0 .605 .75 r
.02381 3.59361 m
.02381 3.59986 L
.5 3.59986 L
.5 3.59361 L
F
0 .609 .75 r
.02381 3.59986 m
.02381 3.60611 L
.5 3.60611 L
.5 3.59986 L
F
0 .612 .75 r
.02381 3.60611 m
.02381 3.61236 L
.5 3.61236 L
.5 3.60611 L
F
0 .616 .75 r
.02381 3.61236 m
.02381 3.61861 L
.5 3.61861 L
.5 3.61236 L
F
0 .62 .75 r
.02381 3.61861 m
.02381 3.62486 L
.5 3.62486 L
.5 3.61861 L
F
0 .623 .75 r
.02381 3.62486 m
.02381 3.63111 L
.5 3.63111 L
.5 3.62486 L
F
0 .627 .75 r
.02381 3.63111 m
.02381 3.63736 L
.5 3.63736 L
.5 3.63111 L
F
0 .631 .75 r
.02381 3.63736 m
.02381 3.64361 L
.5 3.64361 L
.5 3.63736 L
F
0 .634 .75 r
.02381 3.64361 m
.02381 3.64986 L
.5 3.64986 L
.5 3.64361 L
F
0 .638 .75 r
.02381 3.64986 m
.02381 3.65611 L
.5 3.65611 L
.5 3.64986 L
F
0 .642 .75 r
.02381 3.65611 m
.02381 3.66235 L
.5 3.66235 L
.5 3.65611 L
F
0 .645 .75 r
.02381 3.66235 m
.02381 3.6686 L
.5 3.6686 L
.5 3.66235 L
F
0 .649 .75 r
.02381 3.6686 m
.02381 3.67485 L
.5 3.67485 L
.5 3.6686 L
F
0 .653 .75 r
.02381 3.67485 m
.02381 3.6811 L
.5 3.6811 L
.5 3.67485 L
F
0 .656 .75 r
.02381 3.6811 m
.02381 3.68735 L
.5 3.68735 L
.5 3.6811 L
F
0 .66 .75 r
.02381 3.68735 m
.02381 3.6936 L
.5 3.6936 L
.5 3.68735 L
F
0 .664 .75 r
.02381 3.6936 m
.02381 3.69985 L
.5 3.69985 L
.5 3.6936 L
F
0 .667 .75 r
.02381 3.69985 m
.02381 3.7061 L
.5 3.7061 L
.5 3.69985 L
F
0 .671 .75 r
.02381 3.7061 m
.02381 3.71235 L
.5 3.71235 L
.5 3.7061 L
F
0 .675 .75 r
.02381 3.71235 m
.02381 3.7186 L
.5 3.7186 L
.5 3.71235 L
F
0 .678 .75 r
.02381 3.7186 m
.02381 3.72485 L
.5 3.72485 L
.5 3.7186 L
F
0 .682 .75 r
.02381 3.72485 m
.02381 3.7311 L
.5 3.7311 L
.5 3.72485 L
F
0 .686 .75 r
.02381 3.7311 m
.02381 3.73735 L
.5 3.73735 L
.5 3.7311 L
F
0 .689 .75 r
.02381 3.73735 m
.02381 3.74359 L
.5 3.74359 L
.5 3.73735 L
F
0 .693 .75 r
.02381 3.74359 m
.02381 3.74984 L
.5 3.74984 L
.5 3.74359 L
F
0 .696 .75 r
.02381 3.74984 m
.02381 3.75609 L
.5 3.75609 L
.5 3.74984 L
F
0 .7 .75 r
.02381 3.75609 m
.02381 3.76234 L
.5 3.76234 L
.5 3.75609 L
F
0 .704 .75 r
.02381 3.76234 m
.02381 3.76859 L
.5 3.76859 L
.5 3.76234 L
F
0 .707 .75 r
.02381 3.76859 m
.02381 3.77484 L
.5 3.77484 L
.5 3.76859 L
F
0 .711 .75 r
.02381 3.77484 m
.02381 3.78109 L
.5 3.78109 L
.5 3.77484 L
F
0 .715 .75 r
.02381 3.78109 m
.02381 3.78734 L
.5 3.78734 L
.5 3.78109 L
F
0 .718 .75 r
.02381 3.78734 m
.02381 3.79359 L
.5 3.79359 L
.5 3.78734 L
F
0 .722 .75 r
.02381 3.79359 m
.02381 3.79984 L
.5 3.79984 L
.5 3.79359 L
F
0 .726 .75 r
.02381 3.79984 m
.02381 3.80609 L
.5 3.80609 L
.5 3.79984 L
F
0 .729 .75 r
.02381 3.80609 m
.02381 3.81234 L
.5 3.81234 L
.5 3.80609 L
F
0 .733 .75 r
.02381 3.81234 m
.02381 3.81859 L
.5 3.81859 L
.5 3.81234 L
F
0 .737 .75 r
.02381 3.81859 m
.02381 3.82483 L
.5 3.82483 L
.5 3.81859 L
F
0 .74 .75 r
.02381 3.82483 m
.02381 3.83108 L
.5 3.83108 L
.5 3.82483 L
F
0 .744 .75 r
.02381 3.83108 m
.02381 3.83733 L
.5 3.83733 L
.5 3.83108 L
F
0 .748 .75 r
.02381 3.83733 m
.02381 3.84358 L
.5 3.84358 L
.5 3.83733 L
F
0 .75 .749 r
.02381 3.84358 m
.02381 3.84983 L
.5 3.84983 L
.5 3.84358 L
F
0 .75 .745 r
.02381 3.84983 m
.02381 3.85608 L
.5 3.85608 L
.5 3.84983 L
F
0 .75 .741 r
.02381 3.85608 m
.02381 3.86233 L
.5 3.86233 L
.5 3.85608 L
F
0 .75 .738 r
.02381 3.86233 m
.02381 3.86858 L
.5 3.86858 L
.5 3.86233 L
F
0 .75 .734 r
.02381 3.86858 m
.02381 3.87483 L
.5 3.87483 L
.5 3.86858 L
F
0 .75 .73 r
.02381 3.87483 m
.02381 3.88108 L
.5 3.88108 L
.5 3.87483 L
F
0 .75 .727 r
.02381 3.88108 m
.02381 3.88733 L
.5 3.88733 L
.5 3.88108 L
F
0 .75 .723 r
.02381 3.88733 m
.02381 3.89358 L
.5 3.89358 L
.5 3.88733 L
F
0 .75 .719 r
.02381 3.89358 m
.02381 3.89983 L
.5 3.89983 L
.5 3.89358 L
F
0 .75 .716 r
.02381 3.89983 m
.02381 3.90607 L
.5 3.90607 L
.5 3.89983 L
F
0 .75 .712 r
.02381 3.90607 m
.02381 3.91232 L
.5 3.91232 L
.5 3.90607 L
F
0 .75 .708 r
.02381 3.91232 m
.02381 3.91857 L
.5 3.91857 L
.5 3.91232 L
F
0 .75 .705 r
.02381 3.91857 m
.02381 3.92482 L
.5 3.92482 L
.5 3.91857 L
F
0 .75 .701 r
.02381 3.92482 m
.02381 3.93107 L
.5 3.93107 L
.5 3.92482 L
F
0 .75 .697 r
.02381 3.93107 m
.02381 3.93732 L
.5 3.93732 L
.5 3.93107 L
F
0 .75 .694 r
.02381 3.93732 m
.02381 3.94357 L
.5 3.94357 L
.5 3.93732 L
F
0 .75 .69 r
.02381 3.94357 m
.02381 3.94982 L
.5 3.94982 L
.5 3.94357 L
F
0 .75 .686 r
.02381 3.94982 m
.02381 3.95607 L
.5 3.95607 L
.5 3.94982 L
F
0 .75 .683 r
.02381 3.95607 m
.02381 3.96232 L
.5 3.96232 L
.5 3.95607 L
F
0 .75 .679 r
.02381 3.96232 m
.02381 3.96857 L
.5 3.96857 L
.5 3.96232 L
F
0 .75 .675 r
.02381 3.96857 m
.02381 3.97482 L
.5 3.97482 L
.5 3.96857 L
F
0 .75 .672 r
.02381 3.97482 m
.02381 3.98106 L
.5 3.98106 L
.5 3.97482 L
F
0 .75 .668 r
.02381 3.98106 m
.02381 3.98731 L
.5 3.98731 L
.5 3.98106 L
F
0 .75 .664 r
.02381 3.98731 m
.02381 3.99356 L
.5 3.99356 L
.5 3.98731 L
F
0 .75 .661 r
.02381 3.99356 m
.02381 3.99981 L
.5 3.99981 L
.5 3.99356 L
F
0 .75 .657 r
.02381 3.99981 m
.02381 4.00606 L
.5 4.00606 L
.5 3.99981 L
F
0 .75 .653 r
.02381 4.00606 m
.02381 4.01231 L
.5 4.01231 L
.5 4.00606 L
F
0 .75 .65 r
.02381 4.01231 m
.02381 4.01856 L
.5 4.01856 L
.5 4.01231 L
F
0 .75 .646 r
.02381 4.01856 m
.02381 4.02481 L
.5 4.02481 L
.5 4.01856 L
F
0 .75 .642 r
.02381 4.02481 m
.02381 4.03106 L
.5 4.03106 L
.5 4.02481 L
F
0 .75 .639 r
.02381 4.03106 m
.02381 4.03731 L
.5 4.03731 L
.5 4.03106 L
F
0 .75 .635 r
.02381 4.03731 m
.02381 4.04356 L
.5 4.04356 L
.5 4.03731 L
F
0 .75 .631 r
.02381 4.04356 m
.02381 4.04981 L
.5 4.04981 L
.5 4.04356 L
F
0 .75 .628 r
.02381 4.04981 m
.02381 4.05606 L
.5 4.05606 L
.5 4.04981 L
F
0 .75 .624 r
.02381 4.05606 m
.02381 4.0623 L
.5 4.0623 L
.5 4.05606 L
F
0 .75 .62 r
.02381 4.0623 m
.02381 4.06855 L
.5 4.06855 L
.5 4.0623 L
F
0 .75 .617 r
.02381 4.06855 m
.02381 4.0748 L
.5 4.0748 L
.5 4.06855 L
F
0 .75 .613 r
.02381 4.0748 m
.02381 4.08105 L
.5 4.08105 L
.5 4.0748 L
F
0 .75 .609 r
.02381 4.08105 m
.02381 4.0873 L
.5 4.0873 L
.5 4.08105 L
F
0 .75 .606 r
.02381 4.0873 m
.02381 4.09355 L
.5 4.09355 L
.5 4.0873 L
F
0 .75 .602 r
.02381 4.09355 m
.02381 4.0998 L
.5 4.0998 L
.5 4.09355 L
F
0 .75 .598 r
.02381 4.0998 m
.02381 4.10605 L
.5 4.10605 L
.5 4.0998 L
F
0 .75 .595 r
.02381 4.10605 m
.02381 4.1123 L
.5 4.1123 L
.5 4.10605 L
F
0 .75 .591 r
.02381 4.1123 m
.02381 4.11855 L
.5 4.11855 L
.5 4.1123 L
F
0 .75 .588 r
.02381 4.11855 m
.02381 4.1248 L
.5 4.1248 L
.5 4.11855 L
F
0 .75 .584 r
.02381 4.1248 m
.02381 4.13105 L
.5 4.13105 L
.5 4.1248 L
F
0 .75 .58 r
.02381 4.13105 m
.02381 4.1373 L
.5 4.1373 L
.5 4.13105 L
F
0 .75 .577 r
.02381 4.1373 m
.02381 4.14354 L
.5 4.14354 L
.5 4.1373 L
F
0 .75 .573 r
.02381 4.14354 m
.02381 4.14979 L
.5 4.14979 L
.5 4.14354 L
F
0 .75 .569 r
.02381 4.14979 m
.02381 4.15604 L
.5 4.15604 L
.5 4.14979 L
F
0 .75 .566 r
.02381 4.15604 m
.02381 4.16229 L
.5 4.16229 L
.5 4.15604 L
F
0 .75 .562 r
.02381 4.16229 m
.02381 4.16854 L
.5 4.16854 L
.5 4.16229 L
F
0 .75 .558 r
.02381 4.16854 m
.02381 4.17479 L
.5 4.17479 L
.5 4.16854 L
F
0 .75 .555 r
.02381 4.17479 m
.02381 4.18104 L
.5 4.18104 L
.5 4.17479 L
F
0 .75 .551 r
.02381 4.18104 m
.02381 4.18729 L
.5 4.18729 L
.5 4.18104 L
F
0 .75 .547 r
.02381 4.18729 m
.02381 4.19354 L
.5 4.19354 L
.5 4.18729 L
F
0 .75 .544 r
.02381 4.19354 m
.02381 4.19979 L
.5 4.19979 L
.5 4.19354 L
F
0 .75 .54 r
.02381 4.19979 m
.02381 4.20604 L
.5 4.20604 L
.5 4.19979 L
F
0 .75 .536 r
.02381 4.20604 m
.02381 4.21229 L
.5 4.21229 L
.5 4.20604 L
F
0 .75 .533 r
.02381 4.21229 m
.02381 4.21854 L
.5 4.21854 L
.5 4.21229 L
F
0 .75 .529 r
.02381 4.21854 m
.02381 4.22478 L
.5 4.22478 L
.5 4.21854 L
F
0 .75 .525 r
.02381 4.22478 m
.02381 4.23103 L
.5 4.23103 L
.5 4.22478 L
F
0 .75 .522 r
.02381 4.23103 m
.02381 4.23728 L
.5 4.23728 L
.5 4.23103 L
F
0 .75 .518 r
.02381 4.23728 m
.02381 4.24353 L
.5 4.24353 L
.5 4.23728 L
F
0 .75 .514 r
.02381 4.24353 m
.02381 4.24978 L
.5 4.24978 L
.5 4.24353 L
F
0 .75 .511 r
.02381 4.24978 m
.02381 4.25603 L
.5 4.25603 L
.5 4.24978 L
F
0 .75 .507 r
.02381 4.25603 m
.02381 4.26228 L
.5 4.26228 L
.5 4.25603 L
F
0 .75 .503 r
.02381 4.26228 m
.02381 4.26853 L
.5 4.26853 L
.5 4.26228 L
F
0 .75 .5 r
.02381 4.26853 m
.02381 4.27478 L
.5 4.27478 L
.5 4.26853 L
F
0 .75 .496 r
.02381 4.27478 m
.02381 4.28103 L
.5 4.28103 L
.5 4.27478 L
F
0 .75 .492 r
.02381 4.28103 m
.02381 4.28728 L
.5 4.28728 L
.5 4.28103 L
F
0 .75 .489 r
.02381 4.28728 m
.02381 4.29353 L
.5 4.29353 L
.5 4.28728 L
F
0 .75 .485 r
.02381 4.29353 m
.02381 4.29978 L
.5 4.29978 L
.5 4.29353 L
F
0 .75 .481 r
.02381 4.29978 m
.02381 4.30602 L
.5 4.30602 L
.5 4.29978 L
F
0 .75 .478 r
.02381 4.30602 m
.02381 4.31227 L
.5 4.31227 L
.5 4.30602 L
F
0 .75 .474 r
.02381 4.31227 m
.02381 4.31852 L
.5 4.31852 L
.5 4.31227 L
F
0 .75 .47 r
.02381 4.31852 m
.02381 4.32477 L
.5 4.32477 L
.5 4.31852 L
F
0 .75 .467 r
.02381 4.32477 m
.02381 4.33102 L
.5 4.33102 L
.5 4.32477 L
F
0 .75 .463 r
.02381 4.33102 m
.02381 4.33727 L
.5 4.33727 L
.5 4.33102 L
F
0 .75 .459 r
.02381 4.33727 m
.02381 4.34352 L
.5 4.34352 L
.5 4.33727 L
F
0 .75 .456 r
.02381 4.34352 m
.02381 4.34977 L
.5 4.34977 L
.5 4.34352 L
F
0 .75 .452 r
.02381 4.34977 m
.02381 4.35602 L
.5 4.35602 L
.5 4.34977 L
F
0 .75 .448 r
.02381 4.35602 m
.02381 4.36227 L
.5 4.36227 L
.5 4.35602 L
F
0 .75 .445 r
.02381 4.36227 m
.02381 4.36852 L
.5 4.36852 L
.5 4.36227 L
F
0 .75 .441 r
.02381 4.36852 m
.02381 4.37477 L
.5 4.37477 L
.5 4.36852 L
F
0 .75 .437 r
.02381 4.37477 m
.02381 4.38101 L
.5 4.38101 L
.5 4.37477 L
F
0 .75 .434 r
.02381 4.38101 m
.02381 4.38726 L
.5 4.38726 L
.5 4.38101 L
F
0 .75 .43 r
.02381 4.38726 m
.02381 4.39351 L
.5 4.39351 L
.5 4.38726 L
F
0 .75 .426 r
.02381 4.39351 m
.02381 4.39976 L
.5 4.39976 L
.5 4.39351 L
F
0 .75 .423 r
.02381 4.39976 m
.02381 4.40601 L
.5 4.40601 L
.5 4.39976 L
F
0 .75 .419 r
.02381 4.40601 m
.02381 4.41226 L
.5 4.41226 L
.5 4.40601 L
F
0 .75 .415 r
.02381 4.41226 m
.02381 4.41851 L
.5 4.41851 L
.5 4.41226 L
F
0 .75 .412 r
.02381 4.41851 m
.02381 4.42476 L
.5 4.42476 L
.5 4.41851 L
F
0 .75 .408 r
.02381 4.42476 m
.02381 4.43101 L
.5 4.43101 L
.5 4.42476 L
F
0 .75 .404 r
.02381 4.43101 m
.02381 4.43726 L
.5 4.43726 L
.5 4.43101 L
F
0 .75 .401 r
.02381 4.43726 m
.02381 4.44351 L
.5 4.44351 L
.5 4.43726 L
F
0 .75 .397 r
.02381 4.44351 m
.02381 4.44976 L
.5 4.44976 L
.5 4.44351 L
F
0 .75 .393 r
.02381 4.44976 m
.02381 4.45601 L
.5 4.45601 L
.5 4.44976 L
F
0 .75 .39 r
.02381 4.45601 m
.02381 4.46225 L
.5 4.46225 L
.5 4.45601 L
F
0 .75 .386 r
.02381 4.46225 m
.02381 4.4685 L
.5 4.4685 L
.5 4.46225 L
F
0 .75 .383 r
.02381 4.4685 m
.02381 4.47475 L
.5 4.47475 L
.5 4.4685 L
F
0 .75 .379 r
.02381 4.47475 m
.02381 4.481 L
.5 4.481 L
.5 4.47475 L
F
0 .75 .375 r
.02381 4.481 m
.02381 4.48725 L
.5 4.48725 L
.5 4.481 L
F
0 .75 .372 r
.02381 4.48725 m
.02381 4.4935 L
.5 4.4935 L
.5 4.48725 L
F
0 .75 .368 r
.02381 4.4935 m
.02381 4.49975 L
.5 4.49975 L
.5 4.4935 L
F
0 .75 .364 r
.02381 4.49975 m
.02381 4.506 L
.5 4.506 L
.5 4.49975 L
F
0 .75 .361 r
.02381 4.506 m
.02381 4.51225 L
.5 4.51225 L
.5 4.506 L
F
0 .75 .357 r
.02381 4.51225 m
.02381 4.5185 L
.5 4.5185 L
.5 4.51225 L
F
0 .75 .353 r
.02381 4.5185 m
.02381 4.52475 L
.5 4.52475 L
.5 4.5185 L
F
0 .75 .35 r
.02381 4.52475 m
.02381 4.531 L
.5 4.531 L
.5 4.52475 L
F
0 .75 .346 r
.02381 4.531 m
.02381 4.53725 L
.5 4.53725 L
.5 4.531 L
F
0 .75 .342 r
.02381 4.53725 m
.02381 4.54349 L
.5 4.54349 L
.5 4.53725 L
F
0 .75 .339 r
.02381 4.54349 m
.02381 4.54974 L
.5 4.54974 L
.5 4.54349 L
F
0 .75 .335 r
.02381 4.54974 m
.02381 4.55599 L
.5 4.55599 L
.5 4.54974 L
F
0 .75 .331 r
.02381 4.55599 m
.02381 4.56224 L
.5 4.56224 L
.5 4.55599 L
F
0 .75 .328 r
.02381 4.56224 m
.02381 4.56849 L
.5 4.56849 L
.5 4.56224 L
F
0 .75 .324 r
.02381 4.56849 m
.02381 4.57474 L
.5 4.57474 L
.5 4.56849 L
F
0 .75 .32 r
.02381 4.57474 m
.02381 4.58099 L
.5 4.58099 L
.5 4.57474 L
F
0 .75 .317 r
.02381 4.58099 m
.02381 4.58724 L
.5 4.58724 L
.5 4.58099 L
F
0 .75 .313 r
.02381 4.58724 m
.02381 4.59349 L
.5 4.59349 L
.5 4.58724 L
F
0 .75 .309 r
.02381 4.59349 m
.02381 4.59974 L
.5 4.59974 L
.5 4.59349 L
F
0 .75 .306 r
.02381 4.59974 m
.02381 4.60599 L
.5 4.60599 L
.5 4.59974 L
F
0 .75 .302 r
.02381 4.60599 m
.02381 4.61224 L
.5 4.61224 L
.5 4.60599 L
F
0 .75 .298 r
.02381 4.61224 m
.02381 4.61849 L
.5 4.61849 L
.5 4.61224 L
F
0 .75 .295 r
.02381 4.61849 m
.02381 4.62473 L
.5 4.62473 L
.5 4.61849 L
F
0 .75 .291 r
.02381 4.62473 m
.02381 4.63098 L
.5 4.63098 L
.5 4.62473 L
F
0 .75 .287 r
.02381 4.63098 m
.02381 4.63723 L
.5 4.63723 L
.5 4.63098 L
F
0 .75 .284 r
.02381 4.63723 m
.02381 4.64348 L
.5 4.64348 L
.5 4.63723 L
F
0 .75 .28 r
.02381 4.64348 m
.02381 4.64973 L
.5 4.64973 L
.5 4.64348 L
F
0 .75 .276 r
.02381 4.64973 m
.02381 4.65598 L
.5 4.65598 L
.5 4.64973 L
F
0 .75 .273 r
.02381 4.65598 m
.02381 4.66223 L
.5 4.66223 L
.5 4.65598 L
F
0 .75 .269 r
.02381 4.66223 m
.02381 4.66848 L
.5 4.66848 L
.5 4.66223 L
F
0 .75 .265 r
.02381 4.66848 m
.02381 4.67473 L
.5 4.67473 L
.5 4.66848 L
F
0 .75 .262 r
.02381 4.67473 m
.02381 4.68098 L
.5 4.68098 L
.5 4.67473 L
F
0 .75 .258 r
.02381 4.68098 m
.02381 4.68723 L
.5 4.68723 L
.5 4.68098 L
F
0 .75 .254 r
.02381 4.68723 m
.02381 4.69348 L
.5 4.69348 L
.5 4.68723 L
F
0 .75 .251 r
.02381 4.69348 m
.02381 4.69973 L
.5 4.69973 L
.5 4.69348 L
F
0 .75 .247 r
.02381 4.69973 m
.02381 4.70597 L
.5 4.70597 L
.5 4.69973 L
F
0 .75 .243 r
.02381 4.70597 m
.02381 4.71222 L
.5 4.71222 L
.5 4.70597 L
F
0 .75 .24 r
.02381 4.71222 m
.02381 4.71847 L
.5 4.71847 L
.5 4.71222 L
F
0 .75 .236 r
.02381 4.71847 m
.02381 4.72472 L
.5 4.72472 L
.5 4.71847 L
F
0 .75 .232 r
.02381 4.72472 m
.02381 4.73097 L
.5 4.73097 L
.5 4.72472 L
F
0 .75 .229 r
.02381 4.73097 m
.02381 4.73722 L
.5 4.73722 L
.5 4.73097 L
F
0 .75 .225 r
.02381 4.73722 m
.02381 4.74347 L
.5 4.74347 L
.5 4.73722 L
F
0 .75 .221 r
.02381 4.74347 m
.02381 4.74972 L
.5 4.74972 L
.5 4.74347 L
F
0 .75 .218 r
.02381 4.74972 m
.02381 4.75597 L
.5 4.75597 L
.5 4.74972 L
F
0 .75 .214 r
.02381 4.75597 m
.02381 4.76222 L
.5 4.76222 L
.5 4.75597 L
F
0 .75 .21 r
.02381 4.76222 m
.02381 4.76847 L
.5 4.76847 L
.5 4.76222 L
F
0 .75 .207 r
.02381 4.76847 m
.02381 4.77472 L
.5 4.77472 L
.5 4.76847 L
F
0 .75 .203 r
.02381 4.77472 m
.02381 4.78096 L
.5 4.78096 L
.5 4.77472 L
F
0 .75 .199 r
.02381 4.78096 m
.02381 4.78721 L
.5 4.78721 L
.5 4.78096 L
F
0 .75 .196 r
.02381 4.78721 m
.02381 4.79346 L
.5 4.79346 L
.5 4.78721 L
F
0 .75 .192 r
.02381 4.79346 m
.02381 4.79971 L
.5 4.79971 L
.5 4.79346 L
F
0 .75 .188 r
.02381 4.79971 m
.02381 4.80596 L
.5 4.80596 L
.5 4.79971 L
F
0 .75 .185 r
.02381 4.80596 m
.02381 4.81221 L
.5 4.81221 L
.5 4.80596 L
F
0 .75 .181 r
.02381 4.81221 m
.02381 4.81846 L
.5 4.81846 L
.5 4.81221 L
F
0 .75 .178 r
.02381 4.81846 m
.02381 4.82471 L
.5 4.82471 L
.5 4.81846 L
F
0 .75 .174 r
.02381 4.82471 m
.02381 4.83096 L
.5 4.83096 L
.5 4.82471 L
F
0 .75 .17 r
.02381 4.83096 m
.02381 4.83721 L
.5 4.83721 L
.5 4.83096 L
F
0 .75 .167 r
.02381 4.83721 m
.02381 4.84346 L
.5 4.84346 L
.5 4.83721 L
F
0 .75 .163 r
.02381 4.84346 m
.02381 4.84971 L
.5 4.84971 L
.5 4.84346 L
F
0 .75 .159 r
.02381 4.84971 m
.02381 4.85596 L
.5 4.85596 L
.5 4.84971 L
F
0 .75 .156 r
.02381 4.85596 m
.02381 4.8622 L
.5 4.8622 L
.5 4.85596 L
F
0 .75 .152 r
.02381 4.8622 m
.02381 4.86845 L
.5 4.86845 L
.5 4.8622 L
F
0 .75 .148 r
.02381 4.86845 m
.02381 4.8747 L
.5 4.8747 L
.5 4.86845 L
F
0 .75 .145 r
.02381 4.8747 m
.02381 4.88095 L
.5 4.88095 L
.5 4.8747 L
F
0 .75 .141 r
.02381 4.88095 m
.02381 4.8872 L
.5 4.8872 L
.5 4.88095 L
F
0 .75 .137 r
.02381 4.8872 m
.02381 4.89345 L
.5 4.89345 L
.5 4.8872 L
F
0 .75 .134 r
.02381 4.89345 m
.02381 4.8997 L
.5 4.8997 L
.5 4.89345 L
F
0 .75 .13 r
.02381 4.8997 m
.02381 4.90595 L
.5 4.90595 L
.5 4.8997 L
F
0 .75 .126 r
.02381 4.90595 m
.02381 4.9122 L
.5 4.9122 L
.5 4.90595 L
F
0 .75 .123 r
.02381 4.9122 m
.02381 4.91845 L
.5 4.91845 L
.5 4.9122 L
F
0 .75 .119 r
.02381 4.91845 m
.02381 4.9247 L
.5 4.9247 L
.5 4.91845 L
F
0 .75 .115 r
.02381 4.9247 m
.02381 4.93095 L
.5 4.93095 L
.5 4.9247 L
F
0 .75 .112 r
.02381 4.93095 m
.02381 4.9372 L
.5 4.9372 L
.5 4.93095 L
F
0 .75 .108 r
.02381 4.9372 m
.02381 4.94344 L
.5 4.94344 L
.5 4.9372 L
F
0 .75 .104 r
.02381 4.94344 m
.02381 4.94969 L
.5 4.94969 L
.5 4.94344 L
F
0 .75 .101 r
.02381 4.94969 m
.02381 4.95594 L
.5 4.95594 L
.5 4.94969 L
F
0 .75 .097 r
.02381 4.95594 m
.02381 4.96219 L
.5 4.96219 L
.5 4.95594 L
F
0 .75 .093 r
.02381 4.96219 m
.02381 4.96844 L
.5 4.96844 L
.5 4.96219 L
F
0 .75 .09 r
.02381 4.96844 m
.02381 4.97469 L
.5 4.97469 L
.5 4.96844 L
F
0 .75 .086 r
.02381 4.97469 m
.02381 4.98094 L
.5 4.98094 L
.5 4.97469 L
F
0 .75 .082 r
.02381 4.98094 m
.02381 4.98719 L
.5 4.98719 L
.5 4.98094 L
F
0 .75 .079 r
.02381 4.98719 m
.02381 4.99344 L
.5 4.99344 L
.5 4.98719 L
F
0 .75 .075 r
.02381 4.99344 m
.02381 4.99969 L
.5 4.99969 L
.5 4.99344 L
F
0 g
gsave
.52381 4.99656 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(4.) show
75.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 1.4104 L
0 1.4104 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[115]:=",
  ImageSize->{204.188, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003<000181000`40O003h00Oc7oo003<Ool00<ao
o`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<ao
o`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<ao
o`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<ao
o`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<ao
o`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<ao
o`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<Uo
o`<00000`Woo100017oo0@000Goo002iOol7G008Ool400000;Uoo`ML0@Qoo`03001oo`00005oo`00
^Goo1e`32Goo0P000Goo002iOol7G0@:Ool10001Ool00;Uoo`ML1@aoo`00^Goo1e`737oo002iOol7
G0P<Ool00;Uoo`ML2@aoo`00^Goo1e`;37oo002iOol7G0`<Ool005Uoo`8000=oo`8000=oo`8005Ao
o`ML3Paoo`00FGoo00<007ooOol017oo00D007ooOomoo`0005Aoo`ML3`aoo`00BWoo0`0000Aoo`00
Oomoo`8000Ioo`03001oogoo009oo`<000=oo`03001oogoo059oo`ML40aoo`00Bgoo00H007ooOol0
07oo0008Ool01@00Oomoogoo00000Woo00D007ooOomoo`0005Aoo`ML4Paoo`00Bgoo0`000Woo0`00
1Woo00D007ooOomoo`00009oo`05001oogooOol0001DOol7G1<<Ool004]oo`05001oogoo001oo`03
0006Ool00`00Oomoo`02Ool30003Ool00`00Oomoo`1BOol7G1@<Ool004]oo`04001oogoo000:Ool0
0`00Oomoo`08Ool00`00Oomoo`1BOol7G1H<Ool004Yoo`@000]oo`8000Qoo`8005Aoo`ML5`aoo`00
^Goo1e@G37oo002iOol7D1L<Ool00;Uoo`M<5`aoo`00Agoo0P000goo0`000Woo1P000Woo1@0000Ao
o`00000000=oo`8000Aoo`<004]oo`M45`aoo`00BGoo00@007ooOol000Ioo`05001oo`00Ool00003
Ool01@00Oomoogoo00001goo00<007ooOol00Woo00<007ooOol0BWoo1d0G37oo0012Ool30002Ool3
0003Ool30003Ool01@00Ool007oo00000goo00<007ooOol00Woo00<007ooOol00goo00@007ooOomo
o`@004]oo`Ll5`aoo`00BGoo00D007ooOomoo`0000Eoo`05001oo`00Ool00003Ool00`00Oomoo`02
Ool00`00Oomoo`04Ool01P00Oomoo`00Ool004aoo`Ld5`aoo`00Agoo00<007oo00000Woo00<007oo
000017oo00D007oo001oo`0000=oo`07001oogooOol007oo00000goo00<007oo00000goo0P00C7oo
1c0G37oo0018Ool00`00Oomoo`02Ool00`00Oomoo`02Ool20002Ool01000Oomoogoo0P0017oo00<0
07ooOol00goo00<007ooOol00goo00<007ooOol0BWoo1bPG37oo002iOol791L<Ool00;Uoo`LP5`ao
o`00AGoo00<005kgG_L01`000Ukg1@0000=Nm`0000000`000Ukg1`000Ukg1@000UkgBgoo1aPG37oo
0015Ool00ekgOomNm`05Ool3G_L6Ool00ekgOomoo`04Ool3G_L5Ool00ekgOomNm`05Ool00`00Oomo
o`19Ool751L<Ool004Eoo`04001oogooG_L2Ool2G_L2Ool00ekgOomoo`020?L70=L00`2gOomNm`02
Ool2G_L2Ool01EkgOomoogooG_L00goo0P00Bgoo1a0G37oo0011Ool3000017oo001oogoo0ekg1Goo
0P3g17oo00=NmgooOol00goo0`2g0goo0ekg17oo00ENmgooOomoo`0004]oo`L85`aoo`00@Woo00@0
07ooOol0009oo`9Nm`Aoo`80m`eNm`9oo`040;L0UgooOol2G_L5Ool015kgOomooekgBgoo1`@G37oo
000kOol30002Ool400001Woo001ooekgOomNm`=oo`815`9Nm`Eoo`03G_Moogoo00=oo`=Nm`07Ool0
U`2GOomNmgooG_L01Goo0Ukg00<007ooOol0BGoo1`0G37oo0010Ool00`00Ool00002Ool00`00G_Mo
o`02Ool015kgOol15`4G0Woo00=NmgooOol00goo00=NmgooOol00goo00=NmgooOol00Ukg0P2G0goo
00=NmgooOol00Woo0Ukg00<007ooOol0BGoo1`0G37oo0011Ool20002Ool00ekgOomoo`02Ool00ekg
0AMoo`04Ool00ekgOomoo`02Ool00ekgOomoo`02Ool00ekgOomoo`03Ool00ekg09L0U`03Ool01ekg
OomoogooG_Mooekg04]oo`L0=`aoo`00@Woo00@007ooOol000Aoo`030AMNmgoo00Aoo`03G_Moogoo
009oo`03G_Moogoo009oo`03G_Moogoo00=oo`9Nm`03Ool0Ugoo009oo`03G_Mooekg009oo`03001o
ogoo04Uoo`L0M`aoo`00AGoo00@007ooOomoo`815`03G_Moogoo00=oo`]Nm`Eoo`03G_Mooekg0080
M`9oo`9Nm`9oo`8004]oo`L0U`aoo`00AGoo00D007ooOomNm`4g009oo`04G_MoogooOol2G_L4Ool0
0ekgOomoo`02Ool2G_L3Ool01EkgOomoogooG_L00P1g00=ooekgG_L00goo00<007ooOol0BGoo1`3G
37oo0015Ool015kgOomNm`4g0goo00INmgooG_MNmgooG_L4Ool00ekgOomoo`02Ool01UkgOomNmekg
OomNm`Aoo`03G_L0Mekg009oo`04G_Moogoo001;Ool70?L<Ool004Eoo`04001Nmekg0CL3Ool2G_L4
Ool01EkgOomoogooG_L00goo00=NmgooOol00Woo0Ukg1Goo00INm`1gOomooekgOol2001;Ool70AL<
Ool004Eoo`03001Nm`4g00=oo`03G_Mooekg00Aoo`03G_Moogoo00=Nm`9oo`03G_Moogoo009oo`03
G_Mooekg00Aoo`03G_L0Egoo009oo`03G_Moo`0004]oo`L1E`aoo`00AGoo00=Nmgoo0CL00Woo00EN
mgooOomooekg009oo`ANm`03OomNmgoo00ANm`9oo`05G_MoogooOomNm`02Ool015kgOol0E`1G0goo
00=Nm`00Ool0BWoo1`5g37oo0015Ool00`00Ool1=`02G_L4Ool01EkgOomNmgooG_L00goo00UNmgoo
OomooekgOomNmgooG_L017oo0Ukg0goo00H0EgooOomoo`00G_M;Ool70KL<Ool004Eoo`030001Egoo
009Nm`Aoo`9Nm`=oo`04G_MoogooG_L2Ool015kgOomoogoo0Ukg17oo0Ukg0goo0P1G0goo00=Nmgoo
Ool0BGoo1`7G37oo0010Ool30002Ool00`000EMNm`02Ool01UkgOomooekgOomNm`=oo`04G_Moogoo
G_L2Ool01ekgOomoogooG_Mooekg009oo`04G_MoogooG_L3Ool01@1GOomNmekg0000Bgoo1`7g37oo
0010Ool00`00Oomoo`02Ool00`000EMNm`03Ool2G_L2Ool015kgOomoogoo1ekg0goo00=NmgooOol0
0Ukg0goo00INmgooOomoo`0gG_L2Ool00`00Oomoo`19Ool70SL<Ool003]oo`<000=oo`06001oogoo
Ool0005G17oo00=NmgooOol00Woo15kg0Woo00=NmgooOol015kg17oo00=NmgooOol00Woo00INmgoo
G_MNm`0gOol2001;Ool70UL<Ool0045oo`06001oogooOomNm`5G0goo00=NmgooG_L00goo00ANmgoo
OomNm`9oo`04G_MoogooG_L2Ool01ekgOomoogooG_Mooekg00=oo`9Nm`9oo`0403Moogoo001;Ool7
0WL<Ool0041oo`03001oo`00009oo`03G_L1Eekg009oo`08G_MoogooG_MooekgOomNm`9oo`05G_Mo
oekgOomNm`02Ool01EkgOomNmgooG_L00Woo00ANmgooOomoo`9Nm`9oo`0403MNmgoo001;Ool70[L<
Ool0045oo`07001oogooOomNm`5GOol00Ukg17oo00ANmgooOomNm`9oo`05G_MooekgOomNm`02Ool0
15kgOomooekg17oo0ekg00AooekgOomoo`805`8004]oo`L2e`aoo`00AGoo00ENm`5GOomooekg00Ao
o`9Nm`9oo`03G_Mooekg00ANm`04OomNmgooOol2G_L4Ool00ekgOomoo`02Ool01UkgOomoo`0GOol0
04]oo`L2m`aoo`00AGoo00D0005gOomNmgoo009Nm`06OomNmgooOomNmgoo0ekg00=ooekgOol00ekg
0Woo00ANmgooG_Moo`9Nm`03OomNmgoo009oo`06G_Moogoo01MNm`00Bgoo1`;e37oo0015Ool01000
0GMooekg0goo00ANmgooOomoo`9Nm`06OomNmekgOomNmgoo0Ukg00=ooekgG_L00goo00ENmgooOomo
oekg00=oo`04G_Moogoo01L2G_M;Ool70_@<Ool004Eoo`04G_L1MgooG_L2Ool015kgOomNmekg0Woo
00ANmgooG_Moo`=Nm`03OomNmgoo009Nm`05OomNmekgOomNm`02Ool015kgOomoogoo0ekg00<05ekg
0000Bgoo1`;c37oo0015Ool00`000GMNm`02G_L017ooG_Moogoo0T@G0TPG00=<5e0GG_L015kg00=o
oekgOol00Ukg0goo00ANmgooOomoo`ANm`9oo`0301Mooekg04]oo`L2l@aoo`00AGoo00<007oo0GL0
0Woo0Ukg0T0G00M45ekgG_MNmgooD1MD5`05G_L2Ool2G_L3Ool5G_L3Ool01EkgOol05gooG_L0Bgoo
1`;`37oo000WOol20003Ool20003Ool2000BOol00`00Ool1U`03Ool2@1L3G_L2Ool2G_L2G1L00e`F
G_MNm`03G_L00gooG_Moo`03G_L3Ool01UkgOomoogooG_Moo`805`03G_Moogoo04Uoo`L2k`aoo`00
9goo00<007ooOol017oo00D007ooOomoo`0000ioo`06001oogooOol007oo0P6G00=ooc`G?1L00goo
0ekg00EooekgG_ML5E`D00=Nm`03OomNmekg009Nm`9oo`05G_MoogooOomNm`03Ool01EkgOomoo`0G
G_L0Bgoo1`;]37oo000IOol300001Woo001oo`00Ool000Eoo`03001oogoo009oo`<000=oo`03001o
ogoo00]oo`03001oo`00009oo`04001ooekg0IL2?1L01EkgOomoogooG_L00Woo15kg00=L4EkgG_L0
0Ukg0goo00ANmgooOomNm`=oo`05G_MoogooOomNm`02Ool00`0G001oo`1:Ool70^`<Ool001Yoo`08
001oogoo001oo`00Ool000Eoo`05001oogooOol00002Ool01@00Oomoogoo00003Goo00<007oo0000
0Woo0ekg0P6G1ekg00=l05kgG_L00Ukg00<07ekgG_L04ekg00<05ekgOol0BWoo1`;Z37oo000JOol0
2000Oomoo`00Ool007oo0005Ool01@00Oomoogoo00000Woo00D007ooOomoo`0000eoo`03001oo`00
009oo`07001ooekg>1L1]gooG_L00goo00=NmgooOol015kg00<2hUkgG_L00Ukg0goo00ANmgooOomN
m`=oo`05G_MoogooOomNm`02Ool00`0G001oo`1:Ool70^T<Ool001Yoo`03001oogoo00800003Ool0
07oo00Eoo`03001oogoo009oo`<000=oo`03001oogoo00]oo`03001oo`00009oo`07001ooekg>1Mo
o`6gG_L00goo0ekg00EooekgG_MNm`;a00MNm`=oo`05G_MoogooOomNm`03Ool01EkgOomoo`@G0000
Bgoo1`;X37oo000JOol00`00Oomoo`0:Ool00`00Oomoo`08Ool00`00Oomoo`0<Ool01`00Oomoogoo
001oocPG009oo`81]`04OomNmekgG_L2Ool3G_L00`;g0_INm`03G_L2Ool5G_L3Ool01EkgOomoogoo
G_L00Woo00<45ekgOol0BWoo1`;V37oo000IOol3000;Ool20008Ool2000BOol00`00Oolh5`02Ool2
G_L20ML027ooG_MooekgOomNm`:G0[L4G_L017ooG_MNmekg0goo0Ukg0Woo00UNmgooOomooekgOol4
5`00G_L0Bgoo1`;U37oo0015Ool00`00Oold5`02G_L017ooG_Moo`7G0P7g00<25`8g0UL00P9g15kg
00EooekgOomooekg00=oo`03G_Mooekg009Nm`9oo`06G_Moogoo11MooekgBgoo1`;T0goo0`000Woo
00<007ooOol00Goo0015Ool015kg=1Mooekg0goo00ANmgooG_Moo`9Nm`03OomNmgoo00=Nm`03OomN
mgoo009Nm`04OomNmgooG_L3Ool00ekgOomNm`02G_L2Ool00`@GG_L0001;Ool70^84Ool00`00Oomo
o`05Ool004Eoo`04000d5gooG_L3Ool2G_L3Ool01ekgOomNmekgOomNmgoo009Nm`9oo`03G_Moogoo
009Nm`=oo`04G_MoogooOol3G_L00`PGG_L0001;Ool70^42Ool40006Ool004Eoo`06000d5gooOomN
mgoo0ekg0Woo0ekg00MooekgOomNmgooG_Moo`03G_L2Ool01EkgOomNmgooG_L017oo00ANmgooOol8
5`9NmeAoo`03001oo`0000Moo`00AGoo00@003@GOomoo`9Nm`9oo`03G_Mooekg009oo`=Nm`03OomN
mgoo00=Nm`9oo`03G_Mooekg009oo`9Nm`Aoo`06G_Moogoo21Moo`00EGoo0P001goo0015Ool015kg
<1Moogoo0Ukg0goo00ANmgooOomNm`9oo`ENm`9oo`04G_MoogooG_L3Ool3G_L3Ool015kgOomoo`PG
0P00EWoo00<007ooOol01Goo0015Ool01Ukg<1MNmekgOomNm`9oo`05G_MooekgOomNm`02Ool01Ekg
OomNmgooG_L00Woo00ENmgooG_Mooekg009oo`06G_MoogooG_Mooekg0Woo00@<5ekgOol005ioo`00
@7oo0`000Woo00=Nmc0GOol00goo00=NmgooG_L00Woo00ANmgooOomNm`9oo`04G_MoogooG_L2Ool0
15kgOomoogoo0Ukg17oo0Ukg0Woo00@<5ekgOol005ioo`00@7oo00<007ooOol00Woo00=Nmc0GOol0
0goo0Ukg0goo0Ukg00EooekgOomooekg009oo`04G_MooekgG_L3Ool2G_L4Ool3G_L01Goo31Moogoo
0000GWoo0011Ool01`00Oomoogoo000`5ekg00=oo`9Nm`9oo`03G_Moogoo00UNm`9oo`03G_Moogoo
009Nm`=oo`04G_MoogooOol231L00goo0000001NOol0045oo`0<001oogooOol0030GOomNmgooG_Mo
oekg0Woo00ENmgooOomooekg009oo`04G_MoogooG_L3Ool025kgOomooekgOomNmgooG_L4Ool01@`G
G_Moogoo0000GWoo0010Ool00`00Ool00002Ool01P00<1MooekgOomNm`9oo`9Nm`=oo`05G_Moogoo
OomNm`03Ool015kgOomoogoo0Ukg0goo0Ukg17oo00D@5gooG_MNm`0005ioo`00@Goo00H007ooOomo
o`00<1L2Ool00ekgOomoo`02Ool3G_L00gooG_Moo`02Ool01UkgOomoogooG_Moo`=Nm`Aoo`03G_Mo
ogoo009oo`0641MoogooOol005kgGWoo0015Ool00`00Ool/5`02G_L4Ool00ekgOomoo`02G_L3Ool0
15kgOomoogoo0Ukg0Woo00=NmgooOol00Woo0Ukg0goo00<@5gooOol00Woo00=NmgooOol0G7oo0015
Ool00ekgOol/5`02Ool015kgOomooekg17oo2Ekg17oo00ANmgooOomNm`9oo`03G_Mooa0G00Aoo`03
G_L007oo05eoo`00AGoo00@005kgG_L/5`9oo`=Nm`Aoo`05G_MoogooOomNm`03Ool00ekgOomoo`02
Ool3G_L4Ool00ekg51Moo`02Ool00ekgOol0001NOol004Eoo`04001Nmekg;1L3Ool2G_L3Ool00ekg
Oomoo`02Ool00ekgOomoo`02Ool015kgOomoogoo0Ukg17oo00=Nma@G51L00Woo00ANmgoo000005io
o`00AGoo00=NmgooOol00R`G0Woo00=NmgooG_L00Woo00=NmgooOol00Woo00=NmgooOol00Woo00IN
mgooOomNmgooG_L3Ool015kgOolD5ekg0Woo00ANmgooOol005ioo`00AGoo00L007ooOomoob`GOomN
m`03Ool3G_L4Ool00ekgOomoo`02Ool3G_L3Ool01EkgOomNmgoo51L00Woo0Ukg0goo00<007ooOol0
G7oo0015Ool00`00Oomoo`02Ool00bPGG_Moo`04Ool;G_L5Ool2G_L00goo51Moo`02Ool2G_L2Ool2
001NOol0045oo`<00003OomNmgoo00=oo`03G_LX5goo00Aoo`03G_Moogoo009oo`03G_Moogoo009o
o`03G_Moogoo00=oo`9Nm`8H5`=oo`03G_Mooekg009oo`03G_Moogoo05aoo`00@Woo00@007ooOomN
m`Aoo`04G_LX5bPGG_L2Ool00ekgOomoo`03Ool00ekgOomoo`03Ool00ekgOomoo`02G_L00goo61LH
5`03Ool015kgOomoogoo0Ukg00<007ooOol0G7oo0010Ool400001Woo001NmekgOomNm`=oo`04:1MN
mekgG_L5Ool00ekgOomoo`03Ool3G_L2Ool011PGOomNmgoo0Ukg17oo00=Nm`000000GWoo0010Ool0
0`00Ool00002Ool00`00Oomoo`02G_L4Ool00bPGOomNm`03G_L2Ool00ekgOomoo`04G_L2Ool271L2
Ool2G_L5Ool015kgOomNm`00GWoo0011Ool20002Ool00`00Oomoo`03G_L4Ool291L3Ool5G_L3Ool0
15kg71LL5a`G0Woo0ekg1Goo00ANmgooOomNmeioo`00@Woo00@007ooOol0009oo`04G_MoogooG_L3
Ool00ekgOolT5`0291L2Ool00ekgOomoo`02Ool371L3Ool015kgOomooekg17oo00ENmgooOomoo`00
05ioo`00AGoo00=NmgooG_L017oo0Ukg00=ooekgOol00Woo0b@G1B0G0Woo00ANmgooG_MNm`Aoo`04
G_MooekgG_L3Ool2001NOol004Eoo`03001Nmekg00H000=Nm`D00003G_L0000000<000=Nm`H0009N
m`D0009Nmeioo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo
003<Ool00<aoo`00c7oo003<Ool00<aoo`007Goo00<007ooOol05Woo00<007ooOol02Goo00<007oo
Ool0;7oo00<007ooOol02Goo00<007ooOol0=7oo00<007ooOol05Goo000LOol00`00Oomoo`0;Ool0
0`00Oomoo`0:Ool00`00Oomoo`07Ool00`00Oomoo`0@Ool00`00Oomoo`0>Ool00`00Oomoo`0:Ool0
0`00Oomoo`07Ool00`00Oomoo`0@Ool00`00Oomoo`0FOol00`00Oomoo`0:Ool00`00Oomoo`0DOol0
01]oo`03001oogoo009oo`<000Moo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03
001oogoo009oo`<000aoo`03001oogoo00=oo`<000Qoo`03001oogoo009oo`D000Aoo`03001oogoo
00Eoo`03001oogoo009oo`<000aoo`03001oogoo00=oo`<000Ioo`<000Moo`03001oogoo00=oo`<0
00Eoo`03001oogoo01=oo`006goo00<007ooOol017oo0P0017oo1@000goo00<007oo00001Goo00<0
07ooOol01Goo00<007ooOol017oo0P002Goo1@001Goo0P001Goo1@0017oo00<007ooOol017oo00<0
07ooOol01Goo00<007ooOol017oo0P002Goo1@000goo00<007ooOol027oo0P0017oo1@000goo00<0
07ooOol01Goo00<007ooOol04goo000KOol00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`05
Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`03Ool00`00Oomoo`02Ool30006Ool00`00
Oomoo`04Ool00`00Oomoo`07Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00
Oomoo`03Ool00`00Oomoo`02Ool30006Ool00`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`06
Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`0COol001]oo`03001oogoo00=oo`<000Io
o`03001oogoo00=oo`8000Ioo`03001oogoo00Eoo`03001oogoo00=oo`<0009oo`8000Moo`03001o
ogoo00Aoo`<000Moo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00=o
o`<0009oo`8000Moo`03001oogoo00Aoo`03001oogoo00Ioo`<000Ioo`03001oogoo00Aoo`03001o
ogoo00Aoo`03001oogoo01=oo`0027oo0P004Woo00<007ooOol04Goo00<007ooOol017oo00<007oo
Ool01goo00<007ooOol02Goo00<007ooOol077oo00<007ooOol00goo00<007ooOol01goo00<007oo
Ool02Goo00<007ooOol02Woo00<007oo00005Woo00<007oo000017oo00<007ooOol057oo0009Ool0
0`00Oomoo`0AOol00`00Oomoo`0@Ool30003Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomo
o`0KOol20004Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`0;Ool00`00Oomoo`0FOol0
0`00Oomoo`02Ool00`00Oomoo`0EOol0009oo`8000Eoo`03001oogoo009oo`@003Uoo`<003Qoo`<0
04=oo`0017oo00<007ooOol00Woo00<007ooOol02gooY0004Goo0003Ool00`00Oomoo`03Ool00`00
Oomoo`02Ool4002jOol000=oo`8000Aoo`03001oogoo0<1oo`002Goo00<007ooOol0>Woo00<007oo
Ool05goo00<007ooOol027oo00<007ooOol07Goo00<007ooOol0?Woo0008Ool2000kOol00`00Oomo
o`0;Ool00`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`0<Ool00`00Oomoo`0@Ool00`00Oomo
o`0mOol004Aoo`03001oogoo009oo`<000Moo`03001oogoo00Eoo`<000Aoo`03001oogoo00Aoo`03
001oogoo009oo`<000Qoo`03001oogoo009oo`D0009oo`03001oogoo00Eoo`03001oogoo03aoo`00
A7oo00<007ooOol017oo0P0017oo1@001Woo00<007ooOol00goo00<007ooOol017oo00<007ooOol0
17oo0P001Goo1@0017oo00L007ooOomoo`00Ool00006Ool00`00Oomoo`0lOol004Aoo`03001oogoo
00=oo`03001oogoo00Ioo`03001oogoo00Aoo`@000Aoo`03001oogoo00Aoo`03001oogoo00=oo`03
001oogoo00Moo`03001oogoo00Aoo`07001oogooOol007oo00001Woo00<007ooOol0?7oo0014Ool0
0`00Oomoo`03Ool30006Ool00`00Oomoo`04Ool00`00Ool00005Ool00`00Oomoo`04Ool00`00Oomo
o`03Ool30007Ool00`00Oomoo`04Ool01`00Oomoogoo001oo`0000Ioo`03001oogoo03aoo`00AGoo
00<007ooOol04goo0P0017oo00<007ooOol01Woo00<007ooOol04goo00L007ooOomoo`00Ool00005
Ool00`00Oomoo`0mOol004Ioo`03001oogoo01=oo`05001oogooOol0000:Ool00`00Oomoo`0AOol2
0004Ool00`00Oomoo`03Ool00`00Oomoo`0nOol00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool0
0<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool0
0<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool0
0<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool0
0<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool0
0<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool0
0<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool0
0<aoo`00c7oo003<Ool00<aoo`00c7oo0000\
\>"],
  ImageRangeCache->{{{0, 203.188}, {287, 0}} -> {-0.653492, -1.05157, \
0.00732796, 0.00732796}, {{4.8125, 173.5}, {279.938, 7}} -> {-16.0308, \
-20.17, 0.185268, 0.147495}, {{184.688, 198.313}, {211.688, 143.5}} -> \
{-28.5159, -884.944, 0.15413, 11.7447}},
  CellTags->{"Nyquist Plot", "i:10"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[115]=",
  CellTags->{"Nyquist Plot", "i:10"}]
}, Open  ]],

Cell["\<\
ColorNyquist has several options. PlotRange can be used when the transfer \
function has poles on the imaginary axis in order to obtain a visible plot. \
SensitivityPeak, Bandwidth and Margins place circles on the plot that help \
analyze performanc and stability margins.\
\>", "Text",
  CellTags->{"Nyquist Plot", "i:10"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(G5[s_] :=  .2\ \((s + 1)\)\ \(\((s^2 + Sqrt[9]\  + 9)\)\(/\)\((\ 
            s \((s^2\  + \ 2\ s\  + \ 2)\) \((s^2 + 2  s + 
                  4)\))\)\(\ \)\)\), "\n", 
    \(ColorNyquist[G5, s, \(-3\), 3,  .02, 
      PlotRange \[Rule] {{\(-1.25\),  .25}, {\(-1.5\), 1.5}}, 
      SensitivityPeak -> 1.5, Bandwidth -> True, Margins -> True]\)}], "Input",\

  CellLabel->"In[116]:=",
  CellTags->{"Nyquist Plot", "i:10"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.4104 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.438894 0.671621 0.705202 0.671621 [
[ 0 0 0 0 ]
[ 1 1.4104 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.0238095 0.033581 0.853978 1.37682 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.833333 0.666667 0.809017 0.539345 [
[.03333 -0.0125 -12 -9 ]
[.03333 -0.0125 12 0 ]
[.16667 -0.0125 -6 -9 ]
[.16667 -0.0125 6 0 ]
[.3 -0.0125 -12 -9 ]
[.3 -0.0125 12 0 ]
[.43333 -0.0125 -12 -9 ]
[.43333 -0.0125 12 0 ]
[.56667 -0.0125 -12 -9 ]
[.56667 -0.0125 12 0 ]
[.7 -0.0125 -12 -9 ]
[.7 -0.0125 12 0 ]
[.83333 -0.0125 -3 -9 ]
[.83333 -0.0125 3 0 ]
[.96667 -0.0125 -9 -9 ]
[.96667 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -17 -21.875 ]
[.5 -0.0125 17 -9 ]
[-0.0125 .26967 -12 -4.5 ]
[-0.0125 .26967 0 4.5 ]
[-0.0125 .53934 -24 -4.5 ]
[-0.0125 .53934 0 4.5 ]
[-0.0125 .80902 -6 -4.5 ]
[-0.0125 .80902 0 4.5 ]
[-0.0125 1.07869 -18 -4.5 ]
[-0.0125 1.07869 0 4.5 ]
[-0.0125 1.34836 -6 -4.5 ]
[-0.0125 1.34836 0 4.5 ]
[-0.0125 1.61803 -18 -4.5 ]
[-0.0125 1.61803 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .80902 -58.25 -6.4375 ]
[-0.01875 .80902 -24 6.4375 ]
[ 0 1.61803 .125 0 ]
[.5 1.63053 -5 0 ]
[.5 1.63053 5 12.875 ]
[ 1 0 .125 0 ]
[1.0125 .80902 0 -6.4375 ]
[1.0125 .80902 10 6.4375 ]
[.5 1.63053 -91.7188 12.875 ]
[.5 1.63053 91.7188 36.9375 ]
[ 0 0 0 0 ]
[ 1 1.61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.03333 0 m
.03333 .00625 L
s
[(-1.2)] .03333 -0.0125 0 1 Mshowa
.16667 0 m
.16667 .00625 L
s
[(-1)] .16667 -0.0125 0 1 Mshowa
.3 0 m
.3 .00625 L
s
[(-0.8)] .3 -0.0125 0 1 Mshowa
.43333 0 m
.43333 .00625 L
s
[(-0.6)] .43333 -0.0125 0 1 Mshowa
.56667 0 m
.56667 .00625 L
s
[(-0.4)] .56667 -0.0125 0 1 Mshowa
.7 0 m
.7 .00625 L
s
[(-0.2)] .7 -0.0125 0 1 Mshowa
.83333 0 m
.83333 .00625 L
s
[(0)] .83333 -0.0125 0 1 Mshowa
.96667 0 m
.96667 .00625 L
s
[(0.2)] .96667 -0.0125 0 1 Mshowa
.125 Mabswid
.06667 0 m
.06667 .00375 L
s
.1 0 m
.1 .00375 L
s
.13333 0 m
.13333 .00375 L
s
.2 0 m
.2 .00375 L
s
.23333 0 m
.23333 .00375 L
s
.26667 0 m
.26667 .00375 L
s
.33333 0 m
.33333 .00375 L
s
.36667 0 m
.36667 .00375 L
s
.4 0 m
.4 .00375 L
s
.46667 0 m
.46667 .00375 L
s
.5 0 m
.5 .00375 L
s
.53333 0 m
.53333 .00375 L
s
.6 0 m
.6 .00375 L
s
.63333 0 m
.63333 .00375 L
s
.66667 0 m
.66667 .00375 L
s
.73333 0 m
.73333 .00375 L
s
.76667 0 m
.76667 .00375 L
s
.8 0 m
.8 .00375 L
s
.86667 0 m
.86667 .00375 L
s
.9 0 m
.9 .00375 L
s
.93333 0 m
.93333 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -78 -25.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Re) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
75.000000 13.000000 moveto
(@) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
87.000000 13.000000 moveto
(D) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
0 .26967 m
.00625 .26967 L
s
[(-1)] -0.0125 .26967 1 0 Mshowa
0 .53934 m
.00625 .53934 L
s
[(-0.5)] -0.0125 .53934 1 0 Mshowa
0 .80902 m
.00625 .80902 L
s
[(0)] -0.0125 .80902 1 0 Mshowa
0 1.07869 m
.00625 1.07869 L
s
[(0.5)] -0.0125 1.07869 1 0 Mshowa
0 1.34836 m
.00625 1.34836 L
s
[(1)] -0.0125 1.34836 1 0 Mshowa
0 1.61803 m
.00625 1.61803 L
s
[(1.5)] -0.0125 1.61803 1 0 Mshowa
.125 Mabswid
0 .05393 m
.00375 .05393 L
s
0 .10787 m
.00375 .10787 L
s
0 .1618 m
.00375 .1618 L
s
0 .21574 m
.00375 .21574 L
s
0 .32361 m
.00375 .32361 L
s
0 .37754 m
.00375 .37754 L
s
0 .43148 m
.00375 .43148 L
s
0 .48541 m
.00375 .48541 L
s
0 .59328 m
.00375 .59328 L
s
0 .64721 m
.00375 .64721 L
s
0 .70115 m
.00375 .70115 L
s
0 .75508 m
.00375 .75508 L
s
0 .86295 m
.00375 .86295 L
s
0 .91689 m
.00375 .91689 L
s
0 .97082 m
.00375 .97082 L
s
0 1.02475 m
.00375 1.02475 L
s
0 1.13262 m
.00375 1.13262 L
s
0 1.18656 m
.00375 1.18656 L
s
0 1.24049 m
.00375 1.24049 L
s
0 1.29443 m
.00375 1.29443 L
s
0 1.4023 m
.00375 1.4023 L
s
0 1.45623 m
.00375 1.45623 L
s
0 1.51017 m
.00375 1.51017 L
s
0 1.5641 m
.00375 1.5641 L
s
.25 Mabswid
0 0 m
0 1.61803 L
s
gsave
-0.01875 .80902 -119.25 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Im) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
75.250000 13.000000 moveto
(@) show
81.250000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(g) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
87.250000 13.000000 moveto
(D) show
93.250000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
.03333 1.61178 m
.03333 1.61803 L
s
.16667 1.61178 m
.16667 1.61803 L
s
.3 1.61178 m
.3 1.61803 L
s
.43333 1.61178 m
.43333 1.61803 L
s
.56667 1.61178 m
.56667 1.61803 L
s
.7 1.61178 m
.7 1.61803 L
s
.83333 1.61178 m
.83333 1.61803 L
s
.96667 1.61178 m
.96667 1.61803 L
s
.125 Mabswid
.06667 1.61428 m
.06667 1.61803 L
s
.1 1.61428 m
.1 1.61803 L
s
.13333 1.61428 m
.13333 1.61803 L
s
.2 1.61428 m
.2 1.61803 L
s
.23333 1.61428 m
.23333 1.61803 L
s
.26667 1.61428 m
.26667 1.61803 L
s
.33333 1.61428 m
.33333 1.61803 L
s
.36667 1.61428 m
.36667 1.61803 L
s
.4 1.61428 m
.4 1.61803 L
s
.46667 1.61428 m
.46667 1.61803 L
s
.5 1.61428 m
.5 1.61803 L
s
.53333 1.61428 m
.53333 1.61803 L
s
.6 1.61428 m
.6 1.61803 L
s
.63333 1.61428 m
.63333 1.61803 L
s
.66667 1.61428 m
.66667 1.61803 L
s
.73333 1.61428 m
.73333 1.61803 L
s
.76667 1.61428 m
.76667 1.61803 L
s
.8 1.61428 m
.8 1.61803 L
s
.86667 1.61428 m
.86667 1.61803 L
s
.9 1.61428 m
.9 1.61803 L
s
.93333 1.61428 m
.93333 1.61803 L
s
.25 Mabswid
0 1.61803 m
1 1.61803 L
s
gsave
.5 1.63053 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
69.000000 13.000000 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.99375 0 m
1 0 L
s
.99375 .26967 m
1 .26967 L
s
.99375 .53934 m
1 .53934 L
s
.99375 .80902 m
1 .80902 L
s
.99375 1.07869 m
1 1.07869 L
s
.99375 1.34836 m
1 1.34836 L
s
.125 Mabswid
.99625 .05393 m
1 .05393 L
s
.99625 .10787 m
1 .10787 L
s
.99625 .1618 m
1 .1618 L
s
.99625 .21574 m
1 .21574 L
s
.99625 .32361 m
1 .32361 L
s
.99625 .37754 m
1 .37754 L
s
.99625 .43148 m
1 .43148 L
s
.99625 .48541 m
1 .48541 L
s
.99625 .59328 m
1 .59328 L
s
.99625 .64721 m
1 .64721 L
s
.99625 .70115 m
1 .70115 L
s
.99625 .75508 m
1 .75508 L
s
.99625 .86295 m
1 .86295 L
s
.99625 .91689 m
1 .91689 L
s
.99625 .97082 m
1 .97082 L
s
.99625 1.02475 m
1 1.02475 L
s
.99625 1.13262 m
1 1.13262 L
s
.99625 1.18656 m
1 1.18656 L
s
.99625 1.24049 m
1 1.24049 L
s
.99625 1.29443 m
1 1.29443 L
s
.99625 1.4023 m
1 1.4023 L
s
.99625 1.45623 m
1 1.45623 L
s
.99625 1.51017 m
1 1.51017 L
s
.99625 1.5641 m
1 1.5641 L
s
.25 Mabswid
1 0 m
1 1.61803 L
s
gsave
1.0125 .80902 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
69.000000 13.000000 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.5 1.63053 -152.719 8.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 32.0625 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 28.062500 moveto
 460.000000 28.062500 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 28.062500 lineto
closepath
clip newpath
63.000000 18.812500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 18.812500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(G) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
69.000000 18.812500 moveto
(@) show
75.000000 18.812500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
81.000000 18.812500 moveto
(D) show
87.000000 18.812500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(=) show
93.000000 18.812500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
117.375000 12.750000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
138.000000 12.750000 moveto
(H) show
144.000000 12.750000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
152.375000 12.750000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
160.750000 12.750000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
166.750000 12.750000 moveto
(L) show
175.375000 12.750000 moveto
(H) show
181.375000 12.750000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
187.375000 9.312500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
194.312500 12.750000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
202.687500 12.750000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(12) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
214.687500 12.750000 moveto
(L) show
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
97.375000 18.812500 moveto
(\\200) show
99.250000 18.812500 moveto
(\\200) show
101.125000 18.812500 moveto
(\\200) show
103.000000 18.812500 moveto
(\\200) show
104.875000 18.812500 moveto
(\\200) show
106.750000 18.812500 moveto
(\\200) show
108.625000 18.812500 moveto
(\\200) show
110.500000 18.812500 moveto
(\\200) show
112.375000 18.812500 moveto
(\\200) show
114.250000 18.812500 moveto
(\\200) show
116.125000 18.812500 moveto
(\\200) show
118.000000 18.812500 moveto
(\\200) show
119.875000 18.812500 moveto
(\\200) show
121.750000 18.812500 moveto
(\\200) show
123.625000 18.812500 moveto
(\\200) show
125.500000 18.812500 moveto
(\\200) show
127.375000 18.812500 moveto
(\\200) show
129.250000 18.812500 moveto
(\\200) show
131.125000 18.812500 moveto
(\\200) show
133.000000 18.812500 moveto
(\\200) show
134.875000 18.812500 moveto
(\\200) show
136.750000 18.812500 moveto
(\\200) show
138.625000 18.812500 moveto
(\\200) show
140.500000 18.812500 moveto
(\\200) show
142.375000 18.812500 moveto
(\\200) show
144.250000 18.812500 moveto
(\\200) show
146.125000 18.812500 moveto
(\\200) show
148.000000 18.812500 moveto
(\\200) show
149.875000 18.812500 moveto
(\\200) show
151.750000 18.812500 moveto
(\\200) show
153.625000 18.812500 moveto
(\\200) show
155.500000 18.812500 moveto
(\\200) show
157.375000 18.812500 moveto
(\\200) show
159.250000 18.812500 moveto
(\\200) show
161.125000 18.812500 moveto
(\\200) show
163.000000 18.812500 moveto
(\\200) show
164.875000 18.812500 moveto
(\\200) show
166.750000 18.812500 moveto
(\\200) show
168.625000 18.812500 moveto
(\\200) show
170.500000 18.812500 moveto
(\\200) show
172.375000 18.812500 moveto
(\\200) show
174.250000 18.812500 moveto
(\\200) show
176.125000 18.812500 moveto
(\\200) show
178.000000 18.812500 moveto
(\\200) show
179.875000 18.812500 moveto
(\\200) show
181.750000 18.812500 moveto
(\\200) show
183.625000 18.812500 moveto
(\\200) show
185.500000 18.812500 moveto
(\\200) show
187.375000 18.812500 moveto
(\\200) show
189.250000 18.812500 moveto
(\\200) show
191.125000 18.812500 moveto
(\\200) show
193.000000 18.812500 moveto
(\\200) show
194.875000 18.812500 moveto
(\\200) show
196.750000 18.812500 moveto
(\\200) show
198.625000 18.812500 moveto
(\\200) show
200.500000 18.812500 moveto
(\\200) show
202.375000 18.812500 moveto
(\\200) show
204.250000 18.812500 moveto
(\\200) show
206.125000 18.812500 moveto
(\\200) show
208.000000 18.812500 moveto
(\\200) show
209.875000 18.812500 moveto
(\\200) show
211.750000 18.812500 moveto
(\\200) show
213.625000 18.812500 moveto
(\\200) show
215.500000 18.812500 moveto
(\\200) show
217.375000 18.812500 moveto
(\\200) show
219.250000 18.812500 moveto
(\\200) show
221.125000 18.812500 moveto
(\\200) show
223.000000 18.812500 moveto
(\\200) show
224.875000 18.812500 moveto
(\\200) show
226.750000 18.812500 moveto
(\\200) show
228.625000 18.812500 moveto
(\\200) show
230.500000 18.812500 moveto
(\\200) show
232.375000 18.812500 moveto
(\\200) show
234.250000 18.812500 moveto
(\\200) show
236.125000 18.812500 moveto
(\\200) show
238.000000 18.812500 moveto
(\\200) show
238.812500 18.812500 moveto
(\\200) show
98.687500 25.125000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
107.312500 25.125000 moveto
(H) show
113.312500 25.125000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
119.312500 22.562500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
126.250000 25.125000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
134.625000 25.125000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
143.250000 25.125000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
151.625000 25.125000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
160.000000 25.125000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
166.000000 25.125000 moveto
(L) show
174.625000 25.125000 moveto
(H) show
180.625000 25.125000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
186.625000 22.562500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
193.562500 25.125000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
201.937500 25.125000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
210.562500 25.125000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
218.937500 25.125000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
227.312500 25.125000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
233.312500 25.125000 moveto
(L) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier-Italic
%%+ font Math1Mono
%%+ font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier-Italic
%%+ Math1Mono
%%+ Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier-Italic
%%+ font Math1Mono
%%+ font Math2Mono
%%+ font Courier
grestore
0 0 m
1 0 L
1 1.61803 L
0 1.61803 L
closepath
clip
newpath
.75 g
.5 Mabswid
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
1 .84515 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
1 .88686 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
1 .94385 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
1 1.04256 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
1 1.31223 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
.83333 1.61803 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
.56538 1.61803 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
.25598 1.61803 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
0 1.4832 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
0 1.19826 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
0 .98966 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
0 .80902 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
0 .62837 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
0 .41978 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
0 .13484 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
.25598 0 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
.56538 0 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
.83333 0 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
1 .3058 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
1 .57547 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
1 .67418 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
1 .73117 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
1 .77289 L
s
.83333 .80902 m
0 0 rlineto s
.83333 .80902 m
1 .80902 L
s
.96667 .80902 m
.96562 .82254 L
.96248 .83584 L
.9573 .84873 L
.95017 .86098 L
.9412 .87242 L
.93053 .88286 L
.91832 .89213 L
.90478 .90009 L
.8901 .90662 L
.87454 .91161 L
.85832 .91498 L
.84171 .91667 L
.82496 .91667 L
.80835 .91498 L
.79213 .91161 L
.77656 .90662 L
.76189 .90009 L
.74834 .89213 L
.73614 .88286 L
.72546 .87242 L
.71649 .86098 L
.70936 .84873 L
.70419 .83584 L
.70105 .82254 L
.7 .80902 L
.70105 .7955 L
.70419 .78219 L
.70936 .76931 L
.71649 .75705 L
.72546 .74561 L
.73614 .73518 L
.74834 .7259 L
.76189 .71794 L
.77656 .71141 L
.79213 .70643 L
.80835 .70306 L
.82496 .70136 L
.84171 .70136 L
.85832 .70306 L
.87454 .70643 L
.8901 .71141 L
.90478 .71794 L
.91832 .7259 L
.93053 .73518 L
.9412 .74561 L
.95017 .75705 L
.9573 .76931 L
.96248 .78219 L
.96562 .7955 L
Mistroke
.96667 .80902 L
Mfstroke
1 .97719 m
.97622 .99117 L
.94687 1.00422 L
.91574 1.0142 L
.8833 1.02093 L
.85008 1.02433 L
.81659 1.02433 L
.78336 1.02093 L
.75093 1.0142 L
.71979 1.00422 L
.69045 .99117 L
.66335 .97525 L
.63894 .9567 L
.6176 .93582 L
.59965 .91295 L
.58539 .88844 L
.57504 .86267 L
.56877 .83606 L
.56667 .80902 L
.56877 .78198 L
.57504 .75537 L
.58539 .7296 L
.59965 .70508 L
.6176 .68221 L
.63894 .66133 L
.66335 .64279 L
.69045 .62686 L
.71979 .61381 L
.75093 .60384 L
.78336 .5971 L
.81659 .5937 L
.85008 .5937 L
.8833 .5971 L
.91574 .60384 L
.94687 .61381 L
.97622 .62686 L
s
.97622 .62686 m
1 .64084 L
s
1 1.10299 m
.95694 1.11679 L
.90829 1.12689 L
.85845 1.13199 L
.80822 1.13199 L
.75838 1.12689 L
.70973 1.11679 L
.66302 1.10183 L
.619 1.08225 L
.57836 1.05836 L
.54175 1.03054 L
.50973 .99923 L
.48281 .96492 L
.46142 .92814 L
.4459 .88949 L
.43649 .84958 L
.43333 .80902 L
.43649 .76846 L
.4459 .72854 L
.46142 .68989 L
.48281 .65312 L
.50973 .61881 L
.54175 .58749 L
.57836 .55967 L
.619 .53579 L
.66302 .51621 L
.70973 .50125 L
.75838 .49114 L
.80822 .48605 L
.85845 .48605 L
.90829 .49114 L
.95694 .50125 L
s
.95694 .50125 m
1 .51504 L
s
1 1.21878 m
.99814 1.21937 L
.93327 1.23285 L
.86682 1.23964 L
.79985 1.23964 L
.7334 1.23285 L
.66852 1.21937 L
.60625 1.19943 L
.54756 1.17332 L
.49337 1.14147 L
.44455 1.10438 L
.40186 1.06263 L
.36597 1.01688 L
.33745 .96785 L
.31676 .91632 L
.30421 .8631 L
.3 .80902 L
.30421 .75494 L
.31676 .70171 L
.33745 .65018 L
.36597 .60115 L
.40186 .5554 L
.44455 .51365 L
.49337 .47656 L
.54756 .44471 L
.60625 .41861 L
.66852 .39866 L
.7334 .38518 L
.79985 .37839 L
.86682 .37839 L
.93327 .38518 L
.99814 .39866 L
s
.99814 .39866 m
1 .39925 L
s
1 1.33014 m
.95825 1.33881 L
.87519 1.3473 L
.79147 1.3473 L
.70841 1.33881 L
.62732 1.32196 L
.54948 1.29703 L
.47612 1.2644 L
.40838 1.22459 L
.34735 1.17822 L
.29399 1.12604 L
.24913 1.06885 L
.21348 1.00756 L
.18761 .94315 L
.17192 .87661 L
.16667 .80902 L
.17192 .74142 L
.18761 .67489 L
.21348 .61047 L
.24913 .54919 L
.29399 .492 L
.34735 .43981 L
.40838 .39344 L
.47612 .35363 L
.54948 .321 L
.62732 .29607 L
.70841 .27923 L
.79147 .27074 L
.87519 .27074 L
.95825 .27923 L
s
.95825 .27923 m
1 .2879 L
s
1 1.44128 m
.98324 1.44477 L
.88357 1.45495 L
.7831 1.45495 L
.68343 1.44477 L
.58612 1.42455 L
.49271 1.39463 L
.40467 1.35548 L
.32339 1.3077 L
.25016 1.25207 L
.18612 1.18944 L
.13229 1.12081 L
.08951 1.04727 L
.05847 .96997 L
.03964 .89013 L
.03333 .80902 L
.03964 .7279 L
.05847 .64806 L
.08951 .57076 L
.13229 .49722 L
.18612 .42859 L
.25016 .36597 L
.32339 .31033 L
.40467 .26256 L
.49271 .2234 L
.58612 .19348 L
.68343 .17327 L
.7831 .16308 L
.88357 .16308 L
.98324 .17327 L
s
.98324 .17327 m
1 .17675 L
s
1 1.55157 m
.89194 1.56261 L
.77473 1.56261 L
.65844 1.55072 L
.54492 1.52714 L
.43594 1.49224 L
.33323 1.44655 L
.2384 1.39082 L
.15296 1.32591 L
.07825 1.25284 L
.01545 1.17278 L
s
.01545 1.17278 m
0 1.14622 L
s
0 .47181 m
.01545 .44525 L
.07825 .36519 L
.15296 .29213 L
.2384 .22722 L
.33323 .17148 L
.43594 .1258 L
.54492 .09089 L
.65844 .06731 L
.77473 .05542 L
.89194 .05542 L
s
.89194 .05542 m
1 .06647 L
s
.46719 1.61803 m
.37917 1.58984 L
.26178 1.53763 L
.15341 1.47393 L
.05577 1.39975 L
s
.05577 1.39975 m
0 1.34521 L
s
0 .27282 m
.05577 .21829 L
.15341 .1441 L
.26178 .0804 L
.37917 .0282 L
s
.37917 .0282 m
.46719 0 L
s
.17218 1.61803 m
.06842 1.55705 L
s
.06842 1.55705 m
0 1.50506 L
s
0 .11297 m
.06842 .06099 L
s
.06842 .06099 m
.17218 0 L
s
.75 0 0 r
.008 w
.83511 .8045 m
.83516 .80418 L
s
.75 0 .01 r
.83516 .80418 m
.8352 .80383 L
s
.75 0 .019 r
.8352 .80383 m
.83524 .80348 L
s
.75 0 .029 r
.83524 .80348 m
.83527 .8031 L
s
.75 0 .039 r
.83527 .8031 m
.8353 .80271 L
s
.75 0 .049 r
.8353 .80271 m
.83531 .8023 L
s
.75 0 .059 r
.83531 .8023 m
.83531 .80188 L
s
.75 0 .068 r
.83531 .80188 m
.8353 .80143 L
s
.75 0 .078 r
.8353 .80143 m
.83528 .80097 L
s
.75 0 .088 r
.83528 .80097 m
.83525 .80048 L
s
.75 0 .098 r
.83525 .80048 m
.8352 .79998 L
s
.75 0 .107 r
.8352 .79998 m
.83513 .79945 L
s
.75 0 .117 r
.83513 .79945 m
.83505 .79891 L
s
.75 0 .127 r
.83505 .79891 m
.83494 .79834 L
s
.75 0 .137 r
.83494 .79834 m
.83482 .79775 L
s
.75 0 .146 r
.83482 .79775 m
.83467 .79713 L
s
.75 0 .156 r
.83467 .79713 m
.83449 .79649 L
s
.75 0 .166 r
.83449 .79649 m
.83429 .79583 L
s
.75 0 .176 r
.83429 .79583 m
.83406 .79514 L
s
.75 0 .185 r
.83406 .79514 m
.83379 .79443 L
s
.75 0 .195 r
.83379 .79443 m
.8335 .79369 L
s
.75 0 .205 r
.8335 .79369 m
.83316 .79293 L
s
.75 0 .214 r
.83316 .79293 m
.83278 .79214 L
s
.75 0 .224 r
.83278 .79214 m
.83236 .79133 L
s
.75 0 .234 r
.83236 .79133 m
.83189 .79049 L
s
.75 0 .244 r
.83189 .79049 m
.83137 .78962 L
s
.75 0 .254 r
.83137 .78962 m
.8308 .78873 L
s
.75 0 .263 r
.8308 .78873 m
.83017 .78782 L
s
.75 0 .273 r
.83017 .78782 m
.82948 .78688 L
s
.75 0 .283 r
.82948 .78688 m
.82872 .78592 L
s
.75 0 .293 r
.82872 .78592 m
.8279 .78494 L
s
.75 0 .302 r
.8279 .78494 m
.827 .78394 L
s
.75 0 .312 r
.827 .78394 m
.82603 .78292 L
s
.75 0 .322 r
.82603 .78292 m
.82497 .78189 L
s
.75 0 .332 r
.82497 .78189 m
.82383 .78084 L
s
.75 0 .341 r
.82383 .78084 m
.82259 .77977 L
s
.75 0 .351 r
.82259 .77977 m
.82126 .7787 L
s
.75 0 .361 r
.82126 .7787 m
.81983 .77762 L
s
.75 0 .37 r
.81983 .77762 m
.8183 .77654 L
s
.75 0 .38 r
.8183 .77654 m
.81665 .77546 L
s
.75 0 .39 r
.81665 .77546 m
.8149 .77439 L
s
.75 0 .4 r
.8149 .77439 m
.81302 .77333 L
s
.75 0 .409 r
.81302 .77333 m
.81102 .77228 L
s
.75 0 .419 r
.81102 .77228 m
.8089 .77125 L
s
.75 0 .429 r
.8089 .77125 m
.80665 .77025 L
s
.75 0 .439 r
.80665 .77025 m
.80426 .76928 L
s
.75 0 .448 r
.80426 .76928 m
.80174 .76835 L
s
.75 0 .458 r
.80174 .76835 m
.79908 .76747 L
s
.75 0 .468 r
.79908 .76747 m
.79628 .76664 L
s
.75 0 .478 r
.79628 .76664 m
.79333 .76587 L
s
.75 0 .488 r
.79333 .76587 m
.79025 .76517 L
s
.75 0 .497 r
.79025 .76517 m
.78702 .76455 L
s
.75 0 .507 r
.78702 .76455 m
.78365 .76402 L
s
.75 0 .517 r
.78365 .76402 m
.78014 .76359 L
s
.75 0 .527 r
.78014 .76359 m
.77649 .76326 L
s
.75 0 .536 r
.77649 .76326 m
.77271 .76304 L
s
.75 0 .546 r
.77271 .76304 m
.7688 .76295 L
s
.75 0 .556 r
.7688 .76295 m
.76475 .76299 L
s
.75 0 .566 r
.76475 .76299 m
.76059 .76318 L
s
.75 0 .575 r
.76059 .76318 m
.75631 .76351 L
s
.75 0 .585 r
.75631 .76351 m
.75192 .76401 L
s
.75 0 .595 r
.75192 .76401 m
.74744 .76467 L
s
.75 0 .605 r
.74744 .76467 m
.74287 .76552 L
s
.75 0 .614 r
.74287 .76552 m
.73821 .76654 L
s
.75 0 .624 r
.73821 .76654 m
.73349 .76776 L
s
.75 0 .634 r
.73349 .76776 m
.72871 .76919 L
s
.75 0 .644 r
.72871 .76919 m
.72389 .77081 L
s
.75 0 .653 r
.72389 .77081 m
.71904 .77265 L
s
.75 0 .663 r
.71904 .77265 m
.71417 .77471 L
s
.75 0 .673 r
.71417 .77471 m
.7093 .77698 L
s
.75 0 .683 r
.7093 .77698 m
.70444 .77949 L
s
.75 0 .692 r
.70444 .77949 m
.6996 .78221 L
s
.75 0 .702 r
.6996 .78221 m
.69481 .78517 L
s
.75 0 .712 r
.69481 .78517 m
.69008 .78836 L
s
.75 0 .721 r
.69008 .78836 m
.68543 .79178 L
s
.75 0 .731 r
.68543 .79178 m
.68086 .79543 L
s
.75 0 .741 r
.68086 .79543 m
.6764 .7993 L
s
.749 0 .75 r
.6764 .7993 m
.67206 .8034 L
s
.739 0 .75 r
.67206 .8034 m
.66786 .80773 L
s
.73 0 .75 r
.66786 .80773 m
.6638 .81227 L
s
.72 0 .75 r
.6638 .81227 m
.65992 .81702 L
s
.71 0 .75 r
.65992 .81702 m
.65621 .82198 L
s
.701 0 .75 r
.65621 .82198 m
.6527 .82713 L
s
.691 0 .75 r
.6527 .82713 m
.64939 .83249 L
s
.681 0 .75 r
.64939 .83249 m
.64629 .83802 L
s
.671 0 .75 r
.64629 .83802 m
.64343 .84373 L
s
.661 0 .75 r
.64343 .84373 m
.6408 .84961 L
s
.652 0 .75 r
.6408 .84961 m
.63841 .85565 L
s
.642 0 .75 r
.63841 .85565 m
.63628 .86183 L
s
.632 0 .75 r
.63628 .86183 m
.6344 .86815 L
s
.623 0 .75 r
.6344 .86815 m
.63279 .8746 L
s
.613 0 .75 r
.63279 .8746 m
.63145 .88117 L
s
.603 0 .75 r
.63145 .88117 m
.63037 .88785 L
s
.593 0 .75 r
.63037 .88785 m
.62956 .89462 L
s
.584 0 .75 r
.62956 .89462 m
.62903 .90148 L
s
.574 0 .75 r
.62903 .90148 m
.62875 .90842 L
s
.564 0 .75 r
.62875 .90842 m
.62875 .91543 L
s
.554 0 .75 r
.62875 .91543 m
.629 .9225 L
s
.545 0 .75 r
.629 .9225 m
.6295 .92962 L
s
.535 0 .75 r
.6295 .92962 m
.63026 .9368 L
s
.525 0 .75 r
.63026 .9368 m
.63125 .94402 L
s
.515 0 .75 r
.63125 .94402 m
.63246 .95128 L
s
.505 0 .75 r
.63246 .95128 m
.6339 .95858 L
s
.496 0 .75 r
.6339 .95858 m
.63555 .96592 L
s
.486 0 .75 r
.63555 .96592 m
.63739 .9733 L
s
.476 0 .75 r
.63739 .9733 m
.63941 .98072 L
s
.466 0 .75 r
.63941 .98072 m
.6416 .98819 L
s
.457 0 .75 r
.6416 .98819 m
.64394 .99571 L
s
.447 0 .75 r
.64394 .99571 m
.64643 1.00329 L
s
.437 0 .75 r
.64643 1.00329 m
.64905 1.01095 L
s
.427 0 .75 r
.64905 1.01095 m
.65177 1.0187 L
s
.418 0 .75 r
.65177 1.0187 m
.6546 1.02655 L
s
.408 0 .75 r
.6546 1.02655 m
.65751 1.03453 L
s
.398 0 .75 r
.65751 1.03453 m
.66049 1.04266 L
s
.388 0 .75 r
.66049 1.04266 m
.66352 1.05097 L
s
.379 0 .75 r
.66352 1.05097 m
.66659 1.05948 L
s
.369 0 .75 r
.66659 1.05948 m
.6697 1.06824 L
s
.359 0 .75 r
.6697 1.06824 m
.67281 1.07729 L
s
.349 0 .75 r
.67281 1.07729 m
.67594 1.08666 L
s
.34 0 .75 r
.67594 1.08666 m
.67905 1.09642 L
s
.33 0 .75 r
.67905 1.09642 m
.68214 1.10662 L
s
.32 0 .75 r
.68214 1.10662 m
.68521 1.11733 L
s
.31 0 .75 r
.68521 1.11733 m
.68823 1.12863 L
s
.301 0 .75 r
.68823 1.12863 m
.6912 1.14061 L
s
.291 0 .75 r
.6912 1.14061 m
.69412 1.15337 L
s
.281 0 .75 r
.69412 1.15337 m
.69697 1.16704 L
s
.272 0 .75 r
.69697 1.16704 m
.69974 1.18175 L
s
.262 0 .75 r
.69974 1.18175 m
.70244 1.19767 L
s
.252 0 .75 r
.70244 1.19767 m
.70505 1.215 L
s
.242 0 .75 r
.70505 1.215 m
.70756 1.23397 L
s
.232 0 .75 r
.70756 1.23397 m
.70998 1.25486 L
s
.223 0 .75 r
.70998 1.25486 m
.7123 1.27802 L
s
.213 0 .75 r
.7123 1.27802 m
.71451 1.30386 L
s
.203 0 .75 r
.71451 1.30386 m
.7166 1.33293 L
s
.194 0 .75 r
.7166 1.33293 m
.71859 1.36588 L
s
.184 0 .75 r
.71859 1.36588 m
.72046 1.40357 L
s
.174 0 .75 r
.72046 1.40357 m
.72221 1.44711 L
s
.164 0 .75 r
.72221 1.44711 m
.72383 1.498 L
s
.154 0 .75 r
.72383 1.498 m
.72534 1.55826 L
s
.145 0 .75 r
.72534 1.55826 m
0 0 rlineto s
.72534 1.55826 m
.72647 1.61803 L
s
.135 0 .75 r
.125 0 .75 r
.115 0 .75 r
.106 0 .75 r
.096 0 .75 r
.086 0 .75 r
0 .001 .75 r
0 .011 .75 r
0 .021 .75 r
0 .031 .75 r
0 .041 .75 r
0 .05 .75 r
0 .06 .75 r
.72647 0 m
.72534 .05977 L
s
0 .07 .75 r
.72534 .05977 m
.72383 .12003 L
s
0 .079 .75 r
.72383 .12003 m
.72221 .17092 L
s
0 .089 .75 r
.72221 .17092 m
.72046 .21447 L
s
0 .099 .75 r
.72046 .21447 m
.71859 .25215 L
s
0 .109 .75 r
.71859 .25215 m
.7166 .2851 L
s
0 .119 .75 r
.7166 .2851 m
.71451 .31417 L
s
0 .128 .75 r
.71451 .31417 m
.7123 .34002 L
s
0 .138 .75 r
.7123 .34002 m
.70998 .36317 L
s
0 .148 .75 r
.70998 .36317 m
.70756 .38407 L
s
0 .158 .75 r
.70756 .38407 m
.70505 .40303 L
s
0 .167 .75 r
.70505 .40303 m
.70244 .42036 L
s
0 .177 .75 r
.70244 .42036 m
.69974 .43628 L
s
0 .187 .75 r
.69974 .43628 m
.69697 .451 L
s
0 .197 .75 r
.69697 .451 m
.69412 .46466 L
s
0 .206 .75 r
.69412 .46466 m
.6912 .47743 L
s
0 .216 .75 r
.6912 .47743 m
.68823 .48941 L
s
0 .226 .75 r
.68823 .48941 m
.68521 .50071 L
s
0 .236 .75 r
.68521 .50071 m
.68214 .51142 L
s
0 .245 .75 r
.68214 .51142 m
.67905 .52162 L
s
0 .255 .75 r
.67905 .52162 m
.67594 .53137 L
s
0 .265 .75 r
.67594 .53137 m
.67281 .54075 L
s
0 .275 .75 r
.67281 .54075 m
.6697 .54979 L
s
0 .284 .75 r
.6697 .54979 m
.66659 .55855 L
s
0 .294 .75 r
.66659 .55855 m
.66352 .56706 L
s
0 .304 .75 r
.66352 .56706 m
.66049 .57537 L
s
0 .314 .75 r
.66049 .57537 m
.65751 .5835 L
s
0 .323 .75 r
.65751 .5835 m
.6546 .59148 L
s
0 .333 .75 r
.6546 .59148 m
.65177 .59934 L
s
0 .343 .75 r
.65177 .59934 m
.64905 .60708 L
s
0 .353 .75 r
.64905 .60708 m
.64643 .61474 L
s
0 .362 .75 r
.64643 .61474 m
.64394 .62233 L
s
0 .372 .75 r
.64394 .62233 m
.6416 .62985 L
s
0 .382 .75 r
.6416 .62985 m
.63941 .63731 L
s
0 .392 .75 r
.63941 .63731 m
.63739 .64473 L
s
0 .401 .75 r
.63739 .64473 m
.63555 .65211 L
s
0 .411 .75 r
.63555 .65211 m
.6339 .65945 L
s
0 .421 .75 r
.6339 .65945 m
.63246 .66675 L
s
0 .431 .75 r
.63246 .66675 m
.63125 .67401 L
s
0 .44 .75 r
.63125 .67401 m
.63026 .68123 L
s
0 .45 .75 r
.63026 .68123 m
.6295 .68841 L
s
0 .46 .75 r
.6295 .68841 m
.629 .69554 L
s
0 .469 .75 r
.629 .69554 m
.62875 .70261 L
s
0 .479 .75 r
.62875 .70261 m
.62875 .70962 L
s
0 .489 .75 r
.62875 .70962 m
.62903 .71656 L
s
0 .499 .75 r
.62903 .71656 m
.62956 .72342 L
s
0 .508 .75 r
.62956 .72342 m
.63037 .73019 L
s
0 .518 .75 r
.63037 .73019 m
.63145 .73686 L
s
0 .528 .75 r
.63145 .73686 m
.63279 .74343 L
s
0 .538 .75 r
.63279 .74343 m
.6344 .74988 L
s
0 .548 .75 r
.6344 .74988 m
.63628 .7562 L
s
0 .557 .75 r
.63628 .7562 m
.63841 .76239 L
s
0 .567 .75 r
.63841 .76239 m
.6408 .76842 L
s
0 .577 .75 r
.6408 .76842 m
.64343 .7743 L
s
0 .587 .75 r
.64343 .7743 m
.64629 .78001 L
s
0 .596 .75 r
.64629 .78001 m
.64939 .78555 L
s
0 .606 .75 r
.64939 .78555 m
.6527 .7909 L
s
0 .616 .75 r
.6527 .7909 m
.65621 .79606 L
s
0 .626 .75 r
.65621 .79606 m
.65992 .80102 L
s
0 .635 .75 r
.65992 .80102 m
.6638 .80577 L
s
0 .645 .75 r
.6638 .80577 m
.66786 .81031 L
s
0 .655 .75 r
.66786 .81031 m
.67206 .81463 L
s
0 .665 .75 r
.67206 .81463 m
.6764 .81873 L
s
0 .674 .75 r
.6764 .81873 m
.68086 .82261 L
s
0 .684 .75 r
.68086 .82261 m
.68543 .82625 L
s
0 .694 .75 r
.68543 .82625 m
.69008 .82967 L
s
0 .704 .75 r
.69008 .82967 m
.69481 .83286 L
s
0 .713 .75 r
.69481 .83286 m
.6996 .83582 L
s
0 .723 .75 r
.6996 .83582 m
.70444 .83855 L
s
0 .733 .75 r
.70444 .83855 m
.7093 .84105 L
s
0 .743 .75 r
.7093 .84105 m
.71417 .84333 L
s
0 .75 .748 r
.71417 .84333 m
.71904 .84538 L
s
0 .75 .738 r
.71904 .84538 m
.72389 .84722 L
s
0 .75 .728 r
.72389 .84722 m
.72871 .84885 L
s
0 .75 .719 r
.72871 .84885 m
.73349 .85027 L
s
0 .75 .709 r
.73349 .85027 m
.73821 .85149 L
s
0 .75 .699 r
.73821 .85149 m
.74287 .85252 L
s
0 .75 .689 r
.74287 .85252 m
.74744 .85336 L
s
0 .75 .679 r
.74744 .85336 m
.75192 .85403 L
s
0 .75 .67 r
.75192 .85403 m
.75631 .85452 L
s
0 .75 .66 r
.75631 .85452 m
.76059 .85486 L
s
0 .75 .65 r
.76059 .85486 m
.76475 .85504 L
s
0 .75 .641 r
.76475 .85504 m
.7688 .85508 L
s
0 .75 .631 r
.7688 .85508 m
.77271 .85499 L
s
0 .75 .621 r
.77271 .85499 m
.77649 .85478 L
s
0 .75 .611 r
.77649 .85478 m
.78014 .85445 L
s
0 .75 .601 r
.78014 .85445 m
.78365 .85401 L
s
0 .75 .592 r
.78365 .85401 m
.78702 .85348 L
s
0 .75 .582 r
.78702 .85348 m
.79025 .85286 L
s
0 .75 .572 r
.79025 .85286 m
.79333 .85216 L
s
0 .75 .562 r
.79333 .85216 m
.79628 .8514 L
s
0 .75 .553 r
.79628 .8514 m
.79908 .85057 L
s
0 .75 .543 r
.79908 .85057 m
.80174 .84969 L
s
0 .75 .533 r
.80174 .84969 m
.80426 .84876 L
s
0 .75 .524 r
.80426 .84876 m
.80665 .84779 L
s
0 .75 .514 r
.80665 .84779 m
.8089 .84679 L
s
0 .75 .504 r
.8089 .84679 m
.81102 .84576 L
s
0 .75 .494 r
.81102 .84576 m
.81302 .84471 L
s
0 .75 .484 r
.81302 .84471 m
.8149 .84364 L
s
0 .75 .475 r
.8149 .84364 m
.81665 .84257 L
s
0 .75 .465 r
.81665 .84257 m
.8183 .84149 L
s
0 .75 .455 r
.8183 .84149 m
.81983 .84041 L
s
0 .75 .445 r
.81983 .84041 m
.82126 .83933 L
s
0 .75 .436 r
.82126 .83933 m
.82259 .83826 L
s
0 .75 .426 r
.82259 .83826 m
.82383 .8372 L
s
0 .75 .416 r
.82383 .8372 m
.82497 .83615 L
s
0 .75 .406 r
.82497 .83615 m
.82603 .83511 L
s
0 .75 .397 r
.82603 .83511 m
.827 .83409 L
s
0 .75 .387 r
.827 .83409 m
.8279 .83309 L
s
0 .75 .377 r
.8279 .83309 m
.82872 .83211 L
s
0 .75 .367 r
.82872 .83211 m
.82948 .83115 L
s
0 .75 .358 r
.82948 .83115 m
.83017 .83021 L
s
0 .75 .348 r
.83017 .83021 m
.8308 .8293 L
s
0 .75 .338 r
.8308 .8293 m
.83137 .82841 L
s
0 .75 .328 r
.83137 .82841 m
.83189 .82755 L
s
0 .75 .319 r
.83189 .82755 m
.83236 .82671 L
s
0 .75 .309 r
.83236 .82671 m
.83278 .82589 L
s
0 .75 .299 r
.83278 .82589 m
.83316 .8251 L
s
0 .75 .289 r
.83316 .8251 m
.8335 .82434 L
s
0 .75 .28 r
.8335 .82434 m
.83379 .8236 L
s
0 .75 .27 r
.83379 .8236 m
.83406 .82289 L
s
0 .75 .26 r
.83406 .82289 m
.83429 .8222 L
s
0 .75 .251 r
.83429 .8222 m
.83449 .82154 L
s
0 .75 .241 r
.83449 .82154 m
.83467 .8209 L
s
0 .75 .231 r
.83467 .8209 m
.83482 .82029 L
s
0 .75 .221 r
.83482 .82029 m
.83494 .8197 L
s
0 .75 .212 r
.83494 .8197 m
.83505 .81913 L
s
0 .75 .202 r
.83505 .81913 m
.83513 .81858 L
s
0 .75 .192 r
.83513 .81858 m
.8352 .81805 L
s
0 .75 .182 r
.8352 .81805 m
.83525 .81755 L
s
0 .75 .172 r
.83525 .81755 m
.83528 .81707 L
s
0 .75 .163 r
.83528 .81707 m
.8353 .8166 L
s
0 .75 .153 r
.8353 .8166 m
.83531 .81616 L
s
0 .75 .143 r
.83531 .81616 m
.83531 .81573 L
s
0 .75 .133 r
.83531 .81573 m
.8353 .81532 L
s
0 .75 .124 r
.8353 .81532 m
.83527 .81493 L
s
0 .75 .114 r
.83527 .81493 m
.83524 .81456 L
s
0 .75 .104 r
.83524 .81456 m
.8352 .8142 L
s
0 .75 .095 r
.8352 .8142 m
.83516 .81386 L
s
0 .75 .085 r
.83516 .81386 m
.83511 .81353 L
s
0 1 0 r
.001 w
.61111 .80902 m
.60761 .85408 L
.59715 .89844 L
.5799 .94138 L
.55614 .98224 L
.52623 1.02036 L
.49065 1.05515 L
.44997 1.08607 L
.40481 1.11261 L
.3559 1.13436 L
.30401 1.15098 L
.24995 1.16221 L
.19457 1.16787 L
.13876 1.16787 L
.08339 1.16221 L
.02933 1.15098 L
s
.02933 1.15098 m
0 1.14159 L
s
0 .47645 m
.02933 .46705 L
.08339 .45582 L
.13876 .45016 L
.19457 .45016 L
.24995 .45582 L
.30401 .46705 L
.3559 .48367 L
.40481 .50543 L
.44997 .53197 L
.49065 .56288 L
.52623 .59767 L
.55614 .6358 L
.5799 .67665 L
.59715 .7196 L
.60761 .76395 L
.61111 .80902 L
s
1 0 0 r
.0005 w
1 1.16419 m
.99286 1.17647 L
.92942 1.25735 L
.85394 1.33115 L
.76764 1.39672 L
.67185 1.45303 L
.5681 1.49917 L
.45801 1.53443 L
.34333 1.55826 L
.22587 1.57026 L
.10747 1.57026 L
s
.10747 1.57026 m
0 1.55928 L
s
0 .05876 m
.10747 .04777 L
.22587 .04777 L
.34333 .05978 L
.45801 .0836 L
.5681 .11886 L
.67185 .16501 L
.76764 .22131 L
.85394 .28688 L
.92942 .36068 L
.99286 .44156 L
s
.99286 .44156 m
1 .45384 L
s
0 0 1 r
.004 w
1 1.33014 m
.95825 1.33881 L
.87519 1.3473 L
.79147 1.3473 L
.70841 1.33881 L
.62732 1.32196 L
.54948 1.29703 L
.47612 1.2644 L
.40838 1.22459 L
.34735 1.17822 L
.29399 1.12604 L
.24913 1.06885 L
.21348 1.00756 L
.18761 .94315 L
.17192 .87661 L
.16667 .80902 L
.17192 .74142 L
.18761 .67489 L
.21348 .61047 L
.24913 .54919 L
.29399 .492 L
.34735 .43981 L
.40838 .39344 L
.47612 .35363 L
.54948 .321 L
.62732 .29607 L
.70841 .27923 L
.79147 .27074 L
.87519 .27074 L
.95825 .27923 L
s
.95825 .27923 m
1 .2879 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.909028 0.369391 0.97619 0.705202 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.000833056 0.0166611 [
[ 0 0 0 0 ]
[ 1 5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 5 L
0 5 L
closepath
clip
newpath
.75 0 0 r
.02381 .00083 m
.02381 .01749 L
.5 .01749 L
.5 .00083 L
F
0 g
gsave
.52381 .00916 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(3) show
75.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
.75 0 .01 r
.02381 .01749 m
.02381 .03416 L
.5 .03416 L
.5 .01749 L
F
.75 0 .02 r
.02381 .03416 m
.02381 .05082 L
.5 .05082 L
.5 .03416 L
F
.75 0 .029 r
.02381 .05082 m
.02381 .06748 L
.5 .06748 L
.5 .05082 L
F
.75 0 .039 r
.02381 .06748 m
.02381 .08414 L
.5 .08414 L
.5 .06748 L
F
.75 0 .049 r
.02381 .08414 m
.02381 .1008 L
.5 .1008 L
.5 .08414 L
F
.75 0 .059 r
.02381 .1008 m
.02381 .11746 L
.5 .11746 L
.5 .1008 L
F
.75 0 .068 r
.02381 .11746 m
.02381 .13412 L
.5 .13412 L
.5 .11746 L
F
.75 0 .078 r
.02381 .13412 m
.02381 .15078 L
.5 .15078 L
.5 .13412 L
F
.75 0 .088 r
.02381 .15078 m
.02381 .16744 L
.5 .16744 L
.5 .15078 L
F
.75 0 .098 r
.02381 .16744 m
.02381 .18411 L
.5 .18411 L
.5 .16744 L
F
.75 0 .108 r
.02381 .18411 m
.02381 .20077 L
.5 .20077 L
.5 .18411 L
F
.75 0 .117 r
.02381 .20077 m
.02381 .21743 L
.5 .21743 L
.5 .20077 L
F
.75 0 .127 r
.02381 .21743 m
.02381 .23409 L
.5 .23409 L
.5 .21743 L
F
.75 0 .137 r
.02381 .23409 m
.02381 .25075 L
.5 .25075 L
.5 .23409 L
F
.75 0 .147 r
.02381 .25075 m
.02381 .26741 L
.5 .26741 L
.5 .25075 L
F
.75 0 .157 r
.02381 .26741 m
.02381 .28407 L
.5 .28407 L
.5 .26741 L
F
.75 0 .166 r
.02381 .28407 m
.02381 .30073 L
.5 .30073 L
.5 .28407 L
F
.75 0 .176 r
.02381 .30073 m
.02381 .31739 L
.5 .31739 L
.5 .30073 L
F
.75 0 .186 r
.02381 .31739 m
.02381 .33406 L
.5 .33406 L
.5 .31739 L
F
.75 0 .196 r
.02381 .33406 m
.02381 .35072 L
.5 .35072 L
.5 .33406 L
F
.75 0 .205 r
.02381 .35072 m
.02381 .36738 L
.5 .36738 L
.5 .35072 L
F
.75 0 .215 r
.02381 .36738 m
.02381 .38404 L
.5 .38404 L
.5 .36738 L
F
.75 0 .225 r
.02381 .38404 m
.02381 .4007 L
.5 .4007 L
.5 .38404 L
F
.75 0 .235 r
.02381 .4007 m
.02381 .41736 L
.5 .41736 L
.5 .4007 L
F
.75 0 .245 r
.02381 .41736 m
.02381 .43402 L
.5 .43402 L
.5 .41736 L
F
.75 0 .254 r
.02381 .43402 m
.02381 .45068 L
.5 .45068 L
.5 .43402 L
F
.75 0 .264 r
.02381 .45068 m
.02381 .46734 L
.5 .46734 L
.5 .45068 L
F
.75 0 .274 r
.02381 .46734 m
.02381 .48401 L
.5 .48401 L
.5 .46734 L
F
.75 0 .284 r
.02381 .48401 m
.02381 .50067 L
.5 .50067 L
.5 .48401 L
F
.75 0 .293 r
.02381 .50067 m
.02381 .51733 L
.5 .51733 L
.5 .50067 L
F
.75 0 .303 r
.02381 .51733 m
.02381 .53399 L
.5 .53399 L
.5 .51733 L
F
.75 0 .313 r
.02381 .53399 m
.02381 .55065 L
.5 .55065 L
.5 .53399 L
F
.75 0 .323 r
.02381 .55065 m
.02381 .56731 L
.5 .56731 L
.5 .55065 L
F
.75 0 .333 r
.02381 .56731 m
.02381 .58397 L
.5 .58397 L
.5 .56731 L
F
.75 0 .342 r
.02381 .58397 m
.02381 .60063 L
.5 .60063 L
.5 .58397 L
F
.75 0 .352 r
.02381 .60063 m
.02381 .61729 L
.5 .61729 L
.5 .60063 L
F
.75 0 .362 r
.02381 .61729 m
.02381 .63396 L
.5 .63396 L
.5 .61729 L
F
.75 0 .372 r
.02381 .63396 m
.02381 .65062 L
.5 .65062 L
.5 .63396 L
F
.75 0 .382 r
.02381 .65062 m
.02381 .66728 L
.5 .66728 L
.5 .65062 L
F
.75 0 .391 r
.02381 .66728 m
.02381 .68394 L
.5 .68394 L
.5 .66728 L
F
.75 0 .401 r
.02381 .68394 m
.02381 .7006 L
.5 .7006 L
.5 .68394 L
F
.75 0 .411 r
.02381 .7006 m
.02381 .71726 L
.5 .71726 L
.5 .7006 L
F
.75 0 .421 r
.02381 .71726 m
.02381 .73392 L
.5 .73392 L
.5 .71726 L
F
.75 0 .43 r
.02381 .73392 m
.02381 .75058 L
.5 .75058 L
.5 .73392 L
F
.75 0 .44 r
.02381 .75058 m
.02381 .76724 L
.5 .76724 L
.5 .75058 L
F
.75 0 .45 r
.02381 .76724 m
.02381 .78391 L
.5 .78391 L
.5 .76724 L
F
.75 0 .46 r
.02381 .78391 m
.02381 .80057 L
.5 .80057 L
.5 .78391 L
F
.75 0 .47 r
.02381 .80057 m
.02381 .81723 L
.5 .81723 L
.5 .80057 L
F
.75 0 .479 r
.02381 .81723 m
.02381 .83389 L
.5 .83389 L
.5 .81723 L
F
.75 0 .489 r
.02381 .83389 m
.02381 .85055 L
.5 .85055 L
.5 .83389 L
F
.75 0 .499 r
.02381 .85055 m
.02381 .86721 L
.5 .86721 L
.5 .85055 L
F
.75 0 .509 r
.02381 .86721 m
.02381 .88387 L
.5 .88387 L
.5 .86721 L
F
.75 0 .518 r
.02381 .88387 m
.02381 .90053 L
.5 .90053 L
.5 .88387 L
F
.75 0 .528 r
.02381 .90053 m
.02381 .91719 L
.5 .91719 L
.5 .90053 L
F
.75 0 .538 r
.02381 .91719 m
.02381 .93386 L
.5 .93386 L
.5 .91719 L
F
.75 0 .548 r
.02381 .93386 m
.02381 .95052 L
.5 .95052 L
.5 .93386 L
F
.75 0 .558 r
.02381 .95052 m
.02381 .96718 L
.5 .96718 L
.5 .95052 L
F
.75 0 .567 r
.02381 .96718 m
.02381 .98384 L
.5 .98384 L
.5 .96718 L
F
.75 0 .577 r
.02381 .98384 m
.02381 1.0005 L
.5 1.0005 L
.5 .98384 L
F
.75 0 .587 r
.02381 1.0005 m
.02381 1.01716 L
.5 1.01716 L
.5 1.0005 L
F
.75 0 .597 r
.02381 1.01716 m
.02381 1.03382 L
.5 1.03382 L
.5 1.01716 L
F
.75 0 .607 r
.02381 1.03382 m
.02381 1.05048 L
.5 1.05048 L
.5 1.03382 L
F
.75 0 .616 r
.02381 1.05048 m
.02381 1.06714 L
.5 1.06714 L
.5 1.05048 L
F
.75 0 .626 r
.02381 1.06714 m
.02381 1.08381 L
.5 1.08381 L
.5 1.06714 L
F
.75 0 .636 r
.02381 1.08381 m
.02381 1.10047 L
.5 1.10047 L
.5 1.08381 L
F
.75 0 .646 r
.02381 1.10047 m
.02381 1.11713 L
.5 1.11713 L
.5 1.10047 L
F
.75 0 .655 r
.02381 1.11713 m
.02381 1.13379 L
.5 1.13379 L
.5 1.11713 L
F
.75 0 .665 r
.02381 1.13379 m
.02381 1.15045 L
.5 1.15045 L
.5 1.13379 L
F
.75 0 .675 r
.02381 1.15045 m
.02381 1.16711 L
.5 1.16711 L
.5 1.15045 L
F
.75 0 .685 r
.02381 1.16711 m
.02381 1.18377 L
.5 1.18377 L
.5 1.16711 L
F
.75 0 .695 r
.02381 1.18377 m
.02381 1.20043 L
.5 1.20043 L
.5 1.18377 L
F
.75 0 .704 r
.02381 1.20043 m
.02381 1.21709 L
.5 1.21709 L
.5 1.20043 L
F
.75 0 .714 r
.02381 1.21709 m
.02381 1.23376 L
.5 1.23376 L
.5 1.21709 L
F
.75 0 .724 r
.02381 1.23376 m
.02381 1.25042 L
.5 1.25042 L
.5 1.23376 L
F
.75 0 .734 r
.02381 1.25042 m
.02381 1.26708 L
.5 1.26708 L
.5 1.25042 L
F
.75 0 .743 r
.02381 1.26708 m
.02381 1.28374 L
.5 1.28374 L
.5 1.26708 L
F
.747 0 .75 r
.02381 1.28374 m
.02381 1.3004 L
.5 1.3004 L
.5 1.28374 L
F
.737 0 .75 r
.02381 1.3004 m
.02381 1.31706 L
.5 1.31706 L
.5 1.3004 L
F
.727 0 .75 r
.02381 1.31706 m
.02381 1.33372 L
.5 1.33372 L
.5 1.31706 L
F
.717 0 .75 r
.02381 1.33372 m
.02381 1.35038 L
.5 1.35038 L
.5 1.33372 L
F
.708 0 .75 r
.02381 1.35038 m
.02381 1.36704 L
.5 1.36704 L
.5 1.35038 L
F
.698 0 .75 r
.02381 1.36704 m
.02381 1.38371 L
.5 1.38371 L
.5 1.36704 L
F
.688 0 .75 r
.02381 1.38371 m
.02381 1.40037 L
.5 1.40037 L
.5 1.38371 L
F
.678 0 .75 r
.02381 1.40037 m
.02381 1.41703 L
.5 1.41703 L
.5 1.40037 L
F
.668 0 .75 r
.02381 1.41703 m
.02381 1.43369 L
.5 1.43369 L
.5 1.41703 L
F
.659 0 .75 r
.02381 1.43369 m
.02381 1.45035 L
.5 1.45035 L
.5 1.43369 L
F
.649 0 .75 r
.02381 1.45035 m
.02381 1.46701 L
.5 1.46701 L
.5 1.45035 L
F
.639 0 .75 r
.02381 1.46701 m
.02381 1.48367 L
.5 1.48367 L
.5 1.46701 L
F
.629 0 .75 r
.02381 1.48367 m
.02381 1.50033 L
.5 1.50033 L
.5 1.48367 L
F
.62 0 .75 r
.02381 1.50033 m
.02381 1.51699 L
.5 1.51699 L
.5 1.50033 L
F
.61 0 .75 r
.02381 1.51699 m
.02381 1.53366 L
.5 1.53366 L
.5 1.51699 L
F
.6 0 .75 r
.02381 1.53366 m
.02381 1.55032 L
.5 1.55032 L
.5 1.53366 L
F
.59 0 .75 r
.02381 1.55032 m
.02381 1.56698 L
.5 1.56698 L
.5 1.55032 L
F
.58 0 .75 r
.02381 1.56698 m
.02381 1.58364 L
.5 1.58364 L
.5 1.56698 L
F
.571 0 .75 r
.02381 1.58364 m
.02381 1.6003 L
.5 1.6003 L
.5 1.58364 L
F
.561 0 .75 r
.02381 1.6003 m
.02381 1.61696 L
.5 1.61696 L
.5 1.6003 L
F
.551 0 .75 r
.02381 1.61696 m
.02381 1.63362 L
.5 1.63362 L
.5 1.61696 L
F
.541 0 .75 r
.02381 1.63362 m
.02381 1.65028 L
.5 1.65028 L
.5 1.63362 L
F
.532 0 .75 r
.02381 1.65028 m
.02381 1.66694 L
.5 1.66694 L
.5 1.65028 L
F
.522 0 .75 r
.02381 1.66694 m
.02381 1.68361 L
.5 1.68361 L
.5 1.66694 L
F
.512 0 .75 r
.02381 1.68361 m
.02381 1.70027 L
.5 1.70027 L
.5 1.68361 L
F
.502 0 .75 r
.02381 1.70027 m
.02381 1.71693 L
.5 1.71693 L
.5 1.70027 L
F
.492 0 .75 r
.02381 1.71693 m
.02381 1.73359 L
.5 1.73359 L
.5 1.71693 L
F
.483 0 .75 r
.02381 1.73359 m
.02381 1.75025 L
.5 1.75025 L
.5 1.73359 L
F
.473 0 .75 r
.02381 1.75025 m
.02381 1.76691 L
.5 1.76691 L
.5 1.75025 L
F
.463 0 .75 r
.02381 1.76691 m
.02381 1.78357 L
.5 1.78357 L
.5 1.76691 L
F
.453 0 .75 r
.02381 1.78357 m
.02381 1.80023 L
.5 1.80023 L
.5 1.78357 L
F
.443 0 .75 r
.02381 1.80023 m
.02381 1.81689 L
.5 1.81689 L
.5 1.80023 L
F
.434 0 .75 r
.02381 1.81689 m
.02381 1.83356 L
.5 1.83356 L
.5 1.81689 L
F
.424 0 .75 r
.02381 1.83356 m
.02381 1.85022 L
.5 1.85022 L
.5 1.83356 L
F
.414 0 .75 r
.02381 1.85022 m
.02381 1.86688 L
.5 1.86688 L
.5 1.85022 L
F
.404 0 .75 r
.02381 1.86688 m
.02381 1.88354 L
.5 1.88354 L
.5 1.86688 L
F
.395 0 .75 r
.02381 1.88354 m
.02381 1.9002 L
.5 1.9002 L
.5 1.88354 L
F
.385 0 .75 r
.02381 1.9002 m
.02381 1.91686 L
.5 1.91686 L
.5 1.9002 L
F
.375 0 .75 r
.02381 1.91686 m
.02381 1.93352 L
.5 1.93352 L
.5 1.91686 L
F
.365 0 .75 r
.02381 1.93352 m
.02381 1.95018 L
.5 1.95018 L
.5 1.93352 L
F
.355 0 .75 r
.02381 1.95018 m
.02381 1.96684 L
.5 1.96684 L
.5 1.95018 L
F
.346 0 .75 r
.02381 1.96684 m
.02381 1.98351 L
.5 1.98351 L
.5 1.96684 L
F
.336 0 .75 r
.02381 1.98351 m
.02381 2.00017 L
.5 2.00017 L
.5 1.98351 L
F
.326 0 .75 r
.02381 2.00017 m
.02381 2.01683 L
.5 2.01683 L
.5 2.00017 L
F
.316 0 .75 r
.02381 2.01683 m
.02381 2.03349 L
.5 2.03349 L
.5 2.01683 L
F
.307 0 .75 r
.02381 2.03349 m
.02381 2.05015 L
.5 2.05015 L
.5 2.03349 L
F
.297 0 .75 r
.02381 2.05015 m
.02381 2.06681 L
.5 2.06681 L
.5 2.05015 L
F
.287 0 .75 r
.02381 2.06681 m
.02381 2.08347 L
.5 2.08347 L
.5 2.06681 L
F
.277 0 .75 r
.02381 2.08347 m
.02381 2.10013 L
.5 2.10013 L
.5 2.08347 L
F
.267 0 .75 r
.02381 2.10013 m
.02381 2.11679 L
.5 2.11679 L
.5 2.10013 L
F
.258 0 .75 r
.02381 2.11679 m
.02381 2.13346 L
.5 2.13346 L
.5 2.11679 L
F
.248 0 .75 r
.02381 2.13346 m
.02381 2.15012 L
.5 2.15012 L
.5 2.13346 L
F
.238 0 .75 r
.02381 2.15012 m
.02381 2.16678 L
.5 2.16678 L
.5 2.15012 L
F
.228 0 .75 r
.02381 2.16678 m
.02381 2.18344 L
.5 2.18344 L
.5 2.16678 L
F
.218 0 .75 r
.02381 2.18344 m
.02381 2.2001 L
.5 2.2001 L
.5 2.18344 L
F
.209 0 .75 r
.02381 2.2001 m
.02381 2.21676 L
.5 2.21676 L
.5 2.2001 L
F
.199 0 .75 r
.02381 2.21676 m
.02381 2.23342 L
.5 2.23342 L
.5 2.21676 L
F
.189 0 .75 r
.02381 2.23342 m
.02381 2.25008 L
.5 2.25008 L
.5 2.23342 L
F
.179 0 .75 r
.02381 2.25008 m
.02381 2.26674 L
.5 2.26674 L
.5 2.25008 L
F
.17 0 .75 r
.02381 2.26674 m
.02381 2.28341 L
.5 2.28341 L
.5 2.26674 L
F
.16 0 .75 r
.02381 2.28341 m
.02381 2.30007 L
.5 2.30007 L
.5 2.28341 L
F
.15 0 .75 r
.02381 2.30007 m
.02381 2.31673 L
.5 2.31673 L
.5 2.30007 L
F
.14 0 .75 r
.02381 2.31673 m
.02381 2.33339 L
.5 2.33339 L
.5 2.31673 L
F
.13 0 .75 r
.02381 2.33339 m
.02381 2.35005 L
.5 2.35005 L
.5 2.33339 L
F
.121 0 .75 r
.02381 2.35005 m
.02381 2.36671 L
.5 2.36671 L
.5 2.35005 L
F
.111 0 .75 r
.02381 2.36671 m
.02381 2.38337 L
.5 2.38337 L
.5 2.36671 L
F
.101 0 .75 r
.02381 2.38337 m
.02381 2.40003 L
.5 2.40003 L
.5 2.38337 L
F
.091 0 .75 r
.02381 2.40003 m
.02381 2.41669 L
.5 2.41669 L
.5 2.40003 L
F
.082 0 .75 r
.02381 2.41669 m
.02381 2.43336 L
.5 2.43336 L
.5 2.41669 L
F
.072 0 .75 r
.02381 2.43336 m
.02381 2.45002 L
.5 2.45002 L
.5 2.43336 L
F
.062 0 .75 r
.02381 2.45002 m
.02381 2.46668 L
.5 2.46668 L
.5 2.45002 L
F
.052 0 .75 r
.02381 2.46668 m
.02381 2.48334 L
.5 2.48334 L
.5 2.46668 L
F
.042 0 .75 r
.02381 2.48334 m
.02381 2.5 L
.5 2.5 L
.5 2.48334 L
F
.033 0 .75 r
.02381 2.5 m
.02381 2.51666 L
.5 2.51666 L
.5 2.5 L
F
.023 0 .75 r
.02381 2.51666 m
.02381 2.53332 L
.5 2.53332 L
.5 2.51666 L
F
.013 0 .75 r
.02381 2.53332 m
.02381 2.54998 L
.5 2.54998 L
.5 2.53332 L
F
.003 0 .75 r
.02381 2.54998 m
.02381 2.56664 L
.5 2.56664 L
.5 2.54998 L
F
0 .007 .75 r
.02381 2.56664 m
.02381 2.58331 L
.5 2.58331 L
.5 2.56664 L
F
0 .016 .75 r
.02381 2.58331 m
.02381 2.59997 L
.5 2.59997 L
.5 2.58331 L
F
0 .026 .75 r
.02381 2.59997 m
.02381 2.61663 L
.5 2.61663 L
.5 2.59997 L
F
0 .036 .75 r
.02381 2.61663 m
.02381 2.63329 L
.5 2.63329 L
.5 2.61663 L
F
0 .046 .75 r
.02381 2.63329 m
.02381 2.64995 L
.5 2.64995 L
.5 2.63329 L
F
0 .055 .75 r
.02381 2.64995 m
.02381 2.66661 L
.5 2.66661 L
.5 2.64995 L
F
0 .065 .75 r
.02381 2.66661 m
.02381 2.68327 L
.5 2.68327 L
.5 2.66661 L
F
0 .075 .75 r
.02381 2.68327 m
.02381 2.69993 L
.5 2.69993 L
.5 2.68327 L
F
0 .085 .75 r
.02381 2.69993 m
.02381 2.71659 L
.5 2.71659 L
.5 2.69993 L
F
0 .095 .75 r
.02381 2.71659 m
.02381 2.73326 L
.5 2.73326 L
.5 2.71659 L
F
0 .104 .75 r
.02381 2.73326 m
.02381 2.74992 L
.5 2.74992 L
.5 2.73326 L
F
0 .114 .75 r
.02381 2.74992 m
.02381 2.76658 L
.5 2.76658 L
.5 2.74992 L
F
0 .124 .75 r
.02381 2.76658 m
.02381 2.78324 L
.5 2.78324 L
.5 2.76658 L
F
0 .134 .75 r
.02381 2.78324 m
.02381 2.7999 L
.5 2.7999 L
.5 2.78324 L
F
0 .143 .75 r
.02381 2.7999 m
.02381 2.81656 L
.5 2.81656 L
.5 2.7999 L
F
0 .153 .75 r
.02381 2.81656 m
.02381 2.83322 L
.5 2.83322 L
.5 2.81656 L
F
0 .163 .75 r
.02381 2.83322 m
.02381 2.84988 L
.5 2.84988 L
.5 2.83322 L
F
0 .173 .75 r
.02381 2.84988 m
.02381 2.86654 L
.5 2.86654 L
.5 2.84988 L
F
0 .183 .75 r
.02381 2.86654 m
.02381 2.88321 L
.5 2.88321 L
.5 2.86654 L
F
0 .192 .75 r
.02381 2.88321 m
.02381 2.89987 L
.5 2.89987 L
.5 2.88321 L
F
0 .202 .75 r
.02381 2.89987 m
.02381 2.91653 L
.5 2.91653 L
.5 2.89987 L
F
0 .212 .75 r
.02381 2.91653 m
.02381 2.93319 L
.5 2.93319 L
.5 2.91653 L
F
0 .222 .75 r
.02381 2.93319 m
.02381 2.94985 L
.5 2.94985 L
.5 2.93319 L
F
0 .232 .75 r
.02381 2.94985 m
.02381 2.96651 L
.5 2.96651 L
.5 2.94985 L
F
0 .241 .75 r
.02381 2.96651 m
.02381 2.98317 L
.5 2.98317 L
.5 2.96651 L
F
0 .251 .75 r
.02381 2.98317 m
.02381 2.99983 L
.5 2.99983 L
.5 2.98317 L
F
0 .261 .75 r
.02381 2.99983 m
.02381 3.01649 L
.5 3.01649 L
.5 2.99983 L
F
0 .271 .75 r
.02381 3.01649 m
.02381 3.03316 L
.5 3.03316 L
.5 3.01649 L
F
0 .28 .75 r
.02381 3.03316 m
.02381 3.04982 L
.5 3.04982 L
.5 3.03316 L
F
0 .29 .75 r
.02381 3.04982 m
.02381 3.06648 L
.5 3.06648 L
.5 3.04982 L
F
0 .3 .75 r
.02381 3.06648 m
.02381 3.08314 L
.5 3.08314 L
.5 3.06648 L
F
0 .31 .75 r
.02381 3.08314 m
.02381 3.0998 L
.5 3.0998 L
.5 3.08314 L
F
0 .32 .75 r
.02381 3.0998 m
.02381 3.11646 L
.5 3.11646 L
.5 3.0998 L
F
0 .329 .75 r
.02381 3.11646 m
.02381 3.13312 L
.5 3.13312 L
.5 3.11646 L
F
0 .339 .75 r
.02381 3.13312 m
.02381 3.14978 L
.5 3.14978 L
.5 3.13312 L
F
0 .349 .75 r
.02381 3.14978 m
.02381 3.16644 L
.5 3.16644 L
.5 3.14978 L
F
0 .359 .75 r
.02381 3.16644 m
.02381 3.18311 L
.5 3.18311 L
.5 3.16644 L
F
0 .368 .75 r
.02381 3.18311 m
.02381 3.19977 L
.5 3.19977 L
.5 3.18311 L
F
0 .378 .75 r
.02381 3.19977 m
.02381 3.21643 L
.5 3.21643 L
.5 3.19977 L
F
0 .388 .75 r
.02381 3.21643 m
.02381 3.23309 L
.5 3.23309 L
.5 3.21643 L
F
0 .398 .75 r
.02381 3.23309 m
.02381 3.24975 L
.5 3.24975 L
.5 3.23309 L
F
0 .408 .75 r
.02381 3.24975 m
.02381 3.26641 L
.5 3.26641 L
.5 3.24975 L
F
0 .417 .75 r
.02381 3.26641 m
.02381 3.28307 L
.5 3.28307 L
.5 3.26641 L
F
0 .427 .75 r
.02381 3.28307 m
.02381 3.29973 L
.5 3.29973 L
.5 3.28307 L
F
0 .437 .75 r
.02381 3.29973 m
.02381 3.31639 L
.5 3.31639 L
.5 3.29973 L
F
0 .447 .75 r
.02381 3.31639 m
.02381 3.33306 L
.5 3.33306 L
.5 3.31639 L
F
0 .457 .75 r
.02381 3.33306 m
.02381 3.34972 L
.5 3.34972 L
.5 3.33306 L
F
0 .466 .75 r
.02381 3.34972 m
.02381 3.36638 L
.5 3.36638 L
.5 3.34972 L
F
0 .476 .75 r
.02381 3.36638 m
.02381 3.38304 L
.5 3.38304 L
.5 3.36638 L
F
0 .486 .75 r
.02381 3.38304 m
.02381 3.3997 L
.5 3.3997 L
.5 3.38304 L
F
0 .496 .75 r
.02381 3.3997 m
.02381 3.41636 L
.5 3.41636 L
.5 3.3997 L
F
0 .505 .75 r
.02381 3.41636 m
.02381 3.43302 L
.5 3.43302 L
.5 3.41636 L
F
0 .515 .75 r
.02381 3.43302 m
.02381 3.44968 L
.5 3.44968 L
.5 3.43302 L
F
0 .525 .75 r
.02381 3.44968 m
.02381 3.46634 L
.5 3.46634 L
.5 3.44968 L
F
0 .535 .75 r
.02381 3.46634 m
.02381 3.48301 L
.5 3.48301 L
.5 3.46634 L
F
0 .545 .75 r
.02381 3.48301 m
.02381 3.49967 L
.5 3.49967 L
.5 3.48301 L
F
0 .554 .75 r
.02381 3.49967 m
.02381 3.51633 L
.5 3.51633 L
.5 3.49967 L
F
0 .564 .75 r
.02381 3.51633 m
.02381 3.53299 L
.5 3.53299 L
.5 3.51633 L
F
0 .574 .75 r
.02381 3.53299 m
.02381 3.54965 L
.5 3.54965 L
.5 3.53299 L
F
0 .584 .75 r
.02381 3.54965 m
.02381 3.56631 L
.5 3.56631 L
.5 3.54965 L
F
0 .593 .75 r
.02381 3.56631 m
.02381 3.58297 L
.5 3.58297 L
.5 3.56631 L
F
0 .603 .75 r
.02381 3.58297 m
.02381 3.59963 L
.5 3.59963 L
.5 3.58297 L
F
0 .613 .75 r
.02381 3.59963 m
.02381 3.61629 L
.5 3.61629 L
.5 3.59963 L
F
0 .623 .75 r
.02381 3.61629 m
.02381 3.63296 L
.5 3.63296 L
.5 3.61629 L
F
0 .633 .75 r
.02381 3.63296 m
.02381 3.64962 L
.5 3.64962 L
.5 3.63296 L
F
0 .642 .75 r
.02381 3.64962 m
.02381 3.66628 L
.5 3.66628 L
.5 3.64962 L
F
0 .652 .75 r
.02381 3.66628 m
.02381 3.68294 L
.5 3.68294 L
.5 3.66628 L
F
0 .662 .75 r
.02381 3.68294 m
.02381 3.6996 L
.5 3.6996 L
.5 3.68294 L
F
0 .672 .75 r
.02381 3.6996 m
.02381 3.71626 L
.5 3.71626 L
.5 3.6996 L
F
0 .682 .75 r
.02381 3.71626 m
.02381 3.73292 L
.5 3.73292 L
.5 3.71626 L
F
0 .691 .75 r
.02381 3.73292 m
.02381 3.74958 L
.5 3.74958 L
.5 3.73292 L
F
0 .701 .75 r
.02381 3.74958 m
.02381 3.76624 L
.5 3.76624 L
.5 3.74958 L
F
0 .711 .75 r
.02381 3.76624 m
.02381 3.78291 L
.5 3.78291 L
.5 3.76624 L
F
0 .721 .75 r
.02381 3.78291 m
.02381 3.79957 L
.5 3.79957 L
.5 3.78291 L
F
0 .73 .75 r
.02381 3.79957 m
.02381 3.81623 L
.5 3.81623 L
.5 3.79957 L
F
0 .74 .75 r
.02381 3.81623 m
.02381 3.83289 L
.5 3.83289 L
.5 3.81623 L
F
0 .75 .75 r
.02381 3.83289 m
.02381 3.84955 L
.5 3.84955 L
.5 3.83289 L
F
0 .75 .74 r
.02381 3.84955 m
.02381 3.86621 L
.5 3.86621 L
.5 3.84955 L
F
0 .75 .73 r
.02381 3.86621 m
.02381 3.88287 L
.5 3.88287 L
.5 3.86621 L
F
0 .75 .721 r
.02381 3.88287 m
.02381 3.89953 L
.5 3.89953 L
.5 3.88287 L
F
0 .75 .711 r
.02381 3.89953 m
.02381 3.91619 L
.5 3.91619 L
.5 3.89953 L
F
0 .75 .701 r
.02381 3.91619 m
.02381 3.93286 L
.5 3.93286 L
.5 3.91619 L
F
0 .75 .691 r
.02381 3.93286 m
.02381 3.94952 L
.5 3.94952 L
.5 3.93286 L
F
0 .75 .682 r
.02381 3.94952 m
.02381 3.96618 L
.5 3.96618 L
.5 3.94952 L
F
0 .75 .672 r
.02381 3.96618 m
.02381 3.98284 L
.5 3.98284 L
.5 3.96618 L
F
0 .75 .662 r
.02381 3.98284 m
.02381 3.9995 L
.5 3.9995 L
.5 3.98284 L
F
0 .75 .652 r
.02381 3.9995 m
.02381 4.01616 L
.5 4.01616 L
.5 3.9995 L
F
0 .75 .642 r
.02381 4.01616 m
.02381 4.03282 L
.5 4.03282 L
.5 4.01616 L
F
0 .75 .633 r
.02381 4.03282 m
.02381 4.04948 L
.5 4.04948 L
.5 4.03282 L
F
0 .75 .623 r
.02381 4.04948 m
.02381 4.06614 L
.5 4.06614 L
.5 4.04948 L
F
0 .75 .613 r
.02381 4.06614 m
.02381 4.08281 L
.5 4.08281 L
.5 4.06614 L
F
0 .75 .603 r
.02381 4.08281 m
.02381 4.09947 L
.5 4.09947 L
.5 4.08281 L
F
0 .75 .593 r
.02381 4.09947 m
.02381 4.11613 L
.5 4.11613 L
.5 4.09947 L
F
0 .75 .584 r
.02381 4.11613 m
.02381 4.13279 L
.5 4.13279 L
.5 4.11613 L
F
0 .75 .574 r
.02381 4.13279 m
.02381 4.14945 L
.5 4.14945 L
.5 4.13279 L
F
0 .75 .564 r
.02381 4.14945 m
.02381 4.16611 L
.5 4.16611 L
.5 4.14945 L
F
0 .75 .554 r
.02381 4.16611 m
.02381 4.18277 L
.5 4.18277 L
.5 4.16611 L
F
0 .75 .545 r
.02381 4.18277 m
.02381 4.19943 L
.5 4.19943 L
.5 4.18277 L
F
0 .75 .535 r
.02381 4.19943 m
.02381 4.21609 L
.5 4.21609 L
.5 4.19943 L
F
0 .75 .525 r
.02381 4.21609 m
.02381 4.23276 L
.5 4.23276 L
.5 4.21609 L
F
0 .75 .515 r
.02381 4.23276 m
.02381 4.24942 L
.5 4.24942 L
.5 4.23276 L
F
0 .75 .505 r
.02381 4.24942 m
.02381 4.26608 L
.5 4.26608 L
.5 4.24942 L
F
0 .75 .496 r
.02381 4.26608 m
.02381 4.28274 L
.5 4.28274 L
.5 4.26608 L
F
0 .75 .486 r
.02381 4.28274 m
.02381 4.2994 L
.5 4.2994 L
.5 4.28274 L
F
0 .75 .476 r
.02381 4.2994 m
.02381 4.31606 L
.5 4.31606 L
.5 4.2994 L
F
0 .75 .466 r
.02381 4.31606 m
.02381 4.33272 L
.5 4.33272 L
.5 4.31606 L
F
0 .75 .457 r
.02381 4.33272 m
.02381 4.34938 L
.5 4.34938 L
.5 4.33272 L
F
0 .75 .447 r
.02381 4.34938 m
.02381 4.36604 L
.5 4.36604 L
.5 4.34938 L
F
0 .75 .437 r
.02381 4.36604 m
.02381 4.38271 L
.5 4.38271 L
.5 4.36604 L
F
0 .75 .427 r
.02381 4.38271 m
.02381 4.39937 L
.5 4.39937 L
.5 4.38271 L
F
0 .75 .417 r
.02381 4.39937 m
.02381 4.41603 L
.5 4.41603 L
.5 4.39937 L
F
0 .75 .408 r
.02381 4.41603 m
.02381 4.43269 L
.5 4.43269 L
.5 4.41603 L
F
0 .75 .398 r
.02381 4.43269 m
.02381 4.44935 L
.5 4.44935 L
.5 4.43269 L
F
0 .75 .388 r
.02381 4.44935 m
.02381 4.46601 L
.5 4.46601 L
.5 4.44935 L
F
0 .75 .378 r
.02381 4.46601 m
.02381 4.48267 L
.5 4.48267 L
.5 4.46601 L
F
0 .75 .368 r
.02381 4.48267 m
.02381 4.49933 L
.5 4.49933 L
.5 4.48267 L
F
0 .75 .359 r
.02381 4.49933 m
.02381 4.51599 L
.5 4.51599 L
.5 4.49933 L
F
0 .75 .349 r
.02381 4.51599 m
.02381 4.53266 L
.5 4.53266 L
.5 4.51599 L
F
0 .75 .339 r
.02381 4.53266 m
.02381 4.54932 L
.5 4.54932 L
.5 4.53266 L
F
0 .75 .329 r
.02381 4.54932 m
.02381 4.56598 L
.5 4.56598 L
.5 4.54932 L
F
0 .75 .32 r
.02381 4.56598 m
.02381 4.58264 L
.5 4.58264 L
.5 4.56598 L
F
0 .75 .31 r
.02381 4.58264 m
.02381 4.5993 L
.5 4.5993 L
.5 4.58264 L
F
0 .75 .3 r
.02381 4.5993 m
.02381 4.61596 L
.5 4.61596 L
.5 4.5993 L
F
0 .75 .29 r
.02381 4.61596 m
.02381 4.63262 L
.5 4.63262 L
.5 4.61596 L
F
0 .75 .28 r
.02381 4.63262 m
.02381 4.64928 L
.5 4.64928 L
.5 4.63262 L
F
0 .75 .271 r
.02381 4.64928 m
.02381 4.66594 L
.5 4.66594 L
.5 4.64928 L
F
0 .75 .261 r
.02381 4.66594 m
.02381 4.68261 L
.5 4.68261 L
.5 4.66594 L
F
0 .75 .251 r
.02381 4.68261 m
.02381 4.69927 L
.5 4.69927 L
.5 4.68261 L
F
0 .75 .241 r
.02381 4.69927 m
.02381 4.71593 L
.5 4.71593 L
.5 4.69927 L
F
0 .75 .232 r
.02381 4.71593 m
.02381 4.73259 L
.5 4.73259 L
.5 4.71593 L
F
0 .75 .222 r
.02381 4.73259 m
.02381 4.74925 L
.5 4.74925 L
.5 4.73259 L
F
0 .75 .212 r
.02381 4.74925 m
.02381 4.76591 L
.5 4.76591 L
.5 4.74925 L
F
0 .75 .202 r
.02381 4.76591 m
.02381 4.78257 L
.5 4.78257 L
.5 4.76591 L
F
0 .75 .192 r
.02381 4.78257 m
.02381 4.79923 L
.5 4.79923 L
.5 4.78257 L
F
0 .75 .183 r
.02381 4.79923 m
.02381 4.81589 L
.5 4.81589 L
.5 4.79923 L
F
0 .75 .173 r
.02381 4.81589 m
.02381 4.83256 L
.5 4.83256 L
.5 4.81589 L
F
0 .75 .163 r
.02381 4.83256 m
.02381 4.84922 L
.5 4.84922 L
.5 4.83256 L
F
0 .75 .153 r
.02381 4.84922 m
.02381 4.86588 L
.5 4.86588 L
.5 4.84922 L
F
0 .75 .143 r
.02381 4.86588 m
.02381 4.88254 L
.5 4.88254 L
.5 4.86588 L
F
0 .75 .134 r
.02381 4.88254 m
.02381 4.8992 L
.5 4.8992 L
.5 4.88254 L
F
0 .75 .124 r
.02381 4.8992 m
.02381 4.91586 L
.5 4.91586 L
.5 4.8992 L
F
0 .75 .114 r
.02381 4.91586 m
.02381 4.93252 L
.5 4.93252 L
.5 4.91586 L
F
0 .75 .104 r
.02381 4.93252 m
.02381 4.94918 L
.5 4.94918 L
.5 4.93252 L
F
0 .75 .095 r
.02381 4.94918 m
.02381 4.96584 L
.5 4.96584 L
.5 4.94918 L
F
0 .75 .085 r
.02381 4.96584 m
.02381 4.98251 L
.5 4.98251 L
.5 4.96584 L
F
0 .75 .075 r
.02381 4.98251 m
.02381 4.99917 L
.5 4.99917 L
.5 4.98251 L
F
0 g
gsave
.52381 4.99084 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(3) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 1.4104 L
0 1.4104 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[116]:=",
  ImageSize->{204.188, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003<000181000`40O003h00Oc7oo003<Ool00<ao
o`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<ao
o`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<ao
o`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<ao
o`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<ao
o`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<ao
o`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<Qo
o`80009oo`00`Woo100017oo0@000Goo002iOol7G009Ool10001Ool1Ool00;Uoo`ML0@Yoo`40005o
o`00^Goo1e`227oo00<007oo00000Goo002iOol7G0@9Ool10001Ool1Ool00;Uoo`ML1@aoo`00^Goo
1e`637oo002iOol7G0P<Ool00;Uoo`ML2@aoo`00^Goo1e`;37oo002iOol7G0`<Ool00;Uoo`ML3@ao
o`00^Goo1e`?37oo001IOol20003Ool20003Ool2001DOol7G10<Ool005Uoo`03001oogoo00Aoo`05
001oogooOol0001DOol7G14<Ool004Yoo`<00004Ool007ooOol20006Ool00`00Oomoo`02Ool30003
Ool00`00Oomoo`1BOol7G1<<Ool004]oo`06001oogoo001oo`0027oo00D007ooOomoo`00009oo`05
001oogooOol0001DOol7G1@<Ool004]oo`<0009oo`<000Ioo`05001oogooOol00002Ool01@00Oomo
ogoo0000E7oo1e`F37oo001;Ool01@00Oomoo`00Ool00`001Woo00<007ooOol00Woo0`000goo00<0
07ooOol0DWoo1e`G37oo001;Ool01000Oomoo`002Woo00<007ooOol027oo00<007ooOol0DWoo1ePG
37oo001:Ool4000;Ool20008Ool2001DOol7D1L<Ool00;Uoo`M<5`aoo`00^Goo1dPG37oo002iOol7
@1L<Ool004=oo`D0009oo`03001oogoo00D00003Ool007oo00=oo`04001oogooOol20004Ool30000
0goo000000020003Ool30019Ool7?1L<Ool004Eoo`03001oogoo00Eoo`<0009oo`03001oo`00009o
o`03001oo`00009oo`03001oo`0000Aoo`04001oo`000006Ool00`00Oomoo`19Ool7=1L<Ool003mo
o`<000=oo`03001oogoo00@00004Ool000000002Ool30002Ool30002Ool00`00Ool00002Ool50000
0goo001oo`05Ool00`00Oomoo`18Ool7<1L<Ool004Eoo`03001oogoo00Eoo`03001oo`00009oo`03
001oo`00009oo`<0009oo`<0009oo`07001oo`00Ool007oo00001Woo00<007ooOol0B7oo1b`G37oo
0015Ool00`00Oomoo`05Ool4000017oo001oo`000Woo00<007oo00000Woo00<007oo00000goo0P00
00Eoo`00001oo`0000Aoo`03001oo`0004Uoo`LT5`aoo`00A7oo0P0027oo0P000goo00<007ooOol0
0Woo00<007ooOol00Woo0P0017oo0P000Woo00<007ooOol017oo00<007ooOol0B7oo1b0G37oo002i
Ool771L<Ool00;Uoo`LD5`aoo`00Agoo1P0000ANm`00001Nm`D0009Nm`<00003G_L0000000<00005
03L00000001Nm`06001=Ool741L<Ool004Moo`8000=oo`03G_L007oo009oo`03G_Moogoo009Nm`03
001oogoo009oo`03G_Moogoo009oo`030000=goo009oo`07G_MoogooOol007oo0000CGoo1``G37oo
0017Ool>O007Ool00ekgOomoo`02Ool00`0gG_MNm`05G_L2Ool00`00Oomoo`1;Ool711L<Ool004Mo
o`03001ooekg00Ioo`=Nm`9oo`=l00Aoo`ENm`0503MoogooOomNm`03Ool3G_M=Ool701L<Ool004Mo
o`9Nm`Ioo`05G_MoogooOomNm`04Ool2O003G_L4Ool01@0gOomoogooG_L01Goo00<007ooOol0Bgoo
1`0G37oo0017Ool00ekgOomoo`03Ool2G_L5Ool5G_L01GooO01l07`0G_L00goo00D0EgooOomooekg
00Eoo`03001oogoo04]oo`L0=`aoo`00Agoo00<005kgOol00Woo00=NmgooOol017oo0Ukg27oo0g`0
00=oo`1GG_L01Ekg0goo00<007ooOol0Bgoo1`1g37oo0017Ool00`00OomNm`02G_L6Ool015kgOomo
oekg1Goo1Ekg0W`00goo00=NmgooOol015kgCGoo1`2G37oo0011Ool500001Woo001ooekgOomNm`Ao
o`9Nm`Aoo`03G_Mooekg009Nm`=oo`05G_Moogoo05Ml0002Ool00ekgOomoo`03Ool00`00Oomoo`1;
Ool70;L<Ool004=oo`06001oogooOol005kg0goo00ANmgooOomNm`Ioo`9Nm`Ioo`08G_Moogoo07Mo
og`0OomNm`Eoo`03001oogoo04]oo`L0m`aoo`00?Goo0`000goo00D007ooOomooekg00Eoo`9Nm`Io
o`03G_Mooekg00Ioo`03G_L07`0O00T07`8004eoo`L15`aoo`00@goo00D007ooOomoo`0000Aoo`04
G_MooekgG_L3Ool2G_L3Ool015kgOomoogoo0`0O00=Nm`1gOol00goo00=l07ooOol00Woo0P0OCGoo
1`4g37oo0013Ool01@00Oomoogoo00000Woo0Ukg17oo00=NmgooG_L01Woo00=Nm`0O01l00goo00=N
m`1gOol00goo00=Nmg`0O0000goo00=NmgooOol0Bgoo1`5g37oo0012Ool20003Ool00`00OomNm`07
Ool00ekgOomoo`04Ool201l5Ool00ekg09Moo`03Ool01ekgOomoog`0OomNm`0004eoo`L1U`aoo`00
Agoo00<005kgOol01Woo00=NmgooG_L00goo0P0O0Woo00=NmgooOol00goo00<0UekgG_L01Ukg00=l
05kg0000CGoo1`7G37oo0017Ool2G_L5Ool2G_L3Ool2G_L00`0OOomoo`03Ool5G_L00`2gOomoo`02
Ool01EkgOomoogooO0000UkgCGoo1`7g37oo0017Ool015kgOomNmekg0Woo00=NmgooOol00goo0P0O
00=NmgooOol00Woo0ekg0goo00<0]ekgOol00Woo00MNmgooOomooekgO000001=Ool70QL<Ool004Mo
o`/3h00501moogooOomNm`02Ool015kgOomooekg0goo00<0eekgOol00Woo00MNmgooOomooekgOoml
001=Ool70UL<Ool003Uoo`03001oogoo009oo`03001oogoo009oo`05001oogooOol00003Ool015kg
OomNmekg0Woo00<07goo0n000goo0Ukg17oo00ANmgoo0?L0e`UNm`03Ool007oo04aoo`L2M`aoo`00
>7oo00<007oo00001goo00<007oo00000Woo00D007ooOomooekg00=oo`03G_L07goo009oo`83h004
OomNmekgG_L4Ool01Ekg0AMoogooG_L00Woo00ENmgooOomNmgoo009Nmdeoo`L2]`aoo`00<goo0`00
0Woo00<007oo00002Goo00@007ooOol0009oo`03G_Moogoo00=oo`0301mNmekg009oo`03G_L3h0?P
009oo`03G_Moogoo009Nm`040CMoogooG_L2Ool01EkgOomooekgOol00P00CGoo1`;G37oo000hOol0
0`00Ool00007Ool20003Ool01000Oomooekg17oo00@07gooOomoo`9Nm`=oo`030n1oogoo009Nm`03
Ool1E`4g009oo`04G_MoogooG_L2Ool015kgOomooekgCGoo1`;g37oo000hOol00`00Ool00007Ool0
0`00Oomoo`02Ool01000Oomooekg0goo00<07gooOol00goo15kg00Qoo`?P0n1ooekgOol1Mgoo2ekg
00<007ooOol0Bgoo1`;e37oo000iOol00`00Oomoo`06Ool30002Ool3G_L4Ool00`0OOomoo`02Ool0
0ekgOomoo`02Ool2G_L01Woo0n1ooekg0IMoo`9Nm`07OomNmgooG_MooekgOol00ekgCGoo1`;d37oo
0017Ool00`00OomNm`03G_L00`0OG_Moo`03Ool00ekgOomoo`02Ool055kgOomNmekg0n01]`6GG_Mo
oekgOomNmgooG_MooekgOomNmgoo001=Ool70_<<Ool004Moo`03001ooekg00=oo`0301mooekg00AN
m`=oo`03G_Moogoo009oo`080n01egooOomNmgooG_Moo`=Nm`05OomNmgooOomNm`1=Ool70_4<Ool0
01eoo`8000=oo`8000=oo`8001ioo`03001Nmgoo00=oo`0301moogoo009oo`03G_Mooekg00ANm`=o
o`050n025ekgG_Moo`0:G_L00`00Oomoo`1;Ool70_0<Ool001eoo`03001oogoo00Aoo`05001oogoo
Ool0000JOol01P00Oomoogoo001Nm`Aoo`0301moogoo009oo`03G_Moogoo009oo`03G_Mooekg00=N
m`030n02=goo00MNm`03OomNmekg009Nmdeoo`L2k`aoo`003goo0`0000Ioo`00Ool007oo0005Ool0
0`00Oomoo`02Ool30003Ool00`00Oomoo`0GOol00`00Ool00002Ool00`00G_Moo`03Ool00`0OOomo
o`02Ool01EkgOomoogooG_L017oo00]Nmgoo0n02EekgG1EL55`BG11L3U`900INmdeoo`L2k@aoo`00
47oo00P007ooOol007oo001oo`001Goo00D007ooOomoo`00009oo`05001oogooOol0000IOol00`00
Ool00002Ool6G_L00`0OG_MNm`0=G_L010?P0YL2Ue`F0ekg00=L2P;RG_L01EkgCGoo1`;/37oo000@
Ool02000Oomoo`00Ool007oo0005Ool01@00Oomoogoo00000Woo00D007ooOomoo`0001Uoo`03001o
o`00009oo`03001Nmgoo00=oo`0301moogoo009oo`05G_MoogooOomNm`04Ool01UkgOol3h5@G0[L2
e`=Nm`030^/2hUkg00=Nm`03Ool007oo04aoo`L2jPaoo`0047oo00<007ooOol00P0000=oo`00Ool0
1Goo00<007ooOol00Woo0`000goo00<007ooOol05goo00<007oo00000Woo00<005kgOol00goo00<0
7gooOol00Woo00ENmgooOomooekg00Aoo`9Nm`080n1<5goo0_L2m@;c0_02k0MNmdeoo`L2j@aoo`00
47oo00<007ooOol02Woo00<007ooOol027oo00<007ooOol067oo00H007ooOomoo`00G_L4Ool00`0O
Oomoo`02Ool00ekgOomoo`02Ool4G_L017oo0n185d`G3EkgCGoo1`;X37oo000?Ool3000;Ool20008
Ool2000NOol00`00G_Moo`03Ool00`0OOomoo`02Ool6G_L4Ool01P?PA1MNmgooG_Moo`MNm`03OomN
m`0004eoo`L2iPaoo`00Agoo00<007ooG_L00goo00<07ekgG_L00Ukg00=ooekgOol00Woo011Nmgoo
Oomooekg0n0l5gooG_MooekgOomNmgooG_Moo`9Nm`9oo`03G_Moogoo04]oo`L2i@aoo`00Agoo00<0
07ooG_L00ekg00<07gooOol00goo00=NmgooOol00Woo0ekg0143h7oo?1Lh5ekgOomNmgooG_Mooekg
OomNmgooG_Moo`0004eoo`L2i09oo`8000Qoo`00Agoo0ekg17oo00<07gooOol00goo00=NmgooOol0
0ekg00Moo`?POomNmc@GOomNm`02Ool01EkgOomNmgooG_L00Woo0UkgCGoo1`;R17oo00<007ooOol0
1Goo000iOol00`00Oomoo`02Ool00`00Oomoo`02Ool01@00Oomoogoo00000Woo00ENmgooOomoo`0O
00Eoo`=Nm`=oo`070n1NmekgOol`5ekgOol02Ukg00<007ooOol0Bgoo1`;Q0goo00<007ooOol01Woo
000hOol00`00Ool00007Ool00`00Ool00002Ool01000Oomooekg17oo00@07gooOomoo`=Nm`9oo`83
h09Nm`9oo`8/5`9oo`04G_MoogooG_L2Ool015kgOomooekgF7oo00<007ooOol01Goo000hOol00`00
Ool00009Ool01000Oomoo`000Woo00=NmgooOol00goo00<07ekgG_L00Woo00ENmgoo0n1ooekg009o
o`=Nm`04:1MoogooG_L2Ool01EkgOomooekgOol00P00EWoo00<007oo00001goo000hOol00`00Ool0
0007Ool20003Ool01@00OomoogooG_L00goo0Ukg00@07gooOomoo`83h09Nm`Aoo`9Nm`0391Mooekg
00=oo`04G_MoogooG_L2Ool00ekgOomoo`1EOol00`00Oomoo`06Ool003Qoo`03001oo`0000Moo`03
001oogoo009oo`060n1oogooOomNmgoo0Ukg0Woo00@07goo0n03h09oo`9Nm`Aoo`04G_Moob@G81L:
G_L00`00Oomoo`1NOol003Uoo`03001oogoo00Ioo`<0009oo`03G_L3h0?P00P3h00301moogoo009N
m`9oo`04G_MoogooG_L3Ool00b0GG_Moo`02Ool01ekgOomoogooG_Moog`0061oo`00Agoo00ANmgoo
G_MNm`9oo`03G_Moogoo00=oo`0301mNmgoo00Aoo`9Nm`Aoo`0371Moogoo009oo`07G_MoogooOomN
mg`00000H7oo0017Ool2G_L5Ool2G_L3Ool00ekg01l07`04Ool6G_L00a`GOomoo`02Ool01EkgOomo
ogooO0000UkgH7oo0017Ool00`00G_Moo`06Ool00ekgOomNm`03Ool201l2Ool00ekgOomoo`03Ool0
0aPGG_MNm`06G_L00g`0G_L0001POol004Moo`03001ooekg00Moo`03G_Moogoo00Aoo`0301mNmgoo
00Aoo`03G_LH5goo00=oo`07G_MoogooO01ooekg0000H7oo0011Ool5000017oo001oogoo0Ukg0goo
0Ukg00=ooekgOol017oo00ANm`0O01l07`=oo`03G_LD5goo00=oo`03G_Ml07`000=oo`03G_Moogoo
05ioo`00@goo00D007ooOomoo`0000Aoo`03G_Mooekg00Aoo`9Nm`=oo`04G_MoogooOol301l00ekg
51Moo`03Ool00g`0Oomoo`03Ool00`0OOomoo`1NOol004=oo`05001oogooOomNm`05Ool2G_L6Ool0
0ekgOomNm`06Ool00ekg01l07`0:01l00`00Oomoo`1NOol004=oo`06001oogooOol005kg0goo00AN
mgooOomNm`Ioo`9Nm`Ioo`08G_Moogoo51Moog`0OomNm`Eoo`03001oogoo05ioo`00@goo00T007oo
Oomoo`00OomNmgooG_L017oo00=NmgooOol00goo00ANmgooG_MNm`Aoo`05G_Moogoo51Ml0002Ool0
0ekgOomoo`03Ool00`00Oomoo`1NOol0049oo`8000=oo`03001ooekg009Nm`Eoo`9Nm`9oo`03G_Mo
ogoo009oo`INm`9l00=oo`04G_MoogooOol3G_MPOol004Moo`03001Nmgoo009oo`03G_Moogoo00Ao
o`9Nm`Qoo`05G_Ml07`0Ool@5`07G_L2Ool00`00Oomoo`1NOol004Moo`03G_Moogoo00=oo`03G_Mo
ogoo00=oo`03G_Mooekg009Nm`=oo`=l00=oo`0541MoogooOomNm`05Ool00`00Oomoo`1NOol004Mo
o`03G_Moogoo00Aoo`9Nm`=oo`03G_Moogoo009oo`03G_Ml07`0009Nm`Aoo`0541MoogooOomNm`05
Ool00`00Oomoo`1NOol004Moo`03001Nmekg00Ioo`03G_Mooekg00=oo`=l00=oo`ENm`0541Moogoo
OomNm`04Ool2G_MPOol003Moo`D0009oo`03001oogoo009oo`04001oogooOol?O006Ool00ekgOomo
o`02Ool00a0GG_MNm`06G_L00goo001oo`1OOol003Uoo`03001oogoo00Ioo`03001oo`00009oo`80
009oo`9Nm`06001oogooOomNmgoo0ekg00<007ooOol00Woo00=NmgooOol00Woo00<0010GOol00Woo
00MNmgooOomoo`00Ool0001POol003Uoo`03001oogoo00Qoo`03001oogoo00H00004G_L00000G_L5
0002G_L300000ekg0000000300001A0G00000000G_L01P00H7oo000iOol00`00Oomoo`06Ool20028
Ool003Uoo`03001oogoo00Ioo`03001oogoo08Moo`00>7oo0P0027oo0`00Qgoo003<Ool00<aoo`00
c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00;goo00<007ooOol0=Goo
00<007ooOol02Goo00<007ooOol0=7oo00<007ooOol07goo000^Ool00`00Oomoo`0@Ool00`00Oomo
o`0GOol00`00Oomoo`0:Ool00`00Oomoo`07Ool00`00Oomoo`0@Ool00`00Oomoo`0FOol00`00Oomo
o`0:Ool00`00Oomoo`0NOol002Aoo`<000Ioo`03001oogoo009oo`<000aoo`03001oogoo00Aoo`<0
00Eoo`<000Qoo`03001oogoo00=oo`<000Eoo`03001oogoo00Eoo`03001oogoo009oo`<000aoo`03
001oogoo00=oo`<000Ioo`<000Moo`03001oogoo00Aoo`<000Aoo`03001oogoo01eoo`009Woo0P00
1Goo00<007ooOol017oo0P002Goo1@0017oo00<007ooOol01goo0P001Goo1@000goo00<007ooOol0
1Goo00<007ooOol01Goo00<007ooOol017oo0P002Goo1@000goo00<007ooOol027oo0P0017oo1@00
1Goo00<007ooOol00goo00<007ooOol07Goo000UOol00`00Oomoo`05Ool00`00Oomoo`03Ool00`00
Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`07Ool00`00Oomoo`04Ool00`00
Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`03Ool00`00Oomoo`0;Ool00`00Oomoo`04Ool00`00
Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`03Ool40004Ool00`00Oomoo`0MOol002Eoo`<000Eo
o`03001oogoo00=oo`<0009oo`<000Ioo`03001oogoo00Eoo`03001oogoo00Eoo`<000Moo`03001o
ogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00=oo`<0009oo`<000Ioo`03001o
ogoo00Aoo`03001oogoo00Ioo`<000Ioo`03001oogoo00=oo`03001oo`0000Eoo`03001oogoo01eo
o`0027oo0P0027oo0P006Woo00<007ooOol01goo0P003Woo00<007oo00005Woo00<007oo000017oo
00<007ooOol01goo00<007ooOol01goo0P003Goo00<007oo00005goo0P0017oo00<007ooOol07Woo
0008Ool00`00Oomoo`08Ool00`00Oomoo`0IOol00`00Oomoo`08Ool00`00Oomoo`0<Ool00`00Oomo
o`0FOol00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`0;Ool00`00Oomo
o`0GOol01@00Oomoogoo00008Goo00000goo00000005Ool01000Oomoogoo0P001Goo00<007ooOol0
0Woo10007Woo00<007ooOol0@Goo00<007ooOol0Bgoo00000`00Ool00005Ool00`00Oomoo`03Ool0
0`00Oomoo`02Ool00`00Oomoo`0;Oon@000KOol00004001oo`000004Ool00`00Oomoo`02Ool00`00
Oomoo`03Ool00`00Oomoo`02Ool4002`Ool00003001oogoo00Eoo`03001oogoo009oo`8000Aoo`03
001oogoo0;Ioo`0000<007ooOol01Goo00<007ooOol027oo00<007ooOol0>7oo00<007ooOol05goo
00<007ooOol027oo00<007ooOol08Woo00<007ooOol0<Goo00030005Ool20008Ool2000iOol00`00
Oomoo`0;Ool00`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`0@Ool00`00Oomoo`0AOol00`00
Oomoo`0`Ool003Moo`03001oogoo009oo`04001oogooOol30009Ool00`00Oomoo`02Ool30007Ool0
0`00Oomoo`03Ool50004Ool00`00Oomoo`04Ool00`00Oomoo`02Ool3000<Ool00`00Oomoo`03Ool5
000017oo000000001Woo00<007ooOol0;goo000fOol00`00Ool00007Ool00`00Oomoo`09Ool00`00
Oomoo`04Ool20004Ool50005Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool20009
Ool50005Ool01@00Oomoogoo000027oo00<007ooOol0;goo000fOol00`00Ool00008Ool00`00Oomo
o`08Ool00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomo
o`04Ool00`00Oomoo`03Ool00`00Oomoo`0;Ool00`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomo
o`05Ool00`00Oomoo`0_Ool003Ioo`03001oo`0000Qoo`03001oogoo00Qoo`03001oogoo00=oo`<0
00Ioo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00=oo`<000]oo`03
001oogoo00Eoo`03001oogoo009oo`03001oogoo00Eoo`03001oogoo02moo`00=Woo00<007oo0000
1goo00<007oo00002Woo00<007ooOol04goo00<007ooOol00goo00<007ooOol01Woo00<007ooOol0
1goo0`003Woo00L007ooOomoo`00Ool00005Ool00`00Oomoo`0`Ool003Moo`03001oogoo00Moo`03
001oogoo00Yoo`03001oogoo015oo`8000Aoo`03001oogoo00Qoo`03001oogoo00Ioo`8000ioo`80
00Aoo`03001oogoo00=oo`03001oogoo035oo`00OWoo00<007ooOol0Bgoo001nOol00`00Oomoo`1;
Ool007aoo`<004eoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00
c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00
c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00
c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00
c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00
c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00
c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00c7oo003<Ool00<aoo`00
c7oo003<Ool00<aoo`00\
\>"],
  ImageRangeCache->{{{0, 203.188}, {287, 0}} -> {-0.653492, -1.05157, \
0.00732796, 0.00732796}, {{4.8125, 173.5}, {279.938, 7}} -> {-4.20621, \
-6.9881, 0.0415698, 0.0513831}, {{184.688, 198.313}, {211.688, 143.5}} -> \
{-28.5159, -331.955, 0.15413, 4.40519}},
  CellTags->{"Nyquist Plot", "i:10"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[117]=",
  CellTags->{"Nyquist Plot", "i:10"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Root Locus", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"Root Locus", "i:11"}],

Cell["\<\
To compute the root locus plot for values of the gain k ranging from 0 to 40 \
in steps of nominally unit length (40 steps). Actually, the gain is changed \
in a nonlinear fashion to achieve more uniform spacing of the computed \
points. The gain can be roughly estimated from the color scale. \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"Root Locus", "i:11"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(RootLocus[G, s, k, 0, \(+40. \), 1. ]\)], "Input",
  CellLabel->"In[118]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Root Locus", "i:11"}],

Cell[BoxData[
    \(\*"\"\<\\n                Zeros in green, Open loop poles in red\>"\)], \
"Print",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Root Locus", "i:11"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.4104 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.438894 0.671621 0.705202 0.671621 [
[ 0 0 0 0 ]
[ 1 1.4104 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.0238095 0.033581 0.853978 1.37682 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.777239 0.0706581 0.809017 0.176047 [
[.07066 -0.0125 -9 -9 ]
[.07066 -0.0125 9 0 ]
[.21197 -0.0125 -6 -9 ]
[.21197 -0.0125 6 0 ]
[.35329 -0.0125 -6 -9 ]
[.35329 -0.0125 6 0 ]
[.49461 -0.0125 -6 -9 ]
[.49461 -0.0125 6 0 ]
[.63592 -0.0125 -6 -9 ]
[.63592 -0.0125 6 0 ]
[.77724 -0.0125 -3 -9 ]
[.77724 -0.0125 3 0 ]
[.91856 -0.0125 -3 -9 ]
[.91856 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -17 -21.875 ]
[.5 -0.0125 17 -9 ]
[-0.0125 .10483 -12 -4.5 ]
[-0.0125 .10483 0 4.5 ]
[-0.0125 .45692 -12 -4.5 ]
[-0.0125 .45692 0 4.5 ]
[-0.0125 .80902 -6 -4.5 ]
[-0.0125 .80902 0 4.5 ]
[-0.0125 1.16111 -6 -4.5 ]
[-0.0125 1.16111 0 4.5 ]
[-0.0125 1.5132 -6 -4.5 ]
[-0.0125 1.5132 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .80902 -46.25 -6.4375 ]
[-0.01875 .80902 -12 6.4375 ]
[ 0 1.61803 .125 0 ]
[.5 1.63053 -5 0 ]
[.5 1.63053 5 12.875 ]
[ 1 0 .125 0 ]
[1.0125 .80902 0 -6.4375 ]
[1.0125 .80902 10 6.4375 ]
[.5 1.63053 -101.781 12.875 ]
[.5 1.63053 101.781 35.4375 ]
[ 0 0 0 0 ]
[ 1 1.61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.07066 0 m
.07066 .00625 L
s
[(-10)] .07066 -0.0125 0 1 Mshowa
.21197 0 m
.21197 .00625 L
s
[(-8)] .21197 -0.0125 0 1 Mshowa
.35329 0 m
.35329 .00625 L
s
[(-6)] .35329 -0.0125 0 1 Mshowa
.49461 0 m
.49461 .00625 L
s
[(-4)] .49461 -0.0125 0 1 Mshowa
.63592 0 m
.63592 .00625 L
s
[(-2)] .63592 -0.0125 0 1 Mshowa
.77724 0 m
.77724 .00625 L
s
[(0)] .77724 -0.0125 0 1 Mshowa
.91856 0 m
.91856 .00625 L
s
[(2)] .91856 -0.0125 0 1 Mshowa
.125 Mabswid
.10599 0 m
.10599 .00375 L
s
.14132 0 m
.14132 .00375 L
s
.17665 0 m
.17665 .00375 L
s
.2473 0 m
.2473 .00375 L
s
.28263 0 m
.28263 .00375 L
s
.31796 0 m
.31796 .00375 L
s
.38862 0 m
.38862 .00375 L
s
.42395 0 m
.42395 .00375 L
s
.45928 0 m
.45928 .00375 L
s
.52994 0 m
.52994 .00375 L
s
.56526 0 m
.56526 .00375 L
s
.60059 0 m
.60059 .00375 L
s
.67125 0 m
.67125 .00375 L
s
.70658 0 m
.70658 .00375 L
s
.74191 0 m
.74191 .00375 L
s
.81257 0 m
.81257 .00375 L
s
.8479 0 m
.8479 .00375 L
s
.88323 0 m
.88323 .00375 L
s
.03533 0 m
.03533 .00375 L
s
.95388 0 m
.95388 .00375 L
s
.98921 0 m
.98921 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -78 -25.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Re) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
75.000000 13.000000 moveto
(@) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
87.000000 13.000000 moveto
(D) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
0 .10483 m
.00625 .10483 L
s
[(-4)] -0.0125 .10483 1 0 Mshowa
0 .45692 m
.00625 .45692 L
s
[(-2)] -0.0125 .45692 1 0 Mshowa
0 .80902 m
.00625 .80902 L
s
[(0)] -0.0125 .80902 1 0 Mshowa
0 1.16111 m
.00625 1.16111 L
s
[(2)] -0.0125 1.16111 1 0 Mshowa
0 1.5132 m
.00625 1.5132 L
s
[(4)] -0.0125 1.5132 1 0 Mshowa
.125 Mabswid
0 .19285 m
.00375 .19285 L
s
0 .28088 m
.00375 .28088 L
s
0 .3689 m
.00375 .3689 L
s
0 .54495 m
.00375 .54495 L
s
0 .63297 m
.00375 .63297 L
s
0 .72099 m
.00375 .72099 L
s
0 .89704 m
.00375 .89704 L
s
0 .98506 m
.00375 .98506 L
s
0 1.07309 m
.00375 1.07309 L
s
0 1.24913 m
.00375 1.24913 L
s
0 1.33716 m
.00375 1.33716 L
s
0 1.42518 m
.00375 1.42518 L
s
0 .01681 m
.00375 .01681 L
s
0 1.60123 m
.00375 1.60123 L
s
.25 Mabswid
0 0 m
0 1.61803 L
s
gsave
-0.01875 .80902 -107.25 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Im) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
75.250000 13.000000 moveto
(@) show
81.250000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
87.250000 13.000000 moveto
(D) show
93.250000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
.07066 1.61178 m
.07066 1.61803 L
s
.21197 1.61178 m
.21197 1.61803 L
s
.35329 1.61178 m
.35329 1.61803 L
s
.49461 1.61178 m
.49461 1.61803 L
s
.63592 1.61178 m
.63592 1.61803 L
s
.77724 1.61178 m
.77724 1.61803 L
s
.91856 1.61178 m
.91856 1.61803 L
s
.125 Mabswid
.10599 1.61428 m
.10599 1.61803 L
s
.14132 1.61428 m
.14132 1.61803 L
s
.17665 1.61428 m
.17665 1.61803 L
s
.2473 1.61428 m
.2473 1.61803 L
s
.28263 1.61428 m
.28263 1.61803 L
s
.31796 1.61428 m
.31796 1.61803 L
s
.38862 1.61428 m
.38862 1.61803 L
s
.42395 1.61428 m
.42395 1.61803 L
s
.45928 1.61428 m
.45928 1.61803 L
s
.52994 1.61428 m
.52994 1.61803 L
s
.56526 1.61428 m
.56526 1.61803 L
s
.60059 1.61428 m
.60059 1.61803 L
s
.67125 1.61428 m
.67125 1.61803 L
s
.70658 1.61428 m
.70658 1.61803 L
s
.74191 1.61428 m
.74191 1.61803 L
s
.81257 1.61428 m
.81257 1.61803 L
s
.8479 1.61428 m
.8479 1.61803 L
s
.88323 1.61428 m
.88323 1.61803 L
s
.03533 1.61428 m
.03533 1.61803 L
s
.95388 1.61428 m
.95388 1.61803 L
s
.98921 1.61428 m
.98921 1.61803 L
s
.25 Mabswid
0 1.61803 m
1 1.61803 L
s
gsave
.5 1.63053 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
69.000000 13.000000 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.99375 .10483 m
1 .10483 L
s
.99375 .45692 m
1 .45692 L
s
.99375 .80902 m
1 .80902 L
s
.99375 1.16111 m
1 1.16111 L
s
.99375 1.5132 m
1 1.5132 L
s
.125 Mabswid
.99625 .19285 m
1 .19285 L
s
.99625 .28088 m
1 .28088 L
s
.99625 .3689 m
1 .3689 L
s
.99625 .54495 m
1 .54495 L
s
.99625 .63297 m
1 .63297 L
s
.99625 .72099 m
1 .72099 L
s
.99625 .89704 m
1 .89704 L
s
.99625 .98506 m
1 .98506 L
s
.99625 1.07309 m
1 1.07309 L
s
.99625 1.24913 m
1 1.24913 L
s
.99625 1.33716 m
1 1.33716 L
s
.99625 1.42518 m
1 1.42518 L
s
.99625 .01681 m
1 .01681 L
s
.99625 1.60123 m
1 1.60123 L
s
.25 Mabswid
1 0 m
1 1.61803 L
s
gsave
1.0125 .80902 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
69.000000 13.000000 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.5 1.63053 -162.781 8.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30.5625 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 26.562500 moveto
 460.000000 26.562500 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 26.562500 lineto
closepath
clip newpath
63.000000 17.312500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.312500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(G) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
69.000000 17.312500 moveto
(@) show
75.000000 17.312500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
81.000000 17.312500 moveto
(D) show
87.000000 17.312500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(=) show
93.000000 17.312500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
140.000000 11.250000 moveto
(H) show
146.000000 11.250000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
154.375000 11.250000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
162.750000 11.250000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
168.750000 11.250000 moveto
(L) show
177.375000 11.250000 moveto
(H) show
183.375000 11.250000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
191.750000 11.250000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
200.125000 11.250000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
212.125000 11.250000 moveto
(L) show
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
97.375000 17.312500 moveto
(\\200) show
99.250000 17.312500 moveto
(\\200) show
101.125000 17.312500 moveto
(\\200) show
103.000000 17.312500 moveto
(\\200) show
104.875000 17.312500 moveto
(\\200) show
106.750000 17.312500 moveto
(\\200) show
108.625000 17.312500 moveto
(\\200) show
110.500000 17.312500 moveto
(\\200) show
112.375000 17.312500 moveto
(\\200) show
114.250000 17.312500 moveto
(\\200) show
116.125000 17.312500 moveto
(\\200) show
118.000000 17.312500 moveto
(\\200) show
119.875000 17.312500 moveto
(\\200) show
121.750000 17.312500 moveto
(\\200) show
123.625000 17.312500 moveto
(\\200) show
125.500000 17.312500 moveto
(\\200) show
127.375000 17.312500 moveto
(\\200) show
129.250000 17.312500 moveto
(\\200) show
131.125000 17.312500 moveto
(\\200) show
133.000000 17.312500 moveto
(\\200) show
134.875000 17.312500 moveto
(\\200) show
136.750000 17.312500 moveto
(\\200) show
138.625000 17.312500 moveto
(\\200) show
140.500000 17.312500 moveto
(\\200) show
142.375000 17.312500 moveto
(\\200) show
144.250000 17.312500 moveto
(\\200) show
146.125000 17.312500 moveto
(\\200) show
148.000000 17.312500 moveto
(\\200) show
149.875000 17.312500 moveto
(\\200) show
151.750000 17.312500 moveto
(\\200) show
153.625000 17.312500 moveto
(\\200) show
155.500000 17.312500 moveto
(\\200) show
157.375000 17.312500 moveto
(\\200) show
159.250000 17.312500 moveto
(\\200) show
161.125000 17.312500 moveto
(\\200) show
163.000000 17.312500 moveto
(\\200) show
164.875000 17.312500 moveto
(\\200) show
166.750000 17.312500 moveto
(\\200) show
168.625000 17.312500 moveto
(\\200) show
170.500000 17.312500 moveto
(\\200) show
172.375000 17.312500 moveto
(\\200) show
174.250000 17.312500 moveto
(\\200) show
176.125000 17.312500 moveto
(\\200) show
178.000000 17.312500 moveto
(\\200) show
179.875000 17.312500 moveto
(\\200) show
181.750000 17.312500 moveto
(\\200) show
183.625000 17.312500 moveto
(\\200) show
185.500000 17.312500 moveto
(\\200) show
187.375000 17.312500 moveto
(\\200) show
189.250000 17.312500 moveto
(\\200) show
191.125000 17.312500 moveto
(\\200) show
193.000000 17.312500 moveto
(\\200) show
194.875000 17.312500 moveto
(\\200) show
196.750000 17.312500 moveto
(\\200) show
198.625000 17.312500 moveto
(\\200) show
200.500000 17.312500 moveto
(\\200) show
202.375000 17.312500 moveto
(\\200) show
204.250000 17.312500 moveto
(\\200) show
206.125000 17.312500 moveto
(\\200) show
208.000000 17.312500 moveto
(\\200) show
209.875000 17.312500 moveto
(\\200) show
211.750000 17.312500 moveto
(\\200) show
213.625000 17.312500 moveto
(\\200) show
215.500000 17.312500 moveto
(\\200) show
217.375000 17.312500 moveto
(\\200) show
219.250000 17.312500 moveto
(\\200) show
221.125000 17.312500 moveto
(\\200) show
223.000000 17.312500 moveto
(\\200) show
224.875000 17.312500 moveto
(\\200) show
226.750000 17.312500 moveto
(\\200) show
228.625000 17.312500 moveto
(\\200) show
230.500000 17.312500 moveto
(\\200) show
232.375000 17.312500 moveto
(\\200) show
234.250000 17.312500 moveto
(\\200) show
236.125000 17.312500 moveto
(\\200) show
238.000000 17.312500 moveto
(\\200) show
239.875000 17.312500 moveto
(\\200) show
241.750000 17.312500 moveto
(\\200) show
243.625000 17.312500 moveto
(\\200) show
245.500000 17.312500 moveto
(\\200) show
247.375000 17.312500 moveto
(\\200) show
249.250000 17.312500 moveto
(\\200) show
251.125000 17.312500 moveto
(\\200) show
253.000000 17.312500 moveto
(\\200) show
254.875000 17.312500 moveto
(\\200) show
256.750000 17.312500 moveto
(\\200) show
258.625000 17.312500 moveto
(\\200) show
258.937500 17.312500 moveto
(\\200) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
98.687500 23.625000 moveto
(H) show
104.687500 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
113.062500 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
121.437500 23.625000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
127.437500 23.625000 moveto
(L) show
136.062500 23.625000 moveto
(H) show
142.062500 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
148.062500 21.062500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
155.000000 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
163.375000 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
171.750000 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
180.125000 23.625000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
186.125000 23.625000 moveto
(L) show
194.750000 23.625000 moveto
(H) show
200.750000 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
206.750000 21.062500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
213.687500 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
222.062500 23.625000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
230.687500 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
239.062500 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
247.437500 23.625000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
253.437500 23.625000 moveto
(L) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier-Italic
%%+ font Math1Mono
%%+ font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier-Italic
%%+ Math1Mono
%%+ Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier-Italic
%%+ font Math1Mono
%%+ font Math2Mono
%%+ font Courier
grestore
0 0 m
1 0 L
1 1.61803 L
0 1.61803 L
closepath
clip
newpath
.75 g
.5 Mabswid
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
1 .95773 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
1 1.12946 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
1 1.36403 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
.96471 1.61803 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
.86424 1.61803 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
.77724 1.61803 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
.69023 1.61803 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
.58977 1.61803 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
.45253 1.61803 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
.21483 1.61803 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
0 1.3279 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
0 .80902 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
0 .29013 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
.21483 0 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
.45253 0 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
.58977 0 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
.69023 0 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
.77724 0 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
.86424 0 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
.96471 0 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
1 .254 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
1 .48858 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
1 .6603 L
s
.77724 .80902 m
0 0 rlineto s
.77724 .80902 m
1 .80902 L
s
.91856 .80902 m
.91744 .85315 L
.91412 .89658 L
.90863 .93863 L
.90108 .97864 L
.89157 1.01597 L
.88025 1.05004 L
.86732 1.08031 L
.85296 1.1063 L
.83741 1.1276 L
.82091 1.14388 L
.80372 1.15487 L
.78611 1.16042 L
.76837 1.16042 L
.75076 1.15487 L
.73357 1.14388 L
.71707 1.1276 L
.70152 1.1063 L
.68716 1.08031 L
.67422 1.05004 L
.66291 1.01597 L
.6534 .97864 L
.64585 .93863 L
.64036 .89658 L
.63704 .85315 L
.63592 .80902 L
.63704 .76489 L
.64036 .72145 L
.64585 .6794 L
.6534 .63939 L
.66291 .60206 L
.67422 .56799 L
.68716 .53772 L
.70152 .51173 L
.71707 .49043 L
.73357 .47416 L
.75076 .46316 L
.76837 .45762 L
.78611 .45762 L
.80372 .46316 L
.82091 .47416 L
.83741 .49043 L
.85296 .51173 L
.86732 .53772 L
.88025 .56799 L
.89157 .60206 L
.90108 .63939 L
.90863 .6794 L
.91412 .72145 L
.91744 .76489 L
Mistroke
.91856 .80902 L
Mfstroke
1 1.24068 m
.98327 1.29107 L
.9574 1.3516 L
.92868 1.40358 L
.89758 1.44618 L
.86458 1.47874 L
.8302 1.50073 L
.79499 1.51181 L
.75949 1.51181 L
.72428 1.50073 L
.6899 1.47874 L
.6569 1.44618 L
.6258 1.40358 L
.59708 1.3516 L
.57121 1.29107 L
.54858 1.22293 L
.52957 1.14826 L
.51445 1.06825 L
.50349 .98414 L
.49684 .89727 L
.49461 .80902 L
.49684 .72076 L
.50349 .63389 L
.51445 .54979 L
.52957 .46977 L
.54858 .39511 L
.57121 .32697 L
.59708 .26643 L
.6258 .21445 L
.6569 .17185 L
.6899 .1393 L
.72428 .1173 L
.75949 .10622 L
.79499 .10622 L
.8302 .1173 L
.86458 .1393 L
.89758 .17185 L
.92868 .21445 L
.9574 .26643 L
.98327 .32697 L
s
.98327 .32697 m
1 .37736 L
s
.50493 1.61803 m
.46819 1.53209 L
.43426 1.42988 L
.40573 1.31788 L
.38306 1.19786 L
.36661 1.0717 L
.35663 .9414 L
.35329 .80902 L
.35663 .67663 L
.36661 .54633 L
.38306 .42017 L
.40573 .30015 L
.43426 .18815 L
.46819 .08594 L
s
.46819 .08594 m
.50493 0 L
s
.31514 1.61803 m
.28189 1.48751 L
.25167 1.32747 L
.22973 1.15927 L
.21643 .98553 L
.21197 .80902 L
.21643 .6325 L
.22973 .45877 L
.25167 .29056 L
.28189 .13053 L
s
.28189 .13053 m
.31514 0 L
s
.15067 1.61803 m
.12028 1.45709 L
.09286 1.24683 L
.07623 1.02966 L
.07066 .80902 L
.07623 .58837 L
.09286 .37121 L
.12028 .16095 L
s
.12028 .16095 m
.15067 0 L
s
.75 0 0 r
.012 w
.42395 .80902 Mdot
.70658 .63297 Mdot
.70658 .98506 Mdot
.74191 .65656 Mdot
.74191 .96148 Mdot
.75 0 .073 r
.42395 .80902 Mdot
.70643 .63304 Mdot
.70643 .98499 Mdot
.74206 .65626 Mdot
.74206 .96177 Mdot
.75 0 .146 r
.42395 .80902 Mdot
.70541 .63343 Mdot
.70541 .9846 Mdot
.74308 .65433 Mdot
.74308 .9637 Mdot
.75 0 .219 r
.42397 .80902 Mdot
.70288 .63392 Mdot
.70288 .98411 Mdot
.7456 .64983 Mdot
.7456 .9682 Mdot
.75 0 .292 r
.42399 .80902 Mdot
.69875 .63358 Mdot
.69875 .98446 Mdot
.74972 .64297 Mdot
.74972 .97507 Mdot
.75 0 .366 r
.42403 .80902 Mdot
.69346 .63165 Mdot
.69346 .98638 Mdot
.75499 .63434 Mdot
.75499 .98369 Mdot
.75 0 .439 r
.42408 .80902 Mdot
.68753 .62808 Mdot
.68753 .98996 Mdot
.7609 .6244 Mdot
.7609 .99363 Mdot
.75 0 .512 r
.42416 .80902 Mdot
.68132 .62316 Mdot
.68132 .99487 Mdot
.76707 .61345 Mdot
.76707 1.00458 Mdot
.75 0 .585 r
.42426 .80902 Mdot
.67505 .61727 Mdot
.67505 1.00076 Mdot
.77329 .60174 Mdot
.77329 1.01629 Mdot
.75 0 .658 r
.4244 .80902 Mdot
.66881 .61073 Mdot
.66881 1.00731 Mdot
.77945 .58947 Mdot
.77945 1.02856 Mdot
.75 0 .731 r
.42457 .80902 Mdot
.66267 .60378 Mdot
.66267 1.01426 Mdot
.78551 .5768 Mdot
.78551 1.04123 Mdot
.696 0 .75 r
.42477 .80902 Mdot
.65664 .59659 Mdot
.65664 1.02145 Mdot
.79144 .56384 Mdot
.79144 1.05419 Mdot
.623 0 .75 r
.42501 .80902 Mdot
.65072 .58928 Mdot
.65072 1.02875 Mdot
.79724 .55069 Mdot
.79724 1.06734 Mdot
.549 0 .75 r
.4253 .80902 Mdot
.6449 .58194 Mdot
.6449 1.03609 Mdot
.80291 .53739 Mdot
.80291 1.08064 Mdot
.476 0 .75 r
.42564 .80902 Mdot
.63918 .57463 Mdot
.63918 1.04341 Mdot
.80847 .52401 Mdot
.80847 1.09403 Mdot
.403 0 .75 r
.42603 .80902 Mdot
.63354 .56738 Mdot
.63354 1.05065 Mdot
.81391 .51055 Mdot
.81391 1.10748 Mdot
.33 0 .75 r
.42648 .80902 Mdot
.62798 .56022 Mdot
.62798 1.05781 Mdot
.81925 .49706 Mdot
.81925 1.12098 Mdot
.257 0 .75 r
.42699 .80902 Mdot
.62248 .55318 Mdot
.62248 1.06486 Mdot
.82449 .48354 Mdot
.82449 1.13449 Mdot
.184 0 .75 r
.42756 .80902 Mdot
.61705 .54625 Mdot
.61705 1.07178 Mdot
.82964 .47001 Mdot
.82964 1.14802 Mdot
.111 0 .75 r
.42819 .80902 Mdot
.61166 .53945 Mdot
.61166 1.07859 Mdot
.83471 .45648 Mdot
.83471 1.16155 Mdot
.038 0 .75 r
.4289 .80902 Mdot
.60631 .53277 Mdot
.60631 1.08526 Mdot
.83971 .44296 Mdot
.83971 1.17508 Mdot
0 .036 .75 r
.42968 .80902 Mdot
.60099 .52622 Mdot
.60099 1.09181 Mdot
.84463 .42944 Mdot
.84463 1.18859 Mdot
0 .109 .75 r
.43054 .80902 Mdot
.5957 .51979 Mdot
.5957 1.09824 Mdot
.84949 .41594 Mdot
.84949 1.2021 Mdot
0 .182 .75 r
.43149 .80902 Mdot
.59043 .51348 Mdot
.59043 1.10455 Mdot
.85429 .40245 Mdot
.85429 1.21558 Mdot
0 .255 .75 r
.43251 .80902 Mdot
.58517 .50728 Mdot
.58517 1.11076 Mdot
.85904 .38898 Mdot
.85904 1.22905 Mdot
0 .328 .75 r
.43362 .80902 Mdot
.57993 .50117 Mdot
.57993 1.11686 Mdot
.86373 .37553 Mdot
.86373 1.24251 Mdot
0 .401 .75 r
.43482 .80902 Mdot
.57469 .49515 Mdot
.57469 1.12288 Mdot
.86837 .3621 Mdot
.86837 1.25594 Mdot
0 .474 .75 r
.43611 .80902 Mdot
.56945 .48921 Mdot
.56945 1.12882 Mdot
.87296 .34868 Mdot
.87296 1.26935 Mdot
0 .548 .75 r
.43749 .80902 Mdot
.56421 .48334 Mdot
.56421 1.1347 Mdot
.87751 .33529 Mdot
.87751 1.28274 Mdot
0 .621 .75 r
.43895 .80902 Mdot
.55898 .47751 Mdot
.55898 1.14053 Mdot
.88201 .32192 Mdot
.88201 1.29612 Mdot
0 .694 .75 r
.4405 .80902 Mdot
.55373 .47172 Mdot
.55373 1.14632 Mdot
.88648 .30857 Mdot
.88648 1.30947 Mdot
0 .75 .733 r
.44214 .80902 Mdot
.54849 .46594 Mdot
.54849 1.15209 Mdot
.89091 .29523 Mdot
.89091 1.3228 Mdot
0 .75 .66 r
.44384 .80902 Mdot
.54324 .46018 Mdot
.54324 1.15786 Mdot
.8953 .28192 Mdot
.8953 1.33612 Mdot
0 .75 .587 r
.44562 .80902 Mdot
.53799 .4544 Mdot
.53799 1.16363 Mdot
.89966 .26862 Mdot
.89966 1.34941 Mdot
0 .75 .514 r
.44746 .80902 Mdot
.53275 .4486 Mdot
.53275 1.16943 Mdot
.90399 .25535 Mdot
.90399 1.36269 Mdot
0 .75 .441 r
.44934 .80902 Mdot
.52751 .44277 Mdot
.52751 1.17527 Mdot
.90828 .24209 Mdot
.90828 1.37595 Mdot
0 .75 .367 r
.45126 .80902 Mdot
.52229 .43688 Mdot
.52229 1.18115 Mdot
.91255 .22885 Mdot
.91255 1.38919 Mdot
0 .75 .294 r
.45319 .80902 Mdot
.51708 .43095 Mdot
.51708 1.18708 Mdot
.91679 .21562 Mdot
.91679 1.40241 Mdot
0 .75 .221 r
.45513 .80902 Mdot
.5119 .42496 Mdot
.5119 1.19307 Mdot
.921 .20242 Mdot
.921 1.41562 Mdot
0 .75 .148 r
.45706 .80902 Mdot
.50675 .41891 Mdot
.50675 1.19912 Mdot
.92518 .18922 Mdot
.92518 1.42881 Mdot
0 .75 .075 r
.45896 .80902 Mdot
.50164 .41281 Mdot
.50164 1.20522 Mdot
.92934 .17605 Mdot
.92934 1.44199 Mdot
0 1 0 r
.0125 w
.07066 .80902 Mdot
.49461 .80902 Mdot
1 0 0 r
.42395 .80902 Mdot
.70658 .63297 Mdot
.70658 .98506 Mdot
.74191 .65656 Mdot
.74191 .96148 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.909028 0.369391 0.97619 0.705202 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.00980392 0.490196 0.0024975 0.124875 [
[ 0 0 0 0 ]
[ 1 5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 5 L
0 5 L
closepath
clip
newpath
.75 0 0 r
.0098 .0025 m
.0098 .12737 L
.5 .12737 L
.5 .0025 L
F
0 g
gsave
.52451 .06494 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.75 0 .075 r
.0098 .12737 m
.0098 .25225 L
.5 .25225 L
.5 .12737 L
F
.75 0 .15 r
.0098 .25225 m
.0098 .37712 L
.5 .37712 L
.5 .25225 L
F
.75 0 .225 r
.0098 .37712 m
.0098 .502 L
.5 .502 L
.5 .37712 L
F
.75 0 .3 r
.0098 .502 m
.0098 .62687 L
.5 .62687 L
.5 .502 L
F
.75 0 .375 r
.0098 .62687 m
.0098 .75175 L
.5 .75175 L
.5 .62687 L
F
.75 0 .45 r
.0098 .75175 m
.0098 .87662 L
.5 .87662 L
.5 .75175 L
F
.75 0 .525 r
.0098 .87662 m
.0098 1.0015 L
.5 1.0015 L
.5 .87662 L
F
.75 0 .6 r
.0098 1.0015 m
.0098 1.12637 L
.5 1.12637 L
.5 1.0015 L
F
.75 0 .675 r
.0098 1.12637 m
.0098 1.25125 L
.5 1.25125 L
.5 1.12637 L
F
.75 0 .75 r
.0098 1.25125 m
.0098 1.37612 L
.5 1.37612 L
.5 1.25125 L
F
.675 0 .75 r
.0098 1.37612 m
.0098 1.501 L
.5 1.501 L
.5 1.37612 L
F
.6 0 .75 r
.0098 1.501 m
.0098 1.62587 L
.5 1.62587 L
.5 1.501 L
F
.525 0 .75 r
.0098 1.62587 m
.0098 1.75075 L
.5 1.75075 L
.5 1.62587 L
F
.45 0 .75 r
.0098 1.75075 m
.0098 1.87562 L
.5 1.87562 L
.5 1.75075 L
F
.375 0 .75 r
.0098 1.87562 m
.0098 2.0005 L
.5 2.0005 L
.5 1.87562 L
F
.3 0 .75 r
.0098 2.0005 m
.0098 2.12537 L
.5 2.12537 L
.5 2.0005 L
F
.225 0 .75 r
.0098 2.12537 m
.0098 2.25025 L
.5 2.25025 L
.5 2.12537 L
F
.15 0 .75 r
.0098 2.25025 m
.0098 2.37512 L
.5 2.37512 L
.5 2.25025 L
F
.075 0 .75 r
.0098 2.37512 m
.0098 2.5 L
.5 2.5 L
.5 2.37512 L
F
0 0 .75 r
.0098 2.5 m
.0098 2.62488 L
.5 2.62488 L
.5 2.5 L
F
0 .075 .75 r
.0098 2.62488 m
.0098 2.74975 L
.5 2.74975 L
.5 2.62488 L
F
0 .15 .75 r
.0098 2.74975 m
.0098 2.87463 L
.5 2.87463 L
.5 2.74975 L
F
0 .225 .75 r
.0098 2.87463 m
.0098 2.9995 L
.5 2.9995 L
.5 2.87463 L
F
0 .3 .75 r
.0098 2.9995 m
.0098 3.12438 L
.5 3.12438 L
.5 2.9995 L
F
0 .375 .75 r
.0098 3.12438 m
.0098 3.24925 L
.5 3.24925 L
.5 3.12438 L
F
0 .45 .75 r
.0098 3.24925 m
.0098 3.37413 L
.5 3.37413 L
.5 3.24925 L
F
0 .525 .75 r
.0098 3.37413 m
.0098 3.499 L
.5 3.499 L
.5 3.37413 L
F
0 .6 .75 r
.0098 3.499 m
.0098 3.62388 L
.5 3.62388 L
.5 3.499 L
F
0 .675 .75 r
.0098 3.62388 m
.0098 3.74875 L
.5 3.74875 L
.5 3.62388 L
F
0 .75 .75 r
.0098 3.74875 m
.0098 3.87363 L
.5 3.87363 L
.5 3.74875 L
F
0 .75 .675 r
.0098 3.87363 m
.0098 3.9985 L
.5 3.9985 L
.5 3.87363 L
F
0 .75 .6 r
.0098 3.9985 m
.0098 4.12338 L
.5 4.12338 L
.5 3.9985 L
F
0 .75 .525 r
.0098 4.12338 m
.0098 4.24825 L
.5 4.24825 L
.5 4.12338 L
F
0 .75 .45 r
.0098 4.24825 m
.0098 4.37313 L
.5 4.37313 L
.5 4.24825 L
F
0 .75 .375 r
.0098 4.37313 m
.0098 4.498 L
.5 4.498 L
.5 4.37313 L
F
0 .75 .3 r
.0098 4.498 m
.0098 4.62288 L
.5 4.62288 L
.5 4.498 L
F
0 .75 .225 r
.0098 4.62288 m
.0098 4.74775 L
.5 4.74775 L
.5 4.62288 L
F
0 .75 .15 r
.0098 4.74775 m
.0098 4.87263 L
.5 4.87263 L
.5 4.74775 L
F
0 .75 .075 r
.0098 4.87263 m
.0098 4.9975 L
.5 4.9975 L
.5 4.87263 L
F
0 g
gsave
.52451 4.93506 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(40.) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 1.4104 L
0 1.4104 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[118]:=",
  ImageSize->{389.188, 548.875},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400065000291000`40O003h00OogooQWoo003oOon6
Ool00?moohIoo`00ogooQWoo003oOon6Ool00?moohIoo`00ogooQWoo003oOon6Ool00?moohIoo`00
ogooQWoo003oOon6Ool00?moohIoo`00ogooQWoo003oOon6Ool00?moohIoo`00ogooQWoo003oOon6
Ool00?moohIoo`00ogooQWoo003oOon6Ool00?moohIoo`00ogooQWoo003oOon6Ool00?moohIoo`00
ogooQWoo003oOon6Ool00?moohIoo`00ogooQWoo003oOon6Ool00?moohIoo`00ogooQWoo003oOon6
Ool00?moohIoo`00ogooQWoo003oOon6Ool00?moohIoo`00_Goo0P0027oo0P00_7oo002mOol00`00
Oomoo`08Ool00`00Oomoo`2jOol00:ioo`<00004Ool007ooOol20006Ool01000Oomoogoo0P001Goo
00<007ooOol0^Woo002_Ool01P00Oomoo`00Ool000Qoo`03001oogoo00=oo`03001oogoo009oo`03
001oogoo0;Yoo`00[goo0`000Woo0`001Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0
^Woo002_Ool01@00Oomoo`00Ool00`001Woo00<007ooOol00Woo0P0017oo00<007ooOol0^Woo002_
Ool01000Oomoo`002Woo00<007ooOol027oo00<007ooOol0^Woo002^Ool4000;Ool20008Ool2002l
Ool00?moohIoo`00ogooQWoo003oOon6Ool004aoo`D0009oo`03001oogoo01ioo`03001oogoo025o
o`8002=oo`<0025oo`<0021oo`03001oogoo021oo`<005]oo`00CWoo00L007ooOomoo`00Ool0000N
Ool00`00Ool0000ROol00`00Ool0000SOol00`00Oomoo`0POol00`00Oomoo`0OOol00`00Ool0000Q
Ool00`00Oomoo`1KOol004Qoo`<000=oo`07001oogooOol007oo00006Goo0`000Woo00<007oo0000
7Goo0`000Woo00<007oo000077oo0`000Woo100077oo0`000goo00<007ooOol07Woo00<007oo0000
8Woo00<007ooOol0FWoo001>Ool01`00Oomoogoo001oo`0001moo`03001oogoo025oo`80029oo`03
001oo`0002=oo`03001oogoo01ioo`03001oo`00029oo`03001oogoo05Yoo`00CWoo00L007ooOomo
o`00Ool0000NOol00`00Ool0000ROol00`00Oomoo`0ROol2000ROol00`00Ool0000OOol00`00Ool0
000QOol00`00Ool0001KOol004eoo`8000Aoo`03001oogoo01ioo`03001oogoo029oo`8002=oo`03
001oogoo025oo`03001oogoo01moo`03001oogoo025oo`03001oogoo05Yoo`00ogooQWoo003oOon6
Ool00?moohIoo`00ogooQWoo003oOon6Ool003aoobL00003G_L0000000d00003G_L0000001L00003
G_L0000002400003G_L0000000X00003G_L0000001<00003G_L0000001L00003G_L0000001<00003
G_L0000001@00003G_L0000001L00003G_L0000000L004Ioo`00?7oo00<007ooOol01Woo00<007oo
Ool01Woo00<007ooOol01Woo00<007ooOol01Woo00@007ooOomNm`Eoo`03001oogoo00Ioo`03001o
oekg00Moo`03001oogoo00Ioo`03001oogoo00Eoo`03G_L007oo00Moo`03001oogoo00Ioo`03001o
ogoo00Ioo`03001oogoo00Eoo`03G_L007oo00Moo`04001oogooG_L6Ool00`00Oomoo`06Ool00`00
Oomoo`03Ool015kgOomoo`0027oo00<007ooOol01Woo00<007ooOol00Woo00ENmgooOomoo`0000Qo
o`03001oogoo00Ioo`03G_Moogoo00Ioo`03001oogoo00Moo`05001oogooOomNm`04Ool00`00Oomo
o`06Ool00`00Oomoo`06Ool01000Oomooekg1Goo00@007ooOol004Ioo`00?7oo00<007ooOol03goo
00<007ooOol04Woo00=NmgooOol037oo00<007ooG_L067oo00=NmgooOol01goo00<007ooOol067oo
00=NmgooOol01Woo00<007ooG_L05Woo00=NmgooOol02Goo00<007ooOol02goo00=NmgooOol04goo
00=NmgooOol057oo00=NmgooOol02goo00<007ooOol02Goo00=NmgooOol01Woo00<007ooOol0A7oo
000lOol00`00Oomoo`0SOol00ekgOomoo`0@Ool00ekgOomoo`0DOol00ekgOomoo`0SOol00ekgOomo
o`08Ool00ekgOomoo`0EOol00ekgOomoo`0FOol00ekgOomoo`0COol00ekgOomoo`0DOol00ekgOomo
o`0FOol00ekgOomoo`07Ool00`00Oomoo`14Ool003aoo`8002Aoo`03G_Moogoo015oo`03G_Moogoo
01=oo`03G_Moogoo02Aoo`03G_Moogoo00Ioo`03G_Moogoo01Ioo`03G_Moogoo01Ioo`03G_Moogoo
01=oo`03G_Moogoo01Aoo`03G_Moogoo01Ioo`03G_Moogoo00Ioo`8004Ioo`00?7oo00<007ooOol0
8goo00=NmgooOol04Goo00=NmgooOol04goo00=NmgooOol097oo00=NmgooOol01Woo00=NmgooOol0
5Woo00=NmgooOol05goo00=NmgooOol04Woo00=NmgooOol04goo00=NmgooOol05goo00=NmgooOol0
1goo00<007ooOol0A7oo000lOol00`00Oomoo`0SOol00ekgOomoo`0BOol00ekgOomoo`0BOol00ekg
Oomoo`0TOol00ekgOomoo`06Ool00ekgOomoo`0FOol00ekgOomoo`0GOol00ekgOomoo`0BOol00ekg
Oomoo`0COol00ekgOomoo`0GOol00ekgOomoo`07Ool00`00Oomoo`14Ool003aoo`03001oogoo02=o
o`03G_Moogoo01=oo`03G_Moogoo011oo`03G_Moogoo02Ioo`03G_Moogoo00Aoo`03G_Moogoo01Qo
o`03G_Moogoo01Ioo`03G_Moogoo019oo`03G_Moogoo01=oo`03G_Moogoo01Ioo`03G_Moogoo00Qo
o`03001oogoo04Aoo`00?7oo00<007ooOol08Woo00=NmgooOol05Goo00=NmgooOol03goo00=Nmgoo
Ool09Woo00=NmgooOol017oo00=NmgooOol067oo00=NmgooOol05Woo00=NmgooOol04Woo00=Nmgoo
Ool04goo00=NmgooOol05Woo00=NmgooOol027oo00<007ooOol0A7oo000lOol00`00Oomoo`0ROol0
0ekgOomoo`0EOol00ekgOomoo`0?Ool00ekgOomoo`0WOol00ekgOomoo`02Ool00ekgOomoo`0IOol0
0ekgOomoo`0FOol00ekgOomoo`0BOol00ekgOomoo`0COol00ekgOomoo`0FOol00ekgOomoo`08Ool0
0`00Oomoo`14Ool003aoo`03001oogoo029oo`03G_Moogoo01Ioo`03G_Moogoo00ioo`03G_Moogoo
02Moo`03G_Moogoo009oo`03G_Moogoo01Uoo`03G_Moogoo01Ioo`03G_Moogoo019oo`03G_Moogoo
01=oo`03G_Moogoo01Ioo`03G_Moogoo00Qoo`03001oogoo04Aoo`00?7oo00<007ooOol08Woo00=N
mgooOol05goo00=NmgooOol037oo00=NmgooOol0:7oo00ENmgooOomooekg01eoo`03G_Moogoo01Eo
o`03G_Moogoo019oo`03G_Moogoo01=oo`03G_Moogoo01Eoo`03G_Moogoo00Uoo`03001oogoo04Ao
o`00?7oo00<007ooOol08Woo00=NmgooOol05goo00=NmgooOol037oo00=NmgooOol0:Goo00ANmgoo
OomNmaeoo`03G_Moogoo01Eoo`03G_Moogoo019oo`03G_Moogoo01=oo`03G_Moogoo01Eoo`03G_Mo
ogoo00Uoo`03001oogoo04Aoo`00?7oo00<007ooOol08Woo00=NmgooOol067oo00=NmgooOol02goo
00=NmgooOol0:Goo00ANmgooOomNmaeoo`03G_Moogoo01Eoo`03G_Moogoo019oo`03G_Moogoo01=o
o`03G_Moogoo01Eoo`03G_Moogoo00Uoo`03001oogoo04Aoo`00?7oo00<007ooOol08Goo00=Nmgoo
Ool06Woo00=NmgooOol02Woo00=NmgooOol0:Woo0Ukg7Woo00=NmgooOol05Goo00=NmgooOol04Woo
00=NmgooOol04Woo00=NmgooOol05Woo00=NmgooOol02Goo00<007ooOol0A7oo000lOol00`00Oomo
o`0QOol00ekgOomoo`0JOol00ekgOomoo`09Ool00ekgOomoo`0[Ool2G_LNOol00ekgOomoo`0FOol0
0ekgOomoo`0AOol00ekgOomoo`0BOol00ekgOomoo`0EOol00ekgOomoo`0:Ool00`00Oomoo`14Ool0
03aoo`03001oogoo025oo`03G_Moogoo01]oo`03G_Moogoo00Qoo`03G_Moogoo02]oo`03G_Moogoo
01ioo`03G_Moogoo01Eoo`03G_Moogoo015oo`03G_Moogoo019oo`03G_Moogoo01Eoo`03G_Moogoo
00Yoo`03001oogoo04Aoo`00?7oo00<007ooOol08Goo00=NmgooOol077oo00=NmgooOol01goo00=N
mgooOol0:goo0Ukg7goo00=NmgooOol05Goo00=NmgooOol04Goo00=NmgooOol04Woo00=NmgooOol0
5Goo00=NmgooOol02Woo00<007ooOol0A7oo000lOol00`00Oomoo`0QOol00ekgOomoo`0LOol00ekg
Oomoo`07Ool00ekgOomoo`0[Ool2G_LOOol00ekgOomoo`0EOol00ekgOomoo`0AOol00ekgOomoo`0B
Ool00ekgOomoo`0EOol00ekgOomoo`0:Ool00`00Oomoo`14Ool003aoo`03001oogoo021oo`03G_Mo
ogoo01ioo`03G_Moogoo00Ioo`03G_Moogoo02Yoo`04G_MoogooG_LNOol00ekgOomoo`0EOol00ekg
Oomoo`0AOol00ekgOomoo`0BOol00ekgOomoo`0EOol00ekgOomoo`0:Ool00`00Oomoo`14Ool003ao
o`03001oogoo021oo`03G_Moogoo01moo`03G_Moogoo00Aoo`03G_Moogoo02]oo`04G_MoogooG_LO
Ool00ekgOomoo`0DOol00ekgOomoo`0AOol00ekgOomoo`0BOol00ekgOomoo`0DOol00ekgOomoo`0;
Ool00`00Oomoo`14Ool003aoo`03001oogoo021oo`03G_Moogoo021oo`03G_Moogoo00=oo`03G_Mo
ogoo02Yoo`05G_MoogooOomNm`0OOol00ekgOomoo`0DOol00ekgOomoo`0AOol00ekgOomoo`0BOol0
0ekgOomoo`0DOol00ekgOomoo`0;Ool00`00Oomoo`14Ool003aoo`03001oogoo021oo`03G_Moogoo
021oo`03G_Moogoo00=oo`03G_Moogoo02Yoo`03G_Moogoo009oo`03G_Moogoo01aoo`03G_Moogoo
01Aoo`03G_Moogoo015oo`03G_Moogoo019oo`03G_Moogoo01Aoo`03G_Moogoo00]oo`03001oogoo
04Aoo`00?7oo00<007ooOol087oo00=NmgooOol08Goo00=NmgooOol00Woo00=NmgooOol0:Woo00=N
mgooOol00Woo00=NmgooOol077oo00=NmgooOol057oo00=NmgooOol04Goo00=NmgooOol04Goo00=N
mgooOol05Goo00=NmgooOol02goo00<007ooOol0A7oo000lOol00`00Oomoo`0OOol00ekgOomoo`0S
Ool015kgOomooekg;7oo00=NmgooOol017oo00=NmgooOol077oo00=NmgooOol057oo00=NmgooOol0
47oo00=NmgooOol04Goo00=NmgooOol057oo00=NmgooOol037oo00<007ooOol0A7oo000fOol30003
Ool00`00Oomoo`0OOol00ekgOomoo`0SOol015kgOomooekg;7oo00=NmgooOol017oo00=NmgooOol0
77oo00=NmgooOol057oo00=NmgooOol047oo00=NmgooOol04Goo00=NmgooOol057oo00=NmgooOol0
37oo00<007ooOol0A7oo000gOol00`00Oomoo`02Ool00`00Oomoo`0OOol00ekgOomoo`0TOol00ekg
OomNm`0/Ool00ekgOomoo`04Ool00ekgOomoo`0LOol00ekgOomoo`0DOol00ekgOomoo`0@Ool00ekg
Oomoo`0AOol00ekgOomoo`0DOol00ekgOomoo`0<Ool00`00Oomoo`14Ool0031oo`<0009oo`@000=o
o`80021oo`03G_Moogoo02Eoo`9Nmb]oo`03G_Moogoo00Ioo`03G_Moogoo01]oo`03G_Moogoo01Ao
o`03G_Moogoo00]oo`aNm`eoo`03G_Moogoo01Aoo`03G_Moogoo00Yoo`<004Ioo`00=Goo00<007oo
000017oo00<007ooOol07goo00=NmgooOol09Goo00=NmgooOol0:Woo00=NmgooOol01Woo00=Nmgoo
Ool06goo00=NmgooOol057oo00=NmgooOol027oo0ekg1Goo00=NmgooOol017oo0ekg2Woo00=Nmgoo
Ool04goo00=NmgooOol03Goo00<007ooOol0A7oo000fOol20004Ool00`00Oomoo`0NOol00ekgOomo
o`0VOol2G_L[Ool00ekgOomoo`07Ool00ekgOomoo`0KOol00ekgOomoo`0COol00ekgOomoo`05Ool3
G_L8Ool00ekgOomoo`07Ool3G_L7Ool00ekgOomoo`0COol00ekgOomoo`0=Ool00`00Oomoo`14Ool0
03Moo`03001oogoo009oo`03001oogoo01ioo`03G_Moogoo02Ioo`03G_Mooekg02Uoo`03G_Moogoo
00Qoo`03G_Moogoo01]oo`03G_Moogoo01=oo`03G_Moogoo00=oo`9Nm`]oo`03G_Moogoo00Yoo`9N
m`Eoo`03G_Moogoo01=oo`03G_Moogoo00eoo`03001oogoo04Aoo`00?7oo00<007ooOol07Woo00=N
mgooOol09Woo00ANmgooOomNmbQoo`03G_Moogoo00Qoo`03G_Moogoo01]oo`03G_Moogoo01=oo`04
G_MoogooOol2G_L=Ool00ekgOomoo`0<Ool2G_L3Ool00ekgOomoo`0COol00ekgOomoo`0=Ool00`00
Oomoo`14Ool003aoo`03001oogoo01ioo`03G_Moogoo02Eoo`05G_MoogooOomNm`0XOol00ekgOomo
o`09Ool00ekgOomoo`0JOol00ekgOomoo`0COol015kgOomooekg3goo00=NmgooOol03Woo00=Nmgoo
G_L05Goo00=NmgooOol03Woo00<007ooOol0A7oo000lOol00`00Oomoo`0NOol00ekgOomoo`0UOol0
0ekgOomoo`02Ool00ekgOomoo`0TOol00ekgOomoo`0:Ool00ekgOomoo`0KOol00ekgOomoo`0BOol3
G_L@Ool00ekgOomoo`0?Ool2G_LEOol00ekgOomoo`0>Ool00`00Oomoo`14Ool003aoo`03001oogoo
01ioo`03G_Moogoo02Eoo`03G_Moogoo00=oo`03G_Moogoo02=oo`03G_Moogoo00]oo`03G_Moogoo
01Yoo`03G_Moogoo019oo`9Nma5oo`03G_Moogoo011oo`9NmaAoo`03G_Moogoo00ioo`03001oogoo
04Aoo`00?7oo00<007ooOol07Goo00=NmgooOol09Woo00=NmgooOol00goo00=NmgooOol08goo00=N
mgooOol02goo00=NmgooOol06Woo00=NmgooOol047oo0Ukg00=ooekgOol047oo00=NmgooOol047oo
00ANmgooG_MNma9oo`03G_Moogoo00ioo`03001oogoo04Aoo`00?7oo00<007ooOol07Goo00=Nmgoo
Ool09Woo00=NmgooOol017oo00=NmgooOol08Goo00=NmgooOol037oo00=NmgooOol06Woo00=Nmgoo
Ool03goo00ENmgooOomooekg015oo`03G_Moogoo011oo`05G_MoogooOomNm`0AOol00ekgOomoo`0>
Ool00`00Oomoo`14Ool003aoo`03001oogoo01eoo`03G_Moogoo02Eoo`03G_Moogoo00Ioo`03G_Mo
ogoo021oo`03G_Moogoo00eoo`03G_Moogoo01Uoo`03G_Moogoo00ioo`03G_Moogoo009oo`03G_Mo
ogoo00moo`03G_Moogoo011oo`03G_Moogoo009oo`03G_Moogoo00eoo`03G_Moogoo00moo`03001o
ogoo04Aoo`00?7oo00<007ooOol07Goo00=NmgooOol09Goo00=NmgooOol01Woo00=NmgooOol087oo
00=NmgooOol03Goo00=NmgooOol06Woo00=NmgooOol037oo00=NmgooOol00goo00=NmgooOol03goo
00=NmgooOol047oo00=NmgooOol00goo00=NmgooOol037oo00=NmgooOol03goo00<007ooOol0A7oo
000lOol00`00Oomoo`0MOol00ekgOomoo`0UOol00ekgOomoo`07Ool00ekgOomoo`0NOol00ekgOomo
o`0>Ool00ekgOomoo`0JOol00ekgOomoo`0;Ool00ekgOomoo`04Ool00ekgOomoo`0?Ool00ekgOomo
o`0@Ool00ekgOomoo`04Ool00ekgOomoo`0;Ool00ekgOomoo`0?Ool00`00Oomoo`14Ool003aoo`03
001oogoo01aoo`03G_Moogoo02Ioo`03G_Moogoo00Qoo`03G_Moogoo01eoo`03G_Moogoo00moo`03
G_Moogoo01Uoo`03G_Moogoo00Uoo`9Nm`Moo`03G_Moogoo00moo`03G_Moogoo011oo`03G_Moogoo
00Eoo`03G_Moogoo00Yoo`03G_Moogoo00moo`03001oogoo04Aoo`00?7oo00<007ooOol077oo00=N
mgooOol09Woo00=NmgooOol027oo00=NmgooOol07Goo00=NmgooOol03goo00=NmgooOol06Goo00=N
mgooOol027oo00=NmgooOol01goo00=NmgooOol03goo00=NmgooOol03goo00=NmgooOol01goo00=N
mgooOol027oo00=NmgooOol047oo00<007ooOol0A7oo000lOol00`00Oomoo`0LOol00ekgOomoo`0U
Ool00ekgOomoo`0:Ool00ekgOomoo`0KOol00ekgOomoo`0AOol00ekgOomoo`0IOol00ekgOomoo`06
Ool00ekgOomoo`08Ool00ekgOomoo`0?Ool00ekgOomoo`0?Ool00ekgOomoo`08Ool00ekgOomoo`07
Ool00ekgOomoo`0@Ool00`00Oomoo`14Ool003aoo`03001oogoo01aoo`03G_Moogoo02Eoo`03G_Mo
ogoo00]oo`03G_Moogoo01Yoo`03G_Moogoo015oo`03G_Moogoo01Uoo`03G_Moogoo00Eoo`03G_Mo
ogoo00Yoo`03G_Moogoo00ioo`03G_Moogoo00moo`03G_Moogoo00Uoo`03G_Moogoo00Ioo`03G_Mo
ogoo011oo`03001oogoo04Aoo`00?7oo00<007ooOol077oo00=NmgooOol09Goo00=NmgooOol037oo
00=NmgooOol06Goo00=NmgooOol04Goo00=NmgooOol06Goo00=NmgooOol017oo00=NmgooOol02goo
00=NmgooOol03Woo00=NmgooOol03goo00=NmgooOol02Woo00=NmgooOol01Goo00=NmgooOol047oo
00<007ooOol0A7oo000lOol00`00Oomoo`0LOol00ekgOomoo`0UOol00ekgOomoo`0<Ool00ekgOomo
o`0HOol00ekgOomoo`0COol00ekgOomoo`0HOol00ekgOomoo`03Ool00ekgOomoo`0<Ool00ekgOomo
o`0>Ool00ekgOomoo`0?Ool00ekgOomoo`0;Ool00ekgOomoo`03Ool00ekgOol2h@0AOol00`00Oomo
o`14Ool003aoo`03001oogoo01]oo`03G_Moogoo02Ioo`03G_Moogoo00eoo`03G_Moogoo01Moo`03
G_Moogoo01=oo`03G_Moogoo01Uoo`03G_Moogoo009oo`03G_Moogoo00aoo`03G_Moogoo00ioo`03
G_Moogoo00moo`03G_Moogoo00]oo`03G_Moogoo00=oo`04G_L2h@;Q0^4@Ool00`00Oomoo`14Ool0
03aoo`03001oogoo01]oo`03G_Moogoo02Eoo`03G_Moogoo00moo`03G_Moogoo01Ioo`03G_Moogoo
01Aoo`03G_Moogoo01Qoo`05G_MoogooOomNm`0?Ool00ekgOomoo`0>Ool00ekgOomoo`0?Ool00ekg
Oomoo`0<Ool00ekgOomoo`02Ool00ekgOol2h@0AOol00`00Oomoo`14Ool003aoo`03001oogoo01]o
o`03G_Moogoo02Eoo`03G_Moogoo00moo`03G_Moogoo01Eoo`03G_Moogoo01Eoo`03G_Moogoo01Qo
o`04G_MoogooG_L@Ool00ekgOomoo`0>Ool00ekgOomoo`0?Ool00ekgOomoo`0=Ool01EkgOomoogoo
0^@04goo00<007ooOol0A7oo000lOol00`00Oomoo`0KOol00ekgOomoo`0UOol00ekgOomoo`0@Ool0
0ekgOomoo`0DOol00ekgOomoo`0EOol00ekgOomoo`0HOol00ekgOomNm`0AOol00ekgOomoo`0>Ool0
0ekgOomoo`0?Ool00ekgOomoo`0>Ool00ekgOol2i0020^@BOol00`00Oomoo`14Ool003aoo`8001ao
o`03G_Moogoo02Eoo`03G_Moogoo015oo`03G_Moogoo01=oo`03G_Moogoo01Ioo`03G_Moogoo01Mo
o`03G_Mooekg015oo`03G_Moogoo00ioo`03G_Moogoo00ioo`03G_Moogoo00moo`04G_Mooekg0^@B
Ool20016Ool003aoo`03001oogoo01]oo`03G_Moogoo02Eoo`03G_Moogoo015oo`03G_Moogoo019o
o`03G_Moogoo01Moo`03G_Moogoo01Qoo`03G_Moogoo011oo`03G_Moogoo00ioo`03G_Moogoo00io
o`03G_Moogoo011oo`03G_L2iWoo01=oo`03001oogoo04Aoo`00?7oo00<007ooOol06goo00=Nmgoo
Ool097oo00=NmgooOol04goo00=NmgooOol04Goo00=NmgooOol067oo00=NmgooOol05Woo0Ukg4Woo
00=NmgooOol03Woo00=NmgooOol03Woo00=NmgooOol047oo0`;V4goo00<007ooOol0A7oo000lOol0
0`00Oomoo`0KOol00ekgOomoo`0TOol00ekgOomoo`0DOol00ekgOomoo`0@Ool00ekgOomoo`0HOol0
0ekgOomoo`0EOol00ekgOomNm`0COol00ekgOomoo`0=Ool00ekgOomoo`0>Ool00ekgOomoo`0AOol0
0`;VG_Moo`0BOol00`00Oomoo`14Ool003aoo`03001oogoo01Yoo`03G_Moogoo02Eoo`03G_Moogoo
01Aoo`03G_Moogoo011oo`03G_Moogoo01Qoo`03G_Moogoo01Eoo`03G_Mooekg01=oo`03G_Moogoo
00eoo`03G_Moogoo00ioo`03G_Moogoo011oo`03G_Mooekg01=oo`03001oogoo04Aoo`00?7oo00<0
07ooOol06Woo00=NmgooOol09Goo00=NmgooOol05Goo00=NmgooOol03Woo00=NmgooOol06Woo00=N
mgooOol04goo00ENmgooOomooekg019oo`03G_Moogoo00eoo`03G_Moogoo00ioo`03G_Moogoo011o
o`040^QoogooG_LBOol00`00Oomoo`14Ool003aoo`03001oogoo01Yoo`03G_Moogoo02Eoo`03G_Mo
ogoo01Ioo`03G_Moogoo00eoo`03G_Moogoo01Yoo`03G_Moogoo019oo`03G_Moogoo009oo`03G_Mo
ogoo011oo`03G_Moogoo00eoo`03G_Moogoo00ioo`03G_Moogoo00moo`<2j09oo`03G_Moogoo00mo
o`03001oogoo04Aoo`00?7oo00<007ooOol06Woo00=NmgooOol09Goo00=NmgooOol05goo00=Nmgoo
Ool037oo00=NmgooOol06goo00=NmgooOol04Goo00=NmgooOol00Woo00=NmgooOol047oo00=Nmgoo
Ool03Goo00=NmgooOol03Woo00=NmgooOol047oo00D2j7ooOomooekg015oo`03001oogoo04Aoo`00
?7oo00<007ooOol06Woo00=NmgooOol097oo00=NmgooOol067oo00=NmgooOol037oo00=NmgooOol0
6goo00=NmgooOol047oo00=NmgooOol00goo00=NmgooOol047oo00=NmgooOol03Goo00=NmgooOol0
3Woo00=NmgooOol03goo00<2jgooOol00goo00=NmgooOol03Woo00<007ooOol0A7oo000lOol00`00
Oomoo`0JOol00ekgOomoo`0TOol00ekgOomoo`0IOol00ekgOomoo`0:Ool00ekgOomoo`0LOol00ekg
Oomoo`0@Ool00ekgOomoo`04Ool00ekgOomoo`0?Ool00ekgOomoo`0=Ool00ekgOomoo`0>Ool00ekg
Oomoo`0>Ool00`;[0^X2j`04Ool00ekgOomoo`0>Ool00`00Oomoo`14Ool003aoo`03001oogoo01Yo
o`03G_Moogoo02Aoo`03G_Moogoo01Yoo`03G_Moogoo00Uoo`03G_Moogoo01eoo`03G_Moogoo00io
o`03G_Moogoo00Eoo`03G_Moogoo00moo`03G_Moogoo00eoo`03G_Moogoo00eoo`03G_Moogoo011o
o`030^]oogoo00Aoo`03G_Moogoo00eoo`03001oogoo04Aoo`00?7oo00<007ooOol06Woo00=Nmgoo
Ool097oo00=NmgooOol06Woo00=NmgooOol02Goo00=NmgooOol07Goo00=NmgooOol03Woo00=Nmgoo
Ool01Goo00=NmgooOol03goo00=NmgooOol03Goo00=NmgooOol03Goo00=NmgooOol047oo00=Nmgoo
Ool017oo00=NmgooOol03Goo00<007ooOol0A7oo000lOol00`00Oomoo`0IOol00ekgOomoo`0UOol0
0ekgOomoo`0KOol00ekgOomoo`07Ool00ekgOomoo`0OOol00ekgOomoo`0<Ool00ekgOomoo`06Ool0
0ekgOomoo`0@Ool00ekgOomoo`0<Ool00ekgOomoo`0=Ool00ekgOomoo`0?Ool00`;]Oomoo`06Ool0
0ekgOomoo`0<Ool00`00Oomoo`14Ool003aoo`03001oogoo01Uoo`03G_Moogoo02Aoo`03G_Moogoo
01eoo`03G_Moogoo00Ioo`03G_Moogoo01moo`03G_Moogoo00aoo`03G_Moogoo00Ioo`03G_Moogoo
011oo`03G_Moogoo00aoo`03G_Moogoo00eoo`03G_Moogoo00ioo`<2k@Qoo`03G_Moogoo00]oo`03
001oogoo04Aoo`00?7oo00<007ooOol06Goo00=NmgooOol097oo00=NmgooOol07Goo00=NmgooOol0
1Woo00=NmgooOol07goo00=NmgooOol02goo00=NmgooOol027oo00=NmgooOol03goo00=NmgooOol0
37oo00=NmgooOol03Goo00=NmgooOol03goo00<2kGooOol01goo00=NmgooOol02goo00<007ooOol0
A7oo000lOol00`00Oomoo`0IOol00ekgOomoo`0TOol00ekgOomoo`0NOol00ekgOomoo`05Ool00ekg
Oomoo`0POol00ekgOomoo`0:Ool00ekgOomoo`08Ool00ekgOomoo`0?Ool00ekgOomoo`0<Ool00ekg
Oomoo`0=Ool00ekgOomoo`0>Ool00`;_G_Moo`09Ool00ekgOomoo`0:Ool00`00Oomoo`14Ool003ao
o`03001oogoo01Uoo`03G_Moogoo02Aoo`03G_Moogoo01moo`03G_Moogoo00=oo`03G_Moogoo025o
o`03G_Moogoo00Uoo`03G_Moogoo00Uoo`03G_Moogoo00moo`03G_Moogoo00aoo`03G_Moogoo00eo
o`03G_Moogoo00eoo`<2k`Yoo`03G_Moogoo00Yoo`03G_Moogoo04Aoo`00?7oo00<007ooOol06Goo
00=NmgooOol097oo00=NmgooOol07goo00=NmgooOol00goo00=NmgooOol08Woo00=NmgooOol027oo
00=NmgooOol02Goo00=NmgooOol03goo00=NmgooOol037oo00=NmgooOol03Goo00=NmgooOol03Woo
00<2kgooOol02Woo00=NmgooOol02Goo00=NmgooOol0A7oo000lOol00`00Oomoo`0IOol00ekgOomo
o`0SOol00ekgOomoo`0QOol00ekgOomoo`02Ool00ekgOomoo`0ROol00ekgOomoo`07Ool00ekgOomo
o`0;Ool00ekgOomoo`0>Ool00ekgOomoo`0<Ool00ekgOomoo`0=Ool00ekgOomoo`0=Ool00`;bG_Mo
o`0;Ool00ekgOomoo`08Ool00ekg001oo`15Ool003aoo`03001oogoo01Qoo`03G_Moogoo02Aoo`03
G_Moogoo029oo`04G_MoogooG_LUOol00ekgOomoo`07Ool00ekgOomoo`0;Ool00ekgOomoo`0>Ool0
0ekgOomoo`0<Ool00ekgOomoo`0<Ool00ekgOomoo`0=Ool30_8=Ool00ekgOomoo`07Ool00ekg001o
o`15Ool003aoo`03001oogoo01Qoo`03G_Moogoo02Aoo`03G_Moogoo02=oo`03G_Mooekg02Ioo`03
G_Moogoo00Ioo`03G_Moogoo00]oo`03G_Moogoo00ioo`03G_Moogoo00aoo`03G_Moogoo00aoo`03
G_Moogoo00ioo`030_9Nmgoo00aoo`03G_Moogoo00Ioo`03G_Moo`0004Ioo`00?7oo00<007ooOol0
67oo00=NmgooOol097oo00=NmgooOol08goo00=NmgooG_L09Woo00=NmgooOol01Goo00=NmgooOol0
37oo00=NmgooOol03Woo00=NmgooOol037oo00=NmgooOol037oo00=NmgooOol03Woo00=NmgooOol0
3Goo00=NmgooOol01Goo00=Nmgoo0000AWoo000lOol00`00Oomoo`0HOol00ekgOomoo`0TOol00ekg
Oomoo`0TOol2G_LWOol00ekgOomoo`04Ool00ekgOomoo`0=Ool00ekgOomoo`0>Ool00ekgOomoo`0;
Ool00ekgOomoo`0<Ool00ekgOomoo`0=Ool00`;dG_Moo`0>Ool00ekgOomoo`05Ool00ekgOol00016
Ool003aoo`8001Uoo`03G_Moogoo02=oo`03G_Moogoo02Eoo`9NmbMoo`03G_Moogoo00=oo`03G_Mo
ogoo00ioo`03G_Moogoo00ioo`03G_Moogoo00]oo`03G_Moogoo00aoo`03G_Moogoo00aoo`<2m11o
o`03G_Moogoo00=oo`04G_Moo`000016Ool003aoo`03001oogoo01Qoo`03G_Moogoo02=oo`03G_Mo
ogoo02Eoo`9NmbMoo`03G_Moogoo00=oo`03G_Moogoo00ioo`03G_Moogoo00ioo`03G_Moogoo00]o
o`03G_Moogoo00aoo`03G_Moogoo00eoo`030_ANmgoo00moo`03G_Moogoo00=oo`04G_Moogoo0016
Ool003aoo`03G_Moogoo01Qoo`03G_Moogoo02=oo`03G_Moogoo02Eoo`03G_Mooekg02Moo`05G_Mo
ogooOomNm`0AOol00ekgOomoo`0>Ool00ekgOomoo`0;Ool00ekgOomoo`0<Ool00ekgOomoo`0<Ool0
0`;fG_Moo`0@Ool00ekgOomoo`02Ool01EkgOomoogoo0000AWoo000lOol00`00G_MNm`0HOol00ekg
Oomoo`0SOol00ekgOomoo`0UOol015kgOomooekg9Woo00ENmgooOomooekg015oo`03G_Moogoo00io
o`03G_Moogoo00]oo`03G_Moogoo00aoo`03G_Moogoo00]oo`<2mQ9oo`05G_MoogooOomNm`03Ool0
0`00Oomoo`14Ool003aoo`04001oogooG_LFOol00ekgOomoo`0TOol00ekgOomoo`0TOol01EkgOomo
ogooG_L09goo00=NmgooG_L04goo00=NmgooOol03Goo00=NmgooOol02goo00=NmgooOol037oo00=N
mgooOol037oo00<2mUkgOol04Goo00ENmgooOomooekg00=oo`03001oogoo04Aoo`00?7oo00@007oo
Oomoo`9NmaAoo`03G_Moogoo02Aoo`03G_Moogoo02Aoo`03G_Moogoo009oo`03G_Moogoo02Aoo`03
G_Mooekg01=oo`03G_Moogoo00eoo`03G_Moogoo00]oo`03G_Moogoo00]oo`03G_Moogoo00ioo`03
G_Moogoo015oo`03G_Mooekg00Aoo`03001oogoo04Aoo`00?7oo00<007ooOol00goo00=NmgooOol0
4Goo00=NmgooOol08goo00=NmgooOol09Goo00=NmgooOol00goo00=NmgooOol08goo0Ukg57oo00=N
mgooOol03Goo00=NmgooOol02goo00=NmgooOol02goo00=NmgooOol02goo00<2]gooG_L057oo00=N
mgooG_L017oo00<007ooOol0A7oo000lOol00`00Oomoo`04Ool2G_LAOol00ekgOomoo`0SOol00ekg
Oomoo`0UOol00ekgOomoo`04Ool00ekgOomoo`0SOol00ekgOomoo`0BOol00ekgOomoo`0=Ool00ekg
Oomoo`0;Ool00ekgOomoo`0;Ool00ekgOomoo`0:Ool30[L00ekgOomoo`0BOol2G_L5Ool00`00Oomo
o`14Ool003aoo`03001oogoo00Ioo`03G_Moogoo00ioo`03G_Moogoo02=oo`03G_Moogoo02Aoo`03
G_Moogoo00Eoo`03G_Moogoo029oo`9NmaEoo`03G_Moogoo00eoo`03G_Moogoo00Yoo`03G_Moogoo
00]oo`03G_Moogoo00]oo`030[Mooekg01Eoo`03G_Moogoo00=oo`03001oogoo04Aoo`00?7oo00<0
07ooOol01goo0Ukg3Woo00=NmgooOol08goo00=NmgooOol097oo00=NmgooOol01Woo00=NmgooOol0
8Goo00=NmgooG_L057oo00=NmgooOol03Goo00=NmgooOol02Woo00=NmgooOol02goo00=NmgooOol0
2Woo00@2MgooOomNmaEoo`03G_Moogoo00=oo`03001oogoo04Aoo`00?7oo00<007ooOol02Goo00=N
mgooOol02goo00=NmgooOol08goo00=NmgooOol097oo00=NmgooOol01goo00=NmgooOol07goo00AN
mgooOomNmaAoo`03G_Moogoo00eoo`03G_Moogoo00Yoo`03G_Moogoo00]oo`03G_Moogoo00Uoo`<2
M`03OomNmgoo01=oo`03G_Mooekg00Aoo`03001oogoo04Aoo`00?7oo00<007ooOol02Woo0Ukg2goo
00=NmgooOol08goo00=NmgooOol097oo00=NmgooOol01goo00=NmgooOol07goo00ANmgooOomNmaAo
o`03G_Moogoo00eoo`03G_Moogoo00Yoo`03G_Moogoo00]oo`03G_Moogoo00Yoo`030WMooekg01Eo
o`03G_Mooekg00Aoo`03001oogoo04Aoo`00?7oo00<007ooOol037oo00=NmgooOol01goo00=Nmgoo
Ool097oo00=NmgooOol097oo00=NmgooOol027oo00=NmgooOol07Woo00ENmgooOomooekg01Aoo`03
G_Moogoo00aoo`03G_Moogoo00Yoo`03G_Moogoo00]oo`03G_Moogoo00aoo`03G_Moogoo019oo`04
G_MoogooG_L4Ool00`00Oomoo`0aOol00`00Oomoo`0@Ool003aoo`03001oogoo00eoo`9Nm`Moo`03
G_Moogoo02=oo`03G_Moogoo02Eoo`03G_Moogoo00Uoo`03G_Moogoo01aoo`03G_Moogoo009oo`03
G_Moogoo019oo`03G_Moogoo00aoo`03G_Moogoo00Yoo`03G_Moogoo00]oo`03G_Moogoo00Uoo`04
0SMoogooG_LDOol01EkgOomoogooG_L00goo00<007ooOol087oo35`017oo00<007oo00004Goo000l
Ool00`00Oomoo`0?Ool00ekgOomoo`04Ool00ekgOomoo`0SOol00ekgOomoo`0TOol00ekgOomoo`0:
Ool00ekgOomoo`0LOol00ekgOomoo`03Ool00ekgOomoo`0AOol00ekgOomoo`0<Ool00ekgOomoo`0:
Ool00ekgOomoo`0:Ool00ekgOomoo`09Ool30SL00gooG_Moo`0BOol00ekgOomoo`02Ool01EkgOomo
ogoo00008Woo00EH05`0G01L05P000=L0004F01L05`0G004Ool00`00Ool0000AOol003aoo`03001o
ogoo011oo`9Nm`Aoo`03G_Moogoo02=oo`03G_Moogoo02Aoo`03G_Moogoo00]oo`03G_Moogoo01]o
o`03G_Moogoo00=oo`03G_Moogoo015oo`03G_Moogoo00aoo`03G_Moogoo00Yoo`03G_Moogoo00Yo
o`03G_Moogoo00Yoo`030SMooekg01Aoo`03G_Moogoo00=oo`04G_Moogoo000ROol<G004Ool00`00
Ool0000AOol003aoo`03001oogoo019oo`05G_MoogooOomNm`0UOol00ekgOomoo`0TOol00ekgOomo
o`0<Ool00ekgOomoo`0IOol00ekgOomoo`04Ool00ekgOomoo`0AOol00ekgOomoo`0<Ool00ekgOomo
o`0:Ool00ekgOomoo`0:Ool00ekgOomoo`09Ool0107GOomooekg57oo00=NmgooOol00goo00ANmgoo
Ool0029oo`9L0005F01L05`0G01H0003G0000eP0G01oo`03Ool00`00Ool0000AOol003aoo`03001o
ogoo01=oo`9Nm`03OomNmgoo02Aoo`03G_Moogoo02Aoo`03G_Moogoo00aoo`03G_Moogoo01Uoo`03
G_Moogoo00Eoo`03G_Moogoo015oo`03G_Moogoo00]oo`03G_Moogoo00Yoo`03G_Moogoo00Yoo`03
G_Moogoo00Qoo`<1e`03OomNmgoo019oo`03G_Moogoo00Aoo`04G_Moogoo000ROol2G0401E`2G05L
0E`1G0800e`100=L0U`1Ool017oo00<007ooOol047oo000lOol00`00Oomoo`0EOol2G_LUOol00ekg
Oomoo`0TOol00ekgOomoo`0=Ool00ekgOomoo`0HOol00ekgOomoo`05Ool00ekgOomoo`0AOol00ekg
Oomoo`0<Ool00ekgOomoo`09Ool00ekgOomoo`0:Ool00ekgOomoo`09Ool0107GOomooekg4goo00=N
mgooOol01Goo00=Nmgoo00008Woo00aH0E`2G05L0UP1G09L0E`2F05L0U`1G08HOol003aoo`03001o
ogoo01Ioo`9NmbAoo`03G_Moogoo02Aoo`03G_Moogoo00ioo`03G_Moogoo01Ioo`03G_Moogoo00Mo
o`03G_Moogoo011oo`03G_Moogoo00aoo`03G_Moogoo00Uoo`03G_Moogoo00Yoo`03G_Moogoo00]o
o`03G_Moogoo015oo`03G_Moogoo00Ioo`03G_Moo`00029oo`05G09L0E`1G05L0P03G04015`2G05L
0E`167oo000lOol00`00Oomoo`0EOol015kgOomooekg8Woo00=NmgooOol097oo00=NmgooOol047oo
00=NmgooOol05Goo00=NmgooOol01goo00=NmgooOol047oo00=NmgooOol037oo00=NmgooOol02Goo
00=NmgooOol02Woo00=NmgooOol027oo00@1UgooOomNma=oo`03G_Moogoo00Ioo`03G_Moo`00029o
o`0<G0=L15P3G0AL0e`4F0=L15`3G0AH0e`467oo000lOol00`00Oomoo`0EOol015kgOomoogoo0Ukg
87oo00=NmgooOol097oo00=NmgooOol047oo00=NmgooOol05Goo00=NmgooOol01goo00=NmgooOol0
4Goo00=NmgooOol02goo00=NmgooOol02Goo00=NmgooOol02Woo00=NmgooOol01goo0`6G00=ooekg
Ool04Woo00=NmgooOol01goo00=Nm`00Ool08Goo35`467oo000lOol2000FOol00ekgOomoo`03Ool0
0ekgOomoo`0MOol00ekgOomoo`0TOol00ekgOomoo`0AOol00ekgOomoo`0COol00ekgOomoo`09Ool0
0ekgOomoo`0@Ool00ekgOomoo`0;Ool00ekgOomoo`09Ool00ekgOomoo`0:Ool00ekgOomoo`08Ool0
106GOomooekg4Woo00=NmgooOol027oo00=Nm`00Ool08Goo00aH0e`4G0=L15P3G0AL0e`4F0=L15`3
G0@HOol003aoo`03001oogoo01Eoo`03G_Moogoo00Aoo`9Nmaeoo`03G_Moogoo02Aoo`03G_Moogoo
019oo`03G_Moogoo019oo`03G_Moogoo00Uoo`03G_Moogoo011oo`03G_Moogoo00]oo`03G_Moogoo
00Uoo`03G_Moogoo00Uoo`03G_Moogoo00Qoo`040EMoogooG_LCOol00ekgOomoo`09Ool00ekgOomo
o`0POol<G0HHOol003aoo`03001oogoo01Eoo`03G_Moogoo00Ioo`03G_Moogoo01Yoo`03G_Moogoo
02Aoo`03G_Moogoo019oo`03G_Moogoo019oo`03G_Moogoo00Yoo`03G_Moogoo00moo`03G_Moogoo
00]oo`03G_Moogoo00Uoo`03G_Moogoo00Uoo`03G_Moogoo00Moo`050EL1=P5GOomNm`0BOol00ekg
Oomoo`0:Ool00ekgOomoo`0POol2G0H01UP6G0ML1U`6F0IL1`9L1P03F0IL1goo01Moo`00?7oo00<0
07ooOol05Goo00=NmgooOol01goo0Ukg6Woo00=NmgooOol097oo00=NmgooOol04goo00=NmgooOol0
47oo00=NmgooOol02goo00=NmgooOol047oo00=NmgooOol02Woo00=NmgooOol02Goo00=NmgooOol0
2Goo00=NmgooOol027oo00@1EgooOomNma9oo`03G_Moogoo00Yoo`03001oogoo021oo`aL1QQoo`00
?7oo00<007ooOol05Goo00=NmgooOol02Goo00=NmgooOol05goo00=NmgooOol08goo00=NmgooOol0
5Goo00=NmgooOol03goo00=NmgooOol02goo00=NmgooOol047oo00=NmgooOol02Woo00=NmgooOol0
2Goo00=NmgooOol02Goo00=NmgooOol01Woo00<0mgooOol00Woo00=NmgooOol047oo00=NmgooOol0
2Woo00<007ooOol087oo00aH25`9G0QL2EP8G0UL25`9F0QL2E`8G0THOol003aoo`03001oogoo01Eo
o`03G_Moogoo00Yoo`9NmaMoo`03G_Moogoo02=oo`03G_Moogoo01Eoo`03G_Moogoo00moo`03G_Mo
ogoo00aoo`03G_Moogoo00moo`03G_Moogoo00]oo`03G_Moogoo00Qoo`03G_Moogoo00Uoo`03G_Mo
ogoo00Eoo`<0m`=oo`03G_Moogoo00moo`03G_Moogoo00]oo`03001oogoo021oo`0<G0UL25`9G0QL
2E`8G0UL25`9G0QL2E`867oo000lOol00`00Oomoo`0EOol00ekgOomoo`0<Ool00ekgOomoo`0COol0
0ekgOomoo`0TOol00ekgOomoo`0FOol00ekgOomoo`0=Ool00ekgOomoo`0=Ool00ekgOomoo`0?Ool0
0ekgOomoo`0;Ool00ekgOomoo`08Ool00ekgOomoo`09Ool00ekgOomoo`06Ool01@3gOomoogooG_L0
4Woo00=NmgooOol02goo00<007ooOol087oo00aL25`9F0QL2E`8G0UH25`9G0QL2EP8G0THOol003ao
o`03001oogoo01Aoo`03G_Moogoo00ioo`9Nma=oo`03G_Moogoo02Aoo`03G_Moogoo01Moo`03G_Mo
ogoo00aoo`03G_Moogoo00ioo`03G_Moogoo00ioo`03G_Moogoo00]oo`03G_Moogoo00Qoo`03G_Mo
ogoo00Uoo`03G_Moogoo00Yoo`03G_Moogoo00moo`03G_Moogoo00aoo`03001oogoo021oo`0<G0UL
25`9G0QL2E`8G0UL25`9G0QL2E`867oo000lOol00`00Oomoo`0DOol00ekgOomoo`0@Ool00ekgOomo
o`0@Ool00ekgOomoo`0TOol00ekgOomoo`0GOol00ekgOomoo`0<Ool00ekgOomoo`0>Ool00ekgOomo
o`0?Ool00ekgOomoo`0:Ool00ekgOomoo`08Ool00ekgOomoo`09Ool00ekgOomoo`05Ool00`2gOomo
o`02Ool00ekgOomoo`0?Ool00ekgOomoo`0<Ool00`00Oomoo`0POol01EP:G0]L2e`;F0X00e`;00AH
2U`;G0]L2aQoo`00?7oo00<007ooOol057oo00=NmgooOol04Goo0Ukg47oo00=NmgooOol097oo00=N
mgooOol067oo00=NmgooOol02Woo00=NmgooOol03goo00=NmgooOol03goo00=NmgooOol02Woo00=N
mgooOol027oo00=NmgooOol02Goo00=NmgooOol017oo0`2g0goo00=NmgooOol03goo00=NmgooOol0
37oo00<007ooOol087oo35`;67oo000lOol00`00Oomoo`0DOol00ekgOomoo`0COol00ekgOomoo`0=
Ool00ekgOomoo`0SOol00ekgOomoo`0JOol00ekgOomoo`09Ool00ekgOomoo`0@Ool00ekgOomoo`0>
Ool00ekgOomoo`0:Ool00ekgOomoo`08Ool00ekgOomoo`08Ool00ekgOomoo`06Ool01@2gOomoogoo
G_L04Goo00=NmgooOol03Goo00<007ooOol087oo0U`;00EH2U`;G0]L2eP:00=L2`03F0YL2goo01Mo
o`00?7oo00<007ooOol057oo00=NmgooOol057oo0Ukg3Goo00=NmgooOol08goo00=NmgooOol06goo
00<2hGooOol027oo00=NmgooOol047oo00=NmgooOol03Woo00=NmgooOol02Woo00=NmgooOol027oo
00=NmgooOol027oo00=NmgooOol01Goo00<0MgooOol00Woo00=NmgooOol03goo00=NmgooOol03Goo
00<007ooOol087oo0U`=00EL3U`=G0eL3E`>00=L3@03G0iL3Goo01Moo`00?7oo00<007ooOol057oo
00=NmgooOol05Woo00=NmgooOol02Woo00=NmgooOol08goo00=NmgooOol06Woo0`;Q00<2i7ooOol0
1Woo00=NmgooOol047oo00=NmgooOol03goo00=NmgooOol02Goo00=NmgooOol027oo00=NmgooOol0
27oo00=NmgooOol017oo00<0M`1G07L00goo00=NmgooOol03Woo00=NmgooOol03Woo00<007ooOol0
87oo00aH3E`>G0eL3UP=G0iL3E`>F0eL3U`=G0hHOol003aoo`03001oogoo01Aoo`03G_Moogoo01Mo
o`03G_Moogoo00Qoo`03G_Moogoo02Aoo`03G_Moogoo01]oo`040^42i0;T0^@6Ool00ekgOomoo`0B
Ool00ekgOomoo`0>Ool00ekgOomoo`09Ool00ekgOomoo`08Ool00ekgOomoo`08Ool00ekgOomoo`05
Ool00`1gOomoo`02Ool00ekgOomoo`0>Ool00ekgOomoo`0>Ool00`00Oomoo`0POol01E`>G0eL3E`=
G0h00e`=00AL3U`=G0eL3AQoo`00?7oo00<007ooOol057oo00=NmgooOol067oo0Ukg27oo00=Nmgoo
Ool097oo00=NmgooOol07Goo00<2i0;VOol01Goo00=NmgooOol04Woo00=NmgooOol03Woo00=Nmgoo
Ool02Goo00=NmgooOol027oo00=NmgooOol027oo00=NmgooOol02Goo00=NmgooOol03goo00=Nmgoo
Ool03Woo00<007ooOol087oo00aL3e`@F0mL45`?G11H3e`@G0mL45P?G10HOol003aoo`03001oogoo
01Aoo`03G_Moogoo01Yoo`03G_Moogoo00Eoo`03G_Moogoo02Aoo`03G_Moogoo01eoo`<2iPEoo`03
G_Moogoo01=oo`03G_Moogoo00eoo`03G_Moogoo00Yoo`03G_Moogoo00Moo`03G_Moogoo00Qoo`03
G_Moogoo00Aoo`0301Moogoo009oo`03G_Moogoo00ioo`03G_Moogoo00moo`03001oogoo021oo`aL
41Qoo`00?7oo00<007ooOol057oo00=NmgooOol06goo0Ukg1Goo00=NmgooOol097oo00=NmgooOol0
7Woo00<2iP;X0^P017oo00=NmgooOol04goo00=NmgooOol03Goo00=NmgooOol02Woo00=NmgooOol0
1goo00=NmgooOol027oo00=NmgooOol00goo00<05`0g01L00goo00=NmgooOol03Woo00=NmgooOol0
3goo00<007ooOol087oo00aH3e`@G0mL45P?G11L3e`@F0mL45`?G10HOol003aoo`03001oogoo01Ao
o`03G_Moogoo01eoo`03G_Moogoo009oo`03G_Moogoo02=oo`03G_Moogoo021oo`030^Qoo`;[009o
o`03G_Moogoo01Aoo`03G_Moogoo00ioo`03G_Moogoo00Uoo`03G_Moogoo00Moo`03G_Moogoo00Qo
o`03G_Moogoo00Aoo`0301Moogoo009oo`03G_Moogoo00eoo`03G_Moogoo011oo`03001oogoo021o
o`aL4QQoo`00?7oo00<007ooOol04goo00=NmgooOol07goo0Ukg0Woo00=NmgooOol08goo00=Nmgoo
Ool087oo00INm`;[0^X2jgooG_LGOol00ekgOomoo`0=Ool00ekgOomoo`09Ool00ekgOomoo`07Ool0
0ekgOomoo`08Ool00ekgOomoo`02Ool00`0GOomoo`04Ool00ekgOomoo`0=Ool00ekgOomoo`0@Ool0
0`00Oomoo`0POol2G1801UPBG1=L4U`BF19L4`9L4P03F19L4goo01Moo`00?7oo00<007ooOol04goo
00=NmgooOol08Goo00=NmgooG_L09Goo00=NmgooOol08Goo00ENm`;[0^d2kEkg01Moo`03G_Moogoo
00eoo`03G_Moogoo00Uoo`03G_Moogoo00Moo`03G_Moogoo00Moo`03G_Moogoo009oo`0301L45`0G
00Aoo`03G_Moogoo00ioo`03G_Moogoo011oo`03001oogoo021oo`aL4QQoo`00?7oo00<007ooOol0
4goo00=NmgooOol08Woo0Ukg9Goo00=NmgooOol08Woo00ANm`;]0^mNmaQoo`03G_Moogoo00aoo`03
G_Moogoo00Uoo`03G_Moogoo00Moo`03G_Moogoo00Moo`03G_Moogoo00=oo`0301Moogoo00=oo`03
G_Moogoo00eoo`03G_Moogoo015oo`03001oogoo021oo`06F19L4e`BG19H4U`C0U`B00AH4U`CG19L
4QQoo`00=Goo0`0017oo00<007ooOol04goo00=NmgooOol08Woo00=NmgooG_L097oo00=NmgooOol0
8Woo00ENm`;_0_02k`;b01Moo`03G_Moogoo00eoo`03G_Moogoo00Qoo`03G_Moogoo00Moo`03G_Mo
ogoo00Moo`03G_Moogoo00Uoo`03G_Moogoo00eoo`03G_Moogoo015oo`03001oogoo021oo`0<G1EL
55`EG1AL5E`DG1EL55`EG1AL5E`D67oo000eOol00`00Oomoo`04Ool00`00Oomoo`0COol00ekgOomo
o`0ROol00ekgOomoo`02G_LROol00ekgOomoo`0SOol01Ekg0^l2lP;a0_805Woo00=NmgooOol03Goo
00=NmgooOol027oo00=NmgooOol01goo00=NmgooOol01goo00=NmgooOol00Woo00<<5gooOol017oo
00=NmgooOol037oo00=NmgooOol04Woo00<007ooOol087oo00aL55`EF1AL5E`DG1EH55`EG1AL5EPD
G1DHOol0031oo`<000=oo`03001oogoo00=oo`8001Aoo`03G_Moogoo029oo`03G_Moogoo009oo`03
G_Moogoo01ioo`03G_Moogoo02Eoo`04G_Moo`;b0_@GOol00ekgOomoo`0<Ool00ekgOomoo`08Ool0
0ekgOomoo`04Ool7G_L6Ool015kgOomoogoo0``G17oo00=NmgooOol03Goo00=NmgooOol047oo0`00
8Woo00aL5E`DG1EL55`EG1AL5E`DG1EL55`EG1@HOol003Ioo`03001oogoo00=oo`03001oogoo01=o
o`03G_Moogoo029oo`03G_Moogoo00=oo`9Nmaioo`03G_Moogoo02Eoo`9Nm`<2m1Ioo`03G_Moogoo
00aoo`03G_Moogoo00Uoo`04G_MoogooOol2G_L3Ool015kgOomoogoo0Ukg17oo00=NmgooOol00Woo
00<<5gooOol00goo00=NmgooOol03Goo00=NmgooOol04Woo00<007ooOol087oo00EH5U`GG1ML5ePF
00=L5`04F1IL5e`GG1LHOol003Eoo`03001oo`0000Aoo`03001oogoo01=oo`03G_Moogoo029oo`03
G_Moogoo00Eoo`03G_Moogoo01]oo`03G_Moogoo02Aoo`07G_MooekgOol2m0;g0_H05Woo00=Nmgoo
Ool037oo00=NmgooOol027oo00ANmgooG_MNm`Eoo`03G_Moogoo00=oo`=Nm`03OomNmgoo009oo`03
51Moogoo00Aoo`03G_Moogoo00aoo`03G_Moogoo01=oo`03001oogoo021oo`aL5aQoo`00=Woo00<0
07ooOol00goo00<007ooOol04goo00=NmgooOol08Woo00=NmgooOol01Woo0Ukg6goo00=NmgooOol0
97oo00QNmgooOomNmgoo0_Ioo`:g5Goo00=NmgooOol037oo00=NmgooOol027oo0Ukg1goo00=Nmgoo
Ool01Woo0Ukg0Woo0a@G1Goo00=NmgooOol037oo00=NmgooOol04goo00<007ooOol087oo0U`G00EH
5U`GG1ML5ePF00=L5`03F1IL5goo01Moo`00?7oo00<007ooOol04goo00=NmgooOol08Woo00=Nmgoo
Ool027oo00=NmgooOol067oo00=NmgooOol097oo00INmgooOomooekgOol30[LDOol00ekgOomoo`0<
Ool00ekgOomoo`06Ool3G_L8Ool00ekgOomoo`07Ool3G_L00goo51Moo`04Ool00ekgOomoo`0<Ool0
0ekgOomoo`0DOol00`00Oomoo`0POol035@GD1MD5e0GE1M@5e@GD1MD5e0GE1M@5aQoo`00?7oo00<0
07ooOol04goo00=NmgooOol08Woo00=NmgooOol02Goo0Ukg67oo00=NmgooOol097oo00ENmgooOomo
oekg009oo`030[L2M`9g01Aoo`03G_Moogoo00]oo`03G_Moogoo00Eoo`04G_MoogooG_L8Ool00ekg
Oomoo`06Ool01EkgOomoogooG_L01Woo00=NmgooOol037oo00=NmgooOol057oo00<007ooOol087oo
00a@5U@GD1MD5e0FE1M@5e@GD1ID5e0GE1LHOol003aoo`03001oogoo019oo`03G_Moogoo02=oo`03
G_Moogoo00]oo`03G_Moogoo01Eoo`03G_Moogoo02Aoo`03G_Moogoo009oo`05G_Moogoo0WL2=`0D
Ool00ekgOomoo`0;Ool00ekgOomoo`04Ool01EkgOomoogooG_L027oo00=NmgooOol01Woo00INmgoo
OolL5gooG_L5Ool00ekgOomoo`0;Ool00ekgOomoo`0EOol00`00Oomoo`0POol035@GD1MD5e0GE1M@
5e@GD1MD5e0GE1M@5aQoo`00?7oo00<007ooOol04Woo00=NmgooOol08goo00=NmgooOol037oo0Ukg
57oo00=NmgooOol097oo00=NmgooOol017oo00=Nmgoo0SL00P8g00<1egooOol04Goo00=NmgooOol0
2goo00=NmgooOol00goo00ENmgooOomooekg00Qoo`03G_Moogoo00Ioo`06G_Mooa`G81LL5ekg1Goo
00=NmgooOol02goo00=NmgooOol05Goo00<007ooOol087oo0TPG00I85T`GB1M85dPFC1L2B1L00dPF
C1Moo`0GOol003aoo`03001oogoo019oo`03G_Moogoo029oo`03G_Moogoo00moo`03G_Moogoo015o
o`03G_Moogoo02Aoo`03G_Moogoo00Aoo`04G_Moogoo0SL30MLBOol00ekgOomoo`0;Ool00ekgOomo
o`02Ool00ekgOomoo`02Ool00ekgOomoo`06Ool00ekgOomoo`06Ool015kgOomooa`G0Woo00ENmgoo
Oomooekg00ioo`03G_Moogoo01Eoo`03G_Moogoo021oo`a85aQoo`00?7oo00<007ooOol04Woo00=N
mgooOol08Woo00=NmgooOol047oo0Ukg4Goo00=NmgooOol097oo00=NmgooOol01Goo00INmgooOomo
o`7G0ILBOol00ekgOomoo`0;Ool01EkgOomoogooG_L01Goo00=NmgooOol01Woo00=NmgooOol01Woo
00=Nmgoo:1L017oo00ANmgooOomNm`eoo`03G_Moogoo01Eoo`03G_L007oo025oo`06B1I<5dPGB1M8
5T`G0TPG00A85T`GB1M85aQoo`00?7oo00<007ooOol04Woo00=NmgooOol08Woo00=NmgooOol04Woo
00=NmgooOol03Woo00=NmgooOol097oo00=NmgooOol01Woo00=NmgooOol00`6G4Woo00=NmgooOol0
2Woo00ANmgooOomNm`Ioo`03G_Moogoo00Ioo`03G_Moogoo00Ioo`04G_LX5bPG:1L4Ool00ekgOomN
m`0=Ool00ekgOomoo`0EOol00ekg001oo`0QOol<B1LHOol003aoo`03001oogoo019oo`03G_Moogoo
029oo`03G_Moogoo01=oo`9Nm`ioo`03G_Moogoo02Aoo`03G_Moogoo00Ioo`07G_MoogooOol1U`4g
0EL04Goo00=NmgooOol02goo0Ukg27oo00=NmgooOol01Goo00=NmgooOol01Woo00=Nmgoo:1L01Woo
0Ukg37oo00=NmgooOol05Goo00=Nmgoo00008Woo00`l5d0G?1I05c`G@1Ll5T0G?1M05c`F@1LHOol0
03aoo`03001oogoo019oo`03G_Moogoo029oo`03G_Moogoo01Eoo`03G_Moogoo00]oo`03G_Moogoo
02Aoo`03G_Moogoo00Moo`07G_MoogooOol1Egoo0?L04Goo00=NmgooOol02Woo0Ukg27oo00=Nmgoo
Ool01Goo00=NmgooOol01Woo00=NmgooOol01Woo0Ukg37oo00=NmgooOol057oo00ANmgooOol0029o
o`a05aQoo`00?7oo00<007ooOol04Woo00=NmgooOol08Woo00=NmgooOol05Woo0Ukg2goo00=Nmgoo
Ool097oo00=NmgooOol027oo00ANmgooOomoo`<0ma1oo`03G_Moogoo00Yoo`03G_Moogoo00Moo`03
G_Moogoo00Eoo`03G_Moogoo00Ioo`03G_L`5goo00Ioo`9Nm`aoo`03G_Moogoo01Aoo`04G_Moogoo
000ROol033`F@1Ll5d0G?1I05c`G@1Ll5T0G?1M05aQoo`00?7oo00<007ooOol04Woo00=NmgooOol0
8Woo00=NmgooOol067oo00=NmgooOol01goo00=NmgooOol097oo00=NmgooOol02Woo00INmgooOomo
o`3g0;L@Ool00ekgOomoo`09Ool2G_L9Ool00ekgOomoo`05Ool00ekgOomoo`05Ool015kg<1L`5c0G
1Woo00=NmgooG_L02Woo00=NmgooOol057oo00ENmgooOomoo`00029oo`05>1Ld5c@G=1Lh5`03=1L0
13PG=1Ld5c@G67oo000lOol00`00Oomoo`0BOol00ekgOomoo`0ROol00ekgOomoo`0IOol2G_L7Ool0
0ekgOomoo`0TOol00ekgOomoo`0:Ool015kgOomoogoo0`2g47oo00=NmgooOol01goo00ANmgooOomN
m`Qoo`03G_Moogoo00Eoo`03G_Moogoo00Eoo`03G_Mooc0G00Moo`04G_MoogooG_L9Ool00ekgOomo
o`0COol00ekgOomoo`02Ool00`00Oomoo`0POol033@G>1Ld5SPG=1Lh5c@F>1Ld5cPG=1Hh5aQoo`00
?7oo00<007ooOol04Woo00=NmgooOol08Woo00=NmgooOol06goo00=NmgooOol017oo00=NmgooOol0
97oo00=NmgooOol02goo00ENmgooOomoo`2g0080M`moo`03G_Moogoo00Moo`04G_MoogooG_L8Ool0
0ekgOomoo`05Ool00ekgOomoo`05Ool00cPGOomoo`07Ool015kgOomooekg27oo00=NmgooOol04goo
00=NmgooOol00goo00<007ooOol087oo0S@G00Dh5c@G=1Ld5cPG00<d5`03>1Ld5goo01Moo`00?7oo
00<007ooOol04Woo00=NmgooOol08Woo00=NmgooOol077oo0Ukg17oo00=NmgooOol097oo00=Nmgoo
Ool037oo00MNmgooOomoo`1gOol05`0?Ool00ekgOomoo`05Ool01EkgOomoogooG_L027oo00=Nmgoo
Ool01Goo00=NmgooOol017oo0cPG1goo00=NmgooOol00Woo00=NmgooOol01Goo00=NmgooOol04goo
00=NmgooOol00goo00<007ooOol087oo00DX5R`G;1L/5bPF00</5`04:1H/5b`G;1LHOol003aoo`03
001oogoo015oo`03G_Moogoo02=oo`03G_Moogoo01ioo`05G_MoogooOomNm`0VOol00ekgOomoo`0<
Ool00ekgOomoo`02Ool301L>Ool00ekgOomoo`05Ool01EkgOomoogooG_L027oo00=NmgooOol01Goo
00=NmgooOol01Goo00<h5gooOol01Woo00=NmgooOol00Woo00=NmgooOol01Goo00=NmgooOol04Woo
00=NmgooOol017oo00<007ooOol087oo32`G67oo000lOol00`00Oomoo`0AOol00ekgOomoo`0SOol0
0ekgOomoo`0OOol2G_L00gooG_Moo`0UOol00ekgOomoo`0=Ool00ekgOomoo`02Ool201L>Ool00ekg
Oomoo`04Ool00ekgOomoo`02Ool00ekgOomoo`06Ool00ekgOomoo`05Ool00ekgOomoo`05Ool00ekg
Oomoo`06Ool00ekgOomoo`03Ool00ekgOomoo`03Ool00ekgOomoo`0BOol00ekgOomoo`05Ool00`00
Oomoo`0POol2;1L01BPF;1L/5b`G:1H00b`G00<X5R`GOol05goo000lOol00`00Oomoo`0AOol00ekg
Oomoo`0SOol00ekgOomoo`0QOol00ekgOomoo`0UOol00ekgOomoo`0>Ool025kgOomoogoo01L45`0G
31L=Ool00ekgOomoo`03Ool00ekgOomoo`03Ool00ekgOomoo`06Ool00ekgOomoo`04Ool00ekgOomo
o`04Ool00d@GG_Moo`07Ool00ekgOomoo`03Ool00ekgOomoo`03Ool00ekgOomoo`0BOol00ekgOomo
o`05Ool00`00Oomoo`0POol032@G81LT5b0G91LP5b@G81LT5b0G91LP5aQoo`00?7oo00<007ooOol0
4Goo00=NmgooOol08goo00=NmgooOol08Goo0ekg97oo00=NmgooOol03goo00=NmgooOol00Woo00@0
5``G31L<5`aoo`03G_Moogoo009oo`03G_Moogoo00Aoo`03G_Moogoo00Ioo`03G_Moogoo00Aoo`03
G_Moogoo00=oo`03A1M05d@G00Moo`03G_Moogoo00Eoo`05G_MoogooOomNm`0DOol00ekgOomoo`06
Ool00`00Oomoo`0POol0320F91LP5b@G81HT5b0G91LP5R@G81LT5aQoo`00?7oo00<007ooOol04Goo
00=NmgooOol08goo00=NmgooOol08Goo00ANmgooOomNmb=oo`03G_Moogoo011oo`03G_Moogoo00=o
o`0331LD5goo00aoo`05G_MoogooOomNm`06Ool00ekgOomoo`06Ool00ekgOomoo`04Ool00ekgOomo
o`04Ool00d@GG_Moo`06Ool00ekgOomoo`05Ool01EkgOomoogooG_L04goo00=NmgooOol01goo00<0
07ooOol087oo00`T5b0G91LP5b@G81LT5b0G91LP5b@G81LHOol003aoo`80019oo`03G_Moogoo029o
o`03G_Moogoo029oo`04G_MoogooOol2G_LQOol00ekgOomoo`0AOol00ekgOomoo`02Ool00a@G41HD
5`0<Ool015kgOomooekg1goo00=NmgooOol01Woo00=NmgooOol017oo00=NmgooOol00Woo00=<5goo
G_L027oo00=NmgooOol01Woo00ANmgooOomNma=oo`03G_Moogoo00Ioo`80029oo`0<81LT5b0F91LP
5b@G81HT5b0G91LP5R@G67oo000lOol00`00Oomoo`0AOol00ekgOomoo`0ROol00ekgOomoo`0ROol0
0ekgOomoo`03Ool00ekgOomoo`0NOol00ekgOomoo`0BOol00ekgOomoo`02Ool00a@G71Moo`0;Ool0
15kgOomooekg27oo00=NmgooOol01Goo00=NmgooOol017oo00ANmgooOomoo`=<5`03G_Moogoo00Io
o`03G_Moogoo00Ioo`03G_Mooekg01=oo`03G_Moogoo00Qoo`03001oogoo021oo``H5aQoo`00?7oo
00<007ooOol04Goo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol017oo0Ukg7Woo00=Nmgoo
Ool04Woo00=NmgooOol00Woo0a`G37oo0Ukg2Goo00=NmgooOol01Goo00=NmgooOol017oo00=Nmgoo
Ool00Woo00=<5gooG_L01goo00=NmgooOol027oo0Ukg4Woo00=NmgooOol02Goo00<007ooOol087oo
00HH5Q`G61LH5aPF71L261L011PF71LH5aPG67oo000lOol00`00Oomoo`0AOol00ekgOomoo`0ROol0
0ekgOomoo`0ROol00ekgOomoo`06Ool00ekgOomoo`0KOol00ekgOomoo`0COol00ekgOomoo`02Ool0
0a`GOolX5`0;Ool2G_L9Ool00ekgOomoo`05Ool00ekgOomoo`04Ool00ekgOomoo`04Ool00ekgOomo
o`05Ool00ekgOomoo`08Ool00ekgOomoo`0@Ool00ekgOomoo`0:Ool00`00Oomoo`0POol<61LHOol0
03aoo`03001oogoo015oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo00Moo`9Nma]oo`03
G_Moogoo01Aoo`03G_Moogoo009oo`<X5`]oo`03G_Moogoo00Moo`03G_Moogoo00Eoo`03G_Moogoo
00Aoo`05G_MoogooOomD5`02Ool00ekgOomoo`05Ool00ekgOomoo`08Ool00ekgOomoo`0@Ool00ekg
Oomoo`0:Ool00`00Oomoo`0POol030`G41L<5Q0G31L@5``F41L<5a0G31H@5aQoo`00?7oo00<007oo
Ool04Goo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol02Goo00=NmgooOol05goo00=Nmgoo
Ool05Goo00=NmgooOol00goo00<X5c0G<1L02Goo0Ukg2Woo00=NmgooOol017oo00=NmgooOol017oo
00=NmgooOol00e@G00=ooekgOol01Woo00=NmgooOol027oo0Ukg47oo00=NmgooOol02goo00<007oo
Ool087oo310G67oo000lOol00`00Oomoo`0@Ool00ekgOomoo`0SOol00ekgOomoo`0ROol00ekgOomo
o`0:Ool2G_LGOol00ekgOomoo`0FOol00ekgOomoo`03Ool00c0GOolh5`08Ool2G_L:Ool00ekgOomo
o`04Ool00ekgOomoo`04Ool01EkgOomoogooE1L00Woo00=NmgooOol01Goo00=NmgooOol01goo00=N
mgooG_L03goo00=NmgooOol037oo00<007ooOol087oo00`<5Q0G31L@5``F41L<5a0G31H@5``G41LH
Ool003aoo`03001oogoo011oo`03G_Moogoo02=oo`03G_Moogoo029oo`03G_Moogoo00aoo`03G_Mo
ogoo01Aoo`03G_Moogoo01Moo`03G_Moogoo00=oo`<h5`Moo`03G_Mooekg00Uoo`03G_Moogoo00Eo
o`03G_Moogoo00=oo`03G_Mooe`F00Aoo`03G_Moogoo00Aoo`03G_Moogoo00Qoo`03G_Mooekg00mo
o`03G_Moogoo00aoo`03001oogoo021oo`0521L45`@G11L85`0311L010PG11L45`@G67oo000lOol0
0`00Oomoo`0@Ool00ekgOomoo`0SOol00ekgOomoo`0ROol00ekgOomoo`0=Ool2G_LDOol00ekgOomo
o`0GOol00ekgOomoo`04Ool00cPGA1Moo`05Ool015kgOomooekg2Goo00=NmgooOol01Goo00=Nmgoo
Ool00goo00ANme`FG1ML5P=oo`03G_Moogoo00Aoo`03G_Moogoo00Moo`05G_MoogooOomNm`0=Ool0
0ekgOomoo`0=Ool00`00Oomoo`0POol030@G21L45PPG11L85`@F21L45`PG11H85aQoo`00?7oo00<0
07ooOol047oo00=NmgooOol08goo00=NmgooOol08Goo00=NmgooOol047oo00=NmgooOol04Goo00=N
mgooOol067oo00=NmgooOol00goo00=45d0GA1L01Goo00ENmgooOomooekg00Qoo`03G_Moogoo00Eo
o`03G_Moogoo00=oo`03G_Mooe`F00=oo`03G_Moogoo00Eoo`03G_Moogoo00Moo`05G_MoogooOomN
m`0<Ool00ekgOomoo`0>Ool00`00Oomoo`0POol211L01@PG11L45`@G21L00`@G00<85`@GOol05goo
000lOol00`00Oomoo`0@Ool00ekgOomoo`0SOol00ekgOomoo`0QOol00ekgOomoo`0AOol2G_LAOol0
0ekgOomoo`0IOol00ekgOomoo`03Ool00d@GOom<5`03Ool00ekgOomoo`02Ool00ekgOomoo`07Ool0
0ekgOomoo`04Ool00ekgOomoo`03Ool00ekgG1Aoo`03Ool00ekgOomoo`05Ool00ekgOomoo`07Ool0
0ekgOomoo`02Ool00ekgOomoo`09Ool00ekgOomoo`0>Ool00`00Oomoo`0POol01@0F01L05`0G01H0
0`0G00@05P0G01L05aQoo`00?7oo00<007ooOol047oo00=NmgooOol08goo00=NmgooOol08Goo00=N
mgooOol04goo00=NmgooOol03Woo00=NmgooOol06Goo00=NmgooOol017oo0d`G0Woo00=NmgooOol0
0Woo00=NmgooOol01goo00=NmgooOol017oo00=NmgooOol00goo0e`D0goo00=NmgooOol017oo00=N
mgooOol01goo00=NmgooOol00goo00=NmgooOol027oo00=NmgooOol03goo00<007ooOol087oo300G
67oo000lOol00`00Oomoo`0@Ool00ekgOomoo`0SOol00ekgOomoo`0QOol00ekgOomoo`0DOol2G_L=
Ool00ekgOomoo`0KOol00ekgOomoo`04Ool01D`GE1MoogooG_L01Goo00=NmgooOol01Woo00=Nmgoo
Ool017oo00=NmgooOol00goo00=Nme`DOol00goo00=NmgooOol017oo00=NmgooOol01goo00=Nmgoo
Ool00goo00=NmgooOol01goo00=NmgooOol047oo00<007ooOol087oo0P0G00D05P0G01L05`0F00<0
5`0301H05goo01Moo`00?7oo00<007ooOol047oo00=NmgooOol08goo00=NmgooOol08Goo00=Nmgoo
Ool05Woo00=NmgooOol02Woo00=NmgooOol077oo00=NmgooOol00goo0e@G00=NmgooOol017oo00=N
mgooOol01Woo00=NmgooOol017oo00=NmgooOol00Woo00=L4UkgOol017oo00=NmgooOol017oo00=N
mgooOol01Woo00=NmgooOol01Goo00=NmgooOol01Goo00=NmgooOol04Goo00<007ooOol087oo300G
67oo000lOol00`00Oomoo`0@Ool00ekgOomoo`0SOol00ekgOomoo`0QOol00ekgOomoo`0GOol2G_L:
Ool00ekgOomoo`0MOol00ekgOomoo`03Ool00e@GOomL5P07Ool00ekgOomoo`06Ool00ekgOomoo`03
Ool01ekgOomoogooG19L4E`B00Eoo`03G_Moogoo00Aoo`03G_Moogoo00Ioo`03G_Moogoo00Eoo`03
G_Moogoo00Eoo`03G_Moogoo015oo`03001oogoo021oo`0<03H0E`0g05L0=P1G03L0E`0f05L0=`1G
67oo000lOol00`00Oomoo`0@Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0IOol00ekg
Oomoo`07Ool00ekgOomoo`0MOol00ekgOomoo`04Ool3G1H6Ool00ekgOomoo`06Ool00ekgOomoo`03
Ool00ekgOomoo`02Ool00e`BG_Moo`04Ool00ekgOomoo`03Ool00ekgOomoo`06Ool00ekgOomoo`06
Ool00ekgOomoo`04Ool00ekgOomoo`0BOol00`00Oomoo`0POol<05LHOol003aoo`03001oogoo011o
o`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo01Yoo`9Nm`Moo`03G_Moogoo01ioo`03G_Mo
ogoo00=oo`03G_ML5U`D00Ioo`03G_Moogoo00Ioo`03G_Moogoo00Aoo`06G_MoogooG0mooekg1Goo
00=NmgooOol00goo00=NmgooOol01Woo00=NmgooOol01Woo00=NmgooOol00goo00=NmgooOol04goo
00<007ooOol087oo00`0=`1G03H0E`0g05L0=P1G03L0E`0f05LHOol003aoo`03001oogoo011oo`03
G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo01aoo`03G_Moogoo00Aoo`03G_Moogoo01moo`03
G_Moogoo009oo`05G_ML55`DG1AL4P05Ool00ekgOomoo`05Ool00ekgOomoo`04Ool00ekgOomL3`02
G0l00ekgOomoo`03Ool00ekgOomoo`03Ool00ekgOomoo`06Ool00ekgOomoo`07Ool00ekgOomoo`02
Ool00ekgOomoo`0COol00`00Oomoo`0POol<09LHOol003aoo`03001oogoo011oo`03G_Moogoo029o
o`03G_Moogoo029oo`03G_Moogoo01eoo`9Nm`Aoo`03G_Moogoo01moo`03G_Moogoo009oo`03G_Mo
oe`D00=L4PAoo`03G_Moogoo00Ioo`03G_Moogoo00=oo`06G_MoogooG0mooekg1Goo00=NmgooOol0
0goo00=NmgooOol01Goo00=NmgooOol027oo00ENmgooOomooekg01Ioo`03001oogoo021oo`0509H0
U`2G09L0UP0309L0102F09L0U`2G67oo000lOol00`00Oomoo`0@Ool00ekgOomoo`0ROol00ekgOomo
o`0ROol00ekgOomoo`0OOol01EkgOomoogooG_L08Woo00ANmgooOomNm`Aoo`03G19ooe`?00Aoo`03
G_Moogoo00Eoo`03G_Moogoo00=oo`03G_ML3Goo009oo`03G_Moogoo009oo`03G_Moogoo00=oo`03
G_Moogoo00Ioo`03G_Moogoo00Qoo`04G_MoogooG_LGOol00`00Oomoo`0POol<09LHOol003aoo`03
001oogoo011oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo021oo`=NmbAoo`03G_Mooekg
00Eoo`03G0mL45`?00=oo`03G_Moogoo00Eoo`03G_Moogoo00=oo`=L3@9oo`03G_Moogoo009oo`03
G_Moogoo00=oo`03G_Moogoo00Eoo`03G_Moogoo00Uoo`04G_MoogooG_LGOol00`00Oomoo`0POol0
303G0?L0eP3g0=L0m`3F0?L0e`3g0=H0maQoo`00?7oo00<007ooOol047oo00=NmgooOol08Woo00=N
mgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooG_L01Woo00ML3e`=G0eL2gooG_Ml
0006Ool00ekgOomoo`03Ool00ekgG0eoo`02Ool00ekgOomoo`02Ool00ekgOomoo`03Ool00ekgOomo
o`05Ool00ekgOomoo`09Ool00ekgOomNm`0HOol00`00Oomoo`0POol<0=LHOol003aoo`80015oo`03
G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`=Nmb=oo`9Nm`Moo`04G0eL2e`:G0/3O005
Ool00ekgOomoo`03Ool00e`;Oomoo`02Ool00ekgOomoo`02Ool00ekgOomoo`03Ool00ekgOomoo`05
Ool00ekgOomoo`0:Ool00ekgOomoo`0FOol2000ROol0303F0?L0e`3g0=H0m`3G0?L0eP3g0=L0maQo
o`00?7oo00<007ooOol047oo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo00ANmgoo
OomNmb9oo`9Nm`Uoo`05G0]L25`8O01L1006Ool015kgOomoogoo0e`;0goo00=NmgooOol00Woo00=N
mgooOol00goo00=NmgooOol017oo00=NmgooOol02Woo0Ukg6Goo00<007ooOol087oo304g67oo000l
Ool00`00Oomoo`0@Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol015kgOomoogoo
0Ukg87oo0Ukg2Woo00AL25`6G0ANm`Ioo`06G_MoogooG0Qooe`;17oo00=NmgooOol00Woo00=Nmgoo
Ool00Woo00=NmgooOol01Goo00=NmgooOol02Woo0Ukg6Goo00<007ooOol087oo0P4g00D1=P4g0CL1
=`4f00<1=`030CH1=goo01Moo`00?7oo00<007ooOol047oo00=NmgooOol08Woo00=NmgooOol08Woo
00=NmgooOol08Woo00=NmgooOol00goo00=NmgooOol07Goo00=NmgooG_L037oo00=NmgooOol017oo
00=NmgooG0P00U`800=NmgooOol00Woo00=NmgooOol00Woo00=NmgooOol00Woo00=NmgooOol017oo
00=NmgooOol02Woo00=NmgooG_L06Goo00<007ooOol087oo304g67oo000lOol00`00Oomoo`0@Ool0
0ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0SOol00ekgOomoo`04Ool2G_LMOol015kgOomo
oekg2goo00=NmgooOol017oo00ANmgooG0IL209oo`05G_MoogooOomNm`04Ool00ekgOomoo`02Ool0
0ekgOomoo`04Ool00ekgOomoo`09Ool015kgOomooekg6Goo00<007ooOol087oo00D1=P4g0CL1=`4f
00<1=`040CH1=`4g0CLHOol003aoo`03001oogoo011oo`03G_Moogoo029oo`03G_Moogoo025oo`03
G_Moogoo02=oo`03G_Moogoo00Ioo`03G_Moogoo01Uoo`03G_Moogoo009oo`03G_Moogoo00Uoo`03
G_Moogoo00Aoo`=L1P9oo`05G_MoogooOomNm`04Ool00ekgOomoo`02Ool00ekgOomoo`04Ool00ekg
Oomoo`09Ool01EkgOomoogooG_L067oo00<007ooOol087oo305g67oo000lOol00`00Oomoo`0@Ool0
0ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0SOol00ekgOomoo`07Ool2G_LIOol00ekgOomo
o`02Ool00ekgOomoo`09Ool00ekgOomoo`03Ool00e`4O01L1P03Ool01EkgOomoogooG_L00goo00=N
mgooOol00Woo00=NmgooOol017oo00=NmgooOol02Goo00=NmgooOol00Woo00=NmgooOol05Woo00<0
07ooOol087oo0P5g00D1MP5g0GL1M`5f00<1M`030GH1Mgoo01Moo`00?7oo00<007ooOol047oo00=N
mgooOol08Woo00=NmgooOol08Goo00=NmgooOol08Woo00=NmgooOol02Woo00=NmgooOol05Woo00=N
mgooOol00goo00=NmgooOol02Goo00=NmgooOol00Woo0g`00goo00ENmgooOomooekg00=oo`03G_Mo
ogoo009oo`03G_Moogoo00Aoo`03G_Moogoo00Qoo`03G_Moogoo00=oo`03G_Moogoo01Ioo`03G_Mo
ogoo021oo``1MaQoo`00?7oo00<007ooOol047oo00=NmgooOol08Woo00=NmgooOol08Goo00=Nmgoo
Ool08Woo00=NmgooOol02goo0Ukg5Woo00=NmgooOol017oo00=NmgooOol027oo00=NmgooOol00goo
00=l07ooOol00Woo00ENmgooOomooekg00=oo`03G_Moogoo009oo`03G_Moogoo00=oo`03G_Moogoo
00Uoo`03G_Moogoo00=oo`03G_Moogoo01Aoo`9Nm`03001oogoo021oo`0<0KH1e`6g0ML1]P7G0KL1
e`6f0ML1]`7G67oo000lOol00`00Oomoo`0@Ool00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomo
o`0ROol00ekgOomoo`0=Ool00ekgOomoo`0COol00ekgOomoo`04Ool00ekgOomoo`08Ool00ekgOomo
o`04Ool01EkgOomoogooG_L00goo00ENmgooOomooekg00Aoo`03G_Moogoo00=oo`03G_Moogoo00Qo
o`03G_Moogoo00Aoo`03G_Moogoo01=oo`04G_Moogoo000ROol<0MLHOol003aoo`03001oogoo011o
o`03G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo029oo`03G_Moogoo00ioo`9Nma9oo`03G_Mo
ogoo00Ioo`03G_Moogoo00Qoo`03G_Moogoo00=oo`05G_MoogooOomNm`03Ool01EkgOomoogooG_L0
0goo00=NmgooOol017oo00=NmgooOol01goo00=NmgooOol01Woo00=NmgooOol047oo0Ukg0goo00<0
07ooOol087oo00`1]`7G0KH1e`6g0ML1]P7G0KL1e`6f0MLHOol003aoo`03001oogoo011oo`03G_Mo
ogoo029oo`03G_Moogoo025oo`03G_Moogoo029oo`03G_Moogoo011oo`03G_Moogoo00moo`03G_Mo
ogoo00Moo`03G_Moogoo00Moo`03G_Moogoo00=oo`05G_MoogooOomNm`03Ool01EkgOomoogooG_L0
0goo00=NmgooOol00goo00=NmgooOol01goo00=NmgooOol01goo00=NmgooOol03goo00=NmgooOol0
0goo00<007ooOol087oo308G67oo000lOol00`00Oomoo`0@Ool00ekgOomoo`0QOol00ekgOomoo`0R
Ool00ekgOomoo`0ROol00ekgOomoo`0AOol00ekgOomoo`0>Ool00ekgOomoo`07Ool00ekgOomoo`07
Ool00ekgOomoo`03Ool01EkgOomoogooG_L00goo00ENmgooOomooekg00=oo`03G_Moogoo00=oo`03
G_Moogoo00Moo`03G_Moogoo00Moo`03G_Moogoo00eoo`9Nm`Ioo`03001oogoo021oo`050QH25`8G
0QL25P030QL0108F0QL25`8G67oo000lOol00`00Oomoo`0@Ool00ekgOomoo`0QOol00ekgOomoo`0R
Ool00ekgOomoo`0ROol00ekgOomoo`0BOol2G_L>Ool00ekgOomoo`08Ool00ekgOomoo`07Ool00ekg
Oomoo`02Ool00ekgOomoo`02Ool015kgOomooekg0goo00ENmgooOomooekg00Aoo`03G_Moogoo00Mo
o`03G_Moogoo00Qoo`03G_Moogoo00aoo`03G_Moogoo00Ioo`03001oogoo021oo``25aQoo`00?7oo
00<007ooOol047oo00=NmgooOol08Goo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol057oo
00=NmgooOol02goo00=NmgooOol02Goo00=NmgooOol01Woo00=NmgooOol00goo00ENmgooOomooekg
009oo`05G_MoogooOomNm`03Ool00ekgOomoo`02Ool00ekgOomoo`06Ool00ekgOomoo`09Ool00ekg
Oomoo`0:Ool2G_L9Ool00`00Oomoo`0POol0309G0WL2EP9g0UL2M`9F0WL2E`9g0UH2MaQoo`00?7oo
00<007ooOol047oo00=NmgooOol08Goo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol05Goo
0Ukg2goo00=NmgooOol02Goo00=NmgooOol01goo00=NmgooOol00Woo00ENmgooOomooekg009oo`04
G_MoogooG_L3Ool00ekgOomoo`03Ool00ekgOomoo`06Ool00ekgOomoo`0:Ool00ekgOomoo`08Ool0
0ekgOomoo`09Ool00`00Oomoo`0POol<0ULHOol003aoo`03001oogoo011oo`03G_Moogoo025oo`03
G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo01Moo`03G_Moogoo00Qoo`03G_Moogoo00Yoo`03
G_Moogoo00Ioo`03G_Moogoo009oo`05G_MoogooOomNm`02Ool015kgOomooekg0goo00=NmgooOol0
0Woo00=NmgooOol01Woo00=NmgooOol02goo00=NmgooOol01Woo0Ukg37oo00<007ooOol087oo00`2
EP9g0UL2M`9F0WL2E`9g0UH2M`9G0WLHOol003aoo`03001oogoo011oo`03G_Moogoo025oo`03G_Mo
ogoo029oo`03G_Moogoo029oo`03G_Moogoo01Qoo`9Nm`Qoo`03G_Moogoo00]oo`03G_Moogoo00Eo
o`03G_Moogoo009oo`05G_MoogooOomNm`02Ool015kgOomooekg0goo00=NmgooOol00Woo00=Nmgoo
Ool01Goo00=NmgooOol037oo00=NmgooOol01Goo00=NmgooOol037oo00<007ooOol087oo309G67oo
000lOol00`00Oomoo`0?Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomo
o`0KOol00ekgOomoo`04Ool00ekgOomoo`0=Ool00ekgOomoo`05Ool00ekgOomoo`02Ool015kgOomo
oekg0Woo00ANmgooOomNm`=oo`05G_MoogooOomNm`08Ool00ekgOomoo`0<Ool00ekgOomoo`03Ool2
G_L?Ool00`00Oomoo`0POol20[L01@:f0[L2]`:g0[H00`:g00<2]P:gOol05goo000lOol00`00Oomo
o`0?Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0LOol2G_L4Ool0
0ekgOomoo`0=Ool00ekgOomoo`05Ool00ekgOomoo`02Ool015kgOomooekg0Woo00ANmgooOomNm`9o
o`03G_Moogoo009oo`03G_Moogoo00Eoo`03G_Moogoo00eoo`03G_Moogoo009oo`03G_Moogoo00mo
o`03001oogoo021oo``2]aQoo`00?7oo00<007ooOol03goo00=NmgooOol08Woo00=NmgooOol08Woo
00=NmgooOol08Goo00=NmgooOol07Woo00ENmgooOomooekg011oo`03G_Moogoo00Eoo`05G_Moogoo
OomNm`02Ool015kgOomooekg0Woo00ANmgooOomNm`Aoo`03G_Moogoo00Aoo`03G_Moogoo00ioo`03
G_Moogoo009Nma9oo`03001oogoo021oo`050[H2]`:g0[L2]P030[L010:f0[L2]`:g67oo000lOol0
0`00Oomoo`0?Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0OOol2
G_L00gooG_Moo`0@Ool00ekgOomoo`04Ool01EkgOomoogooG_L00Woo00ANmgooOomNm`9oo`04G_Mo
ogooG_L3Ool00ekgOomoo`04Ool00ekgOomoo`0@Ool2G_LDOol00`00Oomoo`0POol<0_LHOol003ao
o`03001oogoo00moo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo025o
o`9Nma5oo`03G_Moogoo00Aoo`05G_MoogooOomNm`02Ool015kgOomooekg0Woo00ANmgooOomNm`=o
o`03G_Moogoo00Aoo`03G_Moogoo00moo`9NmaEoo`03001oogoo021oo`82m`050_H2m`;g0_L2mP03
0_L00`;f0_Moo`0GOol003aoo`80011oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo025o
o`03G_Moogoo029oo`9Nma5oo`03G_Moogoo00Aoo`05G_MoogooOomNm`02Ool00ekgOomNm`02Ool0
0ekgOomNm`03Ool00ekgOomoo`04Ool00ekgOomoo`0?Ool00ekgOomNm`0DOol2000ROol<0_LHOol0
03aoo`03001oogoo00moo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo
029oo`03G_Mooekg015oo`03G_Moogoo00=oo`05G_MoogooOomNm`02Ool01EkgOomNmgooG_L00Woo
00ENmgooOomooekg00Eoo`03G_Moogoo00ioo`9Nm`9oo`03G_Moogoo01=oo`03001oogoo021oo`0<
0_@2m@;d0_D2m0;e0_@2m@;d0_D2m0;e67oo000lOol00`00Oomoo`0?Ool00ekgOomoo`0ROol00ekg
Oomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0ROol00ekgOomoo`02G_L?Ool00ekgOomoo`04Ool0
15kgOomooekg0Woo00ENmgooG_Mooekg009oo`05G_MoogooOomNm`05Ool00ekgOomoo`0=Ool00ekg
Oomoo`02Ool00ekgOomoo`0COol00`00Oomoo`0POol030;e0_@2m@;d0_D2m0;e0_@2m@;d0_D2m1Qo
o`00?7oo00<007ooOol03goo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Goo00=Nmgoo
Ool08Woo00=NmgooOol00Woo00=NmgooOol03Goo00=NmgooOol00goo00ANmgooOomNm`9oo`05G_Mo
oekgOomNm`02Ool015kgOomooekg1Goo00=NmgooOol03Goo00=NmgooOol00goo00=NmgooOol04goo
00<007ooOol087oo00`2m0;e0_@2m@;d0_D2m0;e0_@2m@;d0_DHOol003aoo`03001oogoo00moo`03
G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo029oo`03G_Moogoo00=oo`9N
m`ioo`03G_Moogoo009oo`0=G_MoogooOomNmgooG_MooekgOomNmgooG_L00goo00=NmgooOol00Woo
00=NmgooOol037oo0Ukg1Woo00=NmgooOol04goo00<007ooOol087oo30;b67oo000lOol00`00Oomo
o`0?Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0ROol00ekgOomo
o`05Ool00ekgOomoo`0<Ool00ekgOomoo`02Ool035kgOomooekgOomNmgooG_MooekgOomNm`9oo`03
G_Moogoo00=oo`03G_Moogoo00]oo`03G_Moogoo00Ioo`03G_Moogoo01=oo`03001oogoo021oo`03
0_82l`;b0082lP050_<2lP;b0_82l`020_8HOol003aoo`03001oogoo00moo`03G_Moogoo029oo`03
G_Moogoo025oo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo00Moo`9Nm`aoo`03G_Moogoo
009oo`0<G_MoogooG_MooekgOomNmgooG_Mooekg0Woo00=NmgooOol00Woo00=NmgooOol02Woo0Ukg
2Goo00=NmgooOol04goo00<007ooOol087oo30;b67oo000lOol00`00Oomoo`0?Ool00ekgOomoo`0R
Ool00ekgOomoo`0QOol00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`09Ool00ekgOomoo`0:
Ool00ekgOomoo`02Ool03EkgOomNmgooG_MooekgOomNmgooG_Mooekg00Aoo`03G_Moogoo00Yoo`03
G_Moogoo00Uoo`03G_Moogoo01=oo`03001oogoo021oo`<2lP050_<2lP;b0_82l`030_800`;cOomo
o`0FOol003aoo`03001oogoo00moo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo029oo`03
G_Moogoo025oo`03G_Moogoo00Yoo`9Nm`]oo`05G_MoogooOomNm`02Ool2G_L027ooG_MooekgOomN
mgooG_L3Ool00ekgOomoo`09Ool2G_L<Ool00ekgOomoo`0COol00`00Oomoo`0POol<0_0HOol003ao
o`03001oogoo00moo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo029oo`03G_Moogoo025o
o`03G_Moogoo00aoo`03G_Moogoo00Qoo`05G_MoogooOomNm`02Ool01EkgOomNmekgOol00Ukg0Woo
00ENmgooOomooekg00Yoo`03G_Moogoo00aoo`03G_Moogoo01=oo`03001oogoo021oo`0<0^l2l0;_
0_02k`;`0^l2l0;_0_02k`;`67oo000lOol00`00Oomoo`0?Ool00ekgOomoo`0ROol00ekgOomoo`0Q
Ool00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0=Ool2G_L9Ool025kgOomoogooG_Mooekg
Ool3G_L017ooG_Mooekg0goo00=NmgooOol01goo0Ukg3goo00=NmgooOol04goo00<007ooOol087oo
30;`67oo000lOol00`00Oomoo`0?Ool00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0ROol0
0ekgOomoo`0QOol00ekgOomoo`0?Ool00ekgOomoo`07Ool01ekgOomooekgOomNmgoo00=Nm`04OomN
mgooG_L2Ool00ekgOomoo`07Ool00ekgOomoo`0?Ool00ekgOomoo`0COol00`00Oomoo`0POol030;]
0^h2k@;^0^d2kP;]0^h2k@;^0^d2kQQoo`00?7oo00<007ooOol03goo00=NmgooOol08Goo00=Nmgoo
Ool08Woo00=NmgooOol08Goo00=NmgooOol08Woo00=NmgooOol047oo0Ukg1goo00ANmgooOomoo`9N
m`05OomNmekgG_Moo`02G_L3Ool00ekgOomoo`05Ool2G_LBOol00ekgOomoo`0COol00`00Oomoo`0P
Ool20^d01@;^0^d2k@;]0^h00`;]00<2kP;]Ool05goo000lOol00`00Oomoo`0?Ool00ekgOomoo`0Q
Ool00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0ROol00ekgOomoo`0BOol00ekgOomoo`05
Ool01EkgOomooekgOol01Ekg00EooekgOomooekg00Moo`03G_Moogoo019oo`03G_Moogoo01=oo`03
001oogoo021oo`0<0^d2kP;]0^h2k@;^0^d2kP;]0^h2k@;^67oo000lOol00`00Oomoo`0?Ool00ekg
Oomoo`0QOol00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0ROol00ekgOomoo`0COol2G_L6
Ool015kgOomNmgoo1Ekg00AooekgOomNm`Ioo`9NmaEoo`03G_Moogoo01=oo`03001oogoo021oo``2
jaQoo`00?7oo00<007ooOol03goo00=NmgooOol08Goo00=NmgooOol08Woo00=NmgooOol08Goo00=N
mgooOol08Woo00=NmgooOol05Goo00=NmgooOol00goo00=NmgooOol01ekg0Woo00=NmgooOol00goo
00=NmgooOol05Goo00=NmgooOol04goo00<007ooOol087oo0P;[00D2jP;[0^/2j`;Z00<2j`030^X2
jgoo01Moo`00?7oo00<007ooOol03goo00=NmgooOol08Goo00=NmgooOol08Woo00=NmgooOol08Goo
00=NmgooOol08Woo00=NmgooOol05Woo0Ukg17oo00=NmgooG_L01Ukg00=ooekgOol00goo0Ukg67oo
00=NmgooOol04goo00<007ooOol087oo30;[67oo000lOol00`00Oomoo`0?Ool00ekgOomoo`0QOol0
0ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0ROol00ekgOomoo`0HOol00ekgOomoo`02Ool0
0ekgOomNm`04G_L00gooG_Moo`03Ool00ekgOomoo`0IOol00ekgOomoo`0BOol00`00Oomoo`0POol0
30;X0^T2j0;Y0^P2j@;X0^T2j0;Y0^P2jAQoo`00?7oo00<007ooOol03goo00=NmgooOol08Goo00=N
mgooOol08Woo00=NmgooOol08Goo00=NmgooOol08Woo00=NmgooOol06Goo0Ukg0goo1ekg0goo0Ukg
77oo00=NmgooOol04Woo00<007ooOol087oo00`2j@;X0^T2j0;Y0^P2j@;X0^T2j0;Y0^PHOol001Yo
o`8000Qoo`8001Ioo`03001oogoo00moo`03G_Moogoo025oo`03G_Moogoo029oo`03G_Moogoo025o
o`03G_Moogoo029oo`03G_Moogoo01]oo`03G_Moogoo00MNm`9oo`03G_Moogoo01aoo`03G_Moogoo
019oo`03001oogoo021oo`0<0^P2j@;X0^T2j0;Y0^P2j@;X0^T2j0;Y67oo000JOol00`00Oomoo`08
Ool00`00Oomoo`0DOol00`00Oomoo`0?Ool00ekgOomoo`0QOol00ekgOomoo`0ROol00ekgOomoo`0Q
Ool00ekgOomoo`0ROol00ekgOomoo`0LOol2G_L00gooG_MNm`03G_L00gooG_MNm`0OOol00ekgOomo
o`0BOol00`00Oomoo`0POol030;Y0^P2j@;X0^T2j0;Y0^P2j@;X0^T2j1Qoo`0037oo0`0000Ioo`00
Ool007oo0005Ool01000Oomoogoo0P001Goo00<007ooOol03Woo00<007ooOol00goo00<007ooOol0
3goo00=NmgooOol08Goo00=NmgooOol08Woo00=NmgooOol08Goo00=NmgooOol08Woo00=NmgooOol0
7Woo00=NmgooG_L00Ukg00=ooekgOol087oo00=NmgooOol04Woo00<007ooOol087oo00<2iP;W0^H0
0P;V00D2i`;V0^H2iP;W0082iQQoo`003Goo00P007ooOol007oo001oo`001Goo00<007ooOol00goo
00<007ooOol00Woo00<007ooOol03Goo00<007oo000017oo00<007ooOol03goo00<3h7ooOol08Goo
00=NmgooOol08Woo00=NmgooOol03goo00Yl000G0?L1e`:g0_@2k`;[0^H2h@Qoo`030n1oogoo029o
o`03G_Moogoo01moo`ENmb9oo`03G_Moogoo019oo`03001oogoo021oo``2iQQoo`003Goo00P007oo
Ool007oo001oo`001Goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol03Goo00<007oo0000
17oo4Ekg0`?PF5kg0g`000T1e`:g0_@2k`;[0^H2h@;R0^401Ukg0`?PPUkg8Woo0`;V00D2i`;V0^H2
iP;W00<2iP030^Moogoo01Ioo`003Goo00<007ooOol00P0000=oo`00Ool01Goo00<007ooOol00Woo
0P0017oo00<007ooOol03Goo00<007oo000017oo00<007ooOol03goo00<3h7ooOol08Goo00=Nmgoo
Ool08Woo00=NmgooOol03goo00Yl000G0?L1e`:g0_@2k`;[0^H2h@Qoo`030n1oogoo029oo`03G_Mo
ogoo01moo`ENmb9oo`03G_Moogoo019oo`03001oogoo021oo``2i1Qoo`003Goo00<007ooOol02Woo
00<007ooOol027oo00<007ooOol03Goo00<007oo000017oo00<007ooOol03goo00=NmgooOol08Goo
00=NmgooOol08Woo00=NmgooOol08Goo00=NmgooOol08Woo00=NmgooOol07Woo00=NmgooG_L00Ukg
00=ooekgOol087oo00=NmgooOol04Woo00<007ooOol087oo00`2h`;T0^<2i0;S0^@2h`;T0^<2i0;S
0^@HOol000aoo`<000]oo`8000Qoo`80011oo`03001oogoo00=oo`03001oogoo00moo`03G_Moogoo
025oo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo029oo`03G_Moogoo01aoo`9Nm`03OomN
mekg00=Nm`03OomNmekg01moo`03G_Moogoo019oo`03001oogoo021oo``2i0Eoo`<0009oo`03001o
ogoo009oo`03001oogoo00Ioo`00?7oo00<007ooOol03goo00=NmgooOol08Goo00=NmgooOol08Woo
00=NmgooOol08Goo00=NmgooOol08Woo00=NmgooOol06goo00=NmgooOol01ekg0Woo00=NmgooOol0
77oo00=NmgooOol04Woo00<007ooOol087oo00`2h@;R0^42hP;Q0^82h@;R0^42hP;Q0^86Ool01P00
Oomoo`00Ool000aoo`00?7oo00<007ooOol03goo00=NmgooOol08Goo00=NmgooOol08Woo00=Nmgoo
Ool08Goo00=NmgooOol08Woo00=NmgooOol06Goo0Ukg0goo1Ukg00AooekgOomoo`9Nmaaoo`03G_Mo
ogoo019oo`03001oogoo021oo`82h@050^82h@;Q0^42hP030^400`;R0^5oo`03Ool4000017oo001o
o`0037oo000lOol00`00Oomoo`0?Ool00ekgOomoo`0QOol00ekgOomoo`0ROol00ekgOomoo`0QOol0
0ekgOomoo`0ROol00ekgOomoo`0HOol00ekgOomoo`02Ool00ekgOomNm`04G_L00gooG_Moo`03Ool0
0ekgOomoo`0HOol00ekgOomoo`0COol00`00Oomoo`0POol030;Q0^82h@;R0^42hP;Q0^82h@;R0^42
hPAoo`03001oo`00009oo`03001oo`0000aoo`00?7oo00<007ooOol03goo00=NmgooOol08Goo00=N
mgooOol08Woo00=NmgooOol08Goo00=NmgooOol08Woo00=NmgooOol05Woo0Ukg17oo00=NmgooG_L0
1Ukg00=ooekgOol00goo0Ukg67oo00=NmgooOol04goo00<007ooOol0<Goo0P000Woo00<007oo0000
37oo000lOol00`00Oomoo`0?Ool00ekgOomoo`0QOol00ekgOomoo`0ROol00ekgOomoo`0QOol00ekg
Oomoo`0ROol00ekgOomoo`0EOol00ekgOomoo`03Ool00ekgOomoo`07G_L2Ool00ekgOomoo`03Ool0
0ekgOomoo`0EOol00ekgOomoo`0COol00`00Oomoo`0bOol01@00Oomoogoo00003Goo000lOol00`00
Oomoo`0?Ool00ekgOomoo`0QOol00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0ROol00ekg
Oomoo`0COol2G_L6Ool015kgOomNmgoo1Ekg00AooekgOomNm`Ioo`9NmaEoo`03G_Moogoo01=oo`03
001oogoo04Aoo`00?7oo00<007ooOol03goo00=NmgooOol08Goo00=NmgooOol08Woo00=NmgooOol0
8Goo00=NmgooOol08Woo00=NmgooOol04Woo00=NmgooOol01Goo00ENmgooOomNmgoo00ENm`05OomN
mgooOomNm`07Ool2G_LCOol00ekgOomoo`0COol00`00Oomoo`14Ool003aoo`03001oogoo00moo`03
G_Moogoo025oo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo029oo`03G_Moogoo011oo`9N
m`Moo`04G_MoogooOol2G_L01GooG_MNmekgOol00Ukg0goo00=NmgooOol01Woo00=NmgooOol047oo
00=NmgooOol04goo00<007ooOol0A7oo000lOol00`00Oomoo`0?Ool00ekgOomoo`0ROol00ekgOomo
o`0QOol00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0?Ool00ekgOomoo`07Ool01ekgOomo
oekgOomNmgoo00=Nm`04OomNmgooG_L2Ool00ekgOomoo`07Ool2G_L@Ool00ekgOomoo`0COol00`00
Oomoo`14Ool003aoo`03001oogoo00moo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo029o
o`03G_Moogoo025oo`03G_Moogoo00eoo`9Nm`Uoo`08G_MoogooOomNmgooG_Moo`=Nm`04OomNmgoo
G_L3Ool00ekgOomoo`08Ool00ekgOomoo`0=Ool00ekgOomoo`0COol00`00Oomoo`14Ool003aoo`03
001oogoo00moo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo029oo`03G_Moogoo025oo`03
G_Moogoo00aoo`03G_Moogoo00Qoo`05G_MoogooOomNm`02Ool01EkgOomNmekgOol00Ukg0Woo00EN
mgooOomooekg00Yoo`9Nm`eoo`03G_Moogoo01=oo`03001oogoo04Aoo`00?7oo00<007ooOol03goo
00=NmgooOol08Woo00=NmgooOol08Goo00=NmgooOol08Woo00=NmgooOol08Goo00=NmgooOol02Woo
0Ukg2goo00ENmgooOomooekg009oo`9Nm`08OomNmgooG_MooekgOomNm`Aoo`03G_Moogoo00Uoo`03
G_Moogoo00Yoo`03G_Moogoo01=oo`03001oogoo04Aoo`00?7oo00<007ooOol03goo00=NmgooOol0
8Woo00=NmgooOol08Goo00=NmgooOol08Woo00=NmgooOol08Goo00=NmgooOol02Goo00=NmgooOol0
2Woo00=NmgooOol00Woo00eNmgooG_MooekgOomNmgooG_MooekgOomNm`04Ool00ekgOomoo`0:Ool2
G_L:Ool00ekgOomoo`0COol00`00Oomoo`14Ool003aoo`03001oogoo00moo`03G_Moogoo029oo`03
G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo029oo`03G_Moogoo00Ioo`9Nm`aoo`03G_Moogoo
009oo`0<G_MoogooG_MooekgOomNmgooG_Mooekg0Woo00=NmgooOol00Woo00=NmgooOol02goo00=N
mgooOol01goo00=NmgooOol04goo00<007ooOol0A7oo000lOol00`00Oomoo`0?Ool00ekgOomoo`0R
Ool00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0ROol00ekgOomoo`05Ool00ekgOomoo`0<
Ool00ekgOomoo`02Ool035kgOomooekgOomNmgooG_MooekgOomNm`9oo`03G_Moogoo00=oo`03G_Mo
ogoo00]oo`9Nm`Moo`03G_Moogoo01=oo`03001oogoo04Aoo`00?7oo00<007ooOol03goo00=Nmgoo
Ool08Woo00=NmgooOol08Woo00=NmgooOol08Goo00=NmgooOol08Woo00=NmgooOol00goo0Ukg3Woo
00=NmgooOol00Woo00eNmgooOomooekgOomNmgooG_MooekgOomNm`03Ool00ekgOomoo`02Ool00ekg
Oomoo`0=Ool00ekgOomoo`04Ool00ekgOomoo`0COol00`00Oomoo`14Ool003aoo`03001oogoo00mo
o`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo029oo`03G_Moogoo009o
o`03G_Moogoo00eoo`03G_Moogoo00=oo`04G_MoogooG_L2Ool01EkgOomNmgooG_L00Woo00ANmgoo
OomNm`Eoo`03G_Moogoo00eoo`9Nm`Aoo`03G_Moogoo01=oo`03001oogoo04Aoo`00?7oo00<007oo
Ool03goo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Goo00=NmgooOol08Woo00=Nmgoo
Ool00Ukg3goo00=NmgooOol017oo00ANmgooOomNm`9oo`05G_MooekgOomNm`02Ool01EkgOomoogoo
G_L01Goo00=NmgooOol03Woo00ENmgooOomooekg01Eoo`03001oogoo04Aoo`00?7oo00<007ooOol0
3goo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Goo00=NmgooOol08Woo00=NmgooG_L0
4Goo00=NmgooOol00goo00ENmgooOomooekg009oo`05G_MooekgOomNm`02Ool01EkgOomoogooG_L0
1Woo00=NmgooOol03Woo0Ukg00=ooekgOol057oo00<007ooOol0A7oo000lOol2000@Ool00ekgOomo
o`0ROol00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0ROol2G_LAOol00ekgOomoo`04Ool0
1EkgOomoogooG_L00Woo00=NmgooG_L00Woo00=NmgooG_L00goo00=NmgooOol017oo00=NmgooOol0
47oo0Ukg57oo0P00AWoo000lOol00`00Oomoo`0?Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekg
Oomoo`0QOol00ekgOomoo`0QOol2G_LAOol00ekgOomoo`04Ool01EkgOomoogooG_L00Woo00ANmgoo
OomNm`9oo`04G_MoogooG_L3Ool00ekgOomoo`04Ool00ekgOomoo`0@Ool2G_LDOol00`00Oomoo`14
Ool003aoo`03001oogoo00moo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Mo
ogoo01moo`9Nm`03OomNmgoo011oo`03G_Moogoo00Aoo`05G_MoogooOomNm`02Ool015kgOomooekg
0Woo00ANmgooOomNm`=oo`03G_Moogoo00Eoo`03G_Moogoo00ioo`04G_MoogooG_LCOol00`00Oomo
o`14Ool003aoo`03001oogoo00moo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo025oo`03
G_Moogoo01ioo`05G_MoogooOomNm`0@Ool00ekgOomoo`05Ool01EkgOomoogooG_L00Woo00ANmgoo
OomNm`9oo`04G_MoogooG_L4Ool00ekgOomoo`04Ool00ekgOomoo`0>Ool015kgOomoogoo0Ukg4Goo
00<007ooOol0A7oo000lOol00`00Oomoo`0?Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomo
o`0QOol00ekgOomoo`0LOol2G_L4Ool00ekgOomoo`0=Ool00ekgOomoo`05Ool00ekgOomoo`02Ool0
15kgOomooekg0Woo00ANmgooOomNm`9oo`03G_Moogoo009oo`03G_Moogoo00Eoo`03G_Moogoo00eo
o`03G_Moogoo00=oo`03G_Moogoo00ioo`03001oogoo04Aoo`00?7oo00<007ooOol03goo00=Nmgoo
Ool08Woo00=NmgooOol08Woo00=NmgooOol08Goo00=NmgooOol06goo00=NmgooOol01Goo00=Nmgoo
Ool037oo00=NmgooOol01Goo00=NmgooOol00Woo00ANmgooOomNm`9oo`04G_MoogooG_L3Ool01Ekg
OomoogooG_L027oo00=NmgooOol037oo00=NmgooOol017oo0Ukg3Woo00<007ooOol0A7oo000lOol0
0`00Oomoo`0@Ool00ekgOomoo`0QOol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0HOol2
G_L8Ool00ekgOomoo`0;Ool00ekgOomoo`05Ool00ekgOomoo`02Ool01EkgOomoogooG_L00Woo00AN
mgooOomNm`=oo`03G_Moogoo009oo`03G_Moogoo00Ioo`03G_Moogoo00]oo`03G_Moogoo00Ioo`9N
m`aoo`03001oogoo04Aoo`00?7oo00<007ooOol047oo00=NmgooOol08Goo00=NmgooOol08Woo00=N
mgooOol08Woo00=NmgooOol05goo00=NmgooOol027oo00=NmgooOol02Woo00=NmgooOol01Woo00=N
mgooOol00Woo00ENmgooOomooekg009oo`04G_MoogooG_L3Ool00ekgOomoo`02Ool00ekgOomoo`06
Ool00ekgOomoo`0;Ool00ekgOomoo`08Ool00ekgOomoo`09Ool00`00Oomoo`14Ool003aoo`03001o
ogoo011oo`03G_Moogoo025oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo01Eoo`9Nm`]o
o`03G_Moogoo00Uoo`03G_Moogoo00Moo`03G_Moogoo009oo`05G_MoogooOomNm`02Ool015kgOomo
oekg0goo00=NmgooOol00goo00=NmgooOol01Woo00=NmgooOol02Goo00=NmgooOol02Woo0Ukg2Goo
00<007ooOol0A7oo000lOol00`00Oomoo`0@Ool00ekgOomoo`0QOol00ekgOomoo`0ROol00ekgOomo
o`0ROol00ekgOomoo`0DOol00ekgOomoo`0;Ool00ekgOomoo`09Ool00ekgOomoo`06Ool00ekgOomo
o`03Ool01EkgOomoogooG_L00Woo00ENmgooOomooekg00=oo`03G_Moogoo009oo`03G_Moogoo00Mo
o`03G_Moogoo00Qoo`03G_Moogoo00aoo`03G_Moogoo00Ioo`03001oogoo04Aoo`00?7oo00<007oo
Ool047oo00=NmgooOol08Goo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol04goo00=Nmgoo
Ool037oo00=NmgooOol027oo00=NmgooOol01goo00=NmgooOol00Woo00=NmgooOol00Woo00ANmgoo
OomNm`=oo`05G_MoogooOomNm`04Ool00ekgOomoo`07Ool00ekgOomoo`08Ool00ekgOomoo`0=Ool2
G_L6Ool00`00Oomoo`14Ool003aoo`03001oogoo011oo`03G_Moogoo029oo`03G_Moogoo025oo`03
G_Moogoo029oo`03G_Moogoo015oo`9Nm`moo`03G_Moogoo00Moo`03G_Moogoo00Moo`03G_Moogoo
00=oo`05G_MoogooOomNm`03Ool01EkgOomoogooG_L00goo00=NmgooOol00goo00=NmgooOol01goo
00=NmgooOol01goo00=NmgooOol03goo00=NmgooOol00goo00<007ooOol0A7oo000lOol00`00Oomo
o`0@Ool00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0ROol00ekgOomoo`0@Ool00ekgOomo
o`0?Ool00ekgOomoo`07Ool00ekgOomoo`07Ool00ekgOomoo`03Ool01EkgOomoogooG_L00goo00EN
mgooOomooekg00=oo`03G_Moogoo00=oo`03G_Moogoo00Qoo`03G_Moogoo00Ioo`03G_Moogoo011o
o`9Nm`=oo`03001oogoo04Aoo`00?7oo00<007ooOol047oo00=NmgooOol08Woo00=NmgooOol08Goo
00=NmgooOol08Woo00=NmgooOol03Woo0Ukg4goo00=NmgooOol01Goo00=NmgooOol027oo00=Nmgoo
Ool00goo00ENmgooOomooekg00=oo`05G_MoogooOomNm`03Ool00ekgOomoo`04Ool00ekgOomoo`07
Ool00ekgOomoo`05Ool00ekgOomoo`0COol015kgOomoo`00AWoo000lOol00`00Oomoo`0@Ool00ekg
Oomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0ROol00ekgOomoo`0=Ool00ekgOomoo`0COol00ekg
Oomoo`04Ool00ekgOomoo`08Ool00ekgOomoo`04Ool01EkgOomoogooG_L00goo00ENmgooOomooekg
00Aoo`03G_Moogoo00=oo`03G_Moogoo00Qoo`03G_Moogoo00Aoo`03G_Moogoo01Aoo`9Nm`03001o
ogoo04Aoo`00?7oo00<007ooOol047oo00=NmgooOol08Woo00=NmgooOol08Goo00=NmgooOol08Woo
00=NmgooOol02goo0Ukg5Woo00=NmgooOol017oo00=NmgooOol027oo00=NmgooOol00goo00=l07oo
Ool00Woo00ENmgooOomooekg00=oo`03G_Moogoo009oo`03G_Moogoo00=oo`03G_Moogoo00Uoo`03
G_Moogoo00=oo`03G_Moogoo01Ioo`03G_Moogoo04Aoo`00?7oo00<007ooOol047oo00=NmgooOol0
8Woo00=NmgooOol08Goo00=NmgooOol08Woo00=NmgooOol02Woo00=NmgooOol05Woo00=NmgooOol0
0goo00=NmgooOol02Goo00=NmgooOol00Woo0g`00goo00ENmgooOomooekg00=oo`03G_Moogoo009o
o`03G_Moogoo00Aoo`03G_Moogoo00Uoo`03G_Moogoo009oo`03G_Moogoo01Ioo`03001oogoo04Ao
o`00?7oo00<007ooOol047oo00=NmgooOol08Woo00=NmgooOol08Goo00=NmgooOol08goo00=Nmgoo
Ool01goo0Ukg6Goo00=NmgooOol00Woo00=NmgooOol02Goo00=NmgooOol00goo00=L17`0G0H00goo
00ENmgooOomooekg00=oo`03G_Moogoo009oo`03G_Moogoo00Aoo`03G_Moogoo00Uoo`03G_Moogoo
009oo`03G_Moogoo01Ioo`03001oogoo04Aoo`00?7oo00<007ooOol047oo00=NmgooOol08Woo00=N
mgooOol08Goo00=NmgooOol08goo00=NmgooOol01Woo00=NmgooOol06Goo00=NmgooOol00Woo00=N
mgooOol02Goo00=NmgooOol017oo0e`60Woo00ENmgooOomooekg00Aoo`03G_Moogoo009oo`03G_Mo
ogoo00Aoo`03G_Moogoo00Uoo`05G_MoogooOomNm`0HOol00`00Oomoo`14Ool003aoo`03001oogoo
011oo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo02=oo`03G_Moogoo00Aoo`9Nmaeoo`04
G_MoogooG_L;Ool00ekgOomoo`04Ool015kgOomL1U`80Woo00ENmgooOomooekg00Aoo`03G_Moogoo
009oo`03G_Moogoo00Aoo`03G_Moogoo00Yoo`03G_Mooekg01Uoo`03001oogoo04Aoo`00?7oo00<0
07ooOol047oo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol00goo00=N
mgooOol07Goo00=NmgooG_L037oo00=NmgooOol017oo00=NmgooG0P00U`800=NmgooOol00Woo00=N
mgooOol00Woo00=NmgooOol00Woo00=NmgooOol017oo00=NmgooOol02Woo00=NmgooG_L06Goo00<0
07ooOol0A7oo000lOol00`00Oomoo`0@Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0R
Ool015kgOomoogoo0Ukg87oo0Ukg2Woo00AL25`6O01Nm`Ioo`06G_MoogooG0Qooe`;17oo00=Nmgoo
Ool00Woo00=NmgooOol00Woo00=NmgooOol01Goo00=NmgooOol02Woo0Ukg6Goo00<007ooOol0A7oo
000lOol2000AOol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol015kgOomooekg8Woo
0Ukg1goo00AL3GooG0]L20=l00Ioo`04G_MoogooOol3G0/3Ool00ekgOomoo`02Ool00ekgOomoo`03
Ool00ekgOomoo`04Ool00ekgOomoo`0;Ool00ekgOomoo`0FOol20016Ool003aoo`03001oogoo011o
o`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`=Nmb=oo`9Nm`Ioo`07G0eH3E`=G0YL
2e`6O0001Woo00=NmgooOol00goo00=L2e`=Ool00Woo00=NmgooOol00Woo00=NmgooOol00goo00=N
mgooOol01Goo00=NmgooOol02Woo0Ukg67oo00<007ooOol0A7oo000lOol00`00Oomoo`0@Ool00ekg
Oomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomNm`06Ool01U`?
G0eooe`;OomNm`Moo`03G_Moogoo00=oo`=L3@9oo`03G_Moogoo009oo`03G_Moogoo00=oo`03G_Mo
ogoo00Eoo`03G_Moogoo00Uoo`03G_Mooekg01Qoo`03001oogoo04Aoo`00?7oo00<007ooOol047oo
00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol087oo0ekg97oo00=NmgooG_L017oo00AL4U`?
G11L3`=oo`03G_Moogoo00Eoo`03G_Moogoo00=oo`03G_ML3Goo009oo`03G_Moogoo009oo`03G_Mo
ogoo00=oo`03G_Moogoo00Eoo`03G_Moogoo00Uoo`04G_MoogooG_LGOol00`00Oomoo`14Ool003ao
o`03001oogoo011oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo01moo`05G_MoogooOomN
m`0ROol01EkgOomoogooG_L00Woo0e`B00=L3gooOol00Woo00=NmgooOol01Goo00=NmgooOol00goo
00INmgooOomL3gooG_L4Ool00ekgOomoo`03Ool00ekgOomoo`06Ool00ekgOomoo`08Ool01EkgOomo
ogooG_L05Woo00<007ooOol0A7oo000lOol00`00Oomoo`0@Ool00ekgOomoo`0ROol00ekgOomoo`0R
Ool00ekgOomoo`0MOol2G_L4Ool00ekgOomoo`0OOol00ekgOomoo`02Ool01EkgOomL57ooG1801Goo
00=NmgooOol01Woo00=NmgooOol00goo00INmgooG0mL45`?G_L5Ool00ekgOomoo`03Ool00ekgOomo
o`05Ool00ekgOomoo`08Ool01EkgOomoogooG_L05Woo00<007ooOol0A7oo000lOol00`00Oomoo`0@
Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0LOol00ekgOomoo`04Ool00ekgOomoo`0O
Ool00ekgOomoo`02Ool015kgG1AL55`D1Woo00=NmgooOol01Goo00=NmgooOol017oo00INmgooOomL
3gooG_L5Ool00ekgOomoo`03Ool00ekgOomoo`06Ool00ekgOomoo`06Ool00ekgOomoo`03Ool00ekg
Oomoo`0COol00`00Oomoo`14Ool003aoo`03001oogoo011oo`03G_Moogoo029oo`03G_Moogoo029o
o`03G_Moogoo01Yoo`9Nm`Moo`03G_Moogoo01ioo`03G_Moogoo00Aoo`03G1IL57oo00Eoo`03G_Mo
ogoo00Ioo`03G_Moogoo00Aoo`06G_MoogooOomL4Ukg1Goo00=NmgooOol00goo00=NmgooOol01Woo
00=NmgooOol01Woo00=NmgooOol017oo00=NmgooOol04Woo00<007ooOol0A7oo000lOol00`00Oomo
o`0@Ool00ekgOomoo`0SOol00ekgOomoo`0QOol00ekgOomoo`0IOol00ekgOomoo`07Ool00ekgOomo
o`0MOol00ekgOomoo`04Ool00e`FG1ML5P06Ool00ekgOomoo`06Ool00ekgOomoo`03Ool015kgOomo
ogoo0e`B1Goo00=NmgooOol00goo00=NmgooOol01Woo00=NmgooOol01Woo00=NmgooOol017oo00=N
mgooOol04Woo00<007ooOol0A7oo000lOol00`00Oomoo`0@Ool00ekgOomoo`0SOol00ekgOomoo`0Q
Ool00ekgOomoo`0GOol2G_L:Ool00ekgOomoo`0MOol00ekgOomoo`03Ool00e@GOomL5P07Ool00ekg
Oomoo`06Ool00ekgOomoo`03Ool00ekgOomoo`02Ool00e`BG_Moo`04Ool00ekgOomoo`04Ool00ekg
Oomoo`06Ool00ekgOomoo`05Ool00ekgOomoo`05Ool00ekgOomoo`0AOol00`00Oomoo`14Ool003ao
o`03001oogoo011oo`03G_Moogoo02=oo`03G_Moogoo025oo`03G_Moogoo01Ioo`03G_Moogoo00Yo
o`03G_Moogoo01aoo`03G_Moogoo00=oo`=D5`03OomNmgoo00Aoo`03G_Moogoo00Ioo`03G_Moogoo
00Aoo`03G_Moogoo00=oo`03G_ML57oo00=oo`03G_Moogoo00Aoo`03G_Moogoo00Ioo`03G_Moogoo
00Aoo`03G_Moogoo00Moo`03G_Moogoo011oo`03001oogoo04Aoo`00?7oo00<007ooOol047oo00=N
mgooOol08goo00=NmgooOol08Goo00=NmgooOol057oo0Ukg3Woo00=NmgooOol06Woo00=NmgooOol0
17oo00E<5e@GOomooekg00Eoo`03G_Moogoo00Ioo`03G_Moogoo00Aoo`03G_Moogoo00=oo`=L50=o
o`03G_Moogoo00Aoo`03G_Moogoo00Moo`03G_Moogoo00=oo`03G_Moogoo00Qoo`03G_Moogoo00mo
o`03001oogoo04Aoo`00?7oo00<007ooOol047oo00=NmgooOol08goo00=NmgooOol08Goo00=Nmgoo
Ool04goo00=NmgooOol03Woo00=NmgooOol06Goo00=NmgooOol00goo00A45d`GC1M<5`9oo`03G_Mo
ogoo009oo`03G_Moogoo00Moo`03G_Moogoo00Aoo`03G_Moogoo00=oo`03G_ML57oo00=oo`03G_Mo
ogoo00Aoo`03G_Moogoo00Moo`03G_Moogoo00=oo`03G_Moogoo00Qoo`03G_Moogoo00moo`03001o
ogoo04Aoo`00?7oo00<007ooOol047oo00=NmgooOol08goo00=NmgooOol08Goo00=NmgooOol04Goo
0Ukg4Goo00=NmgooOol06Goo00=NmgooOol00Woo0d@G00=<5gooOol00Woo00ENmgooOomooekg00Uo
o`03G_Moogoo00Aoo`03G_Moogoo00=oo`03G_Moogoo00=oo`03G_Moogoo00Eoo`03G_Moogoo00Mo
o`05G_MoogooOomNm`0<Ool00ekgOomoo`0>Ool00`00Oomoo`14Ool003aoo`03001oogoo011oo`03
G_Moogoo02=oo`03G_Moogoo025oo`03G_Moogoo011oo`03G_Moogoo015oo`03G_Moogoo01Qoo`03
G_Moogoo00=oo`03>1M45goo00Eoo`05G_MoogooOomNm`08Ool00ekgOomoo`05Ool00ekgOomoo`03
Ool00ekgOomL5P03Ool00ekgOomoo`05Ool00ekgOomoo`07Ool01EkgOomoogooG_L03Goo00=Nmgoo
Ool03Goo00<007ooOol0A7oo000lOol00`00Oomoo`0@Ool00ekgOomoo`0SOol00ekgOomoo`0ROol0
0ekgOomoo`0=Ool2G_LDOol00ekgOomoo`0GOol00ekgOomoo`03Ool3>1L6Ool015kgOomooekg2Goo
00=NmgooOol01Goo00=NmgooOol00goo00ANme`FG1ML5P=oo`03G_Moogoo00Aoo`03G_Moogoo00Mo
o`05G_MoogooOomNm`0=Ool00ekgOomoo`0=Ool00`00Oomoo`14Ool003aoo`03001oogoo011oo`03
G_Moogoo02=oo`03G_Moogoo029oo`03G_Moogoo00aoo`03G_Moogoo01Aoo`03G_Moogoo01Moo`03
G_Moogoo009oo`03<1MoocPG00Qoo`03G_Mooekg00Uoo`03G_Moogoo00Eoo`03G_Moogoo00=oo`03
G_Mooe`F00Aoo`03G_Moogoo00Aoo`03G_Moogoo00Qoo`03G_Mooekg00moo`03G_Moogoo00aoo`03
001oogoo04Aoo`00?7oo00<007ooOol047oo00=NmgooOol08goo00=NmgooOol08Woo00=NmgooOol0
2Woo0Ukg5goo00=NmgooOol05Woo00=NmgooOol00Woo0c0G2Goo0Ukg2Woo00=NmgooOol017oo00=N
mgooOol017oo00ENmgooOomooe@G009oo`03G_Moogoo00Eoo`03G_Moogoo00Moo`03G_Mooekg011o
o`03G_Moogoo00]oo`03001oogoo04Aoo`00?7oo00<007ooOol04Goo00=NmgooOol08Woo00=Nmgoo
Ool08Woo00=NmgooOol02Goo00=NmgooOol05goo00=NmgooOol05Goo00=NmgooOol00goo00<X5c0G
Ool02Goo0Ukg2Woo00=NmgooOol017oo00=NmgooOol017oo00=NmgooOol00e@G00=ooekgOol01Woo
00=NmgooOol027oo0Ukg4Goo00=NmgooOol02Woo00<007ooOol0A7oo000lOol00`00Oomoo`0AOol0
0ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`07Ool2G_LKOol00ekgOomoo`0DOol00ekgOomo
o`02Ool3:1L;Ool00ekgOomoo`07Ool00ekgOomoo`05Ool00ekgOomoo`04Ool01EkgOomoogooE1L0
0Woo00=NmgooOol01Goo00=NmgooOol027oo00=NmgooOol047oo00=NmgooOol02Woo00<007ooOol0
A7oo000lOol00`00Oomoo`0AOol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`06Ool00ekg
Oomoo`0KOol00ekgOomoo`0COol00ekgOomoo`02Ool00a`GOolX5`0;Ool2G_L9Ool00ekgOomoo`05
Ool00ekgOomoo`04Ool00ekgOomoo`02Ool00d`GOomNm`07Ool00ekgOomoo`08Ool00ekgOomoo`0A
Ool00ekgOomoo`09Ool00`00Oomoo`14Ool003aoo`03001oogoo015oo`03G_Moogoo029oo`03G_Mo
ogoo029oo`03G_Moogoo00Aoo`9Nmaioo`03G_Moogoo019oo`03G_Moogoo009oo`<L5`aoo`03G_Mo
oekg00Qoo`03G_Moogoo00Eoo`03G_Moogoo00Aoo`08G_MoogooOom<5dPFC1MNm`Moo`03G_Moogoo
00Moo`03G_Mooekg01=oo`03G_Moogoo00Qoo`03001oogoo04Aoo`00?7oo00<007ooOol04Goo00=N
mgooOol08Woo00=NmgooOol08Woo00=NmgooOol00goo00=NmgooOol07Woo00=NmgooOol04Woo00=N
mgooOol00Woo00<D5a`GOol02goo00ANmgooOomNm`Qoo`03G_Moogoo00Eoo`03G_Moogoo00Aoo`03
G_Moogoo009oo`03C1Mooekg00Qoo`03G_Moogoo00Ioo`03G_Mooekg01=oo`03G_Moogoo00Qoo`03
001oogoo04Aoo`00?7oo0P004Woo00=NmgooOol08goo00=NmgooOol08Goo00ANmgooOomoo`9Nmb5o
o`03G_Moogoo015oo`03G_Moogoo009oo`0331L@5Q@G00aoo`04G_MoogooG_L7Ool00ekgOomoo`06
Ool00ekgOomoo`04Ool00ekgOomoo`04Ool00ekgOomoo`06Ool00ekgOomoo`06Ool015kgOomooekg
4goo00=NmgooOol01Woo0P00AWoo000lOol00`00Oomoo`0AOol00ekgOomoo`0SOol00ekgOomoo`0Q
Ool015kgOomooekg8goo00=NmgooOol047oo00=NmgooOol00Woo00<<5`PG31L03Goo00ENmgooOomo
oekg00Ioo`03G_Moogoo00Ioo`03G_Moogoo00Aoo`03G_Moogoo00Aoo`03A1MNmgoo00Ioo`03G_Mo
ogoo00Eoo`05G_MoogooOomNm`0DOol00ekgOomoo`06Ool00`00Oomoo`14Ool003aoo`03001oogoo
015oo`03G_Moogoo02=oo`03G_Moogoo025oo`=NmbAoo`03G_Moogoo00moo`03G_Moogoo009oo`03
01Moo``G00eoo`03G_Moogoo009oo`03G_Moogoo00Aoo`03G_Moogoo00Ioo`03G_Moogoo00Aoo`03
G_Moogoo00=oo`03A1M05d@G00Moo`03G_Moogoo00Eoo`05G_MoogooOomNm`0EOol00ekgOomoo`05
Ool00`00Oomoo`14Ool003aoo`03001oogoo015oo`03G_Moogoo02=oo`03G_Moogoo025oo`03G_Mo
ogoo02Eoo`03G_Moogoo00ioo`07G_MoogooOol05`@G01L03Woo00=NmgooOol00goo00=NmgooOol0
0goo00=NmgooOol01Woo00=NmgooOol017oo00=NmgooOol017oo00=45ekgOol01goo00=NmgooOol0
0goo00=NmgooOol00goo00=NmgooOol04Woo00=NmgooOol01Goo00<007ooOol0A7oo000lOol00`00
Oomoo`0AOol00ekgOomoo`0SOol00ekgOomoo`0OOol2G_L00gooG_Moo`0UOol00ekgOomoo`0=Ool0
0ekgOomoo`02Ool201L>Ool00ekgOomoo`04Ool00ekgOomoo`02Ool00ekgOomoo`06Ool00ekgOomo
o`05Ool00ekgOomoo`05Ool00cPGOomoo`06Ool00ekgOomoo`03Ool00ekgOomoo`03Ool00ekgOomo
o`0COol00ekgOomoo`04Ool00`00Oomoo`14Ool003aoo`03001oogoo015oo`03G_Moogoo02=oo`03
G_Moogoo01ioo`05G_MoogooOomNm`0VOol00ekgOomoo`0<Ool01EkgOomoogoo07L00`0G3Woo00=N
mgooOol01Goo00ENmgooOomooekg00Qoo`03G_Moogoo00Eoo`03G_Moogoo00Aoo`<h5`Moo`03G_Mo
ogoo009oo`03G_Moogoo00Eoo`03G_Moogoo01=oo`03G_Moogoo00=oo`03001oogoo04Aoo`00?7oo
00<007ooOol04Woo00=NmgooOol08Woo00=NmgooOol077oo0Ukg17oo00=NmgooOol097oo00=Nmgoo
Ool037oo00MNmgooOol0M`1F07L05`0?Ool00ekgOomoo`05Ool01EkgOomoogooG_L027oo00=Nmgoo
Ool01Goo00=NmgooOol01Goo00<h5gooOol01Woo00=NmgooOol00Woo00=NmgooOol01Goo00=Nmgoo
Ool04goo00=NmgooOol00goo00<007ooOol0A7oo000lOol00`00Oomoo`0BOol00ekgOomoo`0ROol0
0ekgOomoo`0KOol00ekgOomoo`04Ool00ekgOomoo`0TOol00ekgOomoo`0;Ool01UkgOomoogoo0;L0
Ma1oo`03G_Moogoo00Moo`04G_MoogooG_L8Ool00ekgOomoo`05Ool00ekgOomoo`05Ool00ekgOomo
o`07Ool015kgOomooekg27oo00=NmgooOol057oo00=NmgooOol00Woo00<007ooOol0A7oo000lOol0
0`00Oomoo`0BOol00ekgOomoo`0ROol00ekgOomoo`0IOol2G_L7Ool00ekgOomoo`0TOol00ekgOomo
o`0:Ool015kgOomoogoo0`2g47oo00=NmgooOol01goo00ANmgooOomNm`Qoo`03G_Moogoo00Eoo`03
G_Moogoo00Eoo`03G_Mooc0G00Moo`04G_MoogooG_L9Ool00ekgOomoo`0DOol01EkgOomoogoo0000
AWoo000lOol00`00Oomoo`0BOol00ekgOomoo`0ROol00ekgOomoo`0HOol00ekgOomoo`07Ool00ekg
Oomoo`0UOol00ekgOomoo`09Ool01UkgOomoogoo0?L0]a1oo`03G_Moogoo00Uoo`9Nm`Uoo`03G_Mo
ogoo00Eoo`03G_Moogoo00Eoo`04G_L`5c0G<1L6Ool00ekgOomNm`0:Ool00ekgOomoo`0DOol01Ekg
Oomoogoo0000AWoo000lOol00`00Oomoo`0BOol00ekgOomoo`0ROol00ekgOomoo`0FOol2G_L;Ool0
0ekgOomoo`0TOol00ekgOomoo`08Ool015kgOomoo`5G0`3g47oo00=NmgooOol02Woo00=NmgooOol0
1goo00=NmgooOol01Goo00=NmgooOol01Woo00=Nmc0GOol01Woo0Ukg37oo00=NmgooOol057oo00AN
mgooOol004Ioo`00?7oo00<007ooOol04Woo00=NmgooOol08Woo00=NmgooOol05Goo00=NmgooOol0
2goo00=NmgooOol097oo00=NmgooOol01goo00=NmgooOol00`5G00<0mgooOol03goo00=NmgooOol0
2Woo0Ukg27oo00=NmgooOol01Goo00=NmgooOol01Woo00=Nmgoo:1L01Woo0Ukg37oo00=NmgooOol0
5Goo00=Nmgoo0000AWoo000lOol00`00Oomoo`0BOol00ekgOomoo`0ROol00ekgOomoo`0COol2G_L>
Ool00ekgOomoo`0TOol00ekgOomoo`06Ool01UkgOomoogoo0IL1Ea9oo`03G_Moogoo00]oo`9Nm`Qo
o`03G_Moogoo00Eoo`03G_Moogoo00Ioo`04G_LX5b@F:1L5Ool2G_L<Ool00ekgOomoo`0FOol00ekg
001oo`15Ool003aoo`03001oogoo019oo`03G_Moogoo029oo`03G_Moogoo019oo`03G_Moogoo00io
o`03G_Moogoo02Aoo`03G_Moogoo00Ioo`04G_Moogoo0ML20ILBOol00ekgOomoo`0:Ool015kgOomo
oekg1Woo00=NmgooOol01Woo00=NmgooOol01Woo00=Nmgoo:1L01Goo00=NmgooG_L03Goo00=Nmgoo
Ool05Goo00=Nm`00Ool0AGoo000lOol00`00Oomoo`0BOol00ekgOomoo`0ROol00ekgOomoo`0@Ool2
G_LAOol00ekgOomoo`0TOol00ekgOomoo`05Ool00ekgOomoo`030MLBOol00ekgOomoo`0;Ool01Ekg
OomoogooG_L01Goo00=NmgooOol01Woo00=NmgooOol01Woo00=NmgooOol017oo00ANmgooOomNm`eo
o`03G_Moogoo01Ioo`03G_Moogoo04Aoo`00?7oo00<007ooOol04Woo00=NmgooOol08goo00=Nmgoo
Ool03Woo00=NmgooOol04Goo00=NmgooOol097oo00=NmgooOol017oo00INmgooOol2=goo0MLCOol0
0ekgOomoo`0;Ool00ekgOomoo`02Ool00ekgOomoo`02Ool00ekgOomoo`06Ool00ekgOomoo`06Ool0
15kgOomooa`G0Woo00ENmgooOomooekg00ioo`03G_Moogoo01Eoo`03001oogoo04Aoo`00?7oo00<0
07ooOol04Woo00=NmgooOol08goo00=NmgooOol037oo0Ukg5Goo00=NmgooOol097oo00=NmgooOol0
0goo00=Nmgoo0WL00P8g57oo00=NmgooOol02goo00=NmgooOol00goo00ENmgooOomooekg00Qoo`03
G_Moogoo00Ioo`06G_Mooa`G81LL5ekg1Goo00=NmgooOol02goo00=NmgooOol05Goo00<007ooOol0
A7oo000lOol00`00Oomoo`0COol00ekgOomoo`0ROol00ekgOomoo`0;Ool00ekgOomoo`0EOol00ekg
Oomoo`0TOol00ekgOomoo`02Ool00ekgOol2M`020WLDOol00ekgOomoo`0;Ool00ekgOomoo`05Ool0
15kgOomooekg27oo00=NmgooOol01Woo00ENmgooOolL5ekg00Ioo`03G_Moogoo00]oo`03G_Moogoo
01Eoo`03001oogoo04Aoo`00?7oo00<007ooOol04goo00=NmgooOol08Woo00=NmgooOol02Goo0Ukg
67oo00=NmgooOol097oo00ENmgooOomooekg009oo`030[L2Mgoo01Aoo`03G_Moogoo00]oo`03G_Mo
ogoo00Ioo`03G_Mooekg00Qoo`03G_Moogoo00Ioo`06G_MoogooG_Mooa@G1Goo00=NmgooOol037oo
00=NmgooOol057oo00<007ooOol0A7oo000lOol00`00Oomoo`0COol00ekgOomoo`0ROol00ekgOomo
o`08Ool00ekgOomoo`0HOol00ekgOomoo`0TOol01UkgOomoogooG_L2mP<2]aAoo`03G_Moogoo00ao
o`03G_Moogoo00Moo`9Nm`Qoo`03G_Moogoo00Moo`9Nm`04OolD5a@G51L4Ool00ekgOomoo`0<Ool0
0ekgOomoo`0DOol00`00Oomoo`14Ool003aoo`03001oogoo01=oo`03G_Moogoo029oo`03G_Moogoo
00Ioo`9Nma]oo`03G_Moogoo02Aoo`04G_MoogooG_L30_H00`:gOomoo`0COol00ekgOomoo`0<Ool0
0ekgOomoo`08Ool2G_L7Ool00ekgOomoo`05Ool3G_L3Ool00a@GOomoo`04Ool00ekgOomoo`0<Ool0
0ekgOomoo`0COol00`00Oomoo`14Ool003Eoo`<000Aoo`03001oogoo01=oo`03G_Moogoo029oo`03
G_Moogoo00Eoo`03G_Moogoo01]oo`03G_Moogoo02Eoo`9Nm`03Ool2m0;f01Moo`03G_Moogoo00ao
o`03G_Moogoo00Qoo`03G_Mooekg009Nm`Aoo`03G_Moogoo00=oo`9Nm`9oo`03G_Moogoo00Qoo`03
G_Moogoo00aoo`03G_Moogoo01=oo`03001oogoo04Aoo`00=Goo00<007ooOol017oo00<007ooOol0
4goo00=NmgooOol08Woo00=NmgooOol00goo0Ukg7Woo00=NmgooOol09Goo0Ukg00<2lP;d0_@05Woo
00=NmgooOol037oo00=NmgooOol02Goo00=NmgooOol00Woo2Ukg17oo00=NmgooOol00Woo00<<5goo
Ool00goo00=NmgooOol03Goo00=NmgooOol04Woo00<007ooOol0A7oo000fOol00`00Oomoo`03Ool2
000DOol00ekgOomoo`0ROol00ekgOomoo`02Ool00ekgOomoo`0OOol00ekgOomoo`0TOol015kg0_82
lP;b5goo00=NmgooOol037oo00=NmgooOol027oo00=NmgooOol01goo00=NmgooOol01goo00ANmgoo
Oomoo`<<5`Aoo`03G_Moogoo00eoo`03G_Moogoo011oo`<004Ioo`00=Woo00<007ooOol00goo00<0
07ooOol04goo00=NmgooOol08Woo00=NmgooOol00Ukg8Woo00=NmgooOol08goo00ANm`;_Ool2lQMo
o`03G_Moogoo00eoo`03G_Moogoo00Qoo`03G_Moogoo00Moo`03G_Moogoo00Moo`03G_Moogoo009o
o`0331Moogoo00Aoo`03G_Moogoo00aoo`03G_Moogoo019oo`03001oogoo04Aoo`00=Goo00<007oo
000017oo00<007ooOol04goo00=NmgooOol08Woo00=NmgooG_L097oo00=NmgooOol08Woo00ANm`;]
0^l2kaQoo`03G_Moogoo00eoo`03G_Moogoo00Qoo`03G_Moogoo00Moo`03G_Moogoo00Moo`03G_Mo
ogoo00=oo`0301Moogoo00=oo`03G_Moogoo00eoo`03G_Moogoo015oo`03001oogoo04Aoo`00=Woo
00<007ooOol00goo00<007ooOol04goo00=NmgooOol08Woo0Ukg9Goo00=NmgooOol08Woo0`;]00=N
mgooOol05Woo00=NmgooOol037oo00=NmgooOol02Goo00=NmgooOol01goo00=NmgooOol01goo00=N
mgooOol00Woo00<05`@G01L017oo00=NmgooOol03Goo00=NmgooOol04Goo00<007ooOol0A7oo000l
Ool00`00Oomoo`0COol00ekgOomoo`0QOol00ekgOomNm`0UOol00ekgOomoo`0QOol01Ekg0^/2kGoo
G_L05goo00=NmgooOol03Goo00=NmgooOol02Goo00=NmgooOol01goo00=NmgooOol01goo00=Nmgoo
Ool00goo00<05gooOol00goo00=NmgooOol03Woo00=NmgooOol047oo00<007ooOol0A7oo000lOol0
0`00Oomoo`0COol00ekgOomoo`0OOol2G_L2Ool00ekgOomoo`0SOol00ekgOomoo`0POol01P;X0^/2
jP;[OomNmaMoo`03G_Moogoo00eoo`03G_Moogoo00Uoo`03G_Moogoo00Moo`03G_Moogoo00Qoo`03
G_Moogoo00Uoo`03G_Moogoo00eoo`03G_Moogoo011oo`03001oogoo04Aoo`00?7oo00<007ooOol0
57oo00=NmgooOol07Goo00=NmgooOol00Woo00=NmgooOol097oo00=NmgooOol07Woo0`;X00D2jgoo
Oomooekg01Eoo`03G_Moogoo00ioo`03G_Moogoo00Uoo`03G_Moogoo00Moo`03G_Moogoo00Qoo`03
G_Moogoo00Aoo`0301Moogoo009oo`03G_Moogoo00eoo`03G_Moogoo011oo`03001oogoo04Aoo`00
?7oo00<007ooOol057oo00=NmgooOol06goo0Ukg1Goo00=NmgooOol097oo00=NmgooOol07Woo00<2
iP;XOol017oo00=NmgooOol04goo00=NmgooOol03Goo00=NmgooOol02Woo00=NmgooOol01goo00=N
mgooOol027oo00=NmgooOol00goo00<05`0g01L00goo00=NmgooOol03Woo00=NmgooOol03goo00<0
07ooOol0A7oo000lOol00`00Oomoo`0DOol00ekgOomoo`0JOol00ekgOomoo`05Ool00ekgOomoo`0T
Ool00ekgOomoo`0MOol00`;T0^H2iP05Ool00ekgOomoo`0COol00ekgOomoo`0=Ool00ekgOomoo`0:
Ool00ekgOomoo`07Ool00ekgOomoo`08Ool00ekgOomoo`04Ool00`0GOomoo`02Ool00ekgOomoo`0>
Ool00ekgOomoo`0?Ool00`00Oomoo`14Ool003aoo`03001oogoo01Aoo`03G_Moogoo01Uoo`03G_Mo
ogoo00Ioo`03G_Moogoo02Aoo`03G_Moogoo01aoo`030^@2h`;T00Ioo`03G_Moogoo019oo`03G_Mo
ogoo00ioo`03G_Moogoo00Uoo`03G_Moogoo00Qoo`03G_Moogoo00Qoo`03G_Moogoo00Eoo`0507Mo
ogooOomNm`0AOol00ekgOomoo`0>Ool00`00Oomoo`14Ool003aoo`03001oogoo01Aoo`03G_Moogoo
01Moo`9Nm`Yoo`03G_Moogoo02=oo`03G_Moogoo01]oo`030^5Nm`;T00Qoo`03G_Moogoo015oo`03
G_Moogoo00ioo`03G_Moogoo00Uoo`03G_Moogoo00Qoo`03G_Moogoo00Qoo`03G_Moogoo00Aoo`<0
M`=oo`03G_Moogoo00ioo`03G_Moogoo00ioo`03001oogoo04Aoo`00?7oo00<007ooOol057oo00=N
mgooOol05Woo00=NmgooOol02Woo00=NmgooOol08goo00=NmgooOol06Woo0`;Q2Goo00=NmgooOol0
47oo00=NmgooOol03goo00=NmgooOol02Goo00=NmgooOol027oo00=NmgooOol027oo00=NmgooOol0
1Goo00<0MgooOol00Woo00=NmgooOol03Woo00=NmgooOol03Woo00<007ooOol0A7oo000lOol00`00
Oomoo`0DOol00ekgOomoo`0DOol2G_L=Ool00ekgOomoo`0SOol00ekgOomoo`0KOol00`;QOomoo`08
Ool00ekgOomoo`0@Ool00ekgOomoo`0>Ool00ekgOomoo`0:Ool00ekgOomoo`08Ool00ekgOomoo`08
Ool00ekgOomoo`0:Ool00ekgOomoo`0?Ool00ekgOomoo`0=Ool00`00Oomoo`14Ool003aoo`03001o
ogoo01Aoo`03G_Moogoo01=oo`03G_Moogoo00eoo`03G_Moogoo02Aoo`03G_Moogoo01Uoo`03G_Mo
ogoo00Uoo`03G_Moogoo011oo`03G_Moogoo00ioo`03G_Moogoo00Yoo`03G_Moogoo00Qoo`03G_Mo
ogoo00Qoo`03G_Moogoo00Ioo`050;MoogooOomNm`0AOol00ekgOomoo`0=Ool00`00Oomoo`14Ool0
03aoo`03001oogoo01Aoo`03G_Moogoo015oo`9Nma1oo`03G_Moogoo02Aoo`03G_Moogoo01Qoo`03
G_Moogoo00]oo`03G_Moogoo00ioo`03G_Moogoo00moo`03G_Moogoo00Yoo`03G_Moogoo00Qoo`03
G_Moogoo00Uoo`03G_Moogoo00Aoo`<0]`=oo`03G_Moogoo00moo`03G_Moogoo00aoo`03001oogoo
04Aoo`00?7oo00<007ooOol057oo00=NmgooOol047oo00=NmgooOol047oo00=NmgooOol097oo00=N
mgooOol05goo00=NmgooOol037oo00=NmgooOol03Woo00=NmgooOol03goo00=NmgooOol02Woo00=N
mgooOol027oo00=NmgooOol02Goo00=NmgooOol01Goo00<0]gooOol00Woo00=NmgooOol03goo00=N
mgooOol037oo00<007ooOol0A7oo000lOol00`00Oomoo`0DOol00ekgOomoo`0>Ool2G_LCOol00ekg
Oomoo`0TOol00ekgOomoo`0GOol00ekgOomoo`0<Ool00ekgOomoo`0>Ool00ekgOomoo`0>Ool00ekg
Oomoo`0;Ool00ekgOomoo`08Ool00ekgOomoo`09Ool00ekgOomoo`06Ool01@3gOomoogooG_L04Goo
00=NmgooOol037oo00<007ooOol0A7oo000lOol00`00Oomoo`0EOol00ekgOomoo`0<Ool00ekgOomo
o`0COol00ekgOomoo`0TOol00ekgOomoo`0FOol00ekgOomoo`0=Ool00ekgOomoo`0=Ool00ekgOomo
o`0?Ool00ekgOomoo`0;Ool00ekgOomoo`08Ool00ekgOomoo`09Ool00ekgOomoo`05Ool30?L2Ool0
0ekgOomoo`0@Ool00ekgOomoo`0;Ool00`00Oomoo`14Ool003aoo`03001oogoo01Eoo`03G_Moogoo
00Yoo`9NmaMoo`03G_Moogoo02=oo`03G_Moogoo01Eoo`03G_Moogoo00moo`03G_Moogoo00aoo`03
G_Moogoo00moo`03G_Moogoo00]oo`03G_Moogoo00Qoo`03G_Moogoo00Uoo`03G_Moogoo00Ioo`03
0?Moogoo009oo`03G_Moogoo00moo`03G_Moogoo00]oo`03001oogoo04Aoo`00?7oo00<007ooOol0
5Goo00=NmgooOol02Goo00=NmgooOol05goo00=NmgooOol097oo00=NmgooOol057oo00=NmgooOol0
3goo00=NmgooOol02goo00=NmgooOol047oo00=NmgooOol02Woo00=NmgooOol02Goo00=NmgooOol0
2Goo00=NmgooOol02goo00=NmgooOol047oo00=NmgooOol02Woo00<007ooOol0A7oo000lOol00`00
Oomoo`0EOol00ekgOomoo`07Ool2G_LJOol00ekgOomoo`0TOol00ekgOomoo`0COol00ekgOomoo`0@
Ool00ekgOomoo`0;Ool00ekgOomoo`0@Ool00ekgOomoo`0:Ool00ekgOomoo`09Ool00ekgOomoo`09
Ool00ekgOomoo`08Ool0105GOomooekg4Woo00=NmgooOol02Woo00=NmgooOol0A7oo000lOol00`00
Oomoo`0EOol00ekgOomoo`06Ool00ekgOomoo`0JOol00ekgOomoo`0TOol00ekgOomoo`0BOol00ekg
Oomoo`0BOol00ekgOomoo`0:Ool00ekgOomoo`0?Ool00ekgOomoo`0;Ool00ekgOomoo`09Ool00ekg
Oomoo`09Ool00ekgOomoo`07Ool01@5G0CH1EgooG_L04Woo00=NmgooOol02Woo00=NmgooOol0A7oo
000lOol2000FOol00ekgOomoo`04Ool2G_LMOol00ekgOomoo`0TOol00ekgOomoo`0BOol00ekgOomo
o`0BOol00ekgOomoo`09Ool00ekgOomoo`0@Ool00ekgOomoo`0;Ool00ekgOomoo`09Ool00ekgOomo
o`09Ool00ekgOomoo`08Ool0105GOomooekg4goo00=NmgooOol027oo00=Nm`00Ool0AGoo000lOol0
0`00Oomoo`0EOol00ekgOomoo`03Ool00ekgOomoo`0MOol00ekgOomoo`0TOol00ekgOomoo`0AOol0
0ekgOomoo`0COol00ekgOomoo`09Ool00ekgOomoo`0@Ool00ekgOomoo`0;Ool00ekgOomoo`09Ool0
0ekgOomoo`0:Ool00ekgOomoo`08Ool0106GOomooekg4Woo00=NmgooOol027oo00=Nm`00Ool0AGoo
000lOol00`00Oomoo`0EOol015kgOomoogoo0Ukg87oo00=NmgooOol097oo00=NmgooOol047oo00=N
mgooOol05Goo00=NmgooOol01goo00=NmgooOol04Goo00=NmgooOol02goo00=NmgooOol02Goo00=N
mgooOol02Woo00=NmgooOol01goo0`6G00=ooekgOol04Woo00=NmgooOol01Woo00=Nmgoo0000AWoo
000lOol00`00Oomoo`0EOol015kgOomooekg8goo00=NmgooOol097oo00=NmgooOol03goo00=Nmgoo
Ool05Goo00=NmgooOol01goo00=NmgooOol047oo00=NmgooOol037oo00=NmgooOol02Goo00=Nmgoo
Ool02Woo00=NmgooOol027oo00@1UgooOomNma=oo`03G_Moogoo00Ioo`03G_Moo`0004Ioo`00?7oo
00<007ooOol05Woo0Ukg97oo00=NmgooOol097oo00=NmgooOol03Woo00=NmgooOol05goo00=Nmgoo
Ool01Woo00=NmgooOol047oo00=NmgooOol037oo00=NmgooOol02Goo00=NmgooOol02Woo00=Nmgoo
Ool02goo00=NmgooOol04Goo00=NmgooOol01Woo00=Nmgoo0000AWoo000lOol00`00Oomoo`0EOol2
G_LUOol00ekgOomoo`0TOol00ekgOomoo`0=Ool00ekgOomoo`0HOol00ekgOomoo`05Ool00ekgOomo
o`0AOol00ekgOomoo`0<Ool00ekgOomoo`09Ool00ekgOomoo`0:Ool00ekgOomoo`09Ool0107GOomo
oekg4goo00=NmgooOol017oo00ANmgooOol004Ioo`00?7oo00<007ooOol04goo0Ukg00=ooekgOol0
97oo00=NmgooOol097oo00=NmgooOol037oo00=NmgooOol06Goo00=NmgooOol01Goo00=NmgooOol0
4Goo00=NmgooOol02goo00=NmgooOol02Woo00=NmgooOol02Woo00=NmgooOol027oo0`7G00=ooekg
Ool04Woo00=NmgooOol017oo00ANmgooOol004Ioo`00?7oo00<007ooOol04Woo00ENmgooOomooekg
02Eoo`03G_Moogoo02Aoo`03G_Moogoo00aoo`03G_Moogoo01Yoo`03G_Moogoo00=oo`03G_Moogoo
015oo`03G_Moogoo00aoo`03G_Moogoo00Yoo`03G_Moogoo00Yoo`03G_Moogoo00Uoo`040MMoogoo
G_LDOol00ekgOomoo`03Ool015kgOomoo`00AWoo000lOol00`00Oomoo`0@Ool2G_L4Ool00ekgOomo
o`0SOol00ekgOomoo`0TOol00ekgOomoo`0;Ool00ekgOomoo`0KOol00ekgOomoo`03Ool00ekgOomo
o`0AOol00ekgOomoo`0<Ool00ekgOomoo`0:Ool00ekgOomoo`0:Ool00ekgOomoo`0:Ool00`8gOomN
m`0DOol00ekgOomoo`02Ool01EkgOomoogoo0000AWoo000lOol00`00Oomoo`0?Ool00ekgOomoo`04
Ool00ekgOomoo`0SOol00ekgOomoo`0UOol00ekgOomoo`09Ool00ekgOomoo`0LOol00ekgOomoo`03
Ool00ekgOomoo`0AOol00ekgOomoo`0<Ool00ekgOomoo`0:Ool00ekgOomoo`0:Ool00ekgOomoo`09
Ool30SL00gooG_Moo`0BOol00ekgOomoo`02Ool01EkgOomoogoo0000AWoo000lOol00`00Oomoo`0=
Ool2G_L7Ool00ekgOomoo`0TOol00ekgOomoo`0TOol00ekgOomoo`09Ool00ekgOomoo`0MOol01Ekg
OomoogooG_L057oo00=NmgooOol037oo00=NmgooOol02Woo00=NmgooOol02goo00=NmgooOol02Goo
00@2=gooOomNmaAoo`04G_MoogooG_L4Ool00`00Oomoo`14Ool003aoo`03001oogoo00aoo`03G_Mo
ogoo00Moo`03G_Moogoo02Aoo`03G_Moogoo02Aoo`03G_Moogoo00Qoo`03G_Moogoo01ioo`05G_Mo
ogooOomNm`0DOol00ekgOomoo`0<Ool00ekgOomoo`0:Ool00ekgOomoo`0;Ool00ekgOomoo`0:Ool0
0`9gOomNm`0DOol015kgOomooekg17oo00<007ooOol0A7oo000lOol00`00Oomoo`0:Ool2G_L;Ool0
0ekgOomoo`0SOol00ekgOomoo`0TOol00ekgOomoo`07Ool00ekgOomoo`0OOol015kgOomooekg57oo
00=NmgooOol03Goo00=NmgooOol02Woo00=NmgooOol02goo00=NmgooOol02Goo0`9g00=NmgooOol0
4goo00=NmgooG_L017oo00<007ooOol0A7oo000lOol00`00Oomoo`09Ool00ekgOomoo`0;Ool00ekg
Oomoo`0SOol00ekgOomoo`0TOol00ekgOomoo`07Ool00ekgOomoo`0POol00ekgOomNm`0DOol00ekg
Oomoo`0=Ool00ekgOomoo`0:Ool00ekgOomoo`0;Ool00ekgOomoo`0:Ool0109gOomooekg57oo0Ukg
1Goo00<007ooOol0A7oo000lOol00`00Oomoo`07Ool2G_L>Ool00ekgOomoo`0SOol00ekgOomoo`0T
Ool00ekgOomoo`06Ool00ekgOomoo`0QOol00ekgOomNm`0DOol00ekgOomoo`0=Ool00ekgOomoo`0:
Ool00ekgOomoo`0;Ool00ekgOomoo`0=Ool00ekgOomoo`0COol00ekgOomoo`03Ool00`00Oomoo`14
Ool003aoo`03001oogoo00Ioo`03G_Moogoo00ioo`03G_Moogoo02=oo`03G_Moogoo02Eoo`03G_Mo
ogoo00Aoo`03G_Moogoo02=oo`03G_Moogoo01=oo`03G_Moogoo00eoo`03G_Moogoo00Yoo`03G_Mo
ogoo00]oo`03G_Moogoo00]oo`030[Mooekg01Aoo`9Nm`Eoo`03001oogoo04Aoo`00?7oo00<007oo
Ool017oo0Ukg4Goo00=NmgooOol08goo00=NmgooOol09Goo00=NmgooOol017oo00=NmgooOol08goo
00=NmgooOol04Woo00=NmgooOol03Goo00=NmgooOol02goo00=NmgooOol02goo00=NmgooOol02Woo
0`:g00=NmgooOol04Woo0Ukg1Goo00<007ooOol0A7oo000lOol00`00Oomoo`03Ool00ekgOomoo`0A
Ool00ekgOomoo`0SOol00ekgOomoo`0UOol00ekgOomoo`03Ool00ekgOomoo`0SOol00ekgOomNm`0C
Ool00ekgOomoo`0=Ool00ekgOomoo`0;Ool00ekgOomoo`0;Ool00ekgOomoo`0;Ool00`:gOomNm`0D
Ool00ekgOomNm`04Ool00`00Oomoo`14Ool003aoo`04001oogooOol2G_LDOol00ekgOomoo`0TOol0
0ekgOomoo`0TOol00ekgOomoo`02Ool00ekgOomoo`0TOol00ekgOomNm`0COol00ekgOomoo`0=Ool0
0ekgOomoo`0;Ool00ekgOomoo`0;Ool00ekgOomoo`0=Ool00`;fG_Moo`0AOol015kgOomooekg17oo
00<007ooOol0A7oo000lOol01000Oomooekg5Woo00=NmgooOol097oo00=NmgooOol097oo00ENmgoo
Oomooekg02Moo`04G_MoogooG_LBOol00ekgOomoo`0=Ool00ekgOomoo`0;Ool00ekgOomoo`0<Ool0
0ekgOomoo`0;Ool00`;f0_L2mP0BOol01EkgOomoogooG_L00goo00<007ooOol0A7oo000lOol00`00
G_MNm`0HOol00ekgOomoo`0SOol00ekgOomoo`0UOol015kgOomooekg9Woo00ENmgooOomooekg015o
o`03G_Moogoo00ioo`03G_Moogoo00]oo`03G_Moogoo00aoo`03G_Moogoo00aoo`030_INmgoo015o
o`05G_MoogooOomNm`03Ool00`00Oomoo`14Ool003aoo`03G_Moogoo01Qoo`03G_Moogoo02=oo`03
G_Moogoo02Eoo`03G_Mooekg02Moo`05G_MoogooOomNm`0AOol00ekgOomoo`0>Ool00ekgOomoo`0;
Ool00ekgOomoo`0<Ool00ekgOomoo`0=Ool00ekgOomoo`0?Ool00ekgOomoo`02Ool01EkgOomoogoo
0000AWoo000lOol00`00Oomoo`0HOol00ekgOomoo`0SOol00ekgOomoo`0UOol2G_LWOol00ekgOomo
o`03Ool00ekgOomoo`0>Ool00ekgOomoo`0>Ool00ekgOomoo`0;Ool00ekgOomoo`0<Ool00ekgOomo
o`0=Ool00`;dG_Moo`0?Ool00ekgOomoo`03Ool015kgOomoo`00AWoo000lOol2000IOol00ekgOomo
o`0SOol00ekgOomoo`0UOol2G_LWOol00ekgOomoo`03Ool00ekgOomoo`0>Ool00ekgOomoo`0>Ool0
0ekgOomoo`0;Ool00ekgOomoo`0<Ool00ekgOomoo`0<Ool30_@?Ool00ekgOomoo`04Ool015kgOol0
0000AWoo000lOol00`00Oomoo`0HOol00ekgOomoo`0TOol00ekgOomoo`0TOol2G_LWOol00ekgOomo
o`04Ool00ekgOomoo`0=Ool00ekgOomoo`0>Ool00ekgOomoo`0;Ool00ekgOomoo`0<Ool00ekgOomo
o`0=Ool00`;dG_Moo`0>Ool00ekgOomoo`05Ool00ekgOol00016Ool003aoo`03001oogoo01Qoo`03
G_Moogoo02Aoo`03G_Moogoo02=oo`03G_Mooekg02Ioo`03G_Moogoo00Eoo`03G_Moogoo00aoo`03
G_Moogoo00ioo`03G_Moogoo00aoo`03G_Moogoo00aoo`03G_Moogoo00ioo`030_9oogoo00eoo`03
G_Moogoo00Eoo`03G_Moo`0004Ioo`00?7oo00<007ooOol067oo00=NmgooOol097oo00=NmgooOol0
8goo00=NmgooG_L09Woo00=NmgooOol01Woo00=NmgooOol02goo00=NmgooOol03Woo00=NmgooOol0
37oo00=NmgooOol037oo00=NmgooOol03Goo0`;b3Goo00=NmgooOol01Woo00=Nmgoo0000AWoo000l
Ool00`00Oomoo`0IOol00ekgOomoo`0SOol00ekgOomoo`0ROol015kgOomooekg9Goo00=NmgooOol0
1goo00=NmgooOol02goo00=NmgooOol03Woo00=NmgooOol037oo00=NmgooOol037oo00=NmgooOol0
3Woo00<2lUkgOol037oo00=NmgooOol01goo00=Nm`00Ool0AGoo000lOol00`00Oomoo`0IOol00ekg
Oomoo`0SOol00ekgOomoo`0QOol00ekgOomoo`02Ool00ekgOomoo`0ROol00ekgOomoo`08Ool00ekg
Oomoo`0:Ool00ekgOomoo`0>Ool00ekgOomoo`0<Ool00ekgOomoo`0=Ool00ekgOomoo`0>Ool00ekg
Oomoo`0:Ool00ekgOomoo`08Ool00ekg001oo`15Ool003aoo`03001oogoo01Uoo`03G_Moogoo02Ao
o`03G_Moogoo01moo`03G_Moogoo00=oo`03G_Moogoo029oo`03G_Moogoo00Qoo`03G_Moogoo00Uo
o`03G_Moogoo00moo`03G_Moogoo00aoo`03G_Moogoo00eoo`03G_Moogoo00ioo`030^moogoo00Yo
o`03G_Moogoo00Uoo`03G_Moogoo04Aoo`00?7oo00<007ooOol06Goo00=NmgooOol097oo00=Nmgoo
Ool07goo00=NmgooOol00goo00=NmgooOol08Goo00=NmgooOol02Woo00=NmgooOol027oo00=Nmgoo
Ool03goo00=NmgooOol037oo00=NmgooOol03Goo00=NmgooOol03Goo00<2k`;`0^l02Woo00=Nmgoo
Ool02Woo00=NmgooOol0A7oo000lOol00`00Oomoo`0IOol00ekgOomoo`0TOol00ekgOomoo`0NOol0
0ekgOomoo`05Ool00ekgOomoo`0POol00ekgOomoo`0:Ool00ekgOomoo`08Ool00ekgOomoo`0?Ool0
0ekgOomoo`0<Ool00ekgOomoo`0=Ool00ekgOomoo`0>Ool00`;_G_Moo`09Ool00ekgOomoo`0:Ool0
0`00Oomoo`14Ool003aoo`03001oogoo01Uoo`03G_Moogoo02Aoo`03G_Moogoo01eoo`03G_Moogoo
00Ioo`03G_Moogoo01moo`03G_Moogoo00aoo`03G_Moogoo00Moo`03G_Moogoo00moo`03G_Moogoo
00aoo`03G_Moogoo00eoo`03G_Moogoo00moo`030^eoogoo00Moo`03G_Moogoo00]oo`03001oogoo
04Aoo`00?7oo00<007ooOol06Goo00=NmgooOol097oo00=NmgooOol07Goo00=NmgooOol01Woo00=N
mgooOol07goo00=NmgooOol037oo00=NmgooOol01Woo00=NmgooOol047oo00=NmgooOol037oo00=N
mgooOol03Goo00=NmgooOol03Woo0`;]1goo00=NmgooOol037oo00<007ooOol0A7oo000lOol00`00
Oomoo`0IOol00ekgOomoo`0UOol00ekgOomoo`0KOol00ekgOomoo`07Ool00ekgOomoo`0OOol00ekg
Oomoo`0=Ool00ekgOomoo`05Ool00ekgOomoo`0@Ool00ekgOomoo`0<Ool00ekgOomoo`0=Ool00ekg
Oomoo`0?Ool00`;]Oomoo`06Ool00ekgOomoo`0<Ool00`00Oomoo`14Ool003aoo`03001oogoo01Yo
o`03G_Moogoo02Aoo`03G_Moogoo01Yoo`03G_Moogoo00Uoo`03G_Moogoo01eoo`03G_Moogoo00io
o`03G_Moogoo00Eoo`03G_Moogoo00moo`03G_Moogoo00eoo`03G_Moogoo00eoo`03G_Moogoo011o
o`030^]oogoo00Aoo`03G_Moogoo00eoo`03001oogoo04Aoo`00?7oo00<007ooOol06Woo00=Nmgoo
Ool097oo00=NmgooOol06Woo00=NmgooOol02Goo00=NmgooOol07Goo00=NmgooOol03goo00=Nmgoo
Ool017oo00=NmgooOol03goo00=NmgooOol03Goo00=NmgooOol03Goo00=NmgooOol03goo0`;[17oo
00=NmgooOol03Woo00<007ooOol0A7oo000lOol00`00Oomoo`0JOol00ekgOomoo`0TOol00ekgOomo
o`0IOol00ekgOomoo`0:Ool00ekgOomoo`0LOol00ekgOomoo`0@Ool00ekgOomoo`04Ool00ekgOomo
o`0?Ool00ekgOomoo`0=Ool00ekgOomoo`0>Ool00ekgOomoo`0?Ool00`;[Oomoo`03Ool00ekgOomo
o`0>Ool00`00Oomoo`14Ool003aoo`03001oogoo01Yoo`03G_Moogoo02Aoo`03G_Moogoo01Qoo`03
G_Moogoo00aoo`03G_Moogoo01]oo`03G_Moogoo015oo`03G_Moogoo009oo`03G_Moogoo011oo`03
G_Moogoo00eoo`03G_Moogoo00ioo`03G_Moogoo00moo`03G_Moogoo009oo`03G_Moogoo00moo`03
001oogoo04Aoo`00?7oo00<007ooOol06Woo00=NmgooOol09Goo00=NmgooOol05goo00=NmgooOol0
37oo00=NmgooOol06goo00=NmgooOol04Goo00=NmgooOol00Woo00=NmgooOol047oo00=NmgooOol0
3Goo00=NmgooOol03Woo00=NmgooOol047oo00D2j7ooOomooekg015oo`03001oogoo04Aoo`00?7oo
00<007ooOol06Woo00=NmgooOol09Goo00=NmgooOol05Woo00=NmgooOol03Goo00=NmgooOol06Woo
00=NmgooOol04goo00ENmgooOomooekg019oo`03G_Moogoo00eoo`03G_Moogoo00ioo`03G_Moogoo
00moo`<2j003OomNmgoo015oo`03001oogoo04Aoo`00?7oo00<007ooOol06Woo00=NmgooOol09Goo
00=NmgooOol05Goo00=NmgooOol03Woo00=NmgooOol06Woo00=NmgooOol057oo00ANmgooOomNma9o
o`03G_Moogoo00eoo`03G_Moogoo00ioo`03G_Moogoo011oo`030^Qooekg01=oo`03001oogoo04Ao
o`00?7oo00<007ooOol06Woo00=NmgooOol09Goo00=NmgooOol057oo00=NmgooOol047oo00=Nmgoo
Ool067oo00=NmgooOol05Goo00=NmgooG_L04goo00=NmgooOol03Goo00=NmgooOol03Woo00=Nmgoo
Ool047oo00=Nm`;VG_L04goo00<007ooOol0A7oo000lOol00`00Oomoo`0KOol00ekgOomoo`0TOol0
0ekgOomoo`0DOol00ekgOomoo`0@Ool00ekgOomoo`0HOol00ekgOomoo`0FOol2G_LCOol00ekgOomo
o`0=Ool00ekgOomoo`0>Ool00ekgOomoo`0@Ool30^HCOol00`00Oomoo`14Ool003aoo`03001oogoo
01]oo`03G_Moogoo02Aoo`03G_Moogoo01=oo`03G_Moogoo015oo`03G_Moogoo01Qoo`03G_Moogoo
01Moo`03G_Moogoo011oo`03G_Moogoo00ioo`03G_Moogoo00ioo`03G_Moogoo011oo`03G_L2iWoo
01=oo`03001oogoo04Aoo`00?7oo00<007ooOol06goo00=NmgooOol09Goo00=NmgooOol04Goo00=N
mgooOol04Woo00=NmgooOol05goo00=NmgooOol067oo0Ukg4Goo00=NmgooOol03Woo00=NmgooOol0
3Woo00=NmgooOol03goo00=NmgooG_L057oo00<007ooOol0A7oo000lOol2000LOol00ekgOomoo`0U
Ool00ekgOomoo`0AOol00ekgOomoo`0COol00ekgOomoo`0FOol00ekgOomoo`0GOol00ekgOomNm`0A
Ool00ekgOomoo`0>Ool00ekgOomoo`0>Ool00ekgOomoo`0?Ool015kgOomNm`;T4Woo0P00AWoo000l
Ool00`00Oomoo`0KOol00ekgOomoo`0UOol00ekgOomoo`0@Ool00ekgOomoo`0DOol00ekgOomoo`0E
Ool00ekgOomoo`0HOol015kgOomooekg47oo00=NmgooOol03Woo00=NmgooOol03goo00=NmgooOol0
3Goo00=NmgooOol00`;T4Woo00<007ooOol0A7oo000lOol00`00Oomoo`0KOol00ekgOomoo`0UOol0
0ekgOomoo`0?Ool00ekgOomoo`0EOol00ekgOomoo`0EOol00ekgOomoo`0HOol01EkgOomoogooG_L0
3goo00=NmgooOol03Woo00=NmgooOol03goo00=NmgooOol037oo00=NmgooOol00Woo00<2i7ooOol0
4Goo00<007ooOol0A7oo000lOol00`00Oomoo`0KOol00ekgOomoo`0UOol00ekgOomoo`0?Ool00ekg
Oomoo`0FOol00ekgOomoo`0DOol00ekgOomoo`0HOol00ekgOomoo`02Ool00ekgOomoo`0<Ool00ekg
Oomoo`0>Ool00ekgOomoo`0?Ool00ekgOomoo`0;Ool00ekgOomoo`03Ool00ekgOol2h@0AOol00`00
Oomoo`14Ool003aoo`03001oogoo01]oo`03G_Moogoo02Ioo`03G_Moogoo00eoo`03G_Moogoo01Mo
o`03G_Moogoo01=oo`03G_Moogoo01Uoo`03G_Moogoo009oo`03G_Moogoo00aoo`03G_Moogoo00io
o`03G_Moogoo00moo`03G_Moogoo00]oo`03G_Moogoo00=oo`04G_L2h@;Q0^4@Ool00`00Oomoo`14
Ool003aoo`03001oogoo01aoo`03G_Moogoo02Eoo`03G_Moogoo00aoo`03G_Moogoo01Qoo`03G_Mo
ogoo01=oo`03G_Moogoo01Qoo`03G_Moogoo00Aoo`03G_Moogoo00]oo`03G_Moogoo00ioo`03G_Mo
ogoo00moo`03G_Moogoo00Yoo`03G_Moogoo00Aoo`03G_Moo`;Q015oo`03001oogoo04Aoo`00?7oo
00<007ooOol077oo00=NmgooOol09Goo00=NmgooOol037oo00=NmgooOol06Goo00=NmgooOol04Goo
00=NmgooOol06Goo00=NmgooOol01Goo00=NmgooOol02Woo00=NmgooOol03Woo00=NmgooOol03goo
00=NmgooOol02Goo00=NmgooOol01Woo00=NmgooOol047oo00<007ooOol0A7oo000lOol00`00Oomo
o`0LOol00ekgOomoo`0UOol00ekgOomoo`0;Ool00ekgOomoo`0JOol00ekgOomoo`0AOol00ekgOomo
o`0IOol00ekgOomoo`06Ool00ekgOomoo`09Ool00ekgOomoo`0>Ool00ekgOomoo`0?Ool00ekgOomo
o`08Ool00ekgOomoo`07Ool00ekgOomoo`0@Ool00`00Oomoo`14Ool003aoo`03001oogoo01aoo`03
G_Moogoo02Eoo`03G_Moogoo00Yoo`03G_Moogoo01]oo`03G_Moogoo015oo`03G_Moogoo01Uoo`03
G_Moogoo00Moo`03G_Moogoo00Moo`03G_Moogoo00moo`03G_Moogoo00moo`03G_Moogoo00Moo`03
G_Moogoo00Qoo`03G_Moogoo011oo`03001oogoo04Aoo`00?7oo00<007ooOol077oo00=NmgooOol0
9Woo00=NmgooOol027oo00=NmgooOol07Goo00=NmgooOol03goo00=NmgooOol06Goo00=NmgooOol0
2Goo00=NmgooOol01Woo00=NmgooOol03goo00=NmgooOol03goo00=NmgooOol01Woo00=NmgooOol0
2Goo00=NmgooOol047oo00<007ooOol0A7oo000lOol00`00Oomoo`0LOol00ekgOomoo`0VOol00ekg
Oomoo`08Ool00ekgOomoo`0MOol00ekgOomoo`0?Ool00ekgOomoo`0IOol00ekgOomoo`0:Ool00ekg
Oomoo`05Ool00ekgOomoo`0?Ool00ekgOomoo`0@Ool00ekgOomoo`05Ool00ekgOomoo`0:Ool00ekg
Oomoo`0?Ool00`00Oomoo`14Ool003aoo`03001oogoo01eoo`03G_Moogoo02Eoo`03G_Moogoo00Mo
o`03G_Moogoo01ioo`03G_Moogoo00ioo`03G_Moogoo01Yoo`03G_Moogoo00]oo`03G_Moogoo00Ao
o`03G_Moogoo00moo`03G_Moogoo011oo`03G_Moogoo00Aoo`03G_Moogoo00]oo`03G_Moogoo00mo
o`03001oogoo04Aoo`00?7oo00<007ooOol07Goo00=NmgooOol09Goo00=NmgooOol01Woo00=Nmgoo
Ool087oo00=NmgooOol03Goo00=NmgooOol06Woo00=NmgooOol037oo00=NmgooOol00goo00=Nmgoo
Ool03goo00=NmgooOol047oo00=NmgooOol00goo00=NmgooOol037oo00=NmgooOol03goo00<007oo
Ool0A7oo000lOol00`00Oomoo`0MOol00ekgOomoo`0UOol00ekgOomoo`06Ool00ekgOomoo`0POol0
0ekgOomoo`0=Ool00ekgOomoo`0IOol00ekgOomoo`0>Ool00ekgOomoo`02Ool00ekgOomoo`0?Ool0
0ekgOomoo`0@Ool00ekgOomoo`02Ool00ekgOomoo`0=Ool00ekgOomoo`0?Ool00`00Oomoo`14Ool0
03aoo`03001oogoo01eoo`03G_Moogoo02Ioo`03G_Moogoo00Aoo`03G_Moogoo029oo`03G_Moogoo
00]oo`03G_Moogoo01Yoo`03G_Moogoo00moo`05G_MoogooOomNm`0AOol00ekgOomoo`0@Ool01Ekg
OomoogooG_L04Goo00=NmgooOol03Woo00<007ooOol0A7oo000lOol00`00Oomoo`0MOol00ekgOomo
o`0VOol00ekgOomoo`03Ool00ekgOomoo`0SOol00ekgOomoo`0;Ool00ekgOomoo`0JOol00ekgOomo
o`0@Ool2G_L00gooG_Moo`0@Ool00ekgOomoo`0@Ool015kgOomNmekg4Woo00=NmgooOol03Woo00<0
07ooOol0A7oo000lOol00`00Oomoo`0NOol00ekgOomoo`0UOol00ekgOomoo`03Ool00ekgOomoo`0S
Ool00ekgOomoo`0;Ool00ekgOomoo`0JOol00ekgOomoo`0BOol2G_LAOol00ekgOomoo`0@Ool2G_LD
Ool00ekgOomoo`0>Ool00`00Oomoo`14Ool003aoo`03001oogoo01ioo`03G_Moogoo02Eoo`03G_Mo
ogoo009oo`03G_Moogoo02Eoo`03G_Moogoo00Uoo`03G_Moogoo01]oo`03G_Moogoo019oo`04G_Mo
oekgG_L?Ool00ekgOomoo`0>Ool3G_LEOol00ekgOomoo`0>Ool00`00Oomoo`14Ool003aoo`03001o
ogoo01ioo`03G_Moogoo02Eoo`05G_MoogooOomNm`0XOol00ekgOomoo`09Ool00ekgOomoo`0JOol0
0ekgOomoo`0COol015kgOomoogoo0Ukg3Goo00=NmgooOol037oo0Ukg0Woo00=NmgooOol04goo00=N
mgooOol03Woo00<007ooOol0A7oo000lOol00`00Oomoo`0NOol00ekgOomoo`0VOol015kgOomooekg
:7oo00=NmgooOol027oo00=NmgooOol06goo00=NmgooOol04goo00=NmgooOol00goo0Ukg2goo00=N
mgooOol02Woo0Ukg1Goo00=NmgooOol04goo00=NmgooOol03Goo00<007ooOol0A7oo000fOol30003
Ool00`00Oomoo`0NOol00ekgOomoo`0VOol00ekgOomNm`0ZOol00ekgOomoo`07Ool00ekgOomoo`0K
Ool00ekgOomoo`0COol00ekgOomoo`05Ool3G_L8Ool00ekgOomoo`07Ool3G_L7Ool00ekgOomoo`0C
Ool00ekgOomoo`0=Ool00`00Oomoo`14Ool003Moo`03001oogoo009oo`03001oogoo01ioo`03G_Mo
ogoo02Ioo`9Nmb]oo`03G_Moogoo00Moo`03G_Moogoo01]oo`03G_Moogoo01=oo`03G_Moogoo00Qo
o`=Nm`Eoo`03G_Moogoo00Aoo`=Nm`Yoo`03G_Moogoo01=oo`03G_Moogoo00eoo`03001oogoo04Ao
o`00=Goo10000goo0P0087oo00=NmgooOol09Goo00=NmgooOol0:Woo00=NmgooOol01Woo00=Nmgoo
Ool06goo00=NmgooOol057oo00=NmgooOol02goo35kg3Goo00=NmgooOol04goo00=NmgooOol02goo
0`00AWoo000eOol00`00Ool00004Ool00`00Oomoo`0OOol00ekgOomoo`0UOol2G_L/Ool00ekgOomo
o`05Ool00ekgOomoo`0KOol00ekgOomoo`0DOol00ekgOomoo`0@Ool00ekgOomoo`0AOol00ekgOomo
o`0DOol00ekgOomoo`0<Ool00`00Oomoo`14Ool003Ioo`8000Aoo`03001oogoo01moo`03G_Moogoo
02Aoo`03G_Mooekg02aoo`03G_Moogoo00Aoo`03G_Moogoo01aoo`03G_Moogoo01Aoo`03G_Moogoo
011oo`03G_Moogoo015oo`03G_Moogoo01Aoo`03G_Moogoo00aoo`03001oogoo04Aoo`00=goo00<0
07ooOol00Woo00<007ooOol07goo00=NmgooOol08goo00ANmgooOomNmbaoo`03G_Moogoo00Aoo`03
G_Moogoo01aoo`03G_Moogoo01Aoo`03G_Moogoo011oo`03G_Moogoo015oo`03G_Moogoo01Aoo`03
G_Moogoo00aoo`03001oogoo04Aoo`00?7oo00<007ooOol07goo00=NmgooOol08goo00ANmgooOomN
mbeoo`03G_Moogoo00=oo`03G_Moogoo01aoo`03G_Moogoo01Aoo`03G_Moogoo011oo`03G_Moogoo
015oo`03G_Moogoo01Aoo`03G_Moogoo00aoo`03001oogoo04Aoo`00?7oo00<007ooOol087oo00=N
mgooOol08Goo00=NmgooOol00Woo00=NmgooOol0:Woo00=NmgooOol00Woo00=NmgooOol077oo00=N
mgooOol057oo00=NmgooOol04Goo00=NmgooOol04Goo00=NmgooOol05Goo00=NmgooOol02goo00<0
07ooOol0A7oo000lOol00`00Oomoo`0POol00ekgOomoo`0POol00ekgOomoo`03Ool00ekgOomoo`0Z
Ool00ekgOomoo`02Ool00ekgOomoo`0LOol00ekgOomoo`0DOol00ekgOomoo`0AOol00ekgOomoo`0B
Ool00ekgOomoo`0DOol00ekgOomoo`0;Ool00`00Oomoo`14Ool003aoo`03001oogoo021oo`03G_Mo
ogoo021oo`03G_Moogoo00=oo`03G_Moogoo02]oo`04G_MoogooG_LOOol00ekgOomoo`0DOol00ekg
Oomoo`0AOol00ekgOomoo`0BOol00ekgOomoo`0DOol00ekgOomoo`0;Ool00`00Oomoo`14Ool003ao
o`03001oogoo021oo`03G_Moogoo01moo`03G_Moogoo00Aoo`03G_Moogoo02]oo`04G_MoogooG_LO
Ool00ekgOomoo`0DOol00ekgOomoo`0AOol00ekgOomoo`0BOol00ekgOomoo`0DOol00ekgOomoo`0;
Ool00`00Oomoo`14Ool003aoo`03001oogoo021oo`03G_Moogoo01ioo`03G_Moogoo00Ioo`03G_Mo
ogoo02]oo`03G_Mooekg01ioo`03G_Moogoo01Eoo`03G_Moogoo015oo`03G_Moogoo019oo`03G_Mo
ogoo01Eoo`03G_Moogoo00Yoo`03001oogoo04Aoo`00?7oo00<007ooOol08Goo00=NmgooOol077oo
00=NmgooOol01goo00=NmgooOol0:goo0Ukg7goo00=NmgooOol05Goo00=NmgooOol04Goo00=Nmgoo
Ool04Woo00=NmgooOol05Goo00=NmgooOol02Woo00<007ooOol0A7oo000lOol00`00Oomoo`0QOol0
0ekgOomoo`0LOol00ekgOomoo`07Ool00ekgOomoo`0[Ool2G_LOOol00ekgOomoo`0EOol00ekgOomo
o`0AOol00ekgOomoo`0BOol00ekgOomoo`0EOol00ekgOomoo`0:Ool00`00Oomoo`14Ool003aoo`03
001oogoo025oo`03G_Moogoo01]oo`03G_Moogoo00Qoo`03G_Moogoo02]oo`9Nmamoo`03G_Moogoo
01Eoo`03G_Moogoo015oo`03G_Moogoo019oo`03G_Moogoo01Eoo`03G_Moogoo00Yoo`03001oogoo
04Aoo`00?7oo00<007ooOol08Goo00=NmgooOol06Woo00=NmgooOol02Goo00=NmgooOol0:goo0Ukg
7Woo00=NmgooOol05Woo00=NmgooOol04Goo00=NmgooOol04Woo00=NmgooOol05Goo00=NmgooOol0
2Woo00<007ooOol0A7oo000lOol00`00Oomoo`0QOol00ekgOomoo`0JOol00ekgOomoo`0:Ool00ekg
Oomoo`0ZOol00ekgOomNm`0MOol00ekgOomoo`0EOol00ekgOomoo`0BOol00ekgOomoo`0BOol00ekg
Oomoo`0FOol00ekgOomoo`09Ool00`00Oomoo`14Ool003aoo`03001oogoo029oo`03G_Moogoo01Qo
o`03G_Moogoo00]oo`03G_Moogoo02Uoo`04G_MoogooG_LMOol00ekgOomoo`0EOol00ekgOomoo`0B
Ool00ekgOomoo`0COol00ekgOomoo`0EOol00ekgOomoo`09Ool00`00Oomoo`14Ool003aoo`03001o
ogoo029oo`03G_Moogoo01Moo`03G_Moogoo00aoo`03G_Moogoo02Uoo`04G_MoogooG_LMOol00ekg
Oomoo`0EOol00ekgOomoo`0BOol00ekgOomoo`0COol00ekgOomoo`0EOol00ekgOomoo`09Ool00`00
Oomoo`14Ool003aoo`03001oogoo029oo`03G_Moogoo01Moo`03G_Moogoo00aoo`03G_Moogoo02Qo
o`03G_Moogoo009oo`03G_Moogoo01Yoo`03G_Moogoo01Eoo`03G_Moogoo019oo`03G_Moogoo01=o
o`03G_Moogoo01Eoo`03G_Moogoo00Uoo`03001oogoo04Aoo`00?7oo00<007ooOol08Woo00=Nmgoo
Ool05Woo00=NmgooOol03Woo00=NmgooOol09goo00=NmgooOol00Woo00=NmgooOol06Goo00=Nmgoo
Ool05Woo00=NmgooOol04Woo00=NmgooOol04goo00=NmgooOol05Woo00=NmgooOol027oo00<007oo
Ool0A7oo000lOol00`00Oomoo`0ROol00ekgOomoo`0EOol00ekgOomoo`0?Ool00ekgOomoo`0WOol0
0ekgOomoo`02Ool00ekgOomoo`0IOol00ekgOomoo`0FOol00ekgOomoo`0BOol00ekgOomoo`0COol0
0ekgOomoo`0FOol00ekgOomoo`08Ool00`00Oomoo`14Ool003aoo`03001oogoo029oo`03G_Moogoo
01Eoo`03G_Moogoo00moo`03G_Moogoo02Ioo`03G_Moogoo00Aoo`03G_Moogoo01Qoo`03G_Moogoo
01Ioo`03G_Moogoo019oo`03G_Moogoo01=oo`03G_Moogoo01Ioo`03G_Moogoo00Qoo`03001oogoo
04Aoo`00?7oo00<007ooOol08goo00=NmgooOol04goo00=NmgooOol047oo00=NmgooOol09Woo00=N
mgooOol017oo00=NmgooOol067oo00=NmgooOol05Woo00=NmgooOol04Woo00=NmgooOol04goo00=N
mgooOol05Woo00=NmgooOol027oo00<007ooOol0A7oo000lOol00`00Oomoo`0SOol00ekgOomoo`0B
Ool00ekgOomoo`0BOol00ekgOomoo`0TOol00ekgOomoo`06Ool00ekgOomoo`0FOol00ekgOomoo`0G
Ool00ekgOomoo`0BOol00ekgOomoo`0COol00ekgOomoo`0GOol00ekgOomoo`07Ool00`00Oomoo`14
Ool003aoo`8002Aoo`03G_Moogoo015oo`03G_Moogoo01=oo`03G_Moogoo02Aoo`03G_Moogoo00Io
o`03G_Moogoo01Ioo`03G_Moogoo01Moo`03G_Moogoo019oo`03G_Moogoo01=oo`03G_Moogoo01Mo
o`03G_Moogoo00Ioo`8004Ioo`00?7oo00<007ooOol08goo00=NmgooOol04Goo00=NmgooOol04goo
00=NmgooOol097oo00=NmgooOol01Woo00=NmgooOol05Woo00=NmgooOol05Woo00=NmgooOol04goo
00=NmgooOol057oo00=NmgooOol05Woo00=NmgooOol01goo00<007ooOol0A7oo000lOol00`00Oomo
o`0SOol00ekgOomoo`0@Ool00ekgOomoo`0DOol00ekgOomoo`0SOol00ekgOomoo`08Ool00ekgOomo
o`0EOol00ekgOomoo`0FOol00ekgOomoo`0COol00ekgOomoo`0DOol00ekgOomoo`0FOol00ekgOomo
o`07Ool00`00Oomoo`14Ool003aoo`03001oogoo00moo`03001oogoo019oo`03G_Moogoo00aoo`03
001ooekg01Qoo`03G_Moogoo00Moo`03001oogoo01Qoo`03G_Moogoo00Ioo`03001ooekg01Ioo`03
G_Moogoo00Uoo`03001oogoo00]oo`03G_Moogoo01=oo`03G_Moogoo01Aoo`03G_Moogoo00]oo`03
001oogoo00Uoo`03G_Moogoo00Ioo`03001oogoo04Aoo`00?7oo00<007ooOol01Woo00<007ooOol0
1Woo00<007ooOol01Woo00<007ooOol01Woo00@007ooOomNm`Eoo`03001oogoo00Ioo`03001ooekg
00Moo`03001oogoo00Ioo`03001oogoo00Eoo`03G_L007oo00Moo`03001oogoo00Ioo`03001oogoo
00Ioo`03001oogoo00Eoo`03G_L007oo00Moo`04001oogooG_L6Ool00`00Oomoo`06Ool00`00Oomo
o`03Ool015kgOomoo`0027oo00<007ooOol01Woo00<007ooOol00Woo00ENmgooOomoo`0000Qoo`03
001oogoo00Ioo`03G_Moogoo00Ioo`03001oogoo00Moo`05001oogooOomNm`04Ool00`00Oomoo`06
Ool00`00Oomoo`06Ool01000Oomooekg1Goo00@007ooOol004Ioo`00?7oo9`0000=Nm`0000003@00
00=Nm`0000005`0000=Nm`0000008@0000=Nm`0000002P0000=Nm`0000004`0000=Nm`0000005`00
00=Nm`0000004`0000=Nm`000000500000=Nm`0000005`0000=Nm`0000001`00AWoo003oOon6Ool0
0?moohIoo`00ogooQWoo003oOon6Ool00?moohIoo`00ogooQWoo003oOon6Ool00?moohIoo`00ogoo
QWoo003oOon6Ool00?moohIoo`00ogooQWoo003oOon6Ool00?moohIoo`00ogooQWoo003oOon6Ool0
0?moohIoo`00PGoo00<007ooOol05Woo00<007ooOol02Goo00<007ooOol0;7oo00<007ooOol02Goo
00<007ooOol0=7oo00<007ooOol0JWoo0020Ool00`00Oomoo`0;Ool00`00Oomoo`0:Ool00`00Oomo
o`07Ool00`00Oomoo`0@Ool00`00Oomoo`0>Ool00`00Oomoo`0:Ool00`00Oomoo`07Ool00`00Oomo
o`0@Ool00`00Oomoo`0FOol00`00Oomoo`0:Ool00`00Oomoo`1YOol007moo`03001oogoo009oo`<0
00Moo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo009oo`<000aoo`03
001oogoo00=oo`<000Qoo`03001oogoo009oo`D000Aoo`03001oogoo00Eoo`03001oogoo009oo`<0
00aoo`03001oogoo00=oo`<000Ioo`<000Moo`03001oogoo00=oo`<000Eoo`03001oogoo06Qoo`00
Ogoo00<007ooOol017oo0P0017oo1@000goo00<007oo00001Goo00<007ooOol01Goo00<007ooOol0
17oo0P002Goo1@001Goo0P001Goo1@0017oo00<007ooOol017oo00<007ooOol01Goo00<007ooOol0
17oo0P002Goo1@000goo00<007ooOol027oo0P0017oo1@000goo00<007ooOol01Goo00<007ooOol0
J7oo001oOol00`00Oomoo`03Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`03Ool00`00
Oomoo`05Ool00`00Oomoo`03Ool00`00Oomoo`02Ool30006Ool00`00Oomoo`04Ool00`00Oomoo`07
Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`03Ool00`00Oomoo`02
Ool30006Ool00`00Oomoo`04Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`04Ool00`00
Oomoo`04Ool00`00Oomoo`1XOol007moo`03001oogoo00=oo`<000Ioo`03001oogoo00=oo`8000Io
o`03001oogoo00Eoo`03001oogoo00=oo`<0009oo`8000Moo`03001oogoo00Aoo`<000Moo`03001o
ogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00=oo`<0009oo`8000Moo`03001o
ogoo00Aoo`03001oogoo00Ioo`<000Ioo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo06Qo
o`00HWoo0P0027oo0P004Woo00<007ooOol04Goo00<007ooOol017oo00<007ooOol01goo00<007oo
Ool02Goo00<007ooOol077oo00<007ooOol00goo00<007ooOol01goo00<007ooOol02Goo00<007oo
Ool02Woo00<007oo00005Woo00<007oo000017oo00<007ooOol0JGoo001ROol00`00Oomoo`08Ool0
0`00Oomoo`0AOol00`00Oomoo`0@Ool30003Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomo
o`0KOol20004Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`0;Ool00`00Oomoo`0FOol0
0`00Oomoo`02Ool00`00Oomoo`1ZOol005]oo`8000Eoo`04001oogooOol20005Ool00`00Oomoo`02
Ool4000iOol3000hOol3002HOol005Yoo`03001oo`0000Eoo`03001oogoo00=oo`03001oogoo009o
o`03001oogoo00]ooj@006Ioo`00FWoo00@007oo000000Aoo`03001oogoo009oo`03001oogoo00=o
o`03001oogoo009oo`@00?mooa1oo`00FWoo00<007ooOol01Goo00<007ooOol00Woo0P0017oo00<0
07ooOol0ogoo5Woo001JOol00`00Oomoo`05Ool00`00Oomoo`08Ool00`00Oomoo`0jOol00`00Oomo
o`0GOol00`00Oomoo`08Ool00`00Oomoo`0MOol00`00Oomoo`2COol005Yoo`<000Eoo`8000Qoo`80
03]oo`03001oogoo00]oo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo00aoo`03001oogoo
011oo`03001oogoo099oo`00Z7oo00<007ooOol00Woo0`001goo00<007ooOol01Goo0`0017oo00<0
07ooOol017oo00<007ooOol00Woo0`0027oo00<007ooOol00Woo1@000Woo00<007ooOol01Goo00<0
07ooOol0TGoo002XOol00`00Oomoo`04Ool20004Ool50006Ool00`00Oomoo`03Ool00`00Oomoo`04
Ool00`00Oomoo`04Ool20005Ool50004Ool01`00Oomoogoo001oo`0000Ioo`03001oogoo095oo`00
Z7oo00<007ooOol00goo00<007ooOol01Woo00<007ooOol017oo100017oo00<007ooOol017oo00<0
07ooOol00goo00<007ooOol01goo00<007ooOol017oo00L007ooOomoo`00Ool00006Ool00`00Oomo
o`2AOol00:Qoo`03001oogoo00=oo`<000Ioo`03001oogoo00Aoo`03001oo`0000Eoo`03001oogoo
00Aoo`03001oogoo00=oo`<000Moo`03001oogoo00Aoo`07001oogooOol007oo00001Woo00<007oo
Ool0TGoo002YOol00`00Oomoo`0COol20004Ool00`00Oomoo`06Ool00`00Oomoo`0COol01`00Oomo
ogoo001oo`0000Eoo`03001oogoo099oo`00ZWoo00<007ooOol04goo00D007ooOomoo`0000Yoo`03
001oogoo015oo`8000Aoo`03001oogoo00=oo`03001oogoo09=oo`00ogooQWoo003oOon6Ool00?mo
ohIoo`00ogooQWoo003oOon6Ool00?moohIoo`00ogooQWoo003oOon6Ool00?moohIoo`00ogooQWoo
003oOon6Ool00?moohIoo`00ogooQWoo003oOon6Ool00?moohIoo`00ogooQWoo003oOon6Ool00?mo
ohIoo`00ogooQWoo003oOon6Ool00?moohIoo`00ogooQWoo003oOon6Ool00?moohIoo`00ogooQWoo
003oOon6Ool00?moohIoo`00ogooQWoo003oOon6Ool00?moohIoo`00ogooQWoo003oOon6Ool00?mo
ohIoo`00ogooQWoo0000\
\>"],
  ImageRangeCache->{{{0, 388.188}, {547.875, 0}} -> {-0.653492, -1.05073, \
0.00383565, 0.00383565}, {{9.1875, 331.5}, {534.625, 13.1875}} -> {-14.3065, \
-5.88265, 0.0548558, 0.0220169}, {{352.813, 378.938}, {404.25, 273.938}} -> \
{-27.6386, -44.1511, 0.0782742, 0.307265}},
  CellTags->{"Root Locus", "i:11"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[118]=",
  CellTags->{"Root Locus", "i:11"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(G[s_] := \(\((s + 10)\)\ \((s + 4)\)\)\/\(s\ \((s + 5)\)\ \((s + 2)\)\ \
\((s\^2 +  .2\ s + 2)\)\ \((s\^2 + 1\ s + 1)\)\)\), "\n", 
    \(RootLocus[G, s, k, 0, \(+40. \), 1. ]\)}], "Input",
  CellLabel->"In[119]:=",
  CellTags->{"Root Locus", "i:11"}],

Cell[BoxData[
    \(\*"\"\<\\n                Zeros in green, Open loop poles in red\>"\)], \
"Print",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Root Locus", "i:11"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.4104 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.438894 0.671621 0.705202 0.671621 [
[ 0 0 0 0 ]
[ 1 1.4104 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.0238095 0.033581 0.853978 1.37682 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.803899 0.0730817 0.809017 0.218073 [
[.07308 -0.0125 -9 -9 ]
[.07308 -0.0125 9 0 ]
[.21925 -0.0125 -6 -9 ]
[.21925 -0.0125 6 0 ]
[.36541 -0.0125 -6 -9 ]
[.36541 -0.0125 6 0 ]
[.51157 -0.0125 -6 -9 ]
[.51157 -0.0125 6 0 ]
[.65774 -0.0125 -6 -9 ]
[.65774 -0.0125 6 0 ]
[.8039 -0.0125 -3 -9 ]
[.8039 -0.0125 3 0 ]
[.95006 -0.0125 -3 -9 ]
[.95006 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -17 -21.875 ]
[.5 -0.0125 17 -9 ]
[-0.0125 .1548 -12 -4.5 ]
[-0.0125 .1548 0 4.5 ]
[-0.0125 .37287 -12 -4.5 ]
[-0.0125 .37287 0 4.5 ]
[-0.0125 .59094 -12 -4.5 ]
[-0.0125 .59094 0 4.5 ]
[-0.0125 .80902 -6 -4.5 ]
[-0.0125 .80902 0 4.5 ]
[-0.0125 1.02709 -6 -4.5 ]
[-0.0125 1.02709 0 4.5 ]
[-0.0125 1.24516 -6 -4.5 ]
[-0.0125 1.24516 0 4.5 ]
[-0.0125 1.46324 -6 -4.5 ]
[-0.0125 1.46324 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .80902 -46.25 -6.4375 ]
[-0.01875 .80902 -12 6.4375 ]
[ 0 1.61803 .125 0 ]
[.5 1.63053 -5 0 ]
[.5 1.63053 5 12.875 ]
[ 1 0 .125 0 ]
[1.0125 .80902 0 -6.4375 ]
[1.0125 .80902 10 6.4375 ]
[.5 1.63053 -130.781 12.875 ]
[.5 1.63053 130.781 35.4375 ]
[ 0 0 0 0 ]
[ 1 1.61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.07308 0 m
.07308 .00625 L
s
[(-10)] .07308 -0.0125 0 1 Mshowa
.21925 0 m
.21925 .00625 L
s
[(-8)] .21925 -0.0125 0 1 Mshowa
.36541 0 m
.36541 .00625 L
s
[(-6)] .36541 -0.0125 0 1 Mshowa
.51157 0 m
.51157 .00625 L
s
[(-4)] .51157 -0.0125 0 1 Mshowa
.65774 0 m
.65774 .00625 L
s
[(-2)] .65774 -0.0125 0 1 Mshowa
.8039 0 m
.8039 .00625 L
s
[(0)] .8039 -0.0125 0 1 Mshowa
.95006 0 m
.95006 .00625 L
s
[(2)] .95006 -0.0125 0 1 Mshowa
.125 Mabswid
.10962 0 m
.10962 .00375 L
s
.14616 0 m
.14616 .00375 L
s
.1827 0 m
.1827 .00375 L
s
.25579 0 m
.25579 .00375 L
s
.29233 0 m
.29233 .00375 L
s
.32887 0 m
.32887 .00375 L
s
.40195 0 m
.40195 .00375 L
s
.43849 0 m
.43849 .00375 L
s
.47503 0 m
.47503 .00375 L
s
.54811 0 m
.54811 .00375 L
s
.58465 0 m
.58465 .00375 L
s
.62119 0 m
.62119 .00375 L
s
.69428 0 m
.69428 .00375 L
s
.73082 0 m
.73082 .00375 L
s
.76736 0 m
.76736 .00375 L
s
.84044 0 m
.84044 .00375 L
s
.87698 0 m
.87698 .00375 L
s
.91352 0 m
.91352 .00375 L
s
.03654 0 m
.03654 .00375 L
s
.9866 0 m
.9866 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -78 -25.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Re) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
75.000000 13.000000 moveto
(@) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
87.000000 13.000000 moveto
(D) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
0 .1548 m
.00625 .1548 L
s
[(-3)] -0.0125 .1548 1 0 Mshowa
0 .37287 m
.00625 .37287 L
s
[(-2)] -0.0125 .37287 1 0 Mshowa
0 .59094 m
.00625 .59094 L
s
[(-1)] -0.0125 .59094 1 0 Mshowa
0 .80902 m
.00625 .80902 L
s
[(0)] -0.0125 .80902 1 0 Mshowa
0 1.02709 m
.00625 1.02709 L
s
[(1)] -0.0125 1.02709 1 0 Mshowa
0 1.24516 m
.00625 1.24516 L
s
[(2)] -0.0125 1.24516 1 0 Mshowa
0 1.46324 m
.00625 1.46324 L
s
[(3)] -0.0125 1.46324 1 0 Mshowa
.125 Mabswid
0 .19841 m
.00375 .19841 L
s
0 .24203 m
.00375 .24203 L
s
0 .28564 m
.00375 .28564 L
s
0 .32926 m
.00375 .32926 L
s
0 .41649 m
.00375 .41649 L
s
0 .4601 m
.00375 .4601 L
s
0 .50371 m
.00375 .50371 L
s
0 .54733 m
.00375 .54733 L
s
0 .63456 m
.00375 .63456 L
s
0 .67817 m
.00375 .67817 L
s
0 .72179 m
.00375 .72179 L
s
0 .7654 m
.00375 .7654 L
s
0 .85263 m
.00375 .85263 L
s
0 .89625 m
.00375 .89625 L
s
0 .93986 m
.00375 .93986 L
s
0 .98348 m
.00375 .98348 L
s
0 1.0707 m
.00375 1.0707 L
s
0 1.11432 m
.00375 1.11432 L
s
0 1.15793 m
.00375 1.15793 L
s
0 1.20155 m
.00375 1.20155 L
s
0 1.28878 m
.00375 1.28878 L
s
0 1.33239 m
.00375 1.33239 L
s
0 1.37601 m
.00375 1.37601 L
s
0 1.41962 m
.00375 1.41962 L
s
0 .11118 m
.00375 .11118 L
s
0 .06757 m
.00375 .06757 L
s
0 .02395 m
.00375 .02395 L
s
0 1.50685 m
.00375 1.50685 L
s
0 1.55047 m
.00375 1.55047 L
s
0 1.59408 m
.00375 1.59408 L
s
.25 Mabswid
0 0 m
0 1.61803 L
s
gsave
-0.01875 .80902 -107.25 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Im) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
75.250000 13.000000 moveto
(@) show
81.250000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
87.250000 13.000000 moveto
(D) show
93.250000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
.07308 1.61178 m
.07308 1.61803 L
s
.21925 1.61178 m
.21925 1.61803 L
s
.36541 1.61178 m
.36541 1.61803 L
s
.51157 1.61178 m
.51157 1.61803 L
s
.65774 1.61178 m
.65774 1.61803 L
s
.8039 1.61178 m
.8039 1.61803 L
s
.95006 1.61178 m
.95006 1.61803 L
s
.125 Mabswid
.10962 1.61428 m
.10962 1.61803 L
s
.14616 1.61428 m
.14616 1.61803 L
s
.1827 1.61428 m
.1827 1.61803 L
s
.25579 1.61428 m
.25579 1.61803 L
s
.29233 1.61428 m
.29233 1.61803 L
s
.32887 1.61428 m
.32887 1.61803 L
s
.40195 1.61428 m
.40195 1.61803 L
s
.43849 1.61428 m
.43849 1.61803 L
s
.47503 1.61428 m
.47503 1.61803 L
s
.54811 1.61428 m
.54811 1.61803 L
s
.58465 1.61428 m
.58465 1.61803 L
s
.62119 1.61428 m
.62119 1.61803 L
s
.69428 1.61428 m
.69428 1.61803 L
s
.73082 1.61428 m
.73082 1.61803 L
s
.76736 1.61428 m
.76736 1.61803 L
s
.84044 1.61428 m
.84044 1.61803 L
s
.87698 1.61428 m
.87698 1.61803 L
s
.91352 1.61428 m
.91352 1.61803 L
s
.03654 1.61428 m
.03654 1.61803 L
s
.9866 1.61428 m
.9866 1.61803 L
s
.25 Mabswid
0 1.61803 m
1 1.61803 L
s
gsave
.5 1.63053 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
69.000000 13.000000 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.99375 .1548 m
1 .1548 L
s
.99375 .37287 m
1 .37287 L
s
.99375 .59094 m
1 .59094 L
s
.99375 .80902 m
1 .80902 L
s
.99375 1.02709 m
1 1.02709 L
s
.99375 1.24516 m
1 1.24516 L
s
.99375 1.46324 m
1 1.46324 L
s
.125 Mabswid
.99625 .19841 m
1 .19841 L
s
.99625 .24203 m
1 .24203 L
s
.99625 .28564 m
1 .28564 L
s
.99625 .32926 m
1 .32926 L
s
.99625 .41649 m
1 .41649 L
s
.99625 .4601 m
1 .4601 L
s
.99625 .50371 m
1 .50371 L
s
.99625 .54733 m
1 .54733 L
s
.99625 .63456 m
1 .63456 L
s
.99625 .67817 m
1 .67817 L
s
.99625 .72179 m
1 .72179 L
s
.99625 .7654 m
1 .7654 L
s
.99625 .85263 m
1 .85263 L
s
.99625 .89625 m
1 .89625 L
s
.99625 .93986 m
1 .93986 L
s
.99625 .98348 m
1 .98348 L
s
.99625 1.0707 m
1 1.0707 L
s
.99625 1.11432 m
1 1.11432 L
s
.99625 1.15793 m
1 1.15793 L
s
.99625 1.20155 m
1 1.20155 L
s
.99625 1.28878 m
1 1.28878 L
s
.99625 1.33239 m
1 1.33239 L
s
.99625 1.37601 m
1 1.37601 L
s
.99625 1.41962 m
1 1.41962 L
s
.99625 .11118 m
1 .11118 L
s
.99625 .06757 m
1 .06757 L
s
.99625 .02395 m
1 .02395 L
s
.99625 1.50685 m
1 1.50685 L
s
.99625 1.55047 m
1 1.55047 L
s
.99625 1.59408 m
1 1.59408 L
s
.25 Mabswid
1 0 m
1 1.61803 L
s
gsave
1.0125 .80902 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
69.000000 13.000000 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.5 1.63053 -191.781 8.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30.5625 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 26.562500 moveto
 460.000000 26.562500 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 26.562500 lineto
closepath
clip newpath
63.000000 17.312500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.312500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(G) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
69.000000 17.312500 moveto
(@) show
75.000000 17.312500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
81.000000 17.312500 moveto
(D) show
87.000000 17.312500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(=) show
93.000000 17.312500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
169.000000 11.250000 moveto
(H) show
175.000000 11.250000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
183.375000 11.250000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
191.750000 11.250000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
197.750000 11.250000 moveto
(L) show
206.375000 11.250000 moveto
(H) show
212.375000 11.250000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
220.750000 11.250000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
229.125000 11.250000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
241.125000 11.250000 moveto
(L) show
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
97.375000 17.312500 moveto
(\\200) show
99.250000 17.312500 moveto
(\\200) show
101.125000 17.312500 moveto
(\\200) show
103.000000 17.312500 moveto
(\\200) show
104.875000 17.312500 moveto
(\\200) show
106.750000 17.312500 moveto
(\\200) show
108.625000 17.312500 moveto
(\\200) show
110.500000 17.312500 moveto
(\\200) show
112.375000 17.312500 moveto
(\\200) show
114.250000 17.312500 moveto
(\\200) show
116.125000 17.312500 moveto
(\\200) show
118.000000 17.312500 moveto
(\\200) show
119.875000 17.312500 moveto
(\\200) show
121.750000 17.312500 moveto
(\\200) show
123.625000 17.312500 moveto
(\\200) show
125.500000 17.312500 moveto
(\\200) show
127.375000 17.312500 moveto
(\\200) show
129.250000 17.312500 moveto
(\\200) show
131.125000 17.312500 moveto
(\\200) show
133.000000 17.312500 moveto
(\\200) show
134.875000 17.312500 moveto
(\\200) show
136.750000 17.312500 moveto
(\\200) show
138.625000 17.312500 moveto
(\\200) show
140.500000 17.312500 moveto
(\\200) show
142.375000 17.312500 moveto
(\\200) show
144.250000 17.312500 moveto
(\\200) show
146.125000 17.312500 moveto
(\\200) show
148.000000 17.312500 moveto
(\\200) show
149.875000 17.312500 moveto
(\\200) show
151.750000 17.312500 moveto
(\\200) show
153.625000 17.312500 moveto
(\\200) show
155.500000 17.312500 moveto
(\\200) show
157.375000 17.312500 moveto
(\\200) show
159.250000 17.312500 moveto
(\\200) show
161.125000 17.312500 moveto
(\\200) show
163.000000 17.312500 moveto
(\\200) show
164.875000 17.312500 moveto
(\\200) show
166.750000 17.312500 moveto
(\\200) show
168.625000 17.312500 moveto
(\\200) show
170.500000 17.312500 moveto
(\\200) show
172.375000 17.312500 moveto
(\\200) show
174.250000 17.312500 moveto
(\\200) show
176.125000 17.312500 moveto
(\\200) show
178.000000 17.312500 moveto
(\\200) show
179.875000 17.312500 moveto
(\\200) show
181.750000 17.312500 moveto
(\\200) show
183.625000 17.312500 moveto
(\\200) show
185.500000 17.312500 moveto
(\\200) show
187.375000 17.312500 moveto
(\\200) show
189.250000 17.312500 moveto
(\\200) show
191.125000 17.312500 moveto
(\\200) show
193.000000 17.312500 moveto
(\\200) show
194.875000 17.312500 moveto
(\\200) show
196.750000 17.312500 moveto
(\\200) show
198.625000 17.312500 moveto
(\\200) show
200.500000 17.312500 moveto
(\\200) show
202.375000 17.312500 moveto
(\\200) show
204.250000 17.312500 moveto
(\\200) show
206.125000 17.312500 moveto
(\\200) show
208.000000 17.312500 moveto
(\\200) show
209.875000 17.312500 moveto
(\\200) show
211.750000 17.312500 moveto
(\\200) show
213.625000 17.312500 moveto
(\\200) show
215.500000 17.312500 moveto
(\\200) show
217.375000 17.312500 moveto
(\\200) show
219.250000 17.312500 moveto
(\\200) show
221.125000 17.312500 moveto
(\\200) show
223.000000 17.312500 moveto
(\\200) show
224.875000 17.312500 moveto
(\\200) show
226.750000 17.312500 moveto
(\\200) show
228.625000 17.312500 moveto
(\\200) show
230.500000 17.312500 moveto
(\\200) show
232.375000 17.312500 moveto
(\\200) show
234.250000 17.312500 moveto
(\\200) show
236.125000 17.312500 moveto
(\\200) show
238.000000 17.312500 moveto
(\\200) show
239.875000 17.312500 moveto
(\\200) show
241.750000 17.312500 moveto
(\\200) show
243.625000 17.312500 moveto
(\\200) show
245.500000 17.312500 moveto
(\\200) show
247.375000 17.312500 moveto
(\\200) show
249.250000 17.312500 moveto
(\\200) show
251.125000 17.312500 moveto
(\\200) show
253.000000 17.312500 moveto
(\\200) show
254.875000 17.312500 moveto
(\\200) show
256.750000 17.312500 moveto
(\\200) show
258.625000 17.312500 moveto
(\\200) show
260.500000 17.312500 moveto
(\\200) show
262.375000 17.312500 moveto
(\\200) show
264.250000 17.312500 moveto
(\\200) show
266.125000 17.312500 moveto
(\\200) show
268.000000 17.312500 moveto
(\\200) show
269.875000 17.312500 moveto
(\\200) show
271.750000 17.312500 moveto
(\\200) show
273.625000 17.312500 moveto
(\\200) show
275.500000 17.312500 moveto
(\\200) show
277.375000 17.312500 moveto
(\\200) show
279.250000 17.312500 moveto
(\\200) show
281.125000 17.312500 moveto
(\\200) show
283.000000 17.312500 moveto
(\\200) show
284.875000 17.312500 moveto
(\\200) show
286.750000 17.312500 moveto
(\\200) show
288.625000 17.312500 moveto
(\\200) show
290.500000 17.312500 moveto
(\\200) show
292.375000 17.312500 moveto
(\\200) show
294.250000 17.312500 moveto
(\\200) show
296.125000 17.312500 moveto
(\\200) show
298.000000 17.312500 moveto
(\\200) show
299.875000 17.312500 moveto
(\\200) show
301.750000 17.312500 moveto
(\\200) show
303.625000 17.312500 moveto
(\\200) show
305.500000 17.312500 moveto
(\\200) show
307.375000 17.312500 moveto
(\\200) show
309.250000 17.312500 moveto
(\\200) show
311.125000 17.312500 moveto
(\\200) show
313.000000 17.312500 moveto
(\\200) show
314.875000 17.312500 moveto
(\\200) show
316.750000 17.312500 moveto
(\\200) show
316.937500 17.312500 moveto
(\\200) show
98.687500 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
107.312500 23.625000 moveto
(H) show
113.312500 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
121.687500 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
130.062500 23.625000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
136.062500 23.625000 moveto
(L) show
144.687500 23.625000 moveto
(H) show
150.687500 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
159.062500 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
167.437500 23.625000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
173.437500 23.625000 moveto
(L) show
182.062500 23.625000 moveto
(H) show
188.062500 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
194.062500 21.062500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
201.000000 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
209.375000 23.625000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
230.000000 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
238.375000 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
246.750000 23.625000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
252.750000 23.625000 moveto
(L) show
261.375000 23.625000 moveto
(H) show
267.375000 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
273.375000 21.062500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
280.312500 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
288.687500 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
297.062500 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
305.437500 23.625000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
311.437500 23.625000 moveto
(L) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier-Italic
%%+ font Math1Mono
%%+ font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier-Italic
%%+ Math1Mono
%%+ Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier-Italic
%%+ font Math1Mono
%%+ font Math2Mono
%%+ font Courier
grestore
0 0 m
1 0 L
1 1.61803 L
0 1.61803 L
closepath
clip
newpath
.75 g
.5 Mabswid
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
1 .96581 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
1 1.14686 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
1 1.39417 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
.96043 1.61803 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
.87655 1.61803 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
.8039 1.61803 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
.73125 1.61803 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
.64737 1.61803 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
.53278 1.61803 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
.3343 1.61803 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
0 1.45178 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
0 .80902 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
0 .16626 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
.3343 0 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
.53278 0 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
.64737 0 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
.73125 0 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
.8039 0 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
.87655 0 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
.96043 0 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
1 .22386 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
1 .47118 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
1 .65222 L
s
.8039 .80902 m
0 0 rlineto s
.8039 .80902 m
1 .80902 L
s
.95006 .80902 m
.94891 .86368 L
.94547 .91748 L
.9398 .96957 L
.93198 1.01913 L
.92215 1.06538 L
.91045 1.10758 L
.89707 1.14507 L
.88222 1.17727 L
.86613 1.20365 L
.84907 1.22382 L
.83129 1.23744 L
.81308 1.2443 L
.79472 1.2443 L
.77651 1.23744 L
.75873 1.22382 L
.74167 1.20365 L
.72558 1.17727 L
.71073 1.14507 L
.69735 1.10758 L
.68565 1.06538 L
.67582 1.01913 L
.668 .96957 L
.66233 .91748 L
.65889 .86368 L
.65774 .80902 L
.65889 .75435 L
.66233 .70055 L
.668 .64846 L
.67582 .5989 L
.68565 .55266 L
.69735 .51045 L
.71073 .47296 L
.72558 .44077 L
.74167 .41438 L
.75873 .39422 L
.77651 .3806 L
.79472 .37373 L
.81308 .37373 L
.83129 .3806 L
.84907 .39422 L
.86613 .41438 L
.88222 .44077 L
.89707 .47296 L
.91045 .51045 L
.92215 .55266 L
.93198 .5989 L
.9398 .64846 L
.94547 .70055 L
.94891 .75435 L
Mistroke
.95006 .80902 L
Mfstroke
1 1.45377 m
.99024 1.48113 L
.96054 1.54552 L
.92837 1.59829 L
s
.92837 1.59829 m
.91166 1.61803 L
s
.69614 1.61803 m
.67943 1.59829 L
.64726 1.54552 L
.61756 1.48113 L
.5908 1.40614 L
.5674 1.32174 L
.54773 1.22925 L
.5321 1.13013 L
.52076 1.02595 L
.51388 .91834 L
.51157 .80902 L
.51388 .69969 L
.52076 .59209 L
.5321 .4879 L
.54773 .38879 L
.5674 .2963 L
.5908 .21189 L
.61756 .1369 L
.64726 .07252 L
.67943 .01974 L
s
.67943 .01974 m
.69614 0 L
s
.91166 0 m
.92837 .01974 L
.96054 .07252 L
.99024 .1369 L
s
.99024 .1369 m
1 .16427 L
s
.46022 1.61803 m
.44915 1.5781 L
.41965 1.43936 L
.3962 1.29069 L
.37918 1.13441 L
.36887 .97301 L
.36541 .80902 L
.36887 .64503 L
.37918 .48362 L
.3962 .32735 L
.41965 .17867 L
.44915 .03994 L
s
.44915 .03994 m
.46022 0 L
s
.2866 1.61803 m
.2603 1.45124 L
.23761 1.24288 L
.22386 1.02767 L
.21925 .80902 L
.22386 .59036 L
.23761 .37516 L
.2603 .16679 L
s
.2603 .16679 m
.2866 0 L
s
.12539 1.61803 m
.1244 1.6118 L
.09604 1.35134 L
.07884 1.08234 L
.07308 .80902 L
.07884 .5357 L
.09604 .26669 L
.1244 .00624 L
s
.1244 .00624 m
.12539 0 L
s
.75 0 0 r
.012 w
.43849 .80902 Mdot
.65774 .80902 Mdot
.76736 .62016 Mdot
.76736 .99787 Mdot
.79659 .50139 Mdot
.79659 1.11665 Mdot
.8039 .80902 Mdot
.75 0 .073 r
.43849 .80902 Mdot
.65774 .80902 Mdot
.76742 .62025 Mdot
.76742 .99778 Mdot
.79657 .50141 Mdot
.79657 1.11662 Mdot
.80381 .80902 Mdot
.75 0 .146 r
.43849 .80902 Mdot
.65779 .80902 Mdot
.76789 .62091 Mdot
.76789 .99712 Mdot
.7964 .50156 Mdot
.7964 1.11647 Mdot
.80316 .80902 Mdot
.75 0 .219 r
.43849 .80902 Mdot
.65793 .80902 Mdot
.76921 .62272 Mdot
.76921 .99531 Mdot
.79593 .50196 Mdot
.79593 1.11607 Mdot
.80132 .80902 Mdot
.75 0 .292 r
.43849 .80902 Mdot
.65821 .80902 Mdot
.77204 .62632 Mdot
.77204 .99172 Mdot
.79497 .50261 Mdot
.79497 1.11542 Mdot
.79731 .80902 Mdot
.75 0 .366 r
.43849 .80902 Mdot
.65867 .80902 Mdot
.77751 .63195 Mdot
.77751 .98608 Mdot
.78931 .80902 Mdot
.79327 .5032 Mdot
.79327 1.11483 Mdot
.75 0 .439 r
.4385 .80902 Mdot
.65939 .80902 Mdot
.77471 .80902 Mdot
.78712 .6365 Mdot
.78712 .98154 Mdot
.7906 .50259 Mdot
.7906 1.11544 Mdot
.75 0 .512 r
.4385 .80902 Mdot
.66045 .80902 Mdot
.75681 .80902 Mdot
.78722 .49878 Mdot
.78722 1.11926 Mdot
.79891 .63372 Mdot
.79891 .98431 Mdot
.75 0 .585 r
.4385 .80902 Mdot
.66201 .80902 Mdot
.74112 .80902 Mdot
.78396 .49142 Mdot
.78396 1.12662 Mdot
.80923 .6277 Mdot
.80923 .99033 Mdot
.75 0 .658 r
.43851 .80902 Mdot
.66433 .80902 Mdot
.7272 .80902 Mdot
.78127 .48211 Mdot
.78127 1.13592 Mdot
.81773 .62174 Mdot
.81773 .9963 Mdot
.75 0 .731 r
.43852 .80902 Mdot
.66802 .80902 Mdot
.7135 .80902 Mdot
.77907 .47208 Mdot
.77907 1.14595 Mdot
.82493 .61608 Mdot
.82493 1.00195 Mdot
.696 0 .75 r
.43853 .80902 Mdot
.67564 .80902 Mdot
.69691 .80902 Mdot
.77724 .46185 Mdot
.77724 1.15618 Mdot
.83123 .61062 Mdot
.83123 1.00741 Mdot
.623 0 .75 r
.43854 .80902 Mdot
.68216 .76229 Mdot
.68216 .85574 Mdot
.77568 .45162 Mdot
.77568 1.16641 Mdot
.8369 .6053 Mdot
.8369 1.01274 Mdot
.549 0 .75 r
.43855 .80902 Mdot
.67833 .73778 Mdot
.67833 .88025 Mdot
.77431 .44149 Mdot
.77431 1.17654 Mdot
.84209 .60007 Mdot
.84209 1.01796 Mdot
.476 0 .75 r
.43857 .80902 Mdot
.67472 .72106 Mdot
.67472 .89698 Mdot
.77309 .4315 Mdot
.77309 1.18653 Mdot
.84691 .59493 Mdot
.84691 1.02311 Mdot
.403 0 .75 r
.43858 .80902 Mdot
.67129 .70794 Mdot
.67129 .9101 Mdot
.772 .42166 Mdot
.772 1.19637 Mdot
.85144 .58986 Mdot
.85144 1.02818 Mdot
.33 0 .75 r
.4386 .80902 Mdot
.66801 .697 Mdot
.66801 .92104 Mdot
.77099 .41198 Mdot
.77099 1.20605 Mdot
.85571 .58485 Mdot
.85571 1.03318 Mdot
.257 0 .75 r
.43863 .80902 Mdot
.66485 .68755 Mdot
.66485 .93048 Mdot
.77007 .40247 Mdot
.77007 1.21557 Mdot
.85978 .57991 Mdot
.85978 1.03812 Mdot
.184 0 .75 r
.43865 .80902 Mdot
.66181 .6792 Mdot
.66181 .93883 Mdot
.76921 .39311 Mdot
.76921 1.22493 Mdot
.86366 .57504 Mdot
.86366 1.043 Mdot
.111 0 .75 r
.43868 .80902 Mdot
.65887 .67169 Mdot
.65887 .94634 Mdot
.76841 .3839 Mdot
.76841 1.23414 Mdot
.8674 .57022 Mdot
.8674 1.04781 Mdot
.038 0 .75 r
.43871 .80902 Mdot
.65601 .66485 Mdot
.65601 .95318 Mdot
.76765 .37484 Mdot
.76765 1.24319 Mdot
.87099 .56546 Mdot
.87099 1.05257 Mdot
0 .036 .75 r
.43875 .80902 Mdot
.65324 .65857 Mdot
.65324 .95947 Mdot
.76693 .36593 Mdot
.76693 1.25211 Mdot
.87446 .56076 Mdot
.87446 1.05728 Mdot
0 .109 .75 r
.43879 .80902 Mdot
.65054 .65274 Mdot
.65054 .96529 Mdot
.76625 .35715 Mdot
.76625 1.26088 Mdot
.87783 .55611 Mdot
.87783 1.06192 Mdot
0 .182 .75 r
.43883 .80902 Mdot
.6479 .64731 Mdot
.6479 .97072 Mdot
.7656 .34852 Mdot
.7656 1.26952 Mdot
.88109 .55152 Mdot
.88109 1.06651 Mdot
0 .255 .75 r
.43888 .80902 Mdot
.64533 .64222 Mdot
.64533 .97582 Mdot
.76498 .34001 Mdot
.76498 1.27803 Mdot
.88427 .54698 Mdot
.88427 1.07106 Mdot
0 .328 .75 r
.43893 .80902 Mdot
.64281 .63742 Mdot
.64281 .98062 Mdot
.76438 .33162 Mdot
.76438 1.28641 Mdot
.88736 .54249 Mdot
.88736 1.07554 Mdot
0 .401 .75 r
.43898 .80902 Mdot
.64034 .63288 Mdot
.64034 .98515 Mdot
.76381 .32336 Mdot
.76381 1.29468 Mdot
.89037 .53805 Mdot
.89037 1.07999 Mdot
0 .474 .75 r
.43904 .80902 Mdot
.63793 .62858 Mdot
.63793 .98946 Mdot
.76325 .31521 Mdot
.76325 1.30283 Mdot
.89332 .53366 Mdot
.89332 1.08438 Mdot
0 .548 .75 r
.4391 .80902 Mdot
.63555 .62448 Mdot
.63555 .99355 Mdot
.76271 .30717 Mdot
.76271 1.31087 Mdot
.8962 .52931 Mdot
.8962 1.08872 Mdot
0 .621 .75 r
.43917 .80902 Mdot
.63322 .62058 Mdot
.63322 .99746 Mdot
.76219 .29924 Mdot
.76219 1.3188 Mdot
.89902 .52501 Mdot
.89902 1.09302 Mdot
0 .694 .75 r
.43924 .80902 Mdot
.63093 .61684 Mdot
.63093 1.00119 Mdot
.76168 .29141 Mdot
.76168 1.32662 Mdot
.90178 .52076 Mdot
.90178 1.09728 Mdot
0 .75 .733 r
.43932 .80902 Mdot
.62868 .61327 Mdot
.62868 1.00477 Mdot
.76118 .28368 Mdot
.76118 1.33435 Mdot
.90449 .51654 Mdot
.90449 1.10149 Mdot
0 .75 .66 r
.43941 .80902 Mdot
.62646 .60984 Mdot
.62646 1.0082 Mdot
.7607 .27605 Mdot
.7607 1.34199 Mdot
.90715 .51237 Mdot
.90715 1.10566 Mdot
0 .75 .587 r
.4395 .80902 Mdot
.62428 .60654 Mdot
.62428 1.01149 Mdot
.76023 .26851 Mdot
.76023 1.34953 Mdot
.90976 .50824 Mdot
.90976 1.10979 Mdot
0 .75 .514 r
.43959 .80902 Mdot
.62212 .60337 Mdot
.62212 1.01467 Mdot
.75977 .26106 Mdot
.75977 1.35698 Mdot
.91233 .50415 Mdot
.91233 1.11388 Mdot
0 .75 .441 r
.43969 .80902 Mdot
.62 .60031 Mdot
.62 1.01772 Mdot
.75931 .25369 Mdot
.75931 1.36434 Mdot
.91485 .5001 Mdot
.91485 1.11794 Mdot
0 .75 .367 r
.4398 .80902 Mdot
.6179 .59736 Mdot
.6179 1.02067 Mdot
.75887 .24641 Mdot
.75887 1.37162 Mdot
.91734 .49608 Mdot
.91734 1.12195 Mdot
0 .75 .294 r
.43991 .80902 Mdot
.61583 .59452 Mdot
.61583 1.02352 Mdot
.75844 .23921 Mdot
.75844 1.37882 Mdot
.91979 .4921 Mdot
.91979 1.12593 Mdot
0 .75 .221 r
.44003 .80902 Mdot
.61379 .59176 Mdot
.61379 1.02627 Mdot
.75801 .23209 Mdot
.75801 1.38594 Mdot
.9222 .48816 Mdot
.9222 1.12987 Mdot
0 .75 .148 r
.44016 .80902 Mdot
.61177 .5891 Mdot
.61177 1.02893 Mdot
.75759 .22505 Mdot
.75759 1.39299 Mdot
.92457 .48425 Mdot
.92457 1.13378 Mdot
0 .75 .075 r
.44029 .80902 Mdot
.60977 .58653 Mdot
.60977 1.03151 Mdot
.75718 .21807 Mdot
.75718 1.39996 Mdot
.92692 .48038 Mdot
.92692 1.13766 Mdot
0 1 0 r
.0125 w
.07308 .80902 Mdot
.51157 .80902 Mdot
1 0 0 r
.43849 .80902 Mdot
.65774 .80902 Mdot
.76736 .62016 Mdot
.76736 .99787 Mdot
.79659 .50139 Mdot
.79659 1.11665 Mdot
.8039 .80902 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.909028 0.369391 0.97619 0.705202 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.00980392 0.490196 0.0024975 0.124875 [
[ 0 0 0 0 ]
[ 1 5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 5 L
0 5 L
closepath
clip
newpath
.75 0 0 r
.0098 .0025 m
.0098 .12737 L
.5 .12737 L
.5 .0025 L
F
0 g
gsave
.52451 .06494 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.75 0 .075 r
.0098 .12737 m
.0098 .25225 L
.5 .25225 L
.5 .12737 L
F
.75 0 .15 r
.0098 .25225 m
.0098 .37712 L
.5 .37712 L
.5 .25225 L
F
.75 0 .225 r
.0098 .37712 m
.0098 .502 L
.5 .502 L
.5 .37712 L
F
.75 0 .3 r
.0098 .502 m
.0098 .62687 L
.5 .62687 L
.5 .502 L
F
.75 0 .375 r
.0098 .62687 m
.0098 .75175 L
.5 .75175 L
.5 .62687 L
F
.75 0 .45 r
.0098 .75175 m
.0098 .87662 L
.5 .87662 L
.5 .75175 L
F
.75 0 .525 r
.0098 .87662 m
.0098 1.0015 L
.5 1.0015 L
.5 .87662 L
F
.75 0 .6 r
.0098 1.0015 m
.0098 1.12637 L
.5 1.12637 L
.5 1.0015 L
F
.75 0 .675 r
.0098 1.12637 m
.0098 1.25125 L
.5 1.25125 L
.5 1.12637 L
F
.75 0 .75 r
.0098 1.25125 m
.0098 1.37612 L
.5 1.37612 L
.5 1.25125 L
F
.675 0 .75 r
.0098 1.37612 m
.0098 1.501 L
.5 1.501 L
.5 1.37612 L
F
.6 0 .75 r
.0098 1.501 m
.0098 1.62587 L
.5 1.62587 L
.5 1.501 L
F
.525 0 .75 r
.0098 1.62587 m
.0098 1.75075 L
.5 1.75075 L
.5 1.62587 L
F
.45 0 .75 r
.0098 1.75075 m
.0098 1.87562 L
.5 1.87562 L
.5 1.75075 L
F
.375 0 .75 r
.0098 1.87562 m
.0098 2.0005 L
.5 2.0005 L
.5 1.87562 L
F
.3 0 .75 r
.0098 2.0005 m
.0098 2.12537 L
.5 2.12537 L
.5 2.0005 L
F
.225 0 .75 r
.0098 2.12537 m
.0098 2.25025 L
.5 2.25025 L
.5 2.12537 L
F
.15 0 .75 r
.0098 2.25025 m
.0098 2.37512 L
.5 2.37512 L
.5 2.25025 L
F
.075 0 .75 r
.0098 2.37512 m
.0098 2.5 L
.5 2.5 L
.5 2.37512 L
F
0 0 .75 r
.0098 2.5 m
.0098 2.62488 L
.5 2.62488 L
.5 2.5 L
F
0 .075 .75 r
.0098 2.62488 m
.0098 2.74975 L
.5 2.74975 L
.5 2.62488 L
F
0 .15 .75 r
.0098 2.74975 m
.0098 2.87463 L
.5 2.87463 L
.5 2.74975 L
F
0 .225 .75 r
.0098 2.87463 m
.0098 2.9995 L
.5 2.9995 L
.5 2.87463 L
F
0 .3 .75 r
.0098 2.9995 m
.0098 3.12438 L
.5 3.12438 L
.5 2.9995 L
F
0 .375 .75 r
.0098 3.12438 m
.0098 3.24925 L
.5 3.24925 L
.5 3.12438 L
F
0 .45 .75 r
.0098 3.24925 m
.0098 3.37413 L
.5 3.37413 L
.5 3.24925 L
F
0 .525 .75 r
.0098 3.37413 m
.0098 3.499 L
.5 3.499 L
.5 3.37413 L
F
0 .6 .75 r
.0098 3.499 m
.0098 3.62388 L
.5 3.62388 L
.5 3.499 L
F
0 .675 .75 r
.0098 3.62388 m
.0098 3.74875 L
.5 3.74875 L
.5 3.62388 L
F
0 .75 .75 r
.0098 3.74875 m
.0098 3.87363 L
.5 3.87363 L
.5 3.74875 L
F
0 .75 .675 r
.0098 3.87363 m
.0098 3.9985 L
.5 3.9985 L
.5 3.87363 L
F
0 .75 .6 r
.0098 3.9985 m
.0098 4.12338 L
.5 4.12338 L
.5 3.9985 L
F
0 .75 .525 r
.0098 4.12338 m
.0098 4.24825 L
.5 4.24825 L
.5 4.12338 L
F
0 .75 .45 r
.0098 4.24825 m
.0098 4.37313 L
.5 4.37313 L
.5 4.24825 L
F
0 .75 .375 r
.0098 4.37313 m
.0098 4.498 L
.5 4.498 L
.5 4.37313 L
F
0 .75 .3 r
.0098 4.498 m
.0098 4.62288 L
.5 4.62288 L
.5 4.498 L
F
0 .75 .225 r
.0098 4.62288 m
.0098 4.74775 L
.5 4.74775 L
.5 4.62288 L
F
0 .75 .15 r
.0098 4.74775 m
.0098 4.87263 L
.5 4.87263 L
.5 4.74775 L
F
0 .75 .075 r
.0098 4.87263 m
.0098 4.9975 L
.5 4.9975 L
.5 4.87263 L
F
0 g
gsave
.52451 4.93506 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(40.) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 1.4104 L
0 1.4104 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[119]:=",
  ImageSize->{382.188, 539.063},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005n00026a000`40O003h00OogooOgoo003oOomo
Ool00?moogmoo`00ogooOgoo003oOomoOol00?moogmoo`00ogooOgoo003oOomoOol00?moogmoo`00
ogooOgoo003oOomoOol00?moogmoo`00ogooOgoo003oOomoOol00?moogmoo`00ogooOgoo003oOomo
Ool00?moogmoo`00ogooOgoo003oOomoOol00?moogmoo`00ogooOgoo003oOomoOol00?moogmoo`00
ogooOgoo003oOomoOol00?moogmoo`00ogooOgoo003oOomoOol00?moogmoo`00ogooOgoo003oOomo
Ool00?moogmoo`00ogooOgoo003oOomoOol00?moogmoo`00^Woo0P0027oo0P00^7oo002jOol00`00
Oomoo`08Ool00`00Oomoo`2fOol00:]oo`<00004Ool007ooOol20006Ool01000Oomoogoo0P001Goo
00<007ooOol0]Woo002/Ool01P00Oomoo`00Ool000Qoo`03001oogoo00=oo`03001oogoo009oo`03
001oogoo0;Ioo`00[7oo0`000Woo0`001Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol0
]Woo002/Ool01@00Oomoo`00Ool00`001Woo00<007ooOol00Woo0P0017oo00<007ooOol0]Woo002/
Ool01000Oomoo`002Woo00<007ooOol027oo00<007ooOol0]Woo002[Ool4000;Ool20008Ool2002h
Ool00?moogmoo`00ogooOgoo003oOomoOol004]oo`D0009oo`03001oogoo021oo`03001oogoo025o
o`8002Aoo`<0021oo`<0025oo`03001oogoo025oo`<0055oo`00CGoo00L007ooOomoo`00Ool0000P
Ool00`00Ool0000ROol00`00Ool0000TOol00`00Oomoo`0OOol00`00Oomoo`0POol00`00Ool0000R
Ool00`00Oomoo`1AOol004Moo`<000=oo`07001oogooOol007oo00006goo0`000Woo00<007oo0000
7Goo0`000Woo00<007oo00007Goo0`000Woo10006goo0`000goo00<007ooOol07goo00<007oo0000
8goo00<007ooOol0D7oo001=Ool01`00Oomoogoo001oo`00025oo`03001oogoo025oo`8002=oo`03
001oo`00029oo`03001oogoo01moo`03001oo`0002=oo`03001oogoo051oo`00CGoo00L007ooOomo
o`00Ool0000POol00`00Ool0000ROol00`00Oomoo`0SOol2000QOol00`00Ool0000POol00`00Ool0
000ROol00`00Ool0001AOol004aoo`8000Aoo`03001oogoo021oo`03001oogoo029oo`8002Aoo`03
001oogoo021oo`03001oogoo021oo`03001oogoo029oo`03001oogoo051oo`00ogooOgoo003oOomo
Ool00?moogmoo`00ogooOgoo003oOomoOol00?moogmoo`00?7oo7`0000=Nm`0000009P0000=Nm`00
00002@0000=Nm`0000007@0000=Nm`0000003`0000=Nm`0000006P0000=Nm`0000002@0000=Nm`00
00001P0000=Nm`0000003`0000=Nm`000000400000=Nm`0000001P0000=Nm`0000002@0000=Nm`00
00002000AGoo000lOol00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool01@00Oomoogoo
G_L017oo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01Woo00<007ooOol01Goo00=Nm`00
Ool027oo00<007ooG_L01Woo00<007ooOol01Woo00<007ooOol01Woo00<007ooOol00goo00ANmgoo
Ool000Uoo`03001oogoo009oo`05G_MoogooOol00008Ool00`00Oomoo`06Ool00`00Oomoo`04Ool0
0ekgOol00008Ool00ekg001oo`07Ool00ekgOomoo`06Ool00`00Oomoo`06Ool00ekgOomoo`07Ool0
0`00Oomoo`06Ool00ekgOomoo`06Ool00`00G_Moo`06Ool01000Oomooekg1Goo00D007ooOomoo`00
04Eoo`00?7oo00<007ooOol077oo00=NmgooOol09Woo00=NmgooOol02Woo00=NmgooOol06goo00=N
mgooOol04Goo00=NmgooOol06Goo00=NmgooOol01goo00=NmgooOol027oo00=NmgooOol03goo00=N
mgooOol047oo00=NmgooOol027oo00=NmgooOol01goo00=NmgooOol01goo00<007ooOol0@goo000l
Ool00`00Oomoo`0LOol00ekgOomoo`0UOol00ekgOomoo`0<Ool00ekgOomoo`0JOol00ekgOomoo`0A
Ool00ekgOomoo`0JOol00ekgOomoo`06Ool00ekgOomoo`08Ool00ekgOomoo`0?Ool00ekgOomoo`0@
Ool00ekgOomoo`08Ool00ekgOomoo`06Ool00ekgOomoo`08Ool00`00Oomoo`13Ool003aoo`03001o
ogoo01aoo`03G_Moogoo02Eoo`03G_Moogoo00aoo`03G_Moogoo01Yoo`03G_Moogoo015oo`03G_Mo
ogoo01Yoo`03G_Moogoo00Eoo`03G_Moogoo00Uoo`03G_Moogoo00moo`03G_Moogoo011oo`03G_Mo
ogoo00Uoo`03G_Moogoo00Eoo`03G_Moogoo00Qoo`03001oogoo04=oo`00?7oo00<007ooOol077oo
00=NmgooOol09Goo00=NmgooOol03Goo00=NmgooOol067oo00=NmgooOol04goo00=NmgooOol06Goo
00=NmgooOol017oo00=NmgooOol02Woo00=NmgooOol03goo00=NmgooOol047oo00=NmgooOol02Woo
00=NmgooOol017oo00=NmgooOol027oo00<007ooOol0@goo000lOol00`00Oomoo`0KOol00ekgOomo
o`0VOol00ekgOomoo`0=Ool00ekgOomoo`0HOol00ekgOomoo`0COol00ekgOomoo`0IOol00ekgOomo
o`03Ool00ekgOomoo`0<Ool00ekgOomoo`0>Ool00ekgOomoo`0?Ool00ekgOomoo`0<Ool00ekgOomo
o`03Ool00ekgOomoo`07Ool20015Ool003aoo`03001oogoo01]oo`03G_Moogoo02Ioo`03G_Moogoo
00ioo`03G_Moogoo01Moo`03G_Moogoo01=oo`03G_Moogoo01Uoo`03G_Moogoo00=oo`03G_Moogoo
00aoo`03G_Moogoo00ioo`03G_Moogoo00moo`03G_Moogoo00aoo`03G_Moogoo00=oo`03G_Moogoo
00Qoo`03001oogoo04=oo`00?7oo00<007ooOol06goo00=NmgooOol09Woo00=NmgooOol03goo00=N
mgooOol05Woo00=NmgooOol057oo00=NmgooOol06Goo00ENmgooOomooekg00moo`03G_Moogoo00io
o`03G_Moogoo00moo`03G_Moogoo00eoo`05G_MoogooOomNm`0;Ool00`00Oomoo`13Ool003aoo`03
001oogoo01]oo`03G_Moogoo02Eoo`03G_Moogoo011oo`03G_Moogoo01Eoo`03G_Moogoo01Eoo`03
G_Moogoo01Uoo`05G_MoogooOomNm`0?Ool00ekgOomoo`0>Ool00ekgOomoo`0?Ool00ekgOomoo`0=
Ool01EkgOomoogooG_L02goo00<007ooOol0@goo000lOol00`00Oomoo`0KOol00ekgOomoo`0UOol0
0ekgOomoo`0AOol00ekgOomoo`0DOol00ekgOomoo`0EOol00ekgOomoo`0IOol015kgOomooekg47oo
00=NmgooOol03Woo00=NmgooOol03goo00=NmgooOol03Woo00ANmgooOomNm`]oo`03001oogoo04=o
o`00?7oo00<007ooOol06goo00=NmgooOol09Goo00=NmgooOol04Goo00=NmgooOol057oo00=Nmgoo
Ool05Woo00=NmgooOol067oo00=NmgooG_L04Goo00=NmgooOol03Woo00=NmgooOol03goo00=Nmgoo
Ool03goo00=NmgooG_L02goo00<007ooOol0@goo000lOol00`00Oomoo`0KOol00ekgOomoo`0UOol0
0ekgOomoo`0BOol00ekgOomoo`0COol00ekgOomoo`0FOol00ekgOomoo`0HOol00ekgOomNm`0AOol0
0ekgOomoo`0>Ool00ekgOomoo`0?Ool00ekgOomoo`0?Ool00ekgOomNm`0;Ool00`00Oomoo`13Ool0
03aoo`03001oogoo01]oo`03G_Moogoo02Eoo`03G_Moogoo01=oo`03G_Moogoo015oo`03G_Moogoo
01Moo`03G_Moogoo01Qoo`9Nma9oo`03G_Moogoo00ioo`03G_Moogoo00moo`03G_Moogoo011oo`03
G_Moogoo00Yoo`03001oogoo04=oo`00?7oo00<007ooOol06goo00=NmgooOol09Goo00=NmgooOol0
4goo00=NmgooOol04Goo00=NmgooOol067oo00=NmgooOol05goo0Ukg4Woo00=NmgooOol03Woo00=N
mgooOol03goo00=NmgooOol047oo0Ukg2goo00<007ooOol0@goo000lOol00`00Oomoo`0KOol00ekg
Oomoo`0TOol00ekgOomoo`0EOol00ekgOomoo`0@Ool00ekgOomoo`0HOol00ekgOomoo`0GOol2G_LB
Ool00ekgOomoo`0>Ool00ekgOomoo`0?Ool00ekgOomoo`0@Ool2G_L;Ool00`00Oomoo`13Ool003ao
o`03001oogoo01Yoo`03G_Moogoo02Eoo`03G_Moogoo01Eoo`03G_Moogoo011oo`03G_Moogoo01Qo
o`03G_Moogoo01Ioo`03G_Mooekg019oo`03G_Moogoo00ioo`03G_Moogoo00moo`03G_Moogoo011o
o`03G_Mooekg00Yoo`03001oogoo04=oo`00?7oo00<007ooOol06Woo00=NmgooOol09Goo00=Nmgoo
Ool05Woo00=NmgooOol03Woo00=NmgooOol06Woo00=NmgooOol05Goo00=NmgooG_L04goo00=Nmgoo
Ool03Goo00=NmgooOol03Woo00=NmgooOol04Goo00=NmgooG_L02Goo0P00AGoo000lOol00`00Oomo
o`0JOol00ekgOomoo`0UOol00ekgOomoo`0FOol00ekgOomoo`0>Ool00ekgOomoo`0JOol00ekgOomo
o`0DOol015kgOomooekg4goo00=NmgooOol03Goo00=NmgooOol03Woo00=NmgooOol047oo00ENmgoo
Oomooekg00Uoo`03001oogoo04=oo`00?7oo00<007ooOol06Woo00=NmgooOol09Goo00=NmgooOol0
5goo00=NmgooOol03Goo00=NmgooOol06Woo00=NmgooOol04goo00=NmgooOol00Woo00=NmgooOol0
47oo00=NmgooOol03Goo00=NmgooOol03Woo00=NmgooOol047oo00ENmgooOomooekg00Uoo`03001o
ogoo04=oo`00?7oo00<007ooOol06Woo00=NmgooOol09Goo00=NmgooOol067oo00=NmgooOol037oo
00=NmgooOol06goo00=NmgooOol04Woo00=NmgooOol00Woo00=NmgooOol047oo00=NmgooOol03Goo
00=NmgooOol03Woo00=NmgooOol047oo00=NmgooOol00Woo00=NmgooOol01Woo00<007ooOol0@goo
000lOol00`00Oomoo`0JOol00ekgOomoo`0TOol00ekgOomoo`0IOol00ekgOomoo`0;Ool00ekgOomo
o`0LOol00ekgOomoo`0AOol00ekgOomoo`03Ool00ekgOomoo`0@Ool00ekgOomoo`0=Ool00ekgOomo
o`0>Ool00ekgOomoo`0@Ool00ekgOomoo`02Ool00ekgOomoo`06Ool00`00Oomoo`13Ool003aoo`03
001oogoo01Yoo`03G_Moogoo02Aoo`03G_Moogoo01Yoo`03G_Moogoo00Yoo`03G_Moogoo01aoo`03
G_Moogoo015oo`03G_Moogoo00=oo`03G_Moogoo011oo`03G_Moogoo00eoo`03G_Moogoo00ioo`03
G_Moogoo011oo`03G_Moogoo00=oo`03G_Moogoo00Eoo`03001oogoo04=oo`00?7oo00<007ooOol0
6Woo00=NmgooOol097oo00=NmgooOol06Woo00=NmgooOol02Woo00=NmgooOol07Goo00=NmgooOol0
3goo00=NmgooOol017oo00=NmgooOol047oo00=NmgooOol03Goo00=NmgooOol03Woo00=NmgooOol0
3goo00=NmgooOol017oo00=NmgooOol01Goo00<007ooOol0@goo000lOol00`00Oomoo`0JOol00ekg
Oomoo`0TOol00ekgOomoo`0KOol00ekgOomoo`09Ool00ekgOomoo`0MOol00ekgOomoo`0?Ool00ekg
Oomoo`05Ool00ekgOomoo`0?Ool00ekgOomoo`0=Ool00ekgOomoo`0>Ool00ekgOomoo`0?Ool00ekg
Oomoo`05Ool00ekgOomoo`04Ool00`00Oomoo`13Ool003aoo`03001oogoo01Uoo`03G_Moogoo02Eo
o`03G_Moogoo01]oo`03G_Moogoo00Uoo`03G_Moogoo01eoo`03G_Moogoo00ioo`03G_Moogoo00Io
o`03G_Moogoo00moo`03G_Moogoo00eoo`03G_Moogoo00ioo`03G_Moogoo00moo`03G_Moogoo00Eo
o`03G_Moogoo00Aoo`03001oogoo04=oo`00?7oo00<007ooOol06Goo00=NmgooOol09Goo00=Nmgoo
Ool077oo00=NmgooOol01goo00=NmgooOol07goo00=NmgooOol03Goo00=NmgooOol01Woo00=Nmgoo
Ool03goo00=NmgooOol03Goo00=NmgooOol03Woo00=NmgooOol03goo00=NmgooOol01Woo00=Nmgoo
Ool00goo00<007ooOol0@goo000lOol00`00Oomoo`0IOol00ekgOomoo`0TOol00ekgOomoo`0NOol0
0ekgOomoo`06Ool00ekgOomoo`0OOol00ekgOomoo`0<Ool00ekgOomoo`07Ool00ekgOomoo`0?Ool0
0ekgOomoo`0=Ool00ekgOomoo`0=Ool00ekgOomoo`0@Ool00ekgOomoo`06Ool00ekgOomoo`03Ool0
0`00Oomoo`13Ool003aoo`03001oogoo01Uoo`03G_Moogoo02Aoo`03G_Moogoo01ioo`03G_Moogoo
00Ioo`03G_Moogoo01moo`03G_Moogoo00aoo`03G_Moogoo00Moo`03G_Moogoo00moo`03G_Moogoo
00eoo`03G_Moogoo00eoo`03G_Moogoo011oo`03G_Moogoo00Ioo`03G_Moogoo009oo`8004Eoo`00
?7oo00<007ooOol06Goo00=NmgooOol097oo00=NmgooOol07goo00=NmgooOol01Goo00=NmgooOol0
87oo00=NmgooOol02Woo00=NmgooOol02Goo00=NmgooOol03goo00=NmgooOol037oo00=NmgooOol0
3Goo00=NmgooOol03goo00=NmgooOol027oo00=NmgooOol00Woo00<007ooOol0@goo000lOol00`00
Oomoo`0IOol00ekgOomoo`0TOol00ekgOomoo`0OOol00ekgOomoo`04Ool00ekgOomoo`0QOol00ekg
Oomoo`0:Ool00ekgOomoo`09Ool00ekgOomoo`0?Ool00ekgOomoo`0<Ool00ekgOomoo`0=Ool00ekg
Oomoo`0?Ool00ekgOomoo`08Ool00ekgOomoo`02Ool00`00Oomoo`13Ool003aoo`03001oogoo01Uo
o`03G_Moogoo02Aoo`03G_Moogoo021oo`03G_Moogoo00=oo`03G_Moogoo025oo`03G_Moogoo00Uo
o`03G_Moogoo00Yoo`03G_Moogoo00moo`03G_Moogoo00aoo`03G_Moogoo00eoo`03G_Moogoo00mo
o`03G_Moogoo00Uoo`05G_MoogooOol00015Ool003aoo`03001oogoo01Uoo`03G_Moogoo02Aoo`03
G_Moogoo025oo`03G_Moogoo009oo`03G_Moogoo029oo`03G_Moogoo00Qoo`03G_Moogoo00Yoo`03
G_Moogoo00moo`03G_Moogoo00aoo`03G_Moogoo00eoo`03G_Moogoo00moo`03G_Moogoo00Uoo`05
G_MoogooOol00015Ool003aoo`03001oogoo01Uoo`03G_Moogoo02=oo`03G_Moogoo029oo`03G_Mo
ogoo009oo`03G_Moogoo029oo`03G_Moogoo00Moo`03G_Moogoo00]oo`03G_Moogoo00moo`03G_Mo
ogoo00aoo`03G_Moogoo00eoo`03G_Moogoo00moo`03G_Moogoo00Yoo`04G_Moogoo0015Ool003ao
o`03001oogoo01Qoo`03G_Moogoo02Aoo`03G_Moogoo02=oo`05G_MoogooOomNm`0TOol00ekgOomo
o`07Ool00ekgOomoo`0<Ool00ekgOomoo`0>Ool00ekgOomoo`0<Ool00ekgOomoo`0=Ool00ekgOomo
o`0>Ool00ekgOomoo`0;Ool015kgOomoo`00AGoo000lOol00`00Oomoo`0HOol00ekgOomoo`0TOol0
0ekgOomoo`0SOol015kgOomooekg9Woo00=NmgooOol01Woo00=NmgooOol037oo00=NmgooOol03Woo
00=NmgooOol037oo00=NmgooOol03Goo00=NmgooOol03Woo00=NmgooOol02goo00ANmgooOol004Eo
o`00?7oo00<007ooOol067oo00=NmgooOol097oo00=NmgooOol097oo00=NmgooG_L09Woo00=Nmgoo
Ool01Goo00=NmgooOol03Goo00=NmgooOol03Woo00=NmgooOol037oo00=NmgooOol03Goo00=Nmgoo
Ool03Woo00=NmgooOol037oo00=Nmgoo0000AGoo000dOol20006Ool00`00Oomoo`0HOol00ekgOomo
o`0TOol00ekgOomoo`0TOol00ekgOomNm`0VOol00ekgOomoo`05Ool00ekgOomoo`0=Ool00ekgOomo
o`0>Ool00ekgOomoo`0<Ool00ekgOomoo`0=Ool00ekgOomoo`0>Ool00ekgOomoo`0<Ool00ekgOol0
0015Ool003Ioo`03001oogoo00=oo`03001oogoo01Qoo`03G_Moogoo02Aoo`03G_Moogoo02Eoo`9N
mbMoo`03G_Moogoo00Aoo`03G_Moogoo00eoo`03G_Moogoo00ioo`03G_Moogoo00aoo`03G_Moogoo
00aoo`03G_Moogoo00moo`03G_Moogoo00eoo`03G_L007oo04Aoo`00;goo0`000goo00<007ooOol0
17oo0P006Goo00=NmgooOol08goo00=NmgooOol09Woo0Ukg9goo00=NmgooOol00goo00=NmgooOol0
3Woo00=NmgooOol03Woo00=NmgooOol037oo00=NmgooOol037oo00=NmgooOol03Woo00=NmgooOol0
3Goo00<005kg0000AGoo000fOol00`00Oomoo`03Ool00`00Oomoo`0HOol00ekgOomoo`0SOol00ekg
Oomoo`0VOol2G_LWOol00ekgOomoo`03Ool00ekgOomoo`0?Ool00ekgOomoo`0>Ool00ekgOomoo`0;
Ool00ekgOomoo`0<Ool00ekgOomoo`0>Ool00ekgOomoo`0?Ool00ekgOomoo`13Ool003Aoo`03001o
o`0000Eoo`03001oogoo01Qoo`03G_Moogoo02=oo`03G_Moogoo02Ioo`03G_Mooekg02Moo`03G_Mo
ogoo009oo`03G_Moogoo00moo`03G_Moogoo00ioo`03G_Moogoo00]oo`03G_Moogoo00aoo`03G_Mo
ogoo00ioo`03G_Moogoo00moo`03G_Moogoo04=oo`00=Goo00<007ooOol017oo00=NmgooOol067oo
00=NmgooOol08goo00=NmgooOol09Woo00=NmgooG_L09goo00ENmgooOomooekg019oo`03G_Moogoo
00ioo`03G_Moogoo00]oo`03G_Moogoo00aoo`03G_Moogoo00ioo`03G_Moogoo00moo`03001oogoo
04=oo`00?7oo00<005kgOol067oo00=NmgooOol08goo00=NmgooOol09Goo00ENmgooOomooekg02Io
o`05G_MoogooOomNm`0BOol00ekgOomoo`0>Ool00ekgOomoo`0;Ool00ekgOomoo`0<Ool00ekgOomo
o`0>Ool00ekgOomoo`0?Ool00`00Oomoo`13Ool003aoo`04001ooekgG_LFOol00ekgOomoo`0TOol0
0ekgOomoo`0UOol01EkgOomoogooG_L09goo00ANmgooOomNma9oo`03G_Moogoo00ioo`03G_Moogoo
00]oo`03G_Moogoo00aoo`03G_Moogoo00eoo`03G_Moogoo011oo`03001oogoo04=oo`00?7oo00D0
07ooOomooekg01Eoo`03G_Moogoo02Aoo`03G_Moogoo02Eoo`03G_Moogoo009oo`03G_Moogoo02Ao
o`04G_MoogooG_LCOol00ekgOomoo`0=Ool00ekgOomoo`0;Ool00ekgOomoo`0<Ool00ekgOomoo`0=
Ool00ekgOomoo`0@Ool00`00Oomoo`13Ool003aoo`03001oogoo009oo`03G_Moogoo019oo`03G_Mo
ogoo02Aoo`03G_Moogoo02Eoo`03G_Moogoo00=oo`03G_Moogoo02=oo`03G_Mooekg01Aoo`03G_Mo
ogoo00eoo`03G_Moogoo00]oo`03G_Moogoo00aoo`03G_Moogoo00eoo`03G_Moogoo011oo`03001o
ogoo04=oo`00?7oo00<007ooOol00goo00=NmgooOol04Goo00=NmgooOol08goo00=NmgooOol09Woo
00=NmgooOol00goo00=NmgooOol097oo0Ukg57oo00=NmgooOol03Goo00=NmgooOol02goo00=Nmgoo
Ool037oo00=NmgooOol03Goo00=NmgooOol047oo00<007ooOol0@goo000lOol00`00Oomoo`04Ool2
G_LAOol00ekgOomoo`0SOol00ekgOomoo`0VOol00ekgOomoo`04Ool00ekgOomoo`0SOol2G_LDOol0
0ekgOomoo`0=Ool00ekgOomoo`0;Ool00ekgOomoo`0<Ool00ekgOomoo`0=Ool00ekgOomoo`0@Ool0
0`00Oomoo`13Ool003aoo`03001oogoo00Ioo`03G_Moogoo00ioo`03G_Moogoo02=oo`03G_Moogoo
02Eoo`03G_Moogoo00Eoo`03G_Moogoo02=oo`03G_Moogoo01=oo`03G_Moogoo00eoo`03G_Moogoo
00]oo`03G_Moogoo00]oo`03G_Moogoo00eoo`03G_Moogoo015oo`03001oogoo04=oo`00?7oo00<0
07ooOol01goo00=NmgooOol03Goo00=NmgooOol08goo00=NmgooOol09Goo00=NmgooOol01Woo00=N
mgooOol08Woo0Ukg5Goo00=NmgooOol037oo00=NmgooOol02goo00=NmgooOol02goo00=NmgooOol0
3Goo00=NmgooOol047oo0P00AGoo000lOol00`00Oomoo`08Ool00ekgOomoo`0<Ool00ekgOomoo`0S
Ool00ekgOomoo`0UOol00ekgOomoo`07Ool00ekgOomoo`0QOol2G_LEOol00ekgOomoo`0=Ool00ekg
Oomoo`0:Ool00ekgOomoo`0;Ool00ekgOomoo`0=Ool00ekgOomoo`0AOol00`00Oomoo`13Ool003ao
o`03001oogoo00Uoo`9Nm`aoo`03G_Moogoo02=oo`03G_Moogoo02Eoo`03G_Moogoo00Moo`03G_Mo
ogoo021oo`03G_Mooekg01Eoo`03G_Moogoo00eoo`03G_Moogoo00Yoo`03G_Moogoo00]oo`03G_Mo
ogoo00eoo`03G_Moogoo015oo`03001oogoo04=oo`00?7oo00<007ooOol02goo00=NmgooOol027oo
00=NmgooOol097oo00=NmgooOol09Goo00=NmgooOol027oo00=NmgooOol07goo00ANmgooOomNmaAo
o`03G_Moogoo00eoo`03G_Moogoo00Yoo`03G_Moogoo00]oo`03G_Moogoo00eoo`03G_Moogoo015o
o`03001oogoo04=oo`00?7oo00<007ooOol037oo00=NmgooOol01goo00=NmgooOol097oo00=Nmgoo
Ool09Goo00=NmgooOol027oo00=NmgooOol07goo00ANmgooOomNmaAoo`03G_Moogoo00eoo`03G_Mo
o`;Q00Yoo`03G_Moogoo00]oo`03G_Moogoo00aoo`03G_Moogoo019oo`03001oogoo04=oo`00?7oo
00<007ooOol03Goo00=NmgooOol01Woo00=NmgooOol08goo00=NmgooOol09Woo00=NmgooOol02Goo
00=NmgooOol07Goo00ENmgooOomooekg01Eoo`03G_Moogoo00aoo`04G_L2h@;Q0^49Ool00ekgOomo
o`0;Ool00ekgOomoo`0<Ool00ekgOomoo`0BOol00`00Oomoo`13Ool003aoo`03001oogoo00ioo`9N
m`Ioo`03G_Moogoo02=oo`03G_Moogoo02Ioo`03G_Moogoo00Uoo`03G_Moogoo01eoo`03G_Moogoo
009oo`03G_Moogoo019oo`03G_Moogoo00aoo`04G_L2i0;Q0^@9Ool00ekgOomoo`0;Ool00ekgOomo
o`0<Ool00ekgOomoo`0BOol00ekgOomoo`13Ool003aoo`03001oogoo011oo`03G_Moogoo00=oo`03
G_Moogoo02=oo`03G_Moogoo02Eoo`03G_Moogoo00]oo`03G_Moogoo01aoo`03G_Moogoo009oo`03
G_Moogoo019oo`03G_Moogoo00aoo`03G_Moo`;T00Yoo`03G_Moogoo00]oo`03G_Moogoo00aoo`03
G_Moogoo019oo`03G_Moogoo04=oo`00?7oo00<007ooOol04Goo00=NmgooOol00Woo00=NmgooOol0
8goo00=NmgooOol09Goo00=NmgooOol037oo00=NmgooOol06goo00=NmgooOol00Woo00=NmgooOol0
4Woo00=NmgooOol037oo00ANm`;V0^H2iPUoo`03G_Moogoo00]oo`03G_Moogoo00aoo`03G_Moogoo
015oo`03G_L007oo04Aoo`00?7oo00<007ooOol04Woo00ENmgooOomooekg02Eoo`03G_Moogoo02Eo
o`03G_Moogoo00aoo`03G_Moogoo01Yoo`03G_Moogoo00Aoo`03G_Moogoo015oo`03G_Moogoo00ao
o`03G_Moo`;V00Yoo`03G_Moogoo00]oo`03G_Moogoo00]oo`03G_Moogoo019oo`03G_L007oo04Ao
o`00?7oo00<007ooOol04goo0Ukg00=ooekgOol097oo00=NmgooOol09Goo00=NmgooOol03Goo00=N
mgooOol06Goo00=NmgooOol017oo00=NmgooOol04Goo00=NmgooOol037oo00ANm`;X0^T2j0Uoo`03
G_Moogoo00Yoo`03G_Moogoo00aoo`03G_Moogoo019oo`03G_L007oo04Aoo`00?7oo00<007ooOol0
5Goo0Ukg9Goo00=NmgooOol09Goo00=NmgooOol03Goo00=NmgooOol06Goo00=NmgooOol017oo00=N
mgooOol04Woo00=NmgooOol02goo00=Nmgoo0^P02Woo00=NmgooOol02Woo00=NmgooOol037oo00=N
mgooOol04Goo00=Nm`000000AGoo000lOol00`00Oomoo`0FOol00ekgOomoo`0SOol00ekgOomoo`0U
Ool00ekgOomoo`0>Ool00ekgOomoo`0GOol00ekgOomoo`06Ool00ekgOomoo`0AOol00ekgOomoo`0;
Ool015kg0^/2j`;[2Goo00=NmgooOol02Woo00=NmgooOol037oo00=NmgooOol04Goo00=Nmgoo0000
AGoo000lOol00`00Oomoo`0EOol00ekgOomNm`0TOol00ekgOomoo`0UOol00ekgOomoo`0>Ool00ekg
Oomoo`0GOol00ekgOomoo`06Ool00ekgOomoo`0AOol00ekgOomoo`0<Ool00ekg0^]oo`09Ool00ekg
Oomoo`0:Ool00ekgOomoo`0<Ool00ekgOomoo`0AOol00ekgOol00015Ool003aoo`03001oogoo01Eo
o`03G_Moogoo009Nmb5oo`03G_Moogoo02Eoo`03G_Moogoo011oo`03G_Moogoo01Ioo`03G_Moogoo
00Ioo`03G_Moogoo015oo`03G_Moogoo00aoo`<2k@Uoo`03G_Moogoo00Yoo`03G_Moogoo00]oo`03
G_Moogoo015oo`04G_Moogoo0015Ool003aoo`03001oogoo01Eoo`03G_Moogoo009oo`03G_Moogoo
01ioo`03G_Moogoo02Eoo`03G_Moogoo015oo`03G_Moogoo01Eoo`03G_Moogoo00Moo`03G_Moogoo
011oo`03G_Moogoo00aoo`030^l2k@;_00Uoo`03G_Moogoo00Yoo`03G_Moogoo00]oo`03G_Moogoo
015oo`04G_Moogoo0015Ool003aoo`03001oogoo01Eoo`03G_Moogoo00=oo`03G_Moogoo01eoo`03
G_Moogoo02Eoo`03G_Moogoo015oo`03G_Moogoo01Aoo`03G_Moogoo00Qoo`03G_Moogoo015oo`03
G_Moogoo00]oo`03G_L2kgoo00Uoo`03G_Moogoo00Yoo`03G_Moogoo00]oo`03G_Moogoo015oo`04
G_Moogoo0015Ool003aoo`03001oogoo01Eoo`03G_Moogoo00Aoo`03G_Moogoo01aoo`03G_Moogoo
02Eoo`03G_Moogoo019oo`03G_Moogoo01=oo`03G_Moogoo00Qoo`03G_Moogoo015oo`03G_Moogoo
00]oo`030_82l@;b00Uoo`03G_Moogoo00Yoo`03G_Moogoo00]oo`03G_Moogoo011oo`05G_Moogoo
Ool00015Ool003aoo`03001oogoo01Eoo`03G_Moogoo00Eoo`9Nmaaoo`03G_Moogoo02Eoo`03G_Mo
ogoo019oo`03G_Moogoo01=oo`03G_Moogoo00Uoo`03G_Moogoo011oo`03G_Moogoo00]oo`03G_L2
lWoo00Uoo`03G_Moogoo00Yoo`03G_Moogoo00]oo`03G_Moogoo011oo`05G_MoogooOol00015Ool0
03aoo`03001oogoo01Eoo`03G_Moogoo00Moo`03G_Moogoo01Uoo`03G_Moogoo02Eoo`03G_Moogoo
01=oo`03G_Moogoo015oo`03G_Moogoo00Yoo`03G_Moogoo011oo`03G_Moogoo00]oo`<2m0Uoo`03
G_Moogoo00Yoo`03G_Moogoo00Yoo`03G_Moogoo015oo`05G_MoogooOol00015Ool003aoo`03001o
ogoo01Eoo`03G_Moogoo00Qoo`03G_Moogoo01Qoo`03G_Moogoo02Eoo`03G_Moogoo01=oo`03G_Mo
ogoo015oo`03G_Moogoo00Yoo`03G_Moogoo011oo`03G_Moogoo00]oo`03G_L2m0;f00Uoo`03G_Mo
ogoo00Uoo`03G_Moogoo00]oo`03G_Moogoo011oo`03G_Moogoo009oo`03001oogoo04=oo`00?7oo
00<007ooOol05Goo00=NmgooOol02Goo00=NmgooOol05goo00=NmgooOol097oo00=NmgooOol05Goo
00=NmgooOol047oo00=NmgooOol02goo00=NmgooOol047oo00=NmgooOol02Woo00ANm`;f0_L2mPQo
o`03G_Moogoo00Uoo`03G_Moogoo00]oo`03G_Moogoo011oo`03G_Moogoo009oo`03001oogoo04=o
o`00?7oo00<007ooOol05Goo00=NmgooOol02Woo0Ukg5goo00=NmgooOol097oo00=NmgooOol05Woo
00=NmgooOol03goo00=NmgooOol02goo00=NmgooOol047oo00=NmgooOol02Woo00=Nmgoo0_H02Goo
00=NmgooOol02Goo00=NmgooOol02goo00=NmgooOol047oo00ANmgooOomoo`8004Eoo`00?7oo00<0
07ooOol05Goo00=NmgooOol037oo00=NmgooOol04goo00=NmgooOol09Goo00=NmgooOol05Woo00=N
mgooOol03Woo00=NmgooOol037oo00=NmgooOol047oo00=NmgooOol02Woo00ANm`:g0]L2]`Qoo`03
G_Moogoo00Uoo`03G_Moogoo00]oo`03G_Moogoo00moo`03G_Moogoo00=oo`03001oogoo04=oo`00
?7oo00<007ooOol057oo00=NmgooOol03Woo00=NmgooOol04Woo00=NmgooOol09Goo00=NmgooOol0
5goo00=NmgooOol03Goo00=NmgooOol03Goo00=NmgooOol03goo00=NmgooOol02goo00=Nm`:gOol0
27oo00=NmgooOol02Goo00=NmgooOol02Woo00=NmgooOol047oo00=NmgooOol00goo00<007ooOol0
@goo000lOol00`00Oomoo`0DOol00ekgOomoo`0?Ool00ekgOomoo`0AOol00ekgOomoo`0UOol00ekg
Oomoo`0GOol00ekgOomoo`0=Ool00ekgOomoo`0=Ool00ekgOomoo`0?Ool00ekgOomoo`0;Ool30WL8
Ool00ekgOomoo`09Ool00ekgOomoo`0:Ool00ekgOomoo`0@Ool00ekgOomoo`03Ool00`00Oomoo`13
Ool003aoo`03001oogoo01Aoo`03G_Moogoo011oo`9Nma5oo`03G_Moogoo02Eoo`03G_Moogoo01Qo
o`03G_Moogoo00aoo`03G_Moogoo00eoo`03G_Moogoo011oo`03G_Moogoo00Yoo`03G_L2Mgoo00Qo
o`03G_Moogoo00Uoo`03G_Moogoo00Yoo`03G_Moogoo00moo`03G_Moogoo00Aoo`03001oogoo04=o
o`00?7oo00<007ooOol057oo00=NmgooOol04Woo00=NmgooOol03Woo00=NmgooOol09Goo00=Nmgoo
Ool06Goo00=NmgooOol02Woo00=NmgooOol03goo00=NmgooOol03goo00=NmgooOol02Woo0`8g27oo
00=NmgooOol02Goo00=NmgooOol02Woo00=NmgooOol03goo00=NmgooOol017oo00<007ooOol0@goo
000lOol00`00Oomoo`0DOol00ekgOomoo`0COol00ekgOomoo`0=Ool00ekgOomoo`0UOol00ekgOomo
o`0IOol00ekgOomoo`0:Ool00ekgOomoo`0?Ool00ekgOomoo`0?Ool00ekgOomoo`0:Ool00ekg0SMo
o`08Ool00ekgOomoo`09Ool00ekgOomoo`0:Ool00ekgOomoo`0?Ool00ekgOomoo`04Ool00`00Oomo
o`13Ool003aoo`03001oogoo01Aoo`03G_Moogoo01Aoo`03G_Moogoo00aoo`03G_Moogoo02Aoo`03
G_Moogoo01]oo`03G_Moogoo00Uoo`03G_Moogoo00moo`03G_Moogoo00moo`03G_Moogoo00Yoo`03
0ML1m`7G00Qoo`03G_Moogoo00Uoo`03G_Moogoo00Yoo`03G_Moogoo00ioo`03G_Moogoo00Eoo`03
001oogoo04=oo`00?7oo00<007ooOol057oo00=NmgooOol05Goo0Ukg37oo00=NmgooOol097oo00=N
mgooOol06goo00=NmgooOol02Goo00=NmgooOol047oo00=NmgooOol03Woo00=NmgooOol02Woo00=N
m`7GOol027oo00=NmgooOol02Goo00=NmgooOol02Goo00=NmgooOol03goo00=NmgooOol01Goo00<0
07ooOol0@goo000lOol00`00Oomoo`0DOol00ekgOomoo`0GOol00ekgOomoo`08Ool00ekgOomoo`0U
Ool00ekgOomoo`0LOol00ekgOomoo`08Ool00ekgOomoo`0@Ool00ekgOomoo`0>Ool00ekgOomoo`0:
Ool30IL8Ool00ekgOomoo`08Ool00ekgOomoo`0:Ool00ekgOomoo`0?Ool00ekgOomoo`05Ool00`00
Oomoo`13Ool003aoo`03001oogoo01Aoo`03G_Moogoo01Qoo`03G_Moogoo00Moo`03G_Moogoo02Eo
o`03G_Moogoo01aoo`03G_Moogoo00Moo`03G_Moogoo015oo`03G_Moogoo00moo`03G_Moogoo00Uo
o`03G_L1Ugoo00Qoo`03G_Moogoo00Qoo`03G_Moogoo00Yoo`03G_Moogoo00ioo`03G_Moogoo00Io
o`03001oogoo04=oo`00?7oo00<007ooOol057oo00=NmgooOol06Goo00=NmgooOol01Woo00=Nmgoo
Ool09Goo00=NmgooOol07Goo00=NmgooOol01Woo00=NmgooOol04Woo00=NmgooOol03Woo00=Nmgoo
Ool02Goo0`5G27oo00=NmgooOol027oo00=NmgooOol02Woo00=NmgooOol03Woo00=NmgooOol01Goo
0P00<Woo00<007ooOol047oo000lOol00`00Oomoo`0DOol00ekgOomoo`0JOol00ekgOomoo`05Ool0
0ekgOomoo`0UOol00ekgOomoo`0NOol00ekgOomoo`05Ool00ekgOomoo`0BOol00ekgOomoo`0>Ool0
0ekgOomoo`09Ool00ekg0EL0m`08Ool00ekgOomoo`08Ool00ekgOomoo`0:Ool00ekgOomoo`0>Ool0
0ekgOomoo`06Ool00`00Oomoo`0OOol=G003Ool00`00Ool0000AOol003aoo`03001oogoo01Aoo`03
G_Moogoo01]oo`9Nm`Eoo`03G_Moogoo02Eoo`03G_Moogoo01ioo`03G_Moogoo00Eoo`03G_Moogoo
019oo`03G_Moogoo00ioo`03G_Moogoo00Yoo`030?L0mP3g00Moo`03G_Moogoo00Qoo`03G_Moogoo
00Uoo`03G_Moogoo00ioo`03G_Moogoo00Moo`03001oogoo01moo`=L0005F01L05`0G01H0003G000
0eP0G01oo`02Ool00`00Ool0000AOol003aoo`03001oogoo01Aoo`03G_Moogoo01eoo`03G_Moogoo
009oo`03G_Moogoo02Aoo`03G_Moogoo021oo`03G_Moogoo00=oo`03G_Moogoo01Aoo`03G_Moogoo
00eoo`03G_Moogoo00Yoo`03G_L0mgoo00Moo`03G_Moogoo00Qoo`03G_Moogoo00Uoo`03G_Moogoo
00ioo`03G_Moogoo00Moo`03001oogoo01moo`eL00=oo`03001oo`00015oo`00?7oo00<007ooOol0
57oo00=NmgooOol07Woo00ENmgooOomooekg02Ioo`03G_Moogoo021oo`03G_Moogoo00=oo`03G_Mo
ogoo01Aoo`03G_Moogoo00ioo`03G_Moogoo00Uoo`03G_L0]goo00Moo`03G_Moogoo00Qoo`03G_Mo
ogoo00Uoo`03G_Moogoo00ioo`03G_Moogoo00Moo`03001oogoo01moo`0=G09H0E`2G05L0UP1G09L
0E`2F05L0U`1G0800goo00<007oo00004Goo000lOol00`00Oomoo`0COol00ekgOomoo`0POol015kg
Oomooekg9Woo00=NmgooOol08Goo00=NmgooOol00Woo00=NmgooOol057oo00=NmgooOol03Woo00=N
mgooOol02Goo0`2g1goo00=NmgooOol027oo00=NmgooOol02Goo00=NmgooOol03Goo00=NmgooOol0
27oo00<007ooOol07goo00=L0E`2G0400U`100EL0U`1G05L0E`200=L0@Aoo`03001oogoo011oo`00
?7oo00<007ooOol04goo00=NmgooOol08Goo0ekg9Woo00=NmgooOol08Goo00=NmgooOol00Woo00=N
mgooOol05Goo00=NmgooOol03Goo00=NmgooOol02Goo00=Nm`2gOol01goo00=NmgooOol027oo00=N
mgooOol02Goo00=NmgooOol03Goo00=NmgooOol027oo00<007ooOol07goo00eL0U`1G09H0E`2G05L
0UP1G09L0E`2F05L0P0GOol003aoo`03001oogoo01=oo`03G_Moogoo029oo`9NmbIoo`03G_Moogoo
029oo`05G_MoogooOomNm`0GOol00ekgOomoo`0=Ool00ekgOomoo`09Ool307L7Ool00ekgOomoo`08
Ool00ekgOomoo`08Ool00ekgOomoo`0>Ool00ekgOomoo`08Ool00`00Oomoo`0OOol=G0@GOol003ao
o`03001oogoo01=oo`03G_Moogoo029oo`03G_Mooekg02Eoo`03G_Moogoo02=oo`03G_Mooekg01Qo
o`03G_Moogoo00eoo`03G_Moogoo00Uoo`03G_L0Mgoo00Moo`03G_Moogoo00Qoo`03G_Moogoo00Qo
o`03G_Moogoo00eoo`03G_Moogoo00Uoo`03001oogoo01moo`0=G0AH0e`4G0=L15P3G0AL0e`4F0=L
15`3G0@05goo000dOol30005Ool00`00Oomoo`0COol00ekgOomoo`0ROol015kgOomooekg97oo00=N
mgooOol08goo00=NmgooG_L06Goo00=NmgooOol03Goo00=NmgooOol027oo0`0G1goo00=NmgooOol0
1goo00=NmgooOol02Goo00=NmgooOol03Goo00=NmgooOol02Goo00<007ooOol07goo3E`45goo000d
Ool00`00Oomoo`05Ool00`00Oomoo`0COol00ekgOomoo`0ROol015kgOomoogoo0Ukg8Woo00=Nmgoo
Ool097oo0Ukg6Goo00=NmgooOol03Goo00=NmgooOol027oo00=Nm`0GOol01goo00=NmgooOol01goo
00=NmgooOol02Goo00=NmgooOol037oo00=NmgooOol02Woo00<007ooOol07goo00EL1e`6G0IH1U`7
009L1P06F0IL1e`6G0IH1U`75goo000_Ool30003Ool00`00Oomoo`04Ool2000DOol00ekgOomoo`0R
Ool00ekgOomoo`03Ool00ekgOomoo`0NOol00ekgOomoo`0UOol2G_LIOol00ekgOomoo`0=Ool00ekg
Oomoo`08Ool00`0G11L05`04Ool7G_L6Ool00ekgOomoo`09Ool00ekgOomoo`0<Ool00ekgOomoo`08
Ool3000QOol=G0HGOol003Eoo`03001oogoo00Aoo`03001oogoo01=oo`03G_Moogoo029oo`03G_Mo
ogoo00Aoo`03G_Moogoo01eoo`03G_Moogoo02Ioo`03G_Moogoo01Qoo`03G_Moogoo00aoo`03G_Mo
ogoo00Qoo`03G_L05goo009oo`9Nm`=oo`04G_MoogooOol2G_L4Ool00ekgOomoo`08Ool00ekgOomo
o`0=Ool00ekgOomoo`0:Ool00`00Oomoo`0OOol00e`6F0IL1`02G0H01UP6G0ML1U`6F0IL1`9L1QMo
o`00=7oo00<007oo00001Goo00<007ooOol04goo00=NmgooOol08Woo00=NmgooOol01Goo00=Nmgoo
Ool077oo00=NmgooOol09Goo00=NmgooG_L06Goo00=NmgooOol037oo00=NmgooOol027oo0``G0Ukg
1Goo00=NmgooOol00goo0Ukg0Woo00=NmgooOol027oo00=NmgooOol037oo00=NmgooOol02goo00<0
07ooOol07goo00eL25`9G0QL2E`8G0UL25`9G0QL2E`8G0UL200GOol003Eoo`03001oogoo00Aoo`03
001oogoo01=oo`03G_Moogoo029oo`03G_Moogoo00Ioo`9Nmaaoo`03G_Moogoo02Eoo`03G_Mooekg
01Uoo`03G_Moogoo00eoo`03G_Moogoo00Qoo`0331MNmgoo00Ioo`03G_Moogoo00Eoo`=Nm`Yoo`03
G_Moogoo00aoo`03G_Moogoo00]oo`03001oogoo01moo`0=G0UL25`9F0QL2E`8G0UH25`9G0QL2EP8
G0T05goo000lOol00`00Oomoo`0COol00ekgOomoo`0ROol00ekgOomoo`08Ool00ekgOomoo`0IOol0
0ekgOomoo`0UOol015kgOomooekg6Goo00=NmgooOol037oo00=NmgooOol01goo0Ukg00<D5gooOol0
1Goo00=NmgooOol01goo0Ukg2Goo00=NmgooOol037oo00=NmgooOol02goo00<007ooOol07goo00eL
25`9G0QL2E`8G0UL25`9G0QL2E`8G0UL200GOol003aoo`03001oogoo01=oo`03G_Moogoo029oo`03
G_Moogoo00Uoo`03G_Moogoo01Qoo`03G_Moogoo02Eoo`04G_MoogooG_LIOol00ekgOomoo`0<Ool0
0ekgOomoo`06Ool00ekgOolD5`0251L6Ool00ekgOomoo`07Ool00ekgOomNm`08Ool00ekgOomoo`0;
Ool00ekgOomoo`0<Ool00`00Oomoo`0OOol03E`9F0QL2E`8G0UH25`9G0QL2EP8G0UL25`901Moo`00
?7oo00<007ooOol04goo00=NmgooOol08Woo00=NmgooOol02Woo00=NmgooOol05goo00=NmgooOol0
9Goo00ENmgooOomooekg01Qoo`03G_Moogoo00aoo`03G_Moogoo00Eoo`05G_MoogooG_LD5`07Ool0
0ekgOomoo`07Ool015kgOomooekg1Woo00=NmgooOol037oo00=NmgooOol037oo00<007ooOol07goo
3E`;5goo000lOol00`00Oomoo`0BOol00ekgOomoo`0SOol00ekgOomoo`0;Ool2G_LGOol00ekgOomo
o`0UOol01EkgOomoogooG_L06Goo00=NmgooOol02goo00=NmgooOol017oo00MNmgooOomooa`G81LL
5`06Ool00ekgOomoo`07Ool01EkgOomoogooG_L01Goo00=NmgooOol037oo00=NmgooOol037oo00<0
07ooOol07goo0e`;00EH2U`;G0]L2eP:00=L2`03F0YL2goo01Ioo`00?7oo00<007ooOol04Woo00=N
mgooOol08goo00=NmgooOol03Goo00=NmgooOol04goo00=NmgooOol09Goo00=NmgooOol00goo00=N
mgooOol05Woo00=NmgooOol037oo00=NmgooOol00goo00INmgooOomooekg71L7Ool00ekgOomoo`06
Ool00ekgOomoo`02Ool00ekgOomoo`03Ool00ekgOomoo`0;Ool00ekgOomoo`0=Ool00`00Oomoo`0O
Ool=G0/GOol003aoo`03001oogoo019oo`03G_Moogoo02=oo`03G_Moogoo00ioo`03G_Moogoo019o
o`03G_Moogoo02Eoo`03G_Moogoo00Aoo`03G_Moogoo01Eoo`03G_Moogoo00aoo`03G_Moogoo009o
o`03G_Moogoo009oo`03G_LX5goo00Ioo`03G_Moogoo00Ioo`03G_Moogoo00=oo`03G_Moogoo009o
o`03G_Moogoo00]oo`03G_Moogoo00eoo`03001oogoo01moo`0=G0iH3E`>G0eL3UP=G0iL3E`>F0eL
3U`=G0h05goo000lOol00`00Oomoo`0BOol00ekgOomoo`0ROol00ekgOomoo`0@Ool00ekgOomoo`0A
Ool00ekgOomoo`0UOol00ekgOomoo`04Ool00ekgOomoo`0FOol00ekgOomoo`0;Ool01EkgOomoogoo
G_L01Goo00<X5b@G:1L01Woo00=NmgooOol01Woo00=NmgooOol017oo00ENmgooOomooekg00eoo`03
G_Moogoo00eoo`03001oogoo01moo`03G0eL3U`=009L3@05G0iL3E`=G0eL3P03G0dGOol003aoo`03
001oogoo019oo`03G_Moogoo029oo`03G_Moogoo015oo`9Nma5oo`03G_Moogoo02Eoo`03G_Moogoo
00Eoo`03G_Moogoo01Eoo`03G_Moogoo00]oo`04G_MoogooG_L6Ool00ekg:1Moo`06Ool00ekgOomo
o`06Ool00ekgOomoo`05Ool00ekgOomNm`0=Ool00ekgOomoo`0=Ool2000QOol03E`>G0eL3UP=G0iL
3E`>F0eL3U`=G0iH3E`>01Moo`00?7oo00<007ooOol04Woo00=NmgooOol08Woo00=NmgooOol04goo
00=NmgooOol03Woo00=NmgooOol09Goo00=NmgooOol01Goo00=NmgooOol05Goo00=NmgooOol02goo
00ANmgooOomNm`Ioo`<`5`Ioo`03G_Moogoo00Ioo`03G_Moogoo00Eoo`03G_Mooekg00eoo`03G_Mo
ogoo00ioo`03001oogoo01moo`eL41Moo`00?7oo00<007ooOol04Woo00=NmgooOol08Woo00=Nmgoo
Ool057oo00=NmgooOol03Goo00=NmgooOol09Goo00=NmgooOol01Woo00=NmgooOol05Goo00=Nmgoo
Ool02Woo00=NmgooG_L01goo00=Nmc0G>1L01Woo00=NmgooOol01Woo00=NmgooOol01Woo0Ukg3Goo
00=NmgooOol03Woo00<007ooOol07goo00eL45P?G11L3e`@F0mL45`?G11H3e`@G0mL400GOol003ao
o`03001oogoo019oo`03G_Moogoo029oo`03G_Moogoo01Eoo`03G_Moogoo00aoo`03G_Moogoo02Ao
o`03G_Moogoo00Moo`03G_Moogoo01Eoo`03G_Moogoo00]oo`9Nm`Qoo`<h5`Eoo`03G_Moogoo00Io
o`03G_Moogoo00Ioo`9Nm`aoo`03G_Moogoo00moo`03001oogoo01moo`eL41Moo`00?7oo00<007oo
Ool04Woo00=NmgooOol08Woo00=NmgooOol05Woo0Ukg37oo00=NmgooOol097oo00=NmgooOol027oo
00=NmgooOol057oo00=NmgooOol02goo00=NmgooOol01goo00=NmcPGOol01Goo00=NmgooOol01Woo
00=NmgooOol01goo00=NmgooOol02Woo00=NmgooOol03goo00<007ooOol07goo00EL4e`BG19H4U`C
009L4P06F19L4e`BG19H4U`C5goo000lOol00`00Oomoo`0BOol00ekgOomoo`0ROol00ekgOomoo`0H
Ool00ekgOomoo`08Ool00ekgOomoo`0UOol00ekgOomoo`09Ool00ekgOomoo`0DOol00ekgOomoo`0:
Ool00ekgOomoo`07Ool00ekgA1Moo`05Ool00ekgOomoo`06Ool00ekgOomoo`06Ool2G_L<Ool00ekg
Oomoo`0?Ool00`00Oomoo`0OOol=G18GOol003aoo`03001oogoo019oo`03G_Moogoo029oo`03G_Mo
ogoo01Uoo`03G_Moogoo00Moo`03G_Moogoo02Eoo`03G_Moogoo00Uoo`03G_Moogoo01Aoo`03G_Mo
ogoo00Uoo`9Nm`Uoo`03A1M05T@G00Eoo`03G_Moogoo00Ioo`03G_Moogoo00Ioo`03G_Mooekg00Yo
o`03G_Moogoo011oo`03001oogoo01moo`03G19H4U`C009L4P06F19L4e`BG19H4U`C0U`B5goo000l
Ool00`00Oomoo`0BOol00ekgOomoo`0ROol00ekgOomoo`0JOol00ekgOomoo`06Ool00ekgOomoo`0U
Ool00ekgOomoo`0:Ool00ekgOomoo`0COol00ekgOomoo`08Ool00ekgOomNm`09Ool00ekgA1Moo`05
Ool00ekgOomoo`06Ool00ekgOomoo`06Ool015kgOomooekg2Goo00=NmgooOol047oo00<007ooOol0
7goo00eL55`EG1AL5E`DG1EL55`EG1AL5E`DG1EL500GOol003aoo`03001oogoo019oo`03G_Moogoo
029oo`03G_Moogoo01]oo`9Nm`Ioo`03G_Moogoo02Eoo`03G_Moogoo00Yoo`03G_Moogoo01Aoo`03
G_Moogoo00Moo`04G_MoogooG_L8Ool00ekgC1Moo`05Ool00ekgOomoo`05Ool00ekgOomoo`07Ool0
15kgOomooekg2Goo00=NmgooOol047oo00<007ooOol07goo00eL5E`DG1EH55`EG1AL5EPDG1EL55`E
F1AL5@0GOol003aoo`03001oogoo019oo`03G_Moogoo029oo`03G_Moogoo01eoo`03G_Moogoo00=o
o`03G_Moogoo02Aoo`03G_Moogoo00aoo`03G_Moogoo01=oo`03G_Moogoo00Ioo`05G_MoogooOomN
m`08Ool3C1L5Ool00ekgOomoo`05Ool00ekgOomoo`07Ool01EkgOomoogooG_L01goo00=NmgooOol0
4Goo00<007ooOol07goo00eL55`EG1AL5E`DG1EL55`EG1AL5E`DG1EL500GOol003aoo`03001oogoo
015oo`03G_Moogoo02=oo`03G_Moogoo01ioo`03G_Moogoo009oo`03G_Moogoo02Aoo`03G_Moogoo
00eoo`03G_Moogoo019oo`03G_Moogoo00Ioo`05G_MoogooOomNm`08Ool00ekgC1MD5`05Ool00ekg
Oomoo`05Ool00ekgOomoo`06Ool00ekgOomoo`02Ool00ekgOomoo`05Ool00ekgOomoo`0AOol00`00
Oomoo`0OOol03E`EF1AL5E`DG1EH55`EG1AL5EPDG1EL55`E01Moo`00?7oo00<007ooOol04Goo00=N
mgooOol08goo00=NmgooOol07goo00ENmgooOomooekg02Ioo`03G_Moogoo00eoo`03G_Moogoo01=o
o`03G_Moogoo00Aoo`03G_Moogoo009oo`03G_Moogoo00Ioo`04G_MD5e@GE1L4Ool00ekgOomoo`05
Ool00ekgOomoo`06Ool00ekgOomoo`03Ool00ekgOomoo`04Ool00ekgOomoo`0@Ool2000QOol=G1LG
Ool003aoo`03001oogoo015oo`03G_Moogoo02=oo`03G_Moogoo021oo`9Nm`03OomNmgoo02Eoo`03
G_Moogoo00ioo`03G_Moogoo019oo`03G_Moogoo00Aoo`03G_Moogoo009oo`03G_Moogoo00Ioo`03
G_Mooe@G00Eoo`03G_Moogoo00Eoo`03G_Moogoo00Ioo`03G_Moogoo00=oo`03G_Moogoo00=oo`03
G_Moogoo019oo`03001oogoo01moo`=L5`05F1IL5e`GG1MH5P03G1L00ePFG1Moo`0FOol003aoo`03
001oogoo015oo`03G_Moogoo02=oo`03G_Moogoo029oo`03G_Moogoo02Eoo`03G_Moogoo00ioo`03
G_Moogoo019oo`03G_Moogoo00=oo`03G_Moogoo00Aoo`03G_Moogoo00Eoo`03G_Mooe`F00Eoo`03
G_Moogoo00Eoo`03G_Moogoo00Ioo`03G_Moogoo00Aoo`03G_Moogoo009oo`03G_Moogoo019oo`03
G_Moogoo01moo`eL5aMoo`00?7oo00<007ooOol04Goo00=NmgooOol08goo00=NmgooOol08Woo0Ukg
9Woo00=NmgooOol03goo00=NmgooOol04Woo00=NmgooOol00Woo00=NmgooOol017oo00=NmgooOol0
1Woo00=L5U`GG1H017oo00=NmgooOol01Goo00=NmgooOol01Woo00=NmgooOol017oo00=NmgooOol0
0Woo00=NmgooOol04Goo00=Nm`00Ool087oo00eD5e0FE1M@5e@GD1ID5e0GE1M@5U@GD1MD5`0GOol0
03aoo`03001oogoo015oo`03G_Moogoo02=oo`03G_Moogoo029oo`03G_Mooekg02Aoo`03G_Moogoo
011oo`03G_Moogoo019oo`03G_Moogoo009oo`03G_Moogoo00Aoo`03G_Moogoo00Ioo`03G_ML5U`D
00Aoo`03G_Moogoo00Eoo`03G_Moogoo00Eoo`03G_Moogoo00Eoo`05G_MoogooOomNm`02Ool00`;Q
Oomoo`0?Ool00ekg001oo`0POol03E0GE1M@5e@GD1MD5e0GE1M@5e@GD1MD5e0G01Moo`00?7oo00<0
07ooOol04Goo00=NmgooOol08goo00=NmgooOol08Woo00=NmgooOol00Ukg8Woo00=NmgooOol04Goo
00=NmgooOol04Goo00ENmgooOomooekg00Moo`03G_Moogoo00Ioo`04G_ML55PDG1@3Ool00ekgOomo
o`05Ool00ekgOomoo`05Ool00ekgOomoo`06Ool01EkgOomooekgOol00`;Q3goo00=Nmgoo00008Goo
00eD5e0GE1M@5U@GD1MD5e0FE1M@5e@GD1ID5`0GOol003aoo`03001oogoo015oo`03G_Moogoo029o
o`03G_Moogoo02=oo`03G_Moogoo009oo`03G_Moogoo01moo`03G_Moogoo019oo`03G_Moogoo015o
o`04G_MoogooG_L7Ool00ekgOomoo`06Ool00ekgOomL5004Ool00ekgOomoo`05Ool00ekgOomoo`05
Ool00ekgOomoo`06Ool025kgOomooekgOol2i0;Q0^@?Ool00ekgOol0000QOol=B1LGOol003aoo`03
001oogoo015oo`03G_Moogoo029oo`03G_Moogoo02=oo`03G_Moogoo00=oo`03G_Moogoo01ioo`03
G_Moogoo019oo`03G_Moogoo015oo`03G_Mooekg00Uoo`03G_Moogoo00Eoo`03G_Mooe`B00Aoo`03
G_Moogoo00Eoo`03G_Moogoo00Eoo`03G_Moogoo00Ioo`04G_MooekgOol20^H00`;TOomoo`0=Ool0
15kgOomoo`008Goo00=85dPFC1L00TPG00I85T`GB1M85dPFC1L2B1LGOol003aoo`03001oogoo015o
o`03G_Moogoo029oo`03G_Moogoo02=oo`03G_Moogoo00Aoo`03G_Moogoo01eoo`03G_Moogoo01=o
o`03G_Moogoo011oo`03G_Mooekg00Uoo`03G_Moogoo00Eoo`04G_ML4U`BG183Ool00ekgOomoo`04
Ool00ekgOomoo`06Ool00ekgOomoo`07Ool2G_L017oo0^P2iP;X3goo00ANmgooOol0025oo`e85aMo
o`00?7oo00<007ooOol04Goo00=NmgooOol08Woo00=NmgooOol08goo00=NmgooOol01Goo0Ukg7Goo
00=NmgooOol04goo00=NmgooOol04Goo00=NmgooOol027oo00=NmgooOol01Goo00QNmgooG19L45`?
O01L0Ekg1Woo00=NmgooOol01Goo00=NmgooOol027oo0Ukg00<2j`;Z0^P03goo00ENmgooOomoo`00
025oo`0=@1Ll5d0G?1I05c`G@1Ll5T0G?1M05c`F@1L05goo000lOol00`00Oomoo`0AOol00ekgOomo
o`0ROol00ekgOomoo`0SOol00ekgOomoo`07Ool00ekgOomoo`0JOol00ekgOomoo`0DOol00ekgOomo
o`0@Ool00ekgOomoo`08Ool00ekgOomoo`05Ool015kgOomooe`?0g`000=L0GooOol017oo00=Nmgoo
Ool01Goo00=NmgooOol027oo00ANm`;]0^d2j`moo`03G_Moogoo009oo`03001oogoo01moo`e05aMo
o`00?7oo00<007ooOol04Goo00=NmgooOol08Woo00=NmgooOol08goo00=NmgooOol027oo00=Nmgoo
Ool06Goo00=NmgooOol057oo00=NmgooOol03goo0Ukg2Woo00=NmgooOol01Goo00QNmgooOomooe`=
O01L2ekg1Woo00=NmgooOol01Goo00=NmgooOol027oo00ANm`;_0^d2k`moo`04G_MoogooOol2000Q
Ool03D0G?1I05c`G@1Ll5T0G?1M05c`F@1Ll5d0G01Moo`00?7oo00<007ooOol04Goo00=NmgooOol0
8Woo00=NmgooOol08goo00=NmgooOol02Goo00=NmgooOol05goo00=NmgooOol05Woo00=NmgooOol0
3Woo00=NmgooG_L02Goo00=NmgooOol01Goo00=NmgooOol00Woo00=L2gooG_L01Woo00=NmgooOol0
1Goo00=NmgooOol027oo0P;b00<2kgooOol03Goo00=NmgooOol00goo00<007ooOol07goo00<d5cPG
=1L00S@G00Dh5c@G=1Ld5cPG00<d5aMoo`00?7oo00<007ooOol047oo00=NmgooOol08goo00=Nmgoo
Ool08goo00=NmgooOol02Woo0Ukg5goo00=NmgooOol05goo00=NmgooOol03Goo00=NmgooG_L02Woo
00=NmgooOol017oo00=NmgooOol017oo00=NmgooOol017oo00=NmgooOol01Goo00=NmgooOol01goo
0P;d00<2lWooOol03Woo00=NmgooOol00goo00<007ooOol07goo00dh5c@G>1Ld5SPG=1Lh5c@F>1Ld
5cPG=1Hh5`0GOol003aoo`03001oogoo011oo`03G_Moogoo02=oo`03G_Moogoo02=oo`03G_Moogoo
00aoo`03G_Moogoo01Aoo`03G_Moogoo01Moo`03G_Moogoo00eoo`03G_Mooekg00Yoo`03G_Moogoo
00Aoo`03G_Moogoo00Aoo`03G_Moogoo00Aoo`03G_Moogoo00Eoo`03G_Moogoo00Moo`040_H2m0;f
G_L>Ool00ekgOomoo`04Ool00`00Oomoo`0OOol3=1L01CPG=1Ld5c@G>1L00c@G00<h5c@GOol05Woo
000lOol00`00Oomoo`0@Ool00ekgOomoo`0SOol00ekgOomoo`0SOol00ekgOomoo`0=Ool00ekgOomo
o`0COol00ekgOomoo`0HOol00ekgOomoo`0;Ool01EkgOomoogooG_L02Goo00=NmgooOol01Goo00=N
mgooOol00goo00=NmgooOol017oo00=NmgooOol017oo00=NmgooOol01goo00D2]`:f0_Iooekg00eo
o`03G_Moogoo00Eoo`03001oogoo01moo`0=>1Ld5SPG=1Lh5c@F>1Ld5cPG=1Hh5c@G>1L05goo000l
Ool00`00Oomoo`0@Ool00ekgOomoo`0SOol00ekgOomoo`0ROol00ekgOomoo`0?Ool00ekgOomoo`0B
Ool00ekgOomoo`0HOol00ekgOomoo`0;Ool01EkgOomoogooG_L02Goo00=NmgooOol01Goo00=Nmgoo
Ool00goo00=NmgooOol017oo00=NmgooOol017oo00=NmgooOol01Woo0P9g00@2]gooOomNm`eoo`03
G_Moogoo00Eoo`03001oogoo01moo`d/5aMoo`00?7oo00<007ooOol047oo00=NmgooOol08goo00=N
mgooOol08Woo00=NmgooOol047oo0Ukg4Woo00=NmgooOol06Goo00=NmgooOol02Woo00ENmgooOomo
oekg00Uoo`03G_Moogoo00Eoo`03G_Moogoo00=oo`03G_Moogoo00Aoo`03G_Moogoo00Aoo`03G_Mo
ogoo00Ioo`030SL2M`8g009oo`03G_Moogoo00Yoo`03G_Moogoo00Ioo`03001oogoo01moo`</5`05
:1H/5b`G;1LX5P03;1L00bPF;1Moo`0FOol003aoo`03001oogoo011oo`03G_Moogoo02=oo`03G_Mo
ogoo029oo`03G_Moogoo019oo`03G_Moogoo00moo`03G_Moogoo01Yoo`03G_Moogoo00Uoo`03G_Mo
ogoo009oo`03G_Moogoo00Moo`03G_Moogoo00Aoo`03G_Moogoo00=oo`03G_Moogoo00Aoo`03G_Mo
ogoo00Aoo`03G_Moogoo00Eoo`81e`030SMoogoo009oo`03G_Moogoo00Uoo`03G_Moogoo00Ioo`03
001oogoo01moo`d/5aMoo`00?7oo00<007ooOol047oo00=NmgooOol08goo00=NmgooOol08Woo00=N
mgooOol04goo00=NmgooOol03Woo00=NmgooOol06Woo00=NmgooOol02Goo00=NmgooOol00Woo00=N
mgooOol01goo00=NmgooOol017oo00=NmgooOol00goo00=NmgooOol00goo00=NmgooOol01Goo00=N
mgooOol017oo0P6G00<1egooOol00goo00=NmgooOol027oo00=NmgooOol01goo00<007ooOol07goo
00dT5b0F91LP5b@G81HT5b0G91LP5R@G81LT5`0GOol003aoo`03001oogoo011oo`03G_Moogoo02=o
o`03G_Moogoo029oo`03G_Moogoo01Aoo`03G_Moogoo00aoo`03G_Moogoo01aoo`03G_Moogoo00Qo
o`03G_Moogoo009oo`03G_Moogoo00Moo`03G_Moogoo00Aoo`03G_Moogoo00=oo`03G_Moogoo00=o
o`03G_Moogoo00Aoo`03G_Moogoo00Aoo`81E`030IMNmgoo00Aoo`03G_Moogoo00Qoo`03G_Moogoo
00Moo`03001oogoo01moo`0=81LT5b0G91LP5b@G81LT5b0G91LP5b@G81L05goo000lOol00`00Oomo
o`0@Ool00ekgOomoo`0SOol00ekgOomoo`0ROol00ekgOomoo`0EOol2G_L<Ool00ekgOomoo`0LOol0
0ekgOomoo`07Ool00ekgOomoo`04Ool00ekgOomoo`06Ool00ekgOomoo`04Ool00ekgOomoo`03Ool0
0ekgOomoo`03Ool00ekgOomoo`04Ool00ekgOomoo`05Ool00`5GOomNm`05Ool00ekgOomoo`07Ool0
0ekgOomoo`08Ool00`00Oomoo`0OOol03B@G81LT5b0F91LP5b@G81HT5b0G91LP5R@G01Moo`00?7oo
00<007ooOol047oo00=NmgooOol08goo00=NmgooOol08Woo00=NmgooOol05goo00=NmgooOol02Goo
00=NmgooOol07Goo00=NmgooOol01Woo00=NmgooOol017oo00=NmgooOol01Woo00=NmgooOol017oo
00=NmgooOol00goo00=NmgooOol00goo00=NmgooOol017oo00=NmgooOol017oo0`3g1goo00=Nmgoo
Ool01Goo00=NmgooOol027oo0P008Goo3APG5goo000lOol00`00Oomoo`0@Ool00ekgOomoo`0SOol0
0ekgOomoo`0ROol00ekgOomoo`0HOol00ekgOomoo`08Ool00ekgOomoo`0MOol00ekgOomoo`06Ool0
0ekgOomoo`04Ool00ekgOomoo`07Ool00ekgOomoo`03Ool00ekgOomoo`03Ool00ekgOomoo`03Ool0
0ekgOomoo`04Ool00ekgOomoo`03Ool20;L00`3gG_Moo`06Ool00ekgOomoo`05Ool00ekgOomoo`09
Ool00`00Oomoo`0OOol00aPG61HL5`0261L01QPF71LH5aPG61HL5`8H5aMoo`00?7oo00<007ooOol0
47oo00=NmgooOol08Woo00=NmgooOol08goo00=NmgooOol06Goo00=NmgooOol01goo00=NmgooOol0
7Woo00=NmgooOol01Goo00=NmgooOol01Goo00=NmgooOol01Woo00=NmgooOol00goo00=NmgooOol0
0goo00=NmgooOol00goo00=NmgooOol017oo00=NmgooOol00Woo0P1g00<0]gooG_L01goo00=Nmgoo
Ool017oo00=NmgooOol02Woo00<007ooOol07goo3APG5goo000lOol00`00Oomoo`0@Ool00ekgOomo
o`0ROol00ekgOomoo`0SOol00ekgOomoo`0JOol2G_L7Ool00ekgOomoo`0OOol00ekgOomoo`03Ool0
0ekgOomoo`06Ool00ekgOomoo`06Ool00ekgOomoo`03Ool00ekgOomoo`03Ool00ekgOomoo`03Ool0
0ekgOomoo`03Ool00ekgOomoo`02Ool01@0G03L0MgooG_L02Goo00=NmgooOol00goo00=NmgooOol0
2Woo00<007ooOol07goo00d@5``G41L<5Q0G31L@5``F41L<5a0G31H@5`0GOol003aoo`03001oogoo
011oo`03G_Moogoo029oo`03G_Moogoo02=oo`03G_Moogoo01aoo`03G_Moogoo00Aoo`03G_Moogoo
01moo`03G_Moogoo00=oo`03G_Moogoo00Ioo`03G_Moogoo00Ioo`03G_Moogoo00Aoo`03G_Moogoo
009oo`03G_Moogoo00=oo`03G_Moogoo00=oo`07G_MoogooOol05`@G01L00Woo00=NmgooOol01goo
00=NmgooOol00Woo00=NmgooOol02goo00<007ooOol07goo3A0G5goo000lOol00`00Oomoo`0@Ool0
0ekgOomoo`0ROol00ekgOomoo`0SOol00ekgOomoo`0MOol00ekgOomoo`03Ool00ekgOomoo`0POol0
0ekgOomoo`02Ool00ekgOomoo`07Ool00ekgOomoo`05Ool00ekgOomoo`04Ool00ekgOomoo`02Ool0
0ekgOomoo`03Ool00ekgOomoo`03Ool00ekgOomoo`0231L01@0GOomoogooG_L02Goo00ENmgooOomo
oekg00ioo`03001oogoo01moo`0=41L<5Q0G31L@5``F41L<5a0G31H@5``G41L05goo000lOol00`00
Oomoo`0@Ool00ekgOomoo`0ROol00ekgOomoo`0SOol00ekgOomoo`0NOol00ekgOomoo`02Ool00ekg
Oomoo`0POol00ekgOomoo`02Ool00ekgOomoo`07Ool00ekgOomoo`06Ool00ekgOomoo`03Ool00ekg
Oomoo`02Ool00ekgOomoo`03Ool00ekgOomoo`03Ool01EkgOomooa@G31L00goo00=NmgooOol027oo
00ENmgooOomooekg00ioo`03001oogoo01moo`0311L85`@G00845`0521L45`@G11L85`0311LGOol0
03aoo`03001oogoo011oo`03G_Moogoo029oo`03G_Moogoo02=oo`03G_Moogoo01moo`9Nm`03OomN
mgoo02=oo`04G_MoogooG_L:Ool00ekgOomoo`06Ool00ekgOomoo`03Ool00ekgOomoo`02Ool00ekg
Oomoo`02Ool00ekgOomoo`04Ool01EkgOolD5a0F51L00goo00=NmgooOol02Goo00=NmgooG_L03goo
00<007ooOol07goo00d85`@G21L45PPG11L85`@F21L45`PG11H85`0GOol003aoo`03001oogoo011o
o`03G_Moogoo029oo`03G_Moogoo02=oo`03G_Moogoo025oo`9NmbAoo`04G_MoogooG_L;Ool00ekg
Oomoo`05Ool00ekgOomoo`03Ool00ekgOomoo`02Ool00ekgOomoo`02Ool00ekgOomoo`03Ool01Ekg
OolL5a`G51L017oo00=NmgooOol02Goo00=NmgooG_L03goo00<007ooOol07goo0`@G00D85`@G11L4
5`PG00<45`0321L45goo01Ioo`00<goo1@0017oo00<007ooOol047oo00=NmgooOol08Woo00=Nmgoo
Ool08goo00=NmgooOol08Woo00=NmgooOol04goo00<2h@;TOol03Goo00=NmgooG_L02goo00=Nmgoo
Ool01Goo00=NmgooOol00goo00=NmgooOol00Woo00=NmgooOol00Woo00=NmgooOol00goo00ANmbPG
91HL5`Aoo`03G_Moogoo00Yoo`9Nma1oo`03001oogoo01moo`0301L05P0G00805`0501H05`0G01L0
5P0301LGOol003Eoo`03001oogoo00Aoo`03001oogoo011oo`03G_Moogoo029oo`03G_Moogoo02=o
o`03G_Moogoo029oo`9Nma=oo`<2h@030^Aoogoo00aoo`9Nm`]oo`03G_Moogoo00Eoo`03G_Moogoo
00=oo`03G_Moogoo009oo`03G_Moogoo009oo`03G_Moogoo00=oo`8`5`03:1Moogoo00=oo`03G_Mo
ogoo00Yoo`9Nma1oo`03001oogoo01moo`d05aMoo`00;goo0`000goo00<007ooOol017oo0P004Goo
00=NmgooOol08Woo00=NmgooOol08goo00=NmgooOol08Woo00ANmgooG_MNma9oo`030^42i0;V00io
o`03G_Moogoo00]oo`03G_Moogoo00Aoo`03G_Moogoo00=oo`03G_Moogoo009oo`03G_Moogoo009o
o`03G_Moogoo00=oo`03>1L`5goo00Eoo`03G_Moogoo00Yoo`9Nm`ioo`<0025oo`<05`0501H05`0G
01L05P0301L00`0F01Moo`0FOol003Eoo`03001oogoo00Aoo`03001oogoo011oo`03G_Moogoo029o
o`03G_Moogoo02=oo`03G_Moogoo029oo`05G_MoogooOomNm`0BOol00`;V0^P2j00=Ool2G_L<Ool0
0ekgOomoo`05Ool00ekgOomoo`02Ool00ekgOomoo`02Ool00ekgOomoo`02Ool00ekgOomoo`02Ool3
>1L5Ool00ekgOomoo`0:Ool00ekgOomNm`0@Ool00`00Oomoo`0OOol=01LGOol003Eoo`03001oogoo
00Aoo`03001oogoo011oo`03G_Moogoo029oo`03G_Moogoo02=oo`03G_Moogoo029oo`03G_Moogoo
009oo`03G_Moogoo011oo`030^P2k@;]00aoo`9Nm`aoo`03G_Moogoo00Eoo`03G_Moogoo009oo`03
G_Moogoo009oo`03G_Moogoo009oo`04G_MoogooOol2A1L00cPGOomoo`04Ool00ekgOomoo`0:Ool0
0ekgOomNm`0@Ool00`00Oomoo`0OOol03@1G03H0E`0g05L0=P1G03L0E`0f05L0=`1G01Moo`00=7oo
0P001Woo00<007ooOol047oo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08goo00=Nmgoo
Ool00goo00=NmgooOol047oo00<2k@;_0^l02goo00=NmgooG_L037oo00=NmgooOol017oo00=Nmgoo
Ool00Woo00=NmgooOol00Woo00=NmgooOol00Woo00=NmgooOol00T`G00=45gooOol01Goo00=Nmgoo
Ool02Goo00ANmgooOomNma1oo`03001oogoo01moo`d0EaMoo`00?7oo00<007ooOol047oo00=Nmgoo
Ool08Woo00=NmgooOol08Woo00=NmgooOol08goo00=NmgooOol017oo0Ukg47oo00@2lP;_0_82m0Yo
o`04G_MoogooG_L;Ool00ekgOomoo`04Ool00ekgOomoo`03Ool01EkgOomoogooG_L017oo00INmgoo
E1Mood`GG_L6Ool00ekgOomoo`0:Ool015kgOomooekg47oo00<007ooOol07goo00d0E`0g05L0=P1G
03L0E`0f05L0=`1G03H0E`0GOol003aoo`03001oogoo011oo`03G_Moogoo029oo`03G_Moogoo029o
o`03G_Moogoo02=oo`03G_Moogoo00Ioo`03G_Moogoo00ioo`030_82m0;f00Uoo`05G_MoogooOomN
m`0;Ool00ekgOomoo`04Ool00ekgOomoo`03Ool01EkgOomoogooG_L017oo00INme@GE1MD5gooG_L6
Ool00ekgOomoo`09Ool00ekgOomoo`02Ool00ekgOomoo`0=Ool00`00Oomoo`0OOol=09LGOol003ao
o`03001oogoo011oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo02=oo`03G_Moogoo00Mo
o`03G_Moogoo00ioo`030_H2]P:g00Qoo`03G_Moogoo009oo`03G_Moogoo00Uoo`03G_Moogoo00Ao
o`03O01oogoo009oo`05G_MoogooOomNm`03Ool015`DG1IL5e@G0Woo00=NmgooOol017oo00=Nmgoo
Ool027oo00=NmgooOol00goo00=NmgooOol03Goo00<007ooOol07goo00<0U`2F09L00P2G00D0UP2G
09L0U`2F00<0UaMoo`00?7oo00<007ooOol047oo00=NmgooOol08Woo00=NmgooOol08Woo00=Nmgoo
Ool08Woo00=NmgooOol02Goo00=NmgooOol03Goo00<2M`:g0WL027oo00=NmgooOol00Woo00=Nmgoo
Ool02Goo00=NmgooOol00goo0g`00goo00ENmgooOomooekg009oo`=L5004G1IoogooG_L6Ool00ekg
Oomoo`09Ool00ekgOomoo`03Ool00ekgOomoo`0=Ool00`00Oomoo`0OOol=09LGOol003aoo`03001o
ogoo011oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo00Yoo`9Nm`io
o`030WL2=`8g00Moo`03G_Moogoo00=oo`03G_Moogoo00Qoo`03G_Moogoo00Aoo`03O01L25`6009o
o`09G_MoogooOomNmgooG19ooe`D00Aoo`03G_Moogoo00Aoo`03G_Moogoo00Qoo`03G_Moogoo00Ao
o`03G_Moogoo00eoo`03001oogoo01moo`0=0?L0e`3g0=H0m`3G0?L0eP3g0=L0m`3F0?L05goo000l
Ool00`00Oomoo`0@Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0<
Ool00ekgOomoo`0;Ool00`7G0SL1e`07Ool00ekgOomoo`03Ool00ekgOomoo`09Ool00ekgOomoo`03
Ool3G0P00e`;OomNm`02Ool00e`?G_ML4P02G1800ekgOomoo`02Ool00ekgOomoo`04Ool00ekgOomo
o`08Ool00ekgOomoo`04Ool00ekgOomoo`0=Ool00`00Oomoo`0OOol=0=LGOol003aoo`03001oogoo
011oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo00eoo`03G_Moogoo
00]oo`030ML1U`6G00Ioo`03G_Moogoo00Aoo`03G_Moogoo00Qoo`03G_Moogoo00=oo`03G_ML25`;
009L2`03G0eooe`?009L3`04OomL4WooG_L4Ool00ekgOomoo`03Ool00ekgOomoo`08Ool00ekgOomo
o`05Ool00ekgOomoo`0=Ool00`00Oomoo`0OOol03@3g0=H0m`3G0?L0eP3g0=L0m`3F0?L0e`3g01Mo
o`00?7oo00<007ooOol047oo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo00=Nmgoo
Ool03Woo00=NmgooOol02goo00<1U`5G0EL017oo00=NmgooOol01Woo00=NmgooOol01goo00=Nmgoo
Ool017oo00=NmgooG0/00e`=00=ooe`?G_L00goo00=NmgooOol00Woo00=NmgooOol00goo00=Nmgoo
Ool027oo00=NmgooOol01Woo00=NmgooOol02goo0P008Goo3@4g5goo000lOol00`00Oomoo`0@Ool0
0ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0?Ool2G_L<Ool00`5GOomo
o`03Ool00ekgOomoo`06Ool00ekgOomoo`08Ool00ekgOomoo`03Ool01EkgOomoogooG0d00goo00EN
mgooOomooekg00=oo`03G_Moogoo00Aoo`03G_Moogoo00Moo`03G_Moogoo00Moo`03G_Moogoo00ao
o`03001oogoo01moo`<1=`050CH1=`4g0CL1=P030CL00`4f0CMoo`0FOol003aoo`03001oogoo011o
o`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo015oo`03G_Moogoo00Qo
o`<0m`Aoo`03G_Moogoo00Moo`03G_Moogoo00Moo`03G_Moogoo00=oo`05G_MoogooOomNm`03Ool0
1EkgOomoogooG_L00goo00=NmgooOol00goo00=NmgooOol01goo00=NmgooOol027oo00=NmgooOol0
37oo00<007ooOol07goo3@4g5goo000lOol00`00Oomoo`0@Ool00ekgOomoo`0ROol00ekgOomoo`0R
Ool00ekgOomoo`0ROol00ekgOomoo`0BOol00ekgOomoo`08Ool00`3g0;H0]`03Ool00ekgOomoo`07
Ool00ekgOomoo`07Ool00ekgOomoo`03Ool01EkgOomoogooG_L00goo00ENmgooOomooekg00=oo`03
G_Moogoo00=oo`03G_Moogoo00Moo`03G_Moogoo00Qoo`03G_Moogoo00aoo`03001oogoo01moo`03
0GL1MP5g0081M`050GH1M`5g0GL1MP030GLGOol003aoo`03001oogoo011oo`03G_Moogoo029oo`03
G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo01=oo`03G_Moogoo00Qoo`030;L0M`1g009oo`03
G_Moogoo00Qoo`03G_Moogoo00Moo`03G_Moogoo009oo`05G_MoogooOomNm`03Ool01EkgOomoogoo
G_L00goo00=NmgooOol00goo00=NmgooOol01Woo00=NmgooOol02Goo00=NmgooOol037oo00=Nmgoo
Ool07goo3@5g5goo000lOol00`00Oomoo`0@Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomo
o`0ROol00ekgOomoo`0DOol00ekgOomoo`08Ool01@1gOomoogooG_L02Woo00=NmgooOol01goo00=N
mgooOol00goo00ENmgooOomooekg009oo`05G_MoogooOomNm`03Ool00ekgOomoo`02Ool00ekgOomo
o`07Ool00ekgOomoo`09Ool00ekgOomoo`0;Ool00ekg001oo`0POol30GL01@5f0GL1M`5g0GH00`5g
00<1MP5gOol05Woo000lOol00`00Oomoo`0@Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomo
o`0ROol00ekgOomoo`0EOol2G_L7Ool301L2Ool00ekgOomoo`09Ool00ekgOomoo`06Ool00ekgOomo
o`03Ool01EkgOomoogooG_L00Woo00ENmgooOomooekg009oo`03G_Moogoo00=oo`03G_Moogoo00Io
o`03G_Moogoo00Yoo`03G_Moogoo00Uoo`9Nm`03Ool007oo021oo`d1MaMoo`00?7oo00<007ooOol0
47oo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol05goo00=NmgooOol0
1Goo00D05`@G01Mooekg00aoo`03G_Moogoo00Ioo`03G_Moogoo009oo`05G_MoogooOomNm`02Ool0
15kgOomooekg0goo00=NmgooOol00Woo00=NmgooOol01goo00=NmgooOol02Woo00=NmgooOol027oo
00ENmgooOomoo`00025oo`0=0ML1]P7G0KL1e`6f0ML1]`7G0KH1e`6g0ML05goo000lOol00`00Oomo
o`0@Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0HOol00ekgOomo
o`05Ool0100G31Mooekg37oo00=NmgooOol01Woo00=NmgooOol00Woo00ENmgooOomooekg009oo`04
G_MoogooG_L3Ool00ekgOomoo`02Ool00ekgOomoo`06Ool00ekgOomoo`0;Ool00ekgOomoo`07Ool0
0ekgOomoo`02Ool00`00Oomoo`0OOol=0MLGOol003aoo`03001oogoo011oo`03G_Moogoo029oo`03
G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo01Uoo`03G_Moogoo00Aoo`<<5`03G_Moogoo00]o
o`03G_Moogoo00Eoo`03G_Moogoo009oo`05G_MoogooOomNm`02Ool015kgOomooekg0goo00=Nmgoo
Ool00Woo00=NmgooOol01Goo00=NmgooOol037oo00=NmgooOol01Woo00=NmgooOol00goo00<007oo
Ool07goo00d1e`6g0ML1]P7G0KL1e`6f0ML1]`7G0KH1e`0GOol003aoo`03001oogoo00moo`03G_Mo
ogoo02=oo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo01]oo`9Nm`Eoo`0331LD5goo00eo
o`03G_Moogoo00Ioo`03G_Moogoo009oo`04G_MoogooG_L2Ool015kgOomooekg0goo00ENmgooOomo
oekg00Qoo`03G_Moogoo00eoo`03G_Moogoo00=oo`9Nm`Ioo`03001oogoo01moo`d25aMoo`00?7oo
00<007ooOol03goo00=NmgooOol08goo00=NmgooOol08Woo00=NmgooOol08Goo00=NmgooOol07Goo
00=NmgooOol00Woo00<D5a0F51L03Woo00=NmgooOol01Goo00=NmgooOol00Woo00ANmgooOomNm`9o
o`04G_MoogooG_L2Ool00ekgOomoo`02Ool00ekgOomoo`05Ool00ekgOomoo`0>Ool00ekgOomoo`02
Ool00ekgOomoo`05Ool2000QOol00`8G0QH25`020QL01@8F0QL25`8G0QH00`8G5goo000lOol00`00
Oomoo`0?Ool00ekgOomoo`0SOol00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0NOol00ekg
Oomoo`02Ool00a@GOomoo`0=Ool00ekgOomoo`05Ool00ekgOomoo`02Ool015kgOomooekg0Woo00AN
mgooOomNm`9oo`03G_Moogoo009oo`03G_Moogoo00Eoo`03G_Moogoo00ioo`05G_MoogooOomNm`09
Ool00`00Oomoo`0OOol=0QLGOol003aoo`03001oogoo00moo`03G_Moogoo02=oo`03G_Moogoo029o
o`03G_Moogoo025oo`03G_Moogoo01moo`03G_Moogoo00<L5`moo`03G_Moogoo00Eoo`05G_Moogoo
OomNm`02Ool015kgOomooekg0Woo00ANmgooOomNm`=oo`03G_Moogoo00Eoo`03G_Moogoo00moo`04
G_MoogooG_L:Ool00`00Oomoo`0OOol03@9g0UL2M`9F0WL2E`9g0UH2M`9G0WL2EP9g01Moo`00?7oo
00<007ooOol03goo00=NmgooOol08goo00=NmgooOol08Woo00=NmgooOol08Goo00=NmgooOol087oo
0Ukg00=ooa`G:1L047oo00=NmgooOol017oo00ENmgooOomooekg009oo`04G_MoogooG_L2Ool015kg
Oomooekg0goo00=NmgooOol017oo00=NmgooOol047oo0ekg2goo00<007ooOol07goo3@9G5goo000l
Ool00`00Oomoo`0?Ool00ekgOomoo`0SOol00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0R
Ool015kg:1LX5bPG3goo00=NmgooOol017oo00ENmgooOomooekg009oo`04G_MoogooG_L2Ool015kg
Oomooekg0goo00=NmgooOol017oo00=NmgooOol047oo00=NmgooOol02goo00<007ooOol07goo00d2
M`9F0WL2E`9g0UH2M`9G0WL2EP9g0UL2M`0GOol003aoo`03001oogoo00moo`03G_Moogoo02=oo`03
G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo02=oo`03G_LX5goo011oo`03G_Moogoo00Aoo`05
G_MoogooOomNm`02Ool00ekgOomNm`02Ool00ekgOomNm`03Ool00ekgOomoo`04Ool00ekgOomoo`0@
Ool2G_L=Ool00`00Oomoo`0OOol=0[LGOol003aoo`03001oogoo00moo`03G_Moogoo029oo`03G_Mo
ogoo02=oo`03G_Moogoo025oo`03G_Moogoo02=oo`9Nm`03<1Moogoo00ioo`03G_Moogoo00Aoo`05
G_MoogooOomNm`02Ool00ekgOomNm`02Ool00ekgOomNm`03Ool00ekgOomoo`04Ool00ekgOomoo`0?
Ool00ekgOomNm`0=Ool00`00Oomoo`0OOol30[L01@:f0[L2]`:g0[H00`:g00<2]P:gOol05Woo000l
Ool00`00Oomoo`0?Ool00ekgOomoo`0ROol00ekgOomoo`0SOol00ekgOomoo`0QOol00ekgOomoo`0S
Ool015kg<1L`5c0G47oo00=NmgooOol00goo00ENmgooOomooekg009oo`05G_MooekgOomNm`02Ool0
1EkgOomoogooG_L01Goo00=NmgooOol03Woo0Ukg0Woo00=NmgooOol02goo00<007ooOol07goo3@:g
5goo000lOol00`00Oomoo`0?Ool00ekgOomoo`0ROol00ekgOomoo`0SOol00ekgOomoo`0QOol00ekg
Oomoo`0SOol01EkgOol`5gooG_L047oo00=NmgooOol00goo00ANmgooOomNm`9oo`05G_MooekgOomN
m`02Ool015kgOomooekg1Woo00=NmgooOol03Goo00=NmgooOol00Woo00=NmgooOol02goo00<007oo
Ool07goo00<2m`;f0_L00P;g00D2mP;g0_L2m`;f00<2maMoo`00?7oo00<007ooOol03goo00=Nmgoo
Ool08Woo00=NmgooOol08goo00=NmgooOol08Goo00=NmgooOol08goo00=NmgooOol00Woo00=Nmgoo
Ool03Goo00=NmgooOol00goo00ANmgooOomNm`9oo`05G_MooekgOomNm`02Ool015kgOomooekg1Goo
00=NmgooOol03Goo00=NmgooOol00goo00=NmgooOol02goo00<007ooOol07goo3@;g5goo000lOol0
0`00Oomoo`0?Ool00ekgOomoo`0ROol00ekgOomoo`0SOol00ekgOomoo`0QOol00ekgOomoo`0SOol0
15kgOomoocPG0Woo00=NmgooOol03Goo00=NmgooOol00Woo00]NmgooOomooekgOomNmgooG_Mooekg
009oo`04G_MoogooG_L4Ool00ekgOomoo`0=Ool00ekgOomoo`04Ool00ekgOomoo`0;Ool00`00Oomo
o`0OOol30_L01@;f0_L2m`;g0_H00`;g00<2mP;gOol05Woo000lOol00`00Oomoo`0?Ool00ekgOomo
o`0ROol00ekgOomoo`0SOol00ekgOomoo`0QOol00ekgOomoo`0SOol00ekgOolh5`02>1L2Ool2G_L=
Ool00ekgOomoo`03Ool035kgOomooekgOomNmgooG_MooekgOomNm`9oo`03G_Moogoo00=oo`03G_Mo
ogoo00]oo`9Nm`Moo`03G_Moogoo00Yoo`80025oo`d2maMoo`00?7oo00<007ooOol03goo00=Nmgoo
Ool08Woo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo00ENmgooOomoocPG00Eoo`03
G_Moogoo00]oo`03G_Moogoo009oo`0<G_MoogooG_MooekgOomNmgooG_Mooekg0Woo00=NmgooOol0
0Woo00=NmgooOol02goo00=NmgooOol027oo00=NmgooOol02Woo00<007ooOol07goo00d2m@;d0_D2
m0;e0_@2m@;d0_D2m0;e0_@2m@0GOol003aoo`03001oogoo00moo`03G_Moogoo029oo`03G_Moogoo
029oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo00Qoo`03G_Moogoo00Yoo`03G_Moogoo
009oo`0<G_MoogooG_MooekgOomNmgooG_Mooekg0Woo00=NmgooOol00Woo00=NmgooOol02Woo00=N
mgooOol02Goo00=NmgooOol02Woo00<007ooOol07goo00d2m0;e0_@2m@;d0_D2m0;e0_@2m@;d0_D2
m00GOol003aoo`03001oogoo00moo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`03
G_Moogoo029oo`03G_Moogoo009oo`03A1Moogoo00Aoo`03G_Moogoo00Yoo`03G_Moogoo009oo`0=
G_MooekgOomNmgooG_MooekgOomNmgooG_L017oo00=NmgooOol02Woo00=NmgooOol02Woo00=Nmgoo
Ool02Woo00<007ooOol07goo00d2m@;d0_D2m0;e0_@2m@;d0_D2m0;e0_@2m@0GOol003aoo`03001o
ogoo00moo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`04G_Mo
ogooOol3A1L6Ool2G_L;Ool01EkgOomoogooG_L00Woo0Ukg00QooekgOomNmgooG_Mooekg0goo00=N
mgooOol02Goo0Ukg3Goo00=NmgooOol02Woo00<007ooOol07goo3@;b5goo000lOol00`00Oomoo`0?
Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`02
Ool00d@GOomoo`07Ool00ekgOomoo`08Ool01EkgOomoogooG_L00Woo00ENmgooG_MNmgoo009Nm`9o
o`05G_MoogooOomNm`0:Ool00ekgOomoo`0=Ool00ekgOomoo`0:Ool00`00Oomoo`0OOol20_801@;c
0_82lP;b0_<00`;b00<2l`;b0_805goo000lOol00`00Oomoo`0?Ool00ekgOomoo`0ROol00ekgOomo
o`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0=Ool00ekgOomoo`08Ool025kgOomo
ogooG_MooekgOol3G_L017ooG_Mooekg0goo00=NmgooOol027oo00=NmgooOol03Woo00=NmgooOol0
2Woo00<007ooOol07goo3@;b5goo000lOol00`00Oomoo`0?Ool00ekgOomoo`0ROol00ekgOomoo`0R
Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0>Ool00ekgOomoo`07Ool025kgOomoogoo
G_MooekgOol3G_L017ooG_Mooekg0goo00=NmgooOol01goo00=NmgooOol03goo00=NmgooOol02Woo
00<007ooOol07goo00d2l0;_0_02k`;`0^l2l0;_0_02k`;`0^l2l00GOol003aoo`03001oogoo00mo
o`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo00mo
o`9Nm`Qoo`07G_MoogooG_MooekgOol00ekg00AooekgOomNm`9oo`03G_Moogoo00Ioo`9Nma9oo`03
G_Moogoo00Yoo`03001oogoo01moo`d2l1Moo`00?7oo00<007ooOol03goo00=NmgooOol08Woo00=N
mgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol00goo00=<5gooOol02goo00=N
mgooOol01Goo00INmgooOomooekgOol4G_L00gooG_MNm`03Ool00ekgOomoo`05Ool00ekgOomoo`0B
Ool00ekgOomoo`0:Ool00`00Oomoo`0OOol03@;`0^l2l0;_0_02k`;`0^l2l0;_0_02k`;`01Moo`00
?7oo00<007ooOol03goo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol0
8Woo00=NmgooOol00Woo0d`G3Goo00=NmgooOol01Goo00ENmgooOomNmgoo00ENm`05OomNmgooOomN
m`07Ool00ekgOomoo`0COol00ekgOomoo`0:Ool00`00Oomoo`0OOol00`;]0^h2k@020^d01@;^0^d2
k@;]0^h00`;]5goo000lOol00`00Oomoo`0?Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomo
o`0ROol00ekgOomoo`0ROol00ekgOomoo`03Ool00d`GOomoo`0=Ool00ekgOomoo`05Ool015kgOomN
mgoo1Ekg00AooekgOomNm`Moo`03G_Moogoo01Aoo`03G_Moogoo00Uoo`80025oo`0=0^h2k@;^0^d2
kP;]0^h2k@;^0^d2kP;]0^h05goo000lOol00`00Oomoo`0?Ool00ekgOomoo`0ROol00ekgOomoo`0R
Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0DOol2G_L5Ool00ekgOomoo`07G_L2Ool0
0ekgOomoo`03Ool2G_LGOol00ekgOomoo`0:Ool00`00Oomoo`0OOol30^d01@;^0^d2k@;]0^h00`;]
00<2kP;]Ool05Woo000lOol00`00Oomoo`0?Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomo
o`0ROol00ekgOomoo`0ROol00ekgOomoo`0FOol00ekgOomoo`03Ool00ekgOomNm`06G_L00gooG_Mo
o`04Ool00ekgOomoo`0GOol00ekgOomoo`0:Ool00`00Oomoo`0OOol00`;[0^X2j`020^/01@;Z0^/2
j`;[0^X00`;[5goo000lOol00`00Oomoo`0?Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomo
o`0ROol00ekgOomoo`0ROol00ekgOomoo`0GOol00ekgOomoo`02Ool00ekgOomNm`06G_L00gooG_Mo
o`03Ool00ekgOomoo`0HOol00ekgOomoo`0:Ool00`00Oomoo`0OOol=0^/GOol003aoo`03001oogoo
00moo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo
01Uoo`03G_Moogoo009oo`03G_Mooekg00ANm`03OomNmgoo00=oo`03G_Moogoo01Uoo`03G_Moogoo
00Yoo`03001oogoo01moo`<2j`050^X2j`;[0^/2jP030^/00`;Z0^]oo`0FOol003aoo`03001oogoo
00moo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo
01Yoo`9Nm`=oo`MNm`=oo`9Nmaaoo`03G_Moogoo00Yoo`03001oogoo01moo`d2jaMoo`00?7oo00<0
07ooOol03goo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Goo00=N
mgooOol077oo00=NmgooOol01ekg0Woo00=NmgooOol077oo00=NmgooOol02Woo00<007ooOol07goo
00d2j@;X0^T2j0;Y0^P2j@;X0^T2j0;Y0^P2j@0GOol001Yoo`8000Qoo`8001Ioo`03001oogoo00mo
o`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo01eo
o`03G_Moogoo00ENm`9oo`03G_Moogoo01eoo`03G_Moogoo00Yoo`03001oogoo01moo`0=0^P2j@;X
0^T2j0;Y0^P2j@;X0^T2j0;Y0^P05goo000JOol00`00Oomoo`08Ool00`00Oomoo`0DOol00`00Oomo
o`0?Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomo
o`0NOol00ekgOomNm`04G_L00gooG_Moo`0OOol00ekgOomoo`0:Ool00`00Oomoo`0OOol03@;Y0^P2
j@;X0^T2j0;Y0^P2j@;X0^T2j0;Y01Moo`0037oo0`0000Ioo`00Ool007oo0005Ool01000Oomoogoo
0P001Goo00<007ooOol03Goo00<007ooOol017oo00<007ooOol03goo00=NmgooOol08Woo00=Nmgoo
Ool08Woo00=NmgooOol08Woo00=NmgooOol08Goo00=NmgooOol07goo1ekg8Goo00=NmgooOol02Woo
00<007ooOol07goo3@;V5goo000=Ool02000Oomoo`00Ool007oo0005Ool00`00Oomoo`03Ool00`00
Oomoo`02Ool00`00Oomoo`0<Ool00`00Ool00005Ool00`00Oomoo`0?Ool00`?POomoo`0ROol00ekg
Oomoo`0ROol00ekgOomoo`0?Ool00g`00^5oo`0@Ool00`?POomoo`0QOol01W`0G0mL55`FOomD5`Ao
o`03E1Moogoo009oo`04G1IoogooG1@3Ool015`BOomooe`?17oo00UL3GooOomooe`;OomL27`0G_L0
8goo00=NmgooOol02Woo00<007ooOol07goo0P;V00D2i`;V0^H2iP;W00<2iP030^L2iP;V01Moo`00
3Goo00P007ooOol007oo001oo`001Goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol037oo
00<007oo00001Goo4Ekg0`?PFEkg0g`000<2hEkgG_L03Ekg0`?P8Ekg0g`00U`F0e@G0Ukg0e@G0Ukg
0e`F0e`D00ANme`BG19L4P=L3`9Nm`=L3@04G_ML2e`;G0/3O00aG_LQOol=0^HGOol000eoo`03001o
ogoo00800003Ool007oo00Eoo`03001oogoo009oo`8000Aoo`03001oogoo00aoo`03001oo`0000Eo
o`03001oogoo00moo`030n1oogoo029oo`03G_Moogoo029oo`03G_Moogoo00moo`03O002hGoo011o
o`030n1oogoo025oo`06O01L3e`DG1Iooe@G17oo00=D5gooOol00Woo00AL5WooOomL50=oo`04G19o
ogooG0l4Ool02E`=OomoogooG0]ooe`8O01Nm`0SOol00ekgOomoo`0:Ool00`00Oomoo`0OOol03@;T
0^<2i0;S0^@2h`;T0^<2i0;S0^@2h`;T01Moo`003Goo00<007ooOol02Woo00<007ooOol027oo00<0
07ooOol037oo00<007oo00001Goo00<007ooOol03goo00=NmgooOol08Woo00=NmgooOol08Woo00=N
mgooOol08Woo00=NmgooOol08Goo00=NmgooOol07goo1ekg8Goo00=NmgooOol02Woo00<007ooOol0
7goo3@;T5goo000<Ool3000;Ool20008Ool2000?Ool00`00Oomoo`04Ool00`00Oomoo`0?Ool00ekg
Oomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0NOol00ekg
OomNm`04G_L00gooG_Moo`0OOol00ekgOomoo`0:Ool00`00Oomoo`0OOol03@;T0^<2i0;S0^@2h`;T
0^<2i0;S0^@2h`;T00Aoo`<0009oo`03001oogoo009oo`03001oogoo00Ioo`00?7oo00<007ooOol0
3goo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Goo00=NmgooOol0
7Goo00=NmgooOol01Ekg0Woo00=NmgooOol07Goo00=NmgooOol02Woo00<007ooOol07goo00<2h@;R
0^400P;Q00D2hP;Q0^42h@;R00<2h@Eoo`06001oogoo001oo`0037oo000lOol00`00Oomoo`0?Ool0
0ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0QOol00ekgOomoo`0LOol0
0ekgOomoo`07G_L2Ool2G_LMOol00ekgOomoo`0:Ool00`00Oomoo`0OOol03@;R0^42hP;Q0^82h@;R
0^42hP;Q0^82h@;R00=oo`@00004Ool007oo000<Ool003aoo`03001oogoo00moo`03G_Moogoo029o
o`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo01Yoo`9Nm`=oo`INm`03
OomNmgoo009oo`03G_Moogoo01Yoo`03G_Moogoo00Yoo`03001oogoo01moo`<2h@050^82h@;Q0^42
hP030^400`;R0^5oo`02Ool00`00Ool00002Ool00`00Ool0000<Ool003aoo`03001oogoo00moo`03
G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo01Qoo`03
G_Moogoo009oo`03G_Mooekg00ANm`03OomNmgoo00=oo`03G_Moogoo01Uoo`03G_Moogoo00Yoo`03
001oogoo031oo`80009oo`03001oo`0000aoo`00?7oo00<007ooOol03goo00=NmgooOol08Woo00=N
mgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol05goo00=NmgooOol00Woo00=N
mgooG_L01Ukg00=ooekgOol00goo00=NmgooOol067oo00=NmgooOol02Woo00<007ooOol0<Goo00D0
07ooOomoo`0000eoo`00?7oo00<007ooOol03goo00=NmgooOol08Woo00=NmgooOol08Woo00=Nmgoo
Ool08Woo00=NmgooOol08Woo00=NmgooOol05Woo00=NmgooOol00goo00=NmgooG_L01Ukg00=ooekg
Ool017oo0Ukg67oo00=NmgooOol02Woo00<007ooOol0@goo000lOol00`00Oomoo`0?Ool00ekgOomo
o`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0DOol2G_L5Ool0
0ekgOomoo`07G_L2Ool00ekgOomoo`04Ool00ekgOomoo`0EOol00ekgOomoo`0:Ool00`00Oomoo`13
Ool003aoo`03001oogoo00moo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Mo
ogoo029oo`03G_Moogoo00=oo`03C1Moogoo00eoo`03G_Moogoo00Eoo`04G_MooekgOol5G_L017oo
G_Mooekg1goo00=NmgooOol057oo00=NmgooOol02Goo0P00AGoo000lOol00`00Oomoo`0?Ool00ekg
Oomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`02Ool3C1L=
Ool00ekgOomoo`05Ool01EkgOomooekgOol01Ekg00EooekgOomooekg00Moo`9NmaAoo`03G_Moogoo
00Yoo`03001oogoo04=oo`00?7oo00<007ooOol03goo00=NmgooOol08Woo00=NmgooOol08Woo00=N
mgooOol08Woo00=NmgooOol08Woo00=NmgooOol00goo00=<5gooOol02goo00=NmgooOol01Goo00IN
mgooOomooekgOol4G_L00gooG_MNm`03Ool00ekgOomoo`06Ool00ekgOomoo`0AOol00ekgOomoo`0:
Ool00`00Oomoo`13Ool003aoo`03001oogoo00moo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Mo
ogoo029oo`03G_Moogoo029oo`03G_Moogoo00moo`9Nm`Qoo`07G_MoogooG_MooekgOol00ekg00Ao
oekgOomNm`9oo`03G_Moogoo00Moo`03G_Moogoo011oo`03G_Moogoo00Yoo`03001oogoo04=oo`00
?7oo00<007ooOol03goo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol0
8Woo00=NmgooOol03Woo00=NmgooOol01goo00QNmgooOomooekgOomNmgoo0ekg00AooekgOomNm`=o
o`03G_Moogoo00Moo`03G_Moogoo00moo`03G_Moogoo00Yoo`03001oogoo04=oo`00?7oo00<007oo
Ool03goo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo00=Nmgoo
Ool03Goo00=NmgooOol027oo00QNmgooOomooekgOomNmgoo0ekg00AooekgOomNm`=oo`03G_Moogoo
00Qoo`9Nm`moo`03G_Moogoo00Yoo`03001oogoo04=oo`00?7oo00<007ooOol03goo00=NmgooOol0
8Woo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol00Woo00=45gooOol0
1goo00=NmgooOol027oo00ENmgooOomooekg009oo`9Nm`03OomNmgoo009Nm`9oo`05G_MoogooOomN
m`0;Ool00ekgOomoo`0<Ool00ekgOomoo`0:Ool00`00Oomoo`13Ool003aoo`03001oogoo00moo`03
G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`04G_MoogooOol3A1L6
Ool2G_L;Ool01EkgOomoogooG_L00Woo0Ukg00QooekgOomNmgooG_Mooekg17oo00=NmgooOol02Goo
00=NmgooOol02goo00=NmgooOol02Woo00<007ooOol0@goo000lOol00`00Oomoo`0?Ool00ekgOomo
o`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`02Ool00d@GOomo
o`04Ool00ekgOomoo`0:Ool00ekgOomoo`02Ool03EkgOomNmgooG_MooekgOomNmgooG_Mooekg00Ao
o`03G_Moogoo00Yoo`03G_Moogoo00Yoo`03G_Moogoo00Yoo`03001oogoo04=oo`00?7oo00<007oo
Ool03goo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo00=Nmgoo
Ool027oo00=NmgooOol02Woo00=NmgooOol00Woo00aNmgooOomNmgooG_MooekgOomNmgooG_L2Ool0
0ekgOomoo`02Ool00ekgOomoo`0:Ool2G_L:Ool00ekgOomoo`0:Ool00`00Oomoo`13Ool003aoo`03
001oogoo00moo`03G_Moogoo029oo`03G_Moogoo02=oo`03G_Moogoo025oo`03G_Moogoo02=oo`04
G_Moogoo>1L5Ool00ekgOomoo`0;Ool00ekgOomoo`02Ool035kgOomooekgOomNmgooG_MooekgOomN
m`9oo`03G_Moogoo009oo`03G_Moogoo00aoo`03G_Moogoo00Ioo`03G_Moogoo00]oo`03001oogoo
04=oo`00?7oo00<007ooOol03goo00=NmgooOol08Woo00=NmgooOol08goo00=NmgooOol08Goo00=N
mgooOol08goo00=Nmgoo>1L00SPG0Woo0Ukg3Goo00=NmgooOol00goo00aNmgooOomNmgooG_Mooekg
OomNmgooG_L2Ool00ekgOomoo`03Ool00ekgOomoo`0<Ool00ekgOomoo`05Ool00ekgOomoo`0:Ool2
0015Ool003aoo`03001oogoo00moo`03G_Moogoo029oo`03G_Moogoo02=oo`03G_Moogoo025oo`03
G_Moogoo02=oo`04G_Moogoo>1L2Ool00ekgOomoo`0=Ool00ekgOomoo`02Ool02ekgOomoogooG_Mo
oekgOomNmgooG_L00Woo00ANmgooOomNm`Eoo`03G_Moogoo00aoo`9Nm`Eoo`03G_Moogoo00]oo`03
001oogoo04=oo`00?7oo00<007ooOol03goo00=NmgooOol08Woo00=NmgooOol08goo00=NmgooOol0
8Goo00=NmgooOol08goo00=Nmgoo<1L00Woo00=NmgooOol03Goo00=NmgooOol00goo00ANmgooOomN
m`9oo`05G_MooekgOomNm`02Ool015kgOomooekg1Goo00=NmgooOol03Woo00=NmgooOol00Woo00=N
mgooOol02goo00<007ooOol0@goo000lOol00`00Oomoo`0?Ool00ekgOomoo`0ROol00ekgOomoo`0S
Ool00ekgOomoo`0QOol00ekgOomoo`0SOol01Ekg<1L/5S0GG_L047oo00=NmgooOol00goo00ANmgoo
OomNm`9oo`05G_MooekgOomNm`02Ool01EkgOomoogooG_L01Goo00=NmgooOol03Woo00ENmgooOomo
oekg00eoo`03001oogoo04=oo`00?7oo00<007ooOol03goo00=NmgooOol08Woo00=NmgooOol08goo
00=NmgooOol08Goo00=NmgooOol08goo00ANmgoo<1MNma1oo`03G_Moogoo00=oo`05G_MoogooOomN
m`02Ool01EkgOomNmgooG_L00Woo00ENmgooOomooekg00Eoo`03G_Moogoo00moo`04G_MoogooG_L=
Ool00`00Oomoo`13Ool003aoo`03001oogoo00moo`03G_Moogoo029oo`03G_Moogoo02=oo`03G_Mo
ogoo025oo`03G_Moogoo02=oo`03G_LX5goo011oo`03G_Moogoo00Aoo`05G_MoogooOomNm`02Ool0
0ekgOomNm`02Ool00ekgOomNm`03Ool00ekgOomoo`04Ool00ekgOomoo`0?Ool3G_L=Ool00`00Oomo
o`13Ool003aoo`03001oogoo00moo`03G_Moogoo02=oo`03G_Moogoo029oo`03G_Moogoo025oo`03
G_Moogoo02=oo`03:1LT5bPG011oo`03G_Moogoo00Aoo`05G_MoogooOomNm`02Ool00ekgOomNm`02
Ool00ekgOomNm`04Ool00ekgOomoo`03Ool00ekgOomoo`0AOol00ekgOomoo`0;Ool00`00Oomoo`13
Ool003aoo`03001oogoo00moo`03G_Moogoo02=oo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Mo
ogoo029oo`03G_LL5bPG011oo`03G_Moogoo00Aoo`05G_MoogooOomNm`02Ool015kgOomooekg0Woo
00ANmgooOomNm`=oo`03G_Moogoo00Aoo`03G_Moogoo011oo`9Nm`aoo`03001oogoo04=oo`00?7oo
00<007ooOol03goo00=NmgooOol08goo00=NmgooOol08Woo00=NmgooOol08Goo00=NmgooOol087oo
0Ukg0a`G47oo00=NmgooOol017oo00ENmgooOomooekg009oo`04G_MoogooG_L2Ool015kgOomooekg
0goo00=NmgooOol01Goo00=NmgooOol03goo00ANmgooG_MNm`Yoo`03001oogoo04=oo`00?7oo00<0
07ooOol03goo00=NmgooOol08goo00=NmgooOol08Woo00=NmgooOol08Goo00=NmgooOol07goo00EN
mgooOomooa@G011oo`03G_Moogoo00Eoo`05G_MoogooOomNm`02Ool015kgOomooekg0Woo00ANmgoo
OomNm`Aoo`03G_Moogoo00Aoo`03G_Moogoo00moo`05G_MoogooOomNm`09Ool00`00Oomoo`13Ool0
03aoo`03001oogoo00moo`03G_Moogoo02=oo`03G_Moogoo029oo`03G_Moogoo025oo`03G_Moogoo
01ioo`04G_MoogooOol351L>Ool00ekgOomoo`05Ool00ekgOomoo`02Ool015kgOomooekg0Woo00AN
mgooOomNm`9oo`03G_Moogoo009oo`03G_Moogoo00Eoo`03G_Moogoo00ioo`03G_Moogoo009oo`03
G_Moogoo00Ioo`03001oogoo04=oo`00?7oo00<007ooOol03goo00=NmgooOol08goo00=NmgooOol0
8Woo00=NmgooOol08Goo00=NmgooOol07Goo00=NmgooOol00Woo00<<5a@GOol03Woo00=NmgooOol0
1Goo00=NmgooOol00Woo00ANmgooOomNm`9oo`04G_MoogooG_L2Ool00ekgOomoo`02Ool00ekgOomo
o`05Ool00ekgOomoo`0>Ool00ekgOomoo`03Ool00ekgOomoo`04Ool20015Ool003aoo`03001oogoo
00moo`03G_Moogoo02=oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo01Yoo`9Nm`Aoo`04
31L85``GG_L=Ool00ekgOomoo`06Ool01EkgOomoogooG_L00goo00ANmgooOomNm`9oo`05G_Moogoo
OomNm`04Ool00ekgOomoo`05Ool00ekgOomoo`0<Ool00ekgOomoo`05Ool2G_L5Ool00`00Oomoo`13
Ool003aoo`03001oogoo011oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Mo
ogoo01Uoo`03G_Moogoo00Aoo`0401L<5gooG_L=Ool00ekgOomoo`05Ool00ekgOomoo`02Ool01Ekg
OomoogooG_L00Woo00ANmgooOomNm`=oo`03G_Moogoo009oo`03G_Moogoo00Ioo`03G_Moogoo00]o
o`03G_Moogoo00Moo`03G_Moogoo009oo`03001oogoo04=oo`00?7oo00<007ooOol047oo00=Nmgoo
Ool08Woo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol067oo00=NmgooOol017oo00D05`@G
01Mooekg00aoo`03G_Moogoo00Ioo`03G_Moogoo009oo`05G_MoogooOomNm`02Ool015kgOomooekg
0goo00=NmgooOol00Woo00=NmgooOol01Woo00=NmgooOol02goo00=NmgooOol027oo00ENmgooOomo
o`0004Eoo`00?7oo00<007ooOol047oo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo
00=NmgooOol05goo00=NmgooOol01Goo0P0G0Woo00=NmgooOol02Woo00=NmgooOol01Woo00=Nmgoo
Ool00Woo00ENmgooOomooekg009oo`04G_MoogooG_L3Ool00ekgOomoo`03Ool00ekgOomoo`06Ool0
0ekgOomoo`0:Ool00ekgOomoo`09Ool2G_L00goo001oo`14Ool003aoo`03001oogoo011oo`03G_Mo
ogoo029oo`03G_Moogoo029oo`03G_Moogoo029oo`03G_Moogoo01Eoo`9Nm`Moo`0301L0M`0G009o
o`03G_Moogoo00Uoo`03G_Moogoo00Ioo`03G_Moogoo00=oo`05G_MoogooOomNm`02Ool01EkgOomo
ogooG_L00Woo00=NmgooOol00goo00=NmgooOol01Woo00=NmgooOol02Woo00=NmgooOol02goo00=N
m`00Ool0A7oo000lOol00`00Oomoo`0@Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0R
Ool00ekgOomoo`0DOol00ekgOomoo`07Ool307L2Ool00ekgOomoo`08Ool00ekgOomoo`07Ool00ekg
Oomoo`03Ool01EkgOomoogooG_L00Woo00ENmgooOomooekg00=oo`03G_Moogoo009oo`03G_Moogoo
00Moo`03G_Moogoo00Uoo`03G_Moogoo00aoo`03G_Moogoo04=oo`00?7oo00<007ooOol047oo00=N
mgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol04goo00=NmgooOol027oo00<0
]`1gOol00Woo00=NmgooOol027oo00=NmgooOol01goo00=NmgooOol00Woo00ENmgooOomooekg00=o
o`05G_MoogooOomNm`03Ool00ekgOomoo`03Ool00ekgOomoo`07Ool00ekgOomoo`08Ool00ekgOomo
o`0<Ool00`00Oomoo`13Ool003aoo`03001oogoo011oo`03G_Moogoo029oo`03G_Moogoo029oo`03
G_Moogoo029oo`03G_Moogoo019oo`03G_Moogoo00Qoo`030?L0]`2g00=oo`03G_Moogoo00Moo`03
G_Moogoo00Moo`03G_Moogoo00=oo`05G_MoogooOomNm`03Ool01EkgOomoogooG_L00goo00=Nmgoo
Ool00goo00=NmgooOol01goo00=NmgooOol027oo00=NmgooOol037oo00<007ooOol0@goo000lOol0
0`00Oomoo`0@Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0AOol0
0ekgOomoo`08Ool00`3g0EL0m`04Ool00ekgOomoo`07Ool00ekgOomoo`07Ool00ekgOomoo`03Ool0
1EkgOomoogooG0d00goo00ENmgooOomooekg00=oo`03G_Moogoo00=oo`03G_Moogoo00Qoo`03G_Mo
ogoo00Moo`03G_Moogoo00aoo`03001oogoo04=oo`00?7oo00<007ooOol047oo00=NmgooOol08Woo
00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol03goo0Ukg2goo00<1U`5G0EL017oo00=Nmgoo
Ool01Woo00=NmgooOol027oo00=NmgooOol00goo00=NmgooG0/00e`=00=ooe`?G_L00goo00ENmgoo
Oomooekg00Ioo`03G_Moogoo00Moo`03G_Moogoo00Moo`03G_Moogoo00aoo`03001oogoo04=oo`00
?7oo00<007ooOol047oo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol0
3Woo00=NmgooOol02Woo00<1e`6G0IL01Woo00=NmgooOol01Goo00=NmgooOol01goo00=NmgooOol0
17oo00INme`;G0YL2e`=Ool3G0l017ooG19ooekg17oo00=NmgooOol00goo00=NmgooOol027oo00=N
mgooOol01Goo00=NmgooOol037oo0P00AGoo000lOol00`00Oomoo`0@Ool00ekgOomoo`0ROol00ekg
Oomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0=Ool00ekgOomoo`0:Ool00`7G0SL1e`07Ool00ekg
Oomoo`04Ool00ekgOomoo`08Ool00ekgOomoo`03Ool01UkgG0Qooe`;OomNm`9oo`03G0mNme`B009L
4P03G_Moogoo009oo`03G_Moogoo00=oo`03G_Moogoo00Qoo`03G_Moogoo00Eoo`03G_Moogoo00eo
o`03001oogoo04=oo`00?7oo00<007ooOol047oo00=NmgooOol08Woo00=NmgooOol08Woo00=Nmgoo
Ool08Woo00=NmgooOol037oo00=NmgooOol02goo00<2M`8g0SL01goo00=NmgooOol00goo00=Nmgoo
Ool02Goo00=NmgooOol00goo00=l05`8G0P00Woo00UNmgooOomooekgOomL4WooG1@017oo00=Nmgoo
Ool017oo00=NmgooOol027oo00=NmgooOol017oo00=NmgooOol03Goo00<007ooOol0@goo000lOol0
0`00Oomoo`0@Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0:Ool2
G_L=Ool00`9g0[L2M`08Ool00ekgOomoo`03Ool00ekgOomoo`08Ool00ekgOomoo`03Ool3O00015`6
Oomooekg0goo00=NmgooOol00e`D00AL5WooOomNm`Ioo`03G_Moogoo00Uoo`03G_Moogoo00=oo`03
G_Moogoo00eoo`03001oogoo04=oo`00?7oo00<007ooOol047oo00=NmgooOol08Woo00=NmgooOol0
8Woo00=NmgooOol08goo00=NmgooOol027oo00=NmgooOol03Goo00<2mP:g0[L027oo00=NmgooOol0
0Woo00=NmgooOol02Goo00=NmgooOol017oo00=l05`6Ool00Woo00ENmgooOomooekg00=oo`06G1AL
5U`FG1Iooekg1Woo00=NmgooOol02Goo00=NmgooOol00goo00=NmgooOol03Goo00<007ooOol0@goo
000lOol00`00Oomoo`0@Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0SOol00ekgOomo
o`07Ool00ekgOomoo`0=Ool00`;f0_@2mP09Ool00ekgOomoo`02Ool00ekgOomoo`09Ool00ekgOomo
o`04Ool00ekgOomoo`02Ool01EkgOomoogooG_L017oo00=Nme`FE1L00Woo00=NmgooOol017oo00=N
mgooOol02Goo00=NmgooOol00Woo00=NmgooOol03Goo00<007ooOol0@goo000lOol00`00Oomoo`0@
Ool00ekgOomoo`0ROol00ekgOomoo`0ROol00ekgOomoo`0SOol00ekgOomoo`06Ool00ekgOomoo`0>
Ool00`;b0_@2m00:Ool015kgOomooekg2goo00=NmgooOol017oo00=NmgooOol00goo00ENmgooOomo
oekg00Aoo`06G_MD5e@GE1M<5ekg1Woo00=NmgooOol02Goo00ENmgooOomooekg011oo`03001oogoo
04=oo`00?7oo00<007ooOol047oo00=NmgooOol08Woo00=NmgooOol08Woo00=NmgooOol08goo00=N
mgooOol017oo0Ukg47oo00<2k@;_0_802goo00=NmgooG_L037oo00=NmgooOol017oo00=NmgooOol0
0Woo00=NmgooOol00Woo00=NmgooOol00Woo00INmgooE1M<5dPFA1L6Ool00ekgOomoo`0:Ool015kg
Oomooekg47oo00<007ooOol0@goo000lOol00`00Oomoo`0@Ool00ekgOomoo`0ROol00ekgOomoo`0S
Ool00ekgOomoo`0ROol00ekgOomoo`03Ool00ekgOomoo`0?Ool010;[0^d2k@;_2goo00=NmgooG_L0
37oo00=NmgooOol017oo00=NmgooOol00Woo00=NmgooOol00Woo00=NmgooOol00Woo00MNmgooOomo
od@G@1M45`06Ool00ekgOomoo`0:Ool00ekgOomNm`0@Ool00`00Oomoo`13Ool003=oo`D000Aoo`03
001oogoo011oo`03G_Moogoo029oo`03G_Moogoo02=oo`03G_Moogoo029oo`03G_Moogoo009oo`03
G_Moogoo00moo`040^/2j0;[0^l<Ool2G_L<Ool00ekgOomoo`05Ool00ekgOomoo`02Ool00ekgOomo
o`02Ool00ekgOomoo`02Ool00ekgOomoo`02Ool00d@G>1Moo`05Ool00ekgOomoo`0:Ool00ekgOomN
m`0@Ool00`00Oomoo`13Ool003Eoo`03001oogoo00Aoo`03001oogoo011oo`03G_Moogoo029oo`03
G_Moogoo02=oo`03G_Moogoo029oo`05G_MoogooOomNm`0BOol00`;T0^P2j00=Ool2G_L<Ool00ekg
Oomoo`05Ool00ekgOomoo`02Ool00ekgOomoo`02Ool00ekgOomoo`02Ool00ekgOomoo`02Ool2>1L0
0c0GOomoo`03Ool00ekgOomoo`0;Ool2G_L@Ool00`00Oomoo`13Ool003Eoo`03001oogoo00Aoo`80
015oo`03G_Moogoo029oo`03G_Moogoo02=oo`03G_Moogoo029oo`04G_MooekgG_LBOol00`;Q0^@2
i00>Ool2G_L<Ool00ekgOomoo`04Ool00ekgOomoo`03Ool00ekgOomoo`02Ool00ekgOomoo`02Ool0
0ekgOomoo`03Ool2<1L00bPGOomoo`03Ool00ekgOomoo`0:Ool00ekgOomoo`0=Ool30015Ool003Eo
o`03001oogoo00Aoo`03001oogoo011oo`03G_Moogoo029oo`03G_Moogoo02=oo`03G_Moogoo029o
o`9Nma=oo`<2h@moo`9Nm`]oo`03G_Moogoo00Eoo`03G_Moogoo00=oo`03G_Moogoo009oo`03G_Mo
ogoo009oo`03G_Moogoo00=oo`04G_LX5bPG:1L4Ool00ekgOomoo`0:Ool2G_L@Ool00`00Oomoo`13
Ool003Eoo`03001oogoo00Aoo`03001oogoo011oo`03G_Moogoo029oo`03G_Moogoo02=oo`03G_Mo
ogoo029oo`03G_Moogoo01=oo`030^5oogoo00eoo`03G_Mooekg00]oo`03G_Moogoo00Eoo`03G_Mo
ogoo00=oo`03G_Moogoo009oo`03G_Moogoo009oo`03G_Moogoo00=oo`04G_MoobPG71L4Ool00ekg
Oomoo`0:Ool00ekgOomNm`0?Ool00`00Oomoo`13Ool003Aoo`8000Ioo`03001oogoo011oo`03G_Mo
ogoo029oo`03G_Moogoo02=oo`03G_Moogoo025oo`9NmbAoo`04G_MoogooG_L;Ool00ekgOomoo`05
Ool00ekgOomoo`03Ool00ekgOomoo`02Ool00ekgOomoo`02Ool00ekgOomoo`03Ool01EkgOolL5a`G
51L017oo00=NmgooOol02Goo00=NmgooG_L03goo00<007ooOol0@goo000lOol00`00Oomoo`0@Ool0
0ekgOomoo`0ROol00ekgOomoo`0SOol00ekgOomoo`0OOol2G_L2Ool00ekgOomoo`0QOol01EkgOomo
ogooG_L02Goo00=NmgooOol01Woo00=NmgooOol00goo00=NmgooOol00Woo00=NmgooOol00Woo00=N
mgooOol017oo00ENmgoo51LD5``G00=oo`03G_Moogoo00Qoo`05G_MoogooOomNm`0>Ool00`00Oomo
o`13Ool003aoo`03001oogoo011oo`03G_Moogoo029oo`03G_Moogoo02=oo`03G_Moogoo01ioo`03
G_Moogoo009oo`03G_Moogoo021oo`03G_Moogoo009oo`03G_Moogoo00Moo`03G_Moogoo00Ioo`03
G_Moogoo00=oo`03G_Moogoo009oo`03G_Moogoo00=oo`03G_Moogoo00=oo`06G_Moogoo31L85`0G
0Woo00=NmgooOol027oo00ENmgooOomooekg00ioo`03001oogoo04=oo`00?7oo00<007ooOol047oo
00=NmgooOol08Woo00=NmgooOol08goo00=NmgooOol07Goo00=NmgooOol00goo00=NmgooOol087oo
00=NmgooOol00Woo00=NmgooOol01goo00=NmgooOol01Goo00=NmgooOol017oo00=NmgooOol00Woo
00=NmgooOol00goo00=NmgooOol00goo00MNmgooOomoo`0G11L05`02Ool00ekgOomoo`07Ool00ekg
Oomoo`02Ool00ekgOomoo`0;Ool00`00Oomoo`13Ool003aoo`03001oogoo011oo`03G_Moogoo029o
o`03G_Moogoo02=oo`03G_Moogoo01aoo`03G_Moogoo00Aoo`03G_Moogoo01moo`03G_Moogoo00=o
o`03G_Moogoo00Ioo`03G_Moogoo00Ioo`03G_Moogoo00Aoo`03G_Moogoo009oo`03G_Moogoo00=o
o`03G_Moogoo00=oo`03G_Moogoo009oo`<05`03OomNmgoo00Qoo`03G_Moogoo009oo`03G_Moogoo
00]oo`03001oogoo04=oo`00?7oo00<007ooOol047oo00=NmgooOol08Woo00=NmgooOol08goo00=N
mgooOol06Woo0Ukg1goo00=NmgooOol07goo00=NmgooOol017oo00=NmgooOol01Goo00=NmgooOol0
1Woo00=NmgooOol00goo00=NmgooOol00goo00=NmgooOol00goo00=NmgooOol00goo00=NmgooOol0
0goo00@05`1gOomNm`Qoo`03G_Moogoo00Aoo`03G_Moogoo00Yoo`03001oogoo04=oo`00?7oo00<0
07ooOol047oo00=NmgooOol08goo00=NmgooOol08Woo00=NmgooOol06Goo00=NmgooOol01goo00=N
mgooOol07Woo00=NmgooOol01Goo00=NmgooOol01Goo00=NmgooOol01Woo00=NmgooOol00goo00=N
mgooOol00goo00=NmgooOol00goo00=NmgooOol017oo00=NmgooOol00Woo0P1g00<0]gooG_L01goo
00=NmgooOol01Goo00=NmgooOol02Goo00<007ooOol0@goo000lOol00`00Oomoo`0@Ool00ekgOomo
o`0SOol00ekgOomoo`0ROol00ekgOomoo`0HOol00ekgOomoo`08Ool00ekgOomoo`0MOol00ekgOomo
o`06Ool00ekgOomoo`04Ool00ekgOomoo`07Ool00ekgOomoo`03Ool00ekgOomoo`03Ool00ekgOomo
o`03Ool00ekgOomoo`04Ool00ekgOomoo`03Ool20;L00`3gG_Moo`06Ool00ekgOomoo`05Ool00ekg
Oomoo`09Ool00`00Oomoo`13Ool003aoo`03001oogoo011oo`03G_Moogoo02=oo`03G_Moogoo029o
o`03G_Moogoo01Moo`03G_Moogoo00Uoo`03G_Moogoo01eoo`03G_Moogoo00Ioo`03G_Moogoo00Ao
o`03G_Moogoo00Ioo`03G_Moogoo00Aoo`03G_Moogoo00=oo`03G_Moogoo00=oo`03G_Moogoo00Ao
o`03G_Moogoo00Aoo`030?L1E`3g00Ioo`03G_Moogoo00Moo`03G_Moogoo00Moo`8004Eoo`00?7oo
00<007ooOol047oo00=NmgooOol08goo00=NmgooOol08Woo00=NmgooOol05Goo0Ukg37oo00=Nmgoo
Ool077oo00=NmgooOol027oo00=NmgooOol00goo00=NmgooOol01Woo00=NmgooOol017oo00=Nmgoo
Ool00goo00=NmgooOol00goo00=NmgooOol017oo00=NmgooOol017oo00@1E`4f0IMNm`Eoo`03G_Mo
ogoo00Moo`03G_Moogoo00Qoo`03001oogoo04=oo`00?7oo00<007ooOol047oo00=NmgooOol08goo
00=NmgooOol08Woo00=NmgooOol057oo00=NmgooOol03Goo00=NmgooOol06goo00=NmgooOol027oo
00=NmgooOol00Woo00=NmgooOol01goo00=NmgooOol017oo00=NmgooOol00goo00=NmgooOol00goo
00=NmgooOol017oo00=NmgooOol01Goo0P6G00<1egooOol00goo00=NmgooOol027oo00=NmgooOol0
1goo00<007ooOol0@goo000lOol00`00Oomoo`0@Ool00ekgOomoo`0SOol00ekgOomoo`0ROol00ekg
Oomoo`0COol00ekgOomoo`0>Ool00ekgOomoo`0JOol00ekgOomoo`09Ool00ekgOomoo`02Ool00ekg
Oomoo`07Ool00ekgOomoo`04Ool00ekgOomoo`03Ool00ekgOomoo`03Ool00ekgOomoo`05Ool00ekg
Oomoo`05Ool00`7G0MH2=`04Ool00ekgOomoo`09Ool00ekgOomoo`06Ool00`00Oomoo`13Ool003ao
o`03001oogoo011oo`03G_Moogoo02=oo`03G_Moogoo029oo`03G_Moogoo019oo`03G_Moogoo00mo
o`03G_Moogoo01Yoo`03G_Moogoo00Uoo`03G_Moogoo009oo`03G_Moogoo00Moo`03G_Moogoo00Ao
o`03G_Moogoo00=oo`03G_Moogoo00Aoo`03G_Moogoo00Aoo`03G_Moogoo00Ioo`030SL2M`8g009o
o`03G_Moogoo00Yoo`03G_Moogoo00Ioo`03001oogoo04=oo`00?7oo00<007ooOol047oo00=Nmgoo
Ool08goo00=NmgooOol08Woo00=NmgooOol047oo0Ukg4Woo00=NmgooOol06Goo00=NmgooOol02Woo
00ENmgooOomooekg00Uoo`03G_Moogoo00Eoo`03G_Moogoo00=oo`03G_Moogoo00Aoo`03G_Moogoo
00Aoo`03G_Moogoo00Ioo`82M`040[MoogooG_L=Ool00ekgOomoo`05Ool00`00Oomoo`13Ool003ao
o`03001oogoo011oo`03G_Moogoo02=oo`03G_Moogoo02=oo`03G_Moogoo00ioo`03G_Moogoo019o
o`03G_Moogoo01Qoo`03G_Moogoo00]oo`05G_MoogooOomNm`09Ool00ekgOomoo`05Ool00ekgOomo
o`03Ool00ekgOomoo`04Ool00ekgOomoo`04Ool00ekgOomoo`07Ool30[L00gooG_Moo`0<Ool00ekg
Oomoo`05Ool00`00Oomoo`13Ool003aoo`03001oogoo011oo`03G_Moogoo02=oo`03G_Moogoo02=o
o`03G_Moogoo00eoo`03G_Moogoo01=oo`03G_Moogoo01Qoo`03G_Moogoo00aoo`04G_MoogooG_L9
Ool00ekgOomoo`05Ool00ekgOomoo`03Ool00ekgOomoo`04Ool00ekgOomoo`04Ool00ekgOomoo`08
Ool010:g0_Iooekg3Woo00=NmgooOol017oo00<007ooOol0@goo000lOol00`00Oomoo`0@Ool00ekg
Oomoo`0SOol00ekgOomoo`0SOol00ekgOomoo`0<Ool00ekgOomoo`0DOol00ekgOomoo`0GOol00ekg
Oomoo`0=Ool00ekgOomNm`0:Ool00ekgOomoo`04Ool00ekgOomoo`04Ool00ekgOomoo`04Ool00ekg
Oomoo`05Ool00ekgOomoo`07Ool00`;f0_@2mP0@Ool00ekgOomoo`03Ool00`00Oomoo`13Ool003ao
o`03001oogoo011oo`03G_Moogoo02=oo`03G_Moogoo02=oo`03G_Moogoo00Yoo`9NmaMoo`03G_Mo
ogoo01Moo`03G_Moogoo00eoo`03G_Mooekg00Yoo`03G_Moogoo00Aoo`03G_Moogoo00Aoo`03G_Mo
ogoo00Aoo`03G_Moogoo00Eoo`03G_Moogoo00Moo`82m0030_9oogoo00ioo`03G_Moogoo00=oo`03
001oogoo04=oo`00?7oo00<007ooOol04Goo00=NmgooOol08Woo00=NmgooOol08goo00=NmgooOol0
2Goo00=NmgooOol05goo00=NmgooOol05Woo00=NmgooOol03Woo00=NmgooG_L02Goo00=NmgooOol0
1Goo00QNmgooOomooe`=O01L0Ekg1Woo00=NmgooOol01Goo00=NmgooOol027oo0P;b00<2kgooOol0
3Woo00=NmgooOol00Woo00<007ooOol0@goo000lOol00`00Oomoo`0AOol00ekgOomoo`0ROol00ekg
Oomoo`0SOol00ekgOomoo`08Ool00ekgOomoo`0IOol00ekgOomoo`0DOol00ekgOomoo`0@Ool00ekg
Oomoo`08Ool00ekgOomoo`05Ool015kgOomooe`?0g`000=L0GooOol017oo00=NmgooOol01Goo00=N
mgooOol027oo00ANm`;_0^d2k`moo`04G_MoogooOol20015Ool003aoo`03001oogoo015oo`03G_Mo
ogoo029oo`03G_Moogoo02=oo`03G_Moogoo00Moo`03G_Moogoo01Yoo`03G_Moogoo01Aoo`03G_Mo
ogoo011oo`03G_Moogoo00Qoo`03G_Moogoo00Eoo`03G_Mooe`?009L3`03O01L0Ekg00Ioo`03G_Mo
ogoo00Eoo`03G_Moogoo00Qoo`04G_L2k@;]0^/@Ool01EkgOomoogoo0000AGoo000lOol00`00Oomo
o`0AOol00ekgOomoo`0ROol00ekgOomoo`0SOol00ekgOomoo`05Ool2G_LMOol00ekgOomoo`0COol0
0ekgOomoo`0AOol2G_L9Ool00ekgOomoo`05Ool015kgOomL4U`?0goo00=NmgooOol017oo00=Nmgoo
Ool01Goo00=NmgooOol027oo0Ukg00<2j`;Z0^P03goo00ENmgooOomoo`0004Eoo`00?7oo00<007oo
Ool04Goo00=NmgooOol08Woo00=NmgooOol08goo00=NmgooOol017oo00=NmgooOol07Goo00=Nmgoo
Ool04goo00=NmgooOol047oo00=NmgooG_L02Goo00=NmgooOol01Goo00ANme`BG19L4P=oo`03G_Mo
ogoo00Aoo`03G_Moogoo00Ioo`03G_Moogoo00Ioo`07G_MooekgOol2j0;V0^P03goo00ANmgooOol0
04Eoo`00?7oo00<007ooOol04Goo00=NmgooOol08Woo00=NmgooOol08goo00=NmgooOol00goo00=N
mgooOol07Woo00=NmgooOol04Woo00=NmgooOol04Goo00=NmgooG_L02Goo00=NmgooOol01Goo00=N
mgooG1@017oo00=NmgooOol01Goo00=NmgooOol01Goo00=NmgooOol01Woo00ANmgooOomNm`82iP03
0^Aoogoo00ioo`03G_Moo`0004Eoo`00?7oo00<007ooOol04Goo00=NmgooOol08goo00=NmgooOol0
8Woo00=NmgooOol00Woo00=NmgooOol07goo00=NmgooOol04Woo00=NmgooOol04Goo00ANmgooOomN
m`Moo`03G_Moogoo00Ioo`04G_ML55`DG1@3Ool00ekgOomoo`05Ool00ekgOomoo`05Ool00ekgOomo
o`06Ool025kgOomooekgOol2i0;Q0^@?Ool00ekgOol00015Ool003aoo`03001oogoo015oo`03G_Mo
ogoo02=oo`03G_Moogoo029oo`03G_Moogoo009Nmb9oo`03G_Moogoo015oo`03G_Moogoo015oo`05
G_MoogooOomNm`07Ool00ekgOomoo`06Ool00ekgOomL5004Ool00ekgOomoo`05Ool00ekgOomoo`05
Ool00ekgOomoo`06Ool01EkgOomooekgOol00`;Q47oo00=Nm`00Ool0A7oo000lOol00`00Oomoo`0A
Ool00ekgOomoo`0SOol00ekgOomoo`0ROol00ekgOomNm`0TOol00ekgOomoo`0@Ool00ekgOomoo`0B
Ool00ekgOomoo`02Ool00ekgOomoo`04Ool00ekgOomoo`06Ool00ekgG1Ioo`04Ool00ekgOomoo`05
Ool00ekgOomoo`05Ool00ekgOomoo`05Ool00ekgOomoo`02Ool00ekgOol2h@0AOol00ekg001oo`14
Ool003aoo`03001oogoo015oo`03G_Moogoo02=oo`03G_Moogoo029oo`9NmbIoo`03G_Moogoo00mo
o`03G_Moogoo019oo`03G_Moogoo009oo`03G_Moogoo00Aoo`03G_Moogoo00Eoo`04G_ML5U`GG1H4
Ool00ekgOomoo`05Ool00ekgOomoo`06Ool00ekgOomoo`04Ool00ekgOomoo`02Ool00ekgOomoo`0B
Ool00ekgOomoo`13Ool003aoo`03001oogoo015oo`03G_Moogoo02=oo`03G_Moogoo029oo`9NmbIo
o`03G_Moogoo00ioo`03G_Moogoo019oo`03G_Moogoo00Aoo`03G_Moogoo00=oo`03G_Moogoo00Eo
o`03G_Mooe@G00Eoo`03G_Moogoo00Eoo`03G_Moogoo00Ioo`03G_Moogoo00=oo`03G_Moogoo00=o
o`03G_Moogoo019oo`03001oogoo04=oo`00?7oo00<007ooOol04Goo00=NmgooOol08goo00=Nmgoo
Ool087oo0Ukg00=ooekgOol09Goo00=NmgooOol03Woo00=NmgooOol04Woo00=NmgooOol017oo00=N
mgooOol00Woo00=NmgooOol01Woo00ANme@GF1MD5`Aoo`03G_Moogoo00Eoo`03G_Moogoo00Ioo`03
G_Moogoo00=oo`03G_Moogoo00Aoo`03G_Moogoo015oo`03001oogoo04=oo`00?7oo00<007ooOol0
4Goo00=NmgooOol08goo00=NmgooOol07goo00ENmgooOomooekg02Ioo`03G_Moogoo00eoo`03G_Mo
ogoo01=oo`03G_Moogoo00Eoo`05G_MoogooOomNm`08Ool00ekgOomD5`05Ool00ekgOomoo`05Ool0
0ekgOomoo`06Ool00ekgOomoo`02Ool00ekgOomoo`05Ool00ekgOomoo`0@Ool20015Ool003aoo`03
001oogoo015oo`03G_Moogoo02=oo`03G_Moogoo01ioo`03G_Moogoo009oo`03G_Moogoo02Aoo`03
G_Moogoo00eoo`03G_Moogoo019oo`03G_Moogoo00Ioo`05G_MoogooOomNm`08Ool00ekgC1Moo`05
Ool00ekgOomoo`05Ool00ekgOomoo`06Ool00ekgOomoo`02Ool00ekgOomoo`05Ool00ekgOomoo`0A
Ool00`00Oomoo`13Ool003aoo`03001oogoo019oo`03G_Moogoo029oo`03G_Moogoo01eoo`03G_Mo
ogoo00=oo`03G_Moogoo02Aoo`03G_Moogoo00aoo`03G_Moogoo01=oo`03G_Moogoo00Moo`04G_Mo
ogooG_L8Ool3C1L5Ool00ekgOomoo`05Ool00ekgOomoo`07Ool015kgOomooekg2Goo00=NmgooOol0
47oo00<007ooOol0@goo000lOol00`00Oomoo`0BOol00ekgOomoo`0ROol00ekgOomoo`0KOol2G_L6
Ool00ekgOomoo`0UOol00ekgOomoo`0:Ool00ekgOomoo`0DOol00ekgOomoo`07Ool015kgOomooekg
27oo00=Nmd@GOol01Goo00=NmgooOol01Goo00=NmgooOol01goo00ANmgooOomNm`Uoo`03G_Moogoo
011oo`03001oogoo04=oo`00?7oo00<007ooOol04Woo00=NmgooOol08Woo00=NmgooOol06Woo00=N
mgooOol01Woo00=NmgooOol09Goo00=NmgooOol02Woo00=NmgooOol04goo00=NmgooOol02Goo0Ukg
2Goo0d@G1Goo00=NmgooOol01Woo00=NmgooOol01Woo00=NmgooG_L02Woo00=NmgooOol047oo00<0
07ooOol0@goo000lOol00`00Oomoo`0BOol00ekgOomoo`0ROol00ekgOomoo`0IOol00ekgOomoo`07
Ool00ekgOomoo`0UOol00ekgOomoo`09Ool00ekgOomoo`0DOol00ekgOomoo`09Ool2G_L9Ool00ekg
A1Moo`05Ool00ekgOomoo`06Ool00ekgOomoo`06Ool00ekgOomNm`0;Ool00ekgOomoo`0?Ool00`00
Oomoo`13Ool003aoo`03001oogoo019oo`03G_Moogoo029oo`03G_Moogoo01Qoo`03G_Moogoo00Uo
o`03G_Moogoo02Aoo`03G_Moogoo00Uoo`03G_Moogoo01Aoo`03G_Moogoo00Yoo`03G_Moogoo00Mo
o`03G_Lh5goo00Eoo`03G_Moogoo00Ioo`03G_Moogoo00Ioo`9Nm`aoo`03G_Moogoo00moo`03001o
ogoo04=oo`00?7oo00<007ooOol04Woo00=NmgooOol08Woo00=NmgooOol05Woo0Ukg37oo00=Nmgoo
Ool097oo00=NmgooOol027oo00=NmgooOol057oo00=NmgooOol02goo00=NmgooOol01goo00<h5cPF
>1L01Goo00=NmgooOol01Woo00=NmgooOol01goo00=NmgooOol02Woo00=NmgooOol03goo00<007oo
Ool0@goo000lOol00`00Oomoo`0BOol00ekgOomoo`0ROol00ekgOomoo`0EOol00ekgOomoo`0<Ool0
0ekgOomoo`0TOol00ekgOomoo`07Ool00ekgOomoo`0EOol00ekgOomoo`0;Ool2G_L8Ool00c0G>1Mo
o`05Ool00ekgOomoo`06Ool00ekgOomoo`06Ool2G_L=Ool00ekgOomoo`0>Ool00`00Oomoo`13Ool0
03aoo`03001oogoo019oo`03G_Moogoo029oo`03G_Moogoo01Aoo`03G_Moogoo00eoo`03G_Moogoo
02Eoo`03G_Moogoo00Ioo`03G_Moogoo01Eoo`03G_Moogoo00Yoo`04G_MoogooG_L6Ool3<1L6Ool0
0ekgOomoo`06Ool00ekgOomoo`05Ool00ekgOomNm`0=Ool00ekgOomoo`0>Ool00`00Oomoo`13Ool0
03aoo`03001oogoo019oo`03G_Moogoo029oo`03G_Moogoo01=oo`03G_Moogoo00ioo`03G_Moogoo
02Eoo`03G_Moogoo00Eoo`03G_Moogoo01Eoo`03G_Moogoo00]oo`04G_MoogooG_L6Ool00ekg<1Mo
o`06Ool00ekgOomoo`06Ool00ekgOomoo`05Ool00ekgOomNm`0=Ool00ekgOomoo`0>Ool00`00Oomo
o`13Ool003aoo`03001oogoo019oo`03G_Moogoo029oo`03G_Moogoo015oo`9Nma5oo`03G_Moogoo
02Eoo`03G_Moogoo00Eoo`03G_Moogoo01Eoo`03G_Moogoo00]oo`05G_MoogooOomNm`05Ool00ekg
:1Moo`06Ool00ekgOomoo`06Ool00ekgOomoo`04Ool015kgOomooekg3Woo00=NmgooOol037oo0P00
AGoo000lOol00`00Oomoo`0BOol00ekgOomoo`0SOol00ekgOomoo`0?Ool00ekgOomoo`0AOol00ekg
Oomoo`0UOol00ekgOomoo`04Ool00ekgOomoo`0FOol00ekgOomoo`0;Ool00ekgOomoo`02Ool00ekg
Oomoo`02Ool00bPG91LX5`06Ool00ekgOomoo`06Ool00ekgOomoo`03Ool00ekgOomoo`02Ool00ekg
Oomoo`0;Ool00ekgOomoo`0=Ool00`00Oomoo`13Ool003aoo`03001oogoo019oo`03G_Moogoo02=o
o`03G_Moogoo00ioo`03G_Moogoo019oo`03G_Moogoo02Eoo`03G_Moogoo00Aoo`03G_Moogoo01Eo
o`03G_Moogoo00aoo`03G_Moogoo00=oo`06G_MoogooOomNma`G1goo00=NmgooOol01Woo00=Nmgoo
Ool00Woo00=NmgooOol00goo00=NmgooOol02goo00=NmgooOol03Goo00<007ooOol0@goo000lOol0
0`00Oomoo`0BOol00ekgOomoo`0SOol00ekgOomoo`0=Ool00ekgOomoo`0DOol00ekgOomoo`0TOol0
0ekgOomoo`03Ool00ekgOomoo`0FOol00ekgOomoo`0;Ool00ekgOomoo`04Ool015kgOomoogoo0a`G
1Woo00=NmgooOol01goo00ENmgooOomooekg00Eoo`03G_Moogoo00aoo`03G_Moogoo00aoo`03001o
ogoo04=oo`00?7oo00<007ooOol04goo00=NmgooOol08Woo00=NmgooOol02goo0Ukg5goo00=Nmgoo
Ool09Goo00ENmgooOomooekg01Uoo`03G_Moogoo00]oo`03G_Moogoo00Eoo`05G_MoogooG_LL5`07
Ool00ekgOomoo`07Ool015kgOomooekg1Woo00=NmgooOol037oo00=NmgooOol037oo00<007ooOol0
@goo000lOol00`00Oomoo`0COol00ekgOomoo`0ROol00ekgOomoo`0:Ool00ekgOomoo`0GOol00ekg
Oomoo`0UOol01EkgOomoogooG_L067oo00=NmgooOol037oo00=NmgooOol01Woo00ANmgooG_LD5`Mo
o`03G_Moogoo00Moo`03G_Mooekg00Moo`03G_Moogoo00aoo`03G_Moogoo00aoo`03001oogoo04=o
o`00?7oo00<007ooOol04goo00=NmgooOol08Woo00=NmgooOol02Goo00=NmgooOol067oo00=Nmgoo
Ool09Goo00ANmgooOomNmaUoo`03G_Moogoo00aoo`03G_Moogoo00Moo`04G_LD5a@G51L6Ool00ekg
Oomoo`07Ool2G_L9Ool00ekgOomoo`0<Ool00ekgOomoo`0;Ool00`00Oomoo`13Ool003aoo`03001o
ogoo01=oo`03G_Moogoo029oo`03G_Moogoo00Qoo`03G_Moogoo01Uoo`03G_Moogoo02Eoo`04G_Mo
ogooG_LIOol00ekgOomoo`0<Ool00ekgOomoo`08Ool00``G51Moo`06Ool00ekgOomoo`06Ool2G_L:
Ool00ekgOomoo`0<Ool00ekgOomoo`0;Ool00`00Oomoo`13Ool003aoo`03001oogoo01=oo`03G_Mo
ogoo029oo`03G_Moogoo00Ioo`9Nmaaoo`03G_Moogoo02Eoo`03G_Mooekg01Uoo`03G_Moogoo00eo
o`03G_Moogoo00Moo`0331L85``G00Moo`03G_Moogoo00Eoo`03G_Mooekg00Yoo`03G_Moogoo00ao
o`03G_Moogoo00]oo`03001oogoo04=oo`00=7oo0`001Goo00<007ooOol04goo00=NmgooOol08Woo
00=NmgooOol01Goo00=NmgooOol077oo00=NmgooOol09Goo00=NmgooG_L06Goo00=NmgooOol037oo
00=NmgooOol027oo00=Nm`0GOol00Ukg1Goo00=NmgooOol017oo00ANmgooOomNm`Yoo`03G_Moogoo
00eoo`03G_Moogoo00Yoo`03001oogoo04=oo`00=7oo00<007ooOol01Goo00<007ooOol04goo00=N
mgooOol08Woo00=NmgooOol017oo00=NmgooOol07Goo00=NmgooOol09Woo00=NmgooOol067oo00=N
mgooOol037oo00=NmgooOol027oo00<05`@F01L00Woo0Ukg0goo00=NmgooOol00Woo0Ukg0goo00=N
mgooOol027oo00=NmgooOol03Goo00=NmgooOol02Woo00<007ooOol0@goo000eOol00`00Oomoo`04
Ool2000DOol00ekgOomoo`0ROol00ekgOomoo`03Ool00ekgOomoo`0OOol00ekgOomoo`0TOol2G_LI
Ool00ekgOomoo`0=Ool00ekgOomoo`08Ool00ekg01Moo`04Ool8G_L5Ool00ekgOomoo`09Ool00ekg
Oomoo`0<Ool00ekgOomoo`08Ool30015Ool003Eoo`03001oogoo00Aoo`03001oogoo01=oo`03G_Mo
ogoo029oo`04G_MoogooOol2G_LROol00ekgOomoo`0TOol2G_LIOol00ekgOomoo`0=Ool00ekgOomo
o`08Ool00ekg01Moo`07Ool00ekgOomoo`07Ool00ekgOomoo`09Ool00ekgOomoo`0=Ool00ekgOomo
o`09Ool00`00Oomoo`13Ool003Aoo`03001oo`0000Eoo`03001oogoo01=oo`03G_Moogoo029oo`04
G_MoogooG_LTOol00ekgOomoo`0SOol00ekgOomNm`0IOol00ekgOomoo`0=Ool00ekgOomoo`08Ool3
01L7Ool00ekgOomoo`07Ool00ekgOomoo`09Ool00ekgOomoo`0=Ool00ekgOomoo`09Ool00`00Oomo
o`13Ool003Eoo`03001oogoo00Aoo`03001oogoo01=oo`03G_Moogoo029oo`03G_Mooekg02Eoo`03
G_Moogoo02=oo`04G_MoogooG_LGOol00ekgOomoo`0=Ool00ekgOomoo`09Ool00ekg07Moo`07Ool0
0ekgOomoo`08Ool00ekgOomoo`08Ool00ekgOomoo`0=Ool00ekgOomoo`09Ool00`00Oomoo`13Ool0
03aoo`03001oogoo01=oo`03G_Moogoo02=oo`03G_Moogoo02Aoo`03G_Moogoo029oo`05G_Moogoo
OomNm`0GOol00ekgOomoo`0=Ool00ekgOomoo`09Ool307L7Ool00ekgOomoo`08Ool00ekgOomoo`08
Ool00ekgOomoo`0>Ool00ekgOomoo`08Ool00`00Oomoo`13Ool003aoo`03001oogoo01=oo`03G_Mo
ogoo025oo`=NmbIoo`03G_Moogoo025oo`03G_Moogoo009oo`03G_Moogoo01Eoo`03G_Moogoo00eo
o`03G_Moogoo00Uoo`03G_L0]goo00Moo`03G_Moogoo00Qoo`03G_Moogoo00Uoo`03G_Moogoo00eo
o`03G_Moogoo00Qoo`03001oogoo04=oo`00?7oo00<007ooOol04goo00=NmgooOol087oo00ANmgoo
OomNmbIoo`03G_Moogoo025oo`03G_Moogoo009oo`03G_Moogoo01Aoo`03G_Moogoo00ioo`03G_Mo
ogoo00Uoo`<0]`Moo`03G_Moogoo00Qoo`03G_Moogoo00Uoo`03G_Moogoo00eoo`03G_Moogoo00Qo
o`03001oogoo04=oo`00?7oo00<007ooOol057oo00=NmgooOol07Woo00ENmgooOomooekg02Ioo`03
G_Moogoo021oo`03G_Moogoo00=oo`03G_Moogoo01Aoo`03G_Moogoo00ioo`03G_Moogoo00Uoo`03
G_L0mgoo00Moo`03G_Moogoo00Qoo`03G_Moogoo00Uoo`03G_Moogoo00ioo`03G_Moogoo00Moo`03
001oogoo04=oo`00?7oo00<007ooOol057oo00=NmgooOol07Goo00=NmgooOol00Woo00=NmgooOol0
9Goo00=NmgooOol07goo00=NmgooOol017oo00=NmgooOol04goo00=NmgooOol03Goo00=NmgooOol0
2Woo0`3g1goo00=NmgooOol027oo00=NmgooOol02Goo00=NmgooOol03Woo00=NmgooOol01goo00<0
07ooOol0@goo000lOol00`00Oomoo`0DOol00ekgOomoo`0KOol2G_L5Ool00ekgOomoo`0UOol00ekg
Oomoo`0NOol00ekgOomoo`05Ool00ekgOomoo`0BOol00ekgOomoo`0>Ool00ekgOomoo`09Ool00ekg
0EL0m`08Ool00ekgOomoo`08Ool00ekgOomoo`09Ool00ekgOomoo`0>Ool00ekgOomoo`07Ool00`00
Oomoo`13Ool003aoo`03001oogoo01Aoo`03G_Moogoo01Yoo`03G_Moogoo00Eoo`03G_Moogoo02Eo
o`03G_Moogoo01ioo`03G_Moogoo00Eoo`03G_Moogoo019oo`03G_Moogoo00ioo`03G_Moogoo00Uo
o`<1E`Qoo`03G_Moogoo00Qoo`03G_Moogoo00Yoo`03G_Moogoo00ioo`03G_Moogoo00Ioo`03001o
ogoo04=oo`00?7oo00<007ooOol057oo00=NmgooOol06Goo00=NmgooOol01Woo00=NmgooOol09Goo
00=NmgooOol07Goo00=NmgooOol01Woo00=NmgooOol04Woo00=NmgooOol03Woo00=NmgooOol02Goo
00=Nm`6GOol027oo00=NmgooOol027oo00=NmgooOol02Woo00=NmgooOol03Woo00=NmgooOol01Goo
0P00AGoo000lOol00`00Oomoo`0DOol00ekgOomoo`0HOol00ekgOomoo`07Ool00ekgOomoo`0UOol0
0ekgOomoo`0LOol00ekgOomoo`07Ool00ekgOomoo`0AOol00ekgOomoo`0?Ool00ekgOomoo`09Ool3
0IL8Ool00ekgOomoo`08Ool00ekgOomoo`0:Ool00ekgOomoo`0>Ool00ekgOomoo`06Ool00`00Oomo
o`13Ool003aoo`03001oogoo01Aoo`03G_Moogoo01Moo`03G_Moogoo00Uoo`03G_Moogoo02Aoo`03
G_Moogoo01aoo`03G_Moogoo00Qoo`03G_Moogoo011oo`03G_Moogoo00ioo`03G_Moogoo00Yoo`03
G_L1egoo00Qoo`03G_Moogoo00Qoo`03G_Moogoo00Yoo`03G_Moogoo00moo`03G_Moogoo00Eoo`03
001oogoo04=oo`00?7oo00<007ooOol057oo00=NmgooOol05Goo0Ukg37oo00=NmgooOol097oo00=N
mgooOol06goo00=NmgooOol02Goo00=NmgooOol047oo00=NmgooOol03Woo00=NmgooOol02Woo0`7G
27oo00=NmgooOol02Goo00=NmgooOol02Goo00=NmgooOol03goo00=NmgooOol01Goo00<007ooOol0
@goo000lOol00`00Oomoo`0DOol00ekgOomoo`0DOol00ekgOomoo`0<Ool00ekgOomoo`0UOol00ekg
Oomoo`0JOol00ekgOomoo`09Ool00ekgOomoo`0?Ool00ekgOomoo`0?Ool00ekgOomoo`0:Ool00ekg
0SMoo`08Ool00ekgOomoo`09Ool00ekgOomoo`0:Ool00ekgOomoo`0?Ool00ekgOomoo`04Ool00`00
Oomoo`13Ool003aoo`03001oogoo01Aoo`03G_Moogoo01=oo`03G_Moogoo00eoo`03G_Moogoo02Eo
o`03G_Moogoo01Uoo`03G_Moogoo00Yoo`03G_Moogoo00moo`03G_Moogoo00moo`03G_Moogoo00Yo
o`<2=`Qoo`03G_Moogoo00Uoo`03G_Moogoo00Yoo`03G_Moogoo00moo`03G_Moogoo00Aoo`03001o
ogoo04=oo`00?7oo00<007ooOol057oo00=NmgooOol04Woo00=NmgooOol03Woo00=NmgooOol09Goo
00=NmgooOol06Goo00=NmgooOol02goo00=NmgooOol03Woo00=NmgooOol03goo00=NmgooOol02Woo
00=Nm`9gOol027oo00=NmgooOol02Goo00=NmgooOol02Woo00=NmgooOol03goo00=NmgooOol017oo
00<007ooOol0@goo000lOol00`00Oomoo`0DOol00ekgOomoo`0@Ool2G_LAOol00ekgOomoo`0UOol0
0ekgOomoo`0HOol00ekgOomoo`0<Ool00ekgOomoo`0=Ool00ekgOomoo`0@Ool00ekgOomoo`0:Ool3
0WL8Ool00ekgOomoo`09Ool00ekgOomoo`0:Ool00ekgOomoo`0@Ool00ekgOomoo`03Ool00`00Oomo
o`13Ool003aoo`03001oogoo01Aoo`03G_Moogoo00moo`03G_Moogoo015oo`03G_Moogoo02Eoo`03
G_Moogoo01Moo`03G_Moogoo00eoo`03G_Moogoo00eoo`03G_Moogoo00moo`03G_Moogoo00]oo`03
G_L2]goo00Qoo`03G_Moogoo00Uoo`03G_Moogoo00Yoo`03G_Moogoo011oo`03G_Moogoo00=oo`03
001oogoo04=oo`00?7oo00<007ooOol057oo00=NmgooOol03Woo00=NmgooOol04Woo00=NmgooOol0
9Goo00=NmgooOol05goo00=NmgooOol03Goo00=NmgooOol03Goo00=NmgooOol03goo00=NmgooOol0
2goo0`:g27oo00=NmgooOol02Goo00=NmgooOol02Woo00=NmgooOol047oo00=NmgooOol00goo00<0
07ooOol0@goo000lOol00`00Oomoo`0EOol00ekgOomoo`0<Ool00ekgOomoo`0COol00ekgOomoo`0U
Ool00ekgOomoo`0FOol00ekgOomoo`0?Ool00ekgOomoo`0;Ool00ekgOomoo`0@Ool00ekgOomoo`0:
Ool00ekgOol2mP09Ool00ekgOomoo`09Ool00ekgOomoo`0;Ool00ekgOomoo`0@Ool00ekgOomoo`02
Ool00`00Oomoo`13Ool003aoo`03001oogoo01Eoo`03G_Moogoo00Yoo`9NmaMoo`03G_Moogoo02Ao
o`03G_Moogoo01Ioo`03G_Moogoo00moo`03G_Moogoo00]oo`03G_Moogoo011oo`03G_Moogoo00Yo
o`04G_L2mP;f0_H8Ool00ekgOomoo`09Ool00ekgOomoo`0;Ool00ekgOomoo`0@Ool015kgOomoogoo
0P00AGoo000lOol00`00Oomoo`0EOol00ekgOomoo`09Ool00ekgOomoo`0GOol00ekgOomoo`0UOol0
0ekgOomoo`0DOol00ekgOomoo`0@Ool00ekgOomoo`0;Ool00ekgOomoo`0@Ool00ekgOomoo`0:Ool0
0ekg0_@2mP09Ool00ekgOomoo`09Ool00ekgOomoo`0;Ool00ekgOomoo`0@Ool00ekgOomoo`02Ool0
0`00Oomoo`13Ool003aoo`03001oogoo01Eoo`03G_Moogoo00Qoo`03G_Moogoo01Qoo`03G_Moogoo
02Eoo`03G_Moogoo01=oo`03G_Moogoo015oo`03G_Moogoo00Yoo`03G_Moogoo011oo`03G_Moogoo
00]oo`<2m0Uoo`03G_Moogoo00Uoo`03G_Moogoo00]oo`03G_Moogoo015oo`05G_MoogooOol00015
Ool003aoo`03001oogoo01Eoo`03G_Moogoo00Moo`03G_Moogoo01Uoo`03G_Moogoo02Eoo`03G_Mo
ogoo01=oo`03G_Moogoo019oo`03G_Moogoo00Uoo`03G_Moogoo011oo`03G_Moogoo00]oo`03G_L2
lWoo00Uoo`03G_Moogoo00Yoo`03G_Moogoo00Yoo`03G_Moogoo015oo`05G_MoogooOol00015Ool0
03aoo`03001oogoo01Eoo`03G_Moogoo00Eoo`9Nmaaoo`03G_Moogoo02Eoo`03G_Moogoo019oo`03
G_Moogoo01=oo`03G_Moogoo00Uoo`03G_Moogoo011oo`03G_Moogoo00]oo`<2lPUoo`03G_Moogoo
00Yoo`03G_Moogoo00]oo`03G_Moogoo011oo`05G_MoogooOol00015Ool003aoo`03001oogoo01Eo
o`03G_Moogoo00Aoo`03G_Moogoo01aoo`03G_Moogoo02Eoo`03G_Moogoo019oo`03G_Moogoo01=o
o`03G_Moogoo00Qoo`03G_Moogoo015oo`03G_Moogoo00]oo`03G_L2kgoo00Uoo`03G_Moogoo00Yo
o`03G_Moogoo00]oo`03G_Moogoo015oo`04G_Moogoo0015Ool003aoo`03001oogoo01Eoo`03G_Mo
ogoo00=oo`03G_Moogoo01eoo`03G_Moogoo02Eoo`03G_Moogoo015oo`03G_Moogoo01Eoo`03G_Mo
ogoo00Moo`03G_Moogoo015oo`03G_Moogoo00]oo`<2k`Uoo`03G_Moogoo00Yoo`03G_Moogoo00]o
o`03G_Moogoo015oo`04G_Moogoo0015Ool003aoo`03001oogoo01Eoo`03G_Moogoo009oo`03G_Mo
ogoo01ioo`03G_Moogoo02Eoo`03G_Moogoo015oo`03G_Moogoo01Eoo`03G_Moogoo00Moo`03G_Mo
ogoo011oo`03G_Moogoo00aoo`03G_L2kGoo00Uoo`03G_Moogoo00Yoo`03G_Moogoo00]oo`03G_Mo
ogoo015oo`04G_Moogoo0015Ool003aoo`03001oogoo01Eoo`03G_Moogoo009Nmb9oo`03G_Moogoo
02Eoo`03G_Moogoo00moo`03G_Moogoo01Ioo`03G_Moogoo00Ioo`03G_Moogoo015oo`03G_Moogoo
00aoo`<2k@Uoo`03G_Moogoo00Yoo`03G_Moogoo00]oo`03G_Moogoo019oo`03G_Moo`0004Eoo`00
?7oo00<007ooOol05Goo00=NmgooG_L097oo00=NmgooOol09Goo00=NmgooOol03Woo00=NmgooOol0
5goo00=NmgooOol01Woo00=NmgooOol04Goo00=NmgooOol037oo00=Nm`;[Ool02Goo00=NmgooOol0
2Woo00=NmgooOol037oo00=NmgooOol04Goo00=Nmgoo0000AGoo000lOol00`00Oomoo`0FOol00ekg
Oomoo`0SOol00ekgOomoo`0UOol00ekgOomoo`0>Ool00ekgOomoo`0HOol00ekgOomoo`05Ool00ekg
Oomoo`0AOol00ekgOomoo`0;Ool015kg0^/2j0;[2Goo00=NmgooOol02Woo00=NmgooOol037oo00=N
mgooOol04Goo00=Nmgoo0000AGoo000lOol00`00Oomoo`0EOol2G_LUOol00ekgOomoo`0UOol00ekg
Oomoo`0=Ool00ekgOomoo`0IOol00ekgOomoo`04Ool00ekgOomoo`0BOol00ekgOomoo`0;Ool015kg
0^P2j0;X2Goo00=NmgooOol02Woo00=NmgooOol037oo00=NmgooOol04Woo00=Nm`00Ool0A7oo000l
Ool00`00Oomoo`0COol2G_L00gooG_Moo`0TOol00ekgOomoo`0UOol00ekgOomoo`0=Ool00ekgOomo
o`0IOol00ekgOomoo`04Ool00ekgOomoo`0AOol00ekgOomoo`0<Ool00ekgOol2iP0:Ool00ekgOomo
o`0:Ool00ekgOomoo`0<Ool00ekgOomoo`0BOol00ekg001oo`14Ool003aoo`03001oogoo019oo`05
G_MoogooOomNm`0UOol00ekgOomoo`0UOol00ekgOomoo`0<Ool00ekgOomoo`0KOol00ekgOomoo`03
Ool00ekgOomoo`0AOol00ekgOomoo`0<Ool015kg0^H2iP;V2Goo00=NmgooOol02goo00=NmgooOol0
2goo00=NmgooOol04Woo00=Nm`00Ool0A7oo000lOol00`00Oomoo`0AOol00ekgOomoo`02Ool00ekg
Oomoo`0SOol00ekgOomoo`0UOol00ekgOomoo`0<Ool00ekgOomoo`0KOol00ekgOomoo`02Ool00ekg
Oomoo`0BOol00ekgOomoo`0<Ool00ekgOol2i00:Ool00ekgOomoo`0;Ool00ekgOomoo`0<Ool00ekg
Oomoo`0BOol00ekgOomoo`13Ool003aoo`03001oogoo011oo`03G_Moogoo00=oo`03G_Moogoo02=o
o`03G_Moogoo02Eoo`03G_Moogoo00]oo`03G_Moogoo01aoo`03G_Moogoo009oo`03G_Moogoo019o
o`03G_Moogoo00aoo`04G_L2i0;S0^@9Ool00ekgOomoo`0;Ool00ekgOomoo`0<Ool00ekgOomoo`0B
Ool00ekgOomoo`13Ool003aoo`03001oogoo00ioo`9Nm`Ioo`03G_Moogoo02=oo`03G_Moogoo02Io
o`03G_Moogoo00Uoo`03G_Moogoo01eoo`03G_Moogoo009oo`03G_Moogoo019oo`03G_Moogoo00ao
o`03G_Moo`;Q00Yoo`03G_Moogoo00]oo`03G_Moogoo00aoo`03G_Moogoo019oo`03001oogoo04=o
o`00?7oo00<007ooOol03Goo00=NmgooOol01Woo00=NmgooOol097oo00=NmgooOol09Goo00=Nmgoo
Ool02Goo00=NmgooOol07Woo00ANmgooOomNmaEoo`03G_Moogoo00aoo`04G_L2h@;Q0^49Ool00ekg
Oomoo`0;Ool00ekgOomoo`0<Ool00ekgOomoo`0BOol00`00Oomoo`13Ool003aoo`03001oogoo00ao
o`03G_Moogoo00Moo`03G_Moogoo02Aoo`03G_Moogoo02Eoo`03G_Moogoo00Qoo`03G_Moogoo01mo
o`04G_MoogooG_LDOol00ekgOomoo`0=Ool00ekgOol2h@0:Ool00ekgOomoo`0;Ool00ekgOomoo`0<
Ool00ekgOomoo`0BOol00`00Oomoo`13Ool003aoo`03001oogoo00]oo`03G_Moogoo00Uoo`03G_Mo
ogoo02=oo`03G_Moogoo02Eoo`03G_Moogoo00Qoo`03G_Moogoo01moo`04G_MoogooG_LDOol00ekg
Oomoo`0=Ool00ekgOomoo`0:Ool00ekgOomoo`0;Ool00ekgOomoo`0=Ool00ekgOomoo`0AOol00`00
Oomoo`13Ool003aoo`03001oogoo00Uoo`9Nm`aoo`03G_Moogoo02=oo`03G_Moogoo02Eoo`03G_Mo
ogoo00Moo`03G_Moogoo025oo`9NmaEoo`03G_Moogoo00eoo`03G_Moogoo00Yoo`03G_Moogoo00]o
o`03G_Moogoo00eoo`03G_Moogoo015oo`03001oogoo04=oo`00?7oo00<007ooOol027oo00=Nmgoo
Ool037oo00=NmgooOol08goo00=NmgooOol09Goo00=NmgooOol01Woo00=NmgooOol08Woo0Ukg5Goo
00=NmgooOol037oo00=NmgooOol02goo00=NmgooOol02goo00=NmgooOol03Goo00=NmgooOol04Goo
00<007ooOol0@goo000lOol00`00Oomoo`07Ool00ekgOomoo`0=Ool00ekgOomoo`0SOol00ekgOomo
o`0UOol00ekgOomoo`06Ool00ekgOomoo`0ROol2G_LEOol00ekgOomoo`0<Ool00ekgOomoo`0;Ool0
0ekgOomoo`0;Ool00ekgOomoo`0=Ool00ekgOomoo`0@Ool20015Ool003aoo`03001oogoo00Ioo`03
G_Moogoo00ioo`03G_Moogoo02=oo`03G_Moogoo02Eoo`03G_Moogoo00Eoo`03G_Moogoo02=oo`9N
maAoo`03G_Moogoo00eoo`03G_Moogoo00]oo`03G_Moogoo00]oo`03G_Moogoo00eoo`03G_Moogoo
015oo`03001oogoo04=oo`00?7oo00<007ooOol017oo0Ukg4Goo00=NmgooOol08goo00=NmgooOol0
9Woo00=NmgooOol017oo00=NmgooOol08goo0Ukg57oo00=NmgooOol03Goo00=NmgooOol02goo00=N
mgooOol037oo00=NmgooOol03Goo00=NmgooOol047oo00<007ooOol0@goo000lOol00`00Oomoo`03
Ool00ekgOomoo`0AOol00ekgOomoo`0SOol00ekgOomoo`0VOol00ekgOomoo`03Ool00ekgOomoo`0T
Ool2G_LDOol00ekgOomoo`0=Ool00ekgOomoo`0;Ool00ekgOomoo`0<Ool00ekgOomoo`0=Ool00ekg
Oomoo`0@Ool00`00Oomoo`13Ool003aoo`03001oogoo009oo`03G_Moogoo019oo`03G_Moogoo02Ao
o`03G_Moogoo02Eoo`03G_Moogoo00=oo`03G_Moogoo02=oo`04G_MoogooG_LCOol00ekgOomoo`0=
Ool00ekgOomoo`0;Ool00ekgOomoo`0<Ool00ekgOomoo`0=Ool00ekgOomoo`0@Ool00`00Oomoo`13
Ool003aoo`05001oogooOomNm`0EOol00ekgOomoo`0TOol00ekgOomoo`0UOol00ekgOomoo`02Ool0
0ekgOomoo`0TOol015kgOomooekg4goo00=NmgooOol03Goo00=NmgooOol02goo00=NmgooOol037oo
00=NmgooOol03Goo00=NmgooOol047oo00<007ooOol0@goo000lOol01000OomNmekg5Woo00=Nmgoo
Ool097oo00=NmgooOol09Goo00ENmgooOomooekg02Moo`04G_MoogooG_LBOol00ekgOomoo`0>Ool0
0ekgOomoo`0;Ool00ekgOomoo`0<Ool00ekgOomoo`0=Ool00ekgOomoo`0@Ool00`00Oomoo`13Ool0
03aoo`03001Nmgoo01Qoo`03G_Moogoo02=oo`03G_Moogoo02Eoo`05G_MoogooOomNm`0VOol01Ekg
OomoogooG_L04Woo00=NmgooOol03Woo00=NmgooOol02goo00=NmgooOol037oo00=NmgooOol03Woo
00=NmgooOol03goo00<007ooOol0@goo000lOol00ekgOomoo`0HOol00ekgOomoo`0SOol00ekgOomo
o`0VOol00ekgOomNm`0WOol00ekgOomoo`02Ool00ekgOomoo`0?Ool00ekgOomoo`0>Ool00ekgOomo
o`0;Ool00ekgOomoo`0<Ool00ekgOomoo`0>Ool00ekgOomoo`0?Ool00ekgOomoo`13Ool003Aoo`80
00Ioo`03001oogoo01Qoo`03G_Moogoo02=oo`03G_Moogoo02Ioo`03G_Mooekg02Moo`03G_Moogoo
009oo`03G_Moogoo00moo`03G_Moogoo00ioo`03G_Moogoo00]oo`03G_Moogoo00aoo`03G_Moogoo
00ioo`03G_Moogoo00moo`03G_Moogoo04=oo`00=Woo00<007ooOol00goo00<007ooOol067oo00=N
mgooOol08goo00=NmgooOol09Woo0Ukg9goo00=NmgooOol00goo00=NmgooOol03goo00=NmgooOol0
3Woo00=NmgooOol02goo00=NmgooOol037oo00=NmgooOol03Woo00=NmgooOol03Woo00=Nm`00Ool0
A7oo000eOol00`00Oomoo`04Ool2000IOol00ekgOomoo`0TOol00ekgOomoo`0UOol2G_LWOol00ekg
Oomoo`04Ool00ekgOomoo`0=Ool00ekgOomoo`0>Ool00ekgOomoo`0<Ool00ekgOomoo`0<Ool00ekg
Oomoo`0>Ool00ekgOomoo`0=Ool00`00G_L00015Ool003Ioo`03001oogoo00=oo`03001oogoo01Qo
o`03G_Moogoo02Aoo`03G_Moogoo02Eoo`9NmbMoo`03G_Moogoo00Aoo`03G_Moogoo00eoo`03G_Mo
ogoo00ioo`03G_Moogoo00aoo`03G_Moogoo00aoo`03G_Moogoo00moo`03G_Moogoo00aoo`03G_Mo
o`0004Eoo`00=7oo00<007oo00001Goo00<007ooOol067oo00=NmgooOol097oo00=NmgooOol097oo
00=NmgooG_L09Woo00=NmgooOol01Goo00=NmgooOol03Goo00=NmgooOol03Woo00=NmgooOol037oo
00=NmgooOol03Goo00=NmgooOol03Woo00=NmgooOol037oo00=Nmgoo0000AGoo000eOol00`00Oomo
o`04Ool00`00Oomoo`0HOol00ekgOomoo`0TOol00ekgOomoo`0TOol00ekgOomNm`0VOol00ekgOomo
o`06Ool00ekgOomoo`0<Ool00ekgOomoo`0>Ool00ekgOomoo`0<Ool00ekgOomoo`0=Ool00ekgOomo
o`0>Ool00ekgOomoo`0;Ool015kgOomoo`00AGoo000lOol00`00Oomoo`0HOol00ekgOomoo`0TOol0
0ekgOomoo`0SOol015kgOomooekg9Woo00=NmgooOol01Woo00=NmgooOol037oo00=NmgooOol03Woo
00=NmgooOol037oo00=NmgooOol03Goo00=NmgooOol03Woo00=NmgooOol02goo00ANmgooOol004Eo
o`00?7oo00<007ooOol06Goo00=NmgooOol08goo00=NmgooOol08goo00ENmgooOomooekg02Aoo`03
G_Moogoo00Moo`03G_Moogoo00]oo`03G_Moogoo00moo`03G_Moogoo00aoo`03G_Moogoo00eoo`03
G_Moogoo00ioo`03G_Moogoo00]oo`04G_Moogoo0015Ool003aoo`03001oogoo01Uoo`03G_Moogoo
02Aoo`03G_Moogoo025oo`03G_Moogoo009oo`03G_Moogoo029oo`03G_Moogoo00Qoo`03G_Moogoo
00Yoo`03G_Moogoo00moo`03G_Moogoo00aoo`03G_Moogoo00eoo`03G_Moogoo00moo`03G_Moogoo
00Uoo`05G_MoogooOol00015Ool003aoo`03001oogoo01Uoo`03G_Moogoo02Aoo`03G_Moogoo025o
o`03G_Moogoo009oo`03G_Moogoo029oo`03G_Moogoo00Qoo`03G_Moogoo00Yoo`03G_Moogoo00mo
o`03G_Moogoo00aoo`03G_Moogoo00eoo`03G_Moogoo00moo`03G_Moogoo00Uoo`05G_MoogooOol0
0015Ool003aoo`03001oogoo01Uoo`03G_Moogoo02Aoo`03G_Moogoo021oo`03G_Moogoo00=oo`03
G_Moogoo025oo`03G_Moogoo00Yoo`03G_Moogoo00Uoo`03G_Moogoo00moo`03G_Moogoo00aoo`03
G_Moogoo00eoo`03G_Moogoo00moo`03G_Moogoo00Qoo`03G_Moogoo009oo`03001oogoo04=oo`00
?7oo00<007ooOol06Goo00=NmgooOol097oo00=NmgooOol07goo00=NmgooOol017oo00=NmgooOol0
8Goo00=NmgooOol02Woo00=NmgooOol02Goo00=NmgooOol03goo00=NmgooOol037oo00=NmgooOol0
3Goo00=NmgooOol03goo00=NmgooOol027oo00=NmgooOol00Woo00<007ooOol0@goo000lOol00`00
Oomoo`0IOol00ekgOomoo`0TOol00ekgOomoo`0OOol00ekgOomoo`05Ool00ekgOomoo`0POol00ekg
Oomoo`0;Ool00ekgOomoo`08Ool00ekgOomoo`0?Ool00ekgOomoo`0<Ool00ekgOomoo`0=Ool00ekg
Oomoo`0?Ool00ekgOomoo`08Ool00ekgOomoo`02Ool00`00Oomoo`13Ool003aoo`03001oogoo01Uo
o`03G_Moogoo02Aoo`03G_Moogoo01ioo`03G_Moogoo00Ioo`03G_Moogoo01moo`03G_Moogoo00ao
o`03G_Moogoo00Moo`03G_Moogoo00moo`03G_Moogoo00eoo`03G_Moogoo00eoo`03G_Moogoo011o
o`03G_Moogoo00Ioo`03G_Moogoo009oo`8004Eoo`00?7oo00<007ooOol06Goo00=NmgooOol09Goo
00=NmgooOol07Goo00=NmgooOol01Woo00=NmgooOol07goo00=NmgooOol03Goo00=NmgooOol01Woo
00=NmgooOol03goo00=NmgooOol03Goo00=NmgooOol03Goo00=NmgooOol047oo00=NmgooOol01Woo
00=NmgooOol00goo00<007ooOol0@goo000lOol00`00Oomoo`0IOol00ekgOomoo`0UOol00ekgOomo
o`0LOol00ekgOomoo`07Ool00ekgOomoo`0OOol00ekgOomoo`0=Ool00ekgOomoo`06Ool00ekgOomo
o`0?Ool00ekgOomoo`0=Ool00ekgOomoo`0>Ool00ekgOomoo`0?Ool00ekgOomoo`05Ool00ekgOomo
o`04Ool00`00Oomoo`13Ool003aoo`03001oogoo01Yoo`03G_Moogoo02Aoo`03G_Moogoo01]oo`03
G_Moogoo00Uoo`03G_Moogoo01eoo`03G_Moogoo00moo`03G_Moogoo00Eoo`03G_Moogoo00moo`03
G_Moogoo00eoo`03G_Moogoo00ioo`03G_Moogoo00moo`03G_Moogoo00Eoo`03G_Moogoo00Aoo`03
001oogoo04=oo`00?7oo00<007ooOol06Woo00=NmgooOol097oo00=NmgooOol06goo00=NmgooOol0
2Goo00=NmgooOol07Goo00=NmgooOol03goo00=NmgooOol01Goo00=NmgooOol03goo00=NmgooOol0
3Goo00=NmgooOol03Woo00=NmgooOol03goo00=NmgooOol017oo00=NmgooOol01Goo00<007ooOol0
@goo000lOol00`00Oomoo`0JOol00ekgOomoo`0TOol00ekgOomoo`0JOol00ekgOomoo`0:Ool00ekg
Oomoo`0MOol00ekgOomoo`0@Ool00ekgOomoo`03Ool00ekgOomoo`0@Ool00ekgOomoo`0=Ool00ekg
Oomoo`0>Ool00ekgOomoo`0?Ool00ekgOomoo`04Ool00ekgOomoo`05Ool00`00Oomoo`13Ool003ao
o`03001oogoo01Yoo`03G_Moogoo02Aoo`03G_Moogoo01Yoo`03G_Moogoo00Yoo`03G_Moogoo01ao
o`03G_Moogoo015oo`03G_Moogoo00=oo`03G_Moogoo011oo`03G_Moogoo00eoo`03G_Moogoo00io
o`03G_Moogoo011oo`03G_Moogoo00=oo`03G_Moogoo00Eoo`03001oogoo04=oo`00?7oo00<007oo
Ool06Woo00=NmgooOol09Goo00=NmgooOol067oo00=NmgooOol02goo00=NmgooOol077oo00=Nmgoo
Ool04Woo00=NmgooOol00Woo00=NmgooOol047oo00=NmgooOol03Goo00=NmgooOol03Woo00=Nmgoo
Ool047oo00=NmgooOol00Woo00=NmgooOol01Woo00<007ooOol0@goo000lOol00`00Oomoo`0JOol0
0ekgOomoo`0UOol00ekgOomoo`0HOol00ekgOomoo`0<Ool00ekgOomoo`0KOol00ekgOomoo`0BOol0
0ekgOomoo`02Ool00ekgOomoo`0@Ool00ekgOomoo`0=Ool00ekgOomoo`0>Ool00ekgOomoo`0@Ool0
0ekgOomoo`02Ool00ekgOomoo`06Ool00`00Oomoo`13Ool003aoo`03001oogoo01Yoo`03G_Moogoo
02Eoo`03G_Moogoo01Moo`03G_Moogoo00eoo`03G_Moogoo01Yoo`03G_Moogoo01Aoo`05G_Moogoo
OomNm`0BOol00ekgOomoo`0=Ool00ekgOomoo`0>Ool00ekgOomoo`0@Ool01EkgOomoogooG_L02Goo
00<007ooOol0@goo000lOol00`00Oomoo`0JOol00ekgOomoo`0UOol00ekgOomoo`0FOol00ekgOomo
o`0>Ool00ekgOomoo`0JOol00ekgOomoo`0DOol015kgOomooekg4goo00=NmgooOol03Goo00=Nmgoo
Ool03Woo00=NmgooOol047oo00ENmgooOomooekg00Uoo`03001oogoo04=oo`00?7oo00<007ooOol0
6Woo00=NmgooOol09Goo00=NmgooOol05Woo00=NmgooOol03Woo00=NmgooOol06Woo00=NmgooOol0
5Goo00=NmgooG_L04Woo00=NmgooOol03Woo00=NmgooOol03Woo00=NmgooOol04Goo00=NmgooG_L0
2Goo0P00AGoo000lOol00`00Oomoo`0JOol00ekgOomoo`0UOol00ekgOomoo`0EOol00ekgOomoo`0@
Ool00ekgOomoo`0HOol00ekgOomoo`0FOol00ekgOomNm`0BOol00ekgOomoo`0>Ool00ekgOomoo`0?
Ool00ekgOomoo`0@Ool00ekgOomNm`0:Ool00`00Oomoo`13Ool003aoo`03001oogoo01]oo`03G_Mo
ogoo02Eoo`03G_Moogoo01Aoo`03G_Moogoo011oo`03G_Moogoo01Qoo`03G_Moogoo01Moo`9Nma9o
o`03G_Moogoo00ioo`03G_Moogoo00moo`03G_Moogoo011oo`9Nm`]oo`03001oogoo04=oo`00?7oo
00<007ooOol06goo00=NmgooOol09Goo00=NmgooOol04goo00=NmgooOol04Goo00=NmgooOol067oo
00=NmgooOol05goo0Ukg4Woo00=NmgooOol03Woo00=NmgooOol03goo00=NmgooOol047oo0Ukg2goo
00<007ooOol0@goo000lOol00`00Oomoo`0KOol00ekgOomoo`0UOol00ekgOomoo`0COol00ekgOomo
o`0AOol00ekgOomoo`0GOol00ekgOomoo`0HOol2G_LBOol00ekgOomoo`0>Ool00ekgOomoo`0?Ool0
0ekgOomoo`0@Ool00ekgOomoo`0:Ool00`00Oomoo`13Ool003aoo`03001oogoo01]oo`03G_Moogoo
02Eoo`03G_Moogoo019oo`03G_Moogoo01=oo`03G_Moogoo01Ioo`03G_Moogoo01Qoo`03G_Mooekg
015oo`03G_Moogoo00ioo`03G_Moogoo00moo`03G_Moogoo00moo`03G_Mooekg00]oo`03001oogoo
04=oo`00?7oo00<007ooOol06goo00=NmgooOol09Goo00=NmgooOol04Goo00=NmgooOol057oo00=N
mgooOol05Woo00=NmgooOol067oo00=NmgooG_L04Goo00=NmgooOol03Woo00=NmgooOol03goo00=N
mgooOol03goo00=NmgooG_L02goo00<007ooOol0@goo000lOol00`00Oomoo`0KOol00ekgOomoo`0U
Ool00ekgOomoo`0AOol00ekgOomoo`0DOol00ekgOomoo`0EOol00ekgOomoo`0IOol015kgOomooekg
47oo00=NmgooOol03Woo00=NmgooOol03goo00=NmgooOol03Woo00ANmgooOomNm`]oo`03001oogoo
04=oo`00?7oo00<007ooOol06goo00=NmgooOol09Woo00=NmgooOol03goo00=NmgooOol05Goo00=N
mgooOol05Goo00=NmgooOol06Goo00ENmgooOomooekg00moo`03G_Moogoo00ioo`03G_Moogoo00mo
o`03G_Moogoo00eoo`05G_MoogooOomNm`0;Ool00`00Oomoo`13Ool003aoo`03001oogoo01]oo`03
G_Moogoo02Ioo`03G_Moogoo00moo`03G_Moogoo01Ioo`03G_Moogoo01Aoo`03G_Moogoo01Uoo`05
G_MoogooOomNm`0?Ool00ekgOomoo`0>Ool00ekgOomoo`0?Ool00ekgOomoo`0=Ool01EkgOomoogoo
G_L02goo00<007ooOol0@goo000lOol00`00Oomoo`0KOol00ekgOomoo`0VOol00ekgOomoo`0>Ool0
0ekgOomoo`0GOol00ekgOomoo`0COol00ekgOomoo`0IOol00ekgOomoo`03Ool00ekgOomoo`0<Ool0
0ekgOomoo`0>Ool00ekgOomoo`0?Ool00ekgOomoo`0<Ool00ekgOomoo`03Ool00ekgOomoo`08Ool0
0`00Oomoo`13Ool003aoo`03001oogoo01aoo`03G_Moogoo02Eoo`03G_Moogoo00eoo`03G_Moogoo
01Qoo`03G_Moogoo01=oo`03G_Moogoo01Uoo`03G_Moogoo00=oo`03G_Moogoo00aoo`03G_Moogoo
00ioo`03G_Moogoo00moo`03G_Moogoo00aoo`03G_Moogoo00=oo`03G_Moogoo00Moo`8004Eoo`00
?7oo00<007ooOol077oo00=NmgooOol09Goo00=NmgooOol03Goo00=NmgooOol06Goo00=NmgooOol0
4Woo00=NmgooOol06Goo00=NmgooOol017oo00=NmgooOol02Woo00=NmgooOol03goo00=NmgooOol0
47oo00=NmgooOol02Woo00=NmgooOol017oo00=NmgooOol027oo00<007ooOol0@goo000lOol00`00
Oomoo`0LOol00ekgOomoo`0UOol00ekgOomoo`0<Ool00ekgOomoo`0JOol00ekgOomoo`0AOol00ekg
Oomoo`0JOol00ekgOomoo`05Ool00ekgOomoo`09Ool00ekgOomoo`0?Ool00ekgOomoo`0@Ool00ekg
Oomoo`09Ool00ekgOomoo`05Ool00ekgOomoo`08Ool00`00Oomoo`13Ool003aoo`03001oogoo01ao
o`03G_Moogoo02Ioo`03G_Moogoo00]oo`03G_Moogoo01Yoo`03G_Moogoo015oo`03G_Moogoo01Yo
o`03G_Moogoo00Ioo`03G_Moogoo00Qoo`03G_Moogoo00moo`03G_Moogoo011oo`03G_Moogoo00Qo
o`03G_Moogoo00Ioo`03G_Moogoo00Qoo`03001oogoo04=oo`00?7oo00<007ooOol03goo00<007oo
Ool02Woo00=NmgooOol05Goo00<007ooOol03Woo00=NmgooOol02Woo00=NmgooOol017oo00<007oo
Ool057oo00=NmgooOol02goo00<007ooOol00goo00=NmgooOol06Goo00=Nmgoo00001goo00=Nmgoo
Ool027oo00=NmgooOol03goo00=NmgooOol047oo00=NmgooOol027oo00=NmgooOol017oo00@007oo
OomNm`Uoo`03001oogoo04=oo`00?7oo00<007ooOol01Woo00<007ooOol01Woo00<007ooOol01Woo
00D007ooOomooekg00Aoo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo
00Eoo`03G_L007oo00Qoo`03001ooekg00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo
00=oo`04G_Moogoo0009Ool00`00Oomoo`02Ool01EkgOomoogoo000027oo00<007ooOol01Woo00<0
07ooOol017oo00=Nmgoo000027oo00=Nm`00Ool01goo00=NmgooOol01Woo00<007ooOol01Woo00=N
mgooOol01goo00<007ooOol01Woo00=NmgooOol01Woo00<005kgOol01Woo00@007ooOomNm`Eoo`05
001oogooOol00015Ool003aooal00003G_L0000002H00003G_L0000000T00003G_L0000001d00003
G_L0000000l00003G_L0000001X00003G_L0000000T00003G_L0000000H00003G_L0000000l00003
G_L0000001000003G_L0000000H00003G_L0000000T00003G_L0000000P004Eoo`00ogooOgoo003o
OomoOol00?moogmoo`00ogooOgoo003oOomoOol00?moogmoo`00ogooOgoo003oOomoOol00?moogmo
o`00ogooOgoo003oOomoOol00?moogmoo`00ogooOgoo003oOomoOol00?moogmoo`00ogooOgoo003o
OomoOol006Uoo`03001oogoo01Moo`03001oogoo00Uoo`03001oogoo01Ioo`03001oogoo00Uoo`03
001oogoo045oo`03001oogoo00Qoo`03001oogoo02aoo`03001oogoo04Uoo`00J7oo00<007ooOol0
37oo00<007ooOol02Woo00<007ooOol01goo00<007ooOol02goo00<007ooOol02Woo00<007ooOol0
1goo00<007ooOol047oo00<007ooOol08Woo00<007ooOol02goo00<007ooOol01Woo00<007ooOol0
47oo00<007ooOol03Woo00<007ooOol02Woo00<007ooOol0B7oo001NOol30006Ool00`00Oomoo`02
Ool30008Ool00`00Oomoo`03Ool30005Ool00`00Oomoo`05Ool00`00Oomoo`02Ool30007Ool00`00
Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`05Ool00`00Oomoo`02Ool3000<Ool00`00Oomoo`04
Ool00`00Oomoo`02Ool01000Oomoogoo0`0027oo0`001goo00<007ooOol017oo0`001Goo00<007oo
Ool017oo00<007ooOol00Woo0`0037oo00<007ooOol017oo0`001goo00<007ooOol00Woo1@0017oo
00<007ooOol0Agoo001POol20005Ool00`00Oomoo`04Ool20005Ool50003Ool00`00Oomoo`05Ool0
0`00Oomoo`05Ool00`00Oomoo`04Ool20004Ool50003Ool00`00Ool00005Ool00`00Oomoo`05Ool0
0`00Oomoo`04Ool20009Ool50003Ool00`00Ool00007Ool00`00Oomoo`0:Ool20004Ool50004Ool0
0`00Oomoo`05Ool00`00Oomoo`04Ool00`00Oomoo`04Ool20009Ool50006Ool20004Ool50004Ool0
0`00Oomoo`04Ool00`00Oomoo`17Ool005moo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo
00Moo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo
00Ioo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo00Eoo`03001oogoo00=oo`03001oogoo
009oo`<000Ioo`03001oogoo00=oo`03001oo`0000Qoo`03001oogoo00Qoo`03001oogoo00Ioo`03
001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00=oo`03001oogoo009oo`<0
00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo
04Moo`00Ggoo0`001Goo00<007ooOol00goo0`001goo00<007ooOol017oo00<007ooOol017oo00<0
07ooOol01Goo00<007ooOol00goo0`001Woo00<007ooOol00goo0P001Woo00<007ooOol01Goo00<0
07ooOol00goo0`000Woo0P001goo00<007ooOol00goo00<007oo000027oo00<007ooOol027oo0`00
1Woo00<007ooOol01Goo00<007ooOol017oo00<007ooOol017oo00<007ooOol00goo0`000Woo0P00
1goo00<007ooOol01Goo0`001Woo00<007ooOol017oo00<007ooOol017oo00<007ooOol0Agoo0012
Ool20008Ool2000JOol00`00Oomoo`0BOol00`00Ool00004Ool00`00Oomoo`07Ool00`00Oomoo`0A
Ool00`00Oomoo`04Ool00`00Oomoo`07Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Ool00007
Ool00`00Ool0000IOol00`00Ool00004Ool00`00Oomoo`06Ool00`00Oomoo`09Ool00`00Oomoo`0L
Ool00`00Oomoo`03Ool00`00Oomoo`18Ool0049oo`03001oogoo00Qoo`03001oogoo01Uoo`03001o
ogoo019oo`03001oogoo009oo`03001oogoo00Uoo`03001oogoo011oo`<000=oo`03001oogoo00Uo
o`03001oogoo00Qoo`03001oogoo00]oo`03001oogoo00Moo`03001oogoo01Uoo`03001oogoo009o
o`03001oogoo00Qoo`03001oogoo00Qoo`03001oogoo01]oo`8000Aoo`03001oogoo04Uoo`00>goo
0P001Goo00@007ooOomoo`8000Eoo`03001oogoo009oo`@006Moo`<004aoo`<006moo`00>Woo00<0
07oo00001Goo00<007ooOol00goo00<007ooOol00Woo00<007ooOol02googP00AGoo000jOol01000
Ool0000017oo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00Woo1000ogoo:Goo000jOol0
0`00Oomoo`05Ool00`00Oomoo`02Ool20004Ool00`00Oomoo`3oOol_Ool003Yoo`03001oogoo00Eo
o`03001oogoo00Qoo`03001oogoo05Moo`03001oogoo01Moo`03001oogoo00Qoo`03001oogoo01eo
o`03001oogoo08moo`00>Woo0`001Goo0P0027oo0P00F7oo00<007ooOol02goo00<007ooOol02goo
00<007ooOol01Woo00<007ooOol037oo00<007ooOol047oo00<007ooOol0SWoo002UOol00`00Oomo
o`02Ool30007Ool00`00Oomoo`05Ool30004Ool00`00Oomoo`04Ool00`00Oomoo`02Ool30008Ool0
0`00Oomoo`02Ool50002Ool00`00Oomoo`05Ool00`00Oomoo`2=Ool00:Eoo`03001oogoo00Aoo`80
00Aoo`D000Ioo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo00Aoo`8000Eoo`D000Aoo`07
001oogooOol007oo00001Woo00<007ooOol0SGoo002UOol00`00Oomoo`03Ool00`00Oomoo`06Ool0
0`00Oomoo`04Ool40004Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`07Ool00`00Oomo
o`04Ool01`00Oomoogoo001oo`0000Ioo`03001oogoo08eoo`00YGoo00<007ooOol00goo0`001Woo
00<007ooOol017oo00<007oo00001Goo00<007ooOol017oo00<007ooOol00goo0`001goo00<007oo
Ool017oo00L007ooOomoo`00Ool00006Ool00`00Oomoo`2=Ool00:Ioo`03001oogoo01=oo`8000Ao
o`03001oogoo00Ioo`03001oogoo01=oo`07001oogooOol007oo00001Goo00<007ooOol0SWoo002W
Ool00`00Oomoo`0COol01@00Oomoogoo00002Woo00<007ooOol04Goo0P0017oo00<007ooOol00goo
00<007ooOol0Sgoo003oOomoOol00?moogmoo`00ogooOgoo003oOomoOol00?moogmoo`00ogooOgoo
003oOomoOol00?moogmoo`00ogooOgoo003oOomoOol00?moogmoo`00ogooOgoo003oOomoOol00?mo
ogmoo`00ogooOgoo003oOomoOol00?moogmoo`00ogooOgoo003oOomoOol00?moogmoo`00ogooOgoo
003oOomoOol00?moogmoo`00ogooOgoo003oOomoOol00?moogmoo`00ogooOgoo003oOomoOol00?mo
ogmoo`00ogooOgoo003oOomoOol00?moogmoo`00ogooOgoo003oOomoOol00001\
\>"],
  ImageRangeCache->{{{0, 381.188}, {538.063, 0}} -> {-0.653492, -1.05086, \
0.00390608, 0.00390608}, {{9.0625, 325.5}, {525, 13}} -> {-14.2565, -4.76703, \
0.0542342, 0.0181752}, {{346.5, 372.063}, {397, 269}} -> {-27.6725, -44.2409, \
0.0798052, 0.313275}},
  CellTags->{"Root Locus", "i:11"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[120]=",
  CellTags->{"Root Locus", "i:11"}]
}, Open  ]],

Cell["\<\
The root locus can also be constructed for a range of gains that includes \
negative values:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"Root Locus", "i:11"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(RootLocus[G, s, k, \(-10\), \(+20. \), 1. ]\)], "Input",
  CellLabel->"In[121]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Root Locus", "i:11"}],

Cell[BoxData[
    \("\n                Zeros in green, Open loop poles in red\n"\)], "Print",\

  CellTags->{"Root Locus", "i:11"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.4104 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.438894 0.671621 0.705202 0.671621 [
[ 0 0 0 0 ]
[ 1 1.4104 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.0238095 0.033581 0.853978 1.37682 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.818737 0.0744307 0.809017 0.23549 [
[.07443 -0.0125 -9 -9 ]
[.07443 -0.0125 9 0 ]
[.22329 -0.0125 -6 -9 ]
[.22329 -0.0125 6 0 ]
[.37215 -0.0125 -6 -9 ]
[.37215 -0.0125 6 0 ]
[.52101 -0.0125 -6 -9 ]
[.52101 -0.0125 6 0 ]
[.66988 -0.0125 -6 -9 ]
[.66988 -0.0125 6 0 ]
[.81874 -0.0125 -3 -9 ]
[.81874 -0.0125 3 0 ]
[.9676 -0.0125 -3 -9 ]
[.9676 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -17 -21.875 ]
[.5 -0.0125 17 -9 ]
[-0.0125 .10255 -12 -4.5 ]
[-0.0125 .10255 0 4.5 ]
[-0.0125 .33804 -12 -4.5 ]
[-0.0125 .33804 0 4.5 ]
[-0.0125 .57353 -12 -4.5 ]
[-0.0125 .57353 0 4.5 ]
[-0.0125 .80902 -6 -4.5 ]
[-0.0125 .80902 0 4.5 ]
[-0.0125 1.04451 -6 -4.5 ]
[-0.0125 1.04451 0 4.5 ]
[-0.0125 1.28 -6 -4.5 ]
[-0.0125 1.28 0 4.5 ]
[-0.0125 1.51549 -6 -4.5 ]
[-0.0125 1.51549 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .80902 -46.25 -6.4375 ]
[-0.01875 .80902 -12 6.4375 ]
[ 0 1.61803 .125 0 ]
[.5 1.63053 -5 0 ]
[.5 1.63053 5 12.875 ]
[ 1 0 .125 0 ]
[1.0125 .80902 0 -6.4375 ]
[1.0125 .80902 10 6.4375 ]
[.5 1.63053 -130.781 12.875 ]
[.5 1.63053 130.781 35.4375 ]
[ 0 0 0 0 ]
[ 1 1.61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.07443 0 m
.07443 .00625 L
s
[(-10)] .07443 -0.0125 0 1 Mshowa
.22329 0 m
.22329 .00625 L
s
[(-8)] .22329 -0.0125 0 1 Mshowa
.37215 0 m
.37215 .00625 L
s
[(-6)] .37215 -0.0125 0 1 Mshowa
.52101 0 m
.52101 .00625 L
s
[(-4)] .52101 -0.0125 0 1 Mshowa
.66988 0 m
.66988 .00625 L
s
[(-2)] .66988 -0.0125 0 1 Mshowa
.81874 0 m
.81874 .00625 L
s
[(0)] .81874 -0.0125 0 1 Mshowa
.9676 0 m
.9676 .00625 L
s
[(2)] .9676 -0.0125 0 1 Mshowa
.125 Mabswid
.11165 0 m
.11165 .00375 L
s
.14886 0 m
.14886 .00375 L
s
.18608 0 m
.18608 .00375 L
s
.26051 0 m
.26051 .00375 L
s
.29772 0 m
.29772 .00375 L
s
.33494 0 m
.33494 .00375 L
s
.40937 0 m
.40937 .00375 L
s
.44658 0 m
.44658 .00375 L
s
.4838 0 m
.4838 .00375 L
s
.55823 0 m
.55823 .00375 L
s
.59545 0 m
.59545 .00375 L
s
.63266 0 m
.63266 .00375 L
s
.70709 0 m
.70709 .00375 L
s
.74431 0 m
.74431 .00375 L
s
.78152 0 m
.78152 .00375 L
s
.85595 0 m
.85595 .00375 L
s
.89317 0 m
.89317 .00375 L
s
.93038 0 m
.93038 .00375 L
s
.03722 0 m
.03722 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -78 -25.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Re) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
75.000000 13.000000 moveto
(@) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
87.000000 13.000000 moveto
(D) show
93.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
0 .10255 m
.00625 .10255 L
s
[(-3)] -0.0125 .10255 1 0 Mshowa
0 .33804 m
.00625 .33804 L
s
[(-2)] -0.0125 .33804 1 0 Mshowa
0 .57353 m
.00625 .57353 L
s
[(-1)] -0.0125 .57353 1 0 Mshowa
0 .80902 m
.00625 .80902 L
s
[(0)] -0.0125 .80902 1 0 Mshowa
0 1.04451 m
.00625 1.04451 L
s
[(1)] -0.0125 1.04451 1 0 Mshowa
0 1.28 m
.00625 1.28 L
s
[(2)] -0.0125 1.28 1 0 Mshowa
0 1.51549 m
.00625 1.51549 L
s
[(3)] -0.0125 1.51549 1 0 Mshowa
.125 Mabswid
0 .14965 m
.00375 .14965 L
s
0 .19674 m
.00375 .19674 L
s
0 .24384 m
.00375 .24384 L
s
0 .29094 m
.00375 .29094 L
s
0 .38514 m
.00375 .38514 L
s
0 .43223 m
.00375 .43223 L
s
0 .47933 m
.00375 .47933 L
s
0 .52643 m
.00375 .52643 L
s
0 .62063 m
.00375 .62063 L
s
0 .66772 m
.00375 .66772 L
s
0 .71482 m
.00375 .71482 L
s
0 .76192 m
.00375 .76192 L
s
0 .85611 m
.00375 .85611 L
s
0 .90321 m
.00375 .90321 L
s
0 .95031 m
.00375 .95031 L
s
0 .99741 m
.00375 .99741 L
s
0 1.0916 m
.00375 1.0916 L
s
0 1.1387 m
.00375 1.1387 L
s
0 1.1858 m
.00375 1.1858 L
s
0 1.2329 m
.00375 1.2329 L
s
0 1.32709 m
.00375 1.32709 L
s
0 1.37419 m
.00375 1.37419 L
s
0 1.42129 m
.00375 1.42129 L
s
0 1.46839 m
.00375 1.46839 L
s
0 .05545 m
.00375 .05545 L
s
0 .00835 m
.00375 .00835 L
s
0 1.56258 m
.00375 1.56258 L
s
0 1.60968 m
.00375 1.60968 L
s
.25 Mabswid
0 0 m
0 1.61803 L
s
gsave
-0.01875 .80902 -107.25 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Im) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
75.250000 13.000000 moveto
(@) show
81.250000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
87.250000 13.000000 moveto
(D) show
93.250000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math2Mono
%%+ font Courier
grestore
.07443 1.61178 m
.07443 1.61803 L
s
.22329 1.61178 m
.22329 1.61803 L
s
.37215 1.61178 m
.37215 1.61803 L
s
.52101 1.61178 m
.52101 1.61803 L
s
.66988 1.61178 m
.66988 1.61803 L
s
.81874 1.61178 m
.81874 1.61803 L
s
.9676 1.61178 m
.9676 1.61803 L
s
.125 Mabswid
.11165 1.61428 m
.11165 1.61803 L
s
.14886 1.61428 m
.14886 1.61803 L
s
.18608 1.61428 m
.18608 1.61803 L
s
.26051 1.61428 m
.26051 1.61803 L
s
.29772 1.61428 m
.29772 1.61803 L
s
.33494 1.61428 m
.33494 1.61803 L
s
.40937 1.61428 m
.40937 1.61803 L
s
.44658 1.61428 m
.44658 1.61803 L
s
.4838 1.61428 m
.4838 1.61803 L
s
.55823 1.61428 m
.55823 1.61803 L
s
.59545 1.61428 m
.59545 1.61803 L
s
.63266 1.61428 m
.63266 1.61803 L
s
.70709 1.61428 m
.70709 1.61803 L
s
.74431 1.61428 m
.74431 1.61803 L
s
.78152 1.61428 m
.78152 1.61803 L
s
.85595 1.61428 m
.85595 1.61803 L
s
.89317 1.61428 m
.89317 1.61803 L
s
.93038 1.61428 m
.93038 1.61803 L
s
.03722 1.61428 m
.03722 1.61803 L
s
.25 Mabswid
0 1.61803 m
1 1.61803 L
s
gsave
.5 1.63053 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
69.000000 13.000000 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.99375 .10255 m
1 .10255 L
s
.99375 .33804 m
1 .33804 L
s
.99375 .57353 m
1 .57353 L
s
.99375 .80902 m
1 .80902 L
s
.99375 1.04451 m
1 1.04451 L
s
.99375 1.28 m
1 1.28 L
s
.99375 1.51549 m
1 1.51549 L
s
.125 Mabswid
.99625 .14965 m
1 .14965 L
s
.99625 .19674 m
1 .19674 L
s
.99625 .24384 m
1 .24384 L
s
.99625 .29094 m
1 .29094 L
s
.99625 .38514 m
1 .38514 L
s
.99625 .43223 m
1 .43223 L
s
.99625 .47933 m
1 .47933 L
s
.99625 .52643 m
1 .52643 L
s
.99625 .62063 m
1 .62063 L
s
.99625 .66772 m
1 .66772 L
s
.99625 .71482 m
1 .71482 L
s
.99625 .76192 m
1 .76192 L
s
.99625 .85611 m
1 .85611 L
s
.99625 .90321 m
1 .90321 L
s
.99625 .95031 m
1 .95031 L
s
.99625 .99741 m
1 .99741 L
s
.99625 1.0916 m
1 1.0916 L
s
.99625 1.1387 m
1 1.1387 L
s
.99625 1.1858 m
1 1.1858 L
s
.99625 1.2329 m
1 1.2329 L
s
.99625 1.32709 m
1 1.32709 L
s
.99625 1.37419 m
1 1.37419 L
s
.99625 1.42129 m
1 1.42129 L
s
.99625 1.46839 m
1 1.46839 L
s
.99625 .05545 m
1 .05545 L
s
.99625 .00835 m
1 .00835 L
s
.99625 1.56258 m
1 1.56258 L
s
.99625 1.60968 m
1 1.60968 L
s
.25 Mabswid
1 0 m
1 1.61803 L
s
gsave
1.0125 .80902 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
69.000000 13.000000 moveto
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.5 1.63053 -191.781 8.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 30.5625 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 26.562500 moveto
 460.000000 26.562500 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 26.562500 lineto
closepath
clip newpath
63.000000 17.312500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 17.312500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(G) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
69.000000 17.312500 moveto
(@) show
75.000000 17.312500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
81.000000 17.312500 moveto
(D) show
87.000000 17.312500 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(=) show
93.000000 17.312500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
169.000000 11.250000 moveto
(H) show
175.000000 11.250000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
183.375000 11.250000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
191.750000 11.250000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
197.750000 11.250000 moveto
(L) show
206.375000 11.250000 moveto
(H) show
212.375000 11.250000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
220.750000 11.250000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
229.125000 11.250000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
241.125000 11.250000 moveto
(L) show
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
97.375000 17.312500 moveto
(\\200) show
99.250000 17.312500 moveto
(\\200) show
101.125000 17.312500 moveto
(\\200) show
103.000000 17.312500 moveto
(\\200) show
104.875000 17.312500 moveto
(\\200) show
106.750000 17.312500 moveto
(\\200) show
108.625000 17.312500 moveto
(\\200) show
110.500000 17.312500 moveto
(\\200) show
112.375000 17.312500 moveto
(\\200) show
114.250000 17.312500 moveto
(\\200) show
116.125000 17.312500 moveto
(\\200) show
118.000000 17.312500 moveto
(\\200) show
119.875000 17.312500 moveto
(\\200) show
121.750000 17.312500 moveto
(\\200) show
123.625000 17.312500 moveto
(\\200) show
125.500000 17.312500 moveto
(\\200) show
127.375000 17.312500 moveto
(\\200) show
129.250000 17.312500 moveto
(\\200) show
131.125000 17.312500 moveto
(\\200) show
133.000000 17.312500 moveto
(\\200) show
134.875000 17.312500 moveto
(\\200) show
136.750000 17.312500 moveto
(\\200) show
138.625000 17.312500 moveto
(\\200) show
140.500000 17.312500 moveto
(\\200) show
142.375000 17.312500 moveto
(\\200) show
144.250000 17.312500 moveto
(\\200) show
146.125000 17.312500 moveto
(\\200) show
148.000000 17.312500 moveto
(\\200) show
149.875000 17.312500 moveto
(\\200) show
151.750000 17.312500 moveto
(\\200) show
153.625000 17.312500 moveto
(\\200) show
155.500000 17.312500 moveto
(\\200) show
157.375000 17.312500 moveto
(\\200) show
159.250000 17.312500 moveto
(\\200) show
161.125000 17.312500 moveto
(\\200) show
163.000000 17.312500 moveto
(\\200) show
164.875000 17.312500 moveto
(\\200) show
166.750000 17.312500 moveto
(\\200) show
168.625000 17.312500 moveto
(\\200) show
170.500000 17.312500 moveto
(\\200) show
172.375000 17.312500 moveto
(\\200) show
174.250000 17.312500 moveto
(\\200) show
176.125000 17.312500 moveto
(\\200) show
178.000000 17.312500 moveto
(\\200) show
179.875000 17.312500 moveto
(\\200) show
181.750000 17.312500 moveto
(\\200) show
183.625000 17.312500 moveto
(\\200) show
185.500000 17.312500 moveto
(\\200) show
187.375000 17.312500 moveto
(\\200) show
189.250000 17.312500 moveto
(\\200) show
191.125000 17.312500 moveto
(\\200) show
193.000000 17.312500 moveto
(\\200) show
194.875000 17.312500 moveto
(\\200) show
196.750000 17.312500 moveto
(\\200) show
198.625000 17.312500 moveto
(\\200) show
200.500000 17.312500 moveto
(\\200) show
202.375000 17.312500 moveto
(\\200) show
204.250000 17.312500 moveto
(\\200) show
206.125000 17.312500 moveto
(\\200) show
208.000000 17.312500 moveto
(\\200) show
209.875000 17.312500 moveto
(\\200) show
211.750000 17.312500 moveto
(\\200) show
213.625000 17.312500 moveto
(\\200) show
215.500000 17.312500 moveto
(\\200) show
217.375000 17.312500 moveto
(\\200) show
219.250000 17.312500 moveto
(\\200) show
221.125000 17.312500 moveto
(\\200) show
223.000000 17.312500 moveto
(\\200) show
224.875000 17.312500 moveto
(\\200) show
226.750000 17.312500 moveto
(\\200) show
228.625000 17.312500 moveto
(\\200) show
230.500000 17.312500 moveto
(\\200) show
232.375000 17.312500 moveto
(\\200) show
234.250000 17.312500 moveto
(\\200) show
236.125000 17.312500 moveto
(\\200) show
238.000000 17.312500 moveto
(\\200) show
239.875000 17.312500 moveto
(\\200) show
241.750000 17.312500 moveto
(\\200) show
243.625000 17.312500 moveto
(\\200) show
245.500000 17.312500 moveto
(\\200) show
247.375000 17.312500 moveto
(\\200) show
249.250000 17.312500 moveto
(\\200) show
251.125000 17.312500 moveto
(\\200) show
253.000000 17.312500 moveto
(\\200) show
254.875000 17.312500 moveto
(\\200) show
256.750000 17.312500 moveto
(\\200) show
258.625000 17.312500 moveto
(\\200) show
260.500000 17.312500 moveto
(\\200) show
262.375000 17.312500 moveto
(\\200) show
264.250000 17.312500 moveto
(\\200) show
266.125000 17.312500 moveto
(\\200) show
268.000000 17.312500 moveto
(\\200) show
269.875000 17.312500 moveto
(\\200) show
271.750000 17.312500 moveto
(\\200) show
273.625000 17.312500 moveto
(\\200) show
275.500000 17.312500 moveto
(\\200) show
277.375000 17.312500 moveto
(\\200) show
279.250000 17.312500 moveto
(\\200) show
281.125000 17.312500 moveto
(\\200) show
283.000000 17.312500 moveto
(\\200) show
284.875000 17.312500 moveto
(\\200) show
286.750000 17.312500 moveto
(\\200) show
288.625000 17.312500 moveto
(\\200) show
290.500000 17.312500 moveto
(\\200) show
292.375000 17.312500 moveto
(\\200) show
294.250000 17.312500 moveto
(\\200) show
296.125000 17.312500 moveto
(\\200) show
298.000000 17.312500 moveto
(\\200) show
299.875000 17.312500 moveto
(\\200) show
301.750000 17.312500 moveto
(\\200) show
303.625000 17.312500 moveto
(\\200) show
305.500000 17.312500 moveto
(\\200) show
307.375000 17.312500 moveto
(\\200) show
309.250000 17.312500 moveto
(\\200) show
311.125000 17.312500 moveto
(\\200) show
313.000000 17.312500 moveto
(\\200) show
314.875000 17.312500 moveto
(\\200) show
316.750000 17.312500 moveto
(\\200) show
316.937500 17.312500 moveto
(\\200) show
98.687500 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
107.312500 23.625000 moveto
(H) show
113.312500 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
121.687500 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
130.062500 23.625000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
136.062500 23.625000 moveto
(L) show
144.687500 23.625000 moveto
(H) show
150.687500 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
159.062500 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
167.437500 23.625000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
173.437500 23.625000 moveto
(L) show
182.062500 23.625000 moveto
(H) show
188.062500 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
194.062500 21.062500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
201.000000 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
209.375000 23.625000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0.2) show
230.000000 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
238.375000 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
246.750000 23.625000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
252.750000 23.625000 moveto
(L) show
261.375000 23.625000 moveto
(H) show
267.375000 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
273.375000 21.062500 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 7.125000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
280.312500 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
288.687500 23.625000 moveto
%%IncludeResource: font Courier-Italic
%%IncludeFont: Courier-Italic
/Courier-Italic findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(s) show
297.062500 23.625000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
305.437500 23.625000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
311.437500 23.625000 moveto
(L) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier-Italic
%%+ font Math1Mono
%%+ font Math2Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier-Italic
%%+ Math1Mono
%%+ Math2Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier-Italic
%%+ font Math1Mono
%%+ font Math2Mono
%%+ font Courier
grestore
0 0 m
1 0 L
1 1.61803 L
0 1.61803 L
closepath
clip
newpath
.75 g
.5 Mabswid
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
1 .96268 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
1 1.14012 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
1 1.38251 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
.96637 1.61803 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
.88725 1.61803 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
.81874 1.61803 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
.75022 1.61803 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
.67111 1.61803 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
.56303 1.61803 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
.37584 1.61803 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
0 1.50311 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
0 .80902 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
0 .11493 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
.37584 0 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
.56303 0 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
.67111 0 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
.75022 0 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
.81874 0 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
.88725 0 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
.96637 0 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
1 .23552 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
1 .47791 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
1 .65535 L
s
.81874 .80902 m
0 0 rlineto s
.81874 .80902 m
1 .80902 L
s
.9676 .80902 m
.96642 .86805 L
.96292 .92614 L
.95715 .9824 L
.94919 1.03591 L
.93917 1.08585 L
.92725 1.13142 L
.91363 1.17191 L
.8985 1.20668 L
.88212 1.23517 L
.86474 1.25694 L
.84663 1.27165 L
.82808 1.27907 L
.80939 1.27907 L
.79084 1.27165 L
.77274 1.25694 L
.75536 1.23517 L
.73897 1.20668 L
.72385 1.17191 L
.71022 1.13142 L
.69831 1.08585 L
.68829 1.03591 L
.68033 .9824 L
.67455 .92614 L
.67105 .86805 L
.66988 .80902 L
.67105 .74999 L
.67455 .69189 L
.68033 .63564 L
.68829 .58212 L
.69831 .53218 L
.71022 .48661 L
.72385 .44612 L
.73897 .41136 L
.75536 .38286 L
.77274 .36109 L
.79084 .34638 L
.80939 .33897 L
.82808 .33897 L
.84663 .34638 L
.86474 .36109 L
.88212 .38286 L
.8985 .41136 L
.91363 .44612 L
.92725 .48661 L
.93917 .53218 L
.94919 .58212 L
.95715 .63564 L
.96292 .69189 L
.96642 .74999 L
Mistroke
.9676 .80902 L
Mfstroke
1 1.55438 m
.97827 1.60434 L
s
.97827 1.60434 m
.97039 1.61803 L
s
.66708 1.61803 m
.65921 1.60434 L
.62896 1.53481 L
.60171 1.45383 L
.57787 1.36269 L
.55784 1.26281 L
.54192 1.15577 L
.53037 1.04327 L
.52336 .92708 L
.52101 .80902 L
.52336 .69096 L
.53037 .57476 L
.54192 .46226 L
.55784 .35523 L
.57787 .25535 L
.60171 .1642 L
.62896 .08323 L
.65921 .0137 L
s
.65921 .0137 m
.66708 0 L
s
.97039 0 m
.97827 .0137 L
s
.97827 .0137 m
1 .06366 L
s
.45313 1.61803 m
.42739 1.4897 L
.40351 1.32915 L
.38618 1.1604 L
.37567 .98611 L
.37215 .80902 L
.37567 .63193 L
.38618 .45763 L
.40351 .28888 L
.42739 .12833 L
s
.42739 .12833 m
.45313 0 L
s
.28228 1.61803 m
.26511 1.50253 L
.242 1.27753 L
.22799 1.04513 L
.22329 .80902 L
.22799 .5729 L
.242 .34051 L
.26511 .1155 L
s
.26511 .1155 m
.28228 0 L
s
.12075 1.61803 m
.09781 1.39466 L
.0803 1.10416 L
.07443 .80902 L
.0803 .51387 L
.09781 .22338 L
s
.09781 .22338 m
.12075 0 L
s
.75 0 0 r
.012 w
.44613 .80902 Mdot
.63309 .80902 Mdot
.70771 .41212 Mdot
.70771 1.20591 Mdot
.85031 .32551 Mdot
.85031 1.29253 Mdot
.92557 .80902 Mdot
.75 0 .098 r
.44623 .80902 Mdot
.63705 .80902 Mdot
.71196 .42688 Mdot
.71196 1.19116 Mdot
.84755 .34061 Mdot
.84755 1.27743 Mdot
.91852 .80902 Mdot
.75 0 .195 r
.44631 .80902 Mdot
.64108 .80902 Mdot
.71647 .44226 Mdot
.71647 1.17578 Mdot
.84467 .35595 Mdot
.84467 1.26208 Mdot
.91115 .80902 Mdot
.75 0 .292 r
.44637 .80902 Mdot
.64515 .80902 Mdot
.72129 .45832 Mdot
.72129 1.15972 Mdot
.84165 .37151 Mdot
.84165 1.24652 Mdot
.90341 .80902 Mdot
.75 0 .39 r
.44643 .80902 Mdot
.64922 .80902 Mdot
.72649 .47511 Mdot
.72649 1.14293 Mdot
.83848 .38724 Mdot
.83848 1.23079 Mdot
.89523 .80902 Mdot
.75 0 .488 r
.44647 .80902 Mdot
.65323 .80902 Mdot
.73214 .49266 Mdot
.73214 1.12537 Mdot
.83514 .40303 Mdot
.83514 1.215 Mdot
.88656 .80902 Mdot
.75 0 .585 r
.44651 .80902 Mdot
.65709 .80902 Mdot
.73837 .51096 Mdot
.73837 1.10707 Mdot
.83159 .41871 Mdot
.83159 1.19932 Mdot
.87732 .80902 Mdot
.75 0 .683 r
.44654 .80902 Mdot
.66067 .80902 Mdot
.74527 .5299 Mdot
.74527 1.08814 Mdot
.82784 .43395 Mdot
.82784 1.18408 Mdot
.86741 .80902 Mdot
.72 0 .75 r
.44656 .80902 Mdot
.66381 .80902 Mdot
.75293 .54914 Mdot
.75293 1.0689 Mdot
.82389 .4482 Mdot
.82389 1.16984 Mdot
.85682 .80902 Mdot
.623 0 .75 r
.44657 .80902 Mdot
.66637 .80902 Mdot
.76127 .56796 Mdot
.76127 1.05008 Mdot
.81984 .4605 Mdot
.81984 1.15753 Mdot
.84567 .80902 Mdot
.525 0 .75 r
.44658 .80902 Mdot
.6682 .80902 Mdot
.7697 .58487 Mdot
.7697 1.03317 Mdot
.81603 .46957 Mdot
.81603 1.14846 Mdot
.83458 .80902 Mdot
.427 0 .75 r
.44658 .80902 Mdot
.66929 .80902 Mdot
.77671 .59739 Mdot
.77671 1.02064 Mdot
.81312 .4746 Mdot
.81312 1.14343 Mdot
.82529 .80902 Mdot
.33 0 .75 r
.44658 .80902 Mdot
.66977 .80902 Mdot
.78059 .60365 Mdot
.78059 1.01438 Mdot
.81164 .47646 Mdot
.81164 1.14157 Mdot
.82002 .80902 Mdot
.232 0 .75 r
.44658 .80902 Mdot
.66987 .80902 Mdot
.78151 .60506 Mdot
.78151 1.01297 Mdot
.8113 .47681 Mdot
.8113 1.14122 Mdot
.81875 .80902 Mdot
.135 0 .75 r
.44658 .80902 Mdot
.6699 .80902 Mdot
.7817 .60534 Mdot
.7817 1.01269 Mdot
.81123 .47688 Mdot
.81123 1.14115 Mdot
.8185 .80902 Mdot
.038 0 .75 r
.44658 .80902 Mdot
.67014 .80902 Mdot
.78401 .60868 Mdot
.78401 1.00935 Mdot
.81041 .47761 Mdot
.81041 1.14043 Mdot
.81527 .80902 Mdot
0 .06 .75 r
.44659 .80902 Mdot
.67093 .80902 Mdot
.79321 .61895 Mdot
.79321 .99908 Mdot
.80185 .80902 Mdot
.80752 .47881 Mdot
.80752 1.13922 Mdot
0 .158 .75 r
.44659 .80902 Mdot
.67274 .80902 Mdot
.76957 .80902 Mdot
.8015 .47355 Mdot
.8015 1.14448 Mdot
.81447 .6193 Mdot
.81447 .99873 Mdot
0 .255 .75 r
.4466 .80902 Mdot
.6765 .80902 Mdot
.74104 .80902 Mdot
.79576 .45633 Mdot
.79576 1.1617 Mdot
.83258 .60697 Mdot
.83258 1.01106 Mdot
0 .352 .75 r
.44662 .80902 Mdot
.6865 .80902 Mdot
.71254 .80902 Mdot
.79181 .43558 Mdot
.79181 1.18245 Mdot
.84577 .59555 Mdot
.84577 1.02249 Mdot
0 .45 .75 r
.44664 .80902 Mdot
.69174 .7372 Mdot
.69174 .88084 Mdot
.78891 .41468 Mdot
.78891 1.20335 Mdot
.85644 .58469 Mdot
.85644 1.03334 Mdot
0 .548 .75 r
.44667 .80902 Mdot
.68483 .70429 Mdot
.68483 .91375 Mdot
.78661 .39426 Mdot
.78661 1.22377 Mdot
.86564 .57418 Mdot
.86564 1.04386 Mdot
0 .645 .75 r
.44671 .80902 Mdot
.67851 .68213 Mdot
.67851 .93591 Mdot
.78468 .37445 Mdot
.78468 1.24358 Mdot
.87387 .56393 Mdot
.87387 1.0541 Mdot
0 .742 .75 r
.44676 .80902 Mdot
.67263 .66497 Mdot
.67263 .95306 Mdot
.78302 .35526 Mdot
.78302 1.26277 Mdot
.88139 .55393 Mdot
.88139 1.0641 Mdot
0 .75 .66 r
.44682 .80902 Mdot
.66709 .65082 Mdot
.66709 .96722 Mdot
.78155 .33666 Mdot
.78155 1.28137 Mdot
.88836 .54416 Mdot
.88836 1.07387 Mdot
0 .75 .563 r
.4469 .80902 Mdot
.66184 .63869 Mdot
.66184 .97934 Mdot
.78022 .31862 Mdot
.78022 1.29942 Mdot
.89491 .53461 Mdot
.89491 1.08342 Mdot
0 .75 .465 r
.44698 .80902 Mdot
.65683 .62804 Mdot
.65683 .98999 Mdot
.779 .30109 Mdot
.779 1.31694 Mdot
.9011 .52527 Mdot
.9011 1.09276 Mdot
0 .75 .367 r
.44709 .80902 Mdot
.65202 .61853 Mdot
.65202 .9995 Mdot
.77787 .28405 Mdot
.77787 1.33399 Mdot
.90699 .51613 Mdot
.90699 1.10191 Mdot
0 .75 .27 r
.44721 .80902 Mdot
.64739 .60993 Mdot
.64739 1.00811 Mdot
.77681 .26745 Mdot
.77681 1.35058 Mdot
.91262 .50717 Mdot
.91262 1.11086 Mdot
0 .75 .172 r
.44734 .80902 Mdot
.64291 .60206 Mdot
.64291 1.01597 Mdot
.77581 .25128 Mdot
.77581 1.36676 Mdot
.91802 .49839 Mdot
.91802 1.11964 Mdot
0 .75 .075 r
.4475 .80902 Mdot
.63857 .59482 Mdot
.63857 1.02321 Mdot
.77486 .23549 Mdot
.77486 1.38254 Mdot
.92323 .48978 Mdot
.92323 1.12826 Mdot
0 1 0 r
.0125 w
.07443 .80902 Mdot
.52101 .80902 Mdot
1 0 0 r
.44658 .80902 Mdot
.66988 .80902 Mdot
.78152 .60508 Mdot
.78152 1.01296 Mdot
.81129 .47682 Mdot
.81129 1.14122 Mdot
.81874 .80902 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.909028 0.369391 0.97619 0.705202 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.00980392 0.490196 0.00332889 0.166445 [
[ 0 0 0 0 ]
[ 1 5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 5 L
0 5 L
closepath
clip
newpath
.75 0 0 r
.0098 .00333 m
.0098 .16977 L
.5 .16977 L
.5 .00333 L
F
0 g
gsave
.52451 .08655 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(-) show
69.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
.75 0 .101 r
.0098 .16977 m
.0098 .33622 L
.5 .33622 L
.5 .16977 L
F
.75 0 .202 r
.0098 .33622 m
.0098 .50266 L
.5 .50266 L
.5 .33622 L
F
.75 0 .303 r
.0098 .50266 m
.0098 .66911 L
.5 .66911 L
.5 .50266 L
F
.75 0 .403 r
.0098 .66911 m
.0098 .83555 L
.5 .83555 L
.5 .66911 L
F
.75 0 .504 r
.0098 .83555 m
.0098 1.002 L
.5 1.002 L
.5 .83555 L
F
.75 0 .605 r
.0098 1.002 m
.0098 1.16844 L
.5 1.16844 L
.5 1.002 L
F
.75 0 .706 r
.0098 1.16844 m
.0098 1.33489 L
.5 1.33489 L
.5 1.16844 L
F
.693 0 .75 r
.0098 1.33489 m
.0098 1.50133 L
.5 1.50133 L
.5 1.33489 L
F
.592 0 .75 r
.0098 1.50133 m
.0098 1.66778 L
.5 1.66778 L
.5 1.50133 L
F
.491 0 .75 r
.0098 1.66778 m
.0098 1.83422 L
.5 1.83422 L
.5 1.66778 L
F
.391 0 .75 r
.0098 1.83422 m
.0098 2.00067 L
.5 2.00067 L
.5 1.83422 L
F
.29 0 .75 r
.0098 2.00067 m
.0098 2.16711 L
.5 2.16711 L
.5 2.00067 L
F
.189 0 .75 r
.0098 2.16711 m
.0098 2.33356 L
.5 2.33356 L
.5 2.16711 L
F
.088 0 .75 r
.0098 2.33356 m
.0098 2.5 L
.5 2.5 L
.5 2.33356 L
F
0 .013 .75 r
.0098 2.5 m
.0098 2.66644 L
.5 2.66644 L
.5 2.5 L
F
0 .114 .75 r
.0098 2.66644 m
.0098 2.83289 L
.5 2.83289 L
.5 2.66644 L
F
0 .215 .75 r
.0098 2.83289 m
.0098 2.99933 L
.5 2.99933 L
.5 2.83289 L
F
0 .316 .75 r
.0098 2.99933 m
.0098 3.16578 L
.5 3.16578 L
.5 2.99933 L
F
0 .416 .75 r
.0098 3.16578 m
.0098 3.33222 L
.5 3.33222 L
.5 3.16578 L
F
0 .517 .75 r
.0098 3.33222 m
.0098 3.49867 L
.5 3.49867 L
.5 3.33222 L
F
0 .618 .75 r
.0098 3.49867 m
.0098 3.66511 L
.5 3.66511 L
.5 3.49867 L
F
0 .719 .75 r
.0098 3.66511 m
.0098 3.83156 L
.5 3.83156 L
.5 3.66511 L
F
0 .75 .68 r
.0098 3.83156 m
.0098 3.998 L
.5 3.998 L
.5 3.83156 L
F
0 .75 .579 r
.0098 3.998 m
.0098 4.16445 L
.5 4.16445 L
.5 3.998 L
F
0 .75 .478 r
.0098 4.16445 m
.0098 4.33089 L
.5 4.33089 L
.5 4.16445 L
F
0 .75 .378 r
.0098 4.33089 m
.0098 4.49734 L
.5 4.49734 L
.5 4.33089 L
F
0 .75 .277 r
.0098 4.49734 m
.0098 4.66378 L
.5 4.66378 L
.5 4.49734 L
F
0 .75 .176 r
.0098 4.66378 m
.0098 4.83023 L
.5 4.83023 L
.5 4.66378 L
F
0 .75 .075 r
.0098 4.83023 m
.0098 4.99667 L
.5 4.99667 L
.5 4.83023 L
F
0 g
gsave
.52451 4.91345 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 460.000000 16.875000 lineto
 460.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(20.) show
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 1.4104 L
0 1.4104 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[121]:=",
  ImageSize->{344.188, 485.438},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005H0001iA000`40O003h00OogooFGoo003oOomI
Ool00?mooeUoo`00ogooFGoo003oOomIOol00?mooeUoo`00ogooFGoo003oOomIOol00?mooeUoo`00
ogooFGoo003oOomIOol00?mooeUoo`00ogooFGoo003oOomIOol00?mooeUoo`00ogooFGoo003oOomI
Ool00?mooeUoo`00ogooFGoo003oOomIOol00?mooeUoo`00ogooFGoo003oOomIOol00?mooeUoo`00
ogooFGoo003oOomIOol00?mooeUoo`00ogooFGoo003oOomIOol00?mooeUoo`00ogooFGoo003oOomI
Ool00?mooeUoo`00ogooFGoo003oOomIOol00?mooeUoo`00ogooFGoo003oOomIOol00?mooeUoo`00
ogooFGoo003oOomIOol00?mooeUoo`00ogooFGoo003oOomIOol00?mooeUoo`00ogooFGoo002ROol2
0008Ool2002ZOol00:9oo`03001oogoo00Qoo`03001oogoo0:Qoo`00Tgoo0`0000Aoo`00Oomoo`80
00Ioo`04001oogooOol20005Ool00`00Oomoo`2XOol009Aoo`06001oogoo001oo`0027oo00<007oo
Ool00goo00<007ooOol00Woo00<007ooOol0Z7oo002DOol30002Ool30006Ool00`00Oomoo`02Ool0
0`00Oomoo`03Ool00`00Oomoo`2XOol009Aoo`05001oogoo001oo`030006Ool00`00Oomoo`02Ool2
0004Ool00`00Oomoo`2XOol009Aoo`04001oogoo000:Ool00`00Oomoo`08Ool00`00Oomoo`2XOol0
09=oo`@000]oo`8000Qoo`800:Yoo`00ogooFGoo003oOomIOol00?mooeUoo`00Agoo1@000Woo00<0
07ooOol06Goo00<007ooOol06goo0P007Woo0`006goo0`006goo00<007ooOol06goo0`00Dgoo0019
Ool01`00Oomoogoo001oo`0001Uoo`03001oo`0001aoo`03001oo`0001ioo`03001oogoo01Yoo`03
001oogoo01Yoo`03001oo`0001aoo`03001oogoo05=oo`00@goo0`000goo00L007ooOomoo`00Ool0
000DOol30002Ool00`00Ool0000GOol30002Ool00`00Ool0000GOol30002Ool4000FOol30003Ool0
0`00Oomoo`0IOol00`00Ool0000MOol00`00Oomoo`1BOol004Uoo`07001oogooOol007oo00006Woo
00<007ooOol06goo0P007Goo00<007oo00007Goo00<007ooOol06Goo00<007oo00007Goo00<007oo
Ool0DWoo0019Ool01`00Oomoogoo001oo`0001Uoo`03001oo`0001aoo`03001oogoo01eoo`8001ao
o`03001oo`0001Yoo`03001oo`0001aoo`03001oo`0005=oo`00B7oo0P0017oo00<007ooOol06Goo
00<007ooOol077oo0P007Woo00<007ooOol06goo00<007ooOol06Woo00<007ooOol077oo00<007oo
Ool0DWoo003oOomIOol00?mooeUoo`00ogooFGoo003oOomIOol003YooaT00003G_L0000001h00003
G_L0000001400003G_L0000000d00003G_L0000001@00003G_L0000001<00003G_L0000000h00003
G_L0000000/00003G_L0000000/00003G_L0000000h0009Nm`H004eoo`00>Woo00<007ooOol01Goo
00<007ooOol017oo00<007ooOol01Goo00<007ooG_L01Goo00<007ooOol017oo00<007ooOol01Goo
00<007ooOol01Goo00D007ooOomooekg00=oo`03001oogoo00Aoo`03001oogoo00Eoo`03001ooekg
00Eoo`03001oogoo00Eoo`03001Nmgoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001Nmgoo
00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`9Nm`Moo`03001oogoo00Eoo`03001Nmgoo00Aoo`03
001oogoo00Eoo`03G_Moogoo00Eoo`03001oogoo00=oo`03G_Moo`0000Ioo`03001oogoo00Eoo`9N
m`Eoo`03001oogoo04]oo`00>Woo0P003Goo00<007ooOol01goo00=NmgooOol04Woo00<007ooOol0
2Goo00=NmgooOol047oo00<007ooG_L03Woo00=NmgooOol02goo00<007ooOol01goo00=NmgooOol0
4Goo0Ukg47oo00=NmgooOol02goo00=NmgooOol02goo00=NmgooOol03Woo00=NmgooG_L00goo0P00
CGoo000jOol00`00Oomoo`0FOol00ekgOomoo`0NOol00ekgOomoo`0COol00ekgOomoo`0:Ool00ekg
Oomoo`0FOol00ekgOomoo`0@Ool015kgOomooekg3goo00=NmgooOol02goo00=NmgooOol02goo00=N
mgooOol03Goo00ANmgooOomNm`Aoo`03001oogoo04]oo`00>Woo00<007ooOol05Woo00=NmgooOol0
7Goo00=NmgooOol057oo00=NmgooOol02Woo00=NmgooOol05Woo00=NmgooOol047oo00ANmgooOomN
m`moo`03G_Moogoo00]oo`03G_Moogoo00]oo`03G_Moogoo00eoo`05G_MoogooOomNm`03Ool00`00
Oomoo`1;Ool003Yoo`03001oogoo01Eoo`03G_Moogoo01ioo`03G_Moogoo01Eoo`03G_Moogoo00Uo
o`03G_Moogoo01Moo`03G_Moogoo00ioo`05G_MoogooOomNm`0?Ool00ekgOomoo`0;Ool00ekgOomo
o`0;Ool00ekgOomoo`0=Ool01EkgOomoogooG_L00goo00<007ooOol0Bgoo000jOol00`00Oomoo`0E
Ool00ekgOomoo`0NOol00ekgOomoo`0EOol00ekgOomoo`09Ool00ekgOomoo`0GOol00ekgOomoo`0>
Ool01EkgOomoogooG_L03goo00=NmgooOol02goo00=NmgooOol02goo00=NmgooOol03Goo00=Nmgoo
Ool00Woo00ANmgooOol004eoo`00>Woo00<007ooOol05Goo00=NmgooOol07Woo00=NmgooOol05Woo
00=NmgooOol027oo00=NmgooOol05goo00=NmgooOol03Goo00=NmgooOol00Woo00=NmgooOol03Woo
00=NmgooOol02Woo00=NmgooOol02Woo00=NmgooOol03Woo00=NmgooOol00Woo00ANmgooOol004eo
o`00>Woo00<007ooOol05Goo00=NmgooOol07Woo00=NmgooOol05Woo00=NmgooOol027oo00=Nmgoo
Ool067oo00=NmgooOol037oo00=NmgooOol00Woo00=NmgooOol03Woo00=NmgooOol02Woo00=Nmgoo
Ool02Woo00=NmgooOol03Woo00=NmgooOol00goo00=Nmgoo0000CGoo000jOol00`00Oomoo`0EOol0
0ekgOomoo`0NOol00ekgOomoo`0GOol00ekgOomoo`06Ool00ekgOomoo`0IOol00ekgOomoo`0<Ool0
0ekgOomoo`03Ool00ekgOomoo`0=Ool00ekgOomoo`0:Ool00ekgOomoo`0:Ool00ekgOomoo`0=Ool0
0ekgOomoo`04Ool00ekgOol0001=Ool003Yoo`03001oogoo01Eoo`03G_Moogoo01ioo`03G_Moogoo
01Moo`03G_Moogoo00Ioo`03G_Moogoo01Uoo`03G_Moogoo00]oo`03G_Moogoo00Aoo`03G_Moogoo
00eoo`03G_Moogoo00Yoo`03G_Moogoo00Yoo`03G_Moogoo00eoo`03G_Moogoo00Eoo`03G_L007oo
04aoo`00>Woo00<007ooOol05Goo00=NmgooOol07Woo00=NmgooOol067oo00=NmgooOol01Goo00=N
mgooOol06Goo00=NmgooOol02goo00=NmgooOol017oo00=NmgooOol03Goo00=NmgooOol02Woo00=N
mgooOol02Woo00=NmgooOol03Goo00=NmgooOol01Goo00=Nm`00Ool0C7oo000jOol2000FOol00ekg
Oomoo`0MOol00ekgOomoo`0JOol00ekgOomoo`04Ool00ekgOomoo`0JOol00ekgOomoo`09Ool00ekg
Oomoo`05Ool00ekgOomoo`0=Ool00ekgOomoo`0:Ool00ekgOomoo`0:Ool00ekgOomoo`0=Ool00ekg
Oomoo`05Ool00`00G_Moo`1<Ool003Yoo`03001oogoo01Eoo`03G_Moogoo01eoo`03G_Moogoo01Yo
o`03G_Moogoo00Aoo`03G_Moogoo01Yoo`03G_Moogoo00Uoo`03G_Moogoo00Eoo`03G_Moogoo00eo
o`03G_Moogoo00Yoo`03G_Moogoo00Yoo`03G_Moogoo00eoo`03G_Moogoo00Ioo`03G_Moogoo04]o
o`00>Woo00<007ooOol05Goo00=NmgooOol07Goo00=NmgooOol06goo00=NmgooOol00Woo00=Nmgoo
Ool06goo00=NmgooOol02Goo00=NmgooOol01Woo00=NmgooOol037oo00=NmgooOol02Woo00=Nmgoo
Ool02Woo00=NmgooOol037oo00=NmgooOol01goo00<007ooOol0Bgoo000jOol00`00Oomoo`0DOol0
0ekgOomoo`0NOol00ekgOomoo`0KOol00ekgOomoo`02Ool00ekgOomoo`0LOol00ekgOomoo`07Ool0
0ekgOomoo`07Ool00ekgOomoo`0<Ool00ekgOomoo`0:Ool00ekgOomoo`0:Ool00ekgOomoo`0<Ool0
0ekgOomoo`07Ool00`00Oomoo`1;Ool003Yoo`03001oogoo01Aoo`03G_Moogoo01ioo`03G_Moogoo
01aoo`05G_MoogooOomNm`0NOol00ekgOomoo`07Ool00ekgOomoo`07Ool00ekgOomoo`0<Ool00ekg
Oomoo`0:Ool00ekgOomoo`0:Ool00ekgOomoo`0<Ool00ekgOomoo`07Ool00`00Oomoo`1;Ool003Yo
o`03001oogoo01Aoo`03G_Moogoo01ioo`03G_Moogoo01aoo`05G_MoogooOomNm`0NOol00ekgOomo
o`06Ool00ekgOomoo`08Ool00ekgOomoo`0<Ool00ekgOomoo`0:Ool00ekgOomoo`0:Ool00ekgOomo
o`0<Ool00ekgOomoo`07Ool00`00Oomoo`1;Ool003Yoo`03001oogoo01Aoo`03G_Moogoo01ioo`03
G_Moogoo01eoo`04G_MoogooG_LOOol00ekgOomoo`05Ool00ekgOomoo`08Ool00ekgOomoo`0<Ool0
0ekgOomoo`0:Ool00ekgOomoo`0:Ool00ekgOomoo`0<Ool00ekgOomoo`07Ool00`00Oomoo`1;Ool0
03Yoo`03001oogoo01Aoo`03G_Moogoo01ioo`03G_Moogoo01eoo`03G_Mooekg021oo`03G_Moogoo
00Eoo`03G_Moogoo00Qoo`03G_Moogoo00eoo`03G_Moogoo00Uoo`03G_Moogoo00Uoo`03G_Moogoo
00eoo`03G_Moogoo00Moo`03001oogoo04]oo`00<goo0P001Goo00<007ooOol057oo00=NmgooOol0
7Goo00=NmgooOol07goo0Ukg87oo00=NmgooOol017oo00=NmgooOol02Woo00=NmgooOol037oo00=N
mgooOol02Goo00=NmgooOol02Goo00=NmgooOol037oo00=NmgooOol027oo00<007ooOol0Bgoo000e
Ool00`00Oomoo`02Ool00`00Oomoo`0DOol00ekgOomoo`0MOol00ekgOomoo`0OOol2G_LQOol00ekg
Oomoo`03Ool00ekgOomoo`0:Ool00ekgOomoo`0<Ool00ekgOomoo`09Ool00ekgOomoo`09Ool00ekg
Oomoo`0<Ool00ekgOomoo`08Ool00`00Oomoo`1;Ool002ioo`<000=oo`03001oogoo00=oo`8001Eo
o`03G_Moogoo01eoo`03G_Moogoo021oo`03G_Moogoo01moo`03G_Moogoo009oo`03G_Moogoo00]o
o`03G_Moogoo00aoo`03G_Moogoo00Uoo`03G_Moogoo00Uoo`03G_Moogoo00aoo`03G_Moogoo00Io
o`<004eoo`00=Goo00<007ooOol00Woo00<007ooOol057oo00=NmgooOol07Goo00=NmgooOol087oo
0Ukg87oo00=NmgooOol00Woo00=NmgooOol02goo00=NmgooOol037oo00=NmgooOol02Goo00=Nmgoo
Ool02Goo00=NmgooOol037oo00=NmgooOol027oo00<007ooOol0Bgoo000cOol00`00Ool00004Ool0
0ekgOomoo`0COol00ekgOomoo`0NOol00ekgOomoo`0POol2G_LQOol01EkgOomoogooG_L03Goo00=N
mgooOol037oo00=NmgooOol02Goo00=NmgooOol02Goo00=NmgooOol037oo00=NmgooOol027oo00<0
07ooOol0Bgoo000dOol00`00Oomoo`03Ool00`00G_Moo`0COol00ekgOomoo`0NOol00ekgOomoo`0O
Ool015kgOomooekg87oo00ANmgooOomNm`moo`03G_Moogoo00]oo`03G_Moogoo00Uoo`03G_Moogoo
00Uoo`03G_Moogoo00]oo`03G_Moogoo00Uoo`03001oogoo04]oo`00>Woo00<007ooG_L04goo00=N
mgooOol07Woo00=NmgooOol07goo00ANmgooOomNmb1oo`04G_MoogooG_L?Ool00ekgOomoo`0;Ool0
0ekgOomoo`09Ool00ekgOomoo`09Ool00ekgOomoo`0;Ool00ekgOomoo`09Ool00`00Oomoo`1;Ool0
03Yoo`03001oogoo009Nma5oo`03G_Moogoo01ioo`03G_Moogoo01moo`05G_MoogooOomNm`0OOol0
15kgOomooekg3goo00=NmgooOol02goo00=NmgooOol02Goo00=NmgooOol02Goo00=NmgooOol02goo
00=NmgooOol02Goo00<007ooOol0Bgoo000jOol00`00Oomoo`02Ool00ekgOomoo`0>Ool00ekgOomo
o`0NOol00ekgOomoo`0OOol01EkgOomoogooG_L087oo0Ukg47oo00=NmgooOol02goo00=NmgooOol0
2Goo00=NmgooOol02Goo00=NmgooOol02goo00=NmgooOol02Goo00<007ooOol0Bgoo000jOol00`00
Oomoo`03Ool00ekgOomoo`0=Ool00ekgOomoo`0MOol00ekgOomoo`0POol00ekgOomoo`02Ool00ekg
Oomoo`0MOol2G_L@Ool00ekgOomoo`0;Ool00ekgOomoo`09Ool00ekgOomoo`09Ool00ekgOomoo`0;
Ool00ekgOomoo`09Ool00`00Oomoo`1;Ool003Yoo`03001oogoo00Aoo`03G_Moogoo00aoo`03G_Mo
ogoo01eoo`03G_Moogoo021oo`03G_Moogoo009oo`03G_Moogoo01eoo`03G_Moogoo011oo`03G_Mo
ogoo00Yoo`03G_Moogoo00Uoo`03G_Moogoo00Uoo`03G_Moogoo00Yoo`03G_Moogoo00Yoo`03001o
ogoo04]oo`00>Woo0P001Woo00=NmgooOol02goo00=NmgooOol07Goo00=NmgooOol07goo00=Nmgoo
Ool017oo00=NmgooOol077oo0Ukg4Goo00=NmgooOol02goo00=NmgooOol027oo00=NmgooOol027oo
00=NmgooOol02goo00=NmgooOol02Goo0P00CGoo000jOol00`00Oomoo`06Ool00ekgOomoo`0:Ool0
0ekgOomoo`0MOol00ekgOomoo`0OOol00ekgOomoo`04Ool00ekgOomoo`0LOol2G_LAOol00ekgOomo
o`0;Ool00ekgOomoo`08Ool00ekgOomoo`08Ool00ekgOomoo`0;Ool00ekgOomoo`0:Ool00`00Oomo
o`1;Ool003Yoo`03001oogoo00Moo`9Nm`Uoo`03G_Moogoo01ioo`03G_Moogoo01moo`03G_Moogoo
00Eoo`03G_Moogoo01Yoo`03G_Mooekg015oo`03G_Moogoo00]oo`03G_Moogoo00Qoo`03G_Moogoo
00Qoo`03G_Moogoo00]oo`03G_Moogoo00Yoo`03001oogoo04]oo`00>Woo00<007ooOol02Goo00=N
mgooOol01Woo00=NmgooOol07Woo00=NmgooOol07goo00=NmgooOol01Woo00=NmgooOol06Goo00AN
mgooOomNma1oo`03G_Moogoo00]oo`03G_Moogoo00Qoo`03G_Moogoo00Qoo`03G_Moogoo00]oo`03
G_Moogoo00Yoo`03001oogoo04]oo`00>Woo00<007ooOol02Woo00=NmgooOol01Goo00=NmgooOol0
7Woo00=NmgooOol07goo00=NmgooOol01Woo00=NmgooOol06Goo00ANmgooOomNma1oo`03G_Moogoo
00]oo`03G_Moogoo00Qoo`03G_Moogoo00Qoo`03G_Moogoo00]oo`03G_Moogoo00Yoo`03001oogoo
04]oo`00>Woo00<007ooOol02goo00=NmgooOol017oo00=NmgooOol07Woo00=NmgooOol07goo00=N
mgooOol01goo00=NmgooOol05goo00ENmgooOomooekg015oo`03G_Moogoo00Yoo`03G_Moogoo00Qo
o`03G_Moogoo00Qoo`03G_Moogoo00Yoo`03G_Moogoo00]oo`03001oogoo04]oo`00>Woo00<007oo
Ool037oo00=NmgooOol00goo00=NmgooOol07Woo00=NmgooOol07Woo00=NmgooOol027oo00=Nmgoo
Ool05goo00=NmgooOol00Woo00=NmgooOol03Woo00=NmgooOol02Woo00=NmgooOol027oo00=Nmgoo
Ool027oo00=NmgooOol02Woo00=NmgooOol02goo00<007ooOol0Bgoo000jOol00`00Oomoo`0=Ool0
0ekgOomoo`02Ool00ekgOomoo`0NOol00ekgOomoo`0NOol00ekgOomoo`09Ool00ekgOomoo`0FOol0
0ekgOomoo`02Ool00ekgOomoo`0>Ool00ekgOomoo`0:Ool00ekgOomoo`08Ool00ekgOomoo`08Ool0
0ekgOomoo`0:Ool00ekgOomoo`0;Ool00`00Oomoo`1;Ool003Yoo`03001oogoo00ioo`9Nm`9oo`03
G_Moogoo01eoo`03G_Moogoo01moo`03G_Moogoo00Uoo`03G_Moogoo01Ioo`03G_Moogoo009oo`03
G_Moogoo00ioo`03G_Moogoo00Yoo`03G_Moogoo00Qoo`03G_Moogoo00Qoo`03G_Moogoo00Yoo`03
G_Moogoo00]oo`03001oogoo04]oo`00>Woo00<007ooOol047oo00=NmgooG_L07goo00=NmgooOol0
7goo00=NmgooOol02Woo00=NmgooOol057oo00=NmgooOol017oo00=NmgooOol03Goo00=NmgooOol0
2Woo00=NmgooOol027oo00=NmgooOol027oo00=NmgooOol02Woo00=NmgooOol02goo00<007ooOol0
Bgoo000jOol2000BOol2G_LOOol00ekgOomoo`0OOol00ekgOomoo`0:Ool00ekgOomoo`0DOol00ekg
Oomoo`04Ool00ekgOomoo`0>Ool00ekgOomoo`09Ool00ekgOomoo`08Ool00ekgOomoo`08Ool00ekg
Oomoo`09Ool00ekgOomoo`0;Ool2001=Ool003Yoo`03001oogoo019oo`03G_Moogoo01eoo`03G_Mo
ogoo01moo`03G_Moogoo00]oo`03G_Moogoo01=oo`03G_Moogoo00Aoo`03G_Moogoo00ioo`03G_Mo
ogoo00Uoo`03G_Moogoo00Qoo`03G_Moogoo00Qoo`03G_Moogoo00Uoo`03G_Moogoo00aoo`03001o
ogoo04]oo`00>Woo00<007ooOol04Goo00=NmgooG_L07Woo00=NmgooOol07goo00=NmgooOol02goo
00=NmgooOol04goo00=NmgooOol017oo00=NmgooOol03Woo00=NmgooOol02Woo00=NmgooOol01goo
00=NmgooOol01goo00=NmgooOol02Woo00=NmgooOol037oo00<007ooOol0Bgoo000jOol00`00Oomo
o`0AOol00ekgOomoo`02G_LLOol00ekgOomoo`0NOol00ekgOomoo`0=Ool00ekgOomoo`0AOol00ekg
Oomoo`06Ool00ekgOomoo`0=Ool00ekgOomoo`0:Ool00ekgOomoo`07Ool00ekgOomoo`07Ool00ekg
Oomoo`0:Ool00ekgOomoo`0<Ool00`00Oomoo`1;Ool003Yoo`03001oogoo015oo`03G_Moogoo009o
o`03G_Moogoo01Uoo`03G_Moogoo01ioo`03G_Moogoo00eoo`03G_Moogoo015oo`03G_Moogoo00Io
o`03G_Moogoo00eoo`03G_Moogoo00Yoo`03G_Moogoo00Moo`03G_Moogoo00Moo`03G_Moogoo00Yo
o`03G_Moogoo00aoo`03001oogoo04]oo`00>Woo00<007ooOol04Goo00=NmgooOol00goo00=Nmgoo
Ool067oo00=NmgooOol07Woo00=NmgooOol03Woo00=NmgooOol047oo00=NmgooOol01Woo00=Nmgoo
Ool03Goo00=NmgooOol02Woo00=NmgooOol01goo00=NmgooOol01goo00=NmgooOol02Woo00=Nmgoo
Ool037oo00<007ooOol0Bgoo000jOol00`00Oomoo`0AOol00ekgOomoo`04Ool00ekgOomoo`0GOol0
0ekgOomoo`0NOol00ekgOomoo`0?Ool00ekgOomoo`0?Ool00ekgOomoo`07Ool00ekgOomoo`0=Ool0
0ekgOomoo`09Ool00ekgOomoo`07Ool00ekgOomoo`07Ool00ekgOomoo`09Ool00ekgOomoo`0=Ool0
0`00Oomoo`1;Ool003Yoo`03001oogoo015oo`03G_Moogoo00Eoo`03G_Moogoo01Eoo`03G_Moogoo
01moo`03G_Moogoo00moo`03G_Moogoo00ioo`03G_Moogoo00Qoo`03G_Moogoo00eoo`03G_Moogoo
00Uoo`03G_Moogoo00Moo`03G_Moogoo00Moo`03G_Moogoo00Uoo`03G_Moogoo00eoo`03001oogoo
04]oo`00>Woo00<007ooOol04Goo00=NmgooOol01Woo00=NmgooOol057oo00=NmgooOol07goo00=N
mgooOol047oo00=NmgooOol03Goo00=NmgooOol027oo00=NmgooOol03Goo00=NmgooOol02Goo0P;Q
27oo00=NmgooOol01goo00=NmgooOol02Goo00=NmgooOol03Goo00=NmgooOol0Bgoo000jOol00`00
Oomoo`0AOol00ekgOomoo`07Ool2G_LDOol00ekgOomoo`0OOol00ekgOomoo`0@Ool00ekgOomoo`0=
Ool00ekgOomoo`09Ool00ekgOomoo`0<Ool00ekgOomoo`09Ool20^48Ool00ekgOomoo`07Ool00ekg
Oomoo`09Ool00ekgOomoo`0=Ool00ekgOomoo`1;Ool003Yoo`80019oo`03G_Moogoo00Uoo`03G_Mo
ogoo015oo`03G_Moogoo01ioo`03G_Moogoo019oo`03G_Moogoo00aoo`03G_Moogoo00Uoo`03G_Mo
ogoo00aoo`03G_Moogoo00Uoo`03G_Moogoo00Moo`03G_Moogoo00Moo`03G_Moogoo00Uoo`03G_Mo
ogoo00aoo`03G_L007oo04aoo`00>Woo00<007ooOol04Goo00=NmgooOol02Woo00=NmgooOol047oo
00=NmgooOol07Woo00=NmgooOol04Woo00=NmgooOol02goo00=NmgooOol02Woo00=NmgooOol03Goo
00=NmgooOol027oo0P;U27oo00=NmgooOol01goo00=NmgooOol027oo00=NmgooOol03Goo00=Nm`00
Ool0C7oo000jOol00`00Oomoo`0AOol00ekgOomoo`0;Ool00ekgOomoo`0?Ool00ekgOomoo`0NOol0
0ekgOomoo`0COol00ekgOomoo`0:Ool00ekgOomoo`0;Ool00ekgOomoo`0<Ool00ekgOomoo`08Ool2
0^D8Ool00ekgOomoo`07Ool00ekgOomoo`08Ool00ekgOomoo`0=Ool00ekg001oo`1<Ool003Yoo`03
001oogoo015oo`03G_Moogoo00aoo`03G_Moogoo00ioo`03G_Moogoo01ioo`03G_Moogoo01=oo`03
G_Moogoo00Yoo`03G_Moogoo00]oo`03G_Moogoo00aoo`03G_Moogoo00Qoo`03G_Moogoo00Moo`03
G_Moogoo00Moo`03G_Moogoo00Qoo`03G_Moogoo00aoo`03G_Moo`0004eoo`00>Woo00<007ooOol0
47oo00=NmgooOol03Woo00=NmgooOol03Goo00=NmgooOol07Woo00=NmgooOol057oo00=NmgooOol0
2Goo00=NmgooOol02goo00=NmgooOol037oo00=NmgooOol02Goo00=NmgooOol01Woo00=NmgooOol0
1Woo00=NmgooOol02Goo00=NmgooOol037oo00=Nmgoo0000CGoo000jOol00`00Oomoo`0@Ool00ekg
Oomoo`0?Ool2G_L=Ool00ekgOomoo`0NOol00ekgOomoo`0DOol00ekgOomoo`08Ool00ekgOomoo`0=
Ool00ekgOomoo`0;Ool00ekgOomoo`09Ool20^P7Ool00ekgOomoo`06Ool00ekgOomoo`09Ool00ekg
Oomoo`0<Ool00ekgOol0001=Ool003Yoo`03001oogoo011oo`03G_Moogoo015oo`03G_Moogoo00Uo
o`03G_Moogoo01ioo`03G_Moogoo01Ioo`03G_Moogoo00Moo`03G_Moogoo00eoo`03G_Moogoo00]o
o`03G_Moogoo00Uoo`82j0Moo`03G_Moogoo00Ioo`03G_Moogoo00Uoo`03G_Moogoo00]oo`04G_Mo
ogoo001=Ool003Yoo`03001oogoo011oo`03G_Moogoo019oo`03G_Moogoo00Qoo`03G_Moogoo01io
o`03G_Moogoo01Moo`03G_Moogoo00Ioo`03G_Moogoo00eoo`03G_Moogoo00aoo`03G_Moogoo00Qo
o`03G_Moogoo00Ioo`03G_Moogoo00Ioo`03G_Moogoo00Qoo`03G_Moogoo00aoo`04G_Moogoo001=
Ool003Yoo`03001oogoo011oo`03G_Moogoo01=oo`03G_Moogoo00Moo`03G_Moogoo01ioo`03G_Mo
ogoo01Moo`03G_Moogoo00Ioo`03G_Moogoo00ioo`03G_Moogoo00]oo`03G_Moogoo00Qoo`82j`Mo
o`03G_Moogoo00Ioo`03G_Moogoo00Qoo`03G_Moogoo00aoo`04G_Moogoo001=Ool003Yoo`03001o
ogoo011oo`03G_Moogoo01Aoo`03G_Moogoo00Ioo`03G_Moogoo01ioo`03G_Moogoo01Qoo`03G_Mo
ogoo00Eoo`03G_Moogoo00ioo`03G_Moogoo00]oo`03G_Moogoo00Qoo`82j`Moo`03G_Moogoo00Io
o`03G_Moogoo00Qoo`03G_Moogoo00aoo`04G_Moogoo0011Ool50002Ool00`00Oomoo`02Ool003Yo
o`80015oo`03G_Moogoo01Eoo`03G_Moogoo00Eoo`03G_Moogoo01ioo`03G_Moogoo01Qoo`03G_Mo
ogoo00Aoo`03G_Moogoo00moo`03G_Moogoo00]oo`03G_Moogoo00Qoo`03G_Moogoo00Ioo`03G_Mo
ogoo00Ioo`03G_Moogoo00Qoo`03G_Moogoo00]oo`03G_Moogoo008002eoo`=L0005F01L05`0G01H
0003G004Ool40003Ool01`00Oomoogoo001oo`0000=oo`00>Woo00<007ooOol047oo00=NmgooOol0
5Woo0Ukg1Goo00=NmgooOol07Woo00=NmgooOol06Goo00=NmgooOol00goo00=NmgooOol03goo00=N
mgooOol02goo00=NmgooOol027oo00=NmgooOol01Woo00=NmgooOol01Woo00=NmgooOol027oo00=N
mgooOol02goo00ENmgooOomoo`0002eoo`]L00]oo`07001oogooOol007oo00000goo000jOol00`00
Oomoo`0@Ool00ekgOomoo`0HOol00ekgOomoo`02Ool00ekgOomoo`0NOol00ekgOomoo`0IOol00ekg
Oomoo`03Ool00ekgOomoo`0@Ool00ekgOomoo`0;Ool00ekgOomoo`07Ool20^h7Ool00ekgOomoo`06
Ool00ekgOomoo`07Ool00ekgOomoo`0<Ool01EkgOomoogoo0000;Goo00=L05P0G0000U`000IH05`0
G01L05P0G00;Ool01`00Oomoogoo001oo`0000=oo`00>Woo00<007ooOol047oo00=NmgooOol06Goo
00ENmgooOomooekg021oo`03G_Moogoo01Yoo`03G_Moogoo009oo`03G_Moogoo011oo`03G_Moogoo
00]oo`03G_Moogoo00Moo`82kPMoo`03G_Moogoo00Ioo`03G_Moogoo00Moo`03G_Moogoo00]oo`03
G_Moogoo009oo`03001oogoo02]oo`]L00]oo`07001oogooOol007oo00000goo000jOol00`00Oomo
o`0@Ool00ekgOomoo`0JOol015kgOomooekg7goo00=NmgooOol06goo00=NmgooOol00Woo00=Nmgoo
Ool047oo00=NmgooOol02goo00=NmgooOol01goo00=NmgooOol01Woo00=NmgooOol01Woo00=Nmgoo
Ool01goo00=NmgooOol02goo00=NmgooOol00Woo00<007ooOol0:goo00EL0e`2G09H0U`3009L0P04
F09L0e`2G08:Ool20004Ool00`00Oomoo`02Ool003Yoo`03001oogoo011oo`03G_Moogoo01]oo`03
G_Mooekg01moo`03G_Moogoo01aoo`05G_MoogooOomNm`0COol00ekgOomoo`0:Ool00ekgOomoo`07
Ool20_47Ool00ekgOomoo`06Ool00ekgOomoo`07Ool00ekgOomoo`0;Ool00ekgOomoo`02Ool00`00
Oomoo`0[Ool;G08EOol003Yoo`03001oogoo011oo`03G_Moogoo01aoo`03G_Moogoo01ioo`03G_Mo
ogoo01aoo`04G_MoogooG_LDOol00ekgOomoo`0:Ool00ekgOomoo`07Ool20_47Ool00ekgOomoo`05
Ool00ekgOomoo`08Ool00ekgOomoo`0:Ool00ekgOomoo`03Ool00`00Oomoo`0[Ool00e`2F09L0`02
G0801UP2G0=L0U`2F09L0aEoo`00>Woo00<007ooOol047oo00=NmgooOol077oo0ekg7Woo00=Nmgoo
Ool07Goo00=NmgooG_L057oo00=NmgooOol02Woo00=NmgooOol027oo00=NmgooOol01Goo00=Nmgoo
Ool00goo0U`000=NmgooOol027oo00=NmgooOol02Woo00=NmgooOol00goo00<007ooOol0:goo2e`2
5Goo000cOol30004Ool00`00Oomoo`0@Ool00ekgOomoo`0LOol015kgOomooekg7Goo00=NmgooOol0
7Woo0Ukg5Goo00=NmgooOol02Woo00=NmgooOol01goo00=NmgooOol01Goo00=NmgooOol00goo0U`0
00=NmgooOol01goo00=NmgooOol02goo00=NmgooOol00goo00<007ooOol0:goo00]L1U`5G0IH1E`6
G0EL1UP5G0IL1E`601Eoo`00<goo00<007ooOol017oo00<007ooOol03goo00=NmgooOol07Goo00EN
mgooOomooekg01aoo`03G_Moogoo01ioo`9NmaEoo`03G_Moogoo00Yoo`03G_Moogoo00Moo`82m0Io
o`03G_Moogoo00Eoo`03G_Moogoo00Moo`03G_Moogoo00Yoo`03G_Moogoo00Aoo`03001oogoo02]o
o`=L1@05G0IL1E`5G0EL1P03G0DEOol002ioo`<000=oo`03001oogoo00=oo`80011oo`03G_Moogoo
01eoo`03G_Moogoo009oo`03G_Moogoo01Uoo`03G_Moogoo01moo`03G_Moogoo01=oo`03G_Moogoo
00Yoo`03G_Moogoo00Moo`82m0=oo`MNm`05OomL0U`2OomNm`09Ool00ekgOomoo`0:Ool00ekgOomo
o`02Ool3000]Ool02e`6F0EL1U`5G0IH1E`6G0EL1UP5G0H05Goo000dOol00`00Oomoo`03Ool00`00
Oomoo`0?Ool00ekgOomoo`0MOol00ekgOomoo`03Ool00ekgOomoo`0HOol00ekgOomoo`0NOol2G_LF
Ool00ekgOomoo`09Ool00ekgOomoo`07Ool00ekgOomNm`02G_L3Ool01EkgOomoogooG_L00U`200=o
oekgOol027oo00=NmgooOol02Woo00=NmgooOol017oo00<007ooOol0:goo00=L1E`6G0D00U`500IL
1U`5G0EL1E`6G0DEOol003=oo`03001oo`0000Aoo`03001oogoo00moo`03G_Moogoo01eoo`03G_Mo
ogoo00Aoo`9NmaQoo`03G_Moogoo01ioo`03G_Mooekg01Eoo`03G_Moogoo00Uoo`03G_Moogoo00Mo
o`9Nm`Ioo`03G_Moogoo00Aoo`9Nm`Uoo`03G_Moogoo00Uoo`03G_Moogoo00Eoo`03001oogoo02]o
o`0;G0UL25`9F0QL2E`8G0UH25`9G0QL2@0EOol003Aoo`03001oogoo00=oo`03001oogoo00moo`03
G_Moogoo01eoo`03G_Moogoo00Ioo`03G_Moogoo01Aoo`03G_Moogoo01moo`03G_Mooekg01Eoo`03
G_Moogoo00Yoo`03G_Moogoo00Ioo`82m`Ioo`03G_Moogoo009oo`9L1@03OomNmekg00Moo`03G_Mo
ogoo00Yoo`03G_Moogoo00Eoo`03001oogoo02]oo`05G0QL2E`9G0UL2003G0T00e`8G0UL2@0EOol0
03Yoo`03001oogoo00moo`03G_Moogoo01eoo`03G_Moogoo00Moo`03G_Moogoo01=oo`03G_Moogoo
01moo`04G_MoogooG_LEOol00ekgOomoo`09Ool00ekgOomoo`05Ool00ekg0_L2m`06Ool00ekgOomo
o`02Ool2G0D017ooG_Mooekg1Woo00=NmgooOol02Woo00=NmgooOol01Goo00<007ooOol0:goo00]L
2EP8G0UL25`9F0QL2E`8G0UH25`901Eoo`00>Woo00<007ooOol03goo00=NmgooOol07Goo00=Nmgoo
Ool027oo00=NmgooOol04Woo00=NmgooOol07goo00ANmgooOomNmaEoo`03G_Moogoo00Uoo`03G_Mo
ogoo00Aoo`03G_Mooekg00Moo`03G_Moogoo00Eoo`04G_MoogooG_L5Ool00ekgOomoo`09Ool00ekg
Oomoo`06Ool00`00Oomoo`0[Ool;G0`EOol003Yoo`03001oogoo00moo`03G_Moogoo01eoo`03G_Mo
ogoo00Uoo`03G_Moogoo015oo`03G_Moogoo01moo`05G_MoogooOomNm`0DOol00ekgOomoo`09Ool0
0ekgOomoo`03Ool015kgOomooekg1goo00ANmgooOomoo`9L209oo`04G_MoogooG_L5Ool00ekgOomo
o`09Ool00ekgOomoo`06Ool00`00Oomoo`0[Ool3G0`01EP;G0aL35`<F0/00e`<5Goo000jOol00`00
Oomoo`0?Ool00ekgOomoo`0MOol00ekgOomoo`0:Ool00ekgOomoo`0@Ool00ekgOomoo`0NOol00ekg
Oomoo`02Ool00ekgOomoo`0BOol00ekgOomoo`09Ool00ekgOomoo`03Ool00ekgOomoo`020YL6Ool0
15kgOomoogoo0U`80Woo00ENmgooOomooekg00Aoo`03G_Moogoo00Uoo`03G_Moogoo00Ioo`03001o
ogoo02]oo`]L31Eoo`00>Woo00<007ooOol03goo00=NmgooOol077oo00=NmgooOol037oo0Ukg47oo
00=NmgooOol07Woo00=NmgooOol00goo00=NmgooOol04Woo00=NmgooOol027oo00=NmgooOol00Woo
00ANmgooOomoo`82U`Ioo`03G_Moogoo00Aoo`03G_Moogoo009oo`03G_Moogoo009oo`03G_Moogoo
00Qoo`03G_Moogoo00Moo`03001oogoo02]oo`03G0aH2e`<009L3006F0]L35`<G0aH2e`<5Goo000j
Ool2000@Ool00ekgOomoo`0LOol00ekgOomoo`0>Ool00ekgOomoo`0=Ool00ekgOomoo`0NOol00ekg
Oomoo`04Ool00ekgOomoo`0AOol00ekgOomoo`09Ool015kgOomooekg1Goo00=NmgooOol017oo00AN
mgooOomoo`9L2`03OomNmgoo00Aoo`04G_MoogooG_L;Ool00ekgOomoo`06Ool2000]Ool;G0lEOol0
03Yoo`03001oogoo00moo`03G_Moogoo01aoo`03G_Moogoo00moo`03G_Moogoo00aoo`03G_Moogoo
01ioo`03G_Moogoo00Aoo`03G_Moogoo015oo`03G_Moogoo00Uoo`03G_Mooekg00Ioo`03G_Moogoo
00Aoo`04G_MoogooOol2G0/00gooG_Moo`05Ool00ekgOomNm`0;Ool00ekgOomoo`07Ool00`00Oomo
o`0[Ool01E`@G0mL3eP?G1000U`?00AH3e`@G0mL3aEoo`00>Woo00<007ooOol03goo00=NmgooOol0
77oo00=NmgooOol047oo00=NmgooOol02Woo00=NmgooOol07goo00=NmgooOol01Goo00=NmgooOol0
4Goo00=NmgooOol027oo00=NmgooG_L01Woo0P8g1Goo00=NmgooOol017oo00=NmgooOol017oo00=N
mgooG_L02goo00=NmgooOol01goo00<007ooOol0:goo2e`?5Goo000jOol00`00Oomoo`0?Ool00ekg
Oomoo`0LOol00ekgOomoo`0AOol00ekgOomoo`09Ool00ekgOomoo`0OOol00ekgOomoo`05Ool00ekg
Oomoo`0AOol00ekgOomoo`08Ool2G_L7Ool20SL5Ool00ekgOomoo`04Ool00ekgOomoo`05Ool2G_L:
Ool00ekgOomoo`08Ool00`00Oomoo`0[Ool00e`?F0mL4002G0l01UP?G11L3e`?F0mL41Eoo`00>Woo
00<007ooOol03goo00=NmgooOol077oo00=NmgooOol04Woo00=NmgooOol027oo00=NmgooOol07goo
00=NmgooOol01Woo00=NmgooOol047oo00=NmgooOol027oo00=NmgooOol01Woo00=NmgooOol017oo
00=NmgooOol00U`?0Woo00=NmgooOol01Woo00=NmgooOol027oo00=NmgooOol027oo00<007ooOol0
:goo2e`B5Goo000jOol00`00Oomoo`0>Ool00ekgOomoo`0MOol00ekgOomoo`0COol2G_L8Ool00ekg
Oomoo`0NOol00ekgOomoo`07Ool00ekgOomoo`0AOol00ekgOomoo`07Ool2G_L7Ool00ekgOomoo`04
Ool00ekgOomoo`02G0l2Ool00ekgOomoo`05Ool2G_L:Ool00ekgOomoo`08Ool00`00Oomoo`0[Ool0
2e`CG19L4ePBG1=L4U`CF19L4e`BG1<05Goo000jOol00`00Oomoo`0>Ool00ekgOomoo`0MOol00ekg
Oomoo`0EOol00ekgOomoo`05Ool00ekgOomoo`0NOol00ekgOomoo`08Ool00ekgOomoo`0@Ool015kg
OomL05`01Goo00=NmgooG_L01goo0P7G1Goo00=NmgooOol017oo00=NmgooOol01Goo00=NmgooG_L0
27oo00=NmgooOol02Goo00<007ooOol0:goo2e`B5Goo000jOol00`00Oomoo`0>Ool00ekgOomoo`0M
Ool00ekgOomoo`0FOol00ekgOomoo`04Ool00ekgOomoo`0NOol00ekgOomoo`08Ool00ekgOomoo`0@
Ool015kgOomL05`01Goo00=NmgooG_L01goo0P7G1Goo00ANmgooG19L4P=oo`03G_Moogoo00Eoo`03
G_Mooekg00Qoo`03G_Moogoo00Uoo`03001oogoo02]oo`0;G1=H4U`CG19L4ePBG1=L4U`CF19L4`0E
Ool003Yoo`03001oogoo00ioo`03G_Moogoo01eoo`03G_Moogoo01Moo`03G_Moogoo00=oo`03G_Mo
ogoo01ioo`03G_Moogoo00Uoo`03G_Moogoo011oo`03G_Moogoo00Aoo`04G_MoogooG_L7Ool00ekg
Oomoo`04Ool015kgOomL4U`B0goo00=NmgooOol01Goo00ANmgooOomNm`Moo`03G_Moogoo00Uoo`03
001oogoo02]oo`0;G1EL5U`EG1IL5E`FG1EL5U`EG1IL5@0EOol003Yoo`03001oogoo00ioo`03G_Mo
ogoo01eoo`03G_Moogoo01Qoo`03G_Moogoo009oo`03G_Moogoo01ioo`03G_Moogoo00Uoo`03G_Mo
ogoo011oo`04G_Mooe`2G083Ool015kgOomooekg1goo00=NmgooOol017oo00=NmgooOol017oo00=N
mgooOol01Goo00ANmgooOomNm`Ioo`03G_Moogoo00Yoo`03001oogoo02]oo`0;G1IL5E`FF1EL5U`E
G1IH5E`FG1EL5P0EOol003Yoo`8000moo`03G_Moogoo01eoo`03G_Moogoo01Uoo`05G_MoogooOomN
m`0POol00ekgOomoo`0:Ool00ekgOomoo`0?Ool015kgOomL0U`20Woo00=NmgooOol00Woo00=Nmgoo
Ool017oo00=NmgooOol017oo00=Nme`EG1D017oo00=NmgooOol017oo00=NmgooOol00Woo00=Nmgoo
Ool00goo00=NmgooOol02Goo0P00;Goo00]L5E`FG1EL5U`EG1IL5E`FG1EL5U`E01Eoo`00>Woo00<0
07ooOol03Woo00=NmgooOol07Goo00=NmgooOol06Woo0ekg8Goo00=NmgooOol02goo00=NmgooOol0
3goo00=NmgooOol00Woo00=NmgooOol00Woo00=NmgooOol01Goo0P5g17oo00=Nme`EG1D00goo00=N
mgooOol01Goo00=NmgooOol00Woo00=NmgooOol00goo00=NmgooOol02Woo00<007ooOol0:goo00]L
5UPEG1IL5E`FF1EL5U`EG1IH5E`F01Eoo`00>Woo00<007ooOol03Woo00=NmgooOol07Goo00=Nmgoo
Ool077oo00=NmgooOol07goo00=NmgooOol02goo00=NmgooOol03goo00ENmgooG0EL1Ekg00Eoo`03
G_Moogoo00Eoo`81M`Aoo`03G_Moogoo00=oo`03G_Moogoo00Eoo`03G_Moogoo00=oo`05G_Moogoo
OomNm`0=Ool00`00Oomoo`0[Ool;E1LEOol003Yoo`03001oogoo00ioo`03G_Moogoo01eoo`03G_Mo
ogoo01aoo`9Nmamoo`03G_Moogoo00eoo`03G_Moogoo00ioo`05G_Mooe`5G0ENm`05Ool00ekgOomo
o`05Ool00ekgOomoo`03Ool2F1L4Ool00ekgOomoo`05Ool00ekgOomoo`03Ool01EkgOomoogooG_L0
3Goo00<007ooOol0:goo00EH5e@GE1MD5UPG009D5`04E1IH5e@GE1LEOol003Yoo`03001oogoo00io
o`03G_Moogoo01eoo`03G_Moogoo01aoo`03G_Mooekg01ioo`03G_Moogoo00eoo`03G_Moogoo00io
o`05G_MoogooOomNm`05Ool00ekgOomoo`05Ool00ekgOomoo`03Ool2F1L4Ool00ekgOomoo`05Ool0
0ekgOomoo`03Ool01EkgOomoogooG_L03Goo00<007ooOol0:goo2e@G5Goo000jOol00`00Oomoo`0>
Ool00ekgOomoo`0LOol00ekgOomoo`0MOol015kgOomooekg7Goo00=NmgooOol03Woo00=NmgooOol0
3Woo00ANmgooG0QL20Eoo`03G_Moogoo00Eoo`03G_L0m`3g00=oo`03G_Moogoo00=oo`03G_Moogoo
00Eoo`03G_Moogoo00Aoo`03G_Mooekg00ioo`03001oogoo02]oo`03E1MD5UPG009D5`06E1IH5e@G
E1MD5UPG5Goo000jOol00`00Oomoo`0>Ool00ekgOomoo`0LOol00ekgOomoo`0MOol01EkgOomoogoo
G_L077oo00=NmgooOol03Woo00=NmgooOol03Woo00ANmgooG0QL20Ioo`03G_Moogoo00Aoo`03G_L0
m`3g00=oo`9<5`Aoo`03G_Moogoo00Aoo`03G_Moogoo00Eoo`03G_Mooekg00ioo`03001oogoo02]o
o`]85aEoo`00>Woo00<007ooOol03Woo00=NmgooOol077oo00=NmgooOol07Goo00=NmgooOol00Woo
0Ukg6Woo00=NmgooOol03goo00=NmgooOol03Goo00=NmgooG_L01goo00=NmgooOol017oo00=Nmgoo
Ool00goo0T`G17oo00=NmgooOol017oo00=NmgooOol01Woo0Ukg3Woo00<007ooOol0:goo0dPG00E4
5TPGB1M85d@F00=85aEoo`00>Woo00<007ooOol03Woo00=NmgooOol077oo00=NmgooOol07Goo00=N
mgooOol017oo00=NmgooOol05goo00=NmgooOol03goo00=NmgooOol03Woo0Ukg1goo00=NmgooOol0
17oo00ENmgoo09L0Ugoo00905`Eoo`03G_Moogoo00Aoo`03G_Moogoo00Ioo`03G_Moogoo00eoo`03
001oogoo02]oo`]85aEoo`00>Woo00<007ooOol03Woo00=NmgooOol077oo00=NmgooOol07Goo00=N
mgooOol01Goo00=NmgooOol05Woo00=NmgooOol047oo00=NmgooOol03Goo00ANmgooG0]L2`Eoo`03
G_Moogoo00Aoo`04G_Moo`2G09L2O0000d0GOomoo`03Ool00ekgOomoo`04Ool00ekgOomoo`06Ool0
0ekgOomoo`0=Ool00`00Oomoo`0[Ool00dPGA1I85`02B1L01T@FB1M85dPGA1I85aEoo`00>Woo0P00
3Woo00=NmgooOol07Goo00=NmgooOol07Goo00=NmgooOol01Woo00=NmgooOol057oo00=NmgooOol0
4Goo00=NmgooOol03Goo00ANmgooG0]L2`Eoo`03G_Moogoo00Aoo`04G_Moogoo03L2O0000ekgOomo
o`03Ool00ekgOomoo`04Ool00ekgOomoo`06Ool2G_L=Ool00`00G_Moo`0/Ool2?1L01CPG?1Ll5c`G
>1L00c`G00<h5gooOol04goo000jOol00`00Oomoo`0=Ool00ekgOomoo`0MOol00ekgOomoo`0MOol0
0ekgOomoo`07Ool00ekgOomoo`0COol00ekgOomoo`0BOol00ekgOomoo`0<Ool2G_L8Ool00ekgOomo
o`03Ool00ekgOomoo`0203L00gooG_Moo`04Ool00ekgOomoo`03Ool00ekgOomoo`07Ool2G_L=Ool0
0ekg001oo`0/Ool02c`G>1Ll5cPF?1Lh5c`G>1Hl5cPG?1L05Goo000jOol00`00Oomoo`0=Ool00ekg
Oomoo`0MOol00ekgOomoo`0MOol00ekgOomoo`08Ool2G_LCOol00ekgOomoo`0COol00ekgOomoo`0;
Ool2G_L00gooG0mL3`05Ool00ekgOomoo`03Ool00ekgOomoo`03Ool00ekgOomoo`03Ool00ekgOomo
o`03Ool00ekgOomoo`06Ool20^400ekgOomoo`0;Ool00ekg001oo`0/Ool01CPG?1Ll5c`G>1L00c`G
00<h5c`G?1L05Goo000jOol00`00Oomoo`0=Ool00ekgOomoo`0MOol00ekgOomoo`0MOol00ekgOomo
o`0:Ool00ekgOomoo`0@Ool00ekgOomoo`0COol00ekgOomoo`0:Ool015kgOomNmgoo0U`?1Goo00=N
mgooOol017oo00=NmgooOol00Woo00=NmgooOol00Woo00=NmgooOol017oo00=NmgooOol01Woo0P;Q
00=NmgooOol02Woo00=Nmgoo0000;Goo00/`5b`F<1L/5c0G;1H`5b`G<1L/5S0G01Eoo`00>Woo00<0
07ooOol03Goo00=NmgooOol07Goo00=NmgooOol07Goo00=NmgooOol02goo00=NmgooOol03goo00=N
mgooOol057oo00=NmgooOol02Goo00ANmgooOomNm`Moo`03G_Moogoo00Aoo`03G_Moogoo009oo`03
G_Moogoo009oo`03G_Moogoo00Aoo`03G_Moogoo00Eoo`82i@9oo`03G_Moogoo00Uoo`03G_Moo`00
02eoo`0;;1L`5b`G<1L/5c0G;1L`5b`G<1L/5`0EOol003Yoo`03001oogoo00eoo`03G_Moogoo01eo
o`03G_Moogoo01aoo`03G_Moogoo00eoo`03G_Moogoo00ioo`03G_Moogoo01Aoo`03G_Moogoo00Uo
o`04G_MoogooG_L7Ool00ekgOomoo`04Ool00ekgOomoo`02Ool00ekgOomoo`02Ool00ekgOomoo`04
Ool00ekgOomoo`04Ool00`;X0^D2i@02Ool00ekgOomoo`08Ool015kgOomoo`00;Goo00/`5b`G<1L/
5S0G;1L`5b`F<1L/5c0G01Eoo`00>Woo00<007ooOol03Goo00=NmgooOol07Goo00=NmgooOol077oo
00=NmgooOol03Woo00=NmgooOol03Goo00=NmgooOol05Goo00=NmgooOol01goo00ENmgooOomooekg
009oo`9L4P=oo`03G_Moogoo00Aoo`03G_Moogoo009oo`03G_Moogoo009oo`03G_Moogoo00Aoo`03
G_Moogoo00Aoo`82j0=oo`03G_Moogoo00Qoo`04G_Moogoo000]Ool02b`G<1L/5c0G;1L`5b`G<1L/
5c0G;1L05Goo000jOol00`00Oomoo`0=Ool00ekgOomoo`0MOol00ekgOomoo`0LOol00ekgOomoo`0?
Ool00ekgOomoo`0<Ool00ekgOomoo`0EOol00ekgOomoo`07Ool00ekgOomoo`02Ool015kgOomL4U`B
17oo00=NmgooOol00goo00=NmgooOol00Woo00=NmgooOol00Woo00=NmgooOol00goo00=NmgooOol0
17oo0P;[00ENmgooOomooekg00Uoo`05G_MoogooOol0000]Ool02b@G81HT5b0G91LP5R@G81LT5b0F
91L05Goo000jOol00`00Oomoo`0=Ool00ekgOomoo`0MOol00ekgOomoo`0LOol00ekgOomoo`0@Ool2
G_L;Ool00ekgOomoo`0GOol00ekgOomoo`06Ool00ekgOomoo`02Ool00ekgOomoo`05Ool00ekgOomo
o`03Ool00ekgOomoo`02Ool00ekgOomoo`02Ool00ekgOomoo`03Ool00ekgOomoo`04Ool20^/4Ool0
0ekgOomoo`07Ool01EkgOomoogoo0000;Goo2b0G5Goo000jOol00`00Oomoo`0=Ool00ekgOomoo`0M
Ool00ekgOomoo`0LOol00ekgOomoo`0BOol00ekgOomoo`08Ool00ekgOomoo`0GOol00ekgOomoo`06
Ool00ekgOomoo`02Ool00ekgOomoo`05Ool00ekgOomoo`03Ool00ekgOomoo`02Ool00ekgOomoo`02
Ool00ekgOomoo`03Ool00ekgOomoo`03Ool20^h00ekgOomoo`03Ool00ekgOomoo`05Ool00ekgOomo
o`02Ool00`00Oomoo`0[Ool02b@G81LT5b0F91LP5b@G81HT5b0G91L05Goo000jOol2000>Ool00ekg
Oomoo`0MOol00ekgOomoo`0LOol00ekgOomoo`0COol00ekgOomoo`07Ool00ekgOomoo`0HOol00ekg
Oomoo`04Ool00ekgOomoo`03Ool00ekgOomoo`02G1D3Ool00ekgOomoo`03Ool00ekgOomoo`02Ool0
0ekgOomoo`02Ool00ekgOomoo`03Ool00ekgOomoo`03Ool20^h00ekgOomoo`03Ool00ekgOomoo`04
Ool00ekgOomoo`02Ool2000]Ool;81LEOol003Yoo`03001oogoo00eoo`03G_Moogoo01aoo`03G_Mo
ogoo01eoo`03G_Moogoo01Aoo`03G_Moogoo00Ioo`03G_Moogoo01Qoo`03G_Moogoo00Aoo`03G_Mo
ogoo00Aoo`04G_Mooe`EG1D3Ool00ekgOomoo`03Ool00ekgOomoo`02Ool00ekgOomoo`02Ool00ekg
Oomoo`03Ool015kgOomoogoo0P;a00=ooekgOol01Goo00=NmgooOol017oo00=NmgooOol00goo00<0
07ooOol0:goo00<D5a@F51L00Q@G00HD5Q@G51LD5a@F51LEOol003Yoo`03001oogoo00eoo`03G_Mo
ogoo01aoo`03G_Moogoo01eoo`03G_Moogoo01Eoo`03G_Moogoo00Eoo`03G_Moogoo01Uoo`03G_Mo
ogoo00=oo`03G_Moogoo00Aoo`03G_Moogoo00Eoo`03G_Moogoo009oo`03G_Moogoo009oo`03G_Mo
ogoo009oo`03G_Moogoo009oo`03G_Moogoo009oo`82l@03OomNmgoo00Eoo`03G_Moogoo00=oo`03
G_Moogoo00Aoo`03001oogoo02]oo`/D5aEoo`00>Woo00<007ooOol03Goo00=NmgooOol077oo00=N
mgooOol07Goo00=NmgooOol05Woo00=NmgooOol017oo00=NmgooOol06Woo00=NmgooOol00Woo00=N
mgooOol017oo00=NmgooOol01Goo00=NmgooOol00Woo00=NmgooOol00Woo00=NmgooOol00Woo00=N
mgooOol00Woo00ANmgooOomoo`82m09oo`03G_Moogoo00Aoo`03G_Moogoo00=oo`03G_Moogoo00Ao
o`03001oogoo02]oo`<D5`0551HD5a@G51LD5P0351LEOol003Yoo`03001oogoo00eoo`03G_Moogoo
01aoo`03G_Moogoo01eoo`03G_Moogoo01Moo`9Nm`Aoo`03G_Moogoo01Yoo`05G_MoogooOomNm`08
Ool00ekgOomoo`02F1L2Ool00ekgOomoo`02Ool00ekgOomoo`02Ool00ekgOomoo`02Ool00ekgOomo
o`02Ool015kgOomoogoo0P;d00=ooekgOol01goo00ENmgooOomooekg00Moo`03001oogoo02]oo`/D
5aEoo`00>Woo00<007ooOol03Goo00=NmgooOol077oo00=NmgooOol07Goo00=NmgooOol06Goo00EN
mgooOomooekg01eoo`04G_MoogooG_L8Ool00ekgOomoo`02F1L2Ool00ekgOomoo`03Ool01EkgOomo
ogooG_L00goo00=NmgooOol00goo00ANmgoo0_L2m`=oo`03G_Moogoo00Ioo`05G_MoogooOomNm`07
Ool00`00Oomoo`0[Ool02`PG11H85`@G21L45PPG11L85`@F21L05Goo000jOol00`00Oomoo`0=Ool0
0ekgOomoo`0LOol00ekgOomoo`0MOol00ekgOomoo`0JOol00ekgOomNm`0NOol015kgOomooekg27oo
00=NmgooOol017oo00=NmgooOol00goo00ENmgooOomooekg00=oo`03G_Moogoo00=oo`04G_Moo`;g
0_L3Ool00ekgOomoo`06Ool015kgOomooekg27oo00<007ooOol0:goo2`PG5Goo000jOol00`00Oomo
o`0=Ool00ekgOomoo`0LOol00ekgOomoo`0MOol00ekgOomoo`0KOol2G_LOOol00ekgOomNm`09Ool0
0ekgOomoo`03Ool00ekgOomoo`03Ool01EkgOomoogooG_L00goo00=NmgooOol00goo00=Nm`:G0YL0
0goo00=NmgooOol01goo00ANmgooOomNm`Qoo`03001oogoo02]oo`0;21L45`PG11H85`@G21L45PPG
11L85`0EOol0039oo`D000=oo`03001oogoo00eoo`03G_Moogoo01aoo`03G_Moogoo01eoo`03G_Mo
ogoo01aoo`03G_Moogoo01eoo`03G_Mooekg00Uoo`03G_Moogoo009<5`9oo`03G_Moogoo009oo`05
G_MoogooOomNm`03Ool00ekgOomoo`02Ool015kgOol2U`:G0goo00=NmgooOol01goo00=NmgooG_L0
2Goo00<007ooOol0:goo2`PG5Goo000dOol00`00Oomoo`03Ool00`00Oomoo`0=Ool00ekgOomoo`0L
Ool00ekgOomoo`0MOol00ekgOomoo`0LOol2G_LOOol00ekgOomoo`08Ool00ekgOomoo`02C1L2Ool0
0ekgOomoo`02Ool01EkgOomoogooG_L00goo00=NmgooOol00Woo0P8g1Goo00=NmgooOol027oo0Ukg
2Goo00<007ooOol0:goo00<05`0F01L00P0G00H05P0G01L05`0F01LEOol002ioo`<000=oo`03001o
ogoo00=oo`8000ioo`03G_Moogoo01aoo`03G_Moogoo01eoo`03G_Moogoo01aoo`04G_MooekgG_LM
Ool00ekgOomoo`09Ool00ekgOomoo`03Ool00ekgOomoo`02Ool01EkgOomoogooG_L00goo00=Nmgoo
Ool00Woo0P8g1Goo00=NmgooOol027oo00=NmgooOol01Woo0`00;Goo2`0G5Goo000dOol00`00Oomo
o`03Ool00`00Oomoo`0=Ool00ekgOomoo`0LOol00ekgOomoo`0MOol00ekgOomoo`0LOol01EkgOomo
ogooG_L077oo0Ukg2Woo00=NmgooOol00goo00=NmgooOol00Woo00ENmgooOomooekg00=oo`03G_Mo
ogoo009oo`03G_Moogoo00=oo`03G_Moogoo00Qoo`9Nm`Yoo`03001oogoo02]oo`<05`0501H05`0G
01L05P0301LEOol003Aoo`03001oogoo00=oo`03001oogoo00eoo`03G_Moogoo01aoo`03G_Moogoo
01eoo`03G_Moogoo01aoo`03G_Moogoo009oo`03G_Moogoo01Uoo`9Nm`Yoo`04G_MoogooOol2@1L0
0ekgOomoo`02Ool01EkgOomoogooG_L00goo00=NmgooOol00P7G00=NmgooOol00goo00=NmgooOol0
27oo0Ukg2Woo00<007ooOol0:goo2`0G5Goo000cOol20005Ool00`00Oomoo`0=Ool00ekgOomoo`0L
Ool00ekgOomoo`0LOol00ekgOomoo`0MOol00ekgOomoo`03Ool00ekgOomoo`0HOol00ekgOomNm`0:
Ool00ekgOomoo`02@1L00gooG_Moo`02Ool01EkgOomoogooG_L00goo00=NmgooOol00P7G1Woo00=N
mgooOol01goo00=NmgooG_L02Woo00<007ooOol0:goo00<0M`1f07L00P1g00H0MP1g07L0M`1f07LE
Ool003Yoo`03001oogoo00eoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01eoo`03G_Mo
ogoo00Aoo`03G_Moogoo00aoo`82h@Qoo`05G_MoogooOomNm`09Ool00ekgOomoo`02Ool2=1L3Ool0
1EkgOomoogooG_L00goo00ENm`5g0GMooekg00Eoo`03G_Moogoo00Qoo`04G_MoogooG_L9Ool00`00
Oomoo`0[Ool;07LEOol003Yoo`03001oogoo00eoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Mo
ogoo01eoo`03G_Moogoo00Eoo`03G_Moogoo00]oo`82h@030^Eoogoo00Eoo`05G_MoogooOomNm`09
Ool00ekgOomoo`02Ool2:1L3Ool01EkgOomoogooG_L00goo00ENm`5g0GMooekg00Eoo`03G_Moogoo
00Moo`05G_MoogooOomNm`09Ool00`00Oomoo`0[Ool307L01@1f07L0M`1g07H00`1g5Goo000jOol0
0`00Oomoo`0=Ool00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0MOol00ekgOomoo`06Ool2
G_L<Ool20^D7Ool00ekgOomoo`02Ool00ekgOomoo`07Ool01EkgOomoogoo:1L00W`00Woo00INmgoo
OomooekgOol20?L01EkgOomoogooG_L01Goo00=NmgooOol01goo00ENmgooOomooekg00Uoo`03001o
ogoo02]oo`/0eaEoo`00>Woo00<007ooOol03Goo00=NmgooOol077oo00=NmgooOol077oo00=Nmgoo
Ool07Goo00=NmgooOol027oo00=NmgooOol02Woo0P;X1Woo00=NmgooOol00Woo00=NmgooOol01goo
00=NmgooOol00Woo0W`00goo00ENmgooOomNmgoo0080m`Aoo`03G_Moogoo009oo`03G_Moogoo00Mo
o`03G_Moogoo009oo`03G_Moogoo00Moo`03001oogoo02]oo`030=L0eP3G0080e`060=H0e`3G0=L0
eP3G5Goo000jOol00`00Oomoo`0=Ool00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0MOol0
0ekgOomoo`09Ool00ekgOomoo`09Ool20^P6Ool00ekgOomoo`03Ool00ekgOomoo`06Ool00ekgOomo
o`02Ool201L3Ool015kgOomooekg0Woo00=NmgooOol00Woo00=NmgooOol00Woo00=NmgooOol01goo
00=NmgooOol00Woo00=NmgooOol01goo00<007ooOol0:goo2`3G5Goo000jOol2000>Ool00ekgOomo
o`0LOol00ekgOomoo`0LOol00ekgOomoo`0MOol00ekgOomoo`0:Ool00ekgOomoo`09Ool20^/5Ool0
0ekgOomoo`03Ool00ekgOomoo`06Ool00ekgOomoo`03Ool01Ukg03L0=gooG_Moo`80U`9oo`05G_Mo
ogooOomNm`05Ool00ekgOomoo`06Ool00ekgOomoo`03Ool00ekgOomoo`06Ool2000]Ool30=L01@3F
0=L0e`3G0=H00`3G5Goo000jOol00`00Oomoo`0=Ool00ekgOomoo`0LOol00ekgOomoo`0LOol00ekg
Oomoo`0MOol00ekgOomoo`0;Ool00ekgOomoo`08Ool20^/4Ool00ekgOomoo`05Ool00ekgOomoo`06
Ool00ekgOomoo`02Ool01Ukg03L0=gooG_Moo`80U`9oo`05G_MoogooOomNm`04Ool00ekgOomoo`06
Ool00ekgOomoo`05Ool00ekgOomoo`06Ool00`00Oomoo`0[Ool;0CLEOol003Yoo`03001oogoo00eo
o`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01eoo`03G_Moogoo00aoo`9Nm`Uoo`82kP=o
o`03G_Moogoo00Eoo`03G_Moogoo00Ioo`03G_Moogoo009oo`05G_MoogooOomNm`02Ool015kgOomo
oekg0goo00=NmgooOol00Woo00=NmgooOol01Woo00=NmgooOol01Goo00=NmgooOol01Woo00<007oo
Ool0:goo00<1=`4f0CL00P4g00H1=P4g0CL1=`4f0CLEOol003Yoo`03001oogoo00eoo`03G_Moogoo
01aoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo00moo`03G_Moogoo00Ioo`82kP=oo`03
G_Moogoo00Ioo`03G_Moogoo00Eoo`03G_Moogoo009oo`05G_MoogooOomNm`02Ool015kgOomooekg
0goo00=NmgooOol00Woo00=NmgooOol01Goo00=NmgooOol01Woo00=NmgooOol01Woo00<007ooOol0
:goo2`4g5Goo000jOol00`00Oomoo`0=Ool00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0L
Ool00ekgOomoo`0@Ool00ekgOomoo`06Ool20_42Ool00ekgOomoo`06Ool00ekgOomoo`06Ool01Ekg
OomoogooG_L00goo00ANmgooOomNm`9oo`05G_MoogooOomNm`03Ool00ekgOomoo`06Ool00ekgOomo
o`06Ool00ekgOomoo`06Ool00`00Oomoo`0[Ool30CL01@4f0CL1=`4g0CH00`4g5Goo000jOol00`00
Oomoo`0=Ool00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0AOol00ekg
Oomoo`05Ool20_42Ool00ekgOomoo`07Ool00ekgOomoo`05Ool00ekgOomoo`02Ool015kgOomooekg
0Woo00ANmgooOomNm`9oo`03G_Moogoo009oo`03G_Moogoo00Eoo`03G_Moogoo00Moo`03G_Moogoo
00Ioo`03001oogoo02]oo`0;0IL1]`6G0KL1U`6g0IL1]`6G0KL1U`0EOol003Yoo`03001oogoo00eo
o`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo019oo`03G_Moogoo00Eo
o`82m003OomNmgoo00Qoo`03G_Moogoo00Eoo`03G_Moogoo009oo`04G_MoogooG_L2Ool015kgOomo
oekg0Woo00=NmgooOol00Woo00=NmgooOol01Goo00=NmgooOol01goo00=NmgooOol01Woo00<007oo
Ool0:goo00/1]`6F0KL1U`6g0IH1]`6G0KL1UP6g01Eoo`00>Woo00<007ooOol03Goo00=NmgooOol0
77oo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol04goo00=NmgooOol017oo0P;d00=ooekg
Ool02Goo00=NmgooOol01Goo00ENmgooOomooekg009oo`04G_MoogooG_L2Ool015kgOomooekg0goo
00=NmgooOol01Goo00=NmgooOol027oo00=NmgooOol01Woo00<007ooOol0:goo00/1U`6g0IL1]`6G
0KL1U`6g0IL1]`6G01Eoo`00>Woo00<007ooOol03Goo00=NmgooOol077oo00=NmgooOol077oo00=N
mgooOol077oo00=NmgooOol057oo0Ukg1goo00=NmgooOol02Goo00=NmgooOol017oo00ENmgooOomo
oekg009oo`04G_MoogooG_L2Ool015kgOomooekg0goo00=NmgooOol01Goo00=NmgooOol027oo00=N
mgooOol01Woo00=NmgooOol0:goo00/1]`6G0KL1UP6g0IL1]`6F0KL1U`6g01Eoo`00>Woo00<007oo
Ool037oo00=NmgooOol07Goo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol05Woo00=Nmgoo
Ool00Woo0P;g37oo00=NmgooOol017oo00ENmgooOomooekg009oo`04G_MoogooG_L2Ool015kgOomo
oekg0goo00=NmgooOol017oo00=NmgooOol02Woo00=NmgooOol017oo00=Nm`00Ool0;7oo2`8G5Goo
000jOol2000=Ool00ekgOomoo`0MOol00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0GOol0
15kgOomoogoo0P;g3Goo00=NmgooOol017oo00ANmgooOomNm`=oo`05G_MooekgOomNm`03Ool015kg
Oomooekg1goo00=NmgooOol02Woo00=NmgooOol00goo00=Nm`000000;Goo00<25`8F0QL00P8G00H2
5P8G0QL25`8F0QLEOol003Yoo`03001oogoo00aoo`03G_Moogoo01eoo`03G_Moogoo01aoo`03G_Mo
ogoo01aoo`03G_Moogoo01Qoo`05G_MoogooOomNm`0=Ool00ekgOomoo`04Ool01EkgOomoogooG_L0
0Woo00ENmgooG_Mooekg009oo`05G_MoogooOomNm`06Ool00ekgOomoo`0;Ool015kgOomoogoo0Ukg
0Woo00<007ooOol0:goo2`8G5Goo000jOol00`00Oomoo`0<Ool00ekgOomoo`0MOol00ekgOomoo`0L
Ool00ekgOomoo`0LOol00ekgOomoo`0IOol015kgOomooekg3Woo00=NmgooOol00goo00ENmgooOomo
oekg009oo`05G_MooekgOomNm`02Ool01EkgOomoogooG_L01Goo00=NmgooOol037oo00ANmgooOomN
m`Aoo`03001oogoo02]oo`<25`050QH25`8G0QL25P030QLEOol003Yoo`03001oogoo00aoo`03G_Mo
ogoo01eoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01Yoo`04G_Moo`:G0YL=Ool00ekg
Oomoo`04Ool015kgOomooekg0Woo00ENmgooG_Mooekg009oo`05G_MoogooOomNm`05Ool00ekgOomo
o`0<Ool00ekgOomNm`05Ool00`00Oomoo`0[Ool;0WLEOol003Yoo`03001oogoo00aoo`03G_Moogoo
01eoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01]oo`03G_L2U`:G00ioo`03G_Moogoo
00=oo`04G_MoogooG_L2Ool01EkgOomNmgooG_L00Woo00ANmgooOomNm`Eoo`03G_Moogoo00eoo`9N
m`Ioo`03001oogoo02]oo`030WL2MP9g0082M`060WH2M`9g0WL2MP9g5Goo000jOol00`00Oomoo`0<
Ool00ekgOomoo`0LOol00ekgOomoo`0MOol00ekgOomoo`0LOol00ekgOomoo`0LOol2G_L>Ool00ekg
Oomoo`03Ool015kgOomooekg0Woo00ENmgooG_Mooekg009oo`04G_MoogooG_L5Ool00ekgOomoo`0=
Ool00ekgOomoo`05Ool00`00Oomoo`0[Ool;0WLEOol003Yoo`03001oogoo00aoo`03G_Moogoo01ao
o`03G_Moogoo01eoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Mooekg00ioo`03G_Moogoo009o
o`0=G_MoogooOomNmgooG_MooekgOomNmgooG_L00goo00=NmgooOol00Woo00=NmgooOol037oo0ekg
1goo00<007ooOol0:goo0`9g00D2MP9g0WL2M`9f00<2MaEoo`00>Woo00<007ooOol037oo00=Nmgoo
Ool077oo00=NmgooOol07Goo00=NmgooOol077oo00=NmgooOol077oo00ANmgoo0SL2=`eoo`03G_Mo
ogoo00=oo`0<G_MoogooG_MooekgOomNmgooG_Mooekg0Woo00=NmgooOol00goo00=NmgooOol02goo
00ANmgooOomNm`Moo`03001oogoo02]oo`/2eaEoo`00>Woo00<007ooOol037oo00=NmgooOol077oo
00=NmgooOol07Goo00=NmgooOol077oo00=NmgooOol077oo00ENmgoo0SL2=ekg00eoo`03G_Moogoo
009oo`0<G_MoogooG_MooekgOomNmgooG_Mooekg0Woo00=NmgooOol00Woo00=NmgooOol02goo00EN
mgooOomooekg00Moo`03001oogoo02]oo`030]L2eP;G0082e`060]H2e`;G0]L2eP;G5Goo000jOol0
0`00Oomoo`0<Ool00ekgOomoo`0LOol00ekgOomoo`0MOol00ekgOomoo`0LOol00ekgOomoo`0LOol0
0ekgOomoo`02Ool00ekgOomoo`0;Ool01EkgOomoogooG_L00Woo00UNmgooG_MooekgOomNmgooG_L0
0Woo00=NmgooOol00Woo00=NmgooOol02Woo00=NmgooOol00Woo00=NmgooOol01Goo00<007ooOol0
:goo2`;G5Goo000jOol2000=Ool00ekgOomoo`0LOol00ekgOomoo`0MOol00ekgOomoo`0LOol00ekg
Oomoo`0LOol00ekgOomoo`03Ool2G_L;Ool00ekgOomoo`02Ool03EkgOomNmgooG_MooekgOomNmgoo
G_Mooekg00Aoo`03G_Moogoo00Yoo`03G_Moogoo00=oo`03G_Moogoo00Aoo`8002eoo`0;0_D2m0;e
0_@2m@;d0_D2m0;e0_@2m@0EOol003Yoo`03001oogoo00aoo`03G_Moogoo01aoo`03G_Moogoo01eo
o`03G_Moogoo01aoo`03G_Moogoo01]oo`03G_Moogoo00Ioo`03G_Moogoo00Uoo`05G_MoogooOomN
m`02Ool2G_L00gooG_Moo`02G_L2Ool01EkgOomoogooG_L02goo0Ukg1goo00=NmgooOol017oo00<0
07ooOol0:goo2`;e5Goo000jOol00`00Oomoo`0<Ool00ekgOomoo`0LOol00ekgOomoo`0LOol00ekg
Oomoo`0MOol00ekgOomoo`0KOol00ekgOomoo`07Ool00ekgOomoo`08Ool01EkgOomoogooG_L00Woo
00=NmgooG_L00Ukg00EooekgOomooekg00=oo`03G_Moogoo00Qoo`03G_Moogoo00Moo`03G_Moogoo
00Aoo`03001oogoo02]oo`0;0_D2m0;e0_@2m@;d0_D2m0;e0_@2m@0EOol003Yoo`03001oogoo00ao
o`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01eoo`03G_Moogoo01]oo`03G_Moogoo00Qo
o`03G_Moogoo00Qoo`08G_MoogooOomNmgooG_Moo`=Nm`04OomNmgooG_L3Ool00ekgOomoo`08Ool0
0ekgOomoo`08Ool00ekgOomoo`04Ool00`00Oomoo`0[Ool;0_DEOol003Yoo`03001oogoo00aoo`03
G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01eoo`03G_Moogoo01]oo`04G_MoogooOol20ML6
Ool00ekgOomoo`07Ool025kgOomoogooG_MooekgOol3G_L017ooG_Mooekg0goo00=NmgooOol01goo
00=NmgooOol02Goo00=NmgooOol017oo00<007ooOol0:goo00/2lP;a0_82l@;b0_42lP;a0_82l@;b
01Eoo`00>Woo00<007ooOol037oo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol07Goo00=N
mgooOol06goo00ANmgooOomoo`81e`Moo`03G_Moogoo00Moo`07G_MoogooG_MooekgOol00ekg00Ao
oekgOomNm`9oo`03G_Moogoo00Moo`03G_Moogoo00Yoo`03G_Moogoo00Aoo`03001oogoo02]oo`0;
0_42lP;a0_82l@;b0_42lP;a0_82l@0EOol003Yoo`03001oogoo00aoo`03G_Moogoo01aoo`03G_Mo
ogoo01aoo`03G_Moogoo01eoo`03G_Moogoo01]oo`03G_Moogoo00]oo`9Nm`Moo`04G_MoogooOol2
G_L01GooG_MNmekgOol00Ukg0goo00=NmgooOol01Woo00=NmgooOol02goo00=NmgooOol017oo00<0
07ooOol0:goo00/2lP;a0_82l@;b0_42lP;a0_82l@;b01Eoo`00>Woo00<007ooOol037oo00=Nmgoo
Ool077oo00=NmgooOol077oo00=NmgooOol07Goo00=NmgooOol06goo00=NmgooOol03Goo00=Nmgoo
Ool01Goo00ENmgooOomNmgoo00ENm`05OomNmgooOomNm`07Ool2G_L>Ool00ekgOomoo`04Ool00`00
Oomoo`0[Ool02`;a0_82l@;b0_42lP;a0_82l@;b0_405Goo000jOol00`00Oomoo`0<Ool00ekgOomo
o`0LOol00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0>Ool00ekgOomo
o`04Ool01EkgOomooekgOol01Ekg00EooekgOomooekg00Ioo`03G_Moogoo00ioo`03G_Moogoo00Ao
o`03001oogoo02]oo`0;0^l2kP;_0^h2k`;^0^l2kP;_0^h2k`0EOol003Yoo`03001oogoo00aoo`03
G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo00moo`03
G_Moogoo00Aoo`03G_Moogoo00MNm`9oo`03G_Moogoo00Aoo`03G_Moogoo00moo`03G_Moogoo00Ao
o`03001oogoo02]oo`/2kQEoo`00>Woo0P003Goo00=NmgooOol077oo00=NmgooOol077oo00=Nmgoo
Ool077oo00=NmgooOol077oo00=NmgooOol047oo00=NmgooOol017oo00=NmgooG_L01Ukg0Woo00=N
mgooOol00goo00=NmgooOol047oo00=NmgooOol00goo0P00;Goo00/2k`;^0^l2kP;_0^h2k`;^0^l2
kP;_01Eoo`00>Woo00<007ooOol037oo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol077oo
00=NmgooOol077oo00=NmgooOol04Goo0Ukg17oo00=NmgooG_L01Ukg00=ooekgOol017oo00=Nmgoo
Ool04Goo00=NmgooOol017oo00<007ooOol0:goo2`;^5Goo000jOol00`00Oomoo`0<Ool00ekgOomo
o`0LOol00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0COol00ekgOomo
o`02Ool2G_L01GooG_MNmekgOol00Ukg17oo0Ukg57oo00=NmgooOol017oo00<007ooOol0:goo2`;[
5Goo000jOol00`00Oomoo`0<Ool00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0LOol00ekg
Oomoo`0LOol00ekgOomoo`0DOol01UkgOomoogooG_Moo`ENm`03OomNmgoo009oo`03G_Moogoo01Ao
o`03G_Moogoo00Aoo`03001oogoo02]oo`/2jaEoo`00>Woo00<007ooOol037oo00=NmgooOol077oo
00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol05Goo00ANmgooOomoo`MN
m`=oo`03G_Moogoo01Eoo`03G_Moogoo00Aoo`03001oogoo02]oo`/2jaEoo`00>Woo00<007ooOol0
37oo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol0
5Woo00=NmgooOol01ekg0Woo00=NmgooOol05Woo00=NmgooOol017oo00<007ooOol0:goo2`;[5Goo
000IOol20008Ool2000EOol00`00Oomoo`0<Ool00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomo
o`0LOol00ekgOomoo`0LOol00ekgOomoo`0GOol00ekgOomoo`05G_L2Ool00ekgOomoo`0GOol00ekg
Oomoo`04Ool00`00Oomoo`0[Ool02`;X0^L2j0;W0^P2i`;X0^L2j0;W0^P05Goo000IOol00`00Oomo
o`08Ool00`00Oomoo`0COol00`00Oomoo`0<Ool00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomo
o`0LOol00ekgOomoo`0LOol00ekgOomoo`0HOol9G_LJOol00ekgOomoo`04Ool00`00Oomoo`0[Ool;
0^PEOol000]oo`<00006Ool007oo001oo`001Goo00@007ooOomoo`8000Eoo`03001oogoo00eoo`03
001oogoo00=oo`03001oogoo00aoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03
G_Moogoo01aoo`03G_Moogoo01Yoo`ENmaaoo`03G_Moogoo00Aoo`03001oogoo02]oo`0;0^P2i`;X
0^L2j0;W0^P2i`;X0^L2j00EOol000aoo`08001oogoo001oo`00Ool000Eoo`03001oogoo00=oo`03
001oogoo009oo`03001oogoo00aoo`03001oo`0000Aoo`03001oogoo00aoo`83h1eoo`03G_Moogoo
01aoo`03G_Moogoo00aoo`9l00eoo`83h1Ioo`07G01L1E`8G0]L3e`BF1L00W`00P3g0P5g0goo0P5g
17oo0P3g17oo0P2G1Goo0P0g00Eoog`0O00X5c@G00905`9<5`9H5`03OomL5E`E009L4P9L3`03G0]L
25`8009L1@03G09L05`000Moo`03G_Moogoo00Aoo`03001oogoo02]oo`/2j1Eoo`0037oo00P007oo
Ool007oo001oo`001Goo00<007ooOol00Woo00<007ooOol00goo00<007ooOol037oo00<007oo0000
17oo3ekg0P?PBekg0W`03Ekg0P?P5Ukg00ML05`5G0QL2e`?G19H5`02O0020?L20GL3G_L20GL4G_L2
0?L4G_L209L5G_L203L01EkgO01l02PG=1L00T0G0T`G0UPG00=Nme`EG1D00U`B0U`?00=L2e`8G0P0
0U`500=L0U`0G0003ekg;Goo00/2i@;T0^D2i0;U0^@2i@;T0^D2i0;U01Eoo`0037oo00<007ooOol0
0P0000=oo`00Ool01Goo00<007ooOol00Woo0P0017oo00<007ooOol037oo00<007oo000017oo00<0
07ooOol037oo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol077oo00=N
mgooOol06goo0ekg7Goo00=NmgooOol017oo00<007ooOol0:goo00D2i0;U0^D2i@;T00<2i@030^@2
i@;U01Eoo`0037oo00<007ooOol02Woo00<007ooOol027oo00<007ooOol037oo00<007oo000017oo
00<007ooOol037oo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol077oo
00=NmgooOol06Woo1Ukg6goo00=NmgooOol017oo00<007ooOol0:goo00/2i@;T0^D2i0;U0^@2i@;T
0^D2i0;U01Eoo`002goo0`002goo0P0027oo0P003goo00<007ooOol00goo00<007ooOol037oo00=N
mgooOol077oo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol067oo1ekg
00=ooekgOol06Goo00=NmgooOol017oo00<007ooOol0:goo00<2h@;R0^400P;Q00H2hP;Q0^42h@;R
0^44Ool30003Ool00`00Oomoo`02Ool00`00Oomoo`03Ool003Yoo`03001oogoo00aoo`03G_Moogoo
01aoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01Moo`03G_Moogoo
00ENm`9oo`03G_Moogoo01Moo`03G_Moogoo00Aoo`03001oogoo02]oo`0;0^82h@;R0^42hP;Q0^82
h@;R0^42hP04Ool00`00Oomoo`02Ool00`00Ool00009Ool003Yoo`03001oogoo00aoo`03G_Moogoo
01aoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01Ioo`03G_Moogoo
00MNm`9oo`03G_Moogoo01Ioo`03G_Moogoo00Aoo`03001oogoo02]oo`<2h@050^82h@;Q0^42hP03
0^45Ool01`00Oomoogoo001oo`0000Uoo`00>Woo00<007ooOol037oo00=NmgooOol077oo00=Nmgoo
Ool077oo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol05Goo00ANmgooOomoo`MNm`=oo`03
G_Moogoo01Eoo`03G_Moogoo00Aoo`03001oogoo02]oo`0;0^82h@;R0^42hP;Q0^82h@;R0^42hP05
Ool01`00Oomoogoo001oo`0000Uoo`00>Woo00<007ooOol037oo00=NmgooOol077oo00=NmgooOol0
77oo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol057oo00INmgooOomooekgOol5G_L00goo
G_Moo`02Ool2G_LEOol00ekgOomoo`04Ool00`00Oomoo`0jOol00`00Ool00002Ool00`00Ool00009
Ool003Yoo`03001oogoo00aoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Mo
ogoo01aoo`03G_Moogoo019oo`9Nm`Aoo`9Nm`05OomNmekgG_Moo`02G_L5Ool00ekgOomoo`0BOol0
0ekgOomoo`04Ool00`00Oomoo`0kOol00`00Oomoo`02Ool00`00Oomoo`08Ool003Yoo`8000eoo`03
G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo015oo`03
G_Moogoo00=oo`03G_Mooekg00INm`03OomNmgoo00Aoo`03G_Moogoo015oo`03G_Moogoo00=oo`80
04eoo`00>Woo00<007ooOol037oo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol077oo00=N
mgooOol077oo00=NmgooOol047oo00=NmgooOol017oo00=NmgooG_L01Ukg0Woo00=NmgooOol00goo
00=NmgooOol047oo00=NmgooOol017oo00<007ooOol0Bgoo000jOol00`00Oomoo`0<Ool00ekgOomo
o`0LOol00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0?Ool00ekgOomo
o`04Ool00ekgOomoo`06G_L017ooG_Mooekg1Woo0Ukg47oo00=NmgooOol017oo00<007ooOol0Bgoo
000jOol00`00Oomoo`0<Ool00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0MOol00ekgOomo
o`0KOol00ekgOomoo`0>Ool00ekgOomoo`04Ool01EkgOomooekgOol01Ekg00EooekgOomooekg00Mo
o`03G_Moogoo00eoo`03G_Moogoo00Aoo`03001oogoo04]oo`00>Woo00<007ooOol037oo00=Nmgoo
Ool077oo00=NmgooOol077oo00=NmgooOol07Goo00=NmgooOol06goo00=NmgooOol03Goo00=Nmgoo
Ool01Goo00ENmgooOomNmgoo00ENm`05OomNmgooOomNm`08Ool00ekgOomoo`0<Ool00ekgOomoo`04
Ool00`00Oomoo`1;Ool003Yoo`03001oogoo00aoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Mo
ogoo01eoo`03G_Moogoo01]oo`04G_MoogooOol20ML8Ool2G_L7Ool015kgOomoogoo0Ukg00Eooekg
G_MNmgoo009Nm`=oo`03G_Moogoo00Ioo`03G_Moogoo00]oo`03G_Moogoo00Aoo`03001oogoo04]o
o`00>Woo00<007ooOol037oo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol07Goo00=Nmgoo
Ool06goo00ANmgooOomoo`81e`Moo`03G_Moogoo00Moo`07G_MoogooG_MooekgOol00ekg00Aooekg
OomNm`9oo`03G_Moogoo00Moo`03G_Moogoo00Yoo`03G_Moogoo00Aoo`03001oogoo04]oo`00>Woo
00<007ooOol037oo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol07Goo00=NmgooOol06goo
00=NmgooOol02Goo00=NmgooOol01goo00QNmgooOomooekgOomNmgoo0ekg00AooekgOomNm`=oo`03
G_Moogoo00Moo`9Nm`Yoo`03G_Moogoo00Aoo`03001oogoo04]oo`00>Woo00<007ooOol037oo00=N
mgooOol077oo00=NmgooOol077oo00=NmgooOol07Goo00=NmgooOol06goo00=NmgooOol027oo00=N
mgooOol027oo00QNmgooOomooekgOomNmgoo0ekg00AooekgOomNm`Aoo`03G_Moogoo00Qoo`03G_Mo
ogoo00Moo`03G_Moogoo00Aoo`03001oogoo04]oo`00>Woo00<007ooOol037oo00=NmgooOol077oo
00=NmgooOol07Goo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol01Woo00=NmgooOol027oo
00ENmgooOomooekg009oo`9Nm`03OomNmgoo009Nm`9oo`05G_MoogooOomNm`0;Ool00ekgOomoo`05
Ool00ekgOomoo`05Ool00`00Oomoo`1;Ool003Yoo`8000eoo`03G_Moogoo01aoo`03G_Moogoo01eo
o`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo00Aoo`9Nm`]oo`0AG_MoogooOomNmgooG_Mo
oekgOomNmgooG_MooekgOomNm`04Ool00ekgOomoo`09Ool00ekgOomoo`04Ool00ekgOomoo`04Ool2
001=Ool003Yoo`03001oogoo00aoo`03G_Moogoo01aoo`03G_Moogoo01eoo`03G_Moogoo01aoo`03
G_Moogoo01aoo`03G_Moogoo00=oo`03G_Moogoo00Yoo`03G_Moogoo009oo`0=G_MooekgOomNmgoo
G_MooekgOomNmgooG_L017oo00=NmgooOol02Woo0Ukg17oo00=NmgooOol01Goo00<007ooOol0Bgoo
000jOol00`00Oomoo`0<Ool00ekgOomoo`0LOol00ekgOomoo`0MOol00ekgOomoo`0LOol00ekgOomo
o`0LOol01UkgOol2=`8gOomNm`aoo`03G_Moogoo009oo`0<G_MoogooG_MooekgOomNmgooG_Mooekg
0Woo00=NmgooOol00Woo00=NmgooOol02goo00ENmgooOomooekg00Moo`03001oogoo04]oo`00>Woo
00<007ooOol037oo00=NmgooOol077oo00=NmgooOol07Goo00=NmgooOol077oo00=NmgooOol077oo
00ENmgoo0SL2=ekg00eoo`03G_Moogoo009oo`0<G_MoogooG_MooekgOomNmgooG_Mooekg0Woo00=N
mgooOol00Woo00=NmgooOol037oo00ANmgooOomNm`Moo`03001oogoo04]oo`00>Woo00<007ooOol0
37oo00=NmgooOol077oo00=NmgooOol07Goo00=NmgooOol077oo00=NmgooOol077oo00ANmgooOomN
m`eoo`03G_Moogoo00=oo`0<G_MoogooG_MooekgOomNmgooG_Mooekg0Woo00=NmgooOol00goo00=N
mgooOol037oo00=NmgooG_L01goo00<007ooOol0Bgoo000jOol00`00Oomoo`0<Ool00ekgOomoo`0L
Ool00ekgOomoo`0MOol00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomNm`0>Ool00ekgOomoo`02
Ool03EkgOomoogooG_MooekgOomNmgooG_Mooekg00=oo`03G_Moogoo009oo`03G_Moogoo00eoo`9N
m`Moo`03001oogoo04]oo`00>Woo00<007ooOol037oo00=NmgooOol07Goo00=NmgooOol077oo00=N
mgooOol077oo00=NmgooOol077oo0Ukg3Woo00=NmgooOol00goo00ANmgooOomNm`9oo`05G_Mooekg
OomNm`02Ool015kgOomooekg1Goo00=NmgooOol03Goo0Ukg1Woo00<007ooOol0Bgoo000jOol00`00
Oomoo`0<Ool00ekgOomoo`0MOol00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0KOol00ekg
0YL2U`0>Ool00ekgOomoo`03Ool015kgOomooekg0Woo00ENmgooG_Mooekg009oo`04G_MoogooG_L6
Ool00ekgOomoo`0<Ool00ekgOomNm`05Ool00`00Oomoo`1;Ool003Yoo`03001oogoo00aoo`03G_Mo
ogoo01eoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01Yoo`04G_Moo`:G0YL=Ool00ekg
Oomoo`03Ool01EkgOomoogooG_L00Woo00ENmgooG_Mooekg009oo`05G_MoogooOomNm`05Ool00ekg
Oomoo`0<Ool015kgOomooekg17oo00<007ooOol0Bgoo000jOol00`00Oomoo`0<Ool00ekgOomoo`0M
Ool00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0IOol015kgOomooekg3Woo00=NmgooOol0
0goo00ENmgooOomooekg009oo`05G_MooekgOomNm`02Ool01EkgOomoogooG_L01Woo00=NmgooOol0
2goo00ENmgooOomooekg00=oo`03001oogoo04]oo`00>Woo0P003Goo00=NmgooOol07Goo00=Nmgoo
Ool077oo00=NmgooOol077oo00=NmgooOol067oo00=NmgooOol00P;g3Goo00=NmgooOol017oo00EN
mgooOomooekg009oo`05G_MooekgOomNm`02Ool01EkgOomoogooG_L01Woo00=NmgooOol02goo00=N
mgooOol00Woo0Ukg0P00CGoo000jOol00`00Oomoo`0<Ool00ekgOomoo`0MOol00ekgOomoo`0LOol0
0ekgOomoo`0LOol00ekgOomoo`0FOol2G_L3Ool20_L00ekgOomoo`0:Ool00ekgOomoo`04Ool015kg
Oomooekg0Woo00ANmgooOomNm`9oo`04G_MoogooG_L3Ool00ekgOomoo`04Ool00ekgOomoo`09Ool0
0ekgOomoo`05Ool00ekg001oo`1<Ool003Yoo`03001oogoo00eoo`03G_Moogoo01aoo`03G_Moogoo
01aoo`03G_Moogoo01aoo`03G_Moogoo01Eoo`03G_Moogoo00Eoo`03G_Moogoo00Uoo`03G_Moogoo
00Aoo`05G_MoogooOomNm`02Ool015kgOomooekg0Woo00ANmgooOomNm`=oo`03G_Moogoo00Aoo`03
G_Moogoo00Uoo`03G_Moogoo00Ioo`03G_Moogoo04]oo`00>Woo00<007ooOol03Goo00=NmgooOol0
77oo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol057oo00=NmgooOol00goo0P;d00=ooekg
Ool02Goo00=NmgooOol01Goo00ENmgooOomooekg009oo`04G_MoogooG_L2Ool015kgOomooekg0goo
00=NmgooOol01Goo00=NmgooOol027oo00=NmgooOol01Woo00<007ooOol0Bgoo000jOol00`00Oomo
o`0=Ool00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0COol00ekgOomo
o`04Ool20_@00gooG_Moo`09Ool00ekgOomoo`05Ool01EkgOomoogooG_L00Woo00ANmgooOomNm`9o
o`04G_MoogooG_L4Ool00ekgOomoo`04Ool00ekgOomoo`08Ool00ekgOomoo`06Ool00`00Oomoo`1;
Ool003Yoo`03001oogoo00eoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Mo
ogoo019oo`03G_Moogoo00Qoo`03G_Moogoo00Moo`03G_Moogoo00Eoo`03G_Moogoo009oo`04G_Mo
ogooG_L2Ool015kgOomooekg0Woo00=NmgooOol00Woo00=NmgooOol01Goo00=NmgooOol01goo00=N
mgooOol01Woo00<007ooOol0Bgoo000jOol00`00Oomoo`0=Ool00ekgOomoo`0LOol00ekgOomoo`0L
Ool00ekgOomoo`0LOol00ekgOomoo`0AOol00ekgOomoo`05Ool20_42Ool00ekgOomoo`07Ool00ekg
Oomoo`05Ool00ekgOomoo`02Ool015kgOomooekg0Woo00ANmgooOomNm`9oo`03G_Moogoo009oo`03
G_Moogoo00Ioo`03G_Moogoo00Ioo`03G_Moogoo00Ioo`03001oogoo04]oo`00>Woo00<007ooOol0
3Goo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol07Goo00=NmgooOol03Woo0Ukg27oo0P;a
0Woo00=NmgooOol01Woo00=NmgooOol01Woo00ENmgooOomooekg00=oo`04G_MoogooG_L2Ool01Ekg
OomoogooG_L00goo00=NmgooOol01Woo00=NmgooOol01Woo00=NmgooOol01Woo00<007ooOol0Bgoo
000jOol00`00Oomoo`0=Ool00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0MOol00ekgOomo
o`0=Ool00ekgOomoo`07Ool20^h3Ool00ekgOomoo`06Ool00ekgOomoo`05Ool00ekgOomoo`02Ool0
1EkgOomoogooG_L00Woo00ANmgooOomNm`=oo`03G_Moogoo009oo`03G_Moogoo00Ioo`03G_Moogoo
00Eoo`03G_Moogoo00Ioo`03001oogoo04]oo`00>Woo00<007ooOol03Goo00=NmgooOol077oo00=N
mgooOol077oo00=NmgooOol07Goo00=NmgooOol037oo00=NmgooOol027oo0P;^0goo00=NmgooOol0
1Goo00=NmgooOol01Woo00=NmgooOol00Woo00ENmgooOomooekg009oo`04G_MoogooG_L3Ool00ekg
Oomoo`02Ool00ekgOomoo`06Ool00ekgOomoo`05Ool00ekgOomoo`06Ool00`00Oomoo`1;Ool003Yo
o`8000ioo`03G_Moogoo01aoo`03G_Moogoo01aoo`03G_Moogoo01eoo`03G_Moogoo00]oo`03G_Mo
ogoo00Qoo`82j`Eoo`03G_Moogoo00Aoo`03G_Moogoo00Ioo`03G_Moogoo009oo`06G_L0=`0gOomN
mgoo0P2G0Woo00ENmgooOomooekg00Aoo`03G_Moogoo00Moo`03G_Moogoo00=oo`03G_Moogoo00Io
o`8004eoo`00>Woo00<007ooOol03Goo00=NmgooOol077oo00=NmgooOol077oo00=NmgooOol07Goo
00=NmgooOol02Woo00=NmgooOol02Goo0P;[1Goo00=NmgooOol00goo00=NmgooOol01Woo00=Nmgoo
Ool00goo00INm`0g03MooekgOol209L2Ool01EkgOomoogooG_L01Goo00=NmgooOol01Woo00=Nmgoo
Ool00goo00=NmgooOol01goo00<007ooOol0Bgoo000jOol00`00Oomoo`0=Ool00ekgOomoo`0LOol0
0ekgOomoo`0LOol00ekgOomoo`0MOol00ekgOomoo`09Ool00ekgOomoo`09Ool20^P6Ool00ekgOomo
o`03Ool00ekgOomoo`06Ool00ekgOomoo`02Ool201L3Ool01EkgOomooekgOol00P3g17oo00=Nmgoo
Ool00Woo00=NmgooOol01goo00=NmgooOol00Woo00=NmgooOol01goo00<007ooOol0Bgoo000jOol0
0`00Oomoo`0=Ool00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0MOol00ekgOomoo`07Ool2
G_L;Ool20^D00`;XOomoo`04Ool00ekgOomoo`02Ool00ekgOomoo`07Ool01EkgOomoogoo:1L00W`0
0Woo00INmgooOomooekgOol20?L01EkgOomoogooG_L017oo00=NmgooOol01goo00=NmgooOol00Woo
00=NmgooOol01goo00<007ooOol0Bgoo000jOol00`00Oomoo`0=Ool00ekgOomoo`0LOol00ekgOomo
o`0LOol00ekgOomoo`0MOol00ekgOomoo`06Ool00ekgOomoo`0;Ool20^D7Ool01EkgOomoogooG_L0
2Goo00=NmgooOol00Woo00<X5g`0O0000Woo00ENmgooOomooekg00=oo`05G_MoogooOomNm`05Ool0
0ekgOomoo`07Ool01EkgOomoogooG_L02Goo00<007ooOol0Bgoo000jOol00`00Oomoo`0=Ool00ekg
Oomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0MOol00ekgOomoo`05Ool00ekgOomoo`0;Ool20^48
Ool01EkgOomoogooG_L02Goo00=NmgooOol00Woo0S@G0goo00ENmgooOomooekg00=oo`05G_L1M`5g
OomNm`05Ool00ekgOomoo`08Ool015kgOomooekg2Goo00<007ooOol0Bgoo000jOol00`00Oomoo`0=
Ool00ekgOomoo`0LOol00ekgOomoo`0LOol00ekgOomoo`0MOol00ekgOomoo`04Ool00ekgOomoo`0<
Ool20^49Ool00ekgOomNm`0:Ool00ekgOomoo`03Ool01EkgOomoogooG_L00goo00ENmgooOomooekg
0081M`03OomNmgoo00Aoo`03G_Moogoo00Qoo`03G_Mooekg00Yoo`03001oogoo04]oo`00>Woo00<0
07ooOol03Goo00=NmgooOol077oo00=NmgooOol07Goo00=NmgooOol077oo00=NmgooOol00goo00=N
mgooOol067oo00=NmgooG_L02Goo00ANmgooOomoo`905`03OomNmgoo009oo`05G_MoogooOomNm`03
Ool00ekgOomoo`020ML6Ool00ekgOomoo`08Ool2G_L:Ool00`00Oomoo`1;Ool0039oo`D000=oo`03
001oogoo00eoo`03G_Moogoo01aoo`03G_Moogoo01eoo`03G_Moogoo01aoo`04G_MoogooOol2G_LK
Ool2G_L:Ool015kgOomoogoo0T0G00=NmgooOol00Woo00ENmgooOomooekg00=oo`03G_Moogoo0081
e`03G_Moogoo00=oo`03G_Moogoo00Qoo`9Nm`Yoo`03001oogoo04]oo`00=7oo00<007ooOol00goo
00<007ooOol03Goo00=NmgooOol077oo00=NmgooOol07Goo00=NmgooOol077oo00ANmgooOomNmaeo
o`9Nm`Yoo`03G_Moogoo00=oo`03G_Moogoo009oo`05G_MoogooOomNm`03Ool00ekgOomoo`02Ool2
0SL4Ool00ekgOomoo`09Ool00ekgOomoo`08Ool00`00Oomoo`1;Ool003Aoo`03001oogoo00=oo`80
00ioo`03G_Moogoo01aoo`03G_Moogoo01eoo`03G_Moogoo01aoo`03G_Mooekg01ioo`03G_Moogoo
00Uoo`04G_Mood`GC1L2Ool00ekgOomoo`02Ool01EkgOomoogooG_L00goo00=NmgooOol00Woo0P8g
1Goo00=NmgooOol027oo00=NmgooOol01Woo0`00CGoo000dOol00`00Oomoo`03Ool00`00Oomoo`0=
Ool00ekgOomoo`0LOol00ekgOomoo`0MOol00ekgOomoo`0LOol2G_LOOol2G_L9Ool00ekgOomoo`02
C1L2Ool00ekgOomoo`02Ool01EkgOomoogooG_L00goo00=NmgooOol00Woo00ANmgoo0YL2U`=oo`03
G_Moogoo00Moo`03G_Mooekg00Uoo`03001oogoo04]oo`00=7oo00<007ooOol00goo00<007ooOol0
3Goo00=NmgooOol077oo00=NmgooOol07Goo00=NmgooOol077oo00=NmgooOol07Goo00=NmgooG_L0
2Goo00=NmgooOol017oo00=NmgooOol00Woo00ENmgooOomooekg00=oo`03G_Moogoo009oo`04G_Mo
o`:G0YL3Ool00ekgOomoo`07Ool015kgOomooekg27oo00<007ooOol0Bgoo000cOol20005Ool00`00
Oomoo`0=Ool00ekgOomoo`0LOol00ekgOomoo`0MOol00ekgOomoo`0KOol00ekgOomNm`0NOol00ekg
OomNm`09Ool00ekgOomoo`03Ool00ekgOomoo`03Ool01EkgOomoogooG_L00goo00=NmgooOol00goo
00ANmgoo0_L2m`=oo`03G_Moogoo00Ioo`04G_MoogooG_L8Ool00`00Oomoo`1;Ool003Yoo`03001o
ogoo00eoo`03G_Moogoo01aoo`03G_Moogoo01eoo`03G_Moogoo01Uoo`9Nm`9oo`03G_Moogoo01]o
o`04G_MoogooG_L8Ool00ekgOomoo`02F1L2Ool00ekgOomoo`03Ool01EkgOomoogooG_L00goo00=N
mgooOol00goo00ANmgoo0_L2m`=oo`03G_Moogoo00Ioo`05G_MoogooOomNm`07Ool00`00Oomoo`1;
Ool003Yoo`03001oogoo00eoo`03G_Moogoo01aoo`03G_Moogoo01eoo`03G_Moogoo01Qoo`03G_Mo
ogoo009oo`03G_Moogoo01Yoo`05G_MoogooOomNm`08Ool00ekgOomoo`02F1L2Ool00ekgOomoo`02
Ool00ekgOomoo`02Ool00ekgOomoo`02Ool00ekgOomoo`02Ool015kgOomoogoo0P;d00=ooekgOol0
1goo00ENmgooOomooekg00Moo`03001oogoo04]oo`00>Woo00<007ooOol03Goo00=NmgooOol077oo
00=NmgooOol07Goo00=NmgooOol05goo00=NmgooOol00goo00=NmgooOol06Woo00=NmgooOol00Woo
00=NmgooOol01Goo00=NmgooOol017oo00=NmgooOol00Woo00=NmgooOol00Woo00=NmgooOol00Woo
00=NmgooOol00Woo00ANmgooOomoo`82m09oo`03G_Moogoo00Aoo`03G_Moogoo00=oo`03G_Moogoo
00Aoo`03001oogoo04]oo`00>Woo00<007ooOol03Goo00=NmgooOol077oo00=NmgooOol07Goo00=N
mgooOol05Woo00=NmgooOol017oo00=NmgooOol06Goo00=NmgooOol00goo00=NmgooOol017oo00=N
mgooOol01Goo00=NmgooOol00Woo00=NmgooOol00Woo00=NmgooOol00Woo00=NmgooOol00Woo00=N
mgooOol00Woo0P;a00=ooekgOol01Goo00=NmgooOol00goo00=NmgooOol017oo00<007ooOol0Bgoo
000jOol00`00Oomoo`0=Ool00ekgOomoo`0MOol00ekgOomoo`0LOol00ekgOomoo`0EOol00ekgOomo
o`05Ool00ekgOomoo`0IOol00ekgOomoo`03Ool00ekgOomoo`04Ool015kgOomL5E`E0goo00=Nmgoo
Ool00goo00=NmgooOol00Woo00=NmgooOol00Woo00=NmgooOol00goo00ANmgooOomoo`82l@03OomN
mgoo00Eoo`03G_Moogoo00Aoo`03G_Moogoo00=oo`03001oogoo04]oo`00>Woo0P003Woo00=Nmgoo
Ool07Goo00=NmgooOol077oo00=NmgooOol04goo0Ukg27oo00=NmgooOol067oo00=NmgooOol017oo
00=NmgooOol017oo00ANmgooG1EL5@=oo`03G_Moogoo00=oo`03G_Moogoo009oo`03G_Moogoo009o
o`03G_Moogoo00=oo`03G_Moogoo00=oo`82kP03G_Moogoo00=oo`03G_Moogoo00Aoo`03G_Moogoo
009oo`8004eoo`00>Woo00<007ooOol03Goo00=NmgooOol07Goo00=NmgooOol077oo00=NmgooOol0
4Woo00=NmgooOol027oo00=NmgooOol067oo00=NmgooOol01Goo00=NmgooOol00Woo00=NmgooOol0
1Goo00=NmgooOol00goo00=NmgooOol00Woo00=NmgooOol00Woo00=NmgooOol00goo00=NmgooOol0
0goo0P;^00=NmgooOol00goo00=NmgooOol01Goo00=NmgooOol00Woo00<007ooOol0Bgoo000jOol0
0`00Oomoo`0=Ool00ekgOomoo`0MOol00ekgOomoo`0LOol00ekgOomoo`0AOol00ekgOomoo`0:Ool0
0ekgOomoo`0FOol00ekgOomoo`06Ool00ekgOomoo`02Ool00ekgOomoo`05Ool00ekgOomoo`03Ool0
0ekgOomoo`02Ool00ekgOomoo`02Ool00ekgOomoo`03Ool00ekgOomoo`04Ool20^/4Ool00ekgOomo
o`07Ool01EkgOomoogoo0000CGoo000jOol00`00Oomoo`0=Ool00ekgOomoo`0MOol00ekgOomoo`0L
Ool00ekgOomoo`0@Ool00ekgOomoo`0;Ool00ekgOomoo`0FOol00ekgOomoo`06Ool00ekgOomoo`02
Ool015kgOomL4U`B17oo00=NmgooOol00goo00=NmgooOol00Woo00=NmgooOol00Woo00=NmgooOol0
0goo00=NmgooOol017oo0P;[17oo00=NmgooOol01goo00ENmgooOomoo`0004eoo`00>Woo00<007oo
Ool03Goo00=NmgooOol07Goo00=NmgooOol077oo00=NmgooOol03goo00=NmgooOol037oo00=Nmgoo
Ool05Goo00=NmgooOol027oo00ANmgooOomNm`9oo`9L4PAoo`03G_Moogoo00=oo`03G_Moogoo009o
o`03G_Moogoo009oo`03G_Moogoo00=oo`03G_Moogoo00Eoo`82j0=oo`03G_Moogoo00Qoo`04G_Mo
ogoo001=Ool003Yoo`03001oogoo00eoo`03G_Moogoo01eoo`03G_Moogoo01aoo`03G_Moogoo00io
o`03G_Moogoo00eoo`03G_Moogoo01Aoo`03G_Moogoo00Uoo`04G_MoogooG_L7Ool00ekgOomoo`04
Ool00ekgOomoo`02Ool00ekgOomoo`02Ool00ekgOomoo`04Ool00ekgOomoo`04Ool20^P3Ool00ekg
Oomoo`08Ool015kgOomoo`00CGoo000jOol00`00Oomoo`0=Ool00ekgOomoo`0MOol00ekgOomoo`0M
Ool00ekgOomoo`0;Ool2G_L@Ool00ekgOomoo`0DOol00ekgOomoo`09Ool015kgOomooekg1goo00=N
mgooOol017oo00=NmgooOol00Woo00=NmgooOol00Woo00=NmgooOol017oo00=NmgooOol01Goo0P;U
0Woo00=NmgooOol02Goo00=Nmgoo0000CGoo000jOol00`00Oomoo`0=Ool00ekgOomoo`0MOol00ekg
Oomoo`0MOol00ekgOomoo`0:Ool00ekgOomoo`0@Ool00ekgOomoo`0COol00ekgOomoo`0:Ool015kg
OomNmgoo0U`?1Goo00=NmgooOol017oo00=NmgooOol00Woo00=NmgooOol00Woo00=NmgooOol017oo
00=NmgooOol01Goo0P;U00=ooekgOol02goo00=Nmgoo0000CGoo000jOol00`00Oomoo`0=Ool00ekg
Oomoo`0MOol00ekgOomoo`0MOol00ekgOomoo`09Ool00ekgOomoo`0AOol00ekgOomoo`0COol00ekg
Oomoo`0;Ool2G_L00gooG0mL3`05Ool00ekgOomoo`03Ool00ekgOomoo`03Ool00ekgOomoo`03Ool0
0ekgOomoo`03Ool00ekgOomoo`06Ool20^400ekgOomoo`0;Ool00ekg001oo`1<Ool003Yoo`03001o
ogoo00eoo`03G_Moogoo01eoo`03G_Moogoo01eoo`03G_Moogoo00Qoo`03G_Moogoo019oo`03G_Mo
ogoo019oo`03G_Moogoo00aoo`9Nm`Qoo`03G_Moogoo00=oo`03G_Moogoo00=oo`03G_Moogoo00=o
o`03G_Moogoo00=oo`03G_Moogoo00Ioo`82h@03G_Moogoo00]oo`03G_L007oo04aoo`00>Woo0P00
3Woo00=NmgooOol07Goo00=NmgooOol07Goo00=NmgooOol01goo00=NmgooOol057oo00=NmgooOol0
4Goo00=NmgooOol037oo0Ukg1goo00=NmgooOol017oo00ANmgooOol0=`9l0003G_Moogoo00=oo`03
G_Moogoo00Aoo`03G_Moogoo00Ioo`9Nm`eoo`03001Nmgoo04aoo`00>Woo00<007ooOol03Woo00=N
mgooOol077oo00=NmgooOol07Goo00=NmgooOol01Goo0Ukg5goo00=NmgooOol047oo00=NmgooOol0
3Goo0Ukg0U`;1Goo00=NmgooOol017oo00ANmgoo09L0U`9l0003G_Moogoo00=oo`03G_Moogoo00Ao
o`03G_Moogoo00Ioo`03G_Moogoo00eoo`03001oogoo04]oo`00>Woo00<007ooOol03Woo00=Nmgoo
Ool077oo00=NmgooOol07Goo00=NmgooOol017oo00=NmgooOol05goo00=NmgooOol047oo00=Nmgoo
Ool03Goo0Ukg0U`;1Goo00=NmgooOol017oo00ANmgoo09L0U`8d5`03@1Moogoo00=oo`03G_Moogoo
00Aoo`03G_Moogoo00Ioo`03G_Moogoo00eoo`03001oogoo04]oo`00>Woo00<007ooOol03Woo00=N
mgooOol077oo00=NmgooOol07Goo00=NmgooOol00goo00=NmgooOol067oo00=NmgooOol03goo00=N
mgooOol03Woo0Ukg1goo00=NmgooOol017oo00=NmgooOol00Woo0T0G1Goo00=NmgooOol017oo00=N
mgooOol01Goo00=NmgooG_L03Woo00<007ooOol0Bgoo000jOol00`00Oomoo`0>Ool00ekgOomoo`0L
Ool00ekgOomoo`0MOol00ekgOomoo`02Ool00ekgOomoo`0IOol00ekgOomoo`0?Ool00ekgOomoo`0=
Ool015kgOomL25`81Woo00=NmgooOol017oo00=NmgooOol00goo0T`G17oo00=NmgooOol017oo00=N
mgooOol01Goo00=NmgooG_L03Woo00<007ooOol0Bgoo000jOol00`00Oomoo`0>Ool00ekgOomoo`0M
Ool00ekgOomoo`0LOol01EkgOomoogooG_L077oo00=NmgooOol03Woo00=NmgooOol03Woo00ANmgoo
G0QL20Ioo`03G_Moogoo00Aoo`03G_L0m`3g00=oo`9<5`Aoo`03G_Moogoo00Aoo`03G_Moogoo00Eo
o`03G_Mooekg00ioo`03001oogoo04]oo`00>Woo00<007ooOol03Woo00=NmgooOol07Goo00=Nmgoo
Ool077oo00ANmgooOomNmaeoo`03G_Moogoo00eoo`03G_Moogoo00moo`04G_MoogooG_L5Ool00ekg
Oomoo`05Ool00ekg0?L0m`03Ool2F1L4Ool00ekgOomoo`05Ool00ekgOomoo`03Ool01EkgOomoogoo
G_L03Goo00<007ooOol0Bgoo000jOol00`00Oomoo`0>Ool00ekgOomoo`0MOol00ekgOomoo`0LOol3
G_LNOol00ekgOomoo`0=Ool00ekgOomoo`0>Ool01EkgOomoogooG_L01Goo00=NmgooOol01Goo00=N
mgooOol00goo0UPG17oo00=NmgooOol01Goo00=NmgooOol00goo00ENmgooOomooekg00eoo`03001o
ogoo04]oo`00>Woo00<007ooOol03Woo00=NmgooOol07Goo00=NmgooOol077oo00=NmgooOol07goo
00=NmgooOol02goo00=NmgooOol03goo00ENmgooG0EL1Ekg00Eoo`03G_Moogoo00Eoo`03G_Moogoo
00=oo`03G_Moogoo00=oo`03G_Moogoo00Eoo`03G_Moogoo00=oo`05G_MoogooOomNm`0=Ool00`00
Oomoo`1;Ool003Yoo`03001oogoo00ioo`03G_Moogoo01eoo`03G_Moogoo01]oo`9Nmb5oo`03G_Mo
ogoo00]oo`03G_Moogoo00moo`06G_Mooe`5G0Eooekg17oo00=NmgooOol01Goo0P5g17oo00=Nme`E
G1D00goo00=NmgooOol01Goo00=NmgooOol00Woo00=NmgooOol00goo00=NmgooOol02Woo00<007oo
Ool0Bgoo000jOol2000?Ool00ekgOomoo`0MOol00ekgOomoo`0JOol015kgOomooekg87oo00=Nmgoo
Ool02Woo00=NmgooOol03goo00=NmgooOol00goo00=NmgooOol00Woo00=NmgooOol017oo00=Nm`5g
0GL017oo00=Nme`EG1D017oo00=NmgooOol017oo00=NmgooOol00Woo00=NmgooOol00goo00=Nmgoo
Ool02Goo0P00CGoo000jOol00`00Oomoo`0>Ool00ekgOomoo`0MOol00ekgOomoo`0IOol01EkgOomo
ogooG_L087oo00=NmgooOol02Woo00=NmgooOol03goo00ANmgooG09L0P=oo`04G_MoogooG_L7Ool0
0ekgOomoo`04Ool00ekgOomoo`04Ool00ekgOomoo`05Ool015kgOomooekg1Woo00=NmgooOol02Woo
00<007ooOol0Bgoo000jOol00`00Oomoo`0>Ool00ekgOomoo`0MOol00ekgOomoo`0GOol2G_L4Ool0
0ekgOomoo`0NOol00ekgOomoo`09Ool00ekgOomoo`0@Ool015kgOomL0U`20goo00ANmgooOomNm`Mo
o`03G_Moogoo00Aoo`04G_Mooe`BG183Ool00ekgOomoo`05Ool015kgOomooekg1goo00=NmgooOol0
2Goo00<007ooOol0Bgoo000jOol00`00Oomoo`0>Ool00ekgOomoo`0MOol00ekgOomoo`0FOol00ekg
Oomoo`04Ool00ekgOomoo`0NOol00ekgOomoo`09Ool00ekgOomoo`0?Ool00ekgOomoo`06Ool00ekg
OomNm`07Ool20ML5Ool015kgOomL4U`B0goo00=NmgooOol01Goo00=NmgooG_L027oo00=NmgooOol0
2Goo00<007ooOol0Bgoo000jOol00`00Oomoo`0>Ool00ekgOomoo`0MOol00ekgOomoo`0EOol00ekg
Oomoo`05Ool00ekgOomoo`0NOol00ekgOomoo`08Ool00ekgOomoo`0@Ool015kgOomL05`01Goo00=N
mgooG_L01goo0P7G1Goo00=NmgooOol017oo00=NmgooOol01Goo00=NmgooG_L027oo00=NmgooOol0
2Goo00<007ooOol0Bgoo000jOol00`00Oomoo`0>Ool00ekgOomoo`0MOol00ekgOomoo`0DOol00ekg
Oomoo`06Ool00ekgOomoo`0OOol00ekgOomoo`07Ool00ekgOomoo`0@Ool015kgOomL05`01Woo0Ukg
1goo00=NmgooOol017oo00=NmgooOol017oo00=NmgooOol01Goo0Ukg2Woo00=NmgooOol027oo00<0
07ooOol0Bgoo000jOol00`00Oomoo`0?Ool00ekgOomoo`0LOol00ekgOomoo`0COol00ekgOomoo`07
Ool00ekgOomoo`0OOol00ekgOomoo`06Ool00ekgOomoo`0@Ool00ekgOomoo`08Ool00ekgOomoo`06
Ool00ekgOomoo`04Ool00ekgOomoo`02G0l2Ool00ekgOomoo`06Ool00ekgOomoo`08Ool00ekgOomo
o`08Ool00`00Oomoo`1;Ool003Yoo`03001oogoo00moo`03G_Moogoo01aoo`03G_Moogoo019oo`03
G_Moogoo00Qoo`03G_Moogoo01moo`03G_Moogoo00Eoo`03G_Moogoo015oo`03G_Moogoo00Qoo`9N
m`Moo`82=`Eoo`03G_Moogoo009L3`9oo`03G_Moogoo00Eoo`9Nm`Yoo`03G_Moogoo00Qoo`03001o
ogoo04]oo`00>Woo00<007ooOol03goo00=NmgooOol077oo00=NmgooOol047oo0Ukg2goo00=Nmgoo
Ool07goo00=NmgooOol01Goo00=NmgooOol04Goo00=NmgooOol027oo00=NmgooG_L01Woo0P8g1Goo
00=NmgooOol017oo00=NmgooOol017oo00=NmgooG_L02Woo00=NmgooOol027oo00<007ooOol0Bgoo
000jOol00`00Oomoo`0?Ool00ekgOomoo`0LOol00ekgOomoo`0?Ool00ekgOomoo`0<Ool00ekgOomo
o`0NOol00ekgOomoo`04Ool00ekgOomoo`0BOol00ekgOomoo`08Ool00ekgOomNm`06Ool00ekgOomo
o`04Ool015kgOomoogoo0U`;00=ooekgOol01Goo00=NmgooG_L02goo00=NmgooOol01goo00<007oo
Ool0Bgoo000jOol2000@Ool00ekgOomoo`0LOol00ekgOomoo`0>Ool00ekgOomoo`0=Ool00ekgOomo
o`0NOol00ekgOomoo`04Ool00ekgOomoo`0AOol00ekgOomoo`09Ool015kgOomooekg1Goo00=Nmgoo
Ool017oo00ANmgooOomoo`9L2`03OomNmgoo00Aoo`04G_MoogooG_L;Ool00ekgOomoo`06Ool2001=
Ool003Yoo`03001oogoo00moo`03G_Moogoo01eoo`03G_Moogoo00aoo`03G_Moogoo00ioo`03G_Mo
ogoo01ioo`03G_Moogoo00=oo`03G_Moogoo019oo`03G_Moogoo00Uoo`05G_MoogooOomNm`04Ool0
0ekgOomoo`04Ool00ekgOomoo`04Ool00ekgOomoo`02Ool01EkgOomoogooG_L02goo00=NmgooOol0
1goo00<007ooOol0Bgoo000jOol00`00Oomoo`0?Ool00ekgOomoo`0MOol00ekgOomoo`0;Ool00ekg
Oomoo`0?Ool00ekgOomoo`0NOol00ekgOomoo`03Ool00ekgOomoo`0BOol00ekgOomoo`08Ool00ekg
Oomoo`03Ool00ekgOomoo`020YL6Ool015kgOomoogoo0U`80Woo00ENmgooOomooekg00Aoo`03G_Mo
ogoo00Uoo`03G_Moogoo00Ioo`03001oogoo04]oo`00>Woo00<007ooOol03goo00=NmgooOol07Goo
00=NmgooOol02Goo0Ukg4Woo00=NmgooOol07goo00ENmgooOomooekg01Aoo`03G_Moogoo00Uoo`03
G_Moogoo00=oo`03G_Moogoo0082U`Ioo`04G_MoogooOol2G0P2Ool015kgOomooekg1Goo00=Nmgoo
Ool02Goo00=NmgooOol01Woo00<007ooOol0Bgoo000jOol00`00Oomoo`0?Ool00ekgOomoo`0MOol0
0ekgOomoo`08Ool00ekgOomoo`0BOol00ekgOomoo`0OOol01EkgOomoogooG_L057oo00=NmgooOol0
2Goo00=NmgooOol017oo00=NmgooG_L01goo00=NmgooOol01Goo00ANmgooOomNm`Eoo`03G_Moogoo
00Uoo`03G_Moogoo00Ioo`03001oogoo04]oo`00>Woo00<007ooOol03goo00=NmgooOol07Goo00=N
mgooOol01goo00=NmgooOol04goo00=NmgooOol07goo00ANmgooOomNmaEoo`03G_Moogoo00Uoo`03
G_Moogoo00Eoo`9Nm`Moo`03G_Moogoo009oo`9L1@04OomNmgooG_L6Ool00ekgOomoo`0:Ool00ekg
Oomoo`05Ool00`00Oomoo`1;Ool003Yoo`03001oogoo00moo`03G_Moogoo01eoo`03G_Moogoo00Io
o`03G_Moogoo01Aoo`03G_Moogoo01moo`04G_MoogooG_LDOol00ekgOomoo`0:Ool00ekgOomoo`06
Ool20_L6Ool00ekgOomoo`02Ool2G0D00gooG_MNm`07Ool00ekgOomoo`0:Ool00ekgOomoo`05Ool0
0`00Oomoo`1;Ool003=oo`<000Aoo`03001oogoo00moo`03G_Moogoo01eoo`03G_Moogoo00Eoo`03
G_Moogoo01Ioo`03G_Moogoo01ioo`03G_Mooekg01Eoo`03G_Moogoo00Uoo`03G_Moogoo00Moo`82
m`Ioo`03G_Moogoo00Aoo`9Nm`Uoo`03G_Moogoo00Uoo`03G_Moogoo00Eoo`03001oogoo04]oo`00
<goo00<007ooOol017oo00<007ooOol03goo00=NmgooOol07Goo00=NmgooOol017oo00=NmgooOol0
5goo00=NmgooOol07Woo0Ukg5Woo00=NmgooOol02Goo00=NmgooOol01goo00ANmgooG_MNm`Aoo`03
G_Moogoo009oo`9Nm`03OomNmgoo00Qoo`03G_Moogoo00Yoo`03G_Moogoo00Aoo`03001oogoo04]o
o`00=7oo00<007ooOol00goo0P0047oo00=NmgooOol07Goo00=NmgooOol00Woo0Ukg6Woo00=Nmgoo
Ool07goo00=NmgooOol04goo00=NmgooOol02Woo00=NmgooOol01goo0P;d0Woo2Ekg0U`200=ooekg
Ool027oo00=NmgooOol02Woo00=NmgooOol00Woo0`00CGoo000dOol00`00Oomoo`03Ool00`00Oomo
o`0?Ool00ekgOomoo`0MOol01EkgOomoogooG_L077oo00=NmgooOol07Woo0Ukg5Goo00=NmgooOol0
2Woo00=NmgooOol01goo0P;d1Woo00=NmgooOol00Woo0U`200=ooekgOol027oo00=NmgooOol02Woo
00=NmgooOol017oo00<007ooOol0Bgoo000cOol00`00Ool00004Ool00`00Oomoo`0@Ool00ekgOomo
o`0LOol015kgOomooekg7Goo00=NmgooOol07Woo0Ukg5Goo00=NmgooOol02Woo00=NmgooOol01goo
00=NmgooOol01Goo00=NmgooOol01Goo00=NmgooOol01goo00=NmgooOol02goo00=NmgooOol00goo
00<007ooOol0Bgoo000dOol00`00Oomoo`03Ool00`00Oomoo`0@Ool00ekgOomoo`0LOol00ekgOomN
m`0NOol00ekgOomoo`0MOol00ekgOomNm`0DOol00ekgOomoo`0;Ool00ekgOomoo`07Ool00ekgOomo
o`05Ool00ekgOomoo`03Ool2G0000ekgOomoo`07Ool00ekgOomoo`0;Ool00ekgOomoo`03Ool00`00
Oomoo`1;Ool003Yoo`03001oogoo011oo`03G_Moogoo01aoo`9Nmamoo`03G_Moogoo01eoo`03G_Mo
oekg01Aoo`03G_Moogoo00Yoo`03G_Moogoo00Moo`82l@Moo`03G_Moogoo00=oo`9L0003G_Moogoo
00Qoo`03G_Moogoo00Yoo`03G_Moogoo00=oo`03001oogoo04]oo`00>Woo00<007ooOol047oo00=N
mgooOol06goo0ekg7goo00=NmgooOol077oo00ENmgooOomooekg01=oo`03G_Moogoo00Yoo`03G_Mo
ogoo00Moo`82l@Moo`03G_Moogoo00Ioo`03G_Moogoo00Moo`03G_Moogoo00]oo`03G_Moogoo009o
o`03001oogoo04]oo`00>Woo00<007ooOol047oo00=NmgooOol06Woo00ANmgooOomNmamoo`03G_Mo
ogoo01aoo`05G_MoogooOomNm`0COol00ekgOomoo`0:Ool00ekgOomoo`07Ool00ekgOomoo`06Ool0
0ekgOomoo`06Ool00ekgOomoo`07Ool00ekgOomoo`0;Ool00ekgOomoo`02Ool00`00Oomoo`1;Ool0
03Yoo`03001oogoo011oo`03G_Moogoo01Uoo`05G_MoogooOomNm`0POol00ekgOomoo`0JOol00ekg
Oomoo`02Ool00ekgOomoo`0@Ool00ekgOomoo`0;Ool00ekgOomoo`07Ool00ekgOomoo`06Ool00ekg
Oomoo`06Ool00ekgOomoo`07Ool00ekgOomoo`0;Ool00ekgOomoo`02Ool00`00Oomoo`1;Ool003Yo
o`03001oogoo011oo`03G_Moogoo01Qoo`03G_Moogoo009oo`03G_Moogoo01ioo`03G_Moogoo01Uo
o`03G_Moogoo00=oo`03G_Moogoo011oo`03G_Moogoo00]oo`03G_Moogoo00Moo`82kPMoo`03G_Mo
ogoo00Ioo`03G_Moogoo00Moo`03G_Moogoo00aoo`05G_MoogooOol0001=Ool003Yoo`03001oogoo
011oo`03G_Moogoo01Moo`03G_Moogoo00=oo`03G_Moogoo01ioo`03G_Moogoo01Uoo`03G_Moogoo
00=oo`03G_Moogoo011oo`03G_Moogoo00Yoo`03G_Moogoo00Qoo`82kPMoo`03G_Moogoo00Ioo`03
G_Moogoo00Qoo`03G_Moogoo00]oo`05G_MoogooOol0001=Ool003Yoo`80015oo`03G_Moogoo01Io
o`03G_Moogoo00Aoo`03G_Moogoo01ioo`03G_Moogoo01Qoo`03G_Moogoo00Aoo`03G_Moogoo00mo
o`03G_Moogoo00]oo`03G_Moogoo00Qoo`03G_Moogoo00Ioo`03G_Moogoo00Ioo`03G_Moogoo00Qo
o`03G_Moogoo00]oo`03G_Moogoo008004eoo`00>Woo00<007ooOol047oo00=NmgooOol057oo0Ukg
1goo00=NmgooOol07Woo00=NmgooOol067oo00=NmgooOol01Goo00=NmgooOol03Woo00=NmgooOol0
2goo00=NmgooOol027oo0P;[1goo00=NmgooOol01Woo00=NmgooOol027oo00=NmgooOol02goo00EN
mgooOomoo`0004eoo`00>Woo00<007ooOol047oo00=NmgooOol04goo00=NmgooOol01goo00=Nmgoo
Ool07Woo00=NmgooOol05goo00=NmgooOol01Woo00=NmgooOol03Woo00=NmgooOol02goo00=Nmgoo
Ool027oo0P;[1goo00=NmgooOol01Woo00=NmgooOol027oo00=NmgooOol037oo00ANmgooOol004eo
o`00>Woo00<007ooOol047oo00=NmgooOol04Woo00=NmgooOol027oo00=NmgooOol07Woo00=Nmgoo
Ool05goo00=NmgooOol01Woo00=NmgooOol03Goo00=NmgooOol037oo00=NmgooOol027oo00=Nmgoo
Ool01Woo00=NmgooOol01Woo00=NmgooOol027oo00=NmgooOol037oo00ANmgooOol004eoo`00>Woo
00<007ooOol047oo00=NmgooOol04Goo00=NmgooOol02Goo00=NmgooOol07Woo00=NmgooOol05Woo
00=NmgooOol01goo00=NmgooOol03Goo00=NmgooOol037oo00=NmgooOol027oo00=NmgooOol01Woo
00=NmgooOol01Woo00=NmgooOol027oo00=NmgooOol037oo00ANmgooOol004eoo`00>Woo00<007oo
Ool047oo00=NmgooOol047oo00=NmgooOol02goo00=NmgooOol07Woo00=NmgooOol05Goo00=Nmgoo
Ool01goo00=NmgooOol03Goo00=NmgooOol02goo00=NmgooOol02Goo0P;X1goo00=NmgooOol01Woo
00=NmgooOol02Goo00=NmgooOol037oo00=Nmgoo0000CGoo000jOol00`00Oomoo`0@Ool00ekgOomo
o`0?Ool00ekgOomoo`0<Ool00ekgOomoo`0NOol00ekgOomoo`0DOol00ekgOomoo`09Ool00ekgOomo
o`0;Ool00ekgOomoo`0<Ool00ekgOomoo`09Ool20^P7Ool00ekgOomoo`06Ool00ekgOomoo`09Ool0
0ekgOomoo`0<Ool00ekgOol0001=Ool003Yoo`03001oogoo015oo`03G_Moogoo00aoo`9Nm`moo`03
G_Moogoo01ioo`03G_Moogoo01Aoo`03G_Moogoo00Uoo`03G_Moogoo00]oo`03G_Moogoo00aoo`03
G_Moogoo00Qoo`03G_Moogoo00Moo`03G_Moogoo00Moo`03G_Moogoo00Qoo`03G_Moogoo00aoo`03
G_Moo`0004eoo`00>Woo00<007ooOol04Goo00=NmgooOol02goo00=NmgooOol03goo00=NmgooOol0
7Woo00=NmgooOol04goo00=NmgooOol02Woo00=NmgooOol02goo00=NmgooOol037oo00=NmgooOol0
27oo0P;U27oo00=NmgooOol01goo00=NmgooOol027oo00=NmgooOol03Goo00=Nm`00Ool0C7oo000j
Ool00`00Oomoo`0AOol00ekgOomoo`0:Ool00ekgOomoo`0@Ool00ekgOomoo`0NOol00ekgOomoo`0B
Ool00ekgOomoo`0;Ool00ekgOomoo`0:Ool00ekgOomoo`0=Ool00ekgOomoo`08Ool20^D8Ool00ekg
Oomoo`07Ool00ekgOomoo`08Ool00ekgOomoo`0=Ool00ekg001oo`1<Ool003Yoo`80019oo`03G_Mo
ogoo00Uoo`03G_Moogoo015oo`03G_Moogoo01ioo`03G_Moogoo019oo`03G_Moogoo00aoo`03G_Mo
ogoo00Uoo`03G_Moogoo00aoo`03G_Moogoo00Uoo`03G_Moogoo00Moo`03G_Moogoo00Moo`03G_Mo
ogoo00Uoo`03G_Moogoo00aoo`03G_L007oo04aoo`00>Woo00<007ooOol04Goo00=NmgooOol027oo
00=NmgooOol04Woo00=NmgooOol07goo00=NmgooOol047oo00=NmgooOol03Goo00=NmgooOol02Goo
00=NmgooOol037oo00=NmgooOol02Goo00=NmgooOol01goo00=NmgooOol01goo00=NmgooOol02Goo
00=NmgooOol03Goo00=NmgooOol0Bgoo000jOol00`00Oomoo`0AOol00ekgOomoo`06Ool2G_LEOol0
0ekgOomoo`0OOol00ekgOomoo`0@Ool00ekgOomoo`0=Ool00ekgOomoo`08Ool00ekgOomoo`0=Ool0
0ekgOomoo`09Ool20^48Ool00ekgOomoo`07Ool00ekgOomoo`09Ool00ekgOomoo`0=Ool00ekgOomo
o`1;Ool003Yoo`03001oogoo015oo`03G_Moogoo00Eoo`03G_Moogoo01Eoo`03G_Moogoo01moo`03
G_Moogoo00moo`03G_Moogoo00ioo`03G_Moogoo00Qoo`03G_Moogoo00eoo`03G_Moogoo00Uoo`82
h@Qoo`03G_Moogoo00Moo`03G_Moogoo00Uoo`03G_Moogoo00eoo`03001oogoo04]oo`00>Woo00<0
07ooOol04Goo00=NmgooOol017oo00=NmgooOol05goo00=NmgooOol07Woo00=NmgooOol03goo00=N
mgooOol03goo00=NmgooOol01goo00=NmgooOol03Goo00=NmgooOol02Goo00=NmgooOol01goo00=N
mgooOol01goo00=NmgooOol02Goo00=NmgooOol03Goo00<007ooOol0Bgoo000jOol00`00Oomoo`0A
Ool00ekgOomoo`03Ool00ekgOomoo`0HOol00ekgOomoo`0NOol00ekgOomoo`0>Ool00ekgOomoo`0@
Ool00ekgOomoo`07Ool00ekgOomoo`0<Ool00ekgOomoo`0:Ool00ekgOomoo`07Ool00ekgOomoo`07
Ool00ekgOomoo`0:Ool00ekgOomoo`0<Ool00`00Oomoo`1;Ool003Yoo`03001oogoo015oo`03G_Mo
ogoo00