(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    355901,      14330]*)
(*NotebookOutlinePosition[    367868,      14633]*)
(*  CellTagsIndexPosition[    367468,      14617]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Parametric Representation of Manifolds", "Title"],

Cell["Harry G. Kwatny", "Subtitle"],

Cell["\<\
Department of Mechanical Engineering & Mechanics
Drexel University\
\>", "Subsubtitle"],

Cell[BoxData[{
    \(\(Off[General::spell];\)\), "\n", 
    \(\(Off[General::spell1];\)\)}], "Input",
  CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->"Introduction"],

Cell[TextData[{
  "Frequently in applications, important surfaces or manifolds are implicitly \
defined. It is sometimes useful to generate a parametric representation of \
these manifolds for graphing or other purposes. TSi ProPac contains functions \
useful for this purpose. The primary tools are the two functions:\n",
  StyleBox["ParametricManifold",
    FontFamily->"Courier New"],
  " and ",
  StyleBox["EquilibriumSurface\n",
    FontFamily->"Courier New"],
  StyleBox["These are are constructed using the functions\n",
    FontFamily->"Times New Roman"],
  StyleBox["ExpMap",
    FontFamily->"Courier New"],
  StyleBox[" and ",
    FontFamily->"Times New Roman"],
  StyleBox["FlowComposition",
    FontFamily->"Courier New"],
  StyleBox[
  ".\nWe will illustrate their use in the following sections. First, load the \
package:",
    FontFamily->"Times New Roman"]
}], "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< ProPac`\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Introduction"],

Cell[BoxData[
    \("\n    This is ProPac - Version 2.0\n \n ProPac has been successfully \
loaded. It contains packages\n for multibody dynamics, linear control and \
nonlinear control.\n Appropriate packages will be loaded automatically as \
required.\n Packages can be manually loaded by simply entering \
GeometricTools,\n Dynamics, LinearControl, NonlinearControl or MEXTools as \
desired.\n Once a package is loaded, enter ?GeomtricTools, ?Dynamics,\n \
?LinearControl, ?NonlinearControl, or ?MEXTools, respectively,\n to obtain a \
list of available functions. Help is also available\n in the Help Browser \
under Add-ons."\)], "Print",
  CellLabel->"From In[3]:="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Simple Examples", "Section"],

Cell[CellGroupData[{

Cell["Implicit and Parametric Representation of the Circle", "Subsection",
  CellTags->{"Implicit", "i:1"}],

Cell[TextData[{
  "The unit circle in a plane can be defined by the implicit relation \
f(x,y)=",
  Cell[BoxData[
      \(TraditionalForm\`x\^2\)]],
  "+",
  Cell[BoxData[
      \(TraditionalForm\`y\^2\)]],
  "-1=0. The circle can also be characterized parametrically by the mapping \
theta->{x,y} defined by  x=Cos[theta], y=Sin[theta]. Unfortunately, it is \
rarely possible to find a global parametric representation of a given \
implicit manifold. In such a case it is often possible to obtain a local \
representation. The function ParametricManifold does that. Define:"
}], "Text",
  TextJustification->1,
  CellTags->{"Implicit", "i:1"}],

Cell[BoxData[{
    \(\(f1 = {\((x^2 + y^2 - 1)\)};\)\), "\n", 
    \(\(var1 = {x, y};\)\)}], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"Implicit", "i:1"}],

Cell["\<\
Now, we find a local 6th order representation around the point x=1,y=0:\
\>", "Text",
  CellTags->{"Implicit", "i:1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Circ = ParametricManifold[f1, var1, {1, 0}, 6]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->{"Implicit", "i:1"}],

Cell[BoxData[
    \("1 vector fields computed."\)], "Print",
  CellLabel->"From In[6]:="],

Cell[BoxData[
    \("1 flow functions computed."\)], "Print",
  CellLabel->"From In[6]:="],

Cell[BoxData[
    \({{1 - k1\^2\/2 + k1\^4\/24 - k1\^6\/720, 
        k1 - k1\^3\/6 + k1\^5\/120}, {k1}}\)], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell[BoxData[
    \(\(Cir[k1_] := Circ[\([1]\)];\)\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->{"Implicit", "i:1"}],

Cell["and a 10th order representation:", "Text",
  CellTags->{"Implicit", "i:1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Circ1 = ParametricManifold[f1, var1, {1, 0}, 10]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->{"Implicit", "i:1"}],

Cell[BoxData[
    \("1 vector fields computed."\)], "Print",
  CellLabel->"From In[8]:="],

Cell[BoxData[
    \("1 flow functions computed."\)], "Print",
  CellLabel->"From In[8]:="],

Cell[BoxData[
    \({{1 - k1\^2\/2 + k1\^4\/24 - k1\^6\/720 + k1\^8\/40320 - 
          k1\^10\/3628800, 
        k1 - k1\^3\/6 + k1\^5\/120 - k1\^7\/5040 + 
          k1\^9\/362880}, {k1}}\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell["We can graph these representations of the circle.", "Text",
  CellTags->{"Implicit", "i:1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot[{{Cos[k1], Sin[k1]}, Circ[\([1]\)], 
        Circ1[\([1]\)]}, {k1, \(-Pi\), Pi}, 
      PlotStyle\  -> \n\ \ \ \ \ {{RGBColor[1, \ 0, \ 0], 
            Thickness[0.008]}, {\ RGBColor[0, \ 1, \ 0]}, {\ 
            RGBColor[0, \ 0, \ 1]}}]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->{"Implicit", "i:1"}],

Cell[BoxData[
    \(ParametricPlot::"ppcom" \(\(:\)\(\ \)\) 
      "Function \!\(Circ \[LeftDoubleBracket] 1 \[RightDoubleBracket]\) \
cannot be compiled; plotting will proceed with the uncompiled function."\)], \
"Message",
  CellLabel->"From In[9]:="],

Cell[BoxData[
    \(ParametricPlot::"ppcom" \(\(:\)\(\ \)\) 
      "Function \!\(Circ1 \[LeftDoubleBracket] 1 \[RightDoubleBracket]\) \
cannot be compiled; plotting will proceed with the uncompiled function."\)], \
"Message",
  CellLabel->"From In[9]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.545513 0.430678 0.309017 0.292914 [
[.11483 .29652 -6 -9 ]
[.11483 .29652 6 0 ]
[.33017 .29652 -12 -9 ]
[.33017 .29652 12 0 ]
[.76085 .29652 -9 -9 ]
[.76085 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.53301 .0161 -12 -4.5 ]
[.53301 .0161 0 4.5 ]
[.53301 .16256 -24 -4.5 ]
[.53301 .16256 0 4.5 ]
[.53301 .45547 -18 -4.5 ]
[.53301 .45547 0 4.5 ]
[.53301 .60193 -6 -4.5 ]
[.53301 .60193 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11483 .30902 m
.11483 .31527 L
s
[(-1)] .11483 .29652 0 1 Mshowa
.33017 .30902 m
.33017 .31527 L
s
[(-0.5)] .33017 .29652 0 1 Mshowa
.76085 .30902 m
.76085 .31527 L
s
[(0.5)] .76085 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.1579 .30902 m
.1579 .31277 L
s
.20097 .30902 m
.20097 .31277 L
s
.24404 .30902 m
.24404 .31277 L
s
.28711 .30902 m
.28711 .31277 L
s
.37324 .30902 m
.37324 .31277 L
s
.41631 .30902 m
.41631 .31277 L
s
.45938 .30902 m
.45938 .31277 L
s
.50244 .30902 m
.50244 .31277 L
s
.58858 .30902 m
.58858 .31277 L
s
.63165 .30902 m
.63165 .31277 L
s
.67472 .30902 m
.67472 .31277 L
s
.71778 .30902 m
.71778 .31277 L
s
.80392 .30902 m
.80392 .31277 L
s
.84699 .30902 m
.84699 .31277 L
s
.89005 .30902 m
.89005 .31277 L
s
.93312 .30902 m
.93312 .31277 L
s
.07177 .30902 m
.07177 .31277 L
s
.0287 .30902 m
.0287 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.54551 .0161 m
.55176 .0161 L
s
[(-1)] .53301 .0161 1 0 Mshowa
.54551 .16256 m
.55176 .16256 L
s
[(-0.5)] .53301 .16256 1 0 Mshowa
.54551 .45547 m
.55176 .45547 L
s
[(0.5)] .53301 .45547 1 0 Mshowa
.54551 .60193 m
.55176 .60193 L
s
[(1)] .53301 .60193 1 0 Mshowa
.125 Mabswid
.54551 .04539 m
.54926 .04539 L
s
.54551 .07469 m
.54926 .07469 L
s
.54551 .10398 m
.54926 .10398 L
s
.54551 .13327 m
.54926 .13327 L
s
.54551 .19185 m
.54926 .19185 L
s
.54551 .22114 m
.54926 .22114 L
s
.54551 .25043 m
.54926 .25043 L
s
.54551 .27973 m
.54926 .27973 L
s
.54551 .33831 m
.54926 .33831 L
s
.54551 .3676 m
.54926 .3676 L
s
.54551 .39689 m
.54926 .39689 L
s
.54551 .42618 m
.54926 .42618 L
s
.54551 .48477 m
.54926 .48477 L
s
.54551 .51406 m
.54926 .51406 L
s
.54551 .54335 m
.54926 .54335 L
s
.54551 .57264 m
.54926 .57264 L
s
.25 Mabswid
.54551 0 m
.54551 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.008 w
.11483 .30902 m
.11485 .30675 L
.11488 .30468 L
.11495 .30229 L
.11504 .30004 L
.11526 .29603 L
.11559 .29168 L
.11606 .2869 L
.11669 .28183 L
.11815 .27277 L
.12008 .26344 L
.12229 .25475 L
.12875 .23516 L
.13736 .21554 L
.14698 .19798 L
.17455 .16021 L
.20478 .12986 L
.24387 .09995 L
.28619 .07515 L
.33609 .05306 L
.36209 .044 L
.39116 .03556 L
.41696 .02946 L
.44587 .02405 L
.45968 .02198 L
.47459 .0201 L
.48754 .01877 L
.50169 .01762 L
.51001 .0171 L
.51771 .01671 L
.52508 .01643 L
.52881 .01632 L
.53292 .01623 L
.53662 .01617 L
.54001 .01613 L
.54373 .01611 L
.5456 .0161 L
.54764 .01611 L
.55111 .01613 L
.5548 .01617 L
.55829 .01623 L
.56146 .0163 L
.56802 .0165 L
.57522 .0168 L
.58975 .01765 L
.60316 .01874 L
.61566 .02001 L
.6436 .0238 L
.67312 .02926 L
.70031 .03568 L
Mistroke
.72915 .04407 L
.77905 .06291 L
.82401 .08558 L
.86668 .11386 L
.90394 .14663 L
.93247 .18043 L
.94387 .19768 L
.95409 .21639 L
.96194 .2343 L
.96762 .25088 L
.97215 .26898 L
.97392 .27901 L
.97457 .28363 L
.97514 .28853 L
.97552 .29272 L
.97569 .29495 L
.97585 .29735 L
.97597 .29955 L
.97605 .30156 L
.97611 .30348 L
.97616 .30551 L
.97619 .30772 L
.97619 .31008 L
.97616 .31231 L
.97612 .31433 L
.97604 .31671 L
.97593 .31929 L
.97563 .32396 L
.97523 .32853 L
.97469 .33342 L
.97341 .34224 L
.97138 .35268 L
.96904 .36216 L
.9624 .38254 L
.95415 .40153 L
.93284 .43709 L
.90717 .46807 L
.87575 .49704 L
.83526 .52573 L
.7924 .54902 L
.74169 .56978 L
.68949 .58508 L
.66223 .59097 L
.64666 .59374 L
.63181 .59599 L
.61807 .59775 L
.60307 .5993 L
.58939 .60041 L
.57671 .60116 L
.56963 .60147 L
Mistroke
.56298 .60169 L
.55918 .60178 L
.55569 .60185 L
.55377 .60188 L
.55167 .6019 L
.54969 .60192 L
.54785 .60193 L
.54593 .60193 L
.54385 .60193 L
.54188 .60192 L
.54008 .60191 L
.53665 .60187 L
.53303 .60181 L
.52914 .60172 L
.52551 .60162 L
.51726 .6013 L
.50988 .60093 L
.50307 .60051 L
.48769 .59928 L
.47419 .59789 L
.45994 .59609 L
.43553 .59222 L
.40902 .58683 L
.3581 .57274 L
.30667 .55276 L
.26148 .5292 L
.2193 .50026 L
.18552 .4698 L
.15958 .43902 L
.14724 .42048 L
.13735 .40249 L
.12989 .38579 L
.1236 .36782 L
.1198 .35338 L
.11812 .34512 L
.11686 .33737 L
.11597 .33024 L
.11538 .32371 L
.11514 .32011 L
.11505 .3182 L
.11496 .31618 L
.1149 .31423 L
.11486 .31246 L
.11484 .31069 L
.11483 .30902 L
Mfstroke
0 1 0 r
.5 Mabswid
.02381 .15552 m
.02715 .15599 L
.02898 .1562 L
.03071 .15636 L
.03232 .15648 L
.03406 .15657 L
.03565 .15663 L
.03711 .15667 L
.03884 .15667 L
.04047 .15665 L
.04225 .1566 L
.04417 .15651 L
.04617 .15637 L
.04808 .15621 L
.05166 .15581 L
.05521 .1553 L
.059 .15464 L
.06586 .15316 L
.08173 .14851 L
.11761 .13381 L
.15328 .11668 L
.23542 .07849 L
.32809 .04518 L
.38047 .03175 L
.40775 .0263 L
.43825 .02145 L
.45291 .01958 L
.46689 .01809 L
.47965 .01696 L
.49325 .016 L
.50028 .01561 L
.50806 .01526 L
.51514 .01502 L
.51831 .01493 L
.52179 .01485 L
.52559 .01479 L
.52766 .01476 L
.52959 .01474 L
.53306 .01472 L
.53675 .01472 L
.53884 .01472 L
.5411 .01473 L
.54324 .01475 L
.54521 .01478 L
.54894 .01484 L
.55289 .01493 L
.5601 .01514 L
.56694 .01542 L
.57976 .01612 L
.59352 .01715 L
Mistroke
.60845 .0186 L
.63507 .02203 L
.65943 .02619 L
.68819 .03241 L
.7146 .03946 L
.76188 .05568 L
.80926 .07743 L
.84873 .10099 L
.88434 .1282 L
.91735 .16123 L
.94221 .19498 L
.95328 .21476 L
.96151 .2332 L
.96792 .2519 L
.97223 .2694 L
.97386 .2786 L
.97461 .28391 L
.97516 .28877 L
.97562 .2939 L
.9758 .29659 L
.97596 .29942 L
.97606 .3019 L
.97613 .3042 L
.97618 .30673 L
.97619 .30814 L
.97619 .30942 L
.97617 .31174 L
.97613 .3139 L
.97606 .31628 L
.97595 .31882 L
.9758 .32149 L
.97563 .32401 L
.97521 .32875 L
.97419 .33725 L
.97266 .34647 L
.9705 .35648 L
.96765 .36707 L
.9611 .38588 L
.95334 .40316 L
.94322 .42141 L
.92047 .45312 L
.8893 .48545 L
.85 .51618 L
.80792 .54131 L
.76472 .56122 L
.73851 .57098 L
.71289 .57907 L
.66307 .59114 L
.63628 .59582 L
.62145 .5979 L
Mistroke
.60747 .59954 L
.59452 .6008 L
.58263 .60172 L
.56939 .6025 L
.56207 .60282 L
.55512 .60305 L
.55156 .60314 L
.54772 .60322 L
.54409 .60327 L
.54075 .6033 L
.53773 .60332 L
.53442 .60332 L
.53096 .6033 L
.52773 .60327 L
.52592 .60325 L
.52394 .60322 L
.52036 .60315 L
.51365 .60297 L
.50582 .60268 L
.49858 .60233 L
.48653 .60159 L
.47327 .60054 L
.44661 .59768 L
.41851 .59359 L
.39316 .58895 L
.33779 .57564 L
.29015 .56068 L
.24144 .54207 L
.15734 .50335 L
.12352 .48697 L
.08995 .47248 L
.08147 .46944 L
.07265 .46667 L
.06461 .46458 L
.05718 .46306 L
.05364 .46249 L
.05029 .46206 L
.04844 .46186 L
.04643 .46168 L
.04461 .46155 L
.04292 .46146 L
.04194 .46142 L
.04088 .46139 L
.03896 .46136 L
.03708 .46137 L
.03536 .46141 L
.0335 .46149 L
.03244 .46155 L
.03145 .46162 L
.02928 .46181 L
Mistroke
.02731 .46202 L
.02381 .46252 L
Mfstroke
0 0 1 r
.11405 .30699 m
.11408 .30477 L
.11414 .30275 L
.11423 .30042 L
.11434 .29822 L
.11459 .29429 L
.11496 .29003 L
.11614 .28037 L
.11766 .27146 L
.12201 .25336 L
.12846 .23435 L
.13692 .21537 L
.14655 .19794 L
.17446 .15995 L
.20694 .12779 L
.24195 .10113 L
.28251 .07701 L
.33145 .05482 L
.38162 .03813 L
.41093 .03076 L
.43812 .02535 L
.46592 .02115 L
.47927 .01959 L
.4918 .01839 L
.50543 .01737 L
.51267 .01695 L
.52044 .0166 L
.52435 .01646 L
.5286 .01633 L
.53261 .01623 L
.53633 .01617 L
.53967 .01613 L
.54335 .01611 L
.54521 .0161 L
.5472 .0161 L
.55082 .01612 L
.55439 .01616 L
.55763 .01622 L
.56137 .0163 L
.5649 .0164 L
.57118 .01662 L
.57798 .01694 L
.59339 .01792 L
.60754 .01916 L
.6362 .02267 L
.66608 .02781 L
.69157 .03346 L
.71832 .04072 L
.7646 .05684 L
.8141 .08004 L
Mistroke
.85626 .10621 L
.89253 .13553 L
.92086 .16539 L
.9347 .18357 L
.94597 .20124 L
.95457 .21737 L
.96237 .23542 L
.96849 .25387 L
.97109 .26405 L
.97303 .27359 L
.97443 .28257 L
.97535 .29076 L
.97572 .29531 L
.97588 .29787 L
.976 .30024 L
.97608 .30232 L
.97614 .3046 L
.97618 .30699 L
.97619 .30922 L
.97618 .31151 L
.97613 .31394 L
.97606 .31624 L
.97597 .31832 L
.97584 .32078 L
.97567 .32344 L
.97526 .32826 L
.97471 .33331 L
.97398 .33865 L
.97232 .34818 L
.96825 .36501 L
.96212 .38327 L
.95385 .40213 L
.94469 .41898 L
.91867 .45526 L
.88876 .48594 L
.85004 .51614 L
.80789 .5413 L
.75821 .56372 L
.73471 .57215 L
.70855 .58013 L
.65943 .5915 L
.63304 .59582 L
.61774 .59778 L
.60375 .59924 L
.58886 .60044 L
.58065 .60096 L
.57288 .60134 L
.56568 .60161 L
.56225 .60171 L
.55904 .60179 L
Mistroke
.55556 .60185 L
.55372 .60188 L
.55174 .6019 L
.54967 .60192 L
.5477 .60193 L
.544 .60193 L
.54046 .60191 L
.53847 .60189 L
.53664 .60187 L
.53326 .60181 L
.5297 .60174 L
.52353 .60155 L
.51676 .60128 L
.50952 .60091 L
.50178 .60042 L
.48786 .5993 L
.4609 .59623 L
.43662 .59242 L
.40959 .58697 L
.38512 .58087 L
.33203 .56344 L
.28767 .54368 L
.24328 .51779 L
.20663 .48997 L
.17332 .45677 L
.14789 .42229 L
.1377 .40421 L
.12859 .38402 L
.12231 .3657 L
.11812 .34891 L
.11643 .33957 L
.11572 .33464 L
.11511 .32943 L
.11468 .32487 L
.1145 .32245 L
.11434 .31986 L
.11422 .31748 L
.11414 .3153 L
.11408 .31312 L
.11405 .31105 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[9]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00OW7oo00<007ooOol0
PGoo002LOol00`00Oomoo`21Ool009=oo`D000Aoo`03001oogoo085oo`00UGoo00<007ooOol017oo
00<007ooOol0PGoo0028Ool;0n0E01l40n1dOol0081oo`P3h0/07aEl00X07`Ml06Moo`00NWoo1P?P
0W`01P0O27`01Goo00<007ooOol017oo00<007ooOol02Goo2W`01`0O00<3h7`0O000I7oo001dOol6
0n0801l2O00@Ool20006Ool00`00Oomoo`0HOol2O00401l20n03O01NOol0071oo`@3h0H07`Al01io
o`03001oogoo01]oo`=l00H07`03O01oogoo05Yoo`00Jgoo1@?P100O17`097oo00<007ooOol08Goo
0g`01@0O00=l07ooOol0EGoo001VOol50n000goo01l07`0201l6O00VOol00`00Oomoo`0SOol5O000
0`?P01l07`0201mDOol0065oo`D3h003Ooml07`000<07`El02]oo`03001oogoo02Qoo`Al00030n00
7`0O00807`9l04ioo`00GGoo10?P17oo0W`00P0O1G`0;Woo00<007ooOol0:goo17`00P?P0P0O0W`0
C7oo001JOol30n05Ool2O00301l2O00cOol2000bOol00g`00n007`0201l00g`0Oomoo`18Ool005Qo
o`83h0Eoo`9l00<07`=l03Eoo`03001oogoo03=oo`03O003h0?P00<07dQoo`00EGoo0`?P1Goo0W`0
0P0O0g`0>7oo00<007ooOol0=Goo0W`00P?P0P0O00=l07ooOol0@goo001BOol30n06Ool2O00201l2
O00kOol00`00Oomoo`0gOol3O00010?P01l07`0O@goo001@Ool20n07Ool2O00201l2O00mOol00`00
Oomoo`0jOol3O00010?P01l07g`0@7oo001=Ool30n06Ool3O00201l2O00oOol00`00Oomoo`0lOol3
O00010?P01l07g`0?Woo001:Ool30n07Ool3O00201l2O011Ool00`00Oomoo`0oOol2O00010?P01l0
7`0O?7oo0018Ool20n07Ool4O00201l00g`0Oomoo`12Ool00`00Oomoo`11Ool3O0000`?P01l07`0j
Ool004Eoo`<3h0Qoo`=l00807`03O01oogoo04Aoo`8004Aoo`=l00030n007`0O03Qoo`00@Woo0`?P
2Goo0g`00P0OBGoo00<007ooOol0AGoo0g`000<3h00O01l0=Woo0010Ool20n0:Ool3O00201l00g`0
Oomoo`18Ool00`00Oomoo`17Ool3O00010?P01l07g`0<goo000nOol20n0:Ool3O00201l00g`0Oomo
o`1:Ool00`00Oomoo`19Ool3O0000`?P01ml000bOol003aoo`83h0]oo`=l000301ml07oo04eoo`03
001oogoo04aoo`9l00807`03O01oogoo02ioo`00>Woo0P?P2goo0g`00P0OD7oo00<007ooOol0CGoo
0g`000<07`?POol0;Woo000hOol20n0;Ool3O00201l00g`0Oomoo`1?Ool00`00Oomoo`1?Ool2O002
01l00`?POomoo`0[Ool003Ioo`83h0aoo`9l00807`03O01oogoo055oo`03001oogoo051oo`=l0003
01l3h7oo02]oo`00=7oo0P?P37oo0g`000<07g`0Ool0E7oo0P00Dgoo0W`00P0O00=l07ooOol0:7oo
000bOol20n0=Ool2O00201l00g`0Oomoo`1DOol00`00Oomoo`1COol3O0000`0O0n1oo`0XOol0031o
o`83h0ioo`9l000301ml07oo05Moo`03001oogoo05Eoo`9l000301l3h7`002Moo`00;Woo0P?P3Woo
0g`000<07g`0Ool0F7oo00<007ooOol0EWoo0W`00P0O00=l07ooOol097oo000/Ool20n0?Ool2O002
01l00g`0Oomoo`1HOol00`00Oomoo`1HOol2O0000`0OO01oo`0TOol002Yoo`83h11oo`9l000301ml
07oo05]oo`03001oogoo05Uoo`9l000301l3h7oo02=oo`00:7oo0P?P47oo0W`00P0O00=l07ooOol0
Fgoo00<007ooOol0FWoo0W`000<07`?POol08Woo000VOol20n0AOol2O0000`0OO01l001NOol00`00
Oomoo`1KOol2O00201lROol002Aoo`83h19oo`9l000301ml07oo05moo`03001oogoo05aoo`=l0003
01ml07oo01moo`008Goo0`?P4goo0W`000<07g`0Ool0H7oo0P00GWoo0g`000<07g`0Ool07Woo000N
Ool30n0EOol2O0000`0OO01oo`1QOol00`00Oomoo`1OOol2O0000`0OO01oo`0MOol001aoo`83h1Mo
o`9l000301ml07oo069oo`03001oogoo061oo`9l000301ml07oo01aoo`006Goo0`?P67oo0W`000<0
7g`0Ool0Hgoo00<007ooOol0HGoo0W`000<07g`0Ool06goo000FOol30n0JOol2O0000`0OO01oo`1T
Ool00`00Oomoo`1ROol017`00n007g`06goo000COol30n0LOol2O0000`0OO01oo`1UOol00`00Oomo
o`1SOol017`001ml07`06Woo0007Ool<0n0NOol2O0000`0OO01oo`1BOol20004Ool20004Ool20006
Ool00`00Oomoo`1TOol017`001ml07`06Goo000`Ool2O0000`0OO01oo`1BOol01000Oomoo`0027oo
00@007ooOol000Eoo`03001oogoo06Eoo`04O0007g`0O00HOol0031oo`03O0007g`005Aoo`04001o
ogoo000;Ool00`00Oomoo`03Ool3001VOol00g`001ml000HOol002moo`9l000301moogoo04eoo`@0
009oo`04001oogoo0009Ool20006Ool00`00Oomoo`1WOol00g`001ml000GOol002ioo`9l000301ml
07oo05Aoo`04001oogoo0009Ool00`00Oomoo`05Ool00`00Oomoo`1WOol2O0000`0OO01oo`0EOol0
02eoo`9l000301ml07oo05Ioo`8000Yoo`<000Eoo`03001oogoo06Qoo`9l000301ml07oo01Aoo`00
;Goo00=l000OO000K7oo00<007ooOol0JGoo00Al000O0n1l01Aoo`00;7oo0W`000<07gooOol0Jgoo
00<007ooOol0JWoo00Al000OO01l01=oo`00:goo0W`000<07g`0Ool0K7oo00<007ooOol0Jgoo00=l
000OO0004goo000ZOol2O0000`0OO01oo`1]Ool00`00Oomoo`1/Ool00g`001ml000BOol002Yoo`03
O0007g`006moo`8006eoo`9l000301moogoo011oo`00:Goo0W`000<07gooOol0KWoo00<007ooOol0
KGoo00=l000O0n004Goo000XOol2O0000`0OO01oo`1_Ool00`00Oomoo`1]Ool2O0000`0O0n1oo`0?
Ool002Qoo`03O0007g`0075oo`03001oogoo06ioo`9l000301moogoo00ioo`009goo0W`000<07goo
Ool0L7oo00<007ooOol0Kgoo00=l000O0n003goo000WOol00g`001ml001bOol00`00Oomoo`1_Ool2
O0000`0OOomoo`0=Ool002Ioo`9l000301moogoo075oo`03001oogoo071oo`03O0007`?P00ioo`00
9Woo00=l000OO000Lgoo00<007ooOol0L7oo0W`000<07gooOol037oo000UOol2O0000`0OOomoo`1b
Ool00`00Oomoo`1aOol00g`001moo`0=Ool002Eoo`03O0007g`007Aoo`80079oo`03O0007`?P00eo
o`009Goo00=l000OOol0M7oo00<007ooOol0LGoo0W`000<07gooOol02goo000TOol2O0000`0OOomo
o`1cOol00`00Oomoo`1bOol00g`001l3h00<Ool002Aoo`03O0007g`007Eoo`03001oogoo079oo`9l
000301moogoo00Yoo`0097oo00=l000OOol0MGoo00<007ooOol0Lgoo00=l000OO0002goo000SOol2
O0000`0OOomoo`1dOol00`00Oomoo`1cOol00g`001l3h00;Ool002=oo`03O0007g`007Ioo`03001o
ogoo07Aoo`03O0007g`000Yoo`008Woo0W`000<07gooOol0MGoo00<007ooOol0M7oo00=l000OO000
2Woo000ROol00g`001ml001gOol2001fOol00g`001moo`09Ool0029oo`03O0007goo07Moo`03001o
ogoo07Eoo`03O0007goo00Uoo`008Goo0W`000<07gooOol0MWoo00<007ooOol0MGoo00=l000OO000
2Goo000QOol2O0000`0OOomoo`1fOol00`00Oomoo`1eOol00g`00n007`09Ool0025oo`03O0007goo
07Qoo`03001oogoo07Ioo`03O0007goo00Qoo`008Goo00=l000O00000`00<goo0P0017oo0P0017oo
0P00=7oo00<007ooOol0=7oo0P0017oo0P0017oo0P00=7oo00=l000O00000P001Woo000QOol017`0
01moo`00=7oo00@007ooOol000Qoo`04001oogoo000cOol00`00Oomoo`0cOol01000Oomoo`0027oo
00@007ooOol003=oo`03O0007g`000Qoo`008Goo00Al000OOol003Aoo`04001oogoo000;Ool00`00
Oomoo`0aOol00`00Oomoo`0cOol01000Oomoo`002goo00<007ooOol0<Goo00=l000O0n0027oo000L
Ool400001G`001ml07oo0000;Woo10000Woo00@007ooOol000Uoo`8003Aoo`03001oogoo03=oo`04
001oogoo0009Ool2000eOol00g`001moo`07Ool0021oo`05O0007g`0Ool0000dOol01000Oomoo`00
2Goo00<007ooOol0<goo0P00=7oo00@007ooOol000Uoo`03001oogoo03Aoo`03O0007goo00Moo`00
87oo00=l000OOol00P00=Goo0P002Woo0`00<goo00<007ooOol0=7oo0P002Woo0`00=7oo00=l000O
Ool01goo000POol00g`001moo`1iOol00`00Oomoo`1gOol00g`001moo`07Ool0021oo`03O0007goo
07Uoo`03001oogoo07Moo`03O0007goo00Moo`0087oo00=l000OOol0NGoo00<007ooOol0Mgoo00=l
000OOol01goo000POol00g`001moo`1iOol00`00Oomoo`1gOol00g`001moo`07Ool0021oo`03O000
7goo07Uoo`03001oogoo07Moo`03O0007goo00Moo`0087oo00=l000OOol0NGoo00<007ooOol0Mgoo
00=l000OOol01goo000P0002O03d00000g`001l000060001Ool000Qoo`03001oogoo00Uoo`03001o
ogoo00Uoo`03O0007goo00Yoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uoo`03001o
ogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Yoo`03001o
ogoo00Uoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Uoo`03001o
ogoo00Yoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uoo`03001o
ogoo00Qoo`03O0007goo00Moo`0087oo00=l000OOol0>goo00<007ooOol0>goo00<007ooOol0>goo
00<007ooOol0>Goo00=l000OOol01goo000POol00g`001moo`1iOol00`00Oomoo`1gOol00g`001mo
o`07Ool0021oo`03O0007goo07Uoo`03001oogoo07Moo`03O0007goo00Moo`0087oo00=l000OOol0
NGoo00<007ooOol0Mgoo00=l000OOol01goo000POol00g`001moo`1iOol00`00Oomoo`1gOol00g`0
01moo`07Ool0021oo`03O0007goo07Uoo`03001oogoo07Moo`03O0007goo00Moo`0087oo00=l000O
O000NGoo0P00N7oo00=l000OOol01goo000POol00g`001ml001iOol00`00Oomoo`1gOol00g`001mo
o`07Ool0025oo`03O0007goo07Qoo`03001oogoo07Moo`0301ml07oo00Moo`008Goo00=l000OOol0
N7oo00<007ooOol0MWoo00=l000OO00027oo000QOol00g`001moo`1hOol00`00Oomoo`1fOol00g`0
01ml0008Ool0025oo`03O0007goo07Qoo`03001oogoo07Ioo`03O0007goo00Qoo`008Goo0W`000<0
7gooOol0MWoo00<007ooOol0MGoo00=l000O0n002Goo000QOol2O0000`0OOomoo`1fOol00`00Oomo
o`1eOol00g`001l3h009Ool0029oo`03O0007goo07Moo`03001oogoo07Aoo`9l000301moogoo00Qo
o`008Woo00=l000OOol0Mgoo0P00MGoo0W`000<07gooOol027oo000ROol2O0000`0OOomoo`1eOol0
0`00Oomoo`1dOol00g`001l3h00:Ool0029oo`9l000301moogoo07Eoo`03001oogoo07=oo`9l0003
01moogoo00Uoo`008goo00=l000OO000MWoo00<007ooOol0Lgoo00=l000O0n002goo000SOol2O000
0`0OOomoo`1dOol00`00Oomoo`1cOol00g`001moo`0;Ool002Aoo`03O0007goo07Eoo`03001oogoo
079oo`9l000301moogoo00Yoo`0097oo00=l000OO000MGoo00<007ooOol0LWoo00=l000O0n0037oo
000TOol2O0000`0OOomoo`1cOol00`00Oomoo`1bOol00g`001moo`0<Ool002Eoo`03O0007g`007Ao
o`80079oo`9l000301moogoo00]oo`009Goo0W`000<07gooOol0LWoo00<007ooOol0LGoo00=l000O
O0003Goo000VOol00g`001ml001cOol00`00Oomoo`1`Ool2O0000`0OOomoo`0<Ool002Ioo`9l0003
01moogoo075oo`03001oogoo071oo`03O0007g`000ioo`009goo00=l000OO000LWoo00<007ooOol0
Kgoo0W`000<07gooOol03Goo000WOol2O0000`0OOomoo`1`Ool00`00Oomoo`1_Ool00g`001ml000?
Ool002Qoo`03O0007g`0075oo`03001oogoo06ioo`9l000301moogoo00ioo`00:7oo0W`000<07g`0
Ool0Kgoo00<007ooOol0KGoo0W`000<07g`0Ool03goo000YOol2O0000`0OO01oo`1^Ool00`00Oomo
o`1]Ool00g`001ml000AOol002Yoo`03O0007g`006moo`8006eoo`03O003h00O019oo`00:goo00=l
000OO000KWoo00<007ooOol0K7oo00=l000OO0004Woo000[Ool2O0000`0OO01oo`1/Ool00`00Oomo
o`1[Ool00g`001ml000COol002aoo`9l000301ml07oo06]oo`03001oogoo06Yoo`04O0007g`0O00C
Ool002eoo`04O0007g`0O01[Ool00`00Oomoo`1YOol017`00n007g`057oo000^Ool00g`001ml001[
Ool00`00Oomoo`1YOol00g`001ml000EOol002moo`03O0007g`005Ioo`8000Aoo`8000Aoo`8000Io
o`03001oogoo06Qoo`03O0007g`001Ioo`00;goo00Al000OO01l05Aoo`04001oogoo0008Ool01000
Oomoo`001Goo00<007ooOol0Igoo00Al00?P01ml01Ioo`00<7oo00Al000OO01l05=oo`04001oogoo
000;Ool00`00Oomoo`03Ool3001VOol017`00n007g`05goo000aOol00g`001ml001COol01000Oomo
o`002Goo0P001Woo00<007ooOol0IWoo00<3h00OO00067oo0007Ool:0n0QOol00g`001ml001BOol0
1000Oomoo`002Goo00<007ooOol01Goo00<007ooOol0IGoo00<3h00OO0006Goo000AOol50n0LOol2
O0000`0OO01oo`1AOol2000:Ool30005Ool00`00Oomoo`1TOol010?P01ml07`06Goo000FOol30n0J
Ool2O0000`0OO01oo`1TOol00`00Oomoo`1SOol010?P01ml07`06Woo000IOol30n0HOol2O0000`0O
O01oo`1SOol00`00Oomoo`1ROol017`001ml07`06goo000LOol20n0GOol2O0000`0OO01oo`1ROol0
0`00Oomoo`1QOol017`001ml07`077oo000NOol20n0FOol2O0000`0OO01oo`1QOol00`00Oomoo`1P
Ool017`001ml07`07Goo000POol20n0EOol2O0000`0OO01l001POol2001OOol2O0000`0OO01l000N
Ool0029oo`83h1Aoo`9l000301ml07`005moo`03001oogoo05eoo`9l000301ml07`001moo`0097oo
0P?P57oo00Al000OO01l05ioo`03001oogoo05aoo`04O0007`0OO00QOol002Ioo`83h1=oo`04O000
7`0OO01MOol00`00Oomoo`1KOol017`001ml07`08Woo000XOol20n0BOol2O0000`0OO01oo`1KOol0
0`00Oomoo`1JOol017`001ml07`08goo000ZOol20n0AOol2O0000`0OO01oo`1JOol00`00Oomoo`1H
Ool00g`001l07`02O00TOol002aoo`<3h0moo`9l00807`03O01oogoo05Moo`03001oogoo05Moo`03
O0007g`0009l02Eoo`00;goo0P?P3Woo0g`000<07g`0Ool0Egoo00<007ooOol0EGoo0W`000<07g`0
O0009goo000aOol20n0>Ool2O0000`0OO01l001FOol00`00Oomoo`1DOol00g`001l07`02O00XOol0
03=oo`83h0eoo`9l00807`03O01oogoo05=oo`8005=oo`9l000301ml07`002Yoo`00=Goo0P?P3Goo
0W`000<07g`0O000Dgoo00<007ooOol0DGoo00=l000O01l00W`0:goo000gOol20n0<Ool2O00201l0
0g`0Oomoo`1@Ool00`00Oomoo`1?Ool2O0000`0OO01l000]Ool003Uoo`<3h0]oo`9l00807`03O01o
ogoo04ioo`03001oogoo04ioo`03O0007`0O009l02ioo`00?7oo0P?P2Woo0g`000<07g`0Ool0CWoo
00<007ooOol0C7oo0W`000<07g`0O000<7oo000nOol20n0:Ool2O00201l00g`0Oomoo`1;Ool00`00
Oomoo`1:Ool2O00201l2O00aOol0041oo`83h0Uoo`=l00807`03O01oogoo04Uoo`03001oogoo04Qo
o`=l000301ml07`003=oo`00@Woo0P?P2Goo0g`00P0O00=l07ooOol0Agoo00<007ooOol0Agoo0W`0
0P0O00=l07ooOol0<goo0014Ool30n08Ool3O00201l00g`0Oomoo`15Ool20016Ool2O00201l00g`0
Oomoo`0eOol004Moo`<3h0Moo`=l00807`03O01oogoo04=oo`03001oogoo04=oo`9l00807`9l03Qo
o`00BWoo0P?P1goo0g`00P0O00=l07ooOol0@Goo00<007ooOol0@Goo0W`00P0O0W`0>Woo001<Ool3
0n06Ool3O00201l00g`0Oomoo`0oOol00`00Oomoo`0oOol017`001l07`0O0W`0?7oo001?Ool30n05
Ool3O00201l00g`0Oomoo`0mOol00`00Oomoo`0lOol2O00201l3O00nOol0059oo`<3h0Aoo`=l0080
7`03O01oogoo03]oo`03001oogoo03Yoo`04O003h00O01l3O010Ool005Eoo`@3h09oo`=l00<07`03
O01oogoo03Qoo`03001oogoo03Moo`9l00<07`9l04=oo`00FGoo0`?P00=oog`0O0000W`00`0O>7oo
00<007ooOol0=7oo00=l000O01l00P0O0g`0AGoo001LOol40n04O00301leOol00`00Oomoo`0bOol3
01l010?PO01l07`0B7oo001POol30n04O00301lbOol2000_Ool01G`00n007`0O0n000g`0Bgoo001S
Ool40n03O00301l_Ool00`00Oomoo`0ZOol2O0020n0201l4O01=Ool006Moo`@3h09l00<07`03O01o
ogoo02Uoo`03001oogoo02Eoo`=l0083h0@07`9l055oo`00Jgoo10?P00=l000O01l00P0O0W`09Woo
00<007ooOol08Woo0g`000<3h00O01l00P0O0W`0EGoo001_Ool30n02O00501l5O00NOol00`00Oomo
o`0MOol4O00501l00g`0Oomoo`1HOol0079oo`@3h0=l00P07`Al01Moo`03001oogoo01Uoo`9l00H0
7`=l05eoo`00MWoo1P?P1G`01`0O00=l07ooOol027oo1@0017oo00<007ooOol04Goo17`01P0O00@3
h7`0O01l069oo`00O7oo30?P2@0O0W`00Woo00<007ooOol017oo00<007ooOol01Goo17`0300O00<3
h7`0O0000g`0IWoo0027Ool2O0080n0G01l50n05O01^Ool0095ooaEl07Yoo`00UGoo00<007ooOol0
17oo00<007ooOol0PGoo002DOol20006Ool00`00Oomoo`21Ool009aoo`03001oogoo085oo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.26952, -1.05499, \
0.00811038, 0.0119249}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]="]
}, Open  ]],

Cell["\<\
Notice how the 6th order approximation deteriorates away from the nominal \
point. The 10th order approximation is quite good. \
\>", "Text",
  CellTags->{"Implicit", "i:1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot[{{Cos[k1], Sin[k1]}, Circ[\([1]\)], 
        Circ1[\([1]\)]}, {k1, \(-1.5\)*Pi, 1.5*Pi}, 
      PlotStyle\  -> \n\ \ \ \ \ {{RGBColor[1, \ 0, \ 0], 
            Thickness[0.008]}, \ {RGBColor[0, \ 1, \ 0]}, \ {RGBColor[0, \ 
              0, \ 1]}}, 
      PlotRange -> {{\(-1.5\), 1.5}, {\(-1.5\), 1.5}}]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->{"Implicit", "i:1"}],

Cell[BoxData[
    \(ParametricPlot::"ppcom" \(\(:\)\(\ \)\) 
      "Function \!\(Circ \[LeftDoubleBracket] 1 \[RightDoubleBracket]\) \
cannot be compiled; plotting will proceed with the uncompiled function."\)], \
"Message",
  CellLabel->"From In[10]:="],

Cell[BoxData[
    \(ParametricPlot::"ppcom" \(\(:\)\(\ \)\) 
      "Function \!\(Circ1 \[LeftDoubleBracket] 1 \[RightDoubleBracket]\) \
cannot be compiled; plotting will proceed with the uncompiled function."\)], \
"Message",
  CellLabel->"From In[10]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.309017 0.206011 [
[0 .29652 -12 -9 ]
[0 .29652 12 0 ]
[.16667 .29652 -6 -9 ]
[.16667 .29652 6 0 ]
[.33333 .29652 -12 -9 ]
[.33333 .29652 12 0 ]
[.66667 .29652 -9 -9 ]
[.66667 .29652 9 0 ]
[.83333 .29652 -3 -9 ]
[.83333 .29652 3 0 ]
[1 .29652 -9 -9 ]
[1 .29652 9 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .10301 -12 -4.5 ]
[.4875 .10301 0 4.5 ]
[.4875 .20601 -24 -4.5 ]
[.4875 .20601 0 4.5 ]
[.4875 .41202 -18 -4.5 ]
[.4875 .41202 0 4.5 ]
[.4875 .51503 -6 -4.5 ]
[.4875 .51503 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
0 .31527 L
s
[(-1.5)] 0 .29652 0 1 Mshowa
.16667 .30902 m
.16667 .31527 L
s
[(-1)] .16667 .29652 0 1 Mshowa
.33333 .30902 m
.33333 .31527 L
s
[(-0.5)] .33333 .29652 0 1 Mshowa
.66667 .30902 m
.66667 .31527 L
s
[(0.5)] .66667 .29652 0 1 Mshowa
.83333 .30902 m
.83333 .31527 L
s
[(1)] .83333 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(1.5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.03333 .30902 m
.03333 .31277 L
s
.06667 .30902 m
.06667 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.13333 .30902 m
.13333 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.23333 .30902 m
.23333 .31277 L
s
.26667 .30902 m
.26667 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.43333 .30902 m
.43333 .31277 L
s
.46667 .30902 m
.46667 .31277 L
s
.53333 .30902 m
.53333 .31277 L
s
.56667 .30902 m
.56667 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.73333 .30902 m
.73333 .31277 L
s
.76667 .30902 m
.76667 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.86667 .30902 m
.86667 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.93333 .30902 m
.93333 .31277 L
s
.96667 .30902 m
.96667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .10301 m
.50625 .10301 L
s
[(-1)] .4875 .10301 1 0 Mshowa
.5 .20601 m
.50625 .20601 L
s
[(-0.5)] .4875 .20601 1 0 Mshowa
.5 .41202 m
.50625 .41202 L
s
[(0.5)] .4875 .41202 1 0 Mshowa
.5 .51503 m
.50625 .51503 L
s
[(1)] .4875 .51503 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .0206 m
.50375 .0206 L
s
.5 .0412 m
.50375 .0412 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .0824 m
.50375 .0824 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .14421 m
.50375 .14421 L
s
.5 .16481 m
.50375 .16481 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .22661 m
.50375 .22661 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26781 m
.50375 .26781 L
s
.5 .28842 m
.50375 .28842 L
s
.5 .32962 m
.50375 .32962 L
s
.5 .35022 m
.50375 .35022 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .39142 m
.50375 .39142 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .45322 m
.50375 .45322 L
s
.5 .47383 m
.50375 .47383 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .53563 m
.50375 .53563 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57683 m
.50375 .57683 L
s
.5 .59743 m
.50375 .59743 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.008 w
.5 .51503 m
.49612 .51501 L
.49259 .51498 L
.48852 .51491 L
.48468 .51481 L
.47784 .51457 L
.47043 .51422 L
.46229 .51371 L
.45368 .51303 L
.43832 .51147 L
.4226 .5094 L
.40804 .50703 L
.37564 .50015 L
.34394 .49105 L
.31643 .48097 L
.28647 .46721 L
.26104 .45265 L
.22184 .42254 L
.20501 .40494 L
.19026 .38515 L
.17935 .36531 L
.17466 .35386 L
.17128 .34319 L
.16908 .33376 L
.16814 .32838 L
.16747 .32334 L
.16719 .32061 L
.16698 .31802 L
.16684 .31569 L
.16673 .31316 L
.1667 .31185 L
.16667 .3104 L
.16667 .30889 L
.16668 .30748 L
.16673 .30495 L
.16678 .30353 L
.16685 .30223 L
.16701 .29963 L
.16722 .29717 L
.16773 .29258 L
.16846 .28765 L
.16948 .28232 L
.17187 .27276 L
.17472 .26401 L
.18356 .24426 L
.19633 .22406 L
.21047 .20693 L
.22847 .18952 L
.26777 .16123 L
.29287 .14761 L
Mistroke
.32259 .13461 L
.35261 .12424 L
.38186 .11638 L
.39771 .11295 L
.41513 .1098 L
.43069 .10751 L
.44728 .1056 L
.46241 .10432 L
.47103 .10379 L
.47517 .10358 L
.47908 .10341 L
.48264 .10329 L
.48651 .10317 L
.49002 .1031 L
.49327 .10305 L
.49678 .10302 L
.50065 .10301 L
.50469 .10303 L
.50848 .10307 L
.51237 .10315 L
.51653 .10326 L
.524 .10354 L
.53287 .10401 L
.54089 .10456 L
.55829 .10618 L
.57455 .10822 L
.60281 .11305 L
.63251 .11998 L
.6606 .12849 L
.68983 .13968 L
.7185 .15344 L
.74241 .16761 L
.78176 .19894 L
.79905 .21802 L
.81234 .23706 L
.82201 .25577 L
.82578 .26541 L
.82907 .27619 L
.83114 .28541 L
.832 .29062 L
.83261 .29541 L
.83299 .29963 L
.83314 .30203 L
.83324 .30426 L
.83331 .30662 L
.83333 .30876 L
.83331 .31124 L
.83325 .31358 L
.83315 .31593 L
.83298 .31845 L
Mistroke
.83279 .32082 L
.83257 .32299 L
.83187 .32829 L
.83101 .33331 L
.8287 .34324 L
.8253 .35397 L
.81697 .37278 L
.80669 .38972 L
.79137 .40908 L
.77402 .42632 L
.73463 .45535 L
.71067 .46867 L
.68324 .48111 L
.6558 .49114 L
.62955 .49883 L
.60018 .5055 L
.58475 .50826 L
.56775 .51073 L
.55187 .51252 L
.54485 .51316 L
.53708 .51375 L
.53024 .51418 L
.52286 .51454 L
.51879 .5147 L
.51506 .51482 L
.51149 .51491 L
.50773 .51497 L
.50365 .51502 L
.50135 .51503 L
.49923 .51503 L
.49534 .51501 L
.49122 .51496 L
.48752 .51488 L
.48408 .51479 L
.47623 .5145 L
.46778 .51406 L
.46008 .51355 L
.44284 .51198 L
.42824 .5102 L
.4125 .5078 L
.38441 .50225 L
.35303 .49392 L
.32596 .48472 L
.29625 .47206 L
.27107 .45876 L
.22924 .42918 L
.21112 .4118 L
.19517 .39236 L
.18384 .37429 L
.1788 .36409 L
Mistroke
.17482 .3543 L
.17182 .3451 L
.17051 .34022 L
.16933 .33502 L
.16851 .33064 L
.16778 .3258 L
.16727 .3214 L
.16708 .31923 L
.16693 .31726 L
.16679 .31473 L
.16674 .31333 L
.1667 .31202 L
.16667 .30968 L
.16668 .30715 L
.16671 .30582 L
.16675 .30436 L
.16682 .30283 L
.16689 .30141 L
.16707 .29886 L
.16732 .29612 L
.16798 .29074 L
.16882 .28565 L
.17094 .27615 L
.1737 .26691 L
.17687 .25844 L
.18614 .23963 L
.19824 .2215 L
.21209 .2052 L
.23015 .18807 L
.25205 .17133 L
.27438 .15737 L
.30116 .14367 L
.32719 .13285 L
.35319 .12406 L
.38431 .11581 L
.41363 .11004 L
.43039 .10755 L
.44602 .10572 L
.46332 .10426 L
.47208 .10373 L
.47712 .10349 L
.48174 .10331 L
.48625 .10318 L
.49054 .10309 L
.49289 .10305 L
.49506 .10303 L
.49745 .10301 L
.5 .10301 L
Mfstroke
0 1 0 r
.5 Mabswid
0 .13178 m
.0195 .15326 L
.04147 .17328 L
.05987 .18674 L
.06932 .19216 L
.07915 .19656 L
.08338 .19805 L
.08781 .19935 L
.09157 .20023 L
.09564 .20097 L
.0979 .20128 L
.09999 .20151 L
.10198 .20168 L
.10411 .2018 L
.10619 .20186 L
.10815 .20187 L
.10991 .20184 L
.11182 .20176 L
.11392 .20163 L
.11623 .20143 L
.11865 .20116 L
.12091 .20085 L
.12937 .19926 L
.13756 .19716 L
.14518 .1948 L
.16298 .18819 L
.25175 .1501 L
.30071 .13254 L
.33077 .12371 L
.36024 .11652 L
.39003 .11074 L
.42301 .10604 L
.44044 .10429 L
.45 .10354 L
.45893 .10297 L
.46659 .10259 L
.47479 .10229 L
.47704 .10223 L
.47947 .10217 L
.48162 .10213 L
.4839 .10209 L
.48821 .10204 L
.49218 .10203 L
.49619 .10204 L
.50056 .10208 L
.50469 .10216 L
.50852 .10225 L
.51574 .10249 L
.52341 .10285 L
.53245 .1034 L
Mistroke
.54093 .10405 L
.55668 .1056 L
.58509 .10958 L
.61503 .11551 L
.644 .12314 L
.67427 .13336 L
.7042 .14617 L
.72934 .15951 L
.77157 .18955 L
.79056 .20806 L
.80551 .22662 L
.81686 .24506 L
.82185 .25541 L
.82573 .26525 L
.8286 .27441 L
.83064 .28286 L
.8315 .28746 L
.83223 .2923 L
.83278 .29717 L
.83301 .29993 L
.83317 .3025 L
.83327 .30511 L
.83331 .30643 L
.83333 .30787 L
.83333 .31043 L
.83328 .31282 L
.83322 .31427 L
.83316 .31564 L
.833 .31821 L
.83277 .32098 L
.83245 .32399 L
.83175 .32908 L
.83078 .33447 L
.82846 .34411 L
.82557 .35323 L
.82225 .36171 L
.81252 .38067 L
.7998 .39907 L
.78335 .41753 L
.74665 .4476 L
.72444 .46134 L
.6985 .47454 L
.64683 .49405 L
.61583 .50234 L
.59899 .50594 L
.58085 .50915 L
.56477 .51146 L
.54688 .51345 L
.53899 .51415 L
.53048 .51477 L
Mistroke
.52239 .51524 L
.51505 .51557 L
.51072 .51572 L
.50664 .51583 L
.50233 .51592 L
.49991 .51596 L
.49768 .51598 L
.49393 .516 L
.48983 .516 L
.48554 .51596 L
.48154 .5159 L
.47927 .51586 L
.4768 .5158 L
.47231 .51566 L
.46392 .51532 L
.45413 .51478 L
.44511 .51413 L
.42994 .51275 L
.41334 .5108 L
.38032 .50557 L
.34903 .49895 L
.3214 .49174 L
.26349 .47249 L
.21313 .4517 L
.17231 .43372 L
.15395 .42633 L
.13755 .42086 L
.12877 .41864 L
.12389 .41767 L
.11943 .41698 L
.11569 .41655 L
.11357 .41638 L
.11159 .41626 L
.1095 .41618 L
.1076 .41616 L
.1054 .41619 L
.10332 .41627 L
.10117 .41642 L
.09996 .41652 L
.09884 .41664 L
.09461 .41723 L
.09075 .41798 L
.08663 .419 L
.07792 .42195 L
.06806 .42654 L
.04928 .43862 L
.02975 .45499 L
Mfstroke
.02975 .45499 m
0 .48896 L
s
0 0 1 r
.42585 .40056 m
.41861 .41178 L
.41117 .42091 L
.40232 .42953 L
.39219 .43723 L
.38095 .44374 L
.36986 .4485 L
.35962 .4517 L
.35375 .45307 L
.34829 .45408 L
.34265 .45486 L
.33947 .45518 L
.33656 .45541 L
.33385 .45557 L
.33089 .45568 L
.3281 .45573 L
.32551 .45572 L
.32392 .45569 L
.32222 .45564 L
.31912 .4555 L
.31611 .4553 L
.31334 .45507 L
.30706 .45434 L
.30047 .4533 L
.28823 .45063 L
.27704 .44732 L
.26519 .4429 L
.25278 .4372 L
.23231 .42507 L
.21496 .41148 L
.20028 .3966 L
.18883 .38163 L
.18374 .37347 L
.17895 .36442 L
.1754 .35642 L
.17215 .34749 L
.16935 .33742 L
.16817 .33187 L
.16731 .32666 L
.16698 .32414 L
.1667 .32175 L
.1665 .31957 L
.16632 .31727 L
.16618 .31475 L
.1661 .31243 L
.16605 .30992 L
.16605 .3085 L
.16606 .30716 L
.16612 .30467 L
.16618 .30328 L
Mistroke
.16625 .30202 L
.16641 .29956 L
.16661 .29724 L
.16721 .29204 L
.1681 .28642 L
.17039 .27618 L
.17323 .26682 L
.1806 .24919 L
.19111 .23105 L
.20431 .21358 L
.22132 .19578 L
.25897 .16663 L
.28341 .15237 L
.31244 .13868 L
.33936 .12849 L
.3707 .11913 L
.38582 .11546 L
.4024 .11203 L
.41694 .1095 L
.43303 .1072 L
.4504 .1053 L
.45993 .1045 L
.46882 .10391 L
.47313 .10368 L
.47719 .10349 L
.4809 .10334 L
.48481 .10322 L
.48908 .10312 L
.49302 .10305 L
.49726 .10301 L
.49967 .10301 L
.50191 .10301 L
.50606 .10304 L
.50816 .10307 L
.51047 .10311 L
.51455 .1032 L
.51838 .10332 L
.52699 .10368 L
.53626 .10423 L
.55312 .10564 L
.56848 .1074 L
.59732 .11198 L
.62687 .11851 L
.65533 .12674 L
.68423 .13733 L
.73139 .16073 L
.75445 .17593 L
.77651 .19397 L
.7929 .21068 L
.8079 .23009 L
Mistroke
.81377 .23948 L
.81925 .24977 L
.82327 .25879 L
.8269 .26875 L
.82865 .27461 L
.83003 .28007 L
.8312 .28575 L
.83204 .29091 L
.83237 .29336 L
.83267 .296 L
.83288 .29829 L
.83307 .30081 L
.83321 .30348 L
.83327 .30494 L
.8333 .30631 L
.83333 .30875 L
.83331 .31137 L
.83324 .31386 L
.83318 .31527 L
.83311 .3166 L
.83292 .31927 L
.83266 .32215 L
.83201 .32734 L
.83124 .33208 L
.82877 .34297 L
.82517 .35433 L
.81673 .37322 L
.80424 .3932 L
.78882 .41186 L
.77223 .4279 L
.74993 .44533 L
.72679 .46 L
.67657 .48375 L
.64746 .49377 L
.61505 .50237 L
.58535 .50816 L
.56834 .51065 L
.55263 .51244 L
.53793 .51369 L
.52958 .51422 L
.52559 .51442 L
.52183 .51459 L
.51824 .51472 L
.51436 .51484 L
.51083 .51492 L
.50759 .51498 L
.50407 .51501 L
.50021 .51503 L
.49618 .51502 L
.49243 .51498 L
Mistroke
.48824 .5149 L
.48613 .51485 L
.48381 .51479 L
.47586 .51449 L
.4714 .51427 L
.4666 .51399 L
.45794 .51338 L
.44106 .51178 L
.42574 .50985 L
.3955 .50465 L
.3676 .49809 L
.33923 .4895 L
.31058 .47856 L
.26406 .45462 L
.24136 .4391 L
.2198 .42081 L
.20388 .40394 L
.18947 .38447 L
.18383 .37502 L
.17864 .36473 L
.17486 .35572 L
.1715 .34583 L
.16991 .34 L
.16868 .3346 L
.16774 .32952 L
.16732 .32683 L
.16694 .32391 L
.16665 .3213 L
.16644 .31891 L
.16628 .31661 L
.16616 .3142 L
.16608 .31165 L
.16605 .30928 L
.16607 .30669 L
.16611 .30523 L
.16615 .30391 L
.16627 .30155 L
.16643 .29934 L
.16664 .29693 L
.16692 .29433 L
.16767 .28907 L
.16854 .28428 L
.17076 .27515 L
.17349 .2666 L
.18173 .24817 L
.18767 .23817 L
.19396 .22921 L
.20896 .21218 L
.22558 .19782 L
.24234 .18656 L
Mistroke
.26211 .17644 L
.27202 .17247 L
.28294 .16887 L
.28933 .16713 L
.29521 .16576 L
.30084 .16466 L
.30686 .16372 L
.30984 .16334 L
.31315 .16298 L
.31619 .16272 L
.31898 .16254 L
.32059 .16246 L
.32227 .16239 L
.32396 .16234 L
.32582 .16231 L
.32742 .1623 L
.32914 .16232 L
.33222 .16239 L
.33385 .16246 L
.33534 .16254 L
.33871 .16278 L
.34167 .16307 L
.3448 .16344 L
.3502 .16428 L
.35609 .16547 L
.36648 .16836 L
.37611 .17203 L
.3845 .17615 L
.39333 .18157 L
.40245 .18862 L
.41152 .19752 L
.42585 .21747 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[10]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo001lOol50002Ool20004Ool2002EOol007ioo`03001oogoo00Moo`04
001oogoo002DOol007ioo`03001oogoo00Yoo`03001oogoo00=oo`8008eoo`00MWoo100017oo00<0
07ooOol027oo0P001Woo00<007ooOol0S7oo001nOol00`00Oomoo`08Ool00`00Oomoo`05Ool00`00
Oomoo`2<Ool007eoo`8000Yoo`<000Eoo`03001oogoo08aoo`00TGoo00<007ooOol0S7oo002AOol0
0`00Oomoo`2<Ool0095oo`03001oogoo08aoo`00TGoo00<007ooOol0S7oo002AOol00`00Oomoo`2<
Ool0095oo`03001oogoo08aoo`00TGoo00<007ooOol0S7oo002AOol00`00Oomoo`2<Ool0095oo`03
001oogoo08aoo`00TGoo00<007ooOol0S7oo002AOol00`00Oomoo`2<Ool0095oo`03001oogoo08ao
o`00TGoo00<007ooOol0S7oo002AOol00`00Oomoo`2<Ool0095oo`03001oogoo08aoo`00TGoo00<0
07ooOol0S7oo002AOol00`00Oomoo`2<Ool0095oo`03001oogoo08aoo`00TGoo00<007ooOol0S7oo
002AOol00`00Oomoo`2<Ool0095oo`03001oogoo08aoo`00R7oo1@0017oo00<007ooOol0S7oo002:
Ool00`00Oomoo`04Ool00`00Oomoo`2<Ool008=oo`D3h1407`030n1l07`008Aoo`00N7oo1@?P2`0O
4G`0300ONgoo001bOol60n000g`001l07`0201l;O002Ool00`00Oomoo`04Ool00`00Oomoo`06Ool:
O0000`?P01l07`0201l4O01cOol006ioo`@3h0=l00@07`9l00ioo`8000Ioo`03001oogoo00moo`Il
00D07`9l071oo`00JWoo10?P0g`0100O0g`06Goo00<007ooOol05goo0W`000<3h00O01l0100O00=l
07ooOol0JGoo001VOol40n03O00401l2O00NOol00`00Oomoo`0JOol3O0030n0201l00g`0Oomoo`1W
Ool0069oo`@3h0=l00@07`=l025oo`03001oogoo01moo`9l00040n007`0O01l3O01TOol005ioo`@3
h0=l00@07`03O01oogoo02Eoo`03001oogoo025oo`Al00<07`030n1l07oo065oo`0037oo00<3h7oo
Ool0Bgoo10?P0Woo0g`00P0O0g`0:Goo00<007ooOol09Woo0W`0100O00=l07ooOol0GGoo000=Ool0
0`?POomoo`18Ool20n04Ool3O00201l2O00/Ool00`00Oomoo`0XOol4O00301l00g`0Oomoo`1JOol0
00ioo`030n1oogoo04Aoo`<3h0=oo`=l00<07`03O01oogoo02eoo`03001oogoo02]oo`=l00040n00
7`0OO01JOol000moo`030n1oogoo041oo`<3h0=oo`Al00807`9l035oo`03001oogoo02ioo`9l0004
0n007`0OO01HOol000moo`030n1oogoo03ioo`83h0Eoo`9l00<07`03O01oogoo039oo`03001oogoo
031oo`9l00040n007`?PO01FOol0011oo`030n1oogoo03Yoo`<3h0Eoo`9l00807`9l03Ioo`03001o
ogoo039oo`9l00807`030n1l07oo05=oo`004Goo00<3h7ooOol0=goo0P?P1Woo0W`00P0O0W`0>7oo
00<007ooOol0=7oo0W`00P0O00<3h7`0Ool0DGoo000BOol00`?POomoo`0dOol20n07Ool00g`001l0
7`02O00jOol00`00Oomoo`0fOol2O00201l00`?PO01oo`1?Ool001=oo`030n1oogoo031oo`<3h0Mo
o`03O0007`0O00=l00Moo`/07bUoo`03001oogoo03Qoo`9l000401l3h0?PO01>Ool001Aoo`83h2io
o`83h0Qoo`9l000401ml07`0O004Ool501l;Ool401lUOol00`00Oomoo`0jOol01G`001l07`?PO000
CGoo000FOol00`?POomoo`0YOol20n09Ool2O000100OO01l07`00goo0P0O57oo0`0O8Woo00<007oo
Ool0?7oo00Al000O0n1l04aoo`005goo00<3h7ooOol09Woo0P?P2Woo00=l000O01l00W`00Woo0`0O
6Goo0P0O87oo00<007ooOol0?Goo00Al000O01l3h4]oo`0067oo00<3h7ooOol08Woo0`?P2Woo0W`0
00@07g`0O01l00<07aioo`807aioo`03001oogoo03ioo`9l000301l3h7oo04Uoo`006Goo00<3h7oo
Ool07goo0P?P37oo0W`000<07g`0O0000P0O8goo0P0O77oo00<007ooOol0?goo0W`00P0O00=l07oo
Ool0AWoo000JOol00`?POomoo`0LOol20n0<Ool3O000100OO0007`0O9goo0P0O6Woo00<007ooOol0
@7oo0g`000<07`?POol0AWoo000KOol20n0IOol30n0=Ool2O00201l00g`001moo`0ZOol00`0OOomo
o`0GOol00`00Oomoo`12Ool2O00201m6Ool001eoo`<3h1Aoo`83h0moo`9l000401ml000O01l]Ool0
0`0OOomoo`0FOol00`00Oomoo`13Ool3O0000`0OOomoo`13Ool0021oo`83h0ioo`@3h11oo`9l0003
01ml000O031oo`0301moogoo01Eoo`03001oogoo04Aoo`=l000301moogoo049oo`008Woo1P?P00=o
o`?P0n001@?P4goo0W`000<07g`001l0<Woo00<07gooOol00P0017oo0P0017oo0P001Woo00<007oo
Ool0AGoo0g`000<07gooOol0@Goo000WOol30n0HOol2O00301lcOol00`0OOol00002Ool00`00Oomo
o`06Ool01000Oomoo`001Goo00<007ooOol0AWoo0W`000<07`?POol0@Goo0011Ool3O0000`0OOomo
o`0dOol01@0O001oogoo00002goo00<007ooOol00goo0P00B7oo0W`000<07`?POol0@7oo0011Ool2
O0000`0OOomoo`0`Ool40002Ool0100OOomoo`002Goo0P001Woo00<007ooOol0B7oo0W`000<07`?P
Ool0?goo0010Ool2O0000`0OOomoo`0gOol0100OOomoo`002Goo00<007ooOol01Goo00<007ooOol0
BGoo0W`000<07`?POol0?Woo000oOol2O0000`0OO01oo`0iOol00`0O001oo`09Ool30005Ool00`00
Oomoo`1:Ool2O0000`0OO01oo`0mOol003ioo`9l00807dmoo`03001oogoo04]oo`04O0007`?PO00m
Ool003ioo`03O0007`0O051oo`03001oogoo04aoo`03O0007`?P03eoo`00?Goo00=l000O01l0DGoo
00<007ooOol0CGoo00=l000O0n00?7oo000lOol2O0000`0OO01oo`1@Ool00`00Oomoo`1=Ool2O000
0`0OO01oo`0jOol003aoo`03O0007g`0059oo`03001oogoo04ioo`03O0007`?P03]oo`00>goo0W`0
00<07g`0Ool0DGoo00<007ooOol0Cgoo00=l000OO000>Woo000kOol00g`001ml001COol00`00Oomo
o`1?Ool2O0000`0OOomoo`0hOol003Yoo`9l000301ml07oo059oo`03001oogoo051oo`03O0007g`0
03Uoo`00>Woo0W`000<07gooOol0DWoo00<007ooOol0D7oo00=l000O0n00>Goo000iOol2O0000`0O
O01oo`1COol00`00Oomoo`1AOol00g`001ml000hOol003Uoo`9l000301moogoo05=oo`03001oogoo
055oo`03O0007`?P03Qoo`00>Goo00=l000OO000EGoo00<007ooOol0DWoo00=l000OOol0=goo0007
Ool50002Ool20004Ool2000ROol2O000100OO00000008Woo0P0017oo0P0017oo0P008goo00<007oo
Ool08Woo0P0017oo0P0017oo0P008Woo00=l000OO0000`008Woo1@000Woo0P0017oo0P000goo0009
Ool00`00Oomoo`07Ool01000Oomoo`008Goo00Al000OO00002=oo`04001oogoo0008Ool01000Oomo
o`008Woo00<007ooOol08Goo00@007ooOol000Qoo`04001oogoo000QOol2O0000`0O001oo`0UOol0
0`00Oomoo`07Ool01000Oomoo`000Woo0009Ool00`00Oomoo`0:Ool00`00Oomoo`0OOol017`001ml
00008goo00@007ooOol000]oo`03001oogoo021oo`03001oogoo025oo`04001oogoo000;Ool00`00
Oomoo`0POol00g`001l0000VOol00`00Oomoo`0:Ool10001Ool1Ool00003Ool00000008000Aoo`03
001oogoo00Qoo`8001eoo`@00005O0007`0OOol0000MOol40002Ool01000Oomoo`002Goo0P008goo
00<007ooOol08Goo00@007ooOol000Uoo`8002=oo`03O0007g`002Ioo`03001oogoo00Qoo`8000=o
o`002Goo00<007ooOol027oo00<007ooOol087oo00El000OO01oo`0002=oo`04001oogoo0009Ool0
0`00Oomoo`0ROol00`00Oomoo`0QOol01000Oomoo`002Goo00<007ooOol08Woo00=l00?P01l09Woo
00<007ooOol027oo00<007ooOol00Woo0008Ool2000:Ool3000POol00g`001ml0002000TOol2000:
Ool3000ROol00`00Oomoo`0ROol2000:Ool3000SOol00g`001moo`0TOol2000:Ool30002Ool003Mo
o`03O0007goo05Moo`03001oogoo05Aoo`03O0007goo03Eoo`00=goo00=l000OOol0Egoo00<007oo
Ool0E7oo00=l000OOol0=Goo000gOol00g`001moo`1GOol00`00Oomoo`1DOol00g`001moo`0eOol0
03Moo`03O0007goo05Moo`03001oogoo05Aoo`03O0007goo03Eoo`00=goo00=l000OOol0Egoo00<0
07ooOol0E7oo00=l000OOol0=Goo000<Ool[00000g`001l0002^00000g`001l0000/0009Ool000ao
o`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eo
o`03O0007goo00Moo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Io
o`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Io
o`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Io
o`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eo
o`03O0007goo00Moo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Io
o`03001oogoo00Moo`0037oo00<007ooOol0:7oo00=l000OOol0:Woo00<007ooOol0:Woo00<007oo
Ool0:Goo00<007ooOol0:7oo00=l000OOol0:goo00<007ooOol01goo000gOol00g`001moo`1GOol0
0`00Oomoo`1DOol00g`001moo`0eOol003Moo`03O0007goo05Moo`03001oogoo05Aoo`03O0007goo
03Eoo`00=goo00=l000OOol0Egoo00<007ooOol0E7oo00=l000OOol0=Goo000gOol00g`001ml001G
Ool00`00Oomoo`1DOol00`?P01moo`0eOol003Moo`03O0007`0O05Moo`03001oogoo05=oo`03O003
h00O03Ioo`00=goo0W`000<07gooOol0EGoo00<007ooOol0Dgoo00=l000OO000=Woo000hOol00g`0
01moo`1FOol00`00Oomoo`1COol00g`001moo`0fOol003Qoo`03O0007g`005Ioo`03001oogoo059o
o`9l000301moogoo03Eoo`00>7oo00=l000O01l0EWoo00<007ooOol0DWoo00=l000OO000=goo000i
Ool00g`001moo`1EOol00`00Oomoo`1BOol00g`001moo`0gOol003Uoo`03O0007g`005Eoo`03001o
ogoo055oo`03O003h00O03Qoo`00>Goo0W`000<07gooOol0Dgoo00<007ooOol0DGoo00=l000OO000
>7oo000jOol00g`001ml001DOol00`00Oomoo`1@Ool2O0000`0OOomoo`0gOol003Yoo`03O0007`0O
05Aoo`03001oogoo051oo`03O0007g`003Uoo`00>goo00=l000OO000Dgoo00<007ooOol0Cgoo0W`0
00<07gooOol0>7oo000kOol00g`001l07`1COol00`00Oomoo`1?Ool00g`001ml000jOol003aoo`03
O0007`0O059oo`03001oogoo04ioo`03O0007`?P03]oo`00?7oo0W`00P0ODGoo00<007ooOol0CGoo
0W`000<07g`0Ool0>Woo000mOol2O00201m@Ool00`00Oomoo`1<Ool2O0000`0OO01oo`0kOol003eo
o`=l000301moogoo04ioo`03001oogoo04aoo`03O0007`?P03eoo`00?Woo0W`00P0OCgoo00<007oo
Ool0Bgoo00=l000O0n00?Woo000oOol2O00201ljOol00`0OOomoo`0AOol00`00Oomoo`1:Ool017`0
01l3h7`0?Woo0010Ool2O00201lhOol00`0O00000004Ool20004Ool20006Ool00`00Oomoo`1:Ool0
0g`001ml000oOol0041oo`=l00807cMoo`0401moogoo0008Ool01000Oomoo`001Goo00<007ooOol0
BGoo00=l000OO000@7oo0011Ool3O00201leOol01@0O001oogoo00002goo00<007ooOol00goo0P00
BGoo00Al000O0n1l041oo`00@Woo0W`000<07g`001l0<goo00<07goo00000Woo00<007ooOol01goo
0P001Woo00<007ooOol0Agoo00Al000O0n1l045oo`008Woo3@?P57oo0W`000<07g`001l0<Woo00<0
7goo00000Woo00<007ooOol01goo00<007ooOol01Goo00<007ooOol0AGoo0W`000<07`?PO000@Woo
000POol20n0=Ool30n0COol017`001ml000O<7oo00@07gooOomoo`8000Yoo`<000Eoo`03001oogoo
04Aoo`=l000301ml07oo049oo`007Woo0P?P4Woo10?P3goo0W`000<07g`001l0;Woo00<07gooOol0
5Woo00<007ooOol0@goo0W`000<3h00OOol0A7oo000MOol00`?POomoo`0FOol20n0>Ool2O000100O
O0007`0O:goo00<07gooOol05goo00<007ooOol0@Woo0W`000<3h00OOol0AGoo000KOol20n0KOol3
0n0<Ool2O00201l00g`001l07`0WOol201lJOol00`00Oomoo`10Ool3O00201m7Ool001Yoo`030n1o
ogoo01ioo`83h0]oo`=l000301ml07`000807bAoo`0301moogoo01Yoo`03001oogoo03moo`=l0003
01ml07oo04Moo`006Goo00<3h7ooOol08Goo0P?P2goo0W`000@07g`0O01oo`807b1oo`807aeoo`03
001oogoo03ioo`9l00807dYoo`005goo0P?P9Woo0P?P2Woo0W`00P0O0W`000=oo`0O01l077oo0P0O
7goo00<007ooOol0?Goo0W`000<07g`0Ool0BWoo000FOol00`?POomoo`0XOol20n0:Ool2O0000`0O
O01l0002Ool301lFOol301lQOol00`00Oomoo`0kOol2O00201l00g`0Oomoo`1:Ool001Aoo`83h2eo
o`<3h0Qoo`9l00807`03O01oogoo009oo`D07`ioo`<07bAoo`03001oogoo03Yoo`9l000301l3h7`0
04eoo`004goo00<3h7ooOol0<7oo0P?P27oo0W`000<07g`0O0001goo3P0O9goo00<007ooOol0>7oo
0W`00P0O00=l07ooOol0CGoo000BOol00`?POomoo`0cOol20n07Ool2O00201l2O00jOol00`00Oomo
o`0fOol3O0000`0O0n1l001@Ool0015oo`030n1oogoo03Ioo`<3h0Ioo`9l00807`9l03Qoo`03001o
ogoo03Aoo`=l00807`03O01oogoo051oo`004Goo00<3h7ooOol0>Goo0P?P1Woo0W`00P0O0W`0=Woo
00<007ooOol0<Woo0g`00P0O00=l07ooOol0DWoo000@Ool00`?POomoo`0lOol20n06Ool2O00201l2
O00dOol00`00Oomoo`0`Ool3O00201l00g`0Oomoo`1DOol000moo`030n1oogoo03moo`<3h0Eoo`9l
00807`9l039oo`03001oogoo02ioo`9l00040n007`0OO01HOol000ioo`030n1oogoo04=oo`<3h0Ao
o`9l00<07`03O01oogoo02ioo`03001oogoo02aoo`9l00040n007`0OO01JOol000ioo`030n1oogoo
04Ioo`<3h0=oo`=l00807`03O01oogoo02aoo`03001oogoo02Yoo`03O003h0?P00807`03O01oogoo
05Yoo`003Goo00<3h7ooOol0BWoo0`?P0Woo0g`00`0O0g`0:Goo00<007ooOol09Goo0g`00P?P0`0O
00=l07ooOol0G7oo000<Ool00`?POomoo`1>Ool30n000gooO01l0002O00301l2O00WOol00`00Oomo
o`0SOol3O00401l2O01POol0061oo`<3h0El00@07`03O01oogoo029oo`03001oogoo025oo`03O000
7`0O00807`03O01oogoo06=oo`00Hgoo10?P00=oog`0O0000W`00`0O17`07Woo00<007ooOol07Woo
100O0g`0Igoo001WOol60n02O00401l2O00LOol00`00Oomoo`0FOol4O00401l5O01YOol006eoo`H3
h0H07`03O01oogoo01Eoo`03001oogoo019oo`=l00030n007`0O00807`Il06aoo`00LGoo0W`010?P
0W`01P0O0W`01goo1@0017oo00<007ooOol03Woo0g`000<3h00O01l00P0O0W`0M7oo001gOol80n08
01l3O0000`00Oomoo`04Ool00`00Oomoo`04Ool2O00<01l2O01hOol007aoo`Al00L3h1<07`<3h0Ml
07aoo`00Qgoo4g`0QWoo002:Ool00`00Oomoo`04Ool00`00Oomoo`2<Ool008Uoo`8000Ioo`03001o
ogoo08aoo`00TGoo00<007ooOol0S7oo002AOol00`00Oomoo`2<Ool0095oo`03001oogoo08aoo`00
TGoo00<007ooOol0S7oo002AOol00`00Oomoo`2<Ool0095oo`03001oogoo08aoo`00TGoo00<007oo
Ool0S7oo002AOol00`00Oomoo`2<Ool0095oo`03001oogoo08aoo`00TGoo00<007ooOol0S7oo002A
Ool00`00Oomoo`2<Ool0095oo`03001oogoo08aoo`00TGoo00<007ooOol0S7oo002AOol00`00Oomo
o`2<Ool0095oo`03001oogoo08aoo`00TGoo00<007ooOol0S7oo002AOol00`00Oomoo`2<Ool0095o
o`03001oogoo08aoo`00TGoo00<007ooOol0S7oo002AOol00`00Oomoo`2<Ool0095oo`03001oogoo
08aoo`00O7oo1@000Woo0P0017oo0P001Woo00<007ooOol0S7oo001nOol00`00Oomoo`07Ool01000
Oomoo`001Goo00<007ooOol0S7oo001nOol00`00Oomoo`0:Ool00`00Oomoo`03Ool2002=Ool007io
o`03001oogoo00Qoo`8009Eoo`00OWoo00<007ooOol027oo00<007ooOol0U7oo001mOol2000:Ool3
002DOol00?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.63536, -1.61445, \
0.0112783, 0.0182487}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[10]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["A Surface of Equilibrium Points", "Subsection",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell[TextData[{
  "Consider the parameter dependent differential equation ",
  Cell[BoxData[
      \(TraditionalForm\`x' = x\^3\  + mu1\ x\  + mu0\)]],
  ". Equilibria are defined by Feq=0, where"
}], "Text",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell[BoxData[
    \(\(Feq = {x1^3 + mu1*x1 + mu0};\)\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell["\<\
We can find the equilibrium points as a function of parameters with\
\>", "Text",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \({Time, Surf} = 
      Timing[EquilibriumSurface[Feq, {x1}, {mu0, mu1}, {0}, {0, 0}, s, 
          3]]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell[BoxData[
    \("2 vector fields computed."\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    \("2 flow functions computed."\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    \({0.33000000000000007`\ Second, {{s2, \(-s1\)\ s2 - s2\^3, s1}, {s1, 
          s2}}}\)], "Output",
  CellLabel->"Out[12]="]
}, Open  ]],

Cell["\<\
This provides a local representation of the surface around the point x=0, \
mu0=0, mu1=0 (in this example its global). Now, we can graph the surface of \
equilibria:\
\>", "Text",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot3D[\(Surf[\([1]\)]\)[\([{2, 3, 1}]\)], {s1, \(-2\), 
        2}, {s2, \(-1.5\), 
        1.5}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ PlotPoints -> {25, 
          25}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ BoxRatios -> {1, 
          1,  .3}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ AxesEdge -> {None, 
          None, None}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ViewPoint -> { \
.25, \(-1\),  .5}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ Boxed -> 
        False]\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell[BoxData[
    \(ParametricPlot3D::"ppcom" \(\(:\)\(\ \)\) 
      "Function \!\(\(\(Surf \[LeftDoubleBracket] 1 \[RightDoubleBracket]\)\) \
\[LeftDoubleBracket] \(\({2, 3, 1}\)\) \[RightDoubleBracket]\) cannot be \
compiled; plotting will proceed with the uncompiled function."\)], "Message",
  CellLabel->"From In[13]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .56948 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-2.22045e-016 1.08407 -0.137977 1.08407 [
[ 0 0 0 0 ]
[ 1 .56948 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .56948 L
0 .56948 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.40559 .54846 m .38862 .55174 L .38532 .55056 L p .361 .824 .913 r
F P
0 g
s
.40769 .54387 m .40559 .54846 L p .38532 .55056 L .361 .824 .913 r
F P
0 g
s
.40559 .54846 m .40769 .54387 L .44052 .53667 L p .38 .836 .914 r
F P
0 g
s
.44052 .53667 m .43861 .54141 L .40559 .54846 L p .38 .836 .914 r
F P
0 g
s
.38532 .55056 m .38105 .54914 L .40769 .54387 L p .361 .824 .913 r
F P
0 g
s
.43861 .54141 m .44052 .53667 L .4691 .52969 L p .402 .849 .915 r
F P
0 g
s
.4691 .52969 m .4675 .53456 L .43861 .54141 L p .402 .849 .915 r
F P
0 g
s
.4675 .53456 m .4691 .52969 L .4938 .52292 L p .427 .864 .916 r
F P
0 g
s
.4938 .52292 m .49264 .52791 L .4675 .53456 L p .427 .864 .916 r
F P
0 g
s
.40769 .54387 m .38105 .54914 L .37925 .54851 L p .363 .826 .912 r
F P
0 g
s
.49264 .52791 m .4938 .52292 L .51507 .51634 L p .456 .88 .917 r
F P
0 g
s
.51507 .51634 m .51446 .52143 L .49264 .52791 L p .456 .88 .917 r
F P
0 g
s
.37925 .54851 m .37313 .5465 L .4099 .53904 L p .363 .826 .912 r
F P
0 g
s
.4099 .53904 m .40769 .54387 L p .37925 .54851 L .363 .826 .912 r
F P
0 g
s
.51446 .52143 m .51507 .51634 L .53341 .50994 L p .489 .898 .918 r
F P
0 g
s
.53341 .50994 m .53343 .51512 L .51446 .52143 L p .489 .898 .918 r
F P
0 g
s
.40769 .54387 m .4099 .53904 L .44254 .53169 L p .382 .838 .913 r
F P
0 g
s
.44254 .53169 m .44052 .53667 L .40769 .54387 L p .382 .838 .913 r
F P
0 g
s
.53343 .51512 m .53341 .50994 L .54936 .5037 L p .524 .915 .918 r
F P
0 g
s
.54936 .5037 m .55009 .50896 L .53343 .51512 L p .524 .915 .918 r
F P
0 g
s
.55009 .50896 m .54936 .5037 L .56349 .49757 L p .559 .93 .92 r
F P
0 g
s
.56349 .49757 m .56498 .5029 L .55009 .50896 L p .559 .93 .92 r
F P
0 g
s
.56498 .5029 m .56349 .49757 L .5764 .49153 L p .591 .942 .922 r
F P
0 g
s
.5764 .49153 m .57869 .49692 L .56498 .5029 L p .591 .942 .922 r
F P
0 g
s
.57869 .49692 m .5764 .49153 L .58871 .48553 L p .615 .95 .928 r
F P
0 g
s
.58871 .48553 m .59182 .49097 L .57869 .49692 L p .615 .95 .928 r
F P
0 g
s
.44052 .53667 m .44254 .53169 L .47077 .52457 L p .405 .852 .914 r
F P
0 g
s
.47077 .52457 m .4691 .52969 L .44052 .53667 L p .405 .852 .914 r
F P
0 g
s
.59182 .49097 m .58871 .48553 L .60103 .47953 L p .629 .951 .936 r
F P
0 g
s
.60103 .47953 m .60497 .48501 L .59182 .49097 L p .629 .951 .936 r
F P
0 g
s
.60497 .48501 m .60103 .47953 L .614 .47345 L p .631 .948 .946 r
F P
0 g
s
.614 .47345 m .61878 .47898 L .60497 .48501 L p .631 .948 .946 r
F P
0 g
s
.61878 .47898 m .614 .47345 L .62829 .46726 L p .624 .94 .957 r
F P
0 g
s
.62829 .46726 m .63388 .47284 L .61878 .47898 L p .624 .94 .957 r
F P
0 g
s
.63388 .47284 m .62829 .46726 L .64455 .46089 L p .609 .928 .966 r
F P
0 g
s
.64455 .46089 m .65094 .46651 L .63388 .47284 L p .609 .928 .966 r
F P
0 g
s
.4691 .52969 m .47077 .52457 L .49501 .51767 L p .432 .867 .914 r
F P
0 g
s
.49501 .51767 m .4938 .52292 L .4691 .52969 L p .432 .867 .914 r
F P
0 g
s
.65094 .46651 m .64455 .46089 L .66348 .45425 L p .591 .915 .975 r
F P
0 g
s
.66348 .45425 m .67063 .45993 L .65094 .46651 L p .591 .915 .975 r
F P
0 g
s
.4099 .53904 m .37313 .5465 L .37303 .54646 L p .365 .827 .911 r
F P
0 g
s
.37303 .54646 m .37268 .54635 L p .41223 .53395 L .365 .827 .911 r
F P
0 g
s
.41223 .53395 m .4099 .53904 L p .37303 .54646 L .365 .827 .911 r
F P
0 g
s
.37268 .54635 m .37493 .5417 L .41223 .53395 L p .365 .827 .911 r
F P
0 g
s
.37493 .5417 m .37268 .54635 L .3664 .54413 L p .348 .816 .91 r
F P
0 g
s
.67063 .45993 m .66348 .45425 L .68582 .44728 L p .572 .902 .981 r
F P
0 g
s
.68582 .44728 m .69369 .45303 L .67063 .45993 L p .572 .902 .981 r
F P
0 g
s
.4938 .52292 m .49501 .51767 L .51571 .51099 L p .463 .885 .914 r
F P
0 g
s
.51571 .51099 m .51507 .51634 L .4938 .52292 L p .463 .885 .914 r
F P
0 g
s
.69369 .45303 m .68582 .44728 L .71234 .43989 L p .554 .89 .985 r
F P
0 g
s
.71234 .43989 m .72088 .44571 L .69369 .45303 L p .554 .89 .985 r
F P
0 g
s
.51507 .51634 m .51571 .51099 L .53338 .50451 L p .498 .903 .914 r
F P
0 g
s
.53338 .50451 m .53341 .50994 L .51507 .51634 L p .498 .903 .914 r
F P
0 g
s
.4099 .53904 m .41223 .53395 L .44465 .52644 L p .385 .84 .912 r
F P
0 g
s
.44465 .52644 m .44254 .53169 L .4099 .53904 L p .385 .84 .912 r
F P
0 g
s
.53341 .50994 m .53338 .50451 L .54859 .49819 L p .536 .921 .913 r
F P
0 g
s
.54859 .49819 m .54936 .5037 L .53341 .50994 L p .536 .921 .913 r
F P
0 g
s
.72088 .44571 m .71234 .43989 L .74389 .43198 L p .537 .879 .988 r
F P
0 g
s
.74389 .43198 m .75304 .43789 L .72088 .44571 L p .537 .879 .988 r
F P
0 g
s
.54936 .5037 m .54859 .49819 L .56193 .492 L p .574 .938 .913 r
F P
0 g
s
.56193 .492 m .56349 .49757 L .54936 .5037 L p .574 .938 .913 r
F P
0 g
s
.56349 .49757 m .56193 .492 L .57401 .4859 L p .608 .95 .915 r
F P
0 g
s
.57401 .4859 m .5764 .49153 L .56349 .49757 L p .608 .95 .915 r
F P
0 g
s
.5764 .49153 m .57401 .4859 L .58545 .47985 L p .634 .958 .92 r
F P
0 g
s
.58545 .47985 m .58871 .48553 L .5764 .49153 L p .634 .958 .92 r
F P
0 g
s
.58871 .48553 m .58545 .47985 L .5969 .47379 L p .648 .96 .928 r
F P
0 g
s
.5969 .47379 m .60103 .47953 L .58871 .48553 L p .648 .96 .928 r
F P
0 g
s
.60103 .47953 m .5969 .47379 L .60901 .46768 L p .65 .956 .94 r
F P
0 g
s
.60901 .46768 m .614 .47345 L .60103 .47953 L p .65 .956 .94 r
F P
0 g
s
.614 .47345 m .60901 .46768 L .62244 .46144 L p .64 .947 .952 r
F P
0 g
s
.62244 .46144 m .62829 .46726 L .614 .47345 L p .64 .947 .952 r
F P
0 g
s
.44254 .53169 m .44465 .52644 L .47254 .51918 L p .409 .854 .912 r
F P
0 g
s
.47254 .51918 m .47077 .52457 L .44254 .53169 L p .409 .854 .912 r
F P
0 g
s
.62829 .46726 m .62244 .46144 L .63788 .45501 L p .623 .934 .964 r
F P
0 g
s
.63788 .45501 m .64455 .46089 L .62829 .46726 L p .623 .934 .964 r
F P
0 g
s
.75304 .43789 m .74389 .43198 L .78141 .42343 L p .523 .87 .99 r
F P
0 g
s
.78141 .42343 m .7911 .42945 L .75304 .43789 L p .523 .87 .99 r
F P
0 g
s
.3664 .54413 m .36483 .54361 L .37493 .5417 L p .348 .816 .91 r
F P
0 g
s
.64455 .46089 m .63788 .45501 L .65602 .44833 L p .602 .92 .973 r
F P
0 g
s
.65602 .44833 m .66348 .45425 L .64455 .46089 L p .602 .92 .973 r
F P
0 g
s
.66348 .45425 m .65602 .44833 L .67762 .44129 L p .581 .906 .98 r
F P
0 g
s
.67762 .44129 m .68582 .44728 L .66348 .45425 L p .581 .906 .98 r
F P
0 g
s
.47077 .52457 m .47254 .51918 L .49629 .51216 L p .437 .871 .912 r
F P
0 g
s
.49629 .51216 m .49501 .51767 L .47077 .52457 L p .437 .871 .912 r
F P
0 g
s
.37493 .5417 m .36483 .54361 L .35957 .54176 L p .349 .818 .909 r
F P
0 g
s
.37744 .53653 m .37493 .5417 L p .35957 .54176 L .349 .818 .909 r
F P
0 g
s
.37493 .5417 m .37744 .53653 L .41469 .52858 L p .367 .829 .91 r
F P
0 g
s
.41469 .52858 m .41223 .53395 L .37493 .5417 L p .367 .829 .91 r
F P
0 g
s
.68582 .44728 m .67762 .44129 L .70345 .43383 L p .56 .893 .984 r
F P
0 g
s
.70345 .43383 m .71234 .43989 L .68582 .44728 L p .56 .893 .984 r
F P
0 g
s
.7911 .42945 m .78141 .42343 L p .81229 .42014 L .511 .861 .991 r
F P
0 g
s
.81229 .42014 m .81126 .42534 L .7911 .42945 L p .511 .861 .991 r
F P
0 g
s
.49501 .51767 m .49629 .51216 L .51638 .50538 L p .47 .889 .911 r
F P
0 g
s
.51638 .50538 m .51571 .51099 L .49501 .51767 L p .47 .889 .911 r
F P
0 g
s
.71234 .43989 m .70345 .43383 L .73437 .42583 L p .542 .882 .988 r
F P
0 g
s
.73437 .42583 m .74389 .43198 L .71234 .43989 L p .542 .882 .988 r
F P
0 g
s
.51571 .51099 m .51638 .50538 L .53336 .4988 L p .508 .908 .91 r
F P
0 g
s
.53336 .4988 m .53338 .50451 L .51571 .51099 L p .508 .908 .91 r
F P
0 g
s
.53338 .50451 m .53336 .4988 L .54779 .4924 L p .549 .928 .907 r
F P
0 g
s
.54779 .4924 m .54859 .49819 L .53338 .50451 L p .549 .928 .907 r
F P
0 g
s
.41223 .53395 m .41469 .52858 L .44689 .52091 L p .388 .842 .911 r
F P
0 g
s
.44689 .52091 m .44465 .52644 L .41223 .53395 L p .388 .842 .911 r
F P
0 g
s
.54859 .49819 m .54779 .4924 L .56029 .48614 L p .59 .945 .905 r
F P
0 g
s
.56029 .48614 m .56193 .492 L .54859 .49819 L p .59 .945 .905 r
F P
0 g
s
.56193 .492 m .56029 .48614 L .57149 .47999 L p .627 .959 .906 r
F P
0 g
s
.57149 .47999 m .57401 .4859 L .56193 .492 L p .627 .959 .906 r
F P
0 g
s
.57401 .4859 m .57149 .47999 L .58204 .47389 L p .656 .967 .91 r
F P
0 g
s
.58204 .47389 m .58545 .47985 L .57401 .4859 L p .656 .967 .91 r
F P
0 g
s
.58545 .47985 m .58204 .47389 L .59258 .46779 L p .67 .969 .919 r
F P
0 g
s
.59258 .46779 m .5969 .47379 L .58545 .47985 L p .67 .969 .919 r
F P
0 g
s
.5969 .47379 m .59258 .46779 L .60378 .46163 L p .671 .964 .932 r
F P
0 g
s
.60378 .46163 m .60901 .46768 L .5969 .47379 L p .671 .964 .932 r
F P
0 g
s
.74389 .43198 m .73437 .42583 L .77133 .41717 L p .527 .871 .99 r
F P
0 g
s
.77133 .41717 m .78141 .42343 L .74389 .43198 L p .527 .871 .99 r
F P
0 g
s
.35957 .54176 m .35613 .54063 L .37744 .53653 L p .349 .818 .909 r
F P
0 g
s
.60901 .46768 m .60378 .46163 L .61633 .45535 L p .659 .954 .946 r
F P
0 g
s
.61633 .45535 m .62244 .46144 L .60901 .46768 L p .659 .954 .946 r
F P
0 g
s
.62244 .46144 m .61633 .45535 L .63091 .44888 L p .639 .941 .96 r
F P
0 g
s
.63091 .44888 m .63788 .45501 L .62244 .46144 L p .639 .941 .96 r
F P
0 g
s
.63788 .45501 m .63091 .44888 L .64824 .44214 L p .615 .926 .97 r
F P
0 g
s
.64824 .44214 m .65602 .44833 L .63788 .45501 L p .615 .926 .97 r
F P
0 g
s
.44465 .52644 m .44689 .52091 L .4744 .5135 L p .413 .857 .911 r
F P
0 g
s
.4744 .5135 m .47254 .51918 L .44465 .52644 L p .413 .857 .911 r
F P
0 g
s
.65602 .44833 m .64824 .44214 L .66906 .43505 L p .59 .911 .978 r
F P
0 g
s
.66906 .43505 m .67762 .44129 L .65602 .44833 L p .59 .911 .978 r
F P
0 g
s
.78141 .42343 m .81295 .41684 L .81229 .42014 L p .511 .861 .991 r
F P
0 g
s
.78141 .42343 m .77133 .41717 L p .81467 .40807 L .513 .863 .991 r
F P
0 g
s
.81467 .40807 m .81295 .41684 L .78141 .42343 L p .513 .863 .991 r
F P
0 g
s
.67762 .44129 m .66906 .43505 L .69418 .42751 L p .567 .897 .984 r
F P
0 g
s
.69418 .42751 m .70345 .43383 L .67762 .44129 L p .567 .897 .984 r
F P
0 g
s
.37744 .53653 m .35613 .54063 L .35254 .53939 L p .351 .819 .909 r
F P
0 g
s
.47254 .51918 m .4744 .5135 L .49763 .50636 L p .443 .875 .91 r
F P
0 g
s
.49763 .50636 m .49629 .51216 L .47254 .51918 L p .443 .875 .91 r
F P
0 g
s
.70345 .43383 m .69418 .42751 L .72445 .41941 L p .547 .884 .987 r
F P
0 g
s
.72445 .41941 m .73437 .42583 L .70345 .43383 L p .547 .884 .987 r
F P
0 g
s
.38009 .53106 m .37744 .53653 L p .35254 .53939 L .351 .819 .909 r
F P
0 g
s
.37744 .53653 m .38009 .53106 L .41728 .52292 L p .369 .831 .909 r
F P
0 g
s
.41728 .52292 m .41469 .52858 L .37744 .53653 L p .369 .831 .909 r
F P
0 g
s
.49629 .51216 m .49763 .50636 L .51709 .49946 L p .478 .894 .908 r
F P
0 g
s
.51709 .49946 m .51638 .50538 L .49629 .51216 L p .478 .894 .908 r
F P
0 g
s
.51638 .50538 m .51709 .49946 L .53333 .49279 L p .518 .914 .904 r
F P
0 g
s
.53333 .49279 m .53336 .4988 L .51638 .50538 L p .518 .914 .904 r
F P
0 g
s
.35254 .53939 m .34698 .53758 L .38009 .53106 L p .351 .819 .909 r
F P
0 g
s
.73437 .42583 m .72445 .41941 L .76083 .41065 L p .531 .873 .99 r
F P
0 g
s
.76083 .41065 m .77133 .41717 L .73437 .42583 L p .531 .873 .99 r
F P
0 g
s
.53336 .4988 m .53333 .49279 L .54695 .48631 L p .563 .935 .9 r
F P
0 g
s
.54695 .48631 m .54779 .4924 L .53336 .4988 L p .563 .935 .9 r
F P
0 g
s
.54779 .4924 m .54695 .48631 L .55857 .48 L p .609 .954 .896 r
F P
0 g
s
.55857 .48 m .56029 .48614 L .54779 .4924 L p .609 .954 .896 r
F P
0 g
s
.56029 .48614 m .55857 .48 L .56886 .47379 L p .65 .968 .893 r
F P
0 g
s
.56886 .47379 m .57149 .47999 L .56029 .48614 L p .65 .968 .893 r
F P
0 g
s
.58805 .4615 m .59258 .46779 L .58204 .47389 L p .696 .978 .906 r
F P
0 g
s
.59258 .46779 m .58805 .4615 L .59831 .4553 L p .695 .973 .922 r
F P
0 g
s
.59831 .4553 m .60378 .46163 L .59258 .46779 L p .695 .973 .922 r
F P
0 g
s
.57846 .46764 m .58204 .47389 L .57149 .47999 L p .68 .976 .896 r
F P
0 g
s
.58204 .47389 m .57846 .46764 L .58805 .4615 L p .696 .978 .906 r
F P
0 g
s
.57149 .47999 m .56886 .47379 L .57846 .46764 L p .68 .976 .896 r
F P
0 g
s
.60378 .46163 m .59831 .4553 L .60994 .44898 L p .68 .962 .939 r
F P
0 g
s
.60994 .44898 m .61633 .45535 L .60378 .46163 L p .68 .962 .939 r
F P
0 g
s
.61633 .45535 m .60994 .44898 L .62363 .44247 L p .656 .948 .955 r
F P
0 g
s
.62363 .44247 m .63091 .44888 L .61633 .45535 L p .656 .948 .955 r
F P
0 g
s
.41469 .52858 m .41728 .52292 L .44925 .51507 L p .391 .844 .91 r
F P
0 g
s
.44925 .51507 m .44689 .52091 L .41469 .52858 L p .391 .844 .91 r
F P
0 g
s
.63091 .44888 m .62363 .44247 L .6401 .43568 L p .628 .932 .968 r
F P
0 g
s
.6401 .43568 m .64824 .44214 L .63091 .44888 L p .628 .932 .968 r
F P
0 g
s
.64824 .44214 m .6401 .43568 L .66013 .42852 L p .601 .915 .977 r
F P
0 g
s
.66013 .42852 m .66906 .43505 L .64824 .44214 L p .601 .915 .977 r
F P
0 g
s
.77133 .41717 m .81471 .40788 L .81467 .40807 L p .513 .863 .991 r
F P
0 g
s
.77133 .41717 m .76083 .41065 L .80441 .40107 L p .516 .864 .991 r
F P
0 g
s
.81471 .40788 m .77133 .41717 L p .80441 .40107 L .516 .864 .991 r
F P
0 g
s
.66906 .43505 m .66013 .42852 L .6845 .42091 L p .575 .9 .983 r
F P
0 g
s
.6845 .42091 m .69418 .42751 L .66906 .43505 L p .575 .9 .983 r
F P
0 g
s
.44689 .52091 m .44925 .51507 L .47636 .50751 L p .417 .86 .909 r
F P
0 g
s
.47636 .50751 m .4744 .5135 L .44689 .52091 L p .417 .86 .909 r
F P
0 g
s
.38009 .53106 m .34698 .53758 L .3453 .53701 L p .353 .82 .908 r
F P
0 g
s
.69418 .42751 m .6845 .42091 L .7141 .41273 L p .553 .887 .987 r
F P
0 g
s
.7141 .41273 m .72445 .41941 L .69418 .42751 L p .553 .887 .987 r
F P
0 g
s
.4744 .5135 m .47636 .50751 L .49905 .50023 L p .449 .878 .907 r
F P
0 g
s
.49905 .50023 m .49763 .50636 L .4744 .5135 L p .449 .878 .907 r
F P
0 g
s
.3453 .53701 m .33952 .53516 L p .3829 .52527 L .353 .82 .908 r
F P
0 g
s
.3829 .52527 m .38009 .53106 L p .3453 .53701 L .353 .82 .908 r
F P
0 g
s
.80441 .40107 m .81481 .40737 L .81471 .40788 L p .516 .864 .991 r
F P
0 g
s
.81481 .40737 m .80441 .40107 L .81657 .39861 L closepath p .504 .858 .991 r
F P
0 g
s
.72445 .41941 m .7141 .41273 L .74989 .40385 L p .535 .875 .99 r
F P
0 g
s
.74989 .40385 m .76083 .41065 L .72445 .41941 L p .535 .875 .99 r
F P
0 g
s
.49763 .50636 m .49905 .50023 L .51784 .49323 L p .487 .899 .904 r
F P
0 g
s
.51784 .49323 m .51709 .49946 L .49763 .50636 L p .487 .899 .904 r
F P
0 g
s
.38009 .53106 m .3829 .52527 L .42002 .51692 L p .372 .833 .908 r
F P
0 g
s
.42002 .51692 m .41728 .52292 L .38009 .53106 L p .372 .833 .908 r
F P
0 g
s
.51709 .49946 m .51784 .49323 L .5333 .48646 L p .53 .921 .898 r
F P
0 g
s
.5333 .48646 m .53333 .49279 L .51709 .49946 L p .53 .921 .898 r
F P
0 g
s
.59258 .44867 m .59831 .4553 L .58805 .4615 L p .722 .981 .908 r
F P
0 g
s
.59831 .4553 m .59258 .44867 L .60324 .44231 L p .704 .971 .929 r
F P
0 g
s
.60324 .44231 m .60994 .44898 L .59831 .4553 L p .704 .971 .929 r
F P
0 g
s
.53333 .49279 m .5333 .48646 L .54606 .47991 L p .579 .943 .891 r
F P
0 g
s
.54606 .47991 m .54695 .48631 L .53333 .49279 L p .579 .943 .891 r
F P
0 g
s
.5833 .4549 m .58805 .4615 L .57846 .46764 L p .724 .986 .889 r
F P
0 g
s
.58805 .4615 m .5833 .4549 L .59258 .44867 L p .722 .981 .908 r
F P
0 g
s
.60994 .44898 m .60324 .44231 L .616 .43576 L p .675 .955 .949 r
F P
0 g
s
.616 .43576 m .62363 .44247 L .60994 .44898 L p .675 .955 .949 r
F P
0 g
s
.5747 .46108 m .57846 .46764 L .56886 .47379 L p .708 .985 .879 r
F P
0 g
s
.57846 .46764 m .5747 .46108 L .5833 .4549 L p .724 .986 .889 r
F P
0 g
s
.54695 .48631 m .54606 .47991 L .55677 .47353 L p .629 .962 .883 r
F P
0 g
s
.55677 .47353 m .55857 .48 L .54695 .48631 L p .629 .962 .883 r
F P
0 g
s
.56608 .46727 m .56886 .47379 L .55857 .48 L p .675 .976 .878 r
F P
0 g
s
.56886 .47379 m .56608 .46727 L .5747 .46108 L p .708 .985 .879 r
F P
0 g
s
.62363 .44247 m .616 .43576 L .6316 .42892 L p .643 .938 .964 r
F P
0 g
s
.6316 .42892 m .6401 .43568 L .62363 .44247 L p .643 .938 .964 r
F P
0 g
s
.55857 .48 m .55677 .47353 L .56608 .46727 L p .675 .976 .878 r
F P
0 g
s
.76083 .41065 m .74989 .40385 L .79296 .39414 L p .52 .866 .991 r
F P
0 g
s
.79296 .39414 m .80441 .40107 L .76083 .41065 L p .52 .866 .991 r
F P
0 g
s
.6401 .43568 m .6316 .42892 L .65079 .42171 L p .612 .92 .975 r
F P
0 g
s
.65079 .42171 m .66013 .42852 L .6401 .43568 L p .612 .92 .975 r
F P
0 g
s
.41728 .52292 m .42002 .51692 L .45174 .50889 L p .395 .847 .908 r
F P
0 g
s
.45174 .50889 m .44925 .51507 L .41728 .52292 L p .395 .847 .908 r
F P
0 g
s
.66013 .42852 m .65079 .42171 L .67439 .41402 L p .584 .904 .982 r
F P
0 g
s
.67439 .41402 m .6845 .42091 L .66013 .42852 L p .584 .904 .982 r
F P
0 g
s
.34012 .53391 m .33952 .53516 L .33779 .53456 L p .337 .81 .907 r
F P
0 g
s
.33952 .53516 m .34012 .53391 L .3829 .52527 L p .353 .82 .908 r
F P
0 g
s
.6845 .42091 m .67439 .41402 L .70329 .40574 L p .559 .89 .987 r
F P
0 g
s
.70329 .40574 m .7141 .41273 L .6845 .42091 L p .559 .89 .987 r
F P
0 g
s
.33779 .53456 m .33736 .53441 L .34012 .53391 L p .337 .81 .907 r
F P
0 g
s
.80441 .40107 m .79296 .39414 L p .81719 .39546 L .507 .858 .992 r
F P
0 g
s
.81719 .39546 m .81657 .39861 L .80441 .40107 L p .507 .858 .992 r
F P
0 g
s
.44925 .51507 m .45174 .50889 L .47843 .50117 L p .422 .863 .907 r
F P
0 g
s
.47843 .50117 m .47636 .50751 L .44925 .51507 L p .422 .863 .907 r
F P
0 g
s
.34012 .53391 m .33736 .53441 L .32981 .5318 L p .338 .811 .907 r
F P
0 g
s
.34295 .52802 m .34012 .53391 L p .32981 .5318 L .338 .811 .907 r
F P
0 g
s
.34012 .53391 m .34295 .52802 L .38587 .51913 L p .355 .822 .907 r
F P
0 g
s
.38587 .51913 m .3829 .52527 L .34012 .53391 L p .355 .822 .907 r
F P
0 g
s
.7141 .41273 m .70329 .40574 L .73846 .39675 L p .539 .878 .989 r
F P
0 g
s
.73846 .39675 m .74989 .40385 L .7141 .41273 L p .539 .878 .989 r
F P
0 g
s
.47636 .50751 m .47843 .50117 L .50054 .49377 L p .456 .883 .904 r
F P
0 g
s
.50054 .49377 m .49905 .50023 L .47636 .50751 L p .456 .883 .904 r
F P
0 g
s
.49905 .50023 m .50054 .49377 L .51862 .48665 L p .496 .904 .899 r
F P
0 g
s
.51862 .48665 m .51784 .49323 L .49905 .50023 L p .496 .904 .899 r
F P
0 g
s
.79296 .39414 m .81852 .38883 L .81719 .39546 L p .507 .858 .992 r
F P
0 g
s
.59622 .43532 m .60324 .44231 L .59258 .44867 L p .731 .979 .916 r
F P
0 g
s
.60324 .44231 m .59622 .43532 L .60802 .42873 L p .697 .963 .941 r
F P
0 g
s
.60802 .42873 m .616 .43576 L .60324 .44231 L p .697 .963 .941 r
F P
0 g
s
.74989 .40385 m .73846 .39675 L .78101 .3869 L p .523 .867 .991 r
F P
0 g
s
.78101 .3869 m .79296 .39414 L .74989 .40385 L p .523 .867 .991 r
F P
0 g
s
.58656 .44171 m .59258 .44867 L .5833 .4549 L p .753 .99 .889 r
F P
0 g
s
.59258 .44867 m .58656 .44171 L .59622 .43532 L p .731 .979 .916 r
F P
0 g
s
.616 .43576 m .60802 .42873 L .62269 .42184 L p .66 .945 .96 r
F P
0 g
s
.62269 .42184 m .6316 .42892 L .616 .43576 L p .66 .945 .96 r
F P
0 g
s
.57831 .44797 m .5833 .4549 L .5747 .46108 L p .756 .994 .867 r
F P
0 g
s
.5833 .4549 m .57831 .44797 L .58656 .44171 L p .753 .99 .889 r
F P
0 g
s
.51784 .49323 m .51862 .48665 L .53327 .47979 L p .544 .928 .891 r
F P
0 g
s
.53327 .47979 m .5333 .48646 L .51784 .49323 L p .544 .928 .891 r
F P
0 g
s
.3829 .52527 m .38587 .51913 L .42293 .51057 L p .374 .834 .907 r
F P
0 g
s
.42293 .51057 m .42002 .51692 L .3829 .52527 L p .374 .834 .907 r
F P
0 g
s
.57075 .45419 m .5747 .46108 L .56608 .46727 L p .739 .992 .855 r
F P
0 g
s
.5747 .46108 m .57075 .45419 L .57831 .44797 L p .756 .994 .867 r
F P
0 g
s
.6316 .42892 m .62269 .42184 L .64102 .41457 L p .625 .926 .973 r
F P
0 g
s
.64102 .41457 m .65079 .42171 L .6316 .42892 L p .625 .926 .973 r
F P
0 g
s
.56317 .46042 m .56608 .46727 L .55677 .47353 L p .703 .985 .856 r
F P
0 g
s
.56608 .46727 m .56317 .46042 L .57075 .45419 L p .739 .992 .855 r
F P
0 g
s
.5333 .48646 m .53327 .47979 L .54513 .47317 L p .598 .951 .879 r
F P
0 g
s
.54513 .47317 m .54606 .47991 L .5333 .48646 L p .598 .951 .879 r
F P
0 g
s
.55486 .46672 m .55677 .47353 L .54606 .47991 L p .653 .97 .867 r
F P
0 g
s
.55677 .47353 m .55486 .46672 L .56317 .46042 L p .703 .985 .856 r
F P
0 g
s
.54606 .47991 m .54513 .47317 L .55486 .46672 L p .653 .97 .867 r
F P
0 g
s
.65079 .42171 m .64102 .41457 L .66383 .40681 L p .593 .908 .981 r
F P
0 g
s
.66383 .40681 m .67439 .41402 L .65079 .42171 L p .593 .908 .981 r
F P
0 g
s
.67439 .41402 m .66383 .40681 L .692 .39845 L p .566 .893 .986 r
F P
0 g
s
.692 .39845 m .70329 .40574 L .67439 .41402 L p .566 .893 .986 r
F P
0 g
s
.32981 .5318 m .32725 .53096 L .34295 .52802 L p .338 .811 .907 r
F P
0 g
s
.79296 .39414 m .78101 .3869 L p .81991 .38169 L .51 .859 .992 r
F P
0 g
s
.81991 .38169 m .81852 .38883 L .79296 .39414 L p .51 .859 .992 r
F P
0 g
s
.42002 .51692 m .42293 .51057 L .45438 .50235 L p .398 .849 .907 r
F P
0 g
s
.45438 .50235 m .45174 .50889 L .42002 .51692 L p .398 .849 .907 r
F P
0 g
s
.70329 .40574 m .692 .39845 L .72653 .38934 L p .544 .88 .989 r
F P
0 g
s
.72653 .38934 m .73846 .39675 L .70329 .40574 L p .544 .88 .989 r
F P
0 g
s
.34295 .52802 m .32725 .53096 L .32155 .52901 L p .34 .812 .906 r
F P
0 g
s
.45174 .50889 m .45438 .50235 L .48062 .49447 L p .427 .867 .904 r
F P
0 g
s
.48062 .49447 m .47843 .50117 L .45174 .50889 L p .427 .867 .904 r
F P
0 g
s
.34596 .52176 m .34295 .52802 L p .32155 .52901 L .34 .812 .906 r
F P
0 g
s
.34295 .52802 m .34596 .52176 L .38903 .51262 L p .357 .823 .907 r
F P
0 g
s
.38903 .51262 m .38587 .51913 L .34295 .52802 L p .357 .823 .907 r
F P
0 g
s
.73846 .39675 m .72653 .38934 L .76853 .37935 L p .527 .869 .991 r
F P
0 g
s
.76853 .37935 m .78101 .3869 L .73846 .39675 L p .527 .869 .991 r
F P
0 g
s
.47843 .50117 m .48062 .49447 L .50213 .48692 L p .463 .887 .9 r
F P
0 g
s
.50213 .48692 m .50054 .49377 L .47843 .50117 L p .463 .887 .9 r
F P
0 g
s
.58885 .42798 m .59622 .43532 L .58656 .44171 L p .761 .987 .899 r
F P
0 g
s
.59622 .43532 m .58885 .42798 L .59964 .42135 L p .722 .971 .931 r
F P
0 g
s
.59964 .42135 m .60802 .42873 L .59622 .43532 L p .722 .971 .931 r
F P
0 g
s
.60802 .42873 m .59964 .42135 L .61335 .41442 L p .679 .952 .954 r
F P
0 g
s
.61335 .41442 m .62269 .42184 L .60802 .42873 L p .679 .952 .954 r
F P
0 g
s
.58024 .43439 m .58656 .44171 L .57831 .44797 L p .787 .996 .864 r
F P
0 g
s
.58656 .44171 m .58024 .43439 L .58885 .42798 L p .761 .987 .899 r
F P
0 g
s
.62269 .42184 m .61335 .41442 L .63079 .4071 L p .639 .931 .97 r
F P
0 g
s
.63079 .4071 m .64102 .41457 L .62269 .42184 L p .639 .931 .97 r
F P
0 g
s
.57306 .44069 m .57831 .44797 L .57075 .45419 L p .793 .999 .835 r
F P
0 g
s
.57831 .44797 m .57306 .44069 L .58024 .43439 L p .787 .996 .864 r
F P
0 g
s
.50054 .49377 m .50213 .48692 L .51946 .47969 L p .507 .91 .893 r
F P
0 g
s
.51946 .47969 m .51862 .48665 L .50054 .49377 L p .507 .91 .893 r
F P
0 g
s
.56659 .44693 m .57075 .45419 L .56317 .46042 L p .775 .997 .822 r
F P
0 g
s
.57075 .45419 m .56659 .44693 L .57306 .44069 L p .793 .999 .835 r
F P
0 g
s
.64102 .41457 m .63079 .4071 L .65277 .39927 L p .603 .912 .979 r
F P
0 g
s
.65277 .39927 m .66383 .40681 L .64102 .41457 L p .603 .912 .979 r
F P
0 g
s
.5601 .45319 m .56317 .46042 L .55486 .46672 L p .735 .991 .828 r
F P
0 g
s
.56317 .46042 m .5601 .45319 L .56659 .44693 L p .775 .997 .822 r
F P
0 g
s
.51862 .48665 m .51946 .47969 L .53324 .47275 L p .559 .935 .881 r
F P
0 g
s
.53324 .47275 m .53327 .47979 L .51862 .48665 L p .559 .935 .881 r
F P
0 g
s
.55285 .45955 m .55486 .46672 L .54513 .47317 L p .68 .978 .845 r
F P
0 g
s
.55486 .46672 m .55285 .45955 L .5601 .45319 L p .735 .991 .828 r
F P
0 g
s
.32155 .52901 m .31658 .5274 L .34596 .52176 L p .34 .812 .906 r
F P
0 g
s
.53327 .47979 m .53324 .47275 L .54414 .46604 L p .618 .959 .865 r
F P
0 g
s
.54414 .46604 m .54513 .47317 L .53327 .47979 L p .618 .959 .865 r
F P
0 g
s
.54513 .47317 m .54414 .46604 L .55285 .45955 L p .68 .978 .845 r
F P
0 g
s
.38587 .51913 m .38903 .51262 L .42601 .50384 L p .377 .836 .906 r
F P
0 g
s
.42601 .50384 m .42293 .51057 L .38587 .51913 L p .377 .836 .906 r
F P
0 g
s
.66383 .40681 m .65277 .39927 L .68019 .39082 L p .573 .896 .985 r
F P
0 g
s
.68019 .39082 m .692 .39845 L .66383 .40681 L p .573 .896 .985 r
F P
0 g
s
.78101 .3869 m .82054 .37849 L .81991 .38169 L p .51 .859 .992 r
F P
0 g
s
.78101 .3869 m .76853 .37935 L .81929 .36827 L p .512 .86 .992 r
F P
0 g
s
.82054 .37849 m .78101 .3869 L p .81929 .36827 L .512 .86 .992 r
F P
0 g
s
.692 .39845 m .68019 .39082 L .71406 .3816 L p .549 .882 .989 r
F P
0 g
s
.71406 .3816 m .72653 .38934 L .692 .39845 L p .549 .882 .989 r
F P
0 g
s
.42293 .51057 m .42601 .50384 L .45719 .49542 L p .402 .852 .905 r
F P
0 g
s
.45719 .49542 m .45438 .50235 L .42293 .51057 L p .402 .852 .905 r
F P
0 g
s
.81929 .36827 m .82218 .37 L .82054 .37849 L p .512 .86 .992 r
F P
0 g
s
.34596 .52176 m .31658 .5274 L .31303 .52619 L p .341 .814 .906 r
F P
0 g
s
.72653 .38934 m .71406 .3816 L .7555 .37145 L p .53 .871 .991 r
F P
0 g
s
.7555 .37145 m .76853 .37935 L .72653 .38934 L p .53 .871 .991 r
F P
0 g
s
.45438 .50235 m .45719 .49542 L .48295 .48737 L p .433 .87 .902 r
F P
0 g
s
.48295 .48737 m .48062 .49447 L .45438 .50235 L p .433 .87 .902 r
F P
0 g
s
.59084 .41361 m .59964 .42135 L .58885 .42798 L p .751 .979 .917 r
F P
0 g
s
.59964 .42135 m .59084 .41361 L .60356 .40664 L p .701 .959 .947 r
F P
0 g
s
.60356 .40664 m .61335 .41442 L .59964 .42135 L p .701 .959 .947 r
F P
0 g
s
.58111 .42026 m .58885 .42798 L .58024 .43439 L p .796 .993 .875 r
F P
0 g
s
.58885 .42798 m .58111 .42026 L .59084 .41361 L p .751 .979 .917 r
F P
0 g
s
.61335 .41442 m .60356 .40664 L .62006 .39927 L p .654 .937 .966 r
F P
0 g
s
.62006 .39927 m .63079 .4071 L .61335 .41442 L p .654 .937 .966 r
F P
0 g
s
.57359 .4267 m .58024 .43439 L .57306 .44069 L p .826 .999 .829 r
F P
0 g
s
.58024 .43439 m .57359 .4267 L .58111 .42026 L p .796 .993 .875 r
F P
0 g
s
.34916 .51511 m .34596 .52176 L p .31303 .52619 L .341 .814 .906 r
F P
0 g
s
.34596 .52176 m .34916 .51511 L .39239 .5057 L p .359 .825 .906 r
F P
0 g
s
.39239 .5057 m .38903 .51262 L .34596 .52176 L p .359 .825 .906 r
F P
0 g
s
.63079 .4071 m .62006 .39927 L .64118 .39137 L p .614 .917 .978 r
F P
0 g
s
.64118 .39137 m .65277 .39927 L .63079 .4071 L p .614 .917 .978 r
F P
0 g
s
.31303 .52619 m .3053 .52371 L .34916 .51511 L p .341 .814 .906 r
F P
0 g
s
.56754 .43301 m .57306 .44069 L .56659 .44693 L p .832 .999 .791 r
F P
0 g
s
.57306 .44069 m .56754 .43301 L .57359 .4267 L p .826 .999 .829 r
F P
0 g
s
.48062 .49447 m .48295 .48737 L .5038 .47968 L p .471 .892 .896 r
F P
0 g
s
.5038 .47968 m .50213 .48692 L .48062 .49447 L p .471 .892 .896 r
F P
0 g
s
.56221 .43928 m .56659 .44693 L .5601 .45319 L p .813 .997 .777 r
F P
0 g
s
.56659 .44693 m .56221 .43928 L .56754 .43301 L p .832 .999 .791 r
F P
0 g
s
.76853 .37935 m .7555 .37145 L .80581 .36019 L p .515 .861 .992 r
F P
0 g
s
.80581 .36019 m .81929 .36827 L .76853 .37935 L p .515 .861 .992 r
F P
0 g
s
.65277 .39927 m .64118 .39137 L .66783 .38283 L p .581 .9 .985 r
F P
0 g
s
.66783 .38283 m .68019 .39082 L .65277 .39927 L p .581 .9 .985 r
F P
0 g
s
.55686 .44557 m .5601 .45319 L .55285 .45955 L p .77 .994 .788 r
F P
0 g
s
.5601 .45319 m .55686 .44557 L .56221 .43928 L p .813 .997 .777 r
F P
0 g
s
.50213 .48692 m .5038 .47968 L .52034 .47233 L p .518 .916 .886 r
F P
0 g
s
.52034 .47233 m .51946 .47969 L .50213 .48692 L p .518 .916 .886 r
F P
0 g
s
.55073 .45197 m .55285 .45955 L .54414 .46604 L p .709 .984 .816 r
F P
0 g
s
.55285 .45955 m .55073 .45197 L .55686 .44557 L p .77 .994 .788 r
F P
0 g
s
.51946 .47969 m .52034 .47233 L .53321 .46529 L p .576 .942 .869 r
F P
0 g
s
.53321 .46529 m .53324 .47275 L .51946 .47969 L p .576 .942 .869 r
F P
0 g
s
.5431 .45852 m .54414 .46604 L .53324 .47275 L p .641 .966 .846 r
F P
0 g
s
.54414 .46604 m .5431 .45852 L .55073 .45197 L p .709 .984 .816 r
F P
0 g
s
.53324 .47275 m .53321 .46529 L .5431 .45852 L p .641 .966 .846 r
F P
0 g
s
.68019 .39082 m .66783 .38283 L .70101 .37349 L p .555 .885 .989 r
F P
0 g
s
.70101 .37349 m .71406 .3816 L .68019 .39082 L p .555 .885 .989 r
F P
0 g
s
.82218 .37 m .81929 .36827 L .82266 .36759 L closepath p .5 .854 .992 r
F P
0 g
s
.38903 .51262 m .39239 .5057 L .4293 .49667 L p .38 .839 .905 r
F P
0 g
s
.4293 .49667 m .42601 .50384 L .38903 .51262 L p .38 .839 .905 r
F P
0 g
s
.81929 .36827 m .80581 .36019 L p .82283 .36673 L .503 .854 .993 r
F P
0 g
s
.82283 .36673 m .82266 .36759 L .81929 .36827 L p .503 .854 .993 r
F P
0 g
s
.71406 .3816 m .70101 .37349 L .74187 .36319 L p .534 .873 .991 r
F P
0 g
s
.74187 .36319 m .7555 .37145 L .71406 .3816 L p .534 .873 .991 r
F P
0 g
s
.80581 .36019 m .82492 .35623 L .82283 .36673 L p .503 .854 .993 r
F P
0 g
s
.34916 .51511 m .3053 .52371 L .30422 .52335 L p .343 .815 .905 r
F P
0 g
s
.42601 .50384 m .4293 .49667 L .46016 .48804 L p .406 .855 .903 r
F P
0 g
s
.46016 .48804 m .45719 .49542 L .42601 .50384 L p .406 .855 .903 r
F P
0 g
s
.30422 .52335 m .30061 .52221 L p .35257 .50801 L .343 .815 .905 r
F P
0 g
s
.35257 .50801 m .34916 .51511 L p .30422 .52335 L .343 .815 .905 r
F P
0 g
s
.58159 .40546 m .59084 .41361 L .58111 .42026 L p .782 .986 .898 r
F P
0 g
s
.59084 .41361 m .58159 .40546 L .59327 .39847 L p .725 .966 .937 r
F P
0 g
s
.59327 .39847 m .60356 .40664 L .59084 .41361 L p .725 .966 .937 r
F P
0 g
s
.60356 .40664 m .59327 .39847 L .6088 .39105 L p .671 .944 .961 r
F P
0 g
s
.6088 .39105 m .62006 .39927 L .60356 .40664 L p .671 .944 .961 r
F P
0 g
s
.57296 .41214 m .58111 .42026 L .57359 .4267 L p .834 .996 .842 r
F P
0 g
s
.58111 .42026 m .57296 .41214 L .58159 .40546 L p .782 .986 .898 r
F P
0 g
s
.62006 .39927 m .6088 .39105 L .62903 .38309 L p .626 .922 .976 r
F P
0 g
s
.62903 .38309 m .64118 .39137 L .62006 .39927 L p .626 .922 .976 r
F P
0 g
s
.56659 .4186 m .57359 .4267 L .56754 .43301 L p .867 .995 .779 r
F P
0 g
s
.57359 .4267 m .56659 .4186 L .57296 .41214 L p .834 .996 .842 r
F P
0 g
s
.7555 .37145 m .74187 .36319 L .79171 .35175 L p .518 .863 .992 r
F P
0 g
s
.79171 .35175 m .80581 .36019 L .7555 .37145 L p .518 .863 .992 r
F P
0 g
s
.45719 .49542 m .46016 .48804 L .48542 .47982 L p .439 .874 .898 r
F P
0 g
s
.48542 .47982 m .48295 .48737 L .45719 .49542 L p .439 .874 .898 r
F P
0 g
s
.56172 .42492 m .56754 .43301 L .56221 .43928 L p .873 .989 .728 r
F P
0 g
s
.56754 .43301 m .56172 .42492 L .56659 .4186 L p .867 .995 .779 r
F P
0 g
s
.64118 .39137 m .62903 .38309 L .65487 .37445 L p .59 .903 .984 r
F P
0 g
s
.65487 .37445 m .66783 .38283 L .64118 .39137 L p .59 .903 .984 r
F P
0 g
s
.55759 .43121 m .56221 .43928 L .55686 .44557 L p .853 .987 .712 r
F P
0 g
s
.56221 .43928 m .55759 .43121 L .56172 .42492 L p .873 .989 .728 r
F P
0 g
s
.30061 .52221 m .30243 .51809 L .35257 .50801 L p .343 .815 .905 r
F P
0 g
s
.48295 .48737 m .48542 .47982 L .50558 .47198 L p .48 .897 .891 r
F P
0 g
s
.50558 .47198 m .5038 .47968 L .48295 .48737 L p .48 .897 .891 r
F P
0 g
s
.34916 .51511 m .35257 .50801 L .39597 .49832 L p .361 .827 .905 r
F P
0 g
s
.39597 .49832 m .39239 .5057 L .34916 .51511 L p .361 .827 .905 r
F P
0 g
s
.55343 .43752 m .55686 .44557 L .55073 .45197 L p .807 .989 .733 r
F P
0 g
s
.55686 .44557 m .55343 .43752 L .55759 .43121 L p .853 .987 .712 r
F P
0 g
s
.66783 .38283 m .65487 .37445 L .68734 .365 L p .561 .887 .988 r
F P
0 g
s
.68734 .365 m .70101 .37349 L .66783 .38283 L p .561 .887 .988 r
F P
0 g
s
.54849 .44395 m .55073 .45197 L .5431 .45852 L p .742 .987 .776 r
F P
0 g
s
.55073 .45197 m .54849 .44395 L .55343 .43752 L p .807 .989 .733 r
F P
0 g
s
.5038 .47968 m .50558 .47198 L .52127 .46452 L p .531 .923 .877 r
F P
0 g
s
.52127 .46452 m .52034 .47233 L .5038 .47968 L p .531 .923 .877 r
F P
0 g
s
.54199 .45055 m .5431 .45852 L .53321 .46529 L p .668 .973 .821 r
F P
0 g
s
.5431 .45852 m .54199 .45055 L .54849 .44395 L p .742 .987 .776 r
F P
0 g
s
.52034 .47233 m .52127 .46452 L .53317 .45739 L p .595 .95 .855 r
F P
0 g
s
.53317 .45739 m .53321 .46529 L .52034 .47233 L p .595 .95 .855 r
F P
0 g
s
.53321 .46529 m .53317 .45739 L .54199 .45055 L p .668 .973 .821 r
F P
0 g
s
.80581 .36019 m .79171 .35175 L p .82595 .35094 L .505 .855 .993 r
F P
0 g
s
.82595 .35094 m .82492 .35623 L .80581 .36019 L p .505 .855 .993 r
F P
0 g
s
.70101 .37349 m .68734 .365 L .72759 .35455 L p .539 .875 .991 r
F P
0 g
s
.72759 .35455 m .74187 .36319 L .70101 .37349 L p .539 .875 .991 r
F P
0 g
s
.39239 .5057 m .39597 .49832 L .43279 .48904 L p .383 .841 .904 r
F P
0 g
s
.43279 .48904 m .4293 .49667 L .39239 .5057 L p .383 .841 .904 r
F P
0 g
s
.74187 .36319 m .72759 .35455 L .77696 .3429 L p .521 .864 .992 r
F P
0 g
s
.77696 .3429 m .79171 .35175 L .74187 .36319 L p .521 .864 .992 r
F P
0 g
s
.58245 .38987 m .59327 .39847 L .58159 .40546 L p .752 .974 .924 r
F P
0 g
s
.59327 .39847 m .58245 .38987 L .59697 .38241 L p .691 .951 .955 r
F P
0 g
s
.59697 .38241 m .6088 .39105 L .59327 .39847 L p .691 .951 .955 r
F P
0 g
s
.57185 .39689 m .58159 .40546 L .57296 .41214 L p .818 .991 .872 r
F P
0 g
s
.58159 .40546 m .57185 .39689 L .58245 .38987 L p .752 .974 .924 r
F P
0 g
s
.6088 .39105 m .59697 .38241 L .61626 .37439 L p .64 .927 .973 r
F P
0 g
s
.61626 .37439 m .62903 .38309 L .6088 .39105 L p .64 .927 .973 r
F P
0 g
s
.56437 .40358 m .57296 .41214 L .56659 .4186 L p .876 .993 .795 r
F P
0 g
s
.57296 .41214 m .56437 .40358 L .57185 .39689 L p .818 .991 .872 r
F P
0 g
s
.30243 .51809 m .30561 .51086 L .35621 .50044 L p .345 .816 .904 r
F P
0 g
s
.35621 .50044 m .35257 .50801 L .30243 .51809 L p .345 .816 .904 r
F P
0 g
s
.4293 .49667 m .43279 .48904 L .46333 .48019 L p .411 .858 .901 r
F P
0 g
s
.46333 .48019 m .46016 .48804 L .4293 .49667 L p .411 .858 .901 r
F P
0 g
s
.5592 .41005 m .56659 .4186 L .56172 .42492 L p .909 .979 .707 r
F P
0 g
s
.56659 .4186 m .5592 .41005 L .56437 .40358 L p .876 .993 .795 r
F P
0 g
s
.62903 .38309 m .61626 .37439 L .64127 .36566 L p .599 .907 .982 r
F P
0 g
s
.64127 .36566 m .65487 .37445 L .62903 .38309 L p .599 .907 .982 r
F P
0 g
s
.79171 .35175 m .82728 .34419 L .82595 .35094 L p .505 .855 .993 r
F P
0 g
s
.55557 .41638 m .56172 .42492 L .55759 .43121 L p .911 .961 .639 r
F P
0 g
s
.56172 .42492 m .55557 .41638 L .5592 .41005 L p .909 .979 .707 r
F P
0 g
s
.65487 .37445 m .64127 .36566 L .673 .35609 L p .567 .89 .988 r
F P
0 g
s
.673 .35609 m .68734 .365 L .65487 .37445 L p .567 .89 .988 r
F P
0 g
s
.5527 .42267 m .55759 .43121 L .55343 .43752 L p .889 .958 .62 r
F P
0 g
s
.55759 .43121 m .5527 .42267 L .55557 .41638 L p .911 .961 .639 r
F P
0 g
s
.46016 .48804 m .46333 .48019 L .48805 .47179 L p .445 .878 .895 r
F P
0 g
s
.48805 .47179 m .48542 .47982 L .46016 .48804 L p .445 .878 .895 r
F P
0 g
s
.54981 .42901 m .55343 .43752 L .54849 .44395 L p .844 .971 .655 r
F P
0 g
s
.55343 .43752 m .54981 .42901 L .5527 .42267 L p .889 .958 .62 r
F P
0 g
s
.79171 .35175 m .77696 .3429 L p .82934 .33354 L .507 .856 .993 r
F P
0 g
s
.82934 .33354 m .82728 .34419 L .79171 .35175 L p .507 .856 .993 r
F P
0 g
s
.48542 .47982 m .48805 .47179 L .50748 .46381 L p .489 .902 .885 r
F P
0 g
s
.50748 .46381 m .50558 .47198 L .48542 .47982 L p .489 .902 .885 r
F P
0 g
s
.54612 .43546 m .54849 .44395 L .54199 .45055 L p .777 .982 .721 r
F P
0 g
s
.54849 .44395 m .54612 .43546 L .54981 .42901 L p .844 .971 .655 r
F P
0 g
s
.68734 .365 m .673 .35609 L .71263 .34548 L p .543 .877 .991 r
F P
0 g
s
.71263 .34548 m .72759 .35455 L .68734 .365 L p .543 .877 .991 r
F P
0 g
s
.35257 .50801 m .35621 .50044 L .39979 .49044 L p .364 .828 .904 r
F P
0 g
s
.39979 .49044 m .39597 .49832 L .35257 .50801 L p .364 .828 .904 r
F P
0 g
s
.54082 .44211 m .54199 .45055 L .53317 .45739 L p .697 .977 .787 r
F P
0 g
s
.54199 .45055 m .54082 .44211 L .54612 .43546 L p .777 .982 .721 r
F P
0 g
s
.50558 .47198 m .50748 .46381 L .52227 .45623 L p .546 .929 .867 r
F P
0 g
s
.52227 .45623 m .52127 .46452 L .50558 .47198 L p .546 .929 .867 r
F P
0 g
s
.53313 .44901 m .53317 .45739 L .52127 .46452 L p .616 .957 .836 r
F P
0 g
s
.53317 .45739 m .53313 .44901 L .54082 .44211 L p .697 .977 .787 r
F P
0 g
s
.52127 .46452 m .52227 .45623 L .53313 .44901 L p .616 .957 .836 r
F P
0 g
s
.72759 .35455 m .71263 .34548 L .7615 .33364 L p .524 .866 .992 r
F P
0 g
s
.7615 .33364 m .77696 .3429 L .72759 .35455 L p .524 .866 .992 r
F P
0 g
s
.57105 .38082 m .58245 .38987 L .57185 .39689 L p .783 .98 .907 r
F P
0 g
s
.58245 .38987 m .57105 .38082 L .58452 .37332 L p .713 .957 .948 r
F P
0 g
s
.58452 .37332 m .59697 .38241 L .58245 .38987 L p .713 .957 .948 r
F P
0 g
s
.59697 .38241 m .58452 .37332 L .60285 .36524 L p .655 .933 .969 r
F P
0 g
s
.60285 .36524 m .61626 .37439 L .59697 .38241 L p .655 .933 .969 r
F P
0 g
s
.56159 .38785 m .57185 .39689 L .56437 .40358 L p .858 .991 .835 r
F P
0 g
s
.57185 .39689 m .56159 .38785 L .57105 .38082 L p .783 .98 .907 r
F P
0 g
s
.39597 .49832 m .39979 .49044 L .43652 .48089 L p .387 .843 .902 r
F P
0 g
s
.43652 .48089 m .43279 .48904 L .39597 .49832 L p .387 .843 .902 r
F P
0 g
s
.5553 .39455 m .56437 .40358 L .5592 .41005 L p .918 .978 .728 r
F P
0 g
s
.56437 .40358 m .5553 .39455 L .56159 .38785 L p .858 .991 .835 r
F P
0 g
s
.61626 .37439 m .60285 .36524 L .62698 .35643 L p .609 .911 .981 r
F P
0 g
s
.62698 .35643 m .64127 .36566 L .61626 .37439 L p .609 .911 .981 r
F P
0 g
s
.55139 .40102 m .5592 .41005 L .55557 .41638 L p .944 .941 .606 r
F P
0 g
s
.5592 .41005 m .55139 .40102 L .5553 .39455 L p .918 .978 .728 r
F P
0 g
s
.64127 .36566 m .62698 .35643 L .65795 .34674 L p .574 .893 .987 r
F P
0 g
s
.65795 .34674 m .673 .35609 L .64127 .36566 L p .574 .893 .987 r
F P
0 g
s
.54906 .40735 m .55557 .41638 L .5527 .42267 L p .936 .905 .514 r
F P
0 g
s
.55557 .41638 m .54906 .40735 L .55139 .40102 L p .944 .941 .606 r
F P
0 g
s
.77696 .3429 m .82976 .33141 L .82934 .33354 L p .507 .856 .993 r
F P
0 g
s
.77696 .3429 m .7615 .33364 L .8212 .3203 L p .51 .857 .993 r
F P
0 g
s
.82976 .33141 m .77696 .3429 L p .8212 .3203 L .51 .857 .993 r
F P
0 g
s
.43279 .48904 m .43652 .48089 L .46672 .47182 L p .415 .861 .898 r
F P
0 g
s
.46672 .47182 m .46333 .48019 L .43279 .48904 L p .415 .861 .898 r
F P
0 g
s
.30561 .51086 m .30902 .50312 L .36011 .49233 L p .347 .818 .904 r
F P
0 g
s
.36011 .49233 m .35621 .50044 L .30561 .51086 L p .347 .818 .904 r
F P
0 g
s
.54752 .41364 m .5527 .42267 L .54981 .42901 L p .911 .9 .492 r
F P
0 g
s
.5527 .42267 m .54752 .41364 L .54906 .40735 L p .936 .905 .514 r
F P
0 g
s
.673 .35609 m .65795 .34674 L .69693 .33597 L p .548 .879 .99 r
F P
0 g
s
.69693 .33597 m .71263 .34548 L .673 .35609 L p .548 .879 .99 r
F P
0 g
s
.54597 .41998 m .54981 .42901 L .54612 .43546 L p .873 .929 .546 r
F P
0 g
s
.54981 .42901 m .54597 .41998 L .54752 .41364 L p .911 .9 .492 r
F P
0 g
s
.46333 .48019 m .46672 .47182 L .49085 .46322 L p .452 .882 .891 r
F P
0 g
s
.49085 .46322 m .48805 .47179 L .46333 .48019 L p .452 .882 .891 r
F P
0 g
s
.5436 .42645 m .54612 .43546 L .54082 .44211 L p .812 .964 .644 r
F P
0 g
s
.54612 .43546 m .5436 .42645 L .54597 .41998 L p .873 .929 .546 r
F P
0 g
s
.48805 .47179 m .49085 .46322 L .50949 .45509 L p .5 .908 .878 r
F P
0 g
s
.50949 .45509 m .50748 .46381 L .48805 .47179 L p .5 .908 .878 r
F P
0 g
s
.53958 .43313 m .54082 .44211 L .53313 .44901 L p .728 .976 .741 r
F P
0 g
s
.54082 .44211 m .53958 .43313 L .5436 .42645 L p .812 .964 .644 r
F P
0 g
s
.71263 .34548 m .69693 .33597 L .74528 .32392 L p .528 .867 .992 r
F P
0 g
s
.74528 .32392 m .7615 .33364 L .71263 .34548 L p .528 .867 .992 r
F P
0 g
s
.8212 .3203 m .83078 .32607 L .82976 .33141 L p .51 .857 .993 r
F P
0 g
s
.53309 .44009 m .53313 .44901 L .52227 .45623 L p .64 .963 .811 r
F P
0 g
s
.53313 .44901 m .53309 .44009 L .53958 .43313 L p .728 .976 .741 r
F P
0 g
s
.50748 .46381 m .50949 .45509 L .52333 .4474 L p .562 .936 .854 r
F P
0 g
s
.52333 .4474 m .52227 .45623 L .50748 .46381 L p .562 .936 .854 r
F P
0 g
s
.52227 .45623 m .52333 .4474 L .53309 .44009 L p .64 .963 .811 r
F P
0 g
s
.35621 .50044 m .36011 .49233 L .40388 .482 L p .366 .83 .903 r
F P
0 g
s
.40388 .482 m .39979 .49044 L .35621 .50044 L p .366 .83 .903 r
F P
0 g
s
.55903 .37127 m .57105 .38082 L .56159 .38785 L p .818 .985 .883 r
F P
0 g
s
.57105 .38082 m .55903 .37127 L .5714 .36374 L p .738 .964 .937 r
F P
0 g
s
.5714 .36374 m .58452 .37332 L .57105 .38082 L p .738 .964 .937 r
F P
0 g
s
.58452 .37332 m .5714 .36374 L .58872 .35561 L p .671 .939 .965 r
F P
0 g
s
.58872 .35561 m .60285 .36524 L .58452 .37332 L p .671 .939 .965 r
F P
0 g
s
.55075 .37831 m .56159 .38785 L .5553 .39455 L p .9 .985 .784 r
F P
0 g
s
.56159 .38785 m .55075 .37831 L .55903 .37127 L p .818 .985 .883 r
F P
0 g
s
.60285 .36524 m .58872 .35561 L .61195 .34672 L p .62 .916 .979 r
F P
0 g
s
.61195 .34672 m .62698 .35643 L .60285 .36524 L p .62 .916 .979 r
F P
0 g
s
.54572 .38501 m .5553 .39455 L .55139 .40102 L p .954 .944 .633 r
F P
0 g
s
.5553 .39455 m .54572 .38501 L .55075 .37831 L p .9 .985 .784 r
F P
0 g
s
.62698 .35643 m .61195 .34672 L .64212 .33691 L p .582 .897 .986 r
F P
0 g
s
.64212 .33691 m .65795 .34674 L .62698 .35643 L p .582 .897 .986 r
F P
0 g
s
.7615 .33364 m .74528 .32392 L .80462 .31032 L p .512 .858 .993 r
F P
0 g
s
.80462 .31032 m .8212 .3203 L .7615 .33364 L p .512 .858 .993 r
F P
0 g
s
.54313 .39146 m .55139 .40102 L .54906 .40735 L p .96 .869 .466 r
F P
0 g
s
.55139 .40102 m .54313 .39146 L .54572 .38501 L p .954 .944 .633 r
F P
0 g
s
.39979 .49044 m .40388 .482 L .44051 .47217 L p .39 .846 .9 r
F P
0 g
s
.44051 .47217 m .43652 .48089 L .39979 .49044 L p .39 .846 .9 r
F P
0 g
s
.54217 .39778 m .54906 .40735 L .54752 .41364 L p .934 .807 .347 r
F P
0 g
s
.54906 .40735 m .54217 .39778 L .54313 .39146 L p .96 .869 .466 r
F P
0 g
s
.65795 .34674 m .64212 .33691 L .68043 .32598 L p .553 .881 .99 r
F P
0 g
s
.68043 .32598 m .69693 .33597 L .65795 .34674 L p .553 .881 .99 r
F P
0 g
s
.54204 .40406 m .54752 .41364 L .54597 .41998 L p .907 .801 .323 r
F P
0 g
s
.54752 .41364 m .54204 .40406 L .54217 .39778 L p .934 .807 .347 r
F P
0 g
s
.43652 .48089 m .44051 .47217 L .47033 .46286 L p .421 .864 .895 r
F P
0 g
s
.47033 .46286 m .46672 .47182 L .43652 .48089 L p .421 .864 .895 r
F P
0 g
s
.5419 .41039 m .54597 .41998 L .5436 .42645 L p .883 .853 .398 r
F P
0 g
s
.54597 .41998 m .5419 .41039 L .54204 .40406 L p .907 .801 .323 r
F P
0 g
s
.30902 .50312 m .31269 .49481 L .36429 .48363 L p .349 .819 .903 r
F P
0 g
s
.36429 .48363 m .36011 .49233 L .30902 .50312 L p .349 .819 .903 r
F P
0 g
s
.69693 .33597 m .68043 .32598 L .72824 .31371 L p .531 .869 .992 r
F P
0 g
s
.72824 .31371 m .74528 .32392 L .69693 .33597 L p .531 .869 .992 r
F P
0 g
s
.54092 .41688 m .5436 .42645 L .53958 .43313 L p .839 .925 .537 r
F P
0 g
s
.5436 .42645 m .54092 .41688 L .5419 .41039 L p .883 .853 .398 r
F P
0 g
s
.46672 .47182 m .47033 .46286 L .49384 .45407 L p .46 .887 .886 r
F P
0 g
s
.49384 .45407 m .49085 .46322 L .46672 .47182 L p .46 .887 .886 r
F P
0 g
s
.53826 .42358 m .53958 .43313 L .53309 .44009 L p .761 .967 .678 r
F P
0 g
s
.53958 .43313 m .53826 .42358 L .54092 .41688 L p .839 .925 .537 r
F P
0 g
s
.49085 .46322 m .49384 .45407 L .51164 .44579 L p .512 .914 .869 r
F P
0 g
s
.51164 .44579 m .50949 .45509 L .49085 .46322 L p .512 .914 .869 r
F P
0 g
s
.55756 .35363 m .5714 .36374 L .55903 .37127 L p .765 .971 .924 r
F P
0 g
s
.5714 .36374 m .55756 .35363 L .57383 .34546 L p .69 .945 .96 r
F P
0 g
s
.57383 .34546 m .58872 .35561 L .5714 .36374 L p .69 .945 .96 r
F P
0 g
s
.53305 .4306 m .53309 .44009 L .52333 .4474 L p .666 .966 .778 r
F P
0 g
s
.53309 .44009 m .53305 .4306 L .53826 .42358 L p .761 .967 .678 r
F P
0 g
s
.54634 .36118 m .55903 .37127 L .55075 .37831 L p .856 .986 .85 r
F P
0 g
s
.55903 .37127 m .54634 .36118 L .55756 .35363 L p .765 .971 .924 r
F P
0 g
s
.50949 .45509 m .51164 .44579 L .52445 .43798 L p .58 .943 .837 r
F P
0 g
s
.52445 .43798 m .52333 .4474 L .50949 .45509 L p .58 .943 .837 r
F P
0 g
s
.58872 .35561 m .57383 .34546 L .59612 .33649 L p .632 .921 .977 r
F P
0 g
s
.59612 .33649 m .61195 .34672 L .58872 .35561 L p .632 .921 .977 r
F P
0 g
s
.52333 .4474 m .52445 .43798 L .53305 .4306 L p .666 .966 .778 r
F P
0 g
s
.5393 .36823 m .55075 .37831 L .54572 .38501 L p .941 .964 .71 r
F P
0 g
s
.55075 .37831 m .5393 .36823 L .54634 .36118 L p .856 .986 .85 r
F P
0 g
s
.74528 .32392 m .72824 .31371 L .78721 .29983 L p .515 .859 .993 r
F P
0 g
s
.78721 .29983 m .80462 .31032 L .74528 .32392 L p .515 .859 .993 r
F P
0 g
s
.61195 .34672 m .59612 .33649 L .62547 .32656 L p .59 .9 .985 r
F P
0 g
s
.62547 .32656 m .64212 .33691 L .61195 .34672 L p .59 .9 .985 r
F P
0 g
s
.53558 .37491 m .54572 .38501 L .54313 .39146 L p .975 .877 .501 r
F P
0 g
s
.54572 .38501 m .53558 .37491 L .5393 .36823 L p .941 .964 .71 r
F P
0 g
s
.36011 .49233 m .36429 .48363 L .40827 .47295 L p .369 .832 .902 r
F P
0 g
s
.40827 .47295 m .40388 .482 L .36011 .49233 L p .369 .832 .902 r
F P
0 g
s
.53438 .38134 m .54313 .39146 L .54217 .39778 L p .944 .752 .285 r
F P
0 g
s
.54313 .39146 m .53438 .38134 L .53558 .37491 L p .975 .877 .501 r
F P
0 g
s
.64212 .33691 m .62547 .32656 L .66307 .31547 L p .559 .884 .99 r
F P
0 g
s
.66307 .31547 m .68043 .32598 L .64212 .33691 L p .559 .884 .99 r
F P
0 g
s
.53486 .38763 m .54217 .39778 L .54204 .40406 L p .892 .663 .147 r
F P
0 g
s
.54217 .39778 m .53486 .38763 L .53438 .38134 L p .944 .752 .285 r
F P
0 g
s
.40388 .482 m .40827 .47295 L .44479 .46282 L p .394 .848 .899 r
F P
0 g
s
.44479 .46282 m .44051 .47217 L .40388 .482 L p .394 .848 .899 r
F P
0 g
s
.53621 .39388 m .54204 .40406 L .5419 .41039 L p .863 .654 .121 r
F P
0 g
s
.54204 .40406 m .53621 .39388 L .53486 .38763 L p .892 .663 .147 r
F P
0 g
s
.68043 .32598 m .66307 .31547 L .71033 .30298 L p .535 .871 .992 r
F P
0 g
s
.71033 .30298 m .72824 .31371 L .68043 .32598 L p .535 .871 .992 r
F P
0 g
s
.53756 .4002 m .5419 .41039 L .54092 .41688 L p .86 .731 .211 r
F P
0 g
s
.5419 .41039 m .53756 .4002 L .53621 .39388 L p .863 .654 .121 r
F P
0 g
s
.44051 .47217 m .44479 .46282 L .47421 .45327 L p .426 .868 .892 r
F P
0 g
s
.47421 .45327 m .47033 .46286 L .44051 .47217 L p .426 .868 .892 r
F P
0 g
s
.53807 .40668 m .54092 .41688 L .53826 .42358 L p .849 .851 .392 r
F P
0 g
s
.54092 .41688 m .53807 .40668 L .53756 .4002 L p .86 .731 .211 r
F P
0 g
s
.54293 .34296 m .55756 .35363 L .54634 .36118 L p .797 .976 .905 r
F P
0 g
s
.55756 .35363 m .54293 .34296 L .55811 .33474 L p .711 .952 .953 r
F P
0 g
s
.55811 .33474 m .57383 .34546 L .55756 .35363 L p .711 .952 .953 r
F P
0 g
s
.31269 .49481 m .31662 .48587 L .36879 .47426 L p .351 .821 .902 r
F P
0 g
s
.36879 .47426 m .36429 .48363 L .31269 .49481 L p .351 .821 .902 r
F P
0 g
s
.53291 .35051 m .54634 .36118 L .5393 .36823 L p .898 .98 .803 r
F P
0 g
s
.54634 .36118 m .53291 .35051 L .54293 .34296 L p .797 .976 .905 r
F P
0 g
s
.57383 .34546 m .55811 .33474 L .57942 .3257 L p .646 .926 .974 r
F P
0 g
s
.57942 .3257 m .59612 .33649 L .57383 .34546 L p .646 .926 .974 r
F P
0 g
s
.72824 .31371 m .71033 .30298 L .76891 .28881 L p .517 .861 .993 r
F P
0 g
s
.76891 .28881 m .78721 .29983 L .72824 .31371 L p .517 .861 .993 r
F P
0 g
s
.53684 .4134 m .53826 .42358 L .53305 .4306 L p .79 .941 .59 r
F P
0 g
s
.53826 .42358 m .53684 .4134 L .53807 .40668 L p .849 .851 .392 r
F P
0 g
s
.47033 .46286 m .47421 .45327 L .49705 .44428 L p .468 .892 .881 r
F P
0 g
s
.49705 .44428 m .49384 .45407 L .47033 .46286 L p .468 .892 .881 r
F P
0 g
s
.52716 .35755 m .5393 .36823 L .53558 .37491 L p .974 .92 .606 r
F P
0 g
s
.5393 .36823 m .52716 .35755 L .53291 .35051 L p .898 .98 .803 r
F P
0 g
s
.59612 .33649 m .57942 .3257 L .60791 .31565 L p .599 .904 .984 r
F P
0 g
s
.60791 .31565 m .62547 .32656 L .59612 .33649 L p .599 .904 .984 r
F P
0 g
s
.533 .42046 m .53305 .4306 L .52445 .43798 L p .695 .966 .734 r
F P
0 g
s
.53305 .4306 m .533 .42046 L .53684 .4134 L p .79 .941 .59 r
F P
0 g
s
.49384 .45407 m .49705 .44428 L .51395 .43584 L p .525 .92 .859 r
F P
0 g
s
.51395 .43584 m .51164 .44579 L .49384 .45407 L p .525 .92 .859 r
F P
0 g
s
.52483 .3642 m .53558 .37491 L .53438 .38134 L p .965 .768 .328 r
F P
0 g
s
.53558 .37491 m .52483 .3642 L .52716 .35755 L p .974 .92 .606 r
F P
0 g
s
.52566 .42791 m .52445 .43798 L .51164 .44579 L p .601 .949 .816 r
F P
0 g
s
.52445 .43798 m .52566 .42791 L .533 .42046 L p .695 .966 .734 r
F P
0 g
s
.51164 .44579 m .51395 .43584 L .52566 .42791 L p .601 .949 .816 r
F P
0 g
s
.62547 .32656 m .60791 .31565 L .64479 .3044 L p .564 .886 .989 r
F P
0 g
s
.64479 .3044 m .66307 .31547 L .62547 .32656 L p .564 .886 .989 r
F P
0 g
s
.52509 .37059 m .53438 .38134 L .53486 .38763 L p .883 .592 .077 r
F P
0 g
s
.53438 .38134 m .52509 .37059 L .52483 .3642 L p .965 .768 .328 r
F P
0 g
s
.36429 .48363 m .36879 .47426 L .41299 .46322 L p .372 .834 .9 r
F P
0 g
s
.41299 .46322 m .40827 .47295 L .36429 .48363 L p .372 .834 .9 r
F P
0 g
s
.52709 .37684 m .53486 .38763 L .53621 .39388 L p .805 .483 0 r
F P
0 g
s
.53486 .38763 m .52709 .37684 L .52509 .37059 L p .883 .592 .077 r
F P
0 g
s
.66307 .31547 m .64479 .3044 L .69148 .29168 L p .539 .873 .992 r
F P
0 g
s
.69148 .29168 m .71033 .30298 L .66307 .31547 L p .539 .873 .992 r
F P
0 g
s
.53621 .39388 m .53756 .4002 L p .53277 .38933 L .776 .474 0 r
F P
0 g
s
.53179 .38616 m .53621 .39388 L p .53277 .38933 L .776 .474 0 r
F P
0 g
s
.53 .38305 m .53179 .38616 L p .53277 .38933 L .776 .474 0 r
F P
0 g
s
.53756 .4002 m .53294 .38933 L .53 .38305 L p .776 .474 0 r
F P
0 g
s
.53756 .4002 m .53807 .40668 L p .53569 .39863 L .796 .567 .002 r
F P
0 g
s
.53294 .38933 m .53558 .39553 L p .53569 .39863 L .796 .567 .002 r
F P
0 g
s
.53558 .39553 m .53756 .4002 L p .53569 .39863 L .796 .567 .002 r
F P
0 g
s
.53502 .39579 m .53294 .38933 L p .53625 .40054 L .796 .567 .002 r
F P
0 g
s
.53534 .40252 m .53502 .39579 L p .53589 .4042 L .829 .734 .21 r
F P
0 g
s
.53684 .4134 m .53601 .40737 L p .53589 .4042 L .829 .734 .21 r
F P
0 g
s
.53601 .40737 m .53534 .40252 L p .53589 .4042 L .829 .734 .21 r
F P
0 g
s
.53807 .40668 m .53723 .40369 L p .53625 .40054 L .796 .567 .002 r
F P
0 g
s
.53723 .40369 m .53502 .39579 L p .53625 .40054 L .796 .567 .002 r
F P
0 g
s
.53621 .39388 m .53 .38305 L .52709 .37684 L p .805 .483 0 r
F P
0 g
s
.40827 .47295 m .41299 .46322 L .44939 .45278 L p .398 .851 .897 r
F P
0 g
s
.44939 .45278 m .44479 .46282 L .40827 .47295 L p .398 .851 .897 r
F P
0 g
s
.71033 .30298 m .69148 .29168 L .74965 .27721 L p .52 .862 .993 r
F P
0 g
s
.74965 .27721 m .76891 .28881 L .71033 .30298 L p .52 .862 .993 r
F P
0 g
s
.52745 .33165 m .54293 .34296 L .53291 .35051 L p .832 .98 .88 r
F P
0 g
s
.54293 .34296 m .52745 .33165 L .54149 .32341 L p .734 .958 .943 r
F P
0 g
s
.54149 .32341 m .55811 .33474 L .54293 .34296 L p .734 .958 .943 r
F P
0 g
s
.55811 .33474 m .54149 .32341 L .56178 .3143 L p .661 .931 .971 r
F P
0 g
s
.56178 .3143 m .57942 .3257 L .55811 .33474 L p .661 .931 .971 r
F P
0 g
s
.51868 .33921 m .53291 .35051 L .52716 .35755 L p .939 .963 .736 r
F P
0 g
s
.53291 .35051 m .51868 .33921 L .52745 .33165 L p .832 .98 .88 r
F P
0 g
s
.53502 .39579 m .53807 .40668 L .53684 .4134 L p .829 .734 .21 r
F P
0 g
s
.57942 .3257 m .56178 .3143 L .58938 .30414 L p .608 .908 .983 r
F P
0 g
s
.58938 .30414 m .60791 .31565 L .57942 .3257 L p .608 .908 .983 r
F P
0 g
s
.51429 .34622 m .52716 .35755 L .52483 .3642 L p .987 .842 .464 r
F P
0 g
s
.52716 .35755 m .51429 .34622 L .51868 .33921 L p .939 .963 .736 r
F P
0 g
s
.44479 .46282 m .44939 .45278 L .47838 .44296 L p .432 .872 .889 r
F P
0 g
s
.47838 .44296 m .47421 .45327 L .44479 .46282 L p .432 .872 .889 r
F P
0 g
s
.53534 .40252 m .53684 .4134 L .533 .42046 L p .81 .891 .47 r
F P
0 g
s
.60791 .31565 m .58938 .30414 L .62551 .29272 L p .571 .889 .989 r
F P
0 g
s
.62551 .29272 m .64479 .3044 L .60791 .31565 L p .571 .889 .989 r
F P
0 g
s
.51342 .35283 m .52483 .3642 L .52509 .37059 L p .911 .615 .124 r
F P
0 g
s
.52483 .3642 m .51342 .35283 L .51429 .34622 L p .987 .842 .464 r
F P
0 g
s
.47421 .45327 m .47838 .44296 L .50049 .43376 L p .478 .897 .874 r
F P
0 g
s
.50049 .43376 m .49705 .44428 L .47421 .45327 L p .478 .897 .874 r
F P
0 g
s
.31662 .48587 m .32087 .47622 L .37365 .46416 L p .353 .822 .901 r
F P
0 g
s
.37365 .46416 m .36879 .47426 L .31662 .48587 L p .353 .822 .901 r
F P
0 g
s
.53295 .40961 m .533 .42046 L .52566 .42791 L p .725 .957 .674 r
F P
0 g
s
.533 .42046 m .53295 .40961 L .53534 .40252 L p .81 .891 .47 r
F P
0 g
s
.49705 .44428 m .50049 .43376 L .51642 .42516 L p .54 .926 .846 r
F P
0 g
s
.51642 .42516 m .51395 .43584 L .49705 .44428 L p .54 .926 .846 r
F P
0 g
s
.52695 .41713 m .52566 .42791 L .51395 .43584 L p .624 .954 .789 r
F P
0 g
s
.52566 .42791 m .52695 .41713 L .53295 .40961 L p .725 .957 .674 r
F P
0 g
s
.51521 .35916 m .52509 .37059 L .52709 .37684 L p .781 .405 0 r
F P
0 g
s
.52509 .37059 m .51521 .35916 L .51342 .35283 L p .911 .615 .124 r
F P
0 g
s
.51395 .43584 m .51642 .42516 L .52695 .41713 L p .624 .954 .789 r
F P
0 g
s
.64479 .3044 m .62551 .29272 L .67159 .27977 L p .543 .875 .992 r
F P
0 g
s
.67159 .27977 m .69148 .29168 L .64479 .3044 L p .543 .875 .992 r
F P
0 g
s
.51882 .36534 m .52709 .37684 L .53 .38305 L p .689 .293 0 r
F P
0 g
s
.52709 .37684 m .51882 .36534 L .51521 .35916 L p .781 .405 0 r
F P
0 g
s
.36879 .47426 m .37365 .46416 L .41808 .45272 L p .375 .836 .899 r
F P
0 g
s
.41808 .45272 m .41299 .46322 L .36879 .47426 L p .375 .836 .899 r
F P
0 g
s
.53 .38305 m .52338 .37149 L .51882 .36534 L p .689 .293 0 r
F P
0 g
s
.53 .38305 m .53294 .38933 L p .53072 .38519 L .662 .285 0 r
F P
0 g
s
.52688 .37803 m .52966 .3825 L .53072 .38519 L .662 .285 0 r
F
.52966 .3825 m .53 .38305 L .53072 .38519 L F
.52338 .37149 m .52529 .37482 L p .52688 .37803 L F P
0 g
s
.52529 .37482 m .53 .38305 L p .52688 .37803 L .662 .285 0 r
F P
0 g
s
.53294 .38933 m .528 .37773 L .52338 .37149 L p .662 .285 0 r
F P
0 g
s
.528 .37773 m .53294 .38933 L .53466 .39467 L p .696 .38 0 r
F P
0 g
s
.53466 .39467 m .53502 .39579 L p .53458 .39465 L .696 .38 0 r
F P
0 g
s
.528 .37773 m .53466 .39467 L .53458 .39465 L .696 .38 0 r
F
.53295 .40961 m .5329 .39797 L .53333 .39429 L p .809 .803 .312 r
F P
0 g
s
.53254 .3894 m .53458 .39465 L .53413 .3926 L .696 .38 0 r
F
.53502 .39579 m .53453 .39402 L p .53458 .39465 L F P
0 g
s
.53453 .39402 m .53413 .3926 L p .53458 .39465 L .696 .38 0 r
F P
0 g
s
.53413 .3926 m .53177 .38415 L p .53254 .3894 L .696 .38 0 r
F P
0 g
s
.53177 .38415 m .53502 .39579 L .53534 .40252 L p .77 .575 .004 r
F P
0 g
s
.53534 .40252 m .53414 .39386 L p .53318 .39144 L .77 .575 .004 r
F P
0 g
s
.53414 .39386 m .53372 .39087 L p .53318 .39144 L .77 .575 .004 r
F P
0 g
s
.53333 .39429 m .53372 .39087 L p .53358 .39436 L .809 .803 .312 r
F P
0 g
s
.53358 .39436 m .53295 .40961 L .53333 .39429 L .809 .803 .312 r
F
.53372 .39087 m .53177 .38415 L p .53318 .39144 L .77 .575 .004 r
F P
0 g
s
.53177 .38415 m .528 .37773 L p .53254 .3894 L .696 .38 0 r
F P
0 g
s
.69148 .29168 m .67159 .27977 L .72934 .26498 L p .523 .863 .993 r
F P
0 g
s
.72934 .26498 m .74965 .27721 L .69148 .29168 L p .523 .863 .993 r
F P
0 g
s
.52389 .31141 m .54149 .32341 L .52745 .33165 L p .761 .964 .931 r
F P
0 g
s
.54149 .32341 m .52389 .31141 L .54312 .30224 L p .678 .937 .966 r
F P
0 g
s
.54312 .30224 m .56178 .3143 L .54149 .32341 L p .678 .937 .966 r
F P
0 g
s
.51104 .31967 m .52745 .33165 L .51868 .33921 L p .871 .979 .845 r
F P
0 g
s
.52745 .33165 m .51104 .31967 L .52389 .31141 L p .761 .964 .931 r
F P
0 g
s
.56178 .3143 m .54312 .30224 L .56979 .29197 L p .619 .912 .981 r
F P
0 g
s
.56979 .29197 m .58938 .30414 L .56178 .3143 L p .619 .912 .981 r
F P
0 g
s
.50358 .32721 m .51868 .33921 L .51429 .34622 L p .974 .925 .642 r
F P
0 g
s
.51868 .33921 m .50358 .32721 L .51104 .31967 L p .871 .979 .845 r
F P
0 g
s
.41299 .46322 m .41808 .45272 L .45435 .44194 L p .402 .854 .894 r
F P
0 g
s
.45435 .44194 m .44939 .45278 L .41299 .46322 L p .402 .854 .894 r
F P
0 g
s
.50062 .33418 m .51429 .34622 L .51342 .35283 L p .965 .72 .282 r
F P
0 g
s
.51429 .34622 m .50062 .33418 L .50358 .32721 L p .974 .925 .642 r
F P
0 g
s
.58938 .30414 m .56979 .29197 L .60514 .28038 L p .578 .892 .988 r
F P
0 g
s
.60514 .28038 m .62551 .29272 L .58938 .30414 L p .578 .892 .988 r
F P
0 g
s
.50127 .34072 m .51342 .35283 L .51521 .35916 L p .814 .432 0 r
F P
0 g
s
.51342 .35283 m .50127 .34072 L .50062 .33418 L p .965 .72 .282 r
F P
0 g
s
.53372 .39087 m .53534 .40252 L .53295 .40961 L p .809 .803 .312 r
F P
0 g
s
.44939 .45278 m .45435 .44194 L .48286 .43185 L p .439 .876 .885 r
F P
0 g
s
.48286 .43185 m .47838 .44296 L .44939 .45278 L p .439 .876 .885 r
F P
0 g
s
.62551 .29272 m .60514 .28038 L .6506 .26719 L p .548 .877 .991 r
F P
0 g
s
.6506 .26719 m .67159 .27977 L .62551 .29272 L p .548 .877 .991 r
F P
0 g
s
.50468 .34698 m .51521 .35916 L .51882 .36534 L p .657 .22 0 r
F P
0 g
s
.51521 .35916 m .50468 .34698 L .50127 .34072 L p .814 .432 0 r
F P
0 g
s
.5329 .39797 m .53295 .40961 L .52695 .41713 L p .752 .935 .591 r
F P
0 g
s
.47838 .44296 m .48286 .43185 L .50419 .42244 L p .488 .902 .867 r
F P
0 g
s
.50419 .42244 m .50049 .43376 L .47838 .44296 L p .488 .902 .867 r
F P
0 g
s
.52834 .40555 m .52695 .41713 L .51642 .42516 L p .649 .956 .752 r
F P
0 g
s
.52695 .41713 m .52834 .40555 L .5329 .39797 L p .752 .935 .591 r
F P
0 g
s
.32087 .47622 m .32547 .46579 L .3789 .45323 L p .355 .824 .9 r
F P
0 g
s
.3789 .45323 m .37365 .46416 L .32087 .47622 L p .355 .824 .9 r
F P
0 g
s
.50049 .43376 m .50419 .42244 L .51907 .41369 L p .557 .933 .83 r
F P
0 g
s
.51907 .41369 m .51642 .42516 L .50049 .43376 L p .557 .933 .83 r
F P
0 g
s
.51642 .42516 m .51907 .41369 L .52834 .40555 L p .649 .956 .752 r
F P
0 g
s
.50999 .35308 m .51882 .36534 L .52338 .37149 L p 0 0 .424 r
F P
0 g
s
.51882 .36534 m .50999 .35308 L .50468 .34698 L p .657 .22 0 r
F P
0 g
s
.67159 .27977 m .6506 .26719 L .70792 .25207 L p .526 .865 .993 r
F P
0 g
s
.70792 .25207 m .72934 .26498 L .67159 .27977 L p .526 .865 .993 r
F P
0 g
s
.51631 .35915 m .52338 .37149 L .528 .37773 L p 0 0 .442 r
F P
0 g
s
.52338 .37149 m .51631 .35915 L .50999 .35308 L p 0 0 .424 r
F P
0 g
s
.50523 .29868 m .52389 .31141 L .51104 .31967 L p .791 .97 .914 r
F P
0 g
s
.52389 .31141 m .50523 .29868 L .52334 .28946 L p .696 .943 .961 r
F P
0 g
s
.52334 .28946 m .54312 .30224 L .52389 .31141 L p .696 .943 .961 r
F P
0 g
s
.49362 .30695 m .51104 .31967 L .50358 .32721 L p .912 .97 .795 r
F P
0 g
s
.51104 .31967 m .49362 .30695 L .50523 .29868 L p .791 .97 .914 r
F P
0 g
s
.54312 .30224 m .52334 .28946 L .54905 .27909 L p .631 .917 .979 r
F P
0 g
s
.54905 .27909 m .56979 .29197 L .54312 .30224 L p .631 .917 .979 r
F P
0 g
s
.48753 .31446 m .50358 .32721 L .50062 .33418 L p .993 .857 .511 r
F P
0 g
s
.50358 .32721 m .48753 .31446 L .49362 .30695 L p .912 .97 .795 r
F P
0 g
s
.37365 .46416 m .3789 .45323 L .42358 .44137 L p .378 .839 .898 r
F P
0 g
s
.42358 .44137 m .41808 .45272 L .37365 .46416 L p .378 .839 .898 r
F P
0 g
s
.56979 .29197 m .54905 .27909 L .58359 .26733 L p .585 .895 .987 r
F P
0 g
s
.58359 .26733 m .60514 .28038 L .56979 .29197 L p .585 .895 .987 r
F P
0 g
s
.52272 .3653 m .528 .37773 L .53177 .38415 L p 0 0 .378 r
F P
0 g
s
.528 .37773 m .52272 .3653 L .51631 .35915 L p 0 0 .442 r
F P
0 g
s
.48606 .32136 m .50062 .33418 L .50127 .34072 L p .898 .558 .075 r
F P
0 g
s
.50062 .33418 m .48606 .32136 L .48753 .31446 L p .993 .857 .511 r
F P
0 g
s
.60514 .28038 m .58359 .26733 L .62841 .25389 L p .553 .879 .991 r
F P
0 g
s
.62841 .25389 m .6506 .26719 L .60514 .28038 L p .553 .879 .991 r
F P
0 g
s
.53177 .38415 m .53372 .39087 L p .53173 .38385 L 0 0 .199 r
F P
0 g
s
.53372 .39087 m .53199 .37835 L .52827 .37167 L p 0 0 .199 r
F P
0 g
s
.53199 .37835 m .53372 .39087 L .53356 .39228 L p .776 .672 .122 r
F P
0 g
s
.53356 .39228 m .5329 .39797 L p .53263 .39206 L .776 .672 .122 r
F P
0 g
s
.53199 .37835 m .53356 .39228 L .53263 .39206 L .776 .672 .122 r
F
.52834 .40555 m .52983 .39309 L .53044 .39155 L p .772 .889 .478 r
F P
0 g
s
.5329 .39797 m .53285 .38748 L p .53233 .3858 L .776 .672 .122 r
F P
0 g
s
.53285 .38748 m .53285 .38546 L p .53233 .3858 L .776 .672 .122 r
F P
0 g
s
.53044 .39155 m .53285 .38546 L p .53143 .39179 L .772 .889 .478 r
F P
0 g
s
.53143 .39179 m .52834 .40555 L .53044 .39155 L .772 .889 .478 r
F
.53285 .38546 m .53199 .37835 L p .53233 .3858 L .776 .672 .122 r
F P
0 g
s
.52827 .37167 m .53124 .38226 L p .53173 .38385 L 0 0 .199 r
F P
0 g
s
.53124 .38226 m .53177 .38415 L p .53173 .38385 L 0 0 .199 r
F P
0 g
s
.53177 .38415 m .52827 .37167 L .52272 .3653 L p 0 0 .378 r
F P
0 g
s
.48832 .32782 m .50127 .34072 L .50468 .34698 L p .692 .246 0 r
F P
0 g
s
.50127 .34072 m .48832 .32782 L .48606 .32136 L p .898 .558 .075 r
F P
0 g
s
.41808 .45272 m .42358 .44137 L .45971 .43023 L p .407 .857 .892 r
F P
0 g
s
.45971 .43023 m .45435 .44194 L .41808 .45272 L p .407 .857 .892 r
F P
0 g
s
.50468 .34698 m .49344 .33397 L .48832 .32782 L p .692 .246 0 r
F P
0 g
s
.49344 .33397 m .50468 .34698 L .50999 .35308 L p 0 0 .465 r
F P
0 g
s
.6506 .26719 m .62841 .25389 L .68527 .23843 L p .53 .867 .993 r
F P
0 g
s
.68527 .23843 m .70792 .25207 L .6506 .26719 L p .53 .867 .993 r
F P
0 g
s
.45435 .44194 m .45971 .43023 L .48771 .41985 L p .446 .88 .88 r
F P
0 g
s
.48771 .41985 m .48286 .43185 L .45435 .44194 L p .446 .88 .88 r
F P
0 g
s
.53285 .38546 m .5329 .39797 L .52834 .40555 L p .772 .889 .478 r
F P
0 g
s
.50055 .33996 m .50999 .35308 L .51631 .35915 L p 0 .028 .547 r
F P
0 g
s
.50999 .35308 m .50055 .33996 L .49344 .33397 L p 0 0 .465 r
F P
0 g
s
.52983 .39309 m .52834 .40555 L .51907 .41369 L p .675 .952 .704 r
F P
0 g
s
.48286 .43185 m .48771 .41985 L .50819 .41022 L p .5 .908 .858 r
F P
0 g
s
.50819 .41022 m .50419 .42244 L .48286 .43185 L p .5 .908 .858 r
F P
0 g
s
.52194 .40132 m .51907 .41369 L .50419 .42244 L p .575 .938 .81 r
F P
0 g
s
.51907 .41369 m .52194 .40132 L .52983 .39309 L p .675 .952 .704 r
F P
0 g
s
.50419 .42244 m .50819 .41022 L .52194 .40132 L p .575 .938 .81 r
F P
0 g
s
.48539 .28516 m .50523 .29868 L .49362 .30695 L p .824 .973 .892 r
F P
0 g
s
.50523 .29868 m .48539 .28516 L .50235 .2759 L p .717 .949 .953 r
F P
0 g
s
.50235 .2759 m .52334 .28946 L .50523 .29868 L p .717 .949 .953 r
F P
0 g
s
.52334 .28946 m .50235 .2759 L .52706 .26543 L p .644 .921 .977 r
F P
0 g
s
.52706 .26543 m .54905 .27909 L .52334 .28946 L p .644 .921 .977 r
F P
0 g
s
.47508 .29342 m .49362 .30695 L .48753 .31446 L p .952 .949 .724 r
F P
0 g
s
.49362 .30695 m .47508 .29342 L .48539 .28516 L p .824 .973 .892 r
F P
0 g
s
.32547 .46579 m .33046 .45446 L .38461 .44137 L p .358 .826 .899 r
F P
0 g
s
.38461 .44137 m .3789 .45323 L .32547 .46579 L p .358 .826 .899 r
F P
0 g
s
.50873 .34592 m .51631 .35915 L .52272 .3653 L p 0 .033 .562 r
F P
0 g
s
.51631 .35915 m .50873 .34592 L .50055 .33996 L p 0 .028 .547 r
F P
0 g
s
.54905 .27909 m .52706 .26543 L .56075 .25349 L p .593 .899 .986 r
F P
0 g
s
.56075 .25349 m .58359 .26733 L .54905 .27909 L p .593 .899 .986 r
F P
0 g
s
.47043 .30087 m .48753 .31446 L .48606 .32136 L p .982 .747 .341 r
F P
0 g
s
.48753 .31446 m .47043 .30087 L .47508 .29342 L p .952 .949 .724 r
F P
0 g
s
.47052 .30769 m .48606 .32136 L .48832 .32782 L p .792 .373 0 r
F P
0 g
s
.48606 .32136 m .47052 .30769 L .47043 .30087 L p .982 .747 .341 r
F P
0 g
s
.58359 .26733 m .56075 .25349 L .6049 .2398 L p .558 .881 .991 r
F P
0 g
s
.6049 .2398 m .62841 .25389 L .58359 .26733 L p .558 .881 .991 r
F P
0 g
s
.51705 .35197 m .52272 .3653 L .52827 .37167 L p 0 0 .514 r
F P
0 g
s
.52272 .3653 m .51705 .35197 L .50873 .34592 L p 0 .033 .562 r
F P
0 g
s
.3789 .45323 m .38461 .44137 L .42956 .42904 L p .381 .841 .896 r
F P
0 g
s
.42956 .42904 m .42358 .44137 L .3789 .45323 L p .381 .841 .896 r
F P
0 g
s
.47448 .31403 m .48832 .32782 L .49344 .33397 L p .565 .079 0 r
F P
0 g
s
.48832 .32782 m .47448 .31403 L .47052 .30769 L p .792 .373 0 r
F P
0 g
s
.52827 .37167 m .53199 .37835 L p .52926 .37102 L 0 0 .375 r
F P
0 g
s
.53199 .37835 m .53012 .36488 L .52452 .35825 L p 0 0 .375 r
F P
0 g
s
.53012 .36488 m .53199 .37835 L .53216 .37977 L p .707 .506 0 r
F P
0 g
s
.53216 .37977 m .53285 .38546 L p .53203 .37927 L .707 .506 0 r
F P
0 g
s
.53012 .36488 m .53216 .37977 L .53203 .37927 L .707 .506 0 r
F
.52983 .39309 m .53144 .37962 L .53171 .37809 L p .775 .811 .33 r
F P
0 g
s
.53285 .38546 m .53279 .37415 L p .53115 .37269 L .707 .506 0 r
F P
0 g
s
.53279 .37415 m .53278 .37197 L p .53115 .37269 L .707 .506 0 r
F P
0 g
s
.53171 .37809 m .53278 .37197 L p .53185 .37862 L .775 .811 .33 r
F P
0 g
s
.53185 .37862 m .52983 .39309 L .53171 .37809 L .775 .811 .33 r
F
.53278 .37197 m .53012 .36488 L p .53115 .37269 L .707 .506 0 r
F P
0 g
s
.52452 .35825 m .52771 .36964 L p .52926 .37102 L 0 0 .375 r
F P
0 g
s
.52771 .36964 m .52827 .37167 L p .52926 .37102 L 0 0 .375 r
F P
0 g
s
.52827 .37167 m .52452 .35825 L .51705 .35197 L p 0 0 .514 r
F P
0 g
s
.62841 .25389 m .6049 .2398 L .66129 .22399 L p .533 .868 .993 r
F P
0 g
s
.66129 .22399 m .68527 .23843 L .62841 .25389 L p .533 .868 .993 r
F P
0 g
s
.48141 .32005 m .49344 .33397 L .50055 .33996 L p 0 .079 .576 r
F P
0 g
s
.49344 .33397 m .48141 .32005 L .47448 .31403 L p .565 .079 0 r
F P
0 g
s
.42358 .44137 m .42956 .42904 L .46553 .41752 L p .412 .86 .889 r
F P
0 g
s
.46553 .41752 m .45971 .43023 L .42358 .44137 L p .412 .86 .889 r
F P
0 g
s
.53278 .37197 m .53285 .38546 L .52983 .39309 L p .775 .811 .33 r
F P
0 g
s
.49042 .3259 m .50055 .33996 L .50873 .34592 L p 0 .145 .637 r
F P
0 g
s
.50055 .33996 m .49042 .3259 L .48141 .32005 L p 0 .079 .576 r
F P
0 g
s
.46427 .27076 m .48539 .28516 L .47508 .29342 L p .862 .973 .86 r
F P
0 g
s
.48539 .28516 m .46427 .27076 L .48003 .26148 L p .741 .955 .944 r
F P
0 g
s
.48003 .26148 m .50235 .2759 L .48539 .28516 L p .741 .955 .944 r
F P
0 g
s
.50235 .2759 m .48003 .26148 L .50369 .25091 L p .658 .926 .974 r
F P
0 g
s
.50369 .25091 m .52706 .26543 L .50235 .2759 L p .658 .926 .974 r
F P
0 g
s
.45971 .43023 m .46553 .41752 L .49296 .40684 L p .454 .885 .875 r
F P
0 g
s
.49296 .40684 m .48771 .41985 L .45971 .43023 L p .454 .885 .875 r
F P
0 g
s
.45531 .27899 m .47508 .29342 L .47043 .30087 L p .984 .905 .624 r
F P
0 g
s
.47508 .29342 m .45531 .27899 L .46427 .27076 L p .862 .973 .86 r
F P
0 g
s
.52706 .26543 m .50369 .25091 L .5365 .23881 L p .602 .902 .985 r
F P
0 g
s
.5365 .23881 m .56075 .25349 L .52706 .26543 L p .602 .902 .985 r
F P
0 g
s
.53144 .37962 m .52983 .39309 L .52194 .40132 L p .702 .94 .638 r
F P
0 g
s
.48771 .41985 m .49296 .40684 L .51252 .39699 L p .512 .914 .846 r
F P
0 g
s
.51252 .39699 m .50819 .41022 L .48771 .41985 L p .512 .914 .846 r
F P
0 g
s
.45217 .28636 m .47043 .30087 L .47052 .30769 L p .927 .595 .141 r
F P
0 g
s
.47043 .30087 m .45217 .28636 L .45531 .27899 L p .984 .905 .624 r
F P
0 g
s
.52503 .38794 m .52194 .40132 L .50819 .41022 L p .596 .942 .784 r
F P
0 g
s
.52194 .40132 m .52503 .38794 L .53144 .37962 L p .702 .94 .638 r
F P
0 g
s
.50819 .41022 m .51252 .39699 L .52503 .38794 L p .596 .942 .784 r
F P
0 g
s
.50059 .33171 m .50873 .34592 L .51705 .35197 L p 0 .149 .649 r
F P
0 g
s
.50873 .34592 m .50059 .33171 L .49042 .3259 L p 0 .145 .637 r
F P
0 g
s
.56075 .25349 m .5365 .23881 L .57996 .22485 L p .564 .884 .99 r
F P
0 g
s
.57996 .22485 m .6049 .2398 L .56075 .25349 L p .564 .884 .99 r
F P
0 g
s
.45391 .29306 m .47052 .30769 L .47448 .31403 L p .666 .192 0 r
F P
0 g
s
.47052 .30769 m .45391 .29306 L .45217 .28636 L p .927 .595 .141 r
F P
0 g
s
.33046 .45446 m .3359 .44211 L .39082 .42845 L p .36 .827 .898 r
F P
0 g
s
.39082 .42845 m .38461 .44137 L .33046 .45446 L p .36 .827 .898 r
F P
0 g
s
.51095 .33763 m .51705 .35197 L .52452 .35825 L p 0 .091 .616 r
F P
0 g
s
.51705 .35197 m .51095 .33763 L .50059 .33171 L p 0 .149 .649 r
F P
0 g
s
.47448 .31403 m .45965 .29926 L .45391 .29306 L p .666 .192 0 r
F P
0 g
s
.45965 .29926 m .47448 .31403 L .48141 .32005 L p 0 .06 .549 r
F P
0 g
s
.6049 .2398 m .57996 .22485 L .63586 .20868 L p .537 .87 .993 r
F P
0 g
s
.63586 .20868 m .66129 .22399 L .6049 .2398 L p .537 .87 .993 r
F P
0 g
s
.52048 .3438 m .52452 .35825 L .53012 .36488 L p 0 0 .513 r
F P
0 g
s
.52452 .35825 m .52048 .3438 L .51095 .33763 L p 0 .091 .616 r
F P
0 g
s
.38461 .44137 m .39082 .42845 L .43607 .41562 L p .385 .844 .894 r
F P
0 g
s
.43607 .41562 m .42956 .42904 L .38461 .44137 L p .385 .844 .894 r
F P
0 g
s
.4685 .30512 m .48141 .32005 L .49042 .3259 L p 0 .186 .657 r
F P
0 g
s
.48141 .32005 m .4685 .30512 L .45965 .29926 L p 0 .06 .549 r
F P
0 g
s
.53065 .36629 m .53278 .37197 L p .53138 .36546 L 0 0 .275 r
F P
0 g
s
.53278 .37197 m .53272 .35738 L .5281 .35034 L p 0 0 .275 r
F P
0 g
s
.53272 .35738 m .53278 .37197 L .53219 .37539 L p .749 .692 .149 r
F P
0 g
s
.53219 .37539 m .53144 .37962 L p .53177 .37394 L .749 .692 .149 r
F P
0 g
s
.53272 .35738 m .53219 .37539 L .53177 .37394 L .749 .692 .149 r
F
.52503 .38794 m .52839 .37343 L .53055 .36966 L p .726 .912 .549 r
F P
0 g
s
.53144 .37962 m .53319 .36504 L .5331 .3635 L p .749 .692 .149 r
F P
0 g
s
.53232 .36439 m .53144 .37962 L .5331 .3635 L .749 .692 .149 r
F
.53055 .36966 m .53319 .36504 L p .53099 .37121 L .726 .912 .549 r
F P
0 g
s
.53099 .37121 m .52503 .38794 L .53055 .36966 L .726 .912 .549 r
F
.5331 .3635 m .53272 .35738 L p .53232 .36439 L .749 .692 .149 r
F P
0 g
s
.5281 .35034 m .53012 .36488 L .53065 .36629 L p 0 0 .275 r
F P
0 g
s
.5281 .35034 m .53065 .36629 L .53138 .36546 L 0 0 .275 r
F
.53012 .36488 m .5281 .35034 L .52048 .3438 L p 0 0 .513 r
F P
0 g
s
.45624 .2461 m .48003 .26148 L .46427 .27076 L p .768 .961 .931 r
F P
0 g
s
.48003 .26148 m .45624 .2461 L .47881 .23546 L p .674 .932 .969 r
F P
0 g
s
.47881 .23546 m .50369 .25091 L .48003 .26148 L p .674 .932 .969 r
F P
0 g
s
.44174 .2554 m .46427 .27076 L .45531 .27899 L p .901 .967 .816 r
F P
0 g
s
.46427 .27076 m .44174 .2554 L .45624 .2461 L p .768 .961 .931 r
F P
0 g
s
.50369 .25091 m .47881 .23546 L .51072 .22319 L p .611 .906 .984 r
F P
0 g
s
.51072 .22319 m .5365 .23881 L .50369 .25091 L p .611 .906 .984 r
F P
0 g
s
.4342 .26357 m .45531 .27899 L .45217 .28636 L p .998 .829 .487 r
F P
0 g
s
.45531 .27899 m .4342 .26357 L .44174 .2554 L p .901 .967 .816 r
F P
0 g
s
.47954 .31079 m .49042 .3259 L .50059 .33171 L p 0 .238 .703 r
F P
0 g
s
.49042 .3259 m .47954 .31079 L .4685 .30512 L p 0 .186 .657 r
F P
0 g
s
.42956 .42904 m .43607 .41562 L .47186 .4037 L p .418 .864 .886 r
F P
0 g
s
.47186 .4037 m .46553 .41752 L .42956 .42904 L p .418 .864 .886 r
F P
0 g
s
.43264 .27084 m .45217 .28636 L .45391 .29306 L p .83 .416 0 r
F P
0 g
s
.45217 .28636 m .43264 .27084 L .4342 .26357 L p .998 .829 .487 r
F P
0 g
s
.5365 .23881 m .51072 .22319 L .55345 .20897 L p .57 .886 .99 r
F P
0 g
s
.55345 .20897 m .57996 .22485 L .5365 .23881 L p .57 .886 .99 r
F P
0 g
s
.53319 .36504 m .53144 .37962 L .52503 .38794 L p .726 .912 .549 r
F P
0 g
s
.46553 .41752 m .47186 .4037 L .49867 .3927 L p .462 .889 .869 r
F P
0 g
s
.49867 .3927 m .49296 .40684 L .46553 .41752 L p .462 .889 .869 r
F P
0 g
s
.49183 .31642 m .50059 .33171 L .51095 .33763 L p 0 .241 .713 r
F P
0 g
s
.50059 .33171 m .49183 .31642 L .47954 .31079 L p 0 .238 .703 r
F P
0 g
s
.43612 .2774 m .45391 .29306 L .45965 .29926 L p .54 .034 0 r
F P
0 g
s
.45391 .29306 m .43612 .2774 L .43264 .27084 L p .83 .416 0 r
F P
0 g
s
.52839 .37343 m .52503 .38794 L .51252 .39699 L p .618 .944 .75 r
F P
0 g
s
.49296 .40684 m .49867 .3927 L .51722 .38263 L p .527 .92 .833 r
F P
0 g
s
.51722 .38263 m .51252 .39699 L .49296 .40684 L p .527 .92 .833 r
F P
0 g
s
.51252 .39699 m .51722 .38263 L .52839 .37343 L p .618 .944 .75 r
F P
0 g
s
.57996 .22485 m .55345 .20897 L .60885 .19241 L p .541 .872 .992 r
F P
0 g
s
.60885 .19241 m .63586 .20868 L .57996 .22485 L p .541 .872 .992 r
F P
0 g
s
.50437 .32217 m .51095 .33763 L .52048 .3438 L p 0 .194 .69 r
F P
0 g
s
.51095 .33763 m .50437 .32217 L .49183 .31642 L p 0 .241 .713 r
F P
0 g
s
.44374 .28341 m .45965 .29926 L .4685 .30512 L p 0 .172 .637 r
F P
0 g
s
.45965 .29926 m .44374 .28341 L .43612 .2774 L p .54 .034 0 r
F P
0 g
s
.3359 .44211 m .34185 .42862 L .39762 .41431 L p .363 .829 .897 r
F P
0 g
s
.39762 .41431 m .39082 .42845 L .3359 .44211 L p .363 .829 .897 r
F P
0 g
s
.51611 .32818 m .52048 .3438 L .5281 .35034 L p 0 .08 .616 r
F P
0 g
s
.52048 .3438 m .51611 .32818 L .50437 .32217 L p 0 .194 .69 r
F P
0 g
s
.45462 .28906 m .4685 .30512 L .47954 .31079 L p 0 .271 .717 r
F P
0 g
s
.4685 .30512 m .45462 .28906 L .44374 .28341 L p 0 .172 .637 r
F P
0 g
s
.43085 .22969 m .45624 .2461 L .44174 .2554 L p .798 .965 .914 r
F P
0 g
s
.45624 .2461 m .43085 .22969 L .45228 .21898 L p .691 .937 .964 r
F P
0 g
s
.45228 .21898 m .47881 .23546 L .45624 .2461 L p .691 .937 .964 r
F P
0 g
s
.41765 .23897 m .44174 .2554 L .4342 .26357 L p .942 .95 .754 r
F P
0 g
s
.44174 .2554 m .41765 .23897 L .43085 .22969 L p .798 .965 .914 r
F P
0 g
s
.47881 .23546 m .45228 .21898 L .48324 .20655 L p .622 .91 .982 r
F P
0 g
s
.48324 .20655 m .51072 .22319 L .47881 .23546 L p .622 .91 .982 r
F P
0 g
s
.4116 .24707 m .4342 .26357 L .43264 .27084 L p .978 .711 .312 r
F P
0 g
s
.4342 .26357 m .4116 .24707 L .41765 .23897 L p .942 .95 .754 r
F P
0 g
s
.39082 .42845 m .39762 .41431 L .44318 .40095 L p .389 .846 .892 r
F P
0 g
s
.44318 .40095 m .43607 .41562 L .39082 .42845 L p .389 .846 .892 r
F P
0 g
s
.52592 .33459 m .5281 .35034 L .53272 .35738 L p 0 0 .435 r
F P
0 g
s
.5281 .35034 m .52592 .33459 L .51611 .32818 L p 0 .08 .616 r
F P
0 g
s
.51072 .22319 m .48324 .20655 L .52523 .19206 L p .576 .889 .989 r
F P
0 g
s
.52523 .19206 m .55345 .20897 L .51072 .22319 L p .576 .889 .989 r
F P
0 g
s
.46782 .2945 m .47954 .31079 L .49183 .31642 L p 0 .312 .752 r
F P
0 g
s
.47954 .31079 m .46782 .2945 L .45462 .28906 L p 0 .271 .717 r
F P
0 g
s
.41169 .2542 m .43264 .27084 L .43612 .2774 L p .708 .234 0 r
F P
0 g
s
.43264 .27084 m .41169 .2542 L .4116 .24707 L p .978 .711 .312 r
F P
0 g
s
.53265 .34156 m .53272 .35738 L .53293 .3608 L p 0 0 .05 r
F P
0 g
s
.53265 .34156 m .53293 .3608 L .53305 .35904 L 0 0 .05 r
F
.53272 .35738 m .53265 .34156 L .52592 .33459 L p 0 0 .435 r
F P
0 g
s
.53319 .36504 m .53509 .3492 L .53265 .34156 L p 0 0 .05 r
F P
0 g
s
.52839 .37343 m .53204 .35763 L .53341 .35384 L p .74 .86 .43 r
F P
0 g
s
.53341 .35384 m .53509 .3492 L p .53328 .35573 L .74 .86 .43 r
F P
0 g
s
.53328 .35573 m .52839 .37343 L .53341 .35384 L .74 .86 .43 r
F
.53293 .3608 m .53319 .36504 L p .53305 .35904 L 0 0 .05 r
F P
0 g
s
.55345 .20897 m .52523 .19206 L .58009 .17509 L p .545 .874 .992 r
F P
0 g
s
.58009 .17509 m .60885 .19241 L .55345 .20897 L p .545 .874 .992 r
F P
0 g
s
.43607 .41562 m .44318 .40095 L .47877 .38859 L p .423 .868 .882 r
F P
0 g
s
.47877 .38859 m .47186 .4037 L .43607 .41562 L p .423 .868 .882 r
F P
0 g
s
.43612 .2774 m .417 .26056 L .41169 .2542 L p .708 .234 0 r
F P
0 g
s
.417 .26056 m .43612 .2774 L .44374 .28341 L p 0 .097 .568 r
F P
0 g
s
.48237 .2999 m .49183 .31642 L .50437 .32217 L p 0 .313 .76 r
F P
0 g
s
.49183 .31642 m .48237 .2999 L .46782 .2945 L p 0 .312 .752 r
F P
0 g
s
.53509 .3492 m .53319 .36504 L .52839 .37343 L p .74 .86 .43 r
F P
0 g
s
.47186 .4037 m .47877 .38859 L .50491 .37727 L p .472 .894 .861 r
F P
0 g
s
.50491 .37727 m .49867 .3927 L .47186 .4037 L p .472 .894 .861 r
F P
0 g
s
.53204 .35763 m .52839 .37343 L .51722 .38263 L p .642 .942 .705 r
F P
0 g
s
.42662 .26635 m .44374 .28341 L .45462 .28906 L p 0 .26 .701 r
F P
0 g
s
.44374 .28341 m .42662 .26635 L .417 .26056 L p 0 .097 .568 r
F P
0 g
s
.49867 .3927 m .50491 .37727 L .52235 .36697 L p .542 .925 .816 r
F P
0 g
s
.52235 .36697 m .51722 .38263 L .49867 .3927 L p .542 .925 .816 r
F P
0 g
s
.51722 .38263 m .52235 .36697 L .53204 .35763 L p .642 .942 .705 r
F P
0 g
s
.49726 .30543 m .50437 .32217 L .51611 .32818 L p 0 .276 .744 r
F P
0 g
s
.50437 .32217 m .49726 .30543 L .48237 .2999 L p 0 .313 .76 r
F P
0 g
s
.40367 .21213 m .43085 .22969 L .41765 .23897 L p .831 .968 .89 r
F P
0 g
s
.43085 .22969 m .40367 .21213 L .42393 .20136 L p .711 .943 .958 r
F P
0 g
s
.42393 .20136 m .45228 .21898 L .43085 .22969 L p .711 .943 .958 r
F P
0 g
s
.45228 .21898 m .42393 .20136 L .4539 .18878 L p .633 .914 .98 r
F P
0 g
s
.4539 .18878 m .48324 .20655 L .45228 .21898 L p .633 .914 .98 r
F P
0 g
s
.39184 .22137 m .41765 .23897 L .4116 .24707 L p .977 .914 .666 r
F P
0 g
s
.41765 .23897 m .39184 .22137 L .40367 .21213 L p .831 .968 .89 r
F P
0 g
s
.43965 .27174 m .45462 .28906 L .46782 .2945 L p 0 .338 .761 r
F P
0 g
s
.45462 .28906 m .43965 .27174 L .42662 .26635 L p 0 .26 .701 r
F P
0 g
s
.51137 .31124 m .51611 .32818 L .52592 .33459 L p 0 .185 .691 r
F P
0 g
s
.51611 .32818 m .51137 .31124 L .49726 .30543 L p 0 .276 .744 r
F P
0 g
s
.34185 .42862 m .34838 .41379 L .40508 .39879 L p .366 .831 .896 r
F P
0 g
s
.40508 .39879 m .39762 .41431 L .34185 .42862 L p .366 .831 .896 r
F P
0 g
s
.38734 .22936 m .4116 .24707 L .41169 .2542 L p .915 .554 .109 r
F P
0 g
s
.4116 .24707 m .38734 .22936 L .39184 .22137 L p .977 .914 .666 r
F P
0 g
s
.48324 .20655 m .4539 .18878 L .49511 .17401 L p .583 .892 .989 r
F P
0 g
s
.49511 .17401 m .52523 .19206 L .48324 .20655 L p .583 .892 .989 r
F P
0 g
s
.38917 .23631 m .41169 .2542 L .417 .26056 L p .58 .069 0 r
F P
0 g
s
.41169 .2542 m .38917 .23631 L .38734 .22936 L p .915 .554 .109 r
F P
0 g
s
.45515 .2769 m .46782 .2945 L .48237 .2999 L p 0 .37 .789 r
F P
0 g
s
.46782 .2945 m .45515 .2769 L .43965 .27174 L p 0 .338 .761 r
F P
0 g
s
.52355 .31748 m .52592 .33459 L .53265 .34156 L p 0 0 .559 r
F P
0 g
s
.52592 .33459 m .52355 .31748 L .51137 .31124 L p 0 .185 .691 r
F P
0 g
s
.52523 .19206 m .49511 .17401 L .54943 .15662 L p .549 .876 .992 r
F P
0 g
s
.54943 .15662 m .58009 .17509 L .52523 .19206 L p .549 .876 .992 r
F P
0 g
s
.39762 .41431 m .40508 .39879 L .45099 .38484 L p .393 .849 .89 r
F P
0 g
s
.45099 .38484 m .44318 .40095 L .39762 .41431 L p .393 .849 .89 r
F P
0 g
s
.3964 .24243 m .417 .26056 L .42662 .26635 L p 0 .201 .649 r
F P
0 g
s
.417 .26056 m .3964 .24243 L .38917 .23631 L p .58 .069 0 r
F P
0 g
s
.53374 .34497 m .53509 .3492 L p .53445 .34285 L 0 0 .243 r
F P
0 g
s
.53509 .3492 m .53716 .33192 L .53257 .32433 L p 0 0 .243 r
F P
0 g
s
.53716 .33192 m .53509 .3492 L .53333 .35407 L p .736 .774 .277 r
F P
0 g
s
.53333 .35407 m .53204 .35763 L p .53318 .35193 L .736 .774 .277 r
F P
0 g
s
.53716 .33192 m .53333 .35407 L .53318 .35193 L .736 .774 .277 r
F
.52235 .36697 m .52795 .34983 L .53264 .34435 L p .667 .932 .646 r
F P
0 g
s
.53204 .35763 m .53604 .34038 L .53654 .33657 L p .736 .774 .277 r
F P
0 g
s
.53578 .33886 m .53204 .35763 L .53654 .33657 L .736 .774 .277 r
F
.53257 .32433 m .53265 .34156 L .53374 .34497 L p 0 0 .243 r
F P
0 g
s
.53257 .32433 m .53374 .34497 L .53445 .34285 L 0 0 .243 r
F
.53264 .34435 m .53604 .34038 L p .5328 .34666 L .667 .932 .646 r
F P
0 g
s
.5328 .34666 m .52235 .36697 L .53264 .34435 L .667 .932 .646 r
F
.53654 .33657 m .53716 .33192 L p .53578 .33886 L .736 .774 .277 r
F P
0 g
s
.53265 .34156 m .53257 .32433 L .52355 .31748 L p 0 0 .559 r
F P
0 g
s
.47213 .28202 m .48237 .2999 L .49726 .30543 L p 0 .371 .795 r
F P
0 g
s
.48237 .2999 m .47213 .28202 L .45515 .2769 L p 0 .37 .789 r
F P
0 g
s
.44318 .40095 m .45099 .38484 L .48636 .37203 L p .43 .871 .878 r
F P
0 g
s
.48636 .37203 m .47877 .38859 L .44318 .40095 L p .43 .871 .878 r
F P
0 g
s
.40813 .24794 m .42662 .26635 L .43965 .27174 L p 0 .33 .749 r
F P
0 g
s
.42662 .26635 m .40813 .24794 L .3964 .24243 L p 0 .201 .649 r
F P
0 g
s
.53604 .34038 m .53204 .35763 L .52235 .36697 L p .667 .932 .646 r
F P
0 g
s
.47877 .38859 m .48636 .37203 L .51174 .36036 L p .483 .9 .853 r
F P
0 g
s
.51174 .36036 m .50491 .37727 L .47877 .38859 L p .483 .9 .853 r
F P
0 g
s
.37451 .19329 m .40367 .21213 L .39184 .22137 L p .868 .967 .858 r
F P
0 g
s
.40367 .21213 m .37451 .19329 L .39355 .18249 L p .733 .949 .949 r
F P
0 g
s
.39355 .18249 m .42393 .20136 L .40367 .21213 L p .733 .949 .949 r
F P
0 g
s
.48953 .28726 m .49726 .30543 L .51137 .31124 L p 0 .341 .784 r
F P
0 g
s
.49726 .30543 m .48953 .28726 L .47213 .28202 L p 0 .371 .795 r
F P
0 g
s
.42393 .20136 m .39355 .18249 L .4225 .16976 L p .646 .919 .978 r
F P
0 g
s
.4225 .16976 m .4539 .18878 L .42393 .20136 L p .646 .919 .978 r
F P
0 g
s
.52795 .34983 m .52235 .36697 L .50491 .37727 L p .56 .93 .795 r
F P
0 g
s
.50491 .37727 m .51174 .36036 L .52795 .34983 L p .56 .93 .795 r
F P
0 g
s
.36411 .20247 m .39184 .22137 L .38734 .22936 L p .998 .85 .543 r
F P
0 g
s
.39184 .22137 m .36411 .20247 L .37451 .19329 L p .868 .967 .858 r
F P
0 g
s
.4539 .18878 m .4225 .16976 L .4629 .15471 L p .591 .895 .988 r
F P
0 g
s
.4629 .15471 m .49511 .17401 L .4539 .18878 L p .591 .895 .988 r
F P
0 g
s
.42345 .253 m .43965 .27174 L .45515 .2769 L p 0 .392 .795 r
F P
0 g
s
.43965 .27174 m .42345 .253 L .40813 .24794 L p 0 .33 .749 r
F P
0 g
s
.36123 .2103 m .38734 .22936 L .38917 .23631 L p .813 .374 0 r
F P
0 g
s
.38734 .22936 m .36123 .2103 L .36411 .20247 L p .998 .85 .543 r
F P
0 g
s
.50622 .29281 m .51137 .31124 L .52355 .31748 L p 0 .268 .745 r
F P
0 g
s
.51137 .31124 m .50622 .29281 L .48953 .28726 L p 0 .341 .784 r
F P
0 g
s
.49511 .17401 m .4629 .15471 L .51666 .13688 L p .554 .878 .992 r
F P
0 g
s
.51666 .13688 m .54943 .15662 L .49511 .17401 L p .554 .878 .992 r
F P
0 g
s
.36489 .21702 m .38917 .23631 L .3964 .24243 L p .462 0 0 r
F P
0 g
s
.38917 .23631 m .36489 .21702 L .36123 .2103 L p .813 .374 0 r
F P
0 g
s
.44141 .25782 m .45515 .2769 L .47213 .28202 L p 0 .417 .816 r
F P
0 g
s
.45515 .2769 m .44141 .25782 L .42345 .253 L p 0 .392 .795 r
F P
0 g
s
.34838 .41379 m .35559 .39744 L .41331 .38166 L p .369 .834 .895 r
F P
0 g
s
.41331 .38166 m .40508 .39879 L .34838 .41379 L p .369 .834 .895 r
F P
0 g
s
.52097 .29883 m .52355 .31748 L .53257 .32433 L p 0 .117 .65 r
F P
0 g
s
.52355 .31748 m .52097 .29883 L .50622 .29281 L p 0 .268 .745 r
F P
0 g
s
.37415 .22285 m .3964 .24243 L .40813 .24794 L p 0 .283 .709 r
F P
0 g
s
.3964 .24243 m .37415 .22285 L .36489 .21702 L p .462 0 0 r
F P
0 g
s
.46099 .26258 m .47213 .28202 L .48953 .28726 L p 0 .417 .822 r
F P
0 g
s
.47213 .28202 m .46099 .26258 L .44141 .25782 L p 0 .417 .816 r
F P
0 g
s
.53604 .34038 m .54042 .32145 L .53997 .31764 L p .705 .65 .094 r
F P
0 g
s
.53462 .32772 m .53716 .33192 L p .53597 .32518 L 0 0 .408 r
F P
0 g
s
.53716 .33192 m .53943 .31299 L .53248 .30551 L p 0 0 .408 r
F P
0 g
s
.53943 .31299 m .53716 .33192 L .53651 .3368 L p .705 .65 .094 r
F P
0 g
s
.53651 .3368 m .53604 .34038 L p .53679 .33431 L .705 .65 .094 r
F P
0 g
s
.53943 .31299 m .53651 .3368 L .53679 .33431 L .705 .65 .094 r
F
.52795 .34983 m .53412 .331 L .53777 .32546 L p .689 .909 .565 r
F P
0 g
s
.53851 .32039 m .53604 .34038 L .53997 .31764 L .705 .65 .094 r
F
.53777 .32546 m .54042 .32145 L p .53747 .32816 L .689 .909 .565 r
F P
0 g
s
.53747 .32816 m .52795 .34983 L .53777 .32546 L .689 .909 .565 r
F
.53997 .31764 m .53943 .31299 L p .53851 .32039 L .705 .65 .094 r
F P
0 g
s
.53248 .30551 m .53257 .32433 L .53462 .32772 L p 0 0 .408 r
F P
0 g
s
.53248 .30551 m .53462 .32772 L .53597 .32518 L 0 0 .408 r
F
.53257 .32433 m .53248 .30551 L .52097 .29883 L p 0 .117 .65 r
F P
0 g
s
.40508 .39879 m .41331 .38166 L .4596 .36708 L p .397 .852 .888 r
F P
0 g
s
.4596 .36708 m .45099 .38484 L .40508 .39879 L p .397 .852 .888 r
F P
0 g
s
.38812 .228 m .40813 .24794 L .42345 .253 L p 0 .385 .785 r
F P
0 g
s
.40813 .24794 m .38812 .228 L .37415 .22285 L p 0 .283 .709 r
F P
0 g
s
.34316 .17303 m .37451 .19329 L .36411 .20247 L p .908 .959 .812 r
F P
0 g
s
.37451 .19329 m .34316 .17303 L .36092 .16223 L p .758 .954 .938 r
F P
0 g
s
.36092 .16223 m .39355 .18249 L .37451 .19329 L p .758 .954 .938 r
F P
0 g
s
.39355 .18249 m .36092 .16223 L .38881 .14935 L p .66 .924 .974 r
F P
0 g
s
.38881 .14935 m .4225 .16976 L .39355 .18249 L p .66 .924 .974 r
F P
0 g
s
.33424 .1821 m .36411 .20247 L .36123 .2103 L p .991 .748 .382 r
F P
0 g
s
.36411 .20247 m .33424 .1821 L .34316 .17303 L p .908 .959 .812 r
F P
0 g
s
.4225 .16976 m .38881 .14935 L .42838 .13402 L p .599 .899 .987 r
F P
0 g
s
.42838 .13402 m .4629 .15471 L .4225 .16976 L p .599 .899 .987 r
F P
0 g
s
.45099 .38484 m .4596 .36708 L .49471 .35377 L p .437 .876 .873 r
F P
0 g
s
.49471 .35377 m .48636 .37203 L .45099 .38484 L p .437 .876 .873 r
F P
0 g
s
.48111 .26747 m .48953 .28726 L .50622 .29281 L p 0 .393 .814 r
F P
0 g
s
.48953 .28726 m .48111 .26747 L .46099 .26258 L p 0 .417 .822 r
F P
0 g
s
.54042 .32145 m .53604 .34038 L .52795 .34983 L p .689 .909 .565 r
F P
0 g
s
.33306 .18973 m .36123 .2103 L .36489 .21702 L p .688 .196 0 r
F P
0 g
s
.36123 .2103 m .33306 .18973 L .33424 .1821 L p .991 .748 .382 r
F P
0 g
s
.40588 .23267 m .42345 .253 L .44141 .25782 L p 0 .435 .821 r
F P
0 g
s
.42345 .253 m .40588 .23267 L .38812 .228 L p 0 .385 .785 r
F P
0 g
s
.48636 .37203 m .49471 .35377 L .51925 .34175 L p .494 .905 .842 r
F P
0 g
s
.51925 .34175 m .51174 .36036 L .48636 .37203 L p .494 .905 .842 r
F P
0 g
s
.4629 .15471 m .42838 .13402 L .48155 .11574 L p .559 .88 .991 r
F P
0 g
s
.48155 .11574 m .51666 .13688 L .4629 .15471 L p .559 .88 .991 r
F P
0 g
s
.53412 .331 m .52795 .34983 L .51174 .36036 L p .579 .933 .767 r
F P
0 g
s
.51174 .36036 m .51925 .34175 L .53412 .331 L p .579 .933 .767 r
F P
0 g
s
.36489 .21702 m .33863 .19616 L .33306 .18973 L p .688 .196 0 r
F P
0 g
s
.33863 .19616 m .36489 .21702 L .37415 .22285 L p 0 .179 .623 r
F P
0 g
s
.50059 .27268 m .50622 .29281 L .52097 .29883 L p 0 .334 .785 r
F P
0 g
s
.50622 .29281 m .50059 .27268 L .48111 .26747 L p 0 .393 .814 r
F P
0 g
s
.42647 .23707 m .44141 .25782 L .46099 .26258 L p 0 .456 .838 r
F P
0 g
s
.44141 .25782 m .42647 .23707 L .40588 .23267 L p 0 .435 .821 r
F P
0 g
s
.35004 .20162 m .37415 .22285 L .38812 .228 L p 0 .349 .755 r
F P
0 g
s
.37415 .22285 m .35004 .20162 L .33863 .19616 L p 0 .179 .623 r
F P
0 g
s
.51814 .27841 m .52097 .29883 L .53248 .30551 L p 0 .213 .716 r
F P
0 g
s
.52097 .29883 m .51814 .27841 L .50059 .27268 L p 0 .334 .785 r
F P
0 g
s
.35559 .39744 m .36358 .3793 L .42244 .36267 L p .372 .836 .893 r
F P
0 g
s
.42244 .36267 m .41331 .38166 L .35559 .39744 L p .372 .836 .893 r
F P
0 g
s
.44885 .24138 m .46099 .26258 L .48111 .26747 L p 0 .455 .843 r
F P
0 g
s
.46099 .26258 m .44885 .24138 L .42647 .23707 L p 0 .456 .838 r
F P
0 g
s
.36638 .20634 m .38812 .228 L .40588 .23267 L p 0 .43 .813 r
F P
0 g
s
.38812 .228 m .36638 .20634 L .35004 .20162 L p 0 .349 .755 r
F P
0 g
s
.53239 .28485 m .53248 .30551 L .53943 .31299 L p 0 0 .538 r
F P
0 g
s
.53248 .30551 m .53239 .28485 L .51814 .27841 L p 0 .213 .716 r
F P
0 g
s
.41331 .38166 m .42244 .36267 L .46915 .3474 L p .402 .855 .885 r
F P
0 g
s
.46915 .3474 m .4596 .36708 L .41331 .38166 L p .402 .855 .885 r
F P
0 g
s
.54192 .29218 m .53943 .31299 L .54 .31787 L p 0 0 .101 r
F P
0 g
s
.54192 .29218 m .54 .31787 L .54075 .31497 L 0 0 .101 r
F
.54042 .32145 m .54525 .30059 L .54192 .29218 L p F P
0 g
s
.53412 .331 m .54092 .31021 L .54343 .30462 L p .705 .866 .458 r
F P
0 g
s
.54343 .30462 m .54525 .30059 L p .54261 .30778 L .705 .866 .458 r
F P
0 g
s
.54261 .30778 m .53412 .331 L .54343 .30462 L .705 .866 .458 r
F
.54 .31787 m .54042 .32145 L p .54075 .31497 L 0 0 .101 r
F P
0 g
s
.53943 .31299 m .54192 .29218 L .53239 .28485 L p 0 0 .538 r
F P
0 g
s
.47191 .24583 m .48111 .26747 L .50059 .27268 L p 0 .435 .837 r
F P
0 g
s
.48111 .26747 m .47191 .24583 L .44885 .24138 L p 0 .455 .843 r
F P
0 g
s
.38674 .21053 m .40588 .23267 L .42647 .23707 L p 0 .471 .841 r
F P
0 g
s
.40588 .23267 m .38674 .21053 L .36638 .20634 L p 0 .43 .813 r
F P
0 g
s
.4596 .36708 m .46915 .3474 L .50397 .33355 L p .445 .88 .868 r
F P
0 g
s
.50397 .33355 m .49471 .35377 L .4596 .36708 L p .445 .88 .868 r
F P
0 g
s
.54525 .30059 m .54042 .32145 L .53412 .331 L p .705 .866 .458 r
F P
0 g
s
.54092 .31021 m .53412 .331 L .51925 .34175 L p .601 .934 .732 r
F P
0 g
s
.49471 .35377 m .50397 .33355 L .52757 .32117 L p .507 .91 .829 r
F P
0 g
s
.52757 .32117 m .51925 .34175 L .49471 .35377 L p .507 .91 .829 r
F P
0 g
s
.51925 .34175 m .52757 .32117 L .54092 .31021 L p .601 .934 .732 r
F P
0 g
s
.49442 .25062 m .50059 .27268 L .51814 .27841 L p 0 .386 .816 r
F P
0 g
s
.50059 .27268 m .49442 .25062 L .47191 .24583 L p 0 .435 .837 r
F P
0 g
s
.41015 .2144 m .42647 .23707 L .44885 .24138 L p 0 .488 .855 r
F P
0 g
s
.42647 .23707 m .41015 .2144 L .38674 .21053 L p 0 .471 .841 r
F P
0 g
s
.51503 .25597 m .51814 .27841 L .53239 .28485 L p 0 .29 .764 r
F P
0 g
s
.51814 .27841 m .51503 .25597 L .49442 .25062 L p 0 .386 .816 r
F P
0 g
s
.43556 .21817 m .44885 .24138 L .47191 .24583 L p 0 .487 .859 r
F P
0 g
s
.44885 .24138 m .43556 .21817 L .41015 .2144 L p 0 .488 .855 r
F P
0 g
s
.36358 .3793 m .37249 .35908 L .43262 .3415 L p .375 .838 .892 r
F P
0 g
s
.43262 .3415 m .42244 .36267 L .36358 .3793 L p .375 .838 .892 r
F P
0 g
s
.53229 .26209 m .53239 .28485 L .54192 .29218 L p 0 .09 .635 r
F P
0 g
s
.53239 .28485 m .53229 .26209 L .51503 .25597 L p 0 .29 .764 r
F P
0 g
s
.46181 .22207 m .47191 .24583 L .49442 .25062 L p 0 .469 .854 r
F P
0 g
s
.47191 .24583 m .46181 .22207 L .43556 .21817 L p 0 .487 .859 r
F P
0 g
s
.54384 .29703 m .54525 .30059 L p .54512 .29365 L 0 0 .285 r
F P
0 g
s
.54525 .30059 m .55059 .27748 L .54467 .26919 L p 0 0 .285 r
F P
0 g
s
.55059 .27748 m .54525 .30059 L .5424 .30692 L p .708 .794 .32 r
F P
0 g
s
.5424 .30692 m .54092 .31021 L p .54281 .30382 L .708 .794 .32 r
F P
0 g
s
.55059 .27748 m .5424 .30692 L .54281 .30382 L .708 .794 .32 r
F
.54467 .26919 m .54192 .29218 L .54384 .29703 L p 0 0 .285 r
F P
0 g
s
.54467 .26919 m .54384 .29703 L .54512 .29365 L 0 0 .285 r
F
.52757 .32117 m .53681 .29829 L .54451 .29092 L p .623 .93 .686 r
F P
0 g
s
.54092 .31021 m .54847 .28713 L .5497 .28153 L p .708 .794 .32 r
F P
0 g
s
.5483 .28523 m .54092 .31021 L .5497 .28153 L .708 .794 .32 r
F
.54451 .29092 m .54847 .28713 L p .54406 .29431 L .623 .93 .686 r
F P
0 g
s
.54406 .29431 m .52757 .32117 L .54451 .29092 L .623 .93 .686 r
F
.5497 .28153 m .55059 .27748 L p .5483 .28523 L .708 .794 .32 r
F P
0 g
s
.54192 .29218 m .54467 .26919 L .53229 .26209 L p 0 .09 .635 r
F P
0 g
s
.42244 .36267 m .43262 .3415 L .47979 .32546 L p .407 .858 .882 r
F P
0 g
s
.47979 .32546 m .46915 .3474 L .42244 .36267 L p .407 .858 .882 r
F P
0 g
s
.46915 .3474 m .47979 .32546 L .51427 .31105 L p .453 .885 .861 r
F P
0 g
s
.51427 .31105 m .50397 .33355 L .46915 .3474 L p .453 .885 .861 r
F P
0 g
s
.48762 .22633 m .49442 .25062 L .51503 .25597 L p 0 .429 .838 r
F P
0 g
s
.49442 .25062 m .48762 .22633 L .46181 .22207 L p 0 .469 .854 r
F P
0 g
s
.54847 .28713 m .54092 .31021 L .52757 .32117 L p .623 .93 .686 r
F P
0 g
s
.50397 .33355 m .51427 .31105 L .53681 .29829 L p .521 .915 .814 r
F P
0 g
s
.53681 .29829 m .52757 .32117 L .50397 .33355 L p .521 .915 .814 r
F P
0 g
s
.51159 .23118 m .51503 .25597 L .53229 .26209 L p 0 .351 .8 r
F P
0 g
s
.51503 .25597 m .51159 .23118 L .48762 .22633 L p 0 .429 .838 r
F P
0 g
s
.53218 .23688 m .53229 .26209 L .54467 .26919 L p 0 .19 .706 r
F P
0 g
s
.53229 .26209 m .53218 .23688 L .51159 .23118 L p 0 .351 .8 r
F P
0 g
s
.37249 .35908 m .38249 .33638 L .44405 .31774 L p .379 .841 .89 r
F P
0 g
s
.44405 .31774 m .43262 .3415 L .37249 .35908 L p .379 .841 .89 r
F P
0 g
s
.54773 .24366 m .54467 .26919 L .55059 .27748 L p 0 0 .441 r
F P
0 g
s
.54467 .26919 m .54773 .24366 L .53218 .23688 L p 0 .19 .706 r
F P
0 g
s
.43262 .3415 m .44405 .31774 L .49172 .30085 L p .413 .862 .878 r
F P
0 g
s
.49172 .30085 m .47979 .32546 L .43262 .3415 L p .413 .862 .878 r
F P
0 g
s
.55655 .25175 m .55059 .27748 L .5492 .28383 L p 0 0 0 r
F P
0 g
s
.55655 .25175 m .5492 .28383 L .55004 .28024 L 0 0 0 r
F
.55059 .27748 m .55655 .25175 L .54773 .24366 L p 0 0 .441 r
F P
0 g
s
.54847 .28713 m .5569 .26138 L .55655 .25175 L p 0 0 0 r
F P
0 g
s
.53681 .29829 m .54715 .27269 L .55359 .26522 L p .646 .918 .624 r
F P
0 g
s
.55359 .26522 m .5569 .26138 L p .55266 .26917 L .646 .918 .624 r
F P
0 g
s
.55266 .26917 m .53681 .29829 L .55359 .26522 L .646 .918 .624 r
F
.5492 .28383 m .54847 .28713 L p .55004 .28024 L 0 0 0 r
F P
0 g
s
.47979 .32546 m .49172 .30085 L .52581 .28583 L p .462 .889 .854 r
F P
0 g
s
.52581 .28583 m .51427 .31105 L .47979 .32546 L p .462 .889 .854 r
F P
0 g
s
.5569 .26138 m .54847 .28713 L .53681 .29829 L p .646 .918 .624 r
F P
0 g
s
.51427 .31105 m .52581 .28583 L .54715 .27269 L p .537 .92 .794 r
F P
0 g
s
.54715 .27269 m .53681 .29829 L .51427 .31105 L p .537 .92 .794 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[13]:=",
  ImageSize->{288, 164},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000Y1000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo0029Ool2002EOol008Ioo`<00004Agi7W`00002COol008=oo`<00097
O`05Agi7OdMoAgm7OP02002AOol0081oo`<0000=Agi7Wd=nAim7OTNO@gi7WdMnAim3OTNO0000T7oo
001mOol30002Agl01DMnAgm7OdMoAgh00dMo00I7OTMoAgm7OdMnAgl2002>Ool007Yoo`<0000EAgi7
Wd=nAim7OTNO@gi7WdMnAim3OTNOAgi7Wd=nAim7OTNO@gi7WdMn008008aoo`00Mgoo0`0000A;WT^O
00000097O`05Agi7OdMoAgm7OP03Agl01DMnAgm7OdMoAgh00dMo00=7OTMoAgl00P00Rgoo001dOol3
00006D^NBim;WTnOBii;Wd^N0017OTNO@gi7WdMnAim3OTNOAgi7Wd=nAim7OTNO@gi7WdMn00<00004
@gi7O`000029Ool0075oo`<0000;Bii;Wd^NBim;WT^OBii;Wd^NBim;WP0200000dMoAgi7O`02Agl0
1DMnAgm7OdMoAgh00TMo0`000TMo00E3OTMoAgm7Od=n008008Moo`00Kgoo0P0001Q;WT^OBii?Wd^N
Bim;WTnOBii;Wd^NCim;WT^OBii?W`00Aim3OTNOAgi7Wd=nAil4000034=nAgm3OTMo@gi7Od=nAgm3
OTMo@gi7O`8008Eoo`00KGoo0P0001=C_P00001;WT^OBii;Wd^NBim;WT^OBii;Wd^NBim;WT^OBii;
W`0200000dMnAgl000020003Agl01D=nAgm7OdMo@gh00dMo00E3OTMoAgm7Od=n0097O`8008=oo`00
Jgoo0P0000=C_U>oDkh00U>n0P0000m;Wd^NCim;WT^OBii?Wd^NBim;WTnOBii;Wd^NCil00`0001I7
Od=nAgm3OTMo@gi7Od=nAgm3OTMo@gi7Od=nAgm3OTMo@gi7Od=nAgm3OP80089oo`00JGoo0P002E>n
00`004^OBii;Wd^NBim;WT^OBii;Wd^NBil3000014^OBih000000dMo00E3OTMoAgm7Od=n00=7O`05
@gi7OdMoAgm3OP02Agl3000014=oAgl00000P7oo001WOol20003Dkh01E>oDkiC_U>nDkl00e>n00YC
_`00001;WTnOBii;Wd^NCim;WP800007Bim;WT^OAii;Wd^NBil00P0000e3OTMo@gi7Od=nAgm3OTMo
@gi7Od=nAgm3OP03000024=nAgm3OTMo@gi7Od=n001oOol006Eoo`800003Gmd0000000eC_P800003
Bim;WP000080000;Bii;Wd^NBim;WT^OBii;Wd^NBim;WP0200000dMo@gi7O`02Agl00d=nAgm7O`03
00002d=oAgm3OTMo@gm7Od=nAgm3OdMo@gh00P00OGoo001SOol200001EoMHmeOgF?MGmd00P000U>n
00EC_e>nDkiC_U>o00=C_P03DkmC_U>n0080000@Bii;WdNNBim;WT^OAii;Wd^NBim7WT^OBii;WdNN
Bil200000d=nAgm3OP0300004D=nAgm3OTMo@gi7Od=nAgm3OTMo@gi7Od=nAgm3OTMo0000O7oo001R
Ool00`00GmeOg@07Gmd00`00DkiC_P08Dkh2000055>n000004^NBim;WT^OBii;Wd^NBim;WT^OBii;
Wd^NBim;WT^OBih3000054=oAgm3OTMo@gm7Od=nAgm3OdMo@gi7Od=oAgm3OTMo@gm7Od=nAgl2001j
Ool0065oo`0<001cf@00001OgF?MGmeSgEoMHmeOgF?M0P0000=C_U>oDkh00U>n01MC_`00001?WU>o
CiiC_dnN001;WT^OAii;Wd^NBim7WT^OBii;WdNNBim;WT^O0080000HAii;W`000013OTMo@gi7Od=n
Agm3OTMo@gi7Od=nAgm3OTMo@gi7Od=nAgm3OTMo0P00NGoo001QOol01@00LmUcfG?I00002EoM0P00
0U>n0P000e>n00E?_U>nDkiC_Tnn0080000:Bim;WT^OBii;Wd^NBim;WT^OBih200000d^OAii;W`02
Bil04DNN0013OdMo@gi7Od=oAgm3OTMo@gm7Od=nAgm3OdMo@gh010000T=o0P00Mgoo001POol00`00
LmQcf@02LmT037?H000006?MGmeSgEoMHmeOgF?MGmeSg@80000CCiiC_dnNDkm?WU>oCiiC_dnNDkm?
WU>o001;WdNNBim;WT^OAih00`0000U7WT^OAii;WdNNBim7WT^OAih00P0000U7Od=nAgm3OTMo@gi7
Od=nAgl0100000U3OTMo@gi7Od=nAgm3OTMo0000MWoo001OOol01000O^/000001G?I00<005oMGmd0
15oM0P0000=Og@0000000U>n00E?_U>nDkiC_Tnn00=C_P06CkiC_P00001;WT^O0P0000E7WT^OBim;
WdNN00=;W`06Aii;Wd^OBim7WT^O0P0000=3OTMo@gl0100000I7Od=n@gm3OdMo@gh2@gl01DMo@gi3
Od=oAgl00P00M7oo001OOol01@00O^ajjgk[00000g?I00Icf7?I000005oMHmd200004U^mGmiK_EoN
Fkd004nNDkm?WU>oCiiC_dnNDkm?WU>oCiiC_`<0000ABim7WT^OAii;WdNNBim7WT^OAii;WdNNBim7
WT^OAii;W`0400004d=nAgm3OTMo@gi7Od=nAgm3OTMo@gi7Od=nAgm3OTMo@gi7Od=n0080079oo`00
H7oo00@007k[O^]nj`8000Ecf@800008FmeK_EoMFkeKgE^mGmeK_@800003Dki?_U>n009C_P03CkiC
_P000080009?WP8000=;W`05Aii;Wd^OBim7WP03Bil00dNNBim;W`020002Ail20002@gl01TMo@gi3
Od=oAgm3OP93O`06Agm3OT=o@gm7Od=n0T=o00A7Od=n0000075oo`00HGoo0P0000=jjgk[N^/00P00
00Acf@00001[fP800009GmiK_EoNFkeOgU^mGmiK_EoN00800003CiiC_`000080000CDkm?WU>oCiiC
_dnNDkl004^OAii;WdNNBim7WT^OAii;WdNNBil00P0001I7OT^OAgi;WdMnBil004Mo@gi7Od=nAgm3
OTMo@gi7Od=nAgm3OTMo@gi7O`@00004@gi7O`00001_Ool0069oo`080;<00000001jjgk[001_f`=_
fP0<Km/005_MFkeOgE^mFmeK_EoMFkeKgE^m0P002dnN0P000T^O00A7WT^OBim;W`<00006Bim7WTNO
Aim;WdNN0TNO00I;W`000013OdMo@gh2@gl014Mo@gi3Od=o100000=3Od=n@gl00T=o00=3OT=o@gl0
0P00KGoo001SOol00`000;<1E`0400001FoKJmY_ff_JKm/00P0000IK_EoNFkeOgU^mGmh200003eNm
000005>oCiiC_dnNDkm?WU>oCiiC_dnNDkm?WP0200004T^OAih00000Bim7OT^OAgi;WdMnBim7OT^O
Agi;WdMnBim7OP800003Agm3OTMo00@0000>@gi7Od=nAgm3OTMo@gi7Od=nAgm3OTMo@gi7O`8006]o
o`00I7oo00@0002c0001E`@000=_fP06Km]_fP00001OgE^m0P0000=K_U^mFkh00U^n00<004nNCih0
2TnN0`0000E7WTNOAim;WdNN0097W`06Bim7WTNOAim;WdNN0TNO00=;WdNN00000`000d=o00E3OT=o
@gm3Od=n00=3O`05@gi3Od=o@gm3OP03@gl00d=n0000001YOol006Ioo`8000040GL1E`6i0KT60000
2foK000005NmFmiG_E_NEkeKgUNmFmh00P0000M?WU>oCiiC_dnNDkm?WP0300004D^NCil00000Agi;
WdMnBim7OT^OAgi;WdMnBim7OT^OAgh00`0001E7OT^O000004=nAgm3OTMo@gi7Od=nAgm3OTMo@gi7
Od=nAgm3OTMo@gh00`0000A3OTMo000006Moo`00Igoo00D0002c0EL1E`0000@1^@81fPL00003FkiK
_E^n009K_P03Fkd00000009?WP<000=?WP04Cim?WTnNCih20002Ail01T^OAii7WdNOBim7WP<00009
Agi7WdMoAim7OTNOAgl004=n00=3O`05@gi3Od=o@gm3OP03@gl014=n000000001d=o00<007ooOol0
I7oo001XOol01@000;<0005G0000106i00<0007J0MT00P7J00<1n`7j0O/02P0000a;WTnOCii?Wd^N
Cim?WTnOBii?WdnNCil200000dMnBim7OP0300002dMnBim7OTNOAgi;WdMnAim7OT^OAgh00P0000M7
Od=nAgm3OTMo@gi7O`04000034=nAgm3OT=o@gi7Od=n@gm3OTMo@gh006Eoo`00JGoo00Dh00000001
E`0000@1^@030001fP7J0081fP030001nP7j00<1nP040001nP7k0OX70003Cih01TnOCii?WTnNCim?
WP<0000@Agi7WdMoAim7OTNOAgm7WdMnAim7OdNOAgi7WdMoAil20002@gl3000@@gl2001SOol006Yo
o`05>00d00000EL000030KT010000MX1fP7I0P7J0100007j0O/1nP7k0OX0007j0O/1nP7k0OX0007J
0M/1fPD00006Bii?W`00001;WTnO0P000117OT^OAgi7WdMnBim7OTNOAgi;WdMnAim7OT^OAgi7W`<0
000D@gm3OTMo@gi3Od=nAgm3OT=o@gi7Od=n@gm3OTMo@gi3Od=nAgm3OP80069oo`00K7oo00<h0000
00000`0000<1^@000MX00`7J00<0007j0OX00`7j00@0007j0OX1n`<1nP030001fP7J00<1fP030001
^P0000<0000ACim;WTnNBih004MnAim7OdNOAgi7WdMoAim7OTNOAgm7W`03000014NOAgh000003d=o
10000T=o0P00H7oo001]Ool01C@000015@6H0GP01@0001X1f@7J0001n`7j0O/1nP7k0001n`7j0O/1
nP7k0001f`7J0M/1fP7K0MX0006i0KX1^@6j100000U;WP00Agi;WdMnAim7OT^OAgh0100000M7WdMn
Aim7OTNOAgi7W`0200002D=nAgm3OT=o@gi7Od=n@gm3OP04000024=o@gi3Od=n@gm3OT=o@gh2001N
Ool006ioo`07>000004E0001N06H0GP00P6i1@000`7j00D0007j0OX1nP7k0081nP030001fP7J00<1
fP030001^P6j00<1^P030001F@5H00D0000AAgl000000017OdNOAgi7WdMoAim7OTNOAgm7WdMnAim7
O`020003@gl4000>@gl2001LOol0071oo`0<00015@000GP1V05h0001^@6j0KT1^P7I0P0001`1n`7j
0001nP7k0OX1n`7j0001fP7K0MX1f`7J0001^@6j0KT1^P6i0001F05i0EP1N@5H0;H0]@80000@Aim7
OTNOAgi7WdMnAim7OTNOAgi7WdMnAim7OTNOAgh400004d=o@gi3Od=n@gm3OT=o@gi3Od=n@gm3OT=o
@gi3Od=n@gm3OT=o008005]oo`00LGoo0P0000D15P000IP1N00000<1^@040001fP7J0MX50000107j
0O/1nP00107J00<0006j0KX00`6j00X0005I0EP1F@5H0ET0002f0;D0]P80000;Agi7WdMoAim7OTNO
Agm7WdMnAim7O`030002Agl2000?@gl40002@gl2001IOol0079oo`0>0=@000000001V0000KX1^@6j
0KT0007I0MX1f@<1fP030MT0000000@0000K0M/1fP7K0001^P6i0KX1^@6j0001N@5H0GT1F0000;D0
]P2e0;H03@00Agi7WdMnAim7OTNO00@00007@gi7Wd=nAim3OTNO@gh00P0000U3Od=n@gm3OT=o@gi3
Od=n@gl0100000PoOT=o@gi3Ocmn@gm3OT=o0P00Egoo001cOol30=@00`000IP000040KT01@000MX1
fP7J00001P7J0P6j1@00106j00/0005H0ET1F05I0000]P2e0;H0]@0=00800003Agi7W`00008000=7
O`05Agi7OdMoAgm7OP03Agl014MnAgl000000d=o10003T=o0P00EGoo001dOol010000;<0e05G1000
00L1^P000MX1f@7J0MT000020MX02P7I0MX1fP000KT1^P6i0KX0006I0`0000/1^P000GT1F05i0EP0
002e0;H0]@2f00803@<0000AAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7W`0400004T=n
@gloOT=o@gi3Ocmn@gm3OT=o?gi3Od=n@gloOT=o@gi3O`<005Aoo`00MWoo0P3D00@0005G0IP1V0@0
00<1fP030001fP7J00<1fP030001^P6j0081^P040001V@5i0IT30000205I0EP1F@000;H0]@2f0002
00d01000Bih000000dMo00E7OTMoAgm7OdMn00=7O`03Agi7O`0000800097O`8000i3O`@000=3O`80
059oo`00Mgoo00L0/`000EL1E`6H0IT1V0020IT400030MX03P7I0MX0006j0KT1^P6i0001N@6I0GT1
V@000CP200001`5H0000]@2f0;D0000=00800003Bim;WT^O00800007@gi7Wd=nAim3OTNO@gh01000
0157Wd=nAim3OTNO@gi7W`00@gm3OT=o?gi3Od=n@gloOT=o00@00009?gi3Ocmn@gloOT=o?gi3Ocmn
0080051oo`00N7oo0P000P5G00L0006H0IP0006I0KT1V@0400030MX03@000KX1^P6j0001V@5i0IT1
N@000AL1=`4G008000050;H0]@2f00003@0200001D^NBim;WT^OBih00P0000=7OdMn00000P0000E3
OTMoAgm7Od=n00=7O`04@gi7OdMoAgl20003@gl4000?@gl2001>Ool007Uoo`0>054000000EL0006I
0IP0006I0KT1V@6i0IT1^PD0000=0KX1^@000GT1V@5i0IT1N@000AL1>04G05@00P0000/0]@000000
04^NBim7WT^OBii;WdNN00<0000@@gi7Wd=nAim3OTNO@gi7Wd=nAim3OTNO@gi7Wd=nAil400003cmn
@gloOT=o?gi3Ocmn@gloOT=o?gi3Ocmn@gloOP0400000d=o?gh0001=Ool007Yoo`0305415@000080
0081V00;0001V@6i0IT0006I0KT1V@6i0001V@0200002`6j0001N@6I0GT1V@000CP15`4g00000P1C
0P0000IC/`00Bim;WT^OBih300001DNNBil00000@gh00dMo00E3OTMoAgm7Od=n00=7O`<00004Agm3
OP00000<@gl30002@gl01Cmo@gm3Od=o?gl00P00Bgoo001lOol00`000?D15P0300002P6i0IT1^@6I
0001V@6j0IT1^P000P6I100000`1V@5i00015`4h0AL0001C05@0D`00Ci<500003dNNBim7WT^OAii;
WdNN0013OTNO@gi7Wd=nAim3OP04000044Mo@gi7Od=nAgm3OTMo0013Ocmn@gloOT=o?gi3Ocmn0`00
00doOT=o?gi3Ocmn@gloOT=o?gi3Ocmn@gl0001:Ool007eoo`040000m@4F0EL400001`6i0001^@6I
0KT1V@0000<1V@030001F05H00<0000F0CL15`4h0000D`00@kT005>c001;WdNNBim;WT^OAii;Wd^N
Bim7WT^OBih20002Agl3000034=oAgm3OTMo@gm7Od=nAgm3OdMo@gi7O`800093O`@00093O`05?gm3
Od=o@gloO`03@gl01Cmo@gm3Od=o?gl00P00BGoo001nOol01@000?D0005G0EP00P5h100000<1V@6j
0000106I00@0005H0EP1F0<000060AL00000AkT005>c0`0000a;WdNNBim7WT^OAii;WdNNBim7WT^O
Aih300003d=nAgm3OTMo@gi7Od=nAgm3OTMo@gi7Od=nAgm3OP0400003d=o?gi3Ocmn@gloOT=o?gi3
Ocmn@gloOT=o?gi3O`04000013mn@gl00000Agoo001oOol300020EL00`000GP1N0020GP200000`6i
0001V@020IT01P000EP1F05H0000eP80000A@kQ3^D>h001C/`00Cii?_P00Bim7WT^OBii;WdNNBim;
WP0300003TNNBil00000@gm7Od=nAgm3OdMo@gi7Od=oAgl400000d=n@gm3O`020003@gl01Cmo@gm3
Od=o?gl00T=o100000=3Ocmo@gl00T=o00<oOd=o@gl00P00AGoo0020Ool01@2d0000005G00000`5h
00<0005h0GT010000P6I0100005H0EP003Mj0013V4Ni@iQ3^@00Dk<004noCiiC_`800003Aii;W`00
00<00007Aii;WdNNBim7WT^OAih00P0000A7Od=nAgm3OP@00009Agm3OTMo@gi7Od=nAgm3OTMo0080
0004?gi3Ocmn@gl400003Cmn@gloOT=o?gi3Ocmn@gloOT=o?gi3Ocmn00<004=oo`00PGoo0P2c0`00
0`5h00@0005h0GT00081F0D00004>iX004>h@kT3@kP3000014nNCki?WTnn0`0000e7WdNNBim7WTNO
Aii;WdNNAim7WT^OAii7W`0400000d=oAgm3OP02@gl01TMo@gi3Od=oAgm3OP93O`03Agm3OP0000<0
00=3O`05?gm3Od=o@gloO`03@gl00cmo@gl0000300000cmo@gloO`020011Ool0089oo`030;@0/`4F
00<000060GP0005i0GP1N@000P5H0P0000PkVcMj>i/004Ni@iQ3^D>H0`0000=?WU>oCih00P0000i?
_d^N000004^OAii;WdNNBim7WT^OAii;WdNN0P0000m;WdMn0013OTMo@gi7Od=nAgm3OTMo@gi7Od=n
Agl0100000e3OTMo000003mn@gloOT=o?gi3Ocmn@gloOP0400002D=o?gi3Ocmn@gloOT=o?gi3O`02
000oOol008=oo`8000815P040CL0000000020GP30004>iX00`00@kU3^002@kP00d>i001?]@040000
0dnNCim?WP02Cih024nO0017WdNNBim7WTNOAih30002Ail00dNNAim7W`020002@gl01DMo@gi3Od=o
Agl00`0000=3Od=n@gl00T=o00=3OT=o@gl00P000d=o100000doOd=o?gm3Ocmo@gloOd=o?gm3Ocmo
@gloO`03000nOol008Aoo`8000030AH15@4g0081=`<0000:>i/gNS^K=gXkVcMj0013V4>i@iP20000
3DneBk@004^NCkm;WTnoBii?_d^NCkm;WTno0080000AAii;W`000017OT^OAgi;WdMnBim7OT^OAgi;
W`00Agm3OP04000034=o@gi7Od=n@gm3OTMo@gi3Od=nAgm3OP@0000=@gloOT=o?gi3Ocmn@gloOT=o
?gi3Ocmn@gl0100000<oGT=o?eh00P00?7oo0025Ool00`0a000000050007>iX01`00@kP00000?iT0
04ne00<00003Cii?WdnN009?WP05Cim?WTnNCii?W`0300000dNOAii7W`02Ail01DNNAim7WdNOAih0
0TNO0`000T=o00E3OT=o@gm3Od=n00=3O`03@gi3Od=o00<00093O`800009?gm3Ocmo@gloOd=o?gm3
Ocmo00@00005@gloOcmo?gm3O`03?gl00d=o0000000jOol008Eoo`<0008cN`09=g/cN`00=gXkVcMj
>i/gNS^K00<00005@kToV@00BkA?]@0200001e>m000004noBii?_d^N00@0000<Cim;WP00001;WdMn
Bim7OT^OAgi;WdMn0`0000a7OTNO000004=n@gm3OTMo@gi3Od=nAgl400001d=n@gm3OT=o@gi3Od=n
00800003@gloOT=o00@0000=?ei3OcmN@gloGT=o?ei3OcmN@gloGT=o?eh00`00>Goo0021Ool40006
<g/00`00>iXkVP04>iX200001T>I@kToVD>i001?]@80009G_P03DkiG_P0000<00003Bii?Wd^N009;
WP03Cim;WT^N00800003Aii7W`0000<00007Agm7WdMnAim7OdNOAgh00P0000=3Od=n@gl00`000d=o
00E3OT=o@gm3Od=n00=3O`03@gh000000080008oO`05@gloOcmo?gm3O`03?gl00d=o?gloO`040000
0cmo@gloO`02000gOol007ioo`<000<cN`05=g/cNc=k<g/gN`02<g/01@00>i/gNS^K=gX00`0000@o
VD>i?iU3^@D00003EkiC_UNn0080000<Dkh004^NCim;WTnOBii?Wd^NCim;WTnO0`0000e7WdMnAim7
OTNOAgi7WdMnAim7OTNOAgi7W`03000034=o@gi3Od=n@gm3OT=o@gi3Od=n@gm3OP<0000=?gi3O`00
000oGT=o?ei3OcmN@gloGT=o?eh0100000U3OcmN@gloGT=o?ei3OcmN@gl00P00=Goo001kOol30000
0bmK000cN`09<g/00`00>iXkVP03000023Mj=i/004>i?iU3^D>I0002BkH200000e>n00000004Dkh2
0002Bih014nOBii;WT^N0P000T^N0P0000Q7WdMoAim7OTNOAgm7WdMn100000A7WdMo000000=3O`04
@gi3Od=o@gl400001D=n@gm3Od=o@gh00T=o0P000Smo00=3O`0000000P000cmo00E3Ocmo?gloOd=o
00<oO`03@gloO`00008003Aoo`00N7oo0`0000@_FbmL;e/000<cN`05=g/cNc=k<g/gN`03<g/02c^K
000003Mj>i/gNS^K0013^CnI@kT00`0000=;]d^f00000P0000=C_UNnDkh00U>n00IG_U>nDkh004nO
Bih300001T^NBim;WTnOBii;W`800003Agi7W`0000<00008@gi7WdMnAim3OTNOAgi7W`800003@gi3
O`000080000<@gloOT=o@gi3Ocmn@gm3OT=o?gi3Od=n100000e3OcmN@gloGT=o?ei3OcmN@gloGT=o
?ei3O`0400000cmN@gloGP02000bOol007Eoo`<00003;e/_G2mK008_F`03;e`003=k00PcN`<00008
=i/gNS^K=gXgVcMj000oV@800004?iX004^fBkH50007Dkh300000d^NBim;WP02Bih01D^OBii;WT^N
Bil00`0000e7WdMnAim7OdNOAgi7WdMoAim7OTNOAgm7W`0300000d=o@gi3O`02@gl01T=n@gm3Od=o
@gi3O`@00093O`800003?gm3Ocmo008oO`04@gloOcmo?gl40009?gl00`00Oomoo`0_Ool0079oo`<0
0009;e/_G2mK<e`_FbmL;e/cG000008cN`05=g/cNc=k<g/gN`0400001cMj>i/gNS^K=gXkVcMj00<0
0006?iU3VSnI001;]Tng0P0000=KgEoNFmd00P0000=G_U>n00000P0000]?_U>n000004^NBim;WTnO
Bii;Wd^N0080000<Bim7WP000017Wd=nAim7OTNO@gi7WdMn100000]7Wd=n0013OT=o?gi3Od=n@glo
OT=o00<00008@gm3OT=o?gi3Od=n@gloOP800003@gloGT=o00@0000;?ei3OcmN@gloGT=o?ei3OcmN
@gloGP02000bOol006moo`<00003;e/_G2mK008_F`07;e`_FbmK;e/_G2mK00000c=k10000c=k00L0
03NK=gXkVcMj=i/gNP0200001cnJ?iToVSnI?iX004^g00<00005GmeKgE_MFmeOg@020002Dkh01Dnn
DkiC_U>nCkh00P0000=;Wd^N00000P0000I;WT^OBii;Wd^NBil200000dMnAil000030002Agl01D=n
Agm7OdMo@gh00P0000=3Od=n00000`000d=o00E3OT=o@gm3Od=n00=3O`D000/oO`@00003?gl007oo
035oo`00KGoo0P0000l_FbmL;e/cG2mK;e`_Fc=L;e/_G2mK<e`_F`00<g/00`0000`cFc=l<e/cNc=K
<g`003^K=gXkVcMj>i/300001CnJ?iU3VSnI?iX01P0000=KgEoMFmd00P0000YKgP00Dkm?_U>nCkiC
_dnnDki?_P<0000:Aii;Wd^NBim7WT^OBii;WdNNBil3000034NO@gi7Wd=nAim3OTNO@gi7Wd=nAim3
OP<0000;?gi3Od=n@gloOT=o@gi3Ocmn@gm3OP04000034=o?gi3O`00@gloGT=o?ei3OcmN@gloGP@0
0006?gloGT=o?ehoO`00<Woo001]Ool01@00;e/_FbmK;e`00bmK00H_G2mK;e/_FbmL;e/30009<g/0
0`00=gXkV`030002=g/02@00?iToVSnI?iXoV@00AkM;^00300000e_M00000003Fmd00e_N00000002
Dkh40002Ckh02000Bim;WT^OBii;Wd^NBil3000014^OAih004=n0dMo00A3OTMoAgm7O`@00003@gi7
Od=o008000=3O`03@gh0000000<00093O`06@gi3Od=o@gm3OT=o0P000Smo10002Cmo00<007ooOol0
<7oo001/Ool02`00;e/_G2mK<e`_FbmL;e/cG2mK;e`01@0000`cO3=K<g/cFc=l<e/cNc=K<g`cF`00
=gX200002CNK=gXkVcMj000oVD>J?iToVP0200000dNgBkQ7]`0200002V_k001KgUNmFmiG_E_NEkeK
gUNm0P0000M?_dnNDkm?WTnoCiiC_`0200000dNNBil0000200001T^OAii;WdNNBim7WP800003Aim3
OP0000<00009Aim3OTNO@gi7Wd=nAim3OTNO00@0000=?gi3Ocmn@gloOT=o?gi3Ocmn@gloOT=o?gh0
100000]3OcmN?gloGT=o?ehoOcmN@gloGSmo00<0039oo`00K7oo00@002mK;e/_G0<_F`09;e`00000
000_G2mK;e`_F`0000TcN`<000HgN`03000oVSnI00800004?iX004^hAkL400001FOL001KgE_MFmh0
0U_M0P0000=G_@00Ckh01dnn0`0000Y;WdNNBim7WT^OAii;WdNNBim7WP<00009@gm7Od=nAgm3OdMo
@gi7Od=o00@00003Agm3OP000093O`05@gi3Od=o@gm3OP03@gl400000cmn@gm3O`020004?gl60000
0cmo001oo`0bOol006aoo`05000_Fc=L;e/_G00300003RmL:e/_G2mK;e`[F`00<e/cNc=K<g`cFc=k
<e/400002C^K=gXgVcMj>i/gNSNK0013VP0200001S^I?iX004^hAkM;^0<00003IoaSg6Ol00800007
Ekd00000EmiG_EONEkd00P0000=?_dnN00000`0000Y?_d^N0017WT^OAii;WdNNBim7WP<00003Aii;
WdNN00800003Aim3OTNO00@00007@gi7Od=nAgm3OTMo@gh00P0000=3Ocmn@gl01@0000Q3Ocmn@glo
OT=o?gi3Ocmn1@0000PoGT=o?ehoOcmN@gloGP00<goo001[Ool00`00;e/0000300002RmL;e/_G2mK
;e`_FbmL;e/_G0000c=k100000@cFc=k<e/000HgN`<000@oVP030017]`0000@00006HmaWg6?LImaS
g0000UNn00IG_ENnEkiG_UNmEkh200001dnNCki?WTnnCii?_TnN00800003Bim7WP0000800008Aii7
WdNNAim7WTNOAii7W`<00093O`06Agm3OT=o@gm7Od=n0T=o00=7Od=n00000`000d=o00HoOT=o@gm3
Ocmn@gl400000cmo@gloOP0200001Smo?eloOcmO?gloG`8003=oo`00Jgoo0P0000h_FbmL:e/_G2mK
;e`[FbmL;e/_G2]K;e`003=k0`0000`cO2mK<g`_Fc=l;e/003Mj=i/gNS^K=gX200001SMk000oVS^I
?iXkVP<00003AkP005>c00@0000:Io`00000Gm`005NmEmiG_EONEkd200002UNn001?_d^NCkm;WTno
Bii?_d^N0`0000Q7WT^OAii;WdNNBim7WT^O0`0000];WdMn0013OTMo@gi7Od=nAgm3OTMo00@00008
@gi7O`00000oOT=o?gi3O`D00009@gloOT=o?gi3Ocmn@gloOT=o00800006?ei3O`00000oGP00<goo
001ZOol03P00;e`_FbmL;e/_G2mK;e`_FbmL;e/_G2mK;e`300002S=k<e/cNc=K<g/cFc=k<e/cN`00
0SMk0`000SMk00<003nJ?iX00SnJ0P0000=7^DNhAkP0100000McfG?i001OgEoLHmeOg00200001ENn
000005>nEkh00U>n0P0000=?WTnn00000`0000M;WTnO000004NNAim7WP0400001TNOAii7WdNNAim7
WP800093O`@00003@gm3OT=o0093O`03@gi3Od=o00@0000>@gloOT=o?gm3Ocmn@gloOd=o?gi3Ocmo
@gloOP@00003?gloG`0003Aoo`00JWoo00X002mK;e`[FbmL;e/_G2]K;e`_F`D0000<;e/cO2mK<g`_
Fc=l;e/cO2mK<g`003NK0P000SMk00HcNSMk=g/003^I?iX300000dNiAkQ7^@0300004em]001cn@00
KoX006?MGmaSgEoLHmd005NnDkeG_U>nEkiC_ENn00<00008Ckm;WTnoBii?_d^NCkm;WP<0000;Agi;
WdMnAim7OT^OAgi7WdMnBim7OP03000024=n@gm3OTMo@gi3Od=nAgl400003D=n@gl004=o?gi3Ocmn
@gloOT=o?gi3Ocmn00D00003?gi3Ocmn00800003?gl007oo03=oo`00JGoo00P002mK;e`_FbmL;e/_
G2mK0`0000h_FbmL;e/_G000<g/cFc=k<e/cNc=K<g/cFc=k0`001SMk00@003nJ0000008kVP030017
^4Nh00800003CkD000000080009[nP04KoX00000Gm`200000eoM00000003Dkh20002Dkh01@00Bii;
WT^NCil00T^N0P000T^N00T004NOAii7WdNNAim7WTNOAih00`0000A7WTNO00000093O`03@gh00000
008000=3O`04@gi3Od=o@gl200000cmo@gloOP0500000cmo@gloOP02?gl00d=o?ghoO`04000dOol0
06Uoo`05000_G2]K;e`_F`0300003RmK;e`[FbmL;e/_G000<g`_Fc=l;e/cO2mK<g`300000c=l000g
N`02=g/00c=j=g/gN`0300001C^J?i/kVP00AkP00P0000=7^@00DmH00`0000ageP00Ko][nVojJoX0
05_MGmeKg5oMFmd30002Dkh00dnnDkiC_P0200002DnoBih00000Cim;WT^OBii?W`0200000dMnBil0
000300001dMnAim3OTNOAgi7Wd=n00<0000<@gi3Od=n@gm3OT=o@gi3Od=n@gm3OT=o100000ToOT=o
?gi3Ocmn@gloOT=o?gh0100000A3Ocmn@gl003Aoo`00J7oo00<002mL00000`0000d_FbmL;e/_G2mK
;e`_FbmL;e/003=K<g/cF`04000013=l;e/cN`001CMk0P0000<gN`00>iX00S^J00<oVP0000000T>i
00<005>f00000`000WOF0P0000=[nP00Io/00P0000IOgE_M000005_M0006Dkh300000d^NBim;WP02
Bih00d^OBii;WP03000024NOAii7WdNNAim7WTNOAih300001DMnAil004=o@gh00d=o00=3OT=o@gl0
100000I3Od=n000004=o?gh2?gl500001Cmn?gloOd=o?gh00Smo00<007ooOol0<Woo001XOol20000
3RmL;e/_G2]K;e`_FbmL:e/_G2mK;e`[F`00;e/3000022mK<g`_Fc=l;e/cO2mK0002=g/300001SMk
<g/003^J?i/kVP<00003@kU7^D>i00800003CmL0000000800008MmEgeWOE001WnfOlIo][o0800004
EmeKgUOMFmh20002Dkh200001dnnDkh00000Bii;Wd^N00@00007Bim;WP000017WdMnAil0100000Y3
OTNO@gi7Wd=nAil004=o@gi3O`@00008@gi3Ocmn@gm3OT=o?gi3O`@0000:?gi3Ocmn@gloOT=o?gi3
Ocmn@gl3000dOol006Qoo`0=000_G2mK;e`_FbmL;e/_G2mK;e`_FbmL;e/00`0000/cFc=l;e/cNc=K
<g`_Fc=k<e/003Mk008000DgN`07000kVP00000kVS^K00000d>i00<004ng00000`0000IkK`00MmH0
07?h0002Io/00`00Ho`00006Fmd200001U>nCki?_TnnDki?_P<000=;WP05Bim;WT^NBii;W`030000
2DNOAgi7WdMoAim7OTNOAgm7W`050003@gl01D=n@gm3Od=o@gh010000T=o0P000Smo00=3Ocmn0000
1@0000<oOcmn0000=7oo001WOol02P00;e`_FbmL:e/_G2mK;e`[FbmL100000/[F`00;e/cO2mK<g`_
Fc=l;e/cO2mK00<00006<g/gNc=k=g/cNcMk0`0000HkVc^J>i/004Ni@kT300000d^g000000030000
2W]_001_n7?hKoP006Ok001Sg6?l0P0000EGgE_N000005Nm00800003Dki?_P0000800009Cki?_`00
Bim7WT^OBii;WdNN00800008Bim7WP000017Wd=nAim3OP@00003Aim3OTNO00800004?gi3Od=n@gl4
00001cmn@gloOT=o?gi3Ocmn00D00008?ei3OcmN@gloGT=o?eh003Eoo`00Igoo00H002mK;e`_FbmL
;e/40003;e`02BmK000cFc=l;e/cNc=K<g`_F`040007=g/200001C^J>i/kVS^K>iX00`0000I3^P00
CkM?]`00Fk@400000gNc00000002LoP01P00HmaSo6?LHoaSg0800005EmiGgEONEmeGgP020006Ckh0
0`00Bim;WP0300001TNNBim7WT^OAii;W`@00009@gm7Od=nAgm3OdMo@gi7Od=o00@00003@gm3OT=o
0093O`03@gi3O`0000<00093O`80008oO`03?ghoOcmo00@003Eoo`00IWoo00<002mK;e`0100000`[
FbmL:e/_G2]K;e`[FbmL000cO2mK<g`4000022mK<g`_F`00<g/gNc=k=g/400001C^J>i/kVS^K>iX0
0P0000=3^SnI@kX0100000=G/`0000000P0000=ke7NcNm@00P0000A[n@00001So0800009Gm`005Nm
EmiG_EON001GgP00009?_P04Ckm?_TnnCkh300001dNNBim7WT^OAii;WdNN0080000:Bim7WP00@gi7
Wd=nAim3OTNO@gh300001d=nAil00000?gi3Ocmn00@00008@gloOT=o?gi3Ocmn@gloOPD00004?eho
OcmN000eOol006Ioo`<00003;e`_FbmL008_G008;e/_G2mL;e`_FbmL000cO0<00008<e`_Fc=K;e/c
G2mK000gN`@00007=g/cNcMk000kVc^J>i/00`000d>j00=3^@00BkP02P0000acmP00KoY[nF_j001O
gEoLGmeOg000Emd2000015NnDkiC_P000Tnn0`0000M;WTnn000004NNBim7WP03000024NNAim7WTNO
Aih004=nAgl400000d=oAgm3OP02@gl00dMo0000000200001Cmn@gm3Od=o?gh00d=o100000DoOT=o
000003mn00<oO`03001oogoo03=oo`00IWoo00d002]K;e`[FbmL:e/_G2]K;e`[FbmL:e/_G0030000
23=l;e/cO2mK<g`_Fc=l;e/3000023=k=g/cNcMl<g/gN`00>i/300001C^K=gX003nI@kX00P0000A;
^4_H001GePH00005Mfh007?F001[n@0200003F_k001OoEoLGoeOg000DkeGgU>mEmiC_EON00800007
Bii?_d^NCkm;WTnoBih00`0000Q7WT^OAii;WdNNBim7WT^O0`0000M7Wd=nAim3OTNO@gi7W`030000
24=o@gh00000@gloOT=o?gh400001d=o?gi3Ocmn@gloOT=o00H003Eoo`00IGoo00@002mL;e`_F`<_
G003;e/_G2mL00D00007;e/cFbmK<e`_Fc=K;e/0100000LgNc=k=g/cNcMk<g/gN`030004>i/01`00
@kX00000?iX004^h00800003DmD0000000D00004Mk8007?F0003Io/00`00GmaOg@0200000e_M0000
0002Dkh200001E>n000004^NCkh010000T^N0P0000=7WTNOAih0100000A7WdNN00000093O`@00003
@gm3OT=o0093O`03@gi3O`0000<00093O`05?gi3Od=o@gloOP0400000d=o?gl00002000fOol006Eo
o`06000_G2]K;e`[FbmL100000P[FbmL:e/_G000<g`_Fc=l100000P_Fc=L;e/003=k=g/cNcMl1000
00DgNS^K=gXkVcMj00<00003?iY3^P0000<00003DkEGeP0000H00004Nk<00000KoP200001fOkIoX0
0000FmeKg5oM009Kg@80009C_P03CkeC_P0000800007Ckm;WTnoBii?_d^NCkl0100000M7WTNOAii7
WdNNAim7WP0300001d=n@gm3OTMo@gi3Od=n00@00007@gm3OP000013Ocmn@gl0100000LoOT=o?gi3
Ocmn@gloOP02000fOol006Aoo`03000_G2mK00@000<_G006:e/_G2mL;e`003=K0`0000P_G2mK<e`_
FbmL;e/003=k10000S=k00<gN`00>i/00S^K0`0000E3VSnJ?iXoVP000097^@D00003Ihh0000000<0
0003Mk8006oi009_n0800003Ho/00000009Kg@800004Fmd005>nDkh20002Ckh20002Bih400001d^O
Bih00000Aim7WTNO00@00004Aii7W`000002@gl400001D=n@gm3Od=o@gh00T=o100000M3Ocmn@glo
Od=o?gi3O`0400000cmo001oo`0eOol006Aoo`<0000::e/_G2]K;e`[FbmL:e/_G2]K;e`3000023=L
;e/cG2mK<e`_Fc=L;e/3000023=k=g`cNcMl<g/gO000>i/300001C^K=gX003nJ@kX00`0000E;^DNh
001?ee?G00800004Ihh00000LbX300002G?f001_n@00JoX006?lHo]So002000015OMFmiGgE_N0P00
00E?_U>nCkiC_Tnn00<00007Bii;WdNNBim;WT^OAih0100000M7WdMnAim3OTNOAgi7W`0300001d=o
@gi3Od=n@gm3OT=o00@00007@gi3O`00000oOT=o?gh0100000I3Ocmn@gloOT=o000fOol006=oo`03
000[FbmL008_G005:e/_G2mL;e`[F`0500001bmK<e`_FbmL;e/cG2mK00@0008cN`05=g/cNc=k<g/g
N`0300001S^K=g/kVcMk000oVP800003?i/004Ni00<0009Ce`H0000:Lhl00000LmEcmP00JoYWnP00
Ho`2000015ol000005OM0P0000EGgP00001?_U>n0080009?_P800003Bii;W`0000<00007Aii;WP00
0017WTNOAih0100000I7Wd>N000004=o@gh40003@gl00d=n@gm3O`0500001Cmn?gloOd=o?gh00Smo
0`00=Woo001SOol01P00;e`[FbmL:e/_G0@00008:e/_G2]K;e`003=L;e/cG0@00008;e/cG2mK000c
NcMl<g/gO0@00005=gXkVcMk>i/gNP0300000c^J?i/oVP0200000dNj@kT0000400001f>a00000000
Lhh007?C0080000@KoP006_jIoT005oLGoeOg5omGm`005>mEmiC_EONDkd200000dnnBki?_`02Ckh3
00001d^OAii;WdNNBim7WT^O00@00007@gi7Wd=nAim3OTNO@gh00`0000@oOT=o@gi3O`H00003?gi3
Ocmn00800003@gloOT=o00@00003?gh007oo03Ioo`00HWoo00<002mL;e`0100000T_G2]K;e`[G2mL
:e/_G000<e`00`0000P_G2mK;e`_FbmL;e/003=k100000LcO3=k<g/003^K=g/kV`02000013Mk000o
VSnK0`0000E7^TNiAkX004oH00<00004Hk800000Kk020002Lm<02@00JoP006_j001Sn`00GmaOo002
000015_M001CgEON0P0000=C_@0000000Tnn0P0000I?_T^n000004^OAih40002Aih200000dNOAii7
W`0400000d=nAim3OP0400000d=o@gi3O`02@gl014=n@gm3Od=o1@000cmo0`00=goo001ROol30000
2R]K;e`[FbmL:e/_G2]K;e`[FbmL0`0000PcG2mK<e`_Fc=L;e/cG2mK0`0000PcNc=l<g/gO3=k<g`0
03^K0`0000@kW3Mk000kVP800004?i/004Nj@kT300000doH001GeP0400000fna001cd`0200001fof
001[m`00Ho]Wnf?j00800004FmeKg5_MFm`2000015?NDkeCgU>m0`0000E;WTnoBii?_T^N00<00007
Aii;WdNNBim7WT^OAih0100000A7Wd=nAim3OP<00007@gi7W`00000oOT=o?gh01P0000=3Ocmn@gl0
1@00>Woo001QOol02P00:e`_G2]K;e`[G2mL:e/_G2]L1@0000L_FbmL;e/_G2mK;e`_F`0400001C=l
<g/cNc=k<g`00S=k0`0013Mk0`0000<kVSnK>i/00`0000=3^P0000000P0000EGe`00GmD006OD0080
0004Km<006ofKoH200001FOi001Sn`00Go`00P0000MKg@00001Gg@00DkeC_P0200001DnnDkh004nn
Bkh00`0000A;WT^n001;W`97WP@00005Aii7W`00Aim3OP0300001D=n@gm3OT=o@gh01@0000DoOT=o
@gm3Ocmn00@003moo`00HGoo00H002mL:e/_G2]K;e`4000022/k;e`[>bmL000cG2mK<e`4000022mK
;e`_F`00<g/cO3=k=g`300001C=l000kVcMk>i`00P0000DgN`00>iXoVc^J00800006AkY3^TNj001;
fD^i1@0000EWd`00Jm<006_e0080000>JoT006_jIoT005okHoaOnf?l001KgEOMFmeGg@800004Dki?
_E>nCkd300001D^NCkm;WT^oBih0100000I;WdNNAim7WT^OAih3000014=nAim3OTNO100000I3OT>O
@gh003mn@gl40013Ool0061oo`03000_G2]K00@00009;e`[G2mL:e/_G2]L;e`002mL00<000<_G005
;e/_G2mL000cN`0400001C=l<g/cO000=g/00`000SMk00<003^J00000P0000<kV`00@kX00`0000M;
^D_I001Cf000FmMKeP02000036_D001[mV_f001Wn000IoT006?j001Oo0800003Fo`005OM00800004
Dmd004nnDkh20002Ckh00`00Bki;WP030002Bih20002Aih400000dNNAim7WP0400001T=o@gi3Od=n
@gm3OP@004Moo`00H7oo0`0000X[>bmL:c/_G2/k;e`[>bmL:c/_G0<00007<e`_FbmL;e/cG2mK;e`0
100000HcFc=l<e/cO3=K<g`3000013Ml=g/gO3Mk0`0000<kVSnK>i/00`0000<oVP00BkT01@0000IK
eUog001SmP00IoL200004FOg001Wn000HoYSnf?j001Kg5omFmaOo@00EmiCgEONDmd00P000dnn00Y?
_@00000004NNBkm;WT^oAii;_`<00005Aim7WTNO@ii7W`0200001T=nAil004>O@gi7W`@004]oo`00
Ggoo00X002]K;e`[G2mL:e/_G2]L;e`[F`D0008_G003;e/_G2mL00@00007;e`_F`00<g/cO3=k<g`0
0`0000<cO000=g/00SMk0P0000<gN`00>i/00S^K0P0000=3^d>j00000P0000=7^T^j00001@0000AS
mP00IoH0009Wn0800007HoT00000001On`00Fm`00P0000=Kg@00Emd00P0000AC_@00Cki?_P800004
Bki?_P000002Bih300000d^NAih00002Aih3000014NOAii7Wd>N1000Cgoo001OOol01P00;e`[>bmL
:c/_G0@00006:c/_G2/k;e`003=L100000L_FbmL;e/_G2mK000cF`0400001C=l;e/cO000=g`00`00
00@gO3=k000kVP@0000=@k/00000?iX004NiBmY7^@00CmT005OHFoT00P0000=Km`00GoP00P0000aS
nP00IoX005olGo]Oo5ok001Gg5_MEm`2000015?NCkeCgU>m0P0000E?_T^nCki;_Tnn00<00005Bim7
WT^OAii;W`0300000dNO@gi7W`04001COol005ioo`03000_G2]L00@00006;e`[G2]L:e`_G2]L1000
0bmL00@_FbmL;e`_G0@00006<e/cO3=K<g`cFc=l0`000SMk00<gO3Mk00000P000c^K0P000SnK00=3
V`00BkX020000Uoh00<006?h00000V?i0P0000=On`00Go/00P0000QKo000000005OM001C_E?N0P00
00A?_P00Bki?_P<0009;_P030017WT^N00<00097WP@005Moo`00GWoo0`0000H[>bmL:c/_G2/k;e`4
00001b/k000_FbmL;e/_G2mK00@00006;e`003=l;e/cO2mK1@0000<cNcMl<g/00`0000@cN`00>i/k
V`<00003@k/oVT>k00<00007Ak/004oJBmT005?IEoX01@0000IOnP00001KnP00GoX2000025_lFmaK
o000EmeCgEOMDmd2000015>nCkeC_Tnm0P0000A?_d^NCki;WP@00003Bim7WP00008005]oo`00GWoo
00<002mL:e`00R]L100000L[G2/l:e`[?000;e/_G0040005;e`5000012mK<e`cG3=L100000DcNcMl
=g/003^K00800003>i/003nK00@00003AkX0000000@0009Cf@07001GnE_i001OnU_i00000Uoj0P00
00=Kne_l00000P0000=Gg@00Emd00P0000ACg@00CkiC_P800003Ckh0000000<00003Bii;_T^N00<0
05ioo`00GGoo00<002mL00000`0000L[>bmL:c/_G2/k;e`[>`0400001RmL;e/_G2]K;e`_F`@00006
<g`_Fc=l;e/cO2mK0`0000DcNcMl<g/gO3=k00<00003=g/kW000008000<oV`800006@kY7^`00Bm];
^T_K0P0000A?fP00001GnP800006EoX00000Fo/005ol0P0000=Gg5_mEm`00P0000=CgU?MDmh00`00
00Q?_T^m000004nn001;_d^N0`00HGoo001MOol200001b]L:c`[G2/l:e`[?2]L00D000D_G0@0008_
G005000cG3=L<e`_F`0300001BmL000gNcMl<g/010000S^K0P0000@gO000?i/oV`<00004@kY3^`00
0003BmX02P00CmYCfP00EoYGfP00EoYKn`000U_k0P0000=Go5OL00000P0000=CgEOM00000P0000=C
gTnm00000P000d^n0`00I7oo001MOol01@00;e`[>bmL:c/0100000H_G2/k;e`[>`00:e/400001bmL
;e/_G2]K;e`003=l00@00005;e/cO2mK000cN`03000013=k=g`cNc^L0P0000<gNc^L=g/00`0000<k
VcnL00000P0000=3^`00Bm/02`0000IGn`00001Cf`00Em/2000025OM00000000Dmd005?NCkd20000
0dnn001?_P02001WOol005aoo`03000[G00000<00006:c`[G2/l:e`[?2]L10001bmL100000DcG2mL
<e`_G3=L00@00004<g/cO3=l=g`3000013]l=g/gO3Mk0P000cnK0P000T>k0`0000=;^dNk00000ToK
00X005?KDm/005?KEm]Cf`00Em]Gg08000=Cg003001CgE?M009Cg@800003Cke?_Tnm008006Uoo`00
G7oo0P0000H_G2/k;e`[>bmL:c/400001b]L000_G2mK;e`[FbmL00@00003:e/002mK00H00004<e`0
03Ml<g/400000cMl000kW00500000cnL0000000200001Snk000004>l001;f`P00003Cm/0000000@0
0003Dm`005OM00800003Cm`004oM00800003Cmh004nn008006]oo`00G7oo00D002]L:c`[G2/l00<0
0005:c`[G2/l:e`00002;e`40003;e`40003;e`00c=L;e`_G0040002<g`00c=k000000020003=g`3
00000c^L>i/0000200000cnK@k/0000200000dNk00000002Bm/02000Cm]?fdoK001Cg5?K0003Dm`2
00000e?MCm`0000200000dnmCmd00002001]Ool005]oo`03000_G00000<00005:c/[G2/k;e`[>`05
00000b]K;e`[F`0400001RmL000cG2mK<e`_F`D00003<g/gO00000<00003<e/003Mk00D00007>i/0
0000000kV`00?i/00`0000A7^`000017_0@00003Cm/0000000<00005Cm/00000001?g00300000dnl
Dmd00002001`Ool005]oo`800004:e`[?2]L:c`5000012/l000_G2mL10000RmL00@[G2mL000cG0@0
00<_G0@000@cO0<0008gO005=g/00000000kV`02>i`300001SnK00000000@k]7_0800005Ak];_000
001;g0020002Cm`200001ToL000004_L001?g@8007=oo`00FWoo00<002/k0000100000D[>bmL:c`[
G2/k00@00007;e`[G2mL:e/_G2]L;e`00`0000<cG2mK<e`0100000D_G000<e/gO3=K00@00003=g`0
000000<00003>i`0000000<00006?i`00000>i/004>k0P0000E3_000000004Nl0080000:Bka;g000
001;_4oM001?gD^lCmd2001eOol005Uoo`<000H[?0@00005:c`002mL;e`[G002;e`500000bmL0000
00020004;e`00`00<g`0000200000c=L<g`000020003=g`30003>i`30002?i`300001D>k00000000
Ak`00`0000E;_000000004_L00800004Bkd00000001gOol005Uoo`05000[G2/k;e`[?00400001b]L
:c/[G2/l000[FbmL00@00003:c`_G2/k00<00006;e/cG2mL<e`_Fc=L100000<cG3=l00000`0000<c
N`0000000P0000<gO000>i`00`0000<kW000?i`01P0000HoV`00000004>lAk`200001TNlBkd00000
Aka;g@8007Uoo`00F7oo00<002/l00000`001R/l1@000bmL1@000RmL1P0000<_G000<g`00`0000<c
O3=L00000P0000@cO3Ml=g`gO0<00003>i`gO3^L00D00003>i`004>L00800003?i`004>l00<00003
Ak`0000000@007]oo`00F7oo0P0000D[G2/l:e`[>b]L00D00004:c`002mL:c`400000bmL:c/_G004
0002;e`00bmK<e`_G00400000c=l;e/0000300000cMl<g`0000400000cMk0000000400000cnL>i`o
W00300000d>L?i`0000200000d>L00000003001oOol005Moo`03000[?2/l00D000@[?0D00003:e`_
G2]L00D0008_G0H00003;e`003=L00<00003;e`0000000<00003<g`gO3=l00H00003=g`003^L00@0
0003?i`0000000D00003@i`00000085oo`00Egoo0`0000@[?2/k:c`[?0D000049c/002/l;e`40000
0b/k;e`[?00400000bmL;e/_G002;e`8000012mL000cO3Ml1`000SMl00HkO000000003^M>g`60000
0cnM0013_@020023Ool005Ioo`03000[?2/l00D000H[?0<00003;e`[G2]L00D0008_G0X00003<e`_
G3=L00D0008cO0<00003=g`0000000800003=g`003^L00D0008oW004?id000000025Ool005Ioo`<0
00059c/[?2/l:c`W>`02:c`01P009c/[?000;e`[>`@00003;e`[?2mL00@00003:e`_G00000@00003
<e`_G00000<00004<e`_G000<g`300001S=L00000000<g`gO@8gO0D00003>id003nM00<008Qoo`00
EWoo1@0022/l0`0000<[?2]L:c`01@0000<_G00000000P000bmL100000@_G3=L;e`cG0P00003<e`0
03Ml00H00003>g`gO3]l00<008]oo`00F7oo20000R/l00<002/l;e`0100000<[?2mL00000`0000@[
G2mL;e`_G0<00004;e`003=L;e`8000013=l<e`cOC=L1P0000<gO@00>id00`00SWoo001LOol00`00
:c`[?003:c`90002:c`00`00;e`000030002;e`80002;e`00`00<e`cO006000013=l=g`gO3Ml0`00
TGoo001NOol00`009c`[?004000022/l;e`[?2mL:c`_G2/l;e`<000012mL<ed_G3=L200000<_G000
<g`01000U7oo001QOol80003:c`30002;e`50002;e`900000c=L00000004002HOol006Aoo`H00003
:e`002mL00@00004:c`_G2/l;ed=002NOol006Moo`04000[?2/l:c`20003;e`01B]L;e`002mL:e`0
1P00YGoo001ZOol400000bmM:c`00006002YOol006eoo`D00:ioo`00ogoo8Goo003oOolQOol00?mo
ob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {163, 0}} -> {-0.0012518, 0.127274, \
0.00322283, 0.00322283}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[13]="]
}, Open  ]],

Cell["\<\
Notice that depending on the values of the parameters mu0 and mu1, there may \
be 0, 1, or 3 equilibria.\
\>", "Text",
  CellTags->{"Equilibrium Surface", "i:2"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Method", "Section",
  CellTags->"Introduction"],

Cell[CellGroupData[{

Cell["Summary", "Subsection",
  CellTags->"Introduction"],

Cell["\<\
The approach is simple in concept. We obtain a system of vector fields that \
define independent flows on the surface, integrate them and generate a \
composition starting at the given nominal point. To integrate each vector \
field we use the exponential map and truncate, hence the results are local.\
\>", "Text",
  CellTags->"Introduction"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Exponential Map", "Subsection",
  CellTags->{"Exponential Map", "i:3"}],

Cell[TextData[{
  "As an example of the flow computation consider the vector field f(x) on ",
  Cell[BoxData[
      \(TraditionalForm\`R\^3\)]],
  ":"
}], "Text",
  CellTags->{"Exponential Map", "i:3"}],

Cell["\<\
f={x1^2+x2,x2,-x3*x2};
x={x1,x2,x3};\
\>", "Input",
  CellLabel->"In[14]:=",
  CellTags->{"Exponential Map", "i:3"}],

Cell["\<\
The flow can be computed up to finite order in the \"time\" parameter:\
\>", "Text",
  CellTags->{"Exponential Map", "i:3"}],

Cell[CellGroupData[{

Cell["Flow=ExpMap[f,x,s,4]", "Input",
  CellLabel->"In[16]:=",
  CellTags->{"Exponential Map", "i:3"}],

Cell[BoxData[
    \({x1 + s\ \((x1\^2 + x2)\) + 
        1\/2\ s\^2\ \((x2 + 2\ x1\ \((x1\^2 + x2)\))\) + 
        1\/6\ s\^3\ \((\((1 + 2\ x1)\)\ x2 + \((x1\^2 + x2)\)\ \((4\ x1\^2 + 
                    2\ \((x1\^2 + x2)\))\))\) + 
        1\/24\ s\^4\ \((x2\ \((1 + 2\ x1 + 4\ x1\^2 + 
                    4\ \((x1\^2 + x2)\))\) + \((x1\^2 + x2)\)\ \((2\ x2 + 
                    12\ x1\ \((x1\^2 + x2)\) + 
                    2\ x1\ \((4\ x1\^2 + 2\ \((x1\^2 + x2)\))\))\))\), 
      x2 + s\ x2 + \(s\^2\ x2\)\/2 + \(s\^3\ x2\)\/6 + \(s\^4\ x2\)\/24, 
      x3 - s\ x2\ x3 + 1\/2\ s\^2\ \((\(-x2\)\ x3 + x2\^2\ x3)\) + 
        1\/6\ s\^3\ \((\(-x2\)\ \((\(-x2\) + x2\^2)\)\ x3 + 
              x2\ \((\(-x3\) + 2\ x2\ x3)\))\) + 
        1\/24\ s\^4\ \((\(-x2\)\ \((x2\ \((\(-1\) + 2\ x2)\) - 
                    x2\ \((\(-x2\) + x2\^2)\))\)\ x3 + 
              x2\ \((\(-x3\) + 4\ x2\ x3 - 
                    x2\ \((\(-1\) + 2\ x2)\)\ x3 - \((\(-x2\) + 
                          x2\^2)\)\ x3)\))\)}\)], "Output",
  CellLabel->"Out[16]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Composing Flows to form a Surface", "Subsection",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< ProPac`\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \("\n    This is ProPac - Version 2.0\n \n ProPac has been successfully \
loaded. It contains packages\n for multibody dynamics, linear control and \
nonlinear control.\n Appropriate packages will be loaded automatically as \
required.\n Packages can be manually loaded by simply entering \
GeometricTools,\n Dynamics, LinearControl, NonlinearControl or MEXTools as \
desired.\n Once a package is loaded, enter ?GeomtricTools, ?Dynamics,\n \
?LinearControl, ?NonlinearControl, or ?MEXTools, respectively,\n to obtain a \
list of available functions. Help is also available\n in the Help Browser \
under Add-ons."\)], "Print",
  CellLabel->"From In[17]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GeometricTools\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \(GeometricTools\)], "Output",
  CellLabel->"Out[18]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["FlowComposition", "Subsubsection",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?FlowComposition\)\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \("FlowComposition[Phi,s,Var,Var0,Param,m] returns the composition of the\
\n list of flows, Phi. s denotes the flow independent variable, Var is a\n of \
dependent variables, Var0 is the initial point from which\n the flows \
eminate, Param (optional - default s) is a list of names\n for the \
parameters, and m (optional -default 3) is the desired order\n of the result. \
It can be called with any of the\n following argument sets:\n \
FlowComposition[Phi,s,Var,Var0]\n FlowComposition[Phi,s,Var,Var0,m]\n  \
FlowComposition[Phi,s,Var,Var0,Param]\n \
FlowComposition[Phi,s,Var,Var0,Param,m]\n The composition can also be \
obtained without truncation using:\n FlowComposition[Phi,s,Var,Var0,Infinity]\
\n  FlowComposition[Phi,s,Var,Var0,Param,Infinity]\n However, the composition \
of complex functions can be time consuming. "\)], "Print",
  CellLabel->"From In[19]:="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1", "Subsubsection",
  CellTags->{"Composition", "i:4"}],

Cell["\<\
In this example,we begin with an implicit representation of a manifold and \
proceed to generate a parameteric representation, step by step.\
\>", "Text",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Feq = {x1^3 + mu1*x1 + mu0};\)\), "\n", 
    \(DF = Jacobian[Feq, {mu0, mu1, x1}]\)}], "Input",
  CellLabel->"In[20]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \("  *** LinearControl successfully loaded ***"\)], "Print",
  CellLabel->"From In[20]:="],

Cell[BoxData[
    \({{1, x1, mu1 + 3\ x1\^2}}\)], "Output",
  CellLabel->"Out[21]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Fields = SpecialNullSpace[DF]\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \({{\(-mu1\) - 3\ x1\^2, 0, 1}, {\(-x1\), 1, 0}}\)], "Output",
  CellLabel->"Out[22]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Flow1 = ExpMap[Fields[\([1]\)], {mu0, mu1, x1}, s, 4]\), "\n", 
    \(Flow2 = ExpMap[Fields[\([2]\)], {mu0, mu1, x1}, s, 4]\)}], "Input",
  CellLabel->"In[23]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \({mu0 - s\^3 - 3\ s\^2\ x1 + s\ \((\(-mu1\) - 3\ x1\^2)\), mu1, 
      s + x1}\)], "Output",
  CellLabel->"Out[23]="],

Cell[BoxData[
    \({mu0 - s\ x1, mu1 + s, x1}\)], "Output",
  CellLabel->"Out[24]="]
}, Open  ]],

Cell["The parameters can be specified (e.g. p1, p2)", "Text",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FlowComposition[{Flow1, Flow2}, 
      s, {mu0, mu1, x1}, {0, 0, 0}, {p1, p2}]\)], "Input",
  CellLabel->"In[25]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \({\(-p1\^3\) - p1\ p2, p2, p1}\)], "Output",
  CellLabel->"Out[25]="]
}, Open  ]],

Cell["or left as the default s1, s2", "Text",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FlowComposition[{Flow1, Flow2}, 
      s, {mu0, mu1, x1}, {0, 0, 0}]\)], "Input",
  CellLabel->"In[26]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \({\(-s1\^3\) - s1\ s2, s2, s1}\)], "Output",
  CellLabel->"Out[26]="]
}, Open  ]],

Cell["\<\
Sometimes it is convenient to reorder the dependent variables:\
\>", "Text",
  CellTags->{"Composition", "i:4"}],

Cell["\<\
f1={s+x1,-s^3-mu1*s+mu0,mu1};f2={x1,-x1*s+mu0,s};Phi={f1,f2};\
\>", "Input",
  CellLabel->"In[27]:=",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{

Cell["FlowComposition[Phi,s,{x1,mu0,mu1},{0,0,0}]", "Input",
  CellLabel->"In[28]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \({s1, \(-s1\^3\) - s1\ s2, s2}\)], "Output",
  CellLabel->"Out[28]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2", "Subsubsection",
  CellTags->{"Composition", "i:4"}],

Cell["\<\
This example begins with a pair of vector fields. The flows are computed and \
then composed. In this case, we want a 5th order approximation in the \
parameters.\
\>", "Text",
  CellTags->{"Composition", "i:4"}],

Cell["gam1={1,-3*x1^2-mu1,0};gam2={x1^3,-x1,1};", "Input",
  CellLabel->"In[29]:=",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{

Cell["ff1=ExpMap[gam1,{x1,mu0,mu1},s,5]", "Input",
  CellLabel->"In[30]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \({s + x1, mu0 - s\^3 - 3\ s\^2\ x1 + s\ \((\(-mu1\) - 3\ x1\^2)\), 
      mu1}\)], "Output",
  CellLabel->"Out[30]="]
}, Open  ]],

Cell[CellGroupData[{

Cell["ff2=ExpMap[gam2,{x1,mu0,mu1},s,5]", "Input",
  CellLabel->"In[31]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \({x1 + 
        s\ x1\^3 + \(3\ s\^2\ x1\^5\)\/2 + \(5\ s\^3\ x1\^7\)\/2 + \(35\ s\^4\
\ x1\^9\)\/8 + \(63\ s\^5\ x1\^11\)\/8, 
      mu0 - s\ x1 - \(s\^2\ x1\^3\)\/2 - \(s\^3\ x1\^5\)\/2 - \(5\ s\^4\ \
x1\^7\)\/8 - \(7\ s\^5\ x1\^9\)\/8, mu1 + s}\)], "Output",
  CellLabel->"Out[31]="]
}, Open  ]],

Cell["Phi={ff1,ff2};", "Input",
  CellLabel->"In[32]:=",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{

Cell["FlowComposition[Phi,s,{x1,mu0,mu1},{0,0,0},5]", "Input",
  CellLabel->"In[33]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \({s1 + s1\^3\ s2, \(-s1\^3\) - s1\ s2 - \(s1\^3\ s2\^2\)\/2, 
      s2}\)], "Output",
  CellLabel->"Out[33]="]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Some Pitfalls", "Section",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{

Cell["Example 1: Implicit set is not a regular manifold", "Subsection",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \(Clear[x, y]\)], "Input",
  CellLabel->"In[34]:=",
  CellTags->"Pitfalls"],

Cell[BoxData[{
    \(\(f1 = {\((x^2 + y^2 - 1)\)*y};\)\), "\n", 
    \(\(var1 = {x, y};\)\)}], "Input",
  CellLabel->"In[35]:=",
  CellTags->"Pitfalls"],

Cell["\<\
The set of points that satisfies f1(x,y)=0 includes the unit circle and the \
x-axis. It is the union of two regular manifolds, but the points {-1,0} and \
{1,0} are singular points.\
\>", "Text",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot[{{Cos[k1], Sin[k1]}, {k1/4, 0}}, {k1, \(-2\)*Pi, 2*Pi}, 
      PlotStyle\  -> \n\ \ \ \ \ {{RGBColor[1, \ 0, \ 0]}, \ {RGBColor[0, \ 
              1, \ 0]}}]\)], "Input",
  CellLabel->"In[37]:=",
  CellTags->"Pitfalls"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.303152 0.309017 0.294303 [
[.04527 .29652 -12 -9 ]
[.04527 .29652 12 0 ]
[.19685 .29652 -6 -9 ]
[.19685 .29652 6 0 ]
[.34842 .29652 -12 -9 ]
[.34842 .29652 12 0 ]
[.65158 .29652 -9 -9 ]
[.65158 .29652 9 0 ]
[.80315 .29652 -3 -9 ]
[.80315 .29652 3 0 ]
[.95473 .29652 -9 -9 ]
[.95473 .29652 9 0 ]
[.4875 .01471 -12 -4.5 ]
[.4875 .01471 0 4.5 ]
[.4875 .16187 -24 -4.5 ]
[.4875 .16187 0 4.5 ]
[.4875 .45617 -18 -4.5 ]
[.4875 .45617 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04527 .30902 m
.04527 .31527 L
s
[(-1.5)] .04527 .29652 0 1 Mshowa
.19685 .30902 m
.19685 .31527 L
s
[(-1)] .19685 .29652 0 1 Mshowa
.34842 .30902 m
.34842 .31527 L
s
[(-0.5)] .34842 .29652 0 1 Mshowa
.65158 .30902 m
.65158 .31527 L
s
[(0.5)] .65158 .29652 0 1 Mshowa
.80315 .30902 m
.80315 .31527 L
s
[(1)] .80315 .29652 0 1 Mshowa
.95473 .30902 m
.95473 .31527 L
s
[(1.5)] .95473 .29652 0 1 Mshowa
.125 Mabswid
.07559 .30902 m
.07559 .31277 L
s
.1059 .30902 m
.1059 .31277 L
s
.13622 .30902 m
.13622 .31277 L
s
.16653 .30902 m
.16653 .31277 L
s
.22716 .30902 m
.22716 .31277 L
s
.25748 .30902 m
.25748 .31277 L
s
.28779 .30902 m
.28779 .31277 L
s
.31811 .30902 m
.31811 .31277 L
s
.37874 .30902 m
.37874 .31277 L
s
.40905 .30902 m
.40905 .31277 L
s
.43937 .30902 m
.43937 .31277 L
s
.46968 .30902 m
.46968 .31277 L
s
.53032 .30902 m
.53032 .31277 L
s
.56063 .30902 m
.56063 .31277 L
s
.59095 .30902 m
.59095 .31277 L
s
.62126 .30902 m
.62126 .31277 L
s
.68189 .30902 m
.68189 .31277 L
s
.71221 .30902 m
.71221 .31277 L
s
.74252 .30902 m
.74252 .31277 L
s
.77284 .30902 m
.77284 .31277 L
s
.83347 .30902 m
.83347 .31277 L
s
.86378 .30902 m
.86378 .31277 L
s
.8941 .30902 m
.8941 .31277 L
s
.92441 .30902 m
.92441 .31277 L
s
.01496 .30902 m
.01496 .31277 L
s
.98504 .30902 m
.98504 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01471 m
.50625 .01471 L
s
[(-1)] .4875 .01471 1 0 Mshowa
.5 .16187 m
.50625 .16187 L
s
[(-0.5)] .4875 .16187 1 0 Mshowa
.5 .45617 m
.50625 .45617 L
s
[(0.5)] .4875 .45617 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04414 m
.50375 .04414 L
s
.5 .07357 m
.50375 .07357 L
s
.5 .103 m
.50375 .103 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.80315 .30902 m
.80312 .31358 L
.80302 .31773 L
.80283 .32252 L
.80258 .32705 L
.80196 .33509 L
.80103 .34379 L
.79969 .35334 L
.79793 .36341 L
.79387 .3813 L
.78848 .39948 L
.78234 .41617 L
.76461 .45263 L
.7414 .48704 L
.71602 .51549 L
.68237 .54411 L
.64668 .56657 L
.61204 .58248 L
.59186 .58948 L
.57316 .59462 L
.55538 .59837 L
.54528 .60002 L
.53593 .60124 L
.52771 .60209 L
.51865 .60276 L
.51409 .603 L
.50919 .60318 L
.50456 .60329 L
.50034 .60332 L
.49562 .60329 L
.4912 .6032 L
.48635 .60302 L
.48112 .60275 L
.47595 .60239 L
.4705 .60192 L
.46079 .60085 L
.4435 .59816 L
.42479 .59412 L
.40484 .58844 L
.38401 .58093 L
.34815 .56374 L
.31418 .54155 L
.28121 .51273 L
.25436 .48149 L
.23376 .44975 L
.22533 .43356 L
.21744 .41563 L
.21162 .39976 L
.20635 .38212 L
.20371 .37128 L
Mistroke
.20164 .36114 L
.19988 .35057 L
.19864 .34095 L
.19816 .33639 L
.19773 .33144 L
.19742 .32717 L
.19716 .32248 L
.19697 .31748 L
.19691 .31475 L
.19687 .3122 L
.19685 .30763 L
.19692 .30275 L
.19706 .298 L
.19718 .2953 L
.19731 .29277 L
.19765 .28768 L
.19811 .2822 L
.19921 .27233 L
.20052 .26333 L
.20463 .24274 L
.21057 .22146 L
.22432 .18659 L
.23409 .16768 L
.24441 .15076 L
.2695 .11786 L
.29725 .09022 L
.32515 .0686 L
.35808 .04896 L
.39265 .03378 L
.41306 .02708 L
.43254 .02209 L
.44321 .01992 L
.4534 .01821 L
.4627 .01695 L
.47264 .01592 L
.47777 .01551 L
.48344 .01515 L
.48861 .01492 L
.49347 .01478 L
.49625 .01474 L
.49917 .01472 L
.5044 .01474 L
.50731 .0148 L
.51003 .01488 L
.513 .01498 L
.51618 .01513 L
.52109 .01543 L
.52649 .01584 L
.53737 .01696 L
.54741 .01834 L
Mistroke
.55676 .01992 L
.57761 .02452 L
.59959 .03105 L
.63826 .0471 L
.67131 .06621 L
.70229 .08982 L
.728 .11505 L
.75238 .14598 L
.76403 .16441 L
.77349 .18205 L
.78868 .21918 L
.79455 .23941 L
.79697 .24987 L
.79912 .26116 L
.80063 .27116 L
.80171 .28032 L
.80212 .28474 L
.80249 .28955 L
.80276 .2941 L
.80295 .29831 L
.80309 .30318 L
.80315 .30776 L
.80313 .31278 L
.80308 .3156 L
.80301 .31818 L
.80281 .32309 L
.80265 .32587 L
.80249 .32846 L
.80208 .3337 L
.80155 .33924 L
.80029 .34938 L
.7988 .35869 L
.79433 .3795 L
.78922 .3972 L
.78231 .41626 L
.76607 .45006 L
.74702 .47962 L
.72061 .51087 L
.6917 .53701 L
.66295 .55719 L
.62911 .5753 L
.60949 .58345 L
.59054 .58989 L
.57298 .59466 L
.55417 .59858 L
.54426 .60017 L
.53335 .60153 L
.52854 .60201 L
.52339 .60244 L
.51855 .60277 L
Mistroke
.51408 .603 L
.51136 .60311 L
.50846 .6032 L
.50556 .60327 L
.50236 .60331 L
.4996 .60332 L
.49663 .6033 L
.49383 .60326 L
.49127 .6032 L
.48618 .60301 L
.48331 .60287 L
.48063 .60272 L
.47054 .60193 L
.46544 .6014 L
.46005 .60075 L
.45043 .59936 L
.42892 .59512 L
.41063 .59024 L
.39095 .58362 L
.35602 .56801 L
.32547 .54966 L
.29308 .5241 L
.26599 .49611 L
.24505 .46825 L
.22626 .43547 L
.21225 .40164 L
.20624 .38171 L
.20193 .36267 L
.20023 .35283 L
.19881 .34242 L
.1979 .3335 L
.19751 .32844 L
.19723 .32372 L
.1971 .32107 L
.197 .31821 L
.19692 .3155 L
.19688 .313 L
.19685 .30827 L
.19691 .30326 L
.19697 .30067 L
.19706 .29789 L
.1973 .29286 L
.19771 .28689 L
.19818 .28144 L
.19929 .27177 L
.20057 .26304 L
.20442 .24364 L
.20918 .22593 L
.21468 .20956 L
.23058 .1741 L
Mistroke
.25297 .13842 L
.27695 .10971 L
.30726 .08185 L
.34281 .05737 L
.3789 .03922 L
.39755 .03203 L
.41833 .02559 L
.43834 .02086 L
.448 .01908 L
.4571 .01768 L
.46597 .01657 L
.47412 .01579 L
.47845 .01546 L
.48319 .01517 L
.48796 .01495 L
.49298 .01479 L
.498 .01472 L
.50257 .01472 L
.50783 .01481 L
.51279 .01498 L
.51739 .0152 L
.52162 .01546 L
.53116 .01627 L
.54089 .0174 L
.54973 .0187 L
.56945 .02254 L
.58745 .02722 L
.60421 .03265 L
.64036 .04816 L
.67698 .07007 L
.70601 .09311 L
.7344 .12238 L
.75938 .15667 L
.77804 .19174 L
.78909 .22041 L
.79346 .23521 L
.79734 .25165 L
.79988 .26588 L
.80099 .2739 L
.8018 .28122 L
.80238 .28806 L
.80263 .29167 L
.80283 .29549 L
.80297 .29884 L
.80308 .30252 L
.80314 .30588 L
.80315 .30902 L
Mfstroke
0 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[37]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00OSgoo00<007ooOol0
SWoo002?Ool00`00Oomoo`2>Ool008Ioo`D000Aoo`03001oogoo08ioo`00R7oo00<007ooOol017oo
00<007ooOol0SWoo0026OolCO027Ool007moo`Ql0003Ool007oo00Eoo`03001oogoo00Eoo`Ul081o
o`00Ngoo1W`01goo00<007ooOol017oo00<007ooOol037oo1g`0Ngoo001gOol4O00<Ool20006Ool0
0`00Oomoo`0@Ool5O01iOol007Aoo`Al01Moo`03001oogoo01Eoo`Al07Eoo`00LGoo17`06Woo00<0
07ooOol067oo17`0LWoo001^Ool4O00MOol00`00Oomoo`0KOol3O01`Ool006aoo`=l021oo`03001o
ogoo01ioo`9l06ioo`00JWoo0g`08Woo0P008Goo0g`0Jgoo001XOol3O00TOol00`00Oomoo`0ROol3
O01YOol006Ioo`=l02Ioo`03001oogoo02Aoo`=l06Moo`00I7oo0g`0:7oo00<007ooOol09Woo0g`0
IGoo001ROol3O00ZOol00`00Oomoo`0XOol2O01TOol0061oo`=l02aoo`03001oogoo02Yoo`9l069o
o`00Ggoo0W`0;Woo00<007ooOol0:goo0g`0H7oo001MOol2O00`Ool00`00Oomoo`0]Ool2O01OOol0
05aoo`9l035oo`03001oogoo02moo`9l05eoo`00Fgoo00=l07ooOol0<Goo0P00<Goo0W`0G7oo001I
Ool2O00dOol00`00Oomoo`0bOol2O01JOol005Qoo`9l03Eoo`03001oogoo03=oo`9l05Uoo`00Egoo
00=l07ooOol0=Goo00<007ooOol0=Goo0W`0Egoo001FOol00g`0Oomoo`0fOol00`00Oomoo`0fOol2
O01FOol005Eoo`03O01oogoo03Moo`03001oogoo03Qoo`03O01oogoo05=oo`00Dgoo0W`0>Woo00<0
07ooOol0>Goo00=l07ooOol0DWoo001BOol2O00kOol00`00Oomoo`0jOol00g`0Oomoo`1AOol0055o
o`9l03aoo`8003aoo`03O01oogoo051oo`00D7oo0W`0?Goo00<007ooOol0>goo0W`0DGoo001?Ool0
0g`0Oomoo`0mOol00`00Oomoo`0lOol00g`0Oomoo`1?Ool004ioo`03O01oogoo03ioo`03001oogoo
03eoo`03O01oogoo04ioo`00CGoo00=l07ooOol0?goo00<007ooOol0?Woo00=l07ooOol0CGoo001<
Ool2O011Ool00`00Oomoo`0oOol00g`0Oomoo`1<Ool004aoo`03O01oogoo041oo`03001oogoo041o
o`03O01oogoo04]oo`00Bgoo00=l07ooOol0@Goo00<007ooOol0@7oo0W`0C7oo001:Ool00g`0Oomo
o`12Ool00`00Oomoo`11Ool00g`0Oomoo`1:Ool004Uoo`9l04Aoo`8004=oo`03O01oogoo04Uoo`00
BGoo00=l07ooOol0@goo00<007ooOol0@goo00=l07ooOol0B7oo0018Ool00g`0Oomoo`14Ool00`00
Oomoo`13Ool2O019Ool004Moo`9l04Ioo`03001oogoo04Aoo`03O01oogoo04Moo`00Agoo00=l07oo
Ool0AGoo00<007ooOol0AGoo00=l07ooOol0AWoo0016Ool00g`0Oomoo`16Ool00`00Oomoo`16Ool0
0g`0Oomoo`15Ool004Eoo`9l03Aoo`8000Aoo`8000Aoo`8000Ioo`03001oogoo04Ioo`03O01oogoo
04Eoo`00AGoo00=l07ooOol0<Woo00@007ooOol000Qoo`04001oogoo0005Ool00`00Oomoo`17Ool0
0g`0Oomoo`14Ool004Aoo`9l03Aoo`04001oogoo000;Ool00`00Oomoo`03Ool30017Ool2O015Ool0
04Aoo`03O01oogoo02eoo`@0009oo`04001oogoo0009Ool20006Ool00`00Oomoo`18Ool00g`0Oomo
o`13Ool004=oo`03O01oogoo03Aoo`04001oogoo0009Ool00`00Oomoo`05Ool00`00Oomoo`19Ool0
0g`0Oomoo`12Ool0049oo`9l03Moo`8000Yoo`<000Eoo`03001oogoo04Uoo`03O01oogoo049oo`00
@Woo00=l07ooOol0BWoo00<007ooOol0BWoo00=l07ooOol0@Goo0011Ool2O01<Ool00`00Oomoo`1:
Ool00g`0Oomoo`11Ool0045oo`03O01oogoo04]oo`03001oogoo04]oo`03O01oogoo041oo`00@7oo
0W`0CGoo00<007ooOol0Bgoo00=l07ooOol0@7oo0010Ool00g`0Oomoo`1<Ool2001=Ool00g`0Oomo
o`0oOol003moo`9l04ioo`03001oogoo04aoo`03O01oogoo03moo`00?goo0W`0CWoo00<007ooOol0
C7oo0W`0@7oo000nOol2O01?Ool00`00Oomoo`1=Ool00g`0Oomoo`0nOol003ioo`9l04moo`03001o
ogoo04eoo`03O01oogoo03ioo`00?Woo00=l07ooOol0CWoo00<007ooOol0CWoo00=l07ooOol0?Goo
000mOol2O01@Ool00`00Oomoo`1>Ool00g`0Oomoo`0mOol003eoo`03O01oogoo04moo`03001oogoo
04ioo`9l03ioo`00?7oo0W`0DGoo00<007ooOol0Cgoo00=l07ooOol0?7oo000lOol00g`0Oomoo`1@
Ool2001@Ool00g`0Oomoo`0lOol003aoo`03O01oogoo051oo`03001oogoo051oo`03O01oogoo03]o
o`00?7oo00=l07ooOol0D7oo00<007ooOol0D7oo00=l07ooOol0>goo000kOol2O01BOol00`00Oomo
o`1@Ool2O00lOol003]oo`03O01oogoo055oo`03001oogoo055oo`03O01oogoo03Yoo`00>goo00=l
07ooOol0DGoo00<007ooOol0DGoo00=l07ooOol0>Woo000kOol00g`0Oomoo`1AOol00`00Oomoo`1A
Ool00g`0Oomoo`0jOol003]oo`03O01oogoo055oo`03001oogoo059oo`03O01oogoo03Uoo`00>goo
00=l07ooOol0DGoo0P00Dgoo00=l07ooOol0>Goo000jOol00g`0Oomoo`1BOol00`00Oomoo`1BOol0
0g`0Oomoo`0iOol003Yoo`03O01oogoo059oo`03001oogoo059oo`03O01oogoo03Uoo`00>Woo00=l
07ooOol0DWoo00<007ooOol0DWoo0W`0>Woo000jOol00g`0Oomoo`1BOol00`00Oomoo`1BOol2O00j
Ool000Qoo`D0009oo`8000Aoo`80029oo`9l00@0025oo`8000Aoo`8000Aoo`80025oo`03001oogoo
025oo`8000Aoo`8000Aoo`80029oo`800003O0000000025oo`D0009oo`8000Aoo`8000Qoo`002Woo
00<007ooOol01goo00@007ooOol0025oo`04O01oogoo000ROol01000Oomoo`0027oo00@007ooOol0
021oo`03001oogoo021oo`04001oogoo0008Ool01000Oomoo`008goo00=l07ooOol08goo00<007oo
Ool01goo00@007ooOol000Moo`002Woo00<007ooOol02Woo00<007ooOol07goo00Al07ooOol0029o
o`04001oogoo000;Ool00`00Oomoo`0NOol00`00Oomoo`0POol01000Oomoo`002goo00<007ooOol0
8Goo00=l07ooOol08goo00<007ooOol02Woo00<007ooOol01Goo0002Ool40004Ool00`00Oomoo`08
Ool2000MOol400001GooO01oogoo000077oo10000Woo00@007ooOol000Uoo`80025oo`03001oogoo
021oo`04001oogoo0009Ool2000TOol00g`0Oomoo`0SOol00`00Oomoo`08Ool20008Ool000Yoo`03
001oogoo00Qoo`03001oogoo025oo`04O01oogoo000ROol01000Oomoo`002Goo00<007ooOol087oo
0P008Goo00@007ooOol000Uoo`03001oogoo02=oo`03O01oogoo02=oo`03001oogoo00Qoo`03001o
ogoo00Moo`002Goo0P002Woo0`008Goo00Al07oo000002=oo`8000Yoo`<0021oo`03001oogoo025o
o`8000Yoo`<0029oo`03001l07oo02=oo`8000Yoo`<000Moo`00>Goo00=l07ooOol0Dgoo00<007oo
Ool0Dgoo00=l07ooOol0>7oo000iOol00g`0Oomoo`1COol00`00Oomoo`1COol00g`0Oomoo`0hOol0
03Uoo`03O01oogoo05=oo`03001oogoo05=oo`03O01oogoo03Qoo`00>Goo00=l07ooOol0Dgoo00<0
07ooOol0Dgoo00=l07ooOol0>7oo000iOol00g`0Oomoo`1COol00`00Oomoo`1COol00g`0Oomoo`0h
Ool003Uoo`03O01oogoo05=oo`03001oogoo05=oo`03O01oogoo03Qoo`001`00o`?P4P?P1`000Goo
0005Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomo
o`06Ool00`00Oomoo`06Ool00g`0Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomo
o`06Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomo
o`05Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomo
o`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomo
o`06Ool00`00Oomoo`05Ool00g`0Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomo
o`06Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`04Ool000eoo`03001oogoo02Uoo`03
O01oogoo02Qoo`03001oogoo02Qoo`03001oogoo02Qoo`03001oogoo02Qoo`03O01oogoo02Uoo`03
001oogoo00aoo`00>Goo00=l07ooOol0Dgoo00<007ooOol0Dgoo00=l07ooOol0>7oo000iOol00g`0
Oomoo`1COol00`00Oomoo`1COol00g`0Oomoo`0hOol003Uoo`03O01oogoo05=oo`03001oogoo05=o
o`03O01oogoo03Qoo`00>Goo00=l07ooOol0Dgoo00<007ooOol0Dgoo00=l07ooOol0>7oo000iOol0
0g`0Oomoo`1COol00`00Oomoo`1COol00g`0Oomoo`0hOol003Uoo`03O01oogoo05=oo`8005Aoo`03
O01oogoo03Qoo`00>Goo00=l07ooOol0Dgoo00<007ooOol0Dgoo00=l07ooOol0>7oo000iOol00g`0
Oomoo`1COol00`00Oomoo`1COol00g`0Oomoo`0hOol003Uoo`03O01oogoo05=oo`03001oogoo05=o
o`03O01oogoo03Qoo`00>Goo00=l07ooOol0Dgoo00<007ooOol0Dgoo00=l07ooOol0>7oo000iOol0
0g`0Oomoo`1COol00`00Oomoo`1BOol2O00jOol003Yoo`03O01oogoo059oo`03001oogoo059oo`9l
03Yoo`00>Woo00=l07ooOol0DWoo00<007ooOol0DWoo00=l07ooOol0>Goo000jOol00g`0Oomoo`1B
Ool00`00Oomoo`1BOol00g`0Oomoo`0iOol003Yoo`03O01oogoo059oo`80059oo`9l03]oo`00>Woo
0W`0Dgoo00<007ooOol0DGoo0W`0>goo000jOol2O01COol00`00Oomoo`1AOol00g`0Oomoo`0jOol0
03]oo`03O01oogoo055oo`03001oogoo055oo`03O01oogoo03Yoo`00>goo00=l07ooOol0DGoo00<0
07ooOol0DGoo00=l07ooOol0>Woo000kOol00g`0Oomoo`1AOol00`00Oomoo`1AOol00g`0Oomoo`0j
Ool003aoo`03O01oogoo051oo`03001oogoo051oo`03O01oogoo03]oo`00?7oo00=l07ooOol0D7oo
00<007ooOol0D7oo00=l07ooOol0>goo000mOol00g`0Oomoo`1?Ool2001@Ool2O00mOol003eoo`03
O01oogoo04moo`03001oogoo04moo`9l03eoo`00?Goo00=l07ooOol0Cgoo00<007ooOol0Cgoo00=l
07ooOol0?7oo000nOol00g`0Oomoo`1>Ool00`00Oomoo`1?Ool00g`0Oomoo`0lOol003ioo`03O01o
ogoo04ioo`03001oogoo04ioo`9l03ioo`00?Woo0W`0Cgoo00<007ooOol0CWoo00=l07ooOol0?Goo
000oOol00g`0Oomoo`1=Ool00`00Oomoo`1>Ool00g`0Oomoo`0mOol003moo`03O01oogoo04eoo`03
001oogoo04eoo`03O01oogoo03ioo`00@7oo00=l07ooOol0C7oo00<007ooOol0CGoo00=l07ooOol0
?Woo0010Ool00g`0Oomoo`1<Ool2001=Ool00g`0Oomoo`0oOol0045oo`03O01oogoo04]oo`03001o
ogoo04aoo`03O01oogoo03moo`00@Goo00=l07ooOol0Bgoo00<007ooOol0Bgoo00=l07ooOol0@7oo
0012Ool00g`0Oomoo`1:Ool00`00Oomoo`1:Ool2O012Ool0049oo`03O01oogoo04Yoo`03001oogoo
04Yoo`03O01oogoo045oo`00@goo00=l07ooOol0BGoo00<007ooOol0BGoo0W`0@goo0013Ool00g`0
Oomoo`0eOol20004Ool20004Ool20006Ool00`00Oomoo`19Ool00g`0Oomoo`12Ool004Aoo`03O01o
ogoo03=oo`04001oogoo0008Ool01000Oomoo`001Goo00<007ooOol0B7oo00=l07ooOol0@goo0014
Ool00g`0Oomoo`0cOol01000Oomoo`002goo00<007ooOol00goo0`00Agoo0W`0AGoo0015Ool00g`0
Oomoo`0bOol01000Oomoo`002Goo0P001Woo00<007ooOol0Agoo00=l07ooOol0A7oo0015Ool2O00c
Ool01000Oomoo`002Goo00<007ooOol01Goo00<007ooOol0AWoo00=l07ooOol0AGoo0016Ool00g`0
Oomoo`0bOol2000:Ool30005Ool00`00Oomoo`16Ool00g`0Oomoo`15Ool004Moo`03O01oogoo04Eo
o`03001oogoo04Eoo`03O01oogoo04Ioo`00B7oo00=l07ooOol0A7oo00<007ooOol0A7oo00=l07oo
Ool0Agoo0018Ool00g`0Oomoo`14Ool00`00Oomoo`14Ool00g`0Oomoo`17Ool004Uoo`03O01oogoo
04=oo`03001oogoo04=oo`03O01oogoo04Qoo`00BWoo00=l07ooOol0@Woo0P00@goo0W`0BWoo001;
Ool00g`0Oomoo`11Ool00`00Oomoo`11Ool2O01;Ool004]oo`9l049oo`03001oogoo045oo`03O01o
ogoo04Yoo`00C7oo0W`0@Goo00<007ooOol0@7oo00=l07ooOol0Bgoo001=Ool00g`0Oomoo`0oOol0
0`00Oomoo`0oOol00g`0Oomoo`1<Ool004ioo`03O01oogoo03ioo`03001oogoo03ioo`03O01oogoo
04eoo`00Cgoo00=l07ooOol0?Goo00<007ooOol0?Woo00=l07ooOol0CGoo001@Ool00g`0Oomoo`0l
Ool00`00Oomoo`0mOol00g`0Oomoo`1>Ool0055oo`03O01oogoo03]oo`03001oogoo03aoo`03O01o
ogoo04moo`00DWoo00=l07ooOol0>Woo0P00?7oo00=l07ooOol0D7oo001COol00g`0Oomoo`0iOol0
0`00Oomoo`0jOol00g`0Oomoo`1AOol005Aoo`03O01oogoo03Qoo`03001oogoo03Qoo`9l05Aoo`00
EGoo0W`0>7oo00<007ooOol0=goo0W`0EGoo001FOol2O00gOol00`00Oomoo`0fOol00g`0Oomoo`1E
Ool005Moo`9l03Ioo`03001oogoo03Eoo`03O01oogoo05Ioo`00F7oo0W`0=Goo00<007ooOol0<goo
0W`0FGoo001JOol00g`0Oomoo`0bOol00`00Oomoo`0bOol2O01JOol005]oo`9l039oo`80039oo`03
O01oogoo05Yoo`00G7oo0W`0<Goo00<007ooOol0;goo0W`0GGoo001MOol2O00`Ool00`00Oomoo`0^
Ool00g`0Oomoo`1MOol005ioo`=l02ioo`03001oogoo02aoo`9l061oo`00H7oo0W`0;Goo00<007oo
Ool0:goo0W`0HGoo001ROol2O00[Ool00`00Oomoo`0YOol2O01SOol006Aoo`9l02Uoo`03001oogoo
02Moo`=l06Aoo`00IGoo0g`09goo00<007ooOol09Goo0g`0IWoo001WOol3O00UOol00`00Oomoo`0S
Ool3O01XOol006Uoo`Al029oo`80029oo`=l06Yoo`00Jgoo17`087oo00<007ooOol07Woo0g`0KGoo
001]Ool5O00MOol00`00Oomoo`0KOol4O01_Ool0071oo`El01Yoo`03001oogoo01Uoo`=l079oo`00
Lgoo1G`05goo00<007ooOol05Woo0g`0MGoo001gOol5O00COol00`00Oomoo`0DOol2O01hOol007Yo
o`Al00Qoo`D000Aoo`03001oogoo011oo`Al07Yoo`00OWoo27`00Woo00<007ooOol017oo00<007oo
Ool01goo2G`0OWoo0026OolCO027Ool008Qoo`03001oogoo00Aoo`03001oogoo08ioo`00R7oo00<0
07ooOol017oo00<007ooOol0SWoo0027Ool20006Ool00`00Oomoo`2>Ool008moo`03001oogoo08io
o`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.65911, -1.05362, \
0.0115618, 0.0119094}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[37]="]
}, Open  ]],

Cell["\<\
We can easily compute a local parametric approximation around a regular \
point, say {0,1}:\
\>", "Text",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{

Cell[BoxData[
    \(var1\)], "Input",
  CellLabel->"In[38]:=",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \({x, y}\)], "Output",
  CellLabel->"Out[38]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Man = ParametricManifold[f1, var1, {0, 1}, 4]\)], "Input",
  CellLabel->"In[39]:=",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \("1 vector fields computed."\)], "Print",
  CellLabel->"From In[39]:="],

Cell[BoxData[
    \("1 flow functions computed."\)], "Print",
  CellLabel->"From In[39]:="],

Cell[BoxData[
    \({{\(-2\)\ k1 + \(8\ k1\^3\)\/3, 
        1 - 2\ k1\^2 + \(10\ k1\^4\)\/3}, {k1}}\)], "Output",
  CellLabel->"Out[39]="]
}, Open  ]],

Cell["But computation at a singular point is meaningless.", "Text",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Man = ParametricManifold[f1, var1, {1, 0}, 4]\)], "Input",
  CellLabel->"In[40]:=",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \("Equations may be redundant"\)], "Print",
  CellLabel->"From In[40]:="],

Cell[BoxData[
    \("1 vector fields computed."\)], "Print",
  CellLabel->"From In[40]:="],

Cell[BoxData[
    \("Warning! Manifold may not be regular at nominal point."\)], "Print",
  CellLabel->"From In[40]:="],

Cell[BoxData[
    \("1 flow functions computed."\)], "Print",
  CellLabel->"From In[40]:="],

Cell[BoxData[
    \("Manifold may not be regular at nominal point."\)], "Print",
  CellLabel->"From In[40]:="],

Cell[BoxData[
    \({{1, 0}, {k1}}\)], "Output",
  CellLabel->"Out[40]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2: redundent defining relations", "Subsection",
  CellTags->"Pitfalls"],

Cell["\<\
If the imbedding relations are not independent, the results may still be \
useful:\
\>", "Text",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \(\(f2 = {x + y, \((x + y)\)^2};\)\)], "Input",
  CellLabel->"In[41]:=",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricManifold[f2, {x, y}, {0, 0}, 3]\)], "Input",
  CellLabel->"In[42]:=",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \("Equations may be redundant"\)], "Print",
  CellLabel->"From In[42]:="],

Cell[BoxData[
    \("1 vector fields computed."\)], "Print",
  CellLabel->"From In[42]:="],

Cell[BoxData[
    \("1 flow functions computed."\)], "Print",
  CellLabel->"From In[42]:="],

Cell[BoxData[
    \({{\(-k1\), k1}, {k1}}\)], "Output",
  CellLabel->"Out[42]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f3 = {x + y + p, \((x + y + p)\)^2}\)], "Input",
  CellLabel->"In[43]:=",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \({p + x + y, \((p + x + y)\)\^2}\)], "Output",
  CellLabel->"Out[43]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(EquilibriumSurface[f2, {x, y}, {p}, {0, 0}, {0}, s, 3]\)], "Input",
  CellLabel->"In[44]:=",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \("Equations may be redundant"\)], "Print",
  CellLabel->"From In[44]:="],

Cell[BoxData[
    \("2 vector fields computed."\)], "Print",
  CellLabel->"From In[44]:="],

Cell[BoxData[
    \("2 flow functions computed."\)], "Print",
  CellLabel->"From In[44]:="],

Cell[BoxData[
    \({{\(-s1\), s1, s2}, {s1, s2}}\)], "Output",
  CellLabel->"Out[44]="]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["A More Complex Example", "Section"],

Cell[CellGroupData[{

Cell["Longitudinal Dynamics of an Aircraft", "Subsection",
  CellTags->"Aircraft Example"],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< ProPac`\)], "Input",
  CellLabel->"In[45]:=",
  CellTags->"Aircraft Example"],

Cell[BoxData[
    \("\n    This is ProPac - Version 2.0\n \n ProPac has been successfully \
loaded. It contains packages\n for multibody dynamics, linear control and \
nonlinear control.\n Appropriate packages will be loaded automatically as \
required.\n Packages can be manually loaded by simply entering \
GeometricTools,\n Dynamics, LinearControl, NonlinearControl or MEXTools as \
desired.\n Once a package is loaded, enter ?GeomtricTools, ?Dynamics,\n \
?LinearControl, ?NonlinearControl, or ?MEXTools, respectively,\n to obtain a \
list of available functions. Help is also available\n in the Help Browser \
under Add-ons."\)], "Print",
  CellLabel->"From In[45]:="]
}, Open  ]],

Cell[BoxData[
    \(\(Feq = {\(-\(1\/2\)\)\ \((20. \ \((\(-2.045\)\ \((\(-0.05\) + alpha)\)\
\^3 + alpha)\)\ kappa\ Cos[alpha] - 
                2. \ \((\(-0.05\) + alpha + dele - 
                      3\ \((\(-0.05\) + alpha + dele)\)\^3)\)\ \((1 - 
                      kappa)\)\ Cos[alpha + dele])\), \(-\ Cos[alpha]\) - 
            1\/2\ V\^2\ \((\(-20. \)\ \((\(-2.045\)\ \((\(-0.05\) + \
alpha)\)\^3 + alpha)\)\ Cos[alpha] - 
                  2. \ \((\(-0.05\) + alpha + dele - 
                        3\ \((\(-0.05\) + alpha + dele)\)\^3)\)\ Cos[
                      alpha + dele] - 
                  0.05\ \((1 + 
                        400. \ \((\(-2.045\)\ \((\(-0.05\) + alpha)\)\^3 + \
alpha)\)\^2)\)\ Sin[alpha])\)};\)\)], "Input",
  CellLabel->"In[46]:=",
  CellTags->"Aircraft Example"],

Cell[CellGroupData[{

Cell[BoxData[
    \({TT, ParamMap} = 
      Timing[EquilibriumSurface[
          Feq, {alpha, dele}, {V, kappa}, { .2,  .1}, {0.67276, 0.093009}, 
          kap, 3]]\)], "Input",
  CellLabel->"In[47]:=",
  CellTags->"Aircraft Example"],

Cell[BoxData[
    \("2 vector fields computed."\)], "Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    \("2 flow functions computed."\)], "Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    \({35.37`\ Second, {{\(\(0.2`\)\(\[InvisibleSpace]\)\) - 
            0.6201420349240288`\ kap1 + 1.3053393373609063`\ kap1\^2 - 
            0.33215721468570836`\ kap1\^3 - 0.2216001210379043`\ kap2 - 
            0.08023127831489063`\ kap1\ kap2 - 
            12.632679862512642`\ kap1\^2\ kap2 - 
            0.19534873099879752`\ kap2\^2 + 
            33.217246320746476`\ kap1\ kap2\^2 + 
            13.467687872067946`\ kap2\^3, \(\(0.1`\)\(\[InvisibleSpace]\)\) - 
            0.8126152468379911`\ kap1 + 0.08392440316290846`\ kap1\^2 + 
            0.29408021324234235`\ kap1\^3 + 6.136848475579748`\ kap2 - 
            1.2675896683413208`\ kap1\ kap2 - 
            6.66265756896722`\ kap1\^2\ kap2 + 4.7864015314076145`\ kap2\^2 + 
            50.31621065999766`\ kap1\ kap2\^2 - 
            126.66222294305427`\ kap2\^3, \(\(0.67276`\)\(\[InvisibleSpace]\)\
\) + 1.`\ kap1 + 1.2413890431354448`\ kap1\^2 - 
            2.9132952220449564`\ kap1\^3 - 5.824300031038084`\ kap1\ kap2 + 
            14.382562731811149`\ kap1\^2\ kap2 + 
            12.997649186807685`\ kap2\^2 - 
            64.22889061442916`\ kap1\ kap2\^2 + 
            82.97567765190796`\ kap2\^3, \(\(0.093009`\)\(\[InvisibleSpace]\)\
\) - 2.1728797200382237`\ kap1\^2 + 0.47065905783490686`\ kap1\^3 + 
            1.`\ kap2 + 20.109876581559192`\ kap1\ kap2 - 
            5.241098334207281`\ kap1\^2\ kap2 - 
            35.483816855761596`\ kap2\^2 + 
            73.89848048208985`\ kap1\ kap2\^2 - 
            248.74397643700698`\ kap2\^3}, {kap1, kap2}}}\)], "Output",
  CellLabel->"Out[47]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot3D[\(ParamMap[\([1]\)]\)[\([{3, 4, 
            2}]\)], {kap1, \(- .05\),  .1}, {kap2, \(- .05\),  .08}, \n\ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ PlotPoints -> {25, 
          25}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ BoxRatios -> {1, 
          1,  .5}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ViewPoint -> {2, \(- \
.2\), 1.5}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ Boxed -> True]\)], "Input",
  CellLabel->"In[48]:=",
  CellTags->"Aircraft Example"],

Cell[BoxData[
    \(ParametricPlot3D::"ppcom" \(\(:\)\(\ \)\) 
      "Function \!\(\(\(ParamMap \[LeftDoubleBracket] 1 \[RightDoubleBracket]\
\)\) \[LeftDoubleBracket] \(\({3, 4, 2}\)\) \[RightDoubleBracket]\) cannot be \
compiled; plotting will proceed with the uncompiled function."\)], "Message",
  CellLabel->"From In[48]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .84128 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0798165 1.07982 -0.0707824 1.07982 [
[.81292 .79584 0 -4.28754 ]
[.81292 .79584 24 4.71246 ]
[.8558 .71193 0 -4.27158 ]
[.8558 .71193 18 4.72842 ]
[.90547 .61475 0 -4.25301 ]
[.90547 .61475 24 4.74699 ]
[.96366 .5009 0 -4.23117 ]
[.96366 .5009 18 4.76883 ]
[.06632 -0.01305 -12.9064 -9 ]
[.06632 -0.01305 11.0936 0 ]
[.26874 .00252 -11.6608 -9 ]
[.26874 .00252 12.3392 0 ]
[.46795 .01799 -10.4152 -9 ]
[.46795 .01799 13.5848 0 ]
[.66398 .03334 -2.29239 -9 ]
[.66398 .03334 3.70761 0 ]
[.85686 .04857 -5.94293 -9 ]
[.85686 .04857 12.0571 0 ]
[.04494 .01865 -24 -4.84566 ]
[.04494 .01865 0 4.15434 ]
[.03187 .09007 -6 -4.83265 ]
[.03187 .09007 0 4.16735 ]
[.01792 .16629 -18 -4.81878 ]
[.01792 .16629 0 4.18122 ]
[.003 .24781 -18 -4.80395 ]
[.003 .24781 0 4.19605 ]
[-0.013 .33522 -18 -4.78808 ]
[-0.013 .33522 0 4.21192 ]
[ 0 0 0 0 ]
[ 1 .84128 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.77589 .84128 m
1 .40259 L
s
.79943 .7952 m
.79269 .79488 L
s
[(0.65)] .81292 .79584 -1 -0.04721 Mshowa
.84232 .71125 m
.83558 .7109 L
s
[(0.7)] .8558 .71193 -1 -0.05076 Mshowa
.89199 .61401 m
.88525 .61364 L
s
[(0.75)] .90547 .61475 -1 -0.05489 Mshowa
.95019 .50009 m
.94345 .49969 L
s
[(0.8)] .96366 .5009 -1 -0.05974 Mshowa
.125 Mabswid
.80754 .77934 m
.80349 .77915 L
s
.81587 .76303 m
.81182 .76284 L
s
.82443 .74626 m
.82039 .74606 L
s
.83325 .72901 m
.8292 .7288 L
s
.85167 .69296 m
.84762 .69275 L
s
.86129 .67411 m
.85725 .6739 L
s
.87121 .65469 m
.86717 .65448 L
s
.88144 .63467 m
.8774 .63445 L
s
.90288 .59269 m
.89884 .59247 L
s
.91413 .57068 m
.91009 .57045 L
s
.92575 .54793 m
.92171 .5477 L
s
.93776 .52442 m
.93372 .52418 L
s
.79155 .81064 m
.7875 .81045 L
s
.78387 .82566 m
.77983 .82548 L
s
.7764 .84029 m
.77235 .84011 L
s
.96305 .47492 m
.95901 .47468 L
s
.97636 .44885 m
.97232 .4486 L
s
.99016 .42184 m
.98612 .42159 L
s
.25 Mabswid
.06201 0 m
.92976 .06735 L
s
.06733 .00041 m
.06784 .00714 L
s
[(-0.3)] .06632 -0.01305 .07554 1 Mshowa
.26836 .01602 m
.26817 .02276 L
s
[(-0.2)] .26874 .00252 -0.02827 1 Mshowa
.46619 .03137 m
.4653 .03806 L
s
[(-0.1)] .46795 .01799 -0.13207 1 Mshowa
.66088 .04648 m
.65933 .05305 L
s
[(0)] .66398 .03334 -0.23587 1 Mshowa
.85252 .06135 m
.85035 .06774 L
s
[(0.1)] .85686 .04857 -0.33967 1 Mshowa
.125 Mabswid
.1078 .00355 m
.10802 .0076 L
s
.14813 .00668 m
.14827 .01073 L
s
.18834 .0098 m
.18839 .01385 L
s
.22842 .01292 m
.22839 .01696 L
s
.30818 .01911 m
.30798 .02315 L
s
.34787 .02219 m
.34759 .02623 L
s
.38744 .02526 m
.38707 .02929 L
s
.42687 .02832 m
.42643 .03234 L
s
.50537 .03441 m
.50476 .03841 L
s
.54444 .03744 m
.54374 .04143 L
s
.58337 .04046 m
.5826 .04444 L
s
.62219 .04348 m
.62134 .04744 L
s
.69945 .04947 m
.69844 .0534 L
s
.7379 .05246 m
.73682 .05636 L
s
.77622 .05543 m
.77507 .05931 L
s
.81443 .0584 m
.8132 .06226 L
s
.89048 .0643 m
.88911 .06811 L
s
.92833 .06724 m
.92689 .07102 L
s
.25 Mabswid
.06201 0 m
0 .33867 L
s
.0584 .01969 m
.06513 .0202 L
s
[(-0.2)] .04494 .01865 1 .07681 Mshowa
.04533 .09107 m
.05206 .09156 L
s
[(0)] .03187 .09007 1 .07392 Mshowa
.03139 .16724 m
.03812 .16772 L
s
[(0.2)] .01792 .16629 1 .07084 Mshowa
.01647 .24872 m
.0232 .24918 L
s
[(0.4)] .003 .24781 1 .06755 Mshowa
.00047 .33608 m
.00721 .33651 L
s
[(0.6)] -0.013 .33522 1 .06402 Mshowa
.125 Mabswid
.05521 .03711 m
.05925 .03741 L
s
.05197 .05481 m
.05601 .05511 L
s
.04868 .07279 m
.05272 .07309 L
s
.04193 .10964 m
.04597 .10994 L
s
.03848 .12853 m
.04251 .12882 L
s
.03496 .14772 m
.039 .14801 L
s
.02775 .1871 m
.03179 .18738 L
s
.02405 .20729 m
.02809 .20757 L
s
.02029 .22783 m
.02433 .2281 L
s
.01258 .26999 m
.01662 .27026 L
s
.00861 .29163 m
.01265 .29189 L
s
.00458 .31366 m
.00862 .31392 L
s
.06154 .00254 m
.06558 .00285 L
s
.25 Mabswid
.10218 .51324 m
.06279 .809 L
s
.06279 .809 m
.77589 .84128 L
s
.77589 .84128 m
.74539 .55002 L
s
.74539 .55002 m
.10218 .51324 L
s
.06201 0 m
.92976 .06735 L
s
.92976 .06735 m
1 .40259 L
s
1 .40259 m
0 .33867 L
s
0 .33867 m
.06201 0 L
s
.10218 .51324 m
.06279 .809 L
s
.06279 .809 m
0 .33867 L
s
0 .33867 m
.06201 0 L
s
.06201 0 m
.10218 .51324 L
s
.74539 .55002 m
.92976 .06735 L
s
.92976 .06735 m
1 .40259 L
s
1 .40259 m
.77589 .84128 L
s
.77589 .84128 m
.74539 .55002 L
s
0 0 m
1 0 L
1 .84128 L
0 .84128 L
closepath
clip
newpath
.5 Mabswid
.64342 .58843 m .64309 .60072 L .63013 .5861 L p .33 .477 .855 r
F P
0 g
s
.63013 .5861 m .62961 .57351 L .64342 .58843 L p .33 .477 .855 r
F P
0 g
s
.62961 .57351 m .63013 .5861 L .6162 .57092 L p .339 .497 .869 r
F P
0 g
s
.65598 .60266 m .6548 .61463 L .64309 .60072 L p .313 .447 .836 r
F P
0 g
s
.64309 .60072 m .64342 .58843 L .65598 .60266 L p .313 .447 .836 r
F P
0 g
s
.6162 .57092 m .61485 .55807 L .62961 .57351 L p .339 .497 .869 r
F P
0 g
s
.61485 .55807 m .6162 .57092 L .60159 .55535 L p .343 .51 .879 r
F P
0 g
s
.66703 .61604 m .66496 .62767 L .6548 .61463 L p .286 .405 .808 r
F P
0 g
s
.6548 .61463 m .65598 .60266 L .66703 .61604 L p .286 .405 .808 r
F P
0 g
s
.60159 .55535 m .59942 .54227 L .61485 .55807 L p .343 .51 .879 r
F P
0 g
s
.59942 .54227 m .60159 .55535 L .58657 .53955 L p .34 .519 .886 r
F P
0 g
s
.67626 .62843 m .67331 .63968 L .66496 .62767 L p .243 .342 .766 r
F P
0 g
s
.66496 .62767 m .66703 .61604 L .67626 .62843 L p .243 .342 .766 r
F P
0 g
s
.58657 .53955 m .58361 .52627 L .59942 .54227 L p .34 .519 .886 r
F P
0 g
s
.68339 .63966 m .67952 .65052 L .67331 .63968 L p .174 .244 .696 r
F P
0 g
s
.67331 .63968 m .67626 .62843 L .68339 .63966 L p .174 .244 .696 r
F P
0 g
s
.657 .59033 m .65598 .60266 L .64342 .58843 L p .328 .465 .846 r
F P
0 g
s
.64342 .58843 m .64355 .57578 L .657 .59033 L p .328 .465 .846 r
F P
0 g
s
.64355 .57578 m .64342 .58843 L .62961 .57351 L p .343 .491 .863 r
F P
0 g
s
.62961 .57351 m .62889 .56057 L .64355 .57578 L p .343 .491 .863 r
F P
0 g
s
.62889 .56057 m .62961 .57351 L .61485 .55807 L p .351 .51 .875 r
F P
0 g
s
.66893 .60407 m .66703 .61604 L .65598 .60266 L p .303 .426 .821 r
F P
0 g
s
.65598 .60266 m .657 .59033 L .66893 .60407 L p .303 .426 .821 r
F P
0 g
s
.61485 .55807 m .61328 .54487 L .62889 .56057 L p .351 .51 .875 r
F P
0 g
s
.61328 .54487 m .61485 .55807 L .59942 .54227 L p .354 .523 .885 r
F P
0 g
s
.68808 .64957 m .68328 .66001 L .67952 .65052 L p .059 .085 .572 r
F P
0 g
s
.67952 .65052 m .68339 .63966 L .68808 .64957 L p .059 .085 .572 r
F P
0 g
s
.59942 .54227 m .59702 .52883 L .61328 .54487 L p .354 .523 .885 r
F P
0 g
s
.59702 .52883 m .59942 .54227 L .58361 .52627 L p .352 .53 .892 r
F P
0 g
s
.67907 .61683 m .67626 .62843 L .66703 .61604 L p .265 .37 .784 r
F P
0 g
s
.66703 .61604 m .66893 .60407 L .67907 .61683 L p .265 .37 .784 r
F P
0 g
s
.58361 .52627 m .58041 .51264 L .59702 .52883 L p .352 .53 .892 r
F P
0 g
s
.68711 .62845 m .68339 .63966 L .67626 .62843 L p .205 .285 .725 r
F P
0 g
s
.67626 .62843 m .67907 .61683 L .68711 .62845 L p .205 .285 .725 r
F P
0 g
s
.69002 .65798 m .68426 .66799 L .68328 .66001 L p 0 0 .339 r
F P
0 g
s
.68328 .66001 m .68808 .64957 L .69002 .65798 L p 0 0 .339 r
F P
0 g
s
.65783 .57765 m .657 .59033 L .64355 .57578 L p .341 .48 .854 r
F P
0 g
s
.64355 .57578 m .6435 .56278 L .65783 .57765 L p .341 .48 .854 r
F P
0 g
s
.6435 .56278 m .64355 .57578 L .62889 .56057 L p .355 .505 .87 r
F P
0 g
s
.62889 .56057 m .62796 .54727 L .6435 .56278 L p .355 .505 .87 r
F P
0 g
s
.62796 .54727 m .62889 .56057 L .61328 .54487 L p .362 .522 .881 r
F P
0 g
s
.67067 .59173 m .66893 .60407 L .657 .59033 L p .319 .446 .832 r
F P
0 g
s
.657 .59033 m .65783 .57765 L .67067 .59173 L p .319 .446 .832 r
F P
0 g
s
.69275 .63877 m .68808 .64957 L .68339 .63966 L p .106 .147 .621 r
F P
0 g
s
.68339 .63966 m .68711 .62845 L .69275 .63877 L p .106 .147 .621 r
F P
0 g
s
.61328 .54487 m .61149 .53131 L .62796 .54727 L p .362 .522 .881 r
F P
0 g
s
.61149 .53131 m .61328 .54487 L .59702 .52883 L p .365 .534 .89 r
F P
0 g
s
.68173 .60487 m .67907 .61683 L .66893 .60407 L p .286 .396 .8 r
F P
0 g
s
.66893 .60407 m .67067 .59173 L .68173 .60487 L p .286 .396 .8 r
F P
0 g
s
.59702 .52883 m .59439 .51504 L .61149 .53131 L p .365 .534 .89 r
F P
0 g
s
.59439 .51504 m .59702 .52883 L .58041 .51264 L p .363 .542 .896 r
F P
0 g
s
.6907 .61688 m .68711 .62845 L .67907 .61683 L p .233 .321 .749 r
F P
0 g
s
.67907 .61683 m .68173 .60487 L .6907 .61688 L p .233 .321 .749 r
F P
0 g
s
.58041 .51264 m .57695 .49866 L .59439 .51504 L p .363 .542 .896 r
F P
0 g
s
.69565 .64762 m .69002 .65798 L .68808 .64957 L p 0 0 .426 r
F P
0 g
s
.68808 .64957 m .69275 .63877 L .69565 .64762 L p 0 0 .426 r
F P
0 g
s
.68884 .66471 m .68209 .67426 L .68426 .66799 L p 0 0 0 r
F P
0 g
s
.68426 .66799 m .69002 .65798 L .68884 .66471 L p 0 0 0 r
F P
0 g
s
.69729 .62762 m .69275 .63877 L .68711 .62845 L p .147 .201 .662 r
F P
0 g
s
.68711 .62845 m .6907 .61688 L .69729 .62762 L p .147 .201 .662 r
F P
0 g
s
.65848 .5646 m .65783 .57765 L .6435 .56278 L p .353 .495 .862 r
F P
0 g
s
.6435 .56278 m .64324 .54941 L .65848 .5646 L p .353 .495 .862 r
F P
0 g
s
.64324 .54941 m .6435 .56278 L .62796 .54727 L p .366 .517 .876 r
F P
0 g
s
.67224 .57904 m .67067 .59173 L .65783 .57765 L p .334 .464 .842 r
F P
0 g
s
.65783 .57765 m .65848 .5646 L .67224 .57904 L p .334 .464 .842 r
F P
0 g
s
.62796 .54727 m .62681 .53361 L .64324 .54941 L p .366 .517 .876 r
F P
0 g
s
.62681 .53361 m .62796 .54727 L .61149 .53131 L p .373 .533 .886 r
F P
0 g
s
.68423 .59254 m .68173 .60487 L .67067 .59173 L p .304 .419 .814 r
F P
0 g
s
.67067 .59173 m .67224 .57904 L .68423 .59254 L p .304 .419 .814 r
F P
0 g
s
.61149 .53131 m .60946 .51738 L .62681 .53361 L p .373 .533 .886 r
F P
0 g
s
.60946 .51738 m .61149 .53131 L .59439 .51504 L p .375 .545 .894 r
F P
0 g
s
.59439 .51504 m .5915 .50089 L .60946 .51738 L p .375 .545 .894 r
F P
0 g
s
.5915 .50089 m .59439 .51504 L .57695 .49866 L p .374 .552 .901 r
F P
0 g
s
.69415 .60496 m .6907 .61688 L .68173 .60487 L p .257 .352 .77 r
F P
0 g
s
.68173 .60487 m .68423 .59254 L .69415 .60496 L p .257 .352 .77 r
F P
0 g
s
.69546 .65481 m .68884 .66471 L .69002 .65798 L p 0 0 .067 r
F P
0 g
s
.69002 .65798 m .69565 .64762 L .69546 .65481 L p 0 0 .067 r
F P
0 g
s
.70117 .63691 m .69565 .64762 L .69275 .63877 L p .001 0 .5 r
F P
0 g
s
.69275 .63877 m .69729 .62762 L .70117 .63691 L p .001 0 .5 r
F P
0 g
s
.57695 .49866 m .57322 .48433 L .5915 .50089 L p .374 .552 .901 r
F P
0 g
s
.68413 .66956 m .67636 .67862 L .68209 .67426 L p .642 .873 .512 r
F P
0 g
s
.68209 .67426 m .68884 .66471 L .68413 .66956 L p .642 .873 .512 r
F P
0 g
s
.7017 .61611 m .69729 .62762 L .6907 .61688 L p .183 .248 .697 r
F P
0 g
s
.6907 .61688 m .69415 .60496 L .7017 .61611 L p .183 .248 .697 r
F P
0 g
s
.65895 .55118 m .65848 .5646 L .64324 .54941 L p .365 .508 .869 r
F P
0 g
s
.64324 .54941 m .64278 .53566 L .65895 .55118 L p .365 .508 .869 r
F P
0 g
s
.64278 .53566 m .64324 .54941 L .62681 .53361 L p .376 .529 .881 r
F P
0 g
s
.67364 .56597 m .67224 .57904 L .65848 .5646 L p .347 .48 .851 r
F P
0 g
s
.65848 .5646 m .65895 .55118 L .67364 .56597 L p .347 .48 .851 r
F P
0 g
s
.62681 .53361 m .62544 .51957 L .64278 .53566 L p .376 .529 .881 r
F P
0 g
s
.62544 .51957 m .62681 .53361 L .60946 .51738 L p .383 .544 .891 r
F P
0 g
s
.68657 .57985 m .68423 .59254 L .67224 .57904 L p .321 .44 .826 r
F P
0 g
s
.67224 .57904 m .67364 .56597 L .68657 .57985 L p .321 .44 .826 r
F P
0 g
s
.60946 .51738 m .6072 .50309 L .62544 .51957 L p .383 .544 .891 r
F P
0 g
s
.6072 .50309 m .60946 .51738 L .5915 .50089 L p .385 .555 .899 r
F P
0 g
s
.70198 .64456 m .69546 .65481 L .69565 .64762 L p 0 0 .19 r
F P
0 g
s
.69565 .64762 m .70117 .63691 L .70198 .64456 L p 0 0 .19 r
F P
0 g
s
.69745 .59266 m .69415 .60496 L .68423 .59254 L p .28 .381 .788 r
F P
0 g
s
.68423 .59254 m .68657 .57985 L .69745 .59266 L p .28 .381 .788 r
F P
0 g
s
.70656 .62584 m .70117 .63691 L .69729 .62762 L p .057 .075 .562 r
F P
0 g
s
.69729 .62762 m .7017 .61611 L .70656 .62584 L p .057 .075 .562 r
F P
0 g
s
.5915 .50089 m .58836 .48638 L .6072 .50309 L p .385 .555 .899 r
F P
0 g
s
.58836 .48638 m .5915 .50089 L .57322 .48433 L p .384 .562 .905 r
F P
0 g
s
.69179 .66015 m .68413 .66956 L .68884 .66471 L p .593 .807 .403 r
F P
0 g
s
.68884 .66471 m .69546 .65481 L .69179 .66015 L p .593 .807 .403 r
F P
0 g
s
.57322 .48433 m .56922 .46964 L .58836 .48638 L p .384 .562 .905 r
F P
0 g
s
.70598 .60424 m .7017 .61611 L .69415 .60496 L p .215 .29 .726 r
F P
0 g
s
.69415 .60496 m .69745 .59266 L .70598 .60424 L p .215 .29 .726 r
F P
0 g
s
.67486 .55252 m .67364 .56597 L .65895 .55118 L p .36 .495 .859 r
F P
0 g
s
.65895 .55118 m .65921 .53738 L .67486 .55252 L p .36 .495 .859 r
F P
0 g
s
.65921 .53738 m .65895 .55118 L .64278 .53566 L p .376 .521 .875 r
F P
0 g
s
.64278 .53566 m .64211 .52154 L .65921 .53738 L p .376 .521 .875 r
F P
0 g
s
.64211 .52154 m .64278 .53566 L .62544 .51957 L p .386 .54 .886 r
F P
0 g
s
.67545 .67231 m .66661 .68086 L .67636 .67862 L p .724 .984 .783 r
F P
0 g
s
.67636 .67862 m .68413 .66956 L .67545 .67231 L p .724 .984 .783 r
F P
0 g
s
.70838 .63396 m .70198 .64456 L .70117 .63691 L p 0 0 .3 r
F P
0 g
s
.70117 .63691 m .70656 .62584 L .70838 .63396 L p 0 0 .3 r
F P
0 g
s
.68875 .56678 m .68657 .57985 L .67364 .56597 L p .336 .458 .837 r
F P
0 g
s
.67364 .56597 m .67486 .55252 L .68875 .56678 L p .336 .458 .837 r
F P
0 g
s
.62544 .51957 m .62384 .50516 L .64211 .52154 L p .386 .54 .886 r
F P
0 g
s
.62384 .50516 m .62544 .51957 L .6072 .50309 L p .392 .554 .895 r
F P
0 g
s
.69934 .65038 m .69179 .66015 L .69546 .65481 L p 0 0 0 r
F P
0 g
s
.69546 .65481 m .70198 .64456 L .69934 .65038 L p 0 0 0 r
F P
0 g
s
.71183 .61441 m .70656 .62584 L .7017 .61611 L p .106 .14 .613 r
F P
0 g
s
.7017 .61611 m .70598 .60424 L .71183 .61441 L p .106 .14 .613 r
F P
0 g
s
.6072 .50309 m .60469 .48842 L .62384 .50516 L p .392 .554 .895 r
F P
0 g
s
.60469 .48842 m .6072 .50309 L .58836 .48638 L p .394 .564 .902 r
F P
0 g
s
.70061 .57999 m .69745 .59266 L .68657 .57985 L p .299 .406 .804 r
F P
0 g
s
.68657 .57985 m .68875 .56678 L .70061 .57999 L p .299 .406 .804 r
F P
0 g
s
.58836 .48638 m .58495 .47149 L .60469 .48842 L p .394 .564 .902 r
F P
0 g
s
.58495 .47149 m .58836 .48638 L .56922 .46964 L p .393 .571 .908 r
F P
0 g
s
.71012 .59199 m .70598 .60424 L .69745 .59266 L p .243 .326 .75 r
F P
0 g
s
.69745 .59266 m .70061 .57999 L .71012 .59199 L p .243 .326 .75 r
F P
0 g
s
.68419 .66341 m .67545 .67231 L .68413 .66956 L p .715 .971 .732 r
F P
0 g
s
.68413 .66956 m .69179 .66015 L .68419 .66341 L p .715 .971 .732 r
F P
0 g
s
.56922 .46964 m .56493 .45458 L .58495 .47149 L p .393 .571 .908 r
F P
0 g
s
.71466 .62299 m .70838 .63396 L .70656 .62584 L p 0 0 .395 r
F P
0 g
s
.70656 .62584 m .71183 .61441 L .71466 .62299 L p 0 0 .395 r
F P
0 g
s
.70678 .64026 m .69934 .65038 L .70198 .64456 L p 0 0 0 r
F P
0 g
s
.70198 .64456 m .70838 .63396 L .70678 .64026 L p 0 0 0 r
F P
0 g
s
.67589 .53869 m .67486 .55252 L .65921 .53738 L p .371 .508 .866 r
F P
0 g
s
.65921 .53738 m .65928 .5232 L .67589 .53869 L p .371 .508 .866 r
F P
0 g
s
.65928 .5232 m .65921 .53738 L .64211 .52154 L p .386 .532 .88 r
F P
0 g
s
.64211 .52154 m .64122 .50703 L .65928 .5232 L p .386 .532 .88 r
F P
0 g
s
.64122 .50703 m .64211 .52154 L .62384 .50516 L p .395 .55 .891 r
F P
0 g
s
.69076 .55332 m .68875 .56678 L .67486 .55252 L p .349 .476 .846 r
F P
0 g
s
.67486 .55252 m .67589 .53869 L .69076 .55332 L p .349 .476 .846 r
F P
0 g
s
.71697 .60261 m .71183 .61441 L .70598 .60424 L p .149 .197 .656 r
F P
0 g
s
.70598 .60424 m .71012 .59199 L .71697 .60261 L p .149 .197 .656 r
F P
0 g
s
.62384 .50516 m .622 .49036 L .64122 .50703 L p .395 .55 .891 r
F P
0 g
s
.622 .49036 m .62384 .50516 L .60469 .48842 L p .401 .563 .899 r
F P
0 g
s
.7036 .56694 m .70061 .57999 L .68875 .56678 L p .317 .428 .817 r
F P
0 g
s
.68875 .56678 m .69076 .55332 L .7036 .56694 L p .317 .428 .817 r
F P
0 g
s
.69281 .65416 m .68419 .66341 L .69179 .66015 L p .697 .948 .667 r
F P
0 g
s
.69179 .66015 m .69934 .65038 L .69281 .65416 L p .697 .948 .667 r
F P
0 g
s
.60469 .48842 m .60192 .47336 L .622 .49036 L p .401 .563 .899 r
F P
0 g
s
.60192 .47336 m .60469 .48842 L .58495 .47149 L p .403 .573 .906 r
F P
0 g
s
.6623 .6727 m .65232 .6807 L .66661 .68086 L p .726 .984 .899 r
F P
0 g
s
.66661 .68086 m .67545 .67231 L .6623 .6727 L p .726 .984 .899 r
F P
0 g
s
.71412 .57937 m .71012 .59199 L .70061 .57999 L p .267 .358 .771 r
F P
0 g
s
.70061 .57999 m .7036 .56694 L .71412 .57937 L p .267 .358 .771 r
F P
0 g
s
.58495 .47149 m .58127 .45623 L .60192 .47336 L p .403 .573 .906 r
F P
0 g
s
.58127 .45623 m .58495 .47149 L .56493 .45458 L p .402 .579 .911 r
F P
0 g
s
.72083 .61165 m .71466 .62299 L .71183 .61441 L p 0 0 .476 r
F P
0 g
s
.71183 .61441 m .71697 .60261 L .72083 .61165 L p 0 0 .476 r
F P
0 g
s
.71411 .62978 m .70678 .64026 L .70838 .63396 L p 0 0 0 r
F P
0 g
s
.70838 .63396 m .71466 .62299 L .71411 .62978 L p 0 0 0 r
F P
0 g
s
.56493 .45458 m .56036 .43914 L .58127 .45623 L p .402 .579 .911 r
F P
0 g
s
.72199 .59043 m .71697 .60261 L .71012 .59199 L p .186 .246 .692 r
F P
0 g
s
.71012 .59199 m .71412 .57937 L .72199 .59043 L p .186 .246 .692 r
F P
0 g
s
.70133 .64455 m .69281 .65416 L .69934 .65038 L p .67 .911 .585 r
F P
0 g
s
.69934 .65038 m .70678 .64026 L .70133 .64455 L p .67 .911 .585 r
F P
0 g
s
.67217 .66434 m .6623 .6727 L .67545 .67231 L p .729 .989 .879 r
F P
0 g
s
.67545 .67231 m .68419 .66341 L .67217 .66434 L p .729 .989 .879 r
F P
0 g
s
.67673 .52447 m .67589 .53869 L .65928 .5232 L p .382 .521 .872 r
F P
0 g
s
.65928 .5232 m .65913 .50863 L .67673 .52447 L p .382 .521 .872 r
F P
0 g
s
.65913 .50863 m .65928 .5232 L .64122 .50703 L p .395 .543 .885 r
F P
0 g
s
.6926 .53948 m .69076 .55332 L .67589 .53869 L p .362 .491 .855 r
F P
0 g
s
.67589 .53869 m .67673 .52447 L .6926 .53948 L p .362 .491 .855 r
F P
0 g
s
.64122 .50703 m .6401 .49214 L .65913 .50863 L p .395 .543 .885 r
F P
0 g
s
.6401 .49214 m .64122 .50703 L .622 .49036 L p .404 .559 .895 r
F P
0 g
s
.622 .49036 m .61992 .47518 L .6401 .49214 L p .404 .559 .895 r
F P
0 g
s
.61992 .47518 m .622 .49036 L .60192 .47336 L p .409 .572 .903 r
F P
0 g
s
.70645 .55351 m .7036 .56694 L .69076 .55332 L p .333 .449 .829 r
F P
0 g
s
.69076 .55332 m .6926 .53948 L .70645 .55351 L p .333 .449 .829 r
F P
0 g
s
.60192 .47336 m .59888 .45793 L .61992 .47518 L p .409 .572 .903 r
F P
0 g
s
.59888 .45793 m .60192 .47336 L .58127 .45623 L p .411 .581 .909 r
F P
0 g
s
.71798 .56636 m .71412 .57937 L .7036 .56694 L p .289 .386 .789 r
F P
0 g
s
.7036 .56694 m .70645 .55351 L .71798 .56636 L p .289 .386 .789 r
F P
0 g
s
.72133 .61893 m .71411 .62978 L .71466 .62299 L p 0 0 .126 r
F P
0 g
s
.71466 .62299 m .72083 .61165 L .72133 .61893 L p 0 0 .126 r
F P
0 g
s
.72689 .59994 m .72083 .61165 L .71697 .60261 L p .047 .055 .543 r
F P
0 g
s
.71697 .60261 m .72199 .59043 L .72689 .59994 L p .047 .055 .543 r
F P
0 g
s
.68192 .65563 m .67217 .66434 L .68419 .66341 L p .731 .991 .853 r
F P
0 g
s
.68419 .66341 m .69281 .65416 L .68192 .65563 L p .731 .991 .853 r
F P
0 g
s
.58127 .45623 m .5773 .44058 L .59888 .45793 L p .411 .581 .909 r
F P
0 g
s
.5773 .44058 m .58127 .45623 L .56036 .43914 L p .411 .587 .914 r
F P
0 g
s
.70975 .63458 m .70133 .64455 L .70678 .64026 L p .629 .858 .486 r
F P
0 g
s
.70678 .64026 m .71411 .62978 L .70975 .63458 L p .629 .858 .486 r
F P
0 g
s
.72688 .57787 m .72199 .59043 L .71412 .57937 L p .219 .289 .722 r
F P
0 g
s
.71412 .57937 m .71798 .56636 L .72688 .57787 L p .219 .289 .722 r
F P
0 g
s
.56036 .43914 m .55548 .42334 L .5773 .44058 L p .411 .587 .914 r
F P
0 g
s
.67738 .50985 m .67673 .52447 L .65913 .50863 L p .392 .533 .878 r
F P
0 g
s
.65913 .50863 m .65878 .49366 L .67738 .50985 L p .392 .533 .878 r
F P
0 g
s
.65878 .49366 m .65913 .50863 L .6401 .49214 L p .404 .553 .89 r
F P
0 g
s
.64407 .67045 m .63288 .67786 L .65232 .6807 L p .708 .959 .947 r
F P
0 g
s
.65232 .6807 m .6623 .6727 L .64407 .67045 L p .708 .959 .947 r
F P
0 g
s
.69426 .52525 m .6926 .53948 L .67673 .52447 L p .374 .505 .862 r
F P
0 g
s
.67673 .52447 m .67738 .50985 L .69426 .52525 L p .374 .505 .862 r
F P
0 g
s
.6401 .49214 m .63875 .47684 L .65878 .49366 L p .404 .553 .89 r
F P
0 g
s
.63875 .47684 m .6401 .49214 L .61992 .47518 L p .412 .568 .899 r
F P
0 g
s
.70913 .53968 m .70645 .55351 L .6926 .53948 L p .348 .467 .839 r
F P
0 g
s
.6926 .53948 m .69426 .52525 L .70913 .53968 L p .348 .467 .839 r
F P
0 g
s
.69158 .64656 m .68192 .65563 L .69281 .65416 L p .729 .989 .821 r
F P
0 g
s
.69281 .65416 m .70133 .64455 L .69158 .64656 L p .729 .989 .821 r
F P
0 g
s
.72845 .60771 m .72133 .61893 L .72083 .61165 L p 0 0 .246 r
F P
0 g
s
.72083 .61165 m .72689 .59994 L .72845 .60771 L p 0 0 .246 r
F P
0 g
s
.61992 .47518 m .61758 .45959 L .63875 .47684 L p .412 .568 .899 r
F P
0 g
s
.61758 .45959 m .61992 .47518 L .59888 .45793 L p .417 .58 .906 r
F P
0 g
s
.73282 .58785 m .72689 .59994 L .72199 .59043 L p .1 .125 .599 r
F P
0 g
s
.72199 .59043 m .72688 .57787 L .73282 .58785 L p .1 .125 .599 r
F P
0 g
s
.72169 .55296 m .71798 .56636 L .70645 .55351 L p .309 .412 .805 r
F P
0 g
s
.70645 .55351 m .70913 .53968 L .72169 .55296 L p .309 .412 .805 r
F P
0 g
s
.71411 .62978 m .72133 .61893 L .71806 .62424 L p 0 0 0 r
F P
0 g
s
.71806 .62424 m .70975 .63458 L .71411 .62978 L p 0 0 0 r
F P
0 g
s
.59888 .45793 m .59558 .4421 L .61758 .45959 L p .417 .58 .906 r
F P
0 g
s
.59558 .4421 m .59888 .45793 L .5773 .44058 L p .419 .589 .912 r
F P
0 g
s
.65515 .66267 m .64407 .67045 L .6623 .6727 L p .713 .965 .939 r
F P
0 g
s
.6623 .6727 m .67217 .66434 L .65515 .66267 L p .713 .965 .939 r
F P
0 g
s
.5773 .44058 m .57304 .42455 L .59558 .4421 L p .419 .589 .912 r
F P
0 g
s
.57304 .42455 m .5773 .44058 L .55548 .42334 L p .419 .595 .917 r
F P
0 g
s
.73164 .56493 m .72688 .57787 L .71798 .56636 L p .248 .326 .748 r
F P
0 g
s
.71798 .56636 m .72169 .55296 L .73164 .56493 L p .248 .326 .748 r
F P
0 g
s
.70112 .63713 m .69158 .64656 L .70133 .64455 L p .724 .983 .779 r
F P
0 g
s
.70133 .64455 m .70975 .63458 L .70112 .63713 L p .724 .983 .779 r
F P
0 g
s
.55548 .42334 m .55029 .40715 L .57304 .42455 L p .419 .595 .917 r
F P
0 g
s
.73545 .59612 m .72845 .60771 L .72689 .59994 L p 0 0 .351 r
F P
0 g
s
.72689 .59994 m .73282 .58785 L .73545 .59612 L p 0 0 .351 r
F P
0 g
s
.69573 .51061 m .69426 .52525 L .67738 .50985 L p .385 .518 .869 r
F P
0 g
s
.67738 .50985 m .67782 .49483 L .69573 .51061 L p .385 .518 .869 r
F P
0 g
s
.67782 .49483 m .67738 .50985 L .65878 .49366 L p .401 .543 .883 r
F P
0 g
s
.65878 .49366 m .6582 .47828 L .67782 .49483 L p .401 .543 .883 r
F P
0 g
s
.6582 .47828 m .65878 .49366 L .63875 .47684 L p .412 .562 .894 r
F P
0 g
s
.66611 .65454 m .65515 .66267 L .67217 .66434 L p .718 .972 .929 r
F P
0 g
s
.67217 .66434 m .68192 .65563 L .66611 .65454 L p .718 .972 .929 r
F P
0 g
s
.72627 .61353 m .71806 .62424 L .72133 .61893 L p 0 0 0 r
F P
0 g
s
.72133 .61893 m .72845 .60771 L .72627 .61353 L p 0 0 0 r
F P
0 g
s
.71164 .52545 m .70913 .53968 L .69426 .52525 L p .361 .484 .848 r
F P
0 g
s
.69426 .52525 m .69573 .51061 L .71164 .52545 L p .361 .484 .848 r
F P
0 g
s
.63875 .47684 m .63715 .46114 L .6582 .47828 L p .412 .562 .894 r
F P
0 g
s
.63715 .46114 m .63875 .47684 L .61758 .45959 L p .419 .576 .902 r
F P
0 g
s
.73864 .57538 m .73282 .58785 L .72688 .57787 L p .145 .185 .645 r
F P
0 g
s
.72688 .57787 m .73164 .56493 L .73864 .57538 L p .145 .185 .645 r
F P
0 g
s
.61758 .45959 m .61498 .44361 L .63715 .46114 L p .419 .576 .902 r
F P
0 g
s
.61498 .44361 m .61758 .45959 L .59558 .4421 L p .424 .587 .909 r
F P
0 g
s
.72526 .53917 m .72169 .55296 L .70913 .53968 L p .327 .434 .818 r
F P
0 g
s
.70913 .53968 m .71164 .52545 L .72526 .53917 L p .327 .434 .818 r
F P
0 g
s
.71057 .62734 m .70112 .63713 L .70975 .63458 L p .713 .968 .725 r
F P
0 g
s
.70975 .63458 m .71806 .62424 L .71057 .62734 L p .713 .968 .725 r
F P
0 g
s
.59558 .4421 m .59199 .42587 L .61498 .44361 L p .424 .587 .909 r
F P
0 g
s
.59199 .42587 m .59558 .4421 L .57304 .42455 L p .426 .596 .915 r
F P
0 g
s
.67696 .64604 m .66611 .65454 L .68192 .65563 L p .723 .979 .916 r
F P
0 g
s
.68192 .65563 m .69158 .64656 L .67696 .64604 L p .723 .979 .916 r
F P
0 g
s
.73626 .55159 m .73164 .56493 L .72169 .55296 L p .273 .359 .77 r
F P
0 g
s
.72169 .55296 m .72526 .53917 L .73626 .55159 L p .273 .359 .77 r
F P
0 g
s
.57304 .42455 m .56848 .40812 L .59199 .42587 L p .426 .596 .915 r
F P
0 g
s
.56848 .40812 m .57304 .42455 L .55029 .40715 L p .426 .602 .92 r
F P
0 g
s
.74235 .58414 m .73545 .59612 L .73282 .58785 L p 0 0 .44 r
F P
0 g
s
.73282 .58785 m .73864 .57538 L .74235 .58414 L p 0 0 .44 r
F P
0 g
s
.6201 .66521 m .60759 .67199 L .63288 .67786 L p .688 .931 .968 r
F P
0 g
s
.63288 .67786 m .64407 .67045 L .6201 .66521 L p .688 .931 .968 r
F P
0 g
s
.73438 .60246 m .72627 .61353 L .72845 .60771 L p 0 0 0 r
F P
0 g
s
.72845 .60771 m .73545 .59612 L .73438 .60246 L p 0 0 0 r
F P
0 g
s
.69702 .49556 m .69573 .51061 L .67782 .49483 L p .395 .53 .875 r
F P
0 g
s
.67782 .49483 m .67806 .4794 L .69702 .49556 L p .395 .53 .875 r
F P
0 g
s
.67806 .4794 m .67782 .49483 L .6582 .47828 L p .409 .553 .888 r
F P
0 g
s
.55029 .40715 m .54478 .39057 L .56848 .40812 L p .426 .602 .92 r
F P
0 g
s
.6582 .47828 m .65739 .46249 L .67806 .4794 L p .409 .553 .888 r
F P
0 g
s
.65739 .46249 m .6582 .47828 L .63715 .46114 L p .42 .571 .898 r
F P
0 g
s
.74434 .56252 m .73864 .57538 L .73164 .56493 L p .185 .237 .683 r
F P
0 g
s
.73164 .56493 m .73626 .55159 L .74434 .56252 L p .185 .237 .683 r
F P
0 g
s
.71399 .51082 m .71164 .52545 L .69573 .51061 L p .373 .499 .857 r
F P
0 g
s
.69573 .51061 m .69702 .49556 L .71399 .51082 L p .373 .499 .857 r
F P
0 g
s
.71992 .61717 m .71057 .62734 L .71806 .62424 L p .693 .943 .657 r
F P
0 g
s
.71806 .62424 m .72627 .61353 L .71992 .61717 L p .693 .943 .657 r
F P
0 g
s
.63715 .46114 m .6353 .44504 L .65739 .46249 L p .42 .571 .898 r
F P
0 g
s
.6353 .44504 m .63715 .46114 L .61498 .44361 L p .427 .584 .906 r
F P
0 g
s
.6877 .63718 m .67696 .64604 L .69158 .64656 L p .727 .984 .9 r
F P
0 g
s
.69158 .64656 m .70112 .63713 L .6877 .63718 L p .727 .984 .9 r
F P
0 g
s
.72867 .52497 m .72526 .53917 L .71164 .52545 L p .343 .454 .83 r
F P
0 g
s
.71164 .52545 m .71399 .51082 L .72867 .52497 L p .343 .454 .83 r
F P
0 g
s
.63247 .65806 m .6201 .66521 L .64407 .67045 L p .693 .937 .964 r
F P
0 g
s
.64407 .67045 m .65515 .66267 L .63247 .65806 L p .693 .937 .964 r
F P
0 g
s
.61498 .44361 m .61211 .42722 L .6353 .44504 L p .427 .584 .906 r
F P
0 g
s
.61211 .42722 m .61498 .44361 L .59199 .42587 L p .431 .595 .912 r
F P
0 g
s
.74075 .53785 m .73626 .55159 L .72526 .53917 L p .295 .388 .788 r
F P
0 g
s
.72526 .53917 m .72867 .52497 L .74075 .53785 L p .295 .388 .788 r
F P
0 g
s
.59199 .42587 m .5881 .40923 L .61211 .42722 L p .431 .595 .912 r
F P
0 g
s
.5881 .40923 m .59199 .42587 L .56848 .40812 L p .433 .603 .917 r
F P
0 g
s
.74239 .591 m .73438 .60246 L .73545 .59612 L p 0 0 .042 r
F P
0 g
s
.73545 .59612 m .74235 .58414 L .74239 .591 L p 0 0 .042 r
F P
0 g
s
.74914 .57178 m .74235 .58414 L .73864 .57538 L p .029 .024 .515 r
F P
0 g
s
.73864 .57538 m .74434 .56252 L .74914 .57178 L p .029 .024 .515 r
F P
0 g
s
.64472 .65054 m .63247 .65806 L .65515 .66267 L p .698 .944 .96 r
F P
0 g
s
.65515 .66267 m .66611 .65454 L .64472 .65054 L p .698 .944 .96 r
F P
0 g
s
.69834 .62796 m .6877 .63718 L .70112 .63713 L p .73 .989 .88 r
F P
0 g
s
.70112 .63713 m .71057 .62734 L .69834 .62796 L p .73 .989 .88 r
F P
0 g
s
.56848 .40812 m .5636 .39129 L .5881 .40923 L p .433 .603 .917 r
F P
0 g
s
.5636 .39129 m .56848 .40812 L .54478 .39057 L p .434 .609 .922 r
F P
0 g
s
.72917 .60663 m .71992 .61717 L .72627 .61353 L p .662 .903 .571 r
F P
0 g
s
.72627 .61353 m .73438 .60246 L .72917 .60663 L p .662 .903 .571 r
F P
0 g
s
.74991 .54926 m .74434 .56252 L .73626 .55159 L p .219 .282 .716 r
F P
0 g
s
.73626 .55159 m .74075 .53785 L .74991 .54926 L p .219 .282 .716 r
F P
0 g
s
.69811 .4801 m .69702 .49556 L .67806 .4794 L p .404 .541 .88 r
F P
0 g
s
.67806 .4794 m .67807 .46355 L .69811 .4801 L p .404 .541 .88 r
F P
0 g
s
.67807 .46355 m .67806 .4794 L .65739 .46249 L p .417 .563 .892 r
F P
0 g
s
.71616 .49577 m .71399 .51082 L .69702 .49556 L p .385 .513 .864 r
F P
0 g
s
.69702 .49556 m .69811 .4801 L .71616 .49577 L p .385 .513 .864 r
F P
0 g
s
.65739 .46249 m .65634 .44629 L .67807 .46355 L p .417 .563 .892 r
F P
0 g
s
.65634 .44629 m .65739 .46249 L .6353 .44504 L p .427 .579 .901 r
F P
0 g
s
.54478 .39057 m .53894 .37361 L .5636 .39129 L p .434 .609 .922 r
F P
0 g
s
.6353 .44504 m .6332 .42851 L .65634 .44629 L p .427 .579 .901 r
F P
0 g
s
.6332 .42851 m .6353 .44504 L .61211 .42722 L p .433 .591 .908 r
F P
0 g
s
.65684 .64266 m .64472 .65054 L .66611 .65454 L p .703 .951 .954 r
F P
0 g
s
.66611 .65454 m .67696 .64604 L .65684 .64266 L p .703 .951 .954 r
F P
0 g
s
.73192 .51036 m .72867 .52497 L .71399 .51082 L p .357 .473 .84 r
F P
0 g
s
.71399 .51082 m .71616 .49577 L .73192 .51036 L p .357 .473 .84 r
F P
0 g
s
.75029 .57915 m .74239 .591 L .74235 .58414 L p 0 0 .173 r
F P
0 g
s
.74235 .58414 m .74914 .57178 L .75029 .57915 L p 0 0 .173 r
F P
0 g
s
.70887 .61836 m .69834 .62796 L .71057 .62734 L p .731 .991 .854 r
F P
0 g
s
.71057 .62734 m .71992 .61717 L .70887 .61836 L p .731 .991 .854 r
F P
0 g
s
.61211 .42722 m .60896 .41041 L .6332 .42851 L p .433 .591 .908 r
F P
0 g
s
.60896 .41041 m .61211 .42722 L .5881 .40923 L p .438 .601 .914 r
F P
0 g
s
.74509 .5237 m .74075 .53785 L .72867 .52497 L p .315 .414 .804 r
F P
0 g
s
.72867 .52497 m .73192 .51036 L .74509 .5237 L p .315 .414 .804 r
F P
0 g
s
.75582 .55902 m .74914 .57178 L .74434 .56252 L p .086 .1 .577 r
F P
0 g
s
.74434 .56252 m .74991 .54926 L .75582 .55902 L p .086 .1 .577 r
F P
0 g
s
.73832 .59572 m .72917 .60663 L .73438 .60246 L p .617 .844 .465 r
F P
0 g
s
.73438 .60246 m .74239 .591 L .73832 .59572 L p .617 .844 .465 r
F P
0 g
s
.5881 .40923 m .58392 .39219 L .60896 .41041 L p .438 .601 .914 r
F P
0 g
s
.58392 .39219 m .5881 .40923 L .5636 .39129 L p .44 .609 .92 r
F P
0 g
s
.66886 .63442 m .65684 .64266 L .67696 .64604 L p .709 .957 .948 r
F P
0 g
s
.67696 .64604 m .6877 .63718 L .66886 .63442 L p .709 .957 .948 r
F P
0 g
s
.75536 .5356 m .74991 .54926 L .74075 .53785 L p .249 .321 .742 r
F P
0 g
s
.74075 .53785 m .74509 .5237 L .75536 .5356 L p .249 .321 .742 r
F P
0 g
s
.58954 .65659 m .57561 .66268 L .60759 .67199 L p .671 .908 .977 r
F P
0 g
s
.60759 .67199 m .6201 .66521 L .58954 .65659 L p .671 .908 .977 r
F P
0 g
s
.5636 .39129 m .5584 .37406 L .58392 .39219 L p .44 .609 .92 r
F P
0 g
s
.5584 .37406 m .5636 .39129 L .53894 .37361 L p .441 .616 .924 r
F P
0 g
s
.71932 .6084 m .70887 .61836 L .71992 .61717 L p .729 .989 .821 r
F P
0 g
s
.71992 .61717 m .72917 .60663 L .71932 .6084 L p .729 .989 .821 r
F P
0 g
s
.699 .46422 m .69811 .4801 L .67807 .46355 L p .412 .551 .885 r
F P
0 g
s
.67807 .46355 m .67787 .44727 L .699 .46422 L p .412 .551 .885 r
F P
0 g
s
.67787 .44727 m .67807 .46355 L .65634 .44629 L p .425 .571 .896 r
F P
0 g
s
.71815 .4803 m .71616 .49577 L .69811 .4801 L p .395 .525 .87 r
F P
0 g
s
.69811 .4801 m .699 .46422 L .71815 .4803 L p .395 .525 .87 r
F P
0 g
s
.65634 .44629 m .65504 .42965 L .67787 .44727 L p .425 .571 .896 r
F P
0 g
s
.65504 .42965 m .65634 .44629 L .6332 .42851 L p .434 .586 .904 r
F P
0 g
s
.7581 .56692 m .75029 .57915 L .74914 .57178 L p 0 0 .29 r
F P
0 g
s
.74914 .57178 m .75582 .55902 L .7581 .56692 L p 0 0 .29 r
F P
0 g
s
.73501 .49534 m .73192 .51036 L .71616 .49577 L p .37 .489 .849 r
F P
0 g
s
.71616 .49577 m .71815 .4803 L .73501 .49534 L p .37 .489 .849 r
F P
0 g
s
.53894 .37361 m .53275 .35624 L .5584 .37406 L p .441 .616 .924 r
F P
0 g
s
.60333 .65012 m .58954 .65659 L .6201 .66521 L p .675 .913 .975 r
F P
0 g
s
.6201 .66521 m .63247 .65806 L .60333 .65012 L p .675 .913 .975 r
F P
0 g
s
.68076 .6258 m .66886 .63442 L .6877 .63718 L p .714 .964 .94 r
F P
0 g
s
.6877 .63718 m .69834 .62796 L .68076 .6258 L p .714 .964 .94 r
F P
0 g
s
.6332 .42851 m .63082 .41156 L .65504 .42965 L p .434 .586 .904 r
F P
0 g
s
.63082 .41156 m .6332 .42851 L .60896 .41041 L p .44 .598 .911 r
F P
0 g
s
.74239 .591 m .75029 .57915 L .74738 .58442 L p 0 0 0 r
F P
0 g
s
.74738 .58442 m .73832 .59572 L .74239 .591 L p 0 0 0 r
F P
0 g
s
.76239 .54587 m .75582 .55902 L .74991 .54926 L p .135 .165 .628 r
F P
0 g
s
.74991 .54926 m .75536 .5356 L .76239 .54587 L p .135 .165 .628 r
F P
0 g
s
.7493 .50914 m .74509 .5237 L .73192 .51036 L p .333 .436 .817 r
F P
0 g
s
.73192 .51036 m .73501 .49534 L .7493 .50914 L p .333 .436 .817 r
F P
0 g
s
.60896 .41041 m .60551 .39318 L .63082 .41156 L p .44 .598 .911 r
F P
0 g
s
.60551 .39318 m .60896 .41041 L .58392 .39219 L p .444 .608 .917 r
F P
0 g
s
.61698 .64327 m .60333 .65012 L .63247 .65806 L p .68 .918 .973 r
F P
0 g
s
.63247 .65806 m .64472 .65054 L .61698 .64327 L p .68 .918 .973 r
F P
0 g
s
.72966 .59805 m .71932 .6084 L .72917 .60663 L p .723 .982 .778 r
F P
0 g
s
.72917 .60663 m .73832 .59572 L .72966 .59805 L p .723 .982 .778 r
F P
0 g
s
.58392 .39219 m .57942 .37473 L .60551 .39318 L p .444 .608 .917 r
F P
0 g
s
.57942 .37473 m .58392 .39219 L .5584 .37406 L p .446 .615 .922 r
F P
0 g
s
.76068 .52153 m .75536 .5356 L .74509 .5237 L p .275 .356 .765 r
F P
0 g
s
.74509 .5237 m .7493 .50914 L .76068 .52153 L p .275 .356 .765 r
F P
0 g
s
.69256 .61681 m .68076 .6258 L .69834 .62796 L p .719 .971 .93 r
F P
0 g
s
.69834 .62796 m .70887 .61836 L .69256 .61681 L p .719 .971 .93 r
F P
0 g
s
.5584 .37406 m .55287 .35642 L .57942 .37473 L p .446 .615 .922 r
F P
0 g
s
.55287 .35642 m .5584 .37406 L .53275 .35624 L p .447 .622 .926 r
F P
0 g
s
.76581 .55429 m .7581 .56692 L .75582 .55902 L p 0 0 .391 r
F P
0 g
s
.75582 .55902 m .76239 .54587 L .76581 .55429 L p 0 0 .391 r
F P
0 g
s
.75634 .57273 m .74738 .58442 L .75029 .57915 L p 0 0 0 r
F P
0 g
s
.75029 .57915 m .7581 .56692 L .75634 .57273 L p 0 0 0 r
F P
0 g
s
.63049 .63606 m .61698 .64327 L .64472 .65054 L p .684 .924 .971 r
F P
0 g
s
.64472 .65054 m .65684 .64266 L .63049 .63606 L p .684 .924 .971 r
F P
0 g
s
.71995 .4644 m .71815 .4803 L .699 .46422 L p .405 .537 .876 r
F P
0 g
s
.699 .46422 m .69968 .4479 L .71995 .4644 L p .405 .537 .876 r
F P
0 g
s
.69968 .4479 m .699 .46422 L .67787 .44727 L p .421 .561 .889 r
F P
0 g
s
.67787 .44727 m .67743 .43056 L .69968 .4479 L p .421 .561 .889 r
F P
0 g
s
.67743 .43056 m .67787 .44727 L .65504 .42965 L p .432 .579 .899 r
F P
0 g
s
.73794 .47989 m .73501 .49534 L .71815 .4803 L p .382 .504 .857 r
F P
0 g
s
.71815 .4803 m .71995 .4644 L .73794 .47989 L p .382 .504 .857 r
F P
0 g
s
.65504 .42965 m .65349 .41259 L .67743 .43056 L p .432 .579 .899 r
F P
0 g
s
.65349 .41259 m .65504 .42965 L .63082 .41156 L p .44 .593 .907 r
F P
0 g
s
.76884 .5323 m .76239 .54587 L .75536 .5356 L p .177 .221 .67 r
F P
0 g
s
.75536 .5356 m .76068 .52153 L .76884 .5323 L p .177 .221 .67 r
F P
0 g
s
.53275 .35624 m .5262 .33848 L .55287 .35642 L p .447 .622 .926 r
F P
0 g
s
.63082 .41156 m .62817 .39417 L .65349 .41259 L p .44 .593 .907 r
F P
0 g
s
.62817 .39417 m .63082 .41156 L .60551 .39318 L p .446 .605 .914 r
F P
0 g
s
.75335 .49416 m .7493 .50914 L .73501 .49534 L p .349 .457 .829 r
F P
0 g
s
.73501 .49534 m .73794 .47989 L .75335 .49416 L p .349 .457 .829 r
F P
0 g
s
.73992 .58732 m .72966 .59805 L .73832 .59572 L p .71 .967 .722 r
F P
0 g
s
.73832 .59572 m .74738 .58442 L .73992 .58732 L p .71 .967 .722 r
F P
0 g
s
.70426 .60745 m .69256 .61681 L .70887 .61836 L p .723 .978 .918 r
F P
0 g
s
.70887 .61836 m .71932 .6084 L .70426 .60745 L p .723 .978 .918 r
F P
0 g
s
.64388 .62847 m .63049 .63606 L .65684 .64266 L p .689 .929 .968 r
F P
0 g
s
.65684 .64266 m .66886 .63442 L .64388 .62847 L p .689 .929 .968 r
F P
0 g
s
.60551 .39318 m .60176 .37552 L .62817 .39417 L p .446 .605 .914 r
F P
0 g
s
.60176 .37552 m .60551 .39318 L .57942 .37473 L p .45 .614 .919 r
F P
0 g
s
.76587 .50704 m .76068 .52153 L .7493 .50914 L p .298 .386 .784 r
F P
0 g
s
.7493 .50914 m .75335 .49416 L .76587 .50704 L p .298 .386 .784 r
F P
0 g
s
.57942 .37473 m .57459 .35684 L .60176 .37552 L p .45 .614 .919 r
F P
0 g
s
.57459 .35684 m .57942 .37473 L .55287 .35642 L p .453 .621 .924 r
F P
0 g
s
.76522 .56065 m .75634 .57273 L .7581 .56692 L p 0 0 0 r
F P
0 g
s
.7581 .56692 m .76581 .55429 L .76522 .56065 L p 0 0 0 r
F P
0 g
s
.77341 .54126 m .76581 .55429 L .76239 .54587 L p .002 0 .476 r
F P
0 g
s
.76239 .54587 m .76884 .5323 L .77341 .54126 L p .002 0 .476 r
F P
0 g
s
.65714 .62051 m .64388 .62847 L .66886 .63442 L p .694 .936 .965 r
F P
0 g
s
.66886 .63442 m .68076 .6258 L .65714 .62051 L p .694 .936 .965 r
F P
0 g
s
.71586 .59771 m .70426 .60745 L .71932 .6084 L p .727 .984 .902 r
F P
0 g
s
.71932 .6084 m .72966 .59805 L .71586 .59771 L p .727 .984 .902 r
F P
0 g
s
.75008 .57621 m .73992 .58732 L .74738 .58442 L p .688 .94 .651 r
F P
0 g
s
.74738 .58442 m .75634 .57273 L .75008 .57621 L p .688 .94 .651 r
F P
0 g
s
.55287 .35642 m .54698 .33836 L .57459 .35684 L p .453 .621 .924 r
F P
0 g
s
.54698 .33836 m .55287 .35642 L .5262 .33848 L p .454 .628 .928 r
F P
0 g
s
.77518 .51833 m .76884 .5323 L .76068 .52153 L p .214 .27 .705 r
F P
0 g
s
.76068 .52153 m .76587 .50704 L .77518 .51833 L p .214 .27 .705 r
F P
0 g
s
.72155 .44807 m .71995 .4644 L .69968 .4479 L p .413 .548 .881 r
F P
0 g
s
.69968 .4479 m .70014 .43114 L .72155 .44807 L p .413 .548 .881 r
F P
0 g
s
.70014 .43114 m .69968 .4479 L .67743 .43056 L p .428 .57 .893 r
F P
0 g
s
.55144 .6441 m .53591 .64944 L .57561 .66268 L p .657 .888 .981 r
F P
0 g
s
.57561 .66268 m .58954 .65659 L .55144 .6441 L p .657 .888 .981 r
F P
0 g
s
.67743 .43056 m .67675 .41342 L .70014 .43114 L p .428 .57 .893 r
F P
0 g
s
.67675 .41342 m .67743 .43056 L .65349 .41259 L p .439 .587 .903 r
F P
0 g
s
.74069 .464 m .73794 .47989 L .71995 .4644 L p .393 .518 .864 r
F P
0 g
s
.71995 .4644 m .72155 .44807 L .74069 .464 L p .393 .518 .864 r
F P
0 g
s
.65349 .41259 m .65168 .39509 L .67675 .41342 L p .439 .587 .903 r
F P
0 g
s
.65168 .39509 m .65349 .41259 L .62817 .39417 L p .446 .6 .91 r
F P
0 g
s
.75725 .47875 m .75335 .49416 L .73794 .47989 L p .363 .475 .84 r
F P
0 g
s
.73794 .47989 m .74069 .464 L .75725 .47875 L p .363 .475 .84 r
F P
0 g
s
.5262 .33848 m .51928 .32031 L .54698 .33836 L p .454 .628 .928 r
F P
0 g
s
.62817 .39417 m .62523 .37635 L .65168 .39509 L p .446 .6 .91 r
F P
0 g
s
.62523 .37635 m .62817 .39417 L .60176 .37552 L p .452 .611 .916 r
F P
0 g
s
.56679 .63838 m .55144 .6441 L .58954 .65659 L p .661 .892 .98 r
F P
0 g
s
.58954 .65659 m .60333 .65012 L .56679 .63838 L p .661 .892 .98 r
F P
0 g
s
.67029 .61217 m .65714 .62051 L .68076 .6258 L p .698 .942 .961 r
F P
0 g
s
.68076 .6258 m .69256 .61681 L .67029 .61217 L p .698 .942 .961 r
F P
0 g
s
.774 .54817 m .76522 .56065 L .76581 .55429 L p 0 0 .081 r
F P
0 g
s
.76581 .55429 m .77341 .54126 L .774 .54817 L p 0 0 .081 r
F P
0 g
s
.77093 .49213 m .76587 .50704 L .75335 .49416 L p .318 .412 .801 r
F P
0 g
s
.75335 .49416 m .75725 .47875 L .77093 .49213 L p .318 .412 .801 r
F P
0 g
s
.60176 .37552 m .5977 .35743 L .62523 .37635 L p .452 .611 .916 r
F P
0 g
s
.5977 .35743 m .60176 .37552 L .57459 .35684 L p .456 .62 .921 r
F P
0 g
s
.72737 .58758 m .71586 .59771 L .72966 .59805 L p .73 .988 .882 r
F P
0 g
s
.72966 .59805 m .73992 .58732 L .72737 .58758 L p .73 .988 .882 r
F P
0 g
s
.78091 .52782 m .77341 .54126 L .76884 .5323 L p .064 .064 .546 r
F P
0 g
s
.76884 .5323 m .77518 .51833 L .78091 .52782 L p .064 .064 .546 r
F P
0 g
s
.58197 .63227 m .56679 .63838 L .60333 .65012 L p .664 .897 .979 r
F P
0 g
s
.60333 .65012 m .61698 .64327 L .58197 .63227 L p .664 .897 .979 r
F P
0 g
s
.76016 .5647 m .75008 .57621 L .75634 .57273 L p .655 .897 .561 r
F P
0 g
s
.75634 .57273 m .76522 .56065 L .76016 .5647 L p .655 .897 .561 r
F P
0 g
s
.57459 .35684 m .56943 .33853 L .5977 .35743 L p .456 .62 .921 r
F P
0 g
s
.56943 .33853 m .57459 .35684 L .54698 .33836 L p .458 .627 .925 r
F P
0 g
s
.7814 .50393 m .77518 .51833 L .76587 .50704 L p .246 .311 .734 r
F P
0 g
s
.76587 .50704 m .77093 .49213 L .7814 .50393 L p .246 .311 .734 r
F P
0 g
s
.68333 .60345 m .67029 .61217 L .69256 .61681 L p .703 .949 .956 r
F P
0 g
s
.69256 .61681 m .70426 .60745 L .68333 .60345 L p .703 .949 .956 r
F P
0 g
s
.597 .62579 m .58197 .63227 L .61698 .64327 L p .668 .901 .978 r
F P
0 g
s
.61698 .64327 m .63049 .63606 L .597 .62579 L p .668 .901 .978 r
F P
0 g
s
.72296 .43129 m .72155 .44807 L .70014 .43114 L p .422 .557 .886 r
F P
0 g
s
.70014 .43114 m .70038 .41394 L .72296 .43129 L p .422 .557 .886 r
F P
0 g
s
.70038 .41394 m .70014 .43114 L .67675 .41342 L p .435 .578 .897 r
F P
0 g
s
.54698 .33836 m .54074 .31988 L .56943 .33853 L p .458 .627 .925 r
F P
0 g
s
.54074 .31988 m .54698 .33836 L .51928 .32031 L p .46 .633 .929 r
F P
0 g
s
.74326 .44768 m .74069 .464 L .72155 .44807 L p .403 .53 .871 r
F P
0 g
s
.72155 .44807 m .72296 .43129 L .74326 .44768 L p .403 .53 .871 r
F P
0 g
s
.67675 .41342 m .67583 .39582 L .70038 .41394 L p .435 .578 .897 r
F P
0 g
s
.67583 .39582 m .67675 .41342 L .65168 .39509 L p .445 .594 .906 r
F P
0 g
s
.73879 .57707 m .72737 .58758 L .73992 .58732 L p .73 .991 .856 r
F P
0 g
s
.73992 .58732 m .75008 .57621 L .73879 .57707 L p .73 .991 .856 r
F P
0 g
s
.65168 .39509 m .64959 .37713 L .67583 .39582 L p .445 .594 .906 r
F P
0 g
s
.64959 .37713 m .65168 .39509 L .62523 .37635 L p .452 .606 .912 r
F P
0 g
s
.761 .46291 m .75725 .47875 L .74069 .464 L p .376 .492 .849 r
F P
0 g
s
.74069 .464 m .74326 .44768 L .761 .46291 L p .376 .492 .849 r
F P
0 g
s
.78268 .53529 m .774 .54817 L .77341 .54126 L p 0 0 .211 r
F P
0 g
s
.77341 .54126 m .78091 .52782 L .78268 .53529 L p 0 0 .211 r
F P
0 g
s
.51928 .32031 m .51198 .30174 L .54074 .31988 L p .46 .633 .929 r
F P
0 g
s
.62523 .37635 m .62199 .35808 L .64959 .37713 L p .452 .606 .912 r
F P
0 g
s
.62199 .35808 m .62523 .37635 L .5977 .35743 L p .458 .617 .918 r
F P
0 g
s
.61189 .61892 m .597 .62579 L .63049 .63606 L p .672 .906 .977 r
F P
0 g
s
.63049 .63606 m .64388 .62847 L .61189 .61892 L p .672 .906 .977 r
F P
0 g
s
.77015 .5528 m .76016 .5647 L .76522 .56065 L p .606 .834 .451 r
F P
0 g
s
.76522 .56065 m .774 .54817 L .77015 .5528 L p .606 .834 .451 r
F P
0 g
s
.78831 .51396 m .78091 .52782 L .77518 .51833 L p .118 .136 .603 r
F P
0 g
s
.77518 .51833 m .7814 .50393 L .78831 .51396 L p .118 .136 .603 r
F P
0 g
s
.69627 .59435 m .68333 .60345 L .70426 .60745 L p .708 .956 .95 r
F P
0 g
s
.70426 .60745 m .71586 .59771 L .69627 .59435 L p .708 .956 .95 r
F P
0 g
s
.77585 .47679 m .77093 .49213 L .75725 .47875 L p .337 .436 .815 r
F P
0 g
s
.75725 .47875 m .761 .46291 L .77585 .47679 L p .337 .436 .815 r
F P
0 g
s
.5977 .35743 m .59332 .33889 L .62199 .35808 L p .458 .617 .918 r
F P
0 g
s
.59332 .33889 m .5977 .35743 L .56943 .33853 L p .461 .625 .923 r
F P
0 g
s
.7875 .48911 m .7814 .50393 L .77093 .49213 L p .273 .348 .758 r
F P
0 g
s
.77093 .49213 m .77585 .47679 L .7875 .48911 L p .273 .348 .758 r
F P
0 g
s
.62663 .61166 m .61189 .61892 L .64388 .62847 L p .676 .911 .976 r
F P
0 g
s
.64388 .62847 m .65714 .62051 L .62663 .61166 L p .676 .911 .976 r
F P
0 g
s
.75013 .56616 m .73879 .57707 L .75008 .57621 L p .728 .989 .823 r
F P
0 g
s
.75008 .57621 m .76016 .5647 L .75013 .56616 L p .728 .989 .823 r
F P
0 g
s
.56943 .33853 m .56391 .31978 L .59332 .33889 L p .461 .625 .923 r
F P
0 g
s
.56391 .31978 m .56943 .33853 L .54074 .31988 L p .464 .632 .927 r
F P
0 g
s
.70911 .58486 m .69627 .59435 L .71586 .59771 L p .713 .963 .942 r
F P
0 g
s
.71586 .59771 m .72737 .58758 L .70911 .58486 L p .713 .963 .942 r
F P
0 g
s
.72416 .41406 m .72296 .43129 L .70038 .41394 L p .429 .567 .89 r
F P
0 g
s
.70038 .41394 m .70039 .39628 L .72416 .41406 L p .429 .567 .89 r
F P
0 g
s
.70039 .39628 m .70038 .41394 L .67583 .39582 L p .442 .586 .9 r
F P
0 g
s
.74565 .4309 m .74326 .44768 L .72296 .43129 L p .412 .541 .876 r
F P
0 g
s
.72296 .43129 m .72416 .41406 L .74565 .4309 L p .412 .541 .876 r
F P
0 g
s
.79128 .52199 m .78268 .53529 L .78091 .52782 L p 0 0 .326 r
F P
0 g
s
.78091 .52782 m .78831 .51396 L .79128 .52199 L p 0 0 .326 r
F P
0 g
s
.67583 .39582 m .67464 .37777 L .70039 .39628 L p .442 .586 .9 r
F P
0 g
s
.67464 .37777 m .67583 .39582 L .64959 .37713 L p .451 .601 .908 r
F P
0 g
s
.54074 .31988 m .53412 .30098 L .56391 .31978 L p .464 .632 .927 r
F P
0 g
s
.53412 .30098 m .54074 .31988 L .51198 .30174 L p .466 .639 .931 r
F P
0 g
s
.774 .54817 m .78268 .53529 L .78006 .54049 L p 0 0 0 r
F P
0 g
s
.78006 .54049 m .77015 .5528 L .774 .54817 L p 0 0 0 r
F P
0 g
s
.76458 .44662 m .761 .46291 L .74326 .44768 L p .388 .507 .857 r
F P
0 g
s
.74326 .44768 m .74565 .4309 L .76458 .44662 L p .388 .507 .857 r
F P
0 g
s
.64124 .60402 m .62663 .61166 L .65714 .62051 L p .68 .916 .974 r
F P
0 g
s
.65714 .62051 m .67029 .61217 L .64124 .60402 L p .68 .916 .974 r
F P
0 g
s
.64959 .37713 m .64722 .35872 L .67464 .37777 L p .451 .601 .908 r
F P
0 g
s
.64722 .35872 m .64959 .37713 L .62199 .35808 L p .458 .612 .915 r
F P
0 g
s
.7956 .49968 m .78831 .51396 L .7814 .50393 L p .165 .198 .65 r
F P
0 g
s
.7814 .50393 m .7875 .48911 L .7956 .49968 L p .165 .198 .65 r
F P
0 g
s
.78062 .461 m .77585 .47679 L .761 .46291 L p .353 .457 .827 r
F P
0 g
s
.761 .46291 m .76458 .44662 L .78062 .461 L p .353 .457 .827 r
F P
0 g
s
.51198 .30174 m .50429 .28275 L .53412 .30098 L p .466 .639 .931 r
F P
0 g
s
.62199 .35808 m .61843 .33936 L .64722 .35872 L p .458 .612 .915 r
F P
0 g
s
.61843 .33936 m .62199 .35808 L .59332 .33889 L p .463 .622 .92 r
F P
0 g
s
.76138 .55487 m .75013 .56616 L .76016 .5647 L p .721 .982 .779 r
F P
0 g
s
.76016 .5647 m .77015 .5528 L .76138 .55487 L p .721 .982 .779 r
F P
0 g
s
.50458 .62716 m .48727 .63165 L .53591 .64944 L p .646 .873 .983 r
F P
0 g
s
.53591 .64944 m .55144 .6441 L .50458 .62716 L p .646 .873 .983 r
F P
0 g
s
.72185 .57499 m .70911 .58486 L .72737 .58758 L p .718 .97 .932 r
F P
0 g
s
.72737 .58758 m .73879 .57707 L .72185 .57499 L p .718 .97 .932 r
F P
0 g
s
.65574 .596 m .64124 .60402 L .67029 .61217 L p .684 .922 .972 r
F P
0 g
s
.67029 .61217 m .68333 .60345 L .65574 .596 L p .684 .922 .972 r
F P
0 g
s
.59332 .33889 m .5886 .31991 L .61843 .33936 L p .463 .622 .92 r
F P
0 g
s
.5886 .31991 m .59332 .33889 L .56391 .31978 L p .467 .63 .925 r
F P
0 g
s
.79347 .47386 m .7875 .48911 L .77585 .47679 L p .298 .38 .778 r
F P
0 g
s
.77585 .47679 m .78062 .461 L .79347 .47386 L p .298 .38 .778 r
F P
0 g
s
.52168 .62228 m .50458 .62716 L .55144 .6441 L p .649 .876 .983 r
F P
0 g
s
.55144 .6441 m .56679 .63838 L .52168 .62228 L p .649 .876 .983 r
F P
0 g
s
.79978 .50828 m .79128 .52199 L .78831 .51396 L p 0 0 .423 r
F P
0 g
s
.78831 .51396 m .7956 .49968 L .79978 .50828 L p 0 0 .423 r
F P
0 g
s
.78988 .52778 m .78006 .54049 L .78268 .53529 L p 0 0 0 r
F P
0 g
s
.78268 .53529 m .79128 .52199 L .78988 .52778 L p 0 0 0 r
F P
0 g
s
.56391 .31978 m .55804 .30058 L .5886 .31991 L p .467 .63 .925 r
F P
0 g
s
.55804 .30058 m .56391 .31978 L .53412 .30098 L p .47 .637 .929 r
F P
0 g
s
.53858 .61699 m .52168 .62228 L .56679 .63838 L p .652 .879 .982 r
F P
0 g
s
.56679 .63838 m .58197 .63227 L .53858 .61699 L p .652 .879 .982 r
F P
0 g
s
.74785 .41367 m .74565 .4309 L .72416 .41406 L p .421 .552 .882 r
F P
0 g
s
.72416 .41406 m .72514 .39637 L .74785 .41367 L p .421 .552 .882 r
F P
0 g
s
.72514 .39637 m .72416 .41406 L .70039 .39628 L p .437 .575 .894 r
F P
0 g
s
.70039 .39628 m .70015 .37816 L .72514 .39637 L p .437 .575 .894 r
F P
0 g
s
.70015 .37816 m .70039 .39628 L .67464 .37777 L p .448 .593 .904 r
F P
0 g
s
.67011 .58759 m .65574 .596 L .68333 .60345 L p .688 .927 .969 r
F P
0 g
s
.68333 .60345 m .69627 .59435 L .67011 .58759 L p .688 .927 .969 r
F P
0 g
s
.80279 .48498 m .7956 .49968 L .7875 .48911 L p .204 .251 .689 r
F P
0 g
s
.7875 .48911 m .79347 .47386 L .80279 .48498 L p .204 .251 .689 r
F P
0 g
s
.76799 .42987 m .76458 .44662 L .74565 .4309 L p .399 .52 .864 r
F P
0 g
s
.74565 .4309 m .74785 .41367 L .76799 .42987 L p .399 .52 .864 r
F P
0 g
s
.67464 .37777 m .67319 .35925 L .70015 .37816 L p .448 .593 .904 r
F P
0 g
s
.67319 .35925 m .67464 .37777 L .64722 .35872 L p .457 .607 .911 r
F P
0 g
s
.73451 .56473 m .72185 .57499 L .73879 .57707 L p .722 .977 .92 r
F P
0 g
s
.73879 .57707 m .75013 .56616 L .73451 .56473 L p .722 .977 .92 r
F P
0 g
s
.77255 .54317 m .76138 .55487 L .77015 .5528 L p .708 .967 .723 r
F P
0 g
s
.77015 .5528 m .78006 .54049 L .77255 .54317 L p .708 .967 .723 r
F P
0 g
s
.53412 .30098 m .52711 .28164 L .55804 .30058 L p .47 .637 .929 r
F P
0 g
s
.52711 .28164 m .53412 .30098 L .50429 .28275 L p .472 .644 .932 r
F P
0 g
s
.5553 .61131 m .53858 .61699 L .58197 .63227 L p .655 .883 .982 r
F P
0 g
s
.58197 .63227 m .597 .62579 L .5553 .61131 L p .655 .883 .982 r
F P
0 g
s
.64722 .35872 m .64456 .33985 L .67319 .35925 L p .457 .607 .911 r
F P
0 g
s
.64456 .33985 m .64722 .35872 L .61843 .33936 L p .463 .618 .917 r
F P
0 g
s
.78525 .44477 m .78062 .461 L .76458 .44662 L p .368 .475 .838 r
F P
0 g
s
.76458 .44662 m .76799 .42987 L .78525 .44477 L p .368 .475 .838 r
F P
0 g
s
.61843 .33936 m .61456 .32018 L .64456 .33985 L p .463 .618 .917 r
F P
0 g
s
.61456 .32018 m .61843 .33936 L .5886 .31991 L p .468 .627 .922 r
F P
0 g
s
.50429 .28275 m .49618 .26334 L .52711 .28164 L p .472 .644 .932 r
F P
0 g
s
.57184 .60523 m .5553 .61131 L .597 .62579 L p .658 .887 .981 r
F P
0 g
s
.597 .62579 m .61189 .61892 L .57184 .60523 L p .658 .887 .981 r
F P
0 g
s
.79932 .45816 m .79347 .47386 L .78062 .461 L p .319 .407 .796 r
F P
0 g
s
.78062 .461 m .78525 .44477 L .79932 .45816 L p .319 .407 .796 r
F P
0 g
s
.68438 .57879 m .67011 .58759 L .69627 .59435 L p .693 .934 .966 r
F P
0 g
s
.69627 .59435 m .70911 .58486 L .68438 .57879 L p .693 .934 .966 r
F P
0 g
s
.79963 .51465 m .78988 .52778 L .79128 .52199 L p 0 0 0 r
F P
0 g
s
.79128 .52199 m .79978 .50828 L .79963 .51465 L p 0 0 0 r
F P
0 g
s
.80819 .49414 m .79978 .50828 L .7956 .49968 L p .034 .017 .503 r
F P
0 g
s
.7956 .49968 m .80279 .48498 L .80819 .49414 L p .034 .017 .503 r
F P
0 g
s
.5886 .31991 m .58353 .30047 L .61456 .32018 L p .468 .627 .922 r
F P
0 g
s
.58353 .30047 m .5886 .31991 L .55804 .30058 L p .472 .635 .926 r
F P
0 g
s
.74709 .55406 m .73451 .56473 L .75013 .56616 L p .726 .983 .905 r
F P
0 g
s
.75013 .56616 m .76138 .55487 L .74709 .55406 L p .726 .983 .905 r
F P
0 g
s
.78364 .53106 m .77255 .54317 L .78006 .54049 L p .684 .939 .65 r
F P
0 g
s
.78006 .54049 m .78988 .52778 L .78364 .53106 L p .684 .939 .65 r
F P
0 g
s
.58822 .59875 m .57184 .60523 L .61189 .61892 L p .661 .891 .98 r
F P
0 g
s
.61189 .61892 m .62663 .61166 L .58822 .59875 L p .661 .891 .98 r
F P
0 g
s
.55804 .30058 m .55179 .28095 L .58353 .30047 L p .472 .635 .926 r
F P
0 g
s
.55179 .28095 m .55804 .30058 L .52711 .28164 L p .475 .642 .93 r
F P
0 g
s
.80986 .46983 m .80279 .48498 L .79347 .47386 L p .239 .296 .721 r
F P
0 g
s
.79347 .47386 m .79932 .45816 L .80986 .46983 L p .239 .296 .721 r
F P
0 g
s
.74985 .39598 m .74785 .41367 L .72514 .39637 L p .429 .562 .886 r
F P
0 g
s
.72514 .39637 m .7259 .37821 L .74985 .39598 L p .429 .562 .886 r
F P
0 g
s
.7259 .37821 m .72514 .39637 L .70015 .37816 L p .443 .583 .898 r
F P
0 g
s
.70015 .37816 m .69967 .35957 L .7259 .37821 L p .443 .583 .898 r
F P
0 g
s
.69967 .35957 m .70015 .37816 L .67319 .35925 L p .454 .6 .906 r
F P
0 g
s
.77123 .41267 m .76799 .42987 L .74785 .41367 L p .409 .533 .871 r
F P
0 g
s
.74785 .41367 m .74985 .39598 L .77123 .41267 L p .409 .533 .871 r
F P
0 g
s
.69855 .5696 m .68438 .57879 L .70911 .58486 L p .697 .94 .962 r
F P
0 g
s
.70911 .58486 m .72185 .57499 L .69855 .5696 L p .697 .94 .962 r
F P
0 g
s
.67319 .35925 m .67146 .34026 L .69967 .35957 L p .454 .6 .906 r
F P
0 g
s
.67146 .34026 m .67319 .35925 L .64456 .33985 L p .462 .613 .913 r
F P
0 g
s
.60445 .59188 m .58822 .59875 L .62663 .61166 L p .664 .895 .979 r
F P
0 g
s
.62663 .61166 m .64124 .60402 L .60445 .59188 L p .664 .895 .979 r
F P
0 g
s
.78973 .42808 m .78525 .44477 L .76799 .42987 L p .381 .492 .847 r
F P
0 g
s
.76799 .42987 m .77123 .41267 L .78973 .42808 L p .381 .492 .847 r
F P
0 g
s
.52711 .28164 m .51971 .26187 L .55179 .28095 L p .475 .642 .93 r
F P
0 g
s
.51971 .26187 m .52711 .28164 L .49618 .26334 L p .477 .648 .934 r
F P
0 g
s
.64456 .33985 m .64158 .32051 L .67146 .34026 L p .462 .613 .913 r
F P
0 g
s
.64158 .32051 m .64456 .33985 L .61456 .32018 L p .468 .623 .919 r
F P
0 g
s
.75958 .543 m .74709 .55406 L .76138 .55487 L p .728 .988 .886 r
F P
0 g
s
.76138 .55487 m .77255 .54317 L .75958 .543 L p .728 .988 .886 r
F P
0 g
s
.80928 .50111 m .79963 .51465 L .79978 .50828 L p 0 0 .11 r
F P
0 g
s
.79978 .50828 m .80819 .49414 L .80928 .50111 L p 0 0 .11 r
F P
0 g
s
.80504 .44201 m .79932 .45816 L .78525 .44477 L p .338 .432 .811 r
F P
0 g
s
.78525 .44477 m .78973 .42808 L .80504 .44201 L p .338 .432 .811 r
F P
0 g
s
.81651 .47957 m .80819 .49414 L .80279 .48498 L p .094 .097 .569 r
F P
0 g
s
.80279 .48498 m .80986 .46983 L .81651 .47957 L p .094 .097 .569 r
F P
0 g
s
.61456 .32018 m .61035 .30053 L .64158 .32051 L p .468 .623 .919 r
F P
0 g
s
.61035 .30053 m .61456 .32018 L .58353 .30047 L p .473 .632 .924 r
F P
0 g
s
.49618 .26334 m .48765 .2435 L .51971 .26187 L p .477 .648 .934 r
F P
0 g
s
.79466 .51855 m .78364 .53106 L .78988 .52778 L p .648 .894 .558 r
F P
0 g
s
.78988 .52778 m .79963 .51465 L .79466 .51855 L p .648 .894 .558 r
F P
0 g
s
.62053 .58462 m .60445 .59188 L .64124 .60402 L p .668 .899 .978 r
F P
0 g
s
.64124 .60402 m .65574 .596 L .62053 .58462 L p .668 .899 .978 r
F P
0 g
s
.71262 .56001 m .69855 .5696 L .72185 .57499 L p .702 .947 .957 r
F P
0 g
s
.72185 .57499 m .73451 .56473 L .71262 .56001 L p .702 .947 .957 r
F P
0 g
s
.58353 .30047 m .57809 .28056 L .61035 .30053 L p .473 .632 .924 r
F P
0 g
s
.57809 .28056 m .58353 .30047 L .55179 .28095 L p .477 .64 .928 r
F P
0 g
s
.81682 .45424 m .80986 .46983 L .79932 .45816 L p .268 .335 .748 r
F P
0 g
s
.79932 .45816 m .80504 .44201 L .81682 .45424 L p .268 .335 .748 r
F P
0 g
s
.772 .53154 m .75958 .543 L .77255 .54317 L p .729 .99 .86 r
F P
0 g
s
.77255 .54317 m .78364 .53106 L .772 .53154 L p .729 .99 .86 r
F P
0 g
s
.63648 .57696 m .62053 .58462 L .65574 .596 L p .671 .904 .977 r
F P
0 g
s
.65574 .596 m .67011 .58759 L .63648 .57696 L p .671 .904 .977 r
F P
0 g
s
.55179 .28095 m .54515 .26085 L .57809 .28056 L p .477 .64 .928 r
F P
0 g
s
.54515 .26085 m .55179 .28095 L .51971 .26187 L p .48 .647 .931 r
F P
0 g
s
.75164 .37781 m .74985 .39598 L .7259 .37821 L p .436 .571 .89 r
F P
0 g
s
.7259 .37821 m .72642 .35957 L .75164 .37781 L p .436 .571 .89 r
F P
0 g
s
.72642 .35957 m .7259 .37821 L .69967 .35957 L p .45 .59 .901 r
F P
0 g
s
.77429 .395 m .77123 .41267 L .74985 .39598 L p .418 .544 .876 r
F P
0 g
s
.74985 .39598 m .75164 .37781 L .77429 .395 L p .418 .544 .876 r
F P
0 g
s
.69967 .35957 m .69892 .3405 L .72642 .35957 L p .45 .59 .901 r
F P
0 g
s
.69892 .3405 m .69967 .35957 L .67146 .34026 L p .46 .606 .909 r
F P
0 g
s
.44749 .60506 m .42814 .60858 L .48727 .63165 L p .637 .86 .984 r
F P
0 g
s
.48727 .63165 m .50458 .62716 L .44749 .60506 L p .637 .86 .984 r
F P
0 g
s
.7266 .55003 m .71262 .56001 L .73451 .56473 L p .707 .954 .952 r
F P
0 g
s
.73451 .56473 m .74709 .55406 L .7266 .55003 L p .707 .954 .952 r
F P
0 g
s
.79405 .41093 m .78973 .42808 L .77123 .41267 L p .393 .508 .856 r
F P
0 g
s
.77123 .41267 m .77429 .395 L .79405 .41093 L p .393 .508 .856 r
F P
0 g
s
.67146 .34026 m .66944 .32079 L .69892 .3405 L p .46 .606 .909 r
F P
0 g
s
.66944 .32079 m .67146 .34026 L .64158 .32051 L p .467 .618 .915 r
F P
0 g
s
.81886 .48713 m .80928 .50111 L .80819 .49414 L p 0 0 .24 r
F P
0 g
s
.80819 .49414 m .81651 .47957 L .81886 .48713 L p 0 0 .24 r
F P
0 g
s
.8056 .50562 m .79466 .51855 L .79963 .51465 L p .596 .828 .444 r
F P
0 g
s
.79963 .51465 m .80928 .50111 L .8056 .50562 L p .596 .828 .444 r
F P
0 g
s
.51971 .26187 m .51189 .24166 L .54515 .26085 L p .48 .647 .931 r
F P
0 g
s
.51189 .24166 m .51971 .26187 L .48765 .2435 L p .482 .653 .935 r
F P
0 g
s
.46659 .60111 m .44749 .60506 L .50458 .62716 L p .639 .863 .984 r
F P
0 g
s
.50458 .62716 m .52168 .62228 L .46659 .60111 L p .639 .863 .984 r
F P
0 g
s
.82473 .46456 m .81651 .47957 L .80986 .46983 L p .145 .166 .623 r
F P
0 g
s
.80986 .46983 m .81682 .45424 L .82473 .46456 L p .145 .166 .623 r
F P
0 g
s
.64158 .32051 m .63829 .30069 L .66944 .32079 L p .467 .618 .915 r
F P
0 g
s
.63829 .30069 m .64158 .32051 L .61035 .30053 L p .473 .629 .921 r
F P
0 g
s
.81062 .4254 m .80504 .44201 L .78973 .42808 L p .355 .454 .824 r
F P
0 g
s
.78973 .42808 m .79405 .41093 L .81062 .4254 L p .355 .454 .824 r
F P
0 g
s
.6523 .5689 m .63648 .57696 L .67011 .58759 L p .675 .909 .976 r
F P
0 g
s
.67011 .58759 m .68438 .57879 L .6523 .5689 L p .675 .909 .976 r
F P
0 g
s
.48544 .59675 m .46659 .60111 L .52168 .62228 L p .641 .865 .983 r
F P
0 g
s
.52168 .62228 m .53858 .61699 L .48544 .59675 L p .641 .865 .983 r
F P
0 g
s
.61035 .30053 m .6058 .28041 L .63829 .30069 L p .473 .629 .921 r
F P
0 g
s
.6058 .28041 m .61035 .30053 L .57809 .28056 L p .478 .637 .925 r
F P
0 g
s
.48765 .2435 m .47869 .22324 L .51189 .24166 L p .482 .653 .935 r
F P
0 g
s
.78434 .51967 m .772 .53154 L .78364 .53106 L p .726 .989 .827 r
F P
0 g
s
.78364 .53106 m .79466 .51855 L .78434 .51967 L p .726 .989 .827 r
F P
0 g
s
.50406 .59197 m .48544 .59675 L .53858 .61699 L p .644 .868 .983 r
F P
0 g
s
.53858 .61699 m .5553 .61131 L .50406 .59197 L p .644 .868 .983 r
F P
0 g
s
.82367 .4382 m .81682 .45424 L .80504 .44201 L p .294 .369 .77 r
F P
0 g
s
.80504 .44201 m .81062 .4254 L .82367 .4382 L p .294 .369 .77 r
F P
0 g
s
.74049 .53965 m .7266 .55003 L .74709 .55406 L p .711 .961 .944 r
F P
0 g
s
.74709 .55406 m .75958 .543 L .74049 .53965 L p .711 .961 .944 r
F P
0 g
s
.57809 .28056 m .57229 .2602 L .6058 .28041 L p .478 .637 .925 r
F P
0 g
s
.57229 .2602 m .57809 .28056 L .54515 .26085 L p .482 .645 .929 r
F P
0 g
s
.668 .56045 m .6523 .5689 L .68438 .57879 L p .679 .914 .974 r
F P
0 g
s
.68438 .57879 m .69855 .5696 L .668 .56045 L p .679 .914 .974 r
F P
0 g
s
.52247 .58677 m .50406 .59197 L .5553 .61131 L p .647 .871 .983 r
F P
0 g
s
.5553 .61131 m .57184 .60523 L .52247 .58677 L p .647 .871 .983 r
F P
0 g
s
.82835 .47273 m .81886 .48713 L .81651 .47957 L p 0 0 .352 r
F P
0 g
s
.81651 .47957 m .82473 .46456 L .82835 .47273 L p 0 0 .352 r
F P
0 g
s
.80928 .50111 m .81886 .48713 L .81647 .49227 L p 0 0 0 r
F P
0 g
s
.81647 .49227 m .8056 .50562 L .80928 .50111 L p 0 0 0 r
F P
0 g
s
.75323 .35916 m .75164 .37781 L .72642 .35957 L p .443 .579 .894 r
F P
0 g
s
.72642 .35957 m .72671 .34045 L .75323 .35916 L p .443 .579 .894 r
F P
0 g
s
.72671 .34045 m .72642 .35957 L .69892 .3405 L p .456 .597 .904 r
F P
0 g
s
.77716 .37685 m .77429 .395 L .75164 .37781 L p .427 .555 .881 r
F P
0 g
s
.75164 .37781 m .75323 .35916 L .77716 .37685 L p .427 .555 .881 r
F P
0 g
s
.54515 .26085 m .53811 .2403 L .57229 .2602 L p .482 .645 .929 r
F P
0 g
s
.53811 .2403 m .54515 .26085 L .51189 .24166 L p .485 .651 .933 r
F P
0 g
s
.69892 .3405 m .6979 .32094 L .72671 .34045 L p .456 .597 .904 r
F P
0 g
s
.6979 .32094 m .69892 .3405 L .66944 .32079 L p .465 .612 .911 r
F P
0 g
s
.79821 .39331 m .79405 .41093 L .77429 .395 L p .404 .521 .863 r
F P
0 g
s
.77429 .395 m .77716 .37685 L .79821 .39331 L p .404 .521 .863 r
F P
0 g
s
.54068 .58117 m .52247 .58677 L .57184 .60523 L p .649 .874 .982 r
F P
0 g
s
.57184 .60523 m .58822 .59875 L .54068 .58117 L p .649 .874 .982 r
F P
0 g
s
.83285 .44911 m .82473 .46456 L .81682 .45424 L p .189 .224 .667 r
F P
0 g
s
.81682 .45424 m .82367 .4382 L .83285 .44911 L p .189 .224 .667 r
F P
0 g
s
.66944 .32079 m .66712 .30084 L .6979 .32094 L p .465 .612 .911 r
F P
0 g
s
.66712 .30084 m .66944 .32079 L .63829 .30069 L p .472 .624 .917 r
F P
0 g
s
.79661 .50738 m .78434 .51967 L .79466 .51855 L p .719 .982 .784 r
F P
0 g
s
.79466 .51855 m .8056 .50562 L .79661 .50738 L p .719 .982 .784 r
F P
0 g
s
.7543 .52886 m .74049 .53965 L .75958 .543 L p .716 .968 .935 r
F P
0 g
s
.75958 .543 m .772 .53154 L .7543 .52886 L p .716 .968 .935 r
F P
0 g
s
.81607 .40833 m .81062 .4254 L .79405 .41093 L p .37 .473 .835 r
F P
0 g
s
.79405 .41093 m .79821 .39331 L .81607 .40833 L p .37 .473 .835 r
F P
0 g
s
.6836 .5516 m .668 .56045 L .69855 .5696 L p .683 .919 .972 r
F P
0 g
s
.69855 .5696 m .71262 .56001 L .6836 .5516 L p .683 .919 .972 r
F P
0 g
s
.51189 .24166 m .50364 .221 L .53811 .2403 L p .485 .651 .933 r
F P
0 g
s
.50364 .221 m .51189 .24166 L .47869 .22324 L p .487 .657 .936 r
F P
0 g
s
.63829 .30069 m .63467 .28038 L .66712 .30084 L p .472 .624 .917 r
F P
0 g
s
.63467 .28038 m .63829 .30069 L .6058 .28041 L p .478 .633 .922 r
F P
0 g
s
.5587 .57515 m .54068 .58117 L .58822 .59875 L p .652 .878 .982 r
F P
0 g
s
.58822 .59875 m .60445 .59188 L .5587 .57515 L p .652 .878 .982 r
F P
0 g
s
.6058 .28041 m .60088 .2598 L .63467 .28038 L p .478 .633 .922 r
F P
0 g
s
.60088 .2598 m .6058 .28041 L .57229 .2602 L p .482 .642 .927 r
F P
0 g
s
.8304 .4217 m .82367 .4382 L .81062 .4254 L p .317 .399 .789 r
F P
0 g
s
.81062 .4254 m .81607 .40833 L .8304 .4217 L p .317 .399 .789 r
F P
0 g
s
.47869 .22324 m .46927 .20256 L .50364 .221 L p .487 .657 .936 r
F P
0 g
s
.82727 .47849 m .81647 .49227 L .81886 .48713 L p 0 0 0 r
F P
0 g
s
.81886 .48713 m .82835 .47273 L .82727 .47849 L p 0 0 0 r
F P
0 g
s
.57655 .56873 m .5587 .57515 L .60445 .59188 L p .655 .881 .982 r
F P
0 g
s
.60445 .59188 m .62053 .58462 L .57655 .56873 L p .655 .881 .982 r
F P
0 g
s
.83777 .45788 m .82835 .47273 L .82473 .46456 L p 0 0 .447 r
F P
0 g
s
.82473 .46456 m .83285 .44911 L .83777 .45788 L p 0 0 .447 r
F P
0 g
s
.69909 .54234 m .6836 .5516 L .71262 .56001 L p .687 .925 .97 r
F P
0 g
s
.71262 .56001 m .7266 .55003 L .69909 .54234 L p .687 .925 .97 r
F P
0 g
s
.57229 .2602 m .56609 .23935 L .60088 .2598 L p .482 .642 .927 r
F P
0 g
s
.56609 .23935 m .57229 .2602 L .53811 .2403 L p .486 .649 .93 r
F P
0 g
s
.76804 .51766 m .7543 .52886 L .772 .53154 L p .72 .975 .924 r
F P
0 g
s
.772 .53154 m .78434 .51967 L .76804 .51766 L p .72 .975 .924 r
F P
0 g
s
.80882 .49468 m .79661 .50738 L .8056 .50562 L p .705 .967 .728 r
F P
0 g
s
.8056 .50562 m .81647 .49227 L .80882 .49468 L p .705 .967 .728 r
F P
0 g
s
.77984 .35821 m .77716 .37685 L .75323 .35916 L p .435 .564 .886 r
F P
0 g
s
.75323 .35916 m .75458 .34001 L .77984 .35821 L p .435 .564 .886 r
F P
0 g
s
.75458 .34001 m .75323 .35916 L .72671 .34045 L p .45 .587 .898 r
F P
0 g
s
.72671 .34045 m .72674 .32083 L .75458 .34001 L p .45 .587 .898 r
F P
0 g
s
.72674 .32083 m .72671 .34045 L .6979 .32094 L p .461 .604 .907 r
F P
0 g
s
.84087 .4332 m .83285 .44911 L .82367 .4382 L p .227 .275 .704 r
F P
0 g
s
.82367 .4382 m .8304 .4217 L .84087 .4332 L p .227 .275 .704 r
F P
0 g
s
.80221 .3752 m .79821 .39331 L .77716 .37685 L p .414 .534 .869 r
F P
0 g
s
.77716 .37685 m .77984 .35821 L .80221 .3752 L p .414 .534 .869 r
F P
0 g
s
.59424 .56189 m .57655 .56873 L .62053 .58462 L p .658 .885 .981 r
F P
0 g
s
.62053 .58462 m .63648 .57696 L .59424 .56189 L p .658 .885 .981 r
F P
0 g
s
.6979 .32094 m .69661 .30088 L .72674 .32083 L p .461 .604 .907 r
F P
0 g
s
.69661 .30088 m .6979 .32094 L .66712 .30084 L p .47 .618 .914 r
F P
0 g
s
.53811 .2403 m .53066 .21929 L .56609 .23935 L p .486 .649 .93 r
F P
0 g
s
.53066 .21929 m .53811 .2403 L .50364 .221 L p .489 .656 .934 r
F P
0 g
s
.82137 .39078 m .81607 .40833 L .79821 .39331 L p .383 .491 .845 r
F P
0 g
s
.79821 .39331 m .80221 .3752 L .82137 .39078 L p .383 .491 .845 r
F P
0 g
s
.66712 .30084 m .66449 .28039 L .69661 .30088 L p .47 .618 .914 r
F P
0 g
s
.66449 .28039 m .66712 .30084 L .63467 .28038 L p .477 .629 .919 r
F P
0 g
s
.71448 .53268 m .69909 .54234 L .7266 .55003 L p .691 .931 .967 r
F P
0 g
s
.7266 .55003 m .74049 .53965 L .71448 .53268 L p .691 .931 .967 r
F P
0 g
s
.50364 .221 m .49495 .19989 L .53066 .21929 L p .489 .656 .934 r
F P
0 g
s
.49495 .19989 m .50364 .221 L .46927 .20256 L p .492 .662 .937 r
F P
0 g
s
.63467 .28038 m .63071 .25958 L .66449 .28039 L p .477 .629 .919 r
F P
0 g
s
.63071 .25958 m .63467 .28038 L .60088 .2598 L p .482 .638 .924 r
F P
0 g
s
.61178 .55465 m .59424 .56189 L .63648 .57696 L p .661 .888 .98 r
F P
0 g
s
.63648 .57696 m .6523 .5689 L .61178 .55465 L p .661 .888 .98 r
F P
0 g
s
.83799 .46427 m .82727 .47849 L .82835 .47273 L p 0 0 0 r
F P
0 g
s
.82835 .47273 m .83777 .45788 L .83799 .46427 L p 0 0 0 r
F P
0 g
s
.83701 .40474 m .8304 .4217 L .81607 .40833 L p .337 .425 .805 r
F P
0 g
s
.81607 .40833 m .82137 .39078 L .83701 .40474 L p .337 .425 .805 r
F P
0 g
s
.78171 .50606 m .76804 .51766 L .78434 .51967 L p .723 .981 .909 r
F P
0 g
s
.78434 .51967 m .79661 .50738 L .78171 .50606 L p .723 .981 .909 r
F P
0 g
s
.84709 .44259 m .83777 .45788 L .83285 .44911 L p .06 .045 .524 r
F P
0 g
s
.83285 .44911 m .84087 .4332 L .84709 .44259 L p .06 .045 .524 r
F P
0 g
s
.60088 .2598 m .5956 .23871 L .63071 .25958 L p .482 .638 .924 r
F P
0 g
s
.5956 .23871 m .60088 .2598 L .56609 .23935 L p .487 .646 .928 r
F P
0 g
s
.46927 .20256 m .45938 .18144 L .49495 .19989 L p .492 .662 .937 r
F P
0 g
s
.82096 .48155 m .80882 .49468 L .81647 .49227 L p .681 .939 .654 r
F P
0 g
s
.81647 .49227 m .82727 .47849 L .82096 .48155 L p .681 .939 .654 r
F P
0 g
s
.62917 .54701 m .61178 .55465 L .6523 .5689 L p .664 .892 .98 r
F P
0 g
s
.6523 .5689 m .668 .56045 L .62917 .54701 L p .664 .892 .98 r
F P
0 g
s
.72979 .52262 m .71448 .53268 L .74049 .53965 L p .695 .937 .964 r
F P
0 g
s
.74049 .53965 m .7543 .52886 L .72979 .52262 L p .695 .937 .964 r
F P
0 g
s
.84879 .41684 m .84087 .4332 L .8304 .4217 L p .26 .318 .734 r
F P
0 g
s
.8304 .4217 m .83701 .40474 L .84879 .41684 L p .26 .318 .734 r
F P
0 g
s
.56609 .23935 m .55949 .21803 L .5956 .23871 L p .487 .646 .928 r
F P
0 g
s
.55949 .21803 m .56609 .23935 L .53066 .21929 L p .49 .653 .932 r
F P
0 g
s
.78232 .33907 m .77984 .35821 L .75458 .34001 L p .442 .573 .89 r
F P
0 g
s
.75458 .34001 m .75571 .32037 L .78232 .33907 L p .442 .573 .89 r
F P
0 g
s
.75571 .32037 m .75458 .34001 L .72674 .32083 L p .456 .594 .901 r
F P
0 g
s
.72674 .32083 m .72651 .30071 L .75571 .32037 L p .456 .594 .901 r
F P
0 g
s
.72651 .30071 m .72674 .32083 L .69661 .30088 L p .467 .61 .909 r
F P
0 g
s
.80602 .35661 m .80221 .3752 L .77984 .35821 L p .423 .545 .875 r
F P
0 g
s
.77984 .35821 m .78232 .33907 L .80602 .35661 L p .423 .545 .875 r
F P
0 g
s
.37833 .57688 m .35661 .57929 L .42814 .60858 L p .629 .85 .984 r
F P
0 g
s
.42814 .60858 m .44749 .60506 L .37833 .57688 L p .629 .85 .984 r
F P
0 g
s
.69661 .30088 m .69502 .28032 L .72651 .30071 L p .467 .61 .909 r
F P
0 g
s
.69502 .28032 m .69661 .30088 L .66449 .28039 L p .475 .623 .916 r
F P
0 g
s
.39973 .57402 m .37833 .57688 L .44749 .60506 L p .631 .852 .984 r
F P
0 g
s
.44749 .60506 m .46659 .60111 L .39973 .57402 L p .631 .852 .984 r
F P
0 g
s
.79531 .49403 m .78171 .50606 L .79661 .50738 L p .726 .986 .891 r
F P
0 g
s
.79661 .50738 m .80882 .49468 L .79531 .49403 L p .726 .986 .891 r
F P
0 g
s
.53066 .21929 m .52277 .19781 L .55949 .21803 L p .49 .653 .932 r
F P
0 g
s
.52277 .19781 m .53066 .21929 L .49495 .19989 L p .494 .66 .935 r
F P
0 g
s
.82652 .37275 m .82137 .39078 L .80221 .3752 L p .395 .506 .853 r
F P
0 g
s
.80221 .3752 m .80602 .35661 L .82652 .37275 L p .395 .506 .853 r
F P
0 g
s
.64644 .53895 m .62917 .54701 L .668 .56045 L p .667 .897 .979 r
F P
0 g
s
.668 .56045 m .6836 .5516 L .64644 .53895 L p .667 .897 .979 r
F P
0 g
s
.42082 .57071 m .39973 .57402 L .46659 .60111 L p .633 .854 .984 r
F P
0 g
s
.46659 .60111 m .48544 .59675 L .42082 .57071 L p .633 .854 .984 r
F P
0 g
s
.66449 .28039 m .66154 .25943 L .69502 .28032 L p .475 .623 .916 r
F P
0 g
s
.66154 .25943 m .66449 .28039 L .63071 .25958 L p .481 .634 .921 r
F P
0 g
s
.84864 .44962 m .83799 .46427 L .83777 .45788 L p 0 0 .13 r
F P
0 g
s
.83777 .45788 m .84709 .44259 L .84864 .44962 L p 0 0 .13 r
F P
0 g
s
.74502 .51214 m .72979 .52262 L .7543 .52886 L p .7 .944 .959 r
F P
0 g
s
.7543 .52886 m .76804 .51766 L .74502 .51214 L p .7 .944 .959 r
F P
0 g
s
.44163 .56695 m .42082 .57071 L .48544 .59675 L p .635 .856 .983 r
F P
0 g
s
.48544 .59675 m .50406 .59197 L .44163 .56695 L p .635 .856 .983 r
F P
0 g
s
.83303 .46799 m .82096 .48155 L .82727 .47849 L p .643 .893 .56 r
F P
0 g
s
.82727 .47849 m .83799 .46427 L .83303 .46799 L p .643 .893 .56 r
F P
0 g
s
.85633 .42685 m .84709 .44259 L .84087 .4332 L p .119 .123 .587 r
F P
0 g
s
.84087 .4332 m .84879 .41684 L .85633 .42685 L p .119 .123 .587 r
F P
0 g
s
.8435 .38729 m .83701 .40474 L .82137 .39078 L p .354 .448 .819 r
F P
0 g
s
.82137 .39078 m .82652 .37275 L .8435 .38729 L p .354 .448 .819 r
F P
0 g
s
.49495 .19989 m .4858 .17833 L .52277 .19781 L p .494 .66 .935 r
F P
0 g
s
.4858 .17833 m .49495 .19989 L .45938 .18144 L p .497 .666 .938 r
F P
0 g
s
.63071 .25958 m .62639 .23828 L .66154 .25943 L p .481 .634 .921 r
F P
0 g
s
.62639 .23828 m .63071 .25958 L .5956 .23871 L p .487 .642 .925 r
F P
0 g
s
.46217 .56276 m .44163 .56695 L .50406 .59197 L p .637 .859 .983 r
F P
0 g
s
.50406 .59197 m .52247 .58677 L .46217 .56276 L p .637 .859 .983 r
F P
0 g
s
.66358 .53049 m .64644 .53895 L .6836 .5516 L p .67 .901 .978 r
F P
0 g
s
.6836 .5516 m .69909 .54234 L .66358 .53049 L p .67 .901 .978 r
F P
0 g
s
.45938 .18144 m .44901 .15988 L .4858 .17833 L p .497 .666 .938 r
F P
0 g
s
.5956 .23871 m .58992 .21712 L .62639 .23828 L p .487 .642 .925 r
F P
0 g
s
.58992 .21712 m .5956 .23871 L .55949 .21803 L p .491 .65 .929 r
F P
0 g
s
.48247 .55814 m .46217 .56276 L .52247 .58677 L p .639 .861 .983 r
F P
0 g
s
.52247 .58677 m .54068 .58117 L .48247 .55814 L p .639 .861 .983 r
F P
0 g
s
.85661 .4 m .84879 .41684 L .83701 .40474 L p .288 .355 .758 r
F P
0 g
s
.83701 .40474 m .8435 .38729 L .85661 .4 L p .288 .355 .758 r
F P
0 g
s
.80885 .48158 m .79531 .49403 L .80882 .49468 L p .726 .989 .866 r
F P
0 g
s
.80882 .49468 m .82096 .48155 L .80885 .48158 L p .726 .989 .866 r
F P
0 g
s
.76016 .50125 m .74502 .51214 L .76804 .51766 L p .704 .951 .954 r
F P
0 g
s
.76804 .51766 m .78171 .50606 L .76016 .50125 L p .704 .951 .954 r
F P
0 g
s
.50254 .55308 m .48247 .55814 L .54068 .58117 L p .642 .864 .983 r
F P
0 g
s
.54068 .58117 m .5587 .57515 L .50254 .55308 L p .642 .864 .983 r
F P
0 g
s
.55949 .21803 m .55248 .19622 L .58992 .21712 L p .491 .65 .929 r
F P
0 g
s
.55248 .19622 m .55949 .21803 L .52277 .19781 L p .495 .657 .933 r
F P
0 g
s
.78459 .31944 m .78232 .33907 L .75571 .32037 L p .449 .582 .894 r
F P
0 g
s
.75571 .32037 m .7566 .30021 L .78459 .31944 L p .449 .582 .894 r
F P
0 g
s
.7566 .30021 m .75571 .32037 L .72651 .30071 L p .462 .601 .904 r
F P
0 g
s
.80966 .33751 m .80602 .35661 L .78232 .33907 L p .431 .556 .881 r
F P
0 g
s
.78232 .33907 m .78459 .31944 L .80966 .33751 L p .431 .556 .881 r
F P
0 g
s
.72651 .30071 m .72601 .28007 L .7566 .30021 L p .462 .601 .904 r
F P
0 g
s
.72601 .28007 m .72651 .30071 L .69502 .28032 L p .472 .616 .911 r
F P
0 g
s
.85922 .43451 m .84864 .44962 L .84709 .44259 L p 0 0 .26 r
F P
0 g
s
.84709 .44259 m .85633 .42685 L .85922 .43451 L p 0 0 .26 r
F P
0 g
s
.68061 .52161 m .66358 .53049 L .69909 .54234 L p .674 .906 .977 r
F P
0 g
s
.69909 .54234 m .71448 .53268 L .68061 .52161 L p .674 .906 .977 r
F P
0 g
s
.83152 .35423 m .82652 .37275 L .80602 .35661 L p .407 .521 .861 r
F P
0 g
s
.80602 .35661 m .80966 .33751 L .83152 .35423 L p .407 .521 .861 r
F P
0 g
s
.84504 .45399 m .83303 .46799 L .83799 .46427 L p .589 .826 .445 r
F P
0 g
s
.83799 .46427 m .84864 .44962 L .84504 .45399 L p .589 .826 .445 r
F P
0 g
s
.69502 .28032 m .69312 .25924 L .72601 .28007 L p .472 .616 .911 r
F P
0 g
s
.69312 .25924 m .69502 .28032 L .66154 .25943 L p .479 .628 .917 r
F P
0 g
s
.52239 .5476 m .50254 .55308 L .5587 .57515 L p .644 .866 .983 r
F P
0 g
s
.5587 .57515 m .57655 .56873 L .52239 .5476 L p .644 .866 .983 r
F P
0 g
s
.52277 .19781 m .51443 .17585 L .55248 .19622 L p .495 .657 .933 r
F P
0 g
s
.51443 .17585 m .52277 .19781 L .4858 .17833 L p .498 .663 .936 r
F P
0 g
s
.86549 .41064 m .85633 .42685 L .84879 .41684 L p .168 .189 .639 r
F P
0 g
s
.84879 .41684 m .85661 .4 L .86549 .41064 L p .168 .189 .639 r
F P
0 g
s
.66154 .25943 m .65824 .23796 L .69312 .25924 L p .479 .628 .917 r
F P
0 g
s
.65824 .23796 m .66154 .25943 L .62639 .23828 L p .486 .638 .922 r
F P
0 g
s
.84985 .36937 m .8435 .38729 L .82652 .37275 L p .37 .469 .831 r
F P
0 g
s
.82652 .37275 m .83152 .35423 L .84985 .36937 L p .37 .469 .831 r
F P
0 g
s
.54204 .5417 m .52239 .5476 L .57655 .56873 L p .646 .869 .982 r
F P
0 g
s
.57655 .56873 m .59424 .56189 L .54204 .5417 L p .646 .869 .982 r
F P
0 g
s
.82232 .46871 m .80885 .48158 L .82096 .48155 L p .723 .989 .834 r
F P
0 g
s
.82096 .48155 m .83303 .46799 L .82232 .46871 L p .723 .989 .834 r
F P
0 g
s
.4858 .17833 m .47618 .15631 L .51443 .17585 L p .498 .663 .936 r
F P
0 g
s
.47618 .15631 m .4858 .17833 L .44901 .15988 L p .501 .669 .939 r
F P
0 g
s
.77524 .48994 m .76016 .50125 L .78171 .50606 L p .709 .958 .947 r
F P
0 g
s
.78171 .50606 m .79531 .49403 L .77524 .48994 L p .709 .958 .947 r
F P
0 g
s
.62639 .23828 m .6217 .21647 L .65824 .23796 L p .486 .638 .922 r
F P
0 g
s
.6217 .21647 m .62639 .23828 L .58992 .21712 L p .491 .647 .927 r
F P
0 g
s
.69754 .51232 m .68061 .52161 L .71448 .53268 L p .677 .911 .975 r
F P
0 g
s
.71448 .53268 m .72979 .52262 L .69754 .51232 L p .677 .911 .975 r
F P
0 g
s
.86432 .38269 m .85661 .4 L .8435 .38729 L p .312 .387 .779 r
F P
0 g
s
.8435 .38729 m .84985 .36937 L .86432 .38269 L p .312 .387 .779 r
F P
0 g
s
.5615 .53536 m .54204 .5417 L .59424 .56189 L p .649 .872 .982 r
F P
0 g
s
.59424 .56189 m .61178 .55465 L .5615 .53536 L p .649 .872 .982 r
F P
0 g
s
.44901 .15988 m .43814 .13789 L .47618 .15631 L p .501 .669 .939 r
F P
0 g
s
.58992 .21712 m .58384 .19503 L .6217 .21647 L p .491 .647 .927 r
F P
0 g
s
.58384 .19503 m .58992 .21712 L .55248 .19622 L p .495 .654 .93 r
F P
0 g
s
.86973 .41895 m .85922 .43451 L .85633 .42685 L p 0 0 .371 r
F P
0 g
s
.85633 .42685 m .86549 .41064 L .86973 .41895 L p 0 0 .371 r
F P
0 g
s
.857 .43955 m .84504 .45399 L .84864 .44962 L p 0 0 0 r
F P
0 g
s
.84864 .44962 m .85922 .43451 L .857 .43955 L p 0 0 0 r
F P
0 g
s
.55248 .19622 m .54502 .17392 L .58384 .19503 L p .495 .654 .93 r
F P
0 g
s
.54502 .17392 m .55248 .19622 L .51443 .17585 L p .499 .661 .934 r
F P
0 g
s
.58078 .52861 m .5615 .53536 L .61178 .55465 L p .651 .875 .982 r
F P
0 g
s
.61178 .55465 m .62917 .54701 L .58078 .52861 L p .651 .875 .982 r
F P
0 g
s
.71436 .50262 m .69754 .51232 L .72979 .52262 L p .681 .916 .973 r
F P
0 g
s
.72979 .52262 m .74502 .51214 L .71436 .50262 L p .681 .916 .973 r
F P
0 g
s
.87456 .39396 m .86549 .41064 L .85661 .4 L p .21 .246 .681 r
F P
0 g
s
.85661 .4 m .86432 .38269 L .87456 .39396 L p .21 .246 .681 r
F P
0 g
s
.79025 .47821 m .77524 .48994 L .79531 .49403 L p .713 .965 .939 r
F P
0 g
s
.79531 .49403 m .80885 .48158 L .79025 .47821 L p .713 .965 .939 r
F P
0 g
s
.83574 .4554 m .82232 .46871 L .83303 .46799 L p .716 .983 .792 r
F P
0 g
s
.83303 .46799 m .84504 .45399 L .83574 .4554 L p .716 .983 .792 r
F P
0 g
s
.51443 .17585 m .50563 .15342 L .54502 .17392 L p .499 .661 .934 r
F P
0 g
s
.50563 .15342 m .51443 .17585 L .47618 .15631 L p .502 .667 .937 r
F P
0 g
s
.5999 .52144 m .58078 .52861 L .62917 .54701 L p .654 .879 .982 r
F P
0 g
s
.62917 .54701 m .64644 .53895 L .5999 .52144 L p .654 .879 .982 r
F P
0 g
s
.73111 .4925 m .71436 .50262 L .74502 .51214 L p .685 .922 .971 r
F P
0 g
s
.74502 .51214 m .76016 .50125 L .73111 .4925 L p .685 .922 .971 r
F P
0 g
s
.47618 .15631 m .46606 .13383 L .50563 .15342 L p .502 .667 .937 r
F P
0 g
s
.46606 .13383 m .47618 .15631 L .43814 .13789 L p .506 .673 .939 r
F P
0 g
s
.86889 .42467 m .857 .43955 L .85922 .43451 L p 0 0 0 r
F P
0 g
s
.85922 .43451 m .86973 .41895 L .86889 .42467 L p 0 0 0 r
F P
0 g
s
.88017 .40293 m .86973 .41895 L .86549 .41064 L p .016 0 .464 r
F P
0 g
s
.86549 .41064 m .87456 .39396 L .88017 .40293 L p .016 0 .464 r
F P
0 g
s
.8052 .46606 m .79025 .47821 L .80885 .48158 L p .717 .972 .928 r
F P
0 g
s
.80885 .48158 m .82232 .46871 L .8052 .46606 L p .717 .972 .928 r
F P
0 g
s
.61888 .51384 m .5999 .52144 L .64644 .53895 L p .656 .882 .981 r
F P
0 g
s
.64644 .53895 m .66358 .53049 L .61888 .51384 L p .656 .882 .981 r
F P
0 g
s
.43814 .13789 m .42675 .11546 L .46606 .13383 L p .506 .673 .939 r
F P
0 g
s
.84911 .44166 m .83574 .4554 L .84504 .45399 L p .702 .968 .736 r
F P
0 g
s
.84504 .45399 m .857 .43955 L .84911 .44166 L p .702 .968 .736 r
F P
0 g
s
.74776 .48196 m .73111 .4925 L .76016 .50125 L p .689 .928 .969 r
F P
0 g
s
.76016 .50125 m .77524 .48994 L .74776 .48196 L p .689 .928 .969 r
F P
0 g
s
.63771 .50583 m .61888 .51384 L .66358 .53049 L p .659 .886 .981 r
F P
0 g
s
.66358 .53049 m .68061 .52161 L .63771 .50583 L p .659 .886 .981 r
F P
0 g
s
.31884 .53988 m .29474 .54148 L .37833 .57688 L p .624 .843 .984 r
F P
0 g
s
.37833 .57688 m .39973 .57402 L .31884 .53988 L p .624 .843 .984 r
F P
0 g
s
.35661 .57929 m .37833 .57688 L .29474 .54148 L p .622 .841 .984 r
F P
0 g
s
.29474 .54148 m .27022 .54257 L .35661 .57929 L p .622 .841 .984 r
F P
0 g
s
.34257 .5378 m .31884 .53988 L .39973 .57402 L p .626 .844 .983 r
F P
0 g
s
.39973 .57402 m .42082 .57071 L .34257 .5378 L p .626 .844 .983 r
F P
0 g
s
.36593 .53524 m .34257 .5378 L .42082 .57071 L p .628 .846 .983 r
F P
0 g
s
.42082 .57071 m .44163 .56695 L .36593 .53524 L p .628 .846 .983 r
F P
0 g
s
.82009 .45348 m .8052 .46606 L .82232 .46871 L p .72 .979 .914 r
F P
0 g
s
.82232 .46871 m .83574 .4554 L .82009 .45348 L p .72 .979 .914 r
F P
0 g
s
.88072 .40933 m .86889 .42467 L .86973 .41895 L p 0 0 0 r
F P
0 g
s
.86973 .41895 m .88017 .40293 L .88072 .40933 L p 0 0 0 r
F P
0 g
s
.38896 .53221 m .36593 .53524 L .44163 .56695 L p .629 .848 .983 r
F P
0 g
s
.44163 .56695 m .46217 .56276 L .38896 .53221 L p .629 .848 .983 r
F P
0 g
s
.65642 .49739 m .63771 .50583 L .68061 .52161 L p .662 .89 .98 r
F P
0 g
s
.68061 .52161 m .69754 .51232 L .65642 .49739 L p .662 .89 .98 r
F P
0 g
s
.41168 .52872 m .38896 .53221 L .46217 .56276 L p .631 .85 .983 r
F P
0 g
s
.46217 .56276 m .48247 .55814 L .41168 .52872 L p .631 .85 .983 r
F P
0 g
s
.86242 .42747 m .84911 .44166 L .857 .43955 L p .678 .941 .663 r
F P
0 g
s
.857 .43955 m .86889 .42467 L .86242 .42747 L p .678 .941 .663 r
F P
0 g
s
.76435 .471 m .74776 .48196 L .77524 .48994 L p .693 .934 .965 r
F P
0 g
s
.77524 .48994 m .79025 .47821 L .76435 .471 L p .693 .934 .965 r
F P
0 g
s
.4341 .52476 m .41168 .52872 L .48247 .55814 L p .633 .852 .983 r
F P
0 g
s
.48247 .55814 m .50254 .55308 L .4341 .52476 L p .633 .852 .983 r
F P
0 g
s
.45625 .52036 m .4341 .52476 L .50254 .55308 L p .635 .855 .983 r
F P
0 g
s
.50254 .55308 m .52239 .5476 L .45625 .52036 L p .635 .855 .983 r
F P
0 g
s
.67501 .48853 m .65642 .49739 L .69754 .51232 L p .665 .894 .979 r
F P
0 g
s
.69754 .51232 m .71436 .50262 L .67501 .48853 L p .665 .894 .979 r
F P
0 g
s
.83493 .44046 m .82009 .45348 L .83574 .4554 L p .722 .985 .896 r
F P
0 g
s
.83574 .4554 m .84911 .44166 L .83493 .44046 L p .722 .985 .896 r
F P
0 g
s
.47814 .5155 m .45625 .52036 L .52239 .5476 L p .637 .857 .983 r
F P
0 g
s
.52239 .5476 m .54204 .5417 L .47814 .5155 L p .637 .857 .983 r
F P
0 g
s
.78086 .45961 m .76435 .471 L .79025 .47821 L p .697 .941 .962 r
F P
0 g
s
.79025 .47821 m .8052 .46606 L .78086 .45961 L p .697 .941 .962 r
F P
0 g
s
.4998 .5102 m .47814 .5155 L .54204 .5417 L p .639 .859 .983 r
F P
0 g
s
.54204 .5417 m .5615 .53536 L .4998 .5102 L p .639 .859 .983 r
F P
0 g
s
.87568 .41283 m .86242 .42747 L .86889 .42467 L p .64 .896 .569 r
F P
0 g
s
.86889 .42467 m .88072 .40933 L .87568 .41283 L p .64 .896 .569 r
F P
0 g
s
.69349 .47925 m .67501 .48853 L .71436 .50262 L p .668 .899 .978 r
F P
0 g
s
.71436 .50262 m .73111 .4925 L .69349 .47925 L p .668 .899 .978 r
F P
0 g
s
.52123 .50446 m .4998 .5102 L .5615 .53536 L p .641 .862 .983 r
F P
0 g
s
.5615 .53536 m .58078 .52861 L .52123 .50446 L p .641 .862 .983 r
F P
0 g
s
.84972 .427 m .83493 .44046 L .84911 .44166 L p .723 .988 .873 r
F P
0 g
s
.84911 .44166 m .86242 .42747 L .84972 .427 L p .723 .988 .873 r
F P
0 g
s
.79732 .44779 m .78086 .45961 L .8052 .46606 L p .701 .948 .957 r
F P
0 g
s
.8052 .46606 m .82009 .45348 L .79732 .44779 L p .701 .948 .957 r
F P
0 g
s
.54246 .49827 m .52123 .50446 L .58078 .52861 L p .643 .865 .983 r
F P
0 g
s
.58078 .52861 m .5999 .52144 L .54246 .49827 L p .643 .865 .983 r
F P
0 g
s
.71187 .46954 m .69349 .47925 L .73111 .4925 L p .671 .903 .977 r
F P
0 g
s
.73111 .4925 m .74776 .48196 L .71187 .46954 L p .671 .903 .977 r
F P
0 g
s
.56349 .49165 m .54246 .49827 L .5999 .52144 L p .645 .867 .982 r
F P
0 g
s
.5999 .52144 m .61888 .51384 L .56349 .49165 L p .645 .867 .982 r
F P
0 g
s
.73016 .4594 m .71187 .46954 L .74776 .48196 L p .675 .908 .976 r
F P
0 g
s
.74776 .48196 m .76435 .471 L .73016 .4594 L p .675 .908 .976 r
F P
0 g
s
.81372 .43554 m .79732 .44779 L .82009 .45348 L p .705 .955 .95 r
F P
0 g
s
.82009 .45348 m .83493 .44046 L .81372 .43554 L p .705 .955 .95 r
F P
0 g
s
.86446 .4131 m .84972 .427 L .86242 .42747 L p .72 .988 .842 r
F P
0 g
s
.86242 .42747 m .87568 .41283 L .86446 .4131 L p .72 .988 .842 r
F P
0 g
s
.58436 .48459 m .56349 .49165 L .61888 .51384 L p .648 .87 .982 r
F P
0 g
s
.61888 .51384 m .63771 .50583 L .58436 .48459 L p .648 .87 .982 r
F P
0 g
s
.60505 .4771 m .58436 .48459 L .63771 .50583 L p .65 .873 .982 r
F P
0 g
s
.63771 .50583 m .65642 .49739 L .60505 .4771 L p .65 .873 .982 r
F P
0 g
s
.74837 .44884 m .73016 .4594 L .76435 .471 L p .678 .913 .975 r
F P
0 g
s
.76435 .471 m .78086 .45961 L .74837 .44884 L p .678 .913 .975 r
F P
0 g
s
.83006 .42285 m .81372 .43554 L .83493 .44046 L p .709 .962 .943 r
F P
0 g
s
.83493 .44046 m .84972 .427 L .83006 .42285 L p .709 .962 .943 r
F P
0 g
s
.6256 .46917 m .60505 .4771 L .65642 .49739 L p .652 .876 .982 r
F P
0 g
s
.65642 .49739 m .67501 .48853 L .6256 .46917 L p .652 .876 .982 r
F P
0 g
s
.7665 .43784 m .74837 .44884 L .78086 .45961 L p .682 .919 .973 r
F P
0 g
s
.78086 .45961 m .79732 .44779 L .7665 .43784 L p .682 .919 .973 r
F P
0 g
s
.64601 .46081 m .6256 .46917 L .67501 .48853 L p .655 .88 .981 r
F P
0 g
s
.67501 .48853 m .69349 .47925 L .64601 .46081 L p .655 .88 .981 r
F P
0 g
s
.84636 .40972 m .83006 .42285 L .84972 .427 L p .713 .97 .933 r
F P
0 g
s
.84972 .427 m .86446 .4131 L .84636 .40972 L p .713 .97 .933 r
F P
0 g
s
.27431 .49551 m .2479 .49666 L .34257 .5378 L p .621 .838 .983 r
F P
0 g
s
.34257 .5378 m .36593 .53524 L .27431 .49551 L p .621 .838 .983 r
F P
0 g
s
.31884 .53988 m .34257 .5378 L .2479 .49666 L p .62 .837 .983 r
F P
0 g
s
.30028 .49385 m .27431 .49551 L .36593 .53524 L p .623 .84 .983 r
F P
0 g
s
.36593 .53524 m .38896 .53221 L .30028 .49385 L p .623 .84 .983 r
F P
0 g
s
.2479 .49666 m .22103 .49728 L .31884 .53988 L p .62 .837 .983 r
F P
0 g
s
.29474 .54148 m .31884 .53988 L .22103 .49728 L p .618 .835 .983 r
F P
0 g
s
.32585 .49168 m .30028 .49385 L .38896 .53221 L p .624 .841 .983 r
F P
0 g
s
.38896 .53221 m .41168 .52872 L .32585 .49168 L p .624 .841 .983 r
F P
0 g
s
.22103 .49728 m .19367 .49736 L .29474 .54148 L p .618 .835 .983 r
F P
0 g
s
.27022 .54257 m .29474 .54148 L .19367 .49736 L p .616 .834 .983 r
F P
0 g
s
.35104 .48902 m .32585 .49168 L .41168 .52872 L p .626 .843 .983 r
F P
0 g
s
.41168 .52872 m .4341 .52476 L .35104 .48902 L p .626 .843 .983 r
F P
0 g
s
.19367 .49736 m .16578 .49689 L .27022 .54257 L p .616 .834 .983 r
F P
0 g
s
.37588 .48586 m .35104 .48902 L .4341 .52476 L p .628 .845 .983 r
F P
0 g
s
.4341 .52476 m .45625 .52036 L .37588 .48586 L p .628 .845 .983 r
F P
0 g
s
.6663 .45201 m .64601 .46081 L .69349 .47925 L p .657 .883 .981 r
F P
0 g
s
.69349 .47925 m .71187 .46954 L .6663 .45201 L p .657 .883 .981 r
F P
0 g
s
.78457 .42641 m .7665 .43784 L .79732 .44779 L p .685 .925 .97 r
F P
0 g
s
.79732 .44779 m .81372 .43554 L .78457 .42641 L p .685 .925 .97 r
F P
0 g
s
.40039 .48222 m .37588 .48586 L .45625 .52036 L p .629 .847 .983 r
F P
0 g
s
.45625 .52036 m .47814 .5155 L .40039 .48222 L p .629 .847 .983 r
F P
0 g
s
.4246 .4781 m .40039 .48222 L .47814 .5155 L p .631 .849 .983 r
F P
0 g
s
.47814 .5155 m .4998 .5102 L .4246 .4781 L p .631 .849 .983 r
F P
0 g
s
.44852 .47352 m .4246 .4781 L .4998 .5102 L p .633 .851 .983 r
F P
0 g
s
.4998 .5102 m .52123 .50446 L .44852 .47352 L p .633 .851 .983 r
F P
0 g
s
.68647 .44278 m .6663 .45201 L .71187 .46954 L p .66 .887 .98 r
F P
0 g
s
.71187 .46954 m .73016 .4594 L .68647 .44278 L p .66 .887 .98 r
F P
0 g
s
.47217 .46847 m .44852 .47352 L .52123 .50446 L p .635 .853 .983 r
F P
0 g
s
.52123 .50446 m .54246 .49827 L .47217 .46847 L p .635 .853 .983 r
F P
0 g
s
.80257 .41454 m .78457 .42641 L .81372 .43554 L p .689 .931 .967 r
F P
0 g
s
.81372 .43554 m .83006 .42285 L .80257 .41454 L p .689 .931 .967 r
F P
0 g
s
.49558 .46295 m .47217 .46847 L .54246 .49827 L p .636 .855 .983 r
F P
0 g
s
.54246 .49827 m .56349 .49165 L .49558 .46295 L p .636 .855 .983 r
F P
0 g
s
.70653 .43311 m .68647 .44278 L .73016 .4594 L p .663 .891 .98 r
F P
0 g
s
.73016 .4594 m .74837 .44884 L .70653 .43311 L p .663 .891 .98 r
F P
0 g
s
.51875 .45698 m .49558 .46295 L .56349 .49165 L p .638 .857 .983 r
F P
0 g
s
.56349 .49165 m .58436 .48459 L .51875 .45698 L p .638 .857 .983 r
F P
0 g
s
.82053 .40222 m .80257 .41454 L .83006 .42285 L p .693 .938 .964 r
F P
0 g
s
.83006 .42285 m .84636 .40972 L .82053 .40222 L p .693 .938 .964 r
F P
0 g
s
.54172 .45055 m .51875 .45698 L .58436 .48459 L p .64 .86 .983 r
F P
0 g
s
.58436 .48459 m .60505 .4771 L .54172 .45055 L p .64 .86 .983 r
F P
0 g
s
.7265 .423 m .70653 .43311 L .74837 .44884 L p .666 .896 .979 r
F P
0 g
s
.74837 .44884 m .7665 .43784 L .7265 .423 L p .666 .896 .979 r
F P
0 g
s
.56449 .44367 m .54172 .45055 L .60505 .4771 L p .642 .862 .983 r
F P
0 g
s
.60505 .4771 m .6256 .46917 L .56449 .44367 L p .642 .862 .983 r
F P
0 g
s
.74639 .41245 m .7265 .423 L .7665 .43784 L p .669 .9 .978 r
F P
0 g
s
.7665 .43784 m .78457 .42641 L .74639 .41245 L p .669 .9 .978 r
F P
0 g
s
.58708 .43634 m .56449 .44367 L .6256 .46917 L p .644 .865 .982 r
F P
0 g
s
.6256 .46917 m .64601 .46081 L .58708 .43634 L p .644 .865 .982 r
F P
0 g
s
.60951 .42856 m .58708 .43634 L .64601 .46081 L p .646 .868 .982 r
F P
0 g
s
.64601 .46081 m .6663 .45201 L .60951 .42856 L p .646 .868 .982 r
F P
0 g
s
.7662 .40146 m .74639 .41245 L .78457 .42641 L p .672 .905 .977 r
F P
0 g
s
.78457 .42641 m .80257 .41454 L .7662 .40146 L p .672 .905 .977 r
F P
0 g
s
.63179 .42033 m .60951 .42856 L .6663 .45201 L p .648 .871 .982 r
F P
0 g
s
.6663 .45201 m .68647 .44278 L .63179 .42033 L p .648 .871 .982 r
F P
0 g
s
.78594 .39003 m .7662 .40146 L .80257 .41454 L p .675 .91 .976 r
F P
0 g
s
.80257 .41454 m .82053 .40222 L .78594 .39003 L p .675 .91 .976 r
F P
0 g
s
.65392 .41165 m .63179 .42033 L .68647 .44278 L p .65 .874 .982 r
F P
0 g
s
.68647 .44278 m .70653 .43311 L .65392 .41165 L p .65 .874 .982 r
F P
0 g
s
.25033 .44432 m .22181 .44546 L .32585 .49168 L p .62 .836 .983 r
F P
0 g
s
.32585 .49168 m .35104 .48902 L .25033 .44432 L p .62 .836 .983 r
F P
0 g
s
.30028 .49385 m .32585 .49168 L .22181 .44546 L p .619 .834 .983 r
F P
0 g
s
.27838 .44265 m .25033 .44432 L .35104 .48902 L p .621 .837 .983 r
F P
0 g
s
.35104 .48902 m .37588 .48586 L .27838 .44265 L p .621 .837 .983 r
F P
0 g
s
.22181 .44546 m .19281 .44604 L .30028 .49385 L p .619 .834 .983 r
F P
0 g
s
.27431 .49551 m .30028 .49385 L .19281 .44604 L p .617 .833 .983 r
F P
0 g
s
.306 .44045 m .27838 .44265 L .37588 .48586 L p .623 .839 .983 r
F P
0 g
s
.37588 .48586 m .40039 .48222 L .306 .44045 L p .623 .839 .983 r
F P
0 g
s
.19281 .44604 m .16328 .44606 L .27431 .49551 L p .617 .833 .983 r
F P
0 g
s
.2479 .49666 m .27431 .49551 L .16328 .44606 L p .616 .831 .983 r
F P
0 g
s
.33323 .43773 m .306 .44045 L .40039 .48222 L p .624 .84 .983 r
F P
0 g
s
.40039 .48222 m .4246 .4781 L .33323 .43773 L p .624 .84 .983 r
F P
0 g
s
.16328 .44606 m .13318 .4455 L .2479 .49666 L p .616 .831 .983 r
F P
0 g
s
.22103 .49728 m .2479 .49666 L .13318 .4455 L p .614 .83 .983 r
F P
0 g
s
.67594 .40252 m .65392 .41165 L .70653 .43311 L p .653 .877 .982 r
F P
0 g
s
.70653 .43311 m .7265 .423 L .67594 .40252 L p .653 .877 .982 r
F P
0 g
s
.36007 .4345 m .33323 .43773 L .4246 .4781 L p .626 .842 .983 r
F P
0 g
s
.4246 .4781 m .44852 .47352 L .36007 .4345 L p .626 .842 .983 r
F P
0 g
s
.13318 .4455 m .10248 .44434 L .22103 .49728 L p .614 .83 .983 r
F P
0 g
s
.19367 .49736 m .22103 .49728 L .10248 .44434 L p .613 .829 .983 r
F P
0 g
s
.38658 .43077 m .36007 .4345 L .44852 .47352 L p .627 .844 .983 r
F P
0 g
s
.44852 .47352 m .47217 .46847 L .38658 .43077 L p .627 .844 .983 r
F P
0 g
s
.10248 .44434 m .07113 .44258 L .19367 .49736 L p .613 .829 .983 r
F P
0 g
s
.16578 .49689 m .19367 .49736 L .07113 .44258 L p .612 .828 .983 r
F P
0 g
s
.41275 .42654 m .38658 .43077 L .47217 .46847 L p .629 .845 .983 r
F P
0 g
s
.47217 .46847 m .49558 .46295 L .41275 .42654 L p .629 .845 .983 r
F P
0 g
s
.07113 .44258 m .0391 .44018 L .16578 .49689 L p .612 .828 .983 r
F P
0 g
s
.69784 .39294 m .67594 .40252 L .7265 .423 L p .655 .881 .981 r
F P
0 g
s
.7265 .423 m .74639 .41245 L .69784 .39294 L p .655 .881 .981 r
F P
0 g
s
.43863 .42182 m .41275 .42654 L .49558 .46295 L p .63 .847 .983 r
F P
0 g
s
.49558 .46295 m .51875 .45698 L .43863 .42182 L p .63 .847 .983 r
F P
0 g
s
.46423 .41662 m .43863 .42182 L .51875 .45698 L p .632 .849 .983 r
F P
0 g
s
.51875 .45698 m .54172 .45055 L .46423 .41662 L p .632 .849 .983 r
F P
0 g
s
.71964 .38292 m .69784 .39294 L .74639 .41245 L p .658 .884 .981 r
F P
0 g
s
.74639 .41245 m .7662 .40146 L .71964 .38292 L p .658 .884 .981 r
F P
0 g
s
.48957 .41094 m .46423 .41662 L .54172 .45055 L p .634 .851 .983 r
F P
0 g
s
.54172 .45055 m .56449 .44367 L .48957 .41094 L p .634 .851 .983 r
F P
0 g
s
.51467 .40478 m .48957 .41094 L .56449 .44367 L p .635 .853 .983 r
F P
0 g
s
.56449 .44367 m .58708 .43634 L .51467 .40478 L p .635 .853 .983 r
F P
0 g
s
.74134 .37244 m .71964 .38292 L .7662 .40146 L p .66 .888 .98 r
F P
0 g
s
.7662 .40146 m .78594 .39003 L .74134 .37244 L p .66 .888 .98 r
F P
0 g
s
.53955 .39815 m .51467 .40478 L .58708 .43634 L p .637 .855 .983 r
F P
0 g
s
.58708 .43634 m .60951 .42856 L .53955 .39815 L p .637 .855 .983 r
F P
0 g
s
.56423 .39106 m .53955 .39815 L .60951 .42856 L p .639 .858 .983 r
F P
0 g
s
.60951 .42856 m .63179 .42033 L .56423 .39106 L p .639 .858 .983 r
F P
0 g
s
.58873 .38349 m .56423 .39106 L .63179 .42033 L p .64 .86 .983 r
F P
0 g
s
.63179 .42033 m .65392 .41165 L .58873 .38349 L p .64 .86 .983 r
F P
0 g
s
.61306 .37546 m .58873 .38349 L .65392 .41165 L p .642 .863 .983 r
F P
0 g
s
.65392 .41165 m .67594 .40252 L .61306 .37546 L p .642 .863 .983 r
F P
0 g
s
.63723 .36697 m .61306 .37546 L .67594 .40252 L p .644 .866 .982 r
F P
0 g
s
.67594 .40252 m .69784 .39294 L .63723 .36697 L p .644 .866 .982 r
F P
0 g
s
.66126 .35802 m .63723 .36697 L .69784 .39294 L p .646 .868 .982 r
F P
0 g
s
.69784 .39294 m .71964 .38292 L .66126 .35802 L p .646 .868 .982 r
F P
0 g
s
.68516 .3486 m .66126 .35802 L .71964 .38292 L p .648 .871 .982 r
F P
0 g
s
.71964 .38292 m .74134 .37244 L .68516 .3486 L p .648 .871 .982 r
F P
0 g
s
.25 Mabswid
.06201 0 m
.92976 .06735 L
s
.92976 .06735 m
1 .40259 L
s
1 .40259 m
0 .33867 L
s
0 .33867 m
.06201 0 L
s
.06201 0 m
0 .33867 L
s
.0584 .01969 m
.06513 .0202 L
s
[(-0.2)] .04494 .01865 1 .07681 Mshowa
.04533 .09107 m
.05206 .09156 L
s
[(0)] .03187 .09007 1 .07392 Mshowa
.03139 .16724 m
.03812 .16772 L
s
[(0.2)] .01792 .16629 1 .07084 Mshowa
.01647 .24872 m
.0232 .24918 L
s
[(0.4)] .003 .24781 1 .06755 Mshowa
.00047 .33608 m
.00721 .33651 L
s
[(0.6)] -0.013 .33522 1 .06402 Mshowa
.125 Mabswid
.05521 .03711 m
.05925 .03741 L
s
.05197 .05481 m
.05601 .05511 L
s
.04868 .07279 m
.05272 .07309 L
s
.04193 .10964 m
.04597 .10994 L
s
.03848 .12853 m
.04251 .12882 L
s
.03496 .14772 m
.039 .14801 L
s
.02775 .1871 m
.03179 .18738 L
s
.02405 .20729 m
.02809 .20757 L
s
.02029 .22783 m
.02433 .2281 L
s
.01258 .26999 m
.01662 .27026 L
s
.00861 .29163 m
.01265 .29189 L
s
.00458 .31366 m
.00862 .31392 L
s
.06154 .00254 m
.06558 .00285 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[48]:=",
  ImageSize->{288, 242.25},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000lQ000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol0025oo`8000Ao
o`8000Aoo`800?5oo`0087oo00@007ooOol000Qoo`04001oogoo003`Ool0021oo`04001oogoo000:
Ool00`00Oomoo`3_Ool001Yoo`@0009oo`04001oogoo000;Ool00`00Oomoo`3^Ool0021oo`04001o
ogoo0008Ool01000Oomoo`009Woo0P0017oo0P000goo1000^goo000QOol2000:Ool2000VOol01000
Oomoo`0027oo00<007ooOol0_7oo001EOol01000Oomoo`002Goo00<007ooOol0^goo001?Ool40002
Ool01000Oomoo`002Woo00<007ooOol0^Woo001EOol01000Oomoo`0027oo00@007ooOol002Ioo`80
00Aoo`8000=oo`D008Eoo`00EWoo0P002Woo0P009Woo00@007ooOol000Yoo`03001oogoo08Eoo`00
RWoo00@007ooOol000Yoo`03001oogoo08Eoo`009Goo1`00F7oo10000Woo00@007ooOol000Yoo`03
001oogoo08Eoo`009Goo0P001Goo3@00DGoo00@007ooOol000Yoo`03001oogoo02Aoo`8005moo`00
47oo0P0017oo0P000goo10001Woo0P002Woo00<007ooOol01Goo3@00AGoo0P002Woo0P009Goo00@0
07ooOol005ioo`003goo00@007ooOol000Qoo`03001oogoo00Ioo`8001Eoo`03001oogoo00Moo`h0
06]oo`04001oogoo001NOol000moo`04001oogoo0009Ool00`00Oomoo`05Ool2000OOol00`00Oomo
o`08Ool00`00Oomoo`0>001MOol01000Oomoo`00:goo0P0017oo0P000goo1@008goo0009Ool40002
Ool01000Oomoo`002Woo00<007ooOol017oo0`00<goo00<007ooOol017oo3@00D7oo00@007ooOol0
02Yoo`04001oogoo000:Ool00`00Oomoo`0SOol000moo`04001oogoo0008Ool01000Oomoo`001Goo
0P00=7oo00<007ooOol01goo00<007ooOol01goo3@00A7oo0P00:goo00@007ooOol000Yoo`03001o
ogoo02=oo`0047oo0P002Woo0P001Woo00<007oo0000Agoo00<007ooOol01goo00<007ooOol03@00
I7oo00@007ooOol000Yoo`03001oogoo02=oo`0097oo00<007oo0000Fgoo00<007ooOol00goo3@00
Egoo00@007ooOol000Yoo`03001oogoo02=oo`008goo00@007ooOol006Eoo`03001oogoo00Ioo`d0
04]oo`8000Yoo`8002Eoo`008goo0P0000=oo`00Ool0I7oo00<007ooOol027oo00<007ooOol01goo
3P00LGoo000SOol01000Oomoo`00NWoo00<007ooOol01goo00@007ooOomoo`d006Aoo`008goo00@0
07ooOol008ioo`03001oogoo00Aoo`d005Moo`008goo00@007ooOol009Moo`03001oogoo00Qoo`h0
04Uoo`008Woo0P000Woo00<007ooOol0UGoo00<007ooOol01goo00<007ooOol01goo00<007ooOol0
0Woo3@00?7oo000ROol01@00Oomoogoo0000]Goo00<007ooOol01Goo3@00;goo000ROol01@00Oomo
ogoo0000_goo00<007ooOol01goo3P008Woo000ROol01@00Oomoogoo0000b7oo00<007ooOol01goo
00<007ooOol00Woo1`006goo000ROol01@00Oomoogoo0000g7oo0P006goo000QOol20003Ool00`00
Oomoo`3JOol2000KOol0025oo`03001oogoo00=oo`03001oogoo0=Uoo`03001oo`0001Yoo`006Goo
0P001Woo00<007ooOol00goo00<007ooOol0f7oo00@007ooOol001Yoo`0067oo00@007ooOol000Eo
o`03001oogoo00=oo`03001oogoo0=Qoo`04001oogoo000JOol001Qoo`04001oogoo0004Ool30004
Ool00`00Oomoo`3HOol01000Oomoo`006Woo000HOol01000Oomoo`001Goo00<007ooOol00goo00<0
07ooOol0egoo00D007ooOomoo`0001Yoo`0067oo00@007ooOol000Aoo`03001oogoo00Aoo`03001o
ogoo0=Moo`03001oogoo009oo`03001oogoo01Moo`006Goo0P001Goo00<007ooOol017oo00<007oo
Ool0egoo00<007ooOol00Woo00<007ooOol05goo000POol00`00Oomoo`04Ool00`00Oomoo`3FOol0
0`00Oomoo`03Ool00`00Oomoo`0GOol0021oo`8000Eoo`03001oogoo0=Ioo`03001oogoo00=oo`03
001oogoo01Moo`0087oo00<007ooOol017oo00<007ooOol0eGoo00<007ooOol01Goo00<007ooOol0
5Woo000OOol00`00Oomoo`05Ool00`00Oomoo`1IOol2001jOol00`00Oomoo`05Ool00`00Oomoo`0F
Ool001moo`03001oogoo00Eoo`03001oogoo05Uoo`04000n_@00001hOol00`00Oomoo`05Ool00`00
Oomoo`0FOol001moo`03001oogoo00Eoo`03001oogoo05Yoo`03000n_D:m00<007Aoo`03001oogoo
00Ioo`03001oogoo01Ioo`007goo0P001goo00<007ooOol0FGoo00<003jm?[d00cjm0P00LWoo00<0
07ooOol01Woo00<007ooOol05Woo000OOol00`00Oomoo`06Ool00`00Oomoo`1JOol01000?[dn_D:m
0cjm0P00Kgoo00<007ooOol027oo00<007ooOol05Goo000OOol00`00Oomoo`06Ool00`00Oomoo`1J
Ool00`00?[dn_@05?[d3001]Ool00`00Oomoo`08Ool00`00Oomoo`0EOol001ioo`03001oogoo00Mo
o`03001oogoo05]oo`80008n_@06@[dn_Cjm?[d003jM0P00Jgoo00<007ooOol027oo00<007ooOol0
5Goo000NOol00`00Oomoo`07Ool00`00Oomoo`1KOol01000?[d0000013jm00@003jm?Ydn_@8006Qo
o`03001oogoo00Uoo`03001oogoo01Eoo`007Woo0P0027oo00<007ooOol0G7oo00<003jm?Yd00P00
00Q2_Cjm000nW3jm?Ydn_CjL0P00IWoo00<007ooOol02Goo00<007ooOol05Goo000NOol00`00Oomo
o`07Ool00`00Oomoo`1LOol00`00?[dn_@02?[d2000023jm000nWCjm?Ydn_CjM?[d2001SOol00`00
Oomoo`0;Ool00`00Oomoo`0DOol000Uoo`8000Aoo`8000=oo`@000Ioo`03001oogoo00Moo`03001o
ogoo05eoo`06000nWCjm?Ydn_CjM0P0000Ln_CjL?[dnWCjm?Y`n_@03001QOol00`00Oomoo`0;Ool0
0`00Oomoo`0DOol000Qoo`04001oogoo0008Ool00`00Oomoo`06Ool00`00Oomoo`08Ool00`00Oomo
o`1MOol00`00?[dn_@05?[d2000023jM?[dnWCjm?Ydn_@00?Yd2001OOol00`00Oomoo`0;Ool00`00
Oomoo`0DOol000Qoo`04001oogoo0009Ool00`00Oomoo`05Ool00`00Oomoo`08Ool00`00Oomoo`1N
Ool200001cjM?[dnWCjm?Yd003jM00800009?[dnWCjm?Y`003jM?[djW00005eoo`03001oogoo00ao
o`03001oogoo01Aoo`0027oo00@007ooOol000Yoo`03001oogoo00Aoo`<000Qoo`03001oogoo05io
o`04000nW@000004?[d00`00?YdnW@0200000cjM?[d00004?Yd2001KOol00`00Oomoo`0<Ool00`00
Oomoo`0DOol000Qoo`04001oogoo0008Ool01000Oomoo`001Goo00<007ooOol027oo00<007ooOol0
Ggoo00<003jM?[d00P0000LnWCjm000n_CjM?[djW00200001cjm000n_CjM?[djW3jm008005Uoo`03
001oogoo00eoo`03001oogoo01=oo`002Goo0P002Woo0P001Woo00<007ooOol027oo00<007ooOol0
Ggoo00D003jm?Ydn_CjM00800003?[d003jM00@nW@8000LnW@03001oogoo05Eoo`03001oogoo00io
o`03001oogoo01=oo`007Goo00<007ooOol027oo00<007ooOol0H7oo00H003jm?Ydn_CZM?[d20000
1SZL?[dnWCjm>Y`n_@<00005?[dnWCjm>Y`n_@03001EOol00`00Oomoo`0>Ool00`00Oomoo`0COol0
01aoo`03001oogoo00Yoo`03001oogoo05moo`800005?[dnWCjm?Ydn_@030005?Yd01000?Yd00000
13jM00@003jM0000059oo`03001oogoo00moo`03001oogoo01=oo`0077oo0P002goo00<007ooOol0
Ggoo00X003jm000003jM?[djWCjm000nW@800007?Ydn_CZL000jW3jM>Y`00P0000Hn_CZL000jW3jM
>Y`2001@Ool00`00Oomoo`0?Ool00`00Oomoo`0COol001aoo`03001oogoo00Yoo`03001oogoo061o
o`03000nWCZM00800003?[dnW@0000<nW@800003?Yd003jM00@nW@800003?Yd003jM00<nW@8004io
o`03001oogoo011oo`03001oogoo019oo`0077oo00<007ooOol02Woo00<007ooOol0H7oo00D003ZM
?[djW3jm00800006>Yd003ZM?YdjW3jM0`0000HnWCZL?YdjW3jM>Y`200001SjM>Y`nWCZL?YdjW080
04]oo`03001oogoo015oo`03001oogoo019oo`0077oo00<007ooOol02Woo00<007ooOol0HGoo00@0
03jM?YdjW@8nW@8000HnW@03000nWCjM00DnW@<000DnW@<004Uoo`03001oogoo015oo`03001oogoo
019oo`006goo00<007ooOol02goo00<007ooOol0HGoo00L003jm>Ydn_CZL?[djW@03000013ZM?Ydj
W3jM0`00010nWCZL?YdjW3jM>Y`003ZL000jW3jM>Y`nW@00?YdjW08004Ioo`03001oogoo019oo`03
001oogoo019oo`006goo0P0037oo00<007ooOol0HWoo0P000SjM00DjWCjM?Yd003ZM008000<nW@04
000nW@000004?Yd00`00?YdjW0020003?Yd01@00?YdjW3jM0000AGoo00<007ooOol04goo00<007oo
Ool04Goo000KOol00`00Oomoo`0;Ool00`00Oomoo`1ROol02`00>Y`00000?[djW3jm000nWCZL?Yd0
0P0000DjW000>Y`nWCZL0080000??YdjW000>Y`nWCZL?Yd003jM>Y`003ZL?YdjW3jM008004=oo`03
001oogoo01=oo`03001oogoo015oo`006goo00<007ooOol02goo00<007ooOol0Hgoo00<003ZM?Yd0
0P0000DjW@00?YdnWCZM008nW@<0008nW@06>YdnW@00000nW@000SjM00<jW3jM00000P000cjM00<j
W3jM?Yd00P00@7oo00<007ooOol057oo00<007ooOol04Goo000KOol00`00Oomoo`0;Ool00`00Oomo
o`1SOol01@00?YdjW3jM>Yd00`0000djWCjM>Y`nWCZM?Yd003jM>Y`nWCZL?YdjW002000043jM>Y`n
WCZL?YdjW000>Y`nWCZL?YdjW3jM>Y`nW@00?goo00<007ooOol057oo00<007ooOol04Goo000KOol0
0`00Oomoo`0;Ool00`00Oomoo`1TOol01`00?YdjWCjM>YdnW@0000<nW@03>YdnWCjM00<0008nW@03
>YdnWCjM00<0008nW@03>Y`nW@00008000<nW@03>Y`nWCjM00<003eoo`03001oogoo01Aoo`03001o
ogoo015oo`006Woo00<007ooOol037oo00<007ooOol0I7oo0`0000<jW3jM>Yd00`0000LjWCjM>Y`n
WCZM000jW00200001SjM>Y`nW@00?YdjW0800005?YdjW3jM000nW@0200001cZL?YdjW3jM000nWCYl
008003Yoo`03001oogoo01Ioo`03001oogoo011oo`006Woo0P003Goo00<007ooOol0IGoo00P003ZM
000jWCjM>Yd003ZM0P0000LnWCZM?Yd003jM>YdnW@0200001SZM?Yd003jM>Y`nW@800005>Y`003ZL
?YdjW00200001cjM>Y`nW@00?YdjW3jM008003Qoo`03001oogoo01Ioo`03001oogoo011oo`006Woo
00<007ooOol03Goo00<007ooOol0I7oo00<003jM>Yd00P0000DnW@00?YdjW3jM00800007>Y`003ZL
?YdjW3jM>Y`00`0000DjW3jM>Y`nWCZL00<00004>Y`nWCZL?Yd200001cZL000jO3jM>W`nWCYl0080
03Eoo`03001oogoo01Moo`03001oogoo011oo`001Woo0P0017oo0P001Goo0`0017oo00<007ooOol0
3Goo00<007ooOol0I7oo00D003ZM>YdjWCjM00<00004?YdjWCjM>Yd300005CZM?YdjWCjM>YdnW@00
?YdjWCjM>Y`nWCZM?Yd003jM>Y`nWCZL?YdjW002000023jM>Y`nWCZL?YdjW3jM000dOol00`00Oomo
o`0GOol00`00Oomoo`0@Ool000Eoo`04001oogoo000;Ool00`00Oomoo`03Ool00`00Oomoo`0=Ool0
0`00Oomoo`1UOol05000>Y`nWCZM?YdjW000>Y`nWCZL?YdjW3jM000nWCZL?YdjW3jM>Y`300001CZL
?YdjW3jM>Y`00`0000DjW3jM>Y`nWCZL00<00005>W`nWCYl?YdjO003000bOol00`00Oomoo`0GOol0
0`00Oomoo`0@Ool000Eoo`04001oogoo0008Ool50003Ool00`00Oomoo`0>Ool00`00Oomoo`1UOol0
0`00?YdjW@02>Yd023jM00000000?YdjWCjM>Yd300007CZM?YdjWCjM>Yd003ZL000jWCjM>Y`nW@00
?YdjW000>Y`nWCZL?Yd003jM>W`003ZL?YdjW3jM00000SYl00<007ooOol0;Woo00<007ooOol06Goo
00<007ooOol03goo0005Ool01000Oomoo`0027oo00@007ooOol000Aoo`<000ioo`03001oogoo06Eo
o`<00006>Y`nWCZM?Yd003jM0P0000DjW3jM>Y`003ZL00800006?YdjW3jM000nWCZL0P0000HnWCZL
?Yd003jM>W`200001SjM>Y`nW@00?YdjO0800006?YdjO3jM000nOCYl0P00;Woo00<007ooOol06Goo
00<007ooOol03goo0005Ool01000Oomoo`002Goo00<007oo000017oo00<007ooOol03Woo00<007oo
Ool0IWoo00@003ZM0000008jW@04000jWCZM>Yd200001CjM000nWCZL>Yd00P0001XjW@00>YdnWCZL
>Yd003jM>Y`003ZL?YdjW3ZM000nWCZL000jO3jM>W`jW000?YdjW00013Yl00<007ooOol0:Woo00<0
07ooOol06Woo00<007ooOol03goo0006Ool2000;Ool20004Ool00`00Oomoo`0>Ool00`00Oomoo`1V
Ool01000?YdjWCjM0P0000HjW@00>Y`nWCZL?Yd3000013jM>Y`nWCZL0`0000@jW3jM>Y`nW@<00005
?YdjO3jM>W`nW@0300001CjM>W`nWCYl?Yd00`0000DnOCYl?WdjO3im008002Yoo`03001oogoo01Yo
o`03001oogoo00moo`006Goo00<007ooOol03Woo00<007ooOol0Igoo00<003ZM>Yd00SZM0P001SZM
00@003ZM?YdjW08jW@06?Yd003ZM>YdnWCZL0SZM014003ZL>YdjW3jM>Y`jWCZL000jO3ZL>W`nWCYl
>Y`jO00000LjO003001oogoo02Moo`03001oogoo01Yoo`03001oogoo00moo`0067oo00<007ooOol0
3goo00<007ooOol0Igoo00H003ZL?YdjWCjM>Y`3000013ZL?YdjW3jM0`0000@nWCZL?YdjW0<00004
>Y`nWCZL?Yd300001CjM>W`nWCYl?Yd00`0000DnWCYl?YdjO3jM00<00005?WdjO3im>W`nO@03000V
Ool00`00Oomoo`0LOol00`00Oomoo`0>Ool001Qoo`80011oo`03001oogoo06Moo`<000@jW@04000j
W@000003>Yd02@00>Yd003jM>Y`jW@00>YdjW00200001CjM>Y`jW@00>Yd00P0000HjW3jM>Y`003Yl
>Wd2000013Yl?YdjO0000SYl00<003Yl>W`00SYl00@003Yl>W`002Eoo`03001oogoo01aoo`03001o
ogoo00ioo`0067oo00<007ooOol03goo00<007ooOol0J7oo00X003ZM000003ZM?Yd003jM>Y`jW@80
0004>Y`003Yl?Yd200001SZL?Yd003jM>W`nW@800005>Y`003Yl?YdjO00200001SjM>W`003Yl?Ydj
O0800005?YdjO000>W`jO@02000013Yl?Wd003Ym0SYl0P008Woo00<007ooOol07Goo00<007ooOol0
3Woo000HOol00`00Oomoo`0?Ool00`00Oomoo`1XOol01000>YdjWCZM0P0000<jW@00>Yd00cZM0`00
00<jW3ZM>Yd00`0000DjW3ZM>Y`jWCZL00<00004>W`jWCYl>Yd30002>W`00cYm>W`jO0030004>W`3
0005>W`2000POol00`00Oomoo`0MOol00`00Oomoo`0>Ool001Qoo`03001oogoo00moo`03001oogoo
06Uoo`05000jW3ZM>Y`jW@020000:cZL?YdjW3ZM>Y`nW@00?YdjO3jM>W`nW@00?YdjO3jM>W`nWCYl
?Yd003jM>W`nWCYl?YdjO000>W`nWCYl?YdjO3jM>W`003Yl?WdjO3Ym>W`nO@00008jO006>WdjO3Yl
>W`jO@007goo00<007ooOol07Woo00<007ooOol03Goo000HOol00`00Oomoo`0@Ool00`00Oomoo`1X
Ool00`00>YdjW@03>Yd30004>Yd300000cZL>YdjW@0300001CZL>YdjW3ZM>Y`00`0000@jO3ZM>W`j
W@<0008jO003>WdjO3Yl00<000@jO0<000DjO0<001aoo`03001oogoo01moo`03001oogoo00eoo`00
5goo00<007ooOol04Goo00<007ooOol0JGoo0P0001<jW3ZM>Y`jW@00>Yd003jM>Y`jW@00>YdjO000
>W`nWCYl000jO00200004cjM>W`nW@00>YdjO000>W`nWCYl000jO3Ym000nWCYl?YdjO000008jO005
000nOCYl>Wd00002>W`200001cYm>W`jO000>W`fG00001]oo`03001oogoo01moo`03001oogoo00eo
o`005goo0P004Woo00<007ooOol0JGoo00@003ZM0000008jW@03000jWCZM0080008jW@03000jWCYm
00800005>Yd003Ym>W`jO@0200001CZL>Yd003Ym>W`00P0000<jWCYl00000SYl0P0000<jO3Ym0000
0cYl0P000SYl00@003Yl>W`jO080008jO003000jG3YL008001Uoo`03001oogoo01moo`03001oogoo
00eoo`005goo00<007ooOol04Goo00<007ooOol0JWoo00<003Il>Yd00P0000DjW000>W`jWCYl00<0
0004>W`jWCYl>Yd3000013ZM>W`nWCYl0`0000@jO3ZM>W`nW@<00004>WdjO3Ym>W`300000cYl>Wdj
O002>W`300001CIl>W`jO3Yl=W`00`0000@fFcYl=U`jO08001Ioo`03001oogoo021oo`03001oogoo
00eoo`005goo00<007ooOol04Goo00<007ooOol0JWoo00<003ZM>Yd00SZM0P000cZM014jW3ZM000j
WCYl>YdjOCZM>W`003Yl>WdjO3Ym>W`jO@00008jO005>WdjO3Yl>W`00006>W`00`00>W`jO005>W`0
0`00>W`jO005>W`00`00>U`jG004>U`00`00Oomoo`0COol00`00Oomoo`0QOol00`00Oomoo`0<Ool0
01Moo`03001oogoo015oo`03001oogoo06Yoo`<00003=W`jWCYl00<00003>W`jWCYl00<00004>W`j
WCYl>Yd3000013ZM>W`nWCYl0`0000@jO3ZM>W`nW@<00004>WdjO3Ym>W`300000cYl>WdjO002>W`3
00001CIl>W`jO3Yl=W`00`0000@fFcYl=U`jO0<0019oo`03001oogoo029oo`03001oogoo00aoo`00
5Woo00<007ooOol04Woo00<007ooOol0Jgoo00<003Ym00000cZM00<003Yl00000SZM01HjW000>W`0
03Yl>YdjO@00>W`jO@00>WdjO3Ym000jOCYl000jO3Ym>W`0008jO005000jO3Yl>W`00002>W`00`00
>W`jO002>W`01000>W`jG00013Yl00@003YL=U`000<jG004000fFcIL000AOol00`00Oomoo`0ROol0
0`00Oomoo`0<Ool001Ioo`03001oogoo019oo`03001oogoo06]oo`03000jWCIl00800004>Yd003ZM
=W`2000013ZM000jWCYl0P0000DjWCYl000fO3Ym00800005>W`nW@00>WdfO00200001CZM>W`003Yl
>Wd00P0000DjO3Ym000jOCYl00800006>WdjO000=U`jO3IL0P000SYl00`003IK>U`fF`00=U/jO000
>U`fFcYL000@Ool00`00Oomoo`0ROol00`00Oomoo`0<Ool001Ioo`8001=oo`03001oogoo06aoo`04
000jWCYm>Yd300000cYm>W`jO@0300000cYm>W`jO@03000013Ym>W`jOCYl0`0000@jO3Ym>W`jO0<0
00@jO0<000@jO0<00005>W`jG3Yl>U`jO003000013YL=U`jG3IL0`0000@fFcIL=U/fG08000eoo`03
001oogoo02=oo`03001oogoo00aoo`005Woo00<007ooOol04Woo00<007ooOol0K7oo02/003Il>Ydf
O3ZM=W`003Il>YdfO3ZM=W`003Il>YdjO3ZM=W`003Yl>WdfO3Ym>W`jO@00>WdjO3Ym=W`jOCYl000f
O3Ym>W`jOCIl>Wd003Yl=W`jO@02>W`063Il000fG3Yl=U`jO3IL>W`fG000=U/jG3IK>U`fFcYL000j
G3IK>U`fFcYL=U/000aoo`03001oogoo02Aoo`03001oogoo00]oo`005Woo00<007ooOol04Woo00<0
07ooOol0K7oo0`0000<jWCYm>Yd00`0000<jOCYl>Wd00`0000<jOCYl>Wd00`0000@jOCYl>WdjO0<0
0004>W`jOCYl>W`30004>W`30004>W`300001CYl>U`jO3YL>W`00`0000@jG3IL>U`fG0<00004=U/f
G3IK=U`30009Ool00`00Oomoo`0UOol00`00Oomoo`0;Ool0009oo`8000Aoo`8000=oo`<000Ioo`03
001oogoo019oo`03001oogoo06eoo`17000jO@00>YdfO000=W`jO@00>YdfO000=W`jO@00>YdjO000
=W`jO@00>WdfO3Ym000jOCIl000jO3Ym=W`003Il>W`003Ym>W`jO@00>W`fG000=W`jOCYl000fFcYL
000jO3IL>W`fG000=U/jG000>U`fFcYL000fG3Hk000fFcYL=U/0038k=S/00008Ool00`00Oomoo`0U
Ool00`00Oomoo`0;Ool00005Ool007ooOol00008Ool01000Oomoo`0017oo00<007ooOol04goo00<0
07ooOol0KGoo01<003Im>Wd003ZM>Wd003Il>Wd003Ym>W`003Yl>Wd003Ym>W`00002>W`200000cYl
>Wd00002>W`01000>W`jO@000cYl00D003Yl>W`003Il008jO007000jO3Yl000jG3IL>U`00P00014j
G3Yl000jG3IK=U`003YL=U`003Hk=U`f>`00=U/fG00000<f>`03001oogoo00Eoo`03001oogoo02Eo
o`03001oogoo00]oo`0000Eoo`00Oomoo`0000Qoo`04001oogoo0004Ool3000DOol00`00Oomoo`1]
Ool00`00=W`jO@0300000cYm=W`jO@0300000cYm=W`jO@03000013Ym=W`jOCIl0`0000<fO3Ym=W`0
0`0000@fO3Ym=W`jO0<00004>W`fG3Yl=U`300001CIL>U`fFcYL=U`00`0000@fFcYL=U/jG0<00004
>U`f>cIL=S/30000138k=S`b>cHk0P0017oo00<007ooOol09Woo00<007ooOol02goo00001Goo001o
ogoo000027oo0`001Goo2@003Woo00<007ooOol0KGoo01@003Ym=WdjOCIl000jO3Ym=W`jOCYl000j
O3Ym>W`jOCYl000jO3Ym0cYl00<jO@00>W`013Yl00<003Yl>W`013Yl00@003Yl>W`fO0<jO009000j
G3IL>U`fG3YL=U`jG000008fG00<>U`fFcIL=U`003Hk=U/f>cIL=S/fF`001SHk00D007ooOomoo`00
02Uoo`03001oogoo00Yoo`0000Eoo`00Oomoo`0000Uoo`03001oogoo00Aoo`03001oogoo00Iooa00
06moo`800003=W`jO@0000800003>WdfO3Ym00<00003>WdfO3Ym00<00004>WdfO3Ym=W`300000cIl
>WdfO003000013Il>WdfO3Yl0`0000@jO3IL>W`fG0<00005=U`jG3IK>U`fG00200001CYL=U/jG3IK
>U`00P0000Df>cYL=S/fG3Hk00800005=S/b>cHl<S/f>`0300000goo001oo`0XOol00`00Oomoo`0:
Ool0009oo`8000Yoo`<000Aoo`03001oogoo01Aoo`03001oo`0000l005moo`0E000fO000=WdjO@00
=Wd003Ym=W`jO@00>Wd003Ym>W`003Il>W`003Ym008jO004000jO3Il0002>W`01000>W`fO0000cYl
018003IL>U`003Yl=W`jO000>U`fG000=U`jG3IL>U`003IL0002=U`033YL=U/003Hk000f>cIK=S/f
G000=S/000@f>`04000b6S8K000ZOol00`00Oomoo`0:Ool001Eoo`03001oogoo01Aoo`03001oogoo
00mooa00051oo`07000fO000=W`003Il>Wd00P0000XfO000=W`jO@00>WdfO000=W`jO@80000;=W`j
O@00>WdfO000=W`jO@00>WdfG002000013Ym=W`003IK0`0000DfG3Yl000jG3IK00800005>U`fF`00
=U/fG00200001CIK000b>cHl=S/00P0000DjG000=S/b6SHk00800006<S/0038J<Q/b6S8K0P00:7oo
00<007ooOol02Woo000FOol00`00Oomoo`0COol00`00Oomoo`0OOol@0010Ool00`00=WdfO0030000
0cIl=WdfO00300000cIl>Wd00002000013Ym=W`jO3Yl0`000SYl00PfO000000003Il>W`fO3Yl1000
00=?OU=nDgh00`0000@fG3YL=U`fG0<00004=U`fFcIL=U/20005=S/200001C8k=S/b>cHk<S/00P00
00Lb6c8J<Q/b6S8K<QX0000WOol00`00Oomoo`0:Ool001Ioo`03001oogoo01=oo`03001oogoo02mo
oa00031oo`80000N>WdfO3Ym000jOCIl>WdfO3Ym000jOCIl>WdfO000=W`jOCIl>WdfO3Ym000jOCIl
>WdfO3Ym000jO3IL0`0000Q?OU=oCgiCOdmnDgm?OU=o0P00020fFcYL=U/jG3IK000fFcYL=U/fG3IK
000f>cHl<S/f?3Hk=S`003Hk<Q/f>c8J=S/b6`00<QXb6c8J<Q/b6S8K0P009goo00<007ooOol02Goo
000FOol00`00Oomoo`0COol00`00Oomoo`0oOol@000POol01@00=Wd003Im=W`00`0000<fO3Im=W`0
0`0000<fO3Ym00000P0000@jOCIl>W`jO0<0008jO005=W`00000001?OP02Dgh20002Dgh01U=oCgiC
OU=nDgm?OP<0008fG0800004=U/fG3IK=U`30004=S/30000138k=S/b>cHk0P0000Pb6S8K<QXb6`00
;MX]f@009Woo00<007ooOol02Goo000FOol00`00Oomoo`0COol00`00Oomoo`1?Ool@000AOol01`00
=Wd00000=W`003Il0080000@>WdfO000=W`003Il>Wd003Ym000jOCIl>Wd003Yl=U`3000024mnDgm?
OU=oCgiCOdmnDgl3000025=oCgiCOdmnDgm?OU=oCgh300005CHk000fFcYL=U/0038k=S`003Hl<S/f
?000<Q/b6P00<Q/f>`00<Q/]nP0200001c8K<QX002WI;MXYf@0002Eoo`03001oogoo00Uoo`005Woo
00<007ooOol04goo00<007ooOol0Ggoo400000Eoo`00=W`fOCIl00800003=WdfO3Im00<00003>Wdf
O0000080008fO0H00003CgiCOTmn0080009COP07Dgm?OU=nDgiCOdmnDgh00P0000E?OU=nDgiCOdmn
009COP04Dgl00000=S/200001SIL000f>c8k=S/0008f>`04000b6c8K<Q/3000012gj<OXanS7j0P00
00H]fBgJ;MT]fRgI000TOol00`00Oomoo`09Ool001Ioo`03001oogoo01=oo`03001oogoo06mooa00
0004>Wd003Ym=W`200002E=oCgiCOdmnDgm?OU=oCgiCO`0200002DmnDgm?OU=oCgiCOdmnDgm?OP03
00001dmnDgm?OU=oCgiCOdmn00D00004<S/f>c8k=S`300004CHK<QXb6c8J=Q/0038K;OXb6bgj<Q/0
02gJ:MT]fRWI;MX00P0097oo00<007ooOol027oo000FOol00`00Oomoo`0COol00`00Oomoo`1aOol2
00000cIl=Wd0000200000cIm=W`fO@0200000cIl>Wd0000?00001Dmn000005=oCgh00U=n00ICOdmn
DgiCOU=oCgh200000e=oCgiCOP020003Dih30002=S/0138k=S/f>`001C8K0P0000@anRgj<OXanP<0
0003;MT]fP00008UV080029oo`03001oogoo00Qoo`005Woo00<007ooOol04goo00<007ooOol0LGoo
00h003IL000fO3Im000fO@00>WdfO000=U`003Il0P0000ICOdmnDgm?OU=oCgh300001DmnDgm?OU=o
Cgh04P0000QCWe=nDimCOU>ODgiCWe=n0`0000Xb>cHl0000038J=Q/b6S8K000anP800005;OX002Vi
;MTY^@0300001B5g9IPUN2FH00008Goo00<007ooOol027oo000GOol00`00Oomoo`0COol00`00Oomo
o`1aOol02@00=W`003Il000fO3Im000fO@0400002dmnDgm?OU=nCgiCOdmnDgi?OU=oCgh00P0000QC
OdmnDgi?OU=oCgiCOTmn0P000U=n00ECOdmnDgiCOU=o01800005<QX00000<Q/00004;OX200001RWI
:KTYfBVi:MT000@UV080021oo`03001oogoo00Qoo`005goo00<007ooOol04goo00<007ooOol0LGoo
00<003Im=U`01P0000ACOdmnDgm?OP80000;Dgm?OU=oCgiCOdmnDgm?OU=oCgiCO`02000024mnDgm?
OU=oCgiCOdmnDgl200000dmnDgm?OP0200001U>ODgiCWe=nDimCOP80000:DimCOU>ODgiCWe=nDimC
OU>ODghB00001RFH8GL001Cd6?D001moo`03001oogoo00Qoo`005goo00<007ooOol04goo00<007oo
Ool0LGoo100000=COdmnCgh00P000dmn00=COdmnCgh00`0000YCOTmnDgm?OU=nCgiCOdmnDgi?OP<0
0007CgiCOdmnDgi?OU=oCgh00`0000YCOU>NDgiCWe=nDiiCOU>ODgiCWP<000ICWP800003EiiCWP00
008000@]nP800003:KTYfBVi014001Qoo`03001oogoo00Moo`005goo00<007ooOol04goo00<007oo
Ool0Kgoo0`0000QCOdmNDgm?GU=oCeiCOdmN0P0000MCOdmnDgm?OU=oCgiCO`0200002dmnDgm?OU=o
CgiCOdmnDgm?OU=oCgh00P0000=COdmnDgl00P0000=?OU>ODgh00P0000]CWe=nDimCOU>ODgiCWe=n
DimCOU>O0080000;DgiCW`00001CWUNNDiiGWe>NEiiCWP0300002Bgj000U^000:KT]fP008GPQE`02
00001QSe5?@Hm@0010h000Iooa0000Qoo`03001oogoo00Moo`005goo00<007ooOol04goo00<007oo
Ool0Jgoo100000=COdmNCgh00P000dmn00ECOdmnCgi?OU=o00800003CgiCOdmn009?OP0?Dgm?OP00
001COdmnDgi?OU=oCgiCOTmnDgm?OU=n00<0009COP05DgmCOU=nDgiCO`0300002U>ODgiCWU=nDimC
OU>NDgiCWe=n0`0000]CWUNNDiiGWU>NEiiCWUNNDiiGWU>N00<00008:KT000008GLQEb5g8EL0008H
m@0400043P0>000FOol90009Ool001Moo`03001oogoo01=oo`03001oogoo06Qoo`<00009CeiCOdmN
Dgm?GU=oCeiCOdmN00800008Dgm?GU=oCeiCOdmNDgm?GP800007Dgm?OU=oCgiCOdmnDgl00`0000MC
OdmnDgm?OU=oCgiCO`02000035=nDgl00000DgiCWdmnDimCOU>OCgiCW`<00006DimCOU>ODgiCWe=n
0P0000=GWe>N00000P0000MCWUNNDiiGWe>NEiiCWP0200000eNnEkd0000200002B5G9GPQE`004;<0
01Cd00003@02000MOol00`00Oomoo`08Ool001Moo`03001oogoo01=oo`03001oogoo06Eoo`<00003
Cei?OdmN00800009Dgm?GTmnCeiCOdmNCgi?GU=o00800003CgiCOdmn009?OP03Dgm?OTmn008000=?
OP05Dgm?OTmnCgiCO`0200000dmnDgm?OP0200001U=oDgiCOU=nDgmCOP800005DgmCOU=nDgiCO`03
Dgh01E=o000005=nDil00P0000MCWUNNDiiGWU>NEiiCWP03000015>NEih000001eNn100000DD]12c
00003P@>008001eoo`03001oogoo00Qoo`0067oo00<007ooOol04Woo00<007ooOol0H7oo1@0000Q?
GU=oCeiCOdmNDgm?GU=o0P0000U?GU=oCeiCOdmNDgm?GU=oCeh00P0000QCOdmNDgm?GU=oCeiCOdmN
0P0000QCOdmnDgm?OU=oCgiCOdmn0`0000Y?OU=oDgiCOdmnDgmCOU=oCgiCO`800009CgiCWe=nDim?
OU>ODgiCWdmn00<0000;DiiGWe>NEimCWUNODiiGWe>NEimCWP03000035NmEkiG_E^nEkeG_UNmFkh0
05_MEmaKg@H001eoo`03001oogoo00Uoo`0067oo00<007ooOol04Woo00<007ooOol0FWoo1P000dmN
00a?GdmN000004moCei?OTmNCgm?GTmnCeh3000024mNDgm?GTmnCeiCOdmNCgh20003Cgh01E=oCgi?
OTmnDgl00P0000=?OU=oCgh00`000e=n0P000U=n00ECOe=nDgiCOU=o00=COP80009COP04DgmCOU=n
Dgh20002Dih200002UNNDiiGWU>NEiiCWUNNDiiGWP000UNn0P001ENn00<005_MFmd00e_M00@005_j
FoX001ioo`03001oogoo00Uoo`0067oo00<007ooOol04Woo00<007ooOol0EGoo1@0000ACOdmNCgm?
GP800007Dgm?GU=oCeiCOdmNDgl00P0000U?GU=oCeiCOdmNDgm?GU=oCeh00P0000QCOdmNDgm?GU=o
CeiCOdmN0P0000QCOdmNDgm?GU=oCeiCOdmN0`0000Q?OU=oCgiCOdmnDgm?OU=o0`0000UCOdmnDgmC
OU=oCgiCOe=nDgl00P0000YCOU>O000005>NEimCWUNODiiGW`800005DiiGWe>NEimCWP020003Ekh0
3ENmEkh00000EkeK_P00FmeGg5_MEmaKg@00009KnP8001aoo`8000aoo`0067oo00<007ooOol04Woo
00<007ooOol0DGoo100000=?GdmNCeh00P000dmN00=?GdmNCeh00P000dmN00A?GdmNCei?GP<00008
Cei?OdmNCgi?GTmoCei?OP<00007Cgi?GU=oCei?OTmNDgl00P0000=?OU=oCgh00`0000=?OU=nDgh0
0P000U=n00ECOe=nDgiCOU=o009COP<0009COP06DgmCOU=nDgiCOe=n0`000e>N00IGWU>NDiiCWUNN
Dih200000eNNDih00009Ekh40003Fmd00`00FoYKnP02000NOol00`00Oomoo`0:Ool001Qoo`03001o
ogoo019oo`03001oogoo04aoo`D00009Cei?GdmNDem?GTmOCeiCGdmN00800006Dgm?GTmoCeiCOdmN
0P0000QCOdmNDgm?GU=oCeiCOdmN0P0000UCOdmNDgm?GU=oCeiCOdmNDgl00P0000M?GU=oCeiCOdmN
Dgm?GP03000024mnDgm?OU=oCgiCOdmnDgl200002TmnDgm?OU=oCgiCOdmnDgm?OU=o0P0000=COU=o
Cgh00`0000=CWUNODih00`0000QCWUNODiiGWe>NEimCWUNO0`000eNn00YG_ENnEkiG_UNmEkh005_M
EmeKgPL001ioo`03001oogoo00]oo`0067oo00<007ooOol04Woo00<007ooOol0AGoo1`000dmN00E?
GdmN000004mO00=?GP05Cem?GTmNCei?G`0200000dmNCem?GP02Ceh01DmO000004mNCel00dmN00=?
GdmNCeh00`0000Q?OTmNCgm?GTmnCei?OdmN0P0000=COdmNCgh00P0000=?OU=nDgh00P000U=n00IC
OdmnDgiCOU=oCgh30003Dgh01U=oDgiCOU=nDgmCOP<000UCWP@0009CWP03Eih00000009G_P@000=G
_P8000=Kg@03EmeKg@00009Kn`8001moo`03001oogoo00]oo`0067oo00<007ooOol04Woo00<007oo
Ool0=goo3P0000E?GTmOCei?GdmN00800007Cem?GU=OCei?GdmNDel00P0000U?GU=OCei?GdmNDem?
GTmOCeh00P0000I?OdmNDgm?GTmoCeh3000024mNDgm?GU=oCeiCOdmNDgl2000024mNDgm?GU=oCeiC
OdmNDgl300001e=oCgiCOdmnDgm?OU=o00<00008Dgm?OU=oCgiCOdmnDgm?OP800006Dgm?OU=oCgiC
Odmn0P0000=GWe>N00000P0000YCWUNODiiGWe>NEimCWUNODiiGW`<00003EkiC_UNn009G_P03DkiG
_UNn00D00003EmeKgUOM00800005Go]Kn`00Dk@0000NOol00`00Oomoo`0<Ool001Qoo`03001oogoo
00Aoo`@000]oo`03001oogoo02moo`L0009?GP03Cem?GTmN008000=?GP05Cem?GP00001?G`03Ceh0
0dmOCei?GP030002Ceh014mOCei?GTmN0`0000=?GTmOCeh00TmN00=?GdmNCeh00`000TmN00A?GdmN
Cei?GP80009?GP06Cem?GTmNCei?GdmN0P0000=?OdmNCgh00`0000=COTmnDgl00P0000=COU=oCgh0
0U=n00=COdmnDgh00P0000E?OU=nDgiCOdmn009COP05Dgl00000DgiCO`020007Dih20007Dih20002
Ekh20007Ekh01000EmeKgEOM2@007goo00<007ooOol037oo000IOol00`00Oomoo`05OolJ000@OolE
00001DmOCei?Gd]NCel00P0000M;GTmOCei?Gd]NCem?GP0200001DmOCei?GdmNCel00P0000Q?GTmO
Cei?GdmNCem?GTmO0P0000M?GTmOCeiCGdmNCem?GP0200002DmOCeiCGdmNCem?GU=OCei?G`020000
1TmNCgm?GU=oCei?O`800008CeiCOdmNDgm?GU=oCeiCO`<00008Dgm?OU=oCgiCOdmnDgm?OP<00007
CgiCOdmnDgm?OU=oCgh00`0000M?OU=oCgiCOdmnDgm?OP0300002U>NEimCWU>ODiiGWe>NDimCWUNO
0`0000YGWe>N000005NoDiiG_U>NEkmCWP<0009G_P80000<EmeKgUOMFmiGg@00Fo]Ko5_k001GeP00
7goo00<007ooOol03Goo000IOol00`00Oomoo`07Ool2000014mNBei?Gd]N0P0000I?Gd]NCei;GTmO
Beh200001TmOBei?GTmNCem;GQ800005Cem?GTmNCei?G`0200000dmNCem?GP02Ceh20002Ceh00dmO
Cei?GP020003Ceh014mOCei?GTmN0P000TmN00E?GdmNCei?GTmO00800003Cei?GdmN009?GP<00003
Cei?GdmN009?GP05Cem?GP00001?G`03Ceh00dmOCei?GP020003Ceh01TmOCei?GTmNCem?GP800006
Cem?GTmNCei?GdmN0P0000=?GdmNCeh00`0000=COTmnDgl00P0000U?OU=oCgiCOTmnDgm?OU=nCgh0
0P000U=n00ICOdmnDgiCOU=oCgh200000e=oCgiCOP020003Dih3000:Dih3000:Ekh400001E_MEmeK
gUOM00000U_l00AKn`00EmH001moo`8000moo`006Goo00<007ooOol02Goo0P0000A;?TmOBci?G`80
0006Bei?Gd]NCem;GTmO0P0000I;GTmOBei?Gd]NCel2000014]NCem;GTmO0P0000E;GTmOBei?Gd]N
00800008Cem;GTmOBei?Gd]NCem;GP800005Cem;GTmOBei?G`0200001D]NCem;GTmOBeh00P0000M?
GdmNCem;GTmOCei?G`0200001dmNCem;GTmOCei?Gd]N00800006Cem?GTmOCei?GdmN0P0000M?GdmN
Cem?GTmOCei?G`0300001U=OCei?GdmNDem?GP<0000?Cei?GdmNDem?GTmOCeiCG`00Cgm?GU=oCei?
OdmN00@00008Dgm?OU=oCgiCOdmnDgm?OP800009Dgm?OU=oCgiCOdmnDgm?OU=o00<00007Dgm?OU=o
CgiCOdmnDgl00`0000QCWe=nDimCOU>ODgiCWe=n0P0000MCWe>NEimCWU>ODiiGW`0200000e>NEkl0
000200002eNoDiiG_U>NEkmCWUNn001KgUNmFmh01@0000IKo5_kFo`005_G000OOol00`00Oomoo`0>
Ool001Uoo`03001oogoo00]oo`800004Cem;GTmNBeh200001TmNBei?Gd]NCei;GP80009?GP04Cem;
GTmNCeh20002Ceh01TmOBeh00000Cem;GP9?GP05Cel00000Cei?G`03Ceh00dmOCei?GP020003Ceh0
1DmOCeh00000Cel00dmN00E?G`00001?GTmO00=?GP03Cem?GP00008000=?GP03Cem?GTmN008000=?
GP03Cem?GTmN008000=?GP05Cem?GTmNCei?G`0200000dmNCem?GP02Ceh01DmOCeh00000Cel00dmN
00A?GdmNCei?GPD000=?OP0;Dgl00000CgiCOdmnDgi?OU=oCgiCOP0200002TmnDgi?OU=oCgiCOTmn
Dgm?OU=n0P0000=?OU=nDgh00P0000=CWU=nDil00P0025>N0`000U>N0P000eNN00ACWUNNEiiGWP<0
009G_P800009FmiG_EONEkeKgUNm001Kg5_l00D0021oo`03001oogoo00ioo`006Goo00<007ooOol0
3Goo0P0000A;?TmOBci?G`<00005Cem;GTmOBei?G`0200001T]NCem;GTmOBei?G`800004Bei?Gd]N
Cel3000014mOBei?Gd]N0`0000M;GTmOBei?Gd]NCem;GP03000014]NCem;GTmO0P0000E;GTmOBei?
Gd]N00<00007Bei?GdmNCem;GTmOCeh00P0000I?GdmNCem;GTmOCeh300001DmNCem?GTmOCeh00P00
00Q?GdmNCem?GTmOCei?GdmN0`0000I?GU=OCei?GdmNDel200000dmNDem?GP0300000dmNDgm?GP02
00001U=oCgiCOdmnDgm?OP800008Dgm?OU=oCgiCOdmnDgm?OP<00009CgiCOdmnDgm?OU=oCgiCOdmn
00<00007DgiCWe=nDimCOU>ODgh00P0000UCWe=nDimCOU>ODgiCWe=nDil00`0000]G_U>NEkmCWUNn
DiiG_e>NEkiCWUNo00<0000>FmiG_E_NEkeKgUNm001Kg5_mFmaKo000FoT0021oo`03001oogoo00mo
o`006Goo00<007ooOol03goo0P0000E?GT]NCem;GTmN00800005Bei?GT]NCem;GP0300001D]NCei?
GTmOBeh00P0000E?Gd]NCei?GTmO00800003Cei?Gd]N009?GP80009?GP06Cem?GTmNCei?GdmN0P00
00A?GdmNCei?GP80009?GP04Cem?GTmNCeh20002Ceh01DmOCei?GTmNCel00P0000=?GTmOCeh00TmN
00E?GdmN000004mO00=?GP05Cel00000001?G`03Ceh01DmOCei?GTmN00000dmN00=?GdmNCeh01000
00=?OU=oCgh00Tmn00=COdmnCgh00`000Tmn00=COdmnCgh00P0000U?OU=nCgiCOdmnDgi?OU=oCgh0
0P0000ICOdmnDgi?OU=oCgh200002e=oDgh00000DimCOU>NDgiCWe=nDih00`001U>N00<005>NEih0
0`000eNN00ACWUNNEiiGWP80009G_P<00006FmiG_@00FmaKo5_L0P0000=Kn000Ool087oo00<007oo
Ool03goo000IOol00`00Oomoo`0AOol200001D/nCem;?TmOBch00P0000I?Gd]NCem;GTmOBeh20000
1DmOBei?Gd]NCel00P0000E;GTmOBei?Gd]N00800005Cem;GTmOBei?G`02000024]NCem;GTmOBei?
Gd]NCel2000014]NCem;GTmO0`0000E?Gd]NCem;GTmO00800007Cei?Gd]NCem?GTmOBeh00`0000I;
GTmOCei?Gd]NCel200001TmNCem?GTmOCei?G`800008Cei?GdmNCem?GTmOCei?G`D00004Dgm?GU=o
Ceh200002E=oCeiCOdmNDgm?GU=oCeiCO`0200001DmnDgm?OU=oCgh00`0000Q?OU=oCgiCOdmnDgm?
OU=o0P0000Y?OU=o000004mnDimCOU>OCgiCW`800008DgiCWe=nDimCOU>ODgiCW`80000:DgiCW`00
001CWUNNDiiGWe>NEih300002eNnDih00000FkiG_E^nEkeK_UNmFkh02@008Goo00<007ooOol047oo
000IOol00`00Oomoo`0BOol4000014]NCei;GTmO0`0000E?Gd]NCei;GTmO00800003Cei?Gd]N009?
GP<00004Cei?Gd]NCeh30002Ceh00dmOBeh000020003Ceh014mOCei?GTmN0P000TmN00=?GdmNCeh0
0P000dmN00=?GdmN00000P000dmN00A?GdmNCei?GP80009?GP04Cem?GTmNCeh20002Ceh01DmOCei?
GTmN00000dmN00M?G`00000004moCei?OP0200001TmNCgi?GTmoCei?OP<0009?OP06Dgm?OTmnCgiC
Odmn0P0000ICOdmnCgi?OU=oCgh2000025=oCgiCOTmnDgm?OU=nCgh300000e=nDgmCOP02Dgh015=o
DgiCOU=n0`0000MCOU>ODgiCWU=nDimCOP0300002U>NEiiCWUNNDiiGWU>NEiiCWUNN0`0025Nn00D0
05_MFmeKg000009KnP03001oogoo021oo`03001oogoo011oo`006Woo00<007ooOol04Goo00@007oo
Oomoo`800005Cem;?TmOBci?G`0200001D]NCem;GTmOBeh00P0000I?Gd]NCem;GTmOBeh200001DmO
Bei?Gd]NCel00P0000E;GTmOBei?Gd]N00800007Cem;GTmOBei?Gd]NCel00`0000A?Gd]NCem;GP80
0006Cem;GTmOBei?Gd]N0P0000M?GdmNCem;GTmOCei?G`0200003DmNCem;GTmOCei?G`00Cem?GTmO
Cei?GdmN00@00008Dgm?GU=oCeiCOdmNDgm?GP800007Dgm?GU=oCeiCOdmNDgl00P0000Q?GU=oCeiC
OdmNDgm?GU=o0`0000ECOdmnDgm?OU=o00800003CgiCOdmn00<00003CgiCOdmn00<00009CgiCWe=n
Dim?OU>ODgiCWdmn00800003DimCOU>O00800003DiiGWe>N00<00008DiiGWU>NEimCWUNNDih0009G
_P@0000:EkeK_P00001Gg5_MFm`005_iGoX2000POol2000COol001Yoo`03001oogoo015oo`03001o
ogoo00=oo`800005Bei?Gd]NCei;GP0200001DmNBei?Gd]NCeh00`000TmN00=?Gd]NCeh00P0000E;
GTmNCei?Gd]N00800005Cem;GTmNCei?G`0200000dmNCem?GP02Ceh00dmOCei?GP020003Ceh01DmO
000004mNCel00dmN00E?G`00001?GTmO00=?GP05Cem?GP00Cei?G`03Ceh00dmO00000004000014mN
Cem?GTmN0P0000Q?GTmnCei?OdmNCgi?GTmo0P0000M?GTmoCei?OTmNCgm?GP030003Cgh01U=oCgi?
OTmnDgl0009?OP03Dgm?OTmn00@00003DgiCOe=n009COP04DgmCOU=nDgh300000e=nDgmCOP02Dgh0
0e=oDgiCOP030002Dih01UNNDiiCWU>NEiiCWP<00004DiiGWP000007Ekh400001e_MFmaKg@00FoYK
n@00029oo`03001oogoo015oo`006Woo00<007ooOol04Goo00<007ooOol01Goo0P0000E?Gd/nCem;
?TmO00800006Bei?Gd]NCem;GTmO0P0000E;GTmOBei?Gd]N00800005Cem;GTmOBei?G`03000014mO
Bei?Gd]N0`0000M;GTmOBei?Gd]NCem;GP02000014mOBei?Gd]N0P0000e?Gd]NCem;GTmOBeh004mN
Cem;GTmOCei?G`07000014moCeiCOdmN0P0000ICOdmNDgm?GU=oCeh2000025=oCeiCOdmNDgm?GU=o
Ceh300001dmNDgm?GU=oCeiCOdmN00<00007CeiCOdmNDgm?GU=oCeh0100000ACOdmnDgm?OP<00009
CgiCOdmnDgm?OU=oCgiCOdmn00<00003CgiCWe=n00800003EimCWUNO00800009DiiGWe>NEimCWUNO
DiiGWe>N00<0009G_P0:EkeK_UNnEkiG_E^n001KgEOMFmd6000ROol00`00Oomoo`0BOol001Yoo`03
001oogoo015oo`03001oogoo00Moo`800005Bei?GT]NCem;GP0300001D]NCei;GTmOBeh00P0000E?
Gd]NCei?GTmO00800003Cei?Gd]N009?GP06Cel00000Cei?Gd]N0TmN0P000TmN00E?GdmNCei?GTmO
00800006Cei?GdmNCeh004mO0dmN00=?GdmN00001@0000E?GdmNCei?GTmO00800003Cei?GdmN009?
GP05Cel00000Cei?G`03Ceh034mO00000000Cgm?GTmnCei?OdmNCgi?GP800008Cgi?GTmoCei?OTmN
Cgm?GP800003Dgm?OTmn00800003CgiCOU=n0080009COP04DgmCOU=nDgh20002Dgh01E=oDgiCOU=n
Dgl00e=n0`0000=CWUNNDih00U>N00=GWU>N00000P000e>N00AGWU>NDih0009G_P@0009G_P8000EK
g@03001Kne_j0080029oo`03001oogoo019oo`006Woo00<007ooOol04Woo00<007ooOol027oo0P00
00I?Gd/nCem;?TmOBch200001DmOBei?Gd]NCel00P0000E;GTmOBei?Gd]N00800006Cem;GTmOBei?
Gd]N0P0000E?Gd]NCem;GTmO00800005Bei?Gd]NCem;GP0=000014mNCem?GTmO0P0000M?GTmOCeiC
GdmNCem?GP0300001DmNDgm?GTmoCeh00`0000I?GU=oCeiCOdmNDgl2000024mNDgm?GU=oCeiCOdmN
Dgl2000024mNDgm?GU=oCeiCOdmNDgl300001e=oCgiCOdmnDgm?OU=o00800006CgiCOdmnDgm?OU=o
0`0000YCOdmnDgm?OU=oCgiCO`00EimCWP800008EimCWUNODiiGWe>NEimCWP800004EimCWP000007
Ekh400000eOMFmeGg@02000015okFoX000008Woo00<007ooOol04goo000JOol00`00Oomoo`0BOol0
0`00Oomoo`0:Ool200001T]NCem;GTmNBei?G`800005Bei?Gd]NCei;GP020002Ceh00dmOBei?GP02
00001D]NCei?GTmOBeh03@0000=?GTmOCeh00TmN0P000TmN00E?GdmN000004mO00=?GP05Cem?GP00
001?G`03Ceh014mOCei?GTmN0P000TmN00A?GdmNCei?GP80009?GP04Cem?GTmNCeh300001dmNCgm?
GTmnCei?OdmN00800003Cgm?GTmn00<0009COP06Dgl00000DgiCOdmn0U=n00=COdmn00000P000e=n
00=COe=nDgh00`000U=n0P001E>N0`000U>N00EGWU>NDiiCWUNN00<000QG_P04001GgE_MFmd8000S
Ool00`00Oomoo`02Ool20004Ool20004Ool20003Ool001Yoo`03001oogoo019oo`03001oogoo00ao
oa/00004Bei?Gd]NCel200001DmNCem;GTmOCeh00P0000M?GdmNCem;GTmOCei?G`02000014mNCem?
GTmO0P0000I?GTmOCei?GdmNCel300001e=OCei?GdmNDem?GTmO00<00005Cgm?GU=oCei?O`030000
1U=oCeiCOdmNDgm?GP800007Dgm?GU=oCeiCOdmNDgl00`0000QCOdmnDgm?OU=oCgiCOdmn0P0000QC
OdmnDgm?OU=oCgiCOdmn0P0000MCOdmnDgm?OU=oCgiCO`0300002ENODiiGWe>NEimCWUNODiiGW`02
00000e>NEimCWP0200000eNnDkiG_P040002Ekh200002EOMFmiGgE_NEmd005_kGoaKn`02000QOol3
0004Ool01000Oomoo`0027oo00@007ooOol0009oo`006goo00<007ooOol04Goo00<007ooOol03goo
0P000TmN00A?Gd]NCei?GP80009?GP03Cem?GTmN008000=?GP05Cem?GP00001?G`03Ceh01DmOCeh0
0000Cel00dmN00E?G`00001?GTmO00=?GP05Cem?GP00001?G`03Ceh300000dmNCem?GP02Ceh01DmO
000004mNCel00dmN00=?GdmNCeh00P000dmN00=?GdmNCeh00P000dmN00=?GdmNCeh00P0000=?GTmn
Ceh00P0000=COTmnDgl00P0000=COU=oCgh00U=n00=COdmnDgh00`000U=n00ECOdmnDgiCOU=o0080
0003DgiCOe=n008000=CWP8000UCWP<000UG_P@000=Kg@08Emd005_kFoaKn`00EmH002=oo`03001o
ogoo009oo`04001oogoo0008Ool01000Oomoo`000Woo000KOol00`00Oomoo`0AOol00`00Oomoo`0A
Ool300001DmOBei?Gd]NCel00P0000E;GTmOBei?Gd]N00800005Cem;GTmOBei?G`0200001T]NCem;
GTmOBei?G`800005Bei?GdmNCem;GP0300001T]NCem?GTmOBei?G`800005Cei?GdmNCem?GP020000
1TmOCei?GdmNCem?GP800008Cem?GU=OCei?GdmNDem?GP<0000<Cei?OdmNDgm?GP00CeiCOdmNDgm?
GU=o100000M?OU=oCgiCOdmnDgm?OP03000024mnDgm?OU=oCgiCOdmnDgl200001dmnDgm?OU=oCgiC
Odmn00<00007DgiGWe=nDimCOUNODgh00`0000UCWUNODiiGWe>NEil005NoDih00P000eNn00QC_UNn
EkiG_P00FmiG_E_N2P008goo00<007ooOol00goo00@007ooOol000Uoo`8000=oo`006goo00<007oo
Ool04Goo00<007ooOol057oo0P0000E;GTmNCei?Gd]N00<000=?GP05Cel00000Cei?G`03Ceh30000
0dmNCem?GP02Ceh20002Ceh014mOCei?GTmN0P000TmN00A?GdmNCei?GP<00004Cei?GdmNCeh20003
Ceh00dmOCei?GP030002Ceh02DmOCei?GTmNCem?GP00Cei?G`03Ceh6000015=nCgiCOdmn0P0000QC
OdmnDgi?OU=oCgiCOTmn0P000U=n00ICOdmnDgiCOU=oCgh200000e=oCgiCOP0200000e=nDiiCOP03
0007Dih20002Dih200001ENnEiiG_UNNEkh00`000UNn0P0000MKgUOMFmiGgE_NEmd00003Fo`00`00
FoP0000TOol00`00Oomoo`03Ool01000Oomoo`0027oo00@007ooOol0009oo`006goo00<007ooOol0
4Goo2P003goo0`0000E;GTmOBei?Gd]N00800004Cem;GTmOBeh300001D]NCem;GTmOBeh00P0000E?
Gd]NCem;GTmO00800006Cei?Gd]NCem?GTmO0P0000M?GTmOBei?GdmNCem;GP02000014mOCei?GdmN
0`0000I?GTmOCei?GdmNCel2000024mNCem?GU=OCei?GdmNDel4000014mNDgm?GU=o0P0000I?OU=o
CgiCOdmnDgl300001e=oCgiCOdmnDgm?OU=o00<00007Dgm?OU=oCgiCOdmnDgl00`0000QCWe=nDimC
OU>ODgiCWe=n0P0000MCWe=nEimCOU>ODgiGW`0300002ENoDiiG_U>NEkmCWUNnDiiG_`04000015Nm
FmiG_E_N0P0000IKg5olFm`005_H000TOol00`00Oomoo`05Ool2000:Ool20003Ool001]oo`03001o
ogoo015oo`03001oogoo00Mooa@00005Cem;GTmNCei?G`0200000dmNCem?GP02Ceh20002Ceh00dmO
Cei?GP030002Ceh00dmOCeh000020003Ceh01DmOCeh00000Cel00dmN00=?GdmNCeh00P000dmN00E?
GdmN000004mO00=?GP05Cem?GP00Cei?G`02Ceh30002Cgh01E=o000004mnDgl00dmn0P0000MCOTmn
Dgm?OU=nCgiCO`02000024mnDgm?OU=nCgiCOdmnDgh200000dmnDgiCOP020002Dgh02e=o00000000
DimCOU>NDgiCWe=nDih00`000e>N0P000UNN100000AGWUNnEiiG_P800003EkiK_UNm00D000=Ko0<0
02Eoo`03001oogoo01Ioo`006goo00<007ooOol04Goo00<007ooOol06Goo100000E;GTmOBei?Gd]N
00<00004Bei?Gd]NCel200001T]NCem;GTmOBei?G`800005Bei?Gd]NCem;GP0200001DmOCei?Gd]N
Cel00`0000I?GdmNCem;GTmOCeh2000034mOCei?GdmNCel004mOCei?GdmNCem?GP@00008Dgm?GU=o
CeiCOdmNDgm?GP800005Dgm?GU=oCeiCO`0200001dmnDgm?OU=oCgiCOdmn00<00007CgiCOdmnDgm?
OU=oCgh00`0000QCOU>OCgiCWe=nDim?OU>O0P0000QCOU>ODgiCWe=nDimCOU>O0`0000QG_U>NEkmC
WUNnDiiG_e>N100000YKgUNmFmiG_E_NEkeKgP00FoeKg0H002Aoo`03001oogoo01Moo`006goo00<0
07ooOol04Goo00<007ooOol07Goo0`0000=?GTmOBeh00TmN0P000TmN00=?GdmN00000P000dmN00E?
GdmN000004mO00=?GP05Cel00000Cei?G`03Ceh01DmO000004mNCel00dmN00E?G`00Cei?GTmO009?
GPH00004Cei?OTmNCgl200000dmnDgm?OP02Cgh00e=oCgi?OP020003Cgh00e=oCgh0000200001dmn
Dgi?OU=oCgiCOTmn00800003Dgi?OU=o00800003DgiCOe=n00<000=COP04DgmCOU=nDgh300000e=n
DimCOP0200000eNNDiiGWP0200001E>NEiiGWUNNDih00UNN00<005NnEkh0100000UG_U^n001KgE_L
FmeKg000FoT00P0097oo0P006Goo000KOol00`00Oomoo`0@Ool00`00Oomoo`0QOol200001DmOBei?
Gd]NCel00`0000A?Gd]NCem;GP800005Cem;GTmOBei?G`03000014mOBei?Gd]N0P0000e?Gd]NCem?
GTmOBeh004mNCem;GTmOCei?G`05000015=oCeiCOdmN0P0000ICOdmNDgm?GU=oCeh300001dmNDgm?
GU=oCeiCOdmN00<00005CeiCOdmNDgm?GP0200001e=oCgiCOdmnDgm?OU=o00<00008Dim?OU>ODgiC
WdmnDimCOP<00007DgiCWdmnDimCOU>OCgh00`0000MCWUNODiiGWe>NEimCWP0300002e>NEkh00000
EkeG_UNmFkiG_ENnEkd00`0000=Kg5_mFm`01@0097oo00<007ooOol067oo000LOol00`00Oomoo`0?
Ool00`00Oomoo`0SOol30002Ceh00dmOBei?GP020003Ceh01DmO000004mNCel00dmN00E?G`00001?
GTmO009?GP03001?GdmN009?GP03Cem?GP0000D00004Cem?GTmNCeh200001DmnCei?OdmNCgh00`00
00I?OTmNCgm?GTmnCeh20002Cgh01U=oCgi?OTmnDgm?OP800005Dgm?OTmnCgiCO`0200000dmnDgm?
OP0200000e=oDgiCOP020003Dgh01U=oDgiCOU=nDgmCOP<000=COP80009CWP<00007DiiGWU>NEiiC
WUNNDih00`0025Nn00<005_MFmd01@0000=G]000Ool097oo00<007ooOol067oo000LOol00`00Oomo
o`0?Ool00`00Oomoo`0VOol200001D]NCem;GTmOBeh00P0000A?Gd]NCem;GP800005Cem;GTmOBei?
G`0<000014mNDgm?GTmo0P0000I?GTmoCeiCOdmNCgl300001E=oCeiCOdmNDgl00P0000I?GU=oCeiC
OdmNDgl200003TmNDgm?GU=oCeiCOdmNDgl005=oCeiCOdmNDgl400001dmnDgm?OU=oCgiCOdmn00<0
0009DgiCWdmnDimCOU>OCgiCWe=n00<00007DiiGWe>NEimCWUNODih0100000AGWe>N0000009G_P@0
0007EkiG_@00001KgEOLFmd00P0000AKnP00Ek<002Eoo`03001oogoo01Uoo`0077oo00<007ooOol0
3goo00<007ooOol0:7oo4P0000A?GdmNCei?GP80009?GP05Cem?GP00001?G`03Ceh01DmOCeh00000
Cel00dmN00=?GdmNCeh00P0000E?GTmnCei?OdmN00<00005Cei?OTmNCgm?GP030003Cgh015=oCgi?
OTmn100000ACOe=nDgiCOP<00003DgiCOe=n009COP03DgmCOP00008000=COP04DgmCOU=n0002Dih2
00001ENNDiiCWU>NEih00e>N00AGWP00000000MG_PP00004FoYKn`00000VOol00`00Oomoo`0IOol0
01aoo`03001oogoo00moo`03001oogoo02]oo`800005Cem?GTmOBei?G`02000014]NCem?GTmO0P00
00I?GTmOCei?GdmNCel2000014mNCem?GTmO0P0000I?GU=oCei?OdmNDgl300001U=oCei?OdmNDgm?
GP<00005CeiCOdmNDgm?GP0300001DmNDgm?GU=oCeh00P0000=COdmNDgl00P0000=?OU=oCgh00`00
00E?OU=oCgiCOdmn00@00006Dgm?OU=oCgiCOdmn0P0000UCWe=n000005NODiiGWe>NEil00`0000UG
We>NEimCWUNODih005>nEkh010000UNn0P0000MGgE_MEmeKgP00GoaKn`04000UOol00`00Oomoo`0J
Ool001aoo`03001oogoo00moo`03001oogoo02eoo`800003Cei?GdmN009?GP80009?GP03Cem?GP00
008000=?GP05Cem?GP00001?G`03Ceh300000dmNCem?GP02Ceh01DmO000004mNCel00dmN011?GdmN
000004moCei?OTmNCgm?GP00Cei?OdmNCgi?GP@00006Dgm?OU=nDgiCOdmn0U=n0P000U=n00ECOe=n
DgiCOU=o00<00004DgmCOU=nDgh40009Dih2000015>NEih000001eNn10000e_M00L005_kFo]Kn`00
FmH0000UOol2000LOol001aoo`03001oogoo00moo`03001oogoo02moo`800005Cem;GTmOCei?G`03
000014mOBei?GdmN0`0000A?GTmOCei?G`800005Cei?GdmNCem?GP0200001TmoCeiCOdmNCgm?GP<0
000=CeiCOdmNCgm?GU=oCeh004mNDgm?GU=oCeh01@0000A?OU=oCgiCO`<00007Dgm?OU=oCgiCOdmn
Dgl00`0000MCOdmnDgm?OU=oCgiCO`04000015>NDimCWUNO0`0000QGWe>NEimCWUNODiiGWe>N0`00
00EC_UNnEkiG_U>n00=G_P04001KgUOMFmh400000e_kGoaKn`02000VOol00`00Oomoo`0KOol001ao
o`03001oogoo00moo`03001oogoo035oo`8000=?GP03Cem?GTmN008000=?GP05Cem?GP00001?G`03
Ceh3000014mNCem?GTmN0`000TmN00A?GdmNCei?GP80009?GP05Cem?GTmNCei?G`04000014mnDgi?
OU=o0P0000I?OU=oCgiCOTmnDgl200000e=nDgm?OP02Dgh00e=oCgiCOP020003Dgh00e=o00000002
Dih20006Dih40003Dih20002Ekh40002Ekh200001U_NEmeKgEOMFmh0009Ko0D002Eoo`03001oogoo
01aoo`007Goo00<007ooOol03Goo00<007ooOol0=7oo0`0000E?GTmOBei?GdmN00800005Cem?GTmO
Bei?G`03000014mOCei?GdmN0P0000E?GdmNCem?GTmO0080000;Cei?OdmNDgm?GTmo001COdmNCgm?
GP0200000e=oCgiCO`0200001DmnDgm?OU=oCgh00P0000ICOdmnDgm?OU=oCgh3000024mnDgm?OU=o
CgiCOdmnDgl300001U>ODgiGWe=nDimCOP<00007DiiGWe>NDimCWUNODih00`0000QCWUNnDiiG_U>N
EkiCWUNn100000QGgE_NEmeKgP00FoaKfeol10009Woo00<007ooOol077oo000MOol00`00Oomoo`0=
Ool00`00Oomoo`0gOol200001DmOCei?GTmNCel00`0000E?GdmNCei?GTmO00800004Cei?GdmNCeh2
0003Ceh01DmOCeh004mNCel00dmN00=?G`0000000P000dmn00ACOdmnCgi?OP<00004CgiCOdmnDgh3
00001U=nCgiCOdmnDgi?OP<00003DgiCOdmn00800003DimCOU>N008000MCWP8000=CWP80009GWP03
Dih00000008000=G_P800003EkeKgUNm00/002Ioo`03001oogoo01eoo`007Goo00<007ooOol03Goo
00<007ooOol0>Goo0P0000I;GTmOCei?Gd]NCel200004D]NCem?GTmOBei?G`00Cem?GTmOCeh004mN
Cem?GTmOCeh01P0000ACOdmNDgm?GP800008Dgm?OU=oCgiCOdmnDgm?OP800005Dgm?OU=oCgiCO`02
00001dmnDgm?OU=oCgiCOdmn00<00007DgiCWe=nDimCOU>ODgh00`0000ICOU>ODgiGWe=nDil30000
2ENnDiiG_e>NEkiCWUNoDiiG_P0300003E_NEkeKgUNmFmiG_E_N001KoE_LFod005oj008002Moo`03
001oogoo01eoo`007Goo00<007ooOol03Goo00<007ooOol0>goo0P000TmN00A?GdmNCei?GP80009?
GP03Cem?GTmN00X000=?OP05Cgl00000CgiCO`03Cgh01E=o00000000Dgl00dmn00=COdmnCgh00`00
00ACOTmnDgm?OP800003Dgm?OU=n008000=COP<00007DgiCWe=nDiiCOU>ODgh00P000e>N0P0000=C
WUNN00000P000eNN00ACWUNNEih0009G_P<00008EmiG_@00001Ko5_LFod0009Kn@03001oogoo02Eo
o`8001moo`007Goo00<007ooOol03Goo00<007ooOol0?Goo0P0000E?GTmOBei?GdmN00H00004Dgm?
GTmoCeh200000e=oCeiCO`03000015=oCeiCOdmN0`0000I?GU=oCeiCOdmNDgl200003TmnDgm?OU=o
CgiCOdmnDgl005=oCgiCOdmnDgl3000025>ODgiCWdmnDimCOU>OCgh200001e>ODgiCWe=nDimCOU>O
00<00007EimCWUNNDiiGWe>NEih00`0000UG_U>N001G_E^nEkeK_UNmFkh02`009goo00<007ooOol0
7Woo000MOol00`00Oomoo`0=Ool00`00Oomoo`0oOol5000014mNCem?GTmN0P0000I?GTmnCei?OdmN
Cgh300000dmnCei?O`03000014moCgi?OTmn0`0000=?OU=oCgh00Tmn0`0000=?OU=oCgh00Tmn00=C
Odmn00000`000U=n00ECO`00000005=o00=COP03DgmCOU=n00<00003DiiCOU>O00800003DiiGWP00
00800007EiiCWUNNDiiGWU>NEih0100015Nn0P0015_M00<005_jFoX00P009goo00<007ooOol07goo
000MOol00`00Oomoo`0=Ool00`00Oomoo`12Ool300001DmNCgm?GU=oCeh00`0000I?GTmoCeiCOdmN
Cgl2000014mNDgm?GU=o0P0000E?GU=oCeiCOdmN00800006Dgm?GU=oCeiCOdmN0P0000=COdmnDgl0
0P0000=?OU=oCgh00P0000ECOdmnDgm?OU=o00<00007DimCOU>OCgiCWe=nDil00`0000MGWe>NEimC
WUNODiiGW`0300000eNODiiGWP020002Ekh00eNm0000000400001U_MEmaKg@00Go]KnP8002Qoo`03
001oogoo01moo`007Goo00<007ooOol037oo00<007ooOol0AWoo0P0000I?GdmNCei?GTmOCeh20000
1TmoCei?OTmNCgm?GP800004Cgm?GTmnCeh3000014mnCgm?OTmn0P000dmn00=COdmn00000`000U=n
00ECOe=nDgiCOU=o00800003DgiCOe=n009COP05Dgl00000001CO`02Dgh20002Dih30002Dih01ENN
DiiCWU>NEih00`001eNn00@005_MFmeKg@P002Moo`03001oogoo021oo`007Woo00<007ooOol02goo
00<007ooOol0B7oo0`0000ECOdmNCgm?GU=o00<00005Dgm?GTmoCeiCO`0200001DmNDgm?GU=oCeh0
0P0000ECOdmNDgm?GU=o00@00004CgiCOdmnDgl300001U=oCgiCOdmnDgm?OP<00006CgiCOdmnDgm?
OU=o0`0000MGWe>NEimCWUNODiiGW`0300000eNODiiGW`020002Ekh40002Ekh02`00FmiGgE_MEmeK
gP00Go]Kn`00EmH00P009Woo0P008Woo000NOol00`00Oomoo`0;Ool00`00Oomoo`1;Ool300001DmO
Cei?GTmNCel00`0000]?OdmNCgi?GTmo001?OTmNCgm?GTmn00D00003Dgm?OU=n00<0009COP03Dgm?
OU=n00@00003DgiCOe=n009COP80009COP03Dgl00000009CWP<00005EiiCWU>NDiiGWP02Dih30008
Ekh40003Fmd00`00Fo]Kn`0300000goo001oo`0UOol00`00Oomoo`0QOol001ioo`03001oogoo00]o
o`03001oogoo04ioo`80000<CeiCOdmNCgm?GU=o001?OdmNDgm?GTmo1@0000ACOdmnDgm?OP800005
Dgm?OU=oCgiCO`0200001dmnDgm?OU=oCgiCOdmn00<00004CgiCOdmnDgl300001e>ODiiGWe>NDimC
WUNO00@00004DiiGW`000002Ekh40003Ekh200000e_NEmeKgP0900000goo001oo`0UOol00`00Oomo
o`0QOol001ioo`03001oogoo00]oo`03001oogoo051oo`80009?GP03Cem?GTmN00D00004Dgm?OTmn
Cgh200001E=nCgiCOdmnDgh00P0000E?OU=nCgiCOdmn00<00005CgiCOU=nDgm?OP02Dgh40003Dih3
0008Dih30007Ekh4000015_NEmeKgE_M0P000U_l00@005_h0000009oo`03001oogoo02=oo`03001o
ogoo029oo`007Woo00<007ooOol02goo00<007ooOol0Dgoo100000ACOdmnDgm?OP800005Dgm?OU=o
CgiCO`0200001DmnDgm?OU=oCgh00P0000ICOdmnDgm?OU=oCgh2000015=oCgiCOdmn0P0000UCWe=n
000005>ODiiGWe>NDil0100000=CWUNODih00P0000=G_e>N00000`0000MG_U>n000005_NEkeKgP0;
0004Ool00`00Oomoo`0ROol00`00Oomoo`02Ool20004Ool20005Ool00`00Oomoo`02Ool2000<Ool0
01ioo`03001oogoo00]oo`03001oogoo05Ioo`80009?OP03Dgm?OTmn00<0009?OP03Dgm?OP000080
0004CgiCOTmnDgl200001dmnDgm?OU=nCgiCOdmn00<000=CWP03DimCWU>N00<000ICWP<00008EiiG
_UNNEkiGWUNnEiiG_P@00004EkeKgUNmEmh200001E_LFoaKg000FoT00P001Goo00<007ooOol08Goo
00<007ooOol00Woo00@007ooOol000Yoo`05001oogooOol00002Ool00`00Oomoo`09Ool001ioo`03
001oogoo00]oo`03001oogoo05Qoo`<00005Dgm?OU=oCgiCO`0200001DmnDgm?OU=oCgh00P0000AC
OdmnDgm?OP800003Dgm?OU=o00800003CgiCWe=n00800007DimCOU>ODgiCWe=nDil00P0000=CWU>O
Dih00P0000=G_U>N00000`0000=G_e>NEkh00P0000=G_E_NEkd01@0000MKg5_mFm`005_iGoX00006
Ool00`00Oomoo`0OOol30004Ool01000Oomoo`002Woo00<007ooOol017oo00<007ooOol02Goo000O
Ool00`00Oomoo`09Ool00`00Oomoo`1LOol20003Cgh00e=oCgh000020003Cgh01e=o000004mnDgm?
OU=n00<00007DiiCOU>ODgiCWU=nDil00`0000ICWe>NDiiCWU>ODih300001E>NEiiGWUNNDih00eNN
10001UNn00<005_MFmd01P001goo00<007ooOol087oo00<007ooOol00goo00@007ooOol000]oo`04
001oogooOol2000<Ool001moo`03001oogoo00Uoo`03001oogoo05ioo`<0000;CgiCOdmnDgm?OP00
CgiCOdmnDgm?OP0400000e>OCgiCW`0400001TmnDimCOU>OCgiCW`800003DgiCWe=n00800003EimC
WP0000<00004EkiCWUNoDih200000e^nEkh0000200001UNmFmh005_MFmaKg@800003FoX0000000Qo
o`03001oogoo021oo`03001oogoo00=oo`04001oogoo0008Ool01000Oomoo`000goo00<007ooOol0
2goo000OOol00`00Oomoo`09Ool00`00Oomoo`1QOol00`00CgiCO`03Cgh50003Dgh300000e=nDgmC
OP02Dgh4000015>ODgiCWU=n100000MGWU>NEiiCWUNNDiiGWP040007Ekh;0008Ool00`00Oomoo`0O
Ool00`00Oomoo`05Ool20009Ool40003Ool3000;Ool001moo`03001oogoo00Uoo`03001oogoo06=o
o`@00004CgiCOdmnDgl3000015=oCgiCOdmn0`0000I?OU>OCgiCWdmnDil4000015>NEimCWUNO1000
00=CWUNODih00P0000=G_UNm00000`0000eK_UNn000005_MEmeKg@00GoaKn`00EmH00009Ool00`00
Oomoo`0OOol00`00Oomoo`0UOol001moo`03001oogoo00Uoo`03001oogoo06Ioo`800003DgiCOdmn
009COP05Dgl00000001CO`03Dgh20002Dgh00e=o00000002Dih300001UNNDiiCWU>NEiiCWP@000MG
_P@000=Kg@03001Kne_k008000Yoo`03001oogoo01eoo`8002Qoo`007goo00<007ooOol02Goo00<0
07ooOol0J7oo0`0000I?OU=oCgiCOdmnDgl200001DmnDgm?OU=oCgh00`0000ICWUNODiiCWe>NEil3
00000eNODiiGW`020002Ekh400001eNmEkh00000EmeKgUOM00L000]oo`03001oogoo01ioo`03001o
ogoo02Ioo`007goo00<007ooOol02Goo00<007ooOol0Jgoo0`0000=COU=oCgh00U=n00=CO`000000
0P000e>N0`001U>N0`0025Nn100000=KgEOMFmd00P000U_l00<005_h000037oo00<007ooOol077oo
00<007ooOol09goo000OOol00`00Oomoo`09Ool00`00Oomoo`1^Ool200000e=oCgiCO`0200002E=n
Dil00000DiiGWe>NDimCWP0300001U>NEil00000DiiG_`@0009G_P06Dkh00000FmiG_E_N2@003Goo
00<007ooOol077oo00<007ooOol09goo000POol00`00Oomoo`07Ool00`00Oomoo`1aOol30002Dih0
15>ODiiCWU>N0P001U>N0`001eNn1@0000=GgE_NEmd00P0000EKo5_L000005_i008000eoo`03001o
ogoo01]oo`03001oogoo02Qoo`0087oo00<007ooOol01goo00<007ooOol0M7oo0`0000ECWe=nDimC
OU>O00800003DiiCWe>N00800003EkiCWP0000<00003EkmCWUNn00800003EkeKgUNm00/000ioo`03
001oogoo01Yoo`8002Yoo`0087oo00<007ooOol01goo00<007ooOol0Mgoo100000=CWU>ODih00`00
00QCWUNNDiiGWU>NEiiCWUNN100000AG_ENnEkiG_P80009Kg@07Fm`005_jGoX005OD00003Woo00<0
07ooOol06Woo00<007ooOol0:Goo000POol00`00Oomoo`07Ool00`00Oomoo`1kOol300000e>NEimC
WP0400000eNnDiiG_`0200000eNmFkiG_@0600000e_MFmaKg@05000?Ool00`00Oomoo`0JOol00`00
Oomoo`0YOol0021oo`03001oogoo00Moo`03001oogoo07ioo`80009CWP03EiiCWU>N00D000AG_P80
00=Kg@D00003FmH007oo00moo`03001oogoo01Uoo`03001oogoo02Yoo`0087oo00<007ooOol01goo
00<007ooOol0P7oo0`0000MGWe>N000005NnEkeG_P0600000eOMFmeGg@02000015ol000000004Goo
00<007ooOol06Goo00<007ooOol0:Woo000POol00`00Oomoo`07Ool00`00Oomoo`23Ool40004Ekh2
00000eOMFmeKg@08000BOol00`00Oomoo`0GOol2000]Ool0025oo`03001oogoo00Eoo`03001oogoo
08Qoo`H00003FmiGgE_N00800003Fm]Oo000008001Aoo`03001oogoo01Moo`03001oogoo02]oo`00
8Goo00<007ooOol01Goo00<007ooOol0SWoo20005Woo00<007ooOol05Woo00<007ooOol0;7oo000Q
Ool00`00Oomoo`05Ool00`00Oomoo`2/Ool00`00Oomoo`0FOol00`00Oomoo`0/Ool0025oo`03001o
ogoo00Eoo`03001oogoo0:aoo`03001oogoo01Eoo`03001oogoo02eoo`008Goo00<007ooOol01Goo
00<007ooOol0[7oo00<007ooOol057oo0P00;goo000QOol00`00Oomoo`05Ool00`00Oomoo`2/Ool0
0`00Oomoo`0DOol00`00Oomoo`0^Ool0025oo`03001oogoo00Eoo`03001oogoo0:aoo`03001oogoo
01=oo`03001oogoo02moo`008Goo00<007ooOol01Goo00<007ooOol0[7oo00<007ooOol04goo00<0
07ooOol00Woo0P0017oo0P001Goo00<007ooOol07Goo000ROol00`00Oomoo`03Ool00`00Oomoo`2]
Ool00`00Oomoo`0BOol00`00Oomoo`02Ool01000Oomoo`002Woo00<007ooOol07Goo000ROol00`00
Oomoo`03Ool00`00Oomoo`2]Ool00`00Oomoo`0AOol20004Ool01000Oomoo`002Woo00<007ooOol0
7Goo000ROol00`00Oomoo`03Ool00`00Oomoo`2^Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool01000
Oomoo`002goo00<007ooOol077oo000ROol00`00Oomoo`03Ool00`00Oomoo`2^Ool00`00Oomoo`0@
Ool00`00Oomoo`03Ool01000Oomoo`0027oo00@007ooOol001ioo`008Woo00<007ooOol00goo00<0
07ooOol0[Woo00<007ooOol03goo00<007ooOol01Goo0P002Goo10007Woo000ROol00`00Oomoo`03
Ool00`00Oomoo`2^Ool00`00Oomoo`0>Ool2000dOol0029oo`03001oogoo00=oo`03001oogoo0:io
o`03001oogoo00ioo`03001oogoo03=oo`008Woo00<007ooOol00Woo00<007ooOol0[goo00<007oo
Ool03Woo00<007ooOol0<goo000SOol01@00Oomoogoo0000/Goo00<007ooOol03Goo00<007ooOol0
=7oo000SOol01@00Oomoogoo0000/Goo00<007ooOol03Goo00<007ooOol0=7oo000SOol01@00Oomo
ogoo0000/Goo00<007ooOol037oo0P00=Woo000SOol01@00Oomoogoo0000/Woo00<007ooOol02goo
00<007ooOol0=Goo000SOol01@00Oomoogoo0000/Woo00<007ooOol02Woo00<007ooOol0=Woo000S
Ool01@00Oomoogoo0000/Woo00<007ooOol02Woo00<007ooOol0=Woo000SOol01@00Oomoogoo0000
/Woo00<007ooOol027oo0`00>7oo000TOol00`00Ool0002cOol00`00Oomoo`09Ool00`00Oomoo`0g
Ool002Aoo`03001oo`000;=oo`03001oogoo00Qoo`03001oogoo03Qoo`0097oo00<007oo0000/goo
00<007ooOol027oo00<007ooOol0>7oo000TOol00`00Ool0002cOol00`00Oomoo`06Ool2000kOol0
02Aoo`03001oo`000;=oo`03001oogoo00Moo`03001oogoo03Uoo`0097oo00<007oo0000]7oo00<0
07ooOol01Goo00<007ooOol0>Woo000TOol00`00Ool0002dOol00`00Oomoo`05Ool00`00Oomoo`02
Ool20004Ool20003Ool30004Ool2000TOol002Aoo`03001oo`000;Aoo`03001oogoo00=oo`8000Ao
o`04001oogoo0008Ool01000Oomoo`000Woo00@007ooOol002=oo`009Goo00<007ooOol0/goo00<0
07ooOol017oo00<007ooOol00Woo00@007ooOol000Qoo`04001oogoo0005Ool00`00Oomoo`0QOol0
02Eoo`03001oogoo0;=oo`03001oogoo00=oo`03001oogoo00=oo`04001oogoo0008Ool30004Ool2
000TOol002Eoo`03001oogoo0;=oo`03001oogoo00=oo`03001oogoo00=oo`04001oogoo0009Ool0
0`00Oomoo`03Ool00`00Oomoo`0SOol002Eoo``00:Yoo`04001oogooOol20007Ool2000:Ool30003
Ool3000SOol0035ooaL009=oo`03001oogoo009oo`03001oogoo03eoo`00B7oo5`00O7oo00D007oo
Oomoo`00041oo`00Ggoo5`00IGoo00D007ooOomoo`00041oo`00MWoo5P00D7oo0`00@Goo002<OolG
000iOol00`00Ool00011Ool00:=ooaL0029oo`80049oo`00^Woo5`002goo0P00@Woo003AOol<0013
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {241.25, 0}} -> {-0.0029898, -0.00183208, \
0.00360348, 0.00360348}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[48]="]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{702, 418},
WindowMargins->{{16, Automatic}, {Automatic, 8}},
TaggingRules:>{"NextIndexingNumber" -> 5, "IndexEntries" -> {{"i:1", \
"ParametricManifold"}, {"i:2", "EquilibriumSurface"}, {"i:3", "ExpMap"}, \
{"i:4", "ExpMap"}, {"i:4", "FlowComposition"}, {"i:4", "SpecialNulSpace"}}},
StyleDefinitions -> "Textbook.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Introduction"->{
    Cell[2085, 67, 59, 1, 85, "Section",
      CellTags->"Introduction"],
    Cell[2147, 70, 912, 23, 159, "Text",
      CellTags->"Introduction"],
    Cell[3084, 97, 95, 3, 30, "Input",
      CellTags->"Introduction"],
    Cell[180149, 7444, 57, 1, 85, "Section",
      CellTags->"Introduction"],
    Cell[180231, 7449, 57, 1, 40, "Subsection",
      CellTags->"Introduction"],
    Cell[180291, 7452, 354, 6, 59, "Text",
      CellTags->"Introduction"]},
  "Implicit"->{
    Cell[3962, 122, 107, 1, 40, "Subsection",
      CellTags->{"Implicit", "i:1"}],
    Cell[4072, 125, 644, 15, 76, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[4719, 142, 158, 4, 50, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[4880, 148, 128, 3, 25, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[5033, 155, 136, 3, 30, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[5514, 174, 120, 3, 30, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[5637, 179, 81, 1, 25, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[5743, 184, 138, 3, 30, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[6311, 205, 98, 1, 25, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[6434, 210, 344, 7, 90, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[29532, 1049, 184, 4, 25, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[29741, 1057, 411, 8, 90, "Input",
      CellTags->{"Implicit", "i:1"}]},
  "i:1"->{
    Cell[3962, 122, 107, 1, 40, "Subsection",
      CellTags->{"Implicit", "i:1"}],
    Cell[4072, 125, 644, 15, 76, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[4719, 142, 158, 4, 50, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[4880, 148, 128, 3, 25, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[5033, 155, 136, 3, 30, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[5514, 174, 120, 3, 30, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[5637, 179, 81, 1, 25, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[5743, 184, 138, 3, 30, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[6311, 205, 98, 1, 25, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[6434, 210, 344, 7, 90, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[29532, 1049, 184, 4, 25, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[29741, 1057, 411, 8, 90, "Input",
      CellTags->{"Implicit", "i:1"}]},
  "Equilibrium Surface"->{
    Cell[55146, 2103, 97, 1, 40, "Subsection",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[55246, 2106, 252, 6, 25, "Text",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[55501, 2114, 134, 3, 30, "Input",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[55638, 2119, 135, 3, 25, "Text",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[55798, 2126, 203, 5, 30, "Input",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[56349, 2147, 233, 5, 42, "Text",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[56607, 2156, 566, 10, 130, "Input",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[179928, 7434, 172, 4, 25, "Text",
      CellTags->{"Equilibrium Surface", "i:2"}]},
  "i:2"->{
    Cell[55146, 2103, 97, 1, 40, "Subsection",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[55246, 2106, 252, 6, 25, "Text",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[55501, 2114, 134, 3, 30, "Input",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[55638, 2119, 135, 3, 25, "Text",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[55798, 2126, 203, 5, 30, "Input",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[56349, 2147, 233, 5, 42, "Text",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[56607, 2156, 566, 10, 130, "Input",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[179928, 7434, 172, 4, 25, "Text",
      CellTags->{"Equilibrium Surface", "i:2"}]},
  "Exponential Map"->{
    Cell[180682, 7463, 81, 1, 40, "Subsection",
      CellTags->{"Exponential Map", "i:3"}],
    Cell[180766, 7466, 202, 6, 39, "Text",
      CellTags->{"Exponential Map", "i:3"}],
    Cell[180971, 7474, 126, 5, 66, "Input",
      CellTags->{"Exponential Map", "i:3"}],
    Cell[181100, 7481, 134, 3, 39, "Text",
      CellTags->{"Exponential Map", "i:3"}],
    Cell[181259, 7488, 102, 2, 46, "Input",
      CellTags->{"Exponential Map", "i:3"}]},
  "i:3"->{
    Cell[180682, 7463, 81, 1, 40, "Subsection",
      CellTags->{"Exponential Map", "i:3"}],
    Cell[180766, 7466, 202, 6, 39, "Text",
      CellTags->{"Exponential Map", "i:3"}],
    Cell[180971, 7474, 126, 5, 66, "Input",
      CellTags->{"Exponential Map", "i:3"}],
    Cell[181100, 7481, 134, 3, 39, "Text",
      CellTags->{"Exponential Map", "i:3"}],
    Cell[181259, 7488, 102, 2, 46, "Input",
      CellTags->{"Exponential Map", "i:3"}]},
  "Composition"->{
    Cell[182463, 7516, 91, 1, 34, "Subsection",
      CellTags->{"Composition", "i:4"}],
    Cell[182579, 7521, 104, 3, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[183396, 7541, 108, 3, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[183617, 7553, 76, 1, 51, "Subsubsection",
      CellTags->{"Composition", "i:4"}],
    Cell[183718, 7558, 114, 3, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[184776, 7582, 70, 1, 51, "Subsubsection",
      CellTags->{"Composition", "i:4"}],
    Cell[184849, 7585, 200, 4, 56, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[185074, 7593, 179, 4, 64, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[185488, 7610, 123, 3, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[185756, 7622, 219, 4, 64, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[186217, 7638, 97, 1, 39, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[186339, 7643, 172, 4, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[186617, 7654, 81, 1, 39, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[186723, 7659, 162, 4, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[186991, 7670, 122, 3, 39, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[187116, 7675, 147, 4, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[187288, 7683, 121, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[187549, 7695, 70, 1, 51, "Subsubsection",
      CellTags->{"Composition", "i:4"}],
    Cell[187622, 7698, 222, 5, 56, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[187847, 7705, 119, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[187991, 7711, 111, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[188278, 7723, 111, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[188712, 7736, 92, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[188829, 7742, 123, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}]},
  "i:4"->{
    Cell[182463, 7516, 91, 1, 34, "Subsection",
      CellTags->{"Composition", "i:4"}],
    Cell[182579, 7521, 104, 3, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[183396, 7541, 108, 3, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[183617, 7553, 76, 1, 51, "Subsubsection",
      CellTags->{"Composition", "i:4"}],
    Cell[183718, 7558, 114, 3, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[184776, 7582, 70, 1, 51, "Subsubsection",
      CellTags->{"Composition", "i:4"}],
    Cell[184849, 7585, 200, 4, 56, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[185074, 7593, 179, 4, 64, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[185488, 7610, 123, 3, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[185756, 7622, 219, 4, 64, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[186217, 7638, 97, 1, 39, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[186339, 7643, 172, 4, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[186617, 7654, 81, 1, 39, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[186723, 7659, 162, 4, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[186991, 7670, 122, 3, 39, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[187116, 7675, 147, 4, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[187288, 7683, 121, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[187549, 7695, 70, 1, 51, "Subsubsection",
      CellTags->{"Composition", "i:4"}],
    Cell[187622, 7698, 222, 5, 56, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[187847, 7705, 119, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[187991, 7711, 111, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[188278, 7723, 111, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[188712, 7736, 92, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[188829, 7742, 123, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}]},
  "Pitfalls"->{
    Cell[189157, 7757, 56, 1, 85, "Section",
      CellTags->"Pitfalls"],
    Cell[189238, 7762, 95, 1, 40, "Subsection",
      CellTags->"Pitfalls"],
    Cell[189336, 7765, 93, 3, 30, "Input",
      CellTags->"Pitfalls"],
    Cell[189432, 7770, 152, 4, 50, "Input",
      CellTags->"Pitfalls"],
    Cell[189587, 7776, 230, 5, 42, "Text",
      CellTags->"Pitfalls"],
    Cell[189842, 7785, 255, 5, 50, "Input",
      CellTags->"Pitfalls"],
    Cell[208125, 8450, 139, 4, 25, "Text",
      CellTags->"Pitfalls"],
    Cell[208289, 8458, 86, 3, 30, "Input",
      CellTags->"Pitfalls"],
    Cell[208480, 8470, 127, 3, 30, "Input",
      CellTags->"Pitfalls"],
    Cell[208951, 8489, 91, 1, 25, "Text",
      CellTags->"Pitfalls"],
    Cell[209067, 8494, 127, 3, 30, "Input",
      CellTags->"Pitfalls"],
    Cell[209835, 8527, 85, 1, 40, "Subsection",
      CellTags->"Pitfalls"],
    Cell[209923, 8530, 130, 4, 25, "Text",
      CellTags->"Pitfalls"],
    Cell[210056, 8536, 114, 3, 30, "Input",
      CellTags->"Pitfalls"],
    Cell[210195, 8543, 123, 3, 30, "Input",
      CellTags->"Pitfalls"],
    Cell[210719, 8567, 117, 3, 30, "Input",
      CellTags->"Pitfalls"],
    Cell[210966, 8579, 136, 3, 30, "Input",
      CellTags->"Pitfalls"]},
  "Aircraft Example"->{
    Cell[211601, 8609, 90, 1, 40, "Subsection",
      CellTags->"Aircraft Example"],
    Cell[211716, 8614, 100, 3, 30, "Input",
      CellTags->"Aircraft Example"],
    Cell[212507, 8632, 811, 15, 182, "Input",
      CellTags->"Aircraft Example"],
    Cell[213343, 8651, 235, 6, 70, "Input",
      CellTags->"Aircraft Example"],
    Cell[215411, 8699, 476, 8, 110, "Input",
      CellTags->"Aircraft Example"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Introduction", 356765, 14350},
  {"Implicit", 357237, 14363},
  {"i:1", 358200, 14388},
  {"Equilibrium Surface", 359179, 14413},
  {"i:2", 359930, 14430},
  {"Exponential Map", 360693, 14447},
  {"i:3", 361152, 14458},
  {"Composition", 361619, 14469},
  {"i:4", 363688, 14518},
  {"Pitfalls", 365762, 14567},
  {"Aircraft Example", 367030, 14602}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 55, 0, 59, "Title"],
Cell[1797, 53, 35, 0, 33, "Subtitle"],
Cell[1835, 55, 97, 3, 50, "Subsubtitle"],
Cell[1935, 60, 125, 3, 50, "Input"],

Cell[CellGroupData[{
Cell[2085, 67, 59, 1, 85, "Section",
  CellTags->"Introduction"],
Cell[2147, 70, 912, 23, 159, "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{
Cell[3084, 97, 95, 3, 30, "Input",
  CellTags->"Introduction"],
Cell[3182, 102, 672, 10, 237, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[3903, 118, 34, 0, 85, "Section"],

Cell[CellGroupData[{
Cell[3962, 122, 107, 1, 40, "Subsection",
  CellTags->{"Implicit", "i:1"}],
Cell[4072, 125, 644, 15, 76, "Text",
  CellTags->{"Implicit", "i:1"}],
Cell[4719, 142, 158, 4, 50, "Input",
  CellTags->{"Implicit", "i:1"}],
Cell[4880, 148, 128, 3, 25, "Text",
  CellTags->{"Implicit", "i:1"}],

Cell[CellGroupData[{
Cell[5033, 155, 136, 3, 30, "Input",
  CellTags->{"Implicit", "i:1"}],
Cell[5172, 160, 89, 2, 28, "Print"],
Cell[5264, 164, 90, 2, 28, "Print"],
Cell[5357, 168, 142, 3, 40, "Output"]
}, Open  ]],
Cell[5514, 174, 120, 3, 30, "Input",
  CellTags->{"Implicit", "i:1"}],
Cell[5637, 179, 81, 1, 25, "Text",
  CellTags->{"Implicit", "i:1"}],

Cell[CellGroupData[{
Cell[5743, 184, 138, 3, 30, "Input",
  CellTags->{"Implicit", "i:1"}],
Cell[5884, 189, 89, 2, 28, "Print"],
Cell[5976, 193, 90, 2, 28, "Print"],
Cell[6069, 197, 227, 5, 40, "Output"]
}, Open  ]],
Cell[6311, 205, 98, 1, 25, "Text",
  CellTags->{"Implicit", "i:1"}],

Cell[CellGroupData[{
Cell[6434, 210, 344, 7, 90, "Input",
  CellTags->{"Implicit", "i:1"}],
Cell[6781, 219, 253, 5, 47, "Message"],
Cell[7037, 226, 254, 5, 47, "Message"],
Cell[7294, 233, 22066, 807, 186, 9812, 651, "GraphicsData", "PostScript", \
"Graphics"],
Cell[29363, 1042, 154, 4, 24, "Output"]
}, Open  ]],
Cell[29532, 1049, 184, 4, 25, "Text",
  CellTags->{"Implicit", "i:1"}],

Cell[CellGroupData[{
Cell[29741, 1057, 411, 8, 90, "Input",
  CellTags->{"Implicit", "i:1"}],
Cell[30155, 1067, 254, 5, 47, "Message"],
Cell[30412, 1074, 255, 5, 47, "Message"],
Cell[30670, 1081, 24269, 1010, 186, 12695, 862, "GraphicsData", "PostScript", \
"Graphics"],
Cell[54942, 2093, 155, 4, 24, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[55146, 2103, 97, 1, 40, "Subsection",
  CellTags->{"Equilibrium Surface", "i:2"}],
Cell[55246, 2106, 252, 6, 25, "Text",
  CellTags->{"Equilibrium Surface", "i:2"}],
Cell[55501, 2114, 134, 3, 30, "Input",
  CellTags->{"Equilibrium Surface", "i:2"}],
Cell[55638, 2119, 135, 3, 25, "Text",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell[CellGroupData[{
Cell[55798, 2126, 203, 5, 30, "Input",
  CellTags->{"Equilibrium Surface", "i:2"}],
Cell[56004, 2133, 90, 2, 28, "Print"],
Cell[56097, 2137, 91, 2, 28, "Print"],
Cell[56191, 2141, 143, 3, 24, "Output"]
}, Open  ]],
Cell[56349, 2147, 233, 5, 42, "Text",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell[CellGroupData[{
Cell[56607, 2156, 566, 10, 130, "Input",
  CellTags->{"Equilibrium Surface", "i:2"}],
Cell[57176, 2168, 325, 5, 47, "Message"],
Cell[57504, 2175, 122249, 5250, 172, 92709, 4880, "GraphicsData", \
"PostScript", "Graphics"],
Cell[179756, 7427, 157, 4, 24, "Output"]
}, Open  ]],
Cell[179928, 7434, 172, 4, 25, "Text",
  CellTags->{"Equilibrium Surface", "i:2"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[180149, 7444, 57, 1, 85, "Section",
  CellTags->"Introduction"],

Cell[CellGroupData[{
Cell[180231, 7449, 57, 1, 40, "Subsection",
  CellTags->"Introduction"],
Cell[180291, 7452, 354, 6, 59, "Text",
  CellTags->"Introduction"]
}, Open  ]],

Cell[CellGroupData[{
Cell[180682, 7463, 81, 1, 40, "Subsection",
  CellTags->{"Exponential Map", "i:3"}],
Cell[180766, 7466, 202, 6, 39, "Text",
  CellTags->{"Exponential Map", "i:3"}],
Cell[180971, 7474, 126, 5, 66, "Input",
  CellTags->{"Exponential Map", "i:3"}],
Cell[181100, 7481, 134, 3, 39, "Text",
  CellTags->{"Exponential Map", "i:3"}],

Cell[CellGroupData[{
Cell[181259, 7488, 102, 2, 46, "Input",
  CellTags->{"Exponential Map", "i:3"}],
Cell[181364, 7492, 1050, 18, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[182463, 7516, 91, 1, 34, "Subsection",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{
Cell[182579, 7521, 104, 3, 44, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[182686, 7526, 673, 10, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[183396, 7541, 108, 3, 44, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[183507, 7546, 73, 2, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[183617, 7553, 76, 1, 51, "Subsubsection",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{
Cell[183718, 7558, 114, 3, 44, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[183835, 7563, 892, 13, 70, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[184776, 7582, 70, 1, 51, "Subsubsection",
  CellTags->{"Composition", "i:4"}],
Cell[184849, 7585, 200, 4, 56, "Text",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{
Cell[185074, 7593, 179, 4, 64, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[185256, 7599, 108, 2, 70, "Print"],
Cell[185367, 7603, 84, 2, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[185488, 7610, 123, 3, 44, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[185614, 7615, 105, 2, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[185756, 7622, 219, 4, 64, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[185978, 7628, 136, 3, 70, "Output"],
Cell[186117, 7633, 85, 2, 70, "Output"]
}, Open  ]],
Cell[186217, 7638, 97, 1, 39, "Text",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{
Cell[186339, 7643, 172, 4, 44, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[186514, 7649, 88, 2, 70, "Output"]
}, Open  ]],
Cell[186617, 7654, 81, 1, 39, "Text",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{
Cell[186723, 7659, 162, 4, 44, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[186888, 7665, 88, 2, 70, "Output"]
}, Open  ]],
Cell[186991, 7670, 122, 3, 39, "Text",
  CellTags->{"Composition", "i:4"}],
Cell[187116, 7675, 147, 4, 46, "Input",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{
Cell[187288, 7683, 121, 2, 46, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[187412, 7687, 88, 2, 70, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[187549, 7695, 70, 1, 51, "Subsubsection",
  CellTags->{"Composition", "i:4"}],
Cell[187622, 7698, 222, 5, 56, "Text",
  CellTags->{"Composition", "i:4"}],
Cell[187847, 7705, 119, 2, 46, "Input",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{
Cell[187991, 7711, 111, 2, 46, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[188105, 7715, 136, 3, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[188278, 7723, 111, 2, 46, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[188392, 7727, 305, 6, 70, "Output"]
}, Open  ]],
Cell[188712, 7736, 92, 2, 46, "Input",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{
Cell[188829, 7742, 123, 2, 46, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[188955, 7746, 129, 3, 70, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[189157, 7757, 56, 1, 85, "Section",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{
Cell[189238, 7762, 95, 1, 40, "Subsection",
  CellTags->"Pitfalls"],
Cell[189336, 7765, 93, 3, 30, "Input",
  CellTags->"Pitfalls"],
Cell[189432, 7770, 152, 4, 50, "Input",
  CellTags->"Pitfalls"],
Cell[189587, 7776, 230, 5, 42, "Text",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{
Cell[189842, 7785, 255, 5, 50, "Input",
  CellTags->"Pitfalls"],
Cell[190100, 7792, 17852, 649, 186, 7533, 516, "GraphicsData", "PostScript", \
"Graphics"],
Cell[207955, 8443, 155, 4, 24, "Output"]
}, Open  ]],
Cell[208125, 8450, 139, 4, 25, "Text",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{
Cell[208289, 8458, 86, 3, 30, "Input",
  CellTags->"Pitfalls"],
Cell[208378, 8463, 65, 2, 24, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[208480, 8470, 127, 3, 30, "Input",
  CellTags->"Pitfalls"],
Cell[208610, 8475, 90, 2, 28, "Print"],
Cell[208703, 8479, 91, 2, 28, "Print"],
Cell[208797, 8483, 139, 3, 40, "Output"]
}, Open  ]],
Cell[208951, 8489, 91, 1, 25, "Text",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{
Cell[209067, 8494, 127, 3, 30, "Input",
  CellTags->"Pitfalls"],
Cell[209197, 8499, 91, 2, 28, "Print"],
Cell[209291, 8503, 90, 2, 28, "Print"],
Cell[209384, 8507, 119, 2, 28, "Print"],
Cell[209506, 8511, 91, 2, 28, "Print"],
Cell[209600, 8515, 110, 2, 28, "Print"],
Cell[209713, 8519, 73, 2, 24, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[209835, 8527, 85, 1, 40, "Subsection",
  CellTags->"Pitfalls"],
Cell[209923, 8530, 130, 4, 25, "Text",
  CellTags->"Pitfalls"],
Cell[210056, 8536, 114, 3, 30, "Input",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{
Cell[210195, 8543, 123, 3, 30, "Input",
  CellTags->"Pitfalls"],
Cell[210321, 8548, 91, 2, 28, "Print"],
Cell[210415, 8552, 90, 2, 28, "Print"],
Cell[210508, 8556, 91, 2, 28, "Print"],
Cell[210602, 8560, 80, 2, 24, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[210719, 8567, 117, 3, 30, "Input",
  CellTags->"Pitfalls"],
Cell[210839, 8572, 90, 2, 24, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[210966, 8579, 136, 3, 30, "Input",
  CellTags->"Pitfalls"],
Cell[211105, 8584, 91, 2, 28, "Print"],
Cell[211199, 8588, 90, 2, 28, "Print"],
Cell[211292, 8592, 91, 2, 28, "Print"],
Cell[211386, 8596, 88, 2, 24, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[211535, 8605, 41, 0, 85, "Section"],

Cell[CellGroupData[{
Cell[211601, 8609, 90, 1, 40, "Subsection",
  CellTags->"Aircraft Example"],

Cell[CellGroupData[{
Cell[211716, 8614, 100, 3, 30, "Input",
  CellTags->"Aircraft Example"],
Cell[211819, 8619, 673, 10, 237, "Print"]
}, Open  ]],
Cell[212507, 8632, 811, 15, 182, "Input",
  CellTags->"Aircraft Example"],

Cell[CellGroupData[{
Cell[213343, 8651, 235, 6, 70, "Input",
  CellTags->"Aircraft Example"],
Cell[213581, 8659, 90, 2, 28, "Print"],
Cell[213674, 8663, 91, 2, 28, "Print"],
Cell[213768, 8667, 1606, 27, 176, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[215411, 8699, 476, 8, 110, "Input",
  CellTags->"Aircraft Example"],
Cell[215890, 8709, 329, 5, 47, "Message"],
Cell[216222, 8716, 139467, 5602, 251, 92544, 5018, "GraphicsData", \
"PostScript", "Graphics"],
Cell[355692, 14320, 157, 4, 24, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

