#include <math.h>    
#include "trigfun.h"  
/* 
 *  
 *            Syntax  [sys, x0] = MXTst2(t,x,u,flag) 
*/ 
/* 
* The following #define is used to specify the name of this S-Function. 
*/ 
#define S_FUNCTION_NAME MXTst2 
/* 
* need to include simstruc.h for the definition of the SimStruct and 
* its associated macro definitions. 
*/ 
#include "simstruc.h" 
  
/* 
 * mdlInitializeSizes - initialize the sizes array 
 * 
 * The sizes array is used by SIMULINK to determine the S-function block's 
 * characteristics (number of inputs, outputs, states, etc.). 
 */ 
static void mdlInitializeSizes(S) 
    SimStruct *S; 
{ 
    ssSetNumContStates(    S, 0);      /* number of continuous states */ 
    ssSetNumDiscStates(    S, 0);      /* number of discrete states */ 
    ssSetNumInputs(        S, 2 );      /* number of inputs */ 
    ssSetNumOutputs(       S, 2 );      /* number of outputs */ 
    ssSetDirectFeedThrough(S, 1);      /* direct feedthrough flag */ 
    ssSetNumSampleTimes(   S, 1);      /* number of sample times */ 
    ssSetNumInputArgs(     S, 0);      /* number of input arguments */ 
    ssSetNumRWork(         S, 0);      /* number of real work vector elements */ 
    ssSetNumIWork(         S, 0);      /* number of integer work vector elements */ 
    ssSetNumPWork(         S, 0);      /* number of pointer work vector elements */ 
     /* 
     * if there aren't the correct number of parameters, just return, simulink.c will 
     * flag the error 
     */ 
    if (ssGetNumArgs(S) != 0) 
       return; 
} 
/* 
 * mdlInitializeSampleTimes - initialize the sample times array 
 * 
 * This function is used to specify the sample time(s) for your S-function. 
 * If your S-function is continuous, you must specify a sample time of 0.0. 
 * Sample times must be registered in ascending order. 
 */ 
static void mdlInitializeSampleTimes(S) 
    SimStruct *S; 
{ 
    ssSetSampleTimeEvent(S, 0, 0.0); 
    ssSetOffsetTimeEvent(S, 0, 0.0); 
} 
/* 
 * mdlInitializeConditions - initialize the states 
 * 
 * In this function, you should initialize the continuous and discrete 
 * states for your S-function block.  The initial states are placed 
 * in the x0 variable.  You can also perform any other initialization 
 * activities that your S-function may require. 
 */ 
static void mdlInitializeConditions(x0, S) 
#ifdef MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */ 
    double *x0; 
    SimStruct *S; 
{ 
    int i,imax; 
/* Set initial value for state vector */ 
    for(i=0;i<0;i++){ 
        x0[i] = 0; 
    } 
} 
#else    /* compiled for dSpace board? */ 
    real_T *x0; 
    SimStruct *S; 
{ 
    int_T i,imax; 
/* Set initial value for state vector */ 
    for(i=0;i<0;i++){ 
        x0[i] = 0; 
    } 
} 
#endif 
/* 
 * mdlDerivatives - compute the derivatives 
 * 
 * In this function, you compute the S-function block's derivatives. 
 * The derivatives are placed in the dx variable. 
 */ 
static void mdlDerivatives(dx, x, u, S, tid) 
#ifdef MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */ 
    double *dx, *x, *u; 
    SimStruct *S; 
    int tid; 
{  
    int n; 
    double s1, s2, s3, s4, s5, s6, s7, s8, s9, s10; 
  
    double *RWork = ssGetRWork(S); 
    int i,j; 
    char s='L'; 
    int nrhs, LDA, info; 
#else    /* compiled for dSpace board? */ 
    real_T *dx; 
  const real_T *x, *u; 
    SimStruct *S; 
    int_T tid; 
{  
    int_T n; 
    real_T s1, s2, s3, s4, s5, s6, s7, s8, s9, s10; 
  
    real_T *RWork = ssGetRWork(S); 
    int_T i,j; 
    char s='L'; 
    int_T nrhs, LDA, info; 
#endif 
    n = 0; 
} 
/* 
 * mdlOutputs - compute the outputs 
 * 
 * In this function, you compute the outputs of your S-function 
 * block.  The outputs are placed in the y variable. 
 */ 
static void mdlOutputs(y, x, u, S, tid) 
#ifdef MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */ 
    double *y, *x, *u; 
    SimStruct *S; 
    int tid; 
{ 
    double s1, s2, s3, s4, s5, s6, s7, s8, s9, s10; 
  
#else    /* compiled for dSpace board? */ 
    real_T *y; 
   const real_T *x, *u; 
    SimStruct *S; 
    int_T tid; 
{ 
    real_T s1, s2, s3, s4, s5, s6, s7, s8, s9, s10; 
  
#endif 
    y[0] =     List(u1,u2)(1.0000000); 
    y[1] =     List(u1,u2)(0); 
} 
/* 
 * mdlUpdate - perform action at major integration time step 
 * 
 * This function is called once for every major integration time step. 
 * Discrete states are typically updated here, but this function is useful 
 * for performing any tasks that should only take place once per integration 
 * step. 
 */ 
static void mdlUpdate(x, u, S, tid) 
#ifdef MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */ 
    double  *x, *u; 
    SimStruct *S; 
    int tid; 
#else    /* compiled for dSpace board? */ 
    real_T *x; 
   const real_T *u; 
    SimStruct *S; 
    int_T tid; 
#endif 
{ 
} 
/* 
 * mdlTerminate - called when the simulation is terminated. 
 * 
 * In this function, you should perform any actions that are necessary 
 * at the termination of a simulation.  For example, if memory was allocated 
 * in mdlInitializeConditions, this is the place to free it. 
 */ 
static void mdlTerminate(S) 
    SimStruct *S; 
{ 
} 
#ifdef MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */ 
#include "simulink.c"      /* MEX-file interface mechanism */ 
#else 
#include "cg_sfun.h"       /* Code generation registration function */ 
#endif 
