#include <math.h>    
#include "trigfun.h"  
/* 
 *  
 *            Syntax  [sys, x0] = truck(t,x,u,flag,X0,sr,sl,kappa,g) 
*/ 
/* 
* The following #define is used to specify the name of this S-Function. 
*/ 
#define S_FUNCTION_NAME truck 
/* 
* need to include simstruc.h for the definition of the SimStruct and 
* its associated macro definitions. 
*/ 
#include "simstruc.h" 
  
/* Defines for work arrays */ 
#define Br(j) RWork[j] 
#define Ar(i,j) RWork[4+ i+j*4] 
#define Cr(i,j) RWork[20+ i+j*4] 
/* 
 * mdlInitializeSizes - initialize the sizes array 
 * 
 * The sizes array is used by SIMULINK to determine the S-function block's 
 * characteristics (number of inputs, outputs, states, etc.). 
 */ 
static void mdlInitializeSizes(S) 
    SimStruct *S; 
{ 
    ssSetNumContStates(    S, 8);      /* number of continuous states */ 
    ssSetNumDiscStates(    S, 0);      /* number of discrete states */ 
    ssSetNumInputs(        S, 2 );      /* number of inputs */ 
    ssSetNumOutputs(       S, 2 );      /* number of outputs */ 
    ssSetDirectFeedThrough(S, 0);      /* direct feedthrough flag */ 
    ssSetNumSampleTimes(   S, 1);      /* number of sample times */ 
    ssSetNumInputArgs(     S, 5);      /* number of input arguments */ 
    ssSetNumRWork(         S, 36);      /* number of real work vector elements */ 
    ssSetNumIWork(         S, 0);      /* number of integer work vector elements */ 
    ssSetNumPWork(         S, 0);      /* number of pointer work vector elements */ 
     /* 
     * if there aren't the correct number of parameters, just return, simulink.c will 
     * flag the error 
     */ 
    if (ssGetNumArgs(S) != 5) 
       return; 
    if (mxGetM(ssGetArg(S,0)) != 8  || mxGetN(ssGetArg(S,0)) !=1)  { 
        ssSetErrorStatus( S, "X0 must have dimensions: 8 by 1"); 
        return; 
    } 
    if (mxGetM(ssGetArg(S,1)) != 1  || mxGetN(ssGetArg(S,1)) !=1)  { 
        ssSetErrorStatus( S, "sr must have dimensions: 1 by 1"); 
        return; 
    } 
    if (mxGetM(ssGetArg(S,2)) != 1  || mxGetN(ssGetArg(S,2)) !=1)  { 
        ssSetErrorStatus( S, "sl must have dimensions: 1 by 1"); 
        return; 
    } 
    if (mxGetM(ssGetArg(S,3)) != 1  || mxGetN(ssGetArg(S,3)) !=1)  { 
        ssSetErrorStatus( S, "kappa must have dimensions: 1 by 1"); 
        return; 
    } 
    if (mxGetM(ssGetArg(S,4)) != 1  || mxGetN(ssGetArg(S,4)) !=1)  { 
        ssSetErrorStatus( S, "g must have dimensions: 1 by 1"); 
        return; 
    } 
} 
/* 
 * mdlInitializeSampleTimes - initialize the sample times array 
 * 
 * This function is used to specify the sample time(s) for your S-function. 
 * If your S-function is continuous, you must specify a sample time of 0.0. 
 * Sample times must be registered in ascending order. 
 */ 
static void mdlInitializeSampleTimes(S) 
    SimStruct *S; 
{ 
    ssSetSampleTimeEvent(S, 0, 0.0); 
    ssSetOffsetTimeEvent(S, 0, 0.0); 
} 
/* 
 * mdlInitializeConditions - initialize the states 
 * 
 * In this function, you should initialize the continuous and discrete 
 * states for your S-function block.  The initial states are placed 
 * in the x0 variable.  You can also perform any other initialization 
 * activities that your S-function may require. 
 */ 
static void mdlInitializeConditions(x0, S) 
#ifdef MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */ 
    double *x0; 
    SimStruct *S; 
{ 
    int i,imax; 
    double *X0pr; 
/* Set initial value for state vector */ 
    X0pr = mxGetPr(ssGetArg(S,0));  
    imax = mxGetM(ssGetArg(S,0)); 
    for(i=0;i<imax;i++){ 
        x0[i] = X0pr[i]; 
    } 
} 
#else    /* compiled for dSpace board? */ 
    real_T *x0; 
    SimStruct *S; 
{ 
    int_T i,imax; 
    real_T *X0pr; 
/* Set initial value for state vector */ 
    X0pr = mxGetPr(ssGetArg(S,0));  
    imax = mxGetM(ssGetArg(S,0)); 
    for(i=0;i<imax;i++){ 
        x0[i] = X0pr[i]; 
    } 
} 
#endif 
/* 
 * mdlDerivatives - compute the derivatives 
 * 
 * In this function, you compute the S-function block's derivatives. 
 * The derivatives are placed in the dx variable. 
 */ 
static void mdlDerivatives(dx, x, u, S, tid) 
#ifdef MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */ 
    double *dx, *x, *u; 
    SimStruct *S; 
    int tid; 
{  
    int n; 
    double s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20, s21, s22; 
    double t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17, t18, t19, t20, t21, t22, t23, t24, t25, t26, t27, t28, t29, t30, t31, t32, t33, t34, t35, t36, t37, t38, t39, t40, t41, t42, t43, t44, t45; 
    double *RWork = ssGetRWork(S); 
    int i,j; 
    char s='L'; 
    int nrhs, LDA, info; 
    double *srpr = mxGetPr(ssGetArg(S,1)); 
    double *slpr = mxGetPr(ssGetArg(S,2)); 
    double *kappapr = mxGetPr(ssGetArg(S,3)); 
    double *gpr = mxGetPr(ssGetArg(S,4)); 
#else    /* compiled for dSpace board? */ 
    real_T *dx; 
  const real_T *x, *u; 
    SimStruct *S; 
    int_T tid; 
{  
    int_T n; 
    real_T s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20, s21, s22; 
    real_T t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17, t18, t19, t20, t21, t22, t23, t24, t25, t26, t27, t28, t29, t30, t31, t32, t33, t34, t35, t36, t37, t38, t39, t40, t41, t42, t43, t44, t45; 
    real_T *RWork = ssGetRWork(S); 
    int_T i,j; 
    char s='L'; 
    int_T nrhs, LDA, info; 
    real_T *srpr = mxGetPr(ssGetArg(S,1)); 
    real_T *slpr = mxGetPr(ssGetArg(S,2)); 
    real_T *kappapr = mxGetPr(ssGetArg(S,3)); 
    real_T *gpr = mxGetPr(ssGetArg(S,4)); 
#endif 
    n = 4; 
    t1=pow(tr,2.); 
    t2=pow(tl,2.); 
    t3=pow(srpr[0],3.); 
    t4=pow(srpr[0],2.); 
    t5=pow(slpr[0],3.); 
    t6=pow(slpr[0],2.); 
    t7=cos(x[7]); 
    t8=sin(x[7]); 
    t9=pow(t8,2.); 
    t10=pow(t7,2.); 
    t11=pow(t7,2.); 
    t12=pow(1.8462625*x[0]+1.0000000*x[1],-1.0000000); 
    t13=pow(-1.8462625*x[0]+1.0000000*x[1],-1.0000000); 
    t14=pow(1.0000000+t1+t4,0.5); 
    t15=pow(1.0000000+t1+t4,-0.5); 
    t16=pow(1.0000000+t1+t4,-1.0000000); 
    t17=t16; 
    t18=pow(1.0000000+t1+t4,-1.5); 
    t19=pow(1.0000000+t2+t6,0.5); 
    t20=pow(1.0000000+t2+t6,-0.5); 
    t21=pow(1.0000000+t2+t6,-1.0000000); 
    t22=t21; 
    t23=pow(1.0000000+t2+t6,-1.5); 
    t24=pow(1.0000000*t7*x[1]+t8*(0.20320000*x[0]+1.0000000*x[2])+1.8462625*(x[0]+x[3]),-1.0000000); 
    t25=pow(1.0000000*t7*x[1]+t8*(0.20320000*x[0]+1.0000000*x[2])-1.8462625*(x[0]+x[3]),-1.0000000); 
    t26=atan(t12*(0.7112000*x[0]+1.0000000*x[2])); 
    t27=atan(t12*(-0.7112000*x[0]+1.0000000*x[2])); 
    t28=atan(t13*(0.7112000*x[0]+1.0000000*x[2])); 
    t29=atan(t13*(-0.7112000*x[0]+1.0000000*x[2])); 
    t30=cos(t14*u[1]); 
    t31=cos(0.5000000*t14*u[1]); 
    t32=cos(t19*u[1]); 
    t33=cos(0.5000000*t19*u[1]); 
    t34=sin(t14*u[1]); 
    t35=sin(0.5000000*t14*u[1]); 
    t36=sin(t19*u[1]); 
    t37=sin(0.5000000*t19*u[1]); 
    t38=pow(t35,2.); 
    t39=pow(t37,2.); 
    t40=atan(t24*(-(t8*x[1])+t7*(0.20320000*x[0]+1.0000000*x[2])-9.855200*(x[0]+x[3]))); 
    t41=atan(t25*(-(t8*x[1])+t7*(0.20320000*x[0]+1.0000000*x[2])-9.855200*(x[0]+x[3]))); 
    t42=pow((0.30480000*slpr[0]*t20*t36-1.8462625*t21*(t32+t2*t32+t6)+t21*(-0.30480000+0.30480000*t32)*tl+0.30480000*t21*(1.0000000+t32*(t2+t6))*tl+9.448800*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl))*x[0]+t21*(t32+t2*t32+t6)*x[1]+2.0000000*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl)*x[2],-1.0000000); 
    t43=pow((1.8462625*t16*(t30+t1*t30+t4)-0.30480000*t16*(1.0000000+t30*(t1+t4))*tr-0.30480000*(-(srpr[0]*t15*t34)+t16*(-1.0000000+t30)*tr)+9.448800*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr))*x[0]+t16*(t30+t1*t30+t4)*x[1]+2.0000000*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr)*x[2],-1.0000000); 
    t44=atan(t42*((4.724400*t21*(t2+t32+t32*t6)+0.30480000*slpr[0]*t21*(1.0000000+t32*(t2+t6))+0.30480000*(slpr[0]*t21*(-1.0000000+t32)-t20*t36*tl)+3.692525*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl))*x[0]-2.0000000*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl)*x[1]+t21*(t2+t32+t32*t6)*x[2])); 
    t45=atan(t43*((4.724400*t16*(t1+t30+t30*t4)+0.30480000*srpr[0]*t16*(1.0000000+t30*(t1+t4))+0.30480000*(srpr[0]*t16*(-1.0000000+t30)+t15*t34*tr)-3.692525*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr))*x[0]-2.0000000*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr)*x[1]+t16*(t1+t30+t30*t4)*x[2])); 
    Ar(0,0)=2.0912753e6+1806.8609*t11-102614.05*t7+1806.8609*t9; 
    Ar(1,0)=252495.20*t8; 
    Ar(1,1)=11580.000+43760.00*t10+43760.00*t9; 
    Ar(2,0)=28513.852+4446.016*t10+4446.016*t11-252495.20*t7+8892.032*t9; 
    Ar(2,1)=0; 
    Ar(2,2)=11580.000+43760.00*t10+43760.00*t9; 
    Ar(3,0)=1.9633973e6-51307.02*t7; 
    Ar(3,1)=252495.20*t8; 
    Ar(3,2)=-252495.20*t7; 
    Ar(3,3)=1.9633973e6; 
    s1=-(kappapr[0]*(0.7112000*t26-0.7112000*t27+0.7112000*t28-0.7112000*t29+t40*(-9.855200+0.20320000*t7)+t41*(-9.855200+0.20320000*t7)));
    s2=3.692525*kappapr[0]*t18;
    s3=pow((1.8462625*t17*(t30+t1*t30+t4)-0.30480000*t17*(1.0000000+t30*(t1+t4))*tr-0.30480000*(-(srpr[0]*t15*t34)+t17*(-1.0000000+t30)*tr)+9.448800*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr))*x[0]+t17*(t30+t1*t30+t4)*x[1]+2.0000000*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr)*x[2],-1.0000000)*((4.724400*t17*(t1+t30+t30*t4)+0.30480000*srpr[0]*t17*(1.0000000+t30*(t1+t4))+0.30480000*(srpr[0]*t17*(-1.0000000+t30)+t15*t34*tr)-3.692525*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr))*x[0]-2.0000000*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr)*x[1]+t17*(t1+t30+t30*t4)*x[2]);
    s4=3.692525*kappapr[0]*t18;
    s5=t31*t35;
    s6=pow((1.8462625*t17*(t30+t1*t30+t4)-0.30480000*t17*(1.0000000+t30*(t1+t4))*tr-0.30480000*(-(srpr[0]*t15*t34)+t17*(-1.0000000+t30)*tr)+9.448800*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr))*x[0]+t17*(t30+t1*t30+t4)*x[1]+2.0000000*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr)*x[2],-1.0000000)*((4.724400*t17*(t1+t30+t30*t4)+0.30480000*srpr[0]*t17*(1.0000000+t30*(t1+t4))+0.30480000*(srpr[0]*t17*(-1.0000000+t30)+t15*t34*tr)-3.692525*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr))*x[0]-2.0000000*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr)*x[1]+t17*(t1+t30+t30*t4)*x[2]);
    s7=-0.30480000*kappapr[0]*t15;
    s8=pow((1.8462625*t17*(t30+t1*t30+t4)-0.30480000*t17*(1.0000000+t30*(t1+t4))*tr-0.30480000*(-(srpr[0]*t15*t34)+t17*(-1.0000000+t30)*tr)+9.448800*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr))*x[0]+t17*(t30+t1*t30+t4)*x[1]+2.0000000*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr)*x[2],-1.0000000)*((4.724400*t17*(t1+t30+t30*t4)+0.30480000*srpr[0]*t17*(1.0000000+t30*(t1+t4))+0.30480000*(srpr[0]*t17*(-1.0000000+t30)+t15*t34*tr)-3.692525*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr))*x[0]-2.0000000*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr)*x[1]+t17*(t1+t30+t30*t4)*x[2]);
    s9=-3.692525*kappapr[0]*srpr[0];
    s10=t17*t38;
    s11=pow((1.8462625*t17*(t30+t1*t30+t4)-0.30480000*t17*(1.0000000+t30*(t1+t4))*tr-0.30480000*(-(srpr[0]*t15*t34)+t17*(-1.0000000+t30)*tr)+9.448800*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr))*x[0]+t17*(t30+t1*t30+t4)*x[1]+2.0000000*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr)*x[2],-1.0000000)*((4.724400*t17*(t1+t30+t30*t4)+0.30480000*srpr[0]*t17*(1.0000000+t30*(t1+t4))+0.30480000*(srpr[0]*t17*(-1.0000000+t30)+t15*t34*tr)-3.692525*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr))*x[0]-2.0000000*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr)*x[1]+t17*(t1+t30+t30*t4)*x[2]);
    s12=4.724400*kappapr[0];
    s13=pow((1.8462625*t17*(t30+t1*t30+t4)-0.30480000*t17*(1.0000000+t30*(t1+t4))*tr-0.30480000*(-(srpr[0]*t15*t34)+t17*(-1.0000000+t30)*tr)+9.448800*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr))*x[0]+t17*(t30+t1*t30+t4)*x[1]+2.0000000*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr)*x[2],-1.0000000)*((4.724400*t17*(t1+t30+t30*t4)+0.30480000*srpr[0]*t17*(1.0000000+t30*(t1+t4))+0.30480000*(srpr[0]*t17*(-1.0000000+t30)+t15*t34*tr)-3.692525*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr))*x[0]-2.0000000*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr)*x[1]+t17*(t1+t30+t30*t4)*x[2]);
    s14=-3.692525*kappapr[0]*t18;
    s15=pow((1.8462625*t17*(t30+t1*t30+t4)-0.30480000*t17*(1.0000000+t30*(t1+t4))*tr-0.30480000*(-(srpr[0]*t15*t34)+t17*(-1.0000000+t30)*tr)+9.448800*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr))*x[0]+t17*(t30+t1*t30+t4)*x[1]+2.0000000*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr)*x[2],-1.0000000)*((4.724400*t17*(t1+t30+t30*t4)+0.30480000*srpr[0]*t17*(1.0000000+t30*(t1+t4))+0.30480000*(srpr[0]*t17*(-1.0000000+t30)+t15*t34*tr)-3.692525*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr))*x[0]-2.0000000*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr)*x[1]+t17*(t1+t30+t30*t4)*x[2]);
    s16=0.30480000*kappapr[0]*srpr[0];
    s17=pow((1.8462625*t17*(t30+t1*t30+t4)-0.30480000*t17*(1.0000000+t30*(t1+t4))*tr-0.30480000*(-(srpr[0]*t15*t34)+t17*(-1.0000000+t30)*tr)+9.448800*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr))*x[0]+t17*(t30+t1*t30+t4)*x[1]+2.0000000*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr)*x[2],-1.0000000)*((4.724400*t17*(t1+t30+t30*t4)+0.30480000*srpr[0]*t17*(1.0000000+t30*(t1+t4))+0.30480000*(srpr[0]*t17*(-1.0000000+t30)+t15*t34*tr)-3.692525*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr))*x[0]-2.0000000*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr)*x[1]+t17*(t1+t30+t30*t4)*x[2]);
    s18=4.724400*kappapr[0];
    s19=pow((1.8462625*t17*(t30+t1*t30+t4)-0.30480000*t17*(1.0000000+t30*(t1+t4))*tr-0.30480000*(-(srpr[0]*t15*t34)+t17*(-1.0000000+t30)*tr)+9.448800*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr))*x[0]+t17*(t30+t1*t30+t4)*x[1]+2.0000000*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr)*x[2],-1.0000000)*((4.724400*t17*(t1+t30+t30*t4)+0.30480000*srpr[0]*t17*(1.0000000+t30*(t1+t4))+0.30480000*(srpr[0]*t17*(-1.0000000+t30)+t15*t34*tr)-3.692525*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr))*x[0]-2.0000000*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr)*x[1]+t17*(t1+t30+t30*t4)*x[2]);
    s20=0.30480000*kappapr[0];
    s21=pow((1.8462625*t17*(t30+t1*t30+t4)-0.30480000*t17*(1.0000000+t30*(t1+t4))*tr-0.30480000*(-(srpr[0]*t15*t34)+t17*(-1.0000000+t30)*tr)+9.448800*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr))*x[0]+t17*(t30+t1*t30+t4)*x[1]+2.0000000*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr)*x[2],-1.0000000)*((4.724400*t17*(t1+t30+t30*t4)+0.30480000*srpr[0]*t17*(1.0000000+t30*(t1+t4))+0.30480000*(srpr[0]*t17*(-1.0000000+t30)+t15*t34*tr)-3.692525*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr))*x[0]-2.0000000*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr)*x[1]+t17*(t1+t30+t30*t4)*x[2]);
    s22=pow((1.8462625*t17*(t30+t1*t30+t4)-0.30480000*t17*(1.0000000+t30*(t1+t4))*tr-0.30480000*(-(srpr[0]*t15*t34)+t17*(-1.0000000+t30)*tr)+9.448800*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr))*x[0]+t17*(t30+t1*t30+t4)*x[1]+2.0000000*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr)*x[2],-1.0000000)*((4.724400*t17*(t1+t30+t30*t4)+0.30480000*srpr[0]*t17*(1.0000000+t30*(t1+t4))+0.30480000*(srpr[0]*t17*(-1.0000000+t30)+t15*t34*tr)-3.692525*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr))*x[0]-2.0000000*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr)*x[1]+t17*(t1+t30+t30*t4)*x[2]);
    s23=pow((1.8462625*t17*(t30+t1*t30+t4)-0.30480000*t17*(1.0000000+t30*(t1+t4))*tr-0.30480000*(-(srpr[0]*t15*t34)+t17*(-1.0000000+t30)*tr)+9.448800*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr))*x[0]+t17*(t30+t1*t30+t4)*x[1]+2.0000000*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr)*x[2],-1.0000000)*((4.724400*t17*(t1+t30+t30*t4)+0.30480000*srpr[0]*t17*(1.0000000+t30*(t1+t4))+0.30480000*(srpr[0]*t17*(-1.0000000+t30)+t15*t34*tr)-3.692525*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr))*x[0]-2.0000000*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr)*x[1]+t17*(t1+t30+t30*t4)*x[2]);
    s24=-3.692525*kappapr[0]*t23;
    s25=pow((0.30480000*slpr[0]*t20*t36-1.8462625*t22*(t32+t2*t32+t6)+t22*(-0.30480000+0.30480000*t32)*tl+0.30480000*t22*(1.0000000+t32*(t2+t6))*tl+9.448800*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl))*x[0]+t22*(t32+t2*t32+t6)*x[1]+2.0000000*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl)*x[2],-1.0000000);
    s26=(4.724400*t22*(t2+t32+t32*t6)+0.30480000*slpr[0]*t22*(1.0000000+t32*(t2+t6))+0.30480000*(slpr[0]*t22*(-1.0000000+t32)-t20*t36*tl)+3.692525*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl))*x[0]-2.0000000*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl)*x[1]+t22*(t2+t32+t32*t6)*x[2];
    s27=-3.692525*kappapr[0]*t23;
    s28=t33*t37;
    s29=pow((0.30480000*slpr[0]*t20*t36-1.8462625*t22*(t32+t2*t32+t6)+t22*(-0.30480000+0.30480000*t32)*tl+0.30480000*t22*(1.0000000+t32*(t2+t6))*tl+9.448800*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl))*x[0]+t22*(t32+t2*t32+t6)*x[1]+2.0000000*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl)*x[2],-1.0000000);
    s30=(4.724400*t22*(t2+t32+t32*t6)+0.30480000*slpr[0]*t22*(1.0000000+t32*(t2+t6))+0.30480000*(slpr[0]*t22*(-1.0000000+t32)-t20*t36*tl)+3.692525*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl))*x[0]-2.0000000*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl)*x[1]+t22*(t2+t32+t32*t6)*x[2];
    s31=0.30480000*kappapr[0]*t20;
    s32=pow((0.30480000*slpr[0]*t20*t36-1.8462625*t22*(t32+t2*t32+t6)+t22*(-0.30480000+0.30480000*t32)*tl+0.30480000*t22*(1.0000000+t32*(t2+t6))*tl+9.448800*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl))*x[0]+t22*(t32+t2*t32+t6)*x[1]+2.0000000*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl)*x[2],-1.0000000);
    s33=(4.724400*t22*(t2+t32+t32*t6)+0.30480000*slpr[0]*t22*(1.0000000+t32*(t2+t6))+0.30480000*(slpr[0]*t22*(-1.0000000+t32)-t20*t36*tl)+3.692525*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl))*x[0]-2.0000000*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl)*x[1]+t22*(t2+t32+t32*t6)*x[2];
    s34=-3.692525*kappapr[0]*slpr[0];
    s35=t22*t39;
    s36=pow((0.30480000*slpr[0]*t20*t36-1.8462625*t22*(t32+t2*t32+t6)+t22*(-0.30480000+0.30480000*t32)*tl+0.30480000*t22*(1.0000000+t32*(t2+t6))*tl+9.448800*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl))*x[0]+t22*(t32+t2*t32+t6)*x[1]+2.0000000*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl)*x[2],-1.0000000);
    s37=(4.724400*t22*(t2+t32+t32*t6)+0.30480000*slpr[0]*t22*(1.0000000+t32*(t2+t6))+0.30480000*(slpr[0]*t22*(-1.0000000+t32)-t20*t36*tl)+3.692525*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl))*x[0]-2.0000000*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl)*x[1]+t22*(t2+t32+t32*t6)*x[2];
    s38=4.724400*kappapr[0];
    s39=pow((0.30480000*slpr[0]*t20*t36-1.8462625*t22*(t32+t2*t32+t6)+t22*(-0.30480000+0.30480000*t32)*tl+0.30480000*t22*(1.0000000+t32*(t2+t6))*tl+9.448800*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl))*x[0]+t22*(t32+t2*t32+t6)*x[1]+2.0000000*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl)*x[2],-1.0000000);
    s40=(4.724400*t22*(t2+t32+t32*t6)+0.30480000*slpr[0]*t22*(1.0000000+t32*(t2+t6))+0.30480000*(slpr[0]*t22*(-1.0000000+t32)-t20*t36*tl)+3.692525*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl))*x[0]-2.0000000*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl)*x[1]+t22*(t2+t32+t32*t6)*x[2];
    s41=3.692525*kappapr[0]*t23;
    s42=pow((0.30480000*slpr[0]*t20*t36-1.8462625*t22*(t32+t2*t32+t6)+t22*(-0.30480000+0.30480000*t32)*tl+0.30480000*t22*(1.0000000+t32*(t2+t6))*tl+9.448800*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl))*x[0]+t22*(t32+t2*t32+t6)*x[1]+2.0000000*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl)*x[2],-1.0000000);
    s43=(4.724400*t22*(t2+t32+t32*t6)+0.30480000*slpr[0]*t22*(1.0000000+t32*(t2+t6))+0.30480000*(slpr[0]*t22*(-1.0000000+t32)-t20*t36*tl)+3.692525*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl))*x[0]-2.0000000*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl)*x[1]+t22*(t2+t32+t32*t6)*x[2];
    s44=0.30480000*kappapr[0]*slpr[0];
    s45=pow((0.30480000*slpr[0]*t20*t36-1.8462625*t22*(t32+t2*t32+t6)+t22*(-0.30480000+0.30480000*t32)*tl+0.30480000*t22*(1.0000000+t32*(t2+t6))*tl+9.448800*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl))*x[0]+t22*(t32+t2*t32+t6)*x[1]+2.0000000*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl)*x[2],-1.0000000);
    s46=(4.724400*t22*(t2+t32+t32*t6)+0.30480000*slpr[0]*t22*(1.0000000+t32*(t2+t6))+0.30480000*(slpr[0]*t22*(-1.0000000+t32)-t20*t36*tl)+3.692525*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl))*x[0]-2.0000000*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl)*x[1]+t22*(t2+t32+t32*t6)*x[2];
    s47=4.724400*kappapr[0];
    s48=pow((0.30480000*slpr[0]*t20*t36-1.8462625*t22*(t32+t2*t32+t6)+t22*(-0.30480000+0.30480000*t32)*tl+0.30480000*t22*(1.0000000+t32*(t2+t6))*tl+9.448800*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl))*x[0]+t22*(t32+t2*t32+t6)*x[1]+2.0000000*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl)*x[2],-1.0000000);
    s49=(4.724400*t22*(t2+t32+t32*t6)+0.30480000*slpr[0]*t22*(1.0000000+t32*(t2+t6))+0.30480000*(slpr[0]*t22*(-1.0000000+t32)-t20*t36*tl)+3.692525*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl))*x[0]-2.0000000*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl)*x[1]+t22*(t2+t32+t32*t6)*x[2];
    s50=0.30480000*kappapr[0];
    s51=pow((0.30480000*slpr[0]*t20*t36-1.8462625*t22*(t32+t2*t32+t6)+t22*(-0.30480000+0.30480000*t32)*tl+0.30480000*t22*(1.0000000+t32*(t2+t6))*tl+9.448800*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl))*x[0]+t22*(t32+t2*t32+t6)*x[1]+2.0000000*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl)*x[2],-1.0000000);
    s52=(4.724400*t22*(t2+t32+t32*t6)+0.30480000*slpr[0]*t22*(1.0000000+t32*(t2+t6))+0.30480000*(slpr[0]*t22*(-1.0000000+t32)-t20*t36*tl)+3.692525*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl))*x[0]-2.0000000*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl)*x[1]+t22*(t2+t32+t32*t6)*x[2];
    s53=pow((0.30480000*slpr[0]*t20*t36-1.8462625*t22*(t32+t2*t32+t6)+t22*(-0.30480000+0.30480000*t32)*tl+0.30480000*t22*(1.0000000+t32*(t2+t6))*tl+9.448800*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl))*x[0]+t22*(t32+t2*t32+t6)*x[1]+2.0000000*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl)*x[2],-1.0000000);
    s54=(4.724400*t22*(t2+t32+t32*t6)+0.30480000*slpr[0]*t22*(1.0000000+t32*(t2+t6))+0.30480000*(slpr[0]*t22*(-1.0000000+t32)-t20*t36*tl)+3.692525*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl))*x[0]-2.0000000*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl)*x[1]+t22*(t2+t32+t32*t6)*x[2];
    s55=pow((0.30480000*slpr[0]*t20*t36-1.8462625*t22*(t32+t2*t32+t6)+t22*(-0.30480000+0.30480000*t32)*tl+0.30480000*t22*(1.0000000+t32*(t2+t6))*tl+9.448800*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl))*x[0]+t22*(t32+t2*t32+t6)*x[1]+2.0000000*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl)*x[2],-1.0000000);
    s56=(4.724400*t22*(t2+t32+t32*t6)+0.30480000*slpr[0]*t22*(1.0000000+t32*(t2+t6))+0.30480000*(slpr[0]*t22*(-1.0000000+t32)-t20*t36*tl)+3.692525*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl))*x[0]-2.0000000*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl)*x[1]+t22*(t2+t32+t32*t6)*x[2];
    s57=-(t30*(t1*t17*atan(s17)*s16+t17*t4*atan(s19)*s18+t17*(kappapr[0]*(4.724400*atan(s22)+0.30480000*t3*atan(s23))+srpr[0]*atan(s21)*s20)))+t33*t37*atan(s25*s26)*s24+t6*atan(s29*s30)*s27*s28;
    s58=t36*tl*atan(s32*s33)*s31+tl*atan(s36*s37)*s34*s35-t2*(t22*atan(s39*s40)*s38+t33*t37*atan(s42*s43)*s41)-t32*(t2*t22*atan(s45*s46)*s44+t22*t6*atan(s48*s49)*s47+t22*(kappapr[0]*(4.724400*atan(s53*s54)+0.30480000*t5*atan(s55*s56))+slpr[0]*atan(s51*s52)*s50));
    Br(0)=s1+t31*t35*atan(s3)*s2+t4*atan(s6)*s4*s5+t34*tr*atan(s8)*s7+tr*atan(s11)*s9*s10-t1*(t17*atan(s13)*s12+t31*t35*atan(s15)*s14)+s57+s58; 
    s1=-(kappapr[0]*(-t40-t41)*t8);
    s2=2.0000000*kappapr[0]*t18;
    s3=pow((1.8462625*t17*(t30+t1*t30+t4)-0.30480000*t17*(1.0000000+t30*(t1+t4))*tr-0.30480000*(-(srpr[0]*t15*t34)+t17*(-1.0000000+t30)*tr)+9.448800*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr))*x[0]+t17*(t30+t1*t30+t4)*x[1]+2.0000000*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr)*x[2],-1.0000000)*((4.724400*t17*(t1+t30+t30*t4)+0.30480000*srpr[0]*t17*(1.0000000+t30*(t1+t4))+0.30480000*(srpr[0]*t17*(-1.0000000+t30)+t15*t34*tr)-3.692525*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr))*x[0]-2.0000000*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr)*x[1]+t17*(t1+t30+t30*t4)*x[2]);
    s4=2.0000000*kappapr[0]*t1;
    s5=t18*t31;
    s6=pow((1.8462625*t17*(t30+t1*t30+t4)-0.30480000*t17*(1.0000000+t30*(t1+t4))*tr-0.30480000*(-(srpr[0]*t15*t34)+t17*(-1.0000000+t30)*tr)+9.448800*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr))*x[0]+t17*(t30+t1*t30+t4)*x[1]+2.0000000*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr)*x[2],-1.0000000)*((4.724400*t17*(t1+t30+t30*t4)+0.30480000*srpr[0]*t17*(1.0000000+t30*(t1+t4))+0.30480000*(srpr[0]*t17*(-1.0000000+t30)+t15*t34*tr)-3.692525*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr))*x[0]-2.0000000*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr)*x[1]+t17*(t1+t30+t30*t4)*x[2]);
    s7=2.0000000*kappapr[0]*t18;
    s8=t31*t35;
    s9=pow((1.8462625*t17*(t30+t1*t30+t4)-0.30480000*t17*(1.0000000+t30*(t1+t4))*tr-0.30480000*(-(srpr[0]*t15*t34)+t17*(-1.0000000+t30)*tr)+9.448800*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr))*x[0]+t17*(t30+t1*t30+t4)*x[1]+2.0000000*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr)*x[2],-1.0000000)*((4.724400*t17*(t1+t30+t30*t4)+0.30480000*srpr[0]*t17*(1.0000000+t30*(t1+t4))+0.30480000*(srpr[0]*t17*(-1.0000000+t30)+t15*t34*tr)-3.692525*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr))*x[0]-2.0000000*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr)*x[1]+t17*(t1+t30+t30*t4)*x[2]);
    s10=-2.0000000*kappapr[0]*srpr[0];
    s11=t17*t38;
    s12=pow((1.8462625*t17*(t30+t1*t30+t4)-0.30480000*t17*(1.0000000+t30*(t1+t4))*tr-0.30480000*(-(srpr[0]*t15*t34)+t17*(-1.0000000+t30)*tr)+9.448800*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr))*x[0]+t17*(t30+t1*t30+t4)*x[1]+2.0000000*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr)*x[2],-1.0000000)*((4.724400*t17*(t1+t30+t30*t4)+0.30480000*srpr[0]*t17*(1.0000000+t30*(t1+t4))+0.30480000*(srpr[0]*t17*(-1.0000000+t30)+t15*t34*tr)-3.692525*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr))*x[0]-2.0000000*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr)*x[1]+t17*(t1+t30+t30*t4)*x[2]);
    s13=2.0000000*kappapr[0]*t23;
    s14=pow((0.30480000*slpr[0]*t20*t36-1.8462625*t22*(t32+t2*t32+t6)+t22*(-0.30480000+0.30480000*t32)*tl+0.30480000*t22*(1.0000000+t32*(t2+t6))*tl+9.448800*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl))*x[0]+t22*(t32+t2*t32+t6)*x[1]+2.0000000*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl)*x[2],-1.0000000);
    s15=(4.724400*t22*(t2+t32+t32*t6)+0.30480000*slpr[0]*t22*(1.0000000+t32*(t2+t6))+0.30480000*(slpr[0]*t22*(-1.0000000+t32)-t20*t36*tl)+3.692525*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl))*x[0]-2.0000000*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl)*x[1]+t22*(t2+t32+t32*t6)*x[2];
    s16=2.0000000*kappapr[0]*t2;
    s17=t23*t33;
    s18=pow((0.30480000*slpr[0]*t20*t36-1.8462625*t22*(t32+t2*t32+t6)+t22*(-0.30480000+0.30480000*t32)*tl+0.30480000*t22*(1.0000000+t32*(t2+t6))*tl+9.448800*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl))*x[0]+t22*(t32+t2*t32+t6)*x[1]+2.0000000*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl)*x[2],-1.0000000);
    s19=(4.724400*t22*(t2+t32+t32*t6)+0.30480000*slpr[0]*t22*(1.0000000+t32*(t2+t6))+0.30480000*(slpr[0]*t22*(-1.0000000+t32)-t20*t36*tl)+3.692525*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl))*x[0]-2.0000000*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl)*x[1]+t22*(t2+t32+t32*t6)*x[2];
    s20=2.0000000*kappapr[0]*t23;
    s21=t33*t37;
    s22=pow((0.30480000*slpr[0]*t20*t36-1.8462625*t22*(t32+t2*t32+t6)+t22*(-0.30480000+0.30480000*t32)*tl+0.30480000*t22*(1.0000000+t32*(t2+t6))*tl+9.448800*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl))*x[0]+t22*(t32+t2*t32+t6)*x[1]+2.0000000*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl)*x[2],-1.0000000);
    s23=(4.724400*t22*(t2+t32+t32*t6)+0.30480000*slpr[0]*t22*(1.0000000+t32*(t2+t6))+0.30480000*(slpr[0]*t22*(-1.0000000+t32)-t20*t36*tl)+3.692525*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl))*x[0]-2.0000000*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl)*x[1]+t22*(t2+t32+t32*t6)*x[2];
    s24=2.0000000*kappapr[0]*slpr[0];
    s25=t22*t39;
    s26=pow((0.30480000*slpr[0]*t20*t36-1.8462625*t22*(t32+t2*t32+t6)+t22*(-0.30480000+0.30480000*t32)*tl+0.30480000*t22*(1.0000000+t32*(t2+t6))*tl+9.448800*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl))*x[0]+t22*(t32+t2*t32+t6)*x[1]+2.0000000*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl)*x[2],-1.0000000);
    s27=(4.724400*t22*(t2+t32+t32*t6)+0.30480000*slpr[0]*t22*(1.0000000+t32*(t2+t6))+0.30480000*(slpr[0]*t22*(-1.0000000+t32)-t20*t36*tl)+3.692525*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl))*x[0]-2.0000000*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl)*x[1]+t22*(t2+t32+t32*t6)*x[2];
    s28=4.000000*u[0];
    Br(1)=s1+t31*t35*atan(s3)*s2+t35*atan(s6)*s4*s5+t4*atan(s9)*s7*s8+tr*atan(s12)*s10*s11+t33*t37*atan(s14*s15)*s13+t37*atan(s18*s19)*s16*s17+t6*atan(s22*s23)*s20*s21+tl*atan(s26*s27)*s24*s25+s28; 
    s1=-(kappapr[0]*(1.0000000*t26+1.0000000*t27+1.0000000*t28+1.0000000*t29+(1.0000000*t40+1.0000000*t41)*t7));
    s2=-kappapr[0];
    s3=pow((1.8462625*t17*(t30+t1*t30+t4)-0.30480000*t17*(1.0000000+t30*(t1+t4))*tr-0.30480000*(-(srpr[0]*t15*t34)+t17*(-1.0000000+t30)*tr)+9.448800*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr))*x[0]+t17*(t30+t1*t30+t4)*x[1]+2.0000000*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr)*x[2],-1.0000000)*((4.724400*t17*(t1+t30+t30*t4)+0.30480000*srpr[0]*t17*(1.0000000+t30*(t1+t4))+0.30480000*(srpr[0]*t17*(-1.0000000+t30)+t15*t34*tr)-3.692525*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr))*x[0]-2.0000000*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr)*x[1]+t17*(t1+t30+t30*t4)*x[2]);
    s4=pow((1.8462625*t17*(t30+t1*t30+t4)-0.30480000*t17*(1.0000000+t30*(t1+t4))*tr-0.30480000*(-(srpr[0]*t15*t34)+t17*(-1.0000000+t30)*tr)+9.448800*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr))*x[0]+t17*(t30+t1*t30+t4)*x[1]+2.0000000*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr)*x[2],-1.0000000)*((4.724400*t17*(t1+t30+t30*t4)+0.30480000*srpr[0]*t17*(1.0000000+t30*(t1+t4))+0.30480000*(srpr[0]*t17*(-1.0000000+t30)+t15*t34*tr)-3.692525*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr))*x[0]-2.0000000*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr)*x[1]+t17*(t1+t30+t30*t4)*x[2]);
    s5=kappapr[0]*t17;
    s6=pow((1.8462625*t17*(t30+t1*t30+t4)-0.30480000*t17*(1.0000000+t30*(t1+t4))*tr-0.30480000*(-(srpr[0]*t15*t34)+t17*(-1.0000000+t30)*tr)+9.448800*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr))*x[0]+t17*(t30+t1*t30+t4)*x[1]+2.0000000*t18*t35*(t31*(1.0000000+t1+t4)+srpr[0]*t14*t35*tr)*x[2],-1.0000000)*((4.724400*t17*(t1+t30+t30*t4)+0.30480000*srpr[0]*t17*(1.0000000+t30*(t1+t4))+0.30480000*(srpr[0]*t17*(-1.0000000+t30)+t15*t34*tr)-3.692525*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr))*x[0]-2.0000000*t18*t35*(t31*(1.0000000+t1+t4)-srpr[0]*t14*t35*tr)*x[1]+t17*(t1+t30+t30*t4)*x[2]);
    s7=-kappapr[0];
    s8=pow((0.30480000*slpr[0]*t20*t36-1.8462625*t22*(t32+t2*t32+t6)+t22*(-0.30480000+0.30480000*t32)*tl+0.30480000*t22*(1.0000000+t32*(t2+t6))*tl+9.448800*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl))*x[0]+t22*(t32+t2*t32+t6)*x[1]+2.0000000*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl)*x[2],-1.0000000);
    s9=(4.724400*t22*(t2+t32+t32*t6)+0.30480000*slpr[0]*t22*(1.0000000+t32*(t2+t6))+0.30480000*(slpr[0]*t22*(-1.0000000+t32)-t20*t36*tl)+3.692525*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl))*x[0]-2.0000000*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl)*x[1]+t22*(t2+t32+t32*t6)*x[2];
    s10=pow((0.30480000*slpr[0]*t20*t36-1.8462625*t22*(t32+t2*t32+t6)+t22*(-0.30480000+0.30480000*t32)*tl+0.30480000*t22*(1.0000000+t32*(t2+t6))*tl+9.448800*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl))*x[0]+t22*(t32+t2*t32+t6)*x[1]+2.0000000*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl)*x[2],-1.0000000);
    s11=(4.724400*t22*(t2+t32+t32*t6)+0.30480000*slpr[0]*t22*(1.0000000+t32*(t2+t6))+0.30480000*(slpr[0]*t22*(-1.0000000+t32)-t20*t36*tl)+3.692525*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl))*x[0]-2.0000000*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl)*x[1]+t22*(t2+t32+t32*t6)*x[2];
    s12=kappapr[0]*t22;
    s13=pow((0.30480000*slpr[0]*t20*t36-1.8462625*t22*(t32+t2*t32+t6)+t22*(-0.30480000+0.30480000*t32)*tl+0.30480000*t22*(1.0000000+t32*(t2+t6))*tl+9.448800*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl))*x[0]+t22*(t32+t2*t32+t6)*x[1]+2.0000000*t23*t37*(t33*(1.0000000+t2+t6)-slpr[0]*t19*t37*tl)*x[2],-1.0000000);
    s14=(4.724400*t22*(t2+t32+t32*t6)+0.30480000*slpr[0]*t22*(1.0000000+t32*(t2+t6))+0.30480000*(slpr[0]*t22*(-1.0000000+t32)-t20*t36*tl)+3.692525*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl))*x[0]-2.0000000*t23*t37*(t33*(1.0000000+t2+t6)+slpr[0]*t19*t37*tl)*x[1]+t22*(t2+t32+t32*t6)*x[2];
    Br(2)=s1+t1*t17*atan(s3)*s2-t30*(kappapr[0]*t17*atan(s4)+t4*atan(s6)*s5)+t2*t22*atan(s8*s9)*s7-t32*(kappapr[0]*t22*atan(s10*s11)+t6*atan(s13*s14)*s12); 
    Br(3)=-(kappapr[0]*(-9.855200*t40-9.855200*t41)); 
    Cr(0,0)=-((28513.852+4446.016*t10+4446.016*t11-252495.20*t7+8892.032*t9)*x[1])+252495.20*t8*x[2]; 
    Cr(0,1)=-((-11580.000-43760.00*t10-43760.00*t9)*x[2]); 
    Cr(0,2)=-((11580.000+43760.00*t10+43760.00*t9)*x[1]); 
    Cr(0,3)=-((4446.016*t10-4446.016*t11)*x[1])-t8*(102614.05*x[0]+51307.02*x[3]); 
    Cr(1,0)=-((-28513.852-4446.016*t10-4446.016*t11+252495.20*t7-8892.032*t9)*x[0]); 
    Cr(1,2)=-((-11580.000-43760.00*t10-43760.00*t9)*x[0]); 
    Cr(1,3)=-((4446.016*t10-4446.016*t11+504990.4*t7)*x[0])-252495.20*t7*x[3]; 
    Cr(2,0)=-252495.20*t8*x[0]; 
    Cr(2,1)=-((11580.000+43760.00*t10+43760.00*t9)*x[0]); 
    Cr(2,3)=-504990.4*t8*x[0]-252495.20*t8*x[3]; 
    Cr(3,0)=-((-2223.0080*t10+2223.0080*t11)*x[1])+126247.60*t7*x[1]-t8*(-51307.02*x[0]-126247.60*x[2]-25653.512*x[3]); 
    Cr(3,1)=-((-2223.0080*t10+2223.0080*t11-126247.60*t7)*x[0])+126247.60*t7*x[3]; 
    Cr(3,2)=-(t8*(-126247.60*x[0]-126247.60*x[3])); 
    Cr(3,3)=-126247.60*t7*x[1]-t8*(25653.512*x[0]+126247.60*x[2]); 
/* Compute C*p + F */ 
    for (i=0;i<=3;++i){ 
        for(j=0;j<=3;++j){ 
               Br(i) +=  Cr(i,j)*x[j]; 
       } 
  } 
    /* Solve linear system A*X = C*P + F  */ 
    nrhs = 1; 
    LDA = n; 
    dposv_(&s,&n,&nrhs,&Ar(0,0),&LDA,&Br(0),&LDA,&info); 
    /* reassign results */ 
    dx[0] = Br(0); 
    dx[1] = Br(1); 
    dx[2] = Br(2); 
    dx[3] = Br(3); 
    dx[4] =     x[0]; 
    dx[5] =     cos(x[4])*x[1]-sin(x[4])*x[2]; 
    dx[6] =     sin(x[4])*x[1]+cos(x[4])*x[2]; 
    dx[7] =     x[3]; 
} 
/* 
 * mdlOutputs - compute the outputs 
 * 
 * In this function, you compute the outputs of your S-function 
 * block.  The outputs are placed in the y variable. 
 */ 
static void mdlOutputs(y, x, u, S, tid) 
#ifdef MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */ 
    double *y, *x, *u; 
    SimStruct *S; 
    int tid; 
{ 
    double s1, s2, s3, s4, s5, s6, s7, s8, s9, s10; 
  
    double *srpr = mxGetPr(ssGetArg(S,1)); 
    double *slpr = mxGetPr(ssGetArg(S,2)); 
    double *kappapr = mxGetPr(ssGetArg(S,3)); 
    double *gpr = mxGetPr(ssGetArg(S,4)); 
#else    /* compiled for dSpace board? */ 
    real_T *y; 
   const real_T *x, *u; 
    SimStruct *S; 
    int_T tid; 
{ 
    real_T s1, s2, s3, s4, s5, s6, s7, s8, s9, s10; 
  
    real_T *srpr = mxGetPr(ssGetArg(S,1)); 
    real_T *slpr = mxGetPr(ssGetArg(S,2)); 
    real_T *kappapr = mxGetPr(ssGetArg(S,3)); 
    real_T *gpr = mxGetPr(ssGetArg(S,4)); 
#endif 
    y[0]=39.37008*x[5]; 
    y[1]=39.37008*x[6]; 
} 
/* 
 * mdlUpdate - perform action at major integration time step 
 * 
 * This function is called once for every major integration time step. 
 * Discrete states are typically updated here, but this function is useful 
 * for performing any tasks that should only take place once per integration 
 * step. 
 */ 
static void mdlUpdate(x, u, S, tid) 
#ifdef MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */ 
    double  *x, *u; 
    SimStruct *S; 
    int tid; 
#else    /* compiled for dSpace board? */ 
    real_T *x; 
   const real_T *u; 
    SimStruct *S; 
    int_T tid; 
#endif 
{ 
} 
/* 
 * mdlTerminate - called when the simulation is terminated. 
 * 
 * In this function, you should perform any actions that are necessary 
 * at the termination of a simulation.  For example, if memory was allocated 
 * in mdlInitializeConditions, this is the place to free it. 
 */ 
static void mdlTerminate(S) 
    SimStruct *S; 
{ 
} 
#include "linsolv.c"    /* includes linsolve routine dposv_ linear equation solver*/ 
#ifdef MATLAB_MEX_FILE    /* Is this file being compiled as a MEX-file? */ 
#include "simulink.c"      /* MEX-file interface mechanism */ 
#else 
#include "cg_sfun.h"       /* Code generation registration function */ 
#endif 
