(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    282988,       7612]*)
(*NotebookOutlinePosition[    357534,       9435]*)
(*  CellTagsIndexPosition[    356717,       9406]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["TSi ProPac: Dynamics", "Title",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  TextAlignment->Left,
  AspectRatioFixed->True],

Cell["Harry G. Kwatny", "Subtitle"],

Cell["\<\
Department of Mechanical Engineering & Mechanics
Drexel University\
\>", "Subsubtitle"],

Cell[CellGroupData[{

Cell["Chris LaVigna", "Subtitle"],

Cell["Techno-Sciences, Incorporated", "Subsubtitle"],

Cell[BoxData[
    \(Off[General::spell]; \nOff[General::spell1]; \)], "Input",
  CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Introduction"],

Cell["\<\
TSi ProPac: Dynamics is a Mathematica package containing functions that \
support the assembly of mathematical models and simulation models for \
mechanical systems.  In its current form, Dynamics accommodates tree \
structures composed of combinations of rigid and flexible bodies and simple \
and compound kinematic joints, and which may also have supplemental algebraic \
and/or differential constraints. Thus, systems with closed loops and \
nonholonomic joints can be treated. 

Dynamics creates fully nonlinear, explicit models. The model building process \
requires that the user provide defining data for individual joints and \
bodies, as well as the system interconnection structure. The joints are \
defined in terms of their primitive action parameters from which all the \
required kinematic relations are derived. Thus, a user can contrive unusual \
joint configurations and is not restricted to a predefined set of standard \
joints. The equations are formulated in Poincare's form of Lagrange's \
equations that admits the standard Lagrange equations as a special case. \
However, Poincare's form allows the exploitation of quasi-velocities which \
can significantly simplify the equations of motion.

Dynamics assembles the equations of motion and it contains functions that \
facilitate simulation. Simulation may done within Mathematica  or externally \
using some other simulation software. Dynamics includes functions that assist \
in performing simulations using the NDSolve function in Mathematica and other \
functions to construct a C-code subroutine that compiles as an S-Function for \
use with MATLAB/SIMULINK.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Introduction"]
}, Closed]],

Cell[CellGroupData[{

Cell["Getting Started", "Section",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Getting Started"],

Cell[TextData[{
  "This notebook illustrates the tools provided in Dynamics including a few \
new functions contained in Version 3.0. Dynamics is contained in the \
directory ProPac. ProPac can be placed anywhwere you like, but a search path \
must be defined for it. It is most convenient to place ProPac in the \
AddOns\\Applications directiory, i.e, C:\\Program Files\\Wolfram Research\\",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\\3.0\\AddOns\\Applications. Once ProPac isloaded all of the functions in \
Dynamics as well as other packages included in TSi ProPac will be available \
for use and loaded as when needed."
}], "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Getting Started"],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3 ProPac can be loaded with the command"
}], "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Getting Started"],

Cell[CellGroupData[{

Cell["<<ProPac`", "Input",
  CellLabel->"In[2]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Getting Started"],

Cell[BoxData[
    \("\n    This is a development version of ProPac - Version 1.xx\n \n \
ProPac has been successfully loaded. It contains packages\n for multibody \
dynamics, linear control and nonlinear control.\n Appropriate packages will \
be loaded automatically as required.\n Packages can be manually loaded by \
simply entering GeometricTools,\n Dynamics, LinearControl, NonlinearControl \
or MEXTools as desired.\n Once a package is loaded, enter ?GeomtricTools, \
?Dynamics,\n ?LinearControl, ?NonlinearControl, or ?MEXTools, respectively,\n \
to obtain a list of available functions. Help is also available\n in the Help \
Browser under Add-ons."\)], "Print",
  CellTags->"Getting Started"]
}, Open  ]],

Cell[TextData[{
  "With ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 2.2 use the command ProPac`Master`."
}], "Text",
  CellTags->"Getting Started"]
}, Closed]],

Cell[CellGroupData[{

Cell["The Basics of TSi Dynamics", "Section",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["What's in the Package?", "Subsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"What's in the Package"],

Cell["\<\
To find out what functions are available in Dynamics simply use the commands:\
\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"What's in the Package"],

Cell[CellGroupData[{

Cell["Dynamics", "Input",
  CellLabel->"In[3]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"What's in the Package"],

Cell[BoxData[
    \("  *** Dynamics successfully loaded ***"\)], "Print",
  CellTags->"What's in the Package"],

Cell[BoxData[
    \(Dynamics\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"What's in the Package"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Dynamics\)\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"What's in the Package"],

Cell[BoxData[
    \("Functions included in the Dynamics package are:\n \n Kinematics:\n \
RotationMatrixEuler, ConfigurationMatrixEuler,\n \
AToATilda,ATildaToA,SimpleJointKinematics,\n \
CompoundJointKinematics,CompoundJointMap,Joints,\n \
JointRotation,JointTranslation,CompoundJointConfiguration,\n \
SimpleJointConfiguration,RotationMatrixToEuler,\n \
EndEffector,RelativeConfiguration,\n NodeVelocity,KinematicReplacements,\n \n \
Generalized Forces & Potential Functions:\n \
GeneralizedForce,DamperForce,SpringForce,GravPotential,\n \
SpringPotential,DamperPotential,LeafPotential,\n \
RayleighDissipationForce,BacklashPotential,\n \
BacklashForce,JointFrictionPotential,\n FlxDissPot,FlxStrnPot,\n \n Inertial \
Parameters: RgdBdyInrShift,ChainInertia,TreeInertia,\n \n Model Assembly:\n \
CMatrix,CreateModelSpecial,CreateModel,\n \
PoincareCoefficients,PoincareFunctionCombined,PoincareFunction,\n \
AlgebraicConstraints,DifferentialConstraints,\n MakeODEs,StateTransformation, \
MakeLagrangeEquations,\n CreateModelMEX,FindMostFrequentTerms,\n \n \
Miscellaneous:\n SeriesExpansion,Truncate,MatlabForm\n "\)], "Print",
  CellTags->"What's in the Package"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?GeneralizedForce\)\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"What's in the Package"],

Cell[BoxData[
    \("Q=GeneralizedForce[ChnLst,TerminalNode,BodyLst,X,H,q,p,Force,VelNames],\
\n where\n \n   ChnLst and TerminalNode define the location of the point at \
which the\n   external force is applied. ChnLst defines a chain and \
TerminalNode is\n   the number of the node of interest in the last body of \
the chain.\n \n   BodyLst is the list of system body data.\n \n   X,H,q,p are \
the usual lists of joint data.\n \n   F is a list of 6 expressions which \
defines the external torques (first\n   three) and forces (last three) in \
terms of body velocities (velocities\n   of a body fixed frame at the \
terminal node).\n \n   VelNames is a list of (6) names of the velocities used \
in the expressions\n   F. There must be six names - the first 3 corresponding \
to the angular\n   velocity and the last 3 to the linear velocity.\n \n   Q \
is the generalized force vector.\n \n GeneralizedForce sets up the \
appropriate data structures to use\n NodeVelocity\n \n An alternative calling \
syntax is\n \n \
Q=GeneralizedForce[TerminalNode,TreeLst,BodyLst,X,H,q,p,Force,VelNames]\n \n \
in which case the appropriate chain is identified from the system data"\)], 
  "Print",
  CellTags->"What's in the Package"]
}, Open  ]],

Cell["\<\
Information about any of these functions can be obtained in the usual way \
with ?Function. Most users will find that only a few of these functions are \
necessary for creating models and simulations. The most important are:
   Joints: generates all kinematic functions for list of joints
   CreateModel: creates the dynamic model parameters for tree structures from \
system data   
  EndEffector & NodeVelocity: creates the position, orientation and velocity \
of a body frame located at specified nodes as functions of configuration \
coordinates
   SpringPotential & LeafPotential: the former creates the potential energy \
function of a spring (defined by a local energy function) connected between \
specified nodes, the latter performs a similar function for energy storage \
elements that act between a system node and the space frame
   GeneralizedForce, Spring & DamperForce: the former is a general function \
for forming the generalized force vector from a local force acting at a \
specified node, and the latter two are specific for a spring (defined by a \
local potential function) and a damper (defined by a local disspation \
function) connected between specified system nodes
   AlgebraicConstraints & DifferentialConstraints: these account for \
algebraic and differential constraints added to a tree structure
   MakeODEs & CreateModelMEX: the former assembles the ordinary differential \
equations from the model parmeters generated by other functions into a form \
for numerical computation within Mathematica, the latter builds a C source \
function for computation in MATLAB/SIMULINK.
After describing the basic data structures used by TSi Dynamics we will \
illustrate the use of these and some other functions.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"What's in the Package"]
}, Closed]],

Cell[CellGroupData[{

Cell["Data Structures", "Subsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Data Structures"],

Cell[CellGroupData[{

Cell["Tree Structures", "Subsubsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Data Structures"],

Cell[TextData[
"Dynamics builds models for mechanical systems that have an underlying tree \
topology. Chain structures are a special case. Systems with closed loops are \
accommodated by adding constraints to the underlying tree.\nA tree consisting \
of n bodies also contains n joints. Every system contains a base reference \
frame which is designated body '0'. Otherwise, bodies and joints can be \
numbered arbitrarily. Joint data and body data are organized into lists by \
the analyst, i.e.:\n\tJointList={JointData_1,...,BodyData_n}\n\t\
BodyList={BodyData_1,...,BodyData_n}\nThe structure ofthe individual data \
objects will be described below. Joints and bodies are implicitly numbered by \
there position in the data lists.\nEach body contains a unique 'inboard' \
node, corresponding to (the outboard side of) a joint through which the body \
connects to an inner branch of the tree, or to the root (body 0). Each body \
may also contain outboard nodes. The outboard nodes are distinguished body \
locations that may be associated with a joint location (the inboard side of \
the joint), a sensor location, a point of application of an external force or \
any other feature of interest. Since one joint connects the tree to the root \
(the root node may be considered an outboard node of body 0), there must be \
at least n-1 outboard nodes among the n bodies corresponding to the remaining \
n-1 joints. These are the n 'outboard joint nodes'. The outboard joint nodes \
must be numbered 1 through n and must correspond to the associated joint \
number. The specific association of numbers to joints is not essential but by \
convention the root node is normally assigned the number 1. The remaining \
outboard notes can be numbered arbitrarily. The inboard nodes need not be \
assigned numbers.\nIn summary there are two important book-keeping \
principles:\n\t\[Bullet] joints and bodies are numbered according to their \
position in the data lists,\n\t\[Bullet] output joint nodes must be numbered \
consistently with their repective joints.\nA tree is composed of a set of \
defining chains. For instance consider a tree composed of the following \
sequences of bodies:\n                                       0,1,2,4      \
0,1,2,3,5      0,1,2,3,6\nAll defining chains of any tree will start with \
body 0, so we need not list it. However, the body sequences alone do not \
adequately define a tree. For instance bodies 5 and 6 both connect to body 3, \
but they will do so through different joints. This information can be \
provided by defining each chain as an ordered list of pairs - each pair \
consisting of a body and its inboard joint: {inboard joint, body}. For \
example:\n            {{1,1},{2,2},{5,4}}      {{1,1},{2,2},{3,3},{4,5}}      \
{{1,1},{2,2},{3,3},{6,6}}\nindicates that body 5 connects to body 3 at joint \
4, and body 6 connects to body 3 at joint 6. Recall that each joint is \
uniquely associated with an outboard node of a particular body.\nA tree is \
defined by the data structure:\n    Tree = {list of chains}\n    chain = \
ordered list of pairs {inboard joint, body}\n              =  {{first inboard \
joint, first body},...,{last inboard joint, last body}}"], "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Data Structures"]
}, Closed]],

Cell[CellGroupData[{

Cell["Reference Frames", "Subsubsection",
  CellTags->"Data Structures"],

Cell["\<\
It is assumed that there is a single inertially fixed reference frame whose \
origin is the inboard side of the root  joint.  Each body has a primary \
reference frame, fixed in the body with origin at the inboard node. Body data \
is defined in this frame. As appropriate, there may be other body fixed \
frames as well with origins at outboard node locations. Normally, the axes of \
these frames are parallel to the primary frame when the body is undeformed. \
For the system as a whole, there is a 'reference configuration' corresponding \
to the nominal joint configurations (associated with zero joint motion \
parameters) and undeformed bodies. In the reference configuration all \
reference frames (body and space) are alligned. The analyst sets up the \
reference configuration when choosing body frame orientations for joint and \
body data definitions. It is recommended that the analyst begin by defining a \
physically meaningful reference configuration from which data definitions \
will logically follow.\
\>", "Text",
  CellTags->"Data Structures"]
}, Closed]],

Cell[CellGroupData[{

Cell["Joints", "Subsubsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Data Structures"],

Cell[TextData[
"Joints constrain the relative motion between two bodies, or more precisely, \
between two reference frames  - one fixed in each body on either side of the \
joint. In TSi Dynamics, joints are of two types: simple and compound. Simple \
joints directly define relative motion between the two reference frames, \
whereas compound joints require intermediate reference frames to define the \
overall motion.\nSimple joints are characterized by the number of degrees of \
freedom, r, an r-vector of joint quasi-velocities, p, and a 6xr joint map \
matrix, H. Across the joint the relative velocity vector (\[CapitalDelta]w, \
\[CapitalDelta]V) is Hp. Moreover, H is a constant (independent of the joint \
configuration) and the columns represent the joint action axes in the \
outboard frame (by convention). A compound joint is equivalent to a sequence \
of simple joints. Thus, it is necessary to define a set of numbers that \
represent the degrees of freedom associated with each intermediate frame and \
a corresponding set of (constant) joint map matrices. When defining a joint \
in TSi Dynamics, it is necessary to also assign names for both the joint \
quasi-velocities and joint configuration variables.\nA k-frame compound joint \
with n degrees of freedom is defined by the data structure:\n                 \
                                           {r, H,q,p} \nwhere \n   r = \
k-vector whose elements define the number of degrees of freedom for each \
simple joint, with n = r1 +.. + rk. \n   H = [H1 .. Hk], a matrix composed of \
the k joint map matrices of the simple joints.\n   q = n-vector of joint \
coordinate names.\n   p = n-vector of joint quasi-velocity names.  \nLet us \
consider some elementary examples.\nA two degree of freedom revolute joint as \
a simple joint (spherical joint):"], "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Data Structures"],

Cell["\<\
r1={2};H1={{1,0},{0,0},{0,1},{0,0},{0,0},{0,0}};
q1={a1x,a1z};p1={w1x,w1z};\
\>", "Input",
  CellLabel->"In[6]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Data Structures"],

Cell["\<\
A two degree of freedom revolute joint as a compound joint (universal joint):\
\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Data Structures"],

Cell["\<\
r2={1,1};H2={{1,0},{0,0},{0,1},{0,0},{0,0},{0,0}};
q2={a2x,a2z};p2={w2x,w2z};\
\>", "Input",
  CellLabel->"In[8]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Data Structures"],

Cell["\<\
The function Joints computes all of the necessary quantities for modeling a \
list of joints. These include the kinematic matrix V(q), the Euclidean \
configuration matrix X(q), and the overall joint map matrix H(q). These are \
reported as lists.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Data Structures"],

Cell[CellGroupData[{

Cell["\<\
JointLst={{r1,H1,q1,p1},{r2,H2,q2,p2}};

{V,X,H}=Joints[JointLst];\
\>", "Input",
  CellLabel->"In[10]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Data Structures"],

Cell[BoxData[
    \("Computing joint 1 kinematics"\)], "Print",
  CellTags->"Data Structures"],

Cell[BoxData[
    \("Computing joint 2 kinematics"\)], "Print",
  CellTags->"Data Structures"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Print[V]", "Input",
  CellLabel->"In[12]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Data Structures"],

Cell[BoxData[
    \({{{1, 0}, {0, Cos[a1x]}}, {{1, 0}, {0, 1}}}\)], "Print",
  CellTags->"Data Structures"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Print[X]", "Input",
  CellLabel->"In[13]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Data Structures"],

Cell[BoxData[
    \({{{Cos[a1z], \(-Cos[a1x]\)\ Sin[a1z], Sin[a1x]\ Sin[a1z], 0}, {
          Sin[a1z], Cos[a1x]\ Cos[a1z], \(-Cos[a1z]\)\ Sin[a1x], 0}, {0, 
          Sin[a1x], Cos[a1x], 0}, {0, 0, 0, 1}}, {{Cos[a2z], 
          \(-Cos[a2x]\)\ Sin[a2z], Sin[a2x]\ Sin[a2z], 0}, {Sin[a2z], 
          Cos[a2x]\ Cos[a2z], \(-Cos[a2z]\)\ Sin[a2x], 0}, {0, Sin[a2x], 
          Cos[a2x], 0}, {0, 0, 0, 1}}}\)], "Print",
  CellTags->"Data Structures"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Print[H]", "Input",
  CellLabel->"In[14]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Data Structures"],

Cell[BoxData[
    \({{{1, 0}, {0, 0}, {0, 1}, {0, 0}, {0, 0}, {0, 0}}, {{1, 0}, {0, 
          Sin[a2x]}, {0, Cos[a2x]}, {0, 0}, {0, 0}, {0, 0}}}\)], "Print",
  CellTags->"Data Structures"]
}, Open  ]],

Cell["\<\
Notice that joints 1 and 2 produce the same Euclidean configuration matrix. \
Thus, the configuration coordinates have the same physical meaning. Other \
observations are: (i) the overall joint map matrix for a compound joint \
depends on the joint configuration parameters, and (ii) the kinematic matrix \
is simpler for a compound joint representation than for a simple joint \
representation. A free or unconstrainedbody would be modeled using a six \
degree of freedom joint, such as\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Data Structures"],

Cell[CellGroupData[{

Cell["\<\
r3={6}; H3=IdentityMatrix[6];
q3={ax,ay,az,x,y,z}; p3={wx,wy,wz,ux,uy,uz};

JointLst={{r3,H3,q3,p3}};

{V,X,H}=Joints[JointLst];\
\>", "Input",
  CellLabel->"In[15]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Data Structures"],

Cell[BoxData[
    \("Computing joint 1 kinematics"\)], "Print",
  CellTags->"Data Structures"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Print[V]", "Input",
  CellLabel->"In[19]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Data Structures"],

Cell[BoxData[
    \({{{1, Sin[ax]\ Tan[ay], Cos[ax]\ Tan[ay], 0, 0, 0}, {0, Cos[ax], 
          \(-Sin[ax]\), 0, 0, 0}, {0, Sec[ay]\ Sin[ax], Cos[ax]\ Sec[ay], 0, 
          0, 0}, {0, 0, 0, Cos[ay]\ Cos[az], 
          Cos[az]\ Sin[ax]\ Sin[ay] - Cos[ax]\ Sin[az], 
          Cos[ax]\ Cos[az]\ Sin[ay] + Sin[ax]\ Sin[az]}, {0, 0, 0, 
          Cos[ay]\ Sin[az], Cos[ax]\ Cos[az] + Sin[ax]\ Sin[ay]\ Sin[az], 
          \(-Cos[az]\)\ Sin[ax] + Cos[ax]\ Sin[ay]\ Sin[az]}, {0, 0, 0, 
          \(-Sin[ay]\), Cos[ay]\ Sin[ax], Cos[ax]\ Cos[ay]}}}\)], "Print",
  CellTags->"Data Structures"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Print[X]", "Input",
  CellLabel->"In[20]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Data Structures"],

Cell[BoxData[
    \({{{Cos[ay]\ Cos[az], Cos[az]\ Sin[ax]\ Sin[ay] - Cos[ax]\ Sin[az], 
          Cos[ax]\ Cos[az]\ Sin[ay] + Sin[ax]\ Sin[az], x}, {
          Cos[ay]\ Sin[az], Cos[ax]\ Cos[az] + Sin[ax]\ Sin[ay]\ Sin[az], 
          \(-Cos[az]\)\ Sin[ax] + Cos[ax]\ Sin[ay]\ Sin[az], y}, {
          \(-Sin[ay]\), Cos[ay]\ Sin[ax], Cos[ax]\ Cos[ay], z}, {0, 0, 0, 1}}}
      \)], "Print",
  CellTags->"Data Structures"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Print[H]", "Input",
  CellLabel->"In[21]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Data Structures"],

Cell[BoxData[
    \({{{1, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 0}, {0, 0, 0, 
          1, 0, 0}, {0, 0, 0, 0, 1, 0}, {0, 0, 0, 0, 0, 1}}}\)], "Print",
  CellTags->"Data Structures"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Rigid Bodies", "Subsubsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Data Structures"],

Cell["\<\
A rigid body is defined by its mass, inertia matrix and the location of \
distinguished points or nodes where joints or sensors may be located. We \
assume the following:
1) There is a distinguished point that corresponds to the inboard joint of \
the body. The body frame has its origin located there. 
2) The center of mass and all other points of interest (nodes) including \
outboard joint locations are defined in the body frame.
3) The inertia matrix is defined in the body frame and it is the inertia \
matrix about the center of mass.
The data for a rigid body is organized in a list as follows. A rigid body \
with k outboard nodes is defined by the data structure:
                                    {com,{out1,..,outk},m,Inertia}
where 
   com is the center of mass location, 
   outi = {node number, location} for the ith outboard node, 
   m is the mass, and 
   Inertia is the 3x3 inertia tensor (about the center of mass). It may also \
be specified as a 6x6 spatial inertia tensor. In this      case it is assumed \
specified about the inboard joint. This type of specification is useful, for \
example, when dealing with submerged bodies where a fluid loaded inertia \
needs to be specified.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Data Structures"]
}, Closed]],

Cell[CellGroupData[{

Cell["Flexible Bodies", "Subsubsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Data Structures"],

Cell["\<\
Dynamics accommodates flexible bodies which satisfy the following \
assumptions:
- Local deformations are small, so that linear stiffness (quadratic strain \
energy) and dissipation (quadratic dissipation function) relationships apply.
 -  Body deformations can be characterized by a finite set of deformation \
coordinates, denoted by x. 
-  Body frame center of mass location and joint locations and orientations \
can be defined as (affine) linear functions of the deformation coordinates.
Any flexible body model in which a modal representation of flexure is valid \
satisfies these assumptions. Even with these assumptions, large global \
deformations are possible in which case the body inertia matrix as \
represented in the primary body frame may be a function of the deformation \
coordinates.
The primary body reference frame is a frame fixed in an infinitesimal body \
element with origin at the inboard joint location. We use the following \
notation for specifying the location of points in the primary frame under \
deformation. Let x be the n-vector of deformation coordinates. From the \
linearity assumption the position y of any point P in the body under \
deformation can be characterized by a matrix C and the relation
                                                   y = C.{1, x}
where C is a 3x(n+1) matrix. This is the type of information required to \
locate the center of gravity in the deformed body.
More information is typically required for general nodes at which sensors or \
joints are located. Here it is necessary to determine both the position of \
the node and the angular orientation of a local reference frame fixed in an \
infinitesimal element at the node. Under the small deformation assumption the \
orientation can be specified by any set of local parameters. We use Euler \
angles (3-2-1 convention). The orientation and position of the frame is \
defined by a 6-vector Y, the first three elements being the angles and the \
last three the position vector all relative to and specified in the primary \
body frame. As above, Y can be characterized by a matrix C
                                                  Y = C.{1,x}
where C is a 6x(n+1) matrix.
A flexible body with k outboard nodes and n deformation coordinates is \
defined by the data structure:
                       {Ccom,{out1,..,outk},m,{M(x),B,K},x,v}
where Ccom is a 3x(n+1) matrix that defines the center of mass location, 
   outi = {node number, Couti}, where Couti is a 6x(n+1) matrix that defines \
the orientation and location of the ith outboard node
   m is the mass 
   M(x) is the inertia matrix, B is the dissipation matrix, K is the \
stiffness matrix
   x is an n-vector of deformation coordinate names
   v is an n-vector of deformation velocity names\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Data Structures"]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["A First Example: The Double Pendulum"], "Section",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Building the Equations of Motion", "Subsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Building Equations"],

Cell["\<\
Building a model in TSi Dynamics generally proceeds in the following way:
  - Define joint data.
  - Define body data.
  - Define interconnection structure.
  - Define potential energy function and generalized forces.
  - Assemble the model.
The following is a simple example.
Define Joint Data\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Building Equations"],

Cell["\<\
r1={1};H1={{1},{0},{0},{0},{0},{0}};
q1={a1x};p1={w1x};

r2={1};H2={{1},{0},{0},{0},{0},{0}};
q2={a2x};p2={w2x};

JointLst={{r1,H1,q1,p1},{r2,H2,q2,p2}};\
\>", "Input",
  CellLabel->"In[22]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Building Equations", "i:1"}],

Cell["Define Body Data", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Building Equations"],

Cell["\<\
com1={0,0,-l1}; mass1=m1; out1={2,{0,0,-l1}};
Inertia1=DiagonalMatrix[{0,0,0}];

com2={0,0,-l2}; mass2=m2; out2={3,{0,0,-l2}};
Inertia2=DiagonalMatrix[{0,0,0}];

BodyLst={{com1,{out1},mass1,Inertia1},{com2,{out2},mass2,Inertia2}};\
\>", "Input",
  CellLabel->"In[27]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Building Equations"],

Cell["Define Interconnection Structure", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Building Equations"],

Cell["TreeLst={{{1,1},{2,2}}};", "Input",
  CellLabel->"In[32]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Building Equations"],

Cell["\<\
Define Potential Energy
In this case only gravity contributes to the potential energy. The only \
generalized forces are external torques acting at the two joints.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Building Equations"],

Cell["g=gc; PE=0; Q={T1,T2};", "Input",
  CellLabel->"In[33]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Building Equations"],

Cell[CellGroupData[{

Cell["\<\
{V,X,H,M,Cp,Fp,p,q}=CreateModel[JointLst,BodyLst,TreeLst,g,PE,Q];\
\>", "Input",
  CellLabel->"In[34]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Building Equations"],

Cell[BoxData[
    \("Computing Joint Kinematics"\)], "Print",
  CellTags->"Building Equations"],

Cell[BoxData[
    \("Computing joint 1 kinematics"\)], "Print",
  CellTags->"Building Equations"],

Cell[BoxData[
    \("Computing joint 2 kinematics"\)], "Print",
  CellTags->"Building Equations"],

Cell[BoxData[
    \("Computing Potential Functions"\)], "Print",
  CellTags->"Building Equations"],

Cell[BoxData[
    \("Computing Inertia Matrix"\)], "Print",
  CellTags->"Building Equations"],

Cell[BoxData[
    \("Computing Poincare Function"\)], "Print",
  CellTags->"Building Equations"]
}, Open  ]],

Cell["We can look at some results.", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Building Equations"],

Cell[CellGroupData[{

Cell["Print[MatrixForm[V]]", "Input",
  CellLabel->"In[35]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Building Equations"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"(", GridBox[{
            {
              RowBox[{"(", GridBox[{
                    {"1"}
                    }], ")"}]},
            {
              RowBox[{"(", GridBox[{
                    {"1"}
                    }], ")"}]}
            }], ")"}],
      MatrixForm[ {{{1}}, {{1}}}]]], "Print",
  CellTags->"Building Equations"]
}, Open  ]],

Cell["\<\
Recall that V returns as a list of kinematic matrices- one for each joint. \
Hence in this case we get two 1x1 matrices. This can be assembled into a \
single block diagonal matrix but it is more efficient to retain the list \
form.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Building Equations"],

Cell[CellGroupData[{

Cell["Print[MatrixForm[M]]", "Input",
  CellLabel->"In[36]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Building Equations"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {
              \(l1\^2\ m1 + l2\^2\ m2 + l1\ l2\ m2\ Cos[a2x] + 
                l1\ Cos[a2x]\ \((l2\ m2 + l1\ m2\ Cos[a2x])\) + 
                l1\^2\ m2\ Sin[a2x]\^2\), 
              \(l2\^2\ m2 + l1\ l2\ m2\ Cos[a2x]\)},
            {\(l2\^2\ m2 + l1\ l2\ m2\ Cos[a2x]\), \(l2\^2\ m2\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Print",
  CellTags->"Building Equations"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Print[MatrixForm[Fp]]", "Input",
  CellLabel->"In[37]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Building Equations"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"(", GridBox[{
            {
              \(\(-T1\) + 
                gc\ \((l1\ \((m1 + m2)\)\ Sin[a1x] + l2\ m2\ Sin[a1x + a2x])
                    \)\)},
            {\(\(-T2\) + gc\ l2\ m2\ Sin[a1x + a2x]\)}
            }], ")"}],
      MatrixForm[ {
        Plus[ 
          Times[ -1, T1], 
          Times[ gc, 
            Plus[ 
              Times[ l1, 
                Plus[ m1, m2], 
                Sin[ a1x]], 
              Times[ l2, m2, 
                Sin[ 
                  Plus[ a1x, a2x]]]]]], 
        Plus[ 
          Times[ -1, T2], 
          Times[ gc, l2, m2, 
            Sin[ 
              Plus[ a1x, a2x]]]]}]]], "Print",
  CellTags->"Building Equations"]
}, Open  ]],

Cell["\<\
When doing time consuming computations you may want to save results \
periodically and then reload them for later computations. Since, as an \
analysis proceeds, different data sets may be saved under the same file name, \
it is a good idea to delete any older file before the new one is saved.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Building Equations"],

Cell["\<\
DeleteFile[\"dbl_pend.dat\"];
Save[\"dbl_pend.dat\",p,q,V,X,H,Cp,Fp,M];\
\>", "Input",
  CellLabel->"In[38]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Building Equations"],

Cell["Of course, the data is reloaded by the standard:", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Building Equations"],

Cell["<<dbl_pend.dat;", "Input",
  CellLabel->"In[40]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Building Equations"]
}, Closed]],

Cell[CellGroupData[{

Cell["Simulation: Numerical Solution", "Subsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Simulation", "i:2"}],

Cell["\<\
We can easily construct a simulation within Mathematica. First assemble the \
system parameter matrices computed above into a system of ordinary \
differential equations using the TSi Dynamics function MakeODEs.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Simulation", "i:2"}],

Cell[CellGroupData[{

Cell["Equations=MakeODEs[p,q,V,M,Cp,Fp,t]", "Input",
  CellLabel->"In[41]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Simulation", "i:2"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["a1x", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", \(w1x[t]\)}], 
        ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["a2x", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", \(w2x[t]\)}], 
        ",", 
        RowBox[{
          
          RowBox[{\(-T1\), 
            "+", \(gc\ \((l1\ \((m1 + m2)\)\ Sin[a1x[t]] + 
                  l2\ m2\ Sin[a1x[t] + a2x[t]])\)\), 
            "+", \(w2x[
                t]\ \((\((\(-l1\)\ l2\ m2\ Sin[a2x[t]] + 
                        l1\^2\ m2\ Cos[a2x[t]]\ Sin[a2x[t]] - 
                        l1\ \((l2\ m2 + l1\ m2\ Cos[a2x[t]])\)\ Sin[
                            a2x[t]])\)\ w1x[t] - 
                  l1\ l2\ m2\ Sin[a2x[t]]\ w2x[t])\)\), "+", 
            
            RowBox[{\((l1\^2\ m1 + l2\^2\ m2 + l1\ l2\ m2\ Cos[a2x[t]] + 
                  l1\ Cos[a2x[t]]\ \((l2\ m2 + l1\ m2\ Cos[a2x[t]])\) + 
                  l1\^2\ m2\ Sin[a2x[t]]\^2)\), " ", 
              RowBox[{
                SuperscriptBox["w1x", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{\((l2\^2\ m2 + l1\ l2\ m2\ Cos[a2x[t]])\), " ", 
              RowBox[{
                SuperscriptBox["w2x", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}]}], "==", "0"}], 
        ",", 
        RowBox[{
          
          RowBox[{\(-T2\), "+", \(gc\ l2\ m2\ Sin[a1x[t] + a2x[t]]\), 
            "-", \(1\/2\ l1\ l2\ m2\ Sin[a2x[t]]\ w1x[t]\ w2x[t]\), 
            "+", \(1\/2\ w1x[
                t]\ \((\(-\((\(-l1\)\ l2\ m2\ Sin[a2x[t]] + 
                          l1\^2\ m2\ Cos[a2x[t]]\ Sin[a2x[t]] - 
                          l1\ \((l2\ m2 + l1\ m2\ Cos[a2x[t]])\)\ Sin[
                              a2x[t]])\)\)\ w1x[t] + 
                  l1\ l2\ m2\ Sin[a2x[t]]\ w2x[t])\)\), "+", 
            RowBox[{\((l2\^2\ m2 + l1\ l2\ m2\ Cos[a2x[t]])\), " ", 
              RowBox[{
                SuperscriptBox["w1x", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{\(l2\^2\), " ", "m2", " ", 
              RowBox[{
                SuperscriptBox["w2x", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}]}], "==", 
          "0"}]}], "}"}]], "Output",
  CellLabel->"Out[41]=",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]],

Cell["\<\
Now, replace parameter symbols by numbers and set up initial conditions.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Simulation", "i:2"}],

Cell[CellGroupData[{

Cell["DataReplacements={m1->1,l1->2,m2->1,l2->1,gc->1,T1->0,T2->0}", "Input",
  CellLabel->"In[42]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Simulation", "i:2"}],

Cell[BoxData[
    \({m1 \[Rule] 1, l1 \[Rule] 2, m2 \[Rule] 1, l2 \[Rule] 1, gc \[Rule] 1, 
      T1 \[Rule] 0, T2 \[Rule] 0}\)], "Output",
  CellLabel->"Out[42]=",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equations1=Equations/.DataReplacements", "Input",
  CellLabel->"In[43]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Simulation", "i:2"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["a1x", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", \(w1x[t]\)}], 
        ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["a2x", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", \(w2x[t]\)}], 
        ",", 
        RowBox[{
          
          RowBox[{\(4\ Sin[a1x[t]]\), "+", \(Sin[a1x[t] + a2x[t]]\), 
            "+", \(w2x[
                t]\ \((\((\(-2\)\ Sin[a2x[t]] + 4\ Cos[a2x[t]]\ Sin[a2x[t]] - 
                        2\ \((1 + 2\ Cos[a2x[t]])\)\ Sin[a2x[t]])\)\ w1x[t] - 
                  2\ Sin[a2x[t]]\ w2x[t])\)\), "+", 
            
            RowBox[{\((5 + 2\ Cos[a2x[t]] + 
                  2\ Cos[a2x[t]]\ \((1 + 2\ Cos[a2x[t]])\) + 
                  4\ Sin[a2x[t]]\^2)\), " ", 
              RowBox[{
                SuperscriptBox["w1x", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{\((1 + 2\ Cos[a2x[t]])\), " ", 
              RowBox[{
                SuperscriptBox["w2x", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}]}], "==", "0"}], 
        ",", 
        RowBox[{
          
          RowBox[{\(Sin[a1x[t] + a2x[t]]\), 
            "-", \(Sin[a2x[t]]\ w1x[t]\ w2x[t]\), 
            "+", \(1\/2\ w1x[
                t]\ \((\(-\((\(-2\)\ Sin[a2x[t]] + 
                          4\ Cos[a2x[t]]\ Sin[a2x[t]] - 
                          2\ \((1 + 2\ Cos[a2x[t]])\)\ Sin[a2x[t]])\)\)\ w1x[
                      t] + 2\ Sin[a2x[t]]\ w2x[t])\)\), "+", 
            RowBox[{\((1 + 2\ Cos[a2x[t]])\), " ", 
              RowBox[{
                SuperscriptBox["w1x", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{
              SuperscriptBox["w2x", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", "0"}]}], 
      "}"}]], "Output",
  CellLabel->"Out[43]=",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["vars=Join[p,q]", "Input",
  CellLabel->"In[44]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Simulation", "i:2"}],

Cell[BoxData[
    \({w1x, w2x, a1x, a2x}\)], "Output",
  CellLabel->"Out[44]=",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
InitialConditions=Table[ToExpression[StringJoin[ToString[vars[[i]]],\"[0]==0\"\
]],{i,Length[vars]}]\
\>", "Input",
  CellLabel->"In[45]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Simulation", "i:2"}],

Cell[BoxData[
    \({w1x[0] == 0, w2x[0] == 0, a1x[0] == 0, a2x[0] == 0}\)], "Output",
  CellLabel->"Out[45]=",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
InitialConditions={w1x[0] == 0, w2x[0] == 0, a1x[0] == .1, a2x[0] == .2}\
\>", "Input",
  CellLabel->"In[46]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Simulation", "i:2"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(w1x[0] == 0\), ",", \(w2x[0] == 0\), ",", 
        RowBox[{\(a1x[0]\), "==", 
          StyleBox["0.1`",
            StyleBoxAutoDelete->True,
            PrintPrecision->1]}], ",", 
        RowBox[{\(a2x[0]\), "==", 
          StyleBox["0.2`",
            StyleBoxAutoDelete->True,
            PrintPrecision->1]}]}], "}"}]], "Output",
  CellLabel->"Out[46]=",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equations2=Join[Equations1,InitialConditions]", "Input",
  CellLabel->"In[47]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Simulation", "i:2"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["a1x", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", \(w1x[t]\)}], 
        ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["a2x", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", \(w2x[t]\)}], 
        ",", 
        RowBox[{
          
          RowBox[{\(4\ Sin[a1x[t]]\), "+", \(Sin[a1x[t] + a2x[t]]\), 
            "+", \(w2x[
                t]\ \((\((\(-2\)\ Sin[a2x[t]] + 4\ Cos[a2x[t]]\ Sin[a2x[t]] - 
                        2\ \((1 + 2\ Cos[a2x[t]])\)\ Sin[a2x[t]])\)\ w1x[t] - 
                  2\ Sin[a2x[t]]\ w2x[t])\)\), "+", 
            
            RowBox[{\((5 + 2\ Cos[a2x[t]] + 
                  2\ Cos[a2x[t]]\ \((1 + 2\ Cos[a2x[t]])\) + 
                  4\ Sin[a2x[t]]\^2)\), " ", 
              RowBox[{
                SuperscriptBox["w1x", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{\((1 + 2\ Cos[a2x[t]])\), " ", 
              RowBox[{
                SuperscriptBox["w2x", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}]}], "==", "0"}], 
        ",", 
        RowBox[{
          
          RowBox[{\(Sin[a1x[t] + a2x[t]]\), 
            "-", \(Sin[a2x[t]]\ w1x[t]\ w2x[t]\), 
            "+", \(1\/2\ w1x[
                t]\ \((\(-\((\(-2\)\ Sin[a2x[t]] + 
                          4\ Cos[a2x[t]]\ Sin[a2x[t]] - 
                          2\ \((1 + 2\ Cos[a2x[t]])\)\ Sin[a2x[t]])\)\)\ w1x[
                      t] + 2\ Sin[a2x[t]]\ w2x[t])\)\), "+", 
            RowBox[{\((1 + 2\ Cos[a2x[t]])\), " ", 
              RowBox[{
                SuperscriptBox["w1x", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{
              SuperscriptBox["w2x", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", "0"}], 
        ",", \(w1x[0] == 0\), ",", \(w2x[0] == 0\), ",", 
        RowBox[{\(a1x[0]\), "==", 
          StyleBox["0.1`",
            StyleBoxAutoDelete->True,
            PrintPrecision->1]}], ",", 
        RowBox[{\(a2x[0]\), "==", 
          StyleBox["0.2`",
            StyleBoxAutoDelete->True,
            PrintPrecision->1]}]}], "}"}]], "Output",
  CellLabel->"Out[47]=",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]],

Cell["\<\
Finally, integrate the equations using the Mathematica function NDSolve and \
plot the results.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Simulation", "i:2"}],

Cell[CellGroupData[{

Cell["sols=NDSolve[Equations2,vars,{t,0,40}]", "Input",
  CellLabel->"In[48]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Simulation", "i:2"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"w1x", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 40.`}}, "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{"w2x", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 40.`}}, "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{"a1x", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 40.`}}, "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{"a2x", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 40.`}}, "<>"]\),
              False,
              Editable->False]}]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[48]=",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot[Evaluate[a1x[t]/.sols],{t,0,40}]", "Input",
  CellLabel->"In[49]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Simulation", "i:2"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0238095 0.30933 1.67182 [
[.2619 .29683 -6 -9 ]
[.2619 .29683 6 0 ]
[.5 .29683 -6 -9 ]
[.5 .29683 6 0 ]
[.7381 .29683 -6 -9 ]
[.7381 .29683 6 0 ]
[.97619 .29683 -6 -9 ]
[.97619 .29683 6 0 ]
[.01131 .05856 -30 -4.5 ]
[.01131 .05856 0 4.5 ]
[.01131 .14215 -24 -4.5 ]
[.01131 .14215 0 4.5 ]
[.01131 .22574 -30 -4.5 ]
[.01131 .22574 0 4.5 ]
[.01131 .39292 -24 -4.5 ]
[.01131 .39292 0 4.5 ]
[.01131 .47651 -18 -4.5 ]
[.01131 .47651 0 4.5 ]
[.01131 .5601 -24 -4.5 ]
[.01131 .5601 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.2619 .30933 m
.2619 .31558 L
s
[(10)] .2619 .29683 0 1 Mshowa
.5 .30933 m
.5 .31558 L
s
[(20)] .5 .29683 0 1 Mshowa
.7381 .30933 m
.7381 .31558 L
s
[(30)] .7381 .29683 0 1 Mshowa
.97619 .30933 m
.97619 .31558 L
s
[(40)] .97619 .29683 0 1 Mshowa
.125 Mabswid
.07143 .30933 m
.07143 .31308 L
s
.11905 .30933 m
.11905 .31308 L
s
.16667 .30933 m
.16667 .31308 L
s
.21429 .30933 m
.21429 .31308 L
s
.30952 .30933 m
.30952 .31308 L
s
.35714 .30933 m
.35714 .31308 L
s
.40476 .30933 m
.40476 .31308 L
s
.45238 .30933 m
.45238 .31308 L
s
.54762 .30933 m
.54762 .31308 L
s
.59524 .30933 m
.59524 .31308 L
s
.64286 .30933 m
.64286 .31308 L
s
.69048 .30933 m
.69048 .31308 L
s
.78571 .30933 m
.78571 .31308 L
s
.83333 .30933 m
.83333 .31308 L
s
.88095 .30933 m
.88095 .31308 L
s
.92857 .30933 m
.92857 .31308 L
s
.25 Mabswid
0 .30933 m
1 .30933 L
s
.02381 .05856 m
.03006 .05856 L
s
[(-0.15)] .01131 .05856 1 0 Mshowa
.02381 .14215 m
.03006 .14215 L
s
[(-0.1)] .01131 .14215 1 0 Mshowa
.02381 .22574 m
.03006 .22574 L
s
[(-0.05)] .01131 .22574 1 0 Mshowa
.02381 .39292 m
.03006 .39292 L
s
[(0.05)] .01131 .39292 1 0 Mshowa
.02381 .47651 m
.03006 .47651 L
s
[(0.1)] .01131 .47651 1 0 Mshowa
.02381 .5601 m
.03006 .5601 L
s
[(0.15)] .01131 .5601 1 0 Mshowa
.125 Mabswid
.02381 .07528 m
.02756 .07528 L
s
.02381 .09199 m
.02756 .09199 L
s
.02381 .10871 m
.02756 .10871 L
s
.02381 .12543 m
.02756 .12543 L
s
.02381 .15887 m
.02756 .15887 L
s
.02381 .17558 m
.02756 .17558 L
s
.02381 .1923 m
.02756 .1923 L
s
.02381 .20902 m
.02756 .20902 L
s
.02381 .24246 m
.02756 .24246 L
s
.02381 .25918 m
.02756 .25918 L
s
.02381 .27589 m
.02756 .27589 L
s
.02381 .29261 m
.02756 .29261 L
s
.02381 .32605 m
.02756 .32605 L
s
.02381 .34277 m
.02756 .34277 L
s
.02381 .35948 m
.02756 .35948 L
s
.02381 .3762 m
.02756 .3762 L
s
.02381 .40964 m
.02756 .40964 L
s
.02381 .42636 m
.02756 .42636 L
s
.02381 .44308 m
.02756 .44308 L
s
.02381 .45979 m
.02756 .45979 L
s
.02381 .49323 m
.02756 .49323 L
s
.02381 .50995 m
.02756 .50995 L
s
.02381 .52667 m
.02756 .52667 L
s
.02381 .54339 m
.02756 .54339 L
s
.02381 .04184 m
.02756 .04184 L
s
.02381 .02512 m
.02756 .02512 L
s
.02381 .0084 m
.02756 .0084 L
s
.02381 .57682 m
.02756 .57682 L
s
.02381 .59354 m
.02756 .59354 L
s
.02381 .61026 m
.02756 .61026 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .47651 m
.02499 .4766 L
.02605 .47683 L
.02729 .47728 L
.02846 .47787 L
.03053 .47932 L
.03279 .48142 L
.04262 .49437 L
.0452 .49777 L
.04762 .50046 L
.04894 .50161 L
.05015 .50244 L
.05083 .50279 L
.05149 .50304 L
.05217 .50322 L
.05293 .50329 L
.05418 .50312 L
.05532 .50262 L
.05663 .50162 L
.05786 .50023 L
.05901 .49853 L
.06006 .4966 L
.06244 .49089 L
.06488 .48303 L
.0675 .47225 L
.07221 .44664 L
.07782 .40636 L
.08293 .36169 L
.09418 .24837 L
.10458 .14841 L
.10935 .11143 L
.11383 .08406 L
.11608 .07329 L
.11851 .06401 L
.11982 .06 L
.1212 .05656 L
.12238 .05424 L
.12366 .05235 L
.12434 .05163 L
.12507 .05105 L
.12575 .0507 L
.12639 .05054 L
.12759 .05065 L
.12886 .05134 L
.12952 .05192 L
.13023 .05272 L
.13151 .05457 L
.13303 .05745 L
.13442 .06066 L
.13955 .07656 L
Mistroke
.14443 .09567 L
.15404 .13601 L
.15931 .15566 L
.16427 .1709 L
.16891 .18186 L
.17153 .18661 L
.17393 .19016 L
.17818 .19481 L
.18267 .19828 L
.18501 .19993 L
.18755 .20195 L
.18995 .20433 L
.19217 .20717 L
.19476 .21151 L
.1975 .21761 L
.20235 .23293 L
.20685 .25297 L
.21107 .27704 L
.22069 .34901 L
.23921 .51375 L
.24428 .55071 L
.24707 .56744 L
.24969 .58051 L
.25214 .59016 L
.25344 .59421 L
.2548 .59769 L
.25595 .59998 L
.25721 .60182 L
.25836 .60287 L
.25943 .60332 L
.26068 .6032 L
.26138 .60283 L
.26203 .60229 L
.26323 .60083 L
.2645 .59861 L
.26669 .5932 L
.26912 .58505 L
.27448 .55992 L
.27951 .52944 L
.28979 .45828 L
.30063 .38977 L
.30528 .36648 L
.31025 .34657 L
.3157 .3305 L
.32078 .31996 L
.3304 .30495 L
.33463 .29713 L
.33928 .28563 L
.34425 .26885 L
.34951 .2454 L
Mistroke
.3606 .17857 L
.37112 .10449 L
.37612 .07189 L
.38075 .04639 L
.38325 .03527 L
.38551 .02708 L
.38803 .02031 L
.38869 .01895 L
.38941 .01769 L
.39071 .01596 L
.39185 .01505 L
.3931 .01472 L
.39441 .01511 L
.39564 .01617 L
.39678 .01778 L
.39783 .01975 L
.40017 .02594 L
.40284 .03589 L
.40531 .04772 L
.4109 .08285 L
.42105 .16769 L
.43081 .25594 L
.43593 .29798 L
.44132 .336 L
.44606 .36304 L
.44857 .37477 L
.45125 .38532 L
.45372 .39334 L
.45596 .39928 L
.46034 .40771 L
.49811 .47949 L
.50823 .5228 L
.51376 .54482 L
.51646 .55384 L
.51893 .56061 L
.52001 .56306 L
.52119 .56534 L
.52232 .56711 L
.52333 .56834 L
.52452 .56933 L
.52579 .56981 L
.52696 .56972 L
.52807 .56915 L
.52929 .56795 L
.53058 .56603 L
.53169 .56385 L
.5329 .56088 L
.5356 .55204 L
.53811 .54109 L
.54312 .51181 L
Mistroke
.54785 .47581 L
.5567 .39253 L
.56617 .29556 L
.57155 .24437 L
.5766 .20257 L
.58166 .16847 L
.58629 .145 L
.58883 .13537 L
.59124 .1283 L
.59247 .12545 L
.59378 .12295 L
.59522 .12082 L
.59588 .12007 L
.59656 .1194 L
.59781 .11853 L
.59895 .11808 L
.60019 .11795 L
.60089 .11803 L
.60154 .11819 L
.60272 .1187 L
.6038 .11937 L
.60623 .1215 L
.61073 .12693 L
.615 .13257 L
.61959 .13783 L
.62084 .13898 L
.6222 .14004 L
.62347 .14086 L
.62465 .14146 L
.62589 .1419 L
.62655 .14206 L
.62725 .14217 L
.62799 .14222 L
.62869 .1422 L
.63 .14199 L
.63122 .14161 L
.63235 .14108 L
.63359 .14033 L
.6349 .13934 L
.63943 .13453 L
.64367 .12861 L
.64868 .12115 L
.65111 .11789 L
.65332 .11545 L
.65456 .11437 L
.65573 .11359 L
.65696 .11305 L
.65766 .11289 L
.65829 .11283 L
.65955 .113 L
Mistroke
.66027 .11328 L
.66093 .11366 L
.66164 .11419 L
.66228 .11481 L
.66372 .11663 L
.66498 .11876 L
.66615 .12119 L
.66879 .12841 L
.67112 .1368 L
.6736 .14785 L
.67814 .17389 L
.68241 .20468 L
.69213 .29322 L
.70108 .38536 L
.71064 .47514 L
.71613 .51555 L
.72112 .54257 L
.72352 .55202 L
.72479 .55603 L
.72613 .55955 L
.7273 .56203 L
.72859 .5641 L
.72976 .56541 L
.73086 .56614 L
.7321 .56642 L
.7328 .56632 L
.73345 .56606 L
.73465 .5652 L
.73592 .56376 L
.73705 .56202 L
.73811 .56004 L
.74054 .55432 L
.74553 .53832 L
.75093 .51709 L
.761 .47632 L
.76633 .45814 L
.76927 .44977 L
.77204 .44303 L
.77464 .43775 L
.77746 .43312 L
.77981 .43007 L
.7824 .42741 L
.78483 .42543 L
.78741 .42366 L
.79204 .42048 L
.79478 .41799 L
.79729 .4149 L
.80018 .41003 L
.80293 .40376 L
.80546 .39637 L
Mistroke
.80781 .38796 L
.81313 .36309 L
.81821 .3318 L
.8237 .29044 L
.83366 .20203 L
.84329 .1156 L
.84799 .0794 L
.85227 .05238 L
.85447 .04116 L
.85686 .03119 L
.85817 .02675 L
.85939 .02332 L
.86054 .02066 L
.86178 .01846 L
.86302 .01694 L
.86418 .01614 L
.86486 .01596 L
.86557 .01598 L
.86684 .01658 L
.86748 .01715 L
.86817 .01796 L
.86941 .01992 L
.87088 .02307 L
.87221 .0267 L
.87492 .0361 L
.87741 .04703 L
.88305 .07821 L
.89328 .14721 L
.90233 .20666 L
.90732 .23443 L
.91205 .25629 L
.91762 .27607 L
.92271 .28899 L
.92749 .29778 L
.93269 .30567 L
.93802 .31452 L
.94304 .32582 L
.94754 .33977 L
.95241 .35959 L
.96335 .42182 L
.9734 .49268 L
.97619 .5125 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[49]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol0025oo`03001o
ogoo0?aoo`008Goo00<007ooOol0o7oo000QOol2003mOol0025oo`03001oogoo0?aoo`008Goo00<0
07ooOol0G7oo0`00N7oo0P008goo000QOol00`00Oomoo`1KOol200000goo001oo`1fOol200000goo
001oo`0QOol0025oo`8005aoo`05001oogooOol0001fOol01000Oomoo`008Woo000QOol00`00Oomo
o`1KOol01@00Oomoogoo0000MWoo00@007ooOol0029oo`008Goo00<007ooOol0FWoo00<007ooOol0
0Woo00<007ooOol0Lgoo00<007ooOol00Woo00<007ooOol07goo000QOol00`00Oomoo`1JOol00`00
Oomoo`02Ool00`00Oomoo`1cOol00`00Oomoo`02Ool00`00Oomoo`0OOol0025oo`03001oogoo05Yo
o`03001oogoo009oo`03001oogoo07=oo`03001oogoo009oo`03001oogoo01moo`008Goo0P00Fgoo
00<007ooOol00goo00<007ooOol0LWoo00<007ooOol00goo00<007ooOol07Woo000QOol00`00Oomo
o`1JOol00`00Oomoo`03Ool00`00Oomoo`1aOol00`00Oomoo`04Ool00`00Oomoo`0NOol000aoo`03
001oogoo009oo`03001oogoo00D0009oo`03001oogoo00=oo`03001oogoo01Moo`80045oo`03001o
ogoo00=oo`03001oogoo075oo`03001oogoo00Aoo`03001oogoo01ioo`002goo00<007oo000027oo
00L007ooOomoo`00Ool00004Ool00`00Oomoo`0FOol01000Oomoo`00?goo00<007ooOol017oo00<0
07ooOol0LGoo00<007ooOol017oo00<007ooOol07Woo0006Ool30002Ool00`00Ool00008Ool00`00
Oomoo`03Ool00`00Oomoo`02Ool2000GOol00`00Oomoo`02000nOol00`00Oomoo`04Ool00`00Oomo
o`1aOol00`00Oomoo`04Ool00`00Oomoo`0NOol000]oo`03001oo`0000Qoo`04001oogooOol20005
Ool00`00Oomoo`0EOol00`00Oomoo`02Ool00`00Oomoo`0lOol00`00Oomoo`04Ool00`00Oomoo`1a
Ool00`00Oomoo`05Ool00`00Oomoo`0MOol000]oo`03001oo`0000Qoo`05001oogooOol00006Ool0
0`00Oomoo`0EOol00`00Oomoo`02Ool00`00Oomoo`0kOol00`00Oomoo`06Ool00`00Oomoo`1_Ool0
0`00Oomoo`06Ool00`00Oomoo`0MOol000aoo`03001oogoo00Ioo`8000=oo`<000Aoo`03001oogoo
01Eoo`03001oogoo00=oo`03001oogoo03Yoo`03001oogoo00Ioo`03001oogoo06moo`03001oogoo
00Ioo`03001oogoo01eoo`008Goo0P005Woo00<007ooOol00goo00<007ooOol0>Woo00<007ooOol0
1Woo00<007ooOol0Kgoo00<007ooOol01Woo00<007ooOol07Goo000QOol00`00Oomoo`0EOol00`00
Oomoo`03Ool00`00Oomoo`0jOol00`00Oomoo`06Ool00`00Oomoo`1_Ool00`00Oomoo`06Ool00`00
Oomoo`0MOol0025oo`03001oogoo01Aoo`03001oogoo00Aoo`03001oogoo03Yoo`03001oogoo00Io
o`03001oogoo06moo`03001oogoo00Ioo`03001oogoo01eoo`008Goo00<007ooOol057oo00<007oo
Ool017oo00<007ooOol0>Woo00<007ooOol01Woo00<007ooOol0Kgoo00<007ooOol01Woo00<007oo
Ool07Goo000QOol00`00Oomoo`0DOol00`00Oomoo`05Ool00`00Oomoo`0hOol00`00Oomoo`07Ool0
0`00Oomoo`1_Ool00`00Oomoo`07Ool00`00Oomoo`0LOol0025oo`8001Eoo`03001oogoo00Eoo`03
001oogoo03Qoo`03001oogoo00Moo`03001oogoo06moo`03001oogoo00Moo`03001oogoo01aoo`00
8Goo00<007ooOol057oo00<007ooOol01Goo00<007ooOol0>7oo00<007ooOol027oo00<007ooOol0
KGoo00<007ooOol027oo00<007ooOol077oo000QOol00`00Oomoo`0COol00`00Oomoo`06Ool00`00
Oomoo`0hOol00`00Oomoo`08Ool00`00Oomoo`1]Ool00`00Oomoo`08Ool00`00Oomoo`0LOol0025o
o`03001oogoo01=oo`03001oogoo00Moo`03001oogoo03Moo`03001oogoo00Qoo`03001oogoo06eo
o`03001oogoo00Qoo`03001oogoo01aoo`008Goo0P0057oo00<007ooOol01goo00<007ooOol0=goo
00<007ooOol027oo00<007ooOol0KGoo00<007ooOol027oo00<007ooOol077oo000QOol00`00Oomo
o`0COol00`00Oomoo`07Ool00`00Oomoo`0gOol00`00Oomoo`08Ool00`00Oomoo`0lOol3000^Ool0
0`00Oomoo`09Ool00`00Oomoo`0KOol0025oo`03001oogoo01=oo`03001oogoo00Qoo`03001oogoo
03Ioo`03001oogoo00Qoo`03001oogoo02eoo`8000aoo`04001oogoo000^Ool00`00Oomoo`09Ool0
0`00Oomoo`0KOol0025oo`03001oogoo01=oo`03001oogoo00Qoo`03001oogoo03Eoo`03001oogoo
00Uoo`03001oogoo02aoo`@000Yoo`04001oogooOol2000]Ool00`00Oomoo`09Ool00`00Oomoo`0K
Ool0025oo`8001Aoo`03001oogoo00Qoo`03001oogoo03Eoo`03001oogoo00Yoo`03001oogoo02]o
o`05001oogooOol00008Ool00`00Oomoo`03Ool00`00Oomoo`0[Ool00`00Oomoo`09Ool00`00Oomo
o`0KOol0025oo`03001oogoo01=oo`03001oogoo00Qoo`03001oogoo03Eoo`03001oogoo00Yoo`03
001oogoo02Yoo`03001oogoo009oo`03001oogoo00Ioo`03001oogoo00=oo`03001oogoo02]oo`03
001oogoo00Uoo`03001oogoo01]oo`008Goo00<007ooOol04Woo00<007ooOol02Woo00<007ooOol0
=7oo00<007ooOol02Woo00<007ooOol0:Woo00<007ooOol00goo00<007ooOol017oo00<007ooOol0
1Goo00<007ooOol0:Goo00<007ooOol02Woo00<007ooOol06goo000AOol00`00Oomoo`02Ool00`00
Oomoo`050003Ool00`00Oomoo`0BOol00`00Oomoo`0:Ool00`00Oomoo`0dOol00`00Oomoo`0:Ool0
0`00Oomoo`0ZOol00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`05Ool00`00Oomoo`0YOol0
0`00Oomoo`0;Ool00`00Oomoo`0JOol0011oo`03001oo`0000Qoo`03001oogoo00=oo`03001oogoo
019oo`03001oogoo00Yoo`03001oogoo03Aoo`03001oogoo00Yoo`03001oogoo02Uoo`03001oogoo
00Ioo`800003Ool0000000Qoo`03001oogoo02Uoo`03001oogoo00]oo`03001oogoo01Yoo`002goo
0`000Woo00<007oo000027oo00<007ooOol00goo0P004goo00<007ooOol02Woo00<007ooOol0<goo
00<007ooOol02goo00<007ooOol0:Goo00<007ooOol01goo0`002Woo00<007ooOol0:7oo00<007oo
Ool02goo00<007ooOol06Woo000@Ool00`00Ool00008Ool00`00Oomoo`03Ool00`00Oomoo`0BOol0
0`00Oomoo`0;Ool00`00Oomoo`0bOol00`00Oomoo`0;Ool00`00Oomoo`0YOol00`00Oomoo`0DOol0
0`00Oomoo`0XOol00`00Oomoo`0;Ool00`00Oomoo`0JOol0011oo`03001oo`0000Qoo`03001oogoo
00=oo`03001oogoo019oo`03001oogoo00]oo`03001oogoo039oo`03001oogoo00]oo`03001oogoo
02Uoo`03001oogoo01Aoo`03001oogoo02Qoo`03001oogoo00]oo`03001oogoo01Yoo`004Goo00<0
07ooOol01Woo0P001Goo00<007ooOol04Woo00<007ooOol02goo00<007ooOol0<Woo00<007ooOol0
37oo00<007ooOol09goo00<007ooOol05Goo00<007ooOol0:7oo00<007ooOol02goo00<007ooOol0
6Woo000QOol2000COol00`00Oomoo`0;Ool00`00Oomoo`0bOol00`00Oomoo`0<Ool00`00Oomoo`0W
Ool00`00Oomoo`0EOol00`00Oomoo`0WOol00`00Oomoo`0<Ool00`00Oomoo`0JOol0025oo`03001o
ogoo019oo`03001oogoo00aoo`03001oogoo035oo`03001oogoo00aoo`03001oogoo02Moo`03001o
ogoo01Ioo`03001oogoo02Ioo`03001oogoo00eoo`03001oogoo01Uoo`008Goo00<007ooOol04Goo
00<007ooOol03Goo00<007ooOol0<7oo00<007ooOol03Goo00<007ooOol09goo00<007ooOol05Woo
00<007ooOol09Woo00<007ooOol03Goo00<007ooOol06Goo000QOol00`00Oomoo`0AOol00`00Oomo
o`0=Ool00`00Oomoo`0`Ool00`00Oomoo`0=Ool00`00Oomoo`0WOol00`00Oomoo`0FOol00`00Oomo
o`0VOol00`00Oomoo`0=Ool00`00Oomoo`0IOol0025oo`80019oo`03001oogoo00eoo`03001oogoo
031oo`03001oogoo00eoo`03001oogoo02Moo`03001oogoo01Ioo`03001oogoo02Ioo`03001oogoo
00eoo`03001oogoo01Uoo`008Goo00<007ooOol04Goo00<007ooOol03Woo00<007ooOol0;goo00<0
07ooOol03Goo00<007ooOol09Woo00<007ooOol05goo00<007ooOol09Woo00<007ooOol03Goo00<0
07ooOol06Goo000QOol00`00Oomoo`0AOol00`00Oomoo`0>Ool00`00Oomoo`0_Ool00`00Oomoo`0>
Ool00`00Oomoo`0UOol00`00Oomoo`0GOol00`00Oomoo`0VOol00`00Oomoo`0=Ool00`00Oomoo`0I
Ool0025oo`03001oogoo015oo`03001oogoo00moo`03001oogoo02ioo`03001oogoo00ioo`03001o
ogoo02Eoo`03001oogoo01Moo`03001oogoo02Ioo`03001oogoo00eoo`03001oogoo01Uoo`008Goo
00<007ooOol04Goo00<007ooOol047oo00<007ooOol0;7oo00<007ooOol03goo00<007ooOol09Goo
00<007ooOol067oo00<007ooOol097oo00<007ooOol03Woo00<007ooOol06Goo000QOol2000BOol0
0`00Oomoo`0AOol00`00Oomoo`0[Ool00`00Oomoo`0?Ool00`00Oomoo`0TOol00`00Oomoo`0IOol0
0`00Oomoo`0TOol00`00Oomoo`0?Ool00`00Oomoo`0HOol0025oo`03001oogoo011oo`03001oogoo
01=oo`03001oogoo02Yoo`03001oogoo00moo`03001oogoo02Aoo`03001oogoo01Uoo`03001oogoo
02Aoo`03001oogoo00moo`03001oogoo01Qoo`008Goo00<007ooOol047oo00<007ooOol057oo00<0
07ooOol0:Goo00<007ooOol03goo00<007ooOol097oo00<007ooOol06Goo00<007ooOol097oo00<0
07ooOol03goo00<007ooOol067oo000QOol00`00Oomoo`0@Ool00`00Oomoo`0EOol00`00Oomoo`0X
Ool00`00Oomoo`0?Ool00`00Oomoo`0TOol00`00Oomoo`0IOol00`00Oomoo`0TOol00`00Oomoo`0?
Ool00`00Oomoo`0HOol0025oo`80015oo`03001oogoo01Ioo`03001oogoo02Moo`03001oogoo00mo
o`03001oogoo02Aoo`03001oogoo01Uoo`03001oogoo02Aoo`03001oogoo00moo`03001oogoo01Qo
o`008Goo00<007ooOol047oo00<007ooOol05Woo00<007ooOol09Woo00<007ooOol04Goo00<007oo
Ool08goo00<007ooOol06Goo00<007ooOol097oo00<007ooOol03goo00<007ooOol067oo000<Ool0
0`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`0@Ool0
0`00Oomoo`0GOol00`00Oomoo`0UOol00`00Oomoo`0AOol00`00Oomoo`0SOol00`00Oomoo`0IOol0
0`00Oomoo`0TOol00`00Oomoo`0?Ool00`00Oomoo`0HOol000]oo`03001oo`0000Moo`03001oo`00
009oo`03001oo`0000Aoo`03001oogoo011oo`03001oogoo01Moo`03001oogoo02Eoo`03001oogoo
015oo`03001oogoo02=oo`03001oogoo01Uoo`03001oogoo02Aoo`03001oogoo011oo`03001oogoo
01Moo`001Woo0`000Woo00<007oo00001goo00<007oo000017oo00<007ooOol00Woo0P004Goo00<0
07ooOol067oo00<007ooOol097oo00<007ooOol04Goo00<007ooOol08Woo00<007ooOol06Woo00<0
07ooOol08goo00<007ooOol04Goo00<007ooOol05goo000;Ool00`00Ool00007Ool00`00Ool00002
Ool20005Ool00`00Oomoo`0@Ool00`00Oomoo`0HOol00`00Oomoo`0TOol00`00Oomoo`0AOol00`00
Oomoo`0ROol00`00Oomoo`0KOol00`00Oomoo`0ROol00`00Oomoo`0AOol00`00Oomoo`0GOol000]o
o`03001oo`0000Moo`03001oo`00009oo`03001oogoo00Aoo`03001oogoo00moo`03001oogoo01Uo
o`03001oogoo02Aoo`03001oogoo015oo`03001oogoo029oo`03001oogoo01]oo`03001oogoo029o
o`03001oogoo015oo`03001oogoo01Moo`0037oo00<007ooOol01goo00@007ooOomoo`<000Aoo`03
001oogoo00moo`03001oogoo01Uoo`03001oogoo02=oo`03001oogoo019oo`03001oogoo029oo`03
001oogoo01]oo`03001oogoo029oo`03001oogoo015oo`03001oogoo01Moo`008Goo00<007ooOol0
3goo00<007ooOol06Goo00<007ooOol08goo00<007ooOol04Woo00<007ooOol08Woo00<007ooOol0
6goo00<007ooOol08Woo00<007ooOol04Goo00<007ooOol05goo000QOol2000@Ool00`00Oomoo`0J
Ool00`00Oomoo`0ROol00`00Oomoo`0COol00`00Oomoo`0QOol00`00Oomoo`0KOol00`00Oomoo`0R
Ool00`00Oomoo`0BOol00`00Oomoo`0FOol0025oo`03001oogoo00moo`03001oogoo01Yoo`03001o
ogoo029oo`03001oogoo01=oo`03001oogoo025oo`03001oogoo01]oo`03001oogoo029oo`03001o
ogoo019oo`03001oogoo01Ioo`008Goo00<007ooOol03goo00<007ooOol06Woo00<007ooOol08Woo
00<007ooOol04goo00<007ooOol08Goo00<007ooOol06goo00<007ooOol08Woo00<007ooOol04goo
00<007ooOol05Goo000QOol00`00Oomoo`0?Ool00`00Oomoo`0JOol00`00Oomoo`0ROol00`00Oomo
o`0COol00`00Oomoo`0QOol00`00Oomoo`0KOol00`00Oomoo`0ROol00`00Oomoo`0COol00`00Oomo
o`0EOol0025oo`80011oo`03001oogoo01Yoo`03001oogoo025oo`03001oogoo01Aoo`03001oogoo
025oo`03001oogoo01]oo`03001oogoo029oo`03001oogoo01=oo`03001oogoo01Eoo`008Goo00<0
07ooOol03goo00<007ooOol06Woo00<007ooOol08Goo00<007ooOol057oo00<007ooOol08Goo00<0
07ooOol06goo00<007ooOol08Woo00<007ooOol04goo00<007ooOol05Goo000QOol00`00Oomoo`0>
Ool00`00Oomoo`0LOol00`00Oomoo`06Ool50002Ool00`00Oomoo`0@Ool00`00Oomoo`0DOol00`00
Oomoo`0;Ool30003Ool00`00Oomoo`0=Ool00`00Oomoo`0KOol00`00Oomoo`06Ool20004Ool00`00
Oomoo`0COol00`00Oomoo`0DOol00`00Oomoo`09Ool30002Ool00`00Oomoo`03Ool0025oo`03001o
ogoo00ioo`03001oogoo01aoo`03001oogoo00Qoo`07001oogooOol007oo00004Goo00<007ooOol0
57oo00<007ooOol02goo00<007ooOol00Woo00<007oo00003Goo00<007ooOol077oo00<007ooOol0
27oo00H007ooOol007oo000COol00`00Oomoo`0EOol00`00Oomoo`0:Ool01P00Oomoo`00Ool000Ao
o`008Goo0P003goo00<007ooOol077oo00<007ooOol027oo00L007ooOomoo`00Ool0000AOol00`00
Oomoo`0DOol00`00Oomoo`0<Ool01`00Oomoogoo001oo`0000eoo`03001oogoo01eoo`03001oogoo
00Ioo`07001oogooOol007oo00004goo00<007ooOol05Goo00<007ooOol027oo100000Aoo`00Ool0
00Aoo`008Goo00<007ooOol03Woo00<007ooOol077oo00<007ooOol027oo00L007ooOomoo`00Ool0
000@Ool00`00Oomoo`0FOol00`00Oomoo`0;Ool01`00Oomoogoo001oo`0000eoo`03001oogoo01eo
o`03001oogoo00Moo`06001oogoo001oo`004goo00<007ooOol05Goo00<007ooOol027oo00<007oo
00000Woo00<007oo000017oo000QOol00`00Oomoo`0>Ool00`00Oomoo`0LOol00`00Oomoo`08Ool0
1`00Oomoogoo001oo`00011oo`03001oogoo01Ioo`03001oogoo00Yoo`03001oo`00009oo`03001o
o`0000eoo`03001oogoo01eoo`03001oogoo00Eoo`03001oo`00009oo`03001oo`0001=oo`03001o
ogoo01Ioo`03001oogoo00Qoo`80009oo`03001oo`0000Aoo`008Goo00<007ooOol03Woo00<007oo
Ool077oo00<007ooOol01goo0P0017oo00<007ooOol03goo00<007ooOol05Woo00<007ooOol02goo
00<007ooOol00Woo00<007ooOol037oo00<007ooOol07Goo00<007ooOol01Woo00<007ooOol00Woo
00<007ooOol04Woo00<007ooOol05Woo00<007ooOol02Goo00D007ooOomoo`0000Eoo`008Goo00<0
07ooOol03Woo00<007ooOol07Goo00<007ooOol07Woo00<007ooOol05Woo00<007ooOol07goo00<0
07ooOol07Goo00<007ooOol087oo00<007ooOol05Woo00<007ooOol04goo000QOol2000?Ool00`00
Oomoo`0MOol00`00Oomoo`0MOol00`00Oomoo`0GOol00`00Oomoo`0OOol00`00Oomoo`0MOol00`00
Oomoo`0POol00`00Oomoo`0GOol00`00Oomoo`0BOol0025oo`03001oogoo00ioo`03001oogoo01eo
o`03001oogoo01eoo`03001oogoo01Moo`03001oogoo01moo`03001oogoo01eoo`03001oogoo021o
o`03001oogoo01Qoo`03001oogoo015oo`008Goo00<007ooOol03Woo00<007ooOol07Goo00<007oo
Ool077oo00<007ooOol067oo00<007ooOol07goo00<007ooOol07Goo00<007ooOol07goo00<007oo
Ool06Woo00<007ooOol047oo000QOol00`00Oomoo`0=Ool00`00Oomoo`0NOol00`00Oomoo`0KOol0
0`00Oomoo`0IOol00`00Oomoo`0OOol00`00Oomoo`0MOol00`00Oomoo`0OOol00`00Oomoo`0JOol0
0`00Oomoo`0@Ool001]oool000H000008Goo00<007ooOol02Goo00D007ooOomoo`0000Qoo`03001o
ogoo00Uoo`03001oogoo00Uoo`8000]oo`03001oogoo00Uoo`05001oogooOol00007Ool00`00Oomo
o`0:Ool00`00Oomoo`05Ool01@00Oomoogoo000037oo00<007ooOol02Goo00<007ooOol00Woo00<0
07ooOol017oo00<007ooOol02Woo00<007ooOol02Goo0P002Woo00<007ooOol02Woo00<007ooOol0
1Woo00@007ooOol000aoo`03001oogoo00Uoo`03001oo`0000Uoo`03001oogoo00Eoo`008Goo00<0
07ooOol03Goo00<007ooOol07goo00<007ooOol02Goo00<007ooOol037oo00<007ooOol077oo00<0
07ooOol03Goo00<007ooOol03Goo00<007ooOol07goo00<007ooOol027oo00<007ooOol04goo00<0
07ooOol077oo00<007ooOol01Woo00<007ooOol01Goo000QOol00`00Oomoo`0=Ool00`00Oomoo`0O
Ool00`00Oomoo`0HOol00`00Oomoo`0LOol00`00Oomoo`0MOol00`00Oomoo`0OOol00`00Oomoo`0N
Ool00`00Oomoo`0LOol00`00Oomoo`0>Ool0025oo`8000ioo`03001oogoo01moo`03001oogoo01Qo
o`03001oogoo01aoo`03001oogoo01eoo`03001oogoo01moo`03001oogoo01eoo`03001oogoo01io
o`03001oogoo00eoo`008Goo00<007ooOol03Goo00<007ooOol07goo00<007ooOol05goo00<007oo
Ool07Goo00<007ooOol07Goo00<007ooOol07goo00<007ooOol07Goo00<007ooOol07Woo00<007oo
Ool03Goo000QOol00`00Oomoo`0=Ool00`00Oomoo`0OOol00`00Oomoo`0GOol00`00Oomoo`0MOol0
0`00Oomoo`0MOol00`00Oomoo`0OOol00`00Oomoo`0MOol00`00Oomoo`0OOol00`00Oomoo`0<Ool0
025oo`03001oogoo00eoo`03001oogoo021oo`03001oogoo01Eoo`03001oogoo01ioo`03001oogoo
01eoo`03001oogoo01moo`03001oogoo01eoo`03001oogoo01moo`03001oogoo00aoo`008Goo00<0
07ooOol03Goo00<007ooOol087oo00<007ooOol05Goo00<007ooOol07Woo00<007ooOol07Goo00<0
07ooOol087oo00<007ooOol077oo00<007ooOol07goo00<007ooOol037oo000QOol2000=Ool00`00
Oomoo`0QOol00`00Oomoo`0DOol00`00Oomoo`0POol00`00Oomoo`0LOol00`00Oomoo`0POol00`00
Oomoo`0LOol00`00Oomoo`0OOol00`00Oomoo`0<Ool0025oo`03001oogoo00aoo`03001oogoo025o
o`03001oogoo01Aoo`03001oogoo021oo`03001oogoo01]oo`03001oogoo025oo`03001oogoo01]o
o`03001oogoo021oo`03001oogoo00aoo`008Goo00<007ooOol037oo00<007ooOol08Goo00<007oo
Ool057oo00<007ooOol087oo00<007ooOol06goo00<007ooOol08Goo00<007ooOol06goo00<007oo
Ool08Goo00<007ooOol02goo000QOol00`00Oomoo`0<Ool00`00Oomoo`0QOol00`00Oomoo`0DOol0
0`00Oomoo`0POol00`00Oomoo`0KOol00`00Oomoo`0QOol00`00Oomoo`0KOol00`00Oomoo`0QOol0
0`00Oomoo`0;Ool0025oo`8000eoo`03001oogoo025oo`03001oogoo01=oo`03001oogoo029oo`03
001oogoo01Yoo`03001oogoo025oo`03001oogoo01]oo`03001oogoo025oo`03001oogoo00]oo`00
8Goo00<007ooOol037oo00<007ooOol08Goo00<007ooOol04goo00<007ooOol08Woo00<007ooOol0
6Woo00<007ooOol08Goo00<007ooOol06goo00<007ooOol08Goo00<007ooOol02goo000QOol00`00
Oomoo`0<Ool00`00Oomoo`0ROol00`00Oomoo`0BOol00`00Oomoo`0ROol00`00Oomoo`0JOol00`00
Oomoo`0QOol00`00Oomoo`0KOol00`00Oomoo`0QOol00`00Oomoo`0;Ool0025oo`03001oogoo00ao
o`03001oogoo029oo`03001oogoo019oo`03001oogoo029oo`03001oogoo01Yoo`03001oogoo029o
o`03001oogoo01Yoo`03001oogoo029oo`03001oogoo00Yoo`008Goo0P003Goo00<007ooOol08Woo
00<007ooOol04Woo00<007ooOol08Woo00<007ooOol06Woo00<007ooOol08Woo00<007ooOol06Woo
00<007ooOol08Woo00<007ooOol02Woo000QOol00`00Oomoo`0<Ool00`00Oomoo`0ROol00`00Oomo
o`0AOol00`00Oomoo`0SOol00`00Oomoo`0IOol00`00Oomoo`0SOol00`00Oomoo`0IOol00`00Oomo
o`0SOol00`00Oomoo`0:Ool0025oo`03001oogoo00aoo`03001oogoo029oo`03001oogoo015oo`03
001oogoo02Aoo`03001oogoo01Qoo`03001oogoo02=oo`03001oogoo01Uoo`03001oogoo02=oo`03
001oogoo00Yoo`0037oo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol00Woo00<007ooOol0
0goo00<007ooOol02goo00<007ooOol08goo00<007ooOol04Goo00<007ooOol097oo00<007ooOol0
67oo00<007ooOol08goo00<007ooOol06Goo00<007ooOol08goo00<007ooOol02Woo000;Ool00`00
Ool00007Ool00`00Ool00002Ool00`00Ool00004Ool00`00Oomoo`0;Ool00`00Oomoo`0SOol00`00
Oomoo`0AOol00`00Oomoo`0UOol00`00Oomoo`0GOol00`00Oomoo`0SOol00`00Oomoo`0IOol00`00
Oomoo`0TOol00`00Oomoo`09Ool000]oo`03001oo`0000Moo`03001oo`0000Aoo`03001oogoo009o
o`8000aoo`03001oogoo02=oo`03001oogoo015oo`03001oogoo02Eoo`03001oogoo01Moo`03001o
ogoo02=oo`03001oogoo01Qoo`03001oogoo02Eoo`03001oogoo00Uoo`002goo00<007oo00001goo
00<007oo00000Woo0P001Goo00<007ooOol02goo00<007ooOol097oo00<007ooOol047oo00<007oo
Ool09Goo00<007ooOol05goo00<007ooOol08goo00<007ooOol067oo00<007ooOol09Goo00<007oo
Ool02Goo000;Ool00`00Ool00007Ool00`00Ool00002Ool00`00Oomoo`04Ool00`00Oomoo`0;Ool0
0`00Oomoo`0TOol00`00Oomoo`0?Ool00`00Oomoo`0VOol00`00Oomoo`0GOol00`00Oomoo`0SOol0
0`00Oomoo`0GOol00`00Oomoo`0VOol00`00Oomoo`09Ool000aoo`03001oogoo00Moo`04001oogoo
Ool30004Ool00`00Oomoo`0;Ool00`00Oomoo`0TOol00`00Oomoo`0?Ool00`00Oomoo`0WOol00`00
Oomoo`0FOol00`00Oomoo`0SOol00`00Oomoo`0GOol00`00Oomoo`0VOol00`00Oomoo`09Ool0025o
o`8000aoo`03001oogoo02Aoo`03001oogoo00moo`03001oogoo02Moo`03001oogoo01Ioo`03001o
ogoo02Aoo`03001oogoo01Ioo`03001oogoo02Ioo`03001oogoo00Uoo`008Goo00<007ooOol02goo
00<007ooOol097oo00<007ooOol03goo00<007ooOol0:7oo00<007ooOol05Goo00<007ooOol097oo
00<007ooOol05Goo00<007ooOol0:7oo00<007ooOol027oo000QOol00`00Oomoo`0:Ool00`00Oomo
o`0UOol00`00Oomoo`0?Ool00`00Oomoo`0XOol00`00Oomoo`0DOol00`00Oomoo`0UOol00`00Oomo
o`0DOol2000ZOol00`00Oomoo`08Ool0025oo`03001oogoo00Yoo`03001oogoo02Eoo`03001oogoo
00moo`03001oogoo02Uoo`03001oogoo01=oo`03001oogoo02Eoo`03001oogoo01=oo`03001oogoo
02Yoo`03001oogoo00Qoo`008Goo00<007ooOol02Woo00<007ooOol09Goo00<007ooOol03Woo00<0
07ooOol0:Woo00<007ooOol04goo00<007ooOol09Goo00<007ooOol04Woo00<007ooOol0:goo00<0
07ooOol027oo000QOol2000;Ool00`00Oomoo`0UOol00`00Oomoo`0>Ool00`00Oomoo`0[Ool00`00
Oomoo`0BOol00`00Oomoo`0UOol00`00Oomoo`0@Ool2000^Ool00`00Oomoo`08Ool0025oo`03001o
ogoo00Yoo`03001oogoo02Ioo`03001oogoo00eoo`03001oogoo02]oo`03001oogoo019oo`03001o
ogoo02Eoo`03001oogoo011oo`03001oogoo02eoo`03001oogoo00Qoo`008Goo00<007ooOol02Woo
00<007ooOol09Woo00<007ooOol03Goo00<007ooOol0;7oo00<007ooOol04Goo00<007ooOol09Goo
00<007ooOol03goo00<007ooOol0;goo00<007ooOol01goo000QOol00`00Oomoo`09Ool00`00Oomo
o`0WOol00`00Oomoo`0=Ool00`00Oomoo`0/Ool00`00Oomoo`0AOol00`00Oomoo`0UOol00`00Oomo
o`0>Ool00`00Oomoo`0`Ool00`00Oomoo`07Ool0025oo`8000Yoo`03001oogoo02Moo`03001oogoo
00eoo`03001oogoo02eoo`03001oogoo011oo`03001oogoo02Eoo`03001oogoo00ioo`03001oogoo
031oo`03001oogoo00Moo`008Goo00<007ooOol02Goo00<007ooOol09goo00<007ooOol037oo00<0
07ooOol0;goo00<007ooOol03goo00<007ooOol09Goo00<007ooOol03Woo00<007ooOol0<7oo00<0
07ooOol01goo000QOol00`00Oomoo`09Ool00`00Oomoo`0WOol00`00Oomoo`0<Ool00`00Oomoo`0_
Ool00`00Oomoo`0?Ool00`00Oomoo`0UOol00`00Oomoo`0>Ool00`00Oomoo`0`Ool00`00Oomoo`07
Ool0025oo`03001oogoo00Uoo`03001oogoo02Moo`03001oogoo00aoo`03001oogoo031oo`03001o
ogoo00eoo`03001oogoo02Moo`03001oogoo00aoo`03001oogoo035oo`03001oogoo00Moo`008Goo
0P002Goo00<007ooOol0:7oo00<007ooOol037oo00<007ooOol0<7oo00<007ooOol03Goo00<007oo
Ool09goo00<007ooOol037oo00<007ooOol0<Woo00<007ooOol01Woo000QOol00`00Oomoo`08Ool0
0`00Oomoo`0XOol00`00Oomoo`0<Ool00`00Oomoo`0aOol00`00Oomoo`0<Ool00`00Oomoo`0WOol0
0`00Oomoo`0<Ool00`00Oomoo`0bOol00`00Oomoo`06Ool0025oo`03001oogoo00Qoo`03001oogoo
02Uoo`03001oogoo00]oo`03001oogoo035oo`03001oogoo00aoo`03001oogoo02Moo`03001oogoo
00]oo`03001oogoo03=oo`03001oogoo00Ioo`004Goo00<007ooOol00Woo00<007ooOol01@000goo
00<007ooOol027oo00<007ooOol0:Goo00<007ooOol02Woo00<007ooOol0<goo00<007ooOol02goo
00<007ooOol09goo00<007ooOol02goo00<007ooOol0<goo00<007ooOol01Woo000@Ool00`00Ool0
0008Ool00`00Oomoo`03Ool00`00Oomoo`08Ool00`00Oomoo`0YOol00`00Oomoo`0:Ool00`00Oomo
o`0cOol00`00Oomoo`0;Ool00`00Oomoo`0WOol00`00Oomoo`0:Ool00`00Oomoo`0dOol00`00Oomo
o`06Ool0011oo`03001oo`0000Qoo`03001oogoo00=oo`8000Qoo`03001oogoo02Yoo`03001oogoo
00Yoo`03001oogoo03Aoo`03001oogoo00Yoo`03001oogoo02Moo`03001oogoo00Yoo`03001oogoo
03Aoo`03001oogoo00Ioo`0047oo00<007oo000027oo00<007ooOol00goo00<007oo00001goo00<0
07ooOol0:Woo00<007ooOol02Woo00<007ooOol0=7oo00<007ooOol02Woo00<007ooOol09goo00<0
07ooOol02Woo00<007ooOol0=Goo00<007ooOol01Goo000@Ool00`00Ool00008Ool00`00Oomoo`03
Ool01000Oomoo`001Woo00<007ooOol0:Woo00<007ooOol02Woo00<007ooOol0=Goo00<007ooOol0
2Goo00<007ooOol0:7oo00<007ooOol02Goo00<007ooOol0=Goo00<007ooOol01Goo000AOol00`00
Oomoo`06Ool20005Ool01@00Oomoogoo00001Goo00<007ooOol0:Woo00<007ooOol02Woo00<007oo
Ool0=Goo00<007ooOol02Goo00<007ooOol0:7oo00<007ooOol027oo00<007ooOol0=Woo00<007oo
Ool01Goo000QOol20003Ool01@00Oomoogoo0000;Goo00<007ooOol02Goo00<007ooOol0=Woo00<0
07ooOol027oo00<007ooOol0:Goo00<007ooOol027oo00<007ooOol0=Woo00<007ooOol01Goo000Q
Ool00`00Oomoo`02Ool01@00Oomoogoo0000;Woo00<007ooOol027oo00<007ooOol0=Woo00<007oo
Ool027oo00<007ooOol0:Goo00<007ooOol027oo00<007ooOol0=Woo00<007ooOol01Goo000QOol0
0`00Oomoo`03Ool4000^Ool00`00Oomoo`08Ool00`00Oomoo`0gOol00`00Oomoo`07Ool00`00Oomo
o`0YOol00`00Oomoo`08Ool00`00Oomoo`0fOol00`00Oomoo`05Ool0025oo`03001oogoo00Aoo`03
001oogoo02ioo`03001oogoo00Qoo`03001oogoo03Moo`03001oogoo00Moo`03001oogoo02Uoo`03
001oogoo00Qoo`03001oogoo03Ioo`03001oogoo00Eoo`008Goo0P00=Woo00<007ooOol027oo00<0
07ooOol0=goo00<007ooOol01goo00<007ooOol0:Woo00<007ooOol01Woo00<007ooOol0=goo00<0
07ooOol01Goo000QOol00`00Oomoo`0eOol00`00Oomoo`08Ool00`00Oomoo`0gOol00`00Oomoo`07
Ool00`00Oomoo`0ZOol00`00Oomoo`06Ool00`00Oomoo`0gOol00`00Oomoo`05Ool0025oo`03001o
ogoo03Eoo`03001oogoo00Moo`03001oogoo03Uoo`03001oogoo00Ioo`03001oogoo02Yoo`03001o
ogoo00Ioo`03001oogoo03moo`008Goo00<007ooOol0=Goo00<007ooOol01goo00<007ooOol0>Goo
00<007ooOol01Goo00<007ooOol0:goo00<007ooOol01Woo00<007ooOol0?goo000QOol00`00Oomo
o`0eOol00`00Oomoo`07Ool00`00Oomoo`0iOol00`00Oomoo`05Ool00`00Oomoo`0[Ool00`00Oomo
o`05Ool00`00Oomoo`10Ool0025oo`8003Ioo`03001oogoo00Moo`03001oogoo03Uoo`03001oogoo
00Eoo`03001oogoo02]oo`03001oogoo00Eoo`03001oogoo041oo`008Goo00<007ooOol0=Woo00<0
07ooOol01Woo00<007ooOol0>Goo00<007ooOol01Goo00<007ooOol0;7oo00<007ooOol017oo00<0
07ooOol0@7oo000QOol00`00Oomoo`0fOol00`00Oomoo`06Ool00`00Oomoo`0jOol00`00Oomoo`03
Ool00`00Oomoo`0]Ool00`00Oomoo`03Ool00`00Oomoo`11Ool0025oo`03001oogoo03Ioo`03001o
ogoo00Ioo`03001oogoo03Yoo`03001oogoo00=oo`03001oogoo02eoo`03001oogoo00=oo`03001o
ogoo045oo`008Goo0P00=goo00<007ooOol01Goo00<007ooOol0>goo00<007ooOol00goo00<007oo
Ool0;Goo00<007ooOol00goo00<007ooOol0@Goo000QOol00`00Oomoo`0fOol00`00Oomoo`05Ool0
0`00Oomoo`0kOol00`00Oomoo`03Ool00`00Oomoo`0^Ool01@00Oomoogoo0000A7oo000<Ool00`00
Oomoo`02Ool00`00Oomoo`050002Ool00`00Oomoo`03Ool00`00Oomoo`0fOol00`00Oomoo`05Ool0
0`00Oomoo`0lOol00`00Oomoo`02Ool00`00Oomoo`0^Ool01@00Oomoogoo0000A7oo000;Ool00`00
Ool00008Ool01`00Oomoogoo001oo`0000Aoo`03001oogoo03Ioo`03001oogoo00Eoo`03001oogoo
03aoo`05001oogooOol0000aOol01@00Oomoogoo0000A7oo000;Ool00`00Ool00008Ool00`00Oomo
o`03Ool00`00Oomoo`02Ool2000hOol00`00Oomoo`04Ool00`00Oomoo`0lOol01@00Oomoogoo0000
<Goo00@007ooOol004Eoo`002goo00<007oo000027oo00@007ooOomoo`8000Eoo`03001oogoo03Mo
o`03001oogoo00Aoo`03001oogoo03eoo`04001oogoo000bOol00`00Ool00015Ool000]oo`03001o
o`0000Qoo`05001oogooOol00006Ool00`00Oomoo`0gOol00`00Oomoo`04Ool00`00Oomoo`0mOol3
000cOol30015Ool000aoo`03001oogoo00Ioo`8000=oo`<000Aoo`03001oogoo03Moo`03001oogoo
00Aoo`03001oogoo03ioo`8007]oo`008Goo00<007ooOol0=goo00<007ooOol00goo00<007ooOol0
_7oo000QOol2000hOol00`00Oomoo`03Ool00`00Oomoo`2lOol0025oo`03001oogoo03Moo`03001o
ogoo00=oo`03001oogoo0;aoo`008Goo00<007ooOol0>7oo00<007ooOol00Woo00<007ooOol0_7oo
000QOol00`00Oomoo`0hOol01@00Oomoogoo0000_goo000QOol2000iOol01@00Oomoogoo0000_goo
000QOol00`00Oomoo`0iOol00`00Ool00030Ool0025oo`03001oogoo03Uoo`<00<1oo`008Goo00<0
07ooOol0>Woo00<007ooOol0_goo000QOol2003mOol0025oo`03001oogoo0?aoo`008Goo00<007oo
Ool0o7oo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQ
Ool00?moob5oo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-5.37251, -0.203767, \
0.161578, 0.00230113}},
  CellTags->{"Simulation", "i:2"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[49]=",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot[Evaluate[a2x[t]/.sols],{t,0,40}]", "Input",
  CellLabel->"In[50]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Simulation", "i:2"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0238095 0.308908 1.47205 [
[.2619 .29641 -6 -9 ]
[.2619 .29641 6 0 ]
[.5 .29641 -6 -9 ]
[.5 .29641 6 0 ]
[.7381 .29641 -6 -9 ]
[.7381 .29641 6 0 ]
[.97619 .29641 -6 -9 ]
[.97619 .29641 6 0 ]
[.01131 .0145 -24 -4.5 ]
[.01131 .0145 0 4.5 ]
[.01131 .1617 -24 -4.5 ]
[.01131 .1617 0 4.5 ]
[.01131 .45611 -18 -4.5 ]
[.01131 .45611 0 4.5 ]
[.01131 .60332 -18 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.2619 .30891 m
.2619 .31516 L
s
[(10)] .2619 .29641 0 1 Mshowa
.5 .30891 m
.5 .31516 L
s
[(20)] .5 .29641 0 1 Mshowa
.7381 .30891 m
.7381 .31516 L
s
[(30)] .7381 .29641 0 1 Mshowa
.97619 .30891 m
.97619 .31516 L
s
[(40)] .97619 .29641 0 1 Mshowa
.125 Mabswid
.07143 .30891 m
.07143 .31266 L
s
.11905 .30891 m
.11905 .31266 L
s
.16667 .30891 m
.16667 .31266 L
s
.21429 .30891 m
.21429 .31266 L
s
.30952 .30891 m
.30952 .31266 L
s
.35714 .30891 m
.35714 .31266 L
s
.40476 .30891 m
.40476 .31266 L
s
.45238 .30891 m
.45238 .31266 L
s
.54762 .30891 m
.54762 .31266 L
s
.59524 .30891 m
.59524 .31266 L
s
.64286 .30891 m
.64286 .31266 L
s
.69048 .30891 m
.69048 .31266 L
s
.78571 .30891 m
.78571 .31266 L
s
.83333 .30891 m
.83333 .31266 L
s
.88095 .30891 m
.88095 .31266 L
s
.92857 .30891 m
.92857 .31266 L
s
.25 Mabswid
0 .30891 m
1 .30891 L
s
.02381 .0145 m
.03006 .0145 L
s
[(-0.2)] .01131 .0145 1 0 Mshowa
.02381 .1617 m
.03006 .1617 L
s
[(-0.1)] .01131 .1617 1 0 Mshowa
.02381 .45611 m
.03006 .45611 L
s
[(0.1)] .01131 .45611 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(0.2)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04394 m
.02756 .04394 L
s
.02381 .07338 m
.02756 .07338 L
s
.02381 .10282 m
.02756 .10282 L
s
.02381 .13226 m
.02756 .13226 L
s
.02381 .19114 m
.02756 .19114 L
s
.02381 .22058 m
.02756 .22058 L
s
.02381 .25003 m
.02756 .25003 L
s
.02381 .27947 m
.02756 .27947 L
s
.02381 .33835 m
.02756 .33835 L
s
.02381 .36779 m
.02756 .36779 L
s
.02381 .39723 m
.02756 .39723 L
s
.02381 .42667 m
.02756 .42667 L
s
.02381 .48555 m
.02756 .48555 L
s
.02381 .515 m
.02756 .515 L
s
.02381 .54444 m
.02756 .54444 L
s
.02381 .57388 m
.02756 .57388 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .60256 L
.02605 .60055 L
.02729 .59668 L
.02846 .59151 L
.03053 .57879 L
.03279 .56006 L
.0379 .5006 L
.04262 .42935 L
.05285 .25533 L
.05786 .17994 L
.06244 .1266 L
.06485 .10627 L
.06595 .09888 L
.06713 .09241 L
.06838 .08718 L
.06955 .08384 L
.07026 .08252 L
.07093 .08179 L
.07218 .08175 L
.07348 .08353 L
.07414 .08512 L
.07486 .0874 L
.07614 .09279 L
.07733 .09934 L
.08002 .11924 L
.0829 .1478 L
.09328 .29239 L
.09876 .37559 L
.10176 .41705 L
.10458 .45114 L
.10732 .47849 L
.10982 .49774 L
.11118 .50562 L
.11261 .51188 L
.11335 .5143 L
.11404 .51603 L
.1148 .51733 L
.11561 .51804 L
.11693 .51768 L
.11768 .51664 L
.11836 .51516 L
.11962 .51111 L
.12026 .50842 L
.12096 .50498 L
.12347 .48848 L
.12582 .46748 L
.13089 .4062 L
.13552 .33599 L
.14594 .16538 L
Mistroke
.15072 .09926 L
.15334 .07003 L
.15581 .04809 L
.15812 .03295 L
.15942 .02686 L
.16062 .02285 L
.16162 .02068 L
.16273 .01958 L
.16389 .01988 L
.16496 .02149 L
.16626 .02511 L
.16698 .02797 L
.16766 .03112 L
.17021 .04742 L
.17252 .06801 L
.17498 .09542 L
.1857 .26352 L
.1951 .42513 L
.19767 .46266 L
.20038 .49664 L
.20272 .52072 L
.204 .53166 L
.20521 .54041 L
.20635 .54723 L
.20759 .55301 L
.20871 .55681 L
.20974 .55906 L
.21072 .56009 L
.21179 .56 L
.21291 .55854 L
.21395 .55594 L
.21519 .55133 L
.21636 .54546 L
.21856 .53068 L
.22093 .50961 L
.2235 .48124 L
.23282 .34692 L
.23771 .27046 L
.24287 .19833 L
.24561 .16663 L
.24862 .13901 L
.24994 .12949 L
.25135 .12122 L
.25203 .11794 L
.25268 .11528 L
.25389 .11149 L
.25515 .1092 L
.25578 .10869 L
.25648 .10862 L
.25771 .10978 L
Mistroke
.25886 .11234 L
.25956 .11457 L
.26022 .11716 L
.26146 .12326 L
.26425 .14264 L
.26673 .16593 L
.26897 .19148 L
.27399 .26101 L
.28302 .40546 L
.28808 .48014 L
.29075 .51345 L
.29356 .54254 L
.29603 .5621 L
.29743 .57051 L
.29873 .57651 L
.29993 .58042 L
.30103 .58259 L
.30229 .58345 L
.30349 .58262 L
.30463 .58033 L
.30586 .57624 L
.30702 .57084 L
.30808 .5646 L
.31055 .54546 L
.31315 .5187 L
.31805 .45222 L
.32341 .36238 L
.33289 .19448 L
.33755 .12486 L
.34184 .07603 L
.34424 .05654 L
.34545 .04901 L
.34677 .04258 L
.34747 .03998 L
.34811 .03809 L
.34884 .03646 L
.34954 .03548 L
.35078 .03507 L
.35147 .0356 L
.35212 .03657 L
.35335 .03968 L
.3545 .04409 L
.35553 .04925 L
.35665 .05607 L
.35916 .07593 L
.36146 .09927 L
.37166 .24432 L
.37729 .33508 L
.38242 .4097 L
.38476 .43863 L
Mistroke
.38731 .46516 L
.38971 .48489 L
.39193 .49809 L
.39315 .50317 L
.39428 .50653 L
.39553 .50862 L
.39623 .50906 L
.39687 .509 L
.39816 .50755 L
.39888 .50595 L
.39956 .50397 L
.40079 .49909 L
.40211 .49215 L
.40449 .47527 L
.40707 .45111 L
.41173 .39412 L
.42046 .26123 L
.42505 .1913 L
.42996 .12695 L
.43278 .0979 L
.43536 .07764 L
.43659 .0702 L
.43725 .06692 L
.43794 .06393 L
.43921 .05978 L
.44039 .05752 L
.44169 .0568 L
.44288 .0578 L
.44418 .0607 L
.44484 .06288 L
.44555 .06581 L
.44677 .07205 L
.44807 .08048 L
.4504 .10009 L
.45338 .13277 L
.45619 .1706 L
.46145 .25504 L
.47117 .42573 L
.47648 .50596 L
.47908 .53767 L
.48146 .56131 L
.48363 .57802 L
.48463 .58406 L
.48569 .58931 L
.48682 .59354 L
.48787 .5962 L
.48911 .59779 L
.49024 .59775 L
.49149 .59607 L
.49264 .59302 L
Mistroke
.49389 .58803 L
.49522 .58096 L
.49746 .56498 L
.49991 .54196 L
.51079 .38806 L
.51614 .29892 L
.52108 .22214 L
.52557 .16454 L
.52783 .14154 L
.52913 .13043 L
.53033 .1217 L
.53152 .11441 L
.53282 .10813 L
.53413 .10362 L
.53485 .10194 L
.53551 .10087 L
.53674 .10014 L
.53786 .10091 L
.53915 .10346 L
.54037 .1075 L
.54154 .1128 L
.54263 .11901 L
.5451 .13742 L
.54752 .16067 L
.55011 .19073 L
.55907 .32072 L
.56416 .39782 L
.56958 .46827 L
.57181 .49135 L
.57421 .51143 L
.57558 .52046 L
.57684 .52708 L
.57805 .53186 L
.57932 .53522 L
.58053 .5368 L
.58183 .53671 L
.58305 .53493 L
.58417 .53188 L
.58547 .52657 L
.58689 .51874 L
.58947 .49917 L
.59226 .47073 L
.59522 .43331 L
.60053 .35186 L
.61022 .18669 L
.61556 .10736 L
.61819 .07553 L
.62064 .05138 L
.623 .03352 L
.62432 .02602 L
Mistroke
.62552 .02081 L
.62683 .01687 L
.62758 .01549 L
.62826 .01474 L
.62952 .01472 L
.63015 .01536 L
.63084 .01657 L
.63206 .01997 L
.63317 .02446 L
.63446 .03128 L
.63567 .03932 L
.64018 .08171 L
.64473 .14189 L
.64894 .20866 L
.65848 .37073 L
.66311 .43951 L
.66555 .4697 L
.66811 .49597 L
.67036 .51386 L
.67164 .5217 L
.67283 .52744 L
.67392 .53139 L
.67492 .53384 L
.67607 .53532 L
.67715 .53539 L
.67834 .53398 L
.67965 .53066 L
.68031 .5283 L
.68102 .52525 L
.68229 .51843 L
.68477 .50061 L
.68704 .47939 L
.69253 .41181 L
.69775 .33422 L
.70737 .19342 L
.71014 .16092 L
.71274 .1358 L
.71508 .11845 L
.7164 .11102 L
.7176 .10576 L
.71867 .10238 L
.71982 .10011 L
.72089 .09925 L
.72188 .09957 L
.72303 .10127 L
.72428 .10475 L
.72547 .10957 L
.72656 .11533 L
.72874 .13047 L
.73114 .15248 L
Mistroke
.73601 .21189 L
.74678 .3844 L
.75209 .46844 L
.75703 .533 L
.75932 .55651 L
.76148 .57424 L
.76267 .58207 L
.76397 .58889 L
.76514 .59355 L
.76622 .59651 L
.76743 .59831 L
.76855 .59854 L
.76978 .59719 L
.77048 .59569 L
.77111 .59386 L
.77238 .58887 L
.77376 .58145 L
.77627 .56283 L
.77866 .53927 L
.7809 .51241 L
.78602 .43697 L
.79639 .25583 L
.80075 .18488 L
.80535 .12336 L
.80776 .0984 L
.80903 .08749 L
.81039 .07767 L
.81165 .07037 L
.81279 .06522 L
.81393 .0615 L
.81502 .05932 L
.81617 .05844 L
.8174 .05915 L
.81857 .06137 L
.81964 .0647 L
.82089 .07014 L
.82225 .07793 L
.82473 .09684 L
.82731 .12251 L
.83006 .15565 L
.83501 .22635 L
.84462 .37483 L
.84884 .43068 L
.85107 .45535 L
.85346 .47716 L
.85481 .4872 L
.85605 .49478 L
.85729 .50084 L
.85847 .50511 L
.85978 .50816 L
Mistroke
.861 .50933 L
.86164 .5093 L
.86234 .50877 L
.86307 .50766 L
.86376 .50609 L
.86441 .50413 L
.86512 .50149 L
.86655 .49455 L
.86912 .47698 L
.87211 .44866 L
.87489 .41567 L
.88458 .2689 L
.88967 .18763 L
.89507 .11299 L
.89768 .08404 L
.89907 .07106 L
.90055 .05913 L
.90192 .0501 L
.90316 .04353 L
.90442 .03859 L
.9056 .03548 L
.9068 .03392 L
.90807 .03401 L
.90928 .03577 L
.91036 .03875 L
.91165 .04396 L
.91303 .05163 L
.91555 .07075 L
.9178 .09332 L
.92026 .12342 L
.92524 .19827 L
.93414 .35624 L
.93941 .44528 L
.942 .48342 L
.94439 .51405 L
.94651 .53702 L
.94886 .55717 L
.94999 .56486 L
.95121 .57159 L
.9525 .57692 L
.95371 .58023 L
.95438 .58137 L
.9551 .58202 L
.95639 .58174 L
.95718 .58066 L
.95792 .579 L
.95859 .577 L
.95931 .57429 L
.96066 .56774 L
.96209 .55876 L
Mistroke
.96464 .53768 L
.96941 .48321 L
.97464 .40673 L
.97619 .38215 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[50]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`006goo00<007ooOol0ogoo0goo000KOol0
0`00Oomoo`3oOol3Ool000]oo`03001oogoo009oo`04001oogooOol30004Ool00`00Oomoo`3oOol3
Ool000Yoo`03001oo`0000Moo`03001oogoo00Aoo`03001oogoo0?moo`=oo`001Goo0`000Woo00<0
07oo000027oo00<007ooOol00goo0P00WWoo0P00Hgoo000:Ool00`00Ool00008Ool00`00Oomoo`03
Ool00`00Oomoo`0QOol2001jOol00`00Ool0001ROol000Yoo`03001oo`0000Moo`03001oo`0000Ao
o`03001oogoo025oo`8007Yoo`03001oo`00069oo`002goo00<007ooOol01goo00<007ooOol00goo
00<007ooOol08Goo00<007oo0000NGoo00<007oo0000HWoo000KOol00`00Oomoo`0QOol00`00Ool0
001hOol01000Oomoo`00HWoo000KOol00`00Oomoo`0QOol00`00Ool0000_Ool20017Ool01@00Oomo
ogoo0000AWoo0P006Goo000KOol00`00Oomoo`0QOol01000Oomoo`00;Woo0P00Agoo00D007ooOomo
o`0004Ioo`03001oo`0001Qoo`006goo00<007ooOol087oo00D007ooOomoo`0002ioo`03001oo`00
04Ioo`05001oogooOol00016Ool00`00Ool0000HOol001]oo`80025oo`05001oogooOol0000]Ool0
1000Oomoo`00AWoo00D007ooOomoo`0004Eoo`04001oogoo000HOol001]oo`03001oogoo021oo`05
001oogooOol0000]Ool01000Oomoo`00AWoo00D007ooOomoo`0004Eoo`04001oogoo000HOol001]o
o`03001oogoo021oo`05001oogooOol0000]Ool01000Oomoo`00AWoo00D007ooOomoo`0004Eoo`04
001oogoo000HOol001]oo`03001oogoo021oo`05001oogooOol0000]Ool01000Oomoo`005Woo00<0
07ooOol0;Goo00D007ooOomoo`0002moo`03001oogoo01=oo`04001oogoo000HOol001]oo`03001o
ogoo01moo`03001oogoo009oo`03001oogoo02]oo`04001oogoo000EOol00`00Ool0000^Ool00`00
Oomoo`02Ool00`00Oomoo`0[Ool2000EOol01000Oomoo`0067oo000KOol00`00Oomoo`0OOol00`00
Oomoo`02Ool00`00Oomoo`0[Ool01000Oomoo`005Goo00<007oo0000;Goo00<007ooOol00goo00<0
07ooOol0:goo00<007oo000057oo00D007ooOomoo`0001Moo`006goo00<007ooOol07goo00<007oo
Ool00Woo00<007ooOol0:Woo00<007ooOol00Woo00<007ooOol04Woo00<007oo0000;Goo00<007oo
Ool00goo00<007ooOol0:Woo00@007ooOol001Aoo`05001oogooOol0000GOol001]oo`80021oo`03
001oogoo009oo`03001oogoo02Yoo`03001oogoo009oo`03001oogoo019oo`03001oo`0002eoo`03
001oogoo00=oo`03001oogoo02Yoo`04001oogoo000DOol01@00Oomoogoo00005goo000KOol00`00
Oomoo`0OOol00`00Oomoo`02Ool00`00Oomoo`0ZOol00`00Oomoo`02Ool00`00Oomoo`0AOol01@00
Oomoogoo0000;7oo00<007ooOol00goo00<007ooOol0:Woo00@007ooOol001Aoo`05001oogooOol0
000GOol001]oo`03001oogoo01moo`03001oogoo009oo`03001oogoo02Yoo`03001oogoo009oo`03
001oogoo015oo`05001oogooOol0000/Ool00`00Oomoo`03Ool00`00Oomoo`0ZOol01000Oomoo`00
4goo00<007ooOol00Woo00<007ooOol05Goo000KOol00`00Oomoo`09Ool2000DOol00`00Oomoo`03
Ool00`00Oomoo`0YOol00`00Oomoo`02Ool00`00Oomoo`0AOol01@00Oomoogoo0000;7oo00<007oo
Ool00goo00<007ooOol0:Woo00@007ooOol001=oo`03001oogoo00=oo`03001oogoo01Aoo`006goo
00<007ooOol02Goo0P0057oo00<007ooOol00goo00<007ooOol0:Goo00<007ooOol00goo00<007oo
Ool047oo00D007ooOomoo`0002aoo`03001oogoo00=oo`03001oogoo02Yoo`04001oogoo000COol0
0`00Oomoo`03Ool00`00Oomoo`0DOol001]oo`03001oogoo00Qoo`04001oogoo000COol00`00Oomo
o`03Ool00`00Oomoo`0YOol00`00Oomoo`03Ool00`00Oomoo`0@Ool01@00Oomoogoo0000:goo00<0
07ooOol017oo00<007ooOol0:Woo00D007ooOomoo`00019oo`03001oogoo00=oo`03001oogoo01Ao
o`006goo00<007ooOol027oo00@007ooOol001=oo`03001oogoo00=oo`03001oogoo02Uoo`03001o
ogoo00=oo`03001oogoo011oo`05001oogooOol0000[Ool00`00Oomoo`04Ool00`00Oomoo`0YOol0
0`00Oomoo`02Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool00`00Oomoo`0DOol001]oo`03001oogoo
00Qoo`04001oogoo000COol00`00Oomoo`03Ool00`00Oomoo`0YOol00`00Oomoo`03Ool00`00Oomo
o`0@Ool01@00Oomoogoo00005Woo00<007ooOol04Woo00<007ooOol017oo00<007ooOol04Woo0P00
5Goo00<007ooOol00Woo00<007ooOol047oo00<007ooOol00goo00<007ooOol057oo000KOol20009
Ool01000Oomoo`004goo00<007ooOol00goo00<007ooOol0:7oo00<007ooOol017oo00<007ooOol0
47oo00D007ooOomoo`0001Ioo`8001=oo`03001oogoo00Aoo`03001oogoo019oo`8001Eoo`03001o
ogoo009oo`03001oogoo011oo`03001oogoo00=oo`03001oogoo01Aoo`006goo00<007ooOol027oo
00@007ooOol001=oo`03001oogoo00=oo`03001oogoo02Qoo`03001oogoo00Aoo`03001oogoo011o
o`05001oogooOol0000EOol00`00Ool0000COol00`00Oomoo`04Ool00`00Oomoo`0AOol00`00Ool0
000EOol00`00Oomoo`02Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool00`00Oomoo`0DOol001]oo`03
001oogoo00Qoo`05001oogooOol0000BOol00`00Oomoo`03Ool00`00Oomoo`0BOol2000DOol00`00
Oomoo`04Ool00`00Oomoo`0@Ool01@00Oomoogoo00005Goo00@007ooOol0019oo`03001oogoo00Ao
o`03001oogoo015oo`03001oo`0001Eoo`03001oogoo00=oo`03001oogoo00moo`03001oogoo00=o
o`03001oogoo01Aoo`006goo00<007ooOol027oo00D007ooOomoo`00019oo`03001oogoo00=oo`03
001oogoo019oo`<001=oo`03001oogoo00Aoo`03001oogoo00moo`03001oogoo009oo`03001oogoo
01=oo`04001oogoo000BOol00`00Oomoo`05Ool00`00Oomoo`0@Ool01000Oomoo`0057oo00<007oo
Ool00goo00<007ooOol03goo00<007ooOol00goo00<007ooOol057oo000KOol00`00Oomoo`07Ool0
0`00Oomoo`02Ool00`00Oomoo`0?Ool00`00Oomoo`04Ool00`00Oomoo`0BOol00`00Ool0000COol0
0`00Oomoo`04Ool00`00Oomoo`0?Ool00`00Oomoo`03Ool00`00Oomoo`0BOol01000Oomoo`004Woo
00<007ooOol01Goo00<007ooOol047oo00@007ooOol001Aoo`03001oogoo00=oo`03001oogoo00mo
o`03001oogoo00=oo`03001oogoo01Aoo`006goo00<007ooOol01goo00<007ooOol00Woo00<007oo
Ool03goo00<007ooOol017oo00<007ooOol04Goo00@007ooOol001=oo`03001oogoo00Aoo`03001o
ogoo00moo`03001oogoo00=oo`03001oogoo019oo`04001oogoo000BOol00`00Oomoo`05Ool00`00
Oomoo`0@Ool01000Oomoo`0057oo00<007ooOol00goo00<007ooOol03goo00<007ooOol00goo00<0
07ooOol057oo000KOol00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`0?Ool00`00Oomoo`05
Ool00`00Oomoo`0@Ool01000Oomoo`004goo00<007ooOol017oo00<007ooOol03goo00<007ooOol0
0goo00<007ooOol04Woo00@007ooOol0019oo`03001oogoo00Eoo`03001oogoo011oo`04001oogoo
000DOol00`00Oomoo`03Ool00`00Oomoo`0?Ool00`00Oomoo`03Ool00`00Oomoo`0DOol001]oo`03
001oogoo00Moo`03001oogoo009oo`03001oogoo00moo`03001oogoo00Eoo`03001oogoo011oo`04
001oogoo000COol00`00Oomoo`04Ool00`00Oomoo`0?Ool00`00Oomoo`03Ool00`00Oomoo`0AOol0
1@00Oomoogoo00004Woo00<007ooOol01Goo00<007ooOol03goo00D007ooOomoo`0001Aoo`03001o
ogoo00=oo`03001oogoo00moo`03001oogoo00=oo`03001oogoo01Aoo`006goo0P0027oo00<007oo
Ool00Woo00<007ooOol03goo00<007ooOol01Goo00<007ooOol047oo00@007ooOol001=oo`03001o
ogoo00Aoo`03001oogoo00moo`03001oogoo00=oo`03001oogoo015oo`05001oogooOol0000BOol0
0`00Oomoo`05Ool00`00Oomoo`0?Ool01@00Oomoogoo000057oo00<007ooOol00goo00<007ooOol0
3Woo00<007ooOol017oo00<007ooOol057oo000KOol00`00Oomoo`07Ool00`00Oomoo`03Ool00`00
Oomoo`0>Ool00`00Oomoo`05Ool00`00Oomoo`0@Ool01@00Oomoogoo00004Woo00<007ooOol01Goo
00<007ooOol03Woo00<007ooOol00goo00<007ooOol04Goo00D007ooOomoo`00019oo`03001oogoo
00Eoo`03001oogoo00moo`05001oogooOol0000DOol00`00Oomoo`03Ool00`00Oomoo`0>Ool00`00
Oomoo`04Ool00`00Oomoo`0DOol001]oo`03001oogoo00Moo`03001oogoo00=oo`03001oogoo00io
o`03001oogoo00Eoo`03001oogoo011oo`05001oogooOol0000BOol00`00Oomoo`05Ool00`00Oomo
o`0>Ool00`00Oomoo`03Ool00`00Oomoo`0AOol01@00Oomoogoo00004Woo00<007ooOol01Goo00<0
07ooOol03goo00D007ooOomoo`0001=oo`03001oogoo00Aoo`03001oogoo00ioo`03001oogoo00Ao
o`03001oogoo01Aoo`006goo00<007ooOol01goo00<007ooOol00goo00<007ooOol03Woo00<007oo
Ool01Goo00<007ooOol047oo00D007ooOomoo`00019oo`03001oogoo00Eoo`03001oogoo00ioo`03
001oogoo00=oo`03001oogoo015oo`05001oogooOol0000BOol00`00Oomoo`05Ool00`00Oomoo`0?
Ool00`00Oomoo`02Ool00`00Oomoo`0@Ool00`00Oomoo`04Ool00`00Oomoo`0>Ool00`00Oomoo`05
Ool00`00Oomoo`0COol001]oo`03001oogoo00Moo`03001oogoo00=oo`03001oogoo00ioo`03001o
ogoo00Eoo`03001oogoo011oo`05001oogooOol0000BOol00`00Oomoo`05Ool00`00Oomoo`0>Ool0
0`00Oomoo`03Ool00`00Oomoo`0AOol01@00Oomoogoo00004Goo00<007ooOol01Woo00<007ooOol0
3goo00<007ooOol00Woo00<007ooOol047oo00<007ooOol017oo00<007ooOol03Woo00<007ooOol0
1Goo00<007ooOol04goo000KOol00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Oomoo`0=Ool00`00
Oomoo`06Ool00`00Oomoo`0@Ool01@00Oomoogoo00004Woo00<007ooOol01Goo00<007ooOol03Woo
00<007ooOol017oo00<007ooOol047oo00<007ooOol00Woo00<007ooOol03Woo00<007ooOol01Woo
00<007ooOol03Woo00<007ooOol00goo00<007ooOol047oo00<007ooOol017oo00<007ooOol03Woo
00<007ooOol01Goo00<007ooOol04goo000;Ool00`00Oomoo`02Ool00`00Oomoo`050003Ool00`00
Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`0=Ool00`00Oomoo`06Ool00`00Oomoo`0?Ool00`00
Oomoo`02Ool00`00Oomoo`0@Ool00`00Oomoo`05Ool00`00Oomoo`0>Ool00`00Oomoo`04Ool00`00
Oomoo`0?Ool00`00Oomoo`03Ool00`00Oomoo`0>Ool00`00Oomoo`06Ool00`00Oomoo`0>Ool00`00
Oomoo`03Ool00`00Oomoo`0@Ool00`00Oomoo`04Ool00`00Oomoo`0>Ool00`00Oomoo`05Ool00`00
Oomoo`0COol000Yoo`03001oo`0000Qoo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo00Ao
o`03001oogoo00eoo`03001oogoo00Ioo`03001oogoo00moo`03001oogoo009oo`03001oogoo011o
o`03001oogoo00Eoo`03001oogoo00ioo`03001oogoo00Aoo`03001oogoo00moo`03001oogoo00=o
o`03001oogoo00ioo`03001oogoo00Ioo`03001oogoo00ioo`03001oogoo00=oo`03001oogoo011o
o`03001oogoo00Aoo`03001oogoo00ioo`03001oogoo00Eoo`03001oogoo01=oo`001Goo0`000Woo
00<007oo000027oo00<007ooOol00goo0P001goo00<007ooOol017oo00<007ooOol03Goo00<007oo
Ool01Woo00<007ooOol03goo00<007ooOol00Woo00<007ooOol03goo00<007ooOol01Woo00<007oo
Ool03Goo00<007ooOol01Goo00<007ooOol03goo00<007ooOol00goo00<007ooOol03Woo00<007oo
Ool01Woo00<007ooOol03Woo00<007ooOol00goo00<007ooOol047oo00<007ooOol017oo00<007oo
Ool03Woo00<007ooOol01Goo00<007ooOol04goo000:Ool00`00Ool00008Ool00`00Oomoo`03Ool0
0`00Oomoo`06Ool00`00Oomoo`04Ool00`00Oomoo`0=Ool00`00Oomoo`06Ool00`00Oomoo`0?Ool0
0`00Oomoo`02Ool00`00Oomoo`0?Ool00`00Oomoo`06Ool00`00Oomoo`0=Ool00`00Oomoo`05Ool0
0`00Oomoo`0?Ool00`00Oomoo`03Ool00`00Oomoo`0>Ool00`00Oomoo`06Ool00`00Oomoo`0>Ool0
0`00Oomoo`03Ool00`00Oomoo`0@Ool00`00Oomoo`04Ool00`00Oomoo`0>Ool00`00Oomoo`05Ool0
0`00Oomoo`0COol000Yoo`03001oo`0000Qoo`03001oogoo00=oo`03001oogoo00Ioo`03001oogoo
00Aoo`03001oogoo00eoo`03001oogoo00Ioo`03001oogoo00moo`03001oogoo009oo`03001oogoo
00moo`03001oogoo00Ioo`03001oogoo00eoo`03001oogoo00Eoo`03001oogoo00moo`03001oogoo
00=oo`03001oogoo00ioo`03001oogoo00Ioo`03001oogoo00ioo`03001oogoo00=oo`03001oogoo
00moo`03001oogoo00Eoo`03001oogoo00eoo`03001oogoo00Ioo`03001oogoo01=oo`002goo00<0
07ooOol01Woo0P001Goo00<007ooOol01Woo00<007ooOol017oo00<007ooOol03Goo00<007ooOol0
1Woo00<007ooOol03goo00<007ooOol00Woo00<007ooOol03goo00<007ooOol01Woo00<007ooOol0
3Goo00<007ooOol01Goo00<007ooOol03goo00<007ooOol00goo00<007ooOol03Woo00<007ooOol0
1Woo00<007ooOol03Woo00<007ooOol00goo00<007ooOol03goo00<007ooOol01Woo00<007ooOol0
37oo00<007ooOol01Woo00<007ooOol04goo000KOol00`00Oomoo`06Ool00`00Oomoo`04Ool00`00
Oomoo`0=Ool00`00Oomoo`06Ool00`00Oomoo`0?Ool00`00Oomoo`02Ool00`00Oomoo`0?Ool00`00
Oomoo`06Ool00`00Oomoo`0=Ool00`00Oomoo`05Ool00`00Oomoo`0?Ool00`00Oomoo`04Ool00`00
Oomoo`0=Ool00`00Oomoo`07Ool00`00Oomoo`0=Ool00`00Oomoo`03Ool00`00Oomoo`0?Ool00`00
Oomoo`06Ool00`00Oomoo`0<Ool00`00Oomoo`06Ool00`00Oomoo`0COol001]oo`03001oogoo00Io
o`03001oogoo00Aoo`03001oogoo00eoo`03001oogoo00Moo`03001oogoo00ioo`03001oogoo00=o
o`03001oogoo00ioo`03001oogoo00Ioo`03001oogoo00eoo`03001oogoo00Eoo`03001oogoo00mo
o`03001oogoo00Aoo`03001oogoo00eoo`03001oogoo00Moo`03001oogoo00eoo`03001oogoo00Ao
o`03001oogoo00ioo`03001oogoo00Ioo`03001oogoo00aoo`03001oogoo00Moo`03001oogoo019o
o`006goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol037oo00<007ooOol01goo00<007oo
Ool03Goo00<007ooOol017oo00<007ooOol03Woo00<007ooOol01Woo00<007ooOol03Goo00<007oo
Ool01Goo00<007ooOol03goo00<007ooOol017oo00<007ooOol03Goo00<007ooOol01goo00<007oo
Ool03Goo00<007ooOol017oo00<007ooOol03Woo00<007ooOol01Woo00<007ooOol037oo00<007oo
Ool01goo00<007ooOol04Woo000KOol00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`0<Ool0
0`00Oomoo`07Ool00`00Oomoo`0=Ool00`00Oomoo`04Ool00`00Oomoo`0>Ool00`00Oomoo`06Ool0
0`00Oomoo`0=Ool00`00Oomoo`05Ool00`00Oomoo`0?Ool00`00Oomoo`04Ool00`00Oomoo`0=Ool0
0`00Oomoo`07Ool00`00Oomoo`0=Ool00`00Oomoo`04Ool00`00Oomoo`0>Ool00`00Oomoo`06Ool0
0`00Oomoo`0<Ool00`00Oomoo`07Ool00`00Oomoo`0BOol001]oo`8000Moo`03001oogoo00Eoo`03
001oogoo00aoo`03001oogoo00Moo`03001oogoo00eoo`03001oogoo00Aoo`03001oogoo00ioo`03
001oogoo00Ioo`03001oogoo00eoo`03001oogoo00Eoo`03001oogoo00moo`03001oogoo00Aoo`03
001oogoo00eoo`03001oogoo00Moo`03001oogoo00eoo`03001oogoo00Aoo`03001oogoo00ioo`03
001oogoo00Ioo`03001oogoo00aoo`03001oogoo00Moo`03001oogoo019oo`006goo00<007ooOol0
1Woo00<007ooOol01Goo00<007ooOol037oo00<007ooOol01goo00<007ooOol03Goo00<007ooOol0
17oo00<007ooOol03Woo00<007ooOol01Woo00<007ooOol03Goo00<007ooOol01Goo00<007ooOol0
3Woo00<007ooOol01Goo00<007ooOol03Goo00<007ooOol01goo00<007ooOol03Goo00<007ooOol0
17oo00<007ooOol03Woo00<007ooOol01Woo00<007ooOol037oo00<007ooOol01goo00<007ooOol0
4Woo000KOol00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`0<Ool00`00Oomoo`07Ool00`00
Oomoo`0=Ool00`00Oomoo`04Ool00`00Oomoo`0>Ool00`00Oomoo`06Ool00`00Oomoo`0=Ool00`00
Oomoo`05Ool00`00Oomoo`0>Ool00`00Oomoo`05Ool00`00Oomoo`0=Ool00`00Oomoo`07Ool00`00
Oomoo`0=Ool00`00Oomoo`04Ool00`00Oomoo`0>Ool00`00Oomoo`06Ool00`00Oomoo`0<Ool00`00
Oomoo`07Ool00`00Oomoo`0BOol001]oo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00ao
o`03001oogoo00Moo`03001oogoo00eoo`03001oogoo00Aoo`03001oogoo00ioo`03001oogoo00Io
o`03001oogoo00eoo`03001oogoo00Eoo`03001oogoo00ioo`03001oogoo00Eoo`03001oogoo00eo
o`03001oogoo00Moo`03001oogoo00eoo`03001oogoo00Aoo`03001oogoo00ioo`03001oogoo00Io
o`03001oogoo00aoo`03001oogoo00Moo`03001oogoo019oo`006goo00<007ooOol01Woo00<007oo
Ool01Goo00<007ooOol037oo00<007ooOol01goo00<007ooOol03Goo00<007ooOol017oo00<007oo
Ool03Woo00<007ooOol01Woo00<007ooOol03Goo00<007ooOol01Goo00<007ooOol03Woo00<007oo
Ool01Goo00<007ooOol03Goo00<007ooOol01goo00<007ooOol03Goo00<007ooOol017oo00<007oo
Ool03Woo00<007ooOol01Woo00<007ooOol037oo00<007ooOol01goo00<007ooOol04Woo000KOol0
0`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`0;Ool00`00Oomoo`08Ool00`00Oomoo`0=Ool0
0`00Oomoo`04Ool00`00Oomoo`0>Ool00`00Oomoo`07Ool00`00Oomoo`0;Ool00`00Oomoo`06Ool0
0`00Oomoo`0>Ool00`00Oomoo`05Ool00`00Oomoo`0=Ool00`00Oomoo`07Ool00`00Oomoo`0=Ool0
0`00Oomoo`04Ool00`00Oomoo`0>Ool00`00Oomoo`07Ool00`00Oomoo`0;Ool00`00Oomoo`07Ool0
0`00Oomoo`0BOol001]oo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00]oo`03001oogoo
00Qoo`03001oogoo00eoo`03001oogoo00Aoo`03001oogoo00ioo`03001oogoo00Moo`03001oogoo
00]oo`03001oogoo00Moo`03001oogoo00eoo`03001oogoo00Eoo`03001oogoo00eoo`03001oogoo
00Moo`03001oogoo00eoo`03001oogoo00Aoo`03001oogoo00ioo`03001oogoo00Moo`03001oogoo
00]oo`03001oogoo00Moo`03001oogoo019oo`006goo00<007ooOol01Goo00<007ooOol01Woo00<0
07ooOol02goo00<007ooOol027oo00<007ooOol03Goo00<007ooOol017oo00<007ooOol03Woo00<0
07ooOol01goo00<007ooOol02goo00<007ooOol01goo00<007ooOol03Goo00<007ooOol01Goo00<0
07ooOol037oo00<007ooOol027oo00<007ooOol037oo00<007ooOol01Goo00<007ooOol03Woo00<0
07ooOol01goo00<007ooOol02goo00<007ooOol01goo00<007ooOol04Woo000KOol20006Ool00`00
Oomoo`06Ool00`00Oomoo`0;Ool00`00Oomoo`08Ool00`00Oomoo`0=Ool00`00Oomoo`04Ool00`00
Oomoo`0>Ool00`00Oomoo`07Ool00`00Oomoo`0;Ool00`00Oomoo`07Ool00`00Oomoo`0=Ool00`00
Oomoo`05Ool00`00Oomoo`0<Ool00`00Oomoo`08Ool00`00Oomoo`0<Ool00`00Oomoo`05Ool00`00
Oomoo`0=Ool00`00Oomoo`08Ool00`00Oomoo`0;Ool00`00Oomoo`07Ool00`00Oomoo`0BOol001]o
o`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00]oo`03001oogoo00Qoo`03001oogoo00eo
o`03001oogoo00Eoo`03001oogoo00eoo`03001oogoo00Moo`03001oogoo00]oo`03001oogoo00Mo
o`03001oogoo00eoo`03001oogoo00Ioo`03001oogoo00]oo`03001oogoo00Qoo`03001oogoo00ao
o`03001oogoo00Eoo`03001oogoo00eoo`03001oogoo00Qoo`03001oogoo00]oo`03001oogoo00Mo
o`03001oogoo019oo`006goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol02goo00<007oo
Ool027oo00<007ooOol03Goo00<007ooOol01Goo00<007ooOol03Goo00<007ooOol01goo00<007oo
Ool02goo00<007ooOol01goo00<007ooOol03Goo00<007ooOol01Woo00<007ooOol02goo00<007oo
Ool027oo00<007ooOol037oo00<007ooOol01Goo00<007ooOol03Goo00<007ooOol027oo00<007oo
Ool02Woo00<007ooOol027oo00<007ooOol04Woo000KOol00`00Oomoo`05Ool00`00Oomoo`06Ool0
0`00Oomoo`0;Ool00`00Oomoo`08Ool00`00Oomoo`0=Ool00`00Oomoo`05Ool00`00Oomoo`0=Ool0
0`00Oomoo`07Ool00`00Oomoo`0;Ool00`00Oomoo`07Ool00`00Oomoo`0=Ool00`00Oomoo`06Ool0
0`00Oomoo`0;Ool00`00Oomoo`08Ool00`00Oomoo`0<Ool00`00Oomoo`05Ool00`00Oomoo`0=Ool0
0`00Oomoo`08Ool00`00Oomoo`0:Ool00`00Oomoo`08Ool00`00Oomoo`0BOol001]oo`03001oogoo
00Eoo`03001oogoo00Ioo`03001oogoo00]oo`03001oogoo00Uoo`03001oogoo00]oo`03001oogoo
00Ioo`03001oogoo00aoo`03001oogoo00Qoo`03001oogoo00]oo`03001oogoo00Moo`03001oogoo
00eoo`03001oogoo00Ioo`03001oogoo00]oo`03001oogoo00Uoo`03001oogoo00]oo`03001oogoo
00Eoo`03001oogoo00eoo`03001oogoo00Qoo`03001oogoo00Yoo`03001oogoo00Qoo`03001oogoo
019oo`006goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol02goo00<007ooOol02Goo00<0
07ooOol02goo00<007ooOol01Woo00<007ooOol037oo00<007ooOol027oo00<007ooOol02goo00<0
07ooOol01goo00<007ooOol03Goo00<007ooOol01Woo00<007ooOol02goo00<007ooOol02Goo00<0
07ooOol02goo00<007ooOol01Woo00<007ooOol037oo00<007ooOol027oo00<007ooOol02Woo00<0
07ooOol02Goo00<007ooOol04Goo000KOol00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`0;
Ool00`00Oomoo`09Ool00`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`0<Ool00`00Oomoo`08
Ool00`00Oomoo`0:Ool00`00Oomoo`08Ool00`00Oomoo`0=Ool00`00Oomoo`06Ool00`00Oomoo`0;
Ool00`00Oomoo`09Ool00`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`0<Ool00`00Oomoo`08
Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`0AOol001]oo`8000Ioo`03001oogoo00Io
o`03001oogoo00]oo`03001oogoo00Uoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo00ao
o`03001oogoo00Qoo`03001oogoo00Yoo`03001oogoo00Qoo`03001oogoo00eoo`03001oogoo00Io
o`03001oogoo00]oo`03001oogoo00Uoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo00ao
o`03001oogoo00Qoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo015oo`006goo00<007oo
Ool01Goo00<007ooOol01Woo00<007ooOol02goo00<007ooOol02Goo00<007ooOol02goo00<007oo
Ool01Woo00<007ooOol037oo00<007ooOol027oo00<007ooOol02Woo00<007ooOol027oo00<007oo
Ool03Goo00<007ooOol01Woo00<007ooOol02goo00<007ooOol02Goo00<007ooOol02goo00<007oo
Ool01Woo00<007ooOol037oo00<007ooOol027oo00<007ooOol02Woo00<007ooOol02Goo00<007oo
Ool04Goo000KOol00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool0
0`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`0<Ool00`00Oomoo`08Ool00`00Oomoo`0:Ool0
0`00Oomoo`08Ool00`00Oomoo`0=Ool00`00Oomoo`06Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool0
0`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`0<Ool00`00Oomoo`08Ool00`00Oomoo`0:Ool0
0`00Oomoo`09Ool00`00Oomoo`0AOol001]oo`03001oogoo00Eoo`03001oogoo00Moo`03001oogoo
00Yoo`03001oogoo00Uoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo00aoo`03001oogoo
00Qoo`03001oogoo00Yoo`03001oogoo00Qoo`03001oogoo00aoo`03001oogoo00Moo`03001oogoo
00]oo`03001oogoo00Uoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo00aoo`03001oogoo
00Qoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo015oo`006goo00<007ooOol01Goo00<0
07ooOol01goo00<007ooOol02Woo00<007ooOol02Goo00<007ooOol02goo00<007ooOol01Woo00<0
07ooOol037oo00<007ooOol027oo00<007ooOol02Woo00<007ooOol027oo00<007ooOol037oo00<0
07ooOol01goo00<007ooOol02goo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol01goo00<0
07ooOol037oo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol04Goo000K
Ool00`00Oomoo`05Ool00`00Oomoo`07Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`0;
Ool60002Ool2000>Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`03
Ool30003Ool01000Oomoo`002Goo00<007ooOol02goo00<007ooOol02Goo00<007ooOol02Woo00<0
07ooOol00goo0P000Woo00<007oo000037oo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol0
2Goo00<007ooOol01Woo0`000Woo00<007ooOol00goo000KOol00`00Oomoo`05Ool00`00Oomoo`07
Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`0;Ool01000Oomoo`000goo00<007oo0000
3Woo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol027oo00<007ooOol00goo00<007ooOol0
0Woo00D007oo001oo`0000Uoo`03001oogoo00Yoo`03001oogoo00Yoo`03001oogoo00Yoo`03001o
ogoo00Eoo`06001oo`00001oo`002goo00<007ooOol02Goo00<007ooOol02Goo00<007ooOol02Goo
00<007ooOol01goo00H007ooOol007oo0004Ool001]oo`03001oogoo00Eoo`03001oogoo00Moo`03
001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00]oo`04001oogoo0003Ool00`00Ool0000>Ool0
0`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`04Ool02@00Oomoogoo001o
o`00Ool00009Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00Oomoo`04Ool0
0`00Oomoo`0200000goo001oo`0:Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool0
0`00Oomoo`05Ool4000017oo001oo`0017oo000KOol20006Ool00`00Oomoo`07Ool00`00Oomoo`0:
Ool00`00Oomoo`09Ool00`00Oomoo`0;Ool01000Oomoo`000goo00<007oo00003Woo00<007ooOol0
2Goo00<007ooOol02Goo00<007ooOol027oo00<007ooOol017oo00T007ooOomoo`00Ool007oo0000
2Goo00<007ooOol02Woo00<007ooOol02Woo00<007ooOol02Woo00<007ooOol01Goo00H007oo0000
07oo000;Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`09Ool00`00Oomoo`05Ool00`00
Ool00002Ool00`00Ool00004Ool001]oo`03001oogoo00Eoo`03001oogoo00Moo`03001oogoo00Yo
o`03001oogoo00Uoo`03001oogoo00]oo`04001oogoo0003Ool00`00Ool0000>Ool00`00Oomoo`09
Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`03Ool00`00Ool00002Ool01@00Ool007oo
00002Goo00<007ooOol02Woo00<007ooOol02Woo00<007ooOol02Woo00<007ooOol00goo00@007oo
001oo`800003Ool007oo00Yoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001o
ogoo00Ioo`80009oo`03001oo`0000Aoo`006goo00<007ooOol017oo00<007ooOol027oo00<007oo
Ool02Woo00<007ooOol02Goo00<007ooOol02goo00@007oo000000Aoo`03001oo`0000eoo`03001o
ogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00=oo`03001oogoo009oo`04001o
ogoo0009Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00Oomoo`04Ool01P00
Oomoo`00Ool000aoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Mo
o`05001oogooOol00005Ool001]oo`03001oogoo00Aoo`03001oogoo00Qoo`03001oogoo00Yoo`03
001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Qoo`03001oogoo00]oo`03001oogoo00Uoo`03
001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00]oo`03001oogoo00Qoo`03001oogoo00Uoo`03
001oogoo00]oo`03001oogoo00Uoo`03001oogoo00Moo`03001oogoo00aoo`03001oogoo00Uoo`03
001oogoo00Uoo`03001oogoo00Uoo`03001oogoo015oo`006goo00<007ooOol017oo00<007ooOol0
27oo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol02Woo00<007ooOol027oo00<007ooOol0
2goo00<007ooOol02Goo00<007ooOol027oo00<007ooOol02Woo00<007ooOol02goo00<007ooOol0
27oo00<007ooOol02Goo00<007ooOol02goo00<007ooOol02Goo00<007ooOol01goo00<007ooOol0
37oo00<007ooOol02Goo00<007ooOol027oo00<007ooOol02Woo00<007ooOol04Goo000KOol00`00
Oomoo`04Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00
Oomoo`08Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`0:Ool00`00
Oomoo`0;Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool00`00
Oomoo`08Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`0:Ool00`00
Oomoo`0AOol001]oo`03001oogoo00Aoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Yo
o`03001oogoo00Yoo`03001oogoo00Qoo`03001oogoo00]oo`03001oogoo00Uoo`03001oogoo00Qo
o`03001oogoo00Yoo`03001oogoo00]oo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00]o
o`03001oogoo00Uoo`03001oogoo00Qoo`03001oogoo00Yoo`03001oogoo00Yoo`03001oogoo00Qo
o`03001oogoo00Yoo`03001oogoo015oo`006goo00<007ooOol017oo00<007ooOol027oo00<007oo
Ool02Goo00<007ooOol02goo00<007ooOol02Goo00<007ooOol027oo00<007ooOol02goo00<007oo
Ool02Goo00<007ooOol027oo00<007ooOol02Woo00<007ooOol02goo00<007ooOol027oo00<007oo
Ool02Goo00<007ooOol02goo00<007ooOol02Goo00<007ooOol027oo00<007ooOol02Woo00<007oo
Ool02Woo00<007ooOol027oo00<007ooOol02Woo00<007ooOol04Goo000DOooo000=000001]oo`03
001oogoo00Aoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo009oo`03
001oogoo00Eoo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo00Aoo`05
001oogooOol00008Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04
Ool01000Oomoo`002Goo00@007ooOol000Qoo`03001oogoo009oo`03001oogoo00Eoo`04001oogoo
0009Ool00`00Ool00009Ool01@00Oomoogoo000027oo00<007oo00002Woo0P002Woo00<007oo0000
2Woo00<007oo00002Woo00<007ooOol02Goo0P002goo00<007ooOol01Goo000KOol00`00Oomoo`04
Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool00`00Oomoo`04
Ool01@00Oomoogoo00003Goo00<007ooOol02Woo00<007ooOol01goo00<007ooOol02Woo00<007oo
Ool01Woo00<007ooOol00Woo00<007ooOol027oo00<007ooOol02Goo00<007ooOol02goo00<007oo
Ool027oo00<007ooOol027oo0P0037oo00<007ooOol02Woo00<007ooOol027oo00<007ooOol02Woo
00<007ooOol02Goo00<007ooOol01Goo000KOol00`00Oomoo`04Ool00`00Oomoo`09Ool00`00Oomo
o`08Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`0:Ool00`00Oomo
o`0;Ool00`00Oomoo`07Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomo
o`09Ool00`00Oomoo`0;Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomo
o`0:Ool00`00Oomoo`08Ool00`00Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03001oogoo00Aoo`03
001oogoo00Uoo`03001oogoo00Qoo`03001oogoo00]oo`03001oogoo00Uoo`03001oogoo00Qoo`03
001oogoo00Yoo`03001oogoo00]oo`03001oogoo00Moo`03001oogoo00Yoo`03001oogoo00Yoo`03
001oogoo00Uoo`03001oogoo00Qoo`03001oogoo00aoo`03001oogoo00Qoo`03001oogoo00Uoo`03
001oogoo00Yoo`03001oogoo00Yoo`03001oogoo00Qoo`03001oogoo00]oo`03001oogoo011oo`00
6goo00<007ooOol017oo00<007ooOol02Goo00<007ooOol027oo00<007ooOol02goo00<007ooOol0
27oo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol02goo00<007ooOol01goo00<007ooOol0
2Woo00<007ooOol02Woo00<007ooOol02Goo00<007ooOol027oo00<007ooOol037oo00<007ooOol0
27oo00<007ooOol02Goo00<007ooOol02Woo00<007ooOol02Woo00<007ooOol027oo00<007ooOol0
2goo00<007ooOol047oo000KOol00`00Oomoo`04Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00
Oomoo`0;Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00
Oomoo`07Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00
Oomoo`0<Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`0:Ool00`00
Oomoo`08Ool00`00Oomoo`0;Ool00`00Oomoo`0@Ool001]oo`03001oogoo00Aoo`03001oogoo00Uo
o`03001oogoo00Qoo`03001oogoo00]oo`03001oogoo00Qoo`03001oogoo00Yoo`03001oogoo00Uo
o`03001oogoo00]oo`03001oogoo00Moo`03001oogoo00Yoo`03001oogoo00Yoo`03001oogoo00Uo
o`03001oogoo00Qoo`03001oogoo00aoo`03001oogoo00Qoo`03001oogoo00Uoo`03001oogoo00Yo
o`03001oogoo00Yoo`03001oogoo00Qoo`03001oogoo00]oo`03001oogoo011oo`006goo0P001Goo
00<007ooOol02Goo00<007ooOol027oo00<007ooOol02goo00<007ooOol027oo00<007ooOol02Woo
00<007ooOol02Goo00<007ooOol02goo00<007ooOol01goo00<007ooOol02Woo00<007ooOol02Woo
00<007ooOol02Goo00<007ooOol027oo00<007ooOol037oo00<007ooOol027oo00<007ooOol02Goo
00<007ooOol02Woo00<007ooOol02goo00<007ooOol01goo00<007ooOol02goo00<007ooOol047oo
000KOol00`00Oomoo`03Ool00`00Oomoo`0:Ool00`00Oomoo`08Ool00`00Oomoo`0;Ool00`00Oomo
o`08Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`0;Ool00`00Oomoo`07Ool00`00Oomo
o`0;Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`07Ool00`00Oomoo`0=Ool00`00Oomo
o`07Ool00`00Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomo
o`0<Ool00`00Oomoo`0@Ool001]oo`03001oogoo00=oo`03001oogoo00Yoo`03001oogoo00Qoo`03
001oogoo00]oo`03001oogoo00Qoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00]oo`03
001oogoo00Moo`03001oogoo00]oo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Moo`03
001oogoo00eoo`03001oogoo00Moo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00]oo`03
001oogoo00Ioo`03001oogoo00aoo`03001oogoo011oo`006goo00<007ooOol00goo00<007ooOol0
2Woo00<007ooOol027oo00<007ooOol02goo00<007ooOol027oo00<007ooOol02Woo00<007ooOol0
2Goo00<007ooOol02goo00<007ooOol01goo00<007ooOol02goo00<007ooOol02Goo00<007ooOol0
2Woo00<007ooOol01goo00<007ooOol03Goo00<007ooOol01goo00<007ooOol02Goo00<007ooOol0
2Woo00<007ooOol02goo00<007ooOol01Woo00<007ooOol037oo00<007ooOol047oo000KOol00`00
Oomoo`03Ool00`00Oomoo`0:Ool00`00Oomoo`07Ool00`00Oomoo`0<Ool00`00Oomoo`08Ool00`00
Oomoo`0:Ool00`00Oomoo`09Ool00`00Oomoo`0;Ool00`00Oomoo`07Ool00`00Oomoo`0;Ool00`00
Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`07Ool00`00Oomoo`0=Ool00`00Oomoo`07Ool00`00
Oomoo`09Ool00`00Oomoo`0:Ool00`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`0<Ool00`00
Oomoo`0@Ool001]oo`03001oogoo00=oo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo00ao
o`03001oogoo00Qoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00]oo`03001oogoo00Mo
o`03001oogoo00]oo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Moo`03001oogoo00eo
o`03001oogoo00Moo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00]oo`03001oogoo00Io
o`03001oogoo00aoo`03001oogoo011oo`006goo00<007ooOol00goo00<007ooOol02goo00<007oo
Ool01Woo00<007ooOol037oo00<007ooOol027oo00<007ooOol02Woo00<007ooOol02Goo00<007oo
Ool02goo00<007ooOol01Woo00<007ooOol037oo00<007ooOol02Goo00<007ooOol02Woo00<007oo
Ool01goo00<007ooOol03Goo00<007ooOol01goo00<007ooOol02Woo00<007ooOol02Goo00<007oo
Ool02goo00<007ooOol01Woo00<007ooOol037oo00<007ooOol047oo000KOol00`00Oomoo`03Ool0
0`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`0<Ool00`00Oomoo`08Ool00`00Oomoo`0:Ool0
0`00Oomoo`09Ool00`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`0<Ool00`00Oomoo`08Ool0
0`00Oomoo`0;Ool00`00Oomoo`07Ool00`00Oomoo`0=Ool00`00Oomoo`07Ool00`00Oomoo`0:Ool0
0`00Oomoo`09Ool00`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`0<Ool00`00Oomoo`0@Ool0
01]oo`8000Aoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo00aoo`03001oogoo00Qoo`03
001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo00aoo`03
001oogoo00Qoo`03001oogoo00]oo`03001oogoo00Moo`03001oogoo00eoo`03001oogoo00Moo`03
001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo00aoo`03
001oogoo011oo`006goo00<007ooOol00goo00<007ooOol02goo00<007ooOol01Woo00<007ooOol0
37oo00<007ooOol027oo00<007ooOol02Woo00<007ooOol02Goo00<007ooOol037oo00<007ooOol0
1Goo00<007ooOol037oo00<007ooOol027oo00<007ooOol02goo00<007ooOol01goo00<007ooOol0
3Goo00<007ooOol01Woo00<007ooOol02goo00<007ooOol02Goo00<007ooOol02goo00<007ooOol0
1Woo00<007ooOol037oo00<007ooOol047oo000KOol00`00Oomoo`03Ool00`00Oomoo`0;Ool00`00
Oomoo`06Ool00`00Oomoo`0<Ool00`00Oomoo`08Ool00`00Oomoo`0:Ool00`00Oomoo`09Ool00`00
Oomoo`0<Ool00`00Oomoo`05Ool00`00Oomoo`0<Ool00`00Oomoo`08Ool00`00Oomoo`0;Ool00`00
Oomoo`07Ool00`00Oomoo`0=Ool00`00Oomoo`06Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool00`00
Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`0<Ool00`00Oomoo`0@Ool001]oo`03001oogoo00=o
o`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo00aoo`03001oogoo00Moo`03001oogoo00]o
o`03001oogoo00Uoo`03001oogoo00aoo`03001oogoo00Eoo`03001oogoo00aoo`03001oogoo00Qo
o`03001oogoo00aoo`03001oogoo00Ioo`03001oogoo00eoo`03001oogoo00Ioo`03001oogoo00]o
o`03001oogoo00Uoo`03001oogoo00]oo`03001oogoo00Ioo`03001oogoo00aoo`03001oogoo011o
o`006goo00<007ooOol00goo00<007ooOol02goo00<007ooOol01Woo00<007ooOol037oo00<007oo
Ool01goo00<007ooOol037oo00<007ooOol01goo00<007ooOol03Goo00<007ooOol01Goo00<007oo
Ool037oo00<007ooOol027oo00<007ooOol037oo00<007ooOol01Woo00<007ooOol03Goo00<007oo
Ool01Woo00<007ooOol02goo00<007ooOol02Goo00<007ooOol02goo00<007ooOol01Woo00<007oo
Ool037oo00<007ooOol027oo00<007ooOol01Goo000KOol00`00Oomoo`03Ool00`00Oomoo`0;Ool0
0`00Oomoo`06Ool00`00Oomoo`0=Ool00`00Oomoo`06Ool00`00Oomoo`0<Ool00`00Oomoo`07Ool0
0`00Oomoo`0=Ool00`00Oomoo`05Ool00`00Oomoo`0<Ool00`00Oomoo`08Ool00`00Oomoo`0<Ool0
0`00Oomoo`06Ool00`00Oomoo`0=Ool00`00Oomoo`06Ool00`00Oomoo`0;Ool00`00Oomoo`09Ool0
0`00Oomoo`0;Ool00`00Oomoo`06Ool00`00Oomoo`0<Ool00`00Oomoo`08Ool00`00Oomoo`05Ool0
01]oo`03001oogoo00=oo`03001oogoo00]oo`03001oogoo00Eoo`03001oogoo00ioo`03001oogoo
00Ioo`03001oogoo00aoo`03001oogoo00Moo`03001oogoo00eoo`03001oogoo00Eoo`03001oogoo
00aoo`03001oogoo00Qoo`03001oogoo00aoo`03001oogoo00Eoo`03001oogoo00ioo`03001oogoo
00Ioo`03001oogoo00]oo`03001oogoo00Qoo`03001oogoo00aoo`03001oogoo00Eoo`03001oogoo
00eoo`03001oogoo00Qoo`03001oogoo00Eoo`006goo00<007ooOol00goo00<007ooOol02goo00<0
07ooOol01Goo00<007ooOol03Woo00<007ooOol01Woo00<007ooOol037oo00<007ooOol01goo00<0
07ooOol03Goo00<007ooOol01Goo00<007ooOol037oo00<007ooOol027oo00<007ooOol037oo00<0
07ooOol01Goo00<007ooOol03Woo00<007ooOol01Woo00<007ooOol02goo00<007ooOol027oo00<0
07ooOol037oo00<007ooOol01Goo00<007ooOol03Goo00<007ooOol027oo00<007ooOol01Goo000K
Ool20004Ool00`00Oomoo`0<Ool00`00Oomoo`04Ool00`00Oomoo`0>Ool00`00Oomoo`06Ool00`00
Oomoo`0<Ool00`00Oomoo`07Ool00`00Oomoo`0=Ool00`00Oomoo`05Ool00`00Oomoo`0=Ool00`00
Oomoo`07Ool00`00Oomoo`0<Ool00`00Oomoo`05Ool00`00Oomoo`0>Ool00`00Oomoo`06Ool00`00
Oomoo`0;Ool00`00Oomoo`08Ool00`00Oomoo`0<Ool00`00Oomoo`05Ool00`00Oomoo`0=Ool00`00
Oomoo`08Ool00`00Oomoo`05Ool001]oo`03001oogoo009oo`03001oogoo00eoo`03001oogoo00Ao
o`03001oogoo00ioo`03001oogoo00Ioo`03001oogoo00aoo`03001oogoo00Moo`03001oogoo00eo
o`03001oogoo00Eoo`03001oogoo00eoo`03001oogoo00Moo`03001oogoo00aoo`03001oogoo00Eo
o`03001oogoo00ioo`03001oogoo00Ioo`03001oogoo00]oo`03001oogoo00Qoo`03001oogoo00eo
o`03001oogoo00Aoo`03001oogoo00ioo`03001oogoo00Moo`03001oogoo00Eoo`006goo00<007oo
Ool00Woo00<007ooOol03Goo00<007ooOol017oo00<007ooOol03Woo00<007ooOol01Woo00<007oo
Ool037oo00<007ooOol01goo00<007ooOol03Goo00<007ooOol01Goo00<007ooOol03Goo00<007oo
Ool01goo00<007ooOol037oo00<007ooOol01Goo00<007ooOol03goo00<007ooOol01Goo00<007oo
Ool037oo00<007ooOol01goo00<007ooOol03Goo00<007ooOol017oo00<007ooOol03Woo00<007oo
Ool01goo00<007ooOol01Goo000KOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`04Ool0
0`00Oomoo`0>Ool00`00Oomoo`06Ool00`00Oomoo`0<Ool00`00Oomoo`07Ool00`00Oomoo`0=Ool0
0`00Oomoo`05Ool00`00Oomoo`0=Ool00`00Oomoo`07Ool00`00Oomoo`0<Ool00`00Oomoo`05Ool0
0`00Oomoo`0?Ool00`00Oomoo`05Ool00`00Oomoo`0<Ool00`00Oomoo`07Ool00`00Oomoo`0=Ool0
0`00Oomoo`04Ool00`00Oomoo`0>Ool00`00Oomoo`07Ool00`00Oomoo`05Ool001]oo`03001oogoo
009oo`03001oogoo00eoo`03001oogoo00Aoo`03001oogoo00ioo`03001oogoo00Ioo`03001oogoo
00aoo`03001oogoo00Moo`03001oogoo00eoo`03001oogoo00Eoo`03001oogoo00eoo`03001oogoo
00Ioo`03001oogoo00eoo`03001oogoo00Eoo`03001oogoo00moo`03001oogoo00Eoo`03001oogoo
00aoo`03001oogoo00Moo`03001oogoo00eoo`03001oogoo00Aoo`03001oogoo00ioo`03001oogoo
00Moo`03001oogoo00Eoo`006goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol017oo00<0
07ooOol03Woo00<007ooOol01Woo00<007ooOol037oo00<007ooOol01goo00<007ooOol03Goo00<0
07ooOol01Goo00<007ooOol03Goo00<007ooOol01Woo00<007ooOol03Goo00<007ooOol01Goo00<0
07ooOol03goo00<007ooOol01Goo00<007ooOol037oo00<007ooOol01goo00<007ooOol03Goo00<0
07ooOol017oo00<007ooOol03Woo00<007ooOol01goo00<007ooOol01Goo000KOol00`00Oomoo`02
Ool00`00Oomoo`0=Ool00`00Oomoo`04Ool00`00Oomoo`0>Ool00`00Oomoo`06Ool00`00Oomoo`0<
Ool00`00Oomoo`07Ool00`00Oomoo`0=Ool00`00Oomoo`05Ool00`00Oomoo`0=Ool00`00Oomoo`06
Ool00`00Oomoo`0=Ool00`00Oomoo`05Ool00`00Oomoo`0?Ool00`00Oomoo`05Ool00`00Oomoo`0<
Ool00`00Oomoo`07Ool00`00Oomoo`0=Ool00`00Oomoo`04Ool00`00Oomoo`0>Ool00`00Oomoo`07
Ool00`00Oomoo`05Ool001]oo`8000=oo`03001oogoo00eoo`03001oogoo00Aoo`03001oogoo00io
o`03001oogoo00Ioo`03001oogoo00aoo`03001oogoo00Moo`03001oogoo00ioo`03001oogoo00=o
o`03001oogoo00ioo`03001oogoo00Ioo`03001oogoo00eoo`03001oogoo00Eoo`03001oogoo00mo
o`03001oogoo00Eoo`03001oogoo00aoo`03001oogoo00Moo`03001oogoo00eoo`03001oogoo00Ao
o`03001oogoo00ioo`03001oogoo00Ioo`03001oogoo00Ioo`006goo00<007ooOol00Woo00<007oo
Ool03Goo00<007ooOol017oo00<007ooOol03Woo00<007ooOol01Woo00<007ooOol037oo00<007oo
Ool01Woo00<007ooOol03goo00<007ooOol00goo00<007ooOol03Woo00<007ooOol01Woo00<007oo
Ool03Goo00<007ooOol01Goo00<007ooOol03goo00<007ooOol017oo00<007ooOol03Goo00<007oo
Ool01goo00<007ooOol03Goo00<007ooOol017oo00<007ooOol03Woo00<007ooOol01Woo00<007oo
Ool01Woo000KOol00`00Oomoo`02Ool00`00Oomoo`0=Ool00`00Oomoo`04Ool00`00Oomoo`0>Ool0
0`00Oomoo`06Ool00`00Oomoo`0<Ool00`00Oomoo`06Ool00`00Oomoo`0?Ool00`00Oomoo`03Ool0
0`00Oomoo`0>Ool00`00Oomoo`06Ool00`00Oomoo`0>Ool00`00Oomoo`04Ool00`00Oomoo`0?Ool0
0`00Oomoo`04Ool00`00Oomoo`0=Ool00`00Oomoo`07Ool00`00Oomoo`0=Ool00`00Oomoo`03Ool0
0`00Oomoo`0?Ool00`00Oomoo`06Ool00`00Oomoo`06Ool001]oo`03001oogoo009oo`03001oogoo
00eoo`03001oogoo00=oo`03001oogoo00moo`03001oogoo00Ioo`03001oogoo00aoo`03001oogoo
00Ioo`03001oogoo00moo`03001oogoo00=oo`03001oogoo00ioo`03001oogoo00Ioo`03001oogoo
00ioo`03001oogoo00Aoo`03001oogoo00moo`03001oogoo00Aoo`03001oogoo00eoo`03001oogoo
00Moo`03001oogoo00eoo`03001oogoo00=oo`03001oogoo00moo`03001oogoo00Ioo`03001oogoo
00Ioo`006goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00goo00<007ooOol03goo00<0
07ooOol01Woo00<007ooOol037oo00<007ooOol01Woo00<007ooOol03goo00<007ooOol00goo00<0
07ooOol03Woo00<007ooOol01Woo00<007ooOol03Woo00<007ooOol017oo00<007ooOol03goo00<0
07ooOol017oo00<007ooOol03Goo00<007ooOol01goo00<007ooOol03Goo00<007ooOol00goo00<0
07ooOol03goo00<007ooOol01Woo00<007ooOol01Woo000KOol00`00Oomoo`02Ool00`00Oomoo`0=
Ool00`00Oomoo`03Ool00`00Oomoo`0@Ool00`00Oomoo`05Ool00`00Oomoo`0=Ool00`00Oomoo`05
Ool00`00Oomoo`0?Ool00`00Oomoo`03Ool00`00Oomoo`0>Ool00`00Oomoo`06Ool00`00Oomoo`0>
Ool00`00Oomoo`04Ool00`00Oomoo`0?Ool00`00Oomoo`04Ool00`00Oomoo`0=Ool00`00Oomoo`07
Ool00`00Oomoo`0>Ool00`00Oomoo`02Ool00`00Oomoo`0?Ool00`00Oomoo`06Ool00`00Oomoo`06
Ool000]oo`03001oogoo009oo`03001oogoo00D000=oo`03001oogoo009oo`03001oogoo00eoo`03
001oogoo00=oo`03001oogoo011oo`03001oogoo00Aoo`03001oogoo00ioo`03001oogoo00Eoo`03
001oogoo00moo`03001oogoo00=oo`03001oogoo00ioo`03001oogoo00Ioo`03001oogoo00ioo`03
001oogoo00Aoo`03001oogoo00moo`03001oogoo00Aoo`03001oogoo00ioo`03001oogoo00Ioo`03
001oogoo00ioo`03001oogoo009oo`03001oogoo00moo`03001oogoo00Ioo`03001oogoo00Ioo`00
2Woo00<007oo000027oo00<007ooOol00goo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol0
0goo00<007ooOol047oo00<007ooOol017oo00<007ooOol03Woo00<007ooOol01Goo00<007ooOol0
3goo00<007ooOol00goo00<007ooOol03Woo00<007ooOol01Woo00<007ooOol03Woo00<007ooOol0
0goo00<007ooOol047oo00<007ooOol017oo00<007ooOol03Woo00<007ooOol01Woo00<007ooOol0
3Woo00<007ooOol00Woo00<007ooOol03goo00<007ooOol01Woo00<007ooOol01Woo000:Ool00`00
Ool00008Ool00`00Oomoo`03Ool20003Ool00`00Oomoo`0=Ool00`00Oomoo`03Ool00`00Oomoo`0@
Ool00`00Oomoo`04Ool00`00Oomoo`0>Ool00`00Oomoo`05Ool00`00Oomoo`0@Ool00`00Oomoo`02
Ool00`00Oomoo`0>Ool00`00Oomoo`06Ool00`00Oomoo`0>Ool00`00Oomoo`03Ool00`00Oomoo`0A
Ool00`00Oomoo`03Ool00`00Oomoo`0>Ool00`00Oomoo`05Ool00`00Oomoo`0?Ool00`00Oomoo`02
Ool00`00Oomoo`0?Ool00`00Oomoo`06Ool00`00Oomoo`06Ool000Yoo`03001oo`0000Qoo`03001o
ogoo00=oo`03001oogoo009oo`03001oogoo00eoo`03001oogoo00=oo`03001oogoo011oo`03001o
ogoo00Aoo`03001oogoo00ioo`03001oogoo00Eoo`03001oogoo011oo`03001oogoo009oo`03001o
ogoo00ioo`03001oogoo00Ioo`03001oogoo00ioo`03001oogoo00=oo`03001oogoo015oo`03001o
ogoo00=oo`03001oogoo00ioo`03001oogoo00Eoo`03001oogoo00moo`03001oogoo009oo`03001o
ogoo00moo`03001oogoo00Ioo`03001oogoo00Ioo`002Woo00<007oo000027oo00<007ooOol00goo
00<007ooOol00Woo00<007ooOol03Goo00<007ooOol00goo00<007ooOol047oo00<007ooOol017oo
00<007ooOol03Woo00<007ooOol01Goo00<007ooOol047oo00D007ooOomoo`00015oo`03001oogoo
00Ioo`03001oogoo00ioo`03001oogoo00=oo`03001oogoo015oo`03001oogoo009oo`03001oogoo
00moo`03001oogoo00Eoo`03001oogoo00moo`03001oogoo009oo`03001oogoo011oo`03001oogoo
00Aoo`03001oogoo00Moo`002goo00<007ooOol01Woo0P001Goo00D007ooOomoo`00015oo`03001o
ogoo009oo`03001oogoo011oo`03001oogoo00Aoo`03001oogoo00ioo`03001oogoo00Eoo`03001o
ogoo011oo`05001oogooOol0000BOol00`00Oomoo`04Ool00`00Oomoo`0?Ool00`00Oomoo`03Ool0
0`00Oomoo`0AOol00`00Oomoo`02Ool00`00Oomoo`0?Ool00`00Oomoo`05Ool00`00Oomoo`0@Ool0
1@00Oomoogoo00004Woo00<007ooOol017oo00<007ooOol01goo000KOol01@00Oomoogoo00004Goo
00<007ooOol00Woo00<007ooOol047oo00<007ooOol017oo00<007ooOol03Woo00<007ooOol01Goo
00<007ooOol047oo00D007ooOomoo`00019oo`03001oogoo00Aoo`03001oogoo00moo`03001oogoo
00=oo`03001oogoo015oo`03001oogoo009oo`03001oogoo00moo`03001oogoo00Eoo`03001oogoo
011oo`05001oogooOol0000BOol00`00Oomoo`04Ool00`00Oomoo`07Ool001]oo`05001oogooOol0
000AOol00`00Oomoo`02Ool00`00Oomoo`0@Ool00`00Oomoo`04Ool00`00Oomoo`0>Ool00`00Oomo
o`05Ool00`00Oomoo`0@Ool01@00Oomoogoo00004Woo00<007ooOol017oo00<007ooOol03goo00<0
07ooOol00goo00<007ooOol04Goo00<007ooOol00Woo00<007ooOol03goo00<007ooOol01Goo00<0
07ooOol047oo00D007ooOomoo`00019oo`03001oogoo00Aoo`03001oogoo00Moo`006goo00D007oo
Oomoo`00015oo`05001oogooOol0000COol00`00Oomoo`04Ool00`00Oomoo`0>Ool00`00Oomoo`05
Ool00`00Oomoo`0@Ool01@00Oomoogoo00004Woo00<007ooOol017oo00<007ooOol03goo00<007oo
Ool00goo00<007ooOol04Goo00<007ooOol00Woo00<007ooOol03goo00<007ooOol01Goo00<007oo
Ool047oo00D007ooOomoo`00019oo`03001oogoo00Aoo`03001oogoo00Moo`006goo00D007ooOomo
o`00015oo`05001oogooOol0000DOol00`00Oomoo`03Ool00`00Oomoo`0>Ool00`00Oomoo`05Ool0
0`00Oomoo`0@Ool01@00Oomoogoo00004Woo00<007ooOol017oo00<007ooOol047oo00<007ooOol0
0Woo00<007ooOol04Goo00<007ooOol00Woo00<007ooOol03goo00<007ooOol01Goo00<007ooOol0
47oo00D007ooOomoo`00019oo`03001oogoo00Aoo`03001oogoo00Moo`006goo0P000Woo00<007oo
Ool03goo00D007ooOomoo`0001Aoo`03001oogoo00=oo`03001oogoo00ioo`03001oogoo00Aoo`03
001oogoo015oo`04001oogoo000COol00`00Oomoo`04Ool00`00Oomoo`0@Ool01@00Oomoogoo0000
57oo00<007ooOol00Woo00<007ooOol03goo00<007ooOol01Goo00<007ooOol047oo00@007ooOol0
01=oo`03001oogoo00Aoo`03001oogoo00Moo`006goo00D007ooOomoo`00019oo`04001oogoo000D
Ool00`00Oomoo`03Ool00`00Oomoo`0>Ool00`00Oomoo`04Ool00`00Oomoo`0AOol01000Oomoo`00
4goo00<007ooOol017oo00<007ooOol047oo00D007ooOomoo`0001Aoo`03001oogoo009oo`03001o
ogoo00moo`03001oogoo00Eoo`03001oogoo011oo`04001oogoo000COol00`00Oomoo`04Ool00`00
Oomoo`07Ool001]oo`05001oogooOol0000BOol01000Oomoo`0057oo00<007ooOol00goo00<007oo
Ool03Woo00<007ooOol017oo00<007ooOol04Woo00<007oo00004goo00<007ooOol017oo00<007oo
Ool047oo00D007ooOomoo`0001Aoo`03001oogoo009oo`03001oogoo00moo`03001oogoo00Aoo`03
001oogoo015oo`04001oogoo000COol00`00Oomoo`04Ool00`00Oomoo`07Ool001]oo`05001oogoo
Ool0000BOol01000Oomoo`0057oo00<007ooOol00Woo00<007ooOol047oo00<007ooOol00goo00<0
07ooOol04Woo00<007oo00004goo00<007ooOol017oo00<007ooOol047oo00D007ooOomoo`0001Ao
o`03001oogoo009oo`03001oogoo00moo`03001oogoo00Aoo`03001oogoo019oo`03001oo`0001=o
o`03001oogoo00Aoo`03001oogoo00Moo`006goo00D007ooOomoo`00019oo`04001oogoo000DOol0
0`00Oomoo`02Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool00`00Oomoo`0BOol00`00Ool0000COol0
0`00Oomoo`04Ool00`00Oomoo`0@Ool01@00Oomoogoo000057oo00<007ooOol00Woo00<007ooOol0
47oo00<007ooOol00goo00<007ooOol04Woo00<007oo000057oo00<007ooOol00goo00<007ooOol0
1goo000KOol01@00Oomoogoo00004Woo00@007ooOol001Aoo`03001oogoo009oo`03001oogoo011o
o`03001oogoo00=oo`03001oogoo019oo`03001oo`0001=oo`03001oogoo00Aoo`03001oogoo011o
o`05001oogooOol0000DOol00`00Oomoo`02Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool00`00Oomo
o`0BOol2000EOol00`00Oomoo`03Ool00`00Oomoo`07Ool001]oo`05001oogooOol0000BOol00`00
Ool0000EOol00`00Oomoo`02Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool00`00Oomoo`0BOol2000D
Ool00`00Oomoo`04Ool00`00Oomoo`0@Ool01@00Oomoogoo00005Goo00D007ooOomoo`00019oo`03
001oogoo00=oo`03001oogoo019oo`8001Eoo`03001oogoo00=oo`03001oogoo00Moo`006goo00D0
07ooOomoo`00019oo`03001oo`0001Eoo`03001oogoo009oo`03001oogoo011oo`03001oogoo00=o
o`03001oogoo02Qoo`03001oogoo00Aoo`03001oogoo011oo`05001oogooOol0000EOol01000Oomo
o`004goo00<007ooOol00goo00<007ooOol0:Goo00<007ooOol00Woo00<007ooOol027oo000KOol2
00000goo001oo`0COol2000EOol00`00Oomoo`02Ool00`00Oomoo`0@Ool00`00Oomoo`03Ool00`00
Oomoo`0XOol00`00Oomoo`04Ool00`00Oomoo`0AOol01000Oomoo`005Goo00@007ooOol001=oo`03
001oogoo00=oo`03001oogoo02Uoo`03001oogoo009oo`03001oogoo00Qoo`006goo00@007ooOol0
01Aoo`8001Eoo`03001oogoo009oo`03001oogoo011oo`03001oogoo00=oo`03001oogoo02Qoo`03
001oogoo00=oo`03001oogoo019oo`04001oogoo000EOol01000Oomoo`004goo00<007ooOol00goo
00<007ooOol0:Goo00<007ooOol00Woo00<007ooOol027oo000KOol01000Oomoo`00:goo00<007oo
Ool00Woo00<007ooOol047oo00<007ooOol00goo00<007ooOol0:Goo00<007ooOol00Woo00<007oo
Ool04Woo00<007oo00005Woo00@007ooOol001=oo`03001oogoo00=oo`03001oogoo02Uoo`03001o
ogoo009oo`03001oogoo00Qoo`006goo00@007ooOol002aoo`05001oogooOol0000COol00`00Oomo
o`02Ool00`00Oomoo`0YOol00`00Oomoo`02Ool00`00Oomoo`0BOol00`00Ool0000FOol01000Ool0
00004goo00<007ooOol00goo00<007ooOol0:Goo00<007ooOol00Woo00<007ooOol027oo000KOol0
1000Oomoo`00;7oo00D007ooOomoo`0001=oo`03001oogoo009oo`03001oogoo02Uoo`03001oogoo
009oo`03001oogoo019oo`03001oo`0001Moo`8001Aoo`03001oogoo00=oo`03001oogoo02Uoo`03
001oogoo009oo`03001oogoo00Qoo`006goo00@007ooOol002aoo`05001oogooOol0000COol01@00
Oomoogoo0000;7oo00<007ooOol00Woo00<007ooOol04goo0P005goo0P0057oo00<007ooOol00goo
00<007ooOol0:Goo00<007ooOol00Woo00<007ooOol027oo000KOol01000Oomoo`00;7oo00@007oo
Ool001Aoo`05001oogooOol0000/Ool00`00Oomoo`02Ool00`00Oomoo`0COol00`00Oomoo`0/Ool0
0`00Oomoo`03Ool00`00Oomoo`0YOol00`00Oomoo`02Ool00`00Oomoo`08Ool001]oo`04001oogoo
000/Ool01000Oomoo`0057oo00D007ooOomoo`0002aoo`03001oogoo009oo`03001oogoo049oo`03
001oogoo00=oo`03001oogoo02Uoo`03001oogoo009oo`03001oogoo00Qoo`006goo0`00;Goo00@0
07ooOol001Aoo`05001oogooOol0000/Ool00`00Oomoo`02Ool00`00Oomoo`12Ool00`00Oomoo`03
Ool00`00Oomoo`0YOol00`00Oomoo`02Ool00`00Oomoo`08Ool001]oo`03001oo`0002ioo`03001o
o`0001Aoo`05001oogooOol0000]Ool01@00Oomoogoo0000A7oo00<007ooOol00goo00<007ooOol0
:Woo00@007ooOol000]oo`006goo00<007oo0000;Woo00<007oo000057oo00D007ooOomoo`0002eo
o`05001oogooOol00014Ool00`00Oomoo`02Ool00`00Oomoo`0[Ool01000Oomoo`002goo000KOol0
0`00Ool0000^Ool2000EOol01000Oomoo`00;Woo00D007ooOomoo`0004Aoo`03001oogoo009oo`03
001oogoo02]oo`04001oogoo000;Ool001]oo`03001oo`0002ioo`8001Eoo`04001oogoo000^Ool0
1@00Oomoogoo0000A7oo00<007ooOol00Woo00<007ooOol0:goo00@007ooOol000]oo`006goo00<0
07oo0000AGoo00@007ooOol002ioo`05001oogooOol00014Ool00`00Oomoo`02Ool00`00Oomoo`0[
Ool01000Oomoo`002goo000KOol00`00Ool00016Ool00`00Ool0000^Ool01@00Oomoogoo0000AGoo
00D007ooOomoo`0002ioo`03001oo`0000]oo`006goo00<007oo0000AWoo00<007oo0000;Woo00@0
07ooOol004Ioo`05001oogooOol0000^Ool00`00Ool0000;Ool001]oo`<004Ioo`03001oo`0002io
o`04001oogoo0016Ool01000Oomoo`00;goo0`002goo000KOol00`00Ool00016Ool00`00Ool0000^
Ool01000Oomoo`00AWoo00@007ooOol002moo`8000aoo`006goo00<007oo0000Agoo00<007ooOol0
;Goo00@007ooOol004Ioo`04001oogoo000_Ool2000<Ool001]oo`8007Uoo`03001oo`0004Moo`03
001oo`0003eoo`006goo0P00NGoo00<007oo0000Agoo00<007oo0000?Goo000;Ool00`00Oomoo`02
Ool01000Oomoogoo0`0017oo0P00NGoo0`00Agoo0`00?Goo000:Ool00`00Ool00007Ool00`00Oomo
o`04Ool2001jOol00`00Oomoo`16Ool2000nOol000Yoo`03001oo`0000Qoo`03001oogoo00=oo`80
0?moo`Aoo`002Woo00<007oo000027oo00<007ooOol00goo00<007ooOol0ogoo0goo000:Ool00`00
Ool00007Ool00`00Ool00004Ool00`00Oomoo`3oOol3Ool000]oo`03001oogoo00Moo`03001oogoo
00=oo`03001oogoo0?moo`=oo`006goo00<007ooOol0ogoo0goo003oOolQOol00?moob5oo`00ogoo
8Goo003oOolQOol00?moob5oo`00ogoo8Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-4.31458, -0.22593, \
0.157891, 0.0025538}},
  CellTags->{"Simulation", "i:2"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[50]=",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Creating MEX-Files", "Subsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Creating MEX-Files", "i:3"}],

Cell["\<\
It may be desireable to use the system model in an external program. TSi \
Dynamics provides functions to create C-Code which compiles as a MEX-File for \
use as an S-function in SIMULINK. An S-function may have inputs, outputs so \
that it can be interconnected with other subsystems within SIMULINK and it \
can have parameters which can be defined from within SIMULINK. In the \
following example, we define the joint torques as inputs and the (y,z) \
position of mass 2 as the outputs. Parameters include the system two masses, \
the two lengths and the gravitational constant.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Creating MEX-Files", "i:3"}],

Cell["\<\
We can use the TSi Dynamics function EndEffector to define the functions.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Creating MEX-Files", "i:3"}],

Cell[CellGroupData[{

Cell["\<\
ChainLst={{1,1},{2,2}};
TerminalNode=3;
Xout=EndEffector[ChainLst,TerminalNode,BodyLst,X];
yout={Xout[[2,4]],Xout[[3,4]]}\
\>", "Input",
  CellLabel->"In[51]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Creating MEX-Files", "i:3"}],

Cell[BoxData[
    \({l1\ Sin[a1x] - 
        l2\ \((\(-Cos[a2x]\)\ Sin[a1x] - Cos[a1x]\ Sin[a2x])\), \(-l1\)\ Cos[
            a1x] - l2\ \((Cos[a1x]\ Cos[a2x] - 
              Sin[a1x]\ Sin[a2x])\)}\)], "Output",
  CellLabel->"Out[54]=",
  CellTags->{"Creating MEX-Files", "i:3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Inputs = Q;\nOutputs = yout;\nMEXFilename = \"dbl_pend.c\";\n\
paramvec={m1,l1,m2,l2,gc};\nPassedParams = \
{\"X0\",\"m1\",\"l1\",\"m2\",\"l2\",\"gc\"};\nPassedParamsDimensions = \
{{2*Length[p],1},{1,1},{1,1},{1,1},{1,1},{1,1}};\n",
  StyleBox["CreateModelMEX",
    PageWidth->Infinity,
    AspectRatioFixed->True,
    FontFamily->"Courier New"],
  "[p,q,Inputs,Outputs,PassedParams,PassedParamsDimensions,\n               \
V,Cp,Fp,M,MEXFilename];"
}], "Input",
  CellLabel->"In[55]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Creating MEX-Files", "i:3"}],

Cell[BoxData[
    \("  *** MEXTools successfully loaded ***"\)], "Print",
  CellTags->{"Creating MEX-Files", "i:3"}],

Cell[BoxData[
    \("...Generating Header Code"\)], "Print",
  CellTags->{"Creating MEX-Files", "i:3"}],

Cell[BoxData[
    \("...Generating Initial Condition Function Code"\)], "Print",
  CellTags->{"Creating MEX-Files", "i:3"}],

Cell[BoxData[
    \("...Generating State Derivative Function Code"\)], "Print",
  CellTags->{"Creating MEX-Files", "i:3"}],

Cell[BoxData[
    \("...Collecting all function terms"\)], "Print",
  CellTags->{"Creating MEX-Files", "i:3"}],

Cell[BoxData[
    \("...Generating temp variable declarations"\)], "Print",
  CellTags->{"Creating MEX-Files", "i:3"}],

Cell[BoxData[
    \("...Converting Expressions to C form"\)], "Print",
  CellTags->{"Creating MEX-Files", "i:3"}],

Cell[BoxData[
    \("...Generating Output Function Code"\)], "Print",
  CellTags->{"Creating MEX-Files", "i:3"}],

Cell[BoxData[
    \("MEX File created with name: dbl_pend.c"\)], "Print",
  CellTags->{"Creating MEX-Files", "i:3"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Compiling & Using MEX Files", "Subsection",
  CellTags->"Creating MEX-Files"],

Cell["\<\
Detailed information on compiling and using MEX files with MATLAB/SIMULINK \
can be found in the appropriate MATLAB references. CreateModelMEX (and also \
CreateControllerMEX) assemble C source code that needs to be compiled. During \
the compilation process the compiled code will be linked with additional code \
segments and libraries provided with ProPac or MATLAB or your compiler. It is \
necessary that this code be available at the time of compilation. The easiest \
way to proceed is to perform the compilation from within MATLAB using scripts \
provided with MATLAB (either cmex with MATLAB 4 or mex with MATLAB 5). This \
should automatically define the locations of all required MATLAB or compiler \
code segments. In addition to the file created by ProPac (for example: \
dbl_pend.c) you will need the files linsolv.c, f2c.h and trigfun.h - all \
provided with ProPac. 
\tOne way to compile dbl_pend.c  is to place the files dbl_pend.c, linsolv.c, \
f2c.h and trigfun.h in a common directory, for example C:\\DoublePend. Then \
in the MATLAB command window set the current directory to C:\\DoublePend to \
insure that the four required files are in the search path:
\tcd C:\\DoublePend
then use the command
\tmex dbl_pend.c linsolv.c
in MATLAB 5, or
\t!cmex dbl_pend.c linsolv.c
in MATLAB 4.2.
\tIf you have followed the MATLAB installation instructions as appropriate \
for your compiler this should work fine. Otherwise, you can reinstall MATLAB \
5 and follow the instructions (which setsup the appropriate paths in mex), or \
in MATLAB 4.2 you can edit cmex as described therein.\
\>", "Text",
  TextJustification->1,
  CellTags->"Creating MEX-Files"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Building More Complex Models"], "Section",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Introductory Remarks", "Subsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True],

Cell["\<\
TSi Dynamics provides several routes to developing models. The most direct is \
to use the functions CreateModel or CreateModelSpecial. These two functions \
work essentially the same way but produce models in slightly different form. \
The former is almost always preferable for creating simulations. One example \
of its use has already been given above for creating a model of the double \
pendulum. The following more elaborate examples illustrate some other \
functions in TSi Dynamics.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Partial Suspension System", "Subsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell["\<\
We consider a simple split axle suspension in planar motion. The system \
consists of a chassis, two axles, two tires, two springs - each connecting \
nodes on one axle and the chassis, and two torsional dampers. The modeling \
process begins in the standard way with joint and body definitions. The \
coordinate system is chosen with z down and motion takes place in the y-z \
plane (y points to the right).
Joint Data\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell[CellGroupData[{

Cell["\<\
(* Joint 1 - planar motion *)
r1={3};
q1={theta1,y,z};p1={w1,vy,vz};
H1={{1,0,0},{0,0,0},{0,0,0},{0,0,0},{0,1,0},{0,0,1}};
(* Joint 2 - suspension *)
r2={1};
q2={theta2};p2={w2};
H2={{1},{0},{0},{0},{0},{0}};
(* Joint 3 - suspension *)
r3={1};
H3={{1},{0},{0},{0},{0},{0}};
q3={theta3};p3={w3};

JointLst={{r1,H1,q1,p1},{r2,H2,q2,p2},{r3,H3,q3,p3}};
{V,X,H}=Joints[JointLst];\
\>", "Input",
  CellLabel->"In[62]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell[BoxData[
    \("Computing joint 1 kinematics"\)], "Print",
  CellTags->{"Suspension", "i:4"}],

Cell[BoxData[
    \("Computing joint 2 kinematics"\)], "Print",
  CellTags->{"Suspension", "i:4"}],

Cell[BoxData[
    \("Computing joint 3 kinematics"\)], "Print",
  CellTags->{"Suspension", "i:4"}]
}, Open  ]],

Cell["Body Data", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell["\<\
(* Body 1 - Chassis *)
cm1={0,0,0};
out1={{2,{0,b/2,a/2}},{3,{0,-b/2,a/2}},{6,{0,b/2+a/2,-a/2}},{7,{0,-b/2-a/2,-a/\
2}}};
I1=DiagonalMatrix[{Ixx,Iyy,Izz}];

(* Body 2 - Wheel & Axle *)
cm2={0,d,0};
out2={{4,{0,d,R}},{8,{0,Sqrt[2]*a,0}}};
I2=DiagonalMatrix[{Wxx,Wyy,Wzz}];

(* Body 3 - Wheel & Axle *)
cm3={0,-d,0};
out3={{5,{0,-d,R}},{9,{0,-Sqrt[2]*a,0}}};
I3=DiagonalMatrix[{Wxx,Wyy,Wzz}];

BodyLst={{cm1,out1,m1,I1},{cm2,out2,mw,I2},{cm3,out3,mw,I3}};
\
\>", "Input",
  CellLabel->"In[76]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell["\<\
System Structure
Notice that this system has a tree structure with two chains.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell["TreeLst={{{1,1},{2,2}},{{1,1},{3,3}}};", "Input",
  CellLabel->"In[89]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell["\<\
Potential Energy Constructions
The potential energy comes from two sources in addition to the gravitational \
potential: (i) the tires, and (ii) the springs. The tires are leaves of the \
tree and they react with the space frame. Computing the potential energy of \
the tires illustrates the use of the function LeafPotential.
It is assumed that each tire potential energy function is defined in terms of \
the space coordinates of the tire contact point (the tire outboard node). In \
this example, we suppose that only the vertical displacements are \
significant.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell["\<\
(* Define Tire PE in terms of Space Coordinates *)

yy={{x2,y2,z2},{x3,y3,z3}};
Pot=(k/2)*(z2-z20)^2+(k/2)*(z3-z30)^2;\
\>", "Input",
  CellLabel->"In[90]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell["\<\
Note that z20 and z30 may be specified as externally defined functions of \
time to simulate riding over rough terrain. LeafPotential replaces the \
absolute coordinates by the generalized coordinates.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell["\<\
(* Obtain Tire PE in terms of generalized Coordinates *)

TirePE=LeafPotential[BodyLst,TreeLst,X,H,Pot,yy];\
\>", "Input",
  CellLabel->"In[93]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell[CellGroupData[{

Cell["TirePE", "Input",
  CellLabel->"In[95]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell[BoxData[
    \(1\/8\ k\ \((\((2\ z - 2\ z20 + a\ Cos[theta1] + 
                2\ R\ Cos[theta1 + theta2] + b\ Sin[theta1] + 
                2\ d\ Sin[theta1 + theta2])\)^2 + \((2\ z - 2\ z30 + 
                a\ Cos[theta1] + 2\ R\ Cos[theta1 + theta3] - 
                b\ Sin[theta1] - 
                2\ d\ Sin[theta1 + theta3])\)^2)\)\)], "Output",
  CellLabel->"Out[95]=",
  CellTags->{"Suspension", "i:4"}]
}, Open  ]],

Cell["\<\
The spring potential energy function SpringPotential is a specialized \
function for springs connecting two nodes in the system. It is assumed that \
the potential energy is a function of the length of the spring. Because only \
one variable is involved it is convenient to specify the potential energy as \
a function rather than as an expression in which the variables must be \
separately identified. SpringPotential constructs the potential energy \
function for the spring in terms of the generalized system coordinates.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell["\<\
SpringPot[x_]:=(kdel/2)*(x-ls)^2
q=Join[q1,q2,q3];
SpringPE1=SpringPotential[6,8,SpringPot,TreeLst,BodyLst,X,q];
SpringPE2=SpringPotential[7,9,SpringPot,TreeLst,BodyLst,X,q];

PE=TirePE+SpringPE1+SpringPE2;
\
\>", "Input",
  CellLabel->"In[96]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell[CellGroupData[{

Cell["SpringPE1", "Input",
  CellLabel->"In[101]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell[BoxData[
    \(1\/2\ kdel\ \((\(-ls\) + \@Abs[\(13\ a\^2\)\/4 - \@2\ a\^2\ Cos[theta2] \
+ 2\ \@2\ a\^2\ Sin[theta2]])\)\^2\)], "Output",
  CellLabel->"Out[101]=",
  CellTags->{"Suspension", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["SpringPE2", "Input",
  CellLabel->"In[102]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell[BoxData[
    \(1\/2\ kdel\ \((\(-ls\) + \@Abs[\(13\ a\^2\)\/4 - \@2\ a\^2\ Cos[theta3] \
- 2\ \@2\ a\^2\ Sin[theta3]])\)\^2\)], "Output",
  CellLabel->"Out[102]=",
  CellTags->{"Suspension", "i:4"}]
}, Open  ]],

Cell["\<\
Generalized Force
The only generalized forces acting are due to the dampers. We assume that the \
forces due to the torsional dampers are proportional to the relative angular \
velocities of the axles with respect to the chassis. As an alternative one \
could place a linear damper between two nodes and use the function \
DamperForce to compute the generalized force.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell["Q={0,0,0,-c*w2,-c*w3};", "Input",
  CellLabel->"In[103]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell["\<\
Gravity
Since, we have chosen the z-axis to point down, we change the sign of the \
gravitational acceleration\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell["g=-gc;", "Input",
  CellLabel->"In[104]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell["\<\
Obtain Equations of Motion
Notice that since the joint kinematic data V, X, and H has already been \
computed, we include this data in the argument list of CreateModel to avoid \
recomputing it.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell[CellGroupData[{

Cell["\<\
{V,X,H,M,Cm,F,pp,qq}=CreateModel[JointLst,BodyLst,TreeLst,g,PE,Q,V,X,H];\
\>", "Input",
  CellLabel->"In[105]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell[BoxData[
    \("Computing Potential Functions"\)], "Print",
  CellTags->{"Suspension", "i:4"}],

Cell[BoxData[
    \("Computing Inertia Matrix"\)], "Print",
  CellTags->{"Suspension", "i:4"}],

Cell[BoxData[
    \("Computing Poincare Function"\)], "Print",
  CellTags->{"Suspension", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["M", "Input",
  CellLabel->"In[106]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell[BoxData[
    \({{Ixx + 2\ d\^2\ mw + 2\ Wxx + 
          d\ mw\ \((1\/2\ b\ Cos[theta2] + 1\/2\ a\ Sin[theta2])\) + 
          mw\ \((\(-\(1\/2\)\)\ a\ Cos[theta2] + 1\/2\ b\ Sin[theta2])\)\^2 + \
\((1\/2\ b\ Cos[theta2] + 1\/2\ a\ Sin[theta2])\)\ \((d\ mw + 
                mw\ \((1\/2\ b\ Cos[theta2] + 1\/2\ a\ Sin[theta2])\))\) - 
          d\ mw\ \((\(-\(1\/2\)\)\ b\ Cos[theta3] + 1\/2\ a\ Sin[theta3])\) + 
          mw\ \((\(-\(1\/2\)\)\ a\ Cos[theta3] - 1\/2\ b\ Sin[theta3])\)\^2 + \
\((\(-\(1\/2\)\)\ b\ Cos[theta3] + 1\/2\ a\ Sin[theta3])\)\ \((\(-d\)\ mw + 
                mw\ \((\(-\(1\/2\)\)\ b\ Cos[theta3] + 
                      1\/2\ a\ Sin[theta3])\))\), 
        1\/2\ \((\(-d\)\ mw\ Sin[theta2] - 
                mw\ Sin[
                    theta2]\ \((1\/2\ b\ Cos[theta2] + 
                      1\/2\ a\ Sin[theta2])\) + 
                2\ mw\ Cos[
                    theta2]\ \((\(-\(1\/2\)\)\ a\ Cos[theta2] + 
                      1\/2\ b\ Sin[theta2])\) - 
                Sin[theta2]\ \((d\ mw + 
                      mw\ \((1\/2\ b\ Cos[theta2] + 
                            1\/2\ a\ Sin[theta2])\))\))\) + 
          1\/2\ \((d\ mw\ Sin[theta3] - 
                mw\ Sin[
                    theta3]\ \((\(-\(1\/2\)\)\ b\ Cos[theta3] + 
                      1\/2\ a\ Sin[theta3])\) + 
                2\ mw\ Cos[
                    theta3]\ \((\(-\(1\/2\)\)\ a\ Cos[theta3] - 
                      1\/2\ b\ Sin[theta3])\) - 
                Sin[theta3]\ \((\(-d\)\ mw + 
                      mw\ \((\(-\(1\/2\)\)\ b\ Cos[theta3] + 
                            1\/2\ a\ Sin[theta3])\))\))\), 
        1\/2\ \((d\ mw\ Cos[theta2] + 
                mw\ Cos[
                    theta2]\ \((1\/2\ b\ Cos[theta2] + 
                      1\/2\ a\ Sin[theta2])\) + 
                2\ mw\ Sin[
                    theta2]\ \((\(-\(1\/2\)\)\ a\ Cos[theta2] + 
                      1\/2\ b\ Sin[theta2])\) + 
                Cos[theta2]\ \((d\ mw + 
                      mw\ \((1\/2\ b\ Cos[theta2] + 
                            1\/2\ a\ Sin[theta2])\))\))\) + 
          1\/2\ \((\(-d\)\ mw\ Cos[theta3] + 
                mw\ Cos[
                    theta3]\ \((\(-\(1\/2\)\)\ b\ Cos[theta3] + 
                      1\/2\ a\ Sin[theta3])\) + 
                2\ mw\ Sin[
                    theta3]\ \((\(-\(1\/2\)\)\ a\ Cos[theta3] - 
                      1\/2\ b\ Sin[theta3])\) + 
                Cos[theta3]\ \((\(-d\)\ mw + 
                      mw\ \((\(-\(1\/2\)\)\ b\ Cos[theta3] + 
                            1\/2\ a\ Sin[theta3])\))\))\), 
        d\^2\ mw + Wxx + 
          d\ mw\ \((1\/2\ b\ Cos[theta2] + 1\/2\ a\ Sin[theta2])\), 
        d\^2\ mw + Wxx - 
          d\ mw\ \((\(-\(1\/2\)\)\ b\ Cos[theta3] + 
                1\/2\ a\ Sin[theta3])\)}, {1\/2\ \((\(-d\)\ mw\ Sin[theta2] - 
                mw\ Sin[
                    theta2]\ \((1\/2\ b\ Cos[theta2] + 
                      1\/2\ a\ Sin[theta2])\) + 
                2\ mw\ Cos[
                    theta2]\ \((\(-\(1\/2\)\)\ a\ Cos[theta2] + 
                      1\/2\ b\ Sin[theta2])\) - 
                Sin[theta2]\ \((d\ mw + 
                      mw\ \((1\/2\ b\ Cos[theta2] + 
                            1\/2\ a\ Sin[theta2])\))\))\) + 
          1\/2\ \((d\ mw\ Sin[theta3] - 
                mw\ Sin[
                    theta3]\ \((\(-\(1\/2\)\)\ b\ Cos[theta3] + 
                      1\/2\ a\ Sin[theta3])\) + 
                2\ mw\ Cos[
                    theta3]\ \((\(-\(1\/2\)\)\ a\ Cos[theta3] - 
                      1\/2\ b\ Sin[theta3])\) - 
                Sin[theta3]\ \((\(-d\)\ mw + 
                      mw\ \((\(-\(1\/2\)\)\ b\ Cos[theta3] + 
                            1\/2\ a\ Sin[theta3])\))\))\), 
        m1 + mw\ Cos[theta2]\^2 + mw\ Cos[theta3]\^2 + mw\ Sin[theta2]\^2 + 
          mw\ Sin[theta3]\^2, 0, \(-d\)\ mw\ Sin[theta2], 
        d\ mw\ Sin[
            theta3]}, {1\/2\ \((d\ mw\ Cos[theta2] + 
                mw\ Cos[
                    theta2]\ \((1\/2\ b\ Cos[theta2] + 
                      1\/2\ a\ Sin[theta2])\) + 
                2\ mw\ Sin[
                    theta2]\ \((\(-\(1\/2\)\)\ a\ Cos[theta2] + 
                      1\/2\ b\ Sin[theta2])\) + 
                Cos[theta2]\ \((d\ mw + 
                      mw\ \((1\/2\ b\ Cos[theta2] + 
                            1\/2\ a\ Sin[theta2])\))\))\) + 
          1\/2\ \((\(-d\)\ mw\ Cos[theta3] + 
                mw\ Cos[
                    theta3]\ \((\(-\(1\/2\)\)\ b\ Cos[theta3] + 
                      1\/2\ a\ Sin[theta3])\) + 
                2\ mw\ Sin[
                    theta3]\ \((\(-\(1\/2\)\)\ a\ Cos[theta3] - 
                      1\/2\ b\ Sin[theta3])\) + 
                Cos[theta3]\ \((\(-d\)\ mw + 
                      mw\ \((\(-\(1\/2\)\)\ b\ Cos[theta3] + 
                            1\/2\ a\ Sin[theta3])\))\))\), 0, 
        m1 + mw\ Cos[theta2]\^2 + mw\ Cos[theta3]\^2 + mw\ Sin[theta2]\^2 + 
          mw\ Sin[theta3]\^2, 
        d\ mw\ Cos[theta2], \(-d\)\ mw\ Cos[theta3]}, {d\^2\ mw + Wxx + 
          d\ mw\ \((1\/2\ b\ Cos[theta2] + 
                1\/2\ a\ Sin[theta2])\), \(-d\)\ mw\ Sin[theta2], 
        d\ mw\ Cos[theta2], d\^2\ mw + Wxx, 
        0}, {d\^2\ mw + Wxx - 
          d\ mw\ \((\(-\(1\/2\)\)\ b\ Cos[theta3] + 1\/2\ a\ Sin[theta3])\), 
        d\ mw\ Sin[theta3], \(-d\)\ mw\ Cos[theta3], 0, 
        d\^2\ mw + Wxx}}\)], "Output",
  CellLabel->"Out[106]=",
  CellTags->{"Suspension", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Simplify[Cm.pp]", "Input",
  CellLabel->"In[107]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell[BoxData[
    \({1\/2\ mw\ \((2\ a\ vz\ w1 + 
            d\ \((2\ vy\ w1 + a\ w2\ \((2\ w1 + w2)\))\)\ Cos[theta2] - 
            d\ \((2\ vy\ w1 + 2\ a\ w1\ w3 + a\ w3\^2)\)\ Cos[theta3] + 
            2\ d\ vz\ w1\ Sin[theta2] - 2\ b\ d\ w1\ w2\ Sin[theta2] - 
            b\ d\ w2\^2\ Sin[theta2] - 2\ d\ vz\ w1\ Sin[theta3] - 
            2\ b\ d\ w1\ w3\ Sin[theta3] - 
            b\ d\ w3\^2\ Sin[theta3])\), \(-\((m1 + 2\ mw)\)\)\ vz\ w1 - 
        d\ mw\ \((w1 + w2)\)\^2\ Cos[theta2] + 
        d\ mw\ \((w1 + w3)\)\^2\ Cos[theta3], 
      w1\ \((m1\ vy + 2\ mw\ vy - a\ mw\ w1)\) - 
        d\ mw\ \((w1 + w2)\)\^2\ Sin[theta2] + 
        d\ mw\ \((w1 + w3)\)\^2\ Sin[theta3], 
      1\/2\ d\ mw\ w1\ \((\((2\ vy - a\ w1)\)\ Cos[
                theta2] + \((2\ vz + b\ w1)\)\ Sin[theta2])\), 
      1\/2\ d\ mw\ w1\ \((\((\(-2\)\ vy + a\ w1)\)\ Cos[
                theta3] + \((\(-2\)\ vz + b\ w1)\)\ Sin[
                theta3])\)}\)], "Output",
  CellLabel->"Out[107]=",
  CellTags->{"Suspension", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["F", "Input",
  CellLabel->"In[108]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Suspension", "i:4"}],

Cell[BoxData[
    \({\(-gc\)\ \((d\ mw\ Cos[theta1 + theta2] - 
              d\ mw\ Cos[theta1 + theta3] - a\ mw\ Sin[theta1])\) + 
        1\/8\ k\ \((2\ \((2\ z - 2\ z20 + a\ Cos[theta1] + 
                    2\ R\ Cos[theta1 + theta2] + b\ Sin[theta1] + 
                    2\ d\ Sin[theta1 + theta2])\)\ \((b\ Cos[theta1] + 
                    2\ d\ Cos[theta1 + theta2] - a\ Sin[theta1] - 
                    2\ R\ Sin[theta1 + theta2])\) + 
              2\ \((2\ z - 2\ z30 + a\ Cos[theta1] + 
                    2\ R\ Cos[theta1 + theta3] - b\ Sin[theta1] - 
                    2\ d\ Sin[theta1 + theta3])\)\ \((\(-b\)\ Cos[theta1] - 
                    2\ d\ Cos[theta1 + theta3] - a\ Sin[theta1] - 
                    2\ R\ Sin[theta1 + theta3])\))\), 
      Sin[theta1]\ \((\(-gc\)\ \((m1 + 2\ mw)\) + 
            1\/8\ k\ \((4\ \((2\ z - 2\ z20 + a\ Cos[theta1] + 
                        2\ R\ Cos[theta1 + theta2] + b\ Sin[theta1] + 
                        2\ d\ Sin[theta1 + theta2])\) + 
                  4\ \((2\ z - 2\ z30 + a\ Cos[theta1] + 
                        2\ R\ Cos[theta1 + theta3] - b\ Sin[theta1] - 
                        2\ d\ Sin[theta1 + theta3])\))\))\), 
      Cos[theta1]\ \((\(-gc\)\ \((m1 + 2\ mw)\) + 
            1\/8\ k\ \((4\ \((2\ z - 2\ z20 + a\ Cos[theta1] + 
                        2\ R\ Cos[theta1 + theta2] + b\ Sin[theta1] + 
                        2\ d\ Sin[theta1 + theta2])\) + 
                  4\ \((2\ z - 2\ z30 + a\ Cos[theta1] + 
                        2\ R\ Cos[theta1 + theta3] - b\ Sin[theta1] - 
                        2\ d\ Sin[theta1 + theta3])\))\))\), 
      c\ w2 - d\ gc\ mw\ Cos[theta1 + theta2] + 
        1\/4\ k\ \((2\ z - 2\ z20 + a\ Cos[theta1] + 
              2\ R\ Cos[theta1 + theta2] + b\ Sin[theta1] + 
              2\ d\ Sin[theta1 + theta2])\)\ \((2\ d\ Cos[theta1 + theta2] - 
              2\ R\ Sin[
                  theta1 + 
                    theta2])\) + \((kdel\ \((\(-ls\) + \@Abs[\(13\ a\^2\)\/4 \
- \@2\ a\^2\ Cos[theta2] + 2\ \@2\ a\^2\ Sin[theta2]])\)\ \((2\ \@2\ a\^2\ \
Cos[theta2] + \@2\ a\^2\ Sin[
                      theta2])\)\ \
\((\(-Calculus`DiracDelta`UnitStep[\(-\(\(13\ a\^2\)\/4\)\) + \@2\ a\^2\ Cos[
                            theta2] - 2\ \@2\ a\^2\ Sin[theta2]]\) + 
                  Calculus`DiracDelta`UnitStep[\(13\ a\^2\)\/4 - \@2\ a\^2\ \
Cos[theta2] + 2\ \@2\ a\^2\ Sin[
                          theta2]])\))\)/\((2\ \@Abs[\(13\ a\^2\)\/4 - \@2\ a\
\^2\ Cos[theta2] + 2\ \@2\ a\^2\ Sin[theta2]])\), 
      c\ w3 + d\ gc\ mw\ Cos[theta1 + theta3] + 
        1\/4\ k\ \((2\ z - 2\ z30 + a\ Cos[theta1] + 
              2\ R\ Cos[theta1 + theta3] - b\ Sin[theta1] - 
              2\ d\ Sin[theta1 + theta3])\)\ \((\(-2\)\ d\ Cos[
                  theta1 + theta3] - 
              2\ R\ Sin[
                  theta1 + 
                    theta3])\) + \((kdel\ \((\(-ls\) + \@Abs[\(13\ a\^2\)\/4 \
- \@2\ a\^2\ Cos[theta3] - 2\ \@2\ a\^2\ Sin[theta3]])\)\ \((\(-2\)\ \@2\ \
a\^2\ Cos[theta3] + \@2\ a\^2\ Sin[
                      theta3])\)\ \((Calculus`DiracDelta`UnitStep[\(13\ \
a\^2\)\/4 - \@2\ a\^2\ Cos[theta3] - 2\ \@2\ a\^2\ Sin[theta3]] - 
                  Calculus`DiracDelta`UnitStep[\(-\(\(13\ a\^2\)\/4\)\) + \@2\
\ a\^2\ Cos[theta3] + 
                      2\ \@2\ a\^2\ Sin[
                          theta3]])\))\)/\((2\ \@Abs[\(13\ a\^2\)\/4 - \@2\ a\
\^2\ Cos[theta3] - 2\ \@2\ a\^2\ Sin[theta3]])\)}\)], "Output",
  CellLabel->"Out[108]=",
  CellTags->{"Suspension", "i:4"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["A Flexible Two Link Manipulator", "Subsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["\<\
Consider a two link, planar mechanism in which the lower end of link 1 is \
attached to the space frame by a revolute joint and the upper end of link 1 \
and the lower end of link 2 are joined by a second revolute joint. Assume \
that the links have the same mass per unit length, rho, modulus of \
elasticity, El, cross sectional area moments (constant along the length) \
{Ixx,Iyy,Izz}, and the lengths L1 and L2, respectively.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[CellGroupData[{

Cell["Modeling a Flexible Link", "Subsubsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["\<\
There are many approaches to modeling individual flexible elements. One view \
fixes a 'primary body reference frame' in an infinitesimal element at the \
inboard joint. The location of any point in the deformed body are specified \
in this frame. As the body undergoes motion, it is necessary to track the \
location and orientation of the primary body frame as well as the location in \
that frame of any interesting body points. Thus, the number of degrees of \
freedom associated with a free deformable body will be the six degrees of \
freedom associated with the primary frame plus some number of degrees of \
freedom associated with the body deformations. Usually, it is desired to \
characterize body deformations by a finite number of degrees of freedom and \
this is often accomplished by using finite element or (truncated) modal \
expansion methods.      
As an example take one of the links in the two link manipulator. We fix a \
reference frame in the link at its inboard joint. Suppose that the beam lies \
along the z-axis (points upward) with the inboard joint at the bottom. \
Moroever, assume that the link bends only in the y-z plane. Within this frame \
the link deforms as a centelevered beam and we can characterize the beam \
deformations in terms of its modes.  A cantelevered (Euler) beam of length L \
has the characteristic equation
\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tCos[b*L] * Cosh[b*L] = -1
which has a countable set of solutions br, r = 1,2,3...; the first three \
roots are approximately: \
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["bL={0.600*Pi,1.49*Pi,2.50*Pi};", "Input",
  CellLabel->"In[109]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["They define the natural frequencies by the relation", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["w[i_]:=(bL[[i]])^2*(El*Ixx/(rho*L^4))^(1/2);", "Input",
  CellLabel->"In[110]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["Correspondingly, the mode shapes are:", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["\<\
W[i_,z_]:=((Cosh[bL[[i]]*z/L]-Cos[bL[[i]]*z/L])/(Cosh[bL[[i]]]+Cos[bL[[i]]])

              - \
(Sinh[bL[[i]]*z/L]-Sin[bL[[i]]*z/L])/(Sinh[bL[[i]]]+Sin[bL[[i]]]));  \
\>", "Input",
  CellLabel->"In[111]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["\<\
From the above information we can construct, for example, a one-mode model \
for a link of length L. First, the inertia, damping and stiffness matrices \
are:\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["\<\
M={{Ia,0,0,0,-m,0,0},
   {0,Ib,0,m,0,0,a},
   {0,0,Ic,0,0,0,0},
   {0,m,0, m,0,0,b},
   {-m,0,0,0,m,0,0},
   {0,0,0,0,0,m,0},
   {0,a,0,b,0,0,1}};\
\>", "Input",
  CellLabel->"In[112]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["\<\
B=0*IdentityMatrix[7]; 
K=DiagonalMatrix[{0,0,0,0,0,0,(0.600*Pi)^2}]*(El*Ixx/(m*L^3));\
\>", "Input",
  CellLabel->"In[113]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["\<\
where Ia, Ib, Ic are respectively Ixx m L^2/A, Iyy m L^2/A, Izz m L^2/A. Let \
y1 denote the modal coordinate, then the y position of the right end and \
anglular rotation about the x-axis (phiend) under deformation are given by:\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["yend=W[1,L]*y1; phiend=D[W[1,z],z]/.z->L;", "Input",
  CellLabel->"In[115]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["\<\
and the center of mass (which corresponds to the midpoint) is\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["ycom=W[1,L/2]*y1;", "Input",
  CellLabel->"In[116]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["Consequently, we have the matrices Cout and Ccom:", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["\<\
Cout={{0,D[W[1,z],z]/.z->L},
      {0,0},{0,0},
      {0,0},{0,W[1,L]},{L,0}};
Ccom={{0,0},{0,W[1,L/2]},{L,0}};\
\>", "Input",
  CellLabel->"In[117]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["The link body data is then", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[CellGroupData[{

Cell["Link1={N[Ccom],{{2,N[Cout]}},m,{M,B,K},{y11},{v11}}/.L->L1", "Input",
  CellLabel->"In[119]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[BoxData[
    \({{{0, 0}, {0, 0.223912970343545003`}, {L1, 
          0}}, {{2, {{0, 0.904371004615764739`\/L1}, {0, 0}, {0, 0}, {0, 
              0}, {0, 0.658318911122252892`}, {L1, 0}}}}, 
      m, {{{Ia, 0, 0, 0, \(-m\), 0, 0}, {0, Ib, 0, m, 0, 0, a}, {0, 0, Ic, 0, 
            0, 0, 0}, {0, m, 0, m, 0, 0, b}, {\(-m\), 0, 0, 0, m, 0, 0}, {0, 
            0, 0, 0, 0, m, 0}, {0, a, 0, b, 0, 0, 1}}, {{0, 0, 0, 0, 0, 0, 
            0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 
            0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 
            0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 
            0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 
            0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 
            0, \(3.55305758439216878`\ El\ Ixx\)\/\(L1\^3\ m\)}}}, {y11}, \
{v11}}\)], "Output",
  CellLabel->"Out[119]=",
  CellTags->{"Flexible Manipulator", "i:5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Link2={N[Ccom],{{3,N[Cout]}},m,{M,B,K},{y21},{v21}}/.L->L2", "Input",
  CellLabel->"In[120]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[BoxData[
    \({{{0, 0}, {0, 0.223912970343545003`}, {L2, 
          0}}, {{3, {{0, 0.904371004615764739`\/L2}, {0, 0}, {0, 0}, {0, 
              0}, {0, 0.658318911122252892`}, {L2, 0}}}}, 
      m, {{{Ia, 0, 0, 0, \(-m\), 0, 0}, {0, Ib, 0, m, 0, 0, a}, {0, 0, Ic, 0, 
            0, 0, 0}, {0, m, 0, m, 0, 0, b}, {\(-m\), 0, 0, 0, m, 0, 0}, {0, 
            0, 0, 0, 0, m, 0}, {0, a, 0, b, 0, 0, 1}}, {{0, 0, 0, 0, 0, 0, 
            0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 
            0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 
            0, 0, 0}}, {{0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 
            0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0}, {0, 
            0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 
            0, \(3.55305758439216878`\ El\ Ixx\)\/\(L2\^3\ m\)}}}, {y21}, \
{v21}}\)], "Output",
  CellLabel->"Out[120]=",
  CellTags->{"Flexible Manipulator", "i:5"}]
}, Open  ]],

Cell["BodyList={Link1,Link2};", "Input",
  CellLabel->"In[121]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["\<\
r1={1};
H1=Transpose[{{1,0,0,0,0,0}}];
q1={theta1};p1={w1};

r2={1};
H2=Transpose[{{1,0,0,0,0,0}}];
q2={theta2};p2={w2};

JointList={{r1,H1,q1,p1},{r2,H2,q2,p2}};\
\>", "Input",
  CellLabel->"In[122]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["\<\
TreeList={{{1,1},{2,2}}};
PE=0; Q={0,0,0,0};\
\>", "Input",
  CellLabel->"In[129]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[CellGroupData[{

Cell["\<\
{V,X,H,M,Cp,Fp,p,q}=CreateModel[JointList,BodyList,TreeList,g,PE,Q];\
\>", "Input",
  CellLabel->"In[131]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[BoxData[
    \("Computing Joint Kinematics"\)], "Print",
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[BoxData[
    \("Computing joint 1 kinematics"\)], "Print",
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[BoxData[
    \("Computing joint 2 kinematics"\)], "Print",
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[BoxData[
    \("Computing Potential Functions"\)], "Print",
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[BoxData[
    \("Computing Inertia Matrix"\)], "Print",
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[BoxData[
    \("Computing Poincare Function"\)], "Print",
  CellTags->{"Flexible Manipulator", "i:5"}]
}, Open  ]],

Cell["We can examine some of the results:", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[CellGroupData[{

Cell["M", "Input",
  CellLabel->"In[132]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[BoxData[
    \({{2\ Ia + 
          m\ \((\((\(-\(\(0.904371004615764739`\ y11\ Cos[theta2]\)\/L1\)\) - 
                        Sin[theta2])\)\ \((\(-L1\)\ Cos[theta2] - 
                        0.658318911122252892`\ y11\ Sin[
                            theta2])\) + \((0.658318911122252892`\ y11\ Cos[
                            theta2] - 
                        L1\ Sin[theta2])\)\ \((Cos[
                          theta2] - \(0.904371004615764739`\ y11\ Sin[theta2]\
\)\/L1)\))\)^2 - 
          m\ \((\((\(0.904371004615764739`\ y11\ Cos[theta2]\)\/L1 + 
                      Sin[theta2])\)\ \((0.658318911122252892`\ y11\ Cos[
                          theta2] - 
                      L1\ Sin[theta2])\) + \((\(-L1\)\ Cos[theta2] - 
                      0.658318911122252892`\ y11\ Sin[theta2])\)\ \((Cos[
                        theta2] - \(0.904371004615764739`\ y11\ Sin[theta2]\)\
\/L1)\))\) + \((\((\(0.904371004615764739`\ y11\ Cos[theta2]\)\/L1 + 
                      Sin[theta2])\)\ \((0.658318911122252892`\ y11\ Cos[
                          theta2] - 
                      L1\ Sin[theta2])\) + \((\(-L1\)\ Cos[theta2] - 
                      0.658318911122252892`\ y11\ Sin[theta2])\)\ \((Cos[
                        theta2] - \(0.904371004615764739`\ y11\ Sin[theta2]\)\
\/L1)\))\)\ \((\(-m\) + 
                m\ \((\((\(0.904371004615764739`\ y11\ Cos[theta2]\)\/L1 + 
                            Sin[theta2])\)\ \((0.658318911122252892`\ y11\ \
Cos[theta2] - L1\ Sin[theta2])\) + \((\(-L1\)\ Cos[theta2] - 
                            0.658318911122252892`\ y11\ Sin[
                                theta2])\)\ \((Cos[
                              theta2] - \(0.904371004615764739`\ y11\ \
Sin[theta2]\)\/L1)\))\))\), 
        Ia - m\ \((\((\(0.904371004615764739`\ y11\ Cos[theta2]\)\/L1 + 
                      Sin[theta2])\)\ \((0.658318911122252892`\ y11\ Cos[
                          theta2] - 
                      L1\ Sin[theta2])\) + \((\(-L1\)\ Cos[theta2] - 
                      0.658318911122252892`\ y11\ Sin[theta2])\)\ \((Cos[
                        theta2] - \(0.904371004615764739`\ y11\ Sin[theta2]\)\
\/L1)\))\), 
        1\/2\ \((\(0.904371004615764739`\ Ia\)\/L1 - 
              0.658318911122252892`\ m\ \((Cos[
                      theta2] - \(0.904371004615764739`\ y11\ \
Sin[theta2]\)\/L1)\) + 
              1.31663782224450587`\ m\ \((\(-\(\(0.904371004615764739`\ y11\ \
Cos[theta2]\)\/L1\)\) - 
                    Sin[theta2])\)\ \((\((\(-\(\(0.904371004615764739`\ y11\ \
Cos[theta2]\)\/L1\)\) - Sin[theta2])\)\ \((\(-L1\)\ Cos[theta2] - 
                          0.658318911122252892`\ y11\ Sin[
                              theta2])\) + \((0.658318911122252892`\ y11\ Cos[
                              theta2] - 
                          L1\ Sin[theta2])\)\ \((Cos[
                            theta2] - \(0.904371004615764739`\ y11\ \
Sin[theta2]\)\/L1)\))\) + \((\(-\(\(0.904371004615764739`\ m\)\/L1\)\) + 
                    0.658318911122252892`\ m\ \((Cos[
                            theta2] - \(0.904371004615764739`\ y11\ \
Sin[theta2]\)\/L1)\))\)\ \((\((\(0.904371004615764739`\ y11\ \
Cos[theta2]\)\/L1 + Sin[theta2])\)\ \((0.658318911122252892`\ y11\ Cos[
                              theta2] - 
                          L1\ Sin[theta2])\) + \((\(-L1\)\ Cos[theta2] - 
                          0.658318911122252892`\ y11\ Sin[theta2])\)\ \((Cos[
                            theta2] - \(0.904371004615764739`\ y11\ \
Sin[theta2]\)\/L1)\))\) + \(1\/L1\) \((0.904371004615764739`\ \((Ia - 
                        m\ \((\((\(0.904371004615764739`\ y11\ \
Cos[theta2]\)\/L1 + Sin[theta2])\)\ \((0.658318911122252892`\ y11\ Cos[
                                        theta2] - 
                                    L1\ Sin[theta2])\) + \((\(-L1\)\ Cos[
                                        theta2] - 
                                    0.658318911122252892`\ y11\ Sin[
                                        theta2])\)\ \((Cos[
                                      theta2] - \(0.904371004615764739`\ y11\ \
Sin[theta2]\)\/L1)\))\))\))\) + 
              0.658318911122252892`\ \((Cos[
                      theta2] - \(0.904371004615764739`\ y11\ \
Sin[theta2]\)\/L1)\)\ \((\(-m\) + 
                    m\ \((\((\(0.904371004615764739`\ y11\ Cos[theta2]\)\/L1 \
+ Sin[theta2])\)\ \((0.658318911122252892`\ y11\ Cos[theta2] - 
                                L1\ Sin[theta2])\) + \((\(-L1\)\ Cos[
                                    theta2] - 
                                0.658318911122252892`\ y11\ Sin[
                                    theta2])\)\ \((Cos[
                                  theta2] - \(0.904371004615764739`\ y11\ \
Sin[theta2]\)\/L1)\))\))\))\), 
        0}, {Ia - 
          m\ \((\((\(0.904371004615764739`\ y11\ Cos[theta2]\)\/L1 + 
                      Sin[theta2])\)\ \((0.658318911122252892`\ y11\ Cos[
                          theta2] - 
                      L1\ Sin[theta2])\) + \((\(-L1\)\ Cos[theta2] - 
                      0.658318911122252892`\ y11\ Sin[theta2])\)\ \((Cos[
                        theta2] - \(0.904371004615764739`\ y11\ Sin[theta2]\)\
\/L1)\))\), 
        Ia, \(0.904371004615764739`\ Ia\)\/L1 - 
          0.658318911122252892`\ m\ \((Cos[
                  theta2] - \(0.904371004615764739`\ y11\ \
Sin[theta2]\)\/L1)\), 
        0}, {1\/2\ \((\(0.904371004615764739`\ Ia\)\/L1 - 
              0.658318911122252892`\ m\ \((Cos[
                      theta2] - \(0.904371004615764739`\ y11\ \
Sin[theta2]\)\/L1)\) + 
              1.31663782224450587`\ m\ \((\(-\(\(0.904371004615764739`\ y11\ \
Cos[theta2]\)\/L1\)\) - 
                    Sin[theta2])\)\ \((\((\(-\(\(0.904371004615764739`\ y11\ \
Cos[theta2]\)\/L1\)\) - Sin[theta2])\)\ \((\(-L1\)\ Cos[theta2] - 
                          0.658318911122252892`\ y11\ Sin[
                              theta2])\) + \((0.658318911122252892`\ y11\ Cos[
                              theta2] - 
                          L1\ Sin[theta2])\)\ \((Cos[
                            theta2] - \(0.904371004615764739`\ y11\ \
Sin[theta2]\)\/L1)\))\) + \((\(-\(\(0.904371004615764739`\ m\)\/L1\)\) + 
                    0.658318911122252892`\ m\ \((Cos[
                            theta2] - \(0.904371004615764739`\ y11\ \
Sin[theta2]\)\/L1)\))\)\ \((\((\(0.904371004615764739`\ y11\ \
Cos[theta2]\)\/L1 + Sin[theta2])\)\ \((0.658318911122252892`\ y11\ Cos[
                              theta2] - 
                          L1\ Sin[theta2])\) + \((\(-L1\)\ Cos[theta2] - 
                          0.658318911122252892`\ y11\ Sin[theta2])\)\ \((Cos[
                            theta2] - \(0.904371004615764739`\ y11\ \
Sin[theta2]\)\/L1)\))\) + \(1\/L1\) \((0.904371004615764739`\ \((Ia - 
                        m\ \((\((\(0.904371004615764739`\ y11\ \
Cos[theta2]\)\/L1 + Sin[theta2])\)\ \((0.658318911122252892`\ y11\ Cos[
                                        theta2] - 
                                    L1\ Sin[theta2])\) + \((\(-L1\)\ Cos[
                                        theta2] - 
                                    0.658318911122252892`\ y11\ Sin[
                                        theta2])\)\ \((Cos[
                                      theta2] - \(0.904371004615764739`\ y11\ \
Sin[theta2]\)\/L1)\))\))\))\) + 
              0.658318911122252892`\ \((Cos[
                      theta2] - \(0.904371004615764739`\ y11\ \
Sin[theta2]\)\/L1)\)\ \((\(-m\) + 
                    m\ \((\((\(0.904371004615764739`\ y11\ Cos[theta2]\)\/L1 \
+ Sin[theta2])\)\ \((0.658318911122252892`\ y11\ Cos[theta2] - 
                                L1\ Sin[theta2])\) + \((\(-L1\)\ Cos[
                                    theta2] - 
                                0.658318911122252892`\ y11\ Sin[
                                    theta2])\)\ \((Cos[
                                  theta2] - \(0.904371004615764739`\ y11\ \
Sin[theta2]\)\/L1)\))\))\))\), \(0.904371004615764739`\ Ia\)\/L1 - 
          0.658318911122252892`\ m\ \((Cos[
                  theta2] - \(0.904371004615764739`\ y11\ \
Sin[theta2]\)\/L1)\), 
        1 + 0.433383788741188791`\ m\ \((\(-\(\(0.904371004615764739`\ y11\ \
Cos[theta2]\)\/L1\)\) - Sin[theta2])\)\^2 + \(0.904371004615764739`\ \
\((\(0.904371004615764739`\ Ia\)\/L1 - 0.658318911122252892`\ m\ \
\((Cos[theta2] - \(0.904371004615764739`\ y11\ Sin[theta2]\)\/L1)\))\)\)\/L1 \
+ 0.658318911122252892`\ \((Cos[
                  theta2] - \(0.904371004615764739`\ y11\ \
Sin[theta2]\)\/L1)\)\ \((\(-\(\(0.904371004615764739`\ m\)\/L1\)\) + 
                0.658318911122252892`\ m\ \((Cos[
                        theta2] - \(0.904371004615764739`\ y11\ Sin[theta2]\)\
\/L1)\))\), 0}, {0, 0, 0, 1}}\)], "Output",
  CellLabel->"Out[132]=",
  CellTags->{"Flexible Manipulator", "i:5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Simplify[Cp.p]", "Input",
  CellLabel->"In[133]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[BoxData[
    \({\(1\/\(2\ L1\^2\)\) \((m\ v11\ w1\ y11\ \((5.0050828109236658`\ L1\^2 \
+ 2.83567143637365504`\ y11\^2)\)\ Cos[theta2]\^4 + 
            Cos[theta2]\^3\ \((m\ v11\ y11\ \((\(-2.15372169055542839`\)\ L1\ \
v11 - 0.866767577482377582`\ L1\^2\ w2 - 
                        0.708917859093413671`\ w2\ y11\^2)\) + 
                  0.`\ L1\ m\ v11\ w1\ y11\^2\ Sin[theta2])\) + 
            m\ v11\ Cos[theta2]\^2\ \((\((\(-2.15372169055542839`\)\ v11 - 
                        4.76291628007350542`\ L1\ w1 - 
                        2.38145814003675271`\ L1\ w2)\)\ y11 + \
\((\(-0.866767577482377582`\)\ L1\^2\ v11 + 1.31663782224450587`\ L1\^3\ w2 - 
                        2.12675357728024128`\ v11\ y11\^2 + 
                        1.07686084527771441`\ L1\ w2\ y11\^2)\)\ Sin[
                      theta2] + \((10.0101656218473311`\ L1\^2\ w1\ y11 + 
                        5.67134287274731008`\ w1\ y11\^3)\)\ \
Sin[theta2]\^2)\) + 
            Cos[theta2]\ \((1.19072907001837634`\ L1\ m\ v11\ w2\ y11 + 
                  0.`\ L1\^2\ m\ v11\ w2\ Sin[theta2] + 
                  m\ v11\ y11\ \((\(-2.15372169055542839`\)\ L1\ v11 - 
                        0.866767577482377582`\ L1\^2\ w2 - 
                        0.708917859093413671`\ w2\ y11\^2)\)\ Sin[theta2]\^2 \
+ 0.`\ L1\ m\ v11\ w1\ y11\^2\ Sin[theta2]\^3)\) + 
            m\ v11\ Sin[
                theta2]\ \((L1\ \((1.19072907001837634`\ v11 + 
                        1.31663782224450587`\ L1\ w2)\) + \
\((\(-2.15372169055542839`\)\ v11 - 4.76291628007350542`\ L1\ w1 - 
                        2.38145814003675271`\ L1\ w2)\)\ y11\ Sin[
                      theta2] + \((\(-0.866767577482377582`\)\ L1\^2\ v11 + 
                        1.31663782224450587`\ L1\^3\ w2 - 
                        2.12675357728024128`\ v11\ y11\^2 + 
                        1.07686084527771441`\ L1\ w2\ y11\^2)\)\ \
Sin[theta2]\^2 + \((5.0050828109236658`\ L1\^2\ w1\ y11 + 
                        2.83567143637365504`\ w1\ y11\^3)\)\ \
Sin[theta2]\^3)\))\), \(1\/\(4\ L1\^2\)\) \((m\ v11\ w1\ y11\ \
\((1.73353515496475534`\ L1\^2 + 
                  1.41783571818682734`\ y11\^2)\)\ Cos[theta2]\^3 + 
            L1\ m\ v11\ Cos[theta2]\^2\ \((\(-1.11022302462515654`*^-16\)\ \
v11\ y11 - 
                  4.76291628007350542`\ w1\ y11 + \
\((\(-2.63327564448901174`\)\ L1\^2\ w1 - 
                        2.15372169055542839`\ w1\ y11\^2)\)\ Sin[theta2])\) + 
            Cos[theta2]\ \((m\ v11\ \((\(-2.15372169055542839`\)\ v11 - 
                        
                        2.38145814003675271`\ L1\ w1)\)\ y11 + \((0.`\ L1\^2\ \
m\ v11\ w1 + 1.11022302462515654`*^-16\ m\ v11\^2\ y11\^2)\)\ Sin[theta2] + 
                  m\ v11\ w1\ y11\ \((1.73353515496475534`\ L1\^2 + 
                        1.41783571818682734`\ y11\^2)\)\ Sin[theta2]\^2)\) + 
            L1\ m\ v11\ Sin[
                theta2]\ \((\(-2.63327564448901174`\)\ L1\ w1 + \
\((1.11022302462515654`*^-16\ v11\ y11 - 
                        4.76291628007350542`\ w1\ y11)\)\ Sin[
                      theta2] + \((\(-2.63327564448901174`\)\ L1\^2\ w1 - 
                        2.15372169055542839`\ w1\ y11\^2)\)\ \
Sin[theta2]\^2)\))\), \(1\/\(4\ L1\^2\)\) \((m\ w1\^2\ y11\ \
\((\(-5.0050828109236658`\)\ L1\^2 - 
                  2.83567143637365504`\ y11\^2)\)\ Cos[theta2]\^4 + 
            Cos[theta2]\^3\ \((m\ w1\ w2\ y11\ \((\(-1.73353515496475534`\)\ \
L1\^2 - 1.41783571818682734`\ y11\^2)\) + 
                  0.`\ L1\ m\ w1\^2\ y11\^2\ Sin[theta2])\) + 
            m\ Cos[theta2]\^2\ \((\((1.41783571818682752`\ v11\^2 + 
                        4.76291628007350542`\ L1\ w1\^2 + 
                        2.22044604925031308`*^-16\ L1\ v11\ w2 + 
                        4.76291628007350542`\ L1\ w1\ w2)\)\ y11 + 
                  L1\ w1\ w2\ \((2.63327564448901174`\ L1\^2 + 
                        2.15372169055542839`\ y11\^2)\)\ Sin[theta2] + 
                  w1\^2\ y11\ \((\(-10.0101656218473311`\)\ L1\^2 - 
                        5.67134287274731008`\ y11\^2)\)\ Sin[theta2]\^2)\) + 
            Cos[theta2]\ \((m\ w2\ \((4.30744338111085678`\ v11 + 
                        2.38145814003675271`\ L1\ w1 + 
                        2.38145814003675271`\ L1\ w2)\)\ y11 + 
                  m\ v11\ \((2.22044604925031308`*^-16\ L1\ v11 - 
                        2.22044604925031308`*^-16\ w2\ y11\^2)\)\ Sin[
                      theta2] + 
                  m\ w1\ w2\ y11\ \((\(-1.73353515496475534`\)\ L1\^2 - 
                        1.41783571818682734`\ y11\^2)\)\ Sin[theta2]\^2 + 
                  0.`\ L1\ m\ w1\^2\ y11\^2\ Sin[theta2]\^3)\) + 
            m\ Sin[theta2]\ \((2.15372169055542839`\ v11\^2 + 
                  4.76291628007350542`\ L1\ v11\ w2 + 
                  2.63327564448901174`\ L1\^2\ w1\ w2 + 
                  2.63327564448901174`\ L1\^2\ w2\^2 + \
\((1.41783571818682752`\ v11\^2 + 4.76291628007350542`\ L1\ w1\^2 - 
                        2.22044604925031308`*^-16\ L1\ v11\ w2 + 
                        4.76291628007350542`\ L1\ w1\ w2)\)\ y11\ Sin[
                      theta2] + 
                  L1\ w1\ w2\ \((2.63327564448901174`\ L1\^2 + 
                        2.15372169055542839`\ y11\^2)\)\ Sin[theta2]\^2 + 
                  w1\^2\ y11\ \((\(-5.0050828109236658`\)\ L1\^2 - 
                        2.83567143637365504`\ y11\^2)\)\ \
Sin[theta2]\^3)\))\), 0}\)], "Output",
  CellLabel->"Out[133]=",
  CellTags->{"Flexible Manipulator", "i:5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fp", "Input",
  CellLabel->"In[134]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[BoxData[
    \({\(-\(\(1\/L1\) \((gc\ m\ \((\(-Sin[
                        theta1]\)\ \((2\ L1\^2 + \((L1\ L2 + 
                              0.202500397936091713`\ y11\ y21)\)\ Cos[
                            theta2] - 
                        0.904371004615764739`\ L2\ y11\ Sin[theta2] + 
                        0.223912970343545003`\ L1\ y21\ Sin[theta2])\) + 
                  Cos[theta1]\ \((0.88223188146579794`\ L1\ y11 + \
\((\(-0.904371004615764739`\)\ L2\ y11 + 
                              0.223912970343545003`\ L1\ y21)\)\ Cos[
                            theta2] - L1\ L2\ Sin[theta2] - 
                        0.202500397936091713`\ y11\ y21\ Sin[
                            theta2])\))\))\)\)\), \(-\(\(1\/L1\) \((gc\ m\ \
\((Sin[theta1]\ \((\(-L1\)\ L2\ Cos[theta2] - 
                        0.202500397936091713`\ y11\ y21\ Cos[
                            theta2] - \((\(-0.904371004615764739`\)\ L2\ y11 \
+ 0.223912970343545003`\ L1\ y21)\)\ Sin[theta2])\) + 
                  Cos[theta1]\ \((\(-0.904371004615764739`\)\ L2\ y11\ Cos[
                            theta2] + 
                        0.223912970343545003`\ L1\ y21\ Cos[
                            theta2] - \((L1\ L2 + 
                              0.202500397936091713`\ y11\ y21)\)\ Sin[
                            theta2])\))\))\)\)\), \(3.55305758439216878`\ El\ \
Ixx\ y11\)\/\(L1\^3\ m\) - \(1\/L1\) \((gc\ m\ \((Cos[
                      theta1]\ \((0.202500397936091713`\ y21\ Cos[theta2] - 
                        0.904371004615764739`\ L2\ Sin[theta2])\) + 
                  Sin[theta1]\ \((0.88223188146579794`\ L1 - 
                        0.904371004615764739`\ L2\ Cos[theta2] - 
                        0.202500397936091713`\ y21\ Sin[
                            theta2])\))\))\), \(3.55305758439216878`\ El\ Ixx\
\ y21\)\/\(L2\^3\ m\) - \(1\/L1\) \((gc\ m\ \((Cos[
                      theta1]\ \((0.202500397936091713`\ y11\ Cos[theta2] + 
                        0.223912970343545003`\ L1\ Sin[theta2])\) + 
                  Sin[theta1]\ \((0.223912970343545003`\ L1\ Cos[theta2] - 
                        0.202500397936091713`\ y11\ Sin[
                            theta2])\))\))\)}\)], "Output",
  CellLabel->"Out[134]=",
  CellTags->{"Flexible Manipulator", "i:5"}]
}, Open  ]],

Cell["\<\
The absolute position and orientation of a frame at the end of the second \
link can be obtained with the function EndEffector.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["EndPos=EndEffector[3,TreeList,BodyList,X];", "Input",
  CellLabel->"In[135]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell["Let's take a look at the position vector:", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[CellGroupData[{

Cell["EndPos[[{1,2,3},4]]", "Input",
  CellLabel->"In[136]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[BoxData[
    \({0, 
      0.658318911122252892`\ y11\ Cos[theta1] - L1\ Sin[theta1] + 
        0.658318911122252892`\ y21\ \((Cos[
                  theta2]\ \((Cos[
                      theta1] - \(0.904371004615764739`\ y11\ \
Sin[theta1]\)\/L1)\) + \((\(-\(\(0.904371004615764739`\ y11\ Cos[
                              theta1]\)\/L1\)\) - Sin[theta1])\)\ Sin[
                  theta2])\) + 
        L2\ \((Cos[
                  theta2]\ \((\(-\(\(0.904371004615764739`\ y11\ Cos[
                              theta1]\)\/L1\)\) - 
                    Sin[theta1])\) - \((Cos[
                      theta1] - \(0.904371004615764739`\ y11\ \
Sin[theta1]\)\/L1)\)\ Sin[theta2])\), 
      L1\ Cos[theta1] + 0.658318911122252892`\ y11\ Sin[theta1] + 
        L2\ \((Cos[
                  theta2]\ \((Cos[
                      theta1] - \(0.904371004615764739`\ y11\ \
Sin[theta1]\)\/L1)\) - \((\(0.904371004615764739`\ y11\ Cos[theta1]\)\/L1 + 
                    Sin[theta1])\)\ Sin[theta2])\) + 
        0.658318911122252892`\ y21\ \((Cos[
                  theta2]\ \((\(0.904371004615764739`\ y11\ Cos[theta1]\)\/L1 \
+ Sin[theta1])\) + \((Cos[
                      theta1] - \(0.904371004615764739`\ y11\ \
Sin[theta1]\)\/L1)\)\ Sin[theta2])\)}\)], "Output",
  CellLabel->"Out[136]=",
  CellTags->{"Flexible Manipulator", "i:5"}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Tractor Semi-Trailer", "Subsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["\<\
The goal is to show how deformable tires, tire parameters, and front end \
alignment parameters affect turning radius of a tractor \
semi\[CapitalEth]trailer. This example uses a simple model for a deformable \
pneumatic tire, namely, a single deformation parameter (proportional to \
sideslip angle), so that the cornering force is given by
                             F=-kappa*arctan[vy/vx]\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[CellGroupData[{

Cell[" Joint Definitions", "Subsubsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["Main body (tractor) joint", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["\<\
(* Joint 1  *)
r1={3}; q1={theta,x,y}; p1={wth,vx,vy};
H1={{0,0,0},{0,0,0},{1,0,0},{0,1,0},{0,0,1},{0,0,0}};
\
\>", "Input",
  CellLabel->"In[137]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["Tractor front end joints", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12,
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1],
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["\<\
Define castor sr (right) and sl (left) and camber tr (right) and tl (left). \
Note that positive castor and camber implies spindle points down and forward \
and inward.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["\<\
(* Castor/Camber *)
(* tr=0.02; tl=0.02; *)

(* Joint 2 right front spindle *)
r2={1}; q2={delta2}; p2={wdel2}; 
H2=Transpose[{{-sr,-tr,1,0,0,0}}];

(* Joint 3 left front spindle *)
r3={1}; q3={delta3}; p3={wdel3}; 
H3=Transpose[{{-sl,tl,1,0,0,0}}];\
\>", "Input",
  CellLabel->"In[140]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["Tractor-Semi joint", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12,
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1],
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["\<\
(* Joint 4 5th wheel *)
r4={1}; q4={delta4}; p4={wdel4};
H4=Transpose[{{0,0,1,0,0,0}}];

JointLst={{r1,H1,q1,p1},{r2,H2,q2,p2},{r3,H3,q3,p3},{r4,H4,q4,p4}};\
\>", "Input",
  CellLabel->"In[148]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Joint constructions", "Subsubsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[CellGroupData[{

Cell["{T,{V,X,H}}=Timing[Joints[JointLst]];", "Input",
  CellLabel->"In[152]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \("Computing joint 1 kinematics"\)], "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \("Computing joint 2 kinematics"\)], "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \("Computing joint 3 kinematics"\)], "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \("Computing joint 4 kinematics"\)], "Print",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Print[T];", "Input",
  CellLabel->"In[153]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \(58.83`\ Second\)], "Print",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Body data", "Subsubsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["\<\
Tractor body frame is located midway between rear axles on body centerline \
and at axle hight. It is right handed with x-forward, y-left, and z-up. 

\t           wb = wheelbase (186\")
\t           R=tire radius (12\")
\t           2b=track (72-11/16\")
\t           pin= pin location from rear bogie (8\")
\t           d=tractor rear axle location from rear bogie (28\")
\t           tb=trailor base (388\")
\t           kappa=tire coefficient (approx 14,000 N?)\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["\<\
wb=186*.0254; R=12*.0254; b=(72+11/16)*.0254;
pin=8*.0254; d=28*.0254; tb=388*.0254;
Jtracxx=1.414*10^3; Jtracyy=5.684*10^4; Jtraczz=5.698*10^4;Jtracxz=1.96*10^3;
Jtrailxx=2.202*10^5; Jtrailyy=4.852*10^5; Jtrailzz=5.065*10^5;
mtrac=1.15*10^4; mtrail=4.376*10^4; mtire=40;
Ixx=mtire*(R^2)/2; Iyy=mtire*(3*R^2+(11*.0254)^2)/12; Izz=Iyy;

(* Body 1 tractor *)
cm1={2.4466,0,.9052};
out1={{2,{wb,-b,0}},{3,{wb,b,0}},{4,{pin,0,0}},{5,{d,-b,-R}},{6,{d,b,-R}},{7,{\
-d,-b,-R}},{8,{-d,b,-R}}};
I1={{Jtracxx,0,Jtracxz},{0,Jtracyy,0},{Jtracxz,0,Jtraczz}};

(* Body 2 right front wheel *)
cm2={0,0,0}; out2={{9,{sr*R,tr*R,-R}}};
I2=DiagonalMatrix[{Ixx,Iyy,Izz}];

(* Body 3 left front wheel *)
cm3={0,0,0}; out3={{10,{sl*R,-tl*R,-R}}};
I3=DiagonalMatrix[{Ixx,Iyy,Izz}];

(* Body 4 trailor *)
cm4={-5.77,0,1.0592}; 
out4={{11,{-tb,-b,-R}},{12,{-tb,b,-R}}};
I4=DiagonalMatrix[{Jtrailxx,Jtrailyy,Jtrailzz}];

BodyLst={{cm1,out1,mtrac,I1},{cm2,out2,mtire,I2},{cm3,out3,mtire,I3},{cm4,\
out4,mtrail,I4}};
TreeLst={{{1,1},{2,2}},{{1,1},{3,3}},{{1,1},{4,4}}};

q={theta,x,y,delta2,delta3,delta4};
p={wth,vx,vy,wdel2,wdel3,wdel4};
\
\>", "Input",
  CellLabel->"In[154]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tire Forces", "Subsubsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["\<\
We will compute the tire generalized forces. This requires eight similar, and \
somewhat complicated, calculations. To reduce computation time, we use the \
function KinematicReplacements. The right front tire force is computed both \
with and without this enhancement. We find a factor of 10 improvement in \
computational speed.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[CellGroupData[{

Cell["\<\
(* Front right tire *)

ChnLst={{1,1},{2,2}};
Force={0,0,0,0,-kappa*ArcTan[v9y/v9x],0};
VelNames={w9x,w9y,w9z,v9x,v9y,v9z};
TerminalNode=9;
{T,Q1}=Timing[GeneralizedForce[ChnLst,TerminalNode,BodyLst,X,H,q,p,Force,\
VelNames]]
\
\>", "Input",
  CellLabel->"In[178]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \({97.3300000000000231`\ Second, {\(-kappa\)\ ArcTan[\((1.`\ tr\^2\ vy + 
                  4.72440000000000015`\ tr\^2\ wth + \((\((1 + 
                              sr\^2)\)\ vy + \((\(\(4.72440000000000015`\)\(\
\[InvisibleSpace]\)\) + 4.72440000000000015`\ sr\^2 + 
                              0.304799999999999959`\ sr\^3 + 
                              0.304799999999999959`\ sr\ \((1 + 
                                    tr\^2)\))\)\ wth)\)\ Cos[
                      delta2\ \@\(1 + sr\^2 + tr\^2\)] + 
                  sr\ tr\ \((2.`\ vx + 
                        3.69252499999999983`\ wth)\)\ Sin[1\/2\ delta2\ \@\(1 \
+ sr\^2 + tr\^2\)]\^2 - 
                  1.`\ \@\(1 + sr\^2 + tr\^2\)\ vx\ Sin[
                      delta2\ \@\(1 + sr\^2 + tr\^2\)] - 
                  1.84626249999999991`\ \@\(1 + sr\^2 + tr\^2\)\ wth\ Sin[
                      delta2\ \@\(1 + sr\^2 + tr\^2\)] + 
                  0.304799999999999959`\ tr\ \@\(1 + sr\^2 + tr\^2\)\ wth\ \
Sin[delta2\ \@\(1 + sr\^2 + tr\^2\)])\)/\((1.`\ sr\^2\ vx + 
                  1.84626249999999991`\ sr\^2\ wth + \((\((1 + 
                              tr\^2)\)\ vx + \((\(\(1.84626249999999991`\)\(\
\[InvisibleSpace]\)\) - 0.304799999999999959`\ \((1 + sr\^2)\)\ tr + 
                              1.84626249999999991`\ tr\^2 - 
                              0.304799999999999959`\ tr\^3)\)\ wth)\)\ Cos[
                      delta2\ \@\(1 + sr\^2 + tr\^2\)] + 
                  sr\ tr\ \((2.`\ vy + 
                        9.4488000000000003`\ wth)\)\ Sin[1\/2\ delta2\ \@\(1 \
+ sr\^2 + tr\^2\)]\^2 + 
                  1.`\ \@\(1 + sr\^2 + tr\^2\)\ vy\ Sin[
                      delta2\ \@\(1 + sr\^2 + tr\^2\)] + 
                  4.72440000000000015`\ \@\(1 + sr\^2 + tr\^2\)\ wth\ Sin[
                      delta2\ \@\(1 + sr\^2 + tr\^2\)] + 
                  0.304799999999999959`\ sr\ \@\(1 + sr\^2 + tr\^2\)\ wth\ \
Sin[delta2\ \@\(1 + sr\^2 + tr\^2\)])\)]\ \((\(4.72440000000000015`\ \
tr\^2\)\/\(1 + sr\^2 + tr\^2\) + \(1\/\(1 + sr\^2 + 
                      tr\^2\)\) \((\((\(\(4.72440000000000015`\)\(\
\[InvisibleSpace]\)\) + 4.72440000000000015`\ sr\^2 + 
                        0.304799999999999959`\ sr\^3 + 
                        0.304799999999999959`\ sr\ \((1 + tr\^2)\))\)\ Cos[
                      delta2\ \@\(1 + sr\^2 + tr\^2\)])\) - \
\(3.69252499999999983`\ Cos[1\/2\ delta2\ \@\(1 + sr\^2 + tr\^2\)]\ Sin[1\/2\ \
delta2\ \@\(1 + sr\^2 + tr\^2\)]\)\/\@\(1 + sr\^2 + tr\^2\) + \
\(3.69252499999999983`\ sr\ tr\ Sin[1\/2\ delta2\ \@\(1 + sr\^2 + tr\^2\)]\^2\
\)\/\(1 + sr\^2 + tr\^2\) + \(0.304799999999999959`\ tr\ Sin[delta2\ \@\(1 + \
sr\^2 + tr\^2\)]\)\/\@\(1 + sr\^2 + tr\^2\))\), \(1\/\((1 + sr\^2 + \
tr\^2)\)\^\(3/2\)\) \((2\ kappa\ ArcTan[\((1.`\ tr\^2\ vy + 
                      4.72440000000000015`\ tr\^2\ wth + \((\((1 + 
                                  sr\^2)\)\ vy + \
\((\(\(4.72440000000000015`\)\(\[InvisibleSpace]\)\) + 
                                  4.72440000000000015`\ sr\^2 + 
                                  0.304799999999999959`\ sr\^3 + 
                                  0.304799999999999959`\ sr\ \((1 + 
                                        tr\^2)\))\)\ wth)\)\ Cos[
                          delta2\ \@\(1 + sr\^2 + tr\^2\)] + 
                      sr\ tr\ \((2.`\ vx + 
                            3.69252499999999983`\ wth)\)\ Sin[1\/2\ delta2\ \
\@\(1 + sr\^2 + tr\^2\)]\^2 - 
                      1.`\ \@\(1 + sr\^2 + tr\^2\)\ vx\ Sin[
                          delta2\ \@\(1 + sr\^2 + tr\^2\)] - 
                      1.84626249999999991`\ \@\(1 + sr\^2 + tr\^2\)\ wth\ Sin[
                          delta2\ \@\(1 + sr\^2 + tr\^2\)] + 
                      0.304799999999999959`\ tr\ \@\(1 + sr\^2 + tr\^2\)\ wth\
\ Sin[delta2\ \@\(1 + sr\^2 + tr\^2\)])\)/\((1.`\ sr\^2\ vx + 
                      1.84626249999999991`\ sr\^2\ wth + \((\((1 + 
                                  tr\^2)\)\ vx + \
\((\(\(1.84626249999999991`\)\(\[InvisibleSpace]\)\) - 
                                  0.304799999999999959`\ \((1 + 
                                        sr\^2)\)\ tr + 
                                  1.84626249999999991`\ tr\^2 - 
                                  0.304799999999999959`\ tr\^3)\)\ wth)\)\ \
Cos[delta2\ \@\(1 + sr\^2 + tr\^2\)] + 
                      sr\ tr\ \((2.`\ vy + 
                            9.4488000000000003`\ wth)\)\ Sin[1\/2\ delta2\ \@\
\(1 + sr\^2 + tr\^2\)]\^2 + 
                      1.`\ \@\(1 + sr\^2 + tr\^2\)\ vy\ Sin[
                          delta2\ \@\(1 + sr\^2 + tr\^2\)] + 
                      4.72440000000000015`\ \@\(1 + sr\^2 + tr\^2\)\ wth\ Sin[
                          delta2\ \@\(1 + sr\^2 + tr\^2\)] + 
                      0.304799999999999959`\ sr\ \@\(1 + sr\^2 + tr\^2\)\ wth\
\ Sin[delta2\ \@\(1 + sr\^2 + tr\^2\)])\)]\ Sin[
                1\/2\ delta2\ \@\(1 + sr\^2 + tr\^2\)]\ \((\((1 + sr\^2 + 
                        tr\^2)\)\ Cos[
                      1\/2\ delta2\ \@\(1 + sr\^2 + tr\^2\)] - 
                  sr\ tr\ \@\(1 + sr\^2 + tr\^2\)\ Sin[
                      1\/2\ delta2\ \@\(1 + sr\^2 + tr\^2\)])\))\), \
\(-\(\(1\/\(1 + sr\^2 + 
                  tr\^2\)\) \((kappa\ ArcTan[\((1.`\ tr\^2\ vy + 
                        4.72440000000000015`\ tr\^2\ wth + \((\((1 + 
                                    sr\^2)\)\ vy + \
\((\(\(4.72440000000000015`\)\(\[InvisibleSpace]\)\) + 
                                    4.72440000000000015`\ sr\^2 + 
                                    0.304799999999999959`\ sr\^3 + 
                                    0.304799999999999959`\ sr\ \((1 + 
                                        tr\^2)\))\)\ wth)\)\ Cos[
                            delta2\ \@\(1 + sr\^2 + tr\^2\)] + 
                        sr\ tr\ \((2.`\ vx + 
                              3.69252499999999983`\ wth)\)\ Sin[1\/2\ delta2\ \
\@\(1 + sr\^2 + tr\^2\)]\^2 - 
                        1.`\ \@\(1 + sr\^2 + tr\^2\)\ vx\ Sin[
                            delta2\ \@\(1 + sr\^2 + tr\^2\)] - 
                        1.84626249999999991`\ \@\(1 + sr\^2 + tr\^2\)\ wth\ \
Sin[delta2\ \@\(1 + sr\^2 + tr\^2\)] + 
                        0.304799999999999959`\ tr\ \@\(1 + sr\^2 + tr\^2\)\ \
wth\ Sin[delta2\ \@\(1 + sr\^2 + tr\^2\)])\)/\((1.`\ sr\^2\ vx + 
                        1.84626249999999991`\ sr\^2\ wth + \((\((1 + 
                                    tr\^2)\)\ vx + \
\((\(\(1.84626249999999991`\)\(\[InvisibleSpace]\)\) - 
                                    0.304799999999999959`\ \((1 + 
                                        sr\^2)\)\ tr + 
                                    1.84626249999999991`\ tr\^2 - 
                                    0.304799999999999959`\ tr\^3)\)\ wth)\)\ \
Cos[delta2\ \@\(1 + sr\^2 + tr\^2\)] + 
                        sr\ tr\ \((2.`\ vy + 
                              9.4488000000000003`\ wth)\)\ Sin[1\/2\ delta2\ \
\@\(1 + sr\^2 + tr\^2\)]\^2 + 
                        1.`\ \@\(1 + sr\^2 + tr\^2\)\ vy\ Sin[
                            delta2\ \@\(1 + sr\^2 + tr\^2\)] + 
                        4.72440000000000015`\ \@\(1 + sr\^2 + tr\^2\)\ wth\ \
Sin[delta2\ \@\(1 + sr\^2 + tr\^2\)] + 
                        0.304799999999999959`\ sr\ \@\(1 + sr\^2 + tr\^2\)\ \
wth\ Sin[delta2\ \@\(1 + sr\^2 + tr\^2\)])\)]\ \((tr\^2 + \((1 + 
                          sr\^2)\)\ Cos[
                        delta2\ \@\(1 + sr\^2 + tr\^2\)])\))\)\)\), 0, 0, 
        0}}\)], "Output",
  CellLabel->"Out[183]=",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Print[T]", "Input",
  CellLabel->"In[184]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \(97.3300000000000231`\ Second\)], "Print",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell["{V,X,H,rules1,rules2}=KinematicReplacements[V,X,H,q];", "Input",
  CellLabel->"In[185]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[CellGroupData[{

Cell["rules1", "Input",
  CellLabel->"In[186]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \({t1 \[Rule] Sin[\(delta3\ t17\)\/2], t2 \[Rule] Sin[delta3\ t17], 
      t3 \[Rule] Sin[\(delta2\ t22\)\/2], t4 \[Rule] Sin[delta2\ t22], 
      t5 \[Rule] Cos[delta4], t6 \[Rule] Cos[theta], 
      t7 \[Rule] Cos[\(delta3\ t17\)\/2], t8 \[Rule] Cos[delta3\ t17], 
      t9 \[Rule] Cos[\(delta2\ t22\)\/2], 
      t10 \[Rule] Cos[delta2\ t22]}\)], "Output",
  CellLabel->"Out[186]=",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell["\<\
(* Front right tire *)
ChnLst={{1,1},{2,2}};
Force={0,0,0,0,-kappa*ArcTan[v9y/v9x],0};
VelNames={w9x,w9y,w9z,v9x,v9y,v9z};
TerminalNode=9;
Q1=GeneralizedForce[ChnLst,TerminalNode,BodyLst,X,H,q,p,Force,VelNames];\
\>", "Input",
  CellLabel->"In[187]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[CellGroupData[{

Cell["\<\
{T,Q1}=Timing[GeneralizedForce[ChnLst,TerminalNode,BodyLst,X,H,q,p,Force,\
VelNames]]\
\>", "Input",
  CellLabel->"In[193]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \({6.76000000000001932`\ Second, {\(-kappa\)\ \((4.72440000000000015`\ \
\((t10 + t10\ t12 + t18)\)\ t20 + 
              0.304799999999999959`\ sr\ \((1 + 
                    t10\ \((t12 + t18)\))\)\ t20 - 
              3.69252499999999983`\ t19\ t3\ \((\((1 + t12 + t18)\)\ t9 - 
                    sr\ t22\ t3\ tr)\) + 
              0.304799999999999959`\ \((sr\ \((\(-1\) + t10)\)\ t20 + 
                    t21\ t4\ tr)\))\)\ ArcTan[\((\(-2\)\ t19\ t3\ \((\((1 + 
                              t12 + t18)\)\ t9 - 
                        sr\ t22\ t3\ tr)\)\ vx + \((t10 + t10\ t12 + 
                        t18)\)\ t20\ vy + \((4.72440000000000015`\ \((t10 + 
                              t10\ t12 + t18)\)\ t20 + 
                        0.304799999999999959`\ sr\ \((1 + 
                              t10\ \((t12 + t18)\))\)\ t20 - 
                        3.69252499999999983`\ t19\ t3\ \((\((1 + t12 + 
                                    t18)\)\ t9 - sr\ t22\ t3\ tr)\) + 
                        0.304799999999999959`\ \((sr\ \((\(-1\) + 
                                    t10)\)\ t20 + 
                              t21\ t4\ tr)\))\)\ wth)\)/\((\((t10 + t12 + 
                        t10\ t18)\)\ t20\ vx + 
                  2\ t19\ t3\ \((\((1 + t12 + t18)\)\ t9 + 
                        sr\ t22\ t3\ tr)\)\ vy + \((1.84626249999999991`\ \
\((t10 + t12 + t10\ t18)\)\ t20 - 
                        0.304799999999999959`\ \((1 + 
                              t10\ \((t12 + t18)\))\)\ t20\ tr - 
                        0.304799999999999959`\ \((\(-sr\)\ t21\ t4 + \
\((\(-1\) + t10)\)\ t20\ tr)\) + 
                        9.4488000000000003`\ t19\ t3\ \((\((1 + t12 + 
                                    t18)\)\ t9 + 
                              sr\ t22\ t3\ tr)\))\)\ wth)\)], 
        2\ kappa\ t19\ t3\ \((\((1 + t12 + t18)\)\ t9 - 
              sr\ t22\ t3\ tr)\)\ ArcTan[\((\(-2\)\ t19\ t3\ \((\((1 + t12 + 
                              t18)\)\ t9 - sr\ t22\ t3\ tr)\)\ vx + \((t10 + 
                        t10\ t12 + 
                        t18)\)\ t20\ vy + \((4.72440000000000015`\ \((t10 + 
                              t10\ t12 + t18)\)\ t20 + 
                        0.304799999999999959`\ sr\ \((1 + 
                              t10\ \((t12 + t18)\))\)\ t20 - 
                        3.69252499999999983`\ t19\ t3\ \((\((1 + t12 + 
                                    t18)\)\ t9 - sr\ t22\ t3\ tr)\) + 
                        0.304799999999999959`\ \((sr\ \((\(-1\) + 
                                    t10)\)\ t20 + 
                              t21\ t4\ tr)\))\)\ wth)\)/\((\((t10 + t12 + 
                        t10\ t18)\)\ t20\ vx + 
                  2\ t19\ t3\ \((\((1 + t12 + t18)\)\ t9 + 
                        sr\ t22\ t3\ tr)\)\ vy + \((1.84626249999999991`\ \
\((t10 + t12 + t10\ t18)\)\ t20 - 
                        0.304799999999999959`\ \((1 + 
                              t10\ \((t12 + t18)\))\)\ t20\ tr - 
                        0.304799999999999959`\ \((\(-sr\)\ t21\ t4 + \
\((\(-1\) + t10)\)\ t20\ tr)\) + 
                        9.4488000000000003`\ t19\ t3\ \((\((1 + t12 + 
                                    t18)\)\ t9 + 
                              sr\ t22\ t3\ tr)\))\)\ wth)\)], \(-kappa\)\ \
\((t10 + t10\ t12 + 
              t18)\)\ t20\ ArcTan[\((\(-2\)\ t19\ t3\ \((\((1 + t12 + 
                              t18)\)\ t9 - sr\ t22\ t3\ tr)\)\ vx + \((t10 + 
                        t10\ t12 + 
                        t18)\)\ t20\ vy + \((4.72440000000000015`\ \((t10 + 
                              t10\ t12 + t18)\)\ t20 + 
                        0.304799999999999959`\ sr\ \((1 + 
                              t10\ \((t12 + t18)\))\)\ t20 - 
                        3.69252499999999983`\ t19\ t3\ \((\((1 + t12 + 
                                    t18)\)\ t9 - sr\ t22\ t3\ tr)\) + 
                        0.304799999999999959`\ \((sr\ \((\(-1\) + 
                                    t10)\)\ t20 + 
                              t21\ t4\ tr)\))\)\ wth)\)/\((\((t10 + t12 + 
                        t10\ t18)\)\ t20\ vx + 
                  2\ t19\ t3\ \((\((1 + t12 + t18)\)\ t9 + 
                        sr\ t22\ t3\ tr)\)\ vy + \((1.84626249999999991`\ \
\((t10 + t12 + t10\ t18)\)\ t20 - 
                        0.304799999999999959`\ \((1 + 
                              t10\ \((t12 + t18)\))\)\ t20\ tr - 
                        0.304799999999999959`\ \((\(-sr\)\ t21\ t4 + \
\((\(-1\) + t10)\)\ t20\ tr)\) + 
                        9.4488000000000003`\ t19\ t3\ \((\((1 + t12 + 
                                    t18)\)\ t9 + 
                              sr\ t22\ t3\ tr)\))\)\ wth)\)], 0, 0, 
        0}}\)], "Output",
  CellLabel->"Out[193]=",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Print[T];", "Input",
  CellLabel->"In[194]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \(6.76000000000001932`\ Second\)], "Print",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell["\<\
(* Front left tire *)
ChnLst={{1,1},{3,3}};
Force={0,0,0,0,-kappa*ArcTan[v10y/v10x],0};
VelNames={w10x,w10y,w10z,v10x,v10y,v10z};
TerminalNode=10;
Q2=GeneralizedForce[ChnLst,TerminalNode,BodyLst,X,H,q,p,Force,VelNames];\
\>", "Input",
  CellLabel->"In[195]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["\<\

(* Tractor rear right\[CapitalEth]forward *)
ChnLst={{1,1}};
Force={0,0,0,FDrive,-kappa*ArcTan[v5y/v5x],0};
VelNames={w5x,w5y,w5z,v5x,v5y,v5z};
TerminalNode=5;
Q3=GeneralizedForce[ChnLst,TerminalNode,BodyLst,X,H,q,p,Force,VelNames];\
\>", "Input",
  CellLabel->"In[201]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["\<\

(* Tracter rear right\[CapitalEth]backward *)
ChnLst={{1,1}};
Force={0,0,0,FDrive,-kappa*ArcTan[v7y/v7x],0};
VelNames={w7x,w7y,w7z,v7x,v7y,v7z};
TerminalNode=7;
Q4=GeneralizedForce[ChnLst,TerminalNode,BodyLst,X,H,q,p,Force,VelNames];\
\>", "Input",
  CellLabel->"In[207]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["\<\

(* Tractor rear left\[CapitalEth]forward *)
ChnLst={{1,1}};
Force={0,0,0,FDrive,-kappa*ArcTan[v6y/v6x],0};
VelNames={w6x,w6y,w6z,v6x,v6y,v6z};
TerminalNode=6;
Q5=GeneralizedForce[ChnLst,TerminalNode,BodyLst,X,H,q,p,Force,VelNames];\
\>", "Input",
  CellLabel->"In[213]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["\<\

(* Tractor rear left backward *)
ChnLst={{1,1}};
Force={0,0,0,FDrive,-kappa*ArcTan[v8y/v8x],0};
VelNames={w8x,w8y,w8z,v8x,v8y,v8z};
TerminalNode=8;
Q6=GeneralizedForce[ChnLst,TerminalNode,BodyLst,X,H,q,p,Force,VelNames];\
\>", "Input",
  CellLabel->"In[219]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["\<\

(* Trailor right *)
ChnLst={{1,1},{4,4}};
Force={0,0,0,0,-kappa*ArcTan[v11y/v11x],0};
VelNames={w11x,w11y,w11z,v11x,v11y,v11z};
TerminalNode=11;
Q7=GeneralizedForce[ChnLst,TerminalNode,BodyLst,X,H,q,p,Force,VelNames];\
\>", "Input",
  CellLabel->"In[225]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["\<\

(* Trailor left *)
ChnLst={{1,1},{4,4}};
Force={0,0,0,0,-kappa*ArcTan[v12y/v12x],0};
VelNames={w12x,w12y,w12z,v12x,v12y,v12z};
TerminalNode=12;
Q8=GeneralizedForce[ChnLst,TerminalNode,BodyLst,X,H,q,p,Force,VelNames];\
\>", "Input",
  CellLabel->"In[231]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["Q=Q1+Q2+Q3+Q4+Q5+Q6+Q7+Q8;", "Input",
  CellLabel->"In[237]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create model", "Subsubsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[CellGroupData[{

Cell["\<\
{V,X,H,Q}=Chop[{V,X,H,Q}/.rules1,.001];
{V,X,H,M,Csys,Fsys,psys,qsys}=CreateModel[JointLst,BodyLst,TreeLst,g,0,Q,V,X,\
H];\
\>", "Input",
  CellLabel->"In[238]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \("Computing Potential Functions"\)], "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \("Computing Inertia Matrix"\)], "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \("Computing Poincare Function"\)], "Print",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell["\<\
{V,X,H,M,Csys,Fsys,psys,qsys}={V,X,H,M,Csys,Fsys,psys,qsys}/.rules2;\
\>", "Input",
  CellLabel->"In[240]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["\<\

yout={X[[1]][[1,4]]/.0254,X[[1]][[2,4]]/.0254};

Inputs = {FDrive};
Outputs = yout;
MEXFilename = \"truck.c\";
paramvec={sr,sl,kappa,g};
PassedParams = {\"X0\",\"sr\",\"sl\",\"kappa\",\"g\"};
PassedParamsDimensions = {{2*Length[p],1},{1,1},{1,1},{1,1},{1,1}};\
\>", "Input",
  CellLabel->"In[241]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["System Reduction & Creation of Mex File", "Subsubsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell["\<\
For analysis purposes we create a simulation model with the following two \
features. First, we assume that delta2 and delta3 are inputs rather than \
coordinates determined by the dynamics. Thus, we eliminate two degrees of \
freedom. Second, we choose to ignore any steering imperfections and assume \
delta2 and delta3 are equal and call them both delta. \
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[CellGroupData[{

Cell["\<\
qred=Part[qsys,{1,2,3,6}];
pred=Part[psys,{1,2,3,6}];
Mred=Part[M,{1,2,3,6},{1,2,3,6}]/.Inner[Rule,{delta2,delta3},{0,0},List];
Cred=Part[Csys,{1,2,3,6},{1,2,3,6}]/.Inner[Rule,{delta2,delta3},{0,0},List];
Fred=Part[Fsys,{1,2,3,6}]/.Inner[Rule,{delta2,delta3},{delta,delta},List];
Vred=V[[{1,4}]];

Inputs = {FDrive,delta};

MEXFilename = \"truck.c\";
paramvec={sr,sl,kappa,g};
PassedParams = {\"X0\",\"sr\",\"sl\",\"kappa\",\"g\"};
PassedParamsDimensions = {{2*Length[pred],1},{1,1},{1,1},{1,1},{1,1}};

FpPrec = SetPrecision[Fred,5];
MPrec = SetPrecision[Mred,5];
CpPrec=SetPrecision[Cred,5];


CreateModelMEX[pred,qred,Inputs,Outputs,PassedParams,PassedParamsDimensions,
                              Vred,CpPrec,FpPrec,MPrec, MEXFilename];
  \
\>", "Input",
  CellLabel->"In[248]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \("...Generating Header Code"\)], "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \("...Generating Initial Condition Function Code"\)], "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \("...Generating State Derivative Function Code"\)], "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \("...Collecting all function terms"\)], "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \("...Generating temp variable declarations"\)], "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \("...Converting Expressions to C form"\)], "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \("...Generating Output Function Code"\)], "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \("MEX File created with name: truck.c"\)], "Print",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inputs", "Input",
  CellLabel->"In[264]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \({FDrive, delta}\)], "Output",
  CellLabel->"Out[264]=",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Outputs", "Input",
  CellLabel->"In[265]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[BoxData[
    \({39.3700787401574814`\ x, 39.3700787401574814`\ y}\)], "Output",
  CellLabel->"Out[265]=",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Constraints"], "Section",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Introductory Remarks", "Subsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Constraints Intro"],

Cell["\<\
Many systems of interest do not have a simple tree structure but can be \
viewed in terms of a tree with additional algebraic and/or differential \
constraints. A key advantage of the Lagrange formulation is that the explicit \
formulation of the relations that constrain the configuration of a system is \
usually avoided by appropriate choice of the generalized coordinates. \
However, with complex systems, a correct choice of generalized coordinates \
may be far from obvious. 

One systematic method for dealing with mechanical configurations containing \
closed loops is to break (free) a minimal number of joints so as to obtain a \
tree structure which, of course, has a natural set of configuration \
coordinates. The loop-breaking joint constraints are then added as \
suplemental algebraic relations. The number of degrees of freedom of the \
system is typically reduced by the number of independent relations. If these \
relations are (globally) solvable for a like number of coordinates then these \
coordinates can be explicitly eliminated. When there are k such constraints, \
the number of coordinates is reduced by k and the number of quasi-velocities \
is also reduced by k. It may not be possible to eliminate all k excess \
coordinates, but it is always possible to eliminate k quasi-velocities.

Some chain and loop structures give rise to differential constraints - such \
as when rolling of one body on another occurs. In general, when k independent \
differential constraints are present it is possible to eliminate k \
quasi-velocities. If the constraints are 'partially integrable' then, in \
principle, it is also possible to eliminate some coordinates as well. When \
the constraints are 'completely integrable' the number of configuration \
degrees of freedom are reduced by k and the system is said to be 'holonomic.' \
Otherwise it is 'nonholonomic.'

Even when it is not possible or practical to eliminate all k configuration \
coordinates it is fairly straightforward to derived the reduced set of \
equations in which the k quasi-velocities are removed. These equations form a \
valid, closed system of differential equations that completely describe the \
system behavior. Presently, TSi Dynamics provides functions to generate this \
latter set of equations unless the user specifies a set of configuration \
coordinates that are to be removed.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Constraints Intro"],

Cell[CellGroupData[{

Cell["<<ProPac`", "Input",
  CellLabel->"In[2]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Constraints Intro"],

Cell[BoxData[
    \("\n    This is ProPac - Version 2.0\n \n ProPac has been successfully \
loaded. It contains packages\n for multibody dynamics, linear control and \
nonlinear control.\n Appropriate packages will be loaded automatically as \
required.\n Packages can be manually loaded by simply entering \
GeometricTools,\n Dynamics, LinearControl, NonlinearControl or MEXTools as \
desired.\n Once a package is loaded, enter ?GeomtricTools, ?Dynamics,\n \
?LinearControl, ?NonlinearControl, or ?MEXTools, respectively,\n to obtain a \
list of available functions. Help is also available\n in the Help Browser \
under Add-ons."\)], "Print",
  CellLabel->"From In[2]:="]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["A Simple Closed Chain", "Subsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:7"}],

Cell["\<\
Consider a planar two bar linkage in which the lower end of bar 1 is \
constrained by a revolute joint on the y-axis at y=0 and the upper end of bar \
two slides on the z-axis. The upper end of bar 1 and the lower end of bar 2 \
are connected by a revolute joint.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:7"}],

Cell["\<\
r1={1};
H1=Transpose[{{1,0,0,0,0,0}}];
q1={theta1};p1={w1};

r2={1};
H2=Transpose[{{1,0,0,0,0,0}}];
q2={theta2};p2={w2};

JointList={{r1,H1,q1,p1},{r2,H2,q2,p2}};\
\>", "Input",
  CellLabel->"In[3]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:7"}],

Cell["\<\
Mass1=m1; CenterOfMass1={0,0,L1/2}; OutboardNode1={2,{0,0,L1}};
InertiaMatrix1=DiagonalMatrix[{m1*L1^2/12,m1*L1^2/12,0}];

Mass2=m2; CenterOfMass2={0,0,L2/2}; OutboardNode2={3,{0,0,L2}};
InertiaMatrix2=DiagonalMatrix[{m2*L2^2/12,m2*L2^2/12,0}];

BodyList={{CenterOfMass1,{OutboardNode1},Mass1,InertiaMatrix1},
          {CenterOfMass2,{OutboardNode2},Mass2,InertiaMatrix2}};\
\>", "Input",
  CellLabel->"In[10]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:7"}],

Cell["\<\
TreeList={{{1,1},{2,2}}};
PE=0; Q={0,0};\
\>", "Input",
  CellLabel->"In[15]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:7"}],

Cell[CellGroupData[{

Cell["\<\
{V,X,H,M,Cp,Fp,p,q}=CreateModel[JointList,BodyList,TreeList,g,PE,Q];\
\>", "Input",
  CellLabel->"In[17]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:7"}],

Cell[BoxData[
    \("  *** Dynamics successfully loaded ***"\)], "Print",
  CellLabel->"From In[17]:=",
  CellTags->{"Closed Chain", "i:7"}],

Cell[BoxData[
    \("Computing Joint Kinematics"\)], "Print",
  CellLabel->"From In[17]:=",
  CellTags->{"Closed Chain", "i:7"}],

Cell[BoxData[
    \("Computing joint 1 kinematics"\)], "Print",
  CellLabel->"From In[17]:=",
  CellTags->{"Closed Chain", "i:7"}],

Cell[BoxData[
    \("Computing joint 2 kinematics"\)], "Print",
  CellLabel->"From In[17]:=",
  CellTags->{"Closed Chain", "i:7"}],

Cell[BoxData[
    \("Computing Potential Functions"\)], "Print",
  CellLabel->"From In[17]:=",
  CellTags->{"Closed Chain", "i:7"}],

Cell[BoxData[
    \("Computing Inertia Matrix"\)], "Print",
  CellLabel->"From In[17]:=",
  CellTags->{"Closed Chain", "i:7"}],

Cell[BoxData[
    \("Computing Poincare Function"\)], "Print",
  CellLabel->"From In[17]:=",
  CellTags->{"Closed Chain", "i:7"}]
}, Open  ]],

Cell["\<\
ChnBodyList={{CenterOfMass1,{0,0,L1},Mass1,InertiaMatrix1},
             {CenterOfMass2,{0,0,L2},Mass2,InertiaMatrix2}};\
\>", "Input",
  CellLabel->"In[18]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:7"}],

Cell["EndPos=EndEffector[ChnBodyList,X];", "Input",
  CellLabel->"In[19]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:7"}],

Cell[CellGroupData[{

Cell["G=EndPos[[{2},4]]", "Input",
  CellLabel->"In[20]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:7"}],

Cell[BoxData[
    \({\(-L1\)\ Sin[theta1] + 
        L2\ \((\(-Cos[theta2]\)\ Sin[theta1] - 
              Cos[theta1]\ Sin[theta2])\)}\)], "Output",
  CellLabel->"Out[20]=",
  CellTags->{"Closed Chain", "i:7"}]
}, Open  ]],

Cell["\<\
The relation G=0 is not solvable for either theta1 or theta2 for all values \
of L1 and L2 - although, as we will describe below, it can be solved for \
particular values of these parameters. Thus, we will not try to eliminate any \
configuration coordinate. The constrained dynamics are obtained with:\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:7"}],

Cell[CellGroupData[{

Cell["\<\
{Mm,Cm,Fm,Vm,phat,qhat}=AlgebraicConstraints[M,Cp,Fp,V,G,p,q]\
\>", "Input",
  CellLabel->"In[21]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:7"}],

Cell[BoxData[
    \("Vm"\)], "Print",
  CellLabel->"From In[21]:=",
  CellTags->{"Closed Chain", "i:7"}],

Cell[BoxData[
    \("Mm"\)], "Print",
  CellLabel->"From In[21]:=",
  CellTags->{"Closed Chain", "i:7"}],

Cell[BoxData[
    \("Cm"\)], "Print",
  CellLabel->"From In[21]:=",
  CellTags->{"Closed Chain", "i:7"}],

Cell[BoxData[
    \("Fm"\)], "Print",
  CellLabel->"From In[21]:=",
  CellTags->{"Closed Chain", "i:7"}],

Cell[BoxData[
    \({{{1\/12\ L1\^2\ L2\^2\ \((2\ m1 + 5\ m2 - m2\ Cos[2\ theta1] - 
                3\ m2\ Cos[2\ theta2] + 
                2\ m1\ Cos[2\ \((theta1 + theta2)\)] + 
                3\ m2\ Cos[
                    2\ \((theta1 + 
                          theta2)\)])\)}}, {{\(-\(1\/24\)\)\ "w1"\ L1\^2\ \
L2\^2\ \((3\ L1\ m2\ Sin[theta1 - 2\ theta2] + 
                4\ L2\ m2\ Sin[theta1 - theta2] + 
                L2\ m2\ Sin[3\ theta1 + theta2] + 
                2\ L1\ m1\ Sin[theta1 + 2\ theta2] + 
                2\ L1\ m1\ Sin[3\ theta1 + 2\ theta2] + 
                3\ L1\ m2\ Sin[3\ theta1 + 2\ theta2] - 
                3\ L2\ m2\ Sin[
                    theta1 + 3\ theta2])\)}}, {1\/4\ g\ L1\ L2\ \((\(-\((m1 + 
                      3\ m2)\)\)\ Sin[theta2] + \((m1 + m2)\)\ Sin[
                  2\ theta1 + theta2])\)}, {{\(-L2\)\ Cos[
              theta1 + theta2]}, {L1\ Cos[theta1] + 
            L2\ Cos[theta1 + theta2]}}, {"w1"}, {theta1, theta2}}\)], "Output",\

  CellLabel->"Out[21]=",
  CellTags->{"Closed Chain", "i:7"}]
}, Open  ]],

Cell["\<\
These parameters define the constrained system dynamics. Now, let's consider \
the special case: L1=L2=L. This is the only situation where G=0 can be solved \
for either theta1 or theta2, so that either angle can be used to parameterize \
the system configuration. For simplicity, also set m1=m2=m. In this case the \
system matrices are:\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:7"}],

Cell[CellGroupData[{

Cell["\<\
{Mm,Cm,Fm,Vm}=Simplify[{Mm,Cm,Fm,Vm}/.{L1->L,L2->L,m1->m,m2->m}]\
\>", "Input",
  CellLabel->"In[22]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:7"}],

Cell[BoxData[
    \({{{\(-\(1\/12\)\)\ L\^4\ m\ \((\(-7\) + Cos[2\ theta1] + 
                3\ Cos[2\ theta2] - 
                5\ Cos[2\ \((theta1 + 
                          theta2)\)])\)}}, {{\(-\(1\/24\)\)\ "w1"\ L\^5\ m\ \
\((3\ Sin[theta1 - 2\ theta2] + 4\ Sin[theta1 - theta2] + 
                Sin[3\ theta1 + theta2] + 2\ Sin[theta1 + 2\ theta2] + 
                5\ Sin[3\ theta1 + 2\ theta2] - 
                3\ Sin[theta1 + 
                      3\ theta2])\)}}, {1\/2\ g\ L\^2\ m\ \((\(-2\)\ Sin[
                  theta2] + Sin[2\ theta1 + theta2])\)}, {{\(-L\)\ Cos[
              theta1 + theta2]}, {L\ \((Cos[theta1] + 
                Cos[theta1 + theta2])\)}}}\)], "Output",
  CellLabel->"Out[22]=",
  CellTags->{"Closed Chain", "i:7"}]
}, Open  ]],

Cell["\<\
It is convenient to assemble the corresponding differential equations.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:7"}],

Cell[CellGroupData[{

Cell["Eqns=MakeODEs[phat,qhat,Vm,Mm,Cm,Fm,t]", "Input",
  CellLabel->"In[23]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:7"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["theta1", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], 
          "==", \(\(-L\)\ Cos[theta1[t] + theta2[t]]\ w1[t]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["theta2", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], 
          "==", \(L\ \((Cos[theta1[t]] + Cos[theta1[t] + theta2[t]])\)\ w1[
              t]\)}], ",", 
        RowBox[{
          
          RowBox[{\(1\/2\ g\ L\^2\ m\ \((\(-2\)\ Sin[theta2[t]] + 
                  Sin[2\ theta1[t] + theta2[t]])\)\), 
            "-", \(1\/24\ L\^5\ m\ \((3\ Sin[theta1[t] - 2\ theta2[t]] + 
                  4\ Sin[theta1[t] - theta2[t]] + 
                  Sin[3\ theta1[t] + theta2[t]] + 
                  2\ Sin[theta1[t] + 2\ theta2[t]] + 
                  5\ Sin[3\ theta1[t] + 2\ theta2[t]] - 
                  3\ Sin[theta1[t] + 3\ theta2[t]])\)\ w1[t]\^2\), "-", 
            
            RowBox[{\(1\/12\), " ", \(L\^4\), " ", "m", 
              " ", \((\(-7\) + Cos[2\ theta1[t]] + 3\ Cos[2\ theta2[t]] - 
                  5\ Cos[2\ \((theta1[t] + theta2[t])\)])\), " ", 
              RowBox[{
                SuperscriptBox["w1", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}]}], "==", 
          "0"}]}], "}"}]], "Output",
  CellLabel->"Out[23]=",
  CellTags->{"Closed Chain", "i:7"}]
}, Open  ]],

Cell["\<\
Notice that there are two kinematic equations and one dynamic equation. Since \
L1=L2=L it is easy to show that theta2=-2 theta1. Hence we can make this \
replacement to obtain:\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:7"}],

Cell[CellGroupData[{

Cell["SpEqns=Simplify[Eqns/.theta2[t]->-2*theta1[t]]", "Input",
  CellLabel->"In[24]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:7"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["theta1", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], 
          "==", \(\(-L\)\ Cos[theta1[t]]\ w1[t]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["theta2", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], 
          "==", \(2\ L\ Cos[theta1[t]]\ w1[t]\)}], ",", 
        RowBox[{
          
          RowBox[{\(1\/6\), " ", \(L\^2\), " ", "m", " ", \(Cos[theta1[t]]\), 
            " ", 
            RowBox[{"(", 
              
              RowBox[{\(12\ g\ Sin[theta1[t]]\), 
                "+", \(L\^3\ \((2\ Sin[2\ theta1[t]] - 
                      3\ Sin[4\ theta1[t]])\)\ w1[t]\^2\), "+", 
                
                RowBox[{\(L\^2\), 
                  " ", \((7\ Cos[theta1[t]] - 3\ Cos[3\ theta1[t]])\), " ", 
                  RowBox[{
                    SuperscriptBox["w1", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}], 
          "==", "0"}]}], "}"}]], "Output",
  CellLabel->"Out[24]=",
  CellTags->{"Closed Chain", "i:7"}]
}, Open  ]],

Cell["\<\
Simple trigonometric identities can be used to verify that these equations \
are equivalent to those given by Ginsberg for this example.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:7"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Another Closed Chain", "Subsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:8"}],

Cell["\<\
Consider a two bar linkage in the x-y plane. The left end of bar 1 is \
constrained to slide on the x-axis and the right end of bar two slides on the \
y-axis. The right end of bar 1 and the left end of bar 2 are connected by a \
revolute joint.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:8"}],

Cell["\<\
r1={1,1};
H1=Transpose[{{0,0,1,0,0,0},{0,0,0,1,0,0}}];
q1={theta1,x};p1={w1,vx};

r2={1};
H2=Transpose[{{0,0,1,0,0,0}}];
q2={theta2};p2={w2};

JointList={{r1,H1,q1,p1},{r2,H2,q2,p2}};\
\>", "Input",
  CellLabel->"In[25]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:8"}],

Cell["\<\
Mass1=m1; CenterOfMass1={L1/2,0,0}; OutboardNode1={2,{L1,0,0}};
InertiaMatrix1=DiagonalMatrix[{0,m1*L1^2/2,m1*L1^2/2}];

Mass2=m2; CenterOfMass2={L2/2,0,0}; OutboardNode2={3,{L2,0,0}};
InertiaMatrix2=DiagonalMatrix[{0,m2*L2^2/2,m2*L2^2/2}];

BodyList={{CenterOfMass1,{OutboardNode1},Mass1,InertiaMatrix1},
          {CenterOfMass2,{OutboardNode2},Mass2,InertiaMatrix2}};\
\>", "Input",
  CellLabel->"In[32]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:8"}],

Cell["\<\
TreeList={{{1,1},{2,2}}};
PE=0; Q={0,0,0};\
\>", "Input",
  CellLabel->"In[37]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:8"}],

Cell[CellGroupData[{

Cell["\<\
{V,X,H,M,Cp,Fp,p,q}=CreateModel[JointList,BodyList,TreeList,g,PE,Q];\
\>", "Input",
  CellLabel->"In[39]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:8"}],

Cell[BoxData[
    \("Computing Joint Kinematics"\)], "Print",
  CellLabel->"From In[39]:=",
  CellTags->{"Closed Chain", "i:8"}],

Cell[BoxData[
    \("Computing joint 1 kinematics"\)], "Print",
  CellLabel->"From In[39]:=",
  CellTags->{"Closed Chain", "i:8"}],

Cell[BoxData[
    \("Computing joint 2 kinematics"\)], "Print",
  CellLabel->"From In[39]:=",
  CellTags->{"Closed Chain", "i:8"}],

Cell[BoxData[
    \("Computing Potential Functions"\)], "Print",
  CellLabel->"From In[39]:=",
  CellTags->{"Closed Chain", "i:8"}],

Cell[BoxData[
    \("Computing Inertia Matrix"\)], "Print",
  CellLabel->"From In[39]:=",
  CellTags->{"Closed Chain", "i:8"}],

Cell[BoxData[
    \("Computing Poincare Function"\)], "Print",
  CellLabel->"From In[39]:=",
  CellTags->{"Closed Chain", "i:8"}]
}, Open  ]],

Cell["\<\
ChnBodyList={{CenterOfMass1,{L1,0,0},Mass1,InertiaMatrix1},
             {CenterOfMass2,{L2,0,0},Mass2,InertiaMatrix2}};\
\>", "Input",
  CellLabel->"In[40]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:8"}],

Cell["EndPos=EndEffector[ChnBodyList,X];", "Input",
  CellLabel->"In[41]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:8"}],

Cell[CellGroupData[{

Cell["G=EndPos[[{1},4]]", "Input",
  CellLabel->"In[42]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:8"}],

Cell[BoxData[
    \({x + L1\ Cos[theta1] + 
        L2\ \((Cos[theta1]\ Cos[theta2] - 
              Sin[theta1]\ Sin[theta2])\)}\)], "Output",
  CellLabel->"Out[42]=",
  CellTags->{"Closed Chain", "i:8"}]
}, Open  ]],

Cell["\<\
Since G=0 always has a solution for x, we will eliminate x from the \
constrained equations.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:8"}],

Cell[CellGroupData[{

Cell["\<\
{Mm,Cm,Fm,Vm,phat,qhat}=AlgebraicConstraints[M,Cp,Fp,V,G,p,q,{2}]\
\>", "Input",
  CellLabel->"In[43]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:8"}],

Cell[BoxData[
    \("Vm"\)], "Print",
  CellLabel->"From In[43]:=",
  CellTags->{"Closed Chain", "i:8"}],

Cell[BoxData[
    \("Mm"\)], "Print",
  CellLabel->"From In[43]:=",
  CellTags->{"Closed Chain", "i:8"}],

Cell[BoxData[
    \("Cm"\)], "Print",
  CellLabel->"From In[43]:=",
  CellTags->{"Closed Chain", "i:8"}],

Cell[BoxData[
    \("Fm"\)], "Print",
  CellLabel->"From In[43]:=",
  CellTags->{"Closed Chain", "i:8"}],

Cell[BoxData[
    \("Eliminating specified coordinates."\)], "Print",
  CellLabel->"From In[43]:=",
  CellTags->{"Closed Chain", "i:8"}],

Cell[BoxData[
    \({{{1\/4\ \((3\ L1\^2\ m1 + 2\ L2\^2\ m1 + 2\ L1\^2\ m2 + 3\ L2\^2\ m2 + 
                2\ L1\^2\ m2\ Cos[2\ theta1] + 
                2\ L1\ L2\ \((m1 + m2)\)\ Cos[theta2] - 
                2\ L2\^2\ m1\ Cos[2\ \((theta1 + theta2)\)] - 
                2\ L1\ L2\ m1\ Cos[2\ theta1 + theta2] + 
                2\ L1\ L2\ m2\ Cos[
                    2\ theta1 + 
                      theta2])\), \(-\(1\/4\)\)\ L2\ \((\(-2\)\ L2\ m1 - 
                3\ L2\ m2 - L1\ \((m1 + m2)\)\ Cos[theta2] + 
                2\ L2\ m1\ Cos[2\ \((theta1 + theta2)\)] + 
                L1\ m1\ Cos[2\ theta1 + theta2] - 
                L1\ m2\ Cos[
                    2\ theta1 + 
                      theta2])\)}, {\(-\(1\/4\)\)\ L2\ \((\(-2\)\ L2\ m1 - 
                3\ L2\ m2 - L1\ \((m1 + m2)\)\ Cos[theta2] + 
                2\ L2\ m1\ Cos[2\ \((theta1 + theta2)\)] + 
                L1\ m1\ Cos[2\ theta1 + theta2] - 
                L1\ m2\ Cos[
                    2\ theta1 + 
                      theta2])\), \(-\(1\/4\)\)\ L2\^2\ \((\(-2\)\ m1 - 
                3\ m2 + 
                2\ m1\ Cos[
                    2\ \((theta1 + 
                          theta2)\)])\)}}, {{1\/8\ \((\(-4\)\ L1\^2\ m2\ w1\ \
Sin[2\ theta1] + 
                L2\ \((\(-L1\)\ \((3\ m1 + m2)\)\ w2\ Sin[theta2] + 
                      4\ L2\ m1\ \((w1 + w2)\)\ Sin[
                          2\ \((theta1 + theta2)\)] + 
                      L1\ \((4\ m1\ w1 - 4\ m2\ w1 + m1\ w2 - 
                            3\ m2\ w2)\)\ Sin[2\ theta1 + theta2])\))\), 
          1\/8\ L2\ \((\(-L1\)\ \((m1\ w1 + 3\ m2\ w1 + 2\ m1\ w2 + 
                      2\ m2\ w2)\)\ Sin[theta2] + 
                4\ L2\ m1\ \((w1 + w2)\)\ Sin[2\ \((theta1 + theta2)\)] + 
                L1\ \((3\ m1\ w1 - m2\ w1 + 2\ m1\ w2 - 2\ m2\ w2)\)\ Sin[
                    2\ theta1 + theta2])\)}, {1\/8\ L2\ \((L1\ \((2\ m1\ w1 + 
                      m2\ \((2\ w1 + w2)\))\)\ Sin[theta2] + 
                4\ L2\ m1\ \((w1 + w2)\)\ Sin[2\ \((theta1 + theta2)\)] + 
                L1\ \((2\ m1\ w1 - 2\ m2\ w1 + m2\ w2)\)\ Sin[
                    2\ theta1 + theta2])\), 
          1\/4\ L2\ \((\(-L1\)\ m2\ w1\ Cos[theta1] + 
                4\ L2\ m1\ \((w1 + w2)\)\ Cos[theta1 + theta2])\)\ Sin[
              theta1 + theta2]}}, {0, 0}, {{1, 0}, {0, 1}}, {w1, 
        w2}, {theta1, theta2}}\)], "Output",
  CellLabel->"Out[43]=",
  CellTags->{"Closed Chain", "i:8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Simplify[Cm.phat]", "Input",
  CellLabel->"In[44]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Closed Chain", "i:8"}],

Cell[BoxData[
    \({1\/8\ \((L2\ w2\ \((\(-L1\)\ \((m1\ w1 + 3\ m2\ w1 + 2\ m1\ w2 + 
                        2\ m2\ w2)\)\ Sin[theta2] + 
                  4\ L2\ m1\ \((w1 + w2)\)\ Sin[2\ \((theta1 + theta2)\)] + 
                  L1\ \((3\ m1\ w1 - m2\ w1 + 2\ m1\ w2 - 2\ m2\ w2)\)\ Sin[
                      2\ theta1 + theta2])\) + 
            w1\ \((\(-4\)\ L1\^2\ m2\ w1\ Sin[2\ theta1] + 
                  L2\ \((\(-L1\)\ \((3\ m1 + m2)\)\ w2\ Sin[theta2] + 
                        4\ L2\ m1\ \((w1 + w2)\)\ Sin[
                            2\ \((theta1 + theta2)\)] + 
                        L1\ \((4\ m1\ w1 - 4\ m2\ w1 + m1\ w2 - 
                              3\ m2\ w2)\)\ Sin[2\ theta1 + theta2])\))\))\), 
      1\/8\ L2\ \((2\ w2\ \((\(-L1\)\ m2\ w1\ Cos[theta1] + 
                  4\ L2\ m1\ \((w1 + w2)\)\ Cos[theta1 + theta2])\)\ Sin[
                theta1 + theta2] + 
            w1\ \((L1\ \((2\ m1\ w1 + m2\ \((2\ w1 + w2)\))\)\ Sin[theta2] + 
                  4\ L2\ m1\ \((w1 + w2)\)\ Sin[2\ \((theta1 + theta2)\)] + 
                  L1\ \((2\ m1\ w1 - 2\ m2\ w1 + m2\ w2)\)\ Sin[
                      2\ theta1 + theta2])\))\)}\)], "Output",
  CellLabel->"Out[44]=",
  CellTags->{"Closed Chain", "i:8"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
The Rolling Disk: a Classic Example of Differential Constraints\
\>", "Subsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell["\<\
As an illustration we take an example from Neimark and Fufaev. Consider a \
disk that rolls without slipping on the x-y plane (z is up). Assume that the \
disk is of mass m and radius R. One approach is to ignore the the rolling \
constraints and formulate the equations of motion for the free disk in space, \
and then add the required constraints. A body frame is established with \
origin at the center of the disk. The six degree of freedom, simple joint is \
defined by: \
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{

Cell["\<\
r={6};
H=IdentityMatrix[6]\
\>", "Input",
  CellLabel->"In[45]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[BoxData[
    \({{1, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 0}, {0, 0, 0, 
        1, 0, 0}, {0, 0, 0, 0, 1, 0}, {0, 0, 0, 0, 0, 1}}\)], "Output",
  CellLabel->"Out[46]=",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell["\<\
q={psi,theta,phi,x,y,z};
p={wx,wy,wz,vx,vy,vz};
JointList={{r,H,q,p}};
\
\>", "Input",
  CellLabel->"In[47]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell["\<\
In this setup the x,y,z coordinates locate the center of the disk in the \
space frame and psi, theta, phi are Euler angles in the z-y-x (or 3-2-1) \
convention. 
The body data is:\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell["\<\
(* reassign som variables *)
g=\"g\"; m=\"m\"; J=\"J\"; Iy=\"Iy\"; R=\"R\";\
\>", "Input",
  CellLabel->"In[50]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell["\<\
Mass=m; CenterOfMass={0,0,0}; OutboardNode={2,{0,-R*Sin[psi],-R*Cos[psi]}};
InertiaMatrix=DiagonalMatrix[{J,Iy,Iy}];
BodyList={{CenterOfMass,{OutboardNode},Mass,InertiaMatrix}};\
\>", "Input",
  CellLabel->"In[52]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell["and the remaining data:", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell["\<\
TreeList={{{1,1}}};
PE=0; Q={0,0,0,0,0,0};\
\>", "Input",
  CellLabel->"In[55]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell["The unconstrained disk model is obtained with", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{

Cell["\<\
{V,X,H,M,Cp,Fp,p,q}=CreateModel[JointList,BodyList,TreeList,g,PE,Q];\
\>", "Input",
  CellLabel->"In[57]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[BoxData[
    \("Computing Joint Kinematics"\)], "Print",
  CellLabel->"From In[57]:=",
  CellTags->{"i:9", "Rolling Disk"}],

Cell[BoxData[
    \("Computing joint 1 kinematics"\)], "Print",
  CellLabel->"From In[57]:=",
  CellTags->{"i:9", "Rolling Disk"}],

Cell[BoxData[
    \("Computing Potential Functions"\)], "Print",
  CellLabel->"From In[57]:=",
  CellTags->{"i:9", "Rolling Disk"}],

Cell[BoxData[
    \("Computing Inertia Matrix"\)], "Print",
  CellLabel->"From In[57]:=",
  CellTags->{"i:9", "Rolling Disk"}],

Cell[BoxData[
    \("Computing Poincare Function"\)], "Print",
  CellLabel->"From In[57]:=",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell["\<\
Now, we formulate the differential constraints. Rolling without slipping \
implies that the velocity of the disk contact point must be zero. An \
expression for the (angular and translational) velocity at the outboard node \
as a function of the configuration variables is easily obtained using the \
function EndEffectorVelocity or NodeVelocity.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{

Cell["\<\
{ChainList}=TreeList;
VCont=NodeVelocity[ChainList,BodyList,X,H,p]\
\>", "Input",
  CellLabel->"In[58]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[BoxData[
    \({wx, wy, wz, vx - "R"\ wy\ Cos[psi] + "R"\ wz\ Sin[psi], 
      vy + "R"\ wx\ Cos[psi], vz - "R"\ wx\ Sin[psi]}\)], "Output",
  CellLabel->"Out[59]=",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell["\<\
The rolling constraint requires that the translation velocity of the contact \
point (the last three of the elements of the six\[CapitalEth]vector VCont) be \
zero. Thus, we obtain the constrained system:\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{

Cell["\<\
{Mm,Cm,Fm,Vm,T,phat}=DifferentialConstraints[M,Cp,Fp,V,VCont[[Range[4,6]]],p,\
q,{4,5,6}];\
\>", "Input",
  CellLabel->"In[60]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[BoxData[
    \("Vm"\)], "Print",
  CellLabel->"From In[60]:=",
  CellTags->{"i:9", "Rolling Disk"}],

Cell[BoxData[
    \("Mm"\)], "Print",
  CellLabel->"From In[60]:=",
  CellTags->{"i:9", "Rolling Disk"}],

Cell[BoxData[
    \("Cm"\)], "Print",
  CellLabel->"From In[60]:=",
  CellTags->{"i:9", "Rolling Disk"}],

Cell[BoxData[
    \("Fm"\)], "Print",
  CellLabel->"From In[60]:=",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell["\<\
The dynamics are reduced to three dimensions and the original six quasi\
\[CapitalEth]velocities are reduced to three, in fact, we have:\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{

Cell["phat", "Input",
  CellLabel->"In[61]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[BoxData[
    \({wx, wy, wz}\)], "Output",
  CellLabel->"Out[61]=",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell["\<\
The set of configuration coordinates is not reduced by the function \
DiffConstrainedSys. In general, a set of differential constraints may not \
admit any such reduction. Such would be the case if the constraints were \
completely nonholonomic. In the present case, however, the constraints are \
'partially' integrable and from basic geometry one can see that (cg) hight = \
Rcos(theta)-R. Using this relationship, the coordinate z can be eliminated \
from the equations.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{

Cell["{Sols}=Solve[{X[[1]][[3,4]]==R*(Cos[theta]-1)},{z}]", "Input",
  CellLabel->"In[62]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[BoxData[
    \({{z \[Rule] "R"\ \((\(-1\) + Cos[theta])\)}}\)], "Output",
  CellLabel->"Out[62]=",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell["\<\
Because the translation parameters x,y,z are, in fact, the space coordinates, \
z is precisely the hight of the center of gravity. Inspection shows that only \
Mm and Vm depend on z so we define:\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell["Mmo=Simplify[Mm/.Sols];", "Input",
  CellLabel->"In[63]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell["Vmo=Simplify[Vm[[ {1,2,3,4,5} ]]/.Sols];", "Input",
  CellLabel->"In[64]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell["Now, we assemble the governing equations.", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{

Cell["Eqns=MakeODEs[phat,q[[{1,2,3,4,5}]],Vmo,Mmo,Cm,Fm,t]", "Input",
  CellLabel->"In[65]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["psi", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], 
          "==", \(wx[t] + Sin[psi[t]]\ Tan[theta[t]]\ wy[t] + 
            Cos[psi[t]]\ Tan[theta[t]]\ wz[t]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["theta", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], 
          "==", \(Cos[psi[t]]\ wy[t] - Sin[psi[t]]\ wz[t]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["phi", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], 
          "==", \(Sec[theta[t]]\ Sin[psi[t]]\ wy[t] + 
            Cos[psi[t]]\ Sec[theta[t]]\ wz[t]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["x", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], 
          "==", \("R"\ Sin[phi[t]]\ wx[t] + 
            "R"\ Cos[phi[t]]\ Cos[psi[t]]\ Cos[theta[t]]\ wy[t] - 
            "R"\ Cos[phi[t]]\ Cos[theta[t]]\ Sin[psi[t]]\ wz[t]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], 
          "==", \(\(-"R"\)\ Cos[phi[t]]\ wx[t] + 
            "R"\ Cos[psi[t]]\ Cos[theta[t]]\ Sin[phi[t]]\ wy[t] - 
            "R"\ Cos[theta[t]]\ Sin[phi[t]]\ Sin[psi[t]]\ wz[t]\)}], ",", 
        RowBox[{
          
          RowBox[{\(wy[
                t]\ \((\(-"Iy"\)\ wz[t] + 
                  "R"\ Cos[
                      psi[t]]\ \((\(-"m"\)\ "R"\ Sin[psi[t]]\ wy[t] - 
                        "m"\ "R"\ Cos[psi[t]]\ wz[t])\))\)\), 
            "+", \(wz[
                t]\ \(("Iy"\ wy[t] - 
                  "R"\ Sin[
                      psi[t]]\ \((\(-"m"\)\ "R"\ Sin[psi[t]]\ wy[t] - 
                        "m"\ "R"\ Cos[psi[t]]\ wz[t])\))\)\), "+", 
            RowBox[{\(("J" + "m"\ "R"\^2)\), " ", 
              RowBox[{
                SuperscriptBox["wx", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}]}], "==", "0"}], 
        ",", 
        RowBox[{
          
          RowBox[{\(\(-"g"\)\ "m"\ "R"\ Cos[psi[t]]\ Sin[theta[t]]\), 
            "+", \(wz[
                t]\ \((\(-"Iy"\)\ wx[t] - 
                  "m"\ "R"\^2\ Sin[psi[t]]\^2\ wx[t] + 
                  "m"\ "R"\ Cos[psi[t]]\^2\ Tan[
                      theta[t]]\ \((\(-"R"\)\ Sin[psi[t]]\ wy[t] - 
                        "R"\ Cos[psi[t]]\ wz[t])\))\)\), 
            "+", \(wy[
                t]\ \(("m"\ "R"\^2\ Cos[psi[t]]\ Sin[psi[t]]\ wx[t] + 
                  "m"\ "R"\ Cos[psi[t]]\ Sin[psi[t]]\ Tan[
                      theta[t]]\ \((\(-"R"\)\ Sin[psi[t]]\ wy[t] - 
                        "R"\ Cos[psi[t]]\ wz[t])\))\)\), 
            "+", \(wx[
                t]\ \(("J"\ wz[t] + "m"\ "R"\^2\ Cos[psi[t]]\^2\ wz[t] + 
                  "m"\ "R"\ Cos[
                      psi[t]]\ \((\(-"R"\)\ Sin[psi[t]]\ wy[t] - 
                        "R"\ Cos[psi[t]]\ wz[t])\) + 
                  "R"\ Sin[
                      psi[t]]\ \(("m"\ "R"\ Cos[psi[t]]\ wy[t] - 
                        "m"\ \(("R"\ Cos[psi[t]]\ wy[t] - 
                              "R"\ Sin[psi[t]]\ wz[t])\))\))\)\), "+", 
            RowBox[{\(("Iy" + "m"\ "R"\^2\ Cos[psi[t]]\^2)\), " ", 
              RowBox[{
                SuperscriptBox["wy", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "-", 
            
            RowBox[{"\<\"m\"\>", " ", \("R"\^2\), " ", \(Cos[psi[t]]\), 
              " ", \(Sin[psi[t]]\), " ", 
              RowBox[{
                SuperscriptBox["wz", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}]}], "==", "0"}], 
        ",", 
        RowBox[{
          
          RowBox[{\("g"\ "m"\ "R"\ Sin[psi[t]]\ Sin[theta[t]]\), 
            "+", \(wz[
                t]\ \((\(-"m"\)\ "R"\^2\ Cos[psi[t]]\ Sin[psi[t]]\ wx[t] - 
                  "m"\ "R"\ Cos[psi[t]]\ Sin[psi[t]]\ Tan[
                      theta[t]]\ \((\(-"R"\)\ Sin[psi[t]]\ wy[t] - 
                        "R"\ Cos[psi[t]]\ wz[t])\))\)\), 
            "+", \(wy[
                t]\ \(("Iy"\ wx[t] + "m"\ "R"\^2\ Cos[psi[t]]\^2\ wx[t] - 
                  "m"\ "R"\ Sin[psi[t]]\^2\ Tan[
                      theta[t]]\ \((\(-"R"\)\ Sin[psi[t]]\ wy[t] - 
                        "R"\ Cos[psi[t]]\ wz[t])\))\)\), 
            "+", \(wx[
                t]\ \((\(-"J"\)\ wy[t] - "m"\ "R"\^2\ Sin[psi[t]]\^2\ wy[t] - 
                  "m"\ "R"\ Sin[
                      psi[t]]\ \((\(-"R"\)\ Sin[psi[t]]\ wy[t] - 
                        "R"\ Cos[psi[t]]\ wz[t])\) - 
                  "R"\ Cos[
                      psi[t]]\ \(("m"\ "R"\ Sin[psi[t]]\ wz[t] + 
                        "m"\ \(("R"\ Cos[psi[t]]\ wy[t] - 
                              "R"\ Sin[psi[t]]\ wz[t])\))\))\)\), "-", 
            RowBox[{"\<\"m\"\>", " ", \("R"\^2\), " ", \(Cos[psi[t]]\), 
              " ", \(Sin[psi[t]]\), " ", 
              RowBox[{
                SuperscriptBox["wy", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{\(("Iy" + "m"\ "R"\^2\ Sin[psi[t]]\^2)\), " ", 
              RowBox[{
                SuperscriptBox["wz", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}]}], "==", 
          "0"}]}], "}"}]], "Output",
  CellLabel->"Out[65]=",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell["\<\
Since x,y,z locate the center of gravity it is of interest to compute the \
contact point.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell["\<\
ChnBodyList={{CenterOfMass,{0,-R*Sin[psi],-R*Cos[psi]},Mass,InertiaMatrix}};
\
\>", "Input",
  CellLabel->"In[66]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{

Cell["\<\
{ContactPoint}=Simplify[Transpose[EndEffector[ChnBodyList,X][[{1,2,3},{4}]]]/.\
Sols]\
\>", "Input",
  CellLabel->"In[67]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[BoxData[
    \({{x - "R"\ Cos[phi]\ Sin[theta], 
        y - "R"\ Sin[phi]\ Sin[theta], \(-"R"\)}}\)], "Output",
  CellLabel->"Out[67]=",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell["\<\
Consider the equations of motion as given by the list Eqns. Careful \
inspection of the equations suggests that representation of the angular \
velocity in a fame that does not rotate about the body-x axis may simplify \
them. Thus, we transform the angular velocity coordinates, wy, wz, via the \
relations:\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{

Cell["\<\
a1=wyy[t]==Cos[psi[t]]*wy[t]-Sin[psi[t]]*wz[t]
a2=wzz[t]==Sin[psi[t]]*wy[t]+Cos[psi[t]]*wz[t]
\
\>", "Input",
  CellLabel->"In[68]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[BoxData[
    \(wyy[t] == Cos[psi[t]]\ wy[t] - Sin[psi[t]]\ wz[t]\)], "Output",
  CellLabel->"Out[68]=",
  CellTags->{"i:9", "Rolling Disk"}],

Cell[BoxData[
    \(wzz[t] == Sin[psi[t]]\ wy[t] + Cos[psi[t]]\ wz[t]\)], "Output",
  CellLabel->"Out[69]=",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell["\<\
The inverse transformation rules are obtained using Mathematica's Solve \
function\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{

Cell["Trans=Simplify[Flatten[Solve[{a1,a2},{wy[t],wz[t]}]]]", "Input",
  CellLabel->"In[70]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[BoxData[
    \({wy[t] \[Rule] Cos[psi[t]]\ wyy[t] + Sin[psi[t]]\ wzz[t], 
      wz[t] \[Rule] \(-Sin[psi[t]]\)\ wyy[t] + 
          Cos[psi[t]]\ wzz[t]}\)], "Output",
  CellLabel->"Out[70]=",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell["\<\
The transformed equations are obtained with the function StateTransformation:\
\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{

Cell["StateVars={psi,theta,phi,x,y,wx,wy,wz}", "Input",
  CellLabel->"In[71]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[BoxData[
    \({psi, theta, phi, x, y, wx, wy, wz}\)], "Output",
  CellLabel->"Out[71]=",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["TrEqns=StateTransformation[Eqns,StateVars,Trans,{wyy,wzz},t]", "Input",
  CellLabel->"In[72]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["theta", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", \(wyy[t]\)}], 
        ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["phi", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], 
          "==", \(Sec[theta[t]]\ wzz[t]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["x", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], 
          "==", \("R"\ \((Sin[phi[t]]\ wx[t] + 
                Cos[phi[t]]\ Cos[theta[t]]\ wyy[t])\)\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], 
          "==", \(\(-"R"\)\ Cos[phi[t]]\ wx[t] + 
            "R"\ Cos[theta[t]]\ Sin[phi[t]]\ wyy[t]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["wx", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], 
          "==", \(\("m"\ "R"\^2\ wyy[t]\ wzz[t]\)\/\("J" + "m"\ "R"\^2\)\)}], 
        ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["wzz", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], 
          "==", \(wyy[
              t]\ \((\("J"\ wx[t]\)\/"Iy" + Tan[theta[t]]\ wzz[t])\)\)}], ",",
         
        RowBox[{
          RowBox[{
            SuperscriptBox["wyy", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], 
          "==", \(\("g"\ "m"\ "R"\ Sin[
                    theta[t]] - \(("J" + "m"\ "R"\^2)\)\ wx[t]\ wzz[t] - 
                "Iy"\ Tan[theta[t]]\ wzz[t]\^2\)\/\("Iy" + "m"\ "R"\^2\)\)}], 
        ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["psi", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], 
          "==", \(wx[t] + Tan[theta[t]]\ wzz[t]\)}]}], "}"}]], "Output",
  CellLabel->"Out[72]=",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell["\<\
These equations are obviously equivalent to thedisk equations given by \
Neimark and Fufaev. Another derivation is given by Meirovitch. To compare our \
equations with his, it is necessary to reduce them to second order form by \
eliminating the quasi-velociites (thus, we get Lagrange's equations), and to \
perform a minor transformation of angular coordinates:\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{

Cell["\<\
Rules1=Flatten[Solve[TrEqns[[{1,2,8}]],{wx[t],wyy[t],wzz[t]}]]\
\>", "Input",
  CellLabel->"In[73]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{\(wx[t]\), "\[Rule]", 
          RowBox[{
            RowBox[{\(-Sin[theta[t]]\), " ", 
              RowBox[{
                SuperscriptBox["phi", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{
              SuperscriptBox["psi", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}]}], ",", 
        RowBox[{\(wyy[t]\), "\[Rule]", 
          RowBox[{
            SuperscriptBox["theta", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}], ",", 
        RowBox[{\(wzz[t]\), "\[Rule]", 
          RowBox[{\(Cos[theta[t]]\), " ", 
            RowBox[{
              SuperscriptBox["phi", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}]}]}], 
      "}"}]], "Output",
  CellLabel->"Out[73]=",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Rules2={wx'[t]->D[wx[t]/.Rules1,t],
        wyy'[t]->D[wyy[t]/.Rules1,t],
        wzz'[t]->D[wzz[t]/.Rules1,t]}\
\>", "Input",
  CellLabel->"In[74]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["wx", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
          RowBox[{
            RowBox[{\(-Cos[theta[t]]\), " ", 
              RowBox[{
                SuperscriptBox["phi", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], " ", 
              RowBox[{
                SuperscriptBox["theta", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "-", 
            RowBox[{\(Sin[theta[t]]\), " ", 
              RowBox[{
                SuperscriptBox["phi", "\[Prime]\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{
              SuperscriptBox["psi", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["wyy", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
          RowBox[{
            SuperscriptBox["theta", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["wzz", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
          RowBox[{
            RowBox[{\(-Sin[theta[t]]\), " ", 
              RowBox[{
                SuperscriptBox["phi", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], " ", 
              RowBox[{
                SuperscriptBox["theta", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{\(Cos[theta[t]]\), " ", 
              RowBox[{
                SuperscriptBox["phi", "\[Prime]\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}]}]}]}], 
      "}"}]], "Output",
  CellLabel->"Out[74]=",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Rules3={theta[t]->th[t]-Pi/2,
        theta'[t]->th'[t],
        theta''[t]->th''[t]}\
\>", "Input",
  CellLabel->"In[75]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(theta[t] \[Rule] \(-\(\[Pi]\/2\)\) + th[t]\), ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["theta", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
          RowBox[{
            SuperscriptBox["th", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["theta", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
          RowBox[{
            SuperscriptBox["th", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}]}], "}"}]], "Output",\

  CellLabel->"Out[75]=",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Rules4={phi[t]->-pi/2+ph[t],
        phi'[t]->ph'[t],
        phi''[t]->ph''[t]}\
\>", "Input",
  CellLabel->"In[76]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(phi[t] \[Rule] \(-\(pi\/2\)\) + ph[t]\), ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["phi", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
          RowBox[{
            SuperscriptBox["ph", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["phi", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "\[Rule]", 
          RowBox[{
            SuperscriptBox["ph", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}]}], "}"}]], "Output",\

  CellLabel->"Out[76]=",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LagEqns=Simplify[TrEqns[[{5,6,7}]]/.Rules1/.Rules2/.Rules3/.Rules4]\
\>", "Input",
  CellLabel->"In[77]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{\(Cos[th[t]]\), " ", 
              RowBox[{
                SuperscriptBox["ph", "\[Prime]\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], "+", 
            RowBox[{
              SuperscriptBox["psi", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], "==", 
          FractionBox[
            RowBox[{\(("J" + 2\ "m"\ "R"\^2)\), " ", \(Sin[th[t]]\), " ", 
              RowBox[{
                SuperscriptBox["ph", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], " ", 
              RowBox[{
                SuperscriptBox["th", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}]}], \("J" + 
              "m"\ "R"\^2\)]}], ",", 
        RowBox[{
          FractionBox[
            RowBox[{
              RowBox[{\((2\ "Iy" - "J")\), " ", \(Cos[th[t]]\), " ", 
                RowBox[{
                  SuperscriptBox["ph", "\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}], " ", 
                RowBox[{
                  SuperscriptBox["th", "\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], "-", 
              RowBox[{"\<\"J\"\>", " ", 
                RowBox[{
                  SuperscriptBox["psi", "\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}], " ", 
                RowBox[{
                  SuperscriptBox["th", "\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], "+", 
              RowBox[{"\<\"Iy\"\>", " ", \(Sin[th[t]]\), " ", 
                RowBox[{
                  SuperscriptBox["ph", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "t", 
                  "]"}]}]}], "\<\"Iy\"\>"], "==", "0"}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["th", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "t", "]"}], "==", 
          RowBox[{\(1\/\("Iy" + "m"\ "R"\^2\)\), 
            RowBox[{"(", 
              RowBox[{\(\(-"g"\)\ "m"\ "R"\ Cos[th[t]]\), "+", 
                
                RowBox[{"\<\"Iy\"\>", " ", \(Cos[th[t]]\), 
                  " ", \(Sin[th[t]]\), " ", 
                  SuperscriptBox[
                    RowBox[{
                      SuperscriptBox["ph", "\[Prime]",
                        MultilineFunction->None], "[", "t", "]"}], "2"]}], 
                "-", 
                RowBox[{\(("J" + "m"\ "R"\^2)\), " ", \(Sin[th[t]]\), " ", 
                  RowBox[{
                    SuperscriptBox["ph", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}], " ", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{\(Cos[th[t]]\), " ", 
                        RowBox[{
                          SuperscriptBox["ph", "\[Prime]",
                            MultilineFunction->None], "[", "t", "]"}]}], "+", 
                      
                      RowBox[{
                        SuperscriptBox["psi", "\[Prime]",
                          MultilineFunction->None], "[", "t", "]"}]}], 
                    ")"}]}]}], ")"}]}]}]}], "}"}]], "Output",
  CellLabel->"Out[77]=",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell["\<\
These equations are easily confirmed to be equivalent to those given by \
Meirovitch.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->{"Rolling Disk", "i:9"}]
}, Closed]],

Cell[CellGroupData[{

Cell["A Rigid Drive Train", "Subsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell["\<\
The system is a chain consisting of 3 bodies (coupler, forward shaft and aft \
shaft), 3 joints (one revolute andtwo universal) and and one constraints \
(cylindrical). \
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell[CellGroupData[{

Cell["Body Data", "Subsubsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell["Body 1: Coupler", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell[CellGroupData[{

Cell["\<\
com1={0,0,0}; mass1=12925.9; out1={{2,{0,0,0}}};
Inertia1=DiagonalMatrix[{3.6112 10^5,3.8792 10^5,3.6794 10^5}];

Body1={com1,out1,mass1,Inertia1};
\
\>", "Input",
  CellLabel->"In[78]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell[BoxData[
    \(General::"spell1" \(\(:\)\(\ \)\) 
      "Possible spelling error: new symbol name \"\!\(mass1\)\" is similar to \
existing symbol \"\!\(Mass1\)\"."\)], "Message",
  CellLabel->"From In[78]:=",
  CellTags->"Drive Chain"]
}, Open  ]],

Cell["Body 2: Forward Shaft", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell[CellGroupData[{

Cell["\<\
com2={0,175/2,0}; mass2=24232.2; out2={{3,{0,175,0}}};
Inertia2=DiagonalMatrix[{(mass2*(3*25^2+175^2))/12,(mass2*25^2)/2,(mass2*(3*\
25^2+175^2))/12}];

Body2={com2,out2,mass2,Inertia2};\
\>", "Input",
  CellLabel->"In[81]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell[BoxData[
    \(General::"spell1" \(\(:\)\(\ \)\) 
      "Possible spelling error: new symbol name \"\!\(mass2\)\" is similar to \
existing symbol \"\!\(Mass2\)\"."\)], "Message",
  CellLabel->"From In[81]:=",
  CellTags->"Drive Chain"]
}, Open  ]],

Cell["Body 3: Aft Shaft", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell["\<\
com3={0,10,0}; mass3=19618.8; out3={{6,{0,10,0}},{4,{0,20,0}}};
Inertia3=DiagonalMatrix[{2.2558 10^6,2.8837 10^5,2.2416 10^6}];

Body3={com3,out3,mass3,Inertia3};\
\>", "Input",
  CellLabel->"In[84]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell[CellGroupData[{

Cell["BodyLst=Chop[{Body1,Body2,Body3},10^-5];", "Input",
  CellLabel->"In[87]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell[BoxData[
    \(General::"spell1" \(\(:\)\(\ \)\) 
      "Possible spelling error: new symbol name \"\!\(BodyLst\)\" is similar \
to existing symbol \"\!\(BodyList\)\"."\)], "Message",
  CellLabel->"From In[87]:=",
  CellTags->"Drive Chain"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Joint Data", "Subsubsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell["Joint 1: Revolute", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12,
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1],
  CellTags->"Drive Chain"],

Cell["\<\
r1={1};H1={{0},{1},{0},{0},{0},{0}};
q1={a1y};p1={w1y};
Joint1={r1,H1,q1,p1};\
\>", "Input",
  CellLabel->"In[88]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell["Joints 2 and 3: Universal", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  FontFamily->"Times New Roman",
  FontSize->12,
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1],
  CellTags->"Drive Chain"],

Cell["\<\
r2={1,1};H2={{1,0},{0,0},{0,1},{0,0},{0,0},{0,0}};
q2={a2x,a2z};p2={w2x,w2z};
Joint2={r2,H2,q2,p2};\
\>", "Input",
  CellLabel->"In[91]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell["\<\
Universal joints have singularities which restritc them to 'local' two degree \
of freedom rotations, if the joint operates within the allowable limits the \
relative motion is equivalent to a spherical joint. Treating universal joints \
a spherical generally produces simpler dynamical equations. For variety, we \
do that with the last three joints.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell[CellGroupData[{

Cell["\<\
r3={1,1};H3={{1,0},{0,0},{0,1},{0,0},{0,0},{0,0}};
q3={a3x,a3z};p3={w3x,w3z};
Joint3={r3,H3,q3,p3};


JointLst={Joint1,Joint2,Joint3};
\
\>", "Input",
  CellLabel->"In[94]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell[BoxData[
    \(General::"spell1" \(\(:\)\(\ \)\) 
      "Possible spelling error: new symbol name \"\!\(JointLst\)\" is similar \
to existing symbol \"\!\(JointList\)\"."\)], "Message",
  CellLabel->"From In[94]:=",
  CellTags->"Drive Chain"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Tree Definition", "Subsubsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell["The tree consists of one chain, so we have:", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell[CellGroupData[{

Cell["TreeLst={{{1,1},{2,2},{3,3}}};", "Input",
  CellLabel->"In[98]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell[BoxData[
    \(General::"spell1" \(\(:\)\(\ \)\) 
      "Possible spelling error: new symbol name \"\!\(TreeLst\)\" is similar \
to existing symbol \"\!\(TreeList\)\"."\)], "Message",
  CellLabel->"From In[98]:=",
  CellTags->"Drive Chain"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["The Unconstrained Tree Model", "Subsubsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell["PE=0;Q={0,0,0,0,0};", "Input",
  CellLabel->"In[99]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell[CellGroupData[{

Cell["{V,X,H}=Joints[JointLst];", "Input",
  CellLabel->"In[100]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell[BoxData[
    \("Computing joint 1 kinematics"\)], "Print",
  CellLabel->"From In[100]:=",
  CellTags->"Drive Chain"],

Cell[BoxData[
    \("Computing joint 2 kinematics"\)], "Print",
  CellLabel->"From In[100]:=",
  CellTags->"Drive Chain"],

Cell[BoxData[
    \("Computing joint 3 kinematics"\)], "Print",
  CellLabel->"From In[100]:=",
  CellTags->"Drive Chain"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
{V,X,H,M,Cp,Fp,p,q}=CreateModel[JointLst,BodyLst,TreeLst,0,PE,Q,V,X,H];\
\>", "Input",
  CellLabel->"In[101]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell[BoxData[
    \("Computing Potential Functions"\)], "Print",
  CellLabel->"From In[101]:=",
  CellTags->"Drive Chain"],

Cell[BoxData[
    \("Computing Inertia Matrix"\)], "Print",
  CellLabel->"From In[101]:=",
  CellTags->"Drive Chain"],

Cell[BoxData[
    \("Computing Poincare Function"\)], "Print",
  CellLabel->"From In[101]:=",
  CellTags->"Drive Chain"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Adding the Constraints", "Subsubsection",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell["\<\
There are two algebraic constraint sets. One at node 3 of the fore shaft \
constrains the node x-z coordinates. Similarly, the second applies at node 4 \
of the aft shaft and fixes its x and z coordinates. To set up the \
constraints, we compute the relevent node locations (3 and 4) in the space \
frame using the EndEffector function.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell["\<\
AftShaftPos=Chop[EndEffector[4,TreeLst,BodyLst,X],10^-5];
Gangles={AftShaftPos[[1,2]],AftShaftPos[[2,1]],AftShaftPos[[2,3]],
    AftShaftPos[[2,2]]-1,AftShaftPos[[3,2]]};
ForeShaftPos=Chop[EndEffector[3,TreeLst,BodyLst,X],10^-5];\
\>", "Input",
  CellLabel->"In[102]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell["\<\
G={ForeShaftPos[[1,4]]/175-alpha,ForeShaftPos[[3,4]]/175+alpha,
    AftShaftPos[[1,4]]/175-alpha,AftShaftPos[[3,4]]/175+alpha};
Gs=SeriesExpansion[G,{a2x,a2z,a3x,a3z},1];\
\>", "Input",
  CellLabel->"In[105]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell["\<\
Ms=Chop[N[SeriesExpansion[M/10^8,{a2x,a2z,a3x,a3z},1]],10^-4];
Cps=Chop[N[SeriesExpansion[Cp/10^8,{a2x,a2z,a3x,a3z},1]],10^-4];
Fps=Fp/10^8;\
\>", "Input",
  CellLabel->"In[107]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell["Vs=V;", "Input",
  CellLabel->"In[110]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell[CellGroupData[{

Cell["\<\
{Mm,Cm,Fm,Vm,phat,qhat}=AlgebraicConstraints[Ms,Cps,Fps,Vs,Gs,p,q,{2,3,4,5},{\
2,3,4,5},{2,3,4,5}];\
\>", "Input",
  CellLabel->"In[111]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell[BoxData[
    \("Vm"\)], "Print",
  CellLabel->"From In[111]:=",
  CellTags->"Drive Chain"],

Cell[BoxData[
    \("Mm"\)], "Print",
  CellLabel->"From In[111]:=",
  CellTags->"Drive Chain"],

Cell[BoxData[
    \("Cm"\)], "Print",
  CellLabel->"From In[111]:=",
  CellTags->"Drive Chain"],

Cell[BoxData[
    \("Fm"\)], "Print",
  CellLabel->"From In[111]:=",
  CellTags->"Drive Chain"],

Cell[BoxData[
    \("Eliminating specified coordinates."\)], "Print",
  CellLabel->"From In[111]:=",
  CellTags->"Drive Chain"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mm", "Input",
  CellLabel->"In[112]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell[BoxData[
    \({{\(\(0.082488525`\)\(\[InvisibleSpace]\)\) - 
          16.888196874999995`\ alpha\^2\ Cos[a1y]\^2 - 
          0.32597209999999777`\ alpha\^2\ Cos[a1y]\ Sin[a1y] - 
          16.888196874999995`\ alpha\^2\ Sin[a1y]\^2}}\)], "Output",
  CellLabel->"Out[112]=",
  CellTags->"Drive Chain"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cm", "Input",
  CellLabel->"In[113]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell[BoxData[
    \({{\(-0.0014418499999999668`\)\ alpha\^4\ w1y\ Cos[a1y]\^4 - 
          0.7563091`\ alpha\^4\ w1y\ Cos[a1y]\^3\ Sin[a1y] + 
          alpha\^2\ w1y\ Sin[a1y]\^2\ \((\(\(0.12223953749999783`\)\(\
\[InvisibleSpace]\)\) + 0.0014418499999999668`\ alpha\^2\ Sin[a1y]\^2)\) + 
          Cos[a1y]\^2\ \((\(-0.12223953749999872`\)\ alpha\^2\ w1y + 
                0.`\ alpha\^4\ w1y\ Sin[a1y]\^2)\) + 
          Cos[a1y]\ \((0.`\ alpha\^2\ w1y\ Sin[a1y] + 
                0.7563091`\ alpha\^4\ w1y\ Sin[a1y]\^3)\)}}\)], "Output",
  CellLabel->"Out[113]=",
  CellTags->"Drive Chain"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fm", "Input",
  CellLabel->"In[114]:=",
  PageWidth->Infinity,
  AspectRatioFixed->True,
  CellTags->"Drive Chain"],

Cell[BoxData[
    \({0}\)], "Output",
  CellLabel->"Out[114]=",
  CellTags->"Drive Chain"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bibliography", "Section",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"References"],

Cell["\<\
To use TSi Dynamics requires some knowledge about dynamics. For those users \
seeking more information on the concepts behind the TSi Dynamics modeling \
formalism, we list a few reference books. Some have been cited above in our \
examples.

V. I. Arnold, Mathematical Methods of Classical Mechanics, Springer-Verlag: \
New York, 1989 (2nd ed.)
N. G. Chetaev, Theoretical Mechanics, Springer-Verlag: New York, 1989.
S. H. Crandall, D. C. Karnopp, E. F. Kurtz, D. C. Pridmore-Brown, Dynamics of \
Mechanical and Electromechanial Systems, McGraw-Hill: New York, 1968.
F. Gantmacher, Lectures in Analytical Mechanics, MIR: Moscow, 1975.
J. H. Ginsberg, Advanced Engineering Dynamics, Harper & Row: New York, 1988.
H. Goldstein, Classical Mechanics, Addison-Wesley: Reading, 1981 (2nd ed.)
D. T. Greenwood, Classical Mechanics, Prentice-Hall: Englewood Cliffs, 1977.
T. R. Kane and D. A. Levinson, Dynamics: Theory and Application, McGraw-Hill: \
New York, 1985.
C. Lanczos, The Variational Principles of Mechanics, University of Toronto \
Press: Toronto, 1970 (4th ed.)
L.Meirovitch, Methods of Analytical Dynamics, McGraw-Hill: New York, 1970.
Ju. I. Neimark and N. A. Fufaev, Dynamics of Nonholonomic Systems, American \
Mathematical Society: Providence, 1972.
R. M. Rosenberg, Analytical Dynamics of Discrete Systems, Plenum: New York, \
1977.\
\>", "Text",
  Evaluatable->False,
  CellHorizontalScrolling->False,
  AspectRatioFixed->True,
  CellTags->"References"]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowToolbars->{},
WindowSize->{679, 427},
WindowMargins->{{7, Automatic}, {Automatic, 5}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
TaggingRules:>{"NextIndexingNumber" -> 10, "IndexEntries" -> {{"i:1", \
"CreateModel"}, {"i:2", "MakeODEs"}, {"i:3", "CreateModelMEX"}, {"i:4", \
"CreateModel"}, {"i:4", "Joints"}, {"i:4", "LeafPotential"}, {"i:4", \
"SpringPotential"}, {"i:5", "CreateModel"}, {"i:5", "EndEffector"}, {"i:6", \
"CreateModel"}, {"i:6", "CreateModelMEX"}, {"i:6", "GeneralizedForce"}, \
{"i:6", "Joints"}, {"i:6", "KinematicReplacements"}, {"i:7", \
"AlgebraicConstraints"}, {"i:7", "EndEffector"}, {"i:8", \
"AlgebraicConstraints"}, {"i:9", "DifferentialConstraints"}, {"i:9", \
"NodeVelocity"}}},
ShowCellLabel->True,
ShowCellTags->True,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "Textbook.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Introduction"->{
    Cell[2262, 76, 141, 4, 99, "Section",
      Evaluatable->False,
      CellTags->"Introduction"],
    Cell[2406, 82, 1772, 30, 377, "Text",
      Evaluatable->False,
      CellTags->"Introduction"]},
  "Getting Started"->{
    Cell[4215, 117, 147, 4, 67, "Section",
      Evaluatable->False,
      CellTags->"Getting Started"],
    Cell[4365, 123, 762, 15, 93, "Text",
      Evaluatable->False,
      CellTags->"Getting Started"],
    Cell[5130, 140, 246, 9, 25, "Text",
      Evaluatable->False,
      CellTags->"Getting Started"],
    Cell[5401, 153, 130, 4, 32, "Input",
      CellTags->"Getting Started"],
    Cell[5534, 159, 700, 10, 237, "Print",
      CellTags->"Getting Started"],
    Cell[6249, 172, 162, 6, 25, "Text",
      CellTags->"Getting Started"]},
  "What's in the Package"->{
    Cell[6600, 190, 163, 4, 54, "Subsection",
      Evaluatable->False,
      CellTags->"What's in the Package"],
    Cell[6766, 196, 222, 7, 39, "Text",
      Evaluatable->False,
      CellTags->"What's in the Package"],
    Cell[7013, 207, 135, 4, 46, "Input",
      CellTags->"What's in the Package"],
    Cell[7151, 213, 110, 2, 28, "Print",
      CellTags->"What's in the Package"],
    Cell[7264, 217, 103, 3, 24, "Output",
      CellTags->"What's in the Package"],
    Cell[7404, 225, 107, 3, 44, "Input",
      CellTags->"What's in the Package"],
    Cell[7514, 230, 1166, 19, 579, "Print",
      CellTags->"What's in the Package"],
    Cell[8717, 254, 115, 3, 30, "Input",
      CellTags->"What's in the Package"],
    Cell[8835, 259, 1229, 18, 579, "Print",
      CellTags->"What's in the Package"],
    Cell[10079, 280, 1880, 31, 395, "Text",
      Evaluatable->False,
      CellTags->"What's in the Package"]},
  "Data Structures"->{
    Cell[11996, 316, 150, 4, 48, "Subsection",
      Evaluatable->False,
      CellTags->"Data Structures"],
    Cell[12171, 324, 153, 4, 51, "Subsubsection",
      Evaluatable->False,
      CellTags->"Data Structures"],
    Cell[12327, 330, 3336, 46, 773, "Text",
      Evaluatable->False,
      CellTags->"Data Structures"],
    Cell[15700, 381, 72, 1, 45, "Subsubsection",
      CellTags->"Data Structures"],
    Cell[15775, 384, 1074, 16, 178, "Text",
      CellTags->"Data Structures"],
    Cell[16886, 405, 144, 4, 45, "Subsubsection",
      Evaluatable->False,
      CellTags->"Data Structures"],
    Cell[17033, 411, 1952, 28, 425, "Text",
      Evaluatable->False,
      CellTags->"Data Structures"],
    Cell[18988, 441, 204, 7, 52, "Input",
      CellTags->"Data Structures"],
    Cell[19195, 450, 216, 7, 25, "Text",
      Evaluatable->False,
      CellTags->"Data Structures"],
    Cell[19414, 459, 206, 7, 52, "Input",
      CellTags->"Data Structures"],
    Cell[19623, 468, 384, 9, 42, "Text",
      Evaluatable->False,
      CellTags->"Data Structures"],
    Cell[20032, 481, 196, 8, 72, "Input",
      CellTags->"Data Structures"],
    Cell[20231, 491, 94, 2, 28, "Print",
      CellTags->"Data Structures"],
    Cell[20328, 495, 94, 2, 28, "Print",
      CellTags->"Data Structures"],
    Cell[20459, 502, 130, 4, 32, "Input",
      CellTags->"Data Structures"],
    Cell[20592, 508, 107, 2, 28, "Print",
      CellTags->"Data Structures"],
    Cell[20736, 515, 130, 4, 32, "Input",
      CellTags->"Data Structures"],
    Cell[20869, 521, 447, 7, 123, "Print",
      CellTags->"Data Structures"],
    Cell[21353, 533, 130, 4, 32, "Input",
      CellTags->"Data Structures"],
    Cell[21486, 539, 189, 3, 47, "Print",
      CellTags->"Data Structures"],
    Cell[21690, 545, 624, 12, 93, "Text",
      Evaluatable->False,
      CellTags->"Data Structures"],
    Cell[22339, 561, 258, 11, 132, "Input",
      CellTags->"Data Structures"],
    Cell[22600, 574, 94, 2, 28, "Print",
      CellTags->"Data Structures"],
    Cell[22731, 581, 130, 4, 32, "Input",
      CellTags->"Data Structures"],
    Cell[22864, 587, 588, 9, 156, "Print",
      CellTags->"Data Structures"],
    Cell[23489, 601, 130, 4, 46, "Input",
      CellTags->"Data Structures"],
    Cell[23622, 607, 421, 7, 118, "Print",
      CellTags->"Data Structures"],
    Cell[24080, 619, 130, 4, 46, "Input",
      CellTags->"Data Structures"],
    Cell[24213, 625, 197, 3, 61, "Print",
      CellTags->"Data Structures"],
    Cell[24459, 634, 150, 4, 45, "Subsubsection",
      Evaluatable->False,
      CellTags->"Data Structures"],
    Cell[24612, 640, 1346, 26, 357, "Text",
      Evaluatable->False,
      CellTags->"Data Structures"],
    Cell[25995, 671, 153, 4, 45, "Subsubsection",
      Evaluatable->False,
      CellTags->"Data Structures"],
    Cell[26151, 677, 2915, 49, 747, "Text",
      Evaluatable->False,
      CellTags->"Data Structures"]},
  "Building Equations"->{
    Cell[29299, 740, 170, 4, 54, "Subsection",
      Evaluatable->False,
      CellTags->"Building Equations"],
    Cell[29472, 746, 434, 13, 214, "Text",
      Evaluatable->False,
      CellTags->"Building Equations"],
    Cell[29909, 761, 295, 12, 166, "Input",
      CellTags->{"Building Equations", "i:1"}],
    Cell[30207, 775, 148, 4, 39, "Text",
      Evaluatable->False,
      CellTags->"Building Equations"],
    Cell[30358, 781, 363, 12, 166, "Input",
      CellTags->"Building Equations"],
    Cell[30724, 795, 164, 4, 39, "Text",
      Evaluatable->False,
      CellTags->"Building Equations"],
    Cell[30891, 801, 149, 4, 46, "Input",
      CellTags->"Building Equations"],
    Cell[31043, 807, 303, 8, 81, "Text",
      Evaluatable->False,
      CellTags->"Building Equations"],
    Cell[31349, 817, 147, 4, 46, "Input",
      CellTags->"Building Equations"],
    Cell[31521, 825, 198, 6, 46, "Input",
      CellTags->"Building Equations"],
    Cell[31722, 833, 95, 2, 42, "Print",
      CellTags->"Building Equations"],
    Cell[31820, 837, 97, 2, 42, "Print",
      CellTags->"Building Equations"],
    Cell[31920, 841, 97, 2, 42, "Print",
      CellTags->"Building Equations"],
    Cell[32020, 845, 98, 2, 42, "Print",
      CellTags->"Building Equations"],
    Cell[32121, 849, 93, 2, 42, "Print",
      CellTags->"Building Equations"],
    Cell[32217, 853, 96, 2, 42, "Print",
      CellTags->"Building Equations"],
    Cell[32328, 858, 160, 4, 39, "Text",
      Evaluatable->False,
      CellTags->"Building Equations"],
    Cell[32513, 866, 145, 4, 46, "Input",
      CellTags->"Building Equations"],
    Cell[32661, 872, 385, 13, 56, "Print",
      CellTags->"Building Equations"],
    Cell[33061, 888, 372, 9, 56, "Text",
      Evaluatable->False,
      CellTags->"Building Equations"],
    Cell[33458, 901, 145, 4, 46, "Input",
      CellTags->"Building Equations"],
    Cell[33606, 907, 452, 11, 60, "Print",
      CellTags->"Building Equations"],
    Cell[34095, 923, 146, 4, 46, "Input",
      CellTags->"Building Equations"],
    Cell[34244, 929, 742, 25, 54, "Print",
      CellTags->"Building Equations"],
    Cell[35001, 957, 434, 9, 73, "Text",
      Evaluatable->False,
      CellTags->"Building Equations"],
    Cell[35438, 968, 204, 7, 66, "Input",
      CellTags->"Building Equations"],
    Cell[35645, 977, 180, 4, 39, "Text",
      Evaluatable->False,
      CellTags->"Building Equations"],
    Cell[35828, 983, 140, 4, 46, "Input",
      CellTags->"Building Equations"]},
  "i:1"->{
    Cell[29909, 761, 295, 12, 166, "Input",
      CellTags->{"Building Equations", "i:1"}]},
  "Simulation"->{
    Cell[36005, 992, 169, 4, 48, "Subsection",
      Evaluatable->False,
      CellTags->{"Simulation", "i:2"}],
    Cell[36177, 998, 352, 8, 56, "Text",
      Evaluatable->False,
      CellTags->{"Simulation", "i:2"}],
    Cell[36554, 1010, 161, 4, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[36718, 1016, 2493, 56, 268, "Output",
      CellTags->{"Simulation", "i:2"}],
    Cell[39226, 1075, 213, 6, 39, "Text",
      Evaluatable->False,
      CellTags->{"Simulation", "i:2"}],
    Cell[39464, 1085, 186, 4, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[39653, 1091, 199, 4, 38, "Output",
      CellTags->{"Simulation", "i:2"}],
    Cell[39889, 1100, 164, 4, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[40056, 1106, 2080, 50, 215, "Output",
      CellTags->{"Simulation", "i:2"}],
    Cell[42173, 1161, 140, 4, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[42316, 1167, 114, 3, 38, "Output",
      CellTags->{"Simulation", "i:2"}],
    Cell[42467, 1175, 234, 7, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[42704, 1184, 146, 3, 38, "Output",
      CellTags->{"Simulation", "i:2"}],
    Cell[42887, 1192, 206, 6, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[43096, 1200, 444, 12, 38, "Output",
      CellTags->{"Simulation", "i:2"}],
    Cell[43577, 1217, 171, 4, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[43751, 1223, 2406, 58, 253, "Output",
      CellTags->{"Simulation", "i:2"}],
    Cell[46172, 1284, 236, 7, 39, "Text",
      Evaluatable->False,
      CellTags->{"Simulation", "i:2"}],
    Cell[46433, 1295, 164, 4, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[46600, 1301, 809, 21, 95, "Output",
      CellTags->{"Simulation", "i:2"}],
    Cell[47446, 1327, 163, 4, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[47612, 1333, 31379, 839, 200, 8052, 545, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"Simulation", "i:2"}],
    Cell[78994, 2174, 190, 5, 38, "Output",
      CellTags->{"Simulation", "i:2"}],
    Cell[79221, 2184, 163, 4, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[79387, 2190, 53963, 1165, 200, 9149, 606, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"Simulation", "i:2"}],
    Cell[133353, 3357, 190, 5, 38, "Output",
      CellTags->{"Simulation", "i:2"}]},
  "i:2"->{
    Cell[36005, 992, 169, 4, 48, "Subsection",
      Evaluatable->False,
      CellTags->{"Simulation", "i:2"}],
    Cell[36177, 998, 352, 8, 56, "Text",
      Evaluatable->False,
      CellTags->{"Simulation", "i:2"}],
    Cell[36554, 1010, 161, 4, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[36718, 1016, 2493, 56, 268, "Output",
      CellTags->{"Simulation", "i:2"}],
    Cell[39226, 1075, 213, 6, 39, "Text",
      Evaluatable->False,
      CellTags->{"Simulation", "i:2"}],
    Cell[39464, 1085, 186, 4, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[39653, 1091, 199, 4, 38, "Output",
      CellTags->{"Simulation", "i:2"}],
    Cell[39889, 1100, 164, 4, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[40056, 1106, 2080, 50, 215, "Output",
      CellTags->{"Simulation", "i:2"}],
    Cell[42173, 1161, 140, 4, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[42316, 1167, 114, 3, 38, "Output",
      CellTags->{"Simulation", "i:2"}],
    Cell[42467, 1175, 234, 7, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[42704, 1184, 146, 3, 38, "Output",
      CellTags->{"Simulation", "i:2"}],
    Cell[42887, 1192, 206, 6, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[43096, 1200, 444, 12, 38, "Output",
      CellTags->{"Simulation", "i:2"}],
    Cell[43577, 1217, 171, 4, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[43751, 1223, 2406, 58, 253, "Output",
      CellTags->{"Simulation", "i:2"}],
    Cell[46172, 1284, 236, 7, 39, "Text",
      Evaluatable->False,
      CellTags->{"Simulation", "i:2"}],
    Cell[46433, 1295, 164, 4, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[46600, 1301, 809, 21, 95, "Output",
      CellTags->{"Simulation", "i:2"}],
    Cell[47446, 1327, 163, 4, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[47612, 1333, 31379, 839, 200, 8052, 545, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"Simulation", "i:2"}],
    Cell[78994, 2174, 190, 5, 38, "Output",
      CellTags->{"Simulation", "i:2"}],
    Cell[79221, 2184, 163, 4, 46, "Input",
      CellTags->{"Simulation", "i:2"}],
    Cell[79387, 2190, 53963, 1165, 200, 9149, 606, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"Simulation", "i:2"}],
    Cell[133353, 3357, 190, 5, 38, "Output",
      CellTags->{"Simulation", "i:2"}]},
  "Creating MEX-Files"->{
    Cell[133592, 3368, 165, 4, 48, "Subsection",
      Evaluatable->False,
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[133760, 3374, 730, 13, 107, "Text",
      Evaluatable->False,
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[134493, 3389, 222, 6, 39, "Text",
      Evaluatable->False,
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[134740, 3399, 263, 9, 106, "Input",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[135006, 3410, 281, 6, 57, "Output",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[135324, 3421, 599, 15, 186, "Input",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[135926, 3438, 116, 2, 42, "Print",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[136045, 3442, 103, 2, 42, "Print",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[136151, 3446, 123, 2, 42, "Print",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[136277, 3450, 122, 2, 42, "Print",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[136402, 3454, 110, 2, 42, "Print",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[136515, 3458, 118, 2, 42, "Print",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[136636, 3462, 113, 2, 42, "Print",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[136752, 3466, 112, 2, 42, "Print",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[136867, 3470, 116, 2, 42, "Print",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[137032, 3478, 83, 1, 48, "Subsection",
      CellTags->"Creating MEX-Files"],
    Cell[137118, 3481, 1678, 29, 426, "Text",
      CellTags->"Creating MEX-Files"]},
  "i:3"->{
    Cell[133592, 3368, 165, 4, 48, "Subsection",
      Evaluatable->False,
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[133760, 3374, 730, 13, 107, "Text",
      Evaluatable->False,
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[134493, 3389, 222, 6, 39, "Text",
      Evaluatable->False,
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[134740, 3399, 263, 9, 106, "Input",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[135006, 3410, 281, 6, 57, "Output",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[135324, 3421, 599, 15, 186, "Input",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[135926, 3438, 116, 2, 42, "Print",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[136045, 3442, 103, 2, 42, "Print",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[136151, 3446, 123, 2, 42, "Print",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[136277, 3450, 122, 2, 42, "Print",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[136402, 3454, 110, 2, 42, "Print",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[136515, 3458, 118, 2, 42, "Print",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[136636, 3462, 113, 2, 42, "Print",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[136752, 3466, 112, 2, 42, "Print",
      CellTags->{"Creating MEX-Files", "i:3"}],
    Cell[136867, 3470, 116, 2, 42, "Print",
      CellTags->{"Creating MEX-Files", "i:3"}]},
  "Suspension"->{
    Cell[139770, 3544, 164, 4, 48, "Subsection",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[139937, 3550, 560, 12, 115, "Text",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[140522, 3566, 509, 20, 326, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[141034, 3588, 98, 2, 42, "Print",
      CellTags->{"Suspension", "i:4"}],
    Cell[141135, 3592, 98, 2, 42, "Print",
      CellTags->{"Suspension", "i:4"}],
    Cell[141236, 3596, 98, 2, 42, "Print",
      CellTags->{"Suspension", "i:4"}],
    Cell[141349, 3601, 142, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[141494, 3607, 588, 23, 366, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[142085, 3632, 219, 7, 64, "Text",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[142307, 3641, 164, 4, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[142474, 3647, 707, 14, 140, "Text",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[143184, 3663, 252, 9, 106, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[143439, 3674, 342, 8, 56, "Text",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[143784, 3684, 241, 8, 86, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[144050, 3696, 132, 4, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[144185, 3702, 423, 8, 109, "Output",
      CellTags->{"Suspension", "i:4"}],
    Cell[144623, 3713, 666, 12, 107, "Text",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[145292, 3727, 341, 12, 166, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[145658, 3743, 136, 4, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[145797, 3749, 203, 4, 65, "Output",
      CellTags->{"Suspension", "i:4"}],
    Cell[146037, 3758, 136, 4, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[146176, 3764, 203, 4, 65, "Output",
      CellTags->{"Suspension", "i:4"}],
    Cell[146394, 3771, 509, 11, 98, "Text",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[146906, 3784, 149, 4, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[147058, 3790, 251, 8, 64, "Text",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[147312, 3800, 133, 4, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[147448, 3806, 335, 9, 81, "Text",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[147808, 3819, 207, 6, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[148018, 3827, 99, 2, 42, "Print",
      CellTags->{"Suspension", "i:4"}],
    Cell[148120, 3831, 94, 2, 42, "Print",
      CellTags->{"Suspension", "i:4"}],
    Cell[148217, 3835, 97, 2, 42, "Print",
      CellTags->{"Suspension", "i:4"}],
    Cell[148351, 3842, 128, 4, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[148482, 3848, 5513, 109, 1386, "Output",
      CellTags->{"Suspension", "i:4"}],
    Cell[154032, 3962, 142, 4, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[154177, 3968, 1026, 19, 214, "Output",
      CellTags->{"Suspension", "i:4"}],
    Cell[155240, 3992, 128, 4, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[155371, 3998, 3543, 61, 1013, "Output",
      CellTags->{"Suspension", "i:4"}]},
  "i:4"->{
    Cell[139770, 3544, 164, 4, 48, "Subsection",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[139937, 3550, 560, 12, 115, "Text",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[140522, 3566, 509, 20, 326, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[141034, 3588, 98, 2, 42, "Print",
      CellTags->{"Suspension", "i:4"}],
    Cell[141135, 3592, 98, 2, 42, "Print",
      CellTags->{"Suspension", "i:4"}],
    Cell[141236, 3596, 98, 2, 42, "Print",
      CellTags->{"Suspension", "i:4"}],
    Cell[141349, 3601, 142, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[141494, 3607, 588, 23, 366, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[142085, 3632, 219, 7, 64, "Text",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[142307, 3641, 164, 4, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[142474, 3647, 707, 14, 140, "Text",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[143184, 3663, 252, 9, 106, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[143439, 3674, 342, 8, 56, "Text",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[143784, 3684, 241, 8, 86, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[144050, 3696, 132, 4, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[144185, 3702, 423, 8, 109, "Output",
      CellTags->{"Suspension", "i:4"}],
    Cell[144623, 3713, 666, 12, 107, "Text",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[145292, 3727, 341, 12, 166, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[145658, 3743, 136, 4, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[145797, 3749, 203, 4, 65, "Output",
      CellTags->{"Suspension", "i:4"}],
    Cell[146037, 3758, 136, 4, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[146176, 3764, 203, 4, 65, "Output",
      CellTags->{"Suspension", "i:4"}],
    Cell[146394, 3771, 509, 11, 98, "Text",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[146906, 3784, 149, 4, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[147058, 3790, 251, 8, 64, "Text",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[147312, 3800, 133, 4, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[147448, 3806, 335, 9, 81, "Text",
      Evaluatable->False,
      CellTags->{"Suspension", "i:4"}],
    Cell[147808, 3819, 207, 6, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[148018, 3827, 99, 2, 42, "Print",
      CellTags->{"Suspension", "i:4"}],
    Cell[148120, 3831, 94, 2, 42, "Print",
      CellTags->{"Suspension", "i:4"}],
    Cell[148217, 3835, 97, 2, 42, "Print",
      CellTags->{"Suspension", "i:4"}],
    Cell[148351, 3842, 128, 4, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[148482, 3848, 5513, 109, 1386, "Output",
      CellTags->{"Suspension", "i:4"}],
    Cell[154032, 3962, 142, 4, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[154177, 3968, 1026, 19, 214, "Output",
      CellTags->{"Suspension", "i:4"}],
    Cell[155240, 3992, 128, 4, 46, "Input",
      CellTags->{"Suspension", "i:4"}],
    Cell[155371, 3998, 3543, 61, 1013, "Output",
      CellTags->{"Suspension", "i:4"}]},
  "Flexible Manipulator"->{
    Cell[158963, 4065, 180, 4, 48, "Subsection",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[159146, 4071, 580, 11, 90, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[159751, 4086, 176, 4, 51, "Subsubsection",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[159930, 4092, 1679, 27, 284, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[161612, 4121, 167, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[161782, 4127, 194, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[161979, 4133, 181, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[162163, 4139, 180, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[162346, 4145, 310, 9, 86, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[162659, 4156, 309, 8, 56, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[162971, 4166, 291, 12, 166, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[163265, 4180, 231, 7, 66, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[163499, 4189, 380, 8, 56, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[163882, 4199, 178, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[164063, 4205, 212, 6, 39, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[164278, 4213, 154, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[164435, 4219, 192, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[164630, 4225, 256, 9, 106, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[164889, 4236, 169, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[165083, 4244, 195, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[165281, 4250, 960, 15, 253, "Output",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[166278, 4270, 195, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[166476, 4276, 960, 15, 253, "Output",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[167451, 4294, 160, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[167614, 4300, 307, 14, 206, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[167924, 4316, 189, 7, 66, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[168138, 4327, 213, 6, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[168354, 4335, 106, 2, 42, "Print",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[168463, 4339, 108, 2, 42, "Print",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[168574, 4343, 108, 2, 42, "Print",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[168685, 4347, 109, 2, 42, "Print",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[168797, 4351, 104, 2, 42, "Print",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[168904, 4355, 107, 2, 42, "Print",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[169026, 4360, 178, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[169229, 4368, 138, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[169370, 4374, 8858, 149, 2004, "Output",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[178265, 4528, 151, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[178419, 4534, 5513, 90, 733, "Output",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[183969, 4629, 139, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[184111, 4635, 2301, 37, 379, "Output",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[186427, 4675, 278, 7, 39, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[186708, 4684, 179, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[186890, 4690, 184, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[187099, 4698, 156, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[187258, 4704, 1347, 27, 333, "Output",
      CellTags->{"Flexible Manipulator", "i:5"}]},
  "i:5"->{
    Cell[158963, 4065, 180, 4, 48, "Subsection",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[159146, 4071, 580, 11, 90, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[159751, 4086, 176, 4, 51, "Subsubsection",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[159930, 4092, 1679, 27, 284, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[161612, 4121, 167, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[161782, 4127, 194, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[161979, 4133, 181, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[162163, 4139, 180, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[162346, 4145, 310, 9, 86, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[162659, 4156, 309, 8, 56, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[162971, 4166, 291, 12, 166, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[163265, 4180, 231, 7, 66, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[163499, 4189, 380, 8, 56, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[163882, 4199, 178, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[164063, 4205, 212, 6, 39, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[164278, 4213, 154, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[164435, 4219, 192, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[164630, 4225, 256, 9, 106, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[164889, 4236, 169, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[165083, 4244, 195, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[165281, 4250, 960, 15, 253, "Output",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[166278, 4270, 195, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[166476, 4276, 960, 15, 253, "Output",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[167451, 4294, 160, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[167614, 4300, 307, 14, 206, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[167924, 4316, 189, 7, 66, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[168138, 4327, 213, 6, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[168354, 4335, 106, 2, 42, "Print",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[168463, 4339, 108, 2, 42, "Print",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[168574, 4343, 108, 2, 42, "Print",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[168685, 4347, 109, 2, 42, "Print",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[168797, 4351, 104, 2, 42, "Print",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[168904, 4355, 107, 2, 42, "Print",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[169026, 4360, 178, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[169229, 4368, 138, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[169370, 4374, 8858, 149, 2004, "Output",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[178265, 4528, 151, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[178419, 4534, 5513, 90, 733, "Output",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[183969, 4629, 139, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[184111, 4635, 2301, 37, 379, "Output",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[186427, 4675, 278, 7, 39, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[186708, 4684, 179, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[186890, 4690, 184, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[187099, 4698, 156, 4, 46, "Input",
      CellTags->{"Flexible Manipulator", "i:5"}],
    Cell[187258, 4704, 1347, 27, 333, "Output",
      CellTags->{"Flexible Manipulator", "i:5"}]},
  "Tractor-Trailer"->{
    Cell[188666, 4738, 164, 4, 48, "Subsection",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[188833, 4744, 539, 11, 98, "Text",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[189397, 4759, 165, 4, 51, "Subsubsection",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[189565, 4765, 163, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[189731, 4771, 249, 9, 106, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[189983, 4782, 288, 9, 55, "Text",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[190274, 4793, 314, 8, 56, "Text",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[190591, 4803, 389, 15, 226, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[190983, 4820, 282, 9, 55, "Text",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[191268, 4831, 296, 10, 126, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[191601, 4846, 166, 4, 51, "Subsubsection",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[191792, 4854, 169, 4, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[191964, 4860, 103, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[192070, 4864, 103, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[192176, 4868, 103, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[192282, 4872, 103, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[192422, 4879, 141, 4, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[192566, 4885, 87, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[192702, 4893, 156, 4, 51, "Subsubsection",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[192861, 4899, 611, 15, 256, "Text",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[193475, 4916, 1252, 38, 646, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[194764, 4959, 158, 4, 51, "Subsubsection",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[194925, 4965, 476, 10, 73, "Text",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[195426, 4979, 366, 14, 186, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[195795, 4995, 7597, 124, 1560, "Output",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[203429, 5124, 140, 4, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[203572, 5130, 101, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[203688, 5135, 185, 4, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[203898, 5143, 138, 4, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[204039, 5149, 443, 8, 119, "Output",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[204497, 5160, 351, 11, 146, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[204873, 5175, 225, 7, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[205101, 5184, 4834, 81, 589, "Output",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[209972, 5270, 141, 4, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[210116, 5276, 101, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[210232, 5281, 359, 11, 146, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[210594, 5294, 373, 12, 166, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[210970, 5308, 374, 12, 166, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[211347, 5322, 372, 12, 166, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[211722, 5336, 361, 12, 166, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[212086, 5350, 358, 12, 166, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[212447, 5364, 357, 12, 166, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[212807, 5378, 158, 4, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[213002, 5387, 159, 4, 51, "Subsubsection",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[213186, 5395, 262, 8, 66, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[213451, 5405, 104, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[213558, 5409, 99, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[213660, 5413, 102, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[213777, 5418, 208, 6, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[213988, 5426, 400, 14, 206, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[214425, 5445, 186, 4, 51, "Subsubsection",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[214614, 5451, 504, 10, 73, "Text",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[215143, 5465, 885, 27, 466, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[216031, 5494, 100, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[216134, 5498, 120, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[216257, 5502, 119, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[216379, 5506, 107, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[216489, 5510, 115, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[216607, 5514, 110, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[216720, 5518, 109, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[216832, 5522, 110, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[216979, 5529, 138, 4, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[217120, 5535, 115, 3, 38, "Output",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[217272, 5543, 139, 4, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[217414, 5549, 150, 3, 38, "Output",
      CellTags->{"Tractor-Trailer", "i:6"}]},
  "i:6"->{
    Cell[188666, 4738, 164, 4, 48, "Subsection",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[188833, 4744, 539, 11, 98, "Text",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[189397, 4759, 165, 4, 51, "Subsubsection",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[189565, 4765, 163, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[189731, 4771, 249, 9, 106, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[189983, 4782, 288, 9, 55, "Text",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[190274, 4793, 314, 8, 56, "Text",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[190591, 4803, 389, 15, 226, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[190983, 4820, 282, 9, 55, "Text",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[191268, 4831, 296, 10, 126, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[191601, 4846, 166, 4, 51, "Subsubsection",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[191792, 4854, 169, 4, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[191964, 4860, 103, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[192070, 4864, 103, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[192176, 4868, 103, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[192282, 4872, 103, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[192422, 4879, 141, 4, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[192566, 4885, 87, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[192702, 4893, 156, 4, 51, "Subsubsection",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[192861, 4899, 611, 15, 256, "Text",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[193475, 4916, 1252, 38, 646, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[194764, 4959, 158, 4, 51, "Subsubsection",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[194925, 4965, 476, 10, 73, "Text",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[195426, 4979, 366, 14, 186, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[195795, 4995, 7597, 124, 1560, "Output",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[203429, 5124, 140, 4, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[203572, 5130, 101, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[203688, 5135, 185, 4, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[203898, 5143, 138, 4, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[204039, 5149, 443, 8, 119, "Output",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[204497, 5160, 351, 11, 146, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[204873, 5175, 225, 7, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[205101, 5184, 4834, 81, 589, "Output",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[209972, 5270, 141, 4, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[210116, 5276, 101, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[210232, 5281, 359, 11, 146, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[210594, 5294, 373, 12, 166, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[210970, 5308, 374, 12, 166, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[211347, 5322, 372, 12, 166, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[211722, 5336, 361, 12, 166, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[212086, 5350, 358, 12, 166, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[212447, 5364, 357, 12, 166, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[212807, 5378, 158, 4, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[213002, 5387, 159, 4, 51, "Subsubsection",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[213186, 5395, 262, 8, 66, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[213451, 5405, 104, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[213558, 5409, 99, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[213660, 5413, 102, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[213777, 5418, 208, 6, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[213988, 5426, 400, 14, 206, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[214425, 5445, 186, 4, 51, "Subsubsection",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[214614, 5451, 504, 10, 73, "Text",
      Evaluatable->False,
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[215143, 5465, 885, 27, 466, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[216031, 5494, 100, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[216134, 5498, 120, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[216257, 5502, 119, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[216379, 5506, 107, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[216489, 5510, 115, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[216607, 5514, 110, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[216720, 5518, 109, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[216832, 5522, 110, 2, 42, "Print",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[216979, 5529, 138, 4, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[217120, 5535, 115, 3, 38, "Output",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[217272, 5543, 139, 4, 46, "Input",
      CellTags->{"Tractor-Trailer", "i:6"}],
    Cell[217414, 5549, 150, 3, 38, "Output",
      CellTags->{"Tractor-Trailer", "i:6"}]},
  "Constraints Intro"->{
    Cell[217784, 5567, 157, 4, 54, "Subsection",
      Evaluatable->False,
      CellTags->"Constraints Intro"],
    Cell[217944, 5573, 2519, 41, 461, "Text",
      Evaluatable->False,
      CellTags->"Constraints Intro"],
    Cell[220488, 5618, 132, 4, 46, "Input",
      CellTags->"Constraints Intro"]},
  "Closed Chain"->{
    Cell[221344, 5640, 162, 4, 54, "Subsection",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:7"}],
    Cell[221509, 5646, 406, 9, 73, "Text",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:7"}],
    Cell[221918, 5657, 297, 14, 206, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[222218, 5673, 510, 13, 186, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[222731, 5688, 176, 7, 66, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[222932, 5699, 204, 6, 46, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[223139, 5707, 140, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[223282, 5712, 128, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[223413, 5717, 130, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[223546, 5722, 130, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[223679, 5727, 131, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[223813, 5732, 126, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[223942, 5737, 129, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[224086, 5743, 256, 7, 66, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[224345, 5752, 162, 4, 46, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[224532, 5760, 145, 4, 46, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[224680, 5766, 211, 5, 38, "Output",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[224906, 5774, 445, 9, 73, "Text",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:7"}],
    Cell[225376, 5787, 197, 6, 46, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[225576, 5795, 104, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[225683, 5800, 104, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[225790, 5805, 104, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[225897, 5810, 104, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[226004, 5815, 1074, 21, 268, "Output",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[227093, 5839, 481, 10, 73, "Text",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:7"}],
    Cell[227599, 5853, 200, 6, 46, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[227802, 5861, 764, 14, 206, "Output",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[228581, 5878, 213, 6, 39, "Text",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:7"}],
    Cell[228819, 5888, 166, 4, 46, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[228988, 5894, 1472, 33, 212, "Output",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[230475, 5930, 320, 8, 56, "Text",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:7"}],
    Cell[230820, 5942, 174, 4, 46, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[230997, 5948, 1178, 30, 106, "Output",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[232190, 5981, 279, 7, 56, "Text",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:7"}],
    Cell[232506, 5993, 161, 4, 48, "Subsection",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:8"}],
    Cell[232670, 5999, 388, 9, 56, "Text",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:8"}],
    Cell[233061, 6010, 319, 14, 206, "Input",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[233383, 6026, 506, 13, 186, "Input",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[233892, 6041, 178, 7, 66, "Input",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[234095, 6052, 204, 6, 46, "Input",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[234302, 6060, 128, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[234433, 6065, 130, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[234566, 6070, 130, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[234699, 6075, 131, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[234833, 6080, 126, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[234962, 6085, 129, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[235106, 6091, 256, 7, 66, "Input",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[235365, 6100, 162, 4, 46, "Input",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[235552, 6108, 145, 4, 46, "Input",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[235700, 6114, 205, 5, 24, "Output",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[235920, 6122, 235, 7, 39, "Text",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:8"}],
    Cell[236180, 6133, 201, 6, 46, "Input",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[236384, 6141, 104, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[236491, 6146, 104, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[236598, 6151, 104, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[236705, 6156, 104, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[236812, 6161, 136, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[236951, 6166, 2474, 45, 538, "Output",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[239462, 6216, 145, 4, 46, "Input",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[239610, 6222, 1244, 20, 224, "Output",
      CellTags->{"Closed Chain", "i:8"}]},
  "i:7"->{
    Cell[221344, 5640, 162, 4, 54, "Subsection",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:7"}],
    Cell[221509, 5646, 406, 9, 73, "Text",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:7"}],
    Cell[221918, 5657, 297, 14, 206, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[222218, 5673, 510, 13, 186, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[222731, 5688, 176, 7, 66, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[222932, 5699, 204, 6, 46, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[223139, 5707, 140, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[223282, 5712, 128, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[223413, 5717, 130, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[223546, 5722, 130, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[223679, 5727, 131, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[223813, 5732, 126, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[223942, 5737, 129, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[224086, 5743, 256, 7, 66, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[224345, 5752, 162, 4, 46, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[224532, 5760, 145, 4, 46, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[224680, 5766, 211, 5, 38, "Output",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[224906, 5774, 445, 9, 73, "Text",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:7"}],
    Cell[225376, 5787, 197, 6, 46, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[225576, 5795, 104, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[225683, 5800, 104, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[225790, 5805, 104, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[225897, 5810, 104, 3, 42, "Print",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[226004, 5815, 1074, 21, 268, "Output",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[227093, 5839, 481, 10, 73, "Text",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:7"}],
    Cell[227599, 5853, 200, 6, 46, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[227802, 5861, 764, 14, 206, "Output",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[228581, 5878, 213, 6, 39, "Text",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:7"}],
    Cell[228819, 5888, 166, 4, 46, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[228988, 5894, 1472, 33, 212, "Output",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[230475, 5930, 320, 8, 56, "Text",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:7"}],
    Cell[230820, 5942, 174, 4, 46, "Input",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[230997, 5948, 1178, 30, 106, "Output",
      CellTags->{"Closed Chain", "i:7"}],
    Cell[232190, 5981, 279, 7, 56, "Text",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:7"}]},
  "i:8"->{
    Cell[232506, 5993, 161, 4, 48, "Subsection",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:8"}],
    Cell[232670, 5999, 388, 9, 56, "Text",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:8"}],
    Cell[233061, 6010, 319, 14, 206, "Input",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[233383, 6026, 506, 13, 186, "Input",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[233892, 6041, 178, 7, 66, "Input",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[234095, 6052, 204, 6, 46, "Input",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[234302, 6060, 128, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[234433, 6065, 130, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[234566, 6070, 130, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[234699, 6075, 131, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[234833, 6080, 126, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[234962, 6085, 129, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[235106, 6091, 256, 7, 66, "Input",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[235365, 6100, 162, 4, 46, "Input",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[235552, 6108, 145, 4, 46, "Input",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[235700, 6114, 205, 5, 24, "Output",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[235920, 6122, 235, 7, 39, "Text",
      Evaluatable->False,
      CellTags->{"Closed Chain", "i:8"}],
    Cell[236180, 6133, 201, 6, 46, "Input",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[236384, 6141, 104, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[236491, 6146, 104, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[236598, 6151, 104, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[236705, 6156, 104, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[236812, 6161, 136, 3, 28, "Print",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[236951, 6166, 2474, 45, 538, "Output",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[239462, 6216, 145, 4, 46, "Input",
      CellTags->{"Closed Chain", "i:8"}],
    Cell[239610, 6222, 1244, 20, 224, "Output",
      CellTags->{"Closed Chain", "i:8"}]},
  "Rolling Disk"->{
    Cell[240903, 6248, 212, 6, 48, "Subsection",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[241118, 6256, 619, 12, 90, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[241762, 6272, 162, 7, 66, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[241927, 6281, 225, 4, 57, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[242167, 6288, 207, 9, 106, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[242377, 6299, 323, 9, 81, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[242703, 6310, 211, 7, 66, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[242917, 6319, 313, 8, 86, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[243233, 6329, 158, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[243394, 6335, 178, 7, 66, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[243575, 6344, 180, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[243780, 6352, 204, 6, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[243987, 6360, 128, 3, 28, "Print",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[244118, 6365, 130, 3, 28, "Print",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[244251, 6370, 131, 3, 28, "Print",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[244385, 6375, 126, 3, 28, "Print",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[244514, 6380, 129, 3, 28, "Print",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[244658, 6386, 489, 10, 73, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[245172, 6400, 202, 7, 66, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[245377, 6409, 207, 4, 24, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[245599, 6416, 347, 8, 56, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[245971, 6428, 226, 7, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[246200, 6437, 104, 3, 28, "Print",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[246307, 6442, 104, 3, 28, "Print",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[246414, 6447, 104, 3, 28, "Print",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[246521, 6452, 104, 3, 28, "Print",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[246640, 6458, 279, 7, 39, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[246944, 6469, 132, 4, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[247079, 6475, 108, 3, 24, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[247202, 6481, 616, 12, 90, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[247843, 6497, 179, 4, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[248025, 6503, 140, 3, 24, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[248180, 6509, 338, 8, 56, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[248521, 6519, 151, 4, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[248675, 6525, 168, 4, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[248846, 6531, 176, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[249047, 6539, 180, 4, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[249230, 6545, 5475, 118, 537, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[254720, 6666, 233, 7, 39, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[254956, 6675, 213, 7, 66, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[255194, 6686, 221, 7, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[255418, 6695, 179, 4, 24, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[255612, 6702, 451, 10, 73, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[256088, 6716, 230, 8, 86, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[256321, 6726, 145, 3, 24, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[256469, 6731, 145, 3, 24, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[256629, 6737, 225, 7, 39, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[256879, 6748, 181, 4, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[257063, 6754, 233, 5, 43, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[257311, 6762, 222, 7, 39, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[257558, 6773, 166, 4, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[257727, 6779, 131, 3, 24, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[257895, 6787, 188, 4, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[258086, 6793, 2021, 52, 171, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[260122, 6848, 506, 10, 73, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[260653, 6862, 198, 6, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[260854, 6870, 906, 23, 43, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[261797, 6898, 247, 8, 86, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[262047, 6908, 1959, 47, 62, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[264043, 6960, 221, 8, 86, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[264267, 6970, 757, 19, 35, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[265061, 6994, 216, 8, 86, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[265280, 7004, 748, 19, 37, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[266065, 7028, 203, 6, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[266271, 7036, 3311, 74, 138, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[269597, 7113, 228, 7, 39, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}]},
  "i:9"->{
    Cell[240903, 6248, 212, 6, 48, "Subsection",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[241118, 6256, 619, 12, 90, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[241762, 6272, 162, 7, 66, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[241927, 6281, 225, 4, 57, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[242167, 6288, 207, 9, 106, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[242377, 6299, 323, 9, 81, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[242703, 6310, 211, 7, 66, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[242917, 6319, 313, 8, 86, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[243233, 6329, 158, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[243394, 6335, 178, 7, 66, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[243575, 6344, 180, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[243780, 6352, 204, 6, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[243987, 6360, 128, 3, 28, "Print",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[244118, 6365, 130, 3, 28, "Print",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[244251, 6370, 131, 3, 28, "Print",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[244385, 6375, 126, 3, 28, "Print",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[244514, 6380, 129, 3, 28, "Print",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[244658, 6386, 489, 10, 73, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[245172, 6400, 202, 7, 66, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[245377, 6409, 207, 4, 24, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[245599, 6416, 347, 8, 56, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[245971, 6428, 226, 7, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[246200, 6437, 104, 3, 28, "Print",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[246307, 6442, 104, 3, 28, "Print",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[246414, 6447, 104, 3, 28, "Print",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[246521, 6452, 104, 3, 28, "Print",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[246640, 6458, 279, 7, 39, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[246944, 6469, 132, 4, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[247079, 6475, 108, 3, 24, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[247202, 6481, 616, 12, 90, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[247843, 6497, 179, 4, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[248025, 6503, 140, 3, 24, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[248180, 6509, 338, 8, 56, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[248521, 6519, 151, 4, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[248675, 6525, 168, 4, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[248846, 6531, 176, 4, 39, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[249047, 6539, 180, 4, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[249230, 6545, 5475, 118, 537, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[254720, 6666, 233, 7, 39, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[254956, 6675, 213, 7, 66, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[255194, 6686, 221, 7, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[255418, 6695, 179, 4, 24, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[255612, 6702, 451, 10, 73, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[256088, 6716, 230, 8, 86, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[256321, 6726, 145, 3, 24, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[256469, 6731, 145, 3, 24, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[256629, 6737, 225, 7, 39, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[256879, 6748, 181, 4, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[257063, 6754, 233, 5, 43, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[257311, 6762, 222, 7, 39, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[257558, 6773, 166, 4, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[257727, 6779, 131, 3, 24, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[257895, 6787, 188, 4, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[258086, 6793, 2021, 52, 171, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[260122, 6848, 506, 10, 73, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[260653, 6862, 198, 6, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[260854, 6870, 906, 23, 43, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[261797, 6898, 247, 8, 86, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[262047, 6908, 1959, 47, 62, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[264043, 6960, 221, 8, 86, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[264267, 6970, 757, 19, 35, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[265061, 6994, 216, 8, 86, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[265280, 7004, 748, 19, 37, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[266065, 7028, 203, 6, 46, "Input",
      CellTags->{"Rolling Disk", "i:9"}],
    Cell[266271, 7036, 3311, 74, 138, "Output",
      CellTags->{"i:9", "Rolling Disk"}],
    Cell[269597, 7113, 228, 7, 39, "Text",
      Evaluatable->False,
      CellTags->{"Rolling Disk", "i:9"}]},
  "Drive Chain"->{
    Cell[269862, 7125, 150, 4, 48, "Subsection",
      Evaluatable->False,
      CellTags->"Drive Chain"],
    Cell[270015, 7131, 302, 8, 56, "Text",
      Evaluatable->False,
      CellTags->"Drive Chain"],
    Cell[270342, 7143, 143, 4, 51, "Subsubsection",
      Evaluatable->False,
      CellTags->"Drive Chain"],
    Cell[270488, 7149, 140, 4, 25, "Text",
      Evaluatable->False,
      CellTags->"Drive Chain"],
    Cell[270653, 7157, 274, 10, 112, "Input",
      CellTags->"Drive Chain"],
    Cell[270930, 7169, 240, 5, 70, "Message",
      CellTags->"Drive Chain"],
    Cell[271185, 7177, 146, 4, 25, "Text",
      Evaluatable->False,
      CellTags->"Drive Chain"],
    Cell[271356, 7185, 312, 10, 92, "Input",
      CellTags->"Drive Chain"],
    Cell[271671, 7197, 240, 5, 70, "Message",
      CellTags->"Drive Chain"],
    Cell[271926, 7205, 142, 4, 25, "Text",
      Evaluatable->False,
      CellTags->"Drive Chain"],
    Cell[272071, 7211, 288, 9, 92, "Input",
      CellTags->"Drive Chain"],
    Cell[272384, 7224, 158, 4, 32, "Input",
      CellTags->"Drive Chain"],
    Cell[272545, 7230, 245, 5, 70, "Message",
      CellTags->"Drive Chain"],
    Cell[272839, 7241, 144, 4, 45, "Subsubsection",
      Evaluatable->False,
      CellTags->"Drive Chain"],
    Cell[272986, 7247, 268, 9, 41, "Text",
      Evaluatable->False,
      CellTags->"Drive Chain"],
    Cell[273257, 7258, 203, 8, 72, "Input",
      CellTags->"Drive Chain"],
    Cell[273463, 7268, 276, 9, 41, "Text",
      Evaluatable->False,
      CellTags->"Drive Chain"],
    Cell[273742, 7279, 225, 8, 72, "Input",
      CellTags->"Drive Chain"],
    Cell[273970, 7289, 484, 10, 59, "Text",
      Evaluatable->False,
      CellTags->"Drive Chain"],
    Cell[274479, 7303, 261, 12, 152, "Input",
      CellTags->"Drive Chain"],
    Cell[274743, 7317, 247, 5, 70, "Message",
      CellTags->"Drive Chain"],
    Cell[275039, 7328, 149, 4, 45, "Subsubsection",
      Evaluatable->False,
      CellTags->"Drive Chain"],
    Cell[275191, 7334, 168, 4, 25, "Text",
      Evaluatable->False,
      CellTags->"Drive Chain"],
    Cell[275384, 7342, 148, 4, 32, "Input",
      CellTags->"Drive Chain"],
    Cell[275535, 7348, 245, 5, 70, "Message",
      CellTags->"Drive Chain"],
    Cell[275829, 7359, 162, 4, 45, "Subsubsection",
      Evaluatable->False,
      CellTags->"Drive Chain"],
    Cell[275994, 7365, 137, 4, 46, "Input",
      CellTags->"Drive Chain"],
    Cell[276156, 7373, 144, 4, 46, "Input",
      CellTags->"Drive Chain"],
    Cell[276303, 7379, 121, 3, 70, "Print",
      CellTags->"Drive Chain"],
    Cell[276427, 7384, 121, 3, 70, "Print",
      CellTags->"Drive Chain"],
    Cell[276551, 7389, 121, 3, 70, "Print",
      CellTags->"Drive Chain"],
    Cell[276709, 7397, 198, 6, 46, "Input",
      CellTags->"Drive Chain"],
    Cell[276910, 7405, 122, 3, 70, "Print",
      CellTags->"Drive Chain"],
    Cell[277035, 7410, 117, 3, 70, "Print",
      CellTags->"Drive Chain"],
    Cell[277155, 7415, 120, 3, 70, "Print",
      CellTags->"Drive Chain"],
    Cell[277324, 7424, 156, 4, 51, "Subsubsection",
      Evaluatable->False,
      CellTags->"Drive Chain"],
    Cell[277483, 7430, 469, 10, 59, "Text",
      Evaluatable->False,
      CellTags->"Drive Chain"],
    Cell[277955, 7442, 356, 9, 92, "Input",
      CellTags->"Drive Chain"],
    Cell[278314, 7453, 297, 8, 72, "Input",
      CellTags->"Drive Chain"],
    Cell[278614, 7463, 267, 8, 72, "Input",
      CellTags->"Drive Chain"],
    Cell[278884, 7473, 124, 4, 32, "Input",
      CellTags->"Drive Chain"],
    Cell[279033, 7481, 226, 7, 46, "Input",
      CellTags->"Drive Chain"],
    Cell[279262, 7490, 95, 3, 28, "Print",
      CellTags->"Drive Chain"],
    Cell[279360, 7495, 95, 3, 28, "Print",
      CellTags->"Drive Chain"],
    Cell[279458, 7500, 95, 3, 28, "Print",
      CellTags->"Drive Chain"],
    Cell[279556, 7505, 95, 3, 28, "Print",
      CellTags->"Drive Chain"],
    Cell[279654, 7510, 127, 3, 28, "Print",
      CellTags->"Drive Chain"],
    Cell[279818, 7518, 121, 4, 46, "Input",
      CellTags->"Drive Chain"],
    Cell[279942, 7524, 308, 6, 43, "Output",
      CellTags->"Drive Chain"],
    Cell[280287, 7535, 121, 4, 46, "Input",
      CellTags->"Drive Chain"],
    Cell[280411, 7541, 595, 10, 81, "Output",
      CellTags->"Drive Chain"],
    Cell[281043, 7556, 121, 4, 46, "Input",
      CellTags->"Drive Chain"],
    Cell[281167, 7562, 90, 3, 24, "Output",
      CellTags->"Drive Chain"]},
  "References"->{
    Cell[281330, 7573, 139, 4, 99, "Section",
      Evaluatable->False,
      CellTags->"References"],
    Cell[281472, 7579, 1476, 28, 432, "Text",
      Evaluatable->False,
      CellTags->"References"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Introduction", 284399, 7644},
  {"Getting Started", 284625, 7651},
  {"What's in the Package", 285197, 7667},
  {"Data Structures", 286143, 7691},
  {"Building Equations", 289110, 7770},
  {"i:1", 291633, 7836},
  {"Simulation", 291744, 7839},
  {"i:2", 294149, 7898},
  {"Creating MEX-Files", 296569, 7957},
  {"i:3", 298220, 7995},
  {"Suspension", 299706, 8029},
  {"i:4", 303109, 8114},
  {"Flexible Manipulator", 306529, 8199},
  {"i:5", 311169, 8304},
  {"Tractor-Trailer", 315821, 8409},
  {"i:6", 322100, 8555},
  {"Constraints Intro", 328393, 8701},
  {"Closed Chain", 328719, 8710},
  {"i:7", 334187, 8841},
  {"i:8", 337325, 8917},
  {"Rolling Disk", 339676, 8973},
  {"i:9", 345832, 9123},
  {"Drive Chain", 351996, 9273},
  {"References", 356485, 9395}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 142, 4, 59, "Title",
  Evaluatable->False],
Cell[1884, 57, 35, 0, 33, "Subtitle"],
Cell[1922, 59, 97, 3, 50, "Subsubtitle"],

Cell[CellGroupData[{
Cell[2044, 66, 33, 0, 33, "Subtitle"],
Cell[2080, 68, 52, 0, 32, "Subsubtitle"],
Cell[2135, 70, 102, 2, 50, "Input"],

Cell[CellGroupData[{
Cell[2262, 76, 141, 4, 99, "Section",
  Evaluatable->False,
  CellTags->"Introduction"],
Cell[2406, 82, 1772, 30, 377, "Text",
  Evaluatable->False,
  CellTags->"Introduction"]
}, Closed]],

Cell[CellGroupData[{
Cell[4215, 117, 147, 4, 67, "Section",
  Evaluatable->False,
  CellTags->"Getting Started"],
Cell[4365, 123, 762, 15, 93, "Text",
  Evaluatable->False,
  CellTags->"Getting Started"],
Cell[5130, 140, 246, 9, 25, "Text",
  Evaluatable->False,
  CellTags->"Getting Started"],

Cell[CellGroupData[{
Cell[5401, 153, 130, 4, 32, "Input",
  CellTags->"Getting Started"],
Cell[5534, 159, 700, 10, 237, "Print",
  CellTags->"Getting Started"]
}, Open  ]],
Cell[6249, 172, 162, 6, 25, "Text",
  CellTags->"Getting Started"]
}, Closed]],

Cell[CellGroupData[{
Cell[6448, 183, 127, 3, 53, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6600, 190, 163, 4, 54, "Subsection",
  Evaluatable->False,
  CellTags->"What's in the Package"],
Cell[6766, 196, 222, 7, 39, "Text",
  Evaluatable->False,
  CellTags->"What's in the Package"],

Cell[CellGroupData[{
Cell[7013, 207, 135, 4, 46, "Input",
  CellTags->"What's in the Package"],
Cell[7151, 213, 110, 2, 28, "Print",
  CellTags->"What's in the Package"],
Cell[7264, 217, 103, 3, 24, "Output",
  CellTags->"What's in the Package"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7404, 225, 107, 3, 44, "Input",
  CellTags->"What's in the Package"],
Cell[7514, 230, 1166, 19, 579, "Print",
  CellTags->"What's in the Package"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8717, 254, 115, 3, 30, "Input",
  CellTags->"What's in the Package"],
Cell[8835, 259, 1229, 18, 579, "Print",
  CellTags->"What's in the Package"]
}, Open  ]],
Cell[10079, 280, 1880, 31, 395, "Text",
  Evaluatable->False,
  CellTags->"What's in the Package"]
}, Closed]],

Cell[CellGroupData[{
Cell[11996, 316, 150, 4, 48, "Subsection",
  Evaluatable->False,
  CellTags->"Data Structures"],

Cell[CellGroupData[{
Cell[12171, 324, 153, 4, 51, "Subsubsection",
  Evaluatable->False,
  CellTags->"Data Structures"],
Cell[12327, 330, 3336, 46, 773, "Text",
  Evaluatable->False,
  CellTags->"Data Structures"]
}, Closed]],

Cell[CellGroupData[{
Cell[15700, 381, 72, 1, 45, "Subsubsection",
  CellTags->"Data Structures"],
Cell[15775, 384, 1074, 16, 178, "Text",
  CellTags->"Data Structures"]
}, Closed]],

Cell[CellGroupData[{
Cell[16886, 405, 144, 4, 45, "Subsubsection",
  Evaluatable->False,
  CellTags->"Data Structures"],
Cell[17033, 411, 1952, 28, 425, "Text",
  Evaluatable->False,
  CellTags->"Data Structures"],
Cell[18988, 441, 204, 7, 52, "Input",
  CellTags->"Data Structures"],
Cell[19195, 450, 216, 7, 25, "Text",
  Evaluatable->False,
  CellTags->"Data Structures"],
Cell[19414, 459, 206, 7, 52, "Input",
  CellTags->"Data Structures"],
Cell[19623, 468, 384, 9, 42, "Text",
  Evaluatable->False,
  CellTags->"Data Structures"],

Cell[CellGroupData[{
Cell[20032, 481, 196, 8, 72, "Input",
  CellTags->"Data Structures"],
Cell[20231, 491, 94, 2, 28, "Print",
  CellTags->"Data Structures"],
Cell[20328, 495, 94, 2, 28, "Print",
  CellTags->"Data Structures"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20459, 502, 130, 4, 32, "Input",
  CellTags->"Data Structures"],
Cell[20592, 508, 107, 2, 28, "Print",
  CellTags->"Data Structures"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20736, 515, 130, 4, 32, "Input",
  CellTags->"Data Structures"],
Cell[20869, 521, 447, 7, 123, "Print",
  CellTags->"Data Structures"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21353, 533, 130, 4, 32, "Input",
  CellTags->"Data Structures"],
Cell[21486, 539, 189, 3, 47, "Print",
  CellTags->"Data Structures"]
}, Open  ]],
Cell[21690, 545, 624, 12, 93, "Text",
  Evaluatable->False,
  CellTags->"Data Structures"],

Cell[CellGroupData[{
Cell[22339, 561, 258, 11, 132, "Input",
  CellTags->"Data Structures"],
Cell[22600, 574, 94, 2, 28, "Print",
  CellTags->"Data Structures"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22731, 581, 130, 4, 32, "Input",
  CellTags->"Data Structures"],
Cell[22864, 587, 588, 9, 156, "Print",
  CellTags->"Data Structures"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23489, 601, 130, 4, 46, "Input",
  CellTags->"Data Structures"],
Cell[23622, 607, 421, 7, 118, "Print",
  CellTags->"Data Structures"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24080, 619, 130, 4, 46, "Input",
  CellTags->"Data Structures"],
Cell[24213, 625, 197, 3, 61, "Print",
  CellTags->"Data Structures"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[24459, 634, 150, 4, 45, "Subsubsection",
  Evaluatable->False,
  CellTags->"Data Structures"],
Cell[24612, 640, 1346, 26, 357, "Text",
  Evaluatable->False,
  CellTags->"Data Structures"]
}, Closed]],

Cell[CellGroupData[{
Cell[25995, 671, 153, 4, 45, "Subsubsection",
  Evaluatable->False,
  CellTags->"Data Structures"],
Cell[26151, 677, 2915, 49, 747, "Text",
  Evaluatable->False,
  CellTags->"Data Structures"]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[29127, 733, 147, 3, 85, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[29299, 740, 170, 4, 54, "Subsection",
  Evaluatable->False,
  CellTags->"Building Equations"],
Cell[29472, 746, 434, 13, 214, "Text",
  Evaluatable->False,
  CellTags->"Building Equations"],
Cell[29909, 761, 295, 12, 166, "Input",
  CellTags->{"Building Equations", "i:1"}],
Cell[30207, 775, 148, 4, 39, "Text",
  Evaluatable->False,
  CellTags->"Building Equations"],
Cell[30358, 781, 363, 12, 166, "Input",
  CellTags->"Building Equations"],
Cell[30724, 795, 164, 4, 39, "Text",
  Evaluatable->False,
  CellTags->"Building Equations"],
Cell[30891, 801, 149, 4, 46, "Input",
  CellTags->"Building Equations"],
Cell[31043, 807, 303, 8, 81, "Text",
  Evaluatable->False,
  CellTags->"Building Equations"],
Cell[31349, 817, 147, 4, 46, "Input",
  CellTags->"Building Equations"],

Cell[CellGroupData[{
Cell[31521, 825, 198, 6, 46, "Input",
  CellTags->"Building Equations"],
Cell[31722, 833, 95, 2, 42, "Print",
  CellTags->"Building Equations"],
Cell[31820, 837, 97, 2, 42, "Print",
  CellTags->"Building Equations"],
Cell[31920, 841, 97, 2, 42, "Print",
  CellTags->"Building Equations"],
Cell[32020, 845, 98, 2, 42, "Print",
  CellTags->"Building Equations"],
Cell[32121, 849, 93, 2, 42, "Print",
  CellTags->"Building Equations"],
Cell[32217, 853, 96, 2, 42, "Print",
  CellTags->"Building Equations"]
}, Open  ]],
Cell[32328, 858, 160, 4, 39, "Text",
  Evaluatable->False,
  CellTags->"Building Equations"],

Cell[CellGroupData[{
Cell[32513, 866, 145, 4, 46, "Input",
  CellTags->"Building Equations"],
Cell[32661, 872, 385, 13, 56, "Print",
  CellTags->"Building Equations"]
}, Open  ]],
Cell[33061, 888, 372, 9, 56, "Text",
  Evaluatable->False,
  CellTags->"Building Equations"],

Cell[CellGroupData[{
Cell[33458, 901, 145, 4, 46, "Input",
  CellTags->"Building Equations"],
Cell[33606, 907, 452, 11, 60, "Print",
  CellTags->"Building Equations"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34095, 923, 146, 4, 46, "Input",
  CellTags->"Building Equations"],
Cell[34244, 929, 742, 25, 54, "Print",
  CellTags->"Building Equations"]
}, Open  ]],
Cell[35001, 957, 434, 9, 73, "Text",
  Evaluatable->False,
  CellTags->"Building Equations"],
Cell[35438, 968, 204, 7, 66, "Input",
  CellTags->"Building Equations"],
Cell[35645, 977, 180, 4, 39, "Text",
  Evaluatable->False,
  CellTags->"Building Equations"],
Cell[35828, 983, 140, 4, 46, "Input",
  CellTags->"Building Equations"]
}, Closed]],

Cell[CellGroupData[{
Cell[36005, 992, 169, 4, 48, "Subsection",
  Evaluatable->False,
  CellTags->{"Simulation", "i:2"}],
Cell[36177, 998, 352, 8, 56, "Text",
  Evaluatable->False,
  CellTags->{"Simulation", "i:2"}],

Cell[CellGroupData[{
Cell[36554, 1010, 161, 4, 46, "Input",
  CellTags->{"Simulation", "i:2"}],
Cell[36718, 1016, 2493, 56, 268, "Output",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]],
Cell[39226, 1075, 213, 6, 39, "Text",
  Evaluatable->False,
  CellTags->{"Simulation", "i:2"}],

Cell[CellGroupData[{
Cell[39464, 1085, 186, 4, 46, "Input",
  CellTags->{"Simulation", "i:2"}],
Cell[39653, 1091, 199, 4, 38, "Output",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[39889, 1100, 164, 4, 46, "Input",
  CellTags->{"Simulation", "i:2"}],
Cell[40056, 1106, 2080, 50, 215, "Output",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[42173, 1161, 140, 4, 46, "Input",
  CellTags->{"Simulation", "i:2"}],
Cell[42316, 1167, 114, 3, 38, "Output",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[42467, 1175, 234, 7, 46, "Input",
  CellTags->{"Simulation", "i:2"}],
Cell[42704, 1184, 146, 3, 38, "Output",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[42887, 1192, 206, 6, 46, "Input",
  CellTags->{"Simulation", "i:2"}],
Cell[43096, 1200, 444, 12, 38, "Output",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[43577, 1217, 171, 4, 46, "Input",
  CellTags->{"Simulation", "i:2"}],
Cell[43751, 1223, 2406, 58, 253, "Output",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]],
Cell[46172, 1284, 236, 7, 39, "Text",
  Evaluatable->False,
  CellTags->{"Simulation", "i:2"}],

Cell[CellGroupData[{
Cell[46433, 1295, 164, 4, 46, "Input",
  CellTags->{"Simulation", "i:2"}],
Cell[46600, 1301, 809, 21, 95, "Output",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[47446, 1327, 163, 4, 46, "Input",
  CellTags->{"Simulation", "i:2"}],
Cell[47612, 1333, 31379, 839, 200, 8052, 545, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->{"Simulation", "i:2"}],
Cell[78994, 2174, 190, 5, 38, "Output",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[79221, 2184, 163, 4, 46, "Input",
  CellTags->{"Simulation", "i:2"}],
Cell[79387, 2190, 53963, 1165, 200, 9149, 606, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->{"Simulation", "i:2"}],
Cell[133353, 3357, 190, 5, 38, "Output",
  CellTags->{"Simulation", "i:2"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[133592, 3368, 165, 4, 48, "Subsection",
  Evaluatable->False,
  CellTags->{"Creating MEX-Files", "i:3"}],
Cell[133760, 3374, 730, 13, 107, "Text",
  Evaluatable->False,
  CellTags->{"Creating MEX-Files", "i:3"}],
Cell[134493, 3389, 222, 6, 39, "Text",
  Evaluatable->False,
  CellTags->{"Creating MEX-Files", "i:3"}],

Cell[CellGroupData[{
Cell[134740, 3399, 263, 9, 106, "Input",
  CellTags->{"Creating MEX-Files", "i:3"}],
Cell[135006, 3410, 281, 6, 57, "Output",
  CellTags->{"Creating MEX-Files", "i:3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[135324, 3421, 599, 15, 186, "Input",
  CellTags->{"Creating MEX-Files", "i:3"}],
Cell[135926, 3438, 116, 2, 42, "Print",
  CellTags->{"Creating MEX-Files", "i:3"}],
Cell[136045, 3442, 103, 2, 42, "Print",
  CellTags->{"Creating MEX-Files", "i:3"}],
Cell[136151, 3446, 123, 2, 42, "Print",
  CellTags->{"Creating MEX-Files", "i:3"}],
Cell[136277, 3450, 122, 2, 42, "Print",
  CellTags->{"Creating MEX-Files", "i:3"}],
Cell[136402, 3454, 110, 2, 42, "Print",
  CellTags->{"Creating MEX-Files", "i:3"}],
Cell[136515, 3458, 118, 2, 42, "Print",
  CellTags->{"Creating MEX-Files", "i:3"}],
Cell[136636, 3462, 113, 2, 42, "Print",
  CellTags->{"Creating MEX-Files", "i:3"}],
Cell[136752, 3466, 112, 2, 42, "Print",
  CellTags->{"Creating MEX-Files", "i:3"}],
Cell[136867, 3470, 116, 2, 42, "Print",
  CellTags->{"Creating MEX-Files", "i:3"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[137032, 3478, 83, 1, 48, "Subsection",
  CellTags->"Creating MEX-Files"],
Cell[137118, 3481, 1678, 29, 426, "Text",
  CellTags->"Creating MEX-Files"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[138845, 3516, 139, 3, 85, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[139009, 3523, 124, 3, 40, "Subsection",
  Evaluatable->False],
Cell[139136, 3528, 597, 11, 76, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[139770, 3544, 164, 4, 48, "Subsection",
  Evaluatable->False,
  CellTags->{"Suspension", "i:4"}],
Cell[139937, 3550, 560, 12, 115, "Text",
  Evaluatable->False,
  CellTags->{"Suspension", "i:4"}],

Cell[CellGroupData[{
Cell[140522, 3566, 509, 20, 326, "Input",
  CellTags->{"Suspension", "i:4"}],
Cell[141034, 3588, 98, 2, 42, "Print",
  CellTags->{"Suspension", "i:4"}],
Cell[141135, 3592, 98, 2, 42, "Print",
  CellTags->{"Suspension", "i:4"}],
Cell[141236, 3596, 98, 2, 42, "Print",
  CellTags->{"Suspension", "i:4"}]
}, Open  ]],
Cell[141349, 3601, 142, 4, 39, "Text",
  Evaluatable->False,
  CellTags->{"Suspension", "i:4"}],
Cell[141494, 3607, 588, 23, 366, "Input",
  CellTags->{"Suspension", "i:4"}],
Cell[142085, 3632, 219, 7, 64, "Text",
  Evaluatable->False,
  CellTags->{"Suspension", "i:4"}],
Cell[142307, 3641, 164, 4, 46, "Input",
  CellTags->{"Suspension", "i:4"}],
Cell[142474, 3647, 707, 14, 140, "Text",
  Evaluatable->False,
  CellTags->{"Suspension", "i:4"}],
Cell[143184, 3663, 252, 9, 106, "Input",
  CellTags->{"Suspension", "i:4"}],
Cell[143439, 3674, 342, 8, 56, "Text",
  Evaluatable->False,
  CellTags->{"Suspension", "i:4"}],
Cell[143784, 3684, 241, 8, 86, "Input",
  CellTags->{"Suspension", "i:4"}],

Cell[CellGroupData[{
Cell[144050, 3696, 132, 4, 46, "Input",
  CellTags->{"Suspension", "i:4"}],
Cell[144185, 3702, 423, 8, 109, "Output",
  CellTags->{"Suspension", "i:4"}]
}, Open  ]],
Cell[144623, 3713, 666, 12, 107, "Text",
  Evaluatable->False,
  CellTags->{"Suspension", "i:4"}],
Cell[145292, 3727, 341, 12, 166, "Input",
  CellTags->{"Suspension", "i:4"}],

Cell[CellGroupData[{
Cell[145658, 3743, 136, 4, 46, "Input",
  CellTags->{"Suspension", "i:4"}],
Cell[145797, 3749, 203, 4, 65, "Output",
  CellTags->{"Suspension", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[146037, 3758, 136, 4, 46, "Input",
  CellTags->{"Suspension", "i:4"}],
Cell[146176, 3764, 203, 4, 65, "Output",
  CellTags->{"Suspension", "i:4"}]
}, Open  ]],
Cell[146394, 3771, 509, 11, 98, "Text",
  Evaluatable->False,
  CellTags->{"Suspension", "i:4"}],
Cell[146906, 3784, 149, 4, 46, "Input",
  CellTags->{"Suspension", "i:4"}],
Cell[147058, 3790, 251, 8, 64, "Text",
  Evaluatable->False,
  CellTags->{"Suspension", "i:4"}],
Cell[147312, 3800, 133, 4, 46, "Input",
  CellTags->{"Suspension", "i:4"}],
Cell[147448, 3806, 335, 9, 81, "Text",
  Evaluatable->False,
  CellTags->{"Suspension", "i:4"}],

Cell[CellGroupData[{
Cell[147808, 3819, 207, 6, 46, "Input",
  CellTags->{"Suspension", "i:4"}],
Cell[148018, 3827, 99, 2, 42, "Print",
  CellTags->{"Suspension", "i:4"}],
Cell[148120, 3831, 94, 2, 42, "Print",
  CellTags->{"Suspension", "i:4"}],
Cell[148217, 3835, 97, 2, 42, "Print",
  CellTags->{"Suspension", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[148351, 3842, 128, 4, 46, "Input",
  CellTags->{"Suspension", "i:4"}],
Cell[148482, 3848, 5513, 109, 1386, "Output",
  CellTags->{"Suspension", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[154032, 3962, 142, 4, 46, "Input",
  CellTags->{"Suspension", "i:4"}],
Cell[154177, 3968, 1026, 19, 214, "Output",
  CellTags->{"Suspension", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[155240, 3992, 128, 4, 46, "Input",
  CellTags->{"Suspension", "i:4"}],
Cell[155371, 3998, 3543, 61, 1013, "Output",
  CellTags->{"Suspension", "i:4"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[158963, 4065, 180, 4, 48, "Subsection",
  Evaluatable->False,
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[159146, 4071, 580, 11, 90, "Text",
  Evaluatable->False,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[CellGroupData[{
Cell[159751, 4086, 176, 4, 51, "Subsubsection",
  Evaluatable->False,
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[159930, 4092, 1679, 27, 284, "Text",
  Evaluatable->False,
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[161612, 4121, 167, 4, 46, "Input",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[161782, 4127, 194, 4, 39, "Text",
  Evaluatable->False,
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[161979, 4133, 181, 4, 46, "Input",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[162163, 4139, 180, 4, 39, "Text",
  Evaluatable->False,
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[162346, 4145, 310, 9, 86, "Input",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[162659, 4156, 309, 8, 56, "Text",
  Evaluatable->False,
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[162971, 4166, 291, 12, 166, "Input",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[163265, 4180, 231, 7, 66, "Input",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[163499, 4189, 380, 8, 56, "Text",
  Evaluatable->False,
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[163882, 4199, 178, 4, 46, "Input",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[164063, 4205, 212, 6, 39, "Text",
  Evaluatable->False,
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[164278, 4213, 154, 4, 46, "Input",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[164435, 4219, 192, 4, 39, "Text",
  Evaluatable->False,
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[164630, 4225, 256, 9, 106, "Input",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[164889, 4236, 169, 4, 39, "Text",
  Evaluatable->False,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[CellGroupData[{
Cell[165083, 4244, 195, 4, 46, "Input",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[165281, 4250, 960, 15, 253, "Output",
  CellTags->{"Flexible Manipulator", "i:5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[166278, 4270, 195, 4, 46, "Input",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[166476, 4276, 960, 15, 253, "Output",
  CellTags->{"Flexible Manipulator", "i:5"}]
}, Open  ]],
Cell[167451, 4294, 160, 4, 46, "Input",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[167614, 4300, 307, 14, 206, "Input",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[167924, 4316, 189, 7, 66, "Input",
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[CellGroupData[{
Cell[168138, 4327, 213, 6, 46, "Input",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[168354, 4335, 106, 2, 42, "Print",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[168463, 4339, 108, 2, 42, "Print",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[168574, 4343, 108, 2, 42, "Print",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[168685, 4347, 109, 2, 42, "Print",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[168797, 4351, 104, 2, 42, "Print",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[168904, 4355, 107, 2, 42, "Print",
  CellTags->{"Flexible Manipulator", "i:5"}]
}, Open  ]],
Cell[169026, 4360, 178, 4, 39, "Text",
  Evaluatable->False,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[CellGroupData[{
Cell[169229, 4368, 138, 4, 46, "Input",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[169370, 4374, 8858, 149, 2004, "Output",
  CellTags->{"Flexible Manipulator", "i:5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[178265, 4528, 151, 4, 46, "Input",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[178419, 4534, 5513, 90, 733, "Output",
  CellTags->{"Flexible Manipulator", "i:5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[183969, 4629, 139, 4, 46, "Input",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[184111, 4635, 2301, 37, 379, "Output",
  CellTags->{"Flexible Manipulator", "i:5"}]
}, Open  ]],
Cell[186427, 4675, 278, 7, 39, "Text",
  Evaluatable->False,
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[186708, 4684, 179, 4, 46, "Input",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[186890, 4690, 184, 4, 39, "Text",
  Evaluatable->False,
  CellTags->{"Flexible Manipulator", "i:5"}],

Cell[CellGroupData[{
Cell[187099, 4698, 156, 4, 46, "Input",
  CellTags->{"Flexible Manipulator", "i:5"}],
Cell[187258, 4704, 1347, 27, 333, "Output",
  CellTags->{"Flexible Manipulator", "i:5"}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[188666, 4738, 164, 4, 48, "Subsection",
  Evaluatable->False,
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[188833, 4744, 539, 11, 98, "Text",
  Evaluatable->False,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[CellGroupData[{
Cell[189397, 4759, 165, 4, 51, "Subsubsection",
  Evaluatable->False,
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[189565, 4765, 163, 4, 39, "Text",
  Evaluatable->False,
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[189731, 4771, 249, 9, 106, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[189983, 4782, 288, 9, 55, "Text",
  Evaluatable->False,
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[190274, 4793, 314, 8, 56, "Text",
  Evaluatable->False,
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[190591, 4803, 389, 15, 226, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[190983, 4820, 282, 9, 55, "Text",
  Evaluatable->False,
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[191268, 4831, 296, 10, 126, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[191601, 4846, 166, 4, 51, "Subsubsection",
  Evaluatable->False,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[CellGroupData[{
Cell[191792, 4854, 169, 4, 46, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[191964, 4860, 103, 2, 42, "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[192070, 4864, 103, 2, 42, "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[192176, 4868, 103, 2, 42, "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[192282, 4872, 103, 2, 42, "Print",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[192422, 4879, 141, 4, 46, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[192566, 4885, 87, 2, 42, "Print",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[192702, 4893, 156, 4, 51, "Subsubsection",
  Evaluatable->False,
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[192861, 4899, 611, 15, 256, "Text",
  Evaluatable->False,
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[193475, 4916, 1252, 38, 646, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[194764, 4959, 158, 4, 51, "Subsubsection",
  Evaluatable->False,
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[194925, 4965, 476, 10, 73, "Text",
  Evaluatable->False,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[CellGroupData[{
Cell[195426, 4979, 366, 14, 186, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[195795, 4995, 7597, 124, 1560, "Output",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[203429, 5124, 140, 4, 46, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[203572, 5130, 101, 2, 42, "Print",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],
Cell[203688, 5135, 185, 4, 46, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[CellGroupData[{
Cell[203898, 5143, 138, 4, 46, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[204039, 5149, 443, 8, 119, "Output",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],
Cell[204497, 5160, 351, 11, 146, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[CellGroupData[{
Cell[204873, 5175, 225, 7, 46, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[205101, 5184, 4834, 81, 589, "Output",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[209972, 5270, 141, 4, 46, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[210116, 5276, 101, 2, 42, "Print",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],
Cell[210232, 5281, 359, 11, 146, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[210594, 5294, 373, 12, 166, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[210970, 5308, 374, 12, 166, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[211347, 5322, 372, 12, 166, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[211722, 5336, 361, 12, 166, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[212086, 5350, 358, 12, 166, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[212447, 5364, 357, 12, 166, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[212807, 5378, 158, 4, 46, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[213002, 5387, 159, 4, 51, "Subsubsection",
  Evaluatable->False,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[CellGroupData[{
Cell[213186, 5395, 262, 8, 66, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[213451, 5405, 104, 2, 42, "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[213558, 5409, 99, 2, 42, "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[213660, 5413, 102, 2, 42, "Print",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],
Cell[213777, 5418, 208, 6, 46, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[213988, 5426, 400, 14, 206, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[214425, 5445, 186, 4, 51, "Subsubsection",
  Evaluatable->False,
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[214614, 5451, 504, 10, 73, "Text",
  Evaluatable->False,
  CellTags->{"Tractor-Trailer", "i:6"}],

Cell[CellGroupData[{
Cell[215143, 5465, 885, 27, 466, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[216031, 5494, 100, 2, 42, "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[216134, 5498, 120, 2, 42, "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[216257, 5502, 119, 2, 42, "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[216379, 5506, 107, 2, 42, "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[216489, 5510, 115, 2, 42, "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[216607, 5514, 110, 2, 42, "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[216720, 5518, 109, 2, 42, "Print",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[216832, 5522, 110, 2, 42, "Print",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[216979, 5529, 138, 4, 46, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[217120, 5535, 115, 3, 38, "Output",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[217272, 5543, 139, 4, 46, "Input",
  CellTags->{"Tractor-Trailer", "i:6"}],
Cell[217414, 5549, 150, 3, 38, "Output",
  CellTags->{"Tractor-Trailer", "i:6"}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[217637, 5560, 122, 3, 53, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[217784, 5567, 157, 4, 54, "Subsection",
  Evaluatable->False,
  CellTags->"Constraints Intro"],
Cell[217944, 5573, 2519, 41, 461, "Text",
  Evaluatable->False,
  CellTags->"Constraints Intro"],

Cell[CellGroupData[{
Cell[220488, 5618, 132, 4, 46, "Input",
  CellTags->"Constraints Intro"],
Cell[220623, 5624, 672, 10, 237, "Print"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[221344, 5640, 162, 4, 54, "Subsection",
  Evaluatable->False,
  CellTags->{"Closed Chain", "i:7"}],
Cell[221509, 5646, 406, 9, 73, "Text",
  Evaluatable->False,
  CellTags->{"Closed Chain", "i:7"}],
Cell[221918, 5657, 297, 14, 206, "Input",
  CellTags->{"Closed Chain", "i:7"}],
Cell[222218, 5673, 510, 13, 186, "Input",
  CellTags->{"Closed Chain", "i:7"}],
Cell[222731, 5688, 176, 7, 66, "Input",
  CellTags->{"Closed Chain", "i:7"}],

Cell[CellGroupData[{
Cell[222932, 5699, 204, 6, 46, "Input",
  CellTags->{"Closed Chain", "i:7"}],
Cell[223139, 5707, 140, 3, 42, "Print",
  CellTags->{"Closed Chain", "i:7"}],
Cell[223282, 5712, 128, 3, 42, "Print",
  CellTags->{"Closed Chain", "i:7"}],
Cell[223413, 5717, 130, 3, 42, "Print",
  CellTags->{"Closed Chain", "i:7"}],
Cell[223546, 5722, 130, 3, 42, "Print",
  CellTags->{"Closed Chain", "i:7"}],
Cell[223679, 5727, 131, 3, 42, "Print",
  CellTags->{"Closed Chain", "i:7"}],
Cell[223813, 5732, 126, 3, 42, "Print",
  CellTags->{"Closed Chain", "i:7"}],
Cell[223942, 5737, 129, 3, 42, "Print",
  CellTags->{"Closed Chain", "i:7"}]
}, Open  ]],
Cell[224086, 5743, 256, 7, 66, "Input",
  CellTags->{"Closed Chain", "i:7"}],
Cell[224345, 5752, 162, 4, 46, "Input",
  CellTags->{"Closed Chain", "i:7"}],

Cell[CellGroupData[{
Cell[224532, 5760, 145, 4, 46, "Input",
  CellTags->{"Closed Chain", "i:7"}],
Cell[224680, 5766, 211, 5, 38, "Output",
  CellTags->{"Closed Chain", "i:7"}]
}, Open  ]],
Cell[224906, 5774, 445, 9, 73, "Text",
  Evaluatable->False,
  CellTags->{"Closed Chain", "i:7"}],

Cell[CellGroupData[{
Cell[225376, 5787, 197, 6, 46, "Input",
  CellTags->{"Closed Chain", "i:7"}],
Cell[225576, 5795, 104, 3, 42, "Print",
  CellTags->{"Closed Chain", "i:7"}],
Cell[225683, 5800, 104, 3, 42, "Print",
  CellTags->{"Closed Chain", "i:7"}],
Cell[225790, 5805, 104, 3, 42, "Print",
  CellTags->{"Closed Chain", "i:7"}],
Cell[225897, 5810, 104, 3, 42, "Print",
  CellTags->{"Closed Chain", "i:7"}],
Cell[226004, 5815, 1074, 21, 268, "Output",
  CellTags->{"Closed Chain", "i:7"}]
}, Open  ]],
Cell[227093, 5839, 481, 10, 73, "Text",
  Evaluatable->False,
  CellTags->{"Closed Chain", "i:7"}],

Cell[CellGroupData[{
Cell[227599, 5853, 200, 6, 46, "Input",
  CellTags->{"Closed Chain", "i:7"}],
Cell[227802, 5861, 764, 14, 206, "Output",
  CellTags->{"Closed Chain", "i:7"}]
}, Open  ]],
Cell[228581, 5878, 213, 6, 39, "Text",
  Evaluatable->False,
  CellTags->{"Closed Chain", "i:7"}],

Cell[CellGroupData[{
Cell[228819, 5888, 166, 4, 46, "Input",
  CellTags->{"Closed Chain", "i:7"}],
Cell[228988, 5894, 1472, 33, 212, "Output",
  CellTags->{"Closed Chain", "i:7"}]
}, Open  ]],
Cell[230475, 5930, 320, 8, 56, "Text",
  Evaluatable->False,
  CellTags->{"Closed Chain", "i:7"}],

Cell[CellGroupData[{
Cell[230820, 5942, 174, 4, 46, "Input",
  CellTags->{"Closed Chain", "i:7"}],
Cell[230997, 5948, 1178, 30, 106, "Output",
  CellTags->{"Closed Chain", "i:7"}]
}, Open  ]],
Cell[232190, 5981, 279, 7, 56, "Text",
  Evaluatable->False,
  CellTags->{"Closed Chain", "i:7"}]
}, Closed]],

Cell[CellGroupData[{
Cell[232506, 5993, 161, 4, 48, "Subsection",
  Evaluatable->False,
  CellTags->{"Closed Chain", "i:8"}],
Cell[232670, 5999, 388, 9, 56, "Text",
  Evaluatable->False,
  CellTags->{"Closed Chain", "i:8"}],
Cell[233061, 6010, 319, 14, 206, "Input",
  CellTags->{"Closed Chain", "i:8"}],
Cell[233383, 6026, 506, 13, 186, "Input",
  CellTags->{"Closed Chain", "i:8"}],
Cell[233892, 6041, 178, 7, 66, "Input",
  CellTags->{"Closed Chain", "i:8"}],

Cell[CellGroupData[{
Cell[234095, 6052, 204, 6, 46, "Input",
  CellTags->{"Closed Chain", "i:8"}],
Cell[234302, 6060, 128, 3, 28, "Print",
  CellTags->{"Closed Chain", "i:8"}],
Cell[234433, 6065, 130, 3, 28, "Print",
  CellTags->{"Closed Chain", "i:8"}],
Cell[234566, 6070, 130, 3, 28, "Print",
  CellTags->{"Closed Chain", "i:8"}],
Cell[234699, 6075, 131, 3, 28, "Print",
  CellTags->{"Closed Chain", "i:8"}],
Cell[234833, 6080, 126, 3, 28, "Print",
  CellTags->{"Closed Chain", "i:8"}],
Cell[234962, 6085, 129, 3, 28, "Print",
  CellTags->{"Closed Chain", "i:8"}]
}, Open  ]],
Cell[235106, 6091, 256, 7, 66, "Input",
  CellTags->{"Closed Chain", "i:8"}],
Cell[235365, 6100, 162, 4, 46, "Input",
  CellTags->{"Closed Chain", "i:8"}],

Cell[CellGroupData[{
Cell[235552, 6108, 145, 4, 46, "Input",
  CellTags->{"Closed Chain", "i:8"}],
Cell[235700, 6114, 205, 5, 24, "Output",
  CellTags->{"Closed Chain", "i:8"}]
}, Open  ]],
Cell[235920, 6122, 235, 7, 39, "Text",
  Evaluatable->False,
  CellTags->{"Closed Chain", "i:8"}],

Cell[CellGroupData[{
Cell[236180, 6133, 201, 6, 46, "Input",
  CellTags->{"Closed Chain", "i:8"}],
Cell[236384, 6141, 104, 3, 28, "Print",
  CellTags->{"Closed Chain", "i:8"}],
Cell[236491, 6146, 104, 3, 28, "Print",
  CellTags->{"Closed Chain", "i:8"}],
Cell[236598, 6151, 104, 3, 28, "Print",
  CellTags->{"Closed Chain", "i:8"}],
Cell[236705, 6156, 104, 3, 28, "Print",
  CellTags->{"Closed Chain", "i:8"}],
Cell[236812, 6161, 136, 3, 28, "Print",
  CellTags->{"Closed Chain", "i:8"}],
Cell[236951, 6166, 2474, 45, 538, "Output",
  CellTags->{"Closed Chain", "i:8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[239462, 6216, 145, 4, 46, "Input",
  CellTags->{"Closed Chain", "i:8"}],
Cell[239610, 6222, 1244, 20, 224, "Output",
  CellTags->{"Closed Chain", "i:8"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[240903, 6248, 212, 6, 48, "Subsection",
  Evaluatable->False,
  CellTags->{"Rolling Disk", "i:9"}],
Cell[241118, 6256, 619, 12, 90, "Text",
  Evaluatable->False,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{
Cell[241762, 6272, 162, 7, 66, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[241927, 6281, 225, 4, 57, "Output",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],
Cell[242167, 6288, 207, 9, 106, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[242377, 6299, 323, 9, 81, "Text",
  Evaluatable->False,
  CellTags->{"Rolling Disk", "i:9"}],
Cell[242703, 6310, 211, 7, 66, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[242917, 6319, 313, 8, 86, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[243233, 6329, 158, 4, 39, "Text",
  Evaluatable->False,
  CellTags->{"Rolling Disk", "i:9"}],
Cell[243394, 6335, 178, 7, 66, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[243575, 6344, 180, 4, 39, "Text",
  Evaluatable->False,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{
Cell[243780, 6352, 204, 6, 46, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[243987, 6360, 128, 3, 28, "Print",
  CellTags->{"i:9", "Rolling Disk"}],
Cell[244118, 6365, 130, 3, 28, "Print",
  CellTags->{"i:9", "Rolling Disk"}],
Cell[244251, 6370, 131, 3, 28, "Print",
  CellTags->{"i:9", "Rolling Disk"}],
Cell[244385, 6375, 126, 3, 28, "Print",
  CellTags->{"i:9", "Rolling Disk"}],
Cell[244514, 6380, 129, 3, 28, "Print",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],
Cell[244658, 6386, 489, 10, 73, "Text",
  Evaluatable->False,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{
Cell[245172, 6400, 202, 7, 66, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[245377, 6409, 207, 4, 24, "Output",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],
Cell[245599, 6416, 347, 8, 56, "Text",
  Evaluatable->False,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{
Cell[245971, 6428, 226, 7, 46, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[246200, 6437, 104, 3, 28, "Print",
  CellTags->{"i:9", "Rolling Disk"}],
Cell[246307, 6442, 104, 3, 28, "Print",
  CellTags->{"i:9", "Rolling Disk"}],
Cell[246414, 6447, 104, 3, 28, "Print",
  CellTags->{"i:9", "Rolling Disk"}],
Cell[246521, 6452, 104, 3, 28, "Print",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],
Cell[246640, 6458, 279, 7, 39, "Text",
  Evaluatable->False,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{
Cell[246944, 6469, 132, 4, 46, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[247079, 6475, 108, 3, 24, "Output",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],
Cell[247202, 6481, 616, 12, 90, "Text",
  Evaluatable->False,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{
Cell[247843, 6497, 179, 4, 46, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[248025, 6503, 140, 3, 24, "Output",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],
Cell[248180, 6509, 338, 8, 56, "Text",
  Evaluatable->False,
  CellTags->{"Rolling Disk", "i:9"}],
Cell[248521, 6519, 151, 4, 46, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[248675, 6525, 168, 4, 46, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[248846, 6531, 176, 4, 39, "Text",
  Evaluatable->False,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{
Cell[249047, 6539, 180, 4, 46, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[249230, 6545, 5475, 118, 537, "Output",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],
Cell[254720, 6666, 233, 7, 39, "Text",
  Evaluatable->False,
  CellTags->{"Rolling Disk", "i:9"}],
Cell[254956, 6675, 213, 7, 66, "Input",
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{
Cell[255194, 6686, 221, 7, 46, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[255418, 6695, 179, 4, 24, "Output",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],
Cell[255612, 6702, 451, 10, 73, "Text",
  Evaluatable->False,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{
Cell[256088, 6716, 230, 8, 86, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[256321, 6726, 145, 3, 24, "Output",
  CellTags->{"i:9", "Rolling Disk"}],
Cell[256469, 6731, 145, 3, 24, "Output",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],
Cell[256629, 6737, 225, 7, 39, "Text",
  Evaluatable->False,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{
Cell[256879, 6748, 181, 4, 46, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[257063, 6754, 233, 5, 43, "Output",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],
Cell[257311, 6762, 222, 7, 39, "Text",
  Evaluatable->False,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{
Cell[257558, 6773, 166, 4, 46, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[257727, 6779, 131, 3, 24, "Output",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[257895, 6787, 188, 4, 46, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[258086, 6793, 2021, 52, 171, "Output",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],
Cell[260122, 6848, 506, 10, 73, "Text",
  Evaluatable->False,
  CellTags->{"Rolling Disk", "i:9"}],

Cell[CellGroupData[{
Cell[260653, 6862, 198, 6, 46, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[260854, 6870, 906, 23, 43, "Output",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[261797, 6898, 247, 8, 86, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[262047, 6908, 1959, 47, 62, "Output",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[264043, 6960, 221, 8, 86, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[264267, 6970, 757, 19, 35, "Output",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[265061, 6994, 216, 8, 86, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[265280, 7004, 748, 19, 37, "Output",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[266065, 7028, 203, 6, 46, "Input",
  CellTags->{"Rolling Disk", "i:9"}],
Cell[266271, 7036, 3311, 74, 138, "Output",
  CellTags->{"i:9", "Rolling Disk"}]
}, Open  ]],
Cell[269597, 7113, 228, 7, 39, "Text",
  Evaluatable->False,
  CellTags->{"Rolling Disk", "i:9"}]
}, Closed]],

Cell[CellGroupData[{
Cell[269862, 7125, 150, 4, 48, "Subsection",
  Evaluatable->False,
  CellTags->"Drive Chain"],
Cell[270015, 7131, 302, 8, 56, "Text",
  Evaluatable->False,
  CellTags->"Drive Chain"],

Cell[CellGroupData[{
Cell[270342, 7143, 143, 4, 51, "Subsubsection",
  Evaluatable->False,
  CellTags->"Drive Chain"],
Cell[270488, 7149, 140, 4, 25, "Text",
  Evaluatable->False,
  CellTags->"Drive Chain"],

Cell[CellGroupData[{
Cell[270653, 7157, 274, 10, 112, "Input",
  CellTags->"Drive Chain"],
Cell[270930, 7169, 240, 5, 70, "Message",
  CellTags->"Drive Chain"]
}, Open  ]],
Cell[271185, 7177, 146, 4, 25, "Text",
  Evaluatable->False,
  CellTags->"Drive Chain"],

Cell[CellGroupData[{
Cell[271356, 7185, 312, 10, 92, "Input",
  CellTags->"Drive Chain"],
Cell[271671, 7197, 240, 5, 70, "Message",
  CellTags->"Drive Chain"]
}, Open  ]],
Cell[271926, 7205, 142, 4, 25, "Text",
  Evaluatable->False,
  CellTags->"Drive Chain"],
Cell[272071, 7211, 288, 9, 92, "Input",
  CellTags->"Drive Chain"],

Cell[CellGroupData[{
Cell[272384, 7224, 158, 4, 32, "Input",
  CellTags->"Drive Chain"],
Cell[272545, 7230, 245, 5, 70, "Message",
  CellTags->"Drive Chain"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[272839, 7241, 144, 4, 45, "Subsubsection",
  Evaluatable->False,
  CellTags->"Drive Chain"],
Cell[272986, 7247, 268, 9, 41, "Text",
  Evaluatable->False,
  CellTags->"Drive Chain"],
Cell[273257, 7258, 203, 8, 72, "Input",
  CellTags->"Drive Chain"],
Cell[273463, 7268, 276, 9, 41, "Text",
  Evaluatable->False,
  CellTags->"Drive Chain"],
Cell[273742, 7279, 225, 8, 72, "Input",
  CellTags->"Drive Chain"],
Cell[273970, 7289, 484, 10, 59, "Text",
  Evaluatable->False,
  CellTags->"Drive Chain"],

Cell[CellGroupData[{
Cell[274479, 7303, 261, 12, 152, "Input",
  CellTags->"Drive Chain"],
Cell[274743, 7317, 247, 5, 70, "Message",
  CellTags->"Drive Chain"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[275039, 7328, 149, 4, 45, "Subsubsection",
  Evaluatable->False,
  CellTags->"Drive Chain"],
Cell[275191, 7334, 168, 4, 25, "Text",
  Evaluatable->False,
  CellTags->"Drive Chain"],

Cell[CellGroupData[{
Cell[275384, 7342, 148, 4, 32, "Input",
  CellTags->"Drive Chain"],
Cell[275535, 7348, 245, 5, 70, "Message",
  CellTags->"Drive Chain"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[275829, 7359, 162, 4, 45, "Subsubsection",
  Evaluatable->False,
  CellTags->"Drive Chain"],
Cell[275994, 7365, 137, 4, 46, "Input",
  CellTags->"Drive Chain"],

Cell[CellGroupData[{
Cell[276156, 7373, 144, 4, 46, "Input",
  CellTags->"Drive Chain"],
Cell[276303, 7379, 121, 3, 70, "Print",
  CellTags->"Drive Chain"],
Cell[276427, 7384, 121, 3, 70, "Print",
  CellTags->"Drive Chain"],
Cell[276551, 7389, 121, 3, 70, "Print",
  CellTags->"Drive Chain"]
}, Open  ]],

Cell[CellGroupData[{
Cell[276709, 7397, 198, 6, 46, "Input",
  CellTags->"Drive Chain"],
Cell[276910, 7405, 122, 3, 70, "Print",
  CellTags->"Drive Chain"],
Cell[277035, 7410, 117, 3, 70, "Print",
  CellTags->"Drive Chain"],
Cell[277155, 7415, 120, 3, 70, "Print",
  CellTags->"Drive Chain"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[277324, 7424, 156, 4, 51, "Subsubsection",
  Evaluatable->False,
  CellTags->"Drive Chain"],
Cell[277483, 7430, 469, 10, 59, "Text",
  Evaluatable->False,
  CellTags->"Drive Chain"],
Cell[277955, 7442, 356, 9, 92, "Input",
  CellTags->"Drive Chain"],
Cell[278314, 7453, 297, 8, 72, "Input",
  CellTags->"Drive Chain"],
Cell[278614, 7463, 267, 8, 72, "Input",
  CellTags->"Drive Chain"],
Cell[278884, 7473, 124, 4, 32, "Input",
  CellTags->"Drive Chain"],

Cell[CellGroupData[{
Cell[279033, 7481, 226, 7, 46, "Input",
  CellTags->"Drive Chain"],
Cell[279262, 7490, 95, 3, 28, "Print",
  CellTags->"Drive Chain"],
Cell[279360, 7495, 95, 3, 28, "Print",
  CellTags->"Drive Chain"],
Cell[279458, 7500, 95, 3, 28, "Print",
  CellTags->"Drive Chain"],
Cell[279556, 7505, 95, 3, 28, "Print",
  CellTags->"Drive Chain"],
Cell[279654, 7510, 127, 3, 28, "Print",
  CellTags->"Drive Chain"]
}, Open  ]],

Cell[CellGroupData[{
Cell[279818, 7518, 121, 4, 46, "Input",
  CellTags->"Drive Chain"],
Cell[279942, 7524, 308, 6, 43, "Output",
  CellTags->"Drive Chain"]
}, Open  ]],

Cell[CellGroupData[{
Cell[280287, 7535, 121, 4, 46, "Input",
  CellTags->"Drive Chain"],
Cell[280411, 7541, 595, 10, 81, "Output",
  CellTags->"Drive Chain"]
}, Open  ]],

Cell[CellGroupData[{
Cell[281043, 7556, 121, 4, 46, "Input",
  CellTags->"Drive Chain"],
Cell[281167, 7562, 90, 3, 24, "Output",
  CellTags->"Drive Chain"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[281330, 7573, 139, 4, 99, "Section",
  Evaluatable->False,
  CellTags->"References"],
Cell[281472, 7579, 1476, 28, 432, "Text",
  Evaluatable->False,
  CellTags->"References"]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

