(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     21912,        892]*)
(*NotebookOutlinePosition[     34192,       1258]*)
(*  CellTagsIndexPosition[     31148,       1168]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["TSi ProPac", "IndexSection",
  CellTags->"MasterIndexHeading"],

Cell[TextData[{
  "Ad",
  ", ",
  ButtonBox["LieBracket & Ad",
    ButtonData:>{"LieBracket & Ad", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Ad"],

Cell[TextData[{
  "AdaptiveBackstepRegulator",
  ", ",
  ButtonBox["Adaptive Control",
    ButtonData:>{"Adaptive Control", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AdaptiveBackstepRegulator"],

Cell[TextData[{
  "AdaptiveRegulator",
  ", ",
  ButtonBox["Adaptive Control",
    ButtonData:>{"Adaptive Control", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AdaptiveRegulator"],

Cell[TextData[{
  "AdaptiveTracking",
  ", ",
  ButtonBox["Adaptive Control",
    ButtonData:>{"Adaptive Control", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AdaptiveTracking"],

Cell[TextData[{
  "AlgebraicConstraints",
  ", ",
  ButtonBox["Closed Chains",
    ButtonData:>{"Closed Chains", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AlgebraicConstraints"],

Cell[TextData[{
  "AlgebraicRiccatiEquation",
  ", ",
  ButtonBox["The Algebraic Riccati Equation",
    ButtonData:>{"The Algebraic Riccati Equation", "i:13"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AlgebraicRiccatiEquation"],

Cell[TextData[{
  "BacklashPotential",
  ", ",
  ButtonBox["Introduction",
    ButtonData:>{"Introduction", "i:1"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["Backlash",
    ButtonData:>{"Backlash", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BacklashPotential"],

Cell[TextData[{
  "Bode",
  ", ",
  ButtonBox["Bode Plot",
    ButtonData:>{"Bode Plot", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Bode"],

Cell[TextData[{
  "ColorNyquist",
  ", ",
  ButtonBox["Nyquist Plot",
    ButtonData:>{"Nyquist Plot", "i:10"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ColorNyquist"],

Cell[TextData[{
  "ControlDistribution",
  ", ",
  ButtonBox["Controllability & Observability",
    ButtonData:>{"Controllability & Observability", "i:16"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ControlDistribution"],

Cell[TextData[{
  "Controllability",
  ", ",
  ButtonBox["Controllability & Observability",
    ButtonData:>{"Controllability & Observability", "i:17"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["Exact Feedback Linearization",
    ButtonData:>{"Exact Feedback Linearization", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Controllability"],

Cell[TextData[{
  "ControllablePair",
  ", ",
  ButtonBox["Controllability, Observability and Pole Placement",
    ButtonData:>{"Controllability, Observability and Pole Placement", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ControllablePair"],

Cell[TextData[{
  "ControllableRealization",
  ", ",
  ButtonBox["State Space to Transfer Function and Back",
    ButtonData:>{"State Space to Transfer Function and Back", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ControllableRealization"],

Cell[TextData[{
  "CreateControllerMEX",
  ", ",
  ButtonBox["Creating SIMULINK S-Functions",
    ButtonData:>{"Creating SIMULINK S-Functions", "i:23"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CreateControllerMEX"],

Cell[TextData[{
  "CreateModel",
  ", ",
  ButtonBox["Building Equations",
    ButtonData:>{"Building Equations", "i:1"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["Suspension System",
    ButtonData:>{"Suspension System", "i:4"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["Flexible Manipulator",
    ButtonData:>{"Flexible Manipulator", "i:5"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["Tractor-Trailer",
    ButtonData:>{"Tractor-Trailer", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CreateModel"],

Cell[TextData[{
  "CreateModelMEX",
  ", ",
  ButtonBox["Creating MEX-Files",
    ButtonData:>{"Creating MEX-Files", "i:3"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["Tractor-Trailer",
    ButtonData:>{"Tractor-Trailer", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CreateModelMEX"],

Cell[TextData[{
  "DecouplingMatrix",
  ", ",
  ButtonBox["Input-Output Linearization, Relative Degree & Decoupling",
    ButtonData:>{"Input-Output Linearization, Relative Degree & Decoupling", 
      "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DecouplingMatrix"],

Cell[TextData[{
  "DifferentialConstraints",
  ", ",
  ButtonBox["The Rolling Disk",
    ButtonData:>{"The Rolling Disk", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DifferentialConstraints"],

Cell[TextData[{
  "DynamicExtension",
  ", ",
  ButtonBox["Dynamic extension",
    ButtonData:>{"Dynamic extension", "i:20"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["Dynamic Inverse",
    ButtonData:>{"Dynamic Inverse", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DynamicExtension"],

Cell[TextData[{
  "EndEffector",
  ", ",
  ButtonBox["Flexible Manipulator",
    ButtonData:>{"Flexible Manipulator", "i:5"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["Closed Chains",
    ButtonData:>{"Closed Chains", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EndEffector"],

Cell[TextData[{
  "EquilibriumSurface",
  ", ",
  ButtonBox["Equilibrium Surface",
    ButtonData:>{"Equilibrium Surface", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EquilibriumSurface"],

Cell[TextData[{
  "ExpMap",
  ", ",
  ButtonBox["Exponential Map",
    ButtonData:>{"Exponential Map", "i:3"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["Composition",
    ButtonData:>{"Composition", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ExpMap"],

Cell[TextData[{
  "ExponentialObserver",
  ", ",
  ButtonBox["Nonlinear Observers",
    ButtonData:>{"Nonlinear Observers", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ExponentialObserver"],

Cell[TextData[{
  "FeedbackLinearizable",
  ", ",
  ButtonBox["Exact Feedback Linearization",
    ButtonData:>{"Exact Feedback Linearization", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FeedbackLinearizable"],

Cell[TextData[{
  "FlowComposition",
  ", ",
  ButtonBox["Composition",
    ButtonData:>{"Composition", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FlowComposition"],

Cell[TextData[{
  "GeneralizedForce",
  ", ",
  ButtonBox["Tractor-Trailer",
    ButtonData:>{"Tractor-Trailer", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GeneralizedForce"],

Cell[TextData[{
  "Grad",
  ", ",
  ButtonBox["Grad",
    ButtonData:>{"Grad", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Grad"],

Cell[TextData[{
  "InverseTransformation",
  ", ",
  ButtonBox["Exact Feedback Linearization",
    ButtonData:>{"Exact Feedback Linearization", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InverseTransformation"],

Cell[TextData[{
  "Involutive",
  ", ",
  ButtonBox["Exact Feedback Linearization",
    ButtonData:>{"Exact Feedback Linearization", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Involutive"],

Cell[TextData[{
  "IOLinearize",
  ", ",
  ButtonBox["The Sliding Surface",
    ButtonData:>{"The Sliding Surface", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IOLinearize"],

Cell[TextData[{
  "IOLinearize",
  ", ",
  ButtonBox["Input-Output Linearization, Relative Degree & Decoupling",
    ButtonData:>{"Input-Output Linearization, Relative Degree & Decoupling", 
      "i:19"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["Dynamic Inverse",
    ButtonData:>{"Dynamic Inverse", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IOLinearize"],

Cell[TextData[{
  "IrreducibleRealization",
  ", ",
  ButtonBox["Kalman Canonical Form",
    ButtonData:>{"Kalman Canonical Form", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IrreducibleRealization"],

Cell[TextData[{
  "Jacob",
  ", ",
  ButtonBox["Jacob",
    ButtonData:>{"Jacob", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Jacob"],

Cell[TextData[{
  "JointFrictionPotential",
  ", ",
  ButtonBox["Introduction",
    ButtonData:>{"Introduction", "i:1"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["Friction",
    ButtonData:>{"Friction", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"JointFrictionPotential"],

Cell[TextData[{
  "Joints",
  ", ",
  ButtonBox["Suspension System",
    ButtonData:>{"Suspension System", "i:4"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["Tractor-Trailer",
    ButtonData:>{"Tractor-Trailer", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Joints"],

Cell[TextData[{
  "KalmanDecomposition",
  ", ",
  ButtonBox["Kalman Canonical Form",
    ButtonData:>{"Kalman Canonical Form", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"KalmanDecomposition"],

Cell[TextData[{
  "KinematicReplacements",
  ", ",
  ButtonBox["Tractor-Trailer",
    ButtonData:>{"Tractor-Trailer", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"KinematicReplacements"],

Cell[TextData[{
  "LargestInvariantDistribution",
  ", ",
  ButtonBox["Invariant Distributions",
    ButtonData:>{"Invariant Distributions", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LargestInvariantDistribution"],

Cell[TextData[{
  "LeafPotential",
  ", ",
  ButtonBox["Suspension System",
    ButtonData:>{"Suspension System", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LeafPotential"],

Cell[TextData[{
  "LieBracket",
  ", ",
  ButtonBox["LieBracket & Ad",
    ButtonData:>{"LieBracket & Ad", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LieBracket"],

Cell[TextData[{
  "LieDerivative",
  ", ",
  ButtonBox["LieDerivative",
    ButtonData:>{"LieDerivative", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LieDerivative"],

Cell[TextData[{
  "LocalDecomposition",
  ", ",
  ButtonBox["Controllability & Observability",
    ButtonData:>{"Controllability & Observability", "i:17"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LocalDecomposition"],

Cell[TextData[{
  "LocalZeroDynamics",
  ", ",
  ButtonBox["Input-Output Linearization, Relative Degree & Decoupling",
    ButtonData:>{"Input-Output Linearization, Relative Degree & Decoupling", 
      "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LocalZeroDynamics"],

Cell[TextData[{
  "LQE",
  ", ",
  ButtonBox["Optimal Stochastic State Estimator",
    ButtonData:>{"Optimal Stochastic State Estimator", "i:15"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LQE"],

Cell[TextData[{
  "LQR",
  ", ",
  ButtonBox["Optimal State Feedback",
    ButtonData:>{"Optimal State Feedback", "i:14"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LQR"],

Cell[TextData[{
  "LyapunovEquation",
  ", ",
  ButtonBox["The Lyapunov Equation",
    ButtonData:>{"The Lyapunov Equation", "i:24"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LyapunovEquation"],

Cell[TextData[{
  "MakeODEs",
  ", ",
  ButtonBox["Simulation: Numerical Solution",
    ButtonData:>{"Simulation: Numerical Solution", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MakeODEs"],

Cell[TextData[{
  "MinimalRealization",
  ", ",
  ButtonBox["Minimal Realization",
    ButtonData:>{"Minimal Realization", "i:4"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["Kalman Canonical Form",
    ButtonData:>{"Kalman Canonical Form", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MinimalRealization"],

Cell[TextData[{
  "ModeratingFunctions",
  ", ",
  ButtonBox["Moderating",
    ButtonData:>{"Moderating", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ModeratingFunctions"],

Cell[TextData[{
  "NodeVelocity",
  ", ",
  ButtonBox["The Rolling Disk",
    ButtonData:>{"The Rolling Disk", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NodeVelocity"],

Cell[TextData[{
  "NormalCoordinates",
  ", ",
  ButtonBox["Input-Output Linearization, Relative Degree & Decoupling",
    ButtonData:>{"Input-Output Linearization, Relative Degree & Decoupling", 
      "i:19"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["The Sliding Surface",
    ButtonData:>{"The Sliding Surface", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NormalCoordinates"],

Cell[TextData[{
  "Nyquist",
  ", ",
  ButtonBox["Nyquist Plot",
    ButtonData:>{"Nyquist Plot", "i:10"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Nyquist"],

Cell[TextData[{
  "Observability",
  ", ",
  ButtonBox["Controllability & Observability",
    ButtonData:>{"Controllability & Observability", "i:17"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Observability"],

Cell[TextData[{
  "ObservabilityCodistribution",
  ", ",
  ButtonBox["Controllability & Observability",
    ButtonData:>{"Controllability & Observability", "i:17"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ObservabilityCodistribution"],

Cell[TextData[{
  "ObservablePair",
  ", ",
  ButtonBox["State Space to Transfer Function and Back",
    ButtonData:>{"State Space to Transfer Function and Back", "i:3"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["Controllability, Observability and Pole Placement",
    ButtonData:>{"Controllability, Observability and Pole Placement", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ObservablePair"],

Cell[TextData[{
  "ParametricManifold",
  ", ",
  ButtonBox["Implicit & Parametric Descriptions",
    ButtonData:>{"Implicit & Parametric Descriptions", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ParametricManifold"],

Cell[TextData[{
  "PolePlace",
  ", ",
  ButtonBox["Controllability, Observability and Pole Placement",
    ButtonData:>{"Controllability, Observability and Pole Placement", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PolePlace"],

Cell[TextData[{
  "Poles",
  ", ",
  ButtonBox["Poles and Zeros",
    ButtonData:>{"Poles and Zeros", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Poles"],

Cell[TextData[{
  "PoleZeroPlot",
  ", ",
  ButtonBox["Pole-Zero Plot",
    ButtonData:>{"Pole-Zero Plot", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PoleZeroPlot"],

Cell[TextData[{
  "PSFFCond",
  ", ",
  ButtonBox["Adaptive Control",
    ButtonData:>{"Adaptive Control", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PSFFCond"],

Cell[TextData[{
  "PSFFSolve",
  ", ",
  ButtonBox["Adaptive Control",
    ButtonData:>{"Adaptive Control", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PSFFSolve"],

Cell[TextData[{
  "Rank",
  ", ",
  ButtonBox["Rank",
    ButtonData:>{"Rank", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Rank"],

Cell[TextData[{
  "RelativeOrder",
  ", ",
  ButtonBox["Input-Output Linearization, Relative Degree & Decoupling",
    ButtonData:>{"Input-Output Linearization, Relative Degree & Decoupling", 
      "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RelativeOrder"],

Cell[TextData[{
  "RightInverse",
  ", ",
  ButtonBox["Dynamic Inverse",
    ButtonData:>{"Dynamic Inverse", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RightInverse"],

Cell[TextData[{
  "RootLocus",
  ", ",
  ButtonBox["Root Locus",
    ButtonData:>{"Root Locus", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RootLocus"],

Cell[TextData[{
  "SIExactFBL",
  ", ",
  ButtonBox["Exact Feedback Linearization",
    ButtonData:>{"Exact Feedback Linearization", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SIExactFBL"],

Cell[TextData[{
  "SimplifyArray",
  ", ",
  ButtonBox["Complex Arrays",
    ButtonData:>{"Complex Arrays", "i:10"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SimplifyArray"],

Cell[TextData[{
  "SISONormalFormTrans",
  ", ",
  ButtonBox["Input-Output Linearization, Relative Degree & Decoupling",
    ButtonData:>{"Input-Output Linearization, Relative Degree & Decoupling", 
      "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SISONormalFormTrans"],

Cell[TextData[{
  "SlidingSurface",
  ", ",
  ButtonBox["The Sliding Surface",
    ButtonData:>{"The Sliding Surface", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SlidingSurface"],

Cell[TextData[{
  "SmallestInvariantDistribution",
  ", ",
  ButtonBox["Invariant Distributions",
    ButtonData:>{"Invariant Distributions", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SmallestInvariantDistribution"],

Cell[TextData[{
  "SmoothingFunctions",
  ", ",
  ButtonBox["Smoothing",
    ButtonData:>{"Smoothing", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SmoothingFunctions"],

Cell[TextData[{
  "Span",
  ", ",
  ButtonBox["Span",
    ButtonData:>{"Span", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Span"],

Cell[TextData[{
  "SpecialInverse",
  ", ",
  ButtonBox["Complex Arrays",
    ButtonData:>{"Complex Arrays", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SpecialInverse"],

Cell[TextData[{
  "SpecialNullSpace",
  ", ",
  ButtonBox["SpecialNullSpace",
    ButtonData:>{"SpecialNullSpace", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SpecialNullSpace"],

Cell[TextData[{
  "SpecialNulSpace",
  ", ",
  ButtonBox["Composition",
    ButtonData:>{"Composition", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SpecialNulSpace"],

Cell[TextData[{
  "SpringPotential",
  ", ",
  ButtonBox["Suspension System",
    ButtonData:>{"Suspension System", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SpringPotential"],

Cell[TextData[{
  "StateSpaceToTransferFunction",
  ", ",
  ButtonBox["State Space to Transfer Function and Back",
    ButtonData:>{"State Space to Transfer Function and Back", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"StateSpaceToTransferFunction"],

Cell[TextData[{
  "StructureAlgorithm",
  ", ",
  ButtonBox["Dynamic Inverse",
    ButtonData:>{"Dynamic Inverse", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"StructureAlgorithm"],

Cell[TextData[{
  "SwitchingControl",
  ", ",
  ButtonBox["The Sliding Surface",
    ButtonData:>{"The Sliding Surface", "i:1"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["Reaching",
    ButtonData:>{"Reaching", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SwitchingControl"],

Cell[TextData[{
  "TaylorLinearize",
  ", ",
  ButtonBox["Linearization",
    ButtonData:>{"Linearization", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TaylorLinearize"],

Cell[TextData[{
  "TransformSystem",
  ", ",
  ButtonBox["Exact Feedback Linearization",
    ButtonData:>{"Exact Feedback Linearization", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TransformSystem"],

Cell[TextData[{
  "TriangularDecomposition",
  ", ",
  ButtonBox["Triangular Decomposition",
    ButtonData:>{"Triangular Decomposition", "i:13"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TriangularDecomposition"],

Cell[TextData[{
  "VectorRelativeOrder",
  ", ",
  ButtonBox["Input-Output Linearization, Relative Degree & Decoupling",
    ButtonData:>{"Input-Output Linearization, Relative Degree & Decoupling", 
      "i:19"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["Adaptive Control",
    ButtonData:>{"Adaptive Control", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"VectorRelativeOrder"],

Cell[TextData[{
  "WriteArray",
  ", ",
  ButtonBox["Complex Arrays",
    ButtonData:>{"Complex Arrays", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"WriteArray"],

Cell[TextData[{
  "Zeros",
  ", ",
  ButtonBox["Poles and Zeros",
    ButtonData:>{"Poles and Zeros", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Zeros"]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "MasterIndexHeading"->{
    Cell[1717, 49, 68, 1, 70, "IndexSection",
      CellTags->"MasterIndexHeading"]},
  "Ad"->{
    Cell[1788, 52, 168, 7, 70, "Index",
      CellTags->"Ad"]},
  "AdaptiveBackstepRegulator"->{
    Cell[1959, 61, 217, 7, 70, "Index",
      CellTags->"AdaptiveBackstepRegulator"]},
  "AdaptiveRegulator"->{
    Cell[2179, 70, 201, 7, 70, "Index",
      CellTags->"AdaptiveRegulator"]},
  "AdaptiveTracking"->{
    Cell[2383, 79, 199, 7, 70, "Index",
      CellTags->"AdaptiveTracking"]},
  "AlgebraicConstraints"->{
    Cell[2585, 88, 200, 7, 70, "Index",
      CellTags->"AlgebraicConstraints"]},
  "AlgebraicRiccatiEquation"->{
    Cell[2788, 97, 243, 7, 70, "Index",
      CellTags->"AlgebraicRiccatiEquation"]},
  "BacklashPotential"->{
    Cell[3034, 106, 293, 11, 70, "Index",
      CellTags->"BacklashPotential"]},
  "Bode"->{
    Cell[3330, 119, 160, 7, 70, "Index",
      CellTags->"Bode"]},
  "ColorNyquist"->{
    Cell[3493, 128, 183, 7, 70, "Index",
      CellTags->"ColorNyquist"]},
  "ControlDistribution"->{
    Cell[3679, 137, 235, 7, 70, "Index",
      CellTags->"ControlDistribution"]},
  "Controllability"->{
    Cell[3917, 146, 369, 11, 70, "Index",
      CellTags->"Controllability"]},
  "ControllablePair"->{
    Cell[4289, 159, 264, 7, 70, "Index",
      CellTags->"ControllablePair"]},
  "ControllableRealization"->{
    Cell[4556, 168, 262, 7, 70, "Index",
      CellTags->"ControllableRealization"]},
  "CreateControllerMEX"->{
    Cell[4821, 177, 231, 7, 70, "Index",
      CellTags->"CreateControllerMEX"]},
  "CreateModel"->{
    Cell[5055, 186, 551, 19, 70, "Index",
      CellTags->"CreateModel"]},
  "CreateModelMEX"->{
    Cell[5609, 207, 313, 11, 70, "Index",
      CellTags->"CreateModelMEX"]},
  "DecouplingMatrix"->{
    Cell[5925, 220, 286, 8, 70, "Index",
      CellTags->"DecouplingMatrix"]},
  "DifferentialConstraints"->{
    Cell[6214, 230, 212, 7, 70, "Index",
      CellTags->"DifferentialConstraints"]},
  "DynamicExtension"->{
    Cell[6429, 239, 317, 11, 70, "Index",
      CellTags->"DynamicExtension"]},
  "EndEffector"->{
    Cell[6749, 252, 307, 11, 70, "Index",
      CellTags->"EndEffector"]},
  "EquilibriumSurface"->{
    Cell[7059, 265, 208, 7, 70, "Index",
      CellTags->"EquilibriumSurface"]},
  "ExpMap"->{
    Cell[7270, 274, 283, 11, 70, "Index",
      CellTags->"ExpMap"]},
  "ExponentialObserver"->{
    Cell[7556, 287, 210, 7, 70, "Index",
      CellTags->"ExponentialObserver"]},
  "FeedbackLinearizable"->{
    Cell[7769, 296, 231, 7, 70, "Index",
      CellTags->"FeedbackLinearizable"]},
  "FlowComposition"->{
    Cell[8003, 305, 186, 7, 70, "Index",
      CellTags->"FlowComposition"]},
  "GeneralizedForce"->{
    Cell[8192, 314, 196, 7, 70, "Index",
      CellTags->"GeneralizedForce"]},
  "Grad"->{
    Cell[8391, 323, 150, 7, 70, "Index",
      CellTags->"Grad"]},
  "InverseTransformation"->{
    Cell[8544, 332, 233, 7, 70, "Index",
      CellTags->"InverseTransformation"]},
  "Involutive"->{
    Cell[8780, 341, 211, 7, 70, "Index",
      CellTags->"Involutive"]},
  "IOLinearize"->{
    Cell[8994, 350, 194, 7, 70, "Index",
      CellTags->"IOLinearize"],
    Cell[9191, 359, 392, 12, 70, "Index",
      CellTags->"IOLinearize"]},
  "IrreducibleRealization"->{
    Cell[9586, 373, 220, 7, 70, "Index",
      CellTags->"IrreducibleRealization"]},
  "Jacob"->{
    Cell[9809, 382, 154, 7, 70, "Index",
      CellTags->"Jacob"]},
  "JointFrictionPotential"->{
    Cell[9966, 391, 303, 11, 70, "Index",
      CellTags->"JointFrictionPotential"]},
  "Joints"->{
    Cell[10272, 404, 295, 11, 70, "Index",
      CellTags->"Joints"]},
  "KalmanDecomposition"->{
    Cell[10570, 417, 214, 7, 70, "Index",
      CellTags->"KalmanDecomposition"]},
  "KinematicReplacements"->{
    Cell[10787, 426, 206, 7, 70, "Index",
      CellTags->"KinematicReplacements"]},
  "LargestInvariantDistribution"->{
    Cell[10996, 435, 236, 7, 70, "Index",
      CellTags->"LargestInvariantDistribution"]},
  "LeafPotential"->{
    Cell[11235, 444, 194, 7, 70, "Index",
      CellTags->"LeafPotential"]},
  "LieBracket"->{
    Cell[11432, 453, 184, 7, 70, "Index",
      CellTags->"LieBracket"]},
  "LieDerivative"->{
    Cell[11619, 462, 186, 7, 70, "Index",
      CellTags->"LieDerivative"]},
  "LocalDecomposition"->{
    Cell[11808, 471, 233, 7, 70, "Index",
      CellTags->"LocalDecomposition"]},
  "LocalZeroDynamics"->{
    Cell[12044, 480, 288, 8, 70, "Index",
      CellTags->"LocalZeroDynamics"]},
  "LQE"->{
    Cell[12335, 490, 209, 7, 70, "Index",
      CellTags->"LQE"]},
  "LQR"->{
    Cell[12547, 499, 185, 7, 70, "Index",
      CellTags->"LQR"]},
  "LyapunovEquation"->{
    Cell[12735, 508, 209, 7, 70, "Index",
      CellTags->"LyapunovEquation"]},
  "MakeODEs"->{
    Cell[12947, 517, 210, 7, 70, "Index",
      CellTags->"MakeODEs"]},
  "MinimalRealization"->{
    Cell[13160, 526, 335, 11, 70, "Index",
      CellTags->"MinimalRealization"]},
  "ModeratingFunctions"->{
    Cell[13498, 539, 192, 7, 70, "Index",
      CellTags->"ModeratingFunctions"]},
  "NodeVelocity"->{
    Cell[13693, 548, 190, 7, 70, "Index",
      CellTags->"NodeVelocity"]},
  "NormalCoordinates"->{
    Cell[13886, 557, 411, 12, 70, "Index",
      CellTags->"NormalCoordinates"]},
  "Nyquist"->{
    Cell[14300, 571, 173, 7, 70, "Index",
      CellTags->"Nyquist"]},
  "Observability"->{
    Cell[14476, 580, 223, 7, 70, "Index",
      CellTags->"Observability"]},
  "ObservabilityCodistribution"->{
    Cell[14702, 589, 251, 7, 70, "Index",
      CellTags->"ObservabilityCodistribution"]},
  "ObservablePair"->{
    Cell[14956, 598, 427, 11, 70, "Index",
      CellTags->"ObservablePair"]},
  "ParametricManifold"->{
    Cell[15386, 611, 238, 7, 70, "Index",
      CellTags->"ParametricManifold"]},
  "PolePlace"->{
    Cell[15627, 620, 250, 7, 70, "Index",
      CellTags->"PolePlace"]},
  "Poles"->{
    Cell[15880, 629, 174, 7, 70, "Index",
      CellTags->"Poles"]},
  "PoleZeroPlot"->{
    Cell[16057, 638, 187, 7, 70, "Index",
      CellTags->"PoleZeroPlot"]},
  "PSFFCond"->{
    Cell[16247, 647, 183, 7, 70, "Index",
      CellTags->"PSFFCond"]},
  "PSFFSolve"->{
    Cell[16433, 656, 185, 7, 70, "Index",
      CellTags->"PSFFSolve"]},
  "Rank"->{
    Cell[16621, 665, 150, 7, 70, "Index",
      CellTags->"Rank"]},
  "RelativeOrder"->{
    Cell[16774, 674, 280, 8, 70, "Index",
      CellTags->"RelativeOrder"]},
  "RightInverse"->{
    Cell[17057, 684, 189, 7, 70, "Index",
      CellTags->"RightInverse"]},
  "RootLocus"->{
    Cell[17249, 693, 173, 7, 70, "Index",
      CellTags->"RootLocus"]},
  "SIExactFBL"->{
    Cell[17425, 702, 211, 7, 70, "Index",
      CellTags->"SIExactFBL"]},
  "SimplifyArray"->{
    Cell[17639, 711, 189, 7, 70, "Index",
      CellTags->"SimplifyArray"]},
  "SISONormalFormTrans"->{
    Cell[17831, 720, 292, 8, 70, "Index",
      CellTags->"SISONormalFormTrans"]},
  "SlidingSurface"->{
    Cell[18126, 730, 200, 7, 70, "Index",
      CellTags->"SlidingSurface"]},
  "SmallestInvariantDistribution"->{
    Cell[18329, 739, 238, 7, 70, "Index",
      CellTags->"SmallestInvariantDistribution"]},
  "SmoothingFunctions"->{
    Cell[18570, 748, 188, 7, 70, "Index",
      CellTags->"SmoothingFunctions"]},
  "Span"->{
    Cell[18761, 757, 150, 7, 70, "Index",
      CellTags->"Span"]},
  "SpecialInverse"->{
    Cell[18914, 766, 190, 7, 70, "Index",
      CellTags->"SpecialInverse"]},
  "SpecialNullSpace"->{
    Cell[19107, 775, 199, 7, 70, "Index",
      CellTags->"SpecialNullSpace"]},
  "SpecialNulSpace"->{
    Cell[19309, 784, 186, 7, 70, "Index",
      CellTags->"SpecialNulSpace"]},
  "SpringPotential"->{
    Cell[19498, 793, 198, 7, 70, "Index",
      CellTags->"SpringPotential"]},
  "StateSpaceToTransferFunction"->{
    Cell[19699, 802, 272, 7, 70, "Index",
      CellTags->"StateSpaceToTransferFunction"]},
  "StructureAlgorithm"->{
    Cell[19974, 811, 201, 7, 70, "Index",
      CellTags->"StructureAlgorithm"]},
  "SwitchingControl"->{
    Cell[20178, 820, 305, 11, 70, "Index",
      CellTags->"SwitchingControl"]},
  "TaylorLinearize"->{
    Cell[20486, 833, 190, 7, 70, "Index",
      CellTags->"TaylorLinearize"]},
  "TransformSystem"->{
    Cell[20679, 842, 221, 7, 70, "Index",
      CellTags->"TransformSystem"]},
  "TriangularDecomposition"->{
    Cell[20903, 851, 229, 7, 70, "Index",
      CellTags->"TriangularDecomposition"]},
  "VectorRelativeOrder"->{
    Cell[21135, 860, 410, 12, 70, "Index",
      CellTags->"VectorRelativeOrder"]},
  "WriteArray"->{
    Cell[21548, 874, 183, 7, 70, "Index",
      CellTags->"WriteArray"]},
  "Zeros"->{
    Cell[21734, 883, 174, 7, 70, "Index",
      CellTags->"Zeros"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"MasterIndexHeading", 22488, 907},
  {"Ad", 22584, 910},
  {"AdaptiveBackstepRegulator", 22681, 913},
  {"AdaptiveRegulator", 22793, 916},
  {"AdaptiveTracking", 22896, 919},
  {"AlgebraicConstraints", 23002, 922},
  {"AlgebraicRiccatiEquation", 23116, 925},
  {"BacklashPotential", 23227, 928},
  {"Bode", 23320, 931},
  {"ColorNyquist", 23407, 934},
  {"ControlDistribution", 23509, 937},
  {"Controllability", 23614, 940},
  {"ControllablePair", 23717, 943},
  {"ControllableRealization", 23827, 946},
  {"CreateControllerMEX", 23940, 949},
  {"CreateModel", 24041, 952},
  {"CreateModelMEX", 24138, 955},
  {"DecouplingMatrix", 24240, 958},
  {"DifferentialConstraints", 24350, 961},
  {"DynamicExtension", 24460, 964},
  {"EndEffector", 24559, 967},
  {"EquilibriumSurface", 24660, 970},
  {"ExpMap", 24755, 973},
  {"ExponentialObserver", 24852, 976},
  {"FeedbackLinearizable", 24962, 979},
  {"FlowComposition", 25068, 982},
  {"GeneralizedForce", 25170, 985},
  {"Grad", 25261, 988},
  {"InverseTransformation", 25357, 991},
  {"Involutive", 25459, 994},
  {"IOLinearize", 25551, 997},
  {"IrreducibleRealization", 25729, 1002},
  {"Jacob", 25827, 1005},
  {"JointFrictionPotential", 25925, 1008},
  {"Joints", 26025, 1011},
  {"KalmanDecomposition", 26123, 1014},
  {"KinematicReplacements", 26235, 1017},
  {"LargestInvariantDistribution", 26356, 1020},
  {"LeafPotential", 26469, 1023},
  {"LieBracket", 26564, 1026},
  {"LieDerivative", 26659, 1029},
  {"LocalDecomposition", 26762, 1032},
  {"LocalZeroDynamics", 26869, 1035},
  {"LQE", 26961, 1038},
  {"LQR", 27039, 1041},
  {"LyapunovEquation", 27130, 1044},
  {"MakeODEs", 27226, 1047},
  {"MinimalRealization", 27324, 1050},
  {"ModeratingFunctions", 27434, 1053},
  {"NodeVelocity", 27537, 1056},
  {"NormalCoordinates", 27638, 1059},
  {"Nyquist", 27735, 1062},
  {"Observability", 27827, 1065},
  {"ObservabilityCodistribution", 27939, 1068},
  {"ObservablePair", 28052, 1071},
  {"ParametricManifold", 28157, 1074},
  {"PolePlace", 28256, 1077},
  {"Poles", 28342, 1080},
  {"PoleZeroPlot", 28431, 1083},
  {"PSFFCond", 28523, 1086},
  {"PSFFSolve", 28612, 1089},
  {"Rank", 28697, 1092},
  {"RelativeOrder", 28786, 1095},
  {"RightInverse", 28883, 1098},
  {"RootLocus", 28976, 1101},
  {"SIExactFBL", 29067, 1104},
  {"SimplifyArray", 29162, 1107},
  {"SISONormalFormTrans", 29266, 1110},
  {"SlidingSurface", 29371, 1113},
  {"SmallestInvariantDistribution", 29486, 1116},
  {"SmoothingFunctions", 29605, 1119},
  {"Span", 29699, 1122},
  {"SpecialInverse", 29789, 1125},
  {"SpecialNullSpace", 29891, 1128},
  {"SpecialNulSpace", 29994, 1131},
  {"SpringPotential", 30096, 1134},
  {"StateSpaceToTransferFunction", 30211, 1137},
  {"StructureAlgorithm", 30329, 1140},
  {"SwitchingControl", 30435, 1143},
  {"TaylorLinearize", 30539, 1146},
  {"TransformSystem", 30641, 1149},
  {"TriangularDecomposition", 30751, 1152},
  {"VectorRelativeOrder", 30865, 1155},
  {"WriteArray", 30967, 1158},
  {"Zeros", 31054, 1161}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 68, 1, 70, "IndexSection",
  CellTags->"MasterIndexHeading"],
Cell[1788, 52, 168, 7, 70, "Index",
  CellTags->"Ad"],
Cell[1959, 61, 217, 7, 70, "Index",
  CellTags->"AdaptiveBackstepRegulator"],
Cell[2179, 70, 201, 7, 70, "Index",
  CellTags->"AdaptiveRegulator"],
Cell[2383, 79, 199, 7, 70, "Index",
  CellTags->"AdaptiveTracking"],
Cell[2585, 88, 200, 7, 70, "Index",
  CellTags->"AlgebraicConstraints"],
Cell[2788, 97, 243, 7, 70, "Index",
  CellTags->"AlgebraicRiccatiEquation"],
Cell[3034, 106, 293, 11, 70, "Index",
  CellTags->"BacklashPotential"],
Cell[3330, 119, 160, 7, 70, "Index",
  CellTags->"Bode"],
Cell[3493, 128, 183, 7, 70, "Index",
  CellTags->"ColorNyquist"],
Cell[3679, 137, 235, 7, 70, "Index",
  CellTags->"ControlDistribution"],
Cell[3917, 146, 369, 11, 70, "Index",
  CellTags->"Controllability"],
Cell[4289, 159, 264, 7, 70, "Index",
  CellTags->"ControllablePair"],
Cell[4556, 168, 262, 7, 70, "Index",
  CellTags->"ControllableRealization"],
Cell[4821, 177, 231, 7, 70, "Index",
  CellTags->"CreateControllerMEX"],
Cell[5055, 186, 551, 19, 70, "Index",
  CellTags->"CreateModel"],
Cell[5609, 207, 313, 11, 70, "Index",
  CellTags->"CreateModelMEX"],
Cell[5925, 220, 286, 8, 70, "Index",
  CellTags->"DecouplingMatrix"],
Cell[6214, 230, 212, 7, 70, "Index",
  CellTags->"DifferentialConstraints"],
Cell[6429, 239, 317, 11, 70, "Index",
  CellTags->"DynamicExtension"],
Cell[6749, 252, 307, 11, 70, "Index",
  CellTags->"EndEffector"],
Cell[7059, 265, 208, 7, 70, "Index",
  CellTags->"EquilibriumSurface"],
Cell[7270, 274, 283, 11, 70, "Index",
  CellTags->"ExpMap"],
Cell[7556, 287, 210, 7, 70, "Index",
  CellTags->"ExponentialObserver"],
Cell[7769, 296, 231, 7, 70, "Index",
  CellTags->"FeedbackLinearizable"],
Cell[8003, 305, 186, 7, 70, "Index",
  CellTags->"FlowComposition"],
Cell[8192, 314, 196, 7, 70, "Index",
  CellTags->"GeneralizedForce"],
Cell[8391, 323, 150, 7, 70, "Index",
  CellTags->"Grad"],
Cell[8544, 332, 233, 7, 70, "Index",
  CellTags->"InverseTransformation"],
Cell[8780, 341, 211, 7, 70, "Index",
  CellTags->"Involutive"],
Cell[8994, 350, 194, 7, 70, "Index",
  CellTags->"IOLinearize"],
Cell[9191, 359, 392, 12, 70, "Index",
  CellTags->"IOLinearize"],
Cell[9586, 373, 220, 7, 70, "Index",
  CellTags->"IrreducibleRealization"],
Cell[9809, 382, 154, 7, 70, "Index",
  CellTags->"Jacob"],
Cell[9966, 391, 303, 11, 70, "Index",
  CellTags->"JointFrictionPotential"],
Cell[10272, 404, 295, 11, 70, "Index",
  CellTags->"Joints"],
Cell[10570, 417, 214, 7, 70, "Index",
  CellTags->"KalmanDecomposition"],
Cell[10787, 426, 206, 7, 70, "Index",
  CellTags->"KinematicReplacements"],
Cell[10996, 435, 236, 7, 70, "Index",
  CellTags->"LargestInvariantDistribution"],
Cell[11235, 444, 194, 7, 70, "Index",
  CellTags->"LeafPotential"],
Cell[11432, 453, 184, 7, 70, "Index",
  CellTags->"LieBracket"],
Cell[11619, 462, 186, 7, 70, "Index",
  CellTags->"LieDerivative"],
Cell[11808, 471, 233, 7, 70, "Index",
  CellTags->"LocalDecomposition"],
Cell[12044, 480, 288, 8, 70, "Index",
  CellTags->"LocalZeroDynamics"],
Cell[12335, 490, 209, 7, 70, "Index",
  CellTags->"LQE"],
Cell[12547, 499, 185, 7, 70, "Index",
  CellTags->"LQR"],
Cell[12735, 508, 209, 7, 70, "Index",
  CellTags->"LyapunovEquation"],
Cell[12947, 517, 210, 7, 70, "Index",
  CellTags->"MakeODEs"],
Cell[13160, 526, 335, 11, 70, "Index",
  CellTags->"MinimalRealization"],
Cell[13498, 539, 192, 7, 70, "Index",
  CellTags->"ModeratingFunctions"],
Cell[13693, 548, 190, 7, 70, "Index",
  CellTags->"NodeVelocity"],
Cell[13886, 557, 411, 12, 70, "Index",
  CellTags->"NormalCoordinates"],
Cell[14300, 571, 173, 7, 70, "Index",
  CellTags->"Nyquist"],
Cell[14476, 580, 223, 7, 70, "Index",
  CellTags->"Observability"],
Cell[14702, 589, 251, 7, 70, "Index",
  CellTags->"ObservabilityCodistribution"],
Cell[14956, 598, 427, 11, 70, "Index",
  CellTags->"ObservablePair"],
Cell[15386, 611, 238, 7, 70, "Index",
  CellTags->"ParametricManifold"],
Cell[15627, 620, 250, 7, 70, "Index",
  CellTags->"PolePlace"],
Cell[15880, 629, 174, 7, 70, "Index",
  CellTags->"Poles"],
Cell[16057, 638, 187, 7, 70, "Index",
  CellTags->"PoleZeroPlot"],
Cell[16247, 647, 183, 7, 70, "Index",
  CellTags->"PSFFCond"],
Cell[16433, 656, 185, 7, 70, "Index",
  CellTags->"PSFFSolve"],
Cell[16621, 665, 150, 7, 70, "Index",
  CellTags->"Rank"],
Cell[16774, 674, 280, 8, 70, "Index",
  CellTags->"RelativeOrder"],
Cell[17057, 684, 189, 7, 70, "Index",
  CellTags->"RightInverse"],
Cell[17249, 693, 173, 7, 70, "Index",
  CellTags->"RootLocus"],
Cell[17425, 702, 211, 7, 70, "Index",
  CellTags->"SIExactFBL"],
Cell[17639, 711, 189, 7, 70, "Index",
  CellTags->"SimplifyArray"],
Cell[17831, 720, 292, 8, 70, "Index",
  CellTags->"SISONormalFormTrans"],
Cell[18126, 730, 200, 7, 70, "Index",
  CellTags->"SlidingSurface"],
Cell[18329, 739, 238, 7, 70, "Index",
  CellTags->"SmallestInvariantDistribution"],
Cell[18570, 748, 188, 7, 70, "Index",
  CellTags->"SmoothingFunctions"],
Cell[18761, 757, 150, 7, 70, "Index",
  CellTags->"Span"],
Cell[18914, 766, 190, 7, 70, "Index",
  CellTags->"SpecialInverse"],
Cell[19107, 775, 199, 7, 70, "Index",
  CellTags->"SpecialNullSpace"],
Cell[19309, 784, 186, 7, 70, "Index",
  CellTags->"SpecialNulSpace"],
Cell[19498, 793, 198, 7, 70, "Index",
  CellTags->"SpringPotential"],
Cell[19699, 802, 272, 7, 70, "Index",
  CellTags->"StateSpaceToTransferFunction"],
Cell[19974, 811, 201, 7, 70, "Index",
  CellTags->"StructureAlgorithm"],
Cell[20178, 820, 305, 11, 70, "Index",
  CellTags->"SwitchingControl"],
Cell[20486, 833, 190, 7, 70, "Index",
  CellTags->"TaylorLinearize"],
Cell[20679, 842, 221, 7, 70, "Index",
  CellTags->"TransformSystem"],
Cell[20903, 851, 229, 7, 70, "Index",
  CellTags->"TriangularDecomposition"],
Cell[21135, 860, 410, 12, 70, "Index",
  CellTags->"VectorRelativeOrder"],
Cell[21548, 874, 183, 7, 70, "Index",
  CellTags->"WriteArray"],
Cell[21734, 883, 174, 7, 70, "Index",
  CellTags->"Zeros"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

