(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7597,        228]*)
(*NotebookOutlinePosition[     12504,        348]*)
(*  CellTagsIndexPosition[     12396,        341]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Nonlinear Observers", "Title"],

Cell[CellGroupData[{

Cell["Introduction", "Section"],

Cell[BoxData[
    \(Off[General::spell]; \nOff[General::spell1]; \)], "Input",
  CellLabel->"In[1]:="]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exponential Observer", "Section",
  CellTags->{"Exponential Observer", "i:1"}],

Cell["\<\
If a nonlinear system has a detectable Taylor linearization at an equibrium \
point of interest, then an observer with exponential ly stable error dynamics \
can be designed. Of course, the observer is only local.
Load the package:\
\>", "Text",
  CellTags->{"Exponential Observer", "i:1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< ProPac`\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Exponential Observer", "i:1"}],

Cell[BoxData[
    \("\n ProPac has been successfully loaded. It contains packages\n for \
multibody dynamics, linear control and nonlinear control.\n Appropriate \
packages will be loaded automatically as required.\n Packages can be manually \
loaded by simply entering Dynamics,\n LinearControl or NonlinearControl as \
desired. Once a package is\n loaded, enter ?Dynamics, ?LinearControl or \
?NonlinearControl,\n respectively, to obtain a list of available \
functions."\)], "Print",
  CellTags->{"Exponential Observer", "i:1"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NonlinearControl\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Exponential Observer", "i:1"}],

Cell[BoxData[
    \("  *** LinearControl successfully loaded ***"\)], "Print",
  CellTags->{"Exponential Observer", "i:1"}],

Cell[BoxData[
    \("  *** NonlinearControl successfully loaded ***"\)], "Print",
  CellTags->{"Exponential Observer", "i:1"}],

Cell[BoxData[
    \(NonlinearControl\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Exponential Observer", "i:1"}]
}, Open  ]],

Cell["Here is the definition of the function ExponentialObserver", "Text",
  CellTags->{"Exponential Observer", "i:1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?ExponentialObserver\)\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"Exponential Observer", "i:1"}],

Cell[BoxData[
    \("ExponentialObserver[f,h,x,u,y,x0,u0,decay] returns\n {rhs,xhat,eigs} \
that defines an exponential observer\n of the form:\n \n    \
xhat_dot=rhs(xhat,u,y)\n \n for a system defined by\n \n     x_dot=f(x,u), \
y=h(x)\n \n x0,u0 is an equilibrium point, f(x0,u0)=0, and decay is\n a \
specified exponential decay rate. The observer has an equilibrium\n point at \
xhat=x0, i.e., rhs(x0,u0,h(x0))=0, and its linearization at\n this point has \
eigenvalues eigs. Furthermore, Re(eigs)<decay.\n \n By default the state \
estimates assume the names of the states with 'hat'\n adjoined. The calling \
syntax:\n \n    {rhs,xhat,eigs}=ExponentialObserver[f,h,x,u,y,x0,u0,decay,z]\n\
 \n returns state estimates with names z1,z2,...,zn\n "\)], "Print",
  CellTags->{"Exponential Observer", "i:1"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Subsection",
  CellTags->{"Exponential Observer", "i:1"}],

Cell[BoxData[{
    \(\(f = {x1^2\  + Cos[x2]*x3 - x2, x2*Cos[x1], 
          Sin[x3] + Cos[x1] + u1};\)\), "\n", 
    \(\(h = {x1 + x1*x2 + x3, x2 + x3^3};\)\)}], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"Exponential Observer", "i:1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExponentialObserver[f, h, {x1, x2, x3}, {u1}, {y1, y2}, {0, 0, 0}, {0}, 
      4]\)], "Input",
  CellTags->{"Exponential Observer", "i:1"}],

Cell[BoxData[
    \({{x1hat\^2 - x2hat + 27\ \((\(-x1hat\) - x1hat\ x2hat - x3hat + y1)\) + 
          5\ \((\(-x2hat\) - x3hat\^3 + y2)\) + 
          x3hat\ Cos[x2hat], \(-10\)\ \((\(-x2hat\) - x3hat\^3 + y2)\) + 
          x2hat\ Cos[x1hat], 
        u1 - 45\ \((\(-x1hat\) - x1hat\ x2hat - x3hat + y1)\) - 
          5\ \((\(-x2hat\) - x3hat\^3 + y2)\) + Cos[x1hat] + 
          Sin[x3hat]}, {x1hat, x2hat, 
        x3hat}, {\(-5\), \(-5\), \(-4\)}}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"Exponential Observer", "i:1"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExponentialObserver[f, h, {x1, x2, x3}, {u1}, {y1, y2}, {0, 0, 0}, {0}, 
      4, z]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"Exponential Observer", "i:1"}],

Cell[BoxData[
    \({{z1\^2 - z2 + 27\ \((y1 - z1 - z1\ z2 - z3)\) + 
          5\ \((y2 - z2 - z3\^3)\) + 
          z3\ Cos[z2], \(-10\)\ \((y2 - z2 - z3\^3)\) + z2\ Cos[z1], 
        u1 - 45\ \((y1 - z1 - z1\ z2 - z3)\) - 5\ \((y2 - z2 - z3\^3)\) + 
          Cos[z1] + Sin[z3]}, {z1, z2, 
        z3}, {\(-5\), \(-5\), \(-4\)}}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->{"Exponential Observer", "i:1"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExponentialObserver[f, h, {x1, x2, x3}, {u1}, {y1, y2}, {0, 0, 0}, {0}, 
      4, x]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->{"Exponential Observer", "i:1"}],

Cell[BoxData[
    \({{x1\^2 - x2 + 27\ \((\(-x1\) - x1\ x2 - x3 + y1)\) + 
          5\ \((\(-x2\) - x3\^3 + y2)\) + 
          x3\ Cos[x2], \(-10\)\ \((\(-x2\) - x3\^3 + y2)\) + x2\ Cos[x1], 
        u1 - 45\ \((\(-x1\) - x1\ x2 - x3 + y1)\) - 
          5\ \((\(-x2\) - x3\^3 + y2)\) + Cos[x1] + Sin[x3]}, {x1, x2, 
        x3}, {\(-5\), \(-5\), \(-4\)}}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->{"Exponential Observer", "i:1"}]
}, Open  ]],

Cell["If the (Taylor) linearized system is not observable", "Text",
  CellTags->{"Exponential Observer", "i:1"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(h = {x1*x2 + x3, x2 + x3^3};\)\), "\n", 
    \(ExponentialObserver[f, h, {x1, x2, x3}, {u1}, {y1, y2}, {0, 0, 0}, {0}, 
      4]\)}], "Input",
  CellLabel->"In[7]:=",
  CellTags->{"Exponential Observer", "i:1"}],

Cell[BoxData[
    \("Exponential observer may not exist"\)], "Print",
  CellTags->{"Exponential Observer", "i:1"}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{687, 271},
WindowMargins->{{11, Automatic}, {Automatic, 24}},
TaggingRules:>{"NextIndexingNumber" -> 2, "IndexEntries" -> {{"i:1", \
"ExponentialObserver"}}},
StyleDefinitions -> "Textbook.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Exponential Observer"->{
    Cell[1973, 64, 84, 1, 85, "Section",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[2060, 67, 300, 6, 81, "Text",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[2385, 77, 112, 3, 44, "Input",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[2500, 82, 531, 8, 175, "Print",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[3068, 95, 118, 3, 44, "Input",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[3189, 100, 123, 2, 42, "Print",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[3315, 104, 126, 2, 42, "Print",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[3444, 108, 119, 3, 38, "Output",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[3578, 114, 119, 1, 39, "Text",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[3722, 119, 126, 3, 44, "Input",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[3851, 124, 809, 11, 441, "Print",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[4697, 140, 74, 1, 54, "Subsection",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[4774, 143, 240, 5, 64, "Input",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[5039, 152, 159, 3, 44, "Input",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[5201, 157, 536, 10, 95, "Output",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[5774, 172, 186, 4, 64, "Input",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[5963, 178, 414, 8, 76, "Output",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[6414, 191, 186, 4, 64, "Input",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[6603, 197, 439, 8, 76, "Output",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[7057, 208, 112, 1, 39, "Text",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[7194, 213, 234, 5, 84, "Input",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[7431, 220, 114, 2, 42, "Print",
      CellTags->{"Exponential Observer", "i:1"}]},
  "i:1"->{
    Cell[1973, 64, 84, 1, 85, "Section",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[2060, 67, 300, 6, 81, "Text",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[2385, 77, 112, 3, 44, "Input",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[2500, 82, 531, 8, 175, "Print",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[3068, 95, 118, 3, 44, "Input",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[3189, 100, 123, 2, 42, "Print",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[3315, 104, 126, 2, 42, "Print",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[3444, 108, 119, 3, 38, "Output",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[3578, 114, 119, 1, 39, "Text",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[3722, 119, 126, 3, 44, "Input",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[3851, 124, 809, 11, 441, "Print",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[4697, 140, 74, 1, 54, "Subsection",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[4774, 143, 240, 5, 64, "Input",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[5039, 152, 159, 3, 44, "Input",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[5201, 157, 536, 10, 95, "Output",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[5774, 172, 186, 4, 64, "Input",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[5963, 178, 414, 8, 76, "Output",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[6414, 191, 186, 4, 64, "Input",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[6603, 197, 439, 8, 76, "Output",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[7057, 208, 112, 1, 39, "Text",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[7194, 213, 234, 5, 84, "Input",
      CellTags->{"Exponential Observer", "i:1"}],
    Cell[7431, 220, 114, 2, 42, "Print",
      CellTags->{"Exponential Observer", "i:1"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Exponential Observer", 8344, 247},
  {"i:1", 10363, 292}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 36, 0, 59, "Title"],

Cell[CellGroupData[{
Cell[1800, 55, 31, 0, 85, "Section"],
Cell[1834, 57, 102, 2, 50, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[1973, 64, 84, 1, 85, "Section",
  CellTags->{"Exponential Observer", "i:1"}],
Cell[2060, 67, 300, 6, 81, "Text",
  CellTags->{"Exponential Observer", "i:1"}],

Cell[CellGroupData[{
Cell[2385, 77, 112, 3, 44, "Input",
  CellTags->{"Exponential Observer", "i:1"}],
Cell[2500, 82, 531, 8, 175, "Print",
  CellTags->{"Exponential Observer", "i:1"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[3068, 95, 118, 3, 44, "Input",
  CellTags->{"Exponential Observer", "i:1"}],
Cell[3189, 100, 123, 2, 42, "Print",
  CellTags->{"Exponential Observer", "i:1"}],
Cell[3315, 104, 126, 2, 42, "Print",
  CellTags->{"Exponential Observer", "i:1"}],
Cell[3444, 108, 119, 3, 38, "Output",
  CellTags->{"Exponential Observer", "i:1"}]
}, Open  ]],
Cell[3578, 114, 119, 1, 39, "Text",
  CellTags->{"Exponential Observer", "i:1"}],

Cell[CellGroupData[{
Cell[3722, 119, 126, 3, 44, "Input",
  CellTags->{"Exponential Observer", "i:1"}],
Cell[3851, 124, 809, 11, 441, "Print",
  CellTags->{"Exponential Observer", "i:1"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[4697, 140, 74, 1, 54, "Subsection",
  CellTags->{"Exponential Observer", "i:1"}],
Cell[4774, 143, 240, 5, 64, "Input",
  CellTags->{"Exponential Observer", "i:1"}],

Cell[CellGroupData[{
Cell[5039, 152, 159, 3, 44, "Input",
  CellTags->{"Exponential Observer", "i:1"}],
Cell[5201, 157, 536, 10, 95, "Output",
  CellTags->{"Exponential Observer", "i:1"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[5774, 172, 186, 4, 64, "Input",
  CellTags->{"Exponential Observer", "i:1"}],
Cell[5963, 178, 414, 8, 76, "Output",
  CellTags->{"Exponential Observer", "i:1"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[6414, 191, 186, 4, 64, "Input",
  CellTags->{"Exponential Observer", "i:1"}],
Cell[6603, 197, 439, 8, 76, "Output",
  CellTags->{"Exponential Observer", "i:1"}]
}, Open  ]],
Cell[7057, 208, 112, 1, 39, "Text",
  CellTags->{"Exponential Observer", "i:1"}],

Cell[CellGroupData[{
Cell[7194, 213, 234, 5, 84, "Input",
  CellTags->{"Exponential Observer", "i:1"}],
Cell[7431, 220, 114, 2, 42, "Print",
  CellTags->{"Exponential Observer", "i:1"}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

