(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     19005,        668]*)
(*NotebookOutlinePosition[     34462,       1057]*)
(*  CellTagsIndexPosition[     33786,       1029]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Basic Tools", "Title"],

Cell[CellGroupData[{

Cell["Introduction", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< ProPac`\)], "Input",
  CellLabel->"In[1]:="],

Cell[BoxData[
    \("\n ProPac has been successfully loaded. It contains packages\n for \
multibody dynamics, linear control and nonlinear control.\n Appropriate \
packages will be loaded automatically as required.\n Packages can be manually \
loaded by simply entering GeometricTools,\n Dynamics, LinearControl, \
NonlinearControl or MEXTools as desired.\n Once a package is loaded, enter \
?GeomtricTools, ?Dynamics,\n ?LinearControl, ?NonlinearControl, or ?MEXTools, \
respectively,\n to obtain a list of available functions. Help is also \
available\n in the Help Browser under Add-ons."\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GeometricTools\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    \(GeometricTools\)], "Output",
  CellLabel->"Out[2]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Differential Geometry ", "Section"],

Cell[CellGroupData[{

Cell["Grad", "Subsection",
  CellTags->{"Grad", "i:1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Grad\)\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"Grad", "i:1"}],

Cell[BoxData[
    \("Grad[f,varlist] computes the gradient of the scalar function f with  \
respect to the variables varlist."\)], "Print",
  CellTags->{"Grad", "i:1"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Grad[Sin[x]\ y + y^2, {x, y}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"Grad", "i:1"}],

Cell[BoxData[
    \({y\ Cos[x], 2\ y + Sin[x]}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"Grad", "i:1"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Jacob", "Subsection",
  CellTags->{"Jacob", "i:2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Jacob\)\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"Jacob", "i:2"}],

Cell[BoxData[
    \("Jacob[f,x] computes the Jacobian of the list of functions f with\n  \
respect to the list of variables x.\n \n Example: Jacob[{x y, Sin[x^2 +x y]}, \
{x,y}]"\)], "Print",
  CellTags->{"Jacob", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Jacob[{x\ y, Sin[x^2 + x\ y]}, {x, y}]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->{"Jacob", "i:2"}],

Cell[BoxData[
    \({{y, x}, {\((2\ x + y)\)\ Cos[x\^2 + x\ y], 
        x\ Cos[x\^2 + x\ y]}}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->{"Jacob", "i:2"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["LieBracket & Ad", "Subsection",
  CellTags->{"LieBracket", "i:3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?LieBracket\)\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->{"LieBracket", "i:3"}],

Cell[BoxData[
    \("LieBracket[f,g,var] computes the Lie Bracket of the vector\n functions \
f,g with respect to the vector of variables var.\n \n Example: \
LieBracket[{x,Sin[x^2 +x y]},{y,Cos[x y]},{x,y}]"\)], "Print",
  CellTags->{"LieBracket", "i:3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LieBracket[{x, Sin[x^2\  + x\ y]}, {y, Cos[x\ y]}, {x, y}]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->{"LieBracket", "i:3"}],

Cell[BoxData[
    \({\(-y\) + Sin[x\^2 + x\ y], \(-y\)\ \((2\ x + y)\)\ Cos[x\^2 + x\ y] - 
        x\ Cos[x\ y]\ Cos[x\^2 + x\ y] - x\ y\ Sin[x\ y] - 
        x\ Sin[x\ y]\ Sin[x\^2 + x\ y]}\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->{"LieBracket", "i:3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Ad\)\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->{"LieBracket", "i:3"}],

Cell[BoxData[
    \("Ad[f,g,var,n] computes the nth Adjoint (iterated Lie Bracket) of\n the \
vector fields f,g with respect to the vector of variables var.\n         \
Ad[f,g,var,0]=g\n         Ad[f,g,var,n]=LieBracket[f,Ad[f,g,var,n-1],var]\n   \
      Ad[f,g,var]=Ad[f,g,var,1] "\)], "Print",
  CellTags->{"LieBracket", "i:3"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Ad[{x, Sin[x^2\  + x\ y]}, {y, Cos[x\ y]}, {x, y}, 2]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->{"LieBracket", "i:3"}],

Cell[BoxData[
    \({y + x\ \((2\ x + y)\)\ Cos[x\^2 + x\ y] - 
        Sin[x\^2 + x\ y] + \((\(-1\) + x\ Cos[x\^2 + x\ y])\)\ Sin[
            x\^2 + x\ y], \(-\((2\ x + y)\)\)\ Cos[
            x\^2 + x\ y]\ \((\(-y\) + Sin[x\^2 + x\ y])\) + 
        Sin[x\^2 + x\ y]\ \((\(-x\^2\)\ y\ Cos[x\ y] - 
              y\ Cos[x\^2 + x\ y] - \((2\ x + y)\)\ Cos[x\^2 + x\ y] - 
              x\ Sin[x\ y] + x\ y\ \((2\ x + y)\)\ Sin[x\^2 + x\ y])\) + 
        x\ \((\(-x\)\ y\^2\ Cos[x\ y] - 2\ y\ Cos[x\^2 + x\ y] - 
              Cos[x\ y]\ Cos[x\^2 + x\ y] - y\ Sin[x\ y] + 
              x\ y\ Cos[x\^2 + x\ y]\ Sin[x\ y] - 
              x\ \((2\ x + y)\)\ Cos[x\^2 + x\ y]\ Sin[x\ y] + 
              y\ \((2\ x + y)\)\^2\ Sin[x\^2 + x\ y] - 
              x\ y\ Cos[x\ y]\ Sin[x\^2 + x\ y] + 
              x\ \((2\ x + y)\)\ Cos[x\ y]\ Sin[x\^2 + x\ y] - 
              Sin[x\ y]\ Sin[x\^2 + x\ y])\) - 
        x\ Cos[x\^2 + x\ y]\ \((\(-y\)\ \((2\ x + y)\)\ Cos[x\^2 + x\ y] - 
              x\ Cos[x\ y]\ Cos[x\^2 + x\ y] - x\ y\ Sin[x\ y] - 
              x\ Sin[x\ y]\ Sin[x\^2 + x\ y])\)}\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->{"LieBracket", "i:3"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["LieDerivative", "Subsection",
  CellTags->{"LieDerivative", "i:4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?LieDerivative\)\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->{"LieDerivative", "i:4"}],

Cell[BoxData[
    \("LieDerivative[f,h,x] computes the Lie derivative of the real valued\n \
function h of the vector x along the direction defined by the vector\n field \
f:\n   LDf[h](x) = < dh(x),f(x) >\n \n LieDerivative[f,h,x,k] computes the \
k-th order Lie derivative of the\n real valued function h of the vector x \
along the direction defined by\n  the vector field f:\n   LD^k f[h](x) = \
LD^(k-1) f[LDf[h]](x)\n   LD^0 f[h](x) = h(x) "\)], "Print",
  CellTags->{"LieDerivative", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LieDerivative[{Cos[x^2\ y], x + y^2}, {x^2, x\ y + y}, {x, 
        y}]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->{"LieDerivative", "i:4"}],

Cell[BoxData[
    \({2\ x\ Cos[x\^2\ y], \((1 + x)\)\ \((x + y\^2)\) + 
        y\ Cos[x\^2\ y]}\)], "Output",
  CellLabel->"Out[12]=",
  CellTags->{"LieDerivative", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LieDerivative[{Cos[x^2\ y], x + y^2}, {x^2, x\ y + y}, {x, y}, 
      2]\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->{"LieDerivative", "i:4"}],

Cell[BoxData[
    \({\(-2\)\ x\^3\ \((x + y\^2)\)\ Sin[x\^2\ y] + 
        Cos[x\^2\ y]\ \((2\ Cos[x\^2\ y] - 
              4\ x\^2\ y\ Sin[x\^2\ y])\), \((x + 
              y\^2)\)\ \((2\ \((1 + x)\)\ y + Cos[x\^2\ y] - 
              x\^2\ y\ Sin[x\^2\ y])\) + 
        Cos[x\^2\ y]\ \((1 + 2\ x + y\^2 - 
              2\ x\ y\^2\ Sin[x\^2\ y])\)}\)], "Output",
  CellLabel->"Out[13]=",
  CellTags->{"LieDerivative", "i:4"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Involutive", "Subsection",
  CellTags->"Involutive"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Involutive\)\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"Involutive"],

Cell[BoxData[
    \("Involutive[X,x] tests a set X of vector fields to determine if it is\n \
involutive. It reports the result as a value True or False. The argument\n  X \
must be a list of vector fields, and x must be a list of the\n variables."\)],
   "Print",
  CellTags->"Involutive"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Involutive[{{Sin[x], y\ Cos[x]}, {Cos[y], Sin[x]}}, {x, y}]\)], "Input",\

  CellLabel->"In[15]:=",
  CellTags->"Involutive"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[15]=",
  CellTags->"Involutive"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Rank", "Subsection",
  CellTags->{"Rank", "i:5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Rank\)\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->{"Rank", "i:5"}],

Cell[BoxData[
    \("Rank[X] computes the (generic) rank of a list of vector fields X."\)], \
"Print",
  CellTags->{"Rank", "i:5"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Rank[{{Sin[x], y\ Cos[x]}, {Cos[y], Sin[x]}}]\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->{"Rank", "i:5"}],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[17]=",
  CellTags->{"Rank", "i:5"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Span", "Subsection",
  CellTags->{"Span", "i:6"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Span\)\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->{"Span", "i:6"}],

Cell[BoxData[
    \("Span[X] gives a basis set for the span of a list of vector fields \
X."\)], "Print",
  CellTags->{"Span", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Span[{{Sin[x], y\ Cos[x]}, {Cos[y], Sin[x]}}]\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->{"Span", "i:6"}],

Cell[BoxData[
    \({{1, 0}, {0, 1}}\)], "Output",
  CellLabel->"Out[19]=",
  CellTags->{"Span", "i:6"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["SpecialNullSpace", "Subsection",
  CellTags->{"SpecialNullSpace", "i:12"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?SpecialNullSpace\)\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->{"SpecialNullSpace", "i:12"}],

Cell[BoxData[
    \("SpecialNullSpace[A] gives a basis for the Null Space of A. It\n \
returns an analytic set of basis vector fields if A(x) is\n analytic."\)], \
"Print",
  CellTags->{"SpecialNullSpace", "i:12"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(A = {{x\^3\ Sin[x], x^2\ Cos[x]}, {x\ Sin[x], Cos[x]}}\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->{"SpecialNullSpace", "i:12"}],

Cell[BoxData[
    \({{x\^3\ Sin[x], x\^2\ Cos[x]}, {x\ Sin[x], Cos[x]}}\)], "Output",
  CellLabel->"Out[21]=",
  CellTags->{"SpecialNullSpace", "i:12"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NullSpace[A]\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->{"SpecialNullSpace", "i:12"}],

Cell[BoxData[
    \({{\(-\(Cot[x]\/x\)\), 1}}\)], "Output",
  CellLabel->"Out[22]=",
  CellTags->{"SpecialNullSpace", "i:12"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SpecialNullSpace[A]\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->{"SpecialNullSpace", "i:12"}],

Cell[BoxData[
    \({{\(-Cot[x]\), x}}\)], "Output",
  CellLabel->"Out[23]=",
  CellTags->{"SpecialNullSpace", "i:12"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Invariant Distributions", "Subsection",
  CellTags->{"Invariant Distributions", "i:8"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?LargestInvariantDistribution\)\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->{"Invariant Distributions", "i:8"}],

Cell[BoxData[
    \("LargestInvariantDistribution[tau,h,var] returns the largest\n \
distribution invariant with respect to the set of vector fields\n tau and \
contained in the distribution annihilator of exact codistribution\n {dh}. The \
fields tau and the vector-valued function h\n are given in the local \
coordinates var. "\)], "Print",
  CellTags->{"Invariant Distributions", "i:8"}]
}, Open  ]],

Cell[BoxData[{
    \(\(f = {x1\ x3 + x2\ Exp[x2], x3, x4 - x2\ x3, 
          x3^2 + x2\ x4 - x2^2\ x3};\)\), "\n", 
    \(\(g = {x1, 1, 0, x3};\)\), "\n", 
    \(\(h = {x3};\)\), "\n", 
    \(\(var = {x1, x2, x3, x4};\)\)}], "Input",
  CellTags->{"Invariant Distributions", "i:8"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(LargestInvariantDistribution[{f, g}, h, var]\)], "Input",
  CellTags->{"Invariant Distributions", "i:8"}],

Cell[BoxData[
    \({{0, 1, 0, x3}, {1, 0, 0, 0}}\)], "Output",
  CellTags->{"Invariant Distributions", "i:8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?SmallestInvariantDistribution\)\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->{"Invariant Distributions", "i:8"}],

Cell[BoxData[
    \("SmallestInvariantDistribution[tau,del,var] returns the smallest\n \
distribution invariant with respect to the set of vector fields\n tau and \
containing the distribution del. The fields tau and the \n distribution del \
are given in the local coordinates var. "\)], "Print",
  CellTags->{"Invariant Distributions", "i:8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(del = Span[{g}]\)], "Input",
  CellTags->{"Invariant Distributions", "i:8"}],

Cell[BoxData[
    \({{x1, 1, 0, x3}}\)], "Output",
  CellTags->{"Invariant Distributions", "i:8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SmallestInvariantDistribution[{f, g}, del, var]\)], "Input",
  CellTags->{"Invariant Distributions", "i:8"}],

Cell[BoxData[
    \({{1, 0, 0, 0}, {0, 1, 0, x3}}\)], "Output",
  CellTags->{"Invariant Distributions", "i:8"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Triangular Decomposition", "Subsection",
  CellTags->{"Triangular Decomposition", "i:13"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?TriangularDecomposition\)\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->{"Triangular Decomposition", "i:13"}],

Cell[BoxData[
    \("TriangularDecomposition[f,Del,x,x0,m] returns {Psi,PsiInverse,fnew},\n\
given an involutive distribution Del that is invariant with respect to the\n\
vector field f - both described in terms of local coordinates x, around a \n\
point x0. Psi and PsiInverse define transformation to new coordinates z, \
x=Psi(z)\nalligned with/and transverse to the integral manifolds of Del. It \
places f(x) in a\ntriangular form given by fnew(z). \nThe transfrom x=Psi(z) \
and its inverse z=PsiInverse(x)\nare obtained as a power series of order m. m \
can be set to Infinity to obtain an exact result if it is computable. "\)], \
"Print",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Triangular Decomposition", "i:13"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(f = {x1\ x3 + x2\ Exp[x2], x3, x4 - x2\ x3, 
          x3^2 + x2\ x4 - x2^2\ x3};\)\), "\n", 
    \(\(g = {x1, 1, 0, x3};\)\), "\n", 
    \(\(var = {x1, x2, x3, x4};\)\), "\n", 
    \(del = Span[{g}]\)}], "Input",
  CellTags->{"Triangular Decomposition", "i:13"}],

Cell[BoxData[
    \({{x1, 1, 0, x3}}\)], "Output",
  CellTags->{"Triangular Decomposition", "i:13"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Del0 = SmallestInvariantDistribution[{f, g}, del, var]\)], "Input",
  CellTags->{"Triangular Decomposition", "i:13"}],

Cell[BoxData[
    \({{1, 0, 0, 0}, {0, 1, 0, x3}}\)], "Output",
  CellTags->{"Triangular Decomposition", "i:13"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Del = Join[Del0, {{0, 0, 1, 0}, {0, 0, 0, 1}}]\)], "Input",
  CellTags->{"Triangular Decomposition", "i:13"}],

Cell[BoxData[
    \({{1, 0, 0, 0}, {0, 1, 0, x3}, {0, 0, 1, 0}, {0, 0, 0, 1}}\)], "Output",
  CellTags->{"Triangular Decomposition", "i:13"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TriangularDecomposition[f + g*u, Del, var, {0, 0, 0, 0}, 
      Infinity]\)], "Input",
  CellTags->{"Triangular Decomposition", "i:13"}],

Cell[BoxData[
    \({{z1, z2, z3, z2\ z3 + z4}, {x1, x2, 
        x3, \(-x2\)\ x3 + x4}, {u\ z1 + E\^z2\ z2 + z1\ z3, u + z3, z4, 
        0}}\)], "Output",
  CellTags->{"Triangular Decomposition", "i:13"}]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Working with Complex Arrays", "Section",
  CellTags->"Complex Arrays"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?SpecialInverse\)\)], "Input",
  CellLabel->"In[24]:=",
  CellTags->{"Complex Arrays", "i:9"}],

Cell[BoxData[
    \("SpecialInverse[A] gives the inverse of a square (generically) \
invertible\n matrix A. It can be considerably more efficient than the \
standard\n Mathematica function Inverse if the elements of A are complex \
expressions."\)], "Print",
  CellTags->{"Complex Arrays", "i:9"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?SimplifyArray\)\)], "Input",
  CellLabel->"In[25]:=",
  CellTags->{"Complex Arrays", "i:10"}],

Cell[BoxData[
    \("SimplifyArray[A] returns a simplified version of the list A.\n It is \
intended to replace the standard function Simplify when\n complex lists of \
expressions are to be simplified. SimplifyArray\n applies Simplify to \
individual expressions in A or groups of\n expressions with combined leaf \
count less than 200."\)], "Print",
  CellTags->{"Complex Arrays", "i:10"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?WriteArray\)\)], "Input",
  CellLabel->"In[26]:=",
  CellTags->{"Complex Arrays", "i:11"}],

Cell[BoxData[
    \("WriteArray[filename,A] writes the array A to the file filename.\n \
WriteArray writes individual expressions or groups of expressions\n with leaf \
count less than 200. This partially mitigates the memory\n explosion that \
occurs when writing large arrays using the standard\n Mathematica write \
functions. WriteArray can roughly double the time\n required to write an \
array, but it may reduce the the maximum memory\n used by an order of \
magnitude or more. For example, to write\n and retrieve the two arrays A and \
B use:\n \n       WriteArray[Temp,{A,B}]\n       {A,B}=Get[Temp]\n   "\)], \
"Print",
  CellTags->{"Complex Arrays", "i:11"}]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
ShowPageBreaks->False,
WindowSize->{665, 292},
WindowMargins->{{0, Automatic}, {Automatic, 5}},
Visible->True,
TaggingRules:>{"NextIndexingNumber" -> 14, "IndexEntries" -> {{"i:1", \
"Grad"}, {"i:10", "SimplifyArray"}, {"i:11", "WriteArray"}, {"i:12", \
"SpecialNullSpace"}, {"i:13", "TriangularDecomposition"}, {"i:2", "Jacob"}, \
{"i:3", "Ad"}, {"i:3", "LieBracket"}, {"i:4", "LieDerivative"}, {"i:5", \
"Rank"}, {"i:6", "Span"}, {"i:8", "SmallestInvariantDistribution"}, {"i:9", \
"SpecialInverse"}, {"i:8", "LargestInvariantDistribution", "", ""}}},
ShowCellTags->True,
StyleDefinitions -> "Textbook.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Grad"->{
    Cell[2820, 92, 55, 1, 54, "Subsection",
      CellTags->{"Grad", "i:1"}],
    Cell[2900, 97, 95, 3, 44, "Input",
      CellTags->{"Grad", "i:1"}],
    Cell[2998, 102, 168, 3, 61, "Print",
      CellTags->{"Grad", "i:1"}],
    Cell[3203, 110, 115, 3, 44, "Input",
      CellTags->{"Grad", "i:1"}],
    Cell[3321, 115, 113, 3, 38, "Output",
      CellTags->{"Grad", "i:1"}]},
  "i:1"->{
    Cell[2820, 92, 55, 1, 54, "Subsection",
      CellTags->{"Grad", "i:1"}],
    Cell[2900, 97, 95, 3, 44, "Input",
      CellTags->{"Grad", "i:1"}],
    Cell[2998, 102, 168, 3, 61, "Print",
      CellTags->{"Grad", "i:1"}],
    Cell[3203, 110, 115, 3, 44, "Input",
      CellTags->{"Grad", "i:1"}],
    Cell[3321, 115, 113, 3, 38, "Output",
      CellTags->{"Grad", "i:1"}]},
  "Jacob"->{
    Cell[3483, 124, 57, 1, 48, "Subsection",
      CellTags->{"Jacob", "i:2"}],
    Cell[3565, 129, 97, 3, 44, "Input",
      CellTags->{"Jacob", "i:2"}],
    Cell[3665, 134, 221, 4, 85, "Print",
      CellTags->{"Jacob", "i:2"}],
    Cell[3923, 143, 125, 3, 44, "Input",
      CellTags->{"Jacob", "i:2"}],
    Cell[4051, 148, 162, 4, 24, "Output",
      CellTags->{"Jacob", "i:2"}]},
  "i:2"->{
    Cell[3483, 124, 57, 1, 48, "Subsection",
      CellTags->{"Jacob", "i:2"}],
    Cell[3565, 129, 97, 3, 44, "Input",
      CellTags->{"Jacob", "i:2"}],
    Cell[3665, 134, 221, 4, 85, "Print",
      CellTags->{"Jacob", "i:2"}],
    Cell[3923, 143, 125, 3, 44, "Input",
      CellTags->{"Jacob", "i:2"}],
    Cell[4051, 148, 162, 4, 24, "Output",
      CellTags->{"Jacob", "i:2"}]},
  "LieBracket"->{
    Cell[4262, 158, 72, 1, 48, "Subsection",
      CellTags->{"LieBracket", "i:3"}],
    Cell[4359, 163, 107, 3, 44, "Input",
      CellTags->{"LieBracket", "i:3"}],
    Cell[4469, 168, 256, 4, 70, "Print",
      CellTags->{"LieBracket", "i:3"}],
    Cell[4762, 177, 150, 3, 44, "Input",
      CellTags->{"LieBracket", "i:3"}],
    Cell[4915, 182, 264, 5, 70, "Output",
      CellTags->{"LieBracket", "i:3"}],
    Cell[5216, 192, 99, 3, 44, "Input",
      CellTags->{"LieBracket", "i:3"}],
    Cell[5318, 197, 330, 5, 70, "Print",
      CellTags->{"LieBracket", "i:3"}],
    Cell[5685, 207, 146, 3, 44, "Input",
      CellTags->{"LieBracket", "i:3"}],
    Cell[5834, 212, 1171, 20, 70, "Output",
      CellTags->{"LieBracket", "i:3"}]},
  "i:3"->{
    Cell[4262, 158, 72, 1, 48, "Subsection",
      CellTags->{"LieBracket", "i:3"}],
    Cell[4359, 163, 107, 3, 44, "Input",
      CellTags->{"LieBracket", "i:3"}],
    Cell[4469, 168, 256, 4, 70, "Print",
      CellTags->{"LieBracket", "i:3"}],
    Cell[4762, 177, 150, 3, 44, "Input",
      CellTags->{"LieBracket", "i:3"}],
    Cell[4915, 182, 264, 5, 70, "Output",
      CellTags->{"LieBracket", "i:3"}],
    Cell[5216, 192, 99, 3, 44, "Input",
      CellTags->{"LieBracket", "i:3"}],
    Cell[5318, 197, 330, 5, 70, "Print",
      CellTags->{"LieBracket", "i:3"}],
    Cell[5685, 207, 146, 3, 44, "Input",
      CellTags->{"LieBracket", "i:3"}],
    Cell[5834, 212, 1171, 20, 70, "Output",
      CellTags->{"LieBracket", "i:3"}]},
  "LieDerivative"->{
    Cell[7054, 238, 73, 1, 48, "Subsection",
      CellTags->{"LieDerivative", "i:4"}],
    Cell[7152, 243, 114, 3, 44, "Input",
      CellTags->{"LieDerivative", "i:4"}],
    Cell[7269, 248, 498, 7, 70, "Print",
      CellTags->{"LieDerivative", "i:4"}],
    Cell[7804, 260, 167, 4, 44, "Input",
      CellTags->{"LieDerivative", "i:4"}],
    Cell[7974, 266, 173, 4, 70, "Output",
      CellTags->{"LieDerivative", "i:4"}],
    Cell[8184, 275, 168, 4, 44, "Input",
      CellTags->{"LieDerivative", "i:4"}],
    Cell[8355, 281, 429, 9, 70, "Output",
      CellTags->{"LieDerivative", "i:4"}]},
  "i:4"->{
    Cell[7054, 238, 73, 1, 48, "Subsection",
      CellTags->{"LieDerivative", "i:4"}],
    Cell[7152, 243, 114, 3, 44, "Input",
      CellTags->{"LieDerivative", "i:4"}],
    Cell[7269, 248, 498, 7, 70, "Print",
      CellTags->{"LieDerivative", "i:4"}],
    Cell[7804, 260, 167, 4, 44, "Input",
      CellTags->{"LieDerivative", "i:4"}],
    Cell[7974, 266, 173, 4, 70, "Output",
      CellTags->{"LieDerivative", "i:4"}],
    Cell[8184, 275, 168, 4, 44, "Input",
      CellTags->{"LieDerivative", "i:4"}],
    Cell[8355, 281, 429, 9, 70, "Output",
      CellTags->{"LieDerivative", "i:4"}]},
  "Involutive"->{
    Cell[8833, 296, 58, 1, 48, "Subsection",
      CellTags->"Involutive"],
    Cell[8916, 301, 99, 3, 44, "Input",
      CellTags->"Involutive"],
    Cell[9018, 306, 290, 5, 70, "Print",
      CellTags->"Involutive"],
    Cell[9345, 316, 145, 4, 44, "Input",
      CellTags->"Involutive"],
    Cell[9493, 322, 89, 3, 70, "Output",
      CellTags->"Involutive"]},
  "Rank"->{
    Cell[9631, 331, 55, 1, 48, "Subsection",
      CellTags->{"Rank", "i:5"}],
    Cell[9711, 336, 96, 3, 44, "Input",
      CellTags->{"Rank", "i:5"}],
    Cell[9810, 341, 131, 3, 70, "Print",
      CellTags->{"Rank", "i:5"}],
    Cell[9978, 349, 132, 3, 44, "Input",
      CellTags->{"Rank", "i:5"}],
    Cell[10113, 354, 89, 3, 70, "Output",
      CellTags->{"Rank", "i:5"}]},
  "i:5"->{
    Cell[9631, 331, 55, 1, 48, "Subsection",
      CellTags->{"Rank", "i:5"}],
    Cell[9711, 336, 96, 3, 44, "Input",
      CellTags->{"Rank", "i:5"}],
    Cell[9810, 341, 131, 3, 70, "Print",
      CellTags->{"Rank", "i:5"}],
    Cell[9978, 349, 132, 3, 44, "Input",
      CellTags->{"Rank", "i:5"}],
    Cell[10113, 354, 89, 3, 70, "Output",
      CellTags->{"Rank", "i:5"}]},
  "Span"->{
    Cell[10251, 363, 55, 1, 48, "Subsection",
      CellTags->{"Span", "i:6"}],
    Cell[10331, 368, 96, 3, 44, "Input",
      CellTags->{"Span", "i:6"}],
    Cell[10430, 373, 134, 3, 42, "Print",
      CellTags->{"Span", "i:6"}],
    Cell[10601, 381, 132, 3, 44, "Input",
      CellTags->{"Span", "i:6"}],
    Cell[10736, 386, 104, 3, 38, "Output",
      CellTags->{"Span", "i:6"}]},
  "i:6"->{
    Cell[10251, 363, 55, 1, 48, "Subsection",
      CellTags->{"Span", "i:6"}],
    Cell[10331, 368, 96, 3, 44, "Input",
      CellTags->{"Span", "i:6"}],
    Cell[10430, 373, 134, 3, 42, "Print",
      CellTags->{"Span", "i:6"}],
    Cell[10601, 381, 132, 3, 44, "Input",
      CellTags->{"Span", "i:6"}],
    Cell[10736, 386, 104, 3, 38, "Output",
      CellTags->{"Span", "i:6"}]},
  "SpecialNullSpace"->{
    Cell[10889, 395, 80, 1, 48, "Subsection",
      CellTags->{"SpecialNullSpace", "i:12"}],
    Cell[10994, 400, 121, 3, 44, "Input",
      CellTags->{"SpecialNullSpace", "i:12"}],
    Cell[11118, 405, 214, 4, 80, "Print",
      CellTags->{"SpecialNullSpace", "i:12"}],
    Cell[11369, 414, 154, 3, 45, "Input",
      CellTags->{"SpecialNullSpace", "i:12"}],
    Cell[11526, 419, 152, 3, 38, "Output",
      CellTags->{"SpecialNullSpace", "i:12"}],
    Cell[11715, 427, 112, 3, 44, "Input",
      CellTags->{"SpecialNullSpace", "i:12"}],
    Cell[11830, 432, 126, 3, 51, "Output",
      CellTags->{"SpecialNullSpace", "i:12"}],
    Cell[11993, 440, 119, 3, 44, "Input",
      CellTags->{"SpecialNullSpace", "i:12"}],
    Cell[12115, 445, 119, 3, 38, "Output",
      CellTags->{"SpecialNullSpace", "i:12"}]},
  "i:12"->{
    Cell[10889, 395, 80, 1, 48, "Subsection",
      CellTags->{"SpecialNullSpace", "i:12"}],
    Cell[10994, 400, 121, 3, 44, "Input",
      CellTags->{"SpecialNullSpace", "i:12"}],
    Cell[11118, 405, 214, 4, 80, "Print",
      CellTags->{"SpecialNullSpace", "i:12"}],
    Cell[11369, 414, 154, 3, 45, "Input",
      CellTags->{"SpecialNullSpace", "i:12"}],
    Cell[11526, 419, 152, 3, 38, "Output",
      CellTags->{"SpecialNullSpace", "i:12"}],
    Cell[11715, 427, 112, 3, 44, "Input",
      CellTags->{"SpecialNullSpace", "i:12"}],
    Cell[11830, 432, 126, 3, 51, "Output",
      CellTags->{"SpecialNullSpace", "i:12"}],
    Cell[11993, 440, 119, 3, 44, "Input",
      CellTags->{"SpecialNullSpace", "i:12"}],
    Cell[12115, 445, 119, 3, 38, "Output",
      CellTags->{"SpecialNullSpace", "i:12"}]},
  "Invariant Distributions"->{
    Cell[12283, 454, 93, 1, 48, "Subsection",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[12401, 459, 138, 3, 44, "Input",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[12542, 464, 391, 6, 137, "Print",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[12948, 473, 282, 6, 104, "Input",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[13255, 483, 125, 2, 44, "Input",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[13383, 487, 111, 2, 38, "Output",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[13531, 494, 139, 3, 44, "Input",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[13673, 499, 345, 5, 99, "Print",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[14055, 509, 96, 2, 44, "Input",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[14154, 513, 98, 2, 38, "Output",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[14289, 520, 128, 2, 44, "Input",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[14420, 524, 111, 2, 38, "Output",
      CellTags->{"Invariant Distributions", "i:8"}]},
  "i:8"->{
    Cell[12283, 454, 93, 1, 48, "Subsection",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[12401, 459, 138, 3, 44, "Input",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[12542, 464, 391, 6, 137, "Print",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[12948, 473, 282, 6, 104, "Input",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[13255, 483, 125, 2, 44, "Input",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[13383, 487, 111, 2, 38, "Output",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[13531, 494, 139, 3, 44, "Input",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[13673, 499, 345, 5, 99, "Print",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[14055, 509, 96, 2, 44, "Input",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[14154, 513, 98, 2, 38, "Output",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[14289, 520, 128, 2, 44, "Input",
      CellTags->{"Invariant Distributions", "i:8"}],
    Cell[14420, 524, 111, 2, 38, "Output",
      CellTags->{"Invariant Distributions", "i:8"}]},
  "Triangular Decomposition"->{
    Cell[14580, 532, 96, 1, 48, "Subsection",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[14701, 537, 136, 3, 44, "Input",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[14840, 542, 749, 12, 194, "Print",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[15626, 559, 286, 6, 90, "Input",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[15915, 567, 100, 2, 24, "Output",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[16052, 574, 137, 2, 30, "Input",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[16192, 578, 113, 2, 24, "Output",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[16342, 585, 129, 2, 30, "Input",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[16474, 589, 141, 2, 24, "Output",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[16652, 596, 156, 3, 30, "Input",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[16811, 601, 206, 4, 24, "Output",
      CellTags->{"Triangular Decomposition", "i:13"}]},
  "i:13"->{
    Cell[14580, 532, 96, 1, 48, "Subsection",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[14701, 537, 136, 3, 44, "Input",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[14840, 542, 749, 12, 194, "Print",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[15626, 559, 286, 6, 90, "Input",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[15915, 567, 100, 2, 24, "Output",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[16052, 574, 137, 2, 30, "Input",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[16192, 578, 113, 2, 24, "Output",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[16342, 585, 129, 2, 30, "Input",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[16474, 589, 141, 2, 24, "Output",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[16652, 596, 156, 3, 30, "Input",
      CellTags->{"Triangular Decomposition", "i:13"}],
    Cell[16811, 601, 206, 4, 24, "Output",
      CellTags->{"Triangular Decomposition", "i:13"}]},
  "Complex Arrays"->{
    Cell[17078, 612, 76, 1, 99, "Section",
      CellTags->"Complex Arrays"],
    Cell[17179, 617, 116, 3, 44, "Input",
      CellTags->{"Complex Arrays", "i:9"}],
    Cell[17298, 622, 297, 5, 104, "Print",
      CellTags->{"Complex Arrays", "i:9"}],
    Cell[17632, 632, 116, 3, 39, "Input",
      CellTags->{"Complex Arrays", "i:10"}],
    Cell[17751, 637, 391, 6, 104, "Print",
      CellTags->{"Complex Arrays", "i:10"}],
    Cell[18179, 648, 113, 3, 39, "Input",
      CellTags->{"Complex Arrays", "i:11"}],
    Cell[18295, 653, 670, 10, 275, "Print",
      CellTags->{"Complex Arrays", "i:11"}]},
  "i:9"->{
    Cell[17179, 617, 116, 3, 44, "Input",
      CellTags->{"Complex Arrays", "i:9"}],
    Cell[17298, 622, 297, 5, 104, "Print",
      CellTags->{"Complex Arrays", "i:9"}]},
  "i:10"->{
    Cell[17632, 632, 116, 3, 39, "Input",
      CellTags->{"Complex Arrays", "i:10"}],
    Cell[17751, 637, 391, 6, 104, "Print",
      CellTags->{"Complex Arrays", "i:10"}]},
  "i:11"->{
    Cell[18179, 648, 113, 3, 39, "Input",
      CellTags->{"Complex Arrays", "i:11"}],
    Cell[18295, 653, 670, 10, 275, "Print",
      CellTags->{"Complex Arrays", "i:11"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Grad", 20138, 694},
  {"i:1", 20527, 705},
  {"Jacob", 20918, 716},
  {"i:2", 21314, 727},
  {"LieBracket", 21717, 738},
  {"i:3", 22465, 757},
  {"LieDerivative", 23223, 776},
  {"i:4", 23829, 791},
  {"Involutive", 24442, 806},
  {"Rank", 24818, 817},
  {"i:5", 25209, 828},
  {"Span", 25601, 839},
  {"i:6", 25997, 850},
  {"SpecialNullSpace", 26406, 861},
  {"i:12", 27227, 880},
  {"Invariant Distributions", 28067, 899},
  {"i:8", 29226, 924},
  {"Triangular Decomposition", 30406, 949},
  {"i:13", 31496, 972},
  {"Complex Arrays", 32596, 995},
  {"i:9", 33210, 1010},
  {"i:10", 33396, 1015},
  {"i:11", 33584, 1020}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 28, 0, 59, "Title"],

Cell[CellGroupData[{
Cell[1792, 55, 31, 0, 85, "Section"],

Cell[CellGroupData[{
Cell[1848, 59, 67, 2, 30, "Input"],
Cell[1918, 63, 604, 8, 199, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2559, 76, 71, 2, 30, "Input"],
Cell[2633, 80, 72, 2, 24, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[2754, 88, 41, 0, 85, "Section"],

Cell[CellGroupData[{
Cell[2820, 92, 55, 1, 54, "Subsection",
  CellTags->{"Grad", "i:1"}],

Cell[CellGroupData[{
Cell[2900, 97, 95, 3, 44, "Input",
  CellTags->{"Grad", "i:1"}],
Cell[2998, 102, 168, 3, 61, "Print",
  CellTags->{"Grad", "i:1"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[3203, 110, 115, 3, 44, "Input",
  CellTags->{"Grad", "i:1"}],
Cell[3321, 115, 113, 3, 38, "Output",
  CellTags->{"Grad", "i:1"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[3483, 124, 57, 1, 48, "Subsection",
  CellTags->{"Jacob", "i:2"}],

Cell[CellGroupData[{
Cell[3565, 129, 97, 3, 44, "Input",
  CellTags->{"Jacob", "i:2"}],
Cell[3665, 134, 221, 4, 85, "Print",
  CellTags->{"Jacob", "i:2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[3923, 143, 125, 3, 44, "Input",
  CellTags->{"Jacob", "i:2"}],
Cell[4051, 148, 162, 4, 24, "Output",
  CellTags->{"Jacob", "i:2"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[4262, 158, 72, 1, 48, "Subsection",
  CellTags->{"LieBracket", "i:3"}],

Cell[CellGroupData[{
Cell[4359, 163, 107, 3, 44, "Input",
  CellTags->{"LieBracket", "i:3"}],
Cell[4469, 168, 256, 4, 70, "Print",
  CellTags->{"LieBracket", "i:3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[4762, 177, 150, 3, 44, "Input",
  CellTags->{"LieBracket", "i:3"}],
Cell[4915, 182, 264, 5, 70, "Output",
  CellTags->{"LieBracket", "i:3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[5216, 192, 99, 3, 44, "Input",
  CellTags->{"LieBracket", "i:3"}],
Cell[5318, 197, 330, 5, 70, "Print",
  CellTags->{"LieBracket", "i:3"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[5685, 207, 146, 3, 44, "Input",
  CellTags->{"LieBracket", "i:3"}],
Cell[5834, 212, 1171, 20, 70, "Output",
  CellTags->{"LieBracket", "i:3"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[7054, 238, 73, 1, 48, "Subsection",
  CellTags->{"LieDerivative", "i:4"}],

Cell[CellGroupData[{
Cell[7152, 243, 114, 3, 44, "Input",
  CellTags->{"LieDerivative", "i:4"}],
Cell[7269, 248, 498, 7, 70, "Print",
  CellTags->{"LieDerivative", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[7804, 260, 167, 4, 44, "Input",
  CellTags->{"LieDerivative", "i:4"}],
Cell[7974, 266, 173, 4, 70, "Output",
  CellTags->{"LieDerivative", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[8184, 275, 168, 4, 44, "Input",
  CellTags->{"LieDerivative", "i:4"}],
Cell[8355, 281, 429, 9, 70, "Output",
  CellTags->{"LieDerivative", "i:4"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[8833, 296, 58, 1, 48, "Subsection",
  CellTags->"Involutive"],

Cell[CellGroupData[{
Cell[8916, 301, 99, 3, 44, "Input",
  CellTags->"Involutive"],
Cell[9018, 306, 290, 5, 70, "Print",
  CellTags->"Involutive"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9345, 316, 145, 4, 44, "Input",
  CellTags->"Involutive"],
Cell[9493, 322, 89, 3, 70, "Output",
  CellTags->"Involutive"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[9631, 331, 55, 1, 48, "Subsection",
  CellTags->{"Rank", "i:5"}],

Cell[CellGroupData[{
Cell[9711, 336, 96, 3, 44, "Input",
  CellTags->{"Rank", "i:5"}],
Cell[9810, 341, 131, 3, 70, "Print",
  CellTags->{"Rank", "i:5"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[9978, 349, 132, 3, 44, "Input",
  CellTags->{"Rank", "i:5"}],
Cell[10113, 354, 89, 3, 70, "Output",
  CellTags->{"Rank", "i:5"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[10251, 363, 55, 1, 48, "Subsection",
  CellTags->{"Span", "i:6"}],

Cell[CellGroupData[{
Cell[10331, 368, 96, 3, 44, "Input",
  CellTags->{"Span", "i:6"}],
Cell[10430, 373, 134, 3, 42, "Print",
  CellTags->{"Span", "i:6"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[10601, 381, 132, 3, 44, "Input",
  CellTags->{"Span", "i:6"}],
Cell[10736, 386, 104, 3, 38, "Output",
  CellTags->{"Span", "i:6"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[10889, 395, 80, 1, 48, "Subsection",
  CellTags->{"SpecialNullSpace", "i:12"}],

Cell[CellGroupData[{
Cell[10994, 400, 121, 3, 44, "Input",
  CellTags->{"SpecialNullSpace", "i:12"}],
Cell[11118, 405, 214, 4, 80, "Print",
  CellTags->{"SpecialNullSpace", "i:12"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[11369, 414, 154, 3, 45, "Input",
  CellTags->{"SpecialNullSpace", "i:12"}],
Cell[11526, 419, 152, 3, 38, "Output",
  CellTags->{"SpecialNullSpace", "i:12"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[11715, 427, 112, 3, 44, "Input",
  CellTags->{"SpecialNullSpace", "i:12"}],
Cell[11830, 432, 126, 3, 51, "Output",
  CellTags->{"SpecialNullSpace", "i:12"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[11993, 440, 119, 3, 44, "Input",
  CellTags->{"SpecialNullSpace", "i:12"}],
Cell[12115, 445, 119, 3, 38, "Output",
  CellTags->{"SpecialNullSpace", "i:12"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[12283, 454, 93, 1, 48, "Subsection",
  CellTags->{"Invariant Distributions", "i:8"}],

Cell[CellGroupData[{
Cell[12401, 459, 138, 3, 44, "Input",
  CellTags->{"Invariant Distributions", "i:8"}],
Cell[12542, 464, 391, 6, 137, "Print",
  CellTags->{"Invariant Distributions", "i:8"}]
}, Open  ]],
Cell[12948, 473, 282, 6, 104, "Input",
  CellTags->{"Invariant Distributions", "i:8"}],

Cell[CellGroupData[{
Cell[13255, 483, 125, 2, 44, "Input",
  CellTags->{"Invariant Distributions", "i:8"}],
Cell[13383, 487, 111, 2, 38, "Output",
  CellTags->{"Invariant Distributions", "i:8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[13531, 494, 139, 3, 44, "Input",
  CellTags->{"Invariant Distributions", "i:8"}],
Cell[13673, 499, 345, 5, 99, "Print",
  CellTags->{"Invariant Distributions", "i:8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[14055, 509, 96, 2, 44, "Input",
  CellTags->{"Invariant Distributions", "i:8"}],
Cell[14154, 513, 98, 2, 38, "Output",
  CellTags->{"Invariant Distributions", "i:8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[14289, 520, 128, 2, 44, "Input",
  CellTags->{"Invariant Distributions", "i:8"}],
Cell[14420, 524, 111, 2, 38, "Output",
  CellTags->{"Invariant Distributions", "i:8"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[14580, 532, 96, 1, 48, "Subsection",
  CellTags->{"Triangular Decomposition", "i:13"}],

Cell[CellGroupData[{
Cell[14701, 537, 136, 3, 44, "Input",
  CellTags->{"Triangular Decomposition", "i:13"}],
Cell[14840, 542, 749, 12, 194, "Print",
  CellTags->{"Triangular Decomposition", "i:13"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[15626, 559, 286, 6, 90, "Input",
  CellTags->{"Triangular Decomposition", "i:13"}],
Cell[15915, 567, 100, 2, 24, "Output",
  CellTags->{"Triangular Decomposition", "i:13"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[16052, 574, 137, 2, 30, "Input",
  CellTags->{"Triangular Decomposition", "i:13"}],
Cell[16192, 578, 113, 2, 24, "Output",
  CellTags->{"Triangular Decomposition", "i:13"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[16342, 585, 129, 2, 30, "Input",
  CellTags->{"Triangular Decomposition", "i:13"}],
Cell[16474, 589, 141, 2, 24, "Output",
  CellTags->{"Triangular Decomposition", "i:13"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[16652, 596, 156, 3, 30, "Input",
  CellTags->{"Triangular Decomposition", "i:13"}],
Cell[16811, 601, 206, 4, 24, "Output",
  CellTags->{"Triangular Decomposition", "i:13"}]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[17078, 612, 76, 1, 99, "Section",
  CellTags->"Complex Arrays"],

Cell[CellGroupData[{
Cell[17179, 617, 116, 3, 44, "Input",
  CellTags->{"Complex Arrays", "i:9"}],
Cell[17298, 622, 297, 5, 104, "Print",
  CellTags->{"Complex Arrays", "i:9"}]
}, Closed]],

Cell[CellGroupData[{
Cell[17632, 632, 116, 3, 39, "Input",
  CellTags->{"Complex Arrays", "i:10"}],
Cell[17751, 637, 391, 6, 104, "Print",
  CellTags->{"Complex Arrays", "i:10"}]
}, Closed]],

Cell[CellGroupData[{
Cell[18179, 648, 113, 3, 39, "Input",
  CellTags->{"Complex Arrays", "i:11"}],
Cell[18295, 653, 670, 10, 275, "Print",
  CellTags->{"Complex Arrays", "i:11"}]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

