(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    345364,      14214]*)
(*NotebookOutlinePosition[    365008,      14702]*)
(*  CellTagsIndexPosition[    364608,      14686]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Parametric Representation of Manifolds", "Title"],

Cell["Harry G. Kwatny", "Subtitle"],

Cell["\<\
Department of Mechanical Engineering & Mechanics
Drexel University\
\>", "Subsubtitle"],

Cell[BoxData[
    \(Off[General::spell]; \nOff[General::spell1]; \)], "Input",
  CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->"Introduction"],

Cell[TextData[{
  "Frequently in applications, important surfaces or manifolds are implicitly \
defined. It is sometimes useful to generate a parametric representation of \
these manifolds for graphing or other purposes. TSi ProPac contains functions \
useful for this purpose. The primary tools are the two functions:\n",
  StyleBox["ParametricManifold",
    FontFamily->"Courier New"],
  " and ",
  StyleBox["EquilibriumSurface\n",
    FontFamily->"Courier New"],
  StyleBox["These are are constructed using the functions\n",
    FontFamily->"Times New Roman"],
  StyleBox["ExpMap",
    FontFamily->"Courier New"],
  StyleBox[" and ",
    FontFamily->"Times New Roman"],
  StyleBox["FlowComposition",
    FontFamily->"Courier New"],
  StyleBox[
  ".\nWe will illustrate their use in the following sections. First, load the \
package:",
    FontFamily->"Times New Roman"]
}], "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< ProPac`\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Introduction"],

Cell[BoxData[
    \("\n ProPac has been successfully loaded. It contains packages\n for \
multibody dynamics, linear control and nonlinear control.\n Appropriate \
packages will be loaded automatically as required.\n Packages can be manually \
loaded by simply entering Dynamics,\n LinearControl or NonlinearControl as \
desired. Once a package is\n loaded, enter ?Dynamics, ?LinearControl or \
?NonlinearControl,\n respectively, to obtain a list of available \
functions."\)], "Print",
  CellTags->"Introduction"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Simple Examples", "Section"],

Cell[CellGroupData[{

Cell["Implicit and Parametric Representation of the Circle", "Subsection",
  CellTags->{"Implicit", "i:1"}],

Cell[TextData[{
  "The unit circle in a plane can be defined by the implicit relation \
f(x,y)=",
  Cell[BoxData[
      \(TraditionalForm\`x\^2\)]],
  "+",
  Cell[BoxData[
      \(TraditionalForm\`y\^2\)]],
  "-1=0. The circle can also be characterized parametrically by the mapping \
theta->{x,y} defined by  x=Cos[theta], y=Sin[theta]. Unfortunately, it is \
rarely possible to find a global parametric representation of a given \
implicit manifold. In such a case it is often possible to obtain a local \
representation. The function ParametricManifold does that. Define:"
}], "Text",
  TextJustification->1,
  CellTags->{"Implicit", "i:1"}],

Cell[BoxData[{
    \(\(f1 = {\((x^2 + y^2 - 1)\)};\)\), "\n", 
    \(\(var1 = {x, y};\)\)}], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"Implicit", "i:1"}],

Cell["\<\
Now, we find a local 6th order representation around the point x=1,y=0:\
\>", "Text",
  CellTags->{"Implicit", "i:1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Circ = ParametricManifold[f1, var1, {1, 0}, 6]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"Implicit", "i:1"}],

Cell[BoxData[
    \("1 vector fields computed."\)], "Print",
  CellTags->{"Implicit", "i:1"}],

Cell[BoxData[
    \("1 flow functions computed."\)], "Print",
  CellTags->{"Implicit", "i:1"}],

Cell[BoxData[
    \({{1 - k1\^2\/2 + k1\^4\/24 - k1\^6\/720, 
        k1 - k1\^3\/6 + k1\^5\/120}, {k1}}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"Implicit", "i:1"}]
}, Open  ]],

Cell[BoxData[
    \(\(Cir[k1_] := Circ[\([1]\)];\)\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"Implicit", "i:1"}],

Cell["and a 10th order representation:", "Text",
  CellTags->{"Implicit", "i:1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Circ1 = ParametricManifold[f1, var1, {1, 0}, 10]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->{"Implicit", "i:1"}],

Cell[BoxData[
    \("1 vector fields computed."\)], "Print",
  CellTags->{"Implicit", "i:1"}],

Cell[BoxData[
    \("1 flow functions computed."\)], "Print",
  CellTags->{"Implicit", "i:1"}],

Cell[BoxData[
    \({{1 - k1\^2\/2 + k1\^4\/24 - k1\^6\/720 + k1\^8\/40320 - 
          k1\^10\/3628800, 
        k1 - k1\^3\/6 + k1\^5\/120 - k1\^7\/5040 + 
          k1\^9\/362880}, {k1}}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->{"Implicit", "i:1"}]
}, Open  ]],

Cell["We can graph these representations of the circle.", "Text",
  CellTags->{"Implicit", "i:1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot[{{Cos[k1], Sin[k1]}, Circ[\([1]\)], 
        Circ1[\([1]\)]}, {k1, \(-Pi\), Pi}, 
      PlotStyle\  -> \n\ \ \ \ \ {{RGBColor[1, \ 0, \ 0], 
            Thickness[0.008]}, {\ RGBColor[0, \ 1, \ 0]}, {\ 
            RGBColor[0, \ 0, \ 1]}}]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->{"Implicit", "i:1"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.545513 0.430678 0.309017 0.292914 [
[.11483 .29652 -6 -9 ]
[.11483 .29652 6 0 ]
[.33017 .29652 -12 -9 ]
[.33017 .29652 12 0 ]
[.76085 .29652 -9 -9 ]
[.76085 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.53301 .0161 -12 -4.5 ]
[.53301 .0161 0 4.5 ]
[.53301 .16256 -24 -4.5 ]
[.53301 .16256 0 4.5 ]
[.53301 .45547 -18 -4.5 ]
[.53301 .45547 0 4.5 ]
[.53301 .60193 -6 -4.5 ]
[.53301 .60193 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.11483 .30902 m
.11483 .31527 L
s
[(-1)] .11483 .29652 0 1 Mshowa
.33017 .30902 m
.33017 .31527 L
s
[(-0.5)] .33017 .29652 0 1 Mshowa
.76085 .30902 m
.76085 .31527 L
s
[(0.5)] .76085 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.1579 .30902 m
.1579 .31277 L
s
.20097 .30902 m
.20097 .31277 L
s
.24404 .30902 m
.24404 .31277 L
s
.28711 .30902 m
.28711 .31277 L
s
.37324 .30902 m
.37324 .31277 L
s
.41631 .30902 m
.41631 .31277 L
s
.45938 .30902 m
.45938 .31277 L
s
.50244 .30902 m
.50244 .31277 L
s
.58858 .30902 m
.58858 .31277 L
s
.63165 .30902 m
.63165 .31277 L
s
.67472 .30902 m
.67472 .31277 L
s
.71778 .30902 m
.71778 .31277 L
s
.80392 .30902 m
.80392 .31277 L
s
.84699 .30902 m
.84699 .31277 L
s
.89005 .30902 m
.89005 .31277 L
s
.93312 .30902 m
.93312 .31277 L
s
.07177 .30902 m
.07177 .31277 L
s
.0287 .30902 m
.0287 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.54551 .0161 m
.55176 .0161 L
s
[(-1)] .53301 .0161 1 0 Mshowa
.54551 .16256 m
.55176 .16256 L
s
[(-0.5)] .53301 .16256 1 0 Mshowa
.54551 .45547 m
.55176 .45547 L
s
[(0.5)] .53301 .45547 1 0 Mshowa
.54551 .60193 m
.55176 .60193 L
s
[(1)] .53301 .60193 1 0 Mshowa
.125 Mabswid
.54551 .04539 m
.54926 .04539 L
s
.54551 .07469 m
.54926 .07469 L
s
.54551 .10398 m
.54926 .10398 L
s
.54551 .13327 m
.54926 .13327 L
s
.54551 .19185 m
.54926 .19185 L
s
.54551 .22114 m
.54926 .22114 L
s
.54551 .25043 m
.54926 .25043 L
s
.54551 .27973 m
.54926 .27973 L
s
.54551 .33831 m
.54926 .33831 L
s
.54551 .3676 m
.54926 .3676 L
s
.54551 .39689 m
.54926 .39689 L
s
.54551 .42618 m
.54926 .42618 L
s
.54551 .48477 m
.54926 .48477 L
s
.54551 .51406 m
.54926 .51406 L
s
.54551 .54335 m
.54926 .54335 L
s
.54551 .57264 m
.54926 .57264 L
s
.25 Mabswid
.54551 0 m
.54551 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.008 w
.11483 .30902 m
.11485 .30675 L
.11488 .30468 L
.11495 .30229 L
.11504 .30004 L
.11526 .29603 L
.11559 .29168 L
.11606 .2869 L
.11669 .28183 L
.11815 .27277 L
.12008 .26344 L
.12229 .25475 L
.12875 .23516 L
.13736 .21554 L
.14698 .19798 L
.17455 .16021 L
.20478 .12986 L
.24387 .09995 L
.28619 .07515 L
.33609 .05306 L
.36209 .044 L
.39116 .03556 L
.41696 .02946 L
.44587 .02405 L
.45968 .02198 L
.47459 .0201 L
.48754 .01877 L
.50169 .01762 L
.51001 .0171 L
.51771 .01671 L
.52508 .01643 L
.52881 .01632 L
.53292 .01623 L
.53662 .01617 L
.54001 .01613 L
.54373 .01611 L
.5456 .0161 L
.54764 .01611 L
.55111 .01613 L
.5548 .01617 L
.55829 .01623 L
.56146 .0163 L
.56802 .0165 L
.57522 .0168 L
.58975 .01765 L
.60316 .01874 L
.61566 .02001 L
.6436 .0238 L
.67312 .02926 L
.70031 .03568 L
Mistroke
.72915 .04407 L
.77905 .06291 L
.82401 .08558 L
.86668 .11386 L
.90394 .14663 L
.93247 .18043 L
.94387 .19768 L
.95409 .21639 L
.96194 .2343 L
.96762 .25088 L
.97215 .26898 L
.97392 .27901 L
.97457 .28363 L
.97514 .28853 L
.97552 .29272 L
.97569 .29495 L
.97585 .29735 L
.97597 .29955 L
.97605 .30156 L
.97611 .30348 L
.97616 .30551 L
.97619 .30772 L
.97619 .31008 L
.97616 .31231 L
.97612 .31433 L
.97604 .31671 L
.97593 .31929 L
.97563 .32396 L
.97523 .32853 L
.97469 .33342 L
.97341 .34224 L
.97138 .35268 L
.96904 .36216 L
.9624 .38254 L
.95415 .40153 L
.93284 .43709 L
.90717 .46807 L
.87575 .49704 L
.83526 .52573 L
.7924 .54902 L
.74169 .56978 L
.68949 .58508 L
.66223 .59097 L
.64666 .59374 L
.63181 .59599 L
.61807 .59775 L
.60307 .5993 L
.58939 .60041 L
.57671 .60116 L
.56963 .60147 L
Mistroke
.56298 .60169 L
.55918 .60178 L
.55569 .60185 L
.55377 .60188 L
.55167 .6019 L
.54969 .60192 L
.54785 .60193 L
.54593 .60193 L
.54385 .60193 L
.54188 .60192 L
.54008 .60191 L
.53665 .60187 L
.53303 .60181 L
.52914 .60172 L
.52551 .60162 L
.51726 .6013 L
.50988 .60093 L
.50307 .60051 L
.48769 .59928 L
.47419 .59789 L
.45994 .59609 L
.43553 .59222 L
.40902 .58683 L
.3581 .57274 L
.30667 .55276 L
.26148 .5292 L
.2193 .50026 L
.18552 .4698 L
.15958 .43902 L
.14724 .42048 L
.13735 .40249 L
.12989 .38579 L
.1236 .36782 L
.1198 .35338 L
.11812 .34512 L
.11686 .33737 L
.11597 .33024 L
.11538 .32371 L
.11514 .32011 L
.11505 .3182 L
.11496 .31618 L
.1149 .31423 L
.11486 .31246 L
.11484 .31069 L
.11483 .30902 L
Mfstroke
0 1 0 r
.5 Mabswid
.02381 .15552 m
.02715 .15599 L
.02898 .1562 L
.03071 .15636 L
.03232 .15648 L
.03406 .15657 L
.03565 .15663 L
.03711 .15667 L
.03884 .15667 L
.04047 .15665 L
.04225 .1566 L
.04417 .15651 L
.04617 .15637 L
.04808 .15621 L
.05166 .15581 L
.05521 .1553 L
.059 .15464 L
.06586 .15316 L
.08173 .14851 L
.11761 .13381 L
.15328 .11668 L
.23542 .07849 L
.32809 .04518 L
.38047 .03175 L
.40775 .0263 L
.43825 .02145 L
.45291 .01958 L
.46689 .01809 L
.47965 .01696 L
.49325 .016 L
.50028 .01561 L
.50806 .01526 L
.51514 .01502 L
.51831 .01493 L
.52179 .01485 L
.52559 .01479 L
.52766 .01476 L
.52959 .01474 L
.53306 .01472 L
.53675 .01472 L
.53884 .01472 L
.5411 .01473 L
.54324 .01475 L
.54521 .01478 L
.54894 .01484 L
.55289 .01493 L
.5601 .01514 L
.56694 .01542 L
.57976 .01612 L
.59352 .01715 L
Mistroke
.60845 .0186 L
.63507 .02203 L
.65943 .02619 L
.68819 .03241 L
.7146 .03946 L
.76188 .05568 L
.80926 .07743 L
.84873 .10099 L
.88434 .1282 L
.91735 .16123 L
.94221 .19498 L
.95328 .21476 L
.96151 .2332 L
.96792 .2519 L
.97223 .2694 L
.97386 .2786 L
.97461 .28391 L
.97516 .28877 L
.97562 .2939 L
.9758 .29659 L
.97596 .29942 L
.97606 .3019 L
.97613 .3042 L
.97618 .30673 L
.97619 .30814 L
.97619 .30942 L
.97617 .31174 L
.97613 .3139 L
.97606 .31628 L
.97595 .31882 L
.9758 .32149 L
.97563 .32401 L
.97521 .32875 L
.97419 .33725 L
.97266 .34647 L
.9705 .35648 L
.96765 .36707 L
.9611 .38588 L
.95334 .40316 L
.94322 .42141 L
.92047 .45312 L
.8893 .48545 L
.85 .51618 L
.80792 .54131 L
.76472 .56122 L
.73851 .57098 L
.71289 .57907 L
.66307 .59114 L
.63628 .59582 L
.62145 .5979 L
Mistroke
.60747 .59954 L
.59452 .6008 L
.58263 .60172 L
.56939 .6025 L
.56207 .60282 L
.55512 .60305 L
.55156 .60314 L
.54772 .60322 L
.54409 .60327 L
.54075 .6033 L
.53773 .60332 L
.53442 .60332 L
.53096 .6033 L
.52773 .60327 L
.52592 .60325 L
.52394 .60322 L
.52036 .60315 L
.51365 .60297 L
.50582 .60268 L
.49858 .60233 L
.48653 .60159 L
.47327 .60054 L
.44661 .59768 L
.41851 .59359 L
.39316 .58895 L
.33779 .57564 L
.29015 .56068 L
.24144 .54207 L
.15734 .50335 L
.12352 .48697 L
.08995 .47248 L
.08147 .46944 L
.07265 .46667 L
.06461 .46458 L
.05718 .46306 L
.05364 .46249 L
.05029 .46206 L
.04844 .46186 L
.04643 .46168 L
.04461 .46155 L
.04292 .46146 L
.04194 .46142 L
.04088 .46139 L
.03896 .46136 L
.03708 .46137 L
.03536 .46141 L
.0335 .46149 L
.03244 .46155 L
.03145 .46162 L
.02928 .46181 L
Mistroke
.02731 .46202 L
.02381 .46252 L
Mfstroke
0 0 1 r
.11405 .30699 m
.11408 .30477 L
.11414 .30275 L
.11423 .30042 L
.11434 .29822 L
.11459 .29429 L
.11496 .29003 L
.11614 .28037 L
.11766 .27146 L
.12201 .25336 L
.12846 .23435 L
.13692 .21537 L
.14655 .19794 L
.17446 .15995 L
.20694 .12779 L
.24195 .10113 L
.28251 .07701 L
.33145 .05482 L
.38162 .03813 L
.41093 .03076 L
.43812 .02535 L
.46592 .02115 L
.47927 .01959 L
.4918 .01839 L
.50543 .01737 L
.51267 .01695 L
.52044 .0166 L
.52435 .01646 L
.5286 .01633 L
.53261 .01623 L
.53633 .01617 L
.53967 .01613 L
.54335 .01611 L
.54521 .0161 L
.5472 .0161 L
.55082 .01612 L
.55439 .01616 L
.55763 .01622 L
.56137 .0163 L
.5649 .0164 L
.57118 .01662 L
.57798 .01694 L
.59339 .01792 L
.60754 .01916 L
.6362 .02267 L
.66608 .02781 L
.69157 .03346 L
.71832 .04072 L
.7646 .05684 L
.8141 .08004 L
Mistroke
.85626 .10621 L
.89253 .13553 L
.92086 .16539 L
.9347 .18357 L
.94597 .20124 L
.95457 .21737 L
.96237 .23542 L
.96849 .25387 L
.97109 .26405 L
.97303 .27359 L
.97443 .28257 L
.97535 .29076 L
.97572 .29531 L
.97588 .29787 L
.976 .30024 L
.97608 .30232 L
.97614 .3046 L
.97618 .30699 L
.97619 .30922 L
.97618 .31151 L
.97613 .31394 L
.97606 .31624 L
.97597 .31832 L
.97584 .32078 L
.97567 .32344 L
.97526 .32826 L
.97471 .33331 L
.97398 .33865 L
.97232 .34818 L
.96825 .36501 L
.96212 .38327 L
.95385 .40213 L
.94469 .41898 L
.91867 .45526 L
.88876 .48594 L
.85004 .51614 L
.80789 .5413 L
.75821 .56372 L
.73471 .57215 L
.70855 .58013 L
.65943 .5915 L
.63304 .59582 L
.61774 .59778 L
.60375 .59924 L
.58886 .60044 L
.58065 .60096 L
.57288 .60134 L
.56568 .60161 L
.56225 .60171 L
.55904 .60179 L
Mistroke
.55556 .60185 L
.55372 .60188 L
.55174 .6019 L
.54967 .60192 L
.5477 .60193 L
.544 .60193 L
.54046 .60191 L
.53847 .60189 L
.53664 .60187 L
.53326 .60181 L
.5297 .60174 L
.52353 .60155 L
.51676 .60128 L
.50952 .60091 L
.50178 .60042 L
.48786 .5993 L
.4609 .59623 L
.43662 .59242 L
.40959 .58697 L
.38512 .58087 L
.33203 .56344 L
.28767 .54368 L
.24328 .51779 L
.20663 .48997 L
.17332 .45677 L
.14789 .42229 L
.1377 .40421 L
.12859 .38402 L
.12231 .3657 L
.11812 .34891 L
.11643 .33957 L
.11572 .33464 L
.11511 .32943 L
.11468 .32487 L
.1145 .32245 L
.11434 .31986 L
.11422 .31748 L
.11414 .3153 L
.11408 .31312 L
.11405 .31105 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[7]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00OW7oo00<007ooOol0
PGoo002LOol00`00Oomoo`21Ool009=oo`D000Aoo`03001oogoo085oo`00UGoo00<007ooOol017oo
00<007ooOol0PGoo0028Ool;0n0E01l40n1dOol0081oo`P3h0/07aEl00X07`Ml06Moo`00NWoo1P?P
0W`01P0O27`01Goo00<007ooOol017oo00<007ooOol02Goo2W`01`0O00<3h7ooOol0I7oo001dOol6
0n0801l2O00@Ool20006Ool00`00Oomoo`0HOol2O00401l20n03O01NOol0071oo`@3h0H07`Al01io
o`03001oogoo01]oo`=l00H07eeoo`00Jgoo1@?P100O17`097oo00<007ooOol08Goo0g`01@0O00=l
07ooOol0EGoo001VOol50n000goo01l07`0201l5O00WOol00`00Oomoo`0TOol4O0000`?P01l07`02
01mDOol0065oo`D3h003Ooml07`000<07`El02]oo`03001oogoo02Qoo`Al00030n007`0O00807`9l
04ioo`00GGoo10?P1Goo00=l000O01l01G`0;Woo00<007ooOol0:goo17`00P?P0P0O00=l07ooOol0
Bgoo001JOol30n06Ool017`001l07`0O0W`0<goo0P00<Woo00=l00?P01l00P0OBgoo001HOol20n05
Ool2O00301l3O00eOol00`00Oomoo`0cOol00g`00n03h00301m8Ool005Eoo`<3h0Ioo`03O0007`0O
00=l03Qoo`03001oogoo03Eoo`9l0083h0807dIoo`00DWoo0`?P1goo00=l000O01l00W`0>goo00<0
07ooOol0>7oo0W`000@3h00O01l07d=oo`00D7oo0P?P1goo0W`00P0O0W`0?Goo00<007ooOol0>Woo
0g`000@3h00O01ml041oo`00CGoo0`?P1goo0W`00P0O0W`0?goo00<007ooOol0?Goo0W`000<3h00O
01l0?goo001:Ool30n07Ool3O00201l00g`0Oomoo`10Ool00`00Oomoo`0oOol2O00010?P01l07`0O
?7oo0018Ool20n07Ool4O00201l00g`0Oomoo`12Ool00`00Oomoo`11Ool3O0000`?P01l07`0jOol0
04Eoo`<3h0Moo`Al00807dMoo`8004Aoo`=l00030n007`0O03Qoo`00@Woo0`?P27oo17`00P0OBGoo
00<007ooOol0AGoo0g`000<3h00O01l0=Woo0010Ool20n0:Ool3O00201m;Ool00`00Oomoo`18Ool2
O00010?P01l07g`0<goo000nOol20n0:Ool3O00201m=Ool00`00Oomoo`1:Ool2O0000`?P01ml000b
Ool003aoo`83h0]oo`=l000301moogoo04eoo`03001oogoo04eoo`04O0007`0OO00`Ool003Yoo`83
h0]oo`=l00807e1oo`03001oogoo04ioo`9l000301l3h7oo02ioo`00>7oo0P?P2goo0g`00P0ODWoo
00<007ooOol0D7oo00Al000O01l3h2eoo`00=Woo0P?P37oo0W`00P0OE7oo00<007ooOol0DGoo0W`0
00<07`?POol0:goo000dOol20n0=Ool2O0000`0OOomoo`1DOol2001COol2O00201l[Ool0039oo`83
h0eoo`9l00807eMoo`03001oogoo05Aoo`9l000301l3h7oo02Qoo`00<7oo0P?P3Woo0W`000<07g`0
Ool0Egoo00<007ooOol0EGoo0W`000<07`?PO0009goo000^Ool20n0?Ool2O0000`0OOomoo`1HOol0
0`00Oomoo`1FOol2O00201l00g`0Oomoo`0TOol002aoo`83h11oo`03O0007`0O05]oo`03001oogoo
05Qoo`9l000301ml07oo02Aoo`00:Woo0P?P4Goo00=l000OO000G7oo00<007ooOol0FWoo00=l000O
0n0097oo000XOol20n0AOol017`001l07g`0GGoo00<007ooOol0Fgoo00=l000O0n008goo000VOol2
0n0AOol2O0000`0OO01l001NOol00`00Oomoo`1LOol00g`001l07`0ROol002Aoo`83h19oo`9l0003
01ml07oo05moo`03001oogoo05eoo`9l000301moogoo01moo`008Goo0`?P4goo0W`000<07g`0Ool0
H7oo0P00Ggoo0W`000<07gooOol07Woo000NOol30n0EOol2O0000`0OOomoo`1QOol00`00Oomoo`1O
Ool2O0000`0OOomoo`0MOol001aoo`83h1Qoo`03O0007goo06=oo`03001oogoo061oo`9l000301mo
ogoo01aoo`006Goo0`?P6Goo00=l000OOol0I7oo00<007ooOol0HGoo0W`000<07g`0Ool06goo000F
Ool30n0KOol00g`001ml001UOol00`00Oomoo`1ROol017`00n007g`06goo000COol30n0MOol00g`0
01ml001VOol00`00Oomoo`1SOol00g`001ml000KOol000Moo``3h1moo`03O0007g`005Ioo`03001o
ogoo009oo`03001oogoo009oo`03001oogoo00Aoo`03001oogoo06Eoo`0301ml07oo01Uoo`00<Goo
00=l000OO000EWoo00<007oo00001goo00<007oo00001Goo00<007ooOol0IGoo00=l000OO0006Goo
000aOol00`0OO01oo`1AOol30002Ool00`00Ool00009Ool00`00Oomoo`03Ool3001VOol00g`001ml
000HOol0031oo`03O0007goo05Moo`03001oo`0000Moo`8000Ioo`03001oogoo06Moo`03O0007g`0
01Moo`00;goo00=l000OOol0F7oo00<007oo00001goo00<007ooOol01Goo00<007ooOol0J7oo00=l
000OO0005Woo000^Ool00g`001moo`1JOol00`00Oomoo`06Ool30005Ool00`00Oomoo`1YOol00g`0
01moo`0EOol002ioo`0301moogoo06]oo`03001oogoo06Yoo`0301l3h7oo01Aoo`00;Goo00=l000O
Ool0K7oo00<007ooOol0JWoo00=l000OO00057oo000/Ool00g`001moo`1]Ool00`00Oomoo`1[Ool0
0g`001moo`0COol002]oo`03O0007goo06ioo`03001oogoo06aoo`03O0007goo019oo`00:goo00<0
7gooOol0KWoo0P00KWoo00=l000OOol04Goo000ZOol00g`001moo`1_Ool00`00Oomoo`1^Ool00`0O
0n1oo`0@Ool002Uoo`03O0007goo071oo`03001oogoo06ioo`03O0007`?P011oo`00:Goo00<07goo
Ool0L7oo00<007ooOol0Kgoo00=l000OOol03goo000XOol00g`001moo`1aOol00`00Oomoo`1_Ool0
0g`001l3h00?Ool002Moo`03O0007goo079oo`03001oogoo071oo`03O0007goo00ioo`009goo00=l
000OOol0LWoo00<007ooOol0L7oo00=l000O0n003Woo000VOol00g`001moo`1cOol00`00Oomoo`1a
Ool00g`001moo`0=Ool002Eoo`9l000301moogoo079oo`03001oogoo075oo`03O0007goo00eoo`00
9Goo00=l000OOol0M7oo0P00LWoo00=l000O0n003Goo000UOol00g`001moo`1dOol00`00Oomoo`1b
Ool00g`001moo`0<Ool002Eoo`03O0007goo07Aoo`03001oogoo079oo`03O0007`?P00aoo`0097oo
00=l000OO000MGoo00<007ooOol0LWoo0W`000<07gooOol02Woo000TOol00g`001moo`1eOol00`00
Oomoo`1cOol00g`001moo`0;Ool002=oo`9l000301moogoo07Aoo`03001oogoo07Aoo`0301l3h7oo
00Yoo`008goo00=l000OOol0MWoo00<007ooOol0M7oo00=l000OOol02Woo000SOol00g`001moo`1f
Ool00`00Oomoo`1eOol00`0OOomoo`09Ool0029oo`03O0007g`007Moo`8007Ioo`03O0007goo00Uo
o`008Woo00=l000OOol0Mgoo00<007ooOol0MGoo00=l000OOol02Goo000ROol00g`001moo`1gOol0
0`00Oomoo`1eOol00g`001moo`09Ool0025oo`9l000301moogoo07Ioo`03001oogoo07Ioo`030n00
7goo00Qoo`008Goo00=l000OOol0N7oo00<007ooOol0MWoo00=l000OOol027oo000QOol00g`001l0
0002000eOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0dOol00`00Oomoo`0eOol00`00
Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0dOol00g`001l000020006Ool0025oo`03O0007`00
03Ioo`03001oo`0000Moo`03001oo`0003Eoo`03001oogoo03Aoo`03001oo`0000Moo`03001oo`00
03Eoo`03O0007`0000Qoo`007Goo0`0000Aoog`001l0035oo`<0009oo`03001oo`0000Uoo`03001o
ogoo03=oo`03001oogoo03Aoo`03001oo`0000Uoo`03001oogoo03=oo`03O0007`?P00Qoo`008Goo
00<07g`00000=Woo00<007oo00001goo0P00=Woo00<007ooOol0=7oo00<007oo00001goo0P00=goo
00=l000OOol01goo000POol017`001moo`00=Woo00<007oo00001goo00<007ooOol0=Goo0P00=Goo
00<007oo00001goo00<007ooOol0=Woo00=l000OOol01goo000POol017`001l00000=goo00<007oo
Ool01Woo0`00=Goo00<007ooOol0=Goo00<007ooOol01Woo0`00=Woo00=l000OOol01goo000POol0
0g`001moo`1iOol00`00Oomoo`1gOol00g`001moo`07Ool0021oo`03O0007goo07Uoo`03001oogoo
07Moo`03O0007goo00Moo`0087oo00=l000OOol0NGoo00<007ooOol0Mgoo00=l000OOol01goo000P
Ool00g`001moo`1iOol00`00Oomoo`1gOol00g`001moo`07Ool0021oo`03O0007goo07Uoo`03001o
ogoo07Moo`03O0007goo00Moo`0087oo00=l000OOol0NGoo00<007ooOol0Mgoo00=l000OOol01goo
000P0002O03d00000g`001l000060001Ool000Qoo`03001oogoo00Uoo`03001oogoo00Uoo`03O000
7goo00Yoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Uoo`03001o
ogoo00Yoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uoo`03001o
ogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Uoo`03001oogoo00Yoo`03001o
ogoo00Uoo`03001oogoo00Uoo`03001oogoo00Yoo`03001oogoo00Uoo`03001oogoo00Qoo`03O000
7goo00Moo`0087oo00=l000OOol0>goo00<007ooOol0>goo00<007ooOol0>goo00<007ooOol0>Goo
00=l000OOol01goo000POol00g`001moo`1iOol00`00Oomoo`1gOol00g`001moo`07Ool0021oo`03
O0007goo07Uoo`03001oogoo07Moo`03O0007goo00Moo`0087oo00=l000OOol0NGoo00<007ooOol0
Mgoo00=l000OOol01goo000POol00g`001moo`1iOol00`00Oomoo`1gOol00g`001moo`07Ool0021o
o`03O0007goo07Uoo`03001oogoo07Moo`03O0007goo00Moo`0087oo00=l000OOol0NGoo0P00N7oo
00=l000OOol01goo000POol00g`001moo`1iOol00`00Oomoo`1gOol00g`001moo`07Ool0025oo`03
O0007goo07Qoo`03001oogoo07Moo`0301ml07oo00Moo`008Goo00=l000OOol0N7oo00<007ooOol0
Mgoo00<07g`0Ool01goo000QOol00g`001moo`1hOol00`00Oomoo`1fOol00g`001ml0008Ool0025o
o`03O0007goo07Qoo`03001oogoo07Ioo`03O0007goo00Qoo`008Goo0W`000<07gooOol0MWoo00<0
07ooOol0MWoo00<07`?POol027oo000ROol00g`001moo`1gOol00`00Oomoo`1eOol00g`001l3h009
Ool0029oo`03O0007goo07Moo`03001oogoo07Aoo`9l000301moogoo00Qoo`008Woo00=l000OOol0
Mgoo0P00MGoo0W`000<07gooOol027oo000ROol2O0000`0OOomoo`1eOol00`00Oomoo`1dOol00g`0
01l3h00:Ool002=oo`03O0007goo07Ioo`03001oogoo07Aoo`03O0007goo00Yoo`008goo00=l000O
Ool0MWoo00<007ooOol0Lgoo00=l000O0n002goo000SOol2O0000`0OOomoo`1dOol00`00Oomoo`1c
Ool00g`001moo`0;Ool002Aoo`03O0007goo07Eoo`03001oogoo079oo`9l000301moogoo00Yoo`00
97oo00=l000OO000MGoo00<007ooOol0LWoo00=l000O0n0037oo000UOol00g`001moo`1dOol00`00
Oomoo`1bOol00g`001moo`0<Ool002Eoo`03O0007goo07Aoo`8007=oo`03O0007goo00aoo`009Goo
0W`000<07gooOol0LWoo00<007ooOol0LGoo00=l000OO0003Goo000VOol00g`001moo`1cOol00`00
Oomoo`1aOol00g`001moo`0=Ool002Moo`03O0007goo079oo`03001oogoo075oo`0301moogoo00eo
o`009goo00=l000OOol0LWoo00<007ooOol0L7oo00=l000OOol03Woo000XOol00g`001moo`1aOol0
0`00Oomoo`1_Ool00g`001moo`0?Ool002Uoo`0301ml07oo071oo`03001oogoo06moo`03O0007goo
00moo`00:Goo00=l000OOol0L7oo00<007ooOol0KWoo00=l000OOol047oo000ZOol00g`001moo`1_
Ool00`00Oomoo`1^Ool00`0OOomoo`0@Ool002Yoo`03O0007g`006moo`8006ioo`030n007goo015o
o`00:goo00=l000OO000KWoo00<007ooOol0K7oo00=l000OOol04Woo000/Ool00g`001moo`1]Ool0
0`00Oomoo`1/Ool00`0OOomoo`0BOol002eoo`03O0007goo06aoo`03001oogoo06]oo`0301ml07oo
01=oo`00;Goo00=l000OO000K7oo00<007ooOol0JWoo00<3h00OOol057oo000_Ool00`0OOomoo`1Z
Ool00`00Oomoo`1ZOol00`0OOomoo`0DOol002moo`03O0007goo05Uoo`03001oogoo009oo`03001o
ogoo009oo`03001oogoo00Aoo`03001oogoo06Uoo`0301ml07oo01Eoo`00<7oo00<07g`0Ool0Egoo
00<007oo00001goo00<007oo00001Goo00<007ooOol0J7oo00<3h00OOol05Woo000aOol00`0OO01o
o`1FOol00`00Ool00009Ool00`00Oomoo`03Ool3001WOol00`?P01moo`0GOol0039oo`0301ml07oo
05Eoo`03001oo`0000Moo`8000Ioo`03001oogoo06Ioo`030n007goo01Qoo`001goo2P?P8Woo00<0
7gooOol0E7oo00<007oo00001goo00<007ooOol01Goo00<007ooOol0IGoo00<3h00OOol06Goo000A
Ool50n0MOol00g`001ml001EOol00`00Oomoo`06Ool30005Ool00`00Oomoo`1TOol00`?P01ml000J
Ool001Ioo`<3h1]oo`03O0007g`006Eoo`03001oogoo06=oo`030n007g`001]oo`006Goo0`?P6Goo
00=l000OO000I7oo00<007ooOol0HWoo00=l000OO00077oo000LOol20n0HOol00g`001ml001SOol0
0`00Oomoo`1QOol00g`001ml000MOol001ioo`83h1Moo`03O0007g`0069oo`03001oogoo061oo`03
O0007g`001ioo`0087oo0P?P5Woo00=l000OO000HGoo0P00H7oo00=l000OO0007goo000ROol20n0E
Ool00g`001ml001POol00`00Oomoo`1NOol00g`001ml000POol002Aoo`83h1Aoo`03O0007g`005mo
o`03001oogoo05eoo`807`03O01oogoo01moo`009Woo0P?P4goo00=l000O01l0GWoo00<007ooOol0
Fgoo00Al000OO01l029oo`00:7oo0P?P4Woo0W`000<07g`0Ool0Fgoo00<007ooOol0FWoo00Al000O
O01l02=oo`00:Woo0P?P4Goo0W`000<07g`0Ool0FWoo00<007ooOol0F7oo00=l000O01l00W`097oo
000/Ool30n0?Ool2O00201l00g`0Oomoo`1GOol00`00Oomoo`1GOol017`001ml07`09Woo000_Ool2
0n0?Ool2O0000`0OO01oo`1GOol00`00Oomoo`1FOol00g`001ml000XOol0035oo`83h0moo`03O000
7g`005Moo`03001oogoo05Aoo`04O0007`0OO00YOol003=oo`83h0ioo`04O0007`0OO01EOol2001D
Ool017`001ml07`0:Woo000eOol20n0=Ool2O0000`0OO01oo`1COol00`00Oomoo`1BOol201l00g`0
Oomoo`0ZOol003Moo`83h0eoo`03O0007`0O05=oo`03001oogoo04moo`9l000301ml07`002eoo`00
>Goo0`?P2goo0W`00P0O00=l07ooOol0CWoo00<007ooOol0CGoo0W`00P0O0W`0;Woo000lOol20n0:
Ool3O0000`0OO01l001>Ool00`00Oomoo`1;Ool3O0000`0OO01l000`Ool003ioo`83h0Yoo`9l0080
7`9l04aoo`03001oogoo04Yoo`9l00807c=oo`00@7oo0P?P2goo00=l000O01l00W`0BWoo00<007oo
Ool0B7oo0g`000<07gooOol0<goo0012Ool20n0;Ool017`001l07g`0BGoo00<007ooOol0Agoo0W`0
0P0O=Woo0014Ool30n0:Ool017`001l07g`0Agoo0P00AWoo0W`00P0O>7oo0017Ool30n08Ool2O002
01l00g`0Oomoo`13Ool00`00Oomoo`13Ool2O00201l00g`0Oomoo`0gOol004Yoo`83h0Qoo`9l0080
7`03O01oogoo045oo`03001oogoo049oo`04O0007`0OO00kOol004aoo`<3h0Moo`9l00807d9oo`03
001oogoo03moo`04O0007`0O01l2O00lOol004moo`<3h0Eoo`=l00807d1oo`03001oogoo03eoo`03
O0007`0O00=l03ioo`00DWoo0`?P17oo0g`00P0O00=l07ooOol0>goo00<007ooOol0>Woo00Al00?P
01l07`9l045oo`00EGoo10?P0Woo0g`00`0O>goo00<007ooOol0=goo0W`00`0O0W`0@goo001IOol3
0n02Ool3O00301lhOol00`00Oomoo`0dOol00g`001l07`0201l2O016Ool005aoo`@3h0Al00<07cEo
o`03001oogoo039oo`<07`030n1l07`004Uoo`00H7oo0`?P17`00`0O<Woo0P00<7oo00@3h00O01l3
h0=l04]oo`00Hgoo10?P0g`00`0O;goo00<007ooOol0:goo00=l00?P0n000P0O0g`0CWoo001WOol4
0n02O00301l/Ool00`00Oomoo`0UOol3O0020n0401l00g`0Oomoo`1@Ool006]oo`@3h003O0007`0O
00807`9l02Ioo`03001oogoo02Aoo`03O003h00O00<07`03O01oogoo05Aoo`00Kgoo0`?P0W`01@0O
1G`07Woo00<007ooOol07Goo17`01@0O00=l07ooOol0F7oo001bOol40n03O00801l4O00GOol00`00
Oomoo`0IOol2O00601l3O01MOol007Ioo`H3h0El00L07`03O01oogoo00Qoo`D000Aoo`03001oogoo
015oo`Al00H07`040n1l07`0O01ROol007aoo``3h0T07`9l009oo`03001oogoo00Aoo`03001oogoo
00Eoo`Al00`07`030n1l07`000=l06Ioo`00Qgoo0W`020?P5`0O1@?P1G`0KWoo002AOolEO01jOol0
09Eoo`03001oogoo00Aoo`03001oogoo085oo`00U7oo0P001Woo00<007ooOol0PGoo002LOol00`00
Oomoo`21Ool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.26952, -1.05499, \
0.00811038, 0.0119249}},
  CellTags->{"Implicit", "i:1"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]=",
  CellTags->{"Implicit", "i:1"}]
}, Open  ]],

Cell["\<\
Notice how the 6th order approximation deteriorates away from the nominal \
point. The 10th order approximation is quite good. \
\>", "Text",
  CellTags->{"Implicit", "i:1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot[{{Cos[k1], Sin[k1]}, Circ[\([1]\)], 
        Circ1[\([1]\)]}, {k1, \(-1.5\)*Pi, 1.5*Pi}, 
      PlotStyle\  -> \n\ \ \ \ \ {{RGBColor[1, \ 0, \ 0], 
            Thickness[0.008]}, \ {RGBColor[0, \ 1, \ 0]}, \ {RGBColor[0, \ 
              0, \ 1]}}, 
      PlotRange -> {{\(-1.5\), 1.5}, {\(-1.5\), 1.5}}]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->{"Implicit", "i:1"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.309017 0.206011 [
[0 .29652 -12 -9 ]
[0 .29652 12 0 ]
[.16667 .29652 -6 -9 ]
[.16667 .29652 6 0 ]
[.33333 .29652 -12 -9 ]
[.33333 .29652 12 0 ]
[.66667 .29652 -9 -9 ]
[.66667 .29652 9 0 ]
[.83333 .29652 -3 -9 ]
[.83333 .29652 3 0 ]
[1 .29652 -9 -9 ]
[1 .29652 9 0 ]
[.4875 0 -24 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .10301 -12 -4.5 ]
[.4875 .10301 0 4.5 ]
[.4875 .20601 -24 -4.5 ]
[.4875 .20601 0 4.5 ]
[.4875 .41202 -18 -4.5 ]
[.4875 .41202 0 4.5 ]
[.4875 .51503 -6 -4.5 ]
[.4875 .51503 0 4.5 ]
[.4875 .61803 -18 -4.5 ]
[.4875 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
0 .30902 m
0 .31527 L
s
[(-1.5)] 0 .29652 0 1 Mshowa
.16667 .30902 m
.16667 .31527 L
s
[(-1)] .16667 .29652 0 1 Mshowa
.33333 .30902 m
.33333 .31527 L
s
[(-0.5)] .33333 .29652 0 1 Mshowa
.66667 .30902 m
.66667 .31527 L
s
[(0.5)] .66667 .29652 0 1 Mshowa
.83333 .30902 m
.83333 .31527 L
s
[(1)] .83333 .29652 0 1 Mshowa
1 .30902 m
1 .31527 L
s
[(1.5)] 1 .29652 0 1 Mshowa
.125 Mabswid
.03333 .30902 m
.03333 .31277 L
s
.06667 .30902 m
.06667 .31277 L
s
.1 .30902 m
.1 .31277 L
s
.13333 .30902 m
.13333 .31277 L
s
.2 .30902 m
.2 .31277 L
s
.23333 .30902 m
.23333 .31277 L
s
.26667 .30902 m
.26667 .31277 L
s
.3 .30902 m
.3 .31277 L
s
.36667 .30902 m
.36667 .31277 L
s
.4 .30902 m
.4 .31277 L
s
.43333 .30902 m
.43333 .31277 L
s
.46667 .30902 m
.46667 .31277 L
s
.53333 .30902 m
.53333 .31277 L
s
.56667 .30902 m
.56667 .31277 L
s
.6 .30902 m
.6 .31277 L
s
.63333 .30902 m
.63333 .31277 L
s
.7 .30902 m
.7 .31277 L
s
.73333 .30902 m
.73333 .31277 L
s
.76667 .30902 m
.76667 .31277 L
s
.8 .30902 m
.8 .31277 L
s
.86667 .30902 m
.86667 .31277 L
s
.9 .30902 m
.9 .31277 L
s
.93333 .30902 m
.93333 .31277 L
s
.96667 .30902 m
.96667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1.5)] .4875 0 1 0 Mshowa
.5 .10301 m
.50625 .10301 L
s
[(-1)] .4875 .10301 1 0 Mshowa
.5 .20601 m
.50625 .20601 L
s
[(-0.5)] .4875 .20601 1 0 Mshowa
.5 .41202 m
.50625 .41202 L
s
[(0.5)] .4875 .41202 1 0 Mshowa
.5 .51503 m
.50625 .51503 L
s
[(1)] .4875 .51503 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1.5)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .0206 m
.50375 .0206 L
s
.5 .0412 m
.50375 .0412 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .0824 m
.50375 .0824 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .14421 m
.50375 .14421 L
s
.5 .16481 m
.50375 .16481 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .22661 m
.50375 .22661 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26781 m
.50375 .26781 L
s
.5 .28842 m
.50375 .28842 L
s
.5 .32962 m
.50375 .32962 L
s
.5 .35022 m
.50375 .35022 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .39142 m
.50375 .39142 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .45322 m
.50375 .45322 L
s
.5 .47383 m
.50375 .47383 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .53563 m
.50375 .53563 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57683 m
.50375 .57683 L
s
.5 .59743 m
.50375 .59743 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.008 w
.5 .51503 m
.49612 .51501 L
.49259 .51498 L
.48852 .51491 L
.48468 .51481 L
.47784 .51457 L
.47043 .51422 L
.46229 .51371 L
.45368 .51303 L
.43832 .51147 L
.4226 .5094 L
.40804 .50703 L
.37564 .50015 L
.34394 .49105 L
.31643 .48097 L
.28647 .46721 L
.26104 .45265 L
.22184 .42254 L
.20501 .40494 L
.19026 .38515 L
.17935 .36531 L
.17466 .35386 L
.17128 .34319 L
.16908 .33376 L
.16814 .32838 L
.16747 .32334 L
.16719 .32061 L
.16698 .31802 L
.16684 .31569 L
.16673 .31316 L
.1667 .31185 L
.16667 .3104 L
.16667 .30889 L
.16668 .30748 L
.16673 .30495 L
.16678 .30353 L
.16685 .30223 L
.16701 .29963 L
.16722 .29717 L
.16773 .29258 L
.16846 .28765 L
.16948 .28232 L
.17187 .27276 L
.17472 .26401 L
.18356 .24426 L
.19633 .22406 L
.21047 .20693 L
.22847 .18952 L
.26777 .16123 L
.29287 .14761 L
Mistroke
.32259 .13461 L
.35261 .12424 L
.38186 .11638 L
.39771 .11295 L
.41513 .1098 L
.43069 .10751 L
.44728 .1056 L
.46241 .10432 L
.47103 .10379 L
.47517 .10358 L
.47908 .10341 L
.48264 .10329 L
.48651 .10317 L
.49002 .1031 L
.49327 .10305 L
.49678 .10302 L
.50065 .10301 L
.50469 .10303 L
.50848 .10307 L
.51237 .10315 L
.51653 .10326 L
.524 .10354 L
.53287 .10401 L
.54089 .10456 L
.55829 .10618 L
.57455 .10822 L
.60281 .11305 L
.63251 .11998 L
.6606 .12849 L
.68983 .13968 L
.7185 .15344 L
.74241 .16761 L
.78176 .19894 L
.79905 .21802 L
.81234 .23706 L
.82201 .25577 L
.82578 .26541 L
.82907 .27619 L
.83114 .28541 L
.832 .29062 L
.83261 .29541 L
.83299 .29963 L
.83314 .30203 L
.83324 .30426 L
.83331 .30662 L
.83333 .30876 L
.83331 .31124 L
.83325 .31358 L
.83315 .31593 L
.83298 .31845 L
Mistroke
.83279 .32082 L
.83257 .32299 L
.83187 .32829 L
.83101 .33331 L
.8287 .34324 L
.8253 .35397 L
.81697 .37278 L
.80669 .38972 L
.79137 .40908 L
.77402 .42632 L
.73463 .45535 L
.71067 .46867 L
.68324 .48111 L
.6558 .49114 L
.62955 .49883 L
.60018 .5055 L
.58475 .50826 L
.56775 .51073 L
.55187 .51252 L
.54485 .51316 L
.53708 .51375 L
.53024 .51418 L
.52286 .51454 L
.51879 .5147 L
.51506 .51482 L
.51149 .51491 L
.50773 .51497 L
.50365 .51502 L
.50135 .51503 L
.49923 .51503 L
.49534 .51501 L
.49122 .51496 L
.48752 .51488 L
.48408 .51479 L
.47623 .5145 L
.46778 .51406 L
.46008 .51355 L
.44284 .51198 L
.42824 .5102 L
.4125 .5078 L
.38441 .50225 L
.35303 .49392 L
.32596 .48472 L
.29625 .47206 L
.27107 .45876 L
.22924 .42918 L
.21112 .4118 L
.19517 .39236 L
.18384 .37429 L
.1788 .36409 L
Mistroke
.17482 .3543 L
.17182 .3451 L
.17051 .34022 L
.16933 .33502 L
.16851 .33064 L
.16778 .3258 L
.16727 .3214 L
.16708 .31923 L
.16693 .31726 L
.16679 .31473 L
.16674 .31333 L
.1667 .31202 L
.16667 .30968 L
.16668 .30715 L
.16671 .30582 L
.16675 .30436 L
.16682 .30283 L
.16689 .30141 L
.16707 .29886 L
.16732 .29612 L
.16798 .29074 L
.16882 .28565 L
.17094 .27615 L
.1737 .26691 L
.17687 .25844 L
.18614 .23963 L
.19824 .2215 L
.21209 .2052 L
.23015 .18807 L
.25205 .17133 L
.27438 .15737 L
.30116 .14367 L
.32719 .13285 L
.35319 .12406 L
.38431 .11581 L
.41363 .11004 L
.43039 .10755 L
.44602 .10572 L
.46332 .10426 L
.47208 .10373 L
.47712 .10349 L
.48174 .10331 L
.48625 .10318 L
.49054 .10309 L
.49289 .10305 L
.49506 .10303 L
.49745 .10301 L
.5 .10301 L
Mfstroke
0 1 0 r
.5 Mabswid
0 .13178 m
.0195 .15326 L
.04147 .17328 L
.05987 .18674 L
.06932 .19216 L
.07915 .19656 L
.08338 .19805 L
.08781 .19935 L
.09157 .20023 L
.09564 .20097 L
.0979 .20128 L
.09999 .20151 L
.10198 .20168 L
.10411 .2018 L
.10619 .20186 L
.10815 .20187 L
.10991 .20184 L
.11182 .20176 L
.11392 .20163 L
.11623 .20143 L
.11865 .20116 L
.12091 .20085 L
.12937 .19926 L
.13756 .19716 L
.14518 .1948 L
.16298 .18819 L
.25175 .1501 L
.30071 .13254 L
.33077 .12371 L
.36024 .11652 L
.39003 .11074 L
.42301 .10604 L
.44044 .10429 L
.45 .10354 L
.45893 .10297 L
.46659 .10259 L
.47479 .10229 L
.47704 .10223 L
.47947 .10217 L
.48162 .10213 L
.4839 .10209 L
.48821 .10204 L
.49218 .10203 L
.49619 .10204 L
.50056 .10208 L
.50469 .10216 L
.50852 .10225 L
.51574 .10249 L
.52341 .10285 L
.53245 .1034 L
Mistroke
.54093 .10405 L
.55668 .1056 L
.58509 .10958 L
.61503 .11551 L
.644 .12314 L
.67427 .13336 L
.7042 .14617 L
.72934 .15951 L
.77157 .18955 L
.79056 .20806 L
.80551 .22662 L
.81686 .24506 L
.82185 .25541 L
.82573 .26525 L
.8286 .27441 L
.83064 .28286 L
.8315 .28746 L
.83223 .2923 L
.83278 .29717 L
.83301 .29993 L
.83317 .3025 L
.83327 .30511 L
.83331 .30643 L
.83333 .30787 L
.83333 .31043 L
.83328 .31282 L
.83322 .31427 L
.83316 .31564 L
.833 .31821 L
.83277 .32098 L
.83245 .32399 L
.83175 .32908 L
.83078 .33447 L
.82846 .34411 L
.82557 .35323 L
.82225 .36171 L
.81252 .38067 L
.7998 .39907 L
.78335 .41753 L
.74665 .4476 L
.72444 .46134 L
.6985 .47454 L
.64683 .49405 L
.61583 .50234 L
.59899 .50594 L
.58085 .50915 L
.56477 .51146 L
.54688 .51345 L
.53899 .51415 L
.53048 .51477 L
Mistroke
.52239 .51524 L
.51505 .51557 L
.51072 .51572 L
.50664 .51583 L
.50233 .51592 L
.49991 .51596 L
.49768 .51598 L
.49393 .516 L
.48983 .516 L
.48554 .51596 L
.48154 .5159 L
.47927 .51586 L
.4768 .5158 L
.47231 .51566 L
.46392 .51532 L
.45413 .51478 L
.44511 .51413 L
.42994 .51275 L
.41334 .5108 L
.38032 .50557 L
.34903 .49895 L
.3214 .49174 L
.26349 .47249 L
.21313 .4517 L
.17231 .43372 L
.15395 .42633 L
.13755 .42086 L
.12877 .41864 L
.12389 .41767 L
.11943 .41698 L
.11569 .41655 L
.11357 .41638 L
.11159 .41626 L
.1095 .41618 L
.1076 .41616 L
.1054 .41619 L
.10332 .41627 L
.10117 .41642 L
.09996 .41652 L
.09884 .41664 L
.09461 .41723 L
.09075 .41798 L
.08663 .419 L
.07792 .42195 L
.06806 .42654 L
.04928 .43862 L
.02975 .45499 L
Mfstroke
.02975 .45499 m
0 .48896 L
s
0 0 1 r
.42585 .40056 m
.41861 .41178 L
.41117 .42091 L
.40232 .42953 L
.39219 .43723 L
.38095 .44374 L
.36986 .4485 L
.35962 .4517 L
.35375 .45307 L
.34829 .45408 L
.34265 .45486 L
.33947 .45518 L
.33656 .45541 L
.33385 .45557 L
.33089 .45568 L
.3281 .45573 L
.32551 .45572 L
.32392 .45569 L
.32222 .45564 L
.31912 .4555 L
.31611 .4553 L
.31334 .45507 L
.30706 .45434 L
.30047 .4533 L
.28823 .45063 L
.27704 .44732 L
.26519 .4429 L
.25278 .4372 L
.23231 .42507 L
.21496 .41148 L
.20028 .3966 L
.18883 .38163 L
.18374 .37347 L
.17895 .36442 L
.1754 .35642 L
.17215 .34749 L
.16935 .33742 L
.16817 .33187 L
.16731 .32666 L
.16698 .32414 L
.1667 .32175 L
.1665 .31957 L
.16632 .31727 L
.16618 .31475 L
.1661 .31243 L
.16605 .30992 L
.16605 .3085 L
.16606 .30716 L
.16612 .30467 L
.16618 .30328 L
Mistroke
.16625 .30202 L
.16641 .29956 L
.16661 .29724 L
.16721 .29204 L
.1681 .28642 L
.17039 .27618 L
.17323 .26682 L
.1806 .24919 L
.19111 .23105 L
.20431 .21358 L
.22132 .19578 L
.25897 .16663 L
.28341 .15237 L
.31244 .13868 L
.33936 .12849 L
.3707 .11913 L
.38582 .11546 L
.4024 .11203 L
.41694 .1095 L
.43303 .1072 L
.4504 .1053 L
.45993 .1045 L
.46882 .10391 L
.47313 .10368 L
.47719 .10349 L
.4809 .10334 L
.48481 .10322 L
.48908 .10312 L
.49302 .10305 L
.49726 .10301 L
.49967 .10301 L
.50191 .10301 L
.50606 .10304 L
.50816 .10307 L
.51047 .10311 L
.51455 .1032 L
.51838 .10332 L
.52699 .10368 L
.53626 .10423 L
.55312 .10564 L
.56848 .1074 L
.59732 .11198 L
.62687 .11851 L
.65533 .12674 L
.68423 .13733 L
.73139 .16073 L
.75445 .17593 L
.77651 .19397 L
.7929 .21068 L
.8079 .23009 L
Mistroke
.81377 .23948 L
.81925 .24977 L
.82327 .25879 L
.8269 .26875 L
.82865 .27461 L
.83003 .28007 L
.8312 .28575 L
.83204 .29091 L
.83237 .29336 L
.83267 .296 L
.83288 .29829 L
.83307 .30081 L
.83321 .30348 L
.83327 .30494 L
.8333 .30631 L
.83333 .30875 L
.83331 .31137 L
.83324 .31386 L
.83318 .31527 L
.83311 .3166 L
.83292 .31927 L
.83266 .32215 L
.83201 .32734 L
.83124 .33208 L
.82877 .34297 L
.82517 .35433 L
.81673 .37322 L
.80424 .3932 L
.78882 .41186 L
.77223 .4279 L
.74993 .44533 L
.72679 .46 L
.67657 .48375 L
.64746 .49377 L
.61505 .50237 L
.58535 .50816 L
.56834 .51065 L
.55263 .51244 L
.53793 .51369 L
.52958 .51422 L
.52559 .51442 L
.52183 .51459 L
.51824 .51472 L
.51436 .51484 L
.51083 .51492 L
.50759 .51498 L
.50407 .51501 L
.50021 .51503 L
.49618 .51502 L
.49243 .51498 L
Mistroke
.48824 .5149 L
.48613 .51485 L
.48381 .51479 L
.47586 .51449 L
.4714 .51427 L
.4666 .51399 L
.45794 .51338 L
.44106 .51178 L
.42574 .50985 L
.3955 .50465 L
.3676 .49809 L
.33923 .4895 L
.31058 .47856 L
.26406 .45462 L
.24136 .4391 L
.2198 .42081 L
.20388 .40394 L
.18947 .38447 L
.18383 .37502 L
.17864 .36473 L
.17486 .35572 L
.1715 .34583 L
.16991 .34 L
.16868 .3346 L
.16774 .32952 L
.16732 .32683 L
.16694 .32391 L
.16665 .3213 L
.16644 .31891 L
.16628 .31661 L
.16616 .3142 L
.16608 .31165 L
.16605 .30928 L
.16607 .30669 L
.16611 .30523 L
.16615 .30391 L
.16627 .30155 L
.16643 .29934 L
.16664 .29693 L
.16692 .29433 L
.16767 .28907 L
.16854 .28428 L
.17076 .27515 L
.17349 .2666 L
.18173 .24817 L
.18767 .23817 L
.19396 .22921 L
.20896 .21218 L
.22558 .19782 L
.24234 .18656 L
Mistroke
.26211 .17644 L
.27202 .17247 L
.28294 .16887 L
.28933 .16713 L
.29521 .16576 L
.30084 .16466 L
.30686 .16372 L
.30984 .16334 L
.31315 .16298 L
.31619 .16272 L
.31898 .16254 L
.32059 .16246 L
.32227 .16239 L
.32396 .16234 L
.32582 .16231 L
.32742 .1623 L
.32914 .16232 L
.33222 .16239 L
.33385 .16246 L
.33534 .16254 L
.33871 .16278 L
.34167 .16307 L
.3448 .16344 L
.3502 .16428 L
.35609 .16547 L
.36648 .16836 L
.37611 .17203 L
.3845 .17615 L
.39333 .18157 L
.40245 .18862 L
.41152 .19752 L
.42585 .21747 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[8]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/A000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo001nOol50002Ool00`00Oomoo`02Ool00`00Oomoo`2COol0081oo`03
001oogoo00Ioo`03001oo`0009Aoo`00NWoo0`000goo00<007ooOol027oo00<007ooOol00goo0P00
SGoo0020Ool00`00Oomoo`06Ool20006Ool00`00Oomoo`2<Ool0081oo`03001oogoo00Ioo`03001o
ogoo00Eoo`03001oogoo08aoo`00Ogoo0P0027oo0`001Goo00<007ooOol0S7oo002AOol00`00Oomo
o`2<Ool0095oo`03001oogoo08aoo`00TGoo00<007ooOol0S7oo002AOol00`00Oomoo`2<Ool0095o
o`03001oogoo08aoo`00TGoo00<007ooOol0S7oo002AOol00`00Oomoo`2<Ool0095oo`03001oogoo
08aoo`00TGoo00<007ooOol0S7oo002AOol00`00Oomoo`2<Ool0095oo`03001oogoo08aoo`00TGoo
00<007ooOol0S7oo002AOol00`00Oomoo`2<Ool0095oo`03001oogoo08aoo`00TGoo00<007ooOol0
S7oo002AOol00`00Oomoo`2<Ool0095oo`03001oogoo08aoo`00TGoo00<007ooOol0S7oo002AOol0
0`00Oomoo`2<Ool0095oo`03001oogoo08aoo`00TGoo00<007ooOol0S7oo0028Ool50004Ool00`00
Oomoo`2<Ool008Yoo`03001oogoo00Aoo`03001oogoo08aoo`00Pgoo1@?P4@0O00<3h7`0O000Q7oo
001hOol50n0;01lAO00<01mkOol0079oo`H3h003O0007`0O00807`]l009oo`03001oogoo00Aoo`03
001oogoo00Ioo`Yl00030n007`0O00807`Al07=oo`00KWoo10?P0g`0100O0W`03Woo0P001Woo00<0
07ooOol03goo1W`01@0OLWoo001ZOol40n000gooO01l000401l3O00IOol00`00Oomoo`0GOol2O000
0`?P01l07`0401l00g`0Oomoo`1YOol006Ioo`@3h0=l00@07`9l01ioo`03001oogoo01Yoo`=l00<3
h0807fYoo`00HWoo10?P00=oog`0O000100O0g`08Goo00<007ooOol07goo0W`000@3h00O01l07`=l
06Aoo`00GWoo10?P0g`0100O00=l07ooOol09Goo00<007ooOol08Woo0g`00`0O00<3h7ooOol0HGoo
000<Ool00`?POomoo`1;Ool40n02Ool3O00201l3O00YOol00`00Oomoo`0VOol2O00401mPOol000eo
o`030n1oogoo04Qoo`83h0Aoo`=l00807`9l02aoo`03001oogoo02Qoo`Al00<07`03O01oogoo05Yo
o`003Woo00<3h7ooOol0A7oo0`?P0goo0g`00`0O00=l07ooOol0;Goo00<007ooOol0:goo0g`000<3
h00O01l0Fgoo000?Ool00`?POomoo`10Ool30n03Ool4O00201l2O00aOol00`00Oomoo`0^Ool2O000
0`?P01l07`1IOol000moo`030n1oogoo03ioo`83h0Eoo`9l00<07`03O01oogoo039oo`03001oogoo
031oo`9l00030n007`?P05Moo`0047oo00<3h7ooOol0>Woo0`?P1Woo00=l000O01l00W`0=Woo00<0
07ooOol0<Woo0W`00P0O00<3h7`0Ool0Dgoo000AOol00`?POomoo`0gOol20n06Ool2O00201l2O00h
Ool00`00Oomoo`0dOol2O00201l00`?POomoo`1AOol0019oo`030n1oogoo03Aoo`83h0Ioo`9l0080
7`9l03Yoo`03001oogoo03Ioo`9l00807`030n1oogoo04moo`004goo00<3h7ooOol0<7oo0`?P1goo
00=l000O01l00W`027oo2`0O:Goo00<007ooOol0>7oo0W`000@07`?P0n1l04ioo`0057oo0P?P;Woo
0P?P27oo0W`000@07g`0O01l00Aoo`D07`]oo`@07bEoo`03001oogoo03Yoo`05O0007`0O0n1l001=
Ool001Ioo`030n1oogoo02Uoo`83h0Uoo`9l000301ml07oo00Aoo`807aAoo`<07b9oo`03001oogoo
03eoo`0301l3h7`004aoo`005goo00<3h7ooOol09Woo0P?P2Woo00Al000O01ml00=oo`<07aUoo`80
7b1oo`03001oogoo03ioo`807`030n1oogoo04Uoo`0067oo00<3h7ooOol08Woo0`?P2goo00El000O
O01l07oo00<07aioo`807aioo`03001oogoo03moo`03O0007`?P04Yoo`006Goo00<3h7ooOol07goo
0P?P3Goo00Al000OO01oo`807b=oo`807aaoo`03001oogoo041oo`03O0007`0O04Uoo`006Woo00<3
h7ooOol077oo0P?P37oo0g`000@07g`001l07bMoo`807aYoo`03001oogoo045oo`9l000301l3h7oo
04Ioo`006goo0P?P6Goo0`?P3Goo0W`00P0O00=l000OOol0:Woo00<07gooOol05goo00<007ooOol0
@Woo0W`00P0OAWoo000MOol30n0DOol20n0?Ool2O000100OO0007`0O;Goo00<07gooOol05Woo00<0
07ooOol0@goo0g`000<07gooOol0@goo000POol20n0>Ool40n0AOol017`001ml000O<7oo00<07goo
Ool05Goo00<007ooOol0A7oo0g`000<07gooOol0@Woo000ROol60n000goo0n03h0050n0COol2O000
0`0OO0007`0bOol00`0OOomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`04Ool0
0`00Oomoo`15Ool3O0000`0OOomoo`11Ool002Moo`<3h1Uoo`04O0007`0O01lcOol00`0OOomoo`02
Ool00`00Ool00007Ool00`00Ool00005Ool00`00Oomoo`16Ool2O0000`0O0n1oo`11Ool0049oo`9l
000301moogoo03=oo`0300007`00009oo`03001oo`0000Uoo`03001oogoo00=oo`8004Uoo`03O000
7`?P045oo`00@Goo0W`000<07gooOol0=Woo00H07gooOol007oo0007Ool20006Ool00`00Oomoo`19
Ool00g`001l3h010Ool0041oo`9l000301moogoo03Moo`0601moogoo001oo`001goo00<007ooOol0
1Goo00<007ooOol0BGoo0W`000<07`?POol0?Woo0010Ool00g`001moo`0jOol0100OOomoo`0027oo
0`001Goo00<007ooOol0BWoo0W`000<07gooOol0?Goo000oOol00g`001l07`1?Ool00`00Oomoo`1;
Ool00g`001l3h00nOol003moo`807e1oo`03001oogoo04aoo`03O0007`?P03eoo`00?Woo0P0ODGoo
00<007ooOol0CGoo00=l000O0n00?7oo000mOol00g`001moo`1AOol00`00Oomoo`1>Ool00g`001mo
o`0kOol003aoo`03O0007goo059oo`03001oogoo04moo`0301l3h7oo03Yoo`00?7oo00=l000OOol0
DWoo00<007ooOol0Cgoo00=l000OO000>Woo000kOol00g`001ml001COol00`00Oomoo`1@Ool00g`0
01moo`0iOol003Yoo`9l000301moogoo059oo`03001oogoo051oo`03O0007goo03Uoo`00>Woo0W`0
00<07gooOol0DWoo00<007ooOol0D7oo00=l000O0n00>Goo000jOol00g`001ml001DOol00`00Oomo
o`1AOol00g`001moo`0hOol003Uoo`9l000301moogoo05=oo`03001oogoo059oo`0301l3h7oo03Mo
o`00>Goo00=l000OOol0EGoo00<007ooOol0DWoo00=l000OOol0=goo0007Ool50002Ool00`00Oomo
o`02Ool00`00Oomoo`0ROol00`00O0007`02000TOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00
Oomoo`0SOol00`00Oomoo`0SOol00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0ROol00g`0
01ml0003000ROol50002Ool00`00Oomoo`02Ool00`00Oomoo`03Ool000Uoo`03001oogoo00Ioo`03
001oo`0002=oo`03O0007`0002Eoo`03001oo`0000Moo`03001oo`0002Aoo`03001oogoo029oo`03
001oo`0000Moo`03001oo`0002Aoo`03O0007`0002Ioo`03001oogoo00Ioo`03001oo`0000Aoo`00
0goo0`000goo00<007ooOol027oo00<007ooOol07Goo0`0000Aoog`001l0021oo`<0009oo`03001o
o`0000Uoo`03001oogoo029oo`03001oogoo029oo`03001oo`0000Uoo`03001oogoo029oo`03O000
7`0002Ioo`03001oogoo00Qoo`03001oogoo009oo`002Goo00<007ooOol01Woo0P0097oo0P0O00<0
07ooOol08goo00<007oo00001goo0P009Goo00<007ooOol08Woo00<007oo00001goo0P009Goo00=l
000OO0009Woo00<007ooOol01Woo0P001Goo0009Ool00`00Oomoo`06Ool00`00Oomoo`0ROol017`0
01ml00009Goo00<007oo00001goo00<007ooOol097oo00<007ooOol08Woo00<007oo00001goo00<0
07ooOol09Goo00<3h00OOol09Goo00<007ooOol01Woo00<007ooOol017oo0008Ool20008Ool3000R
Ool017`001ml00009Woo00<007ooOol01Woo0`0097oo00<007ooOol08goo00<007ooOol01Woo0`00
9Goo00=l000OOol097oo0P0027oo0`0017oo000gOol00g`001moo`1GOol00`00Oomoo`1DOol00g`0
01moo`0eOol003Moo`03O0007goo05Moo`03001oogoo05Aoo`03O0007goo03Eoo`00=goo00=l000O
Ool0Egoo00<007ooOol0E7oo00=l000OOol0=Goo000gOol00g`001moo`1GOol00`00Oomoo`1DOol0
0g`001moo`0eOol003Moo`03O0007goo05Moo`03001oogoo05Aoo`03O0007goo03Eoo`0037oo:`00
00=l000O0000[P0000=l000O0000;0002Goo000<Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00
Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00g`001moo`07Ool00`00Oomoo`06Ool00`00
Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00
Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00
Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00
Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00g`001moo`07Ool00`00Oomoo`06Ool00`00
Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`07Ool000aoo`03001oogoo02Qo
o`03O0007goo02Yoo`03001oogoo02Yoo`03001oogoo02Uoo`03001oogoo02Qoo`03O0007goo02]o
o`03001oogoo00Moo`00=goo00=l000OOol0Egoo00<007ooOol0E7oo00=l000OOol0=Goo000gOol0
0g`001moo`1GOol00`00Oomoo`1DOol00g`001moo`0eOol003Moo`03O0007goo05Moo`03001oogoo
05Aoo`03O0007goo03Eoo`00=goo00=l000OOol0Egoo00<007ooOol0E7oo00<3h00OOol0=Goo000g
Ool00g`001l07`1GOol00`00Oomoo`1DOol00`?P01moo`0eOol003Moo`9l000301moogoo05Eoo`03
001oogoo05=oo`03O0007g`003Ioo`00>7oo00=l000OOol0EWoo00<007ooOol0Dgoo00=l000OOol0
=Woo000hOol00g`001ml001FOol00`00Oomoo`1COol00g`001moo`0fOol003Qoo`03O0007`0O05Io
o`03001oogoo059oo`03O0007g`003Moo`00>Goo00=l000OOol0EGoo00<007ooOol0DWoo00=l000O
Ool0=goo000iOol00g`001ml001EOol00`00Oomoo`1AOol00g`00n007`0hOol003Yoo`03O0007goo
05Aoo`03001oogoo055oo`03O0007goo03Qoo`00>Woo00=l000OOol0E7oo00<007ooOol0DGoo00=l
000OOol0>7oo000kOol201mDOol00`00Oomoo`1@Ool00g`001ml000iOol003]oo`03O0007goo05=o
o`03001oogoo051oo`03O0007goo03Uoo`00?7oo0P0ODgoo00<007ooOol0Cgoo00=l000OOol0>Woo
000lOol00g`001l07`1BOol00`00Oomoo`1?Ool00`0O0n1oo`0jOol003eoo`03O0007`0O055oo`03
001oogoo04ioo`03O0007goo03]oo`00?Woo00=l000O01l0D7oo00<007ooOol0CGoo00=l000OOol0
?7oo000nOol2O0000`0OOomoo`1>Ool00`00Oomoo`1=Ool00`0O0n1oo`0lOol003moo`03O0007`0O
04moo`03001oogoo04aoo`0301l3h7oo03eoo`00@7oo00=l000O01l0>Woo00<07gooOol04Goo00<0
07ooOol0Bgoo00<07`?POol0?Woo0011Ool00g`001l07`0hOol01@0OOomoogoo000017oo00<007oo
Ool00Woo00<007ooOol017oo00<007ooOol0BWoo00=l000OOol0?goo0011Ool2O00201lgOol01P0O
Oomoo`00Ool000Moo`03001oo`0000Eoo`03001oogoo04Uoo`03O0007goo041oo`00@Woo0W`00P0O
=Goo00L07gooOomoo`00Ool00009Ool00`00Oomoo`03Ool20019Ool00g`001l3h011Ool004=oo`04
O0007g`001lcOol00`0OOomoo`02Ool00`00Ool00007Ool20006Ool00`00Oomoo`17Ool00g`001l3
h012Ool0029oo`d3h1Eoo`04O0007g`001lbOol00`0OOomoo`02Ool00`00Ool00007Ool00`00Oomo
o`05Ool00`00Oomoo`16Ool00g`001l3h013Ool0021oo`83h0eoo`<3h1=oo`04O0007g`001l`Ool0
0`0OOomoo`04Ool00`00Oomoo`06Ool30005Ool00`00Oomoo`14Ool3O0000`0OOomoo`12Ool001io
o`83h19oo`@3h11oo`04O0007g`001l^Ool00`0OOomoo`0FOol00`00Oomoo`13Ool2O0000`?P01mo
o`14Ool001eoo`030n1oogoo01Ioo`83h0moo`03O0007g`000807b]oo`0301moogoo01Moo`03001o
ogoo049oo`9l00030n007goo04Eoo`006goo0P?P6goo0`?P37oo0W`00P0O00=l000O01l09goo0P0O
6Woo00<007ooOol0@Goo0W`00P0OAgoo000JOol00`?POomoo`0NOol20n0<Ool2O0000`0OO01l0002
01lTOol00`0OOomoo`0JOol00`00Oomoo`10Ool2O0000`0OOomoo`17Ool001Uoo`030n1oogoo025o
o`83h0aoo`05O0007g`0O01oo`0201lPOol201lMOol00`00Oomoo`0nOol2O00201m:Ool001Moo`83
h2Ioo`83h0]oo`04O0007`0OO002Ool201lLOol201lOOol00`00Oomoo`0mOol2O0000`0OO01oo`1:
Ool001Ioo`030n1oogoo02Qoo`83h0Yoo`9l000301ml07`0009oo`<07aIoo`<07b5oo`03001oogoo
03aoo`03O0007`0O04eoo`0057oo0P?P;Goo0`?P2Goo00=l000O01l00W`00goo1@0O3Woo0`0O97oo
00<007ooOol0>goo00=l000O0n00CWoo000COol00`?POomoo`0`Ool20n08Ool2O000100OO01l07`0
1Woo3P0O9goo00<007ooOol0>Goo00Al000O01ml04moo`004Woo00<3h7ooOol0<goo0P?P1goo0W`0
0P0O0W`0>Woo00<007ooOol0=goo0W`000<07`?PO000D7oo000AOol00`?POomoo`0fOol30n06Ool2
O00201l2O00hOol00`00Oomoo`0dOol3O00201l00g`0Oomoo`1@Ool0015oo`030n1oogoo03Uoo`83
h0Ioo`9l00807`9l03Ioo`03001oogoo03=oo`9l00807`03O01oogoo059oo`0047oo00<3h7ooOol0
?7oo0P?P1Woo0W`00P0O00=l07ooOol0<goo00<007ooOol0<Goo0W`00P0O00=l07ooOol0E7oo000?
Ool00`?POomoo`0oOol30n05Ool2O00201l00g`0Oomoo`0aOol00`00Oomoo`0_Ool01G`00n007`0O
O000F7oo000>Ool00`?POomoo`13Ool30n04Ool2O00301l00g`0Oomoo`0^Ool00`00Oomoo`0/Ool2
O00010?P01l07g`0FWoo000>Ool00`?POomoo`16Ool30n03Ool3O00201l00g`0Oomoo`0/Ool00`00
Oomoo`0[Ool20n0201l00g`0Oomoo`1JOol000eoo`030n1oogoo04Yoo`<3h09oo`=l00<07`=l02Uo
o`03001oogoo02Eoo`=l0083h0<07`03O01oogoo05aoo`0037oo00<3h7ooOol0CWoo0`?P00=oog`0
O0000W`00`0O0W`09goo00<007ooOol097oo0W`0100O00=l07ooOol0Ggoo001POol30n000gooO01l
0002O00401lUOol00`00Oomoo`0QOol00g`001l07`0201l00g`0Oomoo`1SOol006=oo`@3h003Ooml
07`0009l00<07`Al01ioo`03001oogoo01ioo`@07`=l06Moo`00Igoo1P?P0W`0100O00=l07ooOol0
6goo00<007ooOol05Woo17`0100O17`0JWoo001]Ool60n0601l00g`0Oomoo`0EOol00`00Oomoo`0B
Ool3O0000`?P01l07`0201l6O01/Ool0075oo`9l00@3h09l00H07`9l00Moo`D000Aoo`03001oogoo
00Eoo`9l00Moo`=l00030n007`0O00807`9l07Aoo`00Mgoo20?P200O0g`000<007ooOol017oo00<0
07ooOol01Goo00=l000O01l02P0O0W`0N7oo001lOol4O0070n0C01l30n07O01lOol008Mooa=l08Io
o`00RWoo00<007ooOol017oo00<007ooOol0S7oo0029Ool20006Ool00`00Oomoo`2<Ool0095oo`03
001oogoo08aoo`00TGoo00<007ooOol0S7oo002AOol00`00Oomoo`2<Ool0095oo`03001oogoo08ao
o`00TGoo00<007ooOol0S7oo002AOol00`00Oomoo`2<Ool0095oo`03001oogoo08aoo`00TGoo00<0
07ooOol0S7oo002AOol00`00Oomoo`2<Ool0095oo`03001oogoo08aoo`00TGoo00<007ooOol0S7oo
002AOol00`00Oomoo`2<Ool0095oo`03001oogoo08aoo`00TGoo00<007ooOol0S7oo002AOol00`00
Oomoo`2<Ool0095oo`03001oogoo08aoo`00TGoo00<007ooOol0S7oo002AOol00`00Oomoo`2<Ool0
095oo`03001oogoo08aoo`00TGoo00<007ooOol0S7oo002AOol00`00Oomoo`2<Ool007ioo`D0009o
o`03001oogoo009oo`03001oogoo00Aoo`03001oogoo08aoo`00P7oo00<007ooOol01Woo00<007oo
00001Goo00<007ooOol0S7oo0020Ool00`00Oomoo`08Ool00`00Oomoo`03Ool2002=Ool0081oo`03
001oogoo00Ioo`8009Eoo`00P7oo00<007ooOol01Woo00<007ooOol0U7oo001oOol20008Ool3002D
Ool00?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.63536, -1.61445, \
0.0112783, 0.0182487}},
  CellTags->{"Implicit", "i:1"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[8]=",
  CellTags->{"Implicit", "i:1"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["A Surface of Equilibrium Points", "Subsection",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell[TextData[{
  "Consider the parameter dependent differential equation ",
  Cell[BoxData[
      \(TraditionalForm\`x' = x\^3\  + mu1\ x\  + mu0\)]],
  ". Equilibria are defined by Feq=0, where"
}], "Text",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell[BoxData[
    \(\(Feq = {x1^3 + mu1*x1 + mu0};\)\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell["\<\
We can find the equilibrium points as a function of parameters with\
\>", "Text",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \({Time, Surf} = 
      Timing[EquilibriumSurface[Feq, {x1}, {mu0, mu1}, {0}, {0, 0}, s, 
          3]]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell[BoxData[
    \("2 vector fields computed."\)], "Print",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell[BoxData[
    \("2 flow functions computed."\)], "Print",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell[BoxData[
    \({0.379999999999999893`\ Second, {{s2, \(-s1\)\ s2 - s2\^3, s1}, {s1, 
          s2}}}\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->{"Equilibrium Surface", "i:2"}]
}, Open  ]],

Cell["\<\
This provides a local representation of the surface around the point x=0, \
mu0=0, mu1=0 (in this example its global). Now, we can graph the surface of \
equilibria:\
\>", "Text",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot3D[\(Surf[\([1]\)]\)[\([{2, 3, 1}]\)], {s1, \(-2\), 
        2}, {s2, \(-1.5\), 
        1.5}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ PlotPoints -> {25, 
          25}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ BoxRatios -> {1, 
          1,  .3}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ AxesEdge -> {None, 
          None, None}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ ViewPoint -> { \
.25, \(-1\),  .5}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ Boxed -> 
        False]\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .56948 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-2.22045e-016 1.08407 -0.137977 1.08407 [
[ 0 0 0 0 ]
[ 1 .56948 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .56948 L
0 .56948 L
closepath
clip
newpath
.5 Mabswid
.40559 .54846 m .38862 .55174 L .38532 .55056 L p .361 .824 .913 r
F P
0 g
s
.40769 .54387 m .40559 .54846 L p .38532 .55056 L .361 .824 .913 r
F P
0 g
s
.40559 .54846 m .40769 .54387 L .44052 .53667 L p .38 .836 .914 r
F P
0 g
s
.44052 .53667 m .43861 .54141 L .40559 .54846 L p .38 .836 .914 r
F P
0 g
s
.38532 .55056 m .38105 .54914 L .40769 .54387 L p .361 .824 .913 r
F P
0 g
s
.43861 .54141 m .44052 .53667 L .4691 .52969 L p .402 .849 .915 r
F P
0 g
s
.4691 .52969 m .4675 .53456 L .43861 .54141 L p .402 .849 .915 r
F P
0 g
s
.4675 .53456 m .4691 .52969 L .4938 .52292 L p .427 .864 .916 r
F P
0 g
s
.4938 .52292 m .49264 .52791 L .4675 .53456 L p .427 .864 .916 r
F P
0 g
s
.40769 .54387 m .38105 .54914 L .37925 .54851 L p .363 .826 .912 r
F P
0 g
s
.49264 .52791 m .4938 .52292 L .51507 .51634 L p .456 .88 .917 r
F P
0 g
s
.51507 .51634 m .51446 .52143 L .49264 .52791 L p .456 .88 .917 r
F P
0 g
s
.37925 .54851 m .37313 .5465 L .4099 .53904 L p .363 .826 .912 r
F P
0 g
s
.4099 .53904 m .40769 .54387 L p .37925 .54851 L .363 .826 .912 r
F P
0 g
s
.51446 .52143 m .51507 .51634 L .53341 .50994 L p .489 .898 .918 r
F P
0 g
s
.53341 .50994 m .53343 .51512 L .51446 .52143 L p .489 .898 .918 r
F P
0 g
s
.40769 .54387 m .4099 .53904 L .44254 .53169 L p .382 .838 .913 r
F P
0 g
s
.44254 .53169 m .44052 .53667 L .40769 .54387 L p .382 .838 .913 r
F P
0 g
s
.53343 .51512 m .53341 .50994 L .54936 .5037 L p .524 .915 .918 r
F P
0 g
s
.54936 .5037 m .55009 .50896 L .53343 .51512 L p .524 .915 .918 r
F P
0 g
s
.55009 .50896 m .54936 .5037 L .56349 .49757 L p .559 .93 .92 r
F P
0 g
s
.56349 .49757 m .56498 .5029 L .55009 .50896 L p .559 .93 .92 r
F P
0 g
s
.56498 .5029 m .56349 .49757 L .5764 .49153 L p .591 .942 .922 r
F P
0 g
s
.5764 .49153 m .57869 .49692 L .56498 .5029 L p .591 .942 .922 r
F P
0 g
s
.57869 .49692 m .5764 .49153 L .58871 .48553 L p .615 .95 .928 r
F P
0 g
s
.58871 .48553 m .59182 .49097 L .57869 .49692 L p .615 .95 .928 r
F P
0 g
s
.44052 .53667 m .44254 .53169 L .47077 .52457 L p .405 .852 .914 r
F P
0 g
s
.47077 .52457 m .4691 .52969 L .44052 .53667 L p .405 .852 .914 r
F P
0 g
s
.59182 .49097 m .58871 .48553 L .60103 .47953 L p .629 .951 .936 r
F P
0 g
s
.60103 .47953 m .60497 .48501 L .59182 .49097 L p .629 .951 .936 r
F P
0 g
s
.60497 .48501 m .60103 .47953 L .614 .47345 L p .631 .948 .946 r
F P
0 g
s
.614 .47345 m .61878 .47898 L .60497 .48501 L p .631 .948 .946 r
F P
0 g
s
.61878 .47898 m .614 .47345 L .62829 .46726 L p .624 .94 .957 r
F P
0 g
s
.62829 .46726 m .63388 .47284 L .61878 .47898 L p .624 .94 .957 r
F P
0 g
s
.63388 .47284 m .62829 .46726 L .64455 .46089 L p .609 .928 .966 r
F P
0 g
s
.64455 .46089 m .65094 .46651 L .63388 .47284 L p .609 .928 .966 r
F P
0 g
s
.4691 .52969 m .47077 .52457 L .49501 .51767 L p .432 .867 .914 r
F P
0 g
s
.49501 .51767 m .4938 .52292 L .4691 .52969 L p .432 .867 .914 r
F P
0 g
s
.65094 .46651 m .64455 .46089 L .66348 .45425 L p .591 .915 .975 r
F P
0 g
s
.66348 .45425 m .67063 .45993 L .65094 .46651 L p .591 .915 .975 r
F P
0 g
s
.4099 .53904 m .37313 .5465 L .37303 .54646 L p .365 .827 .911 r
F P
0 g
s
.37303 .54646 m .37268 .54635 L p .41223 .53395 L .365 .827 .911 r
F P
0 g
s
.41223 .53395 m .4099 .53904 L p .37303 .54646 L .365 .827 .911 r
F P
0 g
s
.37268 .54635 m .37493 .5417 L .41223 .53395 L p .365 .827 .911 r
F P
0 g
s
.37493 .5417 m .37268 .54635 L .3664 .54413 L p .348 .816 .91 r
F P
0 g
s
.67063 .45993 m .66348 .45425 L .68582 .44728 L p .572 .902 .981 r
F P
0 g
s
.68582 .44728 m .69369 .45303 L .67063 .45993 L p .572 .902 .981 r
F P
0 g
s
.4938 .52292 m .49501 .51767 L .51571 .51099 L p .463 .885 .914 r
F P
0 g
s
.51571 .51099 m .51507 .51634 L .4938 .52292 L p .463 .885 .914 r
F P
0 g
s
.69369 .45303 m .68582 .44728 L .71234 .43989 L p .554 .89 .985 r
F P
0 g
s
.71234 .43989 m .72088 .44571 L .69369 .45303 L p .554 .89 .985 r
F P
0 g
s
.51507 .51634 m .51571 .51099 L .53338 .50451 L p .498 .903 .914 r
F P
0 g
s
.53338 .50451 m .53341 .50994 L .51507 .51634 L p .498 .903 .914 r
F P
0 g
s
.4099 .53904 m .41223 .53395 L .44465 .52644 L p .385 .84 .912 r
F P
0 g
s
.44465 .52644 m .44254 .53169 L .4099 .53904 L p .385 .84 .912 r
F P
0 g
s
.53341 .50994 m .53338 .50451 L .54859 .49819 L p .536 .921 .913 r
F P
0 g
s
.54859 .49819 m .54936 .5037 L .53341 .50994 L p .536 .921 .913 r
F P
0 g
s
.72088 .44571 m .71234 .43989 L .74389 .43198 L p .537 .879 .988 r
F P
0 g
s
.74389 .43198 m .75304 .43789 L .72088 .44571 L p .537 .879 .988 r
F P
0 g
s
.54936 .5037 m .54859 .49819 L .56193 .492 L p .574 .938 .913 r
F P
0 g
s
.56193 .492 m .56349 .49757 L .54936 .5037 L p .574 .938 .913 r
F P
0 g
s
.56349 .49757 m .56193 .492 L .57401 .4859 L p .608 .95 .915 r
F P
0 g
s
.57401 .4859 m .5764 .49153 L .56349 .49757 L p .608 .95 .915 r
F P
0 g
s
.5764 .49153 m .57401 .4859 L .58545 .47985 L p .634 .958 .92 r
F P
0 g
s
.58545 .47985 m .58871 .48553 L .5764 .49153 L p .634 .958 .92 r
F P
0 g
s
.58871 .48553 m .58545 .47985 L .5969 .47379 L p .648 .96 .928 r
F P
0 g
s
.5969 .47379 m .60103 .47953 L .58871 .48553 L p .648 .96 .928 r
F P
0 g
s
.60103 .47953 m .5969 .47379 L .60901 .46768 L p .65 .956 .94 r
F P
0 g
s
.60901 .46768 m .614 .47345 L .60103 .47953 L p .65 .956 .94 r
F P
0 g
s
.614 .47345 m .60901 .46768 L .62244 .46144 L p .64 .947 .952 r
F P
0 g
s
.62244 .46144 m .62829 .46726 L .614 .47345 L p .64 .947 .952 r
F P
0 g
s
.44254 .53169 m .44465 .52644 L .47254 .51918 L p .409 .854 .912 r
F P
0 g
s
.47254 .51918 m .47077 .52457 L .44254 .53169 L p .409 .854 .912 r
F P
0 g
s
.62829 .46726 m .62244 .46144 L .63788 .45501 L p .623 .934 .964 r
F P
0 g
s
.63788 .45501 m .64455 .46089 L .62829 .46726 L p .623 .934 .964 r
F P
0 g
s
.75304 .43789 m .74389 .43198 L .78141 .42343 L p .523 .87 .99 r
F P
0 g
s
.78141 .42343 m .7911 .42945 L .75304 .43789 L p .523 .87 .99 r
F P
0 g
s
.3664 .54413 m .36483 .54361 L .37493 .5417 L p .348 .816 .91 r
F P
0 g
s
.64455 .46089 m .63788 .45501 L .65602 .44833 L p .602 .92 .973 r
F P
0 g
s
.65602 .44833 m .66348 .45425 L .64455 .46089 L p .602 .92 .973 r
F P
0 g
s
.66348 .45425 m .65602 .44833 L .67762 .44129 L p .581 .906 .98 r
F P
0 g
s
.67762 .44129 m .68582 .44728 L .66348 .45425 L p .581 .906 .98 r
F P
0 g
s
.47077 .52457 m .47254 .51918 L .49629 .51216 L p .437 .871 .912 r
F P
0 g
s
.49629 .51216 m .49501 .51767 L .47077 .52457 L p .437 .871 .912 r
F P
0 g
s
.37493 .5417 m .36483 .54361 L .35957 .54176 L p .349 .818 .909 r
F P
0 g
s
.37744 .53653 m .37493 .5417 L p .35957 .54176 L .349 .818 .909 r
F P
0 g
s
.37493 .5417 m .37744 .53653 L .41469 .52858 L p .367 .829 .91 r
F P
0 g
s
.41469 .52858 m .41223 .53395 L .37493 .5417 L p .367 .829 .91 r
F P
0 g
s
.68582 .44728 m .67762 .44129 L .70345 .43383 L p .56 .893 .984 r
F P
0 g
s
.70345 .43383 m .71234 .43989 L .68582 .44728 L p .56 .893 .984 r
F P
0 g
s
.7911 .42945 m .78141 .42343 L p .81229 .42014 L .511 .861 .991 r
F P
0 g
s
.81229 .42014 m .81126 .42534 L .7911 .42945 L p .511 .861 .991 r
F P
0 g
s
.49501 .51767 m .49629 .51216 L .51638 .50538 L p .47 .889 .911 r
F P
0 g
s
.51638 .50538 m .51571 .51099 L .49501 .51767 L p .47 .889 .911 r
F P
0 g
s
.71234 .43989 m .70345 .43383 L .73437 .42583 L p .542 .882 .988 r
F P
0 g
s
.73437 .42583 m .74389 .43198 L .71234 .43989 L p .542 .882 .988 r
F P
0 g
s
.51571 .51099 m .51638 .50538 L .53336 .4988 L p .508 .908 .91 r
F P
0 g
s
.53336 .4988 m .53338 .50451 L .51571 .51099 L p .508 .908 .91 r
F P
0 g
s
.53338 .50451 m .53336 .4988 L .54779 .4924 L p .549 .928 .907 r
F P
0 g
s
.54779 .4924 m .54859 .49819 L .53338 .50451 L p .549 .928 .907 r
F P
0 g
s
.41223 .53395 m .41469 .52858 L .44689 .52091 L p .388 .842 .911 r
F P
0 g
s
.44689 .52091 m .44465 .52644 L .41223 .53395 L p .388 .842 .911 r
F P
0 g
s
.54859 .49819 m .54779 .4924 L .56029 .48614 L p .59 .945 .905 r
F P
0 g
s
.56029 .48614 m .56193 .492 L .54859 .49819 L p .59 .945 .905 r
F P
0 g
s
.56193 .492 m .56029 .48614 L .57149 .47999 L p .627 .959 .906 r
F P
0 g
s
.57149 .47999 m .57401 .4859 L .56193 .492 L p .627 .959 .906 r
F P
0 g
s
.57401 .4859 m .57149 .47999 L .58204 .47389 L p .656 .967 .91 r
F P
0 g
s
.58204 .47389 m .58545 .47985 L .57401 .4859 L p .656 .967 .91 r
F P
0 g
s
.58545 .47985 m .58204 .47389 L .59258 .46779 L p .67 .969 .919 r
F P
0 g
s
.59258 .46779 m .5969 .47379 L .58545 .47985 L p .67 .969 .919 r
F P
0 g
s
.5969 .47379 m .59258 .46779 L .60378 .46163 L p .671 .964 .932 r
F P
0 g
s
.60378 .46163 m .60901 .46768 L .5969 .47379 L p .671 .964 .932 r
F P
0 g
s
.74389 .43198 m .73437 .42583 L .77133 .41717 L p .527 .871 .99 r
F P
0 g
s
.77133 .41717 m .78141 .42343 L .74389 .43198 L p .527 .871 .99 r
F P
0 g
s
.35957 .54176 m .35613 .54063 L .37744 .53653 L p .349 .818 .909 r
F P
0 g
s
.60901 .46768 m .60378 .46163 L .61633 .45535 L p .659 .954 .946 r
F P
0 g
s
.61633 .45535 m .62244 .46144 L .60901 .46768 L p .659 .954 .946 r
F P
0 g
s
.62244 .46144 m .61633 .45535 L .63091 .44888 L p .639 .941 .96 r
F P
0 g
s
.63091 .44888 m .63788 .45501 L .62244 .46144 L p .639 .941 .96 r
F P
0 g
s
.63788 .45501 m .63091 .44888 L .64824 .44214 L p .615 .926 .97 r
F P
0 g
s
.64824 .44214 m .65602 .44833 L .63788 .45501 L p .615 .926 .97 r
F P
0 g
s
.44465 .52644 m .44689 .52091 L .4744 .5135 L p .413 .857 .911 r
F P
0 g
s
.4744 .5135 m .47254 .51918 L .44465 .52644 L p .413 .857 .911 r
F P
0 g
s
.65602 .44833 m .64824 .44214 L .66906 .43505 L p .59 .911 .978 r
F P
0 g
s
.66906 .43505 m .67762 .44129 L .65602 .44833 L p .59 .911 .978 r
F P
0 g
s
.78141 .42343 m .81295 .41684 L .81229 .42014 L p .511 .861 .991 r
F P
0 g
s
.78141 .42343 m .77133 .41717 L p .81467 .40807 L .513 .863 .991 r
F P
0 g
s
.81467 .40807 m .81295 .41684 L .78141 .42343 L p .513 .863 .991 r
F P
0 g
s
.67762 .44129 m .66906 .43505 L .69418 .42751 L p .567 .897 .984 r
F P
0 g
s
.69418 .42751 m .70345 .43383 L .67762 .44129 L p .567 .897 .984 r
F P
0 g
s
.37744 .53653 m .35613 .54063 L .35254 .53939 L p .351 .819 .909 r
F P
0 g
s
.47254 .51918 m .4744 .5135 L .49763 .50636 L p .443 .875 .91 r
F P
0 g
s
.49763 .50636 m .49629 .51216 L .47254 .51918 L p .443 .875 .91 r
F P
0 g
s
.70345 .43383 m .69418 .42751 L .72445 .41941 L p .547 .884 .987 r
F P
0 g
s
.72445 .41941 m .73437 .42583 L .70345 .43383 L p .547 .884 .987 r
F P
0 g
s
.38009 .53106 m .37744 .53653 L p .35254 .53939 L .351 .819 .909 r
F P
0 g
s
.37744 .53653 m .38009 .53106 L .41728 .52292 L p .369 .831 .909 r
F P
0 g
s
.41728 .52292 m .41469 .52858 L .37744 .53653 L p .369 .831 .909 r
F P
0 g
s
.49629 .51216 m .49763 .50636 L .51709 .49946 L p .478 .894 .908 r
F P
0 g
s
.51709 .49946 m .51638 .50538 L .49629 .51216 L p .478 .894 .908 r
F P
0 g
s
.51638 .50538 m .51709 .49946 L .53333 .49279 L p .518 .914 .904 r
F P
0 g
s
.53333 .49279 m .53336 .4988 L .51638 .50538 L p .518 .914 .904 r
F P
0 g
s
.35254 .53939 m .34698 .53758 L .38009 .53106 L p .351 .819 .909 r
F P
0 g
s
.73437 .42583 m .72445 .41941 L .76083 .41065 L p .531 .873 .99 r
F P
0 g
s
.76083 .41065 m .77133 .41717 L .73437 .42583 L p .531 .873 .99 r
F P
0 g
s
.53336 .4988 m .53333 .49279 L .54695 .48631 L p .563 .935 .9 r
F P
0 g
s
.54695 .48631 m .54779 .4924 L .53336 .4988 L p .563 .935 .9 r
F P
0 g
s
.54779 .4924 m .54695 .48631 L .55857 .48 L p .609 .954 .896 r
F P
0 g
s
.55857 .48 m .56029 .48614 L .54779 .4924 L p .609 .954 .896 r
F P
0 g
s
.56029 .48614 m .55857 .48 L .56886 .47379 L p .65 .968 .893 r
F P
0 g
s
.56886 .47379 m .57149 .47999 L .56029 .48614 L p .65 .968 .893 r
F P
0 g
s
.58805 .4615 m .59258 .46779 L .58204 .47389 L p .696 .978 .906 r
F P
0 g
s
.59258 .46779 m .58805 .4615 L .59831 .4553 L p .695 .973 .922 r
F P
0 g
s
.59831 .4553 m .60378 .46163 L .59258 .46779 L p .695 .973 .922 r
F P
0 g
s
.57846 .46764 m .58204 .47389 L .57149 .47999 L p .68 .976 .896 r
F P
0 g
s
.58204 .47389 m .57846 .46764 L .58805 .4615 L p .696 .978 .906 r
F P
0 g
s
.57149 .47999 m .56886 .47379 L .57846 .46764 L p .68 .976 .896 r
F P
0 g
s
.60378 .46163 m .59831 .4553 L .60994 .44898 L p .68 .962 .939 r
F P
0 g
s
.60994 .44898 m .61633 .45535 L .60378 .46163 L p .68 .962 .939 r
F P
0 g
s
.61633 .45535 m .60994 .44898 L .62363 .44247 L p .656 .948 .955 r
F P
0 g
s
.62363 .44247 m .63091 .44888 L .61633 .45535 L p .656 .948 .955 r
F P
0 g
s
.41469 .52858 m .41728 .52292 L .44925 .51507 L p .391 .844 .91 r
F P
0 g
s
.44925 .51507 m .44689 .52091 L .41469 .52858 L p .391 .844 .91 r
F P
0 g
s
.63091 .44888 m .62363 .44247 L .6401 .43568 L p .628 .932 .968 r
F P
0 g
s
.6401 .43568 m .64824 .44214 L .63091 .44888 L p .628 .932 .968 r
F P
0 g
s
.64824 .44214 m .6401 .43568 L .66013 .42852 L p .601 .915 .977 r
F P
0 g
s
.66013 .42852 m .66906 .43505 L .64824 .44214 L p .601 .915 .977 r
F P
0 g
s
.77133 .41717 m .81471 .40788 L .81467 .40807 L p .513 .863 .991 r
F P
0 g
s
.77133 .41717 m .76083 .41065 L .80441 .40107 L p .516 .864 .991 r
F P
0 g
s
.81471 .40788 m .77133 .41717 L p .80441 .40107 L .516 .864 .991 r
F P
0 g
s
.66906 .43505 m .66013 .42852 L .6845 .42091 L p .575 .9 .983 r
F P
0 g
s
.6845 .42091 m .69418 .42751 L .66906 .43505 L p .575 .9 .983 r
F P
0 g
s
.44689 .52091 m .44925 .51507 L .47636 .50751 L p .417 .86 .909 r
F P
0 g
s
.47636 .50751 m .4744 .5135 L .44689 .52091 L p .417 .86 .909 r
F P
0 g
s
.38009 .53106 m .34698 .53758 L .3453 .53701 L p .353 .82 .908 r
F P
0 g
s
.69418 .42751 m .6845 .42091 L .7141 .41273 L p .553 .887 .987 r
F P
0 g
s
.7141 .41273 m .72445 .41941 L .69418 .42751 L p .553 .887 .987 r
F P
0 g
s
.4744 .5135 m .47636 .50751 L .49905 .50023 L p .449 .878 .907 r
F P
0 g
s
.49905 .50023 m .49763 .50636 L .4744 .5135 L p .449 .878 .907 r
F P
0 g
s
.3453 .53701 m .33952 .53516 L p .3829 .52527 L .353 .82 .908 r
F P
0 g
s
.3829 .52527 m .38009 .53106 L p .3453 .53701 L .353 .82 .908 r
F P
0 g
s
.80441 .40107 m .81481 .40737 L .81471 .40788 L p .516 .864 .991 r
F P
0 g
s
.81481 .40737 m .80441 .40107 L .81657 .39861 L closepath p .504 .858 .991 r
F P
0 g
s
.72445 .41941 m .7141 .41273 L .74989 .40385 L p .535 .875 .99 r
F P
0 g
s
.74989 .40385 m .76083 .41065 L .72445 .41941 L p .535 .875 .99 r
F P
0 g
s
.49763 .50636 m .49905 .50023 L .51784 .49323 L p .487 .899 .904 r
F P
0 g
s
.51784 .49323 m .51709 .49946 L .49763 .50636 L p .487 .899 .904 r
F P
0 g
s
.38009 .53106 m .3829 .52527 L .42002 .51692 L p .372 .833 .908 r
F P
0 g
s
.42002 .51692 m .41728 .52292 L .38009 .53106 L p .372 .833 .908 r
F P
0 g
s
.51709 .49946 m .51784 .49323 L .5333 .48646 L p .53 .921 .898 r
F P
0 g
s
.5333 .48646 m .53333 .49279 L .51709 .49946 L p .53 .921 .898 r
F P
0 g
s
.59258 .44867 m .59831 .4553 L .58805 .4615 L p .722 .981 .908 r
F P
0 g
s
.59831 .4553 m .59258 .44867 L .60324 .44231 L p .704 .971 .929 r
F P
0 g
s
.60324 .44231 m .60994 .44898 L .59831 .4553 L p .704 .971 .929 r
F P
0 g
s
.53333 .49279 m .5333 .48646 L .54606 .47991 L p .579 .943 .891 r
F P
0 g
s
.54606 .47991 m .54695 .48631 L .53333 .49279 L p .579 .943 .891 r
F P
0 g
s
.5833 .4549 m .58805 .4615 L .57846 .46764 L p .724 .986 .889 r
F P
0 g
s
.58805 .4615 m .5833 .4549 L .59258 .44867 L p .722 .981 .908 r
F P
0 g
s
.60994 .44898 m .60324 .44231 L .616 .43576 L p .675 .955 .949 r
F P
0 g
s
.616 .43576 m .62363 .44247 L .60994 .44898 L p .675 .955 .949 r
F P
0 g
s
.5747 .46108 m .57846 .46764 L .56886 .47379 L p .708 .985 .879 r
F P
0 g
s
.57846 .46764 m .5747 .46108 L .5833 .4549 L p .724 .986 .889 r
F P
0 g
s
.54695 .48631 m .54606 .47991 L .55677 .47353 L p .629 .962 .883 r
F P
0 g
s
.55677 .47353 m .55857 .48 L .54695 .48631 L p .629 .962 .883 r
F P
0 g
s
.56608 .46727 m .56886 .47379 L .55857 .48 L p .675 .976 .878 r
F P
0 g
s
.56886 .47379 m .56608 .46727 L .5747 .46108 L p .708 .985 .879 r
F P
0 g
s
.62363 .44247 m .616 .43576 L .6316 .42892 L p .643 .938 .964 r
F P
0 g
s
.6316 .42892 m .6401 .43568 L .62363 .44247 L p .643 .938 .964 r
F P
0 g
s
.55857 .48 m .55677 .47353 L .56608 .46727 L p .675 .976 .878 r
F P
0 g
s
.76083 .41065 m .74989 .40385 L .79296 .39414 L p .52 .866 .991 r
F P
0 g
s
.79296 .39414 m .80441 .40107 L .76083 .41065 L p .52 .866 .991 r
F P
0 g
s
.6401 .43568 m .6316 .42892 L .65079 .42171 L p .612 .92 .975 r
F P
0 g
s
.65079 .42171 m .66013 .42852 L .6401 .43568 L p .612 .92 .975 r
F P
0 g
s
.41728 .52292 m .42002 .51692 L .45174 .50889 L p .395 .847 .908 r
F P
0 g
s
.45174 .50889 m .44925 .51507 L .41728 .52292 L p .395 .847 .908 r
F P
0 g
s
.66013 .42852 m .65079 .42171 L .67439 .41402 L p .584 .904 .982 r
F P
0 g
s
.67439 .41402 m .6845 .42091 L .66013 .42852 L p .584 .904 .982 r
F P
0 g
s
.34012 .53391 m .33952 .53516 L .33779 .53456 L p .337 .81 .907 r
F P
0 g
s
.33952 .53516 m .34012 .53391 L .3829 .52527 L p .353 .82 .908 r
F P
0 g
s
.6845 .42091 m .67439 .41402 L .70329 .40574 L p .559 .89 .987 r
F P
0 g
s
.70329 .40574 m .7141 .41273 L .6845 .42091 L p .559 .89 .987 r
F P
0 g
s
.33779 .53456 m .33736 .53441 L .34012 .53391 L p .337 .81 .907 r
F P
0 g
s
.80441 .40107 m .79296 .39414 L p .81719 .39546 L .507 .858 .992 r
F P
0 g
s
.81719 .39546 m .81657 .39861 L .80441 .40107 L p .507 .858 .992 r
F P
0 g
s
.44925 .51507 m .45174 .50889 L .47843 .50117 L p .422 .863 .907 r
F P
0 g
s
.47843 .50117 m .47636 .50751 L .44925 .51507 L p .422 .863 .907 r
F P
0 g
s
.34012 .53391 m .33736 .53441 L .32981 .5318 L p .338 .811 .907 r
F P
0 g
s
.34295 .52802 m .34012 .53391 L p .32981 .5318 L .338 .811 .907 r
F P
0 g
s
.34012 .53391 m .34295 .52802 L .38587 .51913 L p .355 .822 .907 r
F P
0 g
s
.38587 .51913 m .3829 .52527 L .34012 .53391 L p .355 .822 .907 r
F P
0 g
s
.7141 .41273 m .70329 .40574 L .73846 .39675 L p .539 .878 .989 r
F P
0 g
s
.73846 .39675 m .74989 .40385 L .7141 .41273 L p .539 .878 .989 r
F P
0 g
s
.47636 .50751 m .47843 .50117 L .50054 .49377 L p .456 .883 .904 r
F P
0 g
s
.50054 .49377 m .49905 .50023 L .47636 .50751 L p .456 .883 .904 r
F P
0 g
s
.49905 .50023 m .50054 .49377 L .51862 .48665 L p .496 .904 .899 r
F P
0 g
s
.51862 .48665 m .51784 .49323 L .49905 .50023 L p .496 .904 .899 r
F P
0 g
s
.79296 .39414 m .81852 .38883 L .81719 .39546 L p .507 .858 .992 r
F P
0 g
s
.59622 .43532 m .60324 .44231 L .59258 .44867 L p .731 .979 .916 r
F P
0 g
s
.60324 .44231 m .59622 .43532 L .60802 .42873 L p .697 .963 .941 r
F P
0 g
s
.60802 .42873 m .616 .43576 L .60324 .44231 L p .697 .963 .941 r
F P
0 g
s
.74989 .40385 m .73846 .39675 L .78101 .3869 L p .523 .867 .991 r
F P
0 g
s
.78101 .3869 m .79296 .39414 L .74989 .40385 L p .523 .867 .991 r
F P
0 g
s
.58656 .44171 m .59258 .44867 L .5833 .4549 L p .753 .99 .889 r
F P
0 g
s
.59258 .44867 m .58656 .44171 L .59622 .43532 L p .731 .979 .916 r
F P
0 g
s
.616 .43576 m .60802 .42873 L .62269 .42184 L p .66 .945 .96 r
F P
0 g
s
.62269 .42184 m .6316 .42892 L .616 .43576 L p .66 .945 .96 r
F P
0 g
s
.57831 .44797 m .5833 .4549 L .5747 .46108 L p .756 .994 .867 r
F P
0 g
s
.5833 .4549 m .57831 .44797 L .58656 .44171 L p .753 .99 .889 r
F P
0 g
s
.51784 .49323 m .51862 .48665 L .53327 .47979 L p .544 .928 .891 r
F P
0 g
s
.53327 .47979 m .5333 .48646 L .51784 .49323 L p .544 .928 .891 r
F P
0 g
s
.3829 .52527 m .38587 .51913 L .42293 .51057 L p .374 .834 .907 r
F P
0 g
s
.42293 .51057 m .42002 .51692 L .3829 .52527 L p .374 .834 .907 r
F P
0 g
s
.57075 .45419 m .5747 .46108 L .56608 .46727 L p .739 .992 .855 r
F P
0 g
s
.5747 .46108 m .57075 .45419 L .57831 .44797 L p .756 .994 .867 r
F P
0 g
s
.6316 .42892 m .62269 .42184 L .64102 .41457 L p .625 .926 .973 r
F P
0 g
s
.64102 .41457 m .65079 .42171 L .6316 .42892 L p .625 .926 .973 r
F P
0 g
s
.56317 .46042 m .56608 .46727 L .55677 .47353 L p .703 .985 .856 r
F P
0 g
s
.56608 .46727 m .56317 .46042 L .57075 .45419 L p .739 .992 .855 r
F P
0 g
s
.5333 .48646 m .53327 .47979 L .54513 .47317 L p .598 .951 .879 r
F P
0 g
s
.54513 .47317 m .54606 .47991 L .5333 .48646 L p .598 .951 .879 r
F P
0 g
s
.55486 .46672 m .55677 .47353 L .54606 .47991 L p .653 .97 .867 r
F P
0 g
s
.55677 .47353 m .55486 .46672 L .56317 .46042 L p .703 .985 .856 r
F P
0 g
s
.54606 .47991 m .54513 .47317 L .55486 .46672 L p .653 .97 .867 r
F P
0 g
s
.65079 .42171 m .64102 .41457 L .66383 .40681 L p .593 .908 .981 r
F P
0 g
s
.66383 .40681 m .67439 .41402 L .65079 .42171 L p .593 .908 .981 r
F P
0 g
s
.67439 .41402 m .66383 .40681 L .692 .39845 L p .566 .893 .986 r
F P
0 g
s
.692 .39845 m .70329 .40574 L .67439 .41402 L p .566 .893 .986 r
F P
0 g
s
.32981 .5318 m .32725 .53096 L .34295 .52802 L p .338 .811 .907 r
F P
0 g
s
.79296 .39414 m .78101 .3869 L p .81991 .38169 L .51 .859 .992 r
F P
0 g
s
.81991 .38169 m .81852 .38883 L .79296 .39414 L p .51 .859 .992 r
F P
0 g
s
.42002 .51692 m .42293 .51057 L .45438 .50235 L p .398 .849 .907 r
F P
0 g
s
.45438 .50235 m .45174 .50889 L .42002 .51692 L p .398 .849 .907 r
F P
0 g
s
.70329 .40574 m .692 .39845 L .72653 .38934 L p .544 .88 .989 r
F P
0 g
s
.72653 .38934 m .73846 .39675 L .70329 .40574 L p .544 .88 .989 r
F P
0 g
s
.34295 .52802 m .32725 .53096 L .32155 .52901 L p .34 .812 .906 r
F P
0 g
s
.45174 .50889 m .45438 .50235 L .48062 .49447 L p .427 .867 .904 r
F P
0 g
s
.48062 .49447 m .47843 .50117 L .45174 .50889 L p .427 .867 .904 r
F P
0 g
s
.34596 .52176 m .34295 .52802 L p .32155 .52901 L .34 .812 .906 r
F P
0 g
s
.34295 .52802 m .34596 .52176 L .38903 .51262 L p .357 .823 .907 r
F P
0 g
s
.38903 .51262 m .38587 .51913 L .34295 .52802 L p .357 .823 .907 r
F P
0 g
s
.73846 .39675 m .72653 .38934 L .76853 .37935 L p .527 .869 .991 r
F P
0 g
s
.76853 .37935 m .78101 .3869 L .73846 .39675 L p .527 .869 .991 r
F P
0 g
s
.47843 .50117 m .48062 .49447 L .50213 .48692 L p .463 .887 .9 r
F P
0 g
s
.50213 .48692 m .50054 .49377 L .47843 .50117 L p .463 .887 .9 r
F P
0 g
s
.58885 .42798 m .59622 .43532 L .58656 .44171 L p .761 .987 .899 r
F P
0 g
s
.59622 .43532 m .58885 .42798 L .59964 .42135 L p .722 .971 .931 r
F P
0 g
s
.59964 .42135 m .60802 .42873 L .59622 .43532 L p .722 .971 .931 r
F P
0 g
s
.60802 .42873 m .59964 .42135 L .61335 .41442 L p .679 .952 .954 r
F P
0 g
s
.61335 .41442 m .62269 .42184 L .60802 .42873 L p .679 .952 .954 r
F P
0 g
s
.58024 .43439 m .58656 .44171 L .57831 .44797 L p .787 .996 .864 r
F P
0 g
s
.58656 .44171 m .58024 .43439 L .58885 .42798 L p .761 .987 .899 r
F P
0 g
s
.62269 .42184 m .61335 .41442 L .63079 .4071 L p .639 .931 .97 r
F P
0 g
s
.63079 .4071 m .64102 .41457 L .62269 .42184 L p .639 .931 .97 r
F P
0 g
s
.57306 .44069 m .57831 .44797 L .57075 .45419 L p .793 .999 .835 r
F P
0 g
s
.57831 .44797 m .57306 .44069 L .58024 .43439 L p .787 .996 .864 r
F P
0 g
s
.50054 .49377 m .50213 .48692 L .51946 .47969 L p .507 .91 .893 r
F P
0 g
s
.51946 .47969 m .51862 .48665 L .50054 .49377 L p .507 .91 .893 r
F P
0 g
s
.56659 .44693 m .57075 .45419 L .56317 .46042 L p .775 .997 .822 r
F P
0 g
s
.57075 .45419 m .56659 .44693 L .57306 .44069 L p .793 .999 .835 r
F P
0 g
s
.64102 .41457 m .63079 .4071 L .65277 .39927 L p .603 .912 .979 r
F P
0 g
s
.65277 .39927 m .66383 .40681 L .64102 .41457 L p .603 .912 .979 r
F P
0 g
s
.5601 .45319 m .56317 .46042 L .55486 .46672 L p .735 .991 .828 r
F P
0 g
s
.56317 .46042 m .5601 .45319 L .56659 .44693 L p .775 .997 .822 r
F P
0 g
s
.51862 .48665 m .51946 .47969 L .53324 .47275 L p .559 .935 .881 r
F P
0 g
s
.53324 .47275 m .53327 .47979 L .51862 .48665 L p .559 .935 .881 r
F P
0 g
s
.55285 .45955 m .55486 .46672 L .54513 .47317 L p .68 .978 .845 r
F P
0 g
s
.55486 .46672 m .55285 .45955 L .5601 .45319 L p .735 .991 .828 r
F P
0 g
s
.32155 .52901 m .31658 .5274 L .34596 .52176 L p .34 .812 .906 r
F P
0 g
s
.53327 .47979 m .53324 .47275 L .54414 .46604 L p .618 .959 .865 r
F P
0 g
s
.54414 .46604 m .54513 .47317 L .53327 .47979 L p .618 .959 .865 r
F P
0 g
s
.54513 .47317 m .54414 .46604 L .55285 .45955 L p .68 .978 .845 r
F P
0 g
s
.38587 .51913 m .38903 .51262 L .42601 .50384 L p .377 .836 .906 r
F P
0 g
s
.42601 .50384 m .42293 .51057 L .38587 .51913 L p .377 .836 .906 r
F P
0 g
s
.66383 .40681 m .65277 .39927 L .68019 .39082 L p .573 .896 .985 r
F P
0 g
s
.68019 .39082 m .692 .39845 L .66383 .40681 L p .573 .896 .985 r
F P
0 g
s
.78101 .3869 m .82054 .37849 L .81991 .38169 L p .51 .859 .992 r
F P
0 g
s
.78101 .3869 m .76853 .37935 L .81929 .36827 L p .512 .86 .992 r
F P
0 g
s
.82054 .37849 m .78101 .3869 L p .81929 .36827 L .512 .86 .992 r
F P
0 g
s
.692 .39845 m .68019 .39082 L .71406 .3816 L p .549 .882 .989 r
F P
0 g
s
.71406 .3816 m .72653 .38934 L .692 .39845 L p .549 .882 .989 r
F P
0 g
s
.42293 .51057 m .42601 .50384 L .45719 .49542 L p .402 .852 .905 r
F P
0 g
s
.45719 .49542 m .45438 .50235 L .42293 .51057 L p .402 .852 .905 r
F P
0 g
s
.81929 .36827 m .82218 .37 L .82054 .37849 L p .512 .86 .992 r
F P
0 g
s
.34596 .52176 m .31658 .5274 L .31303 .52619 L p .341 .814 .906 r
F P
0 g
s
.72653 .38934 m .71406 .3816 L .7555 .37145 L p .53 .871 .991 r
F P
0 g
s
.7555 .37145 m .76853 .37935 L .72653 .38934 L p .53 .871 .991 r
F P
0 g
s
.45438 .50235 m .45719 .49542 L .48295 .48737 L p .433 .87 .902 r
F P
0 g
s
.48295 .48737 m .48062 .49447 L .45438 .50235 L p .433 .87 .902 r
F P
0 g
s
.59084 .41361 m .59964 .42135 L .58885 .42798 L p .751 .979 .917 r
F P
0 g
s
.59964 .42135 m .59084 .41361 L .60356 .40664 L p .701 .959 .947 r
F P
0 g
s
.60356 .40664 m .61335 .41442 L .59964 .42135 L p .701 .959 .947 r
F P
0 g
s
.58111 .42026 m .58885 .42798 L .58024 .43439 L p .796 .993 .875 r
F P
0 g
s
.58885 .42798 m .58111 .42026 L .59084 .41361 L p .751 .979 .917 r
F P
0 g
s
.61335 .41442 m .60356 .40664 L .62006 .39927 L p .654 .937 .966 r
F P
0 g
s
.62006 .39927 m .63079 .4071 L .61335 .41442 L p .654 .937 .966 r
F P
0 g
s
.57359 .4267 m .58024 .43439 L .57306 .44069 L p .826 .999 .829 r
F P
0 g
s
.58024 .43439 m .57359 .4267 L .58111 .42026 L p .796 .993 .875 r
F P
0 g
s
.34916 .51511 m .34596 .52176 L p .31303 .52619 L .341 .814 .906 r
F P
0 g
s
.34596 .52176 m .34916 .51511 L .39239 .5057 L p .359 .825 .906 r
F P
0 g
s
.39239 .5057 m .38903 .51262 L .34596 .52176 L p .359 .825 .906 r
F P
0 g
s
.63079 .4071 m .62006 .39927 L .64118 .39137 L p .614 .917 .978 r
F P
0 g
s
.64118 .39137 m .65277 .39927 L .63079 .4071 L p .614 .917 .978 r
F P
0 g
s
.31303 .52619 m .3053 .52371 L .34916 .51511 L p .341 .814 .906 r
F P
0 g
s
.56754 .43301 m .57306 .44069 L .56659 .44693 L p .832 .999 .791 r
F P
0 g
s
.57306 .44069 m .56754 .43301 L .57359 .4267 L p .826 .999 .829 r
F P
0 g
s
.48062 .49447 m .48295 .48737 L .5038 .47968 L p .471 .892 .896 r
F P
0 g
s
.5038 .47968 m .50213 .48692 L .48062 .49447 L p .471 .892 .896 r
F P
0 g
s
.56221 .43928 m .56659 .44693 L .5601 .45319 L p .813 .997 .777 r
F P
0 g
s
.56659 .44693 m .56221 .43928 L .56754 .43301 L p .832 .999 .791 r
F P
0 g
s
.76853 .37935 m .7555 .37145 L .80581 .36019 L p .515 .861 .992 r
F P
0 g
s
.80581 .36019 m .81929 .36827 L .76853 .37935 L p .515 .861 .992 r
F P
0 g
s
.65277 .39927 m .64118 .39137 L .66783 .38283 L p .581 .9 .985 r
F P
0 g
s
.66783 .38283 m .68019 .39082 L .65277 .39927 L p .581 .9 .985 r
F P
0 g
s
.55686 .44557 m .5601 .45319 L .55285 .45955 L p .77 .994 .788 r
F P
0 g
s
.5601 .45319 m .55686 .44557 L .56221 .43928 L p .813 .997 .777 r
F P
0 g
s
.50213 .48692 m .5038 .47968 L .52034 .47233 L p .518 .916 .886 r
F P
0 g
s
.52034 .47233 m .51946 .47969 L .50213 .48692 L p .518 .916 .886 r
F P
0 g
s
.55073 .45197 m .55285 .45955 L .54414 .46604 L p .709 .984 .816 r
F P
0 g
s
.55285 .45955 m .55073 .45197 L .55686 .44557 L p .77 .994 .788 r
F P
0 g
s
.51946 .47969 m .52034 .47233 L .53321 .46529 L p .576 .942 .869 r
F P
0 g
s
.53321 .46529 m .53324 .47275 L .51946 .47969 L p .576 .942 .869 r
F P
0 g
s
.5431 .45852 m .54414 .46604 L .53324 .47275 L p .641 .966 .846 r
F P
0 g
s
.54414 .46604 m .5431 .45852 L .55073 .45197 L p .709 .984 .816 r
F P
0 g
s
.53324 .47275 m .53321 .46529 L .5431 .45852 L p .641 .966 .846 r
F P
0 g
s
.68019 .39082 m .66783 .38283 L .70101 .37349 L p .555 .885 .989 r
F P
0 g
s
.70101 .37349 m .71406 .3816 L .68019 .39082 L p .555 .885 .989 r
F P
0 g
s
.82218 .37 m .81929 .36827 L .82266 .36759 L closepath p .5 .854 .992 r
F P
0 g
s
.38903 .51262 m .39239 .5057 L .4293 .49667 L p .38 .839 .905 r
F P
0 g
s
.4293 .49667 m .42601 .50384 L .38903 .51262 L p .38 .839 .905 r
F P
0 g
s
.81929 .36827 m .80581 .36019 L p .82283 .36673 L .503 .854 .993 r
F P
0 g
s
.82283 .36673 m .82266 .36759 L .81929 .36827 L p .503 .854 .993 r
F P
0 g
s
.71406 .3816 m .70101 .37349 L .74187 .36319 L p .534 .873 .991 r
F P
0 g
s
.74187 .36319 m .7555 .37145 L .71406 .3816 L p .534 .873 .991 r
F P
0 g
s
.80581 .36019 m .82492 .35623 L .82283 .36673 L p .503 .854 .993 r
F P
0 g
s
.34916 .51511 m .3053 .52371 L .30422 .52335 L p .343 .815 .905 r
F P
0 g
s
.42601 .50384 m .4293 .49667 L .46016 .48804 L p .406 .855 .903 r
F P
0 g
s
.46016 .48804 m .45719 .49542 L .42601 .50384 L p .406 .855 .903 r
F P
0 g
s
.30422 .52335 m .30061 .52221 L p .35257 .50801 L .343 .815 .905 r
F P
0 g
s
.35257 .50801 m .34916 .51511 L p .30422 .52335 L .343 .815 .905 r
F P
0 g
s
.58159 .40546 m .59084 .41361 L .58111 .42026 L p .782 .986 .898 r
F P
0 g
s
.59084 .41361 m .58159 .40546 L .59327 .39847 L p .725 .966 .937 r
F P
0 g
s
.59327 .39847 m .60356 .40664 L .59084 .41361 L p .725 .966 .937 r
F P
0 g
s
.60356 .40664 m .59327 .39847 L .6088 .39105 L p .671 .944 .961 r
F P
0 g
s
.6088 .39105 m .62006 .39927 L .60356 .40664 L p .671 .944 .961 r
F P
0 g
s
.57296 .41214 m .58111 .42026 L .57359 .4267 L p .834 .996 .842 r
F P
0 g
s
.58111 .42026 m .57296 .41214 L .58159 .40546 L p .782 .986 .898 r
F P
0 g
s
.62006 .39927 m .6088 .39105 L .62903 .38309 L p .626 .922 .976 r
F P
0 g
s
.62903 .38309 m .64118 .39137 L .62006 .39927 L p .626 .922 .976 r
F P
0 g
s
.56659 .4186 m .57359 .4267 L .56754 .43301 L p .867 .995 .779 r
F P
0 g
s
.57359 .4267 m .56659 .4186 L .57296 .41214 L p .834 .996 .842 r
F P
0 g
s
.7555 .37145 m .74187 .36319 L .79171 .35175 L p .518 .863 .992 r
F P
0 g
s
.79171 .35175 m .80581 .36019 L .7555 .37145 L p .518 .863 .992 r
F P
0 g
s
.45719 .49542 m .46016 .48804 L .48542 .47982 L p .439 .874 .898 r
F P
0 g
s
.48542 .47982 m .48295 .48737 L .45719 .49542 L p .439 .874 .898 r
F P
0 g
s
.56172 .42492 m .56754 .43301 L .56221 .43928 L p .873 .989 .728 r
F P
0 g
s
.56754 .43301 m .56172 .42492 L .56659 .4186 L p .867 .995 .779 r
F P
0 g
s
.64118 .39137 m .62903 .38309 L .65487 .37445 L p .59 .903 .984 r
F P
0 g
s
.65487 .37445 m .66783 .38283 L .64118 .39137 L p .59 .903 .984 r
F P
0 g
s
.55759 .43121 m .56221 .43928 L .55686 .44557 L p .853 .987 .712 r
F P
0 g
s
.56221 .43928 m .55759 .43121 L .56172 .42492 L p .873 .989 .728 r
F P
0 g
s
.30061 .52221 m .30243 .51809 L .35257 .50801 L p .343 .815 .905 r
F P
0 g
s
.48295 .48737 m .48542 .47982 L .50558 .47198 L p .48 .897 .891 r
F P
0 g
s
.50558 .47198 m .5038 .47968 L .48295 .48737 L p .48 .897 .891 r
F P
0 g
s
.34916 .51511 m .35257 .50801 L .39597 .49832 L p .361 .827 .905 r
F P
0 g
s
.39597 .49832 m .39239 .5057 L .34916 .51511 L p .361 .827 .905 r
F P
0 g
s
.55343 .43752 m .55686 .44557 L .55073 .45197 L p .807 .989 .733 r
F P
0 g
s
.55686 .44557 m .55343 .43752 L .55759 .43121 L p .853 .987 .712 r
F P
0 g
s
.66783 .38283 m .65487 .37445 L .68734 .365 L p .561 .887 .988 r
F P
0 g
s
.68734 .365 m .70101 .37349 L .66783 .38283 L p .561 .887 .988 r
F P
0 g
s
.54849 .44395 m .55073 .45197 L .5431 .45852 L p .742 .987 .776 r
F P
0 g
s
.55073 .45197 m .54849 .44395 L .55343 .43752 L p .807 .989 .733 r
F P
0 g
s
.5038 .47968 m .50558 .47198 L .52127 .46452 L p .531 .923 .877 r
F P
0 g
s
.52127 .46452 m .52034 .47233 L .5038 .47968 L p .531 .923 .877 r
F P
0 g
s
.54199 .45055 m .5431 .45852 L .53321 .46529 L p .668 .973 .821 r
F P
0 g
s
.5431 .45852 m .54199 .45055 L .54849 .44395 L p .742 .987 .776 r
F P
0 g
s
.52034 .47233 m .52127 .46452 L .53317 .45739 L p .595 .95 .855 r
F P
0 g
s
.53317 .45739 m .53321 .46529 L .52034 .47233 L p .595 .95 .855 r
F P
0 g
s
.53321 .46529 m .53317 .45739 L .54199 .45055 L p .668 .973 .821 r
F P
0 g
s
.80581 .36019 m .79171 .35175 L p .82595 .35094 L .505 .855 .993 r
F P
0 g
s
.82595 .35094 m .82492 .35623 L .80581 .36019 L p .505 .855 .993 r
F P
0 g
s
.70101 .37349 m .68734 .365 L .72759 .35455 L p .539 .875 .991 r
F P
0 g
s
.72759 .35455 m .74187 .36319 L .70101 .37349 L p .539 .875 .991 r
F P
0 g
s
.39239 .5057 m .39597 .49832 L .43279 .48904 L p .383 .841 .904 r
F P
0 g
s
.43279 .48904 m .4293 .49667 L .39239 .5057 L p .383 .841 .904 r
F P
0 g
s
.74187 .36319 m .72759 .35455 L .77696 .3429 L p .521 .864 .992 r
F P
0 g
s
.77696 .3429 m .79171 .35175 L .74187 .36319 L p .521 .864 .992 r
F P
0 g
s
.58245 .38987 m .59327 .39847 L .58159 .40546 L p .752 .974 .924 r
F P
0 g
s
.59327 .39847 m .58245 .38987 L .59697 .38241 L p .691 .951 .955 r
F P
0 g
s
.59697 .38241 m .6088 .39105 L .59327 .39847 L p .691 .951 .955 r
F P
0 g
s
.57185 .39689 m .58159 .40546 L .57296 .41214 L p .818 .991 .872 r
F P
0 g
s
.58159 .40546 m .57185 .39689 L .58245 .38987 L p .752 .974 .924 r
F P
0 g
s
.6088 .39105 m .59697 .38241 L .61626 .37439 L p .64 .927 .973 r
F P
0 g
s
.61626 .37439 m .62903 .38309 L .6088 .39105 L p .64 .927 .973 r
F P
0 g
s
.56437 .40358 m .57296 .41214 L .56659 .4186 L p .876 .993 .795 r
F P
0 g
s
.57296 .41214 m .56437 .40358 L .57185 .39689 L p .818 .991 .872 r
F P
0 g
s
.30243 .51809 m .30561 .51086 L .35621 .50044 L p .345 .816 .904 r
F P
0 g
s
.35621 .50044 m .35257 .50801 L .30243 .51809 L p .345 .816 .904 r
F P
0 g
s
.4293 .49667 m .43279 .48904 L .46333 .48019 L p .411 .858 .901 r
F P
0 g
s
.46333 .48019 m .46016 .48804 L .4293 .49667 L p .411 .858 .901 r
F P
0 g
s
.5592 .41005 m .56659 .4186 L .56172 .42492 L p .909 .979 .707 r
F P
0 g
s
.56659 .4186 m .5592 .41005 L .56437 .40358 L p .876 .993 .795 r
F P
0 g
s
.62903 .38309 m .61626 .37439 L .64127 .36566 L p .599 .907 .982 r
F P
0 g
s
.64127 .36566 m .65487 .37445 L .62903 .38309 L p .599 .907 .982 r
F P
0 g
s
.79171 .35175 m .82728 .34419 L .82595 .35094 L p .505 .855 .993 r
F P
0 g
s
.55557 .41638 m .56172 .42492 L .55759 .43121 L p .911 .961 .639 r
F P
0 g
s
.56172 .42492 m .55557 .41638 L .5592 .41005 L p .909 .979 .707 r
F P
0 g
s
.65487 .37445 m .64127 .36566 L .673 .35609 L p .567 .89 .988 r
F P
0 g
s
.673 .35609 m .68734 .365 L .65487 .37445 L p .567 .89 .988 r
F P
0 g
s
.5527 .42267 m .55759 .43121 L .55343 .43752 L p .889 .958 .62 r
F P
0 g
s
.55759 .43121 m .5527 .42267 L .55557 .41638 L p .911 .961 .639 r
F P
0 g
s
.46016 .48804 m .46333 .48019 L .48805 .47179 L p .445 .878 .895 r
F P
0 g
s
.48805 .47179 m .48542 .47982 L .46016 .48804 L p .445 .878 .895 r
F P
0 g
s
.54981 .42901 m .55343 .43752 L .54849 .44395 L p .844 .971 .655 r
F P
0 g
s
.55343 .43752 m .54981 .42901 L .5527 .42267 L p .889 .958 .62 r
F P
0 g
s
.79171 .35175 m .77696 .3429 L p .82934 .33354 L .507 .856 .993 r
F P
0 g
s
.82934 .33354 m .82728 .34419 L .79171 .35175 L p .507 .856 .993 r
F P
0 g
s
.48542 .47982 m .48805 .47179 L .50748 .46381 L p .489 .902 .885 r
F P
0 g
s
.50748 .46381 m .50558 .47198 L .48542 .47982 L p .489 .902 .885 r
F P
0 g
s
.54612 .43546 m .54849 .44395 L .54199 .45055 L p .777 .982 .721 r
F P
0 g
s
.54849 .44395 m .54612 .43546 L .54981 .42901 L p .844 .971 .655 r
F P
0 g
s
.68734 .365 m .673 .35609 L .71263 .34548 L p .543 .877 .991 r
F P
0 g
s
.71263 .34548 m .72759 .35455 L .68734 .365 L p .543 .877 .991 r
F P
0 g
s
.35257 .50801 m .35621 .50044 L .39979 .49044 L p .364 .828 .904 r
F P
0 g
s
.39979 .49044 m .39597 .49832 L .35257 .50801 L p .364 .828 .904 r
F P
0 g
s
.54082 .44211 m .54199 .45055 L .53317 .45739 L p .697 .977 .787 r
F P
0 g
s
.54199 .45055 m .54082 .44211 L .54612 .43546 L p .777 .982 .721 r
F P
0 g
s
.50558 .47198 m .50748 .46381 L .52227 .45623 L p .546 .929 .867 r
F P
0 g
s
.52227 .45623 m .52127 .46452 L .50558 .47198 L p .546 .929 .867 r
F P
0 g
s
.53313 .44901 m .53317 .45739 L .52127 .46452 L p .616 .957 .836 r
F P
0 g
s
.53317 .45739 m .53313 .44901 L .54082 .44211 L p .697 .977 .787 r
F P
0 g
s
.52127 .46452 m .52227 .45623 L .53313 .44901 L p .616 .957 .836 r
F P
0 g
s
.72759 .35455 m .71263 .34548 L .7615 .33364 L p .524 .866 .992 r
F P
0 g
s
.7615 .33364 m .77696 .3429 L .72759 .35455 L p .524 .866 .992 r
F P
0 g
s
.57105 .38082 m .58245 .38987 L .57185 .39689 L p .783 .98 .907 r
F P
0 g
s
.58245 .38987 m .57105 .38082 L .58452 .37332 L p .713 .957 .948 r
F P
0 g
s
.58452 .37332 m .59697 .38241 L .58245 .38987 L p .713 .957 .948 r
F P
0 g
s
.59697 .38241 m .58452 .37332 L .60285 .36524 L p .655 .933 .969 r
F P
0 g
s
.60285 .36524 m .61626 .37439 L .59697 .38241 L p .655 .933 .969 r
F P
0 g
s
.56159 .38785 m .57185 .39689 L .56437 .40358 L p .858 .991 .835 r
F P
0 g
s
.57185 .39689 m .56159 .38785 L .57105 .38082 L p .783 .98 .907 r
F P
0 g
s
.39597 .49832 m .39979 .49044 L .43652 .48089 L p .387 .843 .902 r
F P
0 g
s
.43652 .48089 m .43279 .48904 L .39597 .49832 L p .387 .843 .902 r
F P
0 g
s
.5553 .39455 m .56437 .40358 L .5592 .41005 L p .918 .978 .728 r
F P
0 g
s
.56437 .40358 m .5553 .39455 L .56159 .38785 L p .858 .991 .835 r
F P
0 g
s
.61626 .37439 m .60285 .36524 L .62698 .35643 L p .609 .911 .981 r
F P
0 g
s
.62698 .35643 m .64127 .36566 L .61626 .37439 L p .609 .911 .981 r
F P
0 g
s
.55139 .40102 m .5592 .41005 L .55557 .41638 L p .944 .941 .606 r
F P
0 g
s
.5592 .41005 m .55139 .40102 L .5553 .39455 L p .918 .978 .728 r
F P
0 g
s
.64127 .36566 m .62698 .35643 L .65795 .34674 L p .574 .893 .987 r
F P
0 g
s
.65795 .34674 m .673 .35609 L .64127 .36566 L p .574 .893 .987 r
F P
0 g
s
.54906 .40735 m .55557 .41638 L .5527 .42267 L p .936 .905 .514 r
F P
0 g
s
.55557 .41638 m .54906 .40735 L .55139 .40102 L p .944 .941 .606 r
F P
0 g
s
.77696 .3429 m .82976 .33141 L .82934 .33354 L p .507 .856 .993 r
F P
0 g
s
.77696 .3429 m .7615 .33364 L .8212 .3203 L p .51 .857 .993 r
F P
0 g
s
.82976 .33141 m .77696 .3429 L p .8212 .3203 L .51 .857 .993 r
F P
0 g
s
.43279 .48904 m .43652 .48089 L .46672 .47182 L p .415 .861 .898 r
F P
0 g
s
.46672 .47182 m .46333 .48019 L .43279 .48904 L p .415 .861 .898 r
F P
0 g
s
.30561 .51086 m .30902 .50312 L .36011 .49233 L p .347 .818 .904 r
F P
0 g
s
.36011 .49233 m .35621 .50044 L .30561 .51086 L p .347 .818 .904 r
F P
0 g
s
.54752 .41364 m .5527 .42267 L .54981 .42901 L p .911 .9 .492 r
F P
0 g
s
.5527 .42267 m .54752 .41364 L .54906 .40735 L p .936 .905 .514 r
F P
0 g
s
.673 .35609 m .65795 .34674 L .69693 .33597 L p .548 .879 .99 r
F P
0 g
s
.69693 .33597 m .71263 .34548 L .673 .35609 L p .548 .879 .99 r
F P
0 g
s
.54597 .41998 m .54981 .42901 L .54612 .43546 L p .873 .929 .546 r
F P
0 g
s
.54981 .42901 m .54597 .41998 L .54752 .41364 L p .911 .9 .492 r
F P
0 g
s
.46333 .48019 m .46672 .47182 L .49085 .46322 L p .452 .882 .891 r
F P
0 g
s
.49085 .46322 m .48805 .47179 L .46333 .48019 L p .452 .882 .891 r
F P
0 g
s
.5436 .42645 m .54612 .43546 L .54082 .44211 L p .812 .964 .644 r
F P
0 g
s
.54612 .43546 m .5436 .42645 L .54597 .41998 L p .873 .929 .546 r
F P
0 g
s
.48805 .47179 m .49085 .46322 L .50949 .45509 L p .5 .908 .878 r
F P
0 g
s
.50949 .45509 m .50748 .46381 L .48805 .47179 L p .5 .908 .878 r
F P
0 g
s
.53958 .43313 m .54082 .44211 L .53313 .44901 L p .728 .976 .741 r
F P
0 g
s
.54082 .44211 m .53958 .43313 L .5436 .42645 L p .812 .964 .644 r
F P
0 g
s
.71263 .34548 m .69693 .33597 L .74528 .32392 L p .528 .867 .992 r
F P
0 g
s
.74528 .32392 m .7615 .33364 L .71263 .34548 L p .528 .867 .992 r
F P
0 g
s
.8212 .3203 m .83078 .32607 L .82976 .33141 L p .51 .857 .993 r
F P
0 g
s
.53309 .44009 m .53313 .44901 L .52227 .45623 L p .64 .963 .811 r
F P
0 g
s
.53313 .44901 m .53309 .44009 L .53958 .43313 L p .728 .976 .741 r
F P
0 g
s
.50748 .46381 m .50949 .45509 L .52333 .4474 L p .562 .936 .854 r
F P
0 g
s
.52333 .4474 m .52227 .45623 L .50748 .46381 L p .562 .936 .854 r
F P
0 g
s
.52227 .45623 m .52333 .4474 L .53309 .44009 L p .64 .963 .811 r
F P
0 g
s
.35621 .50044 m .36011 .49233 L .40388 .482 L p .366 .83 .903 r
F P
0 g
s
.40388 .482 m .39979 .49044 L .35621 .50044 L p .366 .83 .903 r
F P
0 g
s
.55903 .37127 m .57105 .38082 L .56159 .38785 L p .818 .985 .883 r
F P
0 g
s
.57105 .38082 m .55903 .37127 L .5714 .36374 L p .738 .964 .937 r
F P
0 g
s
.5714 .36374 m .58452 .37332 L .57105 .38082 L p .738 .964 .937 r
F P
0 g
s
.58452 .37332 m .5714 .36374 L .58872 .35561 L p .671 .939 .965 r
F P
0 g
s
.58872 .35561 m .60285 .36524 L .58452 .37332 L p .671 .939 .965 r
F P
0 g
s
.55075 .37831 m .56159 .38785 L .5553 .39455 L p .9 .985 .784 r
F P
0 g
s
.56159 .38785 m .55075 .37831 L .55903 .37127 L p .818 .985 .883 r
F P
0 g
s
.60285 .36524 m .58872 .35561 L .61195 .34672 L p .62 .916 .979 r
F P
0 g
s
.61195 .34672 m .62698 .35643 L .60285 .36524 L p .62 .916 .979 r
F P
0 g
s
.54572 .38501 m .5553 .39455 L .55139 .40102 L p .954 .944 .633 r
F P
0 g
s
.5553 .39455 m .54572 .38501 L .55075 .37831 L p .9 .985 .784 r
F P
0 g
s
.62698 .35643 m .61195 .34672 L .64212 .33691 L p .582 .897 .986 r
F P
0 g
s
.64212 .33691 m .65795 .34674 L .62698 .35643 L p .582 .897 .986 r
F P
0 g
s
.7615 .33364 m .74528 .32392 L .80462 .31032 L p .512 .858 .993 r
F P
0 g
s
.80462 .31032 m .8212 .3203 L .7615 .33364 L p .512 .858 .993 r
F P
0 g
s
.54313 .39146 m .55139 .40102 L .54906 .40735 L p .96 .869 .466 r
F P
0 g
s
.55139 .40102 m .54313 .39146 L .54572 .38501 L p .954 .944 .633 r
F P
0 g
s
.39979 .49044 m .40388 .482 L .44051 .47217 L p .39 .846 .9 r
F P
0 g
s
.44051 .47217 m .43652 .48089 L .39979 .49044 L p .39 .846 .9 r
F P
0 g
s
.54217 .39778 m .54906 .40735 L .54752 .41364 L p .934 .807 .347 r
F P
0 g
s
.54906 .40735 m .54217 .39778 L .54313 .39146 L p .96 .869 .466 r
F P
0 g
s
.65795 .34674 m .64212 .33691 L .68043 .32598 L p .553 .881 .99 r
F P
0 g
s
.68043 .32598 m .69693 .33597 L .65795 .34674 L p .553 .881 .99 r
F P
0 g
s
.54204 .40406 m .54752 .41364 L .54597 .41998 L p .907 .801 .323 r
F P
0 g
s
.54752 .41364 m .54204 .40406 L .54217 .39778 L p .934 .807 .347 r
F P
0 g
s
.43652 .48089 m .44051 .47217 L .47033 .46286 L p .421 .864 .895 r
F P
0 g
s
.47033 .46286 m .46672 .47182 L .43652 .48089 L p .421 .864 .895 r
F P
0 g
s
.5419 .41039 m .54597 .41998 L .5436 .42645 L p .883 .853 .398 r
F P
0 g
s
.54597 .41998 m .5419 .41039 L .54204 .40406 L p .907 .801 .323 r
F P
0 g
s
.30902 .50312 m .31269 .49481 L .36429 .48363 L p .349 .819 .903 r
F P
0 g
s
.36429 .48363 m .36011 .49233 L .30902 .50312 L p .349 .819 .903 r
F P
0 g
s
.69693 .33597 m .68043 .32598 L .72824 .31371 L p .531 .869 .992 r
F P
0 g
s
.72824 .31371 m .74528 .32392 L .69693 .33597 L p .531 .869 .992 r
F P
0 g
s
.54092 .41688 m .5436 .42645 L .53958 .43313 L p .839 .925 .537 r
F P
0 g
s
.5436 .42645 m .54092 .41688 L .5419 .41039 L p .883 .853 .398 r
F P
0 g
s
.46672 .47182 m .47033 .46286 L .49384 .45407 L p .46 .887 .886 r
F P
0 g
s
.49384 .45407 m .49085 .46322 L .46672 .47182 L p .46 .887 .886 r
F P
0 g
s
.53826 .42358 m .53958 .43313 L .53309 .44009 L p .761 .967 .678 r
F P
0 g
s
.53958 .43313 m .53826 .42358 L .54092 .41688 L p .839 .925 .537 r
F P
0 g
s
.49085 .46322 m .49384 .45407 L .51164 .44579 L p .512 .914 .869 r
F P
0 g
s
.51164 .44579 m .50949 .45509 L .49085 .46322 L p .512 .914 .869 r
F P
0 g
s
.55756 .35363 m .5714 .36374 L .55903 .37127 L p .765 .971 .924 r
F P
0 g
s
.5714 .36374 m .55756 .35363 L .57383 .34546 L p .69 .945 .96 r
F P
0 g
s
.57383 .34546 m .58872 .35561 L .5714 .36374 L p .69 .945 .96 r
F P
0 g
s
.53305 .4306 m .53309 .44009 L .52333 .4474 L p .666 .966 .778 r
F P
0 g
s
.53309 .44009 m .53305 .4306 L .53826 .42358 L p .761 .967 .678 r
F P
0 g
s
.54634 .36118 m .55903 .37127 L .55075 .37831 L p .856 .986 .85 r
F P
0 g
s
.55903 .37127 m .54634 .36118 L .55756 .35363 L p .765 .971 .924 r
F P
0 g
s
.50949 .45509 m .51164 .44579 L .52445 .43798 L p .58 .943 .837 r
F P
0 g
s
.52445 .43798 m .52333 .4474 L .50949 .45509 L p .58 .943 .837 r
F P
0 g
s
.58872 .35561 m .57383 .34546 L .59612 .33649 L p .632 .921 .977 r
F P
0 g
s
.59612 .33649 m .61195 .34672 L .58872 .35561 L p .632 .921 .977 r
F P
0 g
s
.52333 .4474 m .52445 .43798 L .53305 .4306 L p .666 .966 .778 r
F P
0 g
s
.5393 .36823 m .55075 .37831 L .54572 .38501 L p .941 .964 .71 r
F P
0 g
s
.55075 .37831 m .5393 .36823 L .54634 .36118 L p .856 .986 .85 r
F P
0 g
s
.74528 .32392 m .72824 .31371 L .78721 .29983 L p .515 .859 .993 r
F P
0 g
s
.78721 .29983 m .80462 .31032 L .74528 .32392 L p .515 .859 .993 r
F P
0 g
s
.61195 .34672 m .59612 .33649 L .62547 .32656 L p .59 .9 .985 r
F P
0 g
s
.62547 .32656 m .64212 .33691 L .61195 .34672 L p .59 .9 .985 r
F P
0 g
s
.53558 .37491 m .54572 .38501 L .54313 .39146 L p .975 .877 .501 r
F P
0 g
s
.54572 .38501 m .53558 .37491 L .5393 .36823 L p .941 .964 .71 r
F P
0 g
s
.36011 .49233 m .36429 .48363 L .40827 .47295 L p .369 .832 .902 r
F P
0 g
s
.40827 .47295 m .40388 .482 L .36011 .49233 L p .369 .832 .902 r
F P
0 g
s
.53438 .38134 m .54313 .39146 L .54217 .39778 L p .944 .752 .285 r
F P
0 g
s
.54313 .39146 m .53438 .38134 L .53558 .37491 L p .975 .877 .501 r
F P
0 g
s
.64212 .33691 m .62547 .32656 L .66307 .31547 L p .559 .884 .99 r
F P
0 g
s
.66307 .31547 m .68043 .32598 L .64212 .33691 L p .559 .884 .99 r
F P
0 g
s
.53486 .38763 m .54217 .39778 L .54204 .40406 L p .892 .663 .147 r
F P
0 g
s
.54217 .39778 m .53486 .38763 L .53438 .38134 L p .944 .752 .285 r
F P
0 g
s
.40388 .482 m .40827 .47295 L .44479 .46282 L p .394 .848 .899 r
F P
0 g
s
.44479 .46282 m .44051 .47217 L .40388 .482 L p .394 .848 .899 r
F P
0 g
s
.53621 .39388 m .54204 .40406 L .5419 .41039 L p .863 .654 .121 r
F P
0 g
s
.54204 .40406 m .53621 .39388 L .53486 .38763 L p .892 .663 .147 r
F P
0 g
s
.68043 .32598 m .66307 .31547 L .71033 .30298 L p .535 .871 .992 r
F P
0 g
s
.71033 .30298 m .72824 .31371 L .68043 .32598 L p .535 .871 .992 r
F P
0 g
s
.53756 .4002 m .5419 .41039 L .54092 .41688 L p .86 .731 .211 r
F P
0 g
s
.5419 .41039 m .53756 .4002 L .53621 .39388 L p .863 .654 .121 r
F P
0 g
s
.44051 .47217 m .44479 .46282 L .47421 .45327 L p .426 .868 .892 r
F P
0 g
s
.47421 .45327 m .47033 .46286 L .44051 .47217 L p .426 .868 .892 r
F P
0 g
s
.53807 .40668 m .54092 .41688 L .53826 .42358 L p .849 .851 .392 r
F P
0 g
s
.54092 .41688 m .53807 .40668 L .53756 .4002 L p .86 .731 .211 r
F P
0 g
s
.54293 .34296 m .55756 .35363 L .54634 .36118 L p .797 .976 .905 r
F P
0 g
s
.55756 .35363 m .54293 .34296 L .55811 .33474 L p .711 .952 .953 r
F P
0 g
s
.55811 .33474 m .57383 .34546 L .55756 .35363 L p .711 .952 .953 r
F P
0 g
s
.31269 .49481 m .31662 .48587 L .36879 .47426 L p .351 .821 .902 r
F P
0 g
s
.36879 .47426 m .36429 .48363 L .31269 .49481 L p .351 .821 .902 r
F P
0 g
s
.53291 .35051 m .54634 .36118 L .5393 .36823 L p .898 .98 .803 r
F P
0 g
s
.54634 .36118 m .53291 .35051 L .54293 .34296 L p .797 .976 .905 r
F P
0 g
s
.57383 .34546 m .55811 .33474 L .57942 .3257 L p .646 .926 .974 r
F P
0 g
s
.57942 .3257 m .59612 .33649 L .57383 .34546 L p .646 .926 .974 r
F P
0 g
s
.72824 .31371 m .71033 .30298 L .76891 .28881 L p .517 .861 .993 r
F P
0 g
s
.76891 .28881 m .78721 .29983 L .72824 .31371 L p .517 .861 .993 r
F P
0 g
s
.53684 .4134 m .53826 .42358 L .53305 .4306 L p .79 .941 .59 r
F P
0 g
s
.53826 .42358 m .53684 .4134 L .53807 .40668 L p .849 .851 .392 r
F P
0 g
s
.47033 .46286 m .47421 .45327 L .49705 .44428 L p .468 .892 .881 r
F P
0 g
s
.49705 .44428 m .49384 .45407 L .47033 .46286 L p .468 .892 .881 r
F P
0 g
s
.52716 .35755 m .5393 .36823 L .53558 .37491 L p .974 .92 .606 r
F P
0 g
s
.5393 .36823 m .52716 .35755 L .53291 .35051 L p .898 .98 .803 r
F P
0 g
s
.59612 .33649 m .57942 .3257 L .60791 .31565 L p .599 .904 .984 r
F P
0 g
s
.60791 .31565 m .62547 .32656 L .59612 .33649 L p .599 .904 .984 r
F P
0 g
s
.533 .42046 m .53305 .4306 L .52445 .43798 L p .695 .966 .734 r
F P
0 g
s
.53305 .4306 m .533 .42046 L .53684 .4134 L p .79 .941 .59 r
F P
0 g
s
.49384 .45407 m .49705 .44428 L .51395 .43584 L p .525 .92 .859 r
F P
0 g
s
.51395 .43584 m .51164 .44579 L .49384 .45407 L p .525 .92 .859 r
F P
0 g
s
.52483 .3642 m .53558 .37491 L .53438 .38134 L p .965 .768 .328 r
F P
0 g
s
.53558 .37491 m .52483 .3642 L .52716 .35755 L p .974 .92 .606 r
F P
0 g
s
.52566 .42791 m .52445 .43798 L .51164 .44579 L p .601 .949 .816 r
F P
0 g
s
.52445 .43798 m .52566 .42791 L .533 .42046 L p .695 .966 .734 r
F P
0 g
s
.51164 .44579 m .51395 .43584 L .52566 .42791 L p .601 .949 .816 r
F P
0 g
s
.62547 .32656 m .60791 .31565 L .64479 .3044 L p .564 .886 .989 r
F P
0 g
s
.64479 .3044 m .66307 .31547 L .62547 .32656 L p .564 .886 .989 r
F P
0 g
s
.52509 .37059 m .53438 .38134 L .53486 .38763 L p .883 .592 .077 r
F P
0 g
s
.53438 .38134 m .52509 .37059 L .52483 .3642 L p .965 .768 .328 r
F P
0 g
s
.36429 .48363 m .36879 .47426 L .41299 .46322 L p .372 .834 .9 r
F P
0 g
s
.41299 .46322 m .40827 .47295 L .36429 .48363 L p .372 .834 .9 r
F P
0 g
s
.52709 .37684 m .53486 .38763 L .53621 .39388 L p .805 .483 0 r
F P
0 g
s
.53486 .38763 m .52709 .37684 L .52509 .37059 L p .883 .592 .077 r
F P
0 g
s
.66307 .31547 m .64479 .3044 L .69148 .29168 L p .539 .873 .992 r
F P
0 g
s
.69148 .29168 m .71033 .30298 L .66307 .31547 L p .539 .873 .992 r
F P
0 g
s
.53621 .39388 m .53756 .4002 L p .53277 .38933 L .776 .474 0 r
F P
0 g
s
.53179 .38616 m .53621 .39388 L p .53277 .38933 L .776 .474 0 r
F P
0 g
s
.53 .38305 m .53179 .38616 L p .53277 .38933 L .776 .474 0 r
F P
0 g
s
.53756 .4002 m .53294 .38933 L .53 .38305 L p .776 .474 0 r
F P
0 g
s
.53756 .4002 m .53807 .40668 L p .53569 .39863 L .796 .567 .002 r
F P
0 g
s
.53294 .38933 m .53558 .39553 L p .53569 .39863 L .796 .567 .002 r
F P
0 g
s
.53558 .39553 m .53756 .4002 L p .53569 .39863 L .796 .567 .002 r
F P
0 g
s
.53502 .39579 m .53294 .38933 L p .53625 .40054 L .796 .567 .002 r
F P
0 g
s
.53534 .40252 m .53502 .39579 L p .53589 .4042 L .829 .734 .21 r
F P
0 g
s
.53684 .4134 m .53601 .40737 L p .53589 .4042 L .829 .734 .21 r
F P
0 g
s
.53601 .40737 m .53534 .40252 L p .53589 .4042 L .829 .734 .21 r
F P
0 g
s
.53807 .40668 m .53723 .40369 L p .53625 .40054 L .796 .567 .002 r
F P
0 g
s
.53723 .40369 m .53502 .39579 L p .53625 .40054 L .796 .567 .002 r
F P
0 g
s
.53621 .39388 m .53 .38305 L .52709 .37684 L p .805 .483 0 r
F P
0 g
s
.40827 .47295 m .41299 .46322 L .44939 .45278 L p .398 .851 .897 r
F P
0 g
s
.44939 .45278 m .44479 .46282 L .40827 .47295 L p .398 .851 .897 r
F P
0 g
s
.71033 .30298 m .69148 .29168 L .74965 .27721 L p .52 .862 .993 r
F P
0 g
s
.74965 .27721 m .76891 .28881 L .71033 .30298 L p .52 .862 .993 r
F P
0 g
s
.52745 .33165 m .54293 .34296 L .53291 .35051 L p .832 .98 .88 r
F P
0 g
s
.54293 .34296 m .52745 .33165 L .54149 .32341 L p .734 .958 .943 r
F P
0 g
s
.54149 .32341 m .55811 .33474 L .54293 .34296 L p .734 .958 .943 r
F P
0 g
s
.55811 .33474 m .54149 .32341 L .56178 .3143 L p .661 .931 .971 r
F P
0 g
s
.56178 .3143 m .57942 .3257 L .55811 .33474 L p .661 .931 .971 r
F P
0 g
s
.51868 .33921 m .53291 .35051 L .52716 .35755 L p .939 .963 .736 r
F P
0 g
s
.53291 .35051 m .51868 .33921 L .52745 .33165 L p .832 .98 .88 r
F P
0 g
s
.53502 .39579 m .53807 .40668 L .53684 .4134 L p .829 .734 .21 r
F P
0 g
s
.57942 .3257 m .56178 .3143 L .58938 .30414 L p .608 .908 .983 r
F P
0 g
s
.58938 .30414 m .60791 .31565 L .57942 .3257 L p .608 .908 .983 r
F P
0 g
s
.51429 .34622 m .52716 .35755 L .52483 .3642 L p .987 .842 .464 r
F P
0 g
s
.52716 .35755 m .51429 .34622 L .51868 .33921 L p .939 .963 .736 r
F P
0 g
s
.44479 .46282 m .44939 .45278 L .47838 .44296 L p .432 .872 .889 r
F P
0 g
s
.47838 .44296 m .47421 .45327 L .44479 .46282 L p .432 .872 .889 r
F P
0 g
s
.53534 .40252 m .53684 .4134 L .533 .42046 L p .81 .891 .47 r
F P
0 g
s
.60791 .31565 m .58938 .30414 L .62551 .29272 L p .571 .889 .989 r
F P
0 g
s
.62551 .29272 m .64479 .3044 L .60791 .31565 L p .571 .889 .989 r
F P
0 g
s
.51342 .35283 m .52483 .3642 L .52509 .37059 L p .911 .615 .124 r
F P
0 g
s
.52483 .3642 m .51342 .35283 L .51429 .34622 L p .987 .842 .464 r
F P
0 g
s
.47421 .45327 m .47838 .44296 L .50049 .43376 L p .478 .897 .874 r
F P
0 g
s
.50049 .43376 m .49705 .44428 L .47421 .45327 L p .478 .897 .874 r
F P
0 g
s
.31662 .48587 m .32087 .47622 L .37365 .46416 L p .353 .822 .901 r
F P
0 g
s
.37365 .46416 m .36879 .47426 L .31662 .48587 L p .353 .822 .901 r
F P
0 g
s
.53295 .40961 m .533 .42046 L .52566 .42791 L p .725 .957 .674 r
F P
0 g
s
.533 .42046 m .53295 .40961 L .53534 .40252 L p .81 .891 .47 r
F P
0 g
s
.49705 .44428 m .50049 .43376 L .51642 .42516 L p .54 .926 .846 r
F P
0 g
s
.51642 .42516 m .51395 .43584 L .49705 .44428 L p .54 .926 .846 r
F P
0 g
s
.52695 .41713 m .52566 .42791 L .51395 .43584 L p .624 .954 .789 r
F P
0 g
s
.52566 .42791 m .52695 .41713 L .53295 .40961 L p .725 .957 .674 r
F P
0 g
s
.51521 .35916 m .52509 .37059 L .52709 .37684 L p .781 .405 0 r
F P
0 g
s
.52509 .37059 m .51521 .35916 L .51342 .35283 L p .911 .615 .124 r
F P
0 g
s
.51395 .43584 m .51642 .42516 L .52695 .41713 L p .624 .954 .789 r
F P
0 g
s
.64479 .3044 m .62551 .29272 L .67159 .27977 L p .543 .875 .992 r
F P
0 g
s
.67159 .27977 m .69148 .29168 L .64479 .3044 L p .543 .875 .992 r
F P
0 g
s
.51882 .36534 m .52709 .37684 L .53 .38305 L p .689 .293 0 r
F P
0 g
s
.52709 .37684 m .51882 .36534 L .51521 .35916 L p .781 .405 0 r
F P
0 g
s
.36879 .47426 m .37365 .46416 L .41808 .45272 L p .375 .836 .899 r
F P
0 g
s
.41808 .45272 m .41299 .46322 L .36879 .47426 L p .375 .836 .899 r
F P
0 g
s
.53 .38305 m .52338 .37149 L .51882 .36534 L p .689 .293 0 r
F P
0 g
s
.53 .38305 m .53294 .38933 L p .53072 .38519 L .662 .285 0 r
F P
0 g
s
.52688 .37803 m .52966 .3825 L .53072 .38519 L .662 .285 0 r
F
.52966 .3825 m .53 .38305 L .53072 .38519 L F
.52338 .37149 m .52529 .37482 L p .52688 .37803 L F P
0 g
s
.52529 .37482 m .53 .38305 L p .52688 .37803 L .662 .285 0 r
F P
0 g
s
.53294 .38933 m .528 .37773 L .52338 .37149 L p .662 .285 0 r
F P
0 g
s
.528 .37773 m .53294 .38933 L .53466 .39467 L p .696 .38 0 r
F P
0 g
s
.53466 .39467 m .53502 .39579 L p .53458 .39465 L .696 .38 0 r
F P
0 g
s
.528 .37773 m .53466 .39467 L .53458 .39465 L .696 .38 0 r
F
.53295 .40961 m .5329 .39797 L .53333 .39429 L p .809 .803 .312 r
F P
0 g
s
.53254 .3894 m .53458 .39465 L .53413 .3926 L .696 .38 0 r
F
.53502 .39579 m .53453 .39402 L p .53458 .39465 L F P
0 g
s
.53453 .39402 m .53413 .3926 L p .53458 .39465 L .696 .38 0 r
F P
0 g
s
.53413 .3926 m .53177 .38415 L p .53254 .3894 L .696 .38 0 r
F P
0 g
s
.53177 .38415 m .53502 .39579 L .53534 .40252 L p .77 .575 .004 r
F P
0 g
s
.53534 .40252 m .53414 .39386 L p .53318 .39144 L .77 .575 .004 r
F P
0 g
s
.53414 .39386 m .53372 .39087 L p .53318 .39144 L .77 .575 .004 r
F P
0 g
s
.53333 .39429 m .53372 .39087 L p .53358 .39436 L .809 .803 .312 r
F P
0 g
s
.53358 .39436 m .53295 .40961 L .53333 .39429 L .809 .803 .312 r
F
.53372 .39087 m .53177 .38415 L p .53318 .39144 L .77 .575 .004 r
F P
0 g
s
.53177 .38415 m .528 .37773 L p .53254 .3894 L .696 .38 0 r
F P
0 g
s
.69148 .29168 m .67159 .27977 L .72934 .26498 L p .523 .863 .993 r
F P
0 g
s
.72934 .26498 m .74965 .27721 L .69148 .29168 L p .523 .863 .993 r
F P
0 g
s
.52389 .31141 m .54149 .32341 L .52745 .33165 L p .761 .964 .931 r
F P
0 g
s
.54149 .32341 m .52389 .31141 L .54312 .30224 L p .678 .937 .966 r
F P
0 g
s
.54312 .30224 m .56178 .3143 L .54149 .32341 L p .678 .937 .966 r
F P
0 g
s
.51104 .31967 m .52745 .33165 L .51868 .33921 L p .871 .979 .845 r
F P
0 g
s
.52745 .33165 m .51104 .31967 L .52389 .31141 L p .761 .964 .931 r
F P
0 g
s
.56178 .3143 m .54312 .30224 L .56979 .29197 L p .619 .912 .981 r
F P
0 g
s
.56979 .29197 m .58938 .30414 L .56178 .3143 L p .619 .912 .981 r
F P
0 g
s
.50358 .32721 m .51868 .33921 L .51429 .34622 L p .974 .925 .642 r
F P
0 g
s
.51868 .33921 m .50358 .32721 L .51104 .31967 L p .871 .979 .845 r
F P
0 g
s
.41299 .46322 m .41808 .45272 L .45435 .44194 L p .402 .854 .894 r
F P
0 g
s
.45435 .44194 m .44939 .45278 L .41299 .46322 L p .402 .854 .894 r
F P
0 g
s
.50062 .33418 m .51429 .34622 L .51342 .35283 L p .965 .72 .282 r
F P
0 g
s
.51429 .34622 m .50062 .33418 L .50358 .32721 L p .974 .925 .642 r
F P
0 g
s
.58938 .30414 m .56979 .29197 L .60514 .28038 L p .578 .892 .988 r
F P
0 g
s
.60514 .28038 m .62551 .29272 L .58938 .30414 L p .578 .892 .988 r
F P
0 g
s
.50127 .34072 m .51342 .35283 L .51521 .35916 L p .814 .432 0 r
F P
0 g
s
.51342 .35283 m .50127 .34072 L .50062 .33418 L p .965 .72 .282 r
F P
0 g
s
.53372 .39087 m .53534 .40252 L .53295 .40961 L p .809 .803 .312 r
F P
0 g
s
.44939 .45278 m .45435 .44194 L .48286 .43185 L p .439 .876 .885 r
F P
0 g
s
.48286 .43185 m .47838 .44296 L .44939 .45278 L p .439 .876 .885 r
F P
0 g
s
.62551 .29272 m .60514 .28038 L .6506 .26719 L p .548 .877 .991 r
F P
0 g
s
.6506 .26719 m .67159 .27977 L .62551 .29272 L p .548 .877 .991 r
F P
0 g
s
.50468 .34698 m .51521 .35916 L .51882 .36534 L p .657 .22 0 r
F P
0 g
s
.51521 .35916 m .50468 .34698 L .50127 .34072 L p .814 .432 0 r
F P
0 g
s
.5329 .39797 m .53295 .40961 L .52695 .41713 L p .752 .935 .591 r
F P
0 g
s
.47838 .44296 m .48286 .43185 L .50419 .42244 L p .488 .902 .867 r
F P
0 g
s
.50419 .42244 m .50049 .43376 L .47838 .44296 L p .488 .902 .867 r
F P
0 g
s
.52834 .40555 m .52695 .41713 L .51642 .42516 L p .649 .956 .752 r
F P
0 g
s
.52695 .41713 m .52834 .40555 L .5329 .39797 L p .752 .935 .591 r
F P
0 g
s
.32087 .47622 m .32547 .46579 L .3789 .45323 L p .355 .824 .9 r
F P
0 g
s
.3789 .45323 m .37365 .46416 L .32087 .47622 L p .355 .824 .9 r
F P
0 g
s
.50049 .43376 m .50419 .42244 L .51907 .41369 L p .557 .933 .83 r
F P
0 g
s
.51907 .41369 m .51642 .42516 L .50049 .43376 L p .557 .933 .83 r
F P
0 g
s
.51642 .42516 m .51907 .41369 L .52834 .40555 L p .649 .956 .752 r
F P
0 g
s
.50999 .35308 m .51882 .36534 L .52338 .37149 L p 0 0 .424 r
F P
0 g
s
.51882 .36534 m .50999 .35308 L .50468 .34698 L p .657 .22 0 r
F P
0 g
s
.67159 .27977 m .6506 .26719 L .70792 .25207 L p .526 .865 .993 r
F P
0 g
s
.70792 .25207 m .72934 .26498 L .67159 .27977 L p .526 .865 .993 r
F P
0 g
s
.51631 .35915 m .52338 .37149 L .528 .37773 L p 0 0 .442 r
F P
0 g
s
.52338 .37149 m .51631 .35915 L .50999 .35308 L p 0 0 .424 r
F P
0 g
s
.50523 .29868 m .52389 .31141 L .51104 .31967 L p .791 .97 .914 r
F P
0 g
s
.52389 .31141 m .50523 .29868 L .52334 .28946 L p .696 .943 .961 r
F P
0 g
s
.52334 .28946 m .54312 .30224 L .52389 .31141 L p .696 .943 .961 r
F P
0 g
s
.49362 .30695 m .51104 .31967 L .50358 .32721 L p .912 .97 .795 r
F P
0 g
s
.51104 .31967 m .49362 .30695 L .50523 .29868 L p .791 .97 .914 r
F P
0 g
s
.54312 .30224 m .52334 .28946 L .54905 .27909 L p .631 .917 .979 r
F P
0 g
s
.54905 .27909 m .56979 .29197 L .54312 .30224 L p .631 .917 .979 r
F P
0 g
s
.48753 .31446 m .50358 .32721 L .50062 .33418 L p .993 .857 .511 r
F P
0 g
s
.50358 .32721 m .48753 .31446 L .49362 .30695 L p .912 .97 .795 r
F P
0 g
s
.37365 .46416 m .3789 .45323 L .42358 .44137 L p .378 .839 .898 r
F P
0 g
s
.42358 .44137 m .41808 .45272 L .37365 .46416 L p .378 .839 .898 r
F P
0 g
s
.56979 .29197 m .54905 .27909 L .58359 .26733 L p .585 .895 .987 r
F P
0 g
s
.58359 .26733 m .60514 .28038 L .56979 .29197 L p .585 .895 .987 r
F P
0 g
s
.52272 .3653 m .528 .37773 L .53177 .38415 L p 0 0 .378 r
F P
0 g
s
.528 .37773 m .52272 .3653 L .51631 .35915 L p 0 0 .442 r
F P
0 g
s
.48606 .32136 m .50062 .33418 L .50127 .34072 L p .898 .558 .075 r
F P
0 g
s
.50062 .33418 m .48606 .32136 L .48753 .31446 L p .993 .857 .511 r
F P
0 g
s
.60514 .28038 m .58359 .26733 L .62841 .25389 L p .553 .879 .991 r
F P
0 g
s
.62841 .25389 m .6506 .26719 L .60514 .28038 L p .553 .879 .991 r
F P
0 g
s
.53177 .38415 m .53372 .39087 L p .53173 .38385 L 0 0 .199 r
F P
0 g
s
.53372 .39087 m .53199 .37835 L .52827 .37167 L p 0 0 .199 r
F P
0 g
s
.53199 .37835 m .53372 .39087 L .53356 .39228 L p .776 .672 .122 r
F P
0 g
s
.53356 .39228 m .5329 .39797 L p .53263 .39206 L .776 .672 .122 r
F P
0 g
s
.53199 .37835 m .53356 .39228 L .53263 .39206 L .776 .672 .122 r
F
.52834 .40555 m .52983 .39309 L .53044 .39155 L p .772 .889 .478 r
F P
0 g
s
.5329 .39797 m .53285 .38748 L p .53233 .3858 L .776 .672 .122 r
F P
0 g
s
.53285 .38748 m .53285 .38546 L p .53233 .3858 L .776 .672 .122 r
F P
0 g
s
.53044 .39155 m .53285 .38546 L p .53143 .39179 L .772 .889 .478 r
F P
0 g
s
.53143 .39179 m .52834 .40555 L .53044 .39155 L .772 .889 .478 r
F
.53285 .38546 m .53199 .37835 L p .53233 .3858 L .776 .672 .122 r
F P
0 g
s
.52827 .37167 m .53124 .38226 L p .53173 .38385 L 0 0 .199 r
F P
0 g
s
.53124 .38226 m .53177 .38415 L p .53173 .38385 L 0 0 .199 r
F P
0 g
s
.53177 .38415 m .52827 .37167 L .52272 .3653 L p 0 0 .378 r
F P
0 g
s
.48832 .32782 m .50127 .34072 L .50468 .34698 L p .692 .246 0 r
F P
0 g
s
.50127 .34072 m .48832 .32782 L .48606 .32136 L p .898 .558 .075 r
F P
0 g
s
.41808 .45272 m .42358 .44137 L .45971 .43023 L p .407 .857 .892 r
F P
0 g
s
.45971 .43023 m .45435 .44194 L .41808 .45272 L p .407 .857 .892 r
F P
0 g
s
.50468 .34698 m .49344 .33397 L .48832 .32782 L p .692 .246 0 r
F P
0 g
s
.49344 .33397 m .50468 .34698 L .50999 .35308 L p 0 0 .465 r
F P
0 g
s
.6506 .26719 m .62841 .25389 L .68527 .23843 L p .53 .867 .993 r
F P
0 g
s
.68527 .23843 m .70792 .25207 L .6506 .26719 L p .53 .867 .993 r
F P
0 g
s
.45435 .44194 m .45971 .43023 L .48771 .41985 L p .446 .88 .88 r
F P
0 g
s
.48771 .41985 m .48286 .43185 L .45435 .44194 L p .446 .88 .88 r
F P
0 g
s
.53285 .38546 m .5329 .39797 L .52834 .40555 L p .772 .889 .478 r
F P
0 g
s
.50055 .33996 m .50999 .35308 L .51631 .35915 L p 0 .028 .547 r
F P
0 g
s
.50999 .35308 m .50055 .33996 L .49344 .33397 L p 0 0 .465 r
F P
0 g
s
.52983 .39309 m .52834 .40555 L .51907 .41369 L p .675 .952 .704 r
F P
0 g
s
.48286 .43185 m .48771 .41985 L .50819 .41022 L p .5 .908 .858 r
F P
0 g
s
.50819 .41022 m .50419 .42244 L .48286 .43185 L p .5 .908 .858 r
F P
0 g
s
.52194 .40132 m .51907 .41369 L .50419 .42244 L p .575 .938 .81 r
F P
0 g
s
.51907 .41369 m .52194 .40132 L .52983 .39309 L p .675 .952 .704 r
F P
0 g
s
.50419 .42244 m .50819 .41022 L .52194 .40132 L p .575 .938 .81 r
F P
0 g
s
.48539 .28516 m .50523 .29868 L .49362 .30695 L p .824 .973 .892 r
F P
0 g
s
.50523 .29868 m .48539 .28516 L .50235 .2759 L p .717 .949 .953 r
F P
0 g
s
.50235 .2759 m .52334 .28946 L .50523 .29868 L p .717 .949 .953 r
F P
0 g
s
.52334 .28946 m .50235 .2759 L .52706 .26543 L p .644 .921 .977 r
F P
0 g
s
.52706 .26543 m .54905 .27909 L .52334 .28946 L p .644 .921 .977 r
F P
0 g
s
.47508 .29342 m .49362 .30695 L .48753 .31446 L p .952 .949 .724 r
F P
0 g
s
.49362 .30695 m .47508 .29342 L .48539 .28516 L p .824 .973 .892 r
F P
0 g
s
.32547 .46579 m .33046 .45446 L .38461 .44137 L p .358 .826 .899 r
F P
0 g
s
.38461 .44137 m .3789 .45323 L .32547 .46579 L p .358 .826 .899 r
F P
0 g
s
.50873 .34592 m .51631 .35915 L .52272 .3653 L p 0 .033 .562 r
F P
0 g
s
.51631 .35915 m .50873 .34592 L .50055 .33996 L p 0 .028 .547 r
F P
0 g
s
.54905 .27909 m .52706 .26543 L .56075 .25349 L p .593 .899 .986 r
F P
0 g
s
.56075 .25349 m .58359 .26733 L .54905 .27909 L p .593 .899 .986 r
F P
0 g
s
.47043 .30087 m .48753 .31446 L .48606 .32136 L p .982 .747 .341 r
F P
0 g
s
.48753 .31446 m .47043 .30087 L .47508 .29342 L p .952 .949 .724 r
F P
0 g
s
.47052 .30769 m .48606 .32136 L .48832 .32782 L p .792 .373 0 r
F P
0 g
s
.48606 .32136 m .47052 .30769 L .47043 .30087 L p .982 .747 .341 r
F P
0 g
s
.58359 .26733 m .56075 .25349 L .6049 .2398 L p .558 .881 .991 r
F P
0 g
s
.6049 .2398 m .62841 .25389 L .58359 .26733 L p .558 .881 .991 r
F P
0 g
s
.51705 .35197 m .52272 .3653 L .52827 .37167 L p 0 0 .514 r
F P
0 g
s
.52272 .3653 m .51705 .35197 L .50873 .34592 L p 0 .033 .562 r
F P
0 g
s
.3789 .45323 m .38461 .44137 L .42956 .42904 L p .381 .841 .896 r
F P
0 g
s
.42956 .42904 m .42358 .44137 L .3789 .45323 L p .381 .841 .896 r
F P
0 g
s
.47448 .31403 m .48832 .32782 L .49344 .33397 L p .565 .079 0 r
F P
0 g
s
.48832 .32782 m .47448 .31403 L .47052 .30769 L p .792 .373 0 r
F P
0 g
s
.52827 .37167 m .53199 .37835 L p .52926 .37102 L 0 0 .375 r
F P
0 g
s
.53199 .37835 m .53012 .36488 L .52452 .35825 L p 0 0 .375 r
F P
0 g
s
.53012 .36488 m .53199 .37835 L .53216 .37977 L p .707 .506 0 r
F P
0 g
s
.53216 .37977 m .53285 .38546 L p .53203 .37927 L .707 .506 0 r
F P
0 g
s
.53012 .36488 m .53216 .37977 L .53203 .37927 L .707 .506 0 r
F
.52983 .39309 m .53144 .37962 L .53171 .37809 L p .775 .811 .33 r
F P
0 g
s
.53285 .38546 m .53279 .37415 L p .53115 .37269 L .707 .506 0 r
F P
0 g
s
.53279 .37415 m .53278 .37197 L p .53115 .37269 L .707 .506 0 r
F P
0 g
s
.53171 .37809 m .53278 .37197 L p .53185 .37862 L .775 .811 .33 r
F P
0 g
s
.53185 .37862 m .52983 .39309 L .53171 .37809 L .775 .811 .33 r
F
.53278 .37197 m .53012 .36488 L p .53115 .37269 L .707 .506 0 r
F P
0 g
s
.52452 .35825 m .52771 .36964 L p .52926 .37102 L 0 0 .375 r
F P
0 g
s
.52771 .36964 m .52827 .37167 L p .52926 .37102 L 0 0 .375 r
F P
0 g
s
.52827 .37167 m .52452 .35825 L .51705 .35197 L p 0 0 .514 r
F P
0 g
s
.62841 .25389 m .6049 .2398 L .66129 .22399 L p .533 .868 .993 r
F P
0 g
s
.66129 .22399 m .68527 .23843 L .62841 .25389 L p .533 .868 .993 r
F P
0 g
s
.48141 .32005 m .49344 .33397 L .50055 .33996 L p 0 .079 .576 r
F P
0 g
s
.49344 .33397 m .48141 .32005 L .47448 .31403 L p .565 .079 0 r
F P
0 g
s
.42358 .44137 m .42956 .42904 L .46553 .41752 L p .412 .86 .889 r
F P
0 g
s
.46553 .41752 m .45971 .43023 L .42358 .44137 L p .412 .86 .889 r
F P
0 g
s
.53278 .37197 m .53285 .38546 L .52983 .39309 L p .775 .811 .33 r
F P
0 g
s
.49042 .3259 m .50055 .33996 L .50873 .34592 L p 0 .145 .637 r
F P
0 g
s
.50055 .33996 m .49042 .3259 L .48141 .32005 L p 0 .079 .576 r
F P
0 g
s
.46427 .27076 m .48539 .28516 L .47508 .29342 L p .862 .973 .86 r
F P
0 g
s
.48539 .28516 m .46427 .27076 L .48003 .26148 L p .741 .955 .944 r
F P
0 g
s
.48003 .26148 m .50235 .2759 L .48539 .28516 L p .741 .955 .944 r
F P
0 g
s
.50235 .2759 m .48003 .26148 L .50369 .25091 L p .658 .926 .974 r
F P
0 g
s
.50369 .25091 m .52706 .26543 L .50235 .2759 L p .658 .926 .974 r
F P
0 g
s
.45971 .43023 m .46553 .41752 L .49296 .40684 L p .454 .885 .875 r
F P
0 g
s
.49296 .40684 m .48771 .41985 L .45971 .43023 L p .454 .885 .875 r
F P
0 g
s
.45531 .27899 m .47508 .29342 L .47043 .30087 L p .984 .905 .624 r
F P
0 g
s
.47508 .29342 m .45531 .27899 L .46427 .27076 L p .862 .973 .86 r
F P
0 g
s
.52706 .26543 m .50369 .25091 L .5365 .23881 L p .602 .902 .985 r
F P
0 g
s
.5365 .23881 m .56075 .25349 L .52706 .26543 L p .602 .902 .985 r
F P
0 g
s
.53144 .37962 m .52983 .39309 L .52194 .40132 L p .702 .94 .638 r
F P
0 g
s
.48771 .41985 m .49296 .40684 L .51252 .39699 L p .512 .914 .846 r
F P
0 g
s
.51252 .39699 m .50819 .41022 L .48771 .41985 L p .512 .914 .846 r
F P
0 g
s
.45217 .28636 m .47043 .30087 L .47052 .30769 L p .927 .595 .141 r
F P
0 g
s
.47043 .30087 m .45217 .28636 L .45531 .27899 L p .984 .905 .624 r
F P
0 g
s
.52503 .38794 m .52194 .40132 L .50819 .41022 L p .596 .942 .784 r
F P
0 g
s
.52194 .40132 m .52503 .38794 L .53144 .37962 L p .702 .94 .638 r
F P
0 g
s
.50819 .41022 m .51252 .39699 L .52503 .38794 L p .596 .942 .784 r
F P
0 g
s
.50059 .33171 m .50873 .34592 L .51705 .35197 L p 0 .149 .649 r
F P
0 g
s
.50873 .34592 m .50059 .33171 L .49042 .3259 L p 0 .145 .637 r
F P
0 g
s
.56075 .25349 m .5365 .23881 L .57996 .22485 L p .564 .884 .99 r
F P
0 g
s
.57996 .22485 m .6049 .2398 L .56075 .25349 L p .564 .884 .99 r
F P
0 g
s
.45391 .29306 m .47052 .30769 L .47448 .31403 L p .666 .192 0 r
F P
0 g
s
.47052 .30769 m .45391 .29306 L .45217 .28636 L p .927 .595 .141 r
F P
0 g
s
.33046 .45446 m .3359 .44211 L .39082 .42845 L p .36 .827 .898 r
F P
0 g
s
.39082 .42845 m .38461 .44137 L .33046 .45446 L p .36 .827 .898 r
F P
0 g
s
.51095 .33763 m .51705 .35197 L .52452 .35825 L p 0 .091 .616 r
F P
0 g
s
.51705 .35197 m .51095 .33763 L .50059 .33171 L p 0 .149 .649 r
F P
0 g
s
.47448 .31403 m .45965 .29926 L .45391 .29306 L p .666 .192 0 r
F P
0 g
s
.45965 .29926 m .47448 .31403 L .48141 .32005 L p 0 .06 .549 r
F P
0 g
s
.6049 .2398 m .57996 .22485 L .63586 .20868 L p .537 .87 .993 r
F P
0 g
s
.63586 .20868 m .66129 .22399 L .6049 .2398 L p .537 .87 .993 r
F P
0 g
s
.52048 .3438 m .52452 .35825 L .53012 .36488 L p 0 0 .513 r
F P
0 g
s
.52452 .35825 m .52048 .3438 L .51095 .33763 L p 0 .091 .616 r
F P
0 g
s
.38461 .44137 m .39082 .42845 L .43607 .41562 L p .385 .844 .894 r
F P
0 g
s
.43607 .41562 m .42956 .42904 L .38461 .44137 L p .385 .844 .894 r
F P
0 g
s
.4685 .30512 m .48141 .32005 L .49042 .3259 L p 0 .186 .657 r
F P
0 g
s
.48141 .32005 m .4685 .30512 L .45965 .29926 L p 0 .06 .549 r
F P
0 g
s
.53065 .36629 m .53278 .37197 L p .53138 .36546 L 0 0 .275 r
F P
0 g
s
.53278 .37197 m .53272 .35738 L .5281 .35034 L p 0 0 .275 r
F P
0 g
s
.53272 .35738 m .53278 .37197 L .53219 .37539 L p .749 .692 .149 r
F P
0 g
s
.53219 .37539 m .53144 .37962 L p .53177 .37394 L .749 .692 .149 r
F P
0 g
s
.53272 .35738 m .53219 .37539 L .53177 .37394 L .749 .692 .149 r
F
.52503 .38794 m .52839 .37343 L .53055 .36966 L p .726 .912 .549 r
F P
0 g
s
.53144 .37962 m .53319 .36504 L .5331 .3635 L p .749 .692 .149 r
F P
0 g
s
.53232 .36439 m .53144 .37962 L .5331 .3635 L .749 .692 .149 r
F
.53055 .36966 m .53319 .36504 L p .53099 .37121 L .726 .912 .549 r
F P
0 g
s
.53099 .37121 m .52503 .38794 L .53055 .36966 L .726 .912 .549 r
F
.5331 .3635 m .53272 .35738 L p .53232 .36439 L .749 .692 .149 r
F P
0 g
s
.5281 .35034 m .53012 .36488 L .53065 .36629 L p 0 0 .275 r
F P
0 g
s
.5281 .35034 m .53065 .36629 L .53138 .36546 L 0 0 .275 r
F
.53012 .36488 m .5281 .35034 L .52048 .3438 L p 0 0 .513 r
F P
0 g
s
.45624 .2461 m .48003 .26148 L .46427 .27076 L p .768 .961 .931 r
F P
0 g
s
.48003 .26148 m .45624 .2461 L .47881 .23546 L p .674 .932 .969 r
F P
0 g
s
.47881 .23546 m .50369 .25091 L .48003 .26148 L p .674 .932 .969 r
F P
0 g
s
.44174 .2554 m .46427 .27076 L .45531 .27899 L p .901 .967 .816 r
F P
0 g
s
.46427 .27076 m .44174 .2554 L .45624 .2461 L p .768 .961 .931 r
F P
0 g
s
.50369 .25091 m .47881 .23546 L .51072 .22319 L p .611 .906 .984 r
F P
0 g
s
.51072 .22319 m .5365 .23881 L .50369 .25091 L p .611 .906 .984 r
F P
0 g
s
.4342 .26357 m .45531 .27899 L .45217 .28636 L p .998 .829 .487 r
F P
0 g
s
.45531 .27899 m .4342 .26357 L .44174 .2554 L p .901 .967 .816 r
F P
0 g
s
.47954 .31079 m .49042 .3259 L .50059 .33171 L p 0 .238 .703 r
F P
0 g
s
.49042 .3259 m .47954 .31079 L .4685 .30512 L p 0 .186 .657 r
F P
0 g
s
.42956 .42904 m .43607 .41562 L .47186 .4037 L p .418 .864 .886 r
F P
0 g
s
.47186 .4037 m .46553 .41752 L .42956 .42904 L p .418 .864 .886 r
F P
0 g
s
.43264 .27084 m .45217 .28636 L .45391 .29306 L p .83 .416 0 r
F P
0 g
s
.45217 .28636 m .43264 .27084 L .4342 .26357 L p .998 .829 .487 r
F P
0 g
s
.5365 .23881 m .51072 .22319 L .55345 .20897 L p .57 .886 .99 r
F P
0 g
s
.55345 .20897 m .57996 .22485 L .5365 .23881 L p .57 .886 .99 r
F P
0 g
s
.53319 .36504 m .53144 .37962 L .52503 .38794 L p .726 .912 .549 r
F P
0 g
s
.46553 .41752 m .47186 .4037 L .49867 .3927 L p .462 .889 .869 r
F P
0 g
s
.49867 .3927 m .49296 .40684 L .46553 .41752 L p .462 .889 .869 r
F P
0 g
s
.49183 .31642 m .50059 .33171 L .51095 .33763 L p 0 .241 .713 r
F P
0 g
s
.50059 .33171 m .49183 .31642 L .47954 .31079 L p 0 .238 .703 r
F P
0 g
s
.43612 .2774 m .45391 .29306 L .45965 .29926 L p .54 .034 0 r
F P
0 g
s
.45391 .29306 m .43612 .2774 L .43264 .27084 L p .83 .416 0 r
F P
0 g
s
.52839 .37343 m .52503 .38794 L .51252 .39699 L p .618 .944 .75 r
F P
0 g
s
.49296 .40684 m .49867 .3927 L .51722 .38263 L p .527 .92 .833 r
F P
0 g
s
.51722 .38263 m .51252 .39699 L .49296 .40684 L p .527 .92 .833 r
F P
0 g
s
.51252 .39699 m .51722 .38263 L .52839 .37343 L p .618 .944 .75 r
F P
0 g
s
.57996 .22485 m .55345 .20897 L .60885 .19241 L p .541 .872 .992 r
F P
0 g
s
.60885 .19241 m .63586 .20868 L .57996 .22485 L p .541 .872 .992 r
F P
0 g
s
.50437 .32217 m .51095 .33763 L .52048 .3438 L p 0 .194 .69 r
F P
0 g
s
.51095 .33763 m .50437 .32217 L .49183 .31642 L p 0 .241 .713 r
F P
0 g
s
.44374 .28341 m .45965 .29926 L .4685 .30512 L p 0 .172 .637 r
F P
0 g
s
.45965 .29926 m .44374 .28341 L .43612 .2774 L p .54 .034 0 r
F P
0 g
s
.3359 .44211 m .34185 .42862 L .39762 .41431 L p .363 .829 .897 r
F P
0 g
s
.39762 .41431 m .39082 .42845 L .3359 .44211 L p .363 .829 .897 r
F P
0 g
s
.51611 .32818 m .52048 .3438 L .5281 .35034 L p 0 .08 .616 r
F P
0 g
s
.52048 .3438 m .51611 .32818 L .50437 .32217 L p 0 .194 .69 r
F P
0 g
s
.45462 .28906 m .4685 .30512 L .47954 .31079 L p 0 .271 .717 r
F P
0 g
s
.4685 .30512 m .45462 .28906 L .44374 .28341 L p 0 .172 .637 r
F P
0 g
s
.43085 .22969 m .45624 .2461 L .44174 .2554 L p .798 .965 .914 r
F P
0 g
s
.45624 .2461 m .43085 .22969 L .45228 .21898 L p .691 .937 .964 r
F P
0 g
s
.45228 .21898 m .47881 .23546 L .45624 .2461 L p .691 .937 .964 r
F P
0 g
s
.41765 .23897 m .44174 .2554 L .4342 .26357 L p .942 .95 .754 r
F P
0 g
s
.44174 .2554 m .41765 .23897 L .43085 .22969 L p .798 .965 .914 r
F P
0 g
s
.47881 .23546 m .45228 .21898 L .48324 .20655 L p .622 .91 .982 r
F P
0 g
s
.48324 .20655 m .51072 .22319 L .47881 .23546 L p .622 .91 .982 r
F P
0 g
s
.4116 .24707 m .4342 .26357 L .43264 .27084 L p .978 .711 .312 r
F P
0 g
s
.4342 .26357 m .4116 .24707 L .41765 .23897 L p .942 .95 .754 r
F P
0 g
s
.39082 .42845 m .39762 .41431 L .44318 .40095 L p .389 .846 .892 r
F P
0 g
s
.44318 .40095 m .43607 .41562 L .39082 .42845 L p .389 .846 .892 r
F P
0 g
s
.52592 .33459 m .5281 .35034 L .53272 .35738 L p 0 0 .435 r
F P
0 g
s
.5281 .35034 m .52592 .33459 L .51611 .32818 L p 0 .08 .616 r
F P
0 g
s
.51072 .22319 m .48324 .20655 L .52523 .19206 L p .576 .889 .989 r
F P
0 g
s
.52523 .19206 m .55345 .20897 L .51072 .22319 L p .576 .889 .989 r
F P
0 g
s
.46782 .2945 m .47954 .31079 L .49183 .31642 L p 0 .312 .752 r
F P
0 g
s
.47954 .31079 m .46782 .2945 L .45462 .28906 L p 0 .271 .717 r
F P
0 g
s
.41169 .2542 m .43264 .27084 L .43612 .2774 L p .708 .234 0 r
F P
0 g
s
.43264 .27084 m .41169 .2542 L .4116 .24707 L p .978 .711 .312 r
F P
0 g
s
.53265 .34156 m .53272 .35738 L .53293 .3608 L p 0 0 .05 r
F P
0 g
s
.53265 .34156 m .53293 .3608 L .53305 .35904 L 0 0 .05 r
F
.53272 .35738 m .53265 .34156 L .52592 .33459 L p 0 0 .435 r
F P
0 g
s
.53319 .36504 m .53509 .3492 L .53265 .34156 L p 0 0 .05 r
F P
0 g
s
.52839 .37343 m .53204 .35763 L .53341 .35384 L p .74 .86 .43 r
F P
0 g
s
.53341 .35384 m .53509 .3492 L p .53328 .35573 L .74 .86 .43 r
F P
0 g
s
.53328 .35573 m .52839 .37343 L .53341 .35384 L .74 .86 .43 r
F
.53293 .3608 m .53319 .36504 L p .53305 .35904 L 0 0 .05 r
F P
0 g
s
.55345 .20897 m .52523 .19206 L .58009 .17509 L p .545 .874 .992 r
F P
0 g
s
.58009 .17509 m .60885 .19241 L .55345 .20897 L p .545 .874 .992 r
F P
0 g
s
.43607 .41562 m .44318 .40095 L .47877 .38859 L p .423 .868 .882 r
F P
0 g
s
.47877 .38859 m .47186 .4037 L .43607 .41562 L p .423 .868 .882 r
F P
0 g
s
.43612 .2774 m .417 .26056 L .41169 .2542 L p .708 .234 0 r
F P
0 g
s
.417 .26056 m .43612 .2774 L .44374 .28341 L p 0 .097 .568 r
F P
0 g
s
.48237 .2999 m .49183 .31642 L .50437 .32217 L p 0 .313 .76 r
F P
0 g
s
.49183 .31642 m .48237 .2999 L .46782 .2945 L p 0 .312 .752 r
F P
0 g
s
.53509 .3492 m .53319 .36504 L .52839 .37343 L p .74 .86 .43 r
F P
0 g
s
.47186 .4037 m .47877 .38859 L .50491 .37727 L p .472 .894 .861 r
F P
0 g
s
.50491 .37727 m .49867 .3927 L .47186 .4037 L p .472 .894 .861 r
F P
0 g
s
.53204 .35763 m .52839 .37343 L .51722 .38263 L p .642 .942 .705 r
F P
0 g
s
.42662 .26635 m .44374 .28341 L .45462 .28906 L p 0 .26 .701 r
F P
0 g
s
.44374 .28341 m .42662 .26635 L .417 .26056 L p 0 .097 .568 r
F P
0 g
s
.49867 .3927 m .50491 .37727 L .52235 .36697 L p .542 .925 .816 r
F P
0 g
s
.52235 .36697 m .51722 .38263 L .49867 .3927 L p .542 .925 .816 r
F P
0 g
s
.51722 .38263 m .52235 .36697 L .53204 .35763 L p .642 .942 .705 r
F P
0 g
s
.49726 .30543 m .50437 .32217 L .51611 .32818 L p 0 .276 .744 r
F P
0 g
s
.50437 .32217 m .49726 .30543 L .48237 .2999 L p 0 .313 .76 r
F P
0 g
s
.40367 .21213 m .43085 .22969 L .41765 .23897 L p .831 .968 .89 r
F P
0 g
s
.43085 .22969 m .40367 .21213 L .42393 .20136 L p .711 .943 .958 r
F P
0 g
s
.42393 .20136 m .45228 .21898 L .43085 .22969 L p .711 .943 .958 r
F P
0 g
s
.45228 .21898 m .42393 .20136 L .4539 .18878 L p .633 .914 .98 r
F P
0 g
s
.4539 .18878 m .48324 .20655 L .45228 .21898 L p .633 .914 .98 r
F P
0 g
s
.39184 .22137 m .41765 .23897 L .4116 .24707 L p .977 .914 .666 r
F P
0 g
s
.41765 .23897 m .39184 .22137 L .40367 .21213 L p .831 .968 .89 r
F P
0 g
s
.43965 .27174 m .45462 .28906 L .46782 .2945 L p 0 .338 .761 r
F P
0 g
s
.45462 .28906 m .43965 .27174 L .42662 .26635 L p 0 .26 .701 r
F P
0 g
s
.51137 .31124 m .51611 .32818 L .52592 .33459 L p 0 .185 .691 r
F P
0 g
s
.51611 .32818 m .51137 .31124 L .49726 .30543 L p 0 .276 .744 r
F P
0 g
s
.34185 .42862 m .34838 .41379 L .40508 .39879 L p .366 .831 .896 r
F P
0 g
s
.40508 .39879 m .39762 .41431 L .34185 .42862 L p .366 .831 .896 r
F P
0 g
s
.38734 .22936 m .4116 .24707 L .41169 .2542 L p .915 .554 .109 r
F P
0 g
s
.4116 .24707 m .38734 .22936 L .39184 .22137 L p .977 .914 .666 r
F P
0 g
s
.48324 .20655 m .4539 .18878 L .49511 .17401 L p .583 .892 .989 r
F P
0 g
s
.49511 .17401 m .52523 .19206 L .48324 .20655 L p .583 .892 .989 r
F P
0 g
s
.38917 .23631 m .41169 .2542 L .417 .26056 L p .58 .069 0 r
F P
0 g
s
.41169 .2542 m .38917 .23631 L .38734 .22936 L p .915 .554 .109 r
F P
0 g
s
.45515 .2769 m .46782 .2945 L .48237 .2999 L p 0 .37 .789 r
F P
0 g
s
.46782 .2945 m .45515 .2769 L .43965 .27174 L p 0 .338 .761 r
F P
0 g
s
.52355 .31748 m .52592 .33459 L .53265 .34156 L p 0 0 .559 r
F P
0 g
s
.52592 .33459 m .52355 .31748 L .51137 .31124 L p 0 .185 .691 r
F P
0 g
s
.52523 .19206 m .49511 .17401 L .54943 .15662 L p .549 .876 .992 r
F P
0 g
s
.54943 .15662 m .58009 .17509 L .52523 .19206 L p .549 .876 .992 r
F P
0 g
s
.39762 .41431 m .40508 .39879 L .45099 .38484 L p .393 .849 .89 r
F P
0 g
s
.45099 .38484 m .44318 .40095 L .39762 .41431 L p .393 .849 .89 r
F P
0 g
s
.3964 .24243 m .417 .26056 L .42662 .26635 L p 0 .201 .649 r
F P
0 g
s
.417 .26056 m .3964 .24243 L .38917 .23631 L p .58 .069 0 r
F P
0 g
s
.53374 .34497 m .53509 .3492 L p .53445 .34285 L 0 0 .243 r
F P
0 g
s
.53509 .3492 m .53716 .33192 L .53257 .32433 L p 0 0 .243 r
F P
0 g
s
.53716 .33192 m .53509 .3492 L .53333 .35407 L p .736 .774 .277 r
F P
0 g
s
.53333 .35407 m .53204 .35763 L p .53318 .35193 L .736 .774 .277 r
F P
0 g
s
.53716 .33192 m .53333 .35407 L .53318 .35193 L .736 .774 .277 r
F
.52235 .36697 m .52795 .34983 L .53264 .34435 L p .667 .932 .646 r
F P
0 g
s
.53204 .35763 m .53604 .34038 L .53654 .33657 L p .736 .774 .277 r
F P
0 g
s
.53578 .33886 m .53204 .35763 L .53654 .33657 L .736 .774 .277 r
F
.53257 .32433 m .53265 .34156 L .53374 .34497 L p 0 0 .243 r
F P
0 g
s
.53257 .32433 m .53374 .34497 L .53445 .34285 L 0 0 .243 r
F
.53264 .34435 m .53604 .34038 L p .5328 .34666 L .667 .932 .646 r
F P
0 g
s
.5328 .34666 m .52235 .36697 L .53264 .34435 L .667 .932 .646 r
F
.53654 .33657 m .53716 .33192 L p .53578 .33886 L .736 .774 .277 r
F P
0 g
s
.53265 .34156 m .53257 .32433 L .52355 .31748 L p 0 0 .559 r
F P
0 g
s
.47213 .28202 m .48237 .2999 L .49726 .30543 L p 0 .371 .795 r
F P
0 g
s
.48237 .2999 m .47213 .28202 L .45515 .2769 L p 0 .37 .789 r
F P
0 g
s
.44318 .40095 m .45099 .38484 L .48636 .37203 L p .43 .871 .878 r
F P
0 g
s
.48636 .37203 m .47877 .38859 L .44318 .40095 L p .43 .871 .878 r
F P
0 g
s
.40813 .24794 m .42662 .26635 L .43965 .27174 L p 0 .33 .749 r
F P
0 g
s
.42662 .26635 m .40813 .24794 L .3964 .24243 L p 0 .201 .649 r
F P
0 g
s
.53604 .34038 m .53204 .35763 L .52235 .36697 L p .667 .932 .646 r
F P
0 g
s
.47877 .38859 m .48636 .37203 L .51174 .36036 L p .483 .9 .853 r
F P
0 g
s
.51174 .36036 m .50491 .37727 L .47877 .38859 L p .483 .9 .853 r
F P
0 g
s
.37451 .19329 m .40367 .21213 L .39184 .22137 L p .868 .967 .858 r
F P
0 g
s
.40367 .21213 m .37451 .19329 L .39355 .18249 L p .733 .949 .949 r
F P
0 g
s
.39355 .18249 m .42393 .20136 L .40367 .21213 L p .733 .949 .949 r
F P
0 g
s
.48953 .28726 m .49726 .30543 L .51137 .31124 L p 0 .341 .784 r
F P
0 g
s
.49726 .30543 m .48953 .28726 L .47213 .28202 L p 0 .371 .795 r
F P
0 g
s
.42393 .20136 m .39355 .18249 L .4225 .16976 L p .646 .919 .978 r
F P
0 g
s
.4225 .16976 m .4539 .18878 L .42393 .20136 L p .646 .919 .978 r
F P
0 g
s
.52795 .34983 m .52235 .36697 L .50491 .37727 L p .56 .93 .795 r
F P
0 g
s
.50491 .37727 m .51174 .36036 L .52795 .34983 L p .56 .93 .795 r
F P
0 g
s
.36411 .20247 m .39184 .22137 L .38734 .22936 L p .998 .85 .543 r
F P
0 g
s
.39184 .22137 m .36411 .20247 L .37451 .19329 L p .868 .967 .858 r
F P
0 g
s
.4539 .18878 m .4225 .16976 L .4629 .15471 L p .591 .895 .988 r
F P
0 g
s
.4629 .15471 m .49511 .17401 L .4539 .18878 L p .591 .895 .988 r
F P
0 g
s
.42345 .253 m .43965 .27174 L .45515 .2769 L p 0 .392 .795 r
F P
0 g
s
.43965 .27174 m .42345 .253 L .40813 .24794 L p 0 .33 .749 r
F P
0 g
s
.36123 .2103 m .38734 .22936 L .38917 .23631 L p .813 .374 0 r
F P
0 g
s
.38734 .22936 m .36123 .2103 L .36411 .20247 L p .998 .85 .543 r
F P
0 g
s
.50622 .29281 m .51137 .31124 L .52355 .31748 L p 0 .268 .745 r
F P
0 g
s
.51137 .31124 m .50622 .29281 L .48953 .28726 L p 0 .341 .784 r
F P
0 g
s
.49511 .17401 m .4629 .15471 L .51666 .13688 L p .554 .878 .992 r
F P
0 g
s
.51666 .13688 m .54943 .15662 L .49511 .17401 L p .554 .878 .992 r
F P
0 g
s
.36489 .21702 m .38917 .23631 L .3964 .24243 L p .462 0 0 r
F P
0 g
s
.38917 .23631 m .36489 .21702 L .36123 .2103 L p .813 .374 0 r
F P
0 g
s
.44141 .25782 m .45515 .2769 L .47213 .28202 L p 0 .417 .816 r
F P
0 g
s
.45515 .2769 m .44141 .25782 L .42345 .253 L p 0 .392 .795 r
F P
0 g
s
.34838 .41379 m .35559 .39744 L .41331 .38166 L p .369 .834 .895 r
F P
0 g
s
.41331 .38166 m .40508 .39879 L .34838 .41379 L p .369 .834 .895 r
F P
0 g
s
.52097 .29883 m .52355 .31748 L .53257 .32433 L p 0 .117 .65 r
F P
0 g
s
.52355 .31748 m .52097 .29883 L .50622 .29281 L p 0 .268 .745 r
F P
0 g
s
.37415 .22285 m .3964 .24243 L .40813 .24794 L p 0 .283 .709 r
F P
0 g
s
.3964 .24243 m .37415 .22285 L .36489 .21702 L p .462 0 0 r
F P
0 g
s
.46099 .26258 m .47213 .28202 L .48953 .28726 L p 0 .417 .822 r
F P
0 g
s
.47213 .28202 m .46099 .26258 L .44141 .25782 L p 0 .417 .816 r
F P
0 g
s
.53604 .34038 m .54042 .32145 L .53997 .31764 L p .705 .65 .094 r
F P
0 g
s
.53462 .32772 m .53716 .33192 L p .53597 .32518 L 0 0 .408 r
F P
0 g
s
.53716 .33192 m .53943 .31299 L .53248 .30551 L p 0 0 .408 r
F P
0 g
s
.53943 .31299 m .53716 .33192 L .53651 .3368 L p .705 .65 .094 r
F P
0 g
s
.53651 .3368 m .53604 .34038 L p .53679 .33431 L .705 .65 .094 r
F P
0 g
s
.53943 .31299 m .53651 .3368 L .53679 .33431 L .705 .65 .094 r
F
.52795 .34983 m .53412 .331 L .53777 .32546 L p .689 .909 .565 r
F P
0 g
s
.53851 .32039 m .53604 .34038 L .53997 .31764 L .705 .65 .094 r
F
.53777 .32546 m .54042 .32145 L p .53747 .32816 L .689 .909 .565 r
F P
0 g
s
.53747 .32816 m .52795 .34983 L .53777 .32546 L .689 .909 .565 r
F
.53997 .31764 m .53943 .31299 L p .53851 .32039 L .705 .65 .094 r
F P
0 g
s
.53248 .30551 m .53257 .32433 L .53462 .32772 L p 0 0 .408 r
F P
0 g
s
.53248 .30551 m .53462 .32772 L .53597 .32518 L 0 0 .408 r
F
.53257 .32433 m .53248 .30551 L .52097 .29883 L p 0 .117 .65 r
F P
0 g
s
.40508 .39879 m .41331 .38166 L .4596 .36708 L p .397 .852 .888 r
F P
0 g
s
.4596 .36708 m .45099 .38484 L .40508 .39879 L p .397 .852 .888 r
F P
0 g
s
.38812 .228 m .40813 .24794 L .42345 .253 L p 0 .385 .785 r
F P
0 g
s
.40813 .24794 m .38812 .228 L .37415 .22285 L p 0 .283 .709 r
F P
0 g
s
.34316 .17303 m .37451 .19329 L .36411 .20247 L p .908 .959 .812 r
F P
0 g
s
.37451 .19329 m .34316 .17303 L .36092 .16223 L p .758 .954 .938 r
F P
0 g
s
.36092 .16223 m .39355 .18249 L .37451 .19329 L p .758 .954 .938 r
F P
0 g
s
.39355 .18249 m .36092 .16223 L .38881 .14935 L p .66 .924 .974 r
F P
0 g
s
.38881 .14935 m .4225 .16976 L .39355 .18249 L p .66 .924 .974 r
F P
0 g
s
.33424 .1821 m .36411 .20247 L .36123 .2103 L p .991 .748 .382 r
F P
0 g
s
.36411 .20247 m .33424 .1821 L .34316 .17303 L p .908 .959 .812 r
F P
0 g
s
.4225 .16976 m .38881 .14935 L .42838 .13402 L p .599 .899 .987 r
F P
0 g
s
.42838 .13402 m .4629 .15471 L .4225 .16976 L p .599 .899 .987 r
F P
0 g
s
.45099 .38484 m .4596 .36708 L .49471 .35377 L p .437 .876 .873 r
F P
0 g
s
.49471 .35377 m .48636 .37203 L .45099 .38484 L p .437 .876 .873 r
F P
0 g
s
.48111 .26747 m .48953 .28726 L .50622 .29281 L p 0 .393 .814 r
F P
0 g
s
.48953 .28726 m .48111 .26747 L .46099 .26258 L p 0 .417 .822 r
F P
0 g
s
.54042 .32145 m .53604 .34038 L .52795 .34983 L p .689 .909 .565 r
F P
0 g
s
.33306 .18973 m .36123 .2103 L .36489 .21702 L p .688 .196 0 r
F P
0 g
s
.36123 .2103 m .33306 .18973 L .33424 .1821 L p .991 .748 .382 r
F P
0 g
s
.40588 .23267 m .42345 .253 L .44141 .25782 L p 0 .435 .821 r
F P
0 g
s
.42345 .253 m .40588 .23267 L .38812 .228 L p 0 .385 .785 r
F P
0 g
s
.48636 .37203 m .49471 .35377 L .51925 .34175 L p .494 .905 .842 r
F P
0 g
s
.51925 .34175 m .51174 .36036 L .48636 .37203 L p .494 .905 .842 r
F P
0 g
s
.4629 .15471 m .42838 .13402 L .48155 .11574 L p .559 .88 .991 r
F P
0 g
s
.48155 .11574 m .51666 .13688 L .4629 .15471 L p .559 .88 .991 r
F P
0 g
s
.53412 .331 m .52795 .34983 L .51174 .36036 L p .579 .933 .767 r
F P
0 g
s
.51174 .36036 m .51925 .34175 L .53412 .331 L p .579 .933 .767 r
F P
0 g
s
.36489 .21702 m .33863 .19616 L .33306 .18973 L p .688 .196 0 r
F P
0 g
s
.33863 .19616 m .36489 .21702 L .37415 .22285 L p 0 .179 .623 r
F P
0 g
s
.50059 .27268 m .50622 .29281 L .52097 .29883 L p 0 .334 .785 r
F P
0 g
s
.50622 .29281 m .50059 .27268 L .48111 .26747 L p 0 .393 .814 r
F P
0 g
s
.42647 .23707 m .44141 .25782 L .46099 .26258 L p 0 .456 .838 r
F P
0 g
s
.44141 .25782 m .42647 .23707 L .40588 .23267 L p 0 .435 .821 r
F P
0 g
s
.35004 .20162 m .37415 .22285 L .38812 .228 L p 0 .349 .755 r
F P
0 g
s
.37415 .22285 m .35004 .20162 L .33863 .19616 L p 0 .179 .623 r
F P
0 g
s
.51814 .27841 m .52097 .29883 L .53248 .30551 L p 0 .213 .716 r
F P
0 g
s
.52097 .29883 m .51814 .27841 L .50059 .27268 L p 0 .334 .785 r
F P
0 g
s
.35559 .39744 m .36358 .3793 L .42244 .36267 L p .372 .836 .893 r
F P
0 g
s
.42244 .36267 m .41331 .38166 L .35559 .39744 L p .372 .836 .893 r
F P
0 g
s
.44885 .24138 m .46099 .26258 L .48111 .26747 L p 0 .455 .843 r
F P
0 g
s
.46099 .26258 m .44885 .24138 L .42647 .23707 L p 0 .456 .838 r
F P
0 g
s
.36638 .20634 m .38812 .228 L .40588 .23267 L p 0 .43 .813 r
F P
0 g
s
.38812 .228 m .36638 .20634 L .35004 .20162 L p 0 .349 .755 r
F P
0 g
s
.53239 .28485 m .53248 .30551 L .53943 .31299 L p 0 0 .538 r
F P
0 g
s
.53248 .30551 m .53239 .28485 L .51814 .27841 L p 0 .213 .716 r
F P
0 g
s
.41331 .38166 m .42244 .36267 L .46915 .3474 L p .402 .855 .885 r
F P
0 g
s
.46915 .3474 m .4596 .36708 L .41331 .38166 L p .402 .855 .885 r
F P
0 g
s
.54192 .29218 m .53943 .31299 L .54 .31787 L p 0 0 .101 r
F P
0 g
s
.54192 .29218 m .54 .31787 L .54075 .31497 L 0 0 .101 r
F
.54042 .32145 m .54525 .30059 L .54192 .29218 L p F P
0 g
s
.53412 .331 m .54092 .31021 L .54343 .30462 L p .705 .866 .458 r
F P
0 g
s
.54343 .30462 m .54525 .30059 L p .54261 .30778 L .705 .866 .458 r
F P
0 g
s
.54261 .30778 m .53412 .331 L .54343 .30462 L .705 .866 .458 r
F
.54 .31787 m .54042 .32145 L p .54075 .31497 L 0 0 .101 r
F P
0 g
s
.53943 .31299 m .54192 .29218 L .53239 .28485 L p 0 0 .538 r
F P
0 g
s
.47191 .24583 m .48111 .26747 L .50059 .27268 L p 0 .435 .837 r
F P
0 g
s
.48111 .26747 m .47191 .24583 L .44885 .24138 L p 0 .455 .843 r
F P
0 g
s
.38674 .21053 m .40588 .23267 L .42647 .23707 L p 0 .471 .841 r
F P
0 g
s
.40588 .23267 m .38674 .21053 L .36638 .20634 L p 0 .43 .813 r
F P
0 g
s
.4596 .36708 m .46915 .3474 L .50397 .33355 L p .445 .88 .868 r
F P
0 g
s
.50397 .33355 m .49471 .35377 L .4596 .36708 L p .445 .88 .868 r
F P
0 g
s
.54525 .30059 m .54042 .32145 L .53412 .331 L p .705 .866 .458 r
F P
0 g
s
.54092 .31021 m .53412 .331 L .51925 .34175 L p .601 .934 .732 r
F P
0 g
s
.49471 .35377 m .50397 .33355 L .52757 .32117 L p .507 .91 .829 r
F P
0 g
s
.52757 .32117 m .51925 .34175 L .49471 .35377 L p .507 .91 .829 r
F P
0 g
s
.51925 .34175 m .52757 .32117 L .54092 .31021 L p .601 .934 .732 r
F P
0 g
s
.49442 .25062 m .50059 .27268 L .51814 .27841 L p 0 .386 .816 r
F P
0 g
s
.50059 .27268 m .49442 .25062 L .47191 .24583 L p 0 .435 .837 r
F P
0 g
s
.41015 .2144 m .42647 .23707 L .44885 .24138 L p 0 .488 .855 r
F P
0 g
s
.42647 .23707 m .41015 .2144 L .38674 .21053 L p 0 .471 .841 r
F P
0 g
s
.51503 .25597 m .51814 .27841 L .53239 .28485 L p 0 .29 .764 r
F P
0 g
s
.51814 .27841 m .51503 .25597 L .49442 .25062 L p 0 .386 .816 r
F P
0 g
s
.43556 .21817 m .44885 .24138 L .47191 .24583 L p 0 .487 .859 r
F P
0 g
s
.44885 .24138 m .43556 .21817 L .41015 .2144 L p 0 .488 .855 r
F P
0 g
s
.36358 .3793 m .37249 .35908 L .43262 .3415 L p .375 .838 .892 r
F P
0 g
s
.43262 .3415 m .42244 .36267 L .36358 .3793 L p .375 .838 .892 r
F P
0 g
s
.53229 .26209 m .53239 .28485 L .54192 .29218 L p 0 .09 .635 r
F P
0 g
s
.53239 .28485 m .53229 .26209 L .51503 .25597 L p 0 .29 .764 r
F P
0 g
s
.46181 .22207 m .47191 .24583 L .49442 .25062 L p 0 .469 .854 r
F P
0 g
s
.47191 .24583 m .46181 .22207 L .43556 .21817 L p 0 .487 .859 r
F P
0 g
s
.54384 .29703 m .54525 .30059 L p .54512 .29365 L 0 0 .285 r
F P
0 g
s
.54525 .30059 m .55059 .27748 L .54467 .26919 L p 0 0 .285 r
F P
0 g
s
.55059 .27748 m .54525 .30059 L .5424 .30692 L p .708 .794 .32 r
F P
0 g
s
.5424 .30692 m .54092 .31021 L p .54281 .30382 L .708 .794 .32 r
F P
0 g
s
.55059 .27748 m .5424 .30692 L .54281 .30382 L .708 .794 .32 r
F
.54467 .26919 m .54192 .29218 L .54384 .29703 L p 0 0 .285 r
F P
0 g
s
.54467 .26919 m .54384 .29703 L .54512 .29365 L 0 0 .285 r
F
.52757 .32117 m .53681 .29829 L .54451 .29092 L p .623 .93 .686 r
F P
0 g
s
.54092 .31021 m .54847 .28713 L .5497 .28153 L p .708 .794 .32 r
F P
0 g
s
.5483 .28523 m .54092 .31021 L .5497 .28153 L .708 .794 .32 r
F
.54451 .29092 m .54847 .28713 L p .54406 .29431 L .623 .93 .686 r
F P
0 g
s
.54406 .29431 m .52757 .32117 L .54451 .29092 L .623 .93 .686 r
F
.5497 .28153 m .55059 .27748 L p .5483 .28523 L .708 .794 .32 r
F P
0 g
s
.54192 .29218 m .54467 .26919 L .53229 .26209 L p 0 .09 .635 r
F P
0 g
s
.42244 .36267 m .43262 .3415 L .47979 .32546 L p .407 .858 .882 r
F P
0 g
s
.47979 .32546 m .46915 .3474 L .42244 .36267 L p .407 .858 .882 r
F P
0 g
s
.46915 .3474 m .47979 .32546 L .51427 .31105 L p .453 .885 .861 r
F P
0 g
s
.51427 .31105 m .50397 .33355 L .46915 .3474 L p .453 .885 .861 r
F P
0 g
s
.48762 .22633 m .49442 .25062 L .51503 .25597 L p 0 .429 .838 r
F P
0 g
s
.49442 .25062 m .48762 .22633 L .46181 .22207 L p 0 .469 .854 r
F P
0 g
s
.54847 .28713 m .54092 .31021 L .52757 .32117 L p .623 .93 .686 r
F P
0 g
s
.50397 .33355 m .51427 .31105 L .53681 .29829 L p .521 .915 .814 r
F P
0 g
s
.53681 .29829 m .52757 .32117 L .50397 .33355 L p .521 .915 .814 r
F P
0 g
s
.51159 .23118 m .51503 .25597 L .53229 .26209 L p 0 .351 .8 r
F P
0 g
s
.51503 .25597 m .51159 .23118 L .48762 .22633 L p 0 .429 .838 r
F P
0 g
s
.53218 .23688 m .53229 .26209 L .54467 .26919 L p 0 .19 .706 r
F P
0 g
s
.53229 .26209 m .53218 .23688 L .51159 .23118 L p 0 .351 .8 r
F P
0 g
s
.37249 .35908 m .38249 .33638 L .44405 .31774 L p .379 .841 .89 r
F P
0 g
s
.44405 .31774 m .43262 .3415 L .37249 .35908 L p .379 .841 .89 r
F P
0 g
s
.54773 .24366 m .54467 .26919 L .55059 .27748 L p 0 0 .441 r
F P
0 g
s
.54467 .26919 m .54773 .24366 L .53218 .23688 L p 0 .19 .706 r
F P
0 g
s
.43262 .3415 m .44405 .31774 L .49172 .30085 L p .413 .862 .878 r
F P
0 g
s
.49172 .30085 m .47979 .32546 L .43262 .3415 L p .413 .862 .878 r
F P
0 g
s
.55655 .25175 m .55059 .27748 L .5492 .28383 L p 0 0 0 r
F P
0 g
s
.55655 .25175 m .5492 .28383 L .55004 .28024 L 0 0 0 r
F
.55059 .27748 m .55655 .25175 L .54773 .24366 L p 0 0 .441 r
F P
0 g
s
.54847 .28713 m .5569 .26138 L .55655 .25175 L p 0 0 0 r
F P
0 g
s
.53681 .29829 m .54715 .27269 L .55359 .26522 L p .646 .918 .624 r
F P
0 g
s
.55359 .26522 m .5569 .26138 L p .55266 .26917 L .646 .918 .624 r
F P
0 g
s
.55266 .26917 m .53681 .29829 L .55359 .26522 L .646 .918 .624 r
F
.5492 .28383 m .54847 .28713 L p .55004 .28024 L 0 0 0 r
F P
0 g
s
.47979 .32546 m .49172 .30085 L .52581 .28583 L p .462 .889 .854 r
F P
0 g
s
.52581 .28583 m .51427 .31105 L .47979 .32546 L p .462 .889 .854 r
F P
0 g
s
.5569 .26138 m .54847 .28713 L .53681 .29829 L p .646 .918 .624 r
F P
0 g
s
.51427 .31105 m .52581 .28583 L .54715 .27269 L p .537 .92 .794 r
F P
0 g
s
.54715 .27269 m .53681 .29829 L .51427 .31105 L p .537 .92 .794 r
F P
0 g
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[13]:=",
  ImageSize->{288, 164},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000Y1000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo0029Ool2002EOol008Ioo`<00097W`8009=oo`00Pgoo0`001dNO0P00
TGoo0020Ool3000<Ail00`00Oomoo`2>Ool007eoo`<00117W`8008ioo`00NWoo0`005DNO0P00S7oo
001gOol30002Cil2000EAil2002;Ool007Aoo`<000M?W`030017WdNO00m7W`<00097W`8008Uoo`00
LGoo0`002dnO0P0034NO0`001dNO0P00Qgoo001_Ool2000@Cil00`00Aim7W`05Ail4000<Ail20025
Ool006eoo`800003Ekl00000011?W`800097W`<00197W`8008=oo`00Jgoo0P001ENo0P003dnO0`00
5TNO0P00PWoo001YOol20009Ekl00`00Cim?W`09Cil30002Bil2000BAil30002Ail20020Ool006Mo
o`8000aG_`8000M?W`8000M;W`8000e7W`<000M7W`03001oogoo07eoo`00IGoo0P0000=SgP000000
3ENo0P000TnO0`002d^O0P0024NO0`002dNO0P00OGoo001SOol20005Hmh2000=Ekl2000@Bil20003
Ail3000@Ail00`00Oomoo`1jOol0069oo`03001SgV?N00MSgP03001G_eNo00QG_`800003Dkl00000
015;W`<001A7W`8007Yoo`00HGoo00@007OI000000QSgP8000IG_`8000EC_`03001;Wd^O00a;W`80
009;W`8001A7W`8007Uoo`00HGoo00D007OIMmUgf@0000USgP80009G_`8000QC_`8000Y;W`8000I;
W`030017WdNO00e7W`@00097O`8007Moo`00H7oo00<007OIMmT00gOI0P002F?N0P0035>o00<004^O
Bil014^O0`002D^O0P002DNO100024Mo00<007ooOol0M7oo001OOol01000O^`000001GOI00<006?N
Hmh016?N0P0000=OgP00000035>o0P000T^O0P003T^O0P000dNO10003DMo0P00M7oo001OOol01@00
O^ank7k/00001GOI0P000V?N0P001EoN00<005>oDkl02U>o0`004D^O10004dMo0P00LWoo001POol0
1000O^ank7k/0P001GOI0P0025oN0P001e>o0`000U>o0P003T^O0P000T^O0P0054Mo0P00LGoo001Q
Ool20003O^`2000017OI000006oK0P002EoN0P000U>o0`001e>o00<004^OBil02D^O0P001T^O00<0
04MoAgl03DMo10000TMo0P00Kgoo001ROol0102c000000000Wk/00<006oKKm/00foK00<005oNGmh0
25oN0P002e>o0P001T^O0`002D^O0P002DMo100024Mo0P00KGoo001SOol00`000;<1N0040005Km/2
0006Gmh200000e_N0000000<Dkl20002Bil2000>Bil20003Agl4000>Agl2001[Ool006Aoo`040000
/`000GP40005Km/20002Gmh20005Fmh00`00DkmC_`0:Dkl3000ABil4000DAgl2001YOol006Ioo`80
0081N081^PH00003Km/0000000QKgP8000MC_`<0009?_`8000e;W`<0009;W`800157O`<00097O`80
06Moo`00Igoo00D0002c0GP1N00000@1^P81nPL000IKgP80009C_`<000M?_`8000Q;W`<000M;W`03
0017OdMo00]7O`<000M7O`03001oogoo06Aoo`00J7oo00D0002c0001N00000@1^P030001nP7j0081
nP<1n`X000a?_`8000=;W`<000];W`8000M7O`@000]7O`03001oogoo06=oo`00JGoo00Dh00000001
N00000@1^P030001nP7j0081nP030001n`7k00<1n`040001n`7k0O/70009Ckl3000@Bil20002Agl3
000@Agl2001SOol006Yoo`8h00030001N00000<1^P030001nP7j00<1nP030001n`7k00<1n`030001
n`7k00<1n`040001n`7k0O/50002Ckl20002Cil2000@Bil3000DAgl2001ROol006aoo`03>0000000
00<000030KX0007j00<1nP030001n`7k00<1n`030001n`7k00@1n`030001n`7k00<1n`030001^P00
00<000A?W`03001;Wd^O00Y;W`<0009;W`8000m7O`@00097O`80061oo`00KGoo00<h00000CH00P6I
1@000P7j00<0007k0O/00`7k00<0007k0O/00`7k00<0007k0O/0107k00<0006j0KX00P6j100000=?
W`00Bil01T^O10001d^O0P002DMo100024Mo0P00GWoo001^Ool013P00001=P000`6I0P6j1@000`7k
00<0007k0O/0107k00<0007k0O/00`7k00<0006j0KX00`6j00<0005i0GT01@0000A;W`00000000e;
W`8000=7O`@000i7O`8005aoo`00L7oo00<0004f00000`6I00<0006j0KX00P6j00<1fP0000000P7k
00<0007k0O/00`7k00<0007k0O/00`7k00<0006j0KX00`6j00<0005i0GT00`5i0P3F0P0044^O1000
4dMo0P00Fgoo001aOol200001@4f0001V@6I00000`6j00@0007J0MX1fPD000<1n`030001n`7k0081
n`030001^P6j00<1^P030001N@5i00<1N@040000eP3F0=H2000;Bil30002Ail2000?Agl40002@gl2
001IOol0079oo`060=@000000001V@00106j00<0007J0MX01@7J1P000`7k00<0006j0KX00`6j00<0
005i0GT00P5i00<0003F0=H00P3F00<03P00Bil01D^O10001dNO0P002DMo100024=o0P00Egoo001c
Ool30=@00`000IT000040KX01@000MX1fP7J00001P7J0P6j1@00106j00<0005i0GT00P5i00<0003F
0=H00P3F00<03P0000000T^O0`003DNO0P000dMo10003T=o0P00EGoo001dOol010000=@0e05G1000
00<1^P000MX00`7J00<0007J0MX00`7J00<0006j0KX00P6j00<0006J00000P0000<1^P000GT00`5i
00<0003F0=H00P3F0P0>0`004DNO10004T=o0`00E7oo001fOol20=@010000EL1V@6I10000`7J00<0
007J0MX00`7J00<0006j0KX00P6j00@0006J0IX1VP<000<1N@050000eP3F0=H0000200h01000Bil0
00003DNO0`000TNO0P003T=o10000d=o0P00DWoo001gOol0103D0001E`5G106I00<1^P0000000P00
1@7J00<0006j0KX00P6j00<0006J0IX00P6J00H0004h0000005i00030=H0100000h000000d^O0P00
1dNO10001dNO00<004=o@gl01d=o10002D=o0P00D7oo001hOol200020EL010000IT1V@000`6j1000
0`7J00D0006j0KX1^P0000@1VP040001>04h0CP200030=H0100000h000001D^O0P000TNO0`0034NO
0P000d=o10003d=o0P00CWoo001iOol01@1b0000005G00000P6I00<0006j0KX0106j1@000P6j00<0
006J0IX00`6J00D0004h0CP1>01D008000040=H000000007Bil3000@Ail4000?@gl40002@gl00`00
Oomoo`1;Ool007Yoo`0307815P0000800081V@050001^P6j0KX000040KX01P000IX000000KX000@1
VP050001>04h0CP0000205@200000e>c001;W`03Bil30002Bil2000<Ail30002Ail2000<@gl30007
@gl2001;Ool007aoo`0300015P4F00<000@1^P030001^P6j0081^P030001VP6J00@00081VP050001
>04h0CP0000305@00`00Dk<000040007Bil00`00Aim7W`05Ail40007Ail00`00@gm3O`06@gl3000<
@gl00`00Oomoo`18Ool007eoo`0400015P4F0EP400000`6j0001^P030KX01@000IX1VP6J00000P5I
0`000`4h00L0001D0017^@00Dk<0000<Bil20002Ail3000<Ail20002@gl4000?@gl20019Ool007io
o`0300015P000081F081N@@00081^P030001VP6J0081VP040001F@5I0ET300001P4h000004Ni001C
/`<000a;W`<000m7W`@000m3O`@00093O`8004Moo`00Ogoo0`000P5H00<0005i0GT00P5i0P0000<1
^P000IX00P6J00H0005I0ET1F@000=H20003AkT00`00Dk<00002Dkl00`00Bim;W`06Bil30002Bil2
000:Ail40003Agl2000:@gl40008@gl20015Ool0081oo`050;@000000EP000030GT00`000GT1N@04
00020IX01P000ET1F@00>i/000A7^@03001C/`0000=C_`80009;W`@000M;W`8000A7W`@000U7O`80
00A3O`@000e3O`<004=oo`00PGoo0P2d0`000`5i00@0005i0GT00081F@D00003>i/004Ni00A7^@<0
00AC_`<000e;W`@000m7O`@000e3O`@000=3O`80045oo`00PWoo0P2d00H15P000000005i00030GT0
0`000ET1F@020003>i/00`00AkU7^@02AkT30003Dkl20002Ckl2000:Bil20002Bil00`00Agm7O`0:
Agl40002Agl20009@gl40009@gl2000oOol008=oo`8000815P040CP0000000020GT30004>i/00`00
AkU7^@03AkT00`00CkD000030006Ckl00`00Bim;W`04Bil30005Bil20007Agl30008Agl20003@gl4
000=@gl3000nOol008Aoo`8000815P<1>0<000HkV`040017^DNiAkT20002CkD00`00Ckm?_`08Ckl2
0002Bil2000:Bil00`00Agm7O`04000<Agl4000=@gl40003@gl2000lOol008Eoo`030340000000D0
00LkV`070017^@000013^P00CkD00`002Tno0`0034^O0`003DMo0`000TMo0P002D=o10002D=o0P00
>Woo0025Ool30004=g`00`00>i/kV`04>i/30002@kX00`00CkE?]@0200000eNn00000004Ckl40002
Ckl20008Bil30002Bil20008Agl40007Agl20003@gl4000=@gl3000iOol0085oo`@000HgO003000k
Vc^K00@kV`8000A3^P04001?]@000004Ekh40008Ckl20002Bil40007Bil20003Agl3000<Agl4000=
@gl40003@gl2000gOol007ioo`<000XgO003000kVc^K008kV`<000A3^PD000=G_P800003Ekl004no
00U?_`<000e;W`<000a7O`<00093O`8000U3O`@000U3O`8003Eoo`00Ngoo0`0000<cG000=g`02CMl
00<003^K>i/00`000S^K00<004>j@kX00T>j00<004ngCkL00P0000=G_P00000015No0P001Tno0P00
0TnO0P0024^O10000TNO0P001dMo10001d=o0P000d=o10003D=o0`00=7oo001hOol30003<e`00`00
=g`gO009=g`00c^K00000004>i/01000@kY3^T>j0`000Tng0`0025No00<004noCkl00`001TnO0P00
0T^O100024NO0P000TMo0`0034=o10003D=o10000d=o0P00<Woo001eOol30006<e`00`00=g`gO007
=g`30006>i/01P00@kX00000@kX0009?]`D000MG_`<000Y?W`<000e7W`<000]3O`@00093O`8000U3
O`@000U3O`03001oogoo02moo`00LWoo0`0023=L00<003Ml=g`01CMl10001c^K0`000d>j00<004ng
CkL00P000eoN0P000UNo0`000U>o0P001dnO0P000T^O0P0024NO10000TNO00<004=o@gl01T=o0`00
24=o0P000d=o10002d=o0P00<Woo001_Ool3000;<e`01000=g`gO3Ml10000cMl00<003^K>i/013^K
0P001D>j00<004ng00000P001EoN0P001e>o0P000TnO0`001T^O0P000TNO10001dNO0P000T=o1000
2d=o1@002d=o100000=3O`00Ool0<Goo001]Ool2000=<e`00`00=g`000020006=g`00`00>i/kV`03
>i/30005@kX60003Gmh200000e_N001C_`07Dkl3000:Bil3000<Ail3000;@gl40003@gl00`00@gm3
O`06@gl40005@gl00`00Oomoo`0`Ool006eoo`03000cG3=L00/cG0<000TgO003000kVc^K00<0008k
V`030013^T>j00=3^P03001;^4^h00<00003Gmh0000000AKgP80009C_`@0009C_`03001;Wd^O00E;
W`<0009;W`030017WdNO00I7W`@000=7W`8000A3O`D000Q3O`800093O`@000U3O`03001oogoo031o
o`00K7oo00<003=L<e`023=L1@002SMl00@003^K000000@kV`030013^T>j0093^P8000=;^0800003
Jo`005_N00MKgP8000MC_`80009;W`<000I;W`800097W`@000U7W`@000e3O`@000]3O`<0039oo`00
K7oo00<003=L<e`01C=L0`0012mL00<003Ml=g`01cMl0`001S^K00<004>j@kX00P0000@oVP00BkQ;
^0@00003Io`005_N00AKgP800003Fmh005>o00MC_`<000Y;W`<000U7W`@00097W`030013Od=o00Q3
O`@000=3O`8000A3O`H00003@gl007oo039oo`00K7oo00<003=L<e`00S=L0`001RmL00<003Ml=g`0
1CMl10001c^K00@004>j0000008oVP04001;^4^hBkP30003Io`200000e_N00000004Fmh20002Dkl4
0002Ckl00`00Bim;W`05Bil30003Bil20003Ail40007Ail20003@gl50008@gl50007@gl00`00Oomo
o`0aOol006]oo`03000cG00000<000T_G004000gO3Ml=g`40003<g`00`00>i/kV`04>i/30004?iX0
0`00BkP000040005Io`00`00FmiKgP06Fmh20007Ckl20002Bil30008Bil3000<Ail40009@gl40003
@gl20006@gl2000cOol006]oo`8000`_G003000gO000008000HcO003000kVc^K00<kV`800003=i/0
03nJ00<oVP<00003AkT005Nd00@00005Io`00000Hod00005Fmh200000eON001?_`07Ckl30008Bil3
0002Bil00`00Aim7W`06Ail40002Agl20004@gl50009@gl20002@gl200000d=o001oo`0bOol006Yo
o`03000_G2mL00/_G0<000TcO003000kVc^K00<0008gV`03000oVSnJ008oVP8000=7^@@0009cn@03
001SoF?m009So@800003Fmh0000000AGgP80009?_`@0009?_`8000=;W`@000I;W`800097W`@000Q7
O`@000i3O`@00093O`03001oogoo039oo`00JWoo00<002mL;e`01bmL1@002S=l00@003^K000000Dg
V`03000oVSnJ00<000=7^@<00006Gfd007?i001_n`001F?m00<005ONEmh01EON0`0024no0`002d^O
0`0024Mo10000TMo00<004=o@gl024=o1@000d=o0P0000=3O`00Ool0<goo001YOol00`00;e`_G005
;e`30004;e`00`00<g`cO007<g`30006=i/01000?iX000000SnK00<004NiAkT00P0000=CeP000000
0P000fok0P0000ASo@00001Og@8000=GgP80009C_`03001?_dno00A?_`80009?_`03001;Wd^O00I;
W`<00097W`8000=7O`@000M7O`8000=3O`D000Q3O`@003Aoo`00JGoo00<002mL;e`00RmL0`001RmL
00<003=l<g`01C=l0`0000<cO000=i/01CNK0`000cnK00L004Ni000004Nj001CeP0300000g_F001_
n`03Ko/00`00GmeOg@03Gmd30005Dkl20002Ckl20005Ckl20002Bil40007Ail3000<Agl40009@gl4
0003@gl00`00Oomoo`0bOol006Qoo`03000_G00000<000T_G004000cO3=l<g`40003<g`00`00=i/g
V`03=i/200000cMl000oV`03?i/20002AkX00`00DmH000030002NmH200000fok001[o0020002Gmd2
00000e_N001C_`05Dkl30008Ckl30008Ail30002Ail00`00Agm7O`06Agl40002@gl20004@gl50007
@gl00`00Oomoo`0bOol006Qoo`8000`_G003000cO000008000LcO003000gVcNK00<0008gO004000o
VcnK?i/30003AkX200000doG000000020003NmH00`00Joa[o002Jo`20004Fmh20002Dkl20002Dkl2
0003Ckl40002Bil20003Ail40006Ail01000Agm7OdMo100024=o10002T=o0`00=7oo001XOol00`00
;e`_G00:;e`30009<g`01000=i/000001CMl00@003nK0000008oV`060017^TNjAkX004oG100000Io
T000NmH007?i0002Jo`00`00Iod00006Fmh20006Dkl30008Bil30009Ail50008@gl40002@gl20004
@gl60002@gl00`00Oomoo`0bOol006Moo`03000_G2mL00L_G0@00003;e`003=l00PcO0<000HgO0<0
00<oV`030017^TNj00<00003CmL0000000<00003Oi0007?i009cn@03001[o000009Wo@80009KgP80
0003Fmh00000009C_`<0009C_`03001;Wd^O00A;W`80009;W`8000A7W`@000=7W`8000A3O`@000M3
O`D000M3O`03001oogoo03=oo`00Igoo00<002mL;e`00bmL100012mL00<003=l<g`01C=l10001cMl
0P001CnK0`0000I3^P00CmM?e`00Fm@400000g_D00000002LoT00`00IoeWo@03Iod20005Fmh20006
Dkl00`00Bim;W`030006Bil40009Ail40007@gl40002@gl20005@gl4000eOol006Ioo`03000_G2mL
00@000P_G004000cO3=l<g`40003<g`00`00=g`gO002=g`40005?i/20003@kX400000e_D00000002
0003Nm@2000016oj000006Om0P0000=So@00Fmh00e_N00<005ON00001U>o0`001d^O0P000T^O00<0
04NOAil01DNO0`000TNO0P000d=o100024=o1@000d=o00<007ooOol0<goo001VOol3000;;e`00`00
<g`000020006<g`00`00=g`000030003=g`01000?i/oVcnK0`0014>j00<004oI00002@0000=gm`00
KoX00Voj00<006?mHod00V?m00@005_N000000=GgP03001C_e>o00<0009?_`8000=;W`<000E;W`03
0017WdNO00@000I7W`@000Q3O`@00093O`8000A3O`03001oogoo03=oo`00IWoo00<002mL;e`02RmL
0`0023=l0`001SMl00<003nK00000P000S^K00<004>j@kX00P000ToI00<005OF00001@0000EkKP00
MoL006oj00800003Jo/006?m00=So@03001GgUON00AGgP8000M?_`<000Q;W`<000M7W`<00097W`80
00A3O`@000M3O`H003Eoo`00IGoo00<002mL;e`01bmL1@001c=l10001cMl0`0013^K00L004>j0000
04>k001?f@0200000eOF00000005000017_C001gm`000f_k00<006?mHod00P0000=Og@0000000UON
0P0000=C_P0000000Tno10000Tno0P000d^O10000T^O0P000TNO10001dNO10001d=o10000T=o0`00
=Woo001UOol00`00;e`_G003;e`40004;e`01000<g`cO3=l10000c=l00<003Ml=g`00SMl10001C^K
0`000T>k10000UOF1`0000Akd`00001cn@80009[n`8000EOg@8000AC_P<000M?_`@000M;W`<000M7
W`@00097O`8000=3O`@000M3O`8003Ioo`00I7oo00<002mL;e`010001bmL00<003=l00000P001S=l
00<003Ml00000`000cMl00@003^K>i/kV`<000A3^`03001;fD_I00D00003Ihl0000000<00003Nm<0
07?i009cn@800003Io`00000009Og@800004Fmh005>nDkh20002Dkl20002Ckl40002Bkl20003Bil4
0002Ail20002Ail40007Agl40007@gl400000d=o001oo`0eOol006Aoo`<000X_G0<000PcO0<000Hg
O003000kV`000080008kV`030013^d>k00<0009;f@03001Cf5?H00800004Ihl00000MbX300001WOf
001cn@00JoX000=Wo08000AKgP8000EC_`<000M;_`@000M7W`<000M7O`@00093O`8000=3O`@000E3
O`03001oogoo03Aoo`00Hgoo00<002mL;e`01bmL1@001c=l10001cMl0`0013^K00L004>k000003nk
001;f@030002DmP600000gN?00000002MoH01@00JoY[nP00Io`00P0000ASo@00001KgP800003Emh0
0000009C_`80009?_`80009;_`@0009;W`8000=7W`@00097W`800097O`@000I3O`D000M3O`<003Io
o`00Hgoo00<002mL;e`00bmL100012mL00@003=l<g`cO0@000<cO003000gO3Ml008gO0@000DkV`<0
00<o^`800097^PD00007Im800000001gS`00Mm@00P0000E_n000JoY[nP0000ESo@03001GgUON00=G
gP8000E?_`<000M;W`@000M7W`<000A3O`H000=3O`8000=3O`@00003@gl007oo03Ioo`00HWoo00<0
02mL;e`010001bmL00<003=l00000P001S=l00<003Ml00000`000cMl00@003^K>i/kV`800004>i`0
03nk?k/30003AkX00`00CmT00002000016OB000006na0P000WOD00L006oh001[nP00Io/00002Hod2
000015om001GgUON0P0000=GgP0000000Tno0P000Tno0P000T^O10000T^O0P000dNO10000dNO1000
2D=o1@000d=o0`00=goo001ROol3000:;e`30008<g`30006=g`00`00>i/000020002>i`01P00?k/0
0000?i/00097^P<00003CmT005_G00@00003Kk4007?C00800004KoL006oh0003Io/20004God20004
Emh30005Ckl30007Bil40004Ail30002Ail20003@gl60003@gl5000jOol0065oo`03000_G2mL00L_
G0D000LcO0@000LgO0<000@kW0<000<oV`<00003Ak/0000000800005FmL006?E001We002000017?C
001_mfog0P0000E[nP00Io/006?l00800005God00000Fmh00002Emh20002Dmh00`00Ckm?_`030002
Ckl01000Bim;Wd^O10000T^O00<004NOAil00`001DNO1@001D=o1000?goo001QOol00`00;e`_G003
;e`40004;e`01000<g`cO3=l10000c=L00<003Ml=g`00SMl0`0000<gO000>i`00S^L0P0000<kW000
?i/00SnK0P000dNk00<004oJCmX01@0000EWe000Ko@006of00800005JoT006_jJoX00004Ho`00`00
FmiKgP02Fmh20004Dmh30005Ckl40006Bil30004Ail40003Ail00`00@gm3O`040013Ool0061oo`03
000_G2mL00@000L_G003000cO000008000HcG003000gO00000<000<gO003000kW0000080008kW003
000oV`0000800003?i/004Nk00<0009?fP03001Gf000009Om`80000<Ko@006ofKoH006_i001[nP00
Io/006?l0P0000=Oo@00Fmh00P0000AGgP00DmiCgP80009C_P03001?_dno00<0009;_`80009;W`@0
00=7W`@000I7W`@004Moo`00H7oo0`002RmL0`001c=L10001SMl0`0013^L0`000cnK0`0000=3^`00
CmX01@000Uog00@006?g001Wm`800004JoP006_i0003Io/00`00GoeOo@02God00`00EmiGgP02Emh2
0004Dkh30006Bkl30005Ail20002Ail01000Aim7WdNO1000Bgoo001OOol00`00;e`_G007;e`50005
<e`40002<e`00`00=g`gO002=g`300000c=l000kW002>i`200000cMl000oV`02?i/20002@k/30002
BmX6000016?g001Wm`000V_h0P0000MWnP00000006?l001Oo@0200000e_m001GgP02000015?N001C
_U>n0P000Tno0P000T^o0`000T^O00<004NOAil00`0014NO1000Cgoo001OOol00`00;e`_G003;e`4
0004;e`00`00<e`000030005<e`00`00=g`000030003<g`00`00>i`000020002=g`00`00?i/00003
00001D>k000004>k00000d_J00<005?I00000U_i0P0000=On000HoT00P0000ASnP00IoX000ASo004
001KoE_mFod20004Dmh20005Ckl30005Bil30003Ail4001COol005ioo`03000_G2mL00@000H_G0@0
00LcG0@000HcO0<000@gO0<000<kW08000=3^`03001;fP0000L0009On003001Sn@00009SnP800003
Ho/006?l00800006God00000001GgP000U?N0P0000ACgP00Ckm?_`<0009?_`03001;Wd^O00<0009;
W`@005Moo`00GWoo0`001RmL100000<_G000<e`013=L100000<_G000<g`00c=l1@000cMl0`0000@g
O000>i`kW0<000=3^`<00005Ak/004oJCmX00002EoX500001Uoj000005ok001Sn`8000=Oo@03001G
gUON009GgP8000ACgP8000A?_`@0009;W`<005]oo`00GWoo00<002mL;e`00RmL100012mL00<003=L
<e`010001BmL1@0013=l10000cMl00L003^L000003^L0013^`0400000dNk000000040002EoX01000
FoYKnP000Uoj00<005okGo/00P000Uol0`0000=Ko@00Emh00P0000AGgP00DmiCgP800003Ckh00000
00<000=;_`<005ioo`00GGoo00<002mL00000`001bmL10001RmL10001S=l0`001CMl0`000S^L0`00
0cnl0P000TNk00@004oKCm]?f`800004Dm/00000Eo/200001U_k000005_l001Oo08000=Ko@8000=G
gP<0009?_P800004Ckh004^oBkl3001QOol005eoo`8000L_G0D000D_G0@0008_G003000cO3=l008c
O0<00003<g`003Ml008gO0@0008kW0800004>i`003nl?k`30002Ak/20003Cm/01000Dm]Cf`000UOk
00@005_kFo/0009Ko080009Ko0<0009Gg@<0009CgP<000=?_P<006Aoo`00GGoo00<002mL;e`00RmL
100012mL00<002mL00000`001BmL00<003=l00000`000c=l00<003Ml00000P000cMl00<kW0000000
0c^L0`000SnL0`0000=3_000Cm/02`0000IGo000001Go000Fo`200001UOm00000000Dmh0009CgP80
0003Cmh004nn008006Moo`00G7oo00<002mL00000`001RmL10001bmL10001C=l100013Ml0`0013^L
0P000cnL0P000T>l0`000T_K00@004oKCm/0009Cn`05001Go5OlEo`00002Eo`20003Eod00`00DmiC
gP02Dmh20003Cmh2001YOol005aoo`8000H_G0@00003;e`002mL00@_G0@00003;e`003=l00H00004
<g`003Ml=g`400000cMl000kW00500000cnL0000000200001T>l000004>l001;f`P00003Dm`00000
00@00003Dmd005Om00800003Dmd005?N00800003Dmh004oN008006]oo`00G7oo00<002mL;e`00RmL
0`0012mL00<002mL;e`010000bmL10001S=l10000cMl10000c^L0`000SnL0`000T>l0`0000=7_000
00000ToL00D005?LDmaCg000009Cg004001CgE?MDmd20002Dmd30002Dmh3001]Ool005]oo`03000_
G00000<000D_G0D000<_G0@00003;e`003=l00<cO0D0008gO0@00003=g`003^L00D00007?i`00000
000oW000@k`00`0000A7_0000017_0@00003Dm`0000000<00005Dm`00000001Cg@030002Dmd3001`
Ool005]oo`8000@_G0D00004;e`002mL;e`40004;e`00`00<g`000030003<e`40004=g`30003>g`3
0003?i`3000014>l000000000TNl0P000T_L0P0000=?g00000000U?L0P0000ICg@00001?g@00Dmd2
001cOol005Yoo`03000_G00000@000D_G0@000L_G0<000<cG0@00003<e`003Ml008gO0@00003>g`0
000000<00003?i`0000000<00006@k`00000?i`004Nl0P0000E3_000000004^l0080009;g080009?
g@04001?gDoMCmd2001eOol005Uoo`<000H_G0@00003;e`002mL00@_G0D00003<e`00000008000@c
G003000gO0000080008cO0<000<gO0<000<kW0<0008oW0<00005@k`00000001;_00300001D_L0000
0000Cmd00P0000A;g@00000007Moo`00FGoo00<002mL;e`00RmL100012mL00<002mL;e`010000bmL
0`001S=L10000S=l100000<gO00000000P0000<gO000>i`00`0000<kW000?i`01P0000A3_0000000
0097_@80009;g@80009;g@8007Uoo`00F7oo00<002mL00000`001RmL1@000bmL1@000S=L1P0000<c
G000<g`00`000S=l0`0013Ml0`000c^L1@0000<oW@00@k`00P0000=3_@00Akd00`0000=;g@000000
1000Ngoo001HOol20005;e`5000012mL000_G2mL10000bmL10001C=L10000S=l10000SMl1@0000<k
W000000010000cnM0`000T>m0`0000=7_@0000000`00Ogoo001GOol00`00;e`_G0050004;e`50003
;e`50002<e`600000c=L000cO00300000c=m000000030003=gd600000c]m000oW@0400000d>m0000
000500000d>m00000021Ool005Moo`<000@_G0D00004:e`002mL;e`40003;e`40005<e`8000013=m
000gOCMm1`000c]m0`000SnM1P0000<oW@00@kd00P00Pgoo001FOol00`00;e`_G0050006:e`30003
;e`50002<e`:0003<gd50002=gd300000c]m0000000200000cMm000oW@050003?id30025Ool005Io
o`<000L[G004000[G2]L0002;e`40003;ed40002;ed50002<gd40002<gd00`00=gd00002000013Mm
0000000013Mm1@0000<kW@00?id00`00R7oo001FOol50008:e`30003;ed500000bmM000000020003
;ed40004<gd800000cMm000gO@060003>id3002;Ool005Qoo`P0008[?003000_GBmM00@0008_G@@0
00@_G@<00004;ed003=m<gd80004=gd600000cMm000kW@03002>Ool005aoo`03000[?2/l00<[?0T0
008_G@03000_G@0000<0008_G@P0008cG@03000gOCMm00H000@gO@<0095oo`00GWoo00<002/m:cd0
100022mM300013=M200000<cO@00=gd01000U7oo001QOol80003;ed30002;ed50002<ed900000c=m
00000004002HOol006Aoo`H00003;ed002mM00@000@_G@d009ioo`00Igoo00@002mM;ed_G@8000D_
G@03000_GBmM00H00:Eoo`00JWoo10000RmM1`00ZGoo001]Ool5002^Ool00?moob5oo`00ogoo8Goo
003oOolQOol00?moob5oo`00ogoo8Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {163, 0}} -> {-0.0012518, 0.127274, \
0.00322283, 0.00322283}},
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[13]=",
  CellTags->{"Equilibrium Surface", "i:2"}]
}, Open  ]],

Cell["\<\
Notice that depending on the values of the parameters mu0 and mu1, there may \
be 0, 1, or 3 equilibria.\
\>", "Text",
  CellTags->{"Equilibrium Surface", "i:2"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Method", "Section",
  CellTags->"Introduction"],

Cell[CellGroupData[{

Cell["Summary", "Subsection",
  CellTags->"Introduction"],

Cell["\<\
The approach is simple in concept. We obtain a system of vector fields that \
define independent flows on the surface, integrate them and generate a \
composition starting at the given nominal point. To integrate each vector \
field we use the exponential map and truncate, hence the results are local.\
\>", "Text",
  CellTags->"Introduction"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Exponential Map", "Subsection",
  CellTags->{"Exponential Map", "i:3"}],

Cell[TextData[{
  "As an example of the flow computation consider the vector field f(x) on ",
  Cell[BoxData[
      \(TraditionalForm\`R\^3\)]],
  ":"
}], "Text",
  CellTags->{"Exponential Map", "i:3"}],

Cell["\<\
f={x1^2+x2,x2,-x3*x2};
x={x1,x2,x3};\
\>", "Input",
  CellLabel->"In[14]:=",
  CellTags->{"Exponential Map", "i:3"}],

Cell["\<\
The flow can be computed up to finite order in the \"time\" parameter:\
\>", "Text",
  CellTags->{"Exponential Map", "i:3"}],

Cell[CellGroupData[{

Cell["Flow=ExpMap[f,x,s,4]", "Input",
  CellLabel->"In[16]:=",
  CellTags->{"Exponential Map", "i:3"}],

Cell[BoxData[
    \({x1 + s\ \((x1\^2 + x2)\) + 
        1\/2\ s\^2\ \((x2 + 2\ x1\ \((x1\^2 + x2)\))\) + 
        1\/6\ s\^3\ \((\((1 + 2\ x1)\)\ x2 + \((x1\^2 + x2)\)\ \((4\ x1\^2 + 
                    2\ \((x1\^2 + x2)\))\))\) + 
        1\/24\ s\^4\ \((x2\ \((1 + 2\ x1 + 4\ x1\^2 + 
                    4\ \((x1\^2 + x2)\))\) + \((x1\^2 + x2)\)\ \((2\ x2 + 
                    12\ x1\ \((x1\^2 + x2)\) + 
                    2\ x1\ \((4\ x1\^2 + 2\ \((x1\^2 + x2)\))\))\))\), 
      x2 + s\ x2 + \(s\^2\ x2\)\/2 + \(s\^3\ x2\)\/6 + \(s\^4\ x2\)\/24, 
      x3 - s\ x2\ x3 + 1\/2\ s\^2\ \((\(-x2\)\ x3 + x2\^2\ x3)\) + 
        1\/6\ s\^3\ \((\(-x2\)\ \((\(-x2\) + x2\^2)\)\ x3 + 
              x2\ \((\(-x3\) + 2\ x2\ x3)\))\) + 
        1\/24\ s\^4\ \((\(-x2\)\ \((x2\ \((\(-1\) + 2\ x2)\) - 
                    x2\ \((\(-x2\) + x2\^2)\))\)\ x3 + 
              x2\ \((\(-x3\) + 4\ x2\ x3 - 
                    x2\ \((\(-1\) + 2\ x2)\)\ x3 - \((\(-x2\) + 
                          x2\^2)\)\ x3)\))\)}\)], "Output",
  CellLabel->"Out[16]=",
  CellTags->{"Exponential Map", "i:3"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Composing Flows to form a Surface", "Subsection",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< ProPac`\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \("\n ProPac has been successfully loaded. It contains packages\n for \
multibody dynamics, linear control and nonlinear control.\n Appropriate \
packages will be loaded automatically as required.\n Packages can be manually \
loaded by simply entering GeometricTools,\n Dynamics, LinearControl, \
NonlinearControl or MEXTools as desired.\n Once a package is loaded, enter \
?GeomtricTools, ?Dynamics,\n ?LinearControl, ?NonlinearControl, or ?MEXTools, \
respectively,\n to obtain a list of available functions."\)], "Print",
  CellTags->{"Composition", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GeometricTools\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \(GeometricTools\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Composition", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["FlowComposition", "Subsubsection",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?FlowComposition\)\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \("FlowComposition[Phi,s,Var,Var0,Param,m] returns the composition of the\
\n list of flows, Phi. s denotes the flow independent variable, Var is a\n of \
dependent variables, Var0 is the initial point from which\n the flows \
eminate, Param (optional - default s) is a list of names\n for the \
parameters, and m (optional -default 3) is the desired order\n of the result. \
It can be called with any of the\n following argument sets:\n \
FlowComposition[Phi,s,Var,Var0]\n FlowComposition[Phi,s,Var,Var0,m]\n  \
FlowComposition[Phi,s,Var,Var0,Param]\n \
FlowComposition[Phi,s,Var,Var0,Param,m]"\)], "Print",
  CellTags->{"Composition", "i:4"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1", "Subsubsection",
  CellTags->{"Composition", "i:4"}],

Cell["\<\
In this example,we begin with an implicit representation of a manifold and \
proceed to generate a parameteric representation, step by step.\
\>", "Text",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Feq = {x1^3 + mu1*x1 + mu0};\)\), "\n", 
    \(DF = Jacobian[Feq, {mu0, mu1, x1}]\)}], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \("  *** LinearControl successfully loaded ***"\)], "Print",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \({{1, x1, mu1 + 3\ x1\^2}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Composition", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Fields = SpecialNullSpace[DF]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \({{\(-mu1\) - 3\ x1\^2, 0, 1}, {\(-x1\), 1, 0}}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"Composition", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Flow1 = ExpMap[Fields[\([1]\)], {mu0, mu1, x1}, s, 4]\), "\n", 
    \(Flow2 = ExpMap[Fields[\([2]\)], {mu0, mu1, x1}, s, 4]\)}], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \({mu0 - s\^3 - 3\ s\^2\ x1 + s\ \((\(-mu1\) - 3\ x1\^2)\), mu1, 
      s + x1}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \({mu0 - s\ x1, mu1 + s, x1}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->{"Composition", "i:4"}]
}, Open  ]],

Cell["The parameters can be specified (e.g. p1, p2)", "Text",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FlowComposition[{Flow1, Flow2}, 
      s, {mu0, mu1, x1}, {0, 0, 0}, {p1, p2}]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \({\(-p1\^3\) - p1\ p2, p2, p1}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->{"Composition", "i:4"}]
}, Open  ]],

Cell["or left as the default s1, s2", "Text",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(FlowComposition[{Flow1, Flow2}, 
      s, {mu0, mu1, x1}, {0, 0, 0}]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \({\(-s1\^3\) - s1\ s2, s2, s1}\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->{"Composition", "i:4"}]
}, Open  ]],

Cell["\<\
Sometimes it is convenient to reorder the dependent variables:\
\>", "Text",
  CellTags->{"Composition", "i:4"}],

Cell["\<\
f1={s+x1,-s^3-mu1*s+mu0,mu1};f2={x1,-x1*s+mu0,s};Phi={f1,f2};\
\>", "Input",
  CellLabel->"In[12]:=",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{

Cell["FlowComposition[Phi,s,{x1,mu0,mu1},{0,0,0}]", "Input",
  CellLabel->"In[14]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \({s1, \(-s1\^3\) - s1\ s2, s2}\)], "Output",
  CellLabel->"Out[14]=",
  CellTags->{"Composition", "i:4"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2", "Subsubsection",
  CellTags->{"Composition", "i:4"}],

Cell["\<\
This example begins with a pair of vector fields. The flows are computed and \
then composed. In this case, we want a 5th order approximation in the \
parameters.\
\>", "Text",
  CellTags->{"Composition", "i:4"}],

Cell["gam1={1,-3*x1^2-mu1,0};gam2={x1^3,-x1,1};", "Input",
  CellLabel->"In[9]:=",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{

Cell["ff1=ExpMap[gam1,{x1,mu0,mu1},s,5]", "Input",
  CellLabel->"In[10]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \({s + x1, mu0 - s\^3 - 3\ s\^2\ x1 + s\ \((\(-mu1\) - 3\ x1\^2)\), 
      mu1}\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->{"Composition", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["ff2=ExpMap[gam2,{x1,mu0,mu1},s,5]", "Input",
  CellLabel->"In[11]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \({x1 + 
        s\ x1\^3 + \(3\ s\^2\ x1\^5\)\/2 + \(5\ s\^3\ x1\^7\)\/2 + \(35\ s\^4\
\ x1\^9\)\/8 + \(63\ s\^5\ x1\^11\)\/8, 
      mu0 - s\ x1 - \(s\^2\ x1\^3\)\/2 - \(s\^3\ x1\^5\)\/2 - \(5\ s\^4\ \
x1\^7\)\/8 - \(7\ s\^5\ x1\^9\)\/8, mu1 + s}\)], "Output",
  CellLabel->"Out[11]=",
  CellTags->{"Composition", "i:4"}]
}, Open  ]],

Cell["Phi={ff1,ff2};", "Input",
  CellLabel->"In[12]:=",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{

Cell["FlowComposition[Phi,s,{x1,mu0,mu1},{0,0,0},5]", "Input",
  CellLabel->"In[13]:=",
  CellTags->{"Composition", "i:4"}],

Cell[BoxData[
    \({s1 + s1\^3\ s2, \(-s1\^3\) - s1\ s2 - \(s1\^3\ s2\^2\)\/2, 
      s2}\)], "Output",
  CellLabel->"Out[13]=",
  CellTags->{"Composition", "i:4"}]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Some Pitfalls", "Section",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{

Cell["Example 1: Implicit set is not a regular manifold", "Subsection",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \(Clear[x, y]\)], "Input",
  CellLabel->"In[35]:=",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \(f1 = {\((x^2 + y^2 - 1)\)*y}; \nvar1 = {x, y}; \)], "Input",
  CellLabel->"In[36]:=",
  CellTags->"Pitfalls"],

Cell["\<\
The set of points that satisfies f1(x,y)=0 includes the unit circle and the \
x-axis. It is the union of two regular manifolds, but the points {-1,0} and \
{1,0} are singular points.\
\>", "Text",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot[{{Cos[k1], Sin[k1]}, {k1/4, 0}}, {k1, \(-2\)*Pi, 2*Pi}, 
      PlotStyle\  -> \n
        \ \ \ \ \ {{RGBColor[1, \ 0, \ 0]}, \ {RGBColor[0, \ 1, \ 0]}}]\)], 
  "Input",
  CellLabel->"In[37]:=",
  CellTags->"Pitfalls"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.303152 0.309017 0.294303 [
[.04527 .29652 -12 -9 ]
[.04527 .29652 12 0 ]
[.19685 .29652 -6 -9 ]
[.19685 .29652 6 0 ]
[.34842 .29652 -12 -9 ]
[.34842 .29652 12 0 ]
[.65158 .29652 -9 -9 ]
[.65158 .29652 9 0 ]
[.80315 .29652 -3 -9 ]
[.80315 .29652 3 0 ]
[.95473 .29652 -9 -9 ]
[.95473 .29652 9 0 ]
[.4875 .01471 -12 -4.5 ]
[.4875 .01471 0 4.5 ]
[.4875 .16187 -24 -4.5 ]
[.4875 .16187 0 4.5 ]
[.4875 .45617 -18 -4.5 ]
[.4875 .45617 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.04527 .30902 m
.04527 .31527 L
s
[(-1.5)] .04527 .29652 0 1 Mshowa
.19685 .30902 m
.19685 .31527 L
s
[(-1)] .19685 .29652 0 1 Mshowa
.34842 .30902 m
.34842 .31527 L
s
[(-0.5)] .34842 .29652 0 1 Mshowa
.65158 .30902 m
.65158 .31527 L
s
[(0.5)] .65158 .29652 0 1 Mshowa
.80315 .30902 m
.80315 .31527 L
s
[(1)] .80315 .29652 0 1 Mshowa
.95473 .30902 m
.95473 .31527 L
s
[(1.5)] .95473 .29652 0 1 Mshowa
.125 Mabswid
.07559 .30902 m
.07559 .31277 L
s
.1059 .30902 m
.1059 .31277 L
s
.13622 .30902 m
.13622 .31277 L
s
.16653 .30902 m
.16653 .31277 L
s
.22716 .30902 m
.22716 .31277 L
s
.25748 .30902 m
.25748 .31277 L
s
.28779 .30902 m
.28779 .31277 L
s
.31811 .30902 m
.31811 .31277 L
s
.37874 .30902 m
.37874 .31277 L
s
.40905 .30902 m
.40905 .31277 L
s
.43937 .30902 m
.43937 .31277 L
s
.46968 .30902 m
.46968 .31277 L
s
.53032 .30902 m
.53032 .31277 L
s
.56063 .30902 m
.56063 .31277 L
s
.59095 .30902 m
.59095 .31277 L
s
.62126 .30902 m
.62126 .31277 L
s
.68189 .30902 m
.68189 .31277 L
s
.71221 .30902 m
.71221 .31277 L
s
.74252 .30902 m
.74252 .31277 L
s
.77284 .30902 m
.77284 .31277 L
s
.83347 .30902 m
.83347 .31277 L
s
.86378 .30902 m
.86378 .31277 L
s
.8941 .30902 m
.8941 .31277 L
s
.92441 .30902 m
.92441 .31277 L
s
.01496 .30902 m
.01496 .31277 L
s
.98504 .30902 m
.98504 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01471 m
.50625 .01471 L
s
[(-1)] .4875 .01471 1 0 Mshowa
.5 .16187 m
.50625 .16187 L
s
[(-0.5)] .4875 .16187 1 0 Mshowa
.5 .45617 m
.50625 .45617 L
s
[(0.5)] .4875 .45617 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04414 m
.50375 .04414 L
s
.5 .07357 m
.50375 .07357 L
s
.5 .103 m
.50375 .103 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.80315 .30902 m
.80312 .31358 L
.80302 .31773 L
.80283 .32252 L
.80258 .32705 L
.80196 .33509 L
.80103 .34379 L
.79969 .35334 L
.79793 .36341 L
.79387 .3813 L
.78848 .39948 L
.78234 .41617 L
.76461 .45263 L
.7414 .48704 L
.71602 .51549 L
.68237 .54411 L
.64668 .56657 L
.61204 .58248 L
.59186 .58948 L
.57316 .59462 L
.55538 .59837 L
.54528 .60002 L
.53593 .60124 L
.52771 .60209 L
.51865 .60276 L
.51409 .603 L
.50919 .60318 L
.50456 .60329 L
.50034 .60332 L
.49562 .60329 L
.4912 .6032 L
.48635 .60302 L
.48112 .60275 L
.47595 .60239 L
.4705 .60192 L
.46079 .60085 L
.4435 .59816 L
.42479 .59412 L
.40484 .58844 L
.38401 .58093 L
.34815 .56374 L
.31418 .54155 L
.28121 .51273 L
.25436 .48149 L
.23376 .44975 L
.22533 .43356 L
.21744 .41563 L
.21162 .39976 L
.20635 .38212 L
.20371 .37128 L
Mistroke
.20164 .36114 L
.19988 .35057 L
.19864 .34095 L
.19816 .33639 L
.19773 .33144 L
.19742 .32717 L
.19716 .32248 L
.19697 .31748 L
.19691 .31475 L
.19687 .3122 L
.19685 .30763 L
.19692 .30275 L
.19706 .298 L
.19718 .2953 L
.19731 .29277 L
.19765 .28768 L
.19811 .2822 L
.19921 .27233 L
.20052 .26333 L
.20463 .24274 L
.21057 .22146 L
.22432 .18659 L
.23409 .16768 L
.24441 .15076 L
.2695 .11786 L
.29725 .09022 L
.32515 .0686 L
.35808 .04896 L
.39265 .03378 L
.41306 .02708 L
.43254 .02209 L
.44321 .01992 L
.4534 .01821 L
.4627 .01695 L
.47264 .01592 L
.47777 .01551 L
.48344 .01515 L
.48861 .01492 L
.49347 .01478 L
.49625 .01474 L
.49917 .01472 L
.5044 .01474 L
.50731 .0148 L
.51003 .01488 L
.513 .01498 L
.51618 .01513 L
.52109 .01543 L
.52649 .01584 L
.53737 .01696 L
.54741 .01834 L
Mistroke
.55676 .01992 L
.57761 .02452 L
.59959 .03105 L
.63826 .0471 L
.67131 .06621 L
.70229 .08982 L
.728 .11505 L
.75238 .14598 L
.76403 .16441 L
.77349 .18205 L
.78868 .21918 L
.79455 .23941 L
.79697 .24987 L
.79912 .26116 L
.80063 .27116 L
.80171 .28032 L
.80212 .28474 L
.80249 .28955 L
.80276 .2941 L
.80295 .29831 L
.80309 .30318 L
.80315 .30776 L
.80313 .31278 L
.80308 .3156 L
.80301 .31818 L
.80281 .32309 L
.80265 .32587 L
.80249 .32846 L
.80208 .3337 L
.80155 .33924 L
.80029 .34938 L
.7988 .35869 L
.79433 .3795 L
.78922 .3972 L
.78231 .41626 L
.76607 .45006 L
.74702 .47962 L
.72061 .51087 L
.6917 .53701 L
.66295 .55719 L
.62911 .5753 L
.60949 .58345 L
.59054 .58989 L
.57298 .59466 L
.55417 .59858 L
.54426 .60017 L
.53335 .60153 L
.52854 .60201 L
.52339 .60244 L
.51855 .60277 L
Mistroke
.51408 .603 L
.51136 .60311 L
.50846 .6032 L
.50556 .60327 L
.50236 .60331 L
.4996 .60332 L
.49663 .6033 L
.49383 .60326 L
.49127 .6032 L
.48618 .60301 L
.48331 .60287 L
.48063 .60272 L
.47054 .60193 L
.46544 .6014 L
.46005 .60075 L
.45043 .59936 L
.42892 .59512 L
.41063 .59024 L
.39095 .58362 L
.35602 .56801 L
.32547 .54966 L
.29308 .5241 L
.26599 .49611 L
.24505 .46825 L
.22626 .43547 L
.21225 .40164 L
.20624 .38171 L
.20193 .36267 L
.20023 .35283 L
.19881 .34242 L
.1979 .3335 L
.19751 .32844 L
.19723 .32372 L
.1971 .32107 L
.197 .31821 L
.19692 .3155 L
.19688 .313 L
.19685 .30827 L
.19691 .30326 L
.19697 .30067 L
.19706 .29789 L
.1973 .29286 L
.19771 .28689 L
.19818 .28144 L
.19929 .27177 L
.20057 .26304 L
.20442 .24364 L
.20918 .22593 L
.21468 .20956 L
.23058 .1741 L
Mistroke
.25297 .13842 L
.27695 .10971 L
.30726 .08185 L
.34281 .05737 L
.3789 .03922 L
.39755 .03203 L
.41833 .02559 L
.43834 .02086 L
.448 .01908 L
.4571 .01768 L
.46597 .01657 L
.47412 .01579 L
.47845 .01546 L
.48319 .01517 L
.48796 .01495 L
.49298 .01479 L
.498 .01472 L
.50257 .01472 L
.50783 .01481 L
.51279 .01498 L
.51739 .0152 L
.52162 .01546 L
.53116 .01627 L
.54089 .0174 L
.54973 .0187 L
.56945 .02254 L
.58745 .02722 L
.60421 .03265 L
.64036 .04816 L
.67698 .07007 L
.70601 .09311 L
.7344 .12238 L
.75938 .15667 L
.77804 .19174 L
.78909 .22041 L
.79346 .23521 L
.79734 .25165 L
.79988 .26588 L
.80099 .2739 L
.8018 .28122 L
.80238 .28806 L
.80263 .29167 L
.80283 .29549 L
.80297 .29884 L
.80308 .30252 L
.80314 .30588 L
.80315 .30902 L
Mfstroke
0 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[37]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oSoooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo0026oooo1@0000Coool00`000?ooooooo`2>
oooo0028oooo00<0003oooooool01?ooo`030000oooooooo08koool008;oool3000000?ooooo003o
00004Ol008Ooool007ooool8o`0000?oool0003oool01Oooo`030000oooooooo00Goool9o`00P?oo
o`00Noooo`Ko0007oooo00<0003oooooool01?ooo`030000oooooooo00coool7o`00Noooo`00Mooo
o`Co000<oooo0P0000Koool00`000?ooooooo`0@oooo1Ol007Woool007Coool4o`005oooo`030000
oooooooo01Goool4o`00MOooo`00LOooo`Co000Joooo00<0003oooooool06?ooo`Co001boooo001^
oooo1?l001goool00`000?ooooooo`0Koooo0ol0073oool006coool3o`008?ooo`030000oooooooo
01koool2o`00K_ooo`00J_ooo`?o000Roooo0P00027oool3o`00Joooo`00J?ooo`?o000Toooo00<0
003oooooool08_ooo`?o001Yoooo001Voooo0ol002Koool00`000?ooooooo`0Toooo0ol006Ooool0
06Coool3o`00:?ooo`030000oooooooo02Koool3o`00IOooo`00H_ooo`?o000Zoooo00<0003ooooo
ool0:?ooo`;o001Toooo001Poooo0ol002coool00`000?ooooooo`0Zoooo0_l006;oool005ooool2
o`00;_ooo`030000oooooooo02_oool3o`00H?ooo`00GOooo`;o000`oooo00<0003oooooool0;Ooo
o`;o001Ooooo001Loooo0_l0037oool00`000?ooooooo`0_oooo0_l005goool005_oool00ol00?oo
ooooo`0aoooo0P00037oool2o`00G?ooo`00FOooo`;o000doooo00<0003oooooool0<_ooo`;o001J
oooo001Hoooo0_l003Goool00`000?ooooooo`0coooo0_l005Woool005Ooool00ol00?ooooooo`0e
oooo00<0003oooooool0=Oooo`;o001Goooo001Foooo00?o003oooooool0=_ooo`030000oooooooo
03Koool2o`00E_ooo`00EOooo`03o`00oooooooo03Ooool00`000?ooooooo`0hoooo00?o003ooooo
ool0Doooo`00Doooo`;o000joooo00<0003oooooool0>Oooo`03o`00oooooooo05;oool005;oool2
o`00>oooo`030000oooooooo03[oool00ol00?ooooooo`1Aoooo001Aoooo0_l003coool20000??oo
o`03o`00oooooooo053oool0053oool2o`00?Oooo`030000oooooooo03_oool2o`00DOooo`00Cooo
o`03o`00oooooooo03goool00`000?ooooooo`0loooo00?o003oooooool0Coooo`00C_ooo`03o`00
oooooooo03koool00`000?ooooooo`0moooo00?o003oooooool0C_ooo`00COooo`03o`00oooooooo
03ooool00`000?ooooooo`0noooo00?o003oooooool0COooo`00C?ooo`;o0011oooo00<0003ooooo
ool0?oooo`03o`00oooooooo04coool004coool00ol00?ooooooo`10oooo00<0003oooooool0@?oo
o`03o`00oooooooo04_oool004_oool00ol00?ooooooo`11oooo00<0003oooooool0@?ooo`;o001<
oooo001:oooo00?o003oooooool0@_ooo`030000oooooooo047oool00ol00?ooooooo`1:oooo0019
oooo0_l004Coool20000@oooo`03o`00oooooooo04Woool004Woool00ol00?ooooooo`13oooo00<0
003oooooool0@oooo`03o`00oooooooo04Soool004Soool00ol00?ooooooo`14oooo00<0003ooooo
ool0@oooo`;o0019oooo0017oooo0_l004Koool00`000?ooooooo`14oooo00?o003oooooool0Aooo
o`00Aoooo`03o`00oooooooo04Goool00`000?ooooooo`15oooo00?o003oooooool0A_ooo`00A_oo
o`03o`00oooooooo04Koool00`000?ooooooo`16oooo00?o003oooooool0AOooo`00AOooo`;o000g
oooo00<0003oooooool00_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo00<0003ooooo
ool0A_ooo`03o`00oooooooo04Goool004Goool00ol00?ooooooo`0eoooo00<0003oool000001ooo
o`030000oooo000000Goool00`000?ooooooo`17oooo00?o003oooooool0A?ooo`00A?ooo`;o000b
oooo0`0000;oool00`000?ooo`000009oooo00<0003oooooool00oooo`<00017oooo0_l004Goool0
04Coool00ol00?ooooooo`0foooo00<0003oool000001oooo`800006oooo00<0003oooooool0B?oo
o`03o`00oooooooo04?oool004?oool00ol00?ooooooo`0goooo00<0003oool000001oooo`030000
oooooooo00Goool00`000?ooooooo`19oooo00?o003oooooool0@_ooo`00@_ooo`;o000joooo00<0
003oooooool01_ooo`<00005oooo00<0003oooooool0BOooo`03o`00oooooooo04;oool004;oool0
0ol00?ooooooo`1:oooo00<0003oooooool0B_ooo`03o`00oooooooo047oool0047oool2o`00C?oo
o`030000oooooooo04[oool00ol00?ooooooo`11oooo0011oooo00?o003oooooool0Boooo`030000
oooooooo04_oool00ol00?ooooooo`10oooo0010oooo0_l004goool00`000?ooooooo`1;oooo00?o
003oooooool0@?ooo`00@?ooo`03o`00oooooooo04coool20000COooo`03o`00oooooooo03ooool0
03ooool2o`00C_ooo`030000oooooooo04coool00ol00?ooooooo`0ooooo000ooooo0_l004koool0
0`000?ooooooo`1<oooo0_l0043oool003koool2o`00Coooo`030000oooooooo04goool00ol00?oo
ooooo`0noooo000noooo0_l004ooool00`000?ooooooo`1=oooo00?o003oooooool0?_ooo`00?_oo
o`03o`00oooooooo04koool00`000?ooooooo`1>oooo00?o003oooooool0?Oooo`00?Oooo`;o001@
oooo00<0003oooooool0C_ooo`03o`00oooooooo03goool003goool00ol00?ooooooo`1?oooo00<0
003oooooool0C_ooo`;o000noooo000loooo0_l0057oool00`000?ooooooo`1?oooo00?o003ooooo
ool0??ooo`00??ooo`03o`00oooooooo053oool20000D?ooo`03o`00oooooooo03coool003coool0
0ol00?ooooooo`1@oooo00<0003oooooool0D?ooo`03o`00oooooooo03_oool003coool00ol00?oo
ooooo`1@oooo00<0003oooooool0D?ooo`03o`00oooooooo03_oool003_oool2o`00D_ooo`030000
oooooooo053oool2o`00??ooo`00>oooo`03o`00oooooooo057oool00`000?ooooooo`1Aoooo00?o
003oooooool0>_ooo`00>oooo`03o`00oooooooo057oool00`000?ooooooo`1Aoooo00?o003ooooo
ool0>_ooo`00>oooo`03o`00oooooooo057oool00`000?ooooooo`1Aoooo00?o003oooooool0>_oo
o`00>oooo`03o`00oooooooo057oool00`000?ooooooo`1Boooo00?o003oooooool0>Oooo`00>ooo
o`03o`00oooooooo057oool20000Doooo`03o`00oooooooo03Woool003[oool00ol00?ooooooo`1B
oooo00<0003oooooool0D_ooo`03o`00oooooooo03Woool003[oool00ol00?ooooooo`1Boooo00<0
003oooooool0D_ooo`03o`00oooooooo03Woool003[oool00ol00?ooooooo`1Boooo00<0003ooooo
ool0D_ooo`;o000joooo000joooo00?o003oooooool0D_ooo`030000oooooooo05;oool2o`00>_oo
o`002?ooo`D00002oooo00<0003oooooool00_ooo`030000oooooooo02;oool2o`000`0002?oool0
0`000?ooooooo`02oooo00<0003oooooool00_ooo`030000oooooooo027oool00`000?ooooooo`0S
oooo00<0003oooooool00_ooo`030000oooooooo00;oool00`000?ooooooo`0Qoooo0P000003o`00
00000000027oool500000_ooo`030000oooooooo00;oool00`000?ooooooo`08oooo000:oooo00<0
003oooooool01_ooo`030000oooo000002?oool00ol00?ooo`00000Toooo00<0003oool000001ooo
o`030000oooo000002;oool00`000?ooooooo`0Roooo00<0003oool000001oooo`030000oooo0000
02Coool00ol00?ooooooo`0Soooo00<0003oooooool01_ooo`030000oooo000000Woool000Coool3
00000oooo`030000oooooooo00Soool00`000?ooooooo`0Moooo0`000004ooooo`00oooo00007ooo
o`<00002oooo00<0003oool000002Oooo`030000oooooooo023oool00`000?ooooooo`0Roooo00<0
003oool000002Oooo`030000oooooooo02;oool00ol00?ooooooo`0Soooo00<0003oooooool02?oo
o`030000oooooooo00Ooool000[oool00`000?ooooooo`06oooo0P0002Coool00ol00?ooo`00000T
oooo00<0003oool000001oooo`80000Soooo00<0003oooooool08_ooo`030000oooo000000Ooool2
00009Oooo`03o`00oooooooo02?oool00`000?ooooooo`06oooo0P0000[oool000[oool00`000?oo
ooooo`06oooo00<0003oooooool08oooo`03o`00oooo000002Coool00`000?ooo`000007oooo00<0
003oooooool08_ooo`80000Soooo00<0003oool000001oooo`030000oooooooo02Coool00ol00?oo
ooooo`0Soooo00<0003oooooool01_ooo`030000oooooooo00Woool000Woool200002?ooo`<0000S
oooo00?o0000000000009Oooo`030000oooooooo00Koool300008_ooo`030000oooooooo02?oool0
0`000?ooooooo`06oooo0`0002?oool00`000?l00?ooo`0Soooo0P0000Soool300002Oooo`00>Ooo
o`03o`00oooooooo05?oool00`000?ooooooo`1Coooo00?o003oooooool0>?ooo`00>Oooo`03o`00
oooooooo05?oool00`000?ooooooo`1Coooo00?o003oooooool0>?ooo`00>Oooo`03o`00oooooooo
05?oool00`000?ooooooo`1Coooo00?o003oooooool0>?ooo`00>Oooo`03o`00oooooooo05?oool0
0`000?ooooooo`1Coooo00?o003oooooool0>?ooo`00>Oooo`03o`00oooooooo05?oool00`000?oo
ooooo`1Coooo00?o003oooooool0>?ooo`00>Oooo`03o`00oooooooo05?oool00`000?ooooooo`1C
oooo00?o003oooooool0>?ooo`001`000?l0o`0B0?l01`00007oool000Goool00`000?ooooooo`05
oooo00<0003oooooool01_ooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Koool00ol00?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01_ooo`030000oooooooo00Goool0
0`000?ooooooo`06oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`06
oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`03o`00oooooooo00Koool0
0`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`06
oooo00<0003oooooool01Oooo`030000oooooooo00Coool000goool00`000?ooooooo`0Yoooo00?o
003oooooool0:?ooo`030000oooooooo02Soool00`000?ooooooo`0Xoooo00<0003oooooool0:?oo
o`03o`00oooooooo02Woool00`000?ooooooo`0<oooo000ioooo00?o003oooooool0Doooo`030000
oooooooo05?oool00ol00?ooooooo`0hoooo000ioooo00?o003oooooool0Doooo`030000oooooooo
05?oool00ol00?ooooooo`0hoooo000ioooo00?o003oooooool0Doooo`030000oooooooo05?oool0
0ol00?ooooooo`0hoooo000ioooo00?o003oooooool0Doooo`030000oooooooo05?oool00ol00?oo
ooooo`0hoooo000ioooo00?o003oooooool0Doooo`030000oooooooo05?oool00ol00?ooooooo`0h
oooo000ioooo00?o003oooooool0Doooo`80001Doooo00?o003oooooool0>?ooo`00>Oooo`03o`00
oooooooo05?oool00`000?ooooooo`1Coooo00?o003oooooool0>?ooo`00>Oooo`03o`00oooooooo
05?oool00`000?ooooooo`1Coooo00?o003oooooool0>?ooo`00>Oooo`03o`00oooooooo05?oool0
0`000?ooooooo`1Coooo00?o003oooooool0>?ooo`00>Oooo`03o`00oooooooo05?oool00`000?oo
ooooo`1Coooo00?o003oooooool0>?ooo`00>Oooo`03o`00oooooooo05?oool00`000?ooooooo`1B
oooo0_l003[oool003[oool00ol00?ooooooo`1Boooo00<0003oooooool0D_ooo`;o000joooo000j
oooo00?o003oooooool0D_ooo`030000oooooooo05;oool00ol00?ooooooo`0ioooo000joooo00?o
003oooooool0D_ooo`030000oooooooo05;oool00ol00?ooooooo`0ioooo000joooo00?o003ooooo
ool0D_ooo`80001Boooo0_l003_oool003[oool2o`00Doooo`030000oooooooo057oool2o`00>ooo
o`00>_ooo`;o001Coooo00<0003oooooool0DOooo`03o`00oooooooo03[oool003_oool00ol00?oo
ooooo`1Aoooo00<0003oooooool0DOooo`03o`00oooooooo03[oool003_oool00ol00?ooooooo`1A
oooo00<0003oooooool0DOooo`03o`00oooooooo03[oool003_oool00ol00?ooooooo`1Aoooo00<0
003oooooool0DOooo`03o`00oooooooo03[oool003coool00ol00?ooooooo`1@oooo00<0003ooooo
ool0D?ooo`03o`00oooooooo03_oool003coool00ol00?ooooooo`1@oooo00<0003oooooool0D?oo
o`03o`00oooooooo03_oool003goool00ol00?ooooooo`1?oooo0P00053oool2o`00?Oooo`00?Ooo
o`03o`00oooooooo04ooool00`000?ooooooo`1?oooo0_l003goool003goool00ol00?ooooooo`1?
oooo00<0003oooooool0Coooo`03o`00oooooooo03coool003koool00ol00?ooooooo`1>oooo00<0
003oooooool0Coooo`03o`00oooooooo03coool003koool00ol00?ooooooo`1>oooo00<0003ooooo
ool0C_ooo`;o000noooo000noooo0_l004ooool00`000?ooooooo`1>oooo00?o003oooooool0?Ooo
o`00?oooo`03o`00oooooooo04goool00`000?ooooooo`1>oooo00?o003oooooool0?Oooo`00?ooo
o`03o`00oooooooo04goool00`000?ooooooo`1=oooo00?o003oooooool0?_ooo`00@?ooo`03o`00
oooooooo04coool00`000?ooooooo`1=oooo00?o003oooooool0?_ooo`00@?ooo`03o`00oooooooo
04coool20000COooo`03o`00oooooooo03ooool0047oool00ol00?ooooooo`1;oooo00<0003ooooo
ool0C?ooo`03o`00oooooooo03ooool0047oool00ol00?ooooooo`1;oooo00<0003oooooool0Booo
o`03o`00oooooooo043oool004;oool00ol00?ooooooo`1:oooo00<0003oooooool0B_ooo`;o0012
oooo0012oooo00?o003oooooool0B_ooo`030000oooooooo04[oool00ol00?ooooooo`11oooo0013
oooo00?o003oooooool0BOooo`030000oooooooo04Woool2o`00@oooo`00@oooo`03o`00oooooooo
03Soool00`000?ooooooo`02oooo00<0003oooooool00_ooo`030000oooooooo00Coool00`000?oo
ooooo`19oooo00?o003oooooool0@_ooo`00A?ooo`03o`00oooooooo03Koool00`000?ooo`000007
oooo00<0003oool000001Oooo`030000oooooooo04Soool00ol00?ooooooo`13oooo0014oooo00?o
003oooooool0=_ooo`030000oooo000000Woool00`000?ooooooo`03oooo0`0004Ooool2o`00AOoo
o`00AOooo`03o`00oooooooo03Goool00`000?ooo`000007oooo0P0000Koool00`000?ooooooo`17
oooo00?o003oooooool0A?ooo`00AOooo`;o000foooo00<0003oool000001oooo`030000oooooooo
00Goool00`000?ooooooo`16oooo00?o003oooooool0AOooo`00A_ooo`03o`00oooooooo03Goool0
0`000?ooooooo`06oooo0`0000Goool00`000?ooooooo`16oooo00?o003oooooool0AOooo`00Aooo
o`03o`00oooooooo04Goool00`000?ooooooo`15oooo00?o003oooooool0A_ooo`00B?ooo`03o`00
oooooooo04Coool00`000?ooooooo`14oooo00?o003oooooool0Aoooo`00B?ooo`03o`00oooooooo
04Coool00`000?ooooooo`14oooo00?o003oooooool0Aoooo`00BOooo`03o`00oooooooo04?oool0
0`000?ooooooo`13oooo00?o003oooooool0B?ooo`00B_ooo`03o`00oooooooo04;oool20000@ooo
o`;o001:oooo001;oooo00?o003oooooool0@Oooo`030000oooooooo047oool2o`00Boooo`00Booo
o`;o0012oooo00<0003oooooool0@Oooo`03o`00oooooooo04[oool004coool2o`00@Oooo`030000
oooooooo043oool00ol00?ooooooo`1;oooo001=oooo00?o003oooooool0?oooo`030000oooooooo
03ooool00ol00?ooooooo`1<oooo001>oooo00?o003oooooool0?_ooo`030000oooooooo03koool0
0ol00?ooooooo`1=oooo001?oooo00?o003oooooool0?Oooo`030000oooooooo03koool00ol00?oo
ooooo`1=oooo001@oooo00?o003oooooool0??ooo`030000oooooooo03goool00ol00?ooooooo`1>
oooo001Aoooo00?o003oooooool0>oooo`030000oooooooo03coool00ol00?ooooooo`1?oooo001B
oooo00?o003oooooool0>_ooo`80000loooo00?o003oooooool0D?ooo`00Doooo`03o`00oooooooo
03Woool00`000?ooooooo`0joooo00?o003oooooool0DOooo`00E?ooo`03o`00oooooooo03Soool0
0`000?ooooooo`0hoooo0_l005Coool005Goool2o`00>?ooo`030000oooooooo03Ooool2o`00EOoo
o`00E_ooo`;o000goooo00<0003oooooool0=_ooo`03o`00oooooooo05Goool005Ooool2o`00=_oo
o`030000oooooooo03Goool00ol00?ooooooo`1Foooo001Hoooo0_l003Goool00`000?ooooooo`0c
oooo0_l005Woool005[oool00ol00?ooooooo`0boooo00<0003oooooool0<_ooo`;o001Joooo001K
oooo0_l003;oool20000<_ooo`03o`00oooooooo05[oool005coool2o`00<Oooo`030000oooooooo
02ooool2o`00GOooo`00GOooo`;o000`oooo00<0003oooooool0;_ooo`03o`00oooooooo05goool0
05koool3o`00;_ooo`030000oooooooo02coool2o`00H?ooo`00H?ooo`;o000]oooo00<0003ooooo
ool0:oooo`;o001Qoooo001Roooo0_l002_oool00`000?ooooooo`0Yoooo0_l006?oool006Coool2
o`00:Oooo`030000oooooooo02Ooool3o`00I?ooo`00IOooo`?o000Woooo00<0003oooooool09Ooo
o`?o001Voooo001Woooo0ol002Goool00`000?ooooooo`0Soooo0ol006Soool006Woool4o`008_oo
o`80000Roooo0ol006[oool006_oool4o`008?ooo`030000oooooooo01koool3o`00KOooo`00KOoo
o`Go000Moooo00<0003oooooool06oooo`Co001_oooo001`oooo1Ol001[oool00`000?ooooooo`0I
oooo0ol007;oool007?oool5o`005oooo`030000oooooooo01Koool3o`00MOooo`00Moooo`Go000C
oooo00<0003oooooool05?ooo`;o001hoooo001joooo1?l000Soool500001?ooo`030000oooooooo
013oool4o`00N_ooo`00O_ooo`So0002oooo00<0003oooooool01?ooo`030000oooooooo00Ooool9
o`00O_ooo`00Q_oooa?o0027oooo0028oooo00<0003oooooool01?ooo`030000oooooooo08koool0
08Soool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00Qoooo`800006oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.65911, -1.05362, 
  0.0115618, 0.0119094}},
  CellTags->"Pitfalls"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[37]=",
  CellTags->"Pitfalls"]
}, Open  ]],

Cell["\<\
We can easily compute a local parametric approximation around a regular \
point, say {0,1}:\
\>", "Text",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{

Cell[BoxData[
    \(var1\)], "Input",
  CellLabel->"In[38]:=",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \({x, y}\)], "Output",
  CellLabel->"Out[38]=",
  CellTags->"Pitfalls"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Man = ParametricManifold[f1, var1, {0, 1}, 4]\)], "Input",
  CellLabel->"In[39]:=",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \("1 vector fields computed."\)], "Print",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \("1 flow functions computed."\)], "Print",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \({{\(-2\)\ k1 + \(8\ k1\^3\)\/3, 1 - 2\ k1\^2 + \(10\ k1\^4\)\/3}, {k1}}
      \)], "Output",
  CellLabel->"Out[39]=",
  CellTags->"Pitfalls"]
}, Open  ]],

Cell["But computation at a singular point is meaningless.", "Text",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Man = ParametricManifold[f1, var1, {1, 0}, 4]\)], "Input",
  CellLabel->"In[40]:=",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \("Equations may be redundant"\)], "Print",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \("1 vector fields computed."\)], "Print",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \("Warning! Manifold may not be regular at nominal point."\)], "Print",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \("1 flow functions computed."\)], "Print",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \("Manifold may not be regular at nominal point."\)], "Print",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \({{1, 0}, {k1}}\)], "Output",
  CellLabel->"Out[40]=",
  CellTags->"Pitfalls"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2: redundent defining relations", "Subsection",
  CellTags->"Pitfalls"],

Cell["\<\
If the imbedding relations are not independent, the results may still be \
useful:\
\>", "Text",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \(\(f2 = {x + y, \((x + y)\)^2}; \)\)], "Input",
  CellLabel->"In[41]:=",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricManifold[f2, {x, y}, {0, 0}, 3]\)], "Input",
  CellLabel->"In[42]:=",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \("Equations may be redundant"\)], "Print",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \("1 vector fields computed."\)], "Print",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \("1 flow functions computed."\)], "Print",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \({{\(-k1\), k1}, {k1}}\)], "Output",
  CellLabel->"Out[42]=",
  CellTags->"Pitfalls"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f3 = {x + y + p, \((x + y + p)\)^2}\)], "Input",
  CellLabel->"In[43]:=",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \({p + x + y, \((p + x + y)\)\^2}\)], "Output",
  CellLabel->"Out[43]=",
  CellTags->"Pitfalls"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(EquilibriumSurface[f2, {x, y}, {p}, {0, 0}, {0}, s, 3]\)], "Input",
  CellLabel->"In[44]:=",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \("Equations may be redundant"\)], "Print",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \("2 vector fields computed."\)], "Print",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \("2 flow functions computed."\)], "Print",
  CellTags->"Pitfalls"],

Cell[BoxData[
    \({{\(-s1\), s1, s2}, {s1, s2}}\)], "Output",
  CellLabel->"Out[44]=",
  CellTags->"Pitfalls"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["A More Complex Example", "Section"],

Cell[CellGroupData[{

Cell["Longitudinal Dynamics of an Aircraft", "Subsection",
  CellTags->"Aircraft Example"],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< ProPac`\)], "Input",
  CellLabel->"In[45]:=",
  CellTags->"Aircraft Example"],

Cell[BoxData[
    \("\n ProPac has been successfully loaded. It contains packages\n for \
multibody dynamics, linear control and nonlinear control.\n Appropriate \
packages will be loaded automatically as required.\n Packages can be manually \
loaded by simply entering Dynamics,\n LinearControl or NonlinearControl as \
desired. Once a package is\n loaded, enter ?Dynamics, ?LinearControl or \
?NonlinearControl,\n respectively, to obtain a list of available \
functions."\)], "Print",
  CellTags->"Aircraft Example"]
}, Open  ]],

Cell[BoxData[
    \(\(Feq = {
        \(-\(1\/2\)\)\ 
          \((20. \ \((\(-2.045\)\ \((\(-0.05\) + alpha)\)\^3 + alpha)\)\ kappa
                \ Cos[alpha] - 
              2. \ \((\(-0.05\) + alpha + dele - 
                    3\ \((\(-0.05\) + alpha + dele)\)\^3)\)\ \((1 - kappa)\)\ 
                Cos[alpha + dele])\), 
        \(-\ Cos[alpha]\) - 
          1\/2\ V\^2\ 
            \((\(-20. \)\ 
                  \((\(-2.045\)\ \((\(-0.05\) + alpha)\)\^3 + alpha)\)\ 
                  Cos[alpha] - 
                2. \ \((
                    \(-0.05\) + alpha + dele - 
                      3\ \((\(-0.05\) + alpha + dele)\)\^3)\)\ 
                  Cos[alpha + dele] - 
                0.05\ \((
                    1 + 400. \ 
                        \((\(-2.045\)\ \((\(-0.05\) + alpha)\)\^3 + alpha)
                            \)\^2)\)\ Sin[alpha])\)}; \)\)], "Input",
  CellLabel->"In[46]:=",
  CellTags->"Aircraft Example"],

Cell[CellGroupData[{

Cell[BoxData[
    \({TT, ParamMap} = 
      Timing[EquilibriumSurface[
          Feq, {alpha, dele}, {V, kappa}, { .2,  .1}, {0.67276, 0.093009}, 
          kap, 3]]\)], "Input",
  CellLabel->"In[50]:=",
  CellTags->"Aircraft Example"],

Cell[BoxData[
    \("2 vector fields computed."\)], "Print",
  CellTags->"Aircraft Example"],

Cell[BoxData[
    \("2 flow functions computed."\)], "Print",
  CellTags->"Aircraft Example"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(61.4000000000000056`\ Second\), ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox["0.2`",
                      StyleBoxAutoDelete->True,
                      PrintPrecision->1], "\[InvisibleSpace]"}], "-", 
                  \(0.620142034924028706`\ kap1\), "+", 
                  \(1.30533933736090634`\ kap1\^2\), "-", 
                  \(0.332157214685708801`\ kap1\^3\), "-", 
                  \(0.221600121037904296`\ kap2\), "-", 
                  \(0.080231278314890293`\ kap1\ kap2\), "-", 
                  \(12.6326798625126368`\ kap1\^2\ kap2\), "-", 
                  \(0.195348730998797392`\ kap2\^2\), "+", 
                  \(33.2172463207464474`\ kap1\ kap2\^2\), "+", 
                  \(13.4676878720679393`\ kap2\^3\)}], ",", 
                RowBox[{
                  RowBox[{
                    StyleBox["0.1`",
                      StyleBoxAutoDelete->True,
                      PrintPrecision->1], "\[InvisibleSpace]"}], "-", 
                  \(0.812615246837990845`\ kap1\), "+", 
                  \(0.0839244031629084119`\ kap1\^2\), "+", 
                  \(0.294080213242342161`\ kap1\^3\), "+", 
                  \(6.13684847557974588`\ kap2\), "-", 
                  \(1.26758966834132036`\ kap1\ kap2\), "-", 
                  \(6.66265756896721672`\ kap1\^2\ kap2\), "+", 
                  \(4.78640153140761182`\ kap2\^2\), "+", 
                  \(50.3162106599976333`\ kap1\ kap2\^2\), "-", 
                  \(126.662222943054203`\ kap2\^3\)}], ",", 
                RowBox[{
                  RowBox[{
                    StyleBox["0.672760000000000069`",
                      StyleBoxAutoDelete->True,
                      PrintPrecision->5], "\[InvisibleSpace]"}], "+", 
                  \(1.`\ kap1\), "+", \(1.24138904313544462`\ kap1\^2\), "-", 
                  \(2.91329522204495638`\ kap1\^3\), "-", 
                  \(5.82430003103808324`\ kap1\ kap2\), "+", 
                  \(14.3825627318111415`\ kap1\^2\ kap2\), "+", 
                  \(12.9976491868076827`\ kap2\^2\), "-", 
                  \(64.228890614429126`\ kap1\ kap2\^2\), "+", 
                  \(82.9756776519079153`\ kap2\^3\)}], ",", 
                RowBox[{
                  RowBox[{
                    StyleBox["0.0930090000000000038`",
                      StyleBoxAutoDelete->True,
                      PrintPrecision->5], "\[InvisibleSpace]"}], "-", 
                  \(2.17287972003822327`\ kap1\^2\), "+", 
                  \(0.470659057834906846`\ kap1\^3\), "+", \(1.`\ kap2\), 
                  "+", \(20.1098765815591873`\ kap1\ kap2\), "-", 
                  \(5.24109833420727877`\ kap1\^2\ kap2\), "-", 
                  \(35.4838168557615896`\ kap2\^2\), "+", 
                  \(73.8984804820898233`\ kap1\ kap2\^2\), "-", 
                  \(248.743976437006919`\ kap2\^3\)}]}], "}"}], ",", 
            \({kap1, kap2}\)}], "}"}]}], "}"}]], "Output",
  CellLabel->"Out[50]=",
  CellTags->"Aircraft Example"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot3D[
      \(ParamMap[\([1]\)]\)[\([{3, 4, 2}]\)], {kap1, \(- .05\),  .1}, {kap2, 
        \(- .05\),  .08}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
      PlotPoints -> {25, 25}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
      BoxRatios -> {1, 1,  .5}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
      ViewPoint -> {2, \(- .2\), 1.5}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
      Boxed -> True]\)], "Input",
  CellLabel->"In[51]:=",
  CellTags->"Aircraft Example"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .84128 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0798165 1.07982 -0.0707824 1.07982 [
[.81292 .79584 0 -4.28754 ]
[.81292 .79584 24 4.71246 ]
[.8558 .71193 0 -4.27158 ]
[.8558 .71193 18 4.72842 ]
[.90547 .61475 0 -4.25301 ]
[.90547 .61475 24 4.74699 ]
[.96366 .5009 0 -4.23117 ]
[.96366 .5009 18 4.76883 ]
[.06632 -0.01305 -12.9064 -9 ]
[.06632 -0.01305 11.0936 0 ]
[.26874 .00252 -11.6608 -9 ]
[.26874 .00252 12.3392 0 ]
[.46795 .01799 -10.4152 -9 ]
[.46795 .01799 13.5848 0 ]
[.66398 .03334 -2.29239 -9 ]
[.66398 .03334 3.70761 0 ]
[.85686 .04857 -5.94293 -9 ]
[.85686 .04857 12.0571 0 ]
[.04494 .01865 -24 -4.84566 ]
[.04494 .01865 0 4.15434 ]
[.03187 .09007 -6 -4.83265 ]
[.03187 .09007 0 4.16735 ]
[.01792 .16629 -18 -4.81878 ]
[.01792 .16629 0 4.18122 ]
[.003 .24781 -18 -4.80395 ]
[.003 .24781 0 4.19605 ]
[-0.013 .33522 -18 -4.78808 ]
[-0.013 .33522 0 4.21192 ]
[ 0 0 0 0 ]
[ 1 .84128 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.77589 .84128 m
1 .40259 L
s
.79943 .7952 m
.79269 .79488 L
s
[(0.65)] .81292 .79584 -1 -0.04721 Mshowa
.84232 .71125 m
.83558 .7109 L
s
[(0.7)] .8558 .71193 -1 -0.05076 Mshowa
.89199 .61401 m
.88525 .61364 L
s
[(0.75)] .90547 .61475 -1 -0.05489 Mshowa
.95019 .50009 m
.94345 .49969 L
s
[(0.8)] .96366 .5009 -1 -0.05974 Mshowa
.125 Mabswid
.80754 .77934 m
.80349 .77915 L
s
.81587 .76303 m
.81182 .76284 L
s
.82443 .74626 m
.82039 .74606 L
s
.83325 .72901 m
.8292 .7288 L
s
.85167 .69296 m
.84762 .69275 L
s
.86129 .67411 m
.85725 .6739 L
s
.87121 .65469 m
.86717 .65448 L
s
.88144 .63467 m
.8774 .63445 L
s
.90288 .59269 m
.89884 .59247 L
s
.91413 .57068 m
.91009 .57045 L
s
.92575 .54793 m
.92171 .5477 L
s
.93776 .52442 m
.93372 .52418 L
s
.79155 .81064 m
.7875 .81045 L
s
.78387 .82566 m
.77983 .82548 L
s
.7764 .84029 m
.77235 .84011 L
s
.96305 .47492 m
.95901 .47468 L
s
.97636 .44885 m
.97232 .4486 L
s
.99016 .42184 m
.98612 .42159 L
s
.25 Mabswid
.06201 0 m
.92976 .06735 L
s
.06733 .00041 m
.06784 .00714 L
s
[(-0.3)] .06632 -0.01305 .07554 1 Mshowa
.26836 .01602 m
.26817 .02276 L
s
[(-0.2)] .26874 .00252 -0.02827 1 Mshowa
.46619 .03137 m
.4653 .03806 L
s
[(-0.1)] .46795 .01799 -0.13207 1 Mshowa
.66088 .04648 m
.65933 .05305 L
s
[(0)] .66398 .03334 -0.23587 1 Mshowa
.85252 .06135 m
.85035 .06774 L
s
[(0.1)] .85686 .04857 -0.33967 1 Mshowa
.125 Mabswid
.1078 .00355 m
.10802 .0076 L
s
.14813 .00668 m
.14827 .01073 L
s
.18834 .0098 m
.18839 .01385 L
s
.22842 .01292 m
.22839 .01696 L
s
.30818 .01911 m
.30798 .02315 L
s
.34787 .02219 m
.34759 .02623 L
s
.38744 .02526 m
.38707 .02929 L
s
.42687 .02832 m
.42643 .03234 L
s
.50537 .03441 m
.50476 .03841 L
s
.54444 .03744 m
.54374 .04143 L
s
.58337 .04046 m
.5826 .04444 L
s
.62219 .04348 m
.62134 .04744 L
s
.69945 .04947 m
.69844 .0534 L
s
.7379 .05246 m
.73682 .05636 L
s
.77622 .05543 m
.77507 .05931 L
s
.81443 .0584 m
.8132 .06226 L
s
.89048 .0643 m
.88911 .06811 L
s
.92833 .06724 m
.92689 .07102 L
s
.25 Mabswid
.06201 0 m
0 .33867 L
s
.0584 .01969 m
.06513 .0202 L
s
[(-0.2)] .04494 .01865 1 .07681 Mshowa
.04533 .09107 m
.05206 .09156 L
s
[(0)] .03187 .09007 1 .07392 Mshowa
.03139 .16724 m
.03812 .16772 L
s
[(0.2)] .01792 .16629 1 .07084 Mshowa
.01647 .24872 m
.0232 .24918 L
s
[(0.4)] .003 .24781 1 .06755 Mshowa
.00047 .33608 m
.00721 .33651 L
s
[(0.6)] -0.013 .33522 1 .06402 Mshowa
.125 Mabswid
.05521 .03711 m
.05925 .03741 L
s
.05197 .05481 m
.05601 .05511 L
s
.04868 .07279 m
.05272 .07309 L
s
.04193 .10964 m
.04597 .10994 L
s
.03848 .12853 m
.04251 .12882 L
s
.03496 .14772 m
.039 .14801 L
s
.02775 .1871 m
.03179 .18738 L
s
.02405 .20729 m
.02809 .20757 L
s
.02029 .22783 m
.02433 .2281 L
s
.01258 .26999 m
.01662 .27026 L
s
.00861 .29163 m
.01265 .29189 L
s
.00458 .31366 m
.00862 .31392 L
s
.06154 .00254 m
.06558 .00285 L
s
.25 Mabswid
.10218 .51324 m
.06279 .809 L
s
.06279 .809 m
.77589 .84128 L
s
.77589 .84128 m
.74539 .55002 L
s
.74539 .55002 m
.10218 .51324 L
s
.06201 0 m
.92976 .06735 L
s
.92976 .06735 m
1 .40259 L
s
1 .40259 m
0 .33867 L
s
0 .33867 m
.06201 0 L
s
.10218 .51324 m
.06279 .809 L
s
.06279 .809 m
0 .33867 L
s
0 .33867 m
.06201 0 L
s
.06201 0 m
.10218 .51324 L
s
.74539 .55002 m
.92976 .06735 L
s
.92976 .06735 m
1 .40259 L
s
1 .40259 m
.77589 .84128 L
s
.77589 .84128 m
.74539 .55002 L
s
0 0 m
1 0 L
1 .84128 L
0 .84128 L
closepath
clip
newpath
.5 Mabswid
.64342 .58843 m .64309 .60072 L .63013 .5861 L p .33 .477 .855 r
F P
0 g
s
.63013 .5861 m .62961 .57351 L .64342 .58843 L p .33 .477 .855 r
F P
0 g
s
.62961 .57351 m .63013 .5861 L .6162 .57092 L p .339 .497 .869 r
F P
0 g
s
.65598 .60266 m .6548 .61463 L .64309 .60072 L p .313 .447 .836 r
F P
0 g
s
.64309 .60072 m .64342 .58843 L .65598 .60266 L p .313 .447 .836 r
F P
0 g
s
.6162 .57092 m .61485 .55807 L .62961 .57351 L p .339 .497 .869 r
F P
0 g
s
.61485 .55807 m .6162 .57092 L .60159 .55535 L p .343 .51 .879 r
F P
0 g
s
.66703 .61604 m .66496 .62767 L .6548 .61463 L p .286 .405 .808 r
F P
0 g
s
.6548 .61463 m .65598 .60266 L .66703 .61604 L p .286 .405 .808 r
F P
0 g
s
.60159 .55535 m .59942 .54227 L .61485 .55807 L p .343 .51 .879 r
F P
0 g
s
.59942 .54227 m .60159 .55535 L .58657 .53955 L p .34 .519 .886 r
F P
0 g
s
.67626 .62843 m .67331 .63968 L .66496 .62767 L p .243 .342 .766 r
F P
0 g
s
.66496 .62767 m .66703 .61604 L .67626 .62843 L p .243 .342 .766 r
F P
0 g
s
.58657 .53955 m .58361 .52627 L .59942 .54227 L p .34 .519 .886 r
F P
0 g
s
.68339 .63966 m .67952 .65052 L .67331 .63968 L p .174 .244 .696 r
F P
0 g
s
.67331 .63968 m .67626 .62843 L .68339 .63966 L p .174 .244 .696 r
F P
0 g
s
.657 .59033 m .65598 .60266 L .64342 .58843 L p .328 .465 .846 r
F P
0 g
s
.64342 .58843 m .64355 .57578 L .657 .59033 L p .328 .465 .846 r
F P
0 g
s
.64355 .57578 m .64342 .58843 L .62961 .57351 L p .343 .491 .863 r
F P
0 g
s
.62961 .57351 m .62889 .56057 L .64355 .57578 L p .343 .491 .863 r
F P
0 g
s
.62889 .56057 m .62961 .57351 L .61485 .55807 L p .351 .51 .875 r
F P
0 g
s
.66893 .60407 m .66703 .61604 L .65598 .60266 L p .303 .426 .821 r
F P
0 g
s
.65598 .60266 m .657 .59033 L .66893 .60407 L p .303 .426 .821 r
F P
0 g
s
.61485 .55807 m .61328 .54487 L .62889 .56057 L p .351 .51 .875 r
F P
0 g
s
.61328 .54487 m .61485 .55807 L .59942 .54227 L p .354 .523 .885 r
F P
0 g
s
.68808 .64957 m .68328 .66001 L .67952 .65052 L p .059 .085 .572 r
F P
0 g
s
.67952 .65052 m .68339 .63966 L .68808 .64957 L p .059 .085 .572 r
F P
0 g
s
.59942 .54227 m .59702 .52883 L .61328 .54487 L p .354 .523 .885 r
F P
0 g
s
.59702 .52883 m .59942 .54227 L .58361 .52627 L p .352 .53 .892 r
F P
0 g
s
.67907 .61683 m .67626 .62843 L .66703 .61604 L p .265 .37 .784 r
F P
0 g
s
.66703 .61604 m .66893 .60407 L .67907 .61683 L p .265 .37 .784 r
F P
0 g
s
.58361 .52627 m .58041 .51264 L .59702 .52883 L p .352 .53 .892 r
F P
0 g
s
.68711 .62845 m .68339 .63966 L .67626 .62843 L p .205 .285 .725 r
F P
0 g
s
.67626 .62843 m .67907 .61683 L .68711 .62845 L p .205 .285 .725 r
F P
0 g
s
.69002 .65798 m .68426 .66799 L .68328 .66001 L p 0 0 .339 r
F P
0 g
s
.68328 .66001 m .68808 .64957 L .69002 .65798 L p 0 0 .339 r
F P
0 g
s
.65783 .57765 m .657 .59033 L .64355 .57578 L p .341 .48 .854 r
F P
0 g
s
.64355 .57578 m .6435 .56278 L .65783 .57765 L p .341 .48 .854 r
F P
0 g
s
.6435 .56278 m .64355 .57578 L .62889 .56057 L p .355 .505 .87 r
F P
0 g
s
.62889 .56057 m .62796 .54727 L .6435 .56278 L p .355 .505 .87 r
F P
0 g
s
.62796 .54727 m .62889 .56057 L .61328 .54487 L p .362 .522 .881 r
F P
0 g
s
.67067 .59173 m .66893 .60407 L .657 .59033 L p .319 .446 .832 r
F P
0 g
s
.657 .59033 m .65783 .57765 L .67067 .59173 L p .319 .446 .832 r
F P
0 g
s
.69275 .63877 m .68808 .64957 L .68339 .63966 L p .106 .147 .621 r
F P
0 g
s
.68339 .63966 m .68711 .62845 L .69275 .63877 L p .106 .147 .621 r
F P
0 g
s
.61328 .54487 m .61149 .53131 L .62796 .54727 L p .362 .522 .881 r
F P
0 g
s
.61149 .53131 m .61328 .54487 L .59702 .52883 L p .365 .534 .89 r
F P
0 g
s
.68173 .60487 m .67907 .61683 L .66893 .60407 L p .286 .396 .8 r
F P
0 g
s
.66893 .60407 m .67067 .59173 L .68173 .60487 L p .286 .396 .8 r
F P
0 g
s
.59702 .52883 m .59439 .51504 L .61149 .53131 L p .365 .534 .89 r
F P
0 g
s
.59439 .51504 m .59702 .52883 L .58041 .51264 L p .363 .542 .896 r
F P
0 g
s
.6907 .61688 m .68711 .62845 L .67907 .61683 L p .233 .321 .749 r
F P
0 g
s
.67907 .61683 m .68173 .60487 L .6907 .61688 L p .233 .321 .749 r
F P
0 g
s
.58041 .51264 m .57695 .49866 L .59439 .51504 L p .363 .542 .896 r
F P
0 g
s
.69565 .64762 m .69002 .65798 L .68808 .64957 L p 0 0 .426 r
F P
0 g
s
.68808 .64957 m .69275 .63877 L .69565 .64762 L p 0 0 .426 r
F P
0 g
s
.68884 .66471 m .68209 .67426 L .68426 .66799 L p 0 0 0 r
F P
0 g
s
.68426 .66799 m .69002 .65798 L .68884 .66471 L p 0 0 0 r
F P
0 g
s
.69729 .62762 m .69275 .63877 L .68711 .62845 L p .147 .201 .662 r
F P
0 g
s
.68711 .62845 m .6907 .61688 L .69729 .62762 L p .147 .201 .662 r
F P
0 g
s
.65848 .5646 m .65783 .57765 L .6435 .56278 L p .353 .495 .862 r
F P
0 g
s
.6435 .56278 m .64324 .54941 L .65848 .5646 L p .353 .495 .862 r
F P
0 g
s
.64324 .54941 m .6435 .56278 L .62796 .54727 L p .366 .517 .876 r
F P
0 g
s
.67224 .57904 m .67067 .59173 L .65783 .57765 L p .334 .464 .842 r
F P
0 g
s
.65783 .57765 m .65848 .5646 L .67224 .57904 L p .334 .464 .842 r
F P
0 g
s
.62796 .54727 m .62681 .53361 L .64324 .54941 L p .366 .517 .876 r
F P
0 g
s
.62681 .53361 m .62796 .54727 L .61149 .53131 L p .373 .533 .886 r
F P
0 g
s
.68423 .59254 m .68173 .60487 L .67067 .59173 L p .304 .419 .814 r
F P
0 g
s
.67067 .59173 m .67224 .57904 L .68423 .59254 L p .304 .419 .814 r
F P
0 g
s
.61149 .53131 m .60946 .51738 L .62681 .53361 L p .373 .533 .886 r
F P
0 g
s
.60946 .51738 m .61149 .53131 L .59439 .51504 L p .375 .545 .894 r
F P
0 g
s
.59439 .51504 m .5915 .50089 L .60946 .51738 L p .375 .545 .894 r
F P
0 g
s
.5915 .50089 m .59439 .51504 L .57695 .49866 L p .374 .552 .901 r
F P
0 g
s
.69415 .60496 m .6907 .61688 L .68173 .60487 L p .257 .352 .77 r
F P
0 g
s
.68173 .60487 m .68423 .59254 L .69415 .60496 L p .257 .352 .77 r
F P
0 g
s
.69546 .65481 m .68884 .66471 L .69002 .65798 L p 0 0 .067 r
F P
0 g
s
.69002 .65798 m .69565 .64762 L .69546 .65481 L p 0 0 .067 r
F P
0 g
s
.70117 .63691 m .69565 .64762 L .69275 .63877 L p .001 0 .5 r
F P
0 g
s
.69275 .63877 m .69729 .62762 L .70117 .63691 L p .001 0 .5 r
F P
0 g
s
.57695 .49866 m .57322 .48433 L .5915 .50089 L p .374 .552 .901 r
F P
0 g
s
.68413 .66956 m .67636 .67862 L .68209 .67426 L p .642 .873 .512 r
F P
0 g
s
.68209 .67426 m .68884 .66471 L .68413 .66956 L p .642 .873 .512 r
F P
0 g
s
.7017 .61611 m .69729 .62762 L .6907 .61688 L p .183 .248 .697 r
F P
0 g
s
.6907 .61688 m .69415 .60496 L .7017 .61611 L p .183 .248 .697 r
F P
0 g
s
.65895 .55118 m .65848 .5646 L .64324 .54941 L p .365 .508 .869 r
F P
0 g
s
.64324 .54941 m .64278 .53566 L .65895 .55118 L p .365 .508 .869 r
F P
0 g
s
.64278 .53566 m .64324 .54941 L .62681 .53361 L p .376 .529 .881 r
F P
0 g
s
.67364 .56597 m .67224 .57904 L .65848 .5646 L p .347 .48 .851 r
F P
0 g
s
.65848 .5646 m .65895 .55118 L .67364 .56597 L p .347 .48 .851 r
F P
0 g
s
.62681 .53361 m .62544 .51957 L .64278 .53566 L p .376 .529 .881 r
F P
0 g
s
.62544 .51957 m .62681 .53361 L .60946 .51738 L p .383 .544 .891 r
F P
0 g
s
.68657 .57985 m .68423 .59254 L .67224 .57904 L p .321 .44 .826 r
F P
0 g
s
.67224 .57904 m .67364 .56597 L .68657 .57985 L p .321 .44 .826 r
F P
0 g
s
.60946 .51738 m .6072 .50309 L .62544 .51957 L p .383 .544 .891 r
F P
0 g
s
.6072 .50309 m .60946 .51738 L .5915 .50089 L p .385 .555 .899 r
F P
0 g
s
.70198 .64456 m .69546 .65481 L .69565 .64762 L p 0 0 .19 r
F P
0 g
s
.69565 .64762 m .70117 .63691 L .70198 .64456 L p 0 0 .19 r
F P
0 g
s
.69745 .59266 m .69415 .60496 L .68423 .59254 L p .28 .381 .788 r
F P
0 g
s
.68423 .59254 m .68657 .57985 L .69745 .59266 L p .28 .381 .788 r
F P
0 g
s
.70656 .62584 m .70117 .63691 L .69729 .62762 L p .057 .075 .562 r
F P
0 g
s
.69729 .62762 m .7017 .61611 L .70656 .62584 L p .057 .075 .562 r
F P
0 g
s
.5915 .50089 m .58836 .48638 L .6072 .50309 L p .385 .555 .899 r
F P
0 g
s
.58836 .48638 m .5915 .50089 L .57322 .48433 L p .384 .562 .905 r
F P
0 g
s
.69179 .66015 m .68413 .66956 L .68884 .66471 L p .593 .807 .403 r
F P
0 g
s
.68884 .66471 m .69546 .65481 L .69179 .66015 L p .593 .807 .403 r
F P
0 g
s
.57322 .48433 m .56922 .46964 L .58836 .48638 L p .384 .562 .905 r
F P
0 g
s
.70598 .60424 m .7017 .61611 L .69415 .60496 L p .215 .29 .726 r
F P
0 g
s
.69415 .60496 m .69745 .59266 L .70598 .60424 L p .215 .29 .726 r
F P
0 g
s
.67486 .55252 m .67364 .56597 L .65895 .55118 L p .36 .495 .859 r
F P
0 g
s
.65895 .55118 m .65921 .53738 L .67486 .55252 L p .36 .495 .859 r
F P
0 g
s
.65921 .53738 m .65895 .55118 L .64278 .53566 L p .376 .521 .875 r
F P
0 g
s
.64278 .53566 m .64211 .52154 L .65921 .53738 L p .376 .521 .875 r
F P
0 g
s
.64211 .52154 m .64278 .53566 L .62544 .51957 L p .386 .54 .886 r
F P
0 g
s
.67545 .67231 m .66661 .68086 L .67636 .67862 L p .724 .984 .783 r
F P
0 g
s
.67636 .67862 m .68413 .66956 L .67545 .67231 L p .724 .984 .783 r
F P
0 g
s
.70838 .63396 m .70198 .64456 L .70117 .63691 L p 0 0 .3 r
F P
0 g
s
.70117 .63691 m .70656 .62584 L .70838 .63396 L p 0 0 .3 r
F P
0 g
s
.68875 .56678 m .68657 .57985 L .67364 .56597 L p .336 .458 .837 r
F P
0 g
s
.67364 .56597 m .67486 .55252 L .68875 .56678 L p .336 .458 .837 r
F P
0 g
s
.62544 .51957 m .62384 .50516 L .64211 .52154 L p .386 .54 .886 r
F P
0 g
s
.62384 .50516 m .62544 .51957 L .6072 .50309 L p .392 .554 .895 r
F P
0 g
s
.69934 .65038 m .69179 .66015 L .69546 .65481 L p 0 0 0 r
F P
0 g
s
.69546 .65481 m .70198 .64456 L .69934 .65038 L p 0 0 0 r
F P
0 g
s
.71183 .61441 m .70656 .62584 L .7017 .61611 L p .106 .14 .613 r
F P
0 g
s
.7017 .61611 m .70598 .60424 L .71183 .61441 L p .106 .14 .613 r
F P
0 g
s
.6072 .50309 m .60469 .48842 L .62384 .50516 L p .392 .554 .895 r
F P
0 g
s
.60469 .48842 m .6072 .50309 L .58836 .48638 L p .394 .564 .902 r
F P
0 g
s
.70061 .57999 m .69745 .59266 L .68657 .57985 L p .299 .406 .804 r
F P
0 g
s
.68657 .57985 m .68875 .56678 L .70061 .57999 L p .299 .406 .804 r
F P
0 g
s
.58836 .48638 m .58495 .47149 L .60469 .48842 L p .394 .564 .902 r
F P
0 g
s
.58495 .47149 m .58836 .48638 L .56922 .46964 L p .393 .571 .908 r
F P
0 g
s
.71012 .59199 m .70598 .60424 L .69745 .59266 L p .243 .326 .75 r
F P
0 g
s
.69745 .59266 m .70061 .57999 L .71012 .59199 L p .243 .326 .75 r
F P
0 g
s
.68419 .66341 m .67545 .67231 L .68413 .66956 L p .715 .971 .732 r
F P
0 g
s
.68413 .66956 m .69179 .66015 L .68419 .66341 L p .715 .971 .732 r
F P
0 g
s
.56922 .46964 m .56493 .45458 L .58495 .47149 L p .393 .571 .908 r
F P
0 g
s
.71466 .62299 m .70838 .63396 L .70656 .62584 L p 0 0 .395 r
F P
0 g
s
.70656 .62584 m .71183 .61441 L .71466 .62299 L p 0 0 .395 r
F P
0 g
s
.70678 .64026 m .69934 .65038 L .70198 .64456 L p 0 0 0 r
F P
0 g
s
.70198 .64456 m .70838 .63396 L .70678 .64026 L p 0 0 0 r
F P
0 g
s
.67589 .53869 m .67486 .55252 L .65921 .53738 L p .371 .508 .866 r
F P
0 g
s
.65921 .53738 m .65928 .5232 L .67589 .53869 L p .371 .508 .866 r
F P
0 g
s
.65928 .5232 m .65921 .53738 L .64211 .52154 L p .386 .532 .88 r
F P
0 g
s
.64211 .52154 m .64122 .50703 L .65928 .5232 L p .386 .532 .88 r
F P
0 g
s
.64122 .50703 m .64211 .52154 L .62384 .50516 L p .395 .55 .891 r
F P
0 g
s
.69076 .55332 m .68875 .56678 L .67486 .55252 L p .349 .476 .846 r
F P
0 g
s
.67486 .55252 m .67589 .53869 L .69076 .55332 L p .349 .476 .846 r
F P
0 g
s
.71697 .60261 m .71183 .61441 L .70598 .60424 L p .149 .197 .656 r
F P
0 g
s
.70598 .60424 m .71012 .59199 L .71697 .60261 L p .149 .197 .656 r
F P
0 g
s
.62384 .50516 m .622 .49036 L .64122 .50703 L p .395 .55 .891 r
F P
0 g
s
.622 .49036 m .62384 .50516 L .60469 .48842 L p .401 .563 .899 r
F P
0 g
s
.7036 .56694 m .70061 .57999 L .68875 .56678 L p .317 .428 .817 r
F P
0 g
s
.68875 .56678 m .69076 .55332 L .7036 .56694 L p .317 .428 .817 r
F P
0 g
s
.69281 .65416 m .68419 .66341 L .69179 .66015 L p .697 .948 .667 r
F P
0 g
s
.69179 .66015 m .69934 .65038 L .69281 .65416 L p .697 .948 .667 r
F P
0 g
s
.60469 .48842 m .60192 .47336 L .622 .49036 L p .401 .563 .899 r
F P
0 g
s
.60192 .47336 m .60469 .48842 L .58495 .47149 L p .403 .573 .906 r
F P
0 g
s
.6623 .6727 m .65232 .6807 L .66661 .68086 L p .726 .984 .899 r
F P
0 g
s
.66661 .68086 m .67545 .67231 L .6623 .6727 L p .726 .984 .899 r
F P
0 g
s
.71412 .57937 m .71012 .59199 L .70061 .57999 L p .267 .358 .771 r
F P
0 g
s
.70061 .57999 m .7036 .56694 L .71412 .57937 L p .267 .358 .771 r
F P
0 g
s
.58495 .47149 m .58127 .45623 L .60192 .47336 L p .403 .573 .906 r
F P
0 g
s
.58127 .45623 m .58495 .47149 L .56493 .45458 L p .402 .579 .911 r
F P
0 g
s
.72083 .61165 m .71466 .62299 L .71183 .61441 L p 0 0 .476 r
F P
0 g
s
.71183 .61441 m .71697 .60261 L .72083 .61165 L p 0 0 .476 r
F P
0 g
s
.71411 .62978 m .70678 .64026 L .70838 .63396 L p 0 0 0 r
F P
0 g
s
.70838 .63396 m .71466 .62299 L .71411 .62978 L p 0 0 0 r
F P
0 g
s
.56493 .45458 m .56036 .43914 L .58127 .45623 L p .402 .579 .911 r
F P
0 g
s
.72199 .59043 m .71697 .60261 L .71012 .59199 L p .186 .246 .692 r
F P
0 g
s
.71012 .59199 m .71412 .57937 L .72199 .59043 L p .186 .246 .692 r
F P
0 g
s
.70133 .64455 m .69281 .65416 L .69934 .65038 L p .67 .911 .585 r
F P
0 g
s
.69934 .65038 m .70678 .64026 L .70133 .64455 L p .67 .911 .585 r
F P
0 g
s
.67217 .66434 m .6623 .6727 L .67545 .67231 L p .729 .989 .879 r
F P
0 g
s
.67545 .67231 m .68419 .66341 L .67217 .66434 L p .729 .989 .879 r
F P
0 g
s
.67673 .52447 m .67589 .53869 L .65928 .5232 L p .382 .521 .872 r
F P
0 g
s
.65928 .5232 m .65913 .50863 L .67673 .52447 L p .382 .521 .872 r
F P
0 g
s
.65913 .50863 m .65928 .5232 L .64122 .50703 L p .395 .543 .885 r
F P
0 g
s
.6926 .53948 m .69076 .55332 L .67589 .53869 L p .362 .491 .855 r
F P
0 g
s
.67589 .53869 m .67673 .52447 L .6926 .53948 L p .362 .491 .855 r
F P
0 g
s
.64122 .50703 m .6401 .49214 L .65913 .50863 L p .395 .543 .885 r
F P
0 g
s
.6401 .49214 m .64122 .50703 L .622 .49036 L p .404 .559 .895 r
F P
0 g
s
.622 .49036 m .61992 .47518 L .6401 .49214 L p .404 .559 .895 r
F P
0 g
s
.61992 .47518 m .622 .49036 L .60192 .47336 L p .409 .572 .903 r
F P
0 g
s
.70645 .55351 m .7036 .56694 L .69076 .55332 L p .333 .449 .829 r
F P
0 g
s
.69076 .55332 m .6926 .53948 L .70645 .55351 L p .333 .449 .829 r
F P
0 g
s
.60192 .47336 m .59888 .45793 L .61992 .47518 L p .409 .572 .903 r
F P
0 g
s
.59888 .45793 m .60192 .47336 L .58127 .45623 L p .411 .581 .909 r
F P
0 g
s
.71798 .56636 m .71412 .57937 L .7036 .56694 L p .289 .386 .789 r
F P
0 g
s
.7036 .56694 m .70645 .55351 L .71798 .56636 L p .289 .386 .789 r
F P
0 g
s
.72133 .61893 m .71411 .62978 L .71466 .62299 L p 0 0 .126 r
F P
0 g
s
.71466 .62299 m .72083 .61165 L .72133 .61893 L p 0 0 .126 r
F P
0 g
s
.72689 .59994 m .72083 .61165 L .71697 .60261 L p .047 .055 .543 r
F P
0 g
s
.71697 .60261 m .72199 .59043 L .72689 .59994 L p .047 .055 .543 r
F P
0 g
s
.68192 .65563 m .67217 .66434 L .68419 .66341 L p .731 .991 .853 r
F P
0 g
s
.68419 .66341 m .69281 .65416 L .68192 .65563 L p .731 .991 .853 r
F P
0 g
s
.58127 .45623 m .5773 .44058 L .59888 .45793 L p .411 .581 .909 r
F P
0 g
s
.5773 .44058 m .58127 .45623 L .56036 .43914 L p .411 .587 .914 r
F P
0 g
s
.70975 .63458 m .70133 .64455 L .70678 .64026 L p .629 .858 .486 r
F P
0 g
s
.70678 .64026 m .71411 .62978 L .70975 .63458 L p .629 .858 .486 r
F P
0 g
s
.72688 .57787 m .72199 .59043 L .71412 .57937 L p .219 .289 .722 r
F P
0 g
s
.71412 .57937 m .71798 .56636 L .72688 .57787 L p .219 .289 .722 r
F P
0 g
s
.56036 .43914 m .55548 .42334 L .5773 .44058 L p .411 .587 .914 r
F P
0 g
s
.67738 .50985 m .67673 .52447 L .65913 .50863 L p .392 .533 .878 r
F P
0 g
s
.65913 .50863 m .65878 .49366 L .67738 .50985 L p .392 .533 .878 r
F P
0 g
s
.65878 .49366 m .65913 .50863 L .6401 .49214 L p .404 .553 .89 r
F P
0 g
s
.64407 .67045 m .63288 .67786 L .65232 .6807 L p .708 .959 .947 r
F P
0 g
s
.65232 .6807 m .6623 .6727 L .64407 .67045 L p .708 .959 .947 r
F P
0 g
s
.69426 .52525 m .6926 .53948 L .67673 .52447 L p .374 .505 .862 r
F P
0 g
s
.67673 .52447 m .67738 .50985 L .69426 .52525 L p .374 .505 .862 r
F P
0 g
s
.6401 .49214 m .63875 .47684 L .65878 .49366 L p .404 .553 .89 r
F P
0 g
s
.63875 .47684 m .6401 .49214 L .61992 .47518 L p .412 .568 .899 r
F P
0 g
s
.70913 .53968 m .70645 .55351 L .6926 .53948 L p .348 .467 .839 r
F P
0 g
s
.6926 .53948 m .69426 .52525 L .70913 .53968 L p .348 .467 .839 r
F P
0 g
s
.69158 .64656 m .68192 .65563 L .69281 .65416 L p .729 .989 .821 r
F P
0 g
s
.69281 .65416 m .70133 .64455 L .69158 .64656 L p .729 .989 .821 r
F P
0 g
s
.72845 .60771 m .72133 .61893 L .72083 .61165 L p 0 0 .246 r
F P
0 g
s
.72083 .61165 m .72689 .59994 L .72845 .60771 L p 0 0 .246 r
F P
0 g
s
.61992 .47518 m .61758 .45959 L .63875 .47684 L p .412 .568 .899 r
F P
0 g
s
.61758 .45959 m .61992 .47518 L .59888 .45793 L p .417 .58 .906 r
F P
0 g
s
.73282 .58785 m .72689 .59994 L .72199 .59043 L p .1 .125 .599 r
F P
0 g
s
.72199 .59043 m .72688 .57787 L .73282 .58785 L p .1 .125 .599 r
F P
0 g
s
.72169 .55296 m .71798 .56636 L .70645 .55351 L p .309 .412 .805 r
F P
0 g
s
.70645 .55351 m .70913 .53968 L .72169 .55296 L p .309 .412 .805 r
F P
0 g
s
.71411 .62978 m .72133 .61893 L .71806 .62424 L p 0 0 0 r
F P
0 g
s
.71806 .62424 m .70975 .63458 L .71411 .62978 L p 0 0 0 r
F P
0 g
s
.59888 .45793 m .59558 .4421 L .61758 .45959 L p .417 .58 .906 r
F P
0 g
s
.59558 .4421 m .59888 .45793 L .5773 .44058 L p .419 .589 .912 r
F P
0 g
s
.65515 .66267 m .64407 .67045 L .6623 .6727 L p .713 .965 .939 r
F P
0 g
s
.6623 .6727 m .67217 .66434 L .65515 .66267 L p .713 .965 .939 r
F P
0 g
s
.5773 .44058 m .57304 .42455 L .59558 .4421 L p .419 .589 .912 r
F P
0 g
s
.57304 .42455 m .5773 .44058 L .55548 .42334 L p .419 .595 .917 r
F P
0 g
s
.73164 .56493 m .72688 .57787 L .71798 .56636 L p .248 .326 .748 r
F P
0 g
s
.71798 .56636 m .72169 .55296 L .73164 .56493 L p .248 .326 .748 r
F P
0 g
s
.70112 .63713 m .69158 .64656 L .70133 .64455 L p .724 .983 .779 r
F P
0 g
s
.70133 .64455 m .70975 .63458 L .70112 .63713 L p .724 .983 .779 r
F P
0 g
s
.55548 .42334 m .55029 .40715 L .57304 .42455 L p .419 .595 .917 r
F P
0 g
s
.73545 .59612 m .72845 .60771 L .72689 .59994 L p 0 0 .351 r
F P
0 g
s
.72689 .59994 m .73282 .58785 L .73545 .59612 L p 0 0 .351 r
F P
0 g
s
.69573 .51061 m .69426 .52525 L .67738 .50985 L p .385 .518 .869 r
F P
0 g
s
.67738 .50985 m .67782 .49483 L .69573 .51061 L p .385 .518 .869 r
F P
0 g
s
.67782 .49483 m .67738 .50985 L .65878 .49366 L p .401 .543 .883 r
F P
0 g
s
.65878 .49366 m .6582 .47828 L .67782 .49483 L p .401 .543 .883 r
F P
0 g
s
.6582 .47828 m .65878 .49366 L .63875 .47684 L p .412 .562 .894 r
F P
0 g
s
.66611 .65454 m .65515 .66267 L .67217 .66434 L p .718 .972 .929 r
F P
0 g
s
.67217 .66434 m .68192 .65563 L .66611 .65454 L p .718 .972 .929 r
F P
0 g
s
.72627 .61353 m .71806 .62424 L .72133 .61893 L p 0 0 0 r
F P
0 g
s
.72133 .61893 m .72845 .60771 L .72627 .61353 L p 0 0 0 r
F P
0 g
s
.71164 .52545 m .70913 .53968 L .69426 .52525 L p .361 .484 .848 r
F P
0 g
s
.69426 .52525 m .69573 .51061 L .71164 .52545 L p .361 .484 .848 r
F P
0 g
s
.63875 .47684 m .63715 .46114 L .6582 .47828 L p .412 .562 .894 r
F P
0 g
s
.63715 .46114 m .63875 .47684 L .61758 .45959 L p .419 .576 .902 r
F P
0 g
s
.73864 .57538 m .73282 .58785 L .72688 .57787 L p .145 .185 .645 r
F P
0 g
s
.72688 .57787 m .73164 .56493 L .73864 .57538 L p .145 .185 .645 r
F P
0 g
s
.61758 .45959 m .61498 .44361 L .63715 .46114 L p .419 .576 .902 r
F P
0 g
s
.61498 .44361 m .61758 .45959 L .59558 .4421 L p .424 .587 .909 r
F P
0 g
s
.72526 .53917 m .72169 .55296 L .70913 .53968 L p .327 .434 .818 r
F P
0 g
s
.70913 .53968 m .71164 .52545 L .72526 .53917 L p .327 .434 .818 r
F P
0 g
s
.71057 .62734 m .70112 .63713 L .70975 .63458 L p .713 .968 .725 r
F P
0 g
s
.70975 .63458 m .71806 .62424 L .71057 .62734 L p .713 .968 .725 r
F P
0 g
s
.59558 .4421 m .59199 .42587 L .61498 .44361 L p .424 .587 .909 r
F P
0 g
s
.59199 .42587 m .59558 .4421 L .57304 .42455 L p .426 .596 .915 r
F P
0 g
s
.67696 .64604 m .66611 .65454 L .68192 .65563 L p .723 .979 .916 r
F P
0 g
s
.68192 .65563 m .69158 .64656 L .67696 .64604 L p .723 .979 .916 r
F P
0 g
s
.73626 .55159 m .73164 .56493 L .72169 .55296 L p .273 .359 .77 r
F P
0 g
s
.72169 .55296 m .72526 .53917 L .73626 .55159 L p .273 .359 .77 r
F P
0 g
s
.57304 .42455 m .56848 .40812 L .59199 .42587 L p .426 .596 .915 r
F P
0 g
s
.56848 .40812 m .57304 .42455 L .55029 .40715 L p .426 .602 .92 r
F P
0 g
s
.74235 .58414 m .73545 .59612 L .73282 .58785 L p 0 0 .44 r
F P
0 g
s
.73282 .58785 m .73864 .57538 L .74235 .58414 L p 0 0 .44 r
F P
0 g
s
.6201 .66521 m .60759 .67199 L .63288 .67786 L p .688 .931 .968 r
F P
0 g
s
.63288 .67786 m .64407 .67045 L .6201 .66521 L p .688 .931 .968 r
F P
0 g
s
.73438 .60246 m .72627 .61353 L .72845 .60771 L p 0 0 0 r
F P
0 g
s
.72845 .60771 m .73545 .59612 L .73438 .60246 L p 0 0 0 r
F P
0 g
s
.69702 .49556 m .69573 .51061 L .67782 .49483 L p .395 .53 .875 r
F P
0 g
s
.67782 .49483 m .67806 .4794 L .69702 .49556 L p .395 .53 .875 r
F P
0 g
s
.67806 .4794 m .67782 .49483 L .6582 .47828 L p .409 .553 .888 r
F P
0 g
s
.55029 .40715 m .54478 .39057 L .56848 .40812 L p .426 .602 .92 r
F P
0 g
s
.6582 .47828 m .65739 .46249 L .67806 .4794 L p .409 .553 .888 r
F P
0 g
s
.65739 .46249 m .6582 .47828 L .63715 .46114 L p .42 .571 .898 r
F P
0 g
s
.74434 .56252 m .73864 .57538 L .73164 .56493 L p .185 .237 .683 r
F P
0 g
s
.73164 .56493 m .73626 .55159 L .74434 .56252 L p .185 .237 .683 r
F P
0 g
s
.71399 .51082 m .71164 .52545 L .69573 .51061 L p .373 .499 .857 r
F P
0 g
s
.69573 .51061 m .69702 .49556 L .71399 .51082 L p .373 .499 .857 r
F P
0 g
s
.71992 .61717 m .71057 .62734 L .71806 .62424 L p .693 .943 .657 r
F P
0 g
s
.71806 .62424 m .72627 .61353 L .71992 .61717 L p .693 .943 .657 r
F P
0 g
s
.63715 .46114 m .6353 .44504 L .65739 .46249 L p .42 .571 .898 r
F P
0 g
s
.6353 .44504 m .63715 .46114 L .61498 .44361 L p .427 .584 .906 r
F P
0 g
s
.6877 .63718 m .67696 .64604 L .69158 .64656 L p .727 .984 .9 r
F P
0 g
s
.69158 .64656 m .70112 .63713 L .6877 .63718 L p .727 .984 .9 r
F P
0 g
s
.72867 .52497 m .72526 .53917 L .71164 .52545 L p .343 .454 .83 r
F P
0 g
s
.71164 .52545 m .71399 .51082 L .72867 .52497 L p .343 .454 .83 r
F P
0 g
s
.63247 .65806 m .6201 .66521 L .64407 .67045 L p .693 .937 .964 r
F P
0 g
s
.64407 .67045 m .65515 .66267 L .63247 .65806 L p .693 .937 .964 r
F P
0 g
s
.61498 .44361 m .61211 .42722 L .6353 .44504 L p .427 .584 .906 r
F P
0 g
s
.61211 .42722 m .61498 .44361 L .59199 .42587 L p .431 .595 .912 r
F P
0 g
s
.74075 .53785 m .73626 .55159 L .72526 .53917 L p .295 .388 .788 r
F P
0 g
s
.72526 .53917 m .72867 .52497 L .74075 .53785 L p .295 .388 .788 r
F P
0 g
s
.59199 .42587 m .5881 .40923 L .61211 .42722 L p .431 .595 .912 r
F P
0 g
s
.5881 .40923 m .59199 .42587 L .56848 .40812 L p .433 .603 .917 r
F P
0 g
s
.74239 .591 m .73438 .60246 L .73545 .59612 L p 0 0 .042 r
F P
0 g
s
.73545 .59612 m .74235 .58414 L .74239 .591 L p 0 0 .042 r
F P
0 g
s
.74914 .57178 m .74235 .58414 L .73864 .57538 L p .029 .024 .515 r
F P
0 g
s
.73864 .57538 m .74434 .56252 L .74914 .57178 L p .029 .024 .515 r
F P
0 g
s
.64472 .65054 m .63247 .65806 L .65515 .66267 L p .698 .944 .96 r
F P
0 g
s
.65515 .66267 m .66611 .65454 L .64472 .65054 L p .698 .944 .96 r
F P
0 g
s
.69834 .62796 m .6877 .63718 L .70112 .63713 L p .73 .989 .88 r
F P
0 g
s
.70112 .63713 m .71057 .62734 L .69834 .62796 L p .73 .989 .88 r
F P
0 g
s
.56848 .40812 m .5636 .39129 L .5881 .40923 L p .433 .603 .917 r
F P
0 g
s
.5636 .39129 m .56848 .40812 L .54478 .39057 L p .434 .609 .922 r
F P
0 g
s
.72917 .60663 m .71992 .61717 L .72627 .61353 L p .662 .903 .571 r
F P
0 g
s
.72627 .61353 m .73438 .60246 L .72917 .60663 L p .662 .903 .571 r
F P
0 g
s
.74991 .54926 m .74434 .56252 L .73626 .55159 L p .219 .282 .716 r
F P
0 g
s
.73626 .55159 m .74075 .53785 L .74991 .54926 L p .219 .282 .716 r
F P
0 g
s
.69811 .4801 m .69702 .49556 L .67806 .4794 L p .404 .541 .88 r
F P
0 g
s
.67806 .4794 m .67807 .46355 L .69811 .4801 L p .404 .541 .88 r
F P
0 g
s
.67807 .46355 m .67806 .4794 L .65739 .46249 L p .417 .563 .892 r
F P
0 g
s
.71616 .49577 m .71399 .51082 L .69702 .49556 L p .385 .513 .864 r
F P
0 g
s
.69702 .49556 m .69811 .4801 L .71616 .49577 L p .385 .513 .864 r
F P
0 g
s
.65739 .46249 m .65634 .44629 L .67807 .46355 L p .417 .563 .892 r
F P
0 g
s
.65634 .44629 m .65739 .46249 L .6353 .44504 L p .427 .579 .901 r
F P
0 g
s
.54478 .39057 m .53894 .37361 L .5636 .39129 L p .434 .609 .922 r
F P
0 g
s
.6353 .44504 m .6332 .42851 L .65634 .44629 L p .427 .579 .901 r
F P
0 g
s
.6332 .42851 m .6353 .44504 L .61211 .42722 L p .433 .591 .908 r
F P
0 g
s
.65684 .64266 m .64472 .65054 L .66611 .65454 L p .703 .951 .954 r
F P
0 g
s
.66611 .65454 m .67696 .64604 L .65684 .64266 L p .703 .951 .954 r
F P
0 g
s
.73192 .51036 m .72867 .52497 L .71399 .51082 L p .357 .473 .84 r
F P
0 g
s
.71399 .51082 m .71616 .49577 L .73192 .51036 L p .357 .473 .84 r
F P
0 g
s
.75029 .57915 m .74239 .591 L .74235 .58414 L p 0 0 .173 r
F P
0 g
s
.74235 .58414 m .74914 .57178 L .75029 .57915 L p 0 0 .173 r
F P
0 g
s
.70887 .61836 m .69834 .62796 L .71057 .62734 L p .731 .991 .854 r
F P
0 g
s
.71057 .62734 m .71992 .61717 L .70887 .61836 L p .731 .991 .854 r
F P
0 g
s
.61211 .42722 m .60896 .41041 L .6332 .42851 L p .433 .591 .908 r
F P
0 g
s
.60896 .41041 m .61211 .42722 L .5881 .40923 L p .438 .601 .914 r
F P
0 g
s
.74509 .5237 m .74075 .53785 L .72867 .52497 L p .315 .414 .804 r
F P
0 g
s
.72867 .52497 m .73192 .51036 L .74509 .5237 L p .315 .414 .804 r
F P
0 g
s
.75582 .55902 m .74914 .57178 L .74434 .56252 L p .086 .1 .577 r
F P
0 g
s
.74434 .56252 m .74991 .54926 L .75582 .55902 L p .086 .1 .577 r
F P
0 g
s
.73832 .59572 m .72917 .60663 L .73438 .60246 L p .617 .844 .465 r
F P
0 g
s
.73438 .60246 m .74239 .591 L .73832 .59572 L p .617 .844 .465 r
F P
0 g
s
.5881 .40923 m .58392 .39219 L .60896 .41041 L p .438 .601 .914 r
F P
0 g
s
.58392 .39219 m .5881 .40923 L .5636 .39129 L p .44 .609 .92 r
F P
0 g
s
.66886 .63442 m .65684 .64266 L .67696 .64604 L p .709 .957 .948 r
F P
0 g
s
.67696 .64604 m .6877 .63718 L .66886 .63442 L p .709 .957 .948 r
F P
0 g
s
.75536 .5356 m .74991 .54926 L .74075 .53785 L p .249 .321 .742 r
F P
0 g
s
.74075 .53785 m .74509 .5237 L .75536 .5356 L p .249 .321 .742 r
F P
0 g
s
.58954 .65659 m .57561 .66268 L .60759 .67199 L p .671 .908 .977 r
F P
0 g
s
.60759 .67199 m .6201 .66521 L .58954 .65659 L p .671 .908 .977 r
F P
0 g
s
.5636 .39129 m .5584 .37406 L .58392 .39219 L p .44 .609 .92 r
F P
0 g
s
.5584 .37406 m .5636 .39129 L .53894 .37361 L p .441 .616 .924 r
F P
0 g
s
.71932 .6084 m .70887 .61836 L .71992 .61717 L p .729 .989 .821 r
F P
0 g
s
.71992 .61717 m .72917 .60663 L .71932 .6084 L p .729 .989 .821 r
F P
0 g
s
.699 .46422 m .69811 .4801 L .67807 .46355 L p .412 .551 .885 r
F P
0 g
s
.67807 .46355 m .67787 .44727 L .699 .46422 L p .412 .551 .885 r
F P
0 g
s
.67787 .44727 m .67807 .46355 L .65634 .44629 L p .425 .571 .896 r
F P
0 g
s
.71815 .4803 m .71616 .49577 L .69811 .4801 L p .395 .525 .87 r
F P
0 g
s
.69811 .4801 m .699 .46422 L .71815 .4803 L p .395 .525 .87 r
F P
0 g
s
.65634 .44629 m .65504 .42965 L .67787 .44727 L p .425 .571 .896 r
F P
0 g
s
.65504 .42965 m .65634 .44629 L .6332 .42851 L p .434 .586 .904 r
F P
0 g
s
.7581 .56692 m .75029 .57915 L .74914 .57178 L p 0 0 .29 r
F P
0 g
s
.74914 .57178 m .75582 .55902 L .7581 .56692 L p 0 0 .29 r
F P
0 g
s
.73501 .49534 m .73192 .51036 L .71616 .49577 L p .37 .489 .849 r
F P
0 g
s
.71616 .49577 m .71815 .4803 L .73501 .49534 L p .37 .489 .849 r
F P
0 g
s
.53894 .37361 m .53275 .35624 L .5584 .37406 L p .441 .616 .924 r
F P
0 g
s
.60333 .65012 m .58954 .65659 L .6201 .66521 L p .675 .913 .975 r
F P
0 g
s
.6201 .66521 m .63247 .65806 L .60333 .65012 L p .675 .913 .975 r
F P
0 g
s
.68076 .6258 m .66886 .63442 L .6877 .63718 L p .714 .964 .94 r
F P
0 g
s
.6877 .63718 m .69834 .62796 L .68076 .6258 L p .714 .964 .94 r
F P
0 g
s
.6332 .42851 m .63082 .41156 L .65504 .42965 L p .434 .586 .904 r
F P
0 g
s
.63082 .41156 m .6332 .42851 L .60896 .41041 L p .44 .598 .911 r
F P
0 g
s
.74239 .591 m .75029 .57915 L .74738 .58442 L p 0 0 0 r
F P
0 g
s
.74738 .58442 m .73832 .59572 L .74239 .591 L p 0 0 0 r
F P
0 g
s
.76239 .54587 m .75582 .55902 L .74991 .54926 L p .135 .165 .628 r
F P
0 g
s
.74991 .54926 m .75536 .5356 L .76239 .54587 L p .135 .165 .628 r
F P
0 g
s
.7493 .50914 m .74509 .5237 L .73192 .51036 L p .333 .436 .817 r
F P
0 g
s
.73192 .51036 m .73501 .49534 L .7493 .50914 L p .333 .436 .817 r
F P
0 g
s
.60896 .41041 m .60551 .39318 L .63082 .41156 L p .44 .598 .911 r
F P
0 g
s
.60551 .39318 m .60896 .41041 L .58392 .39219 L p .444 .608 .917 r
F P
0 g
s
.61698 .64327 m .60333 .65012 L .63247 .65806 L p .68 .918 .973 r
F P
0 g
s
.63247 .65806 m .64472 .65054 L .61698 .64327 L p .68 .918 .973 r
F P
0 g
s
.72966 .59805 m .71932 .6084 L .72917 .60663 L p .723 .982 .778 r
F P
0 g
s
.72917 .60663 m .73832 .59572 L .72966 .59805 L p .723 .982 .778 r
F P
0 g
s
.58392 .39219 m .57942 .37473 L .60551 .39318 L p .444 .608 .917 r
F P
0 g
s
.57942 .37473 m .58392 .39219 L .5584 .37406 L p .446 .615 .922 r
F P
0 g
s
.76068 .52153 m .75536 .5356 L .74509 .5237 L p .275 .356 .765 r
F P
0 g
s
.74509 .5237 m .7493 .50914 L .76068 .52153 L p .275 .356 .765 r
F P
0 g
s
.69256 .61681 m .68076 .6258 L .69834 .62796 L p .719 .971 .93 r
F P
0 g
s
.69834 .62796 m .70887 .61836 L .69256 .61681 L p .719 .971 .93 r
F P
0 g
s
.5584 .37406 m .55287 .35642 L .57942 .37473 L p .446 .615 .922 r
F P
0 g
s
.55287 .35642 m .5584 .37406 L .53275 .35624 L p .447 .622 .926 r
F P
0 g
s
.76581 .55429 m .7581 .56692 L .75582 .55902 L p 0 0 .391 r
F P
0 g
s
.75582 .55902 m .76239 .54587 L .76581 .55429 L p 0 0 .391 r
F P
0 g
s
.75634 .57273 m .74738 .58442 L .75029 .57915 L p 0 0 0 r
F P
0 g
s
.75029 .57915 m .7581 .56692 L .75634 .57273 L p 0 0 0 r
F P
0 g
s
.63049 .63606 m .61698 .64327 L .64472 .65054 L p .684 .924 .971 r
F P
0 g
s
.64472 .65054 m .65684 .64266 L .63049 .63606 L p .684 .924 .971 r
F P
0 g
s
.71995 .4644 m .71815 .4803 L .699 .46422 L p .405 .537 .876 r
F P
0 g
s
.699 .46422 m .69968 .4479 L .71995 .4644 L p .405 .537 .876 r
F P
0 g
s
.69968 .4479 m .699 .46422 L .67787 .44727 L p .421 .561 .889 r
F P
0 g
s
.67787 .44727 m .67743 .43056 L .69968 .4479 L p .421 .561 .889 r
F P
0 g
s
.67743 .43056 m .67787 .44727 L .65504 .42965 L p .432 .579 .899 r
F P
0 g
s
.73794 .47989 m .73501 .49534 L .71815 .4803 L p .382 .504 .857 r
F P
0 g
s
.71815 .4803 m .71995 .4644 L .73794 .47989 L p .382 .504 .857 r
F P
0 g
s
.65504 .42965 m .65349 .41259 L .67743 .43056 L p .432 .579 .899 r
F P
0 g
s
.65349 .41259 m .65504 .42965 L .63082 .41156 L p .44 .593 .907 r
F P
0 g
s
.76884 .5323 m .76239 .54587 L .75536 .5356 L p .177 .221 .67 r
F P
0 g
s
.75536 .5356 m .76068 .52153 L .76884 .5323 L p .177 .221 .67 r
F P
0 g
s
.53275 .35624 m .5262 .33848 L .55287 .35642 L p .447 .622 .926 r
F P
0 g
s
.63082 .41156 m .62817 .39417 L .65349 .41259 L p .44 .593 .907 r
F P
0 g
s
.62817 .39417 m .63082 .41156 L .60551 .39318 L p .446 .605 .914 r
F P
0 g
s
.75335 .49416 m .7493 .50914 L .73501 .49534 L p .349 .457 .829 r
F P
0 g
s
.73501 .49534 m .73794 .47989 L .75335 .49416 L p .349 .457 .829 r
F P
0 g
s
.73992 .58732 m .72966 .59805 L .73832 .59572 L p .71 .967 .722 r
F P
0 g
s
.73832 .59572 m .74738 .58442 L .73992 .58732 L p .71 .967 .722 r
F P
0 g
s
.70426 .60745 m .69256 .61681 L .70887 .61836 L p .723 .978 .918 r
F P
0 g
s
.70887 .61836 m .71932 .6084 L .70426 .60745 L p .723 .978 .918 r
F P
0 g
s
.64388 .62847 m .63049 .63606 L .65684 .64266 L p .689 .929 .968 r
F P
0 g
s
.65684 .64266 m .66886 .63442 L .64388 .62847 L p .689 .929 .968 r
F P
0 g
s
.60551 .39318 m .60176 .37552 L .62817 .39417 L p .446 .605 .914 r
F P
0 g
s
.60176 .37552 m .60551 .39318 L .57942 .37473 L p .45 .614 .919 r
F P
0 g
s
.76587 .50704 m .76068 .52153 L .7493 .50914 L p .298 .386 .784 r
F P
0 g
s
.7493 .50914 m .75335 .49416 L .76587 .50704 L p .298 .386 .784 r
F P
0 g
s
.57942 .37473 m .57459 .35684 L .60176 .37552 L p .45 .614 .919 r
F P
0 g
s
.57459 .35684 m .57942 .37473 L .55287 .35642 L p .453 .621 .924 r
F P
0 g
s
.76522 .56065 m .75634 .57273 L .7581 .56692 L p 0 0 0 r
F P
0 g
s
.7581 .56692 m .76581 .55429 L .76522 .56065 L p 0 0 0 r
F P
0 g
s
.77341 .54126 m .76581 .55429 L .76239 .54587 L p .002 0 .476 r
F P
0 g
s
.76239 .54587 m .76884 .5323 L .77341 .54126 L p .002 0 .476 r
F P
0 g
s
.65714 .62051 m .64388 .62847 L .66886 .63442 L p .694 .936 .965 r
F P
0 g
s
.66886 .63442 m .68076 .6258 L .65714 .62051 L p .694 .936 .965 r
F P
0 g
s
.71586 .59771 m .70426 .60745 L .71932 .6084 L p .727 .984 .902 r
F P
0 g
s
.71932 .6084 m .72966 .59805 L .71586 .59771 L p .727 .984 .902 r
F P
0 g
s
.75008 .57621 m .73992 .58732 L .74738 .58442 L p .688 .94 .651 r
F P
0 g
s
.74738 .58442 m .75634 .57273 L .75008 .57621 L p .688 .94 .651 r
F P
0 g
s
.55287 .35642 m .54698 .33836 L .57459 .35684 L p .453 .621 .924 r
F P
0 g
s
.54698 .33836 m .55287 .35642 L .5262 .33848 L p .454 .628 .928 r
F P
0 g
s
.77518 .51833 m .76884 .5323 L .76068 .52153 L p .214 .27 .705 r
F P
0 g
s
.76068 .52153 m .76587 .50704 L .77518 .51833 L p .214 .27 .705 r
F P
0 g
s
.72155 .44807 m .71995 .4644 L .69968 .4479 L p .413 .548 .881 r
F P
0 g
s
.69968 .4479 m .70014 .43114 L .72155 .44807 L p .413 .548 .881 r
F P
0 g
s
.70014 .43114 m .69968 .4479 L .67743 .43056 L p .428 .57 .893 r
F P
0 g
s
.55144 .6441 m .53591 .64944 L .57561 .66268 L p .657 .888 .981 r
F P
0 g
s
.57561 .66268 m .58954 .65659 L .55144 .6441 L p .657 .888 .981 r
F P
0 g
s
.67743 .43056 m .67675 .41342 L .70014 .43114 L p .428 .57 .893 r
F P
0 g
s
.67675 .41342 m .67743 .43056 L .65349 .41259 L p .439 .587 .903 r
F P
0 g
s
.74069 .464 m .73794 .47989 L .71995 .4644 L p .393 .518 .864 r
F P
0 g
s
.71995 .4644 m .72155 .44807 L .74069 .464 L p .393 .518 .864 r
F P
0 g
s
.65349 .41259 m .65168 .39509 L .67675 .41342 L p .439 .587 .903 r
F P
0 g
s
.65168 .39509 m .65349 .41259 L .62817 .39417 L p .446 .6 .91 r
F P
0 g
s
.75725 .47875 m .75335 .49416 L .73794 .47989 L p .363 .475 .84 r
F P
0 g
s
.73794 .47989 m .74069 .464 L .75725 .47875 L p .363 .475 .84 r
F P
0 g
s
.5262 .33848 m .51928 .32031 L .54698 .33836 L p .454 .628 .928 r
F P
0 g
s
.62817 .39417 m .62523 .37635 L .65168 .39509 L p .446 .6 .91 r
F P
0 g
s
.62523 .37635 m .62817 .39417 L .60176 .37552 L p .452 .611 .916 r
F P
0 g
s
.56679 .63838 m .55144 .6441 L .58954 .65659 L p .661 .892 .98 r
F P
0 g
s
.58954 .65659 m .60333 .65012 L .56679 .63838 L p .661 .892 .98 r
F P
0 g
s
.67029 .61217 m .65714 .62051 L .68076 .6258 L p .698 .942 .961 r
F P
0 g
s
.68076 .6258 m .69256 .61681 L .67029 .61217 L p .698 .942 .961 r
F P
0 g
s
.774 .54817 m .76522 .56065 L .76581 .55429 L p 0 0 .081 r
F P
0 g
s
.76581 .55429 m .77341 .54126 L .774 .54817 L p 0 0 .081 r
F P
0 g
s
.77093 .49213 m .76587 .50704 L .75335 .49416 L p .318 .412 .801 r
F P
0 g
s
.75335 .49416 m .75725 .47875 L .77093 .49213 L p .318 .412 .801 r
F P
0 g
s
.60176 .37552 m .5977 .35743 L .62523 .37635 L p .452 .611 .916 r
F P
0 g
s
.5977 .35743 m .60176 .37552 L .57459 .35684 L p .456 .62 .921 r
F P
0 g
s
.72737 .58758 m .71586 .59771 L .72966 .59805 L p .73 .988 .882 r
F P
0 g
s
.72966 .59805 m .73992 .58732 L .72737 .58758 L p .73 .988 .882 r
F P
0 g
s
.78091 .52782 m .77341 .54126 L .76884 .5323 L p .064 .064 .546 r
F P
0 g
s
.76884 .5323 m .77518 .51833 L .78091 .52782 L p .064 .064 .546 r
F P
0 g
s
.58197 .63227 m .56679 .63838 L .60333 .65012 L p .664 .897 .979 r
F P
0 g
s
.60333 .65012 m .61698 .64327 L .58197 .63227 L p .664 .897 .979 r
F P
0 g
s
.76016 .5647 m .75008 .57621 L .75634 .57273 L p .655 .897 .561 r
F P
0 g
s
.75634 .57273 m .76522 .56065 L .76016 .5647 L p .655 .897 .561 r
F P
0 g
s
.57459 .35684 m .56943 .33853 L .5977 .35743 L p .456 .62 .921 r
F P
0 g
s
.56943 .33853 m .57459 .35684 L .54698 .33836 L p .458 .627 .925 r
F P
0 g
s
.7814 .50393 m .77518 .51833 L .76587 .50704 L p .246 .311 .734 r
F P
0 g
s
.76587 .50704 m .77093 .49213 L .7814 .50393 L p .246 .311 .734 r
F P
0 g
s
.68333 .60345 m .67029 .61217 L .69256 .61681 L p .703 .949 .956 r
F P
0 g
s
.69256 .61681 m .70426 .60745 L .68333 .60345 L p .703 .949 .956 r
F P
0 g
s
.597 .62579 m .58197 .63227 L .61698 .64327 L p .668 .901 .978 r
F P
0 g
s
.61698 .64327 m .63049 .63606 L .597 .62579 L p .668 .901 .978 r
F P
0 g
s
.72296 .43129 m .72155 .44807 L .70014 .43114 L p .422 .557 .886 r
F P
0 g
s
.70014 .43114 m .70038 .41394 L .72296 .43129 L p .422 .557 .886 r
F P
0 g
s
.70038 .41394 m .70014 .43114 L .67675 .41342 L p .435 .578 .897 r
F P
0 g
s
.54698 .33836 m .54074 .31988 L .56943 .33853 L p .458 .627 .925 r
F P
0 g
s
.54074 .31988 m .54698 .33836 L .51928 .32031 L p .46 .633 .929 r
F P
0 g
s
.74326 .44768 m .74069 .464 L .72155 .44807 L p .403 .53 .871 r
F P
0 g
s
.72155 .44807 m .72296 .43129 L .74326 .44768 L p .403 .53 .871 r
F P
0 g
s
.67675 .41342 m .67583 .39582 L .70038 .41394 L p .435 .578 .897 r
F P
0 g
s
.67583 .39582 m .67675 .41342 L .65168 .39509 L p .445 .594 .906 r
F P
0 g
s
.73879 .57707 m .72737 .58758 L .73992 .58732 L p .73 .991 .856 r
F P
0 g
s
.73992 .58732 m .75008 .57621 L .73879 .57707 L p .73 .991 .856 r
F P
0 g
s
.65168 .39509 m .64959 .37713 L .67583 .39582 L p .445 .594 .906 r
F P
0 g
s
.64959 .37713 m .65168 .39509 L .62523 .37635 L p .452 .606 .912 r
F P
0 g
s
.761 .46291 m .75725 .47875 L .74069 .464 L p .376 .492 .849 r
F P
0 g
s
.74069 .464 m .74326 .44768 L .761 .46291 L p .376 .492 .849 r
F P
0 g
s
.78268 .53529 m .774 .54817 L .77341 .54126 L p 0 0 .211 r
F P
0 g
s
.77341 .54126 m .78091 .52782 L .78268 .53529 L p 0 0 .211 r
F P
0 g
s
.51928 .32031 m .51198 .30174 L .54074 .31988 L p .46 .633 .929 r
F P
0 g
s
.62523 .37635 m .62199 .35808 L .64959 .37713 L p .452 .606 .912 r
F P
0 g
s
.62199 .35808 m .62523 .37635 L .5977 .35743 L p .458 .617 .918 r
F P
0 g
s
.61189 .61892 m .597 .62579 L .63049 .63606 L p .672 .906 .977 r
F P
0 g
s
.63049 .63606 m .64388 .62847 L .61189 .61892 L p .672 .906 .977 r
F P
0 g
s
.77015 .5528 m .76016 .5647 L .76522 .56065 L p .606 .834 .451 r
F P
0 g
s
.76522 .56065 m .774 .54817 L .77015 .5528 L p .606 .834 .451 r
F P
0 g
s
.78831 .51396 m .78091 .52782 L .77518 .51833 L p .118 .136 .603 r
F P
0 g
s
.77518 .51833 m .7814 .50393 L .78831 .51396 L p .118 .136 .603 r
F P
0 g
s
.69627 .59435 m .68333 .60345 L .70426 .60745 L p .708 .956 .95 r
F P
0 g
s
.70426 .60745 m .71586 .59771 L .69627 .59435 L p .708 .956 .95 r
F P
0 g
s
.77585 .47679 m .77093 .49213 L .75725 .47875 L p .337 .436 .815 r
F P
0 g
s
.75725 .47875 m .761 .46291 L .77585 .47679 L p .337 .436 .815 r
F P
0 g
s
.5977 .35743 m .59332 .33889 L .62199 .35808 L p .458 .617 .918 r
F P
0 g
s
.59332 .33889 m .5977 .35743 L .56943 .33853 L p .461 .625 .923 r
F P
0 g
s
.7875 .48911 m .7814 .50393 L .77093 .49213 L p .273 .348 .758 r
F P
0 g
s
.77093 .49213 m .77585 .47679 L .7875 .48911 L p .273 .348 .758 r
F P
0 g
s
.62663 .61166 m .61189 .61892 L .64388 .62847 L p .676 .911 .976 r
F P
0 g
s
.64388 .62847 m .65714 .62051 L .62663 .61166 L p .676 .911 .976 r
F P
0 g
s
.75013 .56616 m .73879 .57707 L .75008 .57621 L p .728 .989 .823 r
F P
0 g
s
.75008 .57621 m .76016 .5647 L .75013 .56616 L p .728 .989 .823 r
F P
0 g
s
.56943 .33853 m .56391 .31978 L .59332 .33889 L p .461 .625 .923 r
F P
0 g
s
.56391 .31978 m .56943 .33853 L .54074 .31988 L p .464 .632 .927 r
F P
0 g
s
.70911 .58486 m .69627 .59435 L .71586 .59771 L p .713 .963 .942 r
F P
0 g
s
.71586 .59771 m .72737 .58758 L .70911 .58486 L p .713 .963 .942 r
F P
0 g
s
.72416 .41406 m .72296 .43129 L .70038 .41394 L p .429 .567 .89 r
F P
0 g
s
.70038 .41394 m .70039 .39628 L .72416 .41406 L p .429 .567 .89 r
F P
0 g
s
.70039 .39628 m .70038 .41394 L .67583 .39582 L p .442 .586 .9 r
F P
0 g
s
.74565 .4309 m .74326 .44768 L .72296 .43129 L p .412 .541 .876 r
F P
0 g
s
.72296 .43129 m .72416 .41406 L .74565 .4309 L p .412 .541 .876 r
F P
0 g
s
.79128 .52199 m .78268 .53529 L .78091 .52782 L p 0 0 .326 r
F P
0 g
s
.78091 .52782 m .78831 .51396 L .79128 .52199 L p 0 0 .326 r
F P
0 g
s
.67583 .39582 m .67464 .37777 L .70039 .39628 L p .442 .586 .9 r
F P
0 g
s
.67464 .37777 m .67583 .39582 L .64959 .37713 L p .451 .601 .908 r
F P
0 g
s
.54074 .31988 m .53412 .30098 L .56391 .31978 L p .464 .632 .927 r
F P
0 g
s
.53412 .30098 m .54074 .31988 L .51198 .30174 L p .466 .639 .931 r
F P
0 g
s
.774 .54817 m .78268 .53529 L .78006 .54049 L p 0 0 0 r
F P
0 g
s
.78006 .54049 m .77015 .5528 L .774 .54817 L p 0 0 0 r
F P
0 g
s
.76458 .44662 m .761 .46291 L .74326 .44768 L p .388 .507 .857 r
F P
0 g
s
.74326 .44768 m .74565 .4309 L .76458 .44662 L p .388 .507 .857 r
F P
0 g
s
.64124 .60402 m .62663 .61166 L .65714 .62051 L p .68 .916 .974 r
F P
0 g
s
.65714 .62051 m .67029 .61217 L .64124 .60402 L p .68 .916 .974 r
F P
0 g
s
.64959 .37713 m .64722 .35872 L .67464 .37777 L p .451 .601 .908 r
F P
0 g
s
.64722 .35872 m .64959 .37713 L .62199 .35808 L p .458 .612 .915 r
F P
0 g
s
.7956 .49968 m .78831 .51396 L .7814 .50393 L p .165 .198 .65 r
F P
0 g
s
.7814 .50393 m .7875 .48911 L .7956 .49968 L p .165 .198 .65 r
F P
0 g
s
.78062 .461 m .77585 .47679 L .761 .46291 L p .353 .457 .827 r
F P
0 g
s
.761 .46291 m .76458 .44662 L .78062 .461 L p .353 .457 .827 r
F P
0 g
s
.51198 .30174 m .50429 .28275 L .53412 .30098 L p .466 .639 .931 r
F P
0 g
s
.62199 .35808 m .61843 .33936 L .64722 .35872 L p .458 .612 .915 r
F P
0 g
s
.61843 .33936 m .62199 .35808 L .59332 .33889 L p .463 .622 .92 r
F P
0 g
s
.76138 .55487 m .75013 .56616 L .76016 .5647 L p .721 .982 .779 r
F P
0 g
s
.76016 .5647 m .77015 .5528 L .76138 .55487 L p .721 .982 .779 r
F P
0 g
s
.50458 .62716 m .48727 .63165 L .53591 .64944 L p .646 .873 .983 r
F P
0 g
s
.53591 .64944 m .55144 .6441 L .50458 .62716 L p .646 .873 .983 r
F P
0 g
s
.72185 .57499 m .70911 .58486 L .72737 .58758 L p .718 .97 .932 r
F P
0 g
s
.72737 .58758 m .73879 .57707 L .72185 .57499 L p .718 .97 .932 r
F P
0 g
s
.65574 .596 m .64124 .60402 L .67029 .61217 L p .684 .922 .972 r
F P
0 g
s
.67029 .61217 m .68333 .60345 L .65574 .596 L p .684 .922 .972 r
F P
0 g
s
.59332 .33889 m .5886 .31991 L .61843 .33936 L p .463 .622 .92 r
F P
0 g
s
.5886 .31991 m .59332 .33889 L .56391 .31978 L p .467 .63 .925 r
F P
0 g
s
.79347 .47386 m .7875 .48911 L .77585 .47679 L p .298 .38 .778 r
F P
0 g
s
.77585 .47679 m .78062 .461 L .79347 .47386 L p .298 .38 .778 r
F P
0 g
s
.52168 .62228 m .50458 .62716 L .55144 .6441 L p .649 .876 .983 r
F P
0 g
s
.55144 .6441 m .56679 .63838 L .52168 .62228 L p .649 .876 .983 r
F P
0 g
s
.79978 .50828 m .79128 .52199 L .78831 .51396 L p 0 0 .423 r
F P
0 g
s
.78831 .51396 m .7956 .49968 L .79978 .50828 L p 0 0 .423 r
F P
0 g
s
.78988 .52778 m .78006 .54049 L .78268 .53529 L p 0 0 0 r
F P
0 g
s
.78268 .53529 m .79128 .52199 L .78988 .52778 L p 0 0 0 r
F P
0 g
s
.56391 .31978 m .55804 .30058 L .5886 .31991 L p .467 .63 .925 r
F P
0 g
s
.55804 .30058 m .56391 .31978 L .53412 .30098 L p .47 .637 .929 r
F P
0 g
s
.53858 .61699 m .52168 .62228 L .56679 .63838 L p .652 .879 .982 r
F P
0 g
s
.56679 .63838 m .58197 .63227 L .53858 .61699 L p .652 .879 .982 r
F P
0 g
s
.74785 .41367 m .74565 .4309 L .72416 .41406 L p .421 .552 .882 r
F P
0 g
s
.72416 .41406 m .72514 .39637 L .74785 .41367 L p .421 .552 .882 r
F P
0 g
s
.72514 .39637 m .72416 .41406 L .70039 .39628 L p .437 .575 .894 r
F P
0 g
s
.70039 .39628 m .70015 .37816 L .72514 .39637 L p .437 .575 .894 r
F P
0 g
s
.70015 .37816 m .70039 .39628 L .67464 .37777 L p .448 .593 .904 r
F P
0 g
s
.67011 .58759 m .65574 .596 L .68333 .60345 L p .688 .927 .969 r
F P
0 g
s
.68333 .60345 m .69627 .59435 L .67011 .58759 L p .688 .927 .969 r
F P
0 g
s
.80279 .48498 m .7956 .49968 L .7875 .48911 L p .204 .251 .689 r
F P
0 g
s
.7875 .48911 m .79347 .47386 L .80279 .48498 L p .204 .251 .689 r
F P
0 g
s
.76799 .42987 m .76458 .44662 L .74565 .4309 L p .399 .52 .864 r
F P
0 g
s
.74565 .4309 m .74785 .41367 L .76799 .42987 L p .399 .52 .864 r
F P
0 g
s
.67464 .37777 m .67319 .35925 L .70015 .37816 L p .448 .593 .904 r
F P
0 g
s
.67319 .35925 m .67464 .37777 L .64722 .35872 L p .457 .607 .911 r
F P
0 g
s
.73451 .56473 m .72185 .57499 L .73879 .57707 L p .722 .977 .92 r
F P
0 g
s
.73879 .57707 m .75013 .56616 L .73451 .56473 L p .722 .977 .92 r
F P
0 g
s
.77255 .54317 m .76138 .55487 L .77015 .5528 L p .708 .967 .723 r
F P
0 g
s
.77015 .5528 m .78006 .54049 L .77255 .54317 L p .708 .967 .723 r
F P
0 g
s
.53412 .30098 m .52711 .28164 L .55804 .30058 L p .47 .637 .929 r
F P
0 g
s
.52711 .28164 m .53412 .30098 L .50429 .28275 L p .472 .644 .932 r
F P
0 g
s
.5553 .61131 m .53858 .61699 L .58197 .63227 L p .655 .883 .982 r
F P
0 g
s
.58197 .63227 m .597 .62579 L .5553 .61131 L p .655 .883 .982 r
F P
0 g
s
.64722 .35872 m .64456 .33985 L .67319 .35925 L p .457 .607 .911 r
F P
0 g
s
.64456 .33985 m .64722 .35872 L .61843 .33936 L p .463 .618 .917 r
F P
0 g
s
.78525 .44477 m .78062 .461 L .76458 .44662 L p .368 .475 .838 r
F P
0 g
s
.76458 .44662 m .76799 .42987 L .78525 .44477 L p .368 .475 .838 r
F P
0 g
s
.61843 .33936 m .61456 .32018 L .64456 .33985 L p .463 .618 .917 r
F P
0 g
s
.61456 .32018 m .61843 .33936 L .5886 .31991 L p .468 .627 .922 r
F P
0 g
s
.50429 .28275 m .49618 .26334 L .52711 .28164 L p .472 .644 .932 r
F P
0 g
s
.57184 .60523 m .5553 .61131 L .597 .62579 L p .658 .887 .981 r
F P
0 g
s
.597 .62579 m .61189 .61892 L .57184 .60523 L p .658 .887 .981 r
F P
0 g
s
.79932 .45816 m .79347 .47386 L .78062 .461 L p .319 .407 .796 r
F P
0 g
s
.78062 .461 m .78525 .44477 L .79932 .45816 L p .319 .407 .796 r
F P
0 g
s
.68438 .57879 m .67011 .58759 L .69627 .59435 L p .693 .934 .966 r
F P
0 g
s
.69627 .59435 m .70911 .58486 L .68438 .57879 L p .693 .934 .966 r
F P
0 g
s
.79963 .51465 m .78988 .52778 L .79128 .52199 L p 0 0 0 r
F P
0 g
s
.79128 .52199 m .79978 .50828 L .79963 .51465 L p 0 0 0 r
F P
0 g
s
.80819 .49414 m .79978 .50828 L .7956 .49968 L p .034 .017 .503 r
F P
0 g
s
.7956 .49968 m .80279 .48498 L .80819 .49414 L p .034 .017 .503 r
F P
0 g
s
.5886 .31991 m .58353 .30047 L .61456 .32018 L p .468 .627 .922 r
F P
0 g
s
.58353 .30047 m .5886 .31991 L .55804 .30058 L p .472 .635 .926 r
F P
0 g
s
.74709 .55406 m .73451 .56473 L .75013 .56616 L p .726 .983 .905 r
F P
0 g
s
.75013 .56616 m .76138 .55487 L .74709 .55406 L p .726 .983 .905 r
F P
0 g
s
.78364 .53106 m .77255 .54317 L .78006 .54049 L p .684 .939 .65 r
F P
0 g
s
.78006 .54049 m .78988 .52778 L .78364 .53106 L p .684 .939 .65 r
F P
0 g
s
.58822 .59875 m .57184 .60523 L .61189 .61892 L p .661 .891 .98 r
F P
0 g
s
.61189 .61892 m .62663 .61166 L .58822 .59875 L p .661 .891 .98 r
F P
0 g
s
.55804 .30058 m .55179 .28095 L .58353 .30047 L p .472 .635 .926 r
F P
0 g
s
.55179 .28095 m .55804 .30058 L .52711 .28164 L p .475 .642 .93 r
F P
0 g
s
.80986 .46983 m .80279 .48498 L .79347 .47386 L p .239 .296 .721 r
F P
0 g
s
.79347 .47386 m .79932 .45816 L .80986 .46983 L p .239 .296 .721 r
F P
0 g
s
.74985 .39598 m .74785 .41367 L .72514 .39637 L p .429 .562 .886 r
F P
0 g
s
.72514 .39637 m .7259 .37821 L .74985 .39598 L p .429 .562 .886 r
F P
0 g
s
.7259 .37821 m .72514 .39637 L .70015 .37816 L p .443 .583 .898 r
F P
0 g
s
.70015 .37816 m .69967 .35957 L .7259 .37821 L p .443 .583 .898 r
F P
0 g
s
.69967 .35957 m .70015 .37816 L .67319 .35925 L p .454 .6 .906 r
F P
0 g
s
.77123 .41267 m .76799 .42987 L .74785 .41367 L p .409 .533 .871 r
F P
0 g
s
.74785 .41367 m .74985 .39598 L .77123 .41267 L p .409 .533 .871 r
F P
0 g
s
.69855 .5696 m .68438 .57879 L .70911 .58486 L p .697 .94 .962 r
F P
0 g
s
.70911 .58486 m .72185 .57499 L .69855 .5696 L p .697 .94 .962 r
F P
0 g
s
.67319 .35925 m .67146 .34026 L .69967 .35957 L p .454 .6 .906 r
F P
0 g
s
.67146 .34026 m .67319 .35925 L .64456 .33985 L p .462 .613 .913 r
F P
0 g
s
.60445 .59188 m .58822 .59875 L .62663 .61166 L p .664 .895 .979 r
F P
0 g
s
.62663 .61166 m .64124 .60402 L .60445 .59188 L p .664 .895 .979 r
F P
0 g
s
.78973 .42808 m .78525 .44477 L .76799 .42987 L p .381 .492 .847 r
F P
0 g
s
.76799 .42987 m .77123 .41267 L .78973 .42808 L p .381 .492 .847 r
F P
0 g
s
.52711 .28164 m .51971 .26187 L .55179 .28095 L p .475 .642 .93 r
F P
0 g
s
.51971 .26187 m .52711 .28164 L .49618 .26334 L p .477 .648 .934 r
F P
0 g
s
.64456 .33985 m .64158 .32051 L .67146 .34026 L p .462 .613 .913 r
F P
0 g
s
.64158 .32051 m .64456 .33985 L .61456 .32018 L p .468 .623 .919 r
F P
0 g
s
.75958 .543 m .74709 .55406 L .76138 .55487 L p .728 .988 .886 r
F P
0 g
s
.76138 .55487 m .77255 .54317 L .75958 .543 L p .728 .988 .886 r
F P
0 g
s
.80928 .50111 m .79963 .51465 L .79978 .50828 L p 0 0 .11 r
F P
0 g
s
.79978 .50828 m .80819 .49414 L .80928 .50111 L p 0 0 .11 r
F P
0 g
s
.80504 .44201 m .79932 .45816 L .78525 .44477 L p .338 .432 .811 r
F P
0 g
s
.78525 .44477 m .78973 .42808 L .80504 .44201 L p .338 .432 .811 r
F P
0 g
s
.81651 .47957 m .80819 .49414 L .80279 .48498 L p .094 .097 .569 r
F P
0 g
s
.80279 .48498 m .80986 .46983 L .81651 .47957 L p .094 .097 .569 r
F P
0 g
s
.61456 .32018 m .61035 .30053 L .64158 .32051 L p .468 .623 .919 r
F P
0 g
s
.61035 .30053 m .61456 .32018 L .58353 .30047 L p .473 .632 .924 r
F P
0 g
s
.49618 .26334 m .48765 .2435 L .51971 .26187 L p .477 .648 .934 r
F P
0 g
s
.79466 .51855 m .78364 .53106 L .78988 .52778 L p .648 .894 .558 r
F P
0 g
s
.78988 .52778 m .79963 .51465 L .79466 .51855 L p .648 .894 .558 r
F P
0 g
s
.62053 .58462 m .60445 .59188 L .64124 .60402 L p .668 .899 .978 r
F P
0 g
s
.64124 .60402 m .65574 .596 L .62053 .58462 L p .668 .899 .978 r
F P
0 g
s
.71262 .56001 m .69855 .5696 L .72185 .57499 L p .702 .947 .957 r
F P
0 g
s
.72185 .57499 m .73451 .56473 L .71262 .56001 L p .702 .947 .957 r
F P
0 g
s
.58353 .30047 m .57809 .28056 L .61035 .30053 L p .473 .632 .924 r
F P
0 g
s
.57809 .28056 m .58353 .30047 L .55179 .28095 L p .477 .64 .928 r
F P
0 g
s
.81682 .45424 m .80986 .46983 L .79932 .45816 L p .268 .335 .748 r
F P
0 g
s
.79932 .45816 m .80504 .44201 L .81682 .45424 L p .268 .335 .748 r
F P
0 g
s
.772 .53154 m .75958 .543 L .77255 .54317 L p .729 .99 .86 r
F P
0 g
s
.77255 .54317 m .78364 .53106 L .772 .53154 L p .729 .99 .86 r
F P
0 g
s
.63648 .57696 m .62053 .58462 L .65574 .596 L p .671 .904 .977 r
F P
0 g
s
.65574 .596 m .67011 .58759 L .63648 .57696 L p .671 .904 .977 r
F P
0 g
s
.55179 .28095 m .54515 .26085 L .57809 .28056 L p .477 .64 .928 r
F P
0 g
s
.54515 .26085 m .55179 .28095 L .51971 .26187 L p .48 .647 .931 r
F P
0 g
s
.75164 .37781 m .74985 .39598 L .7259 .37821 L p .436 .571 .89 r
F P
0 g
s
.7259 .37821 m .72642 .35957 L .75164 .37781 L p .436 .571 .89 r
F P
0 g
s
.72642 .35957 m .7259 .37821 L .69967 .35957 L p .45 .59 .901 r
F P
0 g
s
.77429 .395 m .77123 .41267 L .74985 .39598 L p .418 .544 .876 r
F P
0 g
s
.74985 .39598 m .75164 .37781 L .77429 .395 L p .418 .544 .876 r
F P
0 g
s
.69967 .35957 m .69892 .3405 L .72642 .35957 L p .45 .59 .901 r
F P
0 g
s
.69892 .3405 m .69967 .35957 L .67146 .34026 L p .46 .606 .909 r
F P
0 g
s
.44749 .60506 m .42814 .60858 L .48727 .63165 L p .637 .86 .984 r
F P
0 g
s
.48727 .63165 m .50458 .62716 L .44749 .60506 L p .637 .86 .984 r
F P
0 g
s
.7266 .55003 m .71262 .56001 L .73451 .56473 L p .707 .954 .952 r
F P
0 g
s
.73451 .56473 m .74709 .55406 L .7266 .55003 L p .707 .954 .952 r
F P
0 g
s
.79405 .41093 m .78973 .42808 L .77123 .41267 L p .393 .508 .856 r
F P
0 g
s
.77123 .41267 m .77429 .395 L .79405 .41093 L p .393 .508 .856 r
F P
0 g
s
.67146 .34026 m .66944 .32079 L .69892 .3405 L p .46 .606 .909 r
F P
0 g
s
.66944 .32079 m .67146 .34026 L .64158 .32051 L p .467 .618 .915 r
F P
0 g
s
.81886 .48713 m .80928 .50111 L .80819 .49414 L p 0 0 .24 r
F P
0 g
s
.80819 .49414 m .81651 .47957 L .81886 .48713 L p 0 0 .24 r
F P
0 g
s
.8056 .50562 m .79466 .51855 L .79963 .51465 L p .596 .828 .444 r
F P
0 g
s
.79963 .51465 m .80928 .50111 L .8056 .50562 L p .596 .828 .444 r
F P
0 g
s
.51971 .26187 m .51189 .24166 L .54515 .26085 L p .48 .647 .931 r
F P
0 g
s
.51189 .24166 m .51971 .26187 L .48765 .2435 L p .482 .653 .935 r
F P
0 g
s
.46659 .60111 m .44749 .60506 L .50458 .62716 L p .639 .863 .984 r
F P
0 g
s
.50458 .62716 m .52168 .62228 L .46659 .60111 L p .639 .863 .984 r
F P
0 g
s
.82473 .46456 m .81651 .47957 L .80986 .46983 L p .145 .166 .623 r
F P
0 g
s
.80986 .46983 m .81682 .45424 L .82473 .46456 L p .145 .166 .623 r
F P
0 g
s
.64158 .32051 m .63829 .30069 L .66944 .32079 L p .467 .618 .915 r
F P
0 g
s
.63829 .30069 m .64158 .32051 L .61035 .30053 L p .473 .629 .921 r
F P
0 g
s
.81062 .4254 m .80504 .44201 L .78973 .42808 L p .355 .454 .824 r
F P
0 g
s
.78973 .42808 m .79405 .41093 L .81062 .4254 L p .355 .454 .824 r
F P
0 g
s
.6523 .5689 m .63648 .57696 L .67011 .58759 L p .675 .909 .976 r
F P
0 g
s
.67011 .58759 m .68438 .57879 L .6523 .5689 L p .675 .909 .976 r
F P
0 g
s
.48544 .59675 m .46659 .60111 L .52168 .62228 L p .641 .865 .983 r
F P
0 g
s
.52168 .62228 m .53858 .61699 L .48544 .59675 L p .641 .865 .983 r
F P
0 g
s
.61035 .30053 m .6058 .28041 L .63829 .30069 L p .473 .629 .921 r
F P
0 g
s
.6058 .28041 m .61035 .30053 L .57809 .28056 L p .478 .637 .925 r
F P
0 g
s
.48765 .2435 m .47869 .22324 L .51189 .24166 L p .482 .653 .935 r
F P
0 g
s
.78434 .51967 m .772 .53154 L .78364 .53106 L p .726 .989 .827 r
F P
0 g
s
.78364 .53106 m .79466 .51855 L .78434 .51967 L p .726 .989 .827 r
F P
0 g
s
.50406 .59197 m .48544 .59675 L .53858 .61699 L p .644 .868 .983 r
F P
0 g
s
.53858 .61699 m .5553 .61131 L .50406 .59197 L p .644 .868 .983 r
F P
0 g
s
.82367 .4382 m .81682 .45424 L .80504 .44201 L p .294 .369 .77 r
F P
0 g
s
.80504 .44201 m .81062 .4254 L .82367 .4382 L p .294 .369 .77 r
F P
0 g
s
.74049 .53965 m .7266 .55003 L .74709 .55406 L p .711 .961 .944 r
F P
0 g
s
.74709 .55406 m .75958 .543 L .74049 .53965 L p .711 .961 .944 r
F P
0 g
s
.57809 .28056 m .57229 .2602 L .6058 .28041 L p .478 .637 .925 r
F P
0 g
s
.57229 .2602 m .57809 .28056 L .54515 .26085 L p .482 .645 .929 r
F P
0 g
s
.668 .56045 m .6523 .5689 L .68438 .57879 L p .679 .914 .974 r
F P
0 g
s
.68438 .57879 m .69855 .5696 L .668 .56045 L p .679 .914 .974 r
F P
0 g
s
.52247 .58677 m .50406 .59197 L .5553 .61131 L p .647 .871 .983 r
F P
0 g
s
.5553 .61131 m .57184 .60523 L .52247 .58677 L p .647 .871 .983 r
F P
0 g
s
.82835 .47273 m .81886 .48713 L .81651 .47957 L p 0 0 .352 r
F P
0 g
s
.81651 .47957 m .82473 .46456 L .82835 .47273 L p 0 0 .352 r
F P
0 g
s
.80928 .50111 m .81886 .48713 L .81647 .49227 L p 0 0 0 r
F P
0 g
s
.81647 .49227 m .8056 .50562 L .80928 .50111 L p 0 0 0 r
F P
0 g
s
.75323 .35916 m .75164 .37781 L .72642 .35957 L p .443 .579 .894 r
F P
0 g
s
.72642 .35957 m .72671 .34045 L .75323 .35916 L p .443 .579 .894 r
F P
0 g
s
.72671 .34045 m .72642 .35957 L .69892 .3405 L p .456 .597 .904 r
F P
0 g
s
.77716 .37685 m .77429 .395 L .75164 .37781 L p .427 .555 .881 r
F P
0 g
s
.75164 .37781 m .75323 .35916 L .77716 .37685 L p .427 .555 .881 r
F P
0 g
s
.54515 .26085 m .53811 .2403 L .57229 .2602 L p .482 .645 .929 r
F P
0 g
s
.53811 .2403 m .54515 .26085 L .51189 .24166 L p .485 .651 .933 r
F P
0 g
s
.69892 .3405 m .6979 .32094 L .72671 .34045 L p .456 .597 .904 r
F P
0 g
s
.6979 .32094 m .69892 .3405 L .66944 .32079 L p .465 .612 .911 r
F P
0 g
s
.79821 .39331 m .79405 .41093 L .77429 .395 L p .404 .521 .863 r
F P
0 g
s
.77429 .395 m .77716 .37685 L .79821 .39331 L p .404 .521 .863 r
F P
0 g
s
.54068 .58117 m .52247 .58677 L .57184 .60523 L p .649 .874 .982 r
F P
0 g
s
.57184 .60523 m .58822 .59875 L .54068 .58117 L p .649 .874 .982 r
F P
0 g
s
.83285 .44911 m .82473 .46456 L .81682 .45424 L p .189 .224 .667 r
F P
0 g
s
.81682 .45424 m .82367 .4382 L .83285 .44911 L p .189 .224 .667 r
F P
0 g
s
.66944 .32079 m .66712 .30084 L .6979 .32094 L p .465 .612 .911 r
F P
0 g
s
.66712 .30084 m .66944 .32079 L .63829 .30069 L p .472 .624 .917 r
F P
0 g
s
.79661 .50738 m .78434 .51967 L .79466 .51855 L p .719 .982 .784 r
F P
0 g
s
.79466 .51855 m .8056 .50562 L .79661 .50738 L p .719 .982 .784 r
F P
0 g
s
.7543 .52886 m .74049 .53965 L .75958 .543 L p .716 .968 .935 r
F P
0 g
s
.75958 .543 m .772 .53154 L .7543 .52886 L p .716 .968 .935 r
F P
0 g
s
.81607 .40833 m .81062 .4254 L .79405 .41093 L p .37 .473 .835 r
F P
0 g
s
.79405 .41093 m .79821 .39331 L .81607 .40833 L p .37 .473 .835 r
F P
0 g
s
.6836 .5516 m .668 .56045 L .69855 .5696 L p .683 .919 .972 r
F P
0 g
s
.69855 .5696 m .71262 .56001 L .6836 .5516 L p .683 .919 .972 r
F P
0 g
s
.51189 .24166 m .50364 .221 L .53811 .2403 L p .485 .651 .933 r
F P
0 g
s
.50364 .221 m .51189 .24166 L .47869 .22324 L p .487 .657 .936 r
F P
0 g
s
.63829 .30069 m .63467 .28038 L .66712 .30084 L p .472 .624 .917 r
F P
0 g
s
.63467 .28038 m .63829 .30069 L .6058 .28041 L p .478 .633 .922 r
F P
0 g
s
.5587 .57515 m .54068 .58117 L .58822 .59875 L p .652 .878 .982 r
F P
0 g
s
.58822 .59875 m .60445 .59188 L .5587 .57515 L p .652 .878 .982 r
F P
0 g
s
.6058 .28041 m .60088 .2598 L .63467 .28038 L p .478 .633 .922 r
F P
0 g
s
.60088 .2598 m .6058 .28041 L .57229 .2602 L p .482 .642 .927 r
F P
0 g
s
.8304 .4217 m .82367 .4382 L .81062 .4254 L p .317 .399 .789 r
F P
0 g
s
.81062 .4254 m .81607 .40833 L .8304 .4217 L p .317 .399 .789 r
F P
0 g
s
.47869 .22324 m .46927 .20256 L .50364 .221 L p .487 .657 .936 r
F P
0 g
s
.82727 .47849 m .81647 .49227 L .81886 .48713 L p 0 0 0 r
F P
0 g
s
.81886 .48713 m .82835 .47273 L .82727 .47849 L p 0 0 0 r
F P
0 g
s
.57655 .56873 m .5587 .57515 L .60445 .59188 L p .655 .881 .982 r
F P
0 g
s
.60445 .59188 m .62053 .58462 L .57655 .56873 L p .655 .881 .982 r
F P
0 g
s
.83777 .45788 m .82835 .47273 L .82473 .46456 L p 0 0 .447 r
F P
0 g
s
.82473 .46456 m .83285 .44911 L .83777 .45788 L p 0 0 .447 r
F P
0 g
s
.69909 .54234 m .6836 .5516 L .71262 .56001 L p .687 .925 .97 r
F P
0 g
s
.71262 .56001 m .7266 .55003 L .69909 .54234 L p .687 .925 .97 r
F P
0 g
s
.57229 .2602 m .56609 .23935 L .60088 .2598 L p .482 .642 .927 r
F P
0 g
s
.56609 .23935 m .57229 .2602 L .53811 .2403 L p .486 .649 .93 r
F P
0 g
s
.76804 .51766 m .7543 .52886 L .772 .53154 L p .72 .975 .924 r
F P
0 g
s
.772 .53154 m .78434 .51967 L .76804 .51766 L p .72 .975 .924 r
F P
0 g
s
.80882 .49468 m .79661 .50738 L .8056 .50562 L p .705 .967 .728 r
F P
0 g
s
.8056 .50562 m .81647 .49227 L .80882 .49468 L p .705 .967 .728 r
F P
0 g
s
.77984 .35821 m .77716 .37685 L .75323 .35916 L p .435 .564 .886 r
F P
0 g
s
.75323 .35916 m .75458 .34001 L .77984 .35821 L p .435 .564 .886 r
F P
0 g
s
.75458 .34001 m .75323 .35916 L .72671 .34045 L p .45 .587 .898 r
F P
0 g
s
.72671 .34045 m .72674 .32083 L .75458 .34001 L p .45 .587 .898 r
F P
0 g
s
.72674 .32083 m .72671 .34045 L .6979 .32094 L p .461 .604 .907 r
F P
0 g
s
.84087 .4332 m .83285 .44911 L .82367 .4382 L p .227 .275 .704 r
F P
0 g
s
.82367 .4382 m .8304 .4217 L .84087 .4332 L p .227 .275 .704 r
F P
0 g
s
.80221 .3752 m .79821 .39331 L .77716 .37685 L p .414 .534 .869 r
F P
0 g
s
.77716 .37685 m .77984 .35821 L .80221 .3752 L p .414 .534 .869 r
F P
0 g
s
.59424 .56189 m .57655 .56873 L .62053 .58462 L p .658 .885 .981 r
F P
0 g
s
.62053 .58462 m .63648 .57696 L .59424 .56189 L p .658 .885 .981 r
F P
0 g
s
.6979 .32094 m .69661 .30088 L .72674 .32083 L p .461 .604 .907 r
F P
0 g
s
.69661 .30088 m .6979 .32094 L .66712 .30084 L p .47 .618 .914 r
F P
0 g
s
.53811 .2403 m .53066 .21929 L .56609 .23935 L p .486 .649 .93 r
F P
0 g
s
.53066 .21929 m .53811 .2403 L .50364 .221 L p .489 .656 .934 r
F P
0 g
s
.82137 .39078 m .81607 .40833 L .79821 .39331 L p .383 .491 .845 r
F P
0 g
s
.79821 .39331 m .80221 .3752 L .82137 .39078 L p .383 .491 .845 r
F P
0 g
s
.66712 .30084 m .66449 .28039 L .69661 .30088 L p .47 .618 .914 r
F P
0 g
s
.66449 .28039 m .66712 .30084 L .63467 .28038 L p .477 .629 .919 r
F P
0 g
s
.71448 .53268 m .69909 .54234 L .7266 .55003 L p .691 .931 .967 r
F P
0 g
s
.7266 .55003 m .74049 .53965 L .71448 .53268 L p .691 .931 .967 r
F P
0 g
s
.50364 .221 m .49495 .19989 L .53066 .21929 L p .489 .656 .934 r
F P
0 g
s
.49495 .19989 m .50364 .221 L .46927 .20256 L p .492 .662 .937 r
F P
0 g
s
.63467 .28038 m .63071 .25958 L .66449 .28039 L p .477 .629 .919 r
F P
0 g
s
.63071 .25958 m .63467 .28038 L .60088 .2598 L p .482 .638 .924 r
F P
0 g
s
.61178 .55465 m .59424 .56189 L .63648 .57696 L p .661 .888 .98 r
F P
0 g
s
.63648 .57696 m .6523 .5689 L .61178 .55465 L p .661 .888 .98 r
F P
0 g
s
.83799 .46427 m .82727 .47849 L .82835 .47273 L p 0 0 0 r
F P
0 g
s
.82835 .47273 m .83777 .45788 L .83799 .46427 L p 0 0 0 r
F P
0 g
s
.83701 .40474 m .8304 .4217 L .81607 .40833 L p .337 .425 .805 r
F P
0 g
s
.81607 .40833 m .82137 .39078 L .83701 .40474 L p .337 .425 .805 r
F P
0 g
s
.78171 .50606 m .76804 .51766 L .78434 .51967 L p .723 .981 .909 r
F P
0 g
s
.78434 .51967 m .79661 .50738 L .78171 .50606 L p .723 .981 .909 r
F P
0 g
s
.84709 .44259 m .83777 .45788 L .83285 .44911 L p .06 .045 .524 r
F P
0 g
s
.83285 .44911 m .84087 .4332 L .84709 .44259 L p .06 .045 .524 r
F P
0 g
s
.60088 .2598 m .5956 .23871 L .63071 .25958 L p .482 .638 .924 r
F P
0 g
s
.5956 .23871 m .60088 .2598 L .56609 .23935 L p .487 .646 .928 r
F P
0 g
s
.46927 .20256 m .45938 .18144 L .49495 .19989 L p .492 .662 .937 r
F P
0 g
s
.82096 .48155 m .80882 .49468 L .81647 .49227 L p .681 .939 .654 r
F P
0 g
s
.81647 .49227 m .82727 .47849 L .82096 .48155 L p .681 .939 .654 r
F P
0 g
s
.62917 .54701 m .61178 .55465 L .6523 .5689 L p .664 .892 .98 r
F P
0 g
s
.6523 .5689 m .668 .56045 L .62917 .54701 L p .664 .892 .98 r
F P
0 g
s
.72979 .52262 m .71448 .53268 L .74049 .53965 L p .695 .937 .964 r
F P
0 g
s
.74049 .53965 m .7543 .52886 L .72979 .52262 L p .695 .937 .964 r
F P
0 g
s
.84879 .41684 m .84087 .4332 L .8304 .4217 L p .26 .318 .734 r
F P
0 g
s
.8304 .4217 m .83701 .40474 L .84879 .41684 L p .26 .318 .734 r
F P
0 g
s
.56609 .23935 m .55949 .21803 L .5956 .23871 L p .487 .646 .928 r
F P
0 g
s
.55949 .21803 m .56609 .23935 L .53066 .21929 L p .49 .653 .932 r
F P
0 g
s
.78232 .33907 m .77984 .35821 L .75458 .34001 L p .442 .573 .89 r
F P
0 g
s
.75458 .34001 m .75571 .32037 L .78232 .33907 L p .442 .573 .89 r
F P
0 g
s
.75571 .32037 m .75458 .34001 L .72674 .32083 L p .456 .594 .901 r
F P
0 g
s
.72674 .32083 m .72651 .30071 L .75571 .32037 L p .456 .594 .901 r
F P
0 g
s
.72651 .30071 m .72674 .32083 L .69661 .30088 L p .467 .61 .909 r
F P
0 g
s
.80602 .35661 m .80221 .3752 L .77984 .35821 L p .423 .545 .875 r
F P
0 g
s
.77984 .35821 m .78232 .33907 L .80602 .35661 L p .423 .545 .875 r
F P
0 g
s
.37833 .57688 m .35661 .57929 L .42814 .60858 L p .629 .85 .984 r
F P
0 g
s
.42814 .60858 m .44749 .60506 L .37833 .57688 L p .629 .85 .984 r
F P
0 g
s
.69661 .30088 m .69502 .28032 L .72651 .30071 L p .467 .61 .909 r
F P
0 g
s
.69502 .28032 m .69661 .30088 L .66449 .28039 L p .475 .623 .916 r
F P
0 g
s
.39973 .57402 m .37833 .57688 L .44749 .60506 L p .631 .852 .984 r
F P
0 g
s
.44749 .60506 m .46659 .60111 L .39973 .57402 L p .631 .852 .984 r
F P
0 g
s
.79531 .49403 m .78171 .50606 L .79661 .50738 L p .726 .986 .891 r
F P
0 g
s
.79661 .50738 m .80882 .49468 L .79531 .49403 L p .726 .986 .891 r
F P
0 g
s
.53066 .21929 m .52277 .19781 L .55949 .21803 L p .49 .653 .932 r
F P
0 g
s
.52277 .19781 m .53066 .21929 L .49495 .19989 L p .494 .66 .935 r
F P
0 g
s
.82652 .37275 m .82137 .39078 L .80221 .3752 L p .395 .506 .853 r
F P
0 g
s
.80221 .3752 m .80602 .35661 L .82652 .37275 L p .395 .506 .853 r
F P
0 g
s
.64644 .53895 m .62917 .54701 L .668 .56045 L p .667 .897 .979 r
F P
0 g
s
.668 .56045 m .6836 .5516 L .64644 .53895 L p .667 .897 .979 r
F P
0 g
s
.42082 .57071 m .39973 .57402 L .46659 .60111 L p .633 .854 .984 r
F P
0 g
s
.46659 .60111 m .48544 .59675 L .42082 .57071 L p .633 .854 .984 r
F P
0 g
s
.66449 .28039 m .66154 .25943 L .69502 .28032 L p .475 .623 .916 r
F P
0 g
s
.66154 .25943 m .66449 .28039 L .63071 .25958 L p .481 .634 .921 r
F P
0 g
s
.84864 .44962 m .83799 .46427 L .83777 .45788 L p 0 0 .13 r
F P
0 g
s
.83777 .45788 m .84709 .44259 L .84864 .44962 L p 0 0 .13 r
F P
0 g
s
.74502 .51214 m .72979 .52262 L .7543 .52886 L p .7 .944 .959 r
F P
0 g
s
.7543 .52886 m .76804 .51766 L .74502 .51214 L p .7 .944 .959 r
F P
0 g
s
.44163 .56695 m .42082 .57071 L .48544 .59675 L p .635 .856 .983 r
F P
0 g
s
.48544 .59675 m .50406 .59197 L .44163 .56695 L p .635 .856 .983 r
F P
0 g
s
.83303 .46799 m .82096 .48155 L .82727 .47849 L p .643 .893 .56 r
F P
0 g
s
.82727 .47849 m .83799 .46427 L .83303 .46799 L p .643 .893 .56 r
F P
0 g
s
.85633 .42685 m .84709 .44259 L .84087 .4332 L p .119 .123 .587 r
F P
0 g
s
.84087 .4332 m .84879 .41684 L .85633 .42685 L p .119 .123 .587 r
F P
0 g
s
.8435 .38729 m .83701 .40474 L .82137 .39078 L p .354 .448 .819 r
F P
0 g
s
.82137 .39078 m .82652 .37275 L .8435 .38729 L p .354 .448 .819 r
F P
0 g
s
.49495 .19989 m .4858 .17833 L .52277 .19781 L p .494 .66 .935 r
F P
0 g
s
.4858 .17833 m .49495 .19989 L .45938 .18144 L p .497 .666 .938 r
F P
0 g
s
.63071 .25958 m .62639 .23828 L .66154 .25943 L p .481 .634 .921 r
F P
0 g
s
.62639 .23828 m .63071 .25958 L .5956 .23871 L p .487 .642 .925 r
F P
0 g
s
.46217 .56276 m .44163 .56695 L .50406 .59197 L p .637 .859 .983 r
F P
0 g
s
.50406 .59197 m .52247 .58677 L .46217 .56276 L p .637 .859 .983 r
F P
0 g
s
.66358 .53049 m .64644 .53895 L .6836 .5516 L p .67 .901 .978 r
F P
0 g
s
.6836 .5516 m .69909 .54234 L .66358 .53049 L p .67 .901 .978 r
F P
0 g
s
.45938 .18144 m .44901 .15988 L .4858 .17833 L p .497 .666 .938 r
F P
0 g
s
.5956 .23871 m .58992 .21712 L .62639 .23828 L p .487 .642 .925 r
F P
0 g
s
.58992 .21712 m .5956 .23871 L .55949 .21803 L p .491 .65 .929 r
F P
0 g
s
.48247 .55814 m .46217 .56276 L .52247 .58677 L p .639 .861 .983 r
F P
0 g
s
.52247 .58677 m .54068 .58117 L .48247 .55814 L p .639 .861 .983 r
F P
0 g
s
.85661 .4 m .84879 .41684 L .83701 .40474 L p .288 .355 .758 r
F P
0 g
s
.83701 .40474 m .8435 .38729 L .85661 .4 L p .288 .355 .758 r
F P
0 g
s
.80885 .48158 m .79531 .49403 L .80882 .49468 L p .726 .989 .866 r
F P
0 g
s
.80882 .49468 m .82096 .48155 L .80885 .48158 L p .726 .989 .866 r
F P
0 g
s
.76016 .50125 m .74502 .51214 L .76804 .51766 L p .704 .951 .954 r
F P
0 g
s
.76804 .51766 m .78171 .50606 L .76016 .50125 L p .704 .951 .954 r
F P
0 g
s
.50254 .55308 m .48247 .55814 L .54068 .58117 L p .642 .864 .983 r
F P
0 g
s
.54068 .58117 m .5587 .57515 L .50254 .55308 L p .642 .864 .983 r
F P
0 g
s
.55949 .21803 m .55248 .19622 L .58992 .21712 L p .491 .65 .929 r
F P
0 g
s
.55248 .19622 m .55949 .21803 L .52277 .19781 L p .495 .657 .933 r
F P
0 g
s
.78459 .31944 m .78232 .33907 L .75571 .32037 L p .449 .582 .894 r
F P
0 g
s
.75571 .32037 m .7566 .30021 L .78459 .31944 L p .449 .582 .894 r
F P
0 g
s
.7566 .30021 m .75571 .32037 L .72651 .30071 L p .462 .601 .904 r
F P
0 g
s
.80966 .33751 m .80602 .35661 L .78232 .33907 L p .431 .556 .881 r
F P
0 g
s
.78232 .33907 m .78459 .31944 L .80966 .33751 L p .431 .556 .881 r
F P
0 g
s
.72651 .30071 m .72601 .28007 L .7566 .30021 L p .462 .601 .904 r
F P
0 g
s
.72601 .28007 m .72651 .30071 L .69502 .28032 L p .472 .616 .911 r
F P
0 g
s
.85922 .43451 m .84864 .44962 L .84709 .44259 L p 0 0 .26 r
F P
0 g
s
.84709 .44259 m .85633 .42685 L .85922 .43451 L p 0 0 .26 r
F P
0 g
s
.68061 .52161 m .66358 .53049 L .69909 .54234 L p .674 .906 .977 r
F P
0 g
s
.69909 .54234 m .71448 .53268 L .68061 .52161 L p .674 .906 .977 r
F P
0 g
s
.83152 .35423 m .82652 .37275 L .80602 .35661 L p .407 .521 .861 r
F P
0 g
s
.80602 .35661 m .80966 .33751 L .83152 .35423 L p .407 .521 .861 r
F P
0 g
s
.84504 .45399 m .83303 .46799 L .83799 .46427 L p .589 .826 .445 r
F P
0 g
s
.83799 .46427 m .84864 .44962 L .84504 .45399 L p .589 .826 .445 r
F P
0 g
s
.69502 .28032 m .69312 .25924 L .72601 .28007 L p .472 .616 .911 r
F P
0 g
s
.69312 .25924 m .69502 .28032 L .66154 .25943 L p .479 .628 .917 r
F P
0 g
s
.52239 .5476 m .50254 .55308 L .5587 .57515 L p .644 .866 .983 r
F P
0 g
s
.5587 .57515 m .57655 .56873 L .52239 .5476 L p .644 .866 .983 r
F P
0 g
s
.52277 .19781 m .51443 .17585 L .55248 .19622 L p .495 .657 .933 r
F P
0 g
s
.51443 .17585 m .52277 .19781 L .4858 .17833 L p .498 .663 .936 r
F P
0 g
s
.86549 .41064 m .85633 .42685 L .84879 .41684 L p .168 .189 .639 r
F P
0 g
s
.84879 .41684 m .85661 .4 L .86549 .41064 L p .168 .189 .639 r
F P
0 g
s
.66154 .25943 m .65824 .23796 L .69312 .25924 L p .479 .628 .917 r
F P
0 g
s
.65824 .23796 m .66154 .25943 L .62639 .23828 L p .486 .638 .922 r
F P
0 g
s
.84985 .36937 m .8435 .38729 L .82652 .37275 L p .37 .469 .831 r
F P
0 g
s
.82652 .37275 m .83152 .35423 L .84985 .36937 L p .37 .469 .831 r
F P
0 g
s
.54204 .5417 m .52239 .5476 L .57655 .56873 L p .646 .869 .982 r
F P
0 g
s
.57655 .56873 m .59424 .56189 L .54204 .5417 L p .646 .869 .982 r
F P
0 g
s
.82232 .46871 m .80885 .48158 L .82096 .48155 L p .723 .989 .834 r
F P
0 g
s
.82096 .48155 m .83303 .46799 L .82232 .46871 L p .723 .989 .834 r
F P
0 g
s
.4858 .17833 m .47618 .15631 L .51443 .17585 L p .498 .663 .936 r
F P
0 g
s
.47618 .15631 m .4858 .17833 L .44901 .15988 L p .501 .669 .939 r
F P
0 g
s
.77524 .48994 m .76016 .50125 L .78171 .50606 L p .709 .958 .947 r
F P
0 g
s
.78171 .50606 m .79531 .49403 L .77524 .48994 L p .709 .958 .947 r
F P
0 g
s
.62639 .23828 m .6217 .21647 L .65824 .23796 L p .486 .638 .922 r
F P
0 g
s
.6217 .21647 m .62639 .23828 L .58992 .21712 L p .491 .647 .927 r
F P
0 g
s
.69754 .51232 m .68061 .52161 L .71448 .53268 L p .677 .911 .975 r
F P
0 g
s
.71448 .53268 m .72979 .52262 L .69754 .51232 L p .677 .911 .975 r
F P
0 g
s
.86432 .38269 m .85661 .4 L .8435 .38729 L p .312 .387 .779 r
F P
0 g
s
.8435 .38729 m .84985 .36937 L .86432 .38269 L p .312 .387 .779 r
F P
0 g
s
.5615 .53536 m .54204 .5417 L .59424 .56189 L p .649 .872 .982 r
F P
0 g
s
.59424 .56189 m .61178 .55465 L .5615 .53536 L p .649 .872 .982 r
F P
0 g
s
.44901 .15988 m .43814 .13789 L .47618 .15631 L p .501 .669 .939 r
F P
0 g
s
.58992 .21712 m .58384 .19503 L .6217 .21647 L p .491 .647 .927 r
F P
0 g
s
.58384 .19503 m .58992 .21712 L .55248 .19622 L p .495 .654 .93 r
F P
0 g
s
.86973 .41895 m .85922 .43451 L .85633 .42685 L p 0 0 .371 r
F P
0 g
s
.85633 .42685 m .86549 .41064 L .86973 .41895 L p 0 0 .371 r
F P
0 g
s
.857 .43955 m .84504 .45399 L .84864 .44962 L p 0 0 0 r
F P
0 g
s
.84864 .44962 m .85922 .43451 L .857 .43955 L p 0 0 0 r
F P
0 g
s
.55248 .19622 m .54502 .17392 L .58384 .19503 L p .495 .654 .93 r
F P
0 g
s
.54502 .17392 m .55248 .19622 L .51443 .17585 L p .499 .661 .934 r
F P
0 g
s
.58078 .52861 m .5615 .53536 L .61178 .55465 L p .651 .875 .982 r
F P
0 g
s
.61178 .55465 m .62917 .54701 L .58078 .52861 L p .651 .875 .982 r
F P
0 g
s
.71436 .50262 m .69754 .51232 L .72979 .52262 L p .681 .916 .973 r
F P
0 g
s
.72979 .52262 m .74502 .51214 L .71436 .50262 L p .681 .916 .973 r
F P
0 g
s
.87456 .39396 m .86549 .41064 L .85661 .4 L p .21 .246 .681 r
F P
0 g
s
.85661 .4 m .86432 .38269 L .87456 .39396 L p .21 .246 .681 r
F P
0 g
s
.79025 .47821 m .77524 .48994 L .79531 .49403 L p .713 .965 .939 r
F P
0 g
s
.79531 .49403 m .80885 .48158 L .79025 .47821 L p .713 .965 .939 r
F P
0 g
s
.83574 .4554 m .82232 .46871 L .83303 .46799 L p .716 .983 .792 r
F P
0 g
s
.83303 .46799 m .84504 .45399 L .83574 .4554 L p .716 .983 .792 r
F P
0 g
s
.51443 .17585 m .50563 .15342 L .54502 .17392 L p .499 .661 .934 r
F P
0 g
s
.50563 .15342 m .51443 .17585 L .47618 .15631 L p .502 .667 .937 r
F P
0 g
s
.5999 .52144 m .58078 .52861 L .62917 .54701 L p .654 .879 .982 r
F P
0 g
s
.62917 .54701 m .64644 .53895 L .5999 .52144 L p .654 .879 .982 r
F P
0 g
s
.73111 .4925 m .71436 .50262 L .74502 .51214 L p .685 .922 .971 r
F P
0 g
s
.74502 .51214 m .76016 .50125 L .73111 .4925 L p .685 .922 .971 r
F P
0 g
s
.47618 .15631 m .46606 .13383 L .50563 .15342 L p .502 .667 .937 r
F P
0 g
s
.46606 .13383 m .47618 .15631 L .43814 .13789 L p .506 .673 .939 r
F P
0 g
s
.86889 .42467 m .857 .43955 L .85922 .43451 L p 0 0 0 r
F P
0 g
s
.85922 .43451 m .86973 .41895 L .86889 .42467 L p 0 0 0 r
F P
0 g
s
.88017 .40293 m .86973 .41895 L .86549 .41064 L p .016 0 .464 r
F P
0 g
s
.86549 .41064 m .87456 .39396 L .88017 .40293 L p .016 0 .464 r
F P
0 g
s
.8052 .46606 m .79025 .47821 L .80885 .48158 L p .717 .972 .928 r
F P
0 g
s
.80885 .48158 m .82232 .46871 L .8052 .46606 L p .717 .972 .928 r
F P
0 g
s
.61888 .51384 m .5999 .52144 L .64644 .53895 L p .656 .882 .981 r
F P
0 g
s
.64644 .53895 m .66358 .53049 L .61888 .51384 L p .656 .882 .981 r
F P
0 g
s
.43814 .13789 m .42675 .11546 L .46606 .13383 L p .506 .673 .939 r
F P
0 g
s
.84911 .44166 m .83574 .4554 L .84504 .45399 L p .702 .968 .736 r
F P
0 g
s
.84504 .45399 m .857 .43955 L .84911 .44166 L p .702 .968 .736 r
F P
0 g
s
.74776 .48196 m .73111 .4925 L .76016 .50125 L p .689 .928 .969 r
F P
0 g
s
.76016 .50125 m .77524 .48994 L .74776 .48196 L p .689 .928 .969 r
F P
0 g
s
.63771 .50583 m .61888 .51384 L .66358 .53049 L p .659 .886 .981 r
F P
0 g
s
.66358 .53049 m .68061 .52161 L .63771 .50583 L p .659 .886 .981 r
F P
0 g
s
.31884 .53988 m .29474 .54148 L .37833 .57688 L p .624 .843 .984 r
F P
0 g
s
.37833 .57688 m .39973 .57402 L .31884 .53988 L p .624 .843 .984 r
F P
0 g
s
.35661 .57929 m .37833 .57688 L .29474 .54148 L p .622 .841 .984 r
F P
0 g
s
.29474 .54148 m .27022 .54257 L .35661 .57929 L p .622 .841 .984 r
F P
0 g
s
.34257 .5378 m .31884 .53988 L .39973 .57402 L p .626 .844 .983 r
F P
0 g
s
.39973 .57402 m .42082 .57071 L .34257 .5378 L p .626 .844 .983 r
F P
0 g
s
.36593 .53524 m .34257 .5378 L .42082 .57071 L p .628 .846 .983 r
F P
0 g
s
.42082 .57071 m .44163 .56695 L .36593 .53524 L p .628 .846 .983 r
F P
0 g
s
.82009 .45348 m .8052 .46606 L .82232 .46871 L p .72 .979 .914 r
F P
0 g
s
.82232 .46871 m .83574 .4554 L .82009 .45348 L p .72 .979 .914 r
F P
0 g
s
.88072 .40933 m .86889 .42467 L .86973 .41895 L p 0 0 0 r
F P
0 g
s
.86973 .41895 m .88017 .40293 L .88072 .40933 L p 0 0 0 r
F P
0 g
s
.38896 .53221 m .36593 .53524 L .44163 .56695 L p .629 .848 .983 r
F P
0 g
s
.44163 .56695 m .46217 .56276 L .38896 .53221 L p .629 .848 .983 r
F P
0 g
s
.65642 .49739 m .63771 .50583 L .68061 .52161 L p .662 .89 .98 r
F P
0 g
s
.68061 .52161 m .69754 .51232 L .65642 .49739 L p .662 .89 .98 r
F P
0 g
s
.41168 .52872 m .38896 .53221 L .46217 .56276 L p .631 .85 .983 r
F P
0 g
s
.46217 .56276 m .48247 .55814 L .41168 .52872 L p .631 .85 .983 r
F P
0 g
s
.86242 .42747 m .84911 .44166 L .857 .43955 L p .678 .941 .663 r
F P
0 g
s
.857 .43955 m .86889 .42467 L .86242 .42747 L p .678 .941 .663 r
F P
0 g
s
.76435 .471 m .74776 .48196 L .77524 .48994 L p .693 .934 .965 r
F P
0 g
s
.77524 .48994 m .79025 .47821 L .76435 .471 L p .693 .934 .965 r
F P
0 g
s
.4341 .52476 m .41168 .52872 L .48247 .55814 L p .633 .852 .983 r
F P
0 g
s
.48247 .55814 m .50254 .55308 L .4341 .52476 L p .633 .852 .983 r
F P
0 g
s
.45625 .52036 m .4341 .52476 L .50254 .55308 L p .635 .855 .983 r
F P
0 g
s
.50254 .55308 m .52239 .5476 L .45625 .52036 L p .635 .855 .983 r
F P
0 g
s
.67501 .48853 m .65642 .49739 L .69754 .51232 L p .665 .894 .979 r
F P
0 g
s
.69754 .51232 m .71436 .50262 L .67501 .48853 L p .665 .894 .979 r
F P
0 g
s
.83493 .44046 m .82009 .45348 L .83574 .4554 L p .722 .985 .896 r
F P
0 g
s
.83574 .4554 m .84911 .44166 L .83493 .44046 L p .722 .985 .896 r
F P
0 g
s
.47814 .5155 m .45625 .52036 L .52239 .5476 L p .637 .857 .983 r
F P
0 g
s
.52239 .5476 m .54204 .5417 L .47814 .5155 L p .637 .857 .983 r
F P
0 g
s
.78086 .45961 m .76435 .471 L .79025 .47821 L p .697 .941 .962 r
F P
0 g
s
.79025 .47821 m .8052 .46606 L .78086 .45961 L p .697 .941 .962 r
F P
0 g
s
.4998 .5102 m .47814 .5155 L .54204 .5417 L p .639 .859 .983 r
F P
0 g
s
.54204 .5417 m .5615 .53536 L .4998 .5102 L p .639 .859 .983 r
F P
0 g
s
.87568 .41283 m .86242 .42747 L .86889 .42467 L p .64 .896 .569 r
F P
0 g
s
.86889 .42467 m .88072 .40933 L .87568 .41283 L p .64 .896 .569 r
F P
0 g
s
.69349 .47925 m .67501 .48853 L .71436 .50262 L p .668 .899 .978 r
F P
0 g
s
.71436 .50262 m .73111 .4925 L .69349 .47925 L p .668 .899 .978 r
F P
0 g
s
.52123 .50446 m .4998 .5102 L .5615 .53536 L p .641 .862 .983 r
F P
0 g
s
.5615 .53536 m .58078 .52861 L .52123 .50446 L p .641 .862 .983 r
F P
0 g
s
.84972 .427 m .83493 .44046 L .84911 .44166 L p .723 .988 .873 r
F P
0 g
s
.84911 .44166 m .86242 .42747 L .84972 .427 L p .723 .988 .873 r
F P
0 g
s
.79732 .44779 m .78086 .45961 L .8052 .46606 L p .701 .948 .957 r
F P
0 g
s
.8052 .46606 m .82009 .45348 L .79732 .44779 L p .701 .948 .957 r
F P
0 g
s
.54246 .49827 m .52123 .50446 L .58078 .52861 L p .643 .865 .983 r
F P
0 g
s
.58078 .52861 m .5999 .52144 L .54246 .49827 L p .643 .865 .983 r
F P
0 g
s
.71187 .46954 m .69349 .47925 L .73111 .4925 L p .671 .903 .977 r
F P
0 g
s
.73111 .4925 m .74776 .48196 L .71187 .46954 L p .671 .903 .977 r
F P
0 g
s
.56349 .49165 m .54246 .49827 L .5999 .52144 L p .645 .867 .982 r
F P
0 g
s
.5999 .52144 m .61888 .51384 L .56349 .49165 L p .645 .867 .982 r
F P
0 g
s
.73016 .4594 m .71187 .46954 L .74776 .48196 L p .675 .908 .976 r
F P
0 g
s
.74776 .48196 m .76435 .471 L .73016 .4594 L p .675 .908 .976 r
F P
0 g
s
.81372 .43554 m .79732 .44779 L .82009 .45348 L p .705 .955 .95 r
F P
0 g
s
.82009 .45348 m .83493 .44046 L .81372 .43554 L p .705 .955 .95 r
F P
0 g
s
.86446 .4131 m .84972 .427 L .86242 .42747 L p .72 .988 .842 r
F P
0 g
s
.86242 .42747 m .87568 .41283 L .86446 .4131 L p .72 .988 .842 r
F P
0 g
s
.58436 .48459 m .56349 .49165 L .61888 .51384 L p .648 .87 .982 r
F P
0 g
s
.61888 .51384 m .63771 .50583 L .58436 .48459 L p .648 .87 .982 r
F P
0 g
s
.60505 .4771 m .58436 .48459 L .63771 .50583 L p .65 .873 .982 r
F P
0 g
s
.63771 .50583 m .65642 .49739 L .60505 .4771 L p .65 .873 .982 r
F P
0 g
s
.74837 .44884 m .73016 .4594 L .76435 .471 L p .678 .913 .975 r
F P
0 g
s
.76435 .471 m .78086 .45961 L .74837 .44884 L p .678 .913 .975 r
F P
0 g
s
.83006 .42285 m .81372 .43554 L .83493 .44046 L p .709 .962 .943 r
F P
0 g
s
.83493 .44046 m .84972 .427 L .83006 .42285 L p .709 .962 .943 r
F P
0 g
s
.6256 .46917 m .60505 .4771 L .65642 .49739 L p .652 .876 .982 r
F P
0 g
s
.65642 .49739 m .67501 .48853 L .6256 .46917 L p .652 .876 .982 r
F P
0 g
s
.7665 .43784 m .74837 .44884 L .78086 .45961 L p .682 .919 .973 r
F P
0 g
s
.78086 .45961 m .79732 .44779 L .7665 .43784 L p .682 .919 .973 r
F P
0 g
s
.64601 .46081 m .6256 .46917 L .67501 .48853 L p .655 .88 .981 r
F P
0 g
s
.67501 .48853 m .69349 .47925 L .64601 .46081 L p .655 .88 .981 r
F P
0 g
s
.84636 .40972 m .83006 .42285 L .84972 .427 L p .713 .97 .933 r
F P
0 g
s
.84972 .427 m .86446 .4131 L .84636 .40972 L p .713 .97 .933 r
F P
0 g
s
.27431 .49551 m .2479 .49666 L .34257 .5378 L p .621 .838 .983 r
F P
0 g
s
.34257 .5378 m .36593 .53524 L .27431 .49551 L p .621 .838 .983 r
F P
0 g
s
.31884 .53988 m .34257 .5378 L .2479 .49666 L p .62 .837 .983 r
F P
0 g
s
.30028 .49385 m .27431 .49551 L .36593 .53524 L p .623 .84 .983 r
F P
0 g
s
.36593 .53524 m .38896 .53221 L .30028 .49385 L p .623 .84 .983 r
F P
0 g
s
.2479 .49666 m .22103 .49728 L .31884 .53988 L p .62 .837 .983 r
F P
0 g
s
.29474 .54148 m .31884 .53988 L .22103 .49728 L p .618 .835 .983 r
F P
0 g
s
.32585 .49168 m .30028 .49385 L .38896 .53221 L p .624 .841 .983 r
F P
0 g
s
.38896 .53221 m .41168 .52872 L .32585 .49168 L p .624 .841 .983 r
F P
0 g
s
.22103 .49728 m .19367 .49736 L .29474 .54148 L p .618 .835 .983 r
F P
0 g
s
.27022 .54257 m .29474 .54148 L .19367 .49736 L p .616 .834 .983 r
F P
0 g
s
.35104 .48902 m .32585 .49168 L .41168 .52872 L p .626 .843 .983 r
F P
0 g
s
.41168 .52872 m .4341 .52476 L .35104 .48902 L p .626 .843 .983 r
F P
0 g
s
.19367 .49736 m .16578 .49689 L .27022 .54257 L p .616 .834 .983 r
F P
0 g
s
.37588 .48586 m .35104 .48902 L .4341 .52476 L p .628 .845 .983 r
F P
0 g
s
.4341 .52476 m .45625 .52036 L .37588 .48586 L p .628 .845 .983 r
F P
0 g
s
.6663 .45201 m .64601 .46081 L .69349 .47925 L p .657 .883 .981 r
F P
0 g
s
.69349 .47925 m .71187 .46954 L .6663 .45201 L p .657 .883 .981 r
F P
0 g
s
.78457 .42641 m .7665 .43784 L .79732 .44779 L p .685 .925 .97 r
F P
0 g
s
.79732 .44779 m .81372 .43554 L .78457 .42641 L p .685 .925 .97 r
F P
0 g
s
.40039 .48222 m .37588 .48586 L .45625 .52036 L p .629 .847 .983 r
F P
0 g
s
.45625 .52036 m .47814 .5155 L .40039 .48222 L p .629 .847 .983 r
F P
0 g
s
.4246 .4781 m .40039 .48222 L .47814 .5155 L p .631 .849 .983 r
F P
0 g
s
.47814 .5155 m .4998 .5102 L .4246 .4781 L p .631 .849 .983 r
F P
0 g
s
.44852 .47352 m .4246 .4781 L .4998 .5102 L p .633 .851 .983 r
F P
0 g
s
.4998 .5102 m .52123 .50446 L .44852 .47352 L p .633 .851 .983 r
F P
0 g
s
.68647 .44278 m .6663 .45201 L .71187 .46954 L p .66 .887 .98 r
F P
0 g
s
.71187 .46954 m .73016 .4594 L .68647 .44278 L p .66 .887 .98 r
F P
0 g
s
.47217 .46847 m .44852 .47352 L .52123 .50446 L p .635 .853 .983 r
F P
0 g
s
.52123 .50446 m .54246 .49827 L .47217 .46847 L p .635 .853 .983 r
F P
0 g
s
.80257 .41454 m .78457 .42641 L .81372 .43554 L p .689 .931 .967 r
F P
0 g
s
.81372 .43554 m .83006 .42285 L .80257 .41454 L p .689 .931 .967 r
F P
0 g
s
.49558 .46295 m .47217 .46847 L .54246 .49827 L p .636 .855 .983 r
F P
0 g
s
.54246 .49827 m .56349 .49165 L .49558 .46295 L p .636 .855 .983 r
F P
0 g
s
.70653 .43311 m .68647 .44278 L .73016 .4594 L p .663 .891 .98 r
F P
0 g
s
.73016 .4594 m .74837 .44884 L .70653 .43311 L p .663 .891 .98 r
F P
0 g
s
.51875 .45698 m .49558 .46295 L .56349 .49165 L p .638 .857 .983 r
F P
0 g
s
.56349 .49165 m .58436 .48459 L .51875 .45698 L p .638 .857 .983 r
F P
0 g
s
.82053 .40222 m .80257 .41454 L .83006 .42285 L p .693 .938 .964 r
F P
0 g
s
.83006 .42285 m .84636 .40972 L .82053 .40222 L p .693 .938 .964 r
F P
0 g
s
.54172 .45055 m .51875 .45698 L .58436 .48459 L p .64 .86 .983 r
F P
0 g
s
.58436 .48459 m .60505 .4771 L .54172 .45055 L p .64 .86 .983 r
F P
0 g
s
.7265 .423 m .70653 .43311 L .74837 .44884 L p .666 .896 .979 r
F P
0 g
s
.74837 .44884 m .7665 .43784 L .7265 .423 L p .666 .896 .979 r
F P
0 g
s
.56449 .44367 m .54172 .45055 L .60505 .4771 L p .642 .862 .983 r
F P
0 g
s
.60505 .4771 m .6256 .46917 L .56449 .44367 L p .642 .862 .983 r
F P
0 g
s
.74639 .41245 m .7265 .423 L .7665 .43784 L p .669 .9 .978 r
F P
0 g
s
.7665 .43784 m .78457 .42641 L .74639 .41245 L p .669 .9 .978 r
F P
0 g
s
.58708 .43634 m .56449 .44367 L .6256 .46917 L p .644 .865 .982 r
F P
0 g
s
.6256 .46917 m .64601 .46081 L .58708 .43634 L p .644 .865 .982 r
F P
0 g
s
.60951 .42856 m .58708 .43634 L .64601 .46081 L p .646 .868 .982 r
F P
0 g
s
.64601 .46081 m .6663 .45201 L .60951 .42856 L p .646 .868 .982 r
F P
0 g
s
.7662 .40146 m .74639 .41245 L .78457 .42641 L p .672 .905 .977 r
F P
0 g
s
.78457 .42641 m .80257 .41454 L .7662 .40146 L p .672 .905 .977 r
F P
0 g
s
.63179 .42033 m .60951 .42856 L .6663 .45201 L p .648 .871 .982 r
F P
0 g
s
.6663 .45201 m .68647 .44278 L .63179 .42033 L p .648 .871 .982 r
F P
0 g
s
.78594 .39003 m .7662 .40146 L .80257 .41454 L p .675 .91 .976 r
F P
0 g
s
.80257 .41454 m .82053 .40222 L .78594 .39003 L p .675 .91 .976 r
F P
0 g
s
.65392 .41165 m .63179 .42033 L .68647 .44278 L p .65 .874 .982 r
F P
0 g
s
.68647 .44278 m .70653 .43311 L .65392 .41165 L p .65 .874 .982 r
F P
0 g
s
.25033 .44432 m .22181 .44546 L .32585 .49168 L p .62 .836 .983 r
F P
0 g
s
.32585 .49168 m .35104 .48902 L .25033 .44432 L p .62 .836 .983 r
F P
0 g
s
.30028 .49385 m .32585 .49168 L .22181 .44546 L p .619 .834 .983 r
F P
0 g
s
.27838 .44265 m .25033 .44432 L .35104 .48902 L p .621 .837 .983 r
F P
0 g
s
.35104 .48902 m .37588 .48586 L .27838 .44265 L p .621 .837 .983 r
F P
0 g
s
.22181 .44546 m .19281 .44604 L .30028 .49385 L p .619 .834 .983 r
F P
0 g
s
.27431 .49551 m .30028 .49385 L .19281 .44604 L p .617 .833 .983 r
F P
0 g
s
.306 .44045 m .27838 .44265 L .37588 .48586 L p .623 .839 .983 r
F P
0 g
s
.37588 .48586 m .40039 .48222 L .306 .44045 L p .623 .839 .983 r
F P
0 g
s
.19281 .44604 m .16328 .44606 L .27431 .49551 L p .617 .833 .983 r
F P
0 g
s
.2479 .49666 m .27431 .49551 L .16328 .44606 L p .616 .831 .983 r
F P
0 g
s
.33323 .43773 m .306 .44045 L .40039 .48222 L p .624 .84 .983 r
F P
0 g
s
.40039 .48222 m .4246 .4781 L .33323 .43773 L p .624 .84 .983 r
F P
0 g
s
.16328 .44606 m .13318 .4455 L .2479 .49666 L p .616 .831 .983 r
F P
0 g
s
.22103 .49728 m .2479 .49666 L .13318 .4455 L p .614 .83 .983 r
F P
0 g
s
.67594 .40252 m .65392 .41165 L .70653 .43311 L p .653 .877 .982 r
F P
0 g
s
.70653 .43311 m .7265 .423 L .67594 .40252 L p .653 .877 .982 r
F P
0 g
s
.36007 .4345 m .33323 .43773 L .4246 .4781 L p .626 .842 .983 r
F P
0 g
s
.4246 .4781 m .44852 .47352 L .36007 .4345 L p .626 .842 .983 r
F P
0 g
s
.13318 .4455 m .10248 .44434 L .22103 .49728 L p .614 .83 .983 r
F P
0 g
s
.19367 .49736 m .22103 .49728 L .10248 .44434 L p .613 .829 .983 r
F P
0 g
s
.38658 .43077 m .36007 .4345 L .44852 .47352 L p .627 .844 .983 r
F P
0 g
s
.44852 .47352 m .47217 .46847 L .38658 .43077 L p .627 .844 .983 r
F P
0 g
s
.10248 .44434 m .07113 .44258 L .19367 .49736 L p .613 .829 .983 r
F P
0 g
s
.16578 .49689 m .19367 .49736 L .07113 .44258 L p .612 .828 .983 r
F P
0 g
s
.41275 .42654 m .38658 .43077 L .47217 .46847 L p .629 .845 .983 r
F P
0 g
s
.47217 .46847 m .49558 .46295 L .41275 .42654 L p .629 .845 .983 r
F P
0 g
s
.07113 .44258 m .0391 .44018 L .16578 .49689 L p .612 .828 .983 r
F P
0 g
s
.69784 .39294 m .67594 .40252 L .7265 .423 L p .655 .881 .981 r
F P
0 g
s
.7265 .423 m .74639 .41245 L .69784 .39294 L p .655 .881 .981 r
F P
0 g
s
.43863 .42182 m .41275 .42654 L .49558 .46295 L p .63 .847 .983 r
F P
0 g
s
.49558 .46295 m .51875 .45698 L .43863 .42182 L p .63 .847 .983 r
F P
0 g
s
.46423 .41662 m .43863 .42182 L .51875 .45698 L p .632 .849 .983 r
F P
0 g
s
.51875 .45698 m .54172 .45055 L .46423 .41662 L p .632 .849 .983 r
F P
0 g
s
.71964 .38292 m .69784 .39294 L .74639 .41245 L p .658 .884 .981 r
F P
0 g
s
.74639 .41245 m .7662 .40146 L .71964 .38292 L p .658 .884 .981 r
F P
0 g
s
.48957 .41094 m .46423 .41662 L .54172 .45055 L p .634 .851 .983 r
F P
0 g
s
.54172 .45055 m .56449 .44367 L .48957 .41094 L p .634 .851 .983 r
F P
0 g
s
.51467 .40478 m .48957 .41094 L .56449 .44367 L p .635 .853 .983 r
F P
0 g
s
.56449 .44367 m .58708 .43634 L .51467 .40478 L p .635 .853 .983 r
F P
0 g
s
.74134 .37244 m .71964 .38292 L .7662 .40146 L p .66 .888 .98 r
F P
0 g
s
.7662 .40146 m .78594 .39003 L .74134 .37244 L p .66 .888 .98 r
F P
0 g
s
.53955 .39815 m .51467 .40478 L .58708 .43634 L p .637 .855 .983 r
F P
0 g
s
.58708 .43634 m .60951 .42856 L .53955 .39815 L p .637 .855 .983 r
F P
0 g
s
.56423 .39106 m .53955 .39815 L .60951 .42856 L p .639 .858 .983 r
F P
0 g
s
.60951 .42856 m .63179 .42033 L .56423 .39106 L p .639 .858 .983 r
F P
0 g
s
.58873 .38349 m .56423 .39106 L .63179 .42033 L p .64 .86 .983 r
F P
0 g
s
.63179 .42033 m .65392 .41165 L .58873 .38349 L p .64 .86 .983 r
F P
0 g
s
.61306 .37546 m .58873 .38349 L .65392 .41165 L p .642 .863 .983 r
F P
0 g
s
.65392 .41165 m .67594 .40252 L .61306 .37546 L p .642 .863 .983 r
F P
0 g
s
.63723 .36697 m .61306 .37546 L .67594 .40252 L p .644 .866 .982 r
F P
0 g
s
.67594 .40252 m .69784 .39294 L .63723 .36697 L p .644 .866 .982 r
F P
0 g
s
.66126 .35802 m .63723 .36697 L .69784 .39294 L p .646 .868 .982 r
F P
0 g
s
.69784 .39294 m .71964 .38292 L .66126 .35802 L p .646 .868 .982 r
F P
0 g
s
.68516 .3486 m .66126 .35802 L .71964 .38292 L p .648 .871 .982 r
F P
0 g
s
.71964 .38292 m .74134 .37244 L .68516 .3486 L p .648 .871 .982 r
F P
0 g
s
.25 Mabswid
.06201 0 m
.92976 .06735 L
s
.92976 .06735 m
1 .40259 L
s
1 .40259 m
0 .33867 L
s
0 .33867 m
.06201 0 L
s
.06201 0 m
0 .33867 L
s
.0584 .01969 m
.06513 .0202 L
s
[(-0.2)] .04494 .01865 1 .07681 Mshowa
.04533 .09107 m
.05206 .09156 L
s
[(0)] .03187 .09007 1 .07392 Mshowa
.03139 .16724 m
.03812 .16772 L
s
[(0.2)] .01792 .16629 1 .07084 Mshowa
.01647 .24872 m
.0232 .24918 L
s
[(0.4)] .003 .24781 1 .06755 Mshowa
.00047 .33608 m
.00721 .33651 L
s
[(0.6)] -0.013 .33522 1 .06402 Mshowa
.125 Mabswid
.05521 .03711 m
.05925 .03741 L
s
.05197 .05481 m
.05601 .05511 L
s
.04868 .07279 m
.05272 .07309 L
s
.04193 .10964 m
.04597 .10994 L
s
.03848 .12853 m
.04251 .12882 L
s
.03496 .14772 m
.039 .14801 L
s
.02775 .1871 m
.03179 .18738 L
s
.02405 .20729 m
.02809 .20757 L
s
.02029 .22783 m
.02433 .2281 L
s
.01258 .26999 m
.01662 .27026 L
s
.00861 .29163 m
.01265 .29189 L
s
.00458 .31366 m
.00862 .31392 L
s
.06154 .00254 m
.06558 .00285 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[51]:=",
  ImageSize->{288, 242.25},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000lQP00`40o`000?l0003oooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool0
0?oooolQoooo000Roooo00<0003oooooool00_ooo`040000oooooooooooo0P000??oool0027oool0
0`000?ooo`000009oooo00<0003oooooool0l?ooo`007?ooo`<00002oooo00<0003oool000002?oo
o`030000oooooooo0?7oool0027oool00`000?ooo`000009oooo00<0003oooooool0l?ooo`008Ooo
o`030000oooo000000Ooool00`000?ooo`00000Yoooo00<0003oooooool00_ooo`040000oooooooo
oooo0`000;goool002;oool00`000?ooooooo`07oooo00<0003oooooool09oooo`030000oooo0000
00Ooool00`000?ooooooo`2moooo001Aoooo0`0000;oool00`000?ooo`000008oooo00<0003ooooo
ool0_?ooo`00E_ooo`030000oooo000000Soool00`000?ooooooo`2loooo001Foooo00<0003oool0
00001oooo`030000oooo000002Soool00`000?ooooooo`02oooo00<0003oooooool01@0008Soool0
05Ooool00`000?ooooooo`07oooo00<0003oooooool09_ooo`030000oooo000000Soool00`000?oo
ooooo`28oooo0025oooo0`0000;oool00`000?ooo`000008oooo00<0003oooooool0R?ooo`009Ooo
o`L0001Noooo00<0003oool000002?ooo`030000oooooooo08Soool002Goool200001Oooo`d0001A
oooo00<0003oool000002?ooo`030000oooooooo02Soool00`000?ooooooo`1Moooo000Coooo00<0
003oooooool00_ooo`040000oooooooooooo0`0000Koool200002_ooo`030000oooooooo00Goool=
0000AOooo`030000oooooooo00Koool20000:Oooo`030000oooo000005koool001;oool00`000?oo
o`000007oooo00<0003oooooool01Oooo`80000Eoooo00<0003oooooool01oooo`h0001/oooo00<0
003oool00000G_ooo`003Oooo`<00002oooo00<0003oool000002?ooo`030000oooooooo00Coool2
00007oooo`030000oooooooo00Soool00`000?ooooooo`0>0000G_ooo`030000oooo000002coool0
0`000?ooooooo`02oooo00<0003oooooool01@0002Goool001;oool00`000?ooo`000008oooo00<0
003oooooool01?ooo`<0000coooo00<0003oooooool01?ooo`d0001Aoooo00<0003oool00000:ooo
o`030000oooo000000Soool00`000?ooooooo`0Uoooo000Boooo00<0003oool000001oooo`030000
oooo000000Goool20000=?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo3@0004Goool0
0`000?ooooooo`0Zoooo00<0003oool000002?ooo`030000oooooooo02Goool001?oool00`000?oo
ooooo`07oooo00<0003oooooool01?ooo`030000oooo000004Ooool00`000?ooooooo`07oooo00<0
003oooooool03@0006Goool00`000?ooo`000008oooo00<0003oooooool09Oooo`009?ooo`030000
oooo000005_oool00`000?ooooooo`03oooo3@0005Soool00`000?ooo`000008oooo00<0003ooooo
ool09Oooo`008oooo`040000oooooooo0000IOooo`030000oooooooo00Koool=0000C?ooo`030000
oooooooo00Koool200009oooo`008oooo`8000000oooo`000?ooo`1Toooo00<0003oooooool02?oo
o`030000oooooooo00Ooool>0000LOooo`008oooo`040000oooooooo0000N_ooo`030000oooooooo
00Ooool010000?ooooooooooo`d0001Toooo000Soooo00@0003oooooool0002>oooo00<0003ooooo
ool01?ooo`d0001Goooo000Soooo00@0003oooooool0002Goooo00<0003oooooool02?ooo`h00019
oooo000Roooo0P0000;oool00`000?ooooooo`2Eoooo00<0003oooooool01oooo`030000oooooooo
00Ooool00`000?ooooooo`02oooo3@0003coool002;oool01@000?ooooooooooo`00002eoooo00<0
003oooooool01Oooo`d0000_oooo000Roooo00D0003oooooooooool00000_oooo`030000oooooooo
00Ooool>00008_ooo`008_ooo`050000oooooooooooo00000<Soool00`000?ooooooo`07oooo00<0
003oooooool00_ooo`L0000Koooo000Roooo00D0003oooooooooool00000g?ooo`80000Koooo000Q
oooo0P0000?oool00`000?ooooooo`3Joooo0P0001_oool0027oool00`000?ooooooo`03oooo00<0
003oooooool0fOooo`030000oooo000001[oool001[oool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo0=Soool010000?ooooooo`0001[oool001Woool00`000?ooo`000005
oooo00<0003oooooool00oooo`030000oooooooo0=Soool010000?ooooooo`0001[oool001Woool0
0`000?ooo`000004oooo0`0000Coool00`000?ooooooo`3Hoooo00@0003oooooool0000Joooo000I
oooo00<0003oool000001Oooo`030000oooooooo00?oool00`000?ooooooo`3Goooo00D0003ooooo
ooooool000006_ooo`006Oooo`030000oooo000000Coool00`000?ooooooo`04oooo00<0003ooooo
ool0eoooo`030000oooooooo00;oool00`000?ooooooo`0Goooo000Joooo00<0003oooooool00ooo
o`030000oooooooo00Coool00`000?ooooooo`3Goooo00<0003oooooool00_ooo`030000oooooooo
01Ooool0023oool00`000?ooooooo`04oooo00<0003oooooool0e_ooo`030000oooooooo00?oool0
0`000?ooooooo`0Goooo000Poooo0P0000Goool00`000?ooooooo`3Foooo00<0003oooooool00ooo
o`030000oooooooo01Ooool0023oool00`000?ooooooo`04oooo00<0003oooooool0eOooo`030000
oooooooo00Goool00`000?ooooooo`0Foooo000Ooooo00<0003oooooool01Oooo`030000oooooooo
05Woool20000N_ooo`030000oooooooo00Goool00`000?ooooooo`0Foooo000Ooooo00<0003ooooo
ool01Oooo`030000oooooooo05Woool01000086/l000000007Soool00`000?ooooooo`05oooo00<0
003oooooool05_ooo`007oooo`030000oooooooo00Goool00`000?ooooooo`1Joooo00<00021[?21
[?000`0007Coool00`000?ooooooo`06oooo00<0003oooooool05_ooo`007oooo`800007oooo00<0
003oooooool0FOooo`030000PJc`PJc`00>1[?020000L_ooo`030000oooooooo00Koool00`000?oo
ooooo`0Foooo000Ooooo00<0003oooooool01_ooo`030000oooooooo05[oool00`00086/l86/l004
PJc`0P0006ooool00`000?ooooooo`08oooo00<0003oooooool05Oooo`007oooo`030000oooooooo
00Koool00`000?ooooooo`1Joooo00<00021[?21[?001H6/l0<0001]oooo00<0003oooooool02?oo
o`030000oooooooo01Goool001koool00`000?ooooooo`07oooo00<0003oooooool0Foooo`800006
PJc`00@00020Z^l00000001[oooo00<0003oooooool02?ooo`030000oooooooo01Goool001koool0
0`000?ooooooo`07oooo00<0003oooooool0Foooo`040000P:_`00000000186/l0040000P:[_P:[_
P:[_0P0006Soool00`000?ooooooo`09oooo00<0003oooooool05Oooo`007_ooo`800008oooo00<0
003oooooool0G?ooo`030000P:_`P:_`00800002PJc`00<00020Z^n0Z^l00h2Zk`80001Voooo00<0
003oooooool02Oooo`030000oooooooo01Goool001koool00`000?ooooooo`07oooo00<0003ooooo
ool0G?ooo`030000P:_`P:_`00:0Zo02000000>1[?000020Z^l01H2Zk`80001Soooo00<0003ooooo
ool02oooo`030000oooooooo01Coool000coool00`000?ooooooo`02oooo00@0003oooooooooool3
00001_ooo`030000oooooooo00Ooool00`000?ooooooo`1Moooo00<00020Zo20Zo000h2[l0800007
P:[_0`00067oool00`000?ooooooo`0;oooo00<0003oooooool05?ooo`002oooo`030000oooo0000
00Ooool00`000?ooooooo`05oooo00<0003oooooool02?ooo`030000oooooooo05goool00`00082[
l82[l005P:_`0P0000J0Z^l0100007nYk`00000005ooool00`000?ooooooo`0;oooo00<0003ooooo
ool05?ooo`002oooo`030000oooo000000Soool00`000?ooooooo`04oooo00<0003oooooool02?oo
o`030000oooooooo05koool200001H2[l0040000OjW_00000000182Zk`050000OjW_OjW_OjW_0000
05goool00`000?ooooooo`0<oooo00<0003oooooool05?ooo`002oooo`030000oooo000000Soool0
0`000?ooooooo`04oooo0`0000Soool00`000?ooooooo`1Noooo00@0001oZ_0000000004P:_`00<0
001oZNmoZNl00P0000:0Z^l00`0007nYkgnYk`02OjW_0P0005_oool00`000?ooooooo`0<oooo00<0
003oooooool05?ooo`002oooo`030000oooo000000Ooool00`000?ooo`000005oooo00<0003ooooo
ool02?ooo`030000oooooooo05ooool00`0007nZl7nZl00200000X2[l0030000OjW_OjW_009oZNl2
000000>0Z^l0001oZNl017nYk`80001Ioooo00<0003oooooool03Oooo`030000oooooooo01?oool0
00coool00`000?ooooooo`07oooo00<0003oooooool01?ooo`030000oooooooo00Soool00`000?oo
ooooo`1Ooooo00<0001oZ_1oZ_000WnZl08000000h2[l00007nYk`04OjW_0P0000MoZNl00`000?oo
ooooo`1Eoooo00<0003oooooool03_ooo`030000oooooooo01?oool001goool00`000?ooooooo`08
oooo00<0003oooooool0H?ooo`030000Oj[`Oj[`00=oZ_0200001WnYk`<00005OjW_0`0005Goool0
0`000?ooooooo`0>oooo00<0003oooooool04oooo`007?ooo`030000oooooooo00[oool00`000?oo
ooooo`1Ooooo0P0000EoZ_0300001GnYk`040000OZS^0000000017nYk`040000OZO^00000000D_oo
o`030000oooooooo00ooool00`000?ooooooo`0Coooo000Loooo0P0000_oool00`000?ooooooo`1O
oooo00@0001mZNl000000004Oj[`00@0001nZ>l000000003OjW_00@0001nZ>inZ>inZ>h200000WnY
k`040000OZO^OZO^OZO^0P00053oool00`000?ooooooo`0?oooo00<0003oooooool04oooo`007?oo
o`030000oooooooo00[oool00`000?ooooooo`1Poooo00<0001mZNmmZNl00P00009oZ_00100007jX
kgjXkgjXk`8000000gnYk`0007jXkP04OZS^0P000003OjW_0000OZO^00=nYnh20000C_ooo`030000
oooooooo013oool00`000?ooooooo`0Boooo000Loooo00<0003oooooool02_ooo`030000oooooooo
063oool00`0007fYkgfYk`02OJW_0P000003Oj[`0000OZS_00=nZ>l300001WjXkP800006OZO^0P00
04_oool00`000?ooooooo`0Aoooo00<0003oooooool04_ooo`007?ooo`030000oooooooo00[oool0
0`000?ooooooo`1Qoooo00<0001mZNmmZNl00gfYk`800006OZS_00<0001nZ>inZ>h01GjXkP<00005
OZO^0`0004Woool00`000?ooooooo`0Aoooo00<0003oooooool04_ooo`006oooo`030000oooooooo
00_oool00`000?ooooooo`1Qoooo00<0001mZNmmZNl017fYk`<00004OZS_0`0000InZ>h00`0007fV
k@000004OZO^00<0001mYNemYNd00P0004Koool00`000?ooooooo`0Boooo00<0003oooooool04_oo
o`006oooo`80000<oooo00<0003oooooool0H_ooo`800005OJW_00@0001mYnl000000003OZS_00@0
001mYnh000000004OZS^00<0001mY^emY^d00P0000=nYnh01@0007fUkGfUkGfUk@000015oooo00<0
003oooooool04oooo`030000oooooooo017oool001_oool00`000?ooooooo`0;oooo00<0003ooooo
ool0H_ooo`040000O:S_000000000gfYk`040000OJO_OJO_OJO_0P000003OZS_0000OJO^009mYnh2
00000WjXkP030000OJK]OJK]009mY^d0100007jWkWjWkP0000AmYNd20000@oooo`030000oooooooo
01?oool00`000?ooooooo`0Aoooo000Koooo00<0003oooooool02oooo`030000oooooooo06?oool0
0`0007bXkgbXk`02000000=mZNl0001mYnl017fWk`<00004OJO^0P000003OZS^0000OJK]00=mY^d3
00001WfUk@800010oooo00<0003oooooool05?ooo`030000oooooooo017oool001_oool00`000?oo
ooooo`0;oooo00<0003oooooool0Hoooo`030000O:S_O:S_009lZ>l300001WfWk`030000OJO^OJO^
00AmYnh200001WfVk@030000OJG]OJG]00ImYNd00`000?ooooooo`0moooo00<0003oooooool05?oo
o`030000oooooooo017oool001_oool00`000?ooooooo`0;oooo00<0003oooooool0I?ooo`030000
O:S_O:S_00=lZ>l00`0007fWkgfWk`04OJO_0`0000EmYnh3000017fVk@<00006OJG]0`0003goool0
0`000?ooooooo`0Doooo00<0003oooooool04Oooo`006_ooo`030000oooooooo00coool00`000?oo
ooooo`1Toooo0`0000=lZ>l300001GfWk`040000O:K^000000000gfWkP030000O:G]O:G]00800003
OJK]00@0001lY>`000000004OJG]00<0001lXnalXn`00P0003[oool00`000?ooooooo`0Foooo00<0
003oooooool04?ooo`006_ooo`80000=oooo00<0003oooooool0IOooo`030000NjO_000000=lZ>l0
100007bVkP00000000=mYnl0100007bVkWbVkWbVkP800002OJO^00@0001lYNelYNelYNd2000000=m
Y^d0001lY>`00WbTk0800003OJG]00@0001lXnalXnalXn`20000>?ooo`030000oooooooo01Koool0
0`000?ooooooo`0@oooo000Joooo00<0003oooooool03Oooo`030000oooooooo06Coool00`0007^W
kg^Wk`02000000=lZ>l0001lY^h00WbVkP8000000gfWk`0007bVkP04O:K^0`0000ElYNd3000017bT
k08000000gfUk@0007bSk004O:?/0P0003Goool00`000?ooooooo`0Goooo00<0003oooooool04?oo
o`002Oooo`030000oooooooo00;oool00`000?ooooooo`02oooo0`0000Coool00`000?ooooooo`0=
oooo00<0003oooooool0I?ooo`030000NjO_NjO_009kYnl3000017bVkP<00006O:K^00<0001lYNel
YNd01GbUk@030000O:C/O:C/00AlY>`200001gbSk0030000oooooooo03;oool00`000?ooooooo`0G
oooo00<0003oooooool04?ooo`002?ooo`030000oooo000000Woool00`000?ooooooo`03oooo00<0
003oooooool03Oooo`030000oooooooo06Goool00`0007^Wkg^Wk`03NjO_00<0001lY^ilY^h017bV
kP030000O:K^O:K^00AlY^h300001GbUk@<00005O:C/0`0000ElXn`30000<_ooo`030000oooooooo
01Ooool00`000?ooooooo`0@oooo0008oooo00<0003oool000001oooo`@00003oooo00<0003ooooo
ool03_ooo`030000oooooooo06Goool00`0007^Wkg^Wk`03NjO_0`0000AlY^h300001GbVkP030000
NjC]000000AlYNd0100007^Sk7^Sk00000AlY>`0100007^Rjg^Rj`0000AlXn`0100007ZPjWZPjP00
033oool00`000?ooooooo`0Ioooo00<0003oooooool03oooo`002?ooo`030000oooo000000Ooool0
0`000?ooo`000004oooo0`0000koool00`000?ooooooo`1Uoooo0`0000AkYnl0100007ZUkP000000
00=lY^h0100007^Uk@00000000=lY^h00`0007^TkG^Tk@0200000gbUk@030000Nj?/Nj?/00800003
O:C/00<0001kX^]kX^/00P0000=lXn`00`0007ZPjWZPjP020000;_ooo`030000oooooooo01Woool0
0`000?ooooooo`0?oooo0008oooo00<0003oool000002?ooo`800004oooo00<0003oooooool03_oo
o`030000oooooooo06Koool0100007ZUk`000000009kYnl0100007ZUkWZUkWZUkP8000000gbVkP00
07^Uk@02NjG]0P000003O:K^0000NjC]00=kY>d0100007bUkGbUk@0000AkXn`0100007bTk7bTk000
00AkX^/0100007bSk7bSk00000AjX>X00`000?ooooooo`0Zoooo00<0003oooooool06_ooo`030000
oooooooo00ooool000Woool00`000?ooooooo`08oooo00<0003oooooool00_ooo`030000oooooooo
00koool00`000?ooooooo`1Voooo00@0001jYNmjYNmjYNl2000000=kYnl0001jYNh00gZUkP<00004
NjG]0`0000AkY>d300001G^Sk0<00005Nj;[0`0000EjX>X20000:_ooo`030000oooooooo01[oool0
0`000?ooooooo`0?oooo000Ioooo00<0003oooooool03_ooo`030000oooooooo06Ooool00`0007ZU
kgZUk`02NZG_0P0000IjYNh00`0007^UkG^Uk@04NjG]00<0001kY>ekY>d017^Tk@030000Nj?/Nj?/
00EkXn`00`0007^Rjg^Rj`05Nj;[00<0001jX>YjX>X01GZPjP030000oooooooo02Ooool00`000?oo
ooooo`0Joooo00<0003oooooool03oooo`006?ooo`030000oooooooo00ooool00`000?ooooooo`1W
oooo00<0001jYNmjYNl00gZUk`<00004NZG^0`0000AkYNd3000017^Tk@<00005Nj?/0`0000EkX^/3
00001GZPjP<0000Voooo00<0003oooooool07?ooo`030000oooooooo00koool001Soool200004?oo
o`030000oooooooo06Ooool3000017ZUk`040000NJC^000000000gZUkP030000NZ?]000000=kYNd0
0`0007ZSk7ZSk00200000g^Tk@040000NZ;/000000000g^Sk0030000NZ7[NZ7[00800003Nj;[00@0
001iWnYiWnX00004NZ3Z00@0001hWNUhWNT0000Uoooo00<0003oooooool07?ooo`030000oooooooo
00koool001Soool00`000?ooooooo`0?oooo00<0003oooooool0J?ooo`040000N:C^000000000WZU
k`040000NJC^NJC^NJC^0P000004NZG^0000NZ?]NZ?]0P00009kYNd0100007ZSk7ZSk7ZSk0800000
0g^Tk@0007ZRk002NZ;/0P00009kXn`0100007ZQjgZQjgZQj`800002Nj;[00<0001iWnYiWnX00P00
009jX>X0100007RMjGRMjGRMj@80000Roooo00<0003oooooool07Oooo`030000oooooooo00koool0
01Soool00`000?ooooooo`0?oooo00<0003oooooool0J?ooo`040000N:C^N:C^N:C^0P000003NZG_
0000NJC^00=iY>h300000gZSk@<00005NZ?/0`0000AjX^`300001GZQj`<00004NIoZ0`0000EhWNT2
00008?ooo`030000oooooooo01goool00`000?ooooooo`0>oooo000Hoooo00<0003oooooool03ooo
o`030000oooooooo06Woool00`0007RTkWRTkP02N:C^0P0000IiY>h00`0007ZSkGZSk@03NZ?]00<0
001jXnajXn`01GZSk0030000NZ;/NZ;/00AjX^`00`0007ZQjgZQj`05NZ7[00<0001iWnYiWnX017VO
jP030000N9gYN9gY00EhWNT00`000?ooooooo`0Moooo00<0003oooooool07_ooo`030000oooooooo
00goool001Soool00`000?ooooooo`0@oooo00<0003oooooool0J?ooo`030000N:C^N:C^00=hY>h3
000017VTkP<00003NZ?]0`0000EjXn`3000017ZRk0<00005NZ7[0`0000AiWnX300001GRMj@<0000L
oooo00<0003oooooool07oooo`030000oooooooo00goool001Ooool00`000?ooooooo`0Aoooo00<0
003oooooool0JOooo`800004N:C^00<0001hXnd000000gVTkP040000N:;]N:;]00000gZSk@040000
NJ7/000000000gZSk0040000NJ7[NJ7[00000gZRk0040000N9oZN9oZ000017ZQj`040000N9kYN9kY
00000gVOjP030000MicXMicX00800003N9gY00@0001fVNMfVNL0000Koooo00<0003oooooool07ooo
o`030000oooooooo00goool001Ooool200004_ooo`030000oooooooo06Woool0100007NSkP000000
009hY>h00`0007RSkGRSk@0200000WVTkP030000N:;]N:;]008000000gZSk@0007VQk002NJ7/0P00
009jXn`00`0007VQjgVQj`0200000WZRk0030000N9oZN9oZ00800002NZ7[00@0001hW^UhW^UhW^T2
00000WVOjP040000MicXMicXMicX0P00009hWNT00`0007JIigJIi`0200006Oooo`030000oooooooo
01ooool00`000?ooooooo`0=oooo000Goooo00<0003oooooool04Oooo`030000oooooooo06[oool0
0`0007NSkWNSkP02000000=hY>h0001hXnd00WRSk@<00004N:;]0`0000AiXN`3000017VQj`<00004
N9oZ0`0000EhW^T300001GNLj0<00004MYWW0P0001Koool00`000?ooooooo`0Poooo00<0003ooooo
ool03Oooo`005oooo`030000oooooooo017oool00`000?ooooooo`1Zoooo00<0001gXnigXnh00WNS
kP800005N:?]00<0001hX^ehX^d017RRk@030000NJ7/NJ7/00AiXN`00`0007VQjgVQj`04NJ7[00<0
001hWnYhWnX017ROjP030000N9kYN9kY00EhW^T00`0007NLj7NLj005MicX00<0001fVNMfVNL017JI
i`030000oooooooo01?oool00`000?ooooooo`0Qoooo00<0003oooooool03?ooo`005oooo`030000
oooooooo017oool00`000?ooooooo`1Zoooo0`0000=gXnh300000gRSk@<00004N:;]0`0000AiXN`3
000017VQj`<00004N9oZ0`0000EhW^T300001GNLj0<00004MYWW0`0001;oool00`000?ooooooo`0R
oooo00<0003oooooool03?ooo`005_ooo`030000oooooooo01;oool00`000?ooooooo`1[oooo00<0
001eX^d000000gNSkP030000MZ7]000000=hXnd00`0007NQk0000003N:;]00@0001gX>agX>`00003
NJ7/00@0001gWn]gWn/00003NJ7[00@0001gW^YgW^X00003N9oZ00@0001gW>UgW>T00004N9kY00@0
001fV^QfV^P00004MicX00@0001dV>IdV>H00003MYWW00@0001bU>AbU>@0000Aoooo00<0003ooooo
ool08_ooo`030000oooooooo00coool001Koool00`000?ooooooo`0Boooo00<0003oooooool0Jooo
o`030000MJ;]MJ;]0080000017NSkP0007JQkGJQk@80000017RSk@0007NQk7NQk0800002N:;]00<0
001gX>agX>`00P00009iXN`00`0007NOjgNOj`0200000WVQj`030000MikZMikZ00800002N9oZ00<0
001gW>UgW>T00P00009hW^T0100007JJj7JJj7JJj0800002MicX00D0001dV>IdV>IdV>H000000WJI
i`050000LYCTLYCTLYCT0000013oool00`000?ooooooo`0Roooo00<0003oooooool03?ooo`005_oo
o`80000Coooo00<0003oooooool0K?ooo`040000MJ;]MJ;]MJ;]0`0000=fXNd300000gNQk0<00004
Mj3/0`0000AgWn/3000017NNjP<00004MicY0`0000EfV^P3000017BHiP<00004LYCT0P0000goool0
0`000?ooooooo`0Soooo00<0003oooooool03?ooo`005_ooo`030000oooooooo01;oool00`000?oo
ooooo`1/oooo00<0001eX^eeX^d00gFRk@030000MZ7]MZ7]00=fXNd00`0007NQk7NQk003Mj7/00<0
001gX>agX>`017NPk0030000Mio[Mio[00AgWn/00`0007NNjWNNjP04MikZ00<0001gW>UgW>T017NL
j@030000MY[XMY[X00EfV^P00`0007BHiWBHiP04M9SV00<0001bU>AbU>@017:Di0030000oooooooo
00[oool00`000?ooooooo`0Toooo00<0003oooooool02oooo`005_ooo`030000oooooooo01;oool0
0`000?ooooooo`1/oooo0`0000=eX^d300000gJQk@<00003Mj7/0`0000AgX>`3000017NOj`<00004
MikZ0`0000AgW>T300001GJJj0<00004M9SV0`0000AbU>@300002Oooo`030000oooooooo02Goool0
0`000?ooooooo`0;oooo0005oooo00<0003oooooool00_ooo`040000oooooooooooo0P0000Koool0
0`000?ooooooo`0Boooo00<0003oooooool0KOooo`030000M:3]0000009eX^d0100007FPk7FPk000
009fXNd0100007JOk7JOk000009gXN`0100007JOjgJOj`0000=gX>`0100007JNjWJNjP0000=gWn/0
100007JLjGJLj@0000=gW^X0100007FKj7FKj00000=gW>T0100007BHigBHi`0000AfV^P0100007>F
iG>Fi@0000=dV>H01000076Bhg6Bh`0000=bU>@0100006j>hFj>h@0000Soool00`000?ooooooo`0U
oooo00<0003oooooool02oooo`001?ooo`030000oooo000000Ooool00`000?ooo`000004oooo00<0
003oooooool04oooo`030000oooooooo06goool0100007BPkGBPk@00009eX^d0100007FPk7FPk000
009fXNd0100007JOk7JOk000009gXN`00`0007JOjgJOj`0200000WNPk0040000MYkZMYkZ00000WNO
j`050000MYcYMYcYMYcY0000009gW^X01@0007FKj7FKj7FKj0000002MicY00@0001dV>MdV>MdV>L2
00000WJJj0050000LiKULiKULiKU0000009dV>H01@00076Bhg6Bhg6Bh`000002LYCT00D0001^S^5^
S^5^S^4000001oooo`030000oooooooo02Goool00`000?ooooooo`0;oooo0004oooo00<0003oool0
00001oooo`030000oooo000000Coool300005?ooo`030000oooooooo06goool00`0007BPkGBPk@03
00000gFPk0<00003MYo/0`0000AfWn/300000gJNjP<00004MYcY0`0000AeVnP300001GBHi`<00004
LiKU0`0000AaT^<3000016j>h@800004oooo00<0003oooooool09_ooo`030000oooooooo00_oool0
00Coool00`000?ooo`000007oooo0P0000Goool900003_ooo`030000oooooooo06goool00`0007BP
kGBPk@02M:3]00<0001eX>aeX>`00gFPk0030000MYo/MYo/00=fWn`00`0007JOjgJOj`04MYo[00<0
001fW^YfW^X00gJNjP030000MYcYMYcY00AfW>T00`0007FKj7FKj004MI_X00<0001dV>MdV>L01GBH
i`030000LiKULiKU00AcU^D00`00076Bhg6Bh`04LI;S00<0001^S^5^S^4016j>h@050000oooooooo
oooo000002Woool00`000?ooooooo`0:oooo0004oooo00<0003oool000001oooo`030000oooooooo
00Coool00`000?ooooooo`06oooo400006ooool200000WBPk@<00003MJ3/0`0000=fWn`3000017JO
j`<00003MYkZ0`0000AfW>T3000017FKj0<00005M9SW0P0000EcU^D200001G6Bh`800005KXkQ0`00
0003oooo0000oooo02Soool00`000?ooooooo`0:oooo0005oooo00<0003oooooool01oooo`800004
oooo00<0003oooooool05?ooo`030000oooo000000l0001Ooooo00<0001bWnd000000WBPk@030000
Lik/000000=eX>`00`0007BNj`000002MYo/00@0001eWN]eWN/00003MYo[00@0001eW>YeW>X00002
MYkZ00@0001dVnUdVnT00003MYcY00@0001dVNMdVNL00003MI_X00@0001cUnIcUnH00004M9SW00<0
001aU>@0000017>Fi@030000Ki3R000000AaT^<00`0006b;g`000004KXkQ00@0001XQMaXQM`0000Z
oooo00<0003oooooool02_ooo`005Oooo`030000oooooooo01Coool00`000?ooooooo`0?oooo4000
053oool01@0007:Ok@0007BPk@000002Lik/0P000005MJ3/0000M9k[M9k[0000009fWn`00`0007FM
jgFMj`0200000WJOj`040000MIcZMIcZ00000WJNjP030000M9_YM9_Y00800002MYcY00<0001dVNL0
00000P00009eVnP00`0007>GiW>GiP0200000WBHi`030000LICTLICT008000000g>Fi@0006n@hP02
Ki3R0P000003LI;S0000K8_O009/Rml2000000=^S^40001XQM`00fR5g080000Xoooo00<0003ooooo
ool02_ooo`005_ooo`030000oooooooo01?oool00`000?ooooooo`0Ooooo4000043oool00`0007:O
kG:Ok@0300000g>Nk0<00002M9k[0`0000AeWN/300000gFLjP<00004M9_Y100000>Ug_/3000017>G
iP<00004LICT0P0000E_T>8200001Fb;g`800006J8GL00<0003oooooool09Oooo`030000oooooooo
00[oool001Koool00`000?ooooooo`0Coooo00<0003oooooool0;ooooa00000`oooo0P0000=bWnd0
0`0007>Nk7>Nk003Lik/00<0001dW^]dW^/00WBNj`030000MIg[MIg[00AeWN/00`0007FLjWFLjP03
MIcZ00<0001dVnUdVnT00`0000RUg_/200001G>GiP030000LICTLICT00=aU>@00`0006n@hVn@hP04
Ki3R00<0001/Rmm/Rml016b;g`030000J8GLJ8GL00AXQM`200009oooo`030000oooooooo00Woool0
01Koool00`000?ooooooo`0Coooo00<0003oooooool0?ooooa00000Poooo00<0001`WN`000000W:O
k@<00003Lik/0`00009dW^/3000017FMj`<00003MIcZ0`0000>Ug_/200002:GNn`<00002LiOV0P00
00AaU>@3000016n@hP<00004K8_O0P0000AXQM`0100005ihe5ihe00002Koool00`000?ooooooo`09
oooo000Foooo00<0003oooooool04oooo`030000oooooooo04ooool@00004Oooo`070000L9g/0000
0000LYo]0000LYg/00800002Lik/00<0001cWN/000000WBNj`030000LicZ000000=eWN/00`0007>K
jG>Kj@0300002:GNn`<00008YMkk0`000003Ki;S0000LICT009aU>@0100006f>hFf>h@0000=_T>80
100006V8gVV8gP00009/Rml00`0006F1fVF1fP0200000VR5g0050000GWSDGWSDGWSD000002Goool0
0`000?ooooooo`09oooo000Foooo00<0003oooooool04oooo`030000oooooooo05ooool@000000?o
ool0001`WN`00W2Mk0800003LYg/0`00009cWN/300000W>LjPH00003Y=gk0P0000VUg_/200002:GN
n`8000001FnBh`000000076Di0000003KHkQ00@0001_T>9_T>800003JHSN0`0000AUPMX200001Eih
e0030000oooooooo02;oool00`000?ooooooo`09oooo000Foooo00<0003oooooool04oooo`030000
oooooooo06ooool@000000AcWN/0001cW>YcW>X200002JCMn`800009YMkk0`0000NUg_/5000016f>
h@<00005JHSN00<0001UPMYUPMX00fF1fP030000GWSDGWSD00=NN=@200009?ooo`030000oooooooo
00Soool001Koool00`000?ooooooo`0Coooo00<0003oooooool0LOooo`800002L9g/0`0000=bWN`2
00000W>Mja0000000jCMn`000000000:YMkk0P0000>Ug_/200000jSSnP<00005KHkQ00<0001YR=iY
R=h00fV8gP800004IH7J0`00009NN=@00`0004mSadmSa`0200008_ooo`030000oooooooo00Soool0
01Koool00`000?ooooooo`0Coooo00<0003oooooool0LOooo`030000Ki_/0000009`WN`00`00072K
j`000002LYg/00@0001aVnX0001cWN/200001ZCLn`<00005Y=gk4P0000RXhoX300000Vf>h@800004
JHSN00H0001ROMP00000001UPMX00003FW;A0`0000A?HlL00`000?ooooooo`0Ooooo00<0003ooooo
ool02?ooo`005oooo`030000oooooooo01?oool00`000?ooooooo`1aoooo00D0001_Vn`0001`WN`0
00000W2Kj`030000LYg/000000<0000;Y=ck0P0000RTgO/200001jGNna8000001FN5g000000006V8
gP000004HWgH0P0000EJL]400`0004mSadmSa`02Cf?70P00023oool00`000?ooooooo`08oooo000G
oooo00<0003oooooool04oooo`030000oooooooo077oool00`0006nKk6nKk00600001:?Ln`80000;
Y=ck0P0000RTgO/200000jGNn`800006Z>;k0P0000ZXhoXB00000TmSa`040000=Cj^=Cj^00007ooo
o`030000oooooooo00Soool001Ooool00`000?ooooooo`0Coooo00<0003oooooool0LOooo`@00003
Xm_k0P0000JSg?/300002ZCLn`<00007Y=gk0`0000ZXh_/300001ZSSnP800002[>Si0`0000AROMP2
00000eYbdA40000Hoooo00<0003oooooool01oooo`005oooo`030000oooooooo01?oool00`000?oo
ooooo`1_oooo0`0000RSfo/200001j?Ln`80000;Y=ck0P0000>TgO/200000jOQn`80000;Z>;k0P00
00:XhoX200001jcXn@<00000169mf00005I/cP00009JL]400`0004UJ`TUJ`P0200000cDn[P030000
101f000000Koool@00002?ooo`030000oooooooo00Ooool001Ooool00`000?ooooooo`0Coooo00<0
003oooooool0Joooo`@00003Xm[k0P0000RSfo/200001j?Ln`80000;Y=ck0`0000NWhO/300002ZSR
n`<0000;[>Si0`000003EVc>0000000000A9F/80100003Dn[SDn[P00008407H00`000?ooooooo`0D
oooo2@0000Woool001Ooool00`000?ooooooo`0Coooo00<0003oooooool0J?ooo`<00009Xm[k0P00
00RSfo/200001j?Ln`<00007Y=ck0P0000:Wh?/200002:OQn`<00006Z>;k0P0000:/ioX300001jcX
n@800002/O3f0`0000=9F/801P0002/`X`0003Dn[P0000@0MP80000Moooo00<0003oooooool02?oo
o`005oooo`030000oooooooo01?oool00`000?ooooooo`1Uoooo0`0000>Rf_/200002J?Jn`800008
Xm_k0P0000RSg?/200000jCLn`800006Yn3k0P0000VWhO/200000ZSRn`800007[>Oj0`0000:/j?T2
00001k7`mP@00002:c2S00<0000407H407H00P0001goool00`000?ooooooo`08oooo000Hoooo00<0
003oooooool04_ooo`030000oooooooo063oool500002:;Jn`800009Xm[k0P0000RSfo/200002:?L
n`<0000:Yn3k0P0000VWhO/300002jcWnP<00008/O3f00@0002fn>jfn>jfn>h600007Oooo`030000
oooooooo00Woool001Soool00`000?ooooooo`0Boooo00<0003oooooool0F_ooo`H00005X]Wk0P00
00RRf_/300002:?Jn`800008Xm_k0P0000>Sg?/300000jKOn`80000:Yn3k0P0000JWhO/200000Z_V
nP800009[>Oj00<0002`k_N`k_L00P0000Fal?H00`000;Khk[KhkP03]_S^00@0002ho=Nho=L0000N
oooo00<0003oooooool02Oooo`006?ooo`030000oooooooo01;oool00`000?ooooooo`1Eoooo1@00
00BQfO/200001j;In`800009X][k0P0000RSf_/200002:?Kn`<00008Y]ok0`0000VWh?/200000ZOQ
n`800006ZnKj0P0000F/ioX200001K3^m`800002/O3f00<0002fn>jfn>h00kKhkP030000^?cG^?cG
0080000Loooo0P0000coool001Soool00`000?ooooooo`0Boooo00<0003oooooool0DOooo`@00003
XMSk0P0000JQfO/200001j;In`<00008X][k0`0000NSf_/200000j?Kn`<00003YMkk0P0000VVgo/3
00002:OPn`<00009ZnKj0P0000:/ioX00`000;3^mk3^m`07/>kg100000>fn>h00`000;SlekSle`02
00007_ooo`030000oooooooo00[oool001Soool00`000?ooooooo`0Boooo00<0003oooooool0C?oo
o`D00009XMSk0P0000JQfO/200002:;In`800009X][k0P0000NSf_/300002:GNn`80000:Y]ok0P00
00>Wh?/300000j[UnP<00008ZnKj0`0000V`k_L010000;GflKGflKGfl@L0000Noooo00<0003ooooo
ool02oooo`006?ooo`030000oooooooo01;oool00`000?ooooooo`15oooo1`0000FQf?/200002J7H
n`800006XMWk0P0000RRfO/300002:;Jn`800003Xm[k0P0000>Ug_/200002:GNn`<00009Y]ok0`00
00VZiOX400000j_VnP800002[nch100000>`k_L200001KGfl@030000^OcO^OcO0080000Ooooo00<0
003oooooool02oooo`006?ooo`030000oooooooo01;oool00`000?ooooooo`0goooo3P0000FPf?/2
00001j7Hn`800009XMSk0P0000JQfO/300002:;In`800008X][k0`0000NUg_/300002:GNn`800006
Y]ok0P0000:Yi?X300002Z[UnP<00008[nch1@0000>em_4200000[Wlg`030000[O2Y000001koool0
0`000?ooooooo`0<oooo000Hoooo00<0003oooooool01?ooo`@0000;oooo00<0003oooooool0;ooo
o`L00005WmOk0P0000FPeo/200001j3Hn`<00006XMSk0`0000RQf?/300001Z7In`800008X]Wk0P00
00>Rf_/300000jCMn`800008YMkk0P0000RUg_/200000ZKOn`800007ZNCj0P0000NZiOX200000Zk[
n@800007[nch00@0002dm?>dm?>dm?<900007oooo`030000oooooooo00coool001Woool00`000?oo
ooooo`05oooo6P00013ooolE00001IoFn`800007WmOk0P0000FPeo/200002:3Hn`800007XMSk0P00
00VQf?/200001Z7In`800008X]Wk0`0000RTgO/300001jGNn`<00007YMkk0`0000ZYi?X300000Z[U
nP800006[^_i0`0000:_k?P200001KCdl`070000^?cU^?cU^?cU0000/oNl000001ooool00`000?oo
ooooo`0=oooo000Ioooo00<0003oooooool01oooo`800004W=?k0P0000JLe?/200001YgDna800005
W]Gk0P0000FNe_/200001IkFn`800007WmKk0P0000NOeo/200001J3Gn`<00007X=Sk0P0000NQf?/2
00002J7Hn`800006XMWk0P0000>RfO/300000jCLn`800009Y=gk0P0000RUg_/200000jGNn`800003
Z>?j0`0000ZYi?X300002Zk[n@@00004]?Cc00L0002ho>Fho>Fho>D0002cmk`000007oooo`80000?
oooo000Ioooo00<0003oooooool02Oooo`800004W=?k0P0000JLe?/200001YgDn`800004WMCk0P00
00FMeO/2000029kEn`800005W]Kk0P0000FNe_/200001ioFn`800007WmOk0P0000JPeo/200001j3H
n`<00006XMSk0`0000RQf?/00`000:7Inj7In`04XMWk100000RTg?/200002JCMn`<00007YMkk0`00
00RXhoX200001jWTnP800002[NWi0`0000N^joT010000;?bm;?bm;?bm0D00003^?cU00<0002cmk`0
00007oooo`030000oooooooo00koool001Woool00`000?ooooooo`0;oooo0P0000BLdo/200001YcD
n`800006WMCk0P0000BMe?/200001IgEn`800008W]Gk0P0000FNe_/200001IkFn`800007WmKk0`00
00JOeo/200001Z3Gn`800008X=Sk0P0000NQf?/200002:7Hn`D00004Xmck0P0000RTg?/200002ZCM
n`800003YMkk0P0000>Xh_/200002:SSnP<00002ZNCj0P0000N]jOT300000Zk[n@800006/o;d00<0
002hn^Vhn^T01@00023oool00`000?ooooooo`0>oooo000Ioooo00<0003oooooool03Oooo`800004
W=?k0`0000FLe?/200001YgDn`800004WMCk0`0000BMeO/300001ikEn`<00004W]Kk0P0000FNe_/3
00001ioFn`800006WmOk0`0000FPeo/200002:3Hn`<00006XMSk0P0000>Qf?/300000j?Kn`800006
Xmck0P0000RTg?/300002JCMn`<00007Z>;k0P0000VXhoX300002jgYn@<00006/o;d00<0002hn^Vh
n^T00[Sjj@030000]o_:0000023oool00`000?ooooooo`0?oooo000Ioooo00<0003oooooool03ooo
o`800005W=?k0P0000FLe?/300001IgDn`800005WMCk0P0000FMeO/2000029kEn`800004W]Kk0P00
00JNe_/200001ioFn`800007WmOk0P0000FPeo/300002:3Hn`030000XMSkXMSk00BQf?/400002:?K
n`<00005Xmck0P0000VTg?/200001ZCMn`800002Yn7k0P0000NXh_/300001ZSSnP030000[>Si[>Si
00<00007[NWi0P0000:bl?H300000[?bm0040000^?[Y^?[Y^?[Y0P000003]o_:0000oooo023oool0
0`000?ooooooo`0?oooo000Ioooo00<0003oooooool04Oooo`800005W=?k0P0000JLe?/200001IgD
n`800005WMCk0P0000FMeO/2000029kEn`800004W]Kk0`0000FNe_/200001ioFn`<00006WmOk0P00
00JPeo/200002:3Hn`D00004X][k0P0000VSfo/200001J?Ln`<00008Y=ck0P0000:TgO/200001ZOQ
n`800008Z>;k0P0000:XhoX200001ZcXn@<00002[NWi0P0000Nbl?H900008Oooo`030000oooooooo
013oool001Woool00`000?ooooooo`0Boooo100000BLdo/300001IcDn`800005WMCk0`0000BMe?/3
000019gEn`<00007W]Gk0P0000FNe_/200001IkFn`<00007WmKk0P0000JOeo/200001Z3Gn`030000
X=SkX=Sk00:Pf?/300000j;Jn`800006X][k0`0000RSfo/200001Z?Ln`800008Y=ck0`0000VWhO/3
00001jSRn`<0000:[>Si0`0000Rbl?H01@000;OhkKOhkKOhk@000002^OgE00<0003oooooool08?oo
o`030000oooooooo013oool001[oool00`000?ooooooo`0Aoooo00@0003oooooooooool200001IcC
n`800005W=Ck0P0000JMe?/200001IgDn`800005WMGk0P0000NNeO/3000019kFn`800006W]Kk0P00
00NOe_/200001YoGn`030000X=OkX=Ok00BPeo/400002:;Jn`800007X][k0P0000RSfo/300001J?L
n`800003Y=ck0`0000>Vh?/300002JOQn`800003Z>;k0P0000>[ioX300001jcXn@030000/Nog/Nog
00@00002/_3f0P0000>gn>d00`000;WmeKWme@0200008?ooo`80000Coooo000Joooo00<0003ooooo
ool04Oooo`030000oooooooo00?oool200001IcCn`800005W=Ck0`0000FMe?/200001IgDn`800005
WMGk0P0000RNeO/2000019kFn`800006W]Kk0P0000NOe_/00`0009oGnioGn`04WmOk1P0000BRfO/2
00002:;Jn`800007X][k0`0000RSfo/00`000:?Lnj?Ln`03Xmck100000VVh?/300002:OQn`<00008
ZnOj0`0000:/j?T200001k7_m`@00003]oS]00@0002ioMFioMD0000Roooo00<0003oooooool04Ooo
o`006_ooo`030000oooooooo017oool00`000?ooooooo`05oooo0P0000FLdo/200001YcDn`800005
WMCk0P0000FMe?/3000019gEn`<00007W]Gk0P0000BNe_/200001YkFn`030000WmKkWmKk00BOe_/7
00001:7In`800006X]Wk0P0000RRf_/300001j;Jn`<00007Xm_k100000BVgo/300002JKPn`<00003
Yn7k0P0000>[i_X200002J_WnP<00008/Nog00@0002fmo2fmo2fmo0600008_ooo`030000oooooooo
01;oool001[oool00`000?ooooooo`0Aoooo00<0003oooooool01oooo`800005W=?k0`0000FLe?/2
00001IgDn`800006WMCk0P0000FMeO/200001ikEn`800004W]Kk00<0002Ne_^Ne_/019kFn`H00005
XMSk0P0000JQfO/200001Z;In`<00008X][k0P0000RRf_/200000j?Kn`800003YMkk0P0000JVgo/2
00002ZKPn`<00007ZnKj0`0000J[ioX00`000;3]n;3]n00400000[7_m`800005]_O`00<0002ioMfi
oMd00P0002;oool00`000?ooooooo`0Boooo000Joooo00<0003oooooool04_ooo`030000oooooooo
00Soool200001YcCn`800005W=Ck0P0000FMe?/200001YgDn`800005WMGk0P0000FNeO/=00001:3H
n`800007XMSk0`0000FQfO/300001Z;In`800008X][k0P0000RRf_/300001jGNn`800006Y]ok0`00
00NVh?/00`000:[TnZ[TnP0200002:_VnP800002ZnOj0P0000N`kOP400000kKgl0800002^OgM0P00
02;oool00`000?ooooooo`0Coooo000Joooo00<0003oooooool04_ooo`030000oooooooo00[oool2
00001YcCn`800005W=Ck0P0000FMe?/200001IgDn`d00005WmOk0P0000BPeo/200001Z3Hn`800008
XMSk0P0000JQfO/200001Z;In`<00007X][k0P0000>Rf_/300000jGMn`800007YMkk0`0000JVgo/3
00000ZKPn`800005Z^Cj0`0000N[i_X300002;3]n0040000]OGb]OGb]OGb200002?oool00`000?oo
ooooo`02oooo00<0003oooooool00_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo000J
oooo00<0003oooooool04_ooo`030000oooooooo00cooolK000019kFn`800005WmOk0P0000NOeo/2
00001:3Gn`800006X=Sk0`0000NQf?/300001J7In`<00006X]Wk0P0000NRf_/300002:GMn`800008
YMkk0P0000NVgo/300002J[TnP800003ZnKj0P0000>_k?P400000[3]n0800005]OGb00@0002io>Bi
o>Bio>@200008Oooo`<00004oooo00<0003oool000001oooo`030000oooo000000Goool001_oool0
0`000?ooooooo`0Aoooo00<0003oooooool03oooo`800006WMGk0P0000FNeO/200001IkFn`800006
W]Kk0P0000FOeo/200001ioGn`800004X=Ok0`0000JPf?/200002:7Hn`800006XMWk0P0000JRfO/2
00000j;Jn`800003Y=gk0P0000RUgO/300001jGNn`800003Y]ok0P0000>YhoX200002J[TnP<00009
[nch100000BemO801`000;Wli;Wli;Wli0000;Cg^P00000Soooo00<0003oooooool00_ooo`030000
oooo000000Ooool00`000?ooo`000005oooo000Koooo00<0003oooooool04Oooo`030000oooooooo
017oool300001IgEn`800005W]Gk0P0000FNe_/200001YkFn`800005WmOk0`0000JOeo/200001J3G
n`800006X=Sk0P0000RQf?/300001J7In`030000X]WkX]Wk00BRfO/400001jCMn`<00008YMgk0P00
00NUg_/300001jWSnP<00006Z^Cj00<0002^j_V^j_T00P0000N_k?P010000;Ccm;Ccm;Ccm0X0000S
oooo00<0003oooooool00oooo`030000oooo000000Soool00`000?ooooooo`04oooo000Koooo00<0
003oooooool04Oooo`030000oooooooo01Coool200001IgEn`<00004W]Gk0P0000FNe_/300001IkF
n`800006WmOk0P0000JOeo/300001:3Gn`800006X=Sk0`0000RQf?/00`000:7Inj7In`03XMWk1P00
00BTg?/200002:CMn`800008YMgk0P0000>Ug_/200000jSRn`<00007ZN?j0P0000:Zi?X200001JkZ
n@<00002[nch0P0000Jdlo@01`000;Wkj;Wkj;Wkj0000;Skb000000Toooo00<0003oooooool00ooo
o`030000oooo000000Ooool00`000?ooo`000005oooo000Koooo00<0003oooooool04Oooo`X0000?
oooo0`0000FMeO/2000019kEn`<00005W]Kk0P0000FNe_/200001YoGn`800007WmOk0P0000BPeo/3
00001Z3Hn`800008XMSk100000BSfo/200001ZCLn`<00007Y=gk0`0000NUgO/300002:SRn`800007
ZN?j0`0000V^j_T400001;Ccm0800003^O_X00<0002hnlP000009?ooo`030000oooooooo00Goool0
0`000?ooooooo`07oooo00<0003oooooool01?ooo`006oooo`030000oooooooo017oool00`000?oo
ooooo`07oooo500000FMeO/200001IkEn`800005W]Kk0`0000BNe_/300001IoGn`800007WmOk0P00
00FPeo/200001Z3Hn`030000XMSkXMSk00:Qf?/300000j?Kn`800005Xm_k0P0000NTg?/200002:CM
n`800003YMgk0P0000>WhO/300001jSRn`<00003ZN?j0P0000:]jOT400001:kZn@800003/o7e1@00
00>innP300009Oooo`030000oooooooo01Koool001_oool00`000?ooooooo`0Aoooo00<0003ooooo
ool06Oooo`@00005WMGk0`0000BNeO/200001YkFn`800005W]Kk0P0000FOeo/300001YoGn`800005
X=Ok00<0002Pf?^Pf?/01:3Hn`@00008Xm_k0P0000FSfo/200001jCLn`<00007Y=gk0`0000RWhO/2
00002:SRn`<00008[NWi100000NclOD00`000;Sik;Sik00600009?ooo`030000oooooooo01Ooool0
01_oool00`000?ooooooo`0Aoooo00<0003oooooool07Oooo`<00005WMGk0P0000BNeO/300001IkF
n`800005W]Kk0P0000JOeo/200001YoGn`030000X=OkX=Ok00>Peo/600001:;Jn`800008Xm_k0P00
00FSfo/300001jCLn`800003Y=gk0P0000>WhO/300001jOQn`<00003Z>;k0P0000>/ioX200001jgY
n@030000/Nof/Nof00@00002/o7e00<0002hnNbhnN`00[Sik0040000^OgC000000009?ooo`80000I
oooo000Koooo00<0003oooooool04?ooo`030000oooooooo027oool200001IgEn`<00004W]Gk0P00
00FNe_/3000019kFn`800006WmOk00<0002Oeo^Oeo/019oGn`D00004X][k0P0000JRf_/300001j?K
n`<00005Xm_k0P0000NTg?/300002:OQn`<00007Yn7k0`0000N/ioX300000ZgYn@800007/Nof0`00
00>hnN`500009?ooo`030000oooooooo01Soool001coool00`000?ooooooo`0?oooo00<0003ooooo
ool08oooo`<00005WMGk0P0000BNeO/200001YkFn`800004W]Kk00<0002Oeo^Oeo/019oGn`H00004
XMWk0P0000FRf_/300001Z;Jn`800008Xm_k0P0000FSfo/200000jCLn`800003Y]ok0P0000VWhO/3
00000jOQn`800002ZnKj0`0000N/ioX300002;7_mP030000]oO_]oO_00D000000jo`YP000?ooo`0T
oooo00<0003oooooool06?ooo`007?ooo`030000oooooooo00ooool00`000?ooooooo`0Voooo0P00
00FMeO/2000019kEn`800005W]Kk300000BQfO/200001Z7In`<00005X][k0P0000JRf_/200002:?K
n`030000Xm_kXm_k00>Sfo/400001jKOn`<00009Yn7k0`0000N[i_X400000ZcWnP800002/>kg1000
00:akoH200000kOgk`8000001;[mg0000:o`YP0002Goool00`000?ooooooo`0Ioooo000Loooo00<0
003oooooool03oooo`030000oooooooo02SooolB00001:3Hn`800004X=Sk0P0000JQfO/200001j7I
n`800005X][k0`0000FRf_/300001j?Kn`@00004Y]ok0`0000NVgo/300001ZOQn`030000Z^GjZ^Gj
00800009ZnKj0`0000N`k_L800000[[mg080000Voooo00<0003oooooool06Oooo`007?ooo`030000
oooooooo00ooool00`000?ooooooo`0[oooo0P0000FOeo/2000019oGn`800006X=Sk0P0000BPf?/2
00001Z7In`<00006XMWk0`0000FRf_/300001J;Jn`800003Xm_k0P0000>Ug_/300001JKOn`@00006
Y]ok0P0000:WhO/200001J[UnP<00006ZnKj00<0002_k?R_k?P0100000:`k_L200001;Kfl@030000
^_cR^_cR00@0000Uoooo00<0003oooooool06_ooo`007?ooo`030000oooooooo00ooool00`000?oo
ooooo`0]oooo0P0000FOeo/2000019oGn`<00005X=Sk0P0000BPf?/300001Z7In`800007XMWk0P00
00JRf_/00`000:;Jnj;Jn`03X][k100000RUg_/200001jKOn`<00004Y]ok100000VZiOX200000Z_V
nP800007[nch100000>fm_401`000;[lh[[lh[[lhP000;Gg^@00000Uoooo0P0001coool001coool0
0`000?ooooooo`0?oooo00<0003oooooool0;oooo`800005WmOk0`0000BOeo/300001:3Hn`800005
X=Sk0P0000JQfO/300001j7In`030000X][kX][k00>Rf_/500001:CMn`<00007YMkk0`0000NVgo/4
00001:WTnP<00008Z^Gj0`0000R_k?P010000;CdlkCdlkCdl`@00003^_cR0P0002Koool00`000?oo
ooooo`0Koooo000Loooo00<0003oooooool03oooo`030000oooooooo037oool200001YoGn`800005
WmOk0P0000BPf?/300001:3Hn`<00006XMWk0P0000NQfO/400001:CMn`800006Y=gk0P0000RUg_/2
00001:KOn`800002ZN?j0P0000JYi?X400000j[UnP800002[^_h100000:_k?P200001KCdl`030000
^O_W^O_W00D0000Uoooo00<0003oooooool07?ooo`007Oooo`030000oooooooo00goool00`000?oo
ooooo`0doooo0`0000FOeo/200001IoGn`<00004X=Sk0P0000FPf?/200001Z7In`030000XMWkXMWk
00:QfO/200000j?Ln`800005Y=gk0P0000JTgO/300002:GNn`<00006ZN?j0`0000NYi?X300002:k[
n0@00004]?Cc00@0002innNinnNinnL400009_ooo`030000oooooooo01coool001goool00`000?oo
ooooo`0=oooo00<0003oooooool0=oooo`800005WmOk0`0000FOeo/200001:3Hn`800005X=Sk00<0
002QfO^QfO/01:7In`@00007Xmck0`0000BTgO/300001ZCMn`<00003YMkk0P0000>Xh_/200001jWS
nP800003ZNCj0P0000>]jOT400000jk[n0800003/o;d2`0002Koool00`000?ooooooo`0Moooo000M
oooo00<0003oooooool03Oooo`030000oooooooo03Woool200001YoGn`800006WmOk00<0002Pf?^P
f?/00Z3Hn`030000X=SkX=Sk00>Pf?/600001:?Kn`800008Xmck0P0000FTgO/200001jCMn`<00007
Z>;k0`0000JYhoX300002JgYn@<00007/o;d00H0002hn^^hn^^hn^/0002joM8200009oooo`030000
oooooooo01goool001goool00`000?ooooooo`0=oooo00<0003oooooool0>oooo`800006WmOk0P00
00FOeo/:00001:;Kn`800006Xm_k0`0000NSg?/300001:CMn`800003Y=gk0P0000>WhO/300001jSR
n`800003ZN?j0P0000:/j?T300001ZgYn@030000/_3f/_3f00<00002/o;d0P0000>hn^/010000;[m
d[[mdP0002Ooool200007oooo`007Oooo`030000oooooooo00goool00`000?ooooooo`0moooo0P00
00FOeo/600001:7Jn`800003X][k0`0000BRfo/300001Z?Kn`800008Xmck00<0002TgO^TgO/00jCM
n`<00008Yn7k0P0000NXh_/300001jcXn@<00002[NWi00<0002bl?Jbl?H01;;`mP/0000Woooo00<0
003oooooool07_ooo`007Oooo`030000oooooooo00goool00`000?ooooooo`0ooooo1@0000BQfO/2
00001Z7Jn`<00003X][k0`0000BRfo/300001J?Kn`<00007Xmck100000>Vh?/300001jOQn`<00003
Z>;k0P0000:[ioX300001jcXn@@00004/_3f0P0000Bgn>h00`000;[mfk[mf`0200009oooo`030000
oooooooo01ooool001goool00`000?ooooooo`0=oooo00<0003oooooool0@_ooo`<00005XMWk0`00
00JQf_/200001:;Jn`800005X]_k0P0000JSfo/200000j?Ln`800003Y]ok0P0000FVh?/300001jOQ
n`<00007ZnOj0`0000>/j?T200000k7_m`H00003]oS^00<0002joM^joM/00P0002Soool00`000?oo
ooooo`0Ooooo000Moooo00<0003oooooool03?ooo`030000oooooooo04Koool200001Z7In`800006
XM[k0P0000BRf_/300001:;Kn`800005Xm_k100000NVgo/200001ZKPn`<00003Yn7k0P0000:[i_X3
00001j_WnP<00007/Nog00@0002fm_6fm_6fm_4800009oooo`030000oooooooo023oool001koool0
0`000?ooooooo`0;oooo00<0003oooooool0B?ooo`<00005XMWk0`0000FQf_/200001J;Jn`800005
X]_k100000BUg_/300001ZKOn`<00006Y^3k0`0000N[i_X300000j_WnP800002/>gh100000:akoL0
0`000;KflKKfl@03]_Ka00D0002jo>6jo>40002emkP00P0002Koool200008_ooo`007_ooo`030000
oooooooo00_oool00`000?ooooooo`1;oooo0`0000FQfO/300001J7Jn`030000X][kX][k00>Rf_/5
00000jCNn`<00005YMkk100000FVgo/200000jKPn`800002ZNGj0`0000N[i_X300002;3]n0@00003
]_Ka00<0002jo>6jo>400`000003oooo0000oooo02Goool00`000?ooooooo`0Qoooo000Noooo00<0
003oooooool02oooo`030000oooooooo04koool200001Z7In`030000XM[kXM[k00>Qf_/500001:CM
n`800005Y=kk0P0000NUg_/300001:KOn`<00007ZNGj100000:[i_X200000Zo/n0@00003/>gh0P00
00>em?<9000000?oool0003oool09Oooo`030000oooooooo027oool001koool00`000?ooooooo`0;
oooo00<0003oooooool0D?ooo`800005XMWk1@0000BSg?/200001JCMn`800005Y=kk0`0000NUg_/4
00000jWTnP<00008ZNGj0`0000N_k?P400001;Gdl`800002^__V00@0002inlL000000002oooo00<0
003oooooool08oooo`030000oooooooo02;oool001koool00`000?ooooooo`0;oooo00<0003ooooo
ool0Doooo`@00004Xmck0P0000FSg?/200001JCMn`800006Y=kk0P0000BUg_/200000ZSSn`800005
ZNCj100000>YiOX200000ZkZn@@00002[nch0P0000>cl_@;00001?ooo`030000oooooooo02;oool0
0`000?ooooooo`02oooo00<0003oooooool00_ooo`030000oooooooo00;oool00`000?ooooooo`02
oooo00<0003oooooool03_ooo`007_ooo`030000oooooooo00_oool00`000?ooooooo`1Foooo0P00
00FSg?/300001:?Ln`<00004Y=gk0P0000NTg_/300001ZSSn`<00006ZNCj0`0000R^j_T400001;?b
m0800003^O[[00@0002joM8000000005oooo00<0003oooooool08Oooo`030000oooooooo00;oool0
0`000?ooo`000008oooo00L0003oooooooooool0003oool000003oooo`007_ooo`030000oooooooo
00_oool00`000?ooooooo`1Hoooo0`0000FSg?/200001J?Ln`800004Y=gk0P0000>Tg_/200000jOR
n`800007Z>?k0P0000>Yi?X200000ZgYn@@00003[^[i0P0000>blOH500000kWjj`040000^_gB^_gB
00001_ooo`030000oooooooo01ooool300001?ooo`030000oooo000000Soool00`000?ooooooo`03
oooo00<0003oooooool03Oooo`007oooo`030000oooooooo00Woool00`000?ooooooo`1Loooo0P00
00FSg?/300001:?Ln`800004Y=gk0`0000NWh_/300001ZSSn`<00008[NWi100000JblOH00`000;Sh
k[ShkP0600001oooo`030000oooooooo023oool00`000?ooooooo`03oooo00<0003oool000002Ooo
o`030000oooooooo0080000@oooo000Ooooo00<0003oooooool02Oooo`030000oooooooo05koool3
00001J?Ln`030000XmckXmck00>Sg?/400000jKQn`@00006Yn;k0P0000>Xho/200000ZcWnP@00004
[NWi0P0000:akoL300000[;amP040000^?S^^?S^^?S^0P000003^ogJ0000000000Soool00`000?oo
ooooo`0Poooo00<0003oooooool00oooo`030000oooo000000Ooool00`000?ooo`000002oooo00<0
003oooooool03oooo`007oooo`030000oooooooo00Woool00`000?ooooooo`1Qoooo00<0002Sg?^S
g?/00j?Ln`D00003Y^3k0`0000FVhO/400001:ORn`@00007[>Oj100000NakoL;00002?ooo`030000
oooooooo01ooool00`000?ooooooo`05oooo00<0003oooooool01_ooo`<00002oooo0`0000ooool0
01ooool00`000?ooooooo`09oooo00<0003oooooool0Hoooo`@00004YMok0`0000BVh?/300001ZKQ
n`@00004ZnKj100000>/ioX200000[3]m`@00002/Nog0P0000>fm_001P000;[mhK[mh@000;Kg^@00
00Woool00`000?ooooooo`0Ooooo00<0003oooooool09Oooo`007oooo`030000oooooooo00Woool0
0`000?ooooooo`1Voooo0P0000JUgo/300001:KPn`800003Y^7k0P0000:YiOX300001Z_VnP@00007
/>gg100000>fm_000`000;[mhK[mh@0200002_ooo`030000oooooooo01goool20000:?ooo`007ooo
o`030000oooooooo00Woool00`000?ooooooo`1Xoooo0`0000JUgo/200001JKPn`<00006ZNGj0`00
00>[i_X200000Zo/n0@00002/>gg0P0000>em?8700002oooo`030000oooooooo01koool00`000?oo
ooooo`0Voooo000Ooooo00<0003oooooool02Oooo`030000oooooooo06_oool300001ZGOn`@00003
ZNCj0`0000JYiOX300002:o/n0@00003]OCb0P0000:jnnH00`000;Wka`00000<oooo00<0003ooooo
ool07?ooo`030000oooooooo02Ooool001ooool00`000?ooooooo`09oooo00<0003oooooool0K_oo
o`800003YMok0P0000:Xho/200001JWTnP<00002ZNGj0P0000:^joT400000jo/n0800003/o?d2@00
00goool00`000?ooooooo`0Loooo00<0003oooooool09oooo`008?ooo`030000oooooooo00Ooool0
0`000?ooooooo`1aoooo0`0000JXho/200001ZWTnP<00007[^_i1@0000>clo@200000[WjjP800000
0k[mdP000000000=oooo00<0003oooooool06oooo`030000oooooooo02Soool0023oool00`000?oo
ooooo`07oooo00<0003oooooool0M?ooo`<00005Z>?k0P0000>Yi?X200000ZcYn@@00003[^_i0P00
00>blOD;00003_ooo`030000oooooooo01[oool20000:_ooo`008?ooo`030000oooooooo00Ooool0
0`000?ooooooo`1goooo100000>Xho/300002:cYn@@00004/_7e0P0000>gn>d01P000;_mf[_mfP00
0;;bZP0000koool00`000?ooooooo`0Joooo00<0003oooooool0:Oooo`008?ooo`030000oooooooo
00Ooool00`000?ooooooo`1koooo0`0000>[j?X400000jcYn@800003/Nof1P0000>gn>d500003ooo
o`030000oooooooo01[oool00`000?ooooooo`0Yoooo000Poooo00<0003oooooool01oooo`030000
oooooooo07koool200001J_XnPD00004/Nof0P0000>fmo05000000>gn;/0003oool03oooo`030000
oooooooo01Woool00`000?ooooooo`0Zoooo000Poooo00<0003oooooool01oooo`030000oooooooo
083oool300000Z_XnP800003/>kg1P0000>fmo02000000BjoN4000000000000Aoooo00<0003ooooo
ool06Oooo`030000oooooooo02[oool0023oool00`000?ooooooo`07oooo00<0003oooooool0Pooo
o`@00004/>kg0P0000>emO8800004_ooo`030000oooooooo01Ooool20000;Oooo`008Oooo`030000
oooooooo00Goool00`000?ooooooo`28oooo1P0000>emO8200000[WkiP<0000Doooo00<0003ooooo
ool05oooo`030000oooooooo02_oool0027oool00`000?ooooooo`05oooo00<0003oooooool0S_oo
o`P0000Foooo00<0003oooooool05_ooo`030000oooooooo02coool0027oool00`000?ooooooo`05
oooo00<0003oooooool0[?ooo`030000oooooooo01Koool00`000?ooooooo`0/oooo000Qoooo00<0
003oooooool01Oooo`030000oooooooo0:coool00`000?ooooooo`0Eoooo00<0003oooooool0;Ooo
o`008Oooo`030000oooooooo00Goool00`000?ooooooo`2/oooo00<0003oooooool05?ooo`80000_
oooo000Qoooo00<0003oooooool01Oooo`030000oooooooo0:coool00`000?ooooooo`0Doooo00<0
003oooooool0;_ooo`008Oooo`030000oooooooo00Goool00`000?ooooooo`2/oooo00<0003ooooo
ool04oooo`030000oooooooo02ooool0027oool00`000?ooooooo`05oooo00<0003oooooool0[?oo
o`030000oooooooo01?oool00`000?ooooooo`02oooo00<0003oooooool00_ooo`030000oooooooo
00;oool00`000?ooooooo`0Poooo000Roooo00<0003oooooool00oooo`030000oooooooo0:goool0
0`000?ooooooo`0Boooo00<0003oooooool00_ooo`030000oooo000000Soool00`000?ooooooo`0P
oooo000Roooo00<0003oooooool00oooo`030000oooooooo0:goool00`000?ooooooo`0Aoooo0P00
00Coool00`000?ooo`000008oooo00<0003oooooool08?ooo`008_ooo`030000oooooooo00?oool0
0`000?ooooooo`2^oooo00<0003oooooool04?ooo`030000oooooooo00?oool00`000?ooo`000009
oooo00<0003oooooool07oooo`008_ooo`030000oooooooo00?oool00`000?ooooooo`2^oooo00<0
003oooooool04?ooo`030000oooooooo00?oool00`000?ooo`000007oooo00<0003oool000008Ooo
o`008_ooo`030000oooooooo00?oool00`000?ooooooo`2^oooo00<0003oooooool03oooo`030000
oooooooo00Goool00`000?ooooooo`06oooo0`00027oool002;oool00`000?ooooooo`03oooo00<0
003oooooool0[_ooo`030000oooooooo00koool20000=?ooo`008_ooo`030000oooooooo00?oool0
0`000?ooooooo`2^oooo00<0003oooooool03_ooo`030000oooooooo03?oool002;oool00`000?oo
ooooo`02oooo00<0003oooooool0[oooo`030000oooooooo00koool00`000?ooooooo`0coooo000S
oooo00D0003oooooooooool00000/Oooo`030000oooooooo00goool00`000?ooooooo`0doooo000S
oooo00D0003oooooooooool00000/Oooo`030000oooooooo00goool00`000?ooooooo`0doooo000S
oooo00D0003oooooooooool00000/Oooo`030000oooooooo00coool20000=_ooo`008oooo`050000
oooooooooooo00000;;oool00`000?ooooooo`0;oooo00<0003oooooool0=Oooo`008oooo`050000
oooooooooooo00000;;oool00`000?ooooooo`0:oooo00<0003oooooool0=_ooo`008oooo`050000
oooooooooooo00000;;oool00`000?ooooooo`0:oooo00<0003oooooool0=_ooo`008oooo`050000
oooooooooooo00000;;oool00`000?ooooooo`08oooo0`0003Soool002Coool00`000?ooo`00002c
oooo00<0003oooooool02Oooo`030000oooooooo03Ooool002Coool00`000?ooo`00002coooo00<0
003oooooool02?ooo`030000oooooooo03Soool002Coool00`000?ooo`00002coooo00<0003ooooo
ool02?ooo`030000oooooooo03Soool002Coool00`000?ooo`00002coooo00<0003oooooool01_oo
o`80000koooo000Toooo00<0003oool00000/oooo`030000oooooooo00Ooool00`000?ooooooo`0i
oooo000Toooo00<0003oool00000]?ooo`030000oooooooo00Goool00`000?ooooooo`0joooo000T
oooo00<0003oool00000]?ooo`030000oooooooo00Goool00`000?ooooooo`02oooo00<0003ooooo
ool00_ooo`040000oooooooooooo0P0000Coool00`000?ooooooo`0Voooo000Toooo00<0003oool0
0000]?ooo`030000oooooooo00?oool200001?ooo`030000oooo000000Ooool00`000?ooo`000002
oooo00<0003oool000009oooo`009Oooo`030000oooooooo0;?oool00`000?ooooooo`04oooo00<0
003oooooool00_ooo`030000oooo000000Ooool00`000?ooo`000004oooo00<0003oooooool09Ooo
o`009Oooo`030000oooooooo0;?oool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000
oooo000000Ooool200000oooo`80000Xoooo000Uoooo00<0003oooooool0/oooo`030000oooooooo
00?oool00`000?ooooooo`03oooo00<0003oool000001oooo`030000oooooooo00;oool00`000?oo
ooooo`0Woooo000Uoooo30000:[oool010000?ooooooooooo`800007oooo00<0003oooooool01ooo
o`800002oooo0`0002Ooool0037ooolG0000Toooo`030000oooooooo00;oool00`000?ooooooo`0m
oooo0018oooo5`0007coool01@000?ooooooooooo`000010oooo001Ooooo5`0006Goool01@000?oo
ooooooooo`000010oooo001foooo5P00053oool30000@Oooo`00S?oooaL0000ioooo00<0003oool0
0000@Oooo`00XooooaL0000Roooo0P0004;oool00;[ooolG00002oooo`800012oooo003Aoooo3000
04?oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`00oooo
ob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {241.25, 0}} -> {-0.0029898, -0.00183208, 
  0.00360348, 0.00360348}},
  CellTags->"Aircraft Example"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[51]=",
  CellTags->"Aircraft Example"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{702, 418},
WindowMargins->{{16, Automatic}, {Automatic, 8}},
TaggingRules:>{"NextIndexingNumber" -> 5, "IndexEntries" -> {{"i:1", \
"ParametricManifold"}, {"i:2", "EquilibriumSurface"}, {"i:3", "ExpMap"}, \
{"i:4", "ExpMap"}, {"i:4", "FlowComposition"}, {"i:4", "SpecialNulSpace"}}},
ShowCellTags->True,
StyleDefinitions -> "Textbook.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Introduction"->{
    Cell[2062, 66, 59, 1, 99, "Section",
      CellTags->"Introduction"],
    Cell[2124, 69, 912, 23, 173, "Text",
      CellTags->"Introduction"],
    Cell[3061, 96, 95, 3, 44, "Input",
      CellTags->"Introduction"],
    Cell[3159, 101, 514, 8, 175, "Print",
      CellTags->"Introduction"],
    Cell[167622, 7273, 57, 1, 99, "Section",
      CellTags->"Introduction"],
    Cell[167704, 7278, 57, 1, 54, "Subsection",
      CellTags->"Introduction"],
    Cell[167764, 7281, 354, 6, 73, "Text",
      CellTags->"Introduction"]},
  "Implicit"->{
    Cell[3781, 119, 107, 1, 54, "Subsection",
      CellTags->{"Implicit", "i:1"}],
    Cell[3891, 122, 644, 15, 90, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[4538, 139, 158, 4, 64, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[4699, 145, 128, 3, 39, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[4852, 152, 136, 3, 44, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[4991, 157, 93, 2, 42, "Print",
      CellTags->{"Implicit", "i:1"}],
    Cell[5087, 161, 94, 2, 42, "Print",
      CellTags->{"Implicit", "i:1"}],
    Cell[5184, 165, 175, 4, 54, "Output",
      CellTags->{"Implicit", "i:1"}],
    Cell[5374, 172, 120, 3, 44, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[5497, 177, 81, 1, 39, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[5603, 182, 138, 3, 44, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[5744, 187, 93, 2, 42, "Print",
      CellTags->{"Implicit", "i:1"}],
    Cell[5840, 191, 94, 2, 42, "Print",
      CellTags->{"Implicit", "i:1"}],
    Cell[5937, 195, 260, 6, 54, "Output",
      CellTags->{"Implicit", "i:1"}],
    Cell[6212, 204, 98, 1, 39, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[6335, 209, 344, 7, 104, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[6682, 218, 21701, 803, 200, 9798, 650, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"Implicit", "i:1"}],
    Cell[28386, 1023, 187, 5, 38, "Output",
      CellTags->{"Implicit", "i:1"}],
    Cell[28588, 1031, 184, 4, 39, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[28797, 1039, 410, 8, 104, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[29210, 1049, 24364, 1011, 200, 12681, 861, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"Implicit", "i:1"}],
    Cell[53577, 2062, 187, 5, 38, "Output",
      CellTags->{"Implicit", "i:1"}]},
  "i:1"->{
    Cell[3781, 119, 107, 1, 54, "Subsection",
      CellTags->{"Implicit", "i:1"}],
    Cell[3891, 122, 644, 15, 90, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[4538, 139, 158, 4, 64, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[4699, 145, 128, 3, 39, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[4852, 152, 136, 3, 44, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[4991, 157, 93, 2, 42, "Print",
      CellTags->{"Implicit", "i:1"}],
    Cell[5087, 161, 94, 2, 42, "Print",
      CellTags->{"Implicit", "i:1"}],
    Cell[5184, 165, 175, 4, 54, "Output",
      CellTags->{"Implicit", "i:1"}],
    Cell[5374, 172, 120, 3, 44, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[5497, 177, 81, 1, 39, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[5603, 182, 138, 3, 44, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[5744, 187, 93, 2, 42, "Print",
      CellTags->{"Implicit", "i:1"}],
    Cell[5840, 191, 94, 2, 42, "Print",
      CellTags->{"Implicit", "i:1"}],
    Cell[5937, 195, 260, 6, 54, "Output",
      CellTags->{"Implicit", "i:1"}],
    Cell[6212, 204, 98, 1, 39, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[6335, 209, 344, 7, 104, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[6682, 218, 21701, 803, 200, 9798, 650, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"Implicit", "i:1"}],
    Cell[28386, 1023, 187, 5, 38, "Output",
      CellTags->{"Implicit", "i:1"}],
    Cell[28588, 1031, 184, 4, 39, "Text",
      CellTags->{"Implicit", "i:1"}],
    Cell[28797, 1039, 410, 8, 104, "Input",
      CellTags->{"Implicit", "i:1"}],
    Cell[29210, 1049, 24364, 1011, 200, 12681, 861, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"Implicit", "i:1"}],
    Cell[53577, 2062, 187, 5, 38, "Output",
      CellTags->{"Implicit", "i:1"}]},
  "Equilibrium Surface"->{
    Cell[53813, 2073, 97, 1, 54, "Subsection",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[53913, 2076, 252, 6, 39, "Text",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[54168, 2084, 133, 3, 44, "Input",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[54304, 2089, 135, 3, 39, "Text",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[54464, 2096, 203, 5, 44, "Input",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[54670, 2103, 104, 2, 42, "Print",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[54777, 2107, 105, 2, 42, "Print",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[54885, 2111, 188, 4, 38, "Output",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[55088, 2118, 233, 5, 56, "Text",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[55346, 2127, 566, 10, 144, "Input",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[55915, 2139, 111267, 5114, 186, 92695, 4879, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[167185, 7255, 201, 5, 38, "Output",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[167401, 7263, 172, 4, 39, "Text",
      CellTags->{"Equilibrium Surface", "i:2"}]},
  "i:2"->{
    Cell[53813, 2073, 97, 1, 54, "Subsection",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[53913, 2076, 252, 6, 39, "Text",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[54168, 2084, 133, 3, 44, "Input",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[54304, 2089, 135, 3, 39, "Text",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[54464, 2096, 203, 5, 44, "Input",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[54670, 2103, 104, 2, 42, "Print",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[54777, 2107, 105, 2, 42, "Print",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[54885, 2111, 188, 4, 38, "Output",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[55088, 2118, 233, 5, 56, "Text",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[55346, 2127, 566, 10, 144, "Input",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[55915, 2139, 111267, 5114, 186, 92695, 4879, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[167185, 7255, 201, 5, 38, "Output",
      CellTags->{"Equilibrium Surface", "i:2"}],
    Cell[167401, 7263, 172, 4, 39, "Text",
      CellTags->{"Equilibrium Surface", "i:2"}]},
  "Exponential Map"->{
    Cell[168155, 7292, 81, 1, 54, "Subsection",
      CellTags->{"Exponential Map", "i:3"}],
    Cell[168239, 7295, 202, 6, 39, "Text",
      CellTags->{"Exponential Map", "i:3"}],
    Cell[168444, 7303, 126, 5, 66, "Input",
      CellTags->{"Exponential Map", "i:3"}],
    Cell[168573, 7310, 134, 3, 39, "Text",
      CellTags->{"Exponential Map", "i:3"}],
    Cell[168732, 7317, 102, 2, 46, "Input",
      CellTags->{"Exponential Map", "i:3"}],
    Cell[168837, 7321, 1090, 19, 268, "Output",
      CellTags->{"Exponential Map", "i:3"}]},
  "i:3"->{
    Cell[168155, 7292, 81, 1, 54, "Subsection",
      CellTags->{"Exponential Map", "i:3"}],
    Cell[168239, 7295, 202, 6, 39, "Text",
      CellTags->{"Exponential Map", "i:3"}],
    Cell[168444, 7303, 126, 5, 66, "Input",
      CellTags->{"Exponential Map", "i:3"}],
    Cell[168573, 7310, 134, 3, 39, "Text",
      CellTags->{"Exponential Map", "i:3"}],
    Cell[168732, 7317, 102, 2, 46, "Input",
      CellTags->{"Exponential Map", "i:3"}],
    Cell[168837, 7321, 1090, 19, 268, "Output",
      CellTags->{"Exponential Map", "i:3"}]},
  "Composition"->{
    Cell[169976, 7346, 91, 1, 48, "Subsection",
      CellTags->{"Composition", "i:4"}],
    Cell[170092, 7351, 103, 3, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[170198, 7356, 578, 8, 194, "Print",
      CellTags->{"Composition", "i:4"}],
    Cell[170813, 7369, 107, 3, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[170923, 7374, 108, 3, 38, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[171068, 7382, 76, 1, 51, "Subsubsection",
      CellTags->{"Composition", "i:4"}],
    Cell[171169, 7387, 113, 3, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[171285, 7392, 662, 10, 232, "Print",
      CellTags->{"Composition", "i:4"}],
    Cell[171996, 7408, 70, 1, 51, "Subsubsection",
      CellTags->{"Composition", "i:4"}],
    Cell[172069, 7411, 200, 4, 56, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[172294, 7419, 178, 4, 64, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[172475, 7425, 114, 2, 42, "Print",
      CellTags->{"Composition", "i:4"}],
    Cell[172592, 7429, 119, 3, 38, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[172748, 7437, 122, 3, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[172873, 7442, 140, 3, 38, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[173050, 7450, 218, 4, 64, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[173271, 7456, 171, 4, 38, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[173445, 7462, 120, 3, 38, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[173580, 7468, 97, 1, 39, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[173702, 7473, 171, 4, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[173876, 7479, 123, 3, 38, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[174014, 7485, 81, 1, 39, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[174120, 7490, 161, 4, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[174284, 7496, 123, 3, 38, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[174422, 7502, 122, 3, 39, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[174547, 7507, 147, 4, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[174719, 7515, 121, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[174843, 7519, 124, 3, 38, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[175016, 7528, 70, 1, 51, "Subsubsection",
      CellTags->{"Composition", "i:4"}],
    Cell[175089, 7531, 222, 5, 56, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[175314, 7538, 118, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[175457, 7544, 111, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[175571, 7548, 172, 4, 38, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[175780, 7557, 111, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[175894, 7561, 341, 7, 91, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[176250, 7571, 92, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[176367, 7577, 123, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[176493, 7581, 165, 4, 54, "Output",
      CellTags->{"Composition", "i:4"}]},
  "i:4"->{
    Cell[169976, 7346, 91, 1, 48, "Subsection",
      CellTags->{"Composition", "i:4"}],
    Cell[170092, 7351, 103, 3, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[170198, 7356, 578, 8, 194, "Print",
      CellTags->{"Composition", "i:4"}],
    Cell[170813, 7369, 107, 3, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[170923, 7374, 108, 3, 38, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[171068, 7382, 76, 1, 51, "Subsubsection",
      CellTags->{"Composition", "i:4"}],
    Cell[171169, 7387, 113, 3, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[171285, 7392, 662, 10, 232, "Print",
      CellTags->{"Composition", "i:4"}],
    Cell[171996, 7408, 70, 1, 51, "Subsubsection",
      CellTags->{"Composition", "i:4"}],
    Cell[172069, 7411, 200, 4, 56, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[172294, 7419, 178, 4, 64, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[172475, 7425, 114, 2, 42, "Print",
      CellTags->{"Composition", "i:4"}],
    Cell[172592, 7429, 119, 3, 38, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[172748, 7437, 122, 3, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[172873, 7442, 140, 3, 38, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[173050, 7450, 218, 4, 64, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[173271, 7456, 171, 4, 38, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[173445, 7462, 120, 3, 38, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[173580, 7468, 97, 1, 39, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[173702, 7473, 171, 4, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[173876, 7479, 123, 3, 38, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[174014, 7485, 81, 1, 39, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[174120, 7490, 161, 4, 44, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[174284, 7496, 123, 3, 38, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[174422, 7502, 122, 3, 39, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[174547, 7507, 147, 4, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[174719, 7515, 121, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[174843, 7519, 124, 3, 38, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[175016, 7528, 70, 1, 51, "Subsubsection",
      CellTags->{"Composition", "i:4"}],
    Cell[175089, 7531, 222, 5, 56, "Text",
      CellTags->{"Composition", "i:4"}],
    Cell[175314, 7538, 118, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[175457, 7544, 111, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[175571, 7548, 172, 4, 38, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[175780, 7557, 111, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[175894, 7561, 341, 7, 91, "Output",
      CellTags->{"Composition", "i:4"}],
    Cell[176250, 7571, 92, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[176367, 7577, 123, 2, 46, "Input",
      CellTags->{"Composition", "i:4"}],
    Cell[176493, 7581, 165, 4, 54, "Output",
      CellTags->{"Composition", "i:4"}]},
  "Pitfalls"->{
    Cell[176731, 7593, 56, 1, 99, "Section",
      CellTags->"Pitfalls"],
    Cell[176812, 7598, 95, 1, 54, "Subsection",
      CellTags->"Pitfalls"],
    Cell[176910, 7601, 93, 3, 44, "Input",
      CellTags->"Pitfalls"],
    Cell[177006, 7606, 129, 3, 64, "Input",
      CellTags->"Pitfalls"],
    Cell[177138, 7611, 230, 5, 56, "Text",
      CellTags->"Pitfalls"],
    Cell[177393, 7620, 252, 6, 64, "Input",
      CellTags->"Pitfalls"],
    Cell[177648, 7628, 21224, 690, 200, 7519, 515, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Pitfalls"],
    Cell[198875, 8320, 179, 5, 38, "Output",
      CellTags->"Pitfalls"],
    Cell[199069, 8328, 139, 4, 39, "Text",
      CellTags->"Pitfalls"],
    Cell[199233, 8336, 86, 3, 44, "Input",
      CellTags->"Pitfalls"],
    Cell[199322, 8341, 89, 3, 38, "Output",
      CellTags->"Pitfalls"],
    Cell[199448, 8349, 127, 3, 44, "Input",
      CellTags->"Pitfalls"],
    Cell[199578, 8354, 84, 2, 42, "Print",
      CellTags->"Pitfalls"],
    Cell[199665, 8358, 85, 2, 42, "Print",
      CellTags->"Pitfalls"],
    Cell[199753, 8362, 161, 4, 54, "Output",
      CellTags->"Pitfalls"],
    Cell[199929, 8369, 91, 1, 39, "Text",
      CellTags->"Pitfalls"],
    Cell[200045, 8374, 127, 3, 44, "Input",
      CellTags->"Pitfalls"],
    Cell[200175, 8379, 85, 2, 42, "Print",
      CellTags->"Pitfalls"],
    Cell[200263, 8383, 84, 2, 42, "Print",
      CellTags->"Pitfalls"],
    Cell[200350, 8387, 113, 2, 42, "Print",
      CellTags->"Pitfalls"],
    Cell[200466, 8391, 85, 2, 42, "Print",
      CellTags->"Pitfalls"],
    Cell[200554, 8395, 104, 2, 42, "Print",
      CellTags->"Pitfalls"],
    Cell[200661, 8399, 97, 3, 38, "Output",
      CellTags->"Pitfalls"],
    Cell[200807, 8408, 85, 1, 54, "Subsection",
      CellTags->"Pitfalls"],
    Cell[200895, 8411, 130, 4, 39, "Text",
      CellTags->"Pitfalls"],
    Cell[201028, 8417, 115, 3, 44, "Input",
      CellTags->"Pitfalls"],
    Cell[201168, 8424, 123, 3, 44, "Input",
      CellTags->"Pitfalls"],
    Cell[201294, 8429, 85, 2, 42, "Print",
      CellTags->"Pitfalls"],
    Cell[201382, 8433, 84, 2, 42, "Print",
      CellTags->"Pitfalls"],
    Cell[201469, 8437, 85, 2, 42, "Print",
      CellTags->"Pitfalls"],
    Cell[201557, 8441, 104, 3, 38, "Output",
      CellTags->"Pitfalls"],
    Cell[201698, 8449, 117, 3, 44, "Input",
      CellTags->"Pitfalls"],
    Cell[201818, 8454, 114, 3, 38, "Output",
      CellTags->"Pitfalls"],
    Cell[201969, 8462, 136, 3, 44, "Input",
      CellTags->"Pitfalls"],
    Cell[202108, 8467, 85, 2, 42, "Print",
      CellTags->"Pitfalls"],
    Cell[202196, 8471, 84, 2, 42, "Print",
      CellTags->"Pitfalls"],
    Cell[202283, 8475, 85, 2, 42, "Print",
      CellTags->"Pitfalls"],
    Cell[202371, 8479, 112, 3, 38, "Output",
      CellTags->"Pitfalls"]},
  "Aircraft Example"->{
    Cell[202610, 8493, 90, 1, 54, "Subsection",
      CellTags->"Aircraft Example"],
    Cell[202725, 8498, 100, 3, 44, "Input",
      CellTags->"Aircraft Example"],
    Cell[202828, 8503, 518, 8, 175, "Print",
      CellTags->"Aircraft Example"],
    Cell[203361, 8514, 952, 22, 196, "Input",
      CellTags->"Aircraft Example"],
    Cell[204338, 8540, 235, 6, 84, "Input",
      CellTags->"Aircraft Example"],
    Cell[204576, 8548, 92, 2, 42, "Print",
      CellTags->"Aircraft Example"],
    Cell[204671, 8552, 93, 2, 42, "Print",
      CellTags->"Aircraft Example"],
    Cell[204767, 8556, 3160, 61, 190, "Output",
      CellTags->"Aircraft Example"],
    Cell[207964, 8622, 481, 9, 124, "Input",
      CellTags->"Aircraft Example"],
    Cell[208448, 8633, 136672, 5568, 265, 92530, 5017, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Aircraft Example"],
    Cell[345123, 14203, 189, 5, 38, "Output",
      CellTags->"Aircraft Example"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Introduction", 346248, 14235},
  {"Implicit", 346795, 14250},
  {"i:1", 348666, 14297},
  {"Equilibrium Surface", 350553, 14344},
  {"i:2", 351825, 14372},
  {"Exponential Map", 353109, 14400},
  {"i:3", 353661, 14413},
  {"Composition", 354221, 14426},
  {"i:4", 357494, 14503},
  {"Pitfalls", 360772, 14580},
  {"Aircraft Example", 363621, 14658}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 55, 0, 59, "Title"],
Cell[1797, 53, 35, 0, 33, "Subtitle"],
Cell[1835, 55, 97, 3, 50, "Subsubtitle"],
Cell[1935, 60, 102, 2, 50, "Input"],

Cell[CellGroupData[{
Cell[2062, 66, 59, 1, 99, "Section",
  CellTags->"Introduction"],
Cell[2124, 69, 912, 23, 173, "Text",
  CellTags->"Introduction"],

Cell[CellGroupData[{
Cell[3061, 96, 95, 3, 44, "Input",
  CellTags->"Introduction"],
Cell[3159, 101, 514, 8, 175, "Print",
  CellTags->"Introduction"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[3722, 115, 34, 0, 85, "Section"],

Cell[CellGroupData[{
Cell[3781, 119, 107, 1, 54, "Subsection",
  CellTags->{"Implicit", "i:1"}],
Cell[3891, 122, 644, 15, 90, "Text",
  CellTags->{"Implicit", "i:1"}],
Cell[4538, 139, 158, 4, 64, "Input",
  CellTags->{"Implicit", "i:1"}],
Cell[4699, 145, 128, 3, 39, "Text",
  CellTags->{"Implicit", "i:1"}],

Cell[CellGroupData[{
Cell[4852, 152, 136, 3, 44, "Input",
  CellTags->{"Implicit", "i:1"}],
Cell[4991, 157, 93, 2, 42, "Print",
  CellTags->{"Implicit", "i:1"}],
Cell[5087, 161, 94, 2, 42, "Print",
  CellTags->{"Implicit", "i:1"}],
Cell[5184, 165, 175, 4, 54, "Output",
  CellTags->{"Implicit", "i:1"}]
}, Open  ]],
Cell[5374, 172, 120, 3, 44, "Input",
  CellTags->{"Implicit", "i:1"}],
Cell[5497, 177, 81, 1, 39, "Text",
  CellTags->{"Implicit", "i:1"}],

Cell[CellGroupData[{
Cell[5603, 182, 138, 3, 44, "Input",
  CellTags->{"Implicit", "i:1"}],
Cell[5744, 187, 93, 2, 42, "Print",
  CellTags->{"Implicit", "i:1"}],
Cell[5840, 191, 94, 2, 42, "Print",
  CellTags->{"Implicit", "i:1"}],
Cell[5937, 195, 260, 6, 54, "Output",
  CellTags->{"Implicit", "i:1"}]
}, Open  ]],
Cell[6212, 204, 98, 1, 39, "Text",
  CellTags->{"Implicit", "i:1"}],

Cell[CellGroupData[{
Cell[6335, 209, 344, 7, 104, "Input",
  CellTags->{"Implicit", "i:1"}],
Cell[6682, 218, 21701, 803, 200, 9798, 650, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->{"Implicit", "i:1"}],
Cell[28386, 1023, 187, 5, 38, "Output",
  CellTags->{"Implicit", "i:1"}]
}, Open  ]],
Cell[28588, 1031, 184, 4, 39, "Text",
  CellTags->{"Implicit", "i:1"}],

Cell[CellGroupData[{
Cell[28797, 1039, 410, 8, 104, "Input",
  CellTags->{"Implicit", "i:1"}],
Cell[29210, 1049, 24364, 1011, 200, 12681, 861, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->{"Implicit", "i:1"}],
Cell[53577, 2062, 187, 5, 38, "Output",
  CellTags->{"Implicit", "i:1"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[53813, 2073, 97, 1, 54, "Subsection",
  CellTags->{"Equilibrium Surface", "i:2"}],
Cell[53913, 2076, 252, 6, 39, "Text",
  CellTags->{"Equilibrium Surface", "i:2"}],
Cell[54168, 2084, 133, 3, 44, "Input",
  CellTags->{"Equilibrium Surface", "i:2"}],
Cell[54304, 2089, 135, 3, 39, "Text",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell[CellGroupData[{
Cell[54464, 2096, 203, 5, 44, "Input",
  CellTags->{"Equilibrium Surface", "i:2"}],
Cell[54670, 2103, 104, 2, 42, "Print",
  CellTags->{"Equilibrium Surface", "i:2"}],
Cell[54777, 2107, 105, 2, 42, "Print",
  CellTags->{"Equilibrium Surface", "i:2"}],
Cell[54885, 2111, 188, 4, 38, "Output",
  CellTags->{"Equilibrium Surface", "i:2"}]
}, Open  ]],
Cell[55088, 2118, 233, 5, 56, "Text",
  CellTags->{"Equilibrium Surface", "i:2"}],

Cell[CellGroupData[{
Cell[55346, 2127, 566, 10, 144, "Input",
  CellTags->{"Equilibrium Surface", "i:2"}],
Cell[55915, 2139, 111267, 5114, 186, 92695, 4879, "GraphicsData", \
"PostScript", "Graphics",
  CellTags->{"Equilibrium Surface", "i:2"}],
Cell[167185, 7255, 201, 5, 38, "Output",
  CellTags->{"Equilibrium Surface", "i:2"}]
}, Open  ]],
Cell[167401, 7263, 172, 4, 39, "Text",
  CellTags->{"Equilibrium Surface", "i:2"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[167622, 7273, 57, 1, 99, "Section",
  CellTags->"Introduction"],

Cell[CellGroupData[{
Cell[167704, 7278, 57, 1, 54, "Subsection",
  CellTags->"Introduction"],
Cell[167764, 7281, 354, 6, 73, "Text",
  CellTags->"Introduction"]
}, Open  ]],

Cell[CellGroupData[{
Cell[168155, 7292, 81, 1, 54, "Subsection",
  CellTags->{"Exponential Map", "i:3"}],
Cell[168239, 7295, 202, 6, 39, "Text",
  CellTags->{"Exponential Map", "i:3"}],
Cell[168444, 7303, 126, 5, 66, "Input",
  CellTags->{"Exponential Map", "i:3"}],
Cell[168573, 7310, 134, 3, 39, "Text",
  CellTags->{"Exponential Map", "i:3"}],

Cell[CellGroupData[{
Cell[168732, 7317, 102, 2, 46, "Input",
  CellTags->{"Exponential Map", "i:3"}],
Cell[168837, 7321, 1090, 19, 268, "Output",
  CellTags->{"Exponential Map", "i:3"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[169976, 7346, 91, 1, 48, "Subsection",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{
Cell[170092, 7351, 103, 3, 44, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[170198, 7356, 578, 8, 194, "Print",
  CellTags->{"Composition", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[170813, 7369, 107, 3, 44, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[170923, 7374, 108, 3, 38, "Output",
  CellTags->{"Composition", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[171068, 7382, 76, 1, 51, "Subsubsection",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{
Cell[171169, 7387, 113, 3, 44, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[171285, 7392, 662, 10, 232, "Print",
  CellTags->{"Composition", "i:4"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[171996, 7408, 70, 1, 51, "Subsubsection",
  CellTags->{"Composition", "i:4"}],
Cell[172069, 7411, 200, 4, 56, "Text",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{
Cell[172294, 7419, 178, 4, 64, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[172475, 7425, 114, 2, 42, "Print",
  CellTags->{"Composition", "i:4"}],
Cell[172592, 7429, 119, 3, 38, "Output",
  CellTags->{"Composition", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[172748, 7437, 122, 3, 44, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[172873, 7442, 140, 3, 38, "Output",
  CellTags->{"Composition", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[173050, 7450, 218, 4, 64, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[173271, 7456, 171, 4, 38, "Output",
  CellTags->{"Composition", "i:4"}],
Cell[173445, 7462, 120, 3, 38, "Output",
  CellTags->{"Composition", "i:4"}]
}, Open  ]],
Cell[173580, 7468, 97, 1, 39, "Text",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{
Cell[173702, 7473, 171, 4, 44, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[173876, 7479, 123, 3, 38, "Output",
  CellTags->{"Composition", "i:4"}]
}, Open  ]],
Cell[174014, 7485, 81, 1, 39, "Text",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{
Cell[174120, 7490, 161, 4, 44, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[174284, 7496, 123, 3, 38, "Output",
  CellTags->{"Composition", "i:4"}]
}, Open  ]],
Cell[174422, 7502, 122, 3, 39, "Text",
  CellTags->{"Composition", "i:4"}],
Cell[174547, 7507, 147, 4, 46, "Input",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{
Cell[174719, 7515, 121, 2, 46, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[174843, 7519, 124, 3, 38, "Output",
  CellTags->{"Composition", "i:4"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[175016, 7528, 70, 1, 51, "Subsubsection",
  CellTags->{"Composition", "i:4"}],
Cell[175089, 7531, 222, 5, 56, "Text",
  CellTags->{"Composition", "i:4"}],
Cell[175314, 7538, 118, 2, 46, "Input",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{
Cell[175457, 7544, 111, 2, 46, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[175571, 7548, 172, 4, 38, "Output",
  CellTags->{"Composition", "i:4"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[175780, 7557, 111, 2, 46, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[175894, 7561, 341, 7, 91, "Output",
  CellTags->{"Composition", "i:4"}]
}, Open  ]],
Cell[176250, 7571, 92, 2, 46, "Input",
  CellTags->{"Composition", "i:4"}],

Cell[CellGroupData[{
Cell[176367, 7577, 123, 2, 46, "Input",
  CellTags->{"Composition", "i:4"}],
Cell[176493, 7581, 165, 4, 54, "Output",
  CellTags->{"Composition", "i:4"}]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[176731, 7593, 56, 1, 99, "Section",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{
Cell[176812, 7598, 95, 1, 54, "Subsection",
  CellTags->"Pitfalls"],
Cell[176910, 7601, 93, 3, 44, "Input",
  CellTags->"Pitfalls"],
Cell[177006, 7606, 129, 3, 64, "Input",
  CellTags->"Pitfalls"],
Cell[177138, 7611, 230, 5, 56, "Text",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{
Cell[177393, 7620, 252, 6, 64, "Input",
  CellTags->"Pitfalls"],
Cell[177648, 7628, 21224, 690, 200, 7519, 515, "GraphicsData", "PostScript", \
"Graphics",
  CellTags->"Pitfalls"],
Cell[198875, 8320, 179, 5, 38, "Output",
  CellTags->"Pitfalls"]
}, Open  ]],
Cell[199069, 8328, 139, 4, 39, "Text",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{
Cell[199233, 8336, 86, 3, 44, "Input",
  CellTags->"Pitfalls"],
Cell[199322, 8341, 89, 3, 38, "Output",
  CellTags->"Pitfalls"]
}, Open  ]],

Cell[CellGroupData[{
Cell[199448, 8349, 127, 3, 44, "Input",
  CellTags->"Pitfalls"],
Cell[199578, 8354, 84, 2, 42, "Print",
  CellTags->"Pitfalls"],
Cell[199665, 8358, 85, 2, 42, "Print",
  CellTags->"Pitfalls"],
Cell[199753, 8362, 161, 4, 54, "Output",
  CellTags->"Pitfalls"]
}, Open  ]],
Cell[199929, 8369, 91, 1, 39, "Text",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{
Cell[200045, 8374, 127, 3, 44, "Input",
  CellTags->"Pitfalls"],
Cell[200175, 8379, 85, 2, 42, "Print",
  CellTags->"Pitfalls"],
Cell[200263, 8383, 84, 2, 42, "Print",
  CellTags->"Pitfalls"],
Cell[200350, 8387, 113, 2, 42, "Print",
  CellTags->"Pitfalls"],
Cell[200466, 8391, 85, 2, 42, "Print",
  CellTags->"Pitfalls"],
Cell[200554, 8395, 104, 2, 42, "Print",
  CellTags->"Pitfalls"],
Cell[200661, 8399, 97, 3, 38, "Output",
  CellTags->"Pitfalls"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[200807, 8408, 85, 1, 54, "Subsection",
  CellTags->"Pitfalls"],
Cell[200895, 8411, 130, 4, 39, "Text",
  CellTags->"Pitfalls"],
Cell[201028, 8417, 115, 3, 44, "Input",
  CellTags->"Pitfalls"],

Cell[CellGroupData[{
Cell[201168, 8424, 123, 3, 44, "Input",
  CellTags->"Pitfalls"],
Cell[201294, 8429, 85, 2, 42, "Print",
  CellTags->"Pitfalls"],
Cell[201382, 8433, 84, 2, 42, "Print",
  CellTags->"Pitfalls"],
Cell[201469, 8437, 85, 2, 42, "Print",
  CellTags->"Pitfalls"],
Cell[201557, 8441, 104, 3, 38, "Output",
  CellTags->"Pitfalls"]
}, Open  ]],

Cell[CellGroupData[{
Cell[201698, 8449, 117, 3, 44, "Input",
  CellTags->"Pitfalls"],
Cell[201818, 8454, 114, 3, 38, "Output",
  CellTags->"Pitfalls"]
}, Open  ]],

Cell[CellGroupData[{
Cell[201969, 8462, 136, 3, 44, "Input",
  CellTags->"Pitfalls"],
Cell[202108, 8467, 85, 2, 42, "Print",
  CellTags->"Pitfalls"],
Cell[202196, 8471, 84, 2, 42, "Print",
  CellTags->"Pitfalls"],
Cell[202283, 8475, 85, 2, 42, "Print",
  CellTags->"Pitfalls"],
Cell[202371, 8479, 112, 3, 38, "Output",
  CellTags->"Pitfalls"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[202544, 8489, 41, 0, 53, "Section"],

Cell[CellGroupData[{
Cell[202610, 8493, 90, 1, 54, "Subsection",
  CellTags->"Aircraft Example"],

Cell[CellGroupData[{
Cell[202725, 8498, 100, 3, 44, "Input",
  CellTags->"Aircraft Example"],
Cell[202828, 8503, 518, 8, 175, "Print",
  CellTags->"Aircraft Example"]
}, Open  ]],
Cell[203361, 8514, 952, 22, 196, "Input",
  CellTags->"Aircraft Example"],

Cell[CellGroupData[{
Cell[204338, 8540, 235, 6, 84, "Input",
  CellTags->"Aircraft Example"],
Cell[204576, 8548, 92, 2, 42, "Print",
  CellTags->"Aircraft Example"],
Cell[204671, 8552, 93, 2, 42, "Print",
  CellTags->"Aircraft Example"],
Cell[204767, 8556, 3160, 61, 190, "Output",
  CellTags->"Aircraft Example"]
}, Open  ]],

Cell[CellGroupData[{
Cell[207964, 8622, 481, 9, 124, "Input",
  CellTags->"Aircraft Example"],
Cell[208448, 8633, 136672, 5568, 265, 92530, 5017, "GraphicsData", \
"PostScript", "Graphics",
  CellTags->"Aircraft Example"],
Cell[345123, 14203, 189, 5, 38, "Output",
  CellTags->"Aircraft Example"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

