(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     69406,       2790]*)
(*NotebookOutlinePosition[     71682,       2855]*)
(*  CellTagsIndexPosition[     71397,       2843]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  PageWidth->WindowWidth,
  ShowCellBracket->False,
  CellLabelMargins->{{10, Inherited}, {Inherited, Inherited}},
  ScriptMinSize->9],

Cell[StyleData[All, "AllBrackets"],
  PageWidth->WindowWidth,
  ShowCellBracket->True,
  ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  ShowCellBracket->False,
  CellLabelMargins->{{2, Inherited}, {Inherited, Inherited}},
  ScriptMinSize->5,
  PrivateFontOptions->{"FontType"->"Outline"}],

Cell[StyleData[All, "EnhancedPrintout"],
  PageWidth->PaperWidth,
  ShowCellBracket->False,
  CellLabelMargins->{{2, Inherited}, {Inherited, Inherited}},
  ScriptMinSize->5,
  PrivateFontOptions->{"FontType"->"Outline"}],

Cell[StyleData[All, "EnhancedPrintoutNonGray"],
  PageWidth->PaperWidth,
  ShowCellBracket->False,
  CellLabelMargins->{{2, Inherited}, {Inherited, Inherited}},
  ScriptMinSize->5,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PrintingStyleEnvironment->"Printout",
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  PrintingOptions->{"PrintingMargins"->{{97, 97}, {180, 64}},
  "FirstPageHeader"->False,
  "FacingPages"->True},
  CellLabelAutoDelete->False,
  CellFrameLabelMargins->6,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellMargins->{{12, Inherited}, {20, 40}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakAbove->True,
  PageBreakBelow->False,
  LineSpacing->{1, 11},
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->36,
  FontWeight->"Bold"],

Cell[StyleData["Title", "Printout"],
  CellMargins->{{2, 10}, {15, 30}},
  FontSize->30],

Cell[StyleData["Title", "EnhancedPrintout"],
  CellMargins->{{2, 10}, {15, 30}},
  FontFamily->"Futura",
  FontSize->30],

Cell[StyleData["Title", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 10}, {15, 30}},
  FontFamily->"Futura",
  FontSize->30]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{12, Inherited}, {10, 2}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  LineSpacing->{1, 11},
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  FontFamily->"Helvetica",
  FontSize->28],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{2, 10}, {10, 15}},
  FontSize->24],

Cell[StyleData["Subtitle", "EnhancedPrintout"],
  CellMargins->{{2, 10}, {10, 15}},
  FontFamily->"Futura",
  FontSize->24],

Cell[StyleData["Subtitle", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 10}, {10, 15}},
  FontFamily->"Futura",
  FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  CellMargins->{{12, Inherited}, {10, 20}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Printout"],
  CellMargins->{{2, 10}, {8, 10}},
  FontSize->12],

Cell[StyleData["Subsubtitle", "EnhancedPrintout"],
  CellMargins->{{2, 10}, {8, 10}},
  FontFamily->"Futura",
  FontSize->12],

Cell[StyleData["Subsubtitle", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 10}, {8, 10}},
  FontFamily->"Futura",
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellFrame->{{0, 0}, {0.5, 0}},
  CellMargins->{{10, Inherited}, {8, 30}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameMargins->8,
  LineSpacing->{1, 7},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->20,
  FontWeight->"Bold",
  CellTags->"Section"],

Cell[StyleData["Section", "Printout"],
  CellMargins->{{2, 0}, {7, 24}},
  FontSize->16],

Cell[StyleData["Section", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {7, 24}},
  FontFamily->"Futura",
  FontSize->16],

Cell[StyleData["Section", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {7, 24}},
  FontFamily->"Futura",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{24, Inherited}, {8, 30}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontWeight->"Bold",
  CellTags->"Subsection"],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{9, 0}, {7, 24}},
  FontSize->12],

Cell[StyleData["Subsection", "EnhancedPrintout"],
  CellMargins->{{9, 0}, {7, 24}},
  FontFamily->"Futura",
  FontSize->14],

Cell[StyleData["Subsection", "EnhancedPrintoutNonGray"],
  CellMargins->{{9, 0}, {7, 24}},
  FontFamily->"Futura",
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellMargins->{{12, Inherited}, {8, 24}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection",
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  CellTags->"Subsubsection"],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{2, 0}, {7, 18}},
  FontSize->10],

Cell[StyleData["Subsubsection", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {7, 18}},
  FontFamily->"Futura",
  FontSize->10],

Cell[StyleData["Subsubsection", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {7, 18}},
  FontFamily->"Futura",
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{12, 10}, {7, 7}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0.7, 0},
  CounterIncrements->"Text"],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  FontSize->11],

Cell[StyleData["Text", "EnhancedPrintout"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["Text", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 2}, {6, 6}},
  TextJustification->1,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SmallText"],
  CellMargins->{{12, 10}, {6, 6}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0.7, 0},
  CounterIncrements->"SmallText",
  FontSize->9],

Cell[StyleData["SmallText", "Printout"],
  CellMargins->{{2, 2}, {5, 5}},
  TextJustification->1,
  FontSize->7],

Cell[StyleData["SmallText", "EnhancedPrintout"],
  CellMargins->{{2, 2}, {5, 5}},
  TextJustification->1,
  FontFamily->"Palatino",
  FontSize->7],

Cell[StyleData["SmallText", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 2}, {5, 5}},
  TextJustification->1,
  FontFamily->"Palatino",
  FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CopyrightText"],
  CellMargins->{{10, 4}, {0, 8}},
  ParagraphSpacing->{0, 0},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10],

Cell[StyleData["CopyrightText", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  ShowCellBracket->True,
  CellMargins->{{45, 10}, {5, 7}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[StyleData["Input", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{39, 0}, {4, 6}},
  FontSize->9],

Cell[StyleData["Input", "EnhancedPrintout"],
  ShowCellBracket->False,
  CellMargins->{{39, 0}, {4, 6}},
  FontSize->9],

Cell[StyleData["Input", "EnhancedPrintoutNonGray"],
  ShowCellBracket->False,
  CellMargins->{{39, 0}, {4, 6}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  ShowCellBracket->True,
  CellMargins->{{46, 10}, {7, 5}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Output"],

Cell[StyleData["Output", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{39, 0}, {6, 4}},
  FontSize->9],

Cell[StyleData["Output", "EnhancedPrintout"],
  ShowCellBracket->False,
  CellMargins->{{39, 0}, {6, 4}},
  FontSize->9],

Cell[StyleData["Output", "EnhancedPrintoutNonGray"],
  ShowCellBracket->False,
  CellMargins->{{39, 0}, {6, 4}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  ShowCellBracket->True,
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 0]],

Cell[StyleData["Message", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->9,
  FontColor->GrayLevel[0]],

Cell[StyleData["Message", "EnhancedPrintout"],
  ShowCellBracket->False,
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontFamily->"Courier",
  FontSize->9,
  FontColor->GrayLevel[0]],

Cell[StyleData["Message", "EnhancedPrintoutNonGray"],
  ShowCellBracket->False,
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontFamily->"Courier",
  FontSize->9,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  ShowCellBracket->True,
  CellMargins->{{75, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None],

Cell[StyleData["Print", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{57, Inherited}, {Inherited, Inherited}},
  FontSize->9],

Cell[StyleData["Print", "EnhancedPrintout"],
  ShowCellBracket->False,
  CellMargins->{{57, Inherited}, {Inherited, Inherited}},
  FontFamily->"Courier",
  FontSize->9],

Cell[StyleData["Print", "EnhancedPrintoutNonGray"],
  ShowCellBracket->False,
  CellMargins->{{57, Inherited}, {Inherited, Inherited}},
  FontFamily->"Courier",
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  ShowCellBracket->True,
  CellMargins->{{47, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  StyleMenuListing->None],

Cell[StyleData["Graphics", "Printout"],
  ShowCellBracket->False,
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  ImageSize->{250, 250},
  FontSize->9],

Cell[StyleData["Graphics", "EnhancedPrintout"],
  ShowCellBracket->False,
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  ImageSize->{250, 250},
  FontFamily->"Courier",
  FontSize->9],

Cell[StyleData["Graphics", "EnhancedPrintoutNonGray"],
  ShowCellBracket->False,
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  ImageSize->{250, 250},
  FontFamily->"Courier",
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["CellLabel", "Printout"],
  FontFamily->"Courier",
  FontSize->8,
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],

Cell[StyleData["CellLabel", "EnhancedPrintout"],
  FontFamily->"Courier",
  FontSize->8,
  FontSlant->"Italic",
  FontColor->GrayLevel[0]],

Cell[StyleData["CellLabel", "EnhancedPrintoutNonGray"],
  FontFamily->"Courier",
  FontSize->8,
  FontSlant->"Italic",
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Formatting", "Section"],

Cell["\<\
These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.\
\>", "Text"],

Cell[StyleData["RM"],
  StyleMenuListing->None,
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["BF"],
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[StyleData["IT"],
  StyleMenuListing->None,
  FontSlant->"Italic"],

Cell[StyleData["TR"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["TI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["TB"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["TBI"],
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["MR"],
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["MO"],
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["MB"],
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["MBO"],
  StyleMenuListing->None,
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[StyleData["SR"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Plain"],

Cell[StyleData["SO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SB"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Plain"],

Cell[StyleData["SBO"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[StyleData["SO10"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SO10", "Printout"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->7,
  FontWeight->"Plain",
  FontSlant->"Italic"],

Cell[StyleData["SO10", "EnhancedPrintout"],
  StyleMenuListing->None,
  FontFamily->"Futura",
  FontSize->7,
  FontWeight->"Plain",
  FontSlant->"Italic"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Miscellaneous Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["MathCaption"],
  CellDingbat->"\[FilledSmallSquare]",
  CellMargins->{{46, 42}, {0, 14}},
  PageBreakBelow->False,
  LineSpacing->{1, 1},
  ParagraphSpacing->{0, 8},
  FontColor->RGBColor[0, 0, 0.6]],

Cell[StyleData["MathCaption", "Printout"],
  CellMargins->{{42, 42}, {0, 14}},
  FontSize->10,
  FontColor->GrayLevel[0]],

Cell[StyleData["MathCaption", "EnhancedPrintout"],
  CellMargins->{{42, 42}, {0, 14}},
  FontFamily->"Palatino",
  FontSize->10,
  FontColor->GrayLevel[0]],

Cell[StyleData["MathCaption", "EnhancedPrintoutNonGray"],
  CellMargins->{{42, 42}, {0, 14}},
  FontFamily->"Palatino",
  FontSize->10,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Commentary"],
  CellFrame->{{2, 0}, {0, 0}},
  CellMargins->{{36, 10}, {7, 7}},
  PageBreakBelow->False,
  CellFrameMargins->8,
  CellFrameColor->RGBColor[0, 0.2, 1],
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 8},
  FontSlant->"Italic"],

Cell[StyleData["Commentary", "Printout"],
  CellMargins->{{36, 0}, {6, 6}},
  CellFrameColor->GrayLevel[0.8],
  FontSize->10],

Cell[StyleData["Commentary", "EnhancedPrintout"],
  CellMargins->{{36, 0}, {6, 6}},
  CellFrameColor->GrayLevel[0.8],
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["Commentary", "EnhancedPrintoutNonGray"],
  CellMargins->{{36, 0}, {6, 6}},
  CellFrameColor->GrayLevel[0.8],
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedText"],
  CellMargins->{{20, 4}, {0, 4}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 4},
  ParagraphIndent->-21,
  CounterIncrements->"ItemizedText"],

Cell[StyleData["ItemizedText", "Printout"],
  ParagraphIndent->-18,
  FontSize->11],

Cell[StyleData["ItemizedText", "EnhancedPrintout"],
  ParagraphIndent->-18,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["ItemizedText", "EnhancedPrintoutNonGray"],
  ParagraphIndent->-18,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedTextNote"],
  CellMargins->{{41, 4}, {0, 4}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 4},
  CounterIncrements->"Text"],

Cell[StyleData["ItemizedTextNote", "Printout"],
  CellMargins->{{38, 4}, {0, 4}},
  FontSize->11],

Cell[StyleData["ItemizedTextNote", "EnhancedPrintout"],
  CellMargins->{{38, 4}, {0, 4}},
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["ItemizedTextNote", "EnhancedPrintoutNonGray"],
  CellMargins->{{38, 4}, {0, 4}},
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BulletText"],
  CellMargins->{{20, 4}, {0, 4}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 4},
  ParagraphIndent->-21],

Cell[StyleData["BulletText", "Printout"],
  ParagraphIndent->-18,
  FontSize->11],

Cell[StyleData["BulletText", "EnhancedPrintout"],
  ParagraphIndent->-18,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["BulletText", "EnhancedPrintoutNonGray"],
  ParagraphIndent->-18,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["IndentedText"],
  CellMargins->{{20, 4}, {0, 6}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 8},
  CounterIncrements->"Text"],

Cell[StyleData["IndentedText", "Printout"],
  FontSize->10],

Cell[StyleData["IndentedText", "EnhancedPrintout"],
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["IndentedText", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Emphasis Boxes and Pictures", "Section"],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox"],
  CellFrame->0.5,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  AutoIndent->False,
  AutoSpacing->False,
  ShowStringCharacters->True,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.3, 0.7},
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["DefinitionBox", "EnhancedPrintout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["DefinitionBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 4}, {0, 8}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox3Col"],
  CellFrame->0.5,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  AutoIndent->False,
  AutoSpacing->False,
  ShowStringCharacters->True,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.2, 0.3, 0.5},
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox3Col", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["DefinitionBox3Col", "EnhancedPrintout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["DefinitionBox3Col", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 4}, {0, 8}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox4Col"],
  CellFrame->0.5,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  AutoIndent->False,
  AutoSpacing->False,
  ShowStringCharacters->True,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.15, 0.35, 0.15, 0.35},
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox4Col", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["DefinitionBox4Col", "EnhancedPrintout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["DefinitionBox4Col", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 4}, {0, 8}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox5Col"],
  CellFrame->0.5,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  AutoIndent->False,
  AutoSpacing->False,
  ShowStringCharacters->True,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->0.2,
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox5Col", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["DefinitionBox5Col", "EnhancedPrintout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["DefinitionBox5Col", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 4}, {0, 8}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox6Col"],
  CellFrame->0.5,
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  AutoIndent->False,
  AutoSpacing->False,
  ShowStringCharacters->True,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.13, 0.24, 0.13, 0.13, 0.24, 0.13},
  ColumnAlignments->{Left}}],

Cell[StyleData["DefinitionBox6Col", "Printout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["DefinitionBox6Col", "EnhancedPrintout"],
  CellMargins->{{2, 4}, {0, 8}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["DefinitionBox6Col", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 4}, {0, 8}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TopBox"],
  CellFrame->{{0.5, 0.5}, {0, 0.5}},
  CellMargins->{{11, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakBelow->False,
  AutoIndent->False,
  AutoSpacing->False,
  ShowStringCharacters->True,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.31, 0.62},
  ColumnAlignments->{Left}}],

Cell[StyleData["TopBox", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["TopBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["TopBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MiddleBox"],
  CellFrame->{{0.5, 0.5}, {0, 0}},
  CellMargins->{{11, 4}, {0, -7}},
  CellHorizontalScrolling->True,
  PageBreakAbove->False,
  PageBreakBelow->False,
  AutoIndent->False,
  AutoSpacing->False,
  ShowStringCharacters->True,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.31, 0.62},
  ColumnAlignments->{Left}}],

Cell[StyleData["MiddleBox", "Printout"],
  CellMargins->{{2, 0}, {0, 2}},
  ShowStringCharacters->True,
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["MiddleBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 4}},
  ShowStringCharacters->True,
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["MiddleBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 4}},
  ShowStringCharacters->True,
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MiddleSpacedBox"],
  CellFrame->{{0.5, 0.5}, {0, 0}},
  CellMargins->{{11, 4}, {0, -7}},
  CellHorizontalScrolling->True,
  PageBreakAbove->False,
  PageBreakBelow->False,
  AutoIndent->False,
  AutoSpacing->False,
  ShowStringCharacters->True,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.31, 0.62},
  ColumnAlignments->{Left},
  RowMinHeight->1.2}],

Cell[StyleData["MiddleSpacedBox", "Printout"],
  CellMargins->{{2, 0}, {0, 0}},
  FontSize->10,
  Background->GrayLevel[0.900008],
  GridBoxOptions->{RowMinHeight->1.8}],

Cell[StyleData["MiddleSpacedBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 0}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[0.900008],
  GridBoxOptions->{RowMinHeight->1.8}],

Cell[StyleData["MiddleSpacedBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 0}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1],
  GridBoxOptions->{RowMinHeight->1.8}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BottomBox"],
  CellFrame->{{0.5, 0.5}, {0.5, 0}},
  CellMargins->{{11, 4}, {0, -7}},
  CellHorizontalScrolling->True,
  PageBreakAbove->False,
  PageBreakBelow->False,
  AutoIndent->False,
  AutoSpacing->False,
  ShowStringCharacters->True,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.31, 0.62},
  ColumnAlignments->{Left},
  RowMinHeight->1.2}],

Cell[StyleData["BottomBox", "Printout"],
  CellMargins->{{2, 0}, {0, -5}},
  FontSize->10,
  Background->GrayLevel[0.900008],
  GridBoxOptions->{RowMinHeight->2.2}],

Cell[StyleData["BottomBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, -5}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[0.900008],
  GridBoxOptions->{RowMinHeight->2.2}],

Cell[StyleData["BottomBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, -5}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1],
  GridBoxOptions->{RowMinHeight->2.2}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TopSpanBox"],
  CellFrame->{{0.5, 0.5}, {0, 0.5}},
  CellMargins->{{11, 4}, {-2, 8}},
  CellHorizontalScrolling->True,
  PageBreakBelow->False,
  AutoIndent->False,
  AutoSpacing->False,
  ShowStringCharacters->True,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.9, 0.03},
  ColumnAlignments->{Left}}],

Cell[StyleData["TopSpanBox", "Printout"],
  CellMargins->{{2, 0}, {-2, 8}},
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["TopSpanBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {-4, 8}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[0.900008]],

Cell[StyleData["TopSpanBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {-4, 8}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MiddleSpanBox"],
  CellFrame->{{0.5, 0.5}, {0, 0}},
  CellMargins->{{11, 4}, {-3, -8}},
  CellHorizontalScrolling->True,
  PageBreakAbove->False,
  PageBreakBelow->False,
  AutoIndent->False,
  AutoSpacing->False,
  ShowStringCharacters->True,
  LineIndent->0,
  StyleMenuListing->None,
  FontWeight->"Plain",
  Background->RGBColor[1, 0.6, 0.6],
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->1,
  ColumnWidths->{0.9, 0.03},
  ColumnAlignments->{Left},
  RowMinHeight->1.2}],

Cell[StyleData["MiddleSpanBox", "Printout"],
  CellMargins->{{2, 0}, {-5, 0}},
  FontSize->10,
  Background->GrayLevel[0.900008],
  GridBoxOptions->{RowMinHeight->1.8}],

Cell[StyleData["MiddleSpanBox", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {-7, 0}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[0.900008],
  GridBoxOptions->{RowMinHeight->1.8}],

Cell[StyleData["MiddleSpanBox", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {-7, 0}},
  FontFamily->"Palatino",
  FontSize->10,
  Background->GrayLevel[1],
  GridBoxOptions->{RowMinHeight->1.8}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Picture"],
  CellMargins->{{12, Inherited}, {0, 8}},
  CellHorizontalScrolling->True],

Cell[StyleData["Picture", "Printout"],
  CellMargins->{{2, Inherited}, {0, 8}}],

Cell[StyleData["Picture", "EnhancedPrintout"],
  CellMargins->{{2, Inherited}, {0, 8}}],

Cell[StyleData["Picture", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, Inherited}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Caption"],
  CellMargins->{{12, 4}, {0, 2}},
  PageBreakAbove->False,
  FontFamily->"Helvetica",
  FontSize->9],

Cell[StyleData["Caption", "Printout"],
  CellMargins->{{2, 4}, {2, 4}},
  FontSize->7],

Cell[StyleData["Caption", "EnhancedPrintout"],
  CellMargins->{{2, 4}, {2, 4}},
  FontFamily->"Futura",
  FontSize->7],

Cell[StyleData["Caption", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 4}, {2, 4}},
  FontFamily->"Futura",
  FontSize->7]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Tables", "Section"],

Cell[CellGroupData[{

Cell[StyleData["SingleRowTable"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  AutoIndent->False,
  AutoSpacing->False,
  ShowStringCharacters->True,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->2,
  ColumnAlignments->{Left}}],

Cell[StyleData["SingleRowTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["SingleRowTable", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["SingleRowTable", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnTable"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  AutoIndent->False,
  AutoSpacing->False,
  ShowStringCharacters->True,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->2,
  ColumnWidths->{0.34, 0.64},
  ColumnAlignments->{Left, Center}}],

Cell[StyleData["2ColumnTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["2ColumnTable", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["2ColumnTable", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnEvenTable"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  AutoIndent->False,
  AutoSpacing->False,
  ShowStringCharacters->True,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->2,
  ColumnWidths->0.49,
  ColumnAlignments->{Left, Center}}],

Cell[StyleData["2ColumnEvenTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["2ColumnEvenTable", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["2ColumnEvenTable", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnTable"],
  PageWidth->400,
  CellMargins->{{10, 10}, {1, 1}},
  CellHorizontalScrolling->True,
  ShowStringCharacters->True,
  CounterIncrements->"Table",
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->0.336,
  RowAlignments->Center,
  ColumnAlignments->{Left, Center},
  GridFrame->{{0, 0}, {0.5, 2}},
  RowLines->{True, False},
  ColumnLines->False,
  GridDefaultElement:>Cell[ "Your Data", "TableText"]}],

Cell[StyleData["3ColumnTable", "Printout"],
  CellMargins->{{2, 10}, {1, 1}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnTablePlain"],
  PageWidth->400,
  CellMargins->{{12, 10}, {7, 7}},
  CellHorizontalScrolling->True,
  ShowStringCharacters->True,
  CounterIncrements->"Table",
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->0.336,
  RowAlignments->Center,
  ColumnAlignments->{Left, Center},
  GridFrame->{{0, 0}, {0.5, 2}},
  RowLines->{True, False},
  ColumnLines->False,
  GridDefaultElement:>Cell[ "Your Data", "TableText"]}],

Cell[StyleData["3ColumnTablePlain", "Printout"],
  CellMargins->{{2, 10}, {4, 4}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["4ColumnTable"],
  PageWidth->400,
  CellMargins->{{10, 10}, {1, 1}},
  CellHorizontalScrolling->True,
  ShowStringCharacters->True,
  CounterIncrements->"Table",
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->0.251,
  RowAlignments->Center,
  ColumnAlignments->{Left, Center},
  GridFrame->{{0, 0}, {0.5, 2}},
  RowLines->{True, False},
  ColumnLines->False,
  GridDefaultElement:>Cell[ "Your Data", "TableText"]}],

Cell[StyleData["4ColumnTable", "Printout"],
  CellMargins->{{2, 10}, {1, 1}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["4ColumnTablePlain"],
  PageWidth->400,
  CellMargins->{{12, 10}, {7, 7}},
  CellHorizontalScrolling->True,
  ShowStringCharacters->True,
  CounterIncrements->"Table",
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->0.251,
  RowAlignments->Center,
  ColumnAlignments->{Left, Center},
  GridFrame->{{0, 0}, {0.5, 2}},
  RowLines->{True, False},
  ColumnLines->False,
  GridDefaultElement:>Cell[ "Your Data", "TableText"]}],

Cell[StyleData["4ColumnTablePlain", "Printout"],
  CellMargins->{{2, 10}, {4, 4}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["5ColumnTable"],
  PageWidth->400,
  CellMargins->{{10, 10}, {1, 1}},
  CellHorizontalScrolling->True,
  ShowStringCharacters->True,
  CounterIncrements->"Table",
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->0.201,
  RowAlignments->Center,
  ColumnAlignments->{Left, Center},
  GridFrame->{{0, 0}, {0.5, 2}},
  RowLines->{True, False},
  ColumnLines->False,
  GridDefaultElement:>Cell[ "Your Data", "TableText"]}],

Cell[StyleData["5ColumnTable", "Printout"],
  CellMargins->{{2, 10}, {1, 1}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["5ColumnTablePlain"],
  PageWidth->400,
  CellMargins->{{12, 10}, {7, 7}},
  CellHorizontalScrolling->True,
  ShowStringCharacters->True,
  CounterIncrements->"Table",
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->0.201,
  RowAlignments->Center,
  ColumnAlignments->{Left, Center},
  GridFrame->{{0, 0}, {0.5, 2}},
  RowLines->{True, False},
  ColumnLines->False,
  GridDefaultElement:>Cell[ "Your Data", "TableText"]}],

Cell[StyleData["5ColumnTablePlain", "Printout"],
  CellMargins->{{2, 10}, {4, 4}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["6ColumnTable"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  AutoIndent->False,
  AutoSpacing->False,
  ShowStringCharacters->True,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->2,
  ColumnWidths->0.16,
  ColumnAlignments->{Left, Center}}],

Cell[StyleData["6ColumnTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["6ColumnTable", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["6ColumnTable", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["7ColumnTable"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  AutoIndent->False,
  AutoSpacing->False,
  ShowStringCharacters->True,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->2,
  ColumnWidths->0.14,
  ColumnAlignments->{Left, Center}}],

Cell[StyleData["7ColumnTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["7ColumnTable", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["7ColumnTable", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["8ColumnTable"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  AutoIndent->False,
  AutoSpacing->False,
  ShowStringCharacters->True,
  LineIndent->0,
  StyleMenuListing->None,
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->2,
  ColumnWidths->0.12,
  ColumnAlignments->{Left, Center}}],

Cell[StyleData["8ColumnTable", "Printout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["8ColumnTable", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["8ColumnTable", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 8}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableHead"],
  PageWidth->400,
  CellMargins->{{12, 10}, {1, 7}},
  LineSpacing->{1, 2},
  CounterIncrements->"TableHead",
  StyleMenuListing->None,
  FontFamily->"Times",
  FontWeight->"Bold",
  GridBoxOptions->{ColumnWidths->40,
  ColumnAlignments->{Left}}],

Cell[StyleData["TableHead", "Printout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Table"],
  PageWidth->400,
  CellMargins->{{10, 10}, {1, 1}},
  CellHorizontalScrolling->True,
  ShowStringCharacters->True,
  CounterIncrements->"Table",
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->0.503,
  RowAlignments->Center,
  ColumnAlignments->{Left, Center},
  GridFrame->{{0, 0}, {0.5, 2}},
  RowLines->{True, False},
  ColumnLines->False,
  GridDefaultElement:>Cell[ "Your Data", "TableText"]}],

Cell[StyleData["Table", "Printout"],
  CellMargins->{{2, 10}, {1, 1}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TablePlain"],
  PageWidth->400,
  CellMargins->{{12, 10}, {7, 7}},
  CellHorizontalScrolling->True,
  ShowStringCharacters->True,
  CounterIncrements->"Table",
  StyleMenuListing->None,
  GridBoxOptions->{ColumnWidths->0.503,
  RowAlignments->Center,
  ColumnAlignments->{Left, Center},
  GridFrame->{{0, 0}, {0.5, 2}},
  RowLines->{True, False},
  ColumnLines->False,
  GridDefaultElement:>Cell[ "Your Data", "TableText"]}],

Cell[StyleData["TablePlain", "Printout"],
  CellMargins->{{2, 10}, {4, 4}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableNote"],
  PageWidth->400,
  CellMargins->{{12, 10}, {7, 1}},
  LineSpacing->{1, 1},
  ParagraphSpacing->{0.3, 0},
  FontFamily->"Times",
  FontSize->10],

Cell[StyleData["TableNote", "Printout"],
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Styles for Tables", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["TableHeadText"],
  CounterIncrements->"TableHead",
  FontFamily->"Times",
  FontWeight->"Plain"],

Cell[StyleData["TableHeadText", "Printout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ColumnHead"],
  CounterIncrements->"Table",
  FontFamily->"Times",
  FontSlant->"Italic"],

Cell[StyleData["ColumnHead", "Printout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableText"],
  TextAlignment->Left,
  LineSpacing->{1, 1},
  FontFamily->"Times",
  FontSize->12],

Cell[StyleData["TableText", "Printout"],
  FontSize->10]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Automatic Numbering", "Section"],

Cell["\<\
The following styles are useful for numbered equations, figures, \
etc.  They automatically give the cell a FrameLabel containing a reference to \
a particular counter, and also increment that counter.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["NumberedEquation"],
  CellMargins->{{45, 10}, {7, 7}},
  CellFrameLabels->{{None, Cell[ 
          TextData[ {"(", 
            CounterBox[ "NumberedEquation"], ")"}]]}, {None, None}},
  DefaultFormatType->DefaultTextFormatType,
  SpanMaxSize->Infinity,
  CounterIncrements->"NumberedEquation",
  FormatTypeAutoConvert->False],

Cell[StyleData["NumberedEquation", "Printout"],
  CellMargins->{{39, 55}, {0, 10}},
  FontSize->10],

Cell[StyleData["NumberedEquation", "EnhancedPrintout"],
  CellMargins->{{39, 55}, {0, 10}},
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["NumberedEquation", "EnhancedPrintoutNonGray"],
  CellMargins->{{39, 55}, {0, 10}},
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Section"],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
  CellMargins->{{45, Inherited}, {7, 7}},
  CellHorizontalScrolling->True,
  ScriptLevel->0,
  SingleLetterItalics->True,
  SpanMaxSize->Infinity,
  UnderoverscriptBoxOptions->{LimitsPositioning->True}],

Cell[StyleData["DisplayFormula", "Printout"],
  FontSize->10],

Cell[StyleData["DisplayFormula", "EnhancedPrintout"],
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["DisplayFormula", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DisplayMath"],
  CellMargins->{{45, 10}, {7, 7}},
  Evaluatable->False,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input"],

Cell[StyleData["DisplayMath", "Printout"],
  CellMargins->{{39, 0}, {6, 6}},
  FontSize->9],

Cell[StyleData["DisplayMath", "EnhancedPrintout"],
  CellMargins->{{39, 0}, {4, 6}},
  FontFamily->"WRICourier",
  FontSize->9],

Cell[StyleData["DisplayMath", "EnhancedPrintoutNonGray"],
  CellMargins->{{39, 0}, {4, 6}},
  FontFamily->"WRICourier",
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationNumber"],
  LineSpacing->{1.83, 0}],

Cell[StyleData["EquationNumber", "Printout"],
  LineSpacing->{1.7, 0},
  FontSize->10],

Cell[StyleData["EquationNumber", "EnhancedPrintout"],
  LineSpacing->{1.7, 0},
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["EquationNumber", "EnhancedPrintoutNonGray"],
  LineSpacing->{1.7, 0},
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Program"],
  CellFrame->{{0, 0}, {0.5, 0.5}},
  CellMargins->{{12, Inherited}, {7, 7}},
  CellFrameMargins->{{0, 0}, {7, 5}},
  FontFamily->"Courier"],

Cell[StyleData["Program", "Printout"],
  CellMargins->{{18, 30}, {Inherited, 4}},
  FontSize->9.5],

Cell[StyleData["Program", "EnhancedPrintout"],
  CellMargins->{{18, 30}, {Inherited, 4}},
  FontFamily->"WRICourier",
  FontSize->9.5],

Cell[StyleData["Program", "EnhancedPrintoutNonGray"],
  CellMargins->{{18, 30}, {Inherited, 4}},
  FontFamily->"WRICourier",
  FontSize->9.5]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Contents and Index", "Section"],

Cell[CellGroupData[{

Cell[StyleData["ContentsTitle"],
  ShowGroupOpenCloseIcon->False,
  CellMargins->{{10, 4}, {0, 18}},
  CellGroupingRules->{"SectionGrouping", 60},
  LineSpacing->{1, 11},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->26,
  FontWeight->"Bold"],

Cell[StyleData["ContentsTitle", "Printout"],
  CellMargins->{{2, 0}, {0, 18}},
  PageBreakBelow->False,
  FontSize->18],

Cell[StyleData["ContentsTitle", "EnhancedPrintout"],
  CellMargins->{{2, 0}, {0, 18}},
  PageBreakBelow->False,
  FontFamily->"Futura",
  FontSize->18],

Cell[StyleData["ContentsTitle", "EnhancedPrintoutNonGray"],
  CellMargins->{{2, 0}, {0, 18}},
  PageBreakBelow->False,
  FontFamily->"Futura",
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ContentsSection"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{35, 4}, {3, 18}},
  CellGroupingRules->{"SectionGrouping", 70},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["ContentsSection", "Printout"],
  CellMargins->{{20, 0}, {3, 18}},
  PageBreakBelow->False,
  FontSize->11],

Cell[StyleData["ContentsSection", "EnhancedPrintout"],
  CellMargins->{{20, 0}, {3, 18}},
  PageBreakBelow->False,
  FontFamily->"Futura",
  FontSize->11],

Cell[StyleData["ContentsSection", "EnhancedPrintoutNonGray"],
  CellMargins->{{20, 0}, {3, 18}},
  PageBreakBelow->False,
  FontFamily->"Futura",
  FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["IndexSection"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{20, 4}, {5, 20}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["IndexSection", "Printout"],
  CellMargins->{{12, 0}, {5, 20}},
  PageBreakBelow->False,
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Contents"],
  ShowGroupOpenCloseIcon->False,
  CellMargins->{{50, 4}, {0, 5}},
  CellGroupingRules->{"SectionGrouping", 90},
  StyleMenuListing->None],

Cell[StyleData["Contents", "Printout"],
  CellMargins->{{40, 4}, {0, 5}},
  FontSize->11],

Cell[StyleData["Contents", "EnhancedPrintout"],
  CellMargins->{{40, 5}, {0, 5}},
  FontFamily->"Palatino",
  FontSize->11],

Cell[StyleData["Contents", "EnhancedPrintoutNonGray"],
  CellMargins->{{40, 5}, {0, 5}},
  FontFamily->"Palatino",
  FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Index"],
  CellMargins->{{21, 4}, {0, 0}},
  ParagraphIndent->-48,
  StyleMenuListing->None],

Cell[StyleData["Index", "Printout"],
  CellMargins->{{13, 0}, {0, 0}},
  FontSize->10],

Cell[StyleData["Index", "EnhancedPrintout"],
  CellMargins->{{13, 0}, {0, 0}},
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["Index", "EnhancedPrintoutNonGray"],
  CellMargins->{{13, 0}, {0, 0}},
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["IndexSubentry"],
  CellMargins->{{36, 4}, {0, 0}},
  ParagraphIndent->-48,
  StyleMenuListing->None],

Cell[StyleData["IndexSubentry", "Printout"],
  CellMargins->{{24, 0}, {0, 0}},
  FontSize->10],

Cell[StyleData["IndexSubentry", "EnhancedPrintout"],
  CellMargins->{{24, 0}, {0, 0}},
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["IndexSubentry", "EnhancedPrintoutNonGray"],
  CellMargins->{{24, 0}, {0, 0}},
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Function List", "Section"],

Cell[CellGroupData[{

Cell[StyleData["FunctionName"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{24, 10}, {10, 12}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  FontFamily->"Courier",
  FontSize->14,
  FontWeight->"Bold",
  CellTags->"FunctionName"],

Cell[StyleData["FunctionName", "Printout"],
  CellMargins->{{9, 0}, {10, 10}},
  FontSize->12],

Cell[StyleData["FunctionName", "EnhancedPrintout"],
  CellMargins->{{9, 0}, {10, 10}},
  FontFamily->"Courier",
  FontSize->12],

Cell[StyleData["FunctionName", "EnhancedPrintoutNonGray"],
  CellMargins->{{9, 0}, {10, 10}},
  FontFamily->"Courier",
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsectionIcon"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{24, 10}, {0, 30}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  FontSize->14,
  FontWeight->"Bold",
  CellTags->"FunctionSection"],

Cell[StyleData["SubsectionIcon", "Printout"],
  CellMargins->{{20, 0}, {0, 20}},
  FontSize->13],

Cell[StyleData["SubsectionIcon", "EnhancedPrintout"],
  CellMargins->{{20, 0}, {0, 20}},
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["SubsectionIcon", "EnhancedPrintoutNonGray"],
  CellMargins->{{20, 0}, {0, 20}},
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionSubsection"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{36, 10}, {0, 6}},
  CellGroupingRules->{"SectionGrouping", 60},
  PageBreakBelow->False,
  FontWeight->"Bold",
  CellTags->"FunctionSubsection"],

Cell[StyleData["FunctionSubsection", "Printout"],
  CellMargins->{{30, 0}, {0, 6}}],

Cell[StyleData["FunctionSubsection", "EnhancedPrintout"],
  CellMargins->{{30, 0}, {0, 6}},
  FontFamily->"Palatino",
  FontSize->11],

Cell[StyleData["FunctionSubsection", "EnhancedPrintoutNonGray"],
  CellMargins->{{30, 0}, {0, 6}},
  FontFamily->"Palatino",
  FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsubsectionIcon"],
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{36, 10}, {0, 6}},
  CellGroupingRules->{"SectionGrouping", 60},
  PageBreakBelow->False,
  FontWeight->"Bold",
  CellTags->"SubsubsectionIcon"],

Cell[StyleData["SubsubsectionIcon", "Printout"],
  CellMargins->{{30, 0}, {0, 6}},
  FontSize->11],

Cell[StyleData["SubsubsectionIcon", "EnhancedPrintout"],
  CellMargins->{{30, 0}, {0, 6}},
  FontFamily->"Palatino",
  FontSize->9],

Cell[StyleData["SubsubsectionIcon", "EnhancedPrintoutNonGray"],
  CellMargins->{{30, 0}, {0, 6}},
  FontFamily->"Palatino",
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionDescription"],
  CellMargins->{{36, 10}, {4, 0}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0.7, 0},
  CounterIncrements->"Text",
  FontWeight->"Plain"],

Cell[StyleData["FunctionDescription", "Printout"],
  CellMargins->{{30, 0}, {4, 0}},
  FontSize->11],

Cell[StyleData["FunctionDescription", "EnhancedPrintout"],
  CellMargins->{{30, 0}, {4, 0}},
  TextJustification->0,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["FunctionDescription", "EnhancedPrintoutNonGray"],
  CellMargins->{{30, 0}, {4, 0}},
  TextJustification->0,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionDescriptionRuled"],
  CellFrame->{{0, 0}, {0.25, 0.25}},
  CellMargins->{{36, 10}, {4, 0}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0.7, 0},
  CounterIncrements->"Text"],

Cell[StyleData["FunctionDescriptionRuled", "Printout"],
  CellMargins->{{30, 0}, {4, 0}},
  FontSize->11],

Cell[StyleData["FunctionDescriptionRuled", "EnhancedPrintout"],
  CellMargins->{{30, 0}, {4, 0}},
  TextJustification->0,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["FunctionDescriptionRuled", "EnhancedPrintoutNonGray"],
  CellMargins->{{30, 0}, {4, 0}},
  TextJustification->0,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionDescriptionRuleTop"],
  CellFrame->{{0, 0}, {0, 0.25}},
  CellMargins->{{36, 10}, {4, 0}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0.7, 0},
  CounterIncrements->"Text"],

Cell[StyleData["FunctionDescriptionRuleTop", "Printout"],
  CellMargins->{{30, 0}, {4, 0}},
  FontSize->11],

Cell[StyleData["FunctionDescriptionRuleTop", "EnhancedPrintout"],
  CellMargins->{{30, 0}, {4, 0}},
  TextJustification->0,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["FunctionDescriptionRuleTop", "EnhancedPrintoutNonGray"],
  CellMargins->{{30, 0}, {4, 0}},
  TextJustification->0,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionDescriptionRuleBottom"],
  CellFrame->{{0, 0}, {0.25, 0}},
  CellMargins->{{36, 10}, {4, 0}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0.7, 0},
  CounterIncrements->"Text"],

Cell[StyleData["FunctionDescriptionRuleBottom", "Printout"],
  CellMargins->{{30, 0}, {4, 0}},
  FontSize->11],

Cell[StyleData["FunctionDescriptionRuleBottom", "EnhancedPrintout"],
  CellMargins->{{30, 0}, {4, 0}},
  TextJustification->0,
  FontFamily->"Palatino",
  FontSize->10],

Cell[StyleData["FunctionDescriptionRuleBottom", "EnhancedPrintoutNonGray"],
  CellMargins->{{30, 0}, {4, 0}},
  TextJustification->0,
  FontFamily->"Palatino",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionExample"],
  CellMargins->{{36, 10}, {4, 0}},
  StyleMenuListing->None,
  FontSize->10],

Cell[StyleData["FunctionExample", "Printout"],
  CellMargins->{{30, 0}, {4, 0}},
  FontSize->9],

Cell[StyleData["FunctionExample", "EnhancedPrintout"],
  CellMargins->{{30, 0}, {4, 0}},
  FontFamily->"Palatino",
  FontSize->9],

Cell[StyleData["FunctionExample", "EnhancedPrintoutNonGray"],
  CellMargins->{{30, 0}, {4, 0}},
  FontFamily->"Palatino",
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionTextNote"],
  CellMargins->{{36, 4}, {0, 4}},
  LineSpacing->{1, 3},
  ParagraphSpacing->{0, 4},
  LineIndent->0],

Cell[StyleData["FunctionTextNote", "Printout"],
  CellMargins->{{36, 4}, {0, 4}},
  FontSize->9],

Cell[StyleData["FunctionTextNote", "EnhancedPrintout"],
  CellMargins->{{36, 4}, {0, 4}},
  FontFamily->"Palatino",
  FontSize->8],

Cell[StyleData["FunctionTextNote", "EnhancedPrintoutNonGray"],
  CellMargins->{{36, 4}, {0, 4}},
  FontFamily->"Palatino",
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnFunctionTable"],
  CellMargins->{{36, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  AutoIndent->False,
  AutoSpacing->False,
  LineIndent->0,
  GridBoxOptions->{RowSpacings->1.5,
  ColumnSpacings->2,
  ColumnWidths->{0.28, 0.28, 0.43},
  ColumnAlignments->{Left}}],

Cell[StyleData["3ColumnFunctionTable", "Printout"],
  CellMargins->{{30, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["3ColumnFunctionTable", "EnhancedPrintout"],
  CellMargins->{{30, 0}, {0, 8}},
  FontSize->10],

Cell[StyleData["3ColumnFunctionTable", "EnhancedPrintoutNonGray"],
  CellMargins->{{30, 0}, {0, 8}},
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Browser Emulation", "Section"],

Cell[CellGroupData[{

Cell[StyleData["TextNormal"],
  CellMargins->{{12, 10}, {7, 7}},
  LineSpacing->{1, 3},
  CounterIncrements->"Text",
  FontFamily->"Times",
  FontSize->12],

Cell[StyleData["TextNormal", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BrowserEmulation"],
  CellMargins->{{12, 1}, {7, 24}},
  CellGroupingRules->{"SectionGrouping", 70},
  LineSpacing->{1, 3},
  FontFamily->"Helvetica",
  GridBoxOptions->{ColumnWidths->0.25,
  ColumnAlignments->{Left},
  GridFrame->True,
  GridFrameMargins->0.5,
  ColumnLines->True}],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CategoryDefs"],
  CellMargins->{{300, 10}, {7, 7}},
  LineSpacing->{1, 3},
  FontFamily->"Helvetica",
  Background->RGBColor[1, 0.8, 0.6],
  GridBoxOptions->{ColumnAlignments->{Left},
  GridFrame->False,
  RowLines->True,
  ColumnLines->True}],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Category1"],
  ShowCellBracket->False,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{12, 10}, {7, 7}},
  CellGroupingRules->{"SectionGrouping", 50},
  FontSize->16,
  FontWeight->"Bold"],

Cell[StyleData["Category1", "Printout"],
  CellMargins->{{2, 2}, {6, 6}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Category2"],
  ShowCellBracket->False,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{85, 10}, {7, 7}},
  CellGroupingRules->{"SectionGrouping", 60},
  FontSize->14,
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[StyleData["Category2", "Printout"],
  CellMargins->{{2, 2}, {6, 6}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Category3"],
  ShowCellBracket->False,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{157, 10}, {7, 7}},
  CellGroupingRules->{"SectionGrouping", 70},
  FontSize->12,
  FontWeight->"Bold",
  FontColor->RGBColor[0.2, 0, 0.4]],

Cell[StyleData["Category3", "Printout"],
  CellMargins->{{2, 2}, {6, 6}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Category4"],
  ShowCellBracket->False,
  ShowGroupOpenCloseIcon->True,
  CellMargins->{{230, 10}, {7, 7}},
  CellGroupingRules->{"SectionGrouping", 80},
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0.300008, 0.4]],

Cell[StyleData["Category4", "Printout"],
  CellMargins->{{2, 2}, {6, 6}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headers and Footers", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Header"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->8,
  FontWeight->"Bold"],

Cell[StyleData["Header", "Printout"]],

Cell[StyleData["Header", "EnhancedPrintout"],
  FontFamily->"Futura"],

Cell[StyleData["Header", "EnhancedPrintoutNonGray"],
  FontFamily->"Futura"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Footer"],
  CellMargins->{{0, 0}, {0, 4}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->7,
  FontSlant->"Plain"],

Cell[StyleData["Footer", "Printout"]],

Cell[StyleData["Footer", "EnhancedPrintout"],
  FontFamily->"Futura"],

Cell[StyleData["Footer", "EnhancedPrintoutNonGray"],
  FontFamily->"Futura"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PageNumber"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->8,
  FontWeight->"Bold"],

Cell[StyleData["PageNumber", "Printout"]],

Cell[StyleData["PageNumber", "EnhancedPrintout"],
  FontFamily->"Futura"],

Cell[StyleData["PageNumber", "EnhancedPrintoutNonGray"],
  FontFamily->"Futura"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Printout"],
  FontSize->11,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["Hyperlink", "EnhancedPrintout"],
  FontFamily->"Palatino",
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["Hyperlink", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino",
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "Printout"],
  FontSize->11,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["MainBookLink", "EnhancedPrintout"],
  FontFamily->"Palatino",
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["MainBookLink", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino",
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnsLink", "Printout"],
  FontSize->11,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["AddOnsLink", "EnhancedPrintout"],
  FontSize->11,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["AddOnsLink", "EnhancedPrintoutNonGray"],
  FontSize->11,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLinkText"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Times",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnsLinkText", "Printout"],
  FontSize->11,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["AddOnsLinkText", "EnhancedPrintout"],
  FontSize->11,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["AddOnsLinkText", "EnhancedPrintoutNonGray"],
  FontSize->11,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["RefGuideLink", "EnhancedPrintout"],
  FontFamily->"WRICourier",
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["RefGuideLink", "EnhancedPrintoutNonGray"],
  FontFamily->"WRICourier",
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontSize->11,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["GettingStartedLink", "EnhancedPrintout"],
  FontFamily->"Palatino",
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["GettingStartedLink", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino",
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontSize->11,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["OtherInformationLink", "EnhancedPrintout"],
  FontFamily->"Palatino",
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["OtherInformationLink", "EnhancedPrintoutNonGray"],
  FontFamily->"Palatino",
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Outline Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Outline1"],
  CellMargins->{{12, 10}, {7, 7}},
  CellGroupingRules->{"SectionGrouping", 50},
  ParagraphIndent->-38,
  CounterIncrements->"Outline1",
  FontSize->18,
  FontWeight->"Bold",
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell[StyleData["Outline1", "Printout"],
  CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline2"],
  CellMargins->{{59, 10}, {7, 7}},
  CellGroupingRules->{"SectionGrouping", 60},
  ParagraphIndent->-27,
  CounterIncrements->"Outline2",
  FontSize->15,
  FontWeight->"Bold",
  CounterBoxOptions->{CounterFunction:>(Part[ 
      CharacterRange[ "A", "Z"], #]&)}],

Cell[StyleData["Outline2", "Printout"],
  CounterBoxOptions->{CounterFunction:>(Part[ 
      CharacterRange[ "A", "Z"], #]&)}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline3"],
  CellMargins->{{108, 10}, {7, 7}},
  CellGroupingRules->{"SectionGrouping", 70},
  ParagraphIndent->-21,
  CounterIncrements->"Outline3",
  FontSize->12,
  CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["Outline3", "Printout"],
  CounterBoxOptions->{CounterFunction:>Identity}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline4"],
  CellMargins->{{158, 10}, {7, 7}},
  CellGroupingRules->{"SectionGrouping", 80},
  ParagraphIndent->-18,
  CounterIncrements->"Outline4",
  FontSize->10,
  CounterBoxOptions->{CounterFunction:>(Part[ 
      CharacterRange[ "a", "z"], #]&)}],

Cell[StyleData["Outline4", "Printout"]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 1152}, {0, 850}},
WindowSize->{520, 728},
WindowMargins->{{Automatic, 299}, {Automatic, 28}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Section"->{
    Cell[6091, 215, 404, 12, 56, 26, 0, "StyleData", "Section", "All",
      CounterIncrements->"Section",
      CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
      CellTags->"Section"]},
  "Subsection"->{
    Cell[6876, 246, 349, 10, 44, 29, 0, "StyleData", "Subsection", "All",
      CounterIncrements->"Subsection",
      CounterAssignments->{{"Subsubsection", 0}},
      CellTags->"Subsection"]},
  "Subsubsection"->{
    Cell[7615, 275, 262, 7, 42, 32, 0, "StyleData", "Subsubsection", "All",
      CounterIncrements->"Subsubsection",
      CellTags->"Subsubsection"]},
  "FunctionName"->{
    Cell[50855, 2051, 264, 8, 70, 31, 0, "StyleData", "FunctionName", "All",
      CellTags->"FunctionName"]},
  "FunctionSection"->{
    Cell[51520, 2078, 241, 7, 70, 33, 0, "StyleData", "SubsectionIcon", 
    "All",
      CellTags->"FunctionSection"]},
  "FunctionSubsection"->{
    Cell[52170, 2104, 233, 6, 70, 37, 0, "StyleData", "FunctionSubsection", 
    "All",
      CellTags->"FunctionSubsection"]},
  "SubsubsectionIcon"->{
    Cell[52805, 2128, 229, 6, 70, 36, 0, "StyleData", "SubsubsectionIcon", 
    "All",
      CellTags->"SubsubsectionIcon"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Section", 70200, 2810},
  {"Subsection", 70423, 2815},
  {"Subsubsection", 70639, 2820},
  {"FunctionName", 70812, 2824},
  {"FunctionSection", 70946, 2827},
  {"FunctionSubsection", 71093, 2831},
  {"SubsubsectionIcon", 71246, 2835}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 37, 0, 62, "Subtitle"],
Cell[1779, 53, 193, 4, 46, "Text"],

Cell[CellGroupData[{
Cell[1997, 61, 42, 0, 56, "Section"],
Cell[2042, 63, 166, 4, 36, 31, 0, "StyleData", "All", "Working"],
Cell[2211, 69, 106, 3, 36, 35, 0, "StyleData", "All", "AllBrackets"],
Cell[2320, 74, 212, 5, 36, 32, 0, "StyleData", "All", "Printout"],
Cell[2535, 81, 220, 5, 36, 40, 0, "StyleData", "All", "EnhancedPrintout"],
Cell[2758, 88, 227, 5, 36, 47, 0, "StyleData", "All", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[3022, 98, 35, 0, 36, "Section"],
Cell[3060, 100, 101, 3, 30, "Text"],
Cell[3164, 105, 610, 16, 36, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3811, 126, 38, 0, 36, "Section"],

Cell[CellGroupData[{
Cell[3874, 130, 395, 11, 112, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[4272, 143, 88, 2, 91, 36, 0, "StyleData", "Title", "Printout"],
Cell[4363, 147, 120, 3, 94, 44, 0, "StyleData", "Title", "EnhancedPrintout"],
Cell[4486, 152, 127, 3, 94, 51, 0, "StyleData", "Title", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[4650, 160, 338, 9, 58, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}}],
Cell[4991, 171, 91, 2, 66, 39, 0, "StyleData", "Subtitle", "Printout"],
Cell[5085, 175, 123, 3, 67, 47, 0, "StyleData", "Subtitle", \
"EnhancedPrintout"],
Cell[5211, 180, 130, 3, 67, 54, 0, "StyleData", "Subtitle", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[5378, 188, 317, 8, 46, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[5698, 198, 93, 2, 70, 42, 0, "StyleData", "Subsubtitle", "Printout"],
Cell[5794, 202, 125, 3, 70, 50, 0, "StyleData", "Subsubtitle", \
"EnhancedPrintout"],
Cell[5922, 207, 132, 3, 70, 57, 0, "StyleData", "Subsubtitle", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[6091, 215, 404, 12, 56, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  CellTags->"Section"],
Cell[6498, 229, 88, 2, 71, 38, 0, "StyleData", "Section", "Printout"],
Cell[6589, 233, 120, 3, 73, 46, 0, "StyleData", "Section", \
"EnhancedPrintout"],
Cell[6712, 238, 127, 3, 73, 53, 0, "StyleData", "Section", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[6876, 246, 349, 10, 44, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  CellTags->"Subsection"],
Cell[7228, 258, 91, 2, 61, 41, 0, "StyleData", "Subsection", "Printout"],
Cell[7322, 262, 123, 3, 63, 49, 0, "StyleData", "Subsection", \
"EnhancedPrintout"],
Cell[7448, 267, 130, 3, 63, 56, 0, "StyleData", "Subsection", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[7615, 275, 262, 7, 42, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection",
  CellTags->"Subsubsection"],
Cell[7880, 284, 94, 2, 52, 44, 0, "StyleData", "Subsubsection", "Printout"],
Cell[7977, 288, 126, 3, 52, 52, 0, "StyleData", "Subsubsection", \
"EnhancedPrintout"],
Cell[8106, 293, 133, 3, 52, 59, 0, "StyleData", "Subsubsection", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8288, 302, 39, 0, 36, "Section"],

Cell[CellGroupData[{
Cell[8352, 306, 140, 4, 70, 23, 0, "StyleData", "Text", "All",
  CounterIncrements->"Text"],
Cell[8495, 312, 108, 3, 70, 35, 0, "StyleData", "Text", "Printout"],
Cell[8606, 317, 142, 4, 70, 43, 0, "StyleData", "Text", "EnhancedPrintout"],
Cell[8751, 323, 149, 4, 70, 50, 0, "StyleData", "Text", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[8937, 332, 165, 5, 70, 28, 0, "StyleData", "SmallText", "All",
  CounterIncrements->"SmallText"],
Cell[9105, 339, 112, 3, 70, 40, 0, "StyleData", "SmallText", "Printout"],
Cell[9220, 344, 146, 4, 70, 48, 0, "StyleData", "SmallText", \
"EnhancedPrintout"],
Cell[9369, 350, 153, 4, 70, 55, 0, "StyleData", "SmallText", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[9559, 359, 163, 5, 70, 32, 0, "StyleData", "CopyrightText", "All",
  StyleMenuListing->None],
Cell[9725, 366, 92, 2, 70, 44, 0, "StyleData", "CopyrightText", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9866, 374, 42, 0, 36, "Section"],
Cell[9911, 376, 248, 5, 70, "Text"],

Cell[CellGroupData[{
Cell[10184, 385, 429, 14, 70, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[10616, 401, 111, 3, 70, 36, 0, "StyleData", "Input", "Printout"],
Cell[10730, 406, 119, 3, 70, 44, 0, "StyleData", "Input", \
"EnhancedPrintout"],
Cell[10852, 411, 126, 3, 70, 51, 0, "StyleData", "Input", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[11015, 419, 416, 13, 70, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[11434, 434, 112, 3, 70, 37, 0, "StyleData", "Output", "Printout"],
Cell[11549, 439, 120, 3, 70, 45, 0, "StyleData", "Output", \
"EnhancedPrintout"],
Cell[11672, 444, 127, 3, 70, 52, 0, "StyleData", "Output", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[11836, 452, 549, 16, 70, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[12388, 470, 164, 4, 70, 38, 0, "StyleData", "Message", "Printout"],
Cell[12555, 476, 197, 5, 70, 46, 0, "StyleData", "Message", \
"EnhancedPrintout"],
Cell[12755, 483, 204, 5, 70, 53, 0, "StyleData", "Message", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[12996, 493, 523, 15, 70, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[13522, 510, 135, 3, 70, 36, 0, "StyleData", "Print", "Printout"],
Cell[13660, 515, 168, 4, 70, 44, 0, "StyleData", "Print", \
"EnhancedPrintout"],
Cell[13831, 521, 175, 4, 70, 51, 0, "StyleData", "Print", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[14043, 530, 414, 12, 70, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[14460, 544, 163, 4, 70, 39, 0, "StyleData", "Graphics", "Printout"],
Cell[14626, 550, 196, 5, 70, 47, 0, "StyleData", "Graphics", \
"EnhancedPrintout"],
Cell[14825, 557, 203, 5, 70, 54, 0, "StyleData", "Graphics", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[15065, 567, 128, 4, 70, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[15196, 573, 130, 4, 70, 40, 0, "StyleData", "CellLabel", "Printout"],
Cell[15329, 579, 138, 4, 70, 48, 0, "StyleData", "CellLabel", \
"EnhancedPrintout"],
Cell[15470, 585, 145, 4, 70, 55, 0, "StyleData", "CellLabel", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15664, 595, 36, 0, 36, "Section"],
Cell[15703, 597, 121, 3, 70, "Text"],
Cell[15827, 602, 92, 3, 70, 21, 0, "StyleData", "RM", "All",
  StyleMenuListing->None],
Cell[15922, 607, 69, 2, 70, 21, 0, "StyleData", "BF", "All",
  StyleMenuListing->None],
Cell[15994, 611, 70, 2, 70, 21, 0, "StyleData", "IT", "All",
  StyleMenuListing->None],
Cell[16067, 615, 115, 4, 70, 21, 0, "StyleData", "TR", "All",
  StyleMenuListing->None],
Cell[16185, 621, 116, 4, 70, 21, 0, "StyleData", "TI", "All",
  StyleMenuListing->None],
Cell[16304, 627, 114, 4, 70, 21, 0, "StyleData", "TB", "All",
  StyleMenuListing->None],
Cell[16421, 633, 116, 4, 70, 22, 0, "StyleData", "TBI", "All",
  StyleMenuListing->None],
Cell[16540, 639, 117, 4, 70, 21, 0, "StyleData", "MR", "All",
  StyleMenuListing->None],
Cell[16660, 645, 118, 4, 70, 21, 0, "StyleData", "MO", "All",
  StyleMenuListing->None],
Cell[16781, 651, 116, 4, 70, 21, 0, "StyleData", "MB", "All",
  StyleMenuListing->None],
Cell[16900, 657, 118, 4, 70, 22, 0, "StyleData", "MBO", "All",
  StyleMenuListing->None],
Cell[17021, 663, 119, 4, 70, 21, 0, "StyleData", "SR", "All",
  StyleMenuListing->None],
Cell[17143, 669, 120, 4, 70, 21, 0, "StyleData", "SO", "All",
  StyleMenuListing->None],
Cell[17266, 675, 118, 4, 70, 21, 0, "StyleData", "SB", "All",
  StyleMenuListing->None],
Cell[17387, 681, 120, 4, 70, 22, 0, "StyleData", "SBO", "All",
  StyleMenuListing->None],

Cell[CellGroupData[{
Cell[17532, 689, 138, 5, 70, 23, 0, "StyleData", "SO10", "All",
  StyleMenuListing->None],
Cell[17673, 696, 149, 5, 70, 35, 0, "StyleData", "SO10", "Printout",
  StyleMenuListing->None],
Cell[17825, 703, 154, 5, 70, 43, 0, "StyleData", "SO10", "EnhancedPrintout",
  StyleMenuListing->None]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[18028, 714, 39, 0, 36, "Section"],

Cell[CellGroupData[{
Cell[18092, 718, 215, 6, 70, 30, 0, "StyleData", "MathCaption", "All"],
Cell[18310, 726, 121, 3, 70, 42, 0, "StyleData", "MathCaption", "Printout"],
Cell[18434, 731, 155, 4, 70, 50, 0, "StyleData", "MathCaption", \
"EnhancedPrintout"],
Cell[18592, 737, 162, 4, 70, 57, 0, "StyleData", "MathCaption", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[18791, 746, 256, 8, 70, 29, 0, "StyleData", "Commentary", "All"],
Cell[19050, 756, 125, 3, 70, 41, 0, "StyleData", "Commentary", "Printout"],
Cell[19178, 761, 159, 4, 70, 49, 0, "StyleData", "Commentary", \
"EnhancedPrintout"],
Cell[19340, 767, 166, 4, 70, 56, 0, "StyleData", "Commentary", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[19543, 776, 177, 5, 70, 31, 0, "StyleData", "ItemizedText", "All",
  CounterIncrements->"ItemizedText"],
Cell[19723, 783, 83, 2, 70, 43, 0, "StyleData", "ItemizedText", "Printout"],
Cell[19809, 787, 117, 3, 70, 51, 0, "StyleData", "ItemizedText", \
"EnhancedPrintout"],
Cell[19929, 792, 124, 3, 70, 58, 0, "StyleData", "ItemizedText", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[20090, 800, 149, 4, 70, 35, 0, "StyleData", "ItemizedTextNote", "All",
  CounterIncrements->"Text"],
Cell[20242, 806, 97, 2, 70, 47, 0, "StyleData", "ItemizedTextNote", \
"Printout"],
Cell[20342, 810, 131, 3, 70, 55, 0, "StyleData", "ItemizedTextNote", \
"EnhancedPrintout"],
Cell[20476, 815, 138, 3, 70, 62, 0, "StyleData", "ItemizedTextNote", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[20651, 823, 138, 4, 70, 29, 0, "StyleData", "BulletText", "All"],
Cell[20792, 829, 81, 2, 70, 41, 0, "StyleData", "BulletText", "Printout"],
Cell[20876, 833, 115, 3, 70, 49, 0, "StyleData", "BulletText", \
"EnhancedPrintout"],
Cell[20994, 838, 122, 3, 70, 56, 0, "StyleData", "BulletText", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[21153, 846, 145, 4, 70, 31, 0, "StyleData", "IndentedText", "All",
  CounterIncrements->"Text"],
Cell[21301, 852, 59, 1, 70, 43, 0, "StyleData", "IndentedText", "Printout"],
Cell[21363, 855, 93, 2, 70, 51, 0, "StyleData", "IndentedText", \
"EnhancedPrintout"],
Cell[21459, 859, 100, 2, 70, 58, 0, "StyleData", "IndentedText", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[21608, 867, 46, 0, 36, "Section"],

Cell[CellGroupData[{
Cell[21679, 871, 434, 15, 70, 32, 0, "StyleData", "DefinitionBox", "All",
  StyleMenuListing->None],
Cell[22116, 888, 128, 3, 70, 44, 0, "StyleData", "DefinitionBox", \
"Printout"],
Cell[22247, 893, 162, 4, 70, 52, 0, "StyleData", "DefinitionBox", \
"EnhancedPrintout"],
Cell[22412, 899, 162, 4, 70, 59, 0, "StyleData", "DefinitionBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[22611, 908, 443, 15, 70, 36, 0, "StyleData", "DefinitionBox3Col", "All",
  StyleMenuListing->None],
Cell[23057, 925, 132, 3, 70, 48, 0, "StyleData", "DefinitionBox3Col", \
"Printout"],
Cell[23192, 930, 166, 4, 70, 56, 0, "StyleData", "DefinitionBox3Col", \
"EnhancedPrintout"],
Cell[23361, 936, 166, 4, 70, 63, 0, "StyleData", "DefinitionBox3Col", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[23564, 945, 452, 15, 70, 36, 0, "StyleData", "DefinitionBox4Col", "All",
  StyleMenuListing->None],
Cell[24019, 962, 132, 3, 70, 48, 0, "StyleData", "DefinitionBox4Col", \
"Printout"],
Cell[24154, 967, 166, 4, 70, 56, 0, "StyleData", "DefinitionBox4Col", \
"EnhancedPrintout"],
Cell[24323, 973, 166, 4, 70, 63, 0, "StyleData", "DefinitionBox4Col", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[24526, 982, 431, 15, 70, 36, 0, "StyleData", "DefinitionBox5Col", "All",
  StyleMenuListing->None],
Cell[24960, 999, 132, 3, 70, 48, 0, "StyleData", "DefinitionBox5Col", \
"Printout"],
Cell[25095, 1004, 166, 4, 70, 56, 0, "StyleData", "DefinitionBox5Col", \
"EnhancedPrintout"],
Cell[25264, 1010, 166, 4, 70, 63, 0, "StyleData", "DefinitionBox5Col", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[25467, 1019, 464, 15, 70, 36, 0, "StyleData", "DefinitionBox6Col", "All",
  
  StyleMenuListing->None],
Cell[25934, 1036, 132, 3, 70, 48, 0, "StyleData", "DefinitionBox6Col", \
"Printout"],
Cell[26069, 1041, 166, 4, 70, 56, 0, "StyleData", "DefinitionBox6Col", \
"EnhancedPrintout"],
Cell[26238, 1047, 166, 4, 70, 63, 0, "StyleData", "DefinitionBox6Col", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[26441, 1056, 447, 15, 70, 25, 0, "StyleData", "TopBox", "All",
  StyleMenuListing->None],
Cell[26891, 1073, 121, 3, 70, 37, 0, "StyleData", "TopBox", "Printout"],
Cell[27015, 1078, 155, 4, 70, 45, 0, "StyleData", "TopBox", \
"EnhancedPrintout"],
Cell[27173, 1084, 155, 4, 70, 52, 0, "StyleData", "TopBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[27365, 1093, 474, 16, 70, 28, 0, "StyleData", "MiddleBox", "All",
  StyleMenuListing->None],
Cell[27842, 1111, 154, 4, 70, 40, 0, "StyleData", "MiddleBox", "Printout"],
Cell[27999, 1117, 188, 5, 70, 48, 0, "StyleData", "MiddleBox", \
"EnhancedPrintout"],
Cell[28190, 1124, 188, 5, 70, 55, 0, "StyleData", "MiddleBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[28415, 1134, 501, 17, 70, 34, 0, "StyleData", "MiddleSpacedBox", "All",
  StyleMenuListing->None],
Cell[28919, 1153, 169, 4, 70, 46, 0, "StyleData", "MiddleSpacedBox", \
"Printout"],
Cell[29091, 1159, 203, 5, 70, 54, 0, "StyleData", "MiddleSpacedBox", \
"EnhancedPrintout"],
Cell[29297, 1166, 203, 5, 70, 61, 0, "StyleData", "MiddleSpacedBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[29537, 1176, 497, 17, 70, 28, 0, "StyleData", "BottomBox", "All",
  StyleMenuListing->None],
Cell[30037, 1195, 164, 4, 70, 40, 0, "StyleData", "BottomBox", "Printout"],
Cell[30204, 1201, 198, 5, 70, 48, 0, "StyleData", "BottomBox", \
"EnhancedPrintout"],
Cell[30405, 1208, 198, 5, 70, 55, 0, "StyleData", "BottomBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[30640, 1218, 451, 15, 70, 29, 0, "StyleData", "TopSpanBox", "All",
  StyleMenuListing->None],
Cell[31094, 1235, 126, 3, 70, 41, 0, "StyleData", "TopSpanBox", "Printout"],
Cell[31223, 1240, 160, 4, 70, 49, 0, "StyleData", "TopSpanBox", \
"EnhancedPrintout"],
Cell[31386, 1246, 160, 4, 70, 56, 0, "StyleData", "TopSpanBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[31583, 1255, 499, 17, 70, 32, 0, "StyleData", "MiddleSpanBox", "All",
  StyleMenuListing->None],
Cell[32085, 1274, 168, 4, 70, 44, 0, "StyleData", "MiddleSpanBox", \
"Printout"],
Cell[32256, 1280, 202, 5, 70, 52, 0, "StyleData", "MiddleSpanBox", \
"EnhancedPrintout"],
Cell[32461, 1287, 202, 5, 70, 59, 0, "StyleData", "MiddleSpanBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[32700, 1297, 101, 2, 70, 26, 0, "StyleData", "Picture", "All"],
Cell[32804, 1301, 79, 1, 70, 38, 0, "StyleData", "Picture", "Printout"],
Cell[32886, 1304, 87, 1, 70, 46, 0, "StyleData", "Picture", \
"EnhancedPrintout"],
Cell[32976, 1307, 94, 1, 70, 53, 0, "StyleData", "Picture", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[33107, 1313, 127, 4, 70, 26, 0, "StyleData", "Caption", "All"],
Cell[33237, 1319, 86, 2, 70, 38, 0, "StyleData", "Caption", "Printout"],
Cell[33326, 1323, 118, 3, 70, 46, 0, "StyleData", "Caption", \
"EnhancedPrintout"],
Cell[33447, 1328, 125, 3, 70, 53, 0, "StyleData", "Caption", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[33621, 1337, 25, 0, 36, "Section"],

Cell[CellGroupData[{
Cell[33671, 1341, 329, 11, 70, 33, 0, "StyleData", "SingleRowTable", "All",
  StyleMenuListing->None],
Cell[34003, 1354, 94, 2, 70, 45, 0, "StyleData", "SingleRowTable", \
"Printout"],
Cell[34100, 1358, 102, 2, 70, 53, 0, "StyleData", "SingleRowTable", \
"EnhancedPrintout"],
Cell[34205, 1362, 109, 2, 70, 60, 0, "StyleData", "SingleRowTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[34351, 1369, 365, 12, 70, 31, 0, "StyleData", "2ColumnTable", "All",
  StyleMenuListing->None],
Cell[34719, 1383, 92, 2, 70, 43, 0, "StyleData", "2ColumnTable", "Printout"],
Cell[34814, 1387, 100, 2, 70, 51, 0, "StyleData", "2ColumnTable", \
"EnhancedPrintout"],
Cell[34917, 1391, 107, 2, 70, 58, 0, "StyleData", "2ColumnTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[35061, 1398, 361, 12, 70, 35, 0, "StyleData", "2ColumnEvenTable", "All",
  StyleMenuListing->None],
Cell[35425, 1412, 96, 2, 70, 47, 0, "StyleData", "2ColumnEvenTable", \
"Printout"],
Cell[35524, 1416, 104, 2, 70, 55, 0, "StyleData", "2ColumnEvenTable", \
"EnhancedPrintout"],
Cell[35631, 1420, 111, 2, 70, 62, 0, "StyleData", "2ColumnEvenTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[35779, 1427, 442, 13, 70, 31, 0, "StyleData", "3ColumnTable", "All",
  CounterIncrements->"Table",
  StyleMenuListing->None],
Cell[36224, 1442, 93, 2, 70, 43, 0, "StyleData", "3ColumnTable", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[36354, 1449, 447, 13, 70, 36, 0, "StyleData", "3ColumnTablePlain", "All",
  
  CounterIncrements->"Table",
  StyleMenuListing->None],
Cell[36804, 1464, 98, 2, 70, 48, 0, "StyleData", "3ColumnTablePlain", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[36939, 1471, 442, 13, 70, 31, 0, "StyleData", "4ColumnTable", "All",
  CounterIncrements->"Table",
  StyleMenuListing->None],
Cell[37384, 1486, 93, 2, 70, 43, 0, "StyleData", "4ColumnTable", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[37514, 1493, 447, 13, 70, 36, 0, "StyleData", "4ColumnTablePlain", "All",
  
  CounterIncrements->"Table",
  StyleMenuListing->None],
Cell[37964, 1508, 98, 2, 70, 48, 0, "StyleData", "4ColumnTablePlain", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[38099, 1515, 442, 13, 70, 31, 0, "StyleData", "5ColumnTable", "All",
  CounterIncrements->"Table",
  StyleMenuListing->None],
Cell[38544, 1530, 93, 2, 70, 43, 0, "StyleData", "5ColumnTable", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[38674, 1537, 447, 13, 70, 36, 0, "StyleData", "5ColumnTablePlain", "All",
  
  CounterIncrements->"Table",
  StyleMenuListing->None],
Cell[39124, 1552, 98, 2, 70, 48, 0, "StyleData", "5ColumnTablePlain", \
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[39259, 1559, 357, 12, 70, 31, 0, "StyleData", "6ColumnTable", "All",
  StyleMenuListing->None],
Cell[39619, 1573, 92, 2, 70, 43, 0, "StyleData", "6ColumnTable", "Printout"],
Cell[39714, 1577, 100, 2, 70, 51, 0, "StyleData", "6ColumnTable", \
"EnhancedPrintout"],
Cell[39817, 1581, 107, 2, 70, 58, 0, "StyleData", "6ColumnTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[39961, 1588, 357, 12, 70, 31, 0, "StyleData", "7ColumnTable", "All",
  StyleMenuListing->None],
Cell[40321, 1602, 92, 2, 70, 43, 0, "StyleData", "7ColumnTable", "Printout"],
Cell[40416, 1606, 100, 2, 70, 51, 0, "StyleData", "7ColumnTable", \
"EnhancedPrintout"],
Cell[40519, 1610, 107, 2, 70, 58, 0, "StyleData", "7ColumnTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[40663, 1617, 357, 12, 70, 31, 0, "StyleData", "8ColumnTable", "All",
  StyleMenuListing->None],
Cell[41023, 1631, 92, 2, 70, 43, 0, "StyleData", "8ColumnTable", "Printout"],
Cell[41118, 1635, 100, 2, 70, 51, 0, "StyleData", "8ColumnTable", \
"EnhancedPrintout"],
Cell[41221, 1639, 107, 2, 70, 58, 0, "StyleData", "8ColumnTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[41365, 1646, 275, 9, 70, 28, 0, "StyleData", "TableHead", "All",
  CounterIncrements->"TableHead",
  StyleMenuListing->None],
Cell[41643, 1657, 56, 1, 70, 40, 0, "StyleData", "TableHead", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[41736, 1663, 435, 13, 70, 24, 0, "StyleData", "Table", "All",
  CounterIncrements->"Table",
  StyleMenuListing->None],
Cell[42174, 1678, 86, 2, 70, 36, 0, "StyleData", "Table", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[42297, 1685, 440, 13, 70, 29, 0, "StyleData", "TablePlain", "All",
  CounterIncrements->"Table",
  StyleMenuListing->None],
Cell[42740, 1700, 91, 2, 70, 41, 0, "StyleData", "TablePlain", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[42868, 1707, 173, 6, 70, 28, 0, "StyleData", "TableNote", "All"],
Cell[43044, 1715, 55, 1, 70, 40, 0, "StyleData", "TableNote", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[43136, 1721, 46, 0, 70, "Subsection"],

Cell[CellGroupData[{
Cell[43207, 1725, 112, 3, 70, 32, 0, "StyleData", "TableHeadText", "All",
  CounterIncrements->"TableHead"],
Cell[43322, 1730, 60, 1, 70, 44, 0, "StyleData", "TableHeadText", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[43419, 1736, 105, 3, 70, 29, 0, "StyleData", "ColumnHead", "All",
  CounterIncrements->"Table"],
Cell[43527, 1741, 57, 1, 70, 41, 0, "StyleData", "ColumnHead", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[43621, 1747, 113, 4, 70, 28, 0, "StyleData", "TableText", "All"],
Cell[43737, 1753, 56, 1, 70, 40, 0, "StyleData", "TableText", "Printout"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[43854, 1761, 49, 0, 36, "Section"],
Cell[43906, 1763, 225, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[44156, 1771, 342, 8, 70, 35, 0, "StyleData", "NumberedEquation", "All",
  CounterIncrements->"NumberedEquation"],
Cell[44501, 1781, 99, 2, 70, 47, 0, "StyleData", "NumberedEquation", \
"Printout"],
Cell[44603, 1785, 133, 3, 70, 55, 0, "StyleData", "NumberedEquation", \
"EnhancedPrintout"],
Cell[44739, 1790, 140, 3, 70, 62, 0, "StyleData", "NumberedEquation", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[44928, 1799, 43, 0, 36, "Section"],

Cell[CellGroupData[{
Cell[44996, 1803, 236, 6, 42, 33, 0, "StyleData", "DisplayFormula", "All"],
Cell[45235, 1811, 61, 1, 70, 45, 0, "StyleData", "DisplayFormula", \
"Printout"],
Cell[45299, 1814, 95, 2, 70, 53, 0, "StyleData", "DisplayFormula", \
"EnhancedPrintout"],
Cell[45397, 1818, 102, 2, 70, 60, 0, "StyleData", "DisplayFormula", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[45536, 1825, 389, 12, 39, 30, 0, "StyleData", "DisplayMath", "All",
  CounterIncrements->"Input"],
Cell[45928, 1839, 91, 2, 70, 42, 0, "StyleData", "DisplayMath", "Printout"],
Cell[46022, 1843, 127, 3, 70, 50, 0, "StyleData", "DisplayMath", \
"EnhancedPrintout"],
Cell[46152, 1848, 134, 3, 70, 57, 0, "StyleData", "DisplayMath", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[46323, 1856, 59, 1, 36, 33, 0, "StyleData", "EquationNumber", "All"],
Cell[46385, 1859, 86, 2, 70, 45, 0, "StyleData", "EquationNumber", \
"Printout"],
Cell[46474, 1863, 120, 3, 70, 53, 0, "StyleData", "EquationNumber", \
"EnhancedPrintout"],
Cell[46597, 1868, 127, 3, 70, 60, 0, "StyleData", "EquationNumber", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[46761, 1876, 166, 4, 52, 26, 0, "StyleData", "Program", "All"],
Cell[46930, 1882, 98, 2, 70, 38, 0, "StyleData", "Program", "Printout"],
Cell[47031, 1886, 134, 3, 70, 46, 0, "StyleData", "Program", \
"EnhancedPrintout"],
Cell[47168, 1891, 141, 3, 70, 53, 0, "StyleData", "Program", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[47358, 1900, 37, 0, 36, "Section"],

Cell[CellGroupData[{
Cell[47420, 1904, 261, 8, 60, 32, 0, "StyleData", "ContentsTitle", "All",
  StyleMenuListing->None],
Cell[47684, 1914, 119, 3, 55, 44, 0, "StyleData", "ContentsTitle", \
"Printout"],
Cell[47806, 1919, 151, 4, 54, 52, 0, "StyleData", "ContentsTitle", \
"EnhancedPrintout"],
Cell[47960, 1925, 158, 4, 54, 59, 0, "StyleData", "ContentsTitle", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[48155, 1934, 238, 7, 37, 34, 0, "StyleData", "ContentsSection", "All",
  StyleMenuListing->None],
Cell[48396, 1943, 122, 3, 48, 46, 0, "StyleData", "ContentsSection", \
"Printout"],
Cell[48521, 1948, 154, 4, 49, 54, 0, "StyleData", "ContentsSection", \
"EnhancedPrintout"],
Cell[48678, 1954, 161, 4, 49, 61, 0, "StyleData", "ContentsSection", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[48876, 1963, 191, 6, 39, 31, 0, "StyleData", "IndexSection", "All",
  StyleMenuListing->None],
Cell[49070, 1971, 119, 3, 55, 43, 0, "StyleData", "IndexSection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[49226, 1979, 166, 4, 33, 27, 0, "StyleData", "Contents", "All",
  StyleMenuListing->None],
Cell[49395, 1985, 89, 2, 32, 39, 0, "StyleData", "Contents", "Printout"],
Cell[49487, 1989, 123, 3, 33, 47, 0, "StyleData", "Contents", \
"EnhancedPrintout"],
Cell[49613, 1994, 130, 3, 33, 54, 0, "StyleData", "Contents", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[49780, 2002, 108, 3, 28, 24, 0, "StyleData", "Index", "All",
  StyleMenuListing->None],
Cell[49891, 2007, 86, 2, 27, 36, 0, "StyleData", "Index", "Printout"],
Cell[49980, 2011, 120, 3, 28, 44, 0, "StyleData", "Index", \
"EnhancedPrintout"],
Cell[50103, 2016, 127, 3, 28, 51, 0, "StyleData", "Index", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[50267, 2024, 116, 3, 32, 32, 0, "StyleData", "IndexSubentry", "All",
  StyleMenuListing->None],
Cell[50386, 2029, 94, 2, 27, 44, 0, "StyleData", "IndexSubentry", \
"Printout"],
Cell[50483, 2033, 128, 3, 28, 52, 0, "StyleData", "IndexSubentry", \
"EnhancedPrintout"],
Cell[50614, 2038, 135, 3, 28, 59, 0, "StyleData", "IndexSubentry", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[50798, 2047, 32, 0, 36, "Section"],

Cell[CellGroupData[{
Cell[50855, 2051, 264, 8, 70, 31, 0, "StyleData", "FunctionName", "All",
  CellTags->"FunctionName"],
Cell[51122, 2061, 94, 2, 70, 43, 0, "StyleData", "FunctionName", "Printout"],
Cell[51219, 2065, 127, 3, 70, 51, 0, "StyleData", "FunctionName", \
"EnhancedPrintout"],
Cell[51349, 2070, 134, 3, 70, 58, 0, "StyleData", "FunctionName", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[51520, 2078, 241, 7, 70, 33, 0, "StyleData", "SubsectionIcon", "All",
  CellTags->"FunctionSection"],
Cell[51764, 2087, 96, 2, 70, 45, 0, "StyleData", "SubsectionIcon", \
"Printout"],
Cell[51863, 2091, 130, 3, 70, 53, 0, "StyleData", "SubsectionIcon", \
"EnhancedPrintout"],
Cell[51996, 2096, 137, 3, 70, 60, 0, "StyleData", "SubsectionIcon", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[52170, 2104, 233, 6, 70, 37, 0, "StyleData", "FunctionSubsection", \
"All",
  CellTags->"FunctionSubsection"],
Cell[52406, 2112, 83, 1, 70, 49, 0, "StyleData", "FunctionSubsection", \
"Printout"],
Cell[52492, 2115, 133, 3, 70, 57, 0, "StyleData", "FunctionSubsection", \
"EnhancedPrintout"],
Cell[52628, 2120, 140, 3, 70, 64, 0, "StyleData", "FunctionSubsection", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[52805, 2128, 229, 6, 70, 36, 0, "StyleData", "SubsubsectionIcon", "All",
  CellTags->"SubsubsectionIcon"],
Cell[53037, 2136, 98, 2, 70, 48, 0, "StyleData", "SubsubsectionIcon", \
"Printout"],
Cell[53138, 2140, 131, 3, 70, 56, 0, "StyleData", "SubsubsectionIcon", \
"EnhancedPrintout"],
Cell[53272, 2145, 138, 3, 70, 63, 0, "StyleData", "SubsubsectionIcon", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[53447, 2153, 178, 5, 70, 38, 0, "StyleData", "FunctionDescription", \
"All",
  CounterIncrements->"Text"],
Cell[53628, 2160, 100, 2, 70, 50, 0, "StyleData", "FunctionDescription", \
"Printout"],
Cell[53731, 2164, 158, 4, 70, 58, 0, "StyleData", "FunctionDescription", \
"EnhancedPrintout"],
Cell[53892, 2170, 165, 4, 70, 65, 0, "StyleData", "FunctionDescription", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[54094, 2179, 197, 5, 70, 43, 0, "StyleData", "FunctionDescriptionRuled", \
"All",
  CounterIncrements->"Text"],
Cell[54294, 2186, 105, 2, 70, 55, 0, "StyleData", "FunctionDescriptionRuled", \
"Printout"],
Cell[54402, 2190, 163, 4, 70, 63, 0, "StyleData", "FunctionDescriptionRuled", \
"EnhancedPrintout"],
Cell[54568, 2196, 170, 4, 70, 70, 0, "StyleData", "FunctionDescriptionRuled", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[54775, 2205, 196, 5, 70, 45, 0, "StyleData", \
"FunctionDescriptionRuleTop", "All",
  CounterIncrements->"Text"],
Cell[54974, 2212, 107, 2, 70, 57, 0, "StyleData", \
"FunctionDescriptionRuleTop", "Printout"],
Cell[55084, 2216, 165, 4, 70, 65, 0, "StyleData", \
"FunctionDescriptionRuleTop", "EnhancedPrintout"],
Cell[55252, 2222, 172, 4, 70, 72, 0, "StyleData", \
"FunctionDescriptionRuleTop", "EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[55461, 2231, 199, 5, 70, 48, 0, "StyleData", \
"FunctionDescriptionRuleBottom", "All",
  CounterIncrements->"Text"],
Cell[55663, 2238, 110, 2, 70, 60, 0, "StyleData", \
"FunctionDescriptionRuleBottom", "Printout"],
Cell[55776, 2242, 168, 4, 70, 68, 0, "StyleData", \
"FunctionDescriptionRuleBottom", "EnhancedPrintout"],
Cell[55947, 2248, 175, 4, 70, 75, 0, "StyleData", \
"FunctionDescriptionRuleBottom", "EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[56159, 2257, 111, 3, 70, 34, 0, "StyleData", "FunctionExample", "All",
  StyleMenuListing->None],
Cell[56273, 2262, 95, 2, 70, 46, 0, "StyleData", "FunctionExample", \
"Printout"],
Cell[56371, 2266, 129, 3, 70, 54, 0, "StyleData", "FunctionExample", \
"EnhancedPrintout"],
Cell[56503, 2271, 136, 3, 70, 61, 0, "StyleData", "FunctionExample", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[56676, 2279, 137, 4, 70, 35, 0, "StyleData", "FunctionTextNote", "All"],
Cell[56816, 2285, 96, 2, 70, 47, 0, "StyleData", "FunctionTextNote", \
"Printout"],
Cell[56915, 2289, 130, 3, 70, 55, 0, "StyleData", "FunctionTextNote", \
"EnhancedPrintout"],
Cell[57048, 2294, 137, 3, 70, 62, 0, "StyleData", "FunctionTextNote", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[57222, 2302, 315, 10, 70, 39, 0, "StyleData", "3ColumnFunctionTable", \
"All"],
Cell[57540, 2314, 101, 2, 70, 51, 0, "StyleData", "3ColumnFunctionTable", \
"Printout"],
Cell[57644, 2318, 109, 2, 70, 59, 0, "StyleData", "3ColumnFunctionTable", \
"EnhancedPrintout"],
Cell[57756, 2322, 116, 2, 70, 66, 0, "StyleData", "3ColumnFunctionTable", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[57921, 2330, 36, 0, 36, "Section"],

Cell[CellGroupData[{
Cell[57982, 2334, 155, 5, 70, 29, 0, "StyleData", "TextNormal", "All",
  CounterIncrements->"Text"],
Cell[58140, 2341, 90, 2, 70, 41, 0, "StyleData", "TextNormal", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[58267, 2348, 299, 9, 70, 35, 0, "StyleData", "BrowserEmulation", "All"],
Cell[58569, 2359, 84, 2, 70, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[58690, 2366, 259, 8, 70, 31, 0, "StyleData", "CategoryDefs", "All"],
Cell[58952, 2376, 84, 2, 70, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[59073, 2383, 205, 6, 70, 28, 0, "StyleData", "Category1", "All"],
Cell[59281, 2391, 73, 1, 70, 40, 0, "StyleData", "Category1", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[59391, 2397, 244, 7, 70, 28, 0, "StyleData", "Category2", "All"],
Cell[59638, 2406, 73, 1, 70, 40, 0, "StyleData", "Category2", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[59748, 2412, 242, 7, 70, 28, 0, "StyleData", "Category3", "All"],
Cell[59993, 2421, 73, 1, 70, 40, 0, "StyleData", "Category3", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[60103, 2427, 231, 6, 70, 28, 0, "StyleData", "Category4", "All"],
Cell[60337, 2435, 73, 1, 70, 40, 0, "StyleData", "Category4", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[60459, 2442, 49, 0, 36, "Section"],

Cell[CellGroupData[{
Cell[60533, 2446, 148, 5, 70, 25, 0, "StyleData", "Header", "All",
  StyleMenuListing->None],
Cell[60684, 2453, 37, 0, 70, 37, 0, "StyleData", "Header", "Printout"],
Cell[60724, 2455, 69, 1, 70, 45, 0, "StyleData", "Header", \
"EnhancedPrintout"],
Cell[60796, 2458, 76, 1, 70, 52, 0, "StyleData", "Header", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[60909, 2464, 148, 5, 70, 25, 0, "StyleData", "Footer", "All",
  StyleMenuListing->None],
Cell[61060, 2471, 37, 0, 70, 37, 0, "StyleData", "Footer", "Printout"],
Cell[61100, 2473, 69, 1, 70, 45, 0, "StyleData", "Footer", \
"EnhancedPrintout"],
Cell[61172, 2476, 76, 1, 70, 52, 0, "StyleData", "Footer", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[61285, 2482, 152, 5, 70, 29, 0, "StyleData", "PageNumber", "All",
  StyleMenuListing->None],
Cell[61440, 2489, 41, 0, 70, 41, 0, "StyleData", "PageNumber", "Printout"],
Cell[61484, 2491, 73, 1, 70, 49, 0, "StyleData", "PageNumber", \
"EnhancedPrintout"],
Cell[61560, 2494, 80, 1, 70, 56, 0, "StyleData", "PageNumber", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[61689, 2501, 35, 0, 36, "Section"],
Cell[61727, 2503, 184, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[61936, 2511, 302, 8, 70, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[62241, 2521, 123, 3, 70, 40, 0, "StyleData", "Hyperlink", "Printout"],
Cell[62367, 2526, 157, 4, 70, 48, 0, "StyleData", "Hyperlink", \
"EnhancedPrintout"],
Cell[62527, 2532, 164, 4, 70, 55, 0, "StyleData", "Hyperlink", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[62706, 2539, 104, 3, 70, "Text"],

Cell[CellGroupData[{
Cell[62835, 2546, 316, 8, 70, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[63154, 2556, 126, 3, 70, 43, 0, "StyleData", "MainBookLink", \
"Printout"],
Cell[63283, 2561, 160, 4, 70, 51, 0, "StyleData", "MainBookLink", \
"EnhancedPrintout"],
Cell[63446, 2567, 167, 4, 70, 58, 0, "StyleData", "MainBookLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[63650, 2576, 337, 9, 70, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[63990, 2587, 124, 3, 70, 41, 0, "StyleData", "AddOnsLink", "Printout"],
Cell[64117, 2592, 132, 3, 70, 49, 0, "StyleData", "AddOnsLink", \
"EnhancedPrintout"],
Cell[64252, 2597, 139, 3, 70, 56, 0, "StyleData", "AddOnsLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[64428, 2605, 339, 9, 70, 33, 0, "StyleData", "AddOnsLinkText", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[64770, 2616, 128, 3, 70, 45, 0, "StyleData", "AddOnsLinkText", \
"Printout"],
Cell[64901, 2621, 136, 3, 70, 53, 0, "StyleData", "AddOnsLinkText", \
"EnhancedPrintout"],
Cell[65040, 2626, 143, 3, 70, 60, 0, "StyleData", "AddOnsLinkText", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[65220, 2634, 341, 9, 70, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[65564, 2645, 126, 3, 70, 43, 0, "StyleData", "RefGuideLink", \
"Printout"],
Cell[65693, 2650, 162, 4, 70, 51, 0, "StyleData", "RefGuideLink", \
"EnhancedPrintout"],
Cell[65858, 2656, 169, 4, 70, 58, 0, "StyleData", "RefGuideLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[66064, 2665, 328, 8, 70, 37, 0, "StyleData", "GettingStartedLink", "All",
  
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[66395, 2675, 132, 3, 70, 49, 0, "StyleData", "GettingStartedLink", \
"Printout"],
Cell[66530, 2680, 166, 4, 70, 57, 0, "StyleData", "GettingStartedLink", \
"EnhancedPrintout"],
Cell[66699, 2686, 173, 4, 70, 64, 0, "StyleData", "GettingStartedLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],

Cell[CellGroupData[{
Cell[66909, 2695, 332, 8, 70, 39, 0, "StyleData", "OtherInformationLink", \
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[67244, 2705, 134, 3, 70, 51, 0, "StyleData", "OtherInformationLink", \
"Printout"],
Cell[67381, 2710, 168, 4, 70, 59, 0, "StyleData", "OtherInformationLink", \
"EnhancedPrintout"],
Cell[67552, 2716, 175, 4, 70, 66, 0, "StyleData", "OtherInformationLink", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[67776, 2726, 33, 0, 36, "Section"],

Cell[CellGroupData[{
Cell[67834, 2730, 264, 7, 51, 27, 0, "StyleData", "Outline1", "All",
  CounterIncrements->"Outline1"],
Cell[68101, 2739, 100, 1, 70, 39, 0, "StyleData", "Outline1", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[68238, 2745, 290, 8, 42, 27, 0, "StyleData", "Outline2", "All",
  CounterIncrements->"Outline2"],
Cell[68531, 2755, 126, 2, 70, 39, 0, "StyleData", "Outline2", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[68694, 2762, 232, 6, 39, 27, 0, "StyleData", "Outline3", "All",
  CounterIncrements->"Outline3"],
Cell[68929, 2770, 89, 1, 70, 39, 0, "StyleData", "Outline3", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[69055, 2776, 269, 7, 38, 27, 0, "StyleData", "Outline4", "All",
  CounterIncrements->"Outline4"],
Cell[69327, 2785, 39, 0, 70, 39, 0, "StyleData", "Outline4", "Printout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

