(* :Title: Kernel Initialization Declarations File for ProPac *)

(* :Summary:
        This file contains declarations of all the major symbols
        contained in files in this directory.  When loaded, it sets
        up the symbols with attribute Stub, so the correct package
        will be loaded when the symbol is called.  *)

(* :Author: This file was created by Harry G. Kwatny *)

(* :History: File created on 1 March 1997 *)

BeginPackage["ProPac`Kernel`init`"]
EndPackage[]


(* Declarations for file ProPac`GeoTools` *)

DeclarePackage["ProPac`GeoTools`",{"GeometricTools","ExpMap","FlowComposition","Grad",
"Jacob","LieBracket","Ad","LieDerivative","Involutive","Rank","Span","SpecialInverse",
"SpecialNullSpace","EquilibriumSurface","ParametricManifold","SimplifyArray",
"WriteArray","LeftInverse","RightInverse","TriangularDecomposition",
"SmallestInvariantDistribution","LargestInvariantDistribution","ComplementDistribution",
"IntersectionDistribution","PhasePortrait"}]


(* Declarations for file ProPac`NDTools` *)

DeclarePackage["ProPac`NDTools`",
     {"Sgn", "Sat","Sig", "BacklashPotential", "BacklashForce","JointFrictionPotential","SimplifyDiracDelta1",
     "UnitStep2Sign"}]
     
(* Declarations for file ProPac`VSCTools` *)

DeclarePackage["ProPac`VSCTools`",
   {"SlidingSurface","SwitchingControl"}]

(* Declarations for file ProPac`MatlabInterface` *)

DeclarePackage["ProPac`MatlabInterface`",
     {"MatlabInterface","MatlabForm","MatlabFormPolynomials"}]
     
(* Declarations for file ProPac`MEXTools` *)

DeclarePackage["ProPac`MEXTools`",
     {"MEXTools","CreateMEXFile", "CreateModelMEX", "CreateMEX","CreateControllerMEX",
     "FindMostFrequentTerms","SinCosPowerReplaceToo","ReduceFLOPSToo","ReplaceVariablesStr"}]


(* Declarations for file ProPac`Dynamics` *)

DeclarePackage["ProPac`Dynamics`",
     {"Dynamics", "RotationMatrixEuler", "RotationMatrixToEuler","ConfigurationMatrixEuler","AToATilda","ATildaToA",
     "SimpleJointKinematics","CompoundJointKinematics","CompoundJointMap",
     "Joints","JointRotation","JointTranslation","CompoundJointConfiguration","JointConfiguration",
     "TerminalNodeChain","RelativeConfiguration",
     "ChainInertia","EndEffector","NodeVelocity","EndEffectorVelocity","GeneralizedForce","DamperForce","SpringForce",
     "GravPotential","LeafPotential","SpringPotential","DamperPotential","FlxDissPot","FlxStrnPot","RgdBdyInrShift",
     "TreeInertia","KinematicReplacements","CMatrix","CreateModel","CreateModelSpecial","PoincareCoefficients",
     "PoincareFunctionCombined","PoincareFunction","DifferentialConstraints","AlgebraicConstraints","StateTransformation",
     "MakeODEs","GenerateDissipationTerms","RayleighDissipationForce","SeriesExpansion",
     "Truncate","MakeLagrangeEquations"}]
     
(* Declarations for file ProPac`ControlL` *)

DeclarePackage["ProPac`ControlL`",
     {"LinearControl", "AlgebraicRiccatiEquation", "LQR","LQE","DecouplingControl","RelativeDegree","Until","Kernel",
     "RangeSpace","MatrixTrace","MatrixRank","Poles","ControllableRealization","AssociatedHankelMatrix","LaurentSeries",
     "McMillanDegree","ObservableRealization","BlockCompanionMatrix","StateSpaceToTransferFunction","LeastCommonDenominator",
     "PolePlace","ObservablePair","ControllablePair","ObservabilityMatrix","ControllabilityMatrix","Jacobian","TaylorLinearize","RandomMatrix",
     "PoleZeroPlot","RootLocus","Nyquist","ColorNyquist","InverseNyquist","Bode","Zeros","MinimalRealization",
     "KalmanDecomposition","LyapunovEquation"}]

(* Declarations for file ProPac`ControlN` *)

DeclarePackage["ProPac`ControlN`",
     {"NonlinearControl", "AdaptiveBackstepRegulator", "AdaptiveRegulator",
     "AdaptiveTracking","CoefParameter","ControlDistribution",
     "Controllability","DecouplingMatrix","Dist","DynamicExtension","ExponentialObserver",
     "FeedbackLinearizable","FBLCond","HToH1AndH2","HToNAndM","InverseTransformation",
     "IOLinearize","LocalInverseTransformation","LocalZeroDynamics","NormalCoordinates",
     "PartialTransformSystem","PSFFCond","PSFFSolve","RelativeOrder","SIExactFBL",
     "SISONormalFormTrans","StructureAlgorithm","TransformSystem","VectorRelativeOrder",
     "LocalDecomposition","Observability","ObservabilityCodistribution"}]


Print["\n
   This is ProPac - Version 2.0\n
\n
ProPac has been successfully loaded. It contains packages\n
for multibody dynamics, linear control and nonlinear control.\n
Appropriate packages will be loaded automatically as required.\n
Packages can be manually loaded by simply entering GeometricTools,\n
Dynamics, LinearControl, NonlinearControl or MEXTools as desired.\n
Once a package is loaded, enter ?GeomtricTools, ?Dynamics,\n
?LinearControl, ?NonlinearControl, or ?MEXTools, respectively,\n
to obtain a list of available functions. Help is also available\n
in the Help Browser under Add-ons."];

<<ProPac`NDTools`

Null
