
package client;

import common.LeaseFileClassifier;
import common.MIMEType;

import java.rmi.RMISecurityManager;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryEvent;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.core.lease.Lease;

/**
 * TestFileClassifierLease.java
 *
 *
 * Created: Wed Mar 17 14:29:15 1999
 *
 * @author Jan Newmarch
 * @version 1.3
 *    moved sleep() from constructor to main()
 *    moved to package client
 *    simplified Class.forName to Class.class
 */

public class TestFileClassifierLease implements DiscoveryListener {

    public static void main(String argv[]) {
	new TestFileClassifierLease();

        // stay around long enough to receive replies
        try {
            Thread.currentThread().sleep(10000L);
        } catch(java.lang.InterruptedException e) {
            // do nothing
        }
    }

    public TestFileClassifierLease() {
	System.setSecurityManager(new RMISecurityManager());

	LookupDiscovery discover = null;
        try {
            discover = new LookupDiscovery(LookupDiscovery.ALL_GROUPS);
        } catch(Exception e) {
            System.err.println(e.toString());
            System.exit(1);
        }

        discover.addDiscoveryListener(this);

    }
    
    public void discovered(DiscoveryEvent evt) {

        ServiceRegistrar[] registrars = evt.getRegistrars();
	Class [] classes = new Class[] {LeaseFileClassifier.class};
	LeaseFileClassifier classifier = null;
	ServiceTemplate template = new ServiceTemplate(null, classes, 
						       null);
 
        for (int n = 0; n < registrars.length; n++) {
	    System.out.println("Service found");
            ServiceRegistrar registrar = registrars[n];
	    try {
		/*
		Object obj = registrar.lookup(template);
		if (obj == null) {
		    System.out.println("Classifier null");
		    continue;
		}
		Class cls = obj.getClass();
		while (cls != null) {
		    Class[] ifaces = cls.getInterfaces();
		    System.err.println("Class: " + cls.toString());
		    for (int m = 0; m < ifaces.length; m++)
			System.err.println("Interface: " + ifaces[m].toString());
		    cls = cls.getSuperclass();
		} 
		*/
		classifier = (LeaseFileClassifier) registrar.lookup(template);
	    } catch(java.rmi.RemoteException e) {
		e.printStackTrace();
		System.exit(2);
	    }
	    if (classifier == null) {
		System.out.println("Classifier null");
		continue;
	    }
	    MIMEType type;
	    try {
		type = classifier.getMIMEType("file1.txt");
		System.out.println("Type is " + type.toString());
		Lease lease = classifier.addType("ps", new MIMEType("text", "postscript"));
		if (lease != null) {
		    System.out.println("lease for " + (lease.getExpiration() -
						       System.currentTimeMillis()));
		    type = classifier.getMIMEType("file1.ps");
		    System.out.println("Type is " + type.toString());
		} else {
		    System.err.println("was null");
		}
		    
	    } catch(java.rmi.RemoteException e) {
		e.printStackTrace();
	    } catch(net.jini.core.lease.LeaseDeniedException e) {
		e.printStackTrace();
	    }
	    // System.exit(0);
	}
    }

    public void discarded(DiscoveryEvent evt) {
	// empty
    }
} // TestFileClassifierLease






