
package mutable;

import common.MutableFileClassifier;
import common.MIMEType;

import java.io.Serializable;
import java.io.IOException;
import java.rmi.Naming;

import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;

/**
 * FileClassifierProxy
 *
 *
 * Created: Thu Jun 10 1999
 *
 * @author Jan Newmarch
 * @version 1.0
 */

public class FileClassifierProxy implements MutableFileClassifier, Serializable {

    RemoteFileClassifier server = null;

    public FileClassifierProxy(FileClassifierImpl serv) {
	this.server = serv;
	if (serv==null) System.err.println("server is null");
    }

    public MIMEType getMIMEType(String fileName) 
	throws java.rmi.RemoteException {
	return server.getMIMEType(fileName);
    }

    public void addType(String suffix, MIMEType type)
	throws java.rmi.RemoteException {
	server.addType(suffix, type);
    }

    public void removeMIMEType(String suffix, MIMEType type)
	throws java.rmi.RemoteException {
	server.removeMIMEType(suffix, type);
    }

    public EventRegistration addRemoteListener(RemoteEventListener listener)
	throws java.rmi.RemoteException {
	return server.addRemoteListener(listener);
    }


} // FileClassifierProxy
