/**
 * CorbaHelloClient.java
 *
 *
 * Created: Thu Aug 19 22:28:44 1999
 *
 * @author Jan Newmarch
 * @version 1.0
 */
package corba;

import corba.HelloApp.*;
import org.omg.CosNaming.*;
import org.omg.CORBA.*;

public class CorbaHelloClient {
    
    public CorbaHelloClient() {
	
    }
    
    public static void main(String[] args) {
	try {
	    ORB orb = ORB.init(args, null);

	    // find the name server
	    org.omg.CORBA.Object objRef = 
		orb.resolve_initial_references("NameService");
	    NamingContext ncRef = NamingContextHelper.narrow(objRef);

 	    // find the Hello proxy
	    NameComponent nc = new NameComponent("Hello", "");
	    NameComponent path[] = {nc};
	    org.omg.CORBA.Object obj = ncRef.resolve(path);
	    Hello helloRef = HelloHelper.narrow(obj);

	    // now invoke methods on the CORBA proxy
	    String hello = helloRef.sayHello();
	    System.out.println(hello);
	} catch(Exception e) {
	    e.printStackTrace();
	}
    }
    
} // CorbaHelloClient
