// RoomImpl.java
package corba.RoomBookingImpl;

import org.omg.CORBA.*;
import corba.RoomBooking.*;
// import RoomBooking.RoomPackage.*;

public class RoomImpl extends _RoomImplBase {

    private String name;
    private Meeting[] meetings;

    // constructor
    public RoomImpl( String name ) {
        // super(name);
        this.name = name;
        meetings = new Meeting[ MaxSlots.value ];
    }
    
    // attributes
    public String name() {
        return name; 
    }
        
    // operations
    public Meeting[] View() {
        return meetings;
    }

    public void Book( Slot slot,
        Meeting meeting )
        throws SlotAlreadyTaken {
 
        if( meetings[slot.value()] == null ) {
                meetings[slot.value()] = meeting;
        }
        else {
            throw new SlotAlreadyTaken();
        }        
        return;
    }

    public void Cancel( Slot slot )
        throws NoMeetingInThisSlot {

        System.err.println("cancel " + slot );
        if( meetings[slot.value()] != null  ) {
            meetings[slot.value()].destroy();
            meetings[slot.value()] = null;
        }
        else {
            throw new NoMeetingInThisSlot();
        }
    }
}
