/*
 * EventResource
 *
 * a LeasedResource representing RemoteEventListeners managed by the
 * Landlord leading protocol
 *
 * Author: Brian Jeltema
 */

import com.sun.jini.lease.* ;
import com.sun.jini.lease.landlord.* ;
import net.jini.core.event.* ;

public class EventResource implements LeasedResource {

    private static int leaseID = 0 ;

    private int thisID ;
    private Object leaseLock = new Object() ;
    private long expiration ;
    private RemoteEventListener listener ;

    public EventResource(RemoteEventListener l) {
        listener = l ;
	synchronized(leaseLock) {  // in case autoincrement is not atomic
	    thisID = leaseID++ ;  
	}
    }

    public RemoteEventListener getListener() {
        return listener ;
    }

    public Object getCookie() {
	return new Integer(thisID) ;
    }

    public long getExpiration() {
	synchronized(leaseLock) { 
	    return expiration ; 
	}
    }

    public void setExpiration(long newExpiration) {
	synchronized(leaseLock) { 
	    expiration = newExpiration ;
	}
    }
}
