/*
 * LunchServerProxy
 *
 * A simple pass-through proxy to support RMI access to the service
 *
 * Author: Brian Jeltema
 */

import java.rmi.*;
import net.jini.core.event.* ;
import java.io.Serializable ;
import java.util.Hashtable;

public class LunchServerProxy implements LunchCoordinator,Serializable {
    LunchServerInterface server ;

    public LunchServerProxy(LunchServerInterface server) {
        this.server = server ;
    }

    public void registerPref(String name, String food) throws RemoteException {
        System.out.println("RMI registerPref") ;
	server.registerPref(name,food) ;
    }

    public void changePref(String name, String food) throws RemoteException {
        System.out.println("RMI changePref") ;
	server.changePref(name,food) ;
    }

    public Hashtable getLunchers() throws RemoteException {
        System.out.println("RMI getLunchers") ;
	return server.getLunchers() ;
    }

    public void clearServer() throws RemoteException {
        System.out.println("RMI clearServer") ;
	server.clearServer() ;
    }

    public void dump() throws RemoteException {
        System.out.println("RMI dump") ;
	server.dump() ;
    }

    public EventRegistration registerListener(RemoteEventListener l,long duration) throws RemoteException {
        System.out.println("RMI register listener") ;
        return(server.registerListener(l,duration)) ;
    }
}
